/* SPDX-License-Identifier: BSD-2-Clause */

/*
 * Copyright (c) 2017 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef IMX_UARTREG_H
#define IMX_UARTREG_H

#include <bsp/utility.h>

typedef struct {
	uint32_t urxd;
#define IMX_UART_URXD_CHARRDY BSP_BIT32(15)
#define IMX_UART_URXD_ERR BSP_BIT32(14)
#define IMX_UART_URXD_OVRRUN BSP_BIT32(13)
#define IMX_UART_URXD_FRMERR BSP_BIT32(12)
#define IMX_UART_URXD_BRK BSP_BIT32(11)
#define IMX_UART_URXD_PRERR BSP_BIT32(10)
#define IMX_UART_URXD_RX_DATA(val) BSP_FLD32(val, 0, 7)
#define IMX_UART_URXD_RX_DATA_GET(reg) BSP_FLD32GET(reg, 0, 7)
#define IMX_UART_URXD_RX_DATA_SET(reg, val) BSP_FLD32SET(reg, val, 0, 7)
	uint32_t reserved_04[15];
	uint32_t utxd;
#define IMX_UART_UTXD_TX_DATA(val) BSP_FLD32(val, 0, 7)
#define IMX_UART_UTXD_TX_DATA_GET(reg) BSP_FLD32GET(reg, 0, 7)
#define IMX_UART_UTXD_TX_DATA_SET(reg, val) BSP_FLD32SET(reg, val, 0, 7)
	uint32_t reserved_44[15];
	uint32_t ucr1;
#define IMX_UART_UCR1_ADEN BSP_BIT32(15)
#define IMX_UART_UCR1_ADBR BSP_BIT32(14)
#define IMX_UART_UCR1_TRDYEN BSP_BIT32(13)
#define IMX_UART_UCR1_IDEN BSP_BIT32(12)
#define IMX_UART_UCR1_ICD(val) BSP_FLD32(val, 10, 11)
#define IMX_UART_UCR1_ICD_GET(reg) BSP_FLD32GET(reg, 10, 11)
#define IMX_UART_UCR1_ICD_SET(reg, val) BSP_FLD32SET(reg, val, 10, 11)
#define IMX_UART_UCR1_RRDYEN BSP_BIT32(9)
#define IMX_UART_UCR1_RXDMAEN BSP_BIT32(8)
#define IMX_UART_UCR1_IREN BSP_BIT32(7)
#define IMX_UART_UCR1_TXMPTYEN BSP_BIT32(6)
#define IMX_UART_UCR1_RTSDEN BSP_BIT32(5)
#define IMX_UART_UCR1_SNDBRK BSP_BIT32(4)
#define IMX_UART_UCR1_TXDMAEN BSP_BIT32(3)
#define IMX_UART_UCR1_ATDMAEN BSP_BIT32(2)
#define IMX_UART_UCR1_DOZE BSP_BIT32(1)
#define IMX_UART_UCR1_UARTEN BSP_BIT32(0)
	uint32_t ucr2;
#define IMX_UART_UCR2_ESCI BSP_BIT32(15)
#define IMX_UART_UCR2_IRTS BSP_BIT32(14)
#define IMX_UART_UCR2_CTSC BSP_BIT32(13)
#define IMX_UART_UCR2_CTS BSP_BIT32(12)
#define IMX_UART_UCR2_ESCEN BSP_BIT32(11)
#define IMX_UART_UCR2_RTEC(val) BSP_FLD32(val, 9, 10)
#define IMX_UART_UCR2_RTEC_GET(reg) BSP_FLD32GET(reg, 9, 10)
#define IMX_UART_UCR2_RTEC_SET(reg, val) BSP_FLD32SET(reg, val, 9, 10)
#define IMX_UART_UCR2_PREN BSP_BIT32(8)
#define IMX_UART_UCR2_PROE BSP_BIT32(7)
#define IMX_UART_UCR2_STPB BSP_BIT32(6)
#define IMX_UART_UCR2_WS BSP_BIT32(5)
#define IMX_UART_UCR2_RTSEN BSP_BIT32(4)
#define IMX_UART_UCR2_ATEN BSP_BIT32(3)
#define IMX_UART_UCR2_TXEN BSP_BIT32(2)
#define IMX_UART_UCR2_RXEN BSP_BIT32(1)
#define IMX_UART_UCR2_SRST BSP_BIT32(0)
	uint32_t ucr3;
#define IMX_UART_UCR3_DPEC(val) BSP_FLD32(val, 14, 15)
#define IMX_UART_UCR3_DPEC_GET(reg) BSP_FLD32GET(reg, 14, 15)
#define IMX_UART_UCR3_DPEC_SET(reg, val) BSP_FLD32SET(reg, val, 14, 15)
#define IMX_UART_UCR3_DTREN BSP_BIT32(13)
#define IMX_UART_UCR3_PARERREN BSP_BIT32(12)
#define IMX_UART_UCR3_FRAERREN BSP_BIT32(11)
#define IMX_UART_UCR3_DSR BSP_BIT32(10)
#define IMX_UART_UCR3_DCD BSP_BIT32(9)
#define IMX_UART_UCR3_RI BSP_BIT32(8)
#define IMX_UART_UCR3_ADNIMP BSP_BIT32(7)
#define IMX_UART_UCR3_RXDSEN BSP_BIT32(6)
#define IMX_UART_UCR3_AIRINTEN BSP_BIT32(5)
#define IMX_UART_UCR3_AWAKEN BSP_BIT32(4)
#define IMX_UART_UCR3_DTRDEN BSP_BIT32(3)
#define IMX_UART_UCR3_RXDMUXSEL BSP_BIT32(2)
#define IMX_UART_UCR3_INVT BSP_BIT32(1)
#define IMX_UART_UCR3_ACIEN BSP_BIT32(0)
	uint32_t ucr4;
#define IMX_UART_UCR4_CTSTL(val) BSP_FLD32(val, 10, 15)
#define IMX_UART_UCR4_CTSTL_GET(reg) BSP_FLD32GET(reg, 10, 15)
#define IMX_UART_UCR4_CTSTL_SET(reg, val) BSP_FLD32SET(reg, val, 10, 15)
#define IMX_UART_UCR4_INVR BSP_BIT32(9)
#define IMX_UART_UCR4_ENIRI BSP_BIT32(8)
#define IMX_UART_UCR4_WKEN BSP_BIT32(7)
#define IMX_UART_UCR4_IDDMAEN BSP_BIT32(6)
#define IMX_UART_UCR4_IRSC BSP_BIT32(5)
#define IMX_UART_UCR4_LPBYP BSP_BIT32(4)
#define IMX_UART_UCR4_TCEN BSP_BIT32(3)
#define IMX_UART_UCR4_BKEN BSP_BIT32(2)
#define IMX_UART_UCR4_OREN BSP_BIT32(1)
#define IMX_UART_UCR4_DREN BSP_BIT32(0)
	uint32_t ufcr;
#define IMX_UART_UFCR_TXTL(val) BSP_FLD32(val, 10, 15)
#define IMX_UART_UFCR_TXTL_GET(reg) BSP_FLD32GET(reg, 10, 15)
#define IMX_UART_UFCR_TXTL_SET(reg, val) BSP_FLD32SET(reg, val, 10, 15)
#define IMX_UART_UFCR_RFDIV(val) BSP_FLD32(val, 7, 9)
#define IMX_UART_UFCR_RFDIV_GET(reg) BSP_FLD32GET(reg, 7, 9)
#define IMX_UART_UFCR_RFDIV_SET(reg, val) BSP_FLD32SET(reg, val, 7, 9)
#define IMX_UART_UFCR_DCEDTE BSP_BIT32(6)
#define IMX_UART_UFCR_RXTL(val) BSP_FLD32(val, 0, 5)
#define IMX_UART_UFCR_RXTL_GET(reg) BSP_FLD32GET(reg, 0, 5)
#define IMX_UART_UFCR_RXTL_SET(reg, val) BSP_FLD32SET(reg, val, 0, 5)
	uint32_t usr1;
#define IMX_UART_USR1_PARITYERR BSP_BIT32(15)
#define IMX_UART_USR1_RTSS BSP_BIT32(14)
#define IMX_UART_USR1_TRDY BSP_BIT32(13)
#define IMX_UART_USR1_RTSD BSP_BIT32(12)
#define IMX_UART_USR1_ESCF BSP_BIT32(11)
#define IMX_UART_USR1_FRAMERR BSP_BIT32(10)
#define IMX_UART_USR1_RRDY BSP_BIT32(9)
#define IMX_UART_USR1_AGTIM BSP_BIT32(8)
#define IMX_UART_USR1_DTRD BSP_BIT32(7)
#define IMX_UART_USR1_RXDS BSP_BIT32(6)
#define IMX_UART_USR1_AIRINT BSP_BIT32(5)
#define IMX_UART_USR1_AWAKE BSP_BIT32(4)
#define IMX_UART_USR1_SAD BSP_BIT32(3)
	uint32_t usr2;
#define IMX_UART_USR2_ADET BSP_BIT32(15)
#define IMX_UART_USR2_TXFE BSP_BIT32(14)
#define IMX_UART_USR2_DTRF BSP_BIT32(13)
#define IMX_UART_USR2_IDLE BSP_BIT32(12)
#define IMX_UART_USR2_ACST BSP_BIT32(11)
#define IMX_UART_USR2_RIDELT BSP_BIT32(10)
#define IMX_UART_USR2_RIIN BSP_BIT32(9)
#define IMX_UART_USR2_IRINT BSP_BIT32(8)
#define IMX_UART_USR2_WAKE BSP_BIT32(7)
#define IMX_UART_USR2_DCDDELT BSP_BIT32(6)
#define IMX_UART_USR2_DCDIN BSP_BIT32(5)
#define IMX_UART_USR2_RTSF BSP_BIT32(4)
#define IMX_UART_USR2_TXDC BSP_BIT32(3)
#define IMX_UART_USR2_BRCD BSP_BIT32(2)
#define IMX_UART_USR2_ORE BSP_BIT32(1)
#define IMX_UART_USR2_RDR BSP_BIT32(0)
	uint32_t uesc;
	uint32_t utim;
	uint32_t ubir;
	uint32_t ubmr;
	uint32_t ubrc;
	uint32_t onems;
	uint32_t uts;
#define IMX_UART_UTS_FRCPERR BSP_BIT32(13)
#define IMX_UART_UTS_LOOP BSP_BIT32(12)
#define IMX_UART_UTS_DBGEN BSP_BIT32(11)
#define IMX_UART_UTS_LOOPIR BSP_BIT32(10)
#define IMX_UART_UTS_RXDBG BSP_BIT32(9)
#define IMX_UART_UTS_TXEMPTY BSP_BIT32(6)
#define IMX_UART_UTS_RXEMPTY BSP_BIT32(5)
#define IMX_UART_UTS_TXFULL BSP_BIT32(4)
#define IMX_UART_UTS_RXFULL BSP_BIT32(3)
#define IMX_UART_UTS_SOFTRST BSP_BIT32(0)
	uint32_t umcr;
#define IMX_UART_UMCR_SLADDR(val) BSP_FLD32(val, 8, 15)
#define IMX_UART_UMCR_SLADDR_GET(reg) BSP_FLD32GET(reg, 8, 15)
#define IMX_UART_UMCR_SLADDR_SET(reg, val) BSP_FLD32SET(reg, val, 8, 15)
#define IMX_UART_UMCR_SADEN BSP_BIT32(3)
#define IMX_UART_UMCR_TXB8 BSP_BIT32(2)
#define IMX_UART_UMCR_SLAM BSP_BIT32(1)
#define IMX_UART_UMCR_MDEN BSP_BIT32(0)
} imx_uart;

#endif /* IMX_UARTREG_H */
