/*
 * QEMU model of the PCIE_ATTRIB Register block that holds the attributes
 * of the PCIe Controller
 *
 * Copyright (c) 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-03-17.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_PCIE_ATTRIB_ERR_DEBUG
#define XILINX_PCIE_ATTRIB_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PCIE_ATTRIB "xlnx.nwl-pcie-attrib"

#define XILINX_PCIE_ATTRIB(obj) \
     OBJECT_CHECK(PCIE_ATTRIB, (obj), TYPE_XILINX_PCIE_ATTRIB)

REG32(ATTR_0, 0x0)
    FIELD(ATTR_0, ATTR_AER_CAP_ECRC_GEN_CAPABLE, 1, 1)
    FIELD(ATTR_0, ATTR_AER_CAP_ECRC_CHECK_CAPABLE, 0, 1)
REG32(ATTR_1, 0x4)
    FIELD(ATTR_1, ATTR_AER_CAP_ID, 0, 16)
REG32(ATTR_2, 0x8)
    FIELD(ATTR_2, ATTR_AER_CAP_VERSION, 1, 4)
    FIELD(ATTR_2, ATTR_AER_CAP_PERMIT_ROOTERR_UPDATE, 0, 1)
REG32(ATTR_3, 0xc)
    FIELD(ATTR_3, ATTR_AER_BASE_PTR, 0, 12)
REG32(ATTR_4, 0x10)
    FIELD(ATTR_4, ATTR_AER_CAP_ON, 12, 1)
    FIELD(ATTR_4, ATTR_AER_CAP_NEXTPTR, 0, 12)
REG32(ATTR_5, 0x14)
    FIELD(ATTR_5, ATTR_AER_CAP_OPTIONAL_ERR_SUPPORT, 0, 16)
REG32(ATTR_6, 0x18)
    FIELD(ATTR_6, ATTR_AER_CAP_MULTIHEADER, 8, 1)
    FIELD(ATTR_6, ATTR_AER_CAP_OPTIONAL_ERR_SUPPORT, 0, 8)
REG32(ATTR_7, 0x1c)
    FIELD(ATTR_7, ATTR_BAR0, 0, 16)
REG32(ATTR_8, 0x20)
    FIELD(ATTR_8, ATTR_BAR0, 0, 16)
REG32(ATTR_9, 0x24)
    FIELD(ATTR_9, ATTR_BAR1, 0, 16)
REG32(ATTR_10, 0x28)
    FIELD(ATTR_10, ATTR_BAR1, 0, 16)
REG32(ATTR_11, 0x2c)
    FIELD(ATTR_11, ATTR_BAR2, 0, 16)
REG32(ATTR_12, 0x30)
    FIELD(ATTR_12, ATTR_BAR2, 0, 16)
REG32(ATTR_13, 0x34)
    FIELD(ATTR_13, ATTR_BAR3, 0, 16)
REG32(ATTR_14, 0x38)
    FIELD(ATTR_14, ATTR_BAR3, 0, 16)
REG32(ATTR_15, 0x3c)
    FIELD(ATTR_15, ATTR_BAR4, 0, 16)
REG32(ATTR_16, 0x40)
    FIELD(ATTR_16, ATTR_BAR4, 0, 16)
REG32(ATTR_17, 0x44)
    FIELD(ATTR_17, ATTR_BAR5, 0, 16)
REG32(ATTR_18, 0x48)
    FIELD(ATTR_18, ATTR_BAR5, 0, 16)
REG32(ATTR_19, 0x4c)
    FIELD(ATTR_19, ATTR_EXPANSION_ROM, 0, 16)
REG32(ATTR_20, 0x50)
    FIELD(ATTR_20, ATTR_EXPANSION_ROM, 0, 16)
REG32(ATTR_21, 0x54)
    FIELD(ATTR_21, ATTR_CAPABILITIES_PTR, 0, 8)
REG32(ATTR_22, 0x58)
    FIELD(ATTR_22, ATTR_CARDBUS_CIS_POINTER, 0, 16)
REG32(ATTR_23, 0x5c)
    FIELD(ATTR_23, ATTR_CARDBUS_CIS_POINTER, 0, 16)
REG32(ATTR_24, 0x60)
    FIELD(ATTR_24, ATTR_CLASS_CODE, 0, 16)
REG32(ATTR_25, 0x64)
    FIELD(ATTR_25, ATTR_DEV_CAP2_ATOMICOP_ROUTING_SUPPORTED, 15, 1)
    FIELD(ATTR_25, ATTR_DEV_CAP2_ARI_FORWARDING_SUPPORTED, 14, 1)
    FIELD(ATTR_25, ATTR_CPL_TIMEOUT_RANGES_SUPPORTED, 10, 4)
    FIELD(ATTR_25, ATTR_CPL_TIMEOUT_DISABLE_SUPPORTED, 9, 1)
    FIELD(ATTR_25, ATTR_CMD_INTX_IMPLEMENTED, 8, 1)
    FIELD(ATTR_25, ATTR_CLASS_CODE, 0, 8)
REG32(ATTR_26, 0x68)
    FIELD(ATTR_26, ATTR_DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE, 13, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE, 12, 1)
    FIELD(ATTR_26, ATTR_ENDEND_TLP_PREFIX_FORWARDING_SUPPORTED, 11, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_MAX_ENDEND_TLP_PREFIXES, 9, 2)
    FIELD(ATTR_26, ATTR_DEV_CAP2_ENDEND_TLP_PREFIX_SUPPORTED, 8, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_EXTENDED_FMT_FIELD_SUPPORTED, 7, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_TPH_COMPLETER_SUPPORTED, 5, 2)
    FIELD(ATTR_26, ATTR_DEV_CAP2_LTR_MECHANISM_SUPPORTED, 4, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_NO_RO_ENABLED_PRPR_PASSING, 3, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_CAS128_COMPLETER_SUPPORTED, 2, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_ATOMICOP64_COMPLETER_SUPPORTED, 1, 1)
    FIELD(ATTR_26, ATTR_DEV_CAP2_ATOMICOP32_COMPLETER_SUPPORTED, 0, 1)
REG32(ATTR_27, 0x6c)
    FIELD(ATTR_27, ATTR_DEV_CAP_ROLE_BASED_ERROR, 13, 1)
    FIELD(ATTR_27, ATTR_DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT, 11, 2)
    FIELD(ATTR_27, ATTR_DEV_CAP_MAX_PAYLOAD_SUPPORTED, 8, 3)
    FIELD(ATTR_27, ATTR_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE, 7, 1)
    FIELD(ATTR_27, ATTR_DEV_CAP_EXT_TAG_SUPPORTED, 6, 1)
    FIELD(ATTR_27, ATTR_DEV_CAP_ENDPOINT_L1_LATENCY, 3, 3)
    FIELD(ATTR_27, ATTR_DEV_CAP_ENDPOINT_L0S_LATENCY, 0, 3)
REG32(ATTR_28, 0x70)
    FIELD(ATTR_28, ATTR_DEV_CONTROL_EXT_TAG_DEFAULT, 9, 1)
    FIELD(ATTR_28, ATTR_DEV_CONTROL_AUX_POWER_SUPPORTED, 8, 1)
    FIELD(ATTR_28, ATTR_DEV_CAP_RSVD_31_29, 5, 3)
    FIELD(ATTR_28, ATTR_DEV_CAP_RSVD_17_16, 3, 2)
    FIELD(ATTR_28, ATTR_DEV_CAP_RSVD_14_12, 0, 3)
REG32(ATTR_29, 0x74)
    FIELD(ATTR_29, ATTR_DSN_BASE_PTR, 0, 12)
REG32(ATTR_30, 0x78)
    FIELD(ATTR_30, ATTR_DSN_CAP_ID, 0, 16)
REG32(ATTR_31, 0x7c)
    FIELD(ATTR_31, ATTR_DSN_CAP_ON, 12, 1)
    FIELD(ATTR_31, ATTR_DSN_CAP_NEXTPTR, 0, 12)
REG32(ATTR_32, 0x80)
    FIELD(ATTR_32, ATTR_EXT_CFG_CAP_PTR, 4, 6)
    FIELD(ATTR_32, ATTR_DSN_CAP_VERSION, 0, 4)
REG32(ATTR_33, 0x84)
    FIELD(ATTR_33, ATTR_EXT_CFG_XP_CAP_PTR, 0, 10)
REG32(ATTR_34, 0x88)
    FIELD(ATTR_34, ATTR_INTERRUPT_PIN, 8, 8)
    FIELD(ATTR_34, ATTR_HEADER_TYPE, 0, 8)
REG32(ATTR_35, 0x8c)
    FIELD(ATTR_35, ATTR_LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP, 15, 1)
    FIELD(ATTR_35, ATTR_LINK_CAP_CLOCK_POWER_MANAGEMENT, 14, 1)
    FIELD(ATTR_35, ATTR_LINK_CAP_ASPM_SUPPORT, 12, 2)
    FIELD(ATTR_35, ATTR_LAST_CONFIG_DWORD, 2, 10)
    FIELD(ATTR_35, ATTR_IS_SWITCH, 1, 1)
    FIELD(ATTR_35, ATTR_INTERRUPT_STAT_AUTO, 0, 1)
REG32(ATTR_36, 0x90)
    FIELD(ATTR_36, ATTR_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1, 12, 3)
    FIELD(ATTR_36, ATTR_LINK_CAP_L0S_EXIT_LATENCY_GEN2, 9, 3)
    FIELD(ATTR_36, ATTR_LINK_CAP_L0S_EXIT_LATENCY_GEN1, 6, 3)
    FIELD(ATTR_36, ATTR_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2, 3, 3)
    FIELD(ATTR_36, ATTR_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1, 0, 3)
REG32(ATTR_37, 0x94)
    FIELD(ATTR_37, ATTR_LINK_CAP_RSVD_23, 15, 1)
    FIELD(ATTR_37, ATTR_LINK_CAP_ASPM_OPTIONALITY, 14, 1)
    FIELD(ATTR_37, ATTR_LINK_CAP_MAX_LINK_SPEED, 10, 4)
    FIELD(ATTR_37, ATTR_LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP, 9, 1)
    FIELD(ATTR_37, ATTR_LINK_CAP_L1_EXIT_LATENCY_GEN2, 6, 3)
    FIELD(ATTR_37, ATTR_LINK_CAP_L1_EXIT_LATENCY_GEN1, 3, 3)
    FIELD(ATTR_37, ATTR_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2, 0, 3)
REG32(ATTR_38, 0x98)
    FIELD(ATTR_38, ATTR_MPS_FORCE, 9, 1)
    FIELD(ATTR_38, ATTR_LINK_STATUS_SLOT_CLOCK_CONFIG, 8, 1)
    FIELD(ATTR_38, ATTR_LINK_CTRL2_TARGET_LINK_SPEED, 4, 4)
    FIELD(ATTR_38, ATTR_LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE, 3, 1)
    FIELD(ATTR_38, ATTR_LINK_CTRL2_DEEMPHASIS, 2, 1)
    FIELD(ATTR_38, ATTR_LINK_CONTROL_RCB, 1, 1)
    FIELD(ATTR_38, ATTR_LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE, 0, 1)
REG32(ATTR_39, 0x9c)
    FIELD(ATTR_39, ATTR_MSI_CAP_64_BIT_ADDR_CAPABLE, 8, 1)
    FIELD(ATTR_39, ATTR_MSI_BASE_PTR, 0, 8)
REG32(ATTR_40, 0xa0)
    FIELD(ATTR_40, ATTR_MSI_CAP_MULTIMSGCAP, 9, 3)
    FIELD(ATTR_40, ATTR_MSI_CAP_MULTIMSG_EXTENSION, 8, 1)
    FIELD(ATTR_40, ATTR_MSI_CAP_ID, 0, 8)
REG32(ATTR_41, 0xa4)
    FIELD(ATTR_41, ATTR_MSI_CAP_PER_VECTOR_MASKING_CAPABLE, 9, 1)
    FIELD(ATTR_41, ATTR_MSI_CAP_ON, 8, 1)
    FIELD(ATTR_41, ATTR_MSI_CAP_NEXTPTR, 0, 8)
REG32(ATTR_42, 0xa8)
    FIELD(ATTR_42, ATTR_MSIX_CAP_ID, 8, 8)
    FIELD(ATTR_42, ATTR_MSIX_BASE_PTR, 0, 8)
REG32(ATTR_43, 0xac)
    FIELD(ATTR_43, ATTR_MSIX_CAP_PBA_BIR, 9, 3)
    FIELD(ATTR_43, ATTR_MSIX_CAP_ON, 8, 1)
    FIELD(ATTR_43, ATTR_MSIX_CAP_NEXTPTR, 0, 8)
REG32(ATTR_44, 0xb0)
    FIELD(ATTR_44, ATTR_MSIX_CAP_PBA_OFFSET, 0, 16)
REG32(ATTR_45, 0xb4)
    FIELD(ATTR_45, ATTR_MSIX_CAP_PBA_OFFSET, 3, 13)
    FIELD(ATTR_45, ATTR_MSIX_CAP_TABLE_BIR, 0, 3)
REG32(ATTR_46, 0xb8)
    FIELD(ATTR_46, ATTR_MSIX_CAP_TABLE_OFFSET, 0, 16)
REG32(ATTR_47, 0xbc)
    FIELD(ATTR_47, ATTR_MSIX_CAP_TABLE_OFFSET, 0, 13)
REG32(ATTR_48, 0xc0)
    FIELD(ATTR_48, ATTR_MSIX_CAP_TABLE_SIZE, 0, 11)
REG32(ATTR_49, 0xc4)
    FIELD(ATTR_49, ATTR_PCIE_CAP_CAPABILITY_ID, 8, 8)
    FIELD(ATTR_49, ATTR_PCIE_BASE_PTR, 0, 8)
REG32(ATTR_50, 0xc8)
    FIELD(ATTR_50, ATTR_PCIE_CAP_NEXTPTR, 8, 8)
    FIELD(ATTR_50, ATTR_PCIE_CAP_DEVICE_PORT_TYPE, 4, 4)
    FIELD(ATTR_50, ATTR_PCIE_CAP_CAPABILITY_VERSION, 0, 4)
REG32(ATTR_51, 0xcc)
    FIELD(ATTR_51, ATTR_PM_BASE_PTR, 8, 8)
    FIELD(ATTR_51, ATTR_PCIE_REVISION, 4, 4)
    FIELD(ATTR_51, ATTR_PCIE_CAP_SLOT_IMPLEMENTED, 3, 1)
    FIELD(ATTR_51, ATTR_PCIE_CAP_RSVD_15_14, 1, 2)
    FIELD(ATTR_51, ATTR_PCIE_CAP_ON, 0, 1)
REG32(ATTR_52, 0xd0)
    FIELD(ATTR_52, ATTR_PM_CAP_ID, 6, 8)
    FIELD(ATTR_52, ATTR_PM_CAP_DSI, 5, 1)
    FIELD(ATTR_52, ATTR_PM_CAP_D2SUPPORT, 4, 1)
    FIELD(ATTR_52, ATTR_PM_CAP_D1SUPPORT, 3, 1)
    FIELD(ATTR_52, ATTR_PM_CAP_AUXCURRENT, 0, 3)
REG32(ATTR_53, 0xd4)
    FIELD(ATTR_53, ATTR_PM_CAP_RSVD_04, 15, 1)
    FIELD(ATTR_53, ATTR_PM_CAP_PMESUPPORT, 10, 5)
    FIELD(ATTR_53, ATTR_PM_CAP_PME_CLOCK, 9, 1)
    FIELD(ATTR_53, ATTR_PM_CAP_ON, 8, 1)
    FIELD(ATTR_53, ATTR_PM_CAP_NEXTPTR, 0, 8)
REG32(ATTR_54, 0xd8)
    FIELD(ATTR_54, ATTR_PM_DATA_SCALE4, 14, 2)
    FIELD(ATTR_54, ATTR_PM_DATA_SCALE3, 12, 2)
    FIELD(ATTR_54, ATTR_PM_DATA_SCALE2, 10, 2)
    FIELD(ATTR_54, ATTR_PM_DATA_SCALE1, 8, 2)
    FIELD(ATTR_54, ATTR_PM_DATA_SCALE0, 6, 2)
    FIELD(ATTR_54, ATTR_PM_CSR_NOSOFTRST, 5, 1)
    FIELD(ATTR_54, ATTR_PM_CSR_BPCCEN, 4, 1)
    FIELD(ATTR_54, ATTR_PM_CSR_B2B3, 3, 1)
    FIELD(ATTR_54, ATTR_PM_CAP_VERSION, 0, 3)
REG32(ATTR_55, 0xdc)
    FIELD(ATTR_55, ATTR_PM_DATA0, 6, 8)
    FIELD(ATTR_55, ATTR_PM_DATA_SCALE7, 4, 2)
    FIELD(ATTR_55, ATTR_PM_DATA_SCALE6, 2, 2)
    FIELD(ATTR_55, ATTR_PM_DATA_SCALE5, 0, 2)
REG32(ATTR_56, 0xe0)
    FIELD(ATTR_56, ATTR_PM_DATA2, 8, 8)
    FIELD(ATTR_56, ATTR_PM_DATA1, 0, 8)
REG32(ATTR_57, 0xe4)
    FIELD(ATTR_57, ATTR_PM_DATA4, 8, 8)
    FIELD(ATTR_57, ATTR_PM_DATA3, 0, 8)
REG32(ATTR_58, 0xe8)
    FIELD(ATTR_58, ATTR_PM_DATA6, 8, 8)
    FIELD(ATTR_58, ATTR_PM_DATA5, 0, 8)
REG32(ATTR_59, 0xec)
    FIELD(ATTR_59, ATTR_PM_DATA7, 0, 8)
REG32(ATTR_60, 0xf0)
    FIELD(ATTR_60, ATTR_RBAR_BASE_PTR, 0, 12)
REG32(ATTR_61, 0xf4)
    FIELD(ATTR_61, ATTR_RBAR_CAP_ON, 12, 1)
    FIELD(ATTR_61, ATTR_RBAR_CAP_NEXTPTR, 0, 12)
REG32(ATTR_62, 0xf8)
    FIELD(ATTR_62, ATTR_RBAR_CAP_ID, 0, 16)
REG32(ATTR_63, 0xfc)
    FIELD(ATTR_63, ATTR_RBAR_NUM, 4, 3)
    FIELD(ATTR_63, ATTR_RBAR_CAP_VERSION, 0, 4)
REG32(ATTR_64, 0x100)
    FIELD(ATTR_64, ATTR_RBAR_CAP_SUP0, 0, 16)
REG32(ATTR_65, 0x104)
    FIELD(ATTR_65, ATTR_RBAR_CAP_SUP0, 0, 16)
REG32(ATTR_66, 0x108)
    FIELD(ATTR_66, ATTR_RBAR_CAP_SUP1, 0, 16)
REG32(ATTR_67, 0x10c)
    FIELD(ATTR_67, ATTR_RBAR_CAP_SUP1, 0, 16)
REG32(ATTR_68, 0x110)
    FIELD(ATTR_68, ATTR_RBAR_CAP_SUP2, 0, 16)
REG32(ATTR_69, 0x114)
    FIELD(ATTR_69, ATTR_RBAR_CAP_SUP2, 0, 16)
REG32(ATTR_70, 0x118)
    FIELD(ATTR_70, ATTR_RBAR_CAP_SUP3, 0, 16)
REG32(ATTR_71, 0x11c)
    FIELD(ATTR_71, ATTR_RBAR_CAP_SUP3, 0, 16)
REG32(ATTR_72, 0x120)
    FIELD(ATTR_72, ATTR_RBAR_CAP_SUP4, 0, 16)
REG32(ATTR_73, 0x124)
    FIELD(ATTR_73, ATTR_RBAR_CAP_SUP4, 0, 16)
REG32(ATTR_74, 0x128)
    FIELD(ATTR_74, ATTR_RBAR_CAP_SUP5, 0, 16)
REG32(ATTR_75, 0x12c)
    FIELD(ATTR_75, ATTR_RBAR_CAP_SUP5, 0, 16)
REG32(ATTR_76, 0x130)
    FIELD(ATTR_76, ATTR_RBAR_CAP_INDEX4, 12, 3)
    FIELD(ATTR_76, ATTR_RBAR_CAP_INDEX3, 9, 3)
    FIELD(ATTR_76, ATTR_RBAR_CAP_INDEX2, 6, 3)
    FIELD(ATTR_76, ATTR_RBAR_CAP_INDEX1, 3, 3)
    FIELD(ATTR_76, ATTR_RBAR_CAP_INDEX0, 0, 3)
REG32(ATTR_77, 0x134)
    FIELD(ATTR_77, ATTR_RBAR_CAP_CONTROL_ENCODEDBAR1, 8, 5)
    FIELD(ATTR_77, ATTR_RBAR_CAP_CONTROL_ENCODEDBAR0, 3, 5)
    FIELD(ATTR_77, ATTR_RBAR_CAP_INDEX5, 0, 3)
REG32(ATTR_78, 0x138)
    FIELD(ATTR_78, ATTR_RBAR_CAP_CONTROL_ENCODEDBAR4, 10, 5)
    FIELD(ATTR_78, ATTR_RBAR_CAP_CONTROL_ENCODEDBAR3, 5, 5)
    FIELD(ATTR_78, ATTR_RBAR_CAP_CONTROL_ENCODEDBAR2, 0, 5)
REG32(ATTR_79, 0x13c)
    FIELD(ATTR_79, ATTR_SLOT_CAP_NO_CMD_COMPLETED_SUPPORT, 13, 1)
    FIELD(ATTR_79, ATTR_SLOT_CAP_MRL_SENSOR_PRESENT, 12, 1)
    FIELD(ATTR_79, ATTR_SLOT_CAP_HOTPLUG_SURPRISE, 11, 1)
    FIELD(ATTR_79, ATTR_SLOT_CAP_HOTPLUG_CAPABLE, 10, 1)
    FIELD(ATTR_79, ATTR_SLOT_CAP_ELEC_INTERLOCK_PRESENT, 9, 1)
    FIELD(ATTR_79, ATTR_SLOT_CAP_ATT_INDICATOR_PRESENT, 8, 1)
    FIELD(ATTR_79, ATTR_SLOT_CAP_ATT_BUTTON_PRESENT, 7, 1)
    FIELD(ATTR_79, ATTR_SELECT_DLL_IF, 6, 1)
    FIELD(ATTR_79, ATTR_ROOT_CAP_CRS_SW_VISIBILITY, 5, 1)
    FIELD(ATTR_79, ATTR_RBAR_CAP_CONTROL_ENCODEDBAR5, 0, 5)
REG32(ATTR_80, 0x140)
    FIELD(ATTR_80, ATTR_SLOT_CAP_POWER_INDICATOR_PRESENT, 14, 1)
    FIELD(ATTR_80, ATTR_SLOT_CAP_POWER_CONTROLLER_PRESENT, 13, 1)
    FIELD(ATTR_80, ATTR_SLOT_CAP_PHYSICAL_SLOT_NUM, 0, 13)
REG32(ATTR_81, 0x144)
    FIELD(ATTR_81, ATTR_SSL_MESSAGE_AUTO, 10, 1)
    FIELD(ATTR_81, ATTR_SLOT_CAP_SLOT_POWER_LIMIT_VALUE, 2, 8)
    FIELD(ATTR_81, ATTR_SLOT_CAP_SLOT_POWER_LIMIT_SCALE, 0, 2)
REG32(ATTR_82, 0x148)
    FIELD(ATTR_82, ATTR_VC_BASE_PTR, 0, 12)
REG32(ATTR_83, 0x14c)
    FIELD(ATTR_83, ATTR_VC_CAP_ON, 12, 1)
    FIELD(ATTR_83, ATTR_VC_CAP_NEXTPTR, 0, 12)
REG32(ATTR_84, 0x150)
    FIELD(ATTR_84, ATTR_VC_CAP_ID, 0, 16)
REG32(ATTR_85, 0x154)
    FIELD(ATTR_85, ATTR_VSEC_BASE_PTR, 1, 12)
    FIELD(ATTR_85, ATTR_VC_CAP_REJECT_SNOOP_TRANSACTIONS, 0, 1)
REG32(ATTR_86, 0x158)
    FIELD(ATTR_86, ATTR_VSEC_CAP_HDR_ID, 0, 16)
REG32(ATTR_87, 0x15c)
    FIELD(ATTR_87, ATTR_VSEC_CAP_HDR_REVISION, 12, 4)
    FIELD(ATTR_87, ATTR_VSEC_CAP_HDR_LENGTH, 0, 12)
REG32(ATTR_88, 0x160)
    FIELD(ATTR_88, ATTR_VSEC_CAP_ID, 0, 16)
REG32(ATTR_89, 0x164)
    FIELD(ATTR_89, ATTR_VSEC_CAP_ON, 13, 1)
    FIELD(ATTR_89, ATTR_VSEC_CAP_NEXTPTR, 1, 12)
    FIELD(ATTR_89, ATTR_VSEC_CAP_IS_LINK_VISIBLE, 0, 1)
REG32(ATTR_90, 0x168)
    FIELD(ATTR_90, ATTR_CRM_MODULE_RSTS, 7, 7)
    FIELD(ATTR_90, ATTR_USER_CLK_FREQ, 4, 3)
    FIELD(ATTR_90, ATTR_VSEC_CAP_VERSION, 0, 4)
REG32(ATTR_91, 0x16c)
    FIELD(ATTR_91, ATTR_LL_ACK_TIMEOUT_EN, 15, 1)
    FIELD(ATTR_91, ATTR_LL_ACK_TIMEOUT, 0, 15)
REG32(ATTR_92, 0x170)
    FIELD(ATTR_92, ATTR_LL_ACK_TIMEOUT_FUNC, 0, 2)
REG32(ATTR_93, 0x174)
    FIELD(ATTR_93, ATTR_LL_REPLAY_TIMEOUT_EN, 15, 1)
    FIELD(ATTR_93, ATTR_LL_REPLAY_TIMEOUT, 0, 15)
REG32(ATTR_94, 0x178)
    FIELD(ATTR_94, ATTR_LL_REPLAY_TIMEOUT_FUNC, 0, 2)
REG32(ATTR_95, 0x17c)
    FIELD(ATTR_95, ATTR_PM_ASPML0S_TIMEOUT_EN, 15, 1)
    FIELD(ATTR_95, ATTR_PM_ASPML0S_TIMEOUT, 0, 15)
REG32(ATTR_96, 0x180)
    FIELD(ATTR_96, ATTR_INFER_EI, 6, 5)
    FIELD(ATTR_96, ATTR_ENTER_RVRY_EI_L0, 5, 1)
    FIELD(ATTR_96, ATTR_DISABLE_SCRAMBLING, 4, 1)
    FIELD(ATTR_96, ATTR_DISABLE_LANE_REVERSAL, 3, 1)
    FIELD(ATTR_96, ATTR_PM_ASPM_FASTEXIT, 2, 1)
    FIELD(ATTR_96, ATTR_PM_ASPML0S_TIMEOUT_FUNC, 0, 2)
REG32(ATTR_97, 0x184)
    FIELD(ATTR_97, ATTR_LTSSM_MAX_LINK_WIDTH, 6, 6)
    FIELD(ATTR_97, ATTR_LINK_CAP_MAX_LINK_WIDTH, 0, 6)
REG32(ATTR_98, 0x188)
    FIELD(ATTR_98, ATTR_N_FTS_COMCLK_GEN2, 8, 8)
    FIELD(ATTR_98, ATTR_N_FTS_COMCLK_GEN1, 0, 8)
REG32(ATTR_99, 0x18c)
    FIELD(ATTR_99, ATTR_N_FTS_GEN2, 8, 8)
    FIELD(ATTR_99, ATTR_N_FTS_GEN1, 0, 8)
REG32(ATTR_100, 0x190)
    FIELD(ATTR_100, ATTR_DNSTREAM_LINK_NUM, 8, 8)
    FIELD(ATTR_100, ATTR_EXIT_LOOPBACK_ON_EI, 7, 1)
    FIELD(ATTR_100, ATTR_UPSTREAM_FACING, 6, 1)
    FIELD(ATTR_100, ATTR_UPCONFIG_CAPABLE, 5, 1)
    FIELD(ATTR_100, ATTR_PL_FAST_TRAIN, 4, 1)
    FIELD(ATTR_100, ATTR_PL_AUTO_CONFIG, 1, 3)
    FIELD(ATTR_100, ATTR_ALLOW_X8_GEN2, 0, 1)
REG32(ATTR_101, 0x194)
    FIELD(ATTR_101, ATTR_ENABLE_MSG_ROUTE, 5, 11)
    FIELD(ATTR_101, ATTR_DISABLE_RX_POISONED_RESP, 4, 1)
    FIELD(ATTR_101, ATTR_DISABLE_RX_TC_FILTER, 3, 1)
    FIELD(ATTR_101, ATTR_DISABLE_ID_CHECK, 2, 1)
    FIELD(ATTR_101, ATTR_DISABLE_BAR_FILTERING, 1, 1)
    FIELD(ATTR_101, ATTR_DISABLE_ASPM_L1_TIMER, 0, 1)
REG32(ATTR_102, 0x198)
    FIELD(ATTR_102, ATTR_TL_TX_RAM_RDATA_LATENCY, 14, 2)
    FIELD(ATTR_102, ATTR_TL_TX_RAM_RADDR_LATENCY, 13, 1)
    FIELD(ATTR_102, ATTR_PM_MF, 12, 1)
    FIELD(ATTR_102, ATTR_DISABLE_ERR_MSG, 11, 1)
    FIELD(ATTR_102, ATTR_USE_RID_PINS, 10, 1)
    FIELD(ATTR_102, ATTR_DISABLE_LOCKED_FILTER, 9, 1)
    FIELD(ATTR_102, ATTR_DISABLE_PPM_FILTER, 8, 1)
    FIELD(ATTR_102, ATTR_TL_RBYPASS, 7, 1)
    FIELD(ATTR_102, ATTR_TL_TX_CHECKS_DISABLE, 6, 1)
    FIELD(ATTR_102, ATTR_TL_TFC_DISABLE, 5, 1)
    FIELD(ATTR_102, ATTR_TL_RX_RAM_WRITE_LATENCY, 4, 1)
    FIELD(ATTR_102, ATTR_TL_RX_RAM_RDATA_LATENCY, 2, 2)
    FIELD(ATTR_102, ATTR_TL_RX_RAM_RADDR_LATENCY, 1, 1)
    FIELD(ATTR_102, ATTR_ENABLE_RX_TD_ECRC_TRIM, 0, 1)
REG32(ATTR_103, 0x19c)
    FIELD(ATTR_103, ATTR_VC0_CPL_INFINITE, 5, 1)
    FIELD(ATTR_103, ATTR_VC_CAP_VERSION, 1, 4)
    FIELD(ATTR_103, ATTR_TL_TX_RAM_WRITE_LATENCY, 0, 1)
REG32(ATTR_104, 0x1a0)
    FIELD(ATTR_104, ATTR_VC0_RX_RAM_LIMIT, 0, 13)
REG32(ATTR_105, 0x1a4)
    FIELD(ATTR_105, ATTR_VC0_TOTAL_CREDITS_CD, 0, 11)
REG32(ATTR_106, 0x1a8)
    FIELD(ATTR_106, ATTR_VC0_TOTAL_CREDITS_NPH, 7, 7)
    FIELD(ATTR_106, ATTR_VC0_TOTAL_CREDITS_CH, 0, 7)
REG32(ATTR_107, 0x1ac)
    FIELD(ATTR_107, ATTR_VC0_TOTAL_CREDITS_NPD, 0, 11)
REG32(ATTR_108, 0x1b0)
    FIELD(ATTR_108, ATTR_VC0_TOTAL_CREDITS_PD, 0, 11)
REG32(ATTR_109, 0x1b4)
    FIELD(ATTR_109, ATTR_TECRC_EP_INV, 15, 1)
    FIELD(ATTR_109, ATTR_RECRC_CHK_TRIM, 14, 1)
    FIELD(ATTR_109, ATTR_RECRC_CHK, 12, 2)
    FIELD(ATTR_109, ATTR_VC0_TX_LASTPACKET, 7, 5)
    FIELD(ATTR_109, ATTR_VC0_TOTAL_CREDITS_PH, 0, 7)
REG32(ATTR_110, 0x1b8)
    FIELD(ATTR_110, ATTR_RP_AUTO_SPD_LOOPCNT, 11, 5)
    FIELD(ATTR_110, ATTR_RP_AUTO_SPD, 9, 2)
    FIELD(ATTR_110, ATTR_USER_CLK2_DIV2, 8, 1)
    FIELD(ATTR_110, ATTR_TRN_NP_FC, 7, 1)
    FIELD(ATTR_110, ATTR_TRN_DW, 6, 1)
    FIELD(ATTR_110, ATTR_UR_CFG1, 5, 1)
    FIELD(ATTR_110, ATTR_UR_ATOMIC, 4, 1)
    FIELD(ATTR_110, ATTR_UR_PRS_RESPONSE, 3, 1)
    FIELD(ATTR_110, ATTR_UR_INV_REQ, 2, 1)
    FIELD(ATTR_110, ATTR_CFG_ECRC_ERR_CPLSTAT, 0, 2)
REG32(ATTR_111, 0x1bc)
    FIELD(ATTR_111, ATTR_SPARE_BIT8, 9, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT7, 8, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT6, 7, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT5, 6, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT4, 5, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT3, 4, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT2, 3, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT1, 2, 1)
    FIELD(ATTR_111, ATTR_SPARE_BIT0, 1, 1)
    FIELD(ATTR_111, ATTR_TEST_MODE_PIN_CHAR, 0, 1)
REG32(ATTR_112, 0x1c0)
    FIELD(ATTR_112, ATTR_SPARE_BYTE1, 8, 8)
    FIELD(ATTR_112, ATTR_SPARE_BYTE0, 0, 8)
REG32(ATTR_113, 0x1c4)
    FIELD(ATTR_113, ATTR_SPARE_BYTE3, 8, 8)
    FIELD(ATTR_113, ATTR_SPARE_BYTE2, 0, 8)
REG32(ATTR_114, 0x1c8)
    FIELD(ATTR_114, ATTR_SPARE_WORD0, 0, 16)
REG32(ATTR_115, 0x1cc)
    FIELD(ATTR_115, ATTR_SPARE_WORD0, 0, 16)
REG32(ATTR_116, 0x1d0)
    FIELD(ATTR_116, ATTR_SPARE_WORD1, 0, 16)
REG32(ATTR_117, 0x1d4)
    FIELD(ATTR_117, ATTR_SPARE_WORD1, 0, 16)
REG32(ATTR_118, 0x1d8)
    FIELD(ATTR_118, ATTR_SPARE_WORD2, 0, 16)
REG32(ATTR_119, 0x1dc)
    FIELD(ATTR_119, ATTR_SPARE_WORD2, 0, 16)
REG32(ATTR_120, 0x1e0)
    FIELD(ATTR_120, ATTR_SPARE_WORD3, 0, 16)
REG32(ATTR_121, 0x1e4)
    FIELD(ATTR_121, ATTR_SPARE_WORD3, 0, 16)
REG32(ID, 0x200)
    FIELD(ID, CFG_VEND_ID, 16, 16)
    FIELD(ID, CFG_DEV_ID, 0, 16)
REG32(SUBSYS_ID, 0x204)
    FIELD(SUBSYS_ID, CFG_SUBSYS_VEND_ID, 16, 16)
    FIELD(SUBSYS_ID, CFG_SUBSYS_ID, 0, 16)
REG32(REV_ID, 0x208)
    FIELD(REV_ID, CFG_REV_ID, 0, 8)
REG32(DSN_0, 0x20c)
REG32(DSN_1, 0x210)
REG32(MGMT_CTRL, 0x214)
    FIELD(MGMT_CTRL, CFG_MGMT_WR_READONLY, 1, 1)
    FIELD(MGMT_CTRL, CFG_MGMT_WR_RW1C_AS_RW, 0, 1)
REG32(PM_CTRL, 0x218)
    FIELD(PM_CTRL, CFG_TRN_PENDING, 3, 1)
    FIELD(PM_CTRL, CFG_PM_SEND_PME_TO, 2, 1)
    FIELD(PM_CTRL, CFG_PM_TURNOFF_OK, 1, 1)
    FIELD(PM_CTRL, CFG_PM_WAKE, 0, 1)
REG32(RST_CTRL, 0x220)
    FIELD(RST_CTRL, PL_RST_N, 6, 1)
    FIELD(RST_CTRL, FUNC_LVL_RST_N, 5, 1)
    FIELD(RST_CTRL, DL_RST_N, 3, 1)
    FIELD(RST_CTRL, TL_RST_N, 2, 1)
    FIELD(RST_CTRL, CM_STICKY_RST_N, 1, 1)
    FIELD(RST_CTRL, CM_RST_N, 0, 1)
REG32(DBG_CTRL, 0x224)
    FIELD(DBG_CTRL, PL_DBG_MODE, 3, 3)
    FIELD(DBG_CTRL, DBG_SUB_MODE, 2, 1)
    FIELD(DBG_CTRL, DBG_MODE, 0, 2)
REG32(PL_LINK_CTRL_STATUS, 0x228)
    FIELD(PL_LINK_CTRL_STATUS, DIR_LINK_CHANGE_DONE, 22, 1)
    FIELD(PL_LINK_CTRL_STATUS, DIR_LINK_CHANGE, 20, 2)
    FIELD(PL_LINK_CTRL_STATUS, DIR_LINK_AUTON, 19, 1)
    FIELD(PL_LINK_CTRL_STATUS, DIR_LINK_SPEED, 18, 1)
    FIELD(PL_LINK_CTRL_STATUS, DIR_LINK_WIDTH, 16, 2)
    FIELD(PL_LINK_CTRL_STATUS, LINK_UP, 11, 1)
    FIELD(PL_LINK_CTRL_STATUS, LANE_REVERSAL, 9, 2)
    FIELD(PL_LINK_CTRL_STATUS, LTSSM_STATE, 3, 6)
    FIELD(PL_LINK_CTRL_STATUS, LINK_WIDTH, 1, 2)
    FIELD(PL_LINK_CTRL_STATUS, LINK_RATE, 0, 1)
REG32(DIR_LTSSM, 0x22c)
    FIELD(DIR_LTSSM, PL_DIR_LTSSM_STALL, 7, 1)
    FIELD(DIR_LTSSM, PL_DIR_LTSSM_NEW_VLD, 6, 1)
    FIELD(DIR_LTSSM, PL_DIR_LTSSM_NEW, 0, 6)
REG32(EP_CTRL, 0x230)
    FIELD(EP_CTRL, PL_UPSTREAM_DEEMPH_SOURCE, 1, 1)
    FIELD(EP_CTRL, PL_RECEIVED_HOT_RST, 0, 1)
REG32(RP_CTRL, 0x234)
    FIELD(RP_CTRL, PL_DOWNSTREAM_DEEMPH_SOURCE, 1, 1)
    FIELD(RP_CTRL, PL_TRANSMIT_HOT_RST, 0, 1)
REG32(PCIE_STATUS, 0x238)
    FIELD(PCIE_STATUS, PHY_RDY, 1, 1)
    FIELD(PCIE_STATUS, PCIE_LINK_UP, 0, 1)
REG32(MISC_CTRL, 0x300)
    FIELD(MISC_CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x304)
    FIELD(ISR, PCIE_RESET, 1, 1)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0x308)
    FIELD(IMR, PCIE_RESET, 1, 1)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x30c)
    FIELD(IER, PCIE_RESET, 1, 1)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x310)
    FIELD(IDR, PCIE_RESET, 1, 1)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ECO_0, 0x314)
REG32(ECO_1, 0x318)
REG32(CB, 0x31c)
    FIELD(CB, CB1, 1, 1)
    FIELD(CB, CB0, 0, 1)

#define PCIE_ATTRIB_R_MAX (R_CB + 1)

typedef struct PCIE_ATTRIB {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr;

    uint32_t regs[PCIE_ATTRIB_R_MAX];
    RegisterInfo regs_info[PCIE_ATTRIB_R_MAX];
} PCIE_ATTRIB;

static void imr_update_irq(PCIE_ATTRIB *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PCIE_ATTRIB *s = XILINX_PCIE_ATTRIB(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PCIE_ATTRIB *s = XILINX_PCIE_ATTRIB(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PCIE_ATTRIB *s = XILINX_PCIE_ATTRIB(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo pcie_attrib_regs_info[] = {
    {   .name = "ATTR_0",  .addr = A_ATTR_0,
        .reset = 0x3,
    },{ .name = "ATTR_1",  .addr = A_ATTR_1,
        .reset = 0x1,
    },{ .name = "ATTR_2",  .addr = A_ATTR_2,
        .reset = 0x2,
    },{ .name = "ATTR_3",  .addr = A_ATTR_3,
        .reset = 0x140,
    },{ .name = "ATTR_4",  .addr = A_ATTR_4,
        .reset = 0x1000,
    },{ .name = "ATTR_5",  .addr = A_ATTR_5,
        .reset = 0xff07,
    },{ .name = "ATTR_6",  .addr = A_ATTR_6,
        .reset = 0x7,
    },{ .name = "ATTR_7",  .addr = A_ATTR_7,
        .reset = 0x4,
    },{ .name = "ATTR_8",  .addr = A_ATTR_8,
        .reset = 0xfff0,
    },{ .name = "ATTR_9",  .addr = A_ATTR_9,
        .reset = 0xffff,
    },{ .name = "ATTR_10",  .addr = A_ATTR_10,
        .reset = 0xffff,
    },{ .name = "ATTR_11",  .addr = A_ATTR_11,
        .reset = 0x4,
    },{ .name = "ATTR_12",  .addr = A_ATTR_12,
        .reset = 0xfff0,
    },{ .name = "ATTR_13",  .addr = A_ATTR_13,
        .reset = 0xffff,
    },{ .name = "ATTR_14",  .addr = A_ATTR_14,
        .reset = 0xffff,
    },{ .name = "ATTR_15",  .addr = A_ATTR_15,
        .reset = 0x4,
    },{ .name = "ATTR_16",  .addr = A_ATTR_16,
        .reset = 0xfff0,
    },{ .name = "ATTR_17",  .addr = A_ATTR_17,
        .reset = 0xffff,
    },{ .name = "ATTR_18",  .addr = A_ATTR_18,
        .reset = 0xffff,
    },{ .name = "ATTR_19",  .addr = A_ATTR_19,
    },{ .name = "ATTR_20",  .addr = A_ATTR_20,
    },{ .name = "ATTR_21",  .addr = A_ATTR_21,
        .reset = 0x40,
    },{ .name = "ATTR_22",  .addr = A_ATTR_22,
    },{ .name = "ATTR_23",  .addr = A_ATTR_23,
    },{ .name = "ATTR_24",  .addr = A_ATTR_24,
        .reset = 0x8000,
    },{ .name = "ATTR_25",  .addr = A_ATTR_25,
        .reset = 0x905,
    },{ .name = "ATTR_26",  .addr = A_ATTR_26,
        .reset = 0x3000,
    },{ .name = "ATTR_27",  .addr = A_ATTR_27,
        .reset = 0x2138,
    },{ .name = "ATTR_28",  .addr = A_ATTR_28,
    },{ .name = "ATTR_29",  .addr = A_ATTR_29,
        .reset = 0x100,
    },{ .name = "ATTR_30",  .addr = A_ATTR_30,
        .reset = 0x3,
    },{ .name = "ATTR_31",  .addr = A_ATTR_31,
        .reset = 0x110c,
    },{ .name = "ATTR_32",  .addr = A_ATTR_32,
        .reset = 0x3f1,
    },{ .name = "ATTR_33",  .addr = A_ATTR_33,
        .reset = 0x3ff,
    },{ .name = "ATTR_34",  .addr = A_ATTR_34,
        .reset = 0x100,
    },{ .name = "ATTR_35",  .addr = A_ATTR_35,
        .reset = 0xffd,
    },{ .name = "ATTR_36",  .addr = A_ATTR_36,
        .reset = 0x7fff,
    },{ .name = "ATTR_37",  .addr = A_ATTR_37,
        .reset = 0x49ff,
    },{ .name = "ATTR_38",  .addr = A_ATTR_38,
        .reset = 0x120,
    },{ .name = "ATTR_39",  .addr = A_ATTR_39,
        .reset = 0x148,
    },{ .name = "ATTR_40",  .addr = A_ATTR_40,
        .reset = 0x405,
    },{ .name = "ATTR_41",  .addr = A_ATTR_41,
        .reset = 0x160,
    },{ .name = "ATTR_42",  .addr = A_ATTR_42,
        .reset = 0x119c,
    },{ .name = "ATTR_43",  .addr = A_ATTR_43,
        .reset = 0x100,
    },{ .name = "ATTR_44",  .addr = A_ATTR_44,
        .reset = 0x1,
    },{ .name = "ATTR_45",  .addr = A_ATTR_45,
        .reset = 0x8000,
    },{ .name = "ATTR_46",  .addr = A_ATTR_46,
        .reset = 0x1,
    },{ .name = "ATTR_47",  .addr = A_ATTR_47,
    },{ .name = "ATTR_48",  .addr = A_ATTR_48,
        .reset = 0x3,
    },{ .name = "ATTR_49",  .addr = A_ATTR_49,
        .reset = 0x1060,
    },{ .name = "ATTR_50",  .addr = A_ATTR_50,
        .reset = 0x9c02,
    },{ .name = "ATTR_51",  .addr = A_ATTR_51,
        .reset = 0x4021,
    },{ .name = "ATTR_52",  .addr = A_ATTR_52,
        .reset = 0x40,
    },{ .name = "ATTR_53",  .addr = A_ATTR_53,
        .reset = 0x3d48,
    },{ .name = "ATTR_54",  .addr = A_ATTR_54,
        .reset = 0x23,
    },{ .name = "ATTR_55",  .addr = A_ATTR_55,
    },{ .name = "ATTR_56",  .addr = A_ATTR_56,
    },{ .name = "ATTR_57",  .addr = A_ATTR_57,
    },{ .name = "ATTR_58",  .addr = A_ATTR_58,
    },{ .name = "ATTR_59",  .addr = A_ATTR_59,
    },{ .name = "ATTR_60",  .addr = A_ATTR_60,
        .reset = 0x178,
    },{ .name = "ATTR_61",  .addr = A_ATTR_61,
    },{ .name = "ATTR_62",  .addr = A_ATTR_62,
        .reset = 0x15,
    },{ .name = "ATTR_63",  .addr = A_ATTR_63,
        .reset = 0x1,
    },{ .name = "ATTR_64",  .addr = A_ATTR_64,
        .reset = 0x1,
    },{ .name = "ATTR_65",  .addr = A_ATTR_65,
    },{ .name = "ATTR_66",  .addr = A_ATTR_66,
        .reset = 0x1,
    },{ .name = "ATTR_67",  .addr = A_ATTR_67,
    },{ .name = "ATTR_68",  .addr = A_ATTR_68,
        .reset = 0x1,
    },{ .name = "ATTR_69",  .addr = A_ATTR_69,
    },{ .name = "ATTR_70",  .addr = A_ATTR_70,
        .reset = 0x1,
    },{ .name = "ATTR_71",  .addr = A_ATTR_71,
    },{ .name = "ATTR_72",  .addr = A_ATTR_72,
        .reset = 0x1,
    },{ .name = "ATTR_73",  .addr = A_ATTR_73,
    },{ .name = "ATTR_74",  .addr = A_ATTR_74,
        .reset = 0x1,
    },{ .name = "ATTR_75",  .addr = A_ATTR_75,
    },{ .name = "ATTR_76",  .addr = A_ATTR_76,
    },{ .name = "ATTR_77",  .addr = A_ATTR_77,
    },{ .name = "ATTR_78",  .addr = A_ATTR_78,
    },{ .name = "ATTR_79",  .addr = A_ATTR_79,
    },{ .name = "ATTR_80",  .addr = A_ATTR_80,
    },{ .name = "ATTR_81",  .addr = A_ATTR_81,
    },{ .name = "ATTR_82",  .addr = A_ATTR_82,
        .reset = 0x10c,
    },{ .name = "ATTR_83",  .addr = A_ATTR_83,
        .reset = 0x1128,
    },{ .name = "ATTR_84",  .addr = A_ATTR_84,
        .reset = 0x2,
    },{ .name = "ATTR_85",  .addr = A_ATTR_85,
        .reset = 0x250,
    },{ .name = "ATTR_86",  .addr = A_ATTR_86,
        .reset = 0x1234,
    },{ .name = "ATTR_87",  .addr = A_ATTR_87,
        .reset = 0x1018,
    },{ .name = "ATTR_88",  .addr = A_ATTR_88,
        .reset = 0xb,
    },{ .name = "ATTR_89",  .addr = A_ATTR_89,
        .reset = 0x2281,
    },{ .name = "ATTR_90",  .addr = A_ATTR_90,
        .reset = 0x31,
    },{ .name = "ATTR_91",  .addr = A_ATTR_91,
    },{ .name = "ATTR_92",  .addr = A_ATTR_92,
    },{ .name = "ATTR_93",  .addr = A_ATTR_93,
    },{ .name = "ATTR_94",  .addr = A_ATTR_94,
        .reset = 0x1,
    },{ .name = "ATTR_95",  .addr = A_ATTR_95,
    },{ .name = "ATTR_96",  .addr = A_ATTR_96,
        .reset = 0x28,
    },{ .name = "ATTR_97",  .addr = A_ATTR_97,
        .reset = 0x104,
    },{ .name = "ATTR_98",  .addr = A_ATTR_98,
        .reset = 0xffff,
    },{ .name = "ATTR_99",  .addr = A_ATTR_99,
        .reset = 0xffff,
    },{ .name = "ATTR_100",  .addr = A_ATTR_100,
        .reset = 0xf0,
    },{ .name = "ATTR_101",  .addr = A_ATTR_101,
    },{ .name = "ATTR_102",  .addr = A_ATTR_102,
        .reset = 0x8008,
    },{ .name = "ATTR_103",  .addr = A_ATTR_103,
        .reset = 0x22,
    },{ .name = "ATTR_104",  .addr = A_ATTR_104,
        .reset = 0x3ff,
    },{ .name = "ATTR_105",  .addr = A_ATTR_105,
        .reset = 0x172,
    },{ .name = "ATTR_106",  .addr = A_ATTR_106,
        .reset = 0x248,
    },{ .name = "ATTR_107",  .addr = A_ATTR_107,
        .reset = 0x8,
    },{ .name = "ATTR_108",  .addr = A_ATTR_108,
        .reset = 0x20,
    },{ .name = "ATTR_109",  .addr = A_ATTR_109,
        .reset = 0x7e04,
    },{ .name = "ATTR_110",  .addr = A_ATTR_110,
        .reset = 0xfabc,
    },{ .name = "ATTR_111",  .addr = A_ATTR_111,
    },{ .name = "ATTR_112",  .addr = A_ATTR_112,
    },{ .name = "ATTR_113",  .addr = A_ATTR_113,
    },{ .name = "ATTR_114",  .addr = A_ATTR_114,
    },{ .name = "ATTR_115",  .addr = A_ATTR_115,
    },{ .name = "ATTR_116",  .addr = A_ATTR_116,
    },{ .name = "ATTR_117",  .addr = A_ATTR_117,
    },{ .name = "ATTR_118",  .addr = A_ATTR_118,
    },{ .name = "ATTR_119",  .addr = A_ATTR_119,
    },{ .name = "ATTR_120",  .addr = A_ATTR_120,
    },{ .name = "ATTR_121",  .addr = A_ATTR_121,
    },{ .name = "ID",  .addr = A_ID,
        .reset = 0x10ee7024,
    },{ .name = "SUBSYS_ID",  .addr = A_SUBSYS_ID,
        .reset = 0x10ee0007,
    },{ .name = "REV_ID",  .addr = A_REV_ID,
    },{ .name = "DSN_0",  .addr = A_DSN_0,
    },{ .name = "DSN_1",  .addr = A_DSN_1,
    },{ .name = "MGMT_CTRL",  .addr = A_MGMT_CTRL,
    },{ .name = "PM_CTRL",  .addr = A_PM_CTRL,
        .reset = 0x7,
        .ro = 0x8,
    },{ .name = "RST_CTRL",  .addr = A_RST_CTRL,
        .reset = 0x6f,
    },{ .name = "DBG_CTRL",  .addr = A_DBG_CTRL,
    },{ .name = "PL_LINK_CTRL_STATUS",  .addr = A_PL_LINK_CTRL_STATUS,
        .rsvd = 0xf000,
        .ro = 0x40ffff,
    },{ .name = "DIR_LTSSM",  .addr = A_DIR_LTSSM,
    },{ .name = "EP_CTRL",  .addr = A_EP_CTRL,
        .ro = 0x1,
    },{ .name = "RP_CTRL",  .addr = A_RP_CTRL,
    },{ .name = "PCIE_STATUS",  .addr = A_PCIE_STATUS,
        .ro = 0x3,
        /* PHY is always ready and link is always up.  */
        .reset = R_PCIE_STATUS_PHY_RDY_MASK | R_PCIE_STATUS_PCIE_LINK_UP_MASK,
    },{ .name = "MISC_CTRL",  .addr = A_MISC_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x3,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "IER",  .addr = A_IER,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .pre_write = idr_prew,
    },{ .name = "ECO_0",  .addr = A_ECO_0,
    },{ .name = "ECO_1",  .addr = A_ECO_1,
        .reset = 0xffffffff,
    },{ .name = "CB",  .addr = A_CB,
        .reset = 0x1,
    }
};

static void pcie_attrib_reset(DeviceState *dev)
{
    PCIE_ATTRIB *s = XILINX_PCIE_ATTRIB(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    imr_update_irq(s);
}

static const MemoryRegionOps pcie_attrib_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pcie_attrib_init(Object *obj)
{
    PCIE_ATTRIB *s = XILINX_PCIE_ATTRIB(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PCIE_ATTRIB,
                       PCIE_ATTRIB_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pcie_attrib_regs_info,
                              ARRAY_SIZE(pcie_attrib_regs_info),
                              s->regs_info, s->regs,
                              &pcie_attrib_ops,
                              XILINX_PCIE_ATTRIB_ERR_DEBUG,
                              PCIE_ATTRIB_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr);
}

static const VMStateDescription vmstate_pcie_attrib = {
    .name = TYPE_XILINX_PCIE_ATTRIB,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PCIE_ATTRIB, PCIE_ATTRIB_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pcie_attrib_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pcie_attrib_reset;
    dc->vmsd = &vmstate_pcie_attrib;
}

static const TypeInfo pcie_attrib_info = {
    .name          = TYPE_XILINX_PCIE_ATTRIB,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PCIE_ATTRIB),
    .class_init    = pcie_attrib_class_init,
    .instance_init = pcie_attrib_init,
};

static void pcie_attrib_register_types(void)
{
    type_register_static(&pcie_attrib_info);
}

type_init(pcie_attrib_register_types)
