/*
 * QEMU model of the SERDES t16ffllp
 *
 * Copyright (c) 2015 - 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-12-09.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_SERDES_ERR_DEBUG
#define XILINX_SERDES_ERR_DEBUG 0
#endif

#define TYPE_XILINX_SERDES "xlnx.zynqmp-serdes"

#define XILINX_SERDES(obj) \
     OBJECT_CHECK(SERDES, (obj), TYPE_XILINX_SERDES)

REG32(L0_TX_ANA_TM_0, 0x0)
    FIELD(L0_TX_ANA_TM_0, TX_ANA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_0, ANA_BYP0_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_0, PIPE_TX_DN_RXDET, 5, 1)
    FIELD(L0_TX_ANA_TM_0, FORCE_PIPE_TX_DN_RXDET, 4, 1)
    FIELD(L0_TX_ANA_TM_0, PIPE_TX_DP_RXDET, 3, 1)
    FIELD(L0_TX_ANA_TM_0, FORCE_PIPE_TX_DP_RXDET, 2, 1)
    FIELD(L0_TX_ANA_TM_0, ANA_BYP0_1_0_RSVD, 0, 2)
REG32(L0_TX_ANA_TM_3, 0xc)
    FIELD(L0_TX_ANA_TM_3, TX_ANA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_3, TX_HS_SER_RSTB, 7, 1)
    FIELD(L0_TX_ANA_TM_3, FORCE_TX_HS_SER_RSTB, 6, 1)
    FIELD(L0_TX_ANA_TM_3, TX_HS_BURST, 5, 1)
    FIELD(L0_TX_ANA_TM_3, FORCE_TX_HS_BURST, 4, 1)
    FIELD(L0_TX_ANA_TM_3, TX_SERIALIZER_ENABLE, 3, 1)
    FIELD(L0_TX_ANA_TM_3, FORCE_TX_SERIALIZER_ENABLE, 2, 1)
    FIELD(L0_TX_ANA_TM_3, TX_ENABLE_SUPPLY_SERIALIZER, 1, 1)
    FIELD(L0_TX_ANA_TM_3, FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 0, 1)
REG32(L0_TX_ANA_TM_4, 0x10)
    FIELD(L0_TX_ANA_TM_4, TX_ANA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_4, ANA_BYP4_7_RSVD, 7, 1)
    FIELD(L0_TX_ANA_TM_4, TX_LSEG_DN_RESCAL_CODE, 1, 6)
    FIELD(L0_TX_ANA_TM_4, FORCE_TX_LSEG_DN_RESCAL_CODE, 0, 1)
REG32(L0_TX_ANA_TM_5, 0x14)
    FIELD(L0_TX_ANA_TM_5, TX_ANA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_5, ANA_BYP5_7_RSVD, 7, 1)
    FIELD(L0_TX_ANA_TM_5, TX_USEG_DP_RESCAL_CODE, 1, 6)
    FIELD(L0_TX_ANA_TM_5, FORCE_TX_USEG_DP_RESCAL_CODE, 0, 1)
REG32(L0_TX_ANA_TM_9, 0x24)
    FIELD(L0_TX_ANA_TM_9, TX_ANA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_9, MPHY_TX_HS_SLEWRATE, 0, 8)
REG32(L0_TX_ANA_TM_10, 0x28)
    FIELD(L0_TX_ANA_TM_10, TX_ANA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_10, MPHY_HS_POWERUP_TIME, 4, 4)
    FIELD(L0_TX_ANA_TM_10, MPHY_TX_HS_EQUALIZER_SETTING, 1, 3)
    FIELD(L0_TX_ANA_TM_10, FORCE_MPHY_TX_HS_EQUALIZER_SETTING, 0, 1)
REG32(L0_TX_ANA_TM_13, 0x34)
    FIELD(L0_TX_ANA_TM_13, TX_ANA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_13, ANA_BYP13_7_4_RSVD, 4, 4)
    FIELD(L0_TX_ANA_TM_13, TX_SWAP_POLARITY, 3, 1)
    FIELD(L0_TX_ANA_TM_13, FORCE_TX_SWAP_POLARITY, 2, 1)
    FIELD(L0_TX_ANA_TM_13, MPHY_TX_TRISTATE, 1, 1)
    FIELD(L0_TX_ANA_TM_13, FORCE_MPHY_TX_TRISTATE, 0, 1)
REG32(L0_TX_ANA_TM_14, 0x38)
    FIELD(L0_TX_ANA_TM_14, TX_ANA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_14, ANA_BYP14_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_14, PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L0_TX_ANA_TM_14, FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L0_TX_ANA_TM_14, ANA_BYP14_3_0_RSVD, 0, 4)
REG32(L0_TX_ANA_TM_15, 0x3c)
    FIELD(L0_TX_ANA_TM_15, TX_ANA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_15, PIPE_TX_SWING, 7, 1)
    FIELD(L0_TX_ANA_TM_15, FORCE_PIPE_TX_SWING, 6, 1)
    FIELD(L0_TX_ANA_TM_15, PIPE_TX_RXDET_DISCHARGE, 5, 1)
    FIELD(L0_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_DISCHARGE, 4, 1)
    FIELD(L0_TX_ANA_TM_15, PIPE_TX_RXDET_CHARGE, 3, 1)
    FIELD(L0_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_CHARGE, 2, 1)
    FIELD(L0_TX_ANA_TM_15, PIPE_TX_ENABLE_RXDET, 1, 1)
    FIELD(L0_TX_ANA_TM_15, FORCE_PIPE_TX_ENABLE_RXDET, 0, 1)
REG32(L0_TX_ANA_TM_16, 0x40)
    FIELD(L0_TX_ANA_TM_16, TX_ANA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_16, ANA_BYP16_7_4_RSVD, 4, 4)
    FIELD(L0_TX_ANA_TM_16, PIPE_TX_MARGIN, 1, 3)
    FIELD(L0_TX_ANA_TM_16, FORCE_PIPE_TX_MARGIN, 0, 1)
REG32(L0_TX_ANA_TM_18, 0x48)
    FIELD(L0_TX_ANA_TM_18, TX_ANA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_18, PIPE_TX_DEEMPH_7_0, 0, 8)
REG32(L0_TX_ANA_TM_19, 0x4c)
    FIELD(L0_TX_ANA_TM_19, TX_ANA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_19, PIPE_TX_DEEMPH_15_8, 0, 8)
REG32(L0_TX_ANA_TM_20, 0x50)
    FIELD(L0_TX_ANA_TM_20, TX_ANA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_20, ANA_BYP20_7_5_RSVD, 5, 3)
    FIELD(L0_TX_ANA_TM_20, TX_SERIALIZER_RST_REL, 4, 1)
    FIELD(L0_TX_ANA_TM_20, FORCE_TX_SERIALIZER_RST_REL, 3, 1)
    FIELD(L0_TX_ANA_TM_20, FORCE_MPHY_TX_HS_SLEWRATE, 2, 1)
    FIELD(L0_TX_ANA_TM_20, PIPE_TX_DEEMPH_17_16, 0, 2)
REG32(L0_TX_ANA_TM_21, 0x54)
    FIELD(L0_TX_ANA_TM_21, TX_ANA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_21, ANA_BYP21_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_21, PIPE_TX_COEF_CALC_CLK, 5, 1)
    FIELD(L0_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_CLK, 4, 1)
    FIELD(L0_TX_ANA_TM_21, PIPE_TX_COEF_CALC_FSM_RESET_B, 3, 1)
    FIELD(L0_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_FSM_RESET_B, 2, 1)
    FIELD(L0_TX_ANA_TM_21, PIPE_TX_DEEMPH_CTRL_SEL, 1, 1)
    FIELD(L0_TX_ANA_TM_21, FORCE_PIPE_TX_DEEMPH_CTRL_SEL, 0, 1)
REG32(L0_TX_DIG_TM_61, 0xf4)
    FIELD(L0_TX_DIG_TM_61, TX_DIG_TM_61_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_61, MPHY_PLL_GEAR, 6, 2)
    FIELD(L0_TX_DIG_TM_61, DIG_BYP1_5_4_RSVD, 4, 2)
    FIELD(L0_TX_DIG_TM_61, BYPASS_ENC, 3, 1)
    FIELD(L0_TX_DIG_TM_61, DIG_BYP1_2_RSVD, 2, 1)
    FIELD(L0_TX_DIG_TM_61, BYPASS_SCRAM, 1, 1)
    FIELD(L0_TX_DIG_TM_61, FORCE_BYPASS_SCRAM, 0, 1)
REG32(L0_TX_DIG_TM_62, 0xf8)
    FIELD(L0_TX_DIG_TM_62, TX_DIG_TM_62_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_62, G0_BIT_PER_CNT, 0, 8)
REG32(L0_TX_DIG_TM_65, 0x104)
    FIELD(L0_TX_DIG_TM_65, TX_DIG_TM_65_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_65, FORCE_TX_RXDET_PROBE_THRESHOLD, 7, 1)
    FIELD(L0_TX_DIG_TM_65, FORCE_TX_RXDET_END_CH_THRESHOLD, 6, 1)
    FIELD(L0_TX_DIG_TM_65, FORCE_TX_RXDET_START_CH_THRESHOLD, 5, 1)
    FIELD(L0_TX_DIG_TM_65, FORCE_TX_RXDET_END_DCH_THRESHOLD, 4, 1)
    FIELD(L0_TX_DIG_TM_65, FORCE_TX_RXDET_START_DCH_THRESHOLD, 3, 1)
    FIELD(L0_TX_DIG_TM_65, TX_EN_FULL_CALIB, 2, 1)
    FIELD(L0_TX_DIG_TM_65, FORCE_TX_EN_FULL_CALIB, 1, 1)
    FIELD(L0_TX_DIG_TM_65, DIG_BYP5_0_RSVD, 0, 1)
REG32(L0_TX_DIG_TM_67, 0x10c)
    FIELD(L0_TX_DIG_TM_67, TX_DIG_TM_67_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_67, TX_MPHY_SER_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_68, 0x110)
    FIELD(L0_TX_DIG_TM_68, TX_DIG_TM_68_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_68, TX_SER_SUP_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_69, 0x114)
    FIELD(L0_TX_DIG_TM_69, TX_DIG_TM_69_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_69, TX_MPHY_SUP_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_76, 0x130)
    FIELD(L0_TX_DIG_TM_76, TX_DIG_TM_76_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_76, TX_RXDET_START_DCH_THRESHOLD_7_0, 0, 8)
REG32(L0_TX_DIG_TM_77, 0x134)
    FIELD(L0_TX_DIG_TM_77, TX_DIG_TM_77_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_77, TX_RXDET_END_DCH_THRESHOLD_11_8, 4, 4)
    FIELD(L0_TX_DIG_TM_77, TX_RXDET_START_DCH_THRESHOLD_11_8, 0, 4)
REG32(L0_TX_DIG_TM_78, 0x138)
    FIELD(L0_TX_DIG_TM_78, TX_DIG_TM_78_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_78, TX_RXDET_END_DCH_THRESHOLD_7_0, 0, 8)
REG32(L0_TX_DIG_TM_79, 0x13c)
    FIELD(L0_TX_DIG_TM_79, TX_DIG_TM_79_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_79, TX_RXDET_START_CH_THRESHOLD_7_0, 0, 8)
REG32(L0_TX_DIG_TM_80, 0x140)
    FIELD(L0_TX_DIG_TM_80, TX_DIG_TM_80_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_80, TX_RXDET_END_CH_THRESHOLD_11_8, 4, 4)
    FIELD(L0_TX_DIG_TM_80, TX_RXDET_START_CH_THRESHOLD_11_8, 0, 4)
REG32(L0_TX_DIG_TM_81, 0x144)
    FIELD(L0_TX_DIG_TM_81, TX_DIG_TM_81_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_81, TX_RXDET_END_CH_THRESHOLD_7_0, 0, 8)
REG32(L0_TX_DIG_TM_82, 0x148)
    FIELD(L0_TX_DIG_TM_82, TX_DIG_TM_82_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_82, TX_RXDET_PROBE_THRESHOLD_7_0, 0, 8)
REG32(L0_TX_DIG_TM_83, 0x14c)
    FIELD(L0_TX_DIG_TM_83, TX_DIG_TM_83_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_83, DIG_BYP23_7_4_RSVD, 4, 4)
    FIELD(L0_TX_DIG_TM_83, TX_RXDET_PROBE_THRESHOLD_11_8, 0, 4)
REG32(L0_TX_DIG_TM_84, 0x150)
    FIELD(L0_TX_DIG_TM_84, TX_DIG_TM_84_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_84, TX_DIF_P, 7, 1)
    FIELD(L0_TX_DIG_TM_84, TX_DITHER_1P, 6, 1)
    FIELD(L0_TX_DIG_TM_84, TX_DITHER_1N, 5, 1)
    FIELD(L0_TX_DIG_TM_84, TX_DITHER_EN, 4, 1)
    FIELD(L0_TX_DIG_TM_84, DIG_BYP24_3_RSVD, 3, 1)
    FIELD(L0_TX_DIG_TM_84, TX_PHYDIRDY_SOC_MODE, 2, 1)
    FIELD(L0_TX_DIG_TM_84, DIG_BYP24_1_RSVD, 1, 1)
    FIELD(L0_TX_DIG_TM_84, TX_READ_SHADOW, 0, 1)
REG32(L0_TX_ANA_TM_85, 0x154)
    FIELD(L0_TX_ANA_TM_85, TX_ANA_TM_85_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_85, DIG_BYP25_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_85, TX_HIBERN8_CTRL, 5, 1)
    FIELD(L0_TX_ANA_TM_85, TX_ALLOW_INLNCFG_FROM_TOP, 4, 1)
    FIELD(L0_TX_ANA_TM_85, DIG_BYP25_3_RSVD, 3, 1)
    FIELD(L0_TX_ANA_TM_85, TX_SEND_MSB_FIRST, 2, 1)
    FIELD(L0_TX_ANA_TM_85, DIG_BYP25_1_RSVD, 1, 1)
    FIELD(L0_TX_ANA_TM_85, TX_DIF_N, 0, 1)
REG32(L0_TX_ANA_TM_87, 0x15c)
    FIELD(L0_TX_ANA_TM_87, TX_ANA_TM_87_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_87, DIG_BYP27_7_4_RSVD, 4, 4)
    FIELD(L0_TX_ANA_TM_87, TX_SM_STATUS, 0, 4)
REG32(L0_TX_ANA_TM_88, 0x160)
    FIELD(L0_TX_ANA_TM_88, TX_ANA_TM_88_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_88, TX_COMP_PAT_HIGH_TIME_REGS, 0, 8)
REG32(L0_TX_ANA_TM_89, 0x164)
    FIELD(L0_TX_ANA_TM_89, TX_ANA_TM_89_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_89, DIG_BYP29_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_89, TX_DATAPATH_CTRL_1_REGS, 5, 1)
    FIELD(L0_TX_ANA_TM_89, DIG_BYP29_4_3_RSVD, 3, 2)
    FIELD(L0_TX_ANA_TM_89, INITIAL_DISPARITY, 2, 1)
    FIELD(L0_TX_ANA_TM_89, SCRAMBLER_ENABLE, 1, 1)
    FIELD(L0_TX_ANA_TM_89, DIG_BYP29_0_RSVD, 0, 1)
REG32(L0_TX_ANA_TM_90, 0x168)
    FIELD(L0_TX_ANA_TM_90, TX_ANA_TM_90_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_90, DIG_BYP30_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_90, TX_BYPASS_BCNT_LPBACK_REGS, 5, 1)
    FIELD(L0_TX_ANA_TM_90, DIG_BYP30_4_0_RSVD, 0, 5)
REG32(L0_TX_DIG_TM_91, 0x16c)
    FIELD(L0_TX_DIG_TM_91, TX_DIG_TM_91_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_91, TX_CFGCLK_FREQ, 0, 8)
REG32(L0_TX_DIG_TM_92, 0x170)
    FIELD(L0_TX_DIG_TM_92, TX_DIG_TM_92_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_92, TX_PHYDIRDY_PULL_UP_LATENCY, 0, 8)
REG32(L0_TX_ANA_TM_95, 0x17c)
    FIELD(L0_TX_ANA_TM_95, TX_ANA_TM_95_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_95, ANA_BYP63_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_95, TX_TM_EN_PROG_SYNC_PATTERN, 5, 1)
    FIELD(L0_TX_ANA_TM_95, TX_EXTRA_HS_BURST_IN_LCC, 2, 3)
    FIELD(L0_TX_ANA_TM_95, ANA_BYP22_1_0_RSVD, 0, 2)
REG32(L0_TX_ANA_TM_96, 0x180)
    FIELD(L0_TX_ANA_TM_96, TX_ANA_TM_96_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_96, TX_TM_PROG_SYNC_PATTERN1, 0, 8)
REG32(L0_TX_ANA_TM_97, 0x184)
    FIELD(L0_TX_ANA_TM_97, TX_ANA_TM_97_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_97, TX_TM_PROG_SYNC_PATTERN2, 0, 8)
REG32(L0_TX_DIG_TM_98, 0x188)
    FIELD(L0_TX_DIG_TM_98, TX_DIG_TM_98_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_98, DIG_BYP33_7_6_RSVD, 6, 2)
    FIELD(L0_TX_DIG_TM_98, FORCE_RD_VALUE, 5, 1)
    FIELD(L0_TX_DIG_TM_98, FORCE_RD, 4, 1)
    FIELD(L0_TX_DIG_TM_98, TX_SER_ISO_CTRL_BAR, 3, 1)
    FIELD(L0_TX_DIG_TM_98, FORCE_TX_SER_ISO_CTRL_BAR, 2, 1)
    FIELD(L0_TX_DIG_TM_98, TX_ISO_CTRL_BAR, 1, 1)
    FIELD(L0_TX_DIG_TM_98, FORCE_TX_ISO_CTRL_BAR, 0, 1)
REG32(L0_TX_DIG_TM_99, 0x18c)
    FIELD(L0_TX_DIG_TM_99, TX_DIG_TM_99_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_99, TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_100, 0x190)
    FIELD(L0_TX_DIG_TM_100, TX_DIG_TM_100_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_100, TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_101, 0x194)
    FIELD(L0_TX_DIG_TM_101, TX_DIG_TM_101_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_101, TX_SERIALISER_ENABLE_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_102, 0x198)
    FIELD(L0_TX_DIG_TM_102, TX_DIG_TM_102_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_102, FORCE_TX_ANA_LL_EN, 7, 1)
    FIELD(L0_TX_DIG_TM_102, TX_ANA_LL_EN, 6, 1)
    FIELD(L0_TX_DIG_TM_102, FORCE_DELAY_CNT_THRESHOLD, 5, 1)
    FIELD(L0_TX_DIG_TM_102, FORCE_TX_MPHY_TRST_THRESHOLD, 4, 1)
    FIELD(L0_TX_DIG_TM_102, FORCE_TX_LDO_THRESHOLD, 3, 1)
    FIELD(L0_TX_DIG_TM_102, FORCE_TX_SERIALISER_ENABLE_THRESHOLD, 2, 1)
    FIELD(L0_TX_DIG_TM_102, FORCE_TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 1, 1)
    FIELD(L0_TX_DIG_TM_102, FORCE_TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 1)
REG32(L0_TX_DIG_TM_103, 0x19c)
    FIELD(L0_TX_DIG_TM_103, TX_DIG_TM_103_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_103, FORCE_BG_EN, 7, 1)
    FIELD(L0_TX_DIG_TM_103, FORCE_CALIB_EN, 6, 1)
    FIELD(L0_TX_DIG_TM_103, FORCE_PLL_EN, 5, 1)
    FIELD(L0_TX_DIG_TM_103, FORCE_PSO, 4, 1)
    FIELD(L0_TX_DIG_TM_103, BG_EN, 3, 1)
    FIELD(L0_TX_DIG_TM_103, CALIB_EN, 2, 1)
    FIELD(L0_TX_DIG_TM_103, PLL_EN, 1, 1)
    FIELD(L0_TX_DIG_TM_103, PSO, 0, 1)
REG32(L0_TX_DIG_TM_104, 0x1a0)
    FIELD(L0_TX_DIG_TM_104, TX_DIG_TM_104_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_104, TX_LDO_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_105, 0x1a4)
    FIELD(L0_TX_DIG_TM_105, TX_DIG_TM_105_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_105, TX_MPHY_TRST_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_106, 0x1a8)
    FIELD(L0_TX_DIG_TM_106, TX_DIG_TM_106_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_106, DELAY_CNT_THRESHOLD, 0, 8)
REG32(L0_TX_DIG_TM_107, 0x1ac)
    FIELD(L0_TX_DIG_TM_107, TX_DIG_TM_107_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_107, DIG_BYP42_7_RSVD, 7, 1)
    FIELD(L0_TX_DIG_TM_107, FORCE_P3TOP0_PHYSTATUS_PULSE, 6, 1)
    FIELD(L0_TX_DIG_TM_107, ENABLE_HS_CLK_DIVISION, 5, 1)
    FIELD(L0_TX_DIG_TM_107, TESTDIGOUT_SEL, 1, 4)
    FIELD(L0_TX_DIG_TM_107, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L0_TX_DIG_TM_108, 0x1b0)
    FIELD(L0_TX_DIG_TM_108, TX_DIG_TM_108_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_108, ANA_BYP43_7_RSVD, 7, 1)
    FIELD(L0_TX_DIG_TM_108, TX_EXT_DATA_DELAY, 3, 4)
    FIELD(L0_TX_DIG_TM_108, FORCE_TX_EXT_DATA_DELAY, 2, 1)
    FIELD(L0_TX_DIG_TM_108, FORCE_TX_DATA_DELAY, 1, 1)
    FIELD(L0_TX_DIG_TM_108, FORCE_UPHY_TXPMA_OPMODE, 0, 1)
REG32(L0_TX_DIG_TM_109, 0x1b4)
    FIELD(L0_TX_DIG_TM_109, TX_DIG_TM_109_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_109, UPHY_TXPMA_OPMODE, 0, 8)
REG32(L0_TX_DIG_TM_110, 0x1b8)
    FIELD(L0_TX_DIG_TM_110, TX_DIG_TM_110_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_110, TX_DATA_DELAY, 0, 8)
REG32(L0_TX_DIG_TM_111, 0x1bc)
    FIELD(L0_TX_DIG_TM_111, TX_DIG_TM_111_31_8_RSVD, 24, 8)
    FIELD(L0_TX_DIG_TM_111, TX_DA_SPARE, 0, 8)
REG32(L0_TX_ANA_TM_112, 0x1c0)
    FIELD(L0_TX_ANA_TM_112, TX_ANA_TM_112_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_112, ANA_BYP25_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_112, PIPE_TX_ENABLE_LFPS, 4, 2)
    FIELD(L0_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L0_TX_ANA_TM_112, PIPE_TX_ENABLE_IDLE_MODE, 1, 2)
    FIELD(L0_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L0_TX_ANA_TM_113, 0x1c4)
    FIELD(L0_TX_ANA_TM_113, TX_ANA_TM_113_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_113, MPHY_TX_DRIVERLDO_PROG, 0, 8)
REG32(L0_TX_ANA_TM_114, 0x1c8)
    FIELD(L0_TX_ANA_TM_114, TX_ANA_TM_114_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_114, ANA_BYP27_7_5_RSVD, 5, 3)
    FIELD(L0_TX_ANA_TM_114, FORCE_MPHY_TX_DRIVERLDO_PROG, 4, 1)
    FIELD(L0_TX_ANA_TM_114, MPHY_TX_DRIVERLDO_PROG, 0, 4)
REG32(L0_TX_ANA_TM_115, 0x1cc)
    FIELD(L0_TX_ANA_TM_115, TX_ANA_TM_115_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_115, ANA_BYP28_7_RSVD, 7, 1)
    FIELD(L0_TX_ANA_TM_115, PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 6, 1)
    FIELD(L0_TX_ANA_TM_115, FORCE_PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 5, 1)
    FIELD(L0_TX_ANA_TM_115, TX_PMADIG_DIGITAL_RESET_N, 4, 1)
    FIELD(L0_TX_ANA_TM_115, FORCE_TX_PMADIG_DIGITAL_RESET_N, 3, 1)
    FIELD(L0_TX_ANA_TM_115, TX_ANA_IF_RATE, 1, 2)
    FIELD(L0_TX_ANA_TM_115, FORCE_TX_ANA_IF_RATE, 0, 1)
REG32(L0_TX_ANA_TM_116, 0x1d0)
    FIELD(L0_TX_ANA_TM_116, TX_ANA_TM_116_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_116, ANA_BYP29_7_RSVD, 7, 1)
    FIELD(L0_TX_ANA_TM_116, PIPE_TX_LOCALPRESETINDEX, 3, 4)
    FIELD(L0_TX_ANA_TM_116, FORCE_PIPE_TX_LOCALPRESETINDEX, 2, 1)
    FIELD(L0_TX_ANA_TM_116, MPHY_TX_EN_LANE_LS_CLK, 1, 1)
    FIELD(L0_TX_ANA_TM_116, FORCE_MPHY_TX_EN_LANE_LS_CLK, 0, 1)
REG32(L0_TX_ANA_TM_117, 0x1d4)
    FIELD(L0_TX_ANA_TM_117, TX_ANA_TM_117_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_117, MULTILANE_BYP1_7_6_RSVD, 6, 2)
    FIELD(L0_TX_ANA_TM_117, TX_PCIE_4X_CFG_EN, 5, 1)
    FIELD(L0_TX_ANA_TM_117, FORCE_TX_PCIE_4X_CFG_EN, 4, 1)
    FIELD(L0_TX_ANA_TM_117, TX_PCIE_2X_CFG_EN, 3, 1)
    FIELD(L0_TX_ANA_TM_117, FORCE_TX_PCIE_2X_CFG_EN, 2, 1)
    FIELD(L0_TX_ANA_TM_117, TX_DP_MULTILANE_CFG_EN, 1, 1)
    FIELD(L0_TX_ANA_TM_117, FORCE_TX_DP_MULTILANE_CFG_EN, 0, 1)
REG32(L0_TX_ANA_TM_118, 0x1d8)
    FIELD(L0_TX_ANA_TM_118, TX_ANA_TM_118_31_8_RSVD, 24, 8)
    FIELD(L0_TX_ANA_TM_118, ANA_BYP30_7_4_RSVD, 4, 4)
    FIELD(L0_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_12, 3, 1)
    FIELD(L0_TX_ANA_TM_118, FORCE_TX_DEEMPH_11_6, 2, 1)
    FIELD(L0_TX_ANA_TM_118, FORCE_TX_DEEMPH_5_0, 1, 1)
    FIELD(L0_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_0, 0, 1)
REG32(L0_TXPMA_TM_0, 0x800)
    FIELD(L0_TXPMA_TM_0, TXPMA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_0, TM_TX_ENABLE_SUPPLY_MPHY, 7, 1)
    FIELD(L0_TXPMA_TM_0, TM_FORCE_TX_ENABLE_SUPPLY_MPHY, 6, 1)
    FIELD(L0_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 5, 1)
    FIELD(L0_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 4, 1)
    FIELD(L0_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SA_MODE, 3, 1)
    FIELD(L0_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SA_MODE, 2, 1)
    FIELD(L0_TXPMA_TM_0, TM_MPHY_TX_ENABLE_HS_NT, 1, 1)
    FIELD(L0_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_HS_NT, 0, 1)
REG32(L0_TXPMA_TM_1, 0x804)
    FIELD(L0_TXPMA_TM_1, TXPMA_TM_1_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_1, ANA_MPHY_BYP1_7_4_RSVD, 4, 4)
    FIELD(L0_TXPMA_TM_1, TM_MPHY_TX_HS_DITHER_VAL, 1, 3)
    FIELD(L0_TXPMA_TM_1, TM_FORCE_MPHY_TX_HS_DITHER_VAL, 0, 1)
REG32(L0_TXPMA_TM_2, 0x808)
    FIELD(L0_TXPMA_TM_2, TXPMA_TM_2_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_2, TM_MPHY_TX_DRIVERLDO_PROG_6_0, 1, 7)
    FIELD(L0_TXPMA_TM_2, TM_FORCE_MPHY_TX_DRIVERLDO_PROG, 0, 1)
REG32(L0_TXPMA_TM_3, 0x80c)
    FIELD(L0_TXPMA_TM_3, TXPMA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_3, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMA_TM_3, TM_MPHY_TX_DRIVERLDO_PROG_11_7, 0, 5)
REG32(L0_TXPMA_TM_4, 0x810)
    FIELD(L0_TXPMA_TM_4, TXPMA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_4, TM_PIPE_TX_TX_DATA_WIDTH, 5, 3)
    FIELD(L0_TXPMA_TM_4, TM_FORCE_PIPE_TX_TX_DATA_WIDTH, 4, 1)
    FIELD(L0_TXPMA_TM_4, TM_PIPE_TX_POWERDOWN_VCM_HOLD, 3, 1)
    FIELD(L0_TXPMA_TM_4, TM_FORCE_PIPE_TX_POWERDOWN_VCM_HOLD, 2, 1)
    FIELD(L0_TXPMA_TM_4, TM_PIPE_TX_ANABOOST_POWERDOWN, 1, 1)
    FIELD(L0_TXPMA_TM_4, ANA_PIPE_BYP0_0_RSVD, 0, 1)
REG32(L0_TXPMA_TM_5, 0x814)
    FIELD(L0_TXPMA_TM_5, TXPMA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_5, ANA_BSCAN_BYP0_7_4_RSVD, 4, 4)
    FIELD(L0_TXPMA_TM_5, TM_TX_BSCAN_SEL, 3, 1)
    FIELD(L0_TXPMA_TM_5, TM_FORCE_TX_BSCAN_SEL, 2, 1)
    FIELD(L0_TXPMA_TM_5, TM_TX_BSCAN_DATA, 1, 1)
    FIELD(L0_TXPMA_TM_5, TM_FORCE_TX_BSCAN_DATA, 0, 1)
REG32(L0_TXPMA_TM_6, 0x818)
    FIELD(L0_TXPMA_TM_6, TXPMA_TM_6_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_6, TM_TX_ENABLE_ISI_LPBK, 7, 1)
    FIELD(L0_TXPMA_TM_6, TM_FORCE_TX_ENABLE_ISI_LPBK, 6, 1)
    FIELD(L0_TXPMA_TM_6, TM_TX_ENABLE_SER_LPBK, 5, 1)
    FIELD(L0_TXPMA_TM_6, TM_FORCE_TX_ENABLE_SER_LPBK, 4, 1)
    FIELD(L0_TXPMA_TM_6, TM_TX_ENABLE_RX_LIN_LPBK, 3, 1)
    FIELD(L0_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RX_LIN_LPBK, 2, 1)
    FIELD(L0_TXPMA_TM_6, TM_TX_ENABLE_RCRVD_DATA_LPBK, 1, 1)
    FIELD(L0_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RCRVD_DATA_LPBK, 0, 1)
REG32(L0_TXPMA_TM_7, 0x81c)
    FIELD(L0_TXPMA_TM_7, TXPMA_TM_7_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_UPHY, 7, 1)
    FIELD(L0_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_UPHY, 6, 1)
    FIELD(L0_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_SERIALIZER, 5, 1)
    FIELD(L0_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L0_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_PIPE, 3, 1)
    FIELD(L0_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_PIPE, 2, 1)
    FIELD(L0_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_HSCLK, 1, 1)
    FIELD(L0_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_HSCLK, 0, 1)
REG32(L0_TXPMA_TM_8, 0x820)
    FIELD(L0_TXPMA_TM_8, TXPMA_TM_8_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_8, ANA_LS_LFPS_BYP0_7_2_RSVD, 2, 6)
    FIELD(L0_TXPMA_TM_8, TM_TX_LS_LFPS_DATA, 1, 1)
    FIELD(L0_TXPMA_TM_8, TM_FORCE_TX_LS_LFPS_DATA, 0, 1)
REG32(L0_TXPMA_TM_9, 0x824)
    FIELD(L0_TXPMA_TM_9, TXPMA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_9, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L0_TXPMA_TM_9, TM_TX_SERIALIZER_MODE, 6, 1)
    FIELD(L0_TXPMA_TM_9, TM_FORCE_TX_SERIALIZER_MODE, 5, 1)
    FIELD(L0_TXPMA_TM_9, TM_TX_ENABLE_HSCLK_DIVISION, 3, 2)
    FIELD(L0_TXPMA_TM_9, TM_FORCE_TX_ENABLE_HSCLK_DIVISION, 2, 1)
    FIELD(L0_TXPMA_TM_9, TM_TX_DRIVER_POLARITY, 1, 1)
    FIELD(L0_TXPMA_TM_9, TM_FORCE_TX_DRIVER_POLARITY, 0, 1)
REG32(L0_TXPMA_TM_10, 0x828)
    FIELD(L0_TXPMA_TM_10, TXPMA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_10, ANA_MISC1_7_6_RSVD, 6, 2)
    FIELD(L0_TXPMA_TM_10, TM_TX_ENABLE_LOWLEAKAGE, 5, 1)
    FIELD(L0_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LOWLEAKAGE, 4, 1)
    FIELD(L0_TXPMA_TM_10, TM_TX_ENABLE_REF, 3, 1)
    FIELD(L0_TXPMA_TM_10, TM_FORCE_TX_ENABLE_REF, 2, 1)
    FIELD(L0_TXPMA_TM_10, TM_TX_ENABLE_LDO, 1, 1)
    FIELD(L0_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LDO, 0, 1)
REG32(L0_TXPMA_TM_11, 0x82c)
    FIELD(L0_TXPMA_TM_11, TXPMA_TM_11_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_11, ANA_VCM_BYP0_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMA_TM_11, TM_TX_VCMHOLD_PROG, 1, 4)
    FIELD(L0_TXPMA_TM_11, TM_TX_VCMHOLD_OBSRV, 0, 1)
REG32(L0_TXPMA_TM_12, 0x830)
    FIELD(L0_TXPMA_TM_12, TXPMA_TM_12_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_12, TM_TX_SER_POWERISLAND_OBSRV, 5, 3)
    FIELD(L0_TXPMA_TM_12, TM_TX_CLK_POWERISLAND_OBSRV, 1, 4)
    FIELD(L0_TXPMA_TM_12, ANA_PWR_ISLAND_BYP0_0_RSVD, 0, 1)
REG32(L0_TXPMA_TM_13, 0x834)
    FIELD(L0_TXPMA_TM_13, TXPMA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_13, TM_TX_POWERISLAND_OBSRV, 0, 8)
REG32(L0_TXPMA_TM_14, 0x838)
    FIELD(L0_TXPMA_TM_14, TXPMA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_14, ANA_MISC2_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMA_TM_14, TM_TX_POWERISLAND_OBSRV, 3, 2)
    FIELD(L0_TXPMA_TM_14, PIPE_TM_TX_ANABOOST_POWER_OBSRV, 2, 1)
    FIELD(L0_TXPMA_TM_14, MPHY_TM_TX_ENABLE_DRIVERLDO_OBSRV, 1, 1)
    FIELD(L0_TXPMA_TM_14, MPHY_TM_TX_DRIVERLDO_REDC_SINKIQ, 0, 1)
REG32(L0_TXPMA_TM_15, 0x83c)
    FIELD(L0_TXPMA_TM_15, TXPMA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_15, PIPE_TM_TX_ANABOOST_PROG_7_0, 0, 8)
REG32(L0_TXPMA_TM_16, 0x840)
    FIELD(L0_TXPMA_TM_16, TXPMA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_16, PIPE_TM_TX_ANABOOST_PROG_15_8, 0, 8)
REG32(L0_TXPMA_TM_17, 0x844)
    FIELD(L0_TXPMA_TM_17, TXPMA_TM_17_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_17, TM_TX_RSVD2, 0, 8)
REG32(L0_TXPMA_TM_18, 0x848)
    FIELD(L0_TXPMA_TM_18, TXPMA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_18, TM_TX_ENABLE_VDDREF_CORE, 7, 1)
    FIELD(L0_TXPMA_TM_18, TM_FORCE_TX_ENABLE_VDDREF_CORE, 6, 1)
    FIELD(L0_TXPMA_TM_18, TM_TX_ENABLE_RBYRFB_CORE, 5, 1)
    FIELD(L0_TXPMA_TM_18, TM_FORCE_TX_ENABLE_RBYRFB_CORE, 4, 1)
    FIELD(L0_TXPMA_TM_18, TM_TX_ENABLE_BGREF_CORE, 3, 1)
    FIELD(L0_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGREF_CORE, 2, 1)
    FIELD(L0_TXPMA_TM_18, TM_TX_ENABLE_BGFB_CORE, 1, 1)
    FIELD(L0_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGFB_CORE, 0, 1)
REG32(L0_TXPMA_TM_19, 0x84c)
    FIELD(L0_TXPMA_TM_19, TXPMA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_19, ANA_SATA_BYP0_RSVD, 6, 2)
    FIELD(L0_TXPMA_TM_19, TM_ZDIF_TX_SATA_OFFSET, 0, 6)
REG32(L0_TXPMA_TM_20, 0x850)
    FIELD(L0_TXPMA_TM_20, TXPMA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_20, TM_TX_ELEC_IDLE_DELAY_ENTRY, 0, 8)
REG32(L0_TXPMA_TM_21, 0x854)
    FIELD(L0_TXPMA_TM_21, TXPMA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_21, TM_TX_ELEC_IDLE_DELAY_EXIT, 0, 8)
REG32(L0_TXPMA_TM_22, 0x858)
    FIELD(L0_TXPMA_TM_22, TXPMA_TM_22_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_22, TM_TX_ENABLE_LFPS_DELAY_ENTRY, 0, 8)
REG32(L0_TXPMA_TM_23, 0x85c)
    FIELD(L0_TXPMA_TM_23, TXPMA_TM_23_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_23, TM_TX_ENABLE_LFPS_DELAY_EXIT, 0, 8)
REG32(L0_TXPMA_TM_24, 0x860)
    FIELD(L0_TXPMA_TM_24, TXPMA_TM_24_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_24, ANA_MISC6_7_RSVD, 7, 1)
    FIELD(L0_TXPMA_TM_24, TM_TX_EN_ANA_SUBLP_MODE, 6, 1)
    FIELD(L0_TXPMA_TM_24, TM_FORCE_TX_EN_ANA_SUBLP_MODE, 5, 1)
    FIELD(L0_TXPMA_TM_24, TM_TX_EN_DIG_SUBLP_MODE, 4, 1)
    FIELD(L0_TXPMA_TM_24, TM_FORCE_TX_EN_DIG_SUBLP_MODE, 3, 1)
    FIELD(L0_TXPMA_TM_24, TM_TX_DP_LVLDB0_OVRRD, 2, 1)
    FIELD(L0_TXPMA_TM_24, TM_FORCE_TX_DP_LVLDB0_OVRRD, 1, 1)
    FIELD(L0_TXPMA_TM_24, TM_TX_CLOCK_STOP_REQ, 0, 1)
REG32(L0_TXPMA_TM_25, 0x864)
    FIELD(L0_TXPMA_TM_25, TXPMA_TM_25_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_25, ANA_MISC6_7_6_RSVD, 6, 2)
    FIELD(L0_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_PLL, 5, 1)
    FIELD(L0_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_RX, 4, 1)
    FIELD(L0_TXPMA_TM_25, TM_TX_LANE_LNG, 3, 1)
    FIELD(L0_TXPMA_TM_25, TM_FORCE_TX_LANE_LNG, 2, 1)
    FIELD(L0_TXPMA_TM_25, TM_TX_LANE_MASTER, 1, 1)
    FIELD(L0_TXPMA_TM_25, TM_FORCE_TX_LANE_MASTER, 0, 1)
REG32(L0_TXPMA_TM_26, 0x868)
    FIELD(L0_TXPMA_TM_26, TXPMA_TM_26_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_26, TM_TXPMD_APB_RESET_DELAY, 0, 8)
REG32(L0_TXPMA_TM_27, 0x86c)
    FIELD(L0_TXPMA_TM_27, TXPMA_TM_27_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_TM_27, TM_BSCAN_MODE_EN, 7, 1)
    FIELD(L0_TXPMA_TM_27, TM_FORCE_BSCAN_MODE_EN, 6, 1)
    FIELD(L0_TXPMA_TM_27, TM_PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L0_TXPMA_TM_27, TM_FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L0_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L0_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_LFPS, 2, 1)
    FIELD(L0_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_IDLE_MODE, 1, 1)
    FIELD(L0_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L0_TXPMA_ST_0, 0xb00)
    FIELD(L0_TXPMA_ST_0, TXPMA_ST_0_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_0, TX_PHY_MODE, 4, 4)
    FIELD(L0_TXPMA_ST_0, TX_PHY_GEAR, 0, 4)
REG32(L0_TXPMA_ST_1, 0xb04)
    FIELD(L0_TXPMA_ST_1, TXPMA_ST_1_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_1, TX_ENABLE_HSCLK_DIVISION, 6, 2)
    FIELD(L0_TXPMA_ST_1, PIPE_TX_TRISTATE, 5, 1)
    FIELD(L0_TXPMA_ST_1, TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L0_TXPMA_ST_1, TX_ENABLE_SUPPLY_HSCLK, 3, 1)
    FIELD(L0_TXPMA_ST_1, TX_ENABLE_SUPPLY_MPHY, 2, 1)
    FIELD(L0_TXPMA_ST_1, TX_ENABLE_SUPPLY_PIPE, 1, 1)
    FIELD(L0_TXPMA_ST_1, TX_ENABLE_SUPPLY_UPHY, 0, 1)
REG32(L0_TXPMA_ST_2, 0xb08)
    FIELD(L0_TXPMA_ST_2, TXPMA_ST_2_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_2, ANA_ST2_7_5_SPARE, 5, 3)
    FIELD(L0_TXPMA_ST_2, PIPE_TX_ENABLE_RXDET, 4, 1)
    FIELD(L0_TXPMA_ST_2, PIPE_TX_ENABLE_IDLE_MODE, 2, 2)
    FIELD(L0_TXPMA_ST_2, PIPE_TX_ENABLE_LFPS, 0, 2)
REG32(L0_TXPMA_ST_3, 0xb0c)
    FIELD(L0_TXPMA_ST_3, TXPMA_ST_3_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_3, ANA_ST3_7_6_SPARE, 6, 2)
    FIELD(L0_TXPMA_ST_3, TX_LSEG_DN_RESCAL_CODE, 0, 6)
REG32(L0_TXPMA_ST_4, 0xb10)
    FIELD(L0_TXPMA_ST_4, TXPMA_ST_4_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_4, ANA_ST4_7_6_SPARE, 6, 2)
    FIELD(L0_TXPMA_ST_4, TX_USEG_DP_RESCAL_CODE, 0, 6)
REG32(L0_TXPMA_ST_5, 0xb14)
    FIELD(L0_TXPMA_ST_5, TXPMA_ST_5_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_5, ANA_ST5_7_6_SPARE, 6, 2)
    FIELD(L0_TXPMA_ST_5, PIPE_TX_LOCALFS, 0, 6)
REG32(L0_TXPMA_ST_6, 0xb18)
    FIELD(L0_TXPMA_ST_6, TXPMA_ST_6_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_6, ANA_ST6_7_SPARE, 7, 1)
    FIELD(L0_TXPMA_ST_6, PIPE_TX_LOCALTXCOEFFICIENTSVALID, 6, 1)
    FIELD(L0_TXPMA_ST_6, PIPE_TX_LOCALLF, 0, 6)
REG32(L0_TXPMA_ST_7, 0xb1c)
    FIELD(L0_TXPMA_ST_7, TXPMA_ST_7_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_7, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_7_0, 0, 8)
REG32(L0_TXPMA_ST_8, 0xb20)
    FIELD(L0_TXPMA_ST_8, TXPMA_ST_8_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_8, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_15_8, 0, 8)
REG32(L0_TXPMA_ST_9, 0xb24)
    FIELD(L0_TXPMA_ST_9, TXPMA_ST_9_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMA_ST_9, ANA_ST9_7_2_SPARE, 2, 6)
    FIELD(L0_TXPMA_ST_9, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_17_16, 0, 2)
REG32(L0_TXPMD_TM_0, 0xc00)
    FIELD(L0_TXPMD_TM_0, TXPMD_TM_0_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_1, 0xc04)
    FIELD(L0_TXPMD_TM_1, TXPMD_TM_1_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_2, 0xc08)
    FIELD(L0_TXPMD_TM_2, TXPMD_TM_2_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_3, 0xc0c)
    FIELD(L0_TXPMD_TM_3, TXPMD_TM_3_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_4, 0xc10)
    FIELD(L0_TXPMD_TM_4, TXPMD_TM_4_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_5, 0xc14)
    FIELD(L0_TXPMD_TM_5, TXPMD_TM_5_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_6, 0xc18)
    FIELD(L0_TXPMD_TM_6, TXPMD_TM_6_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_7, 0xc1c)
    FIELD(L0_TXPMD_TM_7, TXPMD_TM_7_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_8, 0xc20)
    FIELD(L0_TXPMD_TM_8, TXPMD_TM_8_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_9, 0xc24)
    FIELD(L0_TXPMD_TM_9, TXPMD_TM_9_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_10, 0xc28)
    FIELD(L0_TXPMD_TM_10, TXPMD_TM_10_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_11, 0xc2c)
    FIELD(L0_TXPMD_TM_11, TXPMD_TM_11_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_12, 0xc30)
    FIELD(L0_TXPMD_TM_12, TXPMD_TM_12_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_13, 0xc34)
    FIELD(L0_TXPMD_TM_13, TXPMD_TM_13_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_14, 0xc38)
    FIELD(L0_TXPMD_TM_14, TXPMD_TM_14_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_15, 0xc3c)
    FIELD(L0_TXPMD_TM_15, TXPMD_TM_15_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_16, 0xc40)
    FIELD(L0_TXPMD_TM_16, TXPMD_TM_16_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_17, 0xc44)
    FIELD(L0_TXPMD_TM_17, TXPMD_TM_17_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_18, 0xc48)
    FIELD(L0_TXPMD_TM_18, TXPMD_TM_18_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_19, 0xc4c)
    FIELD(L0_TXPMD_TM_19, TXPMD_TM_19_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_20, 0xc50)
    FIELD(L0_TXPMD_TM_20, TXPMD_TM_20_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_21, 0xc54)
    FIELD(L0_TXPMD_TM_21, TXPMD_TM_21_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_22, 0xc58)
    FIELD(L0_TXPMD_TM_22, TXPMD_TM_22_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_23, 0xc5c)
    FIELD(L0_TXPMD_TM_23, TXPMD_TM_23_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_24, 0xc60)
    FIELD(L0_TXPMD_TM_24, TXPMD_TM_24_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_25, 0xc64)
    FIELD(L0_TXPMD_TM_25, TXPMD_TM_25_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_26, 0xc68)
    FIELD(L0_TXPMD_TM_26, TXPMD_TM_26_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_27, 0xc6c)
    FIELD(L0_TXPMD_TM_27, TXPMD_TM_27_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_28, 0xc70)
    FIELD(L0_TXPMD_TM_28, TXPMD_TM_28_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_29, 0xc74)
    FIELD(L0_TXPMD_TM_29, TXPMD_TM_29_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_30, 0xc78)
    FIELD(L0_TXPMD_TM_30, TXPMD_TM_30_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L0_TXPMD_TM_31, 0xc7c)
    FIELD(L0_TXPMD_TM_31, TXPMD_TM_31_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L0_TXPMD_TM_32, 0xc80)
    FIELD(L0_TXPMD_TM_32, TXPMD_TM_32_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_32, PIPE_TM_TX_PRE_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L0_TXPMD_TM_33, 0xc84)
    FIELD(L0_TXPMD_TM_33, TXPMD_TM_33_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_33, PIPE_TM_TX_PRE_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L0_TXPMD_TM_34, 0xc88)
    FIELD(L0_TXPMD_TM_34, TXPMD_TM_34_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_34, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L0_TXPMD_TM_35, 0xc8c)
    FIELD(L0_TXPMD_TM_35, TXPMD_TM_35_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_35, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L0_TXPMD_TM_36, 0xc90)
    FIELD(L0_TXPMD_TM_36, TXPMD_TM_36_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_36, PIPE_TM_TX_POST_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L0_TXPMD_TM_37, 0xc94)
    FIELD(L0_TXPMD_TM_37, TXPMD_TM_37_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_37, PIPE_TM_TX_POST_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L0_TXPMD_TM_38, 0xc98)
    FIELD(L0_TXPMD_TM_38, TXPMD_TM_38_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_38, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L0_TXPMD_TM_38, PIPE_TM_TX_ENABLE_SWNW_CNTRL_BYP, 6, 1)
    FIELD(L0_TXPMD_TM_38, PIPE_TM_TX_ENABLE_TRISTATE_BYP, 5, 1)
    FIELD(L0_TXPMD_TM_38, PIPE_TM_TX_TRISTATE, 4, 1)
    FIELD(L0_TXPMD_TM_38, TM_TX_DRIVERLDO_RXDET_BYP, 3, 1)
    FIELD(L0_TXPMD_TM_38, TM_TX_DRIVERLDO_IDLE_BYP, 2, 1)
    FIELD(L0_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_RXDET_BYP, 1, 1)
    FIELD(L0_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_IDLE_BYP, 0, 1)
REG32(L0_TXPMD_TM_39, 0xc9c)
    FIELD(L0_TXPMD_TM_39, TXPMD_TM_39_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_39, ANA_MPHY_BYP0_7_3_RSVD, 3, 5)
    FIELD(L0_TXPMD_TM_39, MPHY_TM_TX_OVRD_DEEMPH_TRIM, 2, 1)
    FIELD(L0_TXPMD_TM_39, MPHY_TM_TX_ENABLE_DEEMPH, 1, 1)
    FIELD(L0_TXPMD_TM_39, MPHY_TM_TX_OVRD_ENABLE_DEEMPH, 0, 1)
REG32(L0_TXPMD_TM_40, 0xca0)
    FIELD(L0_TXPMD_TM_40, TXPMD_TM_40_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_40, MPHY_TM_TX_DEEMPH_TRIM_7_0, 0, 8)
REG32(L0_TXPMD_TM_41, 0xca4)
    FIELD(L0_TXPMD_TM_41, TXPMD_TM_41_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_41, MPHY_TM_TX_DEEMPH_TRIM_15_8, 0, 8)
REG32(L0_TXPMD_TM_42, 0xca8)
    FIELD(L0_TXPMD_TM_42, TXPMD_TM_42_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_42, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L0_TXPMD_TM_42, MPHY_TM_TX_OVRD_LS_DATA, 1, 4)
    FIELD(L0_TXPMD_TM_42, MPHY_TM_TX_ENABLE_OVRD_LS_DATA, 0, 1)
REG32(L0_TXPMD_TM_43, 0xcac)
    FIELD(L0_TXPMD_TM_43, TXPMD_TM_43_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_43, ANA_MPHY_BYP4_7_4_RSVD, 4, 4)
    FIELD(L0_TXPMD_TM_43, MPHY_TM_TX_OVRD_LS_DATA_BAR, 0, 4)
REG32(L0_TXPMD_TM_44, 0xcb0)
    FIELD(L0_TXPMD_TM_44, TXPMD_TM_44_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_44, ANA_PIPE_BYP38_7_6_RSVD, 6, 2)
    FIELD(L0_TXPMD_TM_44, PIPE_TM_TX_EN_PRE_LFPS_PATH, 5, 1)
    FIELD(L0_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_PRE_LFPS_PATH, 4, 1)
    FIELD(L0_TXPMD_TM_44, PIPE_TM_TX_EN_POST_LFPS_PATH, 3, 1)
    FIELD(L0_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_POST_LFPS_PATH, 2, 1)
    FIELD(L0_TXPMD_TM_44, PIPE_TM_TX_EN_MAIN_LFPS_PATH, 1, 1)
    FIELD(L0_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_MAIN_LFPS_PATH, 0, 1)
REG32(L0_TXPMD_TM_45, 0xcb4)
    FIELD(L0_TXPMD_TM_45, TXPMD_TM_45_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_45, ANA_DP_BYP0_7_6_RSVD, 6, 2)
    FIELD(L0_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST2_PATH, 5, 1)
    FIELD(L0_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST2_PATH, 4, 1)
    FIELD(L0_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST1_PATH, 3, 1)
    FIELD(L0_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST1_PATH, 2, 1)
    FIELD(L0_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L0_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_MAIN_PATH, 0, 1)
REG32(L0_TXPMD_TM_46, 0xcb8)
    FIELD(L0_TXPMD_TM_46, TXPMD_TM_46_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_46, ANA_PIPE_BYP39_7_6_RSVD, 6, 2)
    FIELD(L0_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_PRE_PATH, 5, 1)
    FIELD(L0_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_PRE_PATH, 4, 1)
    FIELD(L0_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_POST_PATH, 3, 1)
    FIELD(L0_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_POST_PATH, 2, 1)
    FIELD(L0_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L0_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_MAIN_PATH, 0, 1)
REG32(L0_TXPMD_TM_47, 0xcbc)
    FIELD(L0_TXPMD_TM_47, TXPMD_TM_47_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_47, TM_TX_RSVD1, 0, 8)
REG32(L0_TXPMD_TM_48, 0xcc0)
    FIELD(L0_TXPMD_TM_48, TXPMD_TM_48_31_8_RSVD, 24, 8)
    FIELD(L0_TXPMD_TM_48, ANA_MISC2_7_6_RSVD, 6, 2)
    FIELD(L0_TXPMD_TM_48, TM_FORCE_RESULTANT_MARGINING_FACTOR, 5, 1)
    FIELD(L0_TXPMD_TM_48, TM_RESULTANT_MARGINING_FACTOR, 0, 5)
REG32(L0_TM_ANA_BYP_1, 0x1004)
    FIELD(L0_TM_ANA_BYP_1, TM_ANA_BYP_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_1, MPHY_PWM_DES_PDZ, 7, 1)
    FIELD(L0_TM_ANA_BYP_1, FORCE_MPHY_PWM_DES_PDZ, 6, 1)
    FIELD(L0_TM_ANA_BYP_1, MPHY_PWMB_SYS_ENABLE, 5, 1)
    FIELD(L0_TM_ANA_BYP_1, FORCE_MPHY_PWMB_SYS_ENABLE, 4, 1)
    FIELD(L0_TM_ANA_BYP_1, MPHY_PSO_SQUELCH, 3, 1)
    FIELD(L0_TM_ANA_BYP_1, FORCE_MPHY_PSO_SQUELCH, 2, 1)
    FIELD(L0_TM_ANA_BYP_1, MPHY_PSO_LSRX, 1, 1)
    FIELD(L0_TM_ANA_BYP_1, FORCE_MPHY_PSO_LSRX, 0, 1)
REG32(L0_TM_ANA_BYP_2, 0x1008)
    FIELD(L0_TM_ANA_BYP_2, TM_ANA_BYP_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_2, MPHY_PWM_LSPREAMP_PD, 7, 1)
    FIELD(L0_TM_ANA_BYP_2, FORCE_MPHY_PWM_LSPREAMP_PD, 6, 1)
    FIELD(L0_TM_ANA_BYP_2, MPHY_PWM_GEAR_SEL, 3, 3)
    FIELD(L0_TM_ANA_BYP_2, FORCE_MPHY_PWM_GEAR_SEL, 2, 1)
    FIELD(L0_TM_ANA_BYP_2, MPHY_PWM_DET_PD, 1, 1)
    FIELD(L0_TM_ANA_BYP_2, FORCE_MPHY_PWM_DET_PD, 0, 1)
REG32(L0_TM_ANA_BYP_3, 0x100c)
    FIELD(L0_TM_ANA_BYP_3, TM_ANA_BYP_3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_3, MPHY_RX_MASK_BURST_START, 7, 1)
    FIELD(L0_TM_ANA_BYP_3, FORCE_MPHY_RX_MASK_BURST_START, 6, 1)
    FIELD(L0_TM_ANA_BYP_3, MPHY_RX_GATE_SYMBOL_CLK, 5, 1)
    FIELD(L0_TM_ANA_BYP_3, FORCE_MPHY_RX_GATE_SYMBOL_CLK, 4, 1)
    FIELD(L0_TM_ANA_BYP_3, MPHY_PWM_PREAMP_BIAS_PD, 3, 1)
    FIELD(L0_TM_ANA_BYP_3, FORCE_MPHY_PWM_PREAMP_BIAS_PD, 2, 1)
    FIELD(L0_TM_ANA_BYP_3, MPHY_PWM_LSPREAMP_STANDBYSLEEPSTALL, 1, 1)
    FIELD(L0_TM_ANA_BYP_3, FORCE_MPHY_PWM_LSPREAMP_STANDBYSLEEPSTAL, 0, 1)
REG32(L0_TM_ANA_BYP_4, 0x1010)
    FIELD(L0_TM_ANA_BYP_4, TM_ANA_BYP_4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_4, HSRX_RSTB, 7, 1)
    FIELD(L0_TM_ANA_BYP_4, FORCE_HSRX_RSTB, 6, 1)
    FIELD(L0_TM_ANA_BYP_4, MPHY_RX_TERM_ENABLE, 5, 1)
    FIELD(L0_TM_ANA_BYP_4, FORCE_MPHY_RX_TERM_ENABLE, 4, 1)
    FIELD(L0_TM_ANA_BYP_4, MPHY_RX_MUX_TYP1B_TYP2, 3, 1)
    FIELD(L0_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_TYP1B_TYP2, 2, 1)
    FIELD(L0_TM_ANA_BYP_4, MPHY_RX_MUX_HSB_LS, 1, 1)
    FIELD(L0_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_HSB_LS, 0, 1)
REG32(L0_TM_ANA_BYP_5, 0x1014)
    FIELD(L0_TM_ANA_BYP_5, TM_ANA_BYP_5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_5, MPHY_SQ_SWAP_POLARITY, 5, 1)
    FIELD(L0_TM_ANA_BYP_5, FORCE_MPHY_SQ_SWAP_POLARITY, 4, 1)
    FIELD(L0_TM_ANA_BYP_5, MPHY_SQ_PD, 3, 1)
    FIELD(L0_TM_ANA_BYP_5, FORCE_MPHY_SQ_PD, 2, 1)
    FIELD(L0_TM_ANA_BYP_5, MPHY_SQ_DETECTOR_PD, 1, 1)
    FIELD(L0_TM_ANA_BYP_5, FORCE_MPHY_SQ_DETECTOR_PD, 0, 1)
REG32(L0_TM_ANA_BYP_7, 0x1018)
    FIELD(L0_TM_ANA_BYP_7, TM_ANA_BYP_7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_7, PIPE_RXEQTRAINING, 7, 1)
    FIELD(L0_TM_ANA_BYP_7, FORCE_PIPE_RXEQTRAINING, 6, 1)
    FIELD(L0_TM_ANA_BYP_7, PIPE_RX_TERM_ENABLE, 5, 1)
    FIELD(L0_TM_ANA_BYP_7, FORCE_PIPE_RX_TERM_ENABLE, 4, 1)
REG32(L0_TM_ANA_BYP_8, 0x101c)
    FIELD(L0_TM_ANA_BYP_8, TM_ANA_BYP_8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 7, 1)
    FIELD(L0_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 6, 1)
    FIELD(L0_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 5, 1)
    FIELD(L0_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 4, 1)
    FIELD(L0_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 3, 1)
    FIELD(L0_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 2, 1)
    FIELD(L0_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 1, 1)
    FIELD(L0_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 0, 1)
REG32(L0_TM_ANA_BYP_9, 0x1020)
    FIELD(L0_TM_ANA_BYP_9, TM_ANA_BYP_9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_9, UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 7, 1)
    FIELD(L0_TM_ANA_BYP_9, FORCE_UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 6, 1)
    FIELD(L0_TM_ANA_BYP_9, UPHY_PSO_SAMP_LPBK, 5, 1)
    FIELD(L0_TM_ANA_BYP_9, FORCE_UPHY_PSO_SAMP_LPBK, 4, 1)
    FIELD(L0_TM_ANA_BYP_9, UPHY_EQ_LPBK_ENABLE_CORE, 3, 1)
    FIELD(L0_TM_ANA_BYP_9, FORCE_UPHY_EQ_LPBK_ENABLE_CORE, 2, 1)
    FIELD(L0_TM_ANA_BYP_9, UPHY_EQ_AC_DCZ_COUPLED_CORE, 1, 1)
    FIELD(L0_TM_ANA_BYP_9, FORCE_UPHY_EQ_AC_DCZ_COUPLED_CORE, 0, 1)
REG32(L0_TM_ANA_BYP_10, 0x1024)
    FIELD(L0_TM_ANA_BYP_10, TM_ANA_BYP_10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_10, UPHY_LPBK_CLK_DATA_SEL, 5, 1)
    FIELD(L0_TM_ANA_BYP_10, UPHY_LPBK_CENTRE_EDGEZ_ENABLE_CORE, 4, 1)
    FIELD(L0_TM_ANA_BYP_10, UPHY_HSRX_LPBK_SEL, 1, 3)
    FIELD(L0_TM_ANA_BYP_10, FORCE_UPHY_HSRX_LPBK_SEL, 0, 1)
REG32(L0_TM_ANA_BYP_11, 0x1028)
    FIELD(L0_TM_ANA_BYP_11, TM_ANA_BYP_11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_11, UPHY_PD_PI_DIV_PATH, 5, 1)
    FIELD(L0_TM_ANA_BYP_11, UPHY_PSO_CLK_LANE, 4, 1)
    FIELD(L0_TM_ANA_BYP_11, FORCE_UPHY_PSO_CLK_LANE, 3, 1)
    FIELD(L0_TM_ANA_BYP_11, UPHY_HSCLK_DIVISION_FACTOR, 1, 2)
    FIELD(L0_TM_ANA_BYP_11, FORCE_UPHY_HSCLK_DIVISION_FACTOR, 0, 1)
REG32(L0_TM_ANA_BYP_12, 0x102c)
    FIELD(L0_TM_ANA_BYP_12, TM_ANA_BYP_12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_12, UPHY_PSO_HSRXDIG, 7, 1)
    FIELD(L0_TM_ANA_BYP_12, FORCE_UPHY_PSO_HSRXDIG, 6, 1)
    FIELD(L0_TM_ANA_BYP_12, UPHY_PDN_HS_DES, 5, 1)
    FIELD(L0_TM_ANA_BYP_12, FORCE_UPHY_PDN_HS_DES, 4, 1)
    FIELD(L0_TM_ANA_BYP_12, UPHY_RST_GF_MUX, 3, 1)
    FIELD(L0_TM_ANA_BYP_12, FORCE_UPHY_RST_GF_MUX, 2, 1)
    FIELD(L0_TM_ANA_BYP_12, UPHY_ENABLE_CDR, 1, 1)
    FIELD(L0_TM_ANA_BYP_12, FORCE_UPHY_ENABLE_CDR, 0, 1)
REG32(L0_TM_ANA_BYP_13, 0x1030)
    FIELD(L0_TM_ANA_BYP_13, TM_ANA_BYP_13_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_13, UPHY_PSO_SAMP_FLOPS, 1, 1)
    FIELD(L0_TM_ANA_BYP_13, FORCE_UPHY_PSO_SAMP_FLOPS, 0, 1)
REG32(L0_TM_ANA_BYP_14, 0x1034)
    FIELD(L0_TM_ANA_BYP_14, TM_ANA_BYP_14_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_14, UPHY_PSO_EPI, 7, 1)
    FIELD(L0_TM_ANA_BYP_14, FORCE_UPHY_PSO_EPI, 6, 1)
    FIELD(L0_TM_ANA_BYP_14, UPHY_PD_SAMP_C2C_ECLK, 5, 1)
    FIELD(L0_TM_ANA_BYP_14, FORCE_UPHY_PD_SAMP_C2C_ECLK, 4, 1)
    FIELD(L0_TM_ANA_BYP_14, UPHY_PSO_IQPI, 1, 1)
    FIELD(L0_TM_ANA_BYP_14, FORCE_UPHY_PSO_IQPI, 0, 1)
REG32(L0_TM_ANA_BYP_15, 0x1038)
    FIELD(L0_TM_ANA_BYP_15, TM_ANA_BYP_15_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_15, UPHY_ENABLE_LOW_LEAKAGE, 7, 1)
    FIELD(L0_TM_ANA_BYP_15, FORCE_UPHY_ENABLE_LOW_LEAKAGE, 6, 1)
    FIELD(L0_TM_ANA_BYP_15, UPHY_PD_SAMP_C2C, 5, 1)
    FIELD(L0_TM_ANA_BYP_15, FORCE_UPHY_PD_SAMP_C2C, 4, 1)
    FIELD(L0_TM_ANA_BYP_15, UPHY_PSO_CORE_EQ, 3, 1)
    FIELD(L0_TM_ANA_BYP_15, FORCE_UPHY_PSO_CORE_EQ, 2, 1)
    FIELD(L0_TM_ANA_BYP_15, UPHY_PSO_IO_EQ, 1, 1)
    FIELD(L0_TM_ANA_BYP_15, FORCE_UPHY_PSO_IO_EQ, 0, 1)
REG32(L0_TM_ANA_BYP_16, 0x103c)
    FIELD(L0_TM_ANA_BYP_16, TM_ANA_BYP_16_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_16, UPHY_PSO_SIGDET, 7, 1)
    FIELD(L0_TM_ANA_BYP_16, FORCE_UPHY_PSO_SIGDET, 6, 1)
    FIELD(L0_TM_ANA_BYP_16, UPHY_RX_LANE_POLARITY_SWAP, 5, 1)
    FIELD(L0_TM_ANA_BYP_16, FORCE_UPHY_RX_LANE_POLARITY_SWAP, 4, 1)
    FIELD(L0_TM_ANA_BYP_16, UPHY_RUN_CALIB, 3, 1)
    FIELD(L0_TM_ANA_BYP_16, FORCE_UPHY_RUN_CALIB, 2, 1)
    FIELD(L0_TM_ANA_BYP_16, UPHY_RESTORE_CALCODE, 1, 1)
    FIELD(L0_TM_ANA_BYP_16, FORCE_UPHY_RESTORE_CALCODE, 0, 1)
REG32(L0_TM_ANA_BYP_17, 0x1040)
    FIELD(L0_TM_ANA_BYP_17, TM_ANA_BYP_17_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_17, UPHY_STARTLOOP_PLL, 6, 1)
    FIELD(L0_TM_ANA_BYP_17, FORCE_UPHY_STARTLOOP_PLL, 5, 1)
    FIELD(L0_TM_ANA_BYP_17, UPHY_RX_RESCALIB_CODE, 1, 4)
    FIELD(L0_TM_ANA_BYP_17, FORCE_UPHY_RX_RESCALIB_CODE, 0, 1)
REG32(L0_TM_ANA_BYP_18, 0x1044)
    FIELD(L0_TM_ANA_BYP_18, TM_ANA_BYP_18_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_18, FORCE_UPHY_RESTORE_CALCODE_DATA, 3, 1)
    FIELD(L0_TM_ANA_BYP_18, FORCE_UPHY_RX_PMA_OPMODE, 2, 1)
    FIELD(L0_TM_ANA_BYP_18, UPHY_PSO_LFPSBCN, 1, 1)
    FIELD(L0_TM_ANA_BYP_18, FORCE_UPHY_PSO_LFPSBCN, 0, 1)
REG32(L0_TM_ANA_BYP_20, 0x1048)
    FIELD(L0_TM_ANA_BYP_20, TM_ANA_BYP_20_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_20, UPHY_RX_PMA_OPMODE, 0, 8)
REG32(L0_TM_ANA_BYP_21, 0x104c)
    FIELD(L0_TM_ANA_BYP_21, TM_ANA_BYP_21_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_21, UPHY_RESTORE_CALCODE_DATA, 0, 8)
REG32(L0_TM_ANA_BYP_22, 0x1050)
    FIELD(L0_TM_ANA_BYP_22, TM_ANA_BYP_22_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_22, ISO_HSRX_CTRL_BAR, 7, 1)
    FIELD(L0_TM_ANA_BYP_22, FORCE_ISO_HSRX_CTRL_BAR, 6, 1)
    FIELD(L0_TM_ANA_BYP_22, HSRX_CLOCK_STOP_REQ, 5, 1)
    FIELD(L0_TM_ANA_BYP_22, FORCE_HSRX_CLOCK_STOP_REQ, 4, 1)
    FIELD(L0_TM_ANA_BYP_22, UPHY_SBRX_RUN_CALIB, 3, 1)
    FIELD(L0_TM_ANA_BYP_22, FORCE_UPHY_SBRX_RUN_CALIB, 2, 1)
    FIELD(L0_TM_ANA_BYP_22, RXPMA_RSTB, 1, 1)
    FIELD(L0_TM_ANA_BYP_22, FORCE_RXPMA_RSTB, 0, 1)
REG32(L0_TM_ANA_BYP_23, 0x1054)
    FIELD(L0_TM_ANA_BYP_23, TM_ANA_BYP_23_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BYP_23, ISO_SIGDET_CTRL_BAR, 7, 1)
    FIELD(L0_TM_ANA_BYP_23, FORCE_ISO_SIGDET_CTRL_BAR, 6, 1)
    FIELD(L0_TM_ANA_BYP_23, ISO_LFPS_CTRL_BAR, 5, 1)
    FIELD(L0_TM_ANA_BYP_23, FORCE_ISO_LFPS_CTRL_BAR, 4, 1)
    FIELD(L0_TM_ANA_BYP_23, ISO_MPHY_LSRX_CTRL_BAR, 3, 1)
    FIELD(L0_TM_ANA_BYP_23, FORCE_ISO_MPHY_LSRX_CTRL_BAR, 2, 1)
    FIELD(L0_TM_ANA_BYP_23, ISO_MPHY_SQUELCH_CTRL_BAR, 1, 1)
    FIELD(L0_TM_ANA_BYP_23, FORCE_ISO_MPHY_SQUELCH_CTRL_BAR, 0, 1)
REG32(L0_TM_DIG_1, 0x1058)
    FIELD(L0_TM_DIG_1, TM_DIG_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_1, EN_TXRX_DIFGEAR, 7, 1)
    FIELD(L0_TM_DIG_1, MPHY_HS_TERM_PT_SEL, 6, 1)
    FIELD(L0_TM_DIG_1, TX_ALLOW_INLNCFG_FROM_TOP, 5, 1)
    FIELD(L0_TM_DIG_1, BYPASS_MARKER_DETECTOR, 4, 1)
    FIELD(L0_TM_DIG_1, BYPASS_EXIT_VAL, 0, 4)
REG32(L0_TM_DIG_2, 0x105c)
    FIELD(L0_TM_DIG_2, TM_DIG_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_2, MPHY_SYM_STATE, 1, 5)
    FIELD(L0_TM_DIG_2, FORCE_MPHY_SYM_STATE, 0, 1)
REG32(L0_TM_DIG_3, 0x1060)
    FIELD(L0_TM_DIG_3, TM_DIG_3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_3, MPHY_SQUELCH_DETECT, 7, 1)
    FIELD(L0_TM_DIG_3, FORCE_MPHY_SQUELCH_DETECT, 6, 1)
    FIELD(L0_TM_DIG_3, MPHY_CFG_STATE, 1, 5)
    FIELD(L0_TM_DIG_3, FORCE_MPHY_CFG_STATE, 0, 1)
REG32(L0_TM_DIG_4, 0x1064)
    FIELD(L0_TM_DIG_4, TM_DIG_4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_4, STATUS_REG_VAL, 4, 4)
    FIELD(L0_TM_DIG_4, READ_SHADOW, 3, 1)
REG32(L0_TM_DIG_5, 0x1068)
    FIELD(L0_TM_DIG_5, TM_DIG_5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_5, SYMBOL_CLK_ALWAYS_ON_N, 2, 1)
    FIELD(L0_TM_DIG_5, BYPASS_DIFN_DETECT, 1, 1)
    FIELD(L0_TM_DIG_5, HIBERN8_CTRL, 0, 1)
REG32(L0_TM_DIG_6, 0x106c)
    FIELD(L0_TM_DIG_6, TM_DIG_6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_6, FORCE_BYPASS_ON_ERR, 6, 1)
    FIELD(L0_TM_DIG_6, SUPPRESS_ERR, 5, 1)
    FIELD(L0_TM_DIG_6, BYPASS_OHC, 4, 1)
    FIELD(L0_TM_DIG_6, BYPASS_DECODER, 3, 1)
    FIELD(L0_TM_DIG_6, FORCE_BYPASS_DEC, 2, 1)
    FIELD(L0_TM_DIG_6, BYPASS_DESCRAM, 1, 1)
    FIELD(L0_TM_DIG_6, FORCE_BYPASS_DESCRAM, 0, 1)
REG32(L0_TM_DIG_7, 0x1070)
    FIELD(L0_TM_DIG_7, TM_DIG_7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_7, BYPASS_ON_ERR_CHAR, 0, 8)
REG32(L0_TM_DIG_8, 0x1074)
    FIELD(L0_TM_DIG_8, TM_DIG_8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_8, EYESURF_ENABLE, 4, 1)
    FIELD(L0_TM_DIG_8, USE_EB_IN_MPHY, 3, 1)
    FIELD(L0_TM_DIG_8, BYPASS_EB, 2, 1)
    FIELD(L0_TM_DIG_8, EB_MODE, 1, 1)
    FIELD(L0_TM_DIG_8, FORCE_EB_MODE, 0, 1)
REG32(L0_TM_DIG_9, 0x1078)
    FIELD(L0_TM_DIG_9, TM_DIG_9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_9, FLIP_ENDIAN, 3, 1)
    FIELD(L0_TM_DIG_9, DEC_ERR_CNT_THRESHOLD, 0, 3)
REG32(L0_TM_DIG_10, 0x107c)
    FIELD(L0_TM_DIG_10, TM_DIG_10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_10, CDR_BIT_LOCK_TIME, 0, 4)
REG32(L0_TM_DIG_11, 0x1080)
    FIELD(L0_TM_DIG_11, TM_DIG_11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_11, BYPASS_CDR_ERR_MASK, 7, 1)
    FIELD(L0_TM_DIG_11, SYMB_ERR_SEL, 5, 2)
    FIELD(L0_TM_DIG_11, SYMB_ERR, 4, 1)
REG32(L0_TM_DIG_12, 0x1084)
    FIELD(L0_TM_DIG_12, TM_DIG_12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_12, FLIP_ENDIAN_EB_DATA_OUT, 5, 1)
    FIELD(L0_TM_DIG_12, FLIP_ENDIAN_EB_DATA_IN, 4, 1)
    FIELD(L0_TM_DIG_12, OVERFLOW_BYP, 3, 1)
    FIELD(L0_TM_DIG_12, UNDERFLOW_BYP, 2, 1)
    FIELD(L0_TM_DIG_12, OVERFLOW_BYP_VAL, 1, 1)
    FIELD(L0_TM_DIG_12, UNDERFLOW_BYP_VAL, 0, 1)
REG32(L0_TM_DIG_13, 0x1088)
    FIELD(L0_TM_DIG_13, TM_DIG_13_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_13, OMC_PRESENTN, 6, 1)
    FIELD(L0_TM_DIG_13, CFG_CLK_FREQ, 0, 6)
REG32(L0_TM_DIG_14, 0x108c)
    FIELD(L0_TM_DIG_14, TM_DIG_14_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_14, LFPS_OUTPUT_SEL, 6, 2)
    FIELD(L0_TM_DIG_14, LFPS_STRETCH, 4, 2)
REG32(L0_TM_DIG_15, 0x1090)
    FIELD(L0_TM_DIG_15, TM_DIG_15_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_15, FORCE_LFPS_FILTER_THRESH, 5, 1)
    FIELD(L0_TM_DIG_15, LFPS_FILTER_THRESH, 0, 5)
REG32(L0_TM_DIG_16, 0x1094)
    FIELD(L0_TM_DIG_16, TM_DIG_16_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_16, TESTDIGOUT_SEL, 1, 4)
    FIELD(L0_TM_DIG_16, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L0_TM_DIG_17, 0x1098)
    FIELD(L0_TM_DIG_17, TM_DIG_17_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_17, FORCE_SATA_RX_VALID_CNT, 4, 1)
    FIELD(L0_TM_DIG_17, SATA_RX_VALID_CNT, 0, 4)
REG32(L0_TM_DIG_18, 0x109c)
    FIELD(L0_TM_DIG_18, TM_DIG_18_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_18, CLK_DIST_SETTLE_TIME, 4, 4)
    FIELD(L0_TM_DIG_18, BIASGEN_SETTLE_TIME, 0, 4)
REG32(L0_TM_DIG_19, 0x10a0)
    FIELD(L0_TM_DIG_19, TM_DIG_19_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_19, HSRX_ANA_SETTLE_TIME, 4, 4)
    FIELD(L0_TM_DIG_19, SBRX_ANA_SETTLE_TIME, 0, 4)
REG32(L0_TM_DIG_20, 0x10a4)
    FIELD(L0_TM_DIG_20, TM_DIG_20_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_20, HSRX_COOLING_TIME, 3, 4)
    FIELD(L0_TM_DIG_20, FORCE_RX_CAL, 2, 1)
    FIELD(L0_TM_DIG_20, BYPASS_HSRX_CAL, 1, 1)
    FIELD(L0_TM_DIG_20, BYPASS_SBRX_CAL, 0, 1)
REG32(L0_TM_DIG_21, 0x10a8)
    FIELD(L0_TM_DIG_21, TM_DIG_21_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_21, COMMA_LOCATION_RST, 4, 1)
    FIELD(L0_TM_DIG_21, SSC_WAIT_CNT, 2, 2)
    FIELD(L0_TM_DIG_21, COMMA_PRE_LOCK_THRESH, 0, 2)
REG32(L0_TM_DIG_22, 0x10ac)
    FIELD(L0_TM_DIG_22, TM_DIG_22_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_22, DIS_DEFAULT_CDR_GATE_LOGIC, 5, 1)
    FIELD(L0_TM_DIG_22, INV_POL_SIGDET_HIGH, 4, 1)
    FIELD(L0_TM_DIG_22, INV_POL_SIGDET_LOW, 3, 1)
    FIELD(L0_TM_DIG_22, SIGDET_LFPS_BAR_EN, 2, 1)
    FIELD(L0_TM_DIG_22, OBSRV_SIGDET_OUTPUT, 1, 1)
    FIELD(L0_TM_DIG_22, RX_SIGDET_EN, 0, 1)
REG32(L0_TM_DIG_23, 0x10b0)
    FIELD(L0_TM_DIG_23, TM_DIG_23_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_23, DELAY_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L0_TM_DIG_23, FORCE_RX_SIGDET_SEL, 5, 1)
    FIELD(L0_TM_DIG_23, RX_SIGDET_SEL_VAL, 4, 1)
    FIELD(L0_TM_DIG_23, FORCE_RX_SIG_DET_FILT_FUNC_SEL, 3, 1)
    FIELD(L0_TM_DIG_23, RX_SIG_DET_FILT_FUNC_SEL, 0, 3)
REG32(L0_TM_DIG_24, 0x10b4)
    FIELD(L0_TM_DIG_24, TM_DIG_24_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_24, FILTER_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L0_TM_DIG_24, MIN_TIMER_LOAD_VAL_HIGH_1, 4, 2)
    FIELD(L0_TM_DIG_24, FILTER_TIMER_LOAD_VAL_LOW_1, 2, 2)
    FIELD(L0_TM_DIG_24, MIN_TIMER_LOAD_VAL_LOW_1, 0, 2)
REG32(L0_TM_DIG_25, 0x10b8)
    FIELD(L0_TM_DIG_25, TM_DIG_25_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_25, FILTER_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L0_TM_DIG_26, 0x10bc)
    FIELD(L0_TM_DIG_26, TM_DIG_26_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_26, DELAY_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L0_TM_DIG_27, 0x10c0)
    FIELD(L0_TM_DIG_27, TM_DIG_27_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_27, MIN_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L0_TM_DIG_28, 0x10c4)
    FIELD(L0_TM_DIG_28, TM_DIG_28_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_28, FILTER_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L0_TM_DIG_29, 0x10c8)
    FIELD(L0_TM_DIG_29, TM_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_29, MIN_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L0_TM_AUX_0, 0x10cc)
    FIELD(L0_TM_AUX_0, TM_AUX_0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_AUX_0, BIT_0, 7, 1)
    FIELD(L0_TM_AUX_0, BIT_1, 6, 1)
    FIELD(L0_TM_AUX_0, BIT_2, 5, 1)
    FIELD(L0_TM_AUX_0, BIT_3, 4, 1)
    FIELD(L0_TM_AUX_0, BIT_4, 3, 1)
    FIELD(L0_TM_AUX_0, BIT_5, 2, 1)
    FIELD(L0_TM_AUX_0, BIT_6, 1, 1)
    FIELD(L0_TM_AUX_0, BIT_7, 0, 1)
REG32(L0_TM_AUX_1, 0x10d0)
    FIELD(L0_TM_AUX_1, TM_AUX_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_AUX_1, BIT_0, 7, 1)
    FIELD(L0_TM_AUX_1, BIT_1, 6, 1)
    FIELD(L0_TM_AUX_1, BIT_2, 5, 1)
    FIELD(L0_TM_AUX_1, BIT_3, 4, 1)
    FIELD(L0_TM_AUX_1, BIT_4, 3, 1)
    FIELD(L0_TM_AUX_1, BIT_5, 2, 1)
    FIELD(L0_TM_AUX_1, BIT_6, 1, 1)
    FIELD(L0_TM_AUX_1, BIT_7, 0, 1)
REG32(L0_TM_AUX_2, 0x10d4)
    FIELD(L0_TM_AUX_2, TM_AUX_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_AUX_2, BIT_0, 7, 1)
    FIELD(L0_TM_AUX_2, BIT_1, 6, 1)
    FIELD(L0_TM_AUX_2, BIT_2, 5, 1)
    FIELD(L0_TM_AUX_2, BIT_3, 4, 1)
    FIELD(L0_TM_AUX_2, BIT_4, 3, 1)
    FIELD(L0_TM_AUX_2, BIT_5, 2, 1)
    FIELD(L0_TM_AUX_2, BIT_6, 1, 1)
    FIELD(L0_TM_AUX_2, BIT_7, 0, 1)
REG32(L0_TM_AUX_3, 0x10d8)
    FIELD(L0_TM_AUX_3, TM_AUX_3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_AUX_3, BIT_0, 7, 1)
    FIELD(L0_TM_AUX_3, BIT_1, 6, 1)
    FIELD(L0_TM_AUX_3, BIT_2, 5, 1)
    FIELD(L0_TM_AUX_3, BIT_3, 4, 1)
    FIELD(L0_TM_AUX_3, BIT_4, 3, 1)
    FIELD(L0_TM_AUX_3, BIT_5, 2, 1)
    FIELD(L0_TM_AUX_3, BIT_6, 1, 1)
    FIELD(L0_TM_AUX_3, BIT_7, 0, 1)
REG32(L0_TM_AUX_4, 0x10dc)
    FIELD(L0_TM_AUX_4, TM_AUX_4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_AUX_4, BIT_0, 7, 1)
    FIELD(L0_TM_AUX_4, BIT_1, 6, 1)
    FIELD(L0_TM_AUX_4, BIT_2, 5, 1)
    FIELD(L0_TM_AUX_4, BIT_3, 4, 1)
    FIELD(L0_TM_AUX_4, BIT_4, 3, 1)
    FIELD(L0_TM_AUX_4, BIT_5, 2, 1)
    FIELD(L0_TM_AUX_4, BIT_6, 1, 1)
    FIELD(L0_TM_AUX_4, BIT_7, 0, 1)
REG32(L0_TM_DIG_30, 0x10e0)
    FIELD(L0_TM_DIG_30, TM_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_30, SD_LD_BAR_FILTER_TIME_VAL_1, 4, 2)
    FIELD(L0_TM_DIG_30, SD_LD_BAR_DLY_TIME_VAL_1, 2, 2)
    FIELD(L0_TM_DIG_30, SD_LD_BAR_MIN_TIMER_VAL_1, 0, 2)
REG32(L0_TM_DIG_31, 0x10e4)
    FIELD(L0_TM_DIG_31, TM_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_31, SD_LD_BAR_FILTER_TIME_VAL_0, 0, 8)
REG32(L0_TM_DIG_32, 0x10e8)
    FIELD(L0_TM_DIG_32, TM_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_32, SD_LD_BAR_DLY_TIME_VAL_0, 0, 8)
REG32(L0_TM_DIG_33, 0x10ec)
    FIELD(L0_TM_DIG_33, TM_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_33, SD_LD_BAR_MIN_TIMER_VAL_0, 0, 8)
REG32(L0_TM_DIG_34, 0x10f0)
    FIELD(L0_TM_DIG_34, TM_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_34, SATA_JUNK_DATA_TIMEOUT_VAL, 0, 6)
REG32(L0_TM_DIG_35, 0x10f4)
    FIELD(L0_TM_DIG_35, TM_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_35, SATA_CDR_LOCK_WAIT_TIMEOUT_VAL, 0, 6)
REG32(L0_TM_DIG_36, 0x10f8)
    FIELD(L0_TM_DIG_36, TM_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_36, COM_DET_THRESH_VAL_0, 0, 8)
REG32(L0_TM_DIG_37, 0x10fc)
    FIELD(L0_TM_DIG_37, TM_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DIG_37, FORCE_COM_DETECT_THRESH, 4, 1)
    FIELD(L0_TM_DIG_37, COM_DET_THRESH_VAL_1, 0, 4)
REG32(L0_TM_LFPS_1, 0x1800)
    FIELD(L0_TM_LFPS_1, TM_LFPS_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_LFPS_1, PROG_REFP, 4, 4)
    FIELD(L0_TM_LFPS_1, PROG_REFM, 0, 4)
REG32(L0_TM_LFPS_2, 0x1804)
    FIELD(L0_TM_LFPS_2, TM_LFPS_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_LFPS_2, PROG_VCM, 4, 3)
    FIELD(L0_TM_LFPS_2, PROG_FILTER_CAP, 0, 4)
REG32(L0_TM_LFPS_3, 0x1808)
    FIELD(L0_TM_LFPS_3, TM_LFPS_3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_LFPS_3, PROG_C2, 5, 3)
    FIELD(L0_TM_LFPS_3, PROG_C1, 2, 3)
    FIELD(L0_TM_LFPS_3, PROG_PADINTF, 0, 2)
REG32(L0_TM_LFPS_4, 0x180c)
    FIELD(L0_TM_LFPS_4, TM_LFPS_4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_LFPS_4, TESTBIT, 0, 6)
REG32(L0_TM_RXPMA_1, 0x1810)
    FIELD(L0_TM_RXPMA_1, TM_RXPMA_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_RXPMA_1, UPHY_TESTBIT, 0, 8)
REG32(L0_TM_BSCAN_1, 0x1814)
    FIELD(L0_TM_BSCAN_1, TM_BSCAN_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BSCAN_1, BSCAN_LPF_RES, 0, 3)
REG32(L0_TM_MPHY_SQ_1, 0x1818)
    FIELD(L0_TM_MPHY_SQ_1, TM_MPHY_SQ_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MPHY_SQ_1, TB_REDUCE_OFFSET, 4, 1)
    FIELD(L0_TM_MPHY_SQ_1, TB_INCREASE_OFFSET, 3, 1)
    FIELD(L0_TM_MPHY_SQ_1, TB_DRIVE_RES_SEL, 1, 2)
    FIELD(L0_TM_MPHY_SQ_1, TB_BYPASS_HYST, 0, 1)
REG32(L0_TM_LSRX_1, 0x181c)
    FIELD(L0_TM_LSRX_1, TM_LSRX_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_LSRX_1, LSRX_TESTBITS_0, 0, 8)
REG32(L0_TM_LSRX_2, 0x1820)
    FIELD(L0_TM_LSRX_2, TM_LSRX_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_LSRX_2, LSRX_TESTBITS_1, 0, 6)
REG32(L0_TM_SIGDET_1, 0x1824)
    FIELD(L0_TM_SIGDET_1, TM_SIGDET_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SIGDET_1, BIASTRIM, 4, 3)
    FIELD(L0_TM_SIGDET_1, RELIABPROT, 2, 2)
    FIELD(L0_TM_SIGDET_1, STRESSPORT, 0, 2)
REG32(L0_TM_SIGDET_2, 0x1828)
    FIELD(L0_TM_SIGDET_2, TM_SIGDET_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SIGDET_2, VSENSETRIM, 0, 8)
REG32(L0_TM_DFT_1, 0x182c)
    FIELD(L0_TM_DFT_1, TM_DFT_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_1, LFPS_DFT_SEL_P, 4, 4)
    FIELD(L0_TM_DFT_1, LFPS_DFT_ENABLE, 3, 1)
REG32(L0_TM_DFT_2, 0x1830)
    FIELD(L0_TM_DFT_2, TM_DFT_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_2, SIGDET_DFT_SEL_P, 0, 3)
REG32(L0_TM_DFT_3, 0x1834)
    FIELD(L0_TM_DFT_3, TM_DFT_3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_3, BSCAN_DFT_ENABLE, 4, 1)
    FIELD(L0_TM_DFT_3, BSCAN_DFT_SEL_P, 0, 4)
REG32(L0_TM_DFT_4, 0x1838)
    FIELD(L0_TM_DFT_4, TM_DFT_4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_4, IQPI_DFT_ENABLE, 1, 1)
    FIELD(L0_TM_DFT_4, EPI_DFT_ENABLE, 0, 1)
REG32(L0_TM_DFT_5, 0x183c)
    FIELD(L0_TM_DFT_5, TM_DFT_5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_5, IQPI_DFT_SEL, 0, 8)
REG32(L0_TM_DFT_6, 0x1840)
    FIELD(L0_TM_DFT_6, TM_DFT_6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_6, EPI_DFT_SEL, 0, 8)
REG32(L0_TM_DFT_7, 0x1844)
    FIELD(L0_TM_DFT_7, TM_DFT_7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_7, EQ_DFT_ENABLE, 4, 1)
    FIELD(L0_TM_DFT_7, EQ_DFT_SEL_P, 0, 4)
REG32(L0_TM_DFT_8, 0x1848)
    FIELD(L0_TM_DFT_8, TM_DFT_8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_8, LSRX_DFT_ENABLE, 4, 1)
    FIELD(L0_TM_DFT_8, LSRX_DFT_SEL_P, 0, 4)
REG32(L0_TM_DFT_9, 0x184c)
    FIELD(L0_TM_DFT_9, TM_DFT_9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_9, SAMP_DFT_SEL_P_0, 0, 8)
REG32(L0_TM_DFT_10, 0x1850)
    FIELD(L0_TM_DFT_10, TM_DFT_10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_DFT_10, CLKLANE_DFT_SEL, 2, 2)
    FIELD(L0_TM_DFT_10, SAMP_DFT_SEL_P_1, 0, 2)
REG32(L0_TM_BG_1, 0x1854)
    FIELD(L0_TM_BG_1, TM_BG_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_1, BIASGEN_CURRENT_PROG_0, 0, 8)
REG32(L0_TM_BG_2, 0x1858)
    FIELD(L0_TM_BG_2, TM_BG_2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_2, BIASGEN_CURRENT_PROG_1, 0, 8)
REG32(L0_TM_BG_3, 0x185c)
    FIELD(L0_TM_BG_3, TM_BG_3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_3, BIASGEN_CURRENT_PROG_2, 0, 8)
REG32(L0_TM_BG_4, 0x1860)
    FIELD(L0_TM_BG_4, TM_BG_4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_4, BIASGEN_CURRENT_PROG_3, 0, 8)
REG32(L0_TM_BG_5, 0x1864)
    FIELD(L0_TM_BG_5, TM_BG_5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_5, BIASGEN_CURRENT_PROG_4, 0, 8)
REG32(L0_TM_BG_6, 0x1868)
    FIELD(L0_TM_BG_6, TM_BG_6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_6, BIASGEN_CURRENT_PROG_5, 0, 8)
REG32(L0_TM_BG_7, 0x186c)
    FIELD(L0_TM_BG_7, TM_BG_7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_7, BIASGEN_CURRENT_PROG_6, 0, 8)
REG32(L0_TM_BG_8, 0x1870)
    FIELD(L0_TM_BG_8, TM_BG_8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_8, BIASGEN_CURRENT_PROG_7, 0, 8)
REG32(L0_TM_BG_9, 0x1874)
    FIELD(L0_TM_BG_9, TM_BG_9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_9, BIASGEN_CURRENT_PROG_8, 0, 8)
REG32(L0_TM_BG_10, 0x1878)
    FIELD(L0_TM_BG_10, TM_BG_10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_10, BIASGEN_CURRENT_PROG_9, 0, 8)
REG32(L0_TM_SD0, 0x187c)
    FIELD(L0_TM_SD0, TM_SD0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD0, SD_CAL_OVERRIDE_CODE, 2, 6)
    FIELD(L0_TM_SD0, SD_CAL_OVERRIDE_EN, 1, 1)
    FIELD(L0_TM_SD0, SD_CAL_DIR, 0, 1)
REG32(L0_TM_SD1, 0x1880)
    FIELD(L0_TM_SD1, TM_SD1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD1, SD_BYPASS_ANA_CAL_EN_VAL, 7, 1)
    FIELD(L0_TM_SD1, SD_BYPASS_ANA_CAL_EN, 6, 1)
    FIELD(L0_TM_SD1, SD_CAL_CODE_START, 0, 6)
REG32(L0_TM_SD2, 0x1884)
    FIELD(L0_TM_SD2, TM_SD2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD2, SD_CAL_FORCE_CAL, 7, 1)
    FIELD(L0_TM_SD2, SD_CAL_CODE_TUNE_BYP, 6, 1)
    FIELD(L0_TM_SD2, SD_CAL_CODE_TUNE, 0, 6)
REG32(L0_TM_SD3, 0x1888)
    FIELD(L0_TM_SD3, TM_SD3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD3, SD_CAL_ITER_WAIT_0, 0, 8)
REG32(L0_TM_SD4, 0x188c)
    FIELD(L0_TM_SD4, TM_SD4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD4, SD_CAL_ITER_WAIT_BYPASS, 4, 1)
    FIELD(L0_TM_SD4, SD_CAL_ITER_WAIT_1, 0, 4)
REG32(L0_TM_SD5, 0x1890)
    FIELD(L0_TM_SD5, TM_SD5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD5, SD_CAL_INIT_WAIT_0, 0, 8)
REG32(L0_TM_SD6, 0x1894)
    FIELD(L0_TM_SD6, TM_SD6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD6, SD_CAL_INIT_WAIT_BYPASS, 4, 1)
    FIELD(L0_TM_SD6, SD_CAL_INIT_WAIT_1, 0, 4)
REG32(L0_TM_MISC1, 0x1898)
    FIELD(L0_TM_MISC1, TM_MISC1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MISC1, HSRX_POLARITY_FLIP, 7, 1)
    FIELD(L0_TM_MISC1, RXTERM_BIAS_PROG, 3, 4)
    FIELD(L0_TM_MISC1, LSRX_OR_SYS_POLARITY_FLIP, 2, 1)
    FIELD(L0_TM_MISC1, FORCE_SATAG1_DCC_MODE, 1, 1)
    FIELD(L0_TM_MISC1, SATAG1_DCC_MODE_VAL, 0, 1)
REG32(L0_TM_MISC2, 0x189c)
    FIELD(L0_TM_MISC2, TM_MISC2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MISC2, ILL_CAL_BYPASS_COUNTS, 7, 1)
    FIELD(L0_TM_MISC2, PWR_SEQ_SAMP_CAL_ALWAYS, 6, 1)
    FIELD(L0_TM_MISC2, PWR_SEQ_BYP_CAL_DONE, 5, 1)
    FIELD(L0_TM_MISC2, PWR_SEQ_BYP_CAL_DONE_VAL, 4, 1)
    FIELD(L0_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ, 3, 1)
    FIELD(L0_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ_VAL, 2, 1)
    FIELD(L0_TM_MISC2, UNUSED, 0, 2)
REG32(L0_TM_EYE_SURF0, 0x18a0)
    FIELD(L0_TM_EYE_SURF0, TM_EYE_SURF0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF0, UNUSED, 7, 1)
    FIELD(L0_TM_EYE_SURF0, EYE_SURF_RUN, 6, 1)
    FIELD(L0_TM_EYE_SURF0, COORD_EW_DIR, 5, 1)
    FIELD(L0_TM_EYE_SURF0, COORD_EW_OFFSET, 0, 5)
REG32(L0_TM_EYE_SURF1, 0x18a4)
    FIELD(L0_TM_EYE_SURF1, TM_EYE_SURF1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF1, COORD_NS_DIR, 7, 1)
    FIELD(L0_TM_EYE_SURF1, COORD_NS_OFFSET, 0, 7)
REG32(L0_TM_EYE_SURF2, 0x18a8)
    FIELD(L0_TM_EYE_SURF2, TM_EYE_SURF2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF2, TIMER_DELAY_TIME0, 0, 8)
REG32(L0_TM_EYE_SURF3, 0x18ac)
    FIELD(L0_TM_EYE_SURF3, TM_EYE_SURF3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF3, TIMER_DELAY_TIME1, 0, 8)
REG32(L0_TM_EYE_SURF4, 0x18b0)
    FIELD(L0_TM_EYE_SURF4, TM_EYE_SURF4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF4, TIMER_DELAY_TIME2, 0, 8)
REG32(L0_TM_EYE_SURF5, 0x18b4)
    FIELD(L0_TM_EYE_SURF5, TM_EYE_SURF5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF5, TIMER_DELAY_TIME3, 0, 8)
REG32(L0_TM_EYE_SURF6, 0x18b8)
    FIELD(L0_TM_EYE_SURF6, TM_EYE_SURF6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF6, TIMER_TEST_TIME0, 0, 8)
REG32(L0_TM_EYE_SURF7, 0x18bc)
    FIELD(L0_TM_EYE_SURF7, TM_EYE_SURF7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF7, TIMER_TEST_TIME1, 0, 8)
REG32(L0_TM_EYE_SURF8, 0x18c0)
    FIELD(L0_TM_EYE_SURF8, TM_EYE_SURF8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF8, TIMER_TEST_TIME2, 0, 8)
REG32(L0_TM_EYE_SURF9, 0x18c4)
    FIELD(L0_TM_EYE_SURF9, TM_EYE_SURF9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYE_SURF9, TIMER_TEST_TIME3, 0, 8)
REG32(L0_TM_SPARE, 0x18c8)
    FIELD(L0_TM_SPARE, TM_SPARE_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SPARE, RXDA_SPARE_PORT, 0, 8)
REG32(L0_TM_ANA_EQ1, 0x18cc)
    FIELD(L0_TM_ANA_EQ1, TM_ANA_EQ1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_EQ1, UNUSED, 5, 3)
    FIELD(L0_TM_ANA_EQ1, EQ_INPUT_CM_PROG, 2, 3)
    FIELD(L0_TM_ANA_EQ1, EQ_PADINTF_HQ_PROG, 0, 2)
REG32(L0_TM_ANA_E_PI0, 0x18d0)
    FIELD(L0_TM_ANA_E_PI0, TM_ANA_E_PI0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_E_PI0, EPI_BIASTRIM, 5, 3)
    FIELD(L0_TM_ANA_E_PI0, UNUSED, 0, 5)
REG32(L0_TM_ANA_IQ_PI0, 0x18d4)
    FIELD(L0_TM_ANA_IQ_PI0, TM_ANA_IQ_PI0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_IQ_PI0, IQPI_BIASTRIM, 5, 3)
    FIELD(L0_TM_ANA_IQ_PI0, UNUSED, 0, 5)
REG32(L0_TM_ANA_MISC0, 0x18d8)
    FIELD(L0_TM_ANA_MISC0, TM_ANA_MISC0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_MISC0, EPI_CALIB_EN, 7, 1)
    FIELD(L0_TM_ANA_MISC0, IQPI_CALIB_EN, 6, 1)
    FIELD(L0_TM_ANA_MISC0, UNUSED, 0, 6)
REG32(L0_TM_SAMP_CODE_IQ_PH0, 0x18dc)
    FIELD(L0_TM_SAMP_CODE_IQ_PH0, TM_SAMP_CODE_IQ_PH0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_CODE_IQ_PH0, UNUSED, 7, 1)
    FIELD(L0_TM_SAMP_CODE_IQ_PH0, SAMP_CALIB_BYP, 6, 1)
    FIELD(L0_TM_SAMP_CODE_IQ_PH0, IQ_PH0_SAMP_CODE, 0, 6)
REG32(L0_TM_SAMP_CODE_IQ_PH90, 0x18e0)
    FIELD(L0_TM_SAMP_CODE_IQ_PH90, TM_SAMP_CODE_IQ_PH90_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_CODE_IQ_PH90, CALIB_SWEEP_DIR, 6, 2)
    FIELD(L0_TM_SAMP_CODE_IQ_PH90, IQ_PH90_SAMP_CODE, 0, 6)
REG32(L0_TM_SAMP_CODE_IQ_PH180, 0x18e4)
    FIELD(L0_TM_SAMP_CODE_IQ_PH180, TM_SAMP_CODE_IQ_PH180_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_CODE_IQ_PH180, UNUSED, 6, 2)
    FIELD(L0_TM_SAMP_CODE_IQ_PH180, IQ_PH180_SAMP_CODE, 0, 6)
REG32(L0_TM_SAMP_CODE_IQ_PH270, 0x18e8)
    FIELD(L0_TM_SAMP_CODE_IQ_PH270, TM_SAMP_CODE_IQ_PH270_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_CODE_IQ_PH270, HSRX_DBG_BUS_SEL, 6, 2)
    FIELD(L0_TM_SAMP_CODE_IQ_PH270, IQ_PH270_SAMP_CODE, 0, 6)
REG32(L0_TM_SAMP_CODE_E_PH0, 0x18ec)
    FIELD(L0_TM_SAMP_CODE_E_PH0, TM_SAMP_CODE_E_PH0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_CODE_E_PH0, UNUSED, 6, 2)
    FIELD(L0_TM_SAMP_CODE_E_PH0, E_PH90_SAMP_CODE, 0, 6)
REG32(L0_TM_SAMP_CODE_E_PH180, 0x18f0)
    FIELD(L0_TM_SAMP_CODE_E_PH180, TM_SAMP_CODE_E_PH180_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_CODE_E_PH180, UNUSED, 6, 2)
    FIELD(L0_TM_SAMP_CODE_E_PH180, E_PH270_SAMP_CODE, 0, 6)
REG32(L0_TM_IQ_ILL0, 0x18f4)
    FIELD(L0_TM_IQ_ILL0, TM_IQ_ILL0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL0, ILL_BYPASS_IQ_CAL_EN, 7, 1)
    FIELD(L0_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L0_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L0_TM_IQ_ILL0, ILL_BYPASS_IQ_CODES, 0, 1)
REG32(L0_TM_IQ_ILL1, 0x18f8)
    FIELD(L0_TM_IQ_ILL1, TM_IQ_ILL1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL1, ILL_BYPASS_IQ_CALCODE_F0, 0, 8)
REG32(L0_TM_IQ_ILL2, 0x18fc)
    FIELD(L0_TM_IQ_ILL2, TM_IQ_ILL2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL2, ILL_BYPASS_IQ_CALCODE_F1, 0, 8)
REG32(L0_TM_IQ_ILL3, 0x1900)
    FIELD(L0_TM_IQ_ILL3, TM_IQ_ILL3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL3, ILL_BYPASS_IQ_CALCODE_F2, 0, 8)
REG32(L0_TM_IQ_ILL4, 0x1904)
    FIELD(L0_TM_IQ_ILL4, TM_IQ_ILL4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL4, ILL_BYPASS_IQ_CALCODE_F3, 0, 8)
REG32(L0_TM_IQ_ILL5, 0x1908)
    FIELD(L0_TM_IQ_ILL5, TM_IQ_ILL5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL5, ILL_BYPASS_IQ_CALCODE_F4, 0, 8)
REG32(L0_TM_IQ_ILL6, 0x190c)
    FIELD(L0_TM_IQ_ILL6, TM_IQ_ILL6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL6, ILL_BYPASS_IQ_CALCODE_F5, 0, 8)
REG32(L0_TM_IQ_ILL7, 0x1910)
    FIELD(L0_TM_IQ_ILL7, TM_IQ_ILL7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL7, ILL_BYPASS_IQ_CNSTGMTRIM_VAL, 0, 8)
REG32(L0_TM_IQ_ILL8, 0x1914)
    FIELD(L0_TM_IQ_ILL8, TM_IQ_ILL8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL8, ILL_BYPASS_IQ_POLYTRIM_VAL, 0, 8)
REG32(L0_TM_IQ_ILL9, 0x1918)
    FIELD(L0_TM_IQ_ILL9, TM_IQ_ILL9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL9, UNUSED, 4, 4)
    FIELD(L0_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN, 3, 1)
    FIELD(L0_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN_VAL, 2, 1)
    FIELD(L0_TM_IQ_ILL9, ILL_BYPASS_IQ_CNSTGMTRIM, 1, 1)
    FIELD(L0_TM_IQ_ILL9, ILL_BYPASS_IQ_POLYTIM, 0, 1)
REG32(L0_TM_IQ_ILL10, 0x191c)
    FIELD(L0_TM_IQ_ILL10, TM_IQ_ILL10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_IQ_ILL10, UNUSED, 6, 2)
    FIELD(L0_TM_IQ_ILL10, IQPI_CALCTRIM, 4, 2)
    FIELD(L0_TM_IQ_ILL10, IQPI_REPLICATRIM, 0, 4)
REG32(L0_TM_E_ILL0, 0x1920)
    FIELD(L0_TM_E_ILL0, TM_E_ILL0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL0, E_ILL_CALIB_CTRL, 7, 1)
    FIELD(L0_TM_E_ILL0, E_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L0_TM_E_ILL0, E_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L0_TM_E_ILL0, E_ILL_CALIB_BYP, 0, 1)
REG32(L0_TM_E_ILL1, 0x1924)
    FIELD(L0_TM_E_ILL1, TM_E_ILL1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL1, ILL_BYPASS_E_CALCODE_F0, 0, 8)
REG32(L0_TM_E_ILL2, 0x1928)
    FIELD(L0_TM_E_ILL2, TM_E_ILL2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL2, ILL_BYPASS_E_CALCODE_F1, 0, 8)
REG32(L0_TM_E_ILL3, 0x192c)
    FIELD(L0_TM_E_ILL3, TM_E_ILL3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL3, ILL_BYPASS_E_CALCODE_F2, 0, 8)
REG32(L0_TM_E_ILL4, 0x1930)
    FIELD(L0_TM_E_ILL4, TM_E_ILL4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL4, ILL_BYPASS_E_CALCODE_F3, 0, 8)
REG32(L0_TM_E_ILL5, 0x1934)
    FIELD(L0_TM_E_ILL5, TM_E_ILL5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL5, ILL_BYPASS_E_CALCODE_F4, 0, 8)
REG32(L0_TM_E_ILL6, 0x1938)
    FIELD(L0_TM_E_ILL6, TM_E_ILL6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL6, ILL_BYPASS_E_CALCODE_F5, 0, 8)
REG32(L0_TM_E_ILL7, 0x193c)
    FIELD(L0_TM_E_ILL7, TM_E_ILL7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL7, ILL_BYPASS_E_CNSTGMTRIM_VAL, 0, 8)
REG32(L0_TM_E_ILL8, 0x1940)
    FIELD(L0_TM_E_ILL8, TM_E_ILL8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL8, ILL_BYPASS_E_POLYTRIM_VAL, 0, 8)
REG32(L0_TM_E_ILL9, 0x1944)
    FIELD(L0_TM_E_ILL9, TM_E_ILL9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL9, UNUSED, 4, 4)
    FIELD(L0_TM_E_ILL9, ILL_BYPASS_E_LFEN, 3, 1)
    FIELD(L0_TM_E_ILL9, ILL_BYPASS_E_LFEN_VAL, 2, 1)
    FIELD(L0_TM_E_ILL9, ILL_BYPASS_E_CNSTGMTRIM, 1, 1)
    FIELD(L0_TM_E_ILL9, ILL_BYPASS_E_POLYTIM, 0, 1)
REG32(L0_TM_E_ILL10, 0x1948)
    FIELD(L0_TM_E_ILL10, TM_E_ILL10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_E_ILL10, UNUSED, 6, 2)
    FIELD(L0_TM_E_ILL10, EPI_CALCTRIM, 4, 2)
    FIELD(L0_TM_E_ILL10, EPI_REPLICATRIM, 0, 4)
REG32(L0_TM_EQ0, 0x194c)
    FIELD(L0_TM_EQ0, TM_EQ0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ0, EQ_STG1_RL_PROG_MSB, 7, 1)
    FIELD(L0_TM_EQ0, EQ_STG1_CTRL_BYP, 6, 1)
    FIELD(L0_TM_EQ0, EQ_STG2_CTRL_BYP, 5, 1)
    FIELD(L0_TM_EQ0, EQ_ADAPTATION_FORCE, 4, 1)
    FIELD(L0_TM_EQ0, EQ_ADAPTATION_FORCE_VAL, 3, 1)
    FIELD(L0_TM_EQ0, EQ_ISOURCE_EN_VAL, 0, 3)
REG32(L0_TM_EQ1, 0x1950)
    FIELD(L0_TM_EQ1, TM_EQ1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ1, EQ_STG1_PREAMP_MODE_VAL, 7, 1)
    FIELD(L0_TM_EQ1, EQ_STG1_RL_PROG, 5, 2)
    FIELD(L0_TM_EQ1, EQ_STG2_CM_PROG, 3, 2)
    FIELD(L0_TM_EQ1, EQ_STG2_PREAMP_MODE_VAL, 2, 1)
    FIELD(L0_TM_EQ1, EQ_STG2_RL_PROG, 0, 2)
REG32(L0_TM_EQ2, 0x1954)
    FIELD(L0_TM_EQ2, TM_EQ2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ2, UNUSED, 7, 1)
    FIELD(L0_TM_EQ2, EQ_EN_BACKGND_ADAPT, 6, 1)
    FIELD(L0_TM_EQ2, EQ_COUNT_STRAYS, 5, 1)
    FIELD(L0_TM_EQ2, EQ_WINDOW_SIZE, 3, 2)
    FIELD(L0_TM_EQ2, EQ_MAJ_THRESH, 1, 2)
    FIELD(L0_TM_EQ2, EQ_BIAS_CTRL_BYP, 0, 1)
REG32(L0_TM_EQ3, 0x1958)
    FIELD(L0_TM_EQ3, TM_EQ3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ3, UNUSED, 5, 3)
    FIELD(L0_TM_EQ3, EQ_BYPASS_ISINK_ENZ_VAL, 0, 5)
REG32(L0_TM_EQ4, 0x195c)
    FIELD(L0_TM_EQ4, TM_EQ4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ4, UNUSED, 5, 3)
    FIELD(L0_TM_EQ4, BYPASS_EQ_C_STG1, 4, 1)
    FIELD(L0_TM_EQ4, BYPASS_EQ_C_VAL_STG1, 0, 4)
REG32(L0_TM_EQ5, 0x1960)
    FIELD(L0_TM_EQ5, TM_EQ5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ5, UNUSED, 6, 2)
    FIELD(L0_TM_EQ5, BYPASS_EQ_R_STG1, 5, 1)
    FIELD(L0_TM_EQ5, BYPASS_EQ_R_VAL_STG1, 0, 5)
REG32(L0_TM_EQ6, 0x1964)
    FIELD(L0_TM_EQ6, TM_EQ6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ6, UNUSED, 5, 3)
    FIELD(L0_TM_EQ6, BYPASS_EQ_C_STG2, 4, 1)
    FIELD(L0_TM_EQ6, BYPASS_EQ_C_VAL_STG2, 0, 4)
REG32(L0_TM_EQ7, 0x1968)
    FIELD(L0_TM_EQ7, TM_EQ7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ7, UNUSED, 6, 2)
    FIELD(L0_TM_EQ7, BYPASS_EQ_R_STG2, 5, 1)
    FIELD(L0_TM_EQ7, BYPASS_EQ_R_VAL_STG2, 0, 5)
REG32(L0_TM_EQ8, 0x196c)
    FIELD(L0_TM_EQ8, TM_EQ8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ8, EQ_BYPASS_CALIB, 7, 1)
    FIELD(L0_TM_EQ8, EQ_SWEEP, 5, 2)
    FIELD(L0_TM_EQ8, SEL_SAMP, 2, 3)
    FIELD(L0_TM_EQ8, BYPASS_EQ_CAL, 1, 1)
    FIELD(L0_TM_EQ8, BYPASS_EQ_CAL_VAL, 0, 1)
REG32(L0_TM_EQ9, 0x1970)
    FIELD(L0_TM_EQ9, TM_EQ9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ9, UNUSED, 7, 1)
    FIELD(L0_TM_EQ9, EQ_BYPASS_CALIB_CODE, 0, 7)
REG32(L0_TM_EQ10, 0x1974)
    FIELD(L0_TM_EQ10, TM_EQ10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ10, UNUSED, 7, 1)
    FIELD(L0_TM_EQ10, OFFSET_COEF_SCALER, 4, 3)
    FIELD(L0_TM_EQ10, DIAG_OUTPUT_SEL, 0, 4)
REG32(L0_TM_EQ11, 0x1978)
    FIELD(L0_TM_EQ11, TM_EQ11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ11, EQ_CALIB_CLK_DIV_FORCE, 7, 1)
    FIELD(L0_TM_EQ11, EDGE_IS_FIRST, 6, 1)
    FIELD(L0_TM_EQ11, FORCE_EQ_OFFS_ON, 5, 1)
    FIELD(L0_TM_EQ11, FORCE_EQ_OFFS_OFF, 4, 1)
    FIELD(L0_TM_EQ11, EQ_OFFS_WITH_ADAPT, 3, 1)
    FIELD(L0_TM_EQ11, OFFSET_VOTER_OVERRIDE_EN, 2, 1)
    FIELD(L0_TM_EQ11, OFFSET_VOTER_OVERRIDE_NEG, 1, 1)
    FIELD(L0_TM_EQ11, OFFSET_VOTER_OVERRIDE_POS, 0, 1)
REG32(L0_TM_ILL7, 0x197c)
    FIELD(L0_TM_ILL7, TM_ILL7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL7, ILL_CAL_INIT_WAIT, 0, 8)
REG32(L0_TM_ILL8, 0x1980)
    FIELD(L0_TM_ILL8, TM_ILL8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL8, ILL_CAL_ITER_WAIT, 0, 8)
REG32(L0_TM_ILL9, 0x1984)
    FIELD(L0_TM_ILL9, TM_ILL9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL9, ILL_CAL_BYPASS_CAP_START, 7, 1)
    FIELD(L0_TM_ILL9, ILL_CAL_CAP_START_VAL, 0, 7)
REG32(L0_TM_ILL10, 0x1988)
    FIELD(L0_TM_ILL10, TM_ILL10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL10, G3A_USB3_PCIEG2_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L0_TM_ILL10, G3B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L0_TM_ILL11, 0x198c)
    FIELD(L0_TM_ILL11, TM_ILL11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL11, G2A_PCIEG1_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L0_TM_ILL11, G2B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L0_TM_ILL12, 0x1990)
    FIELD(L0_TM_ILL12, TM_ILL12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL12, G1A_PLL_CTR_BYP_VAL, 0, 8)
REG32(L0_TM_ILL13, 0x1994)
    FIELD(L0_TM_ILL13, TM_ILL13_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL13, ILL_CAL_IDLE_VAL_REFCNT, 0, 3)
REG32(L0_TM_ILL14, 0x1998)
    FIELD(L0_TM_ILL14, TM_ILL14_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL14, ILL_CALIB_WAIT, 4, 4)
    FIELD(L0_TM_ILL14, ILL_CHG_WAIT, 0, 4)
REG32(L0_TM_FRZ_FSM0, 0x199c)
    FIELD(L0_TM_FRZ_FSM0, TM_FRZ_FSM0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_FRZ_FSM0, FREEZE_HSRX_PWR_SEQ_FSM, 0, 8)
REG32(L0_TM_FRZ_FSM1, 0x19a0)
    FIELD(L0_TM_FRZ_FSM1, TM_FRZ_FSM1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_FRZ_FSM1, UNUSED, 6, 2)
    FIELD(L0_TM_FRZ_FSM1, FREEZE_ILL_CALIB_FSM, 0, 6)
REG32(L0_TM_RST_DLY, 0x19a4)
    FIELD(L0_TM_RST_DLY, TM_RST_DLY_31_8_RSVD, 24, 8)
    FIELD(L0_TM_RST_DLY, APB_RST_DLY, 0, 8)
REG32(L0_TM_ILL15, 0x19a8)
    FIELD(L0_TM_ILL15, TM_ILL15_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL15, ILL_CAL_REF_CTR_MSB_REG1, 0, 8)
REG32(L0_TM_MISC3, 0x19ac)
    FIELD(L0_TM_MISC3, TM_MISC3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MISC3, AUX0_BIT_7, 7, 1)
    FIELD(L0_TM_MISC3, AUX0_BIT_6, 6, 1)
    FIELD(L0_TM_MISC3, AUX0_BIT_5, 5, 1)
    FIELD(L0_TM_MISC3, DBG_BUS_SEL, 2, 3)
    FIELD(L0_TM_MISC3, CDR_EN_FPL, 1, 1)
    FIELD(L0_TM_MISC3, CDR_EN_FFL, 0, 1)
REG32(L0_TM_EQ_OFFS1, 0x19b0)
    FIELD(L0_TM_EQ_OFFS1, TM_EQ_OFFS1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ_OFFS1, EQ_OFFSET_CORR_BYP, 1, 7)
    FIELD(L0_TM_EQ_OFFS1, AUX1_BIT_7, 0, 1)
REG32(L0_TM_SAMP0, 0x19b4)
    FIELD(L0_TM_SAMP0, TM_SAMP0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP0, SAMP_CALIB_CLK_DIV_FACTOR, 1, 7)
    FIELD(L0_TM_SAMP0, SAMP_CALIB_CLK_DIV_FORCE, 0, 1)
REG32(L0_TM_EQ12, 0x19b8)
    FIELD(L0_TM_EQ12, TM_EQ12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ12, EQ_CALIB_CLK_DIV_FACTOR, 0, 8)
REG32(L0_TM_MISC4, 0x19bc)
    FIELD(L0_TM_MISC4, TM_MISC4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MISC4, PSO_CLK_LANE_FRM_PCS, 2, 1)
    FIELD(L0_TM_MISC4, BSCAN_MODE_VAL, 1, 1)
    FIELD(L0_TM_MISC4, BSCAN_FORCE_MODE, 0, 1)
REG32(L0_TM_SAMP_STATUS0, 0x1a80)
    FIELD(L0_TM_SAMP_STATUS0, TM_SAMP_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_STATUS0, IQ_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L0_TM_SAMP_STATUS1, 0x1a84)
    FIELD(L0_TM_SAMP_STATUS1, TM_SAMP_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_STATUS1, IQ_SAMP_PH90_CALIB_CODE, 0, 6)
REG32(L0_TM_SAMP_STATUS2, 0x1a88)
    FIELD(L0_TM_SAMP_STATUS2, TM_SAMP_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_STATUS2, IQ_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L0_TM_SAMP_STATUS3, 0x1a8c)
    FIELD(L0_TM_SAMP_STATUS3, TM_SAMP_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_STATUS3, IQ_SAMP_PH270_CALIB_CODE, 0, 6)
REG32(L0_TM_SAMP_STATUS4, 0x1a90)
    FIELD(L0_TM_SAMP_STATUS4, TM_SAMP_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_STATUS4, E_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L0_TM_SAMP_STATUS5, 0x1a94)
    FIELD(L0_TM_SAMP_STATUS5, TM_SAMP_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SAMP_STATUS5, E_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L0_TM_ILL_STATUS0, 0x1a98)
    FIELD(L0_TM_ILL_STATUS0, TM_ILL_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS0, IQ_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS1, 0x1a9c)
    FIELD(L0_TM_ILL_STATUS1, TM_ILL_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS1, IQ_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS2, 0x1aa0)
    FIELD(L0_TM_ILL_STATUS2, TM_ILL_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS2, IQ_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS3, 0x1aa4)
    FIELD(L0_TM_ILL_STATUS3, TM_ILL_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS3, IQ_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS4, 0x1aa8)
    FIELD(L0_TM_ILL_STATUS4, TM_ILL_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS4, IQ_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS5, 0x1aac)
    FIELD(L0_TM_ILL_STATUS5, TM_ILL_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS5, IQ_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS6, 0x1ab0)
    FIELD(L0_TM_ILL_STATUS6, TM_ILL_STATUS6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS6, E_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS7, 0x1ab4)
    FIELD(L0_TM_ILL_STATUS7, TM_ILL_STATUS7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS7, E_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS8, 0x1ab8)
    FIELD(L0_TM_ILL_STATUS8, TM_ILL_STATUS8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS8, E_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS9, 0x1abc)
    FIELD(L0_TM_ILL_STATUS9, TM_ILL_STATUS9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS9, E_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS10, 0x1ac0)
    FIELD(L0_TM_ILL_STATUS10, TM_ILL_STATUS10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS10, E_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_ILL_STATUS11, 0x1ac4)
    FIELD(L0_TM_ILL_STATUS11, TM_ILL_STATUS11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ILL_STATUS11, E_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L0_TM_MISC_ST_0, 0x1ac8)
    FIELD(L0_TM_MISC_ST_0, TM_MISC_ST_0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MISC_ST_0, EYE_SURF_DONE, 5, 1)
    FIELD(L0_TM_MISC_ST_0, SD_CAL_DONE, 4, 1)
    FIELD(L0_TM_MISC_ST_0, SAMP_CAL_DONE, 3, 1)
    FIELD(L0_TM_MISC_ST_0, ILL_CAL_DONE, 2, 1)
    FIELD(L0_TM_MISC_ST_0, EQ_CAL_DONE, 1, 1)
    FIELD(L0_TM_MISC_ST_0, EQ_VALID_ADAPT_CODE, 0, 1)
REG32(L0_TM_SD_ST_0, 0x1acc)
    FIELD(L0_TM_SD_ST_0, TM_SD_ST_0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SD_ST_0, SD_CAL_CODE, 0, 6)
REG32(L0_TM_EYESURF_ST0, 0x1ad0)
    FIELD(L0_TM_EYESURF_ST0, TM_EYESURF_ST0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYESURF_ST0, ERROR_COUNT0, 0, 8)
REG32(L0_TM_EYESURF_ST1, 0x1ad4)
    FIELD(L0_TM_EYESURF_ST1, TM_EYESURF_ST1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EYESURF_ST1, ERROR_COUNT1, 0, 8)
REG32(L0_TM_EQ_ST0, 0x1ad8)
    FIELD(L0_TM_EQ_ST0, TM_EQ_ST0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ_ST0, EQ_ADAPT_CODE0, 0, 8)
REG32(L0_TM_EQ_ST1, 0x1adc)
    FIELD(L0_TM_EQ_ST1, TM_EQ_ST1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ_ST1, EQ_ADAPT_CODE1, 0, 8)
REG32(L0_TM_EQ_ST2, 0x1ae0)
    FIELD(L0_TM_EQ_ST2, TM_EQ_ST2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_EQ_ST2, EQ_CALIB_CODE, 0, 7)
REG32(L0_TM_RXPMA_ST1, 0x1ae4)
    FIELD(L0_TM_RXPMA_ST1, TM_RXPMA_ST1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_RXPMA_ST1, HSRX_OPMODE_STATUS, 0, 8)
REG32(L0_TM_CDR0, 0x1c00)
    FIELD(L0_TM_CDR0, TM_CDR0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR0, FAST_PHASE_LOCK_FORCE, 7, 1)
    FIELD(L0_TM_CDR0, UNUSED, 5, 2)
    FIELD(L0_TM_CDR0, CDR_LOOP_CTRL, 2, 3)
    FIELD(L0_TM_CDR0, SECOND_ORDER_LOOP_DIS, 1, 1)
    FIELD(L0_TM_CDR0, FIRST_ORDER_LOOP_DIS, 0, 1)
REG32(L0_TM_CDR1, 0x1c04)
    FIELD(L0_TM_CDR1, TM_CDR1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR1, RESET_DELAY_2OL, 0, 8)
REG32(L0_TM_CDR2, 0x1c08)
    FIELD(L0_TM_CDR2, TM_CDR2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR2, CLK_SEL_2OL, 6, 2)
    FIELD(L0_TM_CDR2, INTEGRATOR_THRESH_2OL, 0, 6)
REG32(L0_TM_CDR3, 0x1c0c)
    FIELD(L0_TM_CDR3, TM_CDR3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR3, UNUSED, 7, 1)
    FIELD(L0_TM_CDR3, SIGNAL_THRESH_1OL, 0, 7)
REG32(L0_TM_CDR4, 0x1c10)
    FIELD(L0_TM_CDR4, TM_CDR4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR4, UNUSED, 7, 1)
    FIELD(L0_TM_CDR4, SIGNAL_THRESH_2OL, 0, 7)
REG32(L0_TM_CDR5, 0x1c14)
    FIELD(L0_TM_CDR5, TM_CDR5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR5, FPHL_FSM_ACC_CYCLES, 5, 3)
    FIELD(L0_TM_CDR5, FFL_PH0_INT_GAIN, 0, 5)
REG32(L0_TM_CDR6, 0x1c18)
    FIELD(L0_TM_CDR6, TM_CDR6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR6, FPHL_FSM_DELAY_CYCLES, 5, 3)
    FIELD(L0_TM_CDR6, FFL_PH1_INT_GAIN, 0, 5)
REG32(L0_TM_CDR7, 0x1c1c)
    FIELD(L0_TM_CDR7, TM_CDR7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR7, FPHL_FSM_TRIGGER1_WAIT_CYCLES, 5, 3)
    FIELD(L0_TM_CDR7, FFL_PH2_INT_GAIN, 0, 5)
REG32(L0_TM_CDR8, 0x1c20)
    FIELD(L0_TM_CDR8, TM_CDR8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR8, FPHL_FSM_TRIGGER2_WAIT_CYCLES, 5, 3)
    FIELD(L0_TM_CDR8, FFL_PH3_INT_GAIN, 0, 5)
REG32(L0_TM_CDR9, 0x1c24)
    FIELD(L0_TM_CDR9, TM_CDR9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR9, FPHL_FSM_TRIGGER3_WAIT_CYCLES, 5, 3)
    FIELD(L0_TM_CDR9, FFL_PH4_INT_GAIN, 0, 5)
REG32(L0_TM_CDR10, 0x1c28)
    FIELD(L0_TM_CDR10, TM_CDR10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR10, FFL_TIME_PER_PHASE_10_8, 5, 3)
    FIELD(L0_TM_CDR10, FFL_PH5_INT_GAIN, 0, 5)
REG32(L0_TM_CDR11, 0x1c2c)
    FIELD(L0_TM_CDR11, TM_CDR11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR11, UNUSED, 5, 3)
    FIELD(L0_TM_CDR11, FFL_PH6_INT_GAIN, 0, 5)
REG32(L0_TM_CDR12, 0x1c30)
    FIELD(L0_TM_CDR12, TM_CDR12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR12, CDRLF_RESET_ON_EN_CDR, 7, 1)
    FIELD(L0_TM_CDR12, CDRLF_RESET_ON_INT_MAX_2OL, 6, 1)
    FIELD(L0_TM_CDR12, CDRLF_RESET_ON_MODE_CHG, 5, 1)
    FIELD(L0_TM_CDR12, FFL_PH7_INT_GAIN, 0, 5)
REG32(L0_TM_CDR13, 0x1c34)
    FIELD(L0_TM_CDR13, TM_CDR13_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR13, FFL_TIME_PER_PHASE_7_0, 0, 8)
REG32(L0_TM_CDR14, 0x1c38)
    FIELD(L0_TM_CDR14, TM_CDR14_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR14, FFL_PH3_POST_INT_GAIN, 6, 2)
    FIELD(L0_TM_CDR14, FFL_PH2_POST_INT_GAIN, 4, 2)
    FIELD(L0_TM_CDR14, FFL_PH1_POST_INT_GAIN, 2, 2)
    FIELD(L0_TM_CDR14, FFL_PH0_POST_INT_GAIN, 0, 2)
REG32(L0_TM_CDR15, 0x1c3c)
    FIELD(L0_TM_CDR15, TM_CDR15_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR15, FFL_PH7_POST_INT_GAIN, 6, 2)
    FIELD(L0_TM_CDR15, FFL_PH6_POST_INT_GAIN, 4, 2)
    FIELD(L0_TM_CDR15, FFL_PH5_POST_INT_GAIN, 2, 2)
    FIELD(L0_TM_CDR15, FFL_PH4_POST_INT_GAIN, 0, 2)
REG32(L0_TM_CDR16, 0x1c40)
    FIELD(L0_TM_CDR16, TM_CDR16_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR16, UNUSED, 5, 3)
    FIELD(L0_TM_CDR16, FFL_PH0_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR17, 0x1c44)
    FIELD(L0_TM_CDR17, TM_CDR17_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR17, UNUSED, 5, 3)
    FIELD(L0_TM_CDR17, FFL_PH1_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR18, 0x1c48)
    FIELD(L0_TM_CDR18, TM_CDR18_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR18, UNUSED, 5, 3)
    FIELD(L0_TM_CDR18, FFL_PH2_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR19, 0x1c4c)
    FIELD(L0_TM_CDR19, TM_CDR19_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR19, UNUSED, 5, 3)
    FIELD(L0_TM_CDR19, FFL_PH3_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR20, 0x1c50)
    FIELD(L0_TM_CDR20, TM_CDR20_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR20, UNUSED, 5, 3)
    FIELD(L0_TM_CDR20, FFL_PH4_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR21, 0x1c54)
    FIELD(L0_TM_CDR21, TM_CDR21_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR21, UNUSED, 5, 3)
    FIELD(L0_TM_CDR21, FFL_PH5_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR22, 0x1c58)
    FIELD(L0_TM_CDR22, TM_CDR22_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR22, UNUSED, 5, 3)
    FIELD(L0_TM_CDR22, FFL_PH6_PROP_GAIN, 0, 5)
REG32(L0_TM_CDR23, 0x1c5c)
    FIELD(L0_TM_CDR23, TM_CDR23_31_8_RSVD, 24, 8)
    FIELD(L0_TM_CDR23, UNUSED, 7, 1)
    FIELD(L0_TM_CDR23, PHASE_LAG_LEAD_RESPONSE, 5, 2)
    FIELD(L0_TM_CDR23, FFL_PH7_PROP_GAIN, 0, 5)
REG32(L0_TM_MISC0, 0x1c60)
    FIELD(L0_TM_MISC0, TM_MISC0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MISC0, UNUSED, 2, 6)
    FIELD(L0_TM_MISC0, DBG0_SEL, 0, 2)
REG32(L0_TM_HSRX_ST0, 0x1c64)
    FIELD(L0_TM_HSRX_ST0, TM_HSRX_ST0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_HSRX_ST0, FAST_LOCK_STATUS, 0, 1)
REG32(L0_TM_PLL_LS_CLOCK, 0x2000)
    FIELD(L0_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK, 0, 8)
REG32(L0_TM_PLL_LOOP_FILT, 0x2004)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_PLL_LOOP_FILT_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_FORCE_RES_SW_ON, 7, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_HIGH_RES_SW_ON, 6, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_LOW_RES_SW_ON, 5, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_PCIE_R1_DEFAULT_RES_SW_ON, 4, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_PCIE_R1_HIGH_RES_SW_ON, 3, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_PCIE_R1_LOW_RES_SW_ON, 2, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_BYPASS_SEC_LOOP_FILTER, 1, 1)
    FIELD(L0_TM_PLL_LOOP_FILT, TM_SEC_LOOP, 0, 1)
REG32(L0_TM_PLL_DIG2, 0x2008)
    FIELD(L0_TM_PLL_DIG2, TM_PLL_DIG2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG2, TM_FBDIV_0_LSB, 7, 1)
    FIELD(L0_TM_PLL_DIG2, TM_PLL_HS_CLOCK_0, 0, 7)
REG32(L0_TM_PLL_FBDIV, 0x200c)
    FIELD(L0_TM_PLL_FBDIV, TM_PLL_FBDIV_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_FBDIV, TM_FBDIV_1, 0, 8)
REG32(L0_TM_PLL_DIG4, 0x2010)
    FIELD(L0_TM_PLL_DIG4, TM_PLL_DIG4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG4, TM_VCO_CLOCK_PULDN, 7, 1)
    FIELD(L0_TM_PLL_DIG4, TM_FORCE_ANA_COARSEDONE, 6, 1)
    FIELD(L0_TM_PLL_DIG4, TM_ANA_COARSEDONE, 5, 1)
    FIELD(L0_TM_PLL_DIG4, TM_FORCE_COARSE_DONE_INT, 4, 1)
    FIELD(L0_TM_PLL_DIG4, TM_COARSE_DONE_INT, 3, 1)
    FIELD(L0_TM_PLL_DIG4, TM_FORCE_FBDIV, 2, 1)
    FIELD(L0_TM_PLL_DIG4, TM_FBDIV_2, 0, 2)
REG32(L0_TM_PLL_DIG5, 0x2014)
    FIELD(L0_TM_PLL_DIG5, TM_PLL_DIG5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG5, TM_PD_6GHZ_LOWNOISE_RING, 7, 1)
    FIELD(L0_TM_PLL_DIG5, TM_PD_6GHZ_RING, 6, 1)
    FIELD(L0_TM_PLL_DIG5, TM_COARSE_PROG, 1, 5)
    FIELD(L0_TM_PLL_DIG5, TM_FORCE_VCO_CLOCK_PULDN, 0, 1)
REG32(L0_TM_PLL_DIG6, 0x2018)
    FIELD(L0_TM_PLL_DIG6, TM_PLL_DIG6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG6, TM_CONFG_CHNG_CYCLES_0_LSB, 7, 1)
    FIELD(L0_TM_PLL_DIG6, TM_VCO_SETTLE_CYCLES, 5, 2)
    FIELD(L0_TM_PLL_DIG6, TM_INITIAL_WAIT_CYCLES, 3, 2)
    FIELD(L0_TM_PLL_DIG6, TM_FORCE_COARSE_PROG_PD_RING, 2, 1)
    FIELD(L0_TM_PLL_DIG6, TM_PD_1P5GHZ_RING, 1, 1)
    FIELD(L0_TM_PLL_DIG6, TM_PD_3GHZ_RING, 0, 1)
REG32(L0_TM_PLL_DIG7, 0x201c)
    FIELD(L0_TM_PLL_DIG7, TM_PLL_DIG7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG7, TM_CPUMP_CODE_0_LSB, 7, 1)
    FIELD(L0_TM_PLL_DIG7, TM_FORCE_ANA_START_LOOP, 6, 1)
    FIELD(L0_TM_PLL_DIG7, TM_ANA_START_LOOP, 5, 1)
    FIELD(L0_TM_PLL_DIG7, TM_PLL_LOCK_CYCLES, 3, 2)
    FIELD(L0_TM_PLL_DIG7, TM_STAND_BY_SETTLE_CYCLES, 1, 2)
    FIELD(L0_TM_PLL_DIG7, TM_CONFG_CHNG_CYCLES_1_MSB, 0, 1)
REG32(L0_TM_PLL_CPUMP_CODE_1, 0x2020)
    FIELD(L0_TM_PLL_CPUMP_CODE_1, TM_PLL_CPUMP_CODE_1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_CPUMP_CODE_1, TM_CPUMP_CODE_1, 0, 8)
REG32(L0_TM_PLL_DIG9, 0x2024)
    FIELD(L0_TM_PLL_DIG9, TM_PLL_DIG9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG9, TM_PLL_RSVD, 6, 2)
    FIELD(L0_TM_PLL_DIG9, TM_FB_BY2_BYPASS, 5, 1)
    FIELD(L0_TM_PLL_DIG9, TM_FORCE_CP_CODE, 4, 1)
    FIELD(L0_TM_PLL_DIG9, TM_CPUMP_CODE_2_MSB, 0, 4)
REG32(L0_TM_PLL_COARSE_CODE_LSB, 0x2028)
    FIELD(L0_TM_PLL_COARSE_CODE_LSB, TM_PLL_COARSE_CODE_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_COARSE_CODE_LSB, TM_COARSE_CODE_LSB, 0, 8)
REG32(L0_TM_PLL_DIG11, 0x202c)
    FIELD(L0_TM_PLL_DIG11, TM_PLL_DIG11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG11, TM_CONST_NDAC_CNTRL, 4, 4)
    FIELD(L0_TM_PLL_DIG11, TM_FORCE_COARSE_CODE, 3, 1)
    FIELD(L0_TM_PLL_DIG11, TM_COARSE_CODE_MSB, 0, 3)
REG32(L0_TM_PLL_DIG12, 0x2030)
    FIELD(L0_TM_PLL_DIG12, TM_PLL_DIG12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG12, TM_FORCE_PTAT_NDAC_CNTRL, 7, 1)
    FIELD(L0_TM_PLL_DIG12, TM_PTAT_NDAC_CNTRL, 1, 6)
    FIELD(L0_TM_PLL_DIG12, TM_FORCE_CONST_NDAC_CNTRL, 0, 1)
REG32(L0_TM_PLL_CONST_PMOS, 0x2034)
    FIELD(L0_TM_PLL_CONST_PMOS, TM_PLL_CONST_PMOS_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_CONST_PMOS, TM_CONST_PMOS_CNTRL, 0, 8)
REG32(L0_TM_PLL_DIG14, 0x2038)
    FIELD(L0_TM_PLL_DIG14, TM_PLL_DIG14_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG14, TM_COARSE_CODE_AFTER_V2I_0_LSB, 1, 7)
    FIELD(L0_TM_PLL_DIG14, TM_FORCE_CONST_PMOS_CNTRL, 0, 1)
REG32(L0_TM_PLL_DIG15, 0x203c)
    FIELD(L0_TM_PLL_DIG15, TM_PLL_DIG15_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG15, TM_V2I_CODE_0_LSB, 5, 3)
    FIELD(L0_TM_PLL_DIG15, TM_FORCE_COARSE_CODE_AFTER_V2I, 4, 1)
    FIELD(L0_TM_PLL_DIG15, TM_COARSE_CODE_AFTER_V2I_1_MSB, 0, 4)
REG32(L0_TM_PLL_DIG16, 0x2040)
    FIELD(L0_TM_PLL_DIG16, TM_PLL_DIG16_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG16, TM_FORCE_PLL_LOCK, 7, 1)
    FIELD(L0_TM_PLL_DIG16, TM_PLL_LOCK, 6, 1)
    FIELD(L0_TM_PLL_DIG16, TM_FORCE_SS_NO_STEPS_STEP_SIZE, 5, 1)
    FIELD(L0_TM_PLL_DIG16, TM_PLL_RSVD, 4, 1)
    FIELD(L0_TM_PLL_DIG16, TM_FORCE_V2I_CODE, 3, 1)
    FIELD(L0_TM_PLL_DIG16, TM_V2I_CODE_1_MSB, 0, 3)
REG32(L0_TM_PLL_DIG17, 0x2044)
    FIELD(L0_TM_PLL_DIG17, TM_PLL_DIG17_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG17, TM_FB_CLK, 6, 2)
    FIELD(L0_TM_PLL_DIG17, TM_MODE_DEPTH, 3, 3)
    FIELD(L0_TM_PLL_DIG17, TM_MODE_RATE, 0, 3)
REG32(L0_TM_PLL_DIG18, 0x2048)
    FIELD(L0_TM_PLL_DIG18, TM_PLL_DIG18_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG18, TM_PLL_LOCK_PULDN, 7, 1)
    FIELD(L0_TM_PLL_DIG18, TM_STEP_SIZE_CNTRL, 5, 2)
    FIELD(L0_TM_PLL_DIG18, TM_SD_GSHIFT, 3, 2)
    FIELD(L0_TM_PLL_DIG18, TM_SD_DITHER, 1, 2)
    FIELD(L0_TM_PLL_DIG18, TM_PLL_LOCK_INT, 0, 1)
REG32(L0_TM_PLL_DIG19, 0x204c)
    FIELD(L0_TM_PLL_DIG19, TM_PLL_DIG19_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG19, TM_FORCE_EN_CLOCK_HS_DIV_2, 7, 1)
    FIELD(L0_TM_PLL_DIG19, TM_EN_CLOCK_HS_DIV_2, 6, 1)
    FIELD(L0_TM_PLL_DIG19, TM_PLL_HS_CLOCK_1, 3, 3)
    FIELD(L0_TM_PLL_DIG19, TM_PD_PFD, 2, 1)
    FIELD(L0_TM_PLL_DIG19, TM_FORCE_PD_PFD, 1, 1)
    FIELD(L0_TM_PLL_DIG19, TM_SELECT_PCI_2P5, 0, 1)
REG32(L0_TM_PLL_DIG20, 0x2050)
    FIELD(L0_TM_PLL_DIG20, TM_PLL_DIG20_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG20, TM_PLL_HALF_FULL_RATE, 7, 1)
    FIELD(L0_TM_PLL_DIG20, TM_PLL_RSVD, 6, 1)
    FIELD(L0_TM_PLL_DIG20, TM_V2I_PROG, 1, 5)
    FIELD(L0_TM_PLL_DIG20, TM_FORCE_V2I_PROG, 0, 1)
REG32(L0_TM_PLL_DIG21, 0x2054)
    FIELD(L0_TM_PLL_DIG21, TM_PLL_DIG21_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG21, TM_FORCE_EN_PLL_LDO_0P9_REF, 7, 1)
    FIELD(L0_TM_PLL_DIG21, ANA_TM_EN_PLL_0P9_FORCE_SW, 6, 1)
    FIELD(L0_TM_PLL_DIG21, TM_PLL_PD_OPDIV_SYM, 5, 1)
    FIELD(L0_TM_PLL_DIG21, TM_FORCE_PLL_PD_OPDIV_SYM, 4, 1)
    FIELD(L0_TM_PLL_DIG21, TM_PLL_RSVD_1, 3, 1)
    FIELD(L0_TM_PLL_DIG21, TM_PLL_RSVD_2, 2, 1)
    FIELD(L0_TM_PLL_DIG21, TM_PLL_EN, 1, 1)
    FIELD(L0_TM_PLL_DIG21, TM_FORCE_PLL_EN, 0, 1)
REG32(L0_TM_PLL_DIG22, 0x2058)
    FIELD(L0_TM_PLL_DIG22, TM_PLL_DIG22_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG22, TM_PLL_RSVD, 7, 1)
    FIELD(L0_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF_CP, 6, 1)
    FIELD(L0_TM_PLL_DIG22, TM_FORCE_EN_PLL_LDO_0P9_REF_CP, 5, 1)
    FIELD(L0_TM_PLL_DIG22, TM_FORCE_COARSE_START, 4, 1)
    FIELD(L0_TM_PLL_DIG22, TM_FORCE_PD_PLL_LDO_1P4, 3, 1)
    FIELD(L0_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL_DELAYED, 2, 1)
    FIELD(L0_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL, 1, 1)
    FIELD(L0_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF, 0, 1)
REG32(L0_TM_PLL_DIG23, 0x205c)
    FIELD(L0_TM_PLL_DIG23, TM_PLL_DIG23_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG23, BF_7, 7, 1)
    FIELD(L0_TM_PLL_DIG23, PLL_TM_VCO_LDO_BYPASS, 6, 1)
    FIELD(L0_TM_PLL_DIG23, TM_ANA_EN_LL_DELAYED, 5, 1)
    FIELD(L0_TM_PLL_DIG23, TM_ANA_EN_LL, 4, 1)
    FIELD(L0_TM_PLL_DIG23, TM_ANA_PD_PLL, 3, 1)
    FIELD(L0_TM_PLL_DIG23, TM_FORCE_PLL_PD, 2, 1)
    FIELD(L0_TM_PLL_DIG23, TM_ANA_COARSE_START, 1, 1)
    FIELD(L0_TM_PLL_DIG23, TM_PD_PLL_LDO_1P4, 0, 1)
REG32(L0_TM_PLL_DIG24, 0x2060)
    FIELD(L0_TM_PLL_DIG24, TM_PLL_DIG24_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG24, TM_PLL_RSVD, 7, 1)
    FIELD(L0_TM_PLL_DIG24, PLL_TM_VCO_LDO, 1, 6)
    FIELD(L0_TM_PLL_DIG24, PLL_TM_VCO_LDO_BYPASS_WITH_SEQUENCE, 0, 1)
REG32(L0_TM_PLL_DIG25, 0x2064)
    FIELD(L0_TM_PLL_DIG25, TM_PLL_DIG25_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG25, TM_FORCE_RST_N_HSRIPPLE, 7, 1)
    FIELD(L0_TM_PLL_DIG25, TM_RST_N_HSRIPPLE, 6, 1)
    FIELD(L0_TM_PLL_DIG25, TM_PLL_ATB_CNTRL, 1, 5)
    FIELD(L0_TM_PLL_DIG25, TM_PLL_OBSERVE_PTAT_10U, 0, 1)
REG32(L0_TM_PLL_DIG26, 0x2068)
    FIELD(L0_TM_PLL_DIG26, TM_PLL_DIG26_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG26, TM_PLL_RSVD, 7, 1)
    FIELD(L0_TM_PLL_DIG26, TM_PD_PLL_PTAT, 6, 1)
    FIELD(L0_TM_PLL_DIG26, TM_FORCE_PD_PLL_PTAT, 5, 1)
    FIELD(L0_TM_PLL_DIG26, TM_USB3_R2_HIGH_RES_SW_ON, 4, 1)
    FIELD(L0_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIV2_LOOP_OUT, 3, 1)
    FIELD(L0_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIRECT_LOOP_OUT, 2, 1)
    FIELD(L0_TM_PLL_DIG26, TM_PLL_SEL_VCO_HISPEED_DIV2_LOOP_OUT, 1, 1)
    FIELD(L0_TM_PLL_DIG26, TM_FORCE_LOOP_PATH, 0, 1)
REG32(L0_TM_PLL_CLK_DIST_NTRIM_LSB, 0x206c)
    FIELD(L0_TM_PLL_CLK_DIST_NTRIM_LSB, TM_PLL_CLK_DIST_NTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_CLK_DIST_NTRIM_LSB, TM_CLKDIST_BIAS_NTRIM_LSB, 0, 8)
REG32(L0_TM_PLL_CLK_DIST_PTRIM_LSB, 0x2070)
    FIELD(L0_TM_PLL_CLK_DIST_PTRIM_LSB, TM_PLL_CLK_DIST_PTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_CLK_DIST_PTRIM_LSB, TM_CLKDIST_BIAS_PTRIM_LSB, 0, 8)
REG32(L0_TM_PLL_DIG_29, 0x2074)
    FIELD(L0_TM_PLL_DIG_29, TM_PLL_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_MRSTBUF_SUP, 7, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_LRSTBUF_SUP, 6, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_RST_RPTR, 5, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_RST_RPTR, 4, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_CLK_RPTR, 3, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_CLK_RPTR, 2, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_CLKDIST_BIAS_PTRIM_MSB, 1, 1)
    FIELD(L0_TM_PLL_DIG_29, TM_CLKDIST_BIAS_NTRIM_MSB, 0, 1)
REG32(L0_TM_PLL_DIG_30, 0x2078)
    FIELD(L0_TM_PLL_DIG_30, TM_PLL_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_BIAS, 7, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_BIAS, 6, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_CMN_BIAS, 5, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_CMN_BIAS, 4, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_CLKDIST_SUP_OBSRV, 3, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RSTMUX_SUP, 2, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RPTR_RSTBUF_SUP, 1, 1)
    FIELD(L0_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_MUS_SUP, 0, 1)
REG32(L0_TM_PLL_DIG_31, 0x207c)
    FIELD(L0_TM_PLL_DIG_31, TM_PLL_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 7, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 6, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_RST_DRIVE, 5, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_RST_DRIVE, 4, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_CLK_DRIVE, 3, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_CLK_DRIVE, 2, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_CLKDIST_BIAS_RATE_SEL, 1, 1)
    FIELD(L0_TM_PLL_DIG_31, TM_FORCE_CLKDIST_BIAS_RATE_SEL, 0, 1)
REG32(L0_TM_PLL_DIG_32, 0x2080)
    FIELD(L0_TM_PLL_DIG_32, TM_PLL_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_32, TM_CLKDIST_MUX_XVCR_CLK_EN, 7, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_FORCE_CLKDIST_MUX_XVCR_CLK_EN, 6, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_FORCE_LOAD_FBDIV, 5, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_LOAD_FBDIV, 4, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_FORCE_RST_FDBK_DIV, 3, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_RST_FDBK_DIV, 2, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_CLKDIST_ENABLE_MASTER_RST_DRIVE, 1, 1)
    FIELD(L0_TM_PLL_DIG_32, TM_FORCE_CLKDIST_ENABLE_MASTER_RST_DRIVE, 0, 1)
REG32(L0_TM_PLL_DIG_33, 0x2084)
    FIELD(L0_TM_PLL_DIG_33, TM_PLL_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_33, TM_FORCE_TX_CLK_RST_REL, 7, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_TX_CLK_RST_REL, 6, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_CLKDIST_MUX_XCVR_MASTER_RST_EN, 5, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_XCVR_MASTER_RST_EN, 4, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_CLKDIST_MUX_MASTER_CLK_SEL, 3, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_MASTER_CLK_SEL, 2, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_CLKDIST_MUX_LOCAL_CLK_SEL, 1, 1)
    FIELD(L0_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_LOCAL_CLK_SEL, 0, 1)
REG32(L0_TM_PLL_DIG_34, 0x2088)
    FIELD(L0_TM_PLL_DIG_34, TM_PLL_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_34, TM_PLL_RSVD, 7, 1)
    FIELD(L0_TM_PLL_DIG_34, TM_FBDIV_3_MSB, 2, 5)
    FIELD(L0_TM_PLL_DIG_34, TM_SEL_VCO_OUT, 1, 1)
    FIELD(L0_TM_PLL_DIG_34, TM_FORCE_SEL_VCO_OUT, 0, 1)
REG32(L0_TM_PLL_DIG_35, 0x208c)
    FIELD(L0_TM_PLL_DIG_35, TM_PLL_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_35, TM_CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L0_TM_PLL_DIG_35, TM_CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L0_TM_PLL_DIG_35, TM_CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L0_TM_PLL_DIG_35, TM_CLKDIST_RPTR_SPARE, 0, 2)
REG32(L0_TM_PLL_DIG_36, 0x2090)
    FIELD(L0_TM_PLL_DIG_36, TM_PLL_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_36, CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L0_TM_PLL_DIG_36, CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L0_TM_PLL_DIG_36, CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L0_TM_PLL_DIG_36, CLKDIST_RPTR_SPARE, 0, 2)
REG32(L0_TM_PLL_DIG_37, 0x2094)
    FIELD(L0_TM_PLL_DIG_37, TM_PLL_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_DIG_37, TM_COARSE_CODE_SAT_VALUE_LSB, 5, 3)
    FIELD(L0_TM_PLL_DIG_37, TM_ENABLE_COARSE_SATURATION, 4, 1)
    FIELD(L0_TM_PLL_DIG_37, W_SPARE_OUTPUTS, 2, 2)
    FIELD(L0_TM_PLL_DIG_37, TM_FORCE_EN_IP_DIV_BYPASS, 1, 1)
    FIELD(L0_TM_PLL_DIG_37, TM_EN_IP_DIV_BYPASS, 0, 1)
REG32(L0_TM_PLL_COARSE_CODE_SAT_MSB, 0x2098)
    FIELD(L0_TM_PLL_COARSE_CODE_SAT_MSB, TM_PLL_COARSE_CODE_SAT_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PLL_COARSE_CODE_SAT_MSB, TM_COARSE_CODE_SAT_VALUE_MSB, 0, 8)
REG32(L0_MPHY_CFG_HIB8, 0x2300)
    FIELD(L0_MPHY_CFG_HIB8, MPHY_CFG_HIB8_31_8_RSVD, 24, 8)
    FIELD(L0_MPHY_CFG_HIB8, MPHY_HIBERN8_RSVD, 1, 7)
    FIELD(L0_MPHY_CFG_HIB8, MPHY_HIBERN8, 0, 1)
REG32(L0_MPHY_CFG_MODE, 0x2304)
    FIELD(L0_MPHY_CFG_MODE, MPHY_CFG_MODE_31_8_RSVD, 24, 8)
    FIELD(L0_MPHY_CFG_MODE, MPHY_HS_LS_MODE_RSVD, 2, 6)
    FIELD(L0_MPHY_CFG_MODE, MPHY_HS_LS_MODE, 0, 2)
REG32(L0_MPHY_CFG_HS_GEAR, 0x2308)
    FIELD(L0_MPHY_CFG_HS_GEAR, MPHY_CFG_HS_GEAR_31_8_RSVD, 24, 8)
    FIELD(L0_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR_RSVD, 2, 6)
    FIELD(L0_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR, 0, 2)
REG32(L0_MPHY_CFG_HS_RATE, 0x230c)
    FIELD(L0_MPHY_CFG_HS_RATE, MPHY_CFG_HS_RATE_31_8_RSVD, 24, 8)
    FIELD(L0_MPHY_CFG_HS_RATE, MPHY_RATE_RSVD, 1, 7)
    FIELD(L0_MPHY_CFG_HS_RATE, MPHY_RATE, 0, 1)
REG32(L0_MPHY_CFG_PWM, 0x2310)
    FIELD(L0_MPHY_CFG_PWM, MPHY_CFG_PWM_31_8_RSVD, 24, 8)
    FIELD(L0_MPHY_CFG_PWM, MPHY_PWM_GEAR_RSVD, 3, 5)
    FIELD(L0_MPHY_CFG_PWM, MPHY_PWM_GEAR, 0, 3)
REG32(L0_PLL_OPDIV_LS, 0x2314)
    FIELD(L0_PLL_OPDIV_LS, PLL_OPDIV_LS_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_OPDIV_LS, TM_SEL_OPDIV_FOR_REFCLK, 7, 1)
    FIELD(L0_PLL_OPDIV_LS, ANA_OPDIV_LS, 0, 7)
REG32(L0_MPHY_CFG_UPDT, 0x2318)
    FIELD(L0_MPHY_CFG_UPDT, MPHY_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L0_MPHY_CFG_UPDT, MPHY_CFGUPDT_RSVD, 1, 7)
    FIELD(L0_MPHY_CFG_UPDT, MPHY_CFGUPDT, 0, 1)
REG32(L0_PLL_TM_DIV_CNTRLS, 0x231c)
    FIELD(L0_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_DIV_CNTRLS, TM_FORCE_PD_OPDIV_LS, 7, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, TM_PD_OPDIV_LS, 6, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_RSVD, 5, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, TM_BYPASS_OPDIV_LS_MOD, 4, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, TM_FORCE_PLL_PD_HS, 3, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, TM_PLL_PD_HS, 2, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, SEL_IP_MUX_CONTROL, 1, 1)
    FIELD(L0_PLL_TM_DIV_CNTRLS, TM_SWAP_OP_MUX_CONTROL, 0, 1)
REG32(L0_PLL_FBDIV_G1A_LSB, 0x2320)
    FIELD(L0_PLL_FBDIV_G1A_LSB, PLL_FBDIV_G1A_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G1A_LSB, FBDIV_G1A_LSB, 0, 8)
REG32(L0_PLL_FBDIV_G1B_LSB, 0x2324)
    FIELD(L0_PLL_FBDIV_G1B_LSB, PLL_FBDIV_G1B_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G1B_LSB, FBDIV_G1B_LSB, 0, 8)
REG32(L0_PLL_FBDIV_G2A_LSB, 0x2328)
    FIELD(L0_PLL_FBDIV_G2A_LSB, PLL_FBDIV_G2A_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G2A_LSB, FBDIV_G2A_LSB, 0, 8)
REG32(L0_PLL_FBDIV_G2B_LSB, 0x232c)
    FIELD(L0_PLL_FBDIV_G2B_LSB, PLL_FBDIV_G2B_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G2B_LSB, FBDIV_G2B_LSB, 0, 8)
REG32(L0_PLL_FBDIV_G3A_LSB, 0x2330)
    FIELD(L0_PLL_FBDIV_G3A_LSB, PLL_FBDIV_G3A_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G3A_LSB, FBDIV_G3A_LSB, 0, 8)
REG32(L0_PLL_FBDIV_G3B_LSB, 0x2334)
    FIELD(L0_PLL_FBDIV_G3B_LSB, PLL_FBDIV_G3B_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G3B_LSB, FBDIV_G3B_LSB, 0, 8)
REG32(L0_PLL_FBDIV_G1A_MSB, 0x2338)
    FIELD(L0_PLL_FBDIV_G1A_MSB, PLL_FBDIV_G1A_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G1A_MSB, FBDIV_G1A_MSB, 0, 8)
REG32(L0_PLL_FBDIV_G1B_MSB, 0x233c)
    FIELD(L0_PLL_FBDIV_G1B_MSB, PLL_FBDIV_G1B_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G1B_MSB, FBDIV_G1B_MSB, 0, 8)
REG32(L0_PLL_FBDIV_G2A_MSB, 0x2340)
    FIELD(L0_PLL_FBDIV_G2A_MSB, PLL_FBDIV_G2A_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G2A_MSB, FBDIV_G2A_MSB, 0, 8)
REG32(L0_PLL_FBDIV_G2B_MSB, 0x2344)
    FIELD(L0_PLL_FBDIV_G2B_MSB, PLL_FBDIV_G2B_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G2B_MSB, FBDIV_G2B_MSB, 0, 8)
REG32(L0_PLL_FBDIV_G3A_MSB, 0x2348)
    FIELD(L0_PLL_FBDIV_G3A_MSB, PLL_FBDIV_G3A_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G3A_MSB, FBDIV_G3A_MSB, 0, 8)
REG32(L0_PLL_FBDIV_G3B_MSB, 0x234c)
    FIELD(L0_PLL_FBDIV_G3B_MSB, PLL_FBDIV_G3B_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_G3B_MSB, FBDIV_G3B_MSB, 0, 8)
REG32(L0_PLL_IPDIV, 0x2350)
    FIELD(L0_PLL_IPDIV, PLL_IPDIV_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_IPDIV, PLL_IPDIV, 0, 8)
REG32(L0_PLL_FBDIV_FRAC_0_LSB, 0x2354)
    FIELD(L0_PLL_FBDIV_FRAC_0_LSB, PLL_FBDIV_FRAC_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_FRAC_0_LSB, FBDIV_FRAC_0_LSB, 0, 8)
REG32(L0_PLL_FBDIV_FRAC_1, 0x2358)
    FIELD(L0_PLL_FBDIV_FRAC_1, PLL_FBDIV_FRAC_1_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_FRAC_1, FBDIV_FRAC_1, 0, 8)
REG32(L0_PLL_FBDIV_FRAC_2, 0x235c)
    FIELD(L0_PLL_FBDIV_FRAC_2, PLL_FBDIV_FRAC_2_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_FRAC_2, FBDIV_FRAC_2, 0, 8)
REG32(L0_PLL_FBDIV_FRAC_3_MSB, 0x2360)
    FIELD(L0_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSV_RSVD, 7, 1)
    FIELD(L0_PLL_FBDIV_FRAC_3_MSB, TM_FORCE_EN_FRAC, 6, 1)
    FIELD(L0_PLL_FBDIV_FRAC_3_MSB, TM_EN_FRAC, 5, 1)
    FIELD(L0_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB_RSVD, 3, 2)
    FIELD(L0_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB, 0, 3)
REG32(L0_PLL_PWR_SEQ_WAIT_TIME, 0x2364)
    FIELD(L0_PLL_PWR_SEQ_WAIT_TIME, PLL_PWR_SEQ_WAIT_TIME_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_SETTLING, 6, 2)
    FIELD(L0_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_BIAS_SETTLING, 4, 2)
    FIELD(L0_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_SETTLING, 2, 2)
    FIELD(L0_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_RELIABILITY, 0, 2)
REG32(L0_PLL_SS_STEPS_0_LSB, 0x2368)
    FIELD(L0_PLL_SS_STEPS_0_LSB, PLL_SS_STEPS_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_SS_STEPS_0_LSB, SS_NUM_OF_STEPS_0_LSB, 0, 8)
REG32(L0_PLL_SS_STEPS_1_MSB, 0x236c)
    FIELD(L0_PLL_SS_STEPS_1_MSB, PLL_SS_STEPS_1_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB_RSVD, 3, 5)
    FIELD(L0_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB, 0, 3)
REG32(L0_PLL_SS_STEP_SIZE_0_LSB, 0x2370)
    FIELD(L0_PLL_SS_STEP_SIZE_0_LSB, PLL_SS_STEP_SIZE_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_SS_STEP_SIZE_0_LSB, SS_STEP_SIZE_0_LSB, 0, 8)
REG32(L0_PLL_SS_STEP_SIZE_1, 0x2374)
    FIELD(L0_PLL_SS_STEP_SIZE_1, PLL_SS_STEP_SIZE_1_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_SS_STEP_SIZE_1, SS_STEP_SIZE_1, 0, 8)
REG32(L0_PLL_SS_STEP_SIZE_2, 0x2378)
    FIELD(L0_PLL_SS_STEP_SIZE_2, PLL_SS_STEP_SIZE_2_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_SS_STEP_SIZE_2, SS_STEP_SIZE_2, 0, 8)
REG32(L0_PLL_SS_STEP_SIZE_3_MSB, 0x237c)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, PLL_SS_STEP_SIZE_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, TM_FORCE_EN_SS, 7, 1)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, TM_EN_SS, 6, 1)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_NUM_OF_STEPS, 5, 1)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_STEP_SIZE, 4, 1)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, SS_SPREAD_TYPE, 2, 2)
    FIELD(L0_PLL_SS_STEP_SIZE_3_MSB, SS_STEP_SIZE_3_MSB, 0, 2)
REG32(L0_TM_MASK_CFG_UPDT, 0x2380)
    FIELD(L0_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L0_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_RSVD, 7, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, HIBERN8_MASK_CFG_UPDT, 6, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, HS_MODE_MASK_CFG_UPDT, 5, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, LS_MODE_MASK_CFG_UPDT, 4, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, OPDIV_LS_MASK_CFG_UPDT, 3, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, PWM_GEAR_MASK_CFG_UPDT, 2, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, HS_GEAR_MASK_CFG_UPDT, 1, 1)
    FIELD(L0_TM_MASK_CFG_UPDT, HS_RATE_MASK_CFG_UPDT, 0, 1)
REG32(L0_PLL_TM_FORCE_DIV, 0x2384)
    FIELD(L0_PLL_TM_FORCE_DIV, PLL_TM_FORCE_DIV_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_FRAC, 7, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3B, 6, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3A, 5, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2B, 4, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2A, 3, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1B, 2, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1A, 1, 1)
    FIELD(L0_PLL_TM_FORCE_DIV, TM_FORCE_IPDIV, 0, 1)
REG32(L0_PLL_TM_COARSE_CODE_1_LSB, 0x2388)
    FIELD(L0_PLL_TM_COARSE_CODE_1_LSB, PLL_TM_COARSE_CODE_1_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_1_LSB, TM_COARSE_CODE_1_LSB, 0, 8)
REG32(L0_PLL_TM_COARSE_CODE_2_LSB, 0x238c)
    FIELD(L0_PLL_TM_COARSE_CODE_2_LSB, PLL_TM_COARSE_CODE_2_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_2_LSB, TM_COARSE_CODE_2_LSB, 0, 8)
REG32(L0_PLL_TM_COARSE_CODE_3_LSB, 0x2390)
    FIELD(L0_PLL_TM_COARSE_CODE_3_LSB, PLL_TM_COARSE_CODE_3_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_3_LSB, TM_COARSE_CODE_3_LSB, 0, 8)
REG32(L0_PLL_TM_COARSE_CODE_4_LSB, 0x2394)
    FIELD(L0_PLL_TM_COARSE_CODE_4_LSB, PLL_TM_COARSE_CODE_4_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_4_LSB, TM_COARSE_CODE_4_LSB, 0, 8)
REG32(L0_PLL_TM_COARSE_CODE_5_LSB, 0x2398)
    FIELD(L0_PLL_TM_COARSE_CODE_5_LSB, PLL_TM_COARSE_CODE_5_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_5_LSB, TM_COARSE_CODE_5_LSB, 0, 8)
REG32(L0_PLL_TM_COARSE_CODE_6_LSB, 0x239c)
    FIELD(L0_PLL_TM_COARSE_CODE_6_LSB, PLL_TM_COARSE_CODE_6_LSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_6_LSB, TM_COARSE_CODE_6_LSB, 0, 8)
REG32(L0_PLL_TM_COARSE_CODE_1_2_MSB, 0x23a0)
    FIELD(L0_PLL_TM_COARSE_CODE_1_2_MSB, PLL_TM_COARSE_CODE_1_2_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_G1_AB_MSB_RSVD, 6, 2)
    FIELD(L0_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_2_MSB, 3, 3)
    FIELD(L0_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_1_MSB, 0, 3)
REG32(L0_PLL_TM_COARSE_CODE_3_4_MSB, 0x23a4)
    FIELD(L0_PLL_TM_COARSE_CODE_3_4_MSB, PLL_TM_COARSE_CODE_3_4_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_G2_AB_MSB_RSVD, 6, 2)
    FIELD(L0_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_4_MSB, 3, 3)
    FIELD(L0_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_3_MSB, 0, 3)
REG32(L0_PLL_TM_COARSE_CODE_5_6_MSB, 0x23a8)
    FIELD(L0_PLL_TM_COARSE_CODE_5_6_MSB, PLL_TM_COARSE_CODE_5_6_MSB_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_G3_AB_MSB_RSVD, 6, 2)
    FIELD(L0_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_6_MSB, 3, 3)
    FIELD(L0_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_5_MSB, 0, 3)
REG32(L0_PLL_TM_SHARED_0, 0x23ac)
    FIELD(L0_PLL_TM_SHARED_0, PLL_TM_SHARED_0_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_SHARED_0, TM_FORCE_EXTSIGNAL_FOR_HIBERN8, 7, 1)
    FIELD(L0_PLL_TM_SHARED_0, TM_FORCE_REGBIT_FOR_HIBERN8, 6, 1)
    FIELD(L0_PLL_TM_SHARED_0, TM_FORCE_PLL_STANDBY, 5, 1)
    FIELD(L0_PLL_TM_SHARED_0, TM_PLL_STANDBY, 4, 1)
    FIELD(L0_PLL_TM_SHARED_0, TM_SLOWN_FAST_BRING_UP_ALWAYS, 3, 1)
    FIELD(L0_PLL_TM_SHARED_0, EN_TM_FOR_BRING_UP_SCHEME, 2, 1)
    FIELD(L0_PLL_TM_SHARED_0, SELECT_HS_FB_DIVIDER, 1, 1)
    FIELD(L0_PLL_TM_SHARED_0, TM_BYPASS_COARSE_SEARCH, 0, 1)
REG32(L0_PLL_TM_FRAC_OFFSET_0, 0x23b0)
    FIELD(L0_PLL_TM_FRAC_OFFSET_0, PLL_TM_FRAC_OFFSET_0_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_FRAC_OFFSET_0, TM_FRAC_OFFSET_LSB_0, 0, 8)
REG32(L0_PLL_TM_FRAC_OFFSET_1, 0x23b4)
    FIELD(L0_PLL_TM_FRAC_OFFSET_1, PLL_TM_FRAC_OFFSET_1_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_FRAC_OFFSET_1, TM_FRAC_OFFSET_1, 0, 8)
REG32(L0_PLL_TM_FRAC_OFFSET_2, 0x23b8)
    FIELD(L0_PLL_TM_FRAC_OFFSET_2, PLL_TM_FRAC_OFFSET_2_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_TM_FRAC_OFFSET_2, TM_PLL_RSVD, 2, 6)
    FIELD(L0_PLL_TM_FRAC_OFFSET_2, TM_FORCE_FBDIV_FRAC_OFFSET, 1, 1)
    FIELD(L0_PLL_TM_FRAC_OFFSET_2, TM_FRAC_OFFSET_MSB_2, 0, 1)
REG32(L0_PLL_STATUS_READ_0, 0x23e0)
    FIELD(L0_PLL_STATUS_READ_0, PLL_STATUS_READ_0_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_STATUS_READ_0, PLL_COARSE_CODE_LSB_STATUS_READ, 0, 8)
REG32(L0_PLL_STATUS_READ_1, 0x23e4)
    FIELD(L0_PLL_STATUS_READ_1, PLL_STATUS_READ_1_31_8_RSVD, 24, 8)
    FIELD(L0_PLL_STATUS_READ_1, PLL_STATUS_READ_1_RSVD, 6, 2)
    FIELD(L0_PLL_STATUS_READ_1, PLL_START_LOOP_STATUS_READ, 5, 1)
    FIELD(L0_PLL_STATUS_READ_1, PLL_LOCK_STATUS_READ, 4, 1)
    FIELD(L0_PLL_STATUS_READ_1, PLL_COARSE_DONE_STATUS_READ, 3, 1)
    FIELD(L0_PLL_STATUS_READ_1, PLL_COARSE_CODE_MSB_STATUS_READ, 0, 3)
REG32(L0_TM_BG_PROG0, 0x2800)
    FIELD(L0_TM_BG_PROG0, TM_BG_PROG0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_PROG0, TM_BG_PROG0_7_RSVD, 7, 1)
    FIELD(L0_TM_BG_PROG0, IRCONST_PAD, 6, 1)
    FIELD(L0_TM_BG_PROG0, BG_PDN_OK_CTRL, 5, 1)
    FIELD(L0_TM_BG_PROG0, BG_PDN_OK_BYP, 4, 1)
    FIELD(L0_TM_BG_PROG0, BG_PTAT_PDN_OK_CTRL, 3, 1)
    FIELD(L0_TM_BG_PROG0, BG_PTAT_PDN_OK_BYP, 2, 1)
    FIELD(L0_TM_BG_PROG0, BG_PDN_CTRL, 1, 1)
    FIELD(L0_TM_BG_PROG0, BG_PDN_BYP, 0, 1)
REG32(L0_TM_BG_PROG1, 0x2804)
    FIELD(L0_TM_BG_PROG1, TM_BG_PROG1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_PROG1, TM_STARTUP_SWITCHOFF, 7, 1)
    FIELD(L0_TM_BG_PROG1, TM_FORCE_PULLDOWN, 6, 1)
    FIELD(L0_TM_BG_PROG1, TM_DEC_CRUDE_SUPPLY, 5, 1)
    FIELD(L0_TM_BG_PROG1, TM_INC_CRUDE_SUPPLY, 4, 1)
    FIELD(L0_TM_BG_PROG1, TM_EN_1P2V_SUPPORT, 3, 1)
    FIELD(L0_TM_BG_PROG1, TM_EN_VTH_COMP_OUT, 2, 1)
    FIELD(L0_TM_BG_PROG1, TM_EN_SEL_CRUDE_SUPPLY, 1, 1)
    FIELD(L0_TM_BG_PROG1, TM_EN_OUT_BYP, 0, 1)
REG32(L0_TM_ANA_BG_TESTBIT0, 0x2808)
    FIELD(L0_TM_ANA_BG_TESTBIT0, TM_ANA_BG_TESTBIT0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT0, BG_ANA_CTRL0, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT1, 0x280c)
    FIELD(L0_TM_ANA_BG_TESTBIT1, TM_ANA_BG_TESTBIT1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT1, BG_ANA_CTRL1, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT2, 0x2810)
    FIELD(L0_TM_ANA_BG_TESTBIT2, TM_ANA_BG_TESTBIT2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT2, BG_ANA_CTRL2, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT3, 0x2814)
    FIELD(L0_TM_ANA_BG_TESTBIT3, TM_ANA_BG_TESTBIT3_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT3, BG_ANA_CTRL3, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT4, 0x2818)
    FIELD(L0_TM_ANA_BG_TESTBIT4, TM_ANA_BG_TESTBIT4_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT4, BG_ANA_CTRL4, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT5, 0x281c)
    FIELD(L0_TM_ANA_BG_TESTBIT5, TM_ANA_BG_TESTBIT5_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT5, BG_ANA_CTRL5, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT6, 0x2820)
    FIELD(L0_TM_ANA_BG_TESTBIT6, TM_ANA_BG_TESTBIT6_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT6, BG_ANA_CTRL6, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT7, 0x2824)
    FIELD(L0_TM_ANA_BG_TESTBIT7, TM_ANA_BG_TESTBIT7_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT7, BG_ANA_CTRL7, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT8, 0x2828)
    FIELD(L0_TM_ANA_BG_TESTBIT8, TM_ANA_BG_TESTBIT8_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT8, BG_ANA_CTRL8, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT9, 0x282c)
    FIELD(L0_TM_ANA_BG_TESTBIT9, TM_ANA_BG_TESTBIT9_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT9, BG_ANA_CTRL9, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT10, 0x2830)
    FIELD(L0_TM_ANA_BG_TESTBIT10, TM_ANA_BG_TESTBIT10_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT10, BG_ANA_CTRL10, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT11, 0x2834)
    FIELD(L0_TM_ANA_BG_TESTBIT11, TM_ANA_BG_TESTBIT11_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT11, BG_ANA_CTRL11, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT12, 0x2838)
    FIELD(L0_TM_ANA_BG_TESTBIT12, TM_ANA_BG_TESTBIT12_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT12, BG_ANA_CTRL12, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT13, 0x283c)
    FIELD(L0_TM_ANA_BG_TESTBIT13, TM_ANA_BG_TESTBIT13_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT13, BG_ANA_CTRL13, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT14, 0x2840)
    FIELD(L0_TM_ANA_BG_TESTBIT14, TM_ANA_BG_TESTBIT14_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT14, BG_ANA_CTRL14, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT15, 0x2844)
    FIELD(L0_TM_ANA_BG_TESTBIT15, TM_ANA_BG_TESTBIT15_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT15, BG_ANA_CTRL15, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT16, 0x2848)
    FIELD(L0_TM_ANA_BG_TESTBIT16, TM_ANA_BG_TESTBIT16_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT16, BG_ANA_CTRL16, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT17, 0x284c)
    FIELD(L0_TM_ANA_BG_TESTBIT17, TM_ANA_BG_TESTBIT17_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT17, BG_ANA_CTRL17, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT18, 0x2850)
    FIELD(L0_TM_ANA_BG_TESTBIT18, TM_ANA_BG_TESTBIT18_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT18, BG_ANA_CTRL18, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT19, 0x2854)
    FIELD(L0_TM_ANA_BG_TESTBIT19, TM_ANA_BG_TESTBIT19_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT19, BG_ANA_CTRL19, 0, 8)
REG32(L0_TM_ANA_BG_TESTBIT20, 0x2858)
    FIELD(L0_TM_ANA_BG_TESTBIT20, TM_ANA_BG_TESTBIT20_31_8_RSVD, 24, 8)
    FIELD(L0_TM_ANA_BG_TESTBIT20, BG_ANA_CTRL20_7_RSVD, 2, 6)
    FIELD(L0_TM_ANA_BG_TESTBIT20, BG_ANA_CTRL20, 0, 2)
REG32(L0_TM_BG_PROG2, 0x285c)
    FIELD(L0_TM_BG_PROG2, TM_BG_PROG2_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_PROG2, TM_BG_PROG2_6_7_RSVD, 6, 2)
    FIELD(L0_TM_BG_PROG2, FORCE_O_BG_UP, 5, 1)
    FIELD(L0_TM_BG_PROG2, BYPASS_O_BG_UP, 4, 1)
    FIELD(L0_TM_BG_PROG2, FORCE_BG_EN_LL, 3, 1)
    FIELD(L0_TM_BG_PROG2, BYPASS_BG_EN_LL, 2, 1)
    FIELD(L0_TM_BG_PROG2, CNTRL_BG_EN, 1, 1)
    FIELD(L0_TM_BG_PROG2, BYPASS_BG_EN, 0, 1)
REG32(L0_L0_REF_CLK_SEL, 0x2860)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_SEL_31_8_RSVD, 24, 8)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_LCL_SEL, 7, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REFCLK_SEL_6_RSVD, 6, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REFCLK_SEL_5_RSVD, 5, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_SEL_4, 4, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_SEL_3, 3, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_SEL_2, 2, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_SEL_1, 1, 1)
    FIELD(L0_L0_REF_CLK_SEL, L0_REF_CLK_SEL_0, 0, 1)
REG32(L0_L1_REF_CLK_SEL, 0x2864)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_SEL_31_8_RSVD, 24, 8)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_LCL_SEL, 7, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REFCLK_SEL_6_RSVD, 6, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REFCLK_SEL_5_RSVD, 5, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_SEL_4, 4, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_SEL_3, 3, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_SEL_2, 2, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_SEL_1, 1, 1)
    FIELD(L0_L1_REF_CLK_SEL, L1_REF_CLK_SEL_0, 0, 1)
REG32(L0_L2_REF_CLK_SEL, 0x2868)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_SEL_31_8_RSVD, 24, 8)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_LCL_SEL, 7, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REFCLK_SEL_6_RSVD, 6, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REFCLK_SEL_5_RSVD, 5, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_SEL_4, 4, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_SEL_3, 3, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_SEL_2, 2, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_SEL_1, 1, 1)
    FIELD(L0_L2_REF_CLK_SEL, L2_REF_CLK_SEL_0, 0, 1)
REG32(L0_L3_REF_CLK_SEL, 0x286c)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_SEL_31_8_RSVD, 24, 8)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_LCL_SEL, 7, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REFCLK_SEL_6_RSVD, 6, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REFCLK_SEL_5_RSVD, 5, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_SEL_4, 4, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_SEL_3, 3, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_SEL_2, 2, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_SEL_1, 1, 1)
    FIELD(L0_L3_REF_CLK_SEL, L3_REF_CLK_SEL_0, 0, 1)
REG32(L0_L0_REF_CLK_PULLDN, 0x2870)
    FIELD(L0_L0_REF_CLK_PULLDN, L0_REF_CLK_PULLDN_31_8_RSVD, 24, 8)
    FIELD(L0_L0_REF_CLK_PULLDN, L0_REF_CLK_PULLDN_7_4_RSVD, 4, 4)
    FIELD(L0_L0_REF_CLK_PULLDN, L0_REF_CLK_TM_PULLDN2, 3, 1)
    FIELD(L0_L0_REF_CLK_PULLDN, L0_REF_CLK_TM_EN_PULLDN2, 2, 1)
    FIELD(L0_L0_REF_CLK_PULLDN, L0_REF_CLK_TM_PULLDN1, 1, 1)
    FIELD(L0_L0_REF_CLK_PULLDN, L0_REF_CLK_TM_EN_PULLDN1, 0, 1)
REG32(L0_L1_REF_CLK_PULLDN, 0x2874)
    FIELD(L0_L1_REF_CLK_PULLDN, L1_REF_CLK_PULLDN_31_8_RSVD, 24, 8)
    FIELD(L0_L1_REF_CLK_PULLDN, L1_REF_CLK_PULLDN_7_4_RSVD, 4, 4)
    FIELD(L0_L1_REF_CLK_PULLDN, L1_REF_CLK_TM_PULLDN2, 3, 1)
    FIELD(L0_L1_REF_CLK_PULLDN, L1_REF_CLK_TM_EN_PULLDN2, 2, 1)
    FIELD(L0_L1_REF_CLK_PULLDN, L1_REF_CLK_TM_PULLDN1, 1, 1)
    FIELD(L0_L1_REF_CLK_PULLDN, L1_REF_CLK_TM_EN_PULLDN1, 0, 1)
REG32(L0_L2_REF_CLK_PULLDN, 0x2878)
    FIELD(L0_L2_REF_CLK_PULLDN, L2_REF_CLK_PULLDN_31_8_RSVD, 24, 8)
    FIELD(L0_L2_REF_CLK_PULLDN, L2_REF_CLK_PULLDN_7_4_RSVD, 4, 4)
    FIELD(L0_L2_REF_CLK_PULLDN, L2_REF_CLK_TM_PULLDN2, 3, 1)
    FIELD(L0_L2_REF_CLK_PULLDN, L2_REF_CLK_TM_EN_PULLDN2, 2, 1)
    FIELD(L0_L2_REF_CLK_PULLDN, L2_REF_CLK_TM_PULLDN1, 1, 1)
    FIELD(L0_L2_REF_CLK_PULLDN, L2_REF_CLK_TM_EN_PULLDN1, 0, 1)
REG32(L0_L3_REF_CLK_PULLDN, 0x287c)
    FIELD(L0_L3_REF_CLK_PULLDN, L3_REF_CLK_PULLDN_31_8_RSVD, 24, 8)
    FIELD(L0_L3_REF_CLK_PULLDN, L3_REF_CLK_PULLDN_7_4_RSVD, 4, 4)
    FIELD(L0_L3_REF_CLK_PULLDN, L3_REF_CLK_TM_PULLDN2, 3, 1)
    FIELD(L0_L3_REF_CLK_PULLDN, L3_REF_CLK_TM_EN_PULLDN2, 2, 1)
    FIELD(L0_L3_REF_CLK_PULLDN, L3_REF_CLK_TM_PULLDN1, 1, 1)
    FIELD(L0_L3_REF_CLK_PULLDN, L3_REF_CLK_TM_EN_PULLDN1, 0, 1)
REG32(L0_TM_PG_CTRL0, 0x2880)
    FIELD(L0_TM_PG_CTRL0, TM_PG_CTRL0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PG_CTRL0, TM_PG_SPARED, 0, 8)
REG32(L0_TM_PG_CTRL1, 0x2884)
    FIELD(L0_TM_PG_CTRL1, TM_PG_CTRL1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PG_CTRL1, TM_PG_CTRL2_6_7_RSVD, 6, 2)
    FIELD(L0_TM_PG_CTRL1, DVDDCR_OR_VAL, 5, 1)
    FIELD(L0_TM_PG_CTRL1, AVDDIO_OR_VAL, 4, 1)
    FIELD(L0_TM_PG_CTRL1, AVDDCR_OR_VAL, 3, 1)
    FIELD(L0_TM_PG_CTRL1, DVDDCR_OR, 2, 1)
    FIELD(L0_TM_PG_CTRL1, AVDDIO_OR, 1, 1)
    FIELD(L0_TM_PG_CTRL1, AVDDCR_OR, 0, 1)
REG32(L0_TM_SLICER0_CTRL, 0x2888)
    FIELD(L0_TM_SLICER0_CTRL, TM_SLICER0_CTRL_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_CONTROL_7_RSVD, 7, 1)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_SELPLLOUT_TESTOUT, 6, 1)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_SELDIGOUT_TESTOUT, 5, 1)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_OBSERVE_SUP, 4, 1)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_OBSERVE_DIGSUP, 3, 1)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_OBSERVE_DIFSUP, 2, 1)
    FIELD(L0_TM_SLICER0_CTRL, SLICER0_TM_ENABLE_SINGLE_ENDED, 1, 1)
    FIELD(L0_TM_SLICER0_CTRL, REFCLKN01_TM_OBSERVE_SUP, 0, 1)
REG32(L0_TM_SLICER01_BIAS_PROG0, 0x288c)
    FIELD(L0_TM_SLICER01_BIAS_PROG0, TM_SLICER01_BIAS_PROG0_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SLICER01_BIAS_PROG0, SLICER01_TM_BIAS_PROG0, 0, 8)
REG32(L0_TM_SLICER01_BIAS_PROG1, 0x2890)
    FIELD(L0_TM_SLICER01_BIAS_PROG1, TM_SLICER01_BIAS_PROG1_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SLICER01_BIAS_PROG1, SLICER01_TM_BIAS_PROG1_4_7_RSVD, 4, 4)
    FIELD(L0_TM_SLICER01_BIAS_PROG1, SLICER01_TM_BIAS_PROG1, 0, 4)
REG32(L0_TM_SLICER1_CTRL, 0x2894)
    FIELD(L0_TM_SLICER1_CTRL, TM_SLICER1_CTRL_31_8_RSVD, 24, 8)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_CONTROL1_7_RSVD, 7, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_SELPLLOUT_TESTOUT, 6, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_SELDIGOUT_TESTOUT, 5, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_OBSERVE_SUP, 4, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_OBSERVE_DIGSUP, 3, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_OBSERVE_DIFSUP, 2, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_ENABLE_SINGLE_ENDED, 1, 1)
    FIELD(L0_TM_SLICER1_CTRL, SLICER1_TM_CONTROL1_0_RSVD, 0, 1)
REG32(L0_TM_BG_IPTAT_PROG, 0x2898)
    FIELD(L0_TM_BG_IPTAT_PROG, TM_BG_IPTAT_PROG_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_IPTAT_PROG, BG_TM_BG_IPTAT_PROG, 0, 8)
REG32(L0_TM_PG_MUX_SEL, 0x289c)
    FIELD(L0_TM_PG_MUX_SEL, TM_PG_MUX_SEL_31_8_RSVD, 24, 8)
    FIELD(L0_TM_PG_MUX_SEL, TM_BG_MUX_SEL_5_7_RSVD, 5, 3)
    FIELD(L0_TM_PG_MUX_SEL, PG_MUX_SEL_DVDDCR, 4, 1)
    FIELD(L0_TM_PG_MUX_SEL, PG_MUX_SEL_AVDDIO, 2, 2)
    FIELD(L0_TM_PG_MUX_SEL, PG_MUX_SEL_AVDDCR, 0, 2)
REG32(L0_BG_SLICER_SPARE, 0x28a0)
    FIELD(L0_BG_SLICER_SPARE, BG_SLICER_SPARE_31_8_RSVD, 24, 8)
    FIELD(L0_BG_SLICER_SPARE, BG_SLICER_SPARE_RESERVED, 6, 2)
    FIELD(L0_BG_SLICER_SPARE, SLICER1_DA_SPARE, 4, 2)
    FIELD(L0_BG_SLICER_SPARE, SLICER0_DA_SPARE, 2, 2)
    FIELD(L0_BG_SLICER_SPARE, BG_DA_SPARE, 0, 2)
REG32(L0_TM_1US_COUNT, 0x2b00)
    FIELD(L0_TM_1US_COUNT, TM_1US_COUNT_31_8_RSVD, 24, 8)
    FIELD(L0_TM_1US_COUNT, ONE_US_COUNT, 0, 8)
REG32(L0_TM_BG_SETTLING_TIME, 0x2b04)
    FIELD(L0_TM_BG_SETTLING_TIME, TM_BG_SETTLING_TIME_31_8_RSVD, 24, 8)
    FIELD(L0_TM_BG_SETTLING_TIME, TM_BG_SETTLING_TIME_3_7_RSVD, 3, 5)
    FIELD(L0_TM_BG_SETTLING_TIME, BG_SETTLING_TIME, 1, 2)
    FIELD(L0_TM_BG_SETTLING_TIME, EN_1US_COUNTER, 0, 1)
REG32(L0_SLICER0_ENABLE, 0x2b08)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE_31_8_RSVD, 24, 8)
    FIELD(L0_SLICER0_ENABLE, REFCLK01_SUP_EN, 7, 1)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE_TERM, 6, 1)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE_TC_CNTRL, 4, 2)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE_DIVIDER_4TEST, 3, 1)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE_CLK_OUT, 2, 1)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE_BGBIAS, 1, 1)
    FIELD(L0_SLICER0_ENABLE, SLICER0_ENABLE, 0, 1)
REG32(L0_SLICER1_ENABLE, 0x2b0c)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE_31_8_RSVD, 24, 8)
    FIELD(L0_SLICER1_ENABLE, SLICER01_PD_BIAS, 7, 1)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE_TERM, 6, 1)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE_TC_CNTRL, 4, 2)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE_DIVIDER_4TEST, 3, 1)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE_CLK_OUT, 2, 1)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE_BGBIAS, 1, 1)
    FIELD(L0_SLICER1_ENABLE, SLICER1_ENABLE, 0, 1)
REG32(L0_SLICER0_BYPASS, 0x2b10)
    FIELD(L0_SLICER0_BYPASS, SLICER0_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L0_SLICER0_BYPASS, SLICER0_BYPASS_7_RSVD, 7, 1)
    FIELD(L0_SLICER0_BYPASS, SLICER0_ENABLE_TERM_BYPASS, 6, 1)
    FIELD(L0_SLICER0_BYPASS, SLICER0_ENABLE_TC_CNTRL_BYPASS, 5, 1)
    FIELD(L0_SLICER0_BYPASS, SLICER0_BYPASS_4_3_RSVD, 3, 2)
    FIELD(L0_SLICER0_BYPASS, SLICER0_ENABLE_CLK_OUT_BYPASS, 2, 1)
    FIELD(L0_SLICER0_BYPASS, SLICER0_ENABLE_BGBIAS_BYPASS, 1, 1)
    FIELD(L0_SLICER0_BYPASS, SLICER0_ENABLE_BYPASS, 0, 1)
REG32(L0_SLICER1_BYPASS, 0x2b14)
    FIELD(L0_SLICER1_BYPASS, SLICER1_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L0_SLICER1_BYPASS, SLICER01_PD_BIAS_BYPASS, 7, 1)
    FIELD(L0_SLICER1_BYPASS, SLICER1_ENABLE_TERM_BYPASS, 6, 1)
    FIELD(L0_SLICER1_BYPASS, SLICER1_ENABLE_TC_CNTRL_BYPASS, 5, 1)
    FIELD(L0_SLICER1_BYPASS, SLICER1_BYPASS_4_3_RSVD, 3, 2)
    FIELD(L0_SLICER1_BYPASS, SLICER1_ENABLE_CLK_OUT_BYPASS, 2, 1)
    FIELD(L0_SLICER1_BYPASS, SLICER1_ENABLE_BGBIAS_BYPASS, 1, 1)
    FIELD(L0_SLICER1_BYPASS, SLICER1_ENABLE_BYPASS, 0, 1)
REG32(L0_BG_POWER_GOOD_STATUS, 0x2b18)
    FIELD(L0_BG_POWER_GOOD_STATUS, BG_POWER_GOOD_STATUS_31_8_RSVD, 24, 8)
    FIELD(L0_BG_POWER_GOOD_STATUS, BG_POWER_GOOD_STATUS_2_7_RSVD, 2, 6)
    FIELD(L0_BG_POWER_GOOD_STATUS, BG_UP, 1, 1)
    FIELD(L0_BG_POWER_GOOD_STATUS, BG_POWER_GOOD, 0, 1)
REG32(L0_SUPPLY_POWER_GOOD_STATUS, 0x2b1c)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, SUPPLY_POWER_GOOD_STATUS_31_8_RSVD, 24, 8)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, MUXED_PG_DVDDCR, 7, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, MUXED_PG_AVDDIO, 6, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, MUXED_PG_AVDDCR, 5, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, PG_STATIC_AVDDIO, 4, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, PG_STATIC_AVDDCR, 3, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, PG_DVDDCR, 2, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, PG_AVDDIO, 1, 1)
    FIELD(L0_SUPPLY_POWER_GOOD_STATUS, PG_AVDDCR, 0, 1)
REG32(L0_BG_ISO_CTRL, 0x2b20)
    FIELD(L0_BG_ISO_CTRL, BG_ISO_CTRL_31_8_RSVD, 24, 8)
    FIELD(L0_BG_ISO_CTRL, BG_SIO_CONTROL_RSVD, 2, 6)
    FIELD(L0_BG_ISO_CTRL, BG_ISO_CTRL_BAR, 1, 1)
    FIELD(L0_BG_ISO_CTRL, FORCE_BG_ISO_CTRL_BAR, 0, 1)
REG32(L0_UPHY_GLOBAL_CTRL, 0x3000)
    FIELD(L0_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_31_8_RSVD, 24, 8)
    FIELD(L0_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_7_RSVD, 7, 1)
    FIELD(L0_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_6_RSVD, 6, 1)
    FIELD(L0_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_5_RSVD, 5, 1)
    FIELD(L0_UPHY_GLOBAL_CTRL, PCLK_SELECT, 4, 1)
    FIELD(L0_UPHY_GLOBAL_CTRL, MPHY_G3_BIST_ENABLE, 3, 1)
    FIELD(L0_UPHY_GLOBAL_CTRL, MULTI_RATE_ENABLE, 2, 1)
    FIELD(L0_UPHY_GLOBAL_CTRL, MPHY_GEAR_SELECT, 0, 2)
REG32(L0_BIST_CTRL_1, 0x3004)
    FIELD(L0_BIST_CTRL_1, BIST_CTRL_1_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_CTRL_1, REPETITIVE_PATTERN_ENABLE, 7, 1)
    FIELD(L0_BIST_CTRL_1, PRBS_PATTERNS, 5, 2)
    FIELD(L0_BIST_CTRL_1, BIST_PATTERN_SELECT, 2, 3)
    FIELD(L0_BIST_CTRL_1, BIST_INFINITE_MODE_ENABLE, 1, 1)
    FIELD(L0_BIST_CTRL_1, BIST_ENABLE, 0, 1)
REG32(L0_BIST_CTRL_2, 0x3008)
    FIELD(L0_BIST_CTRL_2, BIST_CTRL_2_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_CTRL_2, BIST_CTRL_2_7_3_RSVD, 3, 5)
    FIELD(L0_BIST_CTRL_2, BIST_TRAINIG_SEQUENCE_SELECT, 1, 2)
    FIELD(L0_BIST_CTRL_2, BIST_ERROR_INJECTION_ENABLE, 0, 1)
REG32(L0_BIST_RUN_LEN_L, 0x300c)
    FIELD(L0_BIST_RUN_LEN_L, BIST_RUN_LEN_L_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_RUN_LEN_L, BIST_RUN_LEN_L, 0, 8)
REG32(L0_BIST_ERR_INJ_POINT_L, 0x3010)
    FIELD(L0_BIST_ERR_INJ_POINT_L, BIST_ERR_INJ_POINT_L_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_ERR_INJ_POINT_L, BIST_ERROR_INJ_POINT_L, 0, 8)
REG32(L0_BIST_RUNLEN_ERR_INJ_H, 0x3014)
    FIELD(L0_BIST_RUNLEN_ERR_INJ_H, BIST_RUNLEN_ERR_INJ_H_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_RUNLEN_ERR_INJ_H, BIST_RUN_LEN_H, 4, 4)
    FIELD(L0_BIST_RUNLEN_ERR_INJ_H, BIST_ERROR_INJ_POINT_H, 0, 4)
REG32(L0_BIST_IDLE_TIME, 0x3018)
    FIELD(L0_BIST_IDLE_TIME, BIST_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_IDLE_TIME, BIST_IDLE_TIME, 0, 8)
REG32(L0_BIST_MARKER_L, 0x301c)
    FIELD(L0_BIST_MARKER_L, BIST_MARKER_L_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_MARKER_L, BIST_MARKER_L, 0, 8)
REG32(L0_BIST_IDLE_CHAR_L, 0x3020)
    FIELD(L0_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L, 0, 8)
REG32(L0_BIST_MARKER_IDLE_H, 0x3024)
    FIELD(L0_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_H_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_7, 6, 2)
    FIELD(L0_BIST_MARKER_IDLE_H, BIST_MARKER_H, 4, 2)
    FIELD(L0_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_3, 2, 2)
    FIELD(L0_BIST_MARKER_IDLE_H, BIST_IDLE_CHAR_H, 0, 2)
REG32(L0_BIST_LOW_PULSE_TIME, 0x3028)
    FIELD(L0_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME, 0, 8)
REG32(L0_BIST_TOTAL_PULSE_TIME, 0x302c)
    FIELD(L0_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME, 0, 8)
REG32(L0_BIST_TEST_PAT_1, 0x3030)
    FIELD(L0_BIST_TEST_PAT_1, BIST_TEST_PAT_1_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_TEST_PAT_1, BIST_TEST_PAT_1_L, 0, 8)
REG32(L0_BIST_TEST_PAT_2, 0x3034)
    FIELD(L0_BIST_TEST_PAT_2, BIST_TEST_PAT_2_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_TEST_PAT_2, BIST_TEST_PAT_2_L, 0, 8)
REG32(L0_BIST_TEST_PAT_3, 0x3038)
    FIELD(L0_BIST_TEST_PAT_3, BIST_TEST_PAT_3_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_TEST_PAT_3, BIST_TEST_PAT_3_L, 0, 8)
REG32(L0_BIST_TEST_PAT_4, 0x303c)
    FIELD(L0_BIST_TEST_PAT_4, BIST_TEST_PAT_4_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_TEST_PAT_4, BIST_TEST_PAT_4_L, 0, 8)
REG32(L0_BIST_TEST_PAT_MSBS, 0x3040)
    FIELD(L0_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_MSBS_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_4_H, 6, 2)
    FIELD(L0_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_3_H, 4, 2)
    FIELD(L0_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_2_H, 2, 2)
    FIELD(L0_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_1_H, 0, 2)
REG32(L0_BIST_PKT_NUM, 0x3044)
    FIELD(L0_BIST_PKT_NUM, BIST_PKT_NUM_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_PKT_NUM, BIST_PKT_NUM, 0, 8)
REG32(L0_BIST_FRM_IDLE_TIME, 0x3048)
    FIELD(L0_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME, 0, 8)
REG32(L0_BIST_PKT_CTR_L, 0x304c)
    FIELD(L0_BIST_PKT_CTR_L, BIST_PKT_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_PKT_CTR_L, BIST_PKT_CTR_L, 0, 8)
REG32(L0_BIST_PKT_CTR_H, 0x3050)
    FIELD(L0_BIST_PKT_CTR_H, BIST_PKT_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_PKT_CTR_H, BIST_PKT_CTR_H, 0, 8)
REG32(L0_BIST_ERR_CTR_L, 0x3054)
    FIELD(L0_BIST_ERR_CTR_L, BIST_ERR_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_ERR_CTR_L, BIST_ERR_CTR_L, 0, 8)
REG32(L0_BIST_ERR_CTR_H, 0x3058)
    FIELD(L0_BIST_ERR_CTR_H, BIST_ERR_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_ERR_CTR_H, BIST_ERR_CTR_H, 0, 8)
REG32(L0_CLK_DIV_CNT, 0x305c)
    FIELD(L0_CLK_DIV_CNT, CLK_DIV_CNT_31_8_RSVD, 24, 8)
    FIELD(L0_CLK_DIV_CNT, REF_CLK_BYPASS_GT_50MHZ, 7, 1)
    FIELD(L0_CLK_DIV_CNT, SLOW_CNT_REG, 0, 7)
REG32(L0_DATA_BUS_WID, 0x3060)
    FIELD(L0_DATA_BUS_WID, DATA_BUS_WID_31_8_RSVD, 24, 8)
    FIELD(L0_DATA_BUS_WID, RATE_CHANGE_BYPASS, 7, 1)
    FIELD(L0_DATA_BUS_WID, PCLK_RATIO_BY_4, 6, 1)
    FIELD(L0_DATA_BUS_WID, PCLK_RATIO_BY_2, 5, 1)
    FIELD(L0_DATA_BUS_WID, RATE_CHANGE_DELAY_SEL, 4, 1)
    FIELD(L0_DATA_BUS_WID, RATE_CHANGE_DELAY_COUNT, 0, 4)
REG32(L0_ANADIG_BYPASS, 0x3064)
    FIELD(L0_ANADIG_BYPASS, ANADIG_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L0_ANADIG_BYPASS, ANA_DIG_COUNTER_SELECT, 7, 1)
    FIELD(L0_ANADIG_BYPASS, ANADIG_COUNT, 0, 7)
REG32(L0_BIST_FILLER_OUT, 0x3068)
    FIELD(L0_BIST_FILLER_OUT, BIST_FILLER_OUT_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_FILLER_OUT, BIST_FILLER_OUT_RESERVED, 2, 6)
    FIELD(L0_BIST_FILLER_OUT, BIST_FILLER_OUT_ENABLE, 1, 1)
    FIELD(L0_BIST_FILLER_OUT, BIST_TX_RX_LOOPBACK_ENABLE, 0, 1)
REG32(L0_BIST_FORCE_MK_RST, 0x306c)
    FIELD(L0_BIST_FORCE_MK_RST, BIST_FORCE_MK_RST_31_8_RSVD, 24, 8)
    FIELD(L0_BIST_FORCE_MK_RST, BIST_FORCE_RESET, 1, 1)
    FIELD(L0_BIST_FORCE_MK_RST, BIST_ENABLE_MK_FROM_REG, 0, 1)
REG32(L0_SPARE_IN, 0x3070)
    FIELD(L0_SPARE_IN, SPARE_IN_31_8_RSVD, 24, 8)
    FIELD(L0_SPARE_IN, SPARE_IN, 0, 8)
REG32(L0_SPARE_OUT, 0x3074)
    FIELD(L0_SPARE_OUT, SPARE_OUT_31_8_RSVD, 24, 8)
    FIELD(L0_SPARE_OUT, SPARE_OUT, 0, 8)
REG32(L1_TX_ANA_TM_0, 0x4000)
    FIELD(L1_TX_ANA_TM_0, TX_ANA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_0, ANA_BYP0_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_0, PIPE_TX_DN_RXDET, 5, 1)
    FIELD(L1_TX_ANA_TM_0, FORCE_PIPE_TX_DN_RXDET, 4, 1)
    FIELD(L1_TX_ANA_TM_0, PIPE_TX_DP_RXDET, 3, 1)
    FIELD(L1_TX_ANA_TM_0, FORCE_PIPE_TX_DP_RXDET, 2, 1)
    FIELD(L1_TX_ANA_TM_0, ANA_BYP0_1_0_RSVD, 0, 2)
REG32(L1_TX_ANA_TM_3, 0x400c)
    FIELD(L1_TX_ANA_TM_3, TX_ANA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_3, TX_HS_SER_RSTB, 7, 1)
    FIELD(L1_TX_ANA_TM_3, FORCE_TX_HS_SER_RSTB, 6, 1)
    FIELD(L1_TX_ANA_TM_3, TX_HS_BURST, 5, 1)
    FIELD(L1_TX_ANA_TM_3, FORCE_TX_HS_BURST, 4, 1)
    FIELD(L1_TX_ANA_TM_3, TX_SERIALIZER_ENABLE, 3, 1)
    FIELD(L1_TX_ANA_TM_3, FORCE_TX_SERIALIZER_ENABLE, 2, 1)
    FIELD(L1_TX_ANA_TM_3, TX_ENABLE_SUPPLY_SERIALIZER, 1, 1)
    FIELD(L1_TX_ANA_TM_3, FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 0, 1)
REG32(L1_TX_ANA_TM_4, 0x4010)
    FIELD(L1_TX_ANA_TM_4, TX_ANA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_4, ANA_BYP4_7_RSVD, 7, 1)
    FIELD(L1_TX_ANA_TM_4, TX_LSEG_DN_RESCAL_CODE, 1, 6)
    FIELD(L1_TX_ANA_TM_4, FORCE_TX_LSEG_DN_RESCAL_CODE, 0, 1)
REG32(L1_TX_ANA_TM_5, 0x4014)
    FIELD(L1_TX_ANA_TM_5, TX_ANA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_5, ANA_BYP5_7_RSVD, 7, 1)
    FIELD(L1_TX_ANA_TM_5, TX_USEG_DP_RESCAL_CODE, 1, 6)
    FIELD(L1_TX_ANA_TM_5, FORCE_TX_USEG_DP_RESCAL_CODE, 0, 1)
REG32(L1_TX_ANA_TM_9, 0x4024)
    FIELD(L1_TX_ANA_TM_9, TX_ANA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_9, MPHY_TX_HS_SLEWRATE, 0, 8)
REG32(L1_TX_ANA_TM_10, 0x4028)
    FIELD(L1_TX_ANA_TM_10, TX_ANA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_10, MPHY_HS_POWERUP_TIME, 4, 4)
    FIELD(L1_TX_ANA_TM_10, MPHY_TX_HS_EQUALIZER_SETTING, 1, 3)
    FIELD(L1_TX_ANA_TM_10, FORCE_MPHY_TX_HS_EQUALIZER_SETTING, 0, 1)
REG32(L1_TX_ANA_TM_13, 0x4034)
    FIELD(L1_TX_ANA_TM_13, TX_ANA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_13, ANA_BYP13_7_4_RSVD, 4, 4)
    FIELD(L1_TX_ANA_TM_13, TX_SWAP_POLARITY, 3, 1)
    FIELD(L1_TX_ANA_TM_13, FORCE_TX_SWAP_POLARITY, 2, 1)
    FIELD(L1_TX_ANA_TM_13, MPHY_TX_TRISTATE, 1, 1)
    FIELD(L1_TX_ANA_TM_13, FORCE_MPHY_TX_TRISTATE, 0, 1)
REG32(L1_TX_ANA_TM_14, 0x4038)
    FIELD(L1_TX_ANA_TM_14, TX_ANA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_14, ANA_BYP14_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_14, PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L1_TX_ANA_TM_14, FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L1_TX_ANA_TM_14, ANA_BYP14_3_0_RSVD, 0, 4)
REG32(L1_TX_ANA_TM_15, 0x403c)
    FIELD(L1_TX_ANA_TM_15, TX_ANA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_15, PIPE_TX_SWING, 7, 1)
    FIELD(L1_TX_ANA_TM_15, FORCE_PIPE_TX_SWING, 6, 1)
    FIELD(L1_TX_ANA_TM_15, PIPE_TX_RXDET_DISCHARGE, 5, 1)
    FIELD(L1_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_DISCHARGE, 4, 1)
    FIELD(L1_TX_ANA_TM_15, PIPE_TX_RXDET_CHARGE, 3, 1)
    FIELD(L1_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_CHARGE, 2, 1)
    FIELD(L1_TX_ANA_TM_15, PIPE_TX_ENABLE_RXDET, 1, 1)
    FIELD(L1_TX_ANA_TM_15, FORCE_PIPE_TX_ENABLE_RXDET, 0, 1)
REG32(L1_TX_ANA_TM_16, 0x4040)
    FIELD(L1_TX_ANA_TM_16, TX_ANA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_16, ANA_BYP16_7_4_RSVD, 4, 4)
    FIELD(L1_TX_ANA_TM_16, PIPE_TX_MARGIN, 1, 3)
    FIELD(L1_TX_ANA_TM_16, FORCE_PIPE_TX_MARGIN, 0, 1)
REG32(L1_TX_ANA_TM_18, 0x4048)
    FIELD(L1_TX_ANA_TM_18, TX_ANA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_18, PIPE_TX_DEEMPH_7_0, 0, 8)
REG32(L1_TX_ANA_TM_19, 0x404c)
    FIELD(L1_TX_ANA_TM_19, TX_ANA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_19, PIPE_TX_DEEMPH_15_8, 0, 8)
REG32(L1_TX_ANA_TM_20, 0x4050)
    FIELD(L1_TX_ANA_TM_20, TX_ANA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_20, ANA_BYP20_7_5_RSVD, 5, 3)
    FIELD(L1_TX_ANA_TM_20, TX_SERIALIZER_RST_REL, 4, 1)
    FIELD(L1_TX_ANA_TM_20, FORCE_TX_SERIALIZER_RST_REL, 3, 1)
    FIELD(L1_TX_ANA_TM_20, FORCE_MPHY_TX_HS_SLEWRATE, 2, 1)
    FIELD(L1_TX_ANA_TM_20, PIPE_TX_DEEMPH_17_16, 0, 2)
REG32(L1_TX_ANA_TM_21, 0x4054)
    FIELD(L1_TX_ANA_TM_21, TX_ANA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_21, ANA_BYP21_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_21, PIPE_TX_COEF_CALC_CLK, 5, 1)
    FIELD(L1_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_CLK, 4, 1)
    FIELD(L1_TX_ANA_TM_21, PIPE_TX_COEF_CALC_FSM_RESET_B, 3, 1)
    FIELD(L1_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_FSM_RESET_B, 2, 1)
    FIELD(L1_TX_ANA_TM_21, PIPE_TX_DEEMPH_CTRL_SEL, 1, 1)
    FIELD(L1_TX_ANA_TM_21, FORCE_PIPE_TX_DEEMPH_CTRL_SEL, 0, 1)
REG32(L1_TX_DIG_TM_61, 0x40f4)
    FIELD(L1_TX_DIG_TM_61, TX_DIG_TM_61_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_61, MPHY_PLL_GEAR, 6, 2)
    FIELD(L1_TX_DIG_TM_61, DIG_BYP1_5_4_RSVD, 4, 2)
    FIELD(L1_TX_DIG_TM_61, BYPASS_ENC, 3, 1)
    FIELD(L1_TX_DIG_TM_61, DIG_BYP1_2_RSVD, 2, 1)
    FIELD(L1_TX_DIG_TM_61, BYPASS_SCRAM, 1, 1)
    FIELD(L1_TX_DIG_TM_61, FORCE_BYPASS_SCRAM, 0, 1)
REG32(L1_TX_DIG_TM_62, 0x40f8)
    FIELD(L1_TX_DIG_TM_62, TX_DIG_TM_62_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_62, G0_BIT_PER_CNT, 0, 8)
REG32(L1_TX_DIG_TM_65, 0x4104)
    FIELD(L1_TX_DIG_TM_65, TX_DIG_TM_65_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_65, FORCE_TX_RXDET_PROBE_THRESHOLD, 7, 1)
    FIELD(L1_TX_DIG_TM_65, FORCE_TX_RXDET_END_CH_THRESHOLD, 6, 1)
    FIELD(L1_TX_DIG_TM_65, FORCE_TX_RXDET_START_CH_THRESHOLD, 5, 1)
    FIELD(L1_TX_DIG_TM_65, FORCE_TX_RXDET_END_DCH_THRESHOLD, 4, 1)
    FIELD(L1_TX_DIG_TM_65, FORCE_TX_RXDET_START_DCH_THRESHOLD, 3, 1)
    FIELD(L1_TX_DIG_TM_65, TX_EN_FULL_CALIB, 2, 1)
    FIELD(L1_TX_DIG_TM_65, FORCE_TX_EN_FULL_CALIB, 1, 1)
    FIELD(L1_TX_DIG_TM_65, DIG_BYP5_0_RSVD, 0, 1)
REG32(L1_TX_DIG_TM_67, 0x410c)
    FIELD(L1_TX_DIG_TM_67, TX_DIG_TM_67_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_67, TX_MPHY_SER_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_68, 0x4110)
    FIELD(L1_TX_DIG_TM_68, TX_DIG_TM_68_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_68, TX_SER_SUP_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_69, 0x4114)
    FIELD(L1_TX_DIG_TM_69, TX_DIG_TM_69_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_69, TX_MPHY_SUP_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_76, 0x4130)
    FIELD(L1_TX_DIG_TM_76, TX_DIG_TM_76_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_76, TX_RXDET_START_DCH_THRESHOLD_7_0, 0, 8)
REG32(L1_TX_DIG_TM_77, 0x4134)
    FIELD(L1_TX_DIG_TM_77, TX_DIG_TM_77_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_77, TX_RXDET_END_DCH_THRESHOLD_11_8, 4, 4)
    FIELD(L1_TX_DIG_TM_77, TX_RXDET_START_DCH_THRESHOLD_11_8, 0, 4)
REG32(L1_TX_DIG_TM_78, 0x4138)
    FIELD(L1_TX_DIG_TM_78, TX_DIG_TM_78_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_78, TX_RXDET_END_DCH_THRESHOLD_7_0, 0, 8)
REG32(L1_TX_DIG_TM_79, 0x413c)
    FIELD(L1_TX_DIG_TM_79, TX_DIG_TM_79_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_79, TX_RXDET_START_CH_THRESHOLD_7_0, 0, 8)
REG32(L1_TX_DIG_TM_80, 0x4140)
    FIELD(L1_TX_DIG_TM_80, TX_DIG_TM_80_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_80, TX_RXDET_END_CH_THRESHOLD_11_8, 4, 4)
    FIELD(L1_TX_DIG_TM_80, TX_RXDET_START_CH_THRESHOLD_11_8, 0, 4)
REG32(L1_TX_DIG_TM_81, 0x4144)
    FIELD(L1_TX_DIG_TM_81, TX_DIG_TM_81_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_81, TX_RXDET_END_CH_THRESHOLD_7_0, 0, 8)
REG32(L1_TX_DIG_TM_82, 0x4148)
    FIELD(L1_TX_DIG_TM_82, TX_DIG_TM_82_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_82, TX_RXDET_PROBE_THRESHOLD_7_0, 0, 8)
REG32(L1_TX_DIG_TM_83, 0x414c)
    FIELD(L1_TX_DIG_TM_83, TX_DIG_TM_83_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_83, DIG_BYP23_7_4_RSVD, 4, 4)
    FIELD(L1_TX_DIG_TM_83, TX_RXDET_PROBE_THRESHOLD_11_8, 0, 4)
REG32(L1_TX_DIG_TM_84, 0x4150)
    FIELD(L1_TX_DIG_TM_84, TX_DIG_TM_84_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_84, TX_DIF_P, 7, 1)
    FIELD(L1_TX_DIG_TM_84, TX_DITHER_1P, 6, 1)
    FIELD(L1_TX_DIG_TM_84, TX_DITHER_1N, 5, 1)
    FIELD(L1_TX_DIG_TM_84, TX_DITHER_EN, 4, 1)
    FIELD(L1_TX_DIG_TM_84, DIG_BYP24_3_RSVD, 3, 1)
    FIELD(L1_TX_DIG_TM_84, TX_PHYDIRDY_SOC_MODE, 2, 1)
    FIELD(L1_TX_DIG_TM_84, DIG_BYP24_1_RSVD, 1, 1)
    FIELD(L1_TX_DIG_TM_84, TX_READ_SHADOW, 0, 1)
REG32(L1_TX_ANA_TM_85, 0x4154)
    FIELD(L1_TX_ANA_TM_85, TX_ANA_TM_85_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_85, DIG_BYP25_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_85, TX_HIBERN8_CTRL, 5, 1)
    FIELD(L1_TX_ANA_TM_85, TX_ALLOW_INLNCFG_FROM_TOP, 4, 1)
    FIELD(L1_TX_ANA_TM_85, DIG_BYP25_3_RSVD, 3, 1)
    FIELD(L1_TX_ANA_TM_85, TX_SEND_MSB_FIRST, 2, 1)
    FIELD(L1_TX_ANA_TM_85, DIG_BYP25_1_RSVD, 1, 1)
    FIELD(L1_TX_ANA_TM_85, TX_DIF_N, 0, 1)
REG32(L1_TX_ANA_TM_87, 0x415c)
    FIELD(L1_TX_ANA_TM_87, TX_ANA_TM_87_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_87, DIG_BYP27_7_4_RSVD, 4, 4)
    FIELD(L1_TX_ANA_TM_87, TX_SM_STATUS, 0, 4)
REG32(L1_TX_ANA_TM_88, 0x4160)
    FIELD(L1_TX_ANA_TM_88, TX_ANA_TM_88_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_88, TX_COMP_PAT_HIGH_TIME_REGS, 0, 8)
REG32(L1_TX_ANA_TM_89, 0x4164)
    FIELD(L1_TX_ANA_TM_89, TX_ANA_TM_89_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_89, DIG_BYP29_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_89, TX_DATAPATH_CTRL_1_REGS, 5, 1)
    FIELD(L1_TX_ANA_TM_89, DIG_BYP29_4_3_RSVD, 3, 2)
    FIELD(L1_TX_ANA_TM_89, INITIAL_DISPARITY, 2, 1)
    FIELD(L1_TX_ANA_TM_89, SCRAMBLER_ENABLE, 1, 1)
    FIELD(L1_TX_ANA_TM_89, DIG_BYP29_0_RSVD, 0, 1)
REG32(L1_TX_ANA_TM_90, 0x4168)
    FIELD(L1_TX_ANA_TM_90, TX_ANA_TM_90_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_90, DIG_BYP30_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_90, TX_BYPASS_BCNT_LPBACK_REGS, 5, 1)
    FIELD(L1_TX_ANA_TM_90, DIG_BYP30_4_0_RSVD, 0, 5)
REG32(L1_TX_DIG_TM_91, 0x416c)
    FIELD(L1_TX_DIG_TM_91, TX_DIG_TM_91_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_91, TX_CFGCLK_FREQ, 0, 8)
REG32(L1_TX_DIG_TM_92, 0x4170)
    FIELD(L1_TX_DIG_TM_92, TX_DIG_TM_92_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_92, TX_PHYDIRDY_PULL_UP_LATENCY, 0, 8)
REG32(L1_TX_ANA_TM_95, 0x417c)
    FIELD(L1_TX_ANA_TM_95, TX_ANA_TM_95_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_95, ANA_BYP63_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_95, TX_TM_EN_PROG_SYNC_PATTERN, 5, 1)
    FIELD(L1_TX_ANA_TM_95, TX_EXTRA_HS_BURST_IN_LCC, 2, 3)
    FIELD(L1_TX_ANA_TM_95, ANA_BYP22_1_0_RSVD, 0, 2)
REG32(L1_TX_ANA_TM_96, 0x4180)
    FIELD(L1_TX_ANA_TM_96, TX_ANA_TM_96_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_96, TX_TM_PROG_SYNC_PATTERN1, 0, 8)
REG32(L1_TX_ANA_TM_97, 0x4184)
    FIELD(L1_TX_ANA_TM_97, TX_ANA_TM_97_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_97, TX_TM_PROG_SYNC_PATTERN2, 0, 8)
REG32(L1_TX_DIG_TM_98, 0x4188)
    FIELD(L1_TX_DIG_TM_98, TX_DIG_TM_98_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_98, DIG_BYP33_7_6_RSVD, 6, 2)
    FIELD(L1_TX_DIG_TM_98, FORCE_RD_VALUE, 5, 1)
    FIELD(L1_TX_DIG_TM_98, FORCE_RD, 4, 1)
    FIELD(L1_TX_DIG_TM_98, TX_SER_ISO_CTRL_BAR, 3, 1)
    FIELD(L1_TX_DIG_TM_98, FORCE_TX_SER_ISO_CTRL_BAR, 2, 1)
    FIELD(L1_TX_DIG_TM_98, TX_ISO_CTRL_BAR, 1, 1)
    FIELD(L1_TX_DIG_TM_98, FORCE_TX_ISO_CTRL_BAR, 0, 1)
REG32(L1_TX_DIG_TM_99, 0x418c)
    FIELD(L1_TX_DIG_TM_99, TX_DIG_TM_99_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_99, TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_100, 0x4190)
    FIELD(L1_TX_DIG_TM_100, TX_DIG_TM_100_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_100, TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_101, 0x4194)
    FIELD(L1_TX_DIG_TM_101, TX_DIG_TM_101_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_101, TX_SERIALISER_ENABLE_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_102, 0x4198)
    FIELD(L1_TX_DIG_TM_102, TX_DIG_TM_102_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_102, FORCE_TX_ANA_LL_EN, 7, 1)
    FIELD(L1_TX_DIG_TM_102, TX_ANA_LL_EN, 6, 1)
    FIELD(L1_TX_DIG_TM_102, FORCE_DELAY_CNT_THRESHOLD, 5, 1)
    FIELD(L1_TX_DIG_TM_102, FORCE_TX_MPHY_TRST_THRESHOLD, 4, 1)
    FIELD(L1_TX_DIG_TM_102, FORCE_TX_LDO_THRESHOLD, 3, 1)
    FIELD(L1_TX_DIG_TM_102, FORCE_TX_SERIALISER_ENABLE_THRESHOLD, 2, 1)
    FIELD(L1_TX_DIG_TM_102, FORCE_TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 1, 1)
    FIELD(L1_TX_DIG_TM_102, FORCE_TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 1)
REG32(L1_TX_DIG_TM_103, 0x419c)
    FIELD(L1_TX_DIG_TM_103, TX_DIG_TM_103_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_103, FORCE_BG_EN, 7, 1)
    FIELD(L1_TX_DIG_TM_103, FORCE_CALIB_EN, 6, 1)
    FIELD(L1_TX_DIG_TM_103, FORCE_PLL_EN, 5, 1)
    FIELD(L1_TX_DIG_TM_103, FORCE_PSO, 4, 1)
    FIELD(L1_TX_DIG_TM_103, BG_EN, 3, 1)
    FIELD(L1_TX_DIG_TM_103, CALIB_EN, 2, 1)
    FIELD(L1_TX_DIG_TM_103, PLL_EN, 1, 1)
    FIELD(L1_TX_DIG_TM_103, PSO, 0, 1)
REG32(L1_TX_DIG_TM_104, 0x41a0)
    FIELD(L1_TX_DIG_TM_104, TX_DIG_TM_104_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_104, TX_LDO_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_105, 0x41a4)
    FIELD(L1_TX_DIG_TM_105, TX_DIG_TM_105_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_105, TX_MPHY_TRST_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_106, 0x41a8)
    FIELD(L1_TX_DIG_TM_106, TX_DIG_TM_106_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_106, DELAY_CNT_THRESHOLD, 0, 8)
REG32(L1_TX_DIG_TM_107, 0x41ac)
    FIELD(L1_TX_DIG_TM_107, TX_DIG_TM_107_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_107, DIG_BYP42_7_RSVD, 7, 1)
    FIELD(L1_TX_DIG_TM_107, FORCE_P3TOP0_PHYSTATUS_PULSE, 6, 1)
    FIELD(L1_TX_DIG_TM_107, ENABLE_HS_CLK_DIVISION, 5, 1)
    FIELD(L1_TX_DIG_TM_107, TESTDIGOUT_SEL, 1, 4)
    FIELD(L1_TX_DIG_TM_107, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L1_TX_DIG_TM_108, 0x41b0)
    FIELD(L1_TX_DIG_TM_108, TX_DIG_TM_108_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_108, ANA_BYP43_7_RSVD, 7, 1)
    FIELD(L1_TX_DIG_TM_108, TX_EXT_DATA_DELAY, 3, 4)
    FIELD(L1_TX_DIG_TM_108, FORCE_TX_EXT_DATA_DELAY, 2, 1)
    FIELD(L1_TX_DIG_TM_108, FORCE_TX_DATA_DELAY, 1, 1)
    FIELD(L1_TX_DIG_TM_108, FORCE_UPHY_TXPMA_OPMODE, 0, 1)
REG32(L1_TX_DIG_TM_109, 0x41b4)
    FIELD(L1_TX_DIG_TM_109, TX_DIG_TM_109_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_109, UPHY_TXPMA_OPMODE, 0, 8)
REG32(L1_TX_DIG_TM_110, 0x41b8)
    FIELD(L1_TX_DIG_TM_110, TX_DIG_TM_110_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_110, TX_DATA_DELAY, 0, 8)
REG32(L1_TX_DIG_TM_111, 0x41bc)
    FIELD(L1_TX_DIG_TM_111, TX_DIG_TM_111_31_8_RSVD, 24, 8)
    FIELD(L1_TX_DIG_TM_111, TX_DA_SPARE, 0, 8)
REG32(L1_TX_ANA_TM_112, 0x41c0)
    FIELD(L1_TX_ANA_TM_112, TX_ANA_TM_112_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_112, ANA_BYP25_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_112, PIPE_TX_ENABLE_LFPS, 4, 2)
    FIELD(L1_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L1_TX_ANA_TM_112, PIPE_TX_ENABLE_IDLE_MODE, 1, 2)
    FIELD(L1_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L1_TX_ANA_TM_113, 0x41c4)
    FIELD(L1_TX_ANA_TM_113, TX_ANA_TM_113_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_113, MPHY_TX_DRIVERLDO_PROG, 0, 8)
REG32(L1_TX_ANA_TM_114, 0x41c8)
    FIELD(L1_TX_ANA_TM_114, TX_ANA_TM_114_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_114, ANA_BYP27_7_5_RSVD, 5, 3)
    FIELD(L1_TX_ANA_TM_114, FORCE_MPHY_TX_DRIVERLDO_PROG, 4, 1)
    FIELD(L1_TX_ANA_TM_114, MPHY_TX_DRIVERLDO_PROG, 0, 4)
REG32(L1_TX_ANA_TM_115, 0x41cc)
    FIELD(L1_TX_ANA_TM_115, TX_ANA_TM_115_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_115, ANA_BYP28_7_RSVD, 7, 1)
    FIELD(L1_TX_ANA_TM_115, PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 6, 1)
    FIELD(L1_TX_ANA_TM_115, FORCE_PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 5, 1)
    FIELD(L1_TX_ANA_TM_115, TX_PMADIG_DIGITAL_RESET_N, 4, 1)
    FIELD(L1_TX_ANA_TM_115, FORCE_TX_PMADIG_DIGITAL_RESET_N, 3, 1)
    FIELD(L1_TX_ANA_TM_115, TX_ANA_IF_RATE, 1, 2)
    FIELD(L1_TX_ANA_TM_115, FORCE_TX_ANA_IF_RATE, 0, 1)
REG32(L1_TX_ANA_TM_116, 0x41d0)
    FIELD(L1_TX_ANA_TM_116, TX_ANA_TM_116_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_116, ANA_BYP29_7_RSVD, 7, 1)
    FIELD(L1_TX_ANA_TM_116, PIPE_TX_LOCALPRESETINDEX, 3, 4)
    FIELD(L1_TX_ANA_TM_116, FORCE_PIPE_TX_LOCALPRESETINDEX, 2, 1)
    FIELD(L1_TX_ANA_TM_116, MPHY_TX_EN_LANE_LS_CLK, 1, 1)
    FIELD(L1_TX_ANA_TM_116, FORCE_MPHY_TX_EN_LANE_LS_CLK, 0, 1)
REG32(L1_TX_ANA_TM_117, 0x41d4)
    FIELD(L1_TX_ANA_TM_117, TX_ANA_TM_117_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_117, MULTILANE_BYP1_7_6_RSVD, 6, 2)
    FIELD(L1_TX_ANA_TM_117, TX_PCIE_4X_CFG_EN, 5, 1)
    FIELD(L1_TX_ANA_TM_117, FORCE_TX_PCIE_4X_CFG_EN, 4, 1)
    FIELD(L1_TX_ANA_TM_117, TX_PCIE_2X_CFG_EN, 3, 1)
    FIELD(L1_TX_ANA_TM_117, FORCE_TX_PCIE_2X_CFG_EN, 2, 1)
    FIELD(L1_TX_ANA_TM_117, TX_DP_MULTILANE_CFG_EN, 1, 1)
    FIELD(L1_TX_ANA_TM_117, FORCE_TX_DP_MULTILANE_CFG_EN, 0, 1)
REG32(L1_TX_ANA_TM_118, 0x41d8)
    FIELD(L1_TX_ANA_TM_118, TX_ANA_TM_118_31_8_RSVD, 24, 8)
    FIELD(L1_TX_ANA_TM_118, ANA_BYP30_7_4_RSVD, 4, 4)
    FIELD(L1_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_12, 3, 1)
    FIELD(L1_TX_ANA_TM_118, FORCE_TX_DEEMPH_11_6, 2, 1)
    FIELD(L1_TX_ANA_TM_118, FORCE_TX_DEEMPH_5_0, 1, 1)
    FIELD(L1_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_0, 0, 1)
REG32(L1_TXPMA_TM_0, 0x4800)
    FIELD(L1_TXPMA_TM_0, TXPMA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_0, TM_TX_ENABLE_SUPPLY_MPHY, 7, 1)
    FIELD(L1_TXPMA_TM_0, TM_FORCE_TX_ENABLE_SUPPLY_MPHY, 6, 1)
    FIELD(L1_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 5, 1)
    FIELD(L1_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 4, 1)
    FIELD(L1_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SA_MODE, 3, 1)
    FIELD(L1_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SA_MODE, 2, 1)
    FIELD(L1_TXPMA_TM_0, TM_MPHY_TX_ENABLE_HS_NT, 1, 1)
    FIELD(L1_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_HS_NT, 0, 1)
REG32(L1_TXPMA_TM_1, 0x4804)
    FIELD(L1_TXPMA_TM_1, TXPMA_TM_1_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_1, ANA_MPHY_BYP1_7_4_RSVD, 4, 4)
    FIELD(L1_TXPMA_TM_1, TM_MPHY_TX_HS_DITHER_VAL, 1, 3)
    FIELD(L1_TXPMA_TM_1, TM_FORCE_MPHY_TX_HS_DITHER_VAL, 0, 1)
REG32(L1_TXPMA_TM_2, 0x4808)
    FIELD(L1_TXPMA_TM_2, TXPMA_TM_2_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_2, TM_MPHY_TX_DRIVERLDO_PROG_6_0, 1, 7)
    FIELD(L1_TXPMA_TM_2, TM_FORCE_MPHY_TX_DRIVERLDO_PROG, 0, 1)
REG32(L1_TXPMA_TM_3, 0x480c)
    FIELD(L1_TXPMA_TM_3, TXPMA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_3, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMA_TM_3, TM_MPHY_TX_DRIVERLDO_PROG_11_7, 0, 5)
REG32(L1_TXPMA_TM_4, 0x4810)
    FIELD(L1_TXPMA_TM_4, TXPMA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_4, TM_PIPE_TX_TX_DATA_WIDTH, 5, 3)
    FIELD(L1_TXPMA_TM_4, TM_FORCE_PIPE_TX_TX_DATA_WIDTH, 4, 1)
    FIELD(L1_TXPMA_TM_4, TM_PIPE_TX_POWERDOWN_VCM_HOLD, 3, 1)
    FIELD(L1_TXPMA_TM_4, TM_FORCE_PIPE_TX_POWERDOWN_VCM_HOLD, 2, 1)
    FIELD(L1_TXPMA_TM_4, TM_PIPE_TX_ANABOOST_POWERDOWN, 1, 1)
    FIELD(L1_TXPMA_TM_4, ANA_PIPE_BYP0_0_RSVD, 0, 1)
REG32(L1_TXPMA_TM_5, 0x4814)
    FIELD(L1_TXPMA_TM_5, TXPMA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_5, ANA_BSCAN_BYP0_7_4_RSVD, 4, 4)
    FIELD(L1_TXPMA_TM_5, TM_TX_BSCAN_SEL, 3, 1)
    FIELD(L1_TXPMA_TM_5, TM_FORCE_TX_BSCAN_SEL, 2, 1)
    FIELD(L1_TXPMA_TM_5, TM_TX_BSCAN_DATA, 1, 1)
    FIELD(L1_TXPMA_TM_5, TM_FORCE_TX_BSCAN_DATA, 0, 1)
REG32(L1_TXPMA_TM_6, 0x4818)
    FIELD(L1_TXPMA_TM_6, TXPMA_TM_6_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_6, TM_TX_ENABLE_ISI_LPBK, 7, 1)
    FIELD(L1_TXPMA_TM_6, TM_FORCE_TX_ENABLE_ISI_LPBK, 6, 1)
    FIELD(L1_TXPMA_TM_6, TM_TX_ENABLE_SER_LPBK, 5, 1)
    FIELD(L1_TXPMA_TM_6, TM_FORCE_TX_ENABLE_SER_LPBK, 4, 1)
    FIELD(L1_TXPMA_TM_6, TM_TX_ENABLE_RX_LIN_LPBK, 3, 1)
    FIELD(L1_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RX_LIN_LPBK, 2, 1)
    FIELD(L1_TXPMA_TM_6, TM_TX_ENABLE_RCRVD_DATA_LPBK, 1, 1)
    FIELD(L1_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RCRVD_DATA_LPBK, 0, 1)
REG32(L1_TXPMA_TM_7, 0x481c)
    FIELD(L1_TXPMA_TM_7, TXPMA_TM_7_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_UPHY, 7, 1)
    FIELD(L1_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_UPHY, 6, 1)
    FIELD(L1_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_SERIALIZER, 5, 1)
    FIELD(L1_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L1_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_PIPE, 3, 1)
    FIELD(L1_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_PIPE, 2, 1)
    FIELD(L1_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_HSCLK, 1, 1)
    FIELD(L1_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_HSCLK, 0, 1)
REG32(L1_TXPMA_TM_8, 0x4820)
    FIELD(L1_TXPMA_TM_8, TXPMA_TM_8_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_8, ANA_LS_LFPS_BYP0_7_2_RSVD, 2, 6)
    FIELD(L1_TXPMA_TM_8, TM_TX_LS_LFPS_DATA, 1, 1)
    FIELD(L1_TXPMA_TM_8, TM_FORCE_TX_LS_LFPS_DATA, 0, 1)
REG32(L1_TXPMA_TM_9, 0x4824)
    FIELD(L1_TXPMA_TM_9, TXPMA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_9, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L1_TXPMA_TM_9, TM_TX_SERIALIZER_MODE, 6, 1)
    FIELD(L1_TXPMA_TM_9, TM_FORCE_TX_SERIALIZER_MODE, 5, 1)
    FIELD(L1_TXPMA_TM_9, TM_TX_ENABLE_HSCLK_DIVISION, 3, 2)
    FIELD(L1_TXPMA_TM_9, TM_FORCE_TX_ENABLE_HSCLK_DIVISION, 2, 1)
    FIELD(L1_TXPMA_TM_9, TM_TX_DRIVER_POLARITY, 1, 1)
    FIELD(L1_TXPMA_TM_9, TM_FORCE_TX_DRIVER_POLARITY, 0, 1)
REG32(L1_TXPMA_TM_10, 0x4828)
    FIELD(L1_TXPMA_TM_10, TXPMA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_10, ANA_MISC1_7_6_RSVD, 6, 2)
    FIELD(L1_TXPMA_TM_10, TM_TX_ENABLE_LOWLEAKAGE, 5, 1)
    FIELD(L1_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LOWLEAKAGE, 4, 1)
    FIELD(L1_TXPMA_TM_10, TM_TX_ENABLE_REF, 3, 1)
    FIELD(L1_TXPMA_TM_10, TM_FORCE_TX_ENABLE_REF, 2, 1)
    FIELD(L1_TXPMA_TM_10, TM_TX_ENABLE_LDO, 1, 1)
    FIELD(L1_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LDO, 0, 1)
REG32(L1_TXPMA_TM_11, 0x482c)
    FIELD(L1_TXPMA_TM_11, TXPMA_TM_11_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_11, ANA_VCM_BYP0_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMA_TM_11, TM_TX_VCMHOLD_PROG, 1, 4)
    FIELD(L1_TXPMA_TM_11, TM_TX_VCMHOLD_OBSRV, 0, 1)
REG32(L1_TXPMA_TM_12, 0x4830)
    FIELD(L1_TXPMA_TM_12, TXPMA_TM_12_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_12, TM_TX_SER_POWERISLAND_OBSRV, 5, 3)
    FIELD(L1_TXPMA_TM_12, TM_TX_CLK_POWERISLAND_OBSRV, 1, 4)
    FIELD(L1_TXPMA_TM_12, ANA_PWR_ISLAND_BYP0_0_RSVD, 0, 1)
REG32(L1_TXPMA_TM_13, 0x4834)
    FIELD(L1_TXPMA_TM_13, TXPMA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_13, TM_TX_POWERISLAND_OBSRV, 0, 8)
REG32(L1_TXPMA_TM_14, 0x4838)
    FIELD(L1_TXPMA_TM_14, TXPMA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_14, ANA_MISC2_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMA_TM_14, TM_TX_POWERISLAND_OBSRV, 3, 2)
    FIELD(L1_TXPMA_TM_14, PIPE_TM_TX_ANABOOST_POWER_OBSRV, 2, 1)
    FIELD(L1_TXPMA_TM_14, MPHY_TM_TX_ENABLE_DRIVERLDO_OBSRV, 1, 1)
    FIELD(L1_TXPMA_TM_14, MPHY_TM_TX_DRIVERLDO_REDC_SINKIQ, 0, 1)
REG32(L1_TXPMA_TM_15, 0x483c)
    FIELD(L1_TXPMA_TM_15, TXPMA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_15, PIPE_TM_TX_ANABOOST_PROG_7_0, 0, 8)
REG32(L1_TXPMA_TM_16, 0x4840)
    FIELD(L1_TXPMA_TM_16, TXPMA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_16, PIPE_TM_TX_ANABOOST_PROG_15_8, 0, 8)
REG32(L1_TXPMA_TM_17, 0x4844)
    FIELD(L1_TXPMA_TM_17, TXPMA_TM_17_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_17, TM_TX_RSVD2, 0, 8)
REG32(L1_TXPMA_TM_18, 0x4848)
    FIELD(L1_TXPMA_TM_18, TXPMA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_18, TM_TX_ENABLE_VDDREF_CORE, 7, 1)
    FIELD(L1_TXPMA_TM_18, TM_FORCE_TX_ENABLE_VDDREF_CORE, 6, 1)
    FIELD(L1_TXPMA_TM_18, TM_TX_ENABLE_RBYRFB_CORE, 5, 1)
    FIELD(L1_TXPMA_TM_18, TM_FORCE_TX_ENABLE_RBYRFB_CORE, 4, 1)
    FIELD(L1_TXPMA_TM_18, TM_TX_ENABLE_BGREF_CORE, 3, 1)
    FIELD(L1_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGREF_CORE, 2, 1)
    FIELD(L1_TXPMA_TM_18, TM_TX_ENABLE_BGFB_CORE, 1, 1)
    FIELD(L1_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGFB_CORE, 0, 1)
REG32(L1_TXPMA_TM_19, 0x484c)
    FIELD(L1_TXPMA_TM_19, TXPMA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_19, ANA_SATA_BYP0_RSVD, 6, 2)
    FIELD(L1_TXPMA_TM_19, TM_ZDIF_TX_SATA_OFFSET, 0, 6)
REG32(L1_TXPMA_TM_20, 0x4850)
    FIELD(L1_TXPMA_TM_20, TXPMA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_20, TM_TX_ELEC_IDLE_DELAY_ENTRY, 0, 8)
REG32(L1_TXPMA_TM_21, 0x4854)
    FIELD(L1_TXPMA_TM_21, TXPMA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_21, TM_TX_ELEC_IDLE_DELAY_EXIT, 0, 8)
REG32(L1_TXPMA_TM_22, 0x4858)
    FIELD(L1_TXPMA_TM_22, TXPMA_TM_22_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_22, TM_TX_ENABLE_LFPS_DELAY_ENTRY, 0, 8)
REG32(L1_TXPMA_TM_23, 0x485c)
    FIELD(L1_TXPMA_TM_23, TXPMA_TM_23_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_23, TM_TX_ENABLE_LFPS_DELAY_EXIT, 0, 8)
REG32(L1_TXPMA_TM_24, 0x4860)
    FIELD(L1_TXPMA_TM_24, TXPMA_TM_24_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_24, ANA_MISC6_7_RSVD, 7, 1)
    FIELD(L1_TXPMA_TM_24, TM_TX_EN_ANA_SUBLP_MODE, 6, 1)
    FIELD(L1_TXPMA_TM_24, TM_FORCE_TX_EN_ANA_SUBLP_MODE, 5, 1)
    FIELD(L1_TXPMA_TM_24, TM_TX_EN_DIG_SUBLP_MODE, 4, 1)
    FIELD(L1_TXPMA_TM_24, TM_FORCE_TX_EN_DIG_SUBLP_MODE, 3, 1)
    FIELD(L1_TXPMA_TM_24, TM_TX_DP_LVLDB0_OVRRD, 2, 1)
    FIELD(L1_TXPMA_TM_24, TM_FORCE_TX_DP_LVLDB0_OVRRD, 1, 1)
    FIELD(L1_TXPMA_TM_24, TM_TX_CLOCK_STOP_REQ, 0, 1)
REG32(L1_TXPMA_TM_25, 0x4864)
    FIELD(L1_TXPMA_TM_25, TXPMA_TM_25_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_25, ANA_MISC6_7_6_RSVD, 6, 2)
    FIELD(L1_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_PLL, 5, 1)
    FIELD(L1_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_RX, 4, 1)
    FIELD(L1_TXPMA_TM_25, TM_TX_LANE_LNG, 3, 1)
    FIELD(L1_TXPMA_TM_25, TM_FORCE_TX_LANE_LNG, 2, 1)
    FIELD(L1_TXPMA_TM_25, TM_TX_LANE_MASTER, 1, 1)
    FIELD(L1_TXPMA_TM_25, TM_FORCE_TX_LANE_MASTER, 0, 1)
REG32(L1_TXPMA_TM_26, 0x4868)
    FIELD(L1_TXPMA_TM_26, TXPMA_TM_26_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_26, TM_TXPMD_APB_RESET_DELAY, 0, 8)
REG32(L1_TXPMA_TM_27, 0x486c)
    FIELD(L1_TXPMA_TM_27, TXPMA_TM_27_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_TM_27, TM_BSCAN_MODE_EN, 7, 1)
    FIELD(L1_TXPMA_TM_27, TM_FORCE_BSCAN_MODE_EN, 6, 1)
    FIELD(L1_TXPMA_TM_27, TM_PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L1_TXPMA_TM_27, TM_FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L1_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L1_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_LFPS, 2, 1)
    FIELD(L1_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_IDLE_MODE, 1, 1)
    FIELD(L1_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L1_TXPMA_ST_0, 0x4b00)
    FIELD(L1_TXPMA_ST_0, TXPMA_ST_0_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_0, TX_PHY_MODE, 4, 4)
    FIELD(L1_TXPMA_ST_0, TX_PHY_GEAR, 0, 4)
REG32(L1_TXPMA_ST_1, 0x4b04)
    FIELD(L1_TXPMA_ST_1, TXPMA_ST_1_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_1, TX_ENABLE_HSCLK_DIVISION, 6, 2)
    FIELD(L1_TXPMA_ST_1, PIPE_TX_TRISTATE, 5, 1)
    FIELD(L1_TXPMA_ST_1, TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L1_TXPMA_ST_1, TX_ENABLE_SUPPLY_HSCLK, 3, 1)
    FIELD(L1_TXPMA_ST_1, TX_ENABLE_SUPPLY_MPHY, 2, 1)
    FIELD(L1_TXPMA_ST_1, TX_ENABLE_SUPPLY_PIPE, 1, 1)
    FIELD(L1_TXPMA_ST_1, TX_ENABLE_SUPPLY_UPHY, 0, 1)
REG32(L1_TXPMA_ST_2, 0x4b08)
    FIELD(L1_TXPMA_ST_2, TXPMA_ST_2_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_2, ANA_ST2_7_5_SPARE, 5, 3)
    FIELD(L1_TXPMA_ST_2, PIPE_TX_ENABLE_RXDET, 4, 1)
    FIELD(L1_TXPMA_ST_2, PIPE_TX_ENABLE_IDLE_MODE, 2, 2)
    FIELD(L1_TXPMA_ST_2, PIPE_TX_ENABLE_LFPS, 0, 2)
REG32(L1_TXPMA_ST_3, 0x4b0c)
    FIELD(L1_TXPMA_ST_3, TXPMA_ST_3_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_3, ANA_ST3_7_6_SPARE, 6, 2)
    FIELD(L1_TXPMA_ST_3, TX_LSEG_DN_RESCAL_CODE, 0, 6)
REG32(L1_TXPMA_ST_4, 0x4b10)
    FIELD(L1_TXPMA_ST_4, TXPMA_ST_4_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_4, ANA_ST4_7_6_SPARE, 6, 2)
    FIELD(L1_TXPMA_ST_4, TX_USEG_DP_RESCAL_CODE, 0, 6)
REG32(L1_TXPMA_ST_5, 0x4b14)
    FIELD(L1_TXPMA_ST_5, TXPMA_ST_5_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_5, ANA_ST5_7_6_SPARE, 6, 2)
    FIELD(L1_TXPMA_ST_5, PIPE_TX_LOCALFS, 0, 6)
REG32(L1_TXPMA_ST_6, 0x4b18)
    FIELD(L1_TXPMA_ST_6, TXPMA_ST_6_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_6, ANA_ST6_7_SPARE, 7, 1)
    FIELD(L1_TXPMA_ST_6, PIPE_TX_LOCALTXCOEFFICIENTSVALID, 6, 1)
    FIELD(L1_TXPMA_ST_6, PIPE_TX_LOCALLF, 0, 6)
REG32(L1_TXPMA_ST_7, 0x4b1c)
    FIELD(L1_TXPMA_ST_7, TXPMA_ST_7_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_7, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_7_0, 0, 8)
REG32(L1_TXPMA_ST_8, 0x4b20)
    FIELD(L1_TXPMA_ST_8, TXPMA_ST_8_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_8, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_15_8, 0, 8)
REG32(L1_TXPMA_ST_9, 0x4b24)
    FIELD(L1_TXPMA_ST_9, TXPMA_ST_9_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMA_ST_9, ANA_ST9_7_2_SPARE, 2, 6)
    FIELD(L1_TXPMA_ST_9, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_17_16, 0, 2)
REG32(L1_TXPMD_TM_0, 0x4c00)
    FIELD(L1_TXPMD_TM_0, TXPMD_TM_0_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_1, 0x4c04)
    FIELD(L1_TXPMD_TM_1, TXPMD_TM_1_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_2, 0x4c08)
    FIELD(L1_TXPMD_TM_2, TXPMD_TM_2_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_3, 0x4c0c)
    FIELD(L1_TXPMD_TM_3, TXPMD_TM_3_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_4, 0x4c10)
    FIELD(L1_TXPMD_TM_4, TXPMD_TM_4_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_5, 0x4c14)
    FIELD(L1_TXPMD_TM_5, TXPMD_TM_5_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_6, 0x4c18)
    FIELD(L1_TXPMD_TM_6, TXPMD_TM_6_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_7, 0x4c1c)
    FIELD(L1_TXPMD_TM_7, TXPMD_TM_7_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_8, 0x4c20)
    FIELD(L1_TXPMD_TM_8, TXPMD_TM_8_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_9, 0x4c24)
    FIELD(L1_TXPMD_TM_9, TXPMD_TM_9_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_10, 0x4c28)
    FIELD(L1_TXPMD_TM_10, TXPMD_TM_10_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_11, 0x4c2c)
    FIELD(L1_TXPMD_TM_11, TXPMD_TM_11_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_12, 0x4c30)
    FIELD(L1_TXPMD_TM_12, TXPMD_TM_12_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_13, 0x4c34)
    FIELD(L1_TXPMD_TM_13, TXPMD_TM_13_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_14, 0x4c38)
    FIELD(L1_TXPMD_TM_14, TXPMD_TM_14_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_15, 0x4c3c)
    FIELD(L1_TXPMD_TM_15, TXPMD_TM_15_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_16, 0x4c40)
    FIELD(L1_TXPMD_TM_16, TXPMD_TM_16_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_17, 0x4c44)
    FIELD(L1_TXPMD_TM_17, TXPMD_TM_17_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_18, 0x4c48)
    FIELD(L1_TXPMD_TM_18, TXPMD_TM_18_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_19, 0x4c4c)
    FIELD(L1_TXPMD_TM_19, TXPMD_TM_19_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_20, 0x4c50)
    FIELD(L1_TXPMD_TM_20, TXPMD_TM_20_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_21, 0x4c54)
    FIELD(L1_TXPMD_TM_21, TXPMD_TM_21_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_22, 0x4c58)
    FIELD(L1_TXPMD_TM_22, TXPMD_TM_22_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_23, 0x4c5c)
    FIELD(L1_TXPMD_TM_23, TXPMD_TM_23_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_24, 0x4c60)
    FIELD(L1_TXPMD_TM_24, TXPMD_TM_24_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_25, 0x4c64)
    FIELD(L1_TXPMD_TM_25, TXPMD_TM_25_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_26, 0x4c68)
    FIELD(L1_TXPMD_TM_26, TXPMD_TM_26_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_27, 0x4c6c)
    FIELD(L1_TXPMD_TM_27, TXPMD_TM_27_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_28, 0x4c70)
    FIELD(L1_TXPMD_TM_28, TXPMD_TM_28_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_29, 0x4c74)
    FIELD(L1_TXPMD_TM_29, TXPMD_TM_29_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_30, 0x4c78)
    FIELD(L1_TXPMD_TM_30, TXPMD_TM_30_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L1_TXPMD_TM_31, 0x4c7c)
    FIELD(L1_TXPMD_TM_31, TXPMD_TM_31_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L1_TXPMD_TM_32, 0x4c80)
    FIELD(L1_TXPMD_TM_32, TXPMD_TM_32_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_32, PIPE_TM_TX_PRE_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L1_TXPMD_TM_33, 0x4c84)
    FIELD(L1_TXPMD_TM_33, TXPMD_TM_33_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_33, PIPE_TM_TX_PRE_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L1_TXPMD_TM_34, 0x4c88)
    FIELD(L1_TXPMD_TM_34, TXPMD_TM_34_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_34, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L1_TXPMD_TM_35, 0x4c8c)
    FIELD(L1_TXPMD_TM_35, TXPMD_TM_35_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_35, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L1_TXPMD_TM_36, 0x4c90)
    FIELD(L1_TXPMD_TM_36, TXPMD_TM_36_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_36, PIPE_TM_TX_POST_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L1_TXPMD_TM_37, 0x4c94)
    FIELD(L1_TXPMD_TM_37, TXPMD_TM_37_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_37, PIPE_TM_TX_POST_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L1_TXPMD_TM_38, 0x4c98)
    FIELD(L1_TXPMD_TM_38, TXPMD_TM_38_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_38, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L1_TXPMD_TM_38, PIPE_TM_TX_ENABLE_SWNW_CNTRL_BYP, 6, 1)
    FIELD(L1_TXPMD_TM_38, PIPE_TM_TX_ENABLE_TRISTATE_BYP, 5, 1)
    FIELD(L1_TXPMD_TM_38, PIPE_TM_TX_TRISTATE, 4, 1)
    FIELD(L1_TXPMD_TM_38, TM_TX_DRIVERLDO_RXDET_BYP, 3, 1)
    FIELD(L1_TXPMD_TM_38, TM_TX_DRIVERLDO_IDLE_BYP, 2, 1)
    FIELD(L1_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_RXDET_BYP, 1, 1)
    FIELD(L1_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_IDLE_BYP, 0, 1)
REG32(L1_TXPMD_TM_39, 0x4c9c)
    FIELD(L1_TXPMD_TM_39, TXPMD_TM_39_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_39, ANA_MPHY_BYP0_7_3_RSVD, 3, 5)
    FIELD(L1_TXPMD_TM_39, MPHY_TM_TX_OVRD_DEEMPH_TRIM, 2, 1)
    FIELD(L1_TXPMD_TM_39, MPHY_TM_TX_ENABLE_DEEMPH, 1, 1)
    FIELD(L1_TXPMD_TM_39, MPHY_TM_TX_OVRD_ENABLE_DEEMPH, 0, 1)
REG32(L1_TXPMD_TM_40, 0x4ca0)
    FIELD(L1_TXPMD_TM_40, TXPMD_TM_40_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_40, MPHY_TM_TX_DEEMPH_TRIM_7_0, 0, 8)
REG32(L1_TXPMD_TM_41, 0x4ca4)
    FIELD(L1_TXPMD_TM_41, TXPMD_TM_41_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_41, MPHY_TM_TX_DEEMPH_TRIM_15_8, 0, 8)
REG32(L1_TXPMD_TM_42, 0x4ca8)
    FIELD(L1_TXPMD_TM_42, TXPMD_TM_42_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_42, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L1_TXPMD_TM_42, MPHY_TM_TX_OVRD_LS_DATA, 1, 4)
    FIELD(L1_TXPMD_TM_42, MPHY_TM_TX_ENABLE_OVRD_LS_DATA, 0, 1)
REG32(L1_TXPMD_TM_43, 0x4cac)
    FIELD(L1_TXPMD_TM_43, TXPMD_TM_43_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_43, ANA_MPHY_BYP4_7_4_RSVD, 4, 4)
    FIELD(L1_TXPMD_TM_43, MPHY_TM_TX_OVRD_LS_DATA_BAR, 0, 4)
REG32(L1_TXPMD_TM_44, 0x4cb0)
    FIELD(L1_TXPMD_TM_44, TXPMD_TM_44_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_44, ANA_PIPE_BYP38_7_6_RSVD, 6, 2)
    FIELD(L1_TXPMD_TM_44, PIPE_TM_TX_EN_PRE_LFPS_PATH, 5, 1)
    FIELD(L1_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_PRE_LFPS_PATH, 4, 1)
    FIELD(L1_TXPMD_TM_44, PIPE_TM_TX_EN_POST_LFPS_PATH, 3, 1)
    FIELD(L1_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_POST_LFPS_PATH, 2, 1)
    FIELD(L1_TXPMD_TM_44, PIPE_TM_TX_EN_MAIN_LFPS_PATH, 1, 1)
    FIELD(L1_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_MAIN_LFPS_PATH, 0, 1)
REG32(L1_TXPMD_TM_45, 0x4cb4)
    FIELD(L1_TXPMD_TM_45, TXPMD_TM_45_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_45, ANA_DP_BYP0_7_6_RSVD, 6, 2)
    FIELD(L1_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST2_PATH, 5, 1)
    FIELD(L1_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST2_PATH, 4, 1)
    FIELD(L1_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST1_PATH, 3, 1)
    FIELD(L1_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST1_PATH, 2, 1)
    FIELD(L1_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L1_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_MAIN_PATH, 0, 1)
REG32(L1_TXPMD_TM_46, 0x4cb8)
    FIELD(L1_TXPMD_TM_46, TXPMD_TM_46_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_46, ANA_PIPE_BYP39_7_6_RSVD, 6, 2)
    FIELD(L1_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_PRE_PATH, 5, 1)
    FIELD(L1_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_PRE_PATH, 4, 1)
    FIELD(L1_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_POST_PATH, 3, 1)
    FIELD(L1_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_POST_PATH, 2, 1)
    FIELD(L1_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L1_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_MAIN_PATH, 0, 1)
REG32(L1_TXPMD_TM_47, 0x4cbc)
    FIELD(L1_TXPMD_TM_47, TXPMD_TM_47_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_47, TM_TX_RSVD1, 0, 8)
REG32(L1_TXPMD_TM_48, 0x4cc0)
    FIELD(L1_TXPMD_TM_48, TXPMD_TM_48_31_8_RSVD, 24, 8)
    FIELD(L1_TXPMD_TM_48, ANA_MISC2_7_6_RSVD, 6, 2)
    FIELD(L1_TXPMD_TM_48, TM_FORCE_RESULTANT_MARGINING_FACTOR, 5, 1)
    FIELD(L1_TXPMD_TM_48, TM_RESULTANT_MARGINING_FACTOR, 0, 5)
REG32(L1_TM_ANA_BYP_1, 0x5004)
    FIELD(L1_TM_ANA_BYP_1, TM_ANA_BYP_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_1, MPHY_PWM_DES_PDZ, 7, 1)
    FIELD(L1_TM_ANA_BYP_1, FORCE_MPHY_PWM_DES_PDZ, 6, 1)
    FIELD(L1_TM_ANA_BYP_1, MPHY_PWMB_SYS_ENABLE, 5, 1)
    FIELD(L1_TM_ANA_BYP_1, FORCE_MPHY_PWMB_SYS_ENABLE, 4, 1)
    FIELD(L1_TM_ANA_BYP_1, MPHY_PSO_SQUELCH, 3, 1)
    FIELD(L1_TM_ANA_BYP_1, FORCE_MPHY_PSO_SQUELCH, 2, 1)
    FIELD(L1_TM_ANA_BYP_1, MPHY_PSO_LSRX, 1, 1)
    FIELD(L1_TM_ANA_BYP_1, FORCE_MPHY_PSO_LSRX, 0, 1)
REG32(L1_TM_ANA_BYP_2, 0x5008)
    FIELD(L1_TM_ANA_BYP_2, TM_ANA_BYP_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_2, MPHY_PWM_LSPREAMP_PD, 7, 1)
    FIELD(L1_TM_ANA_BYP_2, FORCE_MPHY_PWM_LSPREAMP_PD, 6, 1)
    FIELD(L1_TM_ANA_BYP_2, MPHY_PWM_GEAR_SEL, 3, 3)
    FIELD(L1_TM_ANA_BYP_2, FORCE_MPHY_PWM_GEAR_SEL, 2, 1)
    FIELD(L1_TM_ANA_BYP_2, MPHY_PWM_DET_PD, 1, 1)
    FIELD(L1_TM_ANA_BYP_2, FORCE_MPHY_PWM_DET_PD, 0, 1)
REG32(L1_TM_ANA_BYP_3, 0x500c)
    FIELD(L1_TM_ANA_BYP_3, TM_ANA_BYP_3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_3, MPHY_RX_MASK_BURST_START, 7, 1)
    FIELD(L1_TM_ANA_BYP_3, FORCE_MPHY_RX_MASK_BURST_START, 6, 1)
    FIELD(L1_TM_ANA_BYP_3, MPHY_RX_GATE_SYMBOL_CLK, 5, 1)
    FIELD(L1_TM_ANA_BYP_3, FORCE_MPHY_RX_GATE_SYMBOL_CLK, 4, 1)
    FIELD(L1_TM_ANA_BYP_3, MPHY_PWM_PREAMP_BIAS_PD, 3, 1)
    FIELD(L1_TM_ANA_BYP_3, FORCE_MPHY_PWM_PREAMP_BIAS_PD, 2, 1)
    FIELD(L1_TM_ANA_BYP_3, MPHY_PWM_LSPREAMP_STANDBYSLEEPSTALL, 1, 1)
    FIELD(L1_TM_ANA_BYP_3, FORCE_MPHY_PWM_LSPREAMP_STANDBYSLEEPSTAL, 0, 1)
REG32(L1_TM_ANA_BYP_4, 0x5010)
    FIELD(L1_TM_ANA_BYP_4, TM_ANA_BYP_4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_4, HSRX_RSTB, 7, 1)
    FIELD(L1_TM_ANA_BYP_4, FORCE_HSRX_RSTB, 6, 1)
    FIELD(L1_TM_ANA_BYP_4, MPHY_RX_TERM_ENABLE, 5, 1)
    FIELD(L1_TM_ANA_BYP_4, FORCE_MPHY_RX_TERM_ENABLE, 4, 1)
    FIELD(L1_TM_ANA_BYP_4, MPHY_RX_MUX_TYP1B_TYP2, 3, 1)
    FIELD(L1_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_TYP1B_TYP2, 2, 1)
    FIELD(L1_TM_ANA_BYP_4, MPHY_RX_MUX_HSB_LS, 1, 1)
    FIELD(L1_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_HSB_LS, 0, 1)
REG32(L1_TM_ANA_BYP_5, 0x5014)
    FIELD(L1_TM_ANA_BYP_5, TM_ANA_BYP_5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_5, MPHY_SQ_SWAP_POLARITY, 5, 1)
    FIELD(L1_TM_ANA_BYP_5, FORCE_MPHY_SQ_SWAP_POLARITY, 4, 1)
    FIELD(L1_TM_ANA_BYP_5, MPHY_SQ_PD, 3, 1)
    FIELD(L1_TM_ANA_BYP_5, FORCE_MPHY_SQ_PD, 2, 1)
    FIELD(L1_TM_ANA_BYP_5, MPHY_SQ_DETECTOR_PD, 1, 1)
    FIELD(L1_TM_ANA_BYP_5, FORCE_MPHY_SQ_DETECTOR_PD, 0, 1)
REG32(L1_TM_ANA_BYP_7, 0x5018)
    FIELD(L1_TM_ANA_BYP_7, TM_ANA_BYP_7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_7, PIPE_RXEQTRAINING, 7, 1)
    FIELD(L1_TM_ANA_BYP_7, FORCE_PIPE_RXEQTRAINING, 6, 1)
    FIELD(L1_TM_ANA_BYP_7, PIPE_RX_TERM_ENABLE, 5, 1)
    FIELD(L1_TM_ANA_BYP_7, FORCE_PIPE_RX_TERM_ENABLE, 4, 1)
REG32(L1_TM_ANA_BYP_8, 0x501c)
    FIELD(L1_TM_ANA_BYP_8, TM_ANA_BYP_8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 7, 1)
    FIELD(L1_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 6, 1)
    FIELD(L1_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 5, 1)
    FIELD(L1_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 4, 1)
    FIELD(L1_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 3, 1)
    FIELD(L1_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 2, 1)
    FIELD(L1_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 1, 1)
    FIELD(L1_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 0, 1)
REG32(L1_TM_ANA_BYP_9, 0x5020)
    FIELD(L1_TM_ANA_BYP_9, TM_ANA_BYP_9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_9, UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 7, 1)
    FIELD(L1_TM_ANA_BYP_9, FORCE_UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 6, 1)
    FIELD(L1_TM_ANA_BYP_9, UPHY_PSO_SAMP_LPBK, 5, 1)
    FIELD(L1_TM_ANA_BYP_9, FORCE_UPHY_PSO_SAMP_LPBK, 4, 1)
    FIELD(L1_TM_ANA_BYP_9, UPHY_EQ_LPBK_ENABLE_CORE, 3, 1)
    FIELD(L1_TM_ANA_BYP_9, FORCE_UPHY_EQ_LPBK_ENABLE_CORE, 2, 1)
    FIELD(L1_TM_ANA_BYP_9, UPHY_EQ_AC_DCZ_COUPLED_CORE, 1, 1)
    FIELD(L1_TM_ANA_BYP_9, FORCE_UPHY_EQ_AC_DCZ_COUPLED_CORE, 0, 1)
REG32(L1_TM_ANA_BYP_10, 0x5024)
    FIELD(L1_TM_ANA_BYP_10, TM_ANA_BYP_10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_10, UPHY_LPBK_CLK_DATA_SEL, 5, 1)
    FIELD(L1_TM_ANA_BYP_10, UPHY_LPBK_CENTRE_EDGEZ_ENABLE_CORE, 4, 1)
    FIELD(L1_TM_ANA_BYP_10, UPHY_HSRX_LPBK_SEL, 1, 3)
    FIELD(L1_TM_ANA_BYP_10, FORCE_UPHY_HSRX_LPBK_SEL, 0, 1)
REG32(L1_TM_ANA_BYP_11, 0x5028)
    FIELD(L1_TM_ANA_BYP_11, TM_ANA_BYP_11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_11, UPHY_PD_PI_DIV_PATH, 5, 1)
    FIELD(L1_TM_ANA_BYP_11, UPHY_PSO_CLK_LANE, 4, 1)
    FIELD(L1_TM_ANA_BYP_11, FORCE_UPHY_PSO_CLK_LANE, 3, 1)
    FIELD(L1_TM_ANA_BYP_11, UPHY_HSCLK_DIVISION_FACTOR, 1, 2)
    FIELD(L1_TM_ANA_BYP_11, FORCE_UPHY_HSCLK_DIVISION_FACTOR, 0, 1)
REG32(L1_TM_ANA_BYP_12, 0x502c)
    FIELD(L1_TM_ANA_BYP_12, TM_ANA_BYP_12_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_12, UPHY_PSO_HSRXDIG, 7, 1)
    FIELD(L1_TM_ANA_BYP_12, FORCE_UPHY_PSO_HSRXDIG, 6, 1)
    FIELD(L1_TM_ANA_BYP_12, UPHY_PDN_HS_DES, 5, 1)
    FIELD(L1_TM_ANA_BYP_12, FORCE_UPHY_PDN_HS_DES, 4, 1)
    FIELD(L1_TM_ANA_BYP_12, UPHY_RST_GF_MUX, 3, 1)
    FIELD(L1_TM_ANA_BYP_12, FORCE_UPHY_RST_GF_MUX, 2, 1)
    FIELD(L1_TM_ANA_BYP_12, UPHY_ENABLE_CDR, 1, 1)
    FIELD(L1_TM_ANA_BYP_12, FORCE_UPHY_ENABLE_CDR, 0, 1)
REG32(L1_TM_ANA_BYP_13, 0x5030)
    FIELD(L1_TM_ANA_BYP_13, TM_ANA_BYP_13_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_13, UPHY_PSO_SAMP_FLOPS, 1, 1)
    FIELD(L1_TM_ANA_BYP_13, FORCE_UPHY_PSO_SAMP_FLOPS, 0, 1)
REG32(L1_TM_ANA_BYP_14, 0x5034)
    FIELD(L1_TM_ANA_BYP_14, TM_ANA_BYP_14_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_14, UPHY_PSO_EPI, 7, 1)
    FIELD(L1_TM_ANA_BYP_14, FORCE_UPHY_PSO_EPI, 6, 1)
    FIELD(L1_TM_ANA_BYP_14, UPHY_PD_SAMP_C2C_ECLK, 5, 1)
    FIELD(L1_TM_ANA_BYP_14, FORCE_UPHY_PD_SAMP_C2C_ECLK, 4, 1)
    FIELD(L1_TM_ANA_BYP_14, UPHY_PSO_IQPI, 1, 1)
    FIELD(L1_TM_ANA_BYP_14, FORCE_UPHY_PSO_IQPI, 0, 1)
REG32(L1_TM_ANA_BYP_15, 0x5038)
    FIELD(L1_TM_ANA_BYP_15, TM_ANA_BYP_15_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_15, UPHY_ENABLE_LOW_LEAKAGE, 7, 1)
    FIELD(L1_TM_ANA_BYP_15, FORCE_UPHY_ENABLE_LOW_LEAKAGE, 6, 1)
    FIELD(L1_TM_ANA_BYP_15, UPHY_PD_SAMP_C2C, 5, 1)
    FIELD(L1_TM_ANA_BYP_15, FORCE_UPHY_PD_SAMP_C2C, 4, 1)
    FIELD(L1_TM_ANA_BYP_15, UPHY_PSO_CORE_EQ, 3, 1)
    FIELD(L1_TM_ANA_BYP_15, FORCE_UPHY_PSO_CORE_EQ, 2, 1)
    FIELD(L1_TM_ANA_BYP_15, UPHY_PSO_IO_EQ, 1, 1)
    FIELD(L1_TM_ANA_BYP_15, FORCE_UPHY_PSO_IO_EQ, 0, 1)
REG32(L1_TM_ANA_BYP_16, 0x503c)
    FIELD(L1_TM_ANA_BYP_16, TM_ANA_BYP_16_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_16, UPHY_PSO_SIGDET, 7, 1)
    FIELD(L1_TM_ANA_BYP_16, FORCE_UPHY_PSO_SIGDET, 6, 1)
    FIELD(L1_TM_ANA_BYP_16, UPHY_RX_LANE_POLARITY_SWAP, 5, 1)
    FIELD(L1_TM_ANA_BYP_16, FORCE_UPHY_RX_LANE_POLARITY_SWAP, 4, 1)
    FIELD(L1_TM_ANA_BYP_16, UPHY_RUN_CALIB, 3, 1)
    FIELD(L1_TM_ANA_BYP_16, FORCE_UPHY_RUN_CALIB, 2, 1)
    FIELD(L1_TM_ANA_BYP_16, UPHY_RESTORE_CALCODE, 1, 1)
    FIELD(L1_TM_ANA_BYP_16, FORCE_UPHY_RESTORE_CALCODE, 0, 1)
REG32(L1_TM_ANA_BYP_17, 0x5040)
    FIELD(L1_TM_ANA_BYP_17, TM_ANA_BYP_17_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_17, UPHY_STARTLOOP_PLL, 6, 1)
    FIELD(L1_TM_ANA_BYP_17, FORCE_UPHY_STARTLOOP_PLL, 5, 1)
    FIELD(L1_TM_ANA_BYP_17, UPHY_RX_RESCALIB_CODE, 1, 4)
    FIELD(L1_TM_ANA_BYP_17, FORCE_UPHY_RX_RESCALIB_CODE, 0, 1)
REG32(L1_TM_ANA_BYP_18, 0x5044)
    FIELD(L1_TM_ANA_BYP_18, TM_ANA_BYP_18_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_18, FORCE_UPHY_RESTORE_CALCODE_DATA, 3, 1)
    FIELD(L1_TM_ANA_BYP_18, FORCE_UPHY_RX_PMA_OPMODE, 2, 1)
    FIELD(L1_TM_ANA_BYP_18, UPHY_PSO_LFPSBCN, 1, 1)
    FIELD(L1_TM_ANA_BYP_18, FORCE_UPHY_PSO_LFPSBCN, 0, 1)
REG32(L1_TM_ANA_BYP_20, 0x5048)
    FIELD(L1_TM_ANA_BYP_20, TM_ANA_BYP_20_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_20, UPHY_RX_PMA_OPMODE, 0, 8)
REG32(L1_TM_ANA_BYP_21, 0x504c)
    FIELD(L1_TM_ANA_BYP_21, TM_ANA_BYP_21_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_21, UPHY_RESTORE_CALCODE_DATA, 0, 8)
REG32(L1_TM_ANA_BYP_22, 0x5050)
    FIELD(L1_TM_ANA_BYP_22, TM_ANA_BYP_22_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_22, ISO_HSRX_CTRL_BAR, 7, 1)
    FIELD(L1_TM_ANA_BYP_22, FORCE_ISO_HSRX_CTRL_BAR, 6, 1)
    FIELD(L1_TM_ANA_BYP_22, HSRX_CLOCK_STOP_REQ, 5, 1)
    FIELD(L1_TM_ANA_BYP_22, FORCE_HSRX_CLOCK_STOP_REQ, 4, 1)
    FIELD(L1_TM_ANA_BYP_22, UPHY_SBRX_RUN_CALIB, 3, 1)
    FIELD(L1_TM_ANA_BYP_22, FORCE_UPHY_SBRX_RUN_CALIB, 2, 1)
    FIELD(L1_TM_ANA_BYP_22, RXPMA_RSTB, 1, 1)
    FIELD(L1_TM_ANA_BYP_22, FORCE_RXPMA_RSTB, 0, 1)
REG32(L1_TM_ANA_BYP_23, 0x5054)
    FIELD(L1_TM_ANA_BYP_23, TM_ANA_BYP_23_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_BYP_23, ISO_SIGDET_CTRL_BAR, 7, 1)
    FIELD(L1_TM_ANA_BYP_23, FORCE_ISO_SIGDET_CTRL_BAR, 6, 1)
    FIELD(L1_TM_ANA_BYP_23, ISO_LFPS_CTRL_BAR, 5, 1)
    FIELD(L1_TM_ANA_BYP_23, FORCE_ISO_LFPS_CTRL_BAR, 4, 1)
    FIELD(L1_TM_ANA_BYP_23, ISO_MPHY_LSRX_CTRL_BAR, 3, 1)
    FIELD(L1_TM_ANA_BYP_23, FORCE_ISO_MPHY_LSRX_CTRL_BAR, 2, 1)
    FIELD(L1_TM_ANA_BYP_23, ISO_MPHY_SQUELCH_CTRL_BAR, 1, 1)
    FIELD(L1_TM_ANA_BYP_23, FORCE_ISO_MPHY_SQUELCH_CTRL_BAR, 0, 1)
REG32(L1_TM_DIG_1, 0x5058)
    FIELD(L1_TM_DIG_1, TM_DIG_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_1, EN_TXRX_DIFGEAR, 7, 1)
    FIELD(L1_TM_DIG_1, MPHY_HS_TERM_PT_SEL, 6, 1)
    FIELD(L1_TM_DIG_1, TX_ALLOW_INLNCFG_FROM_TOP, 5, 1)
    FIELD(L1_TM_DIG_1, BYPASS_MARKER_DETECTOR, 4, 1)
    FIELD(L1_TM_DIG_1, BYPASS_EXIT_VAL, 0, 4)
REG32(L1_TM_DIG_2, 0x505c)
    FIELD(L1_TM_DIG_2, TM_DIG_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_2, MPHY_SYM_STATE, 1, 5)
    FIELD(L1_TM_DIG_2, FORCE_MPHY_SYM_STATE, 0, 1)
REG32(L1_TM_DIG_3, 0x5060)
    FIELD(L1_TM_DIG_3, TM_DIG_3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_3, MPHY_SQUELCH_DETECT, 7, 1)
    FIELD(L1_TM_DIG_3, FORCE_MPHY_SQUELCH_DETECT, 6, 1)
    FIELD(L1_TM_DIG_3, MPHY_CFG_STATE, 1, 5)
    FIELD(L1_TM_DIG_3, FORCE_MPHY_CFG_STATE, 0, 1)
REG32(L1_TM_DIG_4, 0x5064)
    FIELD(L1_TM_DIG_4, TM_DIG_4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_4, STATUS_REG_VAL, 4, 4)
    FIELD(L1_TM_DIG_4, READ_SHADOW, 3, 1)
REG32(L1_TM_DIG_5, 0x5068)
    FIELD(L1_TM_DIG_5, TM_DIG_5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_5, SYMBOL_CLK_ALWAYS_ON_N, 2, 1)
    FIELD(L1_TM_DIG_5, BYPASS_DIFN_DETECT, 1, 1)
    FIELD(L1_TM_DIG_5, HIBERN8_CTRL, 0, 1)
REG32(L1_TM_DIG_6, 0x506c)
    FIELD(L1_TM_DIG_6, TM_DIG_6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_6, FORCE_BYPASS_ON_ERR, 6, 1)
    FIELD(L1_TM_DIG_6, SUPPRESS_ERR, 5, 1)
    FIELD(L1_TM_DIG_6, BYPASS_OHC, 4, 1)
    FIELD(L1_TM_DIG_6, BYPASS_DECODER, 3, 1)
    FIELD(L1_TM_DIG_6, FORCE_BYPASS_DEC, 2, 1)
    FIELD(L1_TM_DIG_6, BYPASS_DESCRAM, 1, 1)
    FIELD(L1_TM_DIG_6, FORCE_BYPASS_DESCRAM, 0, 1)
REG32(L1_TM_DIG_7, 0x5070)
    FIELD(L1_TM_DIG_7, TM_DIG_7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_7, BYPASS_ON_ERR_CHAR, 0, 8)
REG32(L1_TM_DIG_8, 0x5074)
    FIELD(L1_TM_DIG_8, TM_DIG_8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_8, EYESURF_ENABLE, 4, 1)
    FIELD(L1_TM_DIG_8, USE_EB_IN_MPHY, 3, 1)
    FIELD(L1_TM_DIG_8, BYPASS_EB, 2, 1)
    FIELD(L1_TM_DIG_8, EB_MODE, 1, 1)
    FIELD(L1_TM_DIG_8, FORCE_EB_MODE, 0, 1)
REG32(L1_TM_DIG_9, 0x5078)
    FIELD(L1_TM_DIG_9, TM_DIG_9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_9, FLIP_ENDIAN, 3, 1)
    FIELD(L1_TM_DIG_9, DEC_ERR_CNT_THRESHOLD, 0, 3)
REG32(L1_TM_DIG_10, 0x507c)
    FIELD(L1_TM_DIG_10, TM_DIG_10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_10, CDR_BIT_LOCK_TIME, 0, 4)
REG32(L1_TM_DIG_11, 0x5080)
    FIELD(L1_TM_DIG_11, TM_DIG_11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_11, BYPASS_CDR_ERR_MASK, 7, 1)
    FIELD(L1_TM_DIG_11, SYMB_ERR_SEL, 5, 2)
    FIELD(L1_TM_DIG_11, SYMB_ERR, 4, 1)
REG32(L1_TM_DIG_12, 0x5084)
    FIELD(L1_TM_DIG_12, TM_DIG_12_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_12, FLIP_ENDIAN_EB_DATA_OUT, 5, 1)
    FIELD(L1_TM_DIG_12, FLIP_ENDIAN_EB_DATA_IN, 4, 1)
    FIELD(L1_TM_DIG_12, OVERFLOW_BYP, 3, 1)
    FIELD(L1_TM_DIG_12, UNDERFLOW_BYP, 2, 1)
    FIELD(L1_TM_DIG_12, OVERFLOW_BYP_VAL, 1, 1)
    FIELD(L1_TM_DIG_12, UNDERFLOW_BYP_VAL, 0, 1)
REG32(L1_TM_DIG_13, 0x5088)
    FIELD(L1_TM_DIG_13, TM_DIG_13_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_13, OMC_PRESENTN, 6, 1)
    FIELD(L1_TM_DIG_13, CFG_CLK_FREQ, 0, 6)
REG32(L1_TM_DIG_14, 0x508c)
    FIELD(L1_TM_DIG_14, TM_DIG_14_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_14, LFPS_OUTPUT_SEL, 6, 2)
    FIELD(L1_TM_DIG_14, LFPS_STRETCH, 4, 2)
REG32(L1_TM_DIG_15, 0x5090)
    FIELD(L1_TM_DIG_15, TM_DIG_15_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_15, FORCE_LFPS_FILTER_THRESH, 5, 1)
    FIELD(L1_TM_DIG_15, LFPS_FILTER_THRESH, 0, 5)
REG32(L1_TM_DIG_16, 0x5094)
    FIELD(L1_TM_DIG_16, TM_DIG_16_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_16, TESTDIGOUT_SEL, 1, 4)
    FIELD(L1_TM_DIG_16, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L1_TM_DIG_17, 0x5098)
    FIELD(L1_TM_DIG_17, TM_DIG_17_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_17, FORCE_SATA_RX_VALID_CNT, 4, 1)
    FIELD(L1_TM_DIG_17, SATA_RX_VALID_CNT, 0, 4)
REG32(L1_TM_DIG_18, 0x509c)
    FIELD(L1_TM_DIG_18, TM_DIG_18_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_18, CLK_DIST_SETTLE_TIME, 4, 4)
    FIELD(L1_TM_DIG_18, BIASGEN_SETTLE_TIME, 0, 4)
REG32(L1_TM_DIG_19, 0x50a0)
    FIELD(L1_TM_DIG_19, TM_DIG_19_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_19, HSRX_ANA_SETTLE_TIME, 4, 4)
    FIELD(L1_TM_DIG_19, SBRX_ANA_SETTLE_TIME, 0, 4)
REG32(L1_TM_DIG_20, 0x50a4)
    FIELD(L1_TM_DIG_20, TM_DIG_20_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_20, HSRX_COOLING_TIME, 3, 4)
    FIELD(L1_TM_DIG_20, FORCE_RX_CAL, 2, 1)
    FIELD(L1_TM_DIG_20, BYPASS_HSRX_CAL, 1, 1)
    FIELD(L1_TM_DIG_20, BYPASS_SBRX_CAL, 0, 1)
REG32(L1_TM_DIG_21, 0x50a8)
    FIELD(L1_TM_DIG_21, TM_DIG_21_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_21, COMMA_LOCATION_RST, 4, 1)
    FIELD(L1_TM_DIG_21, SSC_WAIT_CNT, 2, 2)
    FIELD(L1_TM_DIG_21, COMMA_PRE_LOCK_THRESH, 0, 2)
REG32(L1_TM_DIG_22, 0x50ac)
    FIELD(L1_TM_DIG_22, TM_DIG_22_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_22, DIS_DEFAULT_CDR_GATE_LOGIC, 5, 1)
    FIELD(L1_TM_DIG_22, INV_POL_SIGDET_HIGH, 4, 1)
    FIELD(L1_TM_DIG_22, INV_POL_SIGDET_LOW, 3, 1)
    FIELD(L1_TM_DIG_22, SIGDET_LFPS_BAR_EN, 2, 1)
    FIELD(L1_TM_DIG_22, OBSRV_SIGDET_OUTPUT, 1, 1)
    FIELD(L1_TM_DIG_22, RX_SIGDET_EN, 0, 1)
REG32(L1_TM_DIG_23, 0x50b0)
    FIELD(L1_TM_DIG_23, TM_DIG_23_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_23, DELAY_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L1_TM_DIG_23, FORCE_RX_SIGDET_SEL, 5, 1)
    FIELD(L1_TM_DIG_23, RX_SIGDET_SEL_VAL, 4, 1)
    FIELD(L1_TM_DIG_23, FORCE_RX_SIG_DET_FILT_FUNC_SEL, 3, 1)
    FIELD(L1_TM_DIG_23, RX_SIG_DET_FILT_FUNC_SEL, 0, 3)
REG32(L1_TM_DIG_24, 0x50b4)
    FIELD(L1_TM_DIG_24, TM_DIG_24_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_24, FILTER_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L1_TM_DIG_24, MIN_TIMER_LOAD_VAL_HIGH_1, 4, 2)
    FIELD(L1_TM_DIG_24, FILTER_TIMER_LOAD_VAL_LOW_1, 2, 2)
    FIELD(L1_TM_DIG_24, MIN_TIMER_LOAD_VAL_LOW_1, 0, 2)
REG32(L1_TM_DIG_25, 0x50b8)
    FIELD(L1_TM_DIG_25, TM_DIG_25_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_25, FILTER_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L1_TM_DIG_26, 0x50bc)
    FIELD(L1_TM_DIG_26, TM_DIG_26_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_26, DELAY_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L1_TM_DIG_27, 0x50c0)
    FIELD(L1_TM_DIG_27, TM_DIG_27_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_27, MIN_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L1_TM_DIG_28, 0x50c4)
    FIELD(L1_TM_DIG_28, TM_DIG_28_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_28, FILTER_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L1_TM_DIG_29, 0x50c8)
    FIELD(L1_TM_DIG_29, TM_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_29, MIN_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L1_TM_AUX_0, 0x50cc)
    FIELD(L1_TM_AUX_0, TM_AUX_0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_AUX_0, BIT_0, 7, 1)
    FIELD(L1_TM_AUX_0, BIT_1, 6, 1)
    FIELD(L1_TM_AUX_0, BIT_2, 5, 1)
    FIELD(L1_TM_AUX_0, BIT_3, 4, 1)
    FIELD(L1_TM_AUX_0, BIT_4, 3, 1)
    FIELD(L1_TM_AUX_0, BIT_5, 2, 1)
    FIELD(L1_TM_AUX_0, BIT_6, 1, 1)
    FIELD(L1_TM_AUX_0, BIT_7, 0, 1)
REG32(L1_TM_AUX_1, 0x50d0)
    FIELD(L1_TM_AUX_1, TM_AUX_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_AUX_1, BIT_0, 7, 1)
    FIELD(L1_TM_AUX_1, BIT_1, 6, 1)
    FIELD(L1_TM_AUX_1, BIT_2, 5, 1)
    FIELD(L1_TM_AUX_1, BIT_3, 4, 1)
    FIELD(L1_TM_AUX_1, BIT_4, 3, 1)
    FIELD(L1_TM_AUX_1, BIT_5, 2, 1)
    FIELD(L1_TM_AUX_1, BIT_6, 1, 1)
    FIELD(L1_TM_AUX_1, BIT_7, 0, 1)
REG32(L1_TM_AUX_2, 0x50d4)
    FIELD(L1_TM_AUX_2, TM_AUX_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_AUX_2, BIT_0, 7, 1)
    FIELD(L1_TM_AUX_2, BIT_1, 6, 1)
    FIELD(L1_TM_AUX_2, BIT_2, 5, 1)
    FIELD(L1_TM_AUX_2, BIT_3, 4, 1)
    FIELD(L1_TM_AUX_2, BIT_4, 3, 1)
    FIELD(L1_TM_AUX_2, BIT_5, 2, 1)
    FIELD(L1_TM_AUX_2, BIT_6, 1, 1)
    FIELD(L1_TM_AUX_2, BIT_7, 0, 1)
REG32(L1_TM_AUX_3, 0x50d8)
    FIELD(L1_TM_AUX_3, TM_AUX_3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_AUX_3, BIT_0, 7, 1)
    FIELD(L1_TM_AUX_3, BIT_1, 6, 1)
    FIELD(L1_TM_AUX_3, BIT_2, 5, 1)
    FIELD(L1_TM_AUX_3, BIT_3, 4, 1)
    FIELD(L1_TM_AUX_3, BIT_4, 3, 1)
    FIELD(L1_TM_AUX_3, BIT_5, 2, 1)
    FIELD(L1_TM_AUX_3, BIT_6, 1, 1)
    FIELD(L1_TM_AUX_3, BIT_7, 0, 1)
REG32(L1_TM_AUX_4, 0x50dc)
    FIELD(L1_TM_AUX_4, TM_AUX_4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_AUX_4, BIT_0, 7, 1)
    FIELD(L1_TM_AUX_4, BIT_1, 6, 1)
    FIELD(L1_TM_AUX_4, BIT_2, 5, 1)
    FIELD(L1_TM_AUX_4, BIT_3, 4, 1)
    FIELD(L1_TM_AUX_4, BIT_4, 3, 1)
    FIELD(L1_TM_AUX_4, BIT_5, 2, 1)
    FIELD(L1_TM_AUX_4, BIT_6, 1, 1)
    FIELD(L1_TM_AUX_4, BIT_7, 0, 1)
REG32(L1_TM_DIG_30, 0x50e0)
    FIELD(L1_TM_DIG_30, TM_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_30, SD_LD_BAR_FILTER_TIME_VAL_1, 4, 2)
    FIELD(L1_TM_DIG_30, SD_LD_BAR_DLY_TIME_VAL_1, 2, 2)
    FIELD(L1_TM_DIG_30, SD_LD_BAR_MIN_TIMER_VAL_1, 0, 2)
REG32(L1_TM_DIG_31, 0x50e4)
    FIELD(L1_TM_DIG_31, TM_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_31, SD_LD_BAR_FILTER_TIME_VAL_0, 0, 8)
REG32(L1_TM_DIG_32, 0x50e8)
    FIELD(L1_TM_DIG_32, TM_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_32, SD_LD_BAR_DLY_TIME_VAL_0, 0, 8)
REG32(L1_TM_DIG_33, 0x50ec)
    FIELD(L1_TM_DIG_33, TM_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_33, SD_LD_BAR_MIN_TIMER_VAL_0, 0, 8)
REG32(L1_TM_DIG_34, 0x50f0)
    FIELD(L1_TM_DIG_34, TM_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_34, SATA_JUNK_DATA_TIMEOUT_VAL, 0, 6)
REG32(L1_TM_DIG_35, 0x50f4)
    FIELD(L1_TM_DIG_35, TM_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_35, SATA_CDR_LOCK_WAIT_TIMEOUT_VAL, 0, 6)
REG32(L1_TM_DIG_36, 0x50f8)
    FIELD(L1_TM_DIG_36, TM_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_36, COM_DET_THRESH_VAL_0, 0, 8)
REG32(L1_TM_DIG_37, 0x50fc)
    FIELD(L1_TM_DIG_37, TM_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DIG_37, FORCE_COM_DETECT_THRESH, 4, 1)
    FIELD(L1_TM_DIG_37, COM_DET_THRESH_VAL_1, 0, 4)
REG32(L1_TM_LFPS_1, 0x5800)
    FIELD(L1_TM_LFPS_1, TM_LFPS_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_LFPS_1, PROG_REFP, 4, 4)
    FIELD(L1_TM_LFPS_1, PROG_REFM, 0, 4)
REG32(L1_TM_LFPS_2, 0x5804)
    FIELD(L1_TM_LFPS_2, TM_LFPS_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_LFPS_2, PROG_VCM, 4, 3)
    FIELD(L1_TM_LFPS_2, PROG_FILTER_CAP, 0, 4)
REG32(L1_TM_LFPS_3, 0x5808)
    FIELD(L1_TM_LFPS_3, TM_LFPS_3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_LFPS_3, PROG_C2, 5, 3)
    FIELD(L1_TM_LFPS_3, PROG_C1, 2, 3)
    FIELD(L1_TM_LFPS_3, PROG_PADINTF, 0, 2)
REG32(L1_TM_LFPS_4, 0x580c)
    FIELD(L1_TM_LFPS_4, TM_LFPS_4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_LFPS_4, TESTBIT, 0, 6)
REG32(L1_TM_RXPMA_1, 0x5810)
    FIELD(L1_TM_RXPMA_1, TM_RXPMA_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_RXPMA_1, UPHY_TESTBIT, 0, 8)
REG32(L1_TM_BSCAN_1, 0x5814)
    FIELD(L1_TM_BSCAN_1, TM_BSCAN_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BSCAN_1, BSCAN_LPF_RES, 0, 3)
REG32(L1_TM_MPHY_SQ_1, 0x5818)
    FIELD(L1_TM_MPHY_SQ_1, TM_MPHY_SQ_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MPHY_SQ_1, TB_REDUCE_OFFSET, 4, 1)
    FIELD(L1_TM_MPHY_SQ_1, TB_INCREASE_OFFSET, 3, 1)
    FIELD(L1_TM_MPHY_SQ_1, TB_DRIVE_RES_SEL, 1, 2)
    FIELD(L1_TM_MPHY_SQ_1, TB_BYPASS_HYST, 0, 1)
REG32(L1_TM_LSRX_1, 0x581c)
    FIELD(L1_TM_LSRX_1, TM_LSRX_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_LSRX_1, LSRX_TESTBITS_0, 0, 8)
REG32(L1_TM_LSRX_2, 0x5820)
    FIELD(L1_TM_LSRX_2, TM_LSRX_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_LSRX_2, LSRX_TESTBITS_1, 0, 6)
REG32(L1_TM_SIGDET_1, 0x5824)
    FIELD(L1_TM_SIGDET_1, TM_SIGDET_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SIGDET_1, BIASTRIM, 4, 3)
    FIELD(L1_TM_SIGDET_1, RELIABPROT, 2, 2)
    FIELD(L1_TM_SIGDET_1, STRESSPORT, 0, 2)
REG32(L1_TM_SIGDET_2, 0x5828)
    FIELD(L1_TM_SIGDET_2, TM_SIGDET_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SIGDET_2, VSENSETRIM, 0, 8)
REG32(L1_TM_DFT_1, 0x582c)
    FIELD(L1_TM_DFT_1, TM_DFT_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_1, LFPS_DFT_SEL_P, 4, 4)
    FIELD(L1_TM_DFT_1, LFPS_DFT_ENABLE, 3, 1)
REG32(L1_TM_DFT_2, 0x5830)
    FIELD(L1_TM_DFT_2, TM_DFT_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_2, SIGDET_DFT_SEL_P, 0, 3)
REG32(L1_TM_DFT_3, 0x5834)
    FIELD(L1_TM_DFT_3, TM_DFT_3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_3, BSCAN_DFT_ENABLE, 4, 1)
    FIELD(L1_TM_DFT_3, BSCAN_DFT_SEL_P, 0, 4)
REG32(L1_TM_DFT_4, 0x5838)
    FIELD(L1_TM_DFT_4, TM_DFT_4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_4, IQPI_DFT_ENABLE, 1, 1)
    FIELD(L1_TM_DFT_4, EPI_DFT_ENABLE, 0, 1)
REG32(L1_TM_DFT_5, 0x583c)
    FIELD(L1_TM_DFT_5, TM_DFT_5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_5, IQPI_DFT_SEL, 0, 8)
REG32(L1_TM_DFT_6, 0x5840)
    FIELD(L1_TM_DFT_6, TM_DFT_6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_6, EPI_DFT_SEL, 0, 8)
REG32(L1_TM_DFT_7, 0x5844)
    FIELD(L1_TM_DFT_7, TM_DFT_7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_7, EQ_DFT_ENABLE, 4, 1)
    FIELD(L1_TM_DFT_7, EQ_DFT_SEL_P, 0, 4)
REG32(L1_TM_DFT_8, 0x5848)
    FIELD(L1_TM_DFT_8, TM_DFT_8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_8, LSRX_DFT_ENABLE, 4, 1)
    FIELD(L1_TM_DFT_8, LSRX_DFT_SEL_P, 0, 4)
REG32(L1_TM_DFT_9, 0x584c)
    FIELD(L1_TM_DFT_9, TM_DFT_9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_9, SAMP_DFT_SEL_P_0, 0, 8)
REG32(L1_TM_DFT_10, 0x5850)
    FIELD(L1_TM_DFT_10, TM_DFT_10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_DFT_10, CLKLANE_DFT_SEL, 2, 2)
    FIELD(L1_TM_DFT_10, SAMP_DFT_SEL_P_1, 0, 2)
REG32(L1_TM_BG_1, 0x5854)
    FIELD(L1_TM_BG_1, TM_BG_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_1, BIASGEN_CURRENT_PROG_0, 0, 8)
REG32(L1_TM_BG_2, 0x5858)
    FIELD(L1_TM_BG_2, TM_BG_2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_2, BIASGEN_CURRENT_PROG_1, 0, 8)
REG32(L1_TM_BG_3, 0x585c)
    FIELD(L1_TM_BG_3, TM_BG_3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_3, BIASGEN_CURRENT_PROG_2, 0, 8)
REG32(L1_TM_BG_4, 0x5860)
    FIELD(L1_TM_BG_4, TM_BG_4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_4, BIASGEN_CURRENT_PROG_3, 0, 8)
REG32(L1_TM_BG_5, 0x5864)
    FIELD(L1_TM_BG_5, TM_BG_5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_5, BIASGEN_CURRENT_PROG_4, 0, 8)
REG32(L1_TM_BG_6, 0x5868)
    FIELD(L1_TM_BG_6, TM_BG_6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_6, BIASGEN_CURRENT_PROG_5, 0, 8)
REG32(L1_TM_BG_7, 0x586c)
    FIELD(L1_TM_BG_7, TM_BG_7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_7, BIASGEN_CURRENT_PROG_6, 0, 8)
REG32(L1_TM_BG_8, 0x5870)
    FIELD(L1_TM_BG_8, TM_BG_8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_8, BIASGEN_CURRENT_PROG_7, 0, 8)
REG32(L1_TM_BG_9, 0x5874)
    FIELD(L1_TM_BG_9, TM_BG_9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_9, BIASGEN_CURRENT_PROG_8, 0, 8)
REG32(L1_TM_BG_10, 0x5878)
    FIELD(L1_TM_BG_10, TM_BG_10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_BG_10, BIASGEN_CURRENT_PROG_9, 0, 8)
REG32(L1_TM_SD0, 0x587c)
    FIELD(L1_TM_SD0, TM_SD0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD0, SD_CAL_OVERRIDE_CODE, 2, 6)
    FIELD(L1_TM_SD0, SD_CAL_OVERRIDE_EN, 1, 1)
    FIELD(L1_TM_SD0, SD_CAL_DIR, 0, 1)
REG32(L1_TM_SD1, 0x5880)
    FIELD(L1_TM_SD1, TM_SD1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD1, SD_BYPASS_ANA_CAL_EN_VAL, 7, 1)
    FIELD(L1_TM_SD1, SD_BYPASS_ANA_CAL_EN, 6, 1)
    FIELD(L1_TM_SD1, SD_CAL_CODE_START, 0, 6)
REG32(L1_TM_SD2, 0x5884)
    FIELD(L1_TM_SD2, TM_SD2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD2, SD_CAL_FORCE_CAL, 7, 1)
    FIELD(L1_TM_SD2, SD_CAL_CODE_TUNE_BYP, 6, 1)
    FIELD(L1_TM_SD2, SD_CAL_CODE_TUNE, 0, 6)
REG32(L1_TM_SD3, 0x5888)
    FIELD(L1_TM_SD3, TM_SD3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD3, SD_CAL_ITER_WAIT_0, 0, 8)
REG32(L1_TM_SD4, 0x588c)
    FIELD(L1_TM_SD4, TM_SD4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD4, SD_CAL_ITER_WAIT_BYPASS, 4, 1)
    FIELD(L1_TM_SD4, SD_CAL_ITER_WAIT_1, 0, 4)
REG32(L1_TM_SD5, 0x5890)
    FIELD(L1_TM_SD5, TM_SD5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD5, SD_CAL_INIT_WAIT_0, 0, 8)
REG32(L1_TM_SD6, 0x5894)
    FIELD(L1_TM_SD6, TM_SD6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD6, SD_CAL_INIT_WAIT_BYPASS, 4, 1)
    FIELD(L1_TM_SD6, SD_CAL_INIT_WAIT_1, 0, 4)
REG32(L1_TM_MISC1, 0x5898)
    FIELD(L1_TM_MISC1, TM_MISC1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MISC1, HSRX_POLARITY_FLIP, 7, 1)
    FIELD(L1_TM_MISC1, RXTERM_BIAS_PROG, 3, 4)
    FIELD(L1_TM_MISC1, LSRX_OR_SYS_POLARITY_FLIP, 2, 1)
    FIELD(L1_TM_MISC1, FORCE_SATAG1_DCC_MODE, 1, 1)
    FIELD(L1_TM_MISC1, SATAG1_DCC_MODE_VAL, 0, 1)
REG32(L1_TM_MISC2, 0x589c)
    FIELD(L1_TM_MISC2, TM_MISC2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MISC2, ILL_CAL_BYPASS_COUNTS, 7, 1)
    FIELD(L1_TM_MISC2, PWR_SEQ_SAMP_CAL_ALWAYS, 6, 1)
    FIELD(L1_TM_MISC2, PWR_SEQ_BYP_CAL_DONE, 5, 1)
    FIELD(L1_TM_MISC2, PWR_SEQ_BYP_CAL_DONE_VAL, 4, 1)
    FIELD(L1_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ, 3, 1)
    FIELD(L1_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ_VAL, 2, 1)
    FIELD(L1_TM_MISC2, UNUSED, 0, 2)
REG32(L1_TM_EYE_SURF0, 0x58a0)
    FIELD(L1_TM_EYE_SURF0, TM_EYE_SURF0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF0, UNUSED, 7, 1)
    FIELD(L1_TM_EYE_SURF0, EYE_SURF_RUN, 6, 1)
    FIELD(L1_TM_EYE_SURF0, COORD_EW_DIR, 5, 1)
    FIELD(L1_TM_EYE_SURF0, COORD_EW_OFFSET, 0, 5)
REG32(L1_TM_EYE_SURF1, 0x58a4)
    FIELD(L1_TM_EYE_SURF1, TM_EYE_SURF1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF1, COORD_NS_DIR, 7, 1)
    FIELD(L1_TM_EYE_SURF1, COORD_NS_OFFSET, 0, 7)
REG32(L1_TM_EYE_SURF2, 0x58a8)
    FIELD(L1_TM_EYE_SURF2, TM_EYE_SURF2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF2, TIMER_DELAY_TIME0, 0, 8)
REG32(L1_TM_EYE_SURF3, 0x58ac)
    FIELD(L1_TM_EYE_SURF3, TM_EYE_SURF3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF3, TIMER_DELAY_TIME1, 0, 8)
REG32(L1_TM_EYE_SURF4, 0x58b0)
    FIELD(L1_TM_EYE_SURF4, TM_EYE_SURF4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF4, TIMER_DELAY_TIME2, 0, 8)
REG32(L1_TM_EYE_SURF5, 0x58b4)
    FIELD(L1_TM_EYE_SURF5, TM_EYE_SURF5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF5, TIMER_DELAY_TIME3, 0, 8)
REG32(L1_TM_EYE_SURF6, 0x58b8)
    FIELD(L1_TM_EYE_SURF6, TM_EYE_SURF6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF6, TIMER_TEST_TIME0, 0, 8)
REG32(L1_TM_EYE_SURF7, 0x58bc)
    FIELD(L1_TM_EYE_SURF7, TM_EYE_SURF7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF7, TIMER_TEST_TIME1, 0, 8)
REG32(L1_TM_EYE_SURF8, 0x58c0)
    FIELD(L1_TM_EYE_SURF8, TM_EYE_SURF8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF8, TIMER_TEST_TIME2, 0, 8)
REG32(L1_TM_EYE_SURF9, 0x58c4)
    FIELD(L1_TM_EYE_SURF9, TM_EYE_SURF9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYE_SURF9, TIMER_TEST_TIME3, 0, 8)
REG32(L1_TM_SPARE, 0x58c8)
    FIELD(L1_TM_SPARE, TM_SPARE_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SPARE, RXDA_SPARE_PORT, 0, 8)
REG32(L1_TM_ANA_EQ1, 0x58cc)
    FIELD(L1_TM_ANA_EQ1, TM_ANA_EQ1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_EQ1, UNUSED, 5, 3)
    FIELD(L1_TM_ANA_EQ1, EQ_INPUT_CM_PROG, 2, 3)
    FIELD(L1_TM_ANA_EQ1, EQ_PADINTF_HQ_PROG, 0, 2)
REG32(L1_TM_ANA_E_PI0, 0x58d0)
    FIELD(L1_TM_ANA_E_PI0, TM_ANA_E_PI0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_E_PI0, EPI_BIASTRIM, 5, 3)
    FIELD(L1_TM_ANA_E_PI0, UNUSED, 0, 5)
REG32(L1_TM_ANA_IQ_PI0, 0x58d4)
    FIELD(L1_TM_ANA_IQ_PI0, TM_ANA_IQ_PI0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_IQ_PI0, IQPI_BIASTRIM, 5, 3)
    FIELD(L1_TM_ANA_IQ_PI0, UNUSED, 0, 5)
REG32(L1_TM_ANA_MISC0, 0x58d8)
    FIELD(L1_TM_ANA_MISC0, TM_ANA_MISC0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ANA_MISC0, EPI_CALIB_EN, 7, 1)
    FIELD(L1_TM_ANA_MISC0, IQPI_CALIB_EN, 6, 1)
    FIELD(L1_TM_ANA_MISC0, UNUSED, 0, 6)
REG32(L1_TM_SAMP_CODE_IQ_PH0, 0x58dc)
    FIELD(L1_TM_SAMP_CODE_IQ_PH0, TM_SAMP_CODE_IQ_PH0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_CODE_IQ_PH0, UNUSED, 7, 1)
    FIELD(L1_TM_SAMP_CODE_IQ_PH0, SAMP_CALIB_BYP, 6, 1)
    FIELD(L1_TM_SAMP_CODE_IQ_PH0, IQ_PH0_SAMP_CODE, 0, 6)
REG32(L1_TM_SAMP_CODE_IQ_PH90, 0x58e0)
    FIELD(L1_TM_SAMP_CODE_IQ_PH90, TM_SAMP_CODE_IQ_PH90_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_CODE_IQ_PH90, CALIB_SWEEP_DIR, 6, 2)
    FIELD(L1_TM_SAMP_CODE_IQ_PH90, IQ_PH90_SAMP_CODE, 0, 6)
REG32(L1_TM_SAMP_CODE_IQ_PH180, 0x58e4)
    FIELD(L1_TM_SAMP_CODE_IQ_PH180, TM_SAMP_CODE_IQ_PH180_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_CODE_IQ_PH180, UNUSED, 6, 2)
    FIELD(L1_TM_SAMP_CODE_IQ_PH180, IQ_PH180_SAMP_CODE, 0, 6)
REG32(L1_TM_SAMP_CODE_IQ_PH270, 0x58e8)
    FIELD(L1_TM_SAMP_CODE_IQ_PH270, TM_SAMP_CODE_IQ_PH270_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_CODE_IQ_PH270, HSRX_DBG_BUS_SEL, 6, 2)
    FIELD(L1_TM_SAMP_CODE_IQ_PH270, IQ_PH270_SAMP_CODE, 0, 6)
REG32(L1_TM_SAMP_CODE_E_PH0, 0x58ec)
    FIELD(L1_TM_SAMP_CODE_E_PH0, TM_SAMP_CODE_E_PH0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_CODE_E_PH0, UNUSED, 6, 2)
    FIELD(L1_TM_SAMP_CODE_E_PH0, E_PH90_SAMP_CODE, 0, 6)
REG32(L1_TM_SAMP_CODE_E_PH180, 0x58f0)
    FIELD(L1_TM_SAMP_CODE_E_PH180, TM_SAMP_CODE_E_PH180_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_CODE_E_PH180, UNUSED, 6, 2)
    FIELD(L1_TM_SAMP_CODE_E_PH180, E_PH270_SAMP_CODE, 0, 6)
REG32(L1_TM_IQ_ILL0, 0x58f4)
    FIELD(L1_TM_IQ_ILL0, TM_IQ_ILL0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL0, ILL_BYPASS_IQ_CAL_EN, 7, 1)
    FIELD(L1_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L1_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L1_TM_IQ_ILL0, ILL_BYPASS_IQ_CODES, 0, 1)
REG32(L1_TM_IQ_ILL1, 0x58f8)
    FIELD(L1_TM_IQ_ILL1, TM_IQ_ILL1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL1, ILL_BYPASS_IQ_CALCODE_F0, 0, 8)
REG32(L1_TM_IQ_ILL2, 0x58fc)
    FIELD(L1_TM_IQ_ILL2, TM_IQ_ILL2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL2, ILL_BYPASS_IQ_CALCODE_F1, 0, 8)
REG32(L1_TM_IQ_ILL3, 0x5900)
    FIELD(L1_TM_IQ_ILL3, TM_IQ_ILL3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL3, ILL_BYPASS_IQ_CALCODE_F2, 0, 8)
REG32(L1_TM_IQ_ILL4, 0x5904)
    FIELD(L1_TM_IQ_ILL4, TM_IQ_ILL4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL4, ILL_BYPASS_IQ_CALCODE_F3, 0, 8)
REG32(L1_TM_IQ_ILL5, 0x5908)
    FIELD(L1_TM_IQ_ILL5, TM_IQ_ILL5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL5, ILL_BYPASS_IQ_CALCODE_F4, 0, 8)
REG32(L1_TM_IQ_ILL6, 0x590c)
    FIELD(L1_TM_IQ_ILL6, TM_IQ_ILL6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL6, ILL_BYPASS_IQ_CALCODE_F5, 0, 8)
REG32(L1_TM_IQ_ILL7, 0x5910)
    FIELD(L1_TM_IQ_ILL7, TM_IQ_ILL7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL7, ILL_BYPASS_IQ_CNSTGMTRIM_VAL, 0, 8)
REG32(L1_TM_IQ_ILL8, 0x5914)
    FIELD(L1_TM_IQ_ILL8, TM_IQ_ILL8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL8, ILL_BYPASS_IQ_POLYTRIM_VAL, 0, 8)
REG32(L1_TM_IQ_ILL9, 0x5918)
    FIELD(L1_TM_IQ_ILL9, TM_IQ_ILL9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL9, UNUSED, 4, 4)
    FIELD(L1_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN, 3, 1)
    FIELD(L1_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN_VAL, 2, 1)
    FIELD(L1_TM_IQ_ILL9, ILL_BYPASS_IQ_CNSTGMTRIM, 1, 1)
    FIELD(L1_TM_IQ_ILL9, ILL_BYPASS_IQ_POLYTIM, 0, 1)
REG32(L1_TM_IQ_ILL10, 0x591c)
    FIELD(L1_TM_IQ_ILL10, TM_IQ_ILL10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_IQ_ILL10, UNUSED, 6, 2)
    FIELD(L1_TM_IQ_ILL10, IQPI_CALCTRIM, 4, 2)
    FIELD(L1_TM_IQ_ILL10, IQPI_REPLICATRIM, 0, 4)
REG32(L1_TM_E_ILL0, 0x5920)
    FIELD(L1_TM_E_ILL0, TM_E_ILL0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL0, E_ILL_CALIB_CTRL, 7, 1)
    FIELD(L1_TM_E_ILL0, E_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L1_TM_E_ILL0, E_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L1_TM_E_ILL0, E_ILL_CALIB_BYP, 0, 1)
REG32(L1_TM_E_ILL1, 0x5924)
    FIELD(L1_TM_E_ILL1, TM_E_ILL1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL1, ILL_BYPASS_E_CALCODE_F0, 0, 8)
REG32(L1_TM_E_ILL2, 0x5928)
    FIELD(L1_TM_E_ILL2, TM_E_ILL2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL2, ILL_BYPASS_E_CALCODE_F1, 0, 8)
REG32(L1_TM_E_ILL3, 0x592c)
    FIELD(L1_TM_E_ILL3, TM_E_ILL3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL3, ILL_BYPASS_E_CALCODE_F2, 0, 8)
REG32(L1_TM_E_ILL4, 0x5930)
    FIELD(L1_TM_E_ILL4, TM_E_ILL4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL4, ILL_BYPASS_E_CALCODE_F3, 0, 8)
REG32(L1_TM_E_ILL5, 0x5934)
    FIELD(L1_TM_E_ILL5, TM_E_ILL5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL5, ILL_BYPASS_E_CALCODE_F4, 0, 8)
REG32(L1_TM_E_ILL6, 0x5938)
    FIELD(L1_TM_E_ILL6, TM_E_ILL6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL6, ILL_BYPASS_E_CALCODE_F5, 0, 8)
REG32(L1_TM_E_ILL7, 0x593c)
    FIELD(L1_TM_E_ILL7, TM_E_ILL7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL7, ILL_BYPASS_E_CNSTGMTRIM_VAL, 0, 8)
REG32(L1_TM_E_ILL8, 0x5940)
    FIELD(L1_TM_E_ILL8, TM_E_ILL8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL8, ILL_BYPASS_E_POLYTRIM_VAL, 0, 8)
REG32(L1_TM_E_ILL9, 0x5944)
    FIELD(L1_TM_E_ILL9, TM_E_ILL9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL9, UNUSED, 4, 4)
    FIELD(L1_TM_E_ILL9, ILL_BYPASS_E_LFEN, 3, 1)
    FIELD(L1_TM_E_ILL9, ILL_BYPASS_E_LFEN_VAL, 2, 1)
    FIELD(L1_TM_E_ILL9, ILL_BYPASS_E_CNSTGMTRIM, 1, 1)
    FIELD(L1_TM_E_ILL9, ILL_BYPASS_E_POLYTIM, 0, 1)
REG32(L1_TM_E_ILL10, 0x5948)
    FIELD(L1_TM_E_ILL10, TM_E_ILL10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_E_ILL10, UNUSED, 6, 2)
    FIELD(L1_TM_E_ILL10, EPI_CALCTRIM, 4, 2)
    FIELD(L1_TM_E_ILL10, EPI_REPLICATRIM, 0, 4)
REG32(L1_TM_EQ0, 0x594c)
    FIELD(L1_TM_EQ0, TM_EQ0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ0, EQ_STG1_RL_PROG_MSB, 7, 1)
    FIELD(L1_TM_EQ0, EQ_STG1_CTRL_BYP, 6, 1)
    FIELD(L1_TM_EQ0, EQ_STG2_CTRL_BYP, 5, 1)
    FIELD(L1_TM_EQ0, EQ_ADAPTATION_FORCE, 4, 1)
    FIELD(L1_TM_EQ0, EQ_ADAPTATION_FORCE_VAL, 3, 1)
    FIELD(L1_TM_EQ0, EQ_ISOURCE_EN_VAL, 0, 3)
REG32(L1_TM_EQ1, 0x5950)
    FIELD(L1_TM_EQ1, TM_EQ1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ1, EQ_STG1_PREAMP_MODE_VAL, 7, 1)
    FIELD(L1_TM_EQ1, EQ_STG1_RL_PROG, 5, 2)
    FIELD(L1_TM_EQ1, EQ_STG2_CM_PROG, 3, 2)
    FIELD(L1_TM_EQ1, EQ_STG2_PREAMP_MODE_VAL, 2, 1)
    FIELD(L1_TM_EQ1, EQ_STG2_RL_PROG, 0, 2)
REG32(L1_TM_EQ2, 0x5954)
    FIELD(L1_TM_EQ2, TM_EQ2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ2, UNUSED, 7, 1)
    FIELD(L1_TM_EQ2, EQ_EN_BACKGND_ADAPT, 6, 1)
    FIELD(L1_TM_EQ2, EQ_COUNT_STRAYS, 5, 1)
    FIELD(L1_TM_EQ2, EQ_WINDOW_SIZE, 3, 2)
    FIELD(L1_TM_EQ2, EQ_MAJ_THRESH, 1, 2)
    FIELD(L1_TM_EQ2, EQ_BIAS_CTRL_BYP, 0, 1)
REG32(L1_TM_EQ3, 0x5958)
    FIELD(L1_TM_EQ3, TM_EQ3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ3, UNUSED, 5, 3)
    FIELD(L1_TM_EQ3, EQ_BYPASS_ISINK_ENZ_VAL, 0, 5)
REG32(L1_TM_EQ4, 0x595c)
    FIELD(L1_TM_EQ4, TM_EQ4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ4, UNUSED, 5, 3)
    FIELD(L1_TM_EQ4, BYPASS_EQ_C_STG1, 4, 1)
    FIELD(L1_TM_EQ4, BYPASS_EQ_C_VAL_STG1, 0, 4)
REG32(L1_TM_EQ5, 0x5960)
    FIELD(L1_TM_EQ5, TM_EQ5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ5, UNUSED, 6, 2)
    FIELD(L1_TM_EQ5, BYPASS_EQ_R_STG1, 5, 1)
    FIELD(L1_TM_EQ5, BYPASS_EQ_R_VAL_STG1, 0, 5)
REG32(L1_TM_EQ6, 0x5964)
    FIELD(L1_TM_EQ6, TM_EQ6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ6, UNUSED, 5, 3)
    FIELD(L1_TM_EQ6, BYPASS_EQ_C_STG2, 4, 1)
    FIELD(L1_TM_EQ6, BYPASS_EQ_C_VAL_STG2, 0, 4)
REG32(L1_TM_EQ7, 0x5968)
    FIELD(L1_TM_EQ7, TM_EQ7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ7, UNUSED, 6, 2)
    FIELD(L1_TM_EQ7, BYPASS_EQ_R_STG2, 5, 1)
    FIELD(L1_TM_EQ7, BYPASS_EQ_R_VAL_STG2, 0, 5)
REG32(L1_TM_EQ8, 0x596c)
    FIELD(L1_TM_EQ8, TM_EQ8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ8, EQ_BYPASS_CALIB, 7, 1)
    FIELD(L1_TM_EQ8, EQ_SWEEP, 5, 2)
    FIELD(L1_TM_EQ8, SEL_SAMP, 2, 3)
    FIELD(L1_TM_EQ8, BYPASS_EQ_CAL, 1, 1)
    FIELD(L1_TM_EQ8, BYPASS_EQ_CAL_VAL, 0, 1)
REG32(L1_TM_EQ9, 0x5970)
    FIELD(L1_TM_EQ9, TM_EQ9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ9, UNUSED, 7, 1)
    FIELD(L1_TM_EQ9, EQ_BYPASS_CALIB_CODE, 0, 7)
REG32(L1_TM_EQ10, 0x5974)
    FIELD(L1_TM_EQ10, TM_EQ10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ10, UNUSED, 7, 1)
    FIELD(L1_TM_EQ10, OFFSET_COEF_SCALER, 4, 3)
    FIELD(L1_TM_EQ10, DIAG_OUTPUT_SEL, 0, 4)
REG32(L1_TM_EQ11, 0x5978)
    FIELD(L1_TM_EQ11, TM_EQ11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ11, EQ_CALIB_CLK_DIV_FORCE, 7, 1)
    FIELD(L1_TM_EQ11, EDGE_IS_FIRST, 6, 1)
    FIELD(L1_TM_EQ11, FORCE_EQ_OFFS_ON, 5, 1)
    FIELD(L1_TM_EQ11, FORCE_EQ_OFFS_OFF, 4, 1)
    FIELD(L1_TM_EQ11, EQ_OFFS_WITH_ADAPT, 3, 1)
    FIELD(L1_TM_EQ11, OFFSET_VOTER_OVERRIDE_EN, 2, 1)
    FIELD(L1_TM_EQ11, OFFSET_VOTER_OVERRIDE_NEG, 1, 1)
    FIELD(L1_TM_EQ11, OFFSET_VOTER_OVERRIDE_POS, 0, 1)
REG32(L1_TM_ILL7, 0x597c)
    FIELD(L1_TM_ILL7, TM_ILL7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL7, ILL_CAL_INIT_WAIT, 0, 8)
REG32(L1_TM_ILL8, 0x5980)
    FIELD(L1_TM_ILL8, TM_ILL8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL8, ILL_CAL_ITER_WAIT, 0, 8)
REG32(L1_TM_ILL9, 0x5984)
    FIELD(L1_TM_ILL9, TM_ILL9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL9, ILL_CAL_BYPASS_CAP_START, 7, 1)
    FIELD(L1_TM_ILL9, ILL_CAL_CAP_START_VAL, 0, 7)
REG32(L1_TM_ILL10, 0x5988)
    FIELD(L1_TM_ILL10, TM_ILL10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL10, G3A_USB3_PCIEG2_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L1_TM_ILL10, G3B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L1_TM_ILL11, 0x598c)
    FIELD(L1_TM_ILL11, TM_ILL11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL11, G2A_PCIEG1_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L1_TM_ILL11, G2B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L1_TM_ILL12, 0x5990)
    FIELD(L1_TM_ILL12, TM_ILL12_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL12, G1A_PLL_CTR_BYP_VAL, 0, 8)
REG32(L1_TM_ILL13, 0x5994)
    FIELD(L1_TM_ILL13, TM_ILL13_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL13, ILL_CAL_IDLE_VAL_REFCNT, 0, 3)
REG32(L1_TM_ILL14, 0x5998)
    FIELD(L1_TM_ILL14, TM_ILL14_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL14, ILL_CALIB_WAIT, 4, 4)
    FIELD(L1_TM_ILL14, ILL_CHG_WAIT, 0, 4)
REG32(L1_TM_FRZ_FSM0, 0x599c)
    FIELD(L1_TM_FRZ_FSM0, TM_FRZ_FSM0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_FRZ_FSM0, FREEZE_HSRX_PWR_SEQ_FSM, 0, 8)
REG32(L1_TM_FRZ_FSM1, 0x59a0)
    FIELD(L1_TM_FRZ_FSM1, TM_FRZ_FSM1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_FRZ_FSM1, UNUSED, 6, 2)
    FIELD(L1_TM_FRZ_FSM1, FREEZE_ILL_CALIB_FSM, 0, 6)
REG32(L1_TM_RST_DLY, 0x59a4)
    FIELD(L1_TM_RST_DLY, TM_RST_DLY_31_8_RSVD, 24, 8)
    FIELD(L1_TM_RST_DLY, APB_RST_DLY, 0, 8)
REG32(L1_TM_ILL15, 0x59a8)
    FIELD(L1_TM_ILL15, TM_ILL15_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL15, ILL_CAL_REF_CTR_MSB_REG1, 0, 8)
REG32(L1_TM_MISC3, 0x59ac)
    FIELD(L1_TM_MISC3, TM_MISC3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MISC3, AUX0_BIT_7, 7, 1)
    FIELD(L1_TM_MISC3, AUX0_BIT_6, 6, 1)
    FIELD(L1_TM_MISC3, AUX0_BIT_5, 5, 1)
    FIELD(L1_TM_MISC3, DBG_BUS_SEL, 2, 3)
    FIELD(L1_TM_MISC3, CDR_EN_FPL, 1, 1)
    FIELD(L1_TM_MISC3, CDR_EN_FFL, 0, 1)
REG32(L1_TM_EQ_OFFS1, 0x59b0)
    FIELD(L1_TM_EQ_OFFS1, TM_EQ_OFFS1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ_OFFS1, EQ_OFFSET_CORR_BYP, 1, 7)
    FIELD(L1_TM_EQ_OFFS1, AUX1_BIT_7, 0, 1)
REG32(L1_TM_SAMP0, 0x59b4)
    FIELD(L1_TM_SAMP0, TM_SAMP0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP0, SAMP_CALIB_CLK_DIV_FACTOR, 1, 7)
    FIELD(L1_TM_SAMP0, SAMP_CALIB_CLK_DIV_FORCE, 0, 1)
REG32(L1_TM_EQ12, 0x59b8)
    FIELD(L1_TM_EQ12, TM_EQ12_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ12, EQ_CALIB_CLK_DIV_FACTOR, 0, 8)
REG32(L1_TM_MISC4, 0x59bc)
    FIELD(L1_TM_MISC4, TM_MISC4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MISC4, PSO_CLK_LANE_FRM_PCS, 2, 1)
    FIELD(L1_TM_MISC4, BSCAN_MODE_VAL, 1, 1)
    FIELD(L1_TM_MISC4, BSCAN_FORCE_MODE, 0, 1)
REG32(L1_TM_SAMP_STATUS0, 0x5a80)
    FIELD(L1_TM_SAMP_STATUS0, TM_SAMP_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_STATUS0, IQ_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L1_TM_SAMP_STATUS1, 0x5a84)
    FIELD(L1_TM_SAMP_STATUS1, TM_SAMP_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_STATUS1, IQ_SAMP_PH90_CALIB_CODE, 0, 6)
REG32(L1_TM_SAMP_STATUS2, 0x5a88)
    FIELD(L1_TM_SAMP_STATUS2, TM_SAMP_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_STATUS2, IQ_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L1_TM_SAMP_STATUS3, 0x5a8c)
    FIELD(L1_TM_SAMP_STATUS3, TM_SAMP_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_STATUS3, IQ_SAMP_PH270_CALIB_CODE, 0, 6)
REG32(L1_TM_SAMP_STATUS4, 0x5a90)
    FIELD(L1_TM_SAMP_STATUS4, TM_SAMP_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_STATUS4, E_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L1_TM_SAMP_STATUS5, 0x5a94)
    FIELD(L1_TM_SAMP_STATUS5, TM_SAMP_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SAMP_STATUS5, E_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L1_TM_ILL_STATUS0, 0x5a98)
    FIELD(L1_TM_ILL_STATUS0, TM_ILL_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS0, IQ_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS1, 0x5a9c)
    FIELD(L1_TM_ILL_STATUS1, TM_ILL_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS1, IQ_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS2, 0x5aa0)
    FIELD(L1_TM_ILL_STATUS2, TM_ILL_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS2, IQ_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS3, 0x5aa4)
    FIELD(L1_TM_ILL_STATUS3, TM_ILL_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS3, IQ_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS4, 0x5aa8)
    FIELD(L1_TM_ILL_STATUS4, TM_ILL_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS4, IQ_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS5, 0x5aac)
    FIELD(L1_TM_ILL_STATUS5, TM_ILL_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS5, IQ_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS6, 0x5ab0)
    FIELD(L1_TM_ILL_STATUS6, TM_ILL_STATUS6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS6, E_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS7, 0x5ab4)
    FIELD(L1_TM_ILL_STATUS7, TM_ILL_STATUS7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS7, E_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS8, 0x5ab8)
    FIELD(L1_TM_ILL_STATUS8, TM_ILL_STATUS8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS8, E_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS9, 0x5abc)
    FIELD(L1_TM_ILL_STATUS9, TM_ILL_STATUS9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS9, E_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS10, 0x5ac0)
    FIELD(L1_TM_ILL_STATUS10, TM_ILL_STATUS10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS10, E_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_ILL_STATUS11, 0x5ac4)
    FIELD(L1_TM_ILL_STATUS11, TM_ILL_STATUS11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_ILL_STATUS11, E_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L1_TM_MISC_ST_0, 0x5ac8)
    FIELD(L1_TM_MISC_ST_0, TM_MISC_ST_0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MISC_ST_0, EYE_SURF_DONE, 5, 1)
    FIELD(L1_TM_MISC_ST_0, SD_CAL_DONE, 4, 1)
    FIELD(L1_TM_MISC_ST_0, SAMP_CAL_DONE, 3, 1)
    FIELD(L1_TM_MISC_ST_0, ILL_CAL_DONE, 2, 1)
    FIELD(L1_TM_MISC_ST_0, EQ_CAL_DONE, 1, 1)
    FIELD(L1_TM_MISC_ST_0, EQ_VALID_ADAPT_CODE, 0, 1)
REG32(L1_TM_SD_ST_0, 0x5acc)
    FIELD(L1_TM_SD_ST_0, TM_SD_ST_0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_SD_ST_0, SD_CAL_CODE, 0, 6)
REG32(L1_TM_EYESURF_ST0, 0x5ad0)
    FIELD(L1_TM_EYESURF_ST0, TM_EYESURF_ST0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYESURF_ST0, ERROR_COUNT0, 0, 8)
REG32(L1_TM_EYESURF_ST1, 0x5ad4)
    FIELD(L1_TM_EYESURF_ST1, TM_EYESURF_ST1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EYESURF_ST1, ERROR_COUNT1, 0, 8)
REG32(L1_TM_EQ_ST0, 0x5ad8)
    FIELD(L1_TM_EQ_ST0, TM_EQ_ST0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ_ST0, EQ_ADAPT_CODE0, 0, 8)
REG32(L1_TM_EQ_ST1, 0x5adc)
    FIELD(L1_TM_EQ_ST1, TM_EQ_ST1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ_ST1, EQ_ADAPT_CODE1, 0, 8)
REG32(L1_TM_EQ_ST2, 0x5ae0)
    FIELD(L1_TM_EQ_ST2, TM_EQ_ST2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_EQ_ST2, EQ_CALIB_CODE, 0, 7)
REG32(L1_TM_RXPMA_ST1, 0x5ae4)
    FIELD(L1_TM_RXPMA_ST1, TM_RXPMA_ST1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_RXPMA_ST1, HSRX_OPMODE_STATUS, 0, 8)
REG32(L1_TM_CDR0, 0x5c00)
    FIELD(L1_TM_CDR0, TM_CDR0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR0, FAST_PHASE_LOCK_FORCE, 7, 1)
    FIELD(L1_TM_CDR0, UNUSED, 5, 2)
    FIELD(L1_TM_CDR0, CDR_LOOP_CTRL, 2, 3)
    FIELD(L1_TM_CDR0, SECOND_ORDER_LOOP_DIS, 1, 1)
    FIELD(L1_TM_CDR0, FIRST_ORDER_LOOP_DIS, 0, 1)
REG32(L1_TM_CDR1, 0x5c04)
    FIELD(L1_TM_CDR1, TM_CDR1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR1, RESET_DELAY_2OL, 0, 8)
REG32(L1_TM_CDR2, 0x5c08)
    FIELD(L1_TM_CDR2, TM_CDR2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR2, CLK_SEL_2OL, 6, 2)
    FIELD(L1_TM_CDR2, INTEGRATOR_THRESH_2OL, 0, 6)
REG32(L1_TM_CDR3, 0x5c0c)
    FIELD(L1_TM_CDR3, TM_CDR3_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR3, UNUSED, 7, 1)
    FIELD(L1_TM_CDR3, SIGNAL_THRESH_1OL, 0, 7)
REG32(L1_TM_CDR4, 0x5c10)
    FIELD(L1_TM_CDR4, TM_CDR4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR4, UNUSED, 7, 1)
    FIELD(L1_TM_CDR4, SIGNAL_THRESH_2OL, 0, 7)
REG32(L1_TM_CDR5, 0x5c14)
    FIELD(L1_TM_CDR5, TM_CDR5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR5, FPHL_FSM_ACC_CYCLES, 5, 3)
    FIELD(L1_TM_CDR5, FFL_PH0_INT_GAIN, 0, 5)
REG32(L1_TM_CDR6, 0x5c18)
    FIELD(L1_TM_CDR6, TM_CDR6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR6, FPHL_FSM_DELAY_CYCLES, 5, 3)
    FIELD(L1_TM_CDR6, FFL_PH1_INT_GAIN, 0, 5)
REG32(L1_TM_CDR7, 0x5c1c)
    FIELD(L1_TM_CDR7, TM_CDR7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR7, FPHL_FSM_TRIGGER1_WAIT_CYCLES, 5, 3)
    FIELD(L1_TM_CDR7, FFL_PH2_INT_GAIN, 0, 5)
REG32(L1_TM_CDR8, 0x5c20)
    FIELD(L1_TM_CDR8, TM_CDR8_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR8, FPHL_FSM_TRIGGER2_WAIT_CYCLES, 5, 3)
    FIELD(L1_TM_CDR8, FFL_PH3_INT_GAIN, 0, 5)
REG32(L1_TM_CDR9, 0x5c24)
    FIELD(L1_TM_CDR9, TM_CDR9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR9, FPHL_FSM_TRIGGER3_WAIT_CYCLES, 5, 3)
    FIELD(L1_TM_CDR9, FFL_PH4_INT_GAIN, 0, 5)
REG32(L1_TM_CDR10, 0x5c28)
    FIELD(L1_TM_CDR10, TM_CDR10_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR10, FFL_TIME_PER_PHASE_10_8, 5, 3)
    FIELD(L1_TM_CDR10, FFL_PH5_INT_GAIN, 0, 5)
REG32(L1_TM_CDR11, 0x5c2c)
    FIELD(L1_TM_CDR11, TM_CDR11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR11, UNUSED, 5, 3)
    FIELD(L1_TM_CDR11, FFL_PH6_INT_GAIN, 0, 5)
REG32(L1_TM_CDR12, 0x5c30)
    FIELD(L1_TM_CDR12, TM_CDR12_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR12, CDRLF_RESET_ON_EN_CDR, 7, 1)
    FIELD(L1_TM_CDR12, CDRLF_RESET_ON_INT_MAX_2OL, 6, 1)
    FIELD(L1_TM_CDR12, CDRLF_RESET_ON_MODE_CHG, 5, 1)
    FIELD(L1_TM_CDR12, FFL_PH7_INT_GAIN, 0, 5)
REG32(L1_TM_CDR13, 0x5c34)
    FIELD(L1_TM_CDR13, TM_CDR13_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR13, FFL_TIME_PER_PHASE_7_0, 0, 8)
REG32(L1_TM_CDR14, 0x5c38)
    FIELD(L1_TM_CDR14, TM_CDR14_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR14, FFL_PH3_POST_INT_GAIN, 6, 2)
    FIELD(L1_TM_CDR14, FFL_PH2_POST_INT_GAIN, 4, 2)
    FIELD(L1_TM_CDR14, FFL_PH1_POST_INT_GAIN, 2, 2)
    FIELD(L1_TM_CDR14, FFL_PH0_POST_INT_GAIN, 0, 2)
REG32(L1_TM_CDR15, 0x5c3c)
    FIELD(L1_TM_CDR15, TM_CDR15_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR15, FFL_PH7_POST_INT_GAIN, 6, 2)
    FIELD(L1_TM_CDR15, FFL_PH6_POST_INT_GAIN, 4, 2)
    FIELD(L1_TM_CDR15, FFL_PH5_POST_INT_GAIN, 2, 2)
    FIELD(L1_TM_CDR15, FFL_PH4_POST_INT_GAIN, 0, 2)
REG32(L1_TM_CDR16, 0x5c40)
    FIELD(L1_TM_CDR16, TM_CDR16_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR16, UNUSED, 5, 3)
    FIELD(L1_TM_CDR16, FFL_PH0_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR17, 0x5c44)
    FIELD(L1_TM_CDR17, TM_CDR17_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR17, UNUSED, 5, 3)
    FIELD(L1_TM_CDR17, FFL_PH1_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR18, 0x5c48)
    FIELD(L1_TM_CDR18, TM_CDR18_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR18, UNUSED, 5, 3)
    FIELD(L1_TM_CDR18, FFL_PH2_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR19, 0x5c4c)
    FIELD(L1_TM_CDR19, TM_CDR19_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR19, UNUSED, 5, 3)
    FIELD(L1_TM_CDR19, FFL_PH3_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR20, 0x5c50)
    FIELD(L1_TM_CDR20, TM_CDR20_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR20, UNUSED, 5, 3)
    FIELD(L1_TM_CDR20, FFL_PH4_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR21, 0x5c54)
    FIELD(L1_TM_CDR21, TM_CDR21_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR21, UNUSED, 5, 3)
    FIELD(L1_TM_CDR21, FFL_PH5_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR22, 0x5c58)
    FIELD(L1_TM_CDR22, TM_CDR22_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR22, UNUSED, 5, 3)
    FIELD(L1_TM_CDR22, FFL_PH6_PROP_GAIN, 0, 5)
REG32(L1_TM_CDR23, 0x5c5c)
    FIELD(L1_TM_CDR23, TM_CDR23_31_8_RSVD, 24, 8)
    FIELD(L1_TM_CDR23, UNUSED, 7, 1)
    FIELD(L1_TM_CDR23, PHASE_LAG_LEAD_RESPONSE, 5, 2)
    FIELD(L1_TM_CDR23, FFL_PH7_PROP_GAIN, 0, 5)
REG32(L1_TM_MISC0, 0x5c60)
    FIELD(L1_TM_MISC0, TM_MISC0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MISC0, UNUSED, 2, 6)
    FIELD(L1_TM_MISC0, DBG0_SEL, 0, 2)
REG32(L1_TM_HSRX_ST0, 0x5c64)
    FIELD(L1_TM_HSRX_ST0, TM_HSRX_ST0_31_8_RSVD, 24, 8)
    FIELD(L1_TM_HSRX_ST0, FAST_LOCK_STATUS, 0, 1)
REG32(L1_TM_PLL_LS_CLOCK, 0x6000)
    FIELD(L1_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK, 0, 8)
REG32(L1_TM_PLL_LOOP_FILT, 0x6004)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_PLL_LOOP_FILT_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_FORCE_RES_SW_ON, 7, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_HIGH_RES_SW_ON, 6, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_LOW_RES_SW_ON, 5, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_PCIE_R1_DEFAULT_RES_SW_ON, 4, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_PCIE_R1_HIGH_RES_SW_ON, 3, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_PCIE_R1_LOW_RES_SW_ON, 2, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_BYPASS_SEC_LOOP_FILTER, 1, 1)
    FIELD(L1_TM_PLL_LOOP_FILT, TM_SEC_LOOP, 0, 1)
REG32(L1_TM_PLL_DIG2, 0x6008)
    FIELD(L1_TM_PLL_DIG2, TM_PLL_DIG2_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG2, TM_FBDIV_0_LSB, 7, 1)
    FIELD(L1_TM_PLL_DIG2, TM_PLL_HS_CLOCK_0, 0, 7)
REG32(L1_TM_PLL_FBDIV, 0x600c)
    FIELD(L1_TM_PLL_FBDIV, TM_PLL_FBDIV_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_FBDIV, TM_FBDIV_1, 0, 8)
REG32(L1_TM_PLL_DIG4, 0x6010)
    FIELD(L1_TM_PLL_DIG4, TM_PLL_DIG4_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG4, TM_VCO_CLOCK_PULDN, 7, 1)
    FIELD(L1_TM_PLL_DIG4, TM_FORCE_ANA_COARSEDONE, 6, 1)
    FIELD(L1_TM_PLL_DIG4, TM_ANA_COARSEDONE, 5, 1)
    FIELD(L1_TM_PLL_DIG4, TM_FORCE_COARSE_DONE_INT, 4, 1)
    FIELD(L1_TM_PLL_DIG4, TM_COARSE_DONE_INT, 3, 1)
    FIELD(L1_TM_PLL_DIG4, TM_FORCE_FBDIV, 2, 1)
    FIELD(L1_TM_PLL_DIG4, TM_FBDIV_2, 0, 2)
REG32(L1_TM_PLL_DIG5, 0x6014)
    FIELD(L1_TM_PLL_DIG5, TM_PLL_DIG5_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG5, TM_PD_6GHZ_LOWNOISE_RING, 7, 1)
    FIELD(L1_TM_PLL_DIG5, TM_PD_6GHZ_RING, 6, 1)
    FIELD(L1_TM_PLL_DIG5, TM_COARSE_PROG, 1, 5)
    FIELD(L1_TM_PLL_DIG5, TM_FORCE_VCO_CLOCK_PULDN, 0, 1)
REG32(L1_TM_PLL_DIG6, 0x6018)
    FIELD(L1_TM_PLL_DIG6, TM_PLL_DIG6_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG6, TM_CONFG_CHNG_CYCLES_0_LSB, 7, 1)
    FIELD(L1_TM_PLL_DIG6, TM_VCO_SETTLE_CYCLES, 5, 2)
    FIELD(L1_TM_PLL_DIG6, TM_INITIAL_WAIT_CYCLES, 3, 2)
    FIELD(L1_TM_PLL_DIG6, TM_FORCE_COARSE_PROG_PD_RING, 2, 1)
    FIELD(L1_TM_PLL_DIG6, TM_PD_1P5GHZ_RING, 1, 1)
    FIELD(L1_TM_PLL_DIG6, TM_PD_3GHZ_RING, 0, 1)
REG32(L1_TM_PLL_DIG7, 0x601c)
    FIELD(L1_TM_PLL_DIG7, TM_PLL_DIG7_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG7, TM_CPUMP_CODE_0_LSB, 7, 1)
    FIELD(L1_TM_PLL_DIG7, TM_FORCE_ANA_START_LOOP, 6, 1)
    FIELD(L1_TM_PLL_DIG7, TM_ANA_START_LOOP, 5, 1)
    FIELD(L1_TM_PLL_DIG7, TM_PLL_LOCK_CYCLES, 3, 2)
    FIELD(L1_TM_PLL_DIG7, TM_STAND_BY_SETTLE_CYCLES, 1, 2)
    FIELD(L1_TM_PLL_DIG7, TM_CONFG_CHNG_CYCLES_1_MSB, 0, 1)
REG32(L1_TM_PLL_CPUMP_CODE_1, 0x6020)
    FIELD(L1_TM_PLL_CPUMP_CODE_1, TM_PLL_CPUMP_CODE_1_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_CPUMP_CODE_1, TM_CPUMP_CODE_1, 0, 8)
REG32(L1_TM_PLL_DIG9, 0x6024)
    FIELD(L1_TM_PLL_DIG9, TM_PLL_DIG9_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG9, TM_PLL_RSVD, 6, 2)
    FIELD(L1_TM_PLL_DIG9, TM_FB_BY2_BYPASS, 5, 1)
    FIELD(L1_TM_PLL_DIG9, TM_FORCE_CP_CODE, 4, 1)
    FIELD(L1_TM_PLL_DIG9, TM_CPUMP_CODE_2_MSB, 0, 4)
REG32(L1_TM_PLL_COARSE_CODE_LSB, 0x6028)
    FIELD(L1_TM_PLL_COARSE_CODE_LSB, TM_PLL_COARSE_CODE_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_COARSE_CODE_LSB, TM_COARSE_CODE_LSB, 0, 8)
REG32(L1_TM_PLL_DIG11, 0x602c)
    FIELD(L1_TM_PLL_DIG11, TM_PLL_DIG11_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG11, TM_CONST_NDAC_CNTRL, 4, 4)
    FIELD(L1_TM_PLL_DIG11, TM_FORCE_COARSE_CODE, 3, 1)
    FIELD(L1_TM_PLL_DIG11, TM_COARSE_CODE_MSB, 0, 3)
REG32(L1_TM_PLL_DIG12, 0x6030)
    FIELD(L1_TM_PLL_DIG12, TM_PLL_DIG12_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG12, TM_FORCE_PTAT_NDAC_CNTRL, 7, 1)
    FIELD(L1_TM_PLL_DIG12, TM_PTAT_NDAC_CNTRL, 1, 6)
    FIELD(L1_TM_PLL_DIG12, TM_FORCE_CONST_NDAC_CNTRL, 0, 1)
REG32(L1_TM_PLL_CONST_PMOS, 0x6034)
    FIELD(L1_TM_PLL_CONST_PMOS, TM_PLL_CONST_PMOS_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_CONST_PMOS, TM_CONST_PMOS_CNTRL, 0, 8)
REG32(L1_TM_PLL_DIG14, 0x6038)
    FIELD(L1_TM_PLL_DIG14, TM_PLL_DIG14_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG14, TM_COARSE_CODE_AFTER_V2I_0_LSB, 1, 7)
    FIELD(L1_TM_PLL_DIG14, TM_FORCE_CONST_PMOS_CNTRL, 0, 1)
REG32(L1_TM_PLL_DIG15, 0x603c)
    FIELD(L1_TM_PLL_DIG15, TM_PLL_DIG15_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG15, TM_V2I_CODE_0_LSB, 5, 3)
    FIELD(L1_TM_PLL_DIG15, TM_FORCE_COARSE_CODE_AFTER_V2I, 4, 1)
    FIELD(L1_TM_PLL_DIG15, TM_COARSE_CODE_AFTER_V2I_1_MSB, 0, 4)
REG32(L1_TM_PLL_DIG16, 0x6040)
    FIELD(L1_TM_PLL_DIG16, TM_PLL_DIG16_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG16, TM_FORCE_PLL_LOCK, 7, 1)
    FIELD(L1_TM_PLL_DIG16, TM_PLL_LOCK, 6, 1)
    FIELD(L1_TM_PLL_DIG16, TM_FORCE_SS_NO_STEPS_STEP_SIZE, 5, 1)
    FIELD(L1_TM_PLL_DIG16, TM_PLL_RSVD, 4, 1)
    FIELD(L1_TM_PLL_DIG16, TM_FORCE_V2I_CODE, 3, 1)
    FIELD(L1_TM_PLL_DIG16, TM_V2I_CODE_1_MSB, 0, 3)
REG32(L1_TM_PLL_DIG17, 0x6044)
    FIELD(L1_TM_PLL_DIG17, TM_PLL_DIG17_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG17, TM_FB_CLK, 6, 2)
    FIELD(L1_TM_PLL_DIG17, TM_MODE_DEPTH, 3, 3)
    FIELD(L1_TM_PLL_DIG17, TM_MODE_RATE, 0, 3)
REG32(L1_TM_PLL_DIG18, 0x6048)
    FIELD(L1_TM_PLL_DIG18, TM_PLL_DIG18_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG18, TM_PLL_LOCK_PULDN, 7, 1)
    FIELD(L1_TM_PLL_DIG18, TM_STEP_SIZE_CNTRL, 5, 2)
    FIELD(L1_TM_PLL_DIG18, TM_SD_GSHIFT, 3, 2)
    FIELD(L1_TM_PLL_DIG18, TM_SD_DITHER, 1, 2)
    FIELD(L1_TM_PLL_DIG18, TM_PLL_LOCK_INT, 0, 1)
REG32(L1_TM_PLL_DIG19, 0x604c)
    FIELD(L1_TM_PLL_DIG19, TM_PLL_DIG19_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG19, TM_FORCE_EN_CLOCK_HS_DIV_2, 7, 1)
    FIELD(L1_TM_PLL_DIG19, TM_EN_CLOCK_HS_DIV_2, 6, 1)
    FIELD(L1_TM_PLL_DIG19, TM_PLL_HS_CLOCK_1, 3, 3)
    FIELD(L1_TM_PLL_DIG19, TM_PD_PFD, 2, 1)
    FIELD(L1_TM_PLL_DIG19, TM_FORCE_PD_PFD, 1, 1)
    FIELD(L1_TM_PLL_DIG19, TM_SELECT_PCI_2P5, 0, 1)
REG32(L1_TM_PLL_DIG20, 0x6050)
    FIELD(L1_TM_PLL_DIG20, TM_PLL_DIG20_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG20, TM_PLL_HALF_FULL_RATE, 7, 1)
    FIELD(L1_TM_PLL_DIG20, TM_PLL_RSVD, 6, 1)
    FIELD(L1_TM_PLL_DIG20, TM_V2I_PROG, 1, 5)
    FIELD(L1_TM_PLL_DIG20, TM_FORCE_V2I_PROG, 0, 1)
REG32(L1_TM_PLL_DIG21, 0x6054)
    FIELD(L1_TM_PLL_DIG21, TM_PLL_DIG21_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG21, TM_FORCE_EN_PLL_LDO_0P9_REF, 7, 1)
    FIELD(L1_TM_PLL_DIG21, ANA_TM_EN_PLL_0P9_FORCE_SW, 6, 1)
    FIELD(L1_TM_PLL_DIG21, TM_PLL_PD_OPDIV_SYM, 5, 1)
    FIELD(L1_TM_PLL_DIG21, TM_FORCE_PLL_PD_OPDIV_SYM, 4, 1)
    FIELD(L1_TM_PLL_DIG21, TM_PLL_RSVD_1, 3, 1)
    FIELD(L1_TM_PLL_DIG21, TM_PLL_RSVD_2, 2, 1)
    FIELD(L1_TM_PLL_DIG21, TM_PLL_EN, 1, 1)
    FIELD(L1_TM_PLL_DIG21, TM_FORCE_PLL_EN, 0, 1)
REG32(L1_TM_PLL_DIG22, 0x6058)
    FIELD(L1_TM_PLL_DIG22, TM_PLL_DIG22_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG22, TM_PLL_RSVD, 7, 1)
    FIELD(L1_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF_CP, 6, 1)
    FIELD(L1_TM_PLL_DIG22, TM_FORCE_EN_PLL_LDO_0P9_REF_CP, 5, 1)
    FIELD(L1_TM_PLL_DIG22, TM_FORCE_COARSE_START, 4, 1)
    FIELD(L1_TM_PLL_DIG22, TM_FORCE_PD_PLL_LDO_1P4, 3, 1)
    FIELD(L1_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL_DELAYED, 2, 1)
    FIELD(L1_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL, 1, 1)
    FIELD(L1_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF, 0, 1)
REG32(L1_TM_PLL_DIG23, 0x605c)
    FIELD(L1_TM_PLL_DIG23, TM_PLL_DIG23_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG23, BF_7, 7, 1)
    FIELD(L1_TM_PLL_DIG23, PLL_TM_VCO_LDO_BYPASS, 6, 1)
    FIELD(L1_TM_PLL_DIG23, TM_ANA_EN_LL_DELAYED, 5, 1)
    FIELD(L1_TM_PLL_DIG23, TM_ANA_EN_LL, 4, 1)
    FIELD(L1_TM_PLL_DIG23, TM_ANA_PD_PLL, 3, 1)
    FIELD(L1_TM_PLL_DIG23, TM_FORCE_PLL_PD, 2, 1)
    FIELD(L1_TM_PLL_DIG23, TM_ANA_COARSE_START, 1, 1)
    FIELD(L1_TM_PLL_DIG23, TM_PD_PLL_LDO_1P4, 0, 1)
REG32(L1_TM_PLL_DIG24, 0x6060)
    FIELD(L1_TM_PLL_DIG24, TM_PLL_DIG24_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG24, TM_PLL_RSVD, 7, 1)
    FIELD(L1_TM_PLL_DIG24, PLL_TM_VCO_LDO, 1, 6)
    FIELD(L1_TM_PLL_DIG24, PLL_TM_VCO_LDO_BYPASS_WITH_SEQUENCE, 0, 1)
REG32(L1_TM_PLL_DIG25, 0x6064)
    FIELD(L1_TM_PLL_DIG25, TM_PLL_DIG25_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG25, TM_FORCE_RST_N_HSRIPPLE, 7, 1)
    FIELD(L1_TM_PLL_DIG25, TM_RST_N_HSRIPPLE, 6, 1)
    FIELD(L1_TM_PLL_DIG25, TM_PLL_ATB_CNTRL, 1, 5)
    FIELD(L1_TM_PLL_DIG25, TM_PLL_OBSERVE_PTAT_10U, 0, 1)
REG32(L1_TM_PLL_DIG26, 0x6068)
    FIELD(L1_TM_PLL_DIG26, TM_PLL_DIG26_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG26, TM_PLL_RSVD, 7, 1)
    FIELD(L1_TM_PLL_DIG26, TM_PD_PLL_PTAT, 6, 1)
    FIELD(L1_TM_PLL_DIG26, TM_FORCE_PD_PLL_PTAT, 5, 1)
    FIELD(L1_TM_PLL_DIG26, TM_USB3_R2_HIGH_RES_SW_ON, 4, 1)
    FIELD(L1_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIV2_LOOP_OUT, 3, 1)
    FIELD(L1_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIRECT_LOOP_OUT, 2, 1)
    FIELD(L1_TM_PLL_DIG26, TM_PLL_SEL_VCO_HISPEED_DIV2_LOOP_OUT, 1, 1)
    FIELD(L1_TM_PLL_DIG26, TM_FORCE_LOOP_PATH, 0, 1)
REG32(L1_TM_PLL_CLK_DIST_NTRIM_LSB, 0x606c)
    FIELD(L1_TM_PLL_CLK_DIST_NTRIM_LSB, TM_PLL_CLK_DIST_NTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_CLK_DIST_NTRIM_LSB, TM_CLKDIST_BIAS_NTRIM_LSB, 0, 8)
REG32(L1_TM_PLL_CLK_DIST_PTRIM_LSB, 0x6070)
    FIELD(L1_TM_PLL_CLK_DIST_PTRIM_LSB, TM_PLL_CLK_DIST_PTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_CLK_DIST_PTRIM_LSB, TM_CLKDIST_BIAS_PTRIM_LSB, 0, 8)
REG32(L1_TM_PLL_DIG_29, 0x6074)
    FIELD(L1_TM_PLL_DIG_29, TM_PLL_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_MRSTBUF_SUP, 7, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_LRSTBUF_SUP, 6, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_RST_RPTR, 5, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_RST_RPTR, 4, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_CLK_RPTR, 3, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_CLK_RPTR, 2, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_CLKDIST_BIAS_PTRIM_MSB, 1, 1)
    FIELD(L1_TM_PLL_DIG_29, TM_CLKDIST_BIAS_NTRIM_MSB, 0, 1)
REG32(L1_TM_PLL_DIG_30, 0x6078)
    FIELD(L1_TM_PLL_DIG_30, TM_PLL_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_BIAS, 7, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_BIAS, 6, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_CMN_BIAS, 5, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_CMN_BIAS, 4, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_CLKDIST_SUP_OBSRV, 3, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RSTMUX_SUP, 2, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RPTR_RSTBUF_SUP, 1, 1)
    FIELD(L1_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_MUS_SUP, 0, 1)
REG32(L1_TM_PLL_DIG_31, 0x607c)
    FIELD(L1_TM_PLL_DIG_31, TM_PLL_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 7, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 6, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_RST_DRIVE, 5, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_RST_DRIVE, 4, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_CLK_DRIVE, 3, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_CLK_DRIVE, 2, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_CLKDIST_BIAS_RATE_SEL, 1, 1)
    FIELD(L1_TM_PLL_DIG_31, TM_FORCE_CLKDIST_BIAS_RATE_SEL, 0, 1)
REG32(L1_TM_PLL_DIG_32, 0x6080)
    FIELD(L1_TM_PLL_DIG_32, TM_PLL_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_32, TM_CLKDIST_MUX_XVCR_CLK_EN, 7, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_FORCE_CLKDIST_MUX_XVCR_CLK_EN, 6, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_FORCE_LOAD_FBDIV, 5, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_LOAD_FBDIV, 4, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_FORCE_RST_FDBK_DIV, 3, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_RST_FDBK_DIV, 2, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_CLKDIST_ENABLE_MASTER_RST_DRIVE, 1, 1)
    FIELD(L1_TM_PLL_DIG_32, TM_FORCE_CLKDIST_ENABLE_MASTER_RST_DRIVE, 0, 1)
REG32(L1_TM_PLL_DIG_33, 0x6084)
    FIELD(L1_TM_PLL_DIG_33, TM_PLL_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_33, TM_FORCE_TX_CLK_RST_REL, 7, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_TX_CLK_RST_REL, 6, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_CLKDIST_MUX_XCVR_MASTER_RST_EN, 5, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_XCVR_MASTER_RST_EN, 4, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_CLKDIST_MUX_MASTER_CLK_SEL, 3, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_MASTER_CLK_SEL, 2, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_CLKDIST_MUX_LOCAL_CLK_SEL, 1, 1)
    FIELD(L1_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_LOCAL_CLK_SEL, 0, 1)
REG32(L1_TM_PLL_DIG_34, 0x6088)
    FIELD(L1_TM_PLL_DIG_34, TM_PLL_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_34, TM_PLL_RSVD, 7, 1)
    FIELD(L1_TM_PLL_DIG_34, TM_FBDIV_3_MSB, 2, 5)
    FIELD(L1_TM_PLL_DIG_34, TM_SEL_VCO_OUT, 1, 1)
    FIELD(L1_TM_PLL_DIG_34, TM_FORCE_SEL_VCO_OUT, 0, 1)
REG32(L1_TM_PLL_DIG_35, 0x608c)
    FIELD(L1_TM_PLL_DIG_35, TM_PLL_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_35, TM_CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L1_TM_PLL_DIG_35, TM_CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L1_TM_PLL_DIG_35, TM_CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L1_TM_PLL_DIG_35, TM_CLKDIST_RPTR_SPARE, 0, 2)
REG32(L1_TM_PLL_DIG_36, 0x6090)
    FIELD(L1_TM_PLL_DIG_36, TM_PLL_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_36, CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L1_TM_PLL_DIG_36, CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L1_TM_PLL_DIG_36, CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L1_TM_PLL_DIG_36, CLKDIST_RPTR_SPARE, 0, 2)
REG32(L1_TM_PLL_DIG_37, 0x6094)
    FIELD(L1_TM_PLL_DIG_37, TM_PLL_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_DIG_37, TM_COARSE_CODE_SAT_VALUE_LSB, 5, 3)
    FIELD(L1_TM_PLL_DIG_37, TM_ENABLE_COARSE_SATURATION, 4, 1)
    FIELD(L1_TM_PLL_DIG_37, W_SPARE_OUTPUTS, 2, 2)
    FIELD(L1_TM_PLL_DIG_37, TM_FORCE_EN_IP_DIV_BYPASS, 1, 1)
    FIELD(L1_TM_PLL_DIG_37, TM_EN_IP_DIV_BYPASS, 0, 1)
REG32(L1_TM_PLL_COARSE_CODE_SAT_MSB, 0x6098)
    FIELD(L1_TM_PLL_COARSE_CODE_SAT_MSB, TM_PLL_COARSE_CODE_SAT_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_TM_PLL_COARSE_CODE_SAT_MSB, TM_COARSE_CODE_SAT_VALUE_MSB, 0, 8)
REG32(L1_MPHY_CFG_HIB8, 0x6300)
    FIELD(L1_MPHY_CFG_HIB8, MPHY_CFG_HIB8_31_8_RSVD, 24, 8)
    FIELD(L1_MPHY_CFG_HIB8, MPHY_HIBERN8_RSVD, 1, 7)
    FIELD(L1_MPHY_CFG_HIB8, MPHY_HIBERN8, 0, 1)
REG32(L1_MPHY_CFG_MODE, 0x6304)
    FIELD(L1_MPHY_CFG_MODE, MPHY_CFG_MODE_31_8_RSVD, 24, 8)
    FIELD(L1_MPHY_CFG_MODE, MPHY_HS_LS_MODE_RSVD, 2, 6)
    FIELD(L1_MPHY_CFG_MODE, MPHY_HS_LS_MODE, 0, 2)
REG32(L1_MPHY_CFG_HS_GEAR, 0x6308)
    FIELD(L1_MPHY_CFG_HS_GEAR, MPHY_CFG_HS_GEAR_31_8_RSVD, 24, 8)
    FIELD(L1_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR_RSVD, 2, 6)
    FIELD(L1_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR, 0, 2)
REG32(L1_MPHY_CFG_HS_RATE, 0x630c)
    FIELD(L1_MPHY_CFG_HS_RATE, MPHY_CFG_HS_RATE_31_8_RSVD, 24, 8)
    FIELD(L1_MPHY_CFG_HS_RATE, MPHY_RATE_RSVD, 1, 7)
    FIELD(L1_MPHY_CFG_HS_RATE, MPHY_RATE, 0, 1)
REG32(L1_MPHY_CFG_PWM, 0x6310)
    FIELD(L1_MPHY_CFG_PWM, MPHY_CFG_PWM_31_8_RSVD, 24, 8)
    FIELD(L1_MPHY_CFG_PWM, MPHY_PWM_GEAR_RSVD, 3, 5)
    FIELD(L1_MPHY_CFG_PWM, MPHY_PWM_GEAR, 0, 3)
REG32(L1_PLL_OPDIV_LS, 0x6314)
    FIELD(L1_PLL_OPDIV_LS, PLL_OPDIV_LS_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_OPDIV_LS, TM_SEL_OPDIV_FOR_REFCLK, 7, 1)
    FIELD(L1_PLL_OPDIV_LS, ANA_OPDIV_LS, 0, 7)
REG32(L1_MPHY_CFG_UPDT, 0x6318)
    FIELD(L1_MPHY_CFG_UPDT, MPHY_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L1_MPHY_CFG_UPDT, MPHY_CFGUPDT_RSVD, 1, 7)
    FIELD(L1_MPHY_CFG_UPDT, MPHY_CFGUPDT, 0, 1)
REG32(L1_PLL_TM_DIV_CNTRLS, 0x631c)
    FIELD(L1_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_DIV_CNTRLS, TM_FORCE_PD_OPDIV_LS, 7, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, TM_PD_OPDIV_LS, 6, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_RSVD, 5, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, TM_BYPASS_OPDIV_LS_MOD, 4, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, TM_FORCE_PLL_PD_HS, 3, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, TM_PLL_PD_HS, 2, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, SEL_IP_MUX_CONTROL, 1, 1)
    FIELD(L1_PLL_TM_DIV_CNTRLS, TM_SWAP_OP_MUX_CONTROL, 0, 1)
REG32(L1_PLL_FBDIV_G1A_LSB, 0x6320)
    FIELD(L1_PLL_FBDIV_G1A_LSB, PLL_FBDIV_G1A_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G1A_LSB, FBDIV_G1A_LSB, 0, 8)
REG32(L1_PLL_FBDIV_G1B_LSB, 0x6324)
    FIELD(L1_PLL_FBDIV_G1B_LSB, PLL_FBDIV_G1B_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G1B_LSB, FBDIV_G1B_LSB, 0, 8)
REG32(L1_PLL_FBDIV_G2A_LSB, 0x6328)
    FIELD(L1_PLL_FBDIV_G2A_LSB, PLL_FBDIV_G2A_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G2A_LSB, FBDIV_G2A_LSB, 0, 8)
REG32(L1_PLL_FBDIV_G2B_LSB, 0x632c)
    FIELD(L1_PLL_FBDIV_G2B_LSB, PLL_FBDIV_G2B_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G2B_LSB, FBDIV_G2B_LSB, 0, 8)
REG32(L1_PLL_FBDIV_G3A_LSB, 0x6330)
    FIELD(L1_PLL_FBDIV_G3A_LSB, PLL_FBDIV_G3A_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G3A_LSB, FBDIV_G3A_LSB, 0, 8)
REG32(L1_PLL_FBDIV_G3B_LSB, 0x6334)
    FIELD(L1_PLL_FBDIV_G3B_LSB, PLL_FBDIV_G3B_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G3B_LSB, FBDIV_G3B_LSB, 0, 8)
REG32(L1_PLL_FBDIV_G1A_MSB, 0x6338)
    FIELD(L1_PLL_FBDIV_G1A_MSB, PLL_FBDIV_G1A_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G1A_MSB, FBDIV_G1A_MSB, 0, 8)
REG32(L1_PLL_FBDIV_G1B_MSB, 0x633c)
    FIELD(L1_PLL_FBDIV_G1B_MSB, PLL_FBDIV_G1B_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G1B_MSB, FBDIV_G1B_MSB, 0, 8)
REG32(L1_PLL_FBDIV_G2A_MSB, 0x6340)
    FIELD(L1_PLL_FBDIV_G2A_MSB, PLL_FBDIV_G2A_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G2A_MSB, FBDIV_G2A_MSB, 0, 8)
REG32(L1_PLL_FBDIV_G2B_MSB, 0x6344)
    FIELD(L1_PLL_FBDIV_G2B_MSB, PLL_FBDIV_G2B_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G2B_MSB, FBDIV_G2B_MSB, 0, 8)
REG32(L1_PLL_FBDIV_G3A_MSB, 0x6348)
    FIELD(L1_PLL_FBDIV_G3A_MSB, PLL_FBDIV_G3A_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G3A_MSB, FBDIV_G3A_MSB, 0, 8)
REG32(L1_PLL_FBDIV_G3B_MSB, 0x634c)
    FIELD(L1_PLL_FBDIV_G3B_MSB, PLL_FBDIV_G3B_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_G3B_MSB, FBDIV_G3B_MSB, 0, 8)
REG32(L1_PLL_IPDIV, 0x6350)
    FIELD(L1_PLL_IPDIV, PLL_IPDIV_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_IPDIV, PLL_IPDIV, 0, 8)
REG32(L1_PLL_FBDIV_FRAC_0_LSB, 0x6354)
    FIELD(L1_PLL_FBDIV_FRAC_0_LSB, PLL_FBDIV_FRAC_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_FRAC_0_LSB, FBDIV_FRAC_0_LSB, 0, 8)
REG32(L1_PLL_FBDIV_FRAC_1, 0x6358)
    FIELD(L1_PLL_FBDIV_FRAC_1, PLL_FBDIV_FRAC_1_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_FRAC_1, FBDIV_FRAC_1, 0, 8)
REG32(L1_PLL_FBDIV_FRAC_2, 0x635c)
    FIELD(L1_PLL_FBDIV_FRAC_2, PLL_FBDIV_FRAC_2_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_FRAC_2, FBDIV_FRAC_2, 0, 8)
REG32(L1_PLL_FBDIV_FRAC_3_MSB, 0x6360)
    FIELD(L1_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSV_RSVD, 7, 1)
    FIELD(L1_PLL_FBDIV_FRAC_3_MSB, TM_FORCE_EN_FRAC, 6, 1)
    FIELD(L1_PLL_FBDIV_FRAC_3_MSB, TM_EN_FRAC, 5, 1)
    FIELD(L1_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB_RSVD, 3, 2)
    FIELD(L1_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB, 0, 3)
REG32(L1_PLL_PWR_SEQ_WAIT_TIME, 0x6364)
    FIELD(L1_PLL_PWR_SEQ_WAIT_TIME, PLL_PWR_SEQ_WAIT_TIME_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_SETTLING, 6, 2)
    FIELD(L1_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_BIAS_SETTLING, 4, 2)
    FIELD(L1_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_SETTLING, 2, 2)
    FIELD(L1_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_RELIABILITY, 0, 2)
REG32(L1_PLL_SS_STEPS_0_LSB, 0x6368)
    FIELD(L1_PLL_SS_STEPS_0_LSB, PLL_SS_STEPS_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_SS_STEPS_0_LSB, SS_NUM_OF_STEPS_0_LSB, 0, 8)
REG32(L1_PLL_SS_STEPS_1_MSB, 0x636c)
    FIELD(L1_PLL_SS_STEPS_1_MSB, PLL_SS_STEPS_1_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB_RSVD, 3, 5)
    FIELD(L1_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB, 0, 3)
REG32(L1_PLL_SS_STEP_SIZE_0_LSB, 0x6370)
    FIELD(L1_PLL_SS_STEP_SIZE_0_LSB, PLL_SS_STEP_SIZE_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_SS_STEP_SIZE_0_LSB, SS_STEP_SIZE_0_LSB, 0, 8)
REG32(L1_PLL_SS_STEP_SIZE_1, 0x6374)
    FIELD(L1_PLL_SS_STEP_SIZE_1, PLL_SS_STEP_SIZE_1_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_SS_STEP_SIZE_1, SS_STEP_SIZE_1, 0, 8)
REG32(L1_PLL_SS_STEP_SIZE_2, 0x6378)
    FIELD(L1_PLL_SS_STEP_SIZE_2, PLL_SS_STEP_SIZE_2_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_SS_STEP_SIZE_2, SS_STEP_SIZE_2, 0, 8)
REG32(L1_PLL_SS_STEP_SIZE_3_MSB, 0x637c)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, PLL_SS_STEP_SIZE_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, TM_FORCE_EN_SS, 7, 1)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, TM_EN_SS, 6, 1)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_NUM_OF_STEPS, 5, 1)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_STEP_SIZE, 4, 1)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, SS_SPREAD_TYPE, 2, 2)
    FIELD(L1_PLL_SS_STEP_SIZE_3_MSB, SS_STEP_SIZE_3_MSB, 0, 2)
REG32(L1_TM_MASK_CFG_UPDT, 0x6380)
    FIELD(L1_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L1_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_RSVD, 7, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, HIBERN8_MASK_CFG_UPDT, 6, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, HS_MODE_MASK_CFG_UPDT, 5, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, LS_MODE_MASK_CFG_UPDT, 4, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, OPDIV_LS_MASK_CFG_UPDT, 3, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, PWM_GEAR_MASK_CFG_UPDT, 2, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, HS_GEAR_MASK_CFG_UPDT, 1, 1)
    FIELD(L1_TM_MASK_CFG_UPDT, HS_RATE_MASK_CFG_UPDT, 0, 1)
REG32(L1_PLL_TM_FORCE_DIV, 0x6384)
    FIELD(L1_PLL_TM_FORCE_DIV, PLL_TM_FORCE_DIV_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_FRAC, 7, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3B, 6, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3A, 5, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2B, 4, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2A, 3, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1B, 2, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1A, 1, 1)
    FIELD(L1_PLL_TM_FORCE_DIV, TM_FORCE_IPDIV, 0, 1)
REG32(L1_PLL_TM_COARSE_CODE_1_LSB, 0x6388)
    FIELD(L1_PLL_TM_COARSE_CODE_1_LSB, PLL_TM_COARSE_CODE_1_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_1_LSB, TM_COARSE_CODE_1_LSB, 0, 8)
REG32(L1_PLL_TM_COARSE_CODE_2_LSB, 0x638c)
    FIELD(L1_PLL_TM_COARSE_CODE_2_LSB, PLL_TM_COARSE_CODE_2_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_2_LSB, TM_COARSE_CODE_2_LSB, 0, 8)
REG32(L1_PLL_TM_COARSE_CODE_3_LSB, 0x6390)
    FIELD(L1_PLL_TM_COARSE_CODE_3_LSB, PLL_TM_COARSE_CODE_3_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_3_LSB, TM_COARSE_CODE_3_LSB, 0, 8)
REG32(L1_PLL_TM_COARSE_CODE_4_LSB, 0x6394)
    FIELD(L1_PLL_TM_COARSE_CODE_4_LSB, PLL_TM_COARSE_CODE_4_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_4_LSB, TM_COARSE_CODE_4_LSB, 0, 8)
REG32(L1_PLL_TM_COARSE_CODE_5_LSB, 0x6398)
    FIELD(L1_PLL_TM_COARSE_CODE_5_LSB, PLL_TM_COARSE_CODE_5_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_5_LSB, TM_COARSE_CODE_5_LSB, 0, 8)
REG32(L1_PLL_TM_COARSE_CODE_6_LSB, 0x639c)
    FIELD(L1_PLL_TM_COARSE_CODE_6_LSB, PLL_TM_COARSE_CODE_6_LSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_6_LSB, TM_COARSE_CODE_6_LSB, 0, 8)
REG32(L1_PLL_TM_COARSE_CODE_1_2_MSB, 0x63a0)
    FIELD(L1_PLL_TM_COARSE_CODE_1_2_MSB, PLL_TM_COARSE_CODE_1_2_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_G1_AB_MSB_RSVD, 6, 2)
    FIELD(L1_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_2_MSB, 3, 3)
    FIELD(L1_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_1_MSB, 0, 3)
REG32(L1_PLL_TM_COARSE_CODE_3_4_MSB, 0x63a4)
    FIELD(L1_PLL_TM_COARSE_CODE_3_4_MSB, PLL_TM_COARSE_CODE_3_4_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_G2_AB_MSB_RSVD, 6, 2)
    FIELD(L1_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_4_MSB, 3, 3)
    FIELD(L1_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_3_MSB, 0, 3)
REG32(L1_PLL_TM_COARSE_CODE_5_6_MSB, 0x63a8)
    FIELD(L1_PLL_TM_COARSE_CODE_5_6_MSB, PLL_TM_COARSE_CODE_5_6_MSB_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_G3_AB_MSB_RSVD, 6, 2)
    FIELD(L1_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_6_MSB, 3, 3)
    FIELD(L1_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_5_MSB, 0, 3)
REG32(L1_PLL_TM_SHARED_0, 0x63ac)
    FIELD(L1_PLL_TM_SHARED_0, PLL_TM_SHARED_0_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_SHARED_0, TM_FORCE_EXTSIGNAL_FOR_HIBERN8, 7, 1)
    FIELD(L1_PLL_TM_SHARED_0, TM_FORCE_REGBIT_FOR_HIBERN8, 6, 1)
    FIELD(L1_PLL_TM_SHARED_0, TM_FORCE_PLL_STANDBY, 5, 1)
    FIELD(L1_PLL_TM_SHARED_0, TM_PLL_STANDBY, 4, 1)
    FIELD(L1_PLL_TM_SHARED_0, TM_SLOWN_FAST_BRING_UP_ALWAYS, 3, 1)
    FIELD(L1_PLL_TM_SHARED_0, EN_TM_FOR_BRING_UP_SCHEME, 2, 1)
    FIELD(L1_PLL_TM_SHARED_0, SELECT_HS_FB_DIVIDER, 1, 1)
    FIELD(L1_PLL_TM_SHARED_0, TM_BYPASS_COARSE_SEARCH, 0, 1)
REG32(L1_PLL_TM_FRAC_OFFSET_0, 0x63b0)
    FIELD(L1_PLL_TM_FRAC_OFFSET_0, PLL_TM_FRAC_OFFSET_0_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_FRAC_OFFSET_0, TM_FRAC_OFFSET_LSB_0, 0, 8)
REG32(L1_PLL_TM_FRAC_OFFSET_1, 0x63b4)
    FIELD(L1_PLL_TM_FRAC_OFFSET_1, PLL_TM_FRAC_OFFSET_1_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_FRAC_OFFSET_1, TM_FRAC_OFFSET_1, 0, 8)
REG32(L1_PLL_TM_FRAC_OFFSET_2, 0x63b8)
    FIELD(L1_PLL_TM_FRAC_OFFSET_2, PLL_TM_FRAC_OFFSET_2_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_TM_FRAC_OFFSET_2, TM_PLL_RSVD, 2, 6)
    FIELD(L1_PLL_TM_FRAC_OFFSET_2, TM_FORCE_FBDIV_FRAC_OFFSET, 1, 1)
    FIELD(L1_PLL_TM_FRAC_OFFSET_2, TM_FRAC_OFFSET_MSB_2, 0, 1)
REG32(L1_PLL_STATUS_READ_0, 0x63e0)
    FIELD(L1_PLL_STATUS_READ_0, PLL_STATUS_READ_0_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_STATUS_READ_0, PLL_COARSE_CODE_LSB_STATUS_READ, 0, 8)
REG32(L1_PLL_STATUS_READ_1, 0x63e4)
    FIELD(L1_PLL_STATUS_READ_1, PLL_STATUS_READ_1_31_8_RSVD, 24, 8)
    FIELD(L1_PLL_STATUS_READ_1, PLL_STATUS_READ_1_RSVD, 6, 2)
    FIELD(L1_PLL_STATUS_READ_1, PLL_START_LOOP_STATUS_READ, 5, 1)
    FIELD(L1_PLL_STATUS_READ_1, PLL_LOCK_STATUS_READ, 4, 1)
    FIELD(L1_PLL_STATUS_READ_1, PLL_COARSE_DONE_STATUS_READ, 3, 1)
    FIELD(L1_PLL_STATUS_READ_1, PLL_COARSE_CODE_MSB_STATUS_READ, 0, 3)
REG32(L1_UPHY_GLOBAL_CTRL, 0x7000)
    FIELD(L1_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_31_8_RSVD, 24, 8)
    FIELD(L1_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_7_RSVD, 7, 1)
    FIELD(L1_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_6_RSVD, 6, 1)
    FIELD(L1_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_5_RSVD, 5, 1)
    FIELD(L1_UPHY_GLOBAL_CTRL, PCLK_SELECT, 4, 1)
    FIELD(L1_UPHY_GLOBAL_CTRL, MPHY_G3_BIST_ENABLE, 3, 1)
    FIELD(L1_UPHY_GLOBAL_CTRL, MULTI_RATE_ENABLE, 2, 1)
    FIELD(L1_UPHY_GLOBAL_CTRL, MPHY_GEAR_SELECT, 0, 2)
REG32(L1_BIST_CTRL_1, 0x7004)
    FIELD(L1_BIST_CTRL_1, BIST_CTRL_1_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_CTRL_1, REPETITIVE_PATTERN_ENABLE, 7, 1)
    FIELD(L1_BIST_CTRL_1, PRBS_PATTERNS, 5, 2)
    FIELD(L1_BIST_CTRL_1, BIST_PATTERN_SELECT, 2, 3)
    FIELD(L1_BIST_CTRL_1, BIST_INFINITE_MODE_ENABLE, 1, 1)
    FIELD(L1_BIST_CTRL_1, BIST_ENABLE, 0, 1)
REG32(L1_BIST_CTRL_2, 0x7008)
    FIELD(L1_BIST_CTRL_2, BIST_CTRL_2_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_CTRL_2, BIST_CTRL_2_7_3_RSVD, 3, 5)
    FIELD(L1_BIST_CTRL_2, BIST_TRAINIG_SEQUENCE_SELECT, 1, 2)
    FIELD(L1_BIST_CTRL_2, BIST_ERROR_INJECTION_ENABLE, 0, 1)
REG32(L1_BIST_RUN_LEN_L, 0x700c)
    FIELD(L1_BIST_RUN_LEN_L, BIST_RUN_LEN_L_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_RUN_LEN_L, BIST_RUN_LEN_L, 0, 8)
REG32(L1_BIST_ERR_INJ_POINT_L, 0x7010)
    FIELD(L1_BIST_ERR_INJ_POINT_L, BIST_ERR_INJ_POINT_L_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_ERR_INJ_POINT_L, BIST_ERROR_INJ_POINT_L, 0, 8)
REG32(L1_BIST_RUNLEN_ERR_INJ_H, 0x7014)
    FIELD(L1_BIST_RUNLEN_ERR_INJ_H, BIST_RUNLEN_ERR_INJ_H_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_RUNLEN_ERR_INJ_H, BIST_RUN_LEN_H, 4, 4)
    FIELD(L1_BIST_RUNLEN_ERR_INJ_H, BIST_ERROR_INJ_POINT_H, 0, 4)
REG32(L1_BIST_IDLE_TIME, 0x7018)
    FIELD(L1_BIST_IDLE_TIME, BIST_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_IDLE_TIME, BIST_IDLE_TIME, 0, 8)
REG32(L1_BIST_MARKER_L, 0x701c)
    FIELD(L1_BIST_MARKER_L, BIST_MARKER_L_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_MARKER_L, BIST_MARKER_L, 0, 8)
REG32(L1_BIST_IDLE_CHAR_L, 0x7020)
    FIELD(L1_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L, 0, 8)
REG32(L1_BIST_MARKER_IDLE_H, 0x7024)
    FIELD(L1_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_H_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_7, 6, 2)
    FIELD(L1_BIST_MARKER_IDLE_H, BIST_MARKER_H, 4, 2)
    FIELD(L1_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_3, 2, 2)
    FIELD(L1_BIST_MARKER_IDLE_H, BIST_IDLE_CHAR_H, 0, 2)
REG32(L1_BIST_LOW_PULSE_TIME, 0x7028)
    FIELD(L1_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME, 0, 8)
REG32(L1_BIST_TOTAL_PULSE_TIME, 0x702c)
    FIELD(L1_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME, 0, 8)
REG32(L1_BIST_TEST_PAT_1, 0x7030)
    FIELD(L1_BIST_TEST_PAT_1, BIST_TEST_PAT_1_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_TEST_PAT_1, BIST_TEST_PAT_1_L, 0, 8)
REG32(L1_BIST_TEST_PAT_2, 0x7034)
    FIELD(L1_BIST_TEST_PAT_2, BIST_TEST_PAT_2_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_TEST_PAT_2, BIST_TEST_PAT_2_L, 0, 8)
REG32(L1_BIST_TEST_PAT_3, 0x7038)
    FIELD(L1_BIST_TEST_PAT_3, BIST_TEST_PAT_3_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_TEST_PAT_3, BIST_TEST_PAT_3_L, 0, 8)
REG32(L1_BIST_TEST_PAT_4, 0x703c)
    FIELD(L1_BIST_TEST_PAT_4, BIST_TEST_PAT_4_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_TEST_PAT_4, BIST_TEST_PAT_4_L, 0, 8)
REG32(L1_BIST_TEST_PAT_MSBS, 0x7040)
    FIELD(L1_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_MSBS_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_4_H, 6, 2)
    FIELD(L1_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_3_H, 4, 2)
    FIELD(L1_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_2_H, 2, 2)
    FIELD(L1_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_1_H, 0, 2)
REG32(L1_BIST_PKT_NUM, 0x7044)
    FIELD(L1_BIST_PKT_NUM, BIST_PKT_NUM_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_PKT_NUM, BIST_PKT_NUM, 0, 8)
REG32(L1_BIST_FRM_IDLE_TIME, 0x7048)
    FIELD(L1_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME, 0, 8)
REG32(L1_BIST_PKT_CTR_L, 0x704c)
    FIELD(L1_BIST_PKT_CTR_L, BIST_PKT_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_PKT_CTR_L, BIST_PKT_CTR_L, 0, 8)
REG32(L1_BIST_PKT_CTR_H, 0x7050)
    FIELD(L1_BIST_PKT_CTR_H, BIST_PKT_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_PKT_CTR_H, BIST_PKT_CTR_H, 0, 8)
REG32(L1_BIST_ERR_CTR_L, 0x7054)
    FIELD(L1_BIST_ERR_CTR_L, BIST_ERR_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_ERR_CTR_L, BIST_ERR_CTR_L, 0, 8)
REG32(L1_BIST_ERR_CTR_H, 0x7058)
    FIELD(L1_BIST_ERR_CTR_H, BIST_ERR_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_ERR_CTR_H, BIST_ERR_CTR_H, 0, 8)
REG32(L1_CLK_DIV_CNT, 0x705c)
    FIELD(L1_CLK_DIV_CNT, CLK_DIV_CNT_31_8_RSVD, 24, 8)
    FIELD(L1_CLK_DIV_CNT, REF_CLK_BYPASS_GT_50MHZ, 7, 1)
    FIELD(L1_CLK_DIV_CNT, SLOW_CNT_REG, 0, 7)
REG32(L1_DATA_BUS_WID, 0x7060)
    FIELD(L1_DATA_BUS_WID, DATA_BUS_WID_31_8_RSVD, 24, 8)
    FIELD(L1_DATA_BUS_WID, RATE_CHANGE_BYPASS, 7, 1)
    FIELD(L1_DATA_BUS_WID, PCLK_RATIO_BY_4, 6, 1)
    FIELD(L1_DATA_BUS_WID, PCLK_RATIO_BY_2, 5, 1)
    FIELD(L1_DATA_BUS_WID, RATE_CHANGE_DELAY_SEL, 4, 1)
    FIELD(L1_DATA_BUS_WID, RATE_CHANGE_DELAY_COUNT, 0, 4)
REG32(L1_ANADIG_BYPASS, 0x7064)
    FIELD(L1_ANADIG_BYPASS, ANADIG_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L1_ANADIG_BYPASS, ANA_DIG_COUNTER_SELECT, 7, 1)
    FIELD(L1_ANADIG_BYPASS, ANADIG_COUNT, 0, 7)
REG32(L1_BIST_FILLER_OUT, 0x7068)
    FIELD(L1_BIST_FILLER_OUT, BIST_FILLER_OUT_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_FILLER_OUT, BIST_FILLER_OUT_RESERVED, 2, 6)
    FIELD(L1_BIST_FILLER_OUT, BIST_FILLER_OUT_ENABLE, 1, 1)
    FIELD(L1_BIST_FILLER_OUT, BIST_TX_RX_LOOPBACK_ENABLE, 0, 1)
REG32(L1_BIST_FORCE_MK_RST, 0x706c)
    FIELD(L1_BIST_FORCE_MK_RST, BIST_FORCE_MK_RST_31_8_RSVD, 24, 8)
    FIELD(L1_BIST_FORCE_MK_RST, BIST_FORCE_RESET, 1, 1)
    FIELD(L1_BIST_FORCE_MK_RST, BIST_ENABLE_MK_FROM_REG, 0, 1)
REG32(L1_SPARE_IN, 0x7070)
    FIELD(L1_SPARE_IN, SPARE_IN_31_8_RSVD, 24, 8)
    FIELD(L1_SPARE_IN, SPARE_IN, 0, 8)
REG32(L1_SPARE_OUT, 0x7074)
    FIELD(L1_SPARE_OUT, SPARE_OUT_31_8_RSVD, 24, 8)
    FIELD(L1_SPARE_OUT, SPARE_OUT, 0, 8)
REG32(L2_TX_ANA_TM_0, 0x8000)
    FIELD(L2_TX_ANA_TM_0, TX_ANA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_0, ANA_BYP0_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_0, PIPE_TX_DN_RXDET, 5, 1)
    FIELD(L2_TX_ANA_TM_0, FORCE_PIPE_TX_DN_RXDET, 4, 1)
    FIELD(L2_TX_ANA_TM_0, PIPE_TX_DP_RXDET, 3, 1)
    FIELD(L2_TX_ANA_TM_0, FORCE_PIPE_TX_DP_RXDET, 2, 1)
    FIELD(L2_TX_ANA_TM_0, ANA_BYP0_1_0_RSVD, 0, 2)
REG32(L2_TX_ANA_TM_3, 0x800c)
    FIELD(L2_TX_ANA_TM_3, TX_ANA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_3, TX_HS_SER_RSTB, 7, 1)
    FIELD(L2_TX_ANA_TM_3, FORCE_TX_HS_SER_RSTB, 6, 1)
    FIELD(L2_TX_ANA_TM_3, TX_HS_BURST, 5, 1)
    FIELD(L2_TX_ANA_TM_3, FORCE_TX_HS_BURST, 4, 1)
    FIELD(L2_TX_ANA_TM_3, TX_SERIALIZER_ENABLE, 3, 1)
    FIELD(L2_TX_ANA_TM_3, FORCE_TX_SERIALIZER_ENABLE, 2, 1)
    FIELD(L2_TX_ANA_TM_3, TX_ENABLE_SUPPLY_SERIALIZER, 1, 1)
    FIELD(L2_TX_ANA_TM_3, FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 0, 1)
REG32(L2_TX_ANA_TM_4, 0x8010)
    FIELD(L2_TX_ANA_TM_4, TX_ANA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_4, ANA_BYP4_7_RSVD, 7, 1)
    FIELD(L2_TX_ANA_TM_4, TX_LSEG_DN_RESCAL_CODE, 1, 6)
    FIELD(L2_TX_ANA_TM_4, FORCE_TX_LSEG_DN_RESCAL_CODE, 0, 1)
REG32(L2_TX_ANA_TM_5, 0x8014)
    FIELD(L2_TX_ANA_TM_5, TX_ANA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_5, ANA_BYP5_7_RSVD, 7, 1)
    FIELD(L2_TX_ANA_TM_5, TX_USEG_DP_RESCAL_CODE, 1, 6)
    FIELD(L2_TX_ANA_TM_5, FORCE_TX_USEG_DP_RESCAL_CODE, 0, 1)
REG32(L2_TX_ANA_TM_9, 0x8024)
    FIELD(L2_TX_ANA_TM_9, TX_ANA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_9, MPHY_TX_HS_SLEWRATE, 0, 8)
REG32(L2_TX_ANA_TM_10, 0x8028)
    FIELD(L2_TX_ANA_TM_10, TX_ANA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_10, MPHY_HS_POWERUP_TIME, 4, 4)
    FIELD(L2_TX_ANA_TM_10, MPHY_TX_HS_EQUALIZER_SETTING, 1, 3)
    FIELD(L2_TX_ANA_TM_10, FORCE_MPHY_TX_HS_EQUALIZER_SETTING, 0, 1)
REG32(L2_TX_ANA_TM_13, 0x8034)
    FIELD(L2_TX_ANA_TM_13, TX_ANA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_13, ANA_BYP13_7_4_RSVD, 4, 4)
    FIELD(L2_TX_ANA_TM_13, TX_SWAP_POLARITY, 3, 1)
    FIELD(L2_TX_ANA_TM_13, FORCE_TX_SWAP_POLARITY, 2, 1)
    FIELD(L2_TX_ANA_TM_13, MPHY_TX_TRISTATE, 1, 1)
    FIELD(L2_TX_ANA_TM_13, FORCE_MPHY_TX_TRISTATE, 0, 1)
REG32(L2_TX_ANA_TM_14, 0x8038)
    FIELD(L2_TX_ANA_TM_14, TX_ANA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_14, ANA_BYP14_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_14, PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L2_TX_ANA_TM_14, FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L2_TX_ANA_TM_14, ANA_BYP14_3_0_RSVD, 0, 4)
REG32(L2_TX_ANA_TM_15, 0x803c)
    FIELD(L2_TX_ANA_TM_15, TX_ANA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_15, PIPE_TX_SWING, 7, 1)
    FIELD(L2_TX_ANA_TM_15, FORCE_PIPE_TX_SWING, 6, 1)
    FIELD(L2_TX_ANA_TM_15, PIPE_TX_RXDET_DISCHARGE, 5, 1)
    FIELD(L2_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_DISCHARGE, 4, 1)
    FIELD(L2_TX_ANA_TM_15, PIPE_TX_RXDET_CHARGE, 3, 1)
    FIELD(L2_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_CHARGE, 2, 1)
    FIELD(L2_TX_ANA_TM_15, PIPE_TX_ENABLE_RXDET, 1, 1)
    FIELD(L2_TX_ANA_TM_15, FORCE_PIPE_TX_ENABLE_RXDET, 0, 1)
REG32(L2_TX_ANA_TM_16, 0x8040)
    FIELD(L2_TX_ANA_TM_16, TX_ANA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_16, ANA_BYP16_7_4_RSVD, 4, 4)
    FIELD(L2_TX_ANA_TM_16, PIPE_TX_MARGIN, 1, 3)
    FIELD(L2_TX_ANA_TM_16, FORCE_PIPE_TX_MARGIN, 0, 1)
REG32(L2_TX_ANA_TM_18, 0x8048)
    FIELD(L2_TX_ANA_TM_18, TX_ANA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_18, PIPE_TX_DEEMPH_7_0, 0, 8)
REG32(L2_TX_ANA_TM_19, 0x804c)
    FIELD(L2_TX_ANA_TM_19, TX_ANA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_19, PIPE_TX_DEEMPH_15_8, 0, 8)
REG32(L2_TX_ANA_TM_20, 0x8050)
    FIELD(L2_TX_ANA_TM_20, TX_ANA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_20, ANA_BYP20_7_5_RSVD, 5, 3)
    FIELD(L2_TX_ANA_TM_20, TX_SERIALIZER_RST_REL, 4, 1)
    FIELD(L2_TX_ANA_TM_20, FORCE_TX_SERIALIZER_RST_REL, 3, 1)
    FIELD(L2_TX_ANA_TM_20, FORCE_MPHY_TX_HS_SLEWRATE, 2, 1)
    FIELD(L2_TX_ANA_TM_20, PIPE_TX_DEEMPH_17_16, 0, 2)
REG32(L2_TX_ANA_TM_21, 0x8054)
    FIELD(L2_TX_ANA_TM_21, TX_ANA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_21, ANA_BYP21_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_21, PIPE_TX_COEF_CALC_CLK, 5, 1)
    FIELD(L2_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_CLK, 4, 1)
    FIELD(L2_TX_ANA_TM_21, PIPE_TX_COEF_CALC_FSM_RESET_B, 3, 1)
    FIELD(L2_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_FSM_RESET_B, 2, 1)
    FIELD(L2_TX_ANA_TM_21, PIPE_TX_DEEMPH_CTRL_SEL, 1, 1)
    FIELD(L2_TX_ANA_TM_21, FORCE_PIPE_TX_DEEMPH_CTRL_SEL, 0, 1)
REG32(L2_TX_DIG_TM_61, 0x80f4)
    FIELD(L2_TX_DIG_TM_61, TX_DIG_TM_61_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_61, MPHY_PLL_GEAR, 6, 2)
    FIELD(L2_TX_DIG_TM_61, DIG_BYP1_5_4_RSVD, 4, 2)
    FIELD(L2_TX_DIG_TM_61, BYPASS_ENC, 3, 1)
    FIELD(L2_TX_DIG_TM_61, DIG_BYP1_2_RSVD, 2, 1)
    FIELD(L2_TX_DIG_TM_61, BYPASS_SCRAM, 1, 1)
    FIELD(L2_TX_DIG_TM_61, FORCE_BYPASS_SCRAM, 0, 1)
REG32(L2_TX_DIG_TM_62, 0x80f8)
    FIELD(L2_TX_DIG_TM_62, TX_DIG_TM_62_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_62, G0_BIT_PER_CNT, 0, 8)
REG32(L2_TX_DIG_TM_65, 0x8104)
    FIELD(L2_TX_DIG_TM_65, TX_DIG_TM_65_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_65, FORCE_TX_RXDET_PROBE_THRESHOLD, 7, 1)
    FIELD(L2_TX_DIG_TM_65, FORCE_TX_RXDET_END_CH_THRESHOLD, 6, 1)
    FIELD(L2_TX_DIG_TM_65, FORCE_TX_RXDET_START_CH_THRESHOLD, 5, 1)
    FIELD(L2_TX_DIG_TM_65, FORCE_TX_RXDET_END_DCH_THRESHOLD, 4, 1)
    FIELD(L2_TX_DIG_TM_65, FORCE_TX_RXDET_START_DCH_THRESHOLD, 3, 1)
    FIELD(L2_TX_DIG_TM_65, TX_EN_FULL_CALIB, 2, 1)
    FIELD(L2_TX_DIG_TM_65, FORCE_TX_EN_FULL_CALIB, 1, 1)
    FIELD(L2_TX_DIG_TM_65, DIG_BYP5_0_RSVD, 0, 1)
REG32(L2_TX_DIG_TM_67, 0x810c)
    FIELD(L2_TX_DIG_TM_67, TX_DIG_TM_67_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_67, TX_MPHY_SER_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_68, 0x8110)
    FIELD(L2_TX_DIG_TM_68, TX_DIG_TM_68_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_68, TX_SER_SUP_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_69, 0x8114)
    FIELD(L2_TX_DIG_TM_69, TX_DIG_TM_69_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_69, TX_MPHY_SUP_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_76, 0x8130)
    FIELD(L2_TX_DIG_TM_76, TX_DIG_TM_76_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_76, TX_RXDET_START_DCH_THRESHOLD_7_0, 0, 8)
REG32(L2_TX_DIG_TM_77, 0x8134)
    FIELD(L2_TX_DIG_TM_77, TX_DIG_TM_77_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_77, TX_RXDET_END_DCH_THRESHOLD_11_8, 4, 4)
    FIELD(L2_TX_DIG_TM_77, TX_RXDET_START_DCH_THRESHOLD_11_8, 0, 4)
REG32(L2_TX_DIG_TM_78, 0x8138)
    FIELD(L2_TX_DIG_TM_78, TX_DIG_TM_78_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_78, TX_RXDET_END_DCH_THRESHOLD_7_0, 0, 8)
REG32(L2_TX_DIG_TM_79, 0x813c)
    FIELD(L2_TX_DIG_TM_79, TX_DIG_TM_79_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_79, TX_RXDET_START_CH_THRESHOLD_7_0, 0, 8)
REG32(L2_TX_DIG_TM_80, 0x8140)
    FIELD(L2_TX_DIG_TM_80, TX_DIG_TM_80_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_80, TX_RXDET_END_CH_THRESHOLD_11_8, 4, 4)
    FIELD(L2_TX_DIG_TM_80, TX_RXDET_START_CH_THRESHOLD_11_8, 0, 4)
REG32(L2_TX_DIG_TM_81, 0x8144)
    FIELD(L2_TX_DIG_TM_81, TX_DIG_TM_81_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_81, TX_RXDET_END_CH_THRESHOLD_7_0, 0, 8)
REG32(L2_TX_DIG_TM_82, 0x8148)
    FIELD(L2_TX_DIG_TM_82, TX_DIG_TM_82_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_82, TX_RXDET_PROBE_THRESHOLD_7_0, 0, 8)
REG32(L2_TX_DIG_TM_83, 0x814c)
    FIELD(L2_TX_DIG_TM_83, TX_DIG_TM_83_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_83, DIG_BYP23_7_4_RSVD, 4, 4)
    FIELD(L2_TX_DIG_TM_83, TX_RXDET_PROBE_THRESHOLD_11_8, 0, 4)
REG32(L2_TX_DIG_TM_84, 0x8150)
    FIELD(L2_TX_DIG_TM_84, TX_DIG_TM_84_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_84, TX_DIF_P, 7, 1)
    FIELD(L2_TX_DIG_TM_84, TX_DITHER_1P, 6, 1)
    FIELD(L2_TX_DIG_TM_84, TX_DITHER_1N, 5, 1)
    FIELD(L2_TX_DIG_TM_84, TX_DITHER_EN, 4, 1)
    FIELD(L2_TX_DIG_TM_84, DIG_BYP24_3_RSVD, 3, 1)
    FIELD(L2_TX_DIG_TM_84, TX_PHYDIRDY_SOC_MODE, 2, 1)
    FIELD(L2_TX_DIG_TM_84, DIG_BYP24_1_RSVD, 1, 1)
    FIELD(L2_TX_DIG_TM_84, TX_READ_SHADOW, 0, 1)
REG32(L2_TX_ANA_TM_85, 0x8154)
    FIELD(L2_TX_ANA_TM_85, TX_ANA_TM_85_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_85, DIG_BYP25_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_85, TX_HIBERN8_CTRL, 5, 1)
    FIELD(L2_TX_ANA_TM_85, TX_ALLOW_INLNCFG_FROM_TOP, 4, 1)
    FIELD(L2_TX_ANA_TM_85, DIG_BYP25_3_RSVD, 3, 1)
    FIELD(L2_TX_ANA_TM_85, TX_SEND_MSB_FIRST, 2, 1)
    FIELD(L2_TX_ANA_TM_85, DIG_BYP25_1_RSVD, 1, 1)
    FIELD(L2_TX_ANA_TM_85, TX_DIF_N, 0, 1)
REG32(L2_TX_ANA_TM_87, 0x815c)
    FIELD(L2_TX_ANA_TM_87, TX_ANA_TM_87_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_87, DIG_BYP27_7_4_RSVD, 4, 4)
    FIELD(L2_TX_ANA_TM_87, TX_SM_STATUS, 0, 4)
REG32(L2_TX_ANA_TM_88, 0x8160)
    FIELD(L2_TX_ANA_TM_88, TX_ANA_TM_88_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_88, TX_COMP_PAT_HIGH_TIME_REGS, 0, 8)
REG32(L2_TX_ANA_TM_89, 0x8164)
    FIELD(L2_TX_ANA_TM_89, TX_ANA_TM_89_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_89, DIG_BYP29_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_89, TX_DATAPATH_CTRL_1_REGS, 5, 1)
    FIELD(L2_TX_ANA_TM_89, DIG_BYP29_4_3_RSVD, 3, 2)
    FIELD(L2_TX_ANA_TM_89, INITIAL_DISPARITY, 2, 1)
    FIELD(L2_TX_ANA_TM_89, SCRAMBLER_ENABLE, 1, 1)
    FIELD(L2_TX_ANA_TM_89, DIG_BYP29_0_RSVD, 0, 1)
REG32(L2_TX_ANA_TM_90, 0x8168)
    FIELD(L2_TX_ANA_TM_90, TX_ANA_TM_90_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_90, DIG_BYP30_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_90, TX_BYPASS_BCNT_LPBACK_REGS, 5, 1)
    FIELD(L2_TX_ANA_TM_90, DIG_BYP30_4_0_RSVD, 0, 5)
REG32(L2_TX_DIG_TM_91, 0x816c)
    FIELD(L2_TX_DIG_TM_91, TX_DIG_TM_91_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_91, TX_CFGCLK_FREQ, 0, 8)
REG32(L2_TX_DIG_TM_92, 0x8170)
    FIELD(L2_TX_DIG_TM_92, TX_DIG_TM_92_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_92, TX_PHYDIRDY_PULL_UP_LATENCY, 0, 8)
REG32(L2_TX_ANA_TM_95, 0x817c)
    FIELD(L2_TX_ANA_TM_95, TX_ANA_TM_95_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_95, ANA_BYP63_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_95, TX_TM_EN_PROG_SYNC_PATTERN, 5, 1)
    FIELD(L2_TX_ANA_TM_95, TX_EXTRA_HS_BURST_IN_LCC, 2, 3)
    FIELD(L2_TX_ANA_TM_95, ANA_BYP22_1_0_RSVD, 0, 2)
REG32(L2_TX_ANA_TM_96, 0x8180)
    FIELD(L2_TX_ANA_TM_96, TX_ANA_TM_96_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_96, TX_TM_PROG_SYNC_PATTERN1, 0, 8)
REG32(L2_TX_ANA_TM_97, 0x8184)
    FIELD(L2_TX_ANA_TM_97, TX_ANA_TM_97_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_97, TX_TM_PROG_SYNC_PATTERN2, 0, 8)
REG32(L2_TX_DIG_TM_98, 0x8188)
    FIELD(L2_TX_DIG_TM_98, TX_DIG_TM_98_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_98, DIG_BYP33_7_6_RSVD, 6, 2)
    FIELD(L2_TX_DIG_TM_98, FORCE_RD_VALUE, 5, 1)
    FIELD(L2_TX_DIG_TM_98, FORCE_RD, 4, 1)
    FIELD(L2_TX_DIG_TM_98, TX_SER_ISO_CTRL_BAR, 3, 1)
    FIELD(L2_TX_DIG_TM_98, FORCE_TX_SER_ISO_CTRL_BAR, 2, 1)
    FIELD(L2_TX_DIG_TM_98, TX_ISO_CTRL_BAR, 1, 1)
    FIELD(L2_TX_DIG_TM_98, FORCE_TX_ISO_CTRL_BAR, 0, 1)
REG32(L2_TX_DIG_TM_99, 0x818c)
    FIELD(L2_TX_DIG_TM_99, TX_DIG_TM_99_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_99, TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_100, 0x8190)
    FIELD(L2_TX_DIG_TM_100, TX_DIG_TM_100_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_100, TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_101, 0x8194)
    FIELD(L2_TX_DIG_TM_101, TX_DIG_TM_101_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_101, TX_SERIALISER_ENABLE_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_102, 0x8198)
    FIELD(L2_TX_DIG_TM_102, TX_DIG_TM_102_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_102, FORCE_TX_ANA_LL_EN, 7, 1)
    FIELD(L2_TX_DIG_TM_102, TX_ANA_LL_EN, 6, 1)
    FIELD(L2_TX_DIG_TM_102, FORCE_DELAY_CNT_THRESHOLD, 5, 1)
    FIELD(L2_TX_DIG_TM_102, FORCE_TX_MPHY_TRST_THRESHOLD, 4, 1)
    FIELD(L2_TX_DIG_TM_102, FORCE_TX_LDO_THRESHOLD, 3, 1)
    FIELD(L2_TX_DIG_TM_102, FORCE_TX_SERIALISER_ENABLE_THRESHOLD, 2, 1)
    FIELD(L2_TX_DIG_TM_102, FORCE_TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 1, 1)
    FIELD(L2_TX_DIG_TM_102, FORCE_TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 1)
REG32(L2_TX_DIG_TM_103, 0x819c)
    FIELD(L2_TX_DIG_TM_103, TX_DIG_TM_103_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_103, FORCE_BG_EN, 7, 1)
    FIELD(L2_TX_DIG_TM_103, FORCE_CALIB_EN, 6, 1)
    FIELD(L2_TX_DIG_TM_103, FORCE_PLL_EN, 5, 1)
    FIELD(L2_TX_DIG_TM_103, FORCE_PSO, 4, 1)
    FIELD(L2_TX_DIG_TM_103, BG_EN, 3, 1)
    FIELD(L2_TX_DIG_TM_103, CALIB_EN, 2, 1)
    FIELD(L2_TX_DIG_TM_103, PLL_EN, 1, 1)
    FIELD(L2_TX_DIG_TM_103, PSO, 0, 1)
REG32(L2_TX_DIG_TM_104, 0x81a0)
    FIELD(L2_TX_DIG_TM_104, TX_DIG_TM_104_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_104, TX_LDO_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_105, 0x81a4)
    FIELD(L2_TX_DIG_TM_105, TX_DIG_TM_105_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_105, TX_MPHY_TRST_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_106, 0x81a8)
    FIELD(L2_TX_DIG_TM_106, TX_DIG_TM_106_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_106, DELAY_CNT_THRESHOLD, 0, 8)
REG32(L2_TX_DIG_TM_107, 0x81ac)
    FIELD(L2_TX_DIG_TM_107, TX_DIG_TM_107_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_107, DIG_BYP42_7_RSVD, 7, 1)
    FIELD(L2_TX_DIG_TM_107, FORCE_P3TOP0_PHYSTATUS_PULSE, 6, 1)
    FIELD(L2_TX_DIG_TM_107, ENABLE_HS_CLK_DIVISION, 5, 1)
    FIELD(L2_TX_DIG_TM_107, TESTDIGOUT_SEL, 1, 4)
    FIELD(L2_TX_DIG_TM_107, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L2_TX_DIG_TM_108, 0x81b0)
    FIELD(L2_TX_DIG_TM_108, TX_DIG_TM_108_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_108, ANA_BYP43_7_RSVD, 7, 1)
    FIELD(L2_TX_DIG_TM_108, TX_EXT_DATA_DELAY, 3, 4)
    FIELD(L2_TX_DIG_TM_108, FORCE_TX_EXT_DATA_DELAY, 2, 1)
    FIELD(L2_TX_DIG_TM_108, FORCE_TX_DATA_DELAY, 1, 1)
    FIELD(L2_TX_DIG_TM_108, FORCE_UPHY_TXPMA_OPMODE, 0, 1)
REG32(L2_TX_DIG_TM_109, 0x81b4)
    FIELD(L2_TX_DIG_TM_109, TX_DIG_TM_109_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_109, UPHY_TXPMA_OPMODE, 0, 8)
REG32(L2_TX_DIG_TM_110, 0x81b8)
    FIELD(L2_TX_DIG_TM_110, TX_DIG_TM_110_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_110, TX_DATA_DELAY, 0, 8)
REG32(L2_TX_DIG_TM_111, 0x81bc)
    FIELD(L2_TX_DIG_TM_111, TX_DIG_TM_111_31_8_RSVD, 24, 8)
    FIELD(L2_TX_DIG_TM_111, TX_DA_SPARE, 0, 8)
REG32(L2_TX_ANA_TM_112, 0x81c0)
    FIELD(L2_TX_ANA_TM_112, TX_ANA_TM_112_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_112, ANA_BYP25_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_112, PIPE_TX_ENABLE_LFPS, 4, 2)
    FIELD(L2_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L2_TX_ANA_TM_112, PIPE_TX_ENABLE_IDLE_MODE, 1, 2)
    FIELD(L2_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L2_TX_ANA_TM_113, 0x81c4)
    FIELD(L2_TX_ANA_TM_113, TX_ANA_TM_113_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_113, MPHY_TX_DRIVERLDO_PROG, 0, 8)
REG32(L2_TX_ANA_TM_114, 0x81c8)
    FIELD(L2_TX_ANA_TM_114, TX_ANA_TM_114_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_114, ANA_BYP27_7_5_RSVD, 5, 3)
    FIELD(L2_TX_ANA_TM_114, FORCE_MPHY_TX_DRIVERLDO_PROG, 4, 1)
    FIELD(L2_TX_ANA_TM_114, MPHY_TX_DRIVERLDO_PROG, 0, 4)
REG32(L2_TX_ANA_TM_115, 0x81cc)
    FIELD(L2_TX_ANA_TM_115, TX_ANA_TM_115_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_115, ANA_BYP28_7_RSVD, 7, 1)
    FIELD(L2_TX_ANA_TM_115, PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 6, 1)
    FIELD(L2_TX_ANA_TM_115, FORCE_PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 5, 1)
    FIELD(L2_TX_ANA_TM_115, TX_PMADIG_DIGITAL_RESET_N, 4, 1)
    FIELD(L2_TX_ANA_TM_115, FORCE_TX_PMADIG_DIGITAL_RESET_N, 3, 1)
    FIELD(L2_TX_ANA_TM_115, TX_ANA_IF_RATE, 1, 2)
    FIELD(L2_TX_ANA_TM_115, FORCE_TX_ANA_IF_RATE, 0, 1)
REG32(L2_TX_ANA_TM_116, 0x81d0)
    FIELD(L2_TX_ANA_TM_116, TX_ANA_TM_116_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_116, ANA_BYP29_7_RSVD, 7, 1)
    FIELD(L2_TX_ANA_TM_116, PIPE_TX_LOCALPRESETINDEX, 3, 4)
    FIELD(L2_TX_ANA_TM_116, FORCE_PIPE_TX_LOCALPRESETINDEX, 2, 1)
    FIELD(L2_TX_ANA_TM_116, MPHY_TX_EN_LANE_LS_CLK, 1, 1)
    FIELD(L2_TX_ANA_TM_116, FORCE_MPHY_TX_EN_LANE_LS_CLK, 0, 1)
REG32(L2_TX_ANA_TM_117, 0x81d4)
    FIELD(L2_TX_ANA_TM_117, TX_ANA_TM_117_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_117, MULTILANE_BYP1_7_6_RSVD, 6, 2)
    FIELD(L2_TX_ANA_TM_117, TX_PCIE_4X_CFG_EN, 5, 1)
    FIELD(L2_TX_ANA_TM_117, FORCE_TX_PCIE_4X_CFG_EN, 4, 1)
    FIELD(L2_TX_ANA_TM_117, TX_PCIE_2X_CFG_EN, 3, 1)
    FIELD(L2_TX_ANA_TM_117, FORCE_TX_PCIE_2X_CFG_EN, 2, 1)
    FIELD(L2_TX_ANA_TM_117, TX_DP_MULTILANE_CFG_EN, 1, 1)
    FIELD(L2_TX_ANA_TM_117, FORCE_TX_DP_MULTILANE_CFG_EN, 0, 1)
REG32(L2_TX_ANA_TM_118, 0x81d8)
    FIELD(L2_TX_ANA_TM_118, TX_ANA_TM_118_31_8_RSVD, 24, 8)
    FIELD(L2_TX_ANA_TM_118, ANA_BYP30_7_4_RSVD, 4, 4)
    FIELD(L2_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_12, 3, 1)
    FIELD(L2_TX_ANA_TM_118, FORCE_TX_DEEMPH_11_6, 2, 1)
    FIELD(L2_TX_ANA_TM_118, FORCE_TX_DEEMPH_5_0, 1, 1)
    FIELD(L2_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_0, 0, 1)
REG32(L2_TXPMA_TM_0, 0x8800)
    FIELD(L2_TXPMA_TM_0, TXPMA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_0, TM_TX_ENABLE_SUPPLY_MPHY, 7, 1)
    FIELD(L2_TXPMA_TM_0, TM_FORCE_TX_ENABLE_SUPPLY_MPHY, 6, 1)
    FIELD(L2_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 5, 1)
    FIELD(L2_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 4, 1)
    FIELD(L2_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SA_MODE, 3, 1)
    FIELD(L2_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SA_MODE, 2, 1)
    FIELD(L2_TXPMA_TM_0, TM_MPHY_TX_ENABLE_HS_NT, 1, 1)
    FIELD(L2_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_HS_NT, 0, 1)
REG32(L2_TXPMA_TM_1, 0x8804)
    FIELD(L2_TXPMA_TM_1, TXPMA_TM_1_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_1, ANA_MPHY_BYP1_7_4_RSVD, 4, 4)
    FIELD(L2_TXPMA_TM_1, TM_MPHY_TX_HS_DITHER_VAL, 1, 3)
    FIELD(L2_TXPMA_TM_1, TM_FORCE_MPHY_TX_HS_DITHER_VAL, 0, 1)
REG32(L2_TXPMA_TM_2, 0x8808)
    FIELD(L2_TXPMA_TM_2, TXPMA_TM_2_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_2, TM_MPHY_TX_DRIVERLDO_PROG_6_0, 1, 7)
    FIELD(L2_TXPMA_TM_2, TM_FORCE_MPHY_TX_DRIVERLDO_PROG, 0, 1)
REG32(L2_TXPMA_TM_3, 0x880c)
    FIELD(L2_TXPMA_TM_3, TXPMA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_3, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMA_TM_3, TM_MPHY_TX_DRIVERLDO_PROG_11_7, 0, 5)
REG32(L2_TXPMA_TM_4, 0x8810)
    FIELD(L2_TXPMA_TM_4, TXPMA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_4, TM_PIPE_TX_TX_DATA_WIDTH, 5, 3)
    FIELD(L2_TXPMA_TM_4, TM_FORCE_PIPE_TX_TX_DATA_WIDTH, 4, 1)
    FIELD(L2_TXPMA_TM_4, TM_PIPE_TX_POWERDOWN_VCM_HOLD, 3, 1)
    FIELD(L2_TXPMA_TM_4, TM_FORCE_PIPE_TX_POWERDOWN_VCM_HOLD, 2, 1)
    FIELD(L2_TXPMA_TM_4, TM_PIPE_TX_ANABOOST_POWERDOWN, 1, 1)
    FIELD(L2_TXPMA_TM_4, ANA_PIPE_BYP0_0_RSVD, 0, 1)
REG32(L2_TXPMA_TM_5, 0x8814)
    FIELD(L2_TXPMA_TM_5, TXPMA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_5, ANA_BSCAN_BYP0_7_4_RSVD, 4, 4)
    FIELD(L2_TXPMA_TM_5, TM_TX_BSCAN_SEL, 3, 1)
    FIELD(L2_TXPMA_TM_5, TM_FORCE_TX_BSCAN_SEL, 2, 1)
    FIELD(L2_TXPMA_TM_5, TM_TX_BSCAN_DATA, 1, 1)
    FIELD(L2_TXPMA_TM_5, TM_FORCE_TX_BSCAN_DATA, 0, 1)
REG32(L2_TXPMA_TM_6, 0x8818)
    FIELD(L2_TXPMA_TM_6, TXPMA_TM_6_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_6, TM_TX_ENABLE_ISI_LPBK, 7, 1)
    FIELD(L2_TXPMA_TM_6, TM_FORCE_TX_ENABLE_ISI_LPBK, 6, 1)
    FIELD(L2_TXPMA_TM_6, TM_TX_ENABLE_SER_LPBK, 5, 1)
    FIELD(L2_TXPMA_TM_6, TM_FORCE_TX_ENABLE_SER_LPBK, 4, 1)
    FIELD(L2_TXPMA_TM_6, TM_TX_ENABLE_RX_LIN_LPBK, 3, 1)
    FIELD(L2_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RX_LIN_LPBK, 2, 1)
    FIELD(L2_TXPMA_TM_6, TM_TX_ENABLE_RCRVD_DATA_LPBK, 1, 1)
    FIELD(L2_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RCRVD_DATA_LPBK, 0, 1)
REG32(L2_TXPMA_TM_7, 0x881c)
    FIELD(L2_TXPMA_TM_7, TXPMA_TM_7_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_UPHY, 7, 1)
    FIELD(L2_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_UPHY, 6, 1)
    FIELD(L2_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_SERIALIZER, 5, 1)
    FIELD(L2_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L2_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_PIPE, 3, 1)
    FIELD(L2_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_PIPE, 2, 1)
    FIELD(L2_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_HSCLK, 1, 1)
    FIELD(L2_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_HSCLK, 0, 1)
REG32(L2_TXPMA_TM_8, 0x8820)
    FIELD(L2_TXPMA_TM_8, TXPMA_TM_8_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_8, ANA_LS_LFPS_BYP0_7_2_RSVD, 2, 6)
    FIELD(L2_TXPMA_TM_8, TM_TX_LS_LFPS_DATA, 1, 1)
    FIELD(L2_TXPMA_TM_8, TM_FORCE_TX_LS_LFPS_DATA, 0, 1)
REG32(L2_TXPMA_TM_9, 0x8824)
    FIELD(L2_TXPMA_TM_9, TXPMA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_9, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L2_TXPMA_TM_9, TM_TX_SERIALIZER_MODE, 6, 1)
    FIELD(L2_TXPMA_TM_9, TM_FORCE_TX_SERIALIZER_MODE, 5, 1)
    FIELD(L2_TXPMA_TM_9, TM_TX_ENABLE_HSCLK_DIVISION, 3, 2)
    FIELD(L2_TXPMA_TM_9, TM_FORCE_TX_ENABLE_HSCLK_DIVISION, 2, 1)
    FIELD(L2_TXPMA_TM_9, TM_TX_DRIVER_POLARITY, 1, 1)
    FIELD(L2_TXPMA_TM_9, TM_FORCE_TX_DRIVER_POLARITY, 0, 1)
REG32(L2_TXPMA_TM_10, 0x8828)
    FIELD(L2_TXPMA_TM_10, TXPMA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_10, ANA_MISC1_7_6_RSVD, 6, 2)
    FIELD(L2_TXPMA_TM_10, TM_TX_ENABLE_LOWLEAKAGE, 5, 1)
    FIELD(L2_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LOWLEAKAGE, 4, 1)
    FIELD(L2_TXPMA_TM_10, TM_TX_ENABLE_REF, 3, 1)
    FIELD(L2_TXPMA_TM_10, TM_FORCE_TX_ENABLE_REF, 2, 1)
    FIELD(L2_TXPMA_TM_10, TM_TX_ENABLE_LDO, 1, 1)
    FIELD(L2_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LDO, 0, 1)
REG32(L2_TXPMA_TM_11, 0x882c)
    FIELD(L2_TXPMA_TM_11, TXPMA_TM_11_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_11, ANA_VCM_BYP0_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMA_TM_11, TM_TX_VCMHOLD_PROG, 1, 4)
    FIELD(L2_TXPMA_TM_11, TM_TX_VCMHOLD_OBSRV, 0, 1)
REG32(L2_TXPMA_TM_12, 0x8830)
    FIELD(L2_TXPMA_TM_12, TXPMA_TM_12_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_12, TM_TX_SER_POWERISLAND_OBSRV, 5, 3)
    FIELD(L2_TXPMA_TM_12, TM_TX_CLK_POWERISLAND_OBSRV, 1, 4)
    FIELD(L2_TXPMA_TM_12, ANA_PWR_ISLAND_BYP0_0_RSVD, 0, 1)
REG32(L2_TXPMA_TM_13, 0x8834)
    FIELD(L2_TXPMA_TM_13, TXPMA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_13, TM_TX_POWERISLAND_OBSRV, 0, 8)
REG32(L2_TXPMA_TM_14, 0x8838)
    FIELD(L2_TXPMA_TM_14, TXPMA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_14, ANA_MISC2_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMA_TM_14, TM_TX_POWERISLAND_OBSRV, 3, 2)
    FIELD(L2_TXPMA_TM_14, PIPE_TM_TX_ANABOOST_POWER_OBSRV, 2, 1)
    FIELD(L2_TXPMA_TM_14, MPHY_TM_TX_ENABLE_DRIVERLDO_OBSRV, 1, 1)
    FIELD(L2_TXPMA_TM_14, MPHY_TM_TX_DRIVERLDO_REDC_SINKIQ, 0, 1)
REG32(L2_TXPMA_TM_15, 0x883c)
    FIELD(L2_TXPMA_TM_15, TXPMA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_15, PIPE_TM_TX_ANABOOST_PROG_7_0, 0, 8)
REG32(L2_TXPMA_TM_16, 0x8840)
    FIELD(L2_TXPMA_TM_16, TXPMA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_16, PIPE_TM_TX_ANABOOST_PROG_15_8, 0, 8)
REG32(L2_TXPMA_TM_17, 0x8844)
    FIELD(L2_TXPMA_TM_17, TXPMA_TM_17_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_17, TM_TX_RSVD2, 0, 8)
REG32(L2_TXPMA_TM_18, 0x8848)
    FIELD(L2_TXPMA_TM_18, TXPMA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_18, TM_TX_ENABLE_VDDREF_CORE, 7, 1)
    FIELD(L2_TXPMA_TM_18, TM_FORCE_TX_ENABLE_VDDREF_CORE, 6, 1)
    FIELD(L2_TXPMA_TM_18, TM_TX_ENABLE_RBYRFB_CORE, 5, 1)
    FIELD(L2_TXPMA_TM_18, TM_FORCE_TX_ENABLE_RBYRFB_CORE, 4, 1)
    FIELD(L2_TXPMA_TM_18, TM_TX_ENABLE_BGREF_CORE, 3, 1)
    FIELD(L2_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGREF_CORE, 2, 1)
    FIELD(L2_TXPMA_TM_18, TM_TX_ENABLE_BGFB_CORE, 1, 1)
    FIELD(L2_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGFB_CORE, 0, 1)
REG32(L2_TXPMA_TM_19, 0x884c)
    FIELD(L2_TXPMA_TM_19, TXPMA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_19, ANA_SATA_BYP0_RSVD, 6, 2)
    FIELD(L2_TXPMA_TM_19, TM_ZDIF_TX_SATA_OFFSET, 0, 6)
REG32(L2_TXPMA_TM_20, 0x8850)
    FIELD(L2_TXPMA_TM_20, TXPMA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_20, TM_TX_ELEC_IDLE_DELAY_ENTRY, 0, 8)
REG32(L2_TXPMA_TM_21, 0x8854)
    FIELD(L2_TXPMA_TM_21, TXPMA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_21, TM_TX_ELEC_IDLE_DELAY_EXIT, 0, 8)
REG32(L2_TXPMA_TM_22, 0x8858)
    FIELD(L2_TXPMA_TM_22, TXPMA_TM_22_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_22, TM_TX_ENABLE_LFPS_DELAY_ENTRY, 0, 8)
REG32(L2_TXPMA_TM_23, 0x885c)
    FIELD(L2_TXPMA_TM_23, TXPMA_TM_23_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_23, TM_TX_ENABLE_LFPS_DELAY_EXIT, 0, 8)
REG32(L2_TXPMA_TM_24, 0x8860)
    FIELD(L2_TXPMA_TM_24, TXPMA_TM_24_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_24, ANA_MISC6_7_RSVD, 7, 1)
    FIELD(L2_TXPMA_TM_24, TM_TX_EN_ANA_SUBLP_MODE, 6, 1)
    FIELD(L2_TXPMA_TM_24, TM_FORCE_TX_EN_ANA_SUBLP_MODE, 5, 1)
    FIELD(L2_TXPMA_TM_24, TM_TX_EN_DIG_SUBLP_MODE, 4, 1)
    FIELD(L2_TXPMA_TM_24, TM_FORCE_TX_EN_DIG_SUBLP_MODE, 3, 1)
    FIELD(L2_TXPMA_TM_24, TM_TX_DP_LVLDB0_OVRRD, 2, 1)
    FIELD(L2_TXPMA_TM_24, TM_FORCE_TX_DP_LVLDB0_OVRRD, 1, 1)
    FIELD(L2_TXPMA_TM_24, TM_TX_CLOCK_STOP_REQ, 0, 1)
REG32(L2_TXPMA_TM_25, 0x8864)
    FIELD(L2_TXPMA_TM_25, TXPMA_TM_25_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_25, ANA_MISC6_7_6_RSVD, 6, 2)
    FIELD(L2_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_PLL, 5, 1)
    FIELD(L2_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_RX, 4, 1)
    FIELD(L2_TXPMA_TM_25, TM_TX_LANE_LNG, 3, 1)
    FIELD(L2_TXPMA_TM_25, TM_FORCE_TX_LANE_LNG, 2, 1)
    FIELD(L2_TXPMA_TM_25, TM_TX_LANE_MASTER, 1, 1)
    FIELD(L2_TXPMA_TM_25, TM_FORCE_TX_LANE_MASTER, 0, 1)
REG32(L2_TXPMA_TM_26, 0x8868)
    FIELD(L2_TXPMA_TM_26, TXPMA_TM_26_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_26, TM_TXPMD_APB_RESET_DELAY, 0, 8)
REG32(L2_TXPMA_TM_27, 0x886c)
    FIELD(L2_TXPMA_TM_27, TXPMA_TM_27_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_TM_27, TM_BSCAN_MODE_EN, 7, 1)
    FIELD(L2_TXPMA_TM_27, TM_FORCE_BSCAN_MODE_EN, 6, 1)
    FIELD(L2_TXPMA_TM_27, TM_PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L2_TXPMA_TM_27, TM_FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L2_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L2_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_LFPS, 2, 1)
    FIELD(L2_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_IDLE_MODE, 1, 1)
    FIELD(L2_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L2_TXPMA_ST_0, 0x8b00)
    FIELD(L2_TXPMA_ST_0, TXPMA_ST_0_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_0, TX_PHY_MODE, 4, 4)
    FIELD(L2_TXPMA_ST_0, TX_PHY_GEAR, 0, 4)
REG32(L2_TXPMA_ST_1, 0x8b04)
    FIELD(L2_TXPMA_ST_1, TXPMA_ST_1_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_1, TX_ENABLE_HSCLK_DIVISION, 6, 2)
    FIELD(L2_TXPMA_ST_1, PIPE_TX_TRISTATE, 5, 1)
    FIELD(L2_TXPMA_ST_1, TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L2_TXPMA_ST_1, TX_ENABLE_SUPPLY_HSCLK, 3, 1)
    FIELD(L2_TXPMA_ST_1, TX_ENABLE_SUPPLY_MPHY, 2, 1)
    FIELD(L2_TXPMA_ST_1, TX_ENABLE_SUPPLY_PIPE, 1, 1)
    FIELD(L2_TXPMA_ST_1, TX_ENABLE_SUPPLY_UPHY, 0, 1)
REG32(L2_TXPMA_ST_2, 0x8b08)
    FIELD(L2_TXPMA_ST_2, TXPMA_ST_2_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_2, ANA_ST2_7_5_SPARE, 5, 3)
    FIELD(L2_TXPMA_ST_2, PIPE_TX_ENABLE_RXDET, 4, 1)
    FIELD(L2_TXPMA_ST_2, PIPE_TX_ENABLE_IDLE_MODE, 2, 2)
    FIELD(L2_TXPMA_ST_2, PIPE_TX_ENABLE_LFPS, 0, 2)
REG32(L2_TXPMA_ST_3, 0x8b0c)
    FIELD(L2_TXPMA_ST_3, TXPMA_ST_3_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_3, ANA_ST3_7_6_SPARE, 6, 2)
    FIELD(L2_TXPMA_ST_3, TX_LSEG_DN_RESCAL_CODE, 0, 6)
REG32(L2_TXPMA_ST_4, 0x8b10)
    FIELD(L2_TXPMA_ST_4, TXPMA_ST_4_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_4, ANA_ST4_7_6_SPARE, 6, 2)
    FIELD(L2_TXPMA_ST_4, TX_USEG_DP_RESCAL_CODE, 0, 6)
REG32(L2_TXPMA_ST_5, 0x8b14)
    FIELD(L2_TXPMA_ST_5, TXPMA_ST_5_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_5, ANA_ST5_7_6_SPARE, 6, 2)
    FIELD(L2_TXPMA_ST_5, PIPE_TX_LOCALFS, 0, 6)
REG32(L2_TXPMA_ST_6, 0x8b18)
    FIELD(L2_TXPMA_ST_6, TXPMA_ST_6_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_6, ANA_ST6_7_SPARE, 7, 1)
    FIELD(L2_TXPMA_ST_6, PIPE_TX_LOCALTXCOEFFICIENTSVALID, 6, 1)
    FIELD(L2_TXPMA_ST_6, PIPE_TX_LOCALLF, 0, 6)
REG32(L2_TXPMA_ST_7, 0x8b1c)
    FIELD(L2_TXPMA_ST_7, TXPMA_ST_7_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_7, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_7_0, 0, 8)
REG32(L2_TXPMA_ST_8, 0x8b20)
    FIELD(L2_TXPMA_ST_8, TXPMA_ST_8_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_8, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_15_8, 0, 8)
REG32(L2_TXPMA_ST_9, 0x8b24)
    FIELD(L2_TXPMA_ST_9, TXPMA_ST_9_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMA_ST_9, ANA_ST9_7_2_SPARE, 2, 6)
    FIELD(L2_TXPMA_ST_9, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_17_16, 0, 2)
REG32(L2_TXPMD_TM_0, 0x8c00)
    FIELD(L2_TXPMD_TM_0, TXPMD_TM_0_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_1, 0x8c04)
    FIELD(L2_TXPMD_TM_1, TXPMD_TM_1_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_2, 0x8c08)
    FIELD(L2_TXPMD_TM_2, TXPMD_TM_2_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_3, 0x8c0c)
    FIELD(L2_TXPMD_TM_3, TXPMD_TM_3_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_4, 0x8c10)
    FIELD(L2_TXPMD_TM_4, TXPMD_TM_4_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_5, 0x8c14)
    FIELD(L2_TXPMD_TM_5, TXPMD_TM_5_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_6, 0x8c18)
    FIELD(L2_TXPMD_TM_6, TXPMD_TM_6_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_7, 0x8c1c)
    FIELD(L2_TXPMD_TM_7, TXPMD_TM_7_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_8, 0x8c20)
    FIELD(L2_TXPMD_TM_8, TXPMD_TM_8_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_9, 0x8c24)
    FIELD(L2_TXPMD_TM_9, TXPMD_TM_9_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_10, 0x8c28)
    FIELD(L2_TXPMD_TM_10, TXPMD_TM_10_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_11, 0x8c2c)
    FIELD(L2_TXPMD_TM_11, TXPMD_TM_11_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_12, 0x8c30)
    FIELD(L2_TXPMD_TM_12, TXPMD_TM_12_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_13, 0x8c34)
    FIELD(L2_TXPMD_TM_13, TXPMD_TM_13_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_14, 0x8c38)
    FIELD(L2_TXPMD_TM_14, TXPMD_TM_14_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_15, 0x8c3c)
    FIELD(L2_TXPMD_TM_15, TXPMD_TM_15_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_16, 0x8c40)
    FIELD(L2_TXPMD_TM_16, TXPMD_TM_16_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_17, 0x8c44)
    FIELD(L2_TXPMD_TM_17, TXPMD_TM_17_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_18, 0x8c48)
    FIELD(L2_TXPMD_TM_18, TXPMD_TM_18_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_19, 0x8c4c)
    FIELD(L2_TXPMD_TM_19, TXPMD_TM_19_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_20, 0x8c50)
    FIELD(L2_TXPMD_TM_20, TXPMD_TM_20_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_21, 0x8c54)
    FIELD(L2_TXPMD_TM_21, TXPMD_TM_21_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_22, 0x8c58)
    FIELD(L2_TXPMD_TM_22, TXPMD_TM_22_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_23, 0x8c5c)
    FIELD(L2_TXPMD_TM_23, TXPMD_TM_23_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_24, 0x8c60)
    FIELD(L2_TXPMD_TM_24, TXPMD_TM_24_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_25, 0x8c64)
    FIELD(L2_TXPMD_TM_25, TXPMD_TM_25_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_26, 0x8c68)
    FIELD(L2_TXPMD_TM_26, TXPMD_TM_26_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_27, 0x8c6c)
    FIELD(L2_TXPMD_TM_27, TXPMD_TM_27_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_28, 0x8c70)
    FIELD(L2_TXPMD_TM_28, TXPMD_TM_28_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_29, 0x8c74)
    FIELD(L2_TXPMD_TM_29, TXPMD_TM_29_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_30, 0x8c78)
    FIELD(L2_TXPMD_TM_30, TXPMD_TM_30_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L2_TXPMD_TM_31, 0x8c7c)
    FIELD(L2_TXPMD_TM_31, TXPMD_TM_31_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L2_TXPMD_TM_32, 0x8c80)
    FIELD(L2_TXPMD_TM_32, TXPMD_TM_32_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_32, PIPE_TM_TX_PRE_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L2_TXPMD_TM_33, 0x8c84)
    FIELD(L2_TXPMD_TM_33, TXPMD_TM_33_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_33, PIPE_TM_TX_PRE_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L2_TXPMD_TM_34, 0x8c88)
    FIELD(L2_TXPMD_TM_34, TXPMD_TM_34_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_34, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L2_TXPMD_TM_35, 0x8c8c)
    FIELD(L2_TXPMD_TM_35, TXPMD_TM_35_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_35, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L2_TXPMD_TM_36, 0x8c90)
    FIELD(L2_TXPMD_TM_36, TXPMD_TM_36_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_36, PIPE_TM_TX_POST_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L2_TXPMD_TM_37, 0x8c94)
    FIELD(L2_TXPMD_TM_37, TXPMD_TM_37_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_37, PIPE_TM_TX_POST_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L2_TXPMD_TM_38, 0x8c98)
    FIELD(L2_TXPMD_TM_38, TXPMD_TM_38_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_38, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L2_TXPMD_TM_38, PIPE_TM_TX_ENABLE_SWNW_CNTRL_BYP, 6, 1)
    FIELD(L2_TXPMD_TM_38, PIPE_TM_TX_ENABLE_TRISTATE_BYP, 5, 1)
    FIELD(L2_TXPMD_TM_38, PIPE_TM_TX_TRISTATE, 4, 1)
    FIELD(L2_TXPMD_TM_38, TM_TX_DRIVERLDO_RXDET_BYP, 3, 1)
    FIELD(L2_TXPMD_TM_38, TM_TX_DRIVERLDO_IDLE_BYP, 2, 1)
    FIELD(L2_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_RXDET_BYP, 1, 1)
    FIELD(L2_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_IDLE_BYP, 0, 1)
REG32(L2_TXPMD_TM_39, 0x8c9c)
    FIELD(L2_TXPMD_TM_39, TXPMD_TM_39_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_39, ANA_MPHY_BYP0_7_3_RSVD, 3, 5)
    FIELD(L2_TXPMD_TM_39, MPHY_TM_TX_OVRD_DEEMPH_TRIM, 2, 1)
    FIELD(L2_TXPMD_TM_39, MPHY_TM_TX_ENABLE_DEEMPH, 1, 1)
    FIELD(L2_TXPMD_TM_39, MPHY_TM_TX_OVRD_ENABLE_DEEMPH, 0, 1)
REG32(L2_TXPMD_TM_40, 0x8ca0)
    FIELD(L2_TXPMD_TM_40, TXPMD_TM_40_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_40, MPHY_TM_TX_DEEMPH_TRIM_7_0, 0, 8)
REG32(L2_TXPMD_TM_41, 0x8ca4)
    FIELD(L2_TXPMD_TM_41, TXPMD_TM_41_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_41, MPHY_TM_TX_DEEMPH_TRIM_15_8, 0, 8)
REG32(L2_TXPMD_TM_42, 0x8ca8)
    FIELD(L2_TXPMD_TM_42, TXPMD_TM_42_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_42, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L2_TXPMD_TM_42, MPHY_TM_TX_OVRD_LS_DATA, 1, 4)
    FIELD(L2_TXPMD_TM_42, MPHY_TM_TX_ENABLE_OVRD_LS_DATA, 0, 1)
REG32(L2_TXPMD_TM_43, 0x8cac)
    FIELD(L2_TXPMD_TM_43, TXPMD_TM_43_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_43, ANA_MPHY_BYP4_7_4_RSVD, 4, 4)
    FIELD(L2_TXPMD_TM_43, MPHY_TM_TX_OVRD_LS_DATA_BAR, 0, 4)
REG32(L2_TXPMD_TM_44, 0x8cb0)
    FIELD(L2_TXPMD_TM_44, TXPMD_TM_44_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_44, ANA_PIPE_BYP38_7_6_RSVD, 6, 2)
    FIELD(L2_TXPMD_TM_44, PIPE_TM_TX_EN_PRE_LFPS_PATH, 5, 1)
    FIELD(L2_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_PRE_LFPS_PATH, 4, 1)
    FIELD(L2_TXPMD_TM_44, PIPE_TM_TX_EN_POST_LFPS_PATH, 3, 1)
    FIELD(L2_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_POST_LFPS_PATH, 2, 1)
    FIELD(L2_TXPMD_TM_44, PIPE_TM_TX_EN_MAIN_LFPS_PATH, 1, 1)
    FIELD(L2_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_MAIN_LFPS_PATH, 0, 1)
REG32(L2_TXPMD_TM_45, 0x8cb4)
    FIELD(L2_TXPMD_TM_45, TXPMD_TM_45_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_45, ANA_DP_BYP0_7_6_RSVD, 6, 2)
    FIELD(L2_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST2_PATH, 5, 1)
    FIELD(L2_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST2_PATH, 4, 1)
    FIELD(L2_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST1_PATH, 3, 1)
    FIELD(L2_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST1_PATH, 2, 1)
    FIELD(L2_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L2_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_MAIN_PATH, 0, 1)
REG32(L2_TXPMD_TM_46, 0x8cb8)
    FIELD(L2_TXPMD_TM_46, TXPMD_TM_46_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_46, ANA_PIPE_BYP39_7_6_RSVD, 6, 2)
    FIELD(L2_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_PRE_PATH, 5, 1)
    FIELD(L2_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_PRE_PATH, 4, 1)
    FIELD(L2_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_POST_PATH, 3, 1)
    FIELD(L2_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_POST_PATH, 2, 1)
    FIELD(L2_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L2_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_MAIN_PATH, 0, 1)
REG32(L2_TXPMD_TM_47, 0x8cbc)
    FIELD(L2_TXPMD_TM_47, TXPMD_TM_47_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_47, TM_TX_RSVD1, 0, 8)
REG32(L2_TXPMD_TM_48, 0x8cc0)
    FIELD(L2_TXPMD_TM_48, TXPMD_TM_48_31_8_RSVD, 24, 8)
    FIELD(L2_TXPMD_TM_48, ANA_MISC2_7_6_RSVD, 6, 2)
    FIELD(L2_TXPMD_TM_48, TM_FORCE_RESULTANT_MARGINING_FACTOR, 5, 1)
    FIELD(L2_TXPMD_TM_48, TM_RESULTANT_MARGINING_FACTOR, 0, 5)
REG32(L2_TM_ANA_BYP_1, 0x9004)
    FIELD(L2_TM_ANA_BYP_1, TM_ANA_BYP_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_1, MPHY_PWM_DES_PDZ, 7, 1)
    FIELD(L2_TM_ANA_BYP_1, FORCE_MPHY_PWM_DES_PDZ, 6, 1)
    FIELD(L2_TM_ANA_BYP_1, MPHY_PWMB_SYS_ENABLE, 5, 1)
    FIELD(L2_TM_ANA_BYP_1, FORCE_MPHY_PWMB_SYS_ENABLE, 4, 1)
    FIELD(L2_TM_ANA_BYP_1, MPHY_PSO_SQUELCH, 3, 1)
    FIELD(L2_TM_ANA_BYP_1, FORCE_MPHY_PSO_SQUELCH, 2, 1)
    FIELD(L2_TM_ANA_BYP_1, MPHY_PSO_LSRX, 1, 1)
    FIELD(L2_TM_ANA_BYP_1, FORCE_MPHY_PSO_LSRX, 0, 1)
REG32(L2_TM_ANA_BYP_2, 0x9008)
    FIELD(L2_TM_ANA_BYP_2, TM_ANA_BYP_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_2, MPHY_PWM_LSPREAMP_PD, 7, 1)
    FIELD(L2_TM_ANA_BYP_2, FORCE_MPHY_PWM_LSPREAMP_PD, 6, 1)
    FIELD(L2_TM_ANA_BYP_2, MPHY_PWM_GEAR_SEL, 3, 3)
    FIELD(L2_TM_ANA_BYP_2, FORCE_MPHY_PWM_GEAR_SEL, 2, 1)
    FIELD(L2_TM_ANA_BYP_2, MPHY_PWM_DET_PD, 1, 1)
    FIELD(L2_TM_ANA_BYP_2, FORCE_MPHY_PWM_DET_PD, 0, 1)
REG32(L2_TM_ANA_BYP_3, 0x900c)
    FIELD(L2_TM_ANA_BYP_3, TM_ANA_BYP_3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_3, MPHY_RX_MASK_BURST_START, 7, 1)
    FIELD(L2_TM_ANA_BYP_3, FORCE_MPHY_RX_MASK_BURST_START, 6, 1)
    FIELD(L2_TM_ANA_BYP_3, MPHY_RX_GATE_SYMBOL_CLK, 5, 1)
    FIELD(L2_TM_ANA_BYP_3, FORCE_MPHY_RX_GATE_SYMBOL_CLK, 4, 1)
    FIELD(L2_TM_ANA_BYP_3, MPHY_PWM_PREAMP_BIAS_PD, 3, 1)
    FIELD(L2_TM_ANA_BYP_3, FORCE_MPHY_PWM_PREAMP_BIAS_PD, 2, 1)
    FIELD(L2_TM_ANA_BYP_3, MPHY_PWM_LSPREAMP_STANDBYSLEEPSTALL, 1, 1)
    FIELD(L2_TM_ANA_BYP_3, FORCE_MPHY_PWM_LSPREAMP_STANDBYSLEEPSTAL, 0, 1)
REG32(L2_TM_ANA_BYP_4, 0x9010)
    FIELD(L2_TM_ANA_BYP_4, TM_ANA_BYP_4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_4, HSRX_RSTB, 7, 1)
    FIELD(L2_TM_ANA_BYP_4, FORCE_HSRX_RSTB, 6, 1)
    FIELD(L2_TM_ANA_BYP_4, MPHY_RX_TERM_ENABLE, 5, 1)
    FIELD(L2_TM_ANA_BYP_4, FORCE_MPHY_RX_TERM_ENABLE, 4, 1)
    FIELD(L2_TM_ANA_BYP_4, MPHY_RX_MUX_TYP1B_TYP2, 3, 1)
    FIELD(L2_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_TYP1B_TYP2, 2, 1)
    FIELD(L2_TM_ANA_BYP_4, MPHY_RX_MUX_HSB_LS, 1, 1)
    FIELD(L2_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_HSB_LS, 0, 1)
REG32(L2_TM_ANA_BYP_5, 0x9014)
    FIELD(L2_TM_ANA_BYP_5, TM_ANA_BYP_5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_5, MPHY_SQ_SWAP_POLARITY, 5, 1)
    FIELD(L2_TM_ANA_BYP_5, FORCE_MPHY_SQ_SWAP_POLARITY, 4, 1)
    FIELD(L2_TM_ANA_BYP_5, MPHY_SQ_PD, 3, 1)
    FIELD(L2_TM_ANA_BYP_5, FORCE_MPHY_SQ_PD, 2, 1)
    FIELD(L2_TM_ANA_BYP_5, MPHY_SQ_DETECTOR_PD, 1, 1)
    FIELD(L2_TM_ANA_BYP_5, FORCE_MPHY_SQ_DETECTOR_PD, 0, 1)
REG32(L2_TM_ANA_BYP_7, 0x9018)
    FIELD(L2_TM_ANA_BYP_7, TM_ANA_BYP_7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_7, PIPE_RXEQTRAINING, 7, 1)
    FIELD(L2_TM_ANA_BYP_7, FORCE_PIPE_RXEQTRAINING, 6, 1)
    FIELD(L2_TM_ANA_BYP_7, PIPE_RX_TERM_ENABLE, 5, 1)
    FIELD(L2_TM_ANA_BYP_7, FORCE_PIPE_RX_TERM_ENABLE, 4, 1)
REG32(L2_TM_ANA_BYP_8, 0x901c)
    FIELD(L2_TM_ANA_BYP_8, TM_ANA_BYP_8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 7, 1)
    FIELD(L2_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 6, 1)
    FIELD(L2_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 5, 1)
    FIELD(L2_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 4, 1)
    FIELD(L2_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 3, 1)
    FIELD(L2_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 2, 1)
    FIELD(L2_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 1, 1)
    FIELD(L2_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 0, 1)
REG32(L2_TM_ANA_BYP_9, 0x9020)
    FIELD(L2_TM_ANA_BYP_9, TM_ANA_BYP_9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_9, UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 7, 1)
    FIELD(L2_TM_ANA_BYP_9, FORCE_UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 6, 1)
    FIELD(L2_TM_ANA_BYP_9, UPHY_PSO_SAMP_LPBK, 5, 1)
    FIELD(L2_TM_ANA_BYP_9, FORCE_UPHY_PSO_SAMP_LPBK, 4, 1)
    FIELD(L2_TM_ANA_BYP_9, UPHY_EQ_LPBK_ENABLE_CORE, 3, 1)
    FIELD(L2_TM_ANA_BYP_9, FORCE_UPHY_EQ_LPBK_ENABLE_CORE, 2, 1)
    FIELD(L2_TM_ANA_BYP_9, UPHY_EQ_AC_DCZ_COUPLED_CORE, 1, 1)
    FIELD(L2_TM_ANA_BYP_9, FORCE_UPHY_EQ_AC_DCZ_COUPLED_CORE, 0, 1)
REG32(L2_TM_ANA_BYP_10, 0x9024)
    FIELD(L2_TM_ANA_BYP_10, TM_ANA_BYP_10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_10, UPHY_LPBK_CLK_DATA_SEL, 5, 1)
    FIELD(L2_TM_ANA_BYP_10, UPHY_LPBK_CENTRE_EDGEZ_ENABLE_CORE, 4, 1)
    FIELD(L2_TM_ANA_BYP_10, UPHY_HSRX_LPBK_SEL, 1, 3)
    FIELD(L2_TM_ANA_BYP_10, FORCE_UPHY_HSRX_LPBK_SEL, 0, 1)
REG32(L2_TM_ANA_BYP_11, 0x9028)
    FIELD(L2_TM_ANA_BYP_11, TM_ANA_BYP_11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_11, UPHY_PD_PI_DIV_PATH, 5, 1)
    FIELD(L2_TM_ANA_BYP_11, UPHY_PSO_CLK_LANE, 4, 1)
    FIELD(L2_TM_ANA_BYP_11, FORCE_UPHY_PSO_CLK_LANE, 3, 1)
    FIELD(L2_TM_ANA_BYP_11, UPHY_HSCLK_DIVISION_FACTOR, 1, 2)
    FIELD(L2_TM_ANA_BYP_11, FORCE_UPHY_HSCLK_DIVISION_FACTOR, 0, 1)
REG32(L2_TM_ANA_BYP_12, 0x902c)
    FIELD(L2_TM_ANA_BYP_12, TM_ANA_BYP_12_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_12, UPHY_PSO_HSRXDIG, 7, 1)
    FIELD(L2_TM_ANA_BYP_12, FORCE_UPHY_PSO_HSRXDIG, 6, 1)
    FIELD(L2_TM_ANA_BYP_12, UPHY_PDN_HS_DES, 5, 1)
    FIELD(L2_TM_ANA_BYP_12, FORCE_UPHY_PDN_HS_DES, 4, 1)
    FIELD(L2_TM_ANA_BYP_12, UPHY_RST_GF_MUX, 3, 1)
    FIELD(L2_TM_ANA_BYP_12, FORCE_UPHY_RST_GF_MUX, 2, 1)
    FIELD(L2_TM_ANA_BYP_12, UPHY_ENABLE_CDR, 1, 1)
    FIELD(L2_TM_ANA_BYP_12, FORCE_UPHY_ENABLE_CDR, 0, 1)
REG32(L2_TM_ANA_BYP_13, 0x9030)
    FIELD(L2_TM_ANA_BYP_13, TM_ANA_BYP_13_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_13, UPHY_PSO_SAMP_FLOPS, 1, 1)
    FIELD(L2_TM_ANA_BYP_13, FORCE_UPHY_PSO_SAMP_FLOPS, 0, 1)
REG32(L2_TM_ANA_BYP_14, 0x9034)
    FIELD(L2_TM_ANA_BYP_14, TM_ANA_BYP_14_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_14, UPHY_PSO_EPI, 7, 1)
    FIELD(L2_TM_ANA_BYP_14, FORCE_UPHY_PSO_EPI, 6, 1)
    FIELD(L2_TM_ANA_BYP_14, UPHY_PD_SAMP_C2C_ECLK, 5, 1)
    FIELD(L2_TM_ANA_BYP_14, FORCE_UPHY_PD_SAMP_C2C_ECLK, 4, 1)
    FIELD(L2_TM_ANA_BYP_14, UPHY_PSO_IQPI, 1, 1)
    FIELD(L2_TM_ANA_BYP_14, FORCE_UPHY_PSO_IQPI, 0, 1)
REG32(L2_TM_ANA_BYP_15, 0x9038)
    FIELD(L2_TM_ANA_BYP_15, TM_ANA_BYP_15_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_15, UPHY_ENABLE_LOW_LEAKAGE, 7, 1)
    FIELD(L2_TM_ANA_BYP_15, FORCE_UPHY_ENABLE_LOW_LEAKAGE, 6, 1)
    FIELD(L2_TM_ANA_BYP_15, UPHY_PD_SAMP_C2C, 5, 1)
    FIELD(L2_TM_ANA_BYP_15, FORCE_UPHY_PD_SAMP_C2C, 4, 1)
    FIELD(L2_TM_ANA_BYP_15, UPHY_PSO_CORE_EQ, 3, 1)
    FIELD(L2_TM_ANA_BYP_15, FORCE_UPHY_PSO_CORE_EQ, 2, 1)
    FIELD(L2_TM_ANA_BYP_15, UPHY_PSO_IO_EQ, 1, 1)
    FIELD(L2_TM_ANA_BYP_15, FORCE_UPHY_PSO_IO_EQ, 0, 1)
REG32(L2_TM_ANA_BYP_16, 0x903c)
    FIELD(L2_TM_ANA_BYP_16, TM_ANA_BYP_16_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_16, UPHY_PSO_SIGDET, 7, 1)
    FIELD(L2_TM_ANA_BYP_16, FORCE_UPHY_PSO_SIGDET, 6, 1)
    FIELD(L2_TM_ANA_BYP_16, UPHY_RX_LANE_POLARITY_SWAP, 5, 1)
    FIELD(L2_TM_ANA_BYP_16, FORCE_UPHY_RX_LANE_POLARITY_SWAP, 4, 1)
    FIELD(L2_TM_ANA_BYP_16, UPHY_RUN_CALIB, 3, 1)
    FIELD(L2_TM_ANA_BYP_16, FORCE_UPHY_RUN_CALIB, 2, 1)
    FIELD(L2_TM_ANA_BYP_16, UPHY_RESTORE_CALCODE, 1, 1)
    FIELD(L2_TM_ANA_BYP_16, FORCE_UPHY_RESTORE_CALCODE, 0, 1)
REG32(L2_TM_ANA_BYP_17, 0x9040)
    FIELD(L2_TM_ANA_BYP_17, TM_ANA_BYP_17_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_17, UPHY_STARTLOOP_PLL, 6, 1)
    FIELD(L2_TM_ANA_BYP_17, FORCE_UPHY_STARTLOOP_PLL, 5, 1)
    FIELD(L2_TM_ANA_BYP_17, UPHY_RX_RESCALIB_CODE, 1, 4)
    FIELD(L2_TM_ANA_BYP_17, FORCE_UPHY_RX_RESCALIB_CODE, 0, 1)
REG32(L2_TM_ANA_BYP_18, 0x9044)
    FIELD(L2_TM_ANA_BYP_18, TM_ANA_BYP_18_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_18, FORCE_UPHY_RESTORE_CALCODE_DATA, 3, 1)
    FIELD(L2_TM_ANA_BYP_18, FORCE_UPHY_RX_PMA_OPMODE, 2, 1)
    FIELD(L2_TM_ANA_BYP_18, UPHY_PSO_LFPSBCN, 1, 1)
    FIELD(L2_TM_ANA_BYP_18, FORCE_UPHY_PSO_LFPSBCN, 0, 1)
REG32(L2_TM_ANA_BYP_20, 0x9048)
    FIELD(L2_TM_ANA_BYP_20, TM_ANA_BYP_20_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_20, UPHY_RX_PMA_OPMODE, 0, 8)
REG32(L2_TM_ANA_BYP_21, 0x904c)
    FIELD(L2_TM_ANA_BYP_21, TM_ANA_BYP_21_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_21, UPHY_RESTORE_CALCODE_DATA, 0, 8)
REG32(L2_TM_ANA_BYP_22, 0x9050)
    FIELD(L2_TM_ANA_BYP_22, TM_ANA_BYP_22_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_22, ISO_HSRX_CTRL_BAR, 7, 1)
    FIELD(L2_TM_ANA_BYP_22, FORCE_ISO_HSRX_CTRL_BAR, 6, 1)
    FIELD(L2_TM_ANA_BYP_22, HSRX_CLOCK_STOP_REQ, 5, 1)
    FIELD(L2_TM_ANA_BYP_22, FORCE_HSRX_CLOCK_STOP_REQ, 4, 1)
    FIELD(L2_TM_ANA_BYP_22, UPHY_SBRX_RUN_CALIB, 3, 1)
    FIELD(L2_TM_ANA_BYP_22, FORCE_UPHY_SBRX_RUN_CALIB, 2, 1)
    FIELD(L2_TM_ANA_BYP_22, RXPMA_RSTB, 1, 1)
    FIELD(L2_TM_ANA_BYP_22, FORCE_RXPMA_RSTB, 0, 1)
REG32(L2_TM_ANA_BYP_23, 0x9054)
    FIELD(L2_TM_ANA_BYP_23, TM_ANA_BYP_23_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_BYP_23, ISO_SIGDET_CTRL_BAR, 7, 1)
    FIELD(L2_TM_ANA_BYP_23, FORCE_ISO_SIGDET_CTRL_BAR, 6, 1)
    FIELD(L2_TM_ANA_BYP_23, ISO_LFPS_CTRL_BAR, 5, 1)
    FIELD(L2_TM_ANA_BYP_23, FORCE_ISO_LFPS_CTRL_BAR, 4, 1)
    FIELD(L2_TM_ANA_BYP_23, ISO_MPHY_LSRX_CTRL_BAR, 3, 1)
    FIELD(L2_TM_ANA_BYP_23, FORCE_ISO_MPHY_LSRX_CTRL_BAR, 2, 1)
    FIELD(L2_TM_ANA_BYP_23, ISO_MPHY_SQUELCH_CTRL_BAR, 1, 1)
    FIELD(L2_TM_ANA_BYP_23, FORCE_ISO_MPHY_SQUELCH_CTRL_BAR, 0, 1)
REG32(L2_TM_DIG_1, 0x9058)
    FIELD(L2_TM_DIG_1, TM_DIG_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_1, EN_TXRX_DIFGEAR, 7, 1)
    FIELD(L2_TM_DIG_1, MPHY_HS_TERM_PT_SEL, 6, 1)
    FIELD(L2_TM_DIG_1, TX_ALLOW_INLNCFG_FROM_TOP, 5, 1)
    FIELD(L2_TM_DIG_1, BYPASS_MARKER_DETECTOR, 4, 1)
    FIELD(L2_TM_DIG_1, BYPASS_EXIT_VAL, 0, 4)
REG32(L2_TM_DIG_2, 0x905c)
    FIELD(L2_TM_DIG_2, TM_DIG_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_2, MPHY_SYM_STATE, 1, 5)
    FIELD(L2_TM_DIG_2, FORCE_MPHY_SYM_STATE, 0, 1)
REG32(L2_TM_DIG_3, 0x9060)
    FIELD(L2_TM_DIG_3, TM_DIG_3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_3, MPHY_SQUELCH_DETECT, 7, 1)
    FIELD(L2_TM_DIG_3, FORCE_MPHY_SQUELCH_DETECT, 6, 1)
    FIELD(L2_TM_DIG_3, MPHY_CFG_STATE, 1, 5)
    FIELD(L2_TM_DIG_3, FORCE_MPHY_CFG_STATE, 0, 1)
REG32(L2_TM_DIG_4, 0x9064)
    FIELD(L2_TM_DIG_4, TM_DIG_4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_4, STATUS_REG_VAL, 4, 4)
    FIELD(L2_TM_DIG_4, READ_SHADOW, 3, 1)
REG32(L2_TM_DIG_5, 0x9068)
    FIELD(L2_TM_DIG_5, TM_DIG_5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_5, SYMBOL_CLK_ALWAYS_ON_N, 2, 1)
    FIELD(L2_TM_DIG_5, BYPASS_DIFN_DETECT, 1, 1)
    FIELD(L2_TM_DIG_5, HIBERN8_CTRL, 0, 1)
REG32(L2_TM_DIG_6, 0x906c)
    FIELD(L2_TM_DIG_6, TM_DIG_6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_6, FORCE_BYPASS_ON_ERR, 6, 1)
    FIELD(L2_TM_DIG_6, SUPPRESS_ERR, 5, 1)
    FIELD(L2_TM_DIG_6, BYPASS_OHC, 4, 1)
    FIELD(L2_TM_DIG_6, BYPASS_DECODER, 3, 1)
    FIELD(L2_TM_DIG_6, FORCE_BYPASS_DEC, 2, 1)
    FIELD(L2_TM_DIG_6, BYPASS_DESCRAM, 1, 1)
    FIELD(L2_TM_DIG_6, FORCE_BYPASS_DESCRAM, 0, 1)
REG32(L2_TM_DIG_7, 0x9070)
    FIELD(L2_TM_DIG_7, TM_DIG_7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_7, BYPASS_ON_ERR_CHAR, 0, 8)
REG32(L2_TM_DIG_8, 0x9074)
    FIELD(L2_TM_DIG_8, TM_DIG_8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_8, EYESURF_ENABLE, 4, 1)
    FIELD(L2_TM_DIG_8, USE_EB_IN_MPHY, 3, 1)
    FIELD(L2_TM_DIG_8, BYPASS_EB, 2, 1)
    FIELD(L2_TM_DIG_8, EB_MODE, 1, 1)
    FIELD(L2_TM_DIG_8, FORCE_EB_MODE, 0, 1)
REG32(L2_TM_DIG_9, 0x9078)
    FIELD(L2_TM_DIG_9, TM_DIG_9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_9, FLIP_ENDIAN, 3, 1)
    FIELD(L2_TM_DIG_9, DEC_ERR_CNT_THRESHOLD, 0, 3)
REG32(L2_TM_DIG_10, 0x907c)
    FIELD(L2_TM_DIG_10, TM_DIG_10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_10, CDR_BIT_LOCK_TIME, 0, 4)
REG32(L2_TM_DIG_11, 0x9080)
    FIELD(L2_TM_DIG_11, TM_DIG_11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_11, BYPASS_CDR_ERR_MASK, 7, 1)
    FIELD(L2_TM_DIG_11, SYMB_ERR_SEL, 5, 2)
    FIELD(L2_TM_DIG_11, SYMB_ERR, 4, 1)
REG32(L2_TM_DIG_12, 0x9084)
    FIELD(L2_TM_DIG_12, TM_DIG_12_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_12, FLIP_ENDIAN_EB_DATA_OUT, 5, 1)
    FIELD(L2_TM_DIG_12, FLIP_ENDIAN_EB_DATA_IN, 4, 1)
    FIELD(L2_TM_DIG_12, OVERFLOW_BYP, 3, 1)
    FIELD(L2_TM_DIG_12, UNDERFLOW_BYP, 2, 1)
    FIELD(L2_TM_DIG_12, OVERFLOW_BYP_VAL, 1, 1)
    FIELD(L2_TM_DIG_12, UNDERFLOW_BYP_VAL, 0, 1)
REG32(L2_TM_DIG_13, 0x9088)
    FIELD(L2_TM_DIG_13, TM_DIG_13_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_13, OMC_PRESENTN, 6, 1)
    FIELD(L2_TM_DIG_13, CFG_CLK_FREQ, 0, 6)
REG32(L2_TM_DIG_14, 0x908c)
    FIELD(L2_TM_DIG_14, TM_DIG_14_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_14, LFPS_OUTPUT_SEL, 6, 2)
    FIELD(L2_TM_DIG_14, LFPS_STRETCH, 4, 2)
REG32(L2_TM_DIG_15, 0x9090)
    FIELD(L2_TM_DIG_15, TM_DIG_15_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_15, FORCE_LFPS_FILTER_THRESH, 5, 1)
    FIELD(L2_TM_DIG_15, LFPS_FILTER_THRESH, 0, 5)
REG32(L2_TM_DIG_16, 0x9094)
    FIELD(L2_TM_DIG_16, TM_DIG_16_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_16, TESTDIGOUT_SEL, 1, 4)
    FIELD(L2_TM_DIG_16, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L2_TM_DIG_17, 0x9098)
    FIELD(L2_TM_DIG_17, TM_DIG_17_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_17, FORCE_SATA_RX_VALID_CNT, 4, 1)
    FIELD(L2_TM_DIG_17, SATA_RX_VALID_CNT, 0, 4)
REG32(L2_TM_DIG_18, 0x909c)
    FIELD(L2_TM_DIG_18, TM_DIG_18_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_18, CLK_DIST_SETTLE_TIME, 4, 4)
    FIELD(L2_TM_DIG_18, BIASGEN_SETTLE_TIME, 0, 4)
REG32(L2_TM_DIG_19, 0x90a0)
    FIELD(L2_TM_DIG_19, TM_DIG_19_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_19, HSRX_ANA_SETTLE_TIME, 4, 4)
    FIELD(L2_TM_DIG_19, SBRX_ANA_SETTLE_TIME, 0, 4)
REG32(L2_TM_DIG_20, 0x90a4)
    FIELD(L2_TM_DIG_20, TM_DIG_20_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_20, HSRX_COOLING_TIME, 3, 4)
    FIELD(L2_TM_DIG_20, FORCE_RX_CAL, 2, 1)
    FIELD(L2_TM_DIG_20, BYPASS_HSRX_CAL, 1, 1)
    FIELD(L2_TM_DIG_20, BYPASS_SBRX_CAL, 0, 1)
REG32(L2_TM_DIG_21, 0x90a8)
    FIELD(L2_TM_DIG_21, TM_DIG_21_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_21, COMMA_LOCATION_RST, 4, 1)
    FIELD(L2_TM_DIG_21, SSC_WAIT_CNT, 2, 2)
    FIELD(L2_TM_DIG_21, COMMA_PRE_LOCK_THRESH, 0, 2)
REG32(L2_TM_DIG_22, 0x90ac)
    FIELD(L2_TM_DIG_22, TM_DIG_22_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_22, DIS_DEFAULT_CDR_GATE_LOGIC, 5, 1)
    FIELD(L2_TM_DIG_22, INV_POL_SIGDET_HIGH, 4, 1)
    FIELD(L2_TM_DIG_22, INV_POL_SIGDET_LOW, 3, 1)
    FIELD(L2_TM_DIG_22, SIGDET_LFPS_BAR_EN, 2, 1)
    FIELD(L2_TM_DIG_22, OBSRV_SIGDET_OUTPUT, 1, 1)
    FIELD(L2_TM_DIG_22, RX_SIGDET_EN, 0, 1)
REG32(L2_TM_DIG_23, 0x90b0)
    FIELD(L2_TM_DIG_23, TM_DIG_23_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_23, DELAY_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L2_TM_DIG_23, FORCE_RX_SIGDET_SEL, 5, 1)
    FIELD(L2_TM_DIG_23, RX_SIGDET_SEL_VAL, 4, 1)
    FIELD(L2_TM_DIG_23, FORCE_RX_SIG_DET_FILT_FUNC_SEL, 3, 1)
    FIELD(L2_TM_DIG_23, RX_SIG_DET_FILT_FUNC_SEL, 0, 3)
REG32(L2_TM_DIG_24, 0x90b4)
    FIELD(L2_TM_DIG_24, TM_DIG_24_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_24, FILTER_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L2_TM_DIG_24, MIN_TIMER_LOAD_VAL_HIGH_1, 4, 2)
    FIELD(L2_TM_DIG_24, FILTER_TIMER_LOAD_VAL_LOW_1, 2, 2)
    FIELD(L2_TM_DIG_24, MIN_TIMER_LOAD_VAL_LOW_1, 0, 2)
REG32(L2_TM_DIG_25, 0x90b8)
    FIELD(L2_TM_DIG_25, TM_DIG_25_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_25, FILTER_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L2_TM_DIG_26, 0x90bc)
    FIELD(L2_TM_DIG_26, TM_DIG_26_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_26, DELAY_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L2_TM_DIG_27, 0x90c0)
    FIELD(L2_TM_DIG_27, TM_DIG_27_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_27, MIN_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L2_TM_DIG_28, 0x90c4)
    FIELD(L2_TM_DIG_28, TM_DIG_28_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_28, FILTER_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L2_TM_DIG_29, 0x90c8)
    FIELD(L2_TM_DIG_29, TM_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_29, MIN_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L2_TM_AUX_0, 0x90cc)
    FIELD(L2_TM_AUX_0, TM_AUX_0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_AUX_0, BIT_0, 7, 1)
    FIELD(L2_TM_AUX_0, BIT_1, 6, 1)
    FIELD(L2_TM_AUX_0, BIT_2, 5, 1)
    FIELD(L2_TM_AUX_0, BIT_3, 4, 1)
    FIELD(L2_TM_AUX_0, BIT_4, 3, 1)
    FIELD(L2_TM_AUX_0, BIT_5, 2, 1)
    FIELD(L2_TM_AUX_0, BIT_6, 1, 1)
    FIELD(L2_TM_AUX_0, BIT_7, 0, 1)
REG32(L2_TM_AUX_1, 0x90d0)
    FIELD(L2_TM_AUX_1, TM_AUX_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_AUX_1, BIT_0, 7, 1)
    FIELD(L2_TM_AUX_1, BIT_1, 6, 1)
    FIELD(L2_TM_AUX_1, BIT_2, 5, 1)
    FIELD(L2_TM_AUX_1, BIT_3, 4, 1)
    FIELD(L2_TM_AUX_1, BIT_4, 3, 1)
    FIELD(L2_TM_AUX_1, BIT_5, 2, 1)
    FIELD(L2_TM_AUX_1, BIT_6, 1, 1)
    FIELD(L2_TM_AUX_1, BIT_7, 0, 1)
REG32(L2_TM_AUX_2, 0x90d4)
    FIELD(L2_TM_AUX_2, TM_AUX_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_AUX_2, BIT_0, 7, 1)
    FIELD(L2_TM_AUX_2, BIT_1, 6, 1)
    FIELD(L2_TM_AUX_2, BIT_2, 5, 1)
    FIELD(L2_TM_AUX_2, BIT_3, 4, 1)
    FIELD(L2_TM_AUX_2, BIT_4, 3, 1)
    FIELD(L2_TM_AUX_2, BIT_5, 2, 1)
    FIELD(L2_TM_AUX_2, BIT_6, 1, 1)
    FIELD(L2_TM_AUX_2, BIT_7, 0, 1)
REG32(L2_TM_AUX_3, 0x90d8)
    FIELD(L2_TM_AUX_3, TM_AUX_3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_AUX_3, BIT_0, 7, 1)
    FIELD(L2_TM_AUX_3, BIT_1, 6, 1)
    FIELD(L2_TM_AUX_3, BIT_2, 5, 1)
    FIELD(L2_TM_AUX_3, BIT_3, 4, 1)
    FIELD(L2_TM_AUX_3, BIT_4, 3, 1)
    FIELD(L2_TM_AUX_3, BIT_5, 2, 1)
    FIELD(L2_TM_AUX_3, BIT_6, 1, 1)
    FIELD(L2_TM_AUX_3, BIT_7, 0, 1)
REG32(L2_TM_AUX_4, 0x90dc)
    FIELD(L2_TM_AUX_4, TM_AUX_4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_AUX_4, BIT_0, 7, 1)
    FIELD(L2_TM_AUX_4, BIT_1, 6, 1)
    FIELD(L2_TM_AUX_4, BIT_2, 5, 1)
    FIELD(L2_TM_AUX_4, BIT_3, 4, 1)
    FIELD(L2_TM_AUX_4, BIT_4, 3, 1)
    FIELD(L2_TM_AUX_4, BIT_5, 2, 1)
    FIELD(L2_TM_AUX_4, BIT_6, 1, 1)
    FIELD(L2_TM_AUX_4, BIT_7, 0, 1)
REG32(L2_TM_DIG_30, 0x90e0)
    FIELD(L2_TM_DIG_30, TM_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_30, SD_LD_BAR_FILTER_TIME_VAL_1, 4, 2)
    FIELD(L2_TM_DIG_30, SD_LD_BAR_DLY_TIME_VAL_1, 2, 2)
    FIELD(L2_TM_DIG_30, SD_LD_BAR_MIN_TIMER_VAL_1, 0, 2)
REG32(L2_TM_DIG_31, 0x90e4)
    FIELD(L2_TM_DIG_31, TM_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_31, SD_LD_BAR_FILTER_TIME_VAL_0, 0, 8)
REG32(L2_TM_DIG_32, 0x90e8)
    FIELD(L2_TM_DIG_32, TM_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_32, SD_LD_BAR_DLY_TIME_VAL_0, 0, 8)
REG32(L2_TM_DIG_33, 0x90ec)
    FIELD(L2_TM_DIG_33, TM_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_33, SD_LD_BAR_MIN_TIMER_VAL_0, 0, 8)
REG32(L2_TM_DIG_34, 0x90f0)
    FIELD(L2_TM_DIG_34, TM_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_34, SATA_JUNK_DATA_TIMEOUT_VAL, 0, 6)
REG32(L2_TM_DIG_35, 0x90f4)
    FIELD(L2_TM_DIG_35, TM_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_35, SATA_CDR_LOCK_WAIT_TIMEOUT_VAL, 0, 6)
REG32(L2_TM_DIG_36, 0x90f8)
    FIELD(L2_TM_DIG_36, TM_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_36, COM_DET_THRESH_VAL_0, 0, 8)
REG32(L2_TM_DIG_37, 0x90fc)
    FIELD(L2_TM_DIG_37, TM_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DIG_37, FORCE_COM_DETECT_THRESH, 4, 1)
    FIELD(L2_TM_DIG_37, COM_DET_THRESH_VAL_1, 0, 4)
REG32(L2_TM_LFPS_1, 0x9800)
    FIELD(L2_TM_LFPS_1, TM_LFPS_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_LFPS_1, PROG_REFP, 4, 4)
    FIELD(L2_TM_LFPS_1, PROG_REFM, 0, 4)
REG32(L2_TM_LFPS_2, 0x9804)
    FIELD(L2_TM_LFPS_2, TM_LFPS_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_LFPS_2, PROG_VCM, 4, 3)
    FIELD(L2_TM_LFPS_2, PROG_FILTER_CAP, 0, 4)
REG32(L2_TM_LFPS_3, 0x9808)
    FIELD(L2_TM_LFPS_3, TM_LFPS_3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_LFPS_3, PROG_C2, 5, 3)
    FIELD(L2_TM_LFPS_3, PROG_C1, 2, 3)
    FIELD(L2_TM_LFPS_3, PROG_PADINTF, 0, 2)
REG32(L2_TM_LFPS_4, 0x980c)
    FIELD(L2_TM_LFPS_4, TM_LFPS_4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_LFPS_4, TESTBIT, 0, 6)
REG32(L2_TM_RXPMA_1, 0x9810)
    FIELD(L2_TM_RXPMA_1, TM_RXPMA_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_RXPMA_1, UPHY_TESTBIT, 0, 8)
REG32(L2_TM_BSCAN_1, 0x9814)
    FIELD(L2_TM_BSCAN_1, TM_BSCAN_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BSCAN_1, BSCAN_LPF_RES, 0, 3)
REG32(L2_TM_MPHY_SQ_1, 0x9818)
    FIELD(L2_TM_MPHY_SQ_1, TM_MPHY_SQ_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MPHY_SQ_1, TB_REDUCE_OFFSET, 4, 1)
    FIELD(L2_TM_MPHY_SQ_1, TB_INCREASE_OFFSET, 3, 1)
    FIELD(L2_TM_MPHY_SQ_1, TB_DRIVE_RES_SEL, 1, 2)
    FIELD(L2_TM_MPHY_SQ_1, TB_BYPASS_HYST, 0, 1)
REG32(L2_TM_LSRX_1, 0x981c)
    FIELD(L2_TM_LSRX_1, TM_LSRX_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_LSRX_1, LSRX_TESTBITS_0, 0, 8)
REG32(L2_TM_LSRX_2, 0x9820)
    FIELD(L2_TM_LSRX_2, TM_LSRX_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_LSRX_2, LSRX_TESTBITS_1, 0, 6)
REG32(L2_TM_SIGDET_1, 0x9824)
    FIELD(L2_TM_SIGDET_1, TM_SIGDET_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SIGDET_1, BIASTRIM, 4, 3)
    FIELD(L2_TM_SIGDET_1, RELIABPROT, 2, 2)
    FIELD(L2_TM_SIGDET_1, STRESSPORT, 0, 2)
REG32(L2_TM_SIGDET_2, 0x9828)
    FIELD(L2_TM_SIGDET_2, TM_SIGDET_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SIGDET_2, VSENSETRIM, 0, 8)
REG32(L2_TM_DFT_1, 0x982c)
    FIELD(L2_TM_DFT_1, TM_DFT_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_1, LFPS_DFT_SEL_P, 4, 4)
    FIELD(L2_TM_DFT_1, LFPS_DFT_ENABLE, 3, 1)
REG32(L2_TM_DFT_2, 0x9830)
    FIELD(L2_TM_DFT_2, TM_DFT_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_2, SIGDET_DFT_SEL_P, 0, 3)
REG32(L2_TM_DFT_3, 0x9834)
    FIELD(L2_TM_DFT_3, TM_DFT_3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_3, BSCAN_DFT_ENABLE, 4, 1)
    FIELD(L2_TM_DFT_3, BSCAN_DFT_SEL_P, 0, 4)
REG32(L2_TM_DFT_4, 0x9838)
    FIELD(L2_TM_DFT_4, TM_DFT_4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_4, IQPI_DFT_ENABLE, 1, 1)
    FIELD(L2_TM_DFT_4, EPI_DFT_ENABLE, 0, 1)
REG32(L2_TM_DFT_5, 0x983c)
    FIELD(L2_TM_DFT_5, TM_DFT_5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_5, IQPI_DFT_SEL, 0, 8)
REG32(L2_TM_DFT_6, 0x9840)
    FIELD(L2_TM_DFT_6, TM_DFT_6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_6, EPI_DFT_SEL, 0, 8)
REG32(L2_TM_DFT_7, 0x9844)
    FIELD(L2_TM_DFT_7, TM_DFT_7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_7, EQ_DFT_ENABLE, 4, 1)
    FIELD(L2_TM_DFT_7, EQ_DFT_SEL_P, 0, 4)
REG32(L2_TM_DFT_8, 0x9848)
    FIELD(L2_TM_DFT_8, TM_DFT_8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_8, LSRX_DFT_ENABLE, 4, 1)
    FIELD(L2_TM_DFT_8, LSRX_DFT_SEL_P, 0, 4)
REG32(L2_TM_DFT_9, 0x984c)
    FIELD(L2_TM_DFT_9, TM_DFT_9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_9, SAMP_DFT_SEL_P_0, 0, 8)
REG32(L2_TM_DFT_10, 0x9850)
    FIELD(L2_TM_DFT_10, TM_DFT_10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_DFT_10, CLKLANE_DFT_SEL, 2, 2)
    FIELD(L2_TM_DFT_10, SAMP_DFT_SEL_P_1, 0, 2)
REG32(L2_TM_BG_1, 0x9854)
    FIELD(L2_TM_BG_1, TM_BG_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_1, BIASGEN_CURRENT_PROG_0, 0, 8)
REG32(L2_TM_BG_2, 0x9858)
    FIELD(L2_TM_BG_2, TM_BG_2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_2, BIASGEN_CURRENT_PROG_1, 0, 8)
REG32(L2_TM_BG_3, 0x985c)
    FIELD(L2_TM_BG_3, TM_BG_3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_3, BIASGEN_CURRENT_PROG_2, 0, 8)
REG32(L2_TM_BG_4, 0x9860)
    FIELD(L2_TM_BG_4, TM_BG_4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_4, BIASGEN_CURRENT_PROG_3, 0, 8)
REG32(L2_TM_BG_5, 0x9864)
    FIELD(L2_TM_BG_5, TM_BG_5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_5, BIASGEN_CURRENT_PROG_4, 0, 8)
REG32(L2_TM_BG_6, 0x9868)
    FIELD(L2_TM_BG_6, TM_BG_6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_6, BIASGEN_CURRENT_PROG_5, 0, 8)
REG32(L2_TM_BG_7, 0x986c)
    FIELD(L2_TM_BG_7, TM_BG_7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_7, BIASGEN_CURRENT_PROG_6, 0, 8)
REG32(L2_TM_BG_8, 0x9870)
    FIELD(L2_TM_BG_8, TM_BG_8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_8, BIASGEN_CURRENT_PROG_7, 0, 8)
REG32(L2_TM_BG_9, 0x9874)
    FIELD(L2_TM_BG_9, TM_BG_9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_9, BIASGEN_CURRENT_PROG_8, 0, 8)
REG32(L2_TM_BG_10, 0x9878)
    FIELD(L2_TM_BG_10, TM_BG_10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_BG_10, BIASGEN_CURRENT_PROG_9, 0, 8)
REG32(L2_TM_SD0, 0x987c)
    FIELD(L2_TM_SD0, TM_SD0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD0, SD_CAL_OVERRIDE_CODE, 2, 6)
    FIELD(L2_TM_SD0, SD_CAL_OVERRIDE_EN, 1, 1)
    FIELD(L2_TM_SD0, SD_CAL_DIR, 0, 1)
REG32(L2_TM_SD1, 0x9880)
    FIELD(L2_TM_SD1, TM_SD1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD1, SD_BYPASS_ANA_CAL_EN_VAL, 7, 1)
    FIELD(L2_TM_SD1, SD_BYPASS_ANA_CAL_EN, 6, 1)
    FIELD(L2_TM_SD1, SD_CAL_CODE_START, 0, 6)
REG32(L2_TM_SD2, 0x9884)
    FIELD(L2_TM_SD2, TM_SD2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD2, SD_CAL_FORCE_CAL, 7, 1)
    FIELD(L2_TM_SD2, SD_CAL_CODE_TUNE_BYP, 6, 1)
    FIELD(L2_TM_SD2, SD_CAL_CODE_TUNE, 0, 6)
REG32(L2_TM_SD3, 0x9888)
    FIELD(L2_TM_SD3, TM_SD3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD3, SD_CAL_ITER_WAIT_0, 0, 8)
REG32(L2_TM_SD4, 0x988c)
    FIELD(L2_TM_SD4, TM_SD4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD4, SD_CAL_ITER_WAIT_BYPASS, 4, 1)
    FIELD(L2_TM_SD4, SD_CAL_ITER_WAIT_1, 0, 4)
REG32(L2_TM_SD5, 0x9890)
    FIELD(L2_TM_SD5, TM_SD5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD5, SD_CAL_INIT_WAIT_0, 0, 8)
REG32(L2_TM_SD6, 0x9894)
    FIELD(L2_TM_SD6, TM_SD6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD6, SD_CAL_INIT_WAIT_BYPASS, 4, 1)
    FIELD(L2_TM_SD6, SD_CAL_INIT_WAIT_1, 0, 4)
REG32(L2_TM_MISC1, 0x9898)
    FIELD(L2_TM_MISC1, TM_MISC1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MISC1, HSRX_POLARITY_FLIP, 7, 1)
    FIELD(L2_TM_MISC1, RXTERM_BIAS_PROG, 3, 4)
    FIELD(L2_TM_MISC1, LSRX_OR_SYS_POLARITY_FLIP, 2, 1)
    FIELD(L2_TM_MISC1, FORCE_SATAG1_DCC_MODE, 1, 1)
    FIELD(L2_TM_MISC1, SATAG1_DCC_MODE_VAL, 0, 1)
REG32(L2_TM_MISC2, 0x989c)
    FIELD(L2_TM_MISC2, TM_MISC2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MISC2, ILL_CAL_BYPASS_COUNTS, 7, 1)
    FIELD(L2_TM_MISC2, PWR_SEQ_SAMP_CAL_ALWAYS, 6, 1)
    FIELD(L2_TM_MISC2, PWR_SEQ_BYP_CAL_DONE, 5, 1)
    FIELD(L2_TM_MISC2, PWR_SEQ_BYP_CAL_DONE_VAL, 4, 1)
    FIELD(L2_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ, 3, 1)
    FIELD(L2_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ_VAL, 2, 1)
    FIELD(L2_TM_MISC2, UNUSED, 0, 2)
REG32(L2_TM_EYE_SURF0, 0x98a0)
    FIELD(L2_TM_EYE_SURF0, TM_EYE_SURF0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF0, UNUSED, 7, 1)
    FIELD(L2_TM_EYE_SURF0, EYE_SURF_RUN, 6, 1)
    FIELD(L2_TM_EYE_SURF0, COORD_EW_DIR, 5, 1)
    FIELD(L2_TM_EYE_SURF0, COORD_EW_OFFSET, 0, 5)
REG32(L2_TM_EYE_SURF1, 0x98a4)
    FIELD(L2_TM_EYE_SURF1, TM_EYE_SURF1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF1, COORD_NS_DIR, 7, 1)
    FIELD(L2_TM_EYE_SURF1, COORD_NS_OFFSET, 0, 7)
REG32(L2_TM_EYE_SURF2, 0x98a8)
    FIELD(L2_TM_EYE_SURF2, TM_EYE_SURF2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF2, TIMER_DELAY_TIME0, 0, 8)
REG32(L2_TM_EYE_SURF3, 0x98ac)
    FIELD(L2_TM_EYE_SURF3, TM_EYE_SURF3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF3, TIMER_DELAY_TIME1, 0, 8)
REG32(L2_TM_EYE_SURF4, 0x98b0)
    FIELD(L2_TM_EYE_SURF4, TM_EYE_SURF4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF4, TIMER_DELAY_TIME2, 0, 8)
REG32(L2_TM_EYE_SURF5, 0x98b4)
    FIELD(L2_TM_EYE_SURF5, TM_EYE_SURF5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF5, TIMER_DELAY_TIME3, 0, 8)
REG32(L2_TM_EYE_SURF6, 0x98b8)
    FIELD(L2_TM_EYE_SURF6, TM_EYE_SURF6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF6, TIMER_TEST_TIME0, 0, 8)
REG32(L2_TM_EYE_SURF7, 0x98bc)
    FIELD(L2_TM_EYE_SURF7, TM_EYE_SURF7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF7, TIMER_TEST_TIME1, 0, 8)
REG32(L2_TM_EYE_SURF8, 0x98c0)
    FIELD(L2_TM_EYE_SURF8, TM_EYE_SURF8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF8, TIMER_TEST_TIME2, 0, 8)
REG32(L2_TM_EYE_SURF9, 0x98c4)
    FIELD(L2_TM_EYE_SURF9, TM_EYE_SURF9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYE_SURF9, TIMER_TEST_TIME3, 0, 8)
REG32(L2_TM_SPARE, 0x98c8)
    FIELD(L2_TM_SPARE, TM_SPARE_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SPARE, RXDA_SPARE_PORT, 0, 8)
REG32(L2_TM_ANA_EQ1, 0x98cc)
    FIELD(L2_TM_ANA_EQ1, TM_ANA_EQ1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_EQ1, UNUSED, 5, 3)
    FIELD(L2_TM_ANA_EQ1, EQ_INPUT_CM_PROG, 2, 3)
    FIELD(L2_TM_ANA_EQ1, EQ_PADINTF_HQ_PROG, 0, 2)
REG32(L2_TM_ANA_E_PI0, 0x98d0)
    FIELD(L2_TM_ANA_E_PI0, TM_ANA_E_PI0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_E_PI0, EPI_BIASTRIM, 5, 3)
    FIELD(L2_TM_ANA_E_PI0, UNUSED, 0, 5)
REG32(L2_TM_ANA_IQ_PI0, 0x98d4)
    FIELD(L2_TM_ANA_IQ_PI0, TM_ANA_IQ_PI0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_IQ_PI0, IQPI_BIASTRIM, 5, 3)
    FIELD(L2_TM_ANA_IQ_PI0, UNUSED, 0, 5)
REG32(L2_TM_ANA_MISC0, 0x98d8)
    FIELD(L2_TM_ANA_MISC0, TM_ANA_MISC0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ANA_MISC0, EPI_CALIB_EN, 7, 1)
    FIELD(L2_TM_ANA_MISC0, IQPI_CALIB_EN, 6, 1)
    FIELD(L2_TM_ANA_MISC0, UNUSED, 0, 6)
REG32(L2_TM_SAMP_CODE_IQ_PH0, 0x98dc)
    FIELD(L2_TM_SAMP_CODE_IQ_PH0, TM_SAMP_CODE_IQ_PH0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_CODE_IQ_PH0, UNUSED, 7, 1)
    FIELD(L2_TM_SAMP_CODE_IQ_PH0, SAMP_CALIB_BYP, 6, 1)
    FIELD(L2_TM_SAMP_CODE_IQ_PH0, IQ_PH0_SAMP_CODE, 0, 6)
REG32(L2_TM_SAMP_CODE_IQ_PH90, 0x98e0)
    FIELD(L2_TM_SAMP_CODE_IQ_PH90, TM_SAMP_CODE_IQ_PH90_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_CODE_IQ_PH90, CALIB_SWEEP_DIR, 6, 2)
    FIELD(L2_TM_SAMP_CODE_IQ_PH90, IQ_PH90_SAMP_CODE, 0, 6)
REG32(L2_TM_SAMP_CODE_IQ_PH180, 0x98e4)
    FIELD(L2_TM_SAMP_CODE_IQ_PH180, TM_SAMP_CODE_IQ_PH180_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_CODE_IQ_PH180, UNUSED, 6, 2)
    FIELD(L2_TM_SAMP_CODE_IQ_PH180, IQ_PH180_SAMP_CODE, 0, 6)
REG32(L2_TM_SAMP_CODE_IQ_PH270, 0x98e8)
    FIELD(L2_TM_SAMP_CODE_IQ_PH270, TM_SAMP_CODE_IQ_PH270_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_CODE_IQ_PH270, HSRX_DBG_BUS_SEL, 6, 2)
    FIELD(L2_TM_SAMP_CODE_IQ_PH270, IQ_PH270_SAMP_CODE, 0, 6)
REG32(L2_TM_SAMP_CODE_E_PH0, 0x98ec)
    FIELD(L2_TM_SAMP_CODE_E_PH0, TM_SAMP_CODE_E_PH0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_CODE_E_PH0, UNUSED, 6, 2)
    FIELD(L2_TM_SAMP_CODE_E_PH0, E_PH90_SAMP_CODE, 0, 6)
REG32(L2_TM_SAMP_CODE_E_PH180, 0x98f0)
    FIELD(L2_TM_SAMP_CODE_E_PH180, TM_SAMP_CODE_E_PH180_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_CODE_E_PH180, UNUSED, 6, 2)
    FIELD(L2_TM_SAMP_CODE_E_PH180, E_PH270_SAMP_CODE, 0, 6)
REG32(L2_TM_IQ_ILL0, 0x98f4)
    FIELD(L2_TM_IQ_ILL0, TM_IQ_ILL0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL0, ILL_BYPASS_IQ_CAL_EN, 7, 1)
    FIELD(L2_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L2_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L2_TM_IQ_ILL0, ILL_BYPASS_IQ_CODES, 0, 1)
REG32(L2_TM_IQ_ILL1, 0x98f8)
    FIELD(L2_TM_IQ_ILL1, TM_IQ_ILL1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL1, ILL_BYPASS_IQ_CALCODE_F0, 0, 8)
REG32(L2_TM_IQ_ILL2, 0x98fc)
    FIELD(L2_TM_IQ_ILL2, TM_IQ_ILL2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL2, ILL_BYPASS_IQ_CALCODE_F1, 0, 8)
REG32(L2_TM_IQ_ILL3, 0x9900)
    FIELD(L2_TM_IQ_ILL3, TM_IQ_ILL3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL3, ILL_BYPASS_IQ_CALCODE_F2, 0, 8)
REG32(L2_TM_IQ_ILL4, 0x9904)
    FIELD(L2_TM_IQ_ILL4, TM_IQ_ILL4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL4, ILL_BYPASS_IQ_CALCODE_F3, 0, 8)
REG32(L2_TM_IQ_ILL5, 0x9908)
    FIELD(L2_TM_IQ_ILL5, TM_IQ_ILL5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL5, ILL_BYPASS_IQ_CALCODE_F4, 0, 8)
REG32(L2_TM_IQ_ILL6, 0x990c)
    FIELD(L2_TM_IQ_ILL6, TM_IQ_ILL6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL6, ILL_BYPASS_IQ_CALCODE_F5, 0, 8)
REG32(L2_TM_IQ_ILL7, 0x9910)
    FIELD(L2_TM_IQ_ILL7, TM_IQ_ILL7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL7, ILL_BYPASS_IQ_CNSTGMTRIM_VAL, 0, 8)
REG32(L2_TM_IQ_ILL8, 0x9914)
    FIELD(L2_TM_IQ_ILL8, TM_IQ_ILL8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL8, ILL_BYPASS_IQ_POLYTRIM_VAL, 0, 8)
REG32(L2_TM_IQ_ILL9, 0x9918)
    FIELD(L2_TM_IQ_ILL9, TM_IQ_ILL9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL9, UNUSED, 4, 4)
    FIELD(L2_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN, 3, 1)
    FIELD(L2_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN_VAL, 2, 1)
    FIELD(L2_TM_IQ_ILL9, ILL_BYPASS_IQ_CNSTGMTRIM, 1, 1)
    FIELD(L2_TM_IQ_ILL9, ILL_BYPASS_IQ_POLYTIM, 0, 1)
REG32(L2_TM_IQ_ILL10, 0x991c)
    FIELD(L2_TM_IQ_ILL10, TM_IQ_ILL10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_IQ_ILL10, UNUSED, 6, 2)
    FIELD(L2_TM_IQ_ILL10, IQPI_CALCTRIM, 4, 2)
    FIELD(L2_TM_IQ_ILL10, IQPI_REPLICATRIM, 0, 4)
REG32(L2_TM_E_ILL0, 0x9920)
    FIELD(L2_TM_E_ILL0, TM_E_ILL0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL0, E_ILL_CALIB_CTRL, 7, 1)
    FIELD(L2_TM_E_ILL0, E_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L2_TM_E_ILL0, E_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L2_TM_E_ILL0, E_ILL_CALIB_BYP, 0, 1)
REG32(L2_TM_E_ILL1, 0x9924)
    FIELD(L2_TM_E_ILL1, TM_E_ILL1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL1, ILL_BYPASS_E_CALCODE_F0, 0, 8)
REG32(L2_TM_E_ILL2, 0x9928)
    FIELD(L2_TM_E_ILL2, TM_E_ILL2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL2, ILL_BYPASS_E_CALCODE_F1, 0, 8)
REG32(L2_TM_E_ILL3, 0x992c)
    FIELD(L2_TM_E_ILL3, TM_E_ILL3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL3, ILL_BYPASS_E_CALCODE_F2, 0, 8)
REG32(L2_TM_E_ILL4, 0x9930)
    FIELD(L2_TM_E_ILL4, TM_E_ILL4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL4, ILL_BYPASS_E_CALCODE_F3, 0, 8)
REG32(L2_TM_E_ILL5, 0x9934)
    FIELD(L2_TM_E_ILL5, TM_E_ILL5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL5, ILL_BYPASS_E_CALCODE_F4, 0, 8)
REG32(L2_TM_E_ILL6, 0x9938)
    FIELD(L2_TM_E_ILL6, TM_E_ILL6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL6, ILL_BYPASS_E_CALCODE_F5, 0, 8)
REG32(L2_TM_E_ILL7, 0x993c)
    FIELD(L2_TM_E_ILL7, TM_E_ILL7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL7, ILL_BYPASS_E_CNSTGMTRIM_VAL, 0, 8)
REG32(L2_TM_E_ILL8, 0x9940)
    FIELD(L2_TM_E_ILL8, TM_E_ILL8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL8, ILL_BYPASS_E_POLYTRIM_VAL, 0, 8)
REG32(L2_TM_E_ILL9, 0x9944)
    FIELD(L2_TM_E_ILL9, TM_E_ILL9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL9, UNUSED, 4, 4)
    FIELD(L2_TM_E_ILL9, ILL_BYPASS_E_LFEN, 3, 1)
    FIELD(L2_TM_E_ILL9, ILL_BYPASS_E_LFEN_VAL, 2, 1)
    FIELD(L2_TM_E_ILL9, ILL_BYPASS_E_CNSTGMTRIM, 1, 1)
    FIELD(L2_TM_E_ILL9, ILL_BYPASS_E_POLYTIM, 0, 1)
REG32(L2_TM_E_ILL10, 0x9948)
    FIELD(L2_TM_E_ILL10, TM_E_ILL10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_E_ILL10, UNUSED, 6, 2)
    FIELD(L2_TM_E_ILL10, EPI_CALCTRIM, 4, 2)
    FIELD(L2_TM_E_ILL10, EPI_REPLICATRIM, 0, 4)
REG32(L2_TM_EQ0, 0x994c)
    FIELD(L2_TM_EQ0, TM_EQ0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ0, EQ_STG1_RL_PROG_MSB, 7, 1)
    FIELD(L2_TM_EQ0, EQ_STG1_CTRL_BYP, 6, 1)
    FIELD(L2_TM_EQ0, EQ_STG2_CTRL_BYP, 5, 1)
    FIELD(L2_TM_EQ0, EQ_ADAPTATION_FORCE, 4, 1)
    FIELD(L2_TM_EQ0, EQ_ADAPTATION_FORCE_VAL, 3, 1)
    FIELD(L2_TM_EQ0, EQ_ISOURCE_EN_VAL, 0, 3)
REG32(L2_TM_EQ1, 0x9950)
    FIELD(L2_TM_EQ1, TM_EQ1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ1, EQ_STG1_PREAMP_MODE_VAL, 7, 1)
    FIELD(L2_TM_EQ1, EQ_STG1_RL_PROG, 5, 2)
    FIELD(L2_TM_EQ1, EQ_STG2_CM_PROG, 3, 2)
    FIELD(L2_TM_EQ1, EQ_STG2_PREAMP_MODE_VAL, 2, 1)
    FIELD(L2_TM_EQ1, EQ_STG2_RL_PROG, 0, 2)
REG32(L2_TM_EQ2, 0x9954)
    FIELD(L2_TM_EQ2, TM_EQ2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ2, UNUSED, 7, 1)
    FIELD(L2_TM_EQ2, EQ_EN_BACKGND_ADAPT, 6, 1)
    FIELD(L2_TM_EQ2, EQ_COUNT_STRAYS, 5, 1)
    FIELD(L2_TM_EQ2, EQ_WINDOW_SIZE, 3, 2)
    FIELD(L2_TM_EQ2, EQ_MAJ_THRESH, 1, 2)
    FIELD(L2_TM_EQ2, EQ_BIAS_CTRL_BYP, 0, 1)
REG32(L2_TM_EQ3, 0x9958)
    FIELD(L2_TM_EQ3, TM_EQ3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ3, UNUSED, 5, 3)
    FIELD(L2_TM_EQ3, EQ_BYPASS_ISINK_ENZ_VAL, 0, 5)
REG32(L2_TM_EQ4, 0x995c)
    FIELD(L2_TM_EQ4, TM_EQ4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ4, UNUSED, 5, 3)
    FIELD(L2_TM_EQ4, BYPASS_EQ_C_STG1, 4, 1)
    FIELD(L2_TM_EQ4, BYPASS_EQ_C_VAL_STG1, 0, 4)
REG32(L2_TM_EQ5, 0x9960)
    FIELD(L2_TM_EQ5, TM_EQ5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ5, UNUSED, 6, 2)
    FIELD(L2_TM_EQ5, BYPASS_EQ_R_STG1, 5, 1)
    FIELD(L2_TM_EQ5, BYPASS_EQ_R_VAL_STG1, 0, 5)
REG32(L2_TM_EQ6, 0x9964)
    FIELD(L2_TM_EQ6, TM_EQ6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ6, UNUSED, 5, 3)
    FIELD(L2_TM_EQ6, BYPASS_EQ_C_STG2, 4, 1)
    FIELD(L2_TM_EQ6, BYPASS_EQ_C_VAL_STG2, 0, 4)
REG32(L2_TM_EQ7, 0x9968)
    FIELD(L2_TM_EQ7, TM_EQ7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ7, UNUSED, 6, 2)
    FIELD(L2_TM_EQ7, BYPASS_EQ_R_STG2, 5, 1)
    FIELD(L2_TM_EQ7, BYPASS_EQ_R_VAL_STG2, 0, 5)
REG32(L2_TM_EQ8, 0x996c)
    FIELD(L2_TM_EQ8, TM_EQ8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ8, EQ_BYPASS_CALIB, 7, 1)
    FIELD(L2_TM_EQ8, EQ_SWEEP, 5, 2)
    FIELD(L2_TM_EQ8, SEL_SAMP, 2, 3)
    FIELD(L2_TM_EQ8, BYPASS_EQ_CAL, 1, 1)
    FIELD(L2_TM_EQ8, BYPASS_EQ_CAL_VAL, 0, 1)
REG32(L2_TM_EQ9, 0x9970)
    FIELD(L2_TM_EQ9, TM_EQ9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ9, UNUSED, 7, 1)
    FIELD(L2_TM_EQ9, EQ_BYPASS_CALIB_CODE, 0, 7)
REG32(L2_TM_EQ10, 0x9974)
    FIELD(L2_TM_EQ10, TM_EQ10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ10, UNUSED, 7, 1)
    FIELD(L2_TM_EQ10, OFFSET_COEF_SCALER, 4, 3)
    FIELD(L2_TM_EQ10, DIAG_OUTPUT_SEL, 0, 4)
REG32(L2_TM_EQ11, 0x9978)
    FIELD(L2_TM_EQ11, TM_EQ11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ11, EQ_CALIB_CLK_DIV_FORCE, 7, 1)
    FIELD(L2_TM_EQ11, EDGE_IS_FIRST, 6, 1)
    FIELD(L2_TM_EQ11, FORCE_EQ_OFFS_ON, 5, 1)
    FIELD(L2_TM_EQ11, FORCE_EQ_OFFS_OFF, 4, 1)
    FIELD(L2_TM_EQ11, EQ_OFFS_WITH_ADAPT, 3, 1)
    FIELD(L2_TM_EQ11, OFFSET_VOTER_OVERRIDE_EN, 2, 1)
    FIELD(L2_TM_EQ11, OFFSET_VOTER_OVERRIDE_NEG, 1, 1)
    FIELD(L2_TM_EQ11, OFFSET_VOTER_OVERRIDE_POS, 0, 1)
REG32(L2_TM_ILL7, 0x997c)
    FIELD(L2_TM_ILL7, TM_ILL7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL7, ILL_CAL_INIT_WAIT, 0, 8)
REG32(L2_TM_ILL8, 0x9980)
    FIELD(L2_TM_ILL8, TM_ILL8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL8, ILL_CAL_ITER_WAIT, 0, 8)
REG32(L2_TM_ILL9, 0x9984)
    FIELD(L2_TM_ILL9, TM_ILL9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL9, ILL_CAL_BYPASS_CAP_START, 7, 1)
    FIELD(L2_TM_ILL9, ILL_CAL_CAP_START_VAL, 0, 7)
REG32(L2_TM_ILL10, 0x9988)
    FIELD(L2_TM_ILL10, TM_ILL10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL10, G3A_USB3_PCIEG2_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L2_TM_ILL10, G3B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L2_TM_ILL11, 0x998c)
    FIELD(L2_TM_ILL11, TM_ILL11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL11, G2A_PCIEG1_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L2_TM_ILL11, G2B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L2_TM_ILL12, 0x9990)
    FIELD(L2_TM_ILL12, TM_ILL12_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL12, G1A_PLL_CTR_BYP_VAL, 0, 8)
REG32(L2_TM_ILL13, 0x9994)
    FIELD(L2_TM_ILL13, TM_ILL13_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL13, ILL_CAL_IDLE_VAL_REFCNT, 0, 3)
REG32(L2_TM_ILL14, 0x9998)
    FIELD(L2_TM_ILL14, TM_ILL14_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL14, ILL_CALIB_WAIT, 4, 4)
    FIELD(L2_TM_ILL14, ILL_CHG_WAIT, 0, 4)
REG32(L2_TM_FRZ_FSM0, 0x999c)
    FIELD(L2_TM_FRZ_FSM0, TM_FRZ_FSM0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_FRZ_FSM0, FREEZE_HSRX_PWR_SEQ_FSM, 0, 8)
REG32(L2_TM_FRZ_FSM1, 0x99a0)
    FIELD(L2_TM_FRZ_FSM1, TM_FRZ_FSM1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_FRZ_FSM1, UNUSED, 6, 2)
    FIELD(L2_TM_FRZ_FSM1, FREEZE_ILL_CALIB_FSM, 0, 6)
REG32(L2_TM_RST_DLY, 0x99a4)
    FIELD(L2_TM_RST_DLY, TM_RST_DLY_31_8_RSVD, 24, 8)
    FIELD(L2_TM_RST_DLY, APB_RST_DLY, 0, 8)
REG32(L2_TM_ILL15, 0x99a8)
    FIELD(L2_TM_ILL15, TM_ILL15_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL15, ILL_CAL_REF_CTR_MSB_REG1, 0, 8)
REG32(L2_TM_MISC3, 0x99ac)
    FIELD(L2_TM_MISC3, TM_MISC3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MISC3, AUX0_BIT_7, 7, 1)
    FIELD(L2_TM_MISC3, AUX0_BIT_6, 6, 1)
    FIELD(L2_TM_MISC3, AUX0_BIT_5, 5, 1)
    FIELD(L2_TM_MISC3, DBG_BUS_SEL, 2, 3)
    FIELD(L2_TM_MISC3, CDR_EN_FPL, 1, 1)
    FIELD(L2_TM_MISC3, CDR_EN_FFL, 0, 1)
REG32(L2_TM_EQ_OFFS1, 0x99b0)
    FIELD(L2_TM_EQ_OFFS1, TM_EQ_OFFS1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ_OFFS1, EQ_OFFSET_CORR_BYP, 1, 7)
    FIELD(L2_TM_EQ_OFFS1, AUX1_BIT_7, 0, 1)
REG32(L2_TM_SAMP0, 0x99b4)
    FIELD(L2_TM_SAMP0, TM_SAMP0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP0, SAMP_CALIB_CLK_DIV_FACTOR, 1, 7)
    FIELD(L2_TM_SAMP0, SAMP_CALIB_CLK_DIV_FORCE, 0, 1)
REG32(L2_TM_EQ12, 0x99b8)
    FIELD(L2_TM_EQ12, TM_EQ12_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ12, EQ_CALIB_CLK_DIV_FACTOR, 0, 8)
REG32(L2_TM_MISC4, 0x99bc)
    FIELD(L2_TM_MISC4, TM_MISC4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MISC4, PSO_CLK_LANE_FRM_PCS, 2, 1)
    FIELD(L2_TM_MISC4, BSCAN_MODE_VAL, 1, 1)
    FIELD(L2_TM_MISC4, BSCAN_FORCE_MODE, 0, 1)
REG32(L2_TM_SAMP_STATUS0, 0x9a80)
    FIELD(L2_TM_SAMP_STATUS0, TM_SAMP_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_STATUS0, IQ_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L2_TM_SAMP_STATUS1, 0x9a84)
    FIELD(L2_TM_SAMP_STATUS1, TM_SAMP_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_STATUS1, IQ_SAMP_PH90_CALIB_CODE, 0, 6)
REG32(L2_TM_SAMP_STATUS2, 0x9a88)
    FIELD(L2_TM_SAMP_STATUS2, TM_SAMP_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_STATUS2, IQ_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L2_TM_SAMP_STATUS3, 0x9a8c)
    FIELD(L2_TM_SAMP_STATUS3, TM_SAMP_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_STATUS3, IQ_SAMP_PH270_CALIB_CODE, 0, 6)
REG32(L2_TM_SAMP_STATUS4, 0x9a90)
    FIELD(L2_TM_SAMP_STATUS4, TM_SAMP_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_STATUS4, E_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L2_TM_SAMP_STATUS5, 0x9a94)
    FIELD(L2_TM_SAMP_STATUS5, TM_SAMP_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SAMP_STATUS5, E_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L2_TM_ILL_STATUS0, 0x9a98)
    FIELD(L2_TM_ILL_STATUS0, TM_ILL_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS0, IQ_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS1, 0x9a9c)
    FIELD(L2_TM_ILL_STATUS1, TM_ILL_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS1, IQ_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS2, 0x9aa0)
    FIELD(L2_TM_ILL_STATUS2, TM_ILL_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS2, IQ_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS3, 0x9aa4)
    FIELD(L2_TM_ILL_STATUS3, TM_ILL_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS3, IQ_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS4, 0x9aa8)
    FIELD(L2_TM_ILL_STATUS4, TM_ILL_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS4, IQ_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS5, 0x9aac)
    FIELD(L2_TM_ILL_STATUS5, TM_ILL_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS5, IQ_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS6, 0x9ab0)
    FIELD(L2_TM_ILL_STATUS6, TM_ILL_STATUS6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS6, E_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS7, 0x9ab4)
    FIELD(L2_TM_ILL_STATUS7, TM_ILL_STATUS7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS7, E_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS8, 0x9ab8)
    FIELD(L2_TM_ILL_STATUS8, TM_ILL_STATUS8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS8, E_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS9, 0x9abc)
    FIELD(L2_TM_ILL_STATUS9, TM_ILL_STATUS9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS9, E_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS10, 0x9ac0)
    FIELD(L2_TM_ILL_STATUS10, TM_ILL_STATUS10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS10, E_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_ILL_STATUS11, 0x9ac4)
    FIELD(L2_TM_ILL_STATUS11, TM_ILL_STATUS11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_ILL_STATUS11, E_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L2_TM_MISC_ST_0, 0x9ac8)
    FIELD(L2_TM_MISC_ST_0, TM_MISC_ST_0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MISC_ST_0, EYE_SURF_DONE, 5, 1)
    FIELD(L2_TM_MISC_ST_0, SD_CAL_DONE, 4, 1)
    FIELD(L2_TM_MISC_ST_0, SAMP_CAL_DONE, 3, 1)
    FIELD(L2_TM_MISC_ST_0, ILL_CAL_DONE, 2, 1)
    FIELD(L2_TM_MISC_ST_0, EQ_CAL_DONE, 1, 1)
    FIELD(L2_TM_MISC_ST_0, EQ_VALID_ADAPT_CODE, 0, 1)
REG32(L2_TM_SD_ST_0, 0x9acc)
    FIELD(L2_TM_SD_ST_0, TM_SD_ST_0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_SD_ST_0, SD_CAL_CODE, 0, 6)
REG32(L2_TM_EYESURF_ST0, 0x9ad0)
    FIELD(L2_TM_EYESURF_ST0, TM_EYESURF_ST0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYESURF_ST0, ERROR_COUNT0, 0, 8)
REG32(L2_TM_EYESURF_ST1, 0x9ad4)
    FIELD(L2_TM_EYESURF_ST1, TM_EYESURF_ST1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EYESURF_ST1, ERROR_COUNT1, 0, 8)
REG32(L2_TM_EQ_ST0, 0x9ad8)
    FIELD(L2_TM_EQ_ST0, TM_EQ_ST0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ_ST0, EQ_ADAPT_CODE0, 0, 8)
REG32(L2_TM_EQ_ST1, 0x9adc)
    FIELD(L2_TM_EQ_ST1, TM_EQ_ST1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ_ST1, EQ_ADAPT_CODE1, 0, 8)
REG32(L2_TM_EQ_ST2, 0x9ae0)
    FIELD(L2_TM_EQ_ST2, TM_EQ_ST2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_EQ_ST2, EQ_CALIB_CODE, 0, 7)
REG32(L2_TM_RXPMA_ST1, 0x9ae4)
    FIELD(L2_TM_RXPMA_ST1, TM_RXPMA_ST1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_RXPMA_ST1, HSRX_OPMODE_STATUS, 0, 8)
REG32(L2_TM_CDR0, 0x9c00)
    FIELD(L2_TM_CDR0, TM_CDR0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR0, FAST_PHASE_LOCK_FORCE, 7, 1)
    FIELD(L2_TM_CDR0, UNUSED, 5, 2)
    FIELD(L2_TM_CDR0, CDR_LOOP_CTRL, 2, 3)
    FIELD(L2_TM_CDR0, SECOND_ORDER_LOOP_DIS, 1, 1)
    FIELD(L2_TM_CDR0, FIRST_ORDER_LOOP_DIS, 0, 1)
REG32(L2_TM_CDR1, 0x9c04)
    FIELD(L2_TM_CDR1, TM_CDR1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR1, RESET_DELAY_2OL, 0, 8)
REG32(L2_TM_CDR2, 0x9c08)
    FIELD(L2_TM_CDR2, TM_CDR2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR2, CLK_SEL_2OL, 6, 2)
    FIELD(L2_TM_CDR2, INTEGRATOR_THRESH_2OL, 0, 6)
REG32(L2_TM_CDR3, 0x9c0c)
    FIELD(L2_TM_CDR3, TM_CDR3_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR3, UNUSED, 7, 1)
    FIELD(L2_TM_CDR3, SIGNAL_THRESH_1OL, 0, 7)
REG32(L2_TM_CDR4, 0x9c10)
    FIELD(L2_TM_CDR4, TM_CDR4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR4, UNUSED, 7, 1)
    FIELD(L2_TM_CDR4, SIGNAL_THRESH_2OL, 0, 7)
REG32(L2_TM_CDR5, 0x9c14)
    FIELD(L2_TM_CDR5, TM_CDR5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR5, FPHL_FSM_ACC_CYCLES, 5, 3)
    FIELD(L2_TM_CDR5, FFL_PH0_INT_GAIN, 0, 5)
REG32(L2_TM_CDR6, 0x9c18)
    FIELD(L2_TM_CDR6, TM_CDR6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR6, FPHL_FSM_DELAY_CYCLES, 5, 3)
    FIELD(L2_TM_CDR6, FFL_PH1_INT_GAIN, 0, 5)
REG32(L2_TM_CDR7, 0x9c1c)
    FIELD(L2_TM_CDR7, TM_CDR7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR7, FPHL_FSM_TRIGGER1_WAIT_CYCLES, 5, 3)
    FIELD(L2_TM_CDR7, FFL_PH2_INT_GAIN, 0, 5)
REG32(L2_TM_CDR8, 0x9c20)
    FIELD(L2_TM_CDR8, TM_CDR8_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR8, FPHL_FSM_TRIGGER2_WAIT_CYCLES, 5, 3)
    FIELD(L2_TM_CDR8, FFL_PH3_INT_GAIN, 0, 5)
REG32(L2_TM_CDR9, 0x9c24)
    FIELD(L2_TM_CDR9, TM_CDR9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR9, FPHL_FSM_TRIGGER3_WAIT_CYCLES, 5, 3)
    FIELD(L2_TM_CDR9, FFL_PH4_INT_GAIN, 0, 5)
REG32(L2_TM_CDR10, 0x9c28)
    FIELD(L2_TM_CDR10, TM_CDR10_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR10, FFL_TIME_PER_PHASE_10_8, 5, 3)
    FIELD(L2_TM_CDR10, FFL_PH5_INT_GAIN, 0, 5)
REG32(L2_TM_CDR11, 0x9c2c)
    FIELD(L2_TM_CDR11, TM_CDR11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR11, UNUSED, 5, 3)
    FIELD(L2_TM_CDR11, FFL_PH6_INT_GAIN, 0, 5)
REG32(L2_TM_CDR12, 0x9c30)
    FIELD(L2_TM_CDR12, TM_CDR12_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR12, CDRLF_RESET_ON_EN_CDR, 7, 1)
    FIELD(L2_TM_CDR12, CDRLF_RESET_ON_INT_MAX_2OL, 6, 1)
    FIELD(L2_TM_CDR12, CDRLF_RESET_ON_MODE_CHG, 5, 1)
    FIELD(L2_TM_CDR12, FFL_PH7_INT_GAIN, 0, 5)
REG32(L2_TM_CDR13, 0x9c34)
    FIELD(L2_TM_CDR13, TM_CDR13_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR13, FFL_TIME_PER_PHASE_7_0, 0, 8)
REG32(L2_TM_CDR14, 0x9c38)
    FIELD(L2_TM_CDR14, TM_CDR14_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR14, FFL_PH3_POST_INT_GAIN, 6, 2)
    FIELD(L2_TM_CDR14, FFL_PH2_POST_INT_GAIN, 4, 2)
    FIELD(L2_TM_CDR14, FFL_PH1_POST_INT_GAIN, 2, 2)
    FIELD(L2_TM_CDR14, FFL_PH0_POST_INT_GAIN, 0, 2)
REG32(L2_TM_CDR15, 0x9c3c)
    FIELD(L2_TM_CDR15, TM_CDR15_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR15, FFL_PH7_POST_INT_GAIN, 6, 2)
    FIELD(L2_TM_CDR15, FFL_PH6_POST_INT_GAIN, 4, 2)
    FIELD(L2_TM_CDR15, FFL_PH5_POST_INT_GAIN, 2, 2)
    FIELD(L2_TM_CDR15, FFL_PH4_POST_INT_GAIN, 0, 2)
REG32(L2_TM_CDR16, 0x9c40)
    FIELD(L2_TM_CDR16, TM_CDR16_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR16, UNUSED, 5, 3)
    FIELD(L2_TM_CDR16, FFL_PH0_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR17, 0x9c44)
    FIELD(L2_TM_CDR17, TM_CDR17_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR17, UNUSED, 5, 3)
    FIELD(L2_TM_CDR17, FFL_PH1_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR18, 0x9c48)
    FIELD(L2_TM_CDR18, TM_CDR18_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR18, UNUSED, 5, 3)
    FIELD(L2_TM_CDR18, FFL_PH2_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR19, 0x9c4c)
    FIELD(L2_TM_CDR19, TM_CDR19_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR19, UNUSED, 5, 3)
    FIELD(L2_TM_CDR19, FFL_PH3_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR20, 0x9c50)
    FIELD(L2_TM_CDR20, TM_CDR20_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR20, UNUSED, 5, 3)
    FIELD(L2_TM_CDR20, FFL_PH4_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR21, 0x9c54)
    FIELD(L2_TM_CDR21, TM_CDR21_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR21, UNUSED, 5, 3)
    FIELD(L2_TM_CDR21, FFL_PH5_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR22, 0x9c58)
    FIELD(L2_TM_CDR22, TM_CDR22_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR22, UNUSED, 5, 3)
    FIELD(L2_TM_CDR22, FFL_PH6_PROP_GAIN, 0, 5)
REG32(L2_TM_CDR23, 0x9c5c)
    FIELD(L2_TM_CDR23, TM_CDR23_31_8_RSVD, 24, 8)
    FIELD(L2_TM_CDR23, UNUSED, 7, 1)
    FIELD(L2_TM_CDR23, PHASE_LAG_LEAD_RESPONSE, 5, 2)
    FIELD(L2_TM_CDR23, FFL_PH7_PROP_GAIN, 0, 5)
REG32(L2_TM_MISC0, 0x9c60)
    FIELD(L2_TM_MISC0, TM_MISC0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MISC0, UNUSED, 2, 6)
    FIELD(L2_TM_MISC0, DBG0_SEL, 0, 2)
REG32(L2_TM_HSRX_ST0, 0x9c64)
    FIELD(L2_TM_HSRX_ST0, TM_HSRX_ST0_31_8_RSVD, 24, 8)
    FIELD(L2_TM_HSRX_ST0, FAST_LOCK_STATUS, 0, 1)
REG32(L2_TM_PLL_LS_CLOCK, 0xa000)
    FIELD(L2_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK, 0, 8)
REG32(L2_TM_PLL_LOOP_FILT, 0xa004)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_PLL_LOOP_FILT_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_FORCE_RES_SW_ON, 7, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_HIGH_RES_SW_ON, 6, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_LOW_RES_SW_ON, 5, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_PCIE_R1_DEFAULT_RES_SW_ON, 4, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_PCIE_R1_HIGH_RES_SW_ON, 3, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_PCIE_R1_LOW_RES_SW_ON, 2, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_BYPASS_SEC_LOOP_FILTER, 1, 1)
    FIELD(L2_TM_PLL_LOOP_FILT, TM_SEC_LOOP, 0, 1)
REG32(L2_TM_PLL_DIG2, 0xa008)
    FIELD(L2_TM_PLL_DIG2, TM_PLL_DIG2_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG2, TM_FBDIV_0_LSB, 7, 1)
    FIELD(L2_TM_PLL_DIG2, TM_PLL_HS_CLOCK_0, 0, 7)
REG32(L2_TM_PLL_FBDIV, 0xa00c)
    FIELD(L2_TM_PLL_FBDIV, TM_PLL_FBDIV_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_FBDIV, TM_FBDIV_1, 0, 8)
REG32(L2_TM_PLL_DIG4, 0xa010)
    FIELD(L2_TM_PLL_DIG4, TM_PLL_DIG4_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG4, TM_VCO_CLOCK_PULDN, 7, 1)
    FIELD(L2_TM_PLL_DIG4, TM_FORCE_ANA_COARSEDONE, 6, 1)
    FIELD(L2_TM_PLL_DIG4, TM_ANA_COARSEDONE, 5, 1)
    FIELD(L2_TM_PLL_DIG4, TM_FORCE_COARSE_DONE_INT, 4, 1)
    FIELD(L2_TM_PLL_DIG4, TM_COARSE_DONE_INT, 3, 1)
    FIELD(L2_TM_PLL_DIG4, TM_FORCE_FBDIV, 2, 1)
    FIELD(L2_TM_PLL_DIG4, TM_FBDIV_2, 0, 2)
REG32(L2_TM_PLL_DIG5, 0xa014)
    FIELD(L2_TM_PLL_DIG5, TM_PLL_DIG5_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG5, TM_PD_6GHZ_LOWNOISE_RING, 7, 1)
    FIELD(L2_TM_PLL_DIG5, TM_PD_6GHZ_RING, 6, 1)
    FIELD(L2_TM_PLL_DIG5, TM_COARSE_PROG, 1, 5)
    FIELD(L2_TM_PLL_DIG5, TM_FORCE_VCO_CLOCK_PULDN, 0, 1)
REG32(L2_TM_PLL_DIG6, 0xa018)
    FIELD(L2_TM_PLL_DIG6, TM_PLL_DIG6_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG6, TM_CONFG_CHNG_CYCLES_0_LSB, 7, 1)
    FIELD(L2_TM_PLL_DIG6, TM_VCO_SETTLE_CYCLES, 5, 2)
    FIELD(L2_TM_PLL_DIG6, TM_INITIAL_WAIT_CYCLES, 3, 2)
    FIELD(L2_TM_PLL_DIG6, TM_FORCE_COARSE_PROG_PD_RING, 2, 1)
    FIELD(L2_TM_PLL_DIG6, TM_PD_1P5GHZ_RING, 1, 1)
    FIELD(L2_TM_PLL_DIG6, TM_PD_3GHZ_RING, 0, 1)
REG32(L2_TM_PLL_DIG7, 0xa01c)
    FIELD(L2_TM_PLL_DIG7, TM_PLL_DIG7_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG7, TM_CPUMP_CODE_0_LSB, 7, 1)
    FIELD(L2_TM_PLL_DIG7, TM_FORCE_ANA_START_LOOP, 6, 1)
    FIELD(L2_TM_PLL_DIG7, TM_ANA_START_LOOP, 5, 1)
    FIELD(L2_TM_PLL_DIG7, TM_PLL_LOCK_CYCLES, 3, 2)
    FIELD(L2_TM_PLL_DIG7, TM_STAND_BY_SETTLE_CYCLES, 1, 2)
    FIELD(L2_TM_PLL_DIG7, TM_CONFG_CHNG_CYCLES_1_MSB, 0, 1)
REG32(L2_TM_PLL_CPUMP_CODE_1, 0xa020)
    FIELD(L2_TM_PLL_CPUMP_CODE_1, TM_PLL_CPUMP_CODE_1_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_CPUMP_CODE_1, TM_CPUMP_CODE_1, 0, 8)
REG32(L2_TM_PLL_DIG9, 0xa024)
    FIELD(L2_TM_PLL_DIG9, TM_PLL_DIG9_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG9, TM_PLL_RSVD, 6, 2)
    FIELD(L2_TM_PLL_DIG9, TM_FB_BY2_BYPASS, 5, 1)
    FIELD(L2_TM_PLL_DIG9, TM_FORCE_CP_CODE, 4, 1)
    FIELD(L2_TM_PLL_DIG9, TM_CPUMP_CODE_2_MSB, 0, 4)
REG32(L2_TM_PLL_COARSE_CODE_LSB, 0xa028)
    FIELD(L2_TM_PLL_COARSE_CODE_LSB, TM_PLL_COARSE_CODE_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_COARSE_CODE_LSB, TM_COARSE_CODE_LSB, 0, 8)
REG32(L2_TM_PLL_DIG11, 0xa02c)
    FIELD(L2_TM_PLL_DIG11, TM_PLL_DIG11_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG11, TM_CONST_NDAC_CNTRL, 4, 4)
    FIELD(L2_TM_PLL_DIG11, TM_FORCE_COARSE_CODE, 3, 1)
    FIELD(L2_TM_PLL_DIG11, TM_COARSE_CODE_MSB, 0, 3)
REG32(L2_TM_PLL_DIG12, 0xa030)
    FIELD(L2_TM_PLL_DIG12, TM_PLL_DIG12_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG12, TM_FORCE_PTAT_NDAC_CNTRL, 7, 1)
    FIELD(L2_TM_PLL_DIG12, TM_PTAT_NDAC_CNTRL, 1, 6)
    FIELD(L2_TM_PLL_DIG12, TM_FORCE_CONST_NDAC_CNTRL, 0, 1)
REG32(L2_TM_PLL_CONST_PMOS, 0xa034)
    FIELD(L2_TM_PLL_CONST_PMOS, TM_PLL_CONST_PMOS_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_CONST_PMOS, TM_CONST_PMOS_CNTRL, 0, 8)
REG32(L2_TM_PLL_DIG14, 0xa038)
    FIELD(L2_TM_PLL_DIG14, TM_PLL_DIG14_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG14, TM_COARSE_CODE_AFTER_V2I_0_LSB, 1, 7)
    FIELD(L2_TM_PLL_DIG14, TM_FORCE_CONST_PMOS_CNTRL, 0, 1)
REG32(L2_TM_PLL_DIG15, 0xa03c)
    FIELD(L2_TM_PLL_DIG15, TM_PLL_DIG15_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG15, TM_V2I_CODE_0_LSB, 5, 3)
    FIELD(L2_TM_PLL_DIG15, TM_FORCE_COARSE_CODE_AFTER_V2I, 4, 1)
    FIELD(L2_TM_PLL_DIG15, TM_COARSE_CODE_AFTER_V2I_1_MSB, 0, 4)
REG32(L2_TM_PLL_DIG16, 0xa040)
    FIELD(L2_TM_PLL_DIG16, TM_PLL_DIG16_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG16, TM_FORCE_PLL_LOCK, 7, 1)
    FIELD(L2_TM_PLL_DIG16, TM_PLL_LOCK, 6, 1)
    FIELD(L2_TM_PLL_DIG16, TM_FORCE_SS_NO_STEPS_STEP_SIZE, 5, 1)
    FIELD(L2_TM_PLL_DIG16, TM_PLL_RSVD, 4, 1)
    FIELD(L2_TM_PLL_DIG16, TM_FORCE_V2I_CODE, 3, 1)
    FIELD(L2_TM_PLL_DIG16, TM_V2I_CODE_1_MSB, 0, 3)
REG32(L2_TM_PLL_DIG17, 0xa044)
    FIELD(L2_TM_PLL_DIG17, TM_PLL_DIG17_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG17, TM_FB_CLK, 6, 2)
    FIELD(L2_TM_PLL_DIG17, TM_MODE_DEPTH, 3, 3)
    FIELD(L2_TM_PLL_DIG17, TM_MODE_RATE, 0, 3)
REG32(L2_TM_PLL_DIG18, 0xa048)
    FIELD(L2_TM_PLL_DIG18, TM_PLL_DIG18_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG18, TM_PLL_LOCK_PULDN, 7, 1)
    FIELD(L2_TM_PLL_DIG18, TM_STEP_SIZE_CNTRL, 5, 2)
    FIELD(L2_TM_PLL_DIG18, TM_SD_GSHIFT, 3, 2)
    FIELD(L2_TM_PLL_DIG18, TM_SD_DITHER, 1, 2)
    FIELD(L2_TM_PLL_DIG18, TM_PLL_LOCK_INT, 0, 1)
REG32(L2_TM_PLL_DIG19, 0xa04c)
    FIELD(L2_TM_PLL_DIG19, TM_PLL_DIG19_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG19, TM_FORCE_EN_CLOCK_HS_DIV_2, 7, 1)
    FIELD(L2_TM_PLL_DIG19, TM_EN_CLOCK_HS_DIV_2, 6, 1)
    FIELD(L2_TM_PLL_DIG19, TM_PLL_HS_CLOCK_1, 3, 3)
    FIELD(L2_TM_PLL_DIG19, TM_PD_PFD, 2, 1)
    FIELD(L2_TM_PLL_DIG19, TM_FORCE_PD_PFD, 1, 1)
    FIELD(L2_TM_PLL_DIG19, TM_SELECT_PCI_2P5, 0, 1)
REG32(L2_TM_PLL_DIG20, 0xa050)
    FIELD(L2_TM_PLL_DIG20, TM_PLL_DIG20_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG20, TM_PLL_HALF_FULL_RATE, 7, 1)
    FIELD(L2_TM_PLL_DIG20, TM_PLL_RSVD, 6, 1)
    FIELD(L2_TM_PLL_DIG20, TM_V2I_PROG, 1, 5)
    FIELD(L2_TM_PLL_DIG20, TM_FORCE_V2I_PROG, 0, 1)
REG32(L2_TM_PLL_DIG21, 0xa054)
    FIELD(L2_TM_PLL_DIG21, TM_PLL_DIG21_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG21, TM_FORCE_EN_PLL_LDO_0P9_REF, 7, 1)
    FIELD(L2_TM_PLL_DIG21, ANA_TM_EN_PLL_0P9_FORCE_SW, 6, 1)
    FIELD(L2_TM_PLL_DIG21, TM_PLL_PD_OPDIV_SYM, 5, 1)
    FIELD(L2_TM_PLL_DIG21, TM_FORCE_PLL_PD_OPDIV_SYM, 4, 1)
    FIELD(L2_TM_PLL_DIG21, TM_PLL_RSVD_1, 3, 1)
    FIELD(L2_TM_PLL_DIG21, TM_PLL_RSVD_2, 2, 1)
    FIELD(L2_TM_PLL_DIG21, TM_PLL_EN, 1, 1)
    FIELD(L2_TM_PLL_DIG21, TM_FORCE_PLL_EN, 0, 1)
REG32(L2_TM_PLL_DIG22, 0xa058)
    FIELD(L2_TM_PLL_DIG22, TM_PLL_DIG22_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG22, TM_PLL_RSVD, 7, 1)
    FIELD(L2_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF_CP, 6, 1)
    FIELD(L2_TM_PLL_DIG22, TM_FORCE_EN_PLL_LDO_0P9_REF_CP, 5, 1)
    FIELD(L2_TM_PLL_DIG22, TM_FORCE_COARSE_START, 4, 1)
    FIELD(L2_TM_PLL_DIG22, TM_FORCE_PD_PLL_LDO_1P4, 3, 1)
    FIELD(L2_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL_DELAYED, 2, 1)
    FIELD(L2_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL, 1, 1)
    FIELD(L2_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF, 0, 1)
REG32(L2_TM_PLL_DIG23, 0xa05c)
    FIELD(L2_TM_PLL_DIG23, TM_PLL_DIG23_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG23, BF_7, 7, 1)
    FIELD(L2_TM_PLL_DIG23, PLL_TM_VCO_LDO_BYPASS, 6, 1)
    FIELD(L2_TM_PLL_DIG23, TM_ANA_EN_LL_DELAYED, 5, 1)
    FIELD(L2_TM_PLL_DIG23, TM_ANA_EN_LL, 4, 1)
    FIELD(L2_TM_PLL_DIG23, TM_ANA_PD_PLL, 3, 1)
    FIELD(L2_TM_PLL_DIG23, TM_FORCE_PLL_PD, 2, 1)
    FIELD(L2_TM_PLL_DIG23, TM_ANA_COARSE_START, 1, 1)
    FIELD(L2_TM_PLL_DIG23, TM_PD_PLL_LDO_1P4, 0, 1)
REG32(L2_TM_PLL_DIG24, 0xa060)
    FIELD(L2_TM_PLL_DIG24, TM_PLL_DIG24_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG24, TM_PLL_RSVD, 7, 1)
    FIELD(L2_TM_PLL_DIG24, PLL_TM_VCO_LDO, 1, 6)
    FIELD(L2_TM_PLL_DIG24, PLL_TM_VCO_LDO_BYPASS_WITH_SEQUENCE, 0, 1)
REG32(L2_TM_PLL_DIG25, 0xa064)
    FIELD(L2_TM_PLL_DIG25, TM_PLL_DIG25_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG25, TM_FORCE_RST_N_HSRIPPLE, 7, 1)
    FIELD(L2_TM_PLL_DIG25, TM_RST_N_HSRIPPLE, 6, 1)
    FIELD(L2_TM_PLL_DIG25, TM_PLL_ATB_CNTRL, 1, 5)
    FIELD(L2_TM_PLL_DIG25, TM_PLL_OBSERVE_PTAT_10U, 0, 1)
REG32(L2_TM_PLL_DIG26, 0xa068)
    FIELD(L2_TM_PLL_DIG26, TM_PLL_DIG26_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG26, TM_PLL_RSVD, 7, 1)
    FIELD(L2_TM_PLL_DIG26, TM_PD_PLL_PTAT, 6, 1)
    FIELD(L2_TM_PLL_DIG26, TM_FORCE_PD_PLL_PTAT, 5, 1)
    FIELD(L2_TM_PLL_DIG26, TM_USB3_R2_HIGH_RES_SW_ON, 4, 1)
    FIELD(L2_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIV2_LOOP_OUT, 3, 1)
    FIELD(L2_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIRECT_LOOP_OUT, 2, 1)
    FIELD(L2_TM_PLL_DIG26, TM_PLL_SEL_VCO_HISPEED_DIV2_LOOP_OUT, 1, 1)
    FIELD(L2_TM_PLL_DIG26, TM_FORCE_LOOP_PATH, 0, 1)
REG32(L2_TM_PLL_CLK_DIST_NTRIM_LSB, 0xa06c)
    FIELD(L2_TM_PLL_CLK_DIST_NTRIM_LSB, TM_PLL_CLK_DIST_NTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_CLK_DIST_NTRIM_LSB, TM_CLKDIST_BIAS_NTRIM_LSB, 0, 8)
REG32(L2_TM_PLL_CLK_DIST_PTRIM_LSB, 0xa070)
    FIELD(L2_TM_PLL_CLK_DIST_PTRIM_LSB, TM_PLL_CLK_DIST_PTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_CLK_DIST_PTRIM_LSB, TM_CLKDIST_BIAS_PTRIM_LSB, 0, 8)
REG32(L2_TM_PLL_DIG_29, 0xa074)
    FIELD(L2_TM_PLL_DIG_29, TM_PLL_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_MRSTBUF_SUP, 7, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_LRSTBUF_SUP, 6, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_RST_RPTR, 5, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_RST_RPTR, 4, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_CLK_RPTR, 3, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_CLK_RPTR, 2, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_CLKDIST_BIAS_PTRIM_MSB, 1, 1)
    FIELD(L2_TM_PLL_DIG_29, TM_CLKDIST_BIAS_NTRIM_MSB, 0, 1)
REG32(L2_TM_PLL_DIG_30, 0xa078)
    FIELD(L2_TM_PLL_DIG_30, TM_PLL_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_BIAS, 7, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_BIAS, 6, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_CMN_BIAS, 5, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_CMN_BIAS, 4, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_CLKDIST_SUP_OBSRV, 3, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RSTMUX_SUP, 2, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RPTR_RSTBUF_SUP, 1, 1)
    FIELD(L2_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_MUS_SUP, 0, 1)
REG32(L2_TM_PLL_DIG_31, 0xa07c)
    FIELD(L2_TM_PLL_DIG_31, TM_PLL_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 7, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 6, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_RST_DRIVE, 5, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_RST_DRIVE, 4, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_CLK_DRIVE, 3, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_CLK_DRIVE, 2, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_CLKDIST_BIAS_RATE_SEL, 1, 1)
    FIELD(L2_TM_PLL_DIG_31, TM_FORCE_CLKDIST_BIAS_RATE_SEL, 0, 1)
REG32(L2_TM_PLL_DIG_32, 0xa080)
    FIELD(L2_TM_PLL_DIG_32, TM_PLL_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_32, TM_CLKDIST_MUX_XVCR_CLK_EN, 7, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_FORCE_CLKDIST_MUX_XVCR_CLK_EN, 6, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_FORCE_LOAD_FBDIV, 5, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_LOAD_FBDIV, 4, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_FORCE_RST_FDBK_DIV, 3, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_RST_FDBK_DIV, 2, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_CLKDIST_ENABLE_MASTER_RST_DRIVE, 1, 1)
    FIELD(L2_TM_PLL_DIG_32, TM_FORCE_CLKDIST_ENABLE_MASTER_RST_DRIVE, 0, 1)
REG32(L2_TM_PLL_DIG_33, 0xa084)
    FIELD(L2_TM_PLL_DIG_33, TM_PLL_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_33, TM_FORCE_TX_CLK_RST_REL, 7, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_TX_CLK_RST_REL, 6, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_CLKDIST_MUX_XCVR_MASTER_RST_EN, 5, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_XCVR_MASTER_RST_EN, 4, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_CLKDIST_MUX_MASTER_CLK_SEL, 3, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_MASTER_CLK_SEL, 2, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_CLKDIST_MUX_LOCAL_CLK_SEL, 1, 1)
    FIELD(L2_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_LOCAL_CLK_SEL, 0, 1)
REG32(L2_TM_PLL_DIG_34, 0xa088)
    FIELD(L2_TM_PLL_DIG_34, TM_PLL_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_34, TM_PLL_RSVD, 7, 1)
    FIELD(L2_TM_PLL_DIG_34, TM_FBDIV_3_MSB, 2, 5)
    FIELD(L2_TM_PLL_DIG_34, TM_SEL_VCO_OUT, 1, 1)
    FIELD(L2_TM_PLL_DIG_34, TM_FORCE_SEL_VCO_OUT, 0, 1)
REG32(L2_TM_PLL_DIG_35, 0xa08c)
    FIELD(L2_TM_PLL_DIG_35, TM_PLL_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_35, TM_CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L2_TM_PLL_DIG_35, TM_CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L2_TM_PLL_DIG_35, TM_CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L2_TM_PLL_DIG_35, TM_CLKDIST_RPTR_SPARE, 0, 2)
REG32(L2_TM_PLL_DIG_36, 0xa090)
    FIELD(L2_TM_PLL_DIG_36, TM_PLL_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_36, CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L2_TM_PLL_DIG_36, CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L2_TM_PLL_DIG_36, CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L2_TM_PLL_DIG_36, CLKDIST_RPTR_SPARE, 0, 2)
REG32(L2_TM_PLL_DIG_37, 0xa094)
    FIELD(L2_TM_PLL_DIG_37, TM_PLL_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_DIG_37, TM_COARSE_CODE_SAT_VALUE_LSB, 5, 3)
    FIELD(L2_TM_PLL_DIG_37, TM_ENABLE_COARSE_SATURATION, 4, 1)
    FIELD(L2_TM_PLL_DIG_37, W_SPARE_OUTPUTS, 2, 2)
    FIELD(L2_TM_PLL_DIG_37, TM_FORCE_EN_IP_DIV_BYPASS, 1, 1)
    FIELD(L2_TM_PLL_DIG_37, TM_EN_IP_DIV_BYPASS, 0, 1)
REG32(L2_TM_PLL_COARSE_CODE_SAT_MSB, 0xa098)
    FIELD(L2_TM_PLL_COARSE_CODE_SAT_MSB, TM_PLL_COARSE_CODE_SAT_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_TM_PLL_COARSE_CODE_SAT_MSB, TM_COARSE_CODE_SAT_VALUE_MSB, 0, 8)
REG32(L2_MPHY_CFG_HIB8, 0xa300)
    FIELD(L2_MPHY_CFG_HIB8, MPHY_CFG_HIB8_31_8_RSVD, 24, 8)
    FIELD(L2_MPHY_CFG_HIB8, MPHY_HIBERN8_RSVD, 1, 7)
    FIELD(L2_MPHY_CFG_HIB8, MPHY_HIBERN8, 0, 1)
REG32(L2_MPHY_CFG_MODE, 0xa304)
    FIELD(L2_MPHY_CFG_MODE, MPHY_CFG_MODE_31_8_RSVD, 24, 8)
    FIELD(L2_MPHY_CFG_MODE, MPHY_HS_LS_MODE_RSVD, 2, 6)
    FIELD(L2_MPHY_CFG_MODE, MPHY_HS_LS_MODE, 0, 2)
REG32(L2_MPHY_CFG_HS_GEAR, 0xa308)
    FIELD(L2_MPHY_CFG_HS_GEAR, MPHY_CFG_HS_GEAR_31_8_RSVD, 24, 8)
    FIELD(L2_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR_RSVD, 2, 6)
    FIELD(L2_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR, 0, 2)
REG32(L2_MPHY_CFG_HS_RATE, 0xa30c)
    FIELD(L2_MPHY_CFG_HS_RATE, MPHY_CFG_HS_RATE_31_8_RSVD, 24, 8)
    FIELD(L2_MPHY_CFG_HS_RATE, MPHY_RATE_RSVD, 1, 7)
    FIELD(L2_MPHY_CFG_HS_RATE, MPHY_RATE, 0, 1)
REG32(L2_MPHY_CFG_PWM, 0xa310)
    FIELD(L2_MPHY_CFG_PWM, MPHY_CFG_PWM_31_8_RSVD, 24, 8)
    FIELD(L2_MPHY_CFG_PWM, MPHY_PWM_GEAR_RSVD, 3, 5)
    FIELD(L2_MPHY_CFG_PWM, MPHY_PWM_GEAR, 0, 3)
REG32(L2_PLL_OPDIV_LS, 0xa314)
    FIELD(L2_PLL_OPDIV_LS, PLL_OPDIV_LS_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_OPDIV_LS, TM_SEL_OPDIV_FOR_REFCLK, 7, 1)
    FIELD(L2_PLL_OPDIV_LS, ANA_OPDIV_LS, 0, 7)
REG32(L2_MPHY_CFG_UPDT, 0xa318)
    FIELD(L2_MPHY_CFG_UPDT, MPHY_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L2_MPHY_CFG_UPDT, MPHY_CFGUPDT_RSVD, 1, 7)
    FIELD(L2_MPHY_CFG_UPDT, MPHY_CFGUPDT, 0, 1)
REG32(L2_PLL_TM_DIV_CNTRLS, 0xa31c)
    FIELD(L2_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_DIV_CNTRLS, TM_FORCE_PD_OPDIV_LS, 7, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, TM_PD_OPDIV_LS, 6, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_RSVD, 5, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, TM_BYPASS_OPDIV_LS_MOD, 4, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, TM_FORCE_PLL_PD_HS, 3, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, TM_PLL_PD_HS, 2, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, SEL_IP_MUX_CONTROL, 1, 1)
    FIELD(L2_PLL_TM_DIV_CNTRLS, TM_SWAP_OP_MUX_CONTROL, 0, 1)
REG32(L2_PLL_FBDIV_G1A_LSB, 0xa320)
    FIELD(L2_PLL_FBDIV_G1A_LSB, PLL_FBDIV_G1A_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G1A_LSB, FBDIV_G1A_LSB, 0, 8)
REG32(L2_PLL_FBDIV_G1B_LSB, 0xa324)
    FIELD(L2_PLL_FBDIV_G1B_LSB, PLL_FBDIV_G1B_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G1B_LSB, FBDIV_G1B_LSB, 0, 8)
REG32(L2_PLL_FBDIV_G2A_LSB, 0xa328)
    FIELD(L2_PLL_FBDIV_G2A_LSB, PLL_FBDIV_G2A_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G2A_LSB, FBDIV_G2A_LSB, 0, 8)
REG32(L2_PLL_FBDIV_G2B_LSB, 0xa32c)
    FIELD(L2_PLL_FBDIV_G2B_LSB, PLL_FBDIV_G2B_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G2B_LSB, FBDIV_G2B_LSB, 0, 8)
REG32(L2_PLL_FBDIV_G3A_LSB, 0xa330)
    FIELD(L2_PLL_FBDIV_G3A_LSB, PLL_FBDIV_G3A_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G3A_LSB, FBDIV_G3A_LSB, 0, 8)
REG32(L2_PLL_FBDIV_G3B_LSB, 0xa334)
    FIELD(L2_PLL_FBDIV_G3B_LSB, PLL_FBDIV_G3B_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G3B_LSB, FBDIV_G3B_LSB, 0, 8)
REG32(L2_PLL_FBDIV_G1A_MSB, 0xa338)
    FIELD(L2_PLL_FBDIV_G1A_MSB, PLL_FBDIV_G1A_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G1A_MSB, FBDIV_G1A_MSB, 0, 8)
REG32(L2_PLL_FBDIV_G1B_MSB, 0xa33c)
    FIELD(L2_PLL_FBDIV_G1B_MSB, PLL_FBDIV_G1B_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G1B_MSB, FBDIV_G1B_MSB, 0, 8)
REG32(L2_PLL_FBDIV_G2A_MSB, 0xa340)
    FIELD(L2_PLL_FBDIV_G2A_MSB, PLL_FBDIV_G2A_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G2A_MSB, FBDIV_G2A_MSB, 0, 8)
REG32(L2_PLL_FBDIV_G2B_MSB, 0xa344)
    FIELD(L2_PLL_FBDIV_G2B_MSB, PLL_FBDIV_G2B_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G2B_MSB, FBDIV_G2B_MSB, 0, 8)
REG32(L2_PLL_FBDIV_G3A_MSB, 0xa348)
    FIELD(L2_PLL_FBDIV_G3A_MSB, PLL_FBDIV_G3A_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G3A_MSB, FBDIV_G3A_MSB, 0, 8)
REG32(L2_PLL_FBDIV_G3B_MSB, 0xa34c)
    FIELD(L2_PLL_FBDIV_G3B_MSB, PLL_FBDIV_G3B_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_G3B_MSB, FBDIV_G3B_MSB, 0, 8)
REG32(L2_PLL_IPDIV, 0xa350)
    FIELD(L2_PLL_IPDIV, PLL_IPDIV_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_IPDIV, PLL_IPDIV, 0, 8)
REG32(L2_PLL_FBDIV_FRAC_0_LSB, 0xa354)
    FIELD(L2_PLL_FBDIV_FRAC_0_LSB, PLL_FBDIV_FRAC_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_FRAC_0_LSB, FBDIV_FRAC_0_LSB, 0, 8)
REG32(L2_PLL_FBDIV_FRAC_1, 0xa358)
    FIELD(L2_PLL_FBDIV_FRAC_1, PLL_FBDIV_FRAC_1_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_FRAC_1, FBDIV_FRAC_1, 0, 8)
REG32(L2_PLL_FBDIV_FRAC_2, 0xa35c)
    FIELD(L2_PLL_FBDIV_FRAC_2, PLL_FBDIV_FRAC_2_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_FRAC_2, FBDIV_FRAC_2, 0, 8)
REG32(L2_PLL_FBDIV_FRAC_3_MSB, 0xa360)
    FIELD(L2_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSV_RSVD, 7, 1)
    FIELD(L2_PLL_FBDIV_FRAC_3_MSB, TM_FORCE_EN_FRAC, 6, 1)
    FIELD(L2_PLL_FBDIV_FRAC_3_MSB, TM_EN_FRAC, 5, 1)
    FIELD(L2_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB_RSVD, 3, 2)
    FIELD(L2_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB, 0, 3)
REG32(L2_PLL_PWR_SEQ_WAIT_TIME, 0xa364)
    FIELD(L2_PLL_PWR_SEQ_WAIT_TIME, PLL_PWR_SEQ_WAIT_TIME_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_SETTLING, 6, 2)
    FIELD(L2_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_BIAS_SETTLING, 4, 2)
    FIELD(L2_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_SETTLING, 2, 2)
    FIELD(L2_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_RELIABILITY, 0, 2)
REG32(L2_PLL_SS_STEPS_0_LSB, 0xa368)
    FIELD(L2_PLL_SS_STEPS_0_LSB, PLL_SS_STEPS_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_SS_STEPS_0_LSB, SS_NUM_OF_STEPS_0_LSB, 0, 8)
REG32(L2_PLL_SS_STEPS_1_MSB, 0xa36c)
    FIELD(L2_PLL_SS_STEPS_1_MSB, PLL_SS_STEPS_1_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB_RSVD, 3, 5)
    FIELD(L2_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB, 0, 3)
REG32(L2_PLL_SS_STEP_SIZE_0_LSB, 0xa370)
    FIELD(L2_PLL_SS_STEP_SIZE_0_LSB, PLL_SS_STEP_SIZE_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_SS_STEP_SIZE_0_LSB, SS_STEP_SIZE_0_LSB, 0, 8)
REG32(L2_PLL_SS_STEP_SIZE_1, 0xa374)
    FIELD(L2_PLL_SS_STEP_SIZE_1, PLL_SS_STEP_SIZE_1_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_SS_STEP_SIZE_1, SS_STEP_SIZE_1, 0, 8)
REG32(L2_PLL_SS_STEP_SIZE_2, 0xa378)
    FIELD(L2_PLL_SS_STEP_SIZE_2, PLL_SS_STEP_SIZE_2_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_SS_STEP_SIZE_2, SS_STEP_SIZE_2, 0, 8)
REG32(L2_PLL_SS_STEP_SIZE_3_MSB, 0xa37c)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, PLL_SS_STEP_SIZE_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, TM_FORCE_EN_SS, 7, 1)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, TM_EN_SS, 6, 1)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_NUM_OF_STEPS, 5, 1)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_STEP_SIZE, 4, 1)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, SS_SPREAD_TYPE, 2, 2)
    FIELD(L2_PLL_SS_STEP_SIZE_3_MSB, SS_STEP_SIZE_3_MSB, 0, 2)
REG32(L2_TM_MASK_CFG_UPDT, 0xa380)
    FIELD(L2_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L2_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_RSVD, 7, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, HIBERN8_MASK_CFG_UPDT, 6, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, HS_MODE_MASK_CFG_UPDT, 5, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, LS_MODE_MASK_CFG_UPDT, 4, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, OPDIV_LS_MASK_CFG_UPDT, 3, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, PWM_GEAR_MASK_CFG_UPDT, 2, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, HS_GEAR_MASK_CFG_UPDT, 1, 1)
    FIELD(L2_TM_MASK_CFG_UPDT, HS_RATE_MASK_CFG_UPDT, 0, 1)
REG32(L2_PLL_TM_FORCE_DIV, 0xa384)
    FIELD(L2_PLL_TM_FORCE_DIV, PLL_TM_FORCE_DIV_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_FRAC, 7, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3B, 6, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3A, 5, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2B, 4, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2A, 3, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1B, 2, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1A, 1, 1)
    FIELD(L2_PLL_TM_FORCE_DIV, TM_FORCE_IPDIV, 0, 1)
REG32(L2_PLL_TM_COARSE_CODE_1_LSB, 0xa388)
    FIELD(L2_PLL_TM_COARSE_CODE_1_LSB, PLL_TM_COARSE_CODE_1_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_1_LSB, TM_COARSE_CODE_1_LSB, 0, 8)
REG32(L2_PLL_TM_COARSE_CODE_2_LSB, 0xa38c)
    FIELD(L2_PLL_TM_COARSE_CODE_2_LSB, PLL_TM_COARSE_CODE_2_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_2_LSB, TM_COARSE_CODE_2_LSB, 0, 8)
REG32(L2_PLL_TM_COARSE_CODE_3_LSB, 0xa390)
    FIELD(L2_PLL_TM_COARSE_CODE_3_LSB, PLL_TM_COARSE_CODE_3_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_3_LSB, TM_COARSE_CODE_3_LSB, 0, 8)
REG32(L2_PLL_TM_COARSE_CODE_4_LSB, 0xa394)
    FIELD(L2_PLL_TM_COARSE_CODE_4_LSB, PLL_TM_COARSE_CODE_4_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_4_LSB, TM_COARSE_CODE_4_LSB, 0, 8)
REG32(L2_PLL_TM_COARSE_CODE_5_LSB, 0xa398)
    FIELD(L2_PLL_TM_COARSE_CODE_5_LSB, PLL_TM_COARSE_CODE_5_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_5_LSB, TM_COARSE_CODE_5_LSB, 0, 8)
REG32(L2_PLL_TM_COARSE_CODE_6_LSB, 0xa39c)
    FIELD(L2_PLL_TM_COARSE_CODE_6_LSB, PLL_TM_COARSE_CODE_6_LSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_6_LSB, TM_COARSE_CODE_6_LSB, 0, 8)
REG32(L2_PLL_TM_COARSE_CODE_1_2_MSB, 0xa3a0)
    FIELD(L2_PLL_TM_COARSE_CODE_1_2_MSB, PLL_TM_COARSE_CODE_1_2_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_G1_AB_MSB_RSVD, 6, 2)
    FIELD(L2_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_2_MSB, 3, 3)
    FIELD(L2_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_1_MSB, 0, 3)
REG32(L2_PLL_TM_COARSE_CODE_3_4_MSB, 0xa3a4)
    FIELD(L2_PLL_TM_COARSE_CODE_3_4_MSB, PLL_TM_COARSE_CODE_3_4_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_G2_AB_MSB_RSVD, 6, 2)
    FIELD(L2_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_4_MSB, 3, 3)
    FIELD(L2_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_3_MSB, 0, 3)
REG32(L2_PLL_TM_COARSE_CODE_5_6_MSB, 0xa3a8)
    FIELD(L2_PLL_TM_COARSE_CODE_5_6_MSB, PLL_TM_COARSE_CODE_5_6_MSB_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_G3_AB_MSB_RSVD, 6, 2)
    FIELD(L2_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_6_MSB, 3, 3)
    FIELD(L2_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_5_MSB, 0, 3)
REG32(L2_PLL_TM_SHARED_0, 0xa3ac)
    FIELD(L2_PLL_TM_SHARED_0, PLL_TM_SHARED_0_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_SHARED_0, TM_FORCE_EXTSIGNAL_FOR_HIBERN8, 7, 1)
    FIELD(L2_PLL_TM_SHARED_0, TM_FORCE_REGBIT_FOR_HIBERN8, 6, 1)
    FIELD(L2_PLL_TM_SHARED_0, TM_FORCE_PLL_STANDBY, 5, 1)
    FIELD(L2_PLL_TM_SHARED_0, TM_PLL_STANDBY, 4, 1)
    FIELD(L2_PLL_TM_SHARED_0, TM_SLOWN_FAST_BRING_UP_ALWAYS, 3, 1)
    FIELD(L2_PLL_TM_SHARED_0, EN_TM_FOR_BRING_UP_SCHEME, 2, 1)
    FIELD(L2_PLL_TM_SHARED_0, SELECT_HS_FB_DIVIDER, 1, 1)
    FIELD(L2_PLL_TM_SHARED_0, TM_BYPASS_COARSE_SEARCH, 0, 1)
REG32(L2_PLL_TM_FRAC_OFFSET_0, 0xa3b0)
    FIELD(L2_PLL_TM_FRAC_OFFSET_0, PLL_TM_FRAC_OFFSET_0_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_FRAC_OFFSET_0, TM_FRAC_OFFSET_LSB_0, 0, 8)
REG32(L2_PLL_TM_FRAC_OFFSET_1, 0xa3b4)
    FIELD(L2_PLL_TM_FRAC_OFFSET_1, PLL_TM_FRAC_OFFSET_1_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_FRAC_OFFSET_1, TM_FRAC_OFFSET_1, 0, 8)
REG32(L2_PLL_TM_FRAC_OFFSET_2, 0xa3b8)
    FIELD(L2_PLL_TM_FRAC_OFFSET_2, PLL_TM_FRAC_OFFSET_2_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_TM_FRAC_OFFSET_2, TM_PLL_RSVD, 2, 6)
    FIELD(L2_PLL_TM_FRAC_OFFSET_2, TM_FORCE_FBDIV_FRAC_OFFSET, 1, 1)
    FIELD(L2_PLL_TM_FRAC_OFFSET_2, TM_FRAC_OFFSET_MSB_2, 0, 1)
REG32(L2_PLL_STATUS_READ_0, 0xa3e0)
    FIELD(L2_PLL_STATUS_READ_0, PLL_STATUS_READ_0_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_STATUS_READ_0, PLL_COARSE_CODE_LSB_STATUS_READ, 0, 8)
REG32(L2_PLL_STATUS_READ_1, 0xa3e4)
    FIELD(L2_PLL_STATUS_READ_1, PLL_STATUS_READ_1_31_8_RSVD, 24, 8)
    FIELD(L2_PLL_STATUS_READ_1, PLL_STATUS_READ_1_RSVD, 6, 2)
    FIELD(L2_PLL_STATUS_READ_1, PLL_START_LOOP_STATUS_READ, 5, 1)
    FIELD(L2_PLL_STATUS_READ_1, PLL_LOCK_STATUS_READ, 4, 1)
    FIELD(L2_PLL_STATUS_READ_1, PLL_COARSE_DONE_STATUS_READ, 3, 1)
    FIELD(L2_PLL_STATUS_READ_1, PLL_COARSE_CODE_MSB_STATUS_READ, 0, 3)
REG32(L2_UPHY_GLOBAL_CTRL, 0xb000)
    FIELD(L2_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_31_8_RSVD, 24, 8)
    FIELD(L2_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_7_RSVD, 7, 1)
    FIELD(L2_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_6_RSVD, 6, 1)
    FIELD(L2_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_5_RSVD, 5, 1)
    FIELD(L2_UPHY_GLOBAL_CTRL, PCLK_SELECT, 4, 1)
    FIELD(L2_UPHY_GLOBAL_CTRL, MPHY_G3_BIST_ENABLE, 3, 1)
    FIELD(L2_UPHY_GLOBAL_CTRL, MULTI_RATE_ENABLE, 2, 1)
    FIELD(L2_UPHY_GLOBAL_CTRL, MPHY_GEAR_SELECT, 0, 2)
REG32(L2_BIST_CTRL_1, 0xb004)
    FIELD(L2_BIST_CTRL_1, BIST_CTRL_1_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_CTRL_1, REPETITIVE_PATTERN_ENABLE, 7, 1)
    FIELD(L2_BIST_CTRL_1, PRBS_PATTERNS, 5, 2)
    FIELD(L2_BIST_CTRL_1, BIST_PATTERN_SELECT, 2, 3)
    FIELD(L2_BIST_CTRL_1, BIST_INFINITE_MODE_ENABLE, 1, 1)
    FIELD(L2_BIST_CTRL_1, BIST_ENABLE, 0, 1)
REG32(L2_BIST_CTRL_2, 0xb008)
    FIELD(L2_BIST_CTRL_2, BIST_CTRL_2_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_CTRL_2, BIST_CTRL_2_7_3_RSVD, 3, 5)
    FIELD(L2_BIST_CTRL_2, BIST_TRAINIG_SEQUENCE_SELECT, 1, 2)
    FIELD(L2_BIST_CTRL_2, BIST_ERROR_INJECTION_ENABLE, 0, 1)
REG32(L2_BIST_RUN_LEN_L, 0xb00c)
    FIELD(L2_BIST_RUN_LEN_L, BIST_RUN_LEN_L_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_RUN_LEN_L, BIST_RUN_LEN_L, 0, 8)
REG32(L2_BIST_ERR_INJ_POINT_L, 0xb010)
    FIELD(L2_BIST_ERR_INJ_POINT_L, BIST_ERR_INJ_POINT_L_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_ERR_INJ_POINT_L, BIST_ERROR_INJ_POINT_L, 0, 8)
REG32(L2_BIST_RUNLEN_ERR_INJ_H, 0xb014)
    FIELD(L2_BIST_RUNLEN_ERR_INJ_H, BIST_RUNLEN_ERR_INJ_H_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_RUNLEN_ERR_INJ_H, BIST_RUN_LEN_H, 4, 4)
    FIELD(L2_BIST_RUNLEN_ERR_INJ_H, BIST_ERROR_INJ_POINT_H, 0, 4)
REG32(L2_BIST_IDLE_TIME, 0xb018)
    FIELD(L2_BIST_IDLE_TIME, BIST_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_IDLE_TIME, BIST_IDLE_TIME, 0, 8)
REG32(L2_BIST_MARKER_L, 0xb01c)
    FIELD(L2_BIST_MARKER_L, BIST_MARKER_L_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_MARKER_L, BIST_MARKER_L, 0, 8)
REG32(L2_BIST_IDLE_CHAR_L, 0xb020)
    FIELD(L2_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L, 0, 8)
REG32(L2_BIST_MARKER_IDLE_H, 0xb024)
    FIELD(L2_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_H_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_7, 6, 2)
    FIELD(L2_BIST_MARKER_IDLE_H, BIST_MARKER_H, 4, 2)
    FIELD(L2_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_3, 2, 2)
    FIELD(L2_BIST_MARKER_IDLE_H, BIST_IDLE_CHAR_H, 0, 2)
REG32(L2_BIST_LOW_PULSE_TIME, 0xb028)
    FIELD(L2_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME, 0, 8)
REG32(L2_BIST_TOTAL_PULSE_TIME, 0xb02c)
    FIELD(L2_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME, 0, 8)
REG32(L2_BIST_TEST_PAT_1, 0xb030)
    FIELD(L2_BIST_TEST_PAT_1, BIST_TEST_PAT_1_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_TEST_PAT_1, BIST_TEST_PAT_1_L, 0, 8)
REG32(L2_BIST_TEST_PAT_2, 0xb034)
    FIELD(L2_BIST_TEST_PAT_2, BIST_TEST_PAT_2_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_TEST_PAT_2, BIST_TEST_PAT_2_L, 0, 8)
REG32(L2_BIST_TEST_PAT_3, 0xb038)
    FIELD(L2_BIST_TEST_PAT_3, BIST_TEST_PAT_3_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_TEST_PAT_3, BIST_TEST_PAT_3_L, 0, 8)
REG32(L2_BIST_TEST_PAT_4, 0xb03c)
    FIELD(L2_BIST_TEST_PAT_4, BIST_TEST_PAT_4_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_TEST_PAT_4, BIST_TEST_PAT_4_L, 0, 8)
REG32(L2_BIST_TEST_PAT_MSBS, 0xb040)
    FIELD(L2_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_MSBS_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_4_H, 6, 2)
    FIELD(L2_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_3_H, 4, 2)
    FIELD(L2_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_2_H, 2, 2)
    FIELD(L2_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_1_H, 0, 2)
REG32(L2_BIST_PKT_NUM, 0xb044)
    FIELD(L2_BIST_PKT_NUM, BIST_PKT_NUM_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_PKT_NUM, BIST_PKT_NUM, 0, 8)
REG32(L2_BIST_FRM_IDLE_TIME, 0xb048)
    FIELD(L2_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME, 0, 8)
REG32(L2_BIST_PKT_CTR_L, 0xb04c)
    FIELD(L2_BIST_PKT_CTR_L, BIST_PKT_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_PKT_CTR_L, BIST_PKT_CTR_L, 0, 8)
REG32(L2_BIST_PKT_CTR_H, 0xb050)
    FIELD(L2_BIST_PKT_CTR_H, BIST_PKT_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_PKT_CTR_H, BIST_PKT_CTR_H, 0, 8)
REG32(L2_BIST_ERR_CTR_L, 0xb054)
    FIELD(L2_BIST_ERR_CTR_L, BIST_ERR_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_ERR_CTR_L, BIST_ERR_CTR_L, 0, 8)
REG32(L2_BIST_ERR_CTR_H, 0xb058)
    FIELD(L2_BIST_ERR_CTR_H, BIST_ERR_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_ERR_CTR_H, BIST_ERR_CTR_H, 0, 8)
REG32(L2_CLK_DIV_CNT, 0xb05c)
    FIELD(L2_CLK_DIV_CNT, CLK_DIV_CNT_31_8_RSVD, 24, 8)
    FIELD(L2_CLK_DIV_CNT, REF_CLK_BYPASS_GT_50MHZ, 7, 1)
    FIELD(L2_CLK_DIV_CNT, SLOW_CNT_REG, 0, 7)
REG32(L2_DATA_BUS_WID, 0xb060)
    FIELD(L2_DATA_BUS_WID, DATA_BUS_WID_31_8_RSVD, 24, 8)
    FIELD(L2_DATA_BUS_WID, RATE_CHANGE_BYPASS, 7, 1)
    FIELD(L2_DATA_BUS_WID, PCLK_RATIO_BY_4, 6, 1)
    FIELD(L2_DATA_BUS_WID, PCLK_RATIO_BY_2, 5, 1)
    FIELD(L2_DATA_BUS_WID, RATE_CHANGE_DELAY_SEL, 4, 1)
    FIELD(L2_DATA_BUS_WID, RATE_CHANGE_DELAY_COUNT, 0, 4)
REG32(L2_ANADIG_BYPASS, 0xb064)
    FIELD(L2_ANADIG_BYPASS, ANADIG_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L2_ANADIG_BYPASS, ANA_DIG_COUNTER_SELECT, 7, 1)
    FIELD(L2_ANADIG_BYPASS, ANADIG_COUNT, 0, 7)
REG32(L2_BIST_FILLER_OUT, 0xb068)
    FIELD(L2_BIST_FILLER_OUT, BIST_FILLER_OUT_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_FILLER_OUT, BIST_FILLER_OUT_RESERVED, 2, 6)
    FIELD(L2_BIST_FILLER_OUT, BIST_FILLER_OUT_ENABLE, 1, 1)
    FIELD(L2_BIST_FILLER_OUT, BIST_TX_RX_LOOPBACK_ENABLE, 0, 1)
REG32(L2_BIST_FORCE_MK_RST, 0xb06c)
    FIELD(L2_BIST_FORCE_MK_RST, BIST_FORCE_MK_RST_31_8_RSVD, 24, 8)
    FIELD(L2_BIST_FORCE_MK_RST, BIST_FORCE_RESET, 1, 1)
    FIELD(L2_BIST_FORCE_MK_RST, BIST_ENABLE_MK_FROM_REG, 0, 1)
REG32(L2_SPARE_IN, 0xb070)
    FIELD(L2_SPARE_IN, SPARE_IN_31_8_RSVD, 24, 8)
    FIELD(L2_SPARE_IN, SPARE_IN, 0, 8)
REG32(L2_SPARE_OUT, 0xb074)
    FIELD(L2_SPARE_OUT, SPARE_OUT_31_8_RSVD, 24, 8)
    FIELD(L2_SPARE_OUT, SPARE_OUT, 0, 8)
REG32(L3_TX_ANA_TM_0, 0xc000)
    FIELD(L3_TX_ANA_TM_0, TX_ANA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_0, ANA_BYP0_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_0, PIPE_TX_DN_RXDET, 5, 1)
    FIELD(L3_TX_ANA_TM_0, FORCE_PIPE_TX_DN_RXDET, 4, 1)
    FIELD(L3_TX_ANA_TM_0, PIPE_TX_DP_RXDET, 3, 1)
    FIELD(L3_TX_ANA_TM_0, FORCE_PIPE_TX_DP_RXDET, 2, 1)
    FIELD(L3_TX_ANA_TM_0, ANA_BYP0_1_0_RSVD, 0, 2)
REG32(L3_TX_ANA_TM_3, 0xc00c)
    FIELD(L3_TX_ANA_TM_3, TX_ANA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_3, TX_HS_SER_RSTB, 7, 1)
    FIELD(L3_TX_ANA_TM_3, FORCE_TX_HS_SER_RSTB, 6, 1)
    FIELD(L3_TX_ANA_TM_3, TX_HS_BURST, 5, 1)
    FIELD(L3_TX_ANA_TM_3, FORCE_TX_HS_BURST, 4, 1)
    FIELD(L3_TX_ANA_TM_3, TX_SERIALIZER_ENABLE, 3, 1)
    FIELD(L3_TX_ANA_TM_3, FORCE_TX_SERIALIZER_ENABLE, 2, 1)
    FIELD(L3_TX_ANA_TM_3, TX_ENABLE_SUPPLY_SERIALIZER, 1, 1)
    FIELD(L3_TX_ANA_TM_3, FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 0, 1)
REG32(L3_TX_ANA_TM_4, 0xc010)
    FIELD(L3_TX_ANA_TM_4, TX_ANA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_4, ANA_BYP4_7_RSVD, 7, 1)
    FIELD(L3_TX_ANA_TM_4, TX_LSEG_DN_RESCAL_CODE, 1, 6)
    FIELD(L3_TX_ANA_TM_4, FORCE_TX_LSEG_DN_RESCAL_CODE, 0, 1)
REG32(L3_TX_ANA_TM_5, 0xc014)
    FIELD(L3_TX_ANA_TM_5, TX_ANA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_5, ANA_BYP5_7_RSVD, 7, 1)
    FIELD(L3_TX_ANA_TM_5, TX_USEG_DP_RESCAL_CODE, 1, 6)
    FIELD(L3_TX_ANA_TM_5, FORCE_TX_USEG_DP_RESCAL_CODE, 0, 1)
REG32(L3_TX_ANA_TM_9, 0xc024)
    FIELD(L3_TX_ANA_TM_9, TX_ANA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_9, MPHY_TX_HS_SLEWRATE, 0, 8)
REG32(L3_TX_ANA_TM_10, 0xc028)
    FIELD(L3_TX_ANA_TM_10, TX_ANA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_10, MPHY_HS_POWERUP_TIME, 4, 4)
    FIELD(L3_TX_ANA_TM_10, MPHY_TX_HS_EQUALIZER_SETTING, 1, 3)
    FIELD(L3_TX_ANA_TM_10, FORCE_MPHY_TX_HS_EQUALIZER_SETTING, 0, 1)
REG32(L3_TX_ANA_TM_13, 0xc034)
    FIELD(L3_TX_ANA_TM_13, TX_ANA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_13, ANA_BYP13_7_4_RSVD, 4, 4)
    FIELD(L3_TX_ANA_TM_13, TX_SWAP_POLARITY, 3, 1)
    FIELD(L3_TX_ANA_TM_13, FORCE_TX_SWAP_POLARITY, 2, 1)
    FIELD(L3_TX_ANA_TM_13, MPHY_TX_TRISTATE, 1, 1)
    FIELD(L3_TX_ANA_TM_13, FORCE_MPHY_TX_TRISTATE, 0, 1)
REG32(L3_TX_ANA_TM_14, 0xc038)
    FIELD(L3_TX_ANA_TM_14, TX_ANA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_14, ANA_BYP14_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_14, PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L3_TX_ANA_TM_14, FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L3_TX_ANA_TM_14, ANA_BYP14_3_0_RSVD, 0, 4)
REG32(L3_TX_ANA_TM_15, 0xc03c)
    FIELD(L3_TX_ANA_TM_15, TX_ANA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_15, PIPE_TX_SWING, 7, 1)
    FIELD(L3_TX_ANA_TM_15, FORCE_PIPE_TX_SWING, 6, 1)
    FIELD(L3_TX_ANA_TM_15, PIPE_TX_RXDET_DISCHARGE, 5, 1)
    FIELD(L3_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_DISCHARGE, 4, 1)
    FIELD(L3_TX_ANA_TM_15, PIPE_TX_RXDET_CHARGE, 3, 1)
    FIELD(L3_TX_ANA_TM_15, FORCE_PIPE_TX_RXDET_CHARGE, 2, 1)
    FIELD(L3_TX_ANA_TM_15, PIPE_TX_ENABLE_RXDET, 1, 1)
    FIELD(L3_TX_ANA_TM_15, FORCE_PIPE_TX_ENABLE_RXDET, 0, 1)
REG32(L3_TX_ANA_TM_16, 0xc040)
    FIELD(L3_TX_ANA_TM_16, TX_ANA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_16, ANA_BYP16_7_4_RSVD, 4, 4)
    FIELD(L3_TX_ANA_TM_16, PIPE_TX_MARGIN, 1, 3)
    FIELD(L3_TX_ANA_TM_16, FORCE_PIPE_TX_MARGIN, 0, 1)
REG32(L3_TX_ANA_TM_18, 0xc048)
    FIELD(L3_TX_ANA_TM_18, TX_ANA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_18, PIPE_TX_DEEMPH_7_0, 0, 8)
REG32(L3_TX_ANA_TM_19, 0xc04c)
    FIELD(L3_TX_ANA_TM_19, TX_ANA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_19, PIPE_TX_DEEMPH_15_8, 0, 8)
REG32(L3_TX_ANA_TM_20, 0xc050)
    FIELD(L3_TX_ANA_TM_20, TX_ANA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_20, ANA_BYP20_7_5_RSVD, 5, 3)
    FIELD(L3_TX_ANA_TM_20, TX_SERIALIZER_RST_REL, 4, 1)
    FIELD(L3_TX_ANA_TM_20, FORCE_TX_SERIALIZER_RST_REL, 3, 1)
    FIELD(L3_TX_ANA_TM_20, FORCE_MPHY_TX_HS_SLEWRATE, 2, 1)
    FIELD(L3_TX_ANA_TM_20, PIPE_TX_DEEMPH_17_16, 0, 2)
REG32(L3_TX_ANA_TM_21, 0xc054)
    FIELD(L3_TX_ANA_TM_21, TX_ANA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_21, ANA_BYP21_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_21, PIPE_TX_COEF_CALC_CLK, 5, 1)
    FIELD(L3_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_CLK, 4, 1)
    FIELD(L3_TX_ANA_TM_21, PIPE_TX_COEF_CALC_FSM_RESET_B, 3, 1)
    FIELD(L3_TX_ANA_TM_21, FORCE_PIPE_TX_COEF_CALC_FSM_RESET_B, 2, 1)
    FIELD(L3_TX_ANA_TM_21, PIPE_TX_DEEMPH_CTRL_SEL, 1, 1)
    FIELD(L3_TX_ANA_TM_21, FORCE_PIPE_TX_DEEMPH_CTRL_SEL, 0, 1)
REG32(L3_TX_DIG_TM_61, 0xc0f4)
    FIELD(L3_TX_DIG_TM_61, TX_DIG_TM_61_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_61, MPHY_PLL_GEAR, 6, 2)
    FIELD(L3_TX_DIG_TM_61, DIG_BYP1_5_4_RSVD, 4, 2)
    FIELD(L3_TX_DIG_TM_61, BYPASS_ENC, 3, 1)
    FIELD(L3_TX_DIG_TM_61, DIG_BYP1_2_RSVD, 2, 1)
    FIELD(L3_TX_DIG_TM_61, BYPASS_SCRAM, 1, 1)
    FIELD(L3_TX_DIG_TM_61, FORCE_BYPASS_SCRAM, 0, 1)
REG32(L3_TX_DIG_TM_62, 0xc0f8)
    FIELD(L3_TX_DIG_TM_62, TX_DIG_TM_62_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_62, G0_BIT_PER_CNT, 0, 8)
REG32(L3_TX_DIG_TM_65, 0xc104)
    FIELD(L3_TX_DIG_TM_65, TX_DIG_TM_65_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_65, FORCE_TX_RXDET_PROBE_THRESHOLD, 7, 1)
    FIELD(L3_TX_DIG_TM_65, FORCE_TX_RXDET_END_CH_THRESHOLD, 6, 1)
    FIELD(L3_TX_DIG_TM_65, FORCE_TX_RXDET_START_CH_THRESHOLD, 5, 1)
    FIELD(L3_TX_DIG_TM_65, FORCE_TX_RXDET_END_DCH_THRESHOLD, 4, 1)
    FIELD(L3_TX_DIG_TM_65, FORCE_TX_RXDET_START_DCH_THRESHOLD, 3, 1)
    FIELD(L3_TX_DIG_TM_65, TX_EN_FULL_CALIB, 2, 1)
    FIELD(L3_TX_DIG_TM_65, FORCE_TX_EN_FULL_CALIB, 1, 1)
    FIELD(L3_TX_DIG_TM_65, DIG_BYP5_0_RSVD, 0, 1)
REG32(L3_TX_DIG_TM_67, 0xc10c)
    FIELD(L3_TX_DIG_TM_67, TX_DIG_TM_67_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_67, TX_MPHY_SER_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_68, 0xc110)
    FIELD(L3_TX_DIG_TM_68, TX_DIG_TM_68_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_68, TX_SER_SUP_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_69, 0xc114)
    FIELD(L3_TX_DIG_TM_69, TX_DIG_TM_69_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_69, TX_MPHY_SUP_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_76, 0xc130)
    FIELD(L3_TX_DIG_TM_76, TX_DIG_TM_76_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_76, TX_RXDET_START_DCH_THRESHOLD_7_0, 0, 8)
REG32(L3_TX_DIG_TM_77, 0xc134)
    FIELD(L3_TX_DIG_TM_77, TX_DIG_TM_77_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_77, TX_RXDET_END_DCH_THRESHOLD_11_8, 4, 4)
    FIELD(L3_TX_DIG_TM_77, TX_RXDET_START_DCH_THRESHOLD_11_8, 0, 4)
REG32(L3_TX_DIG_TM_78, 0xc138)
    FIELD(L3_TX_DIG_TM_78, TX_DIG_TM_78_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_78, TX_RXDET_END_DCH_THRESHOLD_7_0, 0, 8)
REG32(L3_TX_DIG_TM_79, 0xc13c)
    FIELD(L3_TX_DIG_TM_79, TX_DIG_TM_79_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_79, TX_RXDET_START_CH_THRESHOLD_7_0, 0, 8)
REG32(L3_TX_DIG_TM_80, 0xc140)
    FIELD(L3_TX_DIG_TM_80, TX_DIG_TM_80_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_80, TX_RXDET_END_CH_THRESHOLD_11_8, 4, 4)
    FIELD(L3_TX_DIG_TM_80, TX_RXDET_START_CH_THRESHOLD_11_8, 0, 4)
REG32(L3_TX_DIG_TM_81, 0xc144)
    FIELD(L3_TX_DIG_TM_81, TX_DIG_TM_81_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_81, TX_RXDET_END_CH_THRESHOLD_7_0, 0, 8)
REG32(L3_TX_DIG_TM_82, 0xc148)
    FIELD(L3_TX_DIG_TM_82, TX_DIG_TM_82_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_82, TX_RXDET_PROBE_THRESHOLD_7_0, 0, 8)
REG32(L3_TX_DIG_TM_83, 0xc14c)
    FIELD(L3_TX_DIG_TM_83, TX_DIG_TM_83_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_83, DIG_BYP23_7_4_RSVD, 4, 4)
    FIELD(L3_TX_DIG_TM_83, TX_RXDET_PROBE_THRESHOLD_11_8, 0, 4)
REG32(L3_TX_DIG_TM_84, 0xc150)
    FIELD(L3_TX_DIG_TM_84, TX_DIG_TM_84_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_84, TX_DIF_P, 7, 1)
    FIELD(L3_TX_DIG_TM_84, TX_DITHER_1P, 6, 1)
    FIELD(L3_TX_DIG_TM_84, TX_DITHER_1N, 5, 1)
    FIELD(L3_TX_DIG_TM_84, TX_DITHER_EN, 4, 1)
    FIELD(L3_TX_DIG_TM_84, DIG_BYP24_3_RSVD, 3, 1)
    FIELD(L3_TX_DIG_TM_84, TX_PHYDIRDY_SOC_MODE, 2, 1)
    FIELD(L3_TX_DIG_TM_84, DIG_BYP24_1_RSVD, 1, 1)
    FIELD(L3_TX_DIG_TM_84, TX_READ_SHADOW, 0, 1)
REG32(L3_TX_ANA_TM_85, 0xc154)
    FIELD(L3_TX_ANA_TM_85, TX_ANA_TM_85_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_85, DIG_BYP25_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_85, TX_HIBERN8_CTRL, 5, 1)
    FIELD(L3_TX_ANA_TM_85, TX_ALLOW_INLNCFG_FROM_TOP, 4, 1)
    FIELD(L3_TX_ANA_TM_85, DIG_BYP25_3_RSVD, 3, 1)
    FIELD(L3_TX_ANA_TM_85, TX_SEND_MSB_FIRST, 2, 1)
    FIELD(L3_TX_ANA_TM_85, DIG_BYP25_1_RSVD, 1, 1)
    FIELD(L3_TX_ANA_TM_85, TX_DIF_N, 0, 1)
REG32(L3_TX_ANA_TM_87, 0xc15c)
    FIELD(L3_TX_ANA_TM_87, TX_ANA_TM_87_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_87, DIG_BYP27_7_4_RSVD, 4, 4)
    FIELD(L3_TX_ANA_TM_87, TX_SM_STATUS, 0, 4)
REG32(L3_TX_ANA_TM_88, 0xc160)
    FIELD(L3_TX_ANA_TM_88, TX_ANA_TM_88_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_88, TX_COMP_PAT_HIGH_TIME_REGS, 0, 8)
REG32(L3_TX_ANA_TM_89, 0xc164)
    FIELD(L3_TX_ANA_TM_89, TX_ANA_TM_89_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_89, DIG_BYP29_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_89, TX_DATAPATH_CTRL_1_REGS, 5, 1)
    FIELD(L3_TX_ANA_TM_89, DIG_BYP29_4_3_RSVD, 3, 2)
    FIELD(L3_TX_ANA_TM_89, INITIAL_DISPARITY, 2, 1)
    FIELD(L3_TX_ANA_TM_89, SCRAMBLER_ENABLE, 1, 1)
    FIELD(L3_TX_ANA_TM_89, DIG_BYP29_0_RSVD, 0, 1)
REG32(L3_TX_ANA_TM_90, 0xc168)
    FIELD(L3_TX_ANA_TM_90, TX_ANA_TM_90_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_90, DIG_BYP30_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_90, TX_BYPASS_BCNT_LPBACK_REGS, 5, 1)
    FIELD(L3_TX_ANA_TM_90, DIG_BYP30_4_0_RSVD, 0, 5)
REG32(L3_TX_DIG_TM_91, 0xc16c)
    FIELD(L3_TX_DIG_TM_91, TX_DIG_TM_91_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_91, TX_CFGCLK_FREQ, 0, 8)
REG32(L3_TX_DIG_TM_92, 0xc170)
    FIELD(L3_TX_DIG_TM_92, TX_DIG_TM_92_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_92, TX_PHYDIRDY_PULL_UP_LATENCY, 0, 8)
REG32(L3_TX_ANA_TM_95, 0xc17c)
    FIELD(L3_TX_ANA_TM_95, TX_ANA_TM_95_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_95, ANA_BYP63_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_95, TX_TM_EN_PROG_SYNC_PATTERN, 5, 1)
    FIELD(L3_TX_ANA_TM_95, TX_EXTRA_HS_BURST_IN_LCC, 2, 3)
    FIELD(L3_TX_ANA_TM_95, ANA_BYP22_1_0_RSVD, 0, 2)
REG32(L3_TX_ANA_TM_96, 0xc180)
    FIELD(L3_TX_ANA_TM_96, TX_ANA_TM_96_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_96, TX_TM_PROG_SYNC_PATTERN1, 0, 8)
REG32(L3_TX_ANA_TM_97, 0xc184)
    FIELD(L3_TX_ANA_TM_97, TX_ANA_TM_97_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_97, TX_TM_PROG_SYNC_PATTERN2, 0, 8)
REG32(L3_TX_DIG_TM_98, 0xc188)
    FIELD(L3_TX_DIG_TM_98, TX_DIG_TM_98_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_98, DIG_BYP33_7_6_RSVD, 6, 2)
    FIELD(L3_TX_DIG_TM_98, FORCE_RD_VALUE, 5, 1)
    FIELD(L3_TX_DIG_TM_98, FORCE_RD, 4, 1)
    FIELD(L3_TX_DIG_TM_98, TX_SER_ISO_CTRL_BAR, 3, 1)
    FIELD(L3_TX_DIG_TM_98, FORCE_TX_SER_ISO_CTRL_BAR, 2, 1)
    FIELD(L3_TX_DIG_TM_98, TX_ISO_CTRL_BAR, 1, 1)
    FIELD(L3_TX_DIG_TM_98, FORCE_TX_ISO_CTRL_BAR, 0, 1)
REG32(L3_TX_DIG_TM_99, 0xc18c)
    FIELD(L3_TX_DIG_TM_99, TX_DIG_TM_99_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_99, TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_100, 0xc190)
    FIELD(L3_TX_DIG_TM_100, TX_DIG_TM_100_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_100, TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_101, 0xc194)
    FIELD(L3_TX_DIG_TM_101, TX_DIG_TM_101_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_101, TX_SERIALISER_ENABLE_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_102, 0xc198)
    FIELD(L3_TX_DIG_TM_102, TX_DIG_TM_102_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_102, FORCE_TX_ANA_LL_EN, 7, 1)
    FIELD(L3_TX_DIG_TM_102, TX_ANA_LL_EN, 6, 1)
    FIELD(L3_TX_DIG_TM_102, FORCE_DELAY_CNT_THRESHOLD, 5, 1)
    FIELD(L3_TX_DIG_TM_102, FORCE_TX_MPHY_TRST_THRESHOLD, 4, 1)
    FIELD(L3_TX_DIG_TM_102, FORCE_TX_LDO_THRESHOLD, 3, 1)
    FIELD(L3_TX_DIG_TM_102, FORCE_TX_SERIALISER_ENABLE_THRESHOLD, 2, 1)
    FIELD(L3_TX_DIG_TM_102, FORCE_TX_SERIALISER_SUPPLY_ENABLE_THRESHOLD, 1, 1)
    FIELD(L3_TX_DIG_TM_102, FORCE_TX_PIPE_SUPPLY_ENABLE_THRESHOLD, 0, 1)
REG32(L3_TX_DIG_TM_103, 0xc19c)
    FIELD(L3_TX_DIG_TM_103, TX_DIG_TM_103_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_103, FORCE_BG_EN, 7, 1)
    FIELD(L3_TX_DIG_TM_103, FORCE_CALIB_EN, 6, 1)
    FIELD(L3_TX_DIG_TM_103, FORCE_PLL_EN, 5, 1)
    FIELD(L3_TX_DIG_TM_103, FORCE_PSO, 4, 1)
    FIELD(L3_TX_DIG_TM_103, BG_EN, 3, 1)
    FIELD(L3_TX_DIG_TM_103, CALIB_EN, 2, 1)
    FIELD(L3_TX_DIG_TM_103, PLL_EN, 1, 1)
    FIELD(L3_TX_DIG_TM_103, PSO, 0, 1)
REG32(L3_TX_DIG_TM_104, 0xc1a0)
    FIELD(L3_TX_DIG_TM_104, TX_DIG_TM_104_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_104, TX_LDO_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_105, 0xc1a4)
    FIELD(L3_TX_DIG_TM_105, TX_DIG_TM_105_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_105, TX_MPHY_TRST_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_106, 0xc1a8)
    FIELD(L3_TX_DIG_TM_106, TX_DIG_TM_106_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_106, DELAY_CNT_THRESHOLD, 0, 8)
REG32(L3_TX_DIG_TM_107, 0xc1ac)
    FIELD(L3_TX_DIG_TM_107, TX_DIG_TM_107_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_107, DIG_BYP42_7_RSVD, 7, 1)
    FIELD(L3_TX_DIG_TM_107, FORCE_P3TOP0_PHYSTATUS_PULSE, 6, 1)
    FIELD(L3_TX_DIG_TM_107, ENABLE_HS_CLK_DIVISION, 5, 1)
    FIELD(L3_TX_DIG_TM_107, TESTDIGOUT_SEL, 1, 4)
    FIELD(L3_TX_DIG_TM_107, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L3_TX_DIG_TM_108, 0xc1b0)
    FIELD(L3_TX_DIG_TM_108, TX_DIG_TM_108_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_108, ANA_BYP43_7_RSVD, 7, 1)
    FIELD(L3_TX_DIG_TM_108, TX_EXT_DATA_DELAY, 3, 4)
    FIELD(L3_TX_DIG_TM_108, FORCE_TX_EXT_DATA_DELAY, 2, 1)
    FIELD(L3_TX_DIG_TM_108, FORCE_TX_DATA_DELAY, 1, 1)
    FIELD(L3_TX_DIG_TM_108, FORCE_UPHY_TXPMA_OPMODE, 0, 1)
REG32(L3_TX_DIG_TM_109, 0xc1b4)
    FIELD(L3_TX_DIG_TM_109, TX_DIG_TM_109_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_109, UPHY_TXPMA_OPMODE, 0, 8)
REG32(L3_TX_DIG_TM_110, 0xc1b8)
    FIELD(L3_TX_DIG_TM_110, TX_DIG_TM_110_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_110, TX_DATA_DELAY, 0, 8)
REG32(L3_TX_DIG_TM_111, 0xc1bc)
    FIELD(L3_TX_DIG_TM_111, TX_DIG_TM_111_31_8_RSVD, 24, 8)
    FIELD(L3_TX_DIG_TM_111, TX_DA_SPARE, 0, 8)
REG32(L3_TX_ANA_TM_112, 0xc1c0)
    FIELD(L3_TX_ANA_TM_112, TX_ANA_TM_112_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_112, ANA_BYP25_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_112, PIPE_TX_ENABLE_LFPS, 4, 2)
    FIELD(L3_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L3_TX_ANA_TM_112, PIPE_TX_ENABLE_IDLE_MODE, 1, 2)
    FIELD(L3_TX_ANA_TM_112, FORCE_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L3_TX_ANA_TM_113, 0xc1c4)
    FIELD(L3_TX_ANA_TM_113, TX_ANA_TM_113_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_113, MPHY_TX_DRIVERLDO_PROG, 0, 8)
REG32(L3_TX_ANA_TM_114, 0xc1c8)
    FIELD(L3_TX_ANA_TM_114, TX_ANA_TM_114_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_114, ANA_BYP27_7_5_RSVD, 5, 3)
    FIELD(L3_TX_ANA_TM_114, FORCE_MPHY_TX_DRIVERLDO_PROG, 4, 1)
    FIELD(L3_TX_ANA_TM_114, MPHY_TX_DRIVERLDO_PROG, 0, 4)
REG32(L3_TX_ANA_TM_115, 0xc1cc)
    FIELD(L3_TX_ANA_TM_115, TX_ANA_TM_115_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_115, ANA_BYP28_7_RSVD, 7, 1)
    FIELD(L3_TX_ANA_TM_115, PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 6, 1)
    FIELD(L3_TX_ANA_TM_115, FORCE_PIPE_TX_GETLOCALPRESETCOEFFICIENTS, 5, 1)
    FIELD(L3_TX_ANA_TM_115, TX_PMADIG_DIGITAL_RESET_N, 4, 1)
    FIELD(L3_TX_ANA_TM_115, FORCE_TX_PMADIG_DIGITAL_RESET_N, 3, 1)
    FIELD(L3_TX_ANA_TM_115, TX_ANA_IF_RATE, 1, 2)
    FIELD(L3_TX_ANA_TM_115, FORCE_TX_ANA_IF_RATE, 0, 1)
REG32(L3_TX_ANA_TM_116, 0xc1d0)
    FIELD(L3_TX_ANA_TM_116, TX_ANA_TM_116_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_116, ANA_BYP29_7_RSVD, 7, 1)
    FIELD(L3_TX_ANA_TM_116, PIPE_TX_LOCALPRESETINDEX, 3, 4)
    FIELD(L3_TX_ANA_TM_116, FORCE_PIPE_TX_LOCALPRESETINDEX, 2, 1)
    FIELD(L3_TX_ANA_TM_116, MPHY_TX_EN_LANE_LS_CLK, 1, 1)
    FIELD(L3_TX_ANA_TM_116, FORCE_MPHY_TX_EN_LANE_LS_CLK, 0, 1)
REG32(L3_TX_ANA_TM_117, 0xc1d4)
    FIELD(L3_TX_ANA_TM_117, TX_ANA_TM_117_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_117, MULTILANE_BYP1_7_6_RSVD, 6, 2)
    FIELD(L3_TX_ANA_TM_117, TX_PCIE_4X_CFG_EN, 5, 1)
    FIELD(L3_TX_ANA_TM_117, FORCE_TX_PCIE_4X_CFG_EN, 4, 1)
    FIELD(L3_TX_ANA_TM_117, TX_PCIE_2X_CFG_EN, 3, 1)
    FIELD(L3_TX_ANA_TM_117, FORCE_TX_PCIE_2X_CFG_EN, 2, 1)
    FIELD(L3_TX_ANA_TM_117, TX_DP_MULTILANE_CFG_EN, 1, 1)
    FIELD(L3_TX_ANA_TM_117, FORCE_TX_DP_MULTILANE_CFG_EN, 0, 1)
REG32(L3_TX_ANA_TM_118, 0xc1d8)
    FIELD(L3_TX_ANA_TM_118, TX_ANA_TM_118_31_8_RSVD, 24, 8)
    FIELD(L3_TX_ANA_TM_118, ANA_BYP30_7_4_RSVD, 4, 4)
    FIELD(L3_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_12, 3, 1)
    FIELD(L3_TX_ANA_TM_118, FORCE_TX_DEEMPH_11_6, 2, 1)
    FIELD(L3_TX_ANA_TM_118, FORCE_TX_DEEMPH_5_0, 1, 1)
    FIELD(L3_TX_ANA_TM_118, FORCE_TX_DEEMPH_17_0, 0, 1)
REG32(L3_TXPMA_TM_0, 0xc800)
    FIELD(L3_TXPMA_TM_0, TXPMA_TM_0_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_0, TM_TX_ENABLE_SUPPLY_MPHY, 7, 1)
    FIELD(L3_TXPMA_TM_0, TM_FORCE_TX_ENABLE_SUPPLY_MPHY, 6, 1)
    FIELD(L3_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 5, 1)
    FIELD(L3_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SUPPLY_LS_CLOCK, 4, 1)
    FIELD(L3_TXPMA_TM_0, TM_MPHY_TX_ENABLE_SA_MODE, 3, 1)
    FIELD(L3_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_SA_MODE, 2, 1)
    FIELD(L3_TXPMA_TM_0, TM_MPHY_TX_ENABLE_HS_NT, 1, 1)
    FIELD(L3_TXPMA_TM_0, TM_FORCE_MPHY_TX_ENABLE_HS_NT, 0, 1)
REG32(L3_TXPMA_TM_1, 0xc804)
    FIELD(L3_TXPMA_TM_1, TXPMA_TM_1_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_1, ANA_MPHY_BYP1_7_4_RSVD, 4, 4)
    FIELD(L3_TXPMA_TM_1, TM_MPHY_TX_HS_DITHER_VAL, 1, 3)
    FIELD(L3_TXPMA_TM_1, TM_FORCE_MPHY_TX_HS_DITHER_VAL, 0, 1)
REG32(L3_TXPMA_TM_2, 0xc808)
    FIELD(L3_TXPMA_TM_2, TXPMA_TM_2_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_2, TM_MPHY_TX_DRIVERLDO_PROG_6_0, 1, 7)
    FIELD(L3_TXPMA_TM_2, TM_FORCE_MPHY_TX_DRIVERLDO_PROG, 0, 1)
REG32(L3_TXPMA_TM_3, 0xc80c)
    FIELD(L3_TXPMA_TM_3, TXPMA_TM_3_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_3, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMA_TM_3, TM_MPHY_TX_DRIVERLDO_PROG_11_7, 0, 5)
REG32(L3_TXPMA_TM_4, 0xc810)
    FIELD(L3_TXPMA_TM_4, TXPMA_TM_4_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_4, TM_PIPE_TX_TX_DATA_WIDTH, 5, 3)
    FIELD(L3_TXPMA_TM_4, TM_FORCE_PIPE_TX_TX_DATA_WIDTH, 4, 1)
    FIELD(L3_TXPMA_TM_4, TM_PIPE_TX_POWERDOWN_VCM_HOLD, 3, 1)
    FIELD(L3_TXPMA_TM_4, TM_FORCE_PIPE_TX_POWERDOWN_VCM_HOLD, 2, 1)
    FIELD(L3_TXPMA_TM_4, TM_PIPE_TX_ANABOOST_POWERDOWN, 1, 1)
    FIELD(L3_TXPMA_TM_4, ANA_PIPE_BYP0_0_RSVD, 0, 1)
REG32(L3_TXPMA_TM_5, 0xc814)
    FIELD(L3_TXPMA_TM_5, TXPMA_TM_5_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_5, ANA_BSCAN_BYP0_7_4_RSVD, 4, 4)
    FIELD(L3_TXPMA_TM_5, TM_TX_BSCAN_SEL, 3, 1)
    FIELD(L3_TXPMA_TM_5, TM_FORCE_TX_BSCAN_SEL, 2, 1)
    FIELD(L3_TXPMA_TM_5, TM_TX_BSCAN_DATA, 1, 1)
    FIELD(L3_TXPMA_TM_5, TM_FORCE_TX_BSCAN_DATA, 0, 1)
REG32(L3_TXPMA_TM_6, 0xc818)
    FIELD(L3_TXPMA_TM_6, TXPMA_TM_6_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_6, TM_TX_ENABLE_ISI_LPBK, 7, 1)
    FIELD(L3_TXPMA_TM_6, TM_FORCE_TX_ENABLE_ISI_LPBK, 6, 1)
    FIELD(L3_TXPMA_TM_6, TM_TX_ENABLE_SER_LPBK, 5, 1)
    FIELD(L3_TXPMA_TM_6, TM_FORCE_TX_ENABLE_SER_LPBK, 4, 1)
    FIELD(L3_TXPMA_TM_6, TM_TX_ENABLE_RX_LIN_LPBK, 3, 1)
    FIELD(L3_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RX_LIN_LPBK, 2, 1)
    FIELD(L3_TXPMA_TM_6, TM_TX_ENABLE_RCRVD_DATA_LPBK, 1, 1)
    FIELD(L3_TXPMA_TM_6, TM_FORCE_TX_ENABLE_RCRVD_DATA_LPBK, 0, 1)
REG32(L3_TXPMA_TM_7, 0xc81c)
    FIELD(L3_TXPMA_TM_7, TXPMA_TM_7_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_UPHY, 7, 1)
    FIELD(L3_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_UPHY, 6, 1)
    FIELD(L3_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_SERIALIZER, 5, 1)
    FIELD(L3_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L3_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_PIPE, 3, 1)
    FIELD(L3_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_PIPE, 2, 1)
    FIELD(L3_TXPMA_TM_7, TM_TX_ENABLE_SUPPLY_HSCLK, 1, 1)
    FIELD(L3_TXPMA_TM_7, TM_FORCE_TX_ENABLE_SUPPLY_HSCLK, 0, 1)
REG32(L3_TXPMA_TM_8, 0xc820)
    FIELD(L3_TXPMA_TM_8, TXPMA_TM_8_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_8, ANA_LS_LFPS_BYP0_7_2_RSVD, 2, 6)
    FIELD(L3_TXPMA_TM_8, TM_TX_LS_LFPS_DATA, 1, 1)
    FIELD(L3_TXPMA_TM_8, TM_FORCE_TX_LS_LFPS_DATA, 0, 1)
REG32(L3_TXPMA_TM_9, 0xc824)
    FIELD(L3_TXPMA_TM_9, TXPMA_TM_9_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_9, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L3_TXPMA_TM_9, TM_TX_SERIALIZER_MODE, 6, 1)
    FIELD(L3_TXPMA_TM_9, TM_FORCE_TX_SERIALIZER_MODE, 5, 1)
    FIELD(L3_TXPMA_TM_9, TM_TX_ENABLE_HSCLK_DIVISION, 3, 2)
    FIELD(L3_TXPMA_TM_9, TM_FORCE_TX_ENABLE_HSCLK_DIVISION, 2, 1)
    FIELD(L3_TXPMA_TM_9, TM_TX_DRIVER_POLARITY, 1, 1)
    FIELD(L3_TXPMA_TM_9, TM_FORCE_TX_DRIVER_POLARITY, 0, 1)
REG32(L3_TXPMA_TM_10, 0xc828)
    FIELD(L3_TXPMA_TM_10, TXPMA_TM_10_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_10, ANA_MISC1_7_6_RSVD, 6, 2)
    FIELD(L3_TXPMA_TM_10, TM_TX_ENABLE_LOWLEAKAGE, 5, 1)
    FIELD(L3_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LOWLEAKAGE, 4, 1)
    FIELD(L3_TXPMA_TM_10, TM_TX_ENABLE_REF, 3, 1)
    FIELD(L3_TXPMA_TM_10, TM_FORCE_TX_ENABLE_REF, 2, 1)
    FIELD(L3_TXPMA_TM_10, TM_TX_ENABLE_LDO, 1, 1)
    FIELD(L3_TXPMA_TM_10, TM_FORCE_TX_ENABLE_LDO, 0, 1)
REG32(L3_TXPMA_TM_11, 0xc82c)
    FIELD(L3_TXPMA_TM_11, TXPMA_TM_11_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_11, ANA_VCM_BYP0_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMA_TM_11, TM_TX_VCMHOLD_PROG, 1, 4)
    FIELD(L3_TXPMA_TM_11, TM_TX_VCMHOLD_OBSRV, 0, 1)
REG32(L3_TXPMA_TM_12, 0xc830)
    FIELD(L3_TXPMA_TM_12, TXPMA_TM_12_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_12, TM_TX_SER_POWERISLAND_OBSRV, 5, 3)
    FIELD(L3_TXPMA_TM_12, TM_TX_CLK_POWERISLAND_OBSRV, 1, 4)
    FIELD(L3_TXPMA_TM_12, ANA_PWR_ISLAND_BYP0_0_RSVD, 0, 1)
REG32(L3_TXPMA_TM_13, 0xc834)
    FIELD(L3_TXPMA_TM_13, TXPMA_TM_13_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_13, TM_TX_POWERISLAND_OBSRV, 0, 8)
REG32(L3_TXPMA_TM_14, 0xc838)
    FIELD(L3_TXPMA_TM_14, TXPMA_TM_14_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_14, ANA_MISC2_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMA_TM_14, TM_TX_POWERISLAND_OBSRV, 3, 2)
    FIELD(L3_TXPMA_TM_14, PIPE_TM_TX_ANABOOST_POWER_OBSRV, 2, 1)
    FIELD(L3_TXPMA_TM_14, MPHY_TM_TX_ENABLE_DRIVERLDO_OBSRV, 1, 1)
    FIELD(L3_TXPMA_TM_14, MPHY_TM_TX_DRIVERLDO_REDC_SINKIQ, 0, 1)
REG32(L3_TXPMA_TM_15, 0xc83c)
    FIELD(L3_TXPMA_TM_15, TXPMA_TM_15_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_15, PIPE_TM_TX_ANABOOST_PROG_7_0, 0, 8)
REG32(L3_TXPMA_TM_16, 0xc840)
    FIELD(L3_TXPMA_TM_16, TXPMA_TM_16_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_16, PIPE_TM_TX_ANABOOST_PROG_15_8, 0, 8)
REG32(L3_TXPMA_TM_17, 0xc844)
    FIELD(L3_TXPMA_TM_17, TXPMA_TM_17_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_17, TM_TX_RSVD2, 0, 8)
REG32(L3_TXPMA_TM_18, 0xc848)
    FIELD(L3_TXPMA_TM_18, TXPMA_TM_18_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_18, TM_TX_ENABLE_VDDREF_CORE, 7, 1)
    FIELD(L3_TXPMA_TM_18, TM_FORCE_TX_ENABLE_VDDREF_CORE, 6, 1)
    FIELD(L3_TXPMA_TM_18, TM_TX_ENABLE_RBYRFB_CORE, 5, 1)
    FIELD(L3_TXPMA_TM_18, TM_FORCE_TX_ENABLE_RBYRFB_CORE, 4, 1)
    FIELD(L3_TXPMA_TM_18, TM_TX_ENABLE_BGREF_CORE, 3, 1)
    FIELD(L3_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGREF_CORE, 2, 1)
    FIELD(L3_TXPMA_TM_18, TM_TX_ENABLE_BGFB_CORE, 1, 1)
    FIELD(L3_TXPMA_TM_18, TM_FORCE_TX_ENABLE_BGFB_CORE, 0, 1)
REG32(L3_TXPMA_TM_19, 0xc84c)
    FIELD(L3_TXPMA_TM_19, TXPMA_TM_19_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_19, ANA_SATA_BYP0_RSVD, 6, 2)
    FIELD(L3_TXPMA_TM_19, TM_ZDIF_TX_SATA_OFFSET, 0, 6)
REG32(L3_TXPMA_TM_20, 0xc850)
    FIELD(L3_TXPMA_TM_20, TXPMA_TM_20_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_20, TM_TX_ELEC_IDLE_DELAY_ENTRY, 0, 8)
REG32(L3_TXPMA_TM_21, 0xc854)
    FIELD(L3_TXPMA_TM_21, TXPMA_TM_21_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_21, TM_TX_ELEC_IDLE_DELAY_EXIT, 0, 8)
REG32(L3_TXPMA_TM_22, 0xc858)
    FIELD(L3_TXPMA_TM_22, TXPMA_TM_22_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_22, TM_TX_ENABLE_LFPS_DELAY_ENTRY, 0, 8)
REG32(L3_TXPMA_TM_23, 0xc85c)
    FIELD(L3_TXPMA_TM_23, TXPMA_TM_23_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_23, TM_TX_ENABLE_LFPS_DELAY_EXIT, 0, 8)
REG32(L3_TXPMA_TM_24, 0xc860)
    FIELD(L3_TXPMA_TM_24, TXPMA_TM_24_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_24, ANA_MISC6_7_RSVD, 7, 1)
    FIELD(L3_TXPMA_TM_24, TM_TX_EN_ANA_SUBLP_MODE, 6, 1)
    FIELD(L3_TXPMA_TM_24, TM_FORCE_TX_EN_ANA_SUBLP_MODE, 5, 1)
    FIELD(L3_TXPMA_TM_24, TM_TX_EN_DIG_SUBLP_MODE, 4, 1)
    FIELD(L3_TXPMA_TM_24, TM_FORCE_TX_EN_DIG_SUBLP_MODE, 3, 1)
    FIELD(L3_TXPMA_TM_24, TM_TX_DP_LVLDB0_OVRRD, 2, 1)
    FIELD(L3_TXPMA_TM_24, TM_FORCE_TX_DP_LVLDB0_OVRRD, 1, 1)
    FIELD(L3_TXPMA_TM_24, TM_TX_CLOCK_STOP_REQ, 0, 1)
REG32(L3_TXPMA_TM_25, 0xc864)
    FIELD(L3_TXPMA_TM_25, TXPMA_TM_25_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_25, ANA_MISC6_7_6_RSVD, 6, 2)
    FIELD(L3_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_PLL, 5, 1)
    FIELD(L3_TXPMA_TM_25, TM_TX_WRRD_SYNC_SUP_OBSRV_RX, 4, 1)
    FIELD(L3_TXPMA_TM_25, TM_TX_LANE_LNG, 3, 1)
    FIELD(L3_TXPMA_TM_25, TM_FORCE_TX_LANE_LNG, 2, 1)
    FIELD(L3_TXPMA_TM_25, TM_TX_LANE_MASTER, 1, 1)
    FIELD(L3_TXPMA_TM_25, TM_FORCE_TX_LANE_MASTER, 0, 1)
REG32(L3_TXPMA_TM_26, 0xc868)
    FIELD(L3_TXPMA_TM_26, TXPMA_TM_26_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_26, TM_TXPMD_APB_RESET_DELAY, 0, 8)
REG32(L3_TXPMA_TM_27, 0xc86c)
    FIELD(L3_TXPMA_TM_27, TXPMA_TM_27_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_TM_27, TM_BSCAN_MODE_EN, 7, 1)
    FIELD(L3_TXPMA_TM_27, TM_FORCE_BSCAN_MODE_EN, 6, 1)
    FIELD(L3_TXPMA_TM_27, TM_PIPE_TX_FAST_EST_COMMON_MODE, 5, 1)
    FIELD(L3_TXPMA_TM_27, TM_FORCE_PIPE_TX_FAST_EST_COMMON_MODE, 4, 1)
    FIELD(L3_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_LFPS, 3, 1)
    FIELD(L3_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_LFPS, 2, 1)
    FIELD(L3_TXPMA_TM_27, TM_TX_PIPE_TX_ENABLE_IDLE_MODE, 1, 1)
    FIELD(L3_TXPMA_TM_27, TM_FORCE_TX_PIPE_TX_ENABLE_IDLE_MODE, 0, 1)
REG32(L3_TXPMA_ST_0, 0xcb00)
    FIELD(L3_TXPMA_ST_0, TXPMA_ST_0_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_0, TX_PHY_MODE, 4, 4)
    FIELD(L3_TXPMA_ST_0, TX_PHY_GEAR, 0, 4)
REG32(L3_TXPMA_ST_1, 0xcb04)
    FIELD(L3_TXPMA_ST_1, TXPMA_ST_1_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_1, TX_ENABLE_HSCLK_DIVISION, 6, 2)
    FIELD(L3_TXPMA_ST_1, PIPE_TX_TRISTATE, 5, 1)
    FIELD(L3_TXPMA_ST_1, TX_ENABLE_SUPPLY_SERIALIZER, 4, 1)
    FIELD(L3_TXPMA_ST_1, TX_ENABLE_SUPPLY_HSCLK, 3, 1)
    FIELD(L3_TXPMA_ST_1, TX_ENABLE_SUPPLY_MPHY, 2, 1)
    FIELD(L3_TXPMA_ST_1, TX_ENABLE_SUPPLY_PIPE, 1, 1)
    FIELD(L3_TXPMA_ST_1, TX_ENABLE_SUPPLY_UPHY, 0, 1)
REG32(L3_TXPMA_ST_2, 0xcb08)
    FIELD(L3_TXPMA_ST_2, TXPMA_ST_2_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_2, ANA_ST2_7_5_SPARE, 5, 3)
    FIELD(L3_TXPMA_ST_2, PIPE_TX_ENABLE_RXDET, 4, 1)
    FIELD(L3_TXPMA_ST_2, PIPE_TX_ENABLE_IDLE_MODE, 2, 2)
    FIELD(L3_TXPMA_ST_2, PIPE_TX_ENABLE_LFPS, 0, 2)
REG32(L3_TXPMA_ST_3, 0xcb0c)
    FIELD(L3_TXPMA_ST_3, TXPMA_ST_3_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_3, ANA_ST3_7_6_SPARE, 6, 2)
    FIELD(L3_TXPMA_ST_3, TX_LSEG_DN_RESCAL_CODE, 0, 6)
REG32(L3_TXPMA_ST_4, 0xcb10)
    FIELD(L3_TXPMA_ST_4, TXPMA_ST_4_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_4, ANA_ST4_7_6_SPARE, 6, 2)
    FIELD(L3_TXPMA_ST_4, TX_USEG_DP_RESCAL_CODE, 0, 6)
REG32(L3_TXPMA_ST_5, 0xcb14)
    FIELD(L3_TXPMA_ST_5, TXPMA_ST_5_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_5, ANA_ST5_7_6_SPARE, 6, 2)
    FIELD(L3_TXPMA_ST_5, PIPE_TX_LOCALFS, 0, 6)
REG32(L3_TXPMA_ST_6, 0xcb18)
    FIELD(L3_TXPMA_ST_6, TXPMA_ST_6_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_6, ANA_ST6_7_SPARE, 7, 1)
    FIELD(L3_TXPMA_ST_6, PIPE_TX_LOCALTXCOEFFICIENTSVALID, 6, 1)
    FIELD(L3_TXPMA_ST_6, PIPE_TX_LOCALLF, 0, 6)
REG32(L3_TXPMA_ST_7, 0xcb1c)
    FIELD(L3_TXPMA_ST_7, TXPMA_ST_7_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_7, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_7_0, 0, 8)
REG32(L3_TXPMA_ST_8, 0xcb20)
    FIELD(L3_TXPMA_ST_8, TXPMA_ST_8_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_8, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_15_8, 0, 8)
REG32(L3_TXPMA_ST_9, 0xcb24)
    FIELD(L3_TXPMA_ST_9, TXPMA_ST_9_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMA_ST_9, ANA_ST9_7_2_SPARE, 2, 6)
    FIELD(L3_TXPMA_ST_9, PIPE_TX_LOCALTXPRESETCOEFFICIENTS_17_16, 0, 2)
REG32(L3_TXPMD_TM_0, 0xcc00)
    FIELD(L3_TXPMD_TM_0, TXPMD_TM_0_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_0, PIPE_TM_TX_USEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_1, 0xcc04)
    FIELD(L3_TXPMD_TM_1, TXPMD_TM_1_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_1, PIPE_TM_TX_USEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_2, 0xcc08)
    FIELD(L3_TXPMD_TM_2, TXPMD_TM_2_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_2, PIPE_TM_TX_USEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_3, 0xcc0c)
    FIELD(L3_TXPMD_TM_3, TXPMD_TM_3_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_3, PIPE_TM_TX_USEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_4, 0xcc10)
    FIELD(L3_TXPMD_TM_4, TXPMD_TM_4_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_4, PIPE_TM_TX_USEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_5, 0xcc14)
    FIELD(L3_TXPMD_TM_5, TXPMD_TM_5_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_5, PIPE_TM_TX_USEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_6, 0xcc18)
    FIELD(L3_TXPMD_TM_6, TXPMD_TM_6_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_6, PIPE_TM_TX_USEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_7, 0xcc1c)
    FIELD(L3_TXPMD_TM_7, TXPMD_TM_7_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_7, PIPE_TM_TX_USEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_8, 0xcc20)
    FIELD(L3_TXPMD_TM_8, TXPMD_TM_8_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_8, PIPE_TM_TX_USEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_9, 0xcc24)
    FIELD(L3_TXPMD_TM_9, TXPMD_TM_9_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_9, PIPE_TM_TX_USEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_10, 0xcc28)
    FIELD(L3_TXPMD_TM_10, TXPMD_TM_10_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_10, PIPE_TM_TX_USEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_11, 0xcc2c)
    FIELD(L3_TXPMD_TM_11, TXPMD_TM_11_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_11, PIPE_TM_TX_USEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_12, 0xcc30)
    FIELD(L3_TXPMD_TM_12, TXPMD_TM_12_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_12, PIPE_TM_TX_USEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_13, 0xcc34)
    FIELD(L3_TXPMD_TM_13, TXPMD_TM_13_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_13, PIPE_TM_TX_USEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_14, 0xcc38)
    FIELD(L3_TXPMD_TM_14, TXPMD_TM_14_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_14, PIPE_TM_TX_USEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_15, 0xcc3c)
    FIELD(L3_TXPMD_TM_15, TXPMD_TM_15_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_15, PIPE_TM_TX_USEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_16, 0xcc40)
    FIELD(L3_TXPMD_TM_16, TXPMD_TM_16_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_16, PIPE_TM_TX_LSEG_POST_DISABLE_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_17, 0xcc44)
    FIELD(L3_TXPMD_TM_17, TXPMD_TM_17_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_17, PIPE_TM_TX_LSEG_POST_DISABLE_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_18, 0xcc48)
    FIELD(L3_TXPMD_TM_18, TXPMD_TM_18_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_18, PIPE_TM_TX_LSEG_POST_EMPHASIS_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_19, 0xcc4c)
    FIELD(L3_TXPMD_TM_19, TXPMD_TM_19_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_19, PIPE_TM_TX_LSEG_POST_EMPHASIS_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_20, 0xcc50)
    FIELD(L3_TXPMD_TM_20, TXPMD_TM_20_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_20, PIPE_TM_TX_LSEG_POST_MAINSEL_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_21, 0xcc54)
    FIELD(L3_TXPMD_TM_21, TXPMD_TM_21_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_21, PIPE_TM_TX_LSEG_POST_MAINSEL_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_22, 0xcc58)
    FIELD(L3_TXPMD_TM_22, TXPMD_TM_22_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_22, PIPE_TM_TX_LSEG_POST_MARGIN_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_23, 0xcc5c)
    FIELD(L3_TXPMD_TM_23, TXPMD_TM_23_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_23, PIPE_TM_TX_LSEG_POST_MARGIN_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_24, 0xcc60)
    FIELD(L3_TXPMD_TM_24, TXPMD_TM_24_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_24, PIPE_TM_TX_LSEG_PRE_DISABLE_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_25, 0xcc64)
    FIELD(L3_TXPMD_TM_25, TXPMD_TM_25_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_25, PIPE_TM_TX_LSEG_PRE_DISABLE_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_26, 0xcc68)
    FIELD(L3_TXPMD_TM_26, TXPMD_TM_26_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_26, PIPE_TM_TX_LSEG_PRE_EMPHASIS_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_27, 0xcc6c)
    FIELD(L3_TXPMD_TM_27, TXPMD_TM_27_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_27, PIPE_TM_TX_LSEG_PRE_EMPHASIS_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_28, 0xcc70)
    FIELD(L3_TXPMD_TM_28, TXPMD_TM_28_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_28, PIPE_TM_TX_LSEG_PRE_MAINSEL_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_29, 0xcc74)
    FIELD(L3_TXPMD_TM_29, TXPMD_TM_29_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_29, PIPE_TM_TX_LSEG_PRE_MAINSEL_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_30, 0xcc78)
    FIELD(L3_TXPMD_TM_30, TXPMD_TM_30_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_30, PIPE_TM_TX_LSEG_PRE_MARGIN_ENDPOS, 0, 5)
REG32(L3_TXPMD_TM_31, 0xcc7c)
    FIELD(L3_TXPMD_TM_31, TXPMD_TM_31_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_31, PIPE_TM_TX_LSEG_PRE_MARGIN_STARTPOS, 0, 5)
REG32(L3_TXPMD_TM_32, 0xcc80)
    FIELD(L3_TXPMD_TM_32, TXPMD_TM_32_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_32, PIPE_TM_TX_PRE_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L3_TXPMD_TM_33, 0xcc84)
    FIELD(L3_TXPMD_TM_33, TXPMD_TM_33_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_33, PIPE_TM_TX_PRE_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L3_TXPMD_TM_34, 0xcc88)
    FIELD(L3_TXPMD_TM_34, TXPMD_TM_34_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_34, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L3_TXPMD_TM_35, 0xcc8c)
    FIELD(L3_TXPMD_TM_35, TXPMD_TM_35_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_35, PIPE_TM_TX_MAIN_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L3_TXPMD_TM_36, 0xcc90)
    FIELD(L3_TXPMD_TM_36, TXPMD_TM_36_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_36, PIPE_TM_TX_POST_FS_DIVISION_COEF_7_0, 0, 8)
REG32(L3_TXPMD_TM_37, 0xcc94)
    FIELD(L3_TXPMD_TM_37, TXPMD_TM_37_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_37, PIPE_TM_TX_POST_FS_DIVISION_COEF_15_8, 0, 8)
REG32(L3_TXPMD_TM_38, 0xcc98)
    FIELD(L3_TXPMD_TM_38, TXPMD_TM_38_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_38, ANA_MISC0_7_RSVD, 7, 1)
    FIELD(L3_TXPMD_TM_38, PIPE_TM_TX_ENABLE_SWNW_CNTRL_BYP, 6, 1)
    FIELD(L3_TXPMD_TM_38, PIPE_TM_TX_ENABLE_TRISTATE_BYP, 5, 1)
    FIELD(L3_TXPMD_TM_38, PIPE_TM_TX_TRISTATE, 4, 1)
    FIELD(L3_TXPMD_TM_38, TM_TX_DRIVERLDO_RXDET_BYP, 3, 1)
    FIELD(L3_TXPMD_TM_38, TM_TX_DRIVERLDO_IDLE_BYP, 2, 1)
    FIELD(L3_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_RXDET_BYP, 1, 1)
    FIELD(L3_TXPMD_TM_38, TM_TX_DRIVERLDO_EN_IDLE_BYP, 0, 1)
REG32(L3_TXPMD_TM_39, 0xcc9c)
    FIELD(L3_TXPMD_TM_39, TXPMD_TM_39_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_39, ANA_MPHY_BYP0_7_3_RSVD, 3, 5)
    FIELD(L3_TXPMD_TM_39, MPHY_TM_TX_OVRD_DEEMPH_TRIM, 2, 1)
    FIELD(L3_TXPMD_TM_39, MPHY_TM_TX_ENABLE_DEEMPH, 1, 1)
    FIELD(L3_TXPMD_TM_39, MPHY_TM_TX_OVRD_ENABLE_DEEMPH, 0, 1)
REG32(L3_TXPMD_TM_40, 0xcca0)
    FIELD(L3_TXPMD_TM_40, TXPMD_TM_40_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_40, MPHY_TM_TX_DEEMPH_TRIM_7_0, 0, 8)
REG32(L3_TXPMD_TM_41, 0xcca4)
    FIELD(L3_TXPMD_TM_41, TXPMD_TM_41_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_41, MPHY_TM_TX_DEEMPH_TRIM_15_8, 0, 8)
REG32(L3_TXPMD_TM_42, 0xcca8)
    FIELD(L3_TXPMD_TM_42, TXPMD_TM_42_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_42, ANA_MPHY_BYP3_7_5_RSVD, 5, 3)
    FIELD(L3_TXPMD_TM_42, MPHY_TM_TX_OVRD_LS_DATA, 1, 4)
    FIELD(L3_TXPMD_TM_42, MPHY_TM_TX_ENABLE_OVRD_LS_DATA, 0, 1)
REG32(L3_TXPMD_TM_43, 0xccac)
    FIELD(L3_TXPMD_TM_43, TXPMD_TM_43_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_43, ANA_MPHY_BYP4_7_4_RSVD, 4, 4)
    FIELD(L3_TXPMD_TM_43, MPHY_TM_TX_OVRD_LS_DATA_BAR, 0, 4)
REG32(L3_TXPMD_TM_44, 0xccb0)
    FIELD(L3_TXPMD_TM_44, TXPMD_TM_44_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_44, ANA_PIPE_BYP38_7_6_RSVD, 6, 2)
    FIELD(L3_TXPMD_TM_44, PIPE_TM_TX_EN_PRE_LFPS_PATH, 5, 1)
    FIELD(L3_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_PRE_LFPS_PATH, 4, 1)
    FIELD(L3_TXPMD_TM_44, PIPE_TM_TX_EN_POST_LFPS_PATH, 3, 1)
    FIELD(L3_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_POST_LFPS_PATH, 2, 1)
    FIELD(L3_TXPMD_TM_44, PIPE_TM_TX_EN_MAIN_LFPS_PATH, 1, 1)
    FIELD(L3_TXPMD_TM_44, PIPE_TM_TX_OVRD_EN_MAIN_LFPS_PATH, 0, 1)
REG32(L3_TXPMD_TM_45, 0xccb4)
    FIELD(L3_TXPMD_TM_45, TXPMD_TM_45_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_45, ANA_DP_BYP0_7_6_RSVD, 6, 2)
    FIELD(L3_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST2_PATH, 5, 1)
    FIELD(L3_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST2_PATH, 4, 1)
    FIELD(L3_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_POST1_PATH, 3, 1)
    FIELD(L3_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_POST1_PATH, 2, 1)
    FIELD(L3_TXPMD_TM_45, DP_TM_TX_DP_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L3_TXPMD_TM_45, DP_TM_TX_OVRD_DP_ENABLE_MAIN_PATH, 0, 1)
REG32(L3_TXPMD_TM_46, 0xccb8)
    FIELD(L3_TXPMD_TM_46, TXPMD_TM_46_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_46, ANA_PIPE_BYP39_7_6_RSVD, 6, 2)
    FIELD(L3_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_PRE_PATH, 5, 1)
    FIELD(L3_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_PRE_PATH, 4, 1)
    FIELD(L3_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_POST_PATH, 3, 1)
    FIELD(L3_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_POST_PATH, 2, 1)
    FIELD(L3_TXPMD_TM_46, PIPE_TM_TX_PIPE_ENABLE_MAIN_PATH, 1, 1)
    FIELD(L3_TXPMD_TM_46, PIPE_TM_TX_OVRD_PIPE_ENABLE_MAIN_PATH, 0, 1)
REG32(L3_TXPMD_TM_47, 0xccbc)
    FIELD(L3_TXPMD_TM_47, TXPMD_TM_47_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_47, TM_TX_RSVD1, 0, 8)
REG32(L3_TXPMD_TM_48, 0xccc0)
    FIELD(L3_TXPMD_TM_48, TXPMD_TM_48_31_8_RSVD, 24, 8)
    FIELD(L3_TXPMD_TM_48, ANA_MISC2_7_6_RSVD, 6, 2)
    FIELD(L3_TXPMD_TM_48, TM_FORCE_RESULTANT_MARGINING_FACTOR, 5, 1)
    FIELD(L3_TXPMD_TM_48, TM_RESULTANT_MARGINING_FACTOR, 0, 5)
REG32(L3_TM_ANA_BYP_1, 0xd004)
    FIELD(L3_TM_ANA_BYP_1, TM_ANA_BYP_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_1, MPHY_PWM_DES_PDZ, 7, 1)
    FIELD(L3_TM_ANA_BYP_1, FORCE_MPHY_PWM_DES_PDZ, 6, 1)
    FIELD(L3_TM_ANA_BYP_1, MPHY_PWMB_SYS_ENABLE, 5, 1)
    FIELD(L3_TM_ANA_BYP_1, FORCE_MPHY_PWMB_SYS_ENABLE, 4, 1)
    FIELD(L3_TM_ANA_BYP_1, MPHY_PSO_SQUELCH, 3, 1)
    FIELD(L3_TM_ANA_BYP_1, FORCE_MPHY_PSO_SQUELCH, 2, 1)
    FIELD(L3_TM_ANA_BYP_1, MPHY_PSO_LSRX, 1, 1)
    FIELD(L3_TM_ANA_BYP_1, FORCE_MPHY_PSO_LSRX, 0, 1)
REG32(L3_TM_ANA_BYP_2, 0xd008)
    FIELD(L3_TM_ANA_BYP_2, TM_ANA_BYP_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_2, MPHY_PWM_LSPREAMP_PD, 7, 1)
    FIELD(L3_TM_ANA_BYP_2, FORCE_MPHY_PWM_LSPREAMP_PD, 6, 1)
    FIELD(L3_TM_ANA_BYP_2, MPHY_PWM_GEAR_SEL, 3, 3)
    FIELD(L3_TM_ANA_BYP_2, FORCE_MPHY_PWM_GEAR_SEL, 2, 1)
    FIELD(L3_TM_ANA_BYP_2, MPHY_PWM_DET_PD, 1, 1)
    FIELD(L3_TM_ANA_BYP_2, FORCE_MPHY_PWM_DET_PD, 0, 1)
REG32(L3_TM_ANA_BYP_3, 0xd00c)
    FIELD(L3_TM_ANA_BYP_3, TM_ANA_BYP_3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_3, MPHY_RX_MASK_BURST_START, 7, 1)
    FIELD(L3_TM_ANA_BYP_3, FORCE_MPHY_RX_MASK_BURST_START, 6, 1)
    FIELD(L3_TM_ANA_BYP_3, MPHY_RX_GATE_SYMBOL_CLK, 5, 1)
    FIELD(L3_TM_ANA_BYP_3, FORCE_MPHY_RX_GATE_SYMBOL_CLK, 4, 1)
    FIELD(L3_TM_ANA_BYP_3, MPHY_PWM_PREAMP_BIAS_PD, 3, 1)
    FIELD(L3_TM_ANA_BYP_3, FORCE_MPHY_PWM_PREAMP_BIAS_PD, 2, 1)
    FIELD(L3_TM_ANA_BYP_3, MPHY_PWM_LSPREAMP_STANDBYSLEEPSTALL, 1, 1)
    FIELD(L3_TM_ANA_BYP_3, FORCE_MPHY_PWM_LSPREAMP_STANDBYSLEEPSTAL, 0, 1)
REG32(L3_TM_ANA_BYP_4, 0xd010)
    FIELD(L3_TM_ANA_BYP_4, TM_ANA_BYP_4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_4, HSRX_RSTB, 7, 1)
    FIELD(L3_TM_ANA_BYP_4, FORCE_HSRX_RSTB, 6, 1)
    FIELD(L3_TM_ANA_BYP_4, MPHY_RX_TERM_ENABLE, 5, 1)
    FIELD(L3_TM_ANA_BYP_4, FORCE_MPHY_RX_TERM_ENABLE, 4, 1)
    FIELD(L3_TM_ANA_BYP_4, MPHY_RX_MUX_TYP1B_TYP2, 3, 1)
    FIELD(L3_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_TYP1B_TYP2, 2, 1)
    FIELD(L3_TM_ANA_BYP_4, MPHY_RX_MUX_HSB_LS, 1, 1)
    FIELD(L3_TM_ANA_BYP_4, FORCE_MPHY_RX_MUX_HSB_LS, 0, 1)
REG32(L3_TM_ANA_BYP_5, 0xd014)
    FIELD(L3_TM_ANA_BYP_5, TM_ANA_BYP_5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_5, MPHY_SQ_SWAP_POLARITY, 5, 1)
    FIELD(L3_TM_ANA_BYP_5, FORCE_MPHY_SQ_SWAP_POLARITY, 4, 1)
    FIELD(L3_TM_ANA_BYP_5, MPHY_SQ_PD, 3, 1)
    FIELD(L3_TM_ANA_BYP_5, FORCE_MPHY_SQ_PD, 2, 1)
    FIELD(L3_TM_ANA_BYP_5, MPHY_SQ_DETECTOR_PD, 1, 1)
    FIELD(L3_TM_ANA_BYP_5, FORCE_MPHY_SQ_DETECTOR_PD, 0, 1)
REG32(L3_TM_ANA_BYP_7, 0xd018)
    FIELD(L3_TM_ANA_BYP_7, TM_ANA_BYP_7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_7, PIPE_RXEQTRAINING, 7, 1)
    FIELD(L3_TM_ANA_BYP_7, FORCE_PIPE_RXEQTRAINING, 6, 1)
    FIELD(L3_TM_ANA_BYP_7, PIPE_RX_TERM_ENABLE, 5, 1)
    FIELD(L3_TM_ANA_BYP_7, FORCE_PIPE_RX_TERM_ENABLE, 4, 1)
REG32(L3_TM_ANA_BYP_8, 0xd01c)
    FIELD(L3_TM_ANA_BYP_8, TM_ANA_BYP_8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 7, 1)
    FIELD(L3_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_IO_MIRROR_ENABLE, 6, 1)
    FIELD(L3_TM_ANA_BYP_8, UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 5, 1)
    FIELD(L3_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_IRCONST_CORE_MIRROR_ENABLE, 4, 1)
    FIELD(L3_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 3, 1)
    FIELD(L3_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_IO_MIRROR_ENABLE, 2, 1)
    FIELD(L3_TM_ANA_BYP_8, UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 1, 1)
    FIELD(L3_TM_ANA_BYP_8, FORCE_UPHY_BIASGEN_ICONST_CORE_MIRROR_ENABLE, 0, 1)
REG32(L3_TM_ANA_BYP_9, 0xd020)
    FIELD(L3_TM_ANA_BYP_9, TM_ANA_BYP_9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_9, UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 7, 1)
    FIELD(L3_TM_ANA_BYP_9, FORCE_UPHY_RECLPBK_CLK_DATAZ_ENABLE_CORE, 6, 1)
    FIELD(L3_TM_ANA_BYP_9, UPHY_PSO_SAMP_LPBK, 5, 1)
    FIELD(L3_TM_ANA_BYP_9, FORCE_UPHY_PSO_SAMP_LPBK, 4, 1)
    FIELD(L3_TM_ANA_BYP_9, UPHY_EQ_LPBK_ENABLE_CORE, 3, 1)
    FIELD(L3_TM_ANA_BYP_9, FORCE_UPHY_EQ_LPBK_ENABLE_CORE, 2, 1)
    FIELD(L3_TM_ANA_BYP_9, UPHY_EQ_AC_DCZ_COUPLED_CORE, 1, 1)
    FIELD(L3_TM_ANA_BYP_9, FORCE_UPHY_EQ_AC_DCZ_COUPLED_CORE, 0, 1)
REG32(L3_TM_ANA_BYP_10, 0xd024)
    FIELD(L3_TM_ANA_BYP_10, TM_ANA_BYP_10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_10, UPHY_LPBK_CLK_DATA_SEL, 5, 1)
    FIELD(L3_TM_ANA_BYP_10, UPHY_LPBK_CENTRE_EDGEZ_ENABLE_CORE, 4, 1)
    FIELD(L3_TM_ANA_BYP_10, UPHY_HSRX_LPBK_SEL, 1, 3)
    FIELD(L3_TM_ANA_BYP_10, FORCE_UPHY_HSRX_LPBK_SEL, 0, 1)
REG32(L3_TM_ANA_BYP_11, 0xd028)
    FIELD(L3_TM_ANA_BYP_11, TM_ANA_BYP_11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_11, UPHY_PD_PI_DIV_PATH, 5, 1)
    FIELD(L3_TM_ANA_BYP_11, UPHY_PSO_CLK_LANE, 4, 1)
    FIELD(L3_TM_ANA_BYP_11, FORCE_UPHY_PSO_CLK_LANE, 3, 1)
    FIELD(L3_TM_ANA_BYP_11, UPHY_HSCLK_DIVISION_FACTOR, 1, 2)
    FIELD(L3_TM_ANA_BYP_11, FORCE_UPHY_HSCLK_DIVISION_FACTOR, 0, 1)
REG32(L3_TM_ANA_BYP_12, 0xd02c)
    FIELD(L3_TM_ANA_BYP_12, TM_ANA_BYP_12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_12, UPHY_PSO_HSRXDIG, 7, 1)
    FIELD(L3_TM_ANA_BYP_12, FORCE_UPHY_PSO_HSRXDIG, 6, 1)
    FIELD(L3_TM_ANA_BYP_12, UPHY_PDN_HS_DES, 5, 1)
    FIELD(L3_TM_ANA_BYP_12, FORCE_UPHY_PDN_HS_DES, 4, 1)
    FIELD(L3_TM_ANA_BYP_12, UPHY_RST_GF_MUX, 3, 1)
    FIELD(L3_TM_ANA_BYP_12, FORCE_UPHY_RST_GF_MUX, 2, 1)
    FIELD(L3_TM_ANA_BYP_12, UPHY_ENABLE_CDR, 1, 1)
    FIELD(L3_TM_ANA_BYP_12, FORCE_UPHY_ENABLE_CDR, 0, 1)
REG32(L3_TM_ANA_BYP_13, 0xd030)
    FIELD(L3_TM_ANA_BYP_13, TM_ANA_BYP_13_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_13, UPHY_PSO_SAMP_FLOPS, 1, 1)
    FIELD(L3_TM_ANA_BYP_13, FORCE_UPHY_PSO_SAMP_FLOPS, 0, 1)
REG32(L3_TM_ANA_BYP_14, 0xd034)
    FIELD(L3_TM_ANA_BYP_14, TM_ANA_BYP_14_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_14, UPHY_PSO_EPI, 7, 1)
    FIELD(L3_TM_ANA_BYP_14, FORCE_UPHY_PSO_EPI, 6, 1)
    FIELD(L3_TM_ANA_BYP_14, UPHY_PD_SAMP_C2C_ECLK, 5, 1)
    FIELD(L3_TM_ANA_BYP_14, FORCE_UPHY_PD_SAMP_C2C_ECLK, 4, 1)
    FIELD(L3_TM_ANA_BYP_14, UPHY_PSO_IQPI, 1, 1)
    FIELD(L3_TM_ANA_BYP_14, FORCE_UPHY_PSO_IQPI, 0, 1)
REG32(L3_TM_ANA_BYP_15, 0xd038)
    FIELD(L3_TM_ANA_BYP_15, TM_ANA_BYP_15_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_15, UPHY_ENABLE_LOW_LEAKAGE, 7, 1)
    FIELD(L3_TM_ANA_BYP_15, FORCE_UPHY_ENABLE_LOW_LEAKAGE, 6, 1)
    FIELD(L3_TM_ANA_BYP_15, UPHY_PD_SAMP_C2C, 5, 1)
    FIELD(L3_TM_ANA_BYP_15, FORCE_UPHY_PD_SAMP_C2C, 4, 1)
    FIELD(L3_TM_ANA_BYP_15, UPHY_PSO_CORE_EQ, 3, 1)
    FIELD(L3_TM_ANA_BYP_15, FORCE_UPHY_PSO_CORE_EQ, 2, 1)
    FIELD(L3_TM_ANA_BYP_15, UPHY_PSO_IO_EQ, 1, 1)
    FIELD(L3_TM_ANA_BYP_15, FORCE_UPHY_PSO_IO_EQ, 0, 1)
REG32(L3_TM_ANA_BYP_16, 0xd03c)
    FIELD(L3_TM_ANA_BYP_16, TM_ANA_BYP_16_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_16, UPHY_PSO_SIGDET, 7, 1)
    FIELD(L3_TM_ANA_BYP_16, FORCE_UPHY_PSO_SIGDET, 6, 1)
    FIELD(L3_TM_ANA_BYP_16, UPHY_RX_LANE_POLARITY_SWAP, 5, 1)
    FIELD(L3_TM_ANA_BYP_16, FORCE_UPHY_RX_LANE_POLARITY_SWAP, 4, 1)
    FIELD(L3_TM_ANA_BYP_16, UPHY_RUN_CALIB, 3, 1)
    FIELD(L3_TM_ANA_BYP_16, FORCE_UPHY_RUN_CALIB, 2, 1)
    FIELD(L3_TM_ANA_BYP_16, UPHY_RESTORE_CALCODE, 1, 1)
    FIELD(L3_TM_ANA_BYP_16, FORCE_UPHY_RESTORE_CALCODE, 0, 1)
REG32(L3_TM_ANA_BYP_17, 0xd040)
    FIELD(L3_TM_ANA_BYP_17, TM_ANA_BYP_17_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_17, UPHY_STARTLOOP_PLL, 6, 1)
    FIELD(L3_TM_ANA_BYP_17, FORCE_UPHY_STARTLOOP_PLL, 5, 1)
    FIELD(L3_TM_ANA_BYP_17, UPHY_RX_RESCALIB_CODE, 1, 4)
    FIELD(L3_TM_ANA_BYP_17, FORCE_UPHY_RX_RESCALIB_CODE, 0, 1)
REG32(L3_TM_ANA_BYP_18, 0xd044)
    FIELD(L3_TM_ANA_BYP_18, TM_ANA_BYP_18_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_18, FORCE_UPHY_RESTORE_CALCODE_DATA, 3, 1)
    FIELD(L3_TM_ANA_BYP_18, FORCE_UPHY_RX_PMA_OPMODE, 2, 1)
    FIELD(L3_TM_ANA_BYP_18, UPHY_PSO_LFPSBCN, 1, 1)
    FIELD(L3_TM_ANA_BYP_18, FORCE_UPHY_PSO_LFPSBCN, 0, 1)
REG32(L3_TM_ANA_BYP_20, 0xd048)
    FIELD(L3_TM_ANA_BYP_20, TM_ANA_BYP_20_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_20, UPHY_RX_PMA_OPMODE, 0, 8)
REG32(L3_TM_ANA_BYP_21, 0xd04c)
    FIELD(L3_TM_ANA_BYP_21, TM_ANA_BYP_21_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_21, UPHY_RESTORE_CALCODE_DATA, 0, 8)
REG32(L3_TM_ANA_BYP_22, 0xd050)
    FIELD(L3_TM_ANA_BYP_22, TM_ANA_BYP_22_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_22, ISO_HSRX_CTRL_BAR, 7, 1)
    FIELD(L3_TM_ANA_BYP_22, FORCE_ISO_HSRX_CTRL_BAR, 6, 1)
    FIELD(L3_TM_ANA_BYP_22, HSRX_CLOCK_STOP_REQ, 5, 1)
    FIELD(L3_TM_ANA_BYP_22, FORCE_HSRX_CLOCK_STOP_REQ, 4, 1)
    FIELD(L3_TM_ANA_BYP_22, UPHY_SBRX_RUN_CALIB, 3, 1)
    FIELD(L3_TM_ANA_BYP_22, FORCE_UPHY_SBRX_RUN_CALIB, 2, 1)
    FIELD(L3_TM_ANA_BYP_22, RXPMA_RSTB, 1, 1)
    FIELD(L3_TM_ANA_BYP_22, FORCE_RXPMA_RSTB, 0, 1)
REG32(L3_TM_ANA_BYP_23, 0xd054)
    FIELD(L3_TM_ANA_BYP_23, TM_ANA_BYP_23_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_BYP_23, ISO_SIGDET_CTRL_BAR, 7, 1)
    FIELD(L3_TM_ANA_BYP_23, FORCE_ISO_SIGDET_CTRL_BAR, 6, 1)
    FIELD(L3_TM_ANA_BYP_23, ISO_LFPS_CTRL_BAR, 5, 1)
    FIELD(L3_TM_ANA_BYP_23, FORCE_ISO_LFPS_CTRL_BAR, 4, 1)
    FIELD(L3_TM_ANA_BYP_23, ISO_MPHY_LSRX_CTRL_BAR, 3, 1)
    FIELD(L3_TM_ANA_BYP_23, FORCE_ISO_MPHY_LSRX_CTRL_BAR, 2, 1)
    FIELD(L3_TM_ANA_BYP_23, ISO_MPHY_SQUELCH_CTRL_BAR, 1, 1)
    FIELD(L3_TM_ANA_BYP_23, FORCE_ISO_MPHY_SQUELCH_CTRL_BAR, 0, 1)
REG32(L3_TM_DIG_1, 0xd058)
    FIELD(L3_TM_DIG_1, TM_DIG_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_1, EN_TXRX_DIFGEAR, 7, 1)
    FIELD(L3_TM_DIG_1, MPHY_HS_TERM_PT_SEL, 6, 1)
    FIELD(L3_TM_DIG_1, TX_ALLOW_INLNCFG_FROM_TOP, 5, 1)
    FIELD(L3_TM_DIG_1, BYPASS_MARKER_DETECTOR, 4, 1)
    FIELD(L3_TM_DIG_1, BYPASS_EXIT_VAL, 0, 4)
REG32(L3_TM_DIG_2, 0xd05c)
    FIELD(L3_TM_DIG_2, TM_DIG_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_2, MPHY_SYM_STATE, 1, 5)
    FIELD(L3_TM_DIG_2, FORCE_MPHY_SYM_STATE, 0, 1)
REG32(L3_TM_DIG_3, 0xd060)
    FIELD(L3_TM_DIG_3, TM_DIG_3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_3, MPHY_SQUELCH_DETECT, 7, 1)
    FIELD(L3_TM_DIG_3, FORCE_MPHY_SQUELCH_DETECT, 6, 1)
    FIELD(L3_TM_DIG_3, MPHY_CFG_STATE, 1, 5)
    FIELD(L3_TM_DIG_3, FORCE_MPHY_CFG_STATE, 0, 1)
REG32(L3_TM_DIG_4, 0xd064)
    FIELD(L3_TM_DIG_4, TM_DIG_4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_4, STATUS_REG_VAL, 4, 4)
    FIELD(L3_TM_DIG_4, READ_SHADOW, 3, 1)
REG32(L3_TM_DIG_5, 0xd068)
    FIELD(L3_TM_DIG_5, TM_DIG_5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_5, SYMBOL_CLK_ALWAYS_ON_N, 2, 1)
    FIELD(L3_TM_DIG_5, BYPASS_DIFN_DETECT, 1, 1)
    FIELD(L3_TM_DIG_5, HIBERN8_CTRL, 0, 1)
REG32(L3_TM_DIG_6, 0xd06c)
    FIELD(L3_TM_DIG_6, TM_DIG_6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_6, FORCE_BYPASS_ON_ERR, 6, 1)
    FIELD(L3_TM_DIG_6, SUPPRESS_ERR, 5, 1)
    FIELD(L3_TM_DIG_6, BYPASS_OHC, 4, 1)
    FIELD(L3_TM_DIG_6, BYPASS_DECODER, 3, 1)
    FIELD(L3_TM_DIG_6, FORCE_BYPASS_DEC, 2, 1)
    FIELD(L3_TM_DIG_6, BYPASS_DESCRAM, 1, 1)
    FIELD(L3_TM_DIG_6, FORCE_BYPASS_DESCRAM, 0, 1)
REG32(L3_TM_DIG_7, 0xd070)
    FIELD(L3_TM_DIG_7, TM_DIG_7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_7, BYPASS_ON_ERR_CHAR, 0, 8)
REG32(L3_TM_DIG_8, 0xd074)
    FIELD(L3_TM_DIG_8, TM_DIG_8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_8, EYESURF_ENABLE, 4, 1)
    FIELD(L3_TM_DIG_8, USE_EB_IN_MPHY, 3, 1)
    FIELD(L3_TM_DIG_8, BYPASS_EB, 2, 1)
    FIELD(L3_TM_DIG_8, EB_MODE, 1, 1)
    FIELD(L3_TM_DIG_8, FORCE_EB_MODE, 0, 1)
REG32(L3_TM_DIG_9, 0xd078)
    FIELD(L3_TM_DIG_9, TM_DIG_9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_9, FLIP_ENDIAN, 3, 1)
    FIELD(L3_TM_DIG_9, DEC_ERR_CNT_THRESHOLD, 0, 3)
REG32(L3_TM_DIG_10, 0xd07c)
    FIELD(L3_TM_DIG_10, TM_DIG_10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_10, CDR_BIT_LOCK_TIME, 0, 4)
REG32(L3_TM_DIG_11, 0xd080)
    FIELD(L3_TM_DIG_11, TM_DIG_11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_11, BYPASS_CDR_ERR_MASK, 7, 1)
    FIELD(L3_TM_DIG_11, SYMB_ERR_SEL, 5, 2)
    FIELD(L3_TM_DIG_11, SYMB_ERR, 4, 1)
REG32(L3_TM_DIG_12, 0xd084)
    FIELD(L3_TM_DIG_12, TM_DIG_12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_12, FLIP_ENDIAN_EB_DATA_OUT, 5, 1)
    FIELD(L3_TM_DIG_12, FLIP_ENDIAN_EB_DATA_IN, 4, 1)
    FIELD(L3_TM_DIG_12, OVERFLOW_BYP, 3, 1)
    FIELD(L3_TM_DIG_12, UNDERFLOW_BYP, 2, 1)
    FIELD(L3_TM_DIG_12, OVERFLOW_BYP_VAL, 1, 1)
    FIELD(L3_TM_DIG_12, UNDERFLOW_BYP_VAL, 0, 1)
REG32(L3_TM_DIG_13, 0xd088)
    FIELD(L3_TM_DIG_13, TM_DIG_13_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_13, OMC_PRESENTN, 6, 1)
    FIELD(L3_TM_DIG_13, CFG_CLK_FREQ, 0, 6)
REG32(L3_TM_DIG_14, 0xd08c)
    FIELD(L3_TM_DIG_14, TM_DIG_14_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_14, LFPS_OUTPUT_SEL, 6, 2)
    FIELD(L3_TM_DIG_14, LFPS_STRETCH, 4, 2)
REG32(L3_TM_DIG_15, 0xd090)
    FIELD(L3_TM_DIG_15, TM_DIG_15_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_15, FORCE_LFPS_FILTER_THRESH, 5, 1)
    FIELD(L3_TM_DIG_15, LFPS_FILTER_THRESH, 0, 5)
REG32(L3_TM_DIG_16, 0xd094)
    FIELD(L3_TM_DIG_16, TM_DIG_16_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_16, TESTDIGOUT_SEL, 1, 4)
    FIELD(L3_TM_DIG_16, FORCE_TESTDIGOUT_SEL, 0, 1)
REG32(L3_TM_DIG_17, 0xd098)
    FIELD(L3_TM_DIG_17, TM_DIG_17_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_17, FORCE_SATA_RX_VALID_CNT, 4, 1)
    FIELD(L3_TM_DIG_17, SATA_RX_VALID_CNT, 0, 4)
REG32(L3_TM_DIG_18, 0xd09c)
    FIELD(L3_TM_DIG_18, TM_DIG_18_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_18, CLK_DIST_SETTLE_TIME, 4, 4)
    FIELD(L3_TM_DIG_18, BIASGEN_SETTLE_TIME, 0, 4)
REG32(L3_TM_DIG_19, 0xd0a0)
    FIELD(L3_TM_DIG_19, TM_DIG_19_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_19, HSRX_ANA_SETTLE_TIME, 4, 4)
    FIELD(L3_TM_DIG_19, SBRX_ANA_SETTLE_TIME, 0, 4)
REG32(L3_TM_DIG_20, 0xd0a4)
    FIELD(L3_TM_DIG_20, TM_DIG_20_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_20, HSRX_COOLING_TIME, 3, 4)
    FIELD(L3_TM_DIG_20, FORCE_RX_CAL, 2, 1)
    FIELD(L3_TM_DIG_20, BYPASS_HSRX_CAL, 1, 1)
    FIELD(L3_TM_DIG_20, BYPASS_SBRX_CAL, 0, 1)
REG32(L3_TM_DIG_21, 0xd0a8)
    FIELD(L3_TM_DIG_21, TM_DIG_21_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_21, COMMA_LOCATION_RST, 4, 1)
    FIELD(L3_TM_DIG_21, SSC_WAIT_CNT, 2, 2)
    FIELD(L3_TM_DIG_21, COMMA_PRE_LOCK_THRESH, 0, 2)
REG32(L3_TM_DIG_22, 0xd0ac)
    FIELD(L3_TM_DIG_22, TM_DIG_22_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_22, DIS_DEFAULT_CDR_GATE_LOGIC, 5, 1)
    FIELD(L3_TM_DIG_22, INV_POL_SIGDET_HIGH, 4, 1)
    FIELD(L3_TM_DIG_22, INV_POL_SIGDET_LOW, 3, 1)
    FIELD(L3_TM_DIG_22, SIGDET_LFPS_BAR_EN, 2, 1)
    FIELD(L3_TM_DIG_22, OBSRV_SIGDET_OUTPUT, 1, 1)
    FIELD(L3_TM_DIG_22, RX_SIGDET_EN, 0, 1)
REG32(L3_TM_DIG_23, 0xd0b0)
    FIELD(L3_TM_DIG_23, TM_DIG_23_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_23, DELAY_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L3_TM_DIG_23, FORCE_RX_SIGDET_SEL, 5, 1)
    FIELD(L3_TM_DIG_23, RX_SIGDET_SEL_VAL, 4, 1)
    FIELD(L3_TM_DIG_23, FORCE_RX_SIG_DET_FILT_FUNC_SEL, 3, 1)
    FIELD(L3_TM_DIG_23, RX_SIG_DET_FILT_FUNC_SEL, 0, 3)
REG32(L3_TM_DIG_24, 0xd0b4)
    FIELD(L3_TM_DIG_24, TM_DIG_24_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_24, FILTER_TIMER_LOAD_VAL_HIGH_1, 6, 2)
    FIELD(L3_TM_DIG_24, MIN_TIMER_LOAD_VAL_HIGH_1, 4, 2)
    FIELD(L3_TM_DIG_24, FILTER_TIMER_LOAD_VAL_LOW_1, 2, 2)
    FIELD(L3_TM_DIG_24, MIN_TIMER_LOAD_VAL_LOW_1, 0, 2)
REG32(L3_TM_DIG_25, 0xd0b8)
    FIELD(L3_TM_DIG_25, TM_DIG_25_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_25, FILTER_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L3_TM_DIG_26, 0xd0bc)
    FIELD(L3_TM_DIG_26, TM_DIG_26_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_26, DELAY_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L3_TM_DIG_27, 0xd0c0)
    FIELD(L3_TM_DIG_27, TM_DIG_27_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_27, MIN_TIMER_LOAD_VAL_HIGH_0, 0, 8)
REG32(L3_TM_DIG_28, 0xd0c4)
    FIELD(L3_TM_DIG_28, TM_DIG_28_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_28, FILTER_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L3_TM_DIG_29, 0xd0c8)
    FIELD(L3_TM_DIG_29, TM_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_29, MIN_TIMER_LOAD_VAL_LOW_0, 0, 8)
REG32(L3_TM_AUX_0, 0xd0cc)
    FIELD(L3_TM_AUX_0, TM_AUX_0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_AUX_0, BIT_0, 7, 1)
    FIELD(L3_TM_AUX_0, BIT_1, 6, 1)
    FIELD(L3_TM_AUX_0, BIT_2, 5, 1)
    FIELD(L3_TM_AUX_0, BIT_3, 4, 1)
    FIELD(L3_TM_AUX_0, BIT_4, 3, 1)
    FIELD(L3_TM_AUX_0, BIT_5, 2, 1)
    FIELD(L3_TM_AUX_0, BIT_6, 1, 1)
    FIELD(L3_TM_AUX_0, BIT_7, 0, 1)
REG32(L3_TM_AUX_1, 0xd0d0)
    FIELD(L3_TM_AUX_1, TM_AUX_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_AUX_1, BIT_0, 7, 1)
    FIELD(L3_TM_AUX_1, BIT_1, 6, 1)
    FIELD(L3_TM_AUX_1, BIT_2, 5, 1)
    FIELD(L3_TM_AUX_1, BIT_3, 4, 1)
    FIELD(L3_TM_AUX_1, BIT_4, 3, 1)
    FIELD(L3_TM_AUX_1, BIT_5, 2, 1)
    FIELD(L3_TM_AUX_1, BIT_6, 1, 1)
    FIELD(L3_TM_AUX_1, BIT_7, 0, 1)
REG32(L3_TM_AUX_2, 0xd0d4)
    FIELD(L3_TM_AUX_2, TM_AUX_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_AUX_2, BIT_0, 7, 1)
    FIELD(L3_TM_AUX_2, BIT_1, 6, 1)
    FIELD(L3_TM_AUX_2, BIT_2, 5, 1)
    FIELD(L3_TM_AUX_2, BIT_3, 4, 1)
    FIELD(L3_TM_AUX_2, BIT_4, 3, 1)
    FIELD(L3_TM_AUX_2, BIT_5, 2, 1)
    FIELD(L3_TM_AUX_2, BIT_6, 1, 1)
    FIELD(L3_TM_AUX_2, BIT_7, 0, 1)
REG32(L3_TM_AUX_3, 0xd0d8)
    FIELD(L3_TM_AUX_3, TM_AUX_3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_AUX_3, BIT_0, 7, 1)
    FIELD(L3_TM_AUX_3, BIT_1, 6, 1)
    FIELD(L3_TM_AUX_3, BIT_2, 5, 1)
    FIELD(L3_TM_AUX_3, BIT_3, 4, 1)
    FIELD(L3_TM_AUX_3, BIT_4, 3, 1)
    FIELD(L3_TM_AUX_3, BIT_5, 2, 1)
    FIELD(L3_TM_AUX_3, BIT_6, 1, 1)
    FIELD(L3_TM_AUX_3, BIT_7, 0, 1)
REG32(L3_TM_AUX_4, 0xd0dc)
    FIELD(L3_TM_AUX_4, TM_AUX_4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_AUX_4, BIT_0, 7, 1)
    FIELD(L3_TM_AUX_4, BIT_1, 6, 1)
    FIELD(L3_TM_AUX_4, BIT_2, 5, 1)
    FIELD(L3_TM_AUX_4, BIT_3, 4, 1)
    FIELD(L3_TM_AUX_4, BIT_4, 3, 1)
    FIELD(L3_TM_AUX_4, BIT_5, 2, 1)
    FIELD(L3_TM_AUX_4, BIT_6, 1, 1)
    FIELD(L3_TM_AUX_4, BIT_7, 0, 1)
REG32(L3_TM_DIG_30, 0xd0e0)
    FIELD(L3_TM_DIG_30, TM_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_30, SD_LD_BAR_FILTER_TIME_VAL_1, 4, 2)
    FIELD(L3_TM_DIG_30, SD_LD_BAR_DLY_TIME_VAL_1, 2, 2)
    FIELD(L3_TM_DIG_30, SD_LD_BAR_MIN_TIMER_VAL_1, 0, 2)
REG32(L3_TM_DIG_31, 0xd0e4)
    FIELD(L3_TM_DIG_31, TM_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_31, SD_LD_BAR_FILTER_TIME_VAL_0, 0, 8)
REG32(L3_TM_DIG_32, 0xd0e8)
    FIELD(L3_TM_DIG_32, TM_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_32, SD_LD_BAR_DLY_TIME_VAL_0, 0, 8)
REG32(L3_TM_DIG_33, 0xd0ec)
    FIELD(L3_TM_DIG_33, TM_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_33, SD_LD_BAR_MIN_TIMER_VAL_0, 0, 8)
REG32(L3_TM_DIG_34, 0xd0f0)
    FIELD(L3_TM_DIG_34, TM_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_34, SATA_JUNK_DATA_TIMEOUT_VAL, 0, 6)
REG32(L3_TM_DIG_35, 0xd0f4)
    FIELD(L3_TM_DIG_35, TM_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_35, SATA_CDR_LOCK_WAIT_TIMEOUT_VAL, 0, 6)
REG32(L3_TM_DIG_36, 0xd0f8)
    FIELD(L3_TM_DIG_36, TM_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_36, COM_DET_THRESH_VAL_0, 0, 8)
REG32(L3_TM_DIG_37, 0xd0fc)
    FIELD(L3_TM_DIG_37, TM_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DIG_37, FORCE_COM_DETECT_THRESH, 4, 1)
    FIELD(L3_TM_DIG_37, COM_DET_THRESH_VAL_1, 0, 4)
REG32(L3_TM_LFPS_1, 0xd800)
    FIELD(L3_TM_LFPS_1, TM_LFPS_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_LFPS_1, PROG_REFP, 4, 4)
    FIELD(L3_TM_LFPS_1, PROG_REFM, 0, 4)
REG32(L3_TM_LFPS_2, 0xd804)
    FIELD(L3_TM_LFPS_2, TM_LFPS_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_LFPS_2, PROG_VCM, 4, 3)
    FIELD(L3_TM_LFPS_2, PROG_FILTER_CAP, 0, 4)
REG32(L3_TM_LFPS_3, 0xd808)
    FIELD(L3_TM_LFPS_3, TM_LFPS_3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_LFPS_3, PROG_C2, 5, 3)
    FIELD(L3_TM_LFPS_3, PROG_C1, 2, 3)
    FIELD(L3_TM_LFPS_3, PROG_PADINTF, 0, 2)
REG32(L3_TM_LFPS_4, 0xd80c)
    FIELD(L3_TM_LFPS_4, TM_LFPS_4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_LFPS_4, TESTBIT, 0, 6)
REG32(L3_TM_RXPMA_1, 0xd810)
    FIELD(L3_TM_RXPMA_1, TM_RXPMA_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_RXPMA_1, UPHY_TESTBIT, 0, 8)
REG32(L3_TM_BSCAN_1, 0xd814)
    FIELD(L3_TM_BSCAN_1, TM_BSCAN_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BSCAN_1, BSCAN_LPF_RES, 0, 3)
REG32(L3_TM_MPHY_SQ_1, 0xd818)
    FIELD(L3_TM_MPHY_SQ_1, TM_MPHY_SQ_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MPHY_SQ_1, TB_REDUCE_OFFSET, 4, 1)
    FIELD(L3_TM_MPHY_SQ_1, TB_INCREASE_OFFSET, 3, 1)
    FIELD(L3_TM_MPHY_SQ_1, TB_DRIVE_RES_SEL, 1, 2)
    FIELD(L3_TM_MPHY_SQ_1, TB_BYPASS_HYST, 0, 1)
REG32(L3_TM_LSRX_1, 0xd81c)
    FIELD(L3_TM_LSRX_1, TM_LSRX_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_LSRX_1, LSRX_TESTBITS_0, 0, 8)
REG32(L3_TM_LSRX_2, 0xd820)
    FIELD(L3_TM_LSRX_2, TM_LSRX_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_LSRX_2, LSRX_TESTBITS_1, 0, 6)
REG32(L3_TM_SIGDET_1, 0xd824)
    FIELD(L3_TM_SIGDET_1, TM_SIGDET_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SIGDET_1, BIASTRIM, 4, 3)
    FIELD(L3_TM_SIGDET_1, RELIABPROT, 2, 2)
    FIELD(L3_TM_SIGDET_1, STRESSPORT, 0, 2)
REG32(L3_TM_SIGDET_2, 0xd828)
    FIELD(L3_TM_SIGDET_2, TM_SIGDET_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SIGDET_2, VSENSETRIM, 0, 8)
REG32(L3_TM_DFT_1, 0xd82c)
    FIELD(L3_TM_DFT_1, TM_DFT_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_1, LFPS_DFT_SEL_P, 4, 4)
    FIELD(L3_TM_DFT_1, LFPS_DFT_ENABLE, 3, 1)
REG32(L3_TM_DFT_2, 0xd830)
    FIELD(L3_TM_DFT_2, TM_DFT_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_2, SIGDET_DFT_SEL_P, 0, 3)
REG32(L3_TM_DFT_3, 0xd834)
    FIELD(L3_TM_DFT_3, TM_DFT_3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_3, BSCAN_DFT_ENABLE, 4, 1)
    FIELD(L3_TM_DFT_3, BSCAN_DFT_SEL_P, 0, 4)
REG32(L3_TM_DFT_4, 0xd838)
    FIELD(L3_TM_DFT_4, TM_DFT_4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_4, IQPI_DFT_ENABLE, 1, 1)
    FIELD(L3_TM_DFT_4, EPI_DFT_ENABLE, 0, 1)
REG32(L3_TM_DFT_5, 0xd83c)
    FIELD(L3_TM_DFT_5, TM_DFT_5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_5, IQPI_DFT_SEL, 0, 8)
REG32(L3_TM_DFT_6, 0xd840)
    FIELD(L3_TM_DFT_6, TM_DFT_6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_6, EPI_DFT_SEL, 0, 8)
REG32(L3_TM_DFT_7, 0xd844)
    FIELD(L3_TM_DFT_7, TM_DFT_7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_7, EQ_DFT_ENABLE, 4, 1)
    FIELD(L3_TM_DFT_7, EQ_DFT_SEL_P, 0, 4)
REG32(L3_TM_DFT_8, 0xd848)
    FIELD(L3_TM_DFT_8, TM_DFT_8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_8, LSRX_DFT_ENABLE, 4, 1)
    FIELD(L3_TM_DFT_8, LSRX_DFT_SEL_P, 0, 4)
REG32(L3_TM_DFT_9, 0xd84c)
    FIELD(L3_TM_DFT_9, TM_DFT_9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_9, SAMP_DFT_SEL_P_0, 0, 8)
REG32(L3_TM_DFT_10, 0xd850)
    FIELD(L3_TM_DFT_10, TM_DFT_10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_DFT_10, CLKLANE_DFT_SEL, 2, 2)
    FIELD(L3_TM_DFT_10, SAMP_DFT_SEL_P_1, 0, 2)
REG32(L3_TM_BG_1, 0xd854)
    FIELD(L3_TM_BG_1, TM_BG_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_1, BIASGEN_CURRENT_PROG_0, 0, 8)
REG32(L3_TM_BG_2, 0xd858)
    FIELD(L3_TM_BG_2, TM_BG_2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_2, BIASGEN_CURRENT_PROG_1, 0, 8)
REG32(L3_TM_BG_3, 0xd85c)
    FIELD(L3_TM_BG_3, TM_BG_3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_3, BIASGEN_CURRENT_PROG_2, 0, 8)
REG32(L3_TM_BG_4, 0xd860)
    FIELD(L3_TM_BG_4, TM_BG_4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_4, BIASGEN_CURRENT_PROG_3, 0, 8)
REG32(L3_TM_BG_5, 0xd864)
    FIELD(L3_TM_BG_5, TM_BG_5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_5, BIASGEN_CURRENT_PROG_4, 0, 8)
REG32(L3_TM_BG_6, 0xd868)
    FIELD(L3_TM_BG_6, TM_BG_6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_6, BIASGEN_CURRENT_PROG_5, 0, 8)
REG32(L3_TM_BG_7, 0xd86c)
    FIELD(L3_TM_BG_7, TM_BG_7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_7, BIASGEN_CURRENT_PROG_6, 0, 8)
REG32(L3_TM_BG_8, 0xd870)
    FIELD(L3_TM_BG_8, TM_BG_8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_8, BIASGEN_CURRENT_PROG_7, 0, 8)
REG32(L3_TM_BG_9, 0xd874)
    FIELD(L3_TM_BG_9, TM_BG_9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_9, BIASGEN_CURRENT_PROG_8, 0, 8)
REG32(L3_TM_BG_10, 0xd878)
    FIELD(L3_TM_BG_10, TM_BG_10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BG_10, BIASGEN_CURRENT_PROG_9, 0, 8)
REG32(L3_TM_SD0, 0xd87c)
    FIELD(L3_TM_SD0, TM_SD0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD0, SD_CAL_OVERRIDE_CODE, 2, 6)
    FIELD(L3_TM_SD0, SD_CAL_OVERRIDE_EN, 1, 1)
    FIELD(L3_TM_SD0, SD_CAL_DIR, 0, 1)
REG32(L3_TM_SD1, 0xd880)
    FIELD(L3_TM_SD1, TM_SD1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD1, SD_BYPASS_ANA_CAL_EN_VAL, 7, 1)
    FIELD(L3_TM_SD1, SD_BYPASS_ANA_CAL_EN, 6, 1)
    FIELD(L3_TM_SD1, SD_CAL_CODE_START, 0, 6)
REG32(L3_TM_SD2, 0xd884)
    FIELD(L3_TM_SD2, TM_SD2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD2, SD_CAL_FORCE_CAL, 7, 1)
    FIELD(L3_TM_SD2, SD_CAL_CODE_TUNE_BYP, 6, 1)
    FIELD(L3_TM_SD2, SD_CAL_CODE_TUNE, 0, 6)
REG32(L3_TM_SD3, 0xd888)
    FIELD(L3_TM_SD3, TM_SD3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD3, SD_CAL_ITER_WAIT_0, 0, 8)
REG32(L3_TM_SD4, 0xd88c)
    FIELD(L3_TM_SD4, TM_SD4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD4, SD_CAL_ITER_WAIT_BYPASS, 4, 1)
    FIELD(L3_TM_SD4, SD_CAL_ITER_WAIT_1, 0, 4)
REG32(L3_TM_SD5, 0xd890)
    FIELD(L3_TM_SD5, TM_SD5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD5, SD_CAL_INIT_WAIT_0, 0, 8)
REG32(L3_TM_SD6, 0xd894)
    FIELD(L3_TM_SD6, TM_SD6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD6, SD_CAL_INIT_WAIT_BYPASS, 4, 1)
    FIELD(L3_TM_SD6, SD_CAL_INIT_WAIT_1, 0, 4)
REG32(L3_TM_MISC1, 0xd898)
    FIELD(L3_TM_MISC1, TM_MISC1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MISC1, HSRX_POLARITY_FLIP, 7, 1)
    FIELD(L3_TM_MISC1, RXTERM_BIAS_PROG, 3, 4)
    FIELD(L3_TM_MISC1, LSRX_OR_SYS_POLARITY_FLIP, 2, 1)
    FIELD(L3_TM_MISC1, FORCE_SATAG1_DCC_MODE, 1, 1)
    FIELD(L3_TM_MISC1, SATAG1_DCC_MODE_VAL, 0, 1)
REG32(L3_TM_MISC2, 0xd89c)
    FIELD(L3_TM_MISC2, TM_MISC2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MISC2, ILL_CAL_BYPASS_COUNTS, 7, 1)
    FIELD(L3_TM_MISC2, PWR_SEQ_SAMP_CAL_ALWAYS, 6, 1)
    FIELD(L3_TM_MISC2, PWR_SEQ_BYP_CAL_DONE, 5, 1)
    FIELD(L3_TM_MISC2, PWR_SEQ_BYP_CAL_DONE_VAL, 4, 1)
    FIELD(L3_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ, 3, 1)
    FIELD(L3_TM_MISC2, SAMP_BYPASS_CAL_TO_EQ_VAL, 2, 1)
    FIELD(L3_TM_MISC2, UNUSED, 0, 2)
REG32(L3_TM_EYE_SURF0, 0xd8a0)
    FIELD(L3_TM_EYE_SURF0, TM_EYE_SURF0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF0, UNUSED, 7, 1)
    FIELD(L3_TM_EYE_SURF0, EYE_SURF_RUN, 6, 1)
    FIELD(L3_TM_EYE_SURF0, COORD_EW_DIR, 5, 1)
    FIELD(L3_TM_EYE_SURF0, COORD_EW_OFFSET, 0, 5)
REG32(L3_TM_EYE_SURF1, 0xd8a4)
    FIELD(L3_TM_EYE_SURF1, TM_EYE_SURF1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF1, COORD_NS_DIR, 7, 1)
    FIELD(L3_TM_EYE_SURF1, COORD_NS_OFFSET, 0, 7)
REG32(L3_TM_EYE_SURF2, 0xd8a8)
    FIELD(L3_TM_EYE_SURF2, TM_EYE_SURF2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF2, TIMER_DELAY_TIME0, 0, 8)
REG32(L3_TM_EYE_SURF3, 0xd8ac)
    FIELD(L3_TM_EYE_SURF3, TM_EYE_SURF3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF3, TIMER_DELAY_TIME1, 0, 8)
REG32(L3_TM_EYE_SURF4, 0xd8b0)
    FIELD(L3_TM_EYE_SURF4, TM_EYE_SURF4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF4, TIMER_DELAY_TIME2, 0, 8)
REG32(L3_TM_EYE_SURF5, 0xd8b4)
    FIELD(L3_TM_EYE_SURF5, TM_EYE_SURF5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF5, TIMER_DELAY_TIME3, 0, 8)
REG32(L3_TM_EYE_SURF6, 0xd8b8)
    FIELD(L3_TM_EYE_SURF6, TM_EYE_SURF6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF6, TIMER_TEST_TIME0, 0, 8)
REG32(L3_TM_EYE_SURF7, 0xd8bc)
    FIELD(L3_TM_EYE_SURF7, TM_EYE_SURF7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF7, TIMER_TEST_TIME1, 0, 8)
REG32(L3_TM_EYE_SURF8, 0xd8c0)
    FIELD(L3_TM_EYE_SURF8, TM_EYE_SURF8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF8, TIMER_TEST_TIME2, 0, 8)
REG32(L3_TM_EYE_SURF9, 0xd8c4)
    FIELD(L3_TM_EYE_SURF9, TM_EYE_SURF9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYE_SURF9, TIMER_TEST_TIME3, 0, 8)
REG32(L3_TM_SPARE, 0xd8c8)
    FIELD(L3_TM_SPARE, TM_SPARE_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SPARE, RXDA_SPARE_PORT, 0, 8)
REG32(L3_TM_ANA_EQ1, 0xd8cc)
    FIELD(L3_TM_ANA_EQ1, TM_ANA_EQ1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_EQ1, UNUSED, 5, 3)
    FIELD(L3_TM_ANA_EQ1, EQ_INPUT_CM_PROG, 2, 3)
    FIELD(L3_TM_ANA_EQ1, EQ_PADINTF_HQ_PROG, 0, 2)
REG32(L3_TM_ANA_E_PI0, 0xd8d0)
    FIELD(L3_TM_ANA_E_PI0, TM_ANA_E_PI0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_E_PI0, EPI_BIASTRIM, 5, 3)
    FIELD(L3_TM_ANA_E_PI0, UNUSED, 0, 5)
REG32(L3_TM_ANA_IQ_PI0, 0xd8d4)
    FIELD(L3_TM_ANA_IQ_PI0, TM_ANA_IQ_PI0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_IQ_PI0, IQPI_BIASTRIM, 5, 3)
    FIELD(L3_TM_ANA_IQ_PI0, UNUSED, 0, 5)
REG32(L3_TM_ANA_MISC0, 0xd8d8)
    FIELD(L3_TM_ANA_MISC0, TM_ANA_MISC0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ANA_MISC0, EPI_CALIB_EN, 7, 1)
    FIELD(L3_TM_ANA_MISC0, IQPI_CALIB_EN, 6, 1)
    FIELD(L3_TM_ANA_MISC0, UNUSED, 0, 6)
REG32(L3_TM_SAMP_CODE_IQ_PH0, 0xd8dc)
    FIELD(L3_TM_SAMP_CODE_IQ_PH0, TM_SAMP_CODE_IQ_PH0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_CODE_IQ_PH0, UNUSED, 7, 1)
    FIELD(L3_TM_SAMP_CODE_IQ_PH0, SAMP_CALIB_BYP, 6, 1)
    FIELD(L3_TM_SAMP_CODE_IQ_PH0, IQ_PH0_SAMP_CODE, 0, 6)
REG32(L3_TM_SAMP_CODE_IQ_PH90, 0xd8e0)
    FIELD(L3_TM_SAMP_CODE_IQ_PH90, TM_SAMP_CODE_IQ_PH90_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_CODE_IQ_PH90, CALIB_SWEEP_DIR, 6, 2)
    FIELD(L3_TM_SAMP_CODE_IQ_PH90, IQ_PH90_SAMP_CODE, 0, 6)
REG32(L3_TM_SAMP_CODE_IQ_PH180, 0xd8e4)
    FIELD(L3_TM_SAMP_CODE_IQ_PH180, TM_SAMP_CODE_IQ_PH180_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_CODE_IQ_PH180, UNUSED, 6, 2)
    FIELD(L3_TM_SAMP_CODE_IQ_PH180, IQ_PH180_SAMP_CODE, 0, 6)
REG32(L3_TM_SAMP_CODE_IQ_PH270, 0xd8e8)
    FIELD(L3_TM_SAMP_CODE_IQ_PH270, TM_SAMP_CODE_IQ_PH270_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_CODE_IQ_PH270, HSRX_DBG_BUS_SEL, 6, 2)
    FIELD(L3_TM_SAMP_CODE_IQ_PH270, IQ_PH270_SAMP_CODE, 0, 6)
REG32(L3_TM_SAMP_CODE_E_PH0, 0xd8ec)
    FIELD(L3_TM_SAMP_CODE_E_PH0, TM_SAMP_CODE_E_PH0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_CODE_E_PH0, UNUSED, 6, 2)
    FIELD(L3_TM_SAMP_CODE_E_PH0, E_PH90_SAMP_CODE, 0, 6)
REG32(L3_TM_SAMP_CODE_E_PH180, 0xd8f0)
    FIELD(L3_TM_SAMP_CODE_E_PH180, TM_SAMP_CODE_E_PH180_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_CODE_E_PH180, UNUSED, 6, 2)
    FIELD(L3_TM_SAMP_CODE_E_PH180, E_PH270_SAMP_CODE, 0, 6)
REG32(L3_TM_IQ_ILL0, 0xd8f4)
    FIELD(L3_TM_IQ_ILL0, TM_IQ_ILL0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL0, ILL_BYPASS_IQ_CAL_EN, 7, 1)
    FIELD(L3_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L3_TM_IQ_ILL0, IQ_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L3_TM_IQ_ILL0, ILL_BYPASS_IQ_CODES, 0, 1)
REG32(L3_TM_IQ_ILL1, 0xd8f8)
    FIELD(L3_TM_IQ_ILL1, TM_IQ_ILL1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL1, ILL_BYPASS_IQ_CALCODE_F0, 0, 8)
REG32(L3_TM_IQ_ILL2, 0xd8fc)
    FIELD(L3_TM_IQ_ILL2, TM_IQ_ILL2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL2, ILL_BYPASS_IQ_CALCODE_F1, 0, 8)
REG32(L3_TM_IQ_ILL3, 0xd900)
    FIELD(L3_TM_IQ_ILL3, TM_IQ_ILL3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL3, ILL_BYPASS_IQ_CALCODE_F2, 0, 8)
REG32(L3_TM_IQ_ILL4, 0xd904)
    FIELD(L3_TM_IQ_ILL4, TM_IQ_ILL4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL4, ILL_BYPASS_IQ_CALCODE_F3, 0, 8)
REG32(L3_TM_IQ_ILL5, 0xd908)
    FIELD(L3_TM_IQ_ILL5, TM_IQ_ILL5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL5, ILL_BYPASS_IQ_CALCODE_F4, 0, 8)
REG32(L3_TM_IQ_ILL6, 0xd90c)
    FIELD(L3_TM_IQ_ILL6, TM_IQ_ILL6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL6, ILL_BYPASS_IQ_CALCODE_F5, 0, 8)
REG32(L3_TM_IQ_ILL7, 0xd910)
    FIELD(L3_TM_IQ_ILL7, TM_IQ_ILL7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL7, ILL_BYPASS_IQ_CNSTGMTRIM_VAL, 0, 8)
REG32(L3_TM_IQ_ILL8, 0xd914)
    FIELD(L3_TM_IQ_ILL8, TM_IQ_ILL8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL8, ILL_BYPASS_IQ_POLYTRIM_VAL, 0, 8)
REG32(L3_TM_IQ_ILL9, 0xd918)
    FIELD(L3_TM_IQ_ILL9, TM_IQ_ILL9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL9, UNUSED, 4, 4)
    FIELD(L3_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN, 3, 1)
    FIELD(L3_TM_IQ_ILL9, ILL_BYPASS_IQ_LFEN_VAL, 2, 1)
    FIELD(L3_TM_IQ_ILL9, ILL_BYPASS_IQ_CNSTGMTRIM, 1, 1)
    FIELD(L3_TM_IQ_ILL9, ILL_BYPASS_IQ_POLYTIM, 0, 1)
REG32(L3_TM_IQ_ILL10, 0xd91c)
    FIELD(L3_TM_IQ_ILL10, TM_IQ_ILL10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_IQ_ILL10, UNUSED, 6, 2)
    FIELD(L3_TM_IQ_ILL10, IQPI_CALCTRIM, 4, 2)
    FIELD(L3_TM_IQ_ILL10, IQPI_REPLICATRIM, 0, 4)
REG32(L3_TM_E_ILL0, 0xd920)
    FIELD(L3_TM_E_ILL0, TM_E_ILL0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL0, E_ILL_CALIB_CTRL, 7, 1)
    FIELD(L3_TM_E_ILL0, E_ILL_PLOADTRIM_BYP_VAL, 2, 5)
    FIELD(L3_TM_E_ILL0, E_ILL_PLOADTRIM_BYP, 1, 1)
    FIELD(L3_TM_E_ILL0, E_ILL_CALIB_BYP, 0, 1)
REG32(L3_TM_E_ILL1, 0xd924)
    FIELD(L3_TM_E_ILL1, TM_E_ILL1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL1, ILL_BYPASS_E_CALCODE_F0, 0, 8)
REG32(L3_TM_E_ILL2, 0xd928)
    FIELD(L3_TM_E_ILL2, TM_E_ILL2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL2, ILL_BYPASS_E_CALCODE_F1, 0, 8)
REG32(L3_TM_E_ILL3, 0xd92c)
    FIELD(L3_TM_E_ILL3, TM_E_ILL3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL3, ILL_BYPASS_E_CALCODE_F2, 0, 8)
REG32(L3_TM_E_ILL4, 0xd930)
    FIELD(L3_TM_E_ILL4, TM_E_ILL4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL4, ILL_BYPASS_E_CALCODE_F3, 0, 8)
REG32(L3_TM_E_ILL5, 0xd934)
    FIELD(L3_TM_E_ILL5, TM_E_ILL5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL5, ILL_BYPASS_E_CALCODE_F4, 0, 8)
REG32(L3_TM_E_ILL6, 0xd938)
    FIELD(L3_TM_E_ILL6, TM_E_ILL6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL6, ILL_BYPASS_E_CALCODE_F5, 0, 8)
REG32(L3_TM_E_ILL7, 0xd93c)
    FIELD(L3_TM_E_ILL7, TM_E_ILL7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL7, ILL_BYPASS_E_CNSTGMTRIM_VAL, 0, 8)
REG32(L3_TM_E_ILL8, 0xd940)
    FIELD(L3_TM_E_ILL8, TM_E_ILL8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL8, ILL_BYPASS_E_POLYTRIM_VAL, 0, 8)
REG32(L3_TM_E_ILL9, 0xd944)
    FIELD(L3_TM_E_ILL9, TM_E_ILL9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL9, UNUSED, 4, 4)
    FIELD(L3_TM_E_ILL9, ILL_BYPASS_E_LFEN, 3, 1)
    FIELD(L3_TM_E_ILL9, ILL_BYPASS_E_LFEN_VAL, 2, 1)
    FIELD(L3_TM_E_ILL9, ILL_BYPASS_E_CNSTGMTRIM, 1, 1)
    FIELD(L3_TM_E_ILL9, ILL_BYPASS_E_POLYTIM, 0, 1)
REG32(L3_TM_E_ILL10, 0xd948)
    FIELD(L3_TM_E_ILL10, TM_E_ILL10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_E_ILL10, UNUSED, 6, 2)
    FIELD(L3_TM_E_ILL10, EPI_CALCTRIM, 4, 2)
    FIELD(L3_TM_E_ILL10, EPI_REPLICATRIM, 0, 4)
REG32(L3_TM_EQ0, 0xd94c)
    FIELD(L3_TM_EQ0, TM_EQ0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ0, EQ_STG1_RL_PROG_MSB, 7, 1)
    FIELD(L3_TM_EQ0, EQ_STG1_CTRL_BYP, 6, 1)
    FIELD(L3_TM_EQ0, EQ_STG2_CTRL_BYP, 5, 1)
    FIELD(L3_TM_EQ0, EQ_ADAPTATION_FORCE, 4, 1)
    FIELD(L3_TM_EQ0, EQ_ADAPTATION_FORCE_VAL, 3, 1)
    FIELD(L3_TM_EQ0, EQ_ISOURCE_EN_VAL, 0, 3)
REG32(L3_TM_EQ1, 0xd950)
    FIELD(L3_TM_EQ1, TM_EQ1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ1, EQ_STG1_PREAMP_MODE_VAL, 7, 1)
    FIELD(L3_TM_EQ1, EQ_STG1_RL_PROG, 5, 2)
    FIELD(L3_TM_EQ1, EQ_STG2_CM_PROG, 3, 2)
    FIELD(L3_TM_EQ1, EQ_STG2_PREAMP_MODE_VAL, 2, 1)
    FIELD(L3_TM_EQ1, EQ_STG2_RL_PROG, 0, 2)
REG32(L3_TM_EQ2, 0xd954)
    FIELD(L3_TM_EQ2, TM_EQ2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ2, UNUSED, 7, 1)
    FIELD(L3_TM_EQ2, EQ_EN_BACKGND_ADAPT, 6, 1)
    FIELD(L3_TM_EQ2, EQ_COUNT_STRAYS, 5, 1)
    FIELD(L3_TM_EQ2, EQ_WINDOW_SIZE, 3, 2)
    FIELD(L3_TM_EQ2, EQ_MAJ_THRESH, 1, 2)
    FIELD(L3_TM_EQ2, EQ_BIAS_CTRL_BYP, 0, 1)
REG32(L3_TM_EQ3, 0xd958)
    FIELD(L3_TM_EQ3, TM_EQ3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ3, UNUSED, 5, 3)
    FIELD(L3_TM_EQ3, EQ_BYPASS_ISINK_ENZ_VAL, 0, 5)
REG32(L3_TM_EQ4, 0xd95c)
    FIELD(L3_TM_EQ4, TM_EQ4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ4, UNUSED, 5, 3)
    FIELD(L3_TM_EQ4, BYPASS_EQ_C_STG1, 4, 1)
    FIELD(L3_TM_EQ4, BYPASS_EQ_C_VAL_STG1, 0, 4)
REG32(L3_TM_EQ5, 0xd960)
    FIELD(L3_TM_EQ5, TM_EQ5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ5, UNUSED, 6, 2)
    FIELD(L3_TM_EQ5, BYPASS_EQ_R_STG1, 5, 1)
    FIELD(L3_TM_EQ5, BYPASS_EQ_R_VAL_STG1, 0, 5)
REG32(L3_TM_EQ6, 0xd964)
    FIELD(L3_TM_EQ6, TM_EQ6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ6, UNUSED, 5, 3)
    FIELD(L3_TM_EQ6, BYPASS_EQ_C_STG2, 4, 1)
    FIELD(L3_TM_EQ6, BYPASS_EQ_C_VAL_STG2, 0, 4)
REG32(L3_TM_EQ7, 0xd968)
    FIELD(L3_TM_EQ7, TM_EQ7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ7, UNUSED, 6, 2)
    FIELD(L3_TM_EQ7, BYPASS_EQ_R_STG2, 5, 1)
    FIELD(L3_TM_EQ7, BYPASS_EQ_R_VAL_STG2, 0, 5)
REG32(L3_TM_EQ8, 0xd96c)
    FIELD(L3_TM_EQ8, TM_EQ8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ8, EQ_BYPASS_CALIB, 7, 1)
    FIELD(L3_TM_EQ8, EQ_SWEEP, 5, 2)
    FIELD(L3_TM_EQ8, SEL_SAMP, 2, 3)
    FIELD(L3_TM_EQ8, BYPASS_EQ_CAL, 1, 1)
    FIELD(L3_TM_EQ8, BYPASS_EQ_CAL_VAL, 0, 1)
REG32(L3_TM_EQ9, 0xd970)
    FIELD(L3_TM_EQ9, TM_EQ9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ9, UNUSED, 7, 1)
    FIELD(L3_TM_EQ9, EQ_BYPASS_CALIB_CODE, 0, 7)
REG32(L3_TM_EQ10, 0xd974)
    FIELD(L3_TM_EQ10, TM_EQ10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ10, UNUSED, 7, 1)
    FIELD(L3_TM_EQ10, OFFSET_COEF_SCALER, 4, 3)
    FIELD(L3_TM_EQ10, DIAG_OUTPUT_SEL, 0, 4)
REG32(L3_TM_EQ11, 0xd978)
    FIELD(L3_TM_EQ11, TM_EQ11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ11, EQ_CALIB_CLK_DIV_FORCE, 7, 1)
    FIELD(L3_TM_EQ11, EDGE_IS_FIRST, 6, 1)
    FIELD(L3_TM_EQ11, FORCE_EQ_OFFS_ON, 5, 1)
    FIELD(L3_TM_EQ11, FORCE_EQ_OFFS_OFF, 4, 1)
    FIELD(L3_TM_EQ11, EQ_OFFS_WITH_ADAPT, 3, 1)
    FIELD(L3_TM_EQ11, OFFSET_VOTER_OVERRIDE_EN, 2, 1)
    FIELD(L3_TM_EQ11, OFFSET_VOTER_OVERRIDE_NEG, 1, 1)
    FIELD(L3_TM_EQ11, OFFSET_VOTER_OVERRIDE_POS, 0, 1)
REG32(L3_TM_ILL7, 0xd97c)
    FIELD(L3_TM_ILL7, TM_ILL7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL7, ILL_CAL_INIT_WAIT, 0, 8)
REG32(L3_TM_ILL8, 0xd980)
    FIELD(L3_TM_ILL8, TM_ILL8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL8, ILL_CAL_ITER_WAIT, 0, 8)
REG32(L3_TM_ILL9, 0xd984)
    FIELD(L3_TM_ILL9, TM_ILL9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL9, ILL_CAL_BYPASS_CAP_START, 7, 1)
    FIELD(L3_TM_ILL9, ILL_CAL_CAP_START_VAL, 0, 7)
REG32(L3_TM_ILL10, 0xd988)
    FIELD(L3_TM_ILL10, TM_ILL10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL10, G3A_USB3_PCIEG2_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L3_TM_ILL10, G3B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L3_TM_ILL11, 0xd98c)
    FIELD(L3_TM_ILL11, TM_ILL11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL11, G2A_PCIEG1_PLL_CTR_11_8_BYP_VAL, 4, 4)
    FIELD(L3_TM_ILL11, G2B_PLL_CTR_11_8_BYP_VAL, 0, 4)
REG32(L3_TM_ILL12, 0xd990)
    FIELD(L3_TM_ILL12, TM_ILL12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL12, G1A_PLL_CTR_BYP_VAL, 0, 8)
REG32(L3_TM_ILL13, 0xd994)
    FIELD(L3_TM_ILL13, TM_ILL13_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL13, ILL_CAL_IDLE_VAL_REFCNT, 0, 3)
REG32(L3_TM_ILL14, 0xd998)
    FIELD(L3_TM_ILL14, TM_ILL14_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL14, ILL_CALIB_WAIT, 4, 4)
    FIELD(L3_TM_ILL14, ILL_CHG_WAIT, 0, 4)
REG32(L3_TM_FRZ_FSM0, 0xd99c)
    FIELD(L3_TM_FRZ_FSM0, TM_FRZ_FSM0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_FRZ_FSM0, FREEZE_HSRX_PWR_SEQ_FSM, 0, 8)
REG32(L3_TM_FRZ_FSM1, 0xd9a0)
    FIELD(L3_TM_FRZ_FSM1, TM_FRZ_FSM1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_FRZ_FSM1, UNUSED, 6, 2)
    FIELD(L3_TM_FRZ_FSM1, FREEZE_ILL_CALIB_FSM, 0, 6)
REG32(L3_TM_RST_DLY, 0xd9a4)
    FIELD(L3_TM_RST_DLY, TM_RST_DLY_31_8_RSVD, 24, 8)
    FIELD(L3_TM_RST_DLY, APB_RST_DLY, 0, 8)
REG32(L3_TM_ILL15, 0xd9a8)
    FIELD(L3_TM_ILL15, TM_ILL15_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL15, ILL_CAL_REF_CTR_MSB_REG1, 0, 8)
REG32(L3_TM_MISC3, 0xd9ac)
    FIELD(L3_TM_MISC3, TM_MISC3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MISC3, AUX0_BIT_7, 7, 1)
    FIELD(L3_TM_MISC3, AUX0_BIT_6, 6, 1)
    FIELD(L3_TM_MISC3, AUX0_BIT_5, 5, 1)
    FIELD(L3_TM_MISC3, DBG_BUS_SEL, 2, 3)
    FIELD(L3_TM_MISC3, CDR_EN_FPL, 1, 1)
    FIELD(L3_TM_MISC3, CDR_EN_FFL, 0, 1)
REG32(L3_TM_EQ_OFFS1, 0xd9b0)
    FIELD(L3_TM_EQ_OFFS1, TM_EQ_OFFS1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ_OFFS1, EQ_OFFSET_CORR_BYP, 1, 7)
    FIELD(L3_TM_EQ_OFFS1, AUX1_BIT_7, 0, 1)
REG32(L3_TM_SAMP0, 0xd9b4)
    FIELD(L3_TM_SAMP0, TM_SAMP0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP0, SAMP_CALIB_CLK_DIV_FACTOR, 1, 7)
    FIELD(L3_TM_SAMP0, SAMP_CALIB_CLK_DIV_FORCE, 0, 1)
REG32(L3_TM_EQ12, 0xd9b8)
    FIELD(L3_TM_EQ12, TM_EQ12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ12, EQ_CALIB_CLK_DIV_FACTOR, 0, 8)
REG32(L3_TM_MISC4, 0xd9bc)
    FIELD(L3_TM_MISC4, TM_MISC4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MISC4, PSO_CLK_LANE_FRM_PCS, 2, 1)
    FIELD(L3_TM_MISC4, BSCAN_MODE_VAL, 1, 1)
    FIELD(L3_TM_MISC4, BSCAN_FORCE_MODE, 0, 1)
REG32(L3_TM_SAMP_STATUS0, 0xda80)
    FIELD(L3_TM_SAMP_STATUS0, TM_SAMP_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_STATUS0, IQ_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L3_TM_SAMP_STATUS1, 0xda84)
    FIELD(L3_TM_SAMP_STATUS1, TM_SAMP_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_STATUS1, IQ_SAMP_PH90_CALIB_CODE, 0, 6)
REG32(L3_TM_SAMP_STATUS2, 0xda88)
    FIELD(L3_TM_SAMP_STATUS2, TM_SAMP_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_STATUS2, IQ_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L3_TM_SAMP_STATUS3, 0xda8c)
    FIELD(L3_TM_SAMP_STATUS3, TM_SAMP_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_STATUS3, IQ_SAMP_PH270_CALIB_CODE, 0, 6)
REG32(L3_TM_SAMP_STATUS4, 0xda90)
    FIELD(L3_TM_SAMP_STATUS4, TM_SAMP_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_STATUS4, E_SAMP_PH0_CALIB_CODE, 0, 6)
REG32(L3_TM_SAMP_STATUS5, 0xda94)
    FIELD(L3_TM_SAMP_STATUS5, TM_SAMP_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SAMP_STATUS5, E_SAMP_PH180_CALIB_CODE, 0, 6)
REG32(L3_TM_ILL_STATUS0, 0xda98)
    FIELD(L3_TM_ILL_STATUS0, TM_ILL_STATUS0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS0, IQ_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS1, 0xda9c)
    FIELD(L3_TM_ILL_STATUS1, TM_ILL_STATUS1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS1, IQ_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS2, 0xdaa0)
    FIELD(L3_TM_ILL_STATUS2, TM_ILL_STATUS2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS2, IQ_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS3, 0xdaa4)
    FIELD(L3_TM_ILL_STATUS3, TM_ILL_STATUS3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS3, IQ_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS4, 0xdaa8)
    FIELD(L3_TM_ILL_STATUS4, TM_ILL_STATUS4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS4, IQ_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS5, 0xdaac)
    FIELD(L3_TM_ILL_STATUS5, TM_ILL_STATUS5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS5, IQ_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS6, 0xdab0)
    FIELD(L3_TM_ILL_STATUS6, TM_ILL_STATUS6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS6, E_F0_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS7, 0xdab4)
    FIELD(L3_TM_ILL_STATUS7, TM_ILL_STATUS7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS7, E_F1_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS8, 0xdab8)
    FIELD(L3_TM_ILL_STATUS8, TM_ILL_STATUS8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS8, E_F2_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS9, 0xdabc)
    FIELD(L3_TM_ILL_STATUS9, TM_ILL_STATUS9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS9, E_F3_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS10, 0xdac0)
    FIELD(L3_TM_ILL_STATUS10, TM_ILL_STATUS10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS10, E_F4_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_ILL_STATUS11, 0xdac4)
    FIELD(L3_TM_ILL_STATUS11, TM_ILL_STATUS11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_ILL_STATUS11, E_F5_CALCODE_CALIB_VAL, 0, 7)
REG32(L3_TM_MISC_ST_0, 0xdac8)
    FIELD(L3_TM_MISC_ST_0, TM_MISC_ST_0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MISC_ST_0, EYE_SURF_DONE, 5, 1)
    FIELD(L3_TM_MISC_ST_0, SD_CAL_DONE, 4, 1)
    FIELD(L3_TM_MISC_ST_0, SAMP_CAL_DONE, 3, 1)
    FIELD(L3_TM_MISC_ST_0, ILL_CAL_DONE, 2, 1)
    FIELD(L3_TM_MISC_ST_0, EQ_CAL_DONE, 1, 1)
    FIELD(L3_TM_MISC_ST_0, EQ_VALID_ADAPT_CODE, 0, 1)
REG32(L3_TM_SD_ST_0, 0xdacc)
    FIELD(L3_TM_SD_ST_0, TM_SD_ST_0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SD_ST_0, SD_CAL_CODE, 0, 6)
REG32(L3_TM_EYESURF_ST0, 0xdad0)
    FIELD(L3_TM_EYESURF_ST0, TM_EYESURF_ST0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYESURF_ST0, ERROR_COUNT0, 0, 8)
REG32(L3_TM_EYESURF_ST1, 0xdad4)
    FIELD(L3_TM_EYESURF_ST1, TM_EYESURF_ST1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EYESURF_ST1, ERROR_COUNT1, 0, 8)
REG32(L3_TM_EQ_ST0, 0xdad8)
    FIELD(L3_TM_EQ_ST0, TM_EQ_ST0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ_ST0, EQ_ADAPT_CODE0, 0, 8)
REG32(L3_TM_EQ_ST1, 0xdadc)
    FIELD(L3_TM_EQ_ST1, TM_EQ_ST1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ_ST1, EQ_ADAPT_CODE1, 0, 8)
REG32(L3_TM_EQ_ST2, 0xdae0)
    FIELD(L3_TM_EQ_ST2, TM_EQ_ST2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_EQ_ST2, EQ_CALIB_CODE, 0, 7)
REG32(L3_TM_RXPMA_ST1, 0xdae4)
    FIELD(L3_TM_RXPMA_ST1, TM_RXPMA_ST1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_RXPMA_ST1, HSRX_OPMODE_STATUS, 0, 8)
REG32(L3_TM_CDR0, 0xdc00)
    FIELD(L3_TM_CDR0, TM_CDR0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR0, FAST_PHASE_LOCK_FORCE, 7, 1)
    FIELD(L3_TM_CDR0, UNUSED, 5, 2)
    FIELD(L3_TM_CDR0, CDR_LOOP_CTRL, 2, 3)
    FIELD(L3_TM_CDR0, SECOND_ORDER_LOOP_DIS, 1, 1)
    FIELD(L3_TM_CDR0, FIRST_ORDER_LOOP_DIS, 0, 1)
REG32(L3_TM_CDR1, 0xdc04)
    FIELD(L3_TM_CDR1, TM_CDR1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR1, RESET_DELAY_2OL, 0, 8)
REG32(L3_TM_CDR2, 0xdc08)
    FIELD(L3_TM_CDR2, TM_CDR2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR2, CLK_SEL_2OL, 6, 2)
    FIELD(L3_TM_CDR2, INTEGRATOR_THRESH_2OL, 0, 6)
REG32(L3_TM_CDR3, 0xdc0c)
    FIELD(L3_TM_CDR3, TM_CDR3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR3, UNUSED, 7, 1)
    FIELD(L3_TM_CDR3, SIGNAL_THRESH_1OL, 0, 7)
REG32(L3_TM_CDR4, 0xdc10)
    FIELD(L3_TM_CDR4, TM_CDR4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR4, UNUSED, 7, 1)
    FIELD(L3_TM_CDR4, SIGNAL_THRESH_2OL, 0, 7)
REG32(L3_TM_CDR5, 0xdc14)
    FIELD(L3_TM_CDR5, TM_CDR5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR5, FPHL_FSM_ACC_CYCLES, 5, 3)
    FIELD(L3_TM_CDR5, FFL_PH0_INT_GAIN, 0, 5)
REG32(L3_TM_CDR6, 0xdc18)
    FIELD(L3_TM_CDR6, TM_CDR6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR6, FPHL_FSM_DELAY_CYCLES, 5, 3)
    FIELD(L3_TM_CDR6, FFL_PH1_INT_GAIN, 0, 5)
REG32(L3_TM_CDR7, 0xdc1c)
    FIELD(L3_TM_CDR7, TM_CDR7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR7, FPHL_FSM_TRIGGER1_WAIT_CYCLES, 5, 3)
    FIELD(L3_TM_CDR7, FFL_PH2_INT_GAIN, 0, 5)
REG32(L3_TM_CDR8, 0xdc20)
    FIELD(L3_TM_CDR8, TM_CDR8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR8, FPHL_FSM_TRIGGER2_WAIT_CYCLES, 5, 3)
    FIELD(L3_TM_CDR8, FFL_PH3_INT_GAIN, 0, 5)
REG32(L3_TM_CDR9, 0xdc24)
    FIELD(L3_TM_CDR9, TM_CDR9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR9, FPHL_FSM_TRIGGER3_WAIT_CYCLES, 5, 3)
    FIELD(L3_TM_CDR9, FFL_PH4_INT_GAIN, 0, 5)
REG32(L3_TM_CDR10, 0xdc28)
    FIELD(L3_TM_CDR10, TM_CDR10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR10, FFL_TIME_PER_PHASE_10_8, 5, 3)
    FIELD(L3_TM_CDR10, FFL_PH5_INT_GAIN, 0, 5)
REG32(L3_TM_CDR11, 0xdc2c)
    FIELD(L3_TM_CDR11, TM_CDR11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR11, UNUSED, 5, 3)
    FIELD(L3_TM_CDR11, FFL_PH6_INT_GAIN, 0, 5)
REG32(L3_TM_CDR12, 0xdc30)
    FIELD(L3_TM_CDR12, TM_CDR12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR12, CDRLF_RESET_ON_EN_CDR, 7, 1)
    FIELD(L3_TM_CDR12, CDRLF_RESET_ON_INT_MAX_2OL, 6, 1)
    FIELD(L3_TM_CDR12, CDRLF_RESET_ON_MODE_CHG, 5, 1)
    FIELD(L3_TM_CDR12, FFL_PH7_INT_GAIN, 0, 5)
REG32(L3_TM_CDR13, 0xdc34)
    FIELD(L3_TM_CDR13, TM_CDR13_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR13, FFL_TIME_PER_PHASE_7_0, 0, 8)
REG32(L3_TM_CDR14, 0xdc38)
    FIELD(L3_TM_CDR14, TM_CDR14_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR14, FFL_PH3_POST_INT_GAIN, 6, 2)
    FIELD(L3_TM_CDR14, FFL_PH2_POST_INT_GAIN, 4, 2)
    FIELD(L3_TM_CDR14, FFL_PH1_POST_INT_GAIN, 2, 2)
    FIELD(L3_TM_CDR14, FFL_PH0_POST_INT_GAIN, 0, 2)
REG32(L3_TM_CDR15, 0xdc3c)
    FIELD(L3_TM_CDR15, TM_CDR15_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR15, FFL_PH7_POST_INT_GAIN, 6, 2)
    FIELD(L3_TM_CDR15, FFL_PH6_POST_INT_GAIN, 4, 2)
    FIELD(L3_TM_CDR15, FFL_PH5_POST_INT_GAIN, 2, 2)
    FIELD(L3_TM_CDR15, FFL_PH4_POST_INT_GAIN, 0, 2)
REG32(L3_TM_CDR16, 0xdc40)
    FIELD(L3_TM_CDR16, TM_CDR16_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR16, UNUSED, 5, 3)
    FIELD(L3_TM_CDR16, FFL_PH0_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR17, 0xdc44)
    FIELD(L3_TM_CDR17, TM_CDR17_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR17, UNUSED, 5, 3)
    FIELD(L3_TM_CDR17, FFL_PH1_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR18, 0xdc48)
    FIELD(L3_TM_CDR18, TM_CDR18_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR18, UNUSED, 5, 3)
    FIELD(L3_TM_CDR18, FFL_PH2_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR19, 0xdc4c)
    FIELD(L3_TM_CDR19, TM_CDR19_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR19, UNUSED, 5, 3)
    FIELD(L3_TM_CDR19, FFL_PH3_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR20, 0xdc50)
    FIELD(L3_TM_CDR20, TM_CDR20_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR20, UNUSED, 5, 3)
    FIELD(L3_TM_CDR20, FFL_PH4_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR21, 0xdc54)
    FIELD(L3_TM_CDR21, TM_CDR21_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR21, UNUSED, 5, 3)
    FIELD(L3_TM_CDR21, FFL_PH5_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR22, 0xdc58)
    FIELD(L3_TM_CDR22, TM_CDR22_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR22, UNUSED, 5, 3)
    FIELD(L3_TM_CDR22, FFL_PH6_PROP_GAIN, 0, 5)
REG32(L3_TM_CDR23, 0xdc5c)
    FIELD(L3_TM_CDR23, TM_CDR23_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CDR23, UNUSED, 7, 1)
    FIELD(L3_TM_CDR23, PHASE_LAG_LEAD_RESPONSE, 5, 2)
    FIELD(L3_TM_CDR23, FFL_PH7_PROP_GAIN, 0, 5)
REG32(L3_TM_MISC0, 0xdc60)
    FIELD(L3_TM_MISC0, TM_MISC0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MISC0, UNUSED, 2, 6)
    FIELD(L3_TM_MISC0, DBG0_SEL, 0, 2)
REG32(L3_TM_HSRX_ST0, 0xdc64)
    FIELD(L3_TM_HSRX_ST0, TM_HSRX_ST0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_HSRX_ST0, FAST_LOCK_STATUS, 0, 1)
REG32(L3_TM_PLL_LS_CLOCK, 0xe000)
    FIELD(L3_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_LS_CLOCK, TM_PLL_LS_CLOCK, 0, 8)
REG32(L3_TM_PLL_LOOP_FILT, 0xe004)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_PLL_LOOP_FILT_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_FORCE_RES_SW_ON, 7, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_HIGH_RES_SW_ON, 6, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_MPHY_USB3_R2_LOW_RES_SW_ON, 5, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_PCIE_R1_DEFAULT_RES_SW_ON, 4, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_PCIE_R1_HIGH_RES_SW_ON, 3, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_PCIE_R1_LOW_RES_SW_ON, 2, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_BYPASS_SEC_LOOP_FILTER, 1, 1)
    FIELD(L3_TM_PLL_LOOP_FILT, TM_SEC_LOOP, 0, 1)
REG32(L3_TM_PLL_DIG2, 0xe008)
    FIELD(L3_TM_PLL_DIG2, TM_PLL_DIG2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG2, TM_FBDIV_0_LSB, 7, 1)
    FIELD(L3_TM_PLL_DIG2, TM_PLL_HS_CLOCK_0, 0, 7)
REG32(L3_TM_PLL_FBDIV, 0xe00c)
    FIELD(L3_TM_PLL_FBDIV, TM_PLL_FBDIV_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_FBDIV, TM_FBDIV_1, 0, 8)
REG32(L3_TM_PLL_DIG4, 0xe010)
    FIELD(L3_TM_PLL_DIG4, TM_PLL_DIG4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG4, TM_VCO_CLOCK_PULDN, 7, 1)
    FIELD(L3_TM_PLL_DIG4, TM_FORCE_ANA_COARSEDONE, 6, 1)
    FIELD(L3_TM_PLL_DIG4, TM_ANA_COARSEDONE, 5, 1)
    FIELD(L3_TM_PLL_DIG4, TM_FORCE_COARSE_DONE_INT, 4, 1)
    FIELD(L3_TM_PLL_DIG4, TM_COARSE_DONE_INT, 3, 1)
    FIELD(L3_TM_PLL_DIG4, TM_FORCE_FBDIV, 2, 1)
    FIELD(L3_TM_PLL_DIG4, TM_FBDIV_2, 0, 2)
REG32(L3_TM_PLL_DIG5, 0xe014)
    FIELD(L3_TM_PLL_DIG5, TM_PLL_DIG5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG5, TM_PD_6GHZ_LOWNOISE_RING, 7, 1)
    FIELD(L3_TM_PLL_DIG5, TM_PD_6GHZ_RING, 6, 1)
    FIELD(L3_TM_PLL_DIG5, TM_COARSE_PROG, 1, 5)
    FIELD(L3_TM_PLL_DIG5, TM_FORCE_VCO_CLOCK_PULDN, 0, 1)
REG32(L3_TM_PLL_DIG6, 0xe018)
    FIELD(L3_TM_PLL_DIG6, TM_PLL_DIG6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG6, TM_CONFG_CHNG_CYCLES_0_LSB, 7, 1)
    FIELD(L3_TM_PLL_DIG6, TM_VCO_SETTLE_CYCLES, 5, 2)
    FIELD(L3_TM_PLL_DIG6, TM_INITIAL_WAIT_CYCLES, 3, 2)
    FIELD(L3_TM_PLL_DIG6, TM_FORCE_COARSE_PROG_PD_RING, 2, 1)
    FIELD(L3_TM_PLL_DIG6, TM_PD_1P5GHZ_RING, 1, 1)
    FIELD(L3_TM_PLL_DIG6, TM_PD_3GHZ_RING, 0, 1)
REG32(L3_TM_PLL_DIG7, 0xe01c)
    FIELD(L3_TM_PLL_DIG7, TM_PLL_DIG7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG7, TM_CPUMP_CODE_0_LSB, 7, 1)
    FIELD(L3_TM_PLL_DIG7, TM_FORCE_ANA_START_LOOP, 6, 1)
    FIELD(L3_TM_PLL_DIG7, TM_ANA_START_LOOP, 5, 1)
    FIELD(L3_TM_PLL_DIG7, TM_PLL_LOCK_CYCLES, 3, 2)
    FIELD(L3_TM_PLL_DIG7, TM_STAND_BY_SETTLE_CYCLES, 1, 2)
    FIELD(L3_TM_PLL_DIG7, TM_CONFG_CHNG_CYCLES_1_MSB, 0, 1)
REG32(L3_TM_PLL_CPUMP_CODE_1, 0xe020)
    FIELD(L3_TM_PLL_CPUMP_CODE_1, TM_PLL_CPUMP_CODE_1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_CPUMP_CODE_1, TM_CPUMP_CODE_1, 0, 8)
REG32(L3_TM_PLL_DIG9, 0xe024)
    FIELD(L3_TM_PLL_DIG9, TM_PLL_DIG9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG9, TM_PLL_RSVD, 6, 2)
    FIELD(L3_TM_PLL_DIG9, TM_FB_BY2_BYPASS, 5, 1)
    FIELD(L3_TM_PLL_DIG9, TM_FORCE_CP_CODE, 4, 1)
    FIELD(L3_TM_PLL_DIG9, TM_CPUMP_CODE_2_MSB, 0, 4)
REG32(L3_TM_PLL_COARSE_CODE_LSB, 0xe028)
    FIELD(L3_TM_PLL_COARSE_CODE_LSB, TM_PLL_COARSE_CODE_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_COARSE_CODE_LSB, TM_COARSE_CODE_LSB, 0, 8)
REG32(L3_TM_PLL_DIG11, 0xe02c)
    FIELD(L3_TM_PLL_DIG11, TM_PLL_DIG11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG11, TM_CONST_NDAC_CNTRL, 4, 4)
    FIELD(L3_TM_PLL_DIG11, TM_FORCE_COARSE_CODE, 3, 1)
    FIELD(L3_TM_PLL_DIG11, TM_COARSE_CODE_MSB, 0, 3)
REG32(L3_TM_PLL_DIG12, 0xe030)
    FIELD(L3_TM_PLL_DIG12, TM_PLL_DIG12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG12, TM_FORCE_PTAT_NDAC_CNTRL, 7, 1)
    FIELD(L3_TM_PLL_DIG12, TM_PTAT_NDAC_CNTRL, 1, 6)
    FIELD(L3_TM_PLL_DIG12, TM_FORCE_CONST_NDAC_CNTRL, 0, 1)
REG32(L3_TM_PLL_CONST_PMOS, 0xe034)
    FIELD(L3_TM_PLL_CONST_PMOS, TM_PLL_CONST_PMOS_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_CONST_PMOS, TM_CONST_PMOS_CNTRL, 0, 8)
REG32(L3_TM_PLL_DIG14, 0xe038)
    FIELD(L3_TM_PLL_DIG14, TM_PLL_DIG14_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG14, TM_COARSE_CODE_AFTER_V2I_0_LSB, 1, 7)
    FIELD(L3_TM_PLL_DIG14, TM_FORCE_CONST_PMOS_CNTRL, 0, 1)
REG32(L3_TM_PLL_DIG15, 0xe03c)
    FIELD(L3_TM_PLL_DIG15, TM_PLL_DIG15_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG15, TM_V2I_CODE_0_LSB, 5, 3)
    FIELD(L3_TM_PLL_DIG15, TM_FORCE_COARSE_CODE_AFTER_V2I, 4, 1)
    FIELD(L3_TM_PLL_DIG15, TM_COARSE_CODE_AFTER_V2I_1_MSB, 0, 4)
REG32(L3_TM_PLL_DIG16, 0xe040)
    FIELD(L3_TM_PLL_DIG16, TM_PLL_DIG16_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG16, TM_FORCE_PLL_LOCK, 7, 1)
    FIELD(L3_TM_PLL_DIG16, TM_PLL_LOCK, 6, 1)
    FIELD(L3_TM_PLL_DIG16, TM_FORCE_SS_NO_STEPS_STEP_SIZE, 5, 1)
    FIELD(L3_TM_PLL_DIG16, TM_PLL_RSVD, 4, 1)
    FIELD(L3_TM_PLL_DIG16, TM_FORCE_V2I_CODE, 3, 1)
    FIELD(L3_TM_PLL_DIG16, TM_V2I_CODE_1_MSB, 0, 3)
REG32(L3_TM_PLL_DIG17, 0xe044)
    FIELD(L3_TM_PLL_DIG17, TM_PLL_DIG17_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG17, TM_FB_CLK, 6, 2)
    FIELD(L3_TM_PLL_DIG17, TM_MODE_DEPTH, 3, 3)
    FIELD(L3_TM_PLL_DIG17, TM_MODE_RATE, 0, 3)
REG32(L3_TM_PLL_DIG18, 0xe048)
    FIELD(L3_TM_PLL_DIG18, TM_PLL_DIG18_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG18, TM_PLL_LOCK_PULDN, 7, 1)
    FIELD(L3_TM_PLL_DIG18, TM_STEP_SIZE_CNTRL, 5, 2)
    FIELD(L3_TM_PLL_DIG18, TM_SD_GSHIFT, 3, 2)
    FIELD(L3_TM_PLL_DIG18, TM_SD_DITHER, 1, 2)
    FIELD(L3_TM_PLL_DIG18, TM_PLL_LOCK_INT, 0, 1)
REG32(L3_TM_PLL_DIG19, 0xe04c)
    FIELD(L3_TM_PLL_DIG19, TM_PLL_DIG19_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG19, TM_FORCE_EN_CLOCK_HS_DIV_2, 7, 1)
    FIELD(L3_TM_PLL_DIG19, TM_EN_CLOCK_HS_DIV_2, 6, 1)
    FIELD(L3_TM_PLL_DIG19, TM_PLL_HS_CLOCK_1, 3, 3)
    FIELD(L3_TM_PLL_DIG19, TM_PD_PFD, 2, 1)
    FIELD(L3_TM_PLL_DIG19, TM_FORCE_PD_PFD, 1, 1)
    FIELD(L3_TM_PLL_DIG19, TM_SELECT_PCI_2P5, 0, 1)
REG32(L3_TM_PLL_DIG20, 0xe050)
    FIELD(L3_TM_PLL_DIG20, TM_PLL_DIG20_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG20, TM_PLL_HALF_FULL_RATE, 7, 1)
    FIELD(L3_TM_PLL_DIG20, TM_PLL_RSVD, 6, 1)
    FIELD(L3_TM_PLL_DIG20, TM_V2I_PROG, 1, 5)
    FIELD(L3_TM_PLL_DIG20, TM_FORCE_V2I_PROG, 0, 1)
REG32(L3_TM_PLL_DIG21, 0xe054)
    FIELD(L3_TM_PLL_DIG21, TM_PLL_DIG21_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG21, TM_FORCE_EN_PLL_LDO_0P9_REF, 7, 1)
    FIELD(L3_TM_PLL_DIG21, ANA_TM_EN_PLL_0P9_FORCE_SW, 6, 1)
    FIELD(L3_TM_PLL_DIG21, TM_PLL_PD_OPDIV_SYM, 5, 1)
    FIELD(L3_TM_PLL_DIG21, TM_FORCE_PLL_PD_OPDIV_SYM, 4, 1)
    FIELD(L3_TM_PLL_DIG21, TM_PLL_RSVD_1, 3, 1)
    FIELD(L3_TM_PLL_DIG21, TM_PLL_RSVD_2, 2, 1)
    FIELD(L3_TM_PLL_DIG21, TM_PLL_EN, 1, 1)
    FIELD(L3_TM_PLL_DIG21, TM_FORCE_PLL_EN, 0, 1)
REG32(L3_TM_PLL_DIG22, 0xe058)
    FIELD(L3_TM_PLL_DIG22, TM_PLL_DIG22_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG22, TM_PLL_RSVD, 7, 1)
    FIELD(L3_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF_CP, 6, 1)
    FIELD(L3_TM_PLL_DIG22, TM_FORCE_EN_PLL_LDO_0P9_REF_CP, 5, 1)
    FIELD(L3_TM_PLL_DIG22, TM_FORCE_COARSE_START, 4, 1)
    FIELD(L3_TM_PLL_DIG22, TM_FORCE_PD_PLL_LDO_1P4, 3, 1)
    FIELD(L3_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL_DELAYED, 2, 1)
    FIELD(L3_TM_PLL_DIG22, TM_FORCE_ANA_EN_LL, 1, 1)
    FIELD(L3_TM_PLL_DIG22, TM_EN_PLL_LDO_0P9_REF, 0, 1)
REG32(L3_TM_PLL_DIG23, 0xe05c)
    FIELD(L3_TM_PLL_DIG23, TM_PLL_DIG23_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG23, BF_7, 7, 1)
    FIELD(L3_TM_PLL_DIG23, PLL_TM_VCO_LDO_BYPASS, 6, 1)
    FIELD(L3_TM_PLL_DIG23, TM_ANA_EN_LL_DELAYED, 5, 1)
    FIELD(L3_TM_PLL_DIG23, TM_ANA_EN_LL, 4, 1)
    FIELD(L3_TM_PLL_DIG23, TM_ANA_PD_PLL, 3, 1)
    FIELD(L3_TM_PLL_DIG23, TM_FORCE_PLL_PD, 2, 1)
    FIELD(L3_TM_PLL_DIG23, TM_ANA_COARSE_START, 1, 1)
    FIELD(L3_TM_PLL_DIG23, TM_PD_PLL_LDO_1P4, 0, 1)
REG32(L3_TM_PLL_DIG24, 0xe060)
    FIELD(L3_TM_PLL_DIG24, TM_PLL_DIG24_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG24, TM_PLL_RSVD, 7, 1)
    FIELD(L3_TM_PLL_DIG24, PLL_TM_VCO_LDO, 1, 6)
    FIELD(L3_TM_PLL_DIG24, PLL_TM_VCO_LDO_BYPASS_WITH_SEQUENCE, 0, 1)
REG32(L3_TM_PLL_DIG25, 0xe064)
    FIELD(L3_TM_PLL_DIG25, TM_PLL_DIG25_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG25, TM_FORCE_RST_N_HSRIPPLE, 7, 1)
    FIELD(L3_TM_PLL_DIG25, TM_RST_N_HSRIPPLE, 6, 1)
    FIELD(L3_TM_PLL_DIG25, TM_PLL_ATB_CNTRL, 1, 5)
    FIELD(L3_TM_PLL_DIG25, TM_PLL_OBSERVE_PTAT_10U, 0, 1)
REG32(L3_TM_PLL_DIG26, 0xe068)
    FIELD(L3_TM_PLL_DIG26, TM_PLL_DIG26_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG26, TM_PLL_RSVD, 7, 1)
    FIELD(L3_TM_PLL_DIG26, TM_PD_PLL_PTAT, 6, 1)
    FIELD(L3_TM_PLL_DIG26, TM_FORCE_PD_PLL_PTAT, 5, 1)
    FIELD(L3_TM_PLL_DIG26, TM_USB3_R2_HIGH_RES_SW_ON, 4, 1)
    FIELD(L3_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIV2_LOOP_OUT, 3, 1)
    FIELD(L3_TM_PLL_DIG26, TM_PLL_SEL_VCO_DIRECT_LOOP_OUT, 2, 1)
    FIELD(L3_TM_PLL_DIG26, TM_PLL_SEL_VCO_HISPEED_DIV2_LOOP_OUT, 1, 1)
    FIELD(L3_TM_PLL_DIG26, TM_FORCE_LOOP_PATH, 0, 1)
REG32(L3_TM_PLL_CLK_DIST_NTRIM_LSB, 0xe06c)
    FIELD(L3_TM_PLL_CLK_DIST_NTRIM_LSB, TM_PLL_CLK_DIST_NTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_CLK_DIST_NTRIM_LSB, TM_CLKDIST_BIAS_NTRIM_LSB, 0, 8)
REG32(L3_TM_PLL_CLK_DIST_PTRIM_LSB, 0xe070)
    FIELD(L3_TM_PLL_CLK_DIST_PTRIM_LSB, TM_PLL_CLK_DIST_PTRIM_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_CLK_DIST_PTRIM_LSB, TM_CLKDIST_BIAS_PTRIM_LSB, 0, 8)
REG32(L3_TM_PLL_DIG_29, 0xe074)
    FIELD(L3_TM_PLL_DIG_29, TM_PLL_DIG_29_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_MRSTBUF_SUP, 7, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_CLKDIST_OBSRV_LRSTBUF_SUP, 6, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_RST_RPTR, 5, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_RST_RPTR, 4, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_CLKDIST_ENABLE_CLK_RPTR, 3, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_FORCE_CLKDIST_ENABLE_CLK_RPTR, 2, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_CLKDIST_BIAS_PTRIM_MSB, 1, 1)
    FIELD(L3_TM_PLL_DIG_29, TM_CLKDIST_BIAS_NTRIM_MSB, 0, 1)
REG32(L3_TM_PLL_DIG_30, 0xe078)
    FIELD(L3_TM_PLL_DIG_30, TM_PLL_DIG_30_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_BIAS, 7, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_BIAS, 6, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_CLKDIST_ENABLE_CMN_BIAS, 5, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_FORCE_CLKDIST_ENABLE_CMN_BIAS, 4, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_CLKDIST_SUP_OBSRV, 3, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RSTMUX_SUP, 2, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_RPTR_RSTBUF_SUP, 1, 1)
    FIELD(L3_TM_PLL_DIG_30, TM_CLKDIST_OBSRV_MUS_SUP, 0, 1)
REG32(L3_TM_PLL_DIG_31, 0xe07c)
    FIELD(L3_TM_PLL_DIG_31, TM_PLL_DIG_31_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 7, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_MASTER_CLK_DRIVE, 6, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_RST_DRIVE, 5, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_RST_DRIVE, 4, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_CLKDIST_ENABLE_LANE_CLK_DRIVE, 3, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_FORCE_CLKDIST_ENABLE_LANE_CLK_DRIVE, 2, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_CLKDIST_BIAS_RATE_SEL, 1, 1)
    FIELD(L3_TM_PLL_DIG_31, TM_FORCE_CLKDIST_BIAS_RATE_SEL, 0, 1)
REG32(L3_TM_PLL_DIG_32, 0xe080)
    FIELD(L3_TM_PLL_DIG_32, TM_PLL_DIG_32_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_32, TM_CLKDIST_MUX_XVCR_CLK_EN, 7, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_FORCE_CLKDIST_MUX_XVCR_CLK_EN, 6, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_FORCE_LOAD_FBDIV, 5, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_LOAD_FBDIV, 4, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_FORCE_RST_FDBK_DIV, 3, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_RST_FDBK_DIV, 2, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_CLKDIST_ENABLE_MASTER_RST_DRIVE, 1, 1)
    FIELD(L3_TM_PLL_DIG_32, TM_FORCE_CLKDIST_ENABLE_MASTER_RST_DRIVE, 0, 1)
REG32(L3_TM_PLL_DIG_33, 0xe084)
    FIELD(L3_TM_PLL_DIG_33, TM_PLL_DIG_33_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_33, TM_FORCE_TX_CLK_RST_REL, 7, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_TX_CLK_RST_REL, 6, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_CLKDIST_MUX_XCVR_MASTER_RST_EN, 5, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_XCVR_MASTER_RST_EN, 4, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_CLKDIST_MUX_MASTER_CLK_SEL, 3, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_MASTER_CLK_SEL, 2, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_CLKDIST_MUX_LOCAL_CLK_SEL, 1, 1)
    FIELD(L3_TM_PLL_DIG_33, TM_FORCE_CLKDIST_MUX_LOCAL_CLK_SEL, 0, 1)
REG32(L3_TM_PLL_DIG_34, 0xe088)
    FIELD(L3_TM_PLL_DIG_34, TM_PLL_DIG_34_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_34, TM_PLL_RSVD, 7, 1)
    FIELD(L3_TM_PLL_DIG_34, TM_FBDIV_3_MSB, 2, 5)
    FIELD(L3_TM_PLL_DIG_34, TM_SEL_VCO_OUT, 1, 1)
    FIELD(L3_TM_PLL_DIG_34, TM_FORCE_SEL_VCO_OUT, 0, 1)
REG32(L3_TM_PLL_DIG_35, 0xe08c)
    FIELD(L3_TM_PLL_DIG_35, TM_PLL_DIG_35_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_35, TM_CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L3_TM_PLL_DIG_35, TM_CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L3_TM_PLL_DIG_35, TM_CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L3_TM_PLL_DIG_35, TM_CLKDIST_RPTR_SPARE, 0, 2)
REG32(L3_TM_PLL_DIG_36, 0xe090)
    FIELD(L3_TM_PLL_DIG_36, TM_PLL_DIG_36_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_36, CLKDIST_BIAS_SPARE, 6, 2)
    FIELD(L3_TM_PLL_DIG_36, CLKDIST_DRVR_SPARE, 4, 2)
    FIELD(L3_TM_PLL_DIG_36, CLKDIST_MUX_SPARE, 2, 2)
    FIELD(L3_TM_PLL_DIG_36, CLKDIST_RPTR_SPARE, 0, 2)
REG32(L3_TM_PLL_DIG_37, 0xe094)
    FIELD(L3_TM_PLL_DIG_37, TM_PLL_DIG_37_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_DIG_37, TM_COARSE_CODE_SAT_VALUE_LSB, 5, 3)
    FIELD(L3_TM_PLL_DIG_37, TM_ENABLE_COARSE_SATURATION, 4, 1)
    FIELD(L3_TM_PLL_DIG_37, W_SPARE_OUTPUTS, 2, 2)
    FIELD(L3_TM_PLL_DIG_37, TM_FORCE_EN_IP_DIV_BYPASS, 1, 1)
    FIELD(L3_TM_PLL_DIG_37, TM_EN_IP_DIV_BYPASS, 0, 1)
REG32(L3_TM_PLL_COARSE_CODE_SAT_MSB, 0xe098)
    FIELD(L3_TM_PLL_COARSE_CODE_SAT_MSB, TM_PLL_COARSE_CODE_SAT_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_TM_PLL_COARSE_CODE_SAT_MSB, TM_COARSE_CODE_SAT_VALUE_MSB, 0, 8)
REG32(L3_MPHY_CFG_HIB8, 0xe300)
    FIELD(L3_MPHY_CFG_HIB8, MPHY_CFG_HIB8_31_8_RSVD, 24, 8)
    FIELD(L3_MPHY_CFG_HIB8, MPHY_HIBERN8_RSVD, 1, 7)
    FIELD(L3_MPHY_CFG_HIB8, MPHY_HIBERN8, 0, 1)
REG32(L3_MPHY_CFG_MODE, 0xe304)
    FIELD(L3_MPHY_CFG_MODE, MPHY_CFG_MODE_31_8_RSVD, 24, 8)
    FIELD(L3_MPHY_CFG_MODE, MPHY_HS_LS_MODE_RSVD, 2, 6)
    FIELD(L3_MPHY_CFG_MODE, MPHY_HS_LS_MODE, 0, 2)
REG32(L3_MPHY_CFG_HS_GEAR, 0xe308)
    FIELD(L3_MPHY_CFG_HS_GEAR, MPHY_CFG_HS_GEAR_31_8_RSVD, 24, 8)
    FIELD(L3_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR_RSVD, 2, 6)
    FIELD(L3_MPHY_CFG_HS_GEAR, MPHY_HS_GEAR, 0, 2)
REG32(L3_MPHY_CFG_HS_RATE, 0xe30c)
    FIELD(L3_MPHY_CFG_HS_RATE, MPHY_CFG_HS_RATE_31_8_RSVD, 24, 8)
    FIELD(L3_MPHY_CFG_HS_RATE, MPHY_RATE_RSVD, 1, 7)
    FIELD(L3_MPHY_CFG_HS_RATE, MPHY_RATE, 0, 1)
REG32(L3_MPHY_CFG_PWM, 0xe310)
    FIELD(L3_MPHY_CFG_PWM, MPHY_CFG_PWM_31_8_RSVD, 24, 8)
    FIELD(L3_MPHY_CFG_PWM, MPHY_PWM_GEAR_RSVD, 3, 5)
    FIELD(L3_MPHY_CFG_PWM, MPHY_PWM_GEAR, 0, 3)
REG32(L3_PLL_OPDIV_LS, 0xe314)
    FIELD(L3_PLL_OPDIV_LS, PLL_OPDIV_LS_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_OPDIV_LS, TM_SEL_OPDIV_FOR_REFCLK, 7, 1)
    FIELD(L3_PLL_OPDIV_LS, ANA_OPDIV_LS, 0, 7)
REG32(L3_MPHY_CFG_UPDT, 0xe318)
    FIELD(L3_MPHY_CFG_UPDT, MPHY_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L3_MPHY_CFG_UPDT, MPHY_CFGUPDT_RSVD, 1, 7)
    FIELD(L3_MPHY_CFG_UPDT, MPHY_CFGUPDT, 0, 1)
REG32(L3_PLL_TM_DIV_CNTRLS, 0xe31c)
    FIELD(L3_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_DIV_CNTRLS, TM_FORCE_PD_OPDIV_LS, 7, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, TM_PD_OPDIV_LS, 6, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, PLL_TM_DIV_CNTRLS_RSVD, 5, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, TM_BYPASS_OPDIV_LS_MOD, 4, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, TM_FORCE_PLL_PD_HS, 3, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, TM_PLL_PD_HS, 2, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, SEL_IP_MUX_CONTROL, 1, 1)
    FIELD(L3_PLL_TM_DIV_CNTRLS, TM_SWAP_OP_MUX_CONTROL, 0, 1)
REG32(L3_PLL_FBDIV_G1A_LSB, 0xe320)
    FIELD(L3_PLL_FBDIV_G1A_LSB, PLL_FBDIV_G1A_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G1A_LSB, FBDIV_G1A_LSB, 0, 8)
REG32(L3_PLL_FBDIV_G1B_LSB, 0xe324)
    FIELD(L3_PLL_FBDIV_G1B_LSB, PLL_FBDIV_G1B_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G1B_LSB, FBDIV_G1B_LSB, 0, 8)
REG32(L3_PLL_FBDIV_G2A_LSB, 0xe328)
    FIELD(L3_PLL_FBDIV_G2A_LSB, PLL_FBDIV_G2A_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G2A_LSB, FBDIV_G2A_LSB, 0, 8)
REG32(L3_PLL_FBDIV_G2B_LSB, 0xe32c)
    FIELD(L3_PLL_FBDIV_G2B_LSB, PLL_FBDIV_G2B_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G2B_LSB, FBDIV_G2B_LSB, 0, 8)
REG32(L3_PLL_FBDIV_G3A_LSB, 0xe330)
    FIELD(L3_PLL_FBDIV_G3A_LSB, PLL_FBDIV_G3A_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G3A_LSB, FBDIV_G3A_LSB, 0, 8)
REG32(L3_PLL_FBDIV_G3B_LSB, 0xe334)
    FIELD(L3_PLL_FBDIV_G3B_LSB, PLL_FBDIV_G3B_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G3B_LSB, FBDIV_G3B_LSB, 0, 8)
REG32(L3_PLL_FBDIV_G1A_MSB, 0xe338)
    FIELD(L3_PLL_FBDIV_G1A_MSB, PLL_FBDIV_G1A_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G1A_MSB, FBDIV_G1A_MSB, 0, 8)
REG32(L3_PLL_FBDIV_G1B_MSB, 0xe33c)
    FIELD(L3_PLL_FBDIV_G1B_MSB, PLL_FBDIV_G1B_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G1B_MSB, FBDIV_G1B_MSB, 0, 8)
REG32(L3_PLL_FBDIV_G2A_MSB, 0xe340)
    FIELD(L3_PLL_FBDIV_G2A_MSB, PLL_FBDIV_G2A_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G2A_MSB, FBDIV_G2A_MSB, 0, 8)
REG32(L3_PLL_FBDIV_G2B_MSB, 0xe344)
    FIELD(L3_PLL_FBDIV_G2B_MSB, PLL_FBDIV_G2B_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G2B_MSB, FBDIV_G2B_MSB, 0, 8)
REG32(L3_PLL_FBDIV_G3A_MSB, 0xe348)
    FIELD(L3_PLL_FBDIV_G3A_MSB, PLL_FBDIV_G3A_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G3A_MSB, FBDIV_G3A_MSB, 0, 8)
REG32(L3_PLL_FBDIV_G3B_MSB, 0xe34c)
    FIELD(L3_PLL_FBDIV_G3B_MSB, PLL_FBDIV_G3B_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_G3B_MSB, FBDIV_G3B_MSB, 0, 8)
REG32(L3_PLL_IPDIV, 0xe350)
    FIELD(L3_PLL_IPDIV, PLL_IPDIV_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_IPDIV, PLL_IPDIV, 0, 8)
REG32(L3_PLL_FBDIV_FRAC_0_LSB, 0xe354)
    FIELD(L3_PLL_FBDIV_FRAC_0_LSB, PLL_FBDIV_FRAC_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_FRAC_0_LSB, FBDIV_FRAC_0_LSB, 0, 8)
REG32(L3_PLL_FBDIV_FRAC_1, 0xe358)
    FIELD(L3_PLL_FBDIV_FRAC_1, PLL_FBDIV_FRAC_1_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_FRAC_1, FBDIV_FRAC_1, 0, 8)
REG32(L3_PLL_FBDIV_FRAC_2, 0xe35c)
    FIELD(L3_PLL_FBDIV_FRAC_2, PLL_FBDIV_FRAC_2_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_FRAC_2, FBDIV_FRAC_2, 0, 8)
REG32(L3_PLL_FBDIV_FRAC_3_MSB, 0xe360)
    FIELD(L3_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_FBDIV_FRAC_3_MSB, PLL_FBDIV_FRAC_3_MSV_RSVD, 7, 1)
    FIELD(L3_PLL_FBDIV_FRAC_3_MSB, TM_FORCE_EN_FRAC, 6, 1)
    FIELD(L3_PLL_FBDIV_FRAC_3_MSB, TM_EN_FRAC, 5, 1)
    FIELD(L3_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB_RSVD, 3, 2)
    FIELD(L3_PLL_FBDIV_FRAC_3_MSB, FBDIV_FRAC_3_MSB, 0, 3)
REG32(L3_PLL_PWR_SEQ_WAIT_TIME, 0xe364)
    FIELD(L3_PLL_PWR_SEQ_WAIT_TIME, PLL_PWR_SEQ_WAIT_TIME_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_SETTLING, 6, 2)
    FIELD(L3_PLL_PWR_SEQ_WAIT_TIME, TM_PLL_BIAS_SETTLING, 4, 2)
    FIELD(L3_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_SETTLING, 2, 2)
    FIELD(L3_PLL_PWR_SEQ_WAIT_TIME, TM_LDO_RELIABILITY, 0, 2)
REG32(L3_PLL_SS_STEPS_0_LSB, 0xe368)
    FIELD(L3_PLL_SS_STEPS_0_LSB, PLL_SS_STEPS_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_SS_STEPS_0_LSB, SS_NUM_OF_STEPS_0_LSB, 0, 8)
REG32(L3_PLL_SS_STEPS_1_MSB, 0xe36c)
    FIELD(L3_PLL_SS_STEPS_1_MSB, PLL_SS_STEPS_1_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB_RSVD, 3, 5)
    FIELD(L3_PLL_SS_STEPS_1_MSB, SS_NUM_OF_STEPS_1_MSB, 0, 3)
REG32(L3_PLL_SS_STEP_SIZE_0_LSB, 0xe370)
    FIELD(L3_PLL_SS_STEP_SIZE_0_LSB, PLL_SS_STEP_SIZE_0_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_SS_STEP_SIZE_0_LSB, SS_STEP_SIZE_0_LSB, 0, 8)
REG32(L3_PLL_SS_STEP_SIZE_1, 0xe374)
    FIELD(L3_PLL_SS_STEP_SIZE_1, PLL_SS_STEP_SIZE_1_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_SS_STEP_SIZE_1, SS_STEP_SIZE_1, 0, 8)
REG32(L3_PLL_SS_STEP_SIZE_2, 0xe378)
    FIELD(L3_PLL_SS_STEP_SIZE_2, PLL_SS_STEP_SIZE_2_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_SS_STEP_SIZE_2, SS_STEP_SIZE_2, 0, 8)
REG32(L3_PLL_SS_STEP_SIZE_3_MSB, 0xe37c)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, PLL_SS_STEP_SIZE_3_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, TM_FORCE_EN_SS, 7, 1)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, TM_EN_SS, 6, 1)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_NUM_OF_STEPS, 5, 1)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, FORCE_SS_STEP_SIZE, 4, 1)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, SS_SPREAD_TYPE, 2, 2)
    FIELD(L3_PLL_SS_STEP_SIZE_3_MSB, SS_STEP_SIZE_3_MSB, 0, 2)
REG32(L3_TM_MASK_CFG_UPDT, 0xe380)
    FIELD(L3_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_31_8_RSVD, 24, 8)
    FIELD(L3_TM_MASK_CFG_UPDT, TM_MASK_CFG_UPDT_RSVD, 7, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, HIBERN8_MASK_CFG_UPDT, 6, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, HS_MODE_MASK_CFG_UPDT, 5, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, LS_MODE_MASK_CFG_UPDT, 4, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, OPDIV_LS_MASK_CFG_UPDT, 3, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, PWM_GEAR_MASK_CFG_UPDT, 2, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, HS_GEAR_MASK_CFG_UPDT, 1, 1)
    FIELD(L3_TM_MASK_CFG_UPDT, HS_RATE_MASK_CFG_UPDT, 0, 1)
REG32(L3_PLL_TM_FORCE_DIV, 0xe384)
    FIELD(L3_PLL_TM_FORCE_DIV, PLL_TM_FORCE_DIV_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_FRAC, 7, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3B, 6, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G3A, 5, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2B, 4, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G2A, 3, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1B, 2, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_FBDIV_G1A, 1, 1)
    FIELD(L3_PLL_TM_FORCE_DIV, TM_FORCE_IPDIV, 0, 1)
REG32(L3_PLL_TM_COARSE_CODE_1_LSB, 0xe388)
    FIELD(L3_PLL_TM_COARSE_CODE_1_LSB, PLL_TM_COARSE_CODE_1_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_1_LSB, TM_COARSE_CODE_1_LSB, 0, 8)
REG32(L3_PLL_TM_COARSE_CODE_2_LSB, 0xe38c)
    FIELD(L3_PLL_TM_COARSE_CODE_2_LSB, PLL_TM_COARSE_CODE_2_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_2_LSB, TM_COARSE_CODE_2_LSB, 0, 8)
REG32(L3_PLL_TM_COARSE_CODE_3_LSB, 0xe390)
    FIELD(L3_PLL_TM_COARSE_CODE_3_LSB, PLL_TM_COARSE_CODE_3_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_3_LSB, TM_COARSE_CODE_3_LSB, 0, 8)
REG32(L3_PLL_TM_COARSE_CODE_4_LSB, 0xe394)
    FIELD(L3_PLL_TM_COARSE_CODE_4_LSB, PLL_TM_COARSE_CODE_4_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_4_LSB, TM_COARSE_CODE_4_LSB, 0, 8)
REG32(L3_PLL_TM_COARSE_CODE_5_LSB, 0xe398)
    FIELD(L3_PLL_TM_COARSE_CODE_5_LSB, PLL_TM_COARSE_CODE_5_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_5_LSB, TM_COARSE_CODE_5_LSB, 0, 8)
REG32(L3_PLL_TM_COARSE_CODE_6_LSB, 0xe39c)
    FIELD(L3_PLL_TM_COARSE_CODE_6_LSB, PLL_TM_COARSE_CODE_6_LSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_6_LSB, TM_COARSE_CODE_6_LSB, 0, 8)
REG32(L3_PLL_TM_COARSE_CODE_1_2_MSB, 0xe3a0)
    FIELD(L3_PLL_TM_COARSE_CODE_1_2_MSB, PLL_TM_COARSE_CODE_1_2_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_G1_AB_MSB_RSVD, 6, 2)
    FIELD(L3_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_2_MSB, 3, 3)
    FIELD(L3_PLL_TM_COARSE_CODE_1_2_MSB, TM_COARSE_CODE_1_MSB, 0, 3)
REG32(L3_PLL_TM_COARSE_CODE_3_4_MSB, 0xe3a4)
    FIELD(L3_PLL_TM_COARSE_CODE_3_4_MSB, PLL_TM_COARSE_CODE_3_4_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_G2_AB_MSB_RSVD, 6, 2)
    FIELD(L3_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_4_MSB, 3, 3)
    FIELD(L3_PLL_TM_COARSE_CODE_3_4_MSB, TM_COARSE_CODE_3_MSB, 0, 3)
REG32(L3_PLL_TM_COARSE_CODE_5_6_MSB, 0xe3a8)
    FIELD(L3_PLL_TM_COARSE_CODE_5_6_MSB, PLL_TM_COARSE_CODE_5_6_MSB_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_G3_AB_MSB_RSVD, 6, 2)
    FIELD(L3_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_6_MSB, 3, 3)
    FIELD(L3_PLL_TM_COARSE_CODE_5_6_MSB, TM_COARSE_CODE_5_MSB, 0, 3)
REG32(L3_PLL_TM_SHARED_0, 0xe3ac)
    FIELD(L3_PLL_TM_SHARED_0, PLL_TM_SHARED_0_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_SHARED_0, TM_FORCE_EXTSIGNAL_FOR_HIBERN8, 7, 1)
    FIELD(L3_PLL_TM_SHARED_0, TM_FORCE_REGBIT_FOR_HIBERN8, 6, 1)
    FIELD(L3_PLL_TM_SHARED_0, TM_FORCE_PLL_STANDBY, 5, 1)
    FIELD(L3_PLL_TM_SHARED_0, TM_PLL_STANDBY, 4, 1)
    FIELD(L3_PLL_TM_SHARED_0, TM_SLOWN_FAST_BRING_UP_ALWAYS, 3, 1)
    FIELD(L3_PLL_TM_SHARED_0, EN_TM_FOR_BRING_UP_SCHEME, 2, 1)
    FIELD(L3_PLL_TM_SHARED_0, SELECT_HS_FB_DIVIDER, 1, 1)
    FIELD(L3_PLL_TM_SHARED_0, TM_BYPASS_COARSE_SEARCH, 0, 1)
REG32(L3_PLL_TM_FRAC_OFFSET_0, 0xe3b0)
    FIELD(L3_PLL_TM_FRAC_OFFSET_0, PLL_TM_FRAC_OFFSET_0_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_FRAC_OFFSET_0, TM_FRAC_OFFSET_LSB_0, 0, 8)
REG32(L3_PLL_TM_FRAC_OFFSET_1, 0xe3b4)
    FIELD(L3_PLL_TM_FRAC_OFFSET_1, PLL_TM_FRAC_OFFSET_1_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_FRAC_OFFSET_1, TM_FRAC_OFFSET_1, 0, 8)
REG32(L3_PLL_TM_FRAC_OFFSET_2, 0xe3b8)
    FIELD(L3_PLL_TM_FRAC_OFFSET_2, PLL_TM_FRAC_OFFSET_2_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_TM_FRAC_OFFSET_2, TM_PLL_RSVD, 2, 6)
    FIELD(L3_PLL_TM_FRAC_OFFSET_2, TM_FORCE_FBDIV_FRAC_OFFSET, 1, 1)
    FIELD(L3_PLL_TM_FRAC_OFFSET_2, TM_FRAC_OFFSET_MSB_2, 0, 1)
REG32(L3_PLL_STATUS_READ_0, 0xe3e0)
    FIELD(L3_PLL_STATUS_READ_0, PLL_STATUS_READ_0_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_STATUS_READ_0, PLL_COARSE_CODE_LSB_STATUS_READ, 0, 8)
REG32(L3_PLL_STATUS_READ_1, 0xe3e4)
    FIELD(L3_PLL_STATUS_READ_1, PLL_STATUS_READ_1_31_8_RSVD, 24, 8)
    FIELD(L3_PLL_STATUS_READ_1, PLL_STATUS_READ_1_RSVD, 6, 2)
    FIELD(L3_PLL_STATUS_READ_1, PLL_START_LOOP_STATUS_READ, 5, 1)
    FIELD(L3_PLL_STATUS_READ_1, PLL_LOCK_STATUS_READ, 4, 1)
    FIELD(L3_PLL_STATUS_READ_1, PLL_COARSE_DONE_STATUS_READ, 3, 1)
    FIELD(L3_PLL_STATUS_READ_1, PLL_COARSE_CODE_MSB_STATUS_READ, 0, 3)
REG32(L3_TM_CALIB_DIG0, 0xec00)
    FIELD(L3_TM_CALIB_DIG0, TM_CALIB_DIG0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG0, TM_CALIB_DIG0_7_6_RSVD, 6, 2)
    FIELD(L3_TM_CALIB_DIG0, ICONST_CNTRL, 5, 1)
    FIELD(L3_TM_CALIB_DIG0, ICONST_BYP, 4, 1)
    FIELD(L3_TM_CALIB_DIG0, CALIB_RSTN_CNTRL, 2, 2)
    FIELD(L3_TM_CALIB_DIG0, TM_CALIB_DIG0_0_1_RSVD, 0, 2)
REG32(L3_TM_CALIB_DIG1, 0xec04)
    FIELD(L3_TM_CALIB_DIG1, TM_CALIB_DIG1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG1, TM_CALIB_DIG1_4_7_RSVD, 4, 4)
    FIELD(L3_TM_CALIB_DIG1, FORCE_CALIB_EN_LL, 3, 1)
    FIELD(L3_TM_CALIB_DIG1, TM_CALIB_DIG1_1_2_RSVD, 1, 2)
    FIELD(L3_TM_CALIB_DIG1, CALIB_EN_LL_CNTRL, 0, 1)
REG32(L3_TM_CALIB_DIG2, 0xec08)
    FIELD(L3_TM_CALIB_DIG2, TM_CALIB_DIG2_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG2, CALIB_ICONST0, 0, 8)
REG32(L3_TM_CALIB_DIG3, 0xec0c)
    FIELD(L3_TM_CALIB_DIG3, TM_CALIB_DIG3_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG3, CALIB_ICONST1, 0, 8)
REG32(L3_TM_CALIB_DIG4, 0xec10)
    FIELD(L3_TM_CALIB_DIG4, TM_CALIB_DIG4_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG4, CALIB_ICONST2, 0, 8)
REG32(L3_TM_CALIB_DIG5, 0xec14)
    FIELD(L3_TM_CALIB_DIG5, TM_CALIB_DIG5_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG5, CALIB_ICONST3, 0, 8)
REG32(L3_TM_CALIB_DIG6, 0xec18)
    FIELD(L3_TM_CALIB_DIG6, TM_CALIB_DIG6_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG6, CALIB_ICONST4, 0, 8)
REG32(L3_TM_CALIB_DIG7, 0xec1c)
    FIELD(L3_TM_CALIB_DIG7, TM_CALIB_DIG7_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG7, CALIB_ICONST5, 0, 8)
REG32(L3_TM_CALIB_DIG8, 0xec20)
    FIELD(L3_TM_CALIB_DIG8, TM_CALIB_DIG8_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG8, CALIB_ICONST6, 0, 8)
REG32(L3_TM_CALIB_DIG9, 0xec24)
    FIELD(L3_TM_CALIB_DIG9, TM_CALIB_DIG9_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG9, CALIB_ICONST7, 0, 8)
REG32(L3_TM_CALIB_DIG10, 0xec28)
    FIELD(L3_TM_CALIB_DIG10, TM_CALIB_DIG10_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG10, CALIB_ICONST8, 0, 8)
REG32(L3_TM_CALIB_DIG11, 0xec2c)
    FIELD(L3_TM_CALIB_DIG11, TM_CALIB_DIG11_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG11, CALIB_ICONST9, 0, 8)
REG32(L3_TM_CALIB_DIG12, 0xec30)
    FIELD(L3_TM_CALIB_DIG12, TM_CALIB_DIG12_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG12, CALIB_ICONST10_7_RSVD, 7, 1)
    FIELD(L3_TM_CALIB_DIG12, CALIB_ICONST_10, 0, 7)
REG32(L3_TM_CALIB_DIG13, 0xec34)
    FIELD(L3_TM_CALIB_DIG13, TM_CALIB_DIG13_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG13, TM_CALIB_DIG13_6_7_RSVD, 6, 2)
    FIELD(L3_TM_CALIB_DIG13, TM_OR_FP_ICAL_CODE, 5, 1)
    FIELD(L3_TM_CALIB_DIG13, FP_ICAL_CODE_OR, 0, 5)
REG32(L3_TM_CALIB_DIG14, 0xec38)
    FIELD(L3_TM_CALIB_DIG14, TM_CALIB_DIG14_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG14, ICAL_CODE_OR_0, 7, 1)
    FIELD(L3_TM_CALIB_DIG14, TM_OR_ICAL_CODE, 6, 1)
    FIELD(L3_TM_CALIB_DIG14, FORCE_EN_ICAL, 5, 1)
    FIELD(L3_TM_CALIB_DIG14, TM_OR_EN_ICAL, 4, 1)
    FIELD(L3_TM_CALIB_DIG14, FORCE_EN_CALIB, 3, 1)
    FIELD(L3_TM_CALIB_DIG14, TM_OR_EN_CALIB, 2, 1)
    FIELD(L3_TM_CALIB_DIG14, FORCE_CALIB_DONE, 1, 1)
    FIELD(L3_TM_CALIB_DIG14, TM_OR_CALIB_DONE, 0, 1)
REG32(L3_TM_CALIB_DIG15, 0xec3c)
    FIELD(L3_TM_CALIB_DIG15, TM_CALIB_DIG15_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG15, RX_CODE_OR_0, 7, 1)
    FIELD(L3_TM_CALIB_DIG15, TM_OR_RX_CODE, 6, 1)
    FIELD(L3_TM_CALIB_DIG15, FORCE_EN_RX, 5, 1)
    FIELD(L3_TM_CALIB_DIG15, TM_OR_EN_RX, 4, 1)
    FIELD(L3_TM_CALIB_DIG15, ICAL_CODE_OR_4, 3, 1)
    FIELD(L3_TM_CALIB_DIG15, ICAL_CODE_OR_3, 2, 1)
    FIELD(L3_TM_CALIB_DIG15, ICAL_CODE_OR_2, 1, 1)
    FIELD(L3_TM_CALIB_DIG15, ICAL_CODE_OR_1, 0, 1)
REG32(L3_TM_CALIB_DIG16, 0xec40)
    FIELD(L3_TM_CALIB_DIG16, TM_CALIB_DIG16_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG16, MPHY_CODE_OR_1, 7, 1)
    FIELD(L3_TM_CALIB_DIG16, MPHY_CODE_OR_0, 6, 1)
    FIELD(L3_TM_CALIB_DIG16, TM_OR_MPHY_CODE, 5, 1)
    FIELD(L3_TM_CALIB_DIG16, FORCE_EN_MPHY, 4, 1)
    FIELD(L3_TM_CALIB_DIG16, TM_OR_EN_MPHY, 3, 1)
    FIELD(L3_TM_CALIB_DIG16, RX_CODE_OR_3, 2, 1)
    FIELD(L3_TM_CALIB_DIG16, RX_CODE_OR_2, 1, 1)
    FIELD(L3_TM_CALIB_DIG16, RX_CODE_OR_1, 0, 1)
REG32(L3_TM_CALIB_DIG17, 0xec44)
    FIELD(L3_TM_CALIB_DIG17, TM_CALIB_DIG17_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG17, USB2_CODE_OR_2, 7, 1)
    FIELD(L3_TM_CALIB_DIG17, USB2_CODE_OR_1, 6, 1)
    FIELD(L3_TM_CALIB_DIG17, USB2_CODE_OR_0, 5, 1)
    FIELD(L3_TM_CALIB_DIG17, TM_OR_USB2_CODE, 4, 1)
    FIELD(L3_TM_CALIB_DIG17, FORCE_EN_USB2, 3, 1)
    FIELD(L3_TM_CALIB_DIG17, TM_OR_EN_USB2, 2, 1)
    FIELD(L3_TM_CALIB_DIG17, MPHY_CODE_OR_3, 1, 1)
    FIELD(L3_TM_CALIB_DIG17, MPHY_CODE_OR_2, 0, 1)
REG32(L3_TM_CALIB_DIG18, 0xec48)
    FIELD(L3_TM_CALIB_DIG18, TM_CALIB_DIG18_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG18, PIPE_NSW_CODE_OR_2, 7, 1)
    FIELD(L3_TM_CALIB_DIG18, PIPE_NSW_CODE_OR_1, 6, 1)
    FIELD(L3_TM_CALIB_DIG18, PIPE_NSW_CODE_OR_0, 5, 1)
    FIELD(L3_TM_CALIB_DIG18, TM_OR_PIPE_NSW_CODE, 4, 1)
    FIELD(L3_TM_CALIB_DIG18, FORCE_EN_PIPE_NSW, 3, 1)
    FIELD(L3_TM_CALIB_DIG18, TM_OR_EN_PIPE_NSW, 2, 1)
    FIELD(L3_TM_CALIB_DIG18, USB2_CODE_OR_4, 1, 1)
    FIELD(L3_TM_CALIB_DIG18, USB2_CODE_OR_3, 0, 1)
REG32(L3_TM_CALIB_DIG19, 0xec4c)
    FIELD(L3_TM_CALIB_DIG19, TM_CALIB_DIG19_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG19, PIPE_PSW_CODE_OR_1, 7, 1)
    FIELD(L3_TM_CALIB_DIG19, PIPE_PSW_CODE_OR_0, 6, 1)
    FIELD(L3_TM_CALIB_DIG19, TM_OR_PIPE_PSW_CODE, 5, 1)
    FIELD(L3_TM_CALIB_DIG19, FORCE_EN_PIPE_PSW, 4, 1)
    FIELD(L3_TM_CALIB_DIG19, TM_OR_EN_PIPE_PSW, 3, 1)
    FIELD(L3_TM_CALIB_DIG19, PIPE_NSW_CODE_OR_5, 2, 1)
    FIELD(L3_TM_CALIB_DIG19, PIPE_NSW_CODE_OR_4, 1, 1)
    FIELD(L3_TM_CALIB_DIG19, PIPE_NSW_CODE_OR_3, 0, 1)
REG32(L3_TM_CALIB_DIG20, 0xec50)
    FIELD(L3_TM_CALIB_DIG20, TM_CALIB_DIG20_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG20, CALIB_MODE, 6, 2)
    FIELD(L3_TM_CALIB_DIG20, PIPE_PSW_CODE_OR_5, 3, 1)
    FIELD(L3_TM_CALIB_DIG20, PIPE_PSW_CODE_OR_4, 2, 1)
    FIELD(L3_TM_CALIB_DIG20, PIPE_PSW_CODE_OR_3, 1, 1)
    FIELD(L3_TM_CALIB_DIG20, PIPE_PSW_CODE_OR_2, 0, 1)
REG32(L3_TM_CALIB_DIG21, 0xec54)
    FIELD(L3_TM_CALIB_DIG21, TM_CALIB_DIG21_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG21, TM_CALIB_ANA, 3, 5)
    FIELD(L3_TM_CALIB_DIG21, TM_CALIB_DIG22_2_RSVD, 2, 1)
    FIELD(L3_TM_CALIB_DIG21, FORCE_ICALIB_DONE, 1, 1)
    FIELD(L3_TM_CALIB_DIG21, TM_OR_ICALIB_DONE, 0, 1)
REG32(L3_TM_CALIB_DIG22, 0xec58)
    FIELD(L3_TM_CALIB_DIG22, TM_CALIB_DIG22_31_8_RSVD, 24, 8)
    FIELD(L3_TM_CALIB_DIG22, TM_CALIB_DIG22_5_7_RSVD, 7, 1)
    FIELD(L3_TM_CALIB_DIG22, EN_FP_ICAL, 6, 1)
    FIELD(L3_TM_CALIB_DIG22, BYPASS_FP_ICAL, 5, 1)
    FIELD(L3_TM_CALIB_DIG22, TM_CALIB_OBSRV_INTNODES, 0, 5)
REG32(L3_TM_SLICER2_CTRL, 0xec5c)
    FIELD(L3_TM_SLICER2_CTRL, TM_SLICER2_CTRL_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_CONTROL_7_RSVD, 7, 1)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_SELPLLOUT_TESTOUT, 6, 1)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_SELDIGOUT_TESTOUT, 5, 1)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_OBSERVE_SUP, 4, 1)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_OBSERVE_DIGSUP, 3, 1)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_OBSERVE_DIFSUP, 2, 1)
    FIELD(L3_TM_SLICER2_CTRL, SLICER2_TM_ENABLE_SINGLE_ENDED, 1, 1)
    FIELD(L3_TM_SLICER2_CTRL, REFCLKN23_TM_OBSERVE_SUP, 0, 1)
REG32(L3_TM_SLICER23_BIAS_PROG0, 0xec60)
    FIELD(L3_TM_SLICER23_BIAS_PROG0, TM_SLICER23_BIAS_PROG0_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SLICER23_BIAS_PROG0, SLICER23_TM_BIAS_PROG0, 0, 8)
REG32(L3_TM_SLICER23_BIAS_PROG1, 0xec64)
    FIELD(L3_TM_SLICER23_BIAS_PROG1, TM_SLICER23_BIAS_PROG1_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SLICER23_BIAS_PROG1, SLICER23_TM_BIAS_PROG1_4_7_RSVD, 4, 4)
    FIELD(L3_TM_SLICER23_BIAS_PROG1, SLICER23_TM_BIAS_PROG1, 0, 4)
REG32(L3_TM_SLICER3_CTRL, 0xec68)
    FIELD(L3_TM_SLICER3_CTRL, TM_SLICER3_CTRL_31_8_RSVD, 24, 8)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_CONTROL1_7_RSVD, 7, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_SELPLLOUT_TESTOUT, 6, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_SELDIGOUT_TESTOUT, 5, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_OBSERVE_SUP, 4, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_OBSERVE_DIGSUP, 3, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_OBSERVE_DIFSUP, 2, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_ENABLE_SINGLE_ENDED, 1, 1)
    FIELD(L3_TM_SLICER3_CTRL, SLICER3_TM_CONTROL1_0_RSVD, 0, 1)
REG32(L3_CAL_SLICER_SPARE, 0xeca0)
    FIELD(L3_CAL_SLICER_SPARE, CAL_SLICER_SPARE_31_8_RSVD, 24, 8)
    FIELD(L3_CAL_SLICER_SPARE, CAL_SLICER_SPARE_RESERVED, 6, 2)
    FIELD(L3_CAL_SLICER_SPARE, SLICER3_DA_SPARE, 4, 2)
    FIELD(L3_CAL_SLICER_SPARE, SLICER2_DA_SPARE, 2, 2)
    FIELD(L3_CAL_SLICER_SPARE, CAL_DA_SPARE, 0, 2)
REG32(L3_SLICER2_ENABLE, 0xef00)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE_31_8_RSVD, 24, 8)
    FIELD(L3_SLICER2_ENABLE, REFCLK23_SUP_EN, 7, 1)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE_TERM, 6, 1)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE_TC_CNTRL, 4, 2)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE_DIVIDER_4TEST, 3, 1)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE_CLK_OUT, 2, 1)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE_BGBIAS, 1, 1)
    FIELD(L3_SLICER2_ENABLE, SLICER2_ENABLE, 0, 1)
REG32(L3_SLICER3_ENABLE, 0xef04)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE_31_8_RSVD, 24, 8)
    FIELD(L3_SLICER3_ENABLE, SLICER23_PD_BIAS, 7, 1)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE_TERM, 6, 1)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE_TC_CNTRL, 4, 2)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE_DIVIDER_4TEST, 3, 1)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE_CLK_OUT, 2, 1)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE_BGBIAS, 1, 1)
    FIELD(L3_SLICER3_ENABLE, SLICER3_ENABLE, 0, 1)
REG32(L3_SLICER2_BYPASS, 0xef08)
    FIELD(L3_SLICER2_BYPASS, SLICER2_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L3_SLICER2_BYPASS, SLICER2_BYPASS_7_RSVD, 7, 1)
    FIELD(L3_SLICER2_BYPASS, SLICER2_ENABLE_TERM_BYPASS, 6, 1)
    FIELD(L3_SLICER2_BYPASS, SLICER2_ENABLE_TC_CNTRL_BYPASS, 5, 1)
    FIELD(L3_SLICER2_BYPASS, SLICER2_ENABLE_CLK_OUT_BYPASS, 2, 1)
    FIELD(L3_SLICER2_BYPASS, SLICER2_ENABLE_BGBIAS_BYPASS, 1, 1)
    FIELD(L3_SLICER2_BYPASS, SLICER2_ENABLE_BYPASS, 0, 1)
REG32(L3_SLICER3_BYPASS, 0xef0c)
    FIELD(L3_SLICER3_BYPASS, SLICER3_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L3_SLICER3_BYPASS, SLICER23_PD_BIAS_BYPASS, 7, 1)
    FIELD(L3_SLICER3_BYPASS, SLICER3_ENABLE_TERM_BYPASS, 6, 1)
    FIELD(L3_SLICER3_BYPASS, SLICER3_ENABLE_TC_CNTRL_BYPASS, 5, 1)
    FIELD(L3_SLICER3_BYPASS, SLICER3_ENABLE_CLK_OUT_BYPASS, 2, 1)
    FIELD(L3_SLICER3_BYPASS, SLICER3_ENABLE_BGBIAS_BYPASS, 1, 1)
    FIELD(L3_SLICER3_BYPASS, SLICER3_ENABLE_BYPASS, 0, 1)
REG32(L3_TM_BRINGUP_CONTROL, 0xef10)
    FIELD(L3_TM_BRINGUP_CONTROL, TM_BRINGUP_CONTROL_31_8_RSVD, 24, 8)
    FIELD(L3_TM_BRINGUP_CONTROL, TM_BRING_UP_CONTROL_2_7_RSVD, 2, 6)
    FIELD(L3_TM_BRINGUP_CONTROL, TM_SLOW_FAST_BRING_UP_ALWAYS, 1, 1)
    FIELD(L3_TM_BRINGUP_CONTROL, TM_BRING_UP_CONTROL_1_RSVD, 0, 1)
REG32(L3_CALIB_DONE_STATUS, 0xef14)
    FIELD(L3_CALIB_DONE_STATUS, CALIB_DONE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_DONE_STATUS, CALIB_DONE_STATUS_2_7_RSVD, 2, 6)
    FIELD(L3_CALIB_DONE_STATUS, CALIB_DONE_STATUS, 1, 1)
    FIELD(L3_CALIB_DONE_STATUS, CALIB_COMP_OUT_STATUS, 0, 1)
REG32(L3_CALIB_PIPE_PSW_CODE_STATUS, 0xef18)
    FIELD(L3_CALIB_PIPE_PSW_CODE_STATUS, CALIB_PIPE_PSW_CODE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_PIPE_PSW_CODE_STATUS, CALIB_PIPE_PSW_CODE_STATUS_6_7_RSVD, 6, 2)
    FIELD(L3_CALIB_PIPE_PSW_CODE_STATUS, PIPE_PSW_CALIB_CODE_STATUS, 0, 6)
REG32(L3_CALIB_PIPE_NSW_CODE_STATUS, 0xef1c)
    FIELD(L3_CALIB_PIPE_NSW_CODE_STATUS, CALIB_PIPE_NSW_CODE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_PIPE_NSW_CODE_STATUS, CALIB_PIPE_PSW_CODE_STATUS_6_7_RSVD, 6, 2)
    FIELD(L3_CALIB_PIPE_NSW_CODE_STATUS, PIPE_NSW_CALIB_CODE_STATUS, 0, 6)
REG32(L3_CALIB_MPHY_TX_CODE_STATUS, 0xef20)
    FIELD(L3_CALIB_MPHY_TX_CODE_STATUS, CALIB_MPHY_TX_CODE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_MPHY_TX_CODE_STATUS, CALIB_MPHY_TX_CODE_STATUS_4_7_RSVD, 4, 4)
    FIELD(L3_CALIB_MPHY_TX_CODE_STATUS, MPHY_TX_CALIB_CODE_STATUS, 0, 4)
REG32(L3_CALIB_ICAL_CODE_STATUS, 0xef24)
    FIELD(L3_CALIB_ICAL_CODE_STATUS, CALIB_ICAL_CODE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_ICAL_CODE_STATUS, I_CALIB_CODE_STATUS_5_7_RSVD, 5, 3)
    FIELD(L3_CALIB_ICAL_CODE_STATUS, I_CALIB_CODE_STATUS, 0, 5)
REG32(L3_CALIB_RX_CODE_STATUS, 0xef28)
    FIELD(L3_CALIB_RX_CODE_STATUS, CALIB_RX_CODE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_RX_CODE_STATUS, CALIB_RX_CODE_STATUS_4_7_RSVD, 4, 4)
    FIELD(L3_CALIB_RX_CODE_STATUS, I_CALIB_CODE_STATUS, 0, 4)
REG32(L3_CALIB_USB2_TX_CODE_STATUS, 0xef2c)
    FIELD(L3_CALIB_USB2_TX_CODE_STATUS, CALIB_USB2_TX_CODE_STATUS_31_8_RSVD, 24, 8)
    FIELD(L3_CALIB_USB2_TX_CODE_STATUS, USB2_TX_CALIB_CODE_STATUS_5_7_RSVD, 5, 3)
    FIELD(L3_CALIB_USB2_TX_CODE_STATUS, USB2_TX_CALIB_CODE_STATUS, 0, 5)
REG32(L3_CAL_ISO_CTRL, 0xef30)
    FIELD(L3_CAL_ISO_CTRL, CAL_ISO_CTRL_31_8_RSVD, 24, 8)
    FIELD(L3_CAL_ISO_CTRL, CAL_SIO_CONTROL_RSVD, 2, 6)
    FIELD(L3_CAL_ISO_CTRL, CAL_ISO_CTRL_BAR, 1, 1)
    FIELD(L3_CAL_ISO_CTRL, FORCE_CAL_ISO_CTRL_BAR, 0, 1)
REG32(L3_UPHY_GLOBAL_CTRL, 0xf000)
    FIELD(L3_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_31_8_RSVD, 24, 8)
    FIELD(L3_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_7_RSVD, 7, 1)
    FIELD(L3_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_6_RSVD, 6, 1)
    FIELD(L3_UPHY_GLOBAL_CTRL, UPHY_GLOBAL_CTRL_5_RSVD, 5, 1)
    FIELD(L3_UPHY_GLOBAL_CTRL, PCLK_SELECT, 4, 1)
    FIELD(L3_UPHY_GLOBAL_CTRL, MPHY_G3_BIST_ENABLE, 3, 1)
    FIELD(L3_UPHY_GLOBAL_CTRL, MULTI_RATE_ENABLE, 2, 1)
    FIELD(L3_UPHY_GLOBAL_CTRL, MPHY_GEAR_SELECT, 0, 2)
REG32(L3_BIST_CTRL_1, 0xf004)
    FIELD(L3_BIST_CTRL_1, BIST_CTRL_1_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_CTRL_1, REPETITIVE_PATTERN_ENABLE, 7, 1)
    FIELD(L3_BIST_CTRL_1, PRBS_PATTERNS, 5, 2)
    FIELD(L3_BIST_CTRL_1, BIST_PATTERN_SELECT, 2, 3)
    FIELD(L3_BIST_CTRL_1, BIST_INFINITE_MODE_ENABLE, 1, 1)
    FIELD(L3_BIST_CTRL_1, BIST_ENABLE, 0, 1)
REG32(L3_BIST_CTRL_2, 0xf008)
    FIELD(L3_BIST_CTRL_2, BIST_CTRL_2_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_CTRL_2, BIST_CTRL_2_7_3_RSVD, 3, 5)
    FIELD(L3_BIST_CTRL_2, BIST_TRAINIG_SEQUENCE_SELECT, 1, 2)
    FIELD(L3_BIST_CTRL_2, BIST_ERROR_INJECTION_ENABLE, 0, 1)
REG32(L3_BIST_RUN_LEN_L, 0xf00c)
    FIELD(L3_BIST_RUN_LEN_L, BIST_RUN_LEN_L_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_RUN_LEN_L, BIST_RUN_LEN_L, 0, 8)
REG32(L3_BIST_ERR_INJ_POINT_L, 0xf010)
    FIELD(L3_BIST_ERR_INJ_POINT_L, BIST_ERR_INJ_POINT_L_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_ERR_INJ_POINT_L, BIST_ERROR_INJ_POINT_L, 0, 8)
REG32(L3_BIST_RUNLEN_ERR_INJ_H, 0xf014)
    FIELD(L3_BIST_RUNLEN_ERR_INJ_H, BIST_RUNLEN_ERR_INJ_H_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_RUNLEN_ERR_INJ_H, BIST_RUN_LEN_H, 4, 4)
    FIELD(L3_BIST_RUNLEN_ERR_INJ_H, BIST_ERROR_INJ_POINT_H, 0, 4)
REG32(L3_BIST_IDLE_TIME, 0xf018)
    FIELD(L3_BIST_IDLE_TIME, BIST_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_IDLE_TIME, BIST_IDLE_TIME, 0, 8)
REG32(L3_BIST_MARKER_L, 0xf01c)
    FIELD(L3_BIST_MARKER_L, BIST_MARKER_L_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_MARKER_L, BIST_MARKER_L, 0, 8)
REG32(L3_BIST_IDLE_CHAR_L, 0xf020)
    FIELD(L3_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_IDLE_CHAR_L, BIST_IDLE_CHAR_L, 0, 8)
REG32(L3_BIST_MARKER_IDLE_H, 0xf024)
    FIELD(L3_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_H_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_7, 6, 2)
    FIELD(L3_BIST_MARKER_IDLE_H, BIST_MARKER_H, 4, 2)
    FIELD(L3_BIST_MARKER_IDLE_H, BIST_MARKER_IDLE_RESERVED_3, 2, 2)
    FIELD(L3_BIST_MARKER_IDLE_H, BIST_IDLE_CHAR_H, 0, 2)
REG32(L3_BIST_LOW_PULSE_TIME, 0xf028)
    FIELD(L3_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_LOW_PULSE_TIME, BIST_LOW_PULSE_TIME, 0, 8)
REG32(L3_BIST_TOTAL_PULSE_TIME, 0xf02c)
    FIELD(L3_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_TOTAL_PULSE_TIME, BIST_TOTAL_PULSE_TIME, 0, 8)
REG32(L3_BIST_TEST_PAT_1, 0xf030)
    FIELD(L3_BIST_TEST_PAT_1, BIST_TEST_PAT_1_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_TEST_PAT_1, BIST_TEST_PAT_1_L, 0, 8)
REG32(L3_BIST_TEST_PAT_2, 0xf034)
    FIELD(L3_BIST_TEST_PAT_2, BIST_TEST_PAT_2_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_TEST_PAT_2, BIST_TEST_PAT_2_L, 0, 8)
REG32(L3_BIST_TEST_PAT_3, 0xf038)
    FIELD(L3_BIST_TEST_PAT_3, BIST_TEST_PAT_3_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_TEST_PAT_3, BIST_TEST_PAT_3_L, 0, 8)
REG32(L3_BIST_TEST_PAT_4, 0xf03c)
    FIELD(L3_BIST_TEST_PAT_4, BIST_TEST_PAT_4_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_TEST_PAT_4, BIST_TEST_PAT_4_L, 0, 8)
REG32(L3_BIST_TEST_PAT_MSBS, 0xf040)
    FIELD(L3_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_MSBS_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_4_H, 6, 2)
    FIELD(L3_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_3_H, 4, 2)
    FIELD(L3_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_2_H, 2, 2)
    FIELD(L3_BIST_TEST_PAT_MSBS, BIST_TEST_PAT_1_H, 0, 2)
REG32(L3_BIST_PKT_NUM, 0xf044)
    FIELD(L3_BIST_PKT_NUM, BIST_PKT_NUM_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_PKT_NUM, BIST_PKT_NUM, 0, 8)
REG32(L3_BIST_FRM_IDLE_TIME, 0xf048)
    FIELD(L3_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_FRM_IDLE_TIME, BIST_FRM_IDLE_TIME, 0, 8)
REG32(L3_BIST_PKT_CTR_L, 0xf04c)
    FIELD(L3_BIST_PKT_CTR_L, BIST_PKT_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_PKT_CTR_L, BIST_PKT_CTR_L, 0, 8)
REG32(L3_BIST_PKT_CTR_H, 0xf050)
    FIELD(L3_BIST_PKT_CTR_H, BIST_PKT_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_PKT_CTR_H, BIST_PKT_CTR_H, 0, 8)
REG32(L3_BIST_ERR_CTR_L, 0xf054)
    FIELD(L3_BIST_ERR_CTR_L, BIST_ERR_CTR_L_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_ERR_CTR_L, BIST_ERR_CTR_L, 0, 8)
REG32(L3_BIST_ERR_CTR_H, 0xf058)
    FIELD(L3_BIST_ERR_CTR_H, BIST_ERR_CTR_H_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_ERR_CTR_H, BIST_ERR_CTR_H, 0, 8)
REG32(L3_CLK_DIV_CNT, 0xf05c)
    FIELD(L3_CLK_DIV_CNT, CLK_DIV_CNT_31_8_RSVD, 24, 8)
    FIELD(L3_CLK_DIV_CNT, REF_CLK_BYPASS_GT_50MHZ, 7, 1)
    FIELD(L3_CLK_DIV_CNT, SLOW_CNT_REG, 0, 7)
REG32(L3_DATA_BUS_WID, 0xf060)
    FIELD(L3_DATA_BUS_WID, DATA_BUS_WID_31_8_RSVD, 24, 8)
    FIELD(L3_DATA_BUS_WID, RATE_CHANGE_BYPASS, 7, 1)
    FIELD(L3_DATA_BUS_WID, PCLK_RATIO_BY_4, 6, 1)
    FIELD(L3_DATA_BUS_WID, PCLK_RATIO_BY_2, 5, 1)
    FIELD(L3_DATA_BUS_WID, RATE_CHANGE_DELAY_SEL, 4, 1)
    FIELD(L3_DATA_BUS_WID, RATE_CHANGE_DELAY_COUNT, 0, 4)
REG32(L3_ANADIG_BYPASS, 0xf064)
    FIELD(L3_ANADIG_BYPASS, ANADIG_BYPASS_31_8_RSVD, 24, 8)
    FIELD(L3_ANADIG_BYPASS, ANA_DIG_COUNTER_SELECT, 7, 1)
    FIELD(L3_ANADIG_BYPASS, ANADIG_COUNT, 0, 7)
REG32(L3_BIST_FILLER_OUT, 0xf068)
    FIELD(L3_BIST_FILLER_OUT, BIST_FILLER_OUT_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_FILLER_OUT, BIST_FILLER_OUT_RESERVED, 2, 6)
    FIELD(L3_BIST_FILLER_OUT, BIST_FILLER_OUT_ENABLE, 1, 1)
    FIELD(L3_BIST_FILLER_OUT, BIST_TX_RX_LOOPBACK_ENABLE, 0, 1)
REG32(L3_BIST_FORCE_MK_RST, 0xf06c)
    FIELD(L3_BIST_FORCE_MK_RST, BIST_FORCE_MK_RST_31_8_RSVD, 24, 8)
    FIELD(L3_BIST_FORCE_MK_RST, BIST_FORCE_RESET, 1, 1)
    FIELD(L3_BIST_FORCE_MK_RST, BIST_ENABLE_MK_FROM_REG, 0, 1)
REG32(L3_SPARE_IN, 0xf070)
    FIELD(L3_SPARE_IN, SPARE_IN_31_8_RSVD, 24, 8)
    FIELD(L3_SPARE_IN, SPARE_IN, 0, 8)
REG32(L3_SPARE_OUT, 0xf074)
    FIELD(L3_SPARE_OUT, SPARE_OUT_31_8_RSVD, 24, 8)
    FIELD(L3_SPARE_OUT, SPARE_OUT, 0, 8)
REG32(PLL_REF_SEL0, 0x10000)
    FIELD(PLL_REF_SEL0, PLL_REF_SEL0_31_8_RSVD, 24, 8)
    FIELD(PLL_REF_SEL0, PLL_REF_SEL0_7_RSVD, 7, 1)
    FIELD(PLL_REF_SEL0, PLL_REF_SEL0_6_RSVD, 6, 1)
    FIELD(PLL_REF_SEL0, PLL_REF_SEL0_5_RSVD, 5, 1)
    FIELD(PLL_REF_SEL0, PLLREFSEL0, 0, 5)
REG32(PLL_REF_SEL1, 0x10004)
    FIELD(PLL_REF_SEL1, PLL_REF_SEL1_31_8_RSVD, 24, 8)
    FIELD(PLL_REF_SEL1, PLL_REF_SEL0_7_RSVD, 7, 1)
    FIELD(PLL_REF_SEL1, PLL_REF_SEL0_6_RSVD, 6, 1)
    FIELD(PLL_REF_SEL1, PLL_REF_SEL0_5_RSVD, 5, 1)
    FIELD(PLL_REF_SEL1, PLLREFSEL1, 0, 5)
REG32(PLL_REF_SEL2, 0x10008)
    FIELD(PLL_REF_SEL2, PLL_REF_SEL2_31_8_RSVD, 24, 8)
    FIELD(PLL_REF_SEL2, PLL_REF_SEL0_7_RSVD, 7, 1)
    FIELD(PLL_REF_SEL2, PLL_REF_SEL0_6_RSVD, 6, 1)
    FIELD(PLL_REF_SEL2, PLL_REF_SEL0_5_RSVD, 5, 1)
    FIELD(PLL_REF_SEL2, PLLREFSEL2, 0, 5)
REG32(PLL_REF_SEL3, 0x1000c)
    FIELD(PLL_REF_SEL3, PLL_REF_SEL3_31_8_RSVD, 24, 8)
    FIELD(PLL_REF_SEL3, PLL_REF_SEL0_7_RSVD, 7, 1)
    FIELD(PLL_REF_SEL3, PLL_REF_SEL0_6_RSVD, 6, 1)
    FIELD(PLL_REF_SEL3, PLL_REF_SEL0_5_RSVD, 5, 1)
    FIELD(PLL_REF_SEL3, PLLREFSEL3, 0, 5)
REG32(ICM_CFG0, 0x10010)
    FIELD(ICM_CFG0, ICM_CFG0_31_8_RSVD, 24, 8)
    FIELD(ICM_CFG0, ICM_CFG0_7_RSVD, 7, 1)
    FIELD(ICM_CFG0, L1_ICM_CFG, 4, 3)
    FIELD(ICM_CFG0, ICM_CFG0_3_RSVD, 3, 1)
    FIELD(ICM_CFG0, L0_ICM_CFG, 0, 3)
REG32(ICM_CFG1, 0x10014)
    FIELD(ICM_CFG1, ICM_CFG1_31_8_RSVD, 24, 8)
    FIELD(ICM_CFG1, ICM_CFG1_7_RSVD, 7, 1)
    FIELD(ICM_CFG1, L3_ICM_CFG, 4, 3)
    FIELD(ICM_CFG1, ICM_CFG1_3_RSVD, 3, 1)
    FIELD(ICM_CFG1, L2_ICM_CFG, 0, 3)
REG32(TM_CMN_RST, 0x10018)
    FIELD(TM_CMN_RST, TM_CMN_RST_31_8_RSVD, 24, 8)
    FIELD(TM_CMN_RST, TM_CMN_RST_7_2_RSVD, 2, 6)
    FIELD(TM_CMN_RST, CMN_RESETN, 1, 1)
    FIELD(TM_CMN_RST, CMN_RESETN_TM_EN, 0, 1)
REG32(PCIE_DYNDESKEW_PAT0, 0x1001c)
    FIELD(PCIE_DYNDESKEW_PAT0, PCIE_DYNDESKEW_PAT0_31_8_RSVD, 24, 8)
    FIELD(PCIE_DYNDESKEW_PAT0, PCIE_DYN_DESKEW_PAT0, 0, 8)
REG32(PCIE_DYNDESKEW_PAT1, 0x10020)
    FIELD(PCIE_DYNDESKEW_PAT1, PCIE_DYNDESKEW_PAT1_31_8_RSVD, 24, 8)
    FIELD(PCIE_DYNDESKEW_PAT1, PCIE_DYN_DESKEW_PAT1, 0, 8)
REG32(LANE_RPTR_CTRL, 0x10024)
    FIELD(LANE_RPTR_CTRL, LANE_RPTR_CTRL_31_8_RSVD, 24, 8)
    FIELD(LANE_RPTR_CTRL, LANE_RPTR_CTRL_7_1_RSVD, 1, 7)
    FIELD(LANE_RPTR_CTRL, LANE_RPTR_ON, 0, 1)
REG32(BGCAL_REF_SEL, 0x10028)
    FIELD(BGCAL_REF_SEL, BGCAL_REF_SEL_31_8_RSVD, 24, 8)
    FIELD(BGCAL_REF_SEL, BGCAL_REF_SEL_7_RSVD, 7, 1)
    FIELD(BGCAL_REF_SEL, BGCAL_REF_SEL_6_RSVD, 6, 1)
    FIELD(BGCAL_REF_SEL, BGCAL_REF_SEL_5_RSVD, 5, 1)
    FIELD(BGCAL_REF_SEL, BGCAL_REFSEL, 0, 5)
REG32(PCIE_RXSTAT_CTRL, 0x1002c)
    FIELD(PCIE_RXSTAT_CTRL, PCIE_RXSTAT_CTRL_31_8_RSVD, 24, 8)
    FIELD(PCIE_RXSTAT_CTRL, PCIE_RXSTAT_CTRL_7_1_RSVD, 1, 7)
    FIELD(PCIE_RXSTAT_CTRL, PCIE_RXSTAT_PIPELN_DIS_TM, 0, 1)
REG32(PLLLOCK2PCIEPHYRDY_CNT, 0x10034)
    FIELD(PLLLOCK2PCIEPHYRDY_CNT, PLLLOCK2PCIEPHYRDY_CNT_31_8_RSVD, 24, 8)
    FIELD(PLLLOCK2PCIEPHYRDY_CNT, PLLLOCK2PCIEPHYRDY_CNT, 0, 8)
REG32(LPBK_CTRL0, 0x10038)
    FIELD(LPBK_CTRL0, LPBK_CTRL0_31_8_RSVD, 24, 8)
    FIELD(LPBK_CTRL0, LPBK_CTRL0_7_RSVD, 7, 1)
    FIELD(LPBK_CTRL0, L1_LPBK_SEL, 4, 3)
    FIELD(LPBK_CTRL0, LPBK_CTRL0_3_RSVD, 3, 1)
    FIELD(LPBK_CTRL0, L0_LPBK_SEL, 0, 3)
REG32(LPBK_CTRL1, 0x1003c)
    FIELD(LPBK_CTRL1, LPBK_CTRL1_31_8_RSVD, 24, 8)
    FIELD(LPBK_CTRL1, LPBK_CTRL1_7_RSVD, 7, 1)
    FIELD(LPBK_CTRL1, L3_LPBK_SEL, 4, 3)
    FIELD(LPBK_CTRL1, LPBK_CTRL1_3_RSVD, 3, 1)
    FIELD(LPBK_CTRL1, L2_LPBK_SEL, 0, 3)
REG32(TX_PROT_BUS_WIDTH, 0x10040)
    FIELD(TX_PROT_BUS_WIDTH, TX_PROT_BUS_WIDTH_31_8_RSVD, 24, 8)
    FIELD(TX_PROT_BUS_WIDTH, L3_TX_PROT_BUSWIDTH, 6, 2)
    FIELD(TX_PROT_BUS_WIDTH, L2_TX_PROT_BUSWIDTH, 4, 2)
    FIELD(TX_PROT_BUS_WIDTH, L1_TX_PROT_BUSWIDTH, 2, 2)
    FIELD(TX_PROT_BUS_WIDTH, L0_TX_PROT_BUSWIDTH, 0, 2)
REG32(RX_PROT_BUS_WIDTH, 0x10044)
    FIELD(RX_PROT_BUS_WIDTH, RX_PROT_BUS_WIDTH_31_8_RSVD, 24, 8)
    FIELD(RX_PROT_BUS_WIDTH, L3_RX_PROT_BUSWIDTH, 6, 2)
    FIELD(RX_PROT_BUS_WIDTH, L2_RX_PROT_BUSWIDTH, 4, 2)
    FIELD(RX_PROT_BUS_WIDTH, L1_RX_PROT_BUSWIDTH, 2, 2)
    FIELD(RX_PROT_BUS_WIDTH, L0_RX_PROT_BUSWIDTH, 0, 2)
REG32(RMMI_RST_CTRL, 0x10048)
    FIELD(RMMI_RST_CTRL, RMMI_RST_CTRL_31_8_RSVD, 24, 8)
    FIELD(RMMI_RST_CTRL, L3_RX_RESET, 7, 1)
    FIELD(RMMI_RST_CTRL, L2_RX_RESET, 6, 1)
    FIELD(RMMI_RST_CTRL, L1_RX_RESET, 5, 1)
    FIELD(RMMI_RST_CTRL, L0_RX_RESET, 4, 1)
    FIELD(RMMI_RST_CTRL, L3_TX_RESET, 3, 1)
    FIELD(RMMI_RST_CTRL, L2_TX_RESET, 2, 1)
    FIELD(RMMI_RST_CTRL, L1_TX_RESET, 1, 1)
    FIELD(RMMI_RST_CTRL, L0_TX_RESET, 0, 1)
REG32(TM_RX_COUPLING_CTRL, 0x1004c)
    FIELD(TM_RX_COUPLING_CTRL, TM_RX_COUPLING_CTRL_31_8_RSVD, 24, 8)
    FIELD(TM_RX_COUPLING_CTRL, L3_RX_COUPLING_TM_EN, 7, 1)
    FIELD(TM_RX_COUPLING_CTRL, L3_RX_COUPLING, 6, 1)
    FIELD(TM_RX_COUPLING_CTRL, L2_RX_COUPLING_TM_EN, 5, 1)
    FIELD(TM_RX_COUPLING_CTRL, L2_RX_COUPLING, 4, 1)
    FIELD(TM_RX_COUPLING_CTRL, L1_RX_COUPLING_TM_EN, 3, 1)
    FIELD(TM_RX_COUPLING_CTRL, L1_RX_COUPLING, 2, 1)
    FIELD(TM_RX_COUPLING_CTRL, L0_RX_COUPLING_TM_EN, 1, 1)
    FIELD(TM_RX_COUPLING_CTRL, L0_RX_COUPLING, 0, 1)
REG32(TM_PCIE_DESKEW_CTRL, 0x10050)
    FIELD(TM_PCIE_DESKEW_CTRL, TM_PCIE_DESKEW_CTRL_31_8_RSVD, 24, 8)
    FIELD(TM_PCIE_DESKEW_CTRL, EN_DESKEW_RATE_CHANGE_TM, 7, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, LINK_DOWN_RESET, 6, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, PCIE_DESKEW_BYP, 5, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, PCIE_DYN_DESKEW_BYP, 4, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, PCIE_RX_DATA_PATH_EN_TM_EN, 3, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, PCIE_RX_DATA_PATH_EN_TM, 2, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, PCIE_DESKEW_TM_EN, 1, 1)
    FIELD(TM_PCIE_DESKEW_CTRL, PCIE_DESKEW_EN, 0, 1)
REG32(TM_PCIE_LANEMAP, 0x10054)
    FIELD(TM_PCIE_LANEMAP, TM_PCIE_LANEMAP_31_8_RSVD, 24, 8)
    FIELD(TM_PCIE_LANEMAP, TM_PCIE_LANEMAP_TM_7_5_RSVD, 5, 3)
    FIELD(TM_PCIE_LANEMAP, PCIE_LANEMAP_TM_EN, 4, 1)
    FIELD(TM_PCIE_LANEMAP, PCIE_LANEMAP_TM, 0, 4)
REG32(RX_DETECT_CTRL, 0x10058)
    FIELD(RX_DETECT_CTRL, RX_DETECT_CTRL_31_8_RSVD, 24, 8)
    FIELD(RX_DETECT_CTRL, L3_TXDETRX_RC_OFF, 7, 1)
    FIELD(RX_DETECT_CTRL, L3_TXDETRX_RC_OFF_TM_EN, 6, 1)
    FIELD(RX_DETECT_CTRL, L2_TXDETRX_RC_OFF, 5, 1)
    FIELD(RX_DETECT_CTRL, L2_TXDETRX_RC_OFF_TM_EN, 4, 1)
    FIELD(RX_DETECT_CTRL, L1_TXDETRX_RC_OFF, 3, 1)
    FIELD(RX_DETECT_CTRL, L1_TXDETRX_RC_OFF_TM_EN, 2, 1)
    FIELD(RX_DETECT_CTRL, L0_TXDETRX_RC_OFF, 1, 1)
    FIELD(RX_DETECT_CTRL, L0_TXDETRX_RC_OFF_TM_EN, 0, 1)
REG32(DESKEW_ST0, 0x1005c)
    FIELD(DESKEW_ST0, DESKEW_ST0_31_8_RSVD, 24, 8)
    FIELD(DESKEW_ST0, IDLE_SEQ_DETD, 4, 4)
    FIELD(DESKEW_ST0, IDLE_SEQ_4_DETD, 0, 4)
REG32(DESKEW_ST1, 0x10060)
    FIELD(DESKEW_ST1, DESKEW_ST1_31_8_RSVD, 24, 8)
    FIELD(DESKEW_ST1, DESKEW_ST1_7_6_RSVD, 6, 2)
    FIELD(DESKEW_ST1, DESKEW_DONE, 5, 1)
    FIELD(DESKEW_ST1, DESKEW_IN_PROGRESS, 4, 1)
    FIELD(DESKEW_ST1, PCIE_LANE_MAP, 0, 4)
REG32(AFE_RX0_CTRL, 0x10064)
    FIELD(AFE_RX0_CTRL, AFE_RX0_CTRL_31_8_RSVD, 24, 8)
    FIELD(AFE_RX0_CTRL, AFE_RX0_CTRL_7_5_RSVD, 5, 3)
    FIELD(AFE_RX0_CTRL, PSO_IO_EQ, 4, 1)
    FIELD(AFE_RX0_CTRL, PSO_CORE_EQ, 3, 1)
    FIELD(AFE_RX0_CTRL, PSO_EQ_TM, 2, 1)
    FIELD(AFE_RX0_CTRL, AFE_RX0_MPHY_PWM_SYS_REFCLK, 1, 1)
    FIELD(AFE_RX0_CTRL, AFE_RX0_MPHY_MASK_BURST_START, 0, 1)
REG32(AFE_RX1_CTRL, 0x10068)
    FIELD(AFE_RX1_CTRL, AFE_RX1_CTRL_31_8_RSVD, 24, 8)
    FIELD(AFE_RX1_CTRL, AFE_RX1_CTRL_7_5_RSVD, 5, 3)
    FIELD(AFE_RX1_CTRL, PSO_IO_EQ, 4, 1)
    FIELD(AFE_RX1_CTRL, PSO_CORE_EQ, 3, 1)
    FIELD(AFE_RX1_CTRL, PSO_EQ_TM, 2, 1)
    FIELD(AFE_RX1_CTRL, AFE_RX1_MPHY_PWM_SYS_REFCLK, 1, 1)
    FIELD(AFE_RX1_CTRL, AFE_RX1_MPHY_MASK_BURST_START, 0, 1)
REG32(AFE_RX2_CTRL, 0x1006c)
    FIELD(AFE_RX2_CTRL, AFE_RX2_CTRL_31_8_RSVD, 24, 8)
    FIELD(AFE_RX2_CTRL, AFE_RX2_CTRL_7_5_RSVD, 5, 3)
    FIELD(AFE_RX2_CTRL, PSO_IO_EQ, 4, 1)
    FIELD(AFE_RX2_CTRL, PSO_CORE_EQ, 3, 1)
    FIELD(AFE_RX2_CTRL, PSO_EQ_TM, 2, 1)
    FIELD(AFE_RX2_CTRL, AFE_RX2_MPHY_PWM_SYS_REFCLK, 1, 1)
    FIELD(AFE_RX2_CTRL, AFE_RX2_MPHY_MASK_BURST_START, 0, 1)
REG32(AFE_RX3_CTRL, 0x10070)
    FIELD(AFE_RX3_CTRL, AFE_RX3_CTRL_31_8_RSVD, 24, 8)
    FIELD(AFE_RX3_CTRL, AFE_RX3_CTRL_7_5_RSVD, 5, 3)
    FIELD(AFE_RX3_CTRL, PSO_IO_EQ, 4, 1)
    FIELD(AFE_RX3_CTRL, PSO_CORE_EQ, 3, 1)
    FIELD(AFE_RX3_CTRL, PSO_EQ_TM, 2, 1)
    FIELD(AFE_RX3_CTRL, AFE_RX3_MPHY_PWM_SYS_REFCLK, 1, 1)
    FIELD(AFE_RX3_CTRL, AFE_RX3_MPHY_MASK_BURST_START, 0, 1)
REG32(SPARE_IN0, 0x10074)
    FIELD(SPARE_IN0, SPARE_IN0_31_8_RSVD, 24, 8)
    FIELD(SPARE_IN0, SPARE_IN, 0, 8)
REG32(SPARE_OUT0, 0x10078)
    FIELD(SPARE_OUT0, SPARE_OUT0_31_8_RSVD, 24, 8)
    FIELD(SPARE_OUT0, SPARE_OUT, 0, 8)
REG32(SPARE_IN1, 0x1007c)
    FIELD(SPARE_IN1, SPARE_IN1_31_8_RSVD, 24, 8)
    FIELD(SPARE_IN1, SPARE_IN, 0, 8)
REG32(SPARE_OUT1, 0x10080)
    FIELD(SPARE_OUT1, SPARE_OUT1_31_8_RSVD, 24, 8)
    FIELD(SPARE_OUT1, SPARE_OUT, 0, 8)
REG32(SPARE_IN2, 0x10084)
    FIELD(SPARE_IN2, SPARE_IN2_31_8_RSVD, 24, 8)
    FIELD(SPARE_IN2, SPARE_IN, 0, 8)
REG32(SPARE_OUT2, 0x10088)
    FIELD(SPARE_OUT2, SPARE_OUT2_31_8_RSVD, 24, 8)
    FIELD(SPARE_OUT2, SPARE_OUT, 0, 8)
REG32(SPARE_IN3, 0x1008c)
    FIELD(SPARE_IN3, SPARE_IN3_31_8_RSVD, 24, 8)
    FIELD(SPARE_IN3, SPARE_IN, 0, 8)
REG32(SPARE_OUT3, 0x10090)
    FIELD(SPARE_OUT3, SPARE_OUT3_31_8_RSVD, 24, 8)
    FIELD(SPARE_OUT3, SPARE_OUT, 0, 8)
REG32(SGMII_CDET_CTRL, 0x10094)
    FIELD(SGMII_CDET_CTRL, SGMII_CDET_CTRL_31_8_RSVD, 24, 8)
    FIELD(SGMII_CDET_CTRL, L3_EN_CDET_TM_EN, 7, 1)
    FIELD(SGMII_CDET_CTRL, L3_EN_CDET, 6, 1)
    FIELD(SGMII_CDET_CTRL, L2_EN_CDET_TM_EN, 5, 1)
    FIELD(SGMII_CDET_CTRL, L2_EN_CDET, 4, 1)
    FIELD(SGMII_CDET_CTRL, L1_EN_CDET_TM_EN, 3, 1)
    FIELD(SGMII_CDET_CTRL, L1_EN_CDET, 2, 1)
    FIELD(SGMII_CDET_CTRL, L0_EN_CDET_TM_EN, 1, 1)
    FIELD(SGMII_CDET_CTRL, L0_EN_CDET, 0, 1)
REG32(UPHY_SPARE0, 0x10098)
    FIELD(UPHY_SPARE0, UPHY_SPARE0_31_8_RSVD, 24, 8)
    FIELD(UPHY_SPARE0, SPARE, 0, 8)
REG32(UPHY_SPARE1, 0x1009c)
    FIELD(UPHY_SPARE1, UPHY_SPARE1_31_8_RSVD, 24, 8)
    FIELD(UPHY_SPARE1, SPARE, 0, 8)
REG32(UPHY_SPARE2, 0x100a0)
    FIELD(UPHY_SPARE2, UPHY_SPARE2_31_8_RSVD, 24, 8)
    FIELD(UPHY_SPARE2, SPARE, 0, 8)
REG32(UPHY_SPARE3, 0x100a4)
    FIELD(UPHY_SPARE3, UPHY_SPARE3_31_8_RSVD, 24, 8)
    FIELD(UPHY_SPARE3, SPARE, 0, 8)
REG32(CIRRUS_SPARE_OUT0, 0x100a8)
    FIELD(CIRRUS_SPARE_OUT0, CIRRUS_SPARE_OUT0_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_OUT0, SPARE, 0, 8)
REG32(CIRRUS_SPARE_OUT1, 0x100ac)
    FIELD(CIRRUS_SPARE_OUT1, CIRRUS_SPARE_OUT1_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_OUT1, SPARE, 0, 8)
REG32(CIRRUS_SPARE_OUT2, 0x100b0)
    FIELD(CIRRUS_SPARE_OUT2, CIRRUS_SPARE_OUT2_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_OUT2, SPARE, 0, 8)
REG32(CIRRUS_SPARE_OUT3, 0x100b4)
    FIELD(CIRRUS_SPARE_OUT3, CIRRUS_SPARE_OUT3_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_OUT3, SPARE, 0, 8)
REG32(CIRRUS_SPARE_IN0, 0x100b8)
    FIELD(CIRRUS_SPARE_IN0, CIRRUS_SPARE_IN0_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_IN0, SPARE, 0, 8)
REG32(CIRRUS_SPARE_IN1, 0x100bc)
    FIELD(CIRRUS_SPARE_IN1, CIRRUS_SPARE_IN1_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_IN1, SPARE, 0, 8)
REG32(CIRRUS_SPARE_IN2, 0x100c0)
    FIELD(CIRRUS_SPARE_IN2, CIRRUS_SPARE_IN2_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_IN2, SPARE, 0, 8)
REG32(CIRRUS_SPARE_IN3, 0x100c4)
    FIELD(CIRRUS_SPARE_IN3, CIRRUS_SPARE_IN3_31_8_RSVD, 24, 8)
    FIELD(CIRRUS_SPARE_IN3, SPARE, 0, 8)
REG32(AFE_EQ_PSO_DELAY, 0x100c8)
    FIELD(AFE_EQ_PSO_DELAY, AFE_EQ_PSO_DELAY_31_8_RSVD, 24, 8)
    FIELD(AFE_EQ_PSO_DELAY, RSVD_7, 7, 1)
    FIELD(AFE_EQ_PSO_DELAY, DEASSERT_DELAY, 4, 3)
    FIELD(AFE_EQ_PSO_DELAY, RSVD_3, 3, 1)
    FIELD(AFE_EQ_PSO_DELAY, ASSERT_DELAY, 0, 3)
REG32(USB_TXFIFO0_CTRL, 0x10210)
    FIELD(USB_TXFIFO0_CTRL, USB_TXFIFO0_CTRL_31_8_RSVD, 24, 8)
    FIELD(USB_TXFIFO0_CTRL, USB0_TXFIFO_BYP, 7, 1)
    FIELD(USB_TXFIFO0_CTRL, USB_TXFIFO0_CTRL_6_RSVD, 6, 1)
    FIELD(USB_TXFIFO0_CTRL, USB0_TXFIFO_ALMOST_EMPTY_VAL, 0, 6)
REG32(USB_TXFIFO1_CTRL, 0x10214)
    FIELD(USB_TXFIFO1_CTRL, USB_TXFIFO1_CTRL_31_8_RSVD, 24, 8)
    FIELD(USB_TXFIFO1_CTRL, USB1_TXFIFO_BYP, 7, 1)
    FIELD(USB_TXFIFO1_CTRL, USB_TXFIFO1_CTRL_6_RSVD, 6, 1)
    FIELD(USB_TXFIFO1_CTRL, USB1_TXFIFO_ALMOST_EMPTY_VAL, 0, 6)
REG32(DP_TXFIFO0_CTRL, 0x10218)
    FIELD(DP_TXFIFO0_CTRL, DP_TXFIFO0_CTRL_31_8_RSVD, 24, 8)
    FIELD(DP_TXFIFO0_CTRL, DP0_TXFIFO_BYP, 7, 1)
    FIELD(DP_TXFIFO0_CTRL, DP_TXFIFO0_CTRL_6_RSVD, 6, 1)
    FIELD(DP_TXFIFO0_CTRL, DP0_TXFIFO_ALMOST_EMPTY_VAL, 0, 6)
REG32(DP_TXFIFO1_CTRL, 0x1021c)
    FIELD(DP_TXFIFO1_CTRL, DP_TXFIFO1_CTRL_31_8_RSVD, 24, 8)
    FIELD(DP_TXFIFO1_CTRL, DP1_TXFIFO_BYP, 7, 1)
    FIELD(DP_TXFIFO1_CTRL, DP_TXFIFO1_CTRL_6_RSVD, 6, 1)
    FIELD(DP_TXFIFO1_CTRL, DP1_TXFIFO_ALMOST_EMPTY_VAL, 0, 6)

#define SERDES_R_MAX (R_DP_TXFIFO1_CTRL + 1)

typedef struct SERDES {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[SERDES_R_MAX];
    RegisterInfo regs_info[SERDES_R_MAX];
    const char *prefix;
} SERDES;

static RegisterAccessInfo serdes_regs_info[] = {
    {   .name = "L0_TX_ANA_TM_0",  .addr = A_L0_TX_ANA_TM_0,
        .reset = 0x28,
        .ro = 0xffffffc3,
    },{ .name = "L0_TX_ANA_TM_3",  .addr = A_L0_TX_ANA_TM_3,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_4",  .addr = A_L0_TX_ANA_TM_4,
        .ro = 0xffffff80,
    },{ .name = "L0_TX_ANA_TM_5",  .addr = A_L0_TX_ANA_TM_5,
        .ro = 0xffffff80,
    },{ .name = "L0_TX_ANA_TM_9",  .addr = A_L0_TX_ANA_TM_9,
        .reset = 0x3f,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_10",  .addr = A_L0_TX_ANA_TM_10,
        .reset = 0x30,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_13",  .addr = A_L0_TX_ANA_TM_13,
        .reset = 0x2,
        .ro = 0xfffffff0,
    },{ .name = "L0_TX_ANA_TM_14",  .addr = A_L0_TX_ANA_TM_14,
        .ro = 0xffffffcf,
    },{ .name = "L0_TX_ANA_TM_15",  .addr = A_L0_TX_ANA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_16",  .addr = A_L0_TX_ANA_TM_16,
        .ro = 0xfffffff0,
    },{ .name = "L0_TX_ANA_TM_18",  .addr = A_L0_TX_ANA_TM_18,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_19",  .addr = A_L0_TX_ANA_TM_19,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_20",  .addr = A_L0_TX_ANA_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L0_TX_ANA_TM_21",  .addr = A_L0_TX_ANA_TM_21,
        .ro = 0xffffffc0,
    },{ .name = "L0_TX_DIG_TM_61",  .addr = A_L0_TX_DIG_TM_61,
        .ro = 0xffffff34,
    },{ .name = "L0_TX_DIG_TM_62",  .addr = A_L0_TX_DIG_TM_62,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_65",  .addr = A_L0_TX_DIG_TM_65,
        .ro = 0xffffff01,
    },{ .name = "L0_TX_DIG_TM_67",  .addr = A_L0_TX_DIG_TM_67,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_68",  .addr = A_L0_TX_DIG_TM_68,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_69",  .addr = A_L0_TX_DIG_TM_69,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_76",  .addr = A_L0_TX_DIG_TM_76,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_77",  .addr = A_L0_TX_DIG_TM_77,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_78",  .addr = A_L0_TX_DIG_TM_78,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_79",  .addr = A_L0_TX_DIG_TM_79,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_80",  .addr = A_L0_TX_DIG_TM_80,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_81",  .addr = A_L0_TX_DIG_TM_81,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_82",  .addr = A_L0_TX_DIG_TM_82,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_83",  .addr = A_L0_TX_DIG_TM_83,
        .ro = 0xfffffff0,
    },{ .name = "L0_TX_DIG_TM_84",  .addr = A_L0_TX_DIG_TM_84,
        .ro = 0xffffff0a,
    },{ .name = "L0_TX_ANA_TM_85",  .addr = A_L0_TX_ANA_TM_85,
        .ro = 0xffffffca,
    },{ .name = "L0_TX_ANA_TM_87",  .addr = A_L0_TX_ANA_TM_87,
        .ro = 0xfffffff0,
    },{ .name = "L0_TX_ANA_TM_88",  .addr = A_L0_TX_ANA_TM_88,
        .reset = 0x96,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_89",  .addr = A_L0_TX_ANA_TM_89,
        .ro = 0xffffffd9,
    },{ .name = "L0_TX_ANA_TM_90",  .addr = A_L0_TX_ANA_TM_90,
        .ro = 0xffffffdf,
    },{ .name = "L0_TX_DIG_TM_91",  .addr = A_L0_TX_DIG_TM_91,
        .reset = 0x1a,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_92",  .addr = A_L0_TX_DIG_TM_92,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_95",  .addr = A_L0_TX_ANA_TM_95,
        .ro = 0xffffffc3,
    },{ .name = "L0_TX_ANA_TM_96",  .addr = A_L0_TX_ANA_TM_96,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_97",  .addr = A_L0_TX_ANA_TM_97,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_98",  .addr = A_L0_TX_DIG_TM_98,
        .ro = 0xffffffc0,
    },{ .name = "L0_TX_DIG_TM_99",  .addr = A_L0_TX_DIG_TM_99,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_100",  .addr = A_L0_TX_DIG_TM_100,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_101",  .addr = A_L0_TX_DIG_TM_101,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_102",  .addr = A_L0_TX_DIG_TM_102,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_103",  .addr = A_L0_TX_DIG_TM_103,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_104",  .addr = A_L0_TX_DIG_TM_104,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_105",  .addr = A_L0_TX_DIG_TM_105,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_106",  .addr = A_L0_TX_DIG_TM_106,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_107",  .addr = A_L0_TX_DIG_TM_107,
        .ro = 0xffffff80,
    },{ .name = "L0_TX_DIG_TM_108",  .addr = A_L0_TX_DIG_TM_108,
        .ro = 0xffffff80,
    },{ .name = "L0_TX_DIG_TM_109",  .addr = A_L0_TX_DIG_TM_109,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_110",  .addr = A_L0_TX_DIG_TM_110,
        .reset = 0x9,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_DIG_TM_111",  .addr = A_L0_TX_DIG_TM_111,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_112",  .addr = A_L0_TX_ANA_TM_112,
        .ro = 0xffffffc0,
    },{ .name = "L0_TX_ANA_TM_113",  .addr = A_L0_TX_ANA_TM_113,
        .ro = 0xffffff00,
    },{ .name = "L0_TX_ANA_TM_114",  .addr = A_L0_TX_ANA_TM_114,
        .ro = 0xffffffe0,
    },{ .name = "L0_TX_ANA_TM_115",  .addr = A_L0_TX_ANA_TM_115,
        .ro = 0xffffff80,
    },{ .name = "L0_TX_ANA_TM_116",  .addr = A_L0_TX_ANA_TM_116,
        .ro = 0xffffff80,
    },{ .name = "L0_TX_ANA_TM_117",  .addr = A_L0_TX_ANA_TM_117,
        .ro = 0xffffffc0,
    },{ .name = "L0_TX_ANA_TM_118",  .addr = A_L0_TX_ANA_TM_118,
        .ro = 0xfffffff0,
    },{ .name = "L0_TXPMA_TM_0",  .addr = A_L0_TXPMA_TM_0,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_1",  .addr = A_L0_TXPMA_TM_1,
        .ro = 0xfffffff0,
    },{ .name = "L0_TXPMA_TM_2",  .addr = A_L0_TXPMA_TM_2,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_3",  .addr = A_L0_TXPMA_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMA_TM_4",  .addr = A_L0_TXPMA_TM_4,
        .reset = 0x2,
        .ro = 0xffffff01,
    },{ .name = "L0_TXPMA_TM_5",  .addr = A_L0_TXPMA_TM_5,
        .ro = 0xfffffff0,
    },{ .name = "L0_TXPMA_TM_6",  .addr = A_L0_TXPMA_TM_6,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_7",  .addr = A_L0_TXPMA_TM_7,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_8",  .addr = A_L0_TXPMA_TM_8,
        .ro = 0xfffffffc,
    },{ .name = "L0_TXPMA_TM_9",  .addr = A_L0_TXPMA_TM_9,
        .ro = 0xffffff80,
    },{ .name = "L0_TXPMA_TM_10",  .addr = A_L0_TXPMA_TM_10,
        .ro = 0xffffffc0,
    },{ .name = "L0_TXPMA_TM_11",  .addr = A_L0_TXPMA_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMA_TM_12",  .addr = A_L0_TXPMA_TM_12,
        .ro = 0xffffff01,
    },{ .name = "L0_TXPMA_TM_13",  .addr = A_L0_TXPMA_TM_13,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_14",  .addr = A_L0_TXPMA_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMA_TM_15",  .addr = A_L0_TXPMA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_16",  .addr = A_L0_TXPMA_TM_16,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_17",  .addr = A_L0_TXPMA_TM_17,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_18",  .addr = A_L0_TXPMA_TM_18,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_19",  .addr = A_L0_TXPMA_TM_19,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L0_TXPMA_TM_20",  .addr = A_L0_TXPMA_TM_20,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_21",  .addr = A_L0_TXPMA_TM_21,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_22",  .addr = A_L0_TXPMA_TM_22,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_23",  .addr = A_L0_TXPMA_TM_23,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_24",  .addr = A_L0_TXPMA_TM_24,
        .ro = 0xffffff80,
    },{ .name = "L0_TXPMA_TM_25",  .addr = A_L0_TXPMA_TM_25,
        .ro = 0xffffffc0,
    },{ .name = "L0_TXPMA_TM_26",  .addr = A_L0_TXPMA_TM_26,
        .reset = 0x64,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_TM_27",  .addr = A_L0_TXPMA_TM_27,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMA_ST_0",  .addr = A_L0_TXPMA_ST_0,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_1",  .addr = A_L0_TXPMA_ST_1,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_2",  .addr = A_L0_TXPMA_ST_2,
        .reset = 0x4,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_3",  .addr = A_L0_TXPMA_ST_3,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_4",  .addr = A_L0_TXPMA_ST_4,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_5",  .addr = A_L0_TXPMA_ST_5,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_6",  .addr = A_L0_TXPMA_ST_6,
        .reset = 0xb,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_7",  .addr = A_L0_TXPMA_ST_7,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_8",  .addr = A_L0_TXPMA_ST_8,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMA_ST_9",  .addr = A_L0_TXPMA_ST_9,
        .ro = 0xffffffff,
    },{ .name = "L0_TXPMD_TM_0",  .addr = A_L0_TXPMD_TM_0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_1",  .addr = A_L0_TXPMD_TM_1,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_2",  .addr = A_L0_TXPMD_TM_2,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_3",  .addr = A_L0_TXPMD_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_4",  .addr = A_L0_TXPMD_TM_4,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_5",  .addr = A_L0_TXPMD_TM_5,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_6",  .addr = A_L0_TXPMD_TM_6,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_7",  .addr = A_L0_TXPMD_TM_7,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_8",  .addr = A_L0_TXPMD_TM_8,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_9",  .addr = A_L0_TXPMD_TM_9,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_10",  .addr = A_L0_TXPMD_TM_10,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_11",  .addr = A_L0_TXPMD_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_12",  .addr = A_L0_TXPMD_TM_12,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_13",  .addr = A_L0_TXPMD_TM_13,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_14",  .addr = A_L0_TXPMD_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_15",  .addr = A_L0_TXPMD_TM_15,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_16",  .addr = A_L0_TXPMD_TM_16,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_17",  .addr = A_L0_TXPMD_TM_17,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_18",  .addr = A_L0_TXPMD_TM_18,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_19",  .addr = A_L0_TXPMD_TM_19,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_20",  .addr = A_L0_TXPMD_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_21",  .addr = A_L0_TXPMD_TM_21,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_22",  .addr = A_L0_TXPMD_TM_22,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_23",  .addr = A_L0_TXPMD_TM_23,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_24",  .addr = A_L0_TXPMD_TM_24,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_25",  .addr = A_L0_TXPMD_TM_25,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_26",  .addr = A_L0_TXPMD_TM_26,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_27",  .addr = A_L0_TXPMD_TM_27,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_28",  .addr = A_L0_TXPMD_TM_28,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_29",  .addr = A_L0_TXPMD_TM_29,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_30",  .addr = A_L0_TXPMD_TM_30,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_31",  .addr = A_L0_TXPMD_TM_31,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_32",  .addr = A_L0_TXPMD_TM_32,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_33",  .addr = A_L0_TXPMD_TM_33,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_34",  .addr = A_L0_TXPMD_TM_34,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_35",  .addr = A_L0_TXPMD_TM_35,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_36",  .addr = A_L0_TXPMD_TM_36,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_37",  .addr = A_L0_TXPMD_TM_37,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_38",  .addr = A_L0_TXPMD_TM_38,
        .ro = 0xffffff80,
    },{ .name = "L0_TXPMD_TM_39",  .addr = A_L0_TXPMD_TM_39,
        .ro = 0xfffffff8,
    },{ .name = "L0_TXPMD_TM_40",  .addr = A_L0_TXPMD_TM_40,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_41",  .addr = A_L0_TXPMD_TM_41,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_42",  .addr = A_L0_TXPMD_TM_42,
        .ro = 0xffffffe0,
    },{ .name = "L0_TXPMD_TM_43",  .addr = A_L0_TXPMD_TM_43,
        .ro = 0xfffffff0,
    },{ .name = "L0_TXPMD_TM_44",  .addr = A_L0_TXPMD_TM_44,
        .ro = 0xffffffc0,
    },{ .name = "L0_TXPMD_TM_45",  .addr = A_L0_TXPMD_TM_45,
        .ro = 0xffffffc0,
    },{ .name = "L0_TXPMD_TM_46",  .addr = A_L0_TXPMD_TM_46,
        .ro = 0xffffffc0,
    },{ .name = "L0_TXPMD_TM_47",  .addr = A_L0_TXPMD_TM_47,
        .ro = 0xffffff00,
    },{ .name = "L0_TXPMD_TM_48",  .addr = A_L0_TXPMD_TM_48,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_ANA_BYP_1",  .addr = A_L0_TM_ANA_BYP_1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_2",  .addr = A_L0_TM_ANA_BYP_2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_3",  .addr = A_L0_TM_ANA_BYP_3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_4",  .addr = A_L0_TM_ANA_BYP_4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_5",  .addr = A_L0_TM_ANA_BYP_5,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_ANA_BYP_7",  .addr = A_L0_TM_ANA_BYP_7,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L0_TM_ANA_BYP_8",  .addr = A_L0_TM_ANA_BYP_8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_9",  .addr = A_L0_TM_ANA_BYP_9,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_10",  .addr = A_L0_TM_ANA_BYP_10,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_ANA_BYP_11",  .addr = A_L0_TM_ANA_BYP_11,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_ANA_BYP_12",  .addr = A_L0_TM_ANA_BYP_12,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_13",  .addr = A_L0_TM_ANA_BYP_13,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L0_TM_ANA_BYP_14",  .addr = A_L0_TM_ANA_BYP_14,
        .rsvd = 0xc,
        .ro = 0xffffff0c,
    },{ .name = "L0_TM_ANA_BYP_15",  .addr = A_L0_TM_ANA_BYP_15,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_16",  .addr = A_L0_TM_ANA_BYP_16,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_17",  .addr = A_L0_TM_ANA_BYP_17,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_ANA_BYP_18",  .addr = A_L0_TM_ANA_BYP_18,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_ANA_BYP_20",  .addr = A_L0_TM_ANA_BYP_20,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_21",  .addr = A_L0_TM_ANA_BYP_21,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_22",  .addr = A_L0_TM_ANA_BYP_22,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BYP_23",  .addr = A_L0_TM_ANA_BYP_23,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_1",  .addr = A_L0_TM_DIG_1,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_2",  .addr = A_L0_TM_DIG_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_3",  .addr = A_L0_TM_DIG_3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_4",  .addr = A_L0_TM_DIG_4,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L0_TM_DIG_5",  .addr = A_L0_TM_DIG_5,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L0_TM_DIG_6",  .addr = A_L0_TM_DIG_6,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_DIG_7",  .addr = A_L0_TM_DIG_7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_8",  .addr = A_L0_TM_DIG_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DIG_9",  .addr = A_L0_TM_DIG_9,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_DIG_10",  .addr = A_L0_TM_DIG_10,
        .reset = 0x1,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_DIG_11",  .addr = A_L0_TM_DIG_11,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L0_TM_DIG_12",  .addr = A_L0_TM_DIG_12,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_13",  .addr = A_L0_TM_DIG_13,
        .reset = 0x1a,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_DIG_14",  .addr = A_L0_TM_DIG_14,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L0_TM_DIG_15",  .addr = A_L0_TM_DIG_15,
        .reset = 0xd,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_16",  .addr = A_L0_TM_DIG_16,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DIG_17",  .addr = A_L0_TM_DIG_17,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DIG_18",  .addr = A_L0_TM_DIG_18,
        .reset = 0x2a,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_19",  .addr = A_L0_TM_DIG_19,
        .reset = 0x36,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_20",  .addr = A_L0_TM_DIG_20,
        .reset = 0x10,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_DIG_21",  .addr = A_L0_TM_DIG_21,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DIG_22",  .addr = A_L0_TM_DIG_22,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_23",  .addr = A_L0_TM_DIG_23,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_24",  .addr = A_L0_TM_DIG_24,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_25",  .addr = A_L0_TM_DIG_25,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_26",  .addr = A_L0_TM_DIG_26,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_27",  .addr = A_L0_TM_DIG_27,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_28",  .addr = A_L0_TM_DIG_28,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_29",  .addr = A_L0_TM_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_AUX_0",  .addr = A_L0_TM_AUX_0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_AUX_1",  .addr = A_L0_TM_AUX_1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_AUX_2",  .addr = A_L0_TM_AUX_2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_AUX_3",  .addr = A_L0_TM_AUX_3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_AUX_4",  .addr = A_L0_TM_AUX_4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_30",  .addr = A_L0_TM_DIG_30,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_31",  .addr = A_L0_TM_DIG_31,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_32",  .addr = A_L0_TM_DIG_32,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_33",  .addr = A_L0_TM_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_34",  .addr = A_L0_TM_DIG_34,
        .reset = 0x1e,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_35",  .addr = A_L0_TM_DIG_35,
        .reset = 0x18,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_DIG_36",  .addr = A_L0_TM_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DIG_37",  .addr = A_L0_TM_DIG_37,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_LFPS_1",  .addr = A_L0_TM_LFPS_1,
        .reset = 0x88,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_LFPS_2",  .addr = A_L0_TM_LFPS_2,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_LFPS_3",  .addr = A_L0_TM_LFPS_3,
        .reset = 0x6c,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_LFPS_4",  .addr = A_L0_TM_LFPS_4,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_RXPMA_1",  .addr = A_L0_TM_RXPMA_1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BSCAN_1",  .addr = A_L0_TM_BSCAN_1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L0_TM_MPHY_SQ_1",  .addr = A_L0_TM_MPHY_SQ_1,
        .reset = 0x1,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_LSRX_1",  .addr = A_L0_TM_LSRX_1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_LSRX_2",  .addr = A_L0_TM_LSRX_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_SIGDET_1",  .addr = A_L0_TM_SIGDET_1,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_SIGDET_2",  .addr = A_L0_TM_SIGDET_2,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DFT_1",  .addr = A_L0_TM_DFT_1,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L0_TM_DFT_2",  .addr = A_L0_TM_DFT_2,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L0_TM_DFT_3",  .addr = A_L0_TM_DFT_3,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DFT_4",  .addr = A_L0_TM_DFT_4,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L0_TM_DFT_5",  .addr = A_L0_TM_DFT_5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DFT_6",  .addr = A_L0_TM_DFT_6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DFT_7",  .addr = A_L0_TM_DFT_7,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DFT_8",  .addr = A_L0_TM_DFT_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_DFT_9",  .addr = A_L0_TM_DFT_9,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_DFT_10",  .addr = A_L0_TM_DFT_10,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_BG_1",  .addr = A_L0_TM_BG_1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_2",  .addr = A_L0_TM_BG_2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_3",  .addr = A_L0_TM_BG_3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_4",  .addr = A_L0_TM_BG_4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_5",  .addr = A_L0_TM_BG_5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_6",  .addr = A_L0_TM_BG_6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_7",  .addr = A_L0_TM_BG_7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_8",  .addr = A_L0_TM_BG_8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_9",  .addr = A_L0_TM_BG_9,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_10",  .addr = A_L0_TM_BG_10,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SD0",  .addr = A_L0_TM_SD0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SD1",  .addr = A_L0_TM_SD1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SD2",  .addr = A_L0_TM_SD2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SD3",  .addr = A_L0_TM_SD3,
        .reset = 0x4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SD4",  .addr = A_L0_TM_SD4,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_SD5",  .addr = A_L0_TM_SD5,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SD6",  .addr = A_L0_TM_SD6,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_MISC1",  .addr = A_L0_TM_MISC1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_MISC2",  .addr = A_L0_TM_MISC2,
        .ro = 0xffffff03,
    },{ .name = "L0_TM_EYE_SURF0",  .addr = A_L0_TM_EYE_SURF0,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_EYE_SURF1",  .addr = A_L0_TM_EYE_SURF1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF2",  .addr = A_L0_TM_EYE_SURF2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF3",  .addr = A_L0_TM_EYE_SURF3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF4",  .addr = A_L0_TM_EYE_SURF4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF5",  .addr = A_L0_TM_EYE_SURF5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF6",  .addr = A_L0_TM_EYE_SURF6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF7",  .addr = A_L0_TM_EYE_SURF7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF8",  .addr = A_L0_TM_EYE_SURF8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EYE_SURF9",  .addr = A_L0_TM_EYE_SURF9,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SPARE",  .addr = A_L0_TM_SPARE,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_EQ1",  .addr = A_L0_TM_ANA_EQ1,
        .reset = 0xc,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_ANA_E_PI0",  .addr = A_L0_TM_ANA_E_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L0_TM_ANA_IQ_PI0",  .addr = A_L0_TM_ANA_IQ_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L0_TM_ANA_MISC0",  .addr = A_L0_TM_ANA_MISC0,
        .ro = 0xffffff3f,
    },{ .name = "L0_TM_SAMP_CODE_IQ_PH0",  .addr = A_L0_TM_SAMP_CODE_IQ_PH0,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_SAMP_CODE_IQ_PH90",  .addr = A_L0_TM_SAMP_CODE_IQ_PH90,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SAMP_CODE_IQ_PH180",  .addr = A_L0_TM_SAMP_CODE_IQ_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_SAMP_CODE_IQ_PH270",  .addr = A_L0_TM_SAMP_CODE_IQ_PH270,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SAMP_CODE_E_PH0",  .addr = A_L0_TM_SAMP_CODE_E_PH0,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_SAMP_CODE_E_PH180",  .addr = A_L0_TM_SAMP_CODE_E_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_IQ_ILL0",  .addr = A_L0_TM_IQ_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL1",  .addr = A_L0_TM_IQ_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL2",  .addr = A_L0_TM_IQ_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL3",  .addr = A_L0_TM_IQ_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL4",  .addr = A_L0_TM_IQ_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL5",  .addr = A_L0_TM_IQ_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL6",  .addr = A_L0_TM_IQ_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL7",  .addr = A_L0_TM_IQ_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL8",  .addr = A_L0_TM_IQ_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_IQ_ILL9",  .addr = A_L0_TM_IQ_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_IQ_ILL10",  .addr = A_L0_TM_IQ_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_E_ILL0",  .addr = A_L0_TM_E_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL1",  .addr = A_L0_TM_E_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL2",  .addr = A_L0_TM_E_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL3",  .addr = A_L0_TM_E_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL4",  .addr = A_L0_TM_E_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL5",  .addr = A_L0_TM_E_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL6",  .addr = A_L0_TM_E_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL7",  .addr = A_L0_TM_E_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL8",  .addr = A_L0_TM_E_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_E_ILL9",  .addr = A_L0_TM_E_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_E_ILL10",  .addr = A_L0_TM_E_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_EQ0",  .addr = A_L0_TM_EQ0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EQ1",  .addr = A_L0_TM_EQ1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EQ2",  .addr = A_L0_TM_EQ2,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_EQ3",  .addr = A_L0_TM_EQ3,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_EQ4",  .addr = A_L0_TM_EQ4,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_EQ5",  .addr = A_L0_TM_EQ5,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_EQ6",  .addr = A_L0_TM_EQ6,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_EQ7",  .addr = A_L0_TM_EQ7,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_EQ8",  .addr = A_L0_TM_EQ8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EQ9",  .addr = A_L0_TM_EQ9,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_EQ10",  .addr = A_L0_TM_EQ10,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_EQ11",  .addr = A_L0_TM_EQ11,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL7",  .addr = A_L0_TM_ILL7,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL8",  .addr = A_L0_TM_ILL8,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL9",  .addr = A_L0_TM_ILL9,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL10",  .addr = A_L0_TM_ILL10,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL11",  .addr = A_L0_TM_ILL11,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL12",  .addr = A_L0_TM_ILL12,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL13",  .addr = A_L0_TM_ILL13,
        .reset = 0x1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L0_TM_ILL14",  .addr = A_L0_TM_ILL14,
        .reset = 0x51,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_FRZ_FSM0",  .addr = A_L0_TM_FRZ_FSM0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_FRZ_FSM1",  .addr = A_L0_TM_FRZ_FSM1,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_RST_DLY",  .addr = A_L0_TM_RST_DLY,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ILL15",  .addr = A_L0_TM_ILL15,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_MISC3",  .addr = A_L0_TM_MISC3,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EQ_OFFS1",  .addr = A_L0_TM_EQ_OFFS1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SAMP0",  .addr = A_L0_TM_SAMP0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_EQ12",  .addr = A_L0_TM_EQ12,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_MISC4",  .addr = A_L0_TM_MISC4,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L0_TM_SAMP_STATUS0",  .addr = A_L0_TM_SAMP_STATUS0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_SAMP_STATUS1",  .addr = A_L0_TM_SAMP_STATUS1,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_SAMP_STATUS2",  .addr = A_L0_TM_SAMP_STATUS2,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_SAMP_STATUS3",  .addr = A_L0_TM_SAMP_STATUS3,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_SAMP_STATUS4",  .addr = A_L0_TM_SAMP_STATUS4,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_SAMP_STATUS5",  .addr = A_L0_TM_SAMP_STATUS5,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS0",  .addr = A_L0_TM_ILL_STATUS0,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS1",  .addr = A_L0_TM_ILL_STATUS1,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS2",  .addr = A_L0_TM_ILL_STATUS2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS3",  .addr = A_L0_TM_ILL_STATUS3,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS4",  .addr = A_L0_TM_ILL_STATUS4,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS5",  .addr = A_L0_TM_ILL_STATUS5,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS6",  .addr = A_L0_TM_ILL_STATUS6,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS7",  .addr = A_L0_TM_ILL_STATUS7,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS8",  .addr = A_L0_TM_ILL_STATUS8,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS9",  .addr = A_L0_TM_ILL_STATUS9,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS10",  .addr = A_L0_TM_ILL_STATUS10,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_ILL_STATUS11",  .addr = A_L0_TM_ILL_STATUS11,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_MISC_ST_0",  .addr = A_L0_TM_MISC_ST_0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_SD_ST_0",  .addr = A_L0_TM_SD_ST_0,
        .reset = 0x12,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_EYESURF_ST0",  .addr = A_L0_TM_EYESURF_ST0,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_EYESURF_ST1",  .addr = A_L0_TM_EYESURF_ST1,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_EQ_ST0",  .addr = A_L0_TM_EQ_ST0,
        .reset = 0xff,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_EQ_ST1",  .addr = A_L0_TM_EQ_ST1,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_EQ_ST2",  .addr = A_L0_TM_EQ_ST2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_RXPMA_ST1",  .addr = A_L0_TM_RXPMA_ST1,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_CDR0",  .addr = A_L0_TM_CDR0,
        .ro = 0xffffff60,
    },{ .name = "L0_TM_CDR1",  .addr = A_L0_TM_CDR1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR2",  .addr = A_L0_TM_CDR2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR3",  .addr = A_L0_TM_CDR3,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_CDR4",  .addr = A_L0_TM_CDR4,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_CDR5",  .addr = A_L0_TM_CDR5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR6",  .addr = A_L0_TM_CDR6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR7",  .addr = A_L0_TM_CDR7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR8",  .addr = A_L0_TM_CDR8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR9",  .addr = A_L0_TM_CDR9,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR10",  .addr = A_L0_TM_CDR10,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR11",  .addr = A_L0_TM_CDR11,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR12",  .addr = A_L0_TM_CDR12,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR13",  .addr = A_L0_TM_CDR13,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR14",  .addr = A_L0_TM_CDR14,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR15",  .addr = A_L0_TM_CDR15,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_CDR16",  .addr = A_L0_TM_CDR16,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR17",  .addr = A_L0_TM_CDR17,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR18",  .addr = A_L0_TM_CDR18,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR19",  .addr = A_L0_TM_CDR19,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR20",  .addr = A_L0_TM_CDR20,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR21",  .addr = A_L0_TM_CDR21,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR22",  .addr = A_L0_TM_CDR22,
        .ro = 0xffffffe0,
    },{ .name = "L0_TM_CDR23",  .addr = A_L0_TM_CDR23,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_MISC0",  .addr = A_L0_TM_MISC0,
        .ro = 0xfffffffc,
    },{ .name = "L0_TM_HSRX_ST0",  .addr = A_L0_TM_HSRX_ST0,
        .rsvd = 0xfe,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_PLL_LS_CLOCK",  .addr = A_L0_TM_PLL_LS_CLOCK,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_LOOP_FILT",  .addr = A_L0_TM_PLL_LOOP_FILT,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG2",  .addr = A_L0_TM_PLL_DIG2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_FBDIV",  .addr = A_L0_TM_PLL_FBDIV,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG4",  .addr = A_L0_TM_PLL_DIG4,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG5",  .addr = A_L0_TM_PLL_DIG5,
        .reset = 0xc0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG6",  .addr = A_L0_TM_PLL_DIG6,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG7",  .addr = A_L0_TM_PLL_DIG7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_CPUMP_CODE_1",  .addr = A_L0_TM_PLL_CPUMP_CODE_1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG9",  .addr = A_L0_TM_PLL_DIG9,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_PLL_COARSE_CODE_LSB",  .addr = A_L0_TM_PLL_COARSE_CODE_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG11",  .addr = A_L0_TM_PLL_DIG11,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG12",  .addr = A_L0_TM_PLL_DIG12,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_CONST_PMOS",  .addr = A_L0_TM_PLL_CONST_PMOS,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG14",  .addr = A_L0_TM_PLL_DIG14,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG15",  .addr = A_L0_TM_PLL_DIG15,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG16",  .addr = A_L0_TM_PLL_DIG16,
        .ro = 0xffffff10,
    },{ .name = "L0_TM_PLL_DIG17",  .addr = A_L0_TM_PLL_DIG17,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG18",  .addr = A_L0_TM_PLL_DIG18,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG19",  .addr = A_L0_TM_PLL_DIG19,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG20",  .addr = A_L0_TM_PLL_DIG20,
        .ro = 0xffffff40,
    },{ .name = "L0_TM_PLL_DIG21",  .addr = A_L0_TM_PLL_DIG21,
        .reset = 0x20,
        .ro = 0xffffff0c,
    },{ .name = "L0_TM_PLL_DIG22",  .addr = A_L0_TM_PLL_DIG22,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_PLL_DIG23",  .addr = A_L0_TM_PLL_DIG23,
        .reset = 0x31,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG24",  .addr = A_L0_TM_PLL_DIG24,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_PLL_DIG25",  .addr = A_L0_TM_PLL_DIG25,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG26",  .addr = A_L0_TM_PLL_DIG26,
        .reset = 0x40,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_PLL_CLK_DIST_NTRIM_LSB",  .addr = A_L0_TM_PLL_CLK_DIST_NTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_CLK_DIST_PTRIM_LSB",  .addr = A_L0_TM_PLL_CLK_DIST_PTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_29",  .addr = A_L0_TM_PLL_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_30",  .addr = A_L0_TM_PLL_DIG_30,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_31",  .addr = A_L0_TM_PLL_DIG_31,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_32",  .addr = A_L0_TM_PLL_DIG_32,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_33",  .addr = A_L0_TM_PLL_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_34",  .addr = A_L0_TM_PLL_DIG_34,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_PLL_DIG_35",  .addr = A_L0_TM_PLL_DIG_35,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_36",  .addr = A_L0_TM_PLL_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_DIG_37",  .addr = A_L0_TM_PLL_DIG_37,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PLL_COARSE_CODE_SAT_MSB",  .addr = A_L0_TM_PLL_COARSE_CODE_SAT_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_MPHY_CFG_HIB8",  .addr = A_L0_MPHY_CFG_HIB8,
        .ro = 0xfffffffe,
    },{ .name = "L0_MPHY_CFG_MODE",  .addr = A_L0_MPHY_CFG_MODE,
        .ro = 0xfffffffc,
    },{ .name = "L0_MPHY_CFG_HS_GEAR",  .addr = A_L0_MPHY_CFG_HS_GEAR,
        .ro = 0xfffffffc,
    },{ .name = "L0_MPHY_CFG_HS_RATE",  .addr = A_L0_MPHY_CFG_HS_RATE,
        .ro = 0xfffffffe,
    },{ .name = "L0_MPHY_CFG_PWM",  .addr = A_L0_MPHY_CFG_PWM,
        .ro = 0xfffffff8,
    },{ .name = "L0_PLL_OPDIV_LS",  .addr = A_L0_PLL_OPDIV_LS,
        .ro = 0xffffff00,
    },{ .name = "L0_MPHY_CFG_UPDT",  .addr = A_L0_MPHY_CFG_UPDT,
        .ro = 0xfffffffe,
    },{ .name = "L0_PLL_TM_DIV_CNTRLS",  .addr = A_L0_PLL_TM_DIV_CNTRLS,
        .reset = 0x40,
        .ro = 0xffffff20,
    },{ .name = "L0_PLL_FBDIV_G1A_LSB",  .addr = A_L0_PLL_FBDIV_G1A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G1B_LSB",  .addr = A_L0_PLL_FBDIV_G1B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G2A_LSB",  .addr = A_L0_PLL_FBDIV_G2A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G2B_LSB",  .addr = A_L0_PLL_FBDIV_G2B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G3A_LSB",  .addr = A_L0_PLL_FBDIV_G3A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G3B_LSB",  .addr = A_L0_PLL_FBDIV_G3B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G1A_MSB",  .addr = A_L0_PLL_FBDIV_G1A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G1B_MSB",  .addr = A_L0_PLL_FBDIV_G1B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G2A_MSB",  .addr = A_L0_PLL_FBDIV_G2A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G2B_MSB",  .addr = A_L0_PLL_FBDIV_G2B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G3A_MSB",  .addr = A_L0_PLL_FBDIV_G3A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_G3B_MSB",  .addr = A_L0_PLL_FBDIV_G3B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_IPDIV",  .addr = A_L0_PLL_IPDIV,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_FRAC_0_LSB",  .addr = A_L0_PLL_FBDIV_FRAC_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_FRAC_1",  .addr = A_L0_PLL_FBDIV_FRAC_1,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_FRAC_2",  .addr = A_L0_PLL_FBDIV_FRAC_2,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_FBDIV_FRAC_3_MSB",  .addr = A_L0_PLL_FBDIV_FRAC_3_MSB,
        .ro = 0xffffff98,
    },{ .name = "L0_PLL_PWR_SEQ_WAIT_TIME",  .addr = A_L0_PLL_PWR_SEQ_WAIT_TIME,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_SS_STEPS_0_LSB",  .addr = A_L0_PLL_SS_STEPS_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_SS_STEPS_1_MSB",  .addr = A_L0_PLL_SS_STEPS_1_MSB,
        .ro = 0xfffffff8,
    },{ .name = "L0_PLL_SS_STEP_SIZE_0_LSB",  .addr = A_L0_PLL_SS_STEP_SIZE_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_SS_STEP_SIZE_1",  .addr = A_L0_PLL_SS_STEP_SIZE_1,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_SS_STEP_SIZE_2",  .addr = A_L0_PLL_SS_STEP_SIZE_2,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_SS_STEP_SIZE_3_MSB",  .addr = A_L0_PLL_SS_STEP_SIZE_3_MSB,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_MASK_CFG_UPDT",  .addr = A_L0_TM_MASK_CFG_UPDT,
        .ro = 0xffffff80,
    },{ .name = "L0_PLL_TM_FORCE_DIV",  .addr = A_L0_PLL_TM_FORCE_DIV,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_1_LSB",  .addr = A_L0_PLL_TM_COARSE_CODE_1_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_2_LSB",  .addr = A_L0_PLL_TM_COARSE_CODE_2_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_3_LSB",  .addr = A_L0_PLL_TM_COARSE_CODE_3_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_4_LSB",  .addr = A_L0_PLL_TM_COARSE_CODE_4_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_5_LSB",  .addr = A_L0_PLL_TM_COARSE_CODE_5_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_6_LSB",  .addr = A_L0_PLL_TM_COARSE_CODE_6_LSB,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_COARSE_CODE_1_2_MSB",  .addr = A_L0_PLL_TM_COARSE_CODE_1_2_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L0_PLL_TM_COARSE_CODE_3_4_MSB",  .addr = A_L0_PLL_TM_COARSE_CODE_3_4_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L0_PLL_TM_COARSE_CODE_5_6_MSB",  .addr = A_L0_PLL_TM_COARSE_CODE_5_6_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L0_PLL_TM_SHARED_0",  .addr = A_L0_PLL_TM_SHARED_0,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_FRAC_OFFSET_0",  .addr = A_L0_PLL_TM_FRAC_OFFSET_0,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_FRAC_OFFSET_1",  .addr = A_L0_PLL_TM_FRAC_OFFSET_1,
        .ro = 0xffffff00,
    },{ .name = "L0_PLL_TM_FRAC_OFFSET_2",  .addr = A_L0_PLL_TM_FRAC_OFFSET_2,
        .ro = 0xfffffffc,
    },{ .name = "L0_PLL_STATUS_READ_0",  .addr = A_L0_PLL_STATUS_READ_0,
        .ro = 0xffffffff,
    },{ .name = "L0_PLL_STATUS_READ_1",  .addr = A_L0_PLL_STATUS_READ_1,
        .reset = 0x1 | R_L0_PLL_STATUS_READ_1_PLL_LOCK_STATUS_READ_MASK,
        .ro = 0xffffffff,
    },{ .name = "L0_TM_BG_PROG0",  .addr = A_L0_TM_BG_PROG0,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_BG_PROG1",  .addr = A_L0_TM_BG_PROG1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT0",  .addr = A_L0_TM_ANA_BG_TESTBIT0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT1",  .addr = A_L0_TM_ANA_BG_TESTBIT1,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT2",  .addr = A_L0_TM_ANA_BG_TESTBIT2,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT3",  .addr = A_L0_TM_ANA_BG_TESTBIT3,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT4",  .addr = A_L0_TM_ANA_BG_TESTBIT4,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT5",  .addr = A_L0_TM_ANA_BG_TESTBIT5,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT6",  .addr = A_L0_TM_ANA_BG_TESTBIT6,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT7",  .addr = A_L0_TM_ANA_BG_TESTBIT7,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT8",  .addr = A_L0_TM_ANA_BG_TESTBIT8,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT9",  .addr = A_L0_TM_ANA_BG_TESTBIT9,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT10",  .addr = A_L0_TM_ANA_BG_TESTBIT10,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT11",  .addr = A_L0_TM_ANA_BG_TESTBIT11,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT12",  .addr = A_L0_TM_ANA_BG_TESTBIT12,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT13",  .addr = A_L0_TM_ANA_BG_TESTBIT13,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT14",  .addr = A_L0_TM_ANA_BG_TESTBIT14,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT15",  .addr = A_L0_TM_ANA_BG_TESTBIT15,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT16",  .addr = A_L0_TM_ANA_BG_TESTBIT16,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT17",  .addr = A_L0_TM_ANA_BG_TESTBIT17,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT18",  .addr = A_L0_TM_ANA_BG_TESTBIT18,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT19",  .addr = A_L0_TM_ANA_BG_TESTBIT19,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_ANA_BG_TESTBIT20",  .addr = A_L0_TM_ANA_BG_TESTBIT20,
        .ro = 0xfffffffc,
    },{ .name = "L0_TM_BG_PROG2",  .addr = A_L0_TM_BG_PROG2,
        .ro = 0xffffffc0,
    },{ .name = "L0_L0_REF_CLK_SEL",  .addr = A_L0_L0_REF_CLK_SEL,
        .reset = 0x80,
        .ro = 0xffffff60,
    },{ .name = "L0_L1_REF_CLK_SEL",  .addr = A_L0_L1_REF_CLK_SEL,
        .reset = 0x80,
        .ro = 0xffffff60,
    },{ .name = "L0_L2_REF_CLK_SEL",  .addr = A_L0_L2_REF_CLK_SEL,
        .reset = 0x80,
        .ro = 0xffffff60,
    },{ .name = "L0_L3_REF_CLK_SEL",  .addr = A_L0_L3_REF_CLK_SEL,
        .reset = 0x80,
        .ro = 0xffffff60,
    },{ .name = "L0_L0_REF_CLK_PULLDN",  .addr = A_L0_L0_REF_CLK_PULLDN,
        .ro = 0xfffffff0,
    },{ .name = "L0_L1_REF_CLK_PULLDN",  .addr = A_L0_L1_REF_CLK_PULLDN,
        .ro = 0xfffffff0,
    },{ .name = "L0_L2_REF_CLK_PULLDN",  .addr = A_L0_L2_REF_CLK_PULLDN,
        .ro = 0xfffffff0,
    },{ .name = "L0_L3_REF_CLK_PULLDN",  .addr = A_L0_L3_REF_CLK_PULLDN,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_PG_CTRL0",  .addr = A_L0_TM_PG_CTRL0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PG_CTRL1",  .addr = A_L0_TM_PG_CTRL1,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_SLICER0_CTRL",  .addr = A_L0_TM_SLICER0_CTRL,
        .ro = 0xffffff80,
    },{ .name = "L0_TM_SLICER01_BIAS_PROG0",  .addr = A_L0_TM_SLICER01_BIAS_PROG0,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_SLICER01_BIAS_PROG1",  .addr = A_L0_TM_SLICER01_BIAS_PROG1,
        .ro = 0xfffffff0,
    },{ .name = "L0_TM_SLICER1_CTRL",  .addr = A_L0_TM_SLICER1_CTRL,
        .ro = 0xffffff81,
    },{ .name = "L0_TM_BG_IPTAT_PROG",  .addr = A_L0_TM_BG_IPTAT_PROG,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_PG_MUX_SEL",  .addr = A_L0_TM_PG_MUX_SEL,
        .ro = 0xffffffe0,
    },{ .name = "L0_BG_SLICER_SPARE",  .addr = A_L0_BG_SLICER_SPARE,
        .ro = 0xffffffc0,
    },{ .name = "L0_TM_1US_COUNT",  .addr = A_L0_TM_1US_COUNT,
        .reset = 0x28,
        .ro = 0xffffff00,
    },{ .name = "L0_TM_BG_SETTLING_TIME",  .addr = A_L0_TM_BG_SETTLING_TIME,
        .ro = 0xfffffff8,
    },{ .name = "L0_SLICER0_ENABLE",  .addr = A_L0_SLICER0_ENABLE,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "L0_SLICER1_ENABLE",  .addr = A_L0_SLICER1_ENABLE,
        .ro = 0xffffff00,
    },{ .name = "L0_SLICER0_BYPASS",  .addr = A_L0_SLICER0_BYPASS,
        .ro = 0xffffff98,
    },{ .name = "L0_SLICER1_BYPASS",  .addr = A_L0_SLICER1_BYPASS,
        .ro = 0xffffff18,
    },{ .name = "L0_BG_POWER_GOOD_STATUS",  .addr = A_L0_BG_POWER_GOOD_STATUS,
        .ro = 0xffffffff,
    },{ .name = "L0_SUPPLY_POWER_GOOD_STATUS",  .addr = A_L0_SUPPLY_POWER_GOOD_STATUS,
        .ro = 0xffffffff,
        .reset = 0x000000ff,
    },{ .name = "L0_BG_ISO_CTRL",  .addr = A_L0_BG_ISO_CTRL,
        .ro = 0xfffffffc,
    },{ .name = "L0_UPHY_GLOBAL_CTRL",  .addr = A_L0_UPHY_GLOBAL_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "L0_BIST_CTRL_1",  .addr = A_L0_BIST_CTRL_1,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_CTRL_2",  .addr = A_L0_BIST_CTRL_2,
        .ro = 0xfffffff8,
    },{ .name = "L0_BIST_RUN_LEN_L",  .addr = A_L0_BIST_RUN_LEN_L,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_ERR_INJ_POINT_L",  .addr = A_L0_BIST_ERR_INJ_POINT_L,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_RUNLEN_ERR_INJ_H",  .addr = A_L0_BIST_RUNLEN_ERR_INJ_H,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_IDLE_TIME",  .addr = A_L0_BIST_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_MARKER_L",  .addr = A_L0_BIST_MARKER_L,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_IDLE_CHAR_L",  .addr = A_L0_BIST_IDLE_CHAR_L,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_MARKER_IDLE_H",  .addr = A_L0_BIST_MARKER_IDLE_H,
        .ro = 0xffffffcc,
    },{ .name = "L0_BIST_LOW_PULSE_TIME",  .addr = A_L0_BIST_LOW_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_TOTAL_PULSE_TIME",  .addr = A_L0_BIST_TOTAL_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_TEST_PAT_1",  .addr = A_L0_BIST_TEST_PAT_1,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_TEST_PAT_2",  .addr = A_L0_BIST_TEST_PAT_2,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_TEST_PAT_3",  .addr = A_L0_BIST_TEST_PAT_3,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_TEST_PAT_4",  .addr = A_L0_BIST_TEST_PAT_4,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_TEST_PAT_MSBS",  .addr = A_L0_BIST_TEST_PAT_MSBS,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_PKT_NUM",  .addr = A_L0_BIST_PKT_NUM,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_FRM_IDLE_TIME",  .addr = A_L0_BIST_FRM_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_PKT_CTR_L",  .addr = A_L0_BIST_PKT_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L0_BIST_PKT_CTR_H",  .addr = A_L0_BIST_PKT_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L0_BIST_ERR_CTR_L",  .addr = A_L0_BIST_ERR_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L0_BIST_ERR_CTR_H",  .addr = A_L0_BIST_ERR_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L0_CLK_DIV_CNT",  .addr = A_L0_CLK_DIV_CNT,
        .reset = 0x19,
        .ro = 0xffffff00,
    },{ .name = "L0_DATA_BUS_WID",  .addr = A_L0_DATA_BUS_WID,
        .reset = 0x1,
        .ro = 0xffffff00,
    },{ .name = "L0_ANADIG_BYPASS",  .addr = A_L0_ANADIG_BYPASS,
        .ro = 0xffffff00,
    },{ .name = "L0_BIST_FILLER_OUT",  .addr = A_L0_BIST_FILLER_OUT,
        .reset = 0x1,
        .ro = 0xfffffffc,
    },{ .name = "L0_BIST_FORCE_MK_RST",  .addr = A_L0_BIST_FORCE_MK_RST,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L0_SPARE_IN",  .addr = A_L0_SPARE_IN,
        .ro = 0xffffffff,
    },{ .name = "L0_SPARE_OUT",  .addr = A_L0_SPARE_OUT,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_0",  .addr = A_L1_TX_ANA_TM_0,
        .reset = 0x28,
        .ro = 0xffffffc3,
    },{ .name = "L1_TX_ANA_TM_3",  .addr = A_L1_TX_ANA_TM_3,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_4",  .addr = A_L1_TX_ANA_TM_4,
        .ro = 0xffffff80,
    },{ .name = "L1_TX_ANA_TM_5",  .addr = A_L1_TX_ANA_TM_5,
        .ro = 0xffffff80,
    },{ .name = "L1_TX_ANA_TM_9",  .addr = A_L1_TX_ANA_TM_9,
        .reset = 0x3f,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_10",  .addr = A_L1_TX_ANA_TM_10,
        .reset = 0x30,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_13",  .addr = A_L1_TX_ANA_TM_13,
        .reset = 0x2,
        .ro = 0xfffffff0,
    },{ .name = "L1_TX_ANA_TM_14",  .addr = A_L1_TX_ANA_TM_14,
        .ro = 0xffffffcf,
    },{ .name = "L1_TX_ANA_TM_15",  .addr = A_L1_TX_ANA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_16",  .addr = A_L1_TX_ANA_TM_16,
        .ro = 0xfffffff0,
    },{ .name = "L1_TX_ANA_TM_18",  .addr = A_L1_TX_ANA_TM_18,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_19",  .addr = A_L1_TX_ANA_TM_19,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_20",  .addr = A_L1_TX_ANA_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L1_TX_ANA_TM_21",  .addr = A_L1_TX_ANA_TM_21,
        .ro = 0xffffffc0,
    },{ .name = "L1_TX_DIG_TM_61",  .addr = A_L1_TX_DIG_TM_61,
        .ro = 0xffffff34,
    },{ .name = "L1_TX_DIG_TM_62",  .addr = A_L1_TX_DIG_TM_62,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_65",  .addr = A_L1_TX_DIG_TM_65,
        .ro = 0xffffff01,
    },{ .name = "L1_TX_DIG_TM_67",  .addr = A_L1_TX_DIG_TM_67,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_68",  .addr = A_L1_TX_DIG_TM_68,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_69",  .addr = A_L1_TX_DIG_TM_69,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_76",  .addr = A_L1_TX_DIG_TM_76,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_77",  .addr = A_L1_TX_DIG_TM_77,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_78",  .addr = A_L1_TX_DIG_TM_78,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_79",  .addr = A_L1_TX_DIG_TM_79,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_80",  .addr = A_L1_TX_DIG_TM_80,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_81",  .addr = A_L1_TX_DIG_TM_81,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_82",  .addr = A_L1_TX_DIG_TM_82,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_83",  .addr = A_L1_TX_DIG_TM_83,
        .ro = 0xfffffff0,
    },{ .name = "L1_TX_DIG_TM_84",  .addr = A_L1_TX_DIG_TM_84,
        .ro = 0xffffff0a,
    },{ .name = "L1_TX_ANA_TM_85",  .addr = A_L1_TX_ANA_TM_85,
        .ro = 0xffffffca,
    },{ .name = "L1_TX_ANA_TM_87",  .addr = A_L1_TX_ANA_TM_87,
        .ro = 0xfffffff0,
    },{ .name = "L1_TX_ANA_TM_88",  .addr = A_L1_TX_ANA_TM_88,
        .reset = 0x96,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_89",  .addr = A_L1_TX_ANA_TM_89,
        .ro = 0xffffffd9,
    },{ .name = "L1_TX_ANA_TM_90",  .addr = A_L1_TX_ANA_TM_90,
        .ro = 0xffffffdf,
    },{ .name = "L1_TX_DIG_TM_91",  .addr = A_L1_TX_DIG_TM_91,
        .reset = 0x1a,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_92",  .addr = A_L1_TX_DIG_TM_92,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_95",  .addr = A_L1_TX_ANA_TM_95,
        .ro = 0xffffffc3,
    },{ .name = "L1_TX_ANA_TM_96",  .addr = A_L1_TX_ANA_TM_96,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_97",  .addr = A_L1_TX_ANA_TM_97,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_98",  .addr = A_L1_TX_DIG_TM_98,
        .ro = 0xffffffc0,
    },{ .name = "L1_TX_DIG_TM_99",  .addr = A_L1_TX_DIG_TM_99,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_100",  .addr = A_L1_TX_DIG_TM_100,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_101",  .addr = A_L1_TX_DIG_TM_101,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_102",  .addr = A_L1_TX_DIG_TM_102,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_103",  .addr = A_L1_TX_DIG_TM_103,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_104",  .addr = A_L1_TX_DIG_TM_104,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_105",  .addr = A_L1_TX_DIG_TM_105,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_106",  .addr = A_L1_TX_DIG_TM_106,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_107",  .addr = A_L1_TX_DIG_TM_107,
        .ro = 0xffffff80,
    },{ .name = "L1_TX_DIG_TM_108",  .addr = A_L1_TX_DIG_TM_108,
        .ro = 0xffffff80,
    },{ .name = "L1_TX_DIG_TM_109",  .addr = A_L1_TX_DIG_TM_109,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_110",  .addr = A_L1_TX_DIG_TM_110,
        .reset = 0x9,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_DIG_TM_111",  .addr = A_L1_TX_DIG_TM_111,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_112",  .addr = A_L1_TX_ANA_TM_112,
        .ro = 0xffffffc0,
    },{ .name = "L1_TX_ANA_TM_113",  .addr = A_L1_TX_ANA_TM_113,
        .ro = 0xffffff00,
    },{ .name = "L1_TX_ANA_TM_114",  .addr = A_L1_TX_ANA_TM_114,
        .ro = 0xffffffe0,
    },{ .name = "L1_TX_ANA_TM_115",  .addr = A_L1_TX_ANA_TM_115,
        .ro = 0xffffff80,
    },{ .name = "L1_TX_ANA_TM_116",  .addr = A_L1_TX_ANA_TM_116,
        .ro = 0xffffff80,
    },{ .name = "L1_TX_ANA_TM_117",  .addr = A_L1_TX_ANA_TM_117,
        .ro = 0xffffffc0,
    },{ .name = "L1_TX_ANA_TM_118",  .addr = A_L1_TX_ANA_TM_118,
        .ro = 0xfffffff0,
    },{ .name = "L1_TXPMA_TM_0",  .addr = A_L1_TXPMA_TM_0,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_1",  .addr = A_L1_TXPMA_TM_1,
        .ro = 0xfffffff0,
    },{ .name = "L1_TXPMA_TM_2",  .addr = A_L1_TXPMA_TM_2,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_3",  .addr = A_L1_TXPMA_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMA_TM_4",  .addr = A_L1_TXPMA_TM_4,
        .reset = 0x2,
        .ro = 0xffffff01,
    },{ .name = "L1_TXPMA_TM_5",  .addr = A_L1_TXPMA_TM_5,
        .ro = 0xfffffff0,
    },{ .name = "L1_TXPMA_TM_6",  .addr = A_L1_TXPMA_TM_6,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_7",  .addr = A_L1_TXPMA_TM_7,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_8",  .addr = A_L1_TXPMA_TM_8,
        .ro = 0xfffffffc,
    },{ .name = "L1_TXPMA_TM_9",  .addr = A_L1_TXPMA_TM_9,
        .ro = 0xffffff80,
    },{ .name = "L1_TXPMA_TM_10",  .addr = A_L1_TXPMA_TM_10,
        .ro = 0xffffffc0,
    },{ .name = "L1_TXPMA_TM_11",  .addr = A_L1_TXPMA_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMA_TM_12",  .addr = A_L1_TXPMA_TM_12,
        .ro = 0xffffff01,
    },{ .name = "L1_TXPMA_TM_13",  .addr = A_L1_TXPMA_TM_13,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_14",  .addr = A_L1_TXPMA_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMA_TM_15",  .addr = A_L1_TXPMA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_16",  .addr = A_L1_TXPMA_TM_16,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_17",  .addr = A_L1_TXPMA_TM_17,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_18",  .addr = A_L1_TXPMA_TM_18,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_19",  .addr = A_L1_TXPMA_TM_19,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L1_TXPMA_TM_20",  .addr = A_L1_TXPMA_TM_20,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_21",  .addr = A_L1_TXPMA_TM_21,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_22",  .addr = A_L1_TXPMA_TM_22,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_23",  .addr = A_L1_TXPMA_TM_23,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_24",  .addr = A_L1_TXPMA_TM_24,
        .ro = 0xffffff80,
    },{ .name = "L1_TXPMA_TM_25",  .addr = A_L1_TXPMA_TM_25,
        .ro = 0xffffffc0,
    },{ .name = "L1_TXPMA_TM_26",  .addr = A_L1_TXPMA_TM_26,
        .reset = 0x64,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_TM_27",  .addr = A_L1_TXPMA_TM_27,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMA_ST_0",  .addr = A_L1_TXPMA_ST_0,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_1",  .addr = A_L1_TXPMA_ST_1,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_2",  .addr = A_L1_TXPMA_ST_2,
        .reset = 0x4,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_3",  .addr = A_L1_TXPMA_ST_3,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_4",  .addr = A_L1_TXPMA_ST_4,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_5",  .addr = A_L1_TXPMA_ST_5,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_6",  .addr = A_L1_TXPMA_ST_6,
        .reset = 0xb,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_7",  .addr = A_L1_TXPMA_ST_7,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_8",  .addr = A_L1_TXPMA_ST_8,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMA_ST_9",  .addr = A_L1_TXPMA_ST_9,
        .ro = 0xffffffff,
    },{ .name = "L1_TXPMD_TM_0",  .addr = A_L1_TXPMD_TM_0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_1",  .addr = A_L1_TXPMD_TM_1,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_2",  .addr = A_L1_TXPMD_TM_2,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_3",  .addr = A_L1_TXPMD_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_4",  .addr = A_L1_TXPMD_TM_4,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_5",  .addr = A_L1_TXPMD_TM_5,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_6",  .addr = A_L1_TXPMD_TM_6,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_7",  .addr = A_L1_TXPMD_TM_7,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_8",  .addr = A_L1_TXPMD_TM_8,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_9",  .addr = A_L1_TXPMD_TM_9,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_10",  .addr = A_L1_TXPMD_TM_10,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_11",  .addr = A_L1_TXPMD_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_12",  .addr = A_L1_TXPMD_TM_12,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_13",  .addr = A_L1_TXPMD_TM_13,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_14",  .addr = A_L1_TXPMD_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_15",  .addr = A_L1_TXPMD_TM_15,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_16",  .addr = A_L1_TXPMD_TM_16,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_17",  .addr = A_L1_TXPMD_TM_17,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_18",  .addr = A_L1_TXPMD_TM_18,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_19",  .addr = A_L1_TXPMD_TM_19,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_20",  .addr = A_L1_TXPMD_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_21",  .addr = A_L1_TXPMD_TM_21,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_22",  .addr = A_L1_TXPMD_TM_22,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_23",  .addr = A_L1_TXPMD_TM_23,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_24",  .addr = A_L1_TXPMD_TM_24,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_25",  .addr = A_L1_TXPMD_TM_25,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_26",  .addr = A_L1_TXPMD_TM_26,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_27",  .addr = A_L1_TXPMD_TM_27,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_28",  .addr = A_L1_TXPMD_TM_28,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_29",  .addr = A_L1_TXPMD_TM_29,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_30",  .addr = A_L1_TXPMD_TM_30,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_31",  .addr = A_L1_TXPMD_TM_31,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_32",  .addr = A_L1_TXPMD_TM_32,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_33",  .addr = A_L1_TXPMD_TM_33,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_34",  .addr = A_L1_TXPMD_TM_34,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_35",  .addr = A_L1_TXPMD_TM_35,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_36",  .addr = A_L1_TXPMD_TM_36,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_37",  .addr = A_L1_TXPMD_TM_37,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_38",  .addr = A_L1_TXPMD_TM_38,
        .ro = 0xffffff80,
    },{ .name = "L1_TXPMD_TM_39",  .addr = A_L1_TXPMD_TM_39,
        .ro = 0xfffffff8,
    },{ .name = "L1_TXPMD_TM_40",  .addr = A_L1_TXPMD_TM_40,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_41",  .addr = A_L1_TXPMD_TM_41,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_42",  .addr = A_L1_TXPMD_TM_42,
        .ro = 0xffffffe0,
    },{ .name = "L1_TXPMD_TM_43",  .addr = A_L1_TXPMD_TM_43,
        .ro = 0xfffffff0,
    },{ .name = "L1_TXPMD_TM_44",  .addr = A_L1_TXPMD_TM_44,
        .ro = 0xffffffc0,
    },{ .name = "L1_TXPMD_TM_45",  .addr = A_L1_TXPMD_TM_45,
        .ro = 0xffffffc0,
    },{ .name = "L1_TXPMD_TM_46",  .addr = A_L1_TXPMD_TM_46,
        .ro = 0xffffffc0,
    },{ .name = "L1_TXPMD_TM_47",  .addr = A_L1_TXPMD_TM_47,
        .ro = 0xffffff00,
    },{ .name = "L1_TXPMD_TM_48",  .addr = A_L1_TXPMD_TM_48,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_ANA_BYP_1",  .addr = A_L1_TM_ANA_BYP_1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_2",  .addr = A_L1_TM_ANA_BYP_2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_3",  .addr = A_L1_TM_ANA_BYP_3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_4",  .addr = A_L1_TM_ANA_BYP_4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_5",  .addr = A_L1_TM_ANA_BYP_5,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_ANA_BYP_7",  .addr = A_L1_TM_ANA_BYP_7,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L1_TM_ANA_BYP_8",  .addr = A_L1_TM_ANA_BYP_8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_9",  .addr = A_L1_TM_ANA_BYP_9,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_10",  .addr = A_L1_TM_ANA_BYP_10,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_ANA_BYP_11",  .addr = A_L1_TM_ANA_BYP_11,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_ANA_BYP_12",  .addr = A_L1_TM_ANA_BYP_12,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_13",  .addr = A_L1_TM_ANA_BYP_13,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L1_TM_ANA_BYP_14",  .addr = A_L1_TM_ANA_BYP_14,
        .rsvd = 0xc,
        .ro = 0xffffff0c,
    },{ .name = "L1_TM_ANA_BYP_15",  .addr = A_L1_TM_ANA_BYP_15,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_16",  .addr = A_L1_TM_ANA_BYP_16,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_17",  .addr = A_L1_TM_ANA_BYP_17,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_ANA_BYP_18",  .addr = A_L1_TM_ANA_BYP_18,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L1_TM_ANA_BYP_20",  .addr = A_L1_TM_ANA_BYP_20,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_21",  .addr = A_L1_TM_ANA_BYP_21,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_22",  .addr = A_L1_TM_ANA_BYP_22,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_BYP_23",  .addr = A_L1_TM_ANA_BYP_23,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_1",  .addr = A_L1_TM_DIG_1,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_2",  .addr = A_L1_TM_DIG_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_3",  .addr = A_L1_TM_DIG_3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_4",  .addr = A_L1_TM_DIG_4,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L1_TM_DIG_5",  .addr = A_L1_TM_DIG_5,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L1_TM_DIG_6",  .addr = A_L1_TM_DIG_6,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_DIG_7",  .addr = A_L1_TM_DIG_7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_8",  .addr = A_L1_TM_DIG_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DIG_9",  .addr = A_L1_TM_DIG_9,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L1_TM_DIG_10",  .addr = A_L1_TM_DIG_10,
        .reset = 0x1,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L1_TM_DIG_11",  .addr = A_L1_TM_DIG_11,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L1_TM_DIG_12",  .addr = A_L1_TM_DIG_12,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_13",  .addr = A_L1_TM_DIG_13,
        .reset = 0x1a,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_DIG_14",  .addr = A_L1_TM_DIG_14,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L1_TM_DIG_15",  .addr = A_L1_TM_DIG_15,
        .reset = 0xd,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_16",  .addr = A_L1_TM_DIG_16,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DIG_17",  .addr = A_L1_TM_DIG_17,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DIG_18",  .addr = A_L1_TM_DIG_18,
        .reset = 0x2a,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_19",  .addr = A_L1_TM_DIG_19,
        .reset = 0x36,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_20",  .addr = A_L1_TM_DIG_20,
        .reset = 0x10,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_DIG_21",  .addr = A_L1_TM_DIG_21,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DIG_22",  .addr = A_L1_TM_DIG_22,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_23",  .addr = A_L1_TM_DIG_23,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_24",  .addr = A_L1_TM_DIG_24,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_25",  .addr = A_L1_TM_DIG_25,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_26",  .addr = A_L1_TM_DIG_26,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_27",  .addr = A_L1_TM_DIG_27,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_28",  .addr = A_L1_TM_DIG_28,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_29",  .addr = A_L1_TM_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_AUX_0",  .addr = A_L1_TM_AUX_0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_AUX_1",  .addr = A_L1_TM_AUX_1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_AUX_2",  .addr = A_L1_TM_AUX_2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_AUX_3",  .addr = A_L1_TM_AUX_3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_AUX_4",  .addr = A_L1_TM_AUX_4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_30",  .addr = A_L1_TM_DIG_30,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_31",  .addr = A_L1_TM_DIG_31,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_32",  .addr = A_L1_TM_DIG_32,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_33",  .addr = A_L1_TM_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_34",  .addr = A_L1_TM_DIG_34,
        .reset = 0x1e,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_35",  .addr = A_L1_TM_DIG_35,
        .reset = 0x18,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_DIG_36",  .addr = A_L1_TM_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DIG_37",  .addr = A_L1_TM_DIG_37,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_LFPS_1",  .addr = A_L1_TM_LFPS_1,
        .reset = 0x88,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_LFPS_2",  .addr = A_L1_TM_LFPS_2,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_LFPS_3",  .addr = A_L1_TM_LFPS_3,
        .reset = 0x6c,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_LFPS_4",  .addr = A_L1_TM_LFPS_4,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_RXPMA_1",  .addr = A_L1_TM_RXPMA_1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BSCAN_1",  .addr = A_L1_TM_BSCAN_1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L1_TM_MPHY_SQ_1",  .addr = A_L1_TM_MPHY_SQ_1,
        .reset = 0x1,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_LSRX_1",  .addr = A_L1_TM_LSRX_1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_LSRX_2",  .addr = A_L1_TM_LSRX_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_SIGDET_1",  .addr = A_L1_TM_SIGDET_1,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_SIGDET_2",  .addr = A_L1_TM_SIGDET_2,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DFT_1",  .addr = A_L1_TM_DFT_1,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L1_TM_DFT_2",  .addr = A_L1_TM_DFT_2,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L1_TM_DFT_3",  .addr = A_L1_TM_DFT_3,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DFT_4",  .addr = A_L1_TM_DFT_4,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L1_TM_DFT_5",  .addr = A_L1_TM_DFT_5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DFT_6",  .addr = A_L1_TM_DFT_6,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DFT_7",  .addr = A_L1_TM_DFT_7,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DFT_8",  .addr = A_L1_TM_DFT_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_DFT_9",  .addr = A_L1_TM_DFT_9,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_DFT_10",  .addr = A_L1_TM_DFT_10,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L1_TM_BG_1",  .addr = A_L1_TM_BG_1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_2",  .addr = A_L1_TM_BG_2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_3",  .addr = A_L1_TM_BG_3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_4",  .addr = A_L1_TM_BG_4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_5",  .addr = A_L1_TM_BG_5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_6",  .addr = A_L1_TM_BG_6,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_7",  .addr = A_L1_TM_BG_7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_8",  .addr = A_L1_TM_BG_8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_9",  .addr = A_L1_TM_BG_9,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_BG_10",  .addr = A_L1_TM_BG_10,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SD0",  .addr = A_L1_TM_SD0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SD1",  .addr = A_L1_TM_SD1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SD2",  .addr = A_L1_TM_SD2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SD3",  .addr = A_L1_TM_SD3,
        .reset = 0x4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SD4",  .addr = A_L1_TM_SD4,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_SD5",  .addr = A_L1_TM_SD5,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SD6",  .addr = A_L1_TM_SD6,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_MISC1",  .addr = A_L1_TM_MISC1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_MISC2",  .addr = A_L1_TM_MISC2,
        .ro = 0xffffff03,
    },{ .name = "L1_TM_EYE_SURF0",  .addr = A_L1_TM_EYE_SURF0,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_EYE_SURF1",  .addr = A_L1_TM_EYE_SURF1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF2",  .addr = A_L1_TM_EYE_SURF2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF3",  .addr = A_L1_TM_EYE_SURF3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF4",  .addr = A_L1_TM_EYE_SURF4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF5",  .addr = A_L1_TM_EYE_SURF5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF6",  .addr = A_L1_TM_EYE_SURF6,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF7",  .addr = A_L1_TM_EYE_SURF7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF8",  .addr = A_L1_TM_EYE_SURF8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EYE_SURF9",  .addr = A_L1_TM_EYE_SURF9,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SPARE",  .addr = A_L1_TM_SPARE,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ANA_EQ1",  .addr = A_L1_TM_ANA_EQ1,
        .reset = 0xc,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_ANA_E_PI0",  .addr = A_L1_TM_ANA_E_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L1_TM_ANA_IQ_PI0",  .addr = A_L1_TM_ANA_IQ_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L1_TM_ANA_MISC0",  .addr = A_L1_TM_ANA_MISC0,
        .ro = 0xffffff3f,
    },{ .name = "L1_TM_SAMP_CODE_IQ_PH0",  .addr = A_L1_TM_SAMP_CODE_IQ_PH0,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_SAMP_CODE_IQ_PH90",  .addr = A_L1_TM_SAMP_CODE_IQ_PH90,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SAMP_CODE_IQ_PH180",  .addr = A_L1_TM_SAMP_CODE_IQ_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_SAMP_CODE_IQ_PH270",  .addr = A_L1_TM_SAMP_CODE_IQ_PH270,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SAMP_CODE_E_PH0",  .addr = A_L1_TM_SAMP_CODE_E_PH0,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_SAMP_CODE_E_PH180",  .addr = A_L1_TM_SAMP_CODE_E_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_IQ_ILL0",  .addr = A_L1_TM_IQ_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL1",  .addr = A_L1_TM_IQ_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL2",  .addr = A_L1_TM_IQ_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL3",  .addr = A_L1_TM_IQ_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL4",  .addr = A_L1_TM_IQ_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL5",  .addr = A_L1_TM_IQ_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL6",  .addr = A_L1_TM_IQ_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL7",  .addr = A_L1_TM_IQ_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL8",  .addr = A_L1_TM_IQ_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_IQ_ILL9",  .addr = A_L1_TM_IQ_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L1_TM_IQ_ILL10",  .addr = A_L1_TM_IQ_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_E_ILL0",  .addr = A_L1_TM_E_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL1",  .addr = A_L1_TM_E_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL2",  .addr = A_L1_TM_E_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL3",  .addr = A_L1_TM_E_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL4",  .addr = A_L1_TM_E_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL5",  .addr = A_L1_TM_E_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL6",  .addr = A_L1_TM_E_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL7",  .addr = A_L1_TM_E_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL8",  .addr = A_L1_TM_E_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_E_ILL9",  .addr = A_L1_TM_E_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L1_TM_E_ILL10",  .addr = A_L1_TM_E_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_EQ0",  .addr = A_L1_TM_EQ0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EQ1",  .addr = A_L1_TM_EQ1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EQ2",  .addr = A_L1_TM_EQ2,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_EQ3",  .addr = A_L1_TM_EQ3,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_EQ4",  .addr = A_L1_TM_EQ4,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_EQ5",  .addr = A_L1_TM_EQ5,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_EQ6",  .addr = A_L1_TM_EQ6,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_EQ7",  .addr = A_L1_TM_EQ7,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_EQ8",  .addr = A_L1_TM_EQ8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EQ9",  .addr = A_L1_TM_EQ9,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_EQ10",  .addr = A_L1_TM_EQ10,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_EQ11",  .addr = A_L1_TM_EQ11,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL7",  .addr = A_L1_TM_ILL7,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL8",  .addr = A_L1_TM_ILL8,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL9",  .addr = A_L1_TM_ILL9,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL10",  .addr = A_L1_TM_ILL10,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL11",  .addr = A_L1_TM_ILL11,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL12",  .addr = A_L1_TM_ILL12,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL13",  .addr = A_L1_TM_ILL13,
        .reset = 0x1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L1_TM_ILL14",  .addr = A_L1_TM_ILL14,
        .reset = 0x51,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_FRZ_FSM0",  .addr = A_L1_TM_FRZ_FSM0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_FRZ_FSM1",  .addr = A_L1_TM_FRZ_FSM1,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_RST_DLY",  .addr = A_L1_TM_RST_DLY,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_ILL15",  .addr = A_L1_TM_ILL15,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_MISC3",  .addr = A_L1_TM_MISC3,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EQ_OFFS1",  .addr = A_L1_TM_EQ_OFFS1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_SAMP0",  .addr = A_L1_TM_SAMP0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_EQ12",  .addr = A_L1_TM_EQ12,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_MISC4",  .addr = A_L1_TM_MISC4,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L1_TM_SAMP_STATUS0",  .addr = A_L1_TM_SAMP_STATUS0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_SAMP_STATUS1",  .addr = A_L1_TM_SAMP_STATUS1,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_SAMP_STATUS2",  .addr = A_L1_TM_SAMP_STATUS2,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_SAMP_STATUS3",  .addr = A_L1_TM_SAMP_STATUS3,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_SAMP_STATUS4",  .addr = A_L1_TM_SAMP_STATUS4,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_SAMP_STATUS5",  .addr = A_L1_TM_SAMP_STATUS5,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS0",  .addr = A_L1_TM_ILL_STATUS0,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS1",  .addr = A_L1_TM_ILL_STATUS1,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS2",  .addr = A_L1_TM_ILL_STATUS2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS3",  .addr = A_L1_TM_ILL_STATUS3,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS4",  .addr = A_L1_TM_ILL_STATUS4,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS5",  .addr = A_L1_TM_ILL_STATUS5,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS6",  .addr = A_L1_TM_ILL_STATUS6,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS7",  .addr = A_L1_TM_ILL_STATUS7,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS8",  .addr = A_L1_TM_ILL_STATUS8,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS9",  .addr = A_L1_TM_ILL_STATUS9,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS10",  .addr = A_L1_TM_ILL_STATUS10,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_ILL_STATUS11",  .addr = A_L1_TM_ILL_STATUS11,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_MISC_ST_0",  .addr = A_L1_TM_MISC_ST_0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_SD_ST_0",  .addr = A_L1_TM_SD_ST_0,
        .reset = 0x12,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_EYESURF_ST0",  .addr = A_L1_TM_EYESURF_ST0,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_EYESURF_ST1",  .addr = A_L1_TM_EYESURF_ST1,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_EQ_ST0",  .addr = A_L1_TM_EQ_ST0,
        .reset = 0xff,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_EQ_ST1",  .addr = A_L1_TM_EQ_ST1,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_EQ_ST2",  .addr = A_L1_TM_EQ_ST2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_RXPMA_ST1",  .addr = A_L1_TM_RXPMA_ST1,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_CDR0",  .addr = A_L1_TM_CDR0,
        .ro = 0xffffff60,
    },{ .name = "L1_TM_CDR1",  .addr = A_L1_TM_CDR1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR2",  .addr = A_L1_TM_CDR2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR3",  .addr = A_L1_TM_CDR3,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_CDR4",  .addr = A_L1_TM_CDR4,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_CDR5",  .addr = A_L1_TM_CDR5,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR6",  .addr = A_L1_TM_CDR6,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR7",  .addr = A_L1_TM_CDR7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR8",  .addr = A_L1_TM_CDR8,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR9",  .addr = A_L1_TM_CDR9,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR10",  .addr = A_L1_TM_CDR10,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR11",  .addr = A_L1_TM_CDR11,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR12",  .addr = A_L1_TM_CDR12,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR13",  .addr = A_L1_TM_CDR13,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR14",  .addr = A_L1_TM_CDR14,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR15",  .addr = A_L1_TM_CDR15,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_CDR16",  .addr = A_L1_TM_CDR16,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR17",  .addr = A_L1_TM_CDR17,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR18",  .addr = A_L1_TM_CDR18,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR19",  .addr = A_L1_TM_CDR19,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR20",  .addr = A_L1_TM_CDR20,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR21",  .addr = A_L1_TM_CDR21,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR22",  .addr = A_L1_TM_CDR22,
        .ro = 0xffffffe0,
    },{ .name = "L1_TM_CDR23",  .addr = A_L1_TM_CDR23,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_MISC0",  .addr = A_L1_TM_MISC0,
        .ro = 0xfffffffc,
    },{ .name = "L1_TM_HSRX_ST0",  .addr = A_L1_TM_HSRX_ST0,
        .rsvd = 0xfe,
        .ro = 0xffffffff,
    },{ .name = "L1_TM_PLL_LS_CLOCK",  .addr = A_L1_TM_PLL_LS_CLOCK,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_LOOP_FILT",  .addr = A_L1_TM_PLL_LOOP_FILT,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG2",  .addr = A_L1_TM_PLL_DIG2,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_FBDIV",  .addr = A_L1_TM_PLL_FBDIV,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG4",  .addr = A_L1_TM_PLL_DIG4,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG5",  .addr = A_L1_TM_PLL_DIG5,
        .reset = 0xc0,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG6",  .addr = A_L1_TM_PLL_DIG6,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG7",  .addr = A_L1_TM_PLL_DIG7,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_CPUMP_CODE_1",  .addr = A_L1_TM_PLL_CPUMP_CODE_1,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG9",  .addr = A_L1_TM_PLL_DIG9,
        .ro = 0xffffffc0,
    },{ .name = "L1_TM_PLL_COARSE_CODE_LSB",  .addr = A_L1_TM_PLL_COARSE_CODE_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG11",  .addr = A_L1_TM_PLL_DIG11,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG12",  .addr = A_L1_TM_PLL_DIG12,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_CONST_PMOS",  .addr = A_L1_TM_PLL_CONST_PMOS,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG14",  .addr = A_L1_TM_PLL_DIG14,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG15",  .addr = A_L1_TM_PLL_DIG15,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG16",  .addr = A_L1_TM_PLL_DIG16,
        .ro = 0xffffff10,
    },{ .name = "L1_TM_PLL_DIG17",  .addr = A_L1_TM_PLL_DIG17,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG18",  .addr = A_L1_TM_PLL_DIG18,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG19",  .addr = A_L1_TM_PLL_DIG19,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG20",  .addr = A_L1_TM_PLL_DIG20,
        .ro = 0xffffff40,
    },{ .name = "L1_TM_PLL_DIG21",  .addr = A_L1_TM_PLL_DIG21,
        .reset = 0x20,
        .ro = 0xffffff0c,
    },{ .name = "L1_TM_PLL_DIG22",  .addr = A_L1_TM_PLL_DIG22,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_PLL_DIG23",  .addr = A_L1_TM_PLL_DIG23,
        .reset = 0x31,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG24",  .addr = A_L1_TM_PLL_DIG24,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_PLL_DIG25",  .addr = A_L1_TM_PLL_DIG25,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG26",  .addr = A_L1_TM_PLL_DIG26,
        .reset = 0x40,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_PLL_CLK_DIST_NTRIM_LSB",  .addr = A_L1_TM_PLL_CLK_DIST_NTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_CLK_DIST_PTRIM_LSB",  .addr = A_L1_TM_PLL_CLK_DIST_PTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_29",  .addr = A_L1_TM_PLL_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_30",  .addr = A_L1_TM_PLL_DIG_30,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_31",  .addr = A_L1_TM_PLL_DIG_31,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_32",  .addr = A_L1_TM_PLL_DIG_32,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_33",  .addr = A_L1_TM_PLL_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_34",  .addr = A_L1_TM_PLL_DIG_34,
        .ro = 0xffffff80,
    },{ .name = "L1_TM_PLL_DIG_35",  .addr = A_L1_TM_PLL_DIG_35,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_36",  .addr = A_L1_TM_PLL_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_DIG_37",  .addr = A_L1_TM_PLL_DIG_37,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_PLL_COARSE_CODE_SAT_MSB",  .addr = A_L1_TM_PLL_COARSE_CODE_SAT_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_MPHY_CFG_HIB8",  .addr = A_L1_MPHY_CFG_HIB8,
        .ro = 0xfffffffe,
    },{ .name = "L1_MPHY_CFG_MODE",  .addr = A_L1_MPHY_CFG_MODE,
        .ro = 0xfffffffc,
    },{ .name = "L1_MPHY_CFG_HS_GEAR",  .addr = A_L1_MPHY_CFG_HS_GEAR,
        .ro = 0xfffffffc,
    },{ .name = "L1_MPHY_CFG_HS_RATE",  .addr = A_L1_MPHY_CFG_HS_RATE,
        .ro = 0xfffffffe,
    },{ .name = "L1_MPHY_CFG_PWM",  .addr = A_L1_MPHY_CFG_PWM,
        .ro = 0xfffffff8,
    },{ .name = "L1_PLL_OPDIV_LS",  .addr = A_L1_PLL_OPDIV_LS,
        .ro = 0xffffff00,
    },{ .name = "L1_MPHY_CFG_UPDT",  .addr = A_L1_MPHY_CFG_UPDT,
        .ro = 0xfffffffe,
    },{ .name = "L1_PLL_TM_DIV_CNTRLS",  .addr = A_L1_PLL_TM_DIV_CNTRLS,
        .reset = 0x40,
        .ro = 0xffffff20,
    },{ .name = "L1_PLL_FBDIV_G1A_LSB",  .addr = A_L1_PLL_FBDIV_G1A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G1B_LSB",  .addr = A_L1_PLL_FBDIV_G1B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G2A_LSB",  .addr = A_L1_PLL_FBDIV_G2A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G2B_LSB",  .addr = A_L1_PLL_FBDIV_G2B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G3A_LSB",  .addr = A_L1_PLL_FBDIV_G3A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G3B_LSB",  .addr = A_L1_PLL_FBDIV_G3B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G1A_MSB",  .addr = A_L1_PLL_FBDIV_G1A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G1B_MSB",  .addr = A_L1_PLL_FBDIV_G1B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G2A_MSB",  .addr = A_L1_PLL_FBDIV_G2A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G2B_MSB",  .addr = A_L1_PLL_FBDIV_G2B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G3A_MSB",  .addr = A_L1_PLL_FBDIV_G3A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_G3B_MSB",  .addr = A_L1_PLL_FBDIV_G3B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_IPDIV",  .addr = A_L1_PLL_IPDIV,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_FRAC_0_LSB",  .addr = A_L1_PLL_FBDIV_FRAC_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_FRAC_1",  .addr = A_L1_PLL_FBDIV_FRAC_1,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_FRAC_2",  .addr = A_L1_PLL_FBDIV_FRAC_2,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_FBDIV_FRAC_3_MSB",  .addr = A_L1_PLL_FBDIV_FRAC_3_MSB,
        .ro = 0xffffff98,
    },{ .name = "L1_PLL_PWR_SEQ_WAIT_TIME",  .addr = A_L1_PLL_PWR_SEQ_WAIT_TIME,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_SS_STEPS_0_LSB",  .addr = A_L1_PLL_SS_STEPS_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_SS_STEPS_1_MSB",  .addr = A_L1_PLL_SS_STEPS_1_MSB,
        .ro = 0xfffffff8,
    },{ .name = "L1_PLL_SS_STEP_SIZE_0_LSB",  .addr = A_L1_PLL_SS_STEP_SIZE_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_SS_STEP_SIZE_1",  .addr = A_L1_PLL_SS_STEP_SIZE_1,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_SS_STEP_SIZE_2",  .addr = A_L1_PLL_SS_STEP_SIZE_2,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_SS_STEP_SIZE_3_MSB",  .addr = A_L1_PLL_SS_STEP_SIZE_3_MSB,
        .ro = 0xffffff00,
    },{ .name = "L1_TM_MASK_CFG_UPDT",  .addr = A_L1_TM_MASK_CFG_UPDT,
        .ro = 0xffffff80,
    },{ .name = "L1_PLL_TM_FORCE_DIV",  .addr = A_L1_PLL_TM_FORCE_DIV,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_1_LSB",  .addr = A_L1_PLL_TM_COARSE_CODE_1_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_2_LSB",  .addr = A_L1_PLL_TM_COARSE_CODE_2_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_3_LSB",  .addr = A_L1_PLL_TM_COARSE_CODE_3_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_4_LSB",  .addr = A_L1_PLL_TM_COARSE_CODE_4_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_5_LSB",  .addr = A_L1_PLL_TM_COARSE_CODE_5_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_6_LSB",  .addr = A_L1_PLL_TM_COARSE_CODE_6_LSB,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_COARSE_CODE_1_2_MSB",  .addr = A_L1_PLL_TM_COARSE_CODE_1_2_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L1_PLL_TM_COARSE_CODE_3_4_MSB",  .addr = A_L1_PLL_TM_COARSE_CODE_3_4_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L1_PLL_TM_COARSE_CODE_5_6_MSB",  .addr = A_L1_PLL_TM_COARSE_CODE_5_6_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L1_PLL_TM_SHARED_0",  .addr = A_L1_PLL_TM_SHARED_0,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_FRAC_OFFSET_0",  .addr = A_L1_PLL_TM_FRAC_OFFSET_0,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_FRAC_OFFSET_1",  .addr = A_L1_PLL_TM_FRAC_OFFSET_1,
        .ro = 0xffffff00,
    },{ .name = "L1_PLL_TM_FRAC_OFFSET_2",  .addr = A_L1_PLL_TM_FRAC_OFFSET_2,
        .ro = 0xfffffffc,
    },{ .name = "L1_PLL_STATUS_READ_0",  .addr = A_L1_PLL_STATUS_READ_0,
        .ro = 0xffffffff,
    },{ .name = "L1_PLL_STATUS_READ_1",  .addr = A_L1_PLL_STATUS_READ_1,
        .reset = 0x1 | R_L1_PLL_STATUS_READ_1_PLL_LOCK_STATUS_READ_MASK,
        .ro = 0xffffffff,
    },{ .name = "L1_UPHY_GLOBAL_CTRL",  .addr = A_L1_UPHY_GLOBAL_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "L1_BIST_CTRL_1",  .addr = A_L1_BIST_CTRL_1,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_CTRL_2",  .addr = A_L1_BIST_CTRL_2,
        .ro = 0xfffffff8,
    },{ .name = "L1_BIST_RUN_LEN_L",  .addr = A_L1_BIST_RUN_LEN_L,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_ERR_INJ_POINT_L",  .addr = A_L1_BIST_ERR_INJ_POINT_L,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_RUNLEN_ERR_INJ_H",  .addr = A_L1_BIST_RUNLEN_ERR_INJ_H,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_IDLE_TIME",  .addr = A_L1_BIST_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_MARKER_L",  .addr = A_L1_BIST_MARKER_L,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_IDLE_CHAR_L",  .addr = A_L1_BIST_IDLE_CHAR_L,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_MARKER_IDLE_H",  .addr = A_L1_BIST_MARKER_IDLE_H,
        .ro = 0xffffffcc,
    },{ .name = "L1_BIST_LOW_PULSE_TIME",  .addr = A_L1_BIST_LOW_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_TOTAL_PULSE_TIME",  .addr = A_L1_BIST_TOTAL_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_TEST_PAT_1",  .addr = A_L1_BIST_TEST_PAT_1,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_TEST_PAT_2",  .addr = A_L1_BIST_TEST_PAT_2,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_TEST_PAT_3",  .addr = A_L1_BIST_TEST_PAT_3,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_TEST_PAT_4",  .addr = A_L1_BIST_TEST_PAT_4,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_TEST_PAT_MSBS",  .addr = A_L1_BIST_TEST_PAT_MSBS,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_PKT_NUM",  .addr = A_L1_BIST_PKT_NUM,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_FRM_IDLE_TIME",  .addr = A_L1_BIST_FRM_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_PKT_CTR_L",  .addr = A_L1_BIST_PKT_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L1_BIST_PKT_CTR_H",  .addr = A_L1_BIST_PKT_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L1_BIST_ERR_CTR_L",  .addr = A_L1_BIST_ERR_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L1_BIST_ERR_CTR_H",  .addr = A_L1_BIST_ERR_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L1_CLK_DIV_CNT",  .addr = A_L1_CLK_DIV_CNT,
        .reset = 0x19,
        .ro = 0xffffff00,
    },{ .name = "L1_DATA_BUS_WID",  .addr = A_L1_DATA_BUS_WID,
        .reset = 0x1,
        .ro = 0xffffff00,
    },{ .name = "L1_ANADIG_BYPASS",  .addr = A_L1_ANADIG_BYPASS,
        .ro = 0xffffff00,
    },{ .name = "L1_BIST_FILLER_OUT",  .addr = A_L1_BIST_FILLER_OUT,
        .reset = 0x1,
        .ro = 0xfffffffc,
    },{ .name = "L1_BIST_FORCE_MK_RST",  .addr = A_L1_BIST_FORCE_MK_RST,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L1_SPARE_IN",  .addr = A_L1_SPARE_IN,
        .ro = 0xffffffff,
    },{ .name = "L1_SPARE_OUT",  .addr = A_L1_SPARE_OUT,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_0",  .addr = A_L2_TX_ANA_TM_0,
        .reset = 0x28,
        .ro = 0xffffffc3,
    },{ .name = "L2_TX_ANA_TM_3",  .addr = A_L2_TX_ANA_TM_3,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_4",  .addr = A_L2_TX_ANA_TM_4,
        .ro = 0xffffff80,
    },{ .name = "L2_TX_ANA_TM_5",  .addr = A_L2_TX_ANA_TM_5,
        .ro = 0xffffff80,
    },{ .name = "L2_TX_ANA_TM_9",  .addr = A_L2_TX_ANA_TM_9,
        .reset = 0x3f,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_10",  .addr = A_L2_TX_ANA_TM_10,
        .reset = 0x30,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_13",  .addr = A_L2_TX_ANA_TM_13,
        .reset = 0x2,
        .ro = 0xfffffff0,
    },{ .name = "L2_TX_ANA_TM_14",  .addr = A_L2_TX_ANA_TM_14,
        .ro = 0xffffffcf,
    },{ .name = "L2_TX_ANA_TM_15",  .addr = A_L2_TX_ANA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_16",  .addr = A_L2_TX_ANA_TM_16,
        .ro = 0xfffffff0,
    },{ .name = "L2_TX_ANA_TM_18",  .addr = A_L2_TX_ANA_TM_18,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_19",  .addr = A_L2_TX_ANA_TM_19,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_20",  .addr = A_L2_TX_ANA_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L2_TX_ANA_TM_21",  .addr = A_L2_TX_ANA_TM_21,
        .ro = 0xffffffc0,
    },{ .name = "L2_TX_DIG_TM_61",  .addr = A_L2_TX_DIG_TM_61,
        .ro = 0xffffff34,
    },{ .name = "L2_TX_DIG_TM_62",  .addr = A_L2_TX_DIG_TM_62,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_65",  .addr = A_L2_TX_DIG_TM_65,
        .ro = 0xffffff01,
    },{ .name = "L2_TX_DIG_TM_67",  .addr = A_L2_TX_DIG_TM_67,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_68",  .addr = A_L2_TX_DIG_TM_68,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_69",  .addr = A_L2_TX_DIG_TM_69,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_76",  .addr = A_L2_TX_DIG_TM_76,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_77",  .addr = A_L2_TX_DIG_TM_77,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_78",  .addr = A_L2_TX_DIG_TM_78,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_79",  .addr = A_L2_TX_DIG_TM_79,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_80",  .addr = A_L2_TX_DIG_TM_80,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_81",  .addr = A_L2_TX_DIG_TM_81,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_82",  .addr = A_L2_TX_DIG_TM_82,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_83",  .addr = A_L2_TX_DIG_TM_83,
        .ro = 0xfffffff0,
    },{ .name = "L2_TX_DIG_TM_84",  .addr = A_L2_TX_DIG_TM_84,
        .ro = 0xffffff0a,
    },{ .name = "L2_TX_ANA_TM_85",  .addr = A_L2_TX_ANA_TM_85,
        .ro = 0xffffffca,
    },{ .name = "L2_TX_ANA_TM_87",  .addr = A_L2_TX_ANA_TM_87,
        .ro = 0xfffffff0,
    },{ .name = "L2_TX_ANA_TM_88",  .addr = A_L2_TX_ANA_TM_88,
        .reset = 0x96,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_89",  .addr = A_L2_TX_ANA_TM_89,
        .ro = 0xffffffd9,
    },{ .name = "L2_TX_ANA_TM_90",  .addr = A_L2_TX_ANA_TM_90,
        .ro = 0xffffffdf,
    },{ .name = "L2_TX_DIG_TM_91",  .addr = A_L2_TX_DIG_TM_91,
        .reset = 0x1a,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_92",  .addr = A_L2_TX_DIG_TM_92,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_95",  .addr = A_L2_TX_ANA_TM_95,
        .ro = 0xffffffc3,
    },{ .name = "L2_TX_ANA_TM_96",  .addr = A_L2_TX_ANA_TM_96,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_97",  .addr = A_L2_TX_ANA_TM_97,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_98",  .addr = A_L2_TX_DIG_TM_98,
        .ro = 0xffffffc0,
    },{ .name = "L2_TX_DIG_TM_99",  .addr = A_L2_TX_DIG_TM_99,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_100",  .addr = A_L2_TX_DIG_TM_100,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_101",  .addr = A_L2_TX_DIG_TM_101,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_102",  .addr = A_L2_TX_DIG_TM_102,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_103",  .addr = A_L2_TX_DIG_TM_103,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_104",  .addr = A_L2_TX_DIG_TM_104,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_105",  .addr = A_L2_TX_DIG_TM_105,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_106",  .addr = A_L2_TX_DIG_TM_106,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_107",  .addr = A_L2_TX_DIG_TM_107,
        .ro = 0xffffff80,
    },{ .name = "L2_TX_DIG_TM_108",  .addr = A_L2_TX_DIG_TM_108,
        .ro = 0xffffff80,
    },{ .name = "L2_TX_DIG_TM_109",  .addr = A_L2_TX_DIG_TM_109,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_110",  .addr = A_L2_TX_DIG_TM_110,
        .reset = 0x9,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_DIG_TM_111",  .addr = A_L2_TX_DIG_TM_111,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_112",  .addr = A_L2_TX_ANA_TM_112,
        .ro = 0xffffffc0,
    },{ .name = "L2_TX_ANA_TM_113",  .addr = A_L2_TX_ANA_TM_113,
        .ro = 0xffffff00,
    },{ .name = "L2_TX_ANA_TM_114",  .addr = A_L2_TX_ANA_TM_114,
        .ro = 0xffffffe0,
    },{ .name = "L2_TX_ANA_TM_115",  .addr = A_L2_TX_ANA_TM_115,
        .ro = 0xffffff80,
    },{ .name = "L2_TX_ANA_TM_116",  .addr = A_L2_TX_ANA_TM_116,
        .ro = 0xffffff80,
    },{ .name = "L2_TX_ANA_TM_117",  .addr = A_L2_TX_ANA_TM_117,
        .ro = 0xffffffc0,
    },{ .name = "L2_TX_ANA_TM_118",  .addr = A_L2_TX_ANA_TM_118,
        .ro = 0xfffffff0,
    },{ .name = "L2_TXPMA_TM_0",  .addr = A_L2_TXPMA_TM_0,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_1",  .addr = A_L2_TXPMA_TM_1,
        .ro = 0xfffffff0,
    },{ .name = "L2_TXPMA_TM_2",  .addr = A_L2_TXPMA_TM_2,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_3",  .addr = A_L2_TXPMA_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMA_TM_4",  .addr = A_L2_TXPMA_TM_4,
        .reset = 0x2,
        .ro = 0xffffff01,
    },{ .name = "L2_TXPMA_TM_5",  .addr = A_L2_TXPMA_TM_5,
        .ro = 0xfffffff0,
    },{ .name = "L2_TXPMA_TM_6",  .addr = A_L2_TXPMA_TM_6,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_7",  .addr = A_L2_TXPMA_TM_7,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_8",  .addr = A_L2_TXPMA_TM_8,
        .ro = 0xfffffffc,
    },{ .name = "L2_TXPMA_TM_9",  .addr = A_L2_TXPMA_TM_9,
        .ro = 0xffffff80,
    },{ .name = "L2_TXPMA_TM_10",  .addr = A_L2_TXPMA_TM_10,
        .ro = 0xffffffc0,
    },{ .name = "L2_TXPMA_TM_11",  .addr = A_L2_TXPMA_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMA_TM_12",  .addr = A_L2_TXPMA_TM_12,
        .ro = 0xffffff01,
    },{ .name = "L2_TXPMA_TM_13",  .addr = A_L2_TXPMA_TM_13,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_14",  .addr = A_L2_TXPMA_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMA_TM_15",  .addr = A_L2_TXPMA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_16",  .addr = A_L2_TXPMA_TM_16,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_17",  .addr = A_L2_TXPMA_TM_17,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_18",  .addr = A_L2_TXPMA_TM_18,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_19",  .addr = A_L2_TXPMA_TM_19,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L2_TXPMA_TM_20",  .addr = A_L2_TXPMA_TM_20,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_21",  .addr = A_L2_TXPMA_TM_21,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_22",  .addr = A_L2_TXPMA_TM_22,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_23",  .addr = A_L2_TXPMA_TM_23,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_24",  .addr = A_L2_TXPMA_TM_24,
        .ro = 0xffffff80,
    },{ .name = "L2_TXPMA_TM_25",  .addr = A_L2_TXPMA_TM_25,
        .ro = 0xffffffc0,
    },{ .name = "L2_TXPMA_TM_26",  .addr = A_L2_TXPMA_TM_26,
        .reset = 0x64,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_TM_27",  .addr = A_L2_TXPMA_TM_27,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMA_ST_0",  .addr = A_L2_TXPMA_ST_0,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_1",  .addr = A_L2_TXPMA_ST_1,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_2",  .addr = A_L2_TXPMA_ST_2,
        .reset = 0x4,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_3",  .addr = A_L2_TXPMA_ST_3,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_4",  .addr = A_L2_TXPMA_ST_4,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_5",  .addr = A_L2_TXPMA_ST_5,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_6",  .addr = A_L2_TXPMA_ST_6,
        .reset = 0xb,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_7",  .addr = A_L2_TXPMA_ST_7,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_8",  .addr = A_L2_TXPMA_ST_8,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMA_ST_9",  .addr = A_L2_TXPMA_ST_9,
        .ro = 0xffffffff,
    },{ .name = "L2_TXPMD_TM_0",  .addr = A_L2_TXPMD_TM_0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_1",  .addr = A_L2_TXPMD_TM_1,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_2",  .addr = A_L2_TXPMD_TM_2,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_3",  .addr = A_L2_TXPMD_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_4",  .addr = A_L2_TXPMD_TM_4,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_5",  .addr = A_L2_TXPMD_TM_5,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_6",  .addr = A_L2_TXPMD_TM_6,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_7",  .addr = A_L2_TXPMD_TM_7,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_8",  .addr = A_L2_TXPMD_TM_8,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_9",  .addr = A_L2_TXPMD_TM_9,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_10",  .addr = A_L2_TXPMD_TM_10,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_11",  .addr = A_L2_TXPMD_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_12",  .addr = A_L2_TXPMD_TM_12,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_13",  .addr = A_L2_TXPMD_TM_13,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_14",  .addr = A_L2_TXPMD_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_15",  .addr = A_L2_TXPMD_TM_15,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_16",  .addr = A_L2_TXPMD_TM_16,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_17",  .addr = A_L2_TXPMD_TM_17,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_18",  .addr = A_L2_TXPMD_TM_18,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_19",  .addr = A_L2_TXPMD_TM_19,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_20",  .addr = A_L2_TXPMD_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_21",  .addr = A_L2_TXPMD_TM_21,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_22",  .addr = A_L2_TXPMD_TM_22,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_23",  .addr = A_L2_TXPMD_TM_23,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_24",  .addr = A_L2_TXPMD_TM_24,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_25",  .addr = A_L2_TXPMD_TM_25,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_26",  .addr = A_L2_TXPMD_TM_26,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_27",  .addr = A_L2_TXPMD_TM_27,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_28",  .addr = A_L2_TXPMD_TM_28,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_29",  .addr = A_L2_TXPMD_TM_29,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_30",  .addr = A_L2_TXPMD_TM_30,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_31",  .addr = A_L2_TXPMD_TM_31,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_32",  .addr = A_L2_TXPMD_TM_32,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_33",  .addr = A_L2_TXPMD_TM_33,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_34",  .addr = A_L2_TXPMD_TM_34,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_35",  .addr = A_L2_TXPMD_TM_35,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_36",  .addr = A_L2_TXPMD_TM_36,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_37",  .addr = A_L2_TXPMD_TM_37,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_38",  .addr = A_L2_TXPMD_TM_38,
        .ro = 0xffffff80,
    },{ .name = "L2_TXPMD_TM_39",  .addr = A_L2_TXPMD_TM_39,
        .ro = 0xfffffff8,
    },{ .name = "L2_TXPMD_TM_40",  .addr = A_L2_TXPMD_TM_40,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_41",  .addr = A_L2_TXPMD_TM_41,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_42",  .addr = A_L2_TXPMD_TM_42,
        .ro = 0xffffffe0,
    },{ .name = "L2_TXPMD_TM_43",  .addr = A_L2_TXPMD_TM_43,
        .ro = 0xfffffff0,
    },{ .name = "L2_TXPMD_TM_44",  .addr = A_L2_TXPMD_TM_44,
        .ro = 0xffffffc0,
    },{ .name = "L2_TXPMD_TM_45",  .addr = A_L2_TXPMD_TM_45,
        .ro = 0xffffffc0,
    },{ .name = "L2_TXPMD_TM_46",  .addr = A_L2_TXPMD_TM_46,
        .ro = 0xffffffc0,
    },{ .name = "L2_TXPMD_TM_47",  .addr = A_L2_TXPMD_TM_47,
        .ro = 0xffffff00,
    },{ .name = "L2_TXPMD_TM_48",  .addr = A_L2_TXPMD_TM_48,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_ANA_BYP_1",  .addr = A_L2_TM_ANA_BYP_1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_2",  .addr = A_L2_TM_ANA_BYP_2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_3",  .addr = A_L2_TM_ANA_BYP_3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_4",  .addr = A_L2_TM_ANA_BYP_4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_5",  .addr = A_L2_TM_ANA_BYP_5,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_ANA_BYP_7",  .addr = A_L2_TM_ANA_BYP_7,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L2_TM_ANA_BYP_8",  .addr = A_L2_TM_ANA_BYP_8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_9",  .addr = A_L2_TM_ANA_BYP_9,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_10",  .addr = A_L2_TM_ANA_BYP_10,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_ANA_BYP_11",  .addr = A_L2_TM_ANA_BYP_11,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_ANA_BYP_12",  .addr = A_L2_TM_ANA_BYP_12,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_13",  .addr = A_L2_TM_ANA_BYP_13,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L2_TM_ANA_BYP_14",  .addr = A_L2_TM_ANA_BYP_14,
        .rsvd = 0xc,
        .ro = 0xffffff0c,
    },{ .name = "L2_TM_ANA_BYP_15",  .addr = A_L2_TM_ANA_BYP_15,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_16",  .addr = A_L2_TM_ANA_BYP_16,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_17",  .addr = A_L2_TM_ANA_BYP_17,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_ANA_BYP_18",  .addr = A_L2_TM_ANA_BYP_18,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L2_TM_ANA_BYP_20",  .addr = A_L2_TM_ANA_BYP_20,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_21",  .addr = A_L2_TM_ANA_BYP_21,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_22",  .addr = A_L2_TM_ANA_BYP_22,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_BYP_23",  .addr = A_L2_TM_ANA_BYP_23,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_1",  .addr = A_L2_TM_DIG_1,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_2",  .addr = A_L2_TM_DIG_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_3",  .addr = A_L2_TM_DIG_3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_4",  .addr = A_L2_TM_DIG_4,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L2_TM_DIG_5",  .addr = A_L2_TM_DIG_5,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L2_TM_DIG_6",  .addr = A_L2_TM_DIG_6,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_DIG_7",  .addr = A_L2_TM_DIG_7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_8",  .addr = A_L2_TM_DIG_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DIG_9",  .addr = A_L2_TM_DIG_9,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L2_TM_DIG_10",  .addr = A_L2_TM_DIG_10,
        .reset = 0x1,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L2_TM_DIG_11",  .addr = A_L2_TM_DIG_11,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L2_TM_DIG_12",  .addr = A_L2_TM_DIG_12,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_13",  .addr = A_L2_TM_DIG_13,
        .reset = 0x1a,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_DIG_14",  .addr = A_L2_TM_DIG_14,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L2_TM_DIG_15",  .addr = A_L2_TM_DIG_15,
        .reset = 0xd,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_16",  .addr = A_L2_TM_DIG_16,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DIG_17",  .addr = A_L2_TM_DIG_17,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DIG_18",  .addr = A_L2_TM_DIG_18,
        .reset = 0x2a,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_19",  .addr = A_L2_TM_DIG_19,
        .reset = 0x36,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_20",  .addr = A_L2_TM_DIG_20,
        .reset = 0x10,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_DIG_21",  .addr = A_L2_TM_DIG_21,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DIG_22",  .addr = A_L2_TM_DIG_22,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_23",  .addr = A_L2_TM_DIG_23,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_24",  .addr = A_L2_TM_DIG_24,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_25",  .addr = A_L2_TM_DIG_25,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_26",  .addr = A_L2_TM_DIG_26,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_27",  .addr = A_L2_TM_DIG_27,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_28",  .addr = A_L2_TM_DIG_28,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_29",  .addr = A_L2_TM_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_AUX_0",  .addr = A_L2_TM_AUX_0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_AUX_1",  .addr = A_L2_TM_AUX_1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_AUX_2",  .addr = A_L2_TM_AUX_2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_AUX_3",  .addr = A_L2_TM_AUX_3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_AUX_4",  .addr = A_L2_TM_AUX_4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_30",  .addr = A_L2_TM_DIG_30,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_31",  .addr = A_L2_TM_DIG_31,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_32",  .addr = A_L2_TM_DIG_32,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_33",  .addr = A_L2_TM_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_34",  .addr = A_L2_TM_DIG_34,
        .reset = 0x1e,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_35",  .addr = A_L2_TM_DIG_35,
        .reset = 0x18,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_DIG_36",  .addr = A_L2_TM_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DIG_37",  .addr = A_L2_TM_DIG_37,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_LFPS_1",  .addr = A_L2_TM_LFPS_1,
        .reset = 0x88,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_LFPS_2",  .addr = A_L2_TM_LFPS_2,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_LFPS_3",  .addr = A_L2_TM_LFPS_3,
        .reset = 0x6c,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_LFPS_4",  .addr = A_L2_TM_LFPS_4,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_RXPMA_1",  .addr = A_L2_TM_RXPMA_1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BSCAN_1",  .addr = A_L2_TM_BSCAN_1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L2_TM_MPHY_SQ_1",  .addr = A_L2_TM_MPHY_SQ_1,
        .reset = 0x1,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_LSRX_1",  .addr = A_L2_TM_LSRX_1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_LSRX_2",  .addr = A_L2_TM_LSRX_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_SIGDET_1",  .addr = A_L2_TM_SIGDET_1,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_SIGDET_2",  .addr = A_L2_TM_SIGDET_2,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DFT_1",  .addr = A_L2_TM_DFT_1,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L2_TM_DFT_2",  .addr = A_L2_TM_DFT_2,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L2_TM_DFT_3",  .addr = A_L2_TM_DFT_3,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DFT_4",  .addr = A_L2_TM_DFT_4,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L2_TM_DFT_5",  .addr = A_L2_TM_DFT_5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DFT_6",  .addr = A_L2_TM_DFT_6,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DFT_7",  .addr = A_L2_TM_DFT_7,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DFT_8",  .addr = A_L2_TM_DFT_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_DFT_9",  .addr = A_L2_TM_DFT_9,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_DFT_10",  .addr = A_L2_TM_DFT_10,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L2_TM_BG_1",  .addr = A_L2_TM_BG_1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_2",  .addr = A_L2_TM_BG_2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_3",  .addr = A_L2_TM_BG_3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_4",  .addr = A_L2_TM_BG_4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_5",  .addr = A_L2_TM_BG_5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_6",  .addr = A_L2_TM_BG_6,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_7",  .addr = A_L2_TM_BG_7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_8",  .addr = A_L2_TM_BG_8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_9",  .addr = A_L2_TM_BG_9,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_BG_10",  .addr = A_L2_TM_BG_10,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SD0",  .addr = A_L2_TM_SD0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SD1",  .addr = A_L2_TM_SD1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SD2",  .addr = A_L2_TM_SD2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SD3",  .addr = A_L2_TM_SD3,
        .reset = 0x4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SD4",  .addr = A_L2_TM_SD4,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_SD5",  .addr = A_L2_TM_SD5,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SD6",  .addr = A_L2_TM_SD6,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_MISC1",  .addr = A_L2_TM_MISC1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_MISC2",  .addr = A_L2_TM_MISC2,
        .ro = 0xffffff03,
    },{ .name = "L2_TM_EYE_SURF0",  .addr = A_L2_TM_EYE_SURF0,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_EYE_SURF1",  .addr = A_L2_TM_EYE_SURF1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF2",  .addr = A_L2_TM_EYE_SURF2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF3",  .addr = A_L2_TM_EYE_SURF3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF4",  .addr = A_L2_TM_EYE_SURF4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF5",  .addr = A_L2_TM_EYE_SURF5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF6",  .addr = A_L2_TM_EYE_SURF6,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF7",  .addr = A_L2_TM_EYE_SURF7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF8",  .addr = A_L2_TM_EYE_SURF8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EYE_SURF9",  .addr = A_L2_TM_EYE_SURF9,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SPARE",  .addr = A_L2_TM_SPARE,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ANA_EQ1",  .addr = A_L2_TM_ANA_EQ1,
        .reset = 0xc,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_ANA_E_PI0",  .addr = A_L2_TM_ANA_E_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L2_TM_ANA_IQ_PI0",  .addr = A_L2_TM_ANA_IQ_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L2_TM_ANA_MISC0",  .addr = A_L2_TM_ANA_MISC0,
        .ro = 0xffffff3f,
    },{ .name = "L2_TM_SAMP_CODE_IQ_PH0",  .addr = A_L2_TM_SAMP_CODE_IQ_PH0,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_SAMP_CODE_IQ_PH90",  .addr = A_L2_TM_SAMP_CODE_IQ_PH90,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SAMP_CODE_IQ_PH180",  .addr = A_L2_TM_SAMP_CODE_IQ_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_SAMP_CODE_IQ_PH270",  .addr = A_L2_TM_SAMP_CODE_IQ_PH270,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SAMP_CODE_E_PH0",  .addr = A_L2_TM_SAMP_CODE_E_PH0,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_SAMP_CODE_E_PH180",  .addr = A_L2_TM_SAMP_CODE_E_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_IQ_ILL0",  .addr = A_L2_TM_IQ_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL1",  .addr = A_L2_TM_IQ_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL2",  .addr = A_L2_TM_IQ_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL3",  .addr = A_L2_TM_IQ_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL4",  .addr = A_L2_TM_IQ_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL5",  .addr = A_L2_TM_IQ_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL6",  .addr = A_L2_TM_IQ_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL7",  .addr = A_L2_TM_IQ_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL8",  .addr = A_L2_TM_IQ_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_IQ_ILL9",  .addr = A_L2_TM_IQ_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L2_TM_IQ_ILL10",  .addr = A_L2_TM_IQ_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_E_ILL0",  .addr = A_L2_TM_E_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL1",  .addr = A_L2_TM_E_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL2",  .addr = A_L2_TM_E_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL3",  .addr = A_L2_TM_E_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL4",  .addr = A_L2_TM_E_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL5",  .addr = A_L2_TM_E_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL6",  .addr = A_L2_TM_E_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL7",  .addr = A_L2_TM_E_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL8",  .addr = A_L2_TM_E_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_E_ILL9",  .addr = A_L2_TM_E_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L2_TM_E_ILL10",  .addr = A_L2_TM_E_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_EQ0",  .addr = A_L2_TM_EQ0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EQ1",  .addr = A_L2_TM_EQ1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EQ2",  .addr = A_L2_TM_EQ2,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_EQ3",  .addr = A_L2_TM_EQ3,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_EQ4",  .addr = A_L2_TM_EQ4,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_EQ5",  .addr = A_L2_TM_EQ5,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_EQ6",  .addr = A_L2_TM_EQ6,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_EQ7",  .addr = A_L2_TM_EQ7,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_EQ8",  .addr = A_L2_TM_EQ8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EQ9",  .addr = A_L2_TM_EQ9,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_EQ10",  .addr = A_L2_TM_EQ10,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_EQ11",  .addr = A_L2_TM_EQ11,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL7",  .addr = A_L2_TM_ILL7,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL8",  .addr = A_L2_TM_ILL8,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL9",  .addr = A_L2_TM_ILL9,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL10",  .addr = A_L2_TM_ILL10,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL11",  .addr = A_L2_TM_ILL11,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL12",  .addr = A_L2_TM_ILL12,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL13",  .addr = A_L2_TM_ILL13,
        .reset = 0x1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L2_TM_ILL14",  .addr = A_L2_TM_ILL14,
        .reset = 0x51,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_FRZ_FSM0",  .addr = A_L2_TM_FRZ_FSM0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_FRZ_FSM1",  .addr = A_L2_TM_FRZ_FSM1,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_RST_DLY",  .addr = A_L2_TM_RST_DLY,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_ILL15",  .addr = A_L2_TM_ILL15,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_MISC3",  .addr = A_L2_TM_MISC3,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EQ_OFFS1",  .addr = A_L2_TM_EQ_OFFS1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_SAMP0",  .addr = A_L2_TM_SAMP0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_EQ12",  .addr = A_L2_TM_EQ12,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_MISC4",  .addr = A_L2_TM_MISC4,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L2_TM_SAMP_STATUS0",  .addr = A_L2_TM_SAMP_STATUS0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_SAMP_STATUS1",  .addr = A_L2_TM_SAMP_STATUS1,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_SAMP_STATUS2",  .addr = A_L2_TM_SAMP_STATUS2,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_SAMP_STATUS3",  .addr = A_L2_TM_SAMP_STATUS3,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_SAMP_STATUS4",  .addr = A_L2_TM_SAMP_STATUS4,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_SAMP_STATUS5",  .addr = A_L2_TM_SAMP_STATUS5,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS0",  .addr = A_L2_TM_ILL_STATUS0,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS1",  .addr = A_L2_TM_ILL_STATUS1,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS2",  .addr = A_L2_TM_ILL_STATUS2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS3",  .addr = A_L2_TM_ILL_STATUS3,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS4",  .addr = A_L2_TM_ILL_STATUS4,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS5",  .addr = A_L2_TM_ILL_STATUS5,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS6",  .addr = A_L2_TM_ILL_STATUS6,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS7",  .addr = A_L2_TM_ILL_STATUS7,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS8",  .addr = A_L2_TM_ILL_STATUS8,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS9",  .addr = A_L2_TM_ILL_STATUS9,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS10",  .addr = A_L2_TM_ILL_STATUS10,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_ILL_STATUS11",  .addr = A_L2_TM_ILL_STATUS11,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_MISC_ST_0",  .addr = A_L2_TM_MISC_ST_0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_SD_ST_0",  .addr = A_L2_TM_SD_ST_0,
        .reset = 0x12,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_EYESURF_ST0",  .addr = A_L2_TM_EYESURF_ST0,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_EYESURF_ST1",  .addr = A_L2_TM_EYESURF_ST1,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_EQ_ST0",  .addr = A_L2_TM_EQ_ST0,
        .reset = 0xff,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_EQ_ST1",  .addr = A_L2_TM_EQ_ST1,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_EQ_ST2",  .addr = A_L2_TM_EQ_ST2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_RXPMA_ST1",  .addr = A_L2_TM_RXPMA_ST1,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_CDR0",  .addr = A_L2_TM_CDR0,
        .ro = 0xffffff60,
    },{ .name = "L2_TM_CDR1",  .addr = A_L2_TM_CDR1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR2",  .addr = A_L2_TM_CDR2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR3",  .addr = A_L2_TM_CDR3,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_CDR4",  .addr = A_L2_TM_CDR4,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_CDR5",  .addr = A_L2_TM_CDR5,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR6",  .addr = A_L2_TM_CDR6,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR7",  .addr = A_L2_TM_CDR7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR8",  .addr = A_L2_TM_CDR8,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR9",  .addr = A_L2_TM_CDR9,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR10",  .addr = A_L2_TM_CDR10,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR11",  .addr = A_L2_TM_CDR11,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR12",  .addr = A_L2_TM_CDR12,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR13",  .addr = A_L2_TM_CDR13,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR14",  .addr = A_L2_TM_CDR14,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR15",  .addr = A_L2_TM_CDR15,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_CDR16",  .addr = A_L2_TM_CDR16,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR17",  .addr = A_L2_TM_CDR17,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR18",  .addr = A_L2_TM_CDR18,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR19",  .addr = A_L2_TM_CDR19,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR20",  .addr = A_L2_TM_CDR20,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR21",  .addr = A_L2_TM_CDR21,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR22",  .addr = A_L2_TM_CDR22,
        .ro = 0xffffffe0,
    },{ .name = "L2_TM_CDR23",  .addr = A_L2_TM_CDR23,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_MISC0",  .addr = A_L2_TM_MISC0,
        .ro = 0xfffffffc,
    },{ .name = "L2_TM_HSRX_ST0",  .addr = A_L2_TM_HSRX_ST0,
        .rsvd = 0xfe,
        .ro = 0xffffffff,
    },{ .name = "L2_TM_PLL_LS_CLOCK",  .addr = A_L2_TM_PLL_LS_CLOCK,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_LOOP_FILT",  .addr = A_L2_TM_PLL_LOOP_FILT,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG2",  .addr = A_L2_TM_PLL_DIG2,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_FBDIV",  .addr = A_L2_TM_PLL_FBDIV,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG4",  .addr = A_L2_TM_PLL_DIG4,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG5",  .addr = A_L2_TM_PLL_DIG5,
        .reset = 0xc0,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG6",  .addr = A_L2_TM_PLL_DIG6,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG7",  .addr = A_L2_TM_PLL_DIG7,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_CPUMP_CODE_1",  .addr = A_L2_TM_PLL_CPUMP_CODE_1,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG9",  .addr = A_L2_TM_PLL_DIG9,
        .ro = 0xffffffc0,
    },{ .name = "L2_TM_PLL_COARSE_CODE_LSB",  .addr = A_L2_TM_PLL_COARSE_CODE_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG11",  .addr = A_L2_TM_PLL_DIG11,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG12",  .addr = A_L2_TM_PLL_DIG12,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_CONST_PMOS",  .addr = A_L2_TM_PLL_CONST_PMOS,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG14",  .addr = A_L2_TM_PLL_DIG14,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG15",  .addr = A_L2_TM_PLL_DIG15,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG16",  .addr = A_L2_TM_PLL_DIG16,
        .ro = 0xffffff10,
    },{ .name = "L2_TM_PLL_DIG17",  .addr = A_L2_TM_PLL_DIG17,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG18",  .addr = A_L2_TM_PLL_DIG18,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG19",  .addr = A_L2_TM_PLL_DIG19,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG20",  .addr = A_L2_TM_PLL_DIG20,
        .ro = 0xffffff40,
    },{ .name = "L2_TM_PLL_DIG21",  .addr = A_L2_TM_PLL_DIG21,
        .reset = 0x20,
        .ro = 0xffffff0c,
    },{ .name = "L2_TM_PLL_DIG22",  .addr = A_L2_TM_PLL_DIG22,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_PLL_DIG23",  .addr = A_L2_TM_PLL_DIG23,
        .reset = 0x31,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG24",  .addr = A_L2_TM_PLL_DIG24,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_PLL_DIG25",  .addr = A_L2_TM_PLL_DIG25,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG26",  .addr = A_L2_TM_PLL_DIG26,
        .reset = 0x40,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_PLL_CLK_DIST_NTRIM_LSB",  .addr = A_L2_TM_PLL_CLK_DIST_NTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_CLK_DIST_PTRIM_LSB",  .addr = A_L2_TM_PLL_CLK_DIST_PTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_29",  .addr = A_L2_TM_PLL_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_30",  .addr = A_L2_TM_PLL_DIG_30,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_31",  .addr = A_L2_TM_PLL_DIG_31,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_32",  .addr = A_L2_TM_PLL_DIG_32,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_33",  .addr = A_L2_TM_PLL_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_34",  .addr = A_L2_TM_PLL_DIG_34,
        .ro = 0xffffff80,
    },{ .name = "L2_TM_PLL_DIG_35",  .addr = A_L2_TM_PLL_DIG_35,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_36",  .addr = A_L2_TM_PLL_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_DIG_37",  .addr = A_L2_TM_PLL_DIG_37,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_PLL_COARSE_CODE_SAT_MSB",  .addr = A_L2_TM_PLL_COARSE_CODE_SAT_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_MPHY_CFG_HIB8",  .addr = A_L2_MPHY_CFG_HIB8,
        .ro = 0xfffffffe,
    },{ .name = "L2_MPHY_CFG_MODE",  .addr = A_L2_MPHY_CFG_MODE,
        .ro = 0xfffffffc,
    },{ .name = "L2_MPHY_CFG_HS_GEAR",  .addr = A_L2_MPHY_CFG_HS_GEAR,
        .ro = 0xfffffffc,
    },{ .name = "L2_MPHY_CFG_HS_RATE",  .addr = A_L2_MPHY_CFG_HS_RATE,
        .ro = 0xfffffffe,
    },{ .name = "L2_MPHY_CFG_PWM",  .addr = A_L2_MPHY_CFG_PWM,
        .ro = 0xfffffff8,
    },{ .name = "L2_PLL_OPDIV_LS",  .addr = A_L2_PLL_OPDIV_LS,
        .ro = 0xffffff00,
    },{ .name = "L2_MPHY_CFG_UPDT",  .addr = A_L2_MPHY_CFG_UPDT,
        .ro = 0xfffffffe,
    },{ .name = "L2_PLL_TM_DIV_CNTRLS",  .addr = A_L2_PLL_TM_DIV_CNTRLS,
        .reset = 0x40,
        .ro = 0xffffff20,
    },{ .name = "L2_PLL_FBDIV_G1A_LSB",  .addr = A_L2_PLL_FBDIV_G1A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G1B_LSB",  .addr = A_L2_PLL_FBDIV_G1B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G2A_LSB",  .addr = A_L2_PLL_FBDIV_G2A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G2B_LSB",  .addr = A_L2_PLL_FBDIV_G2B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G3A_LSB",  .addr = A_L2_PLL_FBDIV_G3A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G3B_LSB",  .addr = A_L2_PLL_FBDIV_G3B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G1A_MSB",  .addr = A_L2_PLL_FBDIV_G1A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G1B_MSB",  .addr = A_L2_PLL_FBDIV_G1B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G2A_MSB",  .addr = A_L2_PLL_FBDIV_G2A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G2B_MSB",  .addr = A_L2_PLL_FBDIV_G2B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G3A_MSB",  .addr = A_L2_PLL_FBDIV_G3A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_G3B_MSB",  .addr = A_L2_PLL_FBDIV_G3B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_IPDIV",  .addr = A_L2_PLL_IPDIV,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_FRAC_0_LSB",  .addr = A_L2_PLL_FBDIV_FRAC_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_FRAC_1",  .addr = A_L2_PLL_FBDIV_FRAC_1,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_FRAC_2",  .addr = A_L2_PLL_FBDIV_FRAC_2,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_FBDIV_FRAC_3_MSB",  .addr = A_L2_PLL_FBDIV_FRAC_3_MSB,
        .ro = 0xffffff98,
    },{ .name = "L2_PLL_PWR_SEQ_WAIT_TIME",  .addr = A_L2_PLL_PWR_SEQ_WAIT_TIME,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_SS_STEPS_0_LSB",  .addr = A_L2_PLL_SS_STEPS_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_SS_STEPS_1_MSB",  .addr = A_L2_PLL_SS_STEPS_1_MSB,
        .ro = 0xfffffff8,
    },{ .name = "L2_PLL_SS_STEP_SIZE_0_LSB",  .addr = A_L2_PLL_SS_STEP_SIZE_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_SS_STEP_SIZE_1",  .addr = A_L2_PLL_SS_STEP_SIZE_1,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_SS_STEP_SIZE_2",  .addr = A_L2_PLL_SS_STEP_SIZE_2,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_SS_STEP_SIZE_3_MSB",  .addr = A_L2_PLL_SS_STEP_SIZE_3_MSB,
        .ro = 0xffffff00,
    },{ .name = "L2_TM_MASK_CFG_UPDT",  .addr = A_L2_TM_MASK_CFG_UPDT,
        .ro = 0xffffff80,
    },{ .name = "L2_PLL_TM_FORCE_DIV",  .addr = A_L2_PLL_TM_FORCE_DIV,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_1_LSB",  .addr = A_L2_PLL_TM_COARSE_CODE_1_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_2_LSB",  .addr = A_L2_PLL_TM_COARSE_CODE_2_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_3_LSB",  .addr = A_L2_PLL_TM_COARSE_CODE_3_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_4_LSB",  .addr = A_L2_PLL_TM_COARSE_CODE_4_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_5_LSB",  .addr = A_L2_PLL_TM_COARSE_CODE_5_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_6_LSB",  .addr = A_L2_PLL_TM_COARSE_CODE_6_LSB,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_COARSE_CODE_1_2_MSB",  .addr = A_L2_PLL_TM_COARSE_CODE_1_2_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L2_PLL_TM_COARSE_CODE_3_4_MSB",  .addr = A_L2_PLL_TM_COARSE_CODE_3_4_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L2_PLL_TM_COARSE_CODE_5_6_MSB",  .addr = A_L2_PLL_TM_COARSE_CODE_5_6_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L2_PLL_TM_SHARED_0",  .addr = A_L2_PLL_TM_SHARED_0,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_FRAC_OFFSET_0",  .addr = A_L2_PLL_TM_FRAC_OFFSET_0,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_FRAC_OFFSET_1",  .addr = A_L2_PLL_TM_FRAC_OFFSET_1,
        .ro = 0xffffff00,
    },{ .name = "L2_PLL_TM_FRAC_OFFSET_2",  .addr = A_L2_PLL_TM_FRAC_OFFSET_2,
        .ro = 0xfffffffc,
    },{ .name = "L2_PLL_STATUS_READ_0",  .addr = A_L2_PLL_STATUS_READ_0,
        .ro = 0xffffffff,
    },{ .name = "L2_PLL_STATUS_READ_1",  .addr = A_L2_PLL_STATUS_READ_1,
        .reset = 0x1 | R_L2_PLL_STATUS_READ_1_PLL_LOCK_STATUS_READ_MASK,
        .ro = 0xffffffff,
    },{ .name = "L2_UPHY_GLOBAL_CTRL",  .addr = A_L2_UPHY_GLOBAL_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "L2_BIST_CTRL_1",  .addr = A_L2_BIST_CTRL_1,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_CTRL_2",  .addr = A_L2_BIST_CTRL_2,
        .ro = 0xfffffff8,
    },{ .name = "L2_BIST_RUN_LEN_L",  .addr = A_L2_BIST_RUN_LEN_L,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_ERR_INJ_POINT_L",  .addr = A_L2_BIST_ERR_INJ_POINT_L,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_RUNLEN_ERR_INJ_H",  .addr = A_L2_BIST_RUNLEN_ERR_INJ_H,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_IDLE_TIME",  .addr = A_L2_BIST_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_MARKER_L",  .addr = A_L2_BIST_MARKER_L,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_IDLE_CHAR_L",  .addr = A_L2_BIST_IDLE_CHAR_L,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_MARKER_IDLE_H",  .addr = A_L2_BIST_MARKER_IDLE_H,
        .ro = 0xffffffcc,
    },{ .name = "L2_BIST_LOW_PULSE_TIME",  .addr = A_L2_BIST_LOW_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_TOTAL_PULSE_TIME",  .addr = A_L2_BIST_TOTAL_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_TEST_PAT_1",  .addr = A_L2_BIST_TEST_PAT_1,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_TEST_PAT_2",  .addr = A_L2_BIST_TEST_PAT_2,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_TEST_PAT_3",  .addr = A_L2_BIST_TEST_PAT_3,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_TEST_PAT_4",  .addr = A_L2_BIST_TEST_PAT_4,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_TEST_PAT_MSBS",  .addr = A_L2_BIST_TEST_PAT_MSBS,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_PKT_NUM",  .addr = A_L2_BIST_PKT_NUM,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_FRM_IDLE_TIME",  .addr = A_L2_BIST_FRM_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_PKT_CTR_L",  .addr = A_L2_BIST_PKT_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L2_BIST_PKT_CTR_H",  .addr = A_L2_BIST_PKT_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L2_BIST_ERR_CTR_L",  .addr = A_L2_BIST_ERR_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L2_BIST_ERR_CTR_H",  .addr = A_L2_BIST_ERR_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L2_CLK_DIV_CNT",  .addr = A_L2_CLK_DIV_CNT,
        .reset = 0x19,
        .ro = 0xffffff00,
    },{ .name = "L2_DATA_BUS_WID",  .addr = A_L2_DATA_BUS_WID,
        .reset = 0x1,
        .ro = 0xffffff00,
    },{ .name = "L2_ANADIG_BYPASS",  .addr = A_L2_ANADIG_BYPASS,
        .ro = 0xffffff00,
    },{ .name = "L2_BIST_FILLER_OUT",  .addr = A_L2_BIST_FILLER_OUT,
        .reset = 0x1,
        .ro = 0xfffffffc,
    },{ .name = "L2_BIST_FORCE_MK_RST",  .addr = A_L2_BIST_FORCE_MK_RST,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L2_SPARE_IN",  .addr = A_L2_SPARE_IN,
        .ro = 0xffffffff,
    },{ .name = "L2_SPARE_OUT",  .addr = A_L2_SPARE_OUT,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_0",  .addr = A_L3_TX_ANA_TM_0,
        .reset = 0x28,
        .ro = 0xffffffc3,
    },{ .name = "L3_TX_ANA_TM_3",  .addr = A_L3_TX_ANA_TM_3,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_4",  .addr = A_L3_TX_ANA_TM_4,
        .ro = 0xffffff80,
    },{ .name = "L3_TX_ANA_TM_5",  .addr = A_L3_TX_ANA_TM_5,
        .ro = 0xffffff80,
    },{ .name = "L3_TX_ANA_TM_9",  .addr = A_L3_TX_ANA_TM_9,
        .reset = 0x3f,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_10",  .addr = A_L3_TX_ANA_TM_10,
        .reset = 0x30,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_13",  .addr = A_L3_TX_ANA_TM_13,
        .reset = 0x2,
        .ro = 0xfffffff0,
    },{ .name = "L3_TX_ANA_TM_14",  .addr = A_L3_TX_ANA_TM_14,
        .ro = 0xffffffcf,
    },{ .name = "L3_TX_ANA_TM_15",  .addr = A_L3_TX_ANA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_16",  .addr = A_L3_TX_ANA_TM_16,
        .ro = 0xfffffff0,
    },{ .name = "L3_TX_ANA_TM_18",  .addr = A_L3_TX_ANA_TM_18,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_19",  .addr = A_L3_TX_ANA_TM_19,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_20",  .addr = A_L3_TX_ANA_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L3_TX_ANA_TM_21",  .addr = A_L3_TX_ANA_TM_21,
        .ro = 0xffffffc0,
    },{ .name = "L3_TX_DIG_TM_61",  .addr = A_L3_TX_DIG_TM_61,
        .ro = 0xffffff34,
    },{ .name = "L3_TX_DIG_TM_62",  .addr = A_L3_TX_DIG_TM_62,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_65",  .addr = A_L3_TX_DIG_TM_65,
        .ro = 0xffffff01,
    },{ .name = "L3_TX_DIG_TM_67",  .addr = A_L3_TX_DIG_TM_67,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_68",  .addr = A_L3_TX_DIG_TM_68,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_69",  .addr = A_L3_TX_DIG_TM_69,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_76",  .addr = A_L3_TX_DIG_TM_76,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_77",  .addr = A_L3_TX_DIG_TM_77,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_78",  .addr = A_L3_TX_DIG_TM_78,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_79",  .addr = A_L3_TX_DIG_TM_79,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_80",  .addr = A_L3_TX_DIG_TM_80,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_81",  .addr = A_L3_TX_DIG_TM_81,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_82",  .addr = A_L3_TX_DIG_TM_82,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_83",  .addr = A_L3_TX_DIG_TM_83,
        .ro = 0xfffffff0,
    },{ .name = "L3_TX_DIG_TM_84",  .addr = A_L3_TX_DIG_TM_84,
        .ro = 0xffffff0a,
    },{ .name = "L3_TX_ANA_TM_85",  .addr = A_L3_TX_ANA_TM_85,
        .ro = 0xffffffca,
    },{ .name = "L3_TX_ANA_TM_87",  .addr = A_L3_TX_ANA_TM_87,
        .ro = 0xfffffff0,
    },{ .name = "L3_TX_ANA_TM_88",  .addr = A_L3_TX_ANA_TM_88,
        .reset = 0x96,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_89",  .addr = A_L3_TX_ANA_TM_89,
        .ro = 0xffffffd9,
    },{ .name = "L3_TX_ANA_TM_90",  .addr = A_L3_TX_ANA_TM_90,
        .ro = 0xffffffdf,
    },{ .name = "L3_TX_DIG_TM_91",  .addr = A_L3_TX_DIG_TM_91,
        .reset = 0x1a,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_92",  .addr = A_L3_TX_DIG_TM_92,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_95",  .addr = A_L3_TX_ANA_TM_95,
        .ro = 0xffffffc3,
    },{ .name = "L3_TX_ANA_TM_96",  .addr = A_L3_TX_ANA_TM_96,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_97",  .addr = A_L3_TX_ANA_TM_97,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_98",  .addr = A_L3_TX_DIG_TM_98,
        .ro = 0xffffffc0,
    },{ .name = "L3_TX_DIG_TM_99",  .addr = A_L3_TX_DIG_TM_99,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_100",  .addr = A_L3_TX_DIG_TM_100,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_101",  .addr = A_L3_TX_DIG_TM_101,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_102",  .addr = A_L3_TX_DIG_TM_102,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_103",  .addr = A_L3_TX_DIG_TM_103,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_104",  .addr = A_L3_TX_DIG_TM_104,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_105",  .addr = A_L3_TX_DIG_TM_105,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_106",  .addr = A_L3_TX_DIG_TM_106,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_107",  .addr = A_L3_TX_DIG_TM_107,
        .ro = 0xffffff80,
    },{ .name = "L3_TX_DIG_TM_108",  .addr = A_L3_TX_DIG_TM_108,
        .ro = 0xffffff80,
    },{ .name = "L3_TX_DIG_TM_109",  .addr = A_L3_TX_DIG_TM_109,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_110",  .addr = A_L3_TX_DIG_TM_110,
        .reset = 0x9,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_DIG_TM_111",  .addr = A_L3_TX_DIG_TM_111,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_112",  .addr = A_L3_TX_ANA_TM_112,
        .ro = 0xffffffc0,
    },{ .name = "L3_TX_ANA_TM_113",  .addr = A_L3_TX_ANA_TM_113,
        .ro = 0xffffff00,
    },{ .name = "L3_TX_ANA_TM_114",  .addr = A_L3_TX_ANA_TM_114,
        .ro = 0xffffffe0,
    },{ .name = "L3_TX_ANA_TM_115",  .addr = A_L3_TX_ANA_TM_115,
        .ro = 0xffffff80,
    },{ .name = "L3_TX_ANA_TM_116",  .addr = A_L3_TX_ANA_TM_116,
        .ro = 0xffffff80,
    },{ .name = "L3_TX_ANA_TM_117",  .addr = A_L3_TX_ANA_TM_117,
        .ro = 0xffffffc0,
    },{ .name = "L3_TX_ANA_TM_118",  .addr = A_L3_TX_ANA_TM_118,
        .ro = 0xfffffff0,
    },{ .name = "L3_TXPMA_TM_0",  .addr = A_L3_TXPMA_TM_0,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_1",  .addr = A_L3_TXPMA_TM_1,
        .ro = 0xfffffff0,
    },{ .name = "L3_TXPMA_TM_2",  .addr = A_L3_TXPMA_TM_2,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_3",  .addr = A_L3_TXPMA_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMA_TM_4",  .addr = A_L3_TXPMA_TM_4,
        .reset = 0x2,
        .ro = 0xffffff01,
    },{ .name = "L3_TXPMA_TM_5",  .addr = A_L3_TXPMA_TM_5,
        .ro = 0xfffffff0,
    },{ .name = "L3_TXPMA_TM_6",  .addr = A_L3_TXPMA_TM_6,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_7",  .addr = A_L3_TXPMA_TM_7,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_8",  .addr = A_L3_TXPMA_TM_8,
        .ro = 0xfffffffc,
    },{ .name = "L3_TXPMA_TM_9",  .addr = A_L3_TXPMA_TM_9,
        .ro = 0xffffff80,
    },{ .name = "L3_TXPMA_TM_10",  .addr = A_L3_TXPMA_TM_10,
        .ro = 0xffffffc0,
    },{ .name = "L3_TXPMA_TM_11",  .addr = A_L3_TXPMA_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMA_TM_12",  .addr = A_L3_TXPMA_TM_12,
        .ro = 0xffffff01,
    },{ .name = "L3_TXPMA_TM_13",  .addr = A_L3_TXPMA_TM_13,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_14",  .addr = A_L3_TXPMA_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMA_TM_15",  .addr = A_L3_TXPMA_TM_15,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_16",  .addr = A_L3_TXPMA_TM_16,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_17",  .addr = A_L3_TXPMA_TM_17,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_18",  .addr = A_L3_TXPMA_TM_18,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_19",  .addr = A_L3_TXPMA_TM_19,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L3_TXPMA_TM_20",  .addr = A_L3_TXPMA_TM_20,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_21",  .addr = A_L3_TXPMA_TM_21,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_22",  .addr = A_L3_TXPMA_TM_22,
        .reset = 0x6,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_23",  .addr = A_L3_TXPMA_TM_23,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_24",  .addr = A_L3_TXPMA_TM_24,
        .ro = 0xffffff80,
    },{ .name = "L3_TXPMA_TM_25",  .addr = A_L3_TXPMA_TM_25,
        .ro = 0xffffffc0,
    },{ .name = "L3_TXPMA_TM_26",  .addr = A_L3_TXPMA_TM_26,
        .reset = 0x64,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_TM_27",  .addr = A_L3_TXPMA_TM_27,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMA_ST_0",  .addr = A_L3_TXPMA_ST_0,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_1",  .addr = A_L3_TXPMA_ST_1,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_2",  .addr = A_L3_TXPMA_ST_2,
        .reset = 0x4,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_3",  .addr = A_L3_TXPMA_ST_3,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_4",  .addr = A_L3_TXPMA_ST_4,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_5",  .addr = A_L3_TXPMA_ST_5,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_6",  .addr = A_L3_TXPMA_ST_6,
        .reset = 0xb,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_7",  .addr = A_L3_TXPMA_ST_7,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_8",  .addr = A_L3_TXPMA_ST_8,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMA_ST_9",  .addr = A_L3_TXPMA_ST_9,
        .ro = 0xffffffff,
    },{ .name = "L3_TXPMD_TM_0",  .addr = A_L3_TXPMD_TM_0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_1",  .addr = A_L3_TXPMD_TM_1,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_2",  .addr = A_L3_TXPMD_TM_2,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_3",  .addr = A_L3_TXPMD_TM_3,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_4",  .addr = A_L3_TXPMD_TM_4,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_5",  .addr = A_L3_TXPMD_TM_5,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_6",  .addr = A_L3_TXPMD_TM_6,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_7",  .addr = A_L3_TXPMD_TM_7,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_8",  .addr = A_L3_TXPMD_TM_8,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_9",  .addr = A_L3_TXPMD_TM_9,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_10",  .addr = A_L3_TXPMD_TM_10,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_11",  .addr = A_L3_TXPMD_TM_11,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_12",  .addr = A_L3_TXPMD_TM_12,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_13",  .addr = A_L3_TXPMD_TM_13,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_14",  .addr = A_L3_TXPMD_TM_14,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_15",  .addr = A_L3_TXPMD_TM_15,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_16",  .addr = A_L3_TXPMD_TM_16,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_17",  .addr = A_L3_TXPMD_TM_17,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_18",  .addr = A_L3_TXPMD_TM_18,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_19",  .addr = A_L3_TXPMD_TM_19,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_20",  .addr = A_L3_TXPMD_TM_20,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_21",  .addr = A_L3_TXPMD_TM_21,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_22",  .addr = A_L3_TXPMD_TM_22,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_23",  .addr = A_L3_TXPMD_TM_23,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_24",  .addr = A_L3_TXPMD_TM_24,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_25",  .addr = A_L3_TXPMD_TM_25,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_26",  .addr = A_L3_TXPMD_TM_26,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_27",  .addr = A_L3_TXPMD_TM_27,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_28",  .addr = A_L3_TXPMD_TM_28,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_29",  .addr = A_L3_TXPMD_TM_29,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_30",  .addr = A_L3_TXPMD_TM_30,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_31",  .addr = A_L3_TXPMD_TM_31,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_32",  .addr = A_L3_TXPMD_TM_32,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_33",  .addr = A_L3_TXPMD_TM_33,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_34",  .addr = A_L3_TXPMD_TM_34,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_35",  .addr = A_L3_TXPMD_TM_35,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_36",  .addr = A_L3_TXPMD_TM_36,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_37",  .addr = A_L3_TXPMD_TM_37,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_38",  .addr = A_L3_TXPMD_TM_38,
        .ro = 0xffffff80,
    },{ .name = "L3_TXPMD_TM_39",  .addr = A_L3_TXPMD_TM_39,
        .ro = 0xfffffff8,
    },{ .name = "L3_TXPMD_TM_40",  .addr = A_L3_TXPMD_TM_40,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_41",  .addr = A_L3_TXPMD_TM_41,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_42",  .addr = A_L3_TXPMD_TM_42,
        .ro = 0xffffffe0,
    },{ .name = "L3_TXPMD_TM_43",  .addr = A_L3_TXPMD_TM_43,
        .ro = 0xfffffff0,
    },{ .name = "L3_TXPMD_TM_44",  .addr = A_L3_TXPMD_TM_44,
        .ro = 0xffffffc0,
    },{ .name = "L3_TXPMD_TM_45",  .addr = A_L3_TXPMD_TM_45,
        .ro = 0xffffffc0,
    },{ .name = "L3_TXPMD_TM_46",  .addr = A_L3_TXPMD_TM_46,
        .ro = 0xffffffc0,
    },{ .name = "L3_TXPMD_TM_47",  .addr = A_L3_TXPMD_TM_47,
        .ro = 0xffffff00,
    },{ .name = "L3_TXPMD_TM_48",  .addr = A_L3_TXPMD_TM_48,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_ANA_BYP_1",  .addr = A_L3_TM_ANA_BYP_1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_2",  .addr = A_L3_TM_ANA_BYP_2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_3",  .addr = A_L3_TM_ANA_BYP_3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_4",  .addr = A_L3_TM_ANA_BYP_4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_5",  .addr = A_L3_TM_ANA_BYP_5,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_ANA_BYP_7",  .addr = A_L3_TM_ANA_BYP_7,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L3_TM_ANA_BYP_8",  .addr = A_L3_TM_ANA_BYP_8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_9",  .addr = A_L3_TM_ANA_BYP_9,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_10",  .addr = A_L3_TM_ANA_BYP_10,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_ANA_BYP_11",  .addr = A_L3_TM_ANA_BYP_11,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_ANA_BYP_12",  .addr = A_L3_TM_ANA_BYP_12,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_13",  .addr = A_L3_TM_ANA_BYP_13,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L3_TM_ANA_BYP_14",  .addr = A_L3_TM_ANA_BYP_14,
        .rsvd = 0xc,
        .ro = 0xffffff0c,
    },{ .name = "L3_TM_ANA_BYP_15",  .addr = A_L3_TM_ANA_BYP_15,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_16",  .addr = A_L3_TM_ANA_BYP_16,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_17",  .addr = A_L3_TM_ANA_BYP_17,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_ANA_BYP_18",  .addr = A_L3_TM_ANA_BYP_18,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_ANA_BYP_20",  .addr = A_L3_TM_ANA_BYP_20,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_21",  .addr = A_L3_TM_ANA_BYP_21,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_22",  .addr = A_L3_TM_ANA_BYP_22,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_BYP_23",  .addr = A_L3_TM_ANA_BYP_23,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_1",  .addr = A_L3_TM_DIG_1,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_2",  .addr = A_L3_TM_DIG_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_3",  .addr = A_L3_TM_DIG_3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_4",  .addr = A_L3_TM_DIG_4,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L3_TM_DIG_5",  .addr = A_L3_TM_DIG_5,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L3_TM_DIG_6",  .addr = A_L3_TM_DIG_6,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_DIG_7",  .addr = A_L3_TM_DIG_7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_8",  .addr = A_L3_TM_DIG_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DIG_9",  .addr = A_L3_TM_DIG_9,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_DIG_10",  .addr = A_L3_TM_DIG_10,
        .reset = 0x1,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_DIG_11",  .addr = A_L3_TM_DIG_11,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L3_TM_DIG_12",  .addr = A_L3_TM_DIG_12,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_13",  .addr = A_L3_TM_DIG_13,
        .reset = 0x1a,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_DIG_14",  .addr = A_L3_TM_DIG_14,
        .rsvd = 0xf,
        .ro = 0xffffff0f,
    },{ .name = "L3_TM_DIG_15",  .addr = A_L3_TM_DIG_15,
        .reset = 0xd,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_16",  .addr = A_L3_TM_DIG_16,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DIG_17",  .addr = A_L3_TM_DIG_17,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DIG_18",  .addr = A_L3_TM_DIG_18,
        .reset = 0x2a,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_19",  .addr = A_L3_TM_DIG_19,
        .reset = 0x36,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_20",  .addr = A_L3_TM_DIG_20,
        .reset = 0x10,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_DIG_21",  .addr = A_L3_TM_DIG_21,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DIG_22",  .addr = A_L3_TM_DIG_22,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_23",  .addr = A_L3_TM_DIG_23,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_24",  .addr = A_L3_TM_DIG_24,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_25",  .addr = A_L3_TM_DIG_25,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_26",  .addr = A_L3_TM_DIG_26,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_27",  .addr = A_L3_TM_DIG_27,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_28",  .addr = A_L3_TM_DIG_28,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_29",  .addr = A_L3_TM_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_AUX_0",  .addr = A_L3_TM_AUX_0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_AUX_1",  .addr = A_L3_TM_AUX_1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_AUX_2",  .addr = A_L3_TM_AUX_2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_AUX_3",  .addr = A_L3_TM_AUX_3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_AUX_4",  .addr = A_L3_TM_AUX_4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_30",  .addr = A_L3_TM_DIG_30,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_31",  .addr = A_L3_TM_DIG_31,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_32",  .addr = A_L3_TM_DIG_32,
        .reset = 0xfa,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_33",  .addr = A_L3_TM_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_34",  .addr = A_L3_TM_DIG_34,
        .reset = 0x1e,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_35",  .addr = A_L3_TM_DIG_35,
        .reset = 0x18,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_DIG_36",  .addr = A_L3_TM_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DIG_37",  .addr = A_L3_TM_DIG_37,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_LFPS_1",  .addr = A_L3_TM_LFPS_1,
        .reset = 0x88,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_LFPS_2",  .addr = A_L3_TM_LFPS_2,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_LFPS_3",  .addr = A_L3_TM_LFPS_3,
        .reset = 0x6c,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_LFPS_4",  .addr = A_L3_TM_LFPS_4,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_RXPMA_1",  .addr = A_L3_TM_RXPMA_1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BSCAN_1",  .addr = A_L3_TM_BSCAN_1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L3_TM_MPHY_SQ_1",  .addr = A_L3_TM_MPHY_SQ_1,
        .reset = 0x1,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_LSRX_1",  .addr = A_L3_TM_LSRX_1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_LSRX_2",  .addr = A_L3_TM_LSRX_2,
        .rsvd = 0xc0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_SIGDET_1",  .addr = A_L3_TM_SIGDET_1,
        .reset = 0x34,
        .rsvd = 0x80,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_SIGDET_2",  .addr = A_L3_TM_SIGDET_2,
        .reset = 0xf,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DFT_1",  .addr = A_L3_TM_DFT_1,
        .rsvd = 0x7,
        .ro = 0xffffff07,
    },{ .name = "L3_TM_DFT_2",  .addr = A_L3_TM_DFT_2,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L3_TM_DFT_3",  .addr = A_L3_TM_DFT_3,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DFT_4",  .addr = A_L3_TM_DFT_4,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L3_TM_DFT_5",  .addr = A_L3_TM_DFT_5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DFT_6",  .addr = A_L3_TM_DFT_6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DFT_7",  .addr = A_L3_TM_DFT_7,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DFT_8",  .addr = A_L3_TM_DFT_8,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_DFT_9",  .addr = A_L3_TM_DFT_9,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_DFT_10",  .addr = A_L3_TM_DFT_10,
        .rsvd = 0xf0,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_BG_1",  .addr = A_L3_TM_BG_1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_2",  .addr = A_L3_TM_BG_2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_3",  .addr = A_L3_TM_BG_3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_4",  .addr = A_L3_TM_BG_4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_5",  .addr = A_L3_TM_BG_5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_6",  .addr = A_L3_TM_BG_6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_7",  .addr = A_L3_TM_BG_7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_8",  .addr = A_L3_TM_BG_8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_9",  .addr = A_L3_TM_BG_9,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_BG_10",  .addr = A_L3_TM_BG_10,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SD0",  .addr = A_L3_TM_SD0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SD1",  .addr = A_L3_TM_SD1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SD2",  .addr = A_L3_TM_SD2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SD3",  .addr = A_L3_TM_SD3,
        .reset = 0x4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SD4",  .addr = A_L3_TM_SD4,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_SD5",  .addr = A_L3_TM_SD5,
        .reset = 0xa,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SD6",  .addr = A_L3_TM_SD6,
        .rsvd = 0xe0,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_MISC1",  .addr = A_L3_TM_MISC1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_MISC2",  .addr = A_L3_TM_MISC2,
        .ro = 0xffffff03,
    },{ .name = "L3_TM_EYE_SURF0",  .addr = A_L3_TM_EYE_SURF0,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_EYE_SURF1",  .addr = A_L3_TM_EYE_SURF1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF2",  .addr = A_L3_TM_EYE_SURF2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF3",  .addr = A_L3_TM_EYE_SURF3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF4",  .addr = A_L3_TM_EYE_SURF4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF5",  .addr = A_L3_TM_EYE_SURF5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF6",  .addr = A_L3_TM_EYE_SURF6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF7",  .addr = A_L3_TM_EYE_SURF7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF8",  .addr = A_L3_TM_EYE_SURF8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EYE_SURF9",  .addr = A_L3_TM_EYE_SURF9,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SPARE",  .addr = A_L3_TM_SPARE,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ANA_EQ1",  .addr = A_L3_TM_ANA_EQ1,
        .reset = 0xc,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_ANA_E_PI0",  .addr = A_L3_TM_ANA_E_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L3_TM_ANA_IQ_PI0",  .addr = A_L3_TM_ANA_IQ_PI0,
        .reset = 0xa0,
        .ro = 0xffffff1f,
    },{ .name = "L3_TM_ANA_MISC0",  .addr = A_L3_TM_ANA_MISC0,
        .ro = 0xffffff3f,
    },{ .name = "L3_TM_SAMP_CODE_IQ_PH0",  .addr = A_L3_TM_SAMP_CODE_IQ_PH0,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_SAMP_CODE_IQ_PH90",  .addr = A_L3_TM_SAMP_CODE_IQ_PH90,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SAMP_CODE_IQ_PH180",  .addr = A_L3_TM_SAMP_CODE_IQ_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_SAMP_CODE_IQ_PH270",  .addr = A_L3_TM_SAMP_CODE_IQ_PH270,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SAMP_CODE_E_PH0",  .addr = A_L3_TM_SAMP_CODE_E_PH0,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_SAMP_CODE_E_PH180",  .addr = A_L3_TM_SAMP_CODE_E_PH180,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_IQ_ILL0",  .addr = A_L3_TM_IQ_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL1",  .addr = A_L3_TM_IQ_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL2",  .addr = A_L3_TM_IQ_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL3",  .addr = A_L3_TM_IQ_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL4",  .addr = A_L3_TM_IQ_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL5",  .addr = A_L3_TM_IQ_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL6",  .addr = A_L3_TM_IQ_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL7",  .addr = A_L3_TM_IQ_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL8",  .addr = A_L3_TM_IQ_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_IQ_ILL9",  .addr = A_L3_TM_IQ_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_IQ_ILL10",  .addr = A_L3_TM_IQ_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_E_ILL0",  .addr = A_L3_TM_E_ILL0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL1",  .addr = A_L3_TM_E_ILL1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL2",  .addr = A_L3_TM_E_ILL2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL3",  .addr = A_L3_TM_E_ILL3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL4",  .addr = A_L3_TM_E_ILL4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL5",  .addr = A_L3_TM_E_ILL5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL6",  .addr = A_L3_TM_E_ILL6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL7",  .addr = A_L3_TM_E_ILL7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL8",  .addr = A_L3_TM_E_ILL8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_E_ILL9",  .addr = A_L3_TM_E_ILL9,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_E_ILL10",  .addr = A_L3_TM_E_ILL10,
        .reset = 0x3,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_EQ0",  .addr = A_L3_TM_EQ0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EQ1",  .addr = A_L3_TM_EQ1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EQ2",  .addr = A_L3_TM_EQ2,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_EQ3",  .addr = A_L3_TM_EQ3,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_EQ4",  .addr = A_L3_TM_EQ4,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_EQ5",  .addr = A_L3_TM_EQ5,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_EQ6",  .addr = A_L3_TM_EQ6,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_EQ7",  .addr = A_L3_TM_EQ7,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_EQ8",  .addr = A_L3_TM_EQ8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EQ9",  .addr = A_L3_TM_EQ9,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_EQ10",  .addr = A_L3_TM_EQ10,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_EQ11",  .addr = A_L3_TM_EQ11,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL7",  .addr = A_L3_TM_ILL7,
        .reset = 0x5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL8",  .addr = A_L3_TM_ILL8,
        .reset = 0x2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL9",  .addr = A_L3_TM_ILL9,
        .reset = 0x40,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL10",  .addr = A_L3_TM_ILL10,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL11",  .addr = A_L3_TM_ILL11,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL12",  .addr = A_L3_TM_ILL12,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL13",  .addr = A_L3_TM_ILL13,
        .reset = 0x1,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L3_TM_ILL14",  .addr = A_L3_TM_ILL14,
        .reset = 0x51,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_FRZ_FSM0",  .addr = A_L3_TM_FRZ_FSM0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_FRZ_FSM1",  .addr = A_L3_TM_FRZ_FSM1,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_RST_DLY",  .addr = A_L3_TM_RST_DLY,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_ILL15",  .addr = A_L3_TM_ILL15,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_MISC3",  .addr = A_L3_TM_MISC3,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EQ_OFFS1",  .addr = A_L3_TM_EQ_OFFS1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SAMP0",  .addr = A_L3_TM_SAMP0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_EQ12",  .addr = A_L3_TM_EQ12,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_MISC4",  .addr = A_L3_TM_MISC4,
        .rsvd = 0xf8,
        .ro = 0xfffffff8,
    },{ .name = "L3_TM_SAMP_STATUS0",  .addr = A_L3_TM_SAMP_STATUS0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_SAMP_STATUS1",  .addr = A_L3_TM_SAMP_STATUS1,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_SAMP_STATUS2",  .addr = A_L3_TM_SAMP_STATUS2,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_SAMP_STATUS3",  .addr = A_L3_TM_SAMP_STATUS3,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_SAMP_STATUS4",  .addr = A_L3_TM_SAMP_STATUS4,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_SAMP_STATUS5",  .addr = A_L3_TM_SAMP_STATUS5,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS0",  .addr = A_L3_TM_ILL_STATUS0,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS1",  .addr = A_L3_TM_ILL_STATUS1,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS2",  .addr = A_L3_TM_ILL_STATUS2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS3",  .addr = A_L3_TM_ILL_STATUS3,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS4",  .addr = A_L3_TM_ILL_STATUS4,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS5",  .addr = A_L3_TM_ILL_STATUS5,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS6",  .addr = A_L3_TM_ILL_STATUS6,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS7",  .addr = A_L3_TM_ILL_STATUS7,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS8",  .addr = A_L3_TM_ILL_STATUS8,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS9",  .addr = A_L3_TM_ILL_STATUS9,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS10",  .addr = A_L3_TM_ILL_STATUS10,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_ILL_STATUS11",  .addr = A_L3_TM_ILL_STATUS11,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_MISC_ST_0",  .addr = A_L3_TM_MISC_ST_0,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_SD_ST_0",  .addr = A_L3_TM_SD_ST_0,
        .reset = 0x12,
        .rsvd = 0xc0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_EYESURF_ST0",  .addr = A_L3_TM_EYESURF_ST0,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_EYESURF_ST1",  .addr = A_L3_TM_EYESURF_ST1,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_EQ_ST0",  .addr = A_L3_TM_EQ_ST0,
        .reset = 0xff,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_EQ_ST1",  .addr = A_L3_TM_EQ_ST1,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_EQ_ST2",  .addr = A_L3_TM_EQ_ST2,
        .rsvd = 0x80,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_RXPMA_ST1",  .addr = A_L3_TM_RXPMA_ST1,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_CDR0",  .addr = A_L3_TM_CDR0,
        .ro = 0xffffff60,
    },{ .name = "L3_TM_CDR1",  .addr = A_L3_TM_CDR1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR2",  .addr = A_L3_TM_CDR2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR3",  .addr = A_L3_TM_CDR3,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_CDR4",  .addr = A_L3_TM_CDR4,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_CDR5",  .addr = A_L3_TM_CDR5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR6",  .addr = A_L3_TM_CDR6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR7",  .addr = A_L3_TM_CDR7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR8",  .addr = A_L3_TM_CDR8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR9",  .addr = A_L3_TM_CDR9,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR10",  .addr = A_L3_TM_CDR10,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR11",  .addr = A_L3_TM_CDR11,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR12",  .addr = A_L3_TM_CDR12,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR13",  .addr = A_L3_TM_CDR13,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR14",  .addr = A_L3_TM_CDR14,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR15",  .addr = A_L3_TM_CDR15,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CDR16",  .addr = A_L3_TM_CDR16,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR17",  .addr = A_L3_TM_CDR17,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR18",  .addr = A_L3_TM_CDR18,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR19",  .addr = A_L3_TM_CDR19,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR20",  .addr = A_L3_TM_CDR20,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR21",  .addr = A_L3_TM_CDR21,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR22",  .addr = A_L3_TM_CDR22,
        .ro = 0xffffffe0,
    },{ .name = "L3_TM_CDR23",  .addr = A_L3_TM_CDR23,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_MISC0",  .addr = A_L3_TM_MISC0,
        .ro = 0xfffffffc,
    },{ .name = "L3_TM_HSRX_ST0",  .addr = A_L3_TM_HSRX_ST0,
        .rsvd = 0xfe,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_PLL_LS_CLOCK",  .addr = A_L3_TM_PLL_LS_CLOCK,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_LOOP_FILT",  .addr = A_L3_TM_PLL_LOOP_FILT,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG2",  .addr = A_L3_TM_PLL_DIG2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_FBDIV",  .addr = A_L3_TM_PLL_FBDIV,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG4",  .addr = A_L3_TM_PLL_DIG4,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG5",  .addr = A_L3_TM_PLL_DIG5,
        .reset = 0xc0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG6",  .addr = A_L3_TM_PLL_DIG6,
        .reset = 0x3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG7",  .addr = A_L3_TM_PLL_DIG7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_CPUMP_CODE_1",  .addr = A_L3_TM_PLL_CPUMP_CODE_1,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG9",  .addr = A_L3_TM_PLL_DIG9,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_PLL_COARSE_CODE_LSB",  .addr = A_L3_TM_PLL_COARSE_CODE_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG11",  .addr = A_L3_TM_PLL_DIG11,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG12",  .addr = A_L3_TM_PLL_DIG12,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_CONST_PMOS",  .addr = A_L3_TM_PLL_CONST_PMOS,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG14",  .addr = A_L3_TM_PLL_DIG14,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG15",  .addr = A_L3_TM_PLL_DIG15,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG16",  .addr = A_L3_TM_PLL_DIG16,
        .ro = 0xffffff10,
    },{ .name = "L3_TM_PLL_DIG17",  .addr = A_L3_TM_PLL_DIG17,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG18",  .addr = A_L3_TM_PLL_DIG18,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG19",  .addr = A_L3_TM_PLL_DIG19,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG20",  .addr = A_L3_TM_PLL_DIG20,
        .ro = 0xffffff40,
    },{ .name = "L3_TM_PLL_DIG21",  .addr = A_L3_TM_PLL_DIG21,
        .reset = 0x20,
        .ro = 0xffffff0c,
    },{ .name = "L3_TM_PLL_DIG22",  .addr = A_L3_TM_PLL_DIG22,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_PLL_DIG23",  .addr = A_L3_TM_PLL_DIG23,
        .reset = 0x31,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG24",  .addr = A_L3_TM_PLL_DIG24,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_PLL_DIG25",  .addr = A_L3_TM_PLL_DIG25,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG26",  .addr = A_L3_TM_PLL_DIG26,
        .reset = 0x40,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_PLL_CLK_DIST_NTRIM_LSB",  .addr = A_L3_TM_PLL_CLK_DIST_NTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_CLK_DIST_PTRIM_LSB",  .addr = A_L3_TM_PLL_CLK_DIST_PTRIM_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_29",  .addr = A_L3_TM_PLL_DIG_29,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_30",  .addr = A_L3_TM_PLL_DIG_30,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_31",  .addr = A_L3_TM_PLL_DIG_31,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_32",  .addr = A_L3_TM_PLL_DIG_32,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_33",  .addr = A_L3_TM_PLL_DIG_33,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_34",  .addr = A_L3_TM_PLL_DIG_34,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_PLL_DIG_35",  .addr = A_L3_TM_PLL_DIG_35,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_36",  .addr = A_L3_TM_PLL_DIG_36,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_DIG_37",  .addr = A_L3_TM_PLL_DIG_37,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_PLL_COARSE_CODE_SAT_MSB",  .addr = A_L3_TM_PLL_COARSE_CODE_SAT_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_MPHY_CFG_HIB8",  .addr = A_L3_MPHY_CFG_HIB8,
        .ro = 0xfffffffe,
    },{ .name = "L3_MPHY_CFG_MODE",  .addr = A_L3_MPHY_CFG_MODE,
        .ro = 0xfffffffc,
    },{ .name = "L3_MPHY_CFG_HS_GEAR",  .addr = A_L3_MPHY_CFG_HS_GEAR,
        .ro = 0xfffffffc,
    },{ .name = "L3_MPHY_CFG_HS_RATE",  .addr = A_L3_MPHY_CFG_HS_RATE,
        .ro = 0xfffffffe,
    },{ .name = "L3_MPHY_CFG_PWM",  .addr = A_L3_MPHY_CFG_PWM,
        .ro = 0xfffffff8,
    },{ .name = "L3_PLL_OPDIV_LS",  .addr = A_L3_PLL_OPDIV_LS,
        .ro = 0xffffff00,
    },{ .name = "L3_MPHY_CFG_UPDT",  .addr = A_L3_MPHY_CFG_UPDT,
        .ro = 0xfffffffe,
    },{ .name = "L3_PLL_TM_DIV_CNTRLS",  .addr = A_L3_PLL_TM_DIV_CNTRLS,
        .reset = 0x40,
        .ro = 0xffffff20,
    },{ .name = "L3_PLL_FBDIV_G1A_LSB",  .addr = A_L3_PLL_FBDIV_G1A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G1B_LSB",  .addr = A_L3_PLL_FBDIV_G1B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G2A_LSB",  .addr = A_L3_PLL_FBDIV_G2A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G2B_LSB",  .addr = A_L3_PLL_FBDIV_G2B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G3A_LSB",  .addr = A_L3_PLL_FBDIV_G3A_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G3B_LSB",  .addr = A_L3_PLL_FBDIV_G3B_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G1A_MSB",  .addr = A_L3_PLL_FBDIV_G1A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G1B_MSB",  .addr = A_L3_PLL_FBDIV_G1B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G2A_MSB",  .addr = A_L3_PLL_FBDIV_G2A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G2B_MSB",  .addr = A_L3_PLL_FBDIV_G2B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G3A_MSB",  .addr = A_L3_PLL_FBDIV_G3A_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_G3B_MSB",  .addr = A_L3_PLL_FBDIV_G3B_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_IPDIV",  .addr = A_L3_PLL_IPDIV,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_FRAC_0_LSB",  .addr = A_L3_PLL_FBDIV_FRAC_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_FRAC_1",  .addr = A_L3_PLL_FBDIV_FRAC_1,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_FRAC_2",  .addr = A_L3_PLL_FBDIV_FRAC_2,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_FBDIV_FRAC_3_MSB",  .addr = A_L3_PLL_FBDIV_FRAC_3_MSB,
        .ro = 0xffffff98,
    },{ .name = "L3_PLL_PWR_SEQ_WAIT_TIME",  .addr = A_L3_PLL_PWR_SEQ_WAIT_TIME,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_SS_STEPS_0_LSB",  .addr = A_L3_PLL_SS_STEPS_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_SS_STEPS_1_MSB",  .addr = A_L3_PLL_SS_STEPS_1_MSB,
        .ro = 0xfffffff8,
    },{ .name = "L3_PLL_SS_STEP_SIZE_0_LSB",  .addr = A_L3_PLL_SS_STEP_SIZE_0_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_SS_STEP_SIZE_1",  .addr = A_L3_PLL_SS_STEP_SIZE_1,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_SS_STEP_SIZE_2",  .addr = A_L3_PLL_SS_STEP_SIZE_2,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_SS_STEP_SIZE_3_MSB",  .addr = A_L3_PLL_SS_STEP_SIZE_3_MSB,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_MASK_CFG_UPDT",  .addr = A_L3_TM_MASK_CFG_UPDT,
        .ro = 0xffffff80,
    },{ .name = "L3_PLL_TM_FORCE_DIV",  .addr = A_L3_PLL_TM_FORCE_DIV,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_1_LSB",  .addr = A_L3_PLL_TM_COARSE_CODE_1_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_2_LSB",  .addr = A_L3_PLL_TM_COARSE_CODE_2_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_3_LSB",  .addr = A_L3_PLL_TM_COARSE_CODE_3_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_4_LSB",  .addr = A_L3_PLL_TM_COARSE_CODE_4_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_5_LSB",  .addr = A_L3_PLL_TM_COARSE_CODE_5_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_6_LSB",  .addr = A_L3_PLL_TM_COARSE_CODE_6_LSB,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_COARSE_CODE_1_2_MSB",  .addr = A_L3_PLL_TM_COARSE_CODE_1_2_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L3_PLL_TM_COARSE_CODE_3_4_MSB",  .addr = A_L3_PLL_TM_COARSE_CODE_3_4_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L3_PLL_TM_COARSE_CODE_5_6_MSB",  .addr = A_L3_PLL_TM_COARSE_CODE_5_6_MSB,
        .ro = 0xffffffc0,
    },{ .name = "L3_PLL_TM_SHARED_0",  .addr = A_L3_PLL_TM_SHARED_0,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_FRAC_OFFSET_0",  .addr = A_L3_PLL_TM_FRAC_OFFSET_0,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_FRAC_OFFSET_1",  .addr = A_L3_PLL_TM_FRAC_OFFSET_1,
        .ro = 0xffffff00,
    },{ .name = "L3_PLL_TM_FRAC_OFFSET_2",  .addr = A_L3_PLL_TM_FRAC_OFFSET_2,
        .ro = 0xfffffffc,
    },{ .name = "L3_PLL_STATUS_READ_0",  .addr = A_L3_PLL_STATUS_READ_0,
        .ro = 0xffffffff,
    },{ .name = "L3_PLL_STATUS_READ_1",  .addr = A_L3_PLL_STATUS_READ_1,
        .reset = 0x1 | R_L3_PLL_STATUS_READ_1_PLL_LOCK_STATUS_READ_MASK,
        .ro = 0xffffffff,
    },{ .name = "L3_TM_CALIB_DIG0",  .addr = A_L3_TM_CALIB_DIG0,
        .ro = 0xffffffc3,
    },{ .name = "L3_TM_CALIB_DIG1",  .addr = A_L3_TM_CALIB_DIG1,
        .ro = 0xfffffff6,
    },{ .name = "L3_TM_CALIB_DIG2",  .addr = A_L3_TM_CALIB_DIG2,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG3",  .addr = A_L3_TM_CALIB_DIG3,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG4",  .addr = A_L3_TM_CALIB_DIG4,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG5",  .addr = A_L3_TM_CALIB_DIG5,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG6",  .addr = A_L3_TM_CALIB_DIG6,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG7",  .addr = A_L3_TM_CALIB_DIG7,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG8",  .addr = A_L3_TM_CALIB_DIG8,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG9",  .addr = A_L3_TM_CALIB_DIG9,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG10",  .addr = A_L3_TM_CALIB_DIG10,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG11",  .addr = A_L3_TM_CALIB_DIG11,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG12",  .addr = A_L3_TM_CALIB_DIG12,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_CALIB_DIG13",  .addr = A_L3_TM_CALIB_DIG13,
        .ro = 0xffffffc0,
    },{ .name = "L3_TM_CALIB_DIG14",  .addr = A_L3_TM_CALIB_DIG14,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG15",  .addr = A_L3_TM_CALIB_DIG15,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG16",  .addr = A_L3_TM_CALIB_DIG16,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG17",  .addr = A_L3_TM_CALIB_DIG17,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG18",  .addr = A_L3_TM_CALIB_DIG18,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG19",  .addr = A_L3_TM_CALIB_DIG19,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_CALIB_DIG20",  .addr = A_L3_TM_CALIB_DIG20,
        .rsvd = 0x30,
        .ro = 0xffffff30,
    },{ .name = "L3_TM_CALIB_DIG21",  .addr = A_L3_TM_CALIB_DIG21,
        .ro = 0xffffff04,
    },{ .name = "L3_TM_CALIB_DIG22",  .addr = A_L3_TM_CALIB_DIG22,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_SLICER2_CTRL",  .addr = A_L3_TM_SLICER2_CTRL,
        .ro = 0xffffff80,
    },{ .name = "L3_TM_SLICER23_BIAS_PROG0",  .addr = A_L3_TM_SLICER23_BIAS_PROG0,
        .ro = 0xffffff00,
    },{ .name = "L3_TM_SLICER23_BIAS_PROG1",  .addr = A_L3_TM_SLICER23_BIAS_PROG1,
        .ro = 0xfffffff0,
    },{ .name = "L3_TM_SLICER3_CTRL",  .addr = A_L3_TM_SLICER3_CTRL,
        .ro = 0xffffff81,
    },{ .name = "L3_CAL_SLICER_SPARE",  .addr = A_L3_CAL_SLICER_SPARE,
        .ro = 0xffffffc0,
    },{ .name = "L3_SLICER2_ENABLE",  .addr = A_L3_SLICER2_ENABLE,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "L3_SLICER3_ENABLE",  .addr = A_L3_SLICER3_ENABLE,
        .ro = 0xffffff00,
    },{ .name = "L3_SLICER2_BYPASS",  .addr = A_L3_SLICER2_BYPASS,
        .rsvd = 0x18,
        .ro = 0xffffff98,
    },{ .name = "L3_SLICER3_BYPASS",  .addr = A_L3_SLICER3_BYPASS,
        .rsvd = 0x18,
        .ro = 0xffffff18,
    },{ .name = "L3_TM_BRINGUP_CONTROL",  .addr = A_L3_TM_BRINGUP_CONTROL,
        .ro = 0xfffffffd,
    },{ .name = "L3_CALIB_DONE_STATUS",  .addr = A_L3_CALIB_DONE_STATUS,
        .ro = 0xffffffff,
        /* Signal that calibration is done.  */
        .reset = 0x3,
    },{ .name = "L3_CALIB_PIPE_PSW_CODE_STATUS",  .addr = A_L3_CALIB_PIPE_PSW_CODE_STATUS,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L3_CALIB_PIPE_NSW_CODE_STATUS",  .addr = A_L3_CALIB_PIPE_NSW_CODE_STATUS,
        .reset = 0x20,
        .ro = 0xffffffff,
    },{ .name = "L3_CALIB_MPHY_TX_CODE_STATUS",  .addr = A_L3_CALIB_MPHY_TX_CODE_STATUS,
        .reset = 0x8,
        .ro = 0xffffffff,
    },{ .name = "L3_CALIB_ICAL_CODE_STATUS",  .addr = A_L3_CALIB_ICAL_CODE_STATUS,
        .reset = 0x10,
        .ro = 0xffffffff,
    },{ .name = "L3_CALIB_RX_CODE_STATUS",  .addr = A_L3_CALIB_RX_CODE_STATUS,
        .reset = 0x8,
        .ro = 0xffffffff,
    },{ .name = "L3_CALIB_USB2_TX_CODE_STATUS",  .addr = A_L3_CALIB_USB2_TX_CODE_STATUS,
        .reset = 0x10,
        .ro = 0xffffffff,
    },{ .name = "L3_CAL_ISO_CTRL",  .addr = A_L3_CAL_ISO_CTRL,
        .ro = 0xfffffffc,
    },{ .name = "L3_UPHY_GLOBAL_CTRL",  .addr = A_L3_UPHY_GLOBAL_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "L3_BIST_CTRL_1",  .addr = A_L3_BIST_CTRL_1,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_CTRL_2",  .addr = A_L3_BIST_CTRL_2,
        .ro = 0xfffffff8,
    },{ .name = "L3_BIST_RUN_LEN_L",  .addr = A_L3_BIST_RUN_LEN_L,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_ERR_INJ_POINT_L",  .addr = A_L3_BIST_ERR_INJ_POINT_L,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_RUNLEN_ERR_INJ_H",  .addr = A_L3_BIST_RUNLEN_ERR_INJ_H,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_IDLE_TIME",  .addr = A_L3_BIST_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_MARKER_L",  .addr = A_L3_BIST_MARKER_L,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_IDLE_CHAR_L",  .addr = A_L3_BIST_IDLE_CHAR_L,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_MARKER_IDLE_H",  .addr = A_L3_BIST_MARKER_IDLE_H,
        .ro = 0xffffffcc,
    },{ .name = "L3_BIST_LOW_PULSE_TIME",  .addr = A_L3_BIST_LOW_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_TOTAL_PULSE_TIME",  .addr = A_L3_BIST_TOTAL_PULSE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_TEST_PAT_1",  .addr = A_L3_BIST_TEST_PAT_1,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_TEST_PAT_2",  .addr = A_L3_BIST_TEST_PAT_2,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_TEST_PAT_3",  .addr = A_L3_BIST_TEST_PAT_3,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_TEST_PAT_4",  .addr = A_L3_BIST_TEST_PAT_4,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_TEST_PAT_MSBS",  .addr = A_L3_BIST_TEST_PAT_MSBS,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_PKT_NUM",  .addr = A_L3_BIST_PKT_NUM,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_FRM_IDLE_TIME",  .addr = A_L3_BIST_FRM_IDLE_TIME,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_PKT_CTR_L",  .addr = A_L3_BIST_PKT_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L3_BIST_PKT_CTR_H",  .addr = A_L3_BIST_PKT_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L3_BIST_ERR_CTR_L",  .addr = A_L3_BIST_ERR_CTR_L,
        .ro = 0xffffffff,
    },{ .name = "L3_BIST_ERR_CTR_H",  .addr = A_L3_BIST_ERR_CTR_H,
        .ro = 0xffffffff,
    },{ .name = "L3_CLK_DIV_CNT",  .addr = A_L3_CLK_DIV_CNT,
        .reset = 0x19,
        .ro = 0xffffff00,
    },{ .name = "L3_DATA_BUS_WID",  .addr = A_L3_DATA_BUS_WID,
        .reset = 0x1,
        .ro = 0xffffff00,
    },{ .name = "L3_ANADIG_BYPASS",  .addr = A_L3_ANADIG_BYPASS,
        .ro = 0xffffff00,
    },{ .name = "L3_BIST_FILLER_OUT",  .addr = A_L3_BIST_FILLER_OUT,
        .reset = 0x1,
        .ro = 0xfffffffc,
    },{ .name = "L3_BIST_FORCE_MK_RST",  .addr = A_L3_BIST_FORCE_MK_RST,
        .rsvd = 0xfc,
        .ro = 0xfffffffc,
    },{ .name = "L3_SPARE_IN",  .addr = A_L3_SPARE_IN,
        .ro = 0xffffffff,
    },{ .name = "L3_SPARE_OUT",  .addr = A_L3_SPARE_OUT,
        .ro = 0xffffff00,
    },{ .name = "PLL_REF_SEL0",  .addr = A_PLL_REF_SEL0,
        .reset = 0xd,
        .ro = 0xffffffe0,
    },{ .name = "PLL_REF_SEL1",  .addr = A_PLL_REF_SEL1,
        .reset = 0x8,
        .ro = 0xffffffe0,
    },{ .name = "PLL_REF_SEL2",  .addr = A_PLL_REF_SEL2,
        .reset = 0xf,
        .ro = 0xffffffe0,
    },{ .name = "PLL_REF_SEL3",  .addr = A_PLL_REF_SEL3,
        .reset = 0xe,
        .ro = 0xffffffe0,
    },{ .name = "ICM_CFG0",  .addr = A_ICM_CFG0,
        .ro = 0xffffff88,
    },{ .name = "ICM_CFG1",  .addr = A_ICM_CFG1,
        .ro = 0xffffff88,
    },{ .name = "TM_CMN_RST",  .addr = A_TM_CMN_RST,
        .reset = 0x2,
        .ro = 0xfffffffc,
    },{ .name = "PCIE_DYNDESKEW_PAT0",  .addr = A_PCIE_DYNDESKEW_PAT0,
        .reset = 0x1c,
        .ro = 0xffffff00,
    },{ .name = "PCIE_DYNDESKEW_PAT1",  .addr = A_PCIE_DYNDESKEW_PAT1,
        .reset = 0x1c,
        .ro = 0xffffff00,
    },{ .name = "LANE_RPTR_CTRL",  .addr = A_LANE_RPTR_CTRL,
        .ro = 0xfffffffe,
    },{ .name = "BGCAL_REF_SEL",  .addr = A_BGCAL_REF_SEL,
        .reset = 0xc,
        .ro = 0xffffffe0,
    },{ .name = "PCIE_RXSTAT_CTRL",  .addr = A_PCIE_RXSTAT_CTRL,
        .ro = 0xfffffffe,
    },{ .name = "PLLLOCK2PCIEPHYRDY_CNT",  .addr = A_PLLLOCK2PCIEPHYRDY_CNT,
        .ro = 0xffffff00,
    },{ .name = "LPBK_CTRL0",  .addr = A_LPBK_CTRL0,
        .ro = 0xffffff88,
    },{ .name = "LPBK_CTRL1",  .addr = A_LPBK_CTRL1,
        .ro = 0xffffff88,
    },{ .name = "TX_PROT_BUS_WIDTH",  .addr = A_TX_PROT_BUS_WIDTH,
        .reset = 0x55,
        .ro = 0xffffff00,
    },{ .name = "RX_PROT_BUS_WIDTH",  .addr = A_RX_PROT_BUS_WIDTH,
        .reset = 0x55,
        .ro = 0xffffff00,
    },{ .name = "RMMI_RST_CTRL",  .addr = A_RMMI_RST_CTRL,
        .reset = 0xff,
        .ro = 0xffffff00,
    },{ .name = "TM_RX_COUPLING_CTRL",  .addr = A_TM_RX_COUPLING_CTRL,
        .ro = 0xffffff00,
    },{ .name = "TM_PCIE_DESKEW_CTRL",  .addr = A_TM_PCIE_DESKEW_CTRL,
        .reset = 0x80,
        .ro = 0xffffff00,
    },{ .name = "TM_PCIE_LANEMAP",  .addr = A_TM_PCIE_LANEMAP,
        .ro = 0xffffffe0,
    },{ .name = "RX_DETECT_CTRL",  .addr = A_RX_DETECT_CTRL,
        .ro = 0xffffff00,
    },{ .name = "DESKEW_ST0",  .addr = A_DESKEW_ST0,
        .ro = 0xffffffff,
    },{ .name = "DESKEW_ST1",  .addr = A_DESKEW_ST1,
        .ro = 0xffffffff,
    },{ .name = "AFE_RX0_CTRL",  .addr = A_AFE_RX0_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "AFE_RX1_CTRL",  .addr = A_AFE_RX1_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "AFE_RX2_CTRL",  .addr = A_AFE_RX2_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "AFE_RX3_CTRL",  .addr = A_AFE_RX3_CTRL,
        .ro = 0xffffffe0,
    },{ .name = "SPARE_IN0",  .addr = A_SPARE_IN0,
        .ro = 0xffffff00,
    },{ .name = "SPARE_OUT0",  .addr = A_SPARE_OUT0,
        .ro = 0xffffffff,
    },{ .name = "SPARE_IN1",  .addr = A_SPARE_IN1,
        .ro = 0xffffff00,
    },{ .name = "SPARE_OUT1",  .addr = A_SPARE_OUT1,
        .ro = 0xffffffff,
    },{ .name = "SPARE_IN2",  .addr = A_SPARE_IN2,
        .ro = 0xffffff00,
    },{ .name = "SPARE_OUT2",  .addr = A_SPARE_OUT2,
        .ro = 0xffffffff,
    },{ .name = "SPARE_IN3",  .addr = A_SPARE_IN3,
        .ro = 0xffffff00,
    },{ .name = "SPARE_OUT3",  .addr = A_SPARE_OUT3,
        .ro = 0xffffffff,
    },{ .name = "SGMII_CDET_CTRL",  .addr = A_SGMII_CDET_CTRL,
        .reset = 0xff,
        .ro = 0xffffff00,
    },{ .name = "UPHY_SPARE0",  .addr = A_UPHY_SPARE0,
        .ro = 0xffffff00,
    },{ .name = "UPHY_SPARE1",  .addr = A_UPHY_SPARE1,
        .ro = 0xffffff00,
    },{ .name = "UPHY_SPARE2",  .addr = A_UPHY_SPARE2,
        .ro = 0xffffff00,
    },{ .name = "UPHY_SPARE3",  .addr = A_UPHY_SPARE3,
        .ro = 0xffffff00,
    },{ .name = "CIRRUS_SPARE_OUT0",  .addr = A_CIRRUS_SPARE_OUT0,
        .ro = 0xffffff00,
    },{ .name = "CIRRUS_SPARE_OUT1",  .addr = A_CIRRUS_SPARE_OUT1,
        .ro = 0xffffff00,
    },{ .name = "CIRRUS_SPARE_OUT2",  .addr = A_CIRRUS_SPARE_OUT2,
        .ro = 0xffffff00,
    },{ .name = "CIRRUS_SPARE_OUT3",  .addr = A_CIRRUS_SPARE_OUT3,
        .ro = 0xffffff00,
    },{ .name = "CIRRUS_SPARE_IN0",  .addr = A_CIRRUS_SPARE_IN0,
        .ro = 0xffffffff,
    },{ .name = "CIRRUS_SPARE_IN1",  .addr = A_CIRRUS_SPARE_IN1,
        .ro = 0xffffffff,
    },{ .name = "CIRRUS_SPARE_IN2",  .addr = A_CIRRUS_SPARE_IN2,
        .ro = 0xffffffff,
    },{ .name = "CIRRUS_SPARE_IN3",  .addr = A_CIRRUS_SPARE_IN3,
        .ro = 0xffffffff,
    },{ .name = "AFE_EQ_PSO_DELAY",  .addr = A_AFE_EQ_PSO_DELAY,
        .reset = 0x11,
        .ro = 0xffffff88,
    },{ .name = "USB_TXFIFO0_CTRL",  .addr = A_USB_TXFIFO0_CTRL,
        .ro = 0xffffff40,
    },{ .name = "USB_TXFIFO1_CTRL",  .addr = A_USB_TXFIFO1_CTRL,
        .ro = 0xffffff40,
    },{ .name = "DP_TXFIFO0_CTRL",  .addr = A_DP_TXFIFO0_CTRL,
        .ro = 0xffffff40,
    },{ .name = "DP_TXFIFO1_CTRL",  .addr = A_DP_TXFIFO1_CTRL,
        .ro = 0xffffff40,
    }
};

static void serdes_reset(DeviceState *dev)
{
    SERDES *s = XILINX_SERDES(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

/* Returns a device object from a register region created by
 * register_init_block32() */
static SERDES *serdes_from_mr(void *mr_accessor)
{
    RegisterInfoArray *reg_array = mr_accessor;
    Object *obj;

    assert(reg_array != NULL);

    obj = reg_array->mem.owner;
    assert(obj);

    return XILINX_SERDES(obj);
}

static uint64_t serdes_read(void *opaque, hwaddr addr, unsigned size)
{
    SERDES *s = serdes_from_mr(opaque);
    RegisterInfo *r = &s->regs_info[addr / 4];

    if (!r->data) {
        qemu_log("%s: Decode error: read from %" HWADDR_PRIx "\n",
                 object_get_canonical_path(OBJECT(s)),
                 addr);
        return 0;
    }
    return register_read(r, ~0, s->prefix, XILINX_SERDES_ERR_DEBUG);
}

static void serdes_write(void *opaque, hwaddr addr, uint64_t value,
                      unsigned size)
{
    SERDES *s = serdes_from_mr(opaque);
    RegisterInfo *r = &s->regs_info[addr / 4];

    if (!r->data) {
        qemu_log("%s: Decode error: write to %" HWADDR_PRIx "=%" PRIx64 "\n",
                 object_get_canonical_path(OBJECT(s)),
                 addr, value);
        return;
    }
    register_write(r, value, ~0, s->prefix, XILINX_SERDES_ERR_DEBUG);
}

static const MemoryRegionOps serdes_ops = {
    .read = serdes_read,
    .write = serdes_write,
   .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void serdes_init(Object *obj)
{
    SERDES *s = XILINX_SERDES(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    s->prefix = object_get_canonical_path(obj);
    reg_array =
     register_init_block32(DEVICE(obj), serdes_regs_info,
                           ARRAY_SIZE(serdes_regs_info),
                           s->regs_info, s->regs,
                           &serdes_ops,
                           XILINX_SERDES_ERR_DEBUG,
                           SERDES_R_MAX * 4);
    memory_region_init_io(&s->iomem, obj, &serdes_ops, s,
                          TYPE_XILINX_SERDES, SERDES_R_MAX * 4);
    memory_region_add_subregion(&s->iomem, 0x0, &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_serdes = {
    .name = TYPE_XILINX_SERDES,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, SERDES, SERDES_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void serdes_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = serdes_reset;
    dc->vmsd = &vmstate_serdes;
}

static const TypeInfo serdes_info = {
    .name          = TYPE_XILINX_SERDES,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(SERDES),
    .class_init    = serdes_class_init,
    .instance_init = serdes_init,
};

static void serdes_register_types(void)
{
    type_register_static(&serdes_info);
}

type_init(serdes_register_types)
