/*
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (C) 2018, 2024 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This file must be compatible to general purpose POSIX system, e.g. Linux,
 * FreeBSD.  It may be used for utility programs.
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems/recorddata.h>

#include <stddef.h>

static const char * const event_text[] = {
  [ RTEMS_RECORD_EMPTY ] = "EMPTY",
  [ RTEMS_RECORD_VERSION ] = "VERSION",
  [ RTEMS_RECORD_ARCH ] = "ARCH",
  [ RTEMS_RECORD_BSP ] = "BSP",
  [ RTEMS_RECORD_FREQUENCY ] = "FREQUENCY",
  [ RTEMS_RECORD_MULTILIB ] = "MULTILIB",
  [ RTEMS_RECORD_PER_CPU_COUNT ] = "PER_CPU_COUNT",
  [ RTEMS_RECORD_PER_CPU_DISCARD ] = "PER_CPU_DISCARD",
  [ RTEMS_RECORD_PER_CPU_OVERFLOW ] = "PER_CPU_OVERFLOW",
  [ RTEMS_RECORD_PROCESSOR ] = "PROCESSOR",
  [ RTEMS_RECORD_PROCESSOR_MAXIMUM ] = "PROCESSOR_MAXIMUM",
  [ RTEMS_RECORD_THREAD_ID ] = "THREAD_ID",
  [ RTEMS_RECORD_THREAD_NAME ] = "THREAD_NAME",
  [ RTEMS_RECORD_TIME_ADJUSTMENT ] = "TIME_ADJUSTMENT",
  [ RTEMS_RECORD_TOOLS ] = "TOOLS",
  [ RTEMS_RECORD_UNRELIABLE_TIME ] = "UNRELIABLE_TIME",
  [ RTEMS_RECORD_VERSION_CONTROL_KEY ] = "VERSION_CONTROL_KEY",
  [ RTEMS_RECORD_ACCEPT_ENTRY ] = "ACCEPT_ENTRY",
  [ RTEMS_RECORD_ACCEPT_EXIT ] = "ACCEPT_EXIT",
  [ RTEMS_RECORD_ADDRESS ] = "ADDRESS",
  [ RTEMS_RECORD_ALIGNED_ALLOC_ENTRY ] = "ALIGNED_ALLOC_ENTRY",
  [ RTEMS_RECORD_ALIGNED_ALLOC_EXIT ] = "ALIGNED_ALLOC_EXIT",
  [ RTEMS_RECORD_ARG_0 ] = "ARG_0",
  [ RTEMS_RECORD_ARG_1 ] = "ARG_1",
  [ RTEMS_RECORD_ARG_2 ] = "ARG_2",
  [ RTEMS_RECORD_ARG_3 ] = "ARG_3",
  [ RTEMS_RECORD_ARG_4 ] = "ARG_4",
  [ RTEMS_RECORD_ARG_5 ] = "ARG_5",
  [ RTEMS_RECORD_ARG_6 ] = "ARG_6",
  [ RTEMS_RECORD_ARG_7 ] = "ARG_7",
  [ RTEMS_RECORD_ARG_8 ] = "ARG_8",
  [ RTEMS_RECORD_ARG_9 ] = "ARG_9",
  [ RTEMS_RECORD_BIND_ENTRY ] = "BIND_ENTRY",
  [ RTEMS_RECORD_BIND_EXIT ] = "BIND_EXIT",
  [ RTEMS_RECORD_BUFFER ] = "BUFFER",
  [ RTEMS_RECORD_CALLER ] = "CALLER",
  [ RTEMS_RECORD_CALLOC_ENTRY ] = "CALLOC_ENTRY",
  [ RTEMS_RECORD_CALLOC_EXIT ] = "CALLOC_EXIT",
  [ RTEMS_RECORD_CHOWN_ENTRY ] = "CHOWN_ENTRY",
  [ RTEMS_RECORD_CHOWN_EXIT ] = "CHOWN_EXIT",
  [ RTEMS_RECORD_CLOSE_ENTRY ] = "CLOSE_ENTRY",
  [ RTEMS_RECORD_CLOSE_EXIT ] = "CLOSE_EXIT",
  [ RTEMS_RECORD_CONNECT_ENTRY ] = "CONNECT_ENTRY",
  [ RTEMS_RECORD_CONNECT_EXIT ] = "CONNECT_EXIT",
  [ RTEMS_RECORD_ETHER_INPUT ] = "ETHER_INPUT",
  [ RTEMS_RECORD_ETHER_OUTPUT ] = "ETHER_OUTPUT",
  [ RTEMS_RECORD_ERRNO ] = "ERRNO",
  [ RTEMS_RECORD_FATAL_CODE ] = "FATAL_CODE",
  [ RTEMS_RECORD_FATAL_SOURCE ] = "FATAL_SOURCE",
  [ RTEMS_RECORD_FCHMOD_ENTRY ] = "FCHMOD_ENTRY",
  [ RTEMS_RECORD_FCHMOD_EXIT ] = "FCHMOD_EXIT",
  [ RTEMS_RECORD_FCNTL_ENTRY ] = "FCNTL_ENTRY",
  [ RTEMS_RECORD_FCNTL_EXIT ] = "FCNTL_EXIT",
  [ RTEMS_RECORD_FDATASYNC_ENTRY ] = "FDATASYNC_ENTRY",
  [ RTEMS_RECORD_FDATASYNC_EXIT ] = "FDATASYNC_EXIT",
  [ RTEMS_RECORD_FREE_ENTRY ] = "FREE_ENTRY",
  [ RTEMS_RECORD_FREE_EXIT ] = "FREE_EXIT",
  [ RTEMS_RECORD_FSTAT_ENTRY ] = "FSTAT_ENTRY",
  [ RTEMS_RECORD_FSTAT_EXIT ] = "FSTAT_EXIT",
  [ RTEMS_RECORD_FSYNC_ENTRY ] = "FSYNC_ENTRY",
  [ RTEMS_RECORD_FSYNC_EXIT ] = "FSYNC_EXIT",
  [ RTEMS_RECORD_FTRUNCATE_ENTRY ] = "FTRUNCATE_ENTRY",
  [ RTEMS_RECORD_FTRUNCATE_EXIT ] = "FTRUNCATE_EXIT",
  [ RTEMS_RECORD_FUNCTION_ENTRY ] = "FUNCTION_ENTRY",
  [ RTEMS_RECORD_FUNCTION_EXIT ] = "FUNCTION_EXIT",
  [ RTEMS_RECORD_GETSOCKOPT_ENTRY ] = "GETSOCKOPT_ENTRY",
  [ RTEMS_RECORD_GETSOCKOPT_EXIT ] = "GETSOCKOPT_EXIT",
  [ RTEMS_RECORD_HEAP_ALLOC ] = "HEAP_ALLOC",
  [ RTEMS_RECORD_HEAP_FREE ] = "HEAP_FREE",
  [ RTEMS_RECORD_HEAP_SIZE ] = "HEAP_SIZE",
  [ RTEMS_RECORD_HEAP_USAGE ] = "HEAP_USAGE",
  [ RTEMS_RECORD_INTERRUPT_ENTRY ] = "INTERRUPT_ENTRY",
  [ RTEMS_RECORD_INTERRUPT_EXIT ] = "INTERRUPT_EXIT",
  [ RTEMS_RECORD_INTERRUPT_INSTALL ] = "INTERRUPT_INSTALL",
  [ RTEMS_RECORD_INTERRUPT_REMOVE ] = "INTERRUPT_REMOVE",
  [ RTEMS_RECORD_INTERRUPT_SERVER_ENTRY ] = "INTERRUPT_SERVER_ENTRY",
  [ RTEMS_RECORD_INTERRUPT_SERVER_EXIT ] = "INTERRUPT_SERVER_EXIT",
  [ RTEMS_RECORD_INTERRUPT_SERVER_INSTALL ] = "INTERRUPT_SERVER_INSTALL",
  [ RTEMS_RECORD_INTERRUPT_SERVER_MOVE ] = "INTERRUPT_SERVER_MOVE",
  [ RTEMS_RECORD_INTERRUPT_SERVER_REMOVE ] = "INTERRUPT_SERVER_REMOVE",
  [ RTEMS_RECORD_INTERRUPT_SERVER_TRIGGER ] = "INTERRUPT_SERVER_TRIGGER",
  [ RTEMS_RECORD_IOCTL_ENTRY ] = "IOCTL_ENTRY",
  [ RTEMS_RECORD_IOCTL_EXIT ] = "IOCTL_EXIT",
  [ RTEMS_RECORD_IP6_INPUT ] = "IP6_INPUT",
  [ RTEMS_RECORD_IP6_OUTPUT ] = "IP6_OUTPUT",
  [ RTEMS_RECORD_IP_INPUT ] = "IP_INPUT",
  [ RTEMS_RECORD_IP_OUTPUT ] = "IP_OUTPUT",
  [ RTEMS_RECORD_ISR_DISABLE ] = "ISR_DISABLE",
  [ RTEMS_RECORD_ISR_ENABLE ] = "ISR_ENABLE",
  [ RTEMS_RECORD_ISR_LOCK_ACQUIRE_ENTRY ] = "ISR_LOCK_ACQUIRE_ENTRY",
  [ RTEMS_RECORD_ISR_LOCK_ACQUIRE_EXIT ] = "ISR_LOCK_ACQUIRE_EXIT",
  [ RTEMS_RECORD_ISR_LOCK_ADDRESS ] = "ISR_LOCK_ADDRESS",
  [ RTEMS_RECORD_ISR_LOCK_DESTROY ] = "ISR_LOCK_DESTROY",
  [ RTEMS_RECORD_ISR_LOCK_INITIALIZE ] = "ISR_LOCK_INITIALIZE",
  [ RTEMS_RECORD_ISR_LOCK_NAME ] = "ISR_LOCK_NAME",
  [ RTEMS_RECORD_ISR_LOCK_RELEASE ] = "ISR_LOCK_RELEASE",
  [ RTEMS_RECORD_KEVENT_ENTRY ] = "KEVENT_ENTRY",
  [ RTEMS_RECORD_KEVENT_EXIT ] = "KEVENT_EXIT",
  [ RTEMS_RECORD_KQUEUE_ENTRY ] = "KQUEUE_ENTRY",
  [ RTEMS_RECORD_KQUEUE_EXIT ] = "KQUEUE_EXIT",
  [ RTEMS_RECORD_LENGTH ] = "LENGTH",
  [ RTEMS_RECORD_LINE ] = "LINE",
  [ RTEMS_RECORD_LINK_ENTRY ] = "LINK_ENTRY",
  [ RTEMS_RECORD_LINK_EXIT ] = "LINK_EXIT",
  [ RTEMS_RECORD_LISTEN_ENTRY ] = "LISTEN_ENTRY",
  [ RTEMS_RECORD_LISTEN_EXIT ] = "LISTEN_EXIT",
  [ RTEMS_RECORD_LSEEK_ENTRY ] = "LSEEK_ENTRY",
  [ RTEMS_RECORD_LSEEK_EXIT ] = "LSEEK_EXIT",
  [ RTEMS_RECORD_MALLOC_ENTRY ] = "MALLOC_ENTRY",
  [ RTEMS_RECORD_MALLOC_EXIT ] = "MALLOC_EXIT",
  [ RTEMS_RECORD_MEMORY ] = "MEMORY",
  [ RTEMS_RECORD_MKNOD_ENTRY ] = "MKNOD_ENTRY",
  [ RTEMS_RECORD_MKNOD_EXIT ] = "MKNOD_EXIT",
  [ RTEMS_RECORD_MMAP_ENTRY ] = "MMAP_ENTRY",
  [ RTEMS_RECORD_MMAP_EXIT ] = "MMAP_EXIT",
  [ RTEMS_RECORD_MOUNT_ENTRY ] = "MOUNT_ENTRY",
  [ RTEMS_RECORD_MOUNT_EXIT ] = "MOUNT_EXIT",
  [ RTEMS_RECORD_OPEN_ENTRY ] = "OPEN_ENTRY",
  [ RTEMS_RECORD_OPEN_EXIT ] = "OPEN_EXIT",
  [ RTEMS_RECORD_PAGE_ALLOC ] = "PAGE_ALLOC",
  [ RTEMS_RECORD_PAGE_FREE ] = "PAGE_FREE",
  [ RTEMS_RECORD_POLL_ENTRY ] = "POLL_ENTRY",
  [ RTEMS_RECORD_POLL_EXIT ] = "POLL_EXIT",
  [ RTEMS_RECORD_POSIX_MEMALIGN_ENTRY ] = "POSIX_MEMALIGN_ENTRY",
  [ RTEMS_RECORD_POSIX_MEMALIGN_EXIT ] = "POSIX_MEMALIGN_EXIT",
  [ RTEMS_RECORD_READ_ENTRY ] = "READ_ENTRY",
  [ RTEMS_RECORD_READ_EXIT ] = "READ_EXIT",
  [ RTEMS_RECORD_READLINK_ENTRY ] = "READLINK_ENTRY",
  [ RTEMS_RECORD_READLINK_EXIT ] = "READLINK_EXIT",
  [ RTEMS_RECORD_READV_ENTRY ] = "READV_ENTRY",
  [ RTEMS_RECORD_READV_EXIT ] = "READV_EXIT",
  [ RTEMS_RECORD_REALLOC_ENTRY ] = "REALLOC_ENTRY",
  [ RTEMS_RECORD_REALLOC_EXIT ] = "REALLOC_EXIT",
  [ RTEMS_RECORD_RECV_ENTRY ] = "RECV_ENTRY",
  [ RTEMS_RECORD_RECV_EXIT ] = "RECV_EXIT",
  [ RTEMS_RECORD_RECVFROM_ENTRY ] = "RECVFROM_ENTRY",
  [ RTEMS_RECORD_RECVFROM_EXIT ] = "RECVFROM_EXIT",
  [ RTEMS_RECORD_RECVMSG_ENTRY ] = "RECVMSG_ENTRY",
  [ RTEMS_RECORD_RECVMSG_EXIT ] = "RECVMSG_EXIT",
  [ RTEMS_RECORD_REGISTERS ] = "REGISTERS",
  [ RTEMS_RECORD_RENAME_ENTRY ] = "RENAME_ENTRY",
  [ RTEMS_RECORD_RENAME_EXIT ] = "RENAME_EXIT",
  [ RTEMS_RECORD_RETURN_0 ] = "RETURN_0",
  [ RTEMS_RECORD_RETURN_1 ] = "RETURN_1",
  [ RTEMS_RECORD_RETURN_2 ] = "RETURN_2",
  [ RTEMS_RECORD_RETURN_3 ] = "RETURN_3",
  [ RTEMS_RECORD_RETURN_4 ] = "RETURN_4",
  [ RTEMS_RECORD_RETURN_5 ] = "RETURN_5",
  [ RTEMS_RECORD_RETURN_6 ] = "RETURN_6",
  [ RTEMS_RECORD_RETURN_7 ] = "RETURN_7",
  [ RTEMS_RECORD_RETURN_8 ] = "RETURN_8",
  [ RTEMS_RECORD_RETURN_9 ] = "RETURN_9",
  [ RTEMS_RECORD_RTEMS_BARRIER_CREATE ] = "RTEMS_BARRIER_CREATE",
  [ RTEMS_RECORD_RTEMS_BARRIER_DELETE ] = "RTEMS_BARRIER_DELETE",
  [ RTEMS_RECORD_RTEMS_BARRIER_RELEASE ] = "RTEMS_BARRIER_RELEASE",
  [ RTEMS_RECORD_RTEMS_BARRIER_WAIT ] = "RTEMS_BARRIER_WAIT",
  [ RTEMS_RECORD_RTEMS_CALLOC_ENTRY ] = "RTEMS_CALLOC_ENTRY",
  [ RTEMS_RECORD_RTEMS_CALLOC_EXIT ] = "RTEMS_CALLOC_EXIT",
  [ RTEMS_RECORD_RTEMS_EVENT_RECEIVE ] = "RTEMS_EVENT_RECEIVE",
  [ RTEMS_RECORD_RTEMS_EVENT_SEND ] = "RTEMS_EVENT_SEND",
  [ RTEMS_RECORD_RTEMS_EVENT_SYSTEM_RECEIVE ] = "RTEMS_EVENT_SYSTEM_RECEIVE",
  [ RTEMS_RECORD_RTEMS_EVENT_SYSTEM_SEND ] = "RTEMS_EVENT_SYSTEM_SEND",
  [ RTEMS_RECORD_RTEMS_MALLOC_ENTRY ] = "RTEMS_MALLOC_ENTRY",
  [ RTEMS_RECORD_RTEMS_MALLOC_EXIT ] = "RTEMS_MALLOC_EXIT",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_BROADCAST ] = "RTEMS_MESSAGE_QUEUE_BROADCAST",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_CREATE ] = "RTEMS_MESSAGE_QUEUE_CREATE",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_DELETE ] = "RTEMS_MESSAGE_QUEUE_DELETE",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_FLUSH ] = "RTEMS_MESSAGE_QUEUE_FLUSH",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_RECEIVE ] = "RTEMS_MESSAGE_QUEUE_RECEIVE",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_SEND ] = "RTEMS_MESSAGE_QUEUE_SEND",
  [ RTEMS_RECORD_RTEMS_MESSAGE_QUEUE_URGENT ] = "RTEMS_MESSAGE_QUEUE_URGENT",
  [ RTEMS_RECORD_RTEMS_PARTITION_CREATE ] = "RTEMS_PARTITION_CREATE",
  [ RTEMS_RECORD_RTEMS_PARTITION_DELETE ] = "RTEMS_PARTITION_DELETE",
  [ RTEMS_RECORD_RTEMS_PARTITION_GET_BUFFER ] = "RTEMS_PARTITION_GET_BUFFER",
  [ RTEMS_RECORD_RTEMS_PARTITION_RETURN_BUFFER ] = "RTEMS_PARTITION_RETURN_BUFFER",
  [ RTEMS_RECORD_RTEMS_RATE_MONOTONIC_CANCEL ] = "RTEMS_RATE_MONOTONIC_CANCEL",
  [ RTEMS_RECORD_RTEMS_RATE_MONOTONIC_CREATE ] = "RTEMS_RATE_MONOTONIC_CREATE",
  [ RTEMS_RECORD_RTEMS_RATE_MONOTONIC_DELETE ] = "RTEMS_RATE_MONOTONIC_DELETE",
  [ RTEMS_RECORD_RTEMS_RATE_MONOTONIC_PERIOD ] = "RTEMS_RATE_MONOTONIC_PERIOD",
  [ RTEMS_RECORD_RTEMS_SEMAPHORE_CREATE ] = "RTEMS_SEMAPHORE_CREATE",
  [ RTEMS_RECORD_RTEMS_SEMAPHORE_DELETE ] = "RTEMS_SEMAPHORE_DELETE",
  [ RTEMS_RECORD_RTEMS_SEMAPHORE_FLUSH ] = "RTEMS_SEMAPHORE_FLUSH",
  [ RTEMS_RECORD_RTEMS_SEMAPHORE_OBTAIN ] = "RTEMS_SEMAPHORE_OBTAIN",
  [ RTEMS_RECORD_RTEMS_SEMAPHORE_RELEASE ] = "RTEMS_SEMAPHORE_RELEASE",
  [ RTEMS_RECORD_RTEMS_TIMER_CANCEL ] = "RTEMS_TIMER_CANCEL",
  [ RTEMS_RECORD_RTEMS_TIMER_CREATE ] = "RTEMS_TIMER_CREATE",
  [ RTEMS_RECORD_RTEMS_TIMER_DELETE ] = "RTEMS_TIMER_DELETE",
  [ RTEMS_RECORD_RTEMS_TIMER_FIRE_AFTER ] = "RTEMS_TIMER_FIRE_AFTER",
  [ RTEMS_RECORD_RTEMS_TIMER_FIRE_WHEN ] = "RTEMS_TIMER_FIRE_WHEN",
  [ RTEMS_RECORD_RTEMS_TIMER_RESET ] = "RTEMS_TIMER_RESET",
  [ RTEMS_RECORD_RTEMS_TIMER_SERVER_FIRE_AFTER ] = "RTEMS_TIMER_SERVER_FIRE_AFTER",
  [ RTEMS_RECORD_RTEMS_TIMER_SERVER_FIRE_WHEN ] = "RTEMS_TIMER_SERVER_FIRE_WHEN",
  [ RTEMS_RECORD_SBWAIT_ENTRY ] = "SBWAIT_ENTRY",
  [ RTEMS_RECORD_SBWAIT_EXIT ] = "SBWAIT_EXIT",
  [ RTEMS_RECORD_SBWAKEUP_ENTRY ] = "SBWAKEUP_ENTRY",
  [ RTEMS_RECORD_SBWAKEUP_EXIT ] = "SBWAKEUP_EXIT",
  [ RTEMS_RECORD_SCHEDULER_ADD_PROCESSOR ] = "SCHEDULER_ADD_PROCESSOR",
  [ RTEMS_RECORD_SCHEDULER_ASK_FOR_HELP ] = "SCHEDULER_ASK_FOR_HELP",
  [ RTEMS_RECORD_SCHEDULER_BLOCK ] = "SCHEDULER_BLOCK",
  [ RTEMS_RECORD_SCHEDULER_CANCEL_JOB ] = "SCHEDULER_CANCEL_JOB",
  [ RTEMS_RECORD_SCHEDULER_ID ] = "SCHEDULER_ID",
  [ RTEMS_RECORD_SCHEDULER_MAP_PRIORITY ] = "SCHEDULER_MAP_PRIORITY",
  [ RTEMS_RECORD_SCHEDULER_NAME ] = "SCHEDULER_NAME",
  [ RTEMS_RECORD_SCHEDULER_PIN ] = "SCHEDULER_PIN",
  [ RTEMS_RECORD_SCHEDULER_RECONSIDER_HELP_REQUEST ] = "SCHEDULER_RECONSIDER_HELP_REQUEST",
  [ RTEMS_RECORD_SCHEDULER_RELEASE_JOB ] = "SCHEDULER_RELEASE_JOB",
  [ RTEMS_RECORD_SCHEDULER_REMOVE_PROCESSOR ] = "SCHEDULER_REMOVE_PROCESSOR",
  [ RTEMS_RECORD_SCHEDULER_SCHEDULE ] = "SCHEDULER_SCHEDULE",
  [ RTEMS_RECORD_SCHEDULER_SET_AFFINITY ] = "SCHEDULER_SET_AFFINITY",
  [ RTEMS_RECORD_SCHEDULER_TICK ] = "SCHEDULER_TICK",
  [ RTEMS_RECORD_SCHEDULER_UNBLOCK ] = "SCHEDULER_UNBLOCK",
  [ RTEMS_RECORD_SCHEDULER_UNMAP_PRIORITY ] = "SCHEDULER_UNMAP_PRIORITY",
  [ RTEMS_RECORD_SCHEDULER_UNPIN ] = "SCHEDULER_UNPIN",
  [ RTEMS_RECORD_SCHEDULER_UPDATE_PRIORITY ] = "SCHEDULER_UPDATE_PRIORITY",
  [ RTEMS_RECORD_SCHEDULER_WITHDRAW_NODE ] = "SCHEDULER_WITHDRAW_NODE",
  [ RTEMS_RECORD_SCHEDULER_YIELD ] = "SCHEDULER_YIELD",
  [ RTEMS_RECORD_SELECT_ENTRY ] = "SELECT_ENTRY",
  [ RTEMS_RECORD_SELECT_EXIT ] = "SELECT_EXIT",
  [ RTEMS_RECORD_SEND_ENTRY ] = "SEND_ENTRY",
  [ RTEMS_RECORD_SEND_EXIT ] = "SEND_EXIT",
  [ RTEMS_RECORD_SENDMSG_ENTRY ] = "SENDMSG_ENTRY",
  [ RTEMS_RECORD_SENDMSG_EXIT ] = "SENDMSG_EXIT",
  [ RTEMS_RECORD_SENDTO_ENTRY ] = "SENDTO_ENTRY",
  [ RTEMS_RECORD_SENDTO_EXIT ] = "SENDTO_EXIT",
  [ RTEMS_RECORD_SETSOCKOPT_ENTRY ] = "SETSOCKOPT_ENTRY",
  [ RTEMS_RECORD_SETSOCKOPT_EXIT ] = "SETSOCKOPT_EXIT",
  [ RTEMS_RECORD_SHUTDOWN_ENTRY ] = "SHUTDOWN_ENTRY",
  [ RTEMS_RECORD_SHUTDOWN_EXIT ] = "SHUTDOWN_EXIT",
  [ RTEMS_RECORD_SOABORT_ENTRY ] = "SOABORT_ENTRY",
  [ RTEMS_RECORD_SOABORT_EXIT ] = "SOABORT_EXIT",
  [ RTEMS_RECORD_SOACCEPT_ENTRY ] = "SOACCEPT_ENTRY",
  [ RTEMS_RECORD_SOACCEPT_EXIT ] = "SOACCEPT_EXIT",
  [ RTEMS_RECORD_SOALLOC_ENTRY ] = "SOALLOC_ENTRY",
  [ RTEMS_RECORD_SOALLOC_EXIT ] = "SOALLOC_EXIT",
  [ RTEMS_RECORD_SOBINDAT_ENTRY ] = "SOBINDAT_ENTRY",
  [ RTEMS_RECORD_SOBINDAT_EXIT ] = "SOBINDAT_EXIT",
  [ RTEMS_RECORD_SOBIND_ENTRY ] = "SOBIND_ENTRY",
  [ RTEMS_RECORD_SOBIND_EXIT ] = "SOBIND_EXIT",
  [ RTEMS_RECORD_SOCKET_ENTRY ] = "SOCKET_ENTRY",
  [ RTEMS_RECORD_SOCKET_EXIT ] = "SOCKET_EXIT",
  [ RTEMS_RECORD_SOCLOSE_ENTRY ] = "SOCLOSE_ENTRY",
  [ RTEMS_RECORD_SOCLOSE_EXIT ] = "SOCLOSE_EXIT",
  [ RTEMS_RECORD_SOCONNECT2_ENTRY ] = "SOCONNECT2_ENTRY",
  [ RTEMS_RECORD_SOCONNECT2_EXIT ] = "SOCONNECT2_EXIT",
  [ RTEMS_RECORD_SOCONNECTAT_ENTRY ] = "SOCONNECTAT_ENTRY",
  [ RTEMS_RECORD_SOCONNECTAT_EXIT ] = "SOCONNECTAT_EXIT",
  [ RTEMS_RECORD_SOCREATE_ENTRY ] = "SOCREATE_ENTRY",
  [ RTEMS_RECORD_SOCREATE_EXIT ] = "SOCREATE_EXIT",
  [ RTEMS_RECORD_SODEALLOC_ENTRY ] = "SODEALLOC_ENTRY",
  [ RTEMS_RECORD_SODEALLOC_EXIT ] = "SODEALLOC_EXIT",
  [ RTEMS_RECORD_SODISCONNECT_ENTRY ] = "SODISCONNECT_ENTRY",
  [ RTEMS_RECORD_SODISCONNECT_EXIT ] = "SODISCONNECT_EXIT",
  [ RTEMS_RECORD_SOFREE_ENTRY ] = "SOFREE_ENTRY",
  [ RTEMS_RECORD_SOFREE_EXIT ] = "SOFREE_EXIT",
  [ RTEMS_RECORD_SOLISTEN_ENTRY ] = "SOLISTEN_ENTRY",
  [ RTEMS_RECORD_SOLISTEN_EXIT ] = "SOLISTEN_EXIT",
  [ RTEMS_RECORD_SONEWCONN_ENTRY ] = "SONEWCONN_ENTRY",
  [ RTEMS_RECORD_SONEWCONN_EXIT ] = "SONEWCONN_EXIT",
  [ RTEMS_RECORD_SORECEIVE_ENTRY ] = "SORECEIVE_ENTRY",
  [ RTEMS_RECORD_SORECEIVE_EXIT ] = "SORECEIVE_EXIT",
  [ RTEMS_RECORD_SORFLUSH_ENTRY ] = "SORFLUSH_ENTRY",
  [ RTEMS_RECORD_SORFLUSH_EXIT ] = "SORFLUSH_EXIT",
  [ RTEMS_RECORD_SOSEND_ENTRY ] = "SOSEND_ENTRY",
  [ RTEMS_RECORD_SOSEND_EXIT ] = "SOSEND_EXIT",
  [ RTEMS_RECORD_SOSHUTDOWN_ENTRY ] = "SOSHUTDOWN_ENTRY",
  [ RTEMS_RECORD_SOSHUTDOWN_EXIT ] = "SOSHUTDOWN_EXIT",
  [ RTEMS_RECORD_STATVFS_ENTRY ] = "STATVFS_ENTRY",
  [ RTEMS_RECORD_STATVFS_EXIT ] = "STATVFS_EXIT",
  [ RTEMS_RECORD_SYMLINK_ENTRY ] = "SYMLINK_ENTRY",
  [ RTEMS_RECORD_SYMLINK_EXIT ] = "SYMLINK_EXIT",
  [ RTEMS_RECORD_TCP_CLOSE ] = "TCP_CLOSE",
  [ RTEMS_RECORD_TCP_INPUT ] = "TCP_INPUT",
  [ RTEMS_RECORD_TCP_OUTPUT ] = "TCP_OUTPUT",
  [ RTEMS_RECORD_THREAD_BEGIN ] = "THREAD_BEGIN",
  [ RTEMS_RECORD_THREAD_CONTINUE_ENTRY ] = "THREAD_CONTINUE_ENTRY",
  [ RTEMS_RECORD_THREAD_CONTINUE_EXIT ] = "THREAD_CONTINUE_EXIT",
  [ RTEMS_RECORD_THREAD_CREATE ] = "THREAD_CREATE",
  [ RTEMS_RECORD_THREAD_DELETE ] = "THREAD_DELETE",
  [ RTEMS_RECORD_THREAD_DISPATCH_DISABLE ] = "THREAD_DISPATCH_DISABLE",
  [ RTEMS_RECORD_THREAD_DISPATCH_ENABLE ] = "THREAD_DISPATCH_ENABLE",
  [ RTEMS_RECORD_THREAD_EXIT ] = "THREAD_EXIT",
  [ RTEMS_RECORD_THREAD_EXITTED ] = "THREAD_EXITTED",
  [ RTEMS_RECORD_THREAD_PRIO_CURRENT_HIGH ] = "THREAD_PRIO_CURRENT_HIGH",
  [ RTEMS_RECORD_THREAD_PRIO_CURRENT_LOW ] = "THREAD_PRIO_CURRENT_LOW",
  [ RTEMS_RECORD_THREAD_PRIO_REAL_HIGH ] = "THREAD_PRIO_REAL_HIGH",
  [ RTEMS_RECORD_THREAD_PRIO_REAL_LOW ] = "THREAD_PRIO_REAL_LOW",
  [ RTEMS_RECORD_THREAD_QUEUE_ADDRESS ] = "THREAD_QUEUE_ADDRESS",
  [ RTEMS_RECORD_THREAD_QUEUE_DESTROY ] = "THREAD_QUEUE_DESTROY",
  [ RTEMS_RECORD_THREAD_QUEUE_ENQUEUE ] = "THREAD_QUEUE_ENQUEUE",
  [ RTEMS_RECORD_THREAD_QUEUE_ENQUEUE_STICKY ] = "THREAD_QUEUE_ENQUEUE_STICKY",
  [ RTEMS_RECORD_THREAD_QUEUE_EXTRACT ] = "THREAD_QUEUE_EXTRACT",
  [ RTEMS_RECORD_THREAD_QUEUE_ID ] = "THREAD_QUEUE_ID",
  [ RTEMS_RECORD_THREAD_QUEUE_INITIALIZE ] = "THREAD_QUEUE_INITIALIZE",
  [ RTEMS_RECORD_THREAD_QUEUE_NAME ] = "THREAD_QUEUE_NAME",
  [ RTEMS_RECORD_THREAD_QUEUE_SURRENDER ] = "THREAD_QUEUE_SURRENDER",
  [ RTEMS_RECORD_THREAD_QUEUE_SURRENDER_STICKY ] = "THREAD_QUEUE_SURRENDER_STICKY",
  [ RTEMS_RECORD_THREAD_RESOURCE_OBTAIN ] = "THREAD_RESOURCE_OBTAIN",
  [ RTEMS_RECORD_THREAD_RESOURCE_RELEASE ] = "THREAD_RESOURCE_RELEASE",
  [ RTEMS_RECORD_THREAD_RESTART ] = "THREAD_RESTART",
  [ RTEMS_RECORD_THREAD_STACK_CURRENT ] = "THREAD_STACK_CURRENT",
  [ RTEMS_RECORD_THREAD_STACK_SIZE ] = "THREAD_STACK_SIZE",
  [ RTEMS_RECORD_THREAD_STACK_USAGE ] = "THREAD_STACK_USAGE",
  [ RTEMS_RECORD_THREAD_START ] = "THREAD_START",
  [ RTEMS_RECORD_THREAD_STATE_CLEAR ] = "THREAD_STATE_CLEAR",
  [ RTEMS_RECORD_THREAD_STATE_SET ] = "THREAD_STATE_SET",
  [ RTEMS_RECORD_THREAD_SWITCH_IN ] = "THREAD_SWITCH_IN",
  [ RTEMS_RECORD_THREAD_SWITCH_OUT ] = "THREAD_SWITCH_OUT",
  [ RTEMS_RECORD_THREAD_TERMINATE ] = "THREAD_TERMINATE",
  [ RTEMS_RECORD_THREAD_TIMER_INSERT_MONOTONIC ] = "THREAD_TIMER_INSERT_MONOTONIC",
  [ RTEMS_RECORD_THREAD_TIMER_INSERT_REALTIME ] = "THREAD_TIMER_INSERT_REALTIME",
  [ RTEMS_RECORD_THREAD_TIMER_INSERT_TICKS ] = "THREAD_TIMER_INSERT_TICKS",
  [ RTEMS_RECORD_THREAD_TIMER_REMOVE ] = "THREAD_TIMER_REMOVE",
  [ RTEMS_RECORD_UDP_INPUT ] = "UDP_INPUT",
  [ RTEMS_RECORD_UDP_OUTPUT ] = "UDP_OUTPUT",
  [ RTEMS_RECORD_UMA_ALLOC_PTR ] = "UMA_ALLOC_PTR",
  [ RTEMS_RECORD_UMA_ALLOC_ZONE ] = "UMA_ALLOC_ZONE",
  [ RTEMS_RECORD_UMA_FREE_PTR ] = "UMA_FREE_PTR",
  [ RTEMS_RECORD_UMA_FREE_ZONE ] = "UMA_FREE_ZONE",
  [ RTEMS_RECORD_UNLINK_ENTRY ] = "UNLINK_ENTRY",
  [ RTEMS_RECORD_UNLINK_EXIT ] = "UNLINK_EXIT",
  [ RTEMS_RECORD_UNMOUNT_ENTRY ] = "UNMOUNT_ENTRY",
  [ RTEMS_RECORD_UNMOUNT_EXIT ] = "UNMOUNT_EXIT",
  [ RTEMS_RECORD_UPTIME_HIGH ] = "UPTIME_HIGH",
  [ RTEMS_RECORD_UPTIME_LOW ] = "UPTIME_LOW",
  [ RTEMS_RECORD_WATCHDOG_ADDRESS ] = "WATCHDOG_ADDRESS",
  [ RTEMS_RECORD_WATCHDOG_CPU ] = "WATCHDOG_CPU",
  [ RTEMS_RECORD_WATCHDOG_INITIALIZE ] = "WATCHDOG_INITIALIZE",
  [ RTEMS_RECORD_WATCHDOG_INSERT ] = "WATCHDOG_INSERT",
  [ RTEMS_RECORD_WATCHDOG_PREINITIALIZE ] = "WATCHDOG_PREINITIALIZE",
  [ RTEMS_RECORD_WATCHDOG_REMOVE ] = "WATCHDOG_REMOVE",
  [ RTEMS_RECORD_WATCHDOG_ROUTINE ] = "WATCHDOG_ROUTINE",
  [ RTEMS_RECORD_WATCHDOG_STATE ] = "WATCHDOG_STATE",
  [ RTEMS_RECORD_WORKSPACE_ALLOC_ENTRY ] = "WORKSPACE_ALLOC_ENTRY",
  [ RTEMS_RECORD_WORKSPACE_ALLOC_EXIT ] = "WORKSPACE_ALLOC_EXIT",
  [ RTEMS_RECORD_WORKSPACE_FREE_ENTY ] = "WORKSPACE_FREE_ENTY",
  [ RTEMS_RECORD_WORKSPACE_FREE_EXIT ] = "WORKSPACE_FREE_EXIT",
  [ RTEMS_RECORD_WORKSPACE_SIZE ] = "WORKSPACE_SIZE",
  [ RTEMS_RECORD_WORKSPACE_USAGE ] = "WORKSPACE_USAGE",
  [ RTEMS_RECORD_WRITE_ENTRY ] = "WRITE_ENTRY",
  [ RTEMS_RECORD_WRITE_EXIT ] = "WRITE_EXIT",
  [ RTEMS_RECORD_WRITEV_ENTRY ] = "WRITEV_ENTRY",
  [ RTEMS_RECORD_WRITEV_EXIT ] = "WRITEV_EXIT",
  [ RTEMS_RECORD_SYSTEM_342 ] = "SYSTEM_342",
  [ RTEMS_RECORD_SYSTEM_343 ] = "SYSTEM_343",
  [ RTEMS_RECORD_SYSTEM_344 ] = "SYSTEM_344",
  [ RTEMS_RECORD_SYSTEM_345 ] = "SYSTEM_345",
  [ RTEMS_RECORD_SYSTEM_346 ] = "SYSTEM_346",
  [ RTEMS_RECORD_SYSTEM_347 ] = "SYSTEM_347",
  [ RTEMS_RECORD_SYSTEM_348 ] = "SYSTEM_348",
  [ RTEMS_RECORD_SYSTEM_349 ] = "SYSTEM_349",
  [ RTEMS_RECORD_SYSTEM_350 ] = "SYSTEM_350",
  [ RTEMS_RECORD_SYSTEM_351 ] = "SYSTEM_351",
  [ RTEMS_RECORD_SYSTEM_352 ] = "SYSTEM_352",
  [ RTEMS_RECORD_SYSTEM_353 ] = "SYSTEM_353",
  [ RTEMS_RECORD_SYSTEM_354 ] = "SYSTEM_354",
  [ RTEMS_RECORD_SYSTEM_355 ] = "SYSTEM_355",
  [ RTEMS_RECORD_SYSTEM_356 ] = "SYSTEM_356",
  [ RTEMS_RECORD_SYSTEM_357 ] = "SYSTEM_357",
  [ RTEMS_RECORD_SYSTEM_358 ] = "SYSTEM_358",
  [ RTEMS_RECORD_SYSTEM_359 ] = "SYSTEM_359",
  [ RTEMS_RECORD_SYSTEM_360 ] = "SYSTEM_360",
  [ RTEMS_RECORD_SYSTEM_361 ] = "SYSTEM_361",
  [ RTEMS_RECORD_SYSTEM_362 ] = "SYSTEM_362",
  [ RTEMS_RECORD_SYSTEM_363 ] = "SYSTEM_363",
  [ RTEMS_RECORD_SYSTEM_364 ] = "SYSTEM_364",
  [ RTEMS_RECORD_SYSTEM_365 ] = "SYSTEM_365",
  [ RTEMS_RECORD_SYSTEM_366 ] = "SYSTEM_366",
  [ RTEMS_RECORD_SYSTEM_367 ] = "SYSTEM_367",
  [ RTEMS_RECORD_SYSTEM_368 ] = "SYSTEM_368",
  [ RTEMS_RECORD_SYSTEM_369 ] = "SYSTEM_369",
  [ RTEMS_RECORD_SYSTEM_370 ] = "SYSTEM_370",
  [ RTEMS_RECORD_SYSTEM_371 ] = "SYSTEM_371",
  [ RTEMS_RECORD_SYSTEM_372 ] = "SYSTEM_372",
  [ RTEMS_RECORD_SYSTEM_373 ] = "SYSTEM_373",
  [ RTEMS_RECORD_SYSTEM_374 ] = "SYSTEM_374",
  [ RTEMS_RECORD_SYSTEM_375 ] = "SYSTEM_375",
  [ RTEMS_RECORD_SYSTEM_376 ] = "SYSTEM_376",
  [ RTEMS_RECORD_SYSTEM_377 ] = "SYSTEM_377",
  [ RTEMS_RECORD_SYSTEM_378 ] = "SYSTEM_378",
  [ RTEMS_RECORD_SYSTEM_379 ] = "SYSTEM_379",
  [ RTEMS_RECORD_SYSTEM_380 ] = "SYSTEM_380",
  [ RTEMS_RECORD_SYSTEM_381 ] = "SYSTEM_381",
  [ RTEMS_RECORD_SYSTEM_382 ] = "SYSTEM_382",
  [ RTEMS_RECORD_SYSTEM_383 ] = "SYSTEM_383",
  [ RTEMS_RECORD_SYSTEM_384 ] = "SYSTEM_384",
  [ RTEMS_RECORD_SYSTEM_385 ] = "SYSTEM_385",
  [ RTEMS_RECORD_SYSTEM_386 ] = "SYSTEM_386",
  [ RTEMS_RECORD_SYSTEM_387 ] = "SYSTEM_387",
  [ RTEMS_RECORD_SYSTEM_388 ] = "SYSTEM_388",
  [ RTEMS_RECORD_SYSTEM_389 ] = "SYSTEM_389",
  [ RTEMS_RECORD_SYSTEM_390 ] = "SYSTEM_390",
  [ RTEMS_RECORD_SYSTEM_391 ] = "SYSTEM_391",
  [ RTEMS_RECORD_SYSTEM_392 ] = "SYSTEM_392",
  [ RTEMS_RECORD_SYSTEM_393 ] = "SYSTEM_393",
  [ RTEMS_RECORD_SYSTEM_394 ] = "SYSTEM_394",
  [ RTEMS_RECORD_SYSTEM_395 ] = "SYSTEM_395",
  [ RTEMS_RECORD_SYSTEM_396 ] = "SYSTEM_396",
  [ RTEMS_RECORD_SYSTEM_397 ] = "SYSTEM_397",
  [ RTEMS_RECORD_SYSTEM_398 ] = "SYSTEM_398",
  [ RTEMS_RECORD_SYSTEM_399 ] = "SYSTEM_399",
  [ RTEMS_RECORD_SYSTEM_400 ] = "SYSTEM_400",
  [ RTEMS_RECORD_SYSTEM_401 ] = "SYSTEM_401",
  [ RTEMS_RECORD_SYSTEM_402 ] = "SYSTEM_402",
  [ RTEMS_RECORD_SYSTEM_403 ] = "SYSTEM_403",
  [ RTEMS_RECORD_SYSTEM_404 ] = "SYSTEM_404",
  [ RTEMS_RECORD_SYSTEM_405 ] = "SYSTEM_405",
  [ RTEMS_RECORD_SYSTEM_406 ] = "SYSTEM_406",
  [ RTEMS_RECORD_SYSTEM_407 ] = "SYSTEM_407",
  [ RTEMS_RECORD_SYSTEM_408 ] = "SYSTEM_408",
  [ RTEMS_RECORD_SYSTEM_409 ] = "SYSTEM_409",
  [ RTEMS_RECORD_SYSTEM_410 ] = "SYSTEM_410",
  [ RTEMS_RECORD_SYSTEM_411 ] = "SYSTEM_411",
  [ RTEMS_RECORD_SYSTEM_412 ] = "SYSTEM_412",
  [ RTEMS_RECORD_SYSTEM_413 ] = "SYSTEM_413",
  [ RTEMS_RECORD_SYSTEM_414 ] = "SYSTEM_414",
  [ RTEMS_RECORD_SYSTEM_415 ] = "SYSTEM_415",
  [ RTEMS_RECORD_SYSTEM_416 ] = "SYSTEM_416",
  [ RTEMS_RECORD_SYSTEM_417 ] = "SYSTEM_417",
  [ RTEMS_RECORD_SYSTEM_418 ] = "SYSTEM_418",
  [ RTEMS_RECORD_SYSTEM_419 ] = "SYSTEM_419",
  [ RTEMS_RECORD_SYSTEM_420 ] = "SYSTEM_420",
  [ RTEMS_RECORD_SYSTEM_421 ] = "SYSTEM_421",
  [ RTEMS_RECORD_SYSTEM_422 ] = "SYSTEM_422",
  [ RTEMS_RECORD_SYSTEM_423 ] = "SYSTEM_423",
  [ RTEMS_RECORD_SYSTEM_424 ] = "SYSTEM_424",
  [ RTEMS_RECORD_SYSTEM_425 ] = "SYSTEM_425",
  [ RTEMS_RECORD_SYSTEM_426 ] = "SYSTEM_426",
  [ RTEMS_RECORD_SYSTEM_427 ] = "SYSTEM_427",
  [ RTEMS_RECORD_SYSTEM_428 ] = "SYSTEM_428",
  [ RTEMS_RECORD_SYSTEM_429 ] = "SYSTEM_429",
  [ RTEMS_RECORD_SYSTEM_430 ] = "SYSTEM_430",
  [ RTEMS_RECORD_SYSTEM_431 ] = "SYSTEM_431",
  [ RTEMS_RECORD_SYSTEM_432 ] = "SYSTEM_432",
  [ RTEMS_RECORD_SYSTEM_433 ] = "SYSTEM_433",
  [ RTEMS_RECORD_SYSTEM_434 ] = "SYSTEM_434",
  [ RTEMS_RECORD_SYSTEM_435 ] = "SYSTEM_435",
  [ RTEMS_RECORD_SYSTEM_436 ] = "SYSTEM_436",
  [ RTEMS_RECORD_SYSTEM_437 ] = "SYSTEM_437",
  [ RTEMS_RECORD_SYSTEM_438 ] = "SYSTEM_438",
  [ RTEMS_RECORD_SYSTEM_439 ] = "SYSTEM_439",
  [ RTEMS_RECORD_SYSTEM_440 ] = "SYSTEM_440",
  [ RTEMS_RECORD_SYSTEM_441 ] = "SYSTEM_441",
  [ RTEMS_RECORD_SYSTEM_442 ] = "SYSTEM_442",
  [ RTEMS_RECORD_SYSTEM_443 ] = "SYSTEM_443",
  [ RTEMS_RECORD_SYSTEM_444 ] = "SYSTEM_444",
  [ RTEMS_RECORD_SYSTEM_445 ] = "SYSTEM_445",
  [ RTEMS_RECORD_SYSTEM_446 ] = "SYSTEM_446",
  [ RTEMS_RECORD_SYSTEM_447 ] = "SYSTEM_447",
  [ RTEMS_RECORD_SYSTEM_448 ] = "SYSTEM_448",
  [ RTEMS_RECORD_SYSTEM_449 ] = "SYSTEM_449",
  [ RTEMS_RECORD_SYSTEM_450 ] = "SYSTEM_450",
  [ RTEMS_RECORD_SYSTEM_451 ] = "SYSTEM_451",
  [ RTEMS_RECORD_SYSTEM_452 ] = "SYSTEM_452",
  [ RTEMS_RECORD_SYSTEM_453 ] = "SYSTEM_453",
  [ RTEMS_RECORD_SYSTEM_454 ] = "SYSTEM_454",
  [ RTEMS_RECORD_SYSTEM_455 ] = "SYSTEM_455",
  [ RTEMS_RECORD_SYSTEM_456 ] = "SYSTEM_456",
  [ RTEMS_RECORD_SYSTEM_457 ] = "SYSTEM_457",
  [ RTEMS_RECORD_SYSTEM_458 ] = "SYSTEM_458",
  [ RTEMS_RECORD_SYSTEM_459 ] = "SYSTEM_459",
  [ RTEMS_RECORD_SYSTEM_460 ] = "SYSTEM_460",
  [ RTEMS_RECORD_SYSTEM_461 ] = "SYSTEM_461",
  [ RTEMS_RECORD_SYSTEM_462 ] = "SYSTEM_462",
  [ RTEMS_RECORD_SYSTEM_463 ] = "SYSTEM_463",
  [ RTEMS_RECORD_SYSTEM_464 ] = "SYSTEM_464",
  [ RTEMS_RECORD_SYSTEM_465 ] = "SYSTEM_465",
  [ RTEMS_RECORD_SYSTEM_466 ] = "SYSTEM_466",
  [ RTEMS_RECORD_SYSTEM_467 ] = "SYSTEM_467",
  [ RTEMS_RECORD_SYSTEM_468 ] = "SYSTEM_468",
  [ RTEMS_RECORD_SYSTEM_469 ] = "SYSTEM_469",
  [ RTEMS_RECORD_SYSTEM_470 ] = "SYSTEM_470",
  [ RTEMS_RECORD_SYSTEM_471 ] = "SYSTEM_471",
  [ RTEMS_RECORD_SYSTEM_472 ] = "SYSTEM_472",
  [ RTEMS_RECORD_SYSTEM_473 ] = "SYSTEM_473",
  [ RTEMS_RECORD_SYSTEM_474 ] = "SYSTEM_474",
  [ RTEMS_RECORD_SYSTEM_475 ] = "SYSTEM_475",
  [ RTEMS_RECORD_SYSTEM_476 ] = "SYSTEM_476",
  [ RTEMS_RECORD_SYSTEM_477 ] = "SYSTEM_477",
  [ RTEMS_RECORD_SYSTEM_478 ] = "SYSTEM_478",
  [ RTEMS_RECORD_SYSTEM_479 ] = "SYSTEM_479",
  [ RTEMS_RECORD_SYSTEM_480 ] = "SYSTEM_480",
  [ RTEMS_RECORD_SYSTEM_481 ] = "SYSTEM_481",
  [ RTEMS_RECORD_SYSTEM_482 ] = "SYSTEM_482",
  [ RTEMS_RECORD_SYSTEM_483 ] = "SYSTEM_483",
  [ RTEMS_RECORD_SYSTEM_484 ] = "SYSTEM_484",
  [ RTEMS_RECORD_SYSTEM_485 ] = "SYSTEM_485",
  [ RTEMS_RECORD_SYSTEM_486 ] = "SYSTEM_486",
  [ RTEMS_RECORD_SYSTEM_487 ] = "SYSTEM_487",
  [ RTEMS_RECORD_SYSTEM_488 ] = "SYSTEM_488",
  [ RTEMS_RECORD_SYSTEM_489 ] = "SYSTEM_489",
  [ RTEMS_RECORD_SYSTEM_490 ] = "SYSTEM_490",
  [ RTEMS_RECORD_SYSTEM_491 ] = "SYSTEM_491",
  [ RTEMS_RECORD_SYSTEM_492 ] = "SYSTEM_492",
  [ RTEMS_RECORD_SYSTEM_493 ] = "SYSTEM_493",
  [ RTEMS_RECORD_SYSTEM_494 ] = "SYSTEM_494",
  [ RTEMS_RECORD_SYSTEM_495 ] = "SYSTEM_495",
  [ RTEMS_RECORD_SYSTEM_496 ] = "SYSTEM_496",
  [ RTEMS_RECORD_SYSTEM_497 ] = "SYSTEM_497",
  [ RTEMS_RECORD_SYSTEM_498 ] = "SYSTEM_498",
  [ RTEMS_RECORD_SYSTEM_499 ] = "SYSTEM_499",
  [ RTEMS_RECORD_SYSTEM_500 ] = "SYSTEM_500",
  [ RTEMS_RECORD_SYSTEM_501 ] = "SYSTEM_501",
  [ RTEMS_RECORD_SYSTEM_502 ] = "SYSTEM_502",
  [ RTEMS_RECORD_SYSTEM_503 ] = "SYSTEM_503",
  [ RTEMS_RECORD_SYSTEM_504 ] = "SYSTEM_504",
  [ RTEMS_RECORD_SYSTEM_505 ] = "SYSTEM_505",
  [ RTEMS_RECORD_SYSTEM_506 ] = "SYSTEM_506",
  [ RTEMS_RECORD_SYSTEM_507 ] = "SYSTEM_507",
  [ RTEMS_RECORD_SYSTEM_508 ] = "SYSTEM_508",
  [ RTEMS_RECORD_SYSTEM_509 ] = "SYSTEM_509",
  [ RTEMS_RECORD_SYSTEM_510 ] = "SYSTEM_510",
  [ RTEMS_RECORD_SYSTEM_511 ] = "SYSTEM_511",
  [ RTEMS_RECORD_USER_0 ] = "USER_0",
  [ RTEMS_RECORD_USER_1 ] = "USER_1",
  [ RTEMS_RECORD_USER_2 ] = "USER_2",
  [ RTEMS_RECORD_USER_3 ] = "USER_3",
  [ RTEMS_RECORD_USER_4 ] = "USER_4",
  [ RTEMS_RECORD_USER_5 ] = "USER_5",
  [ RTEMS_RECORD_USER_6 ] = "USER_6",
  [ RTEMS_RECORD_USER_7 ] = "USER_7",
  [ RTEMS_RECORD_USER_8 ] = "USER_8",
  [ RTEMS_RECORD_USER_9 ] = "USER_9",
  [ RTEMS_RECORD_USER_10 ] = "USER_10",
  [ RTEMS_RECORD_USER_11 ] = "USER_11",
  [ RTEMS_RECORD_USER_12 ] = "USER_12",
  [ RTEMS_RECORD_USER_13 ] = "USER_13",
  [ RTEMS_RECORD_USER_14 ] = "USER_14",
  [ RTEMS_RECORD_USER_15 ] = "USER_15",
  [ RTEMS_RECORD_USER_16 ] = "USER_16",
  [ RTEMS_RECORD_USER_17 ] = "USER_17",
  [ RTEMS_RECORD_USER_18 ] = "USER_18",
  [ RTEMS_RECORD_USER_19 ] = "USER_19",
  [ RTEMS_RECORD_USER_20 ] = "USER_20",
  [ RTEMS_RECORD_USER_21 ] = "USER_21",
  [ RTEMS_RECORD_USER_22 ] = "USER_22",
  [ RTEMS_RECORD_USER_23 ] = "USER_23",
  [ RTEMS_RECORD_USER_24 ] = "USER_24",
  [ RTEMS_RECORD_USER_25 ] = "USER_25",
  [ RTEMS_RECORD_USER_26 ] = "USER_26",
  [ RTEMS_RECORD_USER_27 ] = "USER_27",
  [ RTEMS_RECORD_USER_28 ] = "USER_28",
  [ RTEMS_RECORD_USER_29 ] = "USER_29",
  [ RTEMS_RECORD_USER_30 ] = "USER_30",
  [ RTEMS_RECORD_USER_31 ] = "USER_31",
  [ RTEMS_RECORD_USER_32 ] = "USER_32",
  [ RTEMS_RECORD_USER_33 ] = "USER_33",
  [ RTEMS_RECORD_USER_34 ] = "USER_34",
  [ RTEMS_RECORD_USER_35 ] = "USER_35",
  [ RTEMS_RECORD_USER_36 ] = "USER_36",
  [ RTEMS_RECORD_USER_37 ] = "USER_37",
  [ RTEMS_RECORD_USER_38 ] = "USER_38",
  [ RTEMS_RECORD_USER_39 ] = "USER_39",
  [ RTEMS_RECORD_USER_40 ] = "USER_40",
  [ RTEMS_RECORD_USER_41 ] = "USER_41",
  [ RTEMS_RECORD_USER_42 ] = "USER_42",
  [ RTEMS_RECORD_USER_43 ] = "USER_43",
  [ RTEMS_RECORD_USER_44 ] = "USER_44",
  [ RTEMS_RECORD_USER_45 ] = "USER_45",
  [ RTEMS_RECORD_USER_46 ] = "USER_46",
  [ RTEMS_RECORD_USER_47 ] = "USER_47",
  [ RTEMS_RECORD_USER_48 ] = "USER_48",
  [ RTEMS_RECORD_USER_49 ] = "USER_49",
  [ RTEMS_RECORD_USER_50 ] = "USER_50",
  [ RTEMS_RECORD_USER_51 ] = "USER_51",
  [ RTEMS_RECORD_USER_52 ] = "USER_52",
  [ RTEMS_RECORD_USER_53 ] = "USER_53",
  [ RTEMS_RECORD_USER_54 ] = "USER_54",
  [ RTEMS_RECORD_USER_55 ] = "USER_55",
  [ RTEMS_RECORD_USER_56 ] = "USER_56",
  [ RTEMS_RECORD_USER_57 ] = "USER_57",
  [ RTEMS_RECORD_USER_58 ] = "USER_58",
  [ RTEMS_RECORD_USER_59 ] = "USER_59",
  [ RTEMS_RECORD_USER_60 ] = "USER_60",
  [ RTEMS_RECORD_USER_61 ] = "USER_61",
  [ RTEMS_RECORD_USER_62 ] = "USER_62",
  [ RTEMS_RECORD_USER_63 ] = "USER_63",
  [ RTEMS_RECORD_USER_64 ] = "USER_64",
  [ RTEMS_RECORD_USER_65 ] = "USER_65",
  [ RTEMS_RECORD_USER_66 ] = "USER_66",
  [ RTEMS_RECORD_USER_67 ] = "USER_67",
  [ RTEMS_RECORD_USER_68 ] = "USER_68",
  [ RTEMS_RECORD_USER_69 ] = "USER_69",
  [ RTEMS_RECORD_USER_70 ] = "USER_70",
  [ RTEMS_RECORD_USER_71 ] = "USER_71",
  [ RTEMS_RECORD_USER_72 ] = "USER_72",
  [ RTEMS_RECORD_USER_73 ] = "USER_73",
  [ RTEMS_RECORD_USER_74 ] = "USER_74",
  [ RTEMS_RECORD_USER_75 ] = "USER_75",
  [ RTEMS_RECORD_USER_76 ] = "USER_76",
  [ RTEMS_RECORD_USER_77 ] = "USER_77",
  [ RTEMS_RECORD_USER_78 ] = "USER_78",
  [ RTEMS_RECORD_USER_79 ] = "USER_79",
  [ RTEMS_RECORD_USER_80 ] = "USER_80",
  [ RTEMS_RECORD_USER_81 ] = "USER_81",
  [ RTEMS_RECORD_USER_82 ] = "USER_82",
  [ RTEMS_RECORD_USER_83 ] = "USER_83",
  [ RTEMS_RECORD_USER_84 ] = "USER_84",
  [ RTEMS_RECORD_USER_85 ] = "USER_85",
  [ RTEMS_RECORD_USER_86 ] = "USER_86",
  [ RTEMS_RECORD_USER_87 ] = "USER_87",
  [ RTEMS_RECORD_USER_88 ] = "USER_88",
  [ RTEMS_RECORD_USER_89 ] = "USER_89",
  [ RTEMS_RECORD_USER_90 ] = "USER_90",
  [ RTEMS_RECORD_USER_91 ] = "USER_91",
  [ RTEMS_RECORD_USER_92 ] = "USER_92",
  [ RTEMS_RECORD_USER_93 ] = "USER_93",
  [ RTEMS_RECORD_USER_94 ] = "USER_94",
  [ RTEMS_RECORD_USER_95 ] = "USER_95",
  [ RTEMS_RECORD_USER_96 ] = "USER_96",
  [ RTEMS_RECORD_USER_97 ] = "USER_97",
  [ RTEMS_RECORD_USER_98 ] = "USER_98",
  [ RTEMS_RECORD_USER_99 ] = "USER_99",
  [ RTEMS_RECORD_USER_100 ] = "USER_100",
  [ RTEMS_RECORD_USER_101 ] = "USER_101",
  [ RTEMS_RECORD_USER_102 ] = "USER_102",
  [ RTEMS_RECORD_USER_103 ] = "USER_103",
  [ RTEMS_RECORD_USER_104 ] = "USER_104",
  [ RTEMS_RECORD_USER_105 ] = "USER_105",
  [ RTEMS_RECORD_USER_106 ] = "USER_106",
  [ RTEMS_RECORD_USER_107 ] = "USER_107",
  [ RTEMS_RECORD_USER_108 ] = "USER_108",
  [ RTEMS_RECORD_USER_109 ] = "USER_109",
  [ RTEMS_RECORD_USER_110 ] = "USER_110",
  [ RTEMS_RECORD_USER_111 ] = "USER_111",
  [ RTEMS_RECORD_USER_112 ] = "USER_112",
  [ RTEMS_RECORD_USER_113 ] = "USER_113",
  [ RTEMS_RECORD_USER_114 ] = "USER_114",
  [ RTEMS_RECORD_USER_115 ] = "USER_115",
  [ RTEMS_RECORD_USER_116 ] = "USER_116",
  [ RTEMS_RECORD_USER_117 ] = "USER_117",
  [ RTEMS_RECORD_USER_118 ] = "USER_118",
  [ RTEMS_RECORD_USER_119 ] = "USER_119",
  [ RTEMS_RECORD_USER_120 ] = "USER_120",
  [ RTEMS_RECORD_USER_121 ] = "USER_121",
  [ RTEMS_RECORD_USER_122 ] = "USER_122",
  [ RTEMS_RECORD_USER_123 ] = "USER_123",
  [ RTEMS_RECORD_USER_124 ] = "USER_124",
  [ RTEMS_RECORD_USER_125 ] = "USER_125",
  [ RTEMS_RECORD_USER_126 ] = "USER_126",
  [ RTEMS_RECORD_USER_127 ] = "USER_127",
  [ RTEMS_RECORD_USER_128 ] = "USER_128",
  [ RTEMS_RECORD_USER_129 ] = "USER_129",
  [ RTEMS_RECORD_USER_130 ] = "USER_130",
  [ RTEMS_RECORD_USER_131 ] = "USER_131",
  [ RTEMS_RECORD_USER_132 ] = "USER_132",
  [ RTEMS_RECORD_USER_133 ] = "USER_133",
  [ RTEMS_RECORD_USER_134 ] = "USER_134",
  [ RTEMS_RECORD_USER_135 ] = "USER_135",
  [ RTEMS_RECORD_USER_136 ] = "USER_136",
  [ RTEMS_RECORD_USER_137 ] = "USER_137",
  [ RTEMS_RECORD_USER_138 ] = "USER_138",
  [ RTEMS_RECORD_USER_139 ] = "USER_139",
  [ RTEMS_RECORD_USER_140 ] = "USER_140",
  [ RTEMS_RECORD_USER_141 ] = "USER_141",
  [ RTEMS_RECORD_USER_142 ] = "USER_142",
  [ RTEMS_RECORD_USER_143 ] = "USER_143",
  [ RTEMS_RECORD_USER_144 ] = "USER_144",
  [ RTEMS_RECORD_USER_145 ] = "USER_145",
  [ RTEMS_RECORD_USER_146 ] = "USER_146",
  [ RTEMS_RECORD_USER_147 ] = "USER_147",
  [ RTEMS_RECORD_USER_148 ] = "USER_148",
  [ RTEMS_RECORD_USER_149 ] = "USER_149",
  [ RTEMS_RECORD_USER_150 ] = "USER_150",
  [ RTEMS_RECORD_USER_151 ] = "USER_151",
  [ RTEMS_RECORD_USER_152 ] = "USER_152",
  [ RTEMS_RECORD_USER_153 ] = "USER_153",
  [ RTEMS_RECORD_USER_154 ] = "USER_154",
  [ RTEMS_RECORD_USER_155 ] = "USER_155",
  [ RTEMS_RECORD_USER_156 ] = "USER_156",
  [ RTEMS_RECORD_USER_157 ] = "USER_157",
  [ RTEMS_RECORD_USER_158 ] = "USER_158",
  [ RTEMS_RECORD_USER_159 ] = "USER_159",
  [ RTEMS_RECORD_USER_160 ] = "USER_160",
  [ RTEMS_RECORD_USER_161 ] = "USER_161",
  [ RTEMS_RECORD_USER_162 ] = "USER_162",
  [ RTEMS_RECORD_USER_163 ] = "USER_163",
  [ RTEMS_RECORD_USER_164 ] = "USER_164",
  [ RTEMS_RECORD_USER_165 ] = "USER_165",
  [ RTEMS_RECORD_USER_166 ] = "USER_166",
  [ RTEMS_RECORD_USER_167 ] = "USER_167",
  [ RTEMS_RECORD_USER_168 ] = "USER_168",
  [ RTEMS_RECORD_USER_169 ] = "USER_169",
  [ RTEMS_RECORD_USER_170 ] = "USER_170",
  [ RTEMS_RECORD_USER_171 ] = "USER_171",
  [ RTEMS_RECORD_USER_172 ] = "USER_172",
  [ RTEMS_RECORD_USER_173 ] = "USER_173",
  [ RTEMS_RECORD_USER_174 ] = "USER_174",
  [ RTEMS_RECORD_USER_175 ] = "USER_175",
  [ RTEMS_RECORD_USER_176 ] = "USER_176",
  [ RTEMS_RECORD_USER_177 ] = "USER_177",
  [ RTEMS_RECORD_USER_178 ] = "USER_178",
  [ RTEMS_RECORD_USER_179 ] = "USER_179",
  [ RTEMS_RECORD_USER_180 ] = "USER_180",
  [ RTEMS_RECORD_USER_181 ] = "USER_181",
  [ RTEMS_RECORD_USER_182 ] = "USER_182",
  [ RTEMS_RECORD_USER_183 ] = "USER_183",
  [ RTEMS_RECORD_USER_184 ] = "USER_184",
  [ RTEMS_RECORD_USER_185 ] = "USER_185",
  [ RTEMS_RECORD_USER_186 ] = "USER_186",
  [ RTEMS_RECORD_USER_187 ] = "USER_187",
  [ RTEMS_RECORD_USER_188 ] = "USER_188",
  [ RTEMS_RECORD_USER_189 ] = "USER_189",
  [ RTEMS_RECORD_USER_190 ] = "USER_190",
  [ RTEMS_RECORD_USER_191 ] = "USER_191",
  [ RTEMS_RECORD_USER_192 ] = "USER_192",
  [ RTEMS_RECORD_USER_193 ] = "USER_193",
  [ RTEMS_RECORD_USER_194 ] = "USER_194",
  [ RTEMS_RECORD_USER_195 ] = "USER_195",
  [ RTEMS_RECORD_USER_196 ] = "USER_196",
  [ RTEMS_RECORD_USER_197 ] = "USER_197",
  [ RTEMS_RECORD_USER_198 ] = "USER_198",
  [ RTEMS_RECORD_USER_199 ] = "USER_199",
  [ RTEMS_RECORD_USER_200 ] = "USER_200",
  [ RTEMS_RECORD_USER_201 ] = "USER_201",
  [ RTEMS_RECORD_USER_202 ] = "USER_202",
  [ RTEMS_RECORD_USER_203 ] = "USER_203",
  [ RTEMS_RECORD_USER_204 ] = "USER_204",
  [ RTEMS_RECORD_USER_205 ] = "USER_205",
  [ RTEMS_RECORD_USER_206 ] = "USER_206",
  [ RTEMS_RECORD_USER_207 ] = "USER_207",
  [ RTEMS_RECORD_USER_208 ] = "USER_208",
  [ RTEMS_RECORD_USER_209 ] = "USER_209",
  [ RTEMS_RECORD_USER_210 ] = "USER_210",
  [ RTEMS_RECORD_USER_211 ] = "USER_211",
  [ RTEMS_RECORD_USER_212 ] = "USER_212",
  [ RTEMS_RECORD_USER_213 ] = "USER_213",
  [ RTEMS_RECORD_USER_214 ] = "USER_214",
  [ RTEMS_RECORD_USER_215 ] = "USER_215",
  [ RTEMS_RECORD_USER_216 ] = "USER_216",
  [ RTEMS_RECORD_USER_217 ] = "USER_217",
  [ RTEMS_RECORD_USER_218 ] = "USER_218",
  [ RTEMS_RECORD_USER_219 ] = "USER_219",
  [ RTEMS_RECORD_USER_220 ] = "USER_220",
  [ RTEMS_RECORD_USER_221 ] = "USER_221",
  [ RTEMS_RECORD_USER_222 ] = "USER_222",
  [ RTEMS_RECORD_USER_223 ] = "USER_223",
  [ RTEMS_RECORD_USER_224 ] = "USER_224",
  [ RTEMS_RECORD_USER_225 ] = "USER_225",
  [ RTEMS_RECORD_USER_226 ] = "USER_226",
  [ RTEMS_RECORD_USER_227 ] = "USER_227",
  [ RTEMS_RECORD_USER_228 ] = "USER_228",
  [ RTEMS_RECORD_USER_229 ] = "USER_229",
  [ RTEMS_RECORD_USER_230 ] = "USER_230",
  [ RTEMS_RECORD_USER_231 ] = "USER_231",
  [ RTEMS_RECORD_USER_232 ] = "USER_232",
  [ RTEMS_RECORD_USER_233 ] = "USER_233",
  [ RTEMS_RECORD_USER_234 ] = "USER_234",
  [ RTEMS_RECORD_USER_235 ] = "USER_235",
  [ RTEMS_RECORD_USER_236 ] = "USER_236",
  [ RTEMS_RECORD_USER_237 ] = "USER_237",
  [ RTEMS_RECORD_USER_238 ] = "USER_238",
  [ RTEMS_RECORD_USER_239 ] = "USER_239",
  [ RTEMS_RECORD_USER_240 ] = "USER_240",
  [ RTEMS_RECORD_USER_241 ] = "USER_241",
  [ RTEMS_RECORD_USER_242 ] = "USER_242",
  [ RTEMS_RECORD_USER_243 ] = "USER_243",
  [ RTEMS_RECORD_USER_244 ] = "USER_244",
  [ RTEMS_RECORD_USER_245 ] = "USER_245",
  [ RTEMS_RECORD_USER_246 ] = "USER_246",
  [ RTEMS_RECORD_USER_247 ] = "USER_247",
  [ RTEMS_RECORD_USER_248 ] = "USER_248",
  [ RTEMS_RECORD_USER_249 ] = "USER_249",
  [ RTEMS_RECORD_USER_250 ] = "USER_250",
  [ RTEMS_RECORD_USER_251 ] = "USER_251",
  [ RTEMS_RECORD_USER_252 ] = "USER_252",
  [ RTEMS_RECORD_USER_253 ] = "USER_253",
  [ RTEMS_RECORD_USER_254 ] = "USER_254",
  [ RTEMS_RECORD_USER_255 ] = "USER_255",
  [ RTEMS_RECORD_USER_256 ] = "USER_256",
  [ RTEMS_RECORD_USER_257 ] = "USER_257",
  [ RTEMS_RECORD_USER_258 ] = "USER_258",
  [ RTEMS_RECORD_USER_259 ] = "USER_259",
  [ RTEMS_RECORD_USER_260 ] = "USER_260",
  [ RTEMS_RECORD_USER_261 ] = "USER_261",
  [ RTEMS_RECORD_USER_262 ] = "USER_262",
  [ RTEMS_RECORD_USER_263 ] = "USER_263",
  [ RTEMS_RECORD_USER_264 ] = "USER_264",
  [ RTEMS_RECORD_USER_265 ] = "USER_265",
  [ RTEMS_RECORD_USER_266 ] = "USER_266",
  [ RTEMS_RECORD_USER_267 ] = "USER_267",
  [ RTEMS_RECORD_USER_268 ] = "USER_268",
  [ RTEMS_RECORD_USER_269 ] = "USER_269",
  [ RTEMS_RECORD_USER_270 ] = "USER_270",
  [ RTEMS_RECORD_USER_271 ] = "USER_271",
  [ RTEMS_RECORD_USER_272 ] = "USER_272",
  [ RTEMS_RECORD_USER_273 ] = "USER_273",
  [ RTEMS_RECORD_USER_274 ] = "USER_274",
  [ RTEMS_RECORD_USER_275 ] = "USER_275",
  [ RTEMS_RECORD_USER_276 ] = "USER_276",
  [ RTEMS_RECORD_USER_277 ] = "USER_277",
  [ RTEMS_RECORD_USER_278 ] = "USER_278",
  [ RTEMS_RECORD_USER_279 ] = "USER_279",
  [ RTEMS_RECORD_USER_280 ] = "USER_280",
  [ RTEMS_RECORD_USER_281 ] = "USER_281",
  [ RTEMS_RECORD_USER_282 ] = "USER_282",
  [ RTEMS_RECORD_USER_283 ] = "USER_283",
  [ RTEMS_RECORD_USER_284 ] = "USER_284",
  [ RTEMS_RECORD_USER_285 ] = "USER_285",
  [ RTEMS_RECORD_USER_286 ] = "USER_286",
  [ RTEMS_RECORD_USER_287 ] = "USER_287",
  [ RTEMS_RECORD_USER_288 ] = "USER_288",
  [ RTEMS_RECORD_USER_289 ] = "USER_289",
  [ RTEMS_RECORD_USER_290 ] = "USER_290",
  [ RTEMS_RECORD_USER_291 ] = "USER_291",
  [ RTEMS_RECORD_USER_292 ] = "USER_292",
  [ RTEMS_RECORD_USER_293 ] = "USER_293",
  [ RTEMS_RECORD_USER_294 ] = "USER_294",
  [ RTEMS_RECORD_USER_295 ] = "USER_295",
  [ RTEMS_RECORD_USER_296 ] = "USER_296",
  [ RTEMS_RECORD_USER_297 ] = "USER_297",
  [ RTEMS_RECORD_USER_298 ] = "USER_298",
  [ RTEMS_RECORD_USER_299 ] = "USER_299",
  [ RTEMS_RECORD_USER_300 ] = "USER_300",
  [ RTEMS_RECORD_USER_301 ] = "USER_301",
  [ RTEMS_RECORD_USER_302 ] = "USER_302",
  [ RTEMS_RECORD_USER_303 ] = "USER_303",
  [ RTEMS_RECORD_USER_304 ] = "USER_304",
  [ RTEMS_RECORD_USER_305 ] = "USER_305",
  [ RTEMS_RECORD_USER_306 ] = "USER_306",
  [ RTEMS_RECORD_USER_307 ] = "USER_307",
  [ RTEMS_RECORD_USER_308 ] = "USER_308",
  [ RTEMS_RECORD_USER_309 ] = "USER_309",
  [ RTEMS_RECORD_USER_310 ] = "USER_310",
  [ RTEMS_RECORD_USER_311 ] = "USER_311",
  [ RTEMS_RECORD_USER_312 ] = "USER_312",
  [ RTEMS_RECORD_USER_313 ] = "USER_313",
  [ RTEMS_RECORD_USER_314 ] = "USER_314",
  [ RTEMS_RECORD_USER_315 ] = "USER_315",
  [ RTEMS_RECORD_USER_316 ] = "USER_316",
  [ RTEMS_RECORD_USER_317 ] = "USER_317",
  [ RTEMS_RECORD_USER_318 ] = "USER_318",
  [ RTEMS_RECORD_USER_319 ] = "USER_319",
  [ RTEMS_RECORD_USER_320 ] = "USER_320",
  [ RTEMS_RECORD_USER_321 ] = "USER_321",
  [ RTEMS_RECORD_USER_322 ] = "USER_322",
  [ RTEMS_RECORD_USER_323 ] = "USER_323",
  [ RTEMS_RECORD_USER_324 ] = "USER_324",
  [ RTEMS_RECORD_USER_325 ] = "USER_325",
  [ RTEMS_RECORD_USER_326 ] = "USER_326",
  [ RTEMS_RECORD_USER_327 ] = "USER_327",
  [ RTEMS_RECORD_USER_328 ] = "USER_328",
  [ RTEMS_RECORD_USER_329 ] = "USER_329",
  [ RTEMS_RECORD_USER_330 ] = "USER_330",
  [ RTEMS_RECORD_USER_331 ] = "USER_331",
  [ RTEMS_RECORD_USER_332 ] = "USER_332",
  [ RTEMS_RECORD_USER_333 ] = "USER_333",
  [ RTEMS_RECORD_USER_334 ] = "USER_334",
  [ RTEMS_RECORD_USER_335 ] = "USER_335",
  [ RTEMS_RECORD_USER_336 ] = "USER_336",
  [ RTEMS_RECORD_USER_337 ] = "USER_337",
  [ RTEMS_RECORD_USER_338 ] = "USER_338",
  [ RTEMS_RECORD_USER_339 ] = "USER_339",
  [ RTEMS_RECORD_USER_340 ] = "USER_340",
  [ RTEMS_RECORD_USER_341 ] = "USER_341",
  [ RTEMS_RECORD_USER_342 ] = "USER_342",
  [ RTEMS_RECORD_USER_343 ] = "USER_343",
  [ RTEMS_RECORD_USER_344 ] = "USER_344",
  [ RTEMS_RECORD_USER_345 ] = "USER_345",
  [ RTEMS_RECORD_USER_346 ] = "USER_346",
  [ RTEMS_RECORD_USER_347 ] = "USER_347",
  [ RTEMS_RECORD_USER_348 ] = "USER_348",
  [ RTEMS_RECORD_USER_349 ] = "USER_349",
  [ RTEMS_RECORD_USER_350 ] = "USER_350",
  [ RTEMS_RECORD_USER_351 ] = "USER_351",
  [ RTEMS_RECORD_USER_352 ] = "USER_352",
  [ RTEMS_RECORD_USER_353 ] = "USER_353",
  [ RTEMS_RECORD_USER_354 ] = "USER_354",
  [ RTEMS_RECORD_USER_355 ] = "USER_355",
  [ RTEMS_RECORD_USER_356 ] = "USER_356",
  [ RTEMS_RECORD_USER_357 ] = "USER_357",
  [ RTEMS_RECORD_USER_358 ] = "USER_358",
  [ RTEMS_RECORD_USER_359 ] = "USER_359",
  [ RTEMS_RECORD_USER_360 ] = "USER_360",
  [ RTEMS_RECORD_USER_361 ] = "USER_361",
  [ RTEMS_RECORD_USER_362 ] = "USER_362",
  [ RTEMS_RECORD_USER_363 ] = "USER_363",
  [ RTEMS_RECORD_USER_364 ] = "USER_364",
  [ RTEMS_RECORD_USER_365 ] = "USER_365",
  [ RTEMS_RECORD_USER_366 ] = "USER_366",
  [ RTEMS_RECORD_USER_367 ] = "USER_367",
  [ RTEMS_RECORD_USER_368 ] = "USER_368",
  [ RTEMS_RECORD_USER_369 ] = "USER_369",
  [ RTEMS_RECORD_USER_370 ] = "USER_370",
  [ RTEMS_RECORD_USER_371 ] = "USER_371",
  [ RTEMS_RECORD_USER_372 ] = "USER_372",
  [ RTEMS_RECORD_USER_373 ] = "USER_373",
  [ RTEMS_RECORD_USER_374 ] = "USER_374",
  [ RTEMS_RECORD_USER_375 ] = "USER_375",
  [ RTEMS_RECORD_USER_376 ] = "USER_376",
  [ RTEMS_RECORD_USER_377 ] = "USER_377",
  [ RTEMS_RECORD_USER_378 ] = "USER_378",
  [ RTEMS_RECORD_USER_379 ] = "USER_379",
  [ RTEMS_RECORD_USER_380 ] = "USER_380",
  [ RTEMS_RECORD_USER_381 ] = "USER_381",
  [ RTEMS_RECORD_USER_382 ] = "USER_382",
  [ RTEMS_RECORD_USER_383 ] = "USER_383",
  [ RTEMS_RECORD_USER_384 ] = "USER_384",
  [ RTEMS_RECORD_USER_385 ] = "USER_385",
  [ RTEMS_RECORD_USER_386 ] = "USER_386",
  [ RTEMS_RECORD_USER_387 ] = "USER_387",
  [ RTEMS_RECORD_USER_388 ] = "USER_388",
  [ RTEMS_RECORD_USER_389 ] = "USER_389",
  [ RTEMS_RECORD_USER_390 ] = "USER_390",
  [ RTEMS_RECORD_USER_391 ] = "USER_391",
  [ RTEMS_RECORD_USER_392 ] = "USER_392",
  [ RTEMS_RECORD_USER_393 ] = "USER_393",
  [ RTEMS_RECORD_USER_394 ] = "USER_394",
  [ RTEMS_RECORD_USER_395 ] = "USER_395",
  [ RTEMS_RECORD_USER_396 ] = "USER_396",
  [ RTEMS_RECORD_USER_397 ] = "USER_397",
  [ RTEMS_RECORD_USER_398 ] = "USER_398",
  [ RTEMS_RECORD_USER_399 ] = "USER_399",
  [ RTEMS_RECORD_USER_400 ] = "USER_400",
  [ RTEMS_RECORD_USER_401 ] = "USER_401",
  [ RTEMS_RECORD_USER_402 ] = "USER_402",
  [ RTEMS_RECORD_USER_403 ] = "USER_403",
  [ RTEMS_RECORD_USER_404 ] = "USER_404",
  [ RTEMS_RECORD_USER_405 ] = "USER_405",
  [ RTEMS_RECORD_USER_406 ] = "USER_406",
  [ RTEMS_RECORD_USER_407 ] = "USER_407",
  [ RTEMS_RECORD_USER_408 ] = "USER_408",
  [ RTEMS_RECORD_USER_409 ] = "USER_409",
  [ RTEMS_RECORD_USER_410 ] = "USER_410",
  [ RTEMS_RECORD_USER_411 ] = "USER_411",
  [ RTEMS_RECORD_USER_412 ] = "USER_412",
  [ RTEMS_RECORD_USER_413 ] = "USER_413",
  [ RTEMS_RECORD_USER_414 ] = "USER_414",
  [ RTEMS_RECORD_USER_415 ] = "USER_415",
  [ RTEMS_RECORD_USER_416 ] = "USER_416",
  [ RTEMS_RECORD_USER_417 ] = "USER_417",
  [ RTEMS_RECORD_USER_418 ] = "USER_418",
  [ RTEMS_RECORD_USER_419 ] = "USER_419",
  [ RTEMS_RECORD_USER_420 ] = "USER_420",
  [ RTEMS_RECORD_USER_421 ] = "USER_421",
  [ RTEMS_RECORD_USER_422 ] = "USER_422",
  [ RTEMS_RECORD_USER_423 ] = "USER_423",
  [ RTEMS_RECORD_USER_424 ] = "USER_424",
  [ RTEMS_RECORD_USER_425 ] = "USER_425",
  [ RTEMS_RECORD_USER_426 ] = "USER_426",
  [ RTEMS_RECORD_USER_427 ] = "USER_427",
  [ RTEMS_RECORD_USER_428 ] = "USER_428",
  [ RTEMS_RECORD_USER_429 ] = "USER_429",
  [ RTEMS_RECORD_USER_430 ] = "USER_430",
  [ RTEMS_RECORD_USER_431 ] = "USER_431",
  [ RTEMS_RECORD_USER_432 ] = "USER_432",
  [ RTEMS_RECORD_USER_433 ] = "USER_433",
  [ RTEMS_RECORD_USER_434 ] = "USER_434",
  [ RTEMS_RECORD_USER_435 ] = "USER_435",
  [ RTEMS_RECORD_USER_436 ] = "USER_436",
  [ RTEMS_RECORD_USER_437 ] = "USER_437",
  [ RTEMS_RECORD_USER_438 ] = "USER_438",
  [ RTEMS_RECORD_USER_439 ] = "USER_439",
  [ RTEMS_RECORD_USER_440 ] = "USER_440",
  [ RTEMS_RECORD_USER_441 ] = "USER_441",
  [ RTEMS_RECORD_USER_442 ] = "USER_442",
  [ RTEMS_RECORD_USER_443 ] = "USER_443",
  [ RTEMS_RECORD_USER_444 ] = "USER_444",
  [ RTEMS_RECORD_USER_445 ] = "USER_445",
  [ RTEMS_RECORD_USER_446 ] = "USER_446",
  [ RTEMS_RECORD_USER_447 ] = "USER_447",
  [ RTEMS_RECORD_USER_448 ] = "USER_448",
  [ RTEMS_RECORD_USER_449 ] = "USER_449",
  [ RTEMS_RECORD_USER_450 ] = "USER_450",
  [ RTEMS_RECORD_USER_451 ] = "USER_451",
  [ RTEMS_RECORD_USER_452 ] = "USER_452",
  [ RTEMS_RECORD_USER_453 ] = "USER_453",
  [ RTEMS_RECORD_USER_454 ] = "USER_454",
  [ RTEMS_RECORD_USER_455 ] = "USER_455",
  [ RTEMS_RECORD_USER_456 ] = "USER_456",
  [ RTEMS_RECORD_USER_457 ] = "USER_457",
  [ RTEMS_RECORD_USER_458 ] = "USER_458",
  [ RTEMS_RECORD_USER_459 ] = "USER_459",
  [ RTEMS_RECORD_USER_460 ] = "USER_460",
  [ RTEMS_RECORD_USER_461 ] = "USER_461",
  [ RTEMS_RECORD_USER_462 ] = "USER_462",
  [ RTEMS_RECORD_USER_463 ] = "USER_463",
  [ RTEMS_RECORD_USER_464 ] = "USER_464",
  [ RTEMS_RECORD_USER_465 ] = "USER_465",
  [ RTEMS_RECORD_USER_466 ] = "USER_466",
  [ RTEMS_RECORD_USER_467 ] = "USER_467",
  [ RTEMS_RECORD_USER_468 ] = "USER_468",
  [ RTEMS_RECORD_USER_469 ] = "USER_469",
  [ RTEMS_RECORD_USER_470 ] = "USER_470",
  [ RTEMS_RECORD_USER_471 ] = "USER_471",
  [ RTEMS_RECORD_USER_472 ] = "USER_472",
  [ RTEMS_RECORD_USER_473 ] = "USER_473",
  [ RTEMS_RECORD_USER_474 ] = "USER_474",
  [ RTEMS_RECORD_USER_475 ] = "USER_475",
  [ RTEMS_RECORD_USER_476 ] = "USER_476",
  [ RTEMS_RECORD_USER_477 ] = "USER_477",
  [ RTEMS_RECORD_USER_478 ] = "USER_478",
  [ RTEMS_RECORD_USER_479 ] = "USER_479",
  [ RTEMS_RECORD_USER_480 ] = "USER_480",
  [ RTEMS_RECORD_USER_481 ] = "USER_481",
  [ RTEMS_RECORD_USER_482 ] = "USER_482",
  [ RTEMS_RECORD_USER_483 ] = "USER_483",
  [ RTEMS_RECORD_USER_484 ] = "USER_484",
  [ RTEMS_RECORD_USER_485 ] = "USER_485",
  [ RTEMS_RECORD_USER_486 ] = "USER_486",
  [ RTEMS_RECORD_USER_487 ] = "USER_487",
  [ RTEMS_RECORD_USER_488 ] = "USER_488",
  [ RTEMS_RECORD_USER_489 ] = "USER_489",
  [ RTEMS_RECORD_USER_490 ] = "USER_490",
  [ RTEMS_RECORD_USER_491 ] = "USER_491",
  [ RTEMS_RECORD_USER_492 ] = "USER_492",
  [ RTEMS_RECORD_USER_493 ] = "USER_493",
  [ RTEMS_RECORD_USER_494 ] = "USER_494",
  [ RTEMS_RECORD_USER_495 ] = "USER_495",
  [ RTEMS_RECORD_USER_496 ] = "USER_496",
  [ RTEMS_RECORD_USER_497 ] = "USER_497",
  [ RTEMS_RECORD_USER_498 ] = "USER_498",
  [ RTEMS_RECORD_USER_499 ] = "USER_499",
  [ RTEMS_RECORD_USER_500 ] = "USER_500",
  [ RTEMS_RECORD_USER_501 ] = "USER_501",
  [ RTEMS_RECORD_USER_502 ] = "USER_502",
  [ RTEMS_RECORD_USER_503 ] = "USER_503",
  [ RTEMS_RECORD_USER_504 ] = "USER_504",
  [ RTEMS_RECORD_USER_505 ] = "USER_505",
  [ RTEMS_RECORD_USER_506 ] = "USER_506",
  [ RTEMS_RECORD_USER_507 ] = "USER_507",
  [ RTEMS_RECORD_USER_508 ] = "USER_508",
  [ RTEMS_RECORD_USER_509 ] = "USER_509",
  [ RTEMS_RECORD_USER_510 ] = "USER_510",
  [ RTEMS_RECORD_USER_511 ] = "USER_511"
};

const char *rtems_record_event_text( rtems_record_event event )
{
  return event_text[ event ];
}
