/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NIS_H_RPCGEN
#define _NIS_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef __nis_object_h
#define __nis_object_h

#define NIS_MAXSTRINGLEN 255
#define NIS_MAXNAMELEN 1024
#define NIS_MAXATTRNAME 32
#define NIS_MAXATTRVAL 2048
#define NIS_MAXCOLUMNS 64
#define NIS_MAXATTR 16
#define NIS_MAXPATH 1024
#define NIS_MAXREPLICAS 128
#define NIS_MAXLINKS 16
#define NIS_PK_NONE 0
#define NIS_PK_DH 1
#define NIS_PK_RSA 2
#define NIS_PK_KERB 3

struct nis_attr {
	char *zattr_ndx;
	struct {
		u_int zattr_val_len;
		char *zattr_val_val;
	} zattr_val;
};
typedef struct nis_attr nis_attr;

typedef char *nis_name;

enum zotypes {
	BOGUS_OBJ = 0,
	NO_OBJ = 1,
	DIRECTORY_OBJ = 2,
	GROUP_OBJ = 3,
	TABLE_OBJ = 4,
	ENTRY_OBJ = 5,
	LINK_OBJ = 6,
	PRIVATE_OBJ = 7,
};
typedef enum zotypes zotypes;

enum nstype {
	UNKNOWN = 0,
	NIS = 1,
	SUNYP = 2,
	IVY = 3,
	DNS = 4,
	X500 = 5,
	DNANS = 6,
	XCHS = 7,
	CDS = 8,
};
typedef enum nstype nstype;

struct oar_mask {
	u_long oa_rights;
	zotypes oa_otype;
};
typedef struct oar_mask oar_mask;

struct endpoint {
	char *uaddr;
	char *family;
	char *proto;
};
typedef struct endpoint endpoint;

struct nis_server {
	nis_name name;
	struct {
		u_int ep_len;
		endpoint *ep_val;
	} ep;
	u_long key_type;
	netobj pkey;
};
typedef struct nis_server nis_server;

struct directory_obj {
	nis_name do_name;
	nstype do_type;
	struct {
		u_int do_servers_len;
		nis_server *do_servers_val;
	} do_servers;
	u_long do_ttl;
	struct {
		u_int do_armask_len;
		oar_mask *do_armask_val;
	} do_armask;
};
typedef struct directory_obj directory_obj;
#define EN_BINARY 1
#define EN_CRYPT 2
#define EN_XDR 4
#define EN_MODIFIED 8
#define EN_ASN1 64

struct entry_col {
	u_long ec_flags;
	struct {
		u_int ec_value_len;
		char *ec_value_val;
	} ec_value;
};
typedef struct entry_col entry_col;

struct entry_obj {
	char *en_type;
	struct {
		u_int en_cols_len;
		entry_col *en_cols_val;
	} en_cols;
};
typedef struct entry_obj entry_obj;

struct group_obj {
	u_long gr_flags;
	struct {
		u_int gr_members_len;
		nis_name *gr_members_val;
	} gr_members;
};
typedef struct group_obj group_obj;

struct link_obj {
	zotypes li_rtype;
	struct {
		u_int li_attrs_len;
		nis_attr *li_attrs_val;
	} li_attrs;
	nis_name li_name;
};
typedef struct link_obj link_obj;
#define TA_BINARY 1
#define TA_CRYPT 2
#define TA_XDR 4
#define TA_SEARCHABLE 8
#define TA_CASE 16
#define TA_MODIFIED 32
#define TA_ASN1 64

struct table_col {
	char *tc_name;
	u_long tc_flags;
	u_long tc_rights;
};
typedef struct table_col table_col;

struct table_obj {
	char *ta_type;
	int ta_maxcol;
	u_char ta_sep;
	struct {
		u_int ta_cols_len;
		table_col *ta_cols_val;
	} ta_cols;
	char *ta_path;
};
typedef struct table_obj table_obj;

struct objdata {
	zotypes zo_type;
	union {
		struct directory_obj di_data;
		struct group_obj gr_data;
		struct table_obj ta_data;
		struct entry_obj en_data;
		struct link_obj li_data;
		struct {
			u_int po_data_len;
			char *po_data_val;
		} po_data;
	} objdata_u;
};
typedef struct objdata objdata;

struct nis_oid {
	u_long ctime;
	u_long mtime;
};
typedef struct nis_oid nis_oid;

struct nis_object {
	nis_oid zo_oid;
	nis_name zo_name;
	nis_name zo_owner;
	nis_name zo_group;
	nis_name zo_domain;
	u_long zo_access;
	u_long zo_ttl;
	objdata zo_data;
};
typedef struct nis_object nis_object;

#endif /* if __nis_object_h */


/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_nis_attr (XDR *, nis_attr*);
extern  bool_t xdr_nis_name (XDR *, nis_name*);
extern  bool_t xdr_zotypes (XDR *, zotypes*);
extern  bool_t xdr_nstype (XDR *, nstype*);
extern  bool_t xdr_oar_mask (XDR *, oar_mask*);
extern  bool_t xdr_endpoint (XDR *, endpoint*);
extern  bool_t xdr_nis_server (XDR *, nis_server*);
extern  bool_t xdr_directory_obj (XDR *, directory_obj*);
extern  bool_t xdr_entry_col (XDR *, entry_col*);
extern  bool_t xdr_entry_obj (XDR *, entry_obj*);
extern  bool_t xdr_group_obj (XDR *, group_obj*);
extern  bool_t xdr_link_obj (XDR *, link_obj*);
extern  bool_t xdr_table_col (XDR *, table_col*);
extern  bool_t xdr_table_obj (XDR *, table_obj*);
extern  bool_t xdr_objdata (XDR *, objdata*);
extern  bool_t xdr_nis_oid (XDR *, nis_oid*);
extern  bool_t xdr_nis_object (XDR *, nis_object*);

#else /* K&R C */
extern bool_t xdr_nis_attr ();
extern bool_t xdr_nis_name ();
extern bool_t xdr_zotypes ();
extern bool_t xdr_nstype ();
extern bool_t xdr_oar_mask ();
extern bool_t xdr_endpoint ();
extern bool_t xdr_nis_server ();
extern bool_t xdr_directory_obj ();
extern bool_t xdr_entry_col ();
extern bool_t xdr_entry_obj ();
extern bool_t xdr_group_obj ();
extern bool_t xdr_link_obj ();
extern bool_t xdr_table_col ();
extern bool_t xdr_table_obj ();
extern bool_t xdr_objdata ();
extern bool_t xdr_nis_oid ();
extern bool_t xdr_nis_object ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NIS_H_RPCGEN */
