DRIVER MANAGER
==============

See documentation in Cobham Gaisler Driver manual available at
http://www.gaisler.com/anonftp/rcc/doc/.


INITIALIZATION
==============
The Driver Manager can be initialized in two different ways:
 1. during RTEMS startup
 2. started by user, typically in the Init task

The driver manager is initalized during RTEMS startup in the
rtems_initialize_device_drivers() function when RTEMS is
configured with driver manager support.

When RTEMS is not configured with the driver manager, the manager
may still be initialized by the user after system startup, typically
from the Init() task.

The main difference between the two ways is when interrupt
is enabled. Interrupt is enabled for the first time by RTEMS when
the Init task is started. This means, for the first case, that
drivers can not use interrupt services until after the
initialization phase is over and the user request services from
the drivers. For the second case of initialization, this means
that driver must take extra care during initialization when interrupt
is enabled so that spurious interrupts are not generated and that the
system does not hang in an infinite IRQ loop.

Most of the problems above are solved for the two methods by 
specifying in which initialization levels IRQ handling is done.
See Level 1 and Level 2 below.

Other differences are that IRQ, System Clock Timer, debug Console
and Console can be initialized with the help of the driver manager
when initialized during start up. Between Level0 and Level1 the
RTEMS I/O Manager drivers are initialized. The LEON3 BSP therefore
has two different versions of the basic drivers.


LEVEL0
------
The level of uninitialized devices that have been united with a
driver.


LEVEL1 - FIND/RESET/IRQ Clear
-----------------------------
The driver is, for the first time, informed of the presence of a
device. Only basic initialization.

- Find all hardware needed for IRQ, Console, Timer and hardware
  that need to be reset.
- Reset hardware, so that interrupts are not generated by mistake
  when enabled later on.
- Init low level non-interrupt (polling-mode) services needed by
  drivers init LEVEL2 and onwards, such as
   * Debug UART console for printk()
   * Timer API (non-IRQ)
   * GPIO (non-IRQ)
   * Special non-main memory configuration, washing
- Register IRQ controller at BSP IRQ library
- Register Timer for system clock
- Register Console UART

During this initialization level interrupts may not be registered, 
enabled or disabled at the IRQ controller, but all IRQ sources
should be cleared to avoid spurious interrupts later on.


AFTER LEVEL1 - if initialized during startup
--------------------------------------------
The statically configured drivers are initialized as normal by RTEMS. The
hardware was found in LEVEL1.

CONFIGURE_BSP_PREREQUISITE_DRIVERS may initialize IRQ driver, or 
IRQ lib initialized when IRQ controller was registered during LEVEL1.


LEVEL2
------
Initialize other device drivers than IRQ, Timer, console:
- ISR can be registered, enabled, disabled at IRQ controller
   (IRQ is still masked by CPU interrupt level if initialized during
   RTEMS startup)
- Timer API that does not require IRQ can be used
- printf() can be used

For standard peripherals this is the first initialization.


LEVEL3
------
Initialize drivers that require features/APIs provided by drivers
in LEVEL2.

Such features may involve services that require IRQ to be implemented.


LEVEL4
------
Unused extra level.



LEVEL INACTIVE - NOT ENABLED DEVICES
------------------------------------
List of devices that experienced:
 - no driver found for device (not united)
 - ignored (not united with a driver, forced by user)
 - an error was reported by device driver during initialization
