/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSImplApplConfig
 *
 * @brief This header file evaluates configuration options related to the block
 *   device cache configuration.
 *
 * It defines
 *
 * - _CONFIGURE_LIBBLOCK_TASKS and
 *
 * - _CONFIGURE_LIBBLOCK_TASKS_STACK_EXTRA
 *
 * for use by other configuration header files.
 */

/*
 * Copyright (C) 2020 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _RTEMS_CONFDEFS_BDBUF_H
#define _RTEMS_CONFDEFS_BDBUF_H

#ifndef __CONFIGURATION_TEMPLATE_h
#error "Do not include this file directly, use <rtems/confdefs.h> instead"
#endif

#ifdef CONFIGURE_INIT

#ifdef CONFIGURE_APPLICATION_NEEDS_LIBBLOCK

#include <rtems/confdefs/percpu.h>
#include <rtems/bdbuf.h>

#ifndef CONFIGURE_BDBUF_MAX_READ_AHEAD_BLOCKS
  #define CONFIGURE_BDBUF_MAX_READ_AHEAD_BLOCKS \
    RTEMS_BDBUF_MAX_READ_AHEAD_BLOCKS_DEFAULT
#endif

#ifndef CONFIGURE_BDBUF_MAX_WRITE_BLOCKS
  #define CONFIGURE_BDBUF_MAX_WRITE_BLOCKS \
    RTEMS_BDBUF_MAX_WRITE_BLOCKS_DEFAULT
#endif

#ifndef CONFIGURE_SWAPOUT_TASK_PRIORITY
  #define CONFIGURE_SWAPOUT_TASK_PRIORITY \
    RTEMS_BDBUF_SWAPOUT_TASK_PRIORITY_DEFAULT
#endif

#ifndef CONFIGURE_SWAPOUT_SWAP_PERIOD
  #define CONFIGURE_SWAPOUT_SWAP_PERIOD \
    RTEMS_BDBUF_SWAPOUT_TASK_SWAP_PERIOD_DEFAULT
#endif

#ifndef CONFIGURE_SWAPOUT_BLOCK_HOLD
  #define CONFIGURE_SWAPOUT_BLOCK_HOLD \
    RTEMS_BDBUF_SWAPOUT_TASK_BLOCK_HOLD_DEFAULT
#endif

#ifndef CONFIGURE_SWAPOUT_WORKER_TASKS
  #define CONFIGURE_SWAPOUT_WORKER_TASKS \
    RTEMS_BDBUF_SWAPOUT_WORKER_TASKS_DEFAULT
#endif

#ifndef CONFIGURE_SWAPOUT_WORKER_TASK_PRIORITY
  #define CONFIGURE_SWAPOUT_WORKER_TASK_PRIORITY \
    RTEMS_BDBUF_SWAPOUT_WORKER_TASK_PRIORITY_DEFAULT
#endif

#ifndef CONFIGURE_BDBUF_TASK_STACK_SIZE
  #define CONFIGURE_BDBUF_TASK_STACK_SIZE \
    RTEMS_BDBUF_TASK_STACK_SIZE_DEFAULT
#endif

#ifndef CONFIGURE_BDBUF_CACHE_MEMORY_SIZE
  #define CONFIGURE_BDBUF_CACHE_MEMORY_SIZE \
    RTEMS_BDBUF_CACHE_MEMORY_SIZE_DEFAULT
#endif

#ifndef CONFIGURE_BDBUF_BUFFER_MIN_SIZE
  #define CONFIGURE_BDBUF_BUFFER_MIN_SIZE \
    RTEMS_BDBUF_BUFFER_MIN_SIZE_DEFAULT
#endif

#ifndef CONFIGURE_BDBUF_BUFFER_MAX_SIZE
  #define CONFIGURE_BDBUF_BUFFER_MAX_SIZE \
    RTEMS_BDBUF_BUFFER_MAX_SIZE_DEFAULT
#endif

#ifndef CONFIGURE_BDBUF_READ_AHEAD_TASK_PRIORITY
  #define CONFIGURE_BDBUF_READ_AHEAD_TASK_PRIORITY \
    RTEMS_BDBUF_READ_AHEAD_TASK_PRIORITY_DEFAULT
#endif

#define _CONFIGURE_LIBBLOCK_TASKS \
  ( 1 + CONFIGURE_SWAPOUT_WORKER_TASKS \
    + ( CONFIGURE_BDBUF_MAX_READ_AHEAD_BLOCKS != 0 ) )

#define _CONFIGURE_LIBBLOCK_TASKS_STACK_EXTRA \
  ( _CONFIGURE_LIBBLOCK_TASKS \
    * ( CONFIGURE_BDBUF_TASK_STACK_SIZE <= CONFIGURE_MINIMUM_TASK_STACK_SIZE ? \
       0 : \
       CONFIGURE_BDBUF_TASK_STACK_SIZE - CONFIGURE_MINIMUM_TASK_STACK_SIZE ) )

#ifdef __cplusplus
extern "C" {
#endif

const rtems_bdbuf_config rtems_bdbuf_configuration = {
  CONFIGURE_BDBUF_MAX_READ_AHEAD_BLOCKS,
  CONFIGURE_BDBUF_MAX_WRITE_BLOCKS,
  CONFIGURE_SWAPOUT_TASK_PRIORITY,
  CONFIGURE_SWAPOUT_SWAP_PERIOD,
  CONFIGURE_SWAPOUT_BLOCK_HOLD,
  CONFIGURE_SWAPOUT_WORKER_TASKS,
  CONFIGURE_SWAPOUT_WORKER_TASK_PRIORITY,
  CONFIGURE_BDBUF_TASK_STACK_SIZE,
  CONFIGURE_BDBUF_CACHE_MEMORY_SIZE,
  CONFIGURE_BDBUF_BUFFER_MIN_SIZE,
  CONFIGURE_BDBUF_BUFFER_MAX_SIZE,
  CONFIGURE_BDBUF_READ_AHEAD_TASK_PRIORITY
};

#ifdef __cplusplus
}
#endif

#else /* !CONFIGURE_APPLICATION_NEEDS_LIBBLOCK */

#define _CONFIGURE_LIBBLOCK_TASKS 0

#define _CONFIGURE_LIBBLOCK_TASKS_STACK_EXTRA 0

#endif /* CONFIGURE_APPLICATION_NEEDS_LIBBLOCK */

#endif /* CONFIGURE_INIT */

#endif /* _RTEMS_CONFDEFS_BDBUF_H */
