/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSImplDoxygen
 *
 * @brief This header file contains Doxygen items related to hash algorithms.
 */

/*
 * Copyright (C) 2023 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @defgroup RTEMSAPIHashAlgorithms Hash Algorithms
 *
 * @ingroup RTEMSAPI
 *
 * @brief This group contains interfaces to hash algorithms.
 */

/**
 * @file cpukit/include/md4.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the HD4 hash algorithm
 *   support.
 */

/**
 * @file cpukit/include/md5.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the HD5 hash algorithm
 *   support.
 */

/**
 * @file cpukit/include/sha224.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the SHA224 hash algorithm
 *   support.
 */

/**
 * @file cpukit/include/sha256.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the SHA256 hash algorithm
 *   support.
 */

/**
 * @file cpukit/include/sha384.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the SHA384 hash algorithm
 *   support.
 */

/**
 * @file cpukit/include/sha512.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the SHA512 hash algorithm
 *   support.
 */

/**
 * @file cpukit/include/sha512t.h
 *
 * @ingroup RTEMSAPIHashAlgorithms
 *
 * @brief This header file contains interfaces of the trucated SHA512 hash
 *   algorithm support.
 */


/**
 * @defgroup RTEMSImplHashAlgorithms Hash Algorithms
 *
 * @ingroup RTEMSImpl
 *
 * @brief This group contains items related to the implementation of hash
 *   algorithms.
 */

/**
 * @file cpukit/libmd/md4.c
 *
 * @ingroup RTEMSImplHashAlgorithms
 *
 * @brief This source file contains the implemention of the MD4 hash algorithm.
 */

/**
 * @file cpukit/libmd/md5.c
 *
 * @ingroup RTEMSImplHashAlgorithms
 *
 * @brief This source file contains the implemention of the MD5 hash algorithm.
 */

/**
 * @file cpukit/libmd/sha256c.c
 *
 * @ingroup RTEMSImplHashAlgorithms
 *
 * @brief This source file contains the implemention of the SHA256 hash
 *   algorithm and variants.
 */

/**
 * @file cpukit/libmd/sha512c.c
 *
 * @ingroup RTEMSImplHashAlgorithms
 *
 * @brief This source file contains the implemention of the SHA512 hash
 *   algorithm and variants.
 */
