ColdFire 5282
=============

Arcturus Networks uC DIMM ColdFire 5282 

```
 CPU: MCF5282, 64MHz
 RAM: 16M
SRAM: 64k (BSP places FEC buffer descriptors here)
 ROM: 4M
```

This is a credit-card sized board in a DIMM format. It is part of a family
which includes Dragonball and Coldfire CPUs, with a standardized DIMM-based bus. 

ACKNOWLEDGEMENTS
----------------
This BSP is based on the work of:
    D. Peter Siddons
    Till Straumann
    Brett Swimley
    Jay Monkman


TODO
----
The bsp relies on the Arcturus monitor to set up DRAM and all chip selects. 
This seems OK to me, but others may find it lame.....

I/O pin restrictions make simultaneous operation of I2C, CAN and UART2
impossible.  The BSP configures UART2 to use the CAN pins and leaves
the I2C pins available for use.

``` 
BSP NAME:           uC5282
BOARD:              Arcturus Netrworks uCdimm 5282
BUS:                Arcturus DIMM bus, A24/D16, plus peripherals.
CPU FAMILY:         ColdFire 5282
CPU:                MCF5282
COPROCESSORS:       N/A

DEBUG MONITOR:      Arcturus bootloader
```

PERIPHERALS
-----------
```
TIMERS:             Four PIT (RTEMS clock is PIT3), Four Timers
  RESOLUTION:       1 microsecond 
SERIAL PORTS:       Internal UART 0, 1 and 2
REAL-TIME CLOCK:    none
DMA:                none
VIDEO:              none
SCSI:               none
NETWORKING:         Internal 10/100Mbs FEC, 100 Mb/s, full/half-duplex
```

DRIVER INFORMATION
------------------
```
CLOCK DRIVER:       PIT3
IOSUPP DRIVER:      none
SHMSUPP:            none
TIMER DRIVER:       TIMER3
TTY DRIVER:         UART0, 1 and 2
```

STDIO
-----
```
PORT:               UART0 Terminal
ELECTRICAL:         RS-232
BAUD:               9600
BITS PER CHARACTER: 8
PARITY:             None
STOP BITS:          1
```

Downloading the image to the board.
-----------------------------------
The bootable image is generated by the make-exe target in the bsp makefile. It
generates a simple stripped binary file which is downloaded over the ethernet
port into RAM then executed or programmed into flash memory.

1) Power up the uC5282 board. A dump of some memory maps is produced
   followed by a prompt.

2) (first time only)
   Set the uC5282 board Internet configuration:
        setenv IPADDR0 www.xxx.yyy.zzz  (Your board's address)
        setenv NETMASK ppp.qqq.rrr.sss  (Your local network address mask)
        setenv HOSTNAME somename        (Your board's name)

3) Type 'tftp<CR>'
   This forces the network link to half-duplex.  If your network link is
   locked at full duplex you'll have to find another port!
   The RTEMS network driver can be forced to 100 Mbs/full-duplex by setting
   the bootstrap environment variable IPADDR0_100FULL to Y.  The driver can
   be forced to 10 Mbs/half-duplex by setting the bootstrap environment
   variable IPADDR0_10HALF to Y.

4) Run 'tftp' on your host machine:
        tftp> binary
        tftp> connect www.xxx.yyy.zzz   (Your ucDIMM's address)
        tftp> put someFile.exe          (someFile.boot for the EPICS build system)

5) When the file has downloaded press the <ESC> key to terminate
   the uCDIMM tftp command.

6) Type 'goram<CR>' to start the downloaded program, or type 'program<CR>'
to burn the code onto the uCDIMM flash.


Clock Speed Determination Algorithm
-----------------------------------
Till Straumann submitted a patch to provide more dynamic clock speed
selection. 

Currently, the uC5282 BSP requires relinking the application with a
special linker flag in order to make it work with 80MHz boards (breaking
run-time compatibility with 64MHz variants).

The change aims adds support for run-time guessing/setting of
the system-clock frequency:

1) If uCbootloader environment variable SYS_CLOCK_SPEED is set to a
non-zero number then the BSP assumes this number to specify the clock
frequency in Hz.

2) If 1) yields no non-zero frequency then the linker-provided symbol
_CPUClockSpeed is assumed to specify the clock frequency (in Hz). This
is the traditional behavior but the default value of _CPUClockSpeed
was changed from 64000000 to 0 (in order to let step 3) do it's work
by default).

3) If neither 1) nor 2) yield a non-zero frequency then assume a PLL
reference frequency (in Hz) as defined by the linker-provided symbol
'_PLLRefClockSpeed' (which defaults to 8000000) and compute the system
clock frequency from the divisor/multiplier settings in the SYNCR
register.

We have both, 64MHz and 80MHz variants and both use a PLL reference of
8MHz so that run-time heuristics + detection 3) work fine.


EPICS Bootstrap Information
---------------------------
The EPICS startup code uses the following environment variables.  If an
optional environment variable is missing the value in parentheses will be used.
All Internet addresses must be given in 'dotted-decimal' format.
HWADDR0    - Ethernet hardware address.
IPADDR0    - Internet address (192.168.0.2).
NETMASK    - Local network address mask (255.255.252.0).
HOSTNAME   - Internet host name (iocNobody).
GATEWAY    - Internet address of gateway machine (NULL).
SERVER     - Internet address of NFS server (192.168.0.1).
NAMESERVER - Internet address of DNS server (SERVER).
DOMAIN     - DNS domain name (precompiled value from CONFIG_SITE).
NTPSERVER  - Internet address of NTP server (SERVER).
BOOTFILE   - Path to executable (epics/iocNobody/bin/RTEMS-uC5282/myApp.boot).
CMDLINE    - Path to startup script (epics/iocBoot/iocNobody/st.cmd).
NFSMOUNT   - NFS information: www.xxx.yyy.zzz:/remote/path /localpath
             A : can also be used to separate the remote and local paths.
             If NFSMOUNT is not set, SERVER will be used as the NFS server,
             and the remote and local paths will be taken from the first
             component of CMDLINE.  If CMDLINE does not begin with a /
             then '/tftpboot' is prepended to the remote path.  This allows
             a remote TFTP and NFS server to be handled transaparently.



Memory map
----------
```
      Memory map as set up by dBUG bootstrap and BSP initialization

          +--------------------------------------------------+
0000 0000 |       16 MByte SDRAM                             | 00FF FFFF
0100 0000 |  ---------------------------------------------   |
          |    Address space for future SDRAM expansion      |
          .                                                  .
          .                                                  .
          .                                                  .
          |                                                  | 0FFF FFFF
          +--------------------------------------------------+
1000 0000 | External 4 MByte flash memory                    |
          .                                                  .
          .                                                  .
          .                                                  .
          |                                                  | 1FFF FFFF
          +--------------------------------------------------+
2000 0000 | 64 kByte on-chip SRAM (RAMBAR)                   |
          .                                                  .
          .                                                  .
          .                                                  .
          |                                                  | 2FFF FFFF
          +--------------------------------------------------+
3000 0000 |  CS1* (devLib 'VME' A24 space)                   | 30FF FFFF
3100 0000 |  CS2* (devLib 'VME' A32 and A16 space)          x| 31FF FFFF
          .                                                  .
          .                                                  .
          .                                                  .
          |                                                  | 3FFF FFFF
          +--------------------------------------------------+
4000 0000 | Internal peripheral system (IPSBAR)              |
          .                                                  .
4400 0000 | Backdoor access to on-chip flash                 |
          .                                                  .
          .                                                  .
          .                                                  .
          |                                                  | 4FFF FFFF
          +--------------------------------------------------+
          .                                                  .
          .                                                  .
          .                                                  .
          +--------------------------------------------------+
f000 0000 | 512 kByte on-chip flash (FLASHBAR)               |
          .                                                  .
          .                                                  .
          .                                                  .
          |                                                  | fFFF FFFF
          +--------------------------------------------------+

x - Final 16-bit location of CS2* space is reserved for FPGA interrupt status.
```



Interrupt map
-------------
```
External interrupt lines (priority is fixed between 3 and 4):
    IRQ7* - Ethernet Transceiver interrupts
    IRQ1* - FPGA ('VME') interrupts.
+-----+-----------------------------------------------------------------------+
|     |                                PRIORITY                               |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|LEVEL|    7   |    6   |    5   |    4   |    3   |    2   |    1   |    0   |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  7  |        |        |        |        |        |        |        |        |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  6  |        |        |        |        |        |        |        |        |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  5  |        |        |        |        |        |        |        |        |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  4  | FEC RX | FEC TX |        |        |        |        |        |   PIT  |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  3  | UART 0 | UART 1 | UART 2 |        |        |        |        |        |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  2  |        |        |        |        |        |        |        |        |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
|  1  |        |        |        |        |        |        |        |        |
+-----+--------+--------+--------+--------+--------+--------+--------+--------+
```

