/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSBSPsARMTMS570
 *
 * @brief This header file provides pin mappings for the TMS570LC4357.
 */

/*
 * Copyright (C) 2015-2017 Pavel Pisa <pisa@cmp.felk.cvut.cz>
 *
 * Czech Technical University in Prague
 * Zikova 1903/4
 * 166 36 Praha 6
 * Czech Republic
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIBBSP_ARM_TMS570_TMS570LC4357_PINS_H
#define LIBBSP_ARM_TMS570_TMS570LC4357_PINS_H

#define TMS570_PIN_MMR_ALT_AD2EVT TMS570_BALL_WITH_MMR(80, 0)
#define TMS570_PIN_MMR_ALT_ECAP1 TMS570_BALL_WITH_MMR(80, 1)
#define TMS570_PIN_MMR_ALT_ECAP2 TMS570_BALL_WITH_MMR(80, 2)
#define TMS570_PIN_MMR_ALT_ECAP3 TMS570_BALL_WITH_MMR(80, 3)
#define TMS570_PIN_MMR_ALT_ECAP4 TMS570_BALL_WITH_MMR(81, 0)
#define TMS570_PIN_MMR_ALT_ECAP5 TMS570_BALL_WITH_MMR(81, 1)
#define TMS570_PIN_MMR_ALT_ECAP6 TMS570_BALL_WITH_MMR(81, 2)
#define TMS570_PIN_MMR_ALT_GIOA_0 TMS570_BALL_WITH_MMR(83, 3)
#define TMS570_PIN_MMR_ALT_GIOA_1 TMS570_BALL_WITH_MMR(84, 0)
#define TMS570_PIN_MMR_ALT_GIOA_2 TMS570_BALL_WITH_MMR(84, 1)
#define TMS570_PIN_MMR_ALT_GIOA_3 TMS570_BALL_WITH_MMR(84, 2)
#define TMS570_PIN_MMR_ALT_GIOA_4 TMS570_BALL_WITH_MMR(84, 3)
#define TMS570_PIN_MMR_ALT_GIOA_5 TMS570_BALL_WITH_MMR(85, 0)
#define TMS570_PIN_MMR_ALT_GIOA_6 TMS570_BALL_WITH_MMR(85, 1)
#define TMS570_PIN_MMR_ALT_GIOA_7 TMS570_BALL_WITH_MMR(85, 2)
#define TMS570_PIN_MMR_ALT_GIOB_0 TMS570_BALL_WITH_MMR(85, 3)
#define TMS570_PIN_MMR_ALT_GIOB_1 TMS570_BALL_WITH_MMR(86, 0)
#define TMS570_PIN_MMR_ALT_GIOB_2 TMS570_BALL_WITH_MMR(86, 1)
#define TMS570_PIN_MMR_ALT_GIOB_3 TMS570_BALL_WITH_MMR(86, 2)
#define TMS570_PIN_MMR_ALT_GIOB_4 TMS570_BALL_WITH_MMR(86, 3)
#define TMS570_PIN_MMR_ALT_GIOB_5 TMS570_BALL_WITH_MMR(87, 0)
#define TMS570_PIN_MMR_ALT_GIOB_6 TMS570_BALL_WITH_MMR(87, 1)
#define TMS570_PIN_MMR_ALT_GIOB_7 TMS570_BALL_WITH_MMR(87, 2)
#define TMS570_PIN_MMR_ALT_HET1_17 TMS570_BALL_WITH_MMR(92, 0)
#define TMS570_PIN_MMR_ALT_HET1_19 TMS570_BALL_WITH_MMR(92, 1)
#define TMS570_PIN_MMR_ALT_HET1_21 TMS570_BALL_WITH_MMR(92, 2)
#define TMS570_PIN_MMR_ALT_HET1_23 TMS570_BALL_WITH_MMR(92, 3)
#define TMS570_PIN_MMR_ALT_HET1_25 TMS570_BALL_WITH_MMR(93, 0)
#define TMS570_PIN_MMR_ALT_HET1_27 TMS570_BALL_WITH_MMR(93, 1)
#define TMS570_PIN_MMR_ALT_HET1_29 TMS570_BALL_WITH_MMR(93, 2)
#define TMS570_PIN_MMR_ALT_HET1_31 TMS570_BALL_WITH_MMR(93, 3)
#define TMS570_PIN_MMR_ALT_HET2_00 TMS570_BALL_WITH_MMR(94, 0)
#define TMS570_PIN_MMR_ALT_HET2_01 TMS570_BALL_WITH_MMR(94, 1)
#define TMS570_PIN_MMR_ALT_HET2_02 TMS570_BALL_WITH_MMR(94, 2)
#define TMS570_PIN_MMR_ALT_HET2_03 TMS570_BALL_WITH_MMR(94, 3)
#define TMS570_PIN_MMR_ALT_HET2_04 TMS570_BALL_WITH_MMR(95, 0)
#define TMS570_PIN_MMR_ALT_HET2_05 TMS570_BALL_WITH_MMR(95, 1)
#define TMS570_PIN_MMR_ALT_HET2_06 TMS570_BALL_WITH_MMR(95, 2)
#define TMS570_PIN_MMR_ALT_HET2_07 TMS570_BALL_WITH_MMR(95, 3)
#define TMS570_PIN_MMR_ALT_HET2_08 TMS570_BALL_WITH_MMR(96, 0)
#define TMS570_PIN_MMR_ALT_HET2_09 TMS570_BALL_WITH_MMR(96, 1)
#define TMS570_PIN_MMR_ALT_HET2_10 TMS570_BALL_WITH_MMR(96, 2)
#define TMS570_PIN_MMR_ALT_HET2_11 TMS570_BALL_WITH_MMR(96, 3)
#define TMS570_PIN_MMR_ALT_HET2_12 TMS570_BALL_WITH_MMR(97, 0)
#define TMS570_PIN_MMR_ALT_HET2_13 TMS570_BALL_WITH_MMR(97, 1)
#define TMS570_PIN_MMR_ALT_HET2_14 TMS570_BALL_WITH_MMR(97, 2)
#define TMS570_PIN_MMR_ALT_HET2_15 TMS570_BALL_WITH_MMR(97, 3)
#define TMS570_PIN_MMR_ALT_HET2_16 TMS570_BALL_WITH_MMR(98, 0)
#define TMS570_PIN_MMR_ALT_HET2_18 TMS570_BALL_WITH_MMR(98, 1)
#define TMS570_PIN_MMR_ALT_HET2_20 TMS570_BALL_WITH_MMR(98, 2)
#define TMS570_PIN_MMR_ALT_HET2_22 TMS570_BALL_WITH_MMR(98, 3)
#define TMS570_PIN_MMR_ALT_MDIO TMS570_BALL_WITH_MMR(87, 3)
#define TMS570_PIN_MMR_ALT_MIBSPI1NCS_4 TMS570_BALL_WITH_MMR(88, 0)
#define TMS570_PIN_MMR_ALT_MIBSPI1NCS_5 TMS570_BALL_WITH_MMR(88, 1)
#define TMS570_PIN_MMR_ALT_MIBSPI2NCS_1 TMS570_BALL_WITH_MMR(88, 2)
#define TMS570_PIN_MMR_ALT_MII_COL TMS570_BALL_WITH_MMR(89, 2)
#define TMS570_PIN_MMR_ALT_MII_CRS TMS570_BALL_WITH_MMR(89, 3)
#define TMS570_PIN_MMR_ALT_MII_RXCLK TMS570_BALL_WITH_MMR(90, 2)
#define TMS570_PIN_MMR_ALT_MII_RXD_0 TMS570_BALL_WITH_MMR(90, 3)
#define TMS570_PIN_MMR_ALT_MII_RXD_1 TMS570_BALL_WITH_MMR(91, 0)
#define TMS570_PIN_MMR_ALT_MII_RXD_2 TMS570_BALL_WITH_MMR(91, 1)
#define TMS570_PIN_MMR_ALT_MII_RXD_3 TMS570_BALL_WITH_MMR(91, 2)
#define TMS570_PIN_MMR_ALT_MII_RX_DV TMS570_BALL_WITH_MMR(90, 0)
#define TMS570_PIN_MMR_ALT_MII_RX_ER TMS570_BALL_WITH_MMR(90, 1)
#define TMS570_PIN_MMR_ALT_MII_TX_CLK TMS570_BALL_WITH_MMR(91, 3)
#define TMS570_PIN_MMR_ALT_eQEP1A TMS570_BALL_WITH_MMR(81, 3)
#define TMS570_PIN_MMR_ALT_eQEP1B TMS570_BALL_WITH_MMR(82, 0)
#define TMS570_PIN_MMR_ALT_eQEP1I TMS570_BALL_WITH_MMR(82, 1)
#define TMS570_PIN_MMR_ALT_eQEP1S TMS570_BALL_WITH_MMR(82, 2)
#define TMS570_PIN_MMR_ALT_eQEP2A TMS570_BALL_WITH_MMR(82, 3)
#define TMS570_PIN_MMR_ALT_eQEP2B TMS570_BALL_WITH_MMR(83, 0)
#define TMS570_PIN_MMR_ALT_eQEP2I TMS570_BALL_WITH_MMR(83, 1)
#define TMS570_PIN_MMR_ALT_eQEP2S TMS570_BALL_WITH_MMR(83, 2)
#define TMS570_PIN_MMR_ALT_nTZ1_1 TMS570_BALL_WITH_MMR(99, 0)
#define TMS570_PIN_MMR_ALT_nTZ1_2 TMS570_BALL_WITH_MMR(99, 1)
#define TMS570_PIN_MMR_ALT_nTZ1_3 TMS570_BALL_WITH_MMR(99, 2)

#define TMS570_BALL_N19 TMS570_BALL_WITH_MMR(0, 0)
#define TMS570_BALL_N19_AD1EVT TMS570_PIN_AND_FNC(TMS570_BALL_N19, 0)
#define TMS570_BALL_N19_MII_RX_ER TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N19, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RX_ER, 1))
#define TMS570_BALL_N19_RMII_RX_ER TMS570_PIN_AND_FNC(TMS570_BALL_N19, 3)
#define TMS570_BALL_N19_nTZ1_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N19, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_nTZ1_1, 0))

#define TMS570_BALL_D4 TMS570_BALL_WITH_MMR(0, 1)
#define TMS570_BALL_D4_EMIF_ADDR_00 TMS570_PIN_AND_FNC(TMS570_BALL_D4, 0)
#define TMS570_BALL_D4_HET2_01 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D4, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_01, 1))

#define TMS570_BALL_D5 TMS570_BALL_WITH_MMR(0, 2)
#define TMS570_BALL_D5_EMIF_ADDR_01 TMS570_PIN_AND_FNC(TMS570_BALL_D5, 0)
#define TMS570_BALL_D5_HET2_03 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D5, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_03, 1))

#define TMS570_BALL_C4 TMS570_BALL_WITH_MMR(0, 3)
#define TMS570_BALL_C4_EMIF_ADDR_06 TMS570_PIN_AND_FNC(TMS570_BALL_C4, 0)
#define TMS570_BALL_C4_RTP_DATA_13 TMS570_PIN_AND_FNC(TMS570_BALL_C4, 1)
#define TMS570_BALL_C4_HET2_11 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C4, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_11, 1))

#define TMS570_BALL_C5 TMS570_BALL_WITH_MMR(1, 0)
#define TMS570_BALL_C5_EMIF_ADDR_07 TMS570_PIN_AND_FNC(TMS570_BALL_C5, 0)
#define TMS570_BALL_C5_RTP_DATA_12 TMS570_PIN_AND_FNC(TMS570_BALL_C5, 1)
#define TMS570_BALL_C5_HET2_13 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C5, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_13, 1))

#define TMS570_BALL_C6 TMS570_BALL_WITH_MMR(1, 1)
#define TMS570_BALL_C6_EMIF_ADDR_08 TMS570_PIN_AND_FNC(TMS570_BALL_C6, 0)
#define TMS570_BALL_C6_RTP_DATA_11 TMS570_PIN_AND_FNC(TMS570_BALL_C6, 1)
#define TMS570_BALL_C6_HET2_15 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C6, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_15, 1))

#define TMS570_BALL_C7 TMS570_BALL_WITH_MMR(1, 2)
#define TMS570_BALL_C7_EMIF_ADDR_09 TMS570_PIN_AND_FNC(TMS570_BALL_C7, 0)
#define TMS570_BALL_C7_RTP_DATA_10 TMS570_PIN_AND_FNC(TMS570_BALL_C7, 1)

#define TMS570_BALL_C8 TMS570_BALL_WITH_MMR(1, 3)
#define TMS570_BALL_C8_EMIF_ADDR_10 TMS570_PIN_AND_FNC(TMS570_BALL_C8, 0)
#define TMS570_BALL_C8_RTP_DATA_09 TMS570_PIN_AND_FNC(TMS570_BALL_C8, 1)

#define TMS570_BALL_C9 TMS570_BALL_WITH_MMR(2, 0)
#define TMS570_BALL_C9_EMIF_ADDR_11 TMS570_PIN_AND_FNC(TMS570_BALL_C9, 0)
#define TMS570_BALL_C9_RTP_DATA_08 TMS570_PIN_AND_FNC(TMS570_BALL_C9, 1)

#define TMS570_BALL_C10 TMS570_BALL_WITH_MMR(2, 1)
#define TMS570_BALL_C10_EMIF_ADDR_12 TMS570_PIN_AND_FNC(TMS570_BALL_C10, 0)
#define TMS570_BALL_C10_RTP_DATA_06 TMS570_PIN_AND_FNC(TMS570_BALL_C10, 1)

#define TMS570_BALL_C11 TMS570_BALL_WITH_MMR(2, 2)
#define TMS570_BALL_C11_EMIF_ADDR_13 TMS570_PIN_AND_FNC(TMS570_BALL_C11, 0)
#define TMS570_BALL_C11_RTP_DATA_05 TMS570_PIN_AND_FNC(TMS570_BALL_C11, 1)

#define TMS570_BALL_C12 TMS570_BALL_WITH_MMR(2, 3)
#define TMS570_BALL_C12_EMIF_ADDR_14 TMS570_PIN_AND_FNC(TMS570_BALL_C12, 0)
#define TMS570_BALL_C12_RTP_DATA_04 TMS570_PIN_AND_FNC(TMS570_BALL_C12, 1)

#define TMS570_BALL_C13 TMS570_BALL_WITH_MMR(3, 0)
#define TMS570_BALL_C13_EMIF_ADDR_15 TMS570_PIN_AND_FNC(TMS570_BALL_C13, 0)
#define TMS570_BALL_C13_RTP_DATA_03 TMS570_PIN_AND_FNC(TMS570_BALL_C13, 1)

#define TMS570_BALL_D14 TMS570_BALL_WITH_MMR(3, 1)
#define TMS570_BALL_D14_EMIF_ADDR_16 TMS570_PIN_AND_FNC(TMS570_BALL_D14, 0)
#define TMS570_BALL_D14_RTP_DATA_02 TMS570_PIN_AND_FNC(TMS570_BALL_D14, 1)

#define TMS570_BALL_C14 TMS570_BALL_WITH_MMR(3, 2)
#define TMS570_BALL_C14_EMIF_ADDR_17 TMS570_PIN_AND_FNC(TMS570_BALL_C14, 0)
#define TMS570_BALL_C14_RTP_DATA_01 TMS570_PIN_AND_FNC(TMS570_BALL_C14, 1)

#define TMS570_BALL_D15 TMS570_BALL_WITH_MMR(3, 3)
#define TMS570_BALL_D15_EMIF_ADDR_18 TMS570_PIN_AND_FNC(TMS570_BALL_D15, 0)
#define TMS570_BALL_D15_RTP_DATA_00 TMS570_PIN_AND_FNC(TMS570_BALL_D15, 1)

#define TMS570_BALL_C15 TMS570_BALL_WITH_MMR(4, 0)
#define TMS570_BALL_C15_EMIF_ADDR_19 TMS570_PIN_AND_FNC(TMS570_BALL_C15, 0)
#define TMS570_BALL_C15_RTP_nENA TMS570_PIN_AND_FNC(TMS570_BALL_C15, 1)

#define TMS570_BALL_C16 TMS570_BALL_WITH_MMR(4, 1)
#define TMS570_BALL_C16_EMIF_ADDR_20 TMS570_PIN_AND_FNC(TMS570_BALL_C16, 0)
#define TMS570_BALL_C16_RTP_nSYNC TMS570_PIN_AND_FNC(TMS570_BALL_C16, 1)

#define TMS570_BALL_C17 TMS570_BALL_WITH_MMR(4, 2)
#define TMS570_BALL_C17_EMIF_ADDR_21 TMS570_PIN_AND_FNC(TMS570_BALL_C17, 0)
#define TMS570_BALL_C17_RTP_CLK TMS570_PIN_AND_FNC(TMS570_BALL_C17, 1)

#define TMS570_BALL_D16 TMS570_BALL_WITH_MMR(8, 3)
#define TMS570_BALL_D16_EMIF_BA_1 TMS570_PIN_AND_FNC(TMS570_BALL_D16, 0)
#define TMS570_BALL_D16_ TMS570_PIN_AND_FNC(TMS570_BALL_D16, 1)
#define TMS570_BALL_D16_HET2_05 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D16, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_05, 1))

#define TMS570_BALL_K3 TMS570_BALL_WITH_MMR(9, 0)
#define TMS570_BALL_K3_EMIF_CLK TMS570_PIN_AND_FNC(TMS570_BALL_K3, 1)
#define TMS570_BALL_K3_ECLK2 TMS570_PIN_AND_FNC(TMS570_BALL_K3, 2)

#define TMS570_BALL_R4 TMS570_BALL_WITH_MMR(9, 1)
#define TMS570_BALL_R4_EMIF_nCAS TMS570_PIN_AND_FNC(TMS570_BALL_R4, 0)
#define TMS570_BALL_R4_GIOB_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R4, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_3, 1))

#define TMS570_BALL_N17 TMS570_BALL_WITH_MMR(9, 2)
#define TMS570_BALL_N17_EMIF_nCS_0 TMS570_PIN_AND_FNC(TMS570_BALL_N17, 0)
#define TMS570_BALL_N17_RTP_DATA_15 TMS570_PIN_AND_FNC(TMS570_BALL_N17, 1)
#define TMS570_BALL_N17_HET2_07 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N17, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_07, 1))

#define TMS570_BALL_L17 TMS570_BALL_WITH_MMR(9, 3)
#define TMS570_BALL_L17_EMIF_nCS_2 TMS570_PIN_AND_FNC(TMS570_BALL_L17, 0)
#define TMS570_BALL_L17_GIOB_4 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_L17, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_4, 1))

#define TMS570_BALL_K17 TMS570_BALL_WITH_MMR(10, 0)
#define TMS570_BALL_K17_EMIF_nCS_3 TMS570_PIN_AND_FNC(TMS570_BALL_K17, 0)
#define TMS570_BALL_K17_RTP_DATA_14 TMS570_PIN_AND_FNC(TMS570_BALL_K17, 1)
#define TMS570_BALL_K17_HET2_09 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_K17, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_09, 1))

#define TMS570_BALL_M17 TMS570_BALL_WITH_MMR(10, 1)
#define TMS570_BALL_M17_EMIF_nCSl_4 TMS570_PIN_AND_FNC(TMS570_BALL_M17, 0)
#define TMS570_BALL_M17_RTP_DATA_07 TMS570_PIN_AND_FNC(TMS570_BALL_M17, 1)
#define TMS570_BALL_M17_GIOB_5 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_M17, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_5, 1))

#define TMS570_BALL_R3 TMS570_BALL_WITH_MMR(10, 2)
#define TMS570_BALL_R3_EMIF_nRAS TMS570_PIN_AND_FNC(TMS570_BALL_R3, 0)
#define TMS570_BALL_R3_GIOB_6 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R3, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_6, 1))

#define TMS570_BALL_P3 TMS570_BALL_WITH_MMR(10, 3)
#define TMS570_BALL_P3_EMIF_nWAIT TMS570_PIN_AND_FNC(TMS570_BALL_P3, 0)
#define TMS570_BALL_P3_GIOB_7 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_P3, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_7, 1))

#define TMS570_BALL_D17 TMS570_BALL_WITH_MMR(11, 0)
#define TMS570_BALL_D17_EMIF_nWE TMS570_PIN_AND_FNC(TMS570_BALL_D17, 0)
#define TMS570_BALL_D17_EMIF_RNW TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D17, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_J1, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_E9 TMS570_BALL_WITH_MMR(11, 1)
#define TMS570_BALL_E9_ETMDATA_08 TMS570_PIN_AND_FNC(TMS570_BALL_E9, 0)
#define TMS570_BALL_E9_EMIF_ADDR_05 TMS570_PIN_AND_FNC(TMS570_BALL_E9, 1)

#define TMS570_BALL_E8 TMS570_BALL_WITH_MMR(11, 2)
#define TMS570_BALL_E8_ETMDATA_09 TMS570_PIN_AND_FNC(TMS570_BALL_E8, 0)
#define TMS570_BALL_E8_EMIF_ADDR_04 TMS570_PIN_AND_FNC(TMS570_BALL_E8, 1)

#define TMS570_BALL_E7 TMS570_BALL_WITH_MMR(11, 3)
#define TMS570_BALL_E7_ETMDATA_10 TMS570_PIN_AND_FNC(TMS570_BALL_E7, 0)
#define TMS570_BALL_E7_EMIF_ADDR_03 TMS570_PIN_AND_FNC(TMS570_BALL_E7, 1)

#define TMS570_BALL_E6 TMS570_BALL_WITH_MMR(12, 0)
#define TMS570_BALL_E6_ETMDATA_11 TMS570_PIN_AND_FNC(TMS570_BALL_E6, 0)
#define TMS570_BALL_E6_EMIF_ADDR_02 TMS570_PIN_AND_FNC(TMS570_BALL_E6, 1)

#define TMS570_BALL_E13 TMS570_BALL_WITH_MMR(12, 1)
#define TMS570_BALL_E13_ETMDATA_12 TMS570_PIN_AND_FNC(TMS570_BALL_E13, 0)
#define TMS570_BALL_E13_EMIF_BA_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E13, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_J4, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_E12 TMS570_BALL_WITH_MMR(12, 2)
#define TMS570_BALL_E12_ETMDATA_13 TMS570_PIN_AND_FNC(TMS570_BALL_E12, 0)
#define TMS570_BALL_E12_EMIF_nOE TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E12, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_A13, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_E11 TMS570_BALL_WITH_MMR(12, 3)
#define TMS570_BALL_E11_ETMDATA_14 TMS570_PIN_AND_FNC(TMS570_BALL_E11, 0)
#define TMS570_BALL_E11_EMIF_nDQM_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E11, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_P2, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_E10 TMS570_BALL_WITH_MMR(13, 0)
#define TMS570_BALL_E10_ETMDATA_15 TMS570_PIN_AND_FNC(TMS570_BALL_E10, 0)
#define TMS570_BALL_E10_EMIF_nDQM_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E10, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_B13, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_K15 TMS570_BALL_WITH_MMR(13, 1)
#define TMS570_BALL_K15_ETMDATA_16 TMS570_PIN_AND_FNC(TMS570_BALL_K15, 0)
#define TMS570_BALL_K15_EMIF_DATA_00 TMS570_PIN_AND_FNC(TMS570_BALL_K15, 1)

#define TMS570_BALL_L15 TMS570_BALL_WITH_MMR(13, 2)
#define TMS570_BALL_L15_ETMDATA_17 TMS570_PIN_AND_FNC(TMS570_BALL_L15, 0)
#define TMS570_BALL_L15_EMIF_DATA_01 TMS570_PIN_AND_FNC(TMS570_BALL_L15, 1)

#define TMS570_BALL_M15 TMS570_BALL_WITH_MMR(13, 3)
#define TMS570_BALL_M15_ETMDATA_18 TMS570_PIN_AND_FNC(TMS570_BALL_M15, 0)
#define TMS570_BALL_M15_EMIF_DATA_02 TMS570_PIN_AND_FNC(TMS570_BALL_M15, 1)

#define TMS570_BALL_N15 TMS570_BALL_WITH_MMR(14, 0)
#define TMS570_BALL_N15_ETMDATA_19 TMS570_PIN_AND_FNC(TMS570_BALL_N15, 0)
#define TMS570_BALL_N15_EMIF_DATA_03 TMS570_PIN_AND_FNC(TMS570_BALL_N15, 1)

#define TMS570_BALL_E5 TMS570_BALL_WITH_MMR(14, 1)
#define TMS570_BALL_E5_ETMDATA_20 TMS570_PIN_AND_FNC(TMS570_BALL_E5, 0)
#define TMS570_BALL_E5_EMIF_DATA_04 TMS570_PIN_AND_FNC(TMS570_BALL_E5, 1)

#define TMS570_BALL_F5 TMS570_BALL_WITH_MMR(14, 2)
#define TMS570_BALL_F5_ETMDATA_21 TMS570_PIN_AND_FNC(TMS570_BALL_F5, 0)
#define TMS570_BALL_F5_EMIF_DATA_05 TMS570_PIN_AND_FNC(TMS570_BALL_F5, 1)

#define TMS570_BALL_G5 TMS570_BALL_WITH_MMR(14, 3)
#define TMS570_BALL_G5_ETMDATA_22 TMS570_PIN_AND_FNC(TMS570_BALL_G5, 0)
#define TMS570_BALL_G5_EMIF_DATA_06 TMS570_PIN_AND_FNC(TMS570_BALL_G5, 1)

#define TMS570_BALL_K5 TMS570_BALL_WITH_MMR(15, 0)
#define TMS570_BALL_K5_ETMDATA_23 TMS570_PIN_AND_FNC(TMS570_BALL_K5, 0)
#define TMS570_BALL_K5_EMIF_DATA_07 TMS570_PIN_AND_FNC(TMS570_BALL_K5, 1)

#define TMS570_BALL_L5 TMS570_BALL_WITH_MMR(15, 1)
#define TMS570_BALL_L5_ETMDATA_24 TMS570_PIN_AND_FNC(TMS570_BALL_L5, 0)
#define TMS570_BALL_L5_EMIF_DATA_08 TMS570_PIN_AND_FNC(TMS570_BALL_L5, 1)
#define TMS570_BALL_L5_HET2_24 TMS570_PIN_AND_FNC(TMS570_BALL_L5, 2)
#define TMS570_BALL_L5_MIBSPI5NCS_4 TMS570_PIN_AND_FNC(TMS570_BALL_L5, 3)

#define TMS570_BALL_M5 TMS570_BALL_WITH_MMR(15, 2)
#define TMS570_BALL_M5_ETMDATA_25 TMS570_PIN_AND_FNC(TMS570_BALL_M5, 0)
#define TMS570_BALL_M5_EMIF_DATA_09 TMS570_PIN_AND_FNC(TMS570_BALL_M5, 1)
#define TMS570_BALL_M5_HET2_25 TMS570_PIN_AND_FNC(TMS570_BALL_M5, 2)
#define TMS570_BALL_M5_MIBSPI5NCS_5 TMS570_PIN_AND_FNC(TMS570_BALL_M5, 3)

#define TMS570_BALL_N5 TMS570_BALL_WITH_MMR(15, 3)
#define TMS570_BALL_N5_ETMDATA_26 TMS570_PIN_AND_FNC(TMS570_BALL_N5, 0)
#define TMS570_BALL_N5_EMIF_DATA_10 TMS570_PIN_AND_FNC(TMS570_BALL_N5, 1)
#define TMS570_BALL_N5_HET2_26 TMS570_PIN_AND_FNC(TMS570_BALL_N5, 2)

#define TMS570_BALL_P5 TMS570_BALL_WITH_MMR(16, 0)
#define TMS570_BALL_P5_ETMDATA_27 TMS570_PIN_AND_FNC(TMS570_BALL_P5, 0)
#define TMS570_BALL_P5_EMIF_DATA_11 TMS570_PIN_AND_FNC(TMS570_BALL_P5, 1)
#define TMS570_BALL_P5_HET2_27 TMS570_PIN_AND_FNC(TMS570_BALL_P5, 2)

#define TMS570_BALL_R5 TMS570_BALL_WITH_MMR(16, 1)
#define TMS570_BALL_R5_ETMDATA_28 TMS570_PIN_AND_FNC(TMS570_BALL_R5, 0)
#define TMS570_BALL_R5_EMIF_DATA_12 TMS570_PIN_AND_FNC(TMS570_BALL_R5, 1)
#define TMS570_BALL_R5_HET2_28 TMS570_PIN_AND_FNC(TMS570_BALL_R5, 2)
#define TMS570_BALL_R5_GIOA_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R5, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_0, 1))

#define TMS570_BALL_R6 TMS570_BALL_WITH_MMR(16, 2)
#define TMS570_BALL_R6_ETMDATA_29 TMS570_PIN_AND_FNC(TMS570_BALL_R6, 0)
#define TMS570_BALL_R6_EMIF_DATA_13 TMS570_PIN_AND_FNC(TMS570_BALL_R6, 1)
#define TMS570_BALL_R6_HET2_29 TMS570_PIN_AND_FNC(TMS570_BALL_R6, 2)
#define TMS570_BALL_R6_GIOA_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R6, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_1, 1))

#define TMS570_BALL_R7 TMS570_BALL_WITH_MMR(16, 3)
#define TMS570_BALL_R7_ETMDATA_30 TMS570_PIN_AND_FNC(TMS570_BALL_R7, 0)
#define TMS570_BALL_R7_EMIF_DATA_14 TMS570_PIN_AND_FNC(TMS570_BALL_R7, 1)
#define TMS570_BALL_R7_HET2_30 TMS570_PIN_AND_FNC(TMS570_BALL_R7, 2)
#define TMS570_BALL_R7_GIOA_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R7, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_3, 1))

#define TMS570_BALL_R8 TMS570_BALL_WITH_MMR(17, 0)
#define TMS570_BALL_R8_ETMDATA_31 TMS570_PIN_AND_FNC(TMS570_BALL_R8, 0)
#define TMS570_BALL_R8_EMIF_DATA_15 TMS570_PIN_AND_FNC(TMS570_BALL_R8, 1)
#define TMS570_BALL_R8_HET2_31 TMS570_PIN_AND_FNC(TMS570_BALL_R8, 2)
#define TMS570_BALL_R8_GIOA_4 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R8, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_4, 1))

#define TMS570_BALL_R9 TMS570_BALL_WITH_MMR(17, 1)
#define TMS570_BALL_R9_ETMTRACECLKIN TMS570_PIN_AND_FNC(TMS570_BALL_R9, 0)
#define TMS570_BALL_R9_EXTCLKIN2 TMS570_PIN_AND_FNC(TMS570_BALL_R9, 1)
#define TMS570_BALL_R9_GIOA_5 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R9, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_5, 1))

#define TMS570_BALL_R10 TMS570_BALL_WITH_MMR(17, 2)
#define TMS570_BALL_R10_ETMTRACECLKOUT TMS570_PIN_AND_FNC(TMS570_BALL_R10, 0)
#define TMS570_BALL_R10_GIOA_6 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R10, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_6, 1))

#define TMS570_BALL_R11 TMS570_BALL_WITH_MMR(17, 3)
#define TMS570_BALL_R11_ETMTRACECTL TMS570_PIN_AND_FNC(TMS570_BALL_R11, 0)
#define TMS570_BALL_R11_GIOA_7 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R11, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_7, 1))

#define TMS570_BALL_B15 TMS570_BALL_WITH_MMR(18, 0)
#define TMS570_BALL_B15_FRAYTX1 TMS570_PIN_AND_FNC(TMS570_BALL_B15, 0)
#define TMS570_BALL_B15_GIOA_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B15, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_2, 1))

#define TMS570_BALL_B8 TMS570_BALL_WITH_MMR(18, 1)
#define TMS570_BALL_B8_FRAYTX2 TMS570_PIN_AND_FNC(TMS570_BALL_B8, 0)
#define TMS570_BALL_B8_GIOB_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B8, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_0, 1))

#define TMS570_BALL_B16 TMS570_BALL_WITH_MMR(18, 2)
#define TMS570_BALL_B16_FRAYTXEN1 TMS570_PIN_AND_FNC(TMS570_BALL_B16, 0)
#define TMS570_BALL_B16_GIOB_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B16, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_1, 1))

#define TMS570_BALL_B9 TMS570_BALL_WITH_MMR(18, 3)
#define TMS570_BALL_B9_FRAYTXEN2 TMS570_PIN_AND_FNC(TMS570_BALL_B9, 0)
#define TMS570_BALL_B9_GIOB_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B9, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_2, 1))

#define TMS570_BALL_C1 TMS570_BALL_WITH_MMR(19, 0)
#define TMS570_BALL_C1_GIOA_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C1, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_2, 0))
#define TMS570_BALL_C1_HET2_00 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C1, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_00, 1))
#define TMS570_BALL_C1_eQEP2I TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C1, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP2I, 1))

#define TMS570_BALL_E1 TMS570_BALL_WITH_MMR(19, 1)
#define TMS570_BALL_E1_GIOA_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E1, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_3, 0))
#define TMS570_BALL_E1_HET2_02 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E1, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_02, 1))

#define TMS570_BALL_B5 TMS570_BALL_WITH_MMR(19, 2)
#define TMS570_BALL_B5_GIOA_5 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B5, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_5, 0))
#define TMS570_BALL_B5_EXTCLKIN TMS570_PIN_AND_FNC(TMS570_BALL_B5, 3)
#define TMS570_BALL_B5_ePWM1A TMS570_PIN_AND_FNC(TMS570_BALL_B5, 5)

#define TMS570_BALL_H3 TMS570_BALL_WITH_MMR(19, 3)
#define TMS570_BALL_H3_GIOA_6 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_H3, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_6, 0))
#define TMS570_BALL_H3_HET2_04 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_H3, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_04, 1))
#define TMS570_BALL_H3_ePWM1B TMS570_PIN_AND_FNC(TMS570_BALL_H3, 5)

#define TMS570_BALL_M1 TMS570_BALL_WITH_MMR(20, 0)
#define TMS570_BALL_M1_GIOA_7 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_M1, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOA_7, 0))
#define TMS570_BALL_M1_HET2_06 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_M1, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_06, 1))
#define TMS570_BALL_M1_ePWM2A TMS570_PIN_AND_FNC(TMS570_BALL_M1, 5)

#define TMS570_BALL_F2 TMS570_BALL_WITH_MMR(20, 1)
#define TMS570_BALL_F2_GIOB_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_F2, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_2, 0))
#define TMS570_BALL_F2_DCAN4TX TMS570_PIN_AND_FNC(TMS570_BALL_F2, 3)

#define TMS570_BALL_W10 TMS570_BALL_WITH_MMR(20, 2)
#define TMS570_BALL_W10_GIOB_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_W10, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_3, 0))
#define TMS570_BALL_W10_DCAN4RX TMS570_PIN_AND_FNC(TMS570_BALL_W10, 3)

#define TMS570_BALL_J2 TMS570_BALL_WITH_MMR(20, 3)
#define TMS570_BALL_J2_GIOB_6 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_J2, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_6, 0))
#define TMS570_BALL_J2_nERROR1 TMS570_PIN_AND_FNC(TMS570_BALL_J2, 1)

#define TMS570_BALL_F1 TMS570_BALL_WITH_MMR(21, 0)
#define TMS570_BALL_F1_GIOB_7 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_F1, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_GIOB_7, 0))
#define TMS570_BALL_F1_nERROR2 TMS570_PIN_AND_FNC(TMS570_BALL_F1, 1)
#define TMS570_BALL_F1_nTZ1_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_F1, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_nTZ1_2, 0))

#define TMS570_BALL_R2 TMS570_BALL_WITH_MMR(21, 1)
#define TMS570_BALL_R2_MIBSPI1NCS_0 TMS570_PIN_AND_FNC(TMS570_BALL_R2, 0)
#define TMS570_BALL_R2_MIBSPI1SOMI_1 TMS570_PIN_AND_FNC(TMS570_BALL_R2, 1)
#define TMS570_BALL_R2_MII_TXD_2 TMS570_PIN_AND_FNC(TMS570_BALL_R2, 2)
#define TMS570_BALL_R2_ECAP6 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_R2, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_ECAP6, 1))

#define TMS570_BALL_F3 TMS570_BALL_WITH_MMR(21, 2)
#define TMS570_BALL_F3_MIBSPI1NCS_1 TMS570_PIN_AND_FNC(TMS570_BALL_F3, 0)
#define TMS570_BALL_F3_MII_COL TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_F3, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_COL, 1))
#define TMS570_BALL_F3_HET1_17 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_F3, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_17, 1))
#define TMS570_BALL_F3_eQEP1S TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_F3, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP1S, 1))

#define TMS570_BALL_G3 TMS570_BALL_WITH_MMR(21, 3)
#define TMS570_BALL_G3_MIBSPI1NCS_2 TMS570_PIN_AND_FNC(TMS570_BALL_G3, 0)
#define TMS570_BALL_G3_MDIO TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_G3, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MDIO, 1))
#define TMS570_BALL_G3_HET1_19 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_G3, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_19, 1))

#define TMS570_BALL_J3 TMS570_BALL_WITH_MMR(22, 0)
#define TMS570_BALL_J3_MIBSPI1NCS_3 TMS570_PIN_AND_FNC(TMS570_BALL_J3, 0)
#define TMS570_BALL_J3_HET1_21 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_J3, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_21, 1))
#define TMS570_BALL_J3_nTZ1_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_J3, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_nTZ1_3, 0))

#define TMS570_BALL_G19 TMS570_BALL_WITH_MMR(22, 1)
#define TMS570_BALL_G19_MIBSPI1NENA TMS570_PIN_AND_FNC(TMS570_BALL_G19, 0)
#define TMS570_BALL_G19_MII_RXD_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_G19, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RXD_2, 1))
#define TMS570_BALL_G19_HET1_23 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_G19, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_23, 1))
#define TMS570_BALL_G19_ECAP4 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_G19, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_ECAP4, 1))

#define TMS570_BALL_V9 TMS570_BALL_WITH_MMR(22, 2)
#define TMS570_BALL_V9_MIBSPI3CLK TMS570_PIN_AND_FNC(TMS570_BALL_V9, 0)
#define TMS570_BALL_V9_AD1EXT_SEL_01 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V9, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_H17, 4) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_V9_eQEP1A TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V9, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP1A, 1))

#define TMS570_BALL_V10 TMS570_BALL_WITH_MMR(22, 3)
#define TMS570_BALL_V10_MIBSPI3NCS_0 TMS570_PIN_AND_FNC(TMS570_BALL_V10, 0)
#define TMS570_BALL_V10_AD2EVT TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V10, 1), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_AD2EVT, 1))
#define TMS570_BALL_V10_eQEP1I TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V10, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP1I, 1))

#define TMS570_BALL_V5 TMS570_BALL_WITH_MMR(23, 0)
#define TMS570_BALL_V5_MIBSPI3NCS_1 TMS570_PIN_AND_FNC(TMS570_BALL_V5, 0)
#define TMS570_BALL_V5_MDCLK TMS570_PIN_AND_FNC(TMS570_BALL_V5, 2)
#define TMS570_BALL_V5_HET1_25 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V5, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_25, 1))

#define TMS570_BALL_B2 TMS570_BALL_WITH_MMR(23, 1)
#define TMS570_BALL_B2_MIBSPI3NCS_2 TMS570_PIN_AND_FNC(TMS570_BALL_B2, 0)
#define TMS570_BALL_B2_I2C1_SDA TMS570_PIN_AND_FNC(TMS570_BALL_B2, 1)
#define TMS570_BALL_B2_HET1_27 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B2, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_27, 1))
#define TMS570_BALL_B2_nTZ1_2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B2, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_nTZ1_2, 1))

#define TMS570_BALL_C3 TMS570_BALL_WITH_MMR(23, 2)
#define TMS570_BALL_C3_MIBSPI3NCS_3 TMS570_PIN_AND_FNC(TMS570_BALL_C3, 0)
#define TMS570_BALL_C3_I2C1_SCL TMS570_PIN_AND_FNC(TMS570_BALL_C3, 1)
#define TMS570_BALL_C3_HET1_29 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C3, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_29, 1))
#define TMS570_BALL_C3_nTZ1_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_C3, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_nTZ1_1, 1))

#define TMS570_BALL_W9 TMS570_BALL_WITH_MMR(23, 3)
#define TMS570_BALL_W9_MIBSPI3NENA TMS570_PIN_AND_FNC(TMS570_BALL_W9, 0)
#define TMS570_BALL_W9_MIBSPI3NCS_5 TMS570_PIN_AND_FNC(TMS570_BALL_W9, 1)
#define TMS570_BALL_W9_HET1_31 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_W9, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_31, 1))
#define TMS570_BALL_W9_eQEP1B TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_W9, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP1B, 1))

#define TMS570_BALL_W8 TMS570_BALL_WITH_MMR(24, 0)
#define TMS570_BALL_W8_MIBSPI3SIMO TMS570_PIN_AND_FNC(TMS570_BALL_W8, 0)
#define TMS570_BALL_W8_AD1EXT_SEL_00 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_W8, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_E16, 4) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_W8_ECAP3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_W8, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_ECAP3, 1))

#define TMS570_BALL_V8 TMS570_BALL_WITH_MMR(24, 1)
#define TMS570_BALL_V8_MIBSPI3SOMI TMS570_PIN_AND_FNC(TMS570_BALL_V8, 0)
#define TMS570_BALL_V8_EXT_ENA TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V8, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_G16, 4) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_V8_ECAP2 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V8, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_ECAP2, 1))

#define TMS570_BALL_H19 TMS570_BALL_WITH_MMR(24, 2)
#define TMS570_BALL_H19_MIBSPI5CLK TMS570_PIN_AND_FNC(TMS570_BALL_H19, 0)
#define TMS570_BALL_H19_DMM_DATA_04 TMS570_PIN_AND_FNC(TMS570_BALL_H19, 1)
#define TMS570_BALL_H19_MII_TXEN TMS570_PIN_AND_FNC(TMS570_BALL_H19, 2)
#define TMS570_BALL_H19_RMII_TXEN TMS570_PIN_AND_FNC(TMS570_BALL_H19, 3)

#define TMS570_BALL_E19 TMS570_BALL_WITH_MMR(24, 3)
#define TMS570_BALL_E19_MIBSPI5NCS_0 TMS570_PIN_AND_FNC(TMS570_BALL_E19, 0)
#define TMS570_BALL_E19_DMM_DATA_05 TMS570_PIN_AND_FNC(TMS570_BALL_E19, 1)
#define TMS570_BALL_E19_ePWM4A TMS570_PIN_AND_FNC(TMS570_BALL_E19, 5)

#define TMS570_BALL_B6 TMS570_BALL_WITH_MMR(25, 0)
#define TMS570_BALL_B6_MIBSPI5NCS_1 TMS570_PIN_AND_FNC(TMS570_BALL_B6, 0)
#define TMS570_BALL_B6_DMM_DATA_06 TMS570_PIN_AND_FNC(TMS570_BALL_B6, 1)

#define TMS570_BALL_W6 TMS570_BALL_WITH_MMR(25, 1)
#define TMS570_BALL_W6_MIBSPI5NCS_2 TMS570_PIN_AND_FNC(TMS570_BALL_W6, 0)
#define TMS570_BALL_W6_DMM_DATA_02 TMS570_PIN_AND_FNC(TMS570_BALL_W6, 1)

#define TMS570_BALL_T12 TMS570_BALL_WITH_MMR(25, 2)
#define TMS570_BALL_T12_MIBSPI5NCS_3 TMS570_PIN_AND_FNC(TMS570_BALL_T12, 0)
#define TMS570_BALL_T12_DMM_DATA_03 TMS570_PIN_AND_FNC(TMS570_BALL_T12, 1)

#define TMS570_BALL_H18 TMS570_BALL_WITH_MMR(25, 3)
#define TMS570_BALL_H18_MIBSPI5NENA TMS570_PIN_AND_FNC(TMS570_BALL_H18, 0)
#define TMS570_BALL_H18_DMM_DATA_07 TMS570_PIN_AND_FNC(TMS570_BALL_H18, 1)
#define TMS570_BALL_H18_MII_RXD_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_H18, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RXD_3, 1))
#define TMS570_BALL_H18_ECAP5 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_H18, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_ECAP5, 1))

#define TMS570_BALL_J19 TMS570_BALL_WITH_MMR(26, 0)
#define TMS570_BALL_J19_MIBSPI5SIMO_0 TMS570_PIN_AND_FNC(TMS570_BALL_J19, 0)
#define TMS570_BALL_J19_DMM_DATA_08 TMS570_PIN_AND_FNC(TMS570_BALL_J19, 1)
#define TMS570_BALL_J19_MII_TXD_1 TMS570_PIN_AND_FNC(TMS570_BALL_J19, 2)
#define TMS570_BALL_J19_RMII_TXD_1 TMS570_PIN_AND_FNC(TMS570_BALL_J19, 3)

#define TMS570_BALL_E16 TMS570_BALL_WITH_MMR(26, 1)
#define TMS570_BALL_E16_MIBSPI5SIMO_1 TMS570_PIN_AND_FNC(TMS570_BALL_E16, 0)
#define TMS570_BALL_E16_DMM_DATA_09 TMS570_PIN_AND_FNC(TMS570_BALL_E16, 1)
#define TMS570_BALL_E16_AD1EXT_SEL_00 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E16, 4), \
                TMS570_PIN_AND_FNC(TMS570_BALL_W8, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_H17 TMS570_BALL_WITH_MMR(26, 2)
#define TMS570_BALL_H17_MIBSPI5SIMO_2 TMS570_PIN_AND_FNC(TMS570_BALL_H17, 0)
#define TMS570_BALL_H17_DMM_DATA_10 TMS570_PIN_AND_FNC(TMS570_BALL_H17, 1)
#define TMS570_BALL_H17_AD1EXT_SEL_01 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_H17, 4), \
                TMS570_PIN_AND_FNC(TMS570_BALL_V9, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_G17 TMS570_BALL_WITH_MMR(26, 3)
#define TMS570_BALL_G17_MIBSPI5SIMO_3 TMS570_PIN_AND_FNC(TMS570_BALL_G17, 0)
#define TMS570_BALL_G17_DMM_DATA_11 TMS570_PIN_AND_FNC(TMS570_BALL_G17, 1)
#define TMS570_BALL_G17_I2C2_SDA TMS570_PIN_AND_FNC(TMS570_BALL_G17, 2)
#define TMS570_BALL_G17_AD1EXT_SEL_02 TMS570_PIN_AND_FNC(TMS570_BALL_G17, 4)

#define TMS570_BALL_J18 TMS570_BALL_WITH_MMR(27, 0)
#define TMS570_BALL_J18_MIBSPI5SOMI_0 TMS570_PIN_AND_FNC(TMS570_BALL_J18, 0)
#define TMS570_BALL_J18_DMM_DATA_12 TMS570_PIN_AND_FNC(TMS570_BALL_J18, 1)
#define TMS570_BALL_J18_MII_TXD_0 TMS570_PIN_AND_FNC(TMS570_BALL_J18, 2)
#define TMS570_BALL_J18_RMII_TXD_0 TMS570_PIN_AND_FNC(TMS570_BALL_J18, 3)

#define TMS570_BALL_E17 TMS570_BALL_WITH_MMR(27, 1)
#define TMS570_BALL_E17_MIBSPI5SOMI_1 TMS570_PIN_AND_FNC(TMS570_BALL_E17, 0)
#define TMS570_BALL_E17_DMM_DATA_13 TMS570_PIN_AND_FNC(TMS570_BALL_E17, 1)
#define TMS570_BALL_E17_AD1EXT_SEL_03 TMS570_PIN_AND_FNC(TMS570_BALL_E17, 4)

#define TMS570_BALL_H16 TMS570_BALL_WITH_MMR(27, 2)
#define TMS570_BALL_H16_MIBSPI5SOMI_2 TMS570_PIN_AND_FNC(TMS570_BALL_H16, 0)
#define TMS570_BALL_H16_DMM_DATA_14 TMS570_PIN_AND_FNC(TMS570_BALL_H16, 1)
#define TMS570_BALL_H16_AD1EXT_SEL_04 TMS570_PIN_AND_FNC(TMS570_BALL_H16, 4)

#define TMS570_BALL_G16 TMS570_BALL_WITH_MMR(27, 3)
#define TMS570_BALL_G16_MIBSPI5SOMI_3 TMS570_PIN_AND_FNC(TMS570_BALL_G16, 0)
#define TMS570_BALL_G16_DMM_DATA_15 TMS570_PIN_AND_FNC(TMS570_BALL_G16, 1)
#define TMS570_BALL_G16_I2C2_SCL TMS570_PIN_AND_FNC(TMS570_BALL_G16, 2)
#define TMS570_BALL_G16_EXT_ENA TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_G16, 4), \
                TMS570_PIN_AND_FNC(TMS570_BALL_V8, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_K18 TMS570_BALL_WITH_MMR(28, 0)
#define TMS570_BALL_K18_HET1_00 TMS570_PIN_AND_FNC(TMS570_BALL_K18, 0)
#define TMS570_BALL_K18_MIBSPI4CLK TMS570_PIN_AND_FNC(TMS570_BALL_K18, 1)
#define TMS570_BALL_K18_ePWM2B TMS570_PIN_AND_FNC(TMS570_BALL_K18, 5)

#define TMS570_BALL_V2 TMS570_BALL_WITH_MMR(28, 1)
#define TMS570_BALL_V2_HET1_01 TMS570_PIN_AND_FNC(TMS570_BALL_V2, 0)
#define TMS570_BALL_V2_MIBSPI4NENA TMS570_PIN_AND_FNC(TMS570_BALL_V2, 1)
#define TMS570_BALL_V2_HET2_08 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V2, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_08, 1))
#define TMS570_BALL_V2_eQEP2A TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V2, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP2A, 1))

#define TMS570_BALL_W5 TMS570_BALL_WITH_MMR(28, 2)
#define TMS570_BALL_W5_HET1_02 TMS570_PIN_AND_FNC(TMS570_BALL_W5, 0)
#define TMS570_BALL_W5_MIBSPI4SIMO TMS570_PIN_AND_FNC(TMS570_BALL_W5, 1)
#define TMS570_BALL_W5_ePWM3A TMS570_PIN_AND_FNC(TMS570_BALL_W5, 5)

#define TMS570_BALL_U1 TMS570_BALL_WITH_MMR(28, 3)
#define TMS570_BALL_U1_HET1_03 TMS570_PIN_AND_FNC(TMS570_BALL_U1, 0)
#define TMS570_BALL_U1_MIBSPI4NCS_0 TMS570_PIN_AND_FNC(TMS570_BALL_U1, 1)
#define TMS570_BALL_U1_HET2_10 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_U1, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_10, 1))
#define TMS570_BALL_U1_eQEP2B TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_U1, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP2B, 1))

#define TMS570_BALL_B12 TMS570_BALL_WITH_MMR(29, 0)
#define TMS570_BALL_B12_HET1_04 TMS570_PIN_AND_FNC(TMS570_BALL_B12, 0)
#define TMS570_BALL_B12_MIBSPI4NCS_1 TMS570_PIN_AND_FNC(TMS570_BALL_B12, 1)
#define TMS570_BALL_B12_ePWM4B TMS570_PIN_AND_FNC(TMS570_BALL_B12, 5)

#define TMS570_BALL_V6 TMS570_BALL_WITH_MMR(29, 1)
#define TMS570_BALL_V6_HET1_05 TMS570_PIN_AND_FNC(TMS570_BALL_V6, 0)
#define TMS570_BALL_V6_MIBSPI4SOMI TMS570_PIN_AND_FNC(TMS570_BALL_V6, 1)
#define TMS570_BALL_V6_HET2_12 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V6, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_12, 1))
#define TMS570_BALL_V6_ePWM3B TMS570_PIN_AND_FNC(TMS570_BALL_V6, 5)

#define TMS570_BALL_W3 TMS570_BALL_WITH_MMR(29, 2)
#define TMS570_BALL_W3_HET1_06 TMS570_PIN_AND_FNC(TMS570_BALL_W3, 0)
#define TMS570_BALL_W3_SCI3RX TMS570_PIN_AND_FNC(TMS570_BALL_W3, 1)
#define TMS570_BALL_W3_ePWM5A TMS570_PIN_AND_FNC(TMS570_BALL_W3, 5)

#define TMS570_BALL_T1 TMS570_BALL_WITH_MMR(29, 3)
#define TMS570_BALL_T1_HET1_07 TMS570_PIN_AND_FNC(TMS570_BALL_T1, 0)
#define TMS570_BALL_T1_MIBSPI4NCS_2 TMS570_PIN_AND_FNC(TMS570_BALL_T1, 1)
#define TMS570_BALL_T1_HET2_14 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_T1, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_14, 1))
#define TMS570_BALL_T1_ePWM7B TMS570_PIN_AND_FNC(TMS570_BALL_T1, 5)

#define TMS570_BALL_E18 TMS570_BALL_WITH_MMR(30, 0)
#define TMS570_BALL_E18_HET1_08 TMS570_PIN_AND_FNC(TMS570_BALL_E18, 0)
#define TMS570_BALL_E18_MIBSPI1SIMO_1 TMS570_PIN_AND_FNC(TMS570_BALL_E18, 1)
#define TMS570_BALL_E18_MII_TXD_3 TMS570_PIN_AND_FNC(TMS570_BALL_E18, 2)

#define TMS570_BALL_V7 TMS570_BALL_WITH_MMR(30, 1)
#define TMS570_BALL_V7_HET1_09 TMS570_PIN_AND_FNC(TMS570_BALL_V7, 0)
#define TMS570_BALL_V7_MIBSPI4NCS_3 TMS570_PIN_AND_FNC(TMS570_BALL_V7, 1)
#define TMS570_BALL_V7_HET2_16 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_V7, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_16, 1))
#define TMS570_BALL_V7_ePWM7A TMS570_PIN_AND_FNC(TMS570_BALL_V7, 5)

#define TMS570_BALL_D19 TMS570_BALL_WITH_MMR(30, 2)
#define TMS570_BALL_D19_HET1_10 TMS570_PIN_AND_FNC(TMS570_BALL_D19, 0)
#define TMS570_BALL_D19_MIBSPI4NCS_4 TMS570_PIN_AND_FNC(TMS570_BALL_D19, 1)
#define TMS570_BALL_D19_MII_TX_CLK TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D19, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_TX_CLK, 1))
#define TMS570_BALL_D19_nTZ1_3 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D19, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_nTZ1_3, 1))

#define TMS570_BALL_E3 TMS570_BALL_WITH_MMR(30, 3)
#define TMS570_BALL_E3_HET1_11 TMS570_PIN_AND_FNC(TMS570_BALL_E3, 0)
#define TMS570_BALL_E3_MIBSPI3NCS_4 TMS570_PIN_AND_FNC(TMS570_BALL_E3, 1)
#define TMS570_BALL_E3_HET2_18 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E3, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_18, 1))
#define TMS570_BALL_E3_EPWM1SYNCO TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E3, 5), \
                TMS570_PIN_AND_FNC(TMS570_BALL_A4, 5) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_B4 TMS570_BALL_WITH_MMR(31, 0)
#define TMS570_BALL_B4_HET1_12 TMS570_PIN_AND_FNC(TMS570_BALL_B4, 0)
#define TMS570_BALL_B4_MIBSPI4NCS_5 TMS570_PIN_AND_FNC(TMS570_BALL_B4, 1)
#define TMS570_BALL_B4_MII_CRS TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B4, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_CRS, 1))
#define TMS570_BALL_B4_RMII_CRS_DV TMS570_PIN_AND_FNC(TMS570_BALL_B4, 3)

#define TMS570_BALL_N2 TMS570_BALL_WITH_MMR(31, 1)
#define TMS570_BALL_N2_HET1_13 TMS570_PIN_AND_FNC(TMS570_BALL_N2, 0)
#define TMS570_BALL_N2_SCI3TX TMS570_PIN_AND_FNC(TMS570_BALL_N2, 1)
#define TMS570_BALL_N2_HET2_20 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N2, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_20, 1))
#define TMS570_BALL_N2_ePWM5B TMS570_PIN_AND_FNC(TMS570_BALL_N2, 5)

#define TMS570_BALL_N1 TMS570_BALL_WITH_MMR(31, 2)
#define TMS570_BALL_N1_HET1_15 TMS570_PIN_AND_FNC(TMS570_BALL_N1, 0)
#define TMS570_BALL_N1_MIBSPI1NCS_4 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N1, 1), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MIBSPI1NCS_4, 1))
#define TMS570_BALL_N1_HET2_22 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N1, 3), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_22, 1))
#define TMS570_BALL_N1_ECAP1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N1, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_ECAP1, 1))

#define TMS570_BALL_A4 TMS570_BALL_WITH_MMR(31, 3)
#define TMS570_BALL_A4_HET1_16 TMS570_PIN_AND_FNC(TMS570_BALL_A4, 0)
#define TMS570_BALL_A4_EPWM1SYNCI TMS570_PIN_AND_FNC(TMS570_BALL_A4, 3)
#define TMS570_BALL_A4_EPWM1SYNCO TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_A4, 5), \
                TMS570_PIN_AND_FNC(TMS570_BALL_E3, 5) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_A13 TMS570_BALL_WITH_MMR(32, 0)
#define TMS570_BALL_A13_HET1_17 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_A13, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_17, 0))
#define TMS570_BALL_A13_EMIF_nOE TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_A13, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_E12, 1) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_A13_SCI4RX TMS570_PIN_AND_FNC(TMS570_BALL_A13, 2)

#define TMS570_BALL_J1 TMS570_BALL_WITH_MMR(32, 1)
#define TMS570_BALL_J1_HET1_18 TMS570_PIN_AND_FNC(TMS570_BALL_J1, 0)
#define TMS570_BALL_J1_EMIF_RNW TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_J1, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_D17, 1) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_J1_ePWM6A TMS570_PIN_AND_FNC(TMS570_BALL_J1, 5)

#define TMS570_BALL_B13 TMS570_BALL_WITH_MMR(32, 2)
#define TMS570_BALL_B13_HET1_19 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B13, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_19, 0))
#define TMS570_BALL_B13_EMIF_nDQM_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B13, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_E10, 1) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_B13_SCI4TX TMS570_PIN_AND_FNC(TMS570_BALL_B13, 2)

#define TMS570_BALL_P2 TMS570_BALL_WITH_MMR(32, 3)
#define TMS570_BALL_P2_HET1_20 TMS570_PIN_AND_FNC(TMS570_BALL_P2, 0)
#define TMS570_BALL_P2_EMIF_nDQM_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_P2, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_E11, 1) | TMS570_PIN_CLEAR_RQ_MASK)
#define TMS570_BALL_P2_ePWM6B TMS570_PIN_AND_FNC(TMS570_BALL_P2, 5)

#define TMS570_BALL_H4 TMS570_BALL_WITH_MMR(33, 0)
#define TMS570_BALL_H4_HET1_21 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_H4, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_21, 0))
#define TMS570_BALL_H4_EMIF_nDQM_2 TMS570_PIN_AND_FNC(TMS570_BALL_H4, 1)

#define TMS570_BALL_B3 TMS570_BALL_WITH_MMR(33, 1)
#define TMS570_BALL_B3_HET1_22 TMS570_PIN_AND_FNC(TMS570_BALL_B3, 0)
#define TMS570_BALL_B3_EMIF_nDQM_3 TMS570_PIN_AND_FNC(TMS570_BALL_B3, 1)

#define TMS570_BALL_J4 TMS570_BALL_WITH_MMR(33, 2)
#define TMS570_BALL_J4_HET1_23 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_J4, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET1_23, 0))
#define TMS570_BALL_J4_EMIF_BA_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_J4, 1), \
                TMS570_PIN_AND_FNC(TMS570_BALL_E13, 1) | TMS570_PIN_CLEAR_RQ_MASK)

#define TMS570_BALL_P1 TMS570_BALL_WITH_MMR(33, 3)
#define TMS570_BALL_P1_HET1_24 TMS570_PIN_AND_FNC(TMS570_BALL_P1, 0)
#define TMS570_BALL_P1_MIBSPI1NCS_5 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_P1, 1), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MIBSPI1NCS_5, 1))
#define TMS570_BALL_P1_MII_RXD_0 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_P1, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RXD_0, 1))
#define TMS570_BALL_P1_RMII_RXD_0 TMS570_PIN_AND_FNC(TMS570_BALL_P1, 3)

#define TMS570_BALL_A14 TMS570_BALL_WITH_MMR(34, 0)
#define TMS570_BALL_A14_HET1_26 TMS570_PIN_AND_FNC(TMS570_BALL_A14, 0)
#define TMS570_BALL_A14_MII_RXD_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_A14, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RXD_1, 1))
#define TMS570_BALL_A14_RMII_RXD_1 TMS570_PIN_AND_FNC(TMS570_BALL_A14, 3)

#define TMS570_BALL_K19 TMS570_BALL_WITH_MMR(34, 1)
#define TMS570_BALL_K19_HET1_28 TMS570_PIN_AND_FNC(TMS570_BALL_K19, 0)
#define TMS570_BALL_K19_MII_RXCLK TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_K19, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RXCLK, 1))
#define TMS570_BALL_K19_RMII_REFCLK TMS570_PIN_AND_FNC(TMS570_BALL_K19, 3)

#define TMS570_BALL_B11 TMS570_BALL_WITH_MMR(34, 2)
#define TMS570_BALL_B11_HET1_30 TMS570_PIN_AND_FNC(TMS570_BALL_B11, 0)
#define TMS570_BALL_B11_MII_RX_DV TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B11, 2), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RX_DV, 1))
#define TMS570_BALL_B11_eQEP2S TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_B11, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_eQEP2S, 1))

/// (TM) TODO: is this correct? LS3137ZWT uses TMS570_PIN_AND_FNC(TMS570_BALL_WITH_MMR(29, 3), 0)
///   Per the schematic, this pin (called MII_RX_DV / RX_DV) attaches to pad B11 and can select
///   between MII and RMII mode for the PHY. A pin like this is required for the lwip tms570 rtems port
#define TMS570_MMR_SELECT_GMII_SEL TMS570_BALL_B11_MII_RX_DV

#define TMS570_BALL_D8 TMS570_BALL_WITH_MMR(34, 3)
#define TMS570_BALL_D8_HET2_01 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D8, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_01, 0))

#define TMS570_BALL_D7 TMS570_BALL_WITH_MMR(35, 0)
#define TMS570_BALL_D7_HET2_02 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D7, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_02, 0))

#define TMS570_BALL_D3 TMS570_BALL_WITH_MMR(35, 1)
#define TMS570_BALL_D3_HET2_12 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D3, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_12, 0))
#define TMS570_BALL_D3_MIBSPI2NENA TMS570_PIN_AND_FNC(TMS570_BALL_D3, 4)
#define TMS570_BALL_D3_MIBSPI2NCS_1 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D3, 5), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MIBSPI2NCS_1, 1))

#define TMS570_BALL_D2 TMS570_BALL_WITH_MMR(35, 2)
#define TMS570_BALL_D2_HET2_13 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D2, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_13, 0))
#define TMS570_BALL_D2_MIBSPI2SOMI TMS570_PIN_AND_FNC(TMS570_BALL_D2, 4)

#define TMS570_BALL_D1 TMS570_BALL_WITH_MMR(35, 3)
#define TMS570_BALL_D1_HET2_14 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_D1, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_14, 0))
#define TMS570_BALL_D1_MIBSPI2SIMO TMS570_PIN_AND_FNC(TMS570_BALL_D1, 4)

#define TMS570_BALL_P4 TMS570_BALL_WITH_MMR(36, 0)
#define TMS570_BALL_P4_HET2_19 TMS570_PIN_AND_FNC(TMS570_BALL_P4, 0)
#define TMS570_BALL_P4_LIN2RX TMS570_PIN_AND_FNC(TMS570_BALL_P4, 1)

#define TMS570_BALL_T5 TMS570_BALL_WITH_MMR(36, 1)
#define TMS570_BALL_T5_HET2_20 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_T5, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_20, 0))
#define TMS570_BALL_T5_LIN2TX TMS570_PIN_AND_FNC(TMS570_BALL_T5, 1)

#define TMS570_BALL_T4 TMS570_BALL_WITH_MMR(36, 2)
#define TMS570_BALL_T4_MII_RXCLK TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_T4, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_RXCLK, 0))

#define TMS570_BALL_U7 TMS570_BALL_WITH_MMR(36, 3)
#define TMS570_BALL_U7_MII_TX_CLK TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_U7, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_MII_TX_CLK, 0))

#define TMS570_BALL_E2 TMS570_BALL_WITH_MMR(37, 0)
#define TMS570_BALL_E2_HET2_03 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_E2, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_03, 0))
#define TMS570_BALL_E2_MIBSPI2CLK TMS570_PIN_AND_FNC(TMS570_BALL_E2, 4)

#define TMS570_BALL_N3 TMS570_BALL_WITH_MMR(37, 1)
#define TMS570_BALL_N3_HET2_07 TMS570_PIN_WITH_IN_ALT( \
                TMS570_PIN_AND_FNC(TMS570_BALL_N3, 0), \
                TMS570_PIN_AND_FNC(TMS570_PIN_MMR_ALT_HET2_07, 0))
#define TMS570_BALL_N3_MIBSPI2NCS_0 TMS570_PIN_AND_FNC(TMS570_BALL_N3, 4)

#define TMS570_MMR_SELECT_MII_MODE \
  TMS570_PIN_AND_FNC(TMS570_BALL_WITH_MMR(160, 3), TMS570_PIN_FNC_CLEAR)
#define TMS570_MMR_SELECT_RMII_MODE \
  TMS570_PIN_AND_FNC(TMS570_BALL_WITH_MMR(160, 3), 0)

/* Default pinmux select */

#define TMS570LC4357_PINMMR_DEFAULT_INIT_LIST(per_pin_action, common_arg) \
  per_pin_action(common_arg, TMS570_BALL_D4_EMIF_ADDR_00) \
  per_pin_action(common_arg, TMS570_BALL_D5_EMIF_ADDR_01) \
  per_pin_action(common_arg, TMS570_BALL_C4_EMIF_ADDR_06) \
  per_pin_action(common_arg, TMS570_BALL_C5_EMIF_ADDR_07) \
  per_pin_action(common_arg, TMS570_BALL_C6_EMIF_ADDR_08) \
  per_pin_action(common_arg, TMS570_BALL_C7_EMIF_ADDR_09) \
  per_pin_action(common_arg, TMS570_BALL_C8_EMIF_ADDR_10) \
  per_pin_action(common_arg, TMS570_BALL_C9_EMIF_ADDR_11) \
  per_pin_action(common_arg, TMS570_BALL_C10_EMIF_ADDR_12) \
  per_pin_action(common_arg, TMS570_BALL_C11_EMIF_ADDR_13) \
  per_pin_action(common_arg, TMS570_BALL_C12_EMIF_ADDR_14) \
  per_pin_action(common_arg, TMS570_BALL_C13_EMIF_ADDR_15) \
  per_pin_action(common_arg, TMS570_BALL_D14_EMIF_ADDR_16) \
  per_pin_action(common_arg, TMS570_BALL_C14_EMIF_ADDR_17) \
  per_pin_action(common_arg, TMS570_BALL_D15_EMIF_ADDR_18) \
  per_pin_action(common_arg, TMS570_BALL_C15_EMIF_ADDR_19) \
  per_pin_action(common_arg, TMS570_BALL_C16_EMIF_ADDR_20) \
  per_pin_action(common_arg, TMS570_BALL_C17_EMIF_ADDR_21) \
  per_pin_action(common_arg, TMS570_BALL_D16_EMIF_BA_1) \
  per_pin_action(common_arg, TMS570_BALL_R4_EMIF_nCAS) \
  per_pin_action(common_arg, TMS570_BALL_N17_EMIF_nCS_0) \
  per_pin_action(common_arg, TMS570_BALL_L17_EMIF_nCS_2) \
  per_pin_action(common_arg, TMS570_BALL_K17_EMIF_nCS_3) \
  per_pin_action(common_arg, TMS570_BALL_M17_EMIF_nCSl_4) \
  per_pin_action(common_arg, TMS570_BALL_R3_EMIF_nRAS) \
  per_pin_action(common_arg, TMS570_BALL_P3_EMIF_nWAIT) \
  per_pin_action(common_arg, TMS570_BALL_D17_EMIF_nWE) \
  per_pin_action(common_arg, TMS570_BALL_E9_EMIF_ADDR_05) \
  per_pin_action(common_arg, TMS570_BALL_E8_EMIF_ADDR_04) \
  per_pin_action(common_arg, TMS570_BALL_E7_EMIF_ADDR_03) \
  per_pin_action(common_arg, TMS570_BALL_E6_EMIF_ADDR_02) \
  per_pin_action(common_arg, TMS570_BALL_E13_EMIF_BA_0) \
  per_pin_action(common_arg, TMS570_BALL_E12_EMIF_nOE) \
  per_pin_action(common_arg, TMS570_BALL_E11_EMIF_nDQM_1) \
  per_pin_action(common_arg, TMS570_BALL_E10_EMIF_nDQM_0) \
  per_pin_action(common_arg, TMS570_BALL_K15_EMIF_DATA_00) \
  per_pin_action(common_arg, TMS570_BALL_L15_EMIF_DATA_01) \
  per_pin_action(common_arg, TMS570_BALL_M15_EMIF_DATA_02) \
  per_pin_action(common_arg, TMS570_BALL_N15_EMIF_DATA_03) \
  per_pin_action(common_arg, TMS570_BALL_E5_EMIF_DATA_04) \
  per_pin_action(common_arg, TMS570_BALL_F5_EMIF_DATA_05) \
  per_pin_action(common_arg, TMS570_BALL_G5_EMIF_DATA_06) \
  per_pin_action(common_arg, TMS570_BALL_K5_EMIF_DATA_07) \
  per_pin_action(common_arg, TMS570_BALL_L5_EMIF_DATA_08) \
  per_pin_action(common_arg, TMS570_BALL_M5_EMIF_DATA_09) \
  per_pin_action(common_arg, TMS570_BALL_N5_EMIF_DATA_10) \
  per_pin_action(common_arg, TMS570_BALL_P5_EMIF_DATA_11) \
  per_pin_action(common_arg, TMS570_BALL_R5_EMIF_DATA_12) \
  per_pin_action(common_arg, TMS570_BALL_R6_EMIF_DATA_13) \
  per_pin_action(common_arg, TMS570_BALL_R7_EMIF_DATA_14) \
  per_pin_action(common_arg, TMS570_BALL_R8_EMIF_DATA_15) \
  per_pin_action(common_arg, TMS570_BALL_R9_ETMTRACECLKIN) \
  per_pin_action(common_arg, TMS570_BALL_R10_ETMTRACECLKOUT) \
  per_pin_action(common_arg, TMS570_BALL_R11_ETMTRACECTL) \
  per_pin_action(common_arg, TMS570_BALL_B15_FRAYTX1) \
  per_pin_action(common_arg, TMS570_BALL_B8_FRAYTX2) \
  per_pin_action(common_arg, TMS570_BALL_B16_FRAYTXEN1) \
  per_pin_action(common_arg, TMS570_BALL_B9_FRAYTXEN2) \
  per_pin_action(common_arg, TMS570_BALL_C1_GIOA_2) \
  per_pin_action(common_arg, TMS570_BALL_E1_GIOA_3) \
  per_pin_action(common_arg, TMS570_BALL_B5_GIOA_5) \
  per_pin_action(common_arg, TMS570_BALL_H3_GIOA_6) \
  per_pin_action(common_arg, TMS570_BALL_M1_GIOA_7) \
  per_pin_action(common_arg, TMS570_BALL_F2_GIOB_2) \
  per_pin_action(common_arg, TMS570_BALL_W10_GIOB_3) \
  per_pin_action(common_arg, TMS570_BALL_J2_GIOB_6) \
  per_pin_action(common_arg, TMS570_BALL_F1_GIOB_7) \
  per_pin_action(common_arg, TMS570_BALL_R2_MIBSPI1NCS_0) \
  per_pin_action(common_arg, TMS570_BALL_F3_MIBSPI1NCS_1) \
  per_pin_action(common_arg, TMS570_BALL_G3_MIBSPI1NCS_2) \
  per_pin_action(common_arg, TMS570_BALL_J3_MIBSPI1NCS_3) \
  per_pin_action(common_arg, TMS570_BALL_G19_MIBSPI1NENA) \
  per_pin_action(common_arg, TMS570_BALL_V9_MIBSPI3CLK) \
  per_pin_action(common_arg, TMS570_BALL_V10_MIBSPI3NCS_0) \
  per_pin_action(common_arg, TMS570_BALL_V5_MIBSPI3NCS_1) \
  per_pin_action(common_arg, TMS570_BALL_B2_MIBSPI3NCS_2) \
  per_pin_action(common_arg, TMS570_BALL_C3_MIBSPI3NCS_3) \
  per_pin_action(common_arg, TMS570_BALL_W9_MIBSPI3NENA) \
  per_pin_action(common_arg, TMS570_BALL_W8_MIBSPI3SIMO) \
  per_pin_action(common_arg, TMS570_BALL_V8_MIBSPI3SOMI) \
  per_pin_action(common_arg, TMS570_BALL_H19_MIBSPI5CLK) \
  per_pin_action(common_arg, TMS570_BALL_E19_MIBSPI5NCS_0) \
  per_pin_action(common_arg, TMS570_BALL_B6_MIBSPI5NCS_1) \
  per_pin_action(common_arg, TMS570_BALL_W6_MIBSPI5NCS_2) \
  per_pin_action(common_arg, TMS570_BALL_T12_MIBSPI5NCS_3) \
  per_pin_action(common_arg, TMS570_BALL_H18_MIBSPI5NENA) \
  per_pin_action(common_arg, TMS570_BALL_J19_MIBSPI5SIMO_0) \
  per_pin_action(common_arg, TMS570_BALL_E16_MIBSPI5SIMO_1) \
  per_pin_action(common_arg, TMS570_BALL_H17_MIBSPI5SIMO_2) \
  per_pin_action(common_arg, TMS570_BALL_G17_MIBSPI5SIMO_3) \
  per_pin_action(common_arg, TMS570_BALL_J18_MIBSPI5SOMI_0) \
  per_pin_action(common_arg, TMS570_BALL_E17_MIBSPI5SOMI_1) \
  per_pin_action(common_arg, TMS570_BALL_H16_MIBSPI5SOMI_2) \
  per_pin_action(common_arg, TMS570_BALL_G16_MIBSPI5SOMI_3) \
  per_pin_action(common_arg, TMS570_BALL_K18_HET1_00) \
  per_pin_action(common_arg, TMS570_BALL_V2_HET1_01) \
  per_pin_action(common_arg, TMS570_BALL_W5_HET1_02) \
  per_pin_action(common_arg, TMS570_BALL_U1_HET1_03) \
  per_pin_action(common_arg, TMS570_BALL_B12_HET1_04) \
  per_pin_action(common_arg, TMS570_BALL_V6_HET1_05) \
  per_pin_action(common_arg, TMS570_BALL_W3_HET1_06) \
  per_pin_action(common_arg, TMS570_BALL_T1_HET1_07) \
  per_pin_action(common_arg, TMS570_BALL_E18_HET1_08) \
  per_pin_action(common_arg, TMS570_BALL_V7_HET1_09) \
  per_pin_action(common_arg, TMS570_BALL_D19_HET1_10) \
  per_pin_action(common_arg, TMS570_BALL_E3_HET1_11) \
  per_pin_action(common_arg, TMS570_BALL_B4_HET1_12) \
  per_pin_action(common_arg, TMS570_BALL_N2_HET1_13) \
  per_pin_action(common_arg, TMS570_BALL_N1_HET1_15) \
  per_pin_action(common_arg, TMS570_BALL_A4_HET1_16) \
  per_pin_action(common_arg, TMS570_BALL_A13_HET1_17) \
  per_pin_action(common_arg, TMS570_BALL_J1_HET1_18) \
  per_pin_action(common_arg, TMS570_BALL_B13_HET1_19) \
  per_pin_action(common_arg, TMS570_BALL_P2_HET1_20) \
  per_pin_action(common_arg, TMS570_BALL_H4_HET1_21) \
  per_pin_action(common_arg, TMS570_BALL_B3_HET1_22) \
  per_pin_action(common_arg, TMS570_BALL_J4_HET1_23) \
  per_pin_action(common_arg, TMS570_BALL_P1_HET1_24) \
  per_pin_action(common_arg, TMS570_BALL_A14_HET1_26) \
  per_pin_action(common_arg, TMS570_BALL_K19_HET1_28) \
  per_pin_action(common_arg, TMS570_BALL_B11_HET1_30) \
  per_pin_action(common_arg, TMS570_BALL_D8_HET2_01) \
  per_pin_action(common_arg, TMS570_BALL_D7_HET2_02) \
  per_pin_action(common_arg, TMS570_BALL_D3_HET2_12) \
  per_pin_action(common_arg, TMS570_BALL_D2_HET2_13) \
  per_pin_action(common_arg, TMS570_BALL_D1_HET2_14) \
  per_pin_action(common_arg, TMS570_BALL_P4_HET2_19) \
  per_pin_action(common_arg, TMS570_BALL_T5_HET2_20) \
  per_pin_action(common_arg, TMS570_BALL_T4_MII_RXCLK) \
  per_pin_action(common_arg, TMS570_BALL_U7_MII_TX_CLK) \
  per_pin_action(common_arg, TMS570_BALL_E2_HET2_03) \
  per_pin_action(common_arg, TMS570_BALL_N3_HET2_07) \
  per_pin_action(common_arg, TMS570_BALL_K3_EMIF_CLK) \
  per_pin_action(common_arg, TMS570_BALL_N19_MII_RX_ER) \
  per_pin_action(common_arg, TMS570_BALL_F3_MII_COL) \
  per_pin_action(common_arg, TMS570_BALL_E18_MII_TXD_3) \
  per_pin_action(common_arg, TMS570_BALL_R2_MII_TXD_2) \
  per_pin_action(common_arg, TMS570_BALL_J19_MII_TXD_1) \
  per_pin_action(common_arg, TMS570_BALL_J18_MII_TXD_0) \
  per_pin_action(common_arg, TMS570_BALL_H19_MII_TXEN) \
  per_pin_action(common_arg, TMS570_BALL_D19_MII_TX_CLK) \
  per_pin_action(common_arg, TMS570_BALL_B4_MII_CRS) \
  per_pin_action(common_arg, TMS570_BALL_K19_MII_RXCLK) \
  per_pin_action(common_arg, TMS570_BALL_H18_MII_RXD_3) \
  per_pin_action(common_arg, TMS570_BALL_G19_MII_RXD_2) \
  per_pin_action(common_arg, TMS570_BALL_A14_MII_RXD_1) \
  per_pin_action(common_arg, TMS570_BALL_P1_MII_RXD_0) \
  per_pin_action(common_arg, TMS570_BALL_B11_MII_RX_DV) \
  per_pin_action(common_arg, TMS570_BALL_G3_MDIO) \
  per_pin_action(common_arg, TMS570_BALL_V5_MDCLK)

/* End of default PINMMR list */

// Note EMIF Clock enable (EMIF_CKE) on Ball L3 has no alternate functions and is enabled by default

#endif /*LIBBSP_ARM_TMS570_TMS570LC4357_PINS_H*/
