/*
 * QEMU model of the PSM_GLOBAL_REG This is the database for the PSM Error Management Register Definitions.
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2022-01-13.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_PSM_GLOBAL_REG_ERR_DEBUG
#define XILINX_PSM_GLOBAL_REG_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSM_GLOBAL_REG "xlnx.psm-err-mng"

#define XILINX_PSM_GLOBAL_REG(obj) \
     OBJECT_CHECK(PSM_GLOBAL_REG, (obj), TYPE_XILINX_PSM_GLOBAL_REG)

REG32(PSM_ERR1_STATUS, 0x0)
    FIELD(PSM_ERR1_STATUS, RSRV_ERR6, 31, 1)
    FIELD(PSM_ERR1_STATUS, RSRV_ERR5, 30, 1)
    FIELD(PSM_ERR1_STATUS, RSRV_ERR4, 29, 1)
    FIELD(PSM_ERR1_STATUS, RSRV_ERR3, 28, 1)
    FIELD(PSM_ERR1_STATUS, RSRV_ERR2, 27, 1)
    FIELD(PSM_ERR1_STATUS, PSM_TO, 26, 1)
    FIELD(PSM_ERR1_STATUS, FPD_TO, 25, 1)
    FIELD(PSM_ERR1_STATUS, LPD_TO, 24, 1)
    FIELD(PSM_ERR1_STATUS, PSM_PAR, 23, 1)
    FIELD(PSM_ERR1_STATUS, IOU_PAR, 22, 1)
    FIELD(PSM_ERR1_STATUS, FPD_PAR, 21, 1)
    FIELD(PSM_ERR1_STATUS, LPD_PAR, 20, 1)
    FIELD(PSM_ERR1_STATUS, FPD_APB, 19, 1)
    FIELD(PSM_ERR1_STATUS, LPD_APB, 18, 1)
    FIELD(PSM_ERR1_STATUS, CPM_NCR, 17, 1)
    FIELD(PSM_ERR1_STATUS, CPM_CR, 16, 1)
    FIELD(PSM_ERR1_STATUS, RPLL_LOCK, 15, 1)
    FIELD(PSM_ERR1_STATUS, APLL_LOCK, 14, 1)
    FIELD(PSM_ERR1_STATUS, GIC_ECC, 13, 1)
    FIELD(PSM_ERR1_STATUS, GIC_AXI, 12, 1)
    FIELD(PSM_ERR1_STATUS, RPU_CCF, 11, 1)
    FIELD(PSM_ERR1_STATUS, RPU_LS, 10, 1)
    FIELD(PSM_ERR1_STATUS, RPU_ECC, 9, 1)
    FIELD(PSM_ERR1_STATUS, L2_ECC, 8, 1)
    FIELD(PSM_ERR1_STATUS, OCM_ECC, 7, 1)
    FIELD(PSM_ERR1_STATUS, PSM_NCR, 6, 1)
    FIELD(PSM_ERR1_STATUS, PSM_CR, 5, 1)
    FIELD(PSM_ERR1_STATUS, MB_FATAL, 4, 1)
    FIELD(PSM_ERR1_STATUS, PSM_B_NCR, 3, 1)
    FIELD(PSM_ERR1_STATUS, PSM_B_CR, 2, 1)
    FIELD(PSM_ERR1_STATUS, PS_SW_NCR, 1, 1)
    FIELD(PSM_ERR1_STATUS, PS_SW_CR, 0, 1)
REG32(PSM_ERR2_STATUS, 0x4)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR9, 31, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR8, 30, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR7, 29, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR6, 28, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR5, 27, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR4, 26, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR3, 25, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR2, 24, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR1, 23, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR10, 22, 1)
    FIELD(PSM_ERR2_STATUS, RSRV_ERR0, 21, 1)
    FIELD(PSM_ERR2_STATUS, FPD_XMPU, 20, 1)
    FIELD(PSM_ERR2_STATUS, LPD_XPPU, 19, 1)
    FIELD(PSM_ERR2_STATUS, LPD_XMPU, 18, 1)
    FIELD(PSM_ERR2_STATUS, FPD_SWDT, 1, 1)
    FIELD(PSM_ERR2_STATUS, LPD_SWDT, 0, 1)
REG32(PSM_ERR1_TRIG, 0x10)
    FIELD(PSM_ERR1_TRIG, RSRV_ERR6, 31, 1)
    FIELD(PSM_ERR1_TRIG, RSRV_ERR5, 30, 1)
    FIELD(PSM_ERR1_TRIG, RSRV_ERR4, 29, 1)
    FIELD(PSM_ERR1_TRIG, RSRV_ERR3, 28, 1)
    FIELD(PSM_ERR1_TRIG, RSRV_ERR2, 27, 1)
    FIELD(PSM_ERR1_TRIG, PSM_TO, 26, 1)
    FIELD(PSM_ERR1_TRIG, FPD_TO, 25, 1)
    FIELD(PSM_ERR1_TRIG, LPD_TO, 24, 1)
    FIELD(PSM_ERR1_TRIG, PSM_PAR, 23, 1)
    FIELD(PSM_ERR1_TRIG, IOU_PAR, 22, 1)
    FIELD(PSM_ERR1_TRIG, FPD_PAR, 21, 1)
    FIELD(PSM_ERR1_TRIG, LPD_PAR, 20, 1)
    FIELD(PSM_ERR1_TRIG, FPD_APB, 19, 1)
    FIELD(PSM_ERR1_TRIG, LPD_APB, 18, 1)
    FIELD(PSM_ERR1_TRIG, CPM_NCR, 17, 1)
    FIELD(PSM_ERR1_TRIG, CPM_CR, 16, 1)
    FIELD(PSM_ERR1_TRIG, RPLL_LOCK, 15, 1)
    FIELD(PSM_ERR1_TRIG, APLL_LOCK, 14, 1)
    FIELD(PSM_ERR1_TRIG, GIC_ECC, 13, 1)
    FIELD(PSM_ERR1_TRIG, GIC_AXI, 12, 1)
    FIELD(PSM_ERR1_TRIG, RPU_CCF, 11, 1)
    FIELD(PSM_ERR1_TRIG, RPU_LS, 10, 1)
    FIELD(PSM_ERR1_TRIG, RPU_ECC, 9, 1)
    FIELD(PSM_ERR1_TRIG, L2_ECC, 8, 1)
    FIELD(PSM_ERR1_TRIG, OCM_ECC, 7, 1)
    FIELD(PSM_ERR1_TRIG, PSM_NCR, 6, 1)
    FIELD(PSM_ERR1_TRIG, PSM_CR, 5, 1)
    FIELD(PSM_ERR1_TRIG, MB_FATAL, 4, 1)
    FIELD(PSM_ERR1_TRIG, PSM_B_NCR, 3, 1)
    FIELD(PSM_ERR1_TRIG, PSM_B_CR, 2, 1)
    FIELD(PSM_ERR1_TRIG, PS_SW_NCR, 1, 1)
    FIELD(PSM_ERR1_TRIG, PS_SW_CR, 0, 1)
REG32(PSM_ERR2_TRIG, 0x14)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR9, 31, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR8, 30, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR7, 29, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR6, 28, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR5, 27, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR4, 26, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR3, 25, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR2, 24, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR1, 23, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR10, 22, 1)
    FIELD(PSM_ERR2_TRIG, RSRV_ERR0, 21, 1)
    FIELD(PSM_ERR2_TRIG, FPD_XMPU, 20, 1)
    FIELD(PSM_ERR2_TRIG, LPD_XPPU, 19, 1)
    FIELD(PSM_ERR2_TRIG, LPD_XMPU, 18, 1)
    FIELD(PSM_ERR2_TRIG, FPD_SWDT, 1, 1)
    FIELD(PSM_ERR2_TRIG, LPD_SWDT, 0, 1)
REG32(PSM_CR_ERR1_MASK, 0x20)
    FIELD(PSM_CR_ERR1_MASK, RSRV_ERR6, 31, 1)
    FIELD(PSM_CR_ERR1_MASK, RSRV_ERR5, 30, 1)
    FIELD(PSM_CR_ERR1_MASK, RSRV_ERR4, 29, 1)
    FIELD(PSM_CR_ERR1_MASK, RSRV_ERR3, 28, 1)
    FIELD(PSM_CR_ERR1_MASK, RSRV_ERR2, 27, 1)
    FIELD(PSM_CR_ERR1_MASK, PSM_TO, 26, 1)
    FIELD(PSM_CR_ERR1_MASK, FPD_TO, 25, 1)
    FIELD(PSM_CR_ERR1_MASK, LPD_TO, 24, 1)
    FIELD(PSM_CR_ERR1_MASK, PSM_PAR, 23, 1)
    FIELD(PSM_CR_ERR1_MASK, IOU_PAR, 22, 1)
    FIELD(PSM_CR_ERR1_MASK, FPD_PAR, 21, 1)
    FIELD(PSM_CR_ERR1_MASK, LPD_PAR, 20, 1)
    FIELD(PSM_CR_ERR1_MASK, FPD_APB, 19, 1)
    FIELD(PSM_CR_ERR1_MASK, LPD_APB, 18, 1)
    FIELD(PSM_CR_ERR1_MASK, CPM_NCR, 17, 1)
    FIELD(PSM_CR_ERR1_MASK, CPM_CR, 16, 1)
    FIELD(PSM_CR_ERR1_MASK, RPLL_LOCK, 15, 1)
    FIELD(PSM_CR_ERR1_MASK, APLL_LOCK, 14, 1)
    FIELD(PSM_CR_ERR1_MASK, GIC_ECC, 13, 1)
    FIELD(PSM_CR_ERR1_MASK, GIC_AXI, 12, 1)
    FIELD(PSM_CR_ERR1_MASK, RPU_CCF, 11, 1)
    FIELD(PSM_CR_ERR1_MASK, RPU_LS, 10, 1)
    FIELD(PSM_CR_ERR1_MASK, RPU_ECC, 9, 1)
    FIELD(PSM_CR_ERR1_MASK, L2_ECC, 8, 1)
    FIELD(PSM_CR_ERR1_MASK, OCM_ECC, 7, 1)
    FIELD(PSM_CR_ERR1_MASK, PSM_NCR, 6, 1)
    FIELD(PSM_CR_ERR1_MASK, PSM_CR, 5, 1)
    FIELD(PSM_CR_ERR1_MASK, MB_FATAL, 4, 1)
    FIELD(PSM_CR_ERR1_MASK, PSM_B_NCR, 3, 1)
    FIELD(PSM_CR_ERR1_MASK, PSM_B_CR, 2, 1)
    FIELD(PSM_CR_ERR1_MASK, PS_SW_NCR, 1, 1)
    FIELD(PSM_CR_ERR1_MASK, PS_SW_CR, 0, 1)
REG32(PSM_CR_ERR1_EN, 0x24)
    FIELD(PSM_CR_ERR1_EN, RSRV_ERR6, 31, 1)
    FIELD(PSM_CR_ERR1_EN, RSRV_ERR5, 30, 1)
    FIELD(PSM_CR_ERR1_EN, RSRV_ERR4, 29, 1)
    FIELD(PSM_CR_ERR1_EN, RSRV_ERR3, 28, 1)
    FIELD(PSM_CR_ERR1_EN, RSRV_ERR2, 27, 1)
    FIELD(PSM_CR_ERR1_EN, PSM_TO, 26, 1)
    FIELD(PSM_CR_ERR1_EN, FPD_TO, 25, 1)
    FIELD(PSM_CR_ERR1_EN, LPD_TO, 24, 1)
    FIELD(PSM_CR_ERR1_EN, PSM_PAR, 23, 1)
    FIELD(PSM_CR_ERR1_EN, IOU_PAR, 22, 1)
    FIELD(PSM_CR_ERR1_EN, FPD_PAR, 21, 1)
    FIELD(PSM_CR_ERR1_EN, LPD_PAR, 20, 1)
    FIELD(PSM_CR_ERR1_EN, FPD_APB, 19, 1)
    FIELD(PSM_CR_ERR1_EN, LPD_APB, 18, 1)
    FIELD(PSM_CR_ERR1_EN, CPM_NCR, 17, 1)
    FIELD(PSM_CR_ERR1_EN, CPM_CR, 16, 1)
    FIELD(PSM_CR_ERR1_EN, RPLL_LOCK, 15, 1)
    FIELD(PSM_CR_ERR1_EN, APLL_LOCK, 14, 1)
    FIELD(PSM_CR_ERR1_EN, GIC_ECC, 13, 1)
    FIELD(PSM_CR_ERR1_EN, GIC_AXI, 12, 1)
    FIELD(PSM_CR_ERR1_EN, RPU_CCF, 11, 1)
    FIELD(PSM_CR_ERR1_EN, RPU_LS, 10, 1)
    FIELD(PSM_CR_ERR1_EN, RPU_ECC, 9, 1)
    FIELD(PSM_CR_ERR1_EN, L2_ECC, 8, 1)
    FIELD(PSM_CR_ERR1_EN, OCM_ECC, 7, 1)
    FIELD(PSM_CR_ERR1_EN, PSM_NCR, 6, 1)
    FIELD(PSM_CR_ERR1_EN, PSM_CR, 5, 1)
    FIELD(PSM_CR_ERR1_EN, MB_FATAL, 4, 1)
    FIELD(PSM_CR_ERR1_EN, PSM_B_NCR, 3, 1)
    FIELD(PSM_CR_ERR1_EN, PSM_B_CR, 2, 1)
    FIELD(PSM_CR_ERR1_EN, PS_SW_NCR, 1, 1)
    FIELD(PSM_CR_ERR1_EN, PS_SW_CR, 0, 1)
REG32(PSM_CR_ERR1_DIS, 0x28)
    FIELD(PSM_CR_ERR1_DIS, RSRV_ERR6, 31, 1)
    FIELD(PSM_CR_ERR1_DIS, RSRV_ERR5, 30, 1)
    FIELD(PSM_CR_ERR1_DIS, RSRV_ERR4, 29, 1)
    FIELD(PSM_CR_ERR1_DIS, RSRV_ERR3, 28, 1)
    FIELD(PSM_CR_ERR1_DIS, RSRV_ERR2, 27, 1)
    FIELD(PSM_CR_ERR1_DIS, PSM_TO, 26, 1)
    FIELD(PSM_CR_ERR1_DIS, FPD_TO, 25, 1)
    FIELD(PSM_CR_ERR1_DIS, LPD_TO, 24, 1)
    FIELD(PSM_CR_ERR1_DIS, PSM_PAR, 23, 1)
    FIELD(PSM_CR_ERR1_DIS, IOU_PAR, 22, 1)
    FIELD(PSM_CR_ERR1_DIS, FPD_PAR, 21, 1)
    FIELD(PSM_CR_ERR1_DIS, LPD_PAR, 20, 1)
    FIELD(PSM_CR_ERR1_DIS, FPD_APB, 19, 1)
    FIELD(PSM_CR_ERR1_DIS, LPD_APB, 18, 1)
    FIELD(PSM_CR_ERR1_DIS, CPM_NCR, 17, 1)
    FIELD(PSM_CR_ERR1_DIS, CPM_CR, 16, 1)
    FIELD(PSM_CR_ERR1_DIS, RPLL_LOCK, 15, 1)
    FIELD(PSM_CR_ERR1_DIS, APLL_LOCK, 14, 1)
    FIELD(PSM_CR_ERR1_DIS, GIC_ECC, 13, 1)
    FIELD(PSM_CR_ERR1_DIS, GIC_AXI, 12, 1)
    FIELD(PSM_CR_ERR1_DIS, RPU_CCF, 11, 1)
    FIELD(PSM_CR_ERR1_DIS, RPU_LS, 10, 1)
    FIELD(PSM_CR_ERR1_DIS, RPU_ECC, 9, 1)
    FIELD(PSM_CR_ERR1_DIS, L2_ECC, 8, 1)
    FIELD(PSM_CR_ERR1_DIS, OCM_ECC, 7, 1)
    FIELD(PSM_CR_ERR1_DIS, PSM_NCR, 6, 1)
    FIELD(PSM_CR_ERR1_DIS, PSM_CR, 5, 1)
    FIELD(PSM_CR_ERR1_DIS, MB_FATAL, 4, 1)
    FIELD(PSM_CR_ERR1_DIS, PSM_B_NCR, 3, 1)
    FIELD(PSM_CR_ERR1_DIS, PSM_B_CR, 2, 1)
    FIELD(PSM_CR_ERR1_DIS, PS_SW_NCR, 1, 1)
    FIELD(PSM_CR_ERR1_DIS, PS_SW_CR, 0, 1)
REG32(PSM_CR_ERR2_MASK, 0x30)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR9, 31, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR8, 30, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR7, 29, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR6, 28, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR5, 27, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR4, 26, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR3, 25, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR2, 24, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR1, 23, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR10, 22, 1)
    FIELD(PSM_CR_ERR2_MASK, RSRV_ERR0, 21, 1)
    FIELD(PSM_CR_ERR2_MASK, FPD_XMPU, 20, 1)
    FIELD(PSM_CR_ERR2_MASK, LPD_XPPU, 19, 1)
    FIELD(PSM_CR_ERR2_MASK, LPD_XMPU, 18, 1)
    FIELD(PSM_CR_ERR2_MASK, FPD_SWDT, 1, 1)
    FIELD(PSM_CR_ERR2_MASK, LPD_SWDT, 0, 1)
REG32(PSM_CR_ERR2_EN, 0x34)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR9, 31, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR8, 30, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR7, 29, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR6, 28, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR5, 27, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR4, 26, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR3, 25, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR2, 24, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR1, 23, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR10, 22, 1)
    FIELD(PSM_CR_ERR2_EN, RSRV_ERR0, 21, 1)
    FIELD(PSM_CR_ERR2_EN, FPD_XMPU, 20, 1)
    FIELD(PSM_CR_ERR2_EN, LPD_XPPU, 19, 1)
    FIELD(PSM_CR_ERR2_EN, LPD_XMPU, 18, 1)
    FIELD(PSM_CR_ERR2_EN, FPD_SWDT, 1, 1)
    FIELD(PSM_CR_ERR2_EN, LPD_SWDT, 0, 1)
REG32(PSM_CR_ERR2_DIS, 0x38)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR9, 31, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR8, 30, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR7, 29, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR6, 28, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR5, 27, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR4, 26, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR3, 25, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR2, 24, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR1, 23, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR10, 22, 1)
    FIELD(PSM_CR_ERR2_DIS, RSRV_ERR0, 21, 1)
    FIELD(PSM_CR_ERR2_DIS, FPD_XMPU, 20, 1)
    FIELD(PSM_CR_ERR2_DIS, LPD_XPPU, 19, 1)
    FIELD(PSM_CR_ERR2_DIS, LPD_XMPU, 18, 1)
    FIELD(PSM_CR_ERR2_DIS, FPD_SWDT, 1, 1)
    FIELD(PSM_CR_ERR2_DIS, LPD_SWDT, 0, 1)
REG32(PSM_NCR_ERR1_MASK, 0x40)
    FIELD(PSM_NCR_ERR1_MASK, RSRV_ERR6, 31, 1)
    FIELD(PSM_NCR_ERR1_MASK, RSRV_ERR5, 30, 1)
    FIELD(PSM_NCR_ERR1_MASK, RSRV_ERR4, 29, 1)
    FIELD(PSM_NCR_ERR1_MASK, RSRV_ERR3, 28, 1)
    FIELD(PSM_NCR_ERR1_MASK, RSRV_ERR2, 27, 1)
    FIELD(PSM_NCR_ERR1_MASK, PSM_TO, 26, 1)
    FIELD(PSM_NCR_ERR1_MASK, FPD_TO, 25, 1)
    FIELD(PSM_NCR_ERR1_MASK, LPD_TO, 24, 1)
    FIELD(PSM_NCR_ERR1_MASK, PSM_PAR, 23, 1)
    FIELD(PSM_NCR_ERR1_MASK, IOU_PAR, 22, 1)
    FIELD(PSM_NCR_ERR1_MASK, FPD_PAR, 21, 1)
    FIELD(PSM_NCR_ERR1_MASK, LPD_PAR, 20, 1)
    FIELD(PSM_NCR_ERR1_MASK, FPD_APB, 19, 1)
    FIELD(PSM_NCR_ERR1_MASK, LPD_APB, 18, 1)
    FIELD(PSM_NCR_ERR1_MASK, CPM_NCR, 17, 1)
    FIELD(PSM_NCR_ERR1_MASK, CPM_CR, 16, 1)
    FIELD(PSM_NCR_ERR1_MASK, RPLL_LOCK, 15, 1)
    FIELD(PSM_NCR_ERR1_MASK, APLL_LOCK, 14, 1)
    FIELD(PSM_NCR_ERR1_MASK, GIC_ECC, 13, 1)
    FIELD(PSM_NCR_ERR1_MASK, GIC_AXI, 12, 1)
    FIELD(PSM_NCR_ERR1_MASK, RPU_CCF, 11, 1)
    FIELD(PSM_NCR_ERR1_MASK, RPU_LS, 10, 1)
    FIELD(PSM_NCR_ERR1_MASK, RPU_ECC, 9, 1)
    FIELD(PSM_NCR_ERR1_MASK, L2_ECC, 8, 1)
    FIELD(PSM_NCR_ERR1_MASK, OCM_ECC, 7, 1)
    FIELD(PSM_NCR_ERR1_MASK, PSM_NCR, 6, 1)
    FIELD(PSM_NCR_ERR1_MASK, PSM_CR, 5, 1)
    FIELD(PSM_NCR_ERR1_MASK, MB_FATAL, 4, 1)
    FIELD(PSM_NCR_ERR1_MASK, PSM_B_NCR, 3, 1)
    FIELD(PSM_NCR_ERR1_MASK, PSM_B_CR, 2, 1)
    FIELD(PSM_NCR_ERR1_MASK, PS_SW_NCR, 1, 1)
    FIELD(PSM_NCR_ERR1_MASK, PS_SW_CR, 0, 1)
REG32(PSM_NCR_ERR1_EN, 0x44)
    FIELD(PSM_NCR_ERR1_EN, RSRV_ERR6, 31, 1)
    FIELD(PSM_NCR_ERR1_EN, RSRV_ERR5, 30, 1)
    FIELD(PSM_NCR_ERR1_EN, RSRV_ERR4, 29, 1)
    FIELD(PSM_NCR_ERR1_EN, RSRV_ERR3, 28, 1)
    FIELD(PSM_NCR_ERR1_EN, RSRV_ERR2, 27, 1)
    FIELD(PSM_NCR_ERR1_EN, PSM_TO, 26, 1)
    FIELD(PSM_NCR_ERR1_EN, FPD_TO, 25, 1)
    FIELD(PSM_NCR_ERR1_EN, LPD_TO, 24, 1)
    FIELD(PSM_NCR_ERR1_EN, PSM_PAR, 23, 1)
    FIELD(PSM_NCR_ERR1_EN, IOU_PAR, 22, 1)
    FIELD(PSM_NCR_ERR1_EN, FPD_PAR, 21, 1)
    FIELD(PSM_NCR_ERR1_EN, LPD_PAR, 20, 1)
    FIELD(PSM_NCR_ERR1_EN, FPD_APB, 19, 1)
    FIELD(PSM_NCR_ERR1_EN, LPD_APB, 18, 1)
    FIELD(PSM_NCR_ERR1_EN, CPM_NCR, 17, 1)
    FIELD(PSM_NCR_ERR1_EN, CPM_CR, 16, 1)
    FIELD(PSM_NCR_ERR1_EN, RPLL_LOCK, 15, 1)
    FIELD(PSM_NCR_ERR1_EN, APLL_LOCK, 14, 1)
    FIELD(PSM_NCR_ERR1_EN, GIC_ECC, 13, 1)
    FIELD(PSM_NCR_ERR1_EN, GIC_AXI, 12, 1)
    FIELD(PSM_NCR_ERR1_EN, RPU_CCF, 11, 1)
    FIELD(PSM_NCR_ERR1_EN, RPU_LS, 10, 1)
    FIELD(PSM_NCR_ERR1_EN, RPU_ECC, 9, 1)
    FIELD(PSM_NCR_ERR1_EN, L2_ECC, 8, 1)
    FIELD(PSM_NCR_ERR1_EN, OCM_ECC, 7, 1)
    FIELD(PSM_NCR_ERR1_EN, PSM_NCR, 6, 1)
    FIELD(PSM_NCR_ERR1_EN, PSM_CR, 5, 1)
    FIELD(PSM_NCR_ERR1_EN, MB_FATAL, 4, 1)
    FIELD(PSM_NCR_ERR1_EN, PSM_B_NCR, 3, 1)
    FIELD(PSM_NCR_ERR1_EN, PSM_B_CR, 2, 1)
    FIELD(PSM_NCR_ERR1_EN, PS_SW_NCR, 1, 1)
    FIELD(PSM_NCR_ERR1_EN, PS_SW_CR, 0, 1)
REG32(PSM_NCR_ERR1_DIS, 0x48)
    FIELD(PSM_NCR_ERR1_DIS, RSRV_ERR6, 31, 1)
    FIELD(PSM_NCR_ERR1_DIS, RSRV_ERR5, 30, 1)
    FIELD(PSM_NCR_ERR1_DIS, RSRV_ERR4, 29, 1)
    FIELD(PSM_NCR_ERR1_DIS, RSRV_ERR3, 28, 1)
    FIELD(PSM_NCR_ERR1_DIS, RSRV_ERR2, 27, 1)
    FIELD(PSM_NCR_ERR1_DIS, PSM_TO, 26, 1)
    FIELD(PSM_NCR_ERR1_DIS, FPD_TO, 25, 1)
    FIELD(PSM_NCR_ERR1_DIS, LPD_TO, 24, 1)
    FIELD(PSM_NCR_ERR1_DIS, PSM_PAR, 23, 1)
    FIELD(PSM_NCR_ERR1_DIS, IOU_PAR, 22, 1)
    FIELD(PSM_NCR_ERR1_DIS, FPD_PAR, 21, 1)
    FIELD(PSM_NCR_ERR1_DIS, LPD_PAR, 20, 1)
    FIELD(PSM_NCR_ERR1_DIS, FPD_APB, 19, 1)
    FIELD(PSM_NCR_ERR1_DIS, LPD_APB, 18, 1)
    FIELD(PSM_NCR_ERR1_DIS, CPM_NCR, 17, 1)
    FIELD(PSM_NCR_ERR1_DIS, CPM_CR, 16, 1)
    FIELD(PSM_NCR_ERR1_DIS, RPLL_LOCK, 15, 1)
    FIELD(PSM_NCR_ERR1_DIS, APLL_LOCK, 14, 1)
    FIELD(PSM_NCR_ERR1_DIS, GIC_ECC, 13, 1)
    FIELD(PSM_NCR_ERR1_DIS, GIC_AXI, 12, 1)
    FIELD(PSM_NCR_ERR1_DIS, RPU_CCF, 11, 1)
    FIELD(PSM_NCR_ERR1_DIS, RPU_LS, 10, 1)
    FIELD(PSM_NCR_ERR1_DIS, RPU_ECC, 9, 1)
    FIELD(PSM_NCR_ERR1_DIS, L2_ECC, 8, 1)
    FIELD(PSM_NCR_ERR1_DIS, OCM_ECC, 7, 1)
    FIELD(PSM_NCR_ERR1_DIS, PSM_NCR, 6, 1)
    FIELD(PSM_NCR_ERR1_DIS, PSM_CR, 5, 1)
    FIELD(PSM_NCR_ERR1_DIS, MB_FATAL, 4, 1)
    FIELD(PSM_NCR_ERR1_DIS, PSM_B_NCR, 3, 1)
    FIELD(PSM_NCR_ERR1_DIS, PSM_B_CR, 2, 1)
    FIELD(PSM_NCR_ERR1_DIS, PS_SW_NCR, 1, 1)
    FIELD(PSM_NCR_ERR1_DIS, PS_SW_CR, 0, 1)
REG32(PSM_NCR_ERR2_MASK, 0x50)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR9, 31, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR8, 30, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR7, 29, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR6, 28, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR5, 27, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR4, 26, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR3, 25, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR2, 24, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR1, 23, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR10, 22, 1)
    FIELD(PSM_NCR_ERR2_MASK, RSRV_ERR0, 21, 1)
    FIELD(PSM_NCR_ERR2_MASK, FPD_XMPU, 20, 1)
    FIELD(PSM_NCR_ERR2_MASK, LPD_XPPU, 19, 1)
    FIELD(PSM_NCR_ERR2_MASK, LPD_XMPU, 18, 1)
    FIELD(PSM_NCR_ERR2_MASK, FPD_SWDT, 1, 1)
    FIELD(PSM_NCR_ERR2_MASK, LPD_SWDT, 0, 1)
REG32(PSM_NCR_ERR2_EN, 0x54)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR9, 31, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR8, 30, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR7, 29, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR6, 28, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR5, 27, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR4, 26, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR3, 25, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR2, 24, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR1, 23, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR10, 22, 1)
    FIELD(PSM_NCR_ERR2_EN, RSRV_ERR0, 21, 1)
    FIELD(PSM_NCR_ERR2_EN, FPD_XMPU, 20, 1)
    FIELD(PSM_NCR_ERR2_EN, LPD_XPPU, 19, 1)
    FIELD(PSM_NCR_ERR2_EN, LPD_XMPU, 18, 1)
    FIELD(PSM_NCR_ERR2_EN, FPD_SWDT, 1, 1)
    FIELD(PSM_NCR_ERR2_EN, LPD_SWDT, 0, 1)
REG32(PSM_NCR_ERR2_DIS, 0x58)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR9, 31, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR8, 30, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR7, 29, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR6, 28, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR5, 27, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR4, 26, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR3, 25, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR2, 24, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR1, 23, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR10, 22, 1)
    FIELD(PSM_NCR_ERR2_DIS, RSRV_ERR0, 21, 1)
    FIELD(PSM_NCR_ERR2_DIS, FPD_XMPU, 20, 1)
    FIELD(PSM_NCR_ERR2_DIS, LPD_XPPU, 19, 1)
    FIELD(PSM_NCR_ERR2_DIS, LPD_XMPU, 18, 1)
    FIELD(PSM_NCR_ERR2_DIS, FPD_SWDT, 1, 1)
    FIELD(PSM_NCR_ERR2_DIS, LPD_SWDT, 0, 1)
REG32(PSM_IRQ1_MASK, 0x60)
    FIELD(PSM_IRQ1_MASK, RSRV_ERR6, 31, 1)
    FIELD(PSM_IRQ1_MASK, RSRV_ERR5, 30, 1)
    FIELD(PSM_IRQ1_MASK, RSRV_ERR4, 29, 1)
    FIELD(PSM_IRQ1_MASK, RSRV_ERR3, 28, 1)
    FIELD(PSM_IRQ1_MASK, RSRV_ERR2, 27, 1)
    FIELD(PSM_IRQ1_MASK, PSM_TO, 26, 1)
    FIELD(PSM_IRQ1_MASK, FPD_TO, 25, 1)
    FIELD(PSM_IRQ1_MASK, LPD_TO, 24, 1)
    FIELD(PSM_IRQ1_MASK, PSM_PAR, 23, 1)
    FIELD(PSM_IRQ1_MASK, IOU_PAR, 22, 1)
    FIELD(PSM_IRQ1_MASK, FPD_PAR, 21, 1)
    FIELD(PSM_IRQ1_MASK, LPD_PAR, 20, 1)
    FIELD(PSM_IRQ1_MASK, FPD_APB, 19, 1)
    FIELD(PSM_IRQ1_MASK, LPD_APB, 18, 1)
    FIELD(PSM_IRQ1_MASK, CPM_NCR, 17, 1)
    FIELD(PSM_IRQ1_MASK, CPM_CR, 16, 1)
    FIELD(PSM_IRQ1_MASK, RPLL_LOCK, 15, 1)
    FIELD(PSM_IRQ1_MASK, APLL_LOCK, 14, 1)
    FIELD(PSM_IRQ1_MASK, GIC_ECC, 13, 1)
    FIELD(PSM_IRQ1_MASK, GIC_AXI, 12, 1)
    FIELD(PSM_IRQ1_MASK, RPU_CCF, 11, 1)
    FIELD(PSM_IRQ1_MASK, RPU_LS, 10, 1)
    FIELD(PSM_IRQ1_MASK, RPU_ECC, 9, 1)
    FIELD(PSM_IRQ1_MASK, L2_ECC, 8, 1)
    FIELD(PSM_IRQ1_MASK, OCM_ECC, 7, 1)
    FIELD(PSM_IRQ1_MASK, PSM_NCR, 6, 1)
    FIELD(PSM_IRQ1_MASK, PSM_CR, 5, 1)
    FIELD(PSM_IRQ1_MASK, MB_FATAL, 4, 1)
    FIELD(PSM_IRQ1_MASK, PSM_B_NCR, 3, 1)
    FIELD(PSM_IRQ1_MASK, PSM_B_CR, 2, 1)
    FIELD(PSM_IRQ1_MASK, PS_SW_NCR, 1, 1)
    FIELD(PSM_IRQ1_MASK, PS_SW_CR, 0, 1)
REG32(PSM_IRQ1_EN, 0x64)
    FIELD(PSM_IRQ1_EN, RSRV_ERR6, 31, 1)
    FIELD(PSM_IRQ1_EN, RSRV_ERR5, 30, 1)
    FIELD(PSM_IRQ1_EN, RSRV_ERR4, 29, 1)
    FIELD(PSM_IRQ1_EN, RSRV_ERR3, 28, 1)
    FIELD(PSM_IRQ1_EN, RSRV_ERR2, 27, 1)
    FIELD(PSM_IRQ1_EN, PSM_TO, 26, 1)
    FIELD(PSM_IRQ1_EN, FPD_TO, 25, 1)
    FIELD(PSM_IRQ1_EN, LPD_TO, 24, 1)
    FIELD(PSM_IRQ1_EN, PSM_PAR, 23, 1)
    FIELD(PSM_IRQ1_EN, IOU_PAR, 22, 1)
    FIELD(PSM_IRQ1_EN, FPD_PAR, 21, 1)
    FIELD(PSM_IRQ1_EN, LPD_PAR, 20, 1)
    FIELD(PSM_IRQ1_EN, FPD_APB, 19, 1)
    FIELD(PSM_IRQ1_EN, LPD_APB, 18, 1)
    FIELD(PSM_IRQ1_EN, CPM_NCR, 17, 1)
    FIELD(PSM_IRQ1_EN, CPM_CR, 16, 1)
    FIELD(PSM_IRQ1_EN, RPLL_LOCK, 15, 1)
    FIELD(PSM_IRQ1_EN, APLL_LOCK, 14, 1)
    FIELD(PSM_IRQ1_EN, GIC_ECC, 13, 1)
    FIELD(PSM_IRQ1_EN, GIC_AXI, 12, 1)
    FIELD(PSM_IRQ1_EN, RPU_CCF, 11, 1)
    FIELD(PSM_IRQ1_EN, RPU_LS, 10, 1)
    FIELD(PSM_IRQ1_EN, RPU_ECC, 9, 1)
    FIELD(PSM_IRQ1_EN, L2_ECC, 8, 1)
    FIELD(PSM_IRQ1_EN, OCM_ECC, 7, 1)
    FIELD(PSM_IRQ1_EN, PSM_NCR, 6, 1)
    FIELD(PSM_IRQ1_EN, PSM_CR, 5, 1)
    FIELD(PSM_IRQ1_EN, MB_FATAL, 4, 1)
    FIELD(PSM_IRQ1_EN, PSM_B_NCR, 3, 1)
    FIELD(PSM_IRQ1_EN, PSM_B_CR, 2, 1)
    FIELD(PSM_IRQ1_EN, PS_SW_NCR, 1, 1)
    FIELD(PSM_IRQ1_EN, PS_SW_CR, 0, 1)
REG32(PSM_IRQ1_DIS, 0x68)
    FIELD(PSM_IRQ1_DIS, RSRV_ERR6, 31, 1)
    FIELD(PSM_IRQ1_DIS, RSRV_ERR5, 30, 1)
    FIELD(PSM_IRQ1_DIS, RSRV_ERR4, 29, 1)
    FIELD(PSM_IRQ1_DIS, RSRV_ERR3, 28, 1)
    FIELD(PSM_IRQ1_DIS, RSRV_ERR2, 27, 1)
    FIELD(PSM_IRQ1_DIS, PSM_TO, 26, 1)
    FIELD(PSM_IRQ1_DIS, FPD_TO, 25, 1)
    FIELD(PSM_IRQ1_DIS, LPD_TO, 24, 1)
    FIELD(PSM_IRQ1_DIS, PSM_PAR, 23, 1)
    FIELD(PSM_IRQ1_DIS, IOU_PAR, 22, 1)
    FIELD(PSM_IRQ1_DIS, FPD_PAR, 21, 1)
    FIELD(PSM_IRQ1_DIS, LPD_PAR, 20, 1)
    FIELD(PSM_IRQ1_DIS, FPD_APB, 19, 1)
    FIELD(PSM_IRQ1_DIS, LPD_APB, 18, 1)
    FIELD(PSM_IRQ1_DIS, CPM_NCR, 17, 1)
    FIELD(PSM_IRQ1_DIS, CPM_CR, 16, 1)
    FIELD(PSM_IRQ1_DIS, RPLL_LOCK, 15, 1)
    FIELD(PSM_IRQ1_DIS, APLL_LOCK, 14, 1)
    FIELD(PSM_IRQ1_DIS, GIC_ECC, 13, 1)
    FIELD(PSM_IRQ1_DIS, GIC_AXI, 12, 1)
    FIELD(PSM_IRQ1_DIS, RPU_CCF, 11, 1)
    FIELD(PSM_IRQ1_DIS, RPU_LS, 10, 1)
    FIELD(PSM_IRQ1_DIS, RPU_ECC, 9, 1)
    FIELD(PSM_IRQ1_DIS, L2_ECC, 8, 1)
    FIELD(PSM_IRQ1_DIS, OCM_ECC, 7, 1)
    FIELD(PSM_IRQ1_DIS, PSM_NCR, 6, 1)
    FIELD(PSM_IRQ1_DIS, PSM_CR, 5, 1)
    FIELD(PSM_IRQ1_DIS, MB_FATAL, 4, 1)
    FIELD(PSM_IRQ1_DIS, PSM_B_NCR, 3, 1)
    FIELD(PSM_IRQ1_DIS, PSM_B_CR, 2, 1)
    FIELD(PSM_IRQ1_DIS, PS_SW_NCR, 1, 1)
    FIELD(PSM_IRQ1_DIS, PS_SW_CR, 0, 1)
REG32(PSM_IRQ2_MASK, 0x70)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR9, 31, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR8, 30, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR7, 29, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR6, 28, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR5, 27, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR4, 26, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR3, 25, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR2, 24, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR1, 23, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR10, 22, 1)
    FIELD(PSM_IRQ2_MASK, RSRV_ERR0, 21, 1)
    FIELD(PSM_IRQ2_MASK, FPD_XMPU, 20, 1)
    FIELD(PSM_IRQ2_MASK, LPD_XPPU, 19, 1)
    FIELD(PSM_IRQ2_MASK, LPD_XMPU, 18, 1)
    FIELD(PSM_IRQ2_MASK, FPD_SWDT, 1, 1)
    FIELD(PSM_IRQ2_MASK, LPD_SWDT, 0, 1)
REG32(PSM_IRQ2_EN, 0x74)
    FIELD(PSM_IRQ2_EN, RSRV_ERR9, 31, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR8, 30, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR7, 29, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR6, 28, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR5, 27, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR4, 26, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR3, 25, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR2, 24, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR1, 23, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR10, 22, 1)
    FIELD(PSM_IRQ2_EN, RSRV_ERR0, 21, 1)
    FIELD(PSM_IRQ2_EN, FPD_XMPU, 20, 1)
    FIELD(PSM_IRQ2_EN, LPD_XPPU, 19, 1)
    FIELD(PSM_IRQ2_EN, LPD_XMPU, 18, 1)
    FIELD(PSM_IRQ2_EN, FPD_SWDT, 1, 1)
    FIELD(PSM_IRQ2_EN, LPD_SWDT, 0, 1)
REG32(PSM_IRQ2_DIS, 0x78)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR9, 31, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR8, 30, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR7, 29, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR6, 28, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR5, 27, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR4, 26, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR3, 25, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR2, 24, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR1, 23, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR10, 22, 1)
    FIELD(PSM_IRQ2_DIS, RSRV_ERR0, 21, 1)
    FIELD(PSM_IRQ2_DIS, FPD_XMPU, 20, 1)
    FIELD(PSM_IRQ2_DIS, LPD_XPPU, 19, 1)
    FIELD(PSM_IRQ2_DIS, LPD_XMPU, 18, 1)
    FIELD(PSM_IRQ2_DIS, FPD_SWDT, 1, 1)
    FIELD(PSM_IRQ2_DIS, LPD_SWDT, 0, 1)

#define PSM_GLOBAL_REG_R_MAX (R_PSM_IRQ2_DIS + 1)

typedef struct PSM_GLOBAL_REG {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[PSM_GLOBAL_REG_R_MAX];
    RegisterInfo regs_info[PSM_GLOBAL_REG_R_MAX];
} PSM_GLOBAL_REG;

static void psm_err_int_en(RegisterInfo *reg, uint64_t val)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val32 = val;

    switch(reg->access->addr) {
    case A_PSM_CR_ERR1_EN:
        s->regs[R_PSM_CR_ERR1_MASK] &= ~(val32);
        break;
    case A_PSM_CR_ERR2_EN:
        s->regs[R_PSM_CR_ERR2_MASK] &= ~(val32);
        break;
    case A_PSM_NCR_ERR1_EN:
        s->regs[R_PSM_NCR_ERR1_MASK] &= ~(val32);
        break;
    case A_PSM_NCR_ERR2_EN:
        s->regs[R_PSM_NCR_ERR2_MASK] &= ~(val32);
        break;
    case A_PSM_IRQ1_EN:
        s->regs[R_PSM_IRQ1_MASK] &= ~(val32);
        break;
    case A_PSM_IRQ2_EN:
        s->regs[R_PSM_IRQ2_MASK] &= ~(val32);
        break;
    };
}

static void psm_err_int_dis(RegisterInfo *reg, uint64_t val)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val32 = val;

    switch(reg->access->addr) {
    case A_PSM_CR_ERR1_DIS:
        s->regs[R_PSM_CR_ERR1_MASK] |= val32;
        break;
    case A_PSM_CR_ERR2_DIS:
        s->regs[R_PSM_CR_ERR2_MASK] |= val32;
        break;
    case A_PSM_NCR_ERR1_DIS:
        s->regs[R_PSM_NCR_ERR1_MASK] |= val32;
        break;
    case A_PSM_NCR_ERR2_DIS:
        s->regs[R_PSM_NCR_ERR2_MASK] |= val32;
        break;
    case A_PSM_IRQ1_DIS:
        s->regs[R_PSM_IRQ1_MASK] |= val32;
        break;
    case A_PSM_IRQ2_DIS:
        s->regs[R_PSM_IRQ2_MASK] |= val32;
        break;
    };
}

static const RegisterAccessInfo psm_global_reg_regs_info[] = {
    {   .name = "PSM_ERR1_STATUS",  .addr = A_PSM_ERR1_STATUS,
        .w1c = 0xffffffff,
    },{ .name = "PSM_ERR2_STATUS",  .addr = A_PSM_ERR2_STATUS,
        .w1c = 0xffffffff,
    },{ .name = "PSM_ERR1_TRIG",  .addr = A_PSM_ERR1_TRIG,
    },{ .name = "PSM_ERR2_TRIG",  .addr = A_PSM_ERR2_TRIG,
    },{ .name = "PSM_CR_ERR1_MASK",  .addr = A_PSM_CR_ERR1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PSM_CR_ERR1_EN",  .addr = A_PSM_CR_ERR1_EN,
        .post_write = psm_err_int_en,
    },{ .name = "PSM_CR_ERR1_DIS",  .addr = A_PSM_CR_ERR1_DIS,
        .post_write = psm_err_int_dis,
    },{ .name = "PSM_CR_ERR2_MASK",  .addr = A_PSM_CR_ERR2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PSM_CR_ERR2_EN",  .addr = A_PSM_CR_ERR2_EN,
        .post_write = psm_err_int_en,
    },{ .name = "PSM_CR_ERR2_DIS",  .addr = A_PSM_CR_ERR2_DIS,
        .post_write = psm_err_int_dis,
    },{ .name = "PSM_NCR_ERR1_MASK",  .addr = A_PSM_NCR_ERR1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PSM_NCR_ERR1_EN",  .addr = A_PSM_NCR_ERR1_EN,
        .post_write = psm_err_int_en,
    },{ .name = "PSM_NCR_ERR1_DIS",  .addr = A_PSM_NCR_ERR1_DIS,
        .post_write = psm_err_int_dis,
    },{ .name = "PSM_NCR_ERR2_MASK",  .addr = A_PSM_NCR_ERR2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PSM_NCR_ERR2_EN",  .addr = A_PSM_NCR_ERR2_EN,
        .post_write = psm_err_int_en,
    },{ .name = "PSM_NCR_ERR2_DIS",  .addr = A_PSM_NCR_ERR2_DIS,
        .post_write = psm_err_int_dis,
    },{ .name = "PSM_IRQ1_MASK",  .addr = A_PSM_IRQ1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PSM_IRQ1_EN",  .addr = A_PSM_IRQ1_EN,
        .post_write = psm_err_int_en,
    },{ .name = "PSM_IRQ1_DIS",  .addr = A_PSM_IRQ1_DIS,
        .post_write = psm_err_int_dis,
    },{ .name = "PSM_IRQ2_MASK",  .addr = A_PSM_IRQ2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PSM_IRQ2_EN",  .addr = A_PSM_IRQ2_EN,
        .post_write = psm_err_int_en,
    },{ .name = "PSM_IRQ2_DIS",  .addr = A_PSM_IRQ2_DIS,
        .post_write = psm_err_int_dis,
    }
};

static void psm_global_reg_reset_enter(Object *obj, ResetType type)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps psm_global_reg_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void psm_global_reg_init(Object *obj)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSM_GLOBAL_REG, PSM_GLOBAL_REG_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psm_global_reg_regs_info,
                              ARRAY_SIZE(psm_global_reg_regs_info),
                              s->regs_info, s->regs,
                              &psm_global_reg_ops,
                              XILINX_PSM_GLOBAL_REG_ERR_DEBUG,
                              PSM_GLOBAL_REG_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_psm_global_reg = {
    .name = TYPE_XILINX_PSM_GLOBAL_REG,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSM_GLOBAL_REG, PSM_GLOBAL_REG_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void psm_global_reg_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_psm_global_reg;
    rc->phases.enter = psm_global_reg_reset_enter;
}

static const TypeInfo psm_global_reg_info = {
    .name          = TYPE_XILINX_PSM_GLOBAL_REG,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSM_GLOBAL_REG),
    .class_init    = psm_global_reg_class_init,
    .instance_init = psm_global_reg_init,
};

static void psm_global_reg_register_types(void)
{
    type_register_static(&psm_global_reg_info);
}

type_init(psm_global_reg_register_types)
