/*
 * QEMU model of the PMC_INT_REGS PMC Interconnect isolation, reset and status registers
 *
 * Copyright (c) 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-04-01.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_PMC_INT_REGS_ERR_DEBUG
#define XILINX_PMC_INT_REGS_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMC_INT_REGS "xlnx.versal-pmc-int"

#define XILINX_PMC_INT_REGS(obj) \
     OBJECT_CHECK(PMC_INT_REGS, (obj), TYPE_XILINX_PMC_INT_REGS)

REG32(IR_STATUS, 0x0)
    FIELD(IR_STATUS, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM3, 4, 1)
    FIELD(IR_STATUS, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM2, 3, 1)
    FIELD(IR_STATUS, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM1, 2, 1)
    FIELD(IR_STATUS, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM0, 1, 1)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x4)
    FIELD(IR_MASK, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM3, 4, 1)
    FIELD(IR_MASK, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM2, 3, 1)
    FIELD(IR_MASK, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM1, 2, 1)
    FIELD(IR_MASK, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM0, 1, 1)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0x8)
    FIELD(IR_ENABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM3, 4, 1)
    FIELD(IR_ENABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM2, 3, 1)
    FIELD(IR_ENABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM1, 2, 1)
    FIELD(IR_ENABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM0, 1, 1)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0xc)
    FIELD(IR_DISABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM3, 4, 1)
    FIELD(IR_DISABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM2, 3, 1)
    FIELD(IR_DISABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM1, 2, 1)
    FIELD(IR_DISABLE, IF_PMC_NOC_AXI0_PROBE_MAINTRACEALARM0, 1, 1)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(JTAGDAP, 0x14)
    FIELD(JTAGDAP, ROUTING, 0, 1)
REG32(PMCDMA0, 0x18)
    FIELD(PMCDMA0, ROUTING, 0, 1)
REG32(PMCDMA1, 0x1c)
    FIELD(PMCDMA1, ROUTING, 0, 1)
REG32(PPU1, 0x24)
    FIELD(PPU1, ROUTING, 0, 1)
REG32(SYSMON, 0x28)
    FIELD(SYSMON, ROUTING, 0, 1)
REG32(INT_PMC_PARITY0_ISR, 0x40)
    FIELD(INT_PMC_PARITY0_ISR, XPPU_NPI_APB, 24, 1)
    FIELD(INT_PMC_PARITY0_ISR, XPPU_APB, 23, 1)
    FIELD(INT_PMC_PARITY0_ISR, XMPU_APB, 22, 1)
    FIELD(INT_PMC_PARITY0_ISR, INTPMC_APB, 21, 1)
    FIELD(INT_PMC_PARITY0_ISR, AES_APB, 20, 1)
    FIELD(INT_PMC_PARITY0_ISR, BBRAM_APB, 19, 1)
    FIELD(INT_PMC_PARITY0_ISR, CFUREG_APB, 18, 1)
    FIELD(INT_PMC_PARITY0_ISR, CRP_APB, 17, 1)
    FIELD(INT_PMC_PARITY0_ISR, DAPREG_APB, 16, 1)
    FIELD(INT_PMC_PARITY0_ISR, ECDSARSA_APB, 15, 1)
    FIELD(INT_PMC_PARITY0_ISR, EFUSE_APB, 14, 1)
    FIELD(INT_PMC_PARITY0_ISR, PMCDMA0REG_APB, 13, 1)
    FIELD(INT_PMC_PARITY0_ISR, PMCDMA1REG_APB, 12, 1)
    FIELD(INT_PMC_PARITY0_ISR, PMCGLOBALREG_APB, 11, 1)
    FIELD(INT_PMC_PARITY0_ISR, PMCOCMCFG_APB, 10, 1)
    FIELD(INT_PMC_PARITY0_ISR, PMCTAP_APB, 9, 1)
    FIELD(INT_PMC_PARITY0_ISR, PPU0TMRTRACE_APB, 8, 1)
    FIELD(INT_PMC_PARITY0_ISR, PPU1RAM_APB, 7, 1)
    FIELD(INT_PMC_PARITY0_ISR, PPU1TMRTRACE_APB, 6, 1)
    FIELD(INT_PMC_PARITY0_ISR, RTC_APB, 5, 1)
    FIELD(INT_PMC_PARITY0_ISR, SHA_APB, 4, 1)
    FIELD(INT_PMC_PARITY0_ISR, SYSMONROOT_APB, 3, 1)
    FIELD(INT_PMC_PARITY0_ISR, TRNG_APB, 2, 1)
    FIELD(INT_PMC_PARITY0_ISR, SBIREG_APB, 1, 1)
    FIELD(INT_PMC_PARITY0_ISR, PMCANLG_APB, 0, 1)
REG32(INT_PMC_PARITY0_IMR, 0x44)
    FIELD(INT_PMC_PARITY0_IMR, XPPU_NPI_APB, 24, 1)
    FIELD(INT_PMC_PARITY0_IMR, XPPU_APB, 23, 1)
    FIELD(INT_PMC_PARITY0_IMR, XMPU_APB, 22, 1)
    FIELD(INT_PMC_PARITY0_IMR, INTPMC_APB, 21, 1)
    FIELD(INT_PMC_PARITY0_IMR, AES_APB, 20, 1)
    FIELD(INT_PMC_PARITY0_IMR, BBRAM_APB, 19, 1)
    FIELD(INT_PMC_PARITY0_IMR, CFUREG_APB, 18, 1)
    FIELD(INT_PMC_PARITY0_IMR, CRP_APB, 17, 1)
    FIELD(INT_PMC_PARITY0_IMR, DAPREG_APB, 16, 1)
    FIELD(INT_PMC_PARITY0_IMR, ECDSARSA_APB, 15, 1)
    FIELD(INT_PMC_PARITY0_IMR, EFUSE_APB, 14, 1)
    FIELD(INT_PMC_PARITY0_IMR, PMCDMA0REG_APB, 13, 1)
    FIELD(INT_PMC_PARITY0_IMR, PMCDMA1REG_APB, 12, 1)
    FIELD(INT_PMC_PARITY0_IMR, PMCGLOBALREG_APB, 11, 1)
    FIELD(INT_PMC_PARITY0_IMR, PMCOCMCFG_APB, 10, 1)
    FIELD(INT_PMC_PARITY0_IMR, PMCTAP_APB, 9, 1)
    FIELD(INT_PMC_PARITY0_IMR, PPU0TMRTRACE_APB, 8, 1)
    FIELD(INT_PMC_PARITY0_IMR, PPU1RAM_APB, 7, 1)
    FIELD(INT_PMC_PARITY0_IMR, PPU1TMRTRACE_APB, 6, 1)
    FIELD(INT_PMC_PARITY0_IMR, RTC_APB, 5, 1)
    FIELD(INT_PMC_PARITY0_IMR, SHA_APB, 4, 1)
    FIELD(INT_PMC_PARITY0_IMR, SYSMONROOT_APB, 3, 1)
    FIELD(INT_PMC_PARITY0_IMR, TRNG_APB, 2, 1)
    FIELD(INT_PMC_PARITY0_IMR, SBIREG_APB, 1, 1)
    FIELD(INT_PMC_PARITY0_IMR, PMCANLG_APB, 0, 1)
REG32(INT_PMC_PARITY0_IER, 0x48)
    FIELD(INT_PMC_PARITY0_IER, XPPU_NPI_APB, 24, 1)
    FIELD(INT_PMC_PARITY0_IER, XPPU_APB, 23, 1)
    FIELD(INT_PMC_PARITY0_IER, XMPU_APB, 22, 1)
    FIELD(INT_PMC_PARITY0_IER, INTPMC_APB, 21, 1)
    FIELD(INT_PMC_PARITY0_IER, AES_APB, 20, 1)
    FIELD(INT_PMC_PARITY0_IER, BBRAM_APB, 19, 1)
    FIELD(INT_PMC_PARITY0_IER, CFUREG_APB, 18, 1)
    FIELD(INT_PMC_PARITY0_IER, CRP_APB, 17, 1)
    FIELD(INT_PMC_PARITY0_IER, DAPREG_APB, 16, 1)
    FIELD(INT_PMC_PARITY0_IER, ECDSARSA_APB, 15, 1)
    FIELD(INT_PMC_PARITY0_IER, EFUSE_APB, 14, 1)
    FIELD(INT_PMC_PARITY0_IER, PMCDMA0REG_APB, 13, 1)
    FIELD(INT_PMC_PARITY0_IER, PMCDMA1REG_APB, 12, 1)
    FIELD(INT_PMC_PARITY0_IER, PMCGLOBALREG_APB, 11, 1)
    FIELD(INT_PMC_PARITY0_IER, PMCOCMCFG_APB, 10, 1)
    FIELD(INT_PMC_PARITY0_IER, PMCTAP_APB, 9, 1)
    FIELD(INT_PMC_PARITY0_IER, PPU0TMRTRACE_APB, 8, 1)
    FIELD(INT_PMC_PARITY0_IER, PPU1RAM_APB, 7, 1)
    FIELD(INT_PMC_PARITY0_IER, PPU1TMRTRACE_APB, 6, 1)
    FIELD(INT_PMC_PARITY0_IER, RTC_APB, 5, 1)
    FIELD(INT_PMC_PARITY0_IER, SHA_APB, 4, 1)
    FIELD(INT_PMC_PARITY0_IER, SYSMONROOT_APB, 3, 1)
    FIELD(INT_PMC_PARITY0_IER, TRNG_APB, 2, 1)
    FIELD(INT_PMC_PARITY0_IER, SBIREG_APB, 1, 1)
    FIELD(INT_PMC_PARITY0_IER, PMCANLG_APB, 0, 1)
REG32(INT_PMC_PARITY0_IDR, 0x4c)
    FIELD(INT_PMC_PARITY0_IDR, XPPU_NPI_APB, 24, 1)
    FIELD(INT_PMC_PARITY0_IDR, XPPU_APB, 23, 1)
    FIELD(INT_PMC_PARITY0_IDR, XMPU_APB, 22, 1)
    FIELD(INT_PMC_PARITY0_IDR, INTPMC_APB, 21, 1)
    FIELD(INT_PMC_PARITY0_IDR, AES_APB, 20, 1)
    FIELD(INT_PMC_PARITY0_IDR, BBRAM_APB, 19, 1)
    FIELD(INT_PMC_PARITY0_IDR, CFUREG_APB, 18, 1)
    FIELD(INT_PMC_PARITY0_IDR, CRP_APB, 17, 1)
    FIELD(INT_PMC_PARITY0_IDR, DAPREG_APB, 16, 1)
    FIELD(INT_PMC_PARITY0_IDR, ECDSARSA_APB, 15, 1)
    FIELD(INT_PMC_PARITY0_IDR, EFUSE_APB, 14, 1)
    FIELD(INT_PMC_PARITY0_IDR, PMCDMA0REG_APB, 13, 1)
    FIELD(INT_PMC_PARITY0_IDR, PMCDMA1REG_APB, 12, 1)
    FIELD(INT_PMC_PARITY0_IDR, PMCGLOBALREG_APB, 11, 1)
    FIELD(INT_PMC_PARITY0_IDR, PMCOCMCFG_APB, 10, 1)
    FIELD(INT_PMC_PARITY0_IDR, PMCTAP_APB, 9, 1)
    FIELD(INT_PMC_PARITY0_IDR, PPU0TMRTRACE_APB, 8, 1)
    FIELD(INT_PMC_PARITY0_IDR, PPU1RAM_APB, 7, 1)
    FIELD(INT_PMC_PARITY0_IDR, PPU1TMRTRACE_APB, 6, 1)
    FIELD(INT_PMC_PARITY0_IDR, RTC_APB, 5, 1)
    FIELD(INT_PMC_PARITY0_IDR, SHA_APB, 4, 1)
    FIELD(INT_PMC_PARITY0_IDR, SYSMONROOT_APB, 3, 1)
    FIELD(INT_PMC_PARITY0_IDR, TRNG_APB, 2, 1)
    FIELD(INT_PMC_PARITY0_IDR, SBIREG_APB, 1, 1)
    FIELD(INT_PMC_PARITY0_IDR, PMCANLG_APB, 0, 1)
REG32(INT_PMC_PARITY0_ITR, 0x50)
    FIELD(INT_PMC_PARITY0_ITR, XPPU_NPI_APB, 24, 1)
    FIELD(INT_PMC_PARITY0_ITR, XPPU_APB, 23, 1)
    FIELD(INT_PMC_PARITY0_ITR, XMPU_APB, 22, 1)
    FIELD(INT_PMC_PARITY0_ITR, INTPMC_APB, 21, 1)
    FIELD(INT_PMC_PARITY0_ITR, AES_APB, 20, 1)
    FIELD(INT_PMC_PARITY0_ITR, BBRAM_APB, 19, 1)
    FIELD(INT_PMC_PARITY0_ITR, CFUREG_APB, 18, 1)
    FIELD(INT_PMC_PARITY0_ITR, CRP_APB, 17, 1)
    FIELD(INT_PMC_PARITY0_ITR, DAPREG_APB, 16, 1)
    FIELD(INT_PMC_PARITY0_ITR, ECDSARSA_APB, 15, 1)
    FIELD(INT_PMC_PARITY0_ITR, EFUSE_APB, 14, 1)
    FIELD(INT_PMC_PARITY0_ITR, PMCDMA0REG_APB, 13, 1)
    FIELD(INT_PMC_PARITY0_ITR, PMCDMA1REG_APB, 12, 1)
    FIELD(INT_PMC_PARITY0_ITR, PMCGLOBALREG_APB, 11, 1)
    FIELD(INT_PMC_PARITY0_ITR, PMCOCMCFG_APB, 10, 1)
    FIELD(INT_PMC_PARITY0_ITR, PMCTAP_APB, 9, 1)
    FIELD(INT_PMC_PARITY0_ITR, PPU0TMRTRACE_APB, 8, 1)
    FIELD(INT_PMC_PARITY0_ITR, PPU1RAM_APB, 7, 1)
    FIELD(INT_PMC_PARITY0_ITR, PPU1TMRTRACE_APB, 6, 1)
    FIELD(INT_PMC_PARITY0_ITR, RTC_APB, 5, 1)
    FIELD(INT_PMC_PARITY0_ITR, SHA_APB, 4, 1)
    FIELD(INT_PMC_PARITY0_ITR, SYSMONROOT_APB, 3, 1)
    FIELD(INT_PMC_PARITY0_ITR, TRNG_APB, 2, 1)
    FIELD(INT_PMC_PARITY0_ITR, SBIREG_APB, 1, 1)
    FIELD(INT_PMC_PARITY0_ITR, PMCANLG_APB, 0, 1)
REG32(INT_PMC_PARITY1_ISR, 0x54)
    FIELD(INT_PMC_PARITY1_ISR, PS_NOC_PCI_AXI1, 18, 1)
    FIELD(INT_PMC_PARITY1_ISR, PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY1_ISR, PS_NOC_RPU_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY1_ISR, NOC_PS_PCI_AXI0, 15, 1)
    FIELD(INT_PMC_PARITY1_ISR, INTPMC_NPI_AXI, 14, 1)
    FIELD(INT_PMC_PARITY1_ISR, PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY1_ISR, NOC_PMC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY1_ISR, INTPMC_PMCOCM, 11, 1)
    FIELD(INT_PMC_PARITY1_ISR, INTPMC_CFUSTREAM, 10, 1)
    FIELD(INT_PMC_PARITY1_ISR, INTPMC_PPU1MDMSHD, 9, 1)
    FIELD(INT_PMC_PARITY1_ISR, INTPMC_PPU0MDMSHD, 8, 1)
    FIELD(INT_PMC_PARITY1_ISR, INTPMC_SBI, 7, 1)
    FIELD(INT_PMC_PARITY1_ISR, DPC_INTPMC, 6, 1)
    FIELD(INT_PMC_PARITY1_ISR, SYSMONROOT_INTPMC, 5, 1)
    FIELD(INT_PMC_PARITY1_ISR, PMCDMA1_INTPMC, 4, 1)
    FIELD(INT_PMC_PARITY1_ISR, PMCDMA0_INTPMC, 3, 1)
    FIELD(INT_PMC_PARITY1_ISR, JTAGDAP_INTPMC, 2, 1)
    FIELD(INT_PMC_PARITY1_ISR, PPU1_INTPMC, 1, 1)
    FIELD(INT_PMC_PARITY1_ISR, PPU0_INTPMC, 0, 1)
REG32(INT_PMC_PARITY1_IMR, 0x58)
    FIELD(INT_PMC_PARITY1_IMR, PS_NOC_PCI_AXI1, 18, 1)
    FIELD(INT_PMC_PARITY1_IMR, PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY1_IMR, PS_NOC_RPU_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY1_IMR, NOC_PS_PCI_AXI0, 15, 1)
    FIELD(INT_PMC_PARITY1_IMR, INTPMC_NPI_AXI, 14, 1)
    FIELD(INT_PMC_PARITY1_IMR, PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY1_IMR, NOC_PMC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY1_IMR, INTPMC_PMCOCM, 11, 1)
    FIELD(INT_PMC_PARITY1_IMR, INTPMC_CFUSTREAM, 10, 1)
    FIELD(INT_PMC_PARITY1_IMR, INTPMC_PPU1MDMSHD, 9, 1)
    FIELD(INT_PMC_PARITY1_IMR, INTPMC_PPU0MDMSHD, 8, 1)
    FIELD(INT_PMC_PARITY1_IMR, INTPMC_SBI, 7, 1)
    FIELD(INT_PMC_PARITY1_IMR, DPC_INTPMC, 6, 1)
    FIELD(INT_PMC_PARITY1_IMR, SYSMONROOT_INTPMC, 5, 1)
    FIELD(INT_PMC_PARITY1_IMR, PMCDMA1_INTPMC, 4, 1)
    FIELD(INT_PMC_PARITY1_IMR, PMCDMA0_INTPMC, 3, 1)
    FIELD(INT_PMC_PARITY1_IMR, JTAGDAP_INTPMC, 2, 1)
    FIELD(INT_PMC_PARITY1_IMR, PPU1_INTPMC, 1, 1)
    FIELD(INT_PMC_PARITY1_IMR, PPU0_INTPMC, 0, 1)
REG32(INT_PMC_PARITY1_IER, 0x5c)
    FIELD(INT_PMC_PARITY1_IER, PS_NOC_PCI_AXI1, 18, 1)
    FIELD(INT_PMC_PARITY1_IER, PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY1_IER, PS_NOC_RPU_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY1_IER, NOC_PS_PCI_AXI0, 15, 1)
    FIELD(INT_PMC_PARITY1_IER, INTPMC_NPI_AXI, 14, 1)
    FIELD(INT_PMC_PARITY1_IER, PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY1_IER, NOC_PMC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY1_IER, INTPMC_PMCOCM, 11, 1)
    FIELD(INT_PMC_PARITY1_IER, INTPMC_CFUSTREAM, 10, 1)
    FIELD(INT_PMC_PARITY1_IER, INTPMC_PPU1MDMSHD, 9, 1)
    FIELD(INT_PMC_PARITY1_IER, INTPMC_PPU0MDMSHD, 8, 1)
    FIELD(INT_PMC_PARITY1_IER, INTPMC_SBI, 7, 1)
    FIELD(INT_PMC_PARITY1_IER, DPC_INTPMC, 6, 1)
    FIELD(INT_PMC_PARITY1_IER, SYSMONROOT_INTPMC, 5, 1)
    FIELD(INT_PMC_PARITY1_IER, PMCDMA1_INTPMC, 4, 1)
    FIELD(INT_PMC_PARITY1_IER, PMCDMA0_INTPMC, 3, 1)
    FIELD(INT_PMC_PARITY1_IER, JTAGDAP_INTPMC, 2, 1)
    FIELD(INT_PMC_PARITY1_IER, PPU1_INTPMC, 1, 1)
    FIELD(INT_PMC_PARITY1_IER, PPU0_INTPMC, 0, 1)
REG32(INT_PMC_PARITY1_IDR, 0x60)
    FIELD(INT_PMC_PARITY1_IDR, PS_NOC_PCI_AXI1, 18, 1)
    FIELD(INT_PMC_PARITY1_IDR, PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY1_IDR, PS_NOC_RPU_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY1_IDR, NOC_PS_PCI_AXI0, 15, 1)
    FIELD(INT_PMC_PARITY1_IDR, INTPMC_NPI_AXI, 14, 1)
    FIELD(INT_PMC_PARITY1_IDR, PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY1_IDR, NOC_PMC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY1_IDR, INTPMC_PMCOCM, 11, 1)
    FIELD(INT_PMC_PARITY1_IDR, INTPMC_CFUSTREAM, 10, 1)
    FIELD(INT_PMC_PARITY1_IDR, INTPMC_PPU1MDMSHD, 9, 1)
    FIELD(INT_PMC_PARITY1_IDR, INTPMC_PPU0MDMSHD, 8, 1)
    FIELD(INT_PMC_PARITY1_IDR, INTPMC_SBI, 7, 1)
    FIELD(INT_PMC_PARITY1_IDR, DPC_INTPMC, 6, 1)
    FIELD(INT_PMC_PARITY1_IDR, SYSMONROOT_INTPMC, 5, 1)
    FIELD(INT_PMC_PARITY1_IDR, PMCDMA1_INTPMC, 4, 1)
    FIELD(INT_PMC_PARITY1_IDR, PMCDMA0_INTPMC, 3, 1)
    FIELD(INT_PMC_PARITY1_IDR, JTAGDAP_INTPMC, 2, 1)
    FIELD(INT_PMC_PARITY1_IDR, PPU1_INTPMC, 1, 1)
    FIELD(INT_PMC_PARITY1_IDR, PPU0_INTPMC, 0, 1)
REG32(INT_PMC_PARITY1_ITR, 0x64)
    FIELD(INT_PMC_PARITY1_ITR, PS_NOC_PCI_AXI1, 18, 1)
    FIELD(INT_PMC_PARITY1_ITR, PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY1_ITR, PS_NOC_RPU_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY1_ITR, NOC_PS_PCI_AXI0, 15, 1)
    FIELD(INT_PMC_PARITY1_ITR, INTPMC_NPI_AXI, 14, 1)
    FIELD(INT_PMC_PARITY1_ITR, PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY1_ITR, NOC_PMC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY1_ITR, INTPMC_PMCOCM, 11, 1)
    FIELD(INT_PMC_PARITY1_ITR, INTPMC_CFUSTREAM, 10, 1)
    FIELD(INT_PMC_PARITY1_ITR, INTPMC_PPU1MDMSHD, 9, 1)
    FIELD(INT_PMC_PARITY1_ITR, INTPMC_PPU0MDMSHD, 8, 1)
    FIELD(INT_PMC_PARITY1_ITR, INTPMC_SBI, 7, 1)
    FIELD(INT_PMC_PARITY1_ITR, DPC_INTPMC, 6, 1)
    FIELD(INT_PMC_PARITY1_ITR, SYSMONROOT_INTPMC, 5, 1)
    FIELD(INT_PMC_PARITY1_ITR, PMCDMA1_INTPMC, 4, 1)
    FIELD(INT_PMC_PARITY1_ITR, PMCDMA0_INTPMC, 3, 1)
    FIELD(INT_PMC_PARITY1_ITR, JTAGDAP_INTPMC, 2, 1)
    FIELD(INT_PMC_PARITY1_ITR, PPU1_INTPMC, 1, 1)
    FIELD(INT_PMC_PARITY1_ITR, PPU0_INTPMC, 0, 1)
REG32(INT_PMC_MISSION_ISR, 0x68)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_INTPMCIOU_AXI_POWER_MAINMISSIONINT, 29, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_RTC_APB_POWER_MAINMISSIONINT, 28, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_GLOBALREG_APB_POWER_MAINMISSIONINT, 27, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_RST_INTCNTL_APB_POWER_MAINMISSIONINT, 26, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_DPC_POWER_MAINMISSIONINT, 25, 1)
    FIELD(INT_PMC_MISSION_ISR, SYSMON_APB_POWER_MAINMISSIONINT, 24, 1)
    FIELD(INT_PMC_MISSION_ISR, PS_PMC_AXI0_POWER_MAINMISSIONINT, 23, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_SYSMONROOT_POWER_MAINMISSIONINT, 22, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_PPU1_POWER_MAINMISSIONINT, 21, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_PPU0_POWER_MAINMISSIONINT, 20, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_PMCDMA1_POWER_MAINMISSIONINT, 19, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_PMCDMA0_POWER_MAINMISSIONINT, 18, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_JTAG_POWER_MAINMISSIONINT, 17, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_IOU_POWER_MAINMISSIONINT, 16, 1)
    FIELD(INT_PMC_MISSION_ISR, NOC_PMC_AXI0_POWER_MAINMISSIONINT, 15, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_PMC_PS_AXI0_POWER_MAINMISSIONINT, 14, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_PMC_NOC_AXI0_POWER_MAINMISSIONINT, 13, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_SBI_AXI_POWER_MAINMISSIONINT, 12, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_PPU1MDMSHD_AXI_POWER_MAINMISSIONINT, 11, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_PPU0MDMSHD_AXI_POWER_MAINMISSIONINT, 10, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_PMCOCM_AXI_POWER_MAINMISSIONINT, 9, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_NPI_AXI_POWER_MAINMISSIONINT, 8, 1)
    FIELD(INT_PMC_MISSION_ISR, IF_INTPMC_CFUSTREAM_AXI_POWER_MAINMISSIONINT, 7, 1)
    FIELD(INT_PMC_MISSION_ISR, EFUSE_APB_POWER_MAINMISSIONINT, 6, 1)
    FIELD(INT_PMC_MISSION_ISR, CFU_APB_POWER_MAINMISSIONINT, 5, 1)
    FIELD(INT_PMC_MISSION_ISR, SECURE_APB_POWER_MAINMISSIONINT, 4, 1)
    FIELD(INT_PMC_MISSION_ISR, PPU_APB_POWER_MAINMISSIONINT, 3, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_POWER_MAINMISSIONINT, 2, 1)
    FIELD(INT_PMC_MISSION_ISR, PMC_LSBUS_REF_CLK_APB_POWER_MAINMISSIONINT, 1, 1)
    FIELD(INT_PMC_MISSION_ISR, DEBUG_APB_POWER_MAINMISSIONINT, 0, 1)
REG32(INT_PMC_MISSION_IMR, 0x6c)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_INTPMCIOU_AXI_POWER_MAINMISSIONINT, 29, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_RTC_APB_POWER_MAINMISSIONINT, 28, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_GLOBALREG_APB_POWER_MAINMISSIONINT, 27, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_RST_INTCNTL_APB_POWER_MAINMISSIONINT, 26, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_DPC_POWER_MAINMISSIONINT, 25, 1)
    FIELD(INT_PMC_MISSION_IMR, SYSMON_APB_POWER_MAINMISSIONINT, 24, 1)
    FIELD(INT_PMC_MISSION_IMR, PS_PMC_AXI0_POWER_MAINMISSIONINT, 23, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_SYSMONROOT_POWER_MAINMISSIONINT, 22, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_PPU1_POWER_MAINMISSIONINT, 21, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_PPU0_POWER_MAINMISSIONINT, 20, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_PMCDMA1_POWER_MAINMISSIONINT, 19, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_PMCDMA0_POWER_MAINMISSIONINT, 18, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_JTAG_POWER_MAINMISSIONINT, 17, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_IOU_POWER_MAINMISSIONINT, 16, 1)
    FIELD(INT_PMC_MISSION_IMR, NOC_PMC_AXI0_POWER_MAINMISSIONINT, 15, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_PMC_PS_AXI0_POWER_MAINMISSIONINT, 14, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_PMC_NOC_AXI0_POWER_MAINMISSIONINT, 13, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_SBI_AXI_POWER_MAINMISSIONINT, 12, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_PPU1MDMSHD_AXI_POWER_MAINMISSIONINT, 11, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_PPU0MDMSHD_AXI_POWER_MAINMISSIONINT, 10, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_PMCOCM_AXI_POWER_MAINMISSIONINT, 9, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_NPI_AXI_POWER_MAINMISSIONINT, 8, 1)
    FIELD(INT_PMC_MISSION_IMR, IF_INTPMC_CFUSTREAM_AXI_POWER_MAINMISSIONINT, 7, 1)
    FIELD(INT_PMC_MISSION_IMR, EFUSE_APB_POWER_MAINMISSIONINT, 6, 1)
    FIELD(INT_PMC_MISSION_IMR, CFU_APB_POWER_MAINMISSIONINT, 5, 1)
    FIELD(INT_PMC_MISSION_IMR, SECURE_APB_POWER_MAINMISSIONINT, 4, 1)
    FIELD(INT_PMC_MISSION_IMR, PPU_APB_POWER_MAINMISSIONINT, 3, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_POWER_MAINMISSIONINT, 2, 1)
    FIELD(INT_PMC_MISSION_IMR, PMC_LSBUS_REF_CLK_APB_POWER_MAINMISSIONINT, 1, 1)
    FIELD(INT_PMC_MISSION_IMR, DEBUG_APB_POWER_MAINMISSIONINT, 0, 1)
REG32(INT_PMC_MISSION_IER, 0x70)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_INTPMCIOU_AXI_POWER_MAINMISSIONINT, 29, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_RTC_APB_POWER_MAINMISSIONINT, 28, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_GLOBALREG_APB_POWER_MAINMISSIONINT, 27, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_RST_INTCNTL_APB_POWER_MAINMISSIONINT, 26, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_DPC_POWER_MAINMISSIONINT, 25, 1)
    FIELD(INT_PMC_MISSION_IER, SYSMON_APB_POWER_MAINMISSIONINT, 24, 1)
    FIELD(INT_PMC_MISSION_IER, PS_PMC_AXI0_POWER_MAINMISSIONINT, 23, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_SYSMONROOT_POWER_MAINMISSIONINT, 22, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_PPU1_POWER_MAINMISSIONINT, 21, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_PPU0_POWER_MAINMISSIONINT, 20, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_PMCDMA1_POWER_MAINMISSIONINT, 19, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_PMCDMA0_POWER_MAINMISSIONINT, 18, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_JTAG_POWER_MAINMISSIONINT, 17, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_IOU_POWER_MAINMISSIONINT, 16, 1)
    FIELD(INT_PMC_MISSION_IER, NOC_PMC_AXI0_POWER_MAINMISSIONINT, 15, 1)
    FIELD(INT_PMC_MISSION_IER, IF_PMC_PS_AXI0_POWER_MAINMISSIONINT, 14, 1)
    FIELD(INT_PMC_MISSION_IER, IF_PMC_NOC_AXI0_POWER_MAINMISSIONINT, 13, 1)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_SBI_AXI_POWER_MAINMISSIONINT, 12, 1)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_PPU1MDMSHD_AXI_POWER_MAINMISSIONINT, 11, 1)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_PPU0MDMSHD_AXI_POWER_MAINMISSIONINT, 10, 1)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_PMCOCM_AXI_POWER_MAINMISSIONINT, 9, 1)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_NPI_AXI_POWER_MAINMISSIONINT, 8, 1)
    FIELD(INT_PMC_MISSION_IER, IF_INTPMC_CFUSTREAM_AXI_POWER_MAINMISSIONINT, 7, 1)
    FIELD(INT_PMC_MISSION_IER, EFUSE_APB_POWER_MAINMISSIONINT, 6, 1)
    FIELD(INT_PMC_MISSION_IER, CFU_APB_POWER_MAINMISSIONINT, 5, 1)
    FIELD(INT_PMC_MISSION_IER, SECURE_APB_POWER_MAINMISSIONINT, 4, 1)
    FIELD(INT_PMC_MISSION_IER, PPU_APB_POWER_MAINMISSIONINT, 3, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_POWER_MAINMISSIONINT, 2, 1)
    FIELD(INT_PMC_MISSION_IER, PMC_LSBUS_REF_CLK_APB_POWER_MAINMISSIONINT, 1, 1)
    FIELD(INT_PMC_MISSION_IER, DEBUG_APB_POWER_MAINMISSIONINT, 0, 1)
REG32(INT_PMC_MISSION_IDR, 0x74)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_INTPMCIOU_AXI_POWER_MAINMISSIONINT, 29, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_RTC_APB_POWER_MAINMISSIONINT, 28, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_GLOBALREG_APB_POWER_MAINMISSIONINT, 27, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_RST_INTCNTL_APB_POWER_MAINMISSIONINT, 26, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_DPC_POWER_MAINMISSIONINT, 25, 1)
    FIELD(INT_PMC_MISSION_IDR, SYSMON_APB_POWER_MAINMISSIONINT, 24, 1)
    FIELD(INT_PMC_MISSION_IDR, PS_PMC_AXI0_POWER_MAINMISSIONINT, 23, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_SYSMONROOT_POWER_MAINMISSIONINT, 22, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_PPU1_POWER_MAINMISSIONINT, 21, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_PPU0_POWER_MAINMISSIONINT, 20, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_PMCDMA1_POWER_MAINMISSIONINT, 19, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_PMCDMA0_POWER_MAINMISSIONINT, 18, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_JTAG_POWER_MAINMISSIONINT, 17, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_IOU_POWER_MAINMISSIONINT, 16, 1)
    FIELD(INT_PMC_MISSION_IDR, NOC_PMC_AXI0_POWER_MAINMISSIONINT, 15, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_PMC_PS_AXI0_POWER_MAINMISSIONINT, 14, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_PMC_NOC_AXI0_POWER_MAINMISSIONINT, 13, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_SBI_AXI_POWER_MAINMISSIONINT, 12, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_PPU1MDMSHD_AXI_POWER_MAINMISSIONINT, 11, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_PPU0MDMSHD_AXI_POWER_MAINMISSIONINT, 10, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_PMCOCM_AXI_POWER_MAINMISSIONINT, 9, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_NPI_AXI_POWER_MAINMISSIONINT, 8, 1)
    FIELD(INT_PMC_MISSION_IDR, IF_INTPMC_CFUSTREAM_AXI_POWER_MAINMISSIONINT, 7, 1)
    FIELD(INT_PMC_MISSION_IDR, EFUSE_APB_POWER_MAINMISSIONINT, 6, 1)
    FIELD(INT_PMC_MISSION_IDR, CFU_APB_POWER_MAINMISSIONINT, 5, 1)
    FIELD(INT_PMC_MISSION_IDR, SECURE_APB_POWER_MAINMISSIONINT, 4, 1)
    FIELD(INT_PMC_MISSION_IDR, PPU_APB_POWER_MAINMISSIONINT, 3, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_POWER_MAINMISSIONINT, 2, 1)
    FIELD(INT_PMC_MISSION_IDR, PMC_LSBUS_REF_CLK_APB_POWER_MAINMISSIONINT, 1, 1)
    FIELD(INT_PMC_MISSION_IDR, DEBUG_APB_POWER_MAINMISSIONINT, 0, 1)
REG32(INT_PMC_MISSION_ITR, 0x78)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_INTPMCIOU_AXI_POWER_MAINMISSIONINT, 29, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_RTC_APB_POWER_MAINMISSIONINT, 28, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_GLOBALREG_APB_POWER_MAINMISSIONINT, 27, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_RST_INTCNTL_APB_POWER_MAINMISSIONINT, 26, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_DPC_POWER_MAINMISSIONINT, 25, 1)
    FIELD(INT_PMC_MISSION_ITR, SYSMON_APB_POWER_MAINMISSIONINT, 24, 1)
    FIELD(INT_PMC_MISSION_ITR, PS_PMC_AXI0_POWER_MAINMISSIONINT, 23, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_SYSMONROOT_POWER_MAINMISSIONINT, 22, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_PPU1_POWER_MAINMISSIONINT, 21, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_PPU0_POWER_MAINMISSIONINT, 20, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_PMCDMA1_POWER_MAINMISSIONINT, 19, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_PMCDMA0_POWER_MAINMISSIONINT, 18, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_JTAG_POWER_MAINMISSIONINT, 17, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_IOU_POWER_MAINMISSIONINT, 16, 1)
    FIELD(INT_PMC_MISSION_ITR, NOC_PMC_AXI0_POWER_MAINMISSIONINT, 15, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_PMC_PS_AXI0_POWER_MAINMISSIONINT, 14, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_PMC_NOC_AXI0_POWER_MAINMISSIONINT, 13, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_SBI_AXI_POWER_MAINMISSIONINT, 12, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_PPU1MDMSHD_AXI_POWER_MAINMISSIONINT, 11, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_PPU0MDMSHD_AXI_POWER_MAINMISSIONINT, 10, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_PMCOCM_AXI_POWER_MAINMISSIONINT, 9, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_NPI_AXI_POWER_MAINMISSIONINT, 8, 1)
    FIELD(INT_PMC_MISSION_ITR, IF_INTPMC_CFUSTREAM_AXI_POWER_MAINMISSIONINT, 7, 1)
    FIELD(INT_PMC_MISSION_ITR, EFUSE_APB_POWER_MAINMISSIONINT, 6, 1)
    FIELD(INT_PMC_MISSION_ITR, CFU_APB_POWER_MAINMISSIONINT, 5, 1)
    FIELD(INT_PMC_MISSION_ITR, SECURE_APB_POWER_MAINMISSIONINT, 4, 1)
    FIELD(INT_PMC_MISSION_ITR, PPU_APB_POWER_MAINMISSIONINT, 3, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_POWER_MAINMISSIONINT, 2, 1)
    FIELD(INT_PMC_MISSION_ITR, PMC_LSBUS_REF_CLK_APB_POWER_MAINMISSIONINT, 1, 1)
    FIELD(INT_PMC_MISSION_ITR, DEBUG_APB_POWER_MAINMISSIONINT, 0, 1)
REG32(INT_PMC_TIMEOUT_ISR, 0x90)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_INTPMCIOU_AXI_T_MAINTIMEOUT, 18, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_RTC_APB_T_MAINTIMEOUT, 17, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_PMCGLOBALREG_APB_T_MAINTIMEOUT, 16, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, PMC_RST_INTCNTL_APB_T_MAINTIMEOUT, 15, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_SYSMONROOT_APB_T_MAINTIMEOUT, 14, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_CFUREG_APB_T_MAINTIMEOUT, 13, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_PMC_PS_AXI0_T_MAINTIMEOUT, 12, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_PMC_NOC_AXI0_T_MAINTIMEOUT, 11, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_SBI_AXI_T_MAINTIMEOUT, 10, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_PPU1MDMSHD_AXI_T_MAINTIMEOUT, 9, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_PPU0MDMSHD_AXI_T_MAINTIMEOUT, 8, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_PMCOCM_AXI_T_MAINTIMEOUT, 7, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_NPI_AXI_T_MAINTIMEOUT, 6, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_CFUSTREAM_AXI_T_MAINTIMEOUT, 5, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, IF_INTPMC_EFUSE_APB_T_MAINTIMEOUT, 4, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, PMC_AES_ECDSARSA_SHA_TRNG_APB_T_MAINTIMEOUT, 3, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, PMC_GLOB_OCMCFG_PPU0_PPU1APB_T_MAINTIMEOUT, 2, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, PMC_LSBUS_REF_CLK_BBRAM_CFU_CRP_ANLG_DMA_APB_T_MAINTIMEOUT, 1, 1)
    FIELD(INT_PMC_TIMEOUT_ISR, PMC_DAP_TAP_APB_T_MAINTIMEOUT, 0, 1)
REG32(INT_PMC_TIMEOUT_IMR, 0x94)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_INTPMCIOU_AXI_T_MAINTIMEOUT, 18, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_RTC_APB_T_MAINTIMEOUT, 17, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_PMCGLOBALREG_APB_T_MAINTIMEOUT, 16, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, PMC_RST_INTCNTL_APB_T_MAINTIMEOUT, 15, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_SYSMONROOT_APB_T_MAINTIMEOUT, 14, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_CFUREG_APB_T_MAINTIMEOUT, 13, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_PMC_PS_AXI0_T_MAINTIMEOUT, 12, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_PMC_NOC_AXI0_T_MAINTIMEOUT, 11, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_SBI_AXI_T_MAINTIMEOUT, 10, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_PPU1MDMSHD_AXI_T_MAINTIMEOUT, 9, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_PPU0MDMSHD_AXI_T_MAINTIMEOUT, 8, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_PMCOCM_AXI_T_MAINTIMEOUT, 7, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_NPI_AXI_T_MAINTIMEOUT, 6, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_CFUSTREAM_AXI_T_MAINTIMEOUT, 5, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, IF_INTPMC_EFUSE_APB_T_MAINTIMEOUT, 4, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, PMC_AES_ECDSARSA_SHA_TRNG_APB_T_MAINTIMEOUT, 3, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, PMC_GLOB_OCMCFG_PPU0_PPU1APB_T_MAINTIMEOUT, 2, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, PMC_LSBUS_REF_CLK_BBRAM_CFU_CRP_ANLG_DMA_APB_T_MAINTIMEOUT, 1, 1)
    FIELD(INT_PMC_TIMEOUT_IMR, PMC_DAP_TAP_APB_T_MAINTIMEOUT, 0, 1)
REG32(INT_PMC_TIMEOUT_IER, 0x98)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_INTPMCIOU_AXI_T_MAINTIMEOUT, 18, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_RTC_APB_T_MAINTIMEOUT, 17, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_PMCGLOBALREG_APB_T_MAINTIMEOUT, 16, 1)
    FIELD(INT_PMC_TIMEOUT_IER, PMC_RST_INTCNTL_APB_T_MAINTIMEOUT, 15, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_SYSMONROOT_APB_T_MAINTIMEOUT, 14, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_CFUREG_APB_T_MAINTIMEOUT, 13, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_PMC_PS_AXI0_T_MAINTIMEOUT, 12, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_PMC_NOC_AXI0_T_MAINTIMEOUT, 11, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_SBI_AXI_T_MAINTIMEOUT, 10, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_PPU1MDMSHD_AXI_T_MAINTIMEOUT, 9, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_PPU0MDMSHD_AXI_T_MAINTIMEOUT, 8, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_PMCOCM_AXI_T_MAINTIMEOUT, 7, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_NPI_AXI_T_MAINTIMEOUT, 6, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_CFUSTREAM_AXI_T_MAINTIMEOUT, 5, 1)
    FIELD(INT_PMC_TIMEOUT_IER, IF_INTPMC_EFUSE_APB_T_MAINTIMEOUT, 4, 1)
    FIELD(INT_PMC_TIMEOUT_IER, PMC_AES_ECDSARSA_SHA_TRNG_APB_T_MAINTIMEOUT, 3, 1)
    FIELD(INT_PMC_TIMEOUT_IER, PMC_GLOB_OCMCFG_PPU0_PPU1APB_T_MAINTIMEOUT, 2, 1)
    FIELD(INT_PMC_TIMEOUT_IER, PMC_LSBUS_REF_CLK_BBRAM_CFU_CRP_ANLG_DMA_APB_T_MAINTIMEOUT, 1, 1)
    FIELD(INT_PMC_TIMEOUT_IER, PMC_DAP_TAP_APB_T_MAINTIMEOUT, 0, 1)
REG32(INT_PMC_TIMEOUT_IDR, 0x9c)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_INTPMCIOU_AXI_T_MAINTIMEOUT, 18, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_RTC_APB_T_MAINTIMEOUT, 17, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_PMCGLOBALREG_APB_T_MAINTIMEOUT, 16, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, PMC_RST_INTCNTL_APB_T_MAINTIMEOUT, 15, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_SYSMONROOT_APB_T_MAINTIMEOUT, 14, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_CFUREG_APB_T_MAINTIMEOUT, 13, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_PMC_PS_AXI0_T_MAINTIMEOUT, 12, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_PMC_NOC_AXI0_T_MAINTIMEOUT, 11, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_SBI_AXI_T_MAINTIMEOUT, 10, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_PPU1MDMSHD_AXI_T_MAINTIMEOUT, 9, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_PPU0MDMSHD_AXI_T_MAINTIMEOUT, 8, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_PMCOCM_AXI_T_MAINTIMEOUT, 7, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_NPI_AXI_T_MAINTIMEOUT, 6, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_CFUSTREAM_AXI_T_MAINTIMEOUT, 5, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, IF_INTPMC_EFUSE_APB_T_MAINTIMEOUT, 4, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, PMC_AES_ECDSARSA_SHA_TRNG_APB_T_MAINTIMEOUT, 3, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, PMC_GLOB_OCMCFG_PPU0_PPU1APB_T_MAINTIMEOUT, 2, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, PMC_LSBUS_REF_CLK_BBRAM_CFU_CRP_ANLG_DMA_APB_T_MAINTIMEOUT, 1, 1)
    FIELD(INT_PMC_TIMEOUT_IDR, PMC_DAP_TAP_APB_T_MAINTIMEOUT, 0, 1)
REG32(INT_PMC_TIMEOUT_ITR, 0xa0)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_INTPMCIOU_AXI_T_MAINTIMEOUT, 18, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_RTC_APB_T_MAINTIMEOUT, 17, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_PMCGLOBALREG_APB_T_MAINTIMEOUT, 16, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, PMC_RST_INTCNTL_APB_T_MAINTIMEOUT, 15, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_SYSMONROOT_APB_T_MAINTIMEOUT, 14, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_CFUREG_APB_T_MAINTIMEOUT, 13, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_PMC_PS_AXI0_T_MAINTIMEOUT, 12, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_PMC_NOC_AXI0_T_MAINTIMEOUT, 11, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_SBI_AXI_T_MAINTIMEOUT, 10, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_PPU1MDMSHD_AXI_T_MAINTIMEOUT, 9, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_PPU0MDMSHD_AXI_T_MAINTIMEOUT, 8, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_PMCOCM_AXI_T_MAINTIMEOUT, 7, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_NPI_AXI_T_MAINTIMEOUT, 6, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_CFUSTREAM_AXI_T_MAINTIMEOUT, 5, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, IF_INTPMC_EFUSE_APB_T_MAINTIMEOUT, 4, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, PMC_AES_ECDSARSA_SHA_TRNG_APB_T_MAINTIMEOUT, 3, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, PMC_GLOB_OCMCFG_PPU0_PPU1APB_T_MAINTIMEOUT, 2, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, PMC_LSBUS_REF_CLK_BBRAM_CFU_CRP_ANLG_DMA_APB_T_MAINTIMEOUT, 1, 1)
    FIELD(INT_PMC_TIMEOUT_ITR, PMC_DAP_TAP_APB_T_MAINTIMEOUT, 0, 1)
REG32(INT_PMC_PARITY_ENTRY_STATUS, 0xa4)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_PS_NOC_RPU_AXI0, 26, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_PS_NOC_RPU_AXI0, 25, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_PS_NOC_RPU_AXI0, 24, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_PS_NOC_PCI_AXI1, 22, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_PS_NOC_PCI_AXI1, 21, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_PS_NOC_PCI_AXI1, 20, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_PS_NOC_PCI_AXI0, 18, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_PS_NOC_PCI_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_PMC_NOC_AXI0, 14, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_PMC_NOC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_INTPMC_NPI_AXI, 10, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_INTPMC_NPI_AXI, 9, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_INTPMC_NPI_AXI, 8, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_NOC_PS_PCI_AXI0, 6, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_NOC_PS_PCI_AXI0, 5, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_NOC_PS_PCI_AXI0, 4, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, POISON_IF_NOC_PMC_AXI0, 2, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, MULT_PERR_IF_NOC_PMC_AXI0, 1, 1)
    FIELD(INT_PMC_PARITY_ENTRY_STATUS, SNGL_PERR_IF_NOC_PMC_AXI0, 0, 1)
REG32(INT_PMC_PARITY_EXIT_STATUS, 0xa8)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_PS_NOC_RPU_AXI0, 26, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_PS_NOC_RPU_AXI0, 25, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_PS_NOC_RPU_AXI0, 24, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_PS_NOC_PCI_AXI1, 22, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_PS_NOC_PCI_AXI1, 21, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_PS_NOC_PCI_AXI1, 20, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_PS_NOC_PCI_AXI0, 18, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_PS_NOC_PCI_AXI0, 17, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_PS_NOC_PCI_AXI0, 16, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_PMC_NOC_AXI0, 14, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_PMC_NOC_AXI0, 13, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_PMC_NOC_AXI0, 12, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_INTPMC_NPI_AXI, 10, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_INTPMC_NPI_AXI, 9, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_INTPMC_NPI_AXI, 8, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_NOC_PS_PCI_AXI0, 6, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_NOC_PS_PCI_AXI0, 5, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_NOC_PS_PCI_AXI0, 4, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, POISON_IF_NOC_PMC_AXI0, 2, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, MULT_PERR_IF_NOC_PMC_AXI0, 1, 1)
    FIELD(INT_PMC_PARITY_EXIT_STATUS, SNGL_PERR_IF_NOC_PMC_AXI0, 0, 1)
REG32(MISC_CONTROL, 0xac)
    FIELD(MISC_CONTROL, XMPU_ALIGN_CFG, 0, 1)
REG32(PMC_DAP_TAP_APB, 0x10000)
    FIELD(PMC_DAP_TAP_APB, RAW_RST_N, 4, 1)
    FIELD(PMC_DAP_TAP_APB, POWER_IDLEREQ, 3, 1)
    FIELD(PMC_DAP_TAP_APB, POWER_IDLEACK, 2, 1)
    FIELD(PMC_DAP_TAP_APB, POWER_IDLE, 1, 1)
    FIELD(PMC_DAP_TAP_APB, MAINEXTEN, 0, 1)
REG32(BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB, 0x20000)
    FIELD(BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB, RAW_RST_N, 4, 1)
    FIELD(BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB, POWER_IDLEREQ, 3, 1)
    FIELD(BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB, POWER_IDLEACK, 2, 1)
    FIELD(BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB, POWER_IDLE, 1, 1)
    FIELD(BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB, MAINEXTEN, 0, 1)
REG32(PPU0_PPU1_APB, 0x30000)
    FIELD(PPU0_PPU1_APB, RAW_RST_N, 4, 1)
    FIELD(PPU0_PPU1_APB, POWER_IDLEREQ, 3, 1)
    FIELD(PPU0_PPU1_APB, POWER_IDLEACK, 2, 1)
    FIELD(PPU0_PPU1_APB, POWER_IDLE, 1, 1)
    FIELD(PPU0_PPU1_APB, MAINEXTEN, 0, 1)
REG32(AES_ECDSARSA_SHA_TRNG_APB, 0x40000)
    FIELD(AES_ECDSARSA_SHA_TRNG_APB, RAW_RST_N, 4, 1)
    FIELD(AES_ECDSARSA_SHA_TRNG_APB, POWER_IDLEREQ, 3, 1)
    FIELD(AES_ECDSARSA_SHA_TRNG_APB, POWER_IDLEACK, 2, 1)
    FIELD(AES_ECDSARSA_SHA_TRNG_APB, POWER_IDLE, 1, 1)
    FIELD(AES_ECDSARSA_SHA_TRNG_APB, MAINEXTEN, 0, 1)
REG32(EFUSE_APB, 0x50000)
    FIELD(EFUSE_APB, RAW_RST_N, 4, 1)
    FIELD(EFUSE_APB, POWER_IDLEREQ, 3, 1)
    FIELD(EFUSE_APB, POWER_IDLEACK, 2, 1)
    FIELD(EFUSE_APB, POWER_IDLE, 1, 1)
    FIELD(EFUSE_APB, MAINEXTEN, 0, 1)
REG32(CFUSTREAM_AXI, 0x60000)
    FIELD(CFUSTREAM_AXI, RAW_RST_N, 4, 1)
    FIELD(CFUSTREAM_AXI, POWER_IDLEREQ, 3, 1)
    FIELD(CFUSTREAM_AXI, POWER_IDLEACK, 2, 1)
    FIELD(CFUSTREAM_AXI, POWER_IDLE, 1, 1)
    FIELD(CFUSTREAM_AXI, MAINEXTEN, 0, 1)
REG32(NPI_AXI, 0x70000)
    FIELD(NPI_AXI, RAW_RST_N, 4, 1)
    FIELD(NPI_AXI, POWER_IDLEREQ, 3, 1)
    FIELD(NPI_AXI, POWER_IDLEACK, 2, 1)
    FIELD(NPI_AXI, POWER_IDLE, 1, 1)
    FIELD(NPI_AXI, MAINEXTEN, 0, 1)
REG32(PMCOCM_AXI, 0x80000)
    FIELD(PMCOCM_AXI, RAW_RST_N, 4, 1)
    FIELD(PMCOCM_AXI, POWER_IDLEREQ, 3, 1)
    FIELD(PMCOCM_AXI, POWER_IDLEACK, 2, 1)
    FIELD(PMCOCM_AXI, POWER_IDLE, 1, 1)
    FIELD(PMCOCM_AXI, MAINEXTEN, 0, 1)
REG32(PPU1MDMSHD_AXI, 0xa0000)
    FIELD(PPU1MDMSHD_AXI, RAW_RST_N, 4, 1)
    FIELD(PPU1MDMSHD_AXI, POWER_IDLEREQ, 3, 1)
    FIELD(PPU1MDMSHD_AXI, POWER_IDLEACK, 2, 1)
    FIELD(PPU1MDMSHD_AXI, POWER_IDLE, 1, 1)
    FIELD(PPU1MDMSHD_AXI, MAINEXTEN, 0, 1)
REG32(SBI_AXI, 0xb0000)
    FIELD(SBI_AXI, RAW_RST_N, 4, 1)
    FIELD(SBI_AXI, POWER_IDLEREQ, 3, 1)
    FIELD(SBI_AXI, POWER_IDLEACK, 2, 1)
    FIELD(SBI_AXI, POWER_IDLE, 1, 1)
    FIELD(SBI_AXI, MAINEXTEN, 0, 1)
REG32(PMC_NOC_AXI0, 0xc0000)
    FIELD(PMC_NOC_AXI0, RAW_RST_N, 4, 1)
    FIELD(PMC_NOC_AXI0, POWER_IDLEREQ, 3, 1)
    FIELD(PMC_NOC_AXI0, POWER_IDLEACK, 2, 1)
    FIELD(PMC_NOC_AXI0, POWER_IDLE, 1, 1)
    FIELD(PMC_NOC_AXI0, MAINEXTEN, 0, 1)
REG32(PMC_PS_AXI0, 0xd0000)
    FIELD(PMC_PS_AXI0, RAW_RST_N, 4, 1)
    FIELD(PMC_PS_AXI0, POWER_IDLEREQ, 3, 1)
    FIELD(PMC_PS_AXI0, POWER_IDLEACK, 2, 1)
    FIELD(PMC_PS_AXI0, POWER_IDLE, 1, 1)
    FIELD(PMC_PS_AXI0, MAINEXTEN, 0, 1)
REG32(SYSMONROOT_APB, 0xe0000)
    FIELD(SYSMONROOT_APB, RAW_RST_N, 4, 1)
    FIELD(SYSMONROOT_APB, POWER_IDLEREQ, 3, 1)
    FIELD(SYSMONROOT_APB, POWER_IDLEACK, 2, 1)
    FIELD(SYSMONROOT_APB, POWER_IDLE, 1, 1)
    FIELD(SYSMONROOT_APB, MAINEXTEN, 0, 1)
REG32(CFU_APB, 0xf0000)
    FIELD(CFU_APB, RAW_RST_N, 4, 1)
    FIELD(CFU_APB, POWER_IDLEREQ, 3, 1)
    FIELD(CFU_APB, POWER_IDLEACK, 2, 1)
    FIELD(CFU_APB, POWER_IDLE, 1, 1)
    FIELD(CFU_APB, MAINEXTEN, 0, 1)
REG32(PMCGLOBALREG_APB, 0x110000)
    FIELD(PMCGLOBALREG_APB, RAW_RST_N, 4, 1)
    FIELD(PMCGLOBALREG_APB, POWER_IDLEREQ, 3, 1)
    FIELD(PMCGLOBALREG_APB, POWER_IDLEACK, 2, 1)
    FIELD(PMCGLOBALREG_APB, POWER_IDLE, 1, 1)
    FIELD(PMCGLOBALREG_APB, MAINEXTEN, 0, 1)
REG32(RTC_APB, 0x120000)
    FIELD(RTC_APB, RAW_RST_N, 4, 1)
    FIELD(RTC_APB, POWER_IDLEREQ, 3, 1)
    FIELD(RTC_APB, POWER_IDLEACK, 2, 1)
    FIELD(RTC_APB, POWER_IDLE, 1, 1)
    FIELD(RTC_APB, MAINEXTEN, 0, 1)
REG32(PMC_TZ_CTRL, 0x230000)
    FIELD(PMC_TZ_CTRL, INTPMC_CONFIG, 21, 1)
    FIELD(PMC_TZ_CTRL, PMC_XPPU, 20, 1)
    FIELD(PMC_TZ_CTRL, PMC_XPPU_NPI, 19, 1)
    FIELD(PMC_TZ_CTRL, PMC_XMPU, 18, 1)
    FIELD(PMC_TZ_CTRL, CFU_APB, 17, 1)
    FIELD(PMC_TZ_CTRL, RTC, 16, 1)
    FIELD(PMC_TZ_CTRL, PMC_SYSMON, 15, 1)
    FIELD(PMC_TZ_CTRL, CRP, 14, 1)
    FIELD(PMC_TZ_CTRL, EFUSE_CACHE, 13, 1)
    FIELD(PMC_TZ_CTRL, EFUSE_CTRL, 12, 1)
    FIELD(PMC_TZ_CTRL, TRNG, 11, 1)
    FIELD(PMC_TZ_CTRL, SLAVE_BOOT, 10, 1)
    FIELD(PMC_TZ_CTRL, SHA3, 9, 1)
    FIELD(PMC_TZ_CTRL, ECDSA_RSA, 8, 1)
    FIELD(PMC_TZ_CTRL, BBRAM_CTRL, 7, 1)
    FIELD(PMC_TZ_CTRL, AES, 6, 1)
    FIELD(PMC_TZ_CTRL, PMC_DMA1, 5, 1)
    FIELD(PMC_TZ_CTRL, PMC_DMA0, 4, 1)
    FIELD(PMC_TZ_CTRL, PMC_TAP, 3, 1)
    FIELD(PMC_TZ_CTRL, PMC_ANALOG, 2, 1)
    FIELD(PMC_TZ_CTRL, PMC_GLOBAL, 1, 1)
    FIELD(PMC_TZ_CTRL, PMC_RAM_CFG, 0, 1)
REG32(PMC_TZ_CTRL_LOCK, 0x230004)
    FIELD(PMC_TZ_CTRL_LOCK, TZ_CTRL_LOCK, 0, 1)
REG32(PMC_IOU_AXI, 0x240000)
    FIELD(PMC_IOU_AXI, RAW_RST_N, 4, 1)
    FIELD(PMC_IOU_AXI, POWER_IDLEREQ, 3, 1)
    FIELD(PMC_IOU_AXI, POWER_IDLEACK, 2, 1)
    FIELD(PMC_IOU_AXI, POWER_IDLE, 1, 1)
    FIELD(PMC_IOU_AXI, MAINEXTEN, 0, 1)

#define PMC_INT_REGS_R_MAX (R_PMC_IOU_AXI + 1)

typedef struct PMC_INT_REGS {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_int_pmc_timeout_imr;
    qemu_irq irq_int_pmc_parity1_imr;
    qemu_irq irq_ir;
    qemu_irq irq_int_pmc_parity0_imr;
    qemu_irq irq_int_pmc_mission_imr;

    uint32_t regs[PMC_INT_REGS_R_MAX];
    RegisterInfo regs_info[PMC_INT_REGS_R_MAX];
} PMC_INT_REGS;

static void int_pmc_timeout_imr_update_irq(PMC_INT_REGS *s)
{
    bool pending = s->regs[R_INT_PMC_TIMEOUT_ISR] & ~s->regs[R_INT_PMC_TIMEOUT_IMR];
    qemu_set_irq(s->irq_int_pmc_timeout_imr, pending);
}

static void int_pmc_timeout_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    int_pmc_timeout_imr_update_irq(s);
}

static uint64_t int_pmc_timeout_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_TIMEOUT_IMR] &= ~val;
    int_pmc_timeout_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_timeout_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_TIMEOUT_IMR] |= val;
    int_pmc_timeout_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_timeout_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_TIMEOUT_ISR] |= val;
    int_pmc_timeout_imr_update_irq(s);
    return 0;
}

static void int_pmc_parity1_imr_update_irq(PMC_INT_REGS *s)
{
    bool pending = s->regs[R_INT_PMC_PARITY1_ISR] & ~s->regs[R_INT_PMC_PARITY1_IMR];
    qemu_set_irq(s->irq_int_pmc_parity1_imr, pending);
}

static void int_pmc_parity1_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    int_pmc_parity1_imr_update_irq(s);
}

static uint64_t int_pmc_parity1_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_PARITY1_IMR] &= ~val;
    int_pmc_parity1_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_parity1_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_PARITY1_IMR] |= val;
    int_pmc_parity1_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_parity1_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_PARITY1_ISR] |= val;
    int_pmc_parity1_imr_update_irq(s);
    return 0;
}

static void ir_update_irq(PMC_INT_REGS *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static void int_pmc_parity0_imr_update_irq(PMC_INT_REGS *s)
{
    bool pending = s->regs[R_INT_PMC_PARITY0_ISR] & ~s->regs[R_INT_PMC_PARITY0_IMR];
    qemu_set_irq(s->irq_int_pmc_parity0_imr, pending);
}

static void int_pmc_parity0_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    int_pmc_parity0_imr_update_irq(s);
}

static uint64_t int_pmc_parity0_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_PARITY0_IMR] &= ~val;
    int_pmc_parity0_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_parity0_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_PARITY0_IMR] |= val;
    int_pmc_parity0_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_parity0_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_PARITY0_ISR] |= val;
    int_pmc_parity0_imr_update_irq(s);
    return 0;
}

static void int_pmc_mission_imr_update_irq(PMC_INT_REGS *s)
{
    bool pending = s->regs[R_INT_PMC_MISSION_ISR] & ~s->regs[R_INT_PMC_MISSION_IMR];
    qemu_set_irq(s->irq_int_pmc_mission_imr, pending);
}

static void int_pmc_mission_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    int_pmc_mission_imr_update_irq(s);
}

static uint64_t int_pmc_mission_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_MISSION_IMR] &= ~val;
    int_pmc_mission_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_mission_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_MISSION_IMR] |= val;
    int_pmc_mission_imr_update_irq(s);
    return 0;
}

static uint64_t int_pmc_mission_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INT_PMC_MISSION_ISR] |= val;
    int_pmc_mission_imr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo pmc_int_regs_regs_info[] = {
    {   .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xffffffe0,
        .w1c = 0xffffffff,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1f,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xffffffe0,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xffffffe0,
        .pre_write = ir_disable_prew,
    },{ .name = "JTAGDAP",  .addr = A_JTAGDAP,
        .rsvd = 0xfffffffe,
    },{ .name = "PMCDMA0",  .addr = A_PMCDMA0,
        .rsvd = 0xfffffffe,
    },{ .name = "PMCDMA1",  .addr = A_PMCDMA1,
        .rsvd = 0xfffffffe,
    },{ .name = "PPU1",  .addr = A_PPU1,
        .rsvd = 0xfffffffe,
    },{ .name = "SYSMON",  .addr = A_SYSMON,
        .rsvd = 0xfffffffe,
    },{ .name = "INT_PMC_PARITY0_ISR",  .addr = A_INT_PMC_PARITY0_ISR,
        .rsvd = 0xfe000000,
        .w1c = 0xffffffff,
        .post_write = int_pmc_parity0_isr_postw,
    },{ .name = "INT_PMC_PARITY0_IMR",  .addr = A_INT_PMC_PARITY0_IMR,
        .reset = 0x1ffffff,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "INT_PMC_PARITY0_IER",  .addr = A_INT_PMC_PARITY0_IER,
        .rsvd = 0xfe000000,
        .pre_write = int_pmc_parity0_ier_prew,
    },{ .name = "INT_PMC_PARITY0_IDR",  .addr = A_INT_PMC_PARITY0_IDR,
        .rsvd = 0xfe000000,
        .pre_write = int_pmc_parity0_idr_prew,
    },{ .name = "INT_PMC_PARITY0_ITR",  .addr = A_INT_PMC_PARITY0_ITR,
        .rsvd = 0xfe000000,
        .pre_write = int_pmc_parity0_itr_prew,
    },{ .name = "INT_PMC_PARITY1_ISR",  .addr = A_INT_PMC_PARITY1_ISR,
        .rsvd = 0xfff80000,
        .w1c = 0xffffffff,
        .post_write = int_pmc_parity1_isr_postw,
    },{ .name = "INT_PMC_PARITY1_IMR",  .addr = A_INT_PMC_PARITY1_IMR,
        .reset = 0x7ffff,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "INT_PMC_PARITY1_IER",  .addr = A_INT_PMC_PARITY1_IER,
        .rsvd = 0xfff80000,
        .pre_write = int_pmc_parity1_ier_prew,
    },{ .name = "INT_PMC_PARITY1_IDR",  .addr = A_INT_PMC_PARITY1_IDR,
        .rsvd = 0xfff80000,
        .pre_write = int_pmc_parity1_idr_prew,
    },{ .name = "INT_PMC_PARITY1_ITR",  .addr = A_INT_PMC_PARITY1_ITR,
        .rsvd = 0xfff80000,
        .pre_write = int_pmc_parity1_itr_prew,
    },{ .name = "INT_PMC_MISSION_ISR",  .addr = A_INT_PMC_MISSION_ISR,
        .rsvd = 0xc0000000,
        .w1c = 0xffffffff,
        .post_write = int_pmc_mission_isr_postw,
    },{ .name = "INT_PMC_MISSION_IMR",  .addr = A_INT_PMC_MISSION_IMR,
        .reset = 0x3fffffff,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "INT_PMC_MISSION_IER",  .addr = A_INT_PMC_MISSION_IER,
        .rsvd = 0xc0000000,
        .pre_write = int_pmc_mission_ier_prew,
    },{ .name = "INT_PMC_MISSION_IDR",  .addr = A_INT_PMC_MISSION_IDR,
        .rsvd = 0xc0000000,
        .pre_write = int_pmc_mission_idr_prew,
    },{ .name = "INT_PMC_MISSION_ITR",  .addr = A_INT_PMC_MISSION_ITR,
        .rsvd = 0xc0000000,
        .pre_write = int_pmc_mission_itr_prew,
    },{ .name = "INT_PMC_TIMEOUT_ISR",  .addr = A_INT_PMC_TIMEOUT_ISR,
        .rsvd = 0xfff80000,
        .w1c = 0xffffffff,
        .post_write = int_pmc_timeout_isr_postw,
    },{ .name = "INT_PMC_TIMEOUT_IMR",  .addr = A_INT_PMC_TIMEOUT_IMR,
        .reset = 0x7ffff,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "INT_PMC_TIMEOUT_IER",  .addr = A_INT_PMC_TIMEOUT_IER,
        .rsvd = 0xfff80000,
        .pre_write = int_pmc_timeout_ier_prew,
    },{ .name = "INT_PMC_TIMEOUT_IDR",  .addr = A_INT_PMC_TIMEOUT_IDR,
        .rsvd = 0xfff80000,
        .pre_write = int_pmc_timeout_idr_prew,
    },{ .name = "INT_PMC_TIMEOUT_ITR",  .addr = A_INT_PMC_TIMEOUT_ITR,
        .rsvd = 0xfff80000,
        .pre_write = int_pmc_timeout_itr_prew,
    },{ .name = "INT_PMC_PARITY_ENTRY_STATUS",
        .addr = A_INT_PMC_PARITY_ENTRY_STATUS,
        .rsvd = 0xf8888888,
        .w1c = 0xffffffff,
    },{ .name = "INT_PMC_PARITY_EXIT_STATUS",
        .addr = A_INT_PMC_PARITY_EXIT_STATUS,
        .rsvd = 0xf8888888,
        .w1c = 0xffffffff,
    },{ .name = "MISC_CONTROL",  .addr = A_MISC_CONTROL,
        .rsvd = 0xfffffffe,
    },{ .name = "PMC_DAP_TAP_APB",  .addr = A_PMC_DAP_TAP_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB",
        .addr = A_BBRAM_CFU_CRP_ANLG_DMA_RTC_SBI_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PPU0_PPU1_APB",  .addr = A_PPU0_PPU1_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "AES_ECDSARSA_SHA_TRNG_APB",
        .addr = A_AES_ECDSARSA_SHA_TRNG_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "EFUSE_APB",  .addr = A_EFUSE_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "CFUSTREAM_AXI",  .addr = A_CFUSTREAM_AXI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "NPI_AXI",  .addr = A_NPI_AXI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PMCOCM_AXI",  .addr = A_PMCOCM_AXI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PPU1MDMSHD_AXI",  .addr = A_PPU1MDMSHD_AXI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "SBI_AXI",  .addr = A_SBI_AXI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PMC_NOC_AXI0",  .addr = A_PMC_NOC_AXI0,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PMC_PS_AXI0",  .addr = A_PMC_PS_AXI0,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "SYSMONROOT_APB",  .addr = A_SYSMONROOT_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "CFU_APB",  .addr = A_CFU_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PMCGLOBALREG_APB",  .addr = A_PMCGLOBALREG_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "RTC_APB",  .addr = A_RTC_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PMC_TZ_CTRL",  .addr = A_PMC_TZ_CTRL,
        .reset = 0xffffffff,
        .rsvd = 0xffc00000,
    },{ .name = "PMC_TZ_CTRL_LOCK",  .addr = A_PMC_TZ_CTRL_LOCK,
    },{ .name = "PMC_IOU_AXI",  .addr = A_PMC_IOU_AXI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    }
};

static void pmc_int_regs_reset(DeviceState *dev)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    int_pmc_timeout_imr_update_irq(s);
    int_pmc_parity1_imr_update_irq(s);
    ir_update_irq(s);
    int_pmc_parity0_imr_update_irq(s);
    int_pmc_mission_imr_update_irq(s);
}

static const MemoryRegionOps pmc_int_regs_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmc_int_regs_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void pmc_int_regs_init(Object *obj)
{
    PMC_INT_REGS *s = XILINX_PMC_INT_REGS(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMC_INT_REGS, PMC_INT_REGS_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmc_int_regs_regs_info,
                              ARRAY_SIZE(pmc_int_regs_regs_info),
                              s->regs_info, s->regs,
                              &pmc_int_regs_ops,
                              XILINX_PMC_INT_REGS_ERR_DEBUG,
                              PMC_INT_REGS_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_int_pmc_timeout_imr);
    sysbus_init_irq(sbd, &s->irq_int_pmc_parity1_imr);
    sysbus_init_irq(sbd, &s->irq_ir);
    sysbus_init_irq(sbd, &s->irq_int_pmc_parity0_imr);
    sysbus_init_irq(sbd, &s->irq_int_pmc_mission_imr);
}

static const VMStateDescription vmstate_pmc_int_regs = {
    .name = TYPE_XILINX_PMC_INT_REGS,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMC_INT_REGS, PMC_INT_REGS_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmc_int_regs_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pmc_int_regs_reset;
    dc->realize = pmc_int_regs_realize;
    dc->vmsd = &vmstate_pmc_int_regs;
}

static const TypeInfo pmc_int_regs_info = {
    .name          = TYPE_XILINX_PMC_INT_REGS,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMC_INT_REGS),
    .class_init    = pmc_int_regs_class_init,
    .instance_init = pmc_int_regs_init,
};

static void pmc_int_regs_register_types(void)
{
    type_register_static(&pmc_int_regs_info);
}

type_init(pmc_int_regs_register_types)
