/*
 * QEMU model of the PMC_GLOBAL This is the database for the PMC Error
 * Management Register Definitions.
 *
 * Copyright (c) 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-12-10.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_PMC_GLOBAL_ERR_DEBUG
#define XILINX_PMC_GLOBAL_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMC_GLOBAL "xlnx.PmcErrMngmnt"

#define XILINX_PMC_GLOBAL(obj) \
     OBJECT_CHECK(PmcErrMngmnt, (obj), TYPE_XILINX_PMC_GLOBAL)

REG32(PMC_ERR1_STATUS, 0x0)
    FIELD(PMC_ERR1_STATUS, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR1_STATUS, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR1_STATUS, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR1_STATUS, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR1_STATUS, PL3, 27, 1)
    FIELD(PMC_ERR1_STATUS, PL2, 26, 1)
    FIELD(PMC_ERR1_STATUS, PL1, 25, 1)
    FIELD(PMC_ERR1_STATUS, PL0, 24, 1)
    FIELD(PMC_ERR1_STATUS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR1_STATUS, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR1_STATUS, GT_NCR, 21, 1)
    FIELD(PMC_ERR1_STATUS, GT_CR, 20, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR1_STATUS, ME_NCR, 17, 1)
    FIELD(PMC_ERR1_STATUS, ME_CR, 16, 1)
    FIELD(PMC_ERR1_STATUS, MMCM, 15, 1)
    FIELD(PMC_ERR1_STATUS, NOC_USER, 14, 1)
    FIELD(PMC_ERR1_STATUS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR1_STATUS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR1_STATUS, PSM_NCR, 9, 1)
    FIELD(PMC_ERR1_STATUS, PSM_CR, 8, 1)
    FIELD(PMC_ERR1_STATUS, CFRAME, 7, 1)
    FIELD(PMC_ERR1_STATUS, CFU, 6, 1)
    FIELD(PMC_ERR1_STATUS, GSW_NCR, 5, 1)
    FIELD(PMC_ERR1_STATUS, GSW_CR, 4, 1)
    FIELD(PMC_ERR1_STATUS, FW_NCR, 3, 1)
    FIELD(PMC_ERR1_STATUS, FW_CR, 2, 1)
    FIELD(PMC_ERR1_STATUS, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR1_STATUS, BOOT_CR, 0, 1)
REG32(PMC_ERR2_STATUS, 0x4)
    FIELD(PMC_ERR2_STATUS, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR2_STATUS, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR2_STATUS, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR2_STATUS, PMC_XPPU, 28, 1)
    FIELD(PMC_ERR2_STATUS, PMC_XMPU, 27, 1)
    FIELD(PMC_ERR2_STATUS, PMC_TO, 26, 1)
    FIELD(PMC_ERR2_STATUS, CLK_MON, 25, 1)
    FIELD(PMC_ERR2_STATUS, PPLL, 24, 1)
    FIELD(PMC_ERR2_STATUS, NPLL, 23, 1)
    FIELD(PMC_ERR2_STATUS, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR2_STATUS, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR2_STATUS, RSRV_ERR0, 20, 1)
    FIELD(PMC_ERR2_STATUS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR2_STATUS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR2_STATUS, CFI, 17, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON7, 14, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON6, 13, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON5, 12, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR2_STATUS, PMC_NCR, 6, 1)
    FIELD(PMC_ERR2_STATUS, PMC_CR, 5, 1)
    FIELD(PMC_ERR2_STATUS, PMC_PAR, 4, 1)
    FIELD(PMC_ERR2_STATUS, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR2_STATUS, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR2_STATUS, PMC_ROM, 1, 1)
    FIELD(PMC_ERR2_STATUS, PMC_APB, 0, 1)
REG32(PMC_ERR1_TRIG, 0x10)
    FIELD(PMC_ERR1_TRIG, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR1_TRIG, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR1_TRIG, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR1_TRIG, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR1_TRIG, PL3, 27, 1)
    FIELD(PMC_ERR1_TRIG, PL2, 26, 1)
    FIELD(PMC_ERR1_TRIG, PL1, 25, 1)
    FIELD(PMC_ERR1_TRIG, PL0, 24, 1)
    FIELD(PMC_ERR1_TRIG, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR1_TRIG, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR1_TRIG, GT_NCR, 21, 1)
    FIELD(PMC_ERR1_TRIG, GT_CR, 20, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR1_TRIG, ME_NCR, 17, 1)
    FIELD(PMC_ERR1_TRIG, ME_CR, 16, 1)
    FIELD(PMC_ERR1_TRIG, MMCM, 15, 1)
    FIELD(PMC_ERR1_TRIG, NOC_USER, 14, 1)
    FIELD(PMC_ERR1_TRIG, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR1_TRIG, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR1_TRIG, PSM_NCR, 9, 1)
    FIELD(PMC_ERR1_TRIG, PSM_CR, 8, 1)
    FIELD(PMC_ERR1_TRIG, CFRAME, 7, 1)
    FIELD(PMC_ERR1_TRIG, CFU, 6, 1)
    FIELD(PMC_ERR1_TRIG, GSW_NCR, 5, 1)
    FIELD(PMC_ERR1_TRIG, GSW_CR, 4, 1)
    FIELD(PMC_ERR1_TRIG, FW_NCR, 3, 1)
    FIELD(PMC_ERR1_TRIG, FW_CR, 2, 1)
    FIELD(PMC_ERR1_TRIG, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR1_TRIG, BOOT_CR, 0, 1)
REG32(PMC_ERR2_TRIG, 0x14)
    FIELD(PMC_ERR2_TRIG, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR2_TRIG, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR2_TRIG, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR2_TRIG, PMC_XPPU, 28, 1)
    FIELD(PMC_ERR2_TRIG, PMC_XMPU, 27, 1)
    FIELD(PMC_ERR2_TRIG, PMC_TO, 26, 1)
    FIELD(PMC_ERR2_TRIG, CLK_MON, 25, 1)
    FIELD(PMC_ERR2_TRIG, PPLL, 24, 1)
    FIELD(PMC_ERR2_TRIG, NPLL, 23, 1)
    FIELD(PMC_ERR2_TRIG, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR2_TRIG, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR2_TRIG, RSRV_ERR0, 20, 1)
    FIELD(PMC_ERR2_TRIG, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR2_TRIG, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR2_TRIG, CFI, 17, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON7, 14, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON6, 13, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON5, 12, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR2_TRIG, PMC_NCR, 6, 1)
    FIELD(PMC_ERR2_TRIG, PMC_CR, 5, 1)
    FIELD(PMC_ERR2_TRIG, PMC_PAR, 4, 1)
    FIELD(PMC_ERR2_TRIG, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR2_TRIG, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR2_TRIG, PMC_ROM, 1, 1)
    FIELD(PMC_ERR2_TRIG, PMC_APB, 0, 1)
REG32(PMC_ERR_OUT1_MASK, 0x20)
    FIELD(PMC_ERR_OUT1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR_OUT1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR_OUT1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR_OUT1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL3, 27, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL2, 26, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL1, 25, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL0, 24, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR_OUT1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_ERR_OUT1_MASK, GT_CR, 20, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR_OUT1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_ERR_OUT1_MASK, ME_CR, 16, 1)
    FIELD(PMC_ERR_OUT1_MASK, MMCM, 15, 1)
    FIELD(PMC_ERR_OUT1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_ERR_OUT1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR_OUT1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR_OUT1_MASK, PSM_NCR, 9, 1)
    FIELD(PMC_ERR_OUT1_MASK, PSM_CR, 8, 1)
    FIELD(PMC_ERR_OUT1_MASK, CFRAME, 7, 1)
    FIELD(PMC_ERR_OUT1_MASK, CFU, 6, 1)
    FIELD(PMC_ERR_OUT1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_ERR_OUT1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_ERR_OUT1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_ERR_OUT1_MASK, FW_CR, 2, 1)
    FIELD(PMC_ERR_OUT1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR_OUT1_MASK, BOOT_CR, 0, 1)
REG32(PMC_ERR_OUT1_EN, 0x24)
    FIELD(PMC_ERR_OUT1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR_OUT1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR_OUT1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR_OUT1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR_OUT1_EN, PL3, 27, 1)
    FIELD(PMC_ERR_OUT1_EN, PL2, 26, 1)
    FIELD(PMC_ERR_OUT1_EN, PL1, 25, 1)
    FIELD(PMC_ERR_OUT1_EN, PL0, 24, 1)
    FIELD(PMC_ERR_OUT1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR_OUT1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR_OUT1_EN, GT_NCR, 21, 1)
    FIELD(PMC_ERR_OUT1_EN, GT_CR, 20, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR_OUT1_EN, ME_NCR, 17, 1)
    FIELD(PMC_ERR_OUT1_EN, ME_CR, 16, 1)
    FIELD(PMC_ERR_OUT1_EN, MMCM, 15, 1)
    FIELD(PMC_ERR_OUT1_EN, NOC_USER, 14, 1)
    FIELD(PMC_ERR_OUT1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR_OUT1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR_OUT1_EN, PSM_NCR, 9, 1)
    FIELD(PMC_ERR_OUT1_EN, PSM_CR, 8, 1)
    FIELD(PMC_ERR_OUT1_EN, CFRAME, 7, 1)
    FIELD(PMC_ERR_OUT1_EN, CFU, 6, 1)
    FIELD(PMC_ERR_OUT1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_ERR_OUT1_EN, GSW_CR, 4, 1)
    FIELD(PMC_ERR_OUT1_EN, FW_NCR, 3, 1)
    FIELD(PMC_ERR_OUT1_EN, FW_CR, 2, 1)
    FIELD(PMC_ERR_OUT1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR_OUT1_EN, BOOT_CR, 0, 1)
REG32(PMC_ERR_OUT1_DIS, 0x28)
    FIELD(PMC_ERR_OUT1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR_OUT1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR_OUT1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR_OUT1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL3, 27, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL2, 26, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL1, 25, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL0, 24, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR_OUT1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_ERR_OUT1_DIS, GT_CR, 20, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR_OUT1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_ERR_OUT1_DIS, ME_CR, 16, 1)
    FIELD(PMC_ERR_OUT1_DIS, MMCM, 15, 1)
    FIELD(PMC_ERR_OUT1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_ERR_OUT1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR_OUT1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR_OUT1_DIS, PSM_NCR, 9, 1)
    FIELD(PMC_ERR_OUT1_DIS, PSM_CR, 8, 1)
    FIELD(PMC_ERR_OUT1_DIS, CFRAME, 7, 1)
    FIELD(PMC_ERR_OUT1_DIS, CFU, 6, 1)
    FIELD(PMC_ERR_OUT1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_ERR_OUT1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_ERR_OUT1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_ERR_OUT1_DIS, FW_CR, 2, 1)
    FIELD(PMC_ERR_OUT1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR_OUT1_DIS, BOOT_CR, 0, 1)
REG32(PMC_ERR_OUT2_MASK, 0x30)
    FIELD(PMC_ERR_OUT2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR_OUT2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR_OUT2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_XPPU, 28, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_XMPU, 27, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_TO, 26, 1)
    FIELD(PMC_ERR_OUT2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_ERR_OUT2_MASK, PPLL, 24, 1)
    FIELD(PMC_ERR_OUT2_MASK, NPLL, 23, 1)
    FIELD(PMC_ERR_OUT2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR_OUT2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR_OUT2_MASK, RSRV_ERR0, 20, 1)
    FIELD(PMC_ERR_OUT2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR_OUT2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR_OUT2_MASK, CFI, 17, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON7, 14, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON6, 13, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON5, 12, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_PAR, 4, 1)
    FIELD(PMC_ERR_OUT2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR_OUT2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_APB, 0, 1)
REG32(PMC_ERR_OUT2_EN, 0x34)
    FIELD(PMC_ERR_OUT2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR_OUT2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR_OUT2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_XPPU, 28, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_XMPU, 27, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_TO, 26, 1)
    FIELD(PMC_ERR_OUT2_EN, CLK_MON, 25, 1)
    FIELD(PMC_ERR_OUT2_EN, PPLL, 24, 1)
    FIELD(PMC_ERR_OUT2_EN, NPLL, 23, 1)
    FIELD(PMC_ERR_OUT2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR_OUT2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR_OUT2_EN, RSRV_ERR0, 20, 1)
    FIELD(PMC_ERR_OUT2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR_OUT2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR_OUT2_EN, CFI, 17, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON7, 14, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON6, 13, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON5, 12, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_CR, 5, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_PAR, 4, 1)
    FIELD(PMC_ERR_OUT2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR_OUT2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_APB, 0, 1)
REG32(PMC_ERR_OUT2_DIS, 0x38)
    FIELD(PMC_ERR_OUT2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR_OUT2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR_OUT2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_XPPU, 28, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_XMPU, 27, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_TO, 26, 1)
    FIELD(PMC_ERR_OUT2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_ERR_OUT2_DIS, PPLL, 24, 1)
    FIELD(PMC_ERR_OUT2_DIS, NPLL, 23, 1)
    FIELD(PMC_ERR_OUT2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR_OUT2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR_OUT2_DIS, RSRV_ERR0, 20, 1)
    FIELD(PMC_ERR_OUT2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR_OUT2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR_OUT2_DIS, CFI, 17, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON7, 14, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON6, 13, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON5, 12, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_PAR, 4, 1)
    FIELD(PMC_ERR_OUT2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR_OUT2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_APB, 0, 1)
REG32(PMC_POR1_MASK, 0x40)
    FIELD(PMC_POR1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_POR1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_POR1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_POR1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_POR1_MASK, PL3, 27, 1)
    FIELD(PMC_POR1_MASK, PL2, 26, 1)
    FIELD(PMC_POR1_MASK, PL1, 25, 1)
    FIELD(PMC_POR1_MASK, PL0, 24, 1)
    FIELD(PMC_POR1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_POR1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_POR1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_POR1_MASK, GT_CR, 20, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_POR1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_POR1_MASK, ME_CR, 16, 1)
    FIELD(PMC_POR1_MASK, MMCM, 15, 1)
    FIELD(PMC_POR1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_POR1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_POR1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_POR1_MASK, PSM_NCR, 9, 1)
    FIELD(PMC_POR1_MASK, PSM_CR, 8, 1)
    FIELD(PMC_POR1_MASK, CFRAME, 7, 1)
    FIELD(PMC_POR1_MASK, CFU, 6, 1)
    FIELD(PMC_POR1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_POR1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_POR1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_POR1_MASK, FW_CR, 2, 1)
    FIELD(PMC_POR1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_POR1_MASK, BOOT_CR, 0, 1)
REG32(PMC_POR1_EN, 0x44)
    FIELD(PMC_POR1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_POR1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_POR1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_POR1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_POR1_EN, PL3, 27, 1)
    FIELD(PMC_POR1_EN, PL2, 26, 1)
    FIELD(PMC_POR1_EN, PL1, 25, 1)
    FIELD(PMC_POR1_EN, PL0, 24, 1)
    FIELD(PMC_POR1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_POR1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_POR1_EN, GT_NCR, 21, 1)
    FIELD(PMC_POR1_EN, GT_CR, 20, 1)
    FIELD(PMC_POR1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_POR1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_POR1_EN, ME_NCR, 17, 1)
    FIELD(PMC_POR1_EN, ME_CR, 16, 1)
    FIELD(PMC_POR1_EN, MMCM, 15, 1)
    FIELD(PMC_POR1_EN, NOC_USER, 14, 1)
    FIELD(PMC_POR1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_POR1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_POR1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_POR1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_POR1_EN, PSM_NCR, 9, 1)
    FIELD(PMC_POR1_EN, PSM_CR, 8, 1)
    FIELD(PMC_POR1_EN, CFRAME, 7, 1)
    FIELD(PMC_POR1_EN, CFU, 6, 1)
    FIELD(PMC_POR1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_POR1_EN, GSW_CR, 4, 1)
    FIELD(PMC_POR1_EN, FW_NCR, 3, 1)
    FIELD(PMC_POR1_EN, FW_CR, 2, 1)
    FIELD(PMC_POR1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_POR1_EN, BOOT_CR, 0, 1)
REG32(PMC_POR1_DIS, 0x48)
    FIELD(PMC_POR1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_POR1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_POR1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_POR1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_POR1_DIS, PL3, 27, 1)
    FIELD(PMC_POR1_DIS, PL2, 26, 1)
    FIELD(PMC_POR1_DIS, PL1, 25, 1)
    FIELD(PMC_POR1_DIS, PL0, 24, 1)
    FIELD(PMC_POR1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_POR1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_POR1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_POR1_DIS, GT_CR, 20, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_POR1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_POR1_DIS, ME_CR, 16, 1)
    FIELD(PMC_POR1_DIS, MMCM, 15, 1)
    FIELD(PMC_POR1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_POR1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_POR1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_POR1_DIS, PSM_NCR, 9, 1)
    FIELD(PMC_POR1_DIS, PSM_CR, 8, 1)
    FIELD(PMC_POR1_DIS, CFRAME, 7, 1)
    FIELD(PMC_POR1_DIS, CFU, 6, 1)
    FIELD(PMC_POR1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_POR1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_POR1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_POR1_DIS, FW_CR, 2, 1)
    FIELD(PMC_POR1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_POR1_DIS, BOOT_CR, 0, 1)
REG32(PMC_POR2_MASK, 0x50)
    FIELD(PMC_POR2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_POR2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_POR2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_POR2_MASK, PMC_XPPU, 28, 1)
    FIELD(PMC_POR2_MASK, PMC_XMPU, 27, 1)
    FIELD(PMC_POR2_MASK, PMC_TO, 26, 1)
    FIELD(PMC_POR2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_POR2_MASK, PPLL, 24, 1)
    FIELD(PMC_POR2_MASK, NPLL, 23, 1)
    FIELD(PMC_POR2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_POR2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_POR2_MASK, RSRV_ERR0, 20, 1)
    FIELD(PMC_POR2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_POR2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_POR2_MASK, CFI, 17, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON7, 14, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON6, 13, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON5, 12, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_POR2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_POR2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_POR2_MASK, PMC_PAR, 4, 1)
    FIELD(PMC_POR2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_POR2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_POR2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_POR2_MASK, PMC_APB, 0, 1)
REG32(PMC_POR2_EN, 0x54)
    FIELD(PMC_POR2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_POR2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_POR2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_POR2_EN, PMC_XPPU, 28, 1)
    FIELD(PMC_POR2_EN, PMC_XMPU, 27, 1)
    FIELD(PMC_POR2_EN, PMC_TO, 26, 1)
    FIELD(PMC_POR2_EN, CLK_MON, 25, 1)
    FIELD(PMC_POR2_EN, PPLL, 24, 1)
    FIELD(PMC_POR2_EN, NPLL, 23, 1)
    FIELD(PMC_POR2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_POR2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_POR2_EN, RSRV_ERR0, 20, 1)
    FIELD(PMC_POR2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_POR2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_POR2_EN, CFI, 17, 1)
    FIELD(PMC_POR2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_POR2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_POR2_EN, PMC_SMON7, 14, 1)
    FIELD(PMC_POR2_EN, PMC_SMON6, 13, 1)
    FIELD(PMC_POR2_EN, PMC_SMON5, 12, 1)
    FIELD(PMC_POR2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_POR2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_POR2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_POR2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_POR2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_POR2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_POR2_EN, PMC_CR, 5, 1)
    FIELD(PMC_POR2_EN, PMC_PAR, 4, 1)
    FIELD(PMC_POR2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_POR2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_POR2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_POR2_EN, PMC_APB, 0, 1)
REG32(PMC_POR2_DIS, 0x58)
    FIELD(PMC_POR2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_POR2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_POR2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_POR2_DIS, PMC_XPPU, 28, 1)
    FIELD(PMC_POR2_DIS, PMC_XMPU, 27, 1)
    FIELD(PMC_POR2_DIS, PMC_TO, 26, 1)
    FIELD(PMC_POR2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_POR2_DIS, PPLL, 24, 1)
    FIELD(PMC_POR2_DIS, NPLL, 23, 1)
    FIELD(PMC_POR2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_POR2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_POR2_DIS, RSRV_ERR0, 20, 1)
    FIELD(PMC_POR2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_POR2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_POR2_DIS, CFI, 17, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON7, 14, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON6, 13, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON5, 12, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_POR2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_POR2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_POR2_DIS, PMC_PAR, 4, 1)
    FIELD(PMC_POR2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_POR2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_POR2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_POR2_DIS, PMC_APB, 0, 1)
REG32(PMC_IRQ1_MASK, 0x60)
    FIELD(PMC_IRQ1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_IRQ1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_IRQ1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_IRQ1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_IRQ1_MASK, PL3, 27, 1)
    FIELD(PMC_IRQ1_MASK, PL2, 26, 1)
    FIELD(PMC_IRQ1_MASK, PL1, 25, 1)
    FIELD(PMC_IRQ1_MASK, PL0, 24, 1)
    FIELD(PMC_IRQ1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_IRQ1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_IRQ1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_IRQ1_MASK, GT_CR, 20, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_IRQ1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_IRQ1_MASK, ME_CR, 16, 1)
    FIELD(PMC_IRQ1_MASK, MMCM, 15, 1)
    FIELD(PMC_IRQ1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_IRQ1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_IRQ1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_IRQ1_MASK, PSM_NCR, 9, 1)
    FIELD(PMC_IRQ1_MASK, PSM_CR, 8, 1)
    FIELD(PMC_IRQ1_MASK, CFRAME, 7, 1)
    FIELD(PMC_IRQ1_MASK, CFU, 6, 1)
    FIELD(PMC_IRQ1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_IRQ1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_IRQ1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_IRQ1_MASK, FW_CR, 2, 1)
    FIELD(PMC_IRQ1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_IRQ1_MASK, BOOT_CR, 0, 1)
REG32(PMC_IRQ1_EN, 0x64)
    FIELD(PMC_IRQ1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_IRQ1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_IRQ1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_IRQ1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_IRQ1_EN, PL3, 27, 1)
    FIELD(PMC_IRQ1_EN, PL2, 26, 1)
    FIELD(PMC_IRQ1_EN, PL1, 25, 1)
    FIELD(PMC_IRQ1_EN, PL0, 24, 1)
    FIELD(PMC_IRQ1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_IRQ1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_IRQ1_EN, GT_NCR, 21, 1)
    FIELD(PMC_IRQ1_EN, GT_CR, 20, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_IRQ1_EN, ME_NCR, 17, 1)
    FIELD(PMC_IRQ1_EN, ME_CR, 16, 1)
    FIELD(PMC_IRQ1_EN, MMCM, 15, 1)
    FIELD(PMC_IRQ1_EN, NOC_USER, 14, 1)
    FIELD(PMC_IRQ1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_IRQ1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_IRQ1_EN, PSM_NCR, 9, 1)
    FIELD(PMC_IRQ1_EN, PSM_CR, 8, 1)
    FIELD(PMC_IRQ1_EN, CFRAME, 7, 1)
    FIELD(PMC_IRQ1_EN, CFU, 6, 1)
    FIELD(PMC_IRQ1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_IRQ1_EN, GSW_CR, 4, 1)
    FIELD(PMC_IRQ1_EN, FW_NCR, 3, 1)
    FIELD(PMC_IRQ1_EN, FW_CR, 2, 1)
    FIELD(PMC_IRQ1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_IRQ1_EN, BOOT_CR, 0, 1)
REG32(PMC_IRQ1_DIS, 0x68)
    FIELD(PMC_IRQ1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_IRQ1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_IRQ1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_IRQ1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_IRQ1_DIS, PL3, 27, 1)
    FIELD(PMC_IRQ1_DIS, PL2, 26, 1)
    FIELD(PMC_IRQ1_DIS, PL1, 25, 1)
    FIELD(PMC_IRQ1_DIS, PL0, 24, 1)
    FIELD(PMC_IRQ1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_IRQ1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_IRQ1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_IRQ1_DIS, GT_CR, 20, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_IRQ1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_IRQ1_DIS, ME_CR, 16, 1)
    FIELD(PMC_IRQ1_DIS, MMCM, 15, 1)
    FIELD(PMC_IRQ1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_IRQ1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_IRQ1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_IRQ1_DIS, PSM_NCR, 9, 1)
    FIELD(PMC_IRQ1_DIS, PSM_CR, 8, 1)
    FIELD(PMC_IRQ1_DIS, CFRAME, 7, 1)
    FIELD(PMC_IRQ1_DIS, CFU, 6, 1)
    FIELD(PMC_IRQ1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_IRQ1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_IRQ1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_IRQ1_DIS, FW_CR, 2, 1)
    FIELD(PMC_IRQ1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_IRQ1_DIS, BOOT_CR, 0, 1)
REG32(PMC_IRQ2_MASK, 0x70)
    FIELD(PMC_IRQ2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_IRQ2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_IRQ2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_IRQ2_MASK, PMC_XPPU, 28, 1)
    FIELD(PMC_IRQ2_MASK, PMC_XMPU, 27, 1)
    FIELD(PMC_IRQ2_MASK, PMC_TO, 26, 1)
    FIELD(PMC_IRQ2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_IRQ2_MASK, PPLL, 24, 1)
    FIELD(PMC_IRQ2_MASK, NPLL, 23, 1)
    FIELD(PMC_IRQ2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_IRQ2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_IRQ2_MASK, RSRV_ERR0, 20, 1)
    FIELD(PMC_IRQ2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_IRQ2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_IRQ2_MASK, CFI, 17, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON7, 14, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON6, 13, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON5, 12, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_IRQ2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_IRQ2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_IRQ2_MASK, PMC_PAR, 4, 1)
    FIELD(PMC_IRQ2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_IRQ2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_IRQ2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_IRQ2_MASK, PMC_APB, 0, 1)
REG32(PMC_IRQ2_EN, 0x74)
    FIELD(PMC_IRQ2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_IRQ2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_IRQ2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_IRQ2_EN, PMC_XPPU, 28, 1)
    FIELD(PMC_IRQ2_EN, PMC_XMPU, 27, 1)
    FIELD(PMC_IRQ2_EN, PMC_TO, 26, 1)
    FIELD(PMC_IRQ2_EN, CLK_MON, 25, 1)
    FIELD(PMC_IRQ2_EN, PPLL, 24, 1)
    FIELD(PMC_IRQ2_EN, NPLL, 23, 1)
    FIELD(PMC_IRQ2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_IRQ2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_IRQ2_EN, RSRV_ERR0, 20, 1)
    FIELD(PMC_IRQ2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_IRQ2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_IRQ2_EN, CFI, 17, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON7, 14, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON6, 13, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON5, 12, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_IRQ2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_IRQ2_EN, PMC_CR, 5, 1)
    FIELD(PMC_IRQ2_EN, PMC_PAR, 4, 1)
    FIELD(PMC_IRQ2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_IRQ2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_IRQ2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_IRQ2_EN, PMC_APB, 0, 1)
REG32(PMC_IRQ2_DIS, 0x78)
    FIELD(PMC_IRQ2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_IRQ2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_IRQ2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_IRQ2_DIS, PMC_XPPU, 28, 1)
    FIELD(PMC_IRQ2_DIS, PMC_XMPU, 27, 1)
    FIELD(PMC_IRQ2_DIS, PMC_TO, 26, 1)
    FIELD(PMC_IRQ2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_IRQ2_DIS, PPLL, 24, 1)
    FIELD(PMC_IRQ2_DIS, NPLL, 23, 1)
    FIELD(PMC_IRQ2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_IRQ2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_IRQ2_DIS, RSRV_ERR0, 20, 1)
    FIELD(PMC_IRQ2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_IRQ2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_IRQ2_DIS, CFI, 17, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON7, 14, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON6, 13, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON5, 12, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_IRQ2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_IRQ2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_IRQ2_DIS, PMC_PAR, 4, 1)
    FIELD(PMC_IRQ2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_IRQ2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_IRQ2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_IRQ2_DIS, PMC_APB, 0, 1)
REG32(PMC_SRST1_MASK, 0x80)
    FIELD(PMC_SRST1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_SRST1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_SRST1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_SRST1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_SRST1_MASK, PL3, 27, 1)
    FIELD(PMC_SRST1_MASK, PL2, 26, 1)
    FIELD(PMC_SRST1_MASK, PL1, 25, 1)
    FIELD(PMC_SRST1_MASK, PL0, 24, 1)
    FIELD(PMC_SRST1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_SRST1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_SRST1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_SRST1_MASK, GT_CR, 20, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_SRST1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_SRST1_MASK, ME_CR, 16, 1)
    FIELD(PMC_SRST1_MASK, MMCM, 15, 1)
    FIELD(PMC_SRST1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_SRST1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_SRST1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_SRST1_MASK, PSM_NCR, 9, 1)
    FIELD(PMC_SRST1_MASK, PSM_CR, 8, 1)
    FIELD(PMC_SRST1_MASK, CFRAME, 7, 1)
    FIELD(PMC_SRST1_MASK, CFU, 6, 1)
    FIELD(PMC_SRST1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_SRST1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_SRST1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_SRST1_MASK, FW_CR, 2, 1)
    FIELD(PMC_SRST1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_SRST1_MASK, BOOT_CR, 0, 1)
REG32(PMC_SRST1_EN, 0x84)
    FIELD(PMC_SRST1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_SRST1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_SRST1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_SRST1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_SRST1_EN, PL3, 27, 1)
    FIELD(PMC_SRST1_EN, PL2, 26, 1)
    FIELD(PMC_SRST1_EN, PL1, 25, 1)
    FIELD(PMC_SRST1_EN, PL0, 24, 1)
    FIELD(PMC_SRST1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_SRST1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_SRST1_EN, GT_NCR, 21, 1)
    FIELD(PMC_SRST1_EN, GT_CR, 20, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_SRST1_EN, ME_NCR, 17, 1)
    FIELD(PMC_SRST1_EN, ME_CR, 16, 1)
    FIELD(PMC_SRST1_EN, MMCM, 15, 1)
    FIELD(PMC_SRST1_EN, NOC_USER, 14, 1)
    FIELD(PMC_SRST1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_SRST1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_SRST1_EN, PSM_NCR, 9, 1)
    FIELD(PMC_SRST1_EN, PSM_CR, 8, 1)
    FIELD(PMC_SRST1_EN, CFRAME, 7, 1)
    FIELD(PMC_SRST1_EN, CFU, 6, 1)
    FIELD(PMC_SRST1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_SRST1_EN, GSW_CR, 4, 1)
    FIELD(PMC_SRST1_EN, FW_NCR, 3, 1)
    FIELD(PMC_SRST1_EN, FW_CR, 2, 1)
    FIELD(PMC_SRST1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_SRST1_EN, BOOT_CR, 0, 1)
REG32(PMC_SRST1_DIS, 0x88)
    FIELD(PMC_SRST1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_SRST1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_SRST1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_SRST1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_SRST1_DIS, PL3, 27, 1)
    FIELD(PMC_SRST1_DIS, PL2, 26, 1)
    FIELD(PMC_SRST1_DIS, PL1, 25, 1)
    FIELD(PMC_SRST1_DIS, PL0, 24, 1)
    FIELD(PMC_SRST1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_SRST1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_SRST1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_SRST1_DIS, GT_CR, 20, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_SRST1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_SRST1_DIS, ME_CR, 16, 1)
    FIELD(PMC_SRST1_DIS, MMCM, 15, 1)
    FIELD(PMC_SRST1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_SRST1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_SRST1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_SRST1_DIS, PSM_NCR, 9, 1)
    FIELD(PMC_SRST1_DIS, PSM_CR, 8, 1)
    FIELD(PMC_SRST1_DIS, CFRAME, 7, 1)
    FIELD(PMC_SRST1_DIS, CFU, 6, 1)
    FIELD(PMC_SRST1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_SRST1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_SRST1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_SRST1_DIS, FW_CR, 2, 1)
    FIELD(PMC_SRST1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_SRST1_DIS, BOOT_CR, 0, 1)
REG32(PMC_SRST2_MASK, 0x90)
    FIELD(PMC_SRST2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_SRST2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_SRST2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_SRST2_MASK, PMC_XPPU, 28, 1)
    FIELD(PMC_SRST2_MASK, PMC_XMPU, 27, 1)
    FIELD(PMC_SRST2_MASK, PMC_TO, 26, 1)
    FIELD(PMC_SRST2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_SRST2_MASK, PPLL, 24, 1)
    FIELD(PMC_SRST2_MASK, NPLL, 23, 1)
    FIELD(PMC_SRST2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_SRST2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_SRST2_MASK, RSRV_ERR0, 20, 1)
    FIELD(PMC_SRST2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_SRST2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_SRST2_MASK, CFI, 17, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON7, 14, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON6, 13, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON5, 12, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_SRST2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_SRST2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_SRST2_MASK, PMC_PAR, 4, 1)
    FIELD(PMC_SRST2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_SRST2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_SRST2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_SRST2_MASK, PMC_APB, 0, 1)
REG32(PMC_SRST2_EN, 0x94)
    FIELD(PMC_SRST2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_SRST2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_SRST2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_SRST2_EN, PMC_XPPU, 28, 1)
    FIELD(PMC_SRST2_EN, PMC_XMPU, 27, 1)
    FIELD(PMC_SRST2_EN, PMC_TO, 26, 1)
    FIELD(PMC_SRST2_EN, CLK_MON, 25, 1)
    FIELD(PMC_SRST2_EN, PPLL, 24, 1)
    FIELD(PMC_SRST2_EN, NPLL, 23, 1)
    FIELD(PMC_SRST2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_SRST2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_SRST2_EN, RSRV_ERR0, 20, 1)
    FIELD(PMC_SRST2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_SRST2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_SRST2_EN, CFI, 17, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON7, 14, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON6, 13, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON5, 12, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_SRST2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_SRST2_EN, PMC_CR, 5, 1)
    FIELD(PMC_SRST2_EN, PMC_PAR, 4, 1)
    FIELD(PMC_SRST2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_SRST2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_SRST2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_SRST2_EN, PMC_APB, 0, 1)
REG32(PMC_SRST2_DIS, 0x98)
    FIELD(PMC_SRST2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_SRST2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_SRST2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_SRST2_DIS, PMC_XPPU, 28, 1)
    FIELD(PMC_SRST2_DIS, PMC_XMPU, 27, 1)
    FIELD(PMC_SRST2_DIS, PMC_TO, 26, 1)
    FIELD(PMC_SRST2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_SRST2_DIS, PPLL, 24, 1)
    FIELD(PMC_SRST2_DIS, NPLL, 23, 1)
    FIELD(PMC_SRST2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_SRST2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_SRST2_DIS, RSRV_ERR0, 20, 1)
    FIELD(PMC_SRST2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_SRST2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_SRST2_DIS, CFI, 17, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON7, 14, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON6, 13, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON5, 12, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_SRST2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_SRST2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_SRST2_DIS, PMC_PAR, 4, 1)
    FIELD(PMC_SRST2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_SRST2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_SRST2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_SRST2_DIS, PMC_APB, 0, 1)
REG32(PMC_BOOT_ERR, 0x100)
    FIELD(PMC_BOOT_ERR, DATA, 0, 30)
REG32(ERROR_MANAGEMENT_POR_LOCK, 0x200)
    FIELD(ERROR_MANAGEMENT_POR_LOCK, LOCK, 0, 1)

#define PMC_GLOBAL_R_MAX (R_ERROR_MANAGEMENT_POR_LOCK + 1)

#define SLR_SYNC_MASK    (R_PMC_ERR2_STATUS_SSIT_ERR0_MASK | \
                          R_PMC_ERR2_STATUS_SSIT_ERR1_MASK | \
                          R_PMC_ERR2_STATUS_SSIT_ERR2_MASK)

typedef struct PmcErrMngmnt {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[PMC_GLOBAL_R_MAX];
    uint32_t pmc_err1_sts;
    uint32_t pmc_err2_sts;
    bool ssit;
    RegisterInfo regs_info[PMC_GLOBAL_R_MAX];
} PmcErrMngmnt;

static void err1_postw(RegisterInfo *reg, uint64_t val)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(reg->opaque);
    s->regs[R_PMC_ERR1_STATUS] |= s->pmc_err1_sts;
}

static void err2_postw(RegisterInfo *reg, uint64_t val)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(reg->opaque);
    s->regs[R_PMC_ERR2_STATUS] |= s->pmc_err2_sts;
}

static uint64_t err2_postr(RegisterInfo *reg, uint64_t val)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(reg->opaque);

    /* Hack:
     * Master and slave SLR handshake involves waiting for slave
     * SLR's to move into sync state and then master ack for slaves.
     *
     * Both these events need PLM on SLR's, which we don't support
     * at preset, so simply toggle the pins to get the effect of sync
     * done.
     */
    if (s->ssit) {
        s->pmc_err2_sts = deposit32(s->pmc_err2_sts,
                                    R_PMC_ERR2_STATUS_SSIT_ERR0_SHIFT, 3,
                                    ((s->pmc_err2_sts ^ SLR_SYNC_MASK) >>
                                    R_PMC_ERR2_STATUS_SSIT_ERR0_SHIFT));
    }
    return s->pmc_err2_sts;
}

static void pmc_err_int_en(RegisterInfo *reg, uint64_t val)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(reg->opaque);
    uint32_t val32 = val;

    switch(reg->access->addr) {
    case A_PMC_ERR_OUT1_EN:
        s->regs[R_PMC_ERR_OUT1_MASK] &= ~(val32);
        break;
    case A_PMC_ERR_OUT2_EN:
        s->regs[R_PMC_ERR_OUT2_MASK] &= ~(val32);
        break;
    case A_PMC_POR1_EN:
        s->regs[R_PMC_POR1_MASK] &= ~(val32);
        break;
    case A_PMC_IRQ1_EN:
        s->regs[R_PMC_IRQ1_MASK] &= ~(val32);
        break;
    case A_PMC_IRQ2_EN:
        s->regs[R_PMC_IRQ2_MASK] &= ~(val32);
        break;
    case A_PMC_SRST1_EN:
        s->regs[R_PMC_SRST1_MASK] &= ~(val32);
        break;
    case A_PMC_SRST2_EN:
        s->regs[R_PMC_SRST2_MASK] &= ~(val32);
        break;
    };
}

static void pmc_err_int_dis(RegisterInfo *reg, uint64_t val)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(reg->opaque);
    uint32_t val32 = val;

    switch(reg->access->addr) {
    case A_PMC_ERR_OUT1_DIS:
        s->regs[R_PMC_ERR_OUT1_MASK] |= val32;
        break;
    case A_PMC_ERR_OUT2_DIS:
        s->regs[R_PMC_ERR_OUT2_MASK] |= val32;
        break;
    case A_PMC_POR1_DIS:
        s->regs[R_PMC_POR1_MASK] |= val32;
        break;
    case A_PMC_IRQ1_DIS:
        s->regs[R_PMC_IRQ1_MASK] |= val32;
        break;
    case A_PMC_IRQ2_DIS:
        s->regs[R_PMC_IRQ2_MASK] |= val32;
        break;
    case A_PMC_SRST1_DIS:
        s->regs[R_PMC_SRST1_MASK] |= val32;
        break;
    case A_PMC_SRST2_DIS:
        s->regs[R_PMC_SRST2_MASK] |= val32;
        break;
    };
}

static const RegisterAccessInfo pmc_global_regs_info[] = {
    {   .name = "PMC_ERR1_STATUS",  .addr = A_PMC_ERR1_STATUS,
        .w1c = 0xffffffff,
        .post_write = err1_postw,
    },{ .name = "PMC_ERR2_STATUS",  .addr = A_PMC_ERR2_STATUS,
        .w1c = 0xffffffff,
        .post_write = err2_postw,
        .post_read = err2_postr,
    },{ .name = "PMC_ERR1_TRIG",  .addr = A_PMC_ERR1_TRIG,
    },{ .name = "PMC_ERR2_TRIG",  .addr = A_PMC_ERR2_TRIG,
    },{ .name = "PMC_ERR_OUT1_MASK",  .addr = A_PMC_ERR_OUT1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_ERR_OUT1_EN",  .addr = A_PMC_ERR_OUT1_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_ERR_OUT1_DIS",  .addr = A_PMC_ERR_OUT1_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_ERR_OUT2_MASK",  .addr = A_PMC_ERR_OUT2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_ERR_OUT2_EN",  .addr = A_PMC_ERR_OUT2_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_ERR_OUT2_DIS",  .addr = A_PMC_ERR_OUT2_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_POR1_MASK",  .addr = A_PMC_POR1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_POR1_EN",  .addr = A_PMC_POR1_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_POR1_DIS",  .addr = A_PMC_POR1_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_POR2_MASK",  .addr = A_PMC_POR2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_POR2_EN",  .addr = A_PMC_POR2_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_POR2_DIS",  .addr = A_PMC_POR2_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_IRQ1_MASK",  .addr = A_PMC_IRQ1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_IRQ1_EN",  .addr = A_PMC_IRQ1_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_IRQ1_DIS",  .addr = A_PMC_IRQ1_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_IRQ2_MASK",  .addr = A_PMC_IRQ2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_IRQ2_EN",  .addr = A_PMC_IRQ2_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_IRQ2_DIS",  .addr = A_PMC_IRQ2_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_SRST1_MASK",  .addr = A_PMC_SRST1_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_SRST1_EN",  .addr = A_PMC_SRST1_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_SRST1_DIS",  .addr = A_PMC_SRST1_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_SRST2_MASK",  .addr = A_PMC_SRST2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_SRST2_EN",  .addr = A_PMC_SRST2_EN,
        .post_write = pmc_err_int_en,
    },{ .name = "PMC_SRST2_DIS",  .addr = A_PMC_SRST2_DIS,
        .post_write = pmc_err_int_dis,
    },{ .name = "PMC_BOOT_ERR",  .addr = A_PMC_BOOT_ERR,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "ERROR_MANAGEMENT_POR_LOCK",
        .addr = A_ERROR_MANAGEMENT_POR_LOCK,
    }
};

static void pmc_global_reset(DeviceState *dev)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static void ssit_err_irq_in(void *opaque, int n, int level)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(opaque);

    if (n <= 2) {
        s->pmc_err2_sts = deposit32(s->pmc_err2_sts,
                                         R_PMC_ERR2_STATUS_SSIT_ERR0_SHIFT + n,
                                         1, level);
    } else {
        n -= 3;
        s->pmc_err1_sts = deposit32(s->pmc_err1_sts,
                                         R_PMC_ERR1_STATUS_SSIT_ERR3_SHIFT + n,
                                         1, level);
    }
    s->regs[R_PMC_ERR2_STATUS] |= s->pmc_err2_sts;
    s->regs[R_PMC_ERR1_STATUS] |= s->pmc_err1_sts;
}

static const MemoryRegionOps pmc_global_ops = {
    .read = register_read_memory,
    .write_with_attrs = register_write_memory_with_attrs,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmc_global_realize(DeviceState *dev, Error **errp)
{
    qdev_init_gpio_in(dev, ssit_err_irq_in, 6);
}

static void pmc_global_init(Object *obj)
{
    PmcErrMngmnt *s = XILINX_PMC_GLOBAL(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMC_GLOBAL,
                       PMC_GLOBAL_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmc_global_regs_info,
                              ARRAY_SIZE(pmc_global_regs_info),
                              s->regs_info, s->regs,
                              &pmc_global_ops,
                              XILINX_PMC_GLOBAL_ERR_DEBUG,
                              PMC_GLOBAL_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static Property err_management_props[] = {
    DEFINE_PROP_BOOL("ssit", PmcErrMngmnt, ssit, false),
    DEFINE_PROP_END_OF_LIST(),
};

static const VMStateDescription vmstate_pmc_global = {
    .name = TYPE_XILINX_PMC_GLOBAL,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PmcErrMngmnt, PMC_GLOBAL_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmc_global_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pmc_global_reset;
    dc->realize = pmc_global_realize;
    dc->vmsd = &vmstate_pmc_global;
    device_class_set_props(dc, err_management_props);
}

static const TypeInfo pmc_global_info = {
    .name          = TYPE_XILINX_PMC_GLOBAL,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PmcErrMngmnt),
    .class_init    = pmc_global_class_init,
    .instance_init = pmc_global_init,
};

static void pmc_global_register_types(void)
{
    type_register_static(&pmc_global_info);
}

type_init(pmc_global_register_types)
