/*
 * QEMU model of the NOC_NSU Noc Slave Unit
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-03-20.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_NOC_NSU_ERR_DEBUG
#define XILINX_NOC_NSU_ERR_DEBUG 0
#endif

#define TYPE_XILINX_NOC_NSU "xlnx.noc-nsu"

#define XILINX_NOC_NSU(obj) \
     OBJECT_CHECK(NOC_NSU, (obj), TYPE_XILINX_NOC_NSU)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE_NPP, 3, 1)
    FIELD(REG_PCSR_MASK, ODISABLE_AXI, 2, 1)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE_NPP, 3, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE_AXI, 2, 1)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_ITR, 0x40)
    FIELD(REG_ITR, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_ITR, WPOISON_WR, 20, 1)
    FIELD(REG_ITR, ADDR_PAR_WR, 19, 1)
    FIELD(REG_ITR, TIMEOUT_WR, 18, 1)
    FIELD(REG_ITR, ECC_1BIT_WR, 17, 1)
    FIELD(REG_ITR, ECC_2BIT_WR, 16, 1)
    FIELD(REG_ITR, NPP_IN_WR, 15, 1)
    FIELD(REG_ITR, XLX_INFOS_WR, 14, 1)
    FIELD(REG_ITR, XLX_RULES_WR, 13, 1)
    FIELD(REG_ITR, AXI_RULES_WR, 12, 1)
    FIELD(REG_ITR, VC_CREDIT_TX, 11, 1)
    FIELD(REG_ITR, VC_CREDIT_RX, 10, 1)
    FIELD(REG_ITR, UNEXPECTED, 9, 1)
    FIELD(REG_ITR, DATA_PAR_RD, 8, 1)
    FIELD(REG_ITR, ADDR_PAR_RD, 7, 1)
    FIELD(REG_ITR, TIMEOUT_RD, 6, 1)
    FIELD(REG_ITR, ECC_1BIT_RD, 5, 1)
    FIELD(REG_ITR, ECC_2BIT_RD, 4, 1)
    FIELD(REG_ITR, NPP_IN_RD, 3, 1)
    FIELD(REG_ITR, XLX_INFOS_RD, 2, 1)
    FIELD(REG_ITR, XLX_RULES_RD, 1, 1)
    FIELD(REG_ITR, AXI_RULES_RD, 0, 1)
REG32(REG_ISR, 0x44)
    FIELD(REG_ISR, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_ISR, WPOISON_WR, 20, 1)
    FIELD(REG_ISR, ADDR_PAR_WR, 19, 1)
    FIELD(REG_ISR, TIMEOUT_WR, 18, 1)
    FIELD(REG_ISR, ECC_1BIT_WR, 17, 1)
    FIELD(REG_ISR, ECC_2BIT_WR, 16, 1)
    FIELD(REG_ISR, NPP_IN_WR, 15, 1)
    FIELD(REG_ISR, XLX_INFOS_WR, 14, 1)
    FIELD(REG_ISR, XLX_RULES_WR, 13, 1)
    FIELD(REG_ISR, AXI_RULES_WR, 12, 1)
    FIELD(REG_ISR, VC_CREDIT_TX, 11, 1)
    FIELD(REG_ISR, VC_CREDIT_RX, 10, 1)
    FIELD(REG_ISR, UNEXPECTED, 9, 1)
    FIELD(REG_ISR, DATA_PAR_RD, 8, 1)
    FIELD(REG_ISR, ADDR_PAR_RD, 7, 1)
    FIELD(REG_ISR, TIMEOUT_RD, 6, 1)
    FIELD(REG_ISR, ECC_1BIT_RD, 5, 1)
    FIELD(REG_ISR, ECC_2BIT_RD, 4, 1)
    FIELD(REG_ISR, NPP_IN_RD, 3, 1)
    FIELD(REG_ISR, XLX_INFOS_RD, 2, 1)
    FIELD(REG_ISR, XLX_RULES_RD, 1, 1)
    FIELD(REG_ISR, AXI_RULES_RD, 0, 1)
REG32(REG_IMR0, 0x48)
    FIELD(REG_IMR0, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IMR0, WPOISON_WR, 20, 1)
    FIELD(REG_IMR0, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IMR0, TIMEOUT_WR, 18, 1)
    FIELD(REG_IMR0, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IMR0, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IMR0, NPP_IN_WR, 15, 1)
    FIELD(REG_IMR0, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IMR0, XLX_RULES_WR, 13, 1)
    FIELD(REG_IMR0, AXI_RULES_WR, 12, 1)
    FIELD(REG_IMR0, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IMR0, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IMR0, UNEXPECTED, 9, 1)
    FIELD(REG_IMR0, DATA_PAR_RD, 8, 1)
    FIELD(REG_IMR0, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IMR0, TIMEOUT_RD, 6, 1)
    FIELD(REG_IMR0, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IMR0, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IMR0, NPP_IN_RD, 3, 1)
    FIELD(REG_IMR0, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR0, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR0, AXI_RULES_RD, 0, 1)
REG32(REG_IER0, 0x4c)
    FIELD(REG_IER0, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IER0, WPOISON_WR, 20, 1)
    FIELD(REG_IER0, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IER0, TIMEOUT_WR, 18, 1)
    FIELD(REG_IER0, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IER0, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IER0, NPP_IN_WR, 15, 1)
    FIELD(REG_IER0, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IER0, XLX_RULES_WR, 13, 1)
    FIELD(REG_IER0, AXI_RULES_WR, 12, 1)
    FIELD(REG_IER0, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IER0, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IER0, UNEXPECTED, 9, 1)
    FIELD(REG_IER0, DATA_PAR_RD, 8, 1)
    FIELD(REG_IER0, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IER0, TIMEOUT_RD, 6, 1)
    FIELD(REG_IER0, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IER0, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IER0, NPP_IN_RD, 3, 1)
    FIELD(REG_IER0, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER0, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER0, AXI_RULES_RD, 0, 1)
REG32(REG_IDR0, 0x50)
    FIELD(REG_IDR0, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IDR0, WPOISON_WR, 20, 1)
    FIELD(REG_IDR0, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IDR0, TIMEOUT_WR, 18, 1)
    FIELD(REG_IDR0, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IDR0, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IDR0, NPP_IN_WR, 15, 1)
    FIELD(REG_IDR0, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IDR0, XLX_RULES_WR, 13, 1)
    FIELD(REG_IDR0, AXI_RULES_WR, 12, 1)
    FIELD(REG_IDR0, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IDR0, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IDR0, UNEXPECTED, 9, 1)
    FIELD(REG_IDR0, DATA_PAR_RD, 8, 1)
    FIELD(REG_IDR0, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IDR0, TIMEOUT_RD, 6, 1)
    FIELD(REG_IDR0, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IDR0, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IDR0, NPP_IN_RD, 3, 1)
    FIELD(REG_IDR0, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR0, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR0, AXI_RULES_RD, 0, 1)
REG32(REG_IMR1, 0x54)
    FIELD(REG_IMR1, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IMR1, WPOISON_WR, 20, 1)
    FIELD(REG_IMR1, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IMR1, TIMEOUT_WR, 18, 1)
    FIELD(REG_IMR1, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IMR1, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IMR1, NPP_IN_WR, 15, 1)
    FIELD(REG_IMR1, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IMR1, XLX_RULES_WR, 13, 1)
    FIELD(REG_IMR1, AXI_RULES_WR, 12, 1)
    FIELD(REG_IMR1, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IMR1, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IMR1, UNEXPECTED, 9, 1)
    FIELD(REG_IMR1, DATA_PAR_RD, 8, 1)
    FIELD(REG_IMR1, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IMR1, TIMEOUT_RD, 6, 1)
    FIELD(REG_IMR1, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IMR1, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IMR1, NPP_IN_RD, 3, 1)
    FIELD(REG_IMR1, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR1, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR1, AXI_RULES_RD, 0, 1)
REG32(REG_IER1, 0x58)
    FIELD(REG_IER1, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IER1, WPOISON_WR, 20, 1)
    FIELD(REG_IER1, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IER1, TIMEOUT_WR, 18, 1)
    FIELD(REG_IER1, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IER1, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IER1, NPP_IN_WR, 15, 1)
    FIELD(REG_IER1, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IER1, XLX_RULES_WR, 13, 1)
    FIELD(REG_IER1, AXI_RULES_WR, 12, 1)
    FIELD(REG_IER1, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IER1, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IER1, UNEXPECTED, 9, 1)
    FIELD(REG_IER1, DATA_PAR_RD, 8, 1)
    FIELD(REG_IER1, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IER1, TIMEOUT_RD, 6, 1)
    FIELD(REG_IER1, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IER1, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IER1, NPP_IN_RD, 3, 1)
    FIELD(REG_IER1, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER1, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER1, AXI_RULES_RD, 0, 1)
REG32(REG_IDR1, 0x5c)
    FIELD(REG_IDR1, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IDR1, WPOISON_WR, 20, 1)
    FIELD(REG_IDR1, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IDR1, TIMEOUT_WR, 18, 1)
    FIELD(REG_IDR1, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IDR1, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IDR1, NPP_IN_WR, 15, 1)
    FIELD(REG_IDR1, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IDR1, XLX_RULES_WR, 13, 1)
    FIELD(REG_IDR1, AXI_RULES_WR, 12, 1)
    FIELD(REG_IDR1, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IDR1, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IDR1, UNEXPECTED, 9, 1)
    FIELD(REG_IDR1, DATA_PAR_RD, 8, 1)
    FIELD(REG_IDR1, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IDR1, TIMEOUT_RD, 6, 1)
    FIELD(REG_IDR1, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IDR1, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IDR1, NPP_IN_RD, 3, 1)
    FIELD(REG_IDR1, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR1, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR1, AXI_RULES_RD, 0, 1)
REG32(REG_IMR2, 0x60)
    FIELD(REG_IMR2, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IMR2, WPOISON_WR, 20, 1)
    FIELD(REG_IMR2, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IMR2, TIMEOUT_WR, 18, 1)
    FIELD(REG_IMR2, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IMR2, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IMR2, NPP_IN_WR, 15, 1)
    FIELD(REG_IMR2, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IMR2, XLX_RULES_WR, 13, 1)
    FIELD(REG_IMR2, AXI_RULES_WR, 12, 1)
    FIELD(REG_IMR2, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IMR2, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IMR2, UNEXPECTED, 9, 1)
    FIELD(REG_IMR2, DATA_PAR_RD, 8, 1)
    FIELD(REG_IMR2, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IMR2, TIMEOUT_RD, 6, 1)
    FIELD(REG_IMR2, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IMR2, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IMR2, NPP_IN_RD, 3, 1)
    FIELD(REG_IMR2, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR2, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR2, AXI_RULES_RD, 0, 1)
REG32(REG_IER2, 0x64)
    FIELD(REG_IER2, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IER2, WPOISON_WR, 20, 1)
    FIELD(REG_IER2, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IER2, TIMEOUT_WR, 18, 1)
    FIELD(REG_IER2, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IER2, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IER2, NPP_IN_WR, 15, 1)
    FIELD(REG_IER2, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IER2, XLX_RULES_WR, 13, 1)
    FIELD(REG_IER2, AXI_RULES_WR, 12, 1)
    FIELD(REG_IER2, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IER2, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IER2, UNEXPECTED, 9, 1)
    FIELD(REG_IER2, DATA_PAR_RD, 8, 1)
    FIELD(REG_IER2, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IER2, TIMEOUT_RD, 6, 1)
    FIELD(REG_IER2, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IER2, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IER2, NPP_IN_RD, 3, 1)
    FIELD(REG_IER2, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER2, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER2, AXI_RULES_RD, 0, 1)
REG32(REG_IDR2, 0x68)
    FIELD(REG_IDR2, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IDR2, WPOISON_WR, 20, 1)
    FIELD(REG_IDR2, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IDR2, TIMEOUT_WR, 18, 1)
    FIELD(REG_IDR2, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IDR2, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IDR2, NPP_IN_WR, 15, 1)
    FIELD(REG_IDR2, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IDR2, XLX_RULES_WR, 13, 1)
    FIELD(REG_IDR2, AXI_RULES_WR, 12, 1)
    FIELD(REG_IDR2, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IDR2, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IDR2, UNEXPECTED, 9, 1)
    FIELD(REG_IDR2, DATA_PAR_RD, 8, 1)
    FIELD(REG_IDR2, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IDR2, TIMEOUT_RD, 6, 1)
    FIELD(REG_IDR2, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IDR2, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IDR2, NPP_IN_RD, 3, 1)
    FIELD(REG_IDR2, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR2, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR2, AXI_RULES_RD, 0, 1)
REG32(REG_IMR3, 0x6c)
    FIELD(REG_IMR3, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IMR3, WPOISON_WR, 20, 1)
    FIELD(REG_IMR3, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IMR3, TIMEOUT_WR, 18, 1)
    FIELD(REG_IMR3, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IMR3, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IMR3, NPP_IN_WR, 15, 1)
    FIELD(REG_IMR3, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IMR3, XLX_RULES_WR, 13, 1)
    FIELD(REG_IMR3, AXI_RULES_WR, 12, 1)
    FIELD(REG_IMR3, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IMR3, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IMR3, UNEXPECTED, 9, 1)
    FIELD(REG_IMR3, DATA_PAR_RD, 8, 1)
    FIELD(REG_IMR3, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IMR3, TIMEOUT_RD, 6, 1)
    FIELD(REG_IMR3, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IMR3, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IMR3, NPP_IN_RD, 3, 1)
    FIELD(REG_IMR3, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR3, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR3, AXI_RULES_RD, 0, 1)
REG32(REG_IER3, 0x70)
    FIELD(REG_IER3, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IER3, WPOISON_WR, 20, 1)
    FIELD(REG_IER3, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IER3, TIMEOUT_WR, 18, 1)
    FIELD(REG_IER3, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IER3, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IER3, NPP_IN_WR, 15, 1)
    FIELD(REG_IER3, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IER3, XLX_RULES_WR, 13, 1)
    FIELD(REG_IER3, AXI_RULES_WR, 12, 1)
    FIELD(REG_IER3, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IER3, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IER3, UNEXPECTED, 9, 1)
    FIELD(REG_IER3, DATA_PAR_RD, 8, 1)
    FIELD(REG_IER3, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IER3, TIMEOUT_RD, 6, 1)
    FIELD(REG_IER3, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IER3, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IER3, NPP_IN_RD, 3, 1)
    FIELD(REG_IER3, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER3, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER3, AXI_RULES_RD, 0, 1)
REG32(REG_IDR3, 0x74)
    FIELD(REG_IDR3, SCAN_CLR_ERR, 21, 1)
    FIELD(REG_IDR3, WPOISON_WR, 20, 1)
    FIELD(REG_IDR3, ADDR_PAR_WR, 19, 1)
    FIELD(REG_IDR3, TIMEOUT_WR, 18, 1)
    FIELD(REG_IDR3, ECC_1BIT_WR, 17, 1)
    FIELD(REG_IDR3, ECC_2BIT_WR, 16, 1)
    FIELD(REG_IDR3, NPP_IN_WR, 15, 1)
    FIELD(REG_IDR3, XLX_INFOS_WR, 14, 1)
    FIELD(REG_IDR3, XLX_RULES_WR, 13, 1)
    FIELD(REG_IDR3, AXI_RULES_WR, 12, 1)
    FIELD(REG_IDR3, VC_CREDIT_TX, 11, 1)
    FIELD(REG_IDR3, VC_CREDIT_RX, 10, 1)
    FIELD(REG_IDR3, UNEXPECTED, 9, 1)
    FIELD(REG_IDR3, DATA_PAR_RD, 8, 1)
    FIELD(REG_IDR3, ADDR_PAR_RD, 7, 1)
    FIELD(REG_IDR3, TIMEOUT_RD, 6, 1)
    FIELD(REG_IDR3, ECC_1BIT_RD, 5, 1)
    FIELD(REG_IDR3, ECC_2BIT_RD, 4, 1)
    FIELD(REG_IDR3, NPP_IN_RD, 3, 1)
    FIELD(REG_IDR3, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR3, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR3, AXI_RULES_RD, 0, 1)
REG32(REG_IOR, 0x78)
    FIELD(REG_IOR, OFFSET, 0, 5)
REG32(REG_SRC, 0x100)
    FIELD(REG_SRC, NSU, 0, 12)
REG32(REG_DWIDTH, 0x104)
    FIELD(REG_DWIDTH, NSU, 0, 3)
REG32(REG_MODE_SELECT, 0x108)
    FIELD(REG_MODE_SELECT, PROT, 0, 2)
REG32(REG_OUTSTANDING_RD_TXN, 0x10c)
    FIELD(REG_OUTSTANDING_RD_TXN, NSU, 0, 6)
REG32(REG_OUTSTANDING_WR_TXN, 0x110)
    FIELD(REG_OUTSTANDING_WR_TXN, NSU, 0, 6)
REG32(REG_COMP_ID_INDEX0, 0x114)
    FIELD(REG_COMP_ID_INDEX0, NSU, 0, 5)
REG32(REG_COMP_ID_INDEX1, 0x118)
    FIELD(REG_COMP_ID_INDEX1, NSU, 0, 5)
REG32(REG_COMP_ID_MODE, 0x11c)
    FIELD(REG_COMP_ID_MODE, NSU, 0, 1)
REG32(REG_FIXED_COMP_ID, 0x120)
    FIELD(REG_FIXED_COMP_ID, NSU, 0, 2)
REG32(REG_DISABLE_EX_MON, 0x124)
    FIELD(REG_DISABLE_EX_MON, NSU, 0, 1)
REG32(REG_TBASE_TRK_TIMEOUT, 0x128)
    FIELD(REG_TBASE_TRK_TIMEOUT, INDEX, 1, 3)
    FIELD(REG_TBASE_TRK_TIMEOUT, EN, 0, 1)
REG32(REG_TBASE_AXI_TIMEOUT, 0x12c)
    FIELD(REG_TBASE_AXI_TIMEOUT, INDEX, 1, 3)
    FIELD(REG_TBASE_AXI_TIMEOUT, EN, 0, 1)
REG32(REG_PAR_CHK, 0x130)
    FIELD(REG_PAR_CHK, EN, 0, 1)
REG32(REG_ODISABLE_AXI_RESP, 0x134)
    FIELD(REG_ODISABLE_AXI_RESP, MODE, 0, 1)
REG32(REG_DBI, 0x138)
    FIELD(REG_DBI, EN, 0, 1)
REG32(REG_ECC_CHK_EN, 0x13c)
    FIELD(REG_ECC_CHK_EN, NSU, 0, 1)
REG32(REG_AXI_LOOPBACK, 0x140)
    FIELD(REG_AXI_LOOPBACK, CMUX_EN, 1, 1)
    FIELD(REG_AXI_LOOPBACK, EN, 0, 1)
REG32(REG_RD_REQ_VC_MAP0, 0x144)
    FIELD(REG_RD_REQ_VC_MAP0, NSU, 0, 3)
REG32(REG_RD_REQ_VC_MAP1, 0x148)
    FIELD(REG_RD_REQ_VC_MAP1, NSU, 0, 3)
REG32(REG_WR_REQ_VC_MAP0, 0x14c)
    FIELD(REG_WR_REQ_VC_MAP0, NSU, 0, 3)
REG32(REG_WR_REQ_VC_MAP1, 0x150)
    FIELD(REG_WR_REQ_VC_MAP1, NSU, 0, 3)
REG32(REG_RD_RESP_VC_MAP0, 0x154)
    FIELD(REG_RD_RESP_VC_MAP0, NSU, 0, 3)
REG32(REG_RD_RESP_VC_MAP1, 0x158)
    FIELD(REG_RD_RESP_VC_MAP1, NSU, 0, 3)
REG32(REG_WR_RESP_VC_MAP0, 0x15c)
    FIELD(REG_WR_RESP_VC_MAP0, NSU, 0, 3)
REG32(REG_WR_RESP_VC_MAP1, 0x160)
    FIELD(REG_WR_RESP_VC_MAP1, NSU, 0, 3)
REG32(REG_PR_MODE, 0x164)
    FIELD(REG_PR_MODE, NSU, 0, 1)
REG32(REG_FLUSH_MODE, 0x168)
    FIELD(REG_FLUSH_MODE, NSU, 0, 1)
REG32(REG_NOC_CLK_GATE_DIS, 0x16c)
    FIELD(REG_NOC_CLK_GATE_DIS, NSU, 0, 1)
REG32(REG_FAB_CLK_GATE_DIS, 0x170)
    FIELD(REG_FAB_CLK_GATE_DIS, NSU, 0, 1)
REG32(REG_RD_VCA_TOKEN0, 0x174)
    FIELD(REG_RD_VCA_TOKEN0, NSU, 0, 8)
REG32(REG_RD_VCA_TOKEN1, 0x178)
    FIELD(REG_RD_VCA_TOKEN1, NSU, 0, 8)
REG32(REG_WR_VCA_TOKEN0, 0x17c)
    FIELD(REG_WR_VCA_TOKEN0, NSU, 0, 8)
REG32(REG_WR_VCA_TOKEN1, 0x180)
    FIELD(REG_WR_VCA_TOKEN1, NSU, 0, 8)
REG32(REG_RDTRK_VCA_TOKEN0, 0x184)
    FIELD(REG_RDTRK_VCA_TOKEN0, NSU, 0, 8)
REG32(REG_RDTRK_VCA_TOKEN1, 0x188)
    FIELD(REG_RDTRK_VCA_TOKEN1, NSU, 0, 8)
REG32(REG_WRTRK_VCA_TOKEN0, 0x18c)
    FIELD(REG_WRTRK_VCA_TOKEN0, NSU, 0, 8)
REG32(REG_WRTRK_VCA_TOKEN1, 0x190)
    FIELD(REG_WRTRK_VCA_TOKEN1, NSU, 0, 8)
REG32(REG_VMAP_OUT_RD_TOKEN0, 0x194)
    FIELD(REG_VMAP_OUT_RD_TOKEN0, NSU, 0, 8)
REG32(REG_VMAP_OUT_RD_TOKEN1, 0x198)
    FIELD(REG_VMAP_OUT_RD_TOKEN1, NSU, 0, 8)
REG32(REG_VMAP_OUT_WR_TOKEN0, 0x19c)
    FIELD(REG_VMAP_OUT_WR_TOKEN0, NSU, 0, 8)
REG32(REG_VMAP_OUT_WR_TOKEN1, 0x1a0)
    FIELD(REG_VMAP_OUT_WR_TOKEN1, NSU, 0, 8)
REG32(REG_PERF_MON0_CTRL, 0x1a4)
    FIELD(REG_PERF_MON0_CTRL, RW_SEL, 3, 1)
    FIELD(REG_PERF_MON0_CTRL, FLT_SEL, 2, 1)
    FIELD(REG_PERF_MON0_CTRL, LAT_SEL, 1, 1)
    FIELD(REG_PERF_MON0_CTRL, MON_EN, 0, 1)
REG32(REG_PERF_MON1_CTRL, 0x1a8)
    FIELD(REG_PERF_MON1_CTRL, RW_SEL, 3, 1)
    FIELD(REG_PERF_MON1_CTRL, FLT_SEL, 2, 1)
    FIELD(REG_PERF_MON1_CTRL, LAT_SEL, 1, 1)
    FIELD(REG_PERF_MON1_CTRL, MON_EN, 0, 1)
REG32(REG_PERF_FLT0_CMP_S0, 0x1ac)
    FIELD(REG_PERF_FLT0_CMP_S0, AXPROT, 29, 3)
    FIELD(REG_PERF_FLT0_CMP_S0, AXBURST, 27, 2)
    FIELD(REG_PERF_FLT0_CMP_S0, AXSIZE_MIN, 24, 3)
    FIELD(REG_PERF_FLT0_CMP_S0, AXLEN_MIN, 16, 8)
    FIELD(REG_PERF_FLT0_CMP_S0, AXID, 0, 16)
REG32(REG_PERF_FLT0_CMP_S1, 0x1b0)
    FIELD(REG_PERF_FLT0_CMP_S1, COMP_ID, 22, 2)
    FIELD(REG_PERF_FLT0_CMP_S1, VC_MAP, 21, 1)
    FIELD(REG_PERF_FLT0_CMP_S1, SRC_ID_TDEST, 9, 12)
    FIELD(REG_PERF_FLT0_CMP_S1, AXLOCK, 8, 1)
    FIELD(REG_PERF_FLT0_CMP_S1, AXQOS_MIN, 4, 4)
    FIELD(REG_PERF_FLT0_CMP_S1, AXCACHE, 0, 4)
REG32(REG_PERF_FLT0_CMP_S2, 0x1b4)
    FIELD(REG_PERF_FLT0_CMP_S2, AXSIZE_MAX, 12, 3)
    FIELD(REG_PERF_FLT0_CMP_S2, AXQOS_MAX, 8, 4)
    FIELD(REG_PERF_FLT0_CMP_S2, AXLEN_MAX, 0, 8)
REG32(REG_PERF_FLT0_CMP_EN, 0x1b8)
    FIELD(REG_PERF_FLT0_CMP_EN, TDEST, 11, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, COMP_ID, 10, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, VC_MAP, 9, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, SRC_ID, 8, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXLOCK, 7, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXQOS, 6, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXCACHE, 5, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXPROT, 4, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXBURST, 3, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXSIZE, 2, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXLEN, 1, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXID, 0, 1)
REG32(REG_PERF_FLT1_CMP_S0, 0x1bc)
    FIELD(REG_PERF_FLT1_CMP_S0, AXPROT, 29, 3)
    FIELD(REG_PERF_FLT1_CMP_S0, AXBURST, 27, 2)
    FIELD(REG_PERF_FLT1_CMP_S0, AXSIZE_MIN, 24, 3)
    FIELD(REG_PERF_FLT1_CMP_S0, AXLEN_MIN, 16, 8)
    FIELD(REG_PERF_FLT1_CMP_S0, AXID, 0, 16)
REG32(REG_PERF_FLT1_CMP_S1, 0x1c0)
    FIELD(REG_PERF_FLT1_CMP_S1, COMP_ID, 22, 2)
    FIELD(REG_PERF_FLT1_CMP_S1, VC_MAP, 21, 1)
    FIELD(REG_PERF_FLT1_CMP_S1, SRC_ID_TDEST, 9, 12)
    FIELD(REG_PERF_FLT1_CMP_S1, AXLOCK, 8, 1)
    FIELD(REG_PERF_FLT1_CMP_S1, AXQOS_MIN, 4, 4)
    FIELD(REG_PERF_FLT1_CMP_S1, AXCACHE, 0, 4)
REG32(REG_PERF_FLT1_CMP_S2, 0x1c4)
    FIELD(REG_PERF_FLT1_CMP_S2, AXSIZE_MAX, 12, 3)
    FIELD(REG_PERF_FLT1_CMP_S2, AXQOS_MAX, 8, 4)
    FIELD(REG_PERF_FLT1_CMP_S2, AXLEN_MAX, 0, 8)
REG32(REG_PERF_FLT1_CMP_EN, 0x1c8)
    FIELD(REG_PERF_FLT1_CMP_EN, TDEST, 11, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, COMP_ID, 10, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, VC_MAP, 9, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, SRC_ID, 8, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXLOCK, 7, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXQOS, 6, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXCACHE, 5, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXPROT, 4, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXBURST, 3, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXSIZE, 2, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXLEN, 1, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXID, 0, 1)
REG32(REG_PERF_MON_TBASE, 0x1cc)
    FIELD(REG_PERF_MON_TBASE, TSLIDE_LSB, 3, 5)
    FIELD(REG_PERF_MON_TBASE, SEL, 0, 3)
REG32(REG_SRC_TFC_CHK_CTRL, 0x1d0)
    FIELD(REG_SRC_TFC_CHK_CTRL, EN, 12, 1)
    FIELD(REG_SRC_TFC_CHK_CTRL, SRC_ID, 0, 12)
REG32(REG_ERR_INJ_MODE, 0x1d4)
    FIELD(REG_ERR_INJ_MODE, NSU, 0, 1)
REG32(REG_ERR_INJ_EN, 0x1d8)
    FIELD(REG_ERR_INJ_EN, DLY_CNT, 9, 16)
    FIELD(REG_ERR_INJ_EN, PAR_DST_WR, 8, 1)
    FIELD(REG_ERR_INJ_EN, PAR_DST_RD, 7, 1)
    FIELD(REG_ERR_INJ_EN, PAR_DATA_WR, 6, 1)
    FIELD(REG_ERR_INJ_EN, PAR_ADDR_WR_REGEN, 5, 1)
    FIELD(REG_ERR_INJ_EN, PAR_ADDR_WR_ORIG, 4, 1)
    FIELD(REG_ERR_INJ_EN, PAR_ADDR_RD_REGEN, 3, 1)
    FIELD(REG_ERR_INJ_EN, PAR_ADDR_RD_ORIG, 2, 1)
    FIELD(REG_ERR_INJ_EN, ECC_WR, 1, 1)
    FIELD(REG_ERR_INJ_EN, ECC_RD, 0, 1)
REG32(REG_ERR_INJ_INDEX_0, 0x1dc)
    FIELD(REG_ERR_INJ_INDEX_0, PAR_DATA, 22, 7)
    FIELD(REG_ERR_INJ_INDEX_0, PAR_ADDR, 16, 6)
    FIELD(REG_ERR_INJ_INDEX_0, ECC_BIT_1, 8, 8)
    FIELD(REG_ERR_INJ_INDEX_0, ECC_BIT_0, 0, 8)
REG32(REG_ERR_INJ_INDEX_1, 0x1e0)
    FIELD(REG_ERR_INJ_INDEX_1, PAR_DST, 0, 4)
REG32(REG_DBG_MUX_SEL, 0x1e4)
    FIELD(REG_DBG_MUX_SEL, DAT_DISC, 8, 1)
    FIELD(REG_DBG_MUX_SEL, POST_TRIG_CNT, 5, 3)
    FIELD(REG_DBG_MUX_SEL, CLK_DIV, 4, 1)
    FIELD(REG_DBG_MUX_SEL, TRIG_EN, 3, 1)
    FIELD(REG_DBG_MUX_SEL, DBG_EN, 2, 1)
    FIELD(REG_DBG_MUX_SEL, IN_SEL, 1, 1)
    FIELD(REG_DBG_MUX_SEL, OUT_SEL, 0, 1)
REG32(REG_DBG_TRIG_MODE, 0x1e8)
    FIELD(REG_DBG_TRIG_MODE, ERR_TYPE, 3, 7)
    FIELD(REG_DBG_TRIG_MODE, OPT, 2, 1)
    FIELD(REG_DBG_TRIG_MODE, TRIG_MODE, 0, 2)
REG32(REG_DBG_TRIG_SET_EN0, 0x1ec)
REG32(REG_DBG_TRIG_SET_EN1, 0x1f0)
REG32(REG_DBG_TRIG_SET_VAL0, 0x1f4)
REG32(REG_DBG_TRIG_SET_VAL1, 0x1f8)
REG32(REG_DBG_TIMESTAMP_IN, 0x1fc)
REG32(REG_ERR_LOG_EN, 0x200)
    FIELD(REG_ERR_LOG_EN, WPOISON, 11, 1)
    FIELD(REG_ERR_LOG_EN, VC_CREDIT, 10, 1)
    FIELD(REG_ERR_LOG_EN, NPP_UNEXP, 9, 1)
    FIELD(REG_ERR_LOG_EN, DATA_PAR, 8, 1)
    FIELD(REG_ERR_LOG_EN, ADDR_PAR, 7, 1)
    FIELD(REG_ERR_LOG_EN, TIMEOUT, 6, 1)
    FIELD(REG_ERR_LOG_EN, ECC_1BIT, 5, 1)
    FIELD(REG_ERR_LOG_EN, ECC_2BIT, 4, 1)
    FIELD(REG_ERR_LOG_EN, NPP_IN, 3, 1)
    FIELD(REG_ERR_LOG_EN, XLX_INFOS, 2, 1)
    FIELD(REG_ERR_LOG_EN, XLX_RULES, 1, 1)
    FIELD(REG_ERR_LOG_EN, AXI_RULES, 0, 1)
REG32(REG_1ST_ERR_NUM, 0x204)
    FIELD(REG_1ST_ERR_NUM, ETYPE, 20, 2)
    FIELD(REG_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_PERF_MON0_LATENCY_MIN, 0x208)
    FIELD(REG_PERF_MON0_LATENCY_MIN, NSU, 0, 10)
REG32(REG_PERF_MON0_LATENCY_MAX, 0x20c)
    FIELD(REG_PERF_MON0_LATENCY_MAX, NSU, 0, 10)
REG32(REG_PERF_MON0_LATENCY_ACC_UPR, 0x210)
    FIELD(REG_PERF_MON0_LATENCY_ACC_UPR, NSU, 0, 8)
REG32(REG_PERF_MON0_LATENCY_ACC_LWR, 0x214)
REG32(REG_PERF_MON0_BURST_CNT, 0x218)
REG32(REG_PERF_MON0_CNT_AND_OFL, 0x21c)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, BYTE_CNT_OFL, 12, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, BURST_CNT_OFL, 11, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, LATENCY_ACC_OFL, 10, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, LATENCY_MAX_OFL, 9, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, LATENCY_MIN_OFL, 8, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, BYTE_CNT_UPR, 0, 8)
REG32(REG_PERF_MON0_BYTE_CNT_LWR, 0x220)
REG32(REG_PERF_MON1_LATENCY_MIN, 0x224)
    FIELD(REG_PERF_MON1_LATENCY_MIN, NSU, 0, 10)
REG32(REG_PERF_MON1_LATENCY_MAX, 0x228)
    FIELD(REG_PERF_MON1_LATENCY_MAX, NSU, 0, 10)
REG32(REG_PERF_MON1_LATENCY_ACC_UPR, 0x22c)
    FIELD(REG_PERF_MON1_LATENCY_ACC_UPR, NSU, 0, 8)
REG32(REG_PERF_MON1_LATENCY_ACC_LWR, 0x230)
REG32(REG_PERF_MON1_BURST_CNT, 0x234)
REG32(REG_PERF_MON1_CNT_AND_OFL, 0x238)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, BYTE_CNT_OFL, 12, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, BURST_CNT_OFL, 11, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, LATENCY_ACC_OFL, 10, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, LATENCY_MAX_OFL, 9, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, LATENCY_MIN_OFL, 8, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, BYTE_CNT_UPR, 0, 8)
REG32(REG_PERF_MON1_BYTE_CNT_LWR, 0x23c)
REG32(REG_SRC_TFC_CHK_STAT, 0x240)
    FIELD(REG_SRC_TFC_CHK_STAT, STA_W, 1, 1)
    FIELD(REG_SRC_TFC_CHK_STAT, STA_R, 0, 1)
REG32(REG_ERR_LOG_INFO_0, 0x244)
    FIELD(REG_ERR_LOG_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_INFO_1, 0x248)
    FIELD(REG_ERR_LOG_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_INFO_1, WSTRB, 8, 16)
    FIELD(REG_ERR_LOG_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_INFO_1, PKT_TYPE, 0, 4)
REG32(REG_ERR_LOG_INFO_2, 0x24c)
    FIELD(REG_ERR_LOG_INFO_2, TRK_IDX, 25, 6)
    FIELD(REG_ERR_LOG_INFO_2, NPP_EBIT, 17, 8)
    FIELD(REG_ERR_LOG_INFO_2, TID, 11, 6)
    FIELD(REG_ERR_LOG_INFO_2, TLAST, 10, 1)
    FIELD(REG_ERR_LOG_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_INFO_2, DBI, 8, 1)
    FIELD(REG_ERR_LOG_INFO_2, VC, 0, 8)
REG32(REG_ERR_LOG_INFO_3, 0x250)
    FIELD(REG_ERR_LOG_INFO_3, AXCACHE, 28, 4)
    FIELD(REG_ERR_LOG_INFO_3, AXLOCK, 27, 1)
    FIELD(REG_ERR_LOG_INFO_3, AXSIZE, 24, 3)
    FIELD(REG_ERR_LOG_INFO_3, AXLEN, 16, 8)
    FIELD(REG_ERR_LOG_INFO_3, AXID, 0, 16)
REG32(REG_ERR_LOG_INFO_4, 0x254)
    FIELD(REG_ERR_LOG_INFO_4, VC_MAP, 27, 1)
    FIELD(REG_ERR_LOG_INFO_4, CID, 25, 2)
    FIELD(REG_ERR_LOG_INFO_4, AXPROT, 22, 3)
    FIELD(REG_ERR_LOG_INFO_4, AXBURST, 20, 2)
    FIELD(REG_ERR_LOG_INFO_4, AXQOS, 16, 4)
    FIELD(REG_ERR_LOG_INFO_4, AXUSER, 0, 16)
REG32(REG_ERR_LOG_INFO_5, 0x258)
REG32(REG_ERR_LOG_INFO_6, 0x25c)
REG32(REG_ERR_LOG_INFO_7, 0x260)
    FIELD(REG_ERR_LOG_INFO_7, CREDIT_OFL, 28, 4)
    FIELD(REG_ERR_LOG_INFO_7, CREDIT_UFL, 24, 4)
    FIELD(REG_ERR_LOG_INFO_7, ADDR_PAR, 16, 8)
    FIELD(REG_ERR_LOG_INFO_7, REMAP_MATCH_TDEST, 0, 16)
REG32(REG_ECC_1BIT_ERR_2ND, 0x264)
    FIELD(REG_ECC_1BIT_ERR_2ND, NSU, 0, 1)
REG32(REG_ERR_INJ_STAT, 0x268)
    FIELD(REG_ERR_INJ_STAT, PAR_DST_WR, 8, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_DST_RD, 7, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_DATA_WR, 6, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_ADDR_WR_REGEN, 5, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_ADDR_WR_ORIG, 4, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_ADDR_RD_REGEN, 3, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_ADDR_RD_ORIG, 2, 1)
    FIELD(REG_ERR_INJ_STAT, ECC_WR, 1, 1)
    FIELD(REG_ERR_INJ_STAT, ECC_RD, 0, 1)
REG32(REG_PENDING_BURST, 0x26c)
    FIELD(REG_PENDING_BURST, WR, 7, 7)
    FIELD(REG_PENDING_BURST, RD, 0, 7)
REG32(REG_BUSY, 0x270)
    FIELD(REG_BUSY, NSU, 0, 1)
REG32(REG_DBG_STATUS, 0x274)
    FIELD(REG_DBG_STATUS, INT_ERR_TYPE, 1, 2)
    FIELD(REG_DBG_STATUS, TRIG_DONE, 0, 1)
REG32(REG_DBG_TIMESTAMP_OUT, 0x278)
REG32(REG_SPARE, 0x27c)

#define NOC_NSU_R_MAX (0x1000 / 4)

#define LOCK_VAL 0xF9E8D7C6

typedef struct NOC_NSU {
    SysBusDevice parent_obj;
    RegisterInfoArray *reg_array;

    uint32_t regs[NOC_NSU_R_MAX];
    RegisterInfo regs_info[NOC_NSU_R_MAX];
} NOC_NSU;

static void noc_nsu_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    NOC_NSU *s = XILINX_NOC_NSU(reg->opaque);
    bool locked = val64 != LOCK_VAL;

    ARRAY_FIELD_DP32(s->regs, REG_PCSR_STATUS, PCSRLOCK, locked);
}

static const RegisterAccessInfo noc_nsu_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xfee47d30,
        .ro = 0xe47d30,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x10000c4,
        .rsvd = 0xfee47d30,
        .ro = 0xe47d30,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_PCSRLOCK_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_CALDONE_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = noc_nsu_lock_postw
    },{ .name = "REG_ITR",  .addr = A_REG_ITR,
        .rsvd = 0xffc00000,
    },{ .name = "REG_ISR",  .addr = A_REG_ISR,
        .rsvd = 0xffc00000,
        .w1c = 0x3fffff,
    },{ .name = "REG_IMR0",  .addr = A_REG_IMR0,
        .reset = 0x1fffff,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_IER0",  .addr = A_REG_IER0,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IDR0",  .addr = A_REG_IDR0,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IMR1",  .addr = A_REG_IMR1,
        .reset = 0x3fffff,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_IER1",  .addr = A_REG_IER1,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IDR1",  .addr = A_REG_IDR1,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IMR2",  .addr = A_REG_IMR2,
        .reset = 0x3fffff,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_IER2",  .addr = A_REG_IER2,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IDR2",  .addr = A_REG_IDR2,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IMR3",  .addr = A_REG_IMR3,
        .reset = 0x3fffff,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_IER3",  .addr = A_REG_IER3,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IDR3",  .addr = A_REG_IDR3,
        .rsvd = 0xffc00000,
    },{ .name = "REG_IOR",  .addr = A_REG_IOR,
        .reset = 0x10,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_SRC",  .addr = A_REG_SRC,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DWIDTH",  .addr = A_REG_DWIDTH,
        .reset = 0x4,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_MODE_SELECT",  .addr = A_REG_MODE_SELECT,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_OUTSTANDING_RD_TXN",  .addr = A_REG_OUTSTANDING_RD_TXN,
        .reset = 0x20,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_OUTSTANDING_WR_TXN",  .addr = A_REG_OUTSTANDING_WR_TXN,
        .reset = 0x20,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_COMP_ID_INDEX0",  .addr = A_REG_COMP_ID_INDEX0,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_COMP_ID_INDEX1",  .addr = A_REG_COMP_ID_INDEX1,
        .reset = 0x1,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_COMP_ID_MODE",  .addr = A_REG_COMP_ID_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_FIXED_COMP_ID",  .addr = A_REG_FIXED_COMP_ID,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_DISABLE_EX_MON",  .addr = A_REG_DISABLE_EX_MON,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_TBASE_TRK_TIMEOUT",  .addr = A_REG_TBASE_TRK_TIMEOUT,
        .reset = 0x2,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_TBASE_AXI_TIMEOUT",  .addr = A_REG_TBASE_AXI_TIMEOUT,
        .reset = 0x2,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_PAR_CHK",  .addr = A_REG_PAR_CHK,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ODISABLE_AXI_RESP",  .addr = A_REG_ODISABLE_AXI_RESP,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_DBI",  .addr = A_REG_DBI,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ECC_CHK_EN",  .addr = A_REG_ECC_CHK_EN,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_AXI_LOOPBACK",  .addr = A_REG_AXI_LOOPBACK,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_RD_REQ_VC_MAP0",  .addr = A_REG_RD_REQ_VC_MAP0,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_RD_REQ_VC_MAP1",  .addr = A_REG_RD_REQ_VC_MAP1,
        .reset = 0x4,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_WR_REQ_VC_MAP0",  .addr = A_REG_WR_REQ_VC_MAP0,
        .reset = 0x1,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_WR_REQ_VC_MAP1",  .addr = A_REG_WR_REQ_VC_MAP1,
        .reset = 0x5,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_RD_RESP_VC_MAP0",  .addr = A_REG_RD_RESP_VC_MAP0,
        .reset = 0x2,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_RD_RESP_VC_MAP1",  .addr = A_REG_RD_RESP_VC_MAP1,
        .reset = 0x6,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_WR_RESP_VC_MAP0",  .addr = A_REG_WR_RESP_VC_MAP0,
        .reset = 0x3,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_WR_RESP_VC_MAP1",  .addr = A_REG_WR_RESP_VC_MAP1,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_PR_MODE",  .addr = A_REG_PR_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_FLUSH_MODE",  .addr = A_REG_FLUSH_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_NOC_CLK_GATE_DIS",  .addr = A_REG_NOC_CLK_GATE_DIS,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_FAB_CLK_GATE_DIS",  .addr = A_REG_FAB_CLK_GATE_DIS,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_RD_VCA_TOKEN0",  .addr = A_REG_RD_VCA_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_RD_VCA_TOKEN1",  .addr = A_REG_RD_VCA_TOKEN1,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_WR_VCA_TOKEN0",  .addr = A_REG_WR_VCA_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_WR_VCA_TOKEN1",  .addr = A_REG_WR_VCA_TOKEN1,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_RDTRK_VCA_TOKEN0",  .addr = A_REG_RDTRK_VCA_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_RDTRK_VCA_TOKEN1",  .addr = A_REG_RDTRK_VCA_TOKEN1,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_WRTRK_VCA_TOKEN0",  .addr = A_REG_WRTRK_VCA_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_WRTRK_VCA_TOKEN1",  .addr = A_REG_WRTRK_VCA_TOKEN1,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_VMAP_OUT_RD_TOKEN0",  .addr = A_REG_VMAP_OUT_RD_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_VMAP_OUT_RD_TOKEN1",  .addr = A_REG_VMAP_OUT_RD_TOKEN1,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_VMAP_OUT_WR_TOKEN0",  .addr = A_REG_VMAP_OUT_WR_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_VMAP_OUT_WR_TOKEN1",  .addr = A_REG_VMAP_OUT_WR_TOKEN1,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_PERF_MON0_CTRL",  .addr = A_REG_PERF_MON0_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_PERF_MON1_CTRL",  .addr = A_REG_PERF_MON1_CTRL,
        .reset = 0xe,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_PERF_FLT0_CMP_S0",  .addr = A_REG_PERF_FLT0_CMP_S0,
    },{ .name = "REG_PERF_FLT0_CMP_S1",  .addr = A_REG_PERF_FLT0_CMP_S1,
        .rsvd = 0xff000000,
    },{ .name = "REG_PERF_FLT0_CMP_S2",  .addr = A_REG_PERF_FLT0_CMP_S2,
        .rsvd = 0xffff8000,
    },{ .name = "REG_PERF_FLT0_CMP_EN",  .addr = A_REG_PERF_FLT0_CMP_EN,
        .rsvd = 0xfffff000,
    },{ .name = "REG_PERF_FLT1_CMP_S0",  .addr = A_REG_PERF_FLT1_CMP_S0,
    },{ .name = "REG_PERF_FLT1_CMP_S1",  .addr = A_REG_PERF_FLT1_CMP_S1,
        .rsvd = 0xff000000,
    },{ .name = "REG_PERF_FLT1_CMP_S2",  .addr = A_REG_PERF_FLT1_CMP_S2,
        .rsvd = 0xffff8000,
    },{ .name = "REG_PERF_FLT1_CMP_EN",  .addr = A_REG_PERF_FLT1_CMP_EN,
        .rsvd = 0xfffff000,
    },{ .name = "REG_PERF_MON_TBASE",  .addr = A_REG_PERF_MON_TBASE,
        .reset = 0x3,
        .rsvd = 0xffffff00,
    },{ .name = "REG_SRC_TFC_CHK_CTRL",  .addr = A_REG_SRC_TFC_CHK_CTRL,
        .reset = 0x1000,
        .rsvd = 0xffffe000,
    },{ .name = "REG_ERR_INJ_MODE",  .addr = A_REG_ERR_INJ_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ERR_INJ_EN",  .addr = A_REG_ERR_INJ_EN,
        .rsvd = 0xfe000000,
    },{ .name = "REG_ERR_INJ_INDEX_0",  .addr = A_REG_ERR_INJ_INDEX_0,
        .rsvd = 0xe0000000,
    },{ .name = "REG_ERR_INJ_INDEX_1",  .addr = A_REG_ERR_INJ_INDEX_1,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_DBG_MUX_SEL",  .addr = A_REG_DBG_MUX_SEL,
        .reset = 0x6,
        .rsvd = 0xfffffe00,
    },{ .name = "REG_DBG_TRIG_MODE",  .addr = A_REG_DBG_TRIG_MODE,
        .reset = 0x12,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_DBG_TRIG_SET_EN0",  .addr = A_REG_DBG_TRIG_SET_EN0,
        .reset = 0xffff,
    },{ .name = "REG_DBG_TRIG_SET_EN1",  .addr = A_REG_DBG_TRIG_SET_EN1,
    },{ .name = "REG_DBG_TRIG_SET_VAL0",  .addr = A_REG_DBG_TRIG_SET_VAL0,
        .reset = 0xb1b0,
    },{ .name = "REG_DBG_TRIG_SET_VAL1",  .addr = A_REG_DBG_TRIG_SET_VAL1,
    },{ .name = "REG_DBG_TIMESTAMP_IN",  .addr = A_REG_DBG_TIMESTAMP_IN,
        .reset = 0x65,
    },{ .name = "REG_ERR_LOG_EN",  .addr = A_REG_ERR_LOG_EN,
        .reset = 0xfff,
        .rsvd = 0xfffff000,
    },{ .name = "REG_1ST_ERR_NUM",  .addr = A_REG_1ST_ERR_NUM,
        .reset = 0x20,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_PERF_MON0_LATENCY_MIN",
        .addr = A_REG_PERF_MON0_LATENCY_MIN,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON0_LATENCY_MAX",
        .addr = A_REG_PERF_MON0_LATENCY_MAX,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON0_LATENCY_ACC_UPR",
        .addr = A_REG_PERF_MON0_LATENCY_ACC_UPR,
        .rsvd = 0xffffff00,
    },{ .name = "REG_PERF_MON0_LATENCY_ACC_LWR",
        .addr = A_REG_PERF_MON0_LATENCY_ACC_LWR,
    },{ .name = "REG_PERF_MON0_BURST_CNT",  .addr = A_REG_PERF_MON0_BURST_CNT,
    },{ .name = "REG_PERF_MON0_CNT_AND_OFL",
        .addr = A_REG_PERF_MON0_CNT_AND_OFL,
        .rsvd = 0xffffe000,
    },{ .name = "REG_PERF_MON0_BYTE_CNT_LWR",
        .addr = A_REG_PERF_MON0_BYTE_CNT_LWR,
    },{ .name = "REG_PERF_MON1_LATENCY_MIN",
        .addr = A_REG_PERF_MON1_LATENCY_MIN,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON1_LATENCY_MAX",
        .addr = A_REG_PERF_MON1_LATENCY_MAX,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON1_LATENCY_ACC_UPR",
        .addr = A_REG_PERF_MON1_LATENCY_ACC_UPR,
        .rsvd = 0xffffff00,
    },{ .name = "REG_PERF_MON1_LATENCY_ACC_LWR",
        .addr = A_REG_PERF_MON1_LATENCY_ACC_LWR,
    },{ .name = "REG_PERF_MON1_BURST_CNT",  .addr = A_REG_PERF_MON1_BURST_CNT,
    },{ .name = "REG_PERF_MON1_CNT_AND_OFL",
        .addr = A_REG_PERF_MON1_CNT_AND_OFL,
        .rsvd = 0xffffe000,
    },{ .name = "REG_PERF_MON1_BYTE_CNT_LWR",
        .addr = A_REG_PERF_MON1_BYTE_CNT_LWR,
    },{ .name = "REG_SRC_TFC_CHK_STAT",  .addr = A_REG_SRC_TFC_CHK_STAT,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "REG_ERR_LOG_INFO_0",  .addr = A_REG_ERR_LOG_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_INFO_1",  .addr = A_REG_ERR_LOG_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_INFO_2",  .addr = A_REG_ERR_LOG_INFO_2,
        .rsvd = 0x80000000,
        .ro = 0x7fffffff,
    },{ .name = "REG_ERR_LOG_INFO_3",  .addr = A_REG_ERR_LOG_INFO_3,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_INFO_4",  .addr = A_REG_ERR_LOG_INFO_4,
        .rsvd = 0xf0000000,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_INFO_5",  .addr = A_REG_ERR_LOG_INFO_5,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_INFO_6",  .addr = A_REG_ERR_LOG_INFO_6,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_INFO_7",  .addr = A_REG_ERR_LOG_INFO_7,
        .ro = 0xffffffff,
    },{ .name = "REG_ECC_1BIT_ERR_2ND",  .addr = A_REG_ECC_1BIT_ERR_2ND,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "REG_ERR_INJ_STAT",  .addr = A_REG_ERR_INJ_STAT,
        .rsvd = 0xfffffe00,
        .ro = 0x1ff,
    },{ .name = "REG_PENDING_BURST",  .addr = A_REG_PENDING_BURST,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_BUSY",  .addr = A_REG_BUSY,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "REG_DBG_STATUS",  .addr = A_REG_DBG_STATUS,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_DBG_TIMESTAMP_OUT",  .addr = A_REG_DBG_TIMESTAMP_OUT,
    },{ .name = "REG_SPARE",  .addr = A_REG_SPARE,
    }
};

static void noc_nsu_reset(DeviceState *dev)
{
    NOC_NSU *s = XILINX_NOC_NSU(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps noc_nsu_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void noc_nsu_init(Object *obj)
{
    NOC_NSU *s = XILINX_NOC_NSU(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    s->reg_array =
        register_init_block32(DEVICE(obj), noc_nsu_regs_info,
                              ARRAY_SIZE(noc_nsu_regs_info),
                              s->regs_info, s->regs,
                              &noc_nsu_ops,
                              XILINX_NOC_NSU_ERR_DEBUG,
                              NOC_NSU_R_MAX * 4);
    sysbus_init_mmio(sbd, &s->reg_array->mem);
}

static const VMStateDescription vmstate_noc_nsu = {
    .name = TYPE_XILINX_NOC_NSU,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, NOC_NSU, NOC_NSU_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void noc_nsu_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = noc_nsu_reset;
    dc->vmsd = &vmstate_noc_nsu;
}

static const TypeInfo noc_nsu_info = {
    .name          = TYPE_XILINX_NOC_NSU,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(NOC_NSU),
    .class_init    = noc_nsu_class_init,
    .instance_init = noc_nsu_init,
};

static void noc_nsu_register_types(void)
{
    type_register_static(&noc_nsu_info);
}

type_init(noc_nsu_register_types)
