/*
 * QEMU model of the PSX_RPU_CLUSTER_CORE0 Realtime Processing Unit
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2022-03-22.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "cpu.h"
#include "hw/qdev-properties.h"
#include "hw/fdt_generic_util.h"
#include "qapi/error.h"

#ifndef XILINX_PSX_RPU_CLUSTER_CORE0_ERR_DEBUG
#define XILINX_PSX_RPU_CLUSTER_CORE0_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSX_RPU_CLUSTER_CORE0 "xlnx.psx_rpu_cluster_core0"

#define XILINX_PSX_RPU_CLUSTER_CORE0(obj) \
     OBJECT_CHECK(PSX_RPU_CLUSTER_CORE0, (obj), \
                  TYPE_XILINX_PSX_RPU_CLUSTER_CORE0)

REG32(CORE_0_CFG0, 0x0)
    FIELD(CORE_0_CFG0, REMAP_AXIM_ADDR, 5, 1)
    FIELD(CORE_0_CFG0, TCMBOOT, 4, 1)
    FIELD(CORE_0_CFG0, CPUHALT, 0, 1)
REG32(CORE_0_CFG1, 0x4)
    FIELD(CORE_0_CFG1, THUMBEXCEPTIONS, 8, 1)
    FIELD(CORE_0_CFG1, ENDIANESS, 4, 1)
    FIELD(CORE_0_CFG1, L1CACHEINVDIS, 0, 1)
REG32(CORE_0_VECTABLE, 0x10)
    FIELD(CORE_0_VECTABLE, BASE_HI, 8, 24)
    FIELD(CORE_0_VECTABLE, BASE_LO, 5, 3)
REG32(CORE_0_PRIMERRIDX, 0x40)
    FIELD(CORE_0_PRIMERRIDX, IDX, 0, 25)
REG32(CORE_0_PRIMERRMEM, 0x44)
    FIELD(CORE_0_PRIMERRMEM, MEM, 0, 15)
REG32(CORE_0_PRIMERRV, 0x48)
    FIELD(CORE_0_PRIMERRV, VLD, 0, 1)
REG32(CORE_0_SECMERRIDX, 0x50)
    FIELD(CORE_0_SECMERRIDX, IDX, 0, 25)
REG32(CORE_0_SECMERRMEM, 0x54)
    FIELD(CORE_0_SECMERRMEM, MEM, 0, 15)
REG32(CORE_0_SECMERRV, 0x58)
    FIELD(CORE_0_SECMERRV, VLD, 0, 1)
REG32(CORE0_PRIMERRIDX, 0x5c)
    FIELD(CORE0_PRIMERRIDX, CORE0_PRIMEVLD, 25, 1)
    FIELD(CORE0_PRIMERRIDX, IDX, 0, 25)
REG32(CORE0_PRIMERRMEM, 0x60)
    FIELD(CORE0_PRIMERRMEM, MEM, 0, 15)
REG32(CORE0_SECMERRIDX, 0x64)
    FIELD(CORE0_SECMERRIDX, CORE0_SECMVLD, 25, 1)
    FIELD(CORE0_SECMERRIDX, IDX, 0, 25)
REG32(CORE0_SECMERRMEM, 0x68)
    FIELD(CORE0_SECMERRMEM, MEM, 0, 15)
REG32(CORE_0_STATUS, 0x70)
REG32(CORE_0_PWRDWN, 0x80)
    FIELD(CORE_0_PWRDWN, EN, 0, 1)
REG32(ERREVENT_0_FATAL_STATUS, 0x100)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_19, 19, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_17, 17, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_12, 12, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_10, 10, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_6, 6, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_5, 5, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_4, 4, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_3, 3, 1)
    FIELD(ERREVENT_0_FATAL_STATUS, BIT_1, 1, 1)
REG32(ERREVENT_0_FATAL_MASK, 0x104)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_19, 19, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_17, 17, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_12, 12, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_10, 10, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_6, 6, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_5, 5, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_4, 4, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_3, 3, 1)
    FIELD(ERREVENT_0_FATAL_MASK, BIT_1, 1, 1)
REG32(ERREVENT_0_FATAL_EN, 0x108)
    FIELD(ERREVENT_0_FATAL_EN, BIT_19, 19, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_17, 17, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_12, 12, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_10, 10, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_6, 6, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_5, 5, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_4, 4, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_3, 3, 1)
    FIELD(ERREVENT_0_FATAL_EN, BIT_1, 1, 1)
REG32(ERREVENT_0_FATAL_DIS, 0x10c)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_19, 19, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_17, 17, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_12, 12, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_10, 10, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_6, 6, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_5, 5, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_4, 4, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_3, 3, 1)
    FIELD(ERREVENT_0_FATAL_DIS, BIT_1, 1, 1)
REG32(ERREVENT_0_FATAL_TRIGG, 0x110)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_19, 19, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_17, 17, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_12, 12, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_10, 10, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_6, 6, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_5, 5, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_4, 4, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_3, 3, 1)
    FIELD(ERREVENT_0_FATAL_TRIGG, BIT_1, 1, 1)
REG32(ERREVENT_0_CORR_STATUS, 0x114)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_16, 16, 1)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_11, 11, 1)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_9, 9, 1)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_8, 8, 1)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_7, 7, 1)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_2, 2, 1)
    FIELD(ERREVENT_0_CORR_STATUS, BIT_0, 0, 1)
REG32(ERREVENT_0_CORR_MASK, 0x118)
    FIELD(ERREVENT_0_CORR_MASK, BIT_16, 16, 1)
    FIELD(ERREVENT_0_CORR_MASK, BIT_11, 11, 1)
    FIELD(ERREVENT_0_CORR_MASK, BIT_9, 9, 1)
    FIELD(ERREVENT_0_CORR_MASK, BIT_8, 8, 1)
    FIELD(ERREVENT_0_CORR_MASK, BIT_7, 7, 1)
    FIELD(ERREVENT_0_CORR_MASK, BIT_2, 2, 1)
    FIELD(ERREVENT_0_CORR_MASK, BIT_0, 0, 1)
REG32(ERREVENT_0_CORR_EN, 0x11c)
    FIELD(ERREVENT_0_CORR_EN, BIT_16, 16, 1)
    FIELD(ERREVENT_0_CORR_EN, BIT_11, 11, 1)
    FIELD(ERREVENT_0_CORR_EN, BIT_9, 9, 1)
    FIELD(ERREVENT_0_CORR_EN, BIT_8, 8, 1)
    FIELD(ERREVENT_0_CORR_EN, BIT_7, 7, 1)
    FIELD(ERREVENT_0_CORR_EN, BIT_2, 2, 1)
    FIELD(ERREVENT_0_CORR_EN, BIT_0, 0, 1)
REG32(ERREVENT_0_CORR_DIS, 0x120)
    FIELD(ERREVENT_0_CORR_DIS, BIT_16, 16, 1)
    FIELD(ERREVENT_0_CORR_DIS, BIT_11, 11, 1)
    FIELD(ERREVENT_0_CORR_DIS, BIT_9, 9, 1)
    FIELD(ERREVENT_0_CORR_DIS, BIT_8, 8, 1)
    FIELD(ERREVENT_0_CORR_DIS, BIT_7, 7, 1)
    FIELD(ERREVENT_0_CORR_DIS, BIT_2, 2, 1)
    FIELD(ERREVENT_0_CORR_DIS, BIT_0, 0, 1)
REG32(ERREVENT_0_CORR_TRIGG, 0x124)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_16, 16, 1)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_11, 11, 1)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_9, 9, 1)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_8, 8, 1)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_7, 7, 1)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_2, 2, 1)
    FIELD(ERREVENT_0_CORR_TRIGG, BIT_0, 0, 1)
REG32(ERREVENT_0_TIME_OUT_STATUS, 0x128)
    FIELD(ERREVENT_0_TIME_OUT_STATUS, BIT_15, 15, 1)
    FIELD(ERREVENT_0_TIME_OUT_STATUS, BIT_14, 14, 1)
    FIELD(ERREVENT_0_TIME_OUT_STATUS, BIT_13, 13, 1)
REG32(ERREVENT_0_TIME_OUT_MASK, 0x12c)
    FIELD(ERREVENT_0_TIME_OUT_MASK, BIT_15, 15, 1)
    FIELD(ERREVENT_0_TIME_OUT_MASK, BIT_14, 14, 1)
    FIELD(ERREVENT_0_TIME_OUT_MASK, BIT_13, 13, 1)
REG32(ERREVENT_0_TIME_OUT_EN, 0x130)
    FIELD(ERREVENT_0_TIME_OUT_EN, BIT_15, 15, 1)
    FIELD(ERREVENT_0_TIME_OUT_EN, BIT_14, 14, 1)
    FIELD(ERREVENT_0_TIME_OUT_EN, BIT_13, 13, 1)
REG32(ERREVENT_0_TIME_OUT_DIS, 0x134)
    FIELD(ERREVENT_0_TIME_OUT_DIS, BIT_15, 15, 1)
    FIELD(ERREVENT_0_TIME_OUT_DIS, BIT_14, 14, 1)
    FIELD(ERREVENT_0_TIME_OUT_DIS, BIT_13, 13, 1)
REG32(ERREVENT_0_TIME_OUT_TRIGG, 0x138)
    FIELD(ERREVENT_0_TIME_OUT_TRIGG, BIT_15, 15, 1)
    FIELD(ERREVENT_0_TIME_OUT_TRIGG, BIT_14, 14, 1)
    FIELD(ERREVENT_0_TIME_OUT_TRIGG, BIT_13, 13, 1)
REG32(ERREVENT_0_EXCEPTION_STATUS, 0x13c)
    FIELD(ERREVENT_0_EXCEPTION_STATUS, BIT_24, 24, 1)
    FIELD(ERREVENT_0_EXCEPTION_STATUS, BIT_23, 23, 1)
    FIELD(ERREVENT_0_EXCEPTION_STATUS, BIT_22, 22, 1)
    FIELD(ERREVENT_0_EXCEPTION_STATUS, BIT_21, 21, 1)
    FIELD(ERREVENT_0_EXCEPTION_STATUS, BIT_20, 20, 1)
REG32(ERREVENT_0_EXCEPTION_MASK, 0x140)
    FIELD(ERREVENT_0_EXCEPTION_MASK, BIT_24, 24, 1)
    FIELD(ERREVENT_0_EXCEPTION_MASK, BIT_23, 23, 1)
    FIELD(ERREVENT_0_EXCEPTION_MASK, BIT_22, 22, 1)
    FIELD(ERREVENT_0_EXCEPTION_MASK, BIT_21, 21, 1)
    FIELD(ERREVENT_0_EXCEPTION_MASK, BIT_20, 20, 1)
REG32(ERREVENT_0_EXCEPTION_TRIGG, 0x144)
    FIELD(ERREVENT_0_EXCEPTION_TRIGG, BIT_24, 24, 1)
    FIELD(ERREVENT_0_EXCEPTION_TRIGG, BIT_23, 23, 1)
    FIELD(ERREVENT_0_EXCEPTION_TRIGG, BIT_22, 22, 1)
    FIELD(ERREVENT_0_EXCEPTION_TRIGG, BIT_21, 21, 1)
    FIELD(ERREVENT_0_EXCEPTION_TRIGG, BIT_20, 20, 1)
REG32(ERREVENT_0_IMP_TESTR1_STATUS, 0x150)
    FIELD(ERREVENT_0_IMP_TESTR1_STATUS, BIT_25, 25, 1)
REG32(ERREVENT_0_IMP_TESTR1_MASK, 0x154)
    FIELD(ERREVENT_0_IMP_TESTR1_MASK, BIT_25, 25, 1)
REG32(ERREVENT_0_IMP_TESTR1_EN, 0x158)
    FIELD(ERREVENT_0_IMP_TESTR1_EN, BIT_25, 25, 1)
REG32(ERREVENT_0_IMP_TESTR1_DIS, 0x15c)
    FIELD(ERREVENT_0_IMP_TESTR1_DIS, BIT_25, 25, 1)
REG32(ERREVENT_0_IMP_TESTR1_TRIGG, 0x160)
    FIELD(ERREVENT_0_IMP_TESTR1_TRIGG, BIT_25, 25, 1)
REG32(ERREVENT_0_IMP_INTMONR_STATUS, 0x164)
    FIELD(ERREVENT_0_IMP_INTMONR_STATUS, BIT_18, 18, 1)
REG32(ERREVENT_0_IMP_INTMONR_MASK, 0x168)
    FIELD(ERREVENT_0_IMP_INTMONR_MASK, BIT_18, 18, 1)
REG32(ERREVENT_0_IMP_INTMONR_EN, 0x16c)
    FIELD(ERREVENT_0_IMP_INTMONR_EN, BIT_18, 18, 1)
REG32(ERREVENT_0_IMP_INTMONR_DIS, 0x170)
    FIELD(ERREVENT_0_IMP_INTMONR_DIS, BIT_18, 18, 1)
REG32(ERREVENT_0_IMP_INTMONR_TRIGG, 0x174)
    FIELD(ERREVENT_0_IMP_INTMONR_TRIGG, BIT_18, 18, 1)
REG32(ERREVENT_0_EXCEPTION_EN, 0x1e4)
    FIELD(ERREVENT_0_EXCEPTION_EN, BIT_24, 24, 1)
    FIELD(ERREVENT_0_EXCEPTION_EN, BIT_23, 23, 1)
    FIELD(ERREVENT_0_EXCEPTION_EN, BIT_22, 22, 1)
    FIELD(ERREVENT_0_EXCEPTION_EN, BIT_21, 21, 1)
    FIELD(ERREVENT_0_EXCEPTION_EN, BIT_20, 20, 1)
REG32(ERREVENT_0_EXCEPTION_DIS, 0x1e8)
    FIELD(ERREVENT_0_EXCEPTION_DIS, BIT_24, 24, 1)
    FIELD(ERREVENT_0_EXCEPTION_DIS, BIT_23, 23, 1)
    FIELD(ERREVENT_0_EXCEPTION_DIS, BIT_22, 22, 1)
    FIELD(ERREVENT_0_EXCEPTION_DIS, BIT_21, 21, 1)
    FIELD(ERREVENT_0_EXCEPTION_DIS, BIT_20, 20, 1)
REG32(RPU_CORE0_ISR, 0x200)
    FIELD(RPU_CORE0_ISR, CORE0_PWR_ERR, 3, 1)
    FIELD(RPU_CORE0_ISR, CORE0_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE0_ISR, CORE0_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE0_IMR, 0x204)
    FIELD(RPU_CORE0_IMR, CORE0_PWR_ERR, 3, 1)
    FIELD(RPU_CORE0_IMR, CORE0_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE0_IMR, CORE0_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE0_IEN, 0x208)
    FIELD(RPU_CORE0_IEN, CORE0_PWR_ERR, 3, 1)
    FIELD(RPU_CORE0_IEN, CORE0_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE0_IEN, CORE0_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE0_IDS, 0x100c)
    FIELD(RPU_CORE0_IDS, CORE0_PWR_ERR, 3, 1)
    FIELD(RPU_CORE0_IDS, CORE0_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE0_IDS, CORE0_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE0_PAR_MON, 0x1104)
    FIELD(RPU_CORE0_PAR_MON, CORE0_PAR_MON_EN, 0, 1)

#define PSX_RPU_CLUSTER_CORE0_R_MAX (R_RPU_CORE0_PAR_MON + 1)

typedef struct PSX_RPU_CLUSTER_CORE0 {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_rpu_core0_imr;
    qemu_irq irq_errevent_0_exception;
    qemu_irq irq_errevent_0_fatal;
    qemu_irq irq_errevent_0_time_out;
    qemu_irq irq_errevent_0_imp_testr1;
    qemu_irq irq_errevent_0_imp_intmonr;
    qemu_irq irq_errevent_0_corr;

    qemu_irq halt;
    qemu_irq thumb;
    bool cpu_rst;
    ARMCPU *core;

    uint32_t regs[PSX_RPU_CLUSTER_CORE0_R_MAX];
    RegisterInfo regs_info[PSX_RPU_CLUSTER_CORE0_R_MAX];
} PSX_RPU_CLUSTER_CORE0;

static void rpu_core0_imr_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_RPU_CORE0_ISR] & ~s->regs[R_RPU_CORE0_IMR];
    qemu_set_irq(s->irq_rpu_core0_imr, pending);
}

static void rpu_core0_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    rpu_core0_imr_update_irq(s);
}

static uint64_t rpu_core0_ien_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RPU_CORE0_IMR] &= ~val;
    rpu_core0_imr_update_irq(s);
    return 0;
}

static uint64_t rpu_core0_ids_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RPU_CORE0_IMR] |= val;
    rpu_core0_imr_update_irq(s);
    return 0;
}

static void errevent_0_exception_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_ERREVENT_0_EXCEPTION_STATUS] &
                   ~s->regs[R_ERREVENT_0_EXCEPTION_MASK];
    qemu_set_irq(s->irq_errevent_0_exception, pending);
}

static void errevent_0_exception_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    errevent_0_exception_update_irq(s);
}

static uint64_t errevent_0_exception_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_EXCEPTION_MASK] &= ~val;
    errevent_0_exception_update_irq(s);
    return 0;
}

static uint64_t errevent_0_exception_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_EXCEPTION_MASK] |= val;
    errevent_0_exception_update_irq(s);
    return 0;
}

static uint64_t errevent_0_exception_trigg_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_EXCEPTION_STATUS] |= val;
    errevent_0_exception_update_irq(s);
    return 0;
}

static void errevent_0_fatal_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_ERREVENT_0_FATAL_STATUS] &
                   ~s->regs[R_ERREVENT_0_FATAL_MASK];
    qemu_set_irq(s->irq_errevent_0_fatal, pending);
}

static void errevent_0_fatal_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    errevent_0_fatal_update_irq(s);
}

static uint64_t errevent_0_fatal_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_FATAL_MASK] &= ~val;
    errevent_0_fatal_update_irq(s);
    return 0;
}

static uint64_t errevent_0_fatal_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_FATAL_MASK] |= val;
    errevent_0_fatal_update_irq(s);
    return 0;
}

static uint64_t errevent_0_fatal_trigg_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_FATAL_STATUS] |= val;
    errevent_0_fatal_update_irq(s);
    return 0;
}

static void errevent_0_time_out_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_ERREVENT_0_TIME_OUT_STATUS] &
                   ~s->regs[R_ERREVENT_0_TIME_OUT_MASK];
    qemu_set_irq(s->irq_errevent_0_time_out, pending);
}

static void errevent_0_time_out_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    errevent_0_time_out_update_irq(s);
}

static uint64_t errevent_0_time_out_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_TIME_OUT_MASK] &= ~val;
    errevent_0_time_out_update_irq(s);
    return 0;
}

static uint64_t errevent_0_time_out_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_TIME_OUT_MASK] |= val;
    errevent_0_time_out_update_irq(s);
    return 0;
}

static uint64_t errevent_0_time_out_trigg_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_TIME_OUT_STATUS] |= val;
    errevent_0_time_out_update_irq(s);
    return 0;
}

static void errevent_0_imp_testr1_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_ERREVENT_0_IMP_TESTR1_STATUS] &
                   ~s->regs[R_ERREVENT_0_IMP_TESTR1_MASK];
    qemu_set_irq(s->irq_errevent_0_imp_testr1, pending);
}

static void errevent_0_imp_testr1_status_postw(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    errevent_0_imp_testr1_update_irq(s);
}

static uint64_t errevent_0_imp_testr1_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_IMP_TESTR1_MASK] &= ~val;
    errevent_0_imp_testr1_update_irq(s);
    return 0;
}

static uint64_t errevent_0_imp_testr1_dis_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_IMP_TESTR1_MASK] |= val;
    errevent_0_imp_testr1_update_irq(s);
    return 0;
}

static uint64_t errevent_0_imp_testr1_trigg_prew(RegisterInfo *reg,
                                                 uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_IMP_TESTR1_STATUS] |= val;
    errevent_0_imp_testr1_update_irq(s);
    return 0;
}

static void errevent_0_imp_intmonr_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_ERREVENT_0_IMP_INTMONR_STATUS] &
                   ~s->regs[R_ERREVENT_0_IMP_INTMONR_MASK];
    qemu_set_irq(s->irq_errevent_0_imp_intmonr, pending);
}

static void errevent_0_imp_intmonr_status_postw(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    errevent_0_imp_intmonr_update_irq(s);
}

static uint64_t errevent_0_imp_intmonr_en_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_IMP_INTMONR_MASK] &= ~val;
    errevent_0_imp_intmonr_update_irq(s);
    return 0;
}

static uint64_t errevent_0_imp_intmonr_dis_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_IMP_INTMONR_MASK] |= val;
    errevent_0_imp_intmonr_update_irq(s);
    return 0;
}

static uint64_t errevent_0_imp_intmonr_trigg_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_IMP_INTMONR_STATUS] |= val;
    errevent_0_imp_intmonr_update_irq(s);
    return 0;
}

static void errevent_0_corr_update_irq(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool pending = s->regs[R_ERREVENT_0_CORR_STATUS] &
                   ~s->regs[R_ERREVENT_0_CORR_MASK];
    qemu_set_irq(s->irq_errevent_0_corr, pending);
}

static void errevent_0_corr_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    errevent_0_corr_update_irq(s);
}

static uint64_t errevent_0_corr_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_CORR_MASK] &= ~val;
    errevent_0_corr_update_irq(s);
    return 0;
}

static uint64_t errevent_0_corr_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_CORR_MASK] |= val;
    errevent_0_corr_update_irq(s);
    return 0;
}

static uint64_t errevent_0_corr_trigg_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_0_CORR_STATUS] |= val;
    errevent_0_corr_update_irq(s);
    return 0;
}

static void rpu_update_gpios(PSX_RPU_CLUSTER_CORE0 *s)
{
    bool ncpuhalt;
    bool use_thumb;

    ncpuhalt = ARRAY_FIELD_EX32(s->regs, CORE_0_CFG0, CPUHALT);

    use_thumb = ARRAY_FIELD_EX32(s->regs, CORE_0_CFG1, THUMBEXCEPTIONS);

    qemu_set_irq(s->halt, s->cpu_rst | ncpuhalt);
    qemu_set_irq(s->thumb, use_thumb);
}

static void core_cfg_postw(RegisterInfo *reg, uint64_t val)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);

    rpu_update_gpios(s);
}

static void vectable_base_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(reg->opaque);

    if (s->core) {
        CPUClass *cc = CPU_GET_CLASS(s->core);
        object_property_set_int(OBJECT(s->core), "rvbar",
                                val64, &error_abort);
        if (s->cpu_rst) {
            cc->set_pc(CPU(s->core), val64);
        }
    }
}

static const RegisterAccessInfo psx_rpu_cluster_core0_regs_info[] = {
    {   .name = "CORE_0_CFG0",  .addr = A_CORE_0_CFG0,
        .reset = 0x10,
        .rsvd = 0xffffffce,
        .post_write = core_cfg_postw,
    },{ .name = "CORE_0_CFG1",  .addr = A_CORE_0_CFG1,
        .rsvd = 0xfffffeee,
        .post_write = core_cfg_postw,
    },{ .name = "CORE_0_VECTABLE",  .addr = A_CORE_0_VECTABLE,
        .rsvd = 0x1f,
        .post_write = vectable_base_postw,
    },{ .name = "CORE_0_PRIMERRIDX",  .addr = A_CORE_0_PRIMERRIDX,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "CORE_0_PRIMERRMEM",  .addr = A_CORE_0_PRIMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE_0_PRIMERRV",  .addr = A_CORE_0_PRIMERRV,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_0_SECMERRIDX",  .addr = A_CORE_0_SECMERRIDX,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "CORE_0_SECMERRMEM",  .addr = A_CORE_0_SECMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE_0_SECMERRV",  .addr = A_CORE_0_SECMERRV,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE0_PRIMERRIDX",  .addr = A_CORE0_PRIMERRIDX,
        .rsvd = 0xfc000000,
        .ro = 0x1ffffff,
        .w1c = 0x2000000,
    },{ .name = "CORE0_PRIMERRMEM",  .addr = A_CORE0_PRIMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE0_SECMERRIDX",  .addr = A_CORE0_SECMERRIDX,
        .rsvd = 0xfc000000,
        .ro = 0x1ffffff,
        .w1c = 0x2000000,
    },{ .name = "CORE0_SECMERRMEM",  .addr = A_CORE0_SECMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE_0_STATUS",  .addr = A_CORE_0_STATUS,
        .rsvd = 0xffffffff,
    },{ .name = "CORE_0_PWRDWN",  .addr = A_CORE_0_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "ERREVENT_0_FATAL_STATUS",  .addr = A_ERREVENT_0_FATAL_STATUS,
        .rsvd = 0xfff5eb85,
        .w1c = 0xa147a,
        .post_write = errevent_0_fatal_status_postw,
    },{ .name = "ERREVENT_0_FATAL_MASK",  .addr = A_ERREVENT_0_FATAL_MASK,
        .reset = 0xa147a,
        .ro = 0xa147a,
    },{ .name = "ERREVENT_0_FATAL_EN",  .addr = A_ERREVENT_0_FATAL_EN,
        .pre_write = errevent_0_fatal_en_prew,
    },{ .name = "ERREVENT_0_FATAL_DIS",  .addr = A_ERREVENT_0_FATAL_DIS,
        .pre_write = errevent_0_fatal_dis_prew,
    },{ .name = "ERREVENT_0_FATAL_TRIGG",  .addr = A_ERREVENT_0_FATAL_TRIGG,
        .pre_write = errevent_0_fatal_trigg_prew,
    },{ .name = "ERREVENT_0_CORR_STATUS",  .addr = A_ERREVENT_0_CORR_STATUS,
        .rsvd = 0xfffef47a,
        .w1c = 0x10b85,
        .post_write = errevent_0_corr_status_postw,
    },{ .name = "ERREVENT_0_CORR_MASK",  .addr = A_ERREVENT_0_CORR_MASK,
        .reset = 0x10b85,
        .ro = 0x10b85,
    },{ .name = "ERREVENT_0_CORR_EN",  .addr = A_ERREVENT_0_CORR_EN,
        .pre_write = errevent_0_corr_en_prew,
    },{ .name = "ERREVENT_0_CORR_DIS",  .addr = A_ERREVENT_0_CORR_DIS,
        .pre_write = errevent_0_corr_dis_prew,
    },{ .name = "ERREVENT_0_CORR_TRIGG",  .addr = A_ERREVENT_0_CORR_TRIGG,
        .pre_write = errevent_0_corr_trigg_prew,
    },{ .name = "ERREVENT_0_TIME_OUT_STATUS",
        .addr = A_ERREVENT_0_TIME_OUT_STATUS,
        .rsvd = 0xffff1fff,
        .w1c = 0xe000,
        .post_write = errevent_0_time_out_status_postw,
    },{ .name = "ERREVENT_0_TIME_OUT_MASK",  .addr = A_ERREVENT_0_TIME_OUT_MASK,
        .reset = 0xe000,
        .ro = 0xe000,
    },{ .name = "ERREVENT_0_TIME_OUT_EN",  .addr = A_ERREVENT_0_TIME_OUT_EN,
        .pre_write = errevent_0_time_out_en_prew,
    },{ .name = "ERREVENT_0_TIME_OUT_DIS",  .addr = A_ERREVENT_0_TIME_OUT_DIS,
        .pre_write = errevent_0_time_out_dis_prew,
    },{ .name = "ERREVENT_0_TIME_OUT_TRIGG",
        .addr = A_ERREVENT_0_TIME_OUT_TRIGG,
        .pre_write = errevent_0_time_out_trigg_prew,
    },{ .name = "ERREVENT_0_EXCEPTION_STATUS",
        .addr = A_ERREVENT_0_EXCEPTION_STATUS,
        .rsvd = 0xfe0fffff,
        .w1c = 0x1f00000,
        .post_write = errevent_0_exception_status_postw,
    },{ .name = "ERREVENT_0_EXCEPTION_MASK",
        .addr = A_ERREVENT_0_EXCEPTION_MASK,
        .reset = 0x1f00000,
        .ro = 0x1f00000,
    },{ .name = "ERREVENT_0_EXCEPTION_TRIGG",
        .addr = A_ERREVENT_0_EXCEPTION_TRIGG,
        .pre_write = errevent_0_exception_trigg_prew,
    },{ .name = "ERREVENT_0_IMP_TESTR1_STATUS",
        .addr = A_ERREVENT_0_IMP_TESTR1_STATUS,
        .rsvd = 0xfdffffff,
        .w1c = 0x2000000,
        .post_write = errevent_0_imp_testr1_status_postw,
    },{ .name = "ERREVENT_0_IMP_TESTR1_MASK",
        .addr = A_ERREVENT_0_IMP_TESTR1_MASK,
        .reset = 0x2000000,
        .ro = 0x2000000,
    },{ .name = "ERREVENT_0_IMP_TESTR1_EN",  .addr = A_ERREVENT_0_IMP_TESTR1_EN,
        .pre_write = errevent_0_imp_testr1_en_prew,
    },{ .name = "ERREVENT_0_IMP_TESTR1_DIS",
        .addr = A_ERREVENT_0_IMP_TESTR1_DIS,
        .pre_write = errevent_0_imp_testr1_dis_prew,
    },{ .name = "ERREVENT_0_IMP_TESTR1_TRIGG",
        .addr = A_ERREVENT_0_IMP_TESTR1_TRIGG,
        .pre_write = errevent_0_imp_testr1_trigg_prew,
    },{ .name = "ERREVENT_0_IMP_INTMONR_STATUS",
        .addr = A_ERREVENT_0_IMP_INTMONR_STATUS,
        .rsvd = 0xfffbffff,
        .w1c = 0x40000,
        .post_write = errevent_0_imp_intmonr_status_postw,
    },{ .name = "ERREVENT_0_IMP_INTMONR_MASK",
        .addr = A_ERREVENT_0_IMP_INTMONR_MASK,
        .reset = 0x40000,
        .ro = 0x40000,
    },{ .name = "ERREVENT_0_IMP_INTMONR_EN",
        .addr = A_ERREVENT_0_IMP_INTMONR_EN,
        .pre_write = errevent_0_imp_intmonr_en_prew,
    },{ .name = "ERREVENT_0_IMP_INTMONR_DIS",
        .addr = A_ERREVENT_0_IMP_INTMONR_DIS,
        .pre_write = errevent_0_imp_intmonr_dis_prew,
    },{ .name = "ERREVENT_0_IMP_INTMONR_TRIGG",
        .addr = A_ERREVENT_0_IMP_INTMONR_TRIGG,
        .pre_write = errevent_0_imp_intmonr_trigg_prew,
    },{ .name = "ERREVENT_0_EXCEPTION_EN",  .addr = A_ERREVENT_0_EXCEPTION_EN,
        .pre_write = errevent_0_exception_en_prew,
    },{ .name = "ERREVENT_0_EXCEPTION_DIS",  .addr = A_ERREVENT_0_EXCEPTION_DIS,
        .pre_write = errevent_0_exception_dis_prew,
    },{ .name = "RPU_CORE0_ISR",  .addr = A_RPU_CORE0_ISR,
        .rsvd = 0xfffffff1,
        .w1c = 0xe,
        .post_write = rpu_core0_isr_postw,
    },{ .name = "RPU_CORE0_IMR",  .addr = A_RPU_CORE0_IMR,
        .reset = 0xe,
        .rsvd = 0xfffffff1,
        .ro = 0xe,
    },{ .name = "RPU_CORE0_IEN",  .addr = A_RPU_CORE0_IEN,
        .rsvd = 0xfffffff1,
        .pre_write = rpu_core0_ien_prew,
    },{ .name = "RPU_CORE0_IDS",  .addr = A_RPU_CORE0_IDS,
        .rsvd = 0xfffffff1,
        .pre_write = rpu_core0_ids_prew,
    },{ .name = "RPU_CORE0_PAR_MON",  .addr = A_RPU_CORE0_PAR_MON,
        .rsvd = 0xfffffffe,
    }
};

static void r52_tcm_region_set(ARMCPU *cpu)
{
    cpu->env.tcmregion.a &= 0x3;
    cpu->env.tcmregion.a |= (7 << 2);

    cpu->env.tcmregion.b &= 0x3;
    cpu->env.tcmregion.b |= ((0x10000 >> 13) << 13) | (7 << 2);

    cpu->env.tcmregion.c &= 0x3;
    cpu->env.tcmregion.c |= ((0x20000 >> 13) << 13) | (7 << 2);
}

static void psx_rpu_cluster_core0_reset_enter(Object *obj, ResetType type)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void psx_rpu_cluster_core0_reset_hold(Object *obj)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(obj);

    rpu_core0_imr_update_irq(s);
    errevent_0_exception_update_irq(s);
    errevent_0_fatal_update_irq(s);
    errevent_0_time_out_update_irq(s);
    errevent_0_imp_testr1_update_irq(s);
    errevent_0_imp_intmonr_update_irq(s);
    errevent_0_corr_update_irq(s);
    r52_tcm_region_set(s->core);
    rpu_update_gpios(s);
}

static const MemoryRegionOps psx_rpu_cluster_core0_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void rpu_core_rst_handler(void *opaque, int irq, int level)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(opaque);

    r52_tcm_region_set(s->core);
    s->cpu_rst = level;
    rpu_update_gpios(s);
}

static void psx_rpu_cluster_core0_realize(DeviceState *dev, Error **errp)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(dev);

    qdev_init_gpio_in_named(dev, rpu_core_rst_handler, "core0-rst", 1);
    qdev_init_gpio_out_named(dev, &s->halt, "halt", 1);
    qdev_init_gpio_out_named(dev, &s->thumb, "thumb", 1);
}

static void psx_rpu_cluster_core0_init(Object *obj)
{
    PSX_RPU_CLUSTER_CORE0 *s = XILINX_PSX_RPU_CLUSTER_CORE0(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSX_RPU_CLUSTER_CORE0,
                       PSX_RPU_CLUSTER_CORE0_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psx_rpu_cluster_core0_regs_info,
                              ARRAY_SIZE(psx_rpu_cluster_core0_regs_info),
                              s->regs_info, s->regs,
                              &psx_rpu_cluster_core0_ops,
                              XILINX_PSX_RPU_CLUSTER_CORE0_ERR_DEBUG,
                              PSX_RPU_CLUSTER_CORE0_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_rpu_core0_imr);
    sysbus_init_irq(sbd, &s->irq_errevent_0_exception);
    sysbus_init_irq(sbd, &s->irq_errevent_0_fatal);
    sysbus_init_irq(sbd, &s->irq_errevent_0_time_out);
    sysbus_init_irq(sbd, &s->irq_errevent_0_imp_testr1);
    sysbus_init_irq(sbd, &s->irq_errevent_0_imp_intmonr);
    sysbus_init_irq(sbd, &s->irq_errevent_0_corr);

    object_property_add_link(obj, "core", TYPE_ARM_CPU,
                         (Object **)&s->core,
                         qdev_prop_allow_set_link_before_realize,
                         OBJ_PROP_LINK_STRONG);
}

static const VMStateDescription vmstate_psx_rpu_cluster_core0 = {
    .name = TYPE_XILINX_PSX_RPU_CLUSTER_CORE0,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSX_RPU_CLUSTER_CORE0,
                             PSX_RPU_CLUSTER_CORE0_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet psx_rpu_core1_cntrl_gpio[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
           { .name = "halt", .fdt_index = 0, .range = 1},
           { .name = "thumb", .fdt_index = 1, .range = 1},
           { },
        },
    },
    { },
};

static const FDTGenericGPIOSet psx_rpu_core1_client_gpio[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
           { .name = "core0-rst", .fdt_index = 0, .range = 1},
           { },
        },
    },
    { },
};

static void psx_rpu_cluster_core0_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->realize = psx_rpu_cluster_core0_realize;
    dc->vmsd = &vmstate_psx_rpu_cluster_core0;
    rc->phases.enter = psx_rpu_cluster_core0_reset_enter;
    rc->phases.hold = psx_rpu_cluster_core0_reset_hold;
    fggc->controller_gpios = psx_rpu_core1_cntrl_gpio;
    fggc->client_gpios = psx_rpu_core1_client_gpio;
}

static const TypeInfo psx_rpu_cluster_core0_info = {
    .name          = TYPE_XILINX_PSX_RPU_CLUSTER_CORE0,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSX_RPU_CLUSTER_CORE0),
    .class_init    = psx_rpu_cluster_core0_class_init,
    .instance_init = psx_rpu_cluster_core0_init,
    .interfaces = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void psx_rpu_cluster_core0_register_types(void)
{
    type_register_static(&psx_rpu_cluster_core0_info);
}

type_init(psx_rpu_cluster_core0_register_types)
