/*
 * QEMU model of the APU_PCIL APU Power Control Interface Logic
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2022-02-04.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_APU_PCIL_ERR_DEBUG
#define XILINX_APU_PCIL_ERR_DEBUG 0
#endif

#define TYPE_XILINX_APU_PCIL "xlnx.apu_pcil"

#define XILINX_APU_PCIL(obj) \
     OBJECT_CHECK(APU_PCIL, (obj), TYPE_XILINX_APU_PCIL)

REG32(CORE_0_PWRDWN, 0x0)
    FIELD(CORE_0_PWRDWN, EN, 0, 1)
REG32(CORE_0_PREQ, 0x4)
    FIELD(CORE_0_PREQ, PREQ, 0, 1)
REG32(CORE_0_PSTATE, 0x8)
    FIELD(CORE_0_PSTATE, PSTATE, 0, 6)
REG32(CORE_0_PACTIVE, 0xc)
    FIELD(CORE_0_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_0_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_0_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_0_ISR_POWER, 0x10)
    FIELD(CORE_0_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_0_IMR_POWER, 0x14)
    FIELD(CORE_0_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_0_IEN_POWER, 0x18)
    FIELD(CORE_0_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_0_IDS_POWER, 0x1c)
    FIELD(CORE_0_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_0_ISR_WAKE, 0x20)
    FIELD(CORE_0_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_0_IMR_WAKE, 0x24)
    FIELD(CORE_0_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_0_IEN_WAKE, 0x28)
    FIELD(CORE_0_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_0_IDS_WAKE, 0x2c)
    FIELD(CORE_0_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_1_PWRDWN, 0x30)
    FIELD(CORE_1_PWRDWN, EN, 0, 1)
REG32(CORE_1_PREQ, 0x34)
    FIELD(CORE_1_PREQ, PREQ, 0, 1)
REG32(CORE_1_PSTATE, 0x38)
    FIELD(CORE_1_PSTATE, PSTATE, 0, 6)
REG32(CORE_1_PACTIVE, 0x3c)
    FIELD(CORE_1_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_1_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_1_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_1_ISR_POWER, 0x40)
    FIELD(CORE_1_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_1_IMR_POWER, 0x44)
    FIELD(CORE_1_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_1_IEN_POWER, 0x48)
    FIELD(CORE_1_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_1_IDS_POWER, 0x4c)
    FIELD(CORE_1_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_1_ISR_WAKE, 0x50)
    FIELD(CORE_1_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_1_IMR_WAKE, 0x54)
    FIELD(CORE_1_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_1_IEN_WAKE, 0x58)
    FIELD(CORE_1_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_1_IDS_WAKE, 0x5c)
    FIELD(CORE_1_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_2_PWRDWN, 0x60)
    FIELD(CORE_2_PWRDWN, EN, 0, 1)
REG32(CORE_2_PREQ, 0x64)
    FIELD(CORE_2_PREQ, PREQ, 0, 1)
REG32(CORE_2_PSTATE, 0x68)
    FIELD(CORE_2_PSTATE, PSTATE, 0, 6)
REG32(CORE_2_PACTIVE, 0x6c)
    FIELD(CORE_2_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_2_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_2_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_2_ISR_POWER, 0x70)
    FIELD(CORE_2_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_2_IMR_POWER, 0x74)
    FIELD(CORE_2_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_2_IEN_POWER, 0x78)
    FIELD(CORE_2_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_2_IDS_POWER, 0x7c)
    FIELD(CORE_2_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_2_ISR_WAKE, 0x80)
    FIELD(CORE_2_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_2_IMR_WAKE, 0x84)
    FIELD(CORE_2_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_2_IEN_WAKE, 0x88)
    FIELD(CORE_2_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_2_IDS_WAKE, 0x8c)
    FIELD(CORE_2_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_3_PWRDWN, 0x90)
    FIELD(CORE_3_PWRDWN, EN, 0, 1)
REG32(CORE_3_PREQ, 0x94)
    FIELD(CORE_3_PREQ, PREQ, 0, 1)
REG32(CORE_3_PSTATE, 0x98)
    FIELD(CORE_3_PSTATE, PSTATE, 0, 6)
REG32(CORE_3_PACTIVE, 0x9c)
    FIELD(CORE_3_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_3_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_3_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_3_ISR_POWER, 0xa0)
    FIELD(CORE_3_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_3_IMR_POWER, 0xa4)
    FIELD(CORE_3_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_3_IEN_POWER, 0xa8)
    FIELD(CORE_3_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_3_IDS_POWER, 0xac)
    FIELD(CORE_3_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_3_ISR_WAKE, 0xb0)
    FIELD(CORE_3_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_3_IMR_WAKE, 0xb4)
    FIELD(CORE_3_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_3_IEN_WAKE, 0xb8)
    FIELD(CORE_3_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_3_IDS_WAKE, 0xbc)
    FIELD(CORE_3_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_4_PWRDWN, 0xc0)
    FIELD(CORE_4_PWRDWN, EN, 0, 1)
REG32(CORE_4_PREQ, 0xc4)
    FIELD(CORE_4_PREQ, PREQ, 0, 1)
REG32(CORE_4_PSTATE, 0xc8)
    FIELD(CORE_4_PSTATE, PSTATE, 0, 6)
REG32(CORE_4_PACTIVE, 0xcc)
    FIELD(CORE_4_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_4_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_4_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_4_ISR_POWER, 0xd0)
    FIELD(CORE_4_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_4_IMR_POWER, 0xd4)
    FIELD(CORE_4_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_4_IEN_POWER, 0xd8)
    FIELD(CORE_4_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_4_IDS_POWER, 0xdc)
    FIELD(CORE_4_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_4_ISR_WAKE, 0xe0)
    FIELD(CORE_4_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_4_IMR_WAKE, 0xe4)
    FIELD(CORE_4_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_4_IEN_WAKE, 0xe8)
    FIELD(CORE_4_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_4_IDS_WAKE, 0xec)
    FIELD(CORE_4_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_5_PWRDWN, 0xf0)
    FIELD(CORE_5_PWRDWN, EN, 0, 1)
REG32(CORE_5_PREQ, 0xf4)
    FIELD(CORE_5_PREQ, PREQ, 0, 1)
REG32(CORE_5_PSTATE, 0xf8)
    FIELD(CORE_5_PSTATE, PSTATE, 0, 6)
REG32(CORE_5_PACTIVE, 0xfc)
    FIELD(CORE_5_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_5_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_5_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_5_ISR_POWER, 0x100)
    FIELD(CORE_5_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_5_IMR_POWER, 0x104)
    FIELD(CORE_5_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_5_IEN_POWER, 0x108)
    FIELD(CORE_5_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_5_IDS_POWER, 0x10c)
    FIELD(CORE_5_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_5_ISR_WAKE, 0x110)
    FIELD(CORE_5_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_5_IMR_WAKE, 0x114)
    FIELD(CORE_5_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_5_IEN_WAKE, 0x118)
    FIELD(CORE_5_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_5_IDS_WAKE, 0x11c)
    FIELD(CORE_5_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_6_PWRDWN, 0x120)
    FIELD(CORE_6_PWRDWN, EN, 0, 1)
REG32(CORE_6_PREQ, 0x124)
    FIELD(CORE_6_PREQ, PREQ, 0, 1)
REG32(CORE_6_PSTATE, 0x128)
    FIELD(CORE_6_PSTATE, PSTATE, 0, 6)
REG32(CORE_6_PACTIVE, 0x12c)
    FIELD(CORE_6_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_6_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_6_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_6_ISR_POWER, 0x130)
    FIELD(CORE_6_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_6_IMR_POWER, 0x134)
    FIELD(CORE_6_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_6_IEN_POWER, 0x138)
    FIELD(CORE_6_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_6_IDS_POWER, 0x13c)
    FIELD(CORE_6_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_6_ISR_WAKE, 0x140)
    FIELD(CORE_6_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_6_IMR_WAKE, 0x144)
    FIELD(CORE_6_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_6_IEN_WAKE, 0x148)
    FIELD(CORE_6_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_6_IDS_WAKE, 0x14c)
    FIELD(CORE_6_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_7_PWRDWN, 0x150)
    FIELD(CORE_7_PWRDWN, EN, 0, 1)
REG32(CORE_7_PREQ, 0x154)
    FIELD(CORE_7_PREQ, PREQ, 0, 1)
REG32(CORE_7_PSTATE, 0x158)
    FIELD(CORE_7_PSTATE, PSTATE, 0, 6)
REG32(CORE_7_PACTIVE, 0x15c)
    FIELD(CORE_7_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_7_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_7_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_7_ISR_POWER, 0x160)
    FIELD(CORE_7_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_7_IMR_POWER, 0x164)
    FIELD(CORE_7_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_7_IEN_POWER, 0x168)
    FIELD(CORE_7_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_7_IDS_POWER, 0x16c)
    FIELD(CORE_7_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_7_ISR_WAKE, 0x170)
    FIELD(CORE_7_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_7_IMR_WAKE, 0x174)
    FIELD(CORE_7_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_7_IEN_WAKE, 0x178)
    FIELD(CORE_7_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_7_IDS_WAKE, 0x17c)
    FIELD(CORE_7_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_8_PWRDWN, 0x180)
    FIELD(CORE_8_PWRDWN, EN, 0, 1)
REG32(CORE_8_PREQ, 0x184)
    FIELD(CORE_8_PREQ, PREQ, 0, 1)
REG32(CORE_8_PSTATE, 0x188)
    FIELD(CORE_8_PSTATE, PSTATE, 0, 6)
REG32(CORE_8_PACTIVE, 0x18c)
    FIELD(CORE_8_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_8_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_8_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_8_ISR_POWER, 0x190)
    FIELD(CORE_8_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_8_IMR_POWER, 0x194)
    FIELD(CORE_8_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_8_IEN_POWER, 0x198)
    FIELD(CORE_8_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_8_IDS_POWER, 0x19c)
    FIELD(CORE_8_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_8_ISR_WAKE, 0x1a0)
    FIELD(CORE_8_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_8_IMR_WAKE, 0x1a4)
    FIELD(CORE_8_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_8_IEN_WAKE, 0x1a8)
    FIELD(CORE_8_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_8_IDS_WAKE, 0x1ac)
    FIELD(CORE_8_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_9_PWRDWN, 0x1b0)
    FIELD(CORE_9_PWRDWN, EN, 0, 1)
REG32(CORE_9_PREQ, 0x1b4)
    FIELD(CORE_9_PREQ, PREQ, 0, 1)
REG32(CORE_9_PSTATE, 0x1b8)
    FIELD(CORE_9_PSTATE, PSTATE, 0, 6)
REG32(CORE_9_PACTIVE, 0x1bc)
    FIELD(CORE_9_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_9_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_9_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_9_ISR_POWER, 0x1c0)
    FIELD(CORE_9_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_9_IMR_POWER, 0x1c4)
    FIELD(CORE_9_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_9_IEN_POWER, 0x1c8)
    FIELD(CORE_9_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_9_IDS_POWER, 0x1cc)
    FIELD(CORE_9_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_9_ISR_WAKE, 0x1d0)
    FIELD(CORE_9_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_9_IMR_WAKE, 0x1d4)
    FIELD(CORE_9_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_9_IEN_WAKE, 0x1d8)
    FIELD(CORE_9_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_9_IDS_WAKE, 0x1dc)
    FIELD(CORE_9_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_10_PWRDWN, 0x1e0)
    FIELD(CORE_10_PWRDWN, EN, 0, 1)
REG32(CORE_10_PREQ, 0x1e4)
    FIELD(CORE_10_PREQ, PREQ, 0, 1)
REG32(CORE_10_PSTATE, 0x1e8)
    FIELD(CORE_10_PSTATE, PSTATE, 0, 6)
REG32(CORE_10_PACTIVE, 0x1ec)
    FIELD(CORE_10_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_10_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_10_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_10_ISR_POWER, 0x1f0)
    FIELD(CORE_10_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_10_IMR_POWER, 0x1f4)
    FIELD(CORE_10_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_10_IEN_POWER, 0x1f8)
    FIELD(CORE_10_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_10_IDS_POWER, 0x1fc)
    FIELD(CORE_10_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_10_ISR_WAKE, 0x200)
    FIELD(CORE_10_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_10_IMR_WAKE, 0x204)
    FIELD(CORE_10_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_10_IEN_WAKE, 0x208)
    FIELD(CORE_10_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_10_IDS_WAKE, 0x20c)
    FIELD(CORE_10_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_11_PWRDWN, 0x210)
    FIELD(CORE_11_PWRDWN, EN, 0, 1)
REG32(CORE_11_PREQ, 0x214)
    FIELD(CORE_11_PREQ, PREQ, 0, 1)
REG32(CORE_11_PSTATE, 0x218)
    FIELD(CORE_11_PSTATE, PSTATE, 0, 6)
REG32(CORE_11_PACTIVE, 0x21c)
    FIELD(CORE_11_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_11_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_11_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_11_ISR_POWER, 0x220)
    FIELD(CORE_11_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_11_IMR_POWER, 0x224)
    FIELD(CORE_11_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_11_IEN_POWER, 0x228)
    FIELD(CORE_11_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_11_IDS_POWER, 0x22c)
    FIELD(CORE_11_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_11_ISR_WAKE, 0x230)
    FIELD(CORE_11_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_11_IMR_WAKE, 0x234)
    FIELD(CORE_11_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_11_IEN_WAKE, 0x238)
    FIELD(CORE_11_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_11_IDS_WAKE, 0x23c)
    FIELD(CORE_11_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_12_PWRDWN, 0x240)
    FIELD(CORE_12_PWRDWN, EN, 0, 1)
REG32(CORE_12_PREQ, 0x244)
    FIELD(CORE_12_PREQ, PREQ, 0, 1)
REG32(CORE_12_PSTATE, 0x248)
    FIELD(CORE_12_PSTATE, PSTATE, 0, 6)
REG32(CORE_12_PACTIVE, 0x24c)
    FIELD(CORE_12_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_12_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_12_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_12_ISR_POWER, 0x250)
    FIELD(CORE_12_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_12_IMR_POWER, 0x254)
    FIELD(CORE_12_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_12_IEN_POWER, 0x258)
    FIELD(CORE_12_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_12_IDS_POWER, 0x25c)
    FIELD(CORE_12_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_12_ISR_WAKE, 0x260)
    FIELD(CORE_12_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_12_IMR_WAKE, 0x264)
    FIELD(CORE_12_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_12_IEN_WAKE, 0x268)
    FIELD(CORE_12_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_12_IDS_WAKE, 0x26c)
    FIELD(CORE_12_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_13_PWRDWN, 0x270)
    FIELD(CORE_13_PWRDWN, EN, 0, 1)
REG32(CORE_13_PREQ, 0x274)
    FIELD(CORE_13_PREQ, PREQ, 0, 1)
REG32(CORE_13_PSTATE, 0x278)
    FIELD(CORE_13_PSTATE, PSTATE, 0, 6)
REG32(CORE_13_PACTIVE, 0x27c)
    FIELD(CORE_13_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_13_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_13_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_13_ISR_POWER, 0x280)
    FIELD(CORE_13_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_13_IMR_POWER, 0x284)
    FIELD(CORE_13_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_13_IEN_POWER, 0x288)
    FIELD(CORE_13_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_13_IDS_POWER, 0x28c)
    FIELD(CORE_13_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_13_ISR_WAKE, 0x290)
    FIELD(CORE_13_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_13_IMR_WAKE, 0x294)
    FIELD(CORE_13_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_13_IEN_WAKE, 0x298)
    FIELD(CORE_13_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_13_IDS_WAKE, 0x29c)
    FIELD(CORE_13_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_14_PWRDWN, 0x2a0)
    FIELD(CORE_14_PWRDWN, EN, 0, 1)
REG32(CORE_14_PREQ, 0x2a4)
    FIELD(CORE_14_PREQ, PREQ, 0, 1)
REG32(CORE_14_PSTATE, 0x2a8)
    FIELD(CORE_14_PSTATE, PSTATE, 0, 6)
REG32(CORE_14_PACTIVE, 0x2ac)
    FIELD(CORE_14_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_14_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_14_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_14_ISR_POWER, 0x2b0)
    FIELD(CORE_14_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_14_IMR_POWER, 0x2b4)
    FIELD(CORE_14_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_14_IEN_POWER, 0x2b8)
    FIELD(CORE_14_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_14_IDS_POWER, 0x2bc)
    FIELD(CORE_14_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_14_ISR_WAKE, 0x2c0)
    FIELD(CORE_14_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_14_IMR_WAKE, 0x2c4)
    FIELD(CORE_14_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_14_IEN_WAKE, 0x2c8)
    FIELD(CORE_14_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_14_IDS_WAKE, 0x2cc)
    FIELD(CORE_14_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_15_PWRDWN, 0x2d0)
    FIELD(CORE_15_PWRDWN, EN, 0, 1)
REG32(CORE_15_PREQ, 0x2d4)
    FIELD(CORE_15_PREQ, PREQ, 0, 1)
REG32(CORE_15_PSTATE, 0x2d8)
    FIELD(CORE_15_PSTATE, PSTATE, 0, 6)
REG32(CORE_15_PACTIVE, 0x2dc)
    FIELD(CORE_15_PACTIVE, PDENY, 25, 1)
    FIELD(CORE_15_PACTIVE, PACCEPT, 24, 1)
    FIELD(CORE_15_PACTIVE, PACTIVE, 0, 18)
REG32(CORE_15_ISR_POWER, 0x2e0)
    FIELD(CORE_15_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_15_IMR_POWER, 0x2e4)
    FIELD(CORE_15_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CORE_15_IEN_POWER, 0x2e8)
    FIELD(CORE_15_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CORE_15_IDS_POWER, 0x2ec)
    FIELD(CORE_15_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CORE_15_ISR_WAKE, 0x2f0)
    FIELD(CORE_15_ISR_WAKE, WAKE, 0, 1)
REG32(CORE_15_IMR_WAKE, 0x2f4)
    FIELD(CORE_15_IMR_WAKE, WAKE, 0, 1)
REG32(CORE_15_IEN_WAKE, 0x2f8)
    FIELD(CORE_15_IEN_WAKE, WAKE, 0, 1)
REG32(CORE_15_IDS_WAKE, 0x2fc)
    FIELD(CORE_15_IDS_WAKE, WAKE, 0, 1)
REG32(CORE_DBG_ISR_PWRUP_REQ, 0x300)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_15, 15, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_14, 14, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_13, 13, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_12, 12, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_11, 11, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_10, 10, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_9, 9, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_8, 8, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_7, 7, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_6, 6, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_5, 5, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_4, 4, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_3, 3, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_2, 2, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_1, 1, 1)
    FIELD(CORE_DBG_ISR_PWRUP_REQ, CORE_0, 0, 1)
REG32(CORE_DBG_IMR_PWRUP_REQ, 0x304)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_15, 15, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_14, 14, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_13, 13, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_12, 12, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_11, 11, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_10, 10, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_9, 9, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_8, 8, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_7, 7, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_6, 6, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_5, 5, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_4, 4, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_3, 3, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_2, 2, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_1, 1, 1)
    FIELD(CORE_DBG_IMR_PWRUP_REQ, CORE_0, 0, 1)
REG32(CORE_DBG_IEN_PWRUP_REQ, 0x308)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_15, 15, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_14, 14, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_13, 13, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_12, 12, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_11, 11, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_10, 10, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_9, 9, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_8, 8, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_7, 7, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_6, 6, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_5, 5, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_4, 4, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_3, 3, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_2, 2, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_1, 1, 1)
    FIELD(CORE_DBG_IEN_PWRUP_REQ, CORE_0, 0, 1)
REG32(CORE_DBG_IDS_PWRUP_REQ, 0x30c)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_15, 15, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_14, 14, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_13, 13, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_12, 12, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_11, 11, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_10, 10, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_9, 9, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_8, 8, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_7, 7, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_6, 6, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_5, 5, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_4, 4, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_3, 3, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_2, 2, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_1, 1, 1)
    FIELD(CORE_DBG_IDS_PWRUP_REQ, CORE_0, 0, 1)
REG32(CLUSTER_DBG_ISR_PWRUP_REQ, 0x310)
    FIELD(CLUSTER_DBG_ISR_PWRUP_REQ, CLUSTER_3, 3, 1)
    FIELD(CLUSTER_DBG_ISR_PWRUP_REQ, CLUSTER_2, 2, 1)
    FIELD(CLUSTER_DBG_ISR_PWRUP_REQ, CLUSTER_1, 1, 1)
    FIELD(CLUSTER_DBG_ISR_PWRUP_REQ, CLUSTER_0, 0, 1)
REG32(CLUSTER_DBG_IMR_PWRUP_REQ, 0x314)
    FIELD(CLUSTER_DBG_IMR_PWRUP_REQ, CLUSTER_3, 3, 1)
    FIELD(CLUSTER_DBG_IMR_PWRUP_REQ, CLUSTER_2, 2, 1)
    FIELD(CLUSTER_DBG_IMR_PWRUP_REQ, CLUSTER_1, 1, 1)
    FIELD(CLUSTER_DBG_IMR_PWRUP_REQ, CLUSTER_0, 0, 1)
REG32(CLUSTER_DBG_IEN_PWRUP_REQ, 0x318)
    FIELD(CLUSTER_DBG_IEN_PWRUP_REQ, CLUSTER_3, 3, 1)
    FIELD(CLUSTER_DBG_IEN_PWRUP_REQ, CLUSTER_2, 2, 1)
    FIELD(CLUSTER_DBG_IEN_PWRUP_REQ, CLUSTER_1, 1, 1)
    FIELD(CLUSTER_DBG_IEN_PWRUP_REQ, CLUSTER_0, 0, 1)
REG32(CLUSTER_DBG_IDS_PWRUP_REQ, 0x31c)
    FIELD(CLUSTER_DBG_IDS_PWRUP_REQ, CLUSTER_3, 3, 1)
    FIELD(CLUSTER_DBG_IDS_PWRUP_REQ, CLUSTER_2, 2, 1)
    FIELD(CLUSTER_DBG_IDS_PWRUP_REQ, CLUSTER_1, 1, 1)
    FIELD(CLUSTER_DBG_IDS_PWRUP_REQ, CLUSTER_0, 0, 1)
REG32(CLUSTER_0_PREQ, 0x8004)
    FIELD(CLUSTER_0_PREQ, PREQ, 0, 1)
REG32(CLUSTER_0_PSTATE, 0x8008)
    FIELD(CLUSTER_0_PSTATE, PSTATE, 0, 7)
REG32(CLUSTER_0_PACTIVE, 0x800c)
    FIELD(CLUSTER_0_PACTIVE, PDENY, 25, 1)
    FIELD(CLUSTER_0_PACTIVE, PACCEPT, 24, 1)
    FIELD(CLUSTER_0_PACTIVE, PACTIVE, 0, 20)
REG32(CLUSTER_0_ISR_POWER, 0x8010)
    FIELD(CLUSTER_0_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_0_IMR_POWER, 0x8014)
    FIELD(CLUSTER_0_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_0_IEN_POWER, 0x8018)
    FIELD(CLUSTER_0_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_0_IDS_POWER, 0x801c)
    FIELD(CLUSTER_0_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_0_ISR_WAKE, 0x8020)
    FIELD(CLUSTER_0_ISR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_0_IMR_WAKE, 0x8024)
    FIELD(CLUSTER_0_IMR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_0_IEN_WAKE, 0x8028)
    FIELD(CLUSTER_0_IEN_WAKE, WAKE, 0, 1)
REG32(CLUSTER_0_IDS_WAKE, 0x802c)
    FIELD(CLUSTER_0_IDS_WAKE, WAKE, 0, 1)
REG32(CLUSTER_1_PREQ, 0x9004)
    FIELD(CLUSTER_1_PREQ, PREQ, 0, 1)
REG32(CLUSTER_1_PSTATE, 0x9008)
    FIELD(CLUSTER_1_PSTATE, PSTATE, 0, 7)
REG32(CLUSTER_1_PACTIVE, 0x900c)
    FIELD(CLUSTER_1_PACTIVE, PDENY, 25, 1)
    FIELD(CLUSTER_1_PACTIVE, PACCEPT, 24, 1)
    FIELD(CLUSTER_1_PACTIVE, PACTIVE, 0, 20)
REG32(CLUSTER_1_ISR_POWER, 0x9010)
    FIELD(CLUSTER_1_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_1_IMR_POWER, 0x9014)
    FIELD(CLUSTER_1_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_1_IEN_POWER, 0x9018)
    FIELD(CLUSTER_1_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_1_IDS_POWER, 0x901c)
    FIELD(CLUSTER_1_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_1_ISR_WAKE, 0x9020)
    FIELD(CLUSTER_1_ISR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_1_IMR_WAKE, 0x9024)
    FIELD(CLUSTER_1_IMR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_1_IEN_WAKE, 0x9028)
    FIELD(CLUSTER_1_IEN_WAKE, WAKE, 0, 1)
REG32(CLUSTER_1_IDS_WAKE, 0x902c)
    FIELD(CLUSTER_1_IDS_WAKE, WAKE, 0, 1)
REG32(CLUSTER_2_PREQ, 0xa004)
    FIELD(CLUSTER_2_PREQ, PREQ, 0, 1)
REG32(CLUSTER_2_PSTATE, 0xa008)
    FIELD(CLUSTER_2_PSTATE, PSTATE, 0, 7)
REG32(CLUSTER_2_PACTIVE, 0xa00c)
    FIELD(CLUSTER_2_PACTIVE, PDENY, 25, 1)
    FIELD(CLUSTER_2_PACTIVE, PACCEPT, 24, 1)
    FIELD(CLUSTER_2_PACTIVE, PACTIVE, 0, 20)
REG32(CLUSTER_2_ISR_POWER, 0xa010)
    FIELD(CLUSTER_2_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_2_IMR_POWER, 0xa014)
    FIELD(CLUSTER_2_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_2_IEN_POWER, 0xa018)
    FIELD(CLUSTER_2_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_2_IDS_POWER, 0xa01c)
    FIELD(CLUSTER_2_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_2_ISR_WAKE, 0xa020)
    FIELD(CLUSTER_2_ISR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_2_IMR_WAKE, 0xa024)
    FIELD(CLUSTER_2_IMR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_2_IEN_WAKE, 0xa028)
    FIELD(CLUSTER_2_IEN_WAKE, WAKE, 0, 1)
REG32(CLUSTER_2_IDS_WAKE, 0xa02c)
    FIELD(CLUSTER_2_IDS_WAKE, WAKE, 0, 1)
REG32(CLUSTER_3_PREQ, 0xb004)
    FIELD(CLUSTER_3_PREQ, PREQ, 0, 1)
REG32(CLUSTER_3_PSTATE, 0xb008)
    FIELD(CLUSTER_3_PSTATE, PSTATE, 0, 7)
REG32(CLUSTER_3_PACTIVE, 0xb00c)
    FIELD(CLUSTER_3_PACTIVE, PDENY, 25, 1)
    FIELD(CLUSTER_3_PACTIVE, PACCEPT, 24, 1)
    FIELD(CLUSTER_3_PACTIVE, PACTIVE, 0, 20)
REG32(CLUSTER_3_ISR_POWER, 0xb010)
    FIELD(CLUSTER_3_ISR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_3_IMR_POWER, 0xb014)
    FIELD(CLUSTER_3_IMR_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_3_IEN_POWER, 0xb018)
    FIELD(CLUSTER_3_IEN_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_3_IDS_POWER, 0xb01c)
    FIELD(CLUSTER_3_IDS_POWER, POWER_DOWN, 0, 1)
REG32(CLUSTER_3_ISR_WAKE, 0xb020)
    FIELD(CLUSTER_3_ISR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_3_IMR_WAKE, 0xb024)
    FIELD(CLUSTER_3_IMR_WAKE, WAKE, 0, 1)
REG32(CLUSTER_3_IEN_WAKE, 0xb028)
    FIELD(CLUSTER_3_IEN_WAKE, WAKE, 0, 1)
REG32(CLUSTER_3_IDS_WAKE, 0xb02c)
    FIELD(CLUSTER_3_IDS_WAKE, WAKE, 0, 1)
REG32(APU_PCIL_ISR, 0xf000)
    FIELD(APU_PCIL_ISR, APB_ERR, 0, 1)
REG32(APU_PCIL_IMR, 0xf004)
    FIELD(APU_PCIL_IMR, APB_ERR, 0, 1)
REG32(APU_PCIL_IEN, 0xf008)
    FIELD(APU_PCIL_IEN, APB_ERR, 0, 1)
REG32(APU_PCIL_IDS, 0xf00c)
    FIELD(APU_PCIL_IDS, APB_ERR, 0, 1)
REG32(APU_PCIL_ERR, 0xf100)
    FIELD(APU_PCIL_ERR, CLUSTER_3, 19, 1)
    FIELD(APU_PCIL_ERR, CLUSTER_2, 18, 1)
    FIELD(APU_PCIL_ERR, CLUSTER_1, 17, 1)
    FIELD(APU_PCIL_ERR, CLUSTER_0, 16, 1)
    FIELD(APU_PCIL_ERR, CORE_15, 15, 1)
    FIELD(APU_PCIL_ERR, CORE_14, 14, 1)
    FIELD(APU_PCIL_ERR, CORE_13, 13, 1)
    FIELD(APU_PCIL_ERR, CORE_12, 12, 1)
    FIELD(APU_PCIL_ERR, CORE_11, 11, 1)
    FIELD(APU_PCIL_ERR, CORE_10, 10, 1)
    FIELD(APU_PCIL_ERR, CORE_9, 9, 1)
    FIELD(APU_PCIL_ERR, CORE_8, 8, 1)
    FIELD(APU_PCIL_ERR, CORE_7, 7, 1)
    FIELD(APU_PCIL_ERR, CORE_6, 6, 1)
    FIELD(APU_PCIL_ERR, CORE_5, 5, 1)
    FIELD(APU_PCIL_ERR, CORE_4, 4, 1)
    FIELD(APU_PCIL_ERR, CORE_3, 3, 1)
    FIELD(APU_PCIL_ERR, CORE_2, 2, 1)
    FIELD(APU_PCIL_ERR, CORE_1, 1, 1)
    FIELD(APU_PCIL_ERR, CORE_0, 0, 1)

#define APU_PCIL_R_MAX (R_APU_PCIL_ERR + 1)

typedef struct APU_PCIL {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_cluster_3_imr_power;
    qemu_irq irq_core_9_imr_wake;
    qemu_irq irq_core_6_imr_power;
    qemu_irq irq_cluster_dbg_imr_pwrup_req;
    qemu_irq irq_core_0_imr_wake;
    qemu_irq irq_core_15_imr_power;
    qemu_irq irq_cluster_2_imr_power;
    qemu_irq irq_core_14_imr_power;
    qemu_irq irq_core_0_imr_power;
    qemu_irq irq_core_2_imr_power;
    qemu_irq irq_core_dbg_imr_pwrup_req;
    qemu_irq irq_core_4_imr_power;
    qemu_irq irq_core_1_imr_power;
    qemu_irq irq_core_3_imr_power;
    qemu_irq irq_core_13_imr_power;
    qemu_irq irq_cluster_0_imr_power;
    qemu_irq irq_core_14_imr_wake;
    qemu_irq irq_core_3_imr_wake;
    qemu_irq irq_core_7_imr_wake;
    qemu_irq irq_core_12_imr_power;
    qemu_irq irq_core_5_imr_power;
    qemu_irq irq_cluster_2_imr_wake;
    qemu_irq irq_core_12_imr_wake;
    qemu_irq irq_core_11_imr_wake;
    qemu_irq irq_core_5_imr_wake;
    qemu_irq irq_core_2_imr_wake;
    qemu_irq irq_core_8_imr_wake;
    qemu_irq irq_core_1_imr_wake;
    qemu_irq irq_cluster_3_imr_wake;
    qemu_irq irq_cluster_0_imr_wake;
    qemu_irq irq_apu_pcil_imr;
    qemu_irq irq_cluster_1_imr_wake;
    qemu_irq irq_core_7_imr_power;
    qemu_irq irq_core_10_imr_wake;
    qemu_irq irq_core_9_imr_power;
    qemu_irq irq_core_6_imr_wake;
    qemu_irq irq_cluster_1_imr_power;
    qemu_irq irq_core_15_imr_wake;
    qemu_irq irq_core_4_imr_wake;
    qemu_irq irq_core_11_imr_power;
    qemu_irq irq_core_8_imr_power;
    qemu_irq irq_core_10_imr_power;
    qemu_irq irq_core_13_imr_wake;

    uint32_t regs[APU_PCIL_R_MAX];
    RegisterInfo regs_info[APU_PCIL_R_MAX];
} APU_PCIL;

static void cluster_3_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_3_ISR_POWER] &
                   ~s->regs[R_CLUSTER_3_IMR_POWER];
    qemu_set_irq(s->irq_cluster_3_imr_power, pending);
}

static void cluster_3_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_3_imr_power_update_irq(s);
}

static uint64_t cluster_3_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_3_IMR_POWER] &= ~val;
    cluster_3_imr_power_update_irq(s);
    return 0;
}

static uint64_t cluster_3_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_3_IMR_POWER] |= val;
    cluster_3_imr_power_update_irq(s);
    return 0;
}

static void core_9_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_9_ISR_WAKE] & ~s->regs[R_CORE_9_IMR_WAKE];
    qemu_set_irq(s->irq_core_9_imr_wake, pending);
}

static void core_9_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_9_imr_wake_update_irq(s);
}

static uint64_t core_9_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_9_IMR_WAKE] &= ~val;
    core_9_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_9_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_9_IMR_WAKE] |= val;
    core_9_imr_wake_update_irq(s);
    return 0;
}

static void core_6_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_6_ISR_POWER] & ~s->regs[R_CORE_6_IMR_POWER];
    qemu_set_irq(s->irq_core_6_imr_power, pending);
}

static void core_6_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_6_imr_power_update_irq(s);
}

static uint64_t core_6_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_6_IMR_POWER] &= ~val;
    core_6_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_6_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_6_IMR_POWER] |= val;
    core_6_imr_power_update_irq(s);
    return 0;
}

static void cluster_dbg_imr_pwrup_req_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_DBG_ISR_PWRUP_REQ] &
                   ~s->regs[R_CLUSTER_DBG_IMR_PWRUP_REQ];
    qemu_set_irq(s->irq_cluster_dbg_imr_pwrup_req, pending);
}

static void cluster_dbg_isr_pwrup_req_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_dbg_imr_pwrup_req_update_irq(s);
}

static uint64_t cluster_dbg_ien_pwrup_req_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DBG_IMR_PWRUP_REQ] &= ~val;
    cluster_dbg_imr_pwrup_req_update_irq(s);
    return 0;
}

static uint64_t cluster_dbg_ids_pwrup_req_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DBG_IMR_PWRUP_REQ] |= val;
    cluster_dbg_imr_pwrup_req_update_irq(s);
    return 0;
}

static void core_0_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_0_ISR_WAKE] & ~s->regs[R_CORE_0_IMR_WAKE];
    qemu_set_irq(s->irq_core_0_imr_wake, pending);
}

static void core_0_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_0_imr_wake_update_irq(s);
}

static uint64_t core_0_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_0_IMR_WAKE] &= ~val;
    core_0_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_0_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_0_IMR_WAKE] |= val;
    core_0_imr_wake_update_irq(s);
    return 0;
}

static void core_15_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_15_ISR_POWER] & ~s->regs[R_CORE_15_IMR_POWER];
    qemu_set_irq(s->irq_core_15_imr_power, pending);
}

static void core_15_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_15_imr_power_update_irq(s);
}

static uint64_t core_15_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_15_IMR_POWER] &= ~val;
    core_15_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_15_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_15_IMR_POWER] |= val;
    core_15_imr_power_update_irq(s);
    return 0;
}

static void cluster_2_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_2_ISR_POWER] &
                   ~s->regs[R_CLUSTER_2_IMR_POWER];
    qemu_set_irq(s->irq_cluster_2_imr_power, pending);
}

static void cluster_2_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_2_imr_power_update_irq(s);
}

static uint64_t cluster_2_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_2_IMR_POWER] &= ~val;
    cluster_2_imr_power_update_irq(s);
    return 0;
}

static uint64_t cluster_2_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_2_IMR_POWER] |= val;
    cluster_2_imr_power_update_irq(s);
    return 0;
}

static void core_14_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_14_ISR_POWER] & ~s->regs[R_CORE_14_IMR_POWER];
    qemu_set_irq(s->irq_core_14_imr_power, pending);
}

static void core_14_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_14_imr_power_update_irq(s);
}

static uint64_t core_14_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_14_IMR_POWER] &= ~val;
    core_14_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_14_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_14_IMR_POWER] |= val;
    core_14_imr_power_update_irq(s);
    return 0;
}

static void core_0_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_0_ISR_POWER] & ~s->regs[R_CORE_0_IMR_POWER];
    qemu_set_irq(s->irq_core_0_imr_power, pending);
}

static void core_0_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_0_imr_power_update_irq(s);
}

static uint64_t core_0_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_0_IMR_POWER] &= ~val;
    core_0_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_0_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_0_IMR_POWER] |= val;
    core_0_imr_power_update_irq(s);
    return 0;
}

static void core_2_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_2_ISR_POWER] & ~s->regs[R_CORE_2_IMR_POWER];
    qemu_set_irq(s->irq_core_2_imr_power, pending);
}

static void core_2_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_2_imr_power_update_irq(s);
}

static uint64_t core_2_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_2_IMR_POWER] &= ~val;
    core_2_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_2_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_2_IMR_POWER] |= val;
    core_2_imr_power_update_irq(s);
    return 0;
}

static void core_dbg_imr_pwrup_req_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_DBG_ISR_PWRUP_REQ] &
                   ~s->regs[R_CORE_DBG_IMR_PWRUP_REQ];
    qemu_set_irq(s->irq_core_dbg_imr_pwrup_req, pending);
}

static void core_dbg_isr_pwrup_req_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_dbg_imr_pwrup_req_update_irq(s);
}

static uint64_t core_dbg_ien_pwrup_req_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_DBG_IMR_PWRUP_REQ] &= ~val;
    core_dbg_imr_pwrup_req_update_irq(s);
    return 0;
}

static uint64_t core_dbg_ids_pwrup_req_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_DBG_IMR_PWRUP_REQ] |= val;
    core_dbg_imr_pwrup_req_update_irq(s);
    return 0;
}

static void core_4_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_4_ISR_POWER] & ~s->regs[R_CORE_4_IMR_POWER];
    qemu_set_irq(s->irq_core_4_imr_power, pending);
}

static void core_4_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_4_imr_power_update_irq(s);
}

static uint64_t core_4_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_4_IMR_POWER] &= ~val;
    core_4_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_4_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_4_IMR_POWER] |= val;
    core_4_imr_power_update_irq(s);
    return 0;
}

static void core_1_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_1_ISR_POWER] & ~s->regs[R_CORE_1_IMR_POWER];
    qemu_set_irq(s->irq_core_1_imr_power, pending);
}

static void core_1_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_1_imr_power_update_irq(s);
}

static uint64_t core_1_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_1_IMR_POWER] &= ~val;
    core_1_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_1_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_1_IMR_POWER] |= val;
    core_1_imr_power_update_irq(s);
    return 0;
}

static void core_3_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_3_ISR_POWER] & ~s->regs[R_CORE_3_IMR_POWER];
    qemu_set_irq(s->irq_core_3_imr_power, pending);
}

static void core_3_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_3_imr_power_update_irq(s);
}

static uint64_t core_3_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_3_IMR_POWER] &= ~val;
    core_3_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_3_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_3_IMR_POWER] |= val;
    core_3_imr_power_update_irq(s);
    return 0;
}

static void core_13_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_13_ISR_POWER] & ~s->regs[R_CORE_13_IMR_POWER];
    qemu_set_irq(s->irq_core_13_imr_power, pending);
}

static void core_13_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_13_imr_power_update_irq(s);
}

static uint64_t core_13_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_13_IMR_POWER] &= ~val;
    core_13_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_13_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_13_IMR_POWER] |= val;
    core_13_imr_power_update_irq(s);
    return 0;
}

static void cluster_0_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_0_ISR_POWER] &
                   ~s->regs[R_CLUSTER_0_IMR_POWER];
    qemu_set_irq(s->irq_cluster_0_imr_power, pending);
}

static void cluster_0_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_0_imr_power_update_irq(s);
}

static uint64_t cluster_0_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_0_IMR_POWER] &= ~val;
    cluster_0_imr_power_update_irq(s);
    return 0;
}

static uint64_t cluster_0_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_0_IMR_POWER] |= val;
    cluster_0_imr_power_update_irq(s);
    return 0;
}

static void core_14_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_14_ISR_WAKE] & ~s->regs[R_CORE_14_IMR_WAKE];
    qemu_set_irq(s->irq_core_14_imr_wake, pending);
}

static void core_14_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_14_imr_wake_update_irq(s);
}

static uint64_t core_14_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_14_IMR_WAKE] &= ~val;
    core_14_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_14_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_14_IMR_WAKE] |= val;
    core_14_imr_wake_update_irq(s);
    return 0;
}

static void core_3_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_3_ISR_WAKE] & ~s->regs[R_CORE_3_IMR_WAKE];
    qemu_set_irq(s->irq_core_3_imr_wake, pending);
}

static void core_3_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_3_imr_wake_update_irq(s);
}

static uint64_t core_3_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_3_IMR_WAKE] &= ~val;
    core_3_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_3_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_3_IMR_WAKE] |= val;
    core_3_imr_wake_update_irq(s);
    return 0;
}

static void core_7_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_7_ISR_WAKE] & ~s->regs[R_CORE_7_IMR_WAKE];
    qemu_set_irq(s->irq_core_7_imr_wake, pending);
}

static void core_7_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_7_imr_wake_update_irq(s);
}

static uint64_t core_7_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_7_IMR_WAKE] &= ~val;
    core_7_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_7_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_7_IMR_WAKE] |= val;
    core_7_imr_wake_update_irq(s);
    return 0;
}

static void core_12_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_12_ISR_POWER] & ~s->regs[R_CORE_12_IMR_POWER];
    qemu_set_irq(s->irq_core_12_imr_power, pending);
}

static void core_12_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_12_imr_power_update_irq(s);
}

static uint64_t core_12_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_12_IMR_POWER] &= ~val;
    core_12_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_12_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_12_IMR_POWER] |= val;
    core_12_imr_power_update_irq(s);
    return 0;
}

static void core_5_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_5_ISR_POWER] & ~s->regs[R_CORE_5_IMR_POWER];
    qemu_set_irq(s->irq_core_5_imr_power, pending);
}

static void core_5_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_5_imr_power_update_irq(s);
}

static uint64_t core_5_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_5_IMR_POWER] &= ~val;
    core_5_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_5_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_5_IMR_POWER] |= val;
    core_5_imr_power_update_irq(s);
    return 0;
}

static void cluster_2_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_2_ISR_WAKE] &
                   ~s->regs[R_CLUSTER_2_IMR_WAKE];
    qemu_set_irq(s->irq_cluster_2_imr_wake, pending);
}

static void cluster_2_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_2_imr_wake_update_irq(s);
}

static uint64_t cluster_2_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_2_IMR_WAKE] &= ~val;
    cluster_2_imr_wake_update_irq(s);
    return 0;
}

static uint64_t cluster_2_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_2_IMR_WAKE] |= val;
    cluster_2_imr_wake_update_irq(s);
    return 0;
}

static void core_12_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_12_ISR_WAKE] & ~s->regs[R_CORE_12_IMR_WAKE];
    qemu_set_irq(s->irq_core_12_imr_wake, pending);
}

static void core_12_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_12_imr_wake_update_irq(s);
}

static uint64_t core_12_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_12_IMR_WAKE] &= ~val;
    core_12_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_12_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_12_IMR_WAKE] |= val;
    core_12_imr_wake_update_irq(s);
    return 0;
}

static void core_11_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_11_ISR_WAKE] & ~s->regs[R_CORE_11_IMR_WAKE];
    qemu_set_irq(s->irq_core_11_imr_wake, pending);
}

static void core_11_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_11_imr_wake_update_irq(s);
}

static uint64_t core_11_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_11_IMR_WAKE] &= ~val;
    core_11_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_11_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_11_IMR_WAKE] |= val;
    core_11_imr_wake_update_irq(s);
    return 0;
}

static void core_5_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_5_ISR_WAKE] & ~s->regs[R_CORE_5_IMR_WAKE];
    qemu_set_irq(s->irq_core_5_imr_wake, pending);
}

static void core_5_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_5_imr_wake_update_irq(s);
}

static uint64_t core_5_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_5_IMR_WAKE] &= ~val;
    core_5_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_5_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_5_IMR_WAKE] |= val;
    core_5_imr_wake_update_irq(s);
    return 0;
}

static void core_2_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_2_ISR_WAKE] & ~s->regs[R_CORE_2_IMR_WAKE];
    qemu_set_irq(s->irq_core_2_imr_wake, pending);
}

static void core_2_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_2_imr_wake_update_irq(s);
}

static uint64_t core_2_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_2_IMR_WAKE] &= ~val;
    core_2_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_2_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_2_IMR_WAKE] |= val;
    core_2_imr_wake_update_irq(s);
    return 0;
}

static void core_8_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_8_ISR_WAKE] & ~s->regs[R_CORE_8_IMR_WAKE];
    qemu_set_irq(s->irq_core_8_imr_wake, pending);
}

static void core_8_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_8_imr_wake_update_irq(s);
}

static uint64_t core_8_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_8_IMR_WAKE] &= ~val;
    core_8_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_8_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_8_IMR_WAKE] |= val;
    core_8_imr_wake_update_irq(s);
    return 0;
}

static void core_1_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_1_ISR_WAKE] & ~s->regs[R_CORE_1_IMR_WAKE];
    qemu_set_irq(s->irq_core_1_imr_wake, pending);
}

static void core_1_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_1_imr_wake_update_irq(s);
}

static uint64_t core_1_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_1_IMR_WAKE] &= ~val;
    core_1_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_1_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_1_IMR_WAKE] |= val;
    core_1_imr_wake_update_irq(s);
    return 0;
}

static void cluster_3_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_3_ISR_WAKE] &
                   ~s->regs[R_CLUSTER_3_IMR_WAKE];
    qemu_set_irq(s->irq_cluster_3_imr_wake, pending);
}

static void cluster_3_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_3_imr_wake_update_irq(s);
}

static uint64_t cluster_3_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_3_IMR_WAKE] &= ~val;
    cluster_3_imr_wake_update_irq(s);
    return 0;
}

static uint64_t cluster_3_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_3_IMR_WAKE] |= val;
    cluster_3_imr_wake_update_irq(s);
    return 0;
}

static void cluster_0_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_0_ISR_WAKE] &
                   ~s->regs[R_CLUSTER_0_IMR_WAKE];
    qemu_set_irq(s->irq_cluster_0_imr_wake, pending);
}

static void cluster_0_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_0_imr_wake_update_irq(s);
}

static uint64_t cluster_0_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_0_IMR_WAKE] &= ~val;
    cluster_0_imr_wake_update_irq(s);
    return 0;
}

static uint64_t cluster_0_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_0_IMR_WAKE] |= val;
    cluster_0_imr_wake_update_irq(s);
    return 0;
}

static void apu_pcil_imr_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_APU_PCIL_ISR] & ~s->regs[R_APU_PCIL_IMR];
    qemu_set_irq(s->irq_apu_pcil_imr, pending);
}

static void apu_pcil_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    apu_pcil_imr_update_irq(s);
}

static uint64_t apu_pcil_ien_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APU_PCIL_IMR] &= ~val;
    apu_pcil_imr_update_irq(s);
    return 0;
}

static uint64_t apu_pcil_ids_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APU_PCIL_IMR] |= val;
    apu_pcil_imr_update_irq(s);
    return 0;
}

static void cluster_1_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_1_ISR_WAKE] &
                   ~s->regs[R_CLUSTER_1_IMR_WAKE];
    qemu_set_irq(s->irq_cluster_1_imr_wake, pending);
}

static void cluster_1_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_1_imr_wake_update_irq(s);
}

static uint64_t cluster_1_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_1_IMR_WAKE] &= ~val;
    cluster_1_imr_wake_update_irq(s);
    return 0;
}

static uint64_t cluster_1_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_1_IMR_WAKE] |= val;
    cluster_1_imr_wake_update_irq(s);
    return 0;
}

static void core_7_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_7_ISR_POWER] & ~s->regs[R_CORE_7_IMR_POWER];
    qemu_set_irq(s->irq_core_7_imr_power, pending);
}

static void core_7_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_7_imr_power_update_irq(s);
}

static uint64_t core_7_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_7_IMR_POWER] &= ~val;
    core_7_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_7_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_7_IMR_POWER] |= val;
    core_7_imr_power_update_irq(s);
    return 0;
}

static void core_10_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_10_ISR_WAKE] & ~s->regs[R_CORE_10_IMR_WAKE];
    qemu_set_irq(s->irq_core_10_imr_wake, pending);
}

static void core_10_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_10_imr_wake_update_irq(s);
}

static uint64_t core_10_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_10_IMR_WAKE] &= ~val;
    core_10_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_10_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_10_IMR_WAKE] |= val;
    core_10_imr_wake_update_irq(s);
    return 0;
}

static void core_9_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_9_ISR_POWER] & ~s->regs[R_CORE_9_IMR_POWER];
    qemu_set_irq(s->irq_core_9_imr_power, pending);
}

static void core_9_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_9_imr_power_update_irq(s);
}

static uint64_t core_9_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_9_IMR_POWER] &= ~val;
    core_9_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_9_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_9_IMR_POWER] |= val;
    core_9_imr_power_update_irq(s);
    return 0;
}

static void core_6_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_6_ISR_WAKE] & ~s->regs[R_CORE_6_IMR_WAKE];
    qemu_set_irq(s->irq_core_6_imr_wake, pending);
}

static void core_6_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_6_imr_wake_update_irq(s);
}

static uint64_t core_6_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_6_IMR_WAKE] &= ~val;
    core_6_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_6_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_6_IMR_WAKE] |= val;
    core_6_imr_wake_update_irq(s);
    return 0;
}

static void cluster_1_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CLUSTER_1_ISR_POWER] &
                   ~s->regs[R_CLUSTER_1_IMR_POWER];
    qemu_set_irq(s->irq_cluster_1_imr_power, pending);
}

static void cluster_1_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    cluster_1_imr_power_update_irq(s);
}

static uint64_t cluster_1_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_1_IMR_POWER] &= ~val;
    cluster_1_imr_power_update_irq(s);
    return 0;
}

static uint64_t cluster_1_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_1_IMR_POWER] |= val;
    cluster_1_imr_power_update_irq(s);
    return 0;
}

static void core_15_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_15_ISR_WAKE] & ~s->regs[R_CORE_15_IMR_WAKE];
    qemu_set_irq(s->irq_core_15_imr_wake, pending);
}

static void core_15_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_15_imr_wake_update_irq(s);
}

static uint64_t core_15_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_15_IMR_WAKE] &= ~val;
    core_15_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_15_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_15_IMR_WAKE] |= val;
    core_15_imr_wake_update_irq(s);
    return 0;
}

static void core_4_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_4_ISR_WAKE] & ~s->regs[R_CORE_4_IMR_WAKE];
    qemu_set_irq(s->irq_core_4_imr_wake, pending);
}

static void core_4_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_4_imr_wake_update_irq(s);
}

static uint64_t core_4_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_4_IMR_WAKE] &= ~val;
    core_4_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_4_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_4_IMR_WAKE] |= val;
    core_4_imr_wake_update_irq(s);
    return 0;
}

static void core_11_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_11_ISR_POWER] & ~s->regs[R_CORE_11_IMR_POWER];
    qemu_set_irq(s->irq_core_11_imr_power, pending);
}

static void core_11_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_11_imr_power_update_irq(s);
}

static uint64_t core_11_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_11_IMR_POWER] &= ~val;
    core_11_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_11_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_11_IMR_POWER] |= val;
    core_11_imr_power_update_irq(s);
    return 0;
}

static void core_8_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_8_ISR_POWER] & ~s->regs[R_CORE_8_IMR_POWER];
    qemu_set_irq(s->irq_core_8_imr_power, pending);
}

static void core_8_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_8_imr_power_update_irq(s);
}

static uint64_t core_8_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_8_IMR_POWER] &= ~val;
    core_8_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_8_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_8_IMR_POWER] |= val;
    core_8_imr_power_update_irq(s);
    return 0;
}

static void core_10_imr_power_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_10_ISR_POWER] & ~s->regs[R_CORE_10_IMR_POWER];
    qemu_set_irq(s->irq_core_10_imr_power, pending);
}

static void core_10_isr_power_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_10_imr_power_update_irq(s);
}

static uint64_t core_10_ien_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_10_IMR_POWER] &= ~val;
    core_10_imr_power_update_irq(s);
    return 0;
}

static uint64_t core_10_ids_power_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_10_IMR_POWER] |= val;
    core_10_imr_power_update_irq(s);
    return 0;
}

static void core_13_imr_wake_update_irq(APU_PCIL *s)
{
    bool pending = s->regs[R_CORE_13_ISR_WAKE] & ~s->regs[R_CORE_13_IMR_WAKE];
    qemu_set_irq(s->irq_core_13_imr_wake, pending);
}

static void core_13_isr_wake_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    core_13_imr_wake_update_irq(s);
}

static uint64_t core_13_ien_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_13_IMR_WAKE] &= ~val;
    core_13_imr_wake_update_irq(s);
    return 0;
}

static uint64_t core_13_ids_wake_prew(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CORE_13_IMR_WAKE] |= val;
    core_13_imr_wake_update_irq(s);
    return 0;
}

static void core_x_preq_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t blk_offset = reg->access->addr / 4 - 1;

    if (val64) {
        /* Validation not implemented
         * set it true untill we implement all requests
         */
        s->regs[blk_offset + R_CORE_0_PACTIVE] |=
                R_CORE_0_PACTIVE_PACCEPT_MASK;
    }
}

static void cluster_x_preq_postw(RegisterInfo *reg, uint64_t val64)
{
    APU_PCIL *s = XILINX_APU_PCIL(reg->opaque);
    uint32_t blk_offset = reg->access->addr / 4 - 1;

    if (val64) {
        /* Validation not implemented
         * set it true untill we implement all requests
         */
        s->regs[blk_offset + R_CORE_0_PACTIVE] |=
                R_CORE_0_PACTIVE_PACCEPT_MASK;
    }
}

static const RegisterAccessInfo apu_pcil_regs_info[] = {
    {   .name = "CORE_0_PWRDWN",  .addr = A_CORE_0_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_0_PREQ",  .addr = A_CORE_0_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_0_PSTATE",  .addr = A_CORE_0_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_0_PACTIVE",  .addr = A_CORE_0_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_0_ISR_POWER",  .addr = A_CORE_0_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_0_isr_power_postw,
    },{ .name = "CORE_0_IMR_POWER",  .addr = A_CORE_0_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_0_IEN_POWER",  .addr = A_CORE_0_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_0_ien_power_prew,
    },{ .name = "CORE_0_IDS_POWER",  .addr = A_CORE_0_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_0_ids_power_prew,
    },{ .name = "CORE_0_ISR_WAKE",  .addr = A_CORE_0_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_0_isr_wake_postw,
    },{ .name = "CORE_0_IMR_WAKE",  .addr = A_CORE_0_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_0_IEN_WAKE",  .addr = A_CORE_0_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_0_ien_wake_prew,
    },{ .name = "CORE_0_IDS_WAKE",  .addr = A_CORE_0_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_0_ids_wake_prew,
    },{ .name = "CORE_1_PWRDWN",  .addr = A_CORE_1_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_1_PREQ",  .addr = A_CORE_1_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_1_PSTATE",  .addr = A_CORE_1_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_1_PACTIVE",  .addr = A_CORE_1_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_1_ISR_POWER",  .addr = A_CORE_1_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_1_isr_power_postw,
    },{ .name = "CORE_1_IMR_POWER",  .addr = A_CORE_1_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_1_IEN_POWER",  .addr = A_CORE_1_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_1_ien_power_prew,
    },{ .name = "CORE_1_IDS_POWER",  .addr = A_CORE_1_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_1_ids_power_prew,
    },{ .name = "CORE_1_ISR_WAKE",  .addr = A_CORE_1_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_1_isr_wake_postw,
    },{ .name = "CORE_1_IMR_WAKE",  .addr = A_CORE_1_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_1_IEN_WAKE",  .addr = A_CORE_1_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_1_ien_wake_prew,
    },{ .name = "CORE_1_IDS_WAKE",  .addr = A_CORE_1_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_1_ids_wake_prew,
    },{ .name = "CORE_2_PWRDWN",  .addr = A_CORE_2_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_2_PREQ",  .addr = A_CORE_2_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_2_PSTATE",  .addr = A_CORE_2_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_2_PACTIVE",  .addr = A_CORE_2_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_2_ISR_POWER",  .addr = A_CORE_2_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_2_isr_power_postw,
    },{ .name = "CORE_2_IMR_POWER",  .addr = A_CORE_2_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_2_IEN_POWER",  .addr = A_CORE_2_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_2_ien_power_prew,
    },{ .name = "CORE_2_IDS_POWER",  .addr = A_CORE_2_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_2_ids_power_prew,
    },{ .name = "CORE_2_ISR_WAKE",  .addr = A_CORE_2_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_2_isr_wake_postw,
    },{ .name = "CORE_2_IMR_WAKE",  .addr = A_CORE_2_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_2_IEN_WAKE",  .addr = A_CORE_2_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_2_ien_wake_prew,
    },{ .name = "CORE_2_IDS_WAKE",  .addr = A_CORE_2_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_2_ids_wake_prew,
    },{ .name = "CORE_3_PWRDWN",  .addr = A_CORE_3_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_3_PREQ",  .addr = A_CORE_3_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_3_PSTATE",  .addr = A_CORE_3_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_3_PACTIVE",  .addr = A_CORE_3_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_3_ISR_POWER",  .addr = A_CORE_3_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_3_isr_power_postw,
    },{ .name = "CORE_3_IMR_POWER",  .addr = A_CORE_3_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_3_IEN_POWER",  .addr = A_CORE_3_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_3_ien_power_prew,
    },{ .name = "CORE_3_IDS_POWER",  .addr = A_CORE_3_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_3_ids_power_prew,
    },{ .name = "CORE_3_ISR_WAKE",  .addr = A_CORE_3_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_3_isr_wake_postw,
    },{ .name = "CORE_3_IMR_WAKE",  .addr = A_CORE_3_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_3_IEN_WAKE",  .addr = A_CORE_3_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_3_ien_wake_prew,
    },{ .name = "CORE_3_IDS_WAKE",  .addr = A_CORE_3_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_3_ids_wake_prew,
    },{ .name = "CORE_4_PWRDWN",  .addr = A_CORE_4_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_4_PREQ",  .addr = A_CORE_4_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_4_PSTATE",  .addr = A_CORE_4_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_4_PACTIVE",  .addr = A_CORE_4_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_4_ISR_POWER",  .addr = A_CORE_4_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_4_isr_power_postw,
    },{ .name = "CORE_4_IMR_POWER",  .addr = A_CORE_4_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_4_IEN_POWER",  .addr = A_CORE_4_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_4_ien_power_prew,
    },{ .name = "CORE_4_IDS_POWER",  .addr = A_CORE_4_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_4_ids_power_prew,
    },{ .name = "CORE_4_ISR_WAKE",  .addr = A_CORE_4_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_4_isr_wake_postw,
    },{ .name = "CORE_4_IMR_WAKE",  .addr = A_CORE_4_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_4_IEN_WAKE",  .addr = A_CORE_4_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_4_ien_wake_prew,
    },{ .name = "CORE_4_IDS_WAKE",  .addr = A_CORE_4_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_4_ids_wake_prew,
    },{ .name = "CORE_5_PWRDWN",  .addr = A_CORE_5_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_5_PREQ",  .addr = A_CORE_5_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_5_PSTATE",  .addr = A_CORE_5_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_5_PACTIVE",  .addr = A_CORE_5_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_5_ISR_POWER",  .addr = A_CORE_5_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_5_isr_power_postw,
    },{ .name = "CORE_5_IMR_POWER",  .addr = A_CORE_5_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_5_IEN_POWER",  .addr = A_CORE_5_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_5_ien_power_prew,
    },{ .name = "CORE_5_IDS_POWER",  .addr = A_CORE_5_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_5_ids_power_prew,
    },{ .name = "CORE_5_ISR_WAKE",  .addr = A_CORE_5_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_5_isr_wake_postw,
    },{ .name = "CORE_5_IMR_WAKE",  .addr = A_CORE_5_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_5_IEN_WAKE",  .addr = A_CORE_5_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_5_ien_wake_prew,
    },{ .name = "CORE_5_IDS_WAKE",  .addr = A_CORE_5_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_5_ids_wake_prew,
    },{ .name = "CORE_6_PWRDWN",  .addr = A_CORE_6_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_6_PREQ",  .addr = A_CORE_6_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_6_PSTATE",  .addr = A_CORE_6_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_6_PACTIVE",  .addr = A_CORE_6_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_6_ISR_POWER",  .addr = A_CORE_6_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_6_isr_power_postw,
    },{ .name = "CORE_6_IMR_POWER",  .addr = A_CORE_6_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_6_IEN_POWER",  .addr = A_CORE_6_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_6_ien_power_prew,
    },{ .name = "CORE_6_IDS_POWER",  .addr = A_CORE_6_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_6_ids_power_prew,
    },{ .name = "CORE_6_ISR_WAKE",  .addr = A_CORE_6_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_6_isr_wake_postw,
    },{ .name = "CORE_6_IMR_WAKE",  .addr = A_CORE_6_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_6_IEN_WAKE",  .addr = A_CORE_6_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_6_ien_wake_prew,
    },{ .name = "CORE_6_IDS_WAKE",  .addr = A_CORE_6_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_6_ids_wake_prew,
    },{ .name = "CORE_7_PWRDWN",  .addr = A_CORE_7_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_7_PREQ",  .addr = A_CORE_7_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_7_PSTATE",  .addr = A_CORE_7_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_7_PACTIVE",  .addr = A_CORE_7_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_7_ISR_POWER",  .addr = A_CORE_7_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_7_isr_power_postw,
    },{ .name = "CORE_7_IMR_POWER",  .addr = A_CORE_7_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_7_IEN_POWER",  .addr = A_CORE_7_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_7_ien_power_prew,
    },{ .name = "CORE_7_IDS_POWER",  .addr = A_CORE_7_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_7_ids_power_prew,
    },{ .name = "CORE_7_ISR_WAKE",  .addr = A_CORE_7_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_7_isr_wake_postw,
    },{ .name = "CORE_7_IMR_WAKE",  .addr = A_CORE_7_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_7_IEN_WAKE",  .addr = A_CORE_7_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_7_ien_wake_prew,
    },{ .name = "CORE_7_IDS_WAKE",  .addr = A_CORE_7_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_7_ids_wake_prew,
    },{ .name = "CORE_8_PWRDWN",  .addr = A_CORE_8_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_8_PREQ",  .addr = A_CORE_8_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_8_PSTATE",  .addr = A_CORE_8_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_8_PACTIVE",  .addr = A_CORE_8_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_8_ISR_POWER",  .addr = A_CORE_8_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_8_isr_power_postw,
    },{ .name = "CORE_8_IMR_POWER",  .addr = A_CORE_8_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_8_IEN_POWER",  .addr = A_CORE_8_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_8_ien_power_prew,
    },{ .name = "CORE_8_IDS_POWER",  .addr = A_CORE_8_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_8_ids_power_prew,
    },{ .name = "CORE_8_ISR_WAKE",  .addr = A_CORE_8_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_8_isr_wake_postw,
    },{ .name = "CORE_8_IMR_WAKE",  .addr = A_CORE_8_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_8_IEN_WAKE",  .addr = A_CORE_8_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_8_ien_wake_prew,
    },{ .name = "CORE_8_IDS_WAKE",  .addr = A_CORE_8_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_8_ids_wake_prew,
    },{ .name = "CORE_9_PWRDWN",  .addr = A_CORE_9_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_9_PREQ",  .addr = A_CORE_9_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_9_PSTATE",  .addr = A_CORE_9_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_9_PACTIVE",  .addr = A_CORE_9_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_9_ISR_POWER",  .addr = A_CORE_9_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_9_isr_power_postw,
    },{ .name = "CORE_9_IMR_POWER",  .addr = A_CORE_9_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_9_IEN_POWER",  .addr = A_CORE_9_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_9_ien_power_prew,
    },{ .name = "CORE_9_IDS_POWER",  .addr = A_CORE_9_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_9_ids_power_prew,
    },{ .name = "CORE_9_ISR_WAKE",  .addr = A_CORE_9_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_9_isr_wake_postw,
    },{ .name = "CORE_9_IMR_WAKE",  .addr = A_CORE_9_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_9_IEN_WAKE",  .addr = A_CORE_9_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_9_ien_wake_prew,
    },{ .name = "CORE_9_IDS_WAKE",  .addr = A_CORE_9_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_9_ids_wake_prew,
    },{ .name = "CORE_10_PWRDWN",  .addr = A_CORE_10_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_10_PREQ",  .addr = A_CORE_10_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_10_PSTATE",  .addr = A_CORE_10_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_10_PACTIVE",  .addr = A_CORE_10_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_10_ISR_POWER",  .addr = A_CORE_10_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_10_isr_power_postw,
    },{ .name = "CORE_10_IMR_POWER",  .addr = A_CORE_10_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_10_IEN_POWER",  .addr = A_CORE_10_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_10_ien_power_prew,
    },{ .name = "CORE_10_IDS_POWER",  .addr = A_CORE_10_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_10_ids_power_prew,
    },{ .name = "CORE_10_ISR_WAKE",  .addr = A_CORE_10_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_10_isr_wake_postw,
    },{ .name = "CORE_10_IMR_WAKE",  .addr = A_CORE_10_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_10_IEN_WAKE",  .addr = A_CORE_10_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_10_ien_wake_prew,
    },{ .name = "CORE_10_IDS_WAKE",  .addr = A_CORE_10_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_10_ids_wake_prew,
    },{ .name = "CORE_11_PWRDWN",  .addr = A_CORE_11_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_11_PREQ",  .addr = A_CORE_11_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_11_PSTATE",  .addr = A_CORE_11_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_11_PACTIVE",  .addr = A_CORE_11_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_11_ISR_POWER",  .addr = A_CORE_11_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_11_isr_power_postw,
    },{ .name = "CORE_11_IMR_POWER",  .addr = A_CORE_11_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_11_IEN_POWER",  .addr = A_CORE_11_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_11_ien_power_prew,
    },{ .name = "CORE_11_IDS_POWER",  .addr = A_CORE_11_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_11_ids_power_prew,
    },{ .name = "CORE_11_ISR_WAKE",  .addr = A_CORE_11_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_11_isr_wake_postw,
    },{ .name = "CORE_11_IMR_WAKE",  .addr = A_CORE_11_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_11_IEN_WAKE",  .addr = A_CORE_11_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_11_ien_wake_prew,
    },{ .name = "CORE_11_IDS_WAKE",  .addr = A_CORE_11_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_11_ids_wake_prew,
    },{ .name = "CORE_12_PWRDWN",  .addr = A_CORE_12_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_12_PREQ",  .addr = A_CORE_12_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_12_PSTATE",  .addr = A_CORE_12_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_12_PACTIVE",  .addr = A_CORE_12_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_12_ISR_POWER",  .addr = A_CORE_12_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_12_isr_power_postw,
    },{ .name = "CORE_12_IMR_POWER",  .addr = A_CORE_12_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_12_IEN_POWER",  .addr = A_CORE_12_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_12_ien_power_prew,
    },{ .name = "CORE_12_IDS_POWER",  .addr = A_CORE_12_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_12_ids_power_prew,
    },{ .name = "CORE_12_ISR_WAKE",  .addr = A_CORE_12_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_12_isr_wake_postw,
    },{ .name = "CORE_12_IMR_WAKE",  .addr = A_CORE_12_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_12_IEN_WAKE",  .addr = A_CORE_12_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_12_ien_wake_prew,
    },{ .name = "CORE_12_IDS_WAKE",  .addr = A_CORE_12_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_12_ids_wake_prew,
    },{ .name = "CORE_13_PWRDWN",  .addr = A_CORE_13_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_13_PREQ",  .addr = A_CORE_13_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_13_PSTATE",  .addr = A_CORE_13_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_13_PACTIVE",  .addr = A_CORE_13_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_13_ISR_POWER",  .addr = A_CORE_13_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_13_isr_power_postw,
    },{ .name = "CORE_13_IMR_POWER",  .addr = A_CORE_13_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_13_IEN_POWER",  .addr = A_CORE_13_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_13_ien_power_prew,
    },{ .name = "CORE_13_IDS_POWER",  .addr = A_CORE_13_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_13_ids_power_prew,
    },{ .name = "CORE_13_ISR_WAKE",  .addr = A_CORE_13_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_13_isr_wake_postw,
    },{ .name = "CORE_13_IMR_WAKE",  .addr = A_CORE_13_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_13_IEN_WAKE",  .addr = A_CORE_13_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_13_ien_wake_prew,
    },{ .name = "CORE_13_IDS_WAKE",  .addr = A_CORE_13_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_13_ids_wake_prew,
    },{ .name = "CORE_14_PWRDWN",  .addr = A_CORE_14_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_14_PREQ",  .addr = A_CORE_14_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_14_PSTATE",  .addr = A_CORE_14_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_14_PACTIVE",  .addr = A_CORE_14_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_14_ISR_POWER",  .addr = A_CORE_14_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_14_isr_power_postw,
    },{ .name = "CORE_14_IMR_POWER",  .addr = A_CORE_14_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_14_IEN_POWER",  .addr = A_CORE_14_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_14_ien_power_prew,
    },{ .name = "CORE_14_IDS_POWER",  .addr = A_CORE_14_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_14_ids_power_prew,
    },{ .name = "CORE_14_ISR_WAKE",  .addr = A_CORE_14_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_14_isr_wake_postw,
    },{ .name = "CORE_14_IMR_WAKE",  .addr = A_CORE_14_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_14_IEN_WAKE",  .addr = A_CORE_14_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_14_ien_wake_prew,
    },{ .name = "CORE_14_IDS_WAKE",  .addr = A_CORE_14_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_14_ids_wake_prew,
    },{ .name = "CORE_15_PWRDWN",  .addr = A_CORE_15_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "CORE_15_PREQ",  .addr = A_CORE_15_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = core_x_preq_postw,
    },{ .name = "CORE_15_PSTATE",  .addr = A_CORE_15_PSTATE,
        .rsvd = 0xffffffc0,
    },{ .name = "CORE_15_PACTIVE",  .addr = A_CORE_15_PACTIVE,
        .rsvd = 0xfcfc0000,
        .ro = 0x303ffff,
    },{ .name = "CORE_15_ISR_POWER",  .addr = A_CORE_15_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_15_isr_power_postw,
    },{ .name = "CORE_15_IMR_POWER",  .addr = A_CORE_15_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_15_IEN_POWER",  .addr = A_CORE_15_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_15_ien_power_prew,
    },{ .name = "CORE_15_IDS_POWER",  .addr = A_CORE_15_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = core_15_ids_power_prew,
    },{ .name = "CORE_15_ISR_WAKE",  .addr = A_CORE_15_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = core_15_isr_wake_postw,
    },{ .name = "CORE_15_IMR_WAKE",  .addr = A_CORE_15_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_15_IEN_WAKE",  .addr = A_CORE_15_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_15_ien_wake_prew,
    },{ .name = "CORE_15_IDS_WAKE",  .addr = A_CORE_15_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = core_15_ids_wake_prew,
    },{ .name = "CORE_DBG_ISR_PWRUP_REQ",  .addr = A_CORE_DBG_ISR_PWRUP_REQ,
        .rsvd = 0xffff0000,
        .w1c = 0xffff,
        .post_write = core_dbg_isr_pwrup_req_postw,
    },{ .name = "CORE_DBG_IMR_PWRUP_REQ",  .addr = A_CORE_DBG_IMR_PWRUP_REQ,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "CORE_DBG_IEN_PWRUP_REQ",  .addr = A_CORE_DBG_IEN_PWRUP_REQ,
        .rsvd = 0xffff0000,
        .pre_write = core_dbg_ien_pwrup_req_prew,
    },{ .name = "CORE_DBG_IDS_PWRUP_REQ",  .addr = A_CORE_DBG_IDS_PWRUP_REQ,
        .rsvd = 0xffff0000,
        .pre_write = core_dbg_ids_pwrup_req_prew,
    },{ .name = "CLUSTER_DBG_ISR_PWRUP_REQ",
        .addr = A_CLUSTER_DBG_ISR_PWRUP_REQ,
        .rsvd = 0xfffffff0,
        .w1c = 0xf,
        .post_write = cluster_dbg_isr_pwrup_req_postw,
    },{ .name = "CLUSTER_DBG_IMR_PWRUP_REQ",
        .addr = A_CLUSTER_DBG_IMR_PWRUP_REQ,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "CLUSTER_DBG_IEN_PWRUP_REQ",
        .addr = A_CLUSTER_DBG_IEN_PWRUP_REQ,
        .rsvd = 0xfffffff0,
        .pre_write = cluster_dbg_ien_pwrup_req_prew,
    },{ .name = "CLUSTER_DBG_IDS_PWRUP_REQ",
        .addr = A_CLUSTER_DBG_IDS_PWRUP_REQ,
        .rsvd = 0xfffffff0,
        .pre_write = cluster_dbg_ids_pwrup_req_prew,
    },{ .name = "CLUSTER_0_PREQ",  .addr = A_CLUSTER_0_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = cluster_x_preq_postw,
    },{ .name = "CLUSTER_0_PSTATE",  .addr = A_CLUSTER_0_PSTATE,
        .rsvd = 0xffffff80,
    },{ .name = "CLUSTER_0_PACTIVE",  .addr = A_CLUSTER_0_PACTIVE,
        .rsvd = 0xfcf00000,
        .ro = 0x30fffff,
    },{ .name = "CLUSTER_0_ISR_POWER",  .addr = A_CLUSTER_0_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_0_isr_power_postw,
    },{ .name = "CLUSTER_0_IMR_POWER",  .addr = A_CLUSTER_0_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_0_IEN_POWER",  .addr = A_CLUSTER_0_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_0_ien_power_prew,
    },{ .name = "CLUSTER_0_IDS_POWER",  .addr = A_CLUSTER_0_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_0_ids_power_prew,
    },{ .name = "CLUSTER_0_ISR_WAKE",  .addr = A_CLUSTER_0_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_0_isr_wake_postw,
    },{ .name = "CLUSTER_0_IMR_WAKE",  .addr = A_CLUSTER_0_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_0_IEN_WAKE",  .addr = A_CLUSTER_0_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_0_ien_wake_prew,
    },{ .name = "CLUSTER_0_IDS_WAKE",  .addr = A_CLUSTER_0_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_0_ids_wake_prew,
    },{ .name = "CLUSTER_1_PREQ",  .addr = A_CLUSTER_1_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = cluster_x_preq_postw,
    },{ .name = "CLUSTER_1_PSTATE",  .addr = A_CLUSTER_1_PSTATE,
        .rsvd = 0xffffff80,
    },{ .name = "CLUSTER_1_PACTIVE",  .addr = A_CLUSTER_1_PACTIVE,
        .rsvd = 0xfcf00000,
        .ro = 0x30fffff,
    },{ .name = "CLUSTER_1_ISR_POWER",  .addr = A_CLUSTER_1_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_1_isr_power_postw,
    },{ .name = "CLUSTER_1_IMR_POWER",  .addr = A_CLUSTER_1_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_1_IEN_POWER",  .addr = A_CLUSTER_1_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_1_ien_power_prew,
    },{ .name = "CLUSTER_1_IDS_POWER",  .addr = A_CLUSTER_1_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_1_ids_power_prew,
    },{ .name = "CLUSTER_1_ISR_WAKE",  .addr = A_CLUSTER_1_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_1_isr_wake_postw,
    },{ .name = "CLUSTER_1_IMR_WAKE",  .addr = A_CLUSTER_1_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_1_IEN_WAKE",  .addr = A_CLUSTER_1_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_1_ien_wake_prew,
    },{ .name = "CLUSTER_1_IDS_WAKE",  .addr = A_CLUSTER_1_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_1_ids_wake_prew,
    },{ .name = "CLUSTER_2_PREQ",  .addr = A_CLUSTER_2_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = cluster_x_preq_postw,
    },{ .name = "CLUSTER_2_PSTATE",  .addr = A_CLUSTER_2_PSTATE,
        .rsvd = 0xffffff80,
    },{ .name = "CLUSTER_2_PACTIVE",  .addr = A_CLUSTER_2_PACTIVE,
        .rsvd = 0xfcf00000,
        .ro = 0x30fffff,
    },{ .name = "CLUSTER_2_ISR_POWER",  .addr = A_CLUSTER_2_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_2_isr_power_postw,
    },{ .name = "CLUSTER_2_IMR_POWER",  .addr = A_CLUSTER_2_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_2_IEN_POWER",  .addr = A_CLUSTER_2_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_2_ien_power_prew,
    },{ .name = "CLUSTER_2_IDS_POWER",  .addr = A_CLUSTER_2_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_2_ids_power_prew,
    },{ .name = "CLUSTER_2_ISR_WAKE",  .addr = A_CLUSTER_2_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_2_isr_wake_postw,
    },{ .name = "CLUSTER_2_IMR_WAKE",  .addr = A_CLUSTER_2_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_2_IEN_WAKE",  .addr = A_CLUSTER_2_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_2_ien_wake_prew,
    },{ .name = "CLUSTER_2_IDS_WAKE",  .addr = A_CLUSTER_2_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_2_ids_wake_prew,
    },{ .name = "CLUSTER_3_PREQ",  .addr = A_CLUSTER_3_PREQ,
        .rsvd = 0xfffffffe,
        .post_write = cluster_x_preq_postw,
    },{ .name = "CLUSTER_3_PSTATE",  .addr = A_CLUSTER_3_PSTATE,
        .rsvd = 0xffffff80,
    },{ .name = "CLUSTER_3_PACTIVE",  .addr = A_CLUSTER_3_PACTIVE,
        .rsvd = 0xfcf00000,
        .ro = 0x30fffff,
    },{ .name = "CLUSTER_3_ISR_POWER",  .addr = A_CLUSTER_3_ISR_POWER,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_3_isr_power_postw,
    },{ .name = "CLUSTER_3_IMR_POWER",  .addr = A_CLUSTER_3_IMR_POWER,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_3_IEN_POWER",  .addr = A_CLUSTER_3_IEN_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_3_ien_power_prew,
    },{ .name = "CLUSTER_3_IDS_POWER",  .addr = A_CLUSTER_3_IDS_POWER,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_3_ids_power_prew,
    },{ .name = "CLUSTER_3_ISR_WAKE",  .addr = A_CLUSTER_3_ISR_WAKE,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = cluster_3_isr_wake_postw,
    },{ .name = "CLUSTER_3_IMR_WAKE",  .addr = A_CLUSTER_3_IMR_WAKE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CLUSTER_3_IEN_WAKE",  .addr = A_CLUSTER_3_IEN_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_3_ien_wake_prew,
    },{ .name = "CLUSTER_3_IDS_WAKE",  .addr = A_CLUSTER_3_IDS_WAKE,
        .rsvd = 0xfffffffe,
        .pre_write = cluster_3_ids_wake_prew,
    },{ .name = "APU_PCIL_ISR",  .addr = A_APU_PCIL_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = apu_pcil_isr_postw,
    },{ .name = "APU_PCIL_IMR",  .addr = A_APU_PCIL_IMR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "APU_PCIL_IEN",  .addr = A_APU_PCIL_IEN,
        .rsvd = 0xfffffffe,
        .pre_write = apu_pcil_ien_prew,
    },{ .name = "APU_PCIL_IDS",  .addr = A_APU_PCIL_IDS,
        .rsvd = 0xfffffffe,
        .pre_write = apu_pcil_ids_prew,
    },{ .name = "APU_PCIL_ERR",  .addr = A_APU_PCIL_ERR,
        .rsvd = 0xfff00000,
        .w1c = 0xfffff,
    }
};

static void apu_pcil_reset_enter(Object *obj, ResetType type)
{
    APU_PCIL *s = XILINX_APU_PCIL(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void apu_pcil_reset_hold(Object *obj)
{
    APU_PCIL *s = XILINX_APU_PCIL(obj);

    cluster_3_imr_power_update_irq(s);
    core_9_imr_wake_update_irq(s);
    core_6_imr_power_update_irq(s);
    cluster_dbg_imr_pwrup_req_update_irq(s);
    core_0_imr_wake_update_irq(s);
    core_15_imr_power_update_irq(s);
    cluster_2_imr_power_update_irq(s);
    core_14_imr_power_update_irq(s);
    core_0_imr_power_update_irq(s);
    core_2_imr_power_update_irq(s);
    core_dbg_imr_pwrup_req_update_irq(s);
    core_4_imr_power_update_irq(s);
    core_1_imr_power_update_irq(s);
    core_3_imr_power_update_irq(s);
    core_13_imr_power_update_irq(s);
    cluster_0_imr_power_update_irq(s);
    core_14_imr_wake_update_irq(s);
    core_3_imr_wake_update_irq(s);
    core_7_imr_wake_update_irq(s);
    core_12_imr_power_update_irq(s);
    core_5_imr_power_update_irq(s);
    cluster_2_imr_wake_update_irq(s);
    core_12_imr_wake_update_irq(s);
    core_11_imr_wake_update_irq(s);
    core_5_imr_wake_update_irq(s);
    core_2_imr_wake_update_irq(s);
    core_8_imr_wake_update_irq(s);
    core_1_imr_wake_update_irq(s);
    cluster_3_imr_wake_update_irq(s);
    cluster_0_imr_wake_update_irq(s);
    apu_pcil_imr_update_irq(s);
    cluster_1_imr_wake_update_irq(s);
    core_7_imr_power_update_irq(s);
    core_10_imr_wake_update_irq(s);
    core_9_imr_power_update_irq(s);
    core_6_imr_wake_update_irq(s);
    cluster_1_imr_power_update_irq(s);
    core_15_imr_wake_update_irq(s);
    core_4_imr_wake_update_irq(s);
    core_11_imr_power_update_irq(s);
    core_8_imr_power_update_irq(s);
    core_10_imr_power_update_irq(s);
    core_13_imr_wake_update_irq(s);
}

static const MemoryRegionOps apu_pcil_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void apu_pcil_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void apu_pcil_init(Object *obj)
{
    APU_PCIL *s = XILINX_APU_PCIL(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_APU_PCIL,
                       APU_PCIL_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), apu_pcil_regs_info,
                              ARRAY_SIZE(apu_pcil_regs_info),
                              s->regs_info, s->regs,
                              &apu_pcil_ops,
                              XILINX_APU_PCIL_ERR_DEBUG,
                              APU_PCIL_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_cluster_3_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_9_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_6_imr_power);
    sysbus_init_irq(sbd, &s->irq_cluster_dbg_imr_pwrup_req);
    sysbus_init_irq(sbd, &s->irq_core_0_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_15_imr_power);
    sysbus_init_irq(sbd, &s->irq_cluster_2_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_14_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_0_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_2_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_dbg_imr_pwrup_req);
    sysbus_init_irq(sbd, &s->irq_core_4_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_1_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_3_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_13_imr_power);
    sysbus_init_irq(sbd, &s->irq_cluster_0_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_14_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_3_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_7_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_12_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_5_imr_power);
    sysbus_init_irq(sbd, &s->irq_cluster_2_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_12_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_11_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_5_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_2_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_8_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_1_imr_wake);
    sysbus_init_irq(sbd, &s->irq_cluster_3_imr_wake);
    sysbus_init_irq(sbd, &s->irq_cluster_0_imr_wake);
    sysbus_init_irq(sbd, &s->irq_apu_pcil_imr);
    sysbus_init_irq(sbd, &s->irq_cluster_1_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_7_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_10_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_9_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_6_imr_wake);
    sysbus_init_irq(sbd, &s->irq_cluster_1_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_15_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_4_imr_wake);
    sysbus_init_irq(sbd, &s->irq_core_11_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_8_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_10_imr_power);
    sysbus_init_irq(sbd, &s->irq_core_13_imr_wake);
}

static const VMStateDescription vmstate_apu_pcil = {
    .name = TYPE_XILINX_APU_PCIL,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, APU_PCIL, APU_PCIL_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void apu_pcil_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = apu_pcil_realize;
    dc->vmsd = &vmstate_apu_pcil;
    rc->phases.enter = apu_pcil_reset_enter;
    rc->phases.hold = apu_pcil_reset_hold;
}

static const TypeInfo apu_pcil_info = {
    .name          = TYPE_XILINX_APU_PCIL,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(APU_PCIL),
    .class_init    = apu_pcil_class_init,
    .instance_init = apu_pcil_init,
};

static void apu_pcil_register_types(void)
{
    type_register_static(&apu_pcil_info);
}

type_init(apu_pcil_register_types)
