/*
 * QEMU model of the GTY_NPI_SLAVE
 *
 * Copyright (c) 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-02-04.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_GTY_NPI_SLAVE_ERR_DEBUG
#define XILINX_GTY_NPI_SLAVE_ERR_DEBUG 0
#endif

#define TYPE_XILINX_GTY_NPI_SLAVE "xlnx.versal-gty-npi"

#define XILINX_GTY_NPI_SLAVE(obj) \
     OBJECT_CHECK(GTY_NPI_SLAVE, (obj), TYPE_XILINX_GTY_NPI_SLAVE)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, BISR_TRIGGER, 29, 1)
    FIELD(REG_PCSR_MASK, BISR_TEST_CLR, 28, 1)
    FIELD(REG_PCSR_MASK, SHUTDOWN, 27, 1)
    FIELD(REG_PCSR_MASK, SELCTRLCFG, 26, 1)
    FIELD(REG_PCSR_MASK, SELNPICLK, 25, 1)
    FIELD(REG_PCSR_MASK, INITCTRL, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, PWRDN, 14, 1)
    FIELD(REG_PCSR_MASK, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_MASK, APBEN, 12, 1)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, TRISTATE, 8, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, BISR_TRIGGER, 29, 1)
    FIELD(REG_PCSR_CONTROL, BISR_TEST_CLR, 28, 1)
    FIELD(REG_PCSR_CONTROL, SHUTDOWN, 27, 1)
    FIELD(REG_PCSR_CONTROL, SELCTRLCFG, 26, 1)
    FIELD(REG_PCSR_CONTROL, SELNPICLK, 25, 1)
    FIELD(REG_PCSR_CONTROL, INITCTRL, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, PWRDN, 14, 1)
    FIELD(REG_PCSR_CONTROL, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_CONTROL, APBEN, 12, 1)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, TRISTATE, 8, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, GTPOWERGOOD, 21, 1)
    FIELD(REG_PCSR_STATUS, BISR_PASS, 20, 1)
    FIELD(REG_PCSR_STATUS, BISR_DONE, 19, 1)
    FIELD(REG_PCSR_STATUS, SHUTDOWN_COMPLETE, 18, 1)
    FIELD(REG_PCSR_STATUS, HOUSECLEAN_DONE, 17, 1)
    FIELD(REG_PCSR_STATUS, RESETERROR, 16, 1)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(MULTICAST, 0x10)
    FIELD(MULTICAST, CHANNEL, 0, 4)
REG32(SIVERSION, 0x14)
REG32(OWNPROGEXCLACCESS, 0x18)
    FIELD(OWNPROGEXCLACCESS, ACCESS, 0, 3)
REG32(GT_GTY_ISR, 0x20)
    FIELD(GT_GTY_ISR, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_ISR, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_ISR, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_ISR, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_ISR, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_ITR, 0x24)
    FIELD(GT_GTY_ITR, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_ITR, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_ITR, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_ITR, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_ITR, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IMR0, 0x28)
    FIELD(GT_GTY_IMR0, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IMR0, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IMR0, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IMR0, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IMR0, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IER0, 0x2c)
    FIELD(GT_GTY_IER0, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IER0, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IER0, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IER0, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IER0, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IDR0, 0x30)
    FIELD(GT_GTY_IDR0, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IDR0, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IDR0, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IDR0, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IDR0, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IMR1, 0x34)
    FIELD(GT_GTY_IMR1, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IMR1, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IMR1, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IMR1, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IMR1, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IER1, 0x38)
    FIELD(GT_GTY_IER1, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IER1, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IER1, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IER1, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IER1, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IDR1, 0x3c)
    FIELD(GT_GTY_IDR1, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IDR1, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IDR1, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IDR1, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IDR1, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IMR2, 0x40)
    FIELD(GT_GTY_IMR2, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IMR2, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IMR2, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IMR2, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IMR2, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IER2, 0x44)
    FIELD(GT_GTY_IER2, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IER2, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IER2, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IER2, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IER2, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IDR2, 0x48)
    FIELD(GT_GTY_IDR2, BISR_RAM_ERR, 4, 1)
    FIELD(GT_GTY_IDR2, MBIST_RAM_ERR, 3, 1)
    FIELD(GT_GTY_IDR2, SECDED_DOUBLE_ERR, 2, 1)
    FIELD(GT_GTY_IDR2, SECDED_SINGLE_ERR, 1, 1)
    FIELD(GT_GTY_IDR2, CANCEL_ACCESS, 0, 1)
REG32(GT_GTY_IOR, 0x4c)
    FIELD(GT_GTY_IOR, OFFSET, 0, 5)
REG32(BISR_CACHE_DATA_0, 0x64)
REG32(BISR_CACHE_DATA_1, 0x68)
REG32(BISR_TEST_DATA_0, 0x6c)
REG32(BISR_TEST_DATA_1, 0x70)
REG32(CH0_COESTATUS_CHANNEL_RESET0, 0x2000)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, CDRSRESET_ENABLE, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, DES_RST_SYNC_EN, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPIDIV, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPIDIV, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_ILO, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPI, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPI, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_PHDLY, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_PHDLY, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_PRBSCNT, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_OOB, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_ISCAN, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_BUF, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_PCS, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_DFE, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRFR, 11, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRPH, 10, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_PMA, 9, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_CLKGEN, 8, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_CKOK, 7, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_CFOK, 6, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_PCS, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_PMA, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_CLKGEN, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_CKCAL, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_RX_PROGDIV, 1, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET0, RESETB_TX_PROGDIV, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_RESET1, 0x2004)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, RESET_EXCEPTION, 31, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, ILO_LOOP_ERR, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, RX_CHICO_RESET_ERR, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, TX_CHICO_RESET_ERR, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, RX_PROGDDIV_RESET_ERR, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, TX_PROGDDIV_RESET_ERR, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, RX_DAPI_RESET_ERR, 18, 2)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, TX_DAPI_RESET_ERR, 16, 2)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, RX_PCS_LOOP_ERR, 11, 5)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, RX_PMA_LOOP_ERR, 4, 7)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, TX_PCS_LOOP_ERR, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET1, TX_PMA_LOOP_ERR, 0, 3)
REG32(CH0_COESTATUS_CHANNEL_RESET2, 0x2008)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, ILO_RESETDONE, 30, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_RESETDONE, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_RESETDONE, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_PMA_RESETDONE, 27, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_PMA_RESETDONE, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_DAPIRESET_DONE, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_DAPIRESET_DONE, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_CHICORESET_DONE, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_CHICORESET_DONE, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_PROGDIVRESET_DONE, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_PROGDIVRESET_DONE, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_DAPI_LOOP_DONE, 18, 2)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_DAPI_LOOP_DONE, 16, 2)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_PCS_LOOP_DONE, 11, 5)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, RX_PMA_LOOP_DONE, 4, 7)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_PCS_LOOP_DONE, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_RESET2, TX_PMA_LOOP_DONE, 0, 3)
REG32(CH0_COESTATUS_CHANNEL_PIPE_RATE3, 0x200c)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_CHANGE_FROM_TO_ESM, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_ESM_DAPIRST_DONE, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_REQUEST_INT, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, RX_ADAPT_IN_PROGRESS_INT, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_DONE_R, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LTSSM_STATE_INT_R, 7, 6)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LINK_REACH_TARGET_INT_R, 6, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, PHY_ESM_ADAPTATION_SAVE_R, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_DONE_RXRATE, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_REQUEST_RXRATE_INT, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, RXRATE_CHANGE_IN_PROGRESS_INT, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE3, FSM_RX_RATE, 0, 2)
REG32(CH0_COESTATUS_CHANNEL_PIPE_RATE2, 0x2010)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, TXRX_128B130B_EN_INT, 31, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT, 30, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_PD_INT, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_RESET_INT, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_LOCK_INT, 27, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_PD_INT, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_RESET_INT, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_PD_INT, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_RESET_INT, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_LOCK_INT, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_PD_INT, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_RESET_INT, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, TXPROGDIV_RESET_INT, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, PMA_RESET_INT, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, PCS_RESET_INT, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, UB_REPROG_REQUEST_INT, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_INT, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_INT, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_IN_PROGRESS_INT, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_PLL_RESET, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT_R, 8, 4)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_8B10B_TO_128B130B, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_128B130B_TO_8B10B, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_ESM, 1, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_128B130B, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_PIPE_RATE0, 0x2014)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_RX, 24, 8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_RX, 16, 8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_TX, 8, 8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_TX, 0, 8)
REG32(CH0_COESTATUS_CHANNEL_PIPE_RATE1, 0x2018)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, TXDAPI_RESET_INT, 31, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, RPLL_LOCK_R, 30, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, LCPLL_LOCK_R, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, TXPROGDIV_RESET_DONE_R, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, TX_PMA_RESETDONE_R, 27, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, RX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, TXRESET_DONE_R, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, RXRESET_DONE_R, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, TXSYNC_DONE_R, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, RXSYNC_DONE_R, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, TXRATE_R, 14, 8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, RXRATE_R, 6, 8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, UB_REPROG_DONE_R, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RATE1, FSM_RATE, 0, 5)
REG32(CH0_COESTATUS_TXUSRCLK_FREQ_CNT, 0x201c)
    FIELD(CH0_COESTATUS_TXUSRCLK_FREQ_CNT, TXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH0_COESTATUS_TXPHYCLK_FREQ_CNT, 0x2020)
    FIELD(CH0_COESTATUS_TXPHYCLK_FREQ_CNT, TXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH0_COESTATUS_TXPCSCLK_FREQ_CNT, 0x2024)
    FIELD(CH0_COESTATUS_TXPCSCLK_FREQ_CNT, TXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH0_COESTATUS_RXUSRCLK_FREQ_CNT, 0x2028)
    FIELD(CH0_COESTATUS_RXUSRCLK_FREQ_CNT, RXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH0_COESTATUS_RXPHYCLK_FREQ_CNT, 0x202c)
    FIELD(CH0_COESTATUS_RXPHYCLK_FREQ_CNT, RXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH0_COESTATUS_RXPCSCLK_FREQ_CNT, 0x2030)
    FIELD(CH0_COESTATUS_RXPCSCLK_FREQ_CNT, RXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH0_COESTATUS_CRC_TX, 0x2034)
REG32(CH0_COESTATUS_CRC_RX, 0x2038)
REG32(CH0_TXCHICO_DBG_SIG_00, 0x2040)
    FIELD(CH0_TXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_00, TXPCSDAPICLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_01, 0x2044)
    FIELD(CH0_TXCHICO_DBG_SIG_01, CLK4TXPI, 8, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_01, TXPICODE, 1, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_01, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_02, 0x2048)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ_SYNC, 28, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS_SYNC, 27, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ_SYNC, 26, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ_SYNC, 25, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE_SYNC, 24, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE_SYNC, 23, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH0_TXCHICO_DBG_SIG_02, TX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH0_TXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH0_TXCHICO_DBG_SIG_02, TXDAPICLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_03, 0x204c)
    FIELD(CH0_TXCHICO_DBG_SIG_03, TXPI_TOP_IN, 13, 4)
    FIELD(CH0_TXCHICO_DBG_SIG_03, TXPI_BOT_IN, 9, 4)
    FIELD(CH0_TXCHICO_DBG_SIG_03, TXPO_TOP_OUT, 5, 4)
    FIELD(CH0_TXCHICO_DBG_SIG_03, TXPO_BOT_OUT, 1, 4)
REG32(CH0_TXCHICO_DBG_SIG_04, 0x2050)
    FIELD(CH0_TXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH0_TXCHICO_DBG_SIG_05, 0x2054)
    FIELD(CH0_TXCHICO_DBG_SIG_05, TXPI_SETINIT_PH_CNT, 22, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_05, TXPI_MAX_SAMPLE_THRESHOLD, 15, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_05, TXPI_MIN_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_05, TXPI_NUM_SAMPLES, 1, 7)
REG32(CH0_TXCHICO_DBG_SIG_06, 0x2058)
    FIELD(CH0_TXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH0_TXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH0_TXCHICO_DBG_SIG_07, 0x205c)
    FIELD(CH0_TXCHICO_DBG_SIG_07, TX_WID_RATIO, 13, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, TX_CHICO_EN, 10, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH0_TXCHICO_DBG_SIG_08, 0x2060)
    FIELD(CH0_TXCHICO_DBG_SIG_08, TXPI_DIV, 11, 11)
    FIELD(CH0_TXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH0_TXCHICO_DBG_SIG_09, 0x2064)
    FIELD(CH0_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_09, TX_PHASE_SHIFT180_REQ, 19, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH0_TXCHICO_DBG_SIG_09, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_10, 0x2068)
    FIELD(CH0_TXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH0_TXCHICO_DBG_SIG_10, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_11, 0x206c)
    FIELD(CH0_TXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH0_TXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_11, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_12, 0x2070)
    FIELD(CH0_TXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_12, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_13, 0x2074)
    FIELD(CH0_TXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH0_TXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH0_TXCHICO_DBG_SIG_13, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_14, 0x2078)
    FIELD(CH0_TXCHICO_DBG_SIG_14, DBG_TXPI_P_STATE, 15, 5)
    FIELD(CH0_TXCHICO_DBG_SIG_14, DBG_TXPI_LAST_SAMPLE_ACC, 7, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_14, DBG_TXPI_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_14, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_15, 0x207c)
    FIELD(CH0_TXCHICO_DBG_SIG_15, DBG_TXPI_INC_PH_CNT, 13, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_15, DBG_TXPI_DEC_PH_CNT, 7, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_15, DBG_TXPI_HOLD_PH_CNT, 1, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_15, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_16, 0x2080)
    FIELD(CH0_TXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_16, MLDLY_BEACON_2, 1, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_16, TXUSRCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_17, 0x2084)
    FIELD(CH0_TXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH0_TXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH0_TXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH0_TXCHICO_DBG_SIG_17, TXDAPICLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_18, 0x2088)
    FIELD(CH0_TXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH0_TXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH0_TXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH0_TXCHICO_DBG_SIG_18, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_19, 0x208c)
    FIELD(CH0_TXCHICO_DBG_SIG_19, DBG_TXPI_STATE, 21, 4)
    FIELD(CH0_TXCHICO_DBG_SIG_19, DBG_TXPI_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH0_TXCHICO_DBG_SIG_19, DBG_TXPI_BEACON_XOR, 1, 2)
    FIELD(CH0_TXCHICO_DBG_SIG_19, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_20, 0x2090)
    FIELD(CH0_TXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH0_TXCHICO_DBG_SIG_20, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_21, 0x2094)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_CHICO_OUT_RSVD, 8, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_SYNC_DONE, 3, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH0_TXCHICO_DBG_SIG_22, 0x2098)
    FIELD(CH0_TXCHICO_DBG_SIG_22, MC_TXPICODE_DDR_EN, 9, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_22, TXPICODE_DDR, 1, 8)
    FIELD(CH0_TXCHICO_DBG_SIG_22, TXPCSCLK_INT, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_23, 0x209c)
    FIELD(CH0_TXCHICO_DBG_SIG_23, DBG_VIR_DIFF, 0, 12)
REG32(CH0_TXCHICO_DBG_SIG_24, 0x20a0)
    FIELD(CH0_TXCHICO_DBG_SIG_24, BEACON_128B130B, 3, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_24, TXPCSCLK_INT_DLY_128B130B, 2, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_24, BEACON_DLY_PCSCLK_128B130B, 1, 1)
    FIELD(CH0_TXCHICO_DBG_SIG_24, RST_BEACON_PCSCLK_DLY_INT_B_128B130B, 0, 1)
REG32(CH0_TXCHICO_DBG_SIG_25, 0x20a4)
REG32(CH0_TXCHICO_DBG_SIG_26, 0x20a8)
REG32(CH0_TXCHICO_DBG_SIG_27, 0x20ac)
REG32(CH0_TXCHICO_DBG_SIG_28, 0x20b0)
REG32(CH0_TXCHICO_DBG_SIG_29, 0x20b4)
REG32(CH0_TXCHICO_DBG_SIG_30, 0x20b8)
REG32(CH0_TXCHICO_DBG_SIG_31, 0x20bc)
REG32(CH0_RXCHICO_DBG_SIG_00, 0x20c0)
    FIELD(CH0_RXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH0_RXCHICO_DBG_SIG_00, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_01, 0x20c4)
REG32(CH0_RXCHICO_DBG_SIG_02, 0x20c8)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ, 28, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS, 27, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ, 26, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ, 25, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE, 24, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE, 23, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH0_RXCHICO_DBG_SIG_02, RX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH0_RXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH0_RXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH0_RXCHICO_DBG_SIG_02, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_03, 0x20cc)
    FIELD(CH0_RXCHICO_DBG_SIG_03, RXPI_TOP_IN, 13, 4)
    FIELD(CH0_RXCHICO_DBG_SIG_03, RXPI_BOT_IN, 9, 4)
    FIELD(CH0_RXCHICO_DBG_SIG_03, RXPO_TOP_OUT, 5, 4)
    FIELD(CH0_RXCHICO_DBG_SIG_03, RXPO_BOT_OUT, 1, 4)
REG32(CH0_RXCHICO_DBG_SIG_04, 0x20d0)
    FIELD(CH0_RXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH0_RXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH0_RXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH0_RXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH0_RXCHICO_DBG_SIG_05, 0x20d4)
REG32(CH0_RXCHICO_DBG_SIG_06, 0x20d8)
    FIELD(CH0_RXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH0_RXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH0_RXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH0_RXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH0_RXCHICO_DBG_SIG_07, 0x20dc)
    FIELD(CH0_RXCHICO_DBG_SIG_07, RX_WID_RATIO, 13, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, RX_CHICO_EN, 10, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH0_RXCHICO_DBG_SIG_08, 0x20e0)
    FIELD(CH0_RXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH0_RXCHICO_DBG_SIG_09, 0x20e4)
    FIELD(CH0_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_DONE, 19, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_REQ, 18, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH0_RXCHICO_DBG_SIG_09, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_10, 0x20e8)
    FIELD(CH0_RXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH0_RXCHICO_DBG_SIG_10, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_11, 0x20ec)
    FIELD(CH0_RXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH0_RXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH0_RXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH0_RXCHICO_DBG_SIG_11, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_12, 0x20f0)
    FIELD(CH0_RXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH0_RXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH0_RXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH0_RXCHICO_DBG_SIG_12, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_13, 0x20f4)
    FIELD(CH0_RXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH0_RXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH0_RXCHICO_DBG_SIG_13, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_14, 0x20f8)
REG32(CH0_RXCHICO_DBG_SIG_15, 0x20fc)
REG32(CH0_RXCHICO_DBG_SIG_16, 0x2100)
    FIELD(CH0_RXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_16, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_17, 0x2104)
    FIELD(CH0_RXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH0_RXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH0_RXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH0_RXCHICO_DBG_SIG_17, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_18, 0x2108)
    FIELD(CH0_RXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH0_RXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH0_RXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH0_RXCHICO_DBG_SIG_18, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_19, 0x210c)
REG32(CH0_RXCHICO_DBG_SIG_20, 0x2110)
    FIELD(CH0_RXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH0_RXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH0_RXCHICO_DBG_SIG_20, RXUSRCLK_INT, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_21, 0x2114)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_FINE_ALIGN_DONE, 8, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_SYNC_DONE, 3, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH0_RXCHICO_DBG_SIG_22, 0x2118)
    FIELD(CH0_RXCHICO_DBG_SIG_22, DBG_VIR_DIFF, 0, 12)
REG32(CH0_RXCHICO_DBG_SIG_23, 0x211c)
    FIELD(CH0_RXCHICO_DBG_SIG_23, BEACON_128B130B, 3, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_23, RST_BEACON_USRCLK_DLY_INT_B_128B130B, 2, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_23, RXUSRCLK_INT_DLY_128B130B, 1, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_23, BEACON_DLY_USRCLK_128B130B, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_24, 0x2120)
    FIELD(CH0_RXCHICO_DBG_SIG_24, CLK_SLIP_ERR, 8, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, CDR_SLIP_REQ, 7, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, CDR_SLIP_DIR, 6, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_DONE, 5, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_REQ, 4, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, CDR_SLIP_READY, 3, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, BEACON_OUT, 2, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, POLARITY_SL, 1, 1)
    FIELD(CH0_RXCHICO_DBG_SIG_24, POLARITY_IM, 0, 1)
REG32(CH0_RXCHICO_DBG_SIG_25, 0x2124)
REG32(CH0_RXCHICO_DBG_SIG_26, 0x2128)
REG32(CH0_RXCHICO_DBG_SIG_27, 0x212c)
REG32(CH0_RXCHICO_DBG_SIG_28, 0x2130)
REG32(CH0_RXCHICO_DBG_SIG_29, 0x2134)
REG32(CH0_RXCHICO_DBG_SIG_30, 0x2138)
REG32(CH0_RXCHICO_DBG_SIG_31, 0x213c)
REG32(CH0_COE_STATUS_EYESCAN_0, 0x2140)
REG32(CH0_COE_STATUS_EYESCAN_1, 0x2144)
REG32(CH0_COE_STATUS_EYESCAN_2, 0x2148)
REG32(CH0_COE_STATUS_EYESCAN_3, 0x214c)
REG32(CH0_COE_STATUS_EYESCAN_4, 0x2150)
REG32(CH0_COE_STATUS_EYESCAN_5, 0x2154)
REG32(CH0_COE_STATUS_EYESCAN_6, 0x2158)
REG32(CH0_COE_STATUS_EYESCAN_7, 0x215c)
REG32(CH0_COE_STATUS_EYESCAN_8, 0x2160)
REG32(CH0_COE_STATUS_EYESCAN_9, 0x2164)
REG32(CH0_COE_STATUS_EYESCAN_10, 0x2168)
    FIELD(CH0_COE_STATUS_EYESCAN_10, COE_STATUS_ES_SAMPLE_COUNT, 16, 16)
    FIELD(CH0_COE_STATUS_EYESCAN_10, COE_STATUS_ES_ERROR_COUNT, 0, 16)
REG32(CH0_COE_STATUS_EYESCAN_11, 0x216c)
    FIELD(CH0_COE_STATUS_EYESCAN_11, COE_STATUS_ES_CONTROL_STATUS, 0, 4)
REG32(CH0_COE_STATUS_PRBSERR_CNT_0, 0x2170)
REG32(CH0_COE_STATUS_PRBSERR_CNT_1, 0x2174)
REG32(CH0_COE_STATUS_RX_CYCLECNT_0, 0x2178)
REG32(CH0_COE_STATUS_RX_CYCLECNT_1, 0x217c)
REG32(CH0_COE_STATUS_PRBS_LINK2RESEED_CNT, 0x2180)
    FIELD(CH0_COE_STATUS_PRBS_LINK2RESEED_CNT, RX_PRBS_LINK2RESEED_CNT, 0, 16)
REG32(CH0_COE_STATUS_TXGBOX_0, 0x2184)
    FIELD(CH0_COE_STATUS_TXGBOX_0, TXFIFO_UNDERFLOW, 25, 1)
    FIELD(CH0_COE_STATUS_TXGBOX_0, TXFIFO_OVERFLOW, 24, 1)
    FIELD(CH0_COE_STATUS_TXGBOX_0, TXFIFO_STATUS, 20, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH0_COE_STATUS_TXGBOX_1, 0x2188)
    FIELD(CH0_COE_STATUS_TXGBOX_1, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_1, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_1, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH0_COE_STATUS_TXGBOX_2, 0x218c)
    FIELD(CH0_COE_STATUS_TXGBOX_2, TXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH0_COE_STATUS_TXGBOX_2, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH0_COE_STATUS_TXGBOX_2, WR_ADDR_SYNC, 3, 3)
    FIELD(CH0_COE_STATUS_TXGBOX_2, RD_ADDR_SYNC, 0, 3)
REG32(CH0_COE_STATUS_TX64B66B_0, 0x2190)
    FIELD(CH0_COE_STATUS_TX64B66B_0, TX_16B_64B_ENC_EN, 30, 1)
    FIELD(CH0_COE_STATUS_TX64B66B_0, TXCTRL_CRC_DATAPACK_START, 29, 1)
    FIELD(CH0_COE_STATUS_TX64B66B_0, TXCTRL_XGMII_OR_CRC_INIT, 28, 1)
    FIELD(CH0_COE_STATUS_TX64B66B_0, TX_16B64B_DATAPAC_TRIG, 27, 1)
    FIELD(CH0_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_64B, 19, 8)
    FIELD(CH0_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_64B, 17, 2)
    FIELD(CH0_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_32B, 9, 8)
    FIELD(CH0_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_32B, 7, 2)
    FIELD(CH0_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_64B, 4, 3)
    FIELD(CH0_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_32B, 1, 3)
    FIELD(CH0_COE_STATUS_TX64B66B_0, STAT_TX_LOCAL_FAULT, 0, 1)
REG32(CH0_COE_STATUS_TX64B66B_1, 0x2194)
REG32(CH0_COE_STATUS_RX64B66B_0, 0x2198)
    FIELD(CH0_COE_STATUS_RX64B66B_0, BLOCK_LOCK, 23, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, COE_RX_TP_CNT, 13, 10)
    FIELD(CH0_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_32B, 10, 3)
    FIELD(CH0_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_64B, 7, 3)
    FIELD(CH0_COE_STATUS_RX64B66B_0, DECODER_IN_IS_BADLYFRAMED, 6, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, STAT_RX_HI_BER, 5, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, STAT_RX_BAD_CODE, 4, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, STAT_RX_TEST_PATTERN_MISMATCH, 3, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, STAT_RX_LOCAL_FAULT, 2, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, DESCRAMBLER2DECODER_IS_BADLYFRAMED, 1, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_0, STAT_RX_VALID_CTRL_CODE, 0, 1)
REG32(CH0_COE_STATUS_RX64B66B_1, 0x219c)
REG32(CH0_COE_STATUS_RX64B66B_2, 0x21a0)
    FIELD(CH0_COE_STATUS_RX64B66B_2, RXOUT_FIFO_16B_UNPACK_EN, 1, 1)
    FIELD(CH0_COE_STATUS_RX64B66B_2, STAT_RX_FIFO_ERROR, 0, 1)
REG32(CH0_COE_STATUS_RXGBOX_FIFO_0, 0x21a4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_11_REG, 24, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH0_COE_STATUS_RXGBOX_FIFO_1, 0x21a8)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_1, RXFIFO_STATUS, 0, 8)
REG32(CH0_COE_STATUS_RXGBOX_FIFO_2, 0x21ac)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_10_REG, 24, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_0_WR_CLK, 16, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH0_COE_STATUS_RXGBOX_FIFO_3, 0x21b0)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_1, 15, 1)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_B, 8, 7)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_0, 7, 1)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_A, 0, 7)
REG32(CH0_COE_STATUS_RXGBOX_FIFO_4, 0x21b4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_OVERFLOW, 31, 1)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_UNDERFLOW, 30, 1)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, RXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, DELAY_RXDATA, 10, 2)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, WR_ADDR_SYNC, 3, 3)
    FIELD(CH0_COE_STATUS_RXGBOX_FIFO_4, RD_ADDR_SYNC, 0, 3)
REG32(CH0_COE_STATUS_8B10BEB_RESET_0, 0x21b8)
REG32(CH0_COE_STATUS_8B10BEB_RESET_1, 0x21bc)
REG32(CH0_COESTATUS_PMA_0, 0x21c0)
    FIELD(CH0_COESTATUS_PMA_0, RX_PKDET_AS, 23, 1)
    FIELD(CH0_COESTATUS_PMA_0, TXSWING_OUT_LOW_AS, 22, 1)
    FIELD(CH0_COESTATUS_PMA_0, TXSWING_OUT_HIGH_AS, 21, 1)
    FIELD(CH0_COESTATUS_PMA_0, TX_QPISENN_AS, 19, 1)
    FIELD(CH0_COESTATUS_PMA_0, TX_DCC_READY_AS, 18, 1)
    FIELD(CH0_COESTATUS_PMA_0, RX_QPISENP_AS, 17, 1)
    FIELD(CH0_COESTATUS_PMA_0, RX_QPISENN_AS, 16, 1)
    FIELD(CH0_COESTATUS_PMA_0, RX_DXDS_CALDONE_AS, 11, 1)
    FIELD(CH0_COESTATUS_PMA_0, CDR_SLIP_RDY_AS, 10, 1)
    FIELD(CH0_COESTATUS_PMA_0, CDR_SRSTSTATUS_AS, 9, 1)
    FIELD(CH0_COESTATUS_PMA_0, CDR_WALKDONE_AS, 8, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_LOSSDATA_AS, 7, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_LCKSTATUS_AS, 6, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_CALENDAC_AS, 5, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_OVWRRDY1_AS, 4, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_OVWRRDY0_AS, 3, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_CDRLOCK_AS, 2, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_CALTIMEOUT_AS, 1, 1)
    FIELD(CH0_COESTATUS_PMA_0, ADAPT_CALDONE_AS, 0, 1)
REG32(CH0_COE_STATUS_PLL_STATUS, 0x21c4)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_RSTB_INT, 18, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_REFDIVRSTB_INT, 17, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_RESET_LOOP_DONE, 15, 2)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_PWRDN_B, 14, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_RST_ERR, 13, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_REFLOSS, 12, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_FBLOSS, 11, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_UNLOCK, 10, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_CRSCODE, 3, 7)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_FINE_EN, 2, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_VCO_SEL, 1, 1)
    FIELD(CH0_COE_STATUS_PLL_STATUS, PLL_FREQLOCK, 0, 1)
REG32(CH0_COESTATUS_PMA_1, 0x21c8)
    FIELD(CH0_COESTATUS_PMA_1, ILO_MODE_TUNE_AS, 13, 2)
    FIELD(CH0_COESTATUS_PMA_1, ILO_CLK_LOST_AS, 12, 1)
    FIELD(CH0_COESTATUS_PMA_1, ILO_FBCLK_LOST_AS, 11, 1)
    FIELD(CH0_COESTATUS_PMA_1, ILO_FINE_EN_AS, 10, 1)
    FIELD(CH0_COESTATUS_PMA_1, ILO_FTL_TUNE_AS, 2, 8)
    FIELD(CH0_COESTATUS_PMA_1, UNLOCK_ILO_AS, 1, 1)
    FIELD(CH0_COESTATUS_PMA_1, ILO_LOCK_AS, 0, 1)
REG32(CH0_COESTATUS_RX_FABRIC_INTF0, 0x21cc)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXSTARTOFSEQ, 17, 2)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXVALID, 16, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, COMWAKE, 15, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, COMSAS, 14, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, COMINIT, 13, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXCLKCORCNT, 11, 2)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXBUFSTATUS, 8, 3)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXCHANREALIGN, 7, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXCHANISALIGNED, 6, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXCHANBONDSEQ, 5, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF0, RXCHBONDO, 0, 5)
REG32(CH0_COESTATUS_RX_FABRIC_INTF1, 0x21d0)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF1, RXSLIPDONE, 4, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF1, RXSLIDERDY, 3, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF1, RXCOMMADET, 2, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF1, RXBYTEREALIGN, 1, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF1, RXBYTEISALIGNED, 0, 1)
REG32(CH0_COESTATUS_RX_FABRIC_INTF2, 0x21d4)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF2, DMON_FIFO_STATUS, 3, 2)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF2, EYESCANDATAERROR, 2, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF2, RXPRBSLOCKED, 1, 1)
    FIELD(CH0_COESTATUS_RX_FABRIC_INTF2, RXPRBSERR, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_PIPE_RESET, 0x21d8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, ILO_LOCK_R, 31, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, GT_POWERGOOD_R, 30, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RPLL_LOCK_R, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_LOCK_R, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_DONE_R, 27, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RX_PMA_RESETDONE_R, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TXRESET_DONE_R, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RXRESET_DONE_R, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_DONE_R, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_DONE_R, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, PHYSTATUS_R, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RPLL_PD_INT_DLY, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RPLL_RESET_INT_DLY, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_PD_INT_DLY, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_RESET_INT_DLY, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_INT_DLY, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, PMA_RESET_INT_DLY, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, PCS_RESET_INT_DLY, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, USER_RDY_INT_DLY, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_INT, 11, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_INT, 10, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, PHY_READY_INT, 9, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, BUFGT_PHY_READY, 8, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RESET, FSM_PIPE_RST_CTRL, 0, 4)
REG32(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, 0x21dc)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_SYNC, 31, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_INT, 30, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_R, 28, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_DELAY, 24, 4)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_SYNC, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_SYNC, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RX_CDR_ALIGN_DONE_SYNC, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_R, 19, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_R, 17, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_IN_PROGRESS_R, 15, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_ENTER, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_ENTER, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_EXIT, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_EXIT, 11, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SRIS_MODE, 10, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, COMMON_REF_MODE, 9, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, FSM_CDR_CTRL, 6, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRFREQRESET, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDR_ALGN_REQ, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_DET, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_RATE, 1, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD_IN, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, 0x21e0)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE_FROM_TO_ESM, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK_R, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_SEL_INT, 25, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, FSM_BUFG, 22, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CTRL_IN_PROGRESS, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_RESET_INT, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CE_INT, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_RESET_MASK_INT, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_CE_MASK_INT, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_RESET_MASK_INT, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_CE_MASK_INT, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_INT, 12, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFGT_RATE, 9, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK, 8, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE, 7, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, PHY_READY, 6, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER, 1, 5)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER_DONE, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_PIPE_PD, 0x21e4)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RXNEW_PD, 30, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RXCURRENT_PD, 28, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TXNEW_PD, 26, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TXCURRENT_PD, 24, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, BEACON, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, PWRUPTX, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, PWRUPTXDRV, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, PWRUPRX, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, PWRUPDET, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RPLL_PD_SA, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, LCPLL_PD_SA, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TXPMA_PWRDN_B_SA, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TXDRVPWRDN_B_SA, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RX_PDB_SA, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, OOB_PDB_SA, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TXSERPWRDN_B_SA, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RXCKMUXPWRDN_B_SA, 11, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TXCKMUXPWRDN_B_SA, 10, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TX_VREG_PDB_SA, 9, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RX_VREG_PDB_SA, 8, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TX_P_CHANGE, 7, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RX_P_CHANGE, 6, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN_PULSE, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, CLR_PHYSTATUS, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, SET_PHYSTATUS, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, TX_P2_CHANGE, 1, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_PD, RX_P2_CHANGE, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, 0x21e8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_BYPASS, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_AS, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_AS, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SA_REG, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETPOLL_SA_REG, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_EN_SA_REG, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_D, 17, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART01, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ZERO, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ONE, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ZERO, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ONE, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_DONE, 11, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SYNC, 10, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER, 7, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVREF_EN, 6, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_SYNC, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_SYNC, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_DELAY, 0, 4)
REG32(CH0_COESTATUS_CHANNEL_PIPE_STAT, 0x21ec)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_128B130B, 29, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_8B10B, 26, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RCVABSENT_SYNC, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RCVPRESENT_SYNC, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RST_PERIOD_SYNC, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RATE_SYNC, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_1, 19, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_0, 16, 3)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_UNDERFLOW_8B10B, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_OVERFLOW_8B10B, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXNOTINTABLE_8B10B, 12, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXDISPERR_8B10B, 10, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXCLKCORCNT_EARLY_8B10B, 8, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, ENB_NOTINTABLE, 6, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, ENB_DISPERR, 4, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RCVDET, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_PWRDWN, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS, 1, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_STAT, RXRATEDONE, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_TX_EQ, 0x21f0)
    FIELD(CH0_COESTATUS_CHANNEL_TX_EQ, TXDRVBIASP_SA, 21, 5)
    FIELD(CH0_COESTATUS_CHANNEL_TX_EQ, TXEMPPRE_SA, 16, 5)
    FIELD(CH0_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_SA, 9, 7)
    FIELD(CH0_COESTATUS_CHANNEL_TX_EQ, TXEMPPOS_SA, 4, 5)
    FIELD(CH0_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_INDEP_SA, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_EQ, TXPDRVAMP_SA, 0, 3)
REG32(CH0_COESTATUS_CHANNEL_TX_ELEC, 0x21f4)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_PCIE_SATA, 31, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_USB3, 30, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXCOMINIT_TXPHYCLK, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, P0_LOOPBACK_PERIOD, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXCOMSAS_TXPHYCLK, 27, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXCOMWAKE_TXPHYCLK, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, COMSTART_TXPHYCLK, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_PCIE_USB3, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_DELAY, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_SEL, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, P0_DATA_PERIOD, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, P0_LFPS_PERIOD, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, P0_TRISTATE_PERIOD, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, USB3_P23_RXDETECTION_PERIOD, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_TRISTATE_PERIOD, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_LFPS_PERIOD, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, USB3_TRISTATE_PERIOD, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_INT, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, SATA_WORDCOUNT, 10, 3)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, USB3_LFPS_PERIOD, 9, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TXELEC_LFPS, 8, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, TX_OOB_SIGSEL, 6, 2)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, PCIE_RXLOOPBACK, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, RCVDETSTART, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, COMSTATE, 2, 2)
    FIELD(CH0_COESTATUS_CHANNEL_TX_ELEC, COMTYPE, 0, 2)
REG32(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, 0x21f8)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_ILO_RESET, 29, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_RXELECIDLE, 28, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_INT, 27, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_OOBSIGVAL_AS, 26, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PMA_RESET, 25, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PMA_RESET, 24, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PCS_RESET, 23, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PCS_RESET, 22, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXPROGDIV_RESET, 21, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_TXPROGDIV_RESET, 20, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHY_READY, 19, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RATE_CHANGE_IN_PROGRESS, 18, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXSYNC_RESET, 17, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RXSYNC_RESET, 16, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_RPLL_RESET, 15, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RPLL_RESET, 14, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_LCPLL_RESET, 13, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_LCPLL_RESET, 12, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PROGDIVRESET_DONE, 11, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PMA_RESETDONE, 10, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_PMA_RESETDONE, 9, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_RESETDONE, 8, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_RESETDONE, 7, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_LOCK, 5, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_RESETDONE, 4, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, LCPLL_RESETDONE, 3, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHYSTATUS_INT, 2, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TXSYNC_DONE, 1, 1)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RXSYNC_DONE, 0, 1)
REG32(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, 0x21fc)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE, 30, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE_CP7, 28, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, FE_PMA_LPBK_FIFO_STATUS, 26, 2)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_IN, 12, 4)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_IN, 8, 4)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_OUT, 4, 4)
    FIELD(CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_OUT, 0, 4)
REG32(CH0_COESTATUS_ADAPT_LOOP_00, 0x2280)
REG32(CH0_COESTATUS_ADAPT_LOOP_01, 0x2284)
REG32(CH0_COESTATUS_ADAPT_LOOP_02, 0x2288)
REG32(CH0_COESTATUS_ADAPT_LOOP_03, 0x228c)
REG32(CH0_COESTATUS_ADAPT_LOOP_04, 0x2290)
REG32(CH0_COESTATUS_ADAPT_LOOP_05, 0x2294)
REG32(CH0_COESTATUS_ADAPT_LOOP_06, 0x2298)
REG32(CH0_COESTATUS_ADAPT_LOOP_07, 0x229c)
REG32(CH0_COESTATUS_ADAPT_LOOP_08, 0x22a0)
REG32(CH0_COESTATUS_ADAPT_LOOP_09, 0x22a4)
REG32(CH0_COESTATUS_ADAPT_LOOP_10, 0x22a8)
REG32(CH0_COESTATUS_ADAPT_LOOP_11, 0x22ac)
REG32(COE_STATUS_POR_FSM, 0x2300)
    FIELD(COE_STATUS_POR_FSM, STATE, 7, 8)
    FIELD(COE_STATUS_POR_FSM, FST_CFG, 6, 1)
    FIELD(COE_STATUS_POR_FSM, RCAL_EN, 5, 1)
    FIELD(COE_STATUS_POR_FSM, GT_POR_B, 4, 1)
    FIELD(COE_STATUS_POR_FSM, GT_DELAY_POR_B, 3, 1)
    FIELD(COE_STATUS_POR_FSM, CALDONE, 2, 1)
    FIELD(COE_STATUS_POR_FSM, GTPOWERGOOD, 1, 1)
    FIELD(COE_STATUS_POR_FSM, GTREADY, 0, 1)
REG32(COE_STATUS_RCAL, 0x2304)
    FIELD(COE_STATUS_RCAL, VCTRL_SELECT_INT, 6, 3)
    FIELD(COE_STATUS_RCAL, RCAL_CMP_SF, 5, 1)
    FIELD(COE_STATUS_RCAL, RCAL_SF, 0, 5)
REG32(COE_STATUS_APB0, 0x2310)
    FIELD(COE_STATUS_APB0, PREADY, 1, 1)
    FIELD(COE_STATUS_APB0, PSLVERR, 0, 1)
REG32(COE_STATUS_APB1, 0x2314)
REG32(COE_STATUS_MST_RST_LOOPER0, 0x2318)
    FIELD(COE_STATUS_MST_RST_LOOPER0, INITIAL_START, 16, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER0, RX_LOOPER_START, 12, 4)
    FIELD(COE_STATUS_MST_RST_LOOPER0, TX_LOOPER_START, 8, 4)
    FIELD(COE_STATUS_MST_RST_LOOPER0, MST_RX_LOOPER_DONE, 4, 4)
    FIELD(COE_STATUS_MST_RST_LOOPER0, MST_TX_LOOPER_DONE, 0, 4)
REG32(COE_STATUS_MST_RST_LOOPER1, 0x231c)
    FIELD(COE_STATUS_MST_RST_LOOPER1, CH3_RX_RESET_LOOP_DONE, 15, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER1, CH2_RX_RESET_LOOP_DONE, 10, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER1, CH1_RX_RESET_LOOP_DONE, 5, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER1, CH0_RX_RESET_LOOP_DONE, 0, 5)
REG32(COE_STATUS_MST_RST_LOOPER2, 0x2320)
    FIELD(COE_STATUS_MST_RST_LOOPER2, CH3_TX_RESET_LOOP_DONE, 15, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER2, CH2_TX_RESET_LOOP_DONE, 10, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER2, CH1_TX_RESET_LOOP_DONE, 5, 5)
    FIELD(COE_STATUS_MST_RST_LOOPER2, CH0_TX_RESET_LOOP_DONE, 0, 5)
REG32(COE_STATUS_UB0, 0x2324)
    FIELD(COE_STATUS_UB0, PIT_STATUS, 30, 2)
    FIELD(COE_STATUS_UB0, GATEREG, 29, 1)
    FIELD(COE_STATUS_UB0, INITCTRL, 28, 1)
    FIELD(COE_STATUS_UB0, FABRICEN, 27, 1)
    FIELD(COE_STATUS_UB0, SLEEP, 26, 1)
    FIELD(COE_STATUS_UB0, WAKEUP, 25, 1)
    FIELD(COE_STATUS_UB0, RAM_PRESPONSE, 24, 1)
    FIELD(COE_STATUS_UB0, IMBENABLE, 23, 1)
    FIELD(COE_STATUS_UB0, IMBRST_INT_B_MX, 22, 1)
    FIELD(COE_STATUS_UB0, P_STATE, 16, 6)
    FIELD(COE_STATUS_UB0, ID_INTERRUPT, 15, 1)
    FIELD(COE_STATUS_UB0, D_INTERRUPT, 14, 1)
    FIELD(COE_STATUS_UB0, UB_INTR_FS, 2, 12)
    FIELD(COE_STATUS_UB0, UB_INTERRUPT_ATT_SET, 1, 1)
REG32(COE_STATUS_UB1, 0x2328)
    FIELD(COE_STATUS_UB1, MBRST_INT_B, 31, 1)
    FIELD(COE_STATUS_UB1, MBRST_SYNC_B, 29, 1)
    FIELD(COE_STATUS_UB1, GWE_RESETIN_B, 24, 1)
    FIELD(COE_STATUS_UB1, SCAN_EN, 23, 1)
    FIELD(COE_STATUS_UB1, SCAN_RST_BYP, 22, 1)
    FIELD(COE_STATUS_UB1, MBRST, 20, 1)
    FIELD(COE_STATUS_UB1, CFG_RST_INT_B, 18, 1)
    FIELD(COE_STATUS_UB1, CFG_RESET, 17, 1)
    FIELD(COE_STATUS_UB1, CFG_RST_B, 16, 1)
    FIELD(COE_STATUS_UB1, DG_WAKEUP, 9, 1)
    FIELD(COE_STATUS_UB1, WAKEUP, 8, 1)
    FIELD(COE_STATUS_UB1, N_STATE, 3, 5)
    FIELD(COE_STATUS_UB1, INT_STATES, 0, 3)
REG32(CH1_COESTATUS_CHANNEL_RESET0, 0x2400)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, CDRSRESET_ENABLE, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, DES_RST_SYNC_EN, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPIDIV, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPIDIV, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_ILO, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPI, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPI, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_PHDLY, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_PHDLY, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_PRBSCNT, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_OOB, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_ISCAN, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_BUF, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_PCS, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_DFE, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRFR, 11, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRPH, 10, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_PMA, 9, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_CLKGEN, 8, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_CKOK, 7, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_CFOK, 6, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_PCS, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_PMA, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_CLKGEN, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_CKCAL, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_RX_PROGDIV, 1, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET0, RESETB_TX_PROGDIV, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_RESET1, 0x2404)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, RESET_EXCEPTION, 31, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, ILO_LOOP_ERR, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, RX_CHICO_RESET_ERR, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, TX_CHICO_RESET_ERR, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, RX_PROGDDIV_RESET_ERR, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, TX_PROGDDIV_RESET_ERR, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, RX_DAPI_RESET_ERR, 18, 2)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, TX_DAPI_RESET_ERR, 16, 2)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, RX_PCS_LOOP_ERR, 11, 5)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, RX_PMA_LOOP_ERR, 4, 7)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, TX_PCS_LOOP_ERR, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET1, TX_PMA_LOOP_ERR, 0, 3)
REG32(CH1_COESTATUS_CHANNEL_RESET2, 0x2408)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, ILO_RESETDONE, 30, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_RESETDONE, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_RESETDONE, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_PMA_RESETDONE, 27, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_PMA_RESETDONE, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_DAPIRESET_DONE, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_DAPIRESET_DONE, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_CHICORESET_DONE, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_CHICORESET_DONE, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_PROGDIVRESET_DONE, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_PROGDIVRESET_DONE, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_DAPI_LOOP_DONE, 18, 2)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_DAPI_LOOP_DONE, 16, 2)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_PCS_LOOP_DONE, 11, 5)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, RX_PMA_LOOP_DONE, 4, 7)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_PCS_LOOP_DONE, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_RESET2, TX_PMA_LOOP_DONE, 0, 3)
REG32(CH1_COESTATUS_CHANNEL_PIPE_RATE3, 0x240c)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_CHANGE_FROM_TO_ESM, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_ESM_DAPIRST_DONE, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_REQUEST_INT, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, RX_ADAPT_IN_PROGRESS_INT, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_DONE_R, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LTSSM_STATE_INT_R, 7, 6)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LINK_REACH_TARGET_INT_R, 6, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, PHY_ESM_ADAPTATION_SAVE_R, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_DONE_RXRATE, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_REQUEST_RXRATE_INT, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, RXRATE_CHANGE_IN_PROGRESS_INT, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE3, FSM_RX_RATE, 0, 2)
REG32(CH1_COESTATUS_CHANNEL_PIPE_RATE2, 0x2410)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, TXRX_128B130B_EN_INT, 31, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT, 30, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_PD_INT, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_RESET_INT, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_LOCK_INT, 27, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_PD_INT, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_RESET_INT, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_PD_INT, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_RESET_INT, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_LOCK_INT, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_PD_INT, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_RESET_INT, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, TXPROGDIV_RESET_INT, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, PMA_RESET_INT, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, PCS_RESET_INT, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, UB_REPROG_REQUEST_INT, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_INT, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_INT, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_IN_PROGRESS_INT, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_PLL_RESET, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT_R, 8, 4)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_8B10B_TO_128B130B, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_128B130B_TO_8B10B, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_ESM, 1, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_128B130B, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_PIPE_RATE0, 0x2414)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_RX, 24, 8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_RX, 16, 8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_TX, 8, 8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_TX, 0, 8)
REG32(CH1_COESTATUS_CHANNEL_PIPE_RATE1, 0x2418)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, TXDAPI_RESET_INT, 31, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, RPLL_LOCK_R, 30, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, LCPLL_LOCK_R, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, TXPROGDIV_RESET_DONE_R, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, TX_PMA_RESETDONE_R, 27, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, RX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, TXRESET_DONE_R, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, RXRESET_DONE_R, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, TXSYNC_DONE_R, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, RXSYNC_DONE_R, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, TXRATE_R, 14, 8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, RXRATE_R, 6, 8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, UB_REPROG_DONE_R, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RATE1, FSM_RATE, 0, 5)
REG32(CH1_COESTATUS_TXUSRCLK_FREQ_CNT, 0x241c)
    FIELD(CH1_COESTATUS_TXUSRCLK_FREQ_CNT, TXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH1_COESTATUS_TXPHYCLK_FREQ_CNT, 0x2420)
    FIELD(CH1_COESTATUS_TXPHYCLK_FREQ_CNT, TXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH1_COESTATUS_TXPCSCLK_FREQ_CNT, 0x2424)
    FIELD(CH1_COESTATUS_TXPCSCLK_FREQ_CNT, TXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH1_COESTATUS_RXUSRCLK_FREQ_CNT, 0x2428)
    FIELD(CH1_COESTATUS_RXUSRCLK_FREQ_CNT, RXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH1_COESTATUS_RXPHYCLK_FREQ_CNT, 0x242c)
    FIELD(CH1_COESTATUS_RXPHYCLK_FREQ_CNT, RXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH1_COESTATUS_RXPCSCLK_FREQ_CNT, 0x2430)
    FIELD(CH1_COESTATUS_RXPCSCLK_FREQ_CNT, RXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH1_COESTATUS_CRC_TX, 0x2434)
REG32(CH1_COESTATUS_CRC_RX, 0x2438)
REG32(CH1_TXCHICO_DBG_SIG_00, 0x2440)
    FIELD(CH1_TXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_00, TXPCSDAPICLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_01, 0x2444)
    FIELD(CH1_TXCHICO_DBG_SIG_01, CLK4TXPI, 8, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_01, TXPICODE, 1, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_01, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_02, 0x2448)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ_SYNC, 28, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS_SYNC, 27, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ_SYNC, 26, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ_SYNC, 25, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE_SYNC, 24, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE_SYNC, 23, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH1_TXCHICO_DBG_SIG_02, TX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH1_TXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH1_TXCHICO_DBG_SIG_02, TXDAPICLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_03, 0x244c)
    FIELD(CH1_TXCHICO_DBG_SIG_03, TXPI_TOP_IN, 13, 4)
    FIELD(CH1_TXCHICO_DBG_SIG_03, TXPI_BOT_IN, 9, 4)
    FIELD(CH1_TXCHICO_DBG_SIG_03, TXPO_TOP_OUT, 5, 4)
    FIELD(CH1_TXCHICO_DBG_SIG_03, TXPO_BOT_OUT, 1, 4)
REG32(CH1_TXCHICO_DBG_SIG_04, 0x2450)
    FIELD(CH1_TXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH1_TXCHICO_DBG_SIG_05, 0x2454)
    FIELD(CH1_TXCHICO_DBG_SIG_05, TXPI_SETINIT_PH_CNT, 22, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_05, TXPI_MAX_SAMPLE_THRESHOLD, 15, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_05, TXPI_MIN_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_05, TXPI_NUM_SAMPLES, 1, 7)
REG32(CH1_TXCHICO_DBG_SIG_06, 0x2458)
    FIELD(CH1_TXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH1_TXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH1_TXCHICO_DBG_SIG_07, 0x245c)
    FIELD(CH1_TXCHICO_DBG_SIG_07, TX_WID_RATIO, 13, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, TX_CHICO_EN, 10, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH1_TXCHICO_DBG_SIG_08, 0x2460)
    FIELD(CH1_TXCHICO_DBG_SIG_08, TXPI_DIV, 11, 11)
    FIELD(CH1_TXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH1_TXCHICO_DBG_SIG_09, 0x2464)
    FIELD(CH1_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_09, TX_PHASE_SHIFT180_REQ, 19, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH1_TXCHICO_DBG_SIG_09, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_10, 0x2468)
    FIELD(CH1_TXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH1_TXCHICO_DBG_SIG_10, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_11, 0x246c)
    FIELD(CH1_TXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH1_TXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_11, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_12, 0x2470)
    FIELD(CH1_TXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_12, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_13, 0x2474)
    FIELD(CH1_TXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH1_TXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH1_TXCHICO_DBG_SIG_13, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_14, 0x2478)
    FIELD(CH1_TXCHICO_DBG_SIG_14, DBG_TXPI_P_STATE, 15, 5)
    FIELD(CH1_TXCHICO_DBG_SIG_14, DBG_TXPI_LAST_SAMPLE_ACC, 7, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_14, DBG_TXPI_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_14, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_15, 0x247c)
    FIELD(CH1_TXCHICO_DBG_SIG_15, DBG_TXPI_INC_PH_CNT, 13, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_15, DBG_TXPI_DEC_PH_CNT, 7, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_15, DBG_TXPI_HOLD_PH_CNT, 1, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_15, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_16, 0x2480)
    FIELD(CH1_TXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_16, MLDLY_BEACON_2, 1, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_16, TXUSRCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_17, 0x2484)
    FIELD(CH1_TXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH1_TXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH1_TXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH1_TXCHICO_DBG_SIG_17, TXDAPICLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_18, 0x2488)
    FIELD(CH1_TXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH1_TXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH1_TXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH1_TXCHICO_DBG_SIG_18, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_19, 0x248c)
    FIELD(CH1_TXCHICO_DBG_SIG_19, DBG_TXPI_STATE, 21, 4)
    FIELD(CH1_TXCHICO_DBG_SIG_19, DBG_TXPI_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH1_TXCHICO_DBG_SIG_19, DBG_TXPI_BEACON_XOR, 1, 2)
    FIELD(CH1_TXCHICO_DBG_SIG_19, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_20, 0x2490)
    FIELD(CH1_TXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH1_TXCHICO_DBG_SIG_20, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_21, 0x2494)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_CHICO_OUT_RSVD, 8, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_SYNC_DONE, 3, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH1_TXCHICO_DBG_SIG_22, 0x2498)
    FIELD(CH1_TXCHICO_DBG_SIG_22, MC_TXPICODE_DDR_EN, 9, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_22, TXPICODE_DDR, 1, 8)
    FIELD(CH1_TXCHICO_DBG_SIG_22, TXPCSCLK_INT, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_23, 0x249c)
    FIELD(CH1_TXCHICO_DBG_SIG_23, DBG_VIR_DIFF, 0, 12)
REG32(CH1_TXCHICO_DBG_SIG_24, 0x24a0)
    FIELD(CH1_TXCHICO_DBG_SIG_24, BEACON_128B130B, 3, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_24, TXPCSCLK_INT_DLY_128B130B, 2, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_24, BEACON_DLY_PCSCLK_128B130B, 1, 1)
    FIELD(CH1_TXCHICO_DBG_SIG_24, RST_BEACON_PCSCLK_DLY_INT_B_128B130B, 0, 1)
REG32(CH1_TXCHICO_DBG_SIG_25, 0x24a4)
REG32(CH1_TXCHICO_DBG_SIG_26, 0x24a8)
REG32(CH1_TXCHICO_DBG_SIG_27, 0x24ac)
REG32(CH1_TXCHICO_DBG_SIG_28, 0x24b0)
REG32(CH1_TXCHICO_DBG_SIG_29, 0x24b4)
REG32(CH1_TXCHICO_DBG_SIG_30, 0x24b8)
REG32(CH1_TXCHICO_DBG_SIG_31, 0x24bc)
REG32(CH1_RXCHICO_DBG_SIG_00, 0x24c0)
    FIELD(CH1_RXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH1_RXCHICO_DBG_SIG_00, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_01, 0x24c4)
REG32(CH1_RXCHICO_DBG_SIG_02, 0x24c8)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ, 28, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS, 27, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ, 26, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ, 25, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE, 24, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE, 23, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH1_RXCHICO_DBG_SIG_02, RX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH1_RXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH1_RXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH1_RXCHICO_DBG_SIG_02, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_03, 0x24cc)
    FIELD(CH1_RXCHICO_DBG_SIG_03, RXPI_TOP_IN, 13, 4)
    FIELD(CH1_RXCHICO_DBG_SIG_03, RXPI_BOT_IN, 9, 4)
    FIELD(CH1_RXCHICO_DBG_SIG_03, RXPO_TOP_OUT, 5, 4)
    FIELD(CH1_RXCHICO_DBG_SIG_03, RXPO_BOT_OUT, 1, 4)
REG32(CH1_RXCHICO_DBG_SIG_04, 0x24d0)
    FIELD(CH1_RXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH1_RXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH1_RXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH1_RXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH1_RXCHICO_DBG_SIG_05, 0x24d4)
REG32(CH1_RXCHICO_DBG_SIG_06, 0x24d8)
    FIELD(CH1_RXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH1_RXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH1_RXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH1_RXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH1_RXCHICO_DBG_SIG_07, 0x24dc)
    FIELD(CH1_RXCHICO_DBG_SIG_07, RX_WID_RATIO, 13, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, RX_CHICO_EN, 10, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH1_RXCHICO_DBG_SIG_08, 0x24e0)
    FIELD(CH1_RXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH1_RXCHICO_DBG_SIG_09, 0x24e4)
    FIELD(CH1_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_DONE, 19, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_REQ, 18, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH1_RXCHICO_DBG_SIG_09, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_10, 0x24e8)
    FIELD(CH1_RXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH1_RXCHICO_DBG_SIG_10, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_11, 0x24ec)
    FIELD(CH1_RXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH1_RXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH1_RXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH1_RXCHICO_DBG_SIG_11, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_12, 0x24f0)
    FIELD(CH1_RXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH1_RXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH1_RXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH1_RXCHICO_DBG_SIG_12, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_13, 0x24f4)
    FIELD(CH1_RXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH1_RXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH1_RXCHICO_DBG_SIG_13, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_14, 0x24f8)
REG32(CH1_RXCHICO_DBG_SIG_15, 0x24fc)
REG32(CH1_RXCHICO_DBG_SIG_16, 0x2500)
    FIELD(CH1_RXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_16, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_17, 0x2504)
    FIELD(CH1_RXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH1_RXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH1_RXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH1_RXCHICO_DBG_SIG_17, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_18, 0x2508)
    FIELD(CH1_RXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH1_RXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH1_RXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH1_RXCHICO_DBG_SIG_18, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_19, 0x250c)
REG32(CH1_RXCHICO_DBG_SIG_20, 0x2510)
    FIELD(CH1_RXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH1_RXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH1_RXCHICO_DBG_SIG_20, RXUSRCLK_INT, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_21, 0x2514)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_FINE_ALIGN_DONE, 8, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_SYNC_DONE, 3, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH1_RXCHICO_DBG_SIG_22, 0x2518)
    FIELD(CH1_RXCHICO_DBG_SIG_22, DBG_VIR_DIFF, 0, 12)
REG32(CH1_RXCHICO_DBG_SIG_23, 0x251c)
    FIELD(CH1_RXCHICO_DBG_SIG_23, BEACON_128B130B, 3, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_23, RST_BEACON_USRCLK_DLY_INT_B_128B130B, 2, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_23, RXUSRCLK_INT_DLY_128B130B, 1, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_23, BEACON_DLY_USRCLK_128B130B, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_24, 0x2520)
    FIELD(CH1_RXCHICO_DBG_SIG_24, CLK_SLIP_ERR, 8, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, CDR_SLIP_REQ, 7, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, CDR_SLIP_DIR, 6, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_DONE, 5, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_REQ, 4, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, CDR_SLIP_READY, 3, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, BEACON_OUT, 2, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, POLARITY_SL, 1, 1)
    FIELD(CH1_RXCHICO_DBG_SIG_24, POLARITY_IM, 0, 1)
REG32(CH1_RXCHICO_DBG_SIG_25, 0x2524)
REG32(CH1_RXCHICO_DBG_SIG_26, 0x2528)
REG32(CH1_RXCHICO_DBG_SIG_27, 0x252c)
REG32(CH1_RXCHICO_DBG_SIG_28, 0x2530)
REG32(CH1_RXCHICO_DBG_SIG_29, 0x2534)
REG32(CH1_RXCHICO_DBG_SIG_30, 0x2538)
REG32(CH1_RXCHICO_DBG_SIG_31, 0x253c)
REG32(CH1_COE_STATUS_EYESCAN_0, 0x2540)
REG32(CH1_COE_STATUS_EYESCAN_1, 0x2544)
REG32(CH1_COE_STATUS_EYESCAN_2, 0x2548)
REG32(CH1_COE_STATUS_EYESCAN_3, 0x254c)
REG32(CH1_COE_STATUS_EYESCAN_4, 0x2550)
REG32(CH1_COE_STATUS_EYESCAN_5, 0x2554)
REG32(CH1_COE_STATUS_EYESCAN_6, 0x2558)
REG32(CH1_COE_STATUS_EYESCAN_7, 0x255c)
REG32(CH1_COE_STATUS_EYESCAN_8, 0x2560)
REG32(CH1_COE_STATUS_EYESCAN_9, 0x2564)
REG32(CH1_COE_STATUS_EYESCAN_10, 0x2568)
    FIELD(CH1_COE_STATUS_EYESCAN_10, COE_STATUS_ES_SAMPLE_COUNT, 16, 16)
    FIELD(CH1_COE_STATUS_EYESCAN_10, COE_STATUS_ES_ERROR_COUNT, 0, 16)
REG32(CH1_COE_STATUS_EYESCAN_11, 0x256c)
    FIELD(CH1_COE_STATUS_EYESCAN_11, COE_STATUS_ES_CONTROL_STATUS, 0, 4)
REG32(CH1_COE_STATUS_PRBSERR_CNT_0, 0x2570)
REG32(CH1_COE_STATUS_PRBSERR_CNT_1, 0x2574)
REG32(CH1_COE_STATUS_RX_CYCLECNT_0, 0x2578)
REG32(CH1_COE_STATUS_RX_CYCLECNT_1, 0x257c)
REG32(CH1_COE_STATUS_PRBS_LINK2RESEED_CNT, 0x2580)
    FIELD(CH1_COE_STATUS_PRBS_LINK2RESEED_CNT, RX_PRBS_LINK2RESEED_CNT, 0, 16)
REG32(CH1_COE_STATUS_TXGBOX_0, 0x2584)
    FIELD(CH1_COE_STATUS_TXGBOX_0, TXFIFO_UNDERFLOW, 25, 1)
    FIELD(CH1_COE_STATUS_TXGBOX_0, TXFIFO_OVERFLOW, 24, 1)
    FIELD(CH1_COE_STATUS_TXGBOX_0, TXFIFO_STATUS, 20, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH1_COE_STATUS_TXGBOX_1, 0x2588)
    FIELD(CH1_COE_STATUS_TXGBOX_1, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_1, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_1, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH1_COE_STATUS_TXGBOX_2, 0x258c)
    FIELD(CH1_COE_STATUS_TXGBOX_2, TXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH1_COE_STATUS_TXGBOX_2, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH1_COE_STATUS_TXGBOX_2, WR_ADDR_SYNC, 3, 3)
    FIELD(CH1_COE_STATUS_TXGBOX_2, RD_ADDR_SYNC, 0, 3)
REG32(CH1_COE_STATUS_TX64B66B_0, 0x2590)
    FIELD(CH1_COE_STATUS_TX64B66B_0, TX_16B_64B_ENC_EN, 30, 1)
    FIELD(CH1_COE_STATUS_TX64B66B_0, TXCTRL_CRC_DATAPACK_START, 29, 1)
    FIELD(CH1_COE_STATUS_TX64B66B_0, TXCTRL_XGMII_OR_CRC_INIT, 28, 1)
    FIELD(CH1_COE_STATUS_TX64B66B_0, TX_16B64B_DATAPAC_TRIG, 27, 1)
    FIELD(CH1_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_64B, 19, 8)
    FIELD(CH1_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_64B, 17, 2)
    FIELD(CH1_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_32B, 9, 8)
    FIELD(CH1_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_32B, 7, 2)
    FIELD(CH1_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_64B, 4, 3)
    FIELD(CH1_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_32B, 1, 3)
    FIELD(CH1_COE_STATUS_TX64B66B_0, STAT_TX_LOCAL_FAULT, 0, 1)
REG32(CH1_COE_STATUS_TX64B66B_1, 0x2594)
REG32(CH1_COE_STATUS_RX64B66B_0, 0x2598)
    FIELD(CH1_COE_STATUS_RX64B66B_0, BLOCK_LOCK, 23, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, COE_RX_TP_CNT, 13, 10)
    FIELD(CH1_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_32B, 10, 3)
    FIELD(CH1_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_64B, 7, 3)
    FIELD(CH1_COE_STATUS_RX64B66B_0, DECODER_IN_IS_BADLYFRAMED, 6, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, STAT_RX_HI_BER, 5, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, STAT_RX_BAD_CODE, 4, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, STAT_RX_TEST_PATTERN_MISMATCH, 3, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, STAT_RX_LOCAL_FAULT, 2, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, DESCRAMBLER2DECODER_IS_BADLYFRAMED, 1, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_0, STAT_RX_VALID_CTRL_CODE, 0, 1)
REG32(CH1_COE_STATUS_RX64B66B_1, 0x259c)
REG32(CH1_COE_STATUS_RX64B66B_2, 0x25a0)
    FIELD(CH1_COE_STATUS_RX64B66B_2, RXOUT_FIFO_16B_UNPACK_EN, 1, 1)
    FIELD(CH1_COE_STATUS_RX64B66B_2, STAT_RX_FIFO_ERROR, 0, 1)
REG32(CH1_COE_STATUS_RXGBOX_FIFO_0, 0x25a4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_11_REG, 24, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH1_COE_STATUS_RXGBOX_FIFO_1, 0x25a8)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_1, RXFIFO_STATUS, 0, 8)
REG32(CH1_COE_STATUS_RXGBOX_FIFO_2, 0x25ac)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_10_REG, 24, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_0_WR_CLK, 16, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH1_COE_STATUS_RXGBOX_FIFO_3, 0x25b0)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_1, 15, 1)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_B, 8, 7)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_0, 7, 1)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_A, 0, 7)
REG32(CH1_COE_STATUS_RXGBOX_FIFO_4, 0x25b4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_OVERFLOW, 31, 1)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_UNDERFLOW, 30, 1)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, RXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, DELAY_RXDATA, 10, 2)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, WR_ADDR_SYNC, 3, 3)
    FIELD(CH1_COE_STATUS_RXGBOX_FIFO_4, RD_ADDR_SYNC, 0, 3)
REG32(CH1_COE_STATUS_8B10BEB_RESET_0, 0x25b8)
REG32(CH1_COE_STATUS_8B10BEB_RESET_1, 0x25bc)
REG32(CH1_COESTATUS_PMA_0, 0x25c0)
    FIELD(CH1_COESTATUS_PMA_0, RX_PKDET_AS, 23, 1)
    FIELD(CH1_COESTATUS_PMA_0, TXSWING_OUT_LOW_AS, 22, 1)
    FIELD(CH1_COESTATUS_PMA_0, TXSWING_OUT_HIGH_AS, 21, 1)
    FIELD(CH1_COESTATUS_PMA_0, TX_QPISENN_AS, 19, 1)
    FIELD(CH1_COESTATUS_PMA_0, TX_DCC_READY_AS, 18, 1)
    FIELD(CH1_COESTATUS_PMA_0, RX_QPISENP_AS, 17, 1)
    FIELD(CH1_COESTATUS_PMA_0, RX_QPISENN_AS, 16, 1)
    FIELD(CH1_COESTATUS_PMA_0, RX_DXDS_CALDONE_AS, 11, 1)
    FIELD(CH1_COESTATUS_PMA_0, CDR_SLIP_RDY_AS, 10, 1)
    FIELD(CH1_COESTATUS_PMA_0, CDR_SRSTSTATUS_AS, 9, 1)
    FIELD(CH1_COESTATUS_PMA_0, CDR_WALKDONE_AS, 8, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_LOSSDATA_AS, 7, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_LCKSTATUS_AS, 6, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_CALENDAC_AS, 5, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_OVWRRDY1_AS, 4, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_OVWRRDY0_AS, 3, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_CDRLOCK_AS, 2, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_CALTIMEOUT_AS, 1, 1)
    FIELD(CH1_COESTATUS_PMA_0, ADAPT_CALDONE_AS, 0, 1)
REG32(CH1_COE_STATUS_PLL_STATUS, 0x25c4)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_RSTB_INT, 18, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_REFDIVRSTB_INT, 17, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_RESET_LOOP_DONE, 15, 2)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_PWRDN_B, 14, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_RST_ERR, 13, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_REFLOSS, 12, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_FBLOSS, 11, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_UNLOCK, 10, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_CRSCODE, 3, 7)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_FINE_EN, 2, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_VCO_SEL, 1, 1)
    FIELD(CH1_COE_STATUS_PLL_STATUS, PLL_FREQLOCK, 0, 1)
REG32(CH1_COESTATUS_PMA_1, 0x25c8)
    FIELD(CH1_COESTATUS_PMA_1, ILO_MODE_TUNE_AS, 13, 2)
    FIELD(CH1_COESTATUS_PMA_1, ILO_CLK_LOST_AS, 12, 1)
    FIELD(CH1_COESTATUS_PMA_1, ILO_FBCLK_LOST_AS, 11, 1)
    FIELD(CH1_COESTATUS_PMA_1, ILO_FINE_EN_AS, 10, 1)
    FIELD(CH1_COESTATUS_PMA_1, ILO_FTL_TUNE_AS, 2, 8)
    FIELD(CH1_COESTATUS_PMA_1, UNLOCK_ILO_AS, 1, 1)
    FIELD(CH1_COESTATUS_PMA_1, ILO_LOCK_AS, 0, 1)
REG32(CH1_COESTATUS_RX_FABRIC_INTF0, 0x25cc)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXSTARTOFSEQ, 17, 2)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXVALID, 16, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, COMWAKE, 15, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, COMSAS, 14, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, COMINIT, 13, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXCLKCORCNT, 11, 2)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXBUFSTATUS, 8, 3)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXCHANREALIGN, 7, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXCHANISALIGNED, 6, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXCHANBONDSEQ, 5, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF0, RXCHBONDO, 0, 5)
REG32(CH1_COESTATUS_RX_FABRIC_INTF1, 0x25d0)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF1, RXSLIPDONE, 4, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF1, RXSLIDERDY, 3, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF1, RXCOMMADET, 2, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF1, RXBYTEREALIGN, 1, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF1, RXBYTEISALIGNED, 0, 1)
REG32(CH1_COESTATUS_RX_FABRIC_INTF2, 0x25d4)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF2, DMON_FIFO_STATUS, 3, 2)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF2, EYESCANDATAERROR, 2, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF2, RXPRBSLOCKED, 1, 1)
    FIELD(CH1_COESTATUS_RX_FABRIC_INTF2, RXPRBSERR, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_PIPE_RESET, 0x25d8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, ILO_LOCK_R, 31, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, GT_POWERGOOD_R, 30, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RPLL_LOCK_R, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_LOCK_R, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_DONE_R, 27, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RX_PMA_RESETDONE_R, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TXRESET_DONE_R, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RXRESET_DONE_R, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_DONE_R, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_DONE_R, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, PHYSTATUS_R, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RPLL_PD_INT_DLY, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RPLL_RESET_INT_DLY, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_PD_INT_DLY, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_RESET_INT_DLY, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_INT_DLY, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, PMA_RESET_INT_DLY, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, PCS_RESET_INT_DLY, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, USER_RDY_INT_DLY, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_INT, 11, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_INT, 10, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, PHY_READY_INT, 9, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, BUFGT_PHY_READY, 8, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RESET, FSM_PIPE_RST_CTRL, 0, 4)
REG32(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, 0x25dc)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_SYNC, 31, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_INT, 30, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_R, 28, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_DELAY, 24, 4)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_SYNC, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_SYNC, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RX_CDR_ALIGN_DONE_SYNC, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_R, 19, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_R, 17, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_IN_PROGRESS_R, 15, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_ENTER, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_ENTER, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_EXIT, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_EXIT, 11, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SRIS_MODE, 10, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, COMMON_REF_MODE, 9, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, FSM_CDR_CTRL, 6, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRFREQRESET, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDR_ALGN_REQ, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_DET, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_RATE, 1, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD_IN, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, 0x25e0)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE_FROM_TO_ESM, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK_R, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_SEL_INT, 25, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, FSM_BUFG, 22, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CTRL_IN_PROGRESS, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_RESET_INT, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CE_INT, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_RESET_MASK_INT, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_CE_MASK_INT, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_RESET_MASK_INT, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_CE_MASK_INT, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_INT, 12, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFGT_RATE, 9, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK, 8, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE, 7, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, PHY_READY, 6, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER, 1, 5)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER_DONE, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_PIPE_PD, 0x25e4)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RXNEW_PD, 30, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RXCURRENT_PD, 28, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TXNEW_PD, 26, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TXCURRENT_PD, 24, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, BEACON, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, PWRUPTX, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, PWRUPTXDRV, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, PWRUPRX, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, PWRUPDET, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RPLL_PD_SA, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, LCPLL_PD_SA, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TXPMA_PWRDN_B_SA, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TXDRVPWRDN_B_SA, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RX_PDB_SA, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, OOB_PDB_SA, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TXSERPWRDN_B_SA, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RXCKMUXPWRDN_B_SA, 11, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TXCKMUXPWRDN_B_SA, 10, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TX_VREG_PDB_SA, 9, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RX_VREG_PDB_SA, 8, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TX_P_CHANGE, 7, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RX_P_CHANGE, 6, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN_PULSE, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, CLR_PHYSTATUS, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, SET_PHYSTATUS, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, TX_P2_CHANGE, 1, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_PD, RX_P2_CHANGE, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, 0x25e8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_BYPASS, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_AS, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_AS, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SA_REG, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETPOLL_SA_REG, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_EN_SA_REG, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_D, 17, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART01, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ZERO, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ONE, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ZERO, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ONE, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_DONE, 11, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SYNC, 10, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER, 7, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVREF_EN, 6, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_SYNC, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_SYNC, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_DELAY, 0, 4)
REG32(CH1_COESTATUS_CHANNEL_PIPE_STAT, 0x25ec)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_128B130B, 29, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_8B10B, 26, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RCVABSENT_SYNC, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RCVPRESENT_SYNC, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RST_PERIOD_SYNC, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RATE_SYNC, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_1, 19, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_0, 16, 3)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_UNDERFLOW_8B10B, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_OVERFLOW_8B10B, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXNOTINTABLE_8B10B, 12, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXDISPERR_8B10B, 10, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXCLKCORCNT_EARLY_8B10B, 8, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, ENB_NOTINTABLE, 6, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, ENB_DISPERR, 4, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RCVDET, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_PWRDWN, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS, 1, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_STAT, RXRATEDONE, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_TX_EQ, 0x25f0)
    FIELD(CH1_COESTATUS_CHANNEL_TX_EQ, TXDRVBIASP_SA, 21, 5)
    FIELD(CH1_COESTATUS_CHANNEL_TX_EQ, TXEMPPRE_SA, 16, 5)
    FIELD(CH1_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_SA, 9, 7)
    FIELD(CH1_COESTATUS_CHANNEL_TX_EQ, TXEMPPOS_SA, 4, 5)
    FIELD(CH1_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_INDEP_SA, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_EQ, TXPDRVAMP_SA, 0, 3)
REG32(CH1_COESTATUS_CHANNEL_TX_ELEC, 0x25f4)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_PCIE_SATA, 31, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_USB3, 30, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXCOMINIT_TXPHYCLK, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, P0_LOOPBACK_PERIOD, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXCOMSAS_TXPHYCLK, 27, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXCOMWAKE_TXPHYCLK, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, COMSTART_TXPHYCLK, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_PCIE_USB3, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_DELAY, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_SEL, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, P0_DATA_PERIOD, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, P0_LFPS_PERIOD, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, P0_TRISTATE_PERIOD, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, USB3_P23_RXDETECTION_PERIOD, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_TRISTATE_PERIOD, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_LFPS_PERIOD, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, USB3_TRISTATE_PERIOD, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_INT, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, SATA_WORDCOUNT, 10, 3)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, USB3_LFPS_PERIOD, 9, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TXELEC_LFPS, 8, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, TX_OOB_SIGSEL, 6, 2)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, PCIE_RXLOOPBACK, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, RCVDETSTART, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, COMSTATE, 2, 2)
    FIELD(CH1_COESTATUS_CHANNEL_TX_ELEC, COMTYPE, 0, 2)
REG32(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, 0x25f8)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_ILO_RESET, 29, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_RXELECIDLE, 28, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_INT, 27, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_OOBSIGVAL_AS, 26, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PMA_RESET, 25, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PMA_RESET, 24, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PCS_RESET, 23, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PCS_RESET, 22, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXPROGDIV_RESET, 21, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_TXPROGDIV_RESET, 20, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHY_READY, 19, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RATE_CHANGE_IN_PROGRESS, 18, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXSYNC_RESET, 17, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RXSYNC_RESET, 16, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_RPLL_RESET, 15, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RPLL_RESET, 14, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_LCPLL_RESET, 13, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_LCPLL_RESET, 12, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PROGDIVRESET_DONE, 11, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PMA_RESETDONE, 10, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_PMA_RESETDONE, 9, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_RESETDONE, 8, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_RESETDONE, 7, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_LOCK, 5, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_RESETDONE, 4, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, LCPLL_RESETDONE, 3, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHYSTATUS_INT, 2, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TXSYNC_DONE, 1, 1)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RXSYNC_DONE, 0, 1)
REG32(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, 0x25fc)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE, 30, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE_CP7, 28, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, FE_PMA_LPBK_FIFO_STATUS, 26, 2)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_IN, 12, 4)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_IN, 8, 4)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_OUT, 4, 4)
    FIELD(CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_OUT, 0, 4)
REG32(CH1_COESTATUS_ADAPT_LOOP_00, 0x2680)
REG32(CH1_COESTATUS_ADAPT_LOOP_01, 0x2684)
REG32(CH1_COESTATUS_ADAPT_LOOP_02, 0x2688)
REG32(CH1_COESTATUS_ADAPT_LOOP_03, 0x268c)
REG32(CH1_COESTATUS_ADAPT_LOOP_04, 0x2690)
REG32(CH1_COESTATUS_ADAPT_LOOP_05, 0x2694)
REG32(CH1_COESTATUS_ADAPT_LOOP_06, 0x2698)
REG32(CH1_COESTATUS_ADAPT_LOOP_07, 0x269c)
REG32(CH1_COESTATUS_ADAPT_LOOP_08, 0x26a0)
REG32(CH1_COESTATUS_ADAPT_LOOP_09, 0x26a4)
REG32(CH1_COESTATUS_ADAPT_LOOP_10, 0x26a8)
REG32(CH1_COESTATUS_ADAPT_LOOP_11, 0x26ac)
REG32(CH2_COESTATUS_CHANNEL_RESET0, 0x2800)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, CDRSRESET_ENABLE, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, DES_RST_SYNC_EN, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPIDIV, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPIDIV, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_ILO, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPI, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPI, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_PHDLY, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_PHDLY, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_PRBSCNT, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_OOB, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_ISCAN, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_BUF, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_PCS, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_DFE, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRFR, 11, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRPH, 10, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_PMA, 9, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_CLKGEN, 8, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_CKOK, 7, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_CFOK, 6, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_PCS, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_PMA, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_CLKGEN, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_CKCAL, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_RX_PROGDIV, 1, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET0, RESETB_TX_PROGDIV, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_RESET1, 0x2804)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, RESET_EXCEPTION, 31, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, ILO_LOOP_ERR, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, RX_CHICO_RESET_ERR, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, TX_CHICO_RESET_ERR, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, RX_PROGDDIV_RESET_ERR, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, TX_PROGDDIV_RESET_ERR, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, RX_DAPI_RESET_ERR, 18, 2)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, TX_DAPI_RESET_ERR, 16, 2)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, RX_PCS_LOOP_ERR, 11, 5)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, RX_PMA_LOOP_ERR, 4, 7)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, TX_PCS_LOOP_ERR, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET1, TX_PMA_LOOP_ERR, 0, 3)
REG32(CH2_COESTATUS_CHANNEL_RESET2, 0x2808)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, ILO_RESETDONE, 30, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_RESETDONE, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_RESETDONE, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_PMA_RESETDONE, 27, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_PMA_RESETDONE, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_DAPIRESET_DONE, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_DAPIRESET_DONE, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_CHICORESET_DONE, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_CHICORESET_DONE, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_PROGDIVRESET_DONE, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_PROGDIVRESET_DONE, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_DAPI_LOOP_DONE, 18, 2)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_DAPI_LOOP_DONE, 16, 2)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_PCS_LOOP_DONE, 11, 5)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, RX_PMA_LOOP_DONE, 4, 7)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_PCS_LOOP_DONE, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_RESET2, TX_PMA_LOOP_DONE, 0, 3)
REG32(CH2_COESTATUS_CHANNEL_PIPE_RATE3, 0x280c)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_CHANGE_FROM_TO_ESM, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_ESM_DAPIRST_DONE, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_REQUEST_INT, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, RX_ADAPT_IN_PROGRESS_INT, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_DONE_R, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LTSSM_STATE_INT_R, 7, 6)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LINK_REACH_TARGET_INT_R, 6, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, PHY_ESM_ADAPTATION_SAVE_R, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_DONE_RXRATE, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_REQUEST_RXRATE_INT, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, RXRATE_CHANGE_IN_PROGRESS_INT, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE3, FSM_RX_RATE, 0, 2)
REG32(CH2_COESTATUS_CHANNEL_PIPE_RATE2, 0x2810)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, TXRX_128B130B_EN_INT, 31, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT, 30, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_PD_INT, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_RESET_INT, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_LOCK_INT, 27, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_PD_INT, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_RESET_INT, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_PD_INT, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_RESET_INT, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_LOCK_INT, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_PD_INT, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_RESET_INT, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, TXPROGDIV_RESET_INT, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, PMA_RESET_INT, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, PCS_RESET_INT, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, UB_REPROG_REQUEST_INT, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_INT, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_INT, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_IN_PROGRESS_INT, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_PLL_RESET, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT_R, 8, 4)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_8B10B_TO_128B130B, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_128B130B_TO_8B10B, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_ESM, 1, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_128B130B, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_PIPE_RATE0, 0x2814)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_RX, 24, 8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_RX, 16, 8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_TX, 8, 8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_TX, 0, 8)
REG32(CH2_COESTATUS_CHANNEL_PIPE_RATE1, 0x2818)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, TXDAPI_RESET_INT, 31, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, RPLL_LOCK_R, 30, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, LCPLL_LOCK_R, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, TXPROGDIV_RESET_DONE_R, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, TX_PMA_RESETDONE_R, 27, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, RX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, TXRESET_DONE_R, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, RXRESET_DONE_R, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, TXSYNC_DONE_R, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, RXSYNC_DONE_R, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, TXRATE_R, 14, 8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, RXRATE_R, 6, 8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, UB_REPROG_DONE_R, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RATE1, FSM_RATE, 0, 5)
REG32(CH2_COESTATUS_TXUSRCLK_FREQ_CNT, 0x281c)
    FIELD(CH2_COESTATUS_TXUSRCLK_FREQ_CNT, TXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH2_COESTATUS_TXPHYCLK_FREQ_CNT, 0x2820)
    FIELD(CH2_COESTATUS_TXPHYCLK_FREQ_CNT, TXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH2_COESTATUS_TXPCSCLK_FREQ_CNT, 0x2824)
    FIELD(CH2_COESTATUS_TXPCSCLK_FREQ_CNT, TXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH2_COESTATUS_RXUSRCLK_FREQ_CNT, 0x2828)
    FIELD(CH2_COESTATUS_RXUSRCLK_FREQ_CNT, RXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH2_COESTATUS_RXPHYCLK_FREQ_CNT, 0x282c)
    FIELD(CH2_COESTATUS_RXPHYCLK_FREQ_CNT, RXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH2_COESTATUS_RXPCSCLK_FREQ_CNT, 0x2830)
    FIELD(CH2_COESTATUS_RXPCSCLK_FREQ_CNT, RXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH2_COESTATUS_CRC_TX, 0x2834)
REG32(CH2_COESTATUS_CRC_RX, 0x2838)
REG32(CH2_TXCHICO_DBG_SIG_00, 0x2840)
    FIELD(CH2_TXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_00, TXPCSDAPICLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_01, 0x2844)
    FIELD(CH2_TXCHICO_DBG_SIG_01, CLK4TXPI, 8, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_01, TXPICODE, 1, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_01, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_02, 0x2848)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ_SYNC, 28, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS_SYNC, 27, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ_SYNC, 26, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ_SYNC, 25, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE_SYNC, 24, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE_SYNC, 23, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH2_TXCHICO_DBG_SIG_02, TX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH2_TXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH2_TXCHICO_DBG_SIG_02, TXDAPICLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_03, 0x284c)
    FIELD(CH2_TXCHICO_DBG_SIG_03, TXPI_TOP_IN, 13, 4)
    FIELD(CH2_TXCHICO_DBG_SIG_03, TXPI_BOT_IN, 9, 4)
    FIELD(CH2_TXCHICO_DBG_SIG_03, TXPO_TOP_OUT, 5, 4)
    FIELD(CH2_TXCHICO_DBG_SIG_03, TXPO_BOT_OUT, 1, 4)
REG32(CH2_TXCHICO_DBG_SIG_04, 0x2850)
    FIELD(CH2_TXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH2_TXCHICO_DBG_SIG_05, 0x2854)
    FIELD(CH2_TXCHICO_DBG_SIG_05, TXPI_SETINIT_PH_CNT, 22, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_05, TXPI_MAX_SAMPLE_THRESHOLD, 15, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_05, TXPI_MIN_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_05, TXPI_NUM_SAMPLES, 1, 7)
REG32(CH2_TXCHICO_DBG_SIG_06, 0x2858)
    FIELD(CH2_TXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH2_TXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH2_TXCHICO_DBG_SIG_07, 0x285c)
    FIELD(CH2_TXCHICO_DBG_SIG_07, TX_WID_RATIO, 13, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, TX_CHICO_EN, 10, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH2_TXCHICO_DBG_SIG_08, 0x2860)
    FIELD(CH2_TXCHICO_DBG_SIG_08, TXPI_DIV, 11, 11)
    FIELD(CH2_TXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH2_TXCHICO_DBG_SIG_09, 0x2864)
    FIELD(CH2_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_09, TX_PHASE_SHIFT180_REQ, 19, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH2_TXCHICO_DBG_SIG_09, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_10, 0x2868)
    FIELD(CH2_TXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH2_TXCHICO_DBG_SIG_10, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_11, 0x286c)
    FIELD(CH2_TXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH2_TXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_11, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_12, 0x2870)
    FIELD(CH2_TXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_12, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_13, 0x2874)
    FIELD(CH2_TXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH2_TXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH2_TXCHICO_DBG_SIG_13, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_14, 0x2878)
    FIELD(CH2_TXCHICO_DBG_SIG_14, DBG_TXPI_P_STATE, 15, 5)
    FIELD(CH2_TXCHICO_DBG_SIG_14, DBG_TXPI_LAST_SAMPLE_ACC, 7, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_14, DBG_TXPI_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_14, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_15, 0x287c)
    FIELD(CH2_TXCHICO_DBG_SIG_15, DBG_TXPI_INC_PH_CNT, 13, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_15, DBG_TXPI_DEC_PH_CNT, 7, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_15, DBG_TXPI_HOLD_PH_CNT, 1, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_15, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_16, 0x2880)
    FIELD(CH2_TXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_16, MLDLY_BEACON_2, 1, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_16, TXUSRCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_17, 0x2884)
    FIELD(CH2_TXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH2_TXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH2_TXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH2_TXCHICO_DBG_SIG_17, TXDAPICLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_18, 0x2888)
    FIELD(CH2_TXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH2_TXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH2_TXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH2_TXCHICO_DBG_SIG_18, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_19, 0x288c)
    FIELD(CH2_TXCHICO_DBG_SIG_19, DBG_TXPI_STATE, 21, 4)
    FIELD(CH2_TXCHICO_DBG_SIG_19, DBG_TXPI_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH2_TXCHICO_DBG_SIG_19, DBG_TXPI_BEACON_XOR, 1, 2)
    FIELD(CH2_TXCHICO_DBG_SIG_19, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_20, 0x2890)
    FIELD(CH2_TXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH2_TXCHICO_DBG_SIG_20, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_21, 0x2894)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_CHICO_OUT_RSVD, 8, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_SYNC_DONE, 3, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH2_TXCHICO_DBG_SIG_22, 0x2898)
    FIELD(CH2_TXCHICO_DBG_SIG_22, MC_TXPICODE_DDR_EN, 9, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_22, TXPICODE_DDR, 1, 8)
    FIELD(CH2_TXCHICO_DBG_SIG_22, TXPCSCLK_INT, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_23, 0x289c)
    FIELD(CH2_TXCHICO_DBG_SIG_23, DBG_VIR_DIFF, 0, 12)
REG32(CH2_TXCHICO_DBG_SIG_24, 0x28a0)
    FIELD(CH2_TXCHICO_DBG_SIG_24, BEACON_128B130B, 3, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_24, TXPCSCLK_INT_DLY_128B130B, 2, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_24, BEACON_DLY_PCSCLK_128B130B, 1, 1)
    FIELD(CH2_TXCHICO_DBG_SIG_24, RST_BEACON_PCSCLK_DLY_INT_B_128B130B, 0, 1)
REG32(CH2_TXCHICO_DBG_SIG_25, 0x28a4)
REG32(CH2_TXCHICO_DBG_SIG_26, 0x28a8)
REG32(CH2_TXCHICO_DBG_SIG_27, 0x28ac)
REG32(CH2_TXCHICO_DBG_SIG_28, 0x28b0)
REG32(CH2_TXCHICO_DBG_SIG_29, 0x28b4)
REG32(CH2_TXCHICO_DBG_SIG_30, 0x28b8)
REG32(CH2_TXCHICO_DBG_SIG_31, 0x28bc)
REG32(CH2_RXCHICO_DBG_SIG_00, 0x28c0)
    FIELD(CH2_RXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH2_RXCHICO_DBG_SIG_00, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_01, 0x28c4)
REG32(CH2_RXCHICO_DBG_SIG_02, 0x28c8)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ, 28, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS, 27, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ, 26, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ, 25, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE, 24, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE, 23, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH2_RXCHICO_DBG_SIG_02, RX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH2_RXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH2_RXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH2_RXCHICO_DBG_SIG_02, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_03, 0x28cc)
    FIELD(CH2_RXCHICO_DBG_SIG_03, RXPI_TOP_IN, 13, 4)
    FIELD(CH2_RXCHICO_DBG_SIG_03, RXPI_BOT_IN, 9, 4)
    FIELD(CH2_RXCHICO_DBG_SIG_03, RXPO_TOP_OUT, 5, 4)
    FIELD(CH2_RXCHICO_DBG_SIG_03, RXPO_BOT_OUT, 1, 4)
REG32(CH2_RXCHICO_DBG_SIG_04, 0x28d0)
    FIELD(CH2_RXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH2_RXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH2_RXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH2_RXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH2_RXCHICO_DBG_SIG_05, 0x28d4)
REG32(CH2_RXCHICO_DBG_SIG_06, 0x28d8)
    FIELD(CH2_RXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH2_RXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH2_RXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH2_RXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH2_RXCHICO_DBG_SIG_07, 0x28dc)
    FIELD(CH2_RXCHICO_DBG_SIG_07, RX_WID_RATIO, 13, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, RX_CHICO_EN, 10, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH2_RXCHICO_DBG_SIG_08, 0x28e0)
    FIELD(CH2_RXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH2_RXCHICO_DBG_SIG_09, 0x28e4)
    FIELD(CH2_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_DONE, 19, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_REQ, 18, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH2_RXCHICO_DBG_SIG_09, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_10, 0x28e8)
    FIELD(CH2_RXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH2_RXCHICO_DBG_SIG_10, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_11, 0x28ec)
    FIELD(CH2_RXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH2_RXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH2_RXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH2_RXCHICO_DBG_SIG_11, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_12, 0x28f0)
    FIELD(CH2_RXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH2_RXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH2_RXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH2_RXCHICO_DBG_SIG_12, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_13, 0x28f4)
    FIELD(CH2_RXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH2_RXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH2_RXCHICO_DBG_SIG_13, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_14, 0x28f8)
REG32(CH2_RXCHICO_DBG_SIG_15, 0x28fc)
REG32(CH2_RXCHICO_DBG_SIG_16, 0x2900)
    FIELD(CH2_RXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_16, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_17, 0x2904)
    FIELD(CH2_RXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH2_RXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH2_RXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH2_RXCHICO_DBG_SIG_17, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_18, 0x2908)
    FIELD(CH2_RXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH2_RXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH2_RXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH2_RXCHICO_DBG_SIG_18, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_19, 0x290c)
REG32(CH2_RXCHICO_DBG_SIG_20, 0x2910)
    FIELD(CH2_RXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH2_RXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH2_RXCHICO_DBG_SIG_20, RXUSRCLK_INT, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_21, 0x2914)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_FINE_ALIGN_DONE, 8, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_SYNC_DONE, 3, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH2_RXCHICO_DBG_SIG_22, 0x2918)
    FIELD(CH2_RXCHICO_DBG_SIG_22, DBG_VIR_DIFF, 0, 12)
REG32(CH2_RXCHICO_DBG_SIG_23, 0x291c)
    FIELD(CH2_RXCHICO_DBG_SIG_23, BEACON_128B130B, 3, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_23, RST_BEACON_USRCLK_DLY_INT_B_128B130B, 2, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_23, RXUSRCLK_INT_DLY_128B130B, 1, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_23, BEACON_DLY_USRCLK_128B130B, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_24, 0x2920)
    FIELD(CH2_RXCHICO_DBG_SIG_24, CLK_SLIP_ERR, 8, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, CDR_SLIP_REQ, 7, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, CDR_SLIP_DIR, 6, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_DONE, 5, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_REQ, 4, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, CDR_SLIP_READY, 3, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, BEACON_OUT, 2, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, POLARITY_SL, 1, 1)
    FIELD(CH2_RXCHICO_DBG_SIG_24, POLARITY_IM, 0, 1)
REG32(CH2_RXCHICO_DBG_SIG_25, 0x2924)
REG32(CH2_RXCHICO_DBG_SIG_26, 0x2928)
REG32(CH2_RXCHICO_DBG_SIG_27, 0x292c)
REG32(CH2_RXCHICO_DBG_SIG_28, 0x2930)
REG32(CH2_RXCHICO_DBG_SIG_29, 0x2934)
REG32(CH2_RXCHICO_DBG_SIG_30, 0x2938)
REG32(CH2_RXCHICO_DBG_SIG_31, 0x293c)
REG32(CH2_COE_STATUS_EYESCAN_0, 0x2940)
REG32(CH2_COE_STATUS_EYESCAN_1, 0x2944)
REG32(CH2_COE_STATUS_EYESCAN_2, 0x2948)
REG32(CH2_COE_STATUS_EYESCAN_3, 0x294c)
REG32(CH2_COE_STATUS_EYESCAN_4, 0x2950)
REG32(CH2_COE_STATUS_EYESCAN_5, 0x2954)
REG32(CH2_COE_STATUS_EYESCAN_6, 0x2958)
REG32(CH2_COE_STATUS_EYESCAN_7, 0x295c)
REG32(CH2_COE_STATUS_EYESCAN_8, 0x2960)
REG32(CH2_COE_STATUS_EYESCAN_9, 0x2964)
REG32(CH2_COE_STATUS_EYESCAN_10, 0x2968)
    FIELD(CH2_COE_STATUS_EYESCAN_10, COE_STATUS_ES_SAMPLE_COUNT, 16, 16)
    FIELD(CH2_COE_STATUS_EYESCAN_10, COE_STATUS_ES_ERROR_COUNT, 0, 16)
REG32(CH2_COE_STATUS_EYESCAN_11, 0x296c)
    FIELD(CH2_COE_STATUS_EYESCAN_11, COE_STATUS_ES_CONTROL_STATUS, 0, 4)
REG32(CH2_COE_STATUS_PRBSERR_CNT_0, 0x2970)
REG32(CH2_COE_STATUS_PRBSERR_CNT_1, 0x2974)
REG32(CH2_COE_STATUS_RX_CYCLECNT_0, 0x2978)
REG32(CH2_COE_STATUS_RX_CYCLECNT_1, 0x297c)
REG32(CH2_COE_STATUS_PRBS_LINK2RESEED_CNT, 0x2980)
    FIELD(CH2_COE_STATUS_PRBS_LINK2RESEED_CNT, RX_PRBS_LINK2RESEED_CNT, 0, 16)
REG32(CH2_COE_STATUS_TXGBOX_0, 0x2984)
    FIELD(CH2_COE_STATUS_TXGBOX_0, TXFIFO_UNDERFLOW, 25, 1)
    FIELD(CH2_COE_STATUS_TXGBOX_0, TXFIFO_OVERFLOW, 24, 1)
    FIELD(CH2_COE_STATUS_TXGBOX_0, TXFIFO_STATUS, 20, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH2_COE_STATUS_TXGBOX_1, 0x2988)
    FIELD(CH2_COE_STATUS_TXGBOX_1, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_1, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_1, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH2_COE_STATUS_TXGBOX_2, 0x298c)
    FIELD(CH2_COE_STATUS_TXGBOX_2, TXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH2_COE_STATUS_TXGBOX_2, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH2_COE_STATUS_TXGBOX_2, WR_ADDR_SYNC, 3, 3)
    FIELD(CH2_COE_STATUS_TXGBOX_2, RD_ADDR_SYNC, 0, 3)
REG32(CH2_COE_STATUS_TX64B66B_0, 0x2990)
    FIELD(CH2_COE_STATUS_TX64B66B_0, TX_16B_64B_ENC_EN, 30, 1)
    FIELD(CH2_COE_STATUS_TX64B66B_0, TXCTRL_CRC_DATAPACK_START, 29, 1)
    FIELD(CH2_COE_STATUS_TX64B66B_0, TXCTRL_XGMII_OR_CRC_INIT, 28, 1)
    FIELD(CH2_COE_STATUS_TX64B66B_0, TX_16B64B_DATAPAC_TRIG, 27, 1)
    FIELD(CH2_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_64B, 19, 8)
    FIELD(CH2_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_64B, 17, 2)
    FIELD(CH2_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_32B, 9, 8)
    FIELD(CH2_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_32B, 7, 2)
    FIELD(CH2_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_64B, 4, 3)
    FIELD(CH2_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_32B, 1, 3)
    FIELD(CH2_COE_STATUS_TX64B66B_0, STAT_TX_LOCAL_FAULT, 0, 1)
REG32(CH2_COE_STATUS_TX64B66B_1, 0x2994)
REG32(CH2_COE_STATUS_RX64B66B_0, 0x2998)
    FIELD(CH2_COE_STATUS_RX64B66B_0, BLOCK_LOCK, 23, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, COE_RX_TP_CNT, 13, 10)
    FIELD(CH2_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_32B, 10, 3)
    FIELD(CH2_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_64B, 7, 3)
    FIELD(CH2_COE_STATUS_RX64B66B_0, DECODER_IN_IS_BADLYFRAMED, 6, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, STAT_RX_HI_BER, 5, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, STAT_RX_BAD_CODE, 4, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, STAT_RX_TEST_PATTERN_MISMATCH, 3, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, STAT_RX_LOCAL_FAULT, 2, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, DESCRAMBLER2DECODER_IS_BADLYFRAMED, 1, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_0, STAT_RX_VALID_CTRL_CODE, 0, 1)
REG32(CH2_COE_STATUS_RX64B66B_1, 0x299c)
REG32(CH2_COE_STATUS_RX64B66B_2, 0x29a0)
    FIELD(CH2_COE_STATUS_RX64B66B_2, RXOUT_FIFO_16B_UNPACK_EN, 1, 1)
    FIELD(CH2_COE_STATUS_RX64B66B_2, STAT_RX_FIFO_ERROR, 0, 1)
REG32(CH2_COE_STATUS_RXGBOX_FIFO_0, 0x29a4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_11_REG, 24, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH2_COE_STATUS_RXGBOX_FIFO_1, 0x29a8)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_1, RXFIFO_STATUS, 0, 8)
REG32(CH2_COE_STATUS_RXGBOX_FIFO_2, 0x29ac)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_10_REG, 24, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_0_WR_CLK, 16, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH2_COE_STATUS_RXGBOX_FIFO_3, 0x29b0)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_1, 15, 1)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_B, 8, 7)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_0, 7, 1)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_A, 0, 7)
REG32(CH2_COE_STATUS_RXGBOX_FIFO_4, 0x29b4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_OVERFLOW, 31, 1)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_UNDERFLOW, 30, 1)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, RXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, DELAY_RXDATA, 10, 2)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, WR_ADDR_SYNC, 3, 3)
    FIELD(CH2_COE_STATUS_RXGBOX_FIFO_4, RD_ADDR_SYNC, 0, 3)
REG32(CH2_COE_STATUS_8B10BEB_RESET_0, 0x29b8)
REG32(CH2_COE_STATUS_8B10BEB_RESET_1, 0x29bc)
REG32(CH2_COESTATUS_PMA_0, 0x29c0)
    FIELD(CH2_COESTATUS_PMA_0, RX_PKDET_AS, 23, 1)
    FIELD(CH2_COESTATUS_PMA_0, TXSWING_OUT_LOW_AS, 22, 1)
    FIELD(CH2_COESTATUS_PMA_0, TXSWING_OUT_HIGH_AS, 21, 1)
    FIELD(CH2_COESTATUS_PMA_0, TX_QPISENN_AS, 19, 1)
    FIELD(CH2_COESTATUS_PMA_0, TX_DCC_READY_AS, 18, 1)
    FIELD(CH2_COESTATUS_PMA_0, RX_QPISENP_AS, 17, 1)
    FIELD(CH2_COESTATUS_PMA_0, RX_QPISENN_AS, 16, 1)
    FIELD(CH2_COESTATUS_PMA_0, RX_DXDS_CALDONE_AS, 11, 1)
    FIELD(CH2_COESTATUS_PMA_0, CDR_SLIP_RDY_AS, 10, 1)
    FIELD(CH2_COESTATUS_PMA_0, CDR_SRSTSTATUS_AS, 9, 1)
    FIELD(CH2_COESTATUS_PMA_0, CDR_WALKDONE_AS, 8, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_LOSSDATA_AS, 7, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_LCKSTATUS_AS, 6, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_CALENDAC_AS, 5, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_OVWRRDY1_AS, 4, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_OVWRRDY0_AS, 3, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_CDRLOCK_AS, 2, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_CALTIMEOUT_AS, 1, 1)
    FIELD(CH2_COESTATUS_PMA_0, ADAPT_CALDONE_AS, 0, 1)
REG32(CH2_COE_STATUS_PLL_STATUS, 0x29c4)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_RSTB_INT, 18, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_REFDIVRSTB_INT, 17, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_RESET_LOOP_DONE, 15, 2)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_PWRDN_B, 14, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_RST_ERR, 13, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_REFLOSS, 12, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_FBLOSS, 11, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_UNLOCK, 10, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_CRSCODE, 3, 7)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_FINE_EN, 2, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_VCO_SEL, 1, 1)
    FIELD(CH2_COE_STATUS_PLL_STATUS, PLL_FREQLOCK, 0, 1)
REG32(CH2_COESTATUS_PMA_1, 0x29c8)
    FIELD(CH2_COESTATUS_PMA_1, ILO_MODE_TUNE_AS, 13, 2)
    FIELD(CH2_COESTATUS_PMA_1, ILO_CLK_LOST_AS, 12, 1)
    FIELD(CH2_COESTATUS_PMA_1, ILO_FBCLK_LOST_AS, 11, 1)
    FIELD(CH2_COESTATUS_PMA_1, ILO_FINE_EN_AS, 10, 1)
    FIELD(CH2_COESTATUS_PMA_1, ILO_FTL_TUNE_AS, 2, 8)
    FIELD(CH2_COESTATUS_PMA_1, UNLOCK_ILO_AS, 1, 1)
    FIELD(CH2_COESTATUS_PMA_1, ILO_LOCK_AS, 0, 1)
REG32(CH2_COESTATUS_RX_FABRIC_INTF0, 0x29cc)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXSTARTOFSEQ, 17, 2)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXVALID, 16, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, COMWAKE, 15, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, COMSAS, 14, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, COMINIT, 13, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXCLKCORCNT, 11, 2)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXBUFSTATUS, 8, 3)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXCHANREALIGN, 7, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXCHANISALIGNED, 6, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXCHANBONDSEQ, 5, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF0, RXCHBONDO, 0, 5)
REG32(CH2_COESTATUS_RX_FABRIC_INTF1, 0x29d0)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF1, RXSLIPDONE, 4, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF1, RXSLIDERDY, 3, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF1, RXCOMMADET, 2, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF1, RXBYTEREALIGN, 1, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF1, RXBYTEISALIGNED, 0, 1)
REG32(CH2_COESTATUS_RX_FABRIC_INTF2, 0x29d4)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF2, DMON_FIFO_STATUS, 3, 2)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF2, EYESCANDATAERROR, 2, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF2, RXPRBSLOCKED, 1, 1)
    FIELD(CH2_COESTATUS_RX_FABRIC_INTF2, RXPRBSERR, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_PIPE_RESET, 0x29d8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, ILO_LOCK_R, 31, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, GT_POWERGOOD_R, 30, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RPLL_LOCK_R, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_LOCK_R, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_DONE_R, 27, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RX_PMA_RESETDONE_R, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TXRESET_DONE_R, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RXRESET_DONE_R, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_DONE_R, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_DONE_R, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, PHYSTATUS_R, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RPLL_PD_INT_DLY, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RPLL_RESET_INT_DLY, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_PD_INT_DLY, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_RESET_INT_DLY, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_INT_DLY, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, PMA_RESET_INT_DLY, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, PCS_RESET_INT_DLY, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, USER_RDY_INT_DLY, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_INT, 11, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_INT, 10, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, PHY_READY_INT, 9, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, BUFGT_PHY_READY, 8, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RESET, FSM_PIPE_RST_CTRL, 0, 4)
REG32(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, 0x29dc)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_SYNC, 31, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_INT, 30, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_R, 28, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_DELAY, 24, 4)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_SYNC, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_SYNC, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RX_CDR_ALIGN_DONE_SYNC, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_R, 19, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_R, 17, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_IN_PROGRESS_R, 15, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_ENTER, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_ENTER, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_EXIT, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_EXIT, 11, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SRIS_MODE, 10, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, COMMON_REF_MODE, 9, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, FSM_CDR_CTRL, 6, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRFREQRESET, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDR_ALGN_REQ, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_DET, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_RATE, 1, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD_IN, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, 0x29e0)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE_FROM_TO_ESM, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK_R, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_SEL_INT, 25, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, FSM_BUFG, 22, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CTRL_IN_PROGRESS, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_RESET_INT, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CE_INT, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_RESET_MASK_INT, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_CE_MASK_INT, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_RESET_MASK_INT, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_CE_MASK_INT, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_INT, 12, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFGT_RATE, 9, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK, 8, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE, 7, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, PHY_READY, 6, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER, 1, 5)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER_DONE, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_PIPE_PD, 0x29e4)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RXNEW_PD, 30, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RXCURRENT_PD, 28, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TXNEW_PD, 26, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TXCURRENT_PD, 24, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, BEACON, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, PWRUPTX, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, PWRUPTXDRV, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, PWRUPRX, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, PWRUPDET, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RPLL_PD_SA, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, LCPLL_PD_SA, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TXPMA_PWRDN_B_SA, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TXDRVPWRDN_B_SA, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RX_PDB_SA, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, OOB_PDB_SA, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TXSERPWRDN_B_SA, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RXCKMUXPWRDN_B_SA, 11, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TXCKMUXPWRDN_B_SA, 10, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TX_VREG_PDB_SA, 9, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RX_VREG_PDB_SA, 8, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TX_P_CHANGE, 7, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RX_P_CHANGE, 6, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN_PULSE, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, CLR_PHYSTATUS, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, SET_PHYSTATUS, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, TX_P2_CHANGE, 1, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_PD, RX_P2_CHANGE, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, 0x29e8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_BYPASS, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_AS, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_AS, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SA_REG, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETPOLL_SA_REG, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_EN_SA_REG, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_D, 17, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART01, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ZERO, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ONE, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ZERO, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ONE, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_DONE, 11, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SYNC, 10, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER, 7, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVREF_EN, 6, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_SYNC, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_SYNC, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_DELAY, 0, 4)
REG32(CH2_COESTATUS_CHANNEL_PIPE_STAT, 0x29ec)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_128B130B, 29, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_8B10B, 26, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RCVABSENT_SYNC, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RCVPRESENT_SYNC, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RST_PERIOD_SYNC, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RATE_SYNC, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_1, 19, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_0, 16, 3)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_UNDERFLOW_8B10B, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_OVERFLOW_8B10B, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXNOTINTABLE_8B10B, 12, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXDISPERR_8B10B, 10, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXCLKCORCNT_EARLY_8B10B, 8, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, ENB_NOTINTABLE, 6, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, ENB_DISPERR, 4, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RCVDET, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_PWRDWN, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS, 1, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_STAT, RXRATEDONE, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_TX_EQ, 0x29f0)
    FIELD(CH2_COESTATUS_CHANNEL_TX_EQ, TXDRVBIASP_SA, 21, 5)
    FIELD(CH2_COESTATUS_CHANNEL_TX_EQ, TXEMPPRE_SA, 16, 5)
    FIELD(CH2_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_SA, 9, 7)
    FIELD(CH2_COESTATUS_CHANNEL_TX_EQ, TXEMPPOS_SA, 4, 5)
    FIELD(CH2_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_INDEP_SA, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_EQ, TXPDRVAMP_SA, 0, 3)
REG32(CH2_COESTATUS_CHANNEL_TX_ELEC, 0x29f4)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_PCIE_SATA, 31, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_USB3, 30, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXCOMINIT_TXPHYCLK, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, P0_LOOPBACK_PERIOD, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXCOMSAS_TXPHYCLK, 27, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXCOMWAKE_TXPHYCLK, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, COMSTART_TXPHYCLK, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_PCIE_USB3, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_DELAY, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_SEL, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, P0_DATA_PERIOD, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, P0_LFPS_PERIOD, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, P0_TRISTATE_PERIOD, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, USB3_P23_RXDETECTION_PERIOD, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_TRISTATE_PERIOD, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_LFPS_PERIOD, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, USB3_TRISTATE_PERIOD, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_INT, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, SATA_WORDCOUNT, 10, 3)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, USB3_LFPS_PERIOD, 9, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TXELEC_LFPS, 8, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, TX_OOB_SIGSEL, 6, 2)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, PCIE_RXLOOPBACK, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, RCVDETSTART, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, COMSTATE, 2, 2)
    FIELD(CH2_COESTATUS_CHANNEL_TX_ELEC, COMTYPE, 0, 2)
REG32(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, 0x29f8)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_ILO_RESET, 29, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_RXELECIDLE, 28, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_INT, 27, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_OOBSIGVAL_AS, 26, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PMA_RESET, 25, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PMA_RESET, 24, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PCS_RESET, 23, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PCS_RESET, 22, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXPROGDIV_RESET, 21, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_TXPROGDIV_RESET, 20, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHY_READY, 19, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RATE_CHANGE_IN_PROGRESS, 18, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXSYNC_RESET, 17, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RXSYNC_RESET, 16, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_RPLL_RESET, 15, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RPLL_RESET, 14, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_LCPLL_RESET, 13, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_LCPLL_RESET, 12, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PROGDIVRESET_DONE, 11, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PMA_RESETDONE, 10, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_PMA_RESETDONE, 9, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_RESETDONE, 8, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_RESETDONE, 7, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_LOCK, 5, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_RESETDONE, 4, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, LCPLL_RESETDONE, 3, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHYSTATUS_INT, 2, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TXSYNC_DONE, 1, 1)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RXSYNC_DONE, 0, 1)
REG32(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, 0x29fc)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE, 30, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE_CP7, 28, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, FE_PMA_LPBK_FIFO_STATUS, 26, 2)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_IN, 12, 4)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_IN, 8, 4)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_OUT, 4, 4)
    FIELD(CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_OUT, 0, 4)
REG32(CH2_COESTATUS_ADAPT_LOOP_00, 0x2a80)
REG32(CH2_COESTATUS_ADAPT_LOOP_01, 0x2a84)
REG32(CH2_COESTATUS_ADAPT_LOOP_02, 0x2a88)
REG32(CH2_COESTATUS_ADAPT_LOOP_03, 0x2a8c)
REG32(CH2_COESTATUS_ADAPT_LOOP_04, 0x2a90)
REG32(CH2_COESTATUS_ADAPT_LOOP_05, 0x2a94)
REG32(CH2_COESTATUS_ADAPT_LOOP_06, 0x2a98)
REG32(CH2_COESTATUS_ADAPT_LOOP_07, 0x2a9c)
REG32(CH2_COESTATUS_ADAPT_LOOP_08, 0x2aa0)
REG32(CH2_COESTATUS_ADAPT_LOOP_09, 0x2aa4)
REG32(CH2_COESTATUS_ADAPT_LOOP_10, 0x2aa8)
REG32(CH2_COESTATUS_ADAPT_LOOP_11, 0x2aac)
REG32(CH3_COESTATUS_CHANNEL_RESET0, 0x2c00)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, CDRSRESET_ENABLE, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, DES_RST_SYNC_EN, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPIDIV, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPIDIV, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_ILO, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_DAPI, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_DAPI, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_PHDLY, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_PHDLY, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_PRBSCNT, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_OOB, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_ISCAN, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_BUF, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_PCS, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_DFE, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRFR, 11, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_CDRPH, 10, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_PMA, 9, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_CLKGEN, 8, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_CKOK, 7, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_CFOK, 6, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_PCS, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_PMA, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_CLKGEN, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_CKCAL, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_RX_PROGDIV, 1, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET0, RESETB_TX_PROGDIV, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_RESET1, 0x2c04)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, RESET_EXCEPTION, 31, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, ILO_LOOP_ERR, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, RX_CHICO_RESET_ERR, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, TX_CHICO_RESET_ERR, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, RX_PROGDDIV_RESET_ERR, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, TX_PROGDDIV_RESET_ERR, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, RX_DAPI_RESET_ERR, 18, 2)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, TX_DAPI_RESET_ERR, 16, 2)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, RX_PCS_LOOP_ERR, 11, 5)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, RX_PMA_LOOP_ERR, 4, 7)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, TX_PCS_LOOP_ERR, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET1, TX_PMA_LOOP_ERR, 0, 3)
REG32(CH3_COESTATUS_CHANNEL_RESET2, 0x2c08)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, ILO_RESETDONE, 30, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_RESETDONE, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_RESETDONE, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_PMA_RESETDONE, 27, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_PMA_RESETDONE, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_DAPIRESET_DONE, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_DAPIRESET_DONE, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_CHICORESET_DONE, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_CHICORESET_DONE, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_PROGDIVRESET_DONE, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_PROGDIVRESET_DONE, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_DAPI_LOOP_DONE, 18, 2)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_DAPI_LOOP_DONE, 16, 2)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_PCS_LOOP_DONE, 11, 5)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, RX_PMA_LOOP_DONE, 4, 7)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_PCS_LOOP_DONE, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_RESET2, TX_PMA_LOOP_DONE, 0, 3)
REG32(CH3_COESTATUS_CHANNEL_PIPE_RATE3, 0x2c0c)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_CHANGE_FROM_TO_ESM, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, BUFGT_RATE_ESM_DAPIRST_DONE, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_REQUEST_INT, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, RX_ADAPT_IN_PROGRESS_INT, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, UB_RX_ADAPT_SAVE_DONE_R, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LTSSM_STATE_INT_R, 7, 6)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, PCIE_LINK_REACH_TARGET_INT_R, 6, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, PHY_ESM_ADAPTATION_SAVE_R, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_DONE_RXRATE, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, UB_REPROG_REQUEST_RXRATE_INT, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, RXRATE_CHANGE_IN_PROGRESS_INT, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE3, FSM_RX_RATE, 0, 2)
REG32(CH3_COESTATUS_CHANNEL_PIPE_RATE2, 0x2c10)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, TXRX_128B130B_EN_INT, 31, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT, 30, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_PD_INT, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_RESET_INT, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, OUTCLK_PLL_LOCK_INT, 27, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_PD_INT, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RPLL_RESET_INT, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_PD_INT, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_RESET_INT, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, DATA_PLL_LOCK_INT, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_PD_INT, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, LCPLL_RESET_INT, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, TXPROGDIV_RESET_INT, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, PMA_RESET_INT, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, PCS_RESET_INT, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, UB_REPROG_REQUEST_INT, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_INT, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_INT, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_IN_PROGRESS_INT, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_PLL_RESET, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, PHYSTATUS_RATE_INT_R, 8, 4)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_8B10B_TO_128B130B, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_128B130B_TO_8B10B, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_ESM, 1, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE2, RATE_CHANGE_FROM_TO_128B130B, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_PIPE_RATE0, 0x2c14)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_RX, 24, 8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_RX, 16, 8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE0, NEW_SPEED_TX, 8, 8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE0, CURRENT_SPEED_TX, 0, 8)
REG32(CH3_COESTATUS_CHANNEL_PIPE_RATE1, 0x2c18)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, TXDAPI_RESET_INT, 31, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, RPLL_LOCK_R, 30, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, LCPLL_LOCK_R, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, TXPROGDIV_RESET_DONE_R, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, TX_PMA_RESETDONE_R, 27, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, RX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, TXRESET_DONE_R, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, RXRESET_DONE_R, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, TXSYNC_DONE_R, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, RXSYNC_DONE_R, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, TXRATE_R, 14, 8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, RXRATE_R, 6, 8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, UB_REPROG_DONE_R, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RATE1, FSM_RATE, 0, 5)
REG32(CH3_COESTATUS_TXUSRCLK_FREQ_CNT, 0x2c1c)
    FIELD(CH3_COESTATUS_TXUSRCLK_FREQ_CNT, TXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH3_COESTATUS_TXPHYCLK_FREQ_CNT, 0x2c20)
    FIELD(CH3_COESTATUS_TXPHYCLK_FREQ_CNT, TXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH3_COESTATUS_TXPCSCLK_FREQ_CNT, 0x2c24)
    FIELD(CH3_COESTATUS_TXPCSCLK_FREQ_CNT, TXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH3_COESTATUS_RXUSRCLK_FREQ_CNT, 0x2c28)
    FIELD(CH3_COESTATUS_RXUSRCLK_FREQ_CNT, RXUSRCLK_FREQ_CNT, 0, 12)
REG32(CH3_COESTATUS_RXPHYCLK_FREQ_CNT, 0x2c2c)
    FIELD(CH3_COESTATUS_RXPHYCLK_FREQ_CNT, RXPHYCLK_FREQ_CNT, 0, 12)
REG32(CH3_COESTATUS_RXPCSCLK_FREQ_CNT, 0x2c30)
    FIELD(CH3_COESTATUS_RXPCSCLK_FREQ_CNT, RXPCSCLK_FREQ_CNT, 0, 12)
REG32(CH3_COESTATUS_CRC_TX, 0x2c34)
REG32(CH3_COESTATUS_CRC_RX, 0x2c38)
REG32(CH3_TXCHICO_DBG_SIG_00, 0x2c40)
    FIELD(CH3_TXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_00, TXPCSDAPICLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_01, 0x2c44)
    FIELD(CH3_TXCHICO_DBG_SIG_01, CLK4TXPI, 8, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_01, TXPICODE, 1, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_01, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_02, 0x2c48)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ_SYNC, 28, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS_SYNC, 27, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ_SYNC, 26, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ_SYNC, 25, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE_SYNC, 24, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE_SYNC, 23, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH3_TXCHICO_DBG_SIG_02, TX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH3_TXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH3_TXCHICO_DBG_SIG_02, TXDAPICLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_03, 0x2c4c)
    FIELD(CH3_TXCHICO_DBG_SIG_03, TXPI_TOP_IN, 13, 4)
    FIELD(CH3_TXCHICO_DBG_SIG_03, TXPI_BOT_IN, 9, 4)
    FIELD(CH3_TXCHICO_DBG_SIG_03, TXPO_TOP_OUT, 5, 4)
    FIELD(CH3_TXCHICO_DBG_SIG_03, TXPO_BOT_OUT, 1, 4)
REG32(CH3_TXCHICO_DBG_SIG_04, 0x2c50)
    FIELD(CH3_TXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH3_TXCHICO_DBG_SIG_05, 0x2c54)
    FIELD(CH3_TXCHICO_DBG_SIG_05, TXPI_SETINIT_PH_CNT, 22, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_05, TXPI_MAX_SAMPLE_THRESHOLD, 15, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_05, TXPI_MIN_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_05, TXPI_NUM_SAMPLES, 1, 7)
REG32(CH3_TXCHICO_DBG_SIG_06, 0x2c58)
    FIELD(CH3_TXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH3_TXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH3_TXCHICO_DBG_SIG_07, 0x2c5c)
    FIELD(CH3_TXCHICO_DBG_SIG_07, TX_WID_RATIO, 13, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, TX_CHICO_EN, 10, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH3_TXCHICO_DBG_SIG_08, 0x2c60)
    FIELD(CH3_TXCHICO_DBG_SIG_08, TXPI_DIV, 11, 11)
    FIELD(CH3_TXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH3_TXCHICO_DBG_SIG_09, 0x2c64)
    FIELD(CH3_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_09, TX_PHASE_SHIFT180_REQ, 19, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH3_TXCHICO_DBG_SIG_09, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_10, 0x2c68)
    FIELD(CH3_TXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH3_TXCHICO_DBG_SIG_10, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_11, 0x2c6c)
    FIELD(CH3_TXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH3_TXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_11, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_12, 0x2c70)
    FIELD(CH3_TXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_12, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_13, 0x2c74)
    FIELD(CH3_TXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH3_TXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH3_TXCHICO_DBG_SIG_13, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_14, 0x2c78)
    FIELD(CH3_TXCHICO_DBG_SIG_14, DBG_TXPI_P_STATE, 15, 5)
    FIELD(CH3_TXCHICO_DBG_SIG_14, DBG_TXPI_LAST_SAMPLE_ACC, 7, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_14, DBG_TXPI_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_14, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_15, 0x2c7c)
    FIELD(CH3_TXCHICO_DBG_SIG_15, DBG_TXPI_INC_PH_CNT, 13, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_15, DBG_TXPI_DEC_PH_CNT, 7, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_15, DBG_TXPI_HOLD_PH_CNT, 1, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_15, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_16, 0x2c80)
    FIELD(CH3_TXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_16, MLDLY_BEACON_2, 1, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_16, TXUSRCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_17, 0x2c84)
    FIELD(CH3_TXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH3_TXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH3_TXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH3_TXCHICO_DBG_SIG_17, TXDAPICLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_18, 0x2c88)
    FIELD(CH3_TXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH3_TXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH3_TXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH3_TXCHICO_DBG_SIG_18, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_19, 0x2c8c)
    FIELD(CH3_TXCHICO_DBG_SIG_19, DBG_TXPI_STATE, 21, 4)
    FIELD(CH3_TXCHICO_DBG_SIG_19, DBG_TXPI_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH3_TXCHICO_DBG_SIG_19, DBG_TXPI_BEACON_XOR, 1, 2)
    FIELD(CH3_TXCHICO_DBG_SIG_19, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_20, 0x2c90)
    FIELD(CH3_TXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH3_TXCHICO_DBG_SIG_20, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_21, 0x2c94)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_CHICO_OUT_RSVD, 8, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_SYNC_DONE, 3, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_21, TX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH3_TXCHICO_DBG_SIG_22, 0x2c98)
    FIELD(CH3_TXCHICO_DBG_SIG_22, MC_TXPICODE_DDR_EN, 9, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_22, TXPICODE_DDR, 1, 8)
    FIELD(CH3_TXCHICO_DBG_SIG_22, TXPCSCLK_INT, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_23, 0x2c9c)
    FIELD(CH3_TXCHICO_DBG_SIG_23, DBG_VIR_DIFF, 0, 12)
REG32(CH3_TXCHICO_DBG_SIG_24, 0x2ca0)
    FIELD(CH3_TXCHICO_DBG_SIG_24, BEACON_128B130B, 3, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_24, TXPCSCLK_INT_DLY_128B130B, 2, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_24, BEACON_DLY_PCSCLK_128B130B, 1, 1)
    FIELD(CH3_TXCHICO_DBG_SIG_24, RST_BEACON_PCSCLK_DLY_INT_B_128B130B, 0, 1)
REG32(CH3_TXCHICO_DBG_SIG_25, 0x2ca4)
REG32(CH3_TXCHICO_DBG_SIG_26, 0x2ca8)
REG32(CH3_TXCHICO_DBG_SIG_27, 0x2cac)
REG32(CH3_TXCHICO_DBG_SIG_28, 0x2cb0)
REG32(CH3_TXCHICO_DBG_SIG_29, 0x2cb4)
REG32(CH3_TXCHICO_DBG_SIG_30, 0x2cb8)
REG32(CH3_TXCHICO_DBG_SIG_31, 0x2cbc)
REG32(CH3_RXCHICO_DBG_SIG_00, 0x2cc0)
    FIELD(CH3_RXCHICO_DBG_SIG_00, CLK4DAPI, 9, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_00, DAPICODE, 1, 8)
    FIELD(CH3_RXCHICO_DBG_SIG_00, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_01, 0x2cc4)
REG32(CH3_RXCHICO_DBG_SIG_02, 0x2cc8)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_BEACON_OUT2, 29, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_REQ, 28, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, ST_7_MM_DLY_ALIGN_PROGRESS, 27, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_REQ, 26, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_REQ, 25, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_ALIGN_DONE, 24, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, ST_6_MM_LOCAL_G_SETINIT_DONE, 23, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_UPDOWN_ST7, 21, 2)
    FIELD(CH3_RXCHICO_DBG_SIG_02, RX_DELAY_ALIGN_ERR, 20, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_SAW_ALIGN_EDGE, 19, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_FAE, 17, 2)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_PHASE_CHANGE, 16, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_SAMPLE_VALID, 14, 2)
    FIELD(CH3_RXCHICO_DBG_SIG_02, MLDLY_DAPICODE, 6, 8)
    FIELD(CH3_RXCHICO_DBG_SIG_02, DBG_MLDLY_P_STATE, 1, 5)
    FIELD(CH3_RXCHICO_DBG_SIG_02, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_03, 0x2ccc)
    FIELD(CH3_RXCHICO_DBG_SIG_03, RXPI_TOP_IN, 13, 4)
    FIELD(CH3_RXCHICO_DBG_SIG_03, RXPI_BOT_IN, 9, 4)
    FIELD(CH3_RXCHICO_DBG_SIG_03, RXPO_TOP_OUT, 5, 4)
    FIELD(CH3_RXCHICO_DBG_SIG_03, RXPO_BOT_OUT, 1, 4)
REG32(CH3_RXCHICO_DBG_SIG_04, 0x2cd0)
    FIELD(CH3_RXCHICO_DBG_SIG_04, MLDLY_SETINIT_PH_CNT, 22, 8)
    FIELD(CH3_RXCHICO_DBG_SIG_04, BCON_EDGE_THRESHOLD, 15, 7)
    FIELD(CH3_RXCHICO_DBG_SIG_04, MLDLY_MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH3_RXCHICO_DBG_SIG_04, MLDLY_MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH3_RXCHICO_DBG_SIG_05, 0x2cd4)
REG32(CH3_RXCHICO_DBG_SIG_06, 0x2cd8)
    FIELD(CH3_RXCHICO_DBG_SIG_06, SETINIT_PH_CNT, 22, 8)
    FIELD(CH3_RXCHICO_DBG_SIG_06, NUM_SAMPLES, 15, 7)
    FIELD(CH3_RXCHICO_DBG_SIG_06, MAX_SAMPLE_THRESHOLD, 8, 7)
    FIELD(CH3_RXCHICO_DBG_SIG_06, MIN_SAMPLE_THRESHOLD, 1, 7)
REG32(CH3_RXCHICO_DBG_SIG_07, 0x2cdc)
    FIELD(CH3_RXCHICO_DBG_SIG_07, RX_WID_RATIO, 13, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, RUN_LOCAL_BEACON, 12, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, RUN_ALTERNATE_EDGE, 11, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, RX_CHICO_EN, 10, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, AUTO_0_MANUAL_1, 9, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, ML, 8, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, IM, 7, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, MM, 6, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, SL, 5, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, GEN_BEACON_POLARITY, 4, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, RCV_BEACON_POLARITY, 3, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, WID_21, 2, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_07, DAPI_BEACON_POL_SEL, 1, 1)
REG32(CH3_RXCHICO_DBG_SIG_08, 0x2ce0)
    FIELD(CH3_RXCHICO_DBG_SIG_08, DAPI_DIV, 1, 10)
REG32(CH3_RXCHICO_DBG_SIG_09, 0x2ce4)
    FIELD(CH3_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_DONE, 21, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_09, ST_5_CALC_180_PH_REQ, 20, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_DONE, 19, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_09, RX_PHASE_SHIFT180_REQ, 18, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_09, SHIFT180COUNT, 1, 17)
    FIELD(CH3_RXCHICO_DBG_SIG_09, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_10, 0x2ce8)
    FIELD(CH3_RXCHICO_DBG_SIG_10, DBG_SHIFT180COUNT_OPT, 1, 17)
    FIELD(CH3_RXCHICO_DBG_SIG_10, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_11, 0x2cec)
    FIELD(CH3_RXCHICO_DBG_SIG_11, DBG_P_STATE, 15, 5)
    FIELD(CH3_RXCHICO_DBG_SIG_11, DBG_LAST_SAMPLE_ACC_FROM_CHICO_SLAVE, 7, 8)
    FIELD(CH3_RXCHICO_DBG_SIG_11, DBG_SYNC_DONE_COUNT, 1, 6)
    FIELD(CH3_RXCHICO_DBG_SIG_11, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_12, 0x2cf0)
    FIELD(CH3_RXCHICO_DBG_SIG_12, DBG_INC_PH_CNT, 13, 6)
    FIELD(CH3_RXCHICO_DBG_SIG_12, DBG_DEC_PH_CNT, 7, 6)
    FIELD(CH3_RXCHICO_DBG_SIG_12, DBG_HOLD_PH_CNT, 1, 6)
    FIELD(CH3_RXCHICO_DBG_SIG_12, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_13, 0x2cf4)
    FIELD(CH3_RXCHICO_DBG_SIG_13, DBG_DAPICODE_MID, 12, 11)
    FIELD(CH3_RXCHICO_DBG_SIG_13, DBG_DAPICODE_VIR, 1, 11)
    FIELD(CH3_RXCHICO_DBG_SIG_13, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_14, 0x2cf8)
REG32(CH3_RXCHICO_DBG_SIG_15, 0x2cfc)
REG32(CH3_RXCHICO_DBG_SIG_16, 0x2d00)
    FIELD(CH3_RXCHICO_DBG_SIG_16, GEN_BEACON_POLARITY, 3, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_16, BEACON_1, 2, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_16, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_17, 0x2d04)
    FIELD(CH3_RXCHICO_DBG_SIG_17, DBG_MLDLY_STATE, 21, 4)
    FIELD(CH3_RXCHICO_DBG_SIG_17, DBG_MLDLY_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH3_RXCHICO_DBG_SIG_17, DBG_MLDLY_BEACON_XOR, 1, 2)
    FIELD(CH3_RXCHICO_DBG_SIG_17, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_18, 0x2d08)
    FIELD(CH3_RXCHICO_DBG_SIG_18, DBG_STATE, 21, 4)
    FIELD(CH3_RXCHICO_DBG_SIG_18, DBG_PHS_CHANGE_CNT, 3, 18)
    FIELD(CH3_RXCHICO_DBG_SIG_18, DBG_BEACON_XOR, 1, 2)
    FIELD(CH3_RXCHICO_DBG_SIG_18, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_19, 0x2d0c)
REG32(CH3_RXCHICO_DBG_SIG_20, 0x2d10)
    FIELD(CH3_RXCHICO_DBG_SIG_20, DBG_LAST_SAMPLE_ACC_FROM_DELAY_ALIGN, 7, 8)
    FIELD(CH3_RXCHICO_DBG_SIG_20, DBG_MASTER_P_STATE, 1, 6)
    FIELD(CH3_RXCHICO_DBG_SIG_20, RXUSRCLK_INT, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_21, 0x2d14)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_FINE_ALIGN_DONE, 8, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_DONE, 7, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_PHASE_ALIGN_ERR, 6, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_ERR, 5, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_PHASE_SHIFT180_DONE, 4, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_SYNC_DONE, 3, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_PHASE_SETINIT_DONE, 2, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_21, RX_DELAY_ALIGN_PROGRESS, 1, 1)
REG32(CH3_RXCHICO_DBG_SIG_22, 0x2d18)
    FIELD(CH3_RXCHICO_DBG_SIG_22, DBG_VIR_DIFF, 0, 12)
REG32(CH3_RXCHICO_DBG_SIG_23, 0x2d1c)
    FIELD(CH3_RXCHICO_DBG_SIG_23, BEACON_128B130B, 3, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_23, RST_BEACON_USRCLK_DLY_INT_B_128B130B, 2, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_23, RXUSRCLK_INT_DLY_128B130B, 1, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_23, BEACON_DLY_USRCLK_128B130B, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_24, 0x2d20)
    FIELD(CH3_RXCHICO_DBG_SIG_24, CLK_SLIP_ERR, 8, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, CDR_SLIP_REQ, 7, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, CDR_SLIP_DIR, 6, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_DONE, 5, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, RX_CDR_ALIGN_REQ, 4, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, CDR_SLIP_READY, 3, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, BEACON_OUT, 2, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, POLARITY_SL, 1, 1)
    FIELD(CH3_RXCHICO_DBG_SIG_24, POLARITY_IM, 0, 1)
REG32(CH3_RXCHICO_DBG_SIG_25, 0x2d24)
REG32(CH3_RXCHICO_DBG_SIG_26, 0x2d28)
REG32(CH3_RXCHICO_DBG_SIG_27, 0x2d2c)
REG32(CH3_RXCHICO_DBG_SIG_28, 0x2d30)
REG32(CH3_RXCHICO_DBG_SIG_29, 0x2d34)
REG32(CH3_RXCHICO_DBG_SIG_30, 0x2d38)
REG32(CH3_RXCHICO_DBG_SIG_31, 0x2d3c)
REG32(CH3_COE_STATUS_EYESCAN_0, 0x2d40)
REG32(CH3_COE_STATUS_EYESCAN_1, 0x2d44)
REG32(CH3_COE_STATUS_EYESCAN_2, 0x2d48)
REG32(CH3_COE_STATUS_EYESCAN_3, 0x2d4c)
REG32(CH3_COE_STATUS_EYESCAN_4, 0x2d50)
REG32(CH3_COE_STATUS_EYESCAN_5, 0x2d54)
REG32(CH3_COE_STATUS_EYESCAN_6, 0x2d58)
REG32(CH3_COE_STATUS_EYESCAN_7, 0x2d5c)
REG32(CH3_COE_STATUS_EYESCAN_8, 0x2d60)
REG32(CH3_COE_STATUS_EYESCAN_9, 0x2d64)
REG32(CH3_COE_STATUS_EYESCAN_10, 0x2d68)
    FIELD(CH3_COE_STATUS_EYESCAN_10, COE_STATUS_ES_SAMPLE_COUNT, 16, 16)
    FIELD(CH3_COE_STATUS_EYESCAN_10, COE_STATUS_ES_ERROR_COUNT, 0, 16)
REG32(CH3_COE_STATUS_EYESCAN_11, 0x2d6c)
    FIELD(CH3_COE_STATUS_EYESCAN_11, COE_STATUS_ES_CONTROL_STATUS, 0, 4)
REG32(CH3_COE_STATUS_PRBSERR_CNT_0, 0x2d70)
REG32(CH3_COE_STATUS_PRBSERR_CNT_1, 0x2d74)
REG32(CH3_COE_STATUS_RX_CYCLECNT_0, 0x2d78)
REG32(CH3_COE_STATUS_RX_CYCLECNT_1, 0x2d7c)
REG32(CH3_COE_STATUS_PRBS_LINK2RESEED_CNT, 0x2d80)
    FIELD(CH3_COE_STATUS_PRBS_LINK2RESEED_CNT, RX_PRBS_LINK2RESEED_CNT, 0, 16)
REG32(CH3_COE_STATUS_TXGBOX_0, 0x2d84)
    FIELD(CH3_COE_STATUS_TXGBOX_0, TXFIFO_UNDERFLOW, 25, 1)
    FIELD(CH3_COE_STATUS_TXGBOX_0, TXFIFO_OVERFLOW, 24, 1)
    FIELD(CH3_COE_STATUS_TXGBOX_0, TXFIFO_STATUS, 20, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH3_COE_STATUS_TXGBOX_1, 0x2d88)
    FIELD(CH3_COE_STATUS_TXGBOX_1, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_1, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_1, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH3_COE_STATUS_TXGBOX_2, 0x2d8c)
    FIELD(CH3_COE_STATUS_TXGBOX_2, TXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH3_COE_STATUS_TXGBOX_2, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH3_COE_STATUS_TXGBOX_2, WR_ADDR_SYNC, 3, 3)
    FIELD(CH3_COE_STATUS_TXGBOX_2, RD_ADDR_SYNC, 0, 3)
REG32(CH3_COE_STATUS_TX64B66B_0, 0x2d90)
    FIELD(CH3_COE_STATUS_TX64B66B_0, TX_16B_64B_ENC_EN, 30, 1)
    FIELD(CH3_COE_STATUS_TX64B66B_0, TXCTRL_CRC_DATAPACK_START, 29, 1)
    FIELD(CH3_COE_STATUS_TX64B66B_0, TXCTRL_XGMII_OR_CRC_INIT, 28, 1)
    FIELD(CH3_COE_STATUS_TX64B66B_0, TX_16B64B_DATAPAC_TRIG, 27, 1)
    FIELD(CH3_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_64B, 19, 8)
    FIELD(CH3_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_64B, 17, 2)
    FIELD(CH3_COE_STATUS_TX64B66B_0, COE_TX_SCR_TP_CNT_32B, 9, 8)
    FIELD(CH3_COE_STATUS_TX64B66B_0, COE_TX_SCR_STATE_32B, 7, 2)
    FIELD(CH3_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_64B, 4, 3)
    FIELD(CH3_COE_STATUS_TX64B66B_0, COE_TXENC_FSM_STATE_32B, 1, 3)
    FIELD(CH3_COE_STATUS_TX64B66B_0, STAT_TX_LOCAL_FAULT, 0, 1)
REG32(CH3_COE_STATUS_TX64B66B_1, 0x2d94)
REG32(CH3_COE_STATUS_RX64B66B_0, 0x2d98)
    FIELD(CH3_COE_STATUS_RX64B66B_0, BLOCK_LOCK, 23, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, COE_RX_TP_CNT, 13, 10)
    FIELD(CH3_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_32B, 10, 3)
    FIELD(CH3_COE_STATUS_RX64B66B_0, COE_RXDEC_FSM_STATE_64B, 7, 3)
    FIELD(CH3_COE_STATUS_RX64B66B_0, DECODER_IN_IS_BADLYFRAMED, 6, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, STAT_RX_HI_BER, 5, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, STAT_RX_BAD_CODE, 4, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, STAT_RX_TEST_PATTERN_MISMATCH, 3, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, STAT_RX_LOCAL_FAULT, 2, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, DESCRAMBLER2DECODER_IS_BADLYFRAMED, 1, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_0, STAT_RX_VALID_CTRL_CODE, 0, 1)
REG32(CH3_COE_STATUS_RX64B66B_1, 0x2d9c)
REG32(CH3_COE_STATUS_RX64B66B_2, 0x2da0)
    FIELD(CH3_COE_STATUS_RX64B66B_2, RXOUT_FIFO_16B_UNPACK_EN, 1, 1)
    FIELD(CH3_COE_STATUS_RX64B66B_2, STAT_RX_FIFO_ERROR, 0, 1)
REG32(CH3_COE_STATUS_RXGBOX_FIFO_0, 0x2da4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_11_REG, 24, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_1_WR_CLK, 16, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_0, ADDR_DIFF_00_REG, 12, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_0, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_0, RD_ADDR_BIN_0_WR_CLK, 0, 4)
REG32(CH3_COE_STATUS_RXGBOX_FIFO_1, 0x2da8)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_1, RXFIFO_STATUS, 0, 8)
REG32(CH3_COE_STATUS_RXGBOX_FIFO_2, 0x2dac)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_10_REG, 24, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_1_SYNC, 20, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_0_WR_CLK, 16, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_2, ADDR_DIFF_01_REG, 8, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_2, WR_ADDR_BIN_0_SYNC, 4, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_2, RD_ADDR_BIN_1_WR_CLK, 0, 4)
REG32(CH3_COE_STATUS_RXGBOX_FIFO_3, 0x2db0)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_1, 15, 1)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_B, 8, 7)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_3, DELAY_RXDATA_0, 7, 1)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_3, BITSLIP_CNT_A, 0, 7)
REG32(CH3_COE_STATUS_RXGBOX_FIFO_4, 0x2db4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_OVERFLOW, 31, 1)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, RXFIFO_UNDERFLOW, 30, 1)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, RXGBOX_FIFO_LATENCY, 16, 14)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, DELAY_RXDATA, 10, 2)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, ADDR_DIFF_ADJ, 6, 4)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, WR_ADDR_SYNC, 3, 3)
    FIELD(CH3_COE_STATUS_RXGBOX_FIFO_4, RD_ADDR_SYNC, 0, 3)
REG32(CH3_COE_STATUS_8B10BEB_RESET_0, 0x2db8)
REG32(CH3_COE_STATUS_8B10BEB_RESET_1, 0x2dbc)
REG32(CH3_COESTATUS_PMA_0, 0x2dc0)
    FIELD(CH3_COESTATUS_PMA_0, RX_PKDET_AS, 23, 1)
    FIELD(CH3_COESTATUS_PMA_0, TXSWING_OUT_LOW_AS, 22, 1)
    FIELD(CH3_COESTATUS_PMA_0, TXSWING_OUT_HIGH_AS, 21, 1)
    FIELD(CH3_COESTATUS_PMA_0, TX_QPISENN_AS, 19, 1)
    FIELD(CH3_COESTATUS_PMA_0, TX_DCC_READY_AS, 18, 1)
    FIELD(CH3_COESTATUS_PMA_0, RX_QPISENP_AS, 17, 1)
    FIELD(CH3_COESTATUS_PMA_0, RX_QPISENN_AS, 16, 1)
    FIELD(CH3_COESTATUS_PMA_0, RX_DXDS_CALDONE_AS, 11, 1)
    FIELD(CH3_COESTATUS_PMA_0, CDR_SLIP_RDY_AS, 10, 1)
    FIELD(CH3_COESTATUS_PMA_0, CDR_SRSTSTATUS_AS, 9, 1)
    FIELD(CH3_COESTATUS_PMA_0, CDR_WALKDONE_AS, 8, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_LOSSDATA_AS, 7, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_LCKSTATUS_AS, 6, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_CALENDAC_AS, 5, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_OVWRRDY1_AS, 4, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_OVWRRDY0_AS, 3, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_CDRLOCK_AS, 2, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_CALTIMEOUT_AS, 1, 1)
    FIELD(CH3_COESTATUS_PMA_0, ADAPT_CALDONE_AS, 0, 1)
REG32(CH3_COE_STATUS_PLL_STATUS, 0x2dc4)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_RSTB_INT, 18, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_REFDIVRSTB_INT, 17, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_RESET_LOOP_DONE, 15, 2)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_PWRDN_B, 14, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_RST_ERR, 13, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_REFLOSS, 12, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_FBLOSS, 11, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_UNLOCK, 10, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_CRSCODE, 3, 7)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_FINE_EN, 2, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_VCO_SEL, 1, 1)
    FIELD(CH3_COE_STATUS_PLL_STATUS, PLL_FREQLOCK, 0, 1)
REG32(CH3_COESTATUS_PMA_1, 0x2dc8)
    FIELD(CH3_COESTATUS_PMA_1, ILO_MODE_TUNE_AS, 13, 2)
    FIELD(CH3_COESTATUS_PMA_1, ILO_CLK_LOST_AS, 12, 1)
    FIELD(CH3_COESTATUS_PMA_1, ILO_FBCLK_LOST_AS, 11, 1)
    FIELD(CH3_COESTATUS_PMA_1, ILO_FINE_EN_AS, 10, 1)
    FIELD(CH3_COESTATUS_PMA_1, ILO_FTL_TUNE_AS, 2, 8)
    FIELD(CH3_COESTATUS_PMA_1, UNLOCK_ILO_AS, 1, 1)
    FIELD(CH3_COESTATUS_PMA_1, ILO_LOCK_AS, 0, 1)
REG32(CH3_COESTATUS_RX_FABRIC_INTF0, 0x2dcc)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXSTARTOFSEQ, 17, 2)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXVALID, 16, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, COMWAKE, 15, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, COMSAS, 14, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, COMINIT, 13, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXCLKCORCNT, 11, 2)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXBUFSTATUS, 8, 3)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXCHANREALIGN, 7, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXCHANISALIGNED, 6, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXCHANBONDSEQ, 5, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF0, RXCHBONDO, 0, 5)
REG32(CH3_COESTATUS_RX_FABRIC_INTF1, 0x2dd0)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF1, RXSLIPDONE, 4, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF1, RXSLIDERDY, 3, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF1, RXCOMMADET, 2, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF1, RXBYTEREALIGN, 1, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF1, RXBYTEISALIGNED, 0, 1)
REG32(CH3_COESTATUS_RX_FABRIC_INTF2, 0x2dd4)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF2, DMON_FIFO_STATUS, 3, 2)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF2, EYESCANDATAERROR, 2, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF2, RXPRBSLOCKED, 1, 1)
    FIELD(CH3_COESTATUS_RX_FABRIC_INTF2, RXPRBSERR, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_PIPE_RESET, 0x2dd8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, ILO_LOCK_R, 31, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, GT_POWERGOOD_R, 30, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RPLL_LOCK_R, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_LOCK_R, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_DONE_R, 27, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TX_PMA_RESETDONE_R, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RX_PMA_RESETDONE_R, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TXRESET_DONE_R, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RXRESET_DONE_R, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_DONE_R, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_DONE_R, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, PHYSTATUS_R, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RPLL_PD_INT_DLY, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RPLL_RESET_INT_DLY, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_PD_INT_DLY, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, LCPLL_RESET_INT_DLY, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TXPROGDIV_RESET_INT_DLY, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, PMA_RESET_INT_DLY, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, PCS_RESET_INT_DLY, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, USER_RDY_INT_DLY, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_INT, 11, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_INT, 10, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, PHY_READY_INT, 9, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, BUFGT_PHY_READY, 8, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, TXSYNC_RESET_CNT, 6, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, RXSYNC_RESET_CNT, 4, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RESET, FSM_PIPE_RST_CTRL, 0, 4)
REG32(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, 0x2ddc)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_SYNC, 31, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_INT, 30, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_R, 28, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SIGVALID_DELAY, 24, 4)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_SYNC, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_SYNC, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RX_CDR_ALIGN_DONE_SYNC, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN34_EIOS_DET_R, 19, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_EIOS_DET_R, 17, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_IN_PROGRESS_R, 15, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_ENTER, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_ENTER, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G12_EI_EXIT, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, G34_EI_EXIT, 11, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, SRIS_MODE, 10, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, COMMON_REF_MODE, 9, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, FSM_CDR_CTRL, 6, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRFREQRESET, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDR_ALGN_REQ, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RATE_CHANGE_DET, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, GEN12_RATE, 1, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL, RXCDRHOLD_IN, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, 0x2de0)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE_FROM_TO_ESM, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK_R, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_SEL_INT, 25, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, FSM_BUFG, 22, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CTRL_IN_PROGRESS, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_RESET_INT, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_CE_INT, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_RESET_MASK_INT, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_PIPECLK_CE_MASK_INT, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_RESET_MASK_INT, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFG_MACCLK_CE_MASK_INT, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, DIV_PIPECLK_INT, 12, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, BUFGT_RATE, 9, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RPLL_LOCK, 8, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, RATE_CHANGE, 7, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, PHY_READY, 6, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER, 1, 5)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL, COUNTER_DONE, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_PIPE_PD, 0x2de4)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RXNEW_PD, 30, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RXCURRENT_PD, 28, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TXNEW_PD, 26, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TXCURRENT_PD, 24, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, BEACON, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, PWRUPTX, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, PWRUPTXDRV, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, PWRUPRX, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, PWRUPDET, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RPLL_PD_SA, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, LCPLL_PD_SA, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TXPMA_PWRDN_B_SA, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TXDRVPWRDN_B_SA, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RX_PDB_SA, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, OOB_PDB_SA, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TXSERPWRDN_B_SA, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RXCKMUXPWRDN_B_SA, 11, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TXCKMUXPWRDN_B_SA, 10, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TX_VREG_PDB_SA, 9, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RX_VREG_PDB_SA, 8, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TX_P_CHANGE, 7, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RX_P_CHANGE, 6, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN_PULSE, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, PHYSTATUS_PWRDWN, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, CLR_PHYSTATUS, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, SET_PHYSTATUS, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, TX_P2_CHANGE, 1, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_PD, RX_P2_CHANGE, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, 0x2de8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_BYPASS, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_AS, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_AS, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SA_REG, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETPOLL_SA_REG, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_EN_SA_REG, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_D, 17, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART01, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ZERO, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_ONE, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ZERO, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER_ONE, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_DONE, 11, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDETSTART_SYNC, 10, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, PRECHARGE_COUNTER, 7, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVREF_EN, 6, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVPRESENT_SYNC, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVABSENT_SYNC, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET, RCVDET_C_DELAY, 0, 4)
REG32(CH3_COESTATUS_CHANNEL_PIPE_STAT, 0x2dec)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_128B130B, 29, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_8B10B, 26, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RCVABSENT_SYNC, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RCVPRESENT_SYNC, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RST_PERIOD_SYNC, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RATE_SYNC, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_1, 19, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_PIPE_0, 16, 3)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_UNDERFLOW_8B10B, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXSTATUS_OVERFLOW_8B10B, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXNOTINTABLE_8B10B, 12, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXDISPERR_8B10B, 10, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXCLKCORCNT_EARLY_8B10B, 8, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, ENB_NOTINTABLE, 6, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, ENB_DISPERR, 4, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_RCVDET, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS_PWRDWN, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, PHYSTATUS, 1, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_STAT, RXRATEDONE, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_TX_EQ, 0x2df0)
    FIELD(CH3_COESTATUS_CHANNEL_TX_EQ, TXDRVBIASP_SA, 21, 5)
    FIELD(CH3_COESTATUS_CHANNEL_TX_EQ, TXEMPPRE_SA, 16, 5)
    FIELD(CH3_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_SA, 9, 7)
    FIELD(CH3_COESTATUS_CHANNEL_TX_EQ, TXEMPPOS_SA, 4, 5)
    FIELD(CH3_COESTATUS_CHANNEL_TX_EQ, TXEMPMAIN_INDEP_SA, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_EQ, TXPDRVAMP_SA, 0, 3)
REG32(CH3_COESTATUS_CHANNEL_TX_ELEC, 0x2df4)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_PCIE_SATA, 31, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_USB3, 30, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXCOMINIT_TXPHYCLK, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, P0_LOOPBACK_PERIOD, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXCOMSAS_TXPHYCLK, 27, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXCOMWAKE_TXPHYCLK, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, COMSTART_TXPHYCLK, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_PCIE_USB3, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA_DELAY, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_SEL, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, P0_DATA_PERIOD, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, P0_LFPS_PERIOD, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, P0_TRISTATE_PERIOD, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, USB3_P23_RXDETECTION_PERIOD, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_TRISTATE_PERIOD, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, P1_P2_P3_LFPS_PERIOD, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, USB3_TRISTATE_PERIOD, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TX_SQUELCH_SA, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXELECIDLE_INT, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, SATA_WORDCOUNT, 10, 3)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, USB3_LFPS_PERIOD, 9, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TXELEC_LFPS, 8, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, TX_OOB_SIGSEL, 6, 2)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, PCIE_RXLOOPBACK, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, RCVDETSTART, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, COMSTATE, 2, 2)
    FIELD(CH3_COESTATUS_CHANNEL_TX_ELEC, COMTYPE, 0, 2)
REG32(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, 0x2df8)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_ILO_RESET, 29, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_RXELECIDLE, 28, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, SIGVALID_INT, 27, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_OOBSIGVAL_AS, 26, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PMA_RESET, 25, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PMA_RESET, 24, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_PCS_RESET, 23, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_PCS_RESET, 22, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXPROGDIV_RESET, 21, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_TXPROGDIV_RESET, 20, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHY_READY, 19, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RATE_CHANGE_IN_PROGRESS, 18, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_TXSYNC_RESET, 17, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RXSYNC_RESET, 16, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_RPLL_RESET, 15, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_RPLL_RESET, 14, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RST_LCPLL_RESET, 13, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PIPE_RATE_LCPLL_RESET, 12, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PROGDIVRESET_DONE, 11, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_PMA_RESETDONE, 10, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_PMA_RESETDONE, 9, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TX_RESETDONE, 8, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RX_RESETDONE, 7, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_LOCK, 5, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RPLL_RESETDONE, 4, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, LCPLL_RESETDONE, 3, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, PHYSTATUS_INT, 2, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, TXSYNC_DONE, 1, 1)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0, RXSYNC_DONE, 0, 1)
REG32(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, 0x2dfc)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE, 30, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, LFPSSTATE_CP7, 28, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, FE_PMA_LPBK_FIFO_STATUS, 26, 2)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_IN, 12, 4)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_IN, 8, 4)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTNORTH_OUT, 4, 4)
    FIELD(CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1, PIPE_DISTSOUTH_OUT, 0, 4)
REG32(CH3_COESTATUS_ADAPT_LOOP_00, 0x2e80)
REG32(CH3_COESTATUS_ADAPT_LOOP_01, 0x2e84)
REG32(CH3_COESTATUS_ADAPT_LOOP_02, 0x2e88)
REG32(CH3_COESTATUS_ADAPT_LOOP_03, 0x2e8c)
REG32(CH3_COESTATUS_ADAPT_LOOP_04, 0x2e90)
REG32(CH3_COESTATUS_ADAPT_LOOP_05, 0x2e94)
REG32(CH3_COESTATUS_ADAPT_LOOP_06, 0x2e98)
REG32(CH3_COESTATUS_ADAPT_LOOP_07, 0x2e9c)
REG32(CH3_COESTATUS_ADAPT_LOOP_08, 0x2ea0)
REG32(CH3_COESTATUS_ADAPT_LOOP_09, 0x2ea4)
REG32(CH3_COESTATUS_ADAPT_LOOP_10, 0x2ea8)
REG32(CH3_COESTATUS_ADAPT_LOOP_11, 0x2eac)
REG32(RCALBG_RCALBG_TOP_CFG0, 0x3000)
    FIELD(RCALBG_RCALBG_TOP_CFG0, RCALSAP_TESTEN, 1, 1)
    FIELD(RCALBG_RCALBG_TOP_CFG0, RCAL_APROBE, 0, 1)
REG32(RCALBG_RCALBG_TOP_CFG1, 0x3004)
REG32(MEMCELLX3008, 0x3008)
    FIELD(MEMCELLX3008, QUAD_SIM_MODE, 28, 4)
    FIELD(MEMCELLX3008, QUAD_SIM_RESET_SPEEDUP, 27, 1)
    FIELD(MEMCELLX3008, SIM_DEVICE, 24, 3)
    FIELD(MEMCELLX3008, HSCLK1_INSTANTIATED, 22, 1)
    FIELD(MEMCELLX3008, HSCLK0_INSTANTIATED, 21, 1)
    FIELD(MEMCELLX3008, QUAD_INSTANTIATED, 20, 1)
REG32(CTRL_RSV_CFG0, 0x300c)
    FIELD(CTRL_RSV_CFG0, CH3_RX_RPLL_RESET_EN, 31, 1)
    FIELD(CTRL_RSV_CFG0, CH2_RX_RPLL_RESET_EN, 30, 1)
    FIELD(CTRL_RSV_CFG0, CH1_RX_RPLL_RESET_EN, 29, 1)
    FIELD(CTRL_RSV_CFG0, CH0_RX_RPLL_RESET_EN, 28, 1)
    FIELD(CTRL_RSV_CFG0, VCTRL3_RPLL, 20, 5)
    FIELD(CTRL_RSV_CFG0, VCTRL2_RPLL, 15, 5)
    FIELD(CTRL_RSV_CFG0, UB_PCIE_RESET_EN, 8, 1)
    FIELD(CTRL_RSV_CFG0, RXMARGIN_RSTSEL, 6, 2)
    FIELD(CTRL_RSV_CFG0, MST_RST_ON_PCIERESET, 5, 1)
    FIELD(CTRL_RSV_CFG0, DMON_LENGTH, 3, 2)
    FIELD(CTRL_RSV_CFG0, DMON_CH_SEL, 1, 2)
    FIELD(CTRL_RSV_CFG0, DMON_EN, 0, 1)
REG32(RCALBG_RCALBG_TOP_CFG2, 0x3010)
REG32(RCALBG_RCALBG_TOP_CFG3, 0x3014)
REG32(RCALBG_RCALBG_TOP_CFG4, 0x3020)
REG32(RCALBG_RCALBG_TOP_CFG5, 0x3024)
REG32(HSCLK0_LCPLL_LGC_CFG0, 0x3030)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_AUTO_FINE_EN, 31, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_FINE_SWEEP, 29, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_OVRD_MODE, 27, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_CRSACCY, 25, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_MONCLKCYCLE, 22, 3)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_PLLLOCKCOARSE, 20, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_PLLLOCKFACTOR, 18, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_UNLOCKCTRL, 16, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_VCTRL_LATCH_BYPASS, 15, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_BYP_LOCKDETECT, 13, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_COARSE_FREQ_OVRD_EN, 12, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLLLOCKEN, 11, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_ALLOW_LB2UB, 10, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_ALLOW_UB2LB, 9, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_VCO_SEL_AUTO, 8, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_VCO_SEL, 7, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG0, LCPLL_COARSE_FREQ_OVRD, 0, 7)
REG32(HSCLK0_LCPLL_LGC_CFG1, 0x3034)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, PLL_RESET_DLY_TIME, 24, 8)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, SDM_RESET_DLY_TIME, 20, 4)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, SDM_LOOP_BYPASS_HANDSHAKE, 19, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, PRESCALE_DIV, 17, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, RESET_ON_PWRDN, 16, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, LCPLL_BIN_ORDER, 13, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, LCPLL_SDM_ORDER, 11, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, SDM_WIDTHSEL, 9, 2)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, RATESEL, 8, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, BYPASS, 7, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, CLKSEL, 6, 1)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, TESTCON, 1, 5)
    FIELD(HSCLK0_LCPLL_LGC_CFG1, TESTEN, 0, 1)
REG32(HSCLK0_LCPLL_LGC_CFG2, 0x3038)
    FIELD(HSCLK0_LCPLL_LGC_CFG2, SDM_SEED, 0, 25)
REG32(HSCLK0_LCPLL_CFG0, 0x303c)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_VCTRL_RESET, 28, 4)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_PREDIV, 20, 5)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_CP, 10, 10)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_VREG_GILTER_BYPASS, 9, 1)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_VREG_EN, 8, 1)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_VREG_GILTER_CTRL, 3, 5)
    FIELD(HSCLK0_LCPLL_CFG0, LCPLL_VCCSEL, 0, 3)
REG32(UB_CFG0, 0x3040)
    FIELD(UB_CFG0, MEM_CTRL, 20, 12)
    FIELD(UB_CFG0, AEN_MB_PWRUPEN, 15, 1)
    FIELD(UB_CFG0, WAKEUP, 12, 1)
    FIELD(UB_CFG0, AEN_MBRST, 9, 1)
    FIELD(UB_CFG0, MBRST, 4, 1)
    FIELD(UB_CFG0, QDCM_PWRDN, 3, 1)
    FIELD(UB_CFG0, INTERRUPT_REQ, 1, 1)
REG32(TERMPROG_CFG, 0x3044)
    FIELD(TERMPROG_CFG, RXTERM_CODE, 7, 5)
    FIELD(TERMPROG_CFG, TXTERM_CODE, 2, 5)
    FIELD(TERMPROG_CFG, RXTERM_OVRD, 1, 1)
    FIELD(TERMPROG_CFG, TXTERM_OVRD, 0, 1)
REG32(MEMCELLX3048, 0x3048)
    FIELD(MEMCELLX3048, HS0_LCPLL_IPS_PIN_EN, 27, 1)
    FIELD(MEMCELLX3048, HS0_LCPLL_IPS_REFCLK_SEL, 24, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP7, 21, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP6, 18, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP5, 15, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP4, 12, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP3, 9, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP2, 6, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP1, 3, 3)
    FIELD(MEMCELLX3048, HS0_LCPLL_REFCLK_MAP0, 0, 3)
REG32(MEMCELLX304C, 0x304c)
    FIELD(MEMCELLX304C, HS0_RPLL_IPS_PIN_EN, 27, 1)
    FIELD(MEMCELLX304C, HS0_RPLL_IPS_REFCLK_SEL, 24, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP7, 21, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP6, 18, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP5, 15, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP4, 12, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP3, 9, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP2, 6, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP1, 3, 3)
    FIELD(MEMCELLX304C, HS0_RPLL_REFCLK_MAP0, 0, 3)
REG32(HSCLK0_LCPLL_CFG1, 0x3070)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_REGMON_EN, 31, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_VCTMON_EN, 30, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_VBG_EN, 29, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_AVCC_EN, 28, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_ICPMON_EN, 27, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_RDAC_CTB, 19, 2)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_RCTRL, 15, 4)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_VCO_TCOMP_EN, 14, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_SCTRL_BYPS, 13, 1)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_IVCO_CNTRL, 8, 5)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_SVCO_CNTRL, 2, 6)
    FIELD(HSCLK0_LCPLL_CFG1, LCPLL_RP_COMP, 0, 2)
REG32(HSCLK0_LCPLL_CFG2, 0x3074)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_LPF, 16, 16)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_REFCLK_EN, 15, 1)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_DIV2OPT, 14, 1)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_DIG_MON, 13, 1)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_FBCLK_EN, 12, 1)
    FIELD(HSCLK0_LCPLL_CFG2, DIV2OPT_EN, 11, 1)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_DYNSEL, 3, 1)
    FIELD(HSCLK0_LCPLL_CFG2, LCPLL_REFCLK_SEL, 0, 3)
REG32(CH0_RESET_TIME_CFG0, 0x3078)
    FIELD(CH0_RESET_TIME_CFG0, TX_PCS_RESET_TIME, 25, 5)
    FIELD(CH0_RESET_TIME_CFG0, TX_PMA_RESET_TIME, 20, 5)
    FIELD(CH0_RESET_TIME_CFG0, TX_CLKGEN_RESET_TIME, 15, 5)
    FIELD(CH0_RESET_TIME_CFG0, TX_DCD_RESET_TIME, 10, 5)
    FIELD(CH0_RESET_TIME_CFG0, ILO_RESET_TIME, 0, 5)
REG32(CH0_RESET_TIME_CFG1, 0x307c)
    FIELD(CH0_RESET_TIME_CFG1, RX_PMA_RESET_TIME, 25, 5)
    FIELD(CH0_RESET_TIME_CFG1, RX_CLKGEN_RESET_TIME, 20, 5)
    FIELD(CH0_RESET_TIME_CFG1, RX_DCD_RESET_TIME, 15, 5)
    FIELD(CH0_RESET_TIME_CFG1, RX_CFOK_RESET_TIME, 10, 5)
    FIELD(CH0_RESET_TIME_CFG1, RX_PHALIGN_RESET_TIME, 5, 5)
    FIELD(CH0_RESET_TIME_CFG1, TX_PHALIGN_RESET_TIME, 0, 5)
REG32(CH0_RESET_TIME_CFG2, 0x3080)
    FIELD(CH0_RESET_TIME_CFG2, RX_BUF_RESET_TIME, 25, 5)
    FIELD(CH0_RESET_TIME_CFG2, RX_PRBS_RESET_TIME, 20, 5)
    FIELD(CH0_RESET_TIME_CFG2, RX_PCS_RESET_TIME, 15, 5)
    FIELD(CH0_RESET_TIME_CFG2, RX_DFE_RESET_TIME, 10, 5)
    FIELD(CH0_RESET_TIME_CFG2, RX_CDRFREQ_RESET_TIME, 5, 5)
    FIELD(CH0_RESET_TIME_CFG2, RX_CDRPHASE_RESET_TIME, 0, 5)
REG32(CH0_RESET_TIME_CFG3, 0x3084)
    FIELD(CH0_RESET_TIME_CFG3, TX_DAPI_RESET_TIME, 29, 3)
    FIELD(CH0_RESET_TIME_CFG3, RX_DAPI_RESET_TIME, 26, 3)
    FIELD(CH0_RESET_TIME_CFG3, TX_DAPIDIV_RESET_TIME, 21, 5)
    FIELD(CH0_RESET_TIME_CFG3, RX_DAPIDIV_RESET_TIME, 16, 5)
    FIELD(CH0_RESET_TIME_CFG3, RX_PROGDIV_RESET_TIME, 13, 3)
    FIELD(CH0_RESET_TIME_CFG3, TX_PROGDIV_RESET_TIME, 10, 3)
    FIELD(CH0_RESET_TIME_CFG3, RX_EYESCAN_RESET_TIME, 5, 5)
    FIELD(CH0_RESET_TIME_CFG3, RX_OOB_RESET_TIME, 0, 5)
REG32(CH0_RESET_LOOPER_ID_CFG, 0x3088)
    FIELD(CH0_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_END_ID, 28, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_START_ID, 24, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_END_ID, 20, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_START_ID, 16, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_END_ID, 12, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_START_ID, 8, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_END_ID, 4, 4)
    FIELD(CH0_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_START_ID, 0, 4)
REG32(CH0_RESET_LOOP_ID_CFG0, 0x308c)
    FIELD(CH0_RESET_LOOP_ID_CFG0, TX_PCS_RESET_LOOP_ID, 12, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG0, TX_PMA_RESET_LOOP_ID, 8, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG0, TX_CLKGEN_RESET_LOOP_ID, 4, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG0, TX_DCD_RESET_LOOP_ID, 0, 4)
REG32(CH0_RESET_LOOP_ID_CFG1, 0x3090)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_PCS_RESET_LOOP_ID, 28, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_DFE_RESET_LOOP_ID, 24, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_CDRFREQ_RESET_LOOP_ID, 20, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_CDRPHASE_RESET_LOOP_ID, 16, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_PMA_RESET_LOOP_ID, 12, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_CLKGEN_RESET_LOOP_ID, 8, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_DCD_RESET_LOOP_ID, 4, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG1, RX_CFOK_RESET_LOOP_ID, 0, 4)
REG32(CH0_RESET_LOOP_ID_CFG2, 0x3094)
    FIELD(CH0_RESET_LOOP_ID_CFG2, RX_OOB_RESET_LOOP_ID, 12, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG2, RX_EYESCAN_RESET_LOOP_ID, 8, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG2, RX_BUF_RESET_LOOP_ID, 4, 4)
    FIELD(CH0_RESET_LOOP_ID_CFG2, RX_PRBS_RESET_LOOP_ID, 0, 4)
REG32(CH0_RESET_BYP_HDSHK_CFG, 0x3098)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDAPI_RESET_LOOP, 9, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDAPI_RESET_LOOP, 8, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CDR_RESET_LOOP, 7, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDCD_RESET_LOOP, 6, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CFOK_RESET_LOOP, 5, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RX_PHALIGN_RESET_LOOP, 4, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PHALIGN_RESET_LOOP, 3, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDCD_RESET_LOOP, 2, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PCS_RESET_LOOP, 1, 1)
    FIELD(CH0_RESET_BYP_HDSHK_CFG, BYP_HDSHK_ILO_RESET_LOOP, 0, 1)
REG32(CH0_RESET_CFG, 0x309c)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_EIDLE_LO_CNT, 28, 4)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_EIDLE_HI_CNT, 24, 4)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_ON_EIDLE, 23, 1)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_ON_COMMAALIGN, 22, 1)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_DEFER_EN, 21, 1)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_ON_RXVALID, 20, 1)
    FIELD(CH0_RESET_CFG, EB8B10B_RESET_ON_UNALIGN, 19, 1)
    FIELD(CH0_RESET_CFG, HSDP_MST_RESET_EN, 16, 1)
    FIELD(CH0_RESET_CFG, TXPHYCLK_FREQ_CNT_EN, 15, 1)
    FIELD(CH0_RESET_CFG, TXPCSCLK_FREQ_CNT_EN, 14, 1)
    FIELD(CH0_RESET_CFG, TXUSRCLK_FREQ_CNT_EN, 13, 1)
    FIELD(CH0_RESET_CFG, RXPHYCLK_FREQ_CNT_EN, 12, 1)
    FIELD(CH0_RESET_CFG, RXPCSCLK_FREQ_CNT_EN, 11, 1)
    FIELD(CH0_RESET_CFG, RXUSRCLK_FREQ_CNT_EN, 10, 1)
    FIELD(CH0_RESET_CFG, CDR_SOFTRESET_MODE, 7, 1)
    FIELD(CH0_RESET_CFG, ILORESET_BYPASS_MODE, 6, 1)
    FIELD(CH0_RESET_CFG, ILORESET_ON_PLLLOCK, 5, 1)
    FIELD(CH0_RESET_CFG, ILORESET_PLLLOCK_SEL, 4, 1)
    FIELD(CH0_RESET_CFG, RX_PMA_RST_SYNC_DISABLE, 3, 1)
    FIELD(CH0_RESET_CFG, PRESCALE_DIV, 0, 3)
REG32(MEMCELLX30A0, 0x30a0)
    FIELD(MEMCELLX30A0, CH0_INSTANTIATED, 31, 1)
    FIELD(MEMCELLX30A0, CH0_SIM_TX_EIDLE_DRIVE_LEVEL, 6, 2)
    FIELD(MEMCELLX30A0, CH0_SIM_RESET_SPEEDUP, 5, 1)
    FIELD(MEMCELLX30A0, CH0_SIM_RECEIVER_DETECT_PASS, 4, 1)
    FIELD(MEMCELLX30A0, CH0_SIM_MODE, 0, 4)
REG32(CH0_TX_ANA_CFG0, 0x30a4)
    FIELD(CH0_TX_ANA_CFG0, TX_VREG_CTRL, 6, 3)
    FIELD(CH0_TX_ANA_CFG0, TX_VREG_VREFSEL, 4, 2)
    FIELD(CH0_TX_ANA_CFG0, TX_LPK_SARC_ENB, 3, 1)
REG32(CH0_TX_DRV_CFG0, 0x30a8)
    FIELD(CH0_TX_DRV_CFG0, TX_REG_COMP_EN, 31, 1)
    FIELD(CH0_TX_DRV_CFG0, TX_REG_SCALE_SEL, 25, 6)
    FIELD(CH0_TX_DRV_CFG0, TX_CTL_DRV_OVR_EN, 24, 1)
    FIELD(CH0_TX_DRV_CFG0, TX_CTL_DRV_EN, 20, 4)
    FIELD(CH0_TX_DRV_CFG0, TX_REFBIAS_ENB_IPP, 19, 1)
    FIELD(CH0_TX_DRV_CFG0, TX_REFBIAS_EN_AVCC, 18, 1)
    FIELD(CH0_TX_DRV_CFG0, TX_QPI_STATEN, 4, 1)
    FIELD(CH0_TX_DRV_CFG0, TX_TXLPK_DRVHIZ, 3, 1)
    FIELD(CH0_TX_DRV_CFG0, TX_SW_MEAS, 0, 3)
REG32(CH0_TX_DRV_CFG1, 0x30ac)
    FIELD(CH0_TX_DRV_CFG1, TX_VCTRLN_ADJ_EN, 31, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_VCTRLP_ADJ_EN, 30, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_ZRES_RATIO_SEL, 22, 5)
    FIELD(CH0_TX_DRV_CFG1, TX_ZCTRLP_OVR_EN, 21, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_ZCTRLP_OVR_SEL, 19, 2)
    FIELD(CH0_TX_DRV_CFG1, TX_ZCTRLN_OVR_EN, 18, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_ZCTRLN_OVR_SEL, 16, 2)
    FIELD(CH0_TX_DRV_CFG1, TX_REGP_PDB, 12, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_REGN_PDB, 11, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_VSWING_SEL_OVR_EN, 10, 1)
    FIELD(CH0_TX_DRV_CFG1, TX_REGP_VSWING_SEL_OVR, 4, 6)
    FIELD(CH0_TX_DRV_CFG1, TX_REGN_VSWING_SEL_OVR, 0, 4)
REG32(CH0_CHL_RSV_CFG0, 0x30b0)
    FIELD(CH0_CHL_RSV_CFG0, EB8B10B_RESET_RXVALID_DELAY, 28, 4)
    FIELD(CH0_CHL_RSV_CFG0, UBALZE_GPI_OUT1_SEL, 17, 2)
    FIELD(CH0_CHL_RSV_CFG0, UB_REPROG_DONE_RXPD_BYPASS, 16, 1)
    FIELD(CH0_CHL_RSV_CFG0, RXPOWERDOWN_UBLAZE_CTRL_EN, 15, 1)
    FIELD(CH0_CHL_RSV_CFG0, RXTERMINATION_OVRD, 13, 2)
    FIELD(CH0_CHL_RSV_CFG0, UB_REPROG_DONE_TXPD_BYPASS, 12, 1)
    FIELD(CH0_CHL_RSV_CFG0, UBALZE_GPI_OUT3_SEL, 10, 2)
    FIELD(CH0_CHL_RSV_CFG0, TXPOWERDOWN_UBLAZE_CTRL_EN, 9, 1)
    FIELD(CH0_CHL_RSV_CFG0, PD_TRANS_TIME_CPMIN, 0, 9)
REG32(CH0_TX_SER_CFG0, 0x30b4)
    FIELD(CH0_TX_SER_CFG0, TX_SEL_CLK_DLY, 10, 2)
    FIELD(CH0_TX_SER_CFG0, CLK_SEL_CLK_STG2, 8, 2)
    FIELD(CH0_TX_SER_CFG0, TX_SEL_CLK_PCS, 4, 4)
    FIELD(CH0_TX_SER_CFG0, TX_ENABLE_STG1, 3, 1)
REG32(CH0_RX_CDR_CFG0, 0x30b8)
    FIELD(CH0_RX_CDR_CFG0, SELMODE, 31, 1)
    FIELD(CH0_RX_CDR_CFG0, DATAWIDTH_OVR, 27, 4)
    FIELD(CH0_RX_CDR_CFG0, LOWLATENCY_OVR, 26, 1)
    FIELD(CH0_RX_CDR_CFG0, S_SEL, 20, 2)
    FIELD(CH0_RX_CDR_CFG0, D_SEL_Y, 19, 1)
    FIELD(CH0_RX_CDR_CFG0, D_SEL_P, 18, 1)
    FIELD(CH0_RX_CDR_CFG0, Y_SEL_X, 17, 1)
    FIELD(CH0_RX_CDR_CFG0, X_SEL_Y, 16, 1)
    FIELD(CH0_RX_CDR_CFG0, WALKSPEED_BM, 14, 2)
    FIELD(CH0_RX_CDR_CFG0, WALKSPEED_CMN, 12, 2)
    FIELD(CH0_RX_CDR_CFG0, TESTCON, 8, 3)
    FIELD(CH0_RX_CDR_CFG0, TESTSRC, 5, 3)
    FIELD(CH0_RX_CDR_CFG0, TESTRATESEL, 3, 2)
    FIELD(CH0_RX_CDR_CFG0, TESTCHCLKSEL, 2, 1)
    FIELD(CH0_RX_CDR_CFG0, TESTEN, 1, 1)
    FIELD(CH0_RX_CDR_CFG0, CDRENF, 0, 1)
REG32(CH0_RX_CDR_CFG1, 0x30bc)
    FIELD(CH0_RX_CDR_CFG1, DELTA_SAT_MODE, 28, 3)
    FIELD(CH0_RX_CDR_CFG1, DXD_VAL, 16, 12)
    FIELD(CH0_RX_CDR_CFG1, CFG_TOGGLE, 15, 1)
    FIELD(CH0_RX_CDR_CFG1, FREQ_SYMM, 14, 1)
    FIELD(CH0_RX_CDR_CFG1, WALKSPEED_SLIP, 12, 2)
    FIELD(CH0_RX_CDR_CFG1, SLIP_MAG, 10, 2)
    FIELD(CH0_RX_CDR_CFG1, SLIP_ENB, 9, 1)
    FIELD(CH0_RX_CDR_CFG1, PI_DDR_MODE, 8, 1)
    FIELD(CH0_RX_CDR_CFG1, FLIPCLKTOPI, 7, 1)
    FIELD(CH0_RX_CDR_CFG1, PICODE_D_OVR, 0, 7)
REG32(CH0_RX_CDR_CFG2, 0x30c0)
    FIELD(CH0_RX_CDR_CFG2, DXDSCAL_DSEL_OVR, 31, 1)
    FIELD(CH0_RX_CDR_CFG2, DXDSCAL_EN_OVR, 30, 1)
    FIELD(CH0_RX_CDR_CFG2, DXDSCAL_CYCLES, 27, 3)
    FIELD(CH0_RX_CDR_CFG2, DXDSCAL_DS_EN, 26, 1)
    FIELD(CH0_RX_CDR_CFG2, DXDSCAL_DX_EN, 25, 1)
    FIELD(CH0_RX_CDR_CFG2, RX_DCC_DONE_BYP, 24, 1)
    FIELD(CH0_RX_CDR_CFG2, VOTEWX, 13, 3)
    FIELD(CH0_RX_CDR_CFG2, VOTEWY, 10, 3)
    FIELD(CH0_RX_CDR_CFG2, PMULFAC, 7, 3)
    FIELD(CH0_RX_CDR_CFG2, PDIVFAC, 4, 3)
    FIELD(CH0_RX_CDR_CFG2, FDIVFAC, 0, 4)
REG32(CH0_RX_CDR_CFG3, 0x30c4)
    FIELD(CH0_RX_CDR_CFG3, PMULFACDYNTARGET, 24, 8)
    FIELD(CH0_RX_CDR_CFG3, PMULFACDYNSEL, 22, 2)
    FIELD(CH0_RX_CDR_CFG3, PMULFACDYNEN, 21, 1)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQFAC3, 19, 2)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQCNT3, 16, 3)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQFAC2, 14, 2)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQCNT2, 11, 3)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQFAC1, 9, 2)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQCNT1, 6, 3)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQFAC0, 4, 2)
    FIELD(CH0_RX_CDR_CFG3, PMULSEQCNT0, 1, 3)
    FIELD(CH0_RX_CDR_CFG3, PMULFACSEQEN, 0, 1)
REG32(CH0_RX_CDR_CFG4, 0x30c8)
    FIELD(CH0_RX_CDR_CFG4, METASTABLE_MODE, 29, 2)
    FIELD(CH0_RX_CDR_CFG4, BMCDR_MISC, 27, 2)
    FIELD(CH0_RX_CDR_CFG4, BMCDR_MAG, 22, 5)
    FIELD(CH0_RX_CDR_CFG4, BMCDR_WINDOW, 18, 4)
    FIELD(CH0_RX_CDR_CFG4, BMCDR_MODE, 16, 2)
    FIELD(CH0_RX_CDR_CFG4, FORCEFOS, 15, 1)
    FIELD(CH0_RX_CDR_CFG4, FOSCNT, 12, 3)
    FIELD(CH0_RX_CDR_CFG4, FOSVAL, 0, 12)
REG32(CH0_ADAPT_APT_CFG, 0x30cc)
REG32(CH0_ADAPT_CAL_CFG, 0x30d0)
    FIELD(CH0_ADAPT_CAL_CFG, OVWRFNSH, 31, 1)
    FIELD(CH0_ADAPT_CAL_CFG, OVWRDAC, 25, 6)
    FIELD(CH0_ADAPT_CAL_CFG, OVWRADD, 21, 4)
    FIELD(CH0_ADAPT_CAL_CFG, OVWRPLS0, 20, 1)
    FIELD(CH0_ADAPT_CAL_CFG, OVWRSKIP, 19, 1)
    FIELD(CH0_ADAPT_CAL_CFG, SEQMAX, 16, 3)
    FIELD(CH0_ADAPT_CAL_CFG, WAITSEL, 14, 2)
    FIELD(CH0_ADAPT_CAL_CFG, MSHIFT, 11, 3)
    FIELD(CH0_ADAPT_CAL_CFG, CAL_INITDAC, 5, 6)
    FIELD(CH0_ADAPT_CAL_CFG, CALSKIP, 4, 1)
    FIELD(CH0_ADAPT_CAL_CFG, TESTCON, 1, 3)
    FIELD(CH0_ADAPT_CAL_CFG, CAL_CFG0, 0, 1)
REG32(CH0_ADAPT_DFE_CFG, 0x30d4)
    FIELD(CH0_ADAPT_DFE_CFG, TRGTCON, 30, 2)
    FIELD(CH0_ADAPT_DFE_CFG, DFE_CFG1, 29, 1)
    FIELD(CH0_ADAPT_DFE_CFG, H3INITDAC, 23, 6)
    FIELD(CH0_ADAPT_DFE_CFG, H2INITDAC, 16, 7)
    FIELD(CH0_ADAPT_DFE_CFG, DFE_CFG0, 15, 1)
    FIELD(CH0_ADAPT_DFE_CFG, UTINITDAC, 7, 8)
    FIELD(CH0_ADAPT_DFE_CFG, VPINITDAC, 0, 7)
REG32(CH0_ADAPT_GC_CFG0, 0x30d8)
    FIELD(CH0_ADAPT_GC_CFG0, GC_CFG01, 31, 1)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_DISFREZ, 30, 1)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_CYCSEL, 28, 2)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_DIFFSEL, 26, 2)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_CLRSEL, 24, 2)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_ENSEL, 22, 2)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_INITDAC, 17, 5)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_SELTGT, 16, 1)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_GEARSEL, 14, 2)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_GAINWIN, 12, 2)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_CNTSEL, 9, 3)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_MSHIFT, 5, 4)
    FIELD(CH0_ADAPT_GC_CFG0, AGC1_WAITSEL, 3, 2)
    FIELD(CH0_ADAPT_GC_CFG0, GC_CFG00, 0, 3)
REG32(CH0_ADAPT_GC_CFG1, 0x30dc)
    FIELD(CH0_ADAPT_GC_CFG1, AGC1_HYSTER, 25, 7)
    FIELD(CH0_ADAPT_GC_CFG1, AGC1_TARGET, 17, 8)
    FIELD(CH0_ADAPT_GC_CFG1, GC_CFG10, 10, 7)
    FIELD(CH0_ADAPT_GC_CFG1, AGC1_UPBDAC, 5, 5)
    FIELD(CH0_ADAPT_GC_CFG1, AGC1_LOBDAC, 0, 5)
REG32(CH0_ADAPT_GC_CFG2, 0x30e0)
    FIELD(CH0_ADAPT_GC_CFG2, GC_CFG22, 31, 1)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_DISFREZ, 30, 1)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_CYCSEL, 28, 2)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_DIFFSEL, 26, 2)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_CLRSEL, 24, 2)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_ENSEL, 22, 2)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_INITDAC, 17, 5)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_SELTGT, 16, 1)
    FIELD(CH0_ADAPT_GC_CFG2, GC_CFG21, 9, 7)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_MSHIFT, 5, 4)
    FIELD(CH0_ADAPT_GC_CFG2, AGC2_WAITSEL, 3, 2)
    FIELD(CH0_ADAPT_GC_CFG2, GC_CFG20, 0, 3)
REG32(CH0_ADAPT_GC_CFG3, 0x30e4)
    FIELD(CH0_ADAPT_GC_CFG3, AGC2_HYSTER, 25, 7)
    FIELD(CH0_ADAPT_GC_CFG3, AGC2_TARGET, 17, 8)
    FIELD(CH0_ADAPT_GC_CFG3, GC_CFG30, 10, 7)
    FIELD(CH0_ADAPT_GC_CFG3, AGC2_UPBDAC, 5, 5)
    FIELD(CH0_ADAPT_GC_CFG3, AGC2_LOBDAC, 0, 5)
REG32(CH0_ADAPT_GEN_CFG0, 0x30e8)
    FIELD(CH0_ADAPT_GEN_CFG0, PCSFLIP, 31, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, BAUDFLIP, 30, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, POWRDN, 29, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, CALCKON, 28, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, GE_CFG00, 27, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, CDRLOCK_DET1_DISLOOP, 26, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, CDRLOCK_DET0_DISLOOP, 25, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, CDRLOCK_DIS_DISLOOP, 24, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, OS_DISLOOP, 23, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, GC2_DISLOOP, 22, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, GC1_DISLOOP, 21, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, KLTUNE_DISLOOP, 20, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, KL_DISLOOP, 19, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, KHCLOAD_DISLOOP, 18, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, KHRDEG_DISLOOP, 17, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, KHCDEG_DISLOOP, 16, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, HF_DISLOOP, 15, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, HE_DISLOOP, 14, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, HD_DISLOOP, 13, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, HC_DISLOOP, 12, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, HB_DISLOOP, 11, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, HA_DISLOOP, 10, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H9_DISLOOP, 9, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H8_DISLOOP, 8, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H7_DISLOOP, 7, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H6_DISLOOP, 6, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H5_DISLOOP, 5, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H4_DISLOOP, 4, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H3_DISLOOP, 3, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, H2_DISLOOP, 2, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, UT_DISLOOP, 1, 1)
    FIELD(CH0_ADAPT_GEN_CFG0, VP_DISLOOP, 0, 1)
REG32(CH0_ADAPT_GEN_CFG1, 0x30ec)
    FIELD(CH0_ADAPT_GEN_CFG1, SELHALF, 31, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, TESTC, 27, 4)
    FIELD(CH0_ADAPT_GEN_CFG1, CDRLOCK_DET1_POWRDN, 26, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, CDRLOCK_DET0_POWRDN, 25, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, CDRLOCK_DIS_POWRDN, 24, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, OS_POWRDN, 23, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, GC2_POWRDN, 22, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, GC1_POWRDN, 21, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, KLTUNE_POWRDN, 20, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, KL_POWRDN, 19, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, KHCLOAD_POWRDN, 18, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, KHRDEG_POWRDN, 17, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, KHCDEG_POWRDN, 16, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, HF_POWRDN, 15, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, HE_POWRDN, 14, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, HD_POWRDN, 13, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, HC_POWRDN, 12, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, HB_POWRDN, 11, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, HA_POWRDN, 10, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H9_POWRDN, 9, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H8_POWRDN, 8, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H7_POWRDN, 7, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H6_POWRDN, 6, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H5_POWRDN, 5, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H4_POWRDN, 4, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H3_POWRDN, 3, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, H2_POWRDN, 2, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, UT_POWRDN, 1, 1)
    FIELD(CH0_ADAPT_GEN_CFG1, VP_POWRDN, 0, 1)
REG32(CH0_ADAPT_GEN_CFG2, 0x30f0)
    FIELD(CH0_ADAPT_GEN_CFG2, APTCTRL2, 31, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, MODSEL, 29, 2)
    FIELD(CH0_ADAPT_GEN_CFG2, SELCDR, 28, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, DISDYN, 27, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, CDRLOCK_DET1_EXHOLD, 26, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, CDRLOCK_DET0_EXHOLD, 25, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, CDRLOCK_DIS_EXHOLD, 24, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, OS_EXHOLD, 23, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, GC2_EXHOLD, 22, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, GC1_EXHOLD, 21, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, KLTUNE_EXHOLD, 20, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, KL_EXHOLD, 19, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, KHCLOAD_EXHOLD, 18, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, KHRDEG_EXHOLD, 17, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, KHCDEG_EXHOLD, 16, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, HF_EXHOLD, 15, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, HE_EXHOLD, 14, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, HD_EXHOLD, 13, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, HC_EXHOLD, 12, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, HB_EXHOLD, 11, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, HA_EXHOLD, 10, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H9_EXHOLD, 9, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H8_EXHOLD, 8, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H7_EXHOLD, 7, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H6_EXHOLD, 6, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H5_EXHOLD, 5, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H4_EXHOLD, 4, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H3_EXHOLD, 3, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, H2_EXHOLD, 2, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, UT_EXHOLD, 1, 1)
    FIELD(CH0_ADAPT_GEN_CFG2, VP_EXHOLD, 0, 1)
REG32(CH0_ADAPT_GEN_CFG3, 0x30f4)
    FIELD(CH0_ADAPT_GEN_CFG3, GEAREN, 31, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, GEARCTRL, 27, 4)
    FIELD(CH0_ADAPT_GEN_CFG3, CDRLOCK_DET1_OVWREN, 26, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, CDRLOCK_DET0_OVWREN, 25, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, CDRLOCK_DIS_OVWREN, 24, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, OS_OVWREN, 23, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, GC2_OVWREN, 22, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, GC1_OVWREN, 21, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, KLTUNE_OVWREN, 20, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, KL_OVWREN, 19, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, KHCLOAD_OVWREN, 18, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, KHRDEG_OVWREN, 17, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, KHCDEG_OVWREN, 16, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, HF_OVWREN, 15, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, HE_OVWREN, 14, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, HD_OVWREN, 13, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, HC_OVWREN, 12, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, HB_OVWREN, 11, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, HA_OVWREN, 10, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H9_OVWREN, 9, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H8_OVWREN, 8, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H7_OVWREN, 7, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H6_OVWREN, 6, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H5_OVWREN, 5, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H4_OVWREN, 4, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H3_OVWREN, 3, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, H2_OVWREN, 2, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, UT_OVWREN, 1, 1)
    FIELD(CH0_ADAPT_GEN_CFG3, VP_OVWREN, 0, 1)
REG32(CH0_ADAPT_H01_CFG, 0x30f8)
    FIELD(CH0_ADAPT_H01_CFG, UT_CFG1, 27, 5)
    FIELD(CH0_ADAPT_H01_CFG, UT_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_H01_CFG, UT_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_H01_CFG, UT_ENSYNC, 20, 1)
    FIELD(CH0_ADAPT_H01_CFG, UT_CFG0, 16, 4)
    FIELD(CH0_ADAPT_H01_CFG, VP_CFG1, 11, 5)
    FIELD(CH0_ADAPT_H01_CFG, VP_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_H01_CFG, VP_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_H01_CFG, VP_ENSYNCH, 4, 1)
    FIELD(CH0_ADAPT_H01_CFG, VP_ENSYNCL, 3, 1)
    FIELD(CH0_ADAPT_H01_CFG, VP_CFG0, 0, 3)
REG32(CH0_ADAPT_H23_CFG, 0x30fc)
    FIELD(CH0_ADAPT_H23_CFG, H3_CFG1, 27, 5)
    FIELD(CH0_ADAPT_H23_CFG, H3_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_H23_CFG, H3_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_H23_CFG, TESTC1, 16, 5)
    FIELD(CH0_ADAPT_H23_CFG, H2_CFG1, 11, 5)
    FIELD(CH0_ADAPT_H23_CFG, H2_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_H23_CFG, H2_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_H23_CFG, TESTC0, 0, 5)
REG32(CH0_ADAPT_H45_CFG, 0x3100)
    FIELD(CH0_ADAPT_H45_CFG, H5_INITDAC, 27, 5)
    FIELD(CH0_ADAPT_H45_CFG, H5_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_H45_CFG, H5_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_H45_CFG, UTCOEFF, 16, 5)
    FIELD(CH0_ADAPT_H45_CFG, H4_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_H45_CFG, H4_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_H45_CFG, H4_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_H45_CFG, TESTC21, 3, 2)
    FIELD(CH0_ADAPT_H45_CFG, TESTC20, 0, 3)
REG32(CH0_ADAPT_H67_CFG, 0x3104)
    FIELD(CH0_ADAPT_H67_CFG, H7_INITDAC, 27, 5)
    FIELD(CH0_ADAPT_H67_CFG, H7_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_H67_CFG, H7_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_H67_CFG, H3COEFF, 16, 5)
    FIELD(CH0_ADAPT_H67_CFG, H6_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_H67_CFG, H6_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_H67_CFG, H6_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_H67_CFG, H2COEFF, 0, 5)
REG32(CH0_ADAPT_H89_CFG, 0x3108)
    FIELD(CH0_ADAPT_H89_CFG, H9_INITDAC, 27, 5)
    FIELD(CH0_ADAPT_H89_CFG, H9_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_H89_CFG, H9_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_H89_CFG, H9_CFG1, 16, 5)
    FIELD(CH0_ADAPT_H89_CFG, H8_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_H89_CFG, H8_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_H89_CFG, H8_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_H89_CFG, H8_CFG1, 0, 5)
REG32(CH0_ADAPT_HAB_CFG, 0x310c)
    FIELD(CH0_ADAPT_HAB_CFG, HB_INITDAC, 27, 5)
    FIELD(CH0_ADAPT_HAB_CFG, HB_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_HAB_CFG, HB_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_HAB_CFG, HB_CFG1, 16, 5)
    FIELD(CH0_ADAPT_HAB_CFG, HA_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_HAB_CFG, HA_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_HAB_CFG, HA_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_HAB_CFG, HA_CFG1, 0, 5)
REG32(CH0_ADAPT_HCD_CFG, 0x3110)
    FIELD(CH0_ADAPT_HCD_CFG, HD_INITDAC, 27, 5)
    FIELD(CH0_ADAPT_HCD_CFG, HD_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_HCD_CFG, HD_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_HCD_CFG, HD_CFG1, 16, 5)
    FIELD(CH0_ADAPT_HCD_CFG, HC_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_HCD_CFG, HC_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_HCD_CFG, HC_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_HCD_CFG, HC_CFG1, 0, 5)
REG32(CH0_ADAPT_HEF_CFG, 0x3114)
    FIELD(CH0_ADAPT_HEF_CFG, HF_INITDAC, 27, 5)
    FIELD(CH0_ADAPT_HEF_CFG, HF_MSHIFT, 23, 4)
    FIELD(CH0_ADAPT_HEF_CFG, HF_WAITSEL, 21, 2)
    FIELD(CH0_ADAPT_HEF_CFG, HE_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_HEF_CFG, HE_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_HEF_CFG, HE_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_HEF_CFG, HE_CFG1, 0, 5)
REG32(CH0_ADAPT_KH_CFG0, 0x3118)
    FIELD(CH0_ADAPT_KH_CFG0, KHCDEG_UTVPRATIO, 24, 8)
    FIELD(CH0_ADAPT_KH_CFG0, KHCDEG_HYSTERSIS, 16, 8)
    FIELD(CH0_ADAPT_KH_CFG0, KHCDEG_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_KH_CFG0, KHCDEG_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_KH_CFG0, WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_KH_CFG0, KH_CFG00, 0, 5)
REG32(CH0_ADAPT_KH_CFG1, 0x311c)
    FIELD(CH0_ADAPT_KH_CFG1, KH_CFG10, 7, 25)
    FIELD(CH0_ADAPT_KH_CFG1, KHCDEG_TARGET, 0, 7)
REG32(CH0_ADAPT_KH_CFG2, 0x3120)
    FIELD(CH0_ADAPT_KH_CFG2, KH_CFG21, 15, 17)
    FIELD(CH0_ADAPT_KH_CFG2, KHRDEG_INITDAC, 11, 4)
    FIELD(CH0_ADAPT_KH_CFG2, KHRDEG_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_KH_CFG2, KHRDEG_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_KH_CFG2, KH_CFG20, 0, 5)
REG32(CH0_ADAPT_KH_CFG3, 0x3124)
REG32(CH0_ADAPT_KH_CFG4, 0x3128)
    FIELD(CH0_ADAPT_KH_CFG4, KH_CFG41, 16, 16)
    FIELD(CH0_ADAPT_KH_CFG4, KHCLOAD_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_KH_CFG4, KHCLOAD_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_KH_CFG4, WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_KH_CFG4, KH_CFG40, 0, 5)
REG32(CH0_ADAPT_KH_CFG5, 0x312c)
REG32(CH0_ADAPT_KL_CFG0, 0x3130)
    FIELD(CH0_ADAPT_KL_CFG0, KL_CFG01, 16, 16)
    FIELD(CH0_ADAPT_KL_CFG0, KL_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_KL_CFG0, KL_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_KL_CFG0, KL_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_KL_CFG0, KL_CFG00, 0, 5)
REG32(CH0_ADAPT_KL_CFG1, 0x3134)
    FIELD(CH0_ADAPT_KL_CFG1, KL_CFG11, 16, 16)
    FIELD(CH0_ADAPT_KL_CFG1, KLTUNE_INITDAC, 11, 5)
    FIELD(CH0_ADAPT_KL_CFG1, KLTUNE_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_KL_CFG1, KLTUNE_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_KL_CFG1, KL_CFG10, 0, 5)
REG32(CH0_ADAPT_LCK_CFG0, 0x3138)
    FIELD(CH0_ADAPT_LCK_CFG0, LCK_CFG0, 30, 2)
    FIELD(CH0_ADAPT_LCK_CFG0, THRD, 24, 6)
    FIELD(CH0_ADAPT_LCK_CFG0, OUTLCKDIS, 23, 1)
    FIELD(CH0_ADAPT_LCK_CFG0, GAIN2, 19, 4)
    FIELD(CH0_ADAPT_LCK_CFG0, GAIN0, 16, 3)
    FIELD(CH0_ADAPT_LCK_CFG0, GAIN1, 12, 4)
    FIELD(CH0_ADAPT_LCK_CFG0, CDRLCK0_INITSEL, 0, 12)
REG32(CH0_ADAPT_LCK_CFG1, 0x313c)
    FIELD(CH0_ADAPT_LCK_CFG1, TESTC, 29, 3)
    FIELD(CH0_ADAPT_LCK_CFG1, ENLOSS, 28, 1)
    FIELD(CH0_ADAPT_LCK_CFG1, ENLCK1, 27, 1)
    FIELD(CH0_ADAPT_LCK_CFG1, ENLCK0, 26, 1)
    FIELD(CH0_ADAPT_LCK_CFG1, LCK_CFG10, 21, 5)
    FIELD(CH0_ADAPT_LCK_CFG1, FORCELOW, 20, 1)
    FIELD(CH0_ADAPT_LCK_CFG1, SELCON, 17, 3)
    FIELD(CH0_ADAPT_LCK_CFG1, DETECTEN, 16, 1)
    FIELD(CH0_ADAPT_LCK_CFG1, LCKCTRVAL, 12, 4)
    FIELD(CH0_ADAPT_LCK_CFG1, LOSSSEL, 0, 12)
REG32(CH0_ADAPT_LCK_CFG2, 0x3140)
    FIELD(CH0_ADAPT_LCK_CFG2, LCK_CFG20, 25, 7)
    FIELD(CH0_ADAPT_LCK_CFG2, FIX_PPM, 24, 1)
    FIELD(CH0_ADAPT_LCK_CFG2, TESTCON, 20, 4)
    FIELD(CH0_ADAPT_LCK_CFG2, UD_CYCLEU, 16, 4)
    FIELD(CH0_ADAPT_LCK_CFG2, UD_CYCLEL, 0, 16)
REG32(CH0_ADAPT_LCK_CFG3, 0x3144)
REG32(CH0_ADAPT_LOP_CFG, 0x3148)
    FIELD(CH0_ADAPT_LOP_CFG, ENDNOD, 29, 3)
    FIELD(CH0_ADAPT_LOP_CFG, PREVSEL, 25, 4)
    FIELD(CH0_ADAPT_LOP_CFG, DFEOSWTX, 22, 3)
    FIELD(CH0_ADAPT_LOP_CFG, DFEOSWTY, 19, 3)
    FIELD(CH0_ADAPT_LOP_CFG, SWCLKP1, 18, 1)
    FIELD(CH0_ADAPT_LOP_CFG, SWCLKP0, 17, 1)
    FIELD(CH0_ADAPT_LOP_CFG, SELWIDTH, 16, 1)
    FIELD(CH0_ADAPT_LOP_CFG, DRP_WIDTH, 13, 3)
    FIELD(CH0_ADAPT_LOP_CFG, NEXTDC, 12, 1)
    FIELD(CH0_ADAPT_LOP_CFG, INVTBIT, 11, 1)
    FIELD(CH0_ADAPT_LOP_CFG, SWCLKSEL, 9, 2)
    FIELD(CH0_ADAPT_LOP_CFG, LOP_CFG0, 7, 2)
    FIELD(CH0_ADAPT_LOP_CFG, BLKOUTC, 5, 2)
    FIELD(CH0_ADAPT_LOP_CFG, DUL_TESTCON, 0, 5)
REG32(CH0_ADAPT_OS_CFG, 0x314c)
    FIELD(CH0_ADAPT_OS_CFG, OS_INITDAC, 25, 7)
    FIELD(CH0_ADAPT_OS_CFG, OS_CFG1, 11, 14)
    FIELD(CH0_ADAPT_OS_CFG, OS_MSHIFT, 7, 4)
    FIELD(CH0_ADAPT_OS_CFG, OS_WAITSEL, 5, 2)
    FIELD(CH0_ADAPT_OS_CFG, OS_CFG0, 0, 5)
REG32(CH0_RX_CRC_CFG0, 0x3150)
    FIELD(CH0_RX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH0_RX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH0_RX_CRC_CFG0, CORRECTION_EN, 7, 1)
    FIELD(CH0_RX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH0_RX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH0_RX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH0_RX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH0_RX_CRC_CFG0, INPUT_BYTE_ORDER, 1, 1)
    FIELD(CH0_RX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH0_RX_CRC_CFG1, 0x3154)
REG32(CH0_RX_CRC_CFG2, 0x3158)
REG32(CH0_RX_CRC_CFG3, 0x315c)
REG32(CH0_TX_CRC_CFG0, 0x3160)
    FIELD(CH0_TX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH0_TX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH0_TX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH0_TX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH0_TX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH0_TX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH0_TX_CRC_CFG0, OUTPUT_BYTE_ORDER, 1, 1)
    FIELD(CH0_TX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH0_TX_CRC_CFG1, 0x3164)
REG32(CH0_TX_CRC_CFG2, 0x3168)
REG32(CH0_TX_CRC_CFG3, 0x316c)
REG32(CH0_DA_CFG, 0x3170)
    FIELD(CH0_DA_CFG, TX_DA_AMP_CTRL_FORCE, 31, 1)
    FIELD(CH0_DA_CFG, TX_DA_AMP_CTRL, 27, 4)
    FIELD(CH0_DA_CFG, TX_DA_SPARE, 20, 7)
    FIELD(CH0_DA_CFG, TX_DA_REFCLK_SEL, 19, 1)
    FIELD(CH0_DA_CFG, TX_DA_RANGE, 18, 1)
    FIELD(CH0_DA_CFG, TX_DA_ENOUT, 17, 1)
    FIELD(CH0_DA_CFG, TX_DA_PWRDNB, 16, 1)
    FIELD(CH0_DA_CFG, RX_DA_AMP_CTRL_FORCE, 15, 1)
    FIELD(CH0_DA_CFG, RX_DA_AMP_CTRL, 11, 4)
    FIELD(CH0_DA_CFG, RX_DA_SPARE, 4, 7)
    FIELD(CH0_DA_CFG, RX_DA_REFCLK_SEL, 3, 1)
    FIELD(CH0_DA_CFG, RX_DA_RANGE, 2, 1)
    FIELD(CH0_DA_CFG, RX_DA_ENOUT, 1, 1)
    FIELD(CH0_DA_CFG, RX_DA_PWRDNB, 0, 1)
REG32(CH0_RX_CTLE_CFG0, 0x3174)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE1_PWRDN, 31, 1)
    FIELD(CH0_RX_CTLE_CFG0, RX_AGC1_CM_REF, 28, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE1_CM_REF, 25, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_AGC2_OCAP_CTRL, 22, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC2_OCAP, 21, 1)
    FIELD(CH0_RX_CTLE_CFG0, RX_AGC1_OCAP_CTRL, 18, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE_TUNE_OS, 16, 2)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC1_OCAP, 15, 1)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE_CL_CAP_CTRL, 12, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE_CS_CAPCTRL, 9, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE_BIAS_CTRL, 6, 3)
    FIELD(CH0_RX_CTLE_CFG0, RX_AGC2_LOW_PWR, 4, 2)
    FIELD(CH0_RX_CTLE_CFG0, RX_AGC1_LOW_PWR, 2, 2)
    FIELD(CH0_RX_CTLE_CFG0, RX_CTLE1_LOW_PWR, 0, 2)
REG32(CH0_RX_CTLE_CFG1, 0x3178)
    FIELD(CH0_RX_CTLE_CFG1, SWCLK_ELVL_OPT, 26, 1)
    FIELD(CH0_RX_CTLE_CFG1, BRCDR_VP_OPT, 25, 1)
    FIELD(CH0_RX_CTLE_CFG1, RCAL_OS_PAD, 19, 6)
    FIELD(CH0_RX_CTLE_CFG1, RX_AGC2_CURR_GAIN, 16, 3)
    FIELD(CH0_RX_CTLE_CFG1, RX_AGC1_CURR_GAIN, 13, 3)
    FIELD(CH0_RX_CTLE_CFG1, RX_CTLE1_CURR_GAIN, 10, 3)
    FIELD(CH0_RX_CTLE_CFG1, RX_AGC2_PWRDN, 9, 1)
    FIELD(CH0_RX_CTLE_CFG1, RX_AGC1_PWRDN, 8, 1)
    FIELD(CH0_RX_CTLE_CFG1, RX_CTLE_OS_PWRDN, 7, 1)
    FIELD(CH0_RX_CTLE_CFG1, RX_CTLE_SAP_SEL, 3, 4)
    FIELD(CH0_RX_CTLE_CFG1, RX_AGC2_CM_REF, 0, 3)
REG32(CH0_RX_DACI2V_CFG0, 0x317c)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_PD_BIAS_OS, 28, 1)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_PD_BIAS_DFE, 27, 1)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_VP_RANGE, 25, 2)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_VS_CODE, 18, 7)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_VS_NEG, 17, 1)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_VS_UT_SIGN, 16, 1)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_SEL_I2V_VCM, 13, 3)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_CFOK_RANGE, 11, 2)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_CFOK_EN, 10, 1)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_FILTER_EN, 9, 1)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_VS_RANGE, 7, 2)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_BIAS_DFE, 5, 2)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_BIAS_I2V, 3, 2)
    FIELD(CH0_RX_DACI2V_CFG0, DAC_BIAS_OS, 1, 2)
    FIELD(CH0_RX_DACI2V_CFG0, SUMMER_VCM_TESTMODE, 0, 1)
REG32(CH0_RX_DFE_CFG0, 0x3180)
    FIELD(CH0_RX_DFE_CFG0, RX_DFE_YEN, 31, 1)
    FIELD(CH0_RX_DFE_CFG0, RX_VREG_PDB, 30, 1)
    FIELD(CH0_RX_DFE_CFG0, RX_VREG_VREFSEL, 28, 2)
    FIELD(CH0_RX_DFE_CFG0, RX_DES_CFG_BITS, 18, 10)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_EN_VCM_EVEN, 17, 1)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_LOW_POWER, 16, 1)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_VCM_TUNE, 12, 4)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_VCM_TUNE_OVWR, 11, 1)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_VREF_TUNE, 8, 3)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_IREF_TUNE, 4, 4)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_DEG_CTRL, 1, 3)
    FIELD(CH0_RX_DFE_CFG0, RX_SUM_DEG_AVTT_OVWR, 0, 1)
REG32(CH0_RX_MISC_CFG0, 0x3184)
    FIELD(CH0_RX_MISC_CFG0, RX_VREG_CTRL, 28, 3)
    FIELD(CH0_RX_MISC_CFG0, RCAL_OS_CTLE, 22, 6)
    FIELD(CH0_RX_MISC_CFG0, RCAL_OS_AGC1, 16, 6)
    FIELD(CH0_RX_MISC_CFG0, SLICER_SARC_DIS, 15, 1)
    FIELD(CH0_RX_MISC_CFG0, RCAL_OS_AGC2, 9, 6)
    FIELD(CH0_RX_MISC_CFG0, RCAL_OS_SUM, 3, 6)
    FIELD(CH0_RX_MISC_CFG0, RX_LPM_EN, 2, 1)
    FIELD(CH0_RX_MISC_CFG0, BAUDRATE_MODE, 1, 1)
    FIELD(CH0_RX_MISC_CFG0, RX_XMODE_SEL, 0, 1)
REG32(CH0_CHL_RSV_CFG1, 0x3188)
REG32(CH0_RX_PAD_CFG0, 0x318c)
    FIELD(CH0_RX_PAD_CFG0, LS_CTRL, 17, 15)
    FIELD(CH0_RX_PAD_CFG0, ACCAP_CMRES_EN, 16, 1)
    FIELD(CH0_RX_PAD_CFG0, ACCAP_CFG, 13, 3)
    FIELD(CH0_RX_PAD_CFG0, LSHIFT_EN, 12, 1)
    FIELD(CH0_RX_PAD_CFG0, ACCAP_EN, 11, 1)
    FIELD(CH0_RX_PAD_CFG0, RX_PAD_CFG0_SPARE, 0, 11)
REG32(CH0_RX_PAD_CFG1, 0x3190)
    FIELD(CH0_RX_PAD_CFG1, RX_PAD_CFG1_SPARE, 30, 2)
    FIELD(CH0_RX_PAD_CFG1, RX_PKDET_EN, 29, 1)
    FIELD(CH0_RX_PAD_CFG1, RX_PKDET_CTRL, 25, 4)
    FIELD(CH0_RX_PAD_CFG1, OOB_VDIFF_INV, 24, 1)
    FIELD(CH0_RX_PAD_CFG1, OOB_SIG_VDIFF_SEL, 21, 3)
    FIELD(CH0_RX_PAD_CFG1, OOB_OVERRIDE, 19, 2)
    FIELD(CH0_RX_PAD_CFG1, OOB_PWRDN_B, 18, 1)
    FIELD(CH0_RX_PAD_CFG1, ACJTAG_EN, 17, 1)
    FIELD(CH0_RX_PAD_CFG1, QPI_EN, 16, 1)
    FIELD(CH0_RX_PAD_CFG1, MNTR_ACJTAG_EN, 15, 1)
    FIELD(CH0_RX_PAD_CFG1, ACJTAG_VD_SEL0, 14, 1)
    FIELD(CH0_RX_PAD_CFG1, ACJTAG_VC_SEL0, 13, 1)
    FIELD(CH0_RX_PAD_CFG1, MNTR_ACJTAG_RESETB, 12, 1)
    FIELD(CH0_RX_PAD_CFG1, MNTR_ACJTAG_ACMODE, 11, 1)
    FIELD(CH0_RX_PAD_CFG1, PROG_OPAMPPD_EN, 10, 1)
    FIELD(CH0_RX_PAD_CFG1, CM_BUFF_CFG, 6, 4)
    FIELD(CH0_RX_PAD_CFG1, RTERM_VCOM_MODE, 4, 2)
    FIELD(CH0_RX_PAD_CFG1, RTERM_VCOM_LVL, 0, 4)
REG32(CH0_RX_PCS_CFG0, 0x3194)
    FIELD(CH0_RX_PCS_CFG0, RX_ALIGN_MCOMMA_DET, 31, 1)
    FIELD(CH0_RX_PCS_CFG0, RX_ALIGN_PCOMMA_DET, 30, 1)
    FIELD(CH0_RX_PCS_CFG0, RX_ALIGN_MCOMMA_VAL, 20, 10)
    FIELD(CH0_RX_PCS_CFG0, RX_ALIGN_PCOMMA_VAL, 10, 10)
    FIELD(CH0_RX_PCS_CFG0, RX_INT_DATA_WIDTH, 7, 2)
    FIELD(CH0_RX_PCS_CFG0, RX_DATA_WIDTH, 3, 4)
    FIELD(CH0_RX_PCS_CFG0, RX_MCOMMA_ALIGNEN, 2, 1)
    FIELD(CH0_RX_PCS_CFG0, RX_PCOMMA_ALIGNEN, 1, 1)
    FIELD(CH0_RX_PCS_CFG0, RX_COMMADETEN, 0, 1)
REG32(CH0_RX_PCS_CFG1, 0x3198)
    FIELD(CH0_RX_PCS_CFG1, RX_FABRIC_DATA_SEL, 29, 3)
    FIELD(CH0_RX_PCS_CFG1, RX_FIFO_DATA_SEL, 26, 3)
    FIELD(CH0_RX_PCS_CFG1, RX_SIG_VALID_DLY, 21, 5)
    FIELD(CH0_RX_PCS_CFG1, RX_SLIDE_MODE, 19, 2)
    FIELD(CH0_RX_PCS_CFG1, RX_SHOW_REALIGN_COMMA, 18, 1)
    FIELD(CH0_RX_PCS_CFG1, RX_SLIDE_AUTO_WAIT, 14, 4)
    FIELD(CH0_RX_PCS_CFG1, RX_ALIGN_COMMA_WORD, 11, 3)
    FIELD(CH0_RX_PCS_CFG1, RX_ALIGN_COMMA_DOUBLE, 10, 1)
    FIELD(CH0_RX_PCS_CFG1, RX_ALIGN_COMMA_ENABLE, 0, 10)
REG32(CH0_RX_PCS_CFG2, 0x319c)
    FIELD(CH0_RX_PCS_CFG2, PCIE_USB_ERR_REP_DIS, 31, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_PHASE_BUFFER_USE, 30, 1)
    FIELD(CH0_RX_PCS_CFG2, RXBUF_RD_INIT_ADDR, 27, 3)
    FIELD(CH0_RX_PCS_CFG2, RXBUF_RXUSRCLK_REG_BYPASS, 26, 1)
    FIELD(CH0_RX_PCS_CFG2, RXBUF_ADDR_CFG, 25, 1)
    FIELD(CH0_RX_PCS_CFG2, START_SKP_SEL, 24, 1)
    FIELD(CH0_RX_PCS_CFG2, SIGVALID_EN_FOR_RXVALID, 23, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_EIEOS_PATTERN_SEL, 21, 2)
    FIELD(CH0_RX_PCS_CFG2, RX_BLKSYNC_MCP, 20, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_BLKSYNC_FTS, 19, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_CBCC_DATA_SEL, 18, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_DEC_VALID_COMMA, 17, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_DEC_MCOMMA_DET, 16, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_DEC_PCOMMA_DET, 15, 1)
    FIELD(CH0_RX_PCS_CFG2, RX_8B10B_EN, 14, 1)
    FIELD(CH0_RX_PCS_CFG2, EIOS_ERR_MASK_DIS, 13, 1)
    FIELD(CH0_RX_PCS_CFG2, SAMPLE_PERIOD, 10, 3)
    FIELD(CH0_RX_PCS_CFG2, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH0_RX_PCS_CFG2, USE_GB, 5, 1)
    FIELD(CH0_RX_PCS_CFG2, MODE, 0, 5)
REG32(CH0_RX_PCS_CFG3, 0x31a0)
    FIELD(CH0_RX_PCS_CFG3, RX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH0_RX_PCS_CFG3, RX_FIFO_STATUS_SEL, 30, 1)
    FIELD(CH0_RX_PCS_CFG3, DATA_RATE, 29, 1)
    FIELD(CH0_RX_PCS_CFG3, DATAPATH_CTRL, 26, 3)
    FIELD(CH0_RX_PCS_CFG3, CLAUSE_CTRL, 25, 1)
    FIELD(CH0_RX_PCS_CFG3, TEST_PATT_EN, 24, 1)
    FIELD(CH0_RX_PCS_CFG3, TESTDATA_PATT_SEL, 23, 1)
    FIELD(CH0_RX_PCS_CFG3, RXVALID_FORCE_RXVAL_COMDET, 20, 1)
    FIELD(CH0_RX_PCS_CFG3, RXVALID_EIOS_RESET_EN, 19, 1)
    FIELD(CH0_RX_PCS_CFG3, RXPHCLK_CYCLE_CNT_EN, 17, 1)
    FIELD(CH0_RX_PCS_CFG3, RXPRBS_LEAKYBUCKET_EN, 16, 1)
    FIELD(CH0_RX_PCS_CFG3, RXPRBS_LINK2RESEED_CNT, 8, 8)
    FIELD(CH0_RX_PCS_CFG3, RXPRBS_LINKACQ_CNT, 0, 8)
REG32(CH0_RX_PCS_CFG4, 0x31a4)
    FIELD(CH0_RX_PCS_CFG4, RXVALID_GEN_EN, 31, 1)
    FIELD(CH0_RX_PCS_CFG4, RXVALID_FORCE_SIGVALID, 30, 1)
    FIELD(CH0_RX_PCS_CFG4, RXVALID_K_NUM, 20, 10)
    FIELD(CH0_RX_PCS_CFG4, RXVALID_GOOD_DATA_NUM, 10, 10)
    FIELD(CH0_RX_PCS_CFG4, RXVALID_ERR_DATA_NUM, 0, 10)
REG32(CH0_CHCLK_MISC_CFG, 0x31a8)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_MONCLKCYCLE, 28, 3)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_PWRDNB, 27, 1)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_UNLOCKCTRL, 25, 2)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OW, 17, 8)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_FINE_SWEEP, 15, 2)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_ILOLOCKCOARSE, 13, 2)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_ILOLOCKFACTOR, 11, 2)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_PLLLOCKDETEN, 10, 1)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_CRS_ACCURACY, 8, 2)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_OVRD_MODE, 6, 2)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OWEN, 5, 1)
    FIELD(CH0_CHCLK_MISC_CFG, CHCLK_FBDIV_VAL, 0, 5)
REG32(CH0_CHCLK_ILO_CFG, 0x31ac)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OW, 28, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OWEN, 27, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OW, 26, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OWEN, 25, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OW, 24, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OWEN, 23, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OW, 21, 2)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OWEN, 20, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_ILO_MODE_SPD, 19, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_CLKSRCMUX_SEL, 18, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_FTL_TUNE_OWEN, 16, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_VREG_CTRL, 12, 3)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_VCTRL_OW, 6, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_BIAS, 5, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_VCTRL_EXT, 4, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_VBUF, 2, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_FTL, 1, 1)
    FIELD(CH0_CHCLK_ILO_CFG, CHCLK_PDB_VREG, 0, 1)
REG32(CH0_CHCLK_RXPI_CFG, 0x31b0)
    FIELD(CH0_CHCLK_RXPI_CFG, PROGDIV_RX_DIV_PDB, 22, 1)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_STEP_BYP_EN, 21, 1)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_STEP_TWO_EN, 20, 1)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_SEL_VREG_SENSE, 19, 1)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_VREG_CTRL, 16, 3)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_BAND_SEL, 4, 2)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_S_PREBUF_EN, 3, 1)
    FIELD(CH0_CHCLK_RXPI_CFG, RXPI_PREBUF_EN, 2, 1)
REG32(CH0_CHCLK_RXCAL_CFG, 0x31b4)
    FIELD(CH0_CHCLK_RXCAL_CFG, DMON_SEL, 28, 4)
    FIELD(CH0_CHCLK_RXCAL_CFG, AUTO_MODE, 27, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, TWAIT_SEL, 25, 2)
    FIELD(CH0_CHCLK_RXCAL_CFG, CLKDIV_SEL, 22, 3)
    FIELD(CH0_CHCLK_RXCAL_CFG, TCYC_PER_CAL, 20, 2)
    FIELD(CH0_CHCLK_RXCAL_CFG, TEVAL_SEL, 18, 2)
    FIELD(CH0_CHCLK_RXCAL_CFG, TOS_SEL, 16, 2)
    FIELD(CH0_CHCLK_RXCAL_CFG, HYST_MODE, 14, 2)
    FIELD(CH0_CHCLK_RXCAL_CFG, DMON_EN, 13, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, RX_CAL_PD, 12, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, OVERRIDE_CODE_IDX, 9, 3)
    FIELD(CH0_CHCLK_RXCAL_CFG, FLIP_DIR_ANY, 8, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_RXPAD_OS, 7, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_AGC2_CM, 6, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_AGC1_CM, 5, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_CTLE_CM, 4, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_RXDCD_S, 3, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_RXDCD_X, 2, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG, SKIP_RXDCD_D, 1, 1)
REG32(CH0_CHCLK_RXCAL_CFG1, 0x31b8)
    FIELD(CH0_CHCLK_RXCAL_CFG1, OVERRIDE_EN, 7, 1)
    FIELD(CH0_CHCLK_RXCAL_CFG1, OVERRIDE_CODE, 0, 7)
REG32(CH0_CHCLK_TXPI_CFG0, 0x31bc)
    FIELD(CH0_CHCLK_TXPI_CFG0, RSVD, 22, 10)
    FIELD(CH0_CHCLK_TXPI_CFG0, SARC_EN, 21, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_STEP_BYP_EN, 20, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TX_PROGCLK_SEL, 18, 2)
    FIELD(CH0_CHCLK_TXPI_CFG0, PROGDIV_TX_DIV_PDB, 17, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_STEP_TWO_EN, 16, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_BAND_SEL, 4, 2)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_PREBUF_EN, 3, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_BYPASS, 2, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TXPI_BYPASSMUX_PDB, 1, 1)
    FIELD(CH0_CHCLK_TXPI_CFG0, TX_PLLCLK_SEL, 0, 1)
REG32(CH0_CHCLK_TXCAL_CFG, 0x31c0)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_EXHOLD, 26, 1)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_OVWREN, 25, 1)
    FIELD(CH0_CHCLK_TXCAL_CFG, TXCLK_TXCAL_FORCEREADY, 24, 1)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TIGHT, 23, 1)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_INITDAC, 16, 7)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACWIN, 14, 2)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACCHECK, 12, 2)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_THRESHSEL, 10, 2)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_MULSEL, 7, 3)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_FLIPDIR, 6, 1)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_CALEN, 5, 1)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTSEL, 1, 4)
    FIELD(CH0_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTEN, 0, 1)
REG32(CH0_CHCLK_RXCAL_CFG2, 0x31c4)
REG32(CH0_CHCLK_RSV_CFG, 0x31c8)
REG32(CH0_PIPE_TX_EQ_CFG0, 0x31cc)
    FIELD(CH0_PIPE_TX_EQ_CFG0, TX_MAINCURSOR_SEL, 30, 1)
    FIELD(CH0_PIPE_TX_EQ_CFG0, TX_DRIVE_MODE, 28, 2)
    FIELD(CH0_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_3, 21, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_2, 14, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_1, 7, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_0, 0, 7)
REG32(CH0_PIPE_TX_EQ_CFG1, 0x31d0)
    FIELD(CH0_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_2, 21, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_1, 14, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_0, 7, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG1, TX_MARGIN_FULL_4, 0, 7)
REG32(CH0_PIPE_TX_EQ_CFG2, 0x31d4)
    FIELD(CH0_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_4, 7, 7)
    FIELD(CH0_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_3, 0, 7)
REG32(CH0_PIPE_TX_EQ_CFG3, 0x31d8)
    FIELD(CH0_PIPE_TX_EQ_CFG3, TX_DEEMPH_3, 15, 5)
    FIELD(CH0_PIPE_TX_EQ_CFG3, TX_DEEMPH_2, 10, 5)
    FIELD(CH0_PIPE_TX_EQ_CFG3, TX_DEEMPH_1, 5, 5)
    FIELD(CH0_PIPE_TX_EQ_CFG3, TX_DEEMPH_0, 0, 5)
REG32(CH0_TX_PCS_CFG0, 0x31dc)
    FIELD(CH0_TX_PCS_CFG0, TX_PMA_DATA_SEL, 29, 3)
    FIELD(CH0_TX_PCS_CFG0, TXPMA_WIDTH_OVRD, 26, 3)
    FIELD(CH0_TX_PCS_CFG0, TX_INT_DATA_WIDTH, 24, 2)
    FIELD(CH0_TX_PCS_CFG0, TX_DATA_WIDTH, 20, 4)
    FIELD(CH0_TX_PCS_CFG0, TX_IDLE_DATA_ZERO, 19, 1)
    FIELD(CH0_TX_PCS_CFG0, TXPMA_WIDTH_OVRD_EN, 18, 1)
    FIELD(CH0_TX_PCS_CFG0, TX_8B10B_EN, 17, 1)
    FIELD(CH0_TX_PCS_CFG0, TX_8B10B_BYPASS, 13, 4)
    FIELD(CH0_TX_PCS_CFG0, SAMPLE_PERIOD, 10, 3)
    FIELD(CH0_TX_PCS_CFG0, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH0_TX_PCS_CFG0, USE_GB, 5, 1)
    FIELD(CH0_TX_PCS_CFG0, MODE, 0, 5)
REG32(CH0_TX_PCS_CFG1, 0x31e0)
    FIELD(CH0_TX_PCS_CFG1, TX_PRBS_FORCE_MODE, 31, 1)
    FIELD(CH0_TX_PCS_CFG1, RXPRBS_ERR_LOOPBACK, 30, 1)
    FIELD(CH0_TX_PCS_CFG1, TX_PRBS_USERPATTERN2, 20, 10)
    FIELD(CH0_TX_PCS_CFG1, TX_PRBS_USERPATTERN1, 10, 10)
    FIELD(CH0_TX_PCS_CFG1, TX_PRBS_USERPATTERN0, 0, 10)
REG32(CH0_TX_PCS_CFG2, 0x31e4)
    FIELD(CH0_TX_PCS_CFG2, TX_FIFO_STATUS_SEL, 31, 1)
    FIELD(CH0_TX_PCS_CFG2, TX_PRBS_USERPATTERN5, 20, 10)
    FIELD(CH0_TX_PCS_CFG2, TX_PRBS_USERPATTERN4, 10, 10)
    FIELD(CH0_TX_PCS_CFG2, TX_PRBS_USERPATTERN3, 0, 10)
REG32(CH0_TX_PCS_CFG3, 0x31e8)
    FIELD(CH0_TX_PCS_CFG3, TX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH0_TX_PCS_CFG3, TXBUF_TXPCSCLK_REG_BYPASS, 30, 1)
    FIELD(CH0_TX_PCS_CFG3, USB_LFPS_TPERIOD_ACCURATE, 29, 1)
    FIELD(CH0_TX_PCS_CFG3, USB_LFPS_TPERIOD, 25, 4)
    FIELD(CH0_TX_PCS_CFG3, TXBUF_WR_INIT_ADDR, 22, 3)
    FIELD(CH0_TX_PCS_CFG3, TXBUF_ADDR_CFG, 21, 1)
    FIELD(CH0_TX_PCS_CFG3, TX_PHASE_BUFFER_USE, 20, 1)
    FIELD(CH0_TX_PCS_CFG3, TX_PRBS_USERPATTERN7, 10, 10)
    FIELD(CH0_TX_PCS_CFG3, TX_PRBS_USERPATTERN6, 0, 10)
REG32(CH0_EYESCAN_CFG0, 0x31ec)
    FIELD(CH0_EYESCAN_CFG0, ES_SWAP_EN, 25, 1)
    FIELD(CH0_EYESCAN_CFG0, ES_ERRDET_EN, 24, 1)
    FIELD(CH0_EYESCAN_CFG0, ES_EYE_SCAN_EN, 23, 1)
    FIELD(CH0_EYESCAN_CFG0, ES_CONTROL, 17, 6)
    FIELD(CH0_EYESCAN_CFG0, ES_PRESCALE, 12, 5)
    FIELD(CH0_EYESCAN_CFG0, ES_HORZ_OFFSET, 0, 12)
REG32(CH0_EYESCAN_CFG1, 0x31f0)
REG32(CH0_EYESCAN_CFG2, 0x31f4)
REG32(CH0_EYESCAN_CFG3, 0x31f8)
REG32(CH0_EYESCAN_CFG4, 0x31fc)
REG32(CH0_EYESCAN_CFG5, 0x3200)
REG32(CH0_EYESCAN_CFG6, 0x3204)
REG32(CH0_EYESCAN_CFG7, 0x3208)
REG32(CH0_EYESCAN_CFG8, 0x320c)
REG32(CH0_EYESCAN_CFG9, 0x3210)
REG32(CH0_EYESCAN_CFG10, 0x3214)
REG32(CH0_EYESCAN_CFG11, 0x3218)
REG32(CH0_EYESCAN_CFG12, 0x321c)
REG32(CH0_EYESCAN_CFG13, 0x3220)
REG32(CH0_EYESCAN_CFG14, 0x3224)
REG32(CH0_EYESCAN_CFG15, 0x3228)
REG32(CH0_EYESCAN_CFG16, 0x322c)
    FIELD(CH0_EYESCAN_CFG16, RXPMA_WIDTH_OVRD_EN, 31, 1)
    FIELD(CH0_EYESCAN_CFG16, RXPMA_ADAP_WIDTH_OVRD, 27, 4)
    FIELD(CH0_EYESCAN_CFG16, RXPMA_CDR_WIDTH_OVRD, 23, 4)
    FIELD(CH0_EYESCAN_CFG16, RXPMA_DES_WIDTH_OVRD, 19, 4)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SAMPLE, 15, 1)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL2, 14, 1)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL, 13, 1)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_VS_UT_SIGN, 12, 1)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_VS_RANGE, 10, 2)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_VS_NEG_DIR, 9, 1)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_VS_CODE, 2, 7)
    FIELD(CH0_EYESCAN_CFG16, EYESCAN_VP_RANGE, 0, 2)
REG32(CH0_RX_ELASTIC_BUF_CFG0, 0x3230)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_THRESH_OVRD, 31, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_REPEAT_WAIT, 26, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_UDFL_THRESH, 20, 6)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_OVFL_THRESH, 14, 6)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MAX_LAT, 8, 6)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MIN_LAT, 2, 6)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_USE, 1, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG0, ELASTICBUF_8B10B_EN, 0, 1)
REG32(CH0_TX_10G_CFG0, 0x3234)
REG32(CH0_TX_10G_CFG1, 0x3238)
    FIELD(CH0_TX_10G_CFG1, DATAPATH_CTRL, 29, 2)
    FIELD(CH0_TX_10G_CFG1, TEST_PATT_EN, 28, 1)
    FIELD(CH0_TX_10G_CFG1, TEST_PATT_SEL, 27, 1)
    FIELD(CH0_TX_10G_CFG1, TESTDATA_PATT_SEL, 26, 1)
    FIELD(CH0_TX_10G_CFG1, TEST_PATT_SEEDA, 0, 26)
REG32(CH0_TX_10G_CFG2, 0x323c)
REG32(CH0_TX_10G_CFG3, 0x3240)
    FIELD(CH0_TX_10G_CFG3, TEST_PATT_SEEDB, 0, 26)
REG32(CH0_RX_PHALIGN_CFG0, 0x3244)
    FIELD(CH0_RX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH0_RX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH0_RX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH0_RX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH0_RX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH0_RX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH0_RX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH0_RX_PHALIGN_CFG0, RXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH0_RX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH0_RX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH0_RX_PHALIGN_CFG0, ALIGN_DMON_SEL, 5, 5)
    FIELD(CH0_RX_PHALIGN_CFG0, DA_WAIT_CYCLES, 0, 5)
REG32(CH0_RX_PHALIGN_CFG1, 0x3248)
    FIELD(CH0_RX_PHALIGN_CFG1, SETINIT_PH_CNT, 27, 5)
    FIELD(CH0_RX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH0_RX_PHALIGN_CFG1, NUM_SAMPLES, 15, 5)
    FIELD(CH0_RX_PHALIGN_CFG1, SAMPLE_WAIT, 13, 2)
    FIELD(CH0_RX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 6, 7)
    FIELD(CH0_RX_PHALIGN_CFG1, MIN_THRESHOLD_OVRD, 5, 1)
    FIELD(CH0_RX_PHALIGN_CFG1, MAX_THRESHOLD_OVRD, 4, 1)
    FIELD(CH0_RX_PHALIGN_CFG1, CHAIN_MODE, 2, 2)
    FIELD(CH0_RX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 1, 1)
    FIELD(CH0_RX_PHALIGN_CFG1, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH0_RX_PHALIGN_CFG2, 0x324c)
    FIELD(CH0_RX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH0_RX_PHALIGN_CFG2, SLIP_EN_WID_PRE, 21, 4)
    FIELD(CH0_RX_PHALIGN_CFG2, SLIP_EN_WID_POST, 17, 4)
    FIELD(CH0_RX_PHALIGN_CFG2, SLIP_PULSE_WID_HI, 13, 4)
    FIELD(CH0_RX_PHALIGN_CFG2, SLIP_PULSE_WID_LO, 9, 4)
    FIELD(CH0_RX_PHALIGN_CFG2, SLIP_PULSE_SETTLE, 5, 4)
REG32(CH0_RX_PHALIGN_CFG3, 0x3250)
    FIELD(CH0_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_CNT, 27, 5)
    FIELD(CH0_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH0_RX_PHALIGN_CFG3, MLDLY_NUM_SAMPLES, 15, 5)
    FIELD(CH0_RX_PHALIGN_CFG3, MLDLY_MIN_THRESHOLD_OVRD, 14, 1)
    FIELD(CH0_RX_PHALIGN_CFG3, MLDLY_MAX_THRESHOLD_OVRD, 13, 1)
    FIELD(CH0_RX_PHALIGN_CFG3, MLDLY_SAMPLE_WAIT, 11, 2)
    FIELD(CH0_RX_PHALIGN_CFG3, DAPICODE_OVRD, 3, 8)
    FIELD(CH0_RX_PHALIGN_CFG3, DMON_CLK_SEL, 0, 2)
REG32(CH0_RX_PHALIGN_CFG4, 0x3254)
    FIELD(CH0_RX_PHALIGN_CFG4, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH0_RX_PHALIGN_CFG4, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH0_RX_PHALIGN_CFG4, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH0_RX_PHALIGN_CFG4, FINE_ALIGN_BYPASS, 12, 1)
    FIELD(CH0_RX_PHALIGN_CFG4, CLKSLIP_PAR_SAMPLES, 10, 2)
    FIELD(CH0_RX_PHALIGN_CFG4, CLKSLIP_NUM_SAMPLES, 5, 5)
    FIELD(CH0_RX_PHALIGN_CFG4, CLKSLIP_SAMPLES_WAIT, 0, 5)
REG32(CH0_RX_PHALIGN_CFG5, 0x3258)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_UP_DOWN, 28, 2)
    FIELD(CH0_RX_PHALIGN_CFG5, CMN_FAB_CLK_PHALIGN_MODE, 26, 2)
    FIELD(CH0_RX_PHALIGN_CFG5, TX_BUFBYPASS_ML_NEGEDGE_MODE, 25, 1)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_BUFBYPASS_ML_NEGEDGE_MODE, 24, 1)
    FIELD(CH0_RX_PHALIGN_CFG5, TXPICODE_DDR_EN, 23, 1)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MODE, 22, 1)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MAXCOUNT, 17, 5)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_WAITCYCLE, 14, 3)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_CDR_SLIP_DIR, 13, 1)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_CDR_SLIP_SAMPLE_COUNT, 11, 2)
    FIELD(CH0_RX_PHALIGN_CFG5, TX_BEACON_DLY_OPT_128B130B, 9, 2)
    FIELD(CH0_RX_PHALIGN_CFG5, TX_CLK_DLY_OPT_128B130B, 7, 2)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_BEACON_DLY_OPT_128B130B, 5, 2)
    FIELD(CH0_RX_PHALIGN_CFG5, RX_CLK_DLY_OPT_128B130B, 3, 2)
REG32(CH0_TX_PHALIGN_CFG0, 0x325c)
    FIELD(CH0_TX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH0_TX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH0_TX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, TXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH0_TX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH0_TX_PHALIGN_CFG0, MIN_THRESHOLD_OVRD, 7, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, MAX_THRESHOLD_OVRD, 6, 1)
    FIELD(CH0_TX_PHALIGN_CFG0, ALIGN_DMON_SEL, 1, 5)
    FIELD(CH0_TX_PHALIGN_CFG0, TX_DYNAMIC_SWITCH_EN, 0, 1)
REG32(CH0_TX_PHALIGN_CFG1, 0x3260)
    FIELD(CH0_TX_PHALIGN_CFG1, PHDA_WAIT_CYCLES, 27, 5)
    FIELD(CH0_TX_PHALIGN_CFG1, SETINIT_PH_CNT, 22, 5)
    FIELD(CH0_TX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 17, 5)
    FIELD(CH0_TX_PHALIGN_CFG1, NUM_SAMPLES, 12, 5)
    FIELD(CH0_TX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 5, 7)
    FIELD(CH0_TX_PHALIGN_CFG1, SAMPLE_WAIT, 3, 2)
    FIELD(CH0_TX_PHALIGN_CFG1, CHAIN_MODE, 1, 2)
    FIELD(CH0_TX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 0, 1)
REG32(CH0_TX_PHALIGN_CFG2, 0x3264)
    FIELD(CH0_TX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH0_TX_PHALIGN_CFG2, TXPI_PHDA_WAIT_CYCLES, 20, 5)
    FIELD(CH0_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_CNT, 15, 5)
    FIELD(CH0_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_WAIT_CYCLE, 10, 5)
    FIELD(CH0_TX_PHALIGN_CFG2, TXPI_NUM_SAMPLES, 3, 5)
    FIELD(CH0_TX_PHALIGN_CFG2, TXPI_SAMPLE_WAIT, 1, 2)
    FIELD(CH0_TX_PHALIGN_CFG2, TXPI_MIN_THRESHOLD_OVRD, 0, 1)
REG32(CH0_TX_PHALIGN_CFG3, 0x3268)
    FIELD(CH0_TX_PHALIGN_CFG3, TXPI_MAX_THRESHOLD_OVRD, 31, 1)
    FIELD(CH0_TX_PHALIGN_CFG3, TXPI_MAX_SAMPLE_THRESHOLD, 24, 7)
    FIELD(CH0_TX_PHALIGN_CFG3, TXPI_MIN_SAMPLE_THRESHOLD, 17, 7)
    FIELD(CH0_TX_PHALIGN_CFG3, DAPICODE_OVRD, 9, 8)
    FIELD(CH0_TX_PHALIGN_CFG3, TXPICODE_OVRD, 2, 7)
    FIELD(CH0_TX_PHALIGN_CFG3, TXPI_ALIGN_DIR, 1, 1)
    FIELD(CH0_TX_PHALIGN_CFG3, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH0_TX_PHALIGN_CFG4, 0x326c)
    FIELD(CH0_TX_PHALIGN_CFG4, TXPI_SETINIT_STEPSIZE, 27, 5)
    FIELD(CH0_TX_PHALIGN_CFG4, TXPI_PHALIGN_STEPSIZE, 22, 5)
    FIELD(CH0_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_CNT, 17, 5)
    FIELD(CH0_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_WAIT_CYCLE, 12, 5)
    FIELD(CH0_TX_PHALIGN_CFG4, MLDLY_NUM_SAMPLES, 5, 5)
    FIELD(CH0_TX_PHALIGN_CFG4, MLDLY_MIN_THRESHOLD_OVRD, 4, 1)
    FIELD(CH0_TX_PHALIGN_CFG4, MLDLY_MAX_THRESHOLD_OVRD, 3, 1)
    FIELD(CH0_TX_PHALIGN_CFG4, MLDLY_SAMPLE_WAIT, 1, 2)
    FIELD(CH0_TX_PHALIGN_CFG4, DLY_ALIGN_DIR, 0, 1)
REG32(CH0_TX_PHALIGN_CFG5, 0x3270)
    FIELD(CH0_TX_PHALIGN_CFG5, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH0_TX_PHALIGN_CFG5, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH0_TX_PHALIGN_CFG5, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH0_TX_PHALIGN_CFG5, DMON_CLK_SEL, 0, 2)
REG32(CH0_PIPE_CTRL_CFG0, 0x3274)
    FIELD(CH0_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_NUM, 28, 4)
    FIELD(CH0_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_EN, 27, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, SATA_BURST_SEQ_LEN, 23, 4)
    FIELD(CH0_PIPE_CTRL_CFG0, TX_PD_ELECIDLE_MODE, 22, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, TX_EILDE_DEASSERT_DLY, 19, 3)
    FIELD(CH0_PIPE_CTRL_CFG0, TX_EIDLE_ASSERT_DLY, 16, 3)
    FIELD(CH0_PIPE_CTRL_CFG0, RX_PCSCLK_SEL, 14, 2)
    FIELD(CH0_PIPE_CTRL_CFG0, TX_PHYCLK_SEL, 13, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, TX_PCSCLK_SEL, 11, 2)
    FIELD(CH0_PIPE_CTRL_CFG0, RX_PHYCLK_SEL, 10, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD, 9, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD_EN, 8, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, PIPECLK_SEL, 7, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, RX_ELECIDLE_MODE, 5, 2)
    FIELD(CH0_PIPE_CTRL_CFG0, RX_ELECIDLE_CFG, 2, 3)
    FIELD(CH0_PIPE_CTRL_CFG0, PCIE_MODE, 1, 1)
    FIELD(CH0_PIPE_CTRL_CFG0, USB_MODE, 0, 1)
REG32(CH0_PIPE_CTRL_CFG1, 0x3278)
    FIELD(CH0_PIPE_CTRL_CFG1, SATA_SPEED, 30, 2)
    FIELD(CH0_PIPE_CTRL_CFG1, P2_SPECIAL_TURNOFF_EN, 29, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, POWERDOWN_OVRD_EN, 28, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PD_TXPMA_PWRDN_OVRD, 27, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PD_TXDRVPWRDN_OVRD, 26, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PD_RX_PD_OVRD, 25, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PD_LCPLL_PD_OVRD, 24, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PD_RPLL_PD_OVRD, 23, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PD_OOB_PD_OVRD, 22, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, OOB_PD, 21, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PIPE_FUND_RST_OVRD_EN, 20, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, IND_ERROR_REPORT, 19, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, UBLAZE_PLL_ILO_CAL_EN, 18, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PIPE_RST_USE_MST_RESET_LOOP, 17, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_PHY_READY_OVRD, 16, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_RX_SYNC_RESET_OVRD, 15, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_TX_SYNC_RESET_OVRD, 14, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_USER_RDY_OVRD, 13, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_PCS_RESET_OVRD, 12, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_PMA_RESET_OVRD, 11, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_TXPROGDIV_RST_OVRD, 10, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_LCPLL_RESET_OVRD, 9, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_LCPLL_PD_OVRD, 8, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_RPLL_RESET_OVRD, 7, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_RPLL_PD_OVRD, 6, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, PIPE_FUND_RST_EN, 5, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RST_ILO_RESET_OVRD, 4, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RXSYNC_EN, 3, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, TXSYNC_EN, 2, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, LCPLL_EN, 1, 1)
    FIELD(CH0_PIPE_CTRL_CFG1, RPLL_EN, 0, 1)
REG32(CH0_PIPE_CTRL_CFG2, 0x327c)
    FIELD(CH0_PIPE_CTRL_CFG2, PMA_SIGDET_SEL, 31, 1)
    FIELD(CH0_PIPE_CTRL_CFG2, P2P3_RX_PWRUP_EN, 30, 1)
    FIELD(CH0_PIPE_CTRL_CFG2, PD_TRANS_TIME_FROM_P2, 15, 15)
    FIELD(CH0_PIPE_CTRL_CFG2, TX_RXDETECT_REF, 12, 3)
    FIELD(CH0_PIPE_CTRL_CFG2, TX_RXDETECT_CFG, 1, 11)
    FIELD(CH0_PIPE_CTRL_CFG2, RXDETECT_BYPASS, 0, 1)
REG32(CH0_PIPE_CTRL_CFG3, 0x3280)
    FIELD(CH0_PIPE_CTRL_CFG3, PIPE_RXADAPT_SAVE_RESTORE_EN, 31, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, PIPE_LCPLL_DYN_PD_EN, 30, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, PIPE_RPLL_DYN_PD_EN, 29, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, RXOUT_DIV, 26, 3)
    FIELD(CH0_PIPE_CTRL_CFG3, TXOUT_DIV, 23, 3)
    FIELD(CH0_PIPE_CTRL_CFG3, RX_VREG_PD, 22, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, TX_VREG_PD, 21, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, ILO_CLKMUX_EN, 20, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, TX_CLKMUX_EN, 19, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, PIPE_FUND_RST_UB_BYPASS, 18, 1)
    FIELD(CH0_PIPE_CTRL_CFG3, PD_TRANS_TIME_TO_P2, 9, 9)
    FIELD(CH0_PIPE_CTRL_CFG3, PD_TRANS_TIME_NONE_P2, 0, 9)
REG32(CH0_PIPE_CTRL_CFG4, 0x3284)
    FIELD(CH0_PIPE_CTRL_CFG4, RST_TXDAPI_RST_OVRD, 31, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RX_RATE_EN, 30, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_TXDAPI_RST_OVRD, 29, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_ILO_RESET_OVRD, 28, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_UB_CTRL_WO_PHYSTATUS, 27, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_UB_REPROG_REQ_DIS, 26, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_USE_RPLL_AS_DATA_PLL, 25, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_PHYSTATUS_CNT, 20, 5)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_DATA_FLUSH_CNT, 15, 5)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_PHYSTATUS_OVRD, 14, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_CHANGE_IN_PROGRESS_OVRD, 13, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_TXRX_128B130B_EN_OVRD, 12, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_RX_SYNC_RESET_OVRD, 11, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_TX_SYNC_RESET_OVRD, 10, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_UB_REPROG_DONE_OVRD, 9, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_PCS_RESET_OVRD, 8, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_PMA_RESET_OVRD, 7, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_TXPROGDIV_RST_OVRD, 6, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_LCPLL_RESET_OVRD, 5, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_LCPLL_PD_OVRD, 4, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_RPLL_RESET_OVRD, 3, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, RATE_RPLL_PD_OVRD, 2, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, PIPE_RATE_OVRD_EN, 1, 1)
    FIELD(CH0_PIPE_CTRL_CFG4, PIPE_RATE_EN, 0, 1)
REG32(CH0_PIPE_CTRL_CFG5, 0x3288)
    FIELD(CH0_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_SYNC_ERR_EN, 31, 1)
    FIELD(CH0_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_DP_DIS_EN, 30, 1)
    FIELD(CH0_PIPE_CTRL_CFG5, PIPE_SPECIAL_OFF_RESET_EN, 29, 1)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGT_ESM_DELAY_CE_DIS, 28, 1)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK2, 25, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK, 22, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_CORECLK, 19, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_E6_PIPECLK, 16, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_E5_PIPECLK, 13, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_G4_PIPECLK, 10, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_G3_PIPECLK, 7, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_G2_PIPECLK, 4, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, BUFGTDIV_G1_PIPECLK, 1, 3)
    FIELD(CH0_PIPE_CTRL_CFG5, PIPE_BUFGT_CTRL_EN, 0, 1)
REG32(CH0_PIPE_CTRL_CFG6, 0x328c)
    FIELD(CH0_PIPE_CTRL_CFG6, RXOOB_CLKDIV_VAL, 27, 5)
    FIELD(CH0_PIPE_CTRL_CFG6, PIPE_DIST_UB_DONE_SHARE_EN, 26, 1)
    FIELD(CH0_PIPE_CTRL_CFG6, PIPE_CONSUMPT_SEL, 23, 3)
    FIELD(CH0_PIPE_CTRL_CFG6, PIPE_DISTSOUTH_SEL, 21, 2)
    FIELD(CH0_PIPE_CTRL_CFG6, PIPE_DISTNORTH_SEL, 19, 2)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGTDIV_PIPECLK_OVRD, 16, 3)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGT_RSTMASK_OVRD, 12, 4)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGT_CEMASK_OVRD, 8, 4)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGT_CE_OVRD, 7, 1)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGT_RESET_OVRD, 6, 1)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGT_OVRD_EN, 5, 1)
    FIELD(CH0_PIPE_CTRL_CFG6, BUFGT_WAIT_CNT, 0, 5)
REG32(CH0_PIPE_CTRL_CFG7, 0x3290)
    FIELD(CH0_PIPE_CTRL_CFG7, CDR_CTRL_USE_RAW_SIGVALID, 31, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, RXELECIDLE_USE_RAW_SIGVALID, 30, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, CDR_CTRL_ADAPT_HOLD_EN, 29, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, PIPE_DIST_PLLLOCK_SEL, 27, 2)
    FIELD(CH0_PIPE_CTRL_CFG7, RXPD_IND_CONTROL, 26, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, RATE_USE_LCPLL_OUTCLK_ESM56, 25, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, CDR_CTRL_USER_HOLDCDR_EN, 24, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, RX_DABYP_DIVSEL, 20, 4)
    FIELD(CH0_PIPE_CTRL_CFG7, RX_DA_DIVSEL, 16, 4)
    FIELD(CH0_PIPE_CTRL_CFG7, RX_DA_BYP, 15, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, RXOUTCLKCTL, 12, 3)
    FIELD(CH0_PIPE_CTRL_CFG7, TX_DABYP_DIVSEL, 8, 4)
    FIELD(CH0_PIPE_CTRL_CFG7, TX_DA_DIVSEL, 4, 4)
    FIELD(CH0_PIPE_CTRL_CFG7, TX_DA_BYP, 3, 1)
    FIELD(CH0_PIPE_CTRL_CFG7, TXOUTCLKCTL, 0, 3)
REG32(CH0_PIPE_CTRL_CFG8, 0x3294)
    FIELD(CH0_PIPE_CTRL_CFG8, PMA_OOB_CLKDIV_VAL, 30, 2)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_ALIGN_REQ_OVRD, 29, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_SLIP_EN, 28, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_HOLDCDR_RX_PHALIGN, 27, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G34, 26, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G12, 25, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_REFCLK_MODE, 23, 2)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_GEN34_ON_EIDLE, 22, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_GEN12_ON_EIDLE, 21, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, CDR_CTRL_EN, 20, 1)
    FIELD(CH0_PIPE_CTRL_CFG8, RXPROGDIVSEL, 10, 10)
    FIELD(CH0_PIPE_CTRL_CFG8, TXPROGDIVSEL, 0, 10)
REG32(CH0_PIPE_CTRL_CFG9, 0x3298)
    FIELD(CH0_PIPE_CTRL_CFG9, TX_RESET_TIMER_SAMPLES_LG, 30, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, TX_RESET_TIMER_RST_OFFSET, 25, 5)
    FIELD(CH0_PIPE_CTRL_CFG9, TX_RESET_TIMER_CNT_FIRST, 21, 4)
    FIELD(CH0_PIPE_CTRL_CFG9, TX_RESET_TIMER_EN, 20, 1)
    FIELD(CH0_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_IN_SEL, 18, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_IN_SEL, 16, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, RXSYNCDONE_CONSUMPT_SEL, 13, 3)
    FIELD(CH0_PIPE_CTRL_CFG9, RXSYNCDONE_DISTSOUTH_SEL, 11, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, RXSYNCDONE_DISTNORTH_SEL, 9, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_DIS, 8, 1)
    FIELD(CH0_PIPE_CTRL_CFG9, TXSYNCDONE_CONSUMPT_SEL, 5, 3)
    FIELD(CH0_PIPE_CTRL_CFG9, TXSYNCDONE_DISTSOUTH_SEL, 3, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, TXSYNCDONE_DISTNORTH_SEL, 1, 2)
    FIELD(CH0_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_DIS, 0, 1)
REG32(CH0_TX_PIPPM_CFG, 0x329c)
    FIELD(CH0_TX_PIPPM_CFG, TXPI_SYNFREQ_PPM, 25, 5)
    FIELD(CH0_TX_PIPPM_CFG, TXPI_DDR_EN, 24, 1)
    FIELD(CH0_TX_PIPPM_CFG, TXPI_PPM_DDR_CFG, 16, 8)
    FIELD(CH0_TX_PIPPM_CFG, TXPI_INVSTROBE_SEL, 15, 1)
    FIELD(CH0_TX_PIPPM_CFG, TXPI_PPM_CFG, 4, 8)
    FIELD(CH0_TX_PIPPM_CFG, TXPIPPMOVRDEN, 3, 1)
    FIELD(CH0_TX_PIPPM_CFG, TXPI_GRAY_SEL, 2, 1)
    FIELD(CH0_TX_PIPPM_CFG, TXPIPPMSEL, 1, 1)
    FIELD(CH0_TX_PIPPM_CFG, TXPIPPMPD, 0, 1)
REG32(CH0_CHL_RSV_CFG2, 0x32a0)
REG32(CH0_FABRIC_INTF_CFG0, 0x32a4)
    FIELD(CH0_FABRIC_INTF_CFG0, HSDPPCSRESET_PIN_EN, 31, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, USRRDY_PIN_EN, 30, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RX_RATE_PIN_EN, 29, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TX_RATE_PIN_EN, 28, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, CDR_PIN_EN, 27, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, QPI_PIN_EN, 26, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, ILO_RESET_PIN_EN, 25, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, PERSTB_PIN_EN, 24, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, LOOPBACK_PIN_EN, 23, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TX_PHDLYRESET_PIN_EN, 22, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TX_PHALIGN_PIN_EN, 21, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TX_DAPI_PIN_EN, 20, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RXTERMINATION_PIN_EN, 19, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TXPOLARITY_PIN_EN, 18, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TXPI_PIN_EN, 17, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TXPISOPD_PIN_EN, 16, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TXPIPPM_PIN_EN, 15, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TXPD_PIN_EN, 14, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TXINHIBIT_PIN_EN, 13, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, TX_CHRESET_PIN_EN, 12, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RX_PHDLYRESET_PIN_EN, 11, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RX_PHALIGN_PIN_EN, 10, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RX_EQTRAINING_PIN_EN, 9, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RX_DAPI_PIN_EN, 8, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RX_CHRESET_PIN_EN, 7, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RXSLIDE_PIN_EN, 6, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, PRBSSEL_PIN_EN, 5, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RXPOLARITY_PIN_EN, 4, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RXPD_PIN_EN, 3, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RXLPM_PIN_EN, 2, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, APT_PIN_EN, 1, 1)
    FIELD(CH0_FABRIC_INTF_CFG0, RXCDRHOLD_PIN_EN, 0, 1)
REG32(CH0_FABRIC_INTF_CFG1, 0x32a8)
    FIELD(CH0_FABRIC_INTF_CFG1, A_RXSLIDE, 31, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_TXRATE, 23, 8)
    FIELD(CH0_FABRIC_INTF_CFG1, A_RXPRBSSEL, 19, 4)
    FIELD(CH0_FABRIC_INTF_CFG1, A_RXPOLARITY, 18, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_RXPD, 16, 2)
    FIELD(CH0_FABRIC_INTF_CFG1, A_RXLPMEN, 15, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRHOLD, 11, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_PERSTB, 10, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_LOOPBACK, 7, 3)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRSTEPSX, 6, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRSTEPSQ, 5, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRSTEPDIR, 4, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRINCPCTRL, 3, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRFREQOS, 2, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDROVREN, 1, 1)
    FIELD(CH0_FABRIC_INTF_CFG1, A_CDRBMCDRREQ, 0, 1)
REG32(CH0_FABRIC_INTF_CFG2, 0x32ac)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RXUSRRDY, 31, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_TXUSRRDY, 30, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_ILO_RESETMASK, 29, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_ILORESET, 28, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_CDRPHRESET, 27, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_EYESCANRESET, 26, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RXOOBRESET, 25, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RXPRBSCNTRESET, 24, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RX_PROGDIVRESET, 23, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_GTRXRESET, 22, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RX_RESETMODE, 20, 2)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RX_PCS_RESETMASK, 15, 5)
    FIELD(CH0_FABRIC_INTF_CFG2, A_RX_PMA_RESETMASK, 8, 7)
    FIELD(CH0_FABRIC_INTF_CFG2, A_TX_PCS_RESETMASK, 7, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_TX_PMA_RESETMASK, 4, 3)
    FIELD(CH0_FABRIC_INTF_CFG2, A_TX_PROGDIVRESET, 3, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_GTTXRESET, 2, 1)
    FIELD(CH0_FABRIC_INTF_CFG2, A_TX_RESETMODE, 0, 2)
REG32(CH0_FABRIC_INTF_CFG3, 0x32b0)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXDAPICODERESET, 31, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXDAPICODEOVRDEN, 30, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXPOLARITY, 29, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXPICODERESET, 28, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXPICODEOVRDEN, 27, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXPISOPD, 26, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_STEPSIZEPPM, 21, 5)
    FIELD(CH0_FABRIC_INTF_CFG3, A_ENPPM, 20, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXPD, 18, 2)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXINHIBIT, 17, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXPHSHIFT180, 16, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXPHSETINITREQ, 15, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXPHALIGNREQ, 14, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXPHDLYPD, 13, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXDLYALIGNREQ, 12, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXMLFINEALIGNREQ, 11, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXMLDCHAINREQ, 10, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXMLDCHAINDONE, 9, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXEQTRAINING, 8, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXDAPICODERESET, 7, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXDAPICODEOVRDEN, 6, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXDAPIRESET, 5, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RX_PHALIGN_RESETMASK, 4, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_RXPHDLYRESET, 3, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXDAPIRESET, 2, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TX_PHALIGN_RESETMASK, 1, 1)
    FIELD(CH0_FABRIC_INTF_CFG3, A_TXPHDLYRESET, 0, 1)
REG32(CH0_FABRIC_INTF_CFG4, 0x32b4)
    FIELD(CH0_FABRIC_INTF_CFG4, A_APT_OVERWREN, 31, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_APT_EXTHOLD, 30, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_RXQPIEN, 29, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXQPIWEAKPU, 28, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXQPIBIASEN, 27, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_EYESCANTRIGGER, 26, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_PHY_ESM_ADAPTATION_SAVE, 25, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_RXTERMINATION, 24, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_RXRATE, 16, 8)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXDAPIRESETMASK, 13, 2)
    FIELD(CH0_FABRIC_INTF_CFG4, A_RXDAPIRESETMASK, 11, 2)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXMLFINEALIGNREQ, 10, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXMLDCHAINREQ, 9, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXDLYALIGNREQ, 8, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXPHSHIFT180, 7, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXPHSETINITREQ, 6, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXPHALIGNREQ, 5, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXPHDLYPD, 4, 1)
    FIELD(CH0_FABRIC_INTF_CFG4, A_TXPRBSSEL, 0, 4)
REG32(CH0_FABRIC_INTF_CFG5, 0x32b8)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXEMPPRE, 27, 5)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXEMPPOS, 22, 5)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXEMPMAIN, 15, 7)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXDRVAMP, 10, 5)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXDEEMPH, 8, 2)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXSWING, 7, 1)
    FIELD(CH0_FABRIC_INTF_CFG5, A_TXMARGIN, 4, 3)
    FIELD(CH0_FABRIC_INTF_CFG5, EYESCANTRIGGER_PIN_EN, 2, 1)
    FIELD(CH0_FABRIC_INTF_CFG5, TX_EQ_PIN_EN, 1, 1)
    FIELD(CH0_FABRIC_INTF_CFG5, PHYESMADAPTSAVE_PIN_EN, 0, 1)
REG32(CH0_RX_ELASTIC_BUF_CFG1, 0x32bc)
    FIELD(CH0_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_3, 22, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_2, 12, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_1, 2, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_PRECEDENCE, 1, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_KEEP_IDLE, 0, 1)
REG32(CH0_RX_ELASTIC_BUF_CFG2, 0x32c0)
    FIELD(CH0_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_LEN, 30, 2)
    FIELD(CH0_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_2, 20, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_1, 10, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_1_4, 0, 10)
REG32(CH0_RX_ELASTIC_BUF_CFG3, 0x32c4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_DISPERR_SEQ_MATCH, 31, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_DATA_SOURCE_SEL, 30, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_USB3_CLK_COR_EQ_EN, 29, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_EN, 25, 4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_1_EN, 21, 4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_USE, 20, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_4, 10, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_3, 0, 10)
REG32(CH0_RX_ELASTIC_BUF_CFG4, 0x32c8)
    FIELD(CH0_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_3, 22, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_2, 12, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_1, 2, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_LEN, 0, 2)
REG32(CH0_RX_ELASTIC_BUF_CFG5, 0x32cc)
    FIELD(CH0_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_USE, 30, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_2, 20, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_1, 10, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_1_4, 0, 10)
REG32(CH0_RX_ELASTIC_BUF_CFG6, 0x32d0)
    FIELD(CH0_RX_ELASTIC_BUF_CFG6, EB_8B10B_FTS_DESKEW_SEQ_EN, 28, 4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_EN, 24, 4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_1_EN, 20, 4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_4, 10, 10)
    FIELD(CH0_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_3, 0, 10)
REG32(CH0_RX_ELASTIC_BUF_CFG7, 0x32d4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB128B130B_32_BLKALGN_CTL, 31, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB128B130B_32_EIOS_LPBK4_BYP, 30, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB128B130B_16_BLKALGN_CTL, 29, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB128B130B_16_EIOS_LPBK4_BYP, 28, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB128B130B_32_ONE_SKP_INS_DEL, 26, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_SLAVE, 22, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MASTER, 21, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_LEVEL, 18, 3)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_BUFFER_CFG, 12, 6)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_DELAY_CC_AFTER_FTS, 11, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_KEEP_4ADJ, 10, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SNAP4_USE, 9, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SLIP4_USE, 8, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_LANE_DESKEW_EN, 7, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_KEEP_ALIGN, 6, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MAX_SKEW, 2, 4)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_EN, 1, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG7, EB8B10B_ADDR_MODE, 0, 1)
REG32(CH0_RX_ELASTIC_BUF_CFG8, 0x32d8)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EIOS_DEL_SEL, 31, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, EB128B130B_32_AUTO_REALIGN, 28, 2)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, EB128B130B_32_FULL_THRESH, 16, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EMPTY_THRESH, 11, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MAX_LAT, 6, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MIN_LAT, 1, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG8, ELASTICBUF_128B130B_EN, 0, 1)
REG32(CH0_RX_ELASTIC_BUF_CFG9, 0x32dc)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EIOS_DEL_SEL, 31, 1)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_AUTO_REALIGN, 28, 2)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_FULL_THRESH, 16, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EMPTY_THRESH, 11, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MAX_LAT, 6, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MIN_LAT, 1, 5)
    FIELD(CH0_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EN, 0, 1)
REG32(CH0_RX_OOB_CFG0, 0x32e0)
    FIELD(CH0_RX_OOB_CFG0, OOB_SATA_EIDLE_VAL, 27, 3)
    FIELD(CH0_RX_OOB_CFG0, OOB_SATA_BURST_VAL, 24, 3)
    FIELD(CH0_RX_OOB_CFG0, OOB_SATA_MAX_INIT, 18, 6)
    FIELD(CH0_RX_OOB_CFG0, OOB_SATA_MIN_INIT, 12, 6)
    FIELD(CH0_RX_OOB_CFG0, OOB_SATA_MAX_BURST, 6, 6)
    FIELD(CH0_RX_OOB_CFG0, OOB_SATA_MIN_BURST, 0, 6)
REG32(CH0_RX_OOB_CFG1, 0x32e4)
    FIELD(CH0_RX_OOB_CFG1, OOB_SAS_MAX_COM, 18, 7)
    FIELD(CH0_RX_OOB_CFG1, OOB_SAS_MIN_COM, 12, 6)
    FIELD(CH0_RX_OOB_CFG1, OOB_SATA_MAX_WAKE, 6, 6)
    FIELD(CH0_RX_OOB_CFG1, OOB_SATA_MIN_WAKE, 0, 6)
REG32(CH0_MONITOR_CFG, 0x32e8)
    FIELD(CH0_MONITOR_CFG, RXAMONSEL, 26, 6)
    FIELD(CH0_MONITOR_CFG, TXAMONSEL, 21, 5)
    FIELD(CH0_MONITOR_CFG, DAAMONSEL, 18, 3)
    FIELD(CH0_MONITOR_CFG, CHCKAMONSEL, 14, 4)
    FIELD(CH0_MONITOR_CFG, CHAMONSEL, 12, 2)
    FIELD(CH0_MONITOR_CFG, DMON_FIFO_BYPASS, 7, 1)
    FIELD(CH0_MONITOR_CFG, DMON_CLK_SRC, 4, 3)
    FIELD(CH0_MONITOR_CFG, DMON_DATA_SRC, 1, 3)
    FIELD(CH0_MONITOR_CFG, DMON_EN, 0, 1)
REG32(CH0_PIPE_CTRL_CFG10, 0x32ec)
    FIELD(CH0_PIPE_CTRL_CFG10, RATE_CHANGE_DURING_RST_EN, 31, 1)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_RXDAPI_RST_MASK, 25, 2)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_TXDAPI_RST_MASK, 23, 2)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_RXSYNC_RST_MASK, 22, 1)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_TXSYNC_RST_MASK, 21, 1)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_RXPCS_RST_MASK, 16, 5)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_RXPMA_RST_MASK, 9, 7)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_TXPCS_RST_MASK, 8, 1)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_TXPMA_RST_MASK, 5, 3)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_LCPLL_RST_MASK, 2, 2)
    FIELD(CH0_PIPE_CTRL_CFG10, PIPE_RPLL_RST_MASK, 0, 2)
REG32(CH0_CHL_RSV_CFG3, 0x32f0)
REG32(CH0_CHL_RSV_CFG4, 0x32f4)
REG32(MEMCELLX32F8, 0x32f8)
    FIELD(MEMCELLX32F8, QUAD_MUX0_REFCLK_SEL, 30, 2)
REG32(HSCLK0_HSDIST_CFG, 0x32fc)
    FIELD(HSCLK0_HSDIST_CFG, HSDIST_DIV2SEL, 16, 1)
    FIELD(HSCLK0_HSDIST_CFG, HSDIST_APROBE_EN_VREF, 7, 1)
    FIELD(HSCLK0_HSDIST_CFG, HSDIST_VREFSEL, 3, 2)
    FIELD(HSCLK0_HSDIST_CFG, HSDIST_CTRL, 0, 3)
REG32(HSCLK0_RPLL_LGC_CFG0, 0x3430)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_AUTO_FINE_EN, 31, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_FINE_SWEEP, 29, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_OVRD_MODE, 27, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_CRSACCY, 25, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_MONCLKCYCLE, 22, 3)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_PLLLOCKCOARSE, 20, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_PLLLOCKFACTOR, 18, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_UNLOCKCTRL, 16, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_VCTRL_LATCH_BYPASS, 15, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_BYP_LOCKDETECT, 13, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_COARSE_FREQ_OVRD_EN, 12, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLLLOCKEN, 11, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_ALLOW_LB2UB, 10, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_ALLOW_UB2LB, 9, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_VCO_SEL_AUTO, 8, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_VCO_SEL, 7, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG0, RPLL_COARSE_FREQ_OVRD, 0, 7)
REG32(HSCLK0_RPLL_LGC_CFG1, 0x3434)
    FIELD(HSCLK0_RPLL_LGC_CFG1, PLL_RESET_DLY_TIME, 24, 8)
    FIELD(HSCLK0_RPLL_LGC_CFG1, SDM_RESET_DLY_TIME, 20, 4)
    FIELD(HSCLK0_RPLL_LGC_CFG1, SDM_LOOP_BYPASS_HANDSHAKE, 19, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG1, PRESCALE_DIV, 17, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG1, RESET_ON_PWRDN, 16, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG1, RPLL_BIN_ORDER, 13, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG1, RPLL_SDM_ORDER, 11, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG1, SDM_WIDTHSEL, 9, 2)
    FIELD(HSCLK0_RPLL_LGC_CFG1, RATESEL, 8, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG1, BYPASS, 7, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG1, CLKSEL, 6, 1)
    FIELD(HSCLK0_RPLL_LGC_CFG1, TESTCON, 1, 5)
    FIELD(HSCLK0_RPLL_LGC_CFG1, TESTEN, 0, 1)
REG32(HSCLK0_RPLL_LGC_CFG2, 0x3438)
    FIELD(HSCLK0_RPLL_LGC_CFG2, SDM_SEED, 0, 25)
REG32(HSCLK0_RPLL_CFG0, 0x343c)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_IF_CTRL_CP2, 28, 3)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_IF_CTRL_CP1, 26, 2)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_IF_CTRL_CZ, 25, 1)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_RSTSEL, 18, 7)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_CPEN, 6, 12)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_ENPFD, 5, 1)
    FIELD(HSCLK0_RPLL_CFG0, RPLL_REFDIV, 0, 5)
REG32(TXRSTDONE_DIST_SEL, 0x3440)
    FIELD(TXRSTDONE_DIST_SEL, CH3_CONSUMPT_SEL, 28, 3)
    FIELD(TXRSTDONE_DIST_SEL, CH3_DISTSOUTH_SEL, 26, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH3_DISTNORTH_SEL, 24, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH2_CONSUMPT_SEL, 20, 3)
    FIELD(TXRSTDONE_DIST_SEL, CH2_DISTSOUTH_SEL, 18, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH2_DISTNORTH_SEL, 16, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH1_CONSUMPT_SEL, 12, 3)
    FIELD(TXRSTDONE_DIST_SEL, CH1_DISTSOUTH_SEL, 10, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH1_DISTNORTH_SEL, 8, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH0_CONSUMPT_SEL, 4, 3)
    FIELD(TXRSTDONE_DIST_SEL, CH0_DISTSOUTH_SEL, 2, 2)
    FIELD(TXRSTDONE_DIST_SEL, CH0_DISTNORTH_SEL, 0, 2)
REG32(RXRSTDONE_DIST_SEL, 0x3444)
    FIELD(RXRSTDONE_DIST_SEL, CH3_CONSUMPT_SEL, 28, 3)
    FIELD(RXRSTDONE_DIST_SEL, CH3_DISTSOUTH_SEL, 26, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH3_DISTNORTH_SEL, 24, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH2_CONSUMPT_SEL, 20, 3)
    FIELD(RXRSTDONE_DIST_SEL, CH2_DISTSOUTH_SEL, 18, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH2_DISTNORTH_SEL, 16, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH1_CONSUMPT_SEL, 12, 3)
    FIELD(RXRSTDONE_DIST_SEL, CH1_DISTSOUTH_SEL, 10, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH1_DISTNORTH_SEL, 8, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH0_CONSUMPT_SEL, 4, 3)
    FIELD(RXRSTDONE_DIST_SEL, CH0_DISTSOUTH_SEL, 2, 2)
    FIELD(RXRSTDONE_DIST_SEL, CH0_DISTNORTH_SEL, 0, 2)
REG32(MST_RESET_CFG, 0x3448)
    FIELD(MST_RESET_CFG, CH3_RX_LCPLL_RESET_EN, 31, 1)
    FIELD(MST_RESET_CFG, CH2_RX_LCPLL_RESET_EN, 30, 1)
    FIELD(MST_RESET_CFG, CH1_RX_LCPLL_RESET_EN, 29, 1)
    FIELD(MST_RESET_CFG, CH0_RX_LCPLL_RESET_EN, 28, 1)
    FIELD(MST_RESET_CFG, CH3_RX_CH_RESET_EN, 27, 1)
    FIELD(MST_RESET_CFG, CH3_RX_PROGDIV_RESET_EN, 26, 1)
    FIELD(MST_RESET_CFG, CH3_TX_CH_RESET_EN, 25, 1)
    FIELD(MST_RESET_CFG, CH3_TX_PROGDIV_RESET_EN, 24, 1)
    FIELD(MST_RESET_CFG, CH3_ILO_RESET_EN, 23, 1)
    FIELD(MST_RESET_CFG, CH2_RX_CH_RESET_EN, 22, 1)
    FIELD(MST_RESET_CFG, CH2_RX_PROGDIV_RESET_EN, 21, 1)
    FIELD(MST_RESET_CFG, CH2_TX_CH_RESET_EN, 20, 1)
    FIELD(MST_RESET_CFG, CH2_TX_PROGDIV_RESET_EN, 19, 1)
    FIELD(MST_RESET_CFG, CH2_ILO_RESET_EN, 18, 1)
    FIELD(MST_RESET_CFG, CH1_RX_CH_RESET_EN, 17, 1)
    FIELD(MST_RESET_CFG, CH1_RX_PROGDIV_RESET_EN, 16, 1)
    FIELD(MST_RESET_CFG, CH1_TX_CH_RESET_EN, 15, 1)
    FIELD(MST_RESET_CFG, CH1_TX_PROGDIV_RESET_EN, 14, 1)
    FIELD(MST_RESET_CFG, CH1_ILO_RESET_EN, 13, 1)
    FIELD(MST_RESET_CFG, CH0_RX_CH_RESET_EN, 12, 1)
    FIELD(MST_RESET_CFG, CH0_RX_PROGDIV_RESET_EN, 11, 1)
    FIELD(MST_RESET_CFG, CH0_TX_CH_RESET_EN, 10, 1)
    FIELD(MST_RESET_CFG, CH0_TX_PROGDIV_RESET_EN, 9, 1)
    FIELD(MST_RESET_CFG, CH0_ILO_RESET_EN, 8, 1)
    FIELD(MST_RESET_CFG, CH3_RPLL_RESET_EN, 7, 1)
    FIELD(MST_RESET_CFG, CH2_RPLL_RESET_EN, 6, 1)
    FIELD(MST_RESET_CFG, CH1_RPLL_RESET_EN, 5, 1)
    FIELD(MST_RESET_CFG, CH0_RPLL_RESET_EN, 4, 1)
    FIELD(MST_RESET_CFG, CH3_LCPLL_RESET_EN, 3, 1)
    FIELD(MST_RESET_CFG, CH2_LCPLL_RESET_EN, 2, 1)
    FIELD(MST_RESET_CFG, CH1_LCPLL_RESET_EN, 1, 1)
    FIELD(MST_RESET_CFG, CH0_LCPLL_RESET_EN, 0, 1)
REG32(POR_CFG, 0x344c)
    FIELD(POR_CFG, VCTRL_BYP_RPLL, 15, 5)
    FIELD(POR_CFG, VCTRL_BYP_LCPLL, 10, 5)
    FIELD(POR_CFG, RPLL_TSENSE_BYP, 9, 1)
    FIELD(POR_CFG, LCPLL_TSENSE_BYP, 8, 1)
    FIELD(POR_CFG, GTPWRGOOD_DLY_TIME, 4, 4)
    FIELD(POR_CFG, POR_RAMP_TIME, 0, 4)
REG32(HSCLK0_RPLL_CFG1, 0x3470)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_SAP_EN_VREG, 31, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_SAP_EN_VCTRL, 30, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_SAP_EN_ICP, 29, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_EN_ANATEST1V, 28, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_VREG_FILTER_CTRL, 23, 5)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_VREG_FILTER_BYPASS, 22, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_VCCSEL, 19, 3)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_RVCO_CCI, 14, 5)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_RVCO_TC_EXTB, 8, 6)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_SAP_EN_AVCC_VCDL, 7, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_TCMP_BYPASS, 6, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_TCMP_ENABLE, 5, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_DYNSEL, 3, 1)
    FIELD(HSCLK0_RPLL_CFG1, RPLL_REFCLK_SEL, 0, 3)
REG32(HSCLK0_RPLL_CFG2, 0x3474)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_TEST_DIG_SEL, 31, 1)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_DMON_EN, 29, 2)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_BAND_SEL, 25, 4)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_FBK_RES_SEL, 23, 2)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_IF_CTRL_RP, 7, 3)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_IF_CTRL_RP_EN, 6, 1)
    FIELD(HSCLK0_RPLL_CFG2, RPLL_IF_CTRL_RZ, 0, 6)
REG32(CH1_RESET_TIME_CFG0, 0x3478)
    FIELD(CH1_RESET_TIME_CFG0, TX_PCS_RESET_TIME, 25, 5)
    FIELD(CH1_RESET_TIME_CFG0, TX_PMA_RESET_TIME, 20, 5)
    FIELD(CH1_RESET_TIME_CFG0, TX_CLKGEN_RESET_TIME, 15, 5)
    FIELD(CH1_RESET_TIME_CFG0, TX_DCD_RESET_TIME, 10, 5)
    FIELD(CH1_RESET_TIME_CFG0, ILO_RESET_TIME, 0, 5)
REG32(CH1_RESET_TIME_CFG1, 0x347c)
    FIELD(CH1_RESET_TIME_CFG1, RX_PMA_RESET_TIME, 25, 5)
    FIELD(CH1_RESET_TIME_CFG1, RX_CLKGEN_RESET_TIME, 20, 5)
    FIELD(CH1_RESET_TIME_CFG1, RX_DCD_RESET_TIME, 15, 5)
    FIELD(CH1_RESET_TIME_CFG1, RX_CFOK_RESET_TIME, 10, 5)
    FIELD(CH1_RESET_TIME_CFG1, RX_PHALIGN_RESET_TIME, 5, 5)
    FIELD(CH1_RESET_TIME_CFG1, TX_PHALIGN_RESET_TIME, 0, 5)
REG32(CH1_RESET_TIME_CFG2, 0x3480)
    FIELD(CH1_RESET_TIME_CFG2, RX_BUF_RESET_TIME, 25, 5)
    FIELD(CH1_RESET_TIME_CFG2, RX_PRBS_RESET_TIME, 20, 5)
    FIELD(CH1_RESET_TIME_CFG2, RX_PCS_RESET_TIME, 15, 5)
    FIELD(CH1_RESET_TIME_CFG2, RX_DFE_RESET_TIME, 10, 5)
    FIELD(CH1_RESET_TIME_CFG2, RX_CDRFREQ_RESET_TIME, 5, 5)
    FIELD(CH1_RESET_TIME_CFG2, RX_CDRPHASE_RESET_TIME, 0, 5)
REG32(CH1_RESET_TIME_CFG3, 0x3484)
    FIELD(CH1_RESET_TIME_CFG3, TX_DAPI_RESET_TIME, 29, 3)
    FIELD(CH1_RESET_TIME_CFG3, RX_DAPI_RESET_TIME, 26, 3)
    FIELD(CH1_RESET_TIME_CFG3, TX_DAPIDIV_RESET_TIME, 21, 5)
    FIELD(CH1_RESET_TIME_CFG3, RX_DAPIDIV_RESET_TIME, 16, 5)
    FIELD(CH1_RESET_TIME_CFG3, RX_PROGDIV_RESET_TIME, 13, 3)
    FIELD(CH1_RESET_TIME_CFG3, TX_PROGDIV_RESET_TIME, 10, 3)
    FIELD(CH1_RESET_TIME_CFG3, RX_EYESCAN_RESET_TIME, 5, 5)
    FIELD(CH1_RESET_TIME_CFG3, RX_OOB_RESET_TIME, 0, 5)
REG32(CH1_RESET_LOOPER_ID_CFG, 0x3488)
    FIELD(CH1_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_END_ID, 28, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_START_ID, 24, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_END_ID, 20, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_START_ID, 16, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_END_ID, 12, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_START_ID, 8, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_END_ID, 4, 4)
    FIELD(CH1_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_START_ID, 0, 4)
REG32(CH1_RESET_LOOP_ID_CFG0, 0x348c)
    FIELD(CH1_RESET_LOOP_ID_CFG0, TX_PCS_RESET_LOOP_ID, 12, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG0, TX_PMA_RESET_LOOP_ID, 8, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG0, TX_CLKGEN_RESET_LOOP_ID, 4, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG0, TX_DCD_RESET_LOOP_ID, 0, 4)
REG32(CH1_RESET_LOOP_ID_CFG1, 0x3490)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_PCS_RESET_LOOP_ID, 28, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_DFE_RESET_LOOP_ID, 24, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_CDRFREQ_RESET_LOOP_ID, 20, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_CDRPHASE_RESET_LOOP_ID, 16, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_PMA_RESET_LOOP_ID, 12, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_CLKGEN_RESET_LOOP_ID, 8, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_DCD_RESET_LOOP_ID, 4, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG1, RX_CFOK_RESET_LOOP_ID, 0, 4)
REG32(CH1_RESET_LOOP_ID_CFG2, 0x3494)
    FIELD(CH1_RESET_LOOP_ID_CFG2, RX_OOB_RESET_LOOP_ID, 12, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG2, RX_EYESCAN_RESET_LOOP_ID, 8, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG2, RX_BUF_RESET_LOOP_ID, 4, 4)
    FIELD(CH1_RESET_LOOP_ID_CFG2, RX_PRBS_RESET_LOOP_ID, 0, 4)
REG32(CH1_RESET_BYP_HDSHK_CFG, 0x3498)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDAPI_RESET_LOOP, 9, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDAPI_RESET_LOOP, 8, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CDR_RESET_LOOP, 7, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDCD_RESET_LOOP, 6, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CFOK_RESET_LOOP, 5, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RX_PHALIGN_RESET_LOOP, 4, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PHALIGN_RESET_LOOP, 3, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDCD_RESET_LOOP, 2, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PCS_RESET_LOOP, 1, 1)
    FIELD(CH1_RESET_BYP_HDSHK_CFG, BYP_HDSHK_ILO_RESET_LOOP, 0, 1)
REG32(CH1_RESET_CFG, 0x349c)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_EIDLE_LO_CNT, 28, 4)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_EIDLE_HI_CNT, 24, 4)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_ON_EIDLE, 23, 1)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_ON_COMMAALIGN, 22, 1)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_DEFER_EN, 21, 1)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_ON_RXVALID, 20, 1)
    FIELD(CH1_RESET_CFG, EB8B10B_RESET_ON_UNALIGN, 19, 1)
    FIELD(CH1_RESET_CFG, HSDP_MST_RESET_EN, 16, 1)
    FIELD(CH1_RESET_CFG, TXPHYCLK_FREQ_CNT_EN, 15, 1)
    FIELD(CH1_RESET_CFG, TXPCSCLK_FREQ_CNT_EN, 14, 1)
    FIELD(CH1_RESET_CFG, TXUSRCLK_FREQ_CNT_EN, 13, 1)
    FIELD(CH1_RESET_CFG, RXPHYCLK_FREQ_CNT_EN, 12, 1)
    FIELD(CH1_RESET_CFG, RXPCSCLK_FREQ_CNT_EN, 11, 1)
    FIELD(CH1_RESET_CFG, RXUSRCLK_FREQ_CNT_EN, 10, 1)
    FIELD(CH1_RESET_CFG, CDR_SOFTRESET_MODE, 7, 1)
    FIELD(CH1_RESET_CFG, ILORESET_BYPASS_MODE, 6, 1)
    FIELD(CH1_RESET_CFG, ILORESET_ON_PLLLOCK, 5, 1)
    FIELD(CH1_RESET_CFG, ILORESET_PLLLOCK_SEL, 4, 1)
    FIELD(CH1_RESET_CFG, RX_PMA_RST_SYNC_DISABLE, 3, 1)
    FIELD(CH1_RESET_CFG, PRESCALE_DIV, 0, 3)
REG32(MEMCELLX34A0, 0x34a0)
    FIELD(MEMCELLX34A0, CH1_INSTANTIATED, 31, 1)
    FIELD(MEMCELLX34A0, CH1_SIM_TX_EIDLE_DRIVE_LEVEL, 6, 2)
    FIELD(MEMCELLX34A0, CH1_SIM_RESET_SPEEDUP, 5, 1)
    FIELD(MEMCELLX34A0, CH1_SIM_RECEIVER_DETECT_PASS, 4, 1)
    FIELD(MEMCELLX34A0, CH1_SIM_MODE, 0, 4)
REG32(CH1_TX_ANA_CFG0, 0x34a4)
    FIELD(CH1_TX_ANA_CFG0, TX_VREG_CTRL, 6, 3)
    FIELD(CH1_TX_ANA_CFG0, TX_VREG_VREFSEL, 4, 2)
    FIELD(CH1_TX_ANA_CFG0, TX_LPK_SARC_ENB, 3, 1)
REG32(CH1_TX_DRV_CFG0, 0x34a8)
    FIELD(CH1_TX_DRV_CFG0, TX_REG_COMP_EN, 31, 1)
    FIELD(CH1_TX_DRV_CFG0, TX_REG_SCALE_SEL, 25, 6)
    FIELD(CH1_TX_DRV_CFG0, TX_CTL_DRV_OVR_EN, 24, 1)
    FIELD(CH1_TX_DRV_CFG0, TX_CTL_DRV_EN, 20, 4)
    FIELD(CH1_TX_DRV_CFG0, TX_REFBIAS_ENB_IPP, 19, 1)
    FIELD(CH1_TX_DRV_CFG0, TX_REFBIAS_EN_AVCC, 18, 1)
    FIELD(CH1_TX_DRV_CFG0, TX_QPI_STATEN, 4, 1)
    FIELD(CH1_TX_DRV_CFG0, TX_TXLPK_DRVHIZ, 3, 1)
    FIELD(CH1_TX_DRV_CFG0, TX_SW_MEAS, 0, 3)
REG32(CH1_TX_DRV_CFG1, 0x34ac)
    FIELD(CH1_TX_DRV_CFG1, TX_VCTRLN_ADJ_EN, 31, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_VCTRLP_ADJ_EN, 30, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_ZRES_RATIO_SEL, 22, 5)
    FIELD(CH1_TX_DRV_CFG1, TX_ZCTRLP_OVR_EN, 21, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_ZCTRLP_OVR_SEL, 19, 2)
    FIELD(CH1_TX_DRV_CFG1, TX_ZCTRLN_OVR_EN, 18, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_ZCTRLN_OVR_SEL, 16, 2)
    FIELD(CH1_TX_DRV_CFG1, TX_REGP_PDB, 12, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_REGN_PDB, 11, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_VSWING_SEL_OVR_EN, 10, 1)
    FIELD(CH1_TX_DRV_CFG1, TX_REGP_VSWING_SEL_OVR, 4, 6)
    FIELD(CH1_TX_DRV_CFG1, TX_REGN_VSWING_SEL_OVR, 0, 4)
REG32(CH1_CHL_RSV_CFG0, 0x34b0)
    FIELD(CH1_CHL_RSV_CFG0, EB8B10B_RESET_RXVALID_DELAY, 28, 4)
    FIELD(CH1_CHL_RSV_CFG0, UBALZE_GPI_OUT1_SEL, 17, 2)
    FIELD(CH1_CHL_RSV_CFG0, UB_REPROG_DONE_RXPD_BYPASS, 16, 1)
    FIELD(CH1_CHL_RSV_CFG0, RXPOWERDOWN_UBLAZE_CTRL_EN, 15, 1)
    FIELD(CH1_CHL_RSV_CFG0, RXTERMINATION_OVRD, 13, 2)
    FIELD(CH1_CHL_RSV_CFG0, UB_REPROG_DONE_TXPD_BYPASS, 12, 1)
    FIELD(CH1_CHL_RSV_CFG0, UBALZE_GPI_OUT3_SEL, 10, 2)
    FIELD(CH1_CHL_RSV_CFG0, TXPOWERDOWN_UBLAZE_CTRL_EN, 9, 1)
    FIELD(CH1_CHL_RSV_CFG0, PD_TRANS_TIME_CPMIN, 0, 9)
REG32(CH1_TX_SER_CFG0, 0x34b4)
    FIELD(CH1_TX_SER_CFG0, TX_SEL_CLK_DLY, 10, 2)
    FIELD(CH1_TX_SER_CFG0, CLK_SEL_CLK_STG2, 8, 2)
    FIELD(CH1_TX_SER_CFG0, TX_SEL_CLK_PCS, 4, 4)
    FIELD(CH1_TX_SER_CFG0, TX_ENABLE_STG1, 3, 1)
REG32(CH1_RX_CDR_CFG0, 0x34b8)
    FIELD(CH1_RX_CDR_CFG0, SELMODE, 31, 1)
    FIELD(CH1_RX_CDR_CFG0, DATAWIDTH_OVR, 27, 4)
    FIELD(CH1_RX_CDR_CFG0, LOWLATENCY_OVR, 26, 1)
    FIELD(CH1_RX_CDR_CFG0, S_SEL, 20, 2)
    FIELD(CH1_RX_CDR_CFG0, D_SEL_Y, 19, 1)
    FIELD(CH1_RX_CDR_CFG0, D_SEL_P, 18, 1)
    FIELD(CH1_RX_CDR_CFG0, Y_SEL_X, 17, 1)
    FIELD(CH1_RX_CDR_CFG0, X_SEL_Y, 16, 1)
    FIELD(CH1_RX_CDR_CFG0, WALKSPEED_BM, 14, 2)
    FIELD(CH1_RX_CDR_CFG0, WALKSPEED_CMN, 12, 2)
    FIELD(CH1_RX_CDR_CFG0, TESTCON, 8, 3)
    FIELD(CH1_RX_CDR_CFG0, TESTSRC, 5, 3)
    FIELD(CH1_RX_CDR_CFG0, TESTRATESEL, 3, 2)
    FIELD(CH1_RX_CDR_CFG0, TESTCHCLKSEL, 2, 1)
    FIELD(CH1_RX_CDR_CFG0, TESTEN, 1, 1)
    FIELD(CH1_RX_CDR_CFG0, CDRENF, 0, 1)
REG32(CH1_RX_CDR_CFG1, 0x34bc)
    FIELD(CH1_RX_CDR_CFG1, DELTA_SAT_MODE, 28, 3)
    FIELD(CH1_RX_CDR_CFG1, DXD_VAL, 16, 12)
    FIELD(CH1_RX_CDR_CFG1, CFG_TOGGLE, 15, 1)
    FIELD(CH1_RX_CDR_CFG1, FREQ_SYMM, 14, 1)
    FIELD(CH1_RX_CDR_CFG1, WALKSPEED_SLIP, 12, 2)
    FIELD(CH1_RX_CDR_CFG1, SLIP_MAG, 10, 2)
    FIELD(CH1_RX_CDR_CFG1, SLIP_ENB, 9, 1)
    FIELD(CH1_RX_CDR_CFG1, PI_DDR_MODE, 8, 1)
    FIELD(CH1_RX_CDR_CFG1, FLIPCLKTOPI, 7, 1)
    FIELD(CH1_RX_CDR_CFG1, PICODE_D_OVR, 0, 7)
REG32(CH1_RX_CDR_CFG2, 0x34c0)
    FIELD(CH1_RX_CDR_CFG2, DXDSCAL_DSEL_OVR, 31, 1)
    FIELD(CH1_RX_CDR_CFG2, DXDSCAL_EN_OVR, 30, 1)
    FIELD(CH1_RX_CDR_CFG2, DXDSCAL_CYCLES, 27, 3)
    FIELD(CH1_RX_CDR_CFG2, DXDSCAL_DS_EN, 26, 1)
    FIELD(CH1_RX_CDR_CFG2, DXDSCAL_DX_EN, 25, 1)
    FIELD(CH1_RX_CDR_CFG2, RX_DCC_DONE_BYP, 24, 1)
    FIELD(CH1_RX_CDR_CFG2, VOTEWX, 13, 3)
    FIELD(CH1_RX_CDR_CFG2, VOTEWY, 10, 3)
    FIELD(CH1_RX_CDR_CFG2, PMULFAC, 7, 3)
    FIELD(CH1_RX_CDR_CFG2, PDIVFAC, 4, 3)
    FIELD(CH1_RX_CDR_CFG2, FDIVFAC, 0, 4)
REG32(CH1_RX_CDR_CFG3, 0x34c4)
    FIELD(CH1_RX_CDR_CFG3, PMULFACDYNTARGET, 24, 8)
    FIELD(CH1_RX_CDR_CFG3, PMULFACDYNSEL, 22, 2)
    FIELD(CH1_RX_CDR_CFG3, PMULFACDYNEN, 21, 1)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQFAC3, 19, 2)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQCNT3, 16, 3)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQFAC2, 14, 2)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQCNT2, 11, 3)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQFAC1, 9, 2)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQCNT1, 6, 3)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQFAC0, 4, 2)
    FIELD(CH1_RX_CDR_CFG3, PMULSEQCNT0, 1, 3)
    FIELD(CH1_RX_CDR_CFG3, PMULFACSEQEN, 0, 1)
REG32(CH1_RX_CDR_CFG4, 0x34c8)
    FIELD(CH1_RX_CDR_CFG4, METASTABLE_MODE, 29, 2)
    FIELD(CH1_RX_CDR_CFG4, BMCDR_MISC, 27, 2)
    FIELD(CH1_RX_CDR_CFG4, BMCDR_MAG, 22, 5)
    FIELD(CH1_RX_CDR_CFG4, BMCDR_WINDOW, 18, 4)
    FIELD(CH1_RX_CDR_CFG4, BMCDR_MODE, 16, 2)
    FIELD(CH1_RX_CDR_CFG4, FORCEFOS, 15, 1)
    FIELD(CH1_RX_CDR_CFG4, FOSCNT, 12, 3)
    FIELD(CH1_RX_CDR_CFG4, FOSVAL, 0, 12)
REG32(CH1_ADAPT_APT_CFG, 0x34cc)
REG32(CH1_ADAPT_CAL_CFG, 0x34d0)
    FIELD(CH1_ADAPT_CAL_CFG, OVWRFNSH, 31, 1)
    FIELD(CH1_ADAPT_CAL_CFG, OVWRDAC, 25, 6)
    FIELD(CH1_ADAPT_CAL_CFG, OVWRADD, 21, 4)
    FIELD(CH1_ADAPT_CAL_CFG, OVWRPLS0, 20, 1)
    FIELD(CH1_ADAPT_CAL_CFG, OVWRSKIP, 19, 1)
    FIELD(CH1_ADAPT_CAL_CFG, SEQMAX, 16, 3)
    FIELD(CH1_ADAPT_CAL_CFG, WAITSEL, 14, 2)
    FIELD(CH1_ADAPT_CAL_CFG, MSHIFT, 11, 3)
    FIELD(CH1_ADAPT_CAL_CFG, CAL_INITDAC, 5, 6)
    FIELD(CH1_ADAPT_CAL_CFG, CALSKIP, 4, 1)
    FIELD(CH1_ADAPT_CAL_CFG, TESTCON, 1, 3)
    FIELD(CH1_ADAPT_CAL_CFG, CAL_CFG0, 0, 1)
REG32(CH1_ADAPT_DFE_CFG, 0x34d4)
    FIELD(CH1_ADAPT_DFE_CFG, TRGTCON, 30, 2)
    FIELD(CH1_ADAPT_DFE_CFG, DFE_CFG1, 29, 1)
    FIELD(CH1_ADAPT_DFE_CFG, H3INITDAC, 23, 6)
    FIELD(CH1_ADAPT_DFE_CFG, H2INITDAC, 16, 7)
    FIELD(CH1_ADAPT_DFE_CFG, DFE_CFG0, 15, 1)
    FIELD(CH1_ADAPT_DFE_CFG, UTINITDAC, 7, 8)
    FIELD(CH1_ADAPT_DFE_CFG, VPINITDAC, 0, 7)
REG32(CH1_ADAPT_GC_CFG0, 0x34d8)
    FIELD(CH1_ADAPT_GC_CFG0, GC_CFG01, 31, 1)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_DISFREZ, 30, 1)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_CYCSEL, 28, 2)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_DIFFSEL, 26, 2)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_CLRSEL, 24, 2)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_ENSEL, 22, 2)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_INITDAC, 17, 5)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_SELTGT, 16, 1)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_GEARSEL, 14, 2)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_GAINWIN, 12, 2)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_CNTSEL, 9, 3)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_MSHIFT, 5, 4)
    FIELD(CH1_ADAPT_GC_CFG0, AGC1_WAITSEL, 3, 2)
    FIELD(CH1_ADAPT_GC_CFG0, GC_CFG00, 0, 3)
REG32(CH1_ADAPT_GC_CFG1, 0x34dc)
    FIELD(CH1_ADAPT_GC_CFG1, AGC1_HYSTER, 25, 7)
    FIELD(CH1_ADAPT_GC_CFG1, AGC1_TARGET, 17, 8)
    FIELD(CH1_ADAPT_GC_CFG1, GC_CFG10, 10, 7)
    FIELD(CH1_ADAPT_GC_CFG1, AGC1_UPBDAC, 5, 5)
    FIELD(CH1_ADAPT_GC_CFG1, AGC1_LOBDAC, 0, 5)
REG32(CH1_ADAPT_GC_CFG2, 0x34e0)
    FIELD(CH1_ADAPT_GC_CFG2, GC_CFG22, 31, 1)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_DISFREZ, 30, 1)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_CYCSEL, 28, 2)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_DIFFSEL, 26, 2)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_CLRSEL, 24, 2)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_ENSEL, 22, 2)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_INITDAC, 17, 5)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_SELTGT, 16, 1)
    FIELD(CH1_ADAPT_GC_CFG2, GC_CFG21, 9, 7)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_MSHIFT, 5, 4)
    FIELD(CH1_ADAPT_GC_CFG2, AGC2_WAITSEL, 3, 2)
    FIELD(CH1_ADAPT_GC_CFG2, GC_CFG20, 0, 3)
REG32(CH1_ADAPT_GC_CFG3, 0x34e4)
    FIELD(CH1_ADAPT_GC_CFG3, AGC2_HYSTER, 25, 7)
    FIELD(CH1_ADAPT_GC_CFG3, AGC2_TARGET, 17, 8)
    FIELD(CH1_ADAPT_GC_CFG3, GC_CFG30, 10, 7)
    FIELD(CH1_ADAPT_GC_CFG3, AGC2_UPBDAC, 5, 5)
    FIELD(CH1_ADAPT_GC_CFG3, AGC2_LOBDAC, 0, 5)
REG32(CH1_ADAPT_GEN_CFG0, 0x34e8)
    FIELD(CH1_ADAPT_GEN_CFG0, PCSFLIP, 31, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, BAUDFLIP, 30, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, POWRDN, 29, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, CALCKON, 28, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, GE_CFG00, 27, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, CDRLOCK_DET1_DISLOOP, 26, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, CDRLOCK_DET0_DISLOOP, 25, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, CDRLOCK_DIS_DISLOOP, 24, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, OS_DISLOOP, 23, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, GC2_DISLOOP, 22, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, GC1_DISLOOP, 21, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, KLTUNE_DISLOOP, 20, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, KL_DISLOOP, 19, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, KHCLOAD_DISLOOP, 18, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, KHRDEG_DISLOOP, 17, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, KHCDEG_DISLOOP, 16, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, HF_DISLOOP, 15, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, HE_DISLOOP, 14, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, HD_DISLOOP, 13, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, HC_DISLOOP, 12, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, HB_DISLOOP, 11, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, HA_DISLOOP, 10, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H9_DISLOOP, 9, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H8_DISLOOP, 8, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H7_DISLOOP, 7, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H6_DISLOOP, 6, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H5_DISLOOP, 5, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H4_DISLOOP, 4, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H3_DISLOOP, 3, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, H2_DISLOOP, 2, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, UT_DISLOOP, 1, 1)
    FIELD(CH1_ADAPT_GEN_CFG0, VP_DISLOOP, 0, 1)
REG32(CH1_ADAPT_GEN_CFG1, 0x34ec)
    FIELD(CH1_ADAPT_GEN_CFG1, SELHALF, 31, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, TESTC, 27, 4)
    FIELD(CH1_ADAPT_GEN_CFG1, CDRLOCK_DET1_POWRDN, 26, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, CDRLOCK_DET0_POWRDN, 25, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, CDRLOCK_DIS_POWRDN, 24, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, OS_POWRDN, 23, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, GC2_POWRDN, 22, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, GC1_POWRDN, 21, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, KLTUNE_POWRDN, 20, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, KL_POWRDN, 19, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, KHCLOAD_POWRDN, 18, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, KHRDEG_POWRDN, 17, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, KHCDEG_POWRDN, 16, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, HF_POWRDN, 15, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, HE_POWRDN, 14, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, HD_POWRDN, 13, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, HC_POWRDN, 12, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, HB_POWRDN, 11, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, HA_POWRDN, 10, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H9_POWRDN, 9, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H8_POWRDN, 8, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H7_POWRDN, 7, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H6_POWRDN, 6, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H5_POWRDN, 5, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H4_POWRDN, 4, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H3_POWRDN, 3, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, H2_POWRDN, 2, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, UT_POWRDN, 1, 1)
    FIELD(CH1_ADAPT_GEN_CFG1, VP_POWRDN, 0, 1)
REG32(CH1_ADAPT_GEN_CFG2, 0x34f0)
    FIELD(CH1_ADAPT_GEN_CFG2, APTCTRL2, 31, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, MODSEL, 29, 2)
    FIELD(CH1_ADAPT_GEN_CFG2, SELCDR, 28, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, DISDYN, 27, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, CDRLOCK_DET1_EXHOLD, 26, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, CDRLOCK_DET0_EXHOLD, 25, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, CDRLOCK_DIS_EXHOLD, 24, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, OS_EXHOLD, 23, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, GC2_EXHOLD, 22, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, GC1_EXHOLD, 21, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, KLTUNE_EXHOLD, 20, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, KL_EXHOLD, 19, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, KHCLOAD_EXHOLD, 18, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, KHRDEG_EXHOLD, 17, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, KHCDEG_EXHOLD, 16, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, HF_EXHOLD, 15, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, HE_EXHOLD, 14, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, HD_EXHOLD, 13, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, HC_EXHOLD, 12, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, HB_EXHOLD, 11, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, HA_EXHOLD, 10, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H9_EXHOLD, 9, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H8_EXHOLD, 8, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H7_EXHOLD, 7, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H6_EXHOLD, 6, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H5_EXHOLD, 5, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H4_EXHOLD, 4, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H3_EXHOLD, 3, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, H2_EXHOLD, 2, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, UT_EXHOLD, 1, 1)
    FIELD(CH1_ADAPT_GEN_CFG2, VP_EXHOLD, 0, 1)
REG32(CH1_ADAPT_GEN_CFG3, 0x34f4)
    FIELD(CH1_ADAPT_GEN_CFG3, GEAREN, 31, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, GEARCTRL, 27, 4)
    FIELD(CH1_ADAPT_GEN_CFG3, CDRLOCK_DET1_OVWREN, 26, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, CDRLOCK_DET0_OVWREN, 25, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, CDRLOCK_DIS_OVWREN, 24, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, OS_OVWREN, 23, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, GC2_OVWREN, 22, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, GC1_OVWREN, 21, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, KLTUNE_OVWREN, 20, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, KL_OVWREN, 19, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, KHCLOAD_OVWREN, 18, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, KHRDEG_OVWREN, 17, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, KHCDEG_OVWREN, 16, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, HF_OVWREN, 15, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, HE_OVWREN, 14, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, HD_OVWREN, 13, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, HC_OVWREN, 12, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, HB_OVWREN, 11, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, HA_OVWREN, 10, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H9_OVWREN, 9, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H8_OVWREN, 8, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H7_OVWREN, 7, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H6_OVWREN, 6, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H5_OVWREN, 5, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H4_OVWREN, 4, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H3_OVWREN, 3, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, H2_OVWREN, 2, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, UT_OVWREN, 1, 1)
    FIELD(CH1_ADAPT_GEN_CFG3, VP_OVWREN, 0, 1)
REG32(CH1_ADAPT_H01_CFG, 0x34f8)
    FIELD(CH1_ADAPT_H01_CFG, UT_CFG1, 27, 5)
    FIELD(CH1_ADAPT_H01_CFG, UT_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_H01_CFG, UT_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_H01_CFG, UT_ENSYNC, 20, 1)
    FIELD(CH1_ADAPT_H01_CFG, UT_CFG0, 16, 4)
    FIELD(CH1_ADAPT_H01_CFG, VP_CFG1, 11, 5)
    FIELD(CH1_ADAPT_H01_CFG, VP_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_H01_CFG, VP_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_H01_CFG, VP_ENSYNCH, 4, 1)
    FIELD(CH1_ADAPT_H01_CFG, VP_ENSYNCL, 3, 1)
    FIELD(CH1_ADAPT_H01_CFG, VP_CFG0, 0, 3)
REG32(CH1_ADAPT_H23_CFG, 0x34fc)
    FIELD(CH1_ADAPT_H23_CFG, H3_CFG1, 27, 5)
    FIELD(CH1_ADAPT_H23_CFG, H3_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_H23_CFG, H3_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_H23_CFG, TESTC1, 16, 5)
    FIELD(CH1_ADAPT_H23_CFG, H2_CFG1, 11, 5)
    FIELD(CH1_ADAPT_H23_CFG, H2_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_H23_CFG, H2_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_H23_CFG, TESTC0, 0, 5)
REG32(CH1_ADAPT_H45_CFG, 0x3500)
    FIELD(CH1_ADAPT_H45_CFG, H5_INITDAC, 27, 5)
    FIELD(CH1_ADAPT_H45_CFG, H5_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_H45_CFG, H5_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_H45_CFG, UTCOEFF, 16, 5)
    FIELD(CH1_ADAPT_H45_CFG, H4_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_H45_CFG, H4_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_H45_CFG, H4_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_H45_CFG, TESTC21, 3, 2)
    FIELD(CH1_ADAPT_H45_CFG, TESTC20, 0, 3)
REG32(CH1_ADAPT_H67_CFG, 0x3504)
    FIELD(CH1_ADAPT_H67_CFG, H7_INITDAC, 27, 5)
    FIELD(CH1_ADAPT_H67_CFG, H7_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_H67_CFG, H7_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_H67_CFG, H3COEFF, 16, 5)
    FIELD(CH1_ADAPT_H67_CFG, H6_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_H67_CFG, H6_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_H67_CFG, H6_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_H67_CFG, H2COEFF, 0, 5)
REG32(CH1_ADAPT_H89_CFG, 0x3508)
    FIELD(CH1_ADAPT_H89_CFG, H9_INITDAC, 27, 5)
    FIELD(CH1_ADAPT_H89_CFG, H9_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_H89_CFG, H9_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_H89_CFG, H9_CFG1, 16, 5)
    FIELD(CH1_ADAPT_H89_CFG, H8_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_H89_CFG, H8_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_H89_CFG, H8_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_H89_CFG, H8_CFG1, 0, 5)
REG32(CH1_ADAPT_HAB_CFG, 0x350c)
    FIELD(CH1_ADAPT_HAB_CFG, HB_INITDAC, 27, 5)
    FIELD(CH1_ADAPT_HAB_CFG, HB_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_HAB_CFG, HB_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_HAB_CFG, HB_CFG1, 16, 5)
    FIELD(CH1_ADAPT_HAB_CFG, HA_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_HAB_CFG, HA_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_HAB_CFG, HA_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_HAB_CFG, HA_CFG1, 0, 5)
REG32(CH1_ADAPT_HCD_CFG, 0x3510)
    FIELD(CH1_ADAPT_HCD_CFG, HD_INITDAC, 27, 5)
    FIELD(CH1_ADAPT_HCD_CFG, HD_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_HCD_CFG, HD_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_HCD_CFG, HD_CFG1, 16, 5)
    FIELD(CH1_ADAPT_HCD_CFG, HC_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_HCD_CFG, HC_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_HCD_CFG, HC_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_HCD_CFG, HC_CFG1, 0, 5)
REG32(CH1_ADAPT_HEF_CFG, 0x3514)
    FIELD(CH1_ADAPT_HEF_CFG, HF_INITDAC, 27, 5)
    FIELD(CH1_ADAPT_HEF_CFG, HF_MSHIFT, 23, 4)
    FIELD(CH1_ADAPT_HEF_CFG, HF_WAITSEL, 21, 2)
    FIELD(CH1_ADAPT_HEF_CFG, HE_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_HEF_CFG, HE_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_HEF_CFG, HE_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_HEF_CFG, HE_CFG1, 0, 5)
REG32(CH1_ADAPT_KH_CFG0, 0x3518)
    FIELD(CH1_ADAPT_KH_CFG0, KHCDEG_UTVPRATIO, 24, 8)
    FIELD(CH1_ADAPT_KH_CFG0, KHCDEG_HYSTERSIS, 16, 8)
    FIELD(CH1_ADAPT_KH_CFG0, KHCDEG_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_KH_CFG0, KHCDEG_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_KH_CFG0, WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_KH_CFG0, KH_CFG00, 0, 5)
REG32(CH1_ADAPT_KH_CFG1, 0x351c)
    FIELD(CH1_ADAPT_KH_CFG1, KH_CFG10, 7, 25)
    FIELD(CH1_ADAPT_KH_CFG1, KHCDEG_TARGET, 0, 7)
REG32(CH1_ADAPT_KH_CFG2, 0x3520)
    FIELD(CH1_ADAPT_KH_CFG2, KH_CFG21, 15, 17)
    FIELD(CH1_ADAPT_KH_CFG2, KHRDEG_INITDAC, 11, 4)
    FIELD(CH1_ADAPT_KH_CFG2, KHRDEG_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_KH_CFG2, KHRDEG_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_KH_CFG2, KH_CFG20, 0, 5)
REG32(CH1_ADAPT_KH_CFG3, 0x3524)
REG32(CH1_ADAPT_KH_CFG4, 0x3528)
    FIELD(CH1_ADAPT_KH_CFG4, KH_CFG41, 16, 16)
    FIELD(CH1_ADAPT_KH_CFG4, KHCLOAD_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_KH_CFG4, KHCLOAD_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_KH_CFG4, WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_KH_CFG4, KH_CFG40, 0, 5)
REG32(CH1_ADAPT_KH_CFG5, 0x352c)
REG32(CH1_ADAPT_KL_CFG0, 0x3530)
    FIELD(CH1_ADAPT_KL_CFG0, KL_CFG01, 16, 16)
    FIELD(CH1_ADAPT_KL_CFG0, KL_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_KL_CFG0, KL_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_KL_CFG0, KL_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_KL_CFG0, KL_CFG00, 0, 5)
REG32(CH1_ADAPT_KL_CFG1, 0x3534)
    FIELD(CH1_ADAPT_KL_CFG1, KL_CFG11, 16, 16)
    FIELD(CH1_ADAPT_KL_CFG1, KLTUNE_INITDAC, 11, 5)
    FIELD(CH1_ADAPT_KL_CFG1, KLTUNE_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_KL_CFG1, KLTUNE_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_KL_CFG1, KL_CFG10, 0, 5)
REG32(CH1_ADAPT_LCK_CFG0, 0x3538)
    FIELD(CH1_ADAPT_LCK_CFG0, LCK_CFG0, 30, 2)
    FIELD(CH1_ADAPT_LCK_CFG0, THRD, 24, 6)
    FIELD(CH1_ADAPT_LCK_CFG0, OUTLCKDIS, 23, 1)
    FIELD(CH1_ADAPT_LCK_CFG0, GAIN2, 19, 4)
    FIELD(CH1_ADAPT_LCK_CFG0, GAIN0, 16, 3)
    FIELD(CH1_ADAPT_LCK_CFG0, GAIN1, 12, 4)
    FIELD(CH1_ADAPT_LCK_CFG0, CDRLCK0_INITSEL, 0, 12)
REG32(CH1_ADAPT_LCK_CFG1, 0x353c)
    FIELD(CH1_ADAPT_LCK_CFG1, TESTC, 29, 3)
    FIELD(CH1_ADAPT_LCK_CFG1, ENLOSS, 28, 1)
    FIELD(CH1_ADAPT_LCK_CFG1, ENLCK1, 27, 1)
    FIELD(CH1_ADAPT_LCK_CFG1, ENLCK0, 26, 1)
    FIELD(CH1_ADAPT_LCK_CFG1, LCK_CFG10, 21, 5)
    FIELD(CH1_ADAPT_LCK_CFG1, FORCELOW, 20, 1)
    FIELD(CH1_ADAPT_LCK_CFG1, SELCON, 17, 3)
    FIELD(CH1_ADAPT_LCK_CFG1, DETECTEN, 16, 1)
    FIELD(CH1_ADAPT_LCK_CFG1, LCKCTRVAL, 12, 4)
    FIELD(CH1_ADAPT_LCK_CFG1, LOSSSEL, 0, 12)
REG32(CH1_ADAPT_LCK_CFG2, 0x3540)
    FIELD(CH1_ADAPT_LCK_CFG2, LCK_CFG20, 25, 7)
    FIELD(CH1_ADAPT_LCK_CFG2, FIX_PPM, 24, 1)
    FIELD(CH1_ADAPT_LCK_CFG2, TESTCON, 20, 4)
    FIELD(CH1_ADAPT_LCK_CFG2, UD_CYCLEU, 16, 4)
    FIELD(CH1_ADAPT_LCK_CFG2, UD_CYCLEL, 0, 16)
REG32(CH1_ADAPT_LCK_CFG3, 0x3544)
REG32(CH1_ADAPT_LOP_CFG, 0x3548)
    FIELD(CH1_ADAPT_LOP_CFG, ENDNOD, 29, 3)
    FIELD(CH1_ADAPT_LOP_CFG, PREVSEL, 25, 4)
    FIELD(CH1_ADAPT_LOP_CFG, DFEOSWTX, 22, 3)
    FIELD(CH1_ADAPT_LOP_CFG, DFEOSWTY, 19, 3)
    FIELD(CH1_ADAPT_LOP_CFG, SWCLKP1, 18, 1)
    FIELD(CH1_ADAPT_LOP_CFG, SWCLKP0, 17, 1)
    FIELD(CH1_ADAPT_LOP_CFG, SELWIDTH, 16, 1)
    FIELD(CH1_ADAPT_LOP_CFG, DRP_WIDTH, 13, 3)
    FIELD(CH1_ADAPT_LOP_CFG, NEXTDC, 12, 1)
    FIELD(CH1_ADAPT_LOP_CFG, INVTBIT, 11, 1)
    FIELD(CH1_ADAPT_LOP_CFG, SWCLKSEL, 9, 2)
    FIELD(CH1_ADAPT_LOP_CFG, LOP_CFG0, 7, 2)
    FIELD(CH1_ADAPT_LOP_CFG, BLKOUTC, 5, 2)
    FIELD(CH1_ADAPT_LOP_CFG, DUL_TESTCON, 0, 5)
REG32(CH1_ADAPT_OS_CFG, 0x354c)
    FIELD(CH1_ADAPT_OS_CFG, OS_INITDAC, 25, 7)
    FIELD(CH1_ADAPT_OS_CFG, OS_CFG1, 11, 14)
    FIELD(CH1_ADAPT_OS_CFG, OS_MSHIFT, 7, 4)
    FIELD(CH1_ADAPT_OS_CFG, OS_WAITSEL, 5, 2)
    FIELD(CH1_ADAPT_OS_CFG, OS_CFG0, 0, 5)
REG32(CH1_RX_CRC_CFG0, 0x3550)
    FIELD(CH1_RX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH1_RX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH1_RX_CRC_CFG0, CORRECTION_EN, 7, 1)
    FIELD(CH1_RX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH1_RX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH1_RX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH1_RX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH1_RX_CRC_CFG0, INPUT_BYTE_ORDER, 1, 1)
    FIELD(CH1_RX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH1_RX_CRC_CFG1, 0x3554)
REG32(CH1_RX_CRC_CFG2, 0x3558)
REG32(CH1_RX_CRC_CFG3, 0x355c)
REG32(CH1_TX_CRC_CFG0, 0x3560)
    FIELD(CH1_TX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH1_TX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH1_TX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH1_TX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH1_TX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH1_TX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH1_TX_CRC_CFG0, OUTPUT_BYTE_ORDER, 1, 1)
    FIELD(CH1_TX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH1_TX_CRC_CFG1, 0x3564)
REG32(CH1_TX_CRC_CFG2, 0x3568)
REG32(CH1_TX_CRC_CFG3, 0x356c)
REG32(CH1_DA_CFG, 0x3570)
    FIELD(CH1_DA_CFG, TX_DA_AMP_CTRL_FORCE, 31, 1)
    FIELD(CH1_DA_CFG, TX_DA_AMP_CTRL, 27, 4)
    FIELD(CH1_DA_CFG, TX_DA_SPARE, 20, 7)
    FIELD(CH1_DA_CFG, TX_DA_REFCLK_SEL, 19, 1)
    FIELD(CH1_DA_CFG, TX_DA_RANGE, 18, 1)
    FIELD(CH1_DA_CFG, TX_DA_ENOUT, 17, 1)
    FIELD(CH1_DA_CFG, TX_DA_PWRDNB, 16, 1)
    FIELD(CH1_DA_CFG, RX_DA_AMP_CTRL_FORCE, 15, 1)
    FIELD(CH1_DA_CFG, RX_DA_AMP_CTRL, 11, 4)
    FIELD(CH1_DA_CFG, RX_DA_SPARE, 4, 7)
    FIELD(CH1_DA_CFG, RX_DA_REFCLK_SEL, 3, 1)
    FIELD(CH1_DA_CFG, RX_DA_RANGE, 2, 1)
    FIELD(CH1_DA_CFG, RX_DA_ENOUT, 1, 1)
    FIELD(CH1_DA_CFG, RX_DA_PWRDNB, 0, 1)
REG32(CH1_RX_CTLE_CFG0, 0x3574)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE1_PWRDN, 31, 1)
    FIELD(CH1_RX_CTLE_CFG0, RX_AGC1_CM_REF, 28, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE1_CM_REF, 25, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_AGC2_OCAP_CTRL, 22, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC2_OCAP, 21, 1)
    FIELD(CH1_RX_CTLE_CFG0, RX_AGC1_OCAP_CTRL, 18, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE_TUNE_OS, 16, 2)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC1_OCAP, 15, 1)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE_CL_CAP_CTRL, 12, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE_CS_CAPCTRL, 9, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE_BIAS_CTRL, 6, 3)
    FIELD(CH1_RX_CTLE_CFG0, RX_AGC2_LOW_PWR, 4, 2)
    FIELD(CH1_RX_CTLE_CFG0, RX_AGC1_LOW_PWR, 2, 2)
    FIELD(CH1_RX_CTLE_CFG0, RX_CTLE1_LOW_PWR, 0, 2)
REG32(CH1_RX_CTLE_CFG1, 0x3578)
    FIELD(CH1_RX_CTLE_CFG1, SWCLK_ELVL_OPT, 26, 1)
    FIELD(CH1_RX_CTLE_CFG1, BRCDR_VP_OPT, 25, 1)
    FIELD(CH1_RX_CTLE_CFG1, RCAL_OS_PAD, 19, 6)
    FIELD(CH1_RX_CTLE_CFG1, RX_AGC2_CURR_GAIN, 16, 3)
    FIELD(CH1_RX_CTLE_CFG1, RX_AGC1_CURR_GAIN, 13, 3)
    FIELD(CH1_RX_CTLE_CFG1, RX_CTLE1_CURR_GAIN, 10, 3)
    FIELD(CH1_RX_CTLE_CFG1, RX_AGC2_PWRDN, 9, 1)
    FIELD(CH1_RX_CTLE_CFG1, RX_AGC1_PWRDN, 8, 1)
    FIELD(CH1_RX_CTLE_CFG1, RX_CTLE_OS_PWRDN, 7, 1)
    FIELD(CH1_RX_CTLE_CFG1, RX_CTLE_SAP_SEL, 3, 4)
    FIELD(CH1_RX_CTLE_CFG1, RX_AGC2_CM_REF, 0, 3)
REG32(CH1_RX_DACI2V_CFG0, 0x357c)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_PD_BIAS_OS, 28, 1)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_PD_BIAS_DFE, 27, 1)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_VP_RANGE, 25, 2)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_VS_CODE, 18, 7)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_VS_NEG, 17, 1)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_VS_UT_SIGN, 16, 1)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_SEL_I2V_VCM, 13, 3)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_CFOK_RANGE, 11, 2)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_CFOK_EN, 10, 1)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_FILTER_EN, 9, 1)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_VS_RANGE, 7, 2)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_BIAS_DFE, 5, 2)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_BIAS_I2V, 3, 2)
    FIELD(CH1_RX_DACI2V_CFG0, DAC_BIAS_OS, 1, 2)
    FIELD(CH1_RX_DACI2V_CFG0, SUMMER_VCM_TESTMODE, 0, 1)
REG32(CH1_RX_DFE_CFG0, 0x3580)
    FIELD(CH1_RX_DFE_CFG0, RX_DFE_YEN, 31, 1)
    FIELD(CH1_RX_DFE_CFG0, RX_VREG_PDB, 30, 1)
    FIELD(CH1_RX_DFE_CFG0, RX_VREG_VREFSEL, 28, 2)
    FIELD(CH1_RX_DFE_CFG0, RX_DES_CFG_BITS, 18, 10)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_EN_VCM_EVEN, 17, 1)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_LOW_POWER, 16, 1)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_VCM_TUNE, 12, 4)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_VCM_TUNE_OVWR, 11, 1)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_VREF_TUNE, 8, 3)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_IREF_TUNE, 4, 4)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_DEG_CTRL, 1, 3)
    FIELD(CH1_RX_DFE_CFG0, RX_SUM_DEG_AVTT_OVWR, 0, 1)
REG32(CH1_RX_MISC_CFG0, 0x3584)
    FIELD(CH1_RX_MISC_CFG0, RX_VREG_CTRL, 28, 3)
    FIELD(CH1_RX_MISC_CFG0, RCAL_OS_CTLE, 22, 6)
    FIELD(CH1_RX_MISC_CFG0, RCAL_OS_AGC1, 16, 6)
    FIELD(CH1_RX_MISC_CFG0, SLICER_SARC_DIS, 15, 1)
    FIELD(CH1_RX_MISC_CFG0, RCAL_OS_AGC2, 9, 6)
    FIELD(CH1_RX_MISC_CFG0, RCAL_OS_SUM, 3, 6)
    FIELD(CH1_RX_MISC_CFG0, RX_LPM_EN, 2, 1)
    FIELD(CH1_RX_MISC_CFG0, BAUDRATE_MODE, 1, 1)
    FIELD(CH1_RX_MISC_CFG0, RX_XMODE_SEL, 0, 1)
REG32(CH1_CHL_RSV_CFG1, 0x3588)
REG32(CH1_RX_PAD_CFG0, 0x358c)
    FIELD(CH1_RX_PAD_CFG0, LS_CTRL, 17, 15)
    FIELD(CH1_RX_PAD_CFG0, ACCAP_CMRES_EN, 16, 1)
    FIELD(CH1_RX_PAD_CFG0, ACCAP_CFG, 13, 3)
    FIELD(CH1_RX_PAD_CFG0, LSHIFT_EN, 12, 1)
    FIELD(CH1_RX_PAD_CFG0, ACCAP_EN, 11, 1)
    FIELD(CH1_RX_PAD_CFG0, RX_PAD_CFG0_SPARE, 0, 11)
REG32(CH1_RX_PAD_CFG1, 0x3590)
    FIELD(CH1_RX_PAD_CFG1, RX_PAD_CFG1_SPARE, 30, 2)
    FIELD(CH1_RX_PAD_CFG1, RX_PKDET_EN, 29, 1)
    FIELD(CH1_RX_PAD_CFG1, RX_PKDET_CTRL, 25, 4)
    FIELD(CH1_RX_PAD_CFG1, OOB_VDIFF_INV, 24, 1)
    FIELD(CH1_RX_PAD_CFG1, OOB_SIG_VDIFF_SEL, 21, 3)
    FIELD(CH1_RX_PAD_CFG1, OOB_OVERRIDE, 19, 2)
    FIELD(CH1_RX_PAD_CFG1, OOB_PWRDN_B, 18, 1)
    FIELD(CH1_RX_PAD_CFG1, ACJTAG_EN, 17, 1)
    FIELD(CH1_RX_PAD_CFG1, QPI_EN, 16, 1)
    FIELD(CH1_RX_PAD_CFG1, MNTR_ACJTAG_EN, 15, 1)
    FIELD(CH1_RX_PAD_CFG1, ACJTAG_VD_SEL0, 14, 1)
    FIELD(CH1_RX_PAD_CFG1, ACJTAG_VC_SEL0, 13, 1)
    FIELD(CH1_RX_PAD_CFG1, MNTR_ACJTAG_RESETB, 12, 1)
    FIELD(CH1_RX_PAD_CFG1, MNTR_ACJTAG_ACMODE, 11, 1)
    FIELD(CH1_RX_PAD_CFG1, PROG_OPAMPPD_EN, 10, 1)
    FIELD(CH1_RX_PAD_CFG1, CM_BUFF_CFG, 6, 4)
    FIELD(CH1_RX_PAD_CFG1, RTERM_VCOM_MODE, 4, 2)
    FIELD(CH1_RX_PAD_CFG1, RTERM_VCOM_LVL, 0, 4)
REG32(CH1_RX_PCS_CFG0, 0x3594)
    FIELD(CH1_RX_PCS_CFG0, RX_ALIGN_MCOMMA_DET, 31, 1)
    FIELD(CH1_RX_PCS_CFG0, RX_ALIGN_PCOMMA_DET, 30, 1)
    FIELD(CH1_RX_PCS_CFG0, RX_ALIGN_MCOMMA_VAL, 20, 10)
    FIELD(CH1_RX_PCS_CFG0, RX_ALIGN_PCOMMA_VAL, 10, 10)
    FIELD(CH1_RX_PCS_CFG0, RX_INT_DATA_WIDTH, 7, 2)
    FIELD(CH1_RX_PCS_CFG0, RX_DATA_WIDTH, 3, 4)
    FIELD(CH1_RX_PCS_CFG0, RX_MCOMMA_ALIGNEN, 2, 1)
    FIELD(CH1_RX_PCS_CFG0, RX_PCOMMA_ALIGNEN, 1, 1)
    FIELD(CH1_RX_PCS_CFG0, RX_COMMADETEN, 0, 1)
REG32(CH1_RX_PCS_CFG1, 0x3598)
    FIELD(CH1_RX_PCS_CFG1, RX_FABRIC_DATA_SEL, 29, 3)
    FIELD(CH1_RX_PCS_CFG1, RX_FIFO_DATA_SEL, 26, 3)
    FIELD(CH1_RX_PCS_CFG1, RX_SIG_VALID_DLY, 21, 5)
    FIELD(CH1_RX_PCS_CFG1, RX_SLIDE_MODE, 19, 2)
    FIELD(CH1_RX_PCS_CFG1, RX_SHOW_REALIGN_COMMA, 18, 1)
    FIELD(CH1_RX_PCS_CFG1, RX_SLIDE_AUTO_WAIT, 14, 4)
    FIELD(CH1_RX_PCS_CFG1, RX_ALIGN_COMMA_WORD, 11, 3)
    FIELD(CH1_RX_PCS_CFG1, RX_ALIGN_COMMA_DOUBLE, 10, 1)
    FIELD(CH1_RX_PCS_CFG1, RX_ALIGN_COMMA_ENABLE, 0, 10)
REG32(CH1_RX_PCS_CFG2, 0x359c)
    FIELD(CH1_RX_PCS_CFG2, PCIE_USB_ERR_REP_DIS, 31, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_PHASE_BUFFER_USE, 30, 1)
    FIELD(CH1_RX_PCS_CFG2, RXBUF_RD_INIT_ADDR, 27, 3)
    FIELD(CH1_RX_PCS_CFG2, RXBUF_RXUSRCLK_REG_BYPASS, 26, 1)
    FIELD(CH1_RX_PCS_CFG2, RXBUF_ADDR_CFG, 25, 1)
    FIELD(CH1_RX_PCS_CFG2, START_SKP_SEL, 24, 1)
    FIELD(CH1_RX_PCS_CFG2, SIGVALID_EN_FOR_RXVALID, 23, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_EIEOS_PATTERN_SEL, 21, 2)
    FIELD(CH1_RX_PCS_CFG2, RX_BLKSYNC_MCP, 20, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_BLKSYNC_FTS, 19, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_CBCC_DATA_SEL, 18, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_DEC_VALID_COMMA, 17, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_DEC_MCOMMA_DET, 16, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_DEC_PCOMMA_DET, 15, 1)
    FIELD(CH1_RX_PCS_CFG2, RX_8B10B_EN, 14, 1)
    FIELD(CH1_RX_PCS_CFG2, EIOS_ERR_MASK_DIS, 13, 1)
    FIELD(CH1_RX_PCS_CFG2, SAMPLE_PERIOD, 10, 3)
    FIELD(CH1_RX_PCS_CFG2, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH1_RX_PCS_CFG2, USE_GB, 5, 1)
    FIELD(CH1_RX_PCS_CFG2, MODE, 0, 5)
REG32(CH1_RX_PCS_CFG3, 0x35a0)
    FIELD(CH1_RX_PCS_CFG3, RX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH1_RX_PCS_CFG3, RX_FIFO_STATUS_SEL, 30, 1)
    FIELD(CH1_RX_PCS_CFG3, DATA_RATE, 29, 1)
    FIELD(CH1_RX_PCS_CFG3, DATAPATH_CTRL, 26, 3)
    FIELD(CH1_RX_PCS_CFG3, CLAUSE_CTRL, 25, 1)
    FIELD(CH1_RX_PCS_CFG3, TEST_PATT_EN, 24, 1)
    FIELD(CH1_RX_PCS_CFG3, TESTDATA_PATT_SEL, 23, 1)
    FIELD(CH1_RX_PCS_CFG3, RXVALID_FORCE_RXVAL_COMDET, 20, 1)
    FIELD(CH1_RX_PCS_CFG3, RXVALID_EIOS_RESET_EN, 19, 1)
    FIELD(CH1_RX_PCS_CFG3, RXPHCLK_CYCLE_CNT_EN, 17, 1)
    FIELD(CH1_RX_PCS_CFG3, RXPRBS_LEAKYBUCKET_EN, 16, 1)
    FIELD(CH1_RX_PCS_CFG3, RXPRBS_LINK2RESEED_CNT, 8, 8)
    FIELD(CH1_RX_PCS_CFG3, RXPRBS_LINKACQ_CNT, 0, 8)
REG32(CH1_RX_PCS_CFG4, 0x35a4)
    FIELD(CH1_RX_PCS_CFG4, RXVALID_GEN_EN, 31, 1)
    FIELD(CH1_RX_PCS_CFG4, RXVALID_FORCE_SIGVALID, 30, 1)
    FIELD(CH1_RX_PCS_CFG4, RXVALID_K_NUM, 20, 10)
    FIELD(CH1_RX_PCS_CFG4, RXVALID_GOOD_DATA_NUM, 10, 10)
    FIELD(CH1_RX_PCS_CFG4, RXVALID_ERR_DATA_NUM, 0, 10)
REG32(CH1_CHCLK_MISC_CFG, 0x35a8)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_MONCLKCYCLE, 28, 3)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_PWRDNB, 27, 1)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_UNLOCKCTRL, 25, 2)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OW, 17, 8)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_FINE_SWEEP, 15, 2)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_ILOLOCKCOARSE, 13, 2)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_ILOLOCKFACTOR, 11, 2)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_PLLLOCKDETEN, 10, 1)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_CRS_ACCURACY, 8, 2)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_OVRD_MODE, 6, 2)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OWEN, 5, 1)
    FIELD(CH1_CHCLK_MISC_CFG, CHCLK_FBDIV_VAL, 0, 5)
REG32(CH1_CHCLK_ILO_CFG, 0x35ac)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OW, 28, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OWEN, 27, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OW, 26, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OWEN, 25, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OW, 24, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OWEN, 23, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OW, 21, 2)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OWEN, 20, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_ILO_MODE_SPD, 19, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_CLKSRCMUX_SEL, 18, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_FTL_TUNE_OWEN, 16, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_VREG_CTRL, 12, 3)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_VCTRL_OW, 6, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_BIAS, 5, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_VCTRL_EXT, 4, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_VBUF, 2, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_FTL, 1, 1)
    FIELD(CH1_CHCLK_ILO_CFG, CHCLK_PDB_VREG, 0, 1)
REG32(CH1_CHCLK_RXPI_CFG, 0x35b0)
    FIELD(CH1_CHCLK_RXPI_CFG, PROGDIV_RX_DIV_PDB, 22, 1)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_STEP_BYP_EN, 21, 1)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_STEP_TWO_EN, 20, 1)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_SEL_VREG_SENSE, 19, 1)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_VREG_CTRL, 16, 3)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_BAND_SEL, 4, 2)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_S_PREBUF_EN, 3, 1)
    FIELD(CH1_CHCLK_RXPI_CFG, RXPI_PREBUF_EN, 2, 1)
REG32(CH1_CHCLK_RXCAL_CFG, 0x35b4)
    FIELD(CH1_CHCLK_RXCAL_CFG, DMON_SEL, 28, 4)
    FIELD(CH1_CHCLK_RXCAL_CFG, AUTO_MODE, 27, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, TWAIT_SEL, 25, 2)
    FIELD(CH1_CHCLK_RXCAL_CFG, CLKDIV_SEL, 22, 3)
    FIELD(CH1_CHCLK_RXCAL_CFG, TCYC_PER_CAL, 20, 2)
    FIELD(CH1_CHCLK_RXCAL_CFG, TEVAL_SEL, 18, 2)
    FIELD(CH1_CHCLK_RXCAL_CFG, TOS_SEL, 16, 2)
    FIELD(CH1_CHCLK_RXCAL_CFG, HYST_MODE, 14, 2)
    FIELD(CH1_CHCLK_RXCAL_CFG, DMON_EN, 13, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, RX_CAL_PD, 12, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, OVERRIDE_CODE_IDX, 9, 3)
    FIELD(CH1_CHCLK_RXCAL_CFG, FLIP_DIR_ANY, 8, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_RXPAD_OS, 7, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_AGC2_CM, 6, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_AGC1_CM, 5, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_CTLE_CM, 4, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_RXDCD_S, 3, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_RXDCD_X, 2, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG, SKIP_RXDCD_D, 1, 1)
REG32(CH1_CHCLK_RXCAL_CFG1, 0x35b8)
    FIELD(CH1_CHCLK_RXCAL_CFG1, OVERRIDE_EN, 7, 1)
    FIELD(CH1_CHCLK_RXCAL_CFG1, OVERRIDE_CODE, 0, 7)
REG32(CH1_CHCLK_TXPI_CFG0, 0x35bc)
    FIELD(CH1_CHCLK_TXPI_CFG0, RSVD, 22, 10)
    FIELD(CH1_CHCLK_TXPI_CFG0, SARC_EN, 21, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_STEP_BYP_EN, 20, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TX_PROGCLK_SEL, 18, 2)
    FIELD(CH1_CHCLK_TXPI_CFG0, PROGDIV_TX_DIV_PDB, 17, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_STEP_TWO_EN, 16, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_BAND_SEL, 4, 2)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_PREBUF_EN, 3, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_BYPASS, 2, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TXPI_BYPASSMUX_PDB, 1, 1)
    FIELD(CH1_CHCLK_TXPI_CFG0, TX_PLLCLK_SEL, 0, 1)
REG32(CH1_CHCLK_TXCAL_CFG, 0x35c0)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_EXHOLD, 26, 1)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_OVWREN, 25, 1)
    FIELD(CH1_CHCLK_TXCAL_CFG, TXCLK_TXCAL_FORCEREADY, 24, 1)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TIGHT, 23, 1)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_INITDAC, 16, 7)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACWIN, 14, 2)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACCHECK, 12, 2)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_THRESHSEL, 10, 2)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_MULSEL, 7, 3)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_FLIPDIR, 6, 1)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_CALEN, 5, 1)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTSEL, 1, 4)
    FIELD(CH1_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTEN, 0, 1)
REG32(CH1_CHCLK_RXCAL_CFG2, 0x35c4)
REG32(CH1_CHCLK_RSV_CFG, 0x35c8)
REG32(CH1_PIPE_TX_EQ_CFG0, 0x35cc)
    FIELD(CH1_PIPE_TX_EQ_CFG0, TX_MAINCURSOR_SEL, 30, 1)
    FIELD(CH1_PIPE_TX_EQ_CFG0, TX_DRIVE_MODE, 28, 2)
    FIELD(CH1_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_3, 21, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_2, 14, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_1, 7, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_0, 0, 7)
REG32(CH1_PIPE_TX_EQ_CFG1, 0x35d0)
    FIELD(CH1_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_2, 21, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_1, 14, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_0, 7, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG1, TX_MARGIN_FULL_4, 0, 7)
REG32(CH1_PIPE_TX_EQ_CFG2, 0x35d4)
    FIELD(CH1_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_4, 7, 7)
    FIELD(CH1_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_3, 0, 7)
REG32(CH1_PIPE_TX_EQ_CFG3, 0x35d8)
    FIELD(CH1_PIPE_TX_EQ_CFG3, TX_DEEMPH_3, 15, 5)
    FIELD(CH1_PIPE_TX_EQ_CFG3, TX_DEEMPH_2, 10, 5)
    FIELD(CH1_PIPE_TX_EQ_CFG3, TX_DEEMPH_1, 5, 5)
    FIELD(CH1_PIPE_TX_EQ_CFG3, TX_DEEMPH_0, 0, 5)
REG32(CH1_TX_PCS_CFG0, 0x35dc)
    FIELD(CH1_TX_PCS_CFG0, TX_PMA_DATA_SEL, 29, 3)
    FIELD(CH1_TX_PCS_CFG0, TXPMA_WIDTH_OVRD, 26, 3)
    FIELD(CH1_TX_PCS_CFG0, TX_INT_DATA_WIDTH, 24, 2)
    FIELD(CH1_TX_PCS_CFG0, TX_DATA_WIDTH, 20, 4)
    FIELD(CH1_TX_PCS_CFG0, TX_IDLE_DATA_ZERO, 19, 1)
    FIELD(CH1_TX_PCS_CFG0, TXPMA_WIDTH_OVRD_EN, 18, 1)
    FIELD(CH1_TX_PCS_CFG0, TX_8B10B_EN, 17, 1)
    FIELD(CH1_TX_PCS_CFG0, TX_8B10B_BYPASS, 13, 4)
    FIELD(CH1_TX_PCS_CFG0, SAMPLE_PERIOD, 10, 3)
    FIELD(CH1_TX_PCS_CFG0, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH1_TX_PCS_CFG0, USE_GB, 5, 1)
    FIELD(CH1_TX_PCS_CFG0, MODE, 0, 5)
REG32(CH1_TX_PCS_CFG1, 0x35e0)
    FIELD(CH1_TX_PCS_CFG1, TX_PRBS_FORCE_MODE, 31, 1)
    FIELD(CH1_TX_PCS_CFG1, RXPRBS_ERR_LOOPBACK, 30, 1)
    FIELD(CH1_TX_PCS_CFG1, TX_PRBS_USERPATTERN2, 20, 10)
    FIELD(CH1_TX_PCS_CFG1, TX_PRBS_USERPATTERN1, 10, 10)
    FIELD(CH1_TX_PCS_CFG1, TX_PRBS_USERPATTERN0, 0, 10)
REG32(CH1_TX_PCS_CFG2, 0x35e4)
    FIELD(CH1_TX_PCS_CFG2, TX_FIFO_STATUS_SEL, 31, 1)
    FIELD(CH1_TX_PCS_CFG2, TX_PRBS_USERPATTERN5, 20, 10)
    FIELD(CH1_TX_PCS_CFG2, TX_PRBS_USERPATTERN4, 10, 10)
    FIELD(CH1_TX_PCS_CFG2, TX_PRBS_USERPATTERN3, 0, 10)
REG32(CH1_TX_PCS_CFG3, 0x35e8)
    FIELD(CH1_TX_PCS_CFG3, TX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH1_TX_PCS_CFG3, TXBUF_TXPCSCLK_REG_BYPASS, 30, 1)
    FIELD(CH1_TX_PCS_CFG3, USB_LFPS_TPERIOD_ACCURATE, 29, 1)
    FIELD(CH1_TX_PCS_CFG3, USB_LFPS_TPERIOD, 25, 4)
    FIELD(CH1_TX_PCS_CFG3, TXBUF_WR_INIT_ADDR, 22, 3)
    FIELD(CH1_TX_PCS_CFG3, TXBUF_ADDR_CFG, 21, 1)
    FIELD(CH1_TX_PCS_CFG3, TX_PHASE_BUFFER_USE, 20, 1)
    FIELD(CH1_TX_PCS_CFG3, TX_PRBS_USERPATTERN7, 10, 10)
    FIELD(CH1_TX_PCS_CFG3, TX_PRBS_USERPATTERN6, 0, 10)
REG32(CH1_EYESCAN_CFG0, 0x35ec)
    FIELD(CH1_EYESCAN_CFG0, ES_SWAP_EN, 25, 1)
    FIELD(CH1_EYESCAN_CFG0, ES_ERRDET_EN, 24, 1)
    FIELD(CH1_EYESCAN_CFG0, ES_EYE_SCAN_EN, 23, 1)
    FIELD(CH1_EYESCAN_CFG0, ES_CONTROL, 17, 6)
    FIELD(CH1_EYESCAN_CFG0, ES_PRESCALE, 12, 5)
    FIELD(CH1_EYESCAN_CFG0, ES_HORZ_OFFSET, 0, 12)
REG32(CH1_EYESCAN_CFG1, 0x35f0)
REG32(CH1_EYESCAN_CFG2, 0x35f4)
REG32(CH1_EYESCAN_CFG3, 0x35f8)
REG32(CH1_EYESCAN_CFG4, 0x35fc)
REG32(CH1_EYESCAN_CFG5, 0x3600)
REG32(CH1_EYESCAN_CFG6, 0x3604)
REG32(CH1_EYESCAN_CFG7, 0x3608)
REG32(CH1_EYESCAN_CFG8, 0x360c)
REG32(CH1_EYESCAN_CFG9, 0x3610)
REG32(CH1_EYESCAN_CFG10, 0x3614)
REG32(CH1_EYESCAN_CFG11, 0x3618)
REG32(CH1_EYESCAN_CFG12, 0x361c)
REG32(CH1_EYESCAN_CFG13, 0x3620)
REG32(CH1_EYESCAN_CFG14, 0x3624)
REG32(CH1_EYESCAN_CFG15, 0x3628)
REG32(CH1_EYESCAN_CFG16, 0x362c)
    FIELD(CH1_EYESCAN_CFG16, RXPMA_WIDTH_OVRD_EN, 31, 1)
    FIELD(CH1_EYESCAN_CFG16, RXPMA_ADAP_WIDTH_OVRD, 27, 4)
    FIELD(CH1_EYESCAN_CFG16, RXPMA_CDR_WIDTH_OVRD, 23, 4)
    FIELD(CH1_EYESCAN_CFG16, RXPMA_DES_WIDTH_OVRD, 19, 4)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SAMPLE, 15, 1)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL2, 14, 1)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL, 13, 1)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_VS_UT_SIGN, 12, 1)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_VS_RANGE, 10, 2)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_VS_NEG_DIR, 9, 1)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_VS_CODE, 2, 7)
    FIELD(CH1_EYESCAN_CFG16, EYESCAN_VP_RANGE, 0, 2)
REG32(CH1_RX_ELASTIC_BUF_CFG0, 0x3630)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_THRESH_OVRD, 31, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_REPEAT_WAIT, 26, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_UDFL_THRESH, 20, 6)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_OVFL_THRESH, 14, 6)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MAX_LAT, 8, 6)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MIN_LAT, 2, 6)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_USE, 1, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG0, ELASTICBUF_8B10B_EN, 0, 1)
REG32(CH1_TX_10G_CFG0, 0x3634)
REG32(CH1_TX_10G_CFG1, 0x3638)
    FIELD(CH1_TX_10G_CFG1, DATAPATH_CTRL, 29, 2)
    FIELD(CH1_TX_10G_CFG1, TEST_PATT_EN, 28, 1)
    FIELD(CH1_TX_10G_CFG1, TEST_PATT_SEL, 27, 1)
    FIELD(CH1_TX_10G_CFG1, TESTDATA_PATT_SEL, 26, 1)
    FIELD(CH1_TX_10G_CFG1, TEST_PATT_SEEDA, 0, 26)
REG32(CH1_TX_10G_CFG2, 0x363c)
REG32(CH1_TX_10G_CFG3, 0x3640)
    FIELD(CH1_TX_10G_CFG3, TEST_PATT_SEEDB, 0, 26)
REG32(CH1_RX_PHALIGN_CFG0, 0x3644)
    FIELD(CH1_RX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH1_RX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH1_RX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH1_RX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH1_RX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH1_RX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH1_RX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH1_RX_PHALIGN_CFG0, RXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH1_RX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH1_RX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH1_RX_PHALIGN_CFG0, ALIGN_DMON_SEL, 5, 5)
    FIELD(CH1_RX_PHALIGN_CFG0, DA_WAIT_CYCLES, 0, 5)
REG32(CH1_RX_PHALIGN_CFG1, 0x3648)
    FIELD(CH1_RX_PHALIGN_CFG1, SETINIT_PH_CNT, 27, 5)
    FIELD(CH1_RX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH1_RX_PHALIGN_CFG1, NUM_SAMPLES, 15, 5)
    FIELD(CH1_RX_PHALIGN_CFG1, SAMPLE_WAIT, 13, 2)
    FIELD(CH1_RX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 6, 7)
    FIELD(CH1_RX_PHALIGN_CFG1, MIN_THRESHOLD_OVRD, 5, 1)
    FIELD(CH1_RX_PHALIGN_CFG1, MAX_THRESHOLD_OVRD, 4, 1)
    FIELD(CH1_RX_PHALIGN_CFG1, CHAIN_MODE, 2, 2)
    FIELD(CH1_RX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 1, 1)
    FIELD(CH1_RX_PHALIGN_CFG1, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH1_RX_PHALIGN_CFG2, 0x364c)
    FIELD(CH1_RX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH1_RX_PHALIGN_CFG2, SLIP_EN_WID_PRE, 21, 4)
    FIELD(CH1_RX_PHALIGN_CFG2, SLIP_EN_WID_POST, 17, 4)
    FIELD(CH1_RX_PHALIGN_CFG2, SLIP_PULSE_WID_HI, 13, 4)
    FIELD(CH1_RX_PHALIGN_CFG2, SLIP_PULSE_WID_LO, 9, 4)
    FIELD(CH1_RX_PHALIGN_CFG2, SLIP_PULSE_SETTLE, 5, 4)
REG32(CH1_RX_PHALIGN_CFG3, 0x3650)
    FIELD(CH1_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_CNT, 27, 5)
    FIELD(CH1_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH1_RX_PHALIGN_CFG3, MLDLY_NUM_SAMPLES, 15, 5)
    FIELD(CH1_RX_PHALIGN_CFG3, MLDLY_MIN_THRESHOLD_OVRD, 14, 1)
    FIELD(CH1_RX_PHALIGN_CFG3, MLDLY_MAX_THRESHOLD_OVRD, 13, 1)
    FIELD(CH1_RX_PHALIGN_CFG3, MLDLY_SAMPLE_WAIT, 11, 2)
    FIELD(CH1_RX_PHALIGN_CFG3, DAPICODE_OVRD, 3, 8)
    FIELD(CH1_RX_PHALIGN_CFG3, DMON_CLK_SEL, 0, 2)
REG32(CH1_RX_PHALIGN_CFG4, 0x3654)
    FIELD(CH1_RX_PHALIGN_CFG4, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH1_RX_PHALIGN_CFG4, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH1_RX_PHALIGN_CFG4, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH1_RX_PHALIGN_CFG4, FINE_ALIGN_BYPASS, 12, 1)
    FIELD(CH1_RX_PHALIGN_CFG4, CLKSLIP_PAR_SAMPLES, 10, 2)
    FIELD(CH1_RX_PHALIGN_CFG4, CLKSLIP_NUM_SAMPLES, 5, 5)
    FIELD(CH1_RX_PHALIGN_CFG4, CLKSLIP_SAMPLES_WAIT, 0, 5)
REG32(CH1_RX_PHALIGN_CFG5, 0x3658)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_UP_DOWN, 28, 2)
    FIELD(CH1_RX_PHALIGN_CFG5, CMN_FAB_CLK_PHALIGN_MODE, 26, 2)
    FIELD(CH1_RX_PHALIGN_CFG5, TX_BUFBYPASS_ML_NEGEDGE_MODE, 25, 1)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_BUFBYPASS_ML_NEGEDGE_MODE, 24, 1)
    FIELD(CH1_RX_PHALIGN_CFG5, TXPICODE_DDR_EN, 23, 1)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MODE, 22, 1)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MAXCOUNT, 17, 5)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_WAITCYCLE, 14, 3)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_CDR_SLIP_DIR, 13, 1)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_CDR_SLIP_SAMPLE_COUNT, 11, 2)
    FIELD(CH1_RX_PHALIGN_CFG5, TX_BEACON_DLY_OPT_128B130B, 9, 2)
    FIELD(CH1_RX_PHALIGN_CFG5, TX_CLK_DLY_OPT_128B130B, 7, 2)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_BEACON_DLY_OPT_128B130B, 5, 2)
    FIELD(CH1_RX_PHALIGN_CFG5, RX_CLK_DLY_OPT_128B130B, 3, 2)
REG32(CH1_TX_PHALIGN_CFG0, 0x365c)
    FIELD(CH1_TX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH1_TX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH1_TX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, TXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH1_TX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH1_TX_PHALIGN_CFG0, MIN_THRESHOLD_OVRD, 7, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, MAX_THRESHOLD_OVRD, 6, 1)
    FIELD(CH1_TX_PHALIGN_CFG0, ALIGN_DMON_SEL, 1, 5)
    FIELD(CH1_TX_PHALIGN_CFG0, TX_DYNAMIC_SWITCH_EN, 0, 1)
REG32(CH1_TX_PHALIGN_CFG1, 0x3660)
    FIELD(CH1_TX_PHALIGN_CFG1, PHDA_WAIT_CYCLES, 27, 5)
    FIELD(CH1_TX_PHALIGN_CFG1, SETINIT_PH_CNT, 22, 5)
    FIELD(CH1_TX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 17, 5)
    FIELD(CH1_TX_PHALIGN_CFG1, NUM_SAMPLES, 12, 5)
    FIELD(CH1_TX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 5, 7)
    FIELD(CH1_TX_PHALIGN_CFG1, SAMPLE_WAIT, 3, 2)
    FIELD(CH1_TX_PHALIGN_CFG1, CHAIN_MODE, 1, 2)
    FIELD(CH1_TX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 0, 1)
REG32(CH1_TX_PHALIGN_CFG2, 0x3664)
    FIELD(CH1_TX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH1_TX_PHALIGN_CFG2, TXPI_PHDA_WAIT_CYCLES, 20, 5)
    FIELD(CH1_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_CNT, 15, 5)
    FIELD(CH1_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_WAIT_CYCLE, 10, 5)
    FIELD(CH1_TX_PHALIGN_CFG2, TXPI_NUM_SAMPLES, 3, 5)
    FIELD(CH1_TX_PHALIGN_CFG2, TXPI_SAMPLE_WAIT, 1, 2)
    FIELD(CH1_TX_PHALIGN_CFG2, TXPI_MIN_THRESHOLD_OVRD, 0, 1)
REG32(CH1_TX_PHALIGN_CFG3, 0x3668)
    FIELD(CH1_TX_PHALIGN_CFG3, TXPI_MAX_THRESHOLD_OVRD, 31, 1)
    FIELD(CH1_TX_PHALIGN_CFG3, TXPI_MAX_SAMPLE_THRESHOLD, 24, 7)
    FIELD(CH1_TX_PHALIGN_CFG3, TXPI_MIN_SAMPLE_THRESHOLD, 17, 7)
    FIELD(CH1_TX_PHALIGN_CFG3, DAPICODE_OVRD, 9, 8)
    FIELD(CH1_TX_PHALIGN_CFG3, TXPICODE_OVRD, 2, 7)
    FIELD(CH1_TX_PHALIGN_CFG3, TXPI_ALIGN_DIR, 1, 1)
    FIELD(CH1_TX_PHALIGN_CFG3, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH1_TX_PHALIGN_CFG4, 0x366c)
    FIELD(CH1_TX_PHALIGN_CFG4, TXPI_SETINIT_STEPSIZE, 27, 5)
    FIELD(CH1_TX_PHALIGN_CFG4, TXPI_PHALIGN_STEPSIZE, 22, 5)
    FIELD(CH1_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_CNT, 17, 5)
    FIELD(CH1_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_WAIT_CYCLE, 12, 5)
    FIELD(CH1_TX_PHALIGN_CFG4, MLDLY_NUM_SAMPLES, 5, 5)
    FIELD(CH1_TX_PHALIGN_CFG4, MLDLY_MIN_THRESHOLD_OVRD, 4, 1)
    FIELD(CH1_TX_PHALIGN_CFG4, MLDLY_MAX_THRESHOLD_OVRD, 3, 1)
    FIELD(CH1_TX_PHALIGN_CFG4, MLDLY_SAMPLE_WAIT, 1, 2)
    FIELD(CH1_TX_PHALIGN_CFG4, DLY_ALIGN_DIR, 0, 1)
REG32(CH1_TX_PHALIGN_CFG5, 0x3670)
    FIELD(CH1_TX_PHALIGN_CFG5, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH1_TX_PHALIGN_CFG5, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH1_TX_PHALIGN_CFG5, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH1_TX_PHALIGN_CFG5, DMON_CLK_SEL, 0, 2)
REG32(CH1_PIPE_CTRL_CFG0, 0x3674)
    FIELD(CH1_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_NUM, 28, 4)
    FIELD(CH1_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_EN, 27, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, SATA_BURST_SEQ_LEN, 23, 4)
    FIELD(CH1_PIPE_CTRL_CFG0, TX_PD_ELECIDLE_MODE, 22, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, TX_EILDE_DEASSERT_DLY, 19, 3)
    FIELD(CH1_PIPE_CTRL_CFG0, TX_EIDLE_ASSERT_DLY, 16, 3)
    FIELD(CH1_PIPE_CTRL_CFG0, RX_PCSCLK_SEL, 14, 2)
    FIELD(CH1_PIPE_CTRL_CFG0, TX_PHYCLK_SEL, 13, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, TX_PCSCLK_SEL, 11, 2)
    FIELD(CH1_PIPE_CTRL_CFG0, RX_PHYCLK_SEL, 10, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD, 9, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD_EN, 8, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, PIPECLK_SEL, 7, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, RX_ELECIDLE_MODE, 5, 2)
    FIELD(CH1_PIPE_CTRL_CFG0, RX_ELECIDLE_CFG, 2, 3)
    FIELD(CH1_PIPE_CTRL_CFG0, PCIE_MODE, 1, 1)
    FIELD(CH1_PIPE_CTRL_CFG0, USB_MODE, 0, 1)
REG32(CH1_PIPE_CTRL_CFG1, 0x3678)
    FIELD(CH1_PIPE_CTRL_CFG1, SATA_SPEED, 30, 2)
    FIELD(CH1_PIPE_CTRL_CFG1, P2_SPECIAL_TURNOFF_EN, 29, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, POWERDOWN_OVRD_EN, 28, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PD_TXPMA_PWRDN_OVRD, 27, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PD_TXDRVPWRDN_OVRD, 26, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PD_RX_PD_OVRD, 25, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PD_LCPLL_PD_OVRD, 24, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PD_RPLL_PD_OVRD, 23, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PD_OOB_PD_OVRD, 22, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, OOB_PD, 21, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PIPE_FUND_RST_OVRD_EN, 20, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, IND_ERROR_REPORT, 19, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, UBLAZE_PLL_ILO_CAL_EN, 18, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PIPE_RST_USE_MST_RESET_LOOP, 17, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_PHY_READY_OVRD, 16, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_RX_SYNC_RESET_OVRD, 15, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_TX_SYNC_RESET_OVRD, 14, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_USER_RDY_OVRD, 13, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_PCS_RESET_OVRD, 12, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_PMA_RESET_OVRD, 11, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_TXPROGDIV_RST_OVRD, 10, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_LCPLL_RESET_OVRD, 9, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_LCPLL_PD_OVRD, 8, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_RPLL_RESET_OVRD, 7, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_RPLL_PD_OVRD, 6, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, PIPE_FUND_RST_EN, 5, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RST_ILO_RESET_OVRD, 4, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RXSYNC_EN, 3, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, TXSYNC_EN, 2, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, LCPLL_EN, 1, 1)
    FIELD(CH1_PIPE_CTRL_CFG1, RPLL_EN, 0, 1)
REG32(CH1_PIPE_CTRL_CFG2, 0x367c)
    FIELD(CH1_PIPE_CTRL_CFG2, PMA_SIGDET_SEL, 31, 1)
    FIELD(CH1_PIPE_CTRL_CFG2, P2P3_RX_PWRUP_EN, 30, 1)
    FIELD(CH1_PIPE_CTRL_CFG2, PD_TRANS_TIME_FROM_P2, 15, 15)
    FIELD(CH1_PIPE_CTRL_CFG2, TX_RXDETECT_REF, 12, 3)
    FIELD(CH1_PIPE_CTRL_CFG2, TX_RXDETECT_CFG, 1, 11)
    FIELD(CH1_PIPE_CTRL_CFG2, RXDETECT_BYPASS, 0, 1)
REG32(CH1_PIPE_CTRL_CFG3, 0x3680)
    FIELD(CH1_PIPE_CTRL_CFG3, PIPE_RXADAPT_SAVE_RESTORE_EN, 31, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, PIPE_LCPLL_DYN_PD_EN, 30, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, PIPE_RPLL_DYN_PD_EN, 29, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, RXOUT_DIV, 26, 3)
    FIELD(CH1_PIPE_CTRL_CFG3, TXOUT_DIV, 23, 3)
    FIELD(CH1_PIPE_CTRL_CFG3, RX_VREG_PD, 22, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, TX_VREG_PD, 21, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, ILO_CLKMUX_EN, 20, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, TX_CLKMUX_EN, 19, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, PIPE_FUND_RST_UB_BYPASS, 18, 1)
    FIELD(CH1_PIPE_CTRL_CFG3, PD_TRANS_TIME_TO_P2, 9, 9)
    FIELD(CH1_PIPE_CTRL_CFG3, PD_TRANS_TIME_NONE_P2, 0, 9)
REG32(CH1_PIPE_CTRL_CFG4, 0x3684)
    FIELD(CH1_PIPE_CTRL_CFG4, RST_TXDAPI_RST_OVRD, 31, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RX_RATE_EN, 30, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_TXDAPI_RST_OVRD, 29, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_ILO_RESET_OVRD, 28, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_UB_CTRL_WO_PHYSTATUS, 27, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_UB_REPROG_REQ_DIS, 26, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_USE_RPLL_AS_DATA_PLL, 25, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_PHYSTATUS_CNT, 20, 5)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_DATA_FLUSH_CNT, 15, 5)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_PHYSTATUS_OVRD, 14, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_CHANGE_IN_PROGRESS_OVRD, 13, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_TXRX_128B130B_EN_OVRD, 12, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_RX_SYNC_RESET_OVRD, 11, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_TX_SYNC_RESET_OVRD, 10, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_UB_REPROG_DONE_OVRD, 9, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_PCS_RESET_OVRD, 8, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_PMA_RESET_OVRD, 7, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_TXPROGDIV_RST_OVRD, 6, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_LCPLL_RESET_OVRD, 5, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_LCPLL_PD_OVRD, 4, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_RPLL_RESET_OVRD, 3, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, RATE_RPLL_PD_OVRD, 2, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, PIPE_RATE_OVRD_EN, 1, 1)
    FIELD(CH1_PIPE_CTRL_CFG4, PIPE_RATE_EN, 0, 1)
REG32(CH1_PIPE_CTRL_CFG5, 0x3688)
    FIELD(CH1_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_SYNC_ERR_EN, 31, 1)
    FIELD(CH1_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_DP_DIS_EN, 30, 1)
    FIELD(CH1_PIPE_CTRL_CFG5, PIPE_SPECIAL_OFF_RESET_EN, 29, 1)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGT_ESM_DELAY_CE_DIS, 28, 1)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK2, 25, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK, 22, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_CORECLK, 19, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_E6_PIPECLK, 16, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_E5_PIPECLK, 13, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_G4_PIPECLK, 10, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_G3_PIPECLK, 7, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_G2_PIPECLK, 4, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, BUFGTDIV_G1_PIPECLK, 1, 3)
    FIELD(CH1_PIPE_CTRL_CFG5, PIPE_BUFGT_CTRL_EN, 0, 1)
REG32(CH1_PIPE_CTRL_CFG6, 0x368c)
    FIELD(CH1_PIPE_CTRL_CFG6, RXOOB_CLKDIV_VAL, 27, 5)
    FIELD(CH1_PIPE_CTRL_CFG6, PIPE_DIST_UB_DONE_SHARE_EN, 26, 1)
    FIELD(CH1_PIPE_CTRL_CFG6, PIPE_CONSUMPT_SEL, 23, 3)
    FIELD(CH1_PIPE_CTRL_CFG6, PIPE_DISTSOUTH_SEL, 21, 2)
    FIELD(CH1_PIPE_CTRL_CFG6, PIPE_DISTNORTH_SEL, 19, 2)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGTDIV_PIPECLK_OVRD, 16, 3)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGT_RSTMASK_OVRD, 12, 4)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGT_CEMASK_OVRD, 8, 4)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGT_CE_OVRD, 7, 1)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGT_RESET_OVRD, 6, 1)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGT_OVRD_EN, 5, 1)
    FIELD(CH1_PIPE_CTRL_CFG6, BUFGT_WAIT_CNT, 0, 5)
REG32(CH1_PIPE_CTRL_CFG7, 0x3690)
    FIELD(CH1_PIPE_CTRL_CFG7, CDR_CTRL_USE_RAW_SIGVALID, 31, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, RXELECIDLE_USE_RAW_SIGVALID, 30, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, CDR_CTRL_ADAPT_HOLD_EN, 29, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, PIPE_DIST_PLLLOCK_SEL, 27, 2)
    FIELD(CH1_PIPE_CTRL_CFG7, RXPD_IND_CONTROL, 26, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, RATE_USE_LCPLL_OUTCLK_ESM56, 25, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, CDR_CTRL_USER_HOLDCDR_EN, 24, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, RX_DABYP_DIVSEL, 20, 4)
    FIELD(CH1_PIPE_CTRL_CFG7, RX_DA_DIVSEL, 16, 4)
    FIELD(CH1_PIPE_CTRL_CFG7, RX_DA_BYP, 15, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, RXOUTCLKCTL, 12, 3)
    FIELD(CH1_PIPE_CTRL_CFG7, TX_DABYP_DIVSEL, 8, 4)
    FIELD(CH1_PIPE_CTRL_CFG7, TX_DA_DIVSEL, 4, 4)
    FIELD(CH1_PIPE_CTRL_CFG7, TX_DA_BYP, 3, 1)
    FIELD(CH1_PIPE_CTRL_CFG7, TXOUTCLKCTL, 0, 3)
REG32(CH1_PIPE_CTRL_CFG8, 0x3694)
    FIELD(CH1_PIPE_CTRL_CFG8, PMA_OOB_CLKDIV_VAL, 30, 2)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_ALIGN_REQ_OVRD, 29, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_SLIP_EN, 28, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_HOLDCDR_RX_PHALIGN, 27, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G34, 26, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G12, 25, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_REFCLK_MODE, 23, 2)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_GEN34_ON_EIDLE, 22, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_GEN12_ON_EIDLE, 21, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, CDR_CTRL_EN, 20, 1)
    FIELD(CH1_PIPE_CTRL_CFG8, RXPROGDIVSEL, 10, 10)
    FIELD(CH1_PIPE_CTRL_CFG8, TXPROGDIVSEL, 0, 10)
REG32(CH1_PIPE_CTRL_CFG9, 0x3698)
    FIELD(CH1_PIPE_CTRL_CFG9, TX_RESET_TIMER_SAMPLES_LG, 30, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, TX_RESET_TIMER_RST_OFFSET, 25, 5)
    FIELD(CH1_PIPE_CTRL_CFG9, TX_RESET_TIMER_CNT_FIRST, 21, 4)
    FIELD(CH1_PIPE_CTRL_CFG9, TX_RESET_TIMER_EN, 20, 1)
    FIELD(CH1_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_IN_SEL, 18, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_IN_SEL, 16, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, RXSYNCDONE_CONSUMPT_SEL, 13, 3)
    FIELD(CH1_PIPE_CTRL_CFG9, RXSYNCDONE_DISTSOUTH_SEL, 11, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, RXSYNCDONE_DISTNORTH_SEL, 9, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_DIS, 8, 1)
    FIELD(CH1_PIPE_CTRL_CFG9, TXSYNCDONE_CONSUMPT_SEL, 5, 3)
    FIELD(CH1_PIPE_CTRL_CFG9, TXSYNCDONE_DISTSOUTH_SEL, 3, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, TXSYNCDONE_DISTNORTH_SEL, 1, 2)
    FIELD(CH1_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_DIS, 0, 1)
REG32(CH1_TX_PIPPM_CFG, 0x369c)
    FIELD(CH1_TX_PIPPM_CFG, TXPI_SYNFREQ_PPM, 25, 5)
    FIELD(CH1_TX_PIPPM_CFG, TXPI_DDR_EN, 24, 1)
    FIELD(CH1_TX_PIPPM_CFG, TXPI_PPM_DDR_CFG, 16, 8)
    FIELD(CH1_TX_PIPPM_CFG, TXPI_INVSTROBE_SEL, 15, 1)
    FIELD(CH1_TX_PIPPM_CFG, TXPI_PPM_CFG, 4, 8)
    FIELD(CH1_TX_PIPPM_CFG, TXPIPPMOVRDEN, 3, 1)
    FIELD(CH1_TX_PIPPM_CFG, TXPI_GRAY_SEL, 2, 1)
    FIELD(CH1_TX_PIPPM_CFG, TXPIPPMSEL, 1, 1)
    FIELD(CH1_TX_PIPPM_CFG, TXPIPPMPD, 0, 1)
REG32(CH1_CHL_RSV_CFG2, 0x36a0)
REG32(CH1_FABRIC_INTF_CFG0, 0x36a4)
    FIELD(CH1_FABRIC_INTF_CFG0, HSDPPCSRESET_PIN_EN, 31, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, USRRDY_PIN_EN, 30, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RX_RATE_PIN_EN, 29, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TX_RATE_PIN_EN, 28, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, CDR_PIN_EN, 27, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, QPI_PIN_EN, 26, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, ILO_RESET_PIN_EN, 25, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, PERSTB_PIN_EN, 24, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, LOOPBACK_PIN_EN, 23, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TX_PHDLYRESET_PIN_EN, 22, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TX_PHALIGN_PIN_EN, 21, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TX_DAPI_PIN_EN, 20, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RXTERMINATION_PIN_EN, 19, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TXPOLARITY_PIN_EN, 18, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TXPI_PIN_EN, 17, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TXPISOPD_PIN_EN, 16, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TXPIPPM_PIN_EN, 15, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TXPD_PIN_EN, 14, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TXINHIBIT_PIN_EN, 13, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, TX_CHRESET_PIN_EN, 12, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RX_PHDLYRESET_PIN_EN, 11, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RX_PHALIGN_PIN_EN, 10, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RX_EQTRAINING_PIN_EN, 9, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RX_DAPI_PIN_EN, 8, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RX_CHRESET_PIN_EN, 7, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RXSLIDE_PIN_EN, 6, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, PRBSSEL_PIN_EN, 5, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RXPOLARITY_PIN_EN, 4, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RXPD_PIN_EN, 3, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RXLPM_PIN_EN, 2, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, APT_PIN_EN, 1, 1)
    FIELD(CH1_FABRIC_INTF_CFG0, RXCDRHOLD_PIN_EN, 0, 1)
REG32(CH1_FABRIC_INTF_CFG1, 0x36a8)
    FIELD(CH1_FABRIC_INTF_CFG1, A_RXSLIDE, 31, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_TXRATE, 23, 8)
    FIELD(CH1_FABRIC_INTF_CFG1, A_RXPRBSSEL, 19, 4)
    FIELD(CH1_FABRIC_INTF_CFG1, A_RXPOLARITY, 18, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_RXPD, 16, 2)
    FIELD(CH1_FABRIC_INTF_CFG1, A_RXLPMEN, 15, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRHOLD, 11, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_PERSTB, 10, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_LOOPBACK, 7, 3)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRSTEPSX, 6, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRSTEPSQ, 5, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRSTEPDIR, 4, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRINCPCTRL, 3, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRFREQOS, 2, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDROVREN, 1, 1)
    FIELD(CH1_FABRIC_INTF_CFG1, A_CDRBMCDRREQ, 0, 1)
REG32(CH1_FABRIC_INTF_CFG2, 0x36ac)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RXUSRRDY, 31, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_TXUSRRDY, 30, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_ILO_RESETMASK, 29, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_ILORESET, 28, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_CDRPHRESET, 27, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_EYESCANRESET, 26, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RXOOBRESET, 25, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RXPRBSCNTRESET, 24, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RX_PROGDIVRESET, 23, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_GTRXRESET, 22, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RX_RESETMODE, 20, 2)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RX_PCS_RESETMASK, 15, 5)
    FIELD(CH1_FABRIC_INTF_CFG2, A_RX_PMA_RESETMASK, 8, 7)
    FIELD(CH1_FABRIC_INTF_CFG2, A_TX_PCS_RESETMASK, 7, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_TX_PMA_RESETMASK, 4, 3)
    FIELD(CH1_FABRIC_INTF_CFG2, A_TX_PROGDIVRESET, 3, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_GTTXRESET, 2, 1)
    FIELD(CH1_FABRIC_INTF_CFG2, A_TX_RESETMODE, 0, 2)
REG32(CH1_FABRIC_INTF_CFG3, 0x36b0)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXDAPICODERESET, 31, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXDAPICODEOVRDEN, 30, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXPOLARITY, 29, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXPICODERESET, 28, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXPICODEOVRDEN, 27, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXPISOPD, 26, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_STEPSIZEPPM, 21, 5)
    FIELD(CH1_FABRIC_INTF_CFG3, A_ENPPM, 20, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXPD, 18, 2)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXINHIBIT, 17, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXPHSHIFT180, 16, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXPHSETINITREQ, 15, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXPHALIGNREQ, 14, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXPHDLYPD, 13, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXDLYALIGNREQ, 12, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXMLFINEALIGNREQ, 11, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXMLDCHAINREQ, 10, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXMLDCHAINDONE, 9, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXEQTRAINING, 8, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXDAPICODERESET, 7, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXDAPICODEOVRDEN, 6, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXDAPIRESET, 5, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RX_PHALIGN_RESETMASK, 4, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_RXPHDLYRESET, 3, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXDAPIRESET, 2, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TX_PHALIGN_RESETMASK, 1, 1)
    FIELD(CH1_FABRIC_INTF_CFG3, A_TXPHDLYRESET, 0, 1)
REG32(CH1_FABRIC_INTF_CFG4, 0x36b4)
    FIELD(CH1_FABRIC_INTF_CFG4, A_APT_OVERWREN, 31, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_APT_EXTHOLD, 30, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_RXQPIEN, 29, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXQPIWEAKPU, 28, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXQPIBIASEN, 27, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_EYESCANTRIGGER, 26, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_PHY_ESM_ADAPTATION_SAVE, 25, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_RXTERMINATION, 24, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_RXRATE, 16, 8)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXDAPIRESETMASK, 13, 2)
    FIELD(CH1_FABRIC_INTF_CFG4, A_RXDAPIRESETMASK, 11, 2)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXMLFINEALIGNREQ, 10, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXMLDCHAINREQ, 9, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXDLYALIGNREQ, 8, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXPHSHIFT180, 7, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXPHSETINITREQ, 6, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXPHALIGNREQ, 5, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXPHDLYPD, 4, 1)
    FIELD(CH1_FABRIC_INTF_CFG4, A_TXPRBSSEL, 0, 4)
REG32(CH1_FABRIC_INTF_CFG5, 0x36b8)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXEMPPRE, 27, 5)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXEMPPOS, 22, 5)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXEMPMAIN, 15, 7)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXDRVAMP, 10, 5)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXDEEMPH, 8, 2)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXSWING, 7, 1)
    FIELD(CH1_FABRIC_INTF_CFG5, A_TXMARGIN, 4, 3)
    FIELD(CH1_FABRIC_INTF_CFG5, EYESCANTRIGGER_PIN_EN, 2, 1)
    FIELD(CH1_FABRIC_INTF_CFG5, TX_EQ_PIN_EN, 1, 1)
    FIELD(CH1_FABRIC_INTF_CFG5, PHYESMADAPTSAVE_PIN_EN, 0, 1)
REG32(CH1_RX_ELASTIC_BUF_CFG1, 0x36bc)
    FIELD(CH1_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_3, 22, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_2, 12, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_1, 2, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_PRECEDENCE, 1, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_KEEP_IDLE, 0, 1)
REG32(CH1_RX_ELASTIC_BUF_CFG2, 0x36c0)
    FIELD(CH1_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_LEN, 30, 2)
    FIELD(CH1_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_2, 20, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_1, 10, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_1_4, 0, 10)
REG32(CH1_RX_ELASTIC_BUF_CFG3, 0x36c4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_DISPERR_SEQ_MATCH, 31, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_DATA_SOURCE_SEL, 30, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_USB3_CLK_COR_EQ_EN, 29, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_EN, 25, 4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_1_EN, 21, 4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_USE, 20, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_4, 10, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_3, 0, 10)
REG32(CH1_RX_ELASTIC_BUF_CFG4, 0x36c8)
    FIELD(CH1_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_3, 22, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_2, 12, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_1, 2, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_LEN, 0, 2)
REG32(CH1_RX_ELASTIC_BUF_CFG5, 0x36cc)
    FIELD(CH1_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_USE, 30, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_2, 20, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_1, 10, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_1_4, 0, 10)
REG32(CH1_RX_ELASTIC_BUF_CFG6, 0x36d0)
    FIELD(CH1_RX_ELASTIC_BUF_CFG6, EB_8B10B_FTS_DESKEW_SEQ_EN, 28, 4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_EN, 24, 4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_1_EN, 20, 4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_4, 10, 10)
    FIELD(CH1_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_3, 0, 10)
REG32(CH1_RX_ELASTIC_BUF_CFG7, 0x36d4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB128B130B_32_BLKALGN_CTL, 31, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB128B130B_32_EIOS_LPBK4_BYP, 30, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB128B130B_16_BLKALGN_CTL, 29, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB128B130B_16_EIOS_LPBK4_BYP, 28, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB128B130B_32_ONE_SKP_INS_DEL, 26, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_SLAVE, 22, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MASTER, 21, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_LEVEL, 18, 3)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_BUFFER_CFG, 12, 6)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_DELAY_CC_AFTER_FTS, 11, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_KEEP_4ADJ, 10, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SNAP4_USE, 9, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SLIP4_USE, 8, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_LANE_DESKEW_EN, 7, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_KEEP_ALIGN, 6, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MAX_SKEW, 2, 4)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_EN, 1, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG7, EB8B10B_ADDR_MODE, 0, 1)
REG32(CH1_RX_ELASTIC_BUF_CFG8, 0x36d8)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EIOS_DEL_SEL, 31, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, EB128B130B_32_AUTO_REALIGN, 28, 2)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, EB128B130B_32_FULL_THRESH, 16, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EMPTY_THRESH, 11, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MAX_LAT, 6, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MIN_LAT, 1, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG8, ELASTICBUF_128B130B_EN, 0, 1)
REG32(CH1_RX_ELASTIC_BUF_CFG9, 0x36dc)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EIOS_DEL_SEL, 31, 1)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_AUTO_REALIGN, 28, 2)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_FULL_THRESH, 16, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EMPTY_THRESH, 11, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MAX_LAT, 6, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MIN_LAT, 1, 5)
    FIELD(CH1_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EN, 0, 1)
REG32(CH1_RX_OOB_CFG0, 0x36e0)
    FIELD(CH1_RX_OOB_CFG0, OOB_SATA_EIDLE_VAL, 27, 3)
    FIELD(CH1_RX_OOB_CFG0, OOB_SATA_BURST_VAL, 24, 3)
    FIELD(CH1_RX_OOB_CFG0, OOB_SATA_MAX_INIT, 18, 6)
    FIELD(CH1_RX_OOB_CFG0, OOB_SATA_MIN_INIT, 12, 6)
    FIELD(CH1_RX_OOB_CFG0, OOB_SATA_MAX_BURST, 6, 6)
    FIELD(CH1_RX_OOB_CFG0, OOB_SATA_MIN_BURST, 0, 6)
REG32(CH1_RX_OOB_CFG1, 0x36e4)
    FIELD(CH1_RX_OOB_CFG1, OOB_SAS_MAX_COM, 18, 7)
    FIELD(CH1_RX_OOB_CFG1, OOB_SAS_MIN_COM, 12, 6)
    FIELD(CH1_RX_OOB_CFG1, OOB_SATA_MAX_WAKE, 6, 6)
    FIELD(CH1_RX_OOB_CFG1, OOB_SATA_MIN_WAKE, 0, 6)
REG32(CH1_MONITOR_CFG, 0x36e8)
    FIELD(CH1_MONITOR_CFG, RXAMONSEL, 26, 6)
    FIELD(CH1_MONITOR_CFG, TXAMONSEL, 21, 5)
    FIELD(CH1_MONITOR_CFG, DAAMONSEL, 18, 3)
    FIELD(CH1_MONITOR_CFG, CHCKAMONSEL, 14, 4)
    FIELD(CH1_MONITOR_CFG, CHAMONSEL, 12, 2)
    FIELD(CH1_MONITOR_CFG, DMON_FIFO_BYPASS, 7, 1)
    FIELD(CH1_MONITOR_CFG, DMON_CLK_SRC, 4, 3)
    FIELD(CH1_MONITOR_CFG, DMON_DATA_SRC, 1, 3)
    FIELD(CH1_MONITOR_CFG, DMON_EN, 0, 1)
REG32(CH1_PIPE_CTRL_CFG10, 0x36ec)
    FIELD(CH1_PIPE_CTRL_CFG10, RATE_CHANGE_DURING_RST_EN, 31, 1)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_RXDAPI_RST_MASK, 25, 2)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_TXDAPI_RST_MASK, 23, 2)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_RXSYNC_RST_MASK, 22, 1)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_TXSYNC_RST_MASK, 21, 1)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_RXPCS_RST_MASK, 16, 5)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_RXPMA_RST_MASK, 9, 7)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_TXPCS_RST_MASK, 8, 1)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_TXPMA_RST_MASK, 5, 3)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_LCPLL_RST_MASK, 2, 2)
    FIELD(CH1_PIPE_CTRL_CFG10, PIPE_RPLL_RST_MASK, 0, 2)
REG32(CH1_CHL_RSV_CFG3, 0x36f0)
REG32(CH1_CHL_RSV_CFG4, 0x36f4)
REG32(MEMCELLX36F8, 0x36f8)
    FIELD(MEMCELLX36F8, QUAD_MUX1_REFCLK_SEL, 30, 2)
REG32(MEMCELLX36FC, 0x36fc)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_EN_FABRIC_CK, 25, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_HROW_CK_SEL, 23, 2)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_ICNTL_RX, 21, 2)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_EN_DC_COUP, 20, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_VCM_HIGH, 19, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_VCM_LOW, 18, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_EN_TX_PATH, 17, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_CLKOUT_SEL, 15, 2)
    FIELD(MEMCELLX36FC, REFCLK0_RXRECCLK_SEL, 13, 2)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_CTL_DRV_EN_CAL, 8, 5)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_CTL_DRV_SWING, 4, 3)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_RPLL_CLK_SEL_EN, 3, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_ENB_VCM_STRONG, 2, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_EN_DRV, 1, 1)
    FIELD(MEMCELLX36FC, REFCLK0_REFCLK_EN_BLD, 0, 1)
REG32(HSCLK1_LCPLL_LGC_CFG0, 0x3830)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_AUTO_FINE_EN, 31, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_FINE_SWEEP, 29, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_OVRD_MODE, 27, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_CRSACCY, 25, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_MONCLKCYCLE, 22, 3)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_PLLLOCKCOARSE, 20, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_PLLLOCKFACTOR, 18, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_UNLOCKCTRL, 16, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_VCTRL_LATCH_BYPASS, 15, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_BYP_LOCKDETECT, 13, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_COARSE_FREQ_OVRD_EN, 12, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLLLOCKEN, 11, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_ALLOW_LB2UB, 10, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_ALLOW_UB2LB, 9, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_VCO_SEL_AUTO, 8, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_VCO_SEL, 7, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG0, LCPLL_COARSE_FREQ_OVRD, 0, 7)
REG32(HSCLK1_LCPLL_LGC_CFG1, 0x3834)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, PLL_RESET_DLY_TIME, 24, 8)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, SDM_RESET_DLY_TIME, 20, 4)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, SDM_LOOP_BYPASS_HANDSHAKE, 19, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, PRESCALE_DIV, 17, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, RESET_ON_PWRDN, 16, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, LCPLL_BIN_ORDER, 13, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, LCPLL_SDM_ORDER, 11, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, SDM_WIDTHSEL, 9, 2)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, RATESEL, 8, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, BYPASS, 7, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, CLKSEL, 6, 1)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, TESTCON, 1, 5)
    FIELD(HSCLK1_LCPLL_LGC_CFG1, TESTEN, 0, 1)
REG32(HSCLK1_LCPLL_LGC_CFG2, 0x3838)
    FIELD(HSCLK1_LCPLL_LGC_CFG2, SDM_SEED, 0, 25)
REG32(HSCLK1_LCPLL_CFG0, 0x383c)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_VCTRL_RESET, 28, 4)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_PREDIV, 20, 5)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_CP, 10, 10)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_VREG_GILTER_BYPASS, 9, 1)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_VREG_EN, 8, 1)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_VREG_GILTER_CTRL, 3, 5)
    FIELD(HSCLK1_LCPLL_CFG0, LCPLL_VCCSEL, 0, 3)
REG32(PIN_CFG0, 0x3840)
    FIELD(PIN_CFG0, DRP_RESET_PIN_EN, 27, 1)
    FIELD(PIN_CFG0, MST_TX_RESET_PIN_EN, 26, 1)
    FIELD(PIN_CFG0, MST_RX_RESET_PIN_EN, 25, 1)
    FIELD(PIN_CFG0, HS1_RPLLRESET_PIN_EN, 24, 1)
    FIELD(PIN_CFG0, HS1_RPLLPD_PIN_EN, 22, 1)
    FIELD(PIN_CFG0, HS1_RPLL_SDM_PIN_EN, 21, 1)
    FIELD(PIN_CFG0, HS1_RPLL_FBDIV_PIN_EN, 20, 1)
    FIELD(PIN_CFG0, HS1_LCPLLRESET_PIN_EN, 19, 1)
    FIELD(PIN_CFG0, HS1_LCPLLPD_PIN_EN, 17, 1)
    FIELD(PIN_CFG0, HS1_LCPLL_SDM_PIN_EN, 16, 1)
    FIELD(PIN_CFG0, HS1_LCPLL_FBDIV_PIN_EN, 15, 1)
    FIELD(PIN_CFG0, HS0_RPLLRESET_PIN_EN, 14, 1)
    FIELD(PIN_CFG0, HS0_RPLLPD_PIN_EN, 12, 1)
    FIELD(PIN_CFG0, HS0_RPLL_SDM_PIN_EN, 11, 1)
    FIELD(PIN_CFG0, HS0_RPLL_FBDIV_PIN_EN, 10, 1)
    FIELD(PIN_CFG0, HS0_LCPLLRESET_PIN_EN, 9, 1)
    FIELD(PIN_CFG0, HS0_LCPLLPD_PIN_EN, 7, 1)
    FIELD(PIN_CFG0, HS0_LCPLL_SDM_PIN_EN, 6, 1)
    FIELD(PIN_CFG0, HS0_LCPLL_FBDIV_PIN_EN, 5, 1)
    FIELD(PIN_CFG0, GTREFCLK1_PD_PIN_EN, 4, 1)
    FIELD(PIN_CFG0, GTREFCLK0_PD_PIN_EN, 3, 1)
    FIELD(PIN_CFG0, BG_PIN_EN, 1, 1)
    FIELD(PIN_CFG0, UBLAZE_FABRIC_PIN_EN, 0, 1)
REG32(A_CFG0, 0x3844)
    FIELD(A_CFG0, MC_A_DRP_RST, 20, 1)
    FIELD(A_CFG0, A_MSTRXRESET, 16, 4)
    FIELD(A_CFG0, A_MSTTXRESET, 12, 4)
    FIELD(A_CFG0, A_UB_ENABLE, 10, 1)
    FIELD(A_CFG0, A_GTREFCLK1_PD, 9, 1)
    FIELD(A_CFG0, A_GTREFCLK0_PD, 8, 1)
    FIELD(A_CFG0, A_RCALEN, 7, 1)
    FIELD(A_CFG0, A_BGRCALOVRD, 2, 5)
    FIELD(A_CFG0, A_BGRCALOVRD_EN, 1, 1)
    FIELD(A_CFG0, A_BGPD, 0, 1)
REG32(A_CFG1, 0x3848)
    FIELD(A_CFG1, A_HS1_RPLLFBDIV, 24, 8)
    FIELD(A_CFG1, A_HS1_LCPLLFBDIV, 16, 8)
    FIELD(A_CFG1, A_HS0_RPLLFBDIV, 8, 8)
    FIELD(A_CFG1, A_HS0_LCPLLFBDIV, 0, 8)
REG32(A_CFG2, 0x384c)
    FIELD(A_CFG2, A_HS0_LCPLLPD, 31, 1)
    FIELD(A_CFG2, A_HS0_LCPLLRESETMASK, 29, 2)
    FIELD(A_CFG2, A_HS0_LCPLLRESETBYPASSMODE, 28, 1)
    FIELD(A_CFG2, A_HS0_LCPLLRESET, 27, 1)
    FIELD(A_CFG2, A_HS0_LCPLLSDMTOGGLE, 26, 1)
    FIELD(A_CFG2, A_HS0_LCPLLSDMDATA, 0, 26)
REG32(HSCLK1_LCPLL_CFG1, 0x3870)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_REGMON_EN, 31, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_VCTMON_EN, 30, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_VBG_EN, 29, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_AVCC_EN, 28, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_ICPMON_EN, 27, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_RDAC_CTB, 19, 2)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_RCTRL, 15, 4)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_VCO_TCOMP_EN, 14, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_SCTRL_BYPS, 13, 1)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_IVCO_CNTRL, 8, 5)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_SVCO_CNTRL, 2, 6)
    FIELD(HSCLK1_LCPLL_CFG1, LCPLL_RP_COMP, 0, 2)
REG32(HSCLK1_LCPLL_CFG2, 0x3874)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_LPF, 16, 16)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_REFCLK_EN, 15, 1)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_DIV2OPT, 14, 1)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_DIG_MON, 13, 1)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_FBCLK_EN, 12, 1)
    FIELD(HSCLK1_LCPLL_CFG2, DIV2OPT_EN, 11, 1)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_DYNSEL, 3, 1)
    FIELD(HSCLK1_LCPLL_CFG2, LCPLL_REFCLK_SEL, 0, 3)
REG32(CH2_RESET_TIME_CFG0, 0x3878)
    FIELD(CH2_RESET_TIME_CFG0, TX_PCS_RESET_TIME, 25, 5)
    FIELD(CH2_RESET_TIME_CFG0, TX_PMA_RESET_TIME, 20, 5)
    FIELD(CH2_RESET_TIME_CFG0, TX_CLKGEN_RESET_TIME, 15, 5)
    FIELD(CH2_RESET_TIME_CFG0, TX_DCD_RESET_TIME, 10, 5)
    FIELD(CH2_RESET_TIME_CFG0, ILO_RESET_TIME, 0, 5)
REG32(CH2_RESET_TIME_CFG1, 0x387c)
    FIELD(CH2_RESET_TIME_CFG1, RX_PMA_RESET_TIME, 25, 5)
    FIELD(CH2_RESET_TIME_CFG1, RX_CLKGEN_RESET_TIME, 20, 5)
    FIELD(CH2_RESET_TIME_CFG1, RX_DCD_RESET_TIME, 15, 5)
    FIELD(CH2_RESET_TIME_CFG1, RX_CFOK_RESET_TIME, 10, 5)
    FIELD(CH2_RESET_TIME_CFG1, RX_PHALIGN_RESET_TIME, 5, 5)
    FIELD(CH2_RESET_TIME_CFG1, TX_PHALIGN_RESET_TIME, 0, 5)
REG32(CH2_RESET_TIME_CFG2, 0x3880)
    FIELD(CH2_RESET_TIME_CFG2, RX_BUF_RESET_TIME, 25, 5)
    FIELD(CH2_RESET_TIME_CFG2, RX_PRBS_RESET_TIME, 20, 5)
    FIELD(CH2_RESET_TIME_CFG2, RX_PCS_RESET_TIME, 15, 5)
    FIELD(CH2_RESET_TIME_CFG2, RX_DFE_RESET_TIME, 10, 5)
    FIELD(CH2_RESET_TIME_CFG2, RX_CDRFREQ_RESET_TIME, 5, 5)
    FIELD(CH2_RESET_TIME_CFG2, RX_CDRPHASE_RESET_TIME, 0, 5)
REG32(CH2_RESET_TIME_CFG3, 0x3884)
    FIELD(CH2_RESET_TIME_CFG3, TX_DAPI_RESET_TIME, 29, 3)
    FIELD(CH2_RESET_TIME_CFG3, RX_DAPI_RESET_TIME, 26, 3)
    FIELD(CH2_RESET_TIME_CFG3, TX_DAPIDIV_RESET_TIME, 21, 5)
    FIELD(CH2_RESET_TIME_CFG3, RX_DAPIDIV_RESET_TIME, 16, 5)
    FIELD(CH2_RESET_TIME_CFG3, RX_PROGDIV_RESET_TIME, 13, 3)
    FIELD(CH2_RESET_TIME_CFG3, TX_PROGDIV_RESET_TIME, 10, 3)
    FIELD(CH2_RESET_TIME_CFG3, RX_EYESCAN_RESET_TIME, 5, 5)
    FIELD(CH2_RESET_TIME_CFG3, RX_OOB_RESET_TIME, 0, 5)
REG32(CH2_RESET_LOOPER_ID_CFG, 0x3888)
    FIELD(CH2_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_END_ID, 28, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_START_ID, 24, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_END_ID, 20, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_START_ID, 16, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_END_ID, 12, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_START_ID, 8, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_END_ID, 4, 4)
    FIELD(CH2_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_START_ID, 0, 4)
REG32(CH2_RESET_LOOP_ID_CFG0, 0x388c)
    FIELD(CH2_RESET_LOOP_ID_CFG0, TX_PCS_RESET_LOOP_ID, 12, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG0, TX_PMA_RESET_LOOP_ID, 8, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG0, TX_CLKGEN_RESET_LOOP_ID, 4, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG0, TX_DCD_RESET_LOOP_ID, 0, 4)
REG32(CH2_RESET_LOOP_ID_CFG1, 0x3890)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_PCS_RESET_LOOP_ID, 28, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_DFE_RESET_LOOP_ID, 24, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_CDRFREQ_RESET_LOOP_ID, 20, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_CDRPHASE_RESET_LOOP_ID, 16, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_PMA_RESET_LOOP_ID, 12, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_CLKGEN_RESET_LOOP_ID, 8, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_DCD_RESET_LOOP_ID, 4, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG1, RX_CFOK_RESET_LOOP_ID, 0, 4)
REG32(CH2_RESET_LOOP_ID_CFG2, 0x3894)
    FIELD(CH2_RESET_LOOP_ID_CFG2, RX_OOB_RESET_LOOP_ID, 12, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG2, RX_EYESCAN_RESET_LOOP_ID, 8, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG2, RX_BUF_RESET_LOOP_ID, 4, 4)
    FIELD(CH2_RESET_LOOP_ID_CFG2, RX_PRBS_RESET_LOOP_ID, 0, 4)
REG32(CH2_RESET_BYP_HDSHK_CFG, 0x3898)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDAPI_RESET_LOOP, 9, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDAPI_RESET_LOOP, 8, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CDR_RESET_LOOP, 7, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDCD_RESET_LOOP, 6, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CFOK_RESET_LOOP, 5, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RX_PHALIGN_RESET_LOOP, 4, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PHALIGN_RESET_LOOP, 3, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDCD_RESET_LOOP, 2, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PCS_RESET_LOOP, 1, 1)
    FIELD(CH2_RESET_BYP_HDSHK_CFG, BYP_HDSHK_ILO_RESET_LOOP, 0, 1)
REG32(CH2_RESET_CFG, 0x389c)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_EIDLE_LO_CNT, 28, 4)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_EIDLE_HI_CNT, 24, 4)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_ON_EIDLE, 23, 1)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_ON_COMMAALIGN, 22, 1)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_DEFER_EN, 21, 1)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_ON_RXVALID, 20, 1)
    FIELD(CH2_RESET_CFG, EB8B10B_RESET_ON_UNALIGN, 19, 1)
    FIELD(CH2_RESET_CFG, HSDP_MST_RESET_EN, 16, 1)
    FIELD(CH2_RESET_CFG, TXPHYCLK_FREQ_CNT_EN, 15, 1)
    FIELD(CH2_RESET_CFG, TXPCSCLK_FREQ_CNT_EN, 14, 1)
    FIELD(CH2_RESET_CFG, TXUSRCLK_FREQ_CNT_EN, 13, 1)
    FIELD(CH2_RESET_CFG, RXPHYCLK_FREQ_CNT_EN, 12, 1)
    FIELD(CH2_RESET_CFG, RXPCSCLK_FREQ_CNT_EN, 11, 1)
    FIELD(CH2_RESET_CFG, RXUSRCLK_FREQ_CNT_EN, 10, 1)
    FIELD(CH2_RESET_CFG, CDR_SOFTRESET_MODE, 7, 1)
    FIELD(CH2_RESET_CFG, ILORESET_BYPASS_MODE, 6, 1)
    FIELD(CH2_RESET_CFG, ILORESET_ON_PLLLOCK, 5, 1)
    FIELD(CH2_RESET_CFG, ILORESET_PLLLOCK_SEL, 4, 1)
    FIELD(CH2_RESET_CFG, RX_PMA_RST_SYNC_DISABLE, 3, 1)
    FIELD(CH2_RESET_CFG, PRESCALE_DIV, 0, 3)
REG32(MEMCELLX38A0, 0x38a0)
    FIELD(MEMCELLX38A0, CH2_INSTANTIATED, 31, 1)
    FIELD(MEMCELLX38A0, CH2_SIM_TX_EIDLE_DRIVE_LEVEL, 6, 2)
    FIELD(MEMCELLX38A0, CH2_SIM_RESET_SPEEDUP, 5, 1)
    FIELD(MEMCELLX38A0, CH2_SIM_RECEIVER_DETECT_PASS, 4, 1)
    FIELD(MEMCELLX38A0, CH2_SIM_MODE, 0, 4)
REG32(CH2_TX_ANA_CFG0, 0x38a4)
    FIELD(CH2_TX_ANA_CFG0, TX_VREG_CTRL, 6, 3)
    FIELD(CH2_TX_ANA_CFG0, TX_VREG_VREFSEL, 4, 2)
    FIELD(CH2_TX_ANA_CFG0, TX_LPK_SARC_ENB, 3, 1)
REG32(CH2_TX_DRV_CFG0, 0x38a8)
    FIELD(CH2_TX_DRV_CFG0, TX_REG_COMP_EN, 31, 1)
    FIELD(CH2_TX_DRV_CFG0, TX_REG_SCALE_SEL, 25, 6)
    FIELD(CH2_TX_DRV_CFG0, TX_CTL_DRV_OVR_EN, 24, 1)
    FIELD(CH2_TX_DRV_CFG0, TX_CTL_DRV_EN, 20, 4)
    FIELD(CH2_TX_DRV_CFG0, TX_REFBIAS_ENB_IPP, 19, 1)
    FIELD(CH2_TX_DRV_CFG0, TX_REFBIAS_EN_AVCC, 18, 1)
    FIELD(CH2_TX_DRV_CFG0, TX_QPI_STATEN, 4, 1)
    FIELD(CH2_TX_DRV_CFG0, TX_TXLPK_DRVHIZ, 3, 1)
    FIELD(CH2_TX_DRV_CFG0, TX_SW_MEAS, 0, 3)
REG32(CH2_TX_DRV_CFG1, 0x38ac)
    FIELD(CH2_TX_DRV_CFG1, TX_VCTRLN_ADJ_EN, 31, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_VCTRLP_ADJ_EN, 30, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_ZRES_RATIO_SEL, 22, 5)
    FIELD(CH2_TX_DRV_CFG1, TX_ZCTRLP_OVR_EN, 21, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_ZCTRLP_OVR_SEL, 19, 2)
    FIELD(CH2_TX_DRV_CFG1, TX_ZCTRLN_OVR_EN, 18, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_ZCTRLN_OVR_SEL, 16, 2)
    FIELD(CH2_TX_DRV_CFG1, TX_REGP_PDB, 12, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_REGN_PDB, 11, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_VSWING_SEL_OVR_EN, 10, 1)
    FIELD(CH2_TX_DRV_CFG1, TX_REGP_VSWING_SEL_OVR, 4, 6)
    FIELD(CH2_TX_DRV_CFG1, TX_REGN_VSWING_SEL_OVR, 0, 4)
REG32(CH2_CHL_RSV_CFG0, 0x38b0)
    FIELD(CH2_CHL_RSV_CFG0, EB8B10B_RESET_RXVALID_DELAY, 28, 4)
    FIELD(CH2_CHL_RSV_CFG0, UBALZE_GPI_OUT1_SEL, 17, 2)
    FIELD(CH2_CHL_RSV_CFG0, UB_REPROG_DONE_RXPD_BYPASS, 16, 1)
    FIELD(CH2_CHL_RSV_CFG0, RXPOWERDOWN_UBLAZE_CTRL_EN, 15, 1)
    FIELD(CH2_CHL_RSV_CFG0, RXTERMINATION_OVRD, 13, 2)
    FIELD(CH2_CHL_RSV_CFG0, UB_REPROG_DONE_TXPD_BYPASS, 12, 1)
    FIELD(CH2_CHL_RSV_CFG0, UBALZE_GPI_OUT3_SEL, 10, 2)
    FIELD(CH2_CHL_RSV_CFG0, TXPOWERDOWN_UBLAZE_CTRL_EN, 9, 1)
    FIELD(CH2_CHL_RSV_CFG0, PD_TRANS_TIME_CPMIN, 0, 9)
REG32(CH2_TX_SER_CFG0, 0x38b4)
    FIELD(CH2_TX_SER_CFG0, TX_SEL_CLK_DLY, 10, 2)
    FIELD(CH2_TX_SER_CFG0, CLK_SEL_CLK_STG2, 8, 2)
    FIELD(CH2_TX_SER_CFG0, TX_SEL_CLK_PCS, 4, 4)
    FIELD(CH2_TX_SER_CFG0, TX_ENABLE_STG1, 3, 1)
REG32(CH2_RX_CDR_CFG0, 0x38b8)
    FIELD(CH2_RX_CDR_CFG0, SELMODE, 31, 1)
    FIELD(CH2_RX_CDR_CFG0, DATAWIDTH_OVR, 27, 4)
    FIELD(CH2_RX_CDR_CFG0, LOWLATENCY_OVR, 26, 1)
    FIELD(CH2_RX_CDR_CFG0, S_SEL, 20, 2)
    FIELD(CH2_RX_CDR_CFG0, D_SEL_Y, 19, 1)
    FIELD(CH2_RX_CDR_CFG0, D_SEL_P, 18, 1)
    FIELD(CH2_RX_CDR_CFG0, Y_SEL_X, 17, 1)
    FIELD(CH2_RX_CDR_CFG0, X_SEL_Y, 16, 1)
    FIELD(CH2_RX_CDR_CFG0, WALKSPEED_BM, 14, 2)
    FIELD(CH2_RX_CDR_CFG0, WALKSPEED_CMN, 12, 2)
    FIELD(CH2_RX_CDR_CFG0, TESTCON, 8, 3)
    FIELD(CH2_RX_CDR_CFG0, TESTSRC, 5, 3)
    FIELD(CH2_RX_CDR_CFG0, TESTRATESEL, 3, 2)
    FIELD(CH2_RX_CDR_CFG0, TESTCHCLKSEL, 2, 1)
    FIELD(CH2_RX_CDR_CFG0, TESTEN, 1, 1)
    FIELD(CH2_RX_CDR_CFG0, CDRENF, 0, 1)
REG32(CH2_RX_CDR_CFG1, 0x38bc)
    FIELD(CH2_RX_CDR_CFG1, DELTA_SAT_MODE, 28, 3)
    FIELD(CH2_RX_CDR_CFG1, DXD_VAL, 16, 12)
    FIELD(CH2_RX_CDR_CFG1, CFG_TOGGLE, 15, 1)
    FIELD(CH2_RX_CDR_CFG1, FREQ_SYMM, 14, 1)
    FIELD(CH2_RX_CDR_CFG1, WALKSPEED_SLIP, 12, 2)
    FIELD(CH2_RX_CDR_CFG1, SLIP_MAG, 10, 2)
    FIELD(CH2_RX_CDR_CFG1, SLIP_ENB, 9, 1)
    FIELD(CH2_RX_CDR_CFG1, PI_DDR_MODE, 8, 1)
    FIELD(CH2_RX_CDR_CFG1, FLIPCLKTOPI, 7, 1)
    FIELD(CH2_RX_CDR_CFG1, PICODE_D_OVR, 0, 7)
REG32(CH2_RX_CDR_CFG2, 0x38c0)
    FIELD(CH2_RX_CDR_CFG2, DXDSCAL_DSEL_OVR, 31, 1)
    FIELD(CH2_RX_CDR_CFG2, DXDSCAL_EN_OVR, 30, 1)
    FIELD(CH2_RX_CDR_CFG2, DXDSCAL_CYCLES, 27, 3)
    FIELD(CH2_RX_CDR_CFG2, DXDSCAL_DS_EN, 26, 1)
    FIELD(CH2_RX_CDR_CFG2, DXDSCAL_DX_EN, 25, 1)
    FIELD(CH2_RX_CDR_CFG2, RX_DCC_DONE_BYP, 24, 1)
    FIELD(CH2_RX_CDR_CFG2, VOTEWX, 13, 3)
    FIELD(CH2_RX_CDR_CFG2, VOTEWY, 10, 3)
    FIELD(CH2_RX_CDR_CFG2, PMULFAC, 7, 3)
    FIELD(CH2_RX_CDR_CFG2, PDIVFAC, 4, 3)
    FIELD(CH2_RX_CDR_CFG2, FDIVFAC, 0, 4)
REG32(CH2_RX_CDR_CFG3, 0x38c4)
    FIELD(CH2_RX_CDR_CFG3, PMULFACDYNTARGET, 24, 8)
    FIELD(CH2_RX_CDR_CFG3, PMULFACDYNSEL, 22, 2)
    FIELD(CH2_RX_CDR_CFG3, PMULFACDYNEN, 21, 1)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQFAC3, 19, 2)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQCNT3, 16, 3)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQFAC2, 14, 2)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQCNT2, 11, 3)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQFAC1, 9, 2)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQCNT1, 6, 3)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQFAC0, 4, 2)
    FIELD(CH2_RX_CDR_CFG3, PMULSEQCNT0, 1, 3)
    FIELD(CH2_RX_CDR_CFG3, PMULFACSEQEN, 0, 1)
REG32(CH2_RX_CDR_CFG4, 0x38c8)
    FIELD(CH2_RX_CDR_CFG4, METASTABLE_MODE, 29, 2)
    FIELD(CH2_RX_CDR_CFG4, BMCDR_MISC, 27, 2)
    FIELD(CH2_RX_CDR_CFG4, BMCDR_MAG, 22, 5)
    FIELD(CH2_RX_CDR_CFG4, BMCDR_WINDOW, 18, 4)
    FIELD(CH2_RX_CDR_CFG4, BMCDR_MODE, 16, 2)
    FIELD(CH2_RX_CDR_CFG4, FORCEFOS, 15, 1)
    FIELD(CH2_RX_CDR_CFG4, FOSCNT, 12, 3)
    FIELD(CH2_RX_CDR_CFG4, FOSVAL, 0, 12)
REG32(CH2_ADAPT_APT_CFG, 0x38cc)
REG32(CH2_ADAPT_CAL_CFG, 0x38d0)
    FIELD(CH2_ADAPT_CAL_CFG, OVWRFNSH, 31, 1)
    FIELD(CH2_ADAPT_CAL_CFG, OVWRDAC, 25, 6)
    FIELD(CH2_ADAPT_CAL_CFG, OVWRADD, 21, 4)
    FIELD(CH2_ADAPT_CAL_CFG, OVWRPLS0, 20, 1)
    FIELD(CH2_ADAPT_CAL_CFG, OVWRSKIP, 19, 1)
    FIELD(CH2_ADAPT_CAL_CFG, SEQMAX, 16, 3)
    FIELD(CH2_ADAPT_CAL_CFG, WAITSEL, 14, 2)
    FIELD(CH2_ADAPT_CAL_CFG, MSHIFT, 11, 3)
    FIELD(CH2_ADAPT_CAL_CFG, CAL_INITDAC, 5, 6)
    FIELD(CH2_ADAPT_CAL_CFG, CALSKIP, 4, 1)
    FIELD(CH2_ADAPT_CAL_CFG, TESTCON, 1, 3)
    FIELD(CH2_ADAPT_CAL_CFG, CAL_CFG0, 0, 1)
REG32(CH2_ADAPT_DFE_CFG, 0x38d4)
    FIELD(CH2_ADAPT_DFE_CFG, TRGTCON, 30, 2)
    FIELD(CH2_ADAPT_DFE_CFG, DFE_CFG1, 29, 1)
    FIELD(CH2_ADAPT_DFE_CFG, H3INITDAC, 23, 6)
    FIELD(CH2_ADAPT_DFE_CFG, H2INITDAC, 16, 7)
    FIELD(CH2_ADAPT_DFE_CFG, DFE_CFG0, 15, 1)
    FIELD(CH2_ADAPT_DFE_CFG, UTINITDAC, 7, 8)
    FIELD(CH2_ADAPT_DFE_CFG, VPINITDAC, 0, 7)
REG32(CH2_ADAPT_GC_CFG0, 0x38d8)
    FIELD(CH2_ADAPT_GC_CFG0, GC_CFG01, 31, 1)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_DISFREZ, 30, 1)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_CYCSEL, 28, 2)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_DIFFSEL, 26, 2)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_CLRSEL, 24, 2)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_ENSEL, 22, 2)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_INITDAC, 17, 5)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_SELTGT, 16, 1)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_GEARSEL, 14, 2)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_GAINWIN, 12, 2)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_CNTSEL, 9, 3)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_MSHIFT, 5, 4)
    FIELD(CH2_ADAPT_GC_CFG0, AGC1_WAITSEL, 3, 2)
    FIELD(CH2_ADAPT_GC_CFG0, GC_CFG00, 0, 3)
REG32(CH2_ADAPT_GC_CFG1, 0x38dc)
    FIELD(CH2_ADAPT_GC_CFG1, AGC1_HYSTER, 25, 7)
    FIELD(CH2_ADAPT_GC_CFG1, AGC1_TARGET, 17, 8)
    FIELD(CH2_ADAPT_GC_CFG1, GC_CFG10, 10, 7)
    FIELD(CH2_ADAPT_GC_CFG1, AGC1_UPBDAC, 5, 5)
    FIELD(CH2_ADAPT_GC_CFG1, AGC1_LOBDAC, 0, 5)
REG32(CH2_ADAPT_GC_CFG2, 0x38e0)
    FIELD(CH2_ADAPT_GC_CFG2, GC_CFG22, 31, 1)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_DISFREZ, 30, 1)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_CYCSEL, 28, 2)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_DIFFSEL, 26, 2)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_CLRSEL, 24, 2)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_ENSEL, 22, 2)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_INITDAC, 17, 5)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_SELTGT, 16, 1)
    FIELD(CH2_ADAPT_GC_CFG2, GC_CFG21, 9, 7)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_MSHIFT, 5, 4)
    FIELD(CH2_ADAPT_GC_CFG2, AGC2_WAITSEL, 3, 2)
    FIELD(CH2_ADAPT_GC_CFG2, GC_CFG20, 0, 3)
REG32(CH2_ADAPT_GC_CFG3, 0x38e4)
    FIELD(CH2_ADAPT_GC_CFG3, AGC2_HYSTER, 25, 7)
    FIELD(CH2_ADAPT_GC_CFG3, AGC2_TARGET, 17, 8)
    FIELD(CH2_ADAPT_GC_CFG3, GC_CFG30, 10, 7)
    FIELD(CH2_ADAPT_GC_CFG3, AGC2_UPBDAC, 5, 5)
    FIELD(CH2_ADAPT_GC_CFG3, AGC2_LOBDAC, 0, 5)
REG32(CH2_ADAPT_GEN_CFG0, 0x38e8)
    FIELD(CH2_ADAPT_GEN_CFG0, PCSFLIP, 31, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, BAUDFLIP, 30, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, POWRDN, 29, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, CALCKON, 28, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, GE_CFG00, 27, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, CDRLOCK_DET1_DISLOOP, 26, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, CDRLOCK_DET0_DISLOOP, 25, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, CDRLOCK_DIS_DISLOOP, 24, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, OS_DISLOOP, 23, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, GC2_DISLOOP, 22, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, GC1_DISLOOP, 21, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, KLTUNE_DISLOOP, 20, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, KL_DISLOOP, 19, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, KHCLOAD_DISLOOP, 18, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, KHRDEG_DISLOOP, 17, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, KHCDEG_DISLOOP, 16, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, HF_DISLOOP, 15, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, HE_DISLOOP, 14, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, HD_DISLOOP, 13, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, HC_DISLOOP, 12, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, HB_DISLOOP, 11, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, HA_DISLOOP, 10, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H9_DISLOOP, 9, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H8_DISLOOP, 8, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H7_DISLOOP, 7, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H6_DISLOOP, 6, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H5_DISLOOP, 5, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H4_DISLOOP, 4, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H3_DISLOOP, 3, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, H2_DISLOOP, 2, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, UT_DISLOOP, 1, 1)
    FIELD(CH2_ADAPT_GEN_CFG0, VP_DISLOOP, 0, 1)
REG32(CH2_ADAPT_GEN_CFG1, 0x38ec)
    FIELD(CH2_ADAPT_GEN_CFG1, SELHALF, 31, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, TESTC, 27, 4)
    FIELD(CH2_ADAPT_GEN_CFG1, CDRLOCK_DET1_POWRDN, 26, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, CDRLOCK_DET0_POWRDN, 25, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, CDRLOCK_DIS_POWRDN, 24, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, OS_POWRDN, 23, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, GC2_POWRDN, 22, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, GC1_POWRDN, 21, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, KLTUNE_POWRDN, 20, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, KL_POWRDN, 19, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, KHCLOAD_POWRDN, 18, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, KHRDEG_POWRDN, 17, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, KHCDEG_POWRDN, 16, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, HF_POWRDN, 15, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, HE_POWRDN, 14, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, HD_POWRDN, 13, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, HC_POWRDN, 12, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, HB_POWRDN, 11, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, HA_POWRDN, 10, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H9_POWRDN, 9, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H8_POWRDN, 8, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H7_POWRDN, 7, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H6_POWRDN, 6, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H5_POWRDN, 5, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H4_POWRDN, 4, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H3_POWRDN, 3, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, H2_POWRDN, 2, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, UT_POWRDN, 1, 1)
    FIELD(CH2_ADAPT_GEN_CFG1, VP_POWRDN, 0, 1)
REG32(CH2_ADAPT_GEN_CFG2, 0x38f0)
    FIELD(CH2_ADAPT_GEN_CFG2, APTCTRL2, 31, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, MODSEL, 29, 2)
    FIELD(CH2_ADAPT_GEN_CFG2, SELCDR, 28, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, DISDYN, 27, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, CDRLOCK_DET1_EXHOLD, 26, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, CDRLOCK_DET0_EXHOLD, 25, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, CDRLOCK_DIS_EXHOLD, 24, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, OS_EXHOLD, 23, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, GC2_EXHOLD, 22, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, GC1_EXHOLD, 21, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, KLTUNE_EXHOLD, 20, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, KL_EXHOLD, 19, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, KHCLOAD_EXHOLD, 18, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, KHRDEG_EXHOLD, 17, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, KHCDEG_EXHOLD, 16, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, HF_EXHOLD, 15, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, HE_EXHOLD, 14, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, HD_EXHOLD, 13, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, HC_EXHOLD, 12, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, HB_EXHOLD, 11, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, HA_EXHOLD, 10, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H9_EXHOLD, 9, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H8_EXHOLD, 8, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H7_EXHOLD, 7, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H6_EXHOLD, 6, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H5_EXHOLD, 5, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H4_EXHOLD, 4, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H3_EXHOLD, 3, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, H2_EXHOLD, 2, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, UT_EXHOLD, 1, 1)
    FIELD(CH2_ADAPT_GEN_CFG2, VP_EXHOLD, 0, 1)
REG32(CH2_ADAPT_GEN_CFG3, 0x38f4)
    FIELD(CH2_ADAPT_GEN_CFG3, GEAREN, 31, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, GEARCTRL, 27, 4)
    FIELD(CH2_ADAPT_GEN_CFG3, CDRLOCK_DET1_OVWREN, 26, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, CDRLOCK_DET0_OVWREN, 25, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, CDRLOCK_DIS_OVWREN, 24, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, OS_OVWREN, 23, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, GC2_OVWREN, 22, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, GC1_OVWREN, 21, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, KLTUNE_OVWREN, 20, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, KL_OVWREN, 19, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, KHCLOAD_OVWREN, 18, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, KHRDEG_OVWREN, 17, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, KHCDEG_OVWREN, 16, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, HF_OVWREN, 15, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, HE_OVWREN, 14, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, HD_OVWREN, 13, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, HC_OVWREN, 12, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, HB_OVWREN, 11, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, HA_OVWREN, 10, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H9_OVWREN, 9, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H8_OVWREN, 8, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H7_OVWREN, 7, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H6_OVWREN, 6, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H5_OVWREN, 5, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H4_OVWREN, 4, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H3_OVWREN, 3, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, H2_OVWREN, 2, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, UT_OVWREN, 1, 1)
    FIELD(CH2_ADAPT_GEN_CFG3, VP_OVWREN, 0, 1)
REG32(CH2_ADAPT_H01_CFG, 0x38f8)
    FIELD(CH2_ADAPT_H01_CFG, UT_CFG1, 27, 5)
    FIELD(CH2_ADAPT_H01_CFG, UT_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_H01_CFG, UT_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_H01_CFG, UT_ENSYNC, 20, 1)
    FIELD(CH2_ADAPT_H01_CFG, UT_CFG0, 16, 4)
    FIELD(CH2_ADAPT_H01_CFG, VP_CFG1, 11, 5)
    FIELD(CH2_ADAPT_H01_CFG, VP_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_H01_CFG, VP_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_H01_CFG, VP_ENSYNCH, 4, 1)
    FIELD(CH2_ADAPT_H01_CFG, VP_ENSYNCL, 3, 1)
    FIELD(CH2_ADAPT_H01_CFG, VP_CFG0, 0, 3)
REG32(CH2_ADAPT_H23_CFG, 0x38fc)
    FIELD(CH2_ADAPT_H23_CFG, H3_CFG1, 27, 5)
    FIELD(CH2_ADAPT_H23_CFG, H3_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_H23_CFG, H3_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_H23_CFG, TESTC1, 16, 5)
    FIELD(CH2_ADAPT_H23_CFG, H2_CFG1, 11, 5)
    FIELD(CH2_ADAPT_H23_CFG, H2_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_H23_CFG, H2_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_H23_CFG, TESTC0, 0, 5)
REG32(CH2_ADAPT_H45_CFG, 0x3900)
    FIELD(CH2_ADAPT_H45_CFG, H5_INITDAC, 27, 5)
    FIELD(CH2_ADAPT_H45_CFG, H5_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_H45_CFG, H5_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_H45_CFG, UTCOEFF, 16, 5)
    FIELD(CH2_ADAPT_H45_CFG, H4_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_H45_CFG, H4_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_H45_CFG, H4_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_H45_CFG, TESTC21, 3, 2)
    FIELD(CH2_ADAPT_H45_CFG, TESTC20, 0, 3)
REG32(CH2_ADAPT_H67_CFG, 0x3904)
    FIELD(CH2_ADAPT_H67_CFG, H7_INITDAC, 27, 5)
    FIELD(CH2_ADAPT_H67_CFG, H7_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_H67_CFG, H7_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_H67_CFG, H3COEFF, 16, 5)
    FIELD(CH2_ADAPT_H67_CFG, H6_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_H67_CFG, H6_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_H67_CFG, H6_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_H67_CFG, H2COEFF, 0, 5)
REG32(CH2_ADAPT_H89_CFG, 0x3908)
    FIELD(CH2_ADAPT_H89_CFG, H9_INITDAC, 27, 5)
    FIELD(CH2_ADAPT_H89_CFG, H9_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_H89_CFG, H9_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_H89_CFG, H9_CFG1, 16, 5)
    FIELD(CH2_ADAPT_H89_CFG, H8_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_H89_CFG, H8_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_H89_CFG, H8_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_H89_CFG, H8_CFG1, 0, 5)
REG32(CH2_ADAPT_HAB_CFG, 0x390c)
    FIELD(CH2_ADAPT_HAB_CFG, HB_INITDAC, 27, 5)
    FIELD(CH2_ADAPT_HAB_CFG, HB_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_HAB_CFG, HB_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_HAB_CFG, HB_CFG1, 16, 5)
    FIELD(CH2_ADAPT_HAB_CFG, HA_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_HAB_CFG, HA_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_HAB_CFG, HA_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_HAB_CFG, HA_CFG1, 0, 5)
REG32(CH2_ADAPT_HCD_CFG, 0x3910)
    FIELD(CH2_ADAPT_HCD_CFG, HD_INITDAC, 27, 5)
    FIELD(CH2_ADAPT_HCD_CFG, HD_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_HCD_CFG, HD_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_HCD_CFG, HD_CFG1, 16, 5)
    FIELD(CH2_ADAPT_HCD_CFG, HC_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_HCD_CFG, HC_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_HCD_CFG, HC_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_HCD_CFG, HC_CFG1, 0, 5)
REG32(CH2_ADAPT_HEF_CFG, 0x3914)
    FIELD(CH2_ADAPT_HEF_CFG, HF_INITDAC, 27, 5)
    FIELD(CH2_ADAPT_HEF_CFG, HF_MSHIFT, 23, 4)
    FIELD(CH2_ADAPT_HEF_CFG, HF_WAITSEL, 21, 2)
    FIELD(CH2_ADAPT_HEF_CFG, HE_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_HEF_CFG, HE_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_HEF_CFG, HE_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_HEF_CFG, HE_CFG1, 0, 5)
REG32(CH2_ADAPT_KH_CFG0, 0x3918)
    FIELD(CH2_ADAPT_KH_CFG0, KHCDEG_UTVPRATIO, 24, 8)
    FIELD(CH2_ADAPT_KH_CFG0, KHCDEG_HYSTERSIS, 16, 8)
    FIELD(CH2_ADAPT_KH_CFG0, KHCDEG_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_KH_CFG0, KHCDEG_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_KH_CFG0, WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_KH_CFG0, KH_CFG00, 0, 5)
REG32(CH2_ADAPT_KH_CFG1, 0x391c)
    FIELD(CH2_ADAPT_KH_CFG1, KH_CFG10, 7, 25)
    FIELD(CH2_ADAPT_KH_CFG1, KHCDEG_TARGET, 0, 7)
REG32(CH2_ADAPT_KH_CFG2, 0x3920)
    FIELD(CH2_ADAPT_KH_CFG2, KH_CFG21, 15, 17)
    FIELD(CH2_ADAPT_KH_CFG2, KHRDEG_INITDAC, 11, 4)
    FIELD(CH2_ADAPT_KH_CFG2, KHRDEG_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_KH_CFG2, KHRDEG_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_KH_CFG2, KH_CFG20, 0, 5)
REG32(CH2_ADAPT_KH_CFG3, 0x3924)
REG32(CH2_ADAPT_KH_CFG4, 0x3928)
    FIELD(CH2_ADAPT_KH_CFG4, KH_CFG41, 16, 16)
    FIELD(CH2_ADAPT_KH_CFG4, KHCLOAD_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_KH_CFG4, KHCLOAD_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_KH_CFG4, WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_KH_CFG4, KH_CFG40, 0, 5)
REG32(CH2_ADAPT_KH_CFG5, 0x392c)
REG32(CH2_ADAPT_KL_CFG0, 0x3930)
    FIELD(CH2_ADAPT_KL_CFG0, KL_CFG01, 16, 16)
    FIELD(CH2_ADAPT_KL_CFG0, KL_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_KL_CFG0, KL_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_KL_CFG0, KL_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_KL_CFG0, KL_CFG00, 0, 5)
REG32(CH2_ADAPT_KL_CFG1, 0x3934)
    FIELD(CH2_ADAPT_KL_CFG1, KL_CFG11, 16, 16)
    FIELD(CH2_ADAPT_KL_CFG1, KLTUNE_INITDAC, 11, 5)
    FIELD(CH2_ADAPT_KL_CFG1, KLTUNE_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_KL_CFG1, KLTUNE_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_KL_CFG1, KL_CFG10, 0, 5)
REG32(CH2_ADAPT_LCK_CFG0, 0x3938)
    FIELD(CH2_ADAPT_LCK_CFG0, LCK_CFG0, 30, 2)
    FIELD(CH2_ADAPT_LCK_CFG0, THRD, 24, 6)
    FIELD(CH2_ADAPT_LCK_CFG0, OUTLCKDIS, 23, 1)
    FIELD(CH2_ADAPT_LCK_CFG0, GAIN2, 19, 4)
    FIELD(CH2_ADAPT_LCK_CFG0, GAIN0, 16, 3)
    FIELD(CH2_ADAPT_LCK_CFG0, GAIN1, 12, 4)
    FIELD(CH2_ADAPT_LCK_CFG0, CDRLCK0_INITSEL, 0, 12)
REG32(CH2_ADAPT_LCK_CFG1, 0x393c)
    FIELD(CH2_ADAPT_LCK_CFG1, TESTC, 29, 3)
    FIELD(CH2_ADAPT_LCK_CFG1, ENLOSS, 28, 1)
    FIELD(CH2_ADAPT_LCK_CFG1, ENLCK1, 27, 1)
    FIELD(CH2_ADAPT_LCK_CFG1, ENLCK0, 26, 1)
    FIELD(CH2_ADAPT_LCK_CFG1, LCK_CFG10, 21, 5)
    FIELD(CH2_ADAPT_LCK_CFG1, FORCELOW, 20, 1)
    FIELD(CH2_ADAPT_LCK_CFG1, SELCON, 17, 3)
    FIELD(CH2_ADAPT_LCK_CFG1, DETECTEN, 16, 1)
    FIELD(CH2_ADAPT_LCK_CFG1, LCKCTRVAL, 12, 4)
    FIELD(CH2_ADAPT_LCK_CFG1, LOSSSEL, 0, 12)
REG32(CH2_ADAPT_LCK_CFG2, 0x3940)
    FIELD(CH2_ADAPT_LCK_CFG2, LCK_CFG20, 25, 7)
    FIELD(CH2_ADAPT_LCK_CFG2, FIX_PPM, 24, 1)
    FIELD(CH2_ADAPT_LCK_CFG2, TESTCON, 20, 4)
    FIELD(CH2_ADAPT_LCK_CFG2, UD_CYCLEU, 16, 4)
    FIELD(CH2_ADAPT_LCK_CFG2, UD_CYCLEL, 0, 16)
REG32(CH2_ADAPT_LCK_CFG3, 0x3944)
REG32(CH2_ADAPT_LOP_CFG, 0x3948)
    FIELD(CH2_ADAPT_LOP_CFG, ENDNOD, 29, 3)
    FIELD(CH2_ADAPT_LOP_CFG, PREVSEL, 25, 4)
    FIELD(CH2_ADAPT_LOP_CFG, DFEOSWTX, 22, 3)
    FIELD(CH2_ADAPT_LOP_CFG, DFEOSWTY, 19, 3)
    FIELD(CH2_ADAPT_LOP_CFG, SWCLKP1, 18, 1)
    FIELD(CH2_ADAPT_LOP_CFG, SWCLKP0, 17, 1)
    FIELD(CH2_ADAPT_LOP_CFG, SELWIDTH, 16, 1)
    FIELD(CH2_ADAPT_LOP_CFG, DRP_WIDTH, 13, 3)
    FIELD(CH2_ADAPT_LOP_CFG, NEXTDC, 12, 1)
    FIELD(CH2_ADAPT_LOP_CFG, INVTBIT, 11, 1)
    FIELD(CH2_ADAPT_LOP_CFG, SWCLKSEL, 9, 2)
    FIELD(CH2_ADAPT_LOP_CFG, LOP_CFG0, 7, 2)
    FIELD(CH2_ADAPT_LOP_CFG, BLKOUTC, 5, 2)
    FIELD(CH2_ADAPT_LOP_CFG, DUL_TESTCON, 0, 5)
REG32(CH2_ADAPT_OS_CFG, 0x394c)
    FIELD(CH2_ADAPT_OS_CFG, OS_INITDAC, 25, 7)
    FIELD(CH2_ADAPT_OS_CFG, OS_CFG1, 11, 14)
    FIELD(CH2_ADAPT_OS_CFG, OS_MSHIFT, 7, 4)
    FIELD(CH2_ADAPT_OS_CFG, OS_WAITSEL, 5, 2)
    FIELD(CH2_ADAPT_OS_CFG, OS_CFG0, 0, 5)
REG32(CH2_RX_CRC_CFG0, 0x3950)
    FIELD(CH2_RX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH2_RX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH2_RX_CRC_CFG0, CORRECTION_EN, 7, 1)
    FIELD(CH2_RX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH2_RX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH2_RX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH2_RX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH2_RX_CRC_CFG0, INPUT_BYTE_ORDER, 1, 1)
    FIELD(CH2_RX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH2_RX_CRC_CFG1, 0x3954)
REG32(CH2_RX_CRC_CFG2, 0x3958)
REG32(CH2_RX_CRC_CFG3, 0x395c)
REG32(CH2_TX_CRC_CFG0, 0x3960)
    FIELD(CH2_TX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH2_TX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH2_TX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH2_TX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH2_TX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH2_TX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH2_TX_CRC_CFG0, OUTPUT_BYTE_ORDER, 1, 1)
    FIELD(CH2_TX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH2_TX_CRC_CFG1, 0x3964)
REG32(CH2_TX_CRC_CFG2, 0x3968)
REG32(CH2_TX_CRC_CFG3, 0x396c)
REG32(CH2_DA_CFG, 0x3970)
    FIELD(CH2_DA_CFG, TX_DA_AMP_CTRL_FORCE, 31, 1)
    FIELD(CH2_DA_CFG, TX_DA_AMP_CTRL, 27, 4)
    FIELD(CH2_DA_CFG, TX_DA_SPARE, 20, 7)
    FIELD(CH2_DA_CFG, TX_DA_REFCLK_SEL, 19, 1)
    FIELD(CH2_DA_CFG, TX_DA_RANGE, 18, 1)
    FIELD(CH2_DA_CFG, TX_DA_ENOUT, 17, 1)
    FIELD(CH2_DA_CFG, TX_DA_PWRDNB, 16, 1)
    FIELD(CH2_DA_CFG, RX_DA_AMP_CTRL_FORCE, 15, 1)
    FIELD(CH2_DA_CFG, RX_DA_AMP_CTRL, 11, 4)
    FIELD(CH2_DA_CFG, RX_DA_SPARE, 4, 7)
    FIELD(CH2_DA_CFG, RX_DA_REFCLK_SEL, 3, 1)
    FIELD(CH2_DA_CFG, RX_DA_RANGE, 2, 1)
    FIELD(CH2_DA_CFG, RX_DA_ENOUT, 1, 1)
    FIELD(CH2_DA_CFG, RX_DA_PWRDNB, 0, 1)
REG32(CH2_RX_CTLE_CFG0, 0x3974)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE1_PWRDN, 31, 1)
    FIELD(CH2_RX_CTLE_CFG0, RX_AGC1_CM_REF, 28, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE1_CM_REF, 25, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_AGC2_OCAP_CTRL, 22, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC2_OCAP, 21, 1)
    FIELD(CH2_RX_CTLE_CFG0, RX_AGC1_OCAP_CTRL, 18, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE_TUNE_OS, 16, 2)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC1_OCAP, 15, 1)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE_CL_CAP_CTRL, 12, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE_CS_CAPCTRL, 9, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE_BIAS_CTRL, 6, 3)
    FIELD(CH2_RX_CTLE_CFG0, RX_AGC2_LOW_PWR, 4, 2)
    FIELD(CH2_RX_CTLE_CFG0, RX_AGC1_LOW_PWR, 2, 2)
    FIELD(CH2_RX_CTLE_CFG0, RX_CTLE1_LOW_PWR, 0, 2)
REG32(CH2_RX_CTLE_CFG1, 0x3978)
    FIELD(CH2_RX_CTLE_CFG1, SWCLK_ELVL_OPT, 26, 1)
    FIELD(CH2_RX_CTLE_CFG1, BRCDR_VP_OPT, 25, 1)
    FIELD(CH2_RX_CTLE_CFG1, RCAL_OS_PAD, 19, 6)
    FIELD(CH2_RX_CTLE_CFG1, RX_AGC2_CURR_GAIN, 16, 3)
    FIELD(CH2_RX_CTLE_CFG1, RX_AGC1_CURR_GAIN, 13, 3)
    FIELD(CH2_RX_CTLE_CFG1, RX_CTLE1_CURR_GAIN, 10, 3)
    FIELD(CH2_RX_CTLE_CFG1, RX_AGC2_PWRDN, 9, 1)
    FIELD(CH2_RX_CTLE_CFG1, RX_AGC1_PWRDN, 8, 1)
    FIELD(CH2_RX_CTLE_CFG1, RX_CTLE_OS_PWRDN, 7, 1)
    FIELD(CH2_RX_CTLE_CFG1, RX_CTLE_SAP_SEL, 3, 4)
    FIELD(CH2_RX_CTLE_CFG1, RX_AGC2_CM_REF, 0, 3)
REG32(CH2_RX_DACI2V_CFG0, 0x397c)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_PD_BIAS_OS, 28, 1)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_PD_BIAS_DFE, 27, 1)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_VP_RANGE, 25, 2)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_VS_CODE, 18, 7)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_VS_NEG, 17, 1)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_VS_UT_SIGN, 16, 1)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_SEL_I2V_VCM, 13, 3)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_CFOK_RANGE, 11, 2)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_CFOK_EN, 10, 1)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_FILTER_EN, 9, 1)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_VS_RANGE, 7, 2)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_BIAS_DFE, 5, 2)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_BIAS_I2V, 3, 2)
    FIELD(CH2_RX_DACI2V_CFG0, DAC_BIAS_OS, 1, 2)
    FIELD(CH2_RX_DACI2V_CFG0, SUMMER_VCM_TESTMODE, 0, 1)
REG32(CH2_RX_DFE_CFG0, 0x3980)
    FIELD(CH2_RX_DFE_CFG0, RX_DFE_YEN, 31, 1)
    FIELD(CH2_RX_DFE_CFG0, RX_VREG_PDB, 30, 1)
    FIELD(CH2_RX_DFE_CFG0, RX_VREG_VREFSEL, 28, 2)
    FIELD(CH2_RX_DFE_CFG0, RX_DES_CFG_BITS, 18, 10)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_EN_VCM_EVEN, 17, 1)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_LOW_POWER, 16, 1)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_VCM_TUNE, 12, 4)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_VCM_TUNE_OVWR, 11, 1)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_VREF_TUNE, 8, 3)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_IREF_TUNE, 4, 4)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_DEG_CTRL, 1, 3)
    FIELD(CH2_RX_DFE_CFG0, RX_SUM_DEG_AVTT_OVWR, 0, 1)
REG32(CH2_RX_MISC_CFG0, 0x3984)
    FIELD(CH2_RX_MISC_CFG0, RX_VREG_CTRL, 28, 3)
    FIELD(CH2_RX_MISC_CFG0, RCAL_OS_CTLE, 22, 6)
    FIELD(CH2_RX_MISC_CFG0, RCAL_OS_AGC1, 16, 6)
    FIELD(CH2_RX_MISC_CFG0, SLICER_SARC_DIS, 15, 1)
    FIELD(CH2_RX_MISC_CFG0, RCAL_OS_AGC2, 9, 6)
    FIELD(CH2_RX_MISC_CFG0, RCAL_OS_SUM, 3, 6)
    FIELD(CH2_RX_MISC_CFG0, RX_LPM_EN, 2, 1)
    FIELD(CH2_RX_MISC_CFG0, BAUDRATE_MODE, 1, 1)
    FIELD(CH2_RX_MISC_CFG0, RX_XMODE_SEL, 0, 1)
REG32(CH2_CHL_RSV_CFG1, 0x3988)
REG32(CH2_RX_PAD_CFG0, 0x398c)
    FIELD(CH2_RX_PAD_CFG0, LS_CTRL, 17, 15)
    FIELD(CH2_RX_PAD_CFG0, ACCAP_CMRES_EN, 16, 1)
    FIELD(CH2_RX_PAD_CFG0, ACCAP_CFG, 13, 3)
    FIELD(CH2_RX_PAD_CFG0, LSHIFT_EN, 12, 1)
    FIELD(CH2_RX_PAD_CFG0, ACCAP_EN, 11, 1)
    FIELD(CH2_RX_PAD_CFG0, RX_PAD_CFG0_SPARE, 0, 11)
REG32(CH2_RX_PAD_CFG1, 0x3990)
    FIELD(CH2_RX_PAD_CFG1, RX_PAD_CFG1_SPARE, 30, 2)
    FIELD(CH2_RX_PAD_CFG1, RX_PKDET_EN, 29, 1)
    FIELD(CH2_RX_PAD_CFG1, RX_PKDET_CTRL, 25, 4)
    FIELD(CH2_RX_PAD_CFG1, OOB_VDIFF_INV, 24, 1)
    FIELD(CH2_RX_PAD_CFG1, OOB_SIG_VDIFF_SEL, 21, 3)
    FIELD(CH2_RX_PAD_CFG1, OOB_OVERRIDE, 19, 2)
    FIELD(CH2_RX_PAD_CFG1, OOB_PWRDN_B, 18, 1)
    FIELD(CH2_RX_PAD_CFG1, ACJTAG_EN, 17, 1)
    FIELD(CH2_RX_PAD_CFG1, QPI_EN, 16, 1)
    FIELD(CH2_RX_PAD_CFG1, MNTR_ACJTAG_EN, 15, 1)
    FIELD(CH2_RX_PAD_CFG1, ACJTAG_VD_SEL0, 14, 1)
    FIELD(CH2_RX_PAD_CFG1, ACJTAG_VC_SEL0, 13, 1)
    FIELD(CH2_RX_PAD_CFG1, MNTR_ACJTAG_RESETB, 12, 1)
    FIELD(CH2_RX_PAD_CFG1, MNTR_ACJTAG_ACMODE, 11, 1)
    FIELD(CH2_RX_PAD_CFG1, PROG_OPAMPPD_EN, 10, 1)
    FIELD(CH2_RX_PAD_CFG1, CM_BUFF_CFG, 6, 4)
    FIELD(CH2_RX_PAD_CFG1, RTERM_VCOM_MODE, 4, 2)
    FIELD(CH2_RX_PAD_CFG1, RTERM_VCOM_LVL, 0, 4)
REG32(CH2_RX_PCS_CFG0, 0x3994)
    FIELD(CH2_RX_PCS_CFG0, RX_ALIGN_MCOMMA_DET, 31, 1)
    FIELD(CH2_RX_PCS_CFG0, RX_ALIGN_PCOMMA_DET, 30, 1)
    FIELD(CH2_RX_PCS_CFG0, RX_ALIGN_MCOMMA_VAL, 20, 10)
    FIELD(CH2_RX_PCS_CFG0, RX_ALIGN_PCOMMA_VAL, 10, 10)
    FIELD(CH2_RX_PCS_CFG0, RX_INT_DATA_WIDTH, 7, 2)
    FIELD(CH2_RX_PCS_CFG0, RX_DATA_WIDTH, 3, 4)
    FIELD(CH2_RX_PCS_CFG0, RX_MCOMMA_ALIGNEN, 2, 1)
    FIELD(CH2_RX_PCS_CFG0, RX_PCOMMA_ALIGNEN, 1, 1)
    FIELD(CH2_RX_PCS_CFG0, RX_COMMADETEN, 0, 1)
REG32(CH2_RX_PCS_CFG1, 0x3998)
    FIELD(CH2_RX_PCS_CFG1, RX_FABRIC_DATA_SEL, 29, 3)
    FIELD(CH2_RX_PCS_CFG1, RX_FIFO_DATA_SEL, 26, 3)
    FIELD(CH2_RX_PCS_CFG1, RX_SIG_VALID_DLY, 21, 5)
    FIELD(CH2_RX_PCS_CFG1, RX_SLIDE_MODE, 19, 2)
    FIELD(CH2_RX_PCS_CFG1, RX_SHOW_REALIGN_COMMA, 18, 1)
    FIELD(CH2_RX_PCS_CFG1, RX_SLIDE_AUTO_WAIT, 14, 4)
    FIELD(CH2_RX_PCS_CFG1, RX_ALIGN_COMMA_WORD, 11, 3)
    FIELD(CH2_RX_PCS_CFG1, RX_ALIGN_COMMA_DOUBLE, 10, 1)
    FIELD(CH2_RX_PCS_CFG1, RX_ALIGN_COMMA_ENABLE, 0, 10)
REG32(CH2_RX_PCS_CFG2, 0x399c)
    FIELD(CH2_RX_PCS_CFG2, PCIE_USB_ERR_REP_DIS, 31, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_PHASE_BUFFER_USE, 30, 1)
    FIELD(CH2_RX_PCS_CFG2, RXBUF_RD_INIT_ADDR, 27, 3)
    FIELD(CH2_RX_PCS_CFG2, RXBUF_RXUSRCLK_REG_BYPASS, 26, 1)
    FIELD(CH2_RX_PCS_CFG2, RXBUF_ADDR_CFG, 25, 1)
    FIELD(CH2_RX_PCS_CFG2, START_SKP_SEL, 24, 1)
    FIELD(CH2_RX_PCS_CFG2, SIGVALID_EN_FOR_RXVALID, 23, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_EIEOS_PATTERN_SEL, 21, 2)
    FIELD(CH2_RX_PCS_CFG2, RX_BLKSYNC_MCP, 20, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_BLKSYNC_FTS, 19, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_CBCC_DATA_SEL, 18, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_DEC_VALID_COMMA, 17, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_DEC_MCOMMA_DET, 16, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_DEC_PCOMMA_DET, 15, 1)
    FIELD(CH2_RX_PCS_CFG2, RX_8B10B_EN, 14, 1)
    FIELD(CH2_RX_PCS_CFG2, EIOS_ERR_MASK_DIS, 13, 1)
    FIELD(CH2_RX_PCS_CFG2, SAMPLE_PERIOD, 10, 3)
    FIELD(CH2_RX_PCS_CFG2, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH2_RX_PCS_CFG2, USE_GB, 5, 1)
    FIELD(CH2_RX_PCS_CFG2, MODE, 0, 5)
REG32(CH2_RX_PCS_CFG3, 0x39a0)
    FIELD(CH2_RX_PCS_CFG3, RX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH2_RX_PCS_CFG3, RX_FIFO_STATUS_SEL, 30, 1)
    FIELD(CH2_RX_PCS_CFG3, DATA_RATE, 29, 1)
    FIELD(CH2_RX_PCS_CFG3, DATAPATH_CTRL, 26, 3)
    FIELD(CH2_RX_PCS_CFG3, CLAUSE_CTRL, 25, 1)
    FIELD(CH2_RX_PCS_CFG3, TEST_PATT_EN, 24, 1)
    FIELD(CH2_RX_PCS_CFG3, TESTDATA_PATT_SEL, 23, 1)
    FIELD(CH2_RX_PCS_CFG3, RXVALID_FORCE_RXVAL_COMDET, 20, 1)
    FIELD(CH2_RX_PCS_CFG3, RXVALID_EIOS_RESET_EN, 19, 1)
    FIELD(CH2_RX_PCS_CFG3, RXPHCLK_CYCLE_CNT_EN, 17, 1)
    FIELD(CH2_RX_PCS_CFG3, RXPRBS_LEAKYBUCKET_EN, 16, 1)
    FIELD(CH2_RX_PCS_CFG3, RXPRBS_LINK2RESEED_CNT, 8, 8)
    FIELD(CH2_RX_PCS_CFG3, RXPRBS_LINKACQ_CNT, 0, 8)
REG32(CH2_RX_PCS_CFG4, 0x39a4)
    FIELD(CH2_RX_PCS_CFG4, RXVALID_GEN_EN, 31, 1)
    FIELD(CH2_RX_PCS_CFG4, RXVALID_FORCE_SIGVALID, 30, 1)
    FIELD(CH2_RX_PCS_CFG4, RXVALID_K_NUM, 20, 10)
    FIELD(CH2_RX_PCS_CFG4, RXVALID_GOOD_DATA_NUM, 10, 10)
    FIELD(CH2_RX_PCS_CFG4, RXVALID_ERR_DATA_NUM, 0, 10)
REG32(CH2_CHCLK_MISC_CFG, 0x39a8)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_MONCLKCYCLE, 28, 3)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_PWRDNB, 27, 1)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_UNLOCKCTRL, 25, 2)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OW, 17, 8)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_FINE_SWEEP, 15, 2)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_ILOLOCKCOARSE, 13, 2)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_ILOLOCKFACTOR, 11, 2)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_PLLLOCKDETEN, 10, 1)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_CRS_ACCURACY, 8, 2)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_OVRD_MODE, 6, 2)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OWEN, 5, 1)
    FIELD(CH2_CHCLK_MISC_CFG, CHCLK_FBDIV_VAL, 0, 5)
REG32(CH2_CHCLK_ILO_CFG, 0x39ac)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OW, 28, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OWEN, 27, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OW, 26, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OWEN, 25, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OW, 24, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OWEN, 23, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OW, 21, 2)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OWEN, 20, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_ILO_MODE_SPD, 19, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_CLKSRCMUX_SEL, 18, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_FTL_TUNE_OWEN, 16, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_VREG_CTRL, 12, 3)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_VCTRL_OW, 6, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_BIAS, 5, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_VCTRL_EXT, 4, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_VBUF, 2, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_FTL, 1, 1)
    FIELD(CH2_CHCLK_ILO_CFG, CHCLK_PDB_VREG, 0, 1)
REG32(CH2_CHCLK_RXPI_CFG, 0x39b0)
    FIELD(CH2_CHCLK_RXPI_CFG, PROGDIV_RX_DIV_PDB, 22, 1)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_STEP_BYP_EN, 21, 1)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_STEP_TWO_EN, 20, 1)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_SEL_VREG_SENSE, 19, 1)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_VREG_CTRL, 16, 3)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_BAND_SEL, 4, 2)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_S_PREBUF_EN, 3, 1)
    FIELD(CH2_CHCLK_RXPI_CFG, RXPI_PREBUF_EN, 2, 1)
REG32(CH2_CHCLK_RXCAL_CFG, 0x39b4)
    FIELD(CH2_CHCLK_RXCAL_CFG, DMON_SEL, 28, 4)
    FIELD(CH2_CHCLK_RXCAL_CFG, AUTO_MODE, 27, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, TWAIT_SEL, 25, 2)
    FIELD(CH2_CHCLK_RXCAL_CFG, CLKDIV_SEL, 22, 3)
    FIELD(CH2_CHCLK_RXCAL_CFG, TCYC_PER_CAL, 20, 2)
    FIELD(CH2_CHCLK_RXCAL_CFG, TEVAL_SEL, 18, 2)
    FIELD(CH2_CHCLK_RXCAL_CFG, TOS_SEL, 16, 2)
    FIELD(CH2_CHCLK_RXCAL_CFG, HYST_MODE, 14, 2)
    FIELD(CH2_CHCLK_RXCAL_CFG, DMON_EN, 13, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, RX_CAL_PD, 12, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, OVERRIDE_CODE_IDX, 9, 3)
    FIELD(CH2_CHCLK_RXCAL_CFG, FLIP_DIR_ANY, 8, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_RXPAD_OS, 7, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_AGC2_CM, 6, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_AGC1_CM, 5, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_CTLE_CM, 4, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_RXDCD_S, 3, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_RXDCD_X, 2, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG, SKIP_RXDCD_D, 1, 1)
REG32(CH2_CHCLK_RXCAL_CFG1, 0x39b8)
    FIELD(CH2_CHCLK_RXCAL_CFG1, OVERRIDE_EN, 7, 1)
    FIELD(CH2_CHCLK_RXCAL_CFG1, OVERRIDE_CODE, 0, 7)
REG32(CH2_CHCLK_TXPI_CFG0, 0x39bc)
    FIELD(CH2_CHCLK_TXPI_CFG0, RSVD, 22, 10)
    FIELD(CH2_CHCLK_TXPI_CFG0, SARC_EN, 21, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_STEP_BYP_EN, 20, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TX_PROGCLK_SEL, 18, 2)
    FIELD(CH2_CHCLK_TXPI_CFG0, PROGDIV_TX_DIV_PDB, 17, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_STEP_TWO_EN, 16, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_BAND_SEL, 4, 2)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_PREBUF_EN, 3, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_BYPASS, 2, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TXPI_BYPASSMUX_PDB, 1, 1)
    FIELD(CH2_CHCLK_TXPI_CFG0, TX_PLLCLK_SEL, 0, 1)
REG32(CH2_CHCLK_TXCAL_CFG, 0x39c0)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_EXHOLD, 26, 1)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_OVWREN, 25, 1)
    FIELD(CH2_CHCLK_TXCAL_CFG, TXCLK_TXCAL_FORCEREADY, 24, 1)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TIGHT, 23, 1)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_INITDAC, 16, 7)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACWIN, 14, 2)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACCHECK, 12, 2)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_THRESHSEL, 10, 2)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_MULSEL, 7, 3)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_FLIPDIR, 6, 1)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_CALEN, 5, 1)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTSEL, 1, 4)
    FIELD(CH2_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTEN, 0, 1)
REG32(CH2_CHCLK_RXCAL_CFG2, 0x39c4)
REG32(CH2_CHCLK_RSV_CFG, 0x39c8)
REG32(CH2_PIPE_TX_EQ_CFG0, 0x39cc)
    FIELD(CH2_PIPE_TX_EQ_CFG0, TX_MAINCURSOR_SEL, 30, 1)
    FIELD(CH2_PIPE_TX_EQ_CFG0, TX_DRIVE_MODE, 28, 2)
    FIELD(CH2_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_3, 21, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_2, 14, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_1, 7, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_0, 0, 7)
REG32(CH2_PIPE_TX_EQ_CFG1, 0x39d0)
    FIELD(CH2_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_2, 21, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_1, 14, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_0, 7, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG1, TX_MARGIN_FULL_4, 0, 7)
REG32(CH2_PIPE_TX_EQ_CFG2, 0x39d4)
    FIELD(CH2_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_4, 7, 7)
    FIELD(CH2_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_3, 0, 7)
REG32(CH2_PIPE_TX_EQ_CFG3, 0x39d8)
    FIELD(CH2_PIPE_TX_EQ_CFG3, TX_DEEMPH_3, 15, 5)
    FIELD(CH2_PIPE_TX_EQ_CFG3, TX_DEEMPH_2, 10, 5)
    FIELD(CH2_PIPE_TX_EQ_CFG3, TX_DEEMPH_1, 5, 5)
    FIELD(CH2_PIPE_TX_EQ_CFG3, TX_DEEMPH_0, 0, 5)
REG32(CH2_TX_PCS_CFG0, 0x39dc)
    FIELD(CH2_TX_PCS_CFG0, TX_PMA_DATA_SEL, 29, 3)
    FIELD(CH2_TX_PCS_CFG0, TXPMA_WIDTH_OVRD, 26, 3)
    FIELD(CH2_TX_PCS_CFG0, TX_INT_DATA_WIDTH, 24, 2)
    FIELD(CH2_TX_PCS_CFG0, TX_DATA_WIDTH, 20, 4)
    FIELD(CH2_TX_PCS_CFG0, TX_IDLE_DATA_ZERO, 19, 1)
    FIELD(CH2_TX_PCS_CFG0, TXPMA_WIDTH_OVRD_EN, 18, 1)
    FIELD(CH2_TX_PCS_CFG0, TX_8B10B_EN, 17, 1)
    FIELD(CH2_TX_PCS_CFG0, TX_8B10B_BYPASS, 13, 4)
    FIELD(CH2_TX_PCS_CFG0, SAMPLE_PERIOD, 10, 3)
    FIELD(CH2_TX_PCS_CFG0, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH2_TX_PCS_CFG0, USE_GB, 5, 1)
    FIELD(CH2_TX_PCS_CFG0, MODE, 0, 5)
REG32(CH2_TX_PCS_CFG1, 0x39e0)
    FIELD(CH2_TX_PCS_CFG1, TX_PRBS_FORCE_MODE, 31, 1)
    FIELD(CH2_TX_PCS_CFG1, RXPRBS_ERR_LOOPBACK, 30, 1)
    FIELD(CH2_TX_PCS_CFG1, TX_PRBS_USERPATTERN2, 20, 10)
    FIELD(CH2_TX_PCS_CFG1, TX_PRBS_USERPATTERN1, 10, 10)
    FIELD(CH2_TX_PCS_CFG1, TX_PRBS_USERPATTERN0, 0, 10)
REG32(CH2_TX_PCS_CFG2, 0x39e4)
    FIELD(CH2_TX_PCS_CFG2, TX_FIFO_STATUS_SEL, 31, 1)
    FIELD(CH2_TX_PCS_CFG2, TX_PRBS_USERPATTERN5, 20, 10)
    FIELD(CH2_TX_PCS_CFG2, TX_PRBS_USERPATTERN4, 10, 10)
    FIELD(CH2_TX_PCS_CFG2, TX_PRBS_USERPATTERN3, 0, 10)
REG32(CH2_TX_PCS_CFG3, 0x39e8)
    FIELD(CH2_TX_PCS_CFG3, TX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH2_TX_PCS_CFG3, TXBUF_TXPCSCLK_REG_BYPASS, 30, 1)
    FIELD(CH2_TX_PCS_CFG3, USB_LFPS_TPERIOD_ACCURATE, 29, 1)
    FIELD(CH2_TX_PCS_CFG3, USB_LFPS_TPERIOD, 25, 4)
    FIELD(CH2_TX_PCS_CFG3, TXBUF_WR_INIT_ADDR, 22, 3)
    FIELD(CH2_TX_PCS_CFG3, TXBUF_ADDR_CFG, 21, 1)
    FIELD(CH2_TX_PCS_CFG3, TX_PHASE_BUFFER_USE, 20, 1)
    FIELD(CH2_TX_PCS_CFG3, TX_PRBS_USERPATTERN7, 10, 10)
    FIELD(CH2_TX_PCS_CFG3, TX_PRBS_USERPATTERN6, 0, 10)
REG32(CH2_EYESCAN_CFG0, 0x39ec)
    FIELD(CH2_EYESCAN_CFG0, ES_SWAP_EN, 25, 1)
    FIELD(CH2_EYESCAN_CFG0, ES_ERRDET_EN, 24, 1)
    FIELD(CH2_EYESCAN_CFG0, ES_EYE_SCAN_EN, 23, 1)
    FIELD(CH2_EYESCAN_CFG0, ES_CONTROL, 17, 6)
    FIELD(CH2_EYESCAN_CFG0, ES_PRESCALE, 12, 5)
    FIELD(CH2_EYESCAN_CFG0, ES_HORZ_OFFSET, 0, 12)
REG32(CH2_EYESCAN_CFG1, 0x39f0)
REG32(CH2_EYESCAN_CFG2, 0x39f4)
REG32(CH2_EYESCAN_CFG3, 0x39f8)
REG32(CH2_EYESCAN_CFG4, 0x39fc)
REG32(CH2_EYESCAN_CFG5, 0x3a00)
REG32(CH2_EYESCAN_CFG6, 0x3a04)
REG32(CH2_EYESCAN_CFG7, 0x3a08)
REG32(CH2_EYESCAN_CFG8, 0x3a0c)
REG32(CH2_EYESCAN_CFG9, 0x3a10)
REG32(CH2_EYESCAN_CFG10, 0x3a14)
REG32(CH2_EYESCAN_CFG11, 0x3a18)
REG32(CH2_EYESCAN_CFG12, 0x3a1c)
REG32(CH2_EYESCAN_CFG13, 0x3a20)
REG32(CH2_EYESCAN_CFG14, 0x3a24)
REG32(CH2_EYESCAN_CFG15, 0x3a28)
REG32(CH2_EYESCAN_CFG16, 0x3a2c)
    FIELD(CH2_EYESCAN_CFG16, RXPMA_WIDTH_OVRD_EN, 31, 1)
    FIELD(CH2_EYESCAN_CFG16, RXPMA_ADAP_WIDTH_OVRD, 27, 4)
    FIELD(CH2_EYESCAN_CFG16, RXPMA_CDR_WIDTH_OVRD, 23, 4)
    FIELD(CH2_EYESCAN_CFG16, RXPMA_DES_WIDTH_OVRD, 19, 4)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SAMPLE, 15, 1)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL2, 14, 1)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL, 13, 1)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_VS_UT_SIGN, 12, 1)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_VS_RANGE, 10, 2)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_VS_NEG_DIR, 9, 1)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_VS_CODE, 2, 7)
    FIELD(CH2_EYESCAN_CFG16, EYESCAN_VP_RANGE, 0, 2)
REG32(CH2_RX_ELASTIC_BUF_CFG0, 0x3a30)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_THRESH_OVRD, 31, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_REPEAT_WAIT, 26, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_UDFL_THRESH, 20, 6)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_OVFL_THRESH, 14, 6)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MAX_LAT, 8, 6)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MIN_LAT, 2, 6)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_USE, 1, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG0, ELASTICBUF_8B10B_EN, 0, 1)
REG32(CH2_TX_10G_CFG0, 0x3a34)
REG32(CH2_TX_10G_CFG1, 0x3a38)
    FIELD(CH2_TX_10G_CFG1, DATAPATH_CTRL, 29, 2)
    FIELD(CH2_TX_10G_CFG1, TEST_PATT_EN, 28, 1)
    FIELD(CH2_TX_10G_CFG1, TEST_PATT_SEL, 27, 1)
    FIELD(CH2_TX_10G_CFG1, TESTDATA_PATT_SEL, 26, 1)
    FIELD(CH2_TX_10G_CFG1, TEST_PATT_SEEDA, 0, 26)
REG32(CH2_TX_10G_CFG2, 0x3a3c)
REG32(CH2_TX_10G_CFG3, 0x3a40)
    FIELD(CH2_TX_10G_CFG3, TEST_PATT_SEEDB, 0, 26)
REG32(CH2_RX_PHALIGN_CFG0, 0x3a44)
    FIELD(CH2_RX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH2_RX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH2_RX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH2_RX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH2_RX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH2_RX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH2_RX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH2_RX_PHALIGN_CFG0, RXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH2_RX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH2_RX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH2_RX_PHALIGN_CFG0, ALIGN_DMON_SEL, 5, 5)
    FIELD(CH2_RX_PHALIGN_CFG0, DA_WAIT_CYCLES, 0, 5)
REG32(CH2_RX_PHALIGN_CFG1, 0x3a48)
    FIELD(CH2_RX_PHALIGN_CFG1, SETINIT_PH_CNT, 27, 5)
    FIELD(CH2_RX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH2_RX_PHALIGN_CFG1, NUM_SAMPLES, 15, 5)
    FIELD(CH2_RX_PHALIGN_CFG1, SAMPLE_WAIT, 13, 2)
    FIELD(CH2_RX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 6, 7)
    FIELD(CH2_RX_PHALIGN_CFG1, MIN_THRESHOLD_OVRD, 5, 1)
    FIELD(CH2_RX_PHALIGN_CFG1, MAX_THRESHOLD_OVRD, 4, 1)
    FIELD(CH2_RX_PHALIGN_CFG1, CHAIN_MODE, 2, 2)
    FIELD(CH2_RX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 1, 1)
    FIELD(CH2_RX_PHALIGN_CFG1, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH2_RX_PHALIGN_CFG2, 0x3a4c)
    FIELD(CH2_RX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH2_RX_PHALIGN_CFG2, SLIP_EN_WID_PRE, 21, 4)
    FIELD(CH2_RX_PHALIGN_CFG2, SLIP_EN_WID_POST, 17, 4)
    FIELD(CH2_RX_PHALIGN_CFG2, SLIP_PULSE_WID_HI, 13, 4)
    FIELD(CH2_RX_PHALIGN_CFG2, SLIP_PULSE_WID_LO, 9, 4)
    FIELD(CH2_RX_PHALIGN_CFG2, SLIP_PULSE_SETTLE, 5, 4)
REG32(CH2_RX_PHALIGN_CFG3, 0x3a50)
    FIELD(CH2_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_CNT, 27, 5)
    FIELD(CH2_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH2_RX_PHALIGN_CFG3, MLDLY_NUM_SAMPLES, 15, 5)
    FIELD(CH2_RX_PHALIGN_CFG3, MLDLY_MIN_THRESHOLD_OVRD, 14, 1)
    FIELD(CH2_RX_PHALIGN_CFG3, MLDLY_MAX_THRESHOLD_OVRD, 13, 1)
    FIELD(CH2_RX_PHALIGN_CFG3, MLDLY_SAMPLE_WAIT, 11, 2)
    FIELD(CH2_RX_PHALIGN_CFG3, DAPICODE_OVRD, 3, 8)
    FIELD(CH2_RX_PHALIGN_CFG3, DMON_CLK_SEL, 0, 2)
REG32(CH2_RX_PHALIGN_CFG4, 0x3a54)
    FIELD(CH2_RX_PHALIGN_CFG4, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH2_RX_PHALIGN_CFG4, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH2_RX_PHALIGN_CFG4, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH2_RX_PHALIGN_CFG4, FINE_ALIGN_BYPASS, 12, 1)
    FIELD(CH2_RX_PHALIGN_CFG4, CLKSLIP_PAR_SAMPLES, 10, 2)
    FIELD(CH2_RX_PHALIGN_CFG4, CLKSLIP_NUM_SAMPLES, 5, 5)
    FIELD(CH2_RX_PHALIGN_CFG4, CLKSLIP_SAMPLES_WAIT, 0, 5)
REG32(CH2_RX_PHALIGN_CFG5, 0x3a58)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_UP_DOWN, 28, 2)
    FIELD(CH2_RX_PHALIGN_CFG5, CMN_FAB_CLK_PHALIGN_MODE, 26, 2)
    FIELD(CH2_RX_PHALIGN_CFG5, TX_BUFBYPASS_ML_NEGEDGE_MODE, 25, 1)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_BUFBYPASS_ML_NEGEDGE_MODE, 24, 1)
    FIELD(CH2_RX_PHALIGN_CFG5, TXPICODE_DDR_EN, 23, 1)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MODE, 22, 1)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MAXCOUNT, 17, 5)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_WAITCYCLE, 14, 3)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_CDR_SLIP_DIR, 13, 1)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_CDR_SLIP_SAMPLE_COUNT, 11, 2)
    FIELD(CH2_RX_PHALIGN_CFG5, TX_BEACON_DLY_OPT_128B130B, 9, 2)
    FIELD(CH2_RX_PHALIGN_CFG5, TX_CLK_DLY_OPT_128B130B, 7, 2)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_BEACON_DLY_OPT_128B130B, 5, 2)
    FIELD(CH2_RX_PHALIGN_CFG5, RX_CLK_DLY_OPT_128B130B, 3, 2)
REG32(CH2_TX_PHALIGN_CFG0, 0x3a5c)
    FIELD(CH2_TX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH2_TX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH2_TX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, TXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH2_TX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH2_TX_PHALIGN_CFG0, MIN_THRESHOLD_OVRD, 7, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, MAX_THRESHOLD_OVRD, 6, 1)
    FIELD(CH2_TX_PHALIGN_CFG0, ALIGN_DMON_SEL, 1, 5)
    FIELD(CH2_TX_PHALIGN_CFG0, TX_DYNAMIC_SWITCH_EN, 0, 1)
REG32(CH2_TX_PHALIGN_CFG1, 0x3a60)
    FIELD(CH2_TX_PHALIGN_CFG1, PHDA_WAIT_CYCLES, 27, 5)
    FIELD(CH2_TX_PHALIGN_CFG1, SETINIT_PH_CNT, 22, 5)
    FIELD(CH2_TX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 17, 5)
    FIELD(CH2_TX_PHALIGN_CFG1, NUM_SAMPLES, 12, 5)
    FIELD(CH2_TX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 5, 7)
    FIELD(CH2_TX_PHALIGN_CFG1, SAMPLE_WAIT, 3, 2)
    FIELD(CH2_TX_PHALIGN_CFG1, CHAIN_MODE, 1, 2)
    FIELD(CH2_TX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 0, 1)
REG32(CH2_TX_PHALIGN_CFG2, 0x3a64)
    FIELD(CH2_TX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH2_TX_PHALIGN_CFG2, TXPI_PHDA_WAIT_CYCLES, 20, 5)
    FIELD(CH2_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_CNT, 15, 5)
    FIELD(CH2_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_WAIT_CYCLE, 10, 5)
    FIELD(CH2_TX_PHALIGN_CFG2, TXPI_NUM_SAMPLES, 3, 5)
    FIELD(CH2_TX_PHALIGN_CFG2, TXPI_SAMPLE_WAIT, 1, 2)
    FIELD(CH2_TX_PHALIGN_CFG2, TXPI_MIN_THRESHOLD_OVRD, 0, 1)
REG32(CH2_TX_PHALIGN_CFG3, 0x3a68)
    FIELD(CH2_TX_PHALIGN_CFG3, TXPI_MAX_THRESHOLD_OVRD, 31, 1)
    FIELD(CH2_TX_PHALIGN_CFG3, TXPI_MAX_SAMPLE_THRESHOLD, 24, 7)
    FIELD(CH2_TX_PHALIGN_CFG3, TXPI_MIN_SAMPLE_THRESHOLD, 17, 7)
    FIELD(CH2_TX_PHALIGN_CFG3, DAPICODE_OVRD, 9, 8)
    FIELD(CH2_TX_PHALIGN_CFG3, TXPICODE_OVRD, 2, 7)
    FIELD(CH2_TX_PHALIGN_CFG3, TXPI_ALIGN_DIR, 1, 1)
    FIELD(CH2_TX_PHALIGN_CFG3, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH2_TX_PHALIGN_CFG4, 0x3a6c)
    FIELD(CH2_TX_PHALIGN_CFG4, TXPI_SETINIT_STEPSIZE, 27, 5)
    FIELD(CH2_TX_PHALIGN_CFG4, TXPI_PHALIGN_STEPSIZE, 22, 5)
    FIELD(CH2_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_CNT, 17, 5)
    FIELD(CH2_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_WAIT_CYCLE, 12, 5)
    FIELD(CH2_TX_PHALIGN_CFG4, MLDLY_NUM_SAMPLES, 5, 5)
    FIELD(CH2_TX_PHALIGN_CFG4, MLDLY_MIN_THRESHOLD_OVRD, 4, 1)
    FIELD(CH2_TX_PHALIGN_CFG4, MLDLY_MAX_THRESHOLD_OVRD, 3, 1)
    FIELD(CH2_TX_PHALIGN_CFG4, MLDLY_SAMPLE_WAIT, 1, 2)
    FIELD(CH2_TX_PHALIGN_CFG4, DLY_ALIGN_DIR, 0, 1)
REG32(CH2_TX_PHALIGN_CFG5, 0x3a70)
    FIELD(CH2_TX_PHALIGN_CFG5, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH2_TX_PHALIGN_CFG5, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH2_TX_PHALIGN_CFG5, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH2_TX_PHALIGN_CFG5, DMON_CLK_SEL, 0, 2)
REG32(CH2_PIPE_CTRL_CFG0, 0x3a74)
    FIELD(CH2_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_NUM, 28, 4)
    FIELD(CH2_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_EN, 27, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, SATA_BURST_SEQ_LEN, 23, 4)
    FIELD(CH2_PIPE_CTRL_CFG0, TX_PD_ELECIDLE_MODE, 22, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, TX_EILDE_DEASSERT_DLY, 19, 3)
    FIELD(CH2_PIPE_CTRL_CFG0, TX_EIDLE_ASSERT_DLY, 16, 3)
    FIELD(CH2_PIPE_CTRL_CFG0, RX_PCSCLK_SEL, 14, 2)
    FIELD(CH2_PIPE_CTRL_CFG0, TX_PHYCLK_SEL, 13, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, TX_PCSCLK_SEL, 11, 2)
    FIELD(CH2_PIPE_CTRL_CFG0, RX_PHYCLK_SEL, 10, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD, 9, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD_EN, 8, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, PIPECLK_SEL, 7, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, RX_ELECIDLE_MODE, 5, 2)
    FIELD(CH2_PIPE_CTRL_CFG0, RX_ELECIDLE_CFG, 2, 3)
    FIELD(CH2_PIPE_CTRL_CFG0, PCIE_MODE, 1, 1)
    FIELD(CH2_PIPE_CTRL_CFG0, USB_MODE, 0, 1)
REG32(CH2_PIPE_CTRL_CFG1, 0x3a78)
    FIELD(CH2_PIPE_CTRL_CFG1, SATA_SPEED, 30, 2)
    FIELD(CH2_PIPE_CTRL_CFG1, P2_SPECIAL_TURNOFF_EN, 29, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, POWERDOWN_OVRD_EN, 28, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PD_TXPMA_PWRDN_OVRD, 27, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PD_TXDRVPWRDN_OVRD, 26, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PD_RX_PD_OVRD, 25, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PD_LCPLL_PD_OVRD, 24, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PD_RPLL_PD_OVRD, 23, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PD_OOB_PD_OVRD, 22, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, OOB_PD, 21, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PIPE_FUND_RST_OVRD_EN, 20, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, IND_ERROR_REPORT, 19, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, UBLAZE_PLL_ILO_CAL_EN, 18, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PIPE_RST_USE_MST_RESET_LOOP, 17, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_PHY_READY_OVRD, 16, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_RX_SYNC_RESET_OVRD, 15, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_TX_SYNC_RESET_OVRD, 14, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_USER_RDY_OVRD, 13, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_PCS_RESET_OVRD, 12, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_PMA_RESET_OVRD, 11, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_TXPROGDIV_RST_OVRD, 10, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_LCPLL_RESET_OVRD, 9, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_LCPLL_PD_OVRD, 8, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_RPLL_RESET_OVRD, 7, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_RPLL_PD_OVRD, 6, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, PIPE_FUND_RST_EN, 5, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RST_ILO_RESET_OVRD, 4, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RXSYNC_EN, 3, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, TXSYNC_EN, 2, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, LCPLL_EN, 1, 1)
    FIELD(CH2_PIPE_CTRL_CFG1, RPLL_EN, 0, 1)
REG32(CH2_PIPE_CTRL_CFG2, 0x3a7c)
    FIELD(CH2_PIPE_CTRL_CFG2, PMA_SIGDET_SEL, 31, 1)
    FIELD(CH2_PIPE_CTRL_CFG2, P2P3_RX_PWRUP_EN, 30, 1)
    FIELD(CH2_PIPE_CTRL_CFG2, PD_TRANS_TIME_FROM_P2, 15, 15)
    FIELD(CH2_PIPE_CTRL_CFG2, TX_RXDETECT_REF, 12, 3)
    FIELD(CH2_PIPE_CTRL_CFG2, TX_RXDETECT_CFG, 1, 11)
    FIELD(CH2_PIPE_CTRL_CFG2, RXDETECT_BYPASS, 0, 1)
REG32(CH2_PIPE_CTRL_CFG3, 0x3a80)
    FIELD(CH2_PIPE_CTRL_CFG3, PIPE_RXADAPT_SAVE_RESTORE_EN, 31, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, PIPE_LCPLL_DYN_PD_EN, 30, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, PIPE_RPLL_DYN_PD_EN, 29, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, RXOUT_DIV, 26, 3)
    FIELD(CH2_PIPE_CTRL_CFG3, TXOUT_DIV, 23, 3)
    FIELD(CH2_PIPE_CTRL_CFG3, RX_VREG_PD, 22, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, TX_VREG_PD, 21, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, ILO_CLKMUX_EN, 20, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, TX_CLKMUX_EN, 19, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, PIPE_FUND_RST_UB_BYPASS, 18, 1)
    FIELD(CH2_PIPE_CTRL_CFG3, PD_TRANS_TIME_TO_P2, 9, 9)
    FIELD(CH2_PIPE_CTRL_CFG3, PD_TRANS_TIME_NONE_P2, 0, 9)
REG32(CH2_PIPE_CTRL_CFG4, 0x3a84)
    FIELD(CH2_PIPE_CTRL_CFG4, RST_TXDAPI_RST_OVRD, 31, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RX_RATE_EN, 30, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_TXDAPI_RST_OVRD, 29, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_ILO_RESET_OVRD, 28, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_UB_CTRL_WO_PHYSTATUS, 27, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_UB_REPROG_REQ_DIS, 26, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_USE_RPLL_AS_DATA_PLL, 25, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_PHYSTATUS_CNT, 20, 5)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_DATA_FLUSH_CNT, 15, 5)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_PHYSTATUS_OVRD, 14, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_CHANGE_IN_PROGRESS_OVRD, 13, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_TXRX_128B130B_EN_OVRD, 12, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_RX_SYNC_RESET_OVRD, 11, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_TX_SYNC_RESET_OVRD, 10, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_UB_REPROG_DONE_OVRD, 9, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_PCS_RESET_OVRD, 8, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_PMA_RESET_OVRD, 7, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_TXPROGDIV_RST_OVRD, 6, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_LCPLL_RESET_OVRD, 5, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_LCPLL_PD_OVRD, 4, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_RPLL_RESET_OVRD, 3, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, RATE_RPLL_PD_OVRD, 2, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, PIPE_RATE_OVRD_EN, 1, 1)
    FIELD(CH2_PIPE_CTRL_CFG4, PIPE_RATE_EN, 0, 1)
REG32(CH2_PIPE_CTRL_CFG5, 0x3a88)
    FIELD(CH2_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_SYNC_ERR_EN, 31, 1)
    FIELD(CH2_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_DP_DIS_EN, 30, 1)
    FIELD(CH2_PIPE_CTRL_CFG5, PIPE_SPECIAL_OFF_RESET_EN, 29, 1)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGT_ESM_DELAY_CE_DIS, 28, 1)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK2, 25, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK, 22, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_CORECLK, 19, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_E6_PIPECLK, 16, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_E5_PIPECLK, 13, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_G4_PIPECLK, 10, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_G3_PIPECLK, 7, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_G2_PIPECLK, 4, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, BUFGTDIV_G1_PIPECLK, 1, 3)
    FIELD(CH2_PIPE_CTRL_CFG5, PIPE_BUFGT_CTRL_EN, 0, 1)
REG32(CH2_PIPE_CTRL_CFG6, 0x3a8c)
    FIELD(CH2_PIPE_CTRL_CFG6, RXOOB_CLKDIV_VAL, 27, 5)
    FIELD(CH2_PIPE_CTRL_CFG6, PIPE_DIST_UB_DONE_SHARE_EN, 26, 1)
    FIELD(CH2_PIPE_CTRL_CFG6, PIPE_CONSUMPT_SEL, 23, 3)
    FIELD(CH2_PIPE_CTRL_CFG6, PIPE_DISTSOUTH_SEL, 21, 2)
    FIELD(CH2_PIPE_CTRL_CFG6, PIPE_DISTNORTH_SEL, 19, 2)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGTDIV_PIPECLK_OVRD, 16, 3)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGT_RSTMASK_OVRD, 12, 4)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGT_CEMASK_OVRD, 8, 4)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGT_CE_OVRD, 7, 1)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGT_RESET_OVRD, 6, 1)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGT_OVRD_EN, 5, 1)
    FIELD(CH2_PIPE_CTRL_CFG6, BUFGT_WAIT_CNT, 0, 5)
REG32(CH2_PIPE_CTRL_CFG7, 0x3a90)
    FIELD(CH2_PIPE_CTRL_CFG7, CDR_CTRL_USE_RAW_SIGVALID, 31, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, RXELECIDLE_USE_RAW_SIGVALID, 30, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, CDR_CTRL_ADAPT_HOLD_EN, 29, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, PIPE_DIST_PLLLOCK_SEL, 27, 2)
    FIELD(CH2_PIPE_CTRL_CFG7, RXPD_IND_CONTROL, 26, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, RATE_USE_LCPLL_OUTCLK_ESM56, 25, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, CDR_CTRL_USER_HOLDCDR_EN, 24, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, RX_DABYP_DIVSEL, 20, 4)
    FIELD(CH2_PIPE_CTRL_CFG7, RX_DA_DIVSEL, 16, 4)
    FIELD(CH2_PIPE_CTRL_CFG7, RX_DA_BYP, 15, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, RXOUTCLKCTL, 12, 3)
    FIELD(CH2_PIPE_CTRL_CFG7, TX_DABYP_DIVSEL, 8, 4)
    FIELD(CH2_PIPE_CTRL_CFG7, TX_DA_DIVSEL, 4, 4)
    FIELD(CH2_PIPE_CTRL_CFG7, TX_DA_BYP, 3, 1)
    FIELD(CH2_PIPE_CTRL_CFG7, TXOUTCLKCTL, 0, 3)
REG32(CH2_PIPE_CTRL_CFG8, 0x3a94)
    FIELD(CH2_PIPE_CTRL_CFG8, PMA_OOB_CLKDIV_VAL, 30, 2)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_ALIGN_REQ_OVRD, 29, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_SLIP_EN, 28, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_HOLDCDR_RX_PHALIGN, 27, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G34, 26, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G12, 25, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_REFCLK_MODE, 23, 2)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_GEN34_ON_EIDLE, 22, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_GEN12_ON_EIDLE, 21, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, CDR_CTRL_EN, 20, 1)
    FIELD(CH2_PIPE_CTRL_CFG8, RXPROGDIVSEL, 10, 10)
    FIELD(CH2_PIPE_CTRL_CFG8, TXPROGDIVSEL, 0, 10)
REG32(CH2_PIPE_CTRL_CFG9, 0x3a98)
    FIELD(CH2_PIPE_CTRL_CFG9, TX_RESET_TIMER_SAMPLES_LG, 30, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, TX_RESET_TIMER_RST_OFFSET, 25, 5)
    FIELD(CH2_PIPE_CTRL_CFG9, TX_RESET_TIMER_CNT_FIRST, 21, 4)
    FIELD(CH2_PIPE_CTRL_CFG9, TX_RESET_TIMER_EN, 20, 1)
    FIELD(CH2_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_IN_SEL, 18, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_IN_SEL, 16, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, RXSYNCDONE_CONSUMPT_SEL, 13, 3)
    FIELD(CH2_PIPE_CTRL_CFG9, RXSYNCDONE_DISTSOUTH_SEL, 11, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, RXSYNCDONE_DISTNORTH_SEL, 9, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_DIS, 8, 1)
    FIELD(CH2_PIPE_CTRL_CFG9, TXSYNCDONE_CONSUMPT_SEL, 5, 3)
    FIELD(CH2_PIPE_CTRL_CFG9, TXSYNCDONE_DISTSOUTH_SEL, 3, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, TXSYNCDONE_DISTNORTH_SEL, 1, 2)
    FIELD(CH2_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_DIS, 0, 1)
REG32(CH2_TX_PIPPM_CFG, 0x3a9c)
    FIELD(CH2_TX_PIPPM_CFG, TXPI_SYNFREQ_PPM, 25, 5)
    FIELD(CH2_TX_PIPPM_CFG, TXPI_DDR_EN, 24, 1)
    FIELD(CH2_TX_PIPPM_CFG, TXPI_PPM_DDR_CFG, 16, 8)
    FIELD(CH2_TX_PIPPM_CFG, TXPI_INVSTROBE_SEL, 15, 1)
    FIELD(CH2_TX_PIPPM_CFG, TXPI_PPM_CFG, 4, 8)
    FIELD(CH2_TX_PIPPM_CFG, TXPIPPMOVRDEN, 3, 1)
    FIELD(CH2_TX_PIPPM_CFG, TXPI_GRAY_SEL, 2, 1)
    FIELD(CH2_TX_PIPPM_CFG, TXPIPPMSEL, 1, 1)
    FIELD(CH2_TX_PIPPM_CFG, TXPIPPMPD, 0, 1)
REG32(CH2_CHL_RSV_CFG2, 0x3aa0)
REG32(CH2_FABRIC_INTF_CFG0, 0x3aa4)
    FIELD(CH2_FABRIC_INTF_CFG0, HSDPPCSRESET_PIN_EN, 31, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, USRRDY_PIN_EN, 30, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RX_RATE_PIN_EN, 29, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TX_RATE_PIN_EN, 28, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, CDR_PIN_EN, 27, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, QPI_PIN_EN, 26, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, ILO_RESET_PIN_EN, 25, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, PERSTB_PIN_EN, 24, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, LOOPBACK_PIN_EN, 23, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TX_PHDLYRESET_PIN_EN, 22, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TX_PHALIGN_PIN_EN, 21, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TX_DAPI_PIN_EN, 20, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RXTERMINATION_PIN_EN, 19, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TXPOLARITY_PIN_EN, 18, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TXPI_PIN_EN, 17, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TXPISOPD_PIN_EN, 16, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TXPIPPM_PIN_EN, 15, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TXPD_PIN_EN, 14, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TXINHIBIT_PIN_EN, 13, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, TX_CHRESET_PIN_EN, 12, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RX_PHDLYRESET_PIN_EN, 11, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RX_PHALIGN_PIN_EN, 10, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RX_EQTRAINING_PIN_EN, 9, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RX_DAPI_PIN_EN, 8, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RX_CHRESET_PIN_EN, 7, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RXSLIDE_PIN_EN, 6, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, PRBSSEL_PIN_EN, 5, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RXPOLARITY_PIN_EN, 4, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RXPD_PIN_EN, 3, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RXLPM_PIN_EN, 2, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, APT_PIN_EN, 1, 1)
    FIELD(CH2_FABRIC_INTF_CFG0, RXCDRHOLD_PIN_EN, 0, 1)
REG32(CH2_FABRIC_INTF_CFG1, 0x3aa8)
    FIELD(CH2_FABRIC_INTF_CFG1, A_RXSLIDE, 31, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_TXRATE, 23, 8)
    FIELD(CH2_FABRIC_INTF_CFG1, A_RXPRBSSEL, 19, 4)
    FIELD(CH2_FABRIC_INTF_CFG1, A_RXPOLARITY, 18, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_RXPD, 16, 2)
    FIELD(CH2_FABRIC_INTF_CFG1, A_RXLPMEN, 15, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRHOLD, 11, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_PERSTB, 10, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_LOOPBACK, 7, 3)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRSTEPSX, 6, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRSTEPSQ, 5, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRSTEPDIR, 4, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRINCPCTRL, 3, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRFREQOS, 2, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDROVREN, 1, 1)
    FIELD(CH2_FABRIC_INTF_CFG1, A_CDRBMCDRREQ, 0, 1)
REG32(CH2_FABRIC_INTF_CFG2, 0x3aac)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RXUSRRDY, 31, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_TXUSRRDY, 30, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_ILO_RESETMASK, 29, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_ILORESET, 28, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_CDRPHRESET, 27, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_EYESCANRESET, 26, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RXOOBRESET, 25, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RXPRBSCNTRESET, 24, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RX_PROGDIVRESET, 23, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_GTRXRESET, 22, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RX_RESETMODE, 20, 2)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RX_PCS_RESETMASK, 15, 5)
    FIELD(CH2_FABRIC_INTF_CFG2, A_RX_PMA_RESETMASK, 8, 7)
    FIELD(CH2_FABRIC_INTF_CFG2, A_TX_PCS_RESETMASK, 7, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_TX_PMA_RESETMASK, 4, 3)
    FIELD(CH2_FABRIC_INTF_CFG2, A_TX_PROGDIVRESET, 3, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_GTTXRESET, 2, 1)
    FIELD(CH2_FABRIC_INTF_CFG2, A_TX_RESETMODE, 0, 2)
REG32(CH2_FABRIC_INTF_CFG3, 0x3ab0)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXDAPICODERESET, 31, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXDAPICODEOVRDEN, 30, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXPOLARITY, 29, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXPICODERESET, 28, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXPICODEOVRDEN, 27, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXPISOPD, 26, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_STEPSIZEPPM, 21, 5)
    FIELD(CH2_FABRIC_INTF_CFG3, A_ENPPM, 20, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXPD, 18, 2)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXINHIBIT, 17, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXPHSHIFT180, 16, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXPHSETINITREQ, 15, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXPHALIGNREQ, 14, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXPHDLYPD, 13, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXDLYALIGNREQ, 12, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXMLFINEALIGNREQ, 11, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXMLDCHAINREQ, 10, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXMLDCHAINDONE, 9, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXEQTRAINING, 8, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXDAPICODERESET, 7, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXDAPICODEOVRDEN, 6, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXDAPIRESET, 5, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RX_PHALIGN_RESETMASK, 4, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_RXPHDLYRESET, 3, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXDAPIRESET, 2, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TX_PHALIGN_RESETMASK, 1, 1)
    FIELD(CH2_FABRIC_INTF_CFG3, A_TXPHDLYRESET, 0, 1)
REG32(CH2_FABRIC_INTF_CFG4, 0x3ab4)
    FIELD(CH2_FABRIC_INTF_CFG4, A_APT_OVERWREN, 31, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_APT_EXTHOLD, 30, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_RXQPIEN, 29, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXQPIWEAKPU, 28, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXQPIBIASEN, 27, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_EYESCANTRIGGER, 26, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_PHY_ESM_ADAPTATION_SAVE, 25, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_RXTERMINATION, 24, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_RXRATE, 16, 8)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXDAPIRESETMASK, 13, 2)
    FIELD(CH2_FABRIC_INTF_CFG4, A_RXDAPIRESETMASK, 11, 2)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXMLFINEALIGNREQ, 10, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXMLDCHAINREQ, 9, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXDLYALIGNREQ, 8, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXPHSHIFT180, 7, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXPHSETINITREQ, 6, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXPHALIGNREQ, 5, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXPHDLYPD, 4, 1)
    FIELD(CH2_FABRIC_INTF_CFG4, A_TXPRBSSEL, 0, 4)
REG32(CH2_FABRIC_INTF_CFG5, 0x3ab8)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXEMPPRE, 27, 5)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXEMPPOS, 22, 5)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXEMPMAIN, 15, 7)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXDRVAMP, 10, 5)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXDEEMPH, 8, 2)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXSWING, 7, 1)
    FIELD(CH2_FABRIC_INTF_CFG5, A_TXMARGIN, 4, 3)
    FIELD(CH2_FABRIC_INTF_CFG5, EYESCANTRIGGER_PIN_EN, 2, 1)
    FIELD(CH2_FABRIC_INTF_CFG5, TX_EQ_PIN_EN, 1, 1)
    FIELD(CH2_FABRIC_INTF_CFG5, PHYESMADAPTSAVE_PIN_EN, 0, 1)
REG32(CH2_RX_ELASTIC_BUF_CFG1, 0x3abc)
    FIELD(CH2_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_3, 22, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_2, 12, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_1, 2, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_PRECEDENCE, 1, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_KEEP_IDLE, 0, 1)
REG32(CH2_RX_ELASTIC_BUF_CFG2, 0x3ac0)
    FIELD(CH2_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_LEN, 30, 2)
    FIELD(CH2_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_2, 20, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_1, 10, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_1_4, 0, 10)
REG32(CH2_RX_ELASTIC_BUF_CFG3, 0x3ac4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_DISPERR_SEQ_MATCH, 31, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_DATA_SOURCE_SEL, 30, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_USB3_CLK_COR_EQ_EN, 29, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_EN, 25, 4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_1_EN, 21, 4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_USE, 20, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_4, 10, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_3, 0, 10)
REG32(CH2_RX_ELASTIC_BUF_CFG4, 0x3ac8)
    FIELD(CH2_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_3, 22, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_2, 12, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_1, 2, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_LEN, 0, 2)
REG32(CH2_RX_ELASTIC_BUF_CFG5, 0x3acc)
    FIELD(CH2_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_USE, 30, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_2, 20, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_1, 10, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_1_4, 0, 10)
REG32(CH2_RX_ELASTIC_BUF_CFG6, 0x3ad0)
    FIELD(CH2_RX_ELASTIC_BUF_CFG6, EB_8B10B_FTS_DESKEW_SEQ_EN, 28, 4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_EN, 24, 4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_1_EN, 20, 4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_4, 10, 10)
    FIELD(CH2_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_3, 0, 10)
REG32(CH2_RX_ELASTIC_BUF_CFG7, 0x3ad4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB128B130B_32_BLKALGN_CTL, 31, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB128B130B_32_EIOS_LPBK4_BYP, 30, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB128B130B_16_BLKALGN_CTL, 29, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB128B130B_16_EIOS_LPBK4_BYP, 28, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB128B130B_32_ONE_SKP_INS_DEL, 26, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_SLAVE, 22, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MASTER, 21, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_LEVEL, 18, 3)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_BUFFER_CFG, 12, 6)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_DELAY_CC_AFTER_FTS, 11, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_KEEP_4ADJ, 10, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SNAP4_USE, 9, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SLIP4_USE, 8, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_LANE_DESKEW_EN, 7, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_KEEP_ALIGN, 6, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MAX_SKEW, 2, 4)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_EN, 1, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG7, EB8B10B_ADDR_MODE, 0, 1)
REG32(CH2_RX_ELASTIC_BUF_CFG8, 0x3ad8)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EIOS_DEL_SEL, 31, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, EB128B130B_32_AUTO_REALIGN, 28, 2)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, EB128B130B_32_FULL_THRESH, 16, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EMPTY_THRESH, 11, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MAX_LAT, 6, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MIN_LAT, 1, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG8, ELASTICBUF_128B130B_EN, 0, 1)
REG32(CH2_RX_ELASTIC_BUF_CFG9, 0x3adc)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EIOS_DEL_SEL, 31, 1)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_AUTO_REALIGN, 28, 2)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_FULL_THRESH, 16, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EMPTY_THRESH, 11, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MAX_LAT, 6, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MIN_LAT, 1, 5)
    FIELD(CH2_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EN, 0, 1)
REG32(CH2_RX_OOB_CFG0, 0x3ae0)
    FIELD(CH2_RX_OOB_CFG0, OOB_SATA_EIDLE_VAL, 27, 3)
    FIELD(CH2_RX_OOB_CFG0, OOB_SATA_BURST_VAL, 24, 3)
    FIELD(CH2_RX_OOB_CFG0, OOB_SATA_MAX_INIT, 18, 6)
    FIELD(CH2_RX_OOB_CFG0, OOB_SATA_MIN_INIT, 12, 6)
    FIELD(CH2_RX_OOB_CFG0, OOB_SATA_MAX_BURST, 6, 6)
    FIELD(CH2_RX_OOB_CFG0, OOB_SATA_MIN_BURST, 0, 6)
REG32(CH2_RX_OOB_CFG1, 0x3ae4)
    FIELD(CH2_RX_OOB_CFG1, OOB_SAS_MAX_COM, 18, 7)
    FIELD(CH2_RX_OOB_CFG1, OOB_SAS_MIN_COM, 12, 6)
    FIELD(CH2_RX_OOB_CFG1, OOB_SATA_MAX_WAKE, 6, 6)
    FIELD(CH2_RX_OOB_CFG1, OOB_SATA_MIN_WAKE, 0, 6)
REG32(CH2_MONITOR_CFG, 0x3ae8)
    FIELD(CH2_MONITOR_CFG, RXAMONSEL, 26, 6)
    FIELD(CH2_MONITOR_CFG, TXAMONSEL, 21, 5)
    FIELD(CH2_MONITOR_CFG, DAAMONSEL, 18, 3)
    FIELD(CH2_MONITOR_CFG, CHCKAMONSEL, 14, 4)
    FIELD(CH2_MONITOR_CFG, CHAMONSEL, 12, 2)
    FIELD(CH2_MONITOR_CFG, DMON_FIFO_BYPASS, 7, 1)
    FIELD(CH2_MONITOR_CFG, DMON_CLK_SRC, 4, 3)
    FIELD(CH2_MONITOR_CFG, DMON_DATA_SRC, 1, 3)
    FIELD(CH2_MONITOR_CFG, DMON_EN, 0, 1)
REG32(CH2_PIPE_CTRL_CFG10, 0x3aec)
    FIELD(CH2_PIPE_CTRL_CFG10, RATE_CHANGE_DURING_RST_EN, 31, 1)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_RXDAPI_RST_MASK, 25, 2)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_TXDAPI_RST_MASK, 23, 2)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_RXSYNC_RST_MASK, 22, 1)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_TXSYNC_RST_MASK, 21, 1)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_RXPCS_RST_MASK, 16, 5)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_RXPMA_RST_MASK, 9, 7)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_TXPCS_RST_MASK, 8, 1)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_TXPMA_RST_MASK, 5, 3)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_LCPLL_RST_MASK, 2, 2)
    FIELD(CH2_PIPE_CTRL_CFG10, PIPE_RPLL_RST_MASK, 0, 2)
REG32(CH2_CHL_RSV_CFG3, 0x3af0)
REG32(CH2_CHL_RSV_CFG4, 0x3af4)
REG32(MEMCELLX3AF8, 0x3af8)
    FIELD(MEMCELLX3AF8, QUAD_MUX2_REFCLK_SEL, 30, 2)
REG32(HSCLK1_HSDIST_CFG, 0x3afc)
    FIELD(HSCLK1_HSDIST_CFG, HSDIST_DIV2SEL, 16, 1)
    FIELD(HSCLK1_HSDIST_CFG, HSDIST_APROBE_EN_VREF, 7, 1)
    FIELD(HSCLK1_HSDIST_CFG, HSDIST_VREFSEL, 3, 2)
    FIELD(HSCLK1_HSDIST_CFG, HSDIST_CTRL, 0, 3)
REG32(RCALBG_RCALBG_BOT_CFG0, 0x3c00)
REG32(RCALBG_RCALBG_BOT_CFG1, 0x3c04)
REG32(CTRL_RSV_CFG1, 0x3c08)
    FIELD(CTRL_RSV_CFG1, VCTRL1_RPLL, 25, 5)
    FIELD(CTRL_RSV_CFG1, VCTRL0_RPLL, 20, 5)
    FIELD(CTRL_RSV_CFG1, VCTRL3_LCPLL, 15, 5)
    FIELD(CTRL_RSV_CFG1, VCTRL2_LCPLL, 10, 5)
    FIELD(CTRL_RSV_CFG1, VCTRL1_LCPLL, 5, 5)
    FIELD(CTRL_RSV_CFG1, VCTRL0_LCPLL, 0, 5)
REG32(A_CFG3, 0x3c0c)
    FIELD(A_CFG3, A_HS0_RPLLPD, 31, 1)
    FIELD(A_CFG3, A_HS0_RPLLRESETMASK, 29, 2)
    FIELD(A_CFG3, A_HS0_RPLLRESETBYPASSMODE, 28, 1)
    FIELD(A_CFG3, A_HS0_RPLLRESET, 27, 1)
    FIELD(A_CFG3, A_HS0_RPLLSDMTOGGLE, 26, 1)
    FIELD(A_CFG3, A_HS0_RPLLSDMDATA, 0, 26)
REG32(RCALBG_RCALBG_BOT_CFG2, 0x3c10)
REG32(RCALBG_RCALBG_BOT_CFG3, 0x3c14)
REG32(RCALBG_RCALBG_BOT_CFG4, 0x3c20)
REG32(RCALBG_RCALBG_BOT_CFG5, 0x3c24)
REG32(HSCLK1_RPLL_LGC_CFG0, 0x3c30)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_AUTO_FINE_EN, 31, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_FINE_SWEEP, 29, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_OVRD_MODE, 27, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_CRSACCY, 25, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_MONCLKCYCLE, 22, 3)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_PLLLOCKCOARSE, 20, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_PLLLOCKFACTOR, 18, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_UNLOCKCTRL, 16, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_VCTRL_LATCH_BYPASS, 15, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_BYP_LOCKDETECT, 13, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_COARSE_FREQ_OVRD_EN, 12, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLLLOCKEN, 11, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_ALLOW_LB2UB, 10, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_ALLOW_UB2LB, 9, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_VCO_SEL_AUTO, 8, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_VCO_SEL, 7, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG0, RPLL_COARSE_FREQ_OVRD, 0, 7)
REG32(HSCLK1_RPLL_LGC_CFG1, 0x3c34)
    FIELD(HSCLK1_RPLL_LGC_CFG1, PLL_RESET_DLY_TIME, 24, 8)
    FIELD(HSCLK1_RPLL_LGC_CFG1, SDM_RESET_DLY_TIME, 20, 4)
    FIELD(HSCLK1_RPLL_LGC_CFG1, SDM_LOOP_BYPASS_HANDSHAKE, 19, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG1, PRESCALE_DIV, 17, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG1, RESET_ON_PWRDN, 16, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG1, RPLL_BIN_ORDER, 13, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG1, RPLL_SDM_ORDER, 11, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG1, SDM_WIDTHSEL, 9, 2)
    FIELD(HSCLK1_RPLL_LGC_CFG1, RATESEL, 8, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG1, BYPASS, 7, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG1, CLKSEL, 6, 1)
    FIELD(HSCLK1_RPLL_LGC_CFG1, TESTCON, 1, 5)
    FIELD(HSCLK1_RPLL_LGC_CFG1, TESTEN, 0, 1)
REG32(HSCLK1_RPLL_LGC_CFG2, 0x3c38)
    FIELD(HSCLK1_RPLL_LGC_CFG2, SDM_SEED, 0, 25)
REG32(HSCLK1_RPLL_CFG0, 0x3c3c)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_IF_CTRL_CP2, 28, 3)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_IF_CTRL_CP1, 26, 2)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_IF_CTRL_CZ, 25, 1)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_RSTSEL, 18, 7)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_CPEN, 6, 12)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_ENPFD, 5, 1)
    FIELD(HSCLK1_RPLL_CFG0, RPLL_REFDIV, 0, 5)
REG32(A_CFG4, 0x3c40)
    FIELD(A_CFG4, A_HS1_LCPLLPD, 31, 1)
    FIELD(A_CFG4, A_HS1_LCPLLRESETMASK, 29, 2)
    FIELD(A_CFG4, A_HS1_LCPLLRESETBYPASSMODE, 28, 1)
    FIELD(A_CFG4, A_HS1_LCPLLRESET, 27, 1)
    FIELD(A_CFG4, A_HS1_LCPLLSDMTOGGLE, 26, 1)
    FIELD(A_CFG4, A_HS1_LCPLLSDMDATA, 0, 26)
REG32(A_CFG5, 0x3c44)
    FIELD(A_CFG5, A_HS1_RPLLPD, 31, 1)
    FIELD(A_CFG5, A_HS1_RPLLRESETMASK, 29, 2)
    FIELD(A_CFG5, A_HS1_RPLLRESETBYPASSMODE, 28, 1)
    FIELD(A_CFG5, A_HS1_RPLLRESET, 27, 1)
    FIELD(A_CFG5, A_HS1_RPLLSDMTOGGLE, 26, 1)
    FIELD(A_CFG5, A_HS1_RPLLSDMDATA, 0, 26)
REG32(MEMCELLX3C48, 0x3c48)
    FIELD(MEMCELLX3C48, HS1_LCPLL_IPS_PIN_EN, 27, 1)
    FIELD(MEMCELLX3C48, HS1_LCPLL_IPS_REFCLK_SEL, 24, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP7, 21, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP6, 18, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP5, 15, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP4, 12, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP3, 9, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP2, 6, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP1, 3, 3)
    FIELD(MEMCELLX3C48, HS1_LCPLL_REFCLK_MAP0, 0, 3)
REG32(MEMCELLX3C4C, 0x3c4c)
    FIELD(MEMCELLX3C4C, HS1_RPLL_IPS_PIN_EN, 27, 1)
    FIELD(MEMCELLX3C4C, HS1_RPLL_IPS_REFCLK_SEL, 24, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP7, 21, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP6, 18, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP5, 15, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP4, 12, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP3, 9, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP2, 6, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP1, 3, 3)
    FIELD(MEMCELLX3C4C, HS1_RPLL_REFCLK_MAP0, 0, 3)
REG32(HSCLK1_RPLL_CFG1, 0x3c70)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_SAP_EN_VREG, 31, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_SAP_EN_VCTRL, 30, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_SAP_EN_ICP, 29, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_EN_ANATEST1V, 28, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_VREG_FILTER_CTRL, 23, 5)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_VREG_FILTER_BYPASS, 22, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_VCCSEL, 19, 3)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_RVCO_CCI, 14, 5)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_RVCO_TC_EXTB, 8, 6)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_SAP_EN_AVCC_VCDL, 7, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_TCMP_BYPASS, 6, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_TCMP_ENABLE, 5, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_DYNSEL, 3, 1)
    FIELD(HSCLK1_RPLL_CFG1, RPLL_REFCLK_SEL, 0, 3)
REG32(HSCLK1_RPLL_CFG2, 0x3c74)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_TEST_DIG_SEL, 31, 1)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_DMON_EN, 29, 2)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_BAND_SEL, 25, 4)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_FBK_RES_SEL, 23, 2)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_IF_CTRL_RP, 7, 3)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_IF_CTRL_RP_EN, 6, 1)
    FIELD(HSCLK1_RPLL_CFG2, RPLL_IF_CTRL_RZ, 0, 6)
REG32(CH3_RESET_TIME_CFG0, 0x3c78)
    FIELD(CH3_RESET_TIME_CFG0, TX_PCS_RESET_TIME, 25, 5)
    FIELD(CH3_RESET_TIME_CFG0, TX_PMA_RESET_TIME, 20, 5)
    FIELD(CH3_RESET_TIME_CFG0, TX_CLKGEN_RESET_TIME, 15, 5)
    FIELD(CH3_RESET_TIME_CFG0, TX_DCD_RESET_TIME, 10, 5)
    FIELD(CH3_RESET_TIME_CFG0, ILO_RESET_TIME, 0, 5)
REG32(CH3_RESET_TIME_CFG1, 0x3c7c)
    FIELD(CH3_RESET_TIME_CFG1, RX_PMA_RESET_TIME, 25, 5)
    FIELD(CH3_RESET_TIME_CFG1, RX_CLKGEN_RESET_TIME, 20, 5)
    FIELD(CH3_RESET_TIME_CFG1, RX_DCD_RESET_TIME, 15, 5)
    FIELD(CH3_RESET_TIME_CFG1, RX_CFOK_RESET_TIME, 10, 5)
    FIELD(CH3_RESET_TIME_CFG1, RX_PHALIGN_RESET_TIME, 5, 5)
    FIELD(CH3_RESET_TIME_CFG1, TX_PHALIGN_RESET_TIME, 0, 5)
REG32(CH3_RESET_TIME_CFG2, 0x3c80)
    FIELD(CH3_RESET_TIME_CFG2, RX_BUF_RESET_TIME, 25, 5)
    FIELD(CH3_RESET_TIME_CFG2, RX_PRBS_RESET_TIME, 20, 5)
    FIELD(CH3_RESET_TIME_CFG2, RX_PCS_RESET_TIME, 15, 5)
    FIELD(CH3_RESET_TIME_CFG2, RX_DFE_RESET_TIME, 10, 5)
    FIELD(CH3_RESET_TIME_CFG2, RX_CDRFREQ_RESET_TIME, 5, 5)
    FIELD(CH3_RESET_TIME_CFG2, RX_CDRPHASE_RESET_TIME, 0, 5)
REG32(CH3_RESET_TIME_CFG3, 0x3c84)
    FIELD(CH3_RESET_TIME_CFG3, TX_DAPI_RESET_TIME, 29, 3)
    FIELD(CH3_RESET_TIME_CFG3, RX_DAPI_RESET_TIME, 26, 3)
    FIELD(CH3_RESET_TIME_CFG3, TX_DAPIDIV_RESET_TIME, 21, 5)
    FIELD(CH3_RESET_TIME_CFG3, RX_DAPIDIV_RESET_TIME, 16, 5)
    FIELD(CH3_RESET_TIME_CFG3, RX_PROGDIV_RESET_TIME, 13, 3)
    FIELD(CH3_RESET_TIME_CFG3, TX_PROGDIV_RESET_TIME, 10, 3)
    FIELD(CH3_RESET_TIME_CFG3, RX_EYESCAN_RESET_TIME, 5, 5)
    FIELD(CH3_RESET_TIME_CFG3, RX_OOB_RESET_TIME, 0, 5)
REG32(CH3_RESET_LOOPER_ID_CFG, 0x3c88)
    FIELD(CH3_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_END_ID, 28, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, TX_PCS_LOOPER_START_ID, 24, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_END_ID, 20, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, TX_PMA_LOOPER_START_ID, 16, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_END_ID, 12, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, RX_PCS_LOOPER_START_ID, 8, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_END_ID, 4, 4)
    FIELD(CH3_RESET_LOOPER_ID_CFG, RX_PMA_LOOPER_START_ID, 0, 4)
REG32(CH3_RESET_LOOP_ID_CFG0, 0x3c8c)
    FIELD(CH3_RESET_LOOP_ID_CFG0, TX_PCS_RESET_LOOP_ID, 12, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG0, TX_PMA_RESET_LOOP_ID, 8, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG0, TX_CLKGEN_RESET_LOOP_ID, 4, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG0, TX_DCD_RESET_LOOP_ID, 0, 4)
REG32(CH3_RESET_LOOP_ID_CFG1, 0x3c90)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_PCS_RESET_LOOP_ID, 28, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_DFE_RESET_LOOP_ID, 24, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_CDRFREQ_RESET_LOOP_ID, 20, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_CDRPHASE_RESET_LOOP_ID, 16, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_PMA_RESET_LOOP_ID, 12, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_CLKGEN_RESET_LOOP_ID, 8, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_DCD_RESET_LOOP_ID, 4, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG1, RX_CFOK_RESET_LOOP_ID, 0, 4)
REG32(CH3_RESET_LOOP_ID_CFG2, 0x3c94)
    FIELD(CH3_RESET_LOOP_ID_CFG2, RX_OOB_RESET_LOOP_ID, 12, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG2, RX_EYESCAN_RESET_LOOP_ID, 8, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG2, RX_BUF_RESET_LOOP_ID, 4, 4)
    FIELD(CH3_RESET_LOOP_ID_CFG2, RX_PRBS_RESET_LOOP_ID, 0, 4)
REG32(CH3_RESET_BYP_HDSHK_CFG, 0x3c98)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDAPI_RESET_LOOP, 9, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDAPI_RESET_LOOP, 8, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CDR_RESET_LOOP, 7, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RXDCD_RESET_LOOP, 6, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_CFOK_RESET_LOOP, 5, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_RX_PHALIGN_RESET_LOOP, 4, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PHALIGN_RESET_LOOP, 3, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TXDCD_RESET_LOOP, 2, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_TX_PCS_RESET_LOOP, 1, 1)
    FIELD(CH3_RESET_BYP_HDSHK_CFG, BYP_HDSHK_ILO_RESET_LOOP, 0, 1)
REG32(CH3_RESET_CFG, 0x3c9c)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_EIDLE_LO_CNT, 28, 4)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_EIDLE_HI_CNT, 24, 4)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_ON_EIDLE, 23, 1)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_ON_COMMAALIGN, 22, 1)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_DEFER_EN, 21, 1)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_ON_RXVALID, 20, 1)
    FIELD(CH3_RESET_CFG, EB8B10B_RESET_ON_UNALIGN, 19, 1)
    FIELD(CH3_RESET_CFG, HSDP_MST_RESET_EN, 16, 1)
    FIELD(CH3_RESET_CFG, TXPHYCLK_FREQ_CNT_EN, 15, 1)
    FIELD(CH3_RESET_CFG, TXPCSCLK_FREQ_CNT_EN, 14, 1)
    FIELD(CH3_RESET_CFG, TXUSRCLK_FREQ_CNT_EN, 13, 1)
    FIELD(CH3_RESET_CFG, RXPHYCLK_FREQ_CNT_EN, 12, 1)
    FIELD(CH3_RESET_CFG, RXPCSCLK_FREQ_CNT_EN, 11, 1)
    FIELD(CH3_RESET_CFG, RXUSRCLK_FREQ_CNT_EN, 10, 1)
    FIELD(CH3_RESET_CFG, CDR_SOFTRESET_MODE, 7, 1)
    FIELD(CH3_RESET_CFG, ILORESET_BYPASS_MODE, 6, 1)
    FIELD(CH3_RESET_CFG, ILORESET_ON_PLLLOCK, 5, 1)
    FIELD(CH3_RESET_CFG, ILORESET_PLLLOCK_SEL, 4, 1)
    FIELD(CH3_RESET_CFG, RX_PMA_RST_SYNC_DISABLE, 3, 1)
    FIELD(CH3_RESET_CFG, PRESCALE_DIV, 0, 3)
REG32(MEMCELLX3CA0, 0x3ca0)
    FIELD(MEMCELLX3CA0, CH3_INSTANTIATED, 31, 1)
    FIELD(MEMCELLX3CA0, CH3_SIM_TX_EIDLE_DRIVE_LEVEL, 6, 2)
    FIELD(MEMCELLX3CA0, CH3_SIM_RESET_SPEEDUP, 5, 1)
    FIELD(MEMCELLX3CA0, CH3_SIM_RECEIVER_DETECT_PASS, 4, 1)
    FIELD(MEMCELLX3CA0, CH3_SIM_MODE, 0, 4)
REG32(CH3_TX_ANA_CFG0, 0x3ca4)
    FIELD(CH3_TX_ANA_CFG0, TX_VREG_CTRL, 6, 3)
    FIELD(CH3_TX_ANA_CFG0, TX_VREG_VREFSEL, 4, 2)
    FIELD(CH3_TX_ANA_CFG0, TX_LPK_SARC_ENB, 3, 1)
REG32(CH3_TX_DRV_CFG0, 0x3ca8)
    FIELD(CH3_TX_DRV_CFG0, TX_REG_COMP_EN, 31, 1)
    FIELD(CH3_TX_DRV_CFG0, TX_REG_SCALE_SEL, 25, 6)
    FIELD(CH3_TX_DRV_CFG0, TX_CTL_DRV_OVR_EN, 24, 1)
    FIELD(CH3_TX_DRV_CFG0, TX_CTL_DRV_EN, 20, 4)
    FIELD(CH3_TX_DRV_CFG0, TX_REFBIAS_ENB_IPP, 19, 1)
    FIELD(CH3_TX_DRV_CFG0, TX_REFBIAS_EN_AVCC, 18, 1)
    FIELD(CH3_TX_DRV_CFG0, TX_QPI_STATEN, 4, 1)
    FIELD(CH3_TX_DRV_CFG0, TX_TXLPK_DRVHIZ, 3, 1)
    FIELD(CH3_TX_DRV_CFG0, TX_SW_MEAS, 0, 3)
REG32(CH3_TX_DRV_CFG1, 0x3cac)
    FIELD(CH3_TX_DRV_CFG1, TX_VCTRLN_ADJ_EN, 31, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_VCTRLP_ADJ_EN, 30, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_ZRES_RATIO_SEL, 22, 5)
    FIELD(CH3_TX_DRV_CFG1, TX_ZCTRLP_OVR_EN, 21, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_ZCTRLP_OVR_SEL, 19, 2)
    FIELD(CH3_TX_DRV_CFG1, TX_ZCTRLN_OVR_EN, 18, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_ZCTRLN_OVR_SEL, 16, 2)
    FIELD(CH3_TX_DRV_CFG1, TX_REGP_PDB, 12, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_REGN_PDB, 11, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_VSWING_SEL_OVR_EN, 10, 1)
    FIELD(CH3_TX_DRV_CFG1, TX_REGP_VSWING_SEL_OVR, 4, 6)
    FIELD(CH3_TX_DRV_CFG1, TX_REGN_VSWING_SEL_OVR, 0, 4)
REG32(CH3_CHL_RSV_CFG0, 0x3cb0)
    FIELD(CH3_CHL_RSV_CFG0, EB8B10B_RESET_RXVALID_DELAY, 28, 4)
    FIELD(CH3_CHL_RSV_CFG0, UBALZE_GPI_OUT1_SEL, 17, 2)
    FIELD(CH3_CHL_RSV_CFG0, UB_REPROG_DONE_RXPD_BYPASS, 16, 1)
    FIELD(CH3_CHL_RSV_CFG0, RXPOWERDOWN_UBLAZE_CTRL_EN, 15, 1)
    FIELD(CH3_CHL_RSV_CFG0, RXTERMINATION_OVRD, 13, 2)
    FIELD(CH3_CHL_RSV_CFG0, UB_REPROG_DONE_TXPD_BYPASS, 12, 1)
    FIELD(CH3_CHL_RSV_CFG0, UBALZE_GPI_OUT3_SEL, 10, 2)
    FIELD(CH3_CHL_RSV_CFG0, TXPOWERDOWN_UBLAZE_CTRL_EN, 9, 1)
    FIELD(CH3_CHL_RSV_CFG0, PD_TRANS_TIME_CPMIN, 0, 9)
REG32(CH3_TX_SER_CFG0, 0x3cb4)
    FIELD(CH3_TX_SER_CFG0, TX_SEL_CLK_DLY, 10, 2)
    FIELD(CH3_TX_SER_CFG0, CLK_SEL_CLK_STG2, 8, 2)
    FIELD(CH3_TX_SER_CFG0, TX_SEL_CLK_PCS, 4, 4)
    FIELD(CH3_TX_SER_CFG0, TX_ENABLE_STG1, 3, 1)
REG32(CH3_RX_CDR_CFG0, 0x3cb8)
    FIELD(CH3_RX_CDR_CFG0, SELMODE, 31, 1)
    FIELD(CH3_RX_CDR_CFG0, DATAWIDTH_OVR, 27, 4)
    FIELD(CH3_RX_CDR_CFG0, LOWLATENCY_OVR, 26, 1)
    FIELD(CH3_RX_CDR_CFG0, S_SEL, 20, 2)
    FIELD(CH3_RX_CDR_CFG0, D_SEL_Y, 19, 1)
    FIELD(CH3_RX_CDR_CFG0, D_SEL_P, 18, 1)
    FIELD(CH3_RX_CDR_CFG0, Y_SEL_X, 17, 1)
    FIELD(CH3_RX_CDR_CFG0, X_SEL_Y, 16, 1)
    FIELD(CH3_RX_CDR_CFG0, WALKSPEED_BM, 14, 2)
    FIELD(CH3_RX_CDR_CFG0, WALKSPEED_CMN, 12, 2)
    FIELD(CH3_RX_CDR_CFG0, TESTCON, 8, 3)
    FIELD(CH3_RX_CDR_CFG0, TESTSRC, 5, 3)
    FIELD(CH3_RX_CDR_CFG0, TESTRATESEL, 3, 2)
    FIELD(CH3_RX_CDR_CFG0, TESTCHCLKSEL, 2, 1)
    FIELD(CH3_RX_CDR_CFG0, TESTEN, 1, 1)
    FIELD(CH3_RX_CDR_CFG0, CDRENF, 0, 1)
REG32(CH3_RX_CDR_CFG1, 0x3cbc)
    FIELD(CH3_RX_CDR_CFG1, DELTA_SAT_MODE, 28, 3)
    FIELD(CH3_RX_CDR_CFG1, DXD_VAL, 16, 12)
    FIELD(CH3_RX_CDR_CFG1, CFG_TOGGLE, 15, 1)
    FIELD(CH3_RX_CDR_CFG1, FREQ_SYMM, 14, 1)
    FIELD(CH3_RX_CDR_CFG1, WALKSPEED_SLIP, 12, 2)
    FIELD(CH3_RX_CDR_CFG1, SLIP_MAG, 10, 2)
    FIELD(CH3_RX_CDR_CFG1, SLIP_ENB, 9, 1)
    FIELD(CH3_RX_CDR_CFG1, PI_DDR_MODE, 8, 1)
    FIELD(CH3_RX_CDR_CFG1, FLIPCLKTOPI, 7, 1)
    FIELD(CH3_RX_CDR_CFG1, PICODE_D_OVR, 0, 7)
REG32(CH3_RX_CDR_CFG2, 0x3cc0)
    FIELD(CH3_RX_CDR_CFG2, DXDSCAL_DSEL_OVR, 31, 1)
    FIELD(CH3_RX_CDR_CFG2, DXDSCAL_EN_OVR, 30, 1)
    FIELD(CH3_RX_CDR_CFG2, DXDSCAL_CYCLES, 27, 3)
    FIELD(CH3_RX_CDR_CFG2, DXDSCAL_DS_EN, 26, 1)
    FIELD(CH3_RX_CDR_CFG2, DXDSCAL_DX_EN, 25, 1)
    FIELD(CH3_RX_CDR_CFG2, RX_DCC_DONE_BYP, 24, 1)
    FIELD(CH3_RX_CDR_CFG2, VOTEWX, 13, 3)
    FIELD(CH3_RX_CDR_CFG2, VOTEWY, 10, 3)
    FIELD(CH3_RX_CDR_CFG2, PMULFAC, 7, 3)
    FIELD(CH3_RX_CDR_CFG2, PDIVFAC, 4, 3)
    FIELD(CH3_RX_CDR_CFG2, FDIVFAC, 0, 4)
REG32(CH3_RX_CDR_CFG3, 0x3cc4)
    FIELD(CH3_RX_CDR_CFG3, PMULFACDYNTARGET, 24, 8)
    FIELD(CH3_RX_CDR_CFG3, PMULFACDYNSEL, 22, 2)
    FIELD(CH3_RX_CDR_CFG3, PMULFACDYNEN, 21, 1)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQFAC3, 19, 2)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQCNT3, 16, 3)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQFAC2, 14, 2)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQCNT2, 11, 3)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQFAC1, 9, 2)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQCNT1, 6, 3)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQFAC0, 4, 2)
    FIELD(CH3_RX_CDR_CFG3, PMULSEQCNT0, 1, 3)
    FIELD(CH3_RX_CDR_CFG3, PMULFACSEQEN, 0, 1)
REG32(CH3_RX_CDR_CFG4, 0x3cc8)
    FIELD(CH3_RX_CDR_CFG4, METASTABLE_MODE, 29, 2)
    FIELD(CH3_RX_CDR_CFG4, BMCDR_MISC, 27, 2)
    FIELD(CH3_RX_CDR_CFG4, BMCDR_MAG, 22, 5)
    FIELD(CH3_RX_CDR_CFG4, BMCDR_WINDOW, 18, 4)
    FIELD(CH3_RX_CDR_CFG4, BMCDR_MODE, 16, 2)
    FIELD(CH3_RX_CDR_CFG4, FORCEFOS, 15, 1)
    FIELD(CH3_RX_CDR_CFG4, FOSCNT, 12, 3)
    FIELD(CH3_RX_CDR_CFG4, FOSVAL, 0, 12)
REG32(CH3_ADAPT_APT_CFG, 0x3ccc)
REG32(CH3_ADAPT_CAL_CFG, 0x3cd0)
    FIELD(CH3_ADAPT_CAL_CFG, OVWRFNSH, 31, 1)
    FIELD(CH3_ADAPT_CAL_CFG, OVWRDAC, 25, 6)
    FIELD(CH3_ADAPT_CAL_CFG, OVWRADD, 21, 4)
    FIELD(CH3_ADAPT_CAL_CFG, OVWRPLS0, 20, 1)
    FIELD(CH3_ADAPT_CAL_CFG, OVWRSKIP, 19, 1)
    FIELD(CH3_ADAPT_CAL_CFG, SEQMAX, 16, 3)
    FIELD(CH3_ADAPT_CAL_CFG, WAITSEL, 14, 2)
    FIELD(CH3_ADAPT_CAL_CFG, MSHIFT, 11, 3)
    FIELD(CH3_ADAPT_CAL_CFG, CAL_INITDAC, 5, 6)
    FIELD(CH3_ADAPT_CAL_CFG, CALSKIP, 4, 1)
    FIELD(CH3_ADAPT_CAL_CFG, TESTCON, 1, 3)
    FIELD(CH3_ADAPT_CAL_CFG, CAL_CFG0, 0, 1)
REG32(CH3_ADAPT_DFE_CFG, 0x3cd4)
    FIELD(CH3_ADAPT_DFE_CFG, TRGTCON, 30, 2)
    FIELD(CH3_ADAPT_DFE_CFG, DFE_CFG1, 29, 1)
    FIELD(CH3_ADAPT_DFE_CFG, H3INITDAC, 23, 6)
    FIELD(CH3_ADAPT_DFE_CFG, H2INITDAC, 16, 7)
    FIELD(CH3_ADAPT_DFE_CFG, DFE_CFG0, 15, 1)
    FIELD(CH3_ADAPT_DFE_CFG, UTINITDAC, 7, 8)
    FIELD(CH3_ADAPT_DFE_CFG, VPINITDAC, 0, 7)
REG32(CH3_ADAPT_GC_CFG0, 0x3cd8)
    FIELD(CH3_ADAPT_GC_CFG0, GC_CFG01, 31, 1)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_DISFREZ, 30, 1)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_CYCSEL, 28, 2)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_DIFFSEL, 26, 2)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_CLRSEL, 24, 2)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_ENSEL, 22, 2)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_INITDAC, 17, 5)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_SELTGT, 16, 1)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_GEARSEL, 14, 2)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_GAINWIN, 12, 2)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_CNTSEL, 9, 3)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_MSHIFT, 5, 4)
    FIELD(CH3_ADAPT_GC_CFG0, AGC1_WAITSEL, 3, 2)
    FIELD(CH3_ADAPT_GC_CFG0, GC_CFG00, 0, 3)
REG32(CH3_ADAPT_GC_CFG1, 0x3cdc)
    FIELD(CH3_ADAPT_GC_CFG1, AGC1_HYSTER, 25, 7)
    FIELD(CH3_ADAPT_GC_CFG1, AGC1_TARGET, 17, 8)
    FIELD(CH3_ADAPT_GC_CFG1, GC_CFG10, 10, 7)
    FIELD(CH3_ADAPT_GC_CFG1, AGC1_UPBDAC, 5, 5)
    FIELD(CH3_ADAPT_GC_CFG1, AGC1_LOBDAC, 0, 5)
REG32(CH3_ADAPT_GC_CFG2, 0x3ce0)
    FIELD(CH3_ADAPT_GC_CFG2, GC_CFG22, 31, 1)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_DISFREZ, 30, 1)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_CYCSEL, 28, 2)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_DIFFSEL, 26, 2)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_CLRSEL, 24, 2)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_ENSEL, 22, 2)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_INITDAC, 17, 5)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_SELTGT, 16, 1)
    FIELD(CH3_ADAPT_GC_CFG2, GC_CFG21, 9, 7)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_MSHIFT, 5, 4)
    FIELD(CH3_ADAPT_GC_CFG2, AGC2_WAITSEL, 3, 2)
    FIELD(CH3_ADAPT_GC_CFG2, GC_CFG20, 0, 3)
REG32(CH3_ADAPT_GC_CFG3, 0x3ce4)
    FIELD(CH3_ADAPT_GC_CFG3, AGC2_HYSTER, 25, 7)
    FIELD(CH3_ADAPT_GC_CFG3, AGC2_TARGET, 17, 8)
    FIELD(CH3_ADAPT_GC_CFG3, GC_CFG30, 10, 7)
    FIELD(CH3_ADAPT_GC_CFG3, AGC2_UPBDAC, 5, 5)
    FIELD(CH3_ADAPT_GC_CFG3, AGC2_LOBDAC, 0, 5)
REG32(CH3_ADAPT_GEN_CFG0, 0x3ce8)
    FIELD(CH3_ADAPT_GEN_CFG0, PCSFLIP, 31, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, BAUDFLIP, 30, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, POWRDN, 29, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, CALCKON, 28, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, GE_CFG00, 27, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, CDRLOCK_DET1_DISLOOP, 26, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, CDRLOCK_DET0_DISLOOP, 25, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, CDRLOCK_DIS_DISLOOP, 24, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, OS_DISLOOP, 23, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, GC2_DISLOOP, 22, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, GC1_DISLOOP, 21, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, KLTUNE_DISLOOP, 20, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, KL_DISLOOP, 19, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, KHCLOAD_DISLOOP, 18, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, KHRDEG_DISLOOP, 17, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, KHCDEG_DISLOOP, 16, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, HF_DISLOOP, 15, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, HE_DISLOOP, 14, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, HD_DISLOOP, 13, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, HC_DISLOOP, 12, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, HB_DISLOOP, 11, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, HA_DISLOOP, 10, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H9_DISLOOP, 9, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H8_DISLOOP, 8, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H7_DISLOOP, 7, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H6_DISLOOP, 6, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H5_DISLOOP, 5, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H4_DISLOOP, 4, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H3_DISLOOP, 3, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, H2_DISLOOP, 2, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, UT_DISLOOP, 1, 1)
    FIELD(CH3_ADAPT_GEN_CFG0, VP_DISLOOP, 0, 1)
REG32(CH3_ADAPT_GEN_CFG1, 0x3cec)
    FIELD(CH3_ADAPT_GEN_CFG1, SELHALF, 31, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, TESTC, 27, 4)
    FIELD(CH3_ADAPT_GEN_CFG1, CDRLOCK_DET1_POWRDN, 26, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, CDRLOCK_DET0_POWRDN, 25, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, CDRLOCK_DIS_POWRDN, 24, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, OS_POWRDN, 23, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, GC2_POWRDN, 22, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, GC1_POWRDN, 21, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, KLTUNE_POWRDN, 20, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, KL_POWRDN, 19, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, KHCLOAD_POWRDN, 18, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, KHRDEG_POWRDN, 17, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, KHCDEG_POWRDN, 16, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, HF_POWRDN, 15, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, HE_POWRDN, 14, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, HD_POWRDN, 13, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, HC_POWRDN, 12, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, HB_POWRDN, 11, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, HA_POWRDN, 10, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H9_POWRDN, 9, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H8_POWRDN, 8, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H7_POWRDN, 7, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H6_POWRDN, 6, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H5_POWRDN, 5, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H4_POWRDN, 4, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H3_POWRDN, 3, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, H2_POWRDN, 2, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, UT_POWRDN, 1, 1)
    FIELD(CH3_ADAPT_GEN_CFG1, VP_POWRDN, 0, 1)
REG32(CH3_ADAPT_GEN_CFG2, 0x3cf0)
    FIELD(CH3_ADAPT_GEN_CFG2, APTCTRL2, 31, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, MODSEL, 29, 2)
    FIELD(CH3_ADAPT_GEN_CFG2, SELCDR, 28, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, DISDYN, 27, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, CDRLOCK_DET1_EXHOLD, 26, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, CDRLOCK_DET0_EXHOLD, 25, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, CDRLOCK_DIS_EXHOLD, 24, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, OS_EXHOLD, 23, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, GC2_EXHOLD, 22, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, GC1_EXHOLD, 21, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, KLTUNE_EXHOLD, 20, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, KL_EXHOLD, 19, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, KHCLOAD_EXHOLD, 18, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, KHRDEG_EXHOLD, 17, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, KHCDEG_EXHOLD, 16, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, HF_EXHOLD, 15, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, HE_EXHOLD, 14, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, HD_EXHOLD, 13, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, HC_EXHOLD, 12, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, HB_EXHOLD, 11, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, HA_EXHOLD, 10, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H9_EXHOLD, 9, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H8_EXHOLD, 8, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H7_EXHOLD, 7, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H6_EXHOLD, 6, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H5_EXHOLD, 5, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H4_EXHOLD, 4, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H3_EXHOLD, 3, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, H2_EXHOLD, 2, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, UT_EXHOLD, 1, 1)
    FIELD(CH3_ADAPT_GEN_CFG2, VP_EXHOLD, 0, 1)
REG32(CH3_ADAPT_GEN_CFG3, 0x3cf4)
    FIELD(CH3_ADAPT_GEN_CFG3, GEAREN, 31, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, GEARCTRL, 27, 4)
    FIELD(CH3_ADAPT_GEN_CFG3, CDRLOCK_DET1_OVWREN, 26, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, CDRLOCK_DET0_OVWREN, 25, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, CDRLOCK_DIS_OVWREN, 24, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, OS_OVWREN, 23, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, GC2_OVWREN, 22, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, GC1_OVWREN, 21, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, KLTUNE_OVWREN, 20, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, KL_OVWREN, 19, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, KHCLOAD_OVWREN, 18, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, KHRDEG_OVWREN, 17, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, KHCDEG_OVWREN, 16, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, HF_OVWREN, 15, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, HE_OVWREN, 14, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, HD_OVWREN, 13, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, HC_OVWREN, 12, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, HB_OVWREN, 11, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, HA_OVWREN, 10, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H9_OVWREN, 9, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H8_OVWREN, 8, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H7_OVWREN, 7, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H6_OVWREN, 6, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H5_OVWREN, 5, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H4_OVWREN, 4, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H3_OVWREN, 3, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, H2_OVWREN, 2, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, UT_OVWREN, 1, 1)
    FIELD(CH3_ADAPT_GEN_CFG3, VP_OVWREN, 0, 1)
REG32(CH3_ADAPT_H01_CFG, 0x3cf8)
    FIELD(CH3_ADAPT_H01_CFG, UT_CFG1, 27, 5)
    FIELD(CH3_ADAPT_H01_CFG, UT_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_H01_CFG, UT_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_H01_CFG, UT_ENSYNC, 20, 1)
    FIELD(CH3_ADAPT_H01_CFG, UT_CFG0, 16, 4)
    FIELD(CH3_ADAPT_H01_CFG, VP_CFG1, 11, 5)
    FIELD(CH3_ADAPT_H01_CFG, VP_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_H01_CFG, VP_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_H01_CFG, VP_ENSYNCH, 4, 1)
    FIELD(CH3_ADAPT_H01_CFG, VP_ENSYNCL, 3, 1)
    FIELD(CH3_ADAPT_H01_CFG, VP_CFG0, 0, 3)
REG32(CH3_ADAPT_H23_CFG, 0x3cfc)
    FIELD(CH3_ADAPT_H23_CFG, H3_CFG1, 27, 5)
    FIELD(CH3_ADAPT_H23_CFG, H3_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_H23_CFG, H3_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_H23_CFG, TESTC1, 16, 5)
    FIELD(CH3_ADAPT_H23_CFG, H2_CFG1, 11, 5)
    FIELD(CH3_ADAPT_H23_CFG, H2_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_H23_CFG, H2_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_H23_CFG, TESTC0, 0, 5)
REG32(CH3_ADAPT_H45_CFG, 0x3d00)
    FIELD(CH3_ADAPT_H45_CFG, H5_INITDAC, 27, 5)
    FIELD(CH3_ADAPT_H45_CFG, H5_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_H45_CFG, H5_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_H45_CFG, UTCOEFF, 16, 5)
    FIELD(CH3_ADAPT_H45_CFG, H4_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_H45_CFG, H4_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_H45_CFG, H4_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_H45_CFG, TESTC21, 3, 2)
    FIELD(CH3_ADAPT_H45_CFG, TESTC20, 0, 3)
REG32(CH3_ADAPT_H67_CFG, 0x3d04)
    FIELD(CH3_ADAPT_H67_CFG, H7_INITDAC, 27, 5)
    FIELD(CH3_ADAPT_H67_CFG, H7_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_H67_CFG, H7_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_H67_CFG, H3COEFF, 16, 5)
    FIELD(CH3_ADAPT_H67_CFG, H6_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_H67_CFG, H6_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_H67_CFG, H6_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_H67_CFG, H2COEFF, 0, 5)
REG32(CH3_ADAPT_H89_CFG, 0x3d08)
    FIELD(CH3_ADAPT_H89_CFG, H9_INITDAC, 27, 5)
    FIELD(CH3_ADAPT_H89_CFG, H9_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_H89_CFG, H9_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_H89_CFG, H9_CFG1, 16, 5)
    FIELD(CH3_ADAPT_H89_CFG, H8_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_H89_CFG, H8_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_H89_CFG, H8_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_H89_CFG, H8_CFG1, 0, 5)
REG32(CH3_ADAPT_HAB_CFG, 0x3d0c)
    FIELD(CH3_ADAPT_HAB_CFG, HB_INITDAC, 27, 5)
    FIELD(CH3_ADAPT_HAB_CFG, HB_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_HAB_CFG, HB_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_HAB_CFG, HB_CFG1, 16, 5)
    FIELD(CH3_ADAPT_HAB_CFG, HA_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_HAB_CFG, HA_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_HAB_CFG, HA_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_HAB_CFG, HA_CFG1, 0, 5)
REG32(CH3_ADAPT_HCD_CFG, 0x3d10)
    FIELD(CH3_ADAPT_HCD_CFG, HD_INITDAC, 27, 5)
    FIELD(CH3_ADAPT_HCD_CFG, HD_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_HCD_CFG, HD_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_HCD_CFG, HD_CFG1, 16, 5)
    FIELD(CH3_ADAPT_HCD_CFG, HC_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_HCD_CFG, HC_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_HCD_CFG, HC_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_HCD_CFG, HC_CFG1, 0, 5)
REG32(CH3_ADAPT_HEF_CFG, 0x3d14)
    FIELD(CH3_ADAPT_HEF_CFG, HF_INITDAC, 27, 5)
    FIELD(CH3_ADAPT_HEF_CFG, HF_MSHIFT, 23, 4)
    FIELD(CH3_ADAPT_HEF_CFG, HF_WAITSEL, 21, 2)
    FIELD(CH3_ADAPT_HEF_CFG, HE_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_HEF_CFG, HE_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_HEF_CFG, HE_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_HEF_CFG, HE_CFG1, 0, 5)
REG32(CH3_ADAPT_KH_CFG0, 0x3d18)
    FIELD(CH3_ADAPT_KH_CFG0, KHCDEG_UTVPRATIO, 24, 8)
    FIELD(CH3_ADAPT_KH_CFG0, KHCDEG_HYSTERSIS, 16, 8)
    FIELD(CH3_ADAPT_KH_CFG0, KHCDEG_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_KH_CFG0, KHCDEG_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_KH_CFG0, WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_KH_CFG0, KH_CFG00, 0, 5)
REG32(CH3_ADAPT_KH_CFG1, 0x3d1c)
    FIELD(CH3_ADAPT_KH_CFG1, KH_CFG10, 7, 25)
    FIELD(CH3_ADAPT_KH_CFG1, KHCDEG_TARGET, 0, 7)
REG32(CH3_ADAPT_KH_CFG2, 0x3d20)
    FIELD(CH3_ADAPT_KH_CFG2, KH_CFG21, 15, 17)
    FIELD(CH3_ADAPT_KH_CFG2, KHRDEG_INITDAC, 11, 4)
    FIELD(CH3_ADAPT_KH_CFG2, KHRDEG_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_KH_CFG2, KHRDEG_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_KH_CFG2, KH_CFG20, 0, 5)
REG32(CH3_ADAPT_KH_CFG3, 0x3d24)
REG32(CH3_ADAPT_KH_CFG4, 0x3d28)
    FIELD(CH3_ADAPT_KH_CFG4, KH_CFG41, 16, 16)
    FIELD(CH3_ADAPT_KH_CFG4, KHCLOAD_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_KH_CFG4, KHCLOAD_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_KH_CFG4, WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_KH_CFG4, KH_CFG40, 0, 5)
REG32(CH3_ADAPT_KH_CFG5, 0x3d2c)
REG32(CH3_ADAPT_KL_CFG0, 0x3d30)
    FIELD(CH3_ADAPT_KL_CFG0, KL_CFG01, 16, 16)
    FIELD(CH3_ADAPT_KL_CFG0, KL_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_KL_CFG0, KL_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_KL_CFG0, KL_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_KL_CFG0, KL_CFG00, 0, 5)
REG32(CH3_ADAPT_KL_CFG1, 0x3d34)
    FIELD(CH3_ADAPT_KL_CFG1, KL_CFG11, 16, 16)
    FIELD(CH3_ADAPT_KL_CFG1, KLTUNE_INITDAC, 11, 5)
    FIELD(CH3_ADAPT_KL_CFG1, KLTUNE_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_KL_CFG1, KLTUNE_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_KL_CFG1, KL_CFG10, 0, 5)
REG32(CH3_ADAPT_LCK_CFG0, 0x3d38)
    FIELD(CH3_ADAPT_LCK_CFG0, LCK_CFG0, 30, 2)
    FIELD(CH3_ADAPT_LCK_CFG0, THRD, 24, 6)
    FIELD(CH3_ADAPT_LCK_CFG0, OUTLCKDIS, 23, 1)
    FIELD(CH3_ADAPT_LCK_CFG0, GAIN2, 19, 4)
    FIELD(CH3_ADAPT_LCK_CFG0, GAIN0, 16, 3)
    FIELD(CH3_ADAPT_LCK_CFG0, GAIN1, 12, 4)
    FIELD(CH3_ADAPT_LCK_CFG0, CDRLCK0_INITSEL, 0, 12)
REG32(CH3_ADAPT_LCK_CFG1, 0x3d3c)
    FIELD(CH3_ADAPT_LCK_CFG1, TESTC, 29, 3)
    FIELD(CH3_ADAPT_LCK_CFG1, ENLOSS, 28, 1)
    FIELD(CH3_ADAPT_LCK_CFG1, ENLCK1, 27, 1)
    FIELD(CH3_ADAPT_LCK_CFG1, ENLCK0, 26, 1)
    FIELD(CH3_ADAPT_LCK_CFG1, LCK_CFG10, 21, 5)
    FIELD(CH3_ADAPT_LCK_CFG1, FORCELOW, 20, 1)
    FIELD(CH3_ADAPT_LCK_CFG1, SELCON, 17, 3)
    FIELD(CH3_ADAPT_LCK_CFG1, DETECTEN, 16, 1)
    FIELD(CH3_ADAPT_LCK_CFG1, LCKCTRVAL, 12, 4)
    FIELD(CH3_ADAPT_LCK_CFG1, LOSSSEL, 0, 12)
REG32(CH3_ADAPT_LCK_CFG2, 0x3d40)
    FIELD(CH3_ADAPT_LCK_CFG2, LCK_CFG20, 25, 7)
    FIELD(CH3_ADAPT_LCK_CFG2, FIX_PPM, 24, 1)
    FIELD(CH3_ADAPT_LCK_CFG2, TESTCON, 20, 4)
    FIELD(CH3_ADAPT_LCK_CFG2, UD_CYCLEU, 16, 4)
    FIELD(CH3_ADAPT_LCK_CFG2, UD_CYCLEL, 0, 16)
REG32(CH3_ADAPT_LCK_CFG3, 0x3d44)
REG32(CH3_ADAPT_LOP_CFG, 0x3d48)
    FIELD(CH3_ADAPT_LOP_CFG, ENDNOD, 29, 3)
    FIELD(CH3_ADAPT_LOP_CFG, PREVSEL, 25, 4)
    FIELD(CH3_ADAPT_LOP_CFG, DFEOSWTX, 22, 3)
    FIELD(CH3_ADAPT_LOP_CFG, DFEOSWTY, 19, 3)
    FIELD(CH3_ADAPT_LOP_CFG, SWCLKP1, 18, 1)
    FIELD(CH3_ADAPT_LOP_CFG, SWCLKP0, 17, 1)
    FIELD(CH3_ADAPT_LOP_CFG, SELWIDTH, 16, 1)
    FIELD(CH3_ADAPT_LOP_CFG, DRP_WIDTH, 13, 3)
    FIELD(CH3_ADAPT_LOP_CFG, NEXTDC, 12, 1)
    FIELD(CH3_ADAPT_LOP_CFG, INVTBIT, 11, 1)
    FIELD(CH3_ADAPT_LOP_CFG, SWCLKSEL, 9, 2)
    FIELD(CH3_ADAPT_LOP_CFG, LOP_CFG0, 7, 2)
    FIELD(CH3_ADAPT_LOP_CFG, BLKOUTC, 5, 2)
    FIELD(CH3_ADAPT_LOP_CFG, DUL_TESTCON, 0, 5)
REG32(CH3_ADAPT_OS_CFG, 0x3d4c)
    FIELD(CH3_ADAPT_OS_CFG, OS_INITDAC, 25, 7)
    FIELD(CH3_ADAPT_OS_CFG, OS_CFG1, 11, 14)
    FIELD(CH3_ADAPT_OS_CFG, OS_MSHIFT, 7, 4)
    FIELD(CH3_ADAPT_OS_CFG, OS_WAITSEL, 5, 2)
    FIELD(CH3_ADAPT_OS_CFG, OS_CFG0, 0, 5)
REG32(CH3_RX_CRC_CFG0, 0x3d50)
    FIELD(CH3_RX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH3_RX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH3_RX_CRC_CFG0, CORRECTION_EN, 7, 1)
    FIELD(CH3_RX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH3_RX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH3_RX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH3_RX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH3_RX_CRC_CFG0, INPUT_BYTE_ORDER, 1, 1)
    FIELD(CH3_RX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH3_RX_CRC_CFG1, 0x3d54)
REG32(CH3_RX_CRC_CFG2, 0x3d58)
REG32(CH3_RX_CRC_CFG3, 0x3d5c)
REG32(CH3_TX_CRC_CFG0, 0x3d60)
    FIELD(CH3_TX_CRC_CFG0, SOP4_CONTROL_WORD, 16, 16)
    FIELD(CH3_TX_CRC_CFG0, SOP_CONTROL_WORD, 8, 8)
    FIELD(CH3_TX_CRC_CFG0, SOP_DETECT_MODE, 6, 1)
    FIELD(CH3_TX_CRC_CFG0, BYTE_MODE, 4, 2)
    FIELD(CH3_TX_CRC_CFG0, CHECKSUM_PACK_MODE, 3, 1)
    FIELD(CH3_TX_CRC_CFG0, CRC_MODE, 2, 1)
    FIELD(CH3_TX_CRC_CFG0, OUTPUT_BYTE_ORDER, 1, 1)
    FIELD(CH3_TX_CRC_CFG0, CRC_EN, 0, 1)
REG32(CH3_TX_CRC_CFG1, 0x3d64)
REG32(CH3_TX_CRC_CFG2, 0x3d68)
REG32(CH3_TX_CRC_CFG3, 0x3d6c)
REG32(CH3_DA_CFG, 0x3d70)
    FIELD(CH3_DA_CFG, TX_DA_AMP_CTRL_FORCE, 31, 1)
    FIELD(CH3_DA_CFG, TX_DA_AMP_CTRL, 27, 4)
    FIELD(CH3_DA_CFG, TX_DA_SPARE, 20, 7)
    FIELD(CH3_DA_CFG, TX_DA_REFCLK_SEL, 19, 1)
    FIELD(CH3_DA_CFG, TX_DA_RANGE, 18, 1)
    FIELD(CH3_DA_CFG, TX_DA_ENOUT, 17, 1)
    FIELD(CH3_DA_CFG, TX_DA_PWRDNB, 16, 1)
    FIELD(CH3_DA_CFG, RX_DA_AMP_CTRL_FORCE, 15, 1)
    FIELD(CH3_DA_CFG, RX_DA_AMP_CTRL, 11, 4)
    FIELD(CH3_DA_CFG, RX_DA_SPARE, 4, 7)
    FIELD(CH3_DA_CFG, RX_DA_REFCLK_SEL, 3, 1)
    FIELD(CH3_DA_CFG, RX_DA_RANGE, 2, 1)
    FIELD(CH3_DA_CFG, RX_DA_ENOUT, 1, 1)
    FIELD(CH3_DA_CFG, RX_DA_PWRDNB, 0, 1)
REG32(CH3_RX_CTLE_CFG0, 0x3d74)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE1_PWRDN, 31, 1)
    FIELD(CH3_RX_CTLE_CFG0, RX_AGC1_CM_REF, 28, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE1_CM_REF, 25, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_AGC2_OCAP_CTRL, 22, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC2_OCAP, 21, 1)
    FIELD(CH3_RX_CTLE_CFG0, RX_AGC1_OCAP_CTRL, 18, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE_TUNE_OS, 16, 2)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE_EN_EXT_AGC1_OCAP, 15, 1)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE_CL_CAP_CTRL, 12, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE_CS_CAPCTRL, 9, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE_BIAS_CTRL, 6, 3)
    FIELD(CH3_RX_CTLE_CFG0, RX_AGC2_LOW_PWR, 4, 2)
    FIELD(CH3_RX_CTLE_CFG0, RX_AGC1_LOW_PWR, 2, 2)
    FIELD(CH3_RX_CTLE_CFG0, RX_CTLE1_LOW_PWR, 0, 2)
REG32(CH3_RX_CTLE_CFG1, 0x3d78)
    FIELD(CH3_RX_CTLE_CFG1, SWCLK_ELVL_OPT, 26, 1)
    FIELD(CH3_RX_CTLE_CFG1, BRCDR_VP_OPT, 25, 1)
    FIELD(CH3_RX_CTLE_CFG1, RCAL_OS_PAD, 19, 6)
    FIELD(CH3_RX_CTLE_CFG1, RX_AGC2_CURR_GAIN, 16, 3)
    FIELD(CH3_RX_CTLE_CFG1, RX_AGC1_CURR_GAIN, 13, 3)
    FIELD(CH3_RX_CTLE_CFG1, RX_CTLE1_CURR_GAIN, 10, 3)
    FIELD(CH3_RX_CTLE_CFG1, RX_AGC2_PWRDN, 9, 1)
    FIELD(CH3_RX_CTLE_CFG1, RX_AGC1_PWRDN, 8, 1)
    FIELD(CH3_RX_CTLE_CFG1, RX_CTLE_OS_PWRDN, 7, 1)
    FIELD(CH3_RX_CTLE_CFG1, RX_CTLE_SAP_SEL, 3, 4)
    FIELD(CH3_RX_CTLE_CFG1, RX_AGC2_CM_REF, 0, 3)
REG32(CH3_RX_DACI2V_CFG0, 0x3d7c)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_PD_BIAS_OS, 28, 1)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_PD_BIAS_DFE, 27, 1)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_VP_RANGE, 25, 2)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_VS_CODE, 18, 7)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_VS_NEG, 17, 1)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_VS_UT_SIGN, 16, 1)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_SEL_I2V_VCM, 13, 3)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_CFOK_RANGE, 11, 2)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_CFOK_EN, 10, 1)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_FILTER_EN, 9, 1)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_VS_RANGE, 7, 2)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_BIAS_DFE, 5, 2)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_BIAS_I2V, 3, 2)
    FIELD(CH3_RX_DACI2V_CFG0, DAC_BIAS_OS, 1, 2)
    FIELD(CH3_RX_DACI2V_CFG0, SUMMER_VCM_TESTMODE, 0, 1)
REG32(CH3_RX_DFE_CFG0, 0x3d80)
    FIELD(CH3_RX_DFE_CFG0, RX_DFE_YEN, 31, 1)
    FIELD(CH3_RX_DFE_CFG0, RX_VREG_PDB, 30, 1)
    FIELD(CH3_RX_DFE_CFG0, RX_VREG_VREFSEL, 28, 2)
    FIELD(CH3_RX_DFE_CFG0, RX_DES_CFG_BITS, 18, 10)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_EN_VCM_EVEN, 17, 1)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_LOW_POWER, 16, 1)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_VCM_TUNE, 12, 4)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_VCM_TUNE_OVWR, 11, 1)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_VREF_TUNE, 8, 3)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_IREF_TUNE, 4, 4)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_DEG_CTRL, 1, 3)
    FIELD(CH3_RX_DFE_CFG0, RX_SUM_DEG_AVTT_OVWR, 0, 1)
REG32(CH3_RX_MISC_CFG0, 0x3d84)
    FIELD(CH3_RX_MISC_CFG0, RX_VREG_CTRL, 28, 3)
    FIELD(CH3_RX_MISC_CFG0, RCAL_OS_CTLE, 22, 6)
    FIELD(CH3_RX_MISC_CFG0, RCAL_OS_AGC1, 16, 6)
    FIELD(CH3_RX_MISC_CFG0, SLICER_SARC_DIS, 15, 1)
    FIELD(CH3_RX_MISC_CFG0, RCAL_OS_AGC2, 9, 6)
    FIELD(CH3_RX_MISC_CFG0, RCAL_OS_SUM, 3, 6)
    FIELD(CH3_RX_MISC_CFG0, RX_LPM_EN, 2, 1)
    FIELD(CH3_RX_MISC_CFG0, BAUDRATE_MODE, 1, 1)
    FIELD(CH3_RX_MISC_CFG0, RX_XMODE_SEL, 0, 1)
REG32(CH3_CHL_RSV_CFG1, 0x3d88)
REG32(CH3_RX_PAD_CFG0, 0x3d8c)
    FIELD(CH3_RX_PAD_CFG0, LS_CTRL, 17, 15)
    FIELD(CH3_RX_PAD_CFG0, ACCAP_CMRES_EN, 16, 1)
    FIELD(CH3_RX_PAD_CFG0, ACCAP_CFG, 13, 3)
    FIELD(CH3_RX_PAD_CFG0, LSHIFT_EN, 12, 1)
    FIELD(CH3_RX_PAD_CFG0, ACCAP_EN, 11, 1)
    FIELD(CH3_RX_PAD_CFG0, RX_PAD_CFG0_SPARE, 0, 11)
REG32(CH3_RX_PAD_CFG1, 0x3d90)
    FIELD(CH3_RX_PAD_CFG1, RX_PAD_CFG1_SPARE, 30, 2)
    FIELD(CH3_RX_PAD_CFG1, RX_PKDET_EN, 29, 1)
    FIELD(CH3_RX_PAD_CFG1, RX_PKDET_CTRL, 25, 4)
    FIELD(CH3_RX_PAD_CFG1, OOB_VDIFF_INV, 24, 1)
    FIELD(CH3_RX_PAD_CFG1, OOB_SIG_VDIFF_SEL, 21, 3)
    FIELD(CH3_RX_PAD_CFG1, OOB_OVERRIDE, 19, 2)
    FIELD(CH3_RX_PAD_CFG1, OOB_PWRDN_B, 18, 1)
    FIELD(CH3_RX_PAD_CFG1, ACJTAG_EN, 17, 1)
    FIELD(CH3_RX_PAD_CFG1, QPI_EN, 16, 1)
    FIELD(CH3_RX_PAD_CFG1, MNTR_ACJTAG_EN, 15, 1)
    FIELD(CH3_RX_PAD_CFG1, ACJTAG_VD_SEL0, 14, 1)
    FIELD(CH3_RX_PAD_CFG1, ACJTAG_VC_SEL0, 13, 1)
    FIELD(CH3_RX_PAD_CFG1, MNTR_ACJTAG_RESETB, 12, 1)
    FIELD(CH3_RX_PAD_CFG1, MNTR_ACJTAG_ACMODE, 11, 1)
    FIELD(CH3_RX_PAD_CFG1, PROG_OPAMPPD_EN, 10, 1)
    FIELD(CH3_RX_PAD_CFG1, CM_BUFF_CFG, 6, 4)
    FIELD(CH3_RX_PAD_CFG1, RTERM_VCOM_MODE, 4, 2)
    FIELD(CH3_RX_PAD_CFG1, RTERM_VCOM_LVL, 0, 4)
REG32(CH3_RX_PCS_CFG0, 0x3d94)
    FIELD(CH3_RX_PCS_CFG0, RX_ALIGN_MCOMMA_DET, 31, 1)
    FIELD(CH3_RX_PCS_CFG0, RX_ALIGN_PCOMMA_DET, 30, 1)
    FIELD(CH3_RX_PCS_CFG0, RX_ALIGN_MCOMMA_VAL, 20, 10)
    FIELD(CH3_RX_PCS_CFG0, RX_ALIGN_PCOMMA_VAL, 10, 10)
    FIELD(CH3_RX_PCS_CFG0, RX_INT_DATA_WIDTH, 7, 2)
    FIELD(CH3_RX_PCS_CFG0, RX_DATA_WIDTH, 3, 4)
    FIELD(CH3_RX_PCS_CFG0, RX_MCOMMA_ALIGNEN, 2, 1)
    FIELD(CH3_RX_PCS_CFG0, RX_PCOMMA_ALIGNEN, 1, 1)
    FIELD(CH3_RX_PCS_CFG0, RX_COMMADETEN, 0, 1)
REG32(CH3_RX_PCS_CFG1, 0x3d98)
    FIELD(CH3_RX_PCS_CFG1, RX_FABRIC_DATA_SEL, 29, 3)
    FIELD(CH3_RX_PCS_CFG1, RX_FIFO_DATA_SEL, 26, 3)
    FIELD(CH3_RX_PCS_CFG1, RX_SIG_VALID_DLY, 21, 5)
    FIELD(CH3_RX_PCS_CFG1, RX_SLIDE_MODE, 19, 2)
    FIELD(CH3_RX_PCS_CFG1, RX_SHOW_REALIGN_COMMA, 18, 1)
    FIELD(CH3_RX_PCS_CFG1, RX_SLIDE_AUTO_WAIT, 14, 4)
    FIELD(CH3_RX_PCS_CFG1, RX_ALIGN_COMMA_WORD, 11, 3)
    FIELD(CH3_RX_PCS_CFG1, RX_ALIGN_COMMA_DOUBLE, 10, 1)
    FIELD(CH3_RX_PCS_CFG1, RX_ALIGN_COMMA_ENABLE, 0, 10)
REG32(CH3_RX_PCS_CFG2, 0x3d9c)
    FIELD(CH3_RX_PCS_CFG2, PCIE_USB_ERR_REP_DIS, 31, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_PHASE_BUFFER_USE, 30, 1)
    FIELD(CH3_RX_PCS_CFG2, RXBUF_RD_INIT_ADDR, 27, 3)
    FIELD(CH3_RX_PCS_CFG2, RXBUF_RXUSRCLK_REG_BYPASS, 26, 1)
    FIELD(CH3_RX_PCS_CFG2, RXBUF_ADDR_CFG, 25, 1)
    FIELD(CH3_RX_PCS_CFG2, START_SKP_SEL, 24, 1)
    FIELD(CH3_RX_PCS_CFG2, SIGVALID_EN_FOR_RXVALID, 23, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_EIEOS_PATTERN_SEL, 21, 2)
    FIELD(CH3_RX_PCS_CFG2, RX_BLKSYNC_MCP, 20, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_BLKSYNC_FTS, 19, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_CBCC_DATA_SEL, 18, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_DEC_VALID_COMMA, 17, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_DEC_MCOMMA_DET, 16, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_DEC_PCOMMA_DET, 15, 1)
    FIELD(CH3_RX_PCS_CFG2, RX_8B10B_EN, 14, 1)
    FIELD(CH3_RX_PCS_CFG2, EIOS_ERR_MASK_DIS, 13, 1)
    FIELD(CH3_RX_PCS_CFG2, SAMPLE_PERIOD, 10, 3)
    FIELD(CH3_RX_PCS_CFG2, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH3_RX_PCS_CFG2, USE_GB, 5, 1)
    FIELD(CH3_RX_PCS_CFG2, MODE, 0, 5)
REG32(CH3_RX_PCS_CFG3, 0x3da0)
    FIELD(CH3_RX_PCS_CFG3, RX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH3_RX_PCS_CFG3, RX_FIFO_STATUS_SEL, 30, 1)
    FIELD(CH3_RX_PCS_CFG3, DATA_RATE, 29, 1)
    FIELD(CH3_RX_PCS_CFG3, DATAPATH_CTRL, 26, 3)
    FIELD(CH3_RX_PCS_CFG3, CLAUSE_CTRL, 25, 1)
    FIELD(CH3_RX_PCS_CFG3, TEST_PATT_EN, 24, 1)
    FIELD(CH3_RX_PCS_CFG3, TESTDATA_PATT_SEL, 23, 1)
    FIELD(CH3_RX_PCS_CFG3, RXVALID_FORCE_RXVAL_COMDET, 20, 1)
    FIELD(CH3_RX_PCS_CFG3, RXVALID_EIOS_RESET_EN, 19, 1)
    FIELD(CH3_RX_PCS_CFG3, RXPHCLK_CYCLE_CNT_EN, 17, 1)
    FIELD(CH3_RX_PCS_CFG3, RXPRBS_LEAKYBUCKET_EN, 16, 1)
    FIELD(CH3_RX_PCS_CFG3, RXPRBS_LINK2RESEED_CNT, 8, 8)
    FIELD(CH3_RX_PCS_CFG3, RXPRBS_LINKACQ_CNT, 0, 8)
REG32(CH3_RX_PCS_CFG4, 0x3da4)
    FIELD(CH3_RX_PCS_CFG4, RXVALID_GEN_EN, 31, 1)
    FIELD(CH3_RX_PCS_CFG4, RXVALID_FORCE_SIGVALID, 30, 1)
    FIELD(CH3_RX_PCS_CFG4, RXVALID_K_NUM, 20, 10)
    FIELD(CH3_RX_PCS_CFG4, RXVALID_GOOD_DATA_NUM, 10, 10)
    FIELD(CH3_RX_PCS_CFG4, RXVALID_ERR_DATA_NUM, 0, 10)
REG32(CH3_CHCLK_MISC_CFG, 0x3da8)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_MONCLKCYCLE, 28, 3)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_PWRDNB, 27, 1)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_UNLOCKCTRL, 25, 2)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OW, 17, 8)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_FINE_SWEEP, 15, 2)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_ILOLOCKCOARSE, 13, 2)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_ILOLOCKFACTOR, 11, 2)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_PLLLOCKDETEN, 10, 1)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_CRS_ACCURACY, 8, 2)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_OVRD_MODE, 6, 2)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_FTL_TUNE_OWEN, 5, 1)
    FIELD(CH3_CHCLK_MISC_CFG, CHCLK_FBDIV_VAL, 0, 5)
REG32(CH3_CHCLK_ILO_CFG, 0x3dac)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OW, 28, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_VCTRL_FTL_EN_OWEN, 27, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OW, 26, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_VTOI_OWEN, 25, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OW, 24, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_ILO_INJDRV_PDB_OWEN, 23, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OW, 21, 2)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_ILO_MODE_TUNE_OWEN, 20, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_ILO_MODE_SPD, 19, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_CLKSRCMUX_SEL, 18, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_FTL_TUNE_OWEN, 16, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_VREG_CTRL, 12, 3)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_VCTRL_OW, 6, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_BIAS, 5, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_VCTRL_EXT, 4, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_VBUF, 2, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_FTL, 1, 1)
    FIELD(CH3_CHCLK_ILO_CFG, CHCLK_PDB_VREG, 0, 1)
REG32(CH3_CHCLK_RXPI_CFG, 0x3db0)
    FIELD(CH3_CHCLK_RXPI_CFG, PROGDIV_RX_DIV_PDB, 22, 1)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_STEP_BYP_EN, 21, 1)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_STEP_TWO_EN, 20, 1)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_SEL_VREG_SENSE, 19, 1)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_VREG_CTRL, 16, 3)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_BAND_SEL, 4, 2)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_S_PREBUF_EN, 3, 1)
    FIELD(CH3_CHCLK_RXPI_CFG, RXPI_PREBUF_EN, 2, 1)
REG32(CH3_CHCLK_RXCAL_CFG, 0x3db4)
    FIELD(CH3_CHCLK_RXCAL_CFG, DMON_SEL, 28, 4)
    FIELD(CH3_CHCLK_RXCAL_CFG, AUTO_MODE, 27, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, TWAIT_SEL, 25, 2)
    FIELD(CH3_CHCLK_RXCAL_CFG, CLKDIV_SEL, 22, 3)
    FIELD(CH3_CHCLK_RXCAL_CFG, TCYC_PER_CAL, 20, 2)
    FIELD(CH3_CHCLK_RXCAL_CFG, TEVAL_SEL, 18, 2)
    FIELD(CH3_CHCLK_RXCAL_CFG, TOS_SEL, 16, 2)
    FIELD(CH3_CHCLK_RXCAL_CFG, HYST_MODE, 14, 2)
    FIELD(CH3_CHCLK_RXCAL_CFG, DMON_EN, 13, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, RX_CAL_PD, 12, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, OVERRIDE_CODE_IDX, 9, 3)
    FIELD(CH3_CHCLK_RXCAL_CFG, FLIP_DIR_ANY, 8, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_RXPAD_OS, 7, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_AGC2_CM, 6, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_AGC1_CM, 5, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_CTLE_CM, 4, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_RXDCD_S, 3, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_RXDCD_X, 2, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG, SKIP_RXDCD_D, 1, 1)
REG32(CH3_CHCLK_RXCAL_CFG1, 0x3db8)
    FIELD(CH3_CHCLK_RXCAL_CFG1, OVERRIDE_EN, 7, 1)
    FIELD(CH3_CHCLK_RXCAL_CFG1, OVERRIDE_CODE, 0, 7)
REG32(CH3_CHCLK_TXPI_CFG0, 0x3dbc)
    FIELD(CH3_CHCLK_TXPI_CFG0, RSVD, 22, 10)
    FIELD(CH3_CHCLK_TXPI_CFG0, SARC_EN, 21, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_STEP_BYP_EN, 20, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TX_PROGCLK_SEL, 18, 2)
    FIELD(CH3_CHCLK_TXPI_CFG0, PROGDIV_TX_DIV_PDB, 17, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_STEP_TWO_EN, 16, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_VTUNE, 12, 4)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_VREG_NGATE_BST, 8, 4)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_BAND_SEL_RSV, 6, 2)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_BAND_SEL, 4, 2)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_PREBUF_EN, 3, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_BYPASS, 2, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TXPI_BYPASSMUX_PDB, 1, 1)
    FIELD(CH3_CHCLK_TXPI_CFG0, TX_PLLCLK_SEL, 0, 1)
REG32(CH3_CHCLK_TXCAL_CFG, 0x3dc0)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_EXHOLD, 26, 1)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_OVWREN, 25, 1)
    FIELD(CH3_CHCLK_TXCAL_CFG, TXCLK_TXCAL_FORCEREADY, 24, 1)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TIGHT, 23, 1)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_INITDAC, 16, 7)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACWIN, 14, 2)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_DACCHECK, 12, 2)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_THRESHSEL, 10, 2)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_MULSEL, 7, 3)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_FLIPDIR, 6, 1)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_CALEN, 5, 1)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTSEL, 1, 4)
    FIELD(CH3_CHCLK_TXCAL_CFG, CHCLK_TXCAL_TESTEN, 0, 1)
REG32(CH3_CHCLK_RXCAL_CFG2, 0x3dc4)
REG32(CH3_CHCLK_RSV_CFG, 0x3dc8)
REG32(CH3_PIPE_TX_EQ_CFG0, 0x3dcc)
    FIELD(CH3_PIPE_TX_EQ_CFG0, TX_MAINCURSOR_SEL, 30, 1)
    FIELD(CH3_PIPE_TX_EQ_CFG0, TX_DRIVE_MODE, 28, 2)
    FIELD(CH3_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_3, 21, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_2, 14, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_1, 7, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG0, TX_MARGIN_FULL_0, 0, 7)
REG32(CH3_PIPE_TX_EQ_CFG1, 0x3dd0)
    FIELD(CH3_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_2, 21, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_1, 14, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG1, TX_MARGIN_LOW_0, 7, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG1, TX_MARGIN_FULL_4, 0, 7)
REG32(CH3_PIPE_TX_EQ_CFG2, 0x3dd4)
    FIELD(CH3_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_4, 7, 7)
    FIELD(CH3_PIPE_TX_EQ_CFG2, TX_MARGIN_LOW_3, 0, 7)
REG32(CH3_PIPE_TX_EQ_CFG3, 0x3dd8)
    FIELD(CH3_PIPE_TX_EQ_CFG3, TX_DEEMPH_3, 15, 5)
    FIELD(CH3_PIPE_TX_EQ_CFG3, TX_DEEMPH_2, 10, 5)
    FIELD(CH3_PIPE_TX_EQ_CFG3, TX_DEEMPH_1, 5, 5)
    FIELD(CH3_PIPE_TX_EQ_CFG3, TX_DEEMPH_0, 0, 5)
REG32(CH3_TX_PCS_CFG0, 0x3ddc)
    FIELD(CH3_TX_PCS_CFG0, TX_PMA_DATA_SEL, 29, 3)
    FIELD(CH3_TX_PCS_CFG0, TXPMA_WIDTH_OVRD, 26, 3)
    FIELD(CH3_TX_PCS_CFG0, TX_INT_DATA_WIDTH, 24, 2)
    FIELD(CH3_TX_PCS_CFG0, TX_DATA_WIDTH, 20, 4)
    FIELD(CH3_TX_PCS_CFG0, TX_IDLE_DATA_ZERO, 19, 1)
    FIELD(CH3_TX_PCS_CFG0, TXPMA_WIDTH_OVRD_EN, 18, 1)
    FIELD(CH3_TX_PCS_CFG0, TX_8B10B_EN, 17, 1)
    FIELD(CH3_TX_PCS_CFG0, TX_8B10B_BYPASS, 13, 4)
    FIELD(CH3_TX_PCS_CFG0, SAMPLE_PERIOD, 10, 3)
    FIELD(CH3_TX_PCS_CFG0, FIFO_INIT_RD_ADDR, 6, 4)
    FIELD(CH3_TX_PCS_CFG0, USE_GB, 5, 1)
    FIELD(CH3_TX_PCS_CFG0, MODE, 0, 5)
REG32(CH3_TX_PCS_CFG1, 0x3de0)
    FIELD(CH3_TX_PCS_CFG1, TX_PRBS_FORCE_MODE, 31, 1)
    FIELD(CH3_TX_PCS_CFG1, RXPRBS_ERR_LOOPBACK, 30, 1)
    FIELD(CH3_TX_PCS_CFG1, TX_PRBS_USERPATTERN2, 20, 10)
    FIELD(CH3_TX_PCS_CFG1, TX_PRBS_USERPATTERN1, 10, 10)
    FIELD(CH3_TX_PCS_CFG1, TX_PRBS_USERPATTERN0, 0, 10)
REG32(CH3_TX_PCS_CFG2, 0x3de4)
    FIELD(CH3_TX_PCS_CFG2, TX_FIFO_STATUS_SEL, 31, 1)
    FIELD(CH3_TX_PCS_CFG2, TX_PRBS_USERPATTERN5, 20, 10)
    FIELD(CH3_TX_PCS_CFG2, TX_PRBS_USERPATTERN4, 10, 10)
    FIELD(CH3_TX_PCS_CFG2, TX_PRBS_USERPATTERN3, 0, 10)
REG32(CH3_TX_PCS_CFG3, 0x3de8)
    FIELD(CH3_TX_PCS_CFG3, TX_DEDICATED_CCIX_CHICO_PATH_EN, 31, 1)
    FIELD(CH3_TX_PCS_CFG3, TXBUF_TXPCSCLK_REG_BYPASS, 30, 1)
    FIELD(CH3_TX_PCS_CFG3, USB_LFPS_TPERIOD_ACCURATE, 29, 1)
    FIELD(CH3_TX_PCS_CFG3, USB_LFPS_TPERIOD, 25, 4)
    FIELD(CH3_TX_PCS_CFG3, TXBUF_WR_INIT_ADDR, 22, 3)
    FIELD(CH3_TX_PCS_CFG3, TXBUF_ADDR_CFG, 21, 1)
    FIELD(CH3_TX_PCS_CFG3, TX_PHASE_BUFFER_USE, 20, 1)
    FIELD(CH3_TX_PCS_CFG3, TX_PRBS_USERPATTERN7, 10, 10)
    FIELD(CH3_TX_PCS_CFG3, TX_PRBS_USERPATTERN6, 0, 10)
REG32(CH3_EYESCAN_CFG0, 0x3dec)
    FIELD(CH3_EYESCAN_CFG0, ES_SWAP_EN, 25, 1)
    FIELD(CH3_EYESCAN_CFG0, ES_ERRDET_EN, 24, 1)
    FIELD(CH3_EYESCAN_CFG0, ES_EYE_SCAN_EN, 23, 1)
    FIELD(CH3_EYESCAN_CFG0, ES_CONTROL, 17, 6)
    FIELD(CH3_EYESCAN_CFG0, ES_PRESCALE, 12, 5)
    FIELD(CH3_EYESCAN_CFG0, ES_HORZ_OFFSET, 0, 12)
REG32(CH3_EYESCAN_CFG1, 0x3df0)
REG32(CH3_EYESCAN_CFG2, 0x3df4)
REG32(CH3_EYESCAN_CFG3, 0x3df8)
REG32(CH3_EYESCAN_CFG4, 0x3dfc)
REG32(CH3_EYESCAN_CFG5, 0x3e00)
REG32(CH3_EYESCAN_CFG6, 0x3e04)
REG32(CH3_EYESCAN_CFG7, 0x3e08)
REG32(CH3_EYESCAN_CFG8, 0x3e0c)
REG32(CH3_EYESCAN_CFG9, 0x3e10)
REG32(CH3_EYESCAN_CFG10, 0x3e14)
REG32(CH3_EYESCAN_CFG11, 0x3e18)
REG32(CH3_EYESCAN_CFG12, 0x3e1c)
REG32(CH3_EYESCAN_CFG13, 0x3e20)
REG32(CH3_EYESCAN_CFG14, 0x3e24)
REG32(CH3_EYESCAN_CFG15, 0x3e28)
REG32(CH3_EYESCAN_CFG16, 0x3e2c)
    FIELD(CH3_EYESCAN_CFG16, RXPMA_WIDTH_OVRD_EN, 31, 1)
    FIELD(CH3_EYESCAN_CFG16, RXPMA_ADAP_WIDTH_OVRD, 27, 4)
    FIELD(CH3_EYESCAN_CFG16, RXPMA_CDR_WIDTH_OVRD, 23, 4)
    FIELD(CH3_EYESCAN_CFG16, RXPMA_DES_WIDTH_OVRD, 19, 4)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SAMPLE, 15, 1)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL2, 14, 1)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_CLK_PHASE_SEL, 13, 1)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_VS_UT_SIGN, 12, 1)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_VS_RANGE, 10, 2)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_VS_NEG_DIR, 9, 1)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_VS_CODE, 2, 7)
    FIELD(CH3_EYESCAN_CFG16, EYESCAN_VP_RANGE, 0, 2)
REG32(CH3_RX_ELASTIC_BUF_CFG0, 0x3e30)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_THRESH_OVRD, 31, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_REPEAT_WAIT, 26, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_UDFL_THRESH, 20, 6)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_OVFL_THRESH, 14, 6)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MAX_LAT, 8, 6)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_MIN_LAT, 2, 6)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, EB8B10B_CLK_COR_USE, 1, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG0, ELASTICBUF_8B10B_EN, 0, 1)
REG32(CH3_TX_10G_CFG0, 0x3e34)
REG32(CH3_TX_10G_CFG1, 0x3e38)
    FIELD(CH3_TX_10G_CFG1, DATAPATH_CTRL, 29, 2)
    FIELD(CH3_TX_10G_CFG1, TEST_PATT_EN, 28, 1)
    FIELD(CH3_TX_10G_CFG1, TEST_PATT_SEL, 27, 1)
    FIELD(CH3_TX_10G_CFG1, TESTDATA_PATT_SEL, 26, 1)
    FIELD(CH3_TX_10G_CFG1, TEST_PATT_SEEDA, 0, 26)
REG32(CH3_TX_10G_CFG2, 0x3e3c)
REG32(CH3_TX_10G_CFG3, 0x3e40)
    FIELD(CH3_TX_10G_CFG3, TEST_PATT_SEEDB, 0, 26)
REG32(CH3_RX_PHALIGN_CFG0, 0x3e44)
    FIELD(CH3_RX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH3_RX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH3_RX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH3_RX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH3_RX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH3_RX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH3_RX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH3_RX_PHALIGN_CFG0, RXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH3_RX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH3_RX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH3_RX_PHALIGN_CFG0, ALIGN_DMON_SEL, 5, 5)
    FIELD(CH3_RX_PHALIGN_CFG0, DA_WAIT_CYCLES, 0, 5)
REG32(CH3_RX_PHALIGN_CFG1, 0x3e48)
    FIELD(CH3_RX_PHALIGN_CFG1, SETINIT_PH_CNT, 27, 5)
    FIELD(CH3_RX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH3_RX_PHALIGN_CFG1, NUM_SAMPLES, 15, 5)
    FIELD(CH3_RX_PHALIGN_CFG1, SAMPLE_WAIT, 13, 2)
    FIELD(CH3_RX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 6, 7)
    FIELD(CH3_RX_PHALIGN_CFG1, MIN_THRESHOLD_OVRD, 5, 1)
    FIELD(CH3_RX_PHALIGN_CFG1, MAX_THRESHOLD_OVRD, 4, 1)
    FIELD(CH3_RX_PHALIGN_CFG1, CHAIN_MODE, 2, 2)
    FIELD(CH3_RX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 1, 1)
    FIELD(CH3_RX_PHALIGN_CFG1, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH3_RX_PHALIGN_CFG2, 0x3e4c)
    FIELD(CH3_RX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH3_RX_PHALIGN_CFG2, SLIP_EN_WID_PRE, 21, 4)
    FIELD(CH3_RX_PHALIGN_CFG2, SLIP_EN_WID_POST, 17, 4)
    FIELD(CH3_RX_PHALIGN_CFG2, SLIP_PULSE_WID_HI, 13, 4)
    FIELD(CH3_RX_PHALIGN_CFG2, SLIP_PULSE_WID_LO, 9, 4)
    FIELD(CH3_RX_PHALIGN_CFG2, SLIP_PULSE_SETTLE, 5, 4)
REG32(CH3_RX_PHALIGN_CFG3, 0x3e50)
    FIELD(CH3_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_CNT, 27, 5)
    FIELD(CH3_RX_PHALIGN_CFG3, MLDLY_SETINIT_PH_WAIT_CYCLE, 22, 5)
    FIELD(CH3_RX_PHALIGN_CFG3, MLDLY_NUM_SAMPLES, 15, 5)
    FIELD(CH3_RX_PHALIGN_CFG3, MLDLY_MIN_THRESHOLD_OVRD, 14, 1)
    FIELD(CH3_RX_PHALIGN_CFG3, MLDLY_MAX_THRESHOLD_OVRD, 13, 1)
    FIELD(CH3_RX_PHALIGN_CFG3, MLDLY_SAMPLE_WAIT, 11, 2)
    FIELD(CH3_RX_PHALIGN_CFG3, DAPICODE_OVRD, 3, 8)
    FIELD(CH3_RX_PHALIGN_CFG3, DMON_CLK_SEL, 0, 2)
REG32(CH3_RX_PHALIGN_CFG4, 0x3e54)
    FIELD(CH3_RX_PHALIGN_CFG4, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH3_RX_PHALIGN_CFG4, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH3_RX_PHALIGN_CFG4, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH3_RX_PHALIGN_CFG4, FINE_ALIGN_BYPASS, 12, 1)
    FIELD(CH3_RX_PHALIGN_CFG4, CLKSLIP_PAR_SAMPLES, 10, 2)
    FIELD(CH3_RX_PHALIGN_CFG4, CLKSLIP_NUM_SAMPLES, 5, 5)
    FIELD(CH3_RX_PHALIGN_CFG4, CLKSLIP_SAMPLES_WAIT, 0, 5)
REG32(CH3_RX_PHALIGN_CFG5, 0x3e58)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_UP_DOWN, 28, 2)
    FIELD(CH3_RX_PHALIGN_CFG5, CMN_FAB_CLK_PHALIGN_MODE, 26, 2)
    FIELD(CH3_RX_PHALIGN_CFG5, TX_BUFBYPASS_ML_NEGEDGE_MODE, 25, 1)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_BUFBYPASS_ML_NEGEDGE_MODE, 24, 1)
    FIELD(CH3_RX_PHALIGN_CFG5, TXPICODE_DDR_EN, 23, 1)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MODE, 22, 1)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_MAXCOUNT, 17, 5)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_ML_CDR_SLIP_WAITCYCLE, 14, 3)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_CDR_SLIP_DIR, 13, 1)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_CDR_SLIP_SAMPLE_COUNT, 11, 2)
    FIELD(CH3_RX_PHALIGN_CFG5, TX_BEACON_DLY_OPT_128B130B, 9, 2)
    FIELD(CH3_RX_PHALIGN_CFG5, TX_CLK_DLY_OPT_128B130B, 7, 2)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_BEACON_DLY_OPT_128B130B, 5, 2)
    FIELD(CH3_RX_PHALIGN_CFG5, RX_CLK_DLY_OPT_128B130B, 3, 2)
REG32(CH3_TX_PHALIGN_CFG0, 0x3e5c)
    FIELD(CH3_TX_PHALIGN_CFG0, DLY_ALIGN_EN, 31, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, PH_ALIGN_EN, 30, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, DAPI_ALIGN_DIR, 29, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, DAPI_BUFG_DIV, 19, 10)
    FIELD(CH3_TX_PHALIGN_CFG0, PHALIGN_MODE, 18, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, SYNC_MODE, 16, 2)
    FIELD(CH3_TX_PHALIGN_CFG0, SYNC_MULTI_LANE, 15, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, TXBUF_BYPASS_MODE, 14, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, BEACON_DLY_OPT, 12, 2)
    FIELD(CH3_TX_PHALIGN_CFG0, CLK_DLY_OPT, 10, 2)
    FIELD(CH3_TX_PHALIGN_CFG0, MIN_THRESHOLD_OVRD, 7, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, MAX_THRESHOLD_OVRD, 6, 1)
    FIELD(CH3_TX_PHALIGN_CFG0, ALIGN_DMON_SEL, 1, 5)
    FIELD(CH3_TX_PHALIGN_CFG0, TX_DYNAMIC_SWITCH_EN, 0, 1)
REG32(CH3_TX_PHALIGN_CFG1, 0x3e60)
    FIELD(CH3_TX_PHALIGN_CFG1, PHDA_WAIT_CYCLES, 27, 5)
    FIELD(CH3_TX_PHALIGN_CFG1, SETINIT_PH_CNT, 22, 5)
    FIELD(CH3_TX_PHALIGN_CFG1, SETINIT_PH_WAIT_CYCLE, 17, 5)
    FIELD(CH3_TX_PHALIGN_CFG1, NUM_SAMPLES, 12, 5)
    FIELD(CH3_TX_PHALIGN_CFG1, MAX_SAMPLE_THRESHOLD, 5, 7)
    FIELD(CH3_TX_PHALIGN_CFG1, SAMPLE_WAIT, 3, 2)
    FIELD(CH3_TX_PHALIGN_CFG1, CHAIN_MODE, 1, 2)
    FIELD(CH3_TX_PHALIGN_CFG1, ASYNC_GBOX_PHALIGN_EN, 0, 1)
REG32(CH3_TX_PHALIGN_CFG2, 0x3e64)
    FIELD(CH3_TX_PHALIGN_CFG2, MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH3_TX_PHALIGN_CFG2, TXPI_PHDA_WAIT_CYCLES, 20, 5)
    FIELD(CH3_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_CNT, 15, 5)
    FIELD(CH3_TX_PHALIGN_CFG2, TXPI_SETINIT_PH_WAIT_CYCLE, 10, 5)
    FIELD(CH3_TX_PHALIGN_CFG2, TXPI_NUM_SAMPLES, 3, 5)
    FIELD(CH3_TX_PHALIGN_CFG2, TXPI_SAMPLE_WAIT, 1, 2)
    FIELD(CH3_TX_PHALIGN_CFG2, TXPI_MIN_THRESHOLD_OVRD, 0, 1)
REG32(CH3_TX_PHALIGN_CFG3, 0x3e68)
    FIELD(CH3_TX_PHALIGN_CFG3, TXPI_MAX_THRESHOLD_OVRD, 31, 1)
    FIELD(CH3_TX_PHALIGN_CFG3, TXPI_MAX_SAMPLE_THRESHOLD, 24, 7)
    FIELD(CH3_TX_PHALIGN_CFG3, TXPI_MIN_SAMPLE_THRESHOLD, 17, 7)
    FIELD(CH3_TX_PHALIGN_CFG3, DAPICODE_OVRD, 9, 8)
    FIELD(CH3_TX_PHALIGN_CFG3, TXPICODE_OVRD, 2, 7)
    FIELD(CH3_TX_PHALIGN_CFG3, TXPI_ALIGN_DIR, 1, 1)
    FIELD(CH3_TX_PHALIGN_CFG3, DLY_DAPICLK_ALIGN_DIR, 0, 1)
REG32(CH3_TX_PHALIGN_CFG4, 0x3e6c)
    FIELD(CH3_TX_PHALIGN_CFG4, TXPI_SETINIT_STEPSIZE, 27, 5)
    FIELD(CH3_TX_PHALIGN_CFG4, TXPI_PHALIGN_STEPSIZE, 22, 5)
    FIELD(CH3_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_CNT, 17, 5)
    FIELD(CH3_TX_PHALIGN_CFG4, MLDLY_SETINIT_PH_WAIT_CYCLE, 12, 5)
    FIELD(CH3_TX_PHALIGN_CFG4, MLDLY_NUM_SAMPLES, 5, 5)
    FIELD(CH3_TX_PHALIGN_CFG4, MLDLY_MIN_THRESHOLD_OVRD, 4, 1)
    FIELD(CH3_TX_PHALIGN_CFG4, MLDLY_MAX_THRESHOLD_OVRD, 3, 1)
    FIELD(CH3_TX_PHALIGN_CFG4, MLDLY_SAMPLE_WAIT, 1, 2)
    FIELD(CH3_TX_PHALIGN_CFG4, DLY_ALIGN_DIR, 0, 1)
REG32(CH3_TX_PHALIGN_CFG5, 0x3e70)
    FIELD(CH3_TX_PHALIGN_CFG5, MLDLY_MIN_SAMPLE_THRESHOLD, 25, 7)
    FIELD(CH3_TX_PHALIGN_CFG5, MLDLY_MAX_SAMPLE_THRESHOLD, 18, 7)
    FIELD(CH3_TX_PHALIGN_CFG5, MLDLY_DA_WAIT_CYCLES, 13, 5)
    FIELD(CH3_TX_PHALIGN_CFG5, DMON_CLK_SEL, 0, 2)
REG32(CH3_PIPE_CTRL_CFG0, 0x3e74)
    FIELD(CH3_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_NUM, 28, 4)
    FIELD(CH3_PIPE_CTRL_CFG0, RXELECIDLE_FILTER_EN, 27, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, SATA_BURST_SEQ_LEN, 23, 4)
    FIELD(CH3_PIPE_CTRL_CFG0, TX_PD_ELECIDLE_MODE, 22, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, TX_EILDE_DEASSERT_DLY, 19, 3)
    FIELD(CH3_PIPE_CTRL_CFG0, TX_EIDLE_ASSERT_DLY, 16, 3)
    FIELD(CH3_PIPE_CTRL_CFG0, RX_PCSCLK_SEL, 14, 2)
    FIELD(CH3_PIPE_CTRL_CFG0, TX_PHYCLK_SEL, 13, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, TX_PCSCLK_SEL, 11, 2)
    FIELD(CH3_PIPE_CTRL_CFG0, RX_PHYCLK_SEL, 10, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD, 9, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, PIPE_TXELECIDLE_OVRD_EN, 8, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, PIPECLK_SEL, 7, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, RX_ELECIDLE_MODE, 5, 2)
    FIELD(CH3_PIPE_CTRL_CFG0, RX_ELECIDLE_CFG, 2, 3)
    FIELD(CH3_PIPE_CTRL_CFG0, PCIE_MODE, 1, 1)
    FIELD(CH3_PIPE_CTRL_CFG0, USB_MODE, 0, 1)
REG32(CH3_PIPE_CTRL_CFG1, 0x3e78)
    FIELD(CH3_PIPE_CTRL_CFG1, SATA_SPEED, 30, 2)
    FIELD(CH3_PIPE_CTRL_CFG1, P2_SPECIAL_TURNOFF_EN, 29, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, POWERDOWN_OVRD_EN, 28, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PD_TXPMA_PWRDN_OVRD, 27, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PD_TXDRVPWRDN_OVRD, 26, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PD_RX_PD_OVRD, 25, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PD_LCPLL_PD_OVRD, 24, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PD_RPLL_PD_OVRD, 23, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PD_OOB_PD_OVRD, 22, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, OOB_PD, 21, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PIPE_FUND_RST_OVRD_EN, 20, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, IND_ERROR_REPORT, 19, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, UBLAZE_PLL_ILO_CAL_EN, 18, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PIPE_RST_USE_MST_RESET_LOOP, 17, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_PHY_READY_OVRD, 16, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_RX_SYNC_RESET_OVRD, 15, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_TX_SYNC_RESET_OVRD, 14, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_USER_RDY_OVRD, 13, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_PCS_RESET_OVRD, 12, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_PMA_RESET_OVRD, 11, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_TXPROGDIV_RST_OVRD, 10, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_LCPLL_RESET_OVRD, 9, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_LCPLL_PD_OVRD, 8, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_RPLL_RESET_OVRD, 7, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_RPLL_PD_OVRD, 6, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, PIPE_FUND_RST_EN, 5, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RST_ILO_RESET_OVRD, 4, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RXSYNC_EN, 3, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, TXSYNC_EN, 2, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, LCPLL_EN, 1, 1)
    FIELD(CH3_PIPE_CTRL_CFG1, RPLL_EN, 0, 1)
REG32(CH3_PIPE_CTRL_CFG2, 0x3e7c)
    FIELD(CH3_PIPE_CTRL_CFG2, PMA_SIGDET_SEL, 31, 1)
    FIELD(CH3_PIPE_CTRL_CFG2, P2P3_RX_PWRUP_EN, 30, 1)
    FIELD(CH3_PIPE_CTRL_CFG2, PD_TRANS_TIME_FROM_P2, 15, 15)
    FIELD(CH3_PIPE_CTRL_CFG2, TX_RXDETECT_REF, 12, 3)
    FIELD(CH3_PIPE_CTRL_CFG2, TX_RXDETECT_CFG, 1, 11)
    FIELD(CH3_PIPE_CTRL_CFG2, RXDETECT_BYPASS, 0, 1)
REG32(CH3_PIPE_CTRL_CFG3, 0x3e80)
    FIELD(CH3_PIPE_CTRL_CFG3, PIPE_RXADAPT_SAVE_RESTORE_EN, 31, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, PIPE_LCPLL_DYN_PD_EN, 30, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, PIPE_RPLL_DYN_PD_EN, 29, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, RXOUT_DIV, 26, 3)
    FIELD(CH3_PIPE_CTRL_CFG3, TXOUT_DIV, 23, 3)
    FIELD(CH3_PIPE_CTRL_CFG3, RX_VREG_PD, 22, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, TX_VREG_PD, 21, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, ILO_CLKMUX_EN, 20, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, TX_CLKMUX_EN, 19, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, PIPE_FUND_RST_UB_BYPASS, 18, 1)
    FIELD(CH3_PIPE_CTRL_CFG3, PD_TRANS_TIME_TO_P2, 9, 9)
    FIELD(CH3_PIPE_CTRL_CFG3, PD_TRANS_TIME_NONE_P2, 0, 9)
REG32(CH3_PIPE_CTRL_CFG4, 0x3e84)
    FIELD(CH3_PIPE_CTRL_CFG4, RST_TXDAPI_RST_OVRD, 31, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RX_RATE_EN, 30, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_TXDAPI_RST_OVRD, 29, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_ILO_RESET_OVRD, 28, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_UB_CTRL_WO_PHYSTATUS, 27, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_UB_REPROG_REQ_DIS, 26, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_USE_RPLL_AS_DATA_PLL, 25, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_PHYSTATUS_CNT, 20, 5)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_DATA_FLUSH_CNT, 15, 5)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_PHYSTATUS_OVRD, 14, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_CHANGE_IN_PROGRESS_OVRD, 13, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_TXRX_128B130B_EN_OVRD, 12, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_RX_SYNC_RESET_OVRD, 11, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_TX_SYNC_RESET_OVRD, 10, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_UB_REPROG_DONE_OVRD, 9, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_PCS_RESET_OVRD, 8, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_PMA_RESET_OVRD, 7, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_TXPROGDIV_RST_OVRD, 6, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_LCPLL_RESET_OVRD, 5, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_LCPLL_PD_OVRD, 4, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_RPLL_RESET_OVRD, 3, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, RATE_RPLL_PD_OVRD, 2, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, PIPE_RATE_OVRD_EN, 1, 1)
    FIELD(CH3_PIPE_CTRL_CFG4, PIPE_RATE_EN, 0, 1)
REG32(CH3_PIPE_CTRL_CFG5, 0x3e88)
    FIELD(CH3_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_SYNC_ERR_EN, 31, 1)
    FIELD(CH3_PIPE_CTRL_CFG5, RX128B130B_RESET_ON_DP_DIS_EN, 30, 1)
    FIELD(CH3_PIPE_CTRL_CFG5, PIPE_SPECIAL_OFF_RESET_EN, 29, 1)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGT_ESM_DELAY_CE_DIS, 28, 1)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK2, 25, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_USERCLK, 22, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_CORECLK, 19, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_E6_PIPECLK, 16, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_E5_PIPECLK, 13, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_G4_PIPECLK, 10, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_G3_PIPECLK, 7, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_G2_PIPECLK, 4, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, BUFGTDIV_G1_PIPECLK, 1, 3)
    FIELD(CH3_PIPE_CTRL_CFG5, PIPE_BUFGT_CTRL_EN, 0, 1)
REG32(CH3_PIPE_CTRL_CFG6, 0x3e8c)
    FIELD(CH3_PIPE_CTRL_CFG6, RXOOB_CLKDIV_VAL, 27, 5)
    FIELD(CH3_PIPE_CTRL_CFG6, PIPE_DIST_UB_DONE_SHARE_EN, 26, 1)
    FIELD(CH3_PIPE_CTRL_CFG6, PIPE_CONSUMPT_SEL, 23, 3)
    FIELD(CH3_PIPE_CTRL_CFG6, PIPE_DISTSOUTH_SEL, 21, 2)
    FIELD(CH3_PIPE_CTRL_CFG6, PIPE_DISTNORTH_SEL, 19, 2)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGTDIV_PIPECLK_OVRD, 16, 3)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGT_RSTMASK_OVRD, 12, 4)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGT_CEMASK_OVRD, 8, 4)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGT_CE_OVRD, 7, 1)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGT_RESET_OVRD, 6, 1)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGT_OVRD_EN, 5, 1)
    FIELD(CH3_PIPE_CTRL_CFG6, BUFGT_WAIT_CNT, 0, 5)
REG32(CH3_PIPE_CTRL_CFG7, 0x3e90)
    FIELD(CH3_PIPE_CTRL_CFG7, CDR_CTRL_USE_RAW_SIGVALID, 31, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, RXELECIDLE_USE_RAW_SIGVALID, 30, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, CDR_CTRL_ADAPT_HOLD_EN, 29, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, PIPE_DIST_PLLLOCK_SEL, 27, 2)
    FIELD(CH3_PIPE_CTRL_CFG7, RXPD_IND_CONTROL, 26, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, RATE_USE_LCPLL_OUTCLK_ESM56, 25, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, CDR_CTRL_USER_HOLDCDR_EN, 24, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, RX_DABYP_DIVSEL, 20, 4)
    FIELD(CH3_PIPE_CTRL_CFG7, RX_DA_DIVSEL, 16, 4)
    FIELD(CH3_PIPE_CTRL_CFG7, RX_DA_BYP, 15, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, RXOUTCLKCTL, 12, 3)
    FIELD(CH3_PIPE_CTRL_CFG7, TX_DABYP_DIVSEL, 8, 4)
    FIELD(CH3_PIPE_CTRL_CFG7, TX_DA_DIVSEL, 4, 4)
    FIELD(CH3_PIPE_CTRL_CFG7, TX_DA_BYP, 3, 1)
    FIELD(CH3_PIPE_CTRL_CFG7, TXOUTCLKCTL, 0, 3)
REG32(CH3_PIPE_CTRL_CFG8, 0x3e94)
    FIELD(CH3_PIPE_CTRL_CFG8, PMA_OOB_CLKDIV_VAL, 30, 2)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_ALIGN_REQ_OVRD, 29, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_SLIP_EN, 28, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_HOLDCDR_RX_PHALIGN, 27, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G34, 26, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_USE_SIGVALID_FOR_G12, 25, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_REFCLK_MODE, 23, 2)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_GEN34_ON_EIDLE, 22, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_GEN12_ON_EIDLE, 21, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, CDR_CTRL_EN, 20, 1)
    FIELD(CH3_PIPE_CTRL_CFG8, RXPROGDIVSEL, 10, 10)
    FIELD(CH3_PIPE_CTRL_CFG8, TXPROGDIVSEL, 0, 10)
REG32(CH3_PIPE_CTRL_CFG9, 0x3e98)
    FIELD(CH3_PIPE_CTRL_CFG9, TX_RESET_TIMER_SAMPLES_LG, 30, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, TX_RESET_TIMER_RST_OFFSET, 25, 5)
    FIELD(CH3_PIPE_CTRL_CFG9, TX_RESET_TIMER_CNT_FIRST, 21, 4)
    FIELD(CH3_PIPE_CTRL_CFG9, TX_RESET_TIMER_EN, 20, 1)
    FIELD(CH3_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_IN_SEL, 18, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_IN_SEL, 16, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, RXSYNCDONE_CONSUMPT_SEL, 13, 3)
    FIELD(CH3_PIPE_CTRL_CFG9, RXSYNCDONE_DISTSOUTH_SEL, 11, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, RXSYNCDONE_DISTNORTH_SEL, 9, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, RXSYNCDONE_DIST_DIS, 8, 1)
    FIELD(CH3_PIPE_CTRL_CFG9, TXSYNCDONE_CONSUMPT_SEL, 5, 3)
    FIELD(CH3_PIPE_CTRL_CFG9, TXSYNCDONE_DISTSOUTH_SEL, 3, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, TXSYNCDONE_DISTNORTH_SEL, 1, 2)
    FIELD(CH3_PIPE_CTRL_CFG9, TXSYNCDONE_DIST_DIS, 0, 1)
REG32(CH3_TX_PIPPM_CFG, 0x3e9c)
    FIELD(CH3_TX_PIPPM_CFG, TXPI_SYNFREQ_PPM, 25, 5)
    FIELD(CH3_TX_PIPPM_CFG, TXPI_DDR_EN, 24, 1)
    FIELD(CH3_TX_PIPPM_CFG, TXPI_PPM_DDR_CFG, 16, 8)
    FIELD(CH3_TX_PIPPM_CFG, TXPI_INVSTROBE_SEL, 15, 1)
    FIELD(CH3_TX_PIPPM_CFG, TXPI_PPM_CFG, 4, 8)
    FIELD(CH3_TX_PIPPM_CFG, TXPIPPMOVRDEN, 3, 1)
    FIELD(CH3_TX_PIPPM_CFG, TXPI_GRAY_SEL, 2, 1)
    FIELD(CH3_TX_PIPPM_CFG, TXPIPPMSEL, 1, 1)
    FIELD(CH3_TX_PIPPM_CFG, TXPIPPMPD, 0, 1)
REG32(CH3_CHL_RSV_CFG2, 0x3ea0)
REG32(CH3_FABRIC_INTF_CFG0, 0x3ea4)
    FIELD(CH3_FABRIC_INTF_CFG0, HSDPPCSRESET_PIN_EN, 31, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, USRRDY_PIN_EN, 30, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RX_RATE_PIN_EN, 29, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TX_RATE_PIN_EN, 28, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, CDR_PIN_EN, 27, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, QPI_PIN_EN, 26, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, ILO_RESET_PIN_EN, 25, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, PERSTB_PIN_EN, 24, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, LOOPBACK_PIN_EN, 23, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TX_PHDLYRESET_PIN_EN, 22, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TX_PHALIGN_PIN_EN, 21, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TX_DAPI_PIN_EN, 20, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RXTERMINATION_PIN_EN, 19, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TXPOLARITY_PIN_EN, 18, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TXPI_PIN_EN, 17, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TXPISOPD_PIN_EN, 16, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TXPIPPM_PIN_EN, 15, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TXPD_PIN_EN, 14, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TXINHIBIT_PIN_EN, 13, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, TX_CHRESET_PIN_EN, 12, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RX_PHDLYRESET_PIN_EN, 11, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RX_PHALIGN_PIN_EN, 10, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RX_EQTRAINING_PIN_EN, 9, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RX_DAPI_PIN_EN, 8, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RX_CHRESET_PIN_EN, 7, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RXSLIDE_PIN_EN, 6, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, PRBSSEL_PIN_EN, 5, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RXPOLARITY_PIN_EN, 4, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RXPD_PIN_EN, 3, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RXLPM_PIN_EN, 2, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, APT_PIN_EN, 1, 1)
    FIELD(CH3_FABRIC_INTF_CFG0, RXCDRHOLD_PIN_EN, 0, 1)
REG32(CH3_FABRIC_INTF_CFG1, 0x3ea8)
    FIELD(CH3_FABRIC_INTF_CFG1, A_RXSLIDE, 31, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_TXRATE, 23, 8)
    FIELD(CH3_FABRIC_INTF_CFG1, A_RXPRBSSEL, 19, 4)
    FIELD(CH3_FABRIC_INTF_CFG1, A_RXPOLARITY, 18, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_RXPD, 16, 2)
    FIELD(CH3_FABRIC_INTF_CFG1, A_RXLPMEN, 15, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRHOLD, 11, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_PERSTB, 10, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_LOOPBACK, 7, 3)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRSTEPSX, 6, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRSTEPSQ, 5, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRSTEPDIR, 4, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRINCPCTRL, 3, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRFREQOS, 2, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDROVREN, 1, 1)
    FIELD(CH3_FABRIC_INTF_CFG1, A_CDRBMCDRREQ, 0, 1)
REG32(CH3_FABRIC_INTF_CFG2, 0x3eac)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RXUSRRDY, 31, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_TXUSRRDY, 30, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_ILO_RESETMASK, 29, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_ILORESET, 28, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_CDRPHRESET, 27, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_EYESCANRESET, 26, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RXOOBRESET, 25, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RXPRBSCNTRESET, 24, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RX_PROGDIVRESET, 23, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_GTRXRESET, 22, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RX_RESETMODE, 20, 2)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RX_PCS_RESETMASK, 15, 5)
    FIELD(CH3_FABRIC_INTF_CFG2, A_RX_PMA_RESETMASK, 8, 7)
    FIELD(CH3_FABRIC_INTF_CFG2, A_TX_PCS_RESETMASK, 7, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_TX_PMA_RESETMASK, 4, 3)
    FIELD(CH3_FABRIC_INTF_CFG2, A_TX_PROGDIVRESET, 3, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_GTTXRESET, 2, 1)
    FIELD(CH3_FABRIC_INTF_CFG2, A_TX_RESETMODE, 0, 2)
REG32(CH3_FABRIC_INTF_CFG3, 0x3eb0)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXDAPICODERESET, 31, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXDAPICODEOVRDEN, 30, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXPOLARITY, 29, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXPICODERESET, 28, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXPICODEOVRDEN, 27, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXPISOPD, 26, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_STEPSIZEPPM, 21, 5)
    FIELD(CH3_FABRIC_INTF_CFG3, A_ENPPM, 20, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXPD, 18, 2)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXINHIBIT, 17, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXPHSHIFT180, 16, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXPHSETINITREQ, 15, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXPHALIGNREQ, 14, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXPHDLYPD, 13, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXDLYALIGNREQ, 12, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXMLFINEALIGNREQ, 11, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXMLDCHAINREQ, 10, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXMLDCHAINDONE, 9, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXEQTRAINING, 8, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXDAPICODERESET, 7, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXDAPICODEOVRDEN, 6, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXDAPIRESET, 5, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RX_PHALIGN_RESETMASK, 4, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_RXPHDLYRESET, 3, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXDAPIRESET, 2, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TX_PHALIGN_RESETMASK, 1, 1)
    FIELD(CH3_FABRIC_INTF_CFG3, A_TXPHDLYRESET, 0, 1)
REG32(CH3_FABRIC_INTF_CFG4, 0x3eb4)
    FIELD(CH3_FABRIC_INTF_CFG4, A_APT_OVERWREN, 31, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_APT_EXTHOLD, 30, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_RXQPIEN, 29, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXQPIWEAKPU, 28, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXQPIBIASEN, 27, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_EYESCANTRIGGER, 26, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_PHY_ESM_ADAPTATION_SAVE, 25, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_RXTERMINATION, 24, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_RXRATE, 16, 8)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXDAPIRESETMASK, 13, 2)
    FIELD(CH3_FABRIC_INTF_CFG4, A_RXDAPIRESETMASK, 11, 2)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXMLFINEALIGNREQ, 10, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXMLDCHAINREQ, 9, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXDLYALIGNREQ, 8, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXPHSHIFT180, 7, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXPHSETINITREQ, 6, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXPHALIGNREQ, 5, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXPHDLYPD, 4, 1)
    FIELD(CH3_FABRIC_INTF_CFG4, A_TXPRBSSEL, 0, 4)
REG32(CH3_FABRIC_INTF_CFG5, 0x3eb8)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXEMPPRE, 27, 5)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXEMPPOS, 22, 5)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXEMPMAIN, 15, 7)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXDRVAMP, 10, 5)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXDEEMPH, 8, 2)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXSWING, 7, 1)
    FIELD(CH3_FABRIC_INTF_CFG5, A_TXMARGIN, 4, 3)
    FIELD(CH3_FABRIC_INTF_CFG5, EYESCANTRIGGER_PIN_EN, 2, 1)
    FIELD(CH3_FABRIC_INTF_CFG5, TX_EQ_PIN_EN, 1, 1)
    FIELD(CH3_FABRIC_INTF_CFG5, PHYESMADAPTSAVE_PIN_EN, 0, 1)
REG32(CH3_RX_ELASTIC_BUF_CFG1, 0x3ebc)
    FIELD(CH3_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_3, 22, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_2, 12, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_SEQ_1_1, 2, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_PRECEDENCE, 1, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG1, EB8B10B_CLK_COR_KEEP_IDLE, 0, 1)
REG32(CH3_RX_ELASTIC_BUF_CFG2, 0x3ec0)
    FIELD(CH3_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_LEN, 30, 2)
    FIELD(CH3_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_2, 20, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_2_1, 10, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG2, EB8B10B_CLK_COR_SEQ_1_4, 0, 10)
REG32(CH3_RX_ELASTIC_BUF_CFG3, 0x3ec4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_DISPERR_SEQ_MATCH, 31, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_DATA_SOURCE_SEL, 30, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_USB3_CLK_COR_EQ_EN, 29, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_EN, 25, 4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_1_EN, 21, 4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_USE, 20, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_4, 10, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG3, EB8B10B_CLK_COR_SEQ_2_3, 0, 10)
REG32(CH3_RX_ELASTIC_BUF_CFG4, 0x3ec8)
    FIELD(CH3_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_3, 22, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_2, 12, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_1_1, 2, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG4, EB8B10B_CHAN_BOND_SEQ_LEN, 0, 2)
REG32(CH3_RX_ELASTIC_BUF_CFG5, 0x3ecc)
    FIELD(CH3_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_USE, 30, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_2, 20, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_2_1, 10, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG5, EB8B10B_CHAN_BOND_SEQ_1_4, 0, 10)
REG32(CH3_RX_ELASTIC_BUF_CFG6, 0x3ed0)
    FIELD(CH3_RX_ELASTIC_BUF_CFG6, EB_8B10B_FTS_DESKEW_SEQ_EN, 28, 4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_EN, 24, 4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_1_EN, 20, 4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_4, 10, 10)
    FIELD(CH3_RX_ELASTIC_BUF_CFG6, EB8B10B_CHAN_BOND_SEQ_2_3, 0, 10)
REG32(CH3_RX_ELASTIC_BUF_CFG7, 0x3ed4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB128B130B_32_BLKALGN_CTL, 31, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB128B130B_32_EIOS_LPBK4_BYP, 30, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB128B130B_16_BLKALGN_CTL, 29, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB128B130B_16_EIOS_LPBK4_BYP, 28, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB128B130B_32_ONE_SKP_INS_DEL, 26, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_SLAVE, 22, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MASTER, 21, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_LEVEL, 18, 3)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_BUFFER_CFG, 12, 6)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_DELAY_CC_AFTER_FTS, 11, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_KEEP_4ADJ, 10, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SNAP4_USE, 9, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_DESKEW_SLIP4_USE, 8, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_FTS_LANE_DESKEW_EN, 7, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_KEEP_ALIGN, 6, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_MAX_SKEW, 2, 4)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_CHAN_BOND_EN, 1, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG7, EB8B10B_ADDR_MODE, 0, 1)
REG32(CH3_RX_ELASTIC_BUF_CFG8, 0x3ed8)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EIOS_DEL_SEL, 31, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, EB128B130B_32_AUTO_REALIGN, 28, 2)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, EB128B130B_32_FULL_THRESH, 16, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, EB128B130B_32_EMPTY_THRESH, 11, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MAX_LAT, 6, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, EB128B130B_32_MIN_LAT, 1, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG8, ELASTICBUF_128B130B_EN, 0, 1)
REG32(CH3_RX_ELASTIC_BUF_CFG9, 0x3edc)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EIOS_DEL_SEL, 31, 1)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_AUTO_REALIGN, 28, 2)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_FULL_THRESH, 16, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EMPTY_THRESH, 11, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MAX_LAT, 6, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_MIN_LAT, 1, 5)
    FIELD(CH3_RX_ELASTIC_BUF_CFG9, EB128B130B_16_EN, 0, 1)
REG32(CH3_RX_OOB_CFG0, 0x3ee0)
    FIELD(CH3_RX_OOB_CFG0, OOB_SATA_EIDLE_VAL, 27, 3)
    FIELD(CH3_RX_OOB_CFG0, OOB_SATA_BURST_VAL, 24, 3)
    FIELD(CH3_RX_OOB_CFG0, OOB_SATA_MAX_INIT, 18, 6)
    FIELD(CH3_RX_OOB_CFG0, OOB_SATA_MIN_INIT, 12, 6)
    FIELD(CH3_RX_OOB_CFG0, OOB_SATA_MAX_BURST, 6, 6)
    FIELD(CH3_RX_OOB_CFG0, OOB_SATA_MIN_BURST, 0, 6)
REG32(CH3_RX_OOB_CFG1, 0x3ee4)
    FIELD(CH3_RX_OOB_CFG1, OOB_SAS_MAX_COM, 18, 7)
    FIELD(CH3_RX_OOB_CFG1, OOB_SAS_MIN_COM, 12, 6)
    FIELD(CH3_RX_OOB_CFG1, OOB_SATA_MAX_WAKE, 6, 6)
    FIELD(CH3_RX_OOB_CFG1, OOB_SATA_MIN_WAKE, 0, 6)
REG32(CH3_MONITOR_CFG, 0x3ee8)
    FIELD(CH3_MONITOR_CFG, RXAMONSEL, 26, 6)
    FIELD(CH3_MONITOR_CFG, TXAMONSEL, 21, 5)
    FIELD(CH3_MONITOR_CFG, DAAMONSEL, 18, 3)
    FIELD(CH3_MONITOR_CFG, CHCKAMONSEL, 14, 4)
    FIELD(CH3_MONITOR_CFG, CHAMONSEL, 12, 2)
    FIELD(CH3_MONITOR_CFG, DMON_FIFO_BYPASS, 7, 1)
    FIELD(CH3_MONITOR_CFG, DMON_CLK_SRC, 4, 3)
    FIELD(CH3_MONITOR_CFG, DMON_DATA_SRC, 1, 3)
    FIELD(CH3_MONITOR_CFG, DMON_EN, 0, 1)
REG32(CH3_PIPE_CTRL_CFG10, 0x3eec)
    FIELD(CH3_PIPE_CTRL_CFG10, RATE_CHANGE_DURING_RST_EN, 31, 1)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_RXDAPI_RST_MASK, 25, 2)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_TXDAPI_RST_MASK, 23, 2)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_RXSYNC_RST_MASK, 22, 1)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_TXSYNC_RST_MASK, 21, 1)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_RXPCS_RST_MASK, 16, 5)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_RXPMA_RST_MASK, 9, 7)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_TXPCS_RST_MASK, 8, 1)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_TXPMA_RST_MASK, 5, 3)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_LCPLL_RST_MASK, 2, 2)
    FIELD(CH3_PIPE_CTRL_CFG10, PIPE_RPLL_RST_MASK, 0, 2)
REG32(CH3_CHL_RSV_CFG3, 0x3ef0)
REG32(CH3_CHL_RSV_CFG4, 0x3ef4)
REG32(MEMCELLX3EF8, 0x3ef8)
    FIELD(MEMCELLX3EF8, QUAD_MUX3_REFCLK_SEL, 30, 2)
REG32(MEMCELLX3EFC, 0x3efc)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_EN_FABRIC_CK, 25, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_HROW_CK_SEL, 23, 2)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_ICNTL_RX, 21, 2)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_EN_DC_COUP, 20, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_VCM_HIGH, 19, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_VCM_LOW, 18, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_EN_TX_PATH, 17, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_CLKOUT_SEL, 15, 2)
    FIELD(MEMCELLX3EFC, REFCLK1_RXRECCLK_SEL, 13, 2)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_CTL_DRV_EN_CAL, 8, 5)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_CTL_DRV_SWING, 4, 3)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_RPLL_CLK_SEL_EN, 3, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_ENB_VCM_STRONG, 2, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_EN_DRV, 1, 1)
    FIELD(MEMCELLX3EFC, REFCLK1_REFCLK_EN_BLD, 0, 1)

#define GTY_NPI_SLAVE_R_MAX (R_MEMCELLX3EFC + 1)

typedef struct GTY_NPI_SLAVE {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[GTY_NPI_SLAVE_R_MAX];
    RegisterInfo regs_info[GTY_NPI_SLAVE_R_MAX];
} GTY_NPI_SLAVE;

#define LOCK_VAL 0xF9E8D7C6

static void lock_postw(RegisterInfo *reg, uint64_t val64)
{
    GTY_NPI_SLAVE *s = XILINX_GTY_NPI_SLAVE(reg->opaque);
    bool locked = val64 != LOCK_VAL;

    ARRAY_FIELD_DP32(s->regs, REG_PCSR_STATUS, PCSRLOCK, locked);
    ARRAY_FIELD_DP32(s->regs, REG_PCSR_LOCK, STATE, locked);
}

static const RegisterAccessInfo gty_npi_slave_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xc0e00cbc,
        .ro = 0xe00cbc,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1000142,
        .rsvd = 0xc0e00cbc,
        .ro = 0xe00cbc,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_GTPOWERGOOD_MASK \
                 | R_REG_PCSR_STATUS_BISR_PASS_MASK \
                 | R_REG_PCSR_STATUS_BISR_DONE_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_CALDONE_MASK \
                 | R_REG_PCSR_STATUS_PCSRLOCK_MASK,
        .rsvd = 0xffc0c006,
        .ro = 0x3fffff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = lock_postw
    },{ .name = "MULTICAST",  .addr = A_MULTICAST,
        .rsvd = 0xfffffff0,
    },{ .name = "SIVERSION",  .addr = A_SIVERSION,
        .reset = 0x1,
        .ro = 0xffffffff,
    },{ .name = "OWNPROGEXCLACCESS",  .addr = A_OWNPROGEXCLACCESS,
        .rsvd = 0xfffffff8,
    },{ .name = "GT_GTY_ISR",  .addr = A_GT_GTY_ISR,
        .rsvd = 0xffffffe0,
        .w1c = 0x1f,
    },{ .name = "GT_GTY_ITR",  .addr = A_GT_GTY_ITR,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IMR0",  .addr = A_GT_GTY_IMR0,
        .reset = 0x1f,
        .rsvd = 0xffffffe0,
        .ro = 0x1f,
    },{ .name = "GT_GTY_IER0",  .addr = A_GT_GTY_IER0,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IDR0",  .addr = A_GT_GTY_IDR0,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IMR1",  .addr = A_GT_GTY_IMR1,
        .reset = 0x1f,
        .rsvd = 0xffffffe0,
        .ro = 0x1f,
    },{ .name = "GT_GTY_IER1",  .addr = A_GT_GTY_IER1,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IDR1",  .addr = A_GT_GTY_IDR1,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IMR2",  .addr = A_GT_GTY_IMR2,
        .reset = 0x1f,
        .rsvd = 0xffffffe0,
        .ro = 0x1f,
    },{ .name = "GT_GTY_IER2",  .addr = A_GT_GTY_IER2,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IDR2",  .addr = A_GT_GTY_IDR2,
        .rsvd = 0xffffffe0,
    },{ .name = "GT_GTY_IOR",  .addr = A_GT_GTY_IOR,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "BISR_CACHE_DATA_0",  .addr = A_BISR_CACHE_DATA_0,
    },{ .name = "BISR_CACHE_DATA_1",  .addr = A_BISR_CACHE_DATA_1,
    },{ .name = "BISR_TEST_DATA_0",  .addr = A_BISR_TEST_DATA_0,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_1",  .addr = A_BISR_TEST_DATA_1,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_RESET0",
        .addr = A_CH0_COESTATUS_CHANNEL_RESET0,
        .rsvd = 0xf8000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_RESET1",
        .addr = A_CH0_COESTATUS_CHANNEL_RESET1,
        .rsvd = 0x7e000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_RESET2",
        .addr = A_CH0_COESTATUS_CHANNEL_RESET2,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_RATE3",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_RATE3,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_RATE2",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_RATE2,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_RATE0",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_RATE0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_RATE1",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_RATE1,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_TXUSRCLK_FREQ_CNT",
        .addr = A_CH0_COESTATUS_TXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_TXPHYCLK_FREQ_CNT",
        .addr = A_CH0_COESTATUS_TXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_TXPCSCLK_FREQ_CNT",
        .addr = A_CH0_COESTATUS_TXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_RXUSRCLK_FREQ_CNT",
        .addr = A_CH0_COESTATUS_RXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_RXPHYCLK_FREQ_CNT",
        .addr = A_CH0_COESTATUS_RXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_RXPCSCLK_FREQ_CNT",
        .addr = A_CH0_COESTATUS_RXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CRC_TX",  .addr = A_CH0_COESTATUS_CRC_TX,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CRC_RX",  .addr = A_CH0_COESTATUS_CRC_RX,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_00",  .addr = A_CH0_TXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_01",  .addr = A_CH0_TXCHICO_DBG_SIG_01,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_02",  .addr = A_CH0_TXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_03",  .addr = A_CH0_TXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_04",  .addr = A_CH0_TXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_05",  .addr = A_CH0_TXCHICO_DBG_SIG_05,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_06",  .addr = A_CH0_TXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_07",  .addr = A_CH0_TXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_08",  .addr = A_CH0_TXCHICO_DBG_SIG_08,
        .rsvd = 0xffc00001,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_09",  .addr = A_CH0_TXCHICO_DBG_SIG_09,
        .rsvd = 0xffc40000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_10",  .addr = A_CH0_TXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_11",  .addr = A_CH0_TXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_12",  .addr = A_CH0_TXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_13",  .addr = A_CH0_TXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_14",  .addr = A_CH0_TXCHICO_DBG_SIG_14,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_15",  .addr = A_CH0_TXCHICO_DBG_SIG_15,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_16",  .addr = A_CH0_TXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_17",  .addr = A_CH0_TXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_18",  .addr = A_CH0_TXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_19",  .addr = A_CH0_TXCHICO_DBG_SIG_19,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_20",  .addr = A_CH0_TXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_21",  .addr = A_CH0_TXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_22",  .addr = A_CH0_TXCHICO_DBG_SIG_22,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_23",  .addr = A_CH0_TXCHICO_DBG_SIG_23,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_24",  .addr = A_CH0_TXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_25",  .addr = A_CH0_TXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_26",  .addr = A_CH0_TXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_27",  .addr = A_CH0_TXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_28",  .addr = A_CH0_TXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_29",  .addr = A_CH0_TXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_30",  .addr = A_CH0_TXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_TXCHICO_DBG_SIG_31",  .addr = A_CH0_TXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_00",  .addr = A_CH0_RXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_01",  .addr = A_CH0_RXCHICO_DBG_SIG_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_02",  .addr = A_CH0_RXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_03",  .addr = A_CH0_RXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_04",  .addr = A_CH0_RXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_05",  .addr = A_CH0_RXCHICO_DBG_SIG_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_06",  .addr = A_CH0_RXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_07",  .addr = A_CH0_RXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_08",  .addr = A_CH0_RXCHICO_DBG_SIG_08,
        .rsvd = 0xfffff801,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_09",  .addr = A_CH0_RXCHICO_DBG_SIG_09,
        .rsvd = 0xffc00000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_10",  .addr = A_CH0_RXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_11",  .addr = A_CH0_RXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_12",  .addr = A_CH0_RXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_13",  .addr = A_CH0_RXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_14",  .addr = A_CH0_RXCHICO_DBG_SIG_14,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_15",  .addr = A_CH0_RXCHICO_DBG_SIG_15,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_16",  .addr = A_CH0_RXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff2,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_17",  .addr = A_CH0_RXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_18",  .addr = A_CH0_RXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_19",  .addr = A_CH0_RXCHICO_DBG_SIG_19,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_20",  .addr = A_CH0_RXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_21",  .addr = A_CH0_RXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_22",  .addr = A_CH0_RXCHICO_DBG_SIG_22,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_23",  .addr = A_CH0_RXCHICO_DBG_SIG_23,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_24",  .addr = A_CH0_RXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_25",  .addr = A_CH0_RXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_26",  .addr = A_CH0_RXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_27",  .addr = A_CH0_RXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_28",  .addr = A_CH0_RXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_29",  .addr = A_CH0_RXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_30",  .addr = A_CH0_RXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RXCHICO_DBG_SIG_31",  .addr = A_CH0_RXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_0",  .addr = A_CH0_COE_STATUS_EYESCAN_0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_1",  .addr = A_CH0_COE_STATUS_EYESCAN_1,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_2",  .addr = A_CH0_COE_STATUS_EYESCAN_2,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_3",  .addr = A_CH0_COE_STATUS_EYESCAN_3,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_4",  .addr = A_CH0_COE_STATUS_EYESCAN_4,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_5",  .addr = A_CH0_COE_STATUS_EYESCAN_5,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_6",  .addr = A_CH0_COE_STATUS_EYESCAN_6,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_7",  .addr = A_CH0_COE_STATUS_EYESCAN_7,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_8",  .addr = A_CH0_COE_STATUS_EYESCAN_8,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_9",  .addr = A_CH0_COE_STATUS_EYESCAN_9,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_10",
        .addr = A_CH0_COE_STATUS_EYESCAN_10,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_EYESCAN_11",
        .addr = A_CH0_COE_STATUS_EYESCAN_11,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_PRBSERR_CNT_0",
        .addr = A_CH0_COE_STATUS_PRBSERR_CNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_PRBSERR_CNT_1",
        .addr = A_CH0_COE_STATUS_PRBSERR_CNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RX_CYCLECNT_0",
        .addr = A_CH0_COE_STATUS_RX_CYCLECNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RX_CYCLECNT_1",
        .addr = A_CH0_COE_STATUS_RX_CYCLECNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_PRBS_LINK2RESEED_CNT",
        .addr = A_CH0_COE_STATUS_PRBS_LINK2RESEED_CNT,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_TXGBOX_0",  .addr = A_CH0_COE_STATUS_TXGBOX_0,
        .rsvd = 0xfc000f00,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_TXGBOX_1",  .addr = A_CH0_COE_STATUS_TXGBOX_1,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_TXGBOX_2",  .addr = A_CH0_COE_STATUS_TXGBOX_2,
        .rsvd = 0xc000fc00,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_TX64B66B_0",
        .addr = A_CH0_COE_STATUS_TX64B66B_0,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_TX64B66B_1",
        .addr = A_CH0_COE_STATUS_TX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RX64B66B_0",
        .addr = A_CH0_COE_STATUS_RX64B66B_0,
        .rsvd = 0xff000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RX64B66B_1",
        .addr = A_CH0_COE_STATUS_RX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RX64B66B_2",
        .addr = A_CH0_COE_STATUS_RX64B66B_2,
        .rsvd = 0xfffffffc,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RXGBOX_FIFO_0",
        .addr = A_CH0_COE_STATUS_RXGBOX_FIFO_0,
        .rsvd = 0xf0000f00,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RXGBOX_FIFO_1",
        .addr = A_CH0_COE_STATUS_RXGBOX_FIFO_1,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RXGBOX_FIFO_2",
        .addr = A_CH0_COE_STATUS_RXGBOX_FIFO_2,
        .rsvd = 0xf000f000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RXGBOX_FIFO_3",
        .addr = A_CH0_COE_STATUS_RXGBOX_FIFO_3,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_RXGBOX_FIFO_4",
        .addr = A_CH0_COE_STATUS_RXGBOX_FIFO_4,
        .rsvd = 0xf000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_8B10BEB_RESET_0",
        .addr = A_CH0_COE_STATUS_8B10BEB_RESET_0,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_8B10BEB_RESET_1",
        .addr = A_CH0_COE_STATUS_8B10BEB_RESET_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_PMA_0",  .addr = A_CH0_COESTATUS_PMA_0,
        .rsvd = 0xff10f000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COE_STATUS_PLL_STATUS",
        .addr = A_CH0_COE_STATUS_PLL_STATUS,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_PMA_1",  .addr = A_CH0_COESTATUS_PMA_1,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_RX_FABRIC_INTF0",
        .addr = A_CH0_COESTATUS_RX_FABRIC_INTF0,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_RX_FABRIC_INTF1",
        .addr = A_CH0_COESTATUS_RX_FABRIC_INTF1,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_RX_FABRIC_INTF2",
        .addr = A_CH0_COESTATUS_RX_FABRIC_INTF2,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_RESET",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_RESET,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_CDR_CTRL,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_BUFG_CTRL,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_PD",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_PD,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_RCVD_DET,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_STAT",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_STAT,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_TX_EQ",
        .addr = A_CH0_COESTATUS_CHANNEL_TX_EQ,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_TX_ELEC",
        .addr = A_CH0_COESTATUS_CHANNEL_TX_ELEC,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT0,
        .rsvd = 0xc0000040,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1",
        .addr = A_CH0_COESTATUS_CHANNEL_PIPE_CTRL_STAT1,
        .rsvd = 0x3ff0000,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_00",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_00,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_01",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_02",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_02,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_03",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_03,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_04",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_04,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_05",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_06",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_06,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_07",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_07,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_08",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_08,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_09",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_09,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_10",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_10,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_COESTATUS_ADAPT_LOOP_11",
        .addr = A_CH0_COESTATUS_ADAPT_LOOP_11,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_POR_FSM",  .addr = A_COE_STATUS_POR_FSM,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_RCAL",  .addr = A_COE_STATUS_RCAL,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_APB0",  .addr = A_COE_STATUS_APB0,
        .rsvd = 0xfffffffc,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_APB1",  .addr = A_COE_STATUS_APB1,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_MST_RST_LOOPER0",
        .addr = A_COE_STATUS_MST_RST_LOOPER0,
        .rsvd = 0xffe00000,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_MST_RST_LOOPER1",
        .addr = A_COE_STATUS_MST_RST_LOOPER1,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_MST_RST_LOOPER2",
        .addr = A_COE_STATUS_MST_RST_LOOPER2,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_UB0",  .addr = A_COE_STATUS_UB0,
        .rsvd = 0x1,
        .ro = 0xffffffff,
    },{ .name = "COE_STATUS_UB1",  .addr = A_COE_STATUS_UB1,
        .rsvd = 0x5e28fc00,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_RESET0",
        .addr = A_CH1_COESTATUS_CHANNEL_RESET0,
        .rsvd = 0xf8000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_RESET1",
        .addr = A_CH1_COESTATUS_CHANNEL_RESET1,
        .rsvd = 0x7e000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_RESET2",
        .addr = A_CH1_COESTATUS_CHANNEL_RESET2,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_RATE3",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_RATE3,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_RATE2",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_RATE2,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_RATE0",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_RATE0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_RATE1",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_RATE1,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_TXUSRCLK_FREQ_CNT",
        .addr = A_CH1_COESTATUS_TXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_TXPHYCLK_FREQ_CNT",
        .addr = A_CH1_COESTATUS_TXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_TXPCSCLK_FREQ_CNT",
        .addr = A_CH1_COESTATUS_TXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_RXUSRCLK_FREQ_CNT",
        .addr = A_CH1_COESTATUS_RXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_RXPHYCLK_FREQ_CNT",
        .addr = A_CH1_COESTATUS_RXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_RXPCSCLK_FREQ_CNT",
        .addr = A_CH1_COESTATUS_RXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CRC_TX",  .addr = A_CH1_COESTATUS_CRC_TX,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CRC_RX",  .addr = A_CH1_COESTATUS_CRC_RX,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_00",  .addr = A_CH1_TXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_01",  .addr = A_CH1_TXCHICO_DBG_SIG_01,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_02",  .addr = A_CH1_TXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_03",  .addr = A_CH1_TXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_04",  .addr = A_CH1_TXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_05",  .addr = A_CH1_TXCHICO_DBG_SIG_05,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_06",  .addr = A_CH1_TXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_07",  .addr = A_CH1_TXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_08",  .addr = A_CH1_TXCHICO_DBG_SIG_08,
        .rsvd = 0xffc00001,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_09",  .addr = A_CH1_TXCHICO_DBG_SIG_09,
        .rsvd = 0xffc40000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_10",  .addr = A_CH1_TXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_11",  .addr = A_CH1_TXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_12",  .addr = A_CH1_TXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_13",  .addr = A_CH1_TXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_14",  .addr = A_CH1_TXCHICO_DBG_SIG_14,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_15",  .addr = A_CH1_TXCHICO_DBG_SIG_15,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_16",  .addr = A_CH1_TXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_17",  .addr = A_CH1_TXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_18",  .addr = A_CH1_TXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_19",  .addr = A_CH1_TXCHICO_DBG_SIG_19,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_20",  .addr = A_CH1_TXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_21",  .addr = A_CH1_TXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_22",  .addr = A_CH1_TXCHICO_DBG_SIG_22,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_23",  .addr = A_CH1_TXCHICO_DBG_SIG_23,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_24",  .addr = A_CH1_TXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_25",  .addr = A_CH1_TXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_26",  .addr = A_CH1_TXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_27",  .addr = A_CH1_TXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_28",  .addr = A_CH1_TXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_29",  .addr = A_CH1_TXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_30",  .addr = A_CH1_TXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_TXCHICO_DBG_SIG_31",  .addr = A_CH1_TXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_00",  .addr = A_CH1_RXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_01",  .addr = A_CH1_RXCHICO_DBG_SIG_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_02",  .addr = A_CH1_RXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_03",  .addr = A_CH1_RXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_04",  .addr = A_CH1_RXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_05",  .addr = A_CH1_RXCHICO_DBG_SIG_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_06",  .addr = A_CH1_RXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_07",  .addr = A_CH1_RXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_08",  .addr = A_CH1_RXCHICO_DBG_SIG_08,
        .rsvd = 0xfffff801,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_09",  .addr = A_CH1_RXCHICO_DBG_SIG_09,
        .rsvd = 0xffc00000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_10",  .addr = A_CH1_RXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_11",  .addr = A_CH1_RXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_12",  .addr = A_CH1_RXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_13",  .addr = A_CH1_RXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_14",  .addr = A_CH1_RXCHICO_DBG_SIG_14,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_15",  .addr = A_CH1_RXCHICO_DBG_SIG_15,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_16",  .addr = A_CH1_RXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff2,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_17",  .addr = A_CH1_RXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_18",  .addr = A_CH1_RXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_19",  .addr = A_CH1_RXCHICO_DBG_SIG_19,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_20",  .addr = A_CH1_RXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_21",  .addr = A_CH1_RXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_22",  .addr = A_CH1_RXCHICO_DBG_SIG_22,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_23",  .addr = A_CH1_RXCHICO_DBG_SIG_23,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_24",  .addr = A_CH1_RXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_25",  .addr = A_CH1_RXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_26",  .addr = A_CH1_RXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_27",  .addr = A_CH1_RXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_28",  .addr = A_CH1_RXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_29",  .addr = A_CH1_RXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_30",  .addr = A_CH1_RXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RXCHICO_DBG_SIG_31",  .addr = A_CH1_RXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_0",  .addr = A_CH1_COE_STATUS_EYESCAN_0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_1",  .addr = A_CH1_COE_STATUS_EYESCAN_1,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_2",  .addr = A_CH1_COE_STATUS_EYESCAN_2,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_3",  .addr = A_CH1_COE_STATUS_EYESCAN_3,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_4",  .addr = A_CH1_COE_STATUS_EYESCAN_4,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_5",  .addr = A_CH1_COE_STATUS_EYESCAN_5,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_6",  .addr = A_CH1_COE_STATUS_EYESCAN_6,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_7",  .addr = A_CH1_COE_STATUS_EYESCAN_7,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_8",  .addr = A_CH1_COE_STATUS_EYESCAN_8,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_9",  .addr = A_CH1_COE_STATUS_EYESCAN_9,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_10",
        .addr = A_CH1_COE_STATUS_EYESCAN_10,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_EYESCAN_11",
        .addr = A_CH1_COE_STATUS_EYESCAN_11,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_PRBSERR_CNT_0",
        .addr = A_CH1_COE_STATUS_PRBSERR_CNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_PRBSERR_CNT_1",
        .addr = A_CH1_COE_STATUS_PRBSERR_CNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RX_CYCLECNT_0",
        .addr = A_CH1_COE_STATUS_RX_CYCLECNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RX_CYCLECNT_1",
        .addr = A_CH1_COE_STATUS_RX_CYCLECNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_PRBS_LINK2RESEED_CNT",
        .addr = A_CH1_COE_STATUS_PRBS_LINK2RESEED_CNT,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_TXGBOX_0",  .addr = A_CH1_COE_STATUS_TXGBOX_0,
        .rsvd = 0xfc000f00,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_TXGBOX_1",  .addr = A_CH1_COE_STATUS_TXGBOX_1,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_TXGBOX_2",  .addr = A_CH1_COE_STATUS_TXGBOX_2,
        .rsvd = 0xc000fc00,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_TX64B66B_0",
        .addr = A_CH1_COE_STATUS_TX64B66B_0,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_TX64B66B_1",
        .addr = A_CH1_COE_STATUS_TX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RX64B66B_0",
        .addr = A_CH1_COE_STATUS_RX64B66B_0,
        .rsvd = 0xff000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RX64B66B_1",
        .addr = A_CH1_COE_STATUS_RX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RX64B66B_2",
        .addr = A_CH1_COE_STATUS_RX64B66B_2,
        .rsvd = 0xfffffffc,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RXGBOX_FIFO_0",
        .addr = A_CH1_COE_STATUS_RXGBOX_FIFO_0,
        .rsvd = 0xf0000f00,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RXGBOX_FIFO_1",
        .addr = A_CH1_COE_STATUS_RXGBOX_FIFO_1,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RXGBOX_FIFO_2",
        .addr = A_CH1_COE_STATUS_RXGBOX_FIFO_2,
        .rsvd = 0xf000f000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RXGBOX_FIFO_3",
        .addr = A_CH1_COE_STATUS_RXGBOX_FIFO_3,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_RXGBOX_FIFO_4",
        .addr = A_CH1_COE_STATUS_RXGBOX_FIFO_4,
        .rsvd = 0xf000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_8B10BEB_RESET_0",
        .addr = A_CH1_COE_STATUS_8B10BEB_RESET_0,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_8B10BEB_RESET_1",
        .addr = A_CH1_COE_STATUS_8B10BEB_RESET_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_PMA_0",  .addr = A_CH1_COESTATUS_PMA_0,
        .rsvd = 0xff10f000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COE_STATUS_PLL_STATUS",
        .addr = A_CH1_COE_STATUS_PLL_STATUS,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_PMA_1",  .addr = A_CH1_COESTATUS_PMA_1,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_RX_FABRIC_INTF0",
        .addr = A_CH1_COESTATUS_RX_FABRIC_INTF0,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_RX_FABRIC_INTF1",
        .addr = A_CH1_COESTATUS_RX_FABRIC_INTF1,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_RX_FABRIC_INTF2",
        .addr = A_CH1_COESTATUS_RX_FABRIC_INTF2,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_RESET",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_RESET,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_CDR_CTRL,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_BUFG_CTRL,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_PD",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_PD,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_RCVD_DET,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_STAT",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_STAT,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_TX_EQ",
        .addr = A_CH1_COESTATUS_CHANNEL_TX_EQ,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_TX_ELEC",
        .addr = A_CH1_COESTATUS_CHANNEL_TX_ELEC,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT0,
        .rsvd = 0xc0000040,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1",
        .addr = A_CH1_COESTATUS_CHANNEL_PIPE_CTRL_STAT1,
        .rsvd = 0x3ff0000,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_00",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_00,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_01",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_02",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_02,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_03",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_03,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_04",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_04,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_05",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_06",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_06,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_07",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_07,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_08",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_08,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_09",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_09,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_10",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_10,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_COESTATUS_ADAPT_LOOP_11",
        .addr = A_CH1_COESTATUS_ADAPT_LOOP_11,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_RESET0",
        .addr = A_CH2_COESTATUS_CHANNEL_RESET0,
        .rsvd = 0xf8000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_RESET1",
        .addr = A_CH2_COESTATUS_CHANNEL_RESET1,
        .rsvd = 0x7e000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_RESET2",
        .addr = A_CH2_COESTATUS_CHANNEL_RESET2,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_RATE3",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_RATE3,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_RATE2",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_RATE2,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_RATE0",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_RATE0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_RATE1",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_RATE1,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_TXUSRCLK_FREQ_CNT",
        .addr = A_CH2_COESTATUS_TXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_TXPHYCLK_FREQ_CNT",
        .addr = A_CH2_COESTATUS_TXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_TXPCSCLK_FREQ_CNT",
        .addr = A_CH2_COESTATUS_TXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_RXUSRCLK_FREQ_CNT",
        .addr = A_CH2_COESTATUS_RXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_RXPHYCLK_FREQ_CNT",
        .addr = A_CH2_COESTATUS_RXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_RXPCSCLK_FREQ_CNT",
        .addr = A_CH2_COESTATUS_RXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CRC_TX",  .addr = A_CH2_COESTATUS_CRC_TX,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CRC_RX",  .addr = A_CH2_COESTATUS_CRC_RX,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_00",  .addr = A_CH2_TXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_01",  .addr = A_CH2_TXCHICO_DBG_SIG_01,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_02",  .addr = A_CH2_TXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_03",  .addr = A_CH2_TXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_04",  .addr = A_CH2_TXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_05",  .addr = A_CH2_TXCHICO_DBG_SIG_05,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_06",  .addr = A_CH2_TXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_07",  .addr = A_CH2_TXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_08",  .addr = A_CH2_TXCHICO_DBG_SIG_08,
        .rsvd = 0xffc00001,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_09",  .addr = A_CH2_TXCHICO_DBG_SIG_09,
        .rsvd = 0xffc40000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_10",  .addr = A_CH2_TXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_11",  .addr = A_CH2_TXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_12",  .addr = A_CH2_TXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_13",  .addr = A_CH2_TXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_14",  .addr = A_CH2_TXCHICO_DBG_SIG_14,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_15",  .addr = A_CH2_TXCHICO_DBG_SIG_15,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_16",  .addr = A_CH2_TXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_17",  .addr = A_CH2_TXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_18",  .addr = A_CH2_TXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_19",  .addr = A_CH2_TXCHICO_DBG_SIG_19,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_20",  .addr = A_CH2_TXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_21",  .addr = A_CH2_TXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_22",  .addr = A_CH2_TXCHICO_DBG_SIG_22,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_23",  .addr = A_CH2_TXCHICO_DBG_SIG_23,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_24",  .addr = A_CH2_TXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_25",  .addr = A_CH2_TXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_26",  .addr = A_CH2_TXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_27",  .addr = A_CH2_TXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_28",  .addr = A_CH2_TXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_29",  .addr = A_CH2_TXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_30",  .addr = A_CH2_TXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_TXCHICO_DBG_SIG_31",  .addr = A_CH2_TXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_00",  .addr = A_CH2_RXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_01",  .addr = A_CH2_RXCHICO_DBG_SIG_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_02",  .addr = A_CH2_RXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_03",  .addr = A_CH2_RXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_04",  .addr = A_CH2_RXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_05",  .addr = A_CH2_RXCHICO_DBG_SIG_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_06",  .addr = A_CH2_RXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_07",  .addr = A_CH2_RXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_08",  .addr = A_CH2_RXCHICO_DBG_SIG_08,
        .rsvd = 0xfffff801,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_09",  .addr = A_CH2_RXCHICO_DBG_SIG_09,
        .rsvd = 0xffc00000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_10",  .addr = A_CH2_RXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_11",  .addr = A_CH2_RXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_12",  .addr = A_CH2_RXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_13",  .addr = A_CH2_RXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_14",  .addr = A_CH2_RXCHICO_DBG_SIG_14,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_15",  .addr = A_CH2_RXCHICO_DBG_SIG_15,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_16",  .addr = A_CH2_RXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff2,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_17",  .addr = A_CH2_RXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_18",  .addr = A_CH2_RXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_19",  .addr = A_CH2_RXCHICO_DBG_SIG_19,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_20",  .addr = A_CH2_RXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_21",  .addr = A_CH2_RXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_22",  .addr = A_CH2_RXCHICO_DBG_SIG_22,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_23",  .addr = A_CH2_RXCHICO_DBG_SIG_23,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_24",  .addr = A_CH2_RXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_25",  .addr = A_CH2_RXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_26",  .addr = A_CH2_RXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_27",  .addr = A_CH2_RXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_28",  .addr = A_CH2_RXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_29",  .addr = A_CH2_RXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_30",  .addr = A_CH2_RXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RXCHICO_DBG_SIG_31",  .addr = A_CH2_RXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_0",  .addr = A_CH2_COE_STATUS_EYESCAN_0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_1",  .addr = A_CH2_COE_STATUS_EYESCAN_1,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_2",  .addr = A_CH2_COE_STATUS_EYESCAN_2,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_3",  .addr = A_CH2_COE_STATUS_EYESCAN_3,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_4",  .addr = A_CH2_COE_STATUS_EYESCAN_4,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_5",  .addr = A_CH2_COE_STATUS_EYESCAN_5,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_6",  .addr = A_CH2_COE_STATUS_EYESCAN_6,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_7",  .addr = A_CH2_COE_STATUS_EYESCAN_7,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_8",  .addr = A_CH2_COE_STATUS_EYESCAN_8,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_9",  .addr = A_CH2_COE_STATUS_EYESCAN_9,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_10",
        .addr = A_CH2_COE_STATUS_EYESCAN_10,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_EYESCAN_11",
        .addr = A_CH2_COE_STATUS_EYESCAN_11,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_PRBSERR_CNT_0",
        .addr = A_CH2_COE_STATUS_PRBSERR_CNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_PRBSERR_CNT_1",
        .addr = A_CH2_COE_STATUS_PRBSERR_CNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RX_CYCLECNT_0",
        .addr = A_CH2_COE_STATUS_RX_CYCLECNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RX_CYCLECNT_1",
        .addr = A_CH2_COE_STATUS_RX_CYCLECNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_PRBS_LINK2RESEED_CNT",
        .addr = A_CH2_COE_STATUS_PRBS_LINK2RESEED_CNT,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_TXGBOX_0",  .addr = A_CH2_COE_STATUS_TXGBOX_0,
        .rsvd = 0xfc000f00,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_TXGBOX_1",  .addr = A_CH2_COE_STATUS_TXGBOX_1,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_TXGBOX_2",  .addr = A_CH2_COE_STATUS_TXGBOX_2,
        .rsvd = 0xc000fc00,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_TX64B66B_0",
        .addr = A_CH2_COE_STATUS_TX64B66B_0,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_TX64B66B_1",
        .addr = A_CH2_COE_STATUS_TX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RX64B66B_0",
        .addr = A_CH2_COE_STATUS_RX64B66B_0,
        .rsvd = 0xff000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RX64B66B_1",
        .addr = A_CH2_COE_STATUS_RX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RX64B66B_2",
        .addr = A_CH2_COE_STATUS_RX64B66B_2,
        .rsvd = 0xfffffffc,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RXGBOX_FIFO_0",
        .addr = A_CH2_COE_STATUS_RXGBOX_FIFO_0,
        .rsvd = 0xf0000f00,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RXGBOX_FIFO_1",
        .addr = A_CH2_COE_STATUS_RXGBOX_FIFO_1,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RXGBOX_FIFO_2",
        .addr = A_CH2_COE_STATUS_RXGBOX_FIFO_2,
        .rsvd = 0xf000f000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RXGBOX_FIFO_3",
        .addr = A_CH2_COE_STATUS_RXGBOX_FIFO_3,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_RXGBOX_FIFO_4",
        .addr = A_CH2_COE_STATUS_RXGBOX_FIFO_4,
        .rsvd = 0xf000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_8B10BEB_RESET_0",
        .addr = A_CH2_COE_STATUS_8B10BEB_RESET_0,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_8B10BEB_RESET_1",
        .addr = A_CH2_COE_STATUS_8B10BEB_RESET_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_PMA_0",  .addr = A_CH2_COESTATUS_PMA_0,
        .rsvd = 0xff10f000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COE_STATUS_PLL_STATUS",
        .addr = A_CH2_COE_STATUS_PLL_STATUS,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_PMA_1",  .addr = A_CH2_COESTATUS_PMA_1,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_RX_FABRIC_INTF0",
        .addr = A_CH2_COESTATUS_RX_FABRIC_INTF0,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_RX_FABRIC_INTF1",
        .addr = A_CH2_COESTATUS_RX_FABRIC_INTF1,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_RX_FABRIC_INTF2",
        .addr = A_CH2_COESTATUS_RX_FABRIC_INTF2,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_RESET",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_RESET,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_CDR_CTRL,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_BUFG_CTRL,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_PD",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_PD,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_RCVD_DET,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_STAT",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_STAT,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_TX_EQ",
        .addr = A_CH2_COESTATUS_CHANNEL_TX_EQ,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_TX_ELEC",
        .addr = A_CH2_COESTATUS_CHANNEL_TX_ELEC,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT0,
        .rsvd = 0xc0000040,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1",
        .addr = A_CH2_COESTATUS_CHANNEL_PIPE_CTRL_STAT1,
        .rsvd = 0x3ff0000,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_00",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_00,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_01",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_02",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_02,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_03",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_03,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_04",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_04,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_05",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_06",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_06,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_07",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_07,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_08",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_08,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_09",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_09,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_10",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_10,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_COESTATUS_ADAPT_LOOP_11",
        .addr = A_CH2_COESTATUS_ADAPT_LOOP_11,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_RESET0",
        .addr = A_CH3_COESTATUS_CHANNEL_RESET0,
        .rsvd = 0xf8000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_RESET1",
        .addr = A_CH3_COESTATUS_CHANNEL_RESET1,
        .rsvd = 0x7e000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_RESET2",
        .addr = A_CH3_COESTATUS_CHANNEL_RESET2,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_RATE3",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_RATE3,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_RATE2",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_RATE2,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_RATE0",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_RATE0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_RATE1",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_RATE1,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_TXUSRCLK_FREQ_CNT",
        .addr = A_CH3_COESTATUS_TXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_TXPHYCLK_FREQ_CNT",
        .addr = A_CH3_COESTATUS_TXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_TXPCSCLK_FREQ_CNT",
        .addr = A_CH3_COESTATUS_TXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_RXUSRCLK_FREQ_CNT",
        .addr = A_CH3_COESTATUS_RXUSRCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_RXPHYCLK_FREQ_CNT",
        .addr = A_CH3_COESTATUS_RXPHYCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_RXPCSCLK_FREQ_CNT",
        .addr = A_CH3_COESTATUS_RXPCSCLK_FREQ_CNT,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CRC_TX",  .addr = A_CH3_COESTATUS_CRC_TX,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CRC_RX",  .addr = A_CH3_COESTATUS_CRC_RX,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_00",  .addr = A_CH3_TXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_01",  .addr = A_CH3_TXCHICO_DBG_SIG_01,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_02",  .addr = A_CH3_TXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_03",  .addr = A_CH3_TXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_04",  .addr = A_CH3_TXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_05",  .addr = A_CH3_TXCHICO_DBG_SIG_05,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_06",  .addr = A_CH3_TXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_07",  .addr = A_CH3_TXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_08",  .addr = A_CH3_TXCHICO_DBG_SIG_08,
        .rsvd = 0xffc00001,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_09",  .addr = A_CH3_TXCHICO_DBG_SIG_09,
        .rsvd = 0xffc40000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_10",  .addr = A_CH3_TXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_11",  .addr = A_CH3_TXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_12",  .addr = A_CH3_TXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_13",  .addr = A_CH3_TXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_14",  .addr = A_CH3_TXCHICO_DBG_SIG_14,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_15",  .addr = A_CH3_TXCHICO_DBG_SIG_15,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_16",  .addr = A_CH3_TXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_17",  .addr = A_CH3_TXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_18",  .addr = A_CH3_TXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_19",  .addr = A_CH3_TXCHICO_DBG_SIG_19,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_20",  .addr = A_CH3_TXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_21",  .addr = A_CH3_TXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_22",  .addr = A_CH3_TXCHICO_DBG_SIG_22,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_23",  .addr = A_CH3_TXCHICO_DBG_SIG_23,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_24",  .addr = A_CH3_TXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_25",  .addr = A_CH3_TXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_26",  .addr = A_CH3_TXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_27",  .addr = A_CH3_TXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_28",  .addr = A_CH3_TXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_29",  .addr = A_CH3_TXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_30",  .addr = A_CH3_TXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_TXCHICO_DBG_SIG_31",  .addr = A_CH3_TXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_00",  .addr = A_CH3_RXCHICO_DBG_SIG_00,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_01",  .addr = A_CH3_RXCHICO_DBG_SIG_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_02",  .addr = A_CH3_RXCHICO_DBG_SIG_02,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_03",  .addr = A_CH3_RXCHICO_DBG_SIG_03,
        .rsvd = 0xfffe0001,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_04",  .addr = A_CH3_RXCHICO_DBG_SIG_04,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_05",  .addr = A_CH3_RXCHICO_DBG_SIG_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_06",  .addr = A_CH3_RXCHICO_DBG_SIG_06,
        .rsvd = 0xc0000001,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_07",  .addr = A_CH3_RXCHICO_DBG_SIG_07,
        .rsvd = 0xffffc001,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_08",  .addr = A_CH3_RXCHICO_DBG_SIG_08,
        .rsvd = 0xfffff801,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_09",  .addr = A_CH3_RXCHICO_DBG_SIG_09,
        .rsvd = 0xffc00000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_10",  .addr = A_CH3_RXCHICO_DBG_SIG_10,
        .rsvd = 0xfffc0000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_11",  .addr = A_CH3_RXCHICO_DBG_SIG_11,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_12",  .addr = A_CH3_RXCHICO_DBG_SIG_12,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_13",  .addr = A_CH3_RXCHICO_DBG_SIG_13,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_14",  .addr = A_CH3_RXCHICO_DBG_SIG_14,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_15",  .addr = A_CH3_RXCHICO_DBG_SIG_15,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_16",  .addr = A_CH3_RXCHICO_DBG_SIG_16,
        .rsvd = 0xfffffff2,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_17",  .addr = A_CH3_RXCHICO_DBG_SIG_17,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_18",  .addr = A_CH3_RXCHICO_DBG_SIG_18,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_19",  .addr = A_CH3_RXCHICO_DBG_SIG_19,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_20",  .addr = A_CH3_RXCHICO_DBG_SIG_20,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_21",  .addr = A_CH3_RXCHICO_DBG_SIG_21,
        .rsvd = 0xfffffe01,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_22",  .addr = A_CH3_RXCHICO_DBG_SIG_22,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_23",  .addr = A_CH3_RXCHICO_DBG_SIG_23,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_24",  .addr = A_CH3_RXCHICO_DBG_SIG_24,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_25",  .addr = A_CH3_RXCHICO_DBG_SIG_25,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_26",  .addr = A_CH3_RXCHICO_DBG_SIG_26,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_27",  .addr = A_CH3_RXCHICO_DBG_SIG_27,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_28",  .addr = A_CH3_RXCHICO_DBG_SIG_28,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_29",  .addr = A_CH3_RXCHICO_DBG_SIG_29,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_30",  .addr = A_CH3_RXCHICO_DBG_SIG_30,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RXCHICO_DBG_SIG_31",  .addr = A_CH3_RXCHICO_DBG_SIG_31,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_0",  .addr = A_CH3_COE_STATUS_EYESCAN_0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_1",  .addr = A_CH3_COE_STATUS_EYESCAN_1,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_2",  .addr = A_CH3_COE_STATUS_EYESCAN_2,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_3",  .addr = A_CH3_COE_STATUS_EYESCAN_3,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_4",  .addr = A_CH3_COE_STATUS_EYESCAN_4,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_5",  .addr = A_CH3_COE_STATUS_EYESCAN_5,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_6",  .addr = A_CH3_COE_STATUS_EYESCAN_6,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_7",  .addr = A_CH3_COE_STATUS_EYESCAN_7,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_8",  .addr = A_CH3_COE_STATUS_EYESCAN_8,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_9",  .addr = A_CH3_COE_STATUS_EYESCAN_9,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_10",
        .addr = A_CH3_COE_STATUS_EYESCAN_10,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_EYESCAN_11",
        .addr = A_CH3_COE_STATUS_EYESCAN_11,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_PRBSERR_CNT_0",
        .addr = A_CH3_COE_STATUS_PRBSERR_CNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_PRBSERR_CNT_1",
        .addr = A_CH3_COE_STATUS_PRBSERR_CNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RX_CYCLECNT_0",
        .addr = A_CH3_COE_STATUS_RX_CYCLECNT_0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RX_CYCLECNT_1",
        .addr = A_CH3_COE_STATUS_RX_CYCLECNT_1,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_PRBS_LINK2RESEED_CNT",
        .addr = A_CH3_COE_STATUS_PRBS_LINK2RESEED_CNT,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_TXGBOX_0",  .addr = A_CH3_COE_STATUS_TXGBOX_0,
        .rsvd = 0xfc000f00,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_TXGBOX_1",  .addr = A_CH3_COE_STATUS_TXGBOX_1,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_TXGBOX_2",  .addr = A_CH3_COE_STATUS_TXGBOX_2,
        .rsvd = 0xc000fc00,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_TX64B66B_0",
        .addr = A_CH3_COE_STATUS_TX64B66B_0,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_TX64B66B_1",
        .addr = A_CH3_COE_STATUS_TX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RX64B66B_0",
        .addr = A_CH3_COE_STATUS_RX64B66B_0,
        .rsvd = 0xff000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RX64B66B_1",
        .addr = A_CH3_COE_STATUS_RX64B66B_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RX64B66B_2",
        .addr = A_CH3_COE_STATUS_RX64B66B_2,
        .rsvd = 0xfffffffc,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RXGBOX_FIFO_0",
        .addr = A_CH3_COE_STATUS_RXGBOX_FIFO_0,
        .rsvd = 0xf0000f00,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RXGBOX_FIFO_1",
        .addr = A_CH3_COE_STATUS_RXGBOX_FIFO_1,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RXGBOX_FIFO_2",
        .addr = A_CH3_COE_STATUS_RXGBOX_FIFO_2,
        .rsvd = 0xf000f000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RXGBOX_FIFO_3",
        .addr = A_CH3_COE_STATUS_RXGBOX_FIFO_3,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_RXGBOX_FIFO_4",
        .addr = A_CH3_COE_STATUS_RXGBOX_FIFO_4,
        .rsvd = 0xf000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_8B10BEB_RESET_0",
        .addr = A_CH3_COE_STATUS_8B10BEB_RESET_0,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_8B10BEB_RESET_1",
        .addr = A_CH3_COE_STATUS_8B10BEB_RESET_1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_PMA_0",  .addr = A_CH3_COESTATUS_PMA_0,
        .rsvd = 0xff10f000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COE_STATUS_PLL_STATUS",
        .addr = A_CH3_COE_STATUS_PLL_STATUS,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_PMA_1",  .addr = A_CH3_COESTATUS_PMA_1,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_RX_FABRIC_INTF0",
        .addr = A_CH3_COESTATUS_RX_FABRIC_INTF0,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_RX_FABRIC_INTF1",
        .addr = A_CH3_COESTATUS_RX_FABRIC_INTF1,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_RX_FABRIC_INTF2",
        .addr = A_CH3_COESTATUS_RX_FABRIC_INTF2,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_RESET",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_RESET,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_CDR_CTRL,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_BUFG_CTRL,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_PD",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_PD,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_RCVD_DET,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_STAT",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_STAT,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_TX_EQ",
        .addr = A_CH3_COESTATUS_CHANNEL_TX_EQ,
        .rsvd = 0xfc000000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_TX_ELEC",
        .addr = A_CH3_COESTATUS_CHANNEL_TX_ELEC,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT0,
        .rsvd = 0xc0000040,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1",
        .addr = A_CH3_COESTATUS_CHANNEL_PIPE_CTRL_STAT1,
        .rsvd = 0x3ff0000,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_00",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_00,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_01",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_01,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_02",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_02,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_03",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_03,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_04",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_04,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_05",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_05,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_06",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_06,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_07",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_07,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_08",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_08,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_09",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_09,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_10",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_10,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_COESTATUS_ADAPT_LOOP_11",
        .addr = A_CH3_COESTATUS_ADAPT_LOOP_11,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_TOP_CFG0",  .addr = A_RCALBG_RCALBG_TOP_CFG0,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "RCALBG_RCALBG_TOP_CFG1",  .addr = A_RCALBG_RCALBG_TOP_CFG1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "MEMCELLX3008",  .addr = A_MEMCELLX3008,
        .rsvd = 0x8fffff,
        .ro = 0x8fffff,
    },{ .name = "CTRL_RSV_CFG0",  .addr = A_CTRL_RSV_CFG0,
        .rsvd = 0xe007e00,
        .ro = 0xe007e00,
    },{ .name = "RCALBG_RCALBG_TOP_CFG2",  .addr = A_RCALBG_RCALBG_TOP_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_TOP_CFG3",  .addr = A_RCALBG_RCALBG_TOP_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_TOP_CFG4",  .addr = A_RCALBG_RCALBG_TOP_CFG4,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_TOP_CFG5",  .addr = A_RCALBG_RCALBG_TOP_CFG5,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "HSCLK0_LCPLL_LGC_CFG0",  .addr = A_HSCLK0_LCPLL_LGC_CFG0,
        .rsvd = 0x4000,
        .ro = 0x4000,
    },{ .name = "HSCLK0_LCPLL_LGC_CFG1",  .addr = A_HSCLK0_LCPLL_LGC_CFG1,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "HSCLK0_LCPLL_LGC_CFG2",  .addr = A_HSCLK0_LCPLL_LGC_CFG2,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "HSCLK0_LCPLL_CFG0",  .addr = A_HSCLK0_LCPLL_CFG0,
        .rsvd = 0xe000000,
        .ro = 0xe000000,
    },{ .name = "UB_CFG0",  .addr = A_UB_CFG0,
        .rsvd = 0xf6de5,
        .ro = 0xf6de5,
    },{ .name = "TERMPROG_CFG",  .addr = A_TERMPROG_CFG,
        .rsvd = 0xfffff000,
        .ro = 0xfffff000,
    },{ .name = "MEMCELLX3048",  .addr = A_MEMCELLX3048,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "MEMCELLX304C",  .addr = A_MEMCELLX304C,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "HSCLK0_LCPLL_CFG1",  .addr = A_HSCLK0_LCPLL_CFG1,
        .rsvd = 0x7e00000,
        .ro = 0x7e00000,
    },{ .name = "HSCLK0_LCPLL_CFG2",  .addr = A_HSCLK0_LCPLL_CFG2,
        .rsvd = 0x7f0,
        .ro = 0x7f0,
    },{ .name = "CH0_RESET_TIME_CFG0",  .addr = A_CH0_RESET_TIME_CFG0,
        .rsvd = 0xc00003e0,
        .ro = 0xc00003e0,
    },{ .name = "CH0_RESET_TIME_CFG1",  .addr = A_CH0_RESET_TIME_CFG1,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH0_RESET_TIME_CFG2",  .addr = A_CH0_RESET_TIME_CFG2,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH0_RESET_TIME_CFG3",  .addr = A_CH0_RESET_TIME_CFG3,
    },{ .name = "CH0_RESET_LOOPER_ID_CFG",  .addr = A_CH0_RESET_LOOPER_ID_CFG,
    },{ .name = "CH0_RESET_LOOP_ID_CFG0",  .addr = A_CH0_RESET_LOOP_ID_CFG0,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH0_RESET_LOOP_ID_CFG1",  .addr = A_CH0_RESET_LOOP_ID_CFG1,
    },{ .name = "CH0_RESET_LOOP_ID_CFG2",  .addr = A_CH0_RESET_LOOP_ID_CFG2,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH0_RESET_BYP_HDSHK_CFG",  .addr = A_CH0_RESET_BYP_HDSHK_CFG,
        .rsvd = 0xfffffc00,
        .ro = 0xfffffc00,
    },{ .name = "CH0_RESET_CFG",  .addr = A_CH0_RESET_CFG,
        .rsvd = 0x60300,
        .ro = 0x60300,
    },{ .name = "MEMCELLX30A0",  .addr = A_MEMCELLX30A0,
        .rsvd = 0x7fffff00,
        .ro = 0x7fffff00,
    },{ .name = "CH0_TX_ANA_CFG0",  .addr = A_CH0_TX_ANA_CFG0,
        .rsvd = 0xfffffe07,
        .ro = 0xfffffe07,
    },{ .name = "CH0_TX_DRV_CFG0",  .addr = A_CH0_TX_DRV_CFG0,
        .rsvd = 0x3ffe0,
        .ro = 0x3ffe0,
    },{ .name = "CH0_TX_DRV_CFG1",  .addr = A_CH0_TX_DRV_CFG1,
        .rsvd = 0x3800e000,
        .ro = 0x3800e000,
    },{ .name = "CH0_CHL_RSV_CFG0",  .addr = A_CH0_CHL_RSV_CFG0,
        .rsvd = 0xff80000,
        .ro = 0xff80000,
    },{ .name = "CH0_TX_SER_CFG0",  .addr = A_CH0_TX_SER_CFG0,
        .rsvd = 0xfffff007,
        .ro = 0xfffff007,
    },{ .name = "CH0_RX_CDR_CFG0",  .addr = A_CH0_RX_CDR_CFG0,
        .rsvd = 0x3c00800,
        .ro = 0x3c00800,
    },{ .name = "CH0_RX_CDR_CFG1",  .addr = A_CH0_RX_CDR_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_RX_CDR_CFG2",  .addr = A_CH0_RX_CDR_CFG2,
        .rsvd = 0xff0000,
        .ro = 0xff0000,
    },{ .name = "CH0_RX_CDR_CFG3",  .addr = A_CH0_RX_CDR_CFG3,
    },{ .name = "CH0_RX_CDR_CFG4",  .addr = A_CH0_RX_CDR_CFG4,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_ADAPT_APT_CFG",  .addr = A_CH0_ADAPT_APT_CFG,
    },{ .name = "CH0_ADAPT_CAL_CFG",  .addr = A_CH0_ADAPT_CAL_CFG,
    },{ .name = "CH0_ADAPT_DFE_CFG",  .addr = A_CH0_ADAPT_DFE_CFG,
    },{ .name = "CH0_ADAPT_GC_CFG0",  .addr = A_CH0_ADAPT_GC_CFG0,
    },{ .name = "CH0_ADAPT_GC_CFG1",  .addr = A_CH0_ADAPT_GC_CFG1,
    },{ .name = "CH0_ADAPT_GC_CFG2",  .addr = A_CH0_ADAPT_GC_CFG2,
    },{ .name = "CH0_ADAPT_GC_CFG3",  .addr = A_CH0_ADAPT_GC_CFG3,
    },{ .name = "CH0_ADAPT_GEN_CFG0",  .addr = A_CH0_ADAPT_GEN_CFG0,
    },{ .name = "CH0_ADAPT_GEN_CFG1",  .addr = A_CH0_ADAPT_GEN_CFG1,
    },{ .name = "CH0_ADAPT_GEN_CFG2",  .addr = A_CH0_ADAPT_GEN_CFG2,
    },{ .name = "CH0_ADAPT_GEN_CFG3",  .addr = A_CH0_ADAPT_GEN_CFG3,
    },{ .name = "CH0_ADAPT_H01_CFG",  .addr = A_CH0_ADAPT_H01_CFG,
    },{ .name = "CH0_ADAPT_H23_CFG",  .addr = A_CH0_ADAPT_H23_CFG,
    },{ .name = "CH0_ADAPT_H45_CFG",  .addr = A_CH0_ADAPT_H45_CFG,
    },{ .name = "CH0_ADAPT_H67_CFG",  .addr = A_CH0_ADAPT_H67_CFG,
    },{ .name = "CH0_ADAPT_H89_CFG",  .addr = A_CH0_ADAPT_H89_CFG,
    },{ .name = "CH0_ADAPT_HAB_CFG",  .addr = A_CH0_ADAPT_HAB_CFG,
    },{ .name = "CH0_ADAPT_HCD_CFG",  .addr = A_CH0_ADAPT_HCD_CFG,
    },{ .name = "CH0_ADAPT_HEF_CFG",  .addr = A_CH0_ADAPT_HEF_CFG,
        .rsvd = 0x1f0000,
        .ro = 0x1f0000,
    },{ .name = "CH0_ADAPT_KH_CFG0",  .addr = A_CH0_ADAPT_KH_CFG0,
    },{ .name = "CH0_ADAPT_KH_CFG1",  .addr = A_CH0_ADAPT_KH_CFG1,
    },{ .name = "CH0_ADAPT_KH_CFG2",  .addr = A_CH0_ADAPT_KH_CFG2,
    },{ .name = "CH0_ADAPT_KH_CFG3",  .addr = A_CH0_ADAPT_KH_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_ADAPT_KH_CFG4",  .addr = A_CH0_ADAPT_KH_CFG4,
    },{ .name = "CH0_ADAPT_KH_CFG5",  .addr = A_CH0_ADAPT_KH_CFG5,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_ADAPT_KL_CFG0",  .addr = A_CH0_ADAPT_KL_CFG0,
    },{ .name = "CH0_ADAPT_KL_CFG1",  .addr = A_CH0_ADAPT_KL_CFG1,
    },{ .name = "CH0_ADAPT_LCK_CFG0",  .addr = A_CH0_ADAPT_LCK_CFG0,
    },{ .name = "CH0_ADAPT_LCK_CFG1",  .addr = A_CH0_ADAPT_LCK_CFG1,
    },{ .name = "CH0_ADAPT_LCK_CFG2",  .addr = A_CH0_ADAPT_LCK_CFG2,
    },{ .name = "CH0_ADAPT_LCK_CFG3",  .addr = A_CH0_ADAPT_LCK_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_ADAPT_LOP_CFG",  .addr = A_CH0_ADAPT_LOP_CFG,
    },{ .name = "CH0_ADAPT_OS_CFG",  .addr = A_CH0_ADAPT_OS_CFG,
    },{ .name = "CH0_RX_CRC_CFG0",  .addr = A_CH0_RX_CRC_CFG0,
    },{ .name = "CH0_RX_CRC_CFG1",  .addr = A_CH0_RX_CRC_CFG1,
    },{ .name = "CH0_RX_CRC_CFG2",  .addr = A_CH0_RX_CRC_CFG2,
    },{ .name = "CH0_RX_CRC_CFG3",  .addr = A_CH0_RX_CRC_CFG3,
    },{ .name = "CH0_TX_CRC_CFG0",  .addr = A_CH0_TX_CRC_CFG0,
        .rsvd = 0x80,
        .ro = 0x80,
    },{ .name = "CH0_TX_CRC_CFG1",  .addr = A_CH0_TX_CRC_CFG1,
    },{ .name = "CH0_TX_CRC_CFG2",  .addr = A_CH0_TX_CRC_CFG2,
    },{ .name = "CH0_TX_CRC_CFG3",  .addr = A_CH0_TX_CRC_CFG3,
    },{ .name = "CH0_DA_CFG",  .addr = A_CH0_DA_CFG,
    },{ .name = "CH0_RX_CTLE_CFG0",  .addr = A_CH0_RX_CTLE_CFG0,
    },{ .name = "CH0_RX_CTLE_CFG1",  .addr = A_CH0_RX_CTLE_CFG1,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH0_RX_DACI2V_CFG0",  .addr = A_CH0_RX_DACI2V_CFG0,
        .rsvd = 0xe0000000,
        .ro = 0xe0000000,
    },{ .name = "CH0_RX_DFE_CFG0",  .addr = A_CH0_RX_DFE_CFG0,
    },{ .name = "CH0_RX_MISC_CFG0",  .addr = A_CH0_RX_MISC_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_CHL_RSV_CFG1",  .addr = A_CH0_CHL_RSV_CFG1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_RX_PAD_CFG0",  .addr = A_CH0_RX_PAD_CFG0,
    },{ .name = "CH0_RX_PAD_CFG1",  .addr = A_CH0_RX_PAD_CFG1,
    },{ .name = "CH0_RX_PCS_CFG0",  .addr = A_CH0_RX_PCS_CFG0,
        .rsvd = 0x200,
        .ro = 0x200,
    },{ .name = "CH0_RX_PCS_CFG1",  .addr = A_CH0_RX_PCS_CFG1,
    },{ .name = "CH0_RX_PCS_CFG2",  .addr = A_CH0_RX_PCS_CFG2,
    },{ .name = "CH0_RX_PCS_CFG3",  .addr = A_CH0_RX_PCS_CFG3,
        .rsvd = 0x640000,
        .ro = 0x640000,
    },{ .name = "CH0_RX_PCS_CFG4",  .addr = A_CH0_RX_PCS_CFG4,
    },{ .name = "CH0_CHCLK_MISC_CFG",  .addr = A_CH0_CHCLK_MISC_CFG,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_CHCLK_ILO_CFG",  .addr = A_CH0_CHCLK_ILO_CFG,
        .rsvd = 0xe0028f88,
        .ro = 0xe0028f88,
    },{ .name = "CH0_CHCLK_RXPI_CFG",  .addr = A_CH0_CHCLK_RXPI_CFG,
        .rsvd = 0xff800003,
        .ro = 0xff800003,
    },{ .name = "CH0_CHCLK_RXCAL_CFG",  .addr = A_CH0_CHCLK_RXCAL_CFG,
        .rsvd = 0x1,
        .ro = 0x1,
    },{ .name = "CH0_CHCLK_RXCAL_CFG1",  .addr = A_CH0_CHCLK_RXCAL_CFG1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "CH0_CHCLK_TXPI_CFG0",  .addr = A_CH0_CHCLK_TXPI_CFG0,
    },{ .name = "CH0_CHCLK_TXCAL_CFG",  .addr = A_CH0_CHCLK_TXCAL_CFG,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH0_CHCLK_RXCAL_CFG2",  .addr = A_CH0_CHCLK_RXCAL_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_CHCLK_RSV_CFG",  .addr = A_CH0_CHCLK_RSV_CFG,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_PIPE_TX_EQ_CFG0",  .addr = A_CH0_PIPE_TX_EQ_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_PIPE_TX_EQ_CFG1",  .addr = A_CH0_PIPE_TX_EQ_CFG1,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "CH0_PIPE_TX_EQ_CFG2",  .addr = A_CH0_PIPE_TX_EQ_CFG2,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
    },{ .name = "CH0_PIPE_TX_EQ_CFG3",  .addr = A_CH0_PIPE_TX_EQ_CFG3,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "CH0_TX_PCS_CFG0",  .addr = A_CH0_TX_PCS_CFG0,
    },{ .name = "CH0_TX_PCS_CFG1",  .addr = A_CH0_TX_PCS_CFG1,
    },{ .name = "CH0_TX_PCS_CFG2",  .addr = A_CH0_TX_PCS_CFG2,
        .rsvd = 0x40000000,
        .ro = 0x40000000,
    },{ .name = "CH0_TX_PCS_CFG3",  .addr = A_CH0_TX_PCS_CFG3,
    },{ .name = "CH0_EYESCAN_CFG0",  .addr = A_CH0_EYESCAN_CFG0,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH0_EYESCAN_CFG1",  .addr = A_CH0_EYESCAN_CFG1,
    },{ .name = "CH0_EYESCAN_CFG2",  .addr = A_CH0_EYESCAN_CFG2,
    },{ .name = "CH0_EYESCAN_CFG3",  .addr = A_CH0_EYESCAN_CFG3,
    },{ .name = "CH0_EYESCAN_CFG4",  .addr = A_CH0_EYESCAN_CFG4,
    },{ .name = "CH0_EYESCAN_CFG5",  .addr = A_CH0_EYESCAN_CFG5,
    },{ .name = "CH0_EYESCAN_CFG6",  .addr = A_CH0_EYESCAN_CFG6,
    },{ .name = "CH0_EYESCAN_CFG7",  .addr = A_CH0_EYESCAN_CFG7,
    },{ .name = "CH0_EYESCAN_CFG8",  .addr = A_CH0_EYESCAN_CFG8,
    },{ .name = "CH0_EYESCAN_CFG9",  .addr = A_CH0_EYESCAN_CFG9,
    },{ .name = "CH0_EYESCAN_CFG10",  .addr = A_CH0_EYESCAN_CFG10,
    },{ .name = "CH0_EYESCAN_CFG11",  .addr = A_CH0_EYESCAN_CFG11,
    },{ .name = "CH0_EYESCAN_CFG12",  .addr = A_CH0_EYESCAN_CFG12,
    },{ .name = "CH0_EYESCAN_CFG13",  .addr = A_CH0_EYESCAN_CFG13,
    },{ .name = "CH0_EYESCAN_CFG14",  .addr = A_CH0_EYESCAN_CFG14,
    },{ .name = "CH0_EYESCAN_CFG15",  .addr = A_CH0_EYESCAN_CFG15,
    },{ .name = "CH0_EYESCAN_CFG16",  .addr = A_CH0_EYESCAN_CFG16,
        .rsvd = 0x70000,
        .ro = 0x70000,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG0",  .addr = A_CH0_RX_ELASTIC_BUF_CFG0,
    },{ .name = "CH0_TX_10G_CFG0",  .addr = A_CH0_TX_10G_CFG0,
    },{ .name = "CH0_TX_10G_CFG1",  .addr = A_CH0_TX_10G_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_TX_10G_CFG2",  .addr = A_CH0_TX_10G_CFG2,
    },{ .name = "CH0_TX_10G_CFG3",  .addr = A_CH0_TX_10G_CFG3,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH0_RX_PHALIGN_CFG0",  .addr = A_CH0_RX_PHALIGN_CFG0,
    },{ .name = "CH0_RX_PHALIGN_CFG1",  .addr = A_CH0_RX_PHALIGN_CFG1,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH0_RX_PHALIGN_CFG2",  .addr = A_CH0_RX_PHALIGN_CFG2,
        .rsvd = 0x1f,
        .ro = 0x1f,
    },{ .name = "CH0_RX_PHALIGN_CFG3",  .addr = A_CH0_RX_PHALIGN_CFG3,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH0_RX_PHALIGN_CFG4",  .addr = A_CH0_RX_PHALIGN_CFG4,
    },{ .name = "CH0_RX_PHALIGN_CFG5",  .addr = A_CH0_RX_PHALIGN_CFG5,
        .rsvd = 0x7,
        .ro = 0x7,
    },{ .name = "CH0_TX_PHALIGN_CFG0",  .addr = A_CH0_TX_PHALIGN_CFG0,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH0_TX_PHALIGN_CFG1",  .addr = A_CH0_TX_PHALIGN_CFG1,
    },{ .name = "CH0_TX_PHALIGN_CFG2",  .addr = A_CH0_TX_PHALIGN_CFG2,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH0_TX_PHALIGN_CFG3",  .addr = A_CH0_TX_PHALIGN_CFG3,
    },{ .name = "CH0_TX_PHALIGN_CFG4",  .addr = A_CH0_TX_PHALIGN_CFG4,
        .rsvd = 0xc00,
        .ro = 0xc00,
    },{ .name = "CH0_TX_PHALIGN_CFG5",  .addr = A_CH0_TX_PHALIGN_CFG5,
    },{ .name = "CH0_PIPE_CTRL_CFG0",  .addr = A_CH0_PIPE_CTRL_CFG0,
    },{ .name = "CH0_PIPE_CTRL_CFG1",  .addr = A_CH0_PIPE_CTRL_CFG1,
    },{ .name = "CH0_PIPE_CTRL_CFG2",  .addr = A_CH0_PIPE_CTRL_CFG2,
    },{ .name = "CH0_PIPE_CTRL_CFG3",  .addr = A_CH0_PIPE_CTRL_CFG3,
    },{ .name = "CH0_PIPE_CTRL_CFG4",  .addr = A_CH0_PIPE_CTRL_CFG4,
    },{ .name = "CH0_PIPE_CTRL_CFG5",  .addr = A_CH0_PIPE_CTRL_CFG5,
    },{ .name = "CH0_PIPE_CTRL_CFG6",  .addr = A_CH0_PIPE_CTRL_CFG6,
    },{ .name = "CH0_PIPE_CTRL_CFG7",  .addr = A_CH0_PIPE_CTRL_CFG7,
    },{ .name = "CH0_PIPE_CTRL_CFG8",  .addr = A_CH0_PIPE_CTRL_CFG8,
    },{ .name = "CH0_PIPE_CTRL_CFG9",  .addr = A_CH0_PIPE_CTRL_CFG9,
    },{ .name = "CH0_TX_PIPPM_CFG",  .addr = A_CH0_TX_PIPPM_CFG,
        .rsvd = 0xc0007000,
        .ro = 0xc0007000,
    },{ .name = "CH0_CHL_RSV_CFG2",  .addr = A_CH0_CHL_RSV_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_FABRIC_INTF_CFG0",  .addr = A_CH0_FABRIC_INTF_CFG0,
    },{ .name = "CH0_FABRIC_INTF_CFG1",  .addr = A_CH0_FABRIC_INTF_CFG1,
        .rsvd = 0x7000,
        .ro = 0x7000,
    },{ .name = "CH0_FABRIC_INTF_CFG2",  .addr = A_CH0_FABRIC_INTF_CFG2,
    },{ .name = "CH0_FABRIC_INTF_CFG3",  .addr = A_CH0_FABRIC_INTF_CFG3,
    },{ .name = "CH0_FABRIC_INTF_CFG4",  .addr = A_CH0_FABRIC_INTF_CFG4,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "CH0_FABRIC_INTF_CFG5",  .addr = A_CH0_FABRIC_INTF_CFG5,
        .rsvd = 0x8,
        .ro = 0x8,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG1",  .addr = A_CH0_RX_ELASTIC_BUF_CFG1,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG2",  .addr = A_CH0_RX_ELASTIC_BUF_CFG2,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG3",  .addr = A_CH0_RX_ELASTIC_BUF_CFG3,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG4",  .addr = A_CH0_RX_ELASTIC_BUF_CFG4,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG5",  .addr = A_CH0_RX_ELASTIC_BUF_CFG5,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG6",  .addr = A_CH0_RX_ELASTIC_BUF_CFG6,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG7",  .addr = A_CH0_RX_ELASTIC_BUF_CFG7,
        .rsvd = 0xb800000,
        .ro = 0xb800000,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG8",  .addr = A_CH0_RX_ELASTIC_BUF_CFG8,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH0_RX_ELASTIC_BUF_CFG9",  .addr = A_CH0_RX_ELASTIC_BUF_CFG9,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH0_RX_OOB_CFG0",  .addr = A_CH0_RX_OOB_CFG0,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH0_RX_OOB_CFG1",  .addr = A_CH0_RX_OOB_CFG1,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "CH0_MONITOR_CFG",  .addr = A_CH0_MONITOR_CFG,
        .rsvd = 0xf00,
        .ro = 0xf00,
    },{ .name = "CH0_PIPE_CTRL_CFG10",  .addr = A_CH0_PIPE_CTRL_CFG10,
        .rsvd = 0x78000010,
        .ro = 0x78000010,
    },{ .name = "CH0_CHL_RSV_CFG3",  .addr = A_CH0_CHL_RSV_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH0_CHL_RSV_CFG4",  .addr = A_CH0_CHL_RSV_CFG4,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "MEMCELLX32F8",  .addr = A_MEMCELLX32F8,
        .rsvd = 0x3fffffff,
        .ro = 0x3fffffff,
    },{ .name = "HSCLK0_HSDIST_CFG",  .addr = A_HSCLK0_HSDIST_CFG,
        .rsvd = 0xfffeff60,
        .ro = 0xfffeff60,
    },{ .name = "HSCLK0_RPLL_LGC_CFG0",  .addr = A_HSCLK0_RPLL_LGC_CFG0,
        .rsvd = 0x4000,
        .ro = 0x4000,
    },{ .name = "HSCLK0_RPLL_LGC_CFG1",  .addr = A_HSCLK0_RPLL_LGC_CFG1,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "HSCLK0_RPLL_LGC_CFG2",  .addr = A_HSCLK0_RPLL_LGC_CFG2,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "HSCLK0_RPLL_CFG0",  .addr = A_HSCLK0_RPLL_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "TXRSTDONE_DIST_SEL",  .addr = A_TXRSTDONE_DIST_SEL,
        .rsvd = 0x80808080,
        .ro = 0x80808080,
    },{ .name = "RXRSTDONE_DIST_SEL",  .addr = A_RXRSTDONE_DIST_SEL,
        .rsvd = 0x80808080,
        .ro = 0x80808080,
    },{ .name = "MST_RESET_CFG",  .addr = A_MST_RESET_CFG,
    },{ .name = "POR_CFG",  .addr = A_POR_CFG,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "HSCLK0_RPLL_CFG1",  .addr = A_HSCLK0_RPLL_CFG1,
        .rsvd = 0x10,
        .ro = 0x10,
    },{ .name = "HSCLK0_RPLL_CFG2",  .addr = A_HSCLK0_RPLL_CFG2,
        .rsvd = 0x7ffc00,
        .ro = 0x7ffc00,
    },{ .name = "CH1_RESET_TIME_CFG0",  .addr = A_CH1_RESET_TIME_CFG0,
        .rsvd = 0xc00003e0,
        .ro = 0xc00003e0,
    },{ .name = "CH1_RESET_TIME_CFG1",  .addr = A_CH1_RESET_TIME_CFG1,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH1_RESET_TIME_CFG2",  .addr = A_CH1_RESET_TIME_CFG2,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH1_RESET_TIME_CFG3",  .addr = A_CH1_RESET_TIME_CFG3,
    },{ .name = "CH1_RESET_LOOPER_ID_CFG",  .addr = A_CH1_RESET_LOOPER_ID_CFG,
    },{ .name = "CH1_RESET_LOOP_ID_CFG0",  .addr = A_CH1_RESET_LOOP_ID_CFG0,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH1_RESET_LOOP_ID_CFG1",  .addr = A_CH1_RESET_LOOP_ID_CFG1,
    },{ .name = "CH1_RESET_LOOP_ID_CFG2",  .addr = A_CH1_RESET_LOOP_ID_CFG2,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH1_RESET_BYP_HDSHK_CFG",  .addr = A_CH1_RESET_BYP_HDSHK_CFG,
        .rsvd = 0xfffffc00,
        .ro = 0xfffffc00,
    },{ .name = "CH1_RESET_CFG",  .addr = A_CH1_RESET_CFG,
        .rsvd = 0x60300,
        .ro = 0x60300,
    },{ .name = "MEMCELLX34A0",  .addr = A_MEMCELLX34A0,
        .rsvd = 0x7fffff00,
        .ro = 0x7fffff00,
    },{ .name = "CH1_TX_ANA_CFG0",  .addr = A_CH1_TX_ANA_CFG0,
        .rsvd = 0xfffffe07,
        .ro = 0xfffffe07,
    },{ .name = "CH1_TX_DRV_CFG0",  .addr = A_CH1_TX_DRV_CFG0,
        .rsvd = 0x3ffe0,
        .ro = 0x3ffe0,
    },{ .name = "CH1_TX_DRV_CFG1",  .addr = A_CH1_TX_DRV_CFG1,
        .rsvd = 0x3800e000,
        .ro = 0x3800e000,
    },{ .name = "CH1_CHL_RSV_CFG0",  .addr = A_CH1_CHL_RSV_CFG0,
        .rsvd = 0xff80000,
        .ro = 0xff80000,
    },{ .name = "CH1_TX_SER_CFG0",  .addr = A_CH1_TX_SER_CFG0,
        .rsvd = 0xfffff007,
        .ro = 0xfffff007,
    },{ .name = "CH1_RX_CDR_CFG0",  .addr = A_CH1_RX_CDR_CFG0,
        .rsvd = 0x3c00800,
        .ro = 0x3c00800,
    },{ .name = "CH1_RX_CDR_CFG1",  .addr = A_CH1_RX_CDR_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_RX_CDR_CFG2",  .addr = A_CH1_RX_CDR_CFG2,
        .rsvd = 0xff0000,
        .ro = 0xff0000,
    },{ .name = "CH1_RX_CDR_CFG3",  .addr = A_CH1_RX_CDR_CFG3,
    },{ .name = "CH1_RX_CDR_CFG4",  .addr = A_CH1_RX_CDR_CFG4,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_ADAPT_APT_CFG",  .addr = A_CH1_ADAPT_APT_CFG,
    },{ .name = "CH1_ADAPT_CAL_CFG",  .addr = A_CH1_ADAPT_CAL_CFG,
    },{ .name = "CH1_ADAPT_DFE_CFG",  .addr = A_CH1_ADAPT_DFE_CFG,
    },{ .name = "CH1_ADAPT_GC_CFG0",  .addr = A_CH1_ADAPT_GC_CFG0,
    },{ .name = "CH1_ADAPT_GC_CFG1",  .addr = A_CH1_ADAPT_GC_CFG1,
    },{ .name = "CH1_ADAPT_GC_CFG2",  .addr = A_CH1_ADAPT_GC_CFG2,
    },{ .name = "CH1_ADAPT_GC_CFG3",  .addr = A_CH1_ADAPT_GC_CFG3,
    },{ .name = "CH1_ADAPT_GEN_CFG0",  .addr = A_CH1_ADAPT_GEN_CFG0,
    },{ .name = "CH1_ADAPT_GEN_CFG1",  .addr = A_CH1_ADAPT_GEN_CFG1,
    },{ .name = "CH1_ADAPT_GEN_CFG2",  .addr = A_CH1_ADAPT_GEN_CFG2,
    },{ .name = "CH1_ADAPT_GEN_CFG3",  .addr = A_CH1_ADAPT_GEN_CFG3,
    },{ .name = "CH1_ADAPT_H01_CFG",  .addr = A_CH1_ADAPT_H01_CFG,
    },{ .name = "CH1_ADAPT_H23_CFG",  .addr = A_CH1_ADAPT_H23_CFG,
    },{ .name = "CH1_ADAPT_H45_CFG",  .addr = A_CH1_ADAPT_H45_CFG,
    },{ .name = "CH1_ADAPT_H67_CFG",  .addr = A_CH1_ADAPT_H67_CFG,
    },{ .name = "CH1_ADAPT_H89_CFG",  .addr = A_CH1_ADAPT_H89_CFG,
    },{ .name = "CH1_ADAPT_HAB_CFG",  .addr = A_CH1_ADAPT_HAB_CFG,
    },{ .name = "CH1_ADAPT_HCD_CFG",  .addr = A_CH1_ADAPT_HCD_CFG,
    },{ .name = "CH1_ADAPT_HEF_CFG",  .addr = A_CH1_ADAPT_HEF_CFG,
        .rsvd = 0x1f0000,
        .ro = 0x1f0000,
    },{ .name = "CH1_ADAPT_KH_CFG0",  .addr = A_CH1_ADAPT_KH_CFG0,
    },{ .name = "CH1_ADAPT_KH_CFG1",  .addr = A_CH1_ADAPT_KH_CFG1,
    },{ .name = "CH1_ADAPT_KH_CFG2",  .addr = A_CH1_ADAPT_KH_CFG2,
    },{ .name = "CH1_ADAPT_KH_CFG3",  .addr = A_CH1_ADAPT_KH_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_ADAPT_KH_CFG4",  .addr = A_CH1_ADAPT_KH_CFG4,
    },{ .name = "CH1_ADAPT_KH_CFG5",  .addr = A_CH1_ADAPT_KH_CFG5,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_ADAPT_KL_CFG0",  .addr = A_CH1_ADAPT_KL_CFG0,
    },{ .name = "CH1_ADAPT_KL_CFG1",  .addr = A_CH1_ADAPT_KL_CFG1,
    },{ .name = "CH1_ADAPT_LCK_CFG0",  .addr = A_CH1_ADAPT_LCK_CFG0,
    },{ .name = "CH1_ADAPT_LCK_CFG1",  .addr = A_CH1_ADAPT_LCK_CFG1,
    },{ .name = "CH1_ADAPT_LCK_CFG2",  .addr = A_CH1_ADAPT_LCK_CFG2,
    },{ .name = "CH1_ADAPT_LCK_CFG3",  .addr = A_CH1_ADAPT_LCK_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_ADAPT_LOP_CFG",  .addr = A_CH1_ADAPT_LOP_CFG,
    },{ .name = "CH1_ADAPT_OS_CFG",  .addr = A_CH1_ADAPT_OS_CFG,
    },{ .name = "CH1_RX_CRC_CFG0",  .addr = A_CH1_RX_CRC_CFG0,
    },{ .name = "CH1_RX_CRC_CFG1",  .addr = A_CH1_RX_CRC_CFG1,
    },{ .name = "CH1_RX_CRC_CFG2",  .addr = A_CH1_RX_CRC_CFG2,
    },{ .name = "CH1_RX_CRC_CFG3",  .addr = A_CH1_RX_CRC_CFG3,
    },{ .name = "CH1_TX_CRC_CFG0",  .addr = A_CH1_TX_CRC_CFG0,
        .rsvd = 0x80,
        .ro = 0x80,
    },{ .name = "CH1_TX_CRC_CFG1",  .addr = A_CH1_TX_CRC_CFG1,
    },{ .name = "CH1_TX_CRC_CFG2",  .addr = A_CH1_TX_CRC_CFG2,
    },{ .name = "CH1_TX_CRC_CFG3",  .addr = A_CH1_TX_CRC_CFG3,
    },{ .name = "CH1_DA_CFG",  .addr = A_CH1_DA_CFG,
    },{ .name = "CH1_RX_CTLE_CFG0",  .addr = A_CH1_RX_CTLE_CFG0,
    },{ .name = "CH1_RX_CTLE_CFG1",  .addr = A_CH1_RX_CTLE_CFG1,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH1_RX_DACI2V_CFG0",  .addr = A_CH1_RX_DACI2V_CFG0,
        .rsvd = 0xe0000000,
        .ro = 0xe0000000,
    },{ .name = "CH1_RX_DFE_CFG0",  .addr = A_CH1_RX_DFE_CFG0,
    },{ .name = "CH1_RX_MISC_CFG0",  .addr = A_CH1_RX_MISC_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_CHL_RSV_CFG1",  .addr = A_CH1_CHL_RSV_CFG1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_RX_PAD_CFG0",  .addr = A_CH1_RX_PAD_CFG0,
    },{ .name = "CH1_RX_PAD_CFG1",  .addr = A_CH1_RX_PAD_CFG1,
    },{ .name = "CH1_RX_PCS_CFG0",  .addr = A_CH1_RX_PCS_CFG0,
        .rsvd = 0x200,
        .ro = 0x200,
    },{ .name = "CH1_RX_PCS_CFG1",  .addr = A_CH1_RX_PCS_CFG1,
    },{ .name = "CH1_RX_PCS_CFG2",  .addr = A_CH1_RX_PCS_CFG2,
    },{ .name = "CH1_RX_PCS_CFG3",  .addr = A_CH1_RX_PCS_CFG3,
        .rsvd = 0x640000,
        .ro = 0x640000,
    },{ .name = "CH1_RX_PCS_CFG4",  .addr = A_CH1_RX_PCS_CFG4,
    },{ .name = "CH1_CHCLK_MISC_CFG",  .addr = A_CH1_CHCLK_MISC_CFG,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_CHCLK_ILO_CFG",  .addr = A_CH1_CHCLK_ILO_CFG,
        .rsvd = 0xe0028f88,
        .ro = 0xe0028f88,
    },{ .name = "CH1_CHCLK_RXPI_CFG",  .addr = A_CH1_CHCLK_RXPI_CFG,
        .rsvd = 0xff800003,
        .ro = 0xff800003,
    },{ .name = "CH1_CHCLK_RXCAL_CFG",  .addr = A_CH1_CHCLK_RXCAL_CFG,
        .rsvd = 0x1,
        .ro = 0x1,
    },{ .name = "CH1_CHCLK_RXCAL_CFG1",  .addr = A_CH1_CHCLK_RXCAL_CFG1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "CH1_CHCLK_TXPI_CFG0",  .addr = A_CH1_CHCLK_TXPI_CFG0,
    },{ .name = "CH1_CHCLK_TXCAL_CFG",  .addr = A_CH1_CHCLK_TXCAL_CFG,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH1_CHCLK_RXCAL_CFG2",  .addr = A_CH1_CHCLK_RXCAL_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_CHCLK_RSV_CFG",  .addr = A_CH1_CHCLK_RSV_CFG,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_PIPE_TX_EQ_CFG0",  .addr = A_CH1_PIPE_TX_EQ_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_PIPE_TX_EQ_CFG1",  .addr = A_CH1_PIPE_TX_EQ_CFG1,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "CH1_PIPE_TX_EQ_CFG2",  .addr = A_CH1_PIPE_TX_EQ_CFG2,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
    },{ .name = "CH1_PIPE_TX_EQ_CFG3",  .addr = A_CH1_PIPE_TX_EQ_CFG3,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "CH1_TX_PCS_CFG0",  .addr = A_CH1_TX_PCS_CFG0,
    },{ .name = "CH1_TX_PCS_CFG1",  .addr = A_CH1_TX_PCS_CFG1,
    },{ .name = "CH1_TX_PCS_CFG2",  .addr = A_CH1_TX_PCS_CFG2,
        .rsvd = 0x40000000,
        .ro = 0x40000000,
    },{ .name = "CH1_TX_PCS_CFG3",  .addr = A_CH1_TX_PCS_CFG3,
    },{ .name = "CH1_EYESCAN_CFG0",  .addr = A_CH1_EYESCAN_CFG0,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH1_EYESCAN_CFG1",  .addr = A_CH1_EYESCAN_CFG1,
    },{ .name = "CH1_EYESCAN_CFG2",  .addr = A_CH1_EYESCAN_CFG2,
    },{ .name = "CH1_EYESCAN_CFG3",  .addr = A_CH1_EYESCAN_CFG3,
    },{ .name = "CH1_EYESCAN_CFG4",  .addr = A_CH1_EYESCAN_CFG4,
    },{ .name = "CH1_EYESCAN_CFG5",  .addr = A_CH1_EYESCAN_CFG5,
    },{ .name = "CH1_EYESCAN_CFG6",  .addr = A_CH1_EYESCAN_CFG6,
    },{ .name = "CH1_EYESCAN_CFG7",  .addr = A_CH1_EYESCAN_CFG7,
    },{ .name = "CH1_EYESCAN_CFG8",  .addr = A_CH1_EYESCAN_CFG8,
    },{ .name = "CH1_EYESCAN_CFG9",  .addr = A_CH1_EYESCAN_CFG9,
    },{ .name = "CH1_EYESCAN_CFG10",  .addr = A_CH1_EYESCAN_CFG10,
    },{ .name = "CH1_EYESCAN_CFG11",  .addr = A_CH1_EYESCAN_CFG11,
    },{ .name = "CH1_EYESCAN_CFG12",  .addr = A_CH1_EYESCAN_CFG12,
    },{ .name = "CH1_EYESCAN_CFG13",  .addr = A_CH1_EYESCAN_CFG13,
    },{ .name = "CH1_EYESCAN_CFG14",  .addr = A_CH1_EYESCAN_CFG14,
    },{ .name = "CH1_EYESCAN_CFG15",  .addr = A_CH1_EYESCAN_CFG15,
    },{ .name = "CH1_EYESCAN_CFG16",  .addr = A_CH1_EYESCAN_CFG16,
        .rsvd = 0x70000,
        .ro = 0x70000,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG0",  .addr = A_CH1_RX_ELASTIC_BUF_CFG0,
    },{ .name = "CH1_TX_10G_CFG0",  .addr = A_CH1_TX_10G_CFG0,
    },{ .name = "CH1_TX_10G_CFG1",  .addr = A_CH1_TX_10G_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_TX_10G_CFG2",  .addr = A_CH1_TX_10G_CFG2,
    },{ .name = "CH1_TX_10G_CFG3",  .addr = A_CH1_TX_10G_CFG3,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH1_RX_PHALIGN_CFG0",  .addr = A_CH1_RX_PHALIGN_CFG0,
    },{ .name = "CH1_RX_PHALIGN_CFG1",  .addr = A_CH1_RX_PHALIGN_CFG1,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH1_RX_PHALIGN_CFG2",  .addr = A_CH1_RX_PHALIGN_CFG2,
        .rsvd = 0x1f,
        .ro = 0x1f,
    },{ .name = "CH1_RX_PHALIGN_CFG3",  .addr = A_CH1_RX_PHALIGN_CFG3,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH1_RX_PHALIGN_CFG4",  .addr = A_CH1_RX_PHALIGN_CFG4,
    },{ .name = "CH1_RX_PHALIGN_CFG5",  .addr = A_CH1_RX_PHALIGN_CFG5,
        .rsvd = 0x7,
        .ro = 0x7,
    },{ .name = "CH1_TX_PHALIGN_CFG0",  .addr = A_CH1_TX_PHALIGN_CFG0,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH1_TX_PHALIGN_CFG1",  .addr = A_CH1_TX_PHALIGN_CFG1,
    },{ .name = "CH1_TX_PHALIGN_CFG2",  .addr = A_CH1_TX_PHALIGN_CFG2,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH1_TX_PHALIGN_CFG3",  .addr = A_CH1_TX_PHALIGN_CFG3,
    },{ .name = "CH1_TX_PHALIGN_CFG4",  .addr = A_CH1_TX_PHALIGN_CFG4,
        .rsvd = 0xc00,
        .ro = 0xc00,
    },{ .name = "CH1_TX_PHALIGN_CFG5",  .addr = A_CH1_TX_PHALIGN_CFG5,
    },{ .name = "CH1_PIPE_CTRL_CFG0",  .addr = A_CH1_PIPE_CTRL_CFG0,
    },{ .name = "CH1_PIPE_CTRL_CFG1",  .addr = A_CH1_PIPE_CTRL_CFG1,
    },{ .name = "CH1_PIPE_CTRL_CFG2",  .addr = A_CH1_PIPE_CTRL_CFG2,
    },{ .name = "CH1_PIPE_CTRL_CFG3",  .addr = A_CH1_PIPE_CTRL_CFG3,
    },{ .name = "CH1_PIPE_CTRL_CFG4",  .addr = A_CH1_PIPE_CTRL_CFG4,
    },{ .name = "CH1_PIPE_CTRL_CFG5",  .addr = A_CH1_PIPE_CTRL_CFG5,
    },{ .name = "CH1_PIPE_CTRL_CFG6",  .addr = A_CH1_PIPE_CTRL_CFG6,
    },{ .name = "CH1_PIPE_CTRL_CFG7",  .addr = A_CH1_PIPE_CTRL_CFG7,
    },{ .name = "CH1_PIPE_CTRL_CFG8",  .addr = A_CH1_PIPE_CTRL_CFG8,
    },{ .name = "CH1_PIPE_CTRL_CFG9",  .addr = A_CH1_PIPE_CTRL_CFG9,
    },{ .name = "CH1_TX_PIPPM_CFG",  .addr = A_CH1_TX_PIPPM_CFG,
        .rsvd = 0xc0007000,
        .ro = 0xc0007000,
    },{ .name = "CH1_CHL_RSV_CFG2",  .addr = A_CH1_CHL_RSV_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_FABRIC_INTF_CFG0",  .addr = A_CH1_FABRIC_INTF_CFG0,
    },{ .name = "CH1_FABRIC_INTF_CFG1",  .addr = A_CH1_FABRIC_INTF_CFG1,
        .rsvd = 0x7000,
        .ro = 0x7000,
    },{ .name = "CH1_FABRIC_INTF_CFG2",  .addr = A_CH1_FABRIC_INTF_CFG2,
    },{ .name = "CH1_FABRIC_INTF_CFG3",  .addr = A_CH1_FABRIC_INTF_CFG3,
    },{ .name = "CH1_FABRIC_INTF_CFG4",  .addr = A_CH1_FABRIC_INTF_CFG4,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "CH1_FABRIC_INTF_CFG5",  .addr = A_CH1_FABRIC_INTF_CFG5,
        .rsvd = 0x8,
        .ro = 0x8,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG1",  .addr = A_CH1_RX_ELASTIC_BUF_CFG1,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG2",  .addr = A_CH1_RX_ELASTIC_BUF_CFG2,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG3",  .addr = A_CH1_RX_ELASTIC_BUF_CFG3,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG4",  .addr = A_CH1_RX_ELASTIC_BUF_CFG4,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG5",  .addr = A_CH1_RX_ELASTIC_BUF_CFG5,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG6",  .addr = A_CH1_RX_ELASTIC_BUF_CFG6,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG7",  .addr = A_CH1_RX_ELASTIC_BUF_CFG7,
        .rsvd = 0xb800000,
        .ro = 0xb800000,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG8",  .addr = A_CH1_RX_ELASTIC_BUF_CFG8,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH1_RX_ELASTIC_BUF_CFG9",  .addr = A_CH1_RX_ELASTIC_BUF_CFG9,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH1_RX_OOB_CFG0",  .addr = A_CH1_RX_OOB_CFG0,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH1_RX_OOB_CFG1",  .addr = A_CH1_RX_OOB_CFG1,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "CH1_MONITOR_CFG",  .addr = A_CH1_MONITOR_CFG,
        .rsvd = 0xf00,
        .ro = 0xf00,
    },{ .name = "CH1_PIPE_CTRL_CFG10",  .addr = A_CH1_PIPE_CTRL_CFG10,
        .rsvd = 0x78000010,
        .ro = 0x78000010,
    },{ .name = "CH1_CHL_RSV_CFG3",  .addr = A_CH1_CHL_RSV_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH1_CHL_RSV_CFG4",  .addr = A_CH1_CHL_RSV_CFG4,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "MEMCELLX36F8",  .addr = A_MEMCELLX36F8,
        .rsvd = 0x3fffffff,
        .ro = 0x3fffffff,
    },{ .name = "MEMCELLX36FC",  .addr = A_MEMCELLX36FC,
        .rsvd = 0xfc000080,
        .ro = 0xfc000080,
    },{ .name = "HSCLK1_LCPLL_LGC_CFG0",  .addr = A_HSCLK1_LCPLL_LGC_CFG0,
        .rsvd = 0x4000,
        .ro = 0x4000,
    },{ .name = "HSCLK1_LCPLL_LGC_CFG1",  .addr = A_HSCLK1_LCPLL_LGC_CFG1,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "HSCLK1_LCPLL_LGC_CFG2",  .addr = A_HSCLK1_LCPLL_LGC_CFG2,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "HSCLK1_LCPLL_CFG0",  .addr = A_HSCLK1_LCPLL_CFG0,
        .rsvd = 0xe000000,
        .ro = 0xe000000,
    },{ .name = "PIN_CFG0",  .addr = A_PIN_CFG0,
        .rsvd = 0xf0842104,
        .ro = 0xf0842104,
    },{ .name = "A_CFG0",  .addr = A_A_CFG0,
        .rsvd = 0xffe00800,
        .ro = 0xffe00800,
    },{ .name = "A_CFG1",  .addr = A_A_CFG1,
    },{ .name = "A_CFG2",  .addr = A_A_CFG2,
    },{ .name = "HSCLK1_LCPLL_CFG1",  .addr = A_HSCLK1_LCPLL_CFG1,
        .rsvd = 0x7e00000,
        .ro = 0x7e00000,
    },{ .name = "HSCLK1_LCPLL_CFG2",  .addr = A_HSCLK1_LCPLL_CFG2,
        .rsvd = 0x7f0,
        .ro = 0x7f0,
    },{ .name = "CH2_RESET_TIME_CFG0",  .addr = A_CH2_RESET_TIME_CFG0,
        .rsvd = 0xc00003e0,
        .ro = 0xc00003e0,
    },{ .name = "CH2_RESET_TIME_CFG1",  .addr = A_CH2_RESET_TIME_CFG1,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH2_RESET_TIME_CFG2",  .addr = A_CH2_RESET_TIME_CFG2,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH2_RESET_TIME_CFG3",  .addr = A_CH2_RESET_TIME_CFG3,
    },{ .name = "CH2_RESET_LOOPER_ID_CFG",  .addr = A_CH2_RESET_LOOPER_ID_CFG,
    },{ .name = "CH2_RESET_LOOP_ID_CFG0",  .addr = A_CH2_RESET_LOOP_ID_CFG0,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH2_RESET_LOOP_ID_CFG1",  .addr = A_CH2_RESET_LOOP_ID_CFG1,
    },{ .name = "CH2_RESET_LOOP_ID_CFG2",  .addr = A_CH2_RESET_LOOP_ID_CFG2,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH2_RESET_BYP_HDSHK_CFG",  .addr = A_CH2_RESET_BYP_HDSHK_CFG,
        .rsvd = 0xfffffc00,
        .ro = 0xfffffc00,
    },{ .name = "CH2_RESET_CFG",  .addr = A_CH2_RESET_CFG,
        .rsvd = 0x60300,
        .ro = 0x60300,
    },{ .name = "MEMCELLX38A0",  .addr = A_MEMCELLX38A0,
        .rsvd = 0x7fffff00,
        .ro = 0x7fffff00,
    },{ .name = "CH2_TX_ANA_CFG0",  .addr = A_CH2_TX_ANA_CFG0,
        .rsvd = 0xfffffe07,
        .ro = 0xfffffe07,
    },{ .name = "CH2_TX_DRV_CFG0",  .addr = A_CH2_TX_DRV_CFG0,
        .rsvd = 0x3ffe0,
        .ro = 0x3ffe0,
    },{ .name = "CH2_TX_DRV_CFG1",  .addr = A_CH2_TX_DRV_CFG1,
        .rsvd = 0x3800e000,
        .ro = 0x3800e000,
    },{ .name = "CH2_CHL_RSV_CFG0",  .addr = A_CH2_CHL_RSV_CFG0,
        .rsvd = 0xff80000,
        .ro = 0xff80000,
    },{ .name = "CH2_TX_SER_CFG0",  .addr = A_CH2_TX_SER_CFG0,
        .rsvd = 0xfffff007,
        .ro = 0xfffff007,
    },{ .name = "CH2_RX_CDR_CFG0",  .addr = A_CH2_RX_CDR_CFG0,
        .rsvd = 0x3c00800,
        .ro = 0x3c00800,
    },{ .name = "CH2_RX_CDR_CFG1",  .addr = A_CH2_RX_CDR_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_RX_CDR_CFG2",  .addr = A_CH2_RX_CDR_CFG2,
        .rsvd = 0xff0000,
        .ro = 0xff0000,
    },{ .name = "CH2_RX_CDR_CFG3",  .addr = A_CH2_RX_CDR_CFG3,
    },{ .name = "CH2_RX_CDR_CFG4",  .addr = A_CH2_RX_CDR_CFG4,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_ADAPT_APT_CFG",  .addr = A_CH2_ADAPT_APT_CFG,
    },{ .name = "CH2_ADAPT_CAL_CFG",  .addr = A_CH2_ADAPT_CAL_CFG,
    },{ .name = "CH2_ADAPT_DFE_CFG",  .addr = A_CH2_ADAPT_DFE_CFG,
    },{ .name = "CH2_ADAPT_GC_CFG0",  .addr = A_CH2_ADAPT_GC_CFG0,
    },{ .name = "CH2_ADAPT_GC_CFG1",  .addr = A_CH2_ADAPT_GC_CFG1,
    },{ .name = "CH2_ADAPT_GC_CFG2",  .addr = A_CH2_ADAPT_GC_CFG2,
    },{ .name = "CH2_ADAPT_GC_CFG3",  .addr = A_CH2_ADAPT_GC_CFG3,
    },{ .name = "CH2_ADAPT_GEN_CFG0",  .addr = A_CH2_ADAPT_GEN_CFG0,
    },{ .name = "CH2_ADAPT_GEN_CFG1",  .addr = A_CH2_ADAPT_GEN_CFG1,
    },{ .name = "CH2_ADAPT_GEN_CFG2",  .addr = A_CH2_ADAPT_GEN_CFG2,
    },{ .name = "CH2_ADAPT_GEN_CFG3",  .addr = A_CH2_ADAPT_GEN_CFG3,
    },{ .name = "CH2_ADAPT_H01_CFG",  .addr = A_CH2_ADAPT_H01_CFG,
    },{ .name = "CH2_ADAPT_H23_CFG",  .addr = A_CH2_ADAPT_H23_CFG,
    },{ .name = "CH2_ADAPT_H45_CFG",  .addr = A_CH2_ADAPT_H45_CFG,
    },{ .name = "CH2_ADAPT_H67_CFG",  .addr = A_CH2_ADAPT_H67_CFG,
    },{ .name = "CH2_ADAPT_H89_CFG",  .addr = A_CH2_ADAPT_H89_CFG,
    },{ .name = "CH2_ADAPT_HAB_CFG",  .addr = A_CH2_ADAPT_HAB_CFG,
    },{ .name = "CH2_ADAPT_HCD_CFG",  .addr = A_CH2_ADAPT_HCD_CFG,
    },{ .name = "CH2_ADAPT_HEF_CFG",  .addr = A_CH2_ADAPT_HEF_CFG,
        .rsvd = 0x1f0000,
        .ro = 0x1f0000,
    },{ .name = "CH2_ADAPT_KH_CFG0",  .addr = A_CH2_ADAPT_KH_CFG0,
    },{ .name = "CH2_ADAPT_KH_CFG1",  .addr = A_CH2_ADAPT_KH_CFG1,
    },{ .name = "CH2_ADAPT_KH_CFG2",  .addr = A_CH2_ADAPT_KH_CFG2,
    },{ .name = "CH2_ADAPT_KH_CFG3",  .addr = A_CH2_ADAPT_KH_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_ADAPT_KH_CFG4",  .addr = A_CH2_ADAPT_KH_CFG4,
    },{ .name = "CH2_ADAPT_KH_CFG5",  .addr = A_CH2_ADAPT_KH_CFG5,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_ADAPT_KL_CFG0",  .addr = A_CH2_ADAPT_KL_CFG0,
    },{ .name = "CH2_ADAPT_KL_CFG1",  .addr = A_CH2_ADAPT_KL_CFG1,
    },{ .name = "CH2_ADAPT_LCK_CFG0",  .addr = A_CH2_ADAPT_LCK_CFG0,
    },{ .name = "CH2_ADAPT_LCK_CFG1",  .addr = A_CH2_ADAPT_LCK_CFG1,
    },{ .name = "CH2_ADAPT_LCK_CFG2",  .addr = A_CH2_ADAPT_LCK_CFG2,
    },{ .name = "CH2_ADAPT_LCK_CFG3",  .addr = A_CH2_ADAPT_LCK_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_ADAPT_LOP_CFG",  .addr = A_CH2_ADAPT_LOP_CFG,
    },{ .name = "CH2_ADAPT_OS_CFG",  .addr = A_CH2_ADAPT_OS_CFG,
    },{ .name = "CH2_RX_CRC_CFG0",  .addr = A_CH2_RX_CRC_CFG0,
    },{ .name = "CH2_RX_CRC_CFG1",  .addr = A_CH2_RX_CRC_CFG1,
    },{ .name = "CH2_RX_CRC_CFG2",  .addr = A_CH2_RX_CRC_CFG2,
    },{ .name = "CH2_RX_CRC_CFG3",  .addr = A_CH2_RX_CRC_CFG3,
    },{ .name = "CH2_TX_CRC_CFG0",  .addr = A_CH2_TX_CRC_CFG0,
        .rsvd = 0x80,
        .ro = 0x80,
    },{ .name = "CH2_TX_CRC_CFG1",  .addr = A_CH2_TX_CRC_CFG1,
    },{ .name = "CH2_TX_CRC_CFG2",  .addr = A_CH2_TX_CRC_CFG2,
    },{ .name = "CH2_TX_CRC_CFG3",  .addr = A_CH2_TX_CRC_CFG3,
    },{ .name = "CH2_DA_CFG",  .addr = A_CH2_DA_CFG,
    },{ .name = "CH2_RX_CTLE_CFG0",  .addr = A_CH2_RX_CTLE_CFG0,
    },{ .name = "CH2_RX_CTLE_CFG1",  .addr = A_CH2_RX_CTLE_CFG1,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH2_RX_DACI2V_CFG0",  .addr = A_CH2_RX_DACI2V_CFG0,
        .rsvd = 0xe0000000,
        .ro = 0xe0000000,
    },{ .name = "CH2_RX_DFE_CFG0",  .addr = A_CH2_RX_DFE_CFG0,
    },{ .name = "CH2_RX_MISC_CFG0",  .addr = A_CH2_RX_MISC_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_CHL_RSV_CFG1",  .addr = A_CH2_CHL_RSV_CFG1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_RX_PAD_CFG0",  .addr = A_CH2_RX_PAD_CFG0,
    },{ .name = "CH2_RX_PAD_CFG1",  .addr = A_CH2_RX_PAD_CFG1,
    },{ .name = "CH2_RX_PCS_CFG0",  .addr = A_CH2_RX_PCS_CFG0,
        .rsvd = 0x200,
        .ro = 0x200,
    },{ .name = "CH2_RX_PCS_CFG1",  .addr = A_CH2_RX_PCS_CFG1,
    },{ .name = "CH2_RX_PCS_CFG2",  .addr = A_CH2_RX_PCS_CFG2,
    },{ .name = "CH2_RX_PCS_CFG3",  .addr = A_CH2_RX_PCS_CFG3,
        .rsvd = 0x640000,
        .ro = 0x640000,
    },{ .name = "CH2_RX_PCS_CFG4",  .addr = A_CH2_RX_PCS_CFG4,
    },{ .name = "CH2_CHCLK_MISC_CFG",  .addr = A_CH2_CHCLK_MISC_CFG,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_CHCLK_ILO_CFG",  .addr = A_CH2_CHCLK_ILO_CFG,
        .rsvd = 0xe0028f88,
        .ro = 0xe0028f88,
    },{ .name = "CH2_CHCLK_RXPI_CFG",  .addr = A_CH2_CHCLK_RXPI_CFG,
        .rsvd = 0xff800003,
        .ro = 0xff800003,
    },{ .name = "CH2_CHCLK_RXCAL_CFG",  .addr = A_CH2_CHCLK_RXCAL_CFG,
        .rsvd = 0x1,
        .ro = 0x1,
    },{ .name = "CH2_CHCLK_RXCAL_CFG1",  .addr = A_CH2_CHCLK_RXCAL_CFG1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "CH2_CHCLK_TXPI_CFG0",  .addr = A_CH2_CHCLK_TXPI_CFG0,
    },{ .name = "CH2_CHCLK_TXCAL_CFG",  .addr = A_CH2_CHCLK_TXCAL_CFG,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH2_CHCLK_RXCAL_CFG2",  .addr = A_CH2_CHCLK_RXCAL_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_CHCLK_RSV_CFG",  .addr = A_CH2_CHCLK_RSV_CFG,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_PIPE_TX_EQ_CFG0",  .addr = A_CH2_PIPE_TX_EQ_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_PIPE_TX_EQ_CFG1",  .addr = A_CH2_PIPE_TX_EQ_CFG1,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "CH2_PIPE_TX_EQ_CFG2",  .addr = A_CH2_PIPE_TX_EQ_CFG2,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
    },{ .name = "CH2_PIPE_TX_EQ_CFG3",  .addr = A_CH2_PIPE_TX_EQ_CFG3,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "CH2_TX_PCS_CFG0",  .addr = A_CH2_TX_PCS_CFG0,
    },{ .name = "CH2_TX_PCS_CFG1",  .addr = A_CH2_TX_PCS_CFG1,
    },{ .name = "CH2_TX_PCS_CFG2",  .addr = A_CH2_TX_PCS_CFG2,
        .rsvd = 0x40000000,
        .ro = 0x40000000,
    },{ .name = "CH2_TX_PCS_CFG3",  .addr = A_CH2_TX_PCS_CFG3,
    },{ .name = "CH2_EYESCAN_CFG0",  .addr = A_CH2_EYESCAN_CFG0,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH2_EYESCAN_CFG1",  .addr = A_CH2_EYESCAN_CFG1,
    },{ .name = "CH2_EYESCAN_CFG2",  .addr = A_CH2_EYESCAN_CFG2,
    },{ .name = "CH2_EYESCAN_CFG3",  .addr = A_CH2_EYESCAN_CFG3,
    },{ .name = "CH2_EYESCAN_CFG4",  .addr = A_CH2_EYESCAN_CFG4,
    },{ .name = "CH2_EYESCAN_CFG5",  .addr = A_CH2_EYESCAN_CFG5,
    },{ .name = "CH2_EYESCAN_CFG6",  .addr = A_CH2_EYESCAN_CFG6,
    },{ .name = "CH2_EYESCAN_CFG7",  .addr = A_CH2_EYESCAN_CFG7,
    },{ .name = "CH2_EYESCAN_CFG8",  .addr = A_CH2_EYESCAN_CFG8,
    },{ .name = "CH2_EYESCAN_CFG9",  .addr = A_CH2_EYESCAN_CFG9,
    },{ .name = "CH2_EYESCAN_CFG10",  .addr = A_CH2_EYESCAN_CFG10,
    },{ .name = "CH2_EYESCAN_CFG11",  .addr = A_CH2_EYESCAN_CFG11,
    },{ .name = "CH2_EYESCAN_CFG12",  .addr = A_CH2_EYESCAN_CFG12,
    },{ .name = "CH2_EYESCAN_CFG13",  .addr = A_CH2_EYESCAN_CFG13,
    },{ .name = "CH2_EYESCAN_CFG14",  .addr = A_CH2_EYESCAN_CFG14,
    },{ .name = "CH2_EYESCAN_CFG15",  .addr = A_CH2_EYESCAN_CFG15,
    },{ .name = "CH2_EYESCAN_CFG16",  .addr = A_CH2_EYESCAN_CFG16,
        .rsvd = 0x70000,
        .ro = 0x70000,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG0",  .addr = A_CH2_RX_ELASTIC_BUF_CFG0,
    },{ .name = "CH2_TX_10G_CFG0",  .addr = A_CH2_TX_10G_CFG0,
    },{ .name = "CH2_TX_10G_CFG1",  .addr = A_CH2_TX_10G_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_TX_10G_CFG2",  .addr = A_CH2_TX_10G_CFG2,
    },{ .name = "CH2_TX_10G_CFG3",  .addr = A_CH2_TX_10G_CFG3,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH2_RX_PHALIGN_CFG0",  .addr = A_CH2_RX_PHALIGN_CFG0,
    },{ .name = "CH2_RX_PHALIGN_CFG1",  .addr = A_CH2_RX_PHALIGN_CFG1,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH2_RX_PHALIGN_CFG2",  .addr = A_CH2_RX_PHALIGN_CFG2,
        .rsvd = 0x1f,
        .ro = 0x1f,
    },{ .name = "CH2_RX_PHALIGN_CFG3",  .addr = A_CH2_RX_PHALIGN_CFG3,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH2_RX_PHALIGN_CFG4",  .addr = A_CH2_RX_PHALIGN_CFG4,
    },{ .name = "CH2_RX_PHALIGN_CFG5",  .addr = A_CH2_RX_PHALIGN_CFG5,
        .rsvd = 0x7,
        .ro = 0x7,
    },{ .name = "CH2_TX_PHALIGN_CFG0",  .addr = A_CH2_TX_PHALIGN_CFG0,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH2_TX_PHALIGN_CFG1",  .addr = A_CH2_TX_PHALIGN_CFG1,
    },{ .name = "CH2_TX_PHALIGN_CFG2",  .addr = A_CH2_TX_PHALIGN_CFG2,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH2_TX_PHALIGN_CFG3",  .addr = A_CH2_TX_PHALIGN_CFG3,
    },{ .name = "CH2_TX_PHALIGN_CFG4",  .addr = A_CH2_TX_PHALIGN_CFG4,
        .rsvd = 0xc00,
        .ro = 0xc00,
    },{ .name = "CH2_TX_PHALIGN_CFG5",  .addr = A_CH2_TX_PHALIGN_CFG5,
    },{ .name = "CH2_PIPE_CTRL_CFG0",  .addr = A_CH2_PIPE_CTRL_CFG0,
    },{ .name = "CH2_PIPE_CTRL_CFG1",  .addr = A_CH2_PIPE_CTRL_CFG1,
    },{ .name = "CH2_PIPE_CTRL_CFG2",  .addr = A_CH2_PIPE_CTRL_CFG2,
    },{ .name = "CH2_PIPE_CTRL_CFG3",  .addr = A_CH2_PIPE_CTRL_CFG3,
    },{ .name = "CH2_PIPE_CTRL_CFG4",  .addr = A_CH2_PIPE_CTRL_CFG4,
    },{ .name = "CH2_PIPE_CTRL_CFG5",  .addr = A_CH2_PIPE_CTRL_CFG5,
    },{ .name = "CH2_PIPE_CTRL_CFG6",  .addr = A_CH2_PIPE_CTRL_CFG6,
    },{ .name = "CH2_PIPE_CTRL_CFG7",  .addr = A_CH2_PIPE_CTRL_CFG7,
    },{ .name = "CH2_PIPE_CTRL_CFG8",  .addr = A_CH2_PIPE_CTRL_CFG8,
    },{ .name = "CH2_PIPE_CTRL_CFG9",  .addr = A_CH2_PIPE_CTRL_CFG9,
    },{ .name = "CH2_TX_PIPPM_CFG",  .addr = A_CH2_TX_PIPPM_CFG,
        .rsvd = 0xc0007000,
        .ro = 0xc0007000,
    },{ .name = "CH2_CHL_RSV_CFG2",  .addr = A_CH2_CHL_RSV_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_FABRIC_INTF_CFG0",  .addr = A_CH2_FABRIC_INTF_CFG0,
    },{ .name = "CH2_FABRIC_INTF_CFG1",  .addr = A_CH2_FABRIC_INTF_CFG1,
        .rsvd = 0x7000,
        .ro = 0x7000,
    },{ .name = "CH2_FABRIC_INTF_CFG2",  .addr = A_CH2_FABRIC_INTF_CFG2,
    },{ .name = "CH2_FABRIC_INTF_CFG3",  .addr = A_CH2_FABRIC_INTF_CFG3,
    },{ .name = "CH2_FABRIC_INTF_CFG4",  .addr = A_CH2_FABRIC_INTF_CFG4,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "CH2_FABRIC_INTF_CFG5",  .addr = A_CH2_FABRIC_INTF_CFG5,
        .rsvd = 0x8,
        .ro = 0x8,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG1",  .addr = A_CH2_RX_ELASTIC_BUF_CFG1,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG2",  .addr = A_CH2_RX_ELASTIC_BUF_CFG2,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG3",  .addr = A_CH2_RX_ELASTIC_BUF_CFG3,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG4",  .addr = A_CH2_RX_ELASTIC_BUF_CFG4,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG5",  .addr = A_CH2_RX_ELASTIC_BUF_CFG5,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG6",  .addr = A_CH2_RX_ELASTIC_BUF_CFG6,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG7",  .addr = A_CH2_RX_ELASTIC_BUF_CFG7,
        .rsvd = 0xb800000,
        .ro = 0xb800000,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG8",  .addr = A_CH2_RX_ELASTIC_BUF_CFG8,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH2_RX_ELASTIC_BUF_CFG9",  .addr = A_CH2_RX_ELASTIC_BUF_CFG9,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH2_RX_OOB_CFG0",  .addr = A_CH2_RX_OOB_CFG0,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH2_RX_OOB_CFG1",  .addr = A_CH2_RX_OOB_CFG1,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "CH2_MONITOR_CFG",  .addr = A_CH2_MONITOR_CFG,
        .rsvd = 0xf00,
        .ro = 0xf00,
    },{ .name = "CH2_PIPE_CTRL_CFG10",  .addr = A_CH2_PIPE_CTRL_CFG10,
        .rsvd = 0x78000010,
        .ro = 0x78000010,
    },{ .name = "CH2_CHL_RSV_CFG3",  .addr = A_CH2_CHL_RSV_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH2_CHL_RSV_CFG4",  .addr = A_CH2_CHL_RSV_CFG4,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "MEMCELLX3AF8",  .addr = A_MEMCELLX3AF8,
        .rsvd = 0x3fffffff,
        .ro = 0x3fffffff,
    },{ .name = "HSCLK1_HSDIST_CFG",  .addr = A_HSCLK1_HSDIST_CFG,
        .rsvd = 0xfffeff60,
        .ro = 0xfffeff60,
    },{ .name = "RCALBG_RCALBG_BOT_CFG0",  .addr = A_RCALBG_RCALBG_BOT_CFG0,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_BOT_CFG1",  .addr = A_RCALBG_RCALBG_BOT_CFG1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CTRL_RSV_CFG1",  .addr = A_CTRL_RSV_CFG1,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "A_CFG3",  .addr = A_A_CFG3,
    },{ .name = "RCALBG_RCALBG_BOT_CFG2",  .addr = A_RCALBG_RCALBG_BOT_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_BOT_CFG3",  .addr = A_RCALBG_RCALBG_BOT_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_BOT_CFG4",  .addr = A_RCALBG_RCALBG_BOT_CFG4,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RCALBG_RCALBG_BOT_CFG5",  .addr = A_RCALBG_RCALBG_BOT_CFG5,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "HSCLK1_RPLL_LGC_CFG0",  .addr = A_HSCLK1_RPLL_LGC_CFG0,
        .rsvd = 0x4000,
        .ro = 0x4000,
    },{ .name = "HSCLK1_RPLL_LGC_CFG1",  .addr = A_HSCLK1_RPLL_LGC_CFG1,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "HSCLK1_RPLL_LGC_CFG2",  .addr = A_HSCLK1_RPLL_LGC_CFG2,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "HSCLK1_RPLL_CFG0",  .addr = A_HSCLK1_RPLL_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "A_CFG4",  .addr = A_A_CFG4,
    },{ .name = "A_CFG5",  .addr = A_A_CFG5,
    },{ .name = "MEMCELLX3C48",  .addr = A_MEMCELLX3C48,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "MEMCELLX3C4C",  .addr = A_MEMCELLX3C4C,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "HSCLK1_RPLL_CFG1",  .addr = A_HSCLK1_RPLL_CFG1,
        .rsvd = 0x10,
        .ro = 0x10,
    },{ .name = "HSCLK1_RPLL_CFG2",  .addr = A_HSCLK1_RPLL_CFG2,
        .rsvd = 0x7ffc00,
        .ro = 0x7ffc00,
    },{ .name = "CH3_RESET_TIME_CFG0",  .addr = A_CH3_RESET_TIME_CFG0,
        .rsvd = 0xc00003e0,
        .ro = 0xc00003e0,
    },{ .name = "CH3_RESET_TIME_CFG1",  .addr = A_CH3_RESET_TIME_CFG1,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH3_RESET_TIME_CFG2",  .addr = A_CH3_RESET_TIME_CFG2,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH3_RESET_TIME_CFG3",  .addr = A_CH3_RESET_TIME_CFG3,
    },{ .name = "CH3_RESET_LOOPER_ID_CFG",  .addr = A_CH3_RESET_LOOPER_ID_CFG,
    },{ .name = "CH3_RESET_LOOP_ID_CFG0",  .addr = A_CH3_RESET_LOOP_ID_CFG0,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH3_RESET_LOOP_ID_CFG1",  .addr = A_CH3_RESET_LOOP_ID_CFG1,
    },{ .name = "CH3_RESET_LOOP_ID_CFG2",  .addr = A_CH3_RESET_LOOP_ID_CFG2,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CH3_RESET_BYP_HDSHK_CFG",  .addr = A_CH3_RESET_BYP_HDSHK_CFG,
        .rsvd = 0xfffffc00,
        .ro = 0xfffffc00,
    },{ .name = "CH3_RESET_CFG",  .addr = A_CH3_RESET_CFG,
        .rsvd = 0x60300,
        .ro = 0x60300,
    },{ .name = "MEMCELLX3CA0",  .addr = A_MEMCELLX3CA0,
        .rsvd = 0x7fffff00,
        .ro = 0x7fffff00,
    },{ .name = "CH3_TX_ANA_CFG0",  .addr = A_CH3_TX_ANA_CFG0,
        .rsvd = 0xfffffe07,
        .ro = 0xfffffe07,
    },{ .name = "CH3_TX_DRV_CFG0",  .addr = A_CH3_TX_DRV_CFG0,
        .rsvd = 0x3ffe0,
        .ro = 0x3ffe0,
    },{ .name = "CH3_TX_DRV_CFG1",  .addr = A_CH3_TX_DRV_CFG1,
        .rsvd = 0x3800e000,
        .ro = 0x3800e000,
    },{ .name = "CH3_CHL_RSV_CFG0",  .addr = A_CH3_CHL_RSV_CFG0,
        .rsvd = 0xff80000,
        .ro = 0xff80000,
    },{ .name = "CH3_TX_SER_CFG0",  .addr = A_CH3_TX_SER_CFG0,
        .rsvd = 0xfffff007,
        .ro = 0xfffff007,
    },{ .name = "CH3_RX_CDR_CFG0",  .addr = A_CH3_RX_CDR_CFG0,
        .rsvd = 0x3c00800,
        .ro = 0x3c00800,
    },{ .name = "CH3_RX_CDR_CFG1",  .addr = A_CH3_RX_CDR_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_RX_CDR_CFG2",  .addr = A_CH3_RX_CDR_CFG2,
        .rsvd = 0xff0000,
        .ro = 0xff0000,
    },{ .name = "CH3_RX_CDR_CFG3",  .addr = A_CH3_RX_CDR_CFG3,
    },{ .name = "CH3_RX_CDR_CFG4",  .addr = A_CH3_RX_CDR_CFG4,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_ADAPT_APT_CFG",  .addr = A_CH3_ADAPT_APT_CFG,
    },{ .name = "CH3_ADAPT_CAL_CFG",  .addr = A_CH3_ADAPT_CAL_CFG,
    },{ .name = "CH3_ADAPT_DFE_CFG",  .addr = A_CH3_ADAPT_DFE_CFG,
    },{ .name = "CH3_ADAPT_GC_CFG0",  .addr = A_CH3_ADAPT_GC_CFG0,
    },{ .name = "CH3_ADAPT_GC_CFG1",  .addr = A_CH3_ADAPT_GC_CFG1,
    },{ .name = "CH3_ADAPT_GC_CFG2",  .addr = A_CH3_ADAPT_GC_CFG2,
    },{ .name = "CH3_ADAPT_GC_CFG3",  .addr = A_CH3_ADAPT_GC_CFG3,
    },{ .name = "CH3_ADAPT_GEN_CFG0",  .addr = A_CH3_ADAPT_GEN_CFG0,
    },{ .name = "CH3_ADAPT_GEN_CFG1",  .addr = A_CH3_ADAPT_GEN_CFG1,
    },{ .name = "CH3_ADAPT_GEN_CFG2",  .addr = A_CH3_ADAPT_GEN_CFG2,
    },{ .name = "CH3_ADAPT_GEN_CFG3",  .addr = A_CH3_ADAPT_GEN_CFG3,
    },{ .name = "CH3_ADAPT_H01_CFG",  .addr = A_CH3_ADAPT_H01_CFG,
    },{ .name = "CH3_ADAPT_H23_CFG",  .addr = A_CH3_ADAPT_H23_CFG,
    },{ .name = "CH3_ADAPT_H45_CFG",  .addr = A_CH3_ADAPT_H45_CFG,
    },{ .name = "CH3_ADAPT_H67_CFG",  .addr = A_CH3_ADAPT_H67_CFG,
    },{ .name = "CH3_ADAPT_H89_CFG",  .addr = A_CH3_ADAPT_H89_CFG,
    },{ .name = "CH3_ADAPT_HAB_CFG",  .addr = A_CH3_ADAPT_HAB_CFG,
    },{ .name = "CH3_ADAPT_HCD_CFG",  .addr = A_CH3_ADAPT_HCD_CFG,
    },{ .name = "CH3_ADAPT_HEF_CFG",  .addr = A_CH3_ADAPT_HEF_CFG,
        .rsvd = 0x1f0000,
        .ro = 0x1f0000,
    },{ .name = "CH3_ADAPT_KH_CFG0",  .addr = A_CH3_ADAPT_KH_CFG0,
    },{ .name = "CH3_ADAPT_KH_CFG1",  .addr = A_CH3_ADAPT_KH_CFG1,
    },{ .name = "CH3_ADAPT_KH_CFG2",  .addr = A_CH3_ADAPT_KH_CFG2,
    },{ .name = "CH3_ADAPT_KH_CFG3",  .addr = A_CH3_ADAPT_KH_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_ADAPT_KH_CFG4",  .addr = A_CH3_ADAPT_KH_CFG4,
    },{ .name = "CH3_ADAPT_KH_CFG5",  .addr = A_CH3_ADAPT_KH_CFG5,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_ADAPT_KL_CFG0",  .addr = A_CH3_ADAPT_KL_CFG0,
    },{ .name = "CH3_ADAPT_KL_CFG1",  .addr = A_CH3_ADAPT_KL_CFG1,
    },{ .name = "CH3_ADAPT_LCK_CFG0",  .addr = A_CH3_ADAPT_LCK_CFG0,
    },{ .name = "CH3_ADAPT_LCK_CFG1",  .addr = A_CH3_ADAPT_LCK_CFG1,
    },{ .name = "CH3_ADAPT_LCK_CFG2",  .addr = A_CH3_ADAPT_LCK_CFG2,
    },{ .name = "CH3_ADAPT_LCK_CFG3",  .addr = A_CH3_ADAPT_LCK_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_ADAPT_LOP_CFG",  .addr = A_CH3_ADAPT_LOP_CFG,
    },{ .name = "CH3_ADAPT_OS_CFG",  .addr = A_CH3_ADAPT_OS_CFG,
    },{ .name = "CH3_RX_CRC_CFG0",  .addr = A_CH3_RX_CRC_CFG0,
    },{ .name = "CH3_RX_CRC_CFG1",  .addr = A_CH3_RX_CRC_CFG1,
    },{ .name = "CH3_RX_CRC_CFG2",  .addr = A_CH3_RX_CRC_CFG2,
    },{ .name = "CH3_RX_CRC_CFG3",  .addr = A_CH3_RX_CRC_CFG3,
    },{ .name = "CH3_TX_CRC_CFG0",  .addr = A_CH3_TX_CRC_CFG0,
        .rsvd = 0x80,
        .ro = 0x80,
    },{ .name = "CH3_TX_CRC_CFG1",  .addr = A_CH3_TX_CRC_CFG1,
    },{ .name = "CH3_TX_CRC_CFG2",  .addr = A_CH3_TX_CRC_CFG2,
    },{ .name = "CH3_TX_CRC_CFG3",  .addr = A_CH3_TX_CRC_CFG3,
    },{ .name = "CH3_DA_CFG",  .addr = A_CH3_DA_CFG,
    },{ .name = "CH3_RX_CTLE_CFG0",  .addr = A_CH3_RX_CTLE_CFG0,
    },{ .name = "CH3_RX_CTLE_CFG1",  .addr = A_CH3_RX_CTLE_CFG1,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH3_RX_DACI2V_CFG0",  .addr = A_CH3_RX_DACI2V_CFG0,
        .rsvd = 0xe0000000,
        .ro = 0xe0000000,
    },{ .name = "CH3_RX_DFE_CFG0",  .addr = A_CH3_RX_DFE_CFG0,
    },{ .name = "CH3_RX_MISC_CFG0",  .addr = A_CH3_RX_MISC_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_CHL_RSV_CFG1",  .addr = A_CH3_CHL_RSV_CFG1,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_RX_PAD_CFG0",  .addr = A_CH3_RX_PAD_CFG0,
    },{ .name = "CH3_RX_PAD_CFG1",  .addr = A_CH3_RX_PAD_CFG1,
    },{ .name = "CH3_RX_PCS_CFG0",  .addr = A_CH3_RX_PCS_CFG0,
        .rsvd = 0x200,
        .ro = 0x200,
    },{ .name = "CH3_RX_PCS_CFG1",  .addr = A_CH3_RX_PCS_CFG1,
    },{ .name = "CH3_RX_PCS_CFG2",  .addr = A_CH3_RX_PCS_CFG2,
    },{ .name = "CH3_RX_PCS_CFG3",  .addr = A_CH3_RX_PCS_CFG3,
        .rsvd = 0x640000,
        .ro = 0x640000,
    },{ .name = "CH3_RX_PCS_CFG4",  .addr = A_CH3_RX_PCS_CFG4,
    },{ .name = "CH3_CHCLK_MISC_CFG",  .addr = A_CH3_CHCLK_MISC_CFG,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_CHCLK_ILO_CFG",  .addr = A_CH3_CHCLK_ILO_CFG,
        .rsvd = 0xe0028f88,
        .ro = 0xe0028f88,
    },{ .name = "CH3_CHCLK_RXPI_CFG",  .addr = A_CH3_CHCLK_RXPI_CFG,
        .rsvd = 0xff800003,
        .ro = 0xff800003,
    },{ .name = "CH3_CHCLK_RXCAL_CFG",  .addr = A_CH3_CHCLK_RXCAL_CFG,
        .rsvd = 0x1,
        .ro = 0x1,
    },{ .name = "CH3_CHCLK_RXCAL_CFG1",  .addr = A_CH3_CHCLK_RXCAL_CFG1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "CH3_CHCLK_TXPI_CFG0",  .addr = A_CH3_CHCLK_TXPI_CFG0,
    },{ .name = "CH3_CHCLK_TXCAL_CFG",  .addr = A_CH3_CHCLK_TXCAL_CFG,
        .rsvd = 0xf8000000,
        .ro = 0xf8000000,
    },{ .name = "CH3_CHCLK_RXCAL_CFG2",  .addr = A_CH3_CHCLK_RXCAL_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_CHCLK_RSV_CFG",  .addr = A_CH3_CHCLK_RSV_CFG,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_PIPE_TX_EQ_CFG0",  .addr = A_CH3_PIPE_TX_EQ_CFG0,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_PIPE_TX_EQ_CFG1",  .addr = A_CH3_PIPE_TX_EQ_CFG1,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
    },{ .name = "CH3_PIPE_TX_EQ_CFG2",  .addr = A_CH3_PIPE_TX_EQ_CFG2,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
    },{ .name = "CH3_PIPE_TX_EQ_CFG3",  .addr = A_CH3_PIPE_TX_EQ_CFG3,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "CH3_TX_PCS_CFG0",  .addr = A_CH3_TX_PCS_CFG0,
    },{ .name = "CH3_TX_PCS_CFG1",  .addr = A_CH3_TX_PCS_CFG1,
    },{ .name = "CH3_TX_PCS_CFG2",  .addr = A_CH3_TX_PCS_CFG2,
        .rsvd = 0x40000000,
        .ro = 0x40000000,
    },{ .name = "CH3_TX_PCS_CFG3",  .addr = A_CH3_TX_PCS_CFG3,
    },{ .name = "CH3_EYESCAN_CFG0",  .addr = A_CH3_EYESCAN_CFG0,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH3_EYESCAN_CFG1",  .addr = A_CH3_EYESCAN_CFG1,
    },{ .name = "CH3_EYESCAN_CFG2",  .addr = A_CH3_EYESCAN_CFG2,
    },{ .name = "CH3_EYESCAN_CFG3",  .addr = A_CH3_EYESCAN_CFG3,
    },{ .name = "CH3_EYESCAN_CFG4",  .addr = A_CH3_EYESCAN_CFG4,
    },{ .name = "CH3_EYESCAN_CFG5",  .addr = A_CH3_EYESCAN_CFG5,
    },{ .name = "CH3_EYESCAN_CFG6",  .addr = A_CH3_EYESCAN_CFG6,
    },{ .name = "CH3_EYESCAN_CFG7",  .addr = A_CH3_EYESCAN_CFG7,
    },{ .name = "CH3_EYESCAN_CFG8",  .addr = A_CH3_EYESCAN_CFG8,
    },{ .name = "CH3_EYESCAN_CFG9",  .addr = A_CH3_EYESCAN_CFG9,
    },{ .name = "CH3_EYESCAN_CFG10",  .addr = A_CH3_EYESCAN_CFG10,
    },{ .name = "CH3_EYESCAN_CFG11",  .addr = A_CH3_EYESCAN_CFG11,
    },{ .name = "CH3_EYESCAN_CFG12",  .addr = A_CH3_EYESCAN_CFG12,
    },{ .name = "CH3_EYESCAN_CFG13",  .addr = A_CH3_EYESCAN_CFG13,
    },{ .name = "CH3_EYESCAN_CFG14",  .addr = A_CH3_EYESCAN_CFG14,
    },{ .name = "CH3_EYESCAN_CFG15",  .addr = A_CH3_EYESCAN_CFG15,
    },{ .name = "CH3_EYESCAN_CFG16",  .addr = A_CH3_EYESCAN_CFG16,
        .rsvd = 0x70000,
        .ro = 0x70000,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG0",  .addr = A_CH3_RX_ELASTIC_BUF_CFG0,
    },{ .name = "CH3_TX_10G_CFG0",  .addr = A_CH3_TX_10G_CFG0,
    },{ .name = "CH3_TX_10G_CFG1",  .addr = A_CH3_TX_10G_CFG1,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_TX_10G_CFG2",  .addr = A_CH3_TX_10G_CFG2,
    },{ .name = "CH3_TX_10G_CFG3",  .addr = A_CH3_TX_10G_CFG3,
        .rsvd = 0xfc000000,
        .ro = 0xfc000000,
    },{ .name = "CH3_RX_PHALIGN_CFG0",  .addr = A_CH3_RX_PHALIGN_CFG0,
    },{ .name = "CH3_RX_PHALIGN_CFG1",  .addr = A_CH3_RX_PHALIGN_CFG1,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH3_RX_PHALIGN_CFG2",  .addr = A_CH3_RX_PHALIGN_CFG2,
        .rsvd = 0x1f,
        .ro = 0x1f,
    },{ .name = "CH3_RX_PHALIGN_CFG3",  .addr = A_CH3_RX_PHALIGN_CFG3,
        .rsvd = 0x300000,
        .ro = 0x300000,
    },{ .name = "CH3_RX_PHALIGN_CFG4",  .addr = A_CH3_RX_PHALIGN_CFG4,
    },{ .name = "CH3_RX_PHALIGN_CFG5",  .addr = A_CH3_RX_PHALIGN_CFG5,
        .rsvd = 0x7,
        .ro = 0x7,
    },{ .name = "CH3_TX_PHALIGN_CFG0",  .addr = A_CH3_TX_PHALIGN_CFG0,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH3_TX_PHALIGN_CFG1",  .addr = A_CH3_TX_PHALIGN_CFG1,
    },{ .name = "CH3_TX_PHALIGN_CFG2",  .addr = A_CH3_TX_PHALIGN_CFG2,
        .rsvd = 0x300,
        .ro = 0x300,
    },{ .name = "CH3_TX_PHALIGN_CFG3",  .addr = A_CH3_TX_PHALIGN_CFG3,
    },{ .name = "CH3_TX_PHALIGN_CFG4",  .addr = A_CH3_TX_PHALIGN_CFG4,
        .rsvd = 0xc00,
        .ro = 0xc00,
    },{ .name = "CH3_TX_PHALIGN_CFG5",  .addr = A_CH3_TX_PHALIGN_CFG5,
    },{ .name = "CH3_PIPE_CTRL_CFG0",  .addr = A_CH3_PIPE_CTRL_CFG0,
    },{ .name = "CH3_PIPE_CTRL_CFG1",  .addr = A_CH3_PIPE_CTRL_CFG1,
    },{ .name = "CH3_PIPE_CTRL_CFG2",  .addr = A_CH3_PIPE_CTRL_CFG2,
    },{ .name = "CH3_PIPE_CTRL_CFG3",  .addr = A_CH3_PIPE_CTRL_CFG3,
    },{ .name = "CH3_PIPE_CTRL_CFG4",  .addr = A_CH3_PIPE_CTRL_CFG4,
    },{ .name = "CH3_PIPE_CTRL_CFG5",  .addr = A_CH3_PIPE_CTRL_CFG5,
    },{ .name = "CH3_PIPE_CTRL_CFG6",  .addr = A_CH3_PIPE_CTRL_CFG6,
    },{ .name = "CH3_PIPE_CTRL_CFG7",  .addr = A_CH3_PIPE_CTRL_CFG7,
    },{ .name = "CH3_PIPE_CTRL_CFG8",  .addr = A_CH3_PIPE_CTRL_CFG8,
    },{ .name = "CH3_PIPE_CTRL_CFG9",  .addr = A_CH3_PIPE_CTRL_CFG9,
    },{ .name = "CH3_TX_PIPPM_CFG",  .addr = A_CH3_TX_PIPPM_CFG,
        .rsvd = 0xc0007000,
        .ro = 0xc0007000,
    },{ .name = "CH3_CHL_RSV_CFG2",  .addr = A_CH3_CHL_RSV_CFG2,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_FABRIC_INTF_CFG0",  .addr = A_CH3_FABRIC_INTF_CFG0,
    },{ .name = "CH3_FABRIC_INTF_CFG1",  .addr = A_CH3_FABRIC_INTF_CFG1,
        .rsvd = 0x7000,
        .ro = 0x7000,
    },{ .name = "CH3_FABRIC_INTF_CFG2",  .addr = A_CH3_FABRIC_INTF_CFG2,
    },{ .name = "CH3_FABRIC_INTF_CFG3",  .addr = A_CH3_FABRIC_INTF_CFG3,
    },{ .name = "CH3_FABRIC_INTF_CFG4",  .addr = A_CH3_FABRIC_INTF_CFG4,
        .rsvd = 0x8000,
        .ro = 0x8000,
    },{ .name = "CH3_FABRIC_INTF_CFG5",  .addr = A_CH3_FABRIC_INTF_CFG5,
        .rsvd = 0x8,
        .ro = 0x8,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG1",  .addr = A_CH3_RX_ELASTIC_BUF_CFG1,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG2",  .addr = A_CH3_RX_ELASTIC_BUF_CFG2,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG3",  .addr = A_CH3_RX_ELASTIC_BUF_CFG3,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG4",  .addr = A_CH3_RX_ELASTIC_BUF_CFG4,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG5",  .addr = A_CH3_RX_ELASTIC_BUF_CFG5,
        .rsvd = 0x80000000,
        .ro = 0x80000000,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG6",  .addr = A_CH3_RX_ELASTIC_BUF_CFG6,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG7",  .addr = A_CH3_RX_ELASTIC_BUF_CFG7,
        .rsvd = 0xb800000,
        .ro = 0xb800000,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG8",  .addr = A_CH3_RX_ELASTIC_BUF_CFG8,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH3_RX_ELASTIC_BUF_CFG9",  .addr = A_CH3_RX_ELASTIC_BUF_CFG9,
        .rsvd = 0x4fe00000,
        .ro = 0x4fe00000,
    },{ .name = "CH3_RX_OOB_CFG0",  .addr = A_CH3_RX_OOB_CFG0,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
    },{ .name = "CH3_RX_OOB_CFG1",  .addr = A_CH3_RX_OOB_CFG1,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "CH3_MONITOR_CFG",  .addr = A_CH3_MONITOR_CFG,
        .rsvd = 0xf00,
        .ro = 0xf00,
    },{ .name = "CH3_PIPE_CTRL_CFG10",  .addr = A_CH3_PIPE_CTRL_CFG10,
        .rsvd = 0x78000010,
        .ro = 0x78000010,
    },{ .name = "CH3_CHL_RSV_CFG3",  .addr = A_CH3_CHL_RSV_CFG3,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CH3_CHL_RSV_CFG4",  .addr = A_CH3_CHL_RSV_CFG4,
        .rsvd = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "MEMCELLX3EF8",  .addr = A_MEMCELLX3EF8,
        .rsvd = 0x3fffffff,
        .ro = 0x3fffffff,
    },{ .name = "MEMCELLX3EFC",  .addr = A_MEMCELLX3EFC,
        .rsvd = 0xfc000080,
        .ro = 0xfc000080,
    }
};

static void gty_npi_slave_reset(DeviceState *dev)
{
    GTY_NPI_SLAVE *s = XILINX_GTY_NPI_SLAVE(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static MemTxResult reg_write(void *opaque, hwaddr addr,
                             uint64_t data, unsigned size, MemTxAttrs attrs)
{
    RegisterInfoArray *reg_array = opaque;
    GTY_NPI_SLAVE *s = XILINX_GTY_NPI_SLAVE(reg_array->r[0]->opaque);

    /* Is the register set Locked?  */
    if (ARRAY_FIELD_EX32(s->regs, REG_PCSR_LOCK, STATE) &&
        addr != A_REG_PCSR_LOCK) {
        return MEMTX_ERROR;
    }

    register_write_memory(opaque, addr, data, size);
    return MEMTX_OK;
}

static const MemoryRegionOps gty_npi_slave_ops = {
    .read = register_read_memory,
    .write_with_attrs = reg_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void gty_npi_slave_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void gty_npi_slave_init(Object *obj)
{
    GTY_NPI_SLAVE *s = XILINX_GTY_NPI_SLAVE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_GTY_NPI_SLAVE,
                       GTY_NPI_SLAVE_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), gty_npi_slave_regs_info,
                              ARRAY_SIZE(gty_npi_slave_regs_info),
                              s->regs_info, s->regs,
                              &gty_npi_slave_ops,
                              XILINX_GTY_NPI_SLAVE_ERR_DEBUG,
                              GTY_NPI_SLAVE_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_gty_npi_slave = {
    .name = TYPE_XILINX_GTY_NPI_SLAVE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, GTY_NPI_SLAVE, GTY_NPI_SLAVE_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void gty_npi_slave_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = gty_npi_slave_reset;
    dc->realize = gty_npi_slave_realize;
    dc->vmsd = &vmstate_gty_npi_slave;
}

static const TypeInfo gty_npi_slave_info = {
    .name          = TYPE_XILINX_GTY_NPI_SLAVE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(GTY_NPI_SLAVE),
    .class_init    = gty_npi_slave_class_init,
    .instance_init = gty_npi_slave_init,
};

static void gty_npi_slave_register_types(void)
{
    type_register_static(&gty_npi_slave_info);
}

type_init(gty_npi_slave_register_types)
