/*
 * QEMU model of the FPD_SLCR Global system level control registers for the
 * full power domain
 *
 * Copyright (c) 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-09-03.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "qemu/log.h"

/* Skeleton model */

#ifndef XILINX_FPD_SLCR_ERR_DEBUG
#define XILINX_FPD_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_FPD_SLCR "xlnx,versal-fpd-slcr"

#define XILINX_FPD_SLCR(obj) \
     OBJECT_CHECK(FPD_SLCR, (obj), TYPE_XILINX_FPD_SLCR)

REG32(WPROT0, 0x0)
    FIELD(WPROT0, ACTIVE, 0, 1)
REG32(CTRL, 0x4)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x8)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0xc)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x10)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x14)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x18)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)
REG32(WDT_CLK_SEL, 0x100)
    FIELD(WDT_CLK_SEL, SELECT, 0, 1)
REG32(APUGIC_CTRL, 0x10c)
    FIELD(APUGIC_CTRL, AWQOS, 16, 4)
    FIELD(APUGIC_CTRL, ARQOS, 0, 4)
REG32(BISR_CACHE_CTRL_0, 0x400)
    FIELD(BISR_CACHE_CTRL_0, CLR, 4, 1)
    FIELD(BISR_CACHE_CTRL_0, TRIGGER, 0, 1)
REG32(BISR_CACHE_CTRL_1, 0x404)
    FIELD(BISR_CACHE_CTRL_1, PGEN_3, 3, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_2, 2, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_1, 1, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_0, 0, 1)
REG32(BISR_CACHE_STATUS, 0x408)
    FIELD(BISR_CACHE_STATUS, PASS_3, 9, 1)
    FIELD(BISR_CACHE_STATUS, DONE_3, 8, 1)
    FIELD(BISR_CACHE_STATUS, PASS_2, 7, 1)
    FIELD(BISR_CACHE_STATUS, DONE_2, 6, 1)
    FIELD(BISR_CACHE_STATUS, PASS_1, 5, 1)
    FIELD(BISR_CACHE_STATUS, DONE_1, 4, 1)
    FIELD(BISR_CACHE_STATUS, PASS_0, 3, 1)
    FIELD(BISR_CACHE_STATUS, DONE_0, 2, 1)
    FIELD(BISR_CACHE_STATUS, PASS, 1, 1)
    FIELD(BISR_CACHE_STATUS, DONE, 0, 1)
REG32(BISR_CACHE_DATA_0, 0x40c)
REG32(BISR_CACHE_DATA_1, 0x410)
REG32(BISR_CACHE_DATA_2, 0x414)
REG32(BISR_CACHE_DATA_3, 0x418)
REG32(BISR_CACHE_DATA_4, 0x41c)
REG32(BISR_CACHE_DATA_5, 0x420)
REG32(BISR_CACHE_DATA_6, 0x424)
REG32(BISR_CACHE_DATA_7, 0x428)
REG32(BISR_CACHE_DATA_8, 0x42c)
REG32(BISR_CACHE_DATA_9, 0x430)
REG32(BISR_CACHE_DATA_10, 0x434)
REG32(BISR_CACHE_DATA_11, 0x438)
REG32(BISR_CACHE_DATA_12, 0x43c)
REG32(BISR_CACHE_DATA_13, 0x440)
REG32(BISR_CACHE_DATA_14, 0x444)
REG32(BISR_CACHE_DATA_15, 0x448)
REG32(BISR_CACHE_DATA_16, 0x44c)
REG32(BISR_CACHE_DATA_17, 0x450)
REG32(BISR_CACHE_DATA_18, 0x454)
REG32(BISR_CACHE_DATA_19, 0x458)
REG32(BISR_CACHE_DATA_20, 0x45c)
REG32(BISR_CACHE_DATA_21, 0x460)
REG32(BISR_CACHE_DATA_22, 0x464)
REG32(BISR_CACHE_DATA_23, 0x468)
REG32(BISR_CACHE_DATA_24, 0x46c)
REG32(BISR_CACHE_DATA_25, 0x470)
REG32(BISR_CACHE_DATA_26, 0x474)
REG32(BISR_CACHE_DATA_27, 0x478)
REG32(BISR_CACHE_DATA_28, 0x47c)
REG32(BISR_CACHE_DATA_29, 0x480)
REG32(BISR_CACHE_DATA_30, 0x484)
REG32(BISR_CACHE_DATA_31, 0x488)
REG32(BISR_TEST_DATA_0, 0x48c)
REG32(BISR_TEST_DATA_1, 0x490)
REG32(BISR_TEST_DATA_2, 0x494)
REG32(BISR_TEST_DATA_3, 0x498)
REG32(BISR_TEST_DATA_4, 0x49c)
REG32(BISR_TEST_DATA_5, 0x4a0)
REG32(BISR_TEST_DATA_6, 0x4a4)
REG32(BISR_TEST_DATA_7, 0x4a8)
REG32(BISR_TEST_DATA_8, 0x4ac)
REG32(BISR_TEST_DATA_9, 0x4b0)
REG32(BISR_TEST_DATA_10, 0x4b4)
REG32(BISR_TEST_DATA_11, 0x4b8)
REG32(BISR_TEST_DATA_12, 0x4bc)
REG32(BISR_TEST_DATA_13, 0x4c0)
REG32(BISR_TEST_DATA_14, 0x4c4)
REG32(BISR_TEST_DATA_15, 0x4c8)
REG32(BISR_TEST_DATA_16, 0x4cc)
REG32(BISR_TEST_DATA_17, 0x4d0)
REG32(BISR_TEST_DATA_18, 0x4d4)
REG32(BISR_TEST_DATA_19, 0x4d8)
REG32(BISR_TEST_DATA_20, 0x4dc)
REG32(BISR_TEST_DATA_21, 0x4e0)
REG32(BISR_TEST_DATA_22, 0x4e4)
REG32(BISR_TEST_DATA_23, 0x4e8)
REG32(BISR_TEST_DATA_24, 0x4ec)
REG32(BISR_TEST_DATA_25, 0x4f0)
REG32(BISR_TEST_DATA_26, 0x4f4)
REG32(BISR_TEST_DATA_27, 0x4f8)
REG32(BISR_TEST_DATA_28, 0x4fc)
REG32(BISR_TEST_DATA_29, 0x500)
REG32(BISR_TEST_DATA_30, 0x504)
REG32(BISR_TEST_DATA_31, 0x508)
REG32(ECO, 0xffc)
REG32(AFI_FS, 0x5000)
    FIELD(AFI_FS, DW_SS0_SEL, 8, 2)

#define FPD_SLCR_R_MAX (R_AFI_FS + 1)

typedef struct FPD_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr;

    uint32_t regs[FPD_SLCR_R_MAX];
    RegisterInfo regs_info[FPD_SLCR_R_MAX];
} FPD_SLCR;

static void imr_update_irq(FPD_SLCR *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR *s = XILINX_FPD_SLCR(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR *s = XILINX_FPD_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR *s = XILINX_FPD_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR *s = XILINX_FPD_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR] |= val;
    imr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo fpd_slcr_regs_info[] = {
    {   .name = "WPROT0",  .addr = A_WPROT0,
        .reset = 0x1,
    },{ .name = "CTRL",  .addr = A_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "ISR",  .addr = A_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "IER",  .addr = A_IER,
        .rsvd = 0xfffffffe,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .rsvd = 0xfffffffe,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .rsvd = 0xfffffffe,
        .pre_write = itr_prew,
    },{ .name = "WDT_CLK_SEL",  .addr = A_WDT_CLK_SEL,
        .rsvd = 0xfffffffe,
    },{ .name = "APUGIC_CTRL",  .addr = A_APUGIC_CTRL,
        .reset = 0x40004,
        .rsvd = 0xfff0fff0,
    },{ .name = "BISR_CACHE_CTRL_0",  .addr = A_BISR_CACHE_CTRL_0,
        .rsvd = 0xffffffee,
    },{ .name = "BISR_CACHE_CTRL_1",  .addr = A_BISR_CACHE_CTRL_1,
        .rsvd = 0xfffffff0,
    },{ .name = "BISR_CACHE_STATUS",  .addr = A_BISR_CACHE_STATUS,
        .rsvd = 0xfffffc00,
        .ro = 0x3ff,
    },{ .name = "BISR_CACHE_DATA_0",  .addr = A_BISR_CACHE_DATA_0,
    },{ .name = "BISR_CACHE_DATA_1",  .addr = A_BISR_CACHE_DATA_1,
    },{ .name = "BISR_CACHE_DATA_2",  .addr = A_BISR_CACHE_DATA_2,
    },{ .name = "BISR_CACHE_DATA_3",  .addr = A_BISR_CACHE_DATA_3,
    },{ .name = "BISR_CACHE_DATA_4",  .addr = A_BISR_CACHE_DATA_4,
    },{ .name = "BISR_CACHE_DATA_5",  .addr = A_BISR_CACHE_DATA_5,
    },{ .name = "BISR_CACHE_DATA_6",  .addr = A_BISR_CACHE_DATA_6,
    },{ .name = "BISR_CACHE_DATA_7",  .addr = A_BISR_CACHE_DATA_7,
    },{ .name = "BISR_CACHE_DATA_8",  .addr = A_BISR_CACHE_DATA_8,
    },{ .name = "BISR_CACHE_DATA_9",  .addr = A_BISR_CACHE_DATA_9,
    },{ .name = "BISR_CACHE_DATA_10",  .addr = A_BISR_CACHE_DATA_10,
    },{ .name = "BISR_CACHE_DATA_11",  .addr = A_BISR_CACHE_DATA_11,
    },{ .name = "BISR_CACHE_DATA_12",  .addr = A_BISR_CACHE_DATA_12,
    },{ .name = "BISR_CACHE_DATA_13",  .addr = A_BISR_CACHE_DATA_13,
    },{ .name = "BISR_CACHE_DATA_14",  .addr = A_BISR_CACHE_DATA_14,
    },{ .name = "BISR_CACHE_DATA_15",  .addr = A_BISR_CACHE_DATA_15,
    },{ .name = "BISR_CACHE_DATA_16",  .addr = A_BISR_CACHE_DATA_16,
    },{ .name = "BISR_CACHE_DATA_17",  .addr = A_BISR_CACHE_DATA_17,
    },{ .name = "BISR_CACHE_DATA_18",  .addr = A_BISR_CACHE_DATA_18,
    },{ .name = "BISR_CACHE_DATA_19",  .addr = A_BISR_CACHE_DATA_19,
    },{ .name = "BISR_CACHE_DATA_20",  .addr = A_BISR_CACHE_DATA_20,
    },{ .name = "BISR_CACHE_DATA_21",  .addr = A_BISR_CACHE_DATA_21,
    },{ .name = "BISR_CACHE_DATA_22",  .addr = A_BISR_CACHE_DATA_22,
    },{ .name = "BISR_CACHE_DATA_23",  .addr = A_BISR_CACHE_DATA_23,
    },{ .name = "BISR_CACHE_DATA_24",  .addr = A_BISR_CACHE_DATA_24,
    },{ .name = "BISR_CACHE_DATA_25",  .addr = A_BISR_CACHE_DATA_25,
    },{ .name = "BISR_CACHE_DATA_26",  .addr = A_BISR_CACHE_DATA_26,
    },{ .name = "BISR_CACHE_DATA_27",  .addr = A_BISR_CACHE_DATA_27,
    },{ .name = "BISR_CACHE_DATA_28",  .addr = A_BISR_CACHE_DATA_28,
    },{ .name = "BISR_CACHE_DATA_29",  .addr = A_BISR_CACHE_DATA_29,
    },{ .name = "BISR_CACHE_DATA_30",  .addr = A_BISR_CACHE_DATA_30,
    },{ .name = "BISR_CACHE_DATA_31",  .addr = A_BISR_CACHE_DATA_31,
    },{ .name = "BISR_TEST_DATA_0",  .addr = A_BISR_TEST_DATA_0,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_1",  .addr = A_BISR_TEST_DATA_1,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_2",  .addr = A_BISR_TEST_DATA_2,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_3",  .addr = A_BISR_TEST_DATA_3,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_4",  .addr = A_BISR_TEST_DATA_4,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_5",  .addr = A_BISR_TEST_DATA_5,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_6",  .addr = A_BISR_TEST_DATA_6,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_7",  .addr = A_BISR_TEST_DATA_7,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_8",  .addr = A_BISR_TEST_DATA_8,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_9",  .addr = A_BISR_TEST_DATA_9,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_10",  .addr = A_BISR_TEST_DATA_10,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_11",  .addr = A_BISR_TEST_DATA_11,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_12",  .addr = A_BISR_TEST_DATA_12,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_13",  .addr = A_BISR_TEST_DATA_13,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_14",  .addr = A_BISR_TEST_DATA_14,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_15",  .addr = A_BISR_TEST_DATA_15,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_16",  .addr = A_BISR_TEST_DATA_16,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_17",  .addr = A_BISR_TEST_DATA_17,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_18",  .addr = A_BISR_TEST_DATA_18,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_19",  .addr = A_BISR_TEST_DATA_19,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_20",  .addr = A_BISR_TEST_DATA_20,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_21",  .addr = A_BISR_TEST_DATA_21,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_22",  .addr = A_BISR_TEST_DATA_22,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_23",  .addr = A_BISR_TEST_DATA_23,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_24",  .addr = A_BISR_TEST_DATA_24,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_25",  .addr = A_BISR_TEST_DATA_25,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_26",  .addr = A_BISR_TEST_DATA_26,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_27",  .addr = A_BISR_TEST_DATA_27,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_28",  .addr = A_BISR_TEST_DATA_28,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_29",  .addr = A_BISR_TEST_DATA_29,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_30",  .addr = A_BISR_TEST_DATA_30,
        .ro = 0xffffffff,
    },{ .name = "BISR_TEST_DATA_31",  .addr = A_BISR_TEST_DATA_31,
        .ro = 0xffffffff,
    },{ .name = "ECO",  .addr = A_ECO,
    },{ .name = "AFI_FS",  .addr = A_AFI_FS,
        .reset = 0x200,
        .rsvd = 0xfffff0ff,
    }
};

static void fpd_slcr_reset(DeviceState *dev)
{
    FPD_SLCR *s = XILINX_FPD_SLCR(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    imr_update_irq(s);
}

static const MemoryRegionOps fpd_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void fpd_slcr_init(Object *obj)
{
    FPD_SLCR *s = XILINX_FPD_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_FPD_SLCR,
                       FPD_SLCR_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), fpd_slcr_regs_info,
                              ARRAY_SIZE(fpd_slcr_regs_info),
                              s->regs_info, s->regs,
                              &fpd_slcr_ops,
                              XILINX_FPD_SLCR_ERR_DEBUG,
                              FPD_SLCR_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr);
}

static const VMStateDescription vmstate_fpd_slcr = {
    .name = TYPE_XILINX_FPD_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, FPD_SLCR, FPD_SLCR_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void fpd_slcr_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = fpd_slcr_reset;
    dc->vmsd = &vmstate_fpd_slcr;
}

static const TypeInfo fpd_slcr_info = {
    .name          = TYPE_XILINX_FPD_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(FPD_SLCR),
    .class_init    = fpd_slcr_class_init,
    .instance_init = fpd_slcr_init,
};

static void fpd_slcr_register_types(void)
{
    type_register_static(&fpd_slcr_info);
}

type_init(fpd_slcr_register_types)
