/*
 * QEMU model of the AFI_FM AXI Fabric Master Interface
 *
 * Copyright (c) 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-03-05.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "hw/irq.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_AFI_FM_ERR_DEBUG
#define XILINX_AFI_FM_ERR_DEBUG 0
#endif

#define TYPE_XILINX_AFI_FM "xlnx.versal-afi-fm"

#define XILINX_AFI_FM(obj) \
     OBJECT_CHECK(AFI_FM, (obj), TYPE_XILINX_AFI_FM)

REG32(AFIFM_RDCTRL, 0x0)
    FIELD(AFIFM_RDCTRL, PAUSE, 3, 1)
    FIELD(AFIFM_RDCTRL, FABRIC_QOS_EN, 2, 1)
    FIELD(AFIFM_RDCTRL, FABRIC_WIDTH, 0, 2)
REG32(AFIFM_RDISSUE, 0x4)
    FIELD(AFIFM_RDISSUE, IGNORE_SPACE, 4, 1)
    FIELD(AFIFM_RDISSUE, CAPABILITY, 0, 4)
REG32(AFIFM_RDQOS, 0x8)
    FIELD(AFIFM_RDQOS, VALUE, 0, 4)
REG32(AFIFM_RDDEBUG, 0x10)
    FIELD(AFIFM_RDDEBUG, AFI_VERSION, 30, 2)
    FIELD(AFIFM_RDDEBUG, OUT_RDCMDS, 1, 5)
    FIELD(AFIFM_RDDEBUG, DFIFO_OVERFLOW, 0, 1)
REG32(AFIFM_WRCTRL, 0x14)
    FIELD(AFIFM_WRCTRL, WR_RELEASE_MODE, 12, 1)
    FIELD(AFIFM_WRCTRL, PAUSE, 3, 1)
    FIELD(AFIFM_WRCTRL, FABRIC_QOS_EN, 2, 1)
    FIELD(AFIFM_WRCTRL, FABRIC_WIDTH, 0, 2)
REG32(AFIFM_WRISSUE, 0x18)
    FIELD(AFIFM_WRISSUE, CAPABILITY, 0, 4)
REG32(AFIFM_WRQOS, 0x1c)
    FIELD(AFIFM_WRQOS, VALUE, 0, 4)
REG32(AFIFM_I_STS, 0xe00)
    FIELD(AFIFM_I_STS, INVALID_APB, 0, 1)
REG32(AFIFM_I_EN, 0xe04)
    FIELD(AFIFM_I_EN, INVALID_APB, 0, 1)
REG32(AFIFM_I_DIS, 0xe08)
    FIELD(AFIFM_I_DIS, INVALID_APB, 0, 1)
REG32(AFIFM_I_MASK, 0xe0c)
    FIELD(AFIFM_I_MASK, INVALID_APB, 0, 1)
REG32(AFIFM_CONTROL, 0xf04)
    FIELD(AFIFM_CONTROL, APB_ERR_RESP, 0, 1)
REG32(AFIFM_SAFETY_CHK, 0xf0c)

#define AFI_FM_R_MAX (R_AFIFM_SAFETY_CHK + 1)

typedef struct AFI_FM {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_afifm_i;

    uint32_t regs[AFI_FM_R_MAX];
    RegisterInfo regs_info[AFI_FM_R_MAX];
} AFI_FM;

static void afifm_i_update_irq(AFI_FM *s)
{
    bool pending = s->regs[R_AFIFM_I_STS] & ~s->regs[R_AFIFM_I_MASK];
    qemu_set_irq(s->irq_afifm_i, pending);
}

static void afifm_i_sts_postw(RegisterInfo *reg, uint64_t val64)
{
    AFI_FM *s = XILINX_AFI_FM(reg->opaque);
    afifm_i_update_irq(s);
}

static uint64_t afifm_i_en_prew(RegisterInfo *reg, uint64_t val64)
{
    AFI_FM *s = XILINX_AFI_FM(reg->opaque);
    uint32_t val = val64;

    s->regs[R_AFIFM_I_MASK] &= ~val;
    afifm_i_update_irq(s);
    return 0;
}

static uint64_t afifm_i_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    AFI_FM *s = XILINX_AFI_FM(reg->opaque);
    uint32_t val = val64;

    s->regs[R_AFIFM_I_MASK] |= val;
    afifm_i_update_irq(s);
    return 0;
}

static const RegisterAccessInfo afi_fm_regs_info[] = {
    {   .name = "AFIFM_RDCTRL",  .addr = A_AFIFM_RDCTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "AFIFM_RDISSUE",  .addr = A_AFIFM_RDISSUE,
        .reset = 0x7,
        .rsvd = 0xffffffe0,
    },{ .name = "AFIFM_RDQOS",  .addr = A_AFIFM_RDQOS,
        .reset = 0x7,
        .rsvd = 0xfffffff0,
    },{ .name = "AFIFM_RDDEBUG",  .addr = A_AFIFM_RDDEBUG,
        .reset = 0x40000000,
        .rsvd = 0x3fffffc0,
        .ro = 0xc000003f,
    },{ .name = "AFIFM_WRCTRL",  .addr = A_AFIFM_WRCTRL,
        .rsvd = 0xffffeff0,
    },{ .name = "AFIFM_WRISSUE",  .addr = A_AFIFM_WRISSUE,
        .reset = 0x7,
        .rsvd = 0xfffffff0,
    },{ .name = "AFIFM_WRQOS",  .addr = A_AFIFM_WRQOS,
        .reset = 0x7,
        .rsvd = 0xfffffff0,
    },{ .name = "AFIFM_I_STS",  .addr = A_AFIFM_I_STS,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = afifm_i_sts_postw,
    },{ .name = "AFIFM_I_EN",  .addr = A_AFIFM_I_EN,
        .rsvd = 0xfffffffe,
        .pre_write = afifm_i_en_prew,
    },{ .name = "AFIFM_I_DIS",  .addr = A_AFIFM_I_DIS,
        .rsvd = 0xfffffffe,
        .pre_write = afifm_i_dis_prew,
    },{ .name = "AFIFM_I_MASK",  .addr = A_AFIFM_I_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "AFIFM_CONTROL",  .addr = A_AFIFM_CONTROL,
        .rsvd = 0xfffffffe,
    },{ .name = "AFIFM_SAFETY_CHK",  .addr = A_AFIFM_SAFETY_CHK,
    }
};

static void afi_fm_reset(DeviceState *dev)
{
    AFI_FM *s = XILINX_AFI_FM(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    afifm_i_update_irq(s);
}

static const MemoryRegionOps afi_fm_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void afi_fm_init(Object *obj)
{
    AFI_FM *s = XILINX_AFI_FM(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_AFI_FM, AFI_FM_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), afi_fm_regs_info,
                              ARRAY_SIZE(afi_fm_regs_info),
                              s->regs_info, s->regs,
                              &afi_fm_ops,
                              XILINX_AFI_FM_ERR_DEBUG,
                              AFI_FM_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_afifm_i);
}

static const VMStateDescription vmstate_afi_fm = {
    .name = TYPE_XILINX_AFI_FM,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, AFI_FM, AFI_FM_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void afi_fm_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = afi_fm_reset;
    dc->vmsd = &vmstate_afi_fm;
}

static const TypeInfo afi_fm_info = {
    .name          = TYPE_XILINX_AFI_FM,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(AFI_FM),
    .class_init    = afi_fm_class_init,
    .instance_init = afi_fm_init,
};

static void afi_fm_register_types(void)
{
    type_register_static(&afi_fm_info);
}

type_init(afi_fm_register_types)
