/*
 * QEMU model of the HNICX_NPI NPI Module for HNICX
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2022-06-23.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_HNICX_NPI_ERR_DEBUG
#define XILINX_HNICX_NPI_ERR_DEBUG 0
#endif

#define TYPE_XILINX_HNICX_NPI "xlnx.hnicx_npi"

#define XILINX_HNICX_NPI(obj) \
     OBJECT_CHECK(HNICX_NPI, (obj), TYPE_XILINX_HNICX_NPI)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, NPI_CLK_EN, 31, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_DPU3, 30, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_DPU2, 29, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_DPU1, 28, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_DPU0, 27, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_NTHUB, 26, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_NMAC, 25, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_NMAE, 24, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_HMAE, 23, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_LCS, 22, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_HUB, 21, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER_VNX, 18, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, NPI_MODSEL, 12, 1)
    FIELD(REG_PCSR_MASK, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(REG_PCSR_MASK, MEMCFG_2PUHD_RSTN, 10, 1)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE, 2, 4)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, NPI_CLK_EN, 31, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_DPU3, 30, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_DPU2, 29, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_DPU1, 28, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_DPU0, 27, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_NTHUB, 26, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_NMAC, 25, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_NMAE, 24, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_HMAE, 23, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_LCS, 22, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_HUB, 21, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER_VNX, 18, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, NPI_MODSEL, 12, 1)
    FIELD(REG_PCSR_CONTROL, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(REG_PCSR_CONTROL, MEMCFG_2PUHD_RSTN, 10, 1)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE, 2, 4)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_DPU3, 31, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_DPU3, 30, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_DPU2, 29, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_DPU2, 28, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_DPU1, 27, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_DPU1, 26, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_DPU0, 25, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_DPU0, 24, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_NMAE, 23, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_NMAE, 22, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_HMAE, 21, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_HMAE, 20, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_LCS_NMAC, 19, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_LCS_NMAC, 18, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_HUB, 17, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_HUB, 16, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_VNX, 15, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_VNX, 14, 1)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS_NTHUB, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE_NTHUB, 6, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_NPI_CSR_WR_STATUS, 0x208)
    FIELD(REG_NPI_CSR_WR_STATUS, BVALID, 0, 1)
REG32(REG_NPI_CSR_RD_STATUS, 0x20c)
    FIELD(REG_NPI_CSR_RD_STATUS, RVALID, 0, 1)

#define HNICX_NPI_R_MAX (R_REG_NPI_CSR_RD_STATUS + 1)

typedef struct HNICX_NPI {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[HNICX_NPI_R_MAX];
    RegisterInfo regs_info[HNICX_NPI_R_MAX];
} HNICX_NPI;

static void reg_pcsr_ctrl_postw(RegisterInfo *reg, uint64_t val)
{
    HNICX_NPI *s = XILINX_HNICX_NPI(reg->opaque);
    uint32_t val32 = val;

    s->regs[R_REG_PCSR_STATUS] |=
        (val32 & R_REG_PCSR_CONTROL_SCAN_CLEAR_TRIGGER_MASK ?
                 (R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK |
                 R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK) : 0) |
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_NTHUB_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_NTHUB_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_NTHUB_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_VNX_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_VNX_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_VNX_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_HUB_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_HUB_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_HUB_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_LCS_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_LCS_NMAC_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_LCS_NMAC_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_HMAE_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_HMAE_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_HMAE_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_NMAE_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_NMAE_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_NMAE_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_DPU0_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_DPU0_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_DPU0_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_DPU1_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_DPU1_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_DPU1_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_DPU2_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_DPU2_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_DPU2_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_DPU3_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_DPU3_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_DPU3_MASK): 0);
}

static void reg_pcsr_lock_postw(RegisterInfo *reg, uint64_t val)
{
    HNICX_NPI *s = XILINX_HNICX_NPI(reg->opaque);

    s->regs[R_REG_PCSR_STATUS] &= ~R_REG_PCSR_STATUS_PCSRLOCK_MASK;

    if (val != 0xf9e8d7c6) {
        s->regs[R_REG_PCSR_STATUS] |= val & R_REG_PCSR_LOCK_STATE_MASK;
    }
}

static const RegisterAccessInfo hnicx_npi_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0x6100,
        .ro = 0x6100,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x14fe,
        .rsvd = 0x6100,
        .ro = 0x6100,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = 0xFFFFC0C7,
        .rsvd = 0x38,
        .ro = 0xffffffc7,
        .post_write = reg_pcsr_ctrl_postw,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .post_write = reg_pcsr_lock_postw,
    },{ .name = "REG_NPI_CSR_WR_STATUS",  .addr = A_REG_NPI_CSR_WR_STATUS,
        .reset = 0x1,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_NPI_CSR_RD_STATUS",  .addr = A_REG_NPI_CSR_RD_STATUS,
        .reset = 0x1,
        .rsvd = 0xfffffff8,
    }
};

static void hnicx_npi_reset_enter(Object *obj, ResetType type)
{
    HNICX_NPI *s = XILINX_HNICX_NPI(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps hnicx_npi_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void hnicx_npi_init(Object *obj)
{
    HNICX_NPI *s = XILINX_HNICX_NPI(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_HNICX_NPI, HNICX_NPI_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), hnicx_npi_regs_info,
                              ARRAY_SIZE(hnicx_npi_regs_info),
                              s->regs_info, s->regs,
                              &hnicx_npi_ops,
                              XILINX_HNICX_NPI_ERR_DEBUG,
                              HNICX_NPI_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_hnicx_npi = {
    .name = TYPE_XILINX_HNICX_NPI,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, HNICX_NPI, HNICX_NPI_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void hnicx_npi_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_hnicx_npi;
    rc->phases.enter = hnicx_npi_reset_enter;
}

static const TypeInfo hnicx_npi_info = {
    .name          = TYPE_XILINX_HNICX_NPI,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(HNICX_NPI),
    .class_init    = hnicx_npi_class_init,
    .instance_init = hnicx_npi_init,
};

static void hnicx_npi_register_types(void)
{
    type_register_static(&hnicx_npi_info);
}

type_init(hnicx_npi_register_types)
