/*
 * QEMU model of the PMU_GLOBAL
 *
 * Copyright (c) 2014 - 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-03-19.
 * Written by Edgar E. Iglesias.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "hw/qdev-properties.h"

#include "hw/fdt_generic_util.h"

#ifndef XILINX_PMU_GLOBAL_ERR_DEBUG
#define XILINX_PMU_GLOBAL_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMU_GLOBAL "xlnx,pmu_global"

#define XILINX_PMU_GLOBAL(obj) \
     OBJECT_CHECK(PMU_GLOBAL, (obj), TYPE_XILINX_PMU_GLOBAL)

REG32(GLOBAL_CNTRL, 0x0)
    FIELD(GLOBAL_CNTRL, MB_SLEEP, 16, 1)
    FIELD(GLOBAL_CNTRL, WRITE_QOS, 12, 4)
    FIELD(GLOBAL_CNTRL, READ_QOS, 8, 4)
    FIELD(GLOBAL_CNTRL, FW_IS_PRESENT, 4, 1)
    FIELD(GLOBAL_CNTRL, COHERENT, 2, 1)
    FIELD(GLOBAL_CNTRL, SLVERR_ENABLE, 1, 1)
    FIELD(GLOBAL_CNTRL, DONT_SLEEP, 0, 1)
REG32(PS_CNTRL, 0x4)
    FIELD(PS_CNTRL, PROG_GATE_STATUS, 16, 1)
    FIELD(PS_CNTRL, PROG_ENABLE, 1, 1)
    FIELD(PS_CNTRL, PROG_GATE, 0, 1)
REG32(APU_PWR_STATUS_INIT, 0x8)
    FIELD(APU_PWR_STATUS_INIT, ACPU3, 3, 1)
    FIELD(APU_PWR_STATUS_INIT, ACPU2, 2, 1)
    FIELD(APU_PWR_STATUS_INIT, ACPU1, 1, 1)
    FIELD(APU_PWR_STATUS_INIT, ACPU0, 0, 1)
REG32(ADDR_ERROR_STATUS, 0x10)
    FIELD(ADDR_ERROR_STATUS, STATUS, 0, 1)
REG32(ADDR_ERROR_INT_MASK, 0x14)
    FIELD(ADDR_ERROR_INT_MASK, MASK, 0, 1)
REG32(ADDR_ERROR_INT_EN, 0x18)
    FIELD(ADDR_ERROR_INT_EN, ENABLE, 0, 1)
REG32(ADDR_ERROR_INT_DIS, 0x1c)
    FIELD(ADDR_ERROR_INT_DIS, DISABLE, 0, 1)
REG32(GLOBAL_GEN_STORAGE0, 0x30)
REG32(GLOBAL_GEN_STORAGE1, 0x34)
REG32(GLOBAL_GEN_STORAGE2, 0x38)
REG32(GLOBAL_GEN_STORAGE3, 0x3c)
REG32(GLOBAL_GEN_STORAGE4, 0x40)
REG32(GLOBAL_GEN_STORAGE5, 0x44)
REG32(GLOBAL_GEN_STORAGE6, 0x48)
REG32(PERS_GLOB_GEN_STORAGE0, 0x50)
REG32(PERS_GLOB_GEN_STORAGE1, 0x54)
REG32(PERS_GLOB_GEN_STORAGE2, 0x58)
REG32(PERS_GLOB_GEN_STORAGE3, 0x5c)
REG32(PERS_GLOB_GEN_STORAGE4, 0x60)
REG32(PERS_GLOB_GEN_STORAGE5, 0x64)
REG32(PERS_GLOB_GEN_STORAGE6, 0x68)
REG32(PERS_GLOB_GEN_STORAGE7, 0x6c)
REG32(DDR_CNTRL, 0x70)
    FIELD(DDR_CNTRL, RET, 0, 1)
REG32(PWR_STATE, 0x100)
    FIELD(PWR_STATE, PL, 23, 1)
    FIELD(PWR_STATE, FP, 22, 1)
    FIELD(PWR_STATE, USB1, 21, 1)
    FIELD(PWR_STATE, USB0, 20, 1)
    FIELD(PWR_STATE, OCM_BANK3, 19, 1)
    FIELD(PWR_STATE, OCM_BANK2, 18, 1)
    FIELD(PWR_STATE, OCM_BANK1, 17, 1)
    FIELD(PWR_STATE, OCM_BANK0, 16, 1)
    FIELD(PWR_STATE, TCM1B, 15, 1)
    FIELD(PWR_STATE, TCM1A, 14, 1)
    FIELD(PWR_STATE, TCM0B, 13, 1)
    FIELD(PWR_STATE, TCM0A, 12, 1)
    FIELD(PWR_STATE, R5_1, 11, 1)
    FIELD(PWR_STATE, R5_0, 10, 1)
    FIELD(PWR_STATE, L2_BANK0, 7, 1)
    FIELD(PWR_STATE, PP1, 5, 1)
    FIELD(PWR_STATE, PP0, 4, 1)
    FIELD(PWR_STATE, ACPU3, 3, 1)
    FIELD(PWR_STATE, ACPU2, 2, 1)
    FIELD(PWR_STATE, ACPU1, 1, 1)
    FIELD(PWR_STATE, ACPU0, 0, 1)
REG32(AUX_PWR_STATE, 0x104)
    FIELD(AUX_PWR_STATE, ACPU3_EMULATION, 31, 1)
    FIELD(AUX_PWR_STATE, ACPU2_EMULATION, 30, 1)
    FIELD(AUX_PWR_STATE, ACPU1_EMULATION, 29, 1)
    FIELD(AUX_PWR_STATE, ACPU0_EMULATION, 28, 1)
    FIELD(AUX_PWR_STATE, RPU_EMULATION, 27, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK3, 19, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK2, 18, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK1, 17, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK0, 16, 1)
    FIELD(AUX_PWR_STATE, TCM1B, 15, 1)
    FIELD(AUX_PWR_STATE, TCM1A, 14, 1)
    FIELD(AUX_PWR_STATE, TCM0B, 13, 1)
    FIELD(AUX_PWR_STATE, TCM0A, 12, 1)
    FIELD(AUX_PWR_STATE, L2_BANK0, 7, 1)
REG32(RAM_RET_CNTRL, 0x108)
    FIELD(RAM_RET_CNTRL, OCM_BANK3, 19, 1)
    FIELD(RAM_RET_CNTRL, OCM_BANK2, 18, 1)
    FIELD(RAM_RET_CNTRL, OCM_BANK1, 17, 1)
    FIELD(RAM_RET_CNTRL, OCM_BANK0, 16, 1)
    FIELD(RAM_RET_CNTRL, TCM1B, 15, 1)
    FIELD(RAM_RET_CNTRL, TCM1A, 14, 1)
    FIELD(RAM_RET_CNTRL, TCM0B, 13, 1)
    FIELD(RAM_RET_CNTRL, TCM0A, 12, 1)
    FIELD(RAM_RET_CNTRL, L2_BANK0, 7, 1)
REG32(PWR_SUPPLY_STATUS, 0x10c)
    FIELD(PWR_SUPPLY_STATUS, VCC_PSAUX, 2, 1)
    FIELD(PWR_SUPPLY_STATUS, VCC_INT, 1, 1)
    FIELD(PWR_SUPPLY_STATUS, VCC_PSINTFP, 0, 1)
REG32(REQ_PWRUP_STATUS, 0x110)
    FIELD(REQ_PWRUP_STATUS, PL, 23, 1)
    FIELD(REQ_PWRUP_STATUS, FP, 22, 1)
    FIELD(REQ_PWRUP_STATUS, USB1, 21, 1)
    FIELD(REQ_PWRUP_STATUS, USB0, 20, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_STATUS, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_STATUS, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_STATUS, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_STATUS, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_STATUS, RPU, 10, 1)
    FIELD(REQ_PWRUP_STATUS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_STATUS, PP1, 5, 1)
    FIELD(REQ_PWRUP_STATUS, PP0, 4, 1)
    FIELD(REQ_PWRUP_STATUS, ACPU3, 3, 1)
    FIELD(REQ_PWRUP_STATUS, ACPU2, 2, 1)
    FIELD(REQ_PWRUP_STATUS, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_STATUS, ACPU0, 0, 1)
REG32(REQ_PWRUP_INT_MASK, 0x114)
    FIELD(REQ_PWRUP_INT_MASK, PL, 23, 1)
    FIELD(REQ_PWRUP_INT_MASK, FP, 22, 1)
    FIELD(REQ_PWRUP_INT_MASK, USB1, 21, 1)
    FIELD(REQ_PWRUP_INT_MASK, USB0, 20, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_INT_MASK, RPU, 10, 1)
    FIELD(REQ_PWRUP_INT_MASK, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_INT_MASK, PP1, 5, 1)
    FIELD(REQ_PWRUP_INT_MASK, PP0, 4, 1)
    FIELD(REQ_PWRUP_INT_MASK, ACPU3, 3, 1)
    FIELD(REQ_PWRUP_INT_MASK, ACPU2, 2, 1)
    FIELD(REQ_PWRUP_INT_MASK, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_INT_MASK, ACPU0, 0, 1)
REG32(REQ_PWRUP_INT_EN, 0x118)
    FIELD(REQ_PWRUP_INT_EN, PL, 23, 1)
    FIELD(REQ_PWRUP_INT_EN, FP, 22, 1)
    FIELD(REQ_PWRUP_INT_EN, USB1, 21, 1)
    FIELD(REQ_PWRUP_INT_EN, USB0, 20, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_INT_EN, RPU, 10, 1)
    FIELD(REQ_PWRUP_INT_EN, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_INT_EN, PP1, 5, 1)
    FIELD(REQ_PWRUP_INT_EN, PP0, 4, 1)
    FIELD(REQ_PWRUP_INT_EN, ACPU3, 3, 1)
    FIELD(REQ_PWRUP_INT_EN, ACPU2, 2, 1)
    FIELD(REQ_PWRUP_INT_EN, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_INT_EN, ACPU0, 0, 1)
REG32(REQ_PWRUP_INT_DIS, 0x11c)
    FIELD(REQ_PWRUP_INT_DIS, PL, 23, 1)
    FIELD(REQ_PWRUP_INT_DIS, FP, 22, 1)
    FIELD(REQ_PWRUP_INT_DIS, USB1, 21, 1)
    FIELD(REQ_PWRUP_INT_DIS, USB0, 20, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_INT_DIS, RPU, 10, 1)
    FIELD(REQ_PWRUP_INT_DIS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_INT_DIS, PP1, 5, 1)
    FIELD(REQ_PWRUP_INT_DIS, PP0, 4, 1)
    FIELD(REQ_PWRUP_INT_DIS, ACPU3, 3, 1)
    FIELD(REQ_PWRUP_INT_DIS, ACPU2, 2, 1)
    FIELD(REQ_PWRUP_INT_DIS, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_INT_DIS, ACPU0, 0, 1)
REG32(REQ_PWRUP_TRIG, 0x120)
    FIELD(REQ_PWRUP_TRIG, PL, 23, 1)
    FIELD(REQ_PWRUP_TRIG, FP, 22, 1)
    FIELD(REQ_PWRUP_TRIG, USB1, 21, 1)
    FIELD(REQ_PWRUP_TRIG, USB0, 20, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_TRIG, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_TRIG, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_TRIG, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_TRIG, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_TRIG, RPU, 10, 1)
    FIELD(REQ_PWRUP_TRIG, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_TRIG, PP1, 5, 1)
    FIELD(REQ_PWRUP_TRIG, PP0, 4, 1)
    FIELD(REQ_PWRUP_TRIG, ACPU3, 3, 1)
    FIELD(REQ_PWRUP_TRIG, ACPU2, 2, 1)
    FIELD(REQ_PWRUP_TRIG, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_TRIG, ACPU0, 0, 1)
REG32(REQ_PWRDWN_STATUS, 0x210)
    FIELD(REQ_PWRDWN_STATUS, PL, 23, 1)
    FIELD(REQ_PWRDWN_STATUS, FP, 22, 1)
    FIELD(REQ_PWRDWN_STATUS, USB1, 21, 1)
    FIELD(REQ_PWRDWN_STATUS, USB0, 20, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_STATUS, RPU, 10, 1)
    FIELD(REQ_PWRDWN_STATUS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_STATUS, PP1, 5, 1)
    FIELD(REQ_PWRDWN_STATUS, PP0, 4, 1)
    FIELD(REQ_PWRDWN_STATUS, ACPU3, 3, 1)
    FIELD(REQ_PWRDWN_STATUS, ACPU2, 2, 1)
    FIELD(REQ_PWRDWN_STATUS, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_STATUS, ACPU0, 0, 1)
REG32(REQ_PWRDWN_INT_MASK, 0x214)
    FIELD(REQ_PWRDWN_INT_MASK, PL, 23, 1)
    FIELD(REQ_PWRDWN_INT_MASK, FP, 22, 1)
    FIELD(REQ_PWRDWN_INT_MASK, USB1, 21, 1)
    FIELD(REQ_PWRDWN_INT_MASK, USB0, 20, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_INT_MASK, RPU, 10, 1)
    FIELD(REQ_PWRDWN_INT_MASK, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_INT_MASK, PP1, 5, 1)
    FIELD(REQ_PWRDWN_INT_MASK, PP0, 4, 1)
    FIELD(REQ_PWRDWN_INT_MASK, ACPU3, 3, 1)
    FIELD(REQ_PWRDWN_INT_MASK, ACPU2, 2, 1)
    FIELD(REQ_PWRDWN_INT_MASK, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_INT_MASK, ACPU0, 0, 1)
REG32(REQ_PWRDWN_INT_EN, 0x218)
    FIELD(REQ_PWRDWN_INT_EN, PL, 23, 1)
    FIELD(REQ_PWRDWN_INT_EN, FP, 22, 1)
    FIELD(REQ_PWRDWN_INT_EN, USB1, 21, 1)
    FIELD(REQ_PWRDWN_INT_EN, USB0, 20, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_INT_EN, RPU, 10, 1)
    FIELD(REQ_PWRDWN_INT_EN, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_INT_EN, PP1, 5, 1)
    FIELD(REQ_PWRDWN_INT_EN, PP0, 4, 1)
    FIELD(REQ_PWRDWN_INT_EN, ACPU3, 3, 1)
    FIELD(REQ_PWRDWN_INT_EN, ACPU2, 2, 1)
    FIELD(REQ_PWRDWN_INT_EN, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_INT_EN, ACPU0, 0, 1)
REG32(REQ_PWRDWN_INT_DIS, 0x21c)
    FIELD(REQ_PWRDWN_INT_DIS, PL, 23, 1)
    FIELD(REQ_PWRDWN_INT_DIS, FP, 22, 1)
    FIELD(REQ_PWRDWN_INT_DIS, USB1, 21, 1)
    FIELD(REQ_PWRDWN_INT_DIS, USB0, 20, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_INT_DIS, RPU, 10, 1)
    FIELD(REQ_PWRDWN_INT_DIS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_INT_DIS, PP1, 5, 1)
    FIELD(REQ_PWRDWN_INT_DIS, PP0, 4, 1)
    FIELD(REQ_PWRDWN_INT_DIS, ACPU3, 3, 1)
    FIELD(REQ_PWRDWN_INT_DIS, ACPU2, 2, 1)
    FIELD(REQ_PWRDWN_INT_DIS, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_INT_DIS, ACPU0, 0, 1)
REG32(REQ_PWRDWN_TRIG, 0x220)
    FIELD(REQ_PWRDWN_TRIG, PL, 23, 1)
    FIELD(REQ_PWRDWN_TRIG, FP, 22, 1)
    FIELD(REQ_PWRDWN_TRIG, USB1, 21, 1)
    FIELD(REQ_PWRDWN_TRIG, USB0, 20, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_TRIG, RPU, 10, 1)
    FIELD(REQ_PWRDWN_TRIG, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_TRIG, PP1, 5, 1)
    FIELD(REQ_PWRDWN_TRIG, PP0, 4, 1)
    FIELD(REQ_PWRDWN_TRIG, ACPU3, 3, 1)
    FIELD(REQ_PWRDWN_TRIG, ACPU2, 2, 1)
    FIELD(REQ_PWRDWN_TRIG, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_TRIG, ACPU0, 0, 1)
REG32(REQ_ISO_STATUS, 0x310)
    FIELD(REQ_ISO_STATUS, FP_LOCKED, 4, 1)
    FIELD(REQ_ISO_STATUS, PL_NONPCAP, 2, 1)
    FIELD(REQ_ISO_STATUS, PL, 1, 1)
    FIELD(REQ_ISO_STATUS, FP, 0, 1)
REG32(REQ_ISO_INT_MASK, 0x314)
    FIELD(REQ_ISO_INT_MASK, FP_LOCKED, 4, 1)
    FIELD(REQ_ISO_INT_MASK, PL_NONPCAP, 2, 1)
    FIELD(REQ_ISO_INT_MASK, PL, 1, 1)
    FIELD(REQ_ISO_INT_MASK, FP, 0, 1)
REG32(REQ_ISO_INT_EN, 0x318)
    FIELD(REQ_ISO_INT_EN, FP_LOCKED, 4, 1)
    FIELD(REQ_ISO_INT_EN, PL_NONPCAP, 2, 1)
    FIELD(REQ_ISO_INT_EN, PL, 1, 1)
    FIELD(REQ_ISO_INT_EN, FP, 0, 1)
REG32(REQ_ISO_INT_DIS, 0x31c)
    FIELD(REQ_ISO_INT_DIS, FP_LOCKED, 4, 1)
    FIELD(REQ_ISO_INT_DIS, PL_NONPCAP, 2, 1)
    FIELD(REQ_ISO_INT_DIS, PL, 1, 1)
    FIELD(REQ_ISO_INT_DIS, FP, 0, 1)
REG32(REQ_ISO_TRIG, 0x320)
    FIELD(REQ_ISO_TRIG, FP_LOCKED, 4, 1)
    FIELD(REQ_ISO_TRIG, PL_NONPCAP, 2, 1)
    FIELD(REQ_ISO_TRIG, PL, 1, 1)
    FIELD(REQ_ISO_TRIG, FP, 0, 1)
REG32(REQ_SWRST_STATUS, 0x410)
    FIELD(REQ_SWRST_STATUS, PL, 31, 1)
    FIELD(REQ_SWRST_STATUS, FP, 30, 1)
    FIELD(REQ_SWRST_STATUS, LP, 29, 1)
    FIELD(REQ_SWRST_STATUS, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_STATUS, IOU, 27, 1)
    FIELD(REQ_SWRST_STATUS, USB1, 25, 1)
    FIELD(REQ_SWRST_STATUS, USB0, 24, 1)
    FIELD(REQ_SWRST_STATUS, GEM3, 23, 1)
    FIELD(REQ_SWRST_STATUS, GEM2, 22, 1)
    FIELD(REQ_SWRST_STATUS, GEM1, 21, 1)
    FIELD(REQ_SWRST_STATUS, GEM0, 20, 1)
    FIELD(REQ_SWRST_STATUS, RPU, 18, 1)
    FIELD(REQ_SWRST_STATUS, R5_1, 17, 1)
    FIELD(REQ_SWRST_STATUS, R5_0, 16, 1)
    FIELD(REQ_SWRST_STATUS, DISPLAY_PORT, 12, 1)
    FIELD(REQ_SWRST_STATUS, SATA, 10, 1)
    FIELD(REQ_SWRST_STATUS, PCIE, 9, 1)
    FIELD(REQ_SWRST_STATUS, GPU, 8, 1)
    FIELD(REQ_SWRST_STATUS, PP1, 7, 1)
    FIELD(REQ_SWRST_STATUS, PP0, 6, 1)
    FIELD(REQ_SWRST_STATUS, APU, 4, 1)
    FIELD(REQ_SWRST_STATUS, ACPU3, 3, 1)
    FIELD(REQ_SWRST_STATUS, ACPU2, 2, 1)
    FIELD(REQ_SWRST_STATUS, ACPU1, 1, 1)
    FIELD(REQ_SWRST_STATUS, ACPU0, 0, 1)
REG32(REQ_SWRST_INT_MASK, 0x414)
    FIELD(REQ_SWRST_INT_MASK, PL, 31, 1)
    FIELD(REQ_SWRST_INT_MASK, FP, 30, 1)
    FIELD(REQ_SWRST_INT_MASK, LP, 29, 1)
    FIELD(REQ_SWRST_INT_MASK, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_INT_MASK, IOU, 27, 1)
    FIELD(REQ_SWRST_INT_MASK, USB1, 25, 1)
    FIELD(REQ_SWRST_INT_MASK, USB0, 24, 1)
    FIELD(REQ_SWRST_INT_MASK, GEM3, 23, 1)
    FIELD(REQ_SWRST_INT_MASK, GEM2, 22, 1)
    FIELD(REQ_SWRST_INT_MASK, GEM1, 21, 1)
    FIELD(REQ_SWRST_INT_MASK, GEM0, 20, 1)
    FIELD(REQ_SWRST_INT_MASK, LS_R5, 18, 1)
    FIELD(REQ_SWRST_INT_MASK, R5_1, 17, 1)
    FIELD(REQ_SWRST_INT_MASK, R5_0, 16, 1)
    FIELD(REQ_SWRST_INT_MASK, DISPLAY_PORT, 12, 1)
    FIELD(REQ_SWRST_INT_MASK, SATA, 10, 1)
    FIELD(REQ_SWRST_INT_MASK, PCIE, 9, 1)
    FIELD(REQ_SWRST_INT_MASK, GPU, 8, 1)
    FIELD(REQ_SWRST_INT_MASK, PP1, 7, 1)
    FIELD(REQ_SWRST_INT_MASK, PP0, 6, 1)
    FIELD(REQ_SWRST_INT_MASK, APU, 4, 1)
    FIELD(REQ_SWRST_INT_MASK, ACPU3, 3, 1)
    FIELD(REQ_SWRST_INT_MASK, ACPU2, 2, 1)
    FIELD(REQ_SWRST_INT_MASK, ACPU1, 1, 1)
    FIELD(REQ_SWRST_INT_MASK, ACPU0, 0, 1)
REG32(REQ_SWRST_INT_EN, 0x418)
    FIELD(REQ_SWRST_INT_EN, PL, 31, 1)
    FIELD(REQ_SWRST_INT_EN, FP, 30, 1)
    FIELD(REQ_SWRST_INT_EN, LP, 29, 1)
    FIELD(REQ_SWRST_INT_EN, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_INT_EN, IOU, 27, 1)
    FIELD(REQ_SWRST_INT_EN, USB1, 25, 1)
    FIELD(REQ_SWRST_INT_EN, USB0, 24, 1)
    FIELD(REQ_SWRST_INT_EN, GEM3, 23, 1)
    FIELD(REQ_SWRST_INT_EN, GEM2, 22, 1)
    FIELD(REQ_SWRST_INT_EN, GEM1, 21, 1)
    FIELD(REQ_SWRST_INT_EN, GEM0, 20, 1)
    FIELD(REQ_SWRST_INT_EN, LS_R5, 18, 1)
    FIELD(REQ_SWRST_INT_EN, R5_1, 17, 1)
    FIELD(REQ_SWRST_INT_EN, R5_0, 16, 1)
    FIELD(REQ_SWRST_INT_EN, DISPLAY_PORT, 12, 1)
    FIELD(REQ_SWRST_INT_EN, SATA, 10, 1)
    FIELD(REQ_SWRST_INT_EN, PCIE, 9, 1)
    FIELD(REQ_SWRST_INT_EN, GPU, 8, 1)
    FIELD(REQ_SWRST_INT_EN, PP1, 7, 1)
    FIELD(REQ_SWRST_INT_EN, PP0, 6, 1)
    FIELD(REQ_SWRST_INT_EN, APU, 4, 1)
    FIELD(REQ_SWRST_INT_EN, ACPU3, 3, 1)
    FIELD(REQ_SWRST_INT_EN, ACPU2, 2, 1)
    FIELD(REQ_SWRST_INT_EN, ACPU1, 1, 1)
    FIELD(REQ_SWRST_INT_EN, ACPU0, 0, 1)
REG32(REQ_SWRST_INT_DIS, 0x41c)
    FIELD(REQ_SWRST_INT_DIS, PL, 31, 1)
    FIELD(REQ_SWRST_INT_DIS, FP, 30, 1)
    FIELD(REQ_SWRST_INT_DIS, LP, 29, 1)
    FIELD(REQ_SWRST_INT_DIS, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_INT_DIS, IOU, 27, 1)
    FIELD(REQ_SWRST_INT_DIS, USB1, 25, 1)
    FIELD(REQ_SWRST_INT_DIS, USB0, 24, 1)
    FIELD(REQ_SWRST_INT_DIS, GEM3, 23, 1)
    FIELD(REQ_SWRST_INT_DIS, GEM2, 22, 1)
    FIELD(REQ_SWRST_INT_DIS, GEM1, 21, 1)
    FIELD(REQ_SWRST_INT_DIS, GEM0, 20, 1)
    FIELD(REQ_SWRST_INT_DIS, LS_R5, 18, 1)
    FIELD(REQ_SWRST_INT_DIS, R5_1, 17, 1)
    FIELD(REQ_SWRST_INT_DIS, R5_0, 16, 1)
    FIELD(REQ_SWRST_INT_DIS, DISPLAY_PORT, 12, 1)
    FIELD(REQ_SWRST_INT_DIS, SATA, 10, 1)
    FIELD(REQ_SWRST_INT_DIS, PCIE, 9, 1)
    FIELD(REQ_SWRST_INT_DIS, GPU, 8, 1)
    FIELD(REQ_SWRST_INT_DIS, PP1, 7, 1)
    FIELD(REQ_SWRST_INT_DIS, PP0, 6, 1)
    FIELD(REQ_SWRST_INT_DIS, APU, 4, 1)
    FIELD(REQ_SWRST_INT_DIS, ACPU3, 3, 1)
    FIELD(REQ_SWRST_INT_DIS, ACPU2, 2, 1)
    FIELD(REQ_SWRST_INT_DIS, ACPU1, 1, 1)
    FIELD(REQ_SWRST_INT_DIS, ACPU0, 0, 1)
REG32(REQ_SWRST_TRIG, 0x420)
    FIELD(REQ_SWRST_TRIG, PL, 31, 1)
    FIELD(REQ_SWRST_TRIG, FP, 30, 1)
    FIELD(REQ_SWRST_TRIG, LP, 29, 1)
    FIELD(REQ_SWRST_TRIG, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_TRIG, IOU, 27, 1)
    FIELD(REQ_SWRST_TRIG, USB1, 25, 1)
    FIELD(REQ_SWRST_TRIG, USB0, 24, 1)
    FIELD(REQ_SWRST_TRIG, GEM3, 23, 1)
    FIELD(REQ_SWRST_TRIG, GEM2, 22, 1)
    FIELD(REQ_SWRST_TRIG, GEM1, 21, 1)
    FIELD(REQ_SWRST_TRIG, GEM0, 20, 1)
    FIELD(REQ_SWRST_TRIG, LS_R5, 18, 1)
    FIELD(REQ_SWRST_TRIG, R5_1, 17, 1)
    FIELD(REQ_SWRST_TRIG, R5_0, 16, 1)
    FIELD(REQ_SWRST_TRIG, DISPLAY_PORT, 12, 1)
    FIELD(REQ_SWRST_TRIG, SATA, 10, 1)
    FIELD(REQ_SWRST_TRIG, PCIE, 9, 1)
    FIELD(REQ_SWRST_TRIG, GPU, 8, 1)
    FIELD(REQ_SWRST_TRIG, PP1, 7, 1)
    FIELD(REQ_SWRST_TRIG, PP0, 6, 1)
    FIELD(REQ_SWRST_TRIG, APU, 4, 1)
    FIELD(REQ_SWRST_TRIG, ACPU3, 3, 1)
    FIELD(REQ_SWRST_TRIG, ACPU2, 2, 1)
    FIELD(REQ_SWRST_TRIG, ACPU1, 1, 1)
    FIELD(REQ_SWRST_TRIG, ACPU0, 0, 1)
REG32(REQ_AUX_STATUS, 0x510)
    FIELD(REQ_AUX_STATUS, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_INT_MASK, 0x514)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_INT_EN, 0x518)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_INT_DIS, 0x51c)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_TRIG, 0x520)
    FIELD(REQ_AUX_TRIG, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_0, 0, 1)
REG32(LOGCLR_STATUS, 0x524)
    FIELD(LOGCLR_STATUS, FP, 17, 1)
    FIELD(LOGCLR_STATUS, LP, 16, 1)
    FIELD(LOGCLR_STATUS, USB1, 13, 1)
    FIELD(LOGCLR_STATUS, USB0, 12, 1)
    FIELD(LOGCLR_STATUS, RPU, 10, 1)
    FIELD(LOGCLR_STATUS, PP1, 7, 1)
    FIELD(LOGCLR_STATUS, PP0, 6, 1)
    FIELD(LOGCLR_STATUS, ACPU3, 3, 1)
    FIELD(LOGCLR_STATUS, ACPU2, 2, 1)
    FIELD(LOGCLR_STATUS, ACPU1, 1, 1)
    FIELD(LOGCLR_STATUS, ACPU0, 0, 1)
REG32(CSU_BR_ERROR, 0x528)
    FIELD(CSU_BR_ERROR, BR_ERROR, 31, 1)
    FIELD(CSU_BR_ERROR, ERR_TYPE, 0, 16)
REG32(MB_FAULT_STATUS, 0x52c)
    FIELD(MB_FAULT_STATUS, R_FFAIL, 24, 8)
    FIELD(MB_FAULT_STATUS, R_SLEEP_RST, 19, 1)
    FIELD(MB_FAULT_STATUS, R_LSFAIL, 16, 3)
    FIELD(MB_FAULT_STATUS, N_FFAIL, 8, 8)
    FIELD(MB_FAULT_STATUS, N_SLEEP_RST, 3, 1)
    FIELD(MB_FAULT_STATUS, N_LSFAIL, 0, 3)
REG32(ERROR_STATUS_1, 0x530)
    FIELD(ERROR_STATUS_1, AUX3, 31, 1)
    FIELD(ERROR_STATUS_1, AUX2, 30, 1)
    FIELD(ERROR_STATUS_1, AUX1, 29, 1)
    FIELD(ERROR_STATUS_1, AUX0, 28, 1)
    FIELD(ERROR_STATUS_1, DFT, 27, 1)
    FIELD(ERROR_STATUS_1, CLK_MON, 26, 1)
    FIELD(ERROR_STATUS_1, XMPU, 24, 2)
    FIELD(ERROR_STATUS_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_STATUS_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_STATUS_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_STATUS_1, RPU_CCF, 9, 1)
    FIELD(ERROR_STATUS_1, RPU_LS, 6, 2)
    FIELD(ERROR_STATUS_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_STATUS_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_STATUS_1, RPU1, 3, 1)
    FIELD(ERROR_STATUS_1, RPU0, 2, 1)
    FIELD(ERROR_STATUS_1, OCM_ECC, 1, 1)
    FIELD(ERROR_STATUS_1, DDR_ECC, 0, 1)
REG32(ERROR_INT_MASK_1, 0x534)
    FIELD(ERROR_INT_MASK_1, AUX3, 31, 1)
    FIELD(ERROR_INT_MASK_1, AUX2, 30, 1)
    FIELD(ERROR_INT_MASK_1, AUX1, 29, 1)
    FIELD(ERROR_INT_MASK_1, AUX0, 28, 1)
    FIELD(ERROR_INT_MASK_1, DFT, 27, 1)
    FIELD(ERROR_INT_MASK_1, CLK_MON, 26, 1)
    FIELD(ERROR_INT_MASK_1, XMPU, 24, 2)
    FIELD(ERROR_INT_MASK_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_INT_MASK_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_INT_MASK_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_INT_MASK_1, RPU_CCF, 9, 1)
    FIELD(ERROR_INT_MASK_1, RPU_LS, 6, 2)
    FIELD(ERROR_INT_MASK_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_INT_MASK_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_INT_MASK_1, RPU1, 3, 1)
    FIELD(ERROR_INT_MASK_1, RPU0, 2, 1)
    FIELD(ERROR_INT_MASK_1, OCM_ECC, 1, 1)
    FIELD(ERROR_INT_MASK_1, DDR_ECC, 0, 1)
REG32(ERROR_INT_EN_1, 0x538)
    FIELD(ERROR_INT_EN_1, AUX3, 31, 1)
    FIELD(ERROR_INT_EN_1, AUX2, 30, 1)
    FIELD(ERROR_INT_EN_1, AUX1, 29, 1)
    FIELD(ERROR_INT_EN_1, AUX0, 28, 1)
    FIELD(ERROR_INT_EN_1, DFT, 27, 1)
    FIELD(ERROR_INT_EN_1, CLK_MON, 26, 1)
    FIELD(ERROR_INT_EN_1, XMPU, 24, 2)
    FIELD(ERROR_INT_EN_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_INT_EN_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_INT_EN_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_INT_EN_1, RPU_CCF, 9, 1)
    FIELD(ERROR_INT_EN_1, RPU_LS, 6, 2)
    FIELD(ERROR_INT_EN_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_INT_EN_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_INT_EN_1, RPU1, 3, 1)
    FIELD(ERROR_INT_EN_1, RPU0, 2, 1)
    FIELD(ERROR_INT_EN_1, OCM_ECC, 1, 1)
    FIELD(ERROR_INT_EN_1, DDR_ECC, 0, 1)
REG32(ERROR_INT_DIS_1, 0x53c)
    FIELD(ERROR_INT_DIS_1, AUX3, 31, 1)
    FIELD(ERROR_INT_DIS_1, AUX2, 30, 1)
    FIELD(ERROR_INT_DIS_1, AUX1, 29, 1)
    FIELD(ERROR_INT_DIS_1, AUX0, 28, 1)
    FIELD(ERROR_INT_DIS_1, DFT, 27, 1)
    FIELD(ERROR_INT_DIS_1, CLK_MON, 26, 1)
    FIELD(ERROR_INT_DIS_1, XMPU, 24, 2)
    FIELD(ERROR_INT_DIS_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_INT_DIS_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_INT_DIS_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_INT_DIS_1, RPU_CCF, 9, 1)
    FIELD(ERROR_INT_DIS_1, RPU_LS, 6, 2)
    FIELD(ERROR_INT_DIS_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_INT_DIS_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_INT_DIS_1, RPU1, 3, 1)
    FIELD(ERROR_INT_DIS_1, RPU0, 2, 1)
    FIELD(ERROR_INT_DIS_1, OCM_ECC, 1, 1)
    FIELD(ERROR_INT_DIS_1, DDR_ECC, 0, 1)
REG32(ERROR_STATUS_2, 0x540)
    FIELD(ERROR_STATUS_2, CSU_ROM, 26, 1)
    FIELD(ERROR_STATUS_2, PMU_PB, 25, 1)
    FIELD(ERROR_STATUS_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_STATUS_2, PMU_FW, 18, 4)
    FIELD(ERROR_STATUS_2, PMU_UC, 17, 1)
    FIELD(ERROR_STATUS_2, CSU, 16, 1)
    FIELD(ERROR_STATUS_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_STATUS_2, PL, 2, 4)
    FIELD(ERROR_STATUS_2, TO, 0, 2)
REG32(ERROR_INT_MASK_2, 0x544)
    FIELD(ERROR_INT_MASK_2, CSU_ROM, 26, 1)
    FIELD(ERROR_INT_MASK_2, PMU_PB, 25, 1)
    FIELD(ERROR_INT_MASK_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_INT_MASK_2, PMU_FW, 18, 4)
    FIELD(ERROR_INT_MASK_2, PMU_UC, 17, 1)
    FIELD(ERROR_INT_MASK_2, CSU, 16, 1)
    FIELD(ERROR_INT_MASK_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_INT_MASK_2, PL, 2, 4)
    FIELD(ERROR_INT_MASK_2, TO, 0, 2)
REG32(ERROR_INT_EN_2, 0x548)
    FIELD(ERROR_INT_EN_2, CSU_ROM, 26, 1)
    FIELD(ERROR_INT_EN_2, PMU_PB, 25, 1)
    FIELD(ERROR_INT_EN_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_INT_EN_2, PMU_FW, 18, 4)
    FIELD(ERROR_INT_EN_2, PMU_UC, 17, 1)
    FIELD(ERROR_INT_EN_2, CSU, 16, 1)
    FIELD(ERROR_INT_EN_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_INT_EN_2, PL, 2, 4)
    FIELD(ERROR_INT_EN_2, TO, 0, 2)
REG32(ERROR_INT_DIS_2, 0x54c)
    FIELD(ERROR_INT_DIS_2, CSU_ROM, 26, 1)
    FIELD(ERROR_INT_DIS_2, PMU_PB, 25, 1)
    FIELD(ERROR_INT_DIS_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_INT_DIS_2, PMU_FW, 18, 4)
    FIELD(ERROR_INT_DIS_2, PMU_UC, 17, 1)
    FIELD(ERROR_INT_DIS_2, CSU, 16, 1)
    FIELD(ERROR_INT_DIS_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_INT_DIS_2, PL, 2, 4)
    FIELD(ERROR_INT_DIS_2, TO, 0, 2)
REG32(ERROR_POR_MASK_1, 0x550)
    FIELD(ERROR_POR_MASK_1, AUX3, 31, 1)
    FIELD(ERROR_POR_MASK_1, AUX2, 30, 1)
    FIELD(ERROR_POR_MASK_1, AUX1, 29, 1)
    FIELD(ERROR_POR_MASK_1, AUX0, 28, 1)
    FIELD(ERROR_POR_MASK_1, DFT, 27, 1)
    FIELD(ERROR_POR_MASK_1, CLK_MON, 26, 1)
    FIELD(ERROR_POR_MASK_1, XMPU, 24, 2)
    FIELD(ERROR_POR_MASK_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_POR_MASK_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_POR_MASK_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_POR_MASK_1, RPU_CCF, 9, 1)
    FIELD(ERROR_POR_MASK_1, RPU_LS, 6, 2)
    FIELD(ERROR_POR_MASK_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_POR_MASK_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_POR_MASK_1, RPU1, 3, 1)
    FIELD(ERROR_POR_MASK_1, RPU0, 2, 1)
    FIELD(ERROR_POR_MASK_1, OCM_ECC, 1, 1)
    FIELD(ERROR_POR_MASK_1, DDR_ECC, 0, 1)
REG32(ERROR_POR_EN_1, 0x554)
    FIELD(ERROR_POR_EN_1, AUX3, 31, 1)
    FIELD(ERROR_POR_EN_1, AUX2, 30, 1)
    FIELD(ERROR_POR_EN_1, AUX1, 29, 1)
    FIELD(ERROR_POR_EN_1, AUX0, 28, 1)
    FIELD(ERROR_POR_EN_1, DFT, 27, 1)
    FIELD(ERROR_POR_EN_1, CLK_MON, 26, 1)
    FIELD(ERROR_POR_EN_1, XMPU, 24, 2)
    FIELD(ERROR_POR_EN_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_POR_EN_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_POR_EN_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_POR_EN_1, RPU_CCF, 9, 1)
    FIELD(ERROR_POR_EN_1, RPU_LS, 6, 2)
    FIELD(ERROR_POR_EN_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_POR_EN_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_POR_EN_1, RPU1, 3, 1)
    FIELD(ERROR_POR_EN_1, RPU0, 2, 1)
    FIELD(ERROR_POR_EN_1, OCM_ECC, 1, 1)
    FIELD(ERROR_POR_EN_1, DDR_ECC, 0, 1)
REG32(ERROR_POR_DIS_1, 0x558)
    FIELD(ERROR_POR_DIS_1, AUX3, 31, 1)
    FIELD(ERROR_POR_DIS_1, AUX2, 30, 1)
    FIELD(ERROR_POR_DIS_1, AUX1, 29, 1)
    FIELD(ERROR_POR_DIS_1, AUX0, 28, 1)
    FIELD(ERROR_POR_DIS_1, DFT, 27, 1)
    FIELD(ERROR_POR_DIS_1, CLK_MON, 26, 1)
    FIELD(ERROR_POR_DIS_1, XMPU, 24, 2)
    FIELD(ERROR_POR_DIS_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_POR_DIS_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_POR_DIS_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_POR_DIS_1, RPU_CCF, 9, 1)
    FIELD(ERROR_POR_DIS_1, RPU_LS, 6, 2)
    FIELD(ERROR_POR_DIS_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_POR_DIS_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_POR_DIS_1, RPU1, 3, 1)
    FIELD(ERROR_POR_DIS_1, RPU0, 2, 1)
    FIELD(ERROR_POR_DIS_1, OCM_ECC, 1, 1)
    FIELD(ERROR_POR_DIS_1, DDR_ECC, 0, 1)
REG32(ERROR_POR_MASK_2, 0x55c)
    FIELD(ERROR_POR_MASK_2, CSU_ROM, 26, 1)
    FIELD(ERROR_POR_MASK_2, PMU_PB, 25, 1)
    FIELD(ERROR_POR_MASK_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_POR_MASK_2, PMU_FW, 18, 4)
    FIELD(ERROR_POR_MASK_2, PMU_UC, 17, 1)
    FIELD(ERROR_POR_MASK_2, CSU, 16, 1)
    FIELD(ERROR_POR_MASK_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_POR_MASK_2, PL, 2, 4)
    FIELD(ERROR_POR_MASK_2, TO, 0, 2)
REG32(ERROR_POR_EN_2, 0x560)
    FIELD(ERROR_POR_EN_2, CSU_ROM, 26, 1)
    FIELD(ERROR_POR_EN_2, PMU_PB, 25, 1)
    FIELD(ERROR_POR_EN_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_POR_EN_2, PMU_FW, 18, 4)
    FIELD(ERROR_POR_EN_2, PMU_UC, 17, 1)
    FIELD(ERROR_POR_EN_2, CSU, 16, 1)
    FIELD(ERROR_POR_EN_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_POR_EN_2, PL, 2, 4)
    FIELD(ERROR_POR_EN_2, TO, 0, 2)
REG32(ERROR_POR_DIS_2, 0x564)
    FIELD(ERROR_POR_DIS_2, CSU_ROM, 26, 1)
    FIELD(ERROR_POR_DIS_2, PMU_PB, 25, 1)
    FIELD(ERROR_POR_DIS_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_POR_DIS_2, PMU_FW, 18, 4)
    FIELD(ERROR_POR_DIS_2, PMU_UC, 17, 1)
    FIELD(ERROR_POR_DIS_2, CSU, 16, 1)
    FIELD(ERROR_POR_DIS_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_POR_DIS_2, PL, 2, 4)
    FIELD(ERROR_POR_DIS_2, TO, 0, 2)
REG32(ERROR_SRST_MASK_1, 0x568)
    FIELD(ERROR_SRST_MASK_1, AUX3, 31, 1)
    FIELD(ERROR_SRST_MASK_1, AUX2, 30, 1)
    FIELD(ERROR_SRST_MASK_1, AUX1, 29, 1)
    FIELD(ERROR_SRST_MASK_1, AUX0, 28, 1)
    FIELD(ERROR_SRST_MASK_1, DFT, 27, 1)
    FIELD(ERROR_SRST_MASK_1, CLK_MON, 26, 1)
    FIELD(ERROR_SRST_MASK_1, XMPU, 24, 2)
    FIELD(ERROR_SRST_MASK_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_SRST_MASK_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_SRST_MASK_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_SRST_MASK_1, RPU_CCF, 9, 1)
    FIELD(ERROR_SRST_MASK_1, RPU_LS, 6, 2)
    FIELD(ERROR_SRST_MASK_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_SRST_MASK_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_SRST_MASK_1, RPU1, 3, 1)
    FIELD(ERROR_SRST_MASK_1, RPU0, 2, 1)
    FIELD(ERROR_SRST_MASK_1, OCM_ECC, 1, 1)
    FIELD(ERROR_SRST_MASK_1, DDR_ECC, 0, 1)
REG32(ERROR_SRST_EN_1, 0x56c)
    FIELD(ERROR_SRST_EN_1, AUX3, 31, 1)
    FIELD(ERROR_SRST_EN_1, AUX2, 30, 1)
    FIELD(ERROR_SRST_EN_1, AUX1, 29, 1)
    FIELD(ERROR_SRST_EN_1, AUX0, 28, 1)
    FIELD(ERROR_SRST_EN_1, DFT, 27, 1)
    FIELD(ERROR_SRST_EN_1, CLK_MON, 26, 1)
    FIELD(ERROR_SRST_EN_1, XMPU, 24, 2)
    FIELD(ERROR_SRST_EN_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_SRST_EN_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_SRST_EN_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_SRST_EN_1, RPU_CCF, 9, 1)
    FIELD(ERROR_SRST_EN_1, RPU_LS, 6, 2)
    FIELD(ERROR_SRST_EN_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_SRST_EN_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_SRST_EN_1, RPU1, 3, 1)
    FIELD(ERROR_SRST_EN_1, RPU0, 2, 1)
    FIELD(ERROR_SRST_EN_1, OCM_ECC, 1, 1)
    FIELD(ERROR_SRST_EN_1, DDR_ECC, 0, 1)
REG32(ERROR_SRST_DIS_1, 0x570)
    FIELD(ERROR_SRST_DIS_1, AUX3, 31, 1)
    FIELD(ERROR_SRST_DIS_1, AUX2, 30, 1)
    FIELD(ERROR_SRST_DIS_1, AUX1, 29, 1)
    FIELD(ERROR_SRST_DIS_1, AUX0, 28, 1)
    FIELD(ERROR_SRST_DIS_1, DFT, 27, 1)
    FIELD(ERROR_SRST_DIS_1, CLK_MON, 26, 1)
    FIELD(ERROR_SRST_DIS_1, XMPU, 24, 2)
    FIELD(ERROR_SRST_DIS_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_SRST_DIS_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_SRST_DIS_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_SRST_DIS_1, RPU_CCF, 9, 1)
    FIELD(ERROR_SRST_DIS_1, RPU_LS, 6, 2)
    FIELD(ERROR_SRST_DIS_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_SRST_DIS_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_SRST_DIS_1, RPU1, 3, 1)
    FIELD(ERROR_SRST_DIS_1, RPU0, 2, 1)
    FIELD(ERROR_SRST_DIS_1, OCM_ECC, 1, 1)
    FIELD(ERROR_SRST_DIS_1, DDR_ECC, 0, 1)
REG32(ERROR_SRST_MASK_2, 0x574)
    FIELD(ERROR_SRST_MASK_2, CSU_ROM, 26, 1)
    FIELD(ERROR_SRST_MASK_2, PMU_PB, 25, 1)
    FIELD(ERROR_SRST_MASK_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_SRST_MASK_2, PMU_FW, 18, 4)
    FIELD(ERROR_SRST_MASK_2, PMU_UC, 17, 1)
    FIELD(ERROR_SRST_MASK_2, CSU, 16, 1)
    FIELD(ERROR_SRST_MASK_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_SRST_MASK_2, PL, 2, 4)
    FIELD(ERROR_SRST_MASK_2, TO, 0, 2)
REG32(ERROR_SRST_EN_2, 0x578)
    FIELD(ERROR_SRST_EN_2, CSU_ROM, 26, 1)
    FIELD(ERROR_SRST_EN_2, PMU_PB, 25, 1)
    FIELD(ERROR_SRST_EN_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_SRST_EN_2, PMU_FW, 18, 4)
    FIELD(ERROR_SRST_EN_2, PMU_UC, 17, 1)
    FIELD(ERROR_SRST_EN_2, CSU, 16, 1)
    FIELD(ERROR_SRST_EN_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_SRST_EN_2, PL, 2, 4)
    FIELD(ERROR_SRST_EN_2, TO, 0, 2)
REG32(ERROR_SRST_DIS_2, 0x57c)
    FIELD(ERROR_SRST_DIS_2, CSU_ROM, 26, 1)
    FIELD(ERROR_SRST_DIS_2, PMU_PB, 25, 1)
    FIELD(ERROR_SRST_DIS_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_SRST_DIS_2, PMU_FW, 18, 4)
    FIELD(ERROR_SRST_DIS_2, PMU_UC, 17, 1)
    FIELD(ERROR_SRST_DIS_2, CSU, 16, 1)
    FIELD(ERROR_SRST_DIS_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_SRST_DIS_2, PL, 2, 4)
    FIELD(ERROR_SRST_DIS_2, TO, 0, 2)
REG32(ERROR_SIG_MASK_1, 0x580)
    FIELD(ERROR_SIG_MASK_1, AUX3, 31, 1)
    FIELD(ERROR_SIG_MASK_1, AUX2, 30, 1)
    FIELD(ERROR_SIG_MASK_1, AUX1, 29, 1)
    FIELD(ERROR_SIG_MASK_1, AUX0, 28, 1)
    FIELD(ERROR_SIG_MASK_1, DFT, 27, 1)
    FIELD(ERROR_SIG_MASK_1, CLK_MON, 26, 1)
    FIELD(ERROR_SIG_MASK_1, XMPU, 24, 2)
    FIELD(ERROR_SIG_MASK_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_SIG_MASK_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_SIG_MASK_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_SIG_MASK_1, RPU_CCF, 9, 1)
    FIELD(ERROR_SIG_MASK_1, RPU_LS, 6, 2)
    FIELD(ERROR_SIG_MASK_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_SIG_MASK_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_SIG_MASK_1, RPU1, 3, 1)
    FIELD(ERROR_SIG_MASK_1, RPU0, 2, 1)
    FIELD(ERROR_SIG_MASK_1, OCM_ECC, 1, 1)
    FIELD(ERROR_SIG_MASK_1, DDR_ECC, 0, 1)
REG32(ERROR_SIG_EN_1, 0x584)
    FIELD(ERROR_SIG_EN_1, AUX3, 31, 1)
    FIELD(ERROR_SIG_EN_1, AUX2, 30, 1)
    FIELD(ERROR_SIG_EN_1, AUX1, 29, 1)
    FIELD(ERROR_SIG_EN_1, AUX0, 28, 1)
    FIELD(ERROR_SIG_EN_1, DFT, 27, 1)
    FIELD(ERROR_SIG_EN_1, CLK_MON, 26, 1)
    FIELD(ERROR_SIG_EN_1, XMPU, 24, 2)
    FIELD(ERROR_SIG_EN_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_SIG_EN_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_SIG_EN_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_SIG_EN_1, RPU_CCF, 9, 1)
    FIELD(ERROR_SIG_EN_1, RPU_LS, 6, 2)
    FIELD(ERROR_SIG_EN_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_SIG_EN_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_SIG_EN_1, RPU1, 3, 1)
    FIELD(ERROR_SIG_EN_1, RPU0, 2, 1)
    FIELD(ERROR_SIG_EN_1, OCM_ECC, 1, 1)
    FIELD(ERROR_SIG_EN_1, DDR_ECC, 0, 1)
REG32(ERROR_SIG_DIS_1, 0x588)
    FIELD(ERROR_SIG_DIS_1, AUX3, 31, 1)
    FIELD(ERROR_SIG_DIS_1, AUX2, 30, 1)
    FIELD(ERROR_SIG_DIS_1, AUX1, 29, 1)
    FIELD(ERROR_SIG_DIS_1, AUX0, 28, 1)
    FIELD(ERROR_SIG_DIS_1, DFT, 27, 1)
    FIELD(ERROR_SIG_DIS_1, CLK_MON, 26, 1)
    FIELD(ERROR_SIG_DIS_1, XMPU, 24, 2)
    FIELD(ERROR_SIG_DIS_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_SIG_DIS_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_SIG_DIS_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_SIG_DIS_1, RPU_CCF, 9, 1)
    FIELD(ERROR_SIG_DIS_1, RPU_LS, 6, 2)
    FIELD(ERROR_SIG_DIS_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_SIG_DIS_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_SIG_DIS_1, RPU1, 3, 1)
    FIELD(ERROR_SIG_DIS_1, RPU0, 2, 1)
    FIELD(ERROR_SIG_DIS_1, OCM_ECC, 1, 1)
    FIELD(ERROR_SIG_DIS_1, DDR_ECC, 0, 1)
REG32(ERROR_SIG_MASK_2, 0x58c)
    FIELD(ERROR_SIG_MASK_2, CSU_ROM, 26, 1)
    FIELD(ERROR_SIG_MASK_2, PMU_PB, 25, 1)
    FIELD(ERROR_SIG_MASK_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_SIG_MASK_2, PMU_FW, 18, 4)
    FIELD(ERROR_SIG_MASK_2, PMU_UC, 17, 1)
    FIELD(ERROR_SIG_MASK_2, CSU, 16, 1)
    FIELD(ERROR_SIG_MASK_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_SIG_MASK_2, PL, 2, 4)
    FIELD(ERROR_SIG_MASK_2, TO, 0, 2)
REG32(ERROR_SIG_EN_2, 0x590)
    FIELD(ERROR_SIG_EN_2, CSU_ROM, 26, 1)
    FIELD(ERROR_SIG_EN_2, PMU_PB, 25, 1)
    FIELD(ERROR_SIG_EN_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_SIG_EN_2, PMU_FW, 18, 4)
    FIELD(ERROR_SIG_EN_2, PMU_UC, 17, 1)
    FIELD(ERROR_SIG_EN_2, CSU, 16, 1)
    FIELD(ERROR_SIG_EN_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_SIG_EN_2, PL, 2, 4)
    FIELD(ERROR_SIG_EN_2, TO, 0, 2)
REG32(ERROR_SIG_DIS_2, 0x594)
    FIELD(ERROR_SIG_DIS_2, CSU_ROM, 26, 1)
    FIELD(ERROR_SIG_DIS_2, PMU_PB, 25, 1)
    FIELD(ERROR_SIG_DIS_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_SIG_DIS_2, PMU_FW, 18, 4)
    FIELD(ERROR_SIG_DIS_2, PMU_UC, 17, 1)
    FIELD(ERROR_SIG_DIS_2, CSU, 16, 1)
    FIELD(ERROR_SIG_DIS_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_SIG_DIS_2, PL, 2, 4)
    FIELD(ERROR_SIG_DIS_2, TO, 0, 2)
REG32(ERROR_EN_1, 0x5a0)
    FIELD(ERROR_EN_1, AUX3, 31, 1)
    FIELD(ERROR_EN_1, AUX2, 30, 1)
    FIELD(ERROR_EN_1, AUX1, 29, 1)
    FIELD(ERROR_EN_1, AUX0, 28, 1)
    FIELD(ERROR_EN_1, DFT, 27, 1)
    FIELD(ERROR_EN_1, CLK_MON, 26, 1)
    FIELD(ERROR_EN_1, XMPU, 24, 2)
    FIELD(ERROR_EN_1, PWR_SUPPLY, 16, 8)
    FIELD(ERROR_EN_1, FPD_SWDT, 13, 1)
    FIELD(ERROR_EN_1, LPD_SWDT, 12, 1)
    FIELD(ERROR_EN_1, RPU_CCF, 9, 1)
    FIELD(ERROR_EN_1, RPU_LS, 6, 2)
    FIELD(ERROR_EN_1, FPD_TEMP, 5, 1)
    FIELD(ERROR_EN_1, LPD_TEMP, 4, 1)
    FIELD(ERROR_EN_1, RPU1, 3, 1)
    FIELD(ERROR_EN_1, RPU0, 2, 1)
    FIELD(ERROR_EN_1, OCM_ECC, 1, 1)
    FIELD(ERROR_EN_1, DDR_ECC, 0, 1)
REG32(ERROR_EN_2, 0x5a4)
    FIELD(ERROR_EN_2, CSU_ROM, 26, 1)
    FIELD(ERROR_EN_2, PMU_PB, 25, 1)
    FIELD(ERROR_EN_2, PMU_SERVICE, 24, 1)
    FIELD(ERROR_EN_2, PMU_FW, 18, 4)
    FIELD(ERROR_EN_2, PMU_UC, 17, 1)
    FIELD(ERROR_EN_2, CSU, 16, 1)
    FIELD(ERROR_EN_2, PLL_LOCK, 8, 5)
    FIELD(ERROR_EN_2, PL, 2, 4)
    FIELD(ERROR_EN_2, TO, 0, 2)
REG32(AIB_CNTRL, 0x600)
    FIELD(AIB_CNTRL, FPD_AFI_FS, 3, 1)
    FIELD(AIB_CNTRL, FPD_AFI_FM, 2, 1)
    FIELD(AIB_CNTRL, LPD_AFI_FS, 1, 1)
    FIELD(AIB_CNTRL, LPD_AFI_FM, 0, 1)
REG32(AIB_STATUS, 0x604)
    FIELD(AIB_STATUS, FPD_AFI_FS, 3, 1)
    FIELD(AIB_STATUS, FPD_AFI_FM, 2, 1)
    FIELD(AIB_STATUS, LPD_AFI_FS, 1, 1)
    FIELD(AIB_STATUS, LPD_AFI_FM, 0, 1)
REG32(GLOBAL_RESET, 0x608)
    FIELD(GLOBAL_RESET, PS_ONLY_RST, 10, 1)
    FIELD(GLOBAL_RESET, FPD_RST, 9, 1)
    FIELD(GLOBAL_RESET, RPU_LS_RST, 8, 1)
REG32(ROM_VALIDATION_STATUS, 0x610)
    FIELD(ROM_VALIDATION_STATUS, PASS, 1, 1)
    FIELD(ROM_VALIDATION_STATUS, DONE, 0, 1)
REG32(ROM_VALIDATION_DIGEST_0, 0x614)
REG32(ROM_VALIDATION_DIGEST_1, 0x618)
REG32(ROM_VALIDATION_DIGEST_2, 0x61c)
REG32(ROM_VALIDATION_DIGEST_3, 0x620)
REG32(ROM_VALIDATION_DIGEST_4, 0x624)
REG32(ROM_VALIDATION_DIGEST_5, 0x628)
REG32(ROM_VALIDATION_DIGEST_6, 0x62c)
REG32(ROM_VALIDATION_DIGEST_7, 0x630)
REG32(ROM_VALIDATION_DIGEST_8, 0x634)
REG32(ROM_VALIDATION_DIGEST_9, 0x638)
REG32(ROM_VALIDATION_DIGEST_10, 0x63c)
REG32(ROM_VALIDATION_DIGEST_11, 0x640)
REG32(SAFETY_GATE, 0x650)
    FIELD(SAFETY_GATE, PMU_LOGCLR_ENABLE, 2, 1)
    FIELD(SAFETY_GATE, LBIST_ENABLE, 1, 1)
    FIELD(SAFETY_GATE, SCAN_ENABLE, 0, 1)
REG32(MBIST_RST, 0x700)
REG32(MBIST_PG_EN, 0x704)
REG32(MBIST_SETUP, 0x708)
REG32(MBIST_DONE, 0x710)
REG32(MBIST_GOOD, 0x714)
REG32(SAFETY_CHK, 0x800)

#define PMU_GLOBAL_R_MAX (R_SAFETY_CHK + 1)

typedef struct PMU_GLOBAL {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_req_pwrdwn_int;
    qemu_irq irq_req_swrst_int;
    qemu_irq irq_error_srst_2;
    qemu_irq irq_req_pwrup_int;
    qemu_irq irq_error_srst_1;
    qemu_irq irq_error_sig_2;
    qemu_irq irq_req_aux_int;
    qemu_irq irq_error_sig_1;
    qemu_irq irq_addr_error_int;
    qemu_irq irq_error_int_2;
    qemu_irq irq_error_int_1;
    qemu_irq irq_error_por_2;
    qemu_irq irq_error_por_1;
    qemu_irq irq_req_iso_int;

    qemu_irq pmu_wake;
    qemu_irq fpd_rst;
    qemu_irq ps_only_rst;

    bool fw_is_present;
    bool ignore_pwr_req;
    /* Record hardware error events, so error status register can be updated
     * if error is enabled in error enable register.
     */
    uint32_t error_1;
    uint32_t error_2;

    uint32_t regs[PMU_GLOBAL_R_MAX];
    RegisterInfo regs_info[PMU_GLOBAL_R_MAX];
} PMU_GLOBAL;

#define PROPAGATE_GPIO(s, reg, f, irq) {              \
    bool val = ARRAY_FIELD_EX32((s)->regs, reg, f);   \
    qemu_set_irq(irq, val);                           \
}

static void req_pwrdwn_int_update_irq(PMU_GLOBAL *s)
{
    bool pending;

    pending = s->regs[R_REQ_PWRDWN_STATUS] & ~s->regs[R_REQ_PWRDWN_INT_MASK];
    qemu_set_irq(s->irq_req_pwrdwn_int, pending);
}

static void req_pwrdwn_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    req_pwrdwn_int_update_irq(s);
}

static uint64_t req_pwrdwn_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN_INT_MASK] &= ~val;
    req_pwrdwn_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN_INT_MASK] |= val;
    req_pwrdwn_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN_STATUS] |= val;
    req_pwrdwn_int_update_irq(s);
    return 0;
}

static void req_swrst_int_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_REQ_SWRST_STATUS] & ~s->regs[R_REQ_SWRST_INT_MASK];
    qemu_set_irq(s->irq_req_swrst_int, pending);
}

static void req_swrst_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    req_swrst_int_update_irq(s);
}

static uint64_t req_swrst_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_INT_MASK] &= ~val;
    req_swrst_int_update_irq(s);
    return 0;
}

static uint64_t req_swrst_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_INT_MASK] |= val;
    req_swrst_int_update_irq(s);
    return 0;
}

static uint64_t req_swrst_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_STATUS] |= val;
    req_swrst_int_update_irq(s);
    return 0;
}

static void error_srst_2_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_2] & ~s->regs[R_ERROR_SRST_MASK_2];
    qemu_set_irq(s->irq_error_srst_2, pending);
}

static uint64_t error_srst_en_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SRST_MASK_2] &= ~val;
    error_srst_2_update_irq(s);
    return 0;
}

static uint64_t error_srst_dis_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SRST_MASK_2] |= val;
    error_srst_2_update_irq(s);
    return 0;
}

static void req_pwrup_int_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_REQ_PWRUP_STATUS] & ~s->regs[R_REQ_PWRUP_INT_MASK];
    qemu_set_irq(s->irq_req_pwrup_int, pending);
}

static void req_pwrup_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    req_pwrup_int_update_irq(s);
}

static uint64_t req_pwrup_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP_INT_MASK] &= ~val;
    req_pwrup_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP_INT_MASK] |= val;
    req_pwrup_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    if (!s->ignore_pwr_req) {
        s->regs[R_REQ_PWRUP_STATUS] |= val;
    }
    req_pwrup_int_update_irq(s);
    return 0;
}

static void error_srst_1_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_1] & ~s->regs[R_ERROR_SRST_MASK_1];
    qemu_set_irq(s->irq_error_srst_1, pending);
}

static uint64_t error_srst_en_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SRST_MASK_1] &= ~val;
    error_srst_1_update_irq(s);
    return 0;
}

static uint64_t error_srst_dis_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SRST_MASK_1] |= val;
    error_srst_1_update_irq(s);
    return 0;
}

static void error_sig_2_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_2] & ~s->regs[R_ERROR_SIG_MASK_2];
    qemu_set_irq(s->irq_error_sig_2, pending);
}

static uint64_t error_sig_en_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SIG_MASK_2] &= ~val;
    error_sig_2_update_irq(s);
    return 0;
}

static uint64_t error_sig_dis_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SIG_MASK_2] |= val;
    error_sig_2_update_irq(s);
    return 0;
}

static void req_aux_int_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_REQ_AUX_STATUS] & ~s->regs[R_REQ_AUX_INT_MASK];
    qemu_set_irq(s->irq_req_aux_int, pending);
}

static void req_aux_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    req_aux_int_update_irq(s);
}

static uint64_t req_aux_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_AUX_INT_MASK] &= ~val;
    req_aux_int_update_irq(s);
    return 0;
}

static uint64_t req_aux_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_AUX_INT_MASK] |= val;
    req_aux_int_update_irq(s);
    return 0;
}

static uint64_t req_aux_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_AUX_STATUS] |= val;
    req_aux_int_update_irq(s);
    return 0;
}

static void error_sig_1_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_1] & ~s->regs[R_ERROR_SIG_MASK_1];
    qemu_set_irq(s->irq_error_sig_1, pending);
}

static uint64_t error_sig_en_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SIG_MASK_1] &= ~val;
    error_sig_1_update_irq(s);
    return 0;
}

static uint64_t error_sig_dis_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_SIG_MASK_1] |= val;
    error_sig_1_update_irq(s);
    return 0;
}

static void addr_error_int_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ADDR_ERROR_STATUS] & ~s->regs[R_ADDR_ERROR_INT_MASK];
    qemu_set_irq(s->irq_addr_error_int, pending);
}

static void addr_error_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    addr_error_int_update_irq(s);
}

static uint64_t addr_error_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] &= ~val;
    addr_error_int_update_irq(s);
    return 0;
}

static uint64_t addr_error_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] |= val;
    addr_error_int_update_irq(s);
    return 0;
}

static void error_int_2_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_2] & ~s->regs[R_ERROR_INT_MASK_2];
    qemu_set_irq(s->irq_error_int_2, pending);
}

static void error_status_2_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    s->error_2 = val64;
    error_int_2_update_irq(s);
}

static uint64_t error_int_en_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_INT_MASK_2] &= ~val;
    error_int_2_update_irq(s);
    return 0;
}

static uint64_t error_int_dis_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_INT_MASK_2] |= val;
    error_int_2_update_irq(s);
    return 0;
}

static void error_int_1_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_1] & ~s->regs[R_ERROR_INT_MASK_1];
    qemu_set_irq(s->irq_error_int_1, pending);
}


/* Set error in ERROR_STATUS_1 register if it is enabled in ERROR_EN_1 and
 * error input is set.
 * Error is only cleared by explicitly writing a 1 to its corresponding
 * ERROR_STATUS_1 register bit.
 */
static void set_error_1(PMU_GLOBAL *s)
{
    s->regs[R_ERROR_STATUS_1] |= s->error_1 & s->regs[R_ERROR_EN_1];
    error_int_1_update_irq(s);
}

static void error_en_1_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    set_error_1(s);
}

/* Set error in ERROR_STATUS_2 register if it is enabled in ERROR_EN_2 and
 * error input is set.
 * Error is only cleared by explicitly writing a 1 to its corresponding
 * ERROR_STATUS_2 register bit.
 */
static void set_error_2(PMU_GLOBAL *s)
{
    s->regs[R_ERROR_STATUS_2] |= s->error_2 & s->regs[R_ERROR_EN_2];
    error_int_2_update_irq(s);
}

static void error_en_2_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    set_error_2(s);
}

static void abi_cntrl_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    s->regs[R_AIB_STATUS] |= val64;
}

static void error_status_1_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    s->error_1 = val64;
    error_int_1_update_irq(s);
}

static uint64_t error_int_en_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_INT_MASK_1] &= ~val;
    error_int_1_update_irq(s);
    return 0;
}

static uint64_t error_int_dis_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_INT_MASK_1] |= val;
    error_int_1_update_irq(s);
    return 0;
}

static void error_por_2_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_2] & ~s->regs[R_ERROR_POR_MASK_2];
    qemu_set_irq(s->irq_error_por_2, pending);
}

static uint64_t error_por_en_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_POR_MASK_2] &= ~val;
    error_por_2_update_irq(s);
    return 0;
}

static uint64_t error_por_dis_2_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_POR_MASK_2] |= val;
    error_por_2_update_irq(s);
    return 0;
}

static void error_por_1_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_ERROR_STATUS_1] & ~s->regs[R_ERROR_POR_MASK_1];
    qemu_set_irq(s->irq_error_por_1, pending);
}

static uint64_t error_por_en_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_POR_MASK_1] &= ~val;
    error_por_1_update_irq(s);
    return 0;
}

static uint64_t error_por_dis_1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERROR_POR_MASK_1] |= val;
    error_por_1_update_irq(s);
    return 0;
}

static void req_iso_int_update_irq(PMU_GLOBAL *s)
{
    bool pending = s->regs[R_REQ_ISO_STATUS] & ~s->regs[R_REQ_ISO_INT_MASK];
    qemu_set_irq(s->irq_req_iso_int, pending);
}

static void req_iso_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    req_iso_int_update_irq(s);
}

static uint64_t req_iso_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_INT_MASK] &= ~val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t req_iso_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_INT_MASK] |= val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t req_iso_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_STATUS] |= val;
    req_iso_int_update_irq(s);
    return 0;
}

static void mbist_rst_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    /* Reset the MBIST_DONE, MBIST_GOOD registers */
    s->regs[R_MBIST_DONE] &= s->regs[R_MBIST_RST];
    s->regs[R_MBIST_GOOD] &= s->regs[R_MBIST_RST];
}

static void mbist_pg_en_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    s->regs[R_MBIST_DONE] |= s->regs[R_MBIST_RST]
                           & s->regs[R_MBIST_SETUP] & s->regs[R_MBIST_PG_EN];
    s->regs[R_MBIST_GOOD] |= s->regs[R_MBIST_RST]
                           & s->regs[R_MBIST_SETUP] & s->regs[R_MBIST_PG_EN];
}

static void global_cntrl_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    PROPAGATE_GPIO(s, GLOBAL_CNTRL, DONT_SLEEP, s->pmu_wake);
}

static void global_reset_postw(RegisterInfo *reg, uint64_t val64)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg->opaque);

    PROPAGATE_GPIO(s, GLOBAL_RESET, FPD_RST, s->fpd_rst);
    PROPAGATE_GPIO(s, GLOBAL_RESET, PS_ONLY_RST, s->ps_only_rst);
}

static const RegisterAccessInfo pmu_global_regs_info[] = {
    {   .name = "GLOBAL_CNTRL",  .addr = A_GLOBAL_CNTRL,
        .reset = 0x8800,
        .rsvd = 0xfffe00e8,
        .ro = 0xffff00e8,
        .post_write = global_cntrl_postw,
    },{ .name = "PS_CNTRL",  .addr = A_PS_CNTRL,
        .rsvd = 0xfffefffc,
        .ro = 0xfffffffc,
    },{ .name = "APU_PWR_STATUS_INIT",  .addr = A_APU_PWR_STATUS_INIT,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "ADDR_ERROR_STATUS",  .addr = A_ADDR_ERROR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = addr_error_status_postw,
    },{ .name = "ADDR_ERROR_INT_MASK",  .addr = A_ADDR_ERROR_INT_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "ADDR_ERROR_INT_EN",  .addr = A_ADDR_ERROR_INT_EN,
        .pre_write = addr_error_int_en_prew,
    },{ .name = "ADDR_ERROR_INT_DIS",  .addr = A_ADDR_ERROR_INT_DIS,
        .pre_write = addr_error_int_dis_prew,
    },{ .name = "GLOBAL_GEN_STORAGE0",  .addr = A_GLOBAL_GEN_STORAGE0,
    },{ .name = "GLOBAL_GEN_STORAGE1",  .addr = A_GLOBAL_GEN_STORAGE1,
    },{ .name = "GLOBAL_GEN_STORAGE2",  .addr = A_GLOBAL_GEN_STORAGE2,
    },{ .name = "GLOBAL_GEN_STORAGE3",  .addr = A_GLOBAL_GEN_STORAGE3,
    },{ .name = "GLOBAL_GEN_STORAGE4",  .addr = A_GLOBAL_GEN_STORAGE4,
    },{ .name = "GLOBAL_GEN_STORAGE5",  .addr = A_GLOBAL_GEN_STORAGE5,
    },{ .name = "GLOBAL_GEN_STORAGE6",  .addr = A_GLOBAL_GEN_STORAGE6,
    },{ .name = "PERS_GLOB_GEN_STORAGE0",  .addr = A_PERS_GLOB_GEN_STORAGE0,
    },{ .name = "PERS_GLOB_GEN_STORAGE1",  .addr = A_PERS_GLOB_GEN_STORAGE1,
    },{ .name = "PERS_GLOB_GEN_STORAGE2",  .addr = A_PERS_GLOB_GEN_STORAGE2,
    },{ .name = "PERS_GLOB_GEN_STORAGE3",  .addr = A_PERS_GLOB_GEN_STORAGE3,
    },{ .name = "PERS_GLOB_GEN_STORAGE4",  .addr = A_PERS_GLOB_GEN_STORAGE4,
    },{ .name = "PERS_GLOB_GEN_STORAGE5",  .addr = A_PERS_GLOB_GEN_STORAGE5,
    },{ .name = "PERS_GLOB_GEN_STORAGE6",  .addr = A_PERS_GLOB_GEN_STORAGE6,
    },{ .name = "PERS_GLOB_GEN_STORAGE7",  .addr = A_PERS_GLOB_GEN_STORAGE7,
    },{ .name = "DDR_CNTRL",  .addr = A_DDR_CNTRL,
    },{ .name = "PWR_STATE",  .addr = A_PWR_STATE,
        .reset = 0xfffcbf,
        .rsvd = 0xff000340,
        .ro = 0xffffffff,
    },{ .name = "AUX_PWR_STATE",  .addr = A_AUX_PWR_STATE,
        .reset = 0xff080,
        .rsvd = 0x7f00f7f,
        .ro = 0xffffffff,
    },{ .name = "RAM_RET_CNTRL",  .addr = A_RAM_RET_CNTRL,
        .rsvd = 0xfff00f7f,
        .ro = 0xfff00f7f,
    },{ .name = "PWR_SUPPLY_STATUS",  .addr = A_PWR_SUPPLY_STATUS,
        /* FIXME: Added 0x3 to reset bits so FPD will be
         * properly powered up by PMUROM.
         */
        .reset = 0x4 | 0x3,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP_STATUS",  .addr = A_REQ_PWRUP_STATUS,
        .rsvd = 0xff000b40,
        .ro = 0xff000b40,
        .w1c = 0xfff4bf,
        .post_write = req_pwrup_status_postw,
    },{ .name = "REQ_PWRUP_INT_MASK",  .addr = A_REQ_PWRUP_INT_MASK,
        .reset = 0xfff4bf,
        .rsvd = 0xff000b40,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP_INT_EN",  .addr = A_REQ_PWRUP_INT_EN,
        .pre_write = req_pwrup_int_en_prew,
    },{ .name = "REQ_PWRUP_INT_DIS",  .addr = A_REQ_PWRUP_INT_DIS,
        .pre_write = req_pwrup_int_dis_prew,
    },{ .name = "REQ_PWRUP_TRIG",  .addr = A_REQ_PWRUP_TRIG,
        .pre_write = req_pwrup_trig_prew,
    },{ .name = "REQ_PWRDWN_STATUS",  .addr = A_REQ_PWRDWN_STATUS,
        .rsvd = 0xff000b40,
        .ro = 0xff000b40,
        .w1c = 0xfff4bf,
        .post_write = req_pwrdwn_status_postw,
    },{ .name = "REQ_PWRDWN_INT_MASK",  .addr = A_REQ_PWRDWN_INT_MASK,
        .reset = 0xfff4bf,
        .rsvd = 0xff000b40,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRDWN_INT_EN",  .addr = A_REQ_PWRDWN_INT_EN,
        .pre_write = req_pwrdwn_int_en_prew,
    },{ .name = "REQ_PWRDWN_INT_DIS",  .addr = A_REQ_PWRDWN_INT_DIS,
        .pre_write = req_pwrdwn_int_dis_prew,
    },{ .name = "REQ_PWRDWN_TRIG",  .addr = A_REQ_PWRDWN_TRIG,
        .pre_write = req_pwrdwn_trig_prew,
    },{ .name = "REQ_ISO_STATUS",  .addr = A_REQ_ISO_STATUS,
        .rsvd = 0xffffffe8,
        .ro = 0xffffffe8,
        .w1c = 0x17,
        .post_write = req_iso_status_postw,
    },{ .name = "REQ_ISO_INT_MASK",  .addr = A_REQ_ISO_INT_MASK,
        .reset = 0x17,
        .rsvd = 0xffffffe8,
        .ro = 0xffffffff,
    },{ .name = "REQ_ISO_INT_EN",  .addr = A_REQ_ISO_INT_EN,
        .pre_write = req_iso_int_en_prew,
    },{ .name = "REQ_ISO_INT_DIS",  .addr = A_REQ_ISO_INT_DIS,
        .pre_write = req_iso_int_dis_prew,
    },{ .name = "REQ_ISO_TRIG",  .addr = A_REQ_ISO_TRIG,
        .pre_write = req_iso_trig_prew,
    },{ .name = "REQ_SWRST_STATUS",  .addr = A_REQ_SWRST_STATUS,
        .rsvd = 0x408e820,
        .ro = 0x408e820,
        .w1c = 0xfbf717df,
        .post_write = req_swrst_status_postw,
    },{ .name = "REQ_SWRST_INT_MASK",  .addr = A_REQ_SWRST_INT_MASK,
        .reset = 0xfbf717df,
        .rsvd = 0x408e820,
        .ro = 0xffffffff,
    },{ .name = "REQ_SWRST_INT_EN",  .addr = A_REQ_SWRST_INT_EN,
        .pre_write = req_swrst_int_en_prew,
    },{ .name = "REQ_SWRST_INT_DIS",  .addr = A_REQ_SWRST_INT_DIS,
        .pre_write = req_swrst_int_dis_prew,
    },{ .name = "REQ_SWRST_TRIG",  .addr = A_REQ_SWRST_TRIG,
        .pre_write = req_swrst_trig_prew,
    },{ .name = "REQ_AUX_STATUS",  .addr = A_REQ_AUX_STATUS,
        .rsvd = 0xfffccb30,
        .ro = 0xfffccb30,
        .w1c = 0x334cf,
        .post_write = req_aux_status_postw,
    },{ .name = "REQ_AUX_INT_MASK",  .addr = A_REQ_AUX_INT_MASK,
        .reset = 0x334cf,
        .rsvd = 0xfffccb30,
        .ro = 0xffffffff,
    },{ .name = "REQ_AUX_INT_EN",  .addr = A_REQ_AUX_INT_EN,
        .pre_write = req_aux_int_en_prew,
    },{ .name = "REQ_AUX_INT_DIS",  .addr = A_REQ_AUX_INT_DIS,
        .pre_write = req_aux_int_dis_prew,
    },{ .name = "REQ_AUX_TRIG",  .addr = A_REQ_AUX_TRIG,
        .pre_write = req_aux_trig_prew,
    },{ .name = "LOGCLR_STATUS",  .addr = A_LOGCLR_STATUS,
        .rsvd = 0xfffccb30,
        .ro = 0xffffffff,
    },{ .name = "CSU_BR_ERROR",  .addr = A_CSU_BR_ERROR,
        .rsvd = 0x7fff0000,
        .ro = 0x7fff0000,
    },{ .name = "MB_FAULT_STATUS",  .addr = A_MB_FAULT_STATUS,
        .rsvd = 0xf000f0,
        .ro = 0xffffffff,
    },{ .name = "ERROR_STATUS_1",  .addr = A_ERROR_STATUS_1,
        .rsvd = 0xcd00,
        .ro = 0xcd00,
        .w1c = 0xffff32ff,
        .post_write = error_status_1_postw,
    },{ .name = "ERROR_INT_MASK_1",  .addr = A_ERROR_INT_MASK_1,
        .reset = 0xffff32ff,
        .rsvd = 0xcd00,
        .ro = 0xffffffff,
    },{ .name = "ERROR_INT_EN_1",  .addr = A_ERROR_INT_EN_1,
        .rsvd = 0xcd00,
        .pre_write = error_int_en_1_prew,
    },{ .name = "ERROR_INT_DIS_1",  .addr = A_ERROR_INT_DIS_1,
        .pre_write = error_int_dis_1_prew,
    },{ .name = "ERROR_STATUS_2",  .addr = A_ERROR_STATUS_2,
        .rsvd = 0xf8c0e0c0,
        .ro = 0xf8c0e0c0,
        .w1c = 0x73f1f3f,
        .post_write = error_status_2_postw,
    },{ .name = "ERROR_INT_MASK_2",  .addr = A_ERROR_INT_MASK_2,
        .reset = 0x73f1f3f,
        .rsvd = 0xf8c0e0c0,
        .ro = 0xffffffff,
    },{ .name = "ERROR_INT_EN_2",  .addr = A_ERROR_INT_EN_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_int_en_2_prew,
    },{ .name = "ERROR_INT_DIS_2",  .addr = A_ERROR_INT_DIS_2,
        .pre_write = error_int_dis_2_prew,
    },{ .name = "ERROR_POR_MASK_1",  .addr = A_ERROR_POR_MASK_1,
        .reset = 0xffff32ff,
        .rsvd = 0xcd00,
        .ro = 0xffffffff,
    },{ .name = "ERROR_POR_EN_1",  .addr = A_ERROR_POR_EN_1,
        .rsvd = 0xcd00,
        .pre_write = error_por_en_1_prew,
    },{ .name = "ERROR_POR_DIS_1",  .addr = A_ERROR_POR_DIS_1,
        .rsvd = 0xcd00,
        .pre_write = error_por_dis_1_prew,
    },{ .name = "ERROR_POR_MASK_2",  .addr = A_ERROR_POR_MASK_2,
        .reset = 0x73f1f3f,
        .rsvd = 0xf8c0e0c0,
        .ro = 0xffffffff,
    },{ .name = "ERROR_POR_EN_2",  .addr = A_ERROR_POR_EN_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_por_en_2_prew,
    },{ .name = "ERROR_POR_DIS_2",  .addr = A_ERROR_POR_DIS_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_por_dis_2_prew,
    },{ .name = "ERROR_SRST_MASK_1",  .addr = A_ERROR_SRST_MASK_1,
        .reset = 0xffff32ff,
        .rsvd = 0xcd00,
        .ro = 0xffffffff,
    },{ .name = "ERROR_SRST_EN_1",  .addr = A_ERROR_SRST_EN_1,
        .rsvd = 0xcd00,
        .pre_write = error_srst_en_1_prew,
    },{ .name = "ERROR_SRST_DIS_1",  .addr = A_ERROR_SRST_DIS_1,
        .rsvd = 0xcd00,
        .pre_write = error_srst_dis_1_prew,
    },{ .name = "ERROR_SRST_MASK_2",  .addr = A_ERROR_SRST_MASK_2,
        .reset = 0x73f1f3f,
        .rsvd = 0xf8c0e0c0,
        .ro = 0xffffffff,
    },{ .name = "ERROR_SRST_EN_2",  .addr = A_ERROR_SRST_EN_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_srst_en_2_prew,
    },{ .name = "ERROR_SRST_DIS_2",  .addr = A_ERROR_SRST_DIS_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_srst_dis_2_prew,
    },{ .name = "ERROR_SIG_MASK_1",  .addr = A_ERROR_SIG_MASK_1,
        .reset = 0xc3,
        .rsvd = 0xcd00,
        .ro = 0xffffffff,
    },{ .name = "ERROR_SIG_EN_1",  .addr = A_ERROR_SIG_EN_1,
        .rsvd = 0xcd00,
        .pre_write = error_sig_en_1_prew,
    },{ .name = "ERROR_SIG_DIS_1",  .addr = A_ERROR_SIG_DIS_1,
        .rsvd = 0xcd00,
        .pre_write = error_sig_dis_1_prew,
    },{ .name = "ERROR_SIG_MASK_2",  .addr = A_ERROR_SIG_MASK_2,
        .reset = 0x1f00,
        .rsvd = 0xf8c0e0c0,
        .ro = 0xffffffff,
    },{ .name = "ERROR_SIG_EN_2",  .addr = A_ERROR_SIG_EN_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_sig_en_2_prew,
    },{ .name = "ERROR_SIG_DIS_2",  .addr = A_ERROR_SIG_DIS_2,
        .rsvd = 0xf8c0e0c0,
        .pre_write = error_sig_dis_2_prew,
    },{ .name = "ERROR_EN_1",  .addr = A_ERROR_EN_1,
        .post_write = error_en_1_postw,
    },{ .name = "ERROR_EN_2",  .addr = A_ERROR_EN_2,
        .post_write = error_en_2_postw,
    },{ .name = "AIB_CNTRL",  .addr = A_AIB_CNTRL,
        .post_write = abi_cntrl_postw,
        .rsvd = 0xfffffff0,
    },{ .name = "AIB_STATUS",  .addr = A_AIB_STATUS,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "GLOBAL_RESET",  .addr = A_GLOBAL_RESET,
        .rsvd = 0xfffff8ff,
        .ro = 0xfffff8ff,
        .post_write = global_reset_postw,
    },{ .name = "ROM_VALIDATION_STATUS",  .addr = A_ROM_VALIDATION_STATUS,
        .rsvd = 0xfffffffc,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_0",  .addr = A_ROM_VALIDATION_DIGEST_0,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_1",  .addr = A_ROM_VALIDATION_DIGEST_1,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_2",  .addr = A_ROM_VALIDATION_DIGEST_2,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_3",  .addr = A_ROM_VALIDATION_DIGEST_3,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_4",  .addr = A_ROM_VALIDATION_DIGEST_4,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_5",  .addr = A_ROM_VALIDATION_DIGEST_5,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_6",  .addr = A_ROM_VALIDATION_DIGEST_6,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_7",  .addr = A_ROM_VALIDATION_DIGEST_7,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_8",  .addr = A_ROM_VALIDATION_DIGEST_8,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_9",  .addr = A_ROM_VALIDATION_DIGEST_9,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_10",  .addr = A_ROM_VALIDATION_DIGEST_10,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "ROM_VALIDATION_DIGEST_11",  .addr = A_ROM_VALIDATION_DIGEST_11,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "SAFETY_GATE",  .addr = A_SAFETY_GATE,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
    },{ .name = "MBIST_RST",  .addr = A_MBIST_RST,
        .post_write = mbist_rst_postw,
    },{ .name = "MBIST_PG_EN",  .addr = A_MBIST_PG_EN,
        .post_write = mbist_pg_en_postw,
    },{ .name = "MBIST_SETUP",  .addr = A_MBIST_SETUP,
    },{ .name = "MBIST_DONE",  .addr = A_MBIST_DONE,
        .ro = 0xffffffff,
    },{ .name = "MBIST_GOOD",  .addr = A_MBIST_GOOD,
        .ro = 0xffffffff,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    }
};

static void pmu_global_reset(DeviceState *dev)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        switch (i) {
        case R_PERS_GLOB_GEN_STORAGE0...R_PERS_GLOB_GEN_STORAGE7:
            continue;
        default:
            register_reset(&s->regs_info[i]);
       };
    }

    req_pwrdwn_int_update_irq(s);
    req_swrst_int_update_irq(s);
    error_srst_2_update_irq(s);
    req_pwrup_int_update_irq(s);
    error_srst_1_update_irq(s);
    error_sig_2_update_irq(s);
    req_aux_int_update_irq(s);
    error_sig_1_update_irq(s);
    addr_error_int_update_irq(s);
    error_int_2_update_irq(s);
    error_int_1_update_irq(s);
    error_por_2_update_irq(s);
    error_por_1_update_irq(s);
    req_iso_int_update_irq(s);

    s->error_1 = 0;
    s->error_2 = 0;

    ARRAY_FIELD_DP32(s->regs, GLOBAL_CNTRL, FW_IS_PRESENT, s->fw_is_present);
}


static MemTxResult check_addr(PMU_GLOBAL *s, hwaddr addr)
{
    MemTxResult ret = MEMTX_OK;
    RegisterInfo *r = &s->regs_info[addr / 4];

    /* Register doesn't exist?  */
    if (!r->data) {
        s->regs[R_ADDR_ERROR_STATUS] |= R_ADDR_ERROR_STATUS_STATUS_MASK;
        addr_error_int_update_irq(s);


        /* Report Slave Errors when enabled.  */
        if (ARRAY_FIELD_EX32(s->regs, GLOBAL_CNTRL, SLVERR_ENABLE)) {
            ret = MEMTX_DECODE_ERROR;
        }
    }
    return ret;
}

static MemTxResult pmu_global_read(void *opaque, hwaddr addr, uint64_t *value,
                                   unsigned size, MemTxAttrs attr)
{
    RegisterInfoArray *reg_array = opaque;
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg_array->r[0]->opaque);
    MemTxResult ret = MEMTX_OK;

    if (!attr.secure) {
        /* Ignore NS accesses.  */
        qemu_log_mask(LOG_GUEST_ERROR,
                      "Non secure accesses to PMU global are invalid\n");
        *value = 0;
        return ret;
    }

    *value = register_read_memory(opaque, addr, size);
    ret = check_addr(s, addr);
    return ret;
}

static MemTxResult pmu_global_write(void *opaque, hwaddr addr, uint64_t value,
                                    unsigned size, MemTxAttrs attr)
{
    RegisterInfoArray *reg_array = opaque;
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(reg_array->r[0]->opaque);
    MemTxResult ret = MEMTX_OK;

    if (!attr.secure) {
        /* Ignore NS accesses.  */
        qemu_log_mask(LOG_GUEST_ERROR,
                      "Non secure accesses to PMU global are invalid\n");
        return ret;
    }

    register_write_memory(opaque, addr, value, size);
    ret = check_addr(s, addr);
    return ret;
}


static const MemoryRegionOps pmu_global_ops = {
    .read_with_attrs = pmu_global_read,
    .write_with_attrs = pmu_global_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pwr_state_handler(void *opaque, int n, int level)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(opaque);

    s->regs[R_PWR_STATE] = deposit32(s->regs[R_PWR_STATE], n, 1, level);
}

static void error_handler(void *opaque, int n, int level)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(opaque);

    /* First 32 gpios are for ERROR_STATUS_1 */
    if (n < 32) {
        s->error_1 = deposit32(s->error_1, n, 1, level);
        set_error_1(s);
    } else {
        s->error_2 = deposit32(s->error_2, n, 1, level);
        set_error_2(s);
    }
}

static void gpio_mb_sleep_h(void *opaque, int n, int level)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(opaque);
    ARRAY_FIELD_DP32(s->regs, GLOBAL_CNTRL, MB_SLEEP, !!level);
}

static void pmu_global_init(Object *obj)
{
    PMU_GLOBAL *s = XILINX_PMU_GLOBAL(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMU_GLOBAL,
                       PMU_GLOBAL_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmu_global_regs_info,
                              ARRAY_SIZE(pmu_global_regs_info),
                              s->regs_info, s->regs,
                              &pmu_global_ops,
                              XILINX_PMU_GLOBAL_ERR_DEBUG,
                              PMU_GLOBAL_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);

    sysbus_init_irq(sbd, &s->irq_req_aux_int);    /* 23 */
    sysbus_init_irq(sbd, &s->irq_req_iso_int);    /* 24 */
    sysbus_init_irq(sbd, &s->irq_req_swrst_int);  /* 26 */
    sysbus_init_irq(sbd, &s->irq_req_pwrup_int);  /* 27 */
    sysbus_init_irq(sbd, &s->irq_req_pwrdwn_int); /* 28 */
    sysbus_init_irq(sbd, &s->irq_addr_error_int); /* 29 */

    /* Order not yet defined!   */
    sysbus_init_irq(sbd, &s->irq_error_srst_1);
    sysbus_init_irq(sbd, &s->irq_error_srst_2);
    sysbus_init_irq(sbd, &s->irq_error_sig_1);
    sysbus_init_irq(sbd, &s->irq_error_sig_2);
    sysbus_init_irq(sbd, &s->irq_error_por_1);
    sysbus_init_irq(sbd, &s->irq_error_por_2);

    qdev_init_gpio_in_named(DEVICE(obj), gpio_mb_sleep_h, "mb_sleep", 1);
    qdev_init_gpio_in_named(DEVICE(obj), pwr_state_handler, "pwr_state", 24);
    qdev_init_gpio_out_named(DEVICE(obj), &s->irq_error_int_1,
                             "error_1_out", 1);
    qdev_init_gpio_out_named(DEVICE(obj), &s->irq_error_int_2,
                             "error_2_out", 1);

    qdev_init_gpio_out_named(DEVICE(obj), &s->pmu_wake, "pmu_wake", 1);
    qdev_init_gpio_out_named(DEVICE(obj), &s->fpd_rst, "FPD_RST", 1);
    qdev_init_gpio_out_named(DEVICE(obj), &s->ps_only_rst, "PS_ONLY_RST", 1);

    /* GPIOs that can be used from qtest */
    qdev_init_gpio_in(DEVICE(obj), error_handler, 64);
}

static const VMStateDescription vmstate_pmu_global = {
    .name = TYPE_XILINX_PMU_GLOBAL,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMU_GLOBAL, PMU_GLOBAL_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet pmu_gpios[] = {
    {
      .names = &fdt_generic_gpio_name_set_gpio,
      .gpios = (FDTGenericGPIOConnection[]) {
        { .name = "pmu_wake", .fdt_index = 0 },
        { .name = "FPD_RST", .fdt_index = 2 },
        { .name = "PS_ONLY_RST", .fdt_index = 3 },
        { },
      },
    },
    { },
};

static const FDTGenericGPIONameSet pwr_state_gpios_names = {
    .propname = "pwr-state-gpios",
    .cells_propname = "#gpio-cells",
    .names_propname = "pwr-state-gpio-names",
};

static const FDTGenericGPIONameSet error_out_gpios_names = {
    .propname = "error-out-gpios",
    .cells_propname = "#gpio-cells",
    .names_propname = "error-out-names",
};

static const FDTGenericGPIOSet pmu_global_client_gpios[] = {
    {
      .names = &pwr_state_gpios_names,
      .gpios = (FDTGenericGPIOConnection[]) {
        { .name = "pwr_state", .fdt_index = 0, .range = 24 },
        { },
      },
    },
    {
      .names = &fdt_generic_gpio_name_set_gpio,
      .gpios = (FDTGenericGPIOConnection[]) {
        { .name = "mb_sleep", .fdt_index = 1 },
        { },
      },
    },
    {
      .names = &error_out_gpios_names,
      .gpios = (FDTGenericGPIOConnection[]) {
        { .name = "error_1_out", .fdt_index = 0 },
        { .name = "error_2_out", .fdt_index = 1 },
        { },
      },
    },
    { },
};

static Property pmu_global_properties[] = {
    DEFINE_PROP_BOOL("fw-is-present", PMU_GLOBAL, fw_is_present, false),
    DEFINE_PROP_BOOL("ignore-pwr-req", PMU_GLOBAL, ignore_pwr_req, false),
    DEFINE_PROP_END_OF_LIST(),
};

static void pmu_global_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->reset = pmu_global_reset;
    dc->vmsd = &vmstate_pmu_global;
    device_class_set_props(dc, pmu_global_properties);
    fggc->controller_gpios = pmu_gpios;
    fggc->client_gpios = pmu_global_client_gpios;
}

static const TypeInfo pmu_global_info = {
    .name          = TYPE_XILINX_PMU_GLOBAL,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMU_GLOBAL),
    .class_init    = pmu_global_class_init,
    .instance_init = pmu_global_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void pmu_global_register_types(void)
{
    type_register_static(&pmu_global_info);
}

type_init(pmu_global_register_types)
