/*
 * QEMU model of the AMS Registers for Analog Monitor System
 *
 * Copyright (c) 2014-2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-01-09.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_AMS_ERR_DEBUG
#define XILINX_AMS_ERR_DEBUG 0
#endif

#define TYPE_XILINX_AMS "xlnx.zynqmp_ams"

#define XILINX_AMS(obj) \
     OBJECT_CHECK(AMS, (obj), TYPE_XILINX_AMS)

REG32(MISC_CTRL, 0x0)
    FIELD(MISC_CTRL, SLVERR_ENABLE_DRP, 1, 1)
    FIELD(MISC_CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR_0, 0x10)
    FIELD(ISR_0, PL_ALM_15, 31, 1)
    FIELD(ISR_0, PL_ALM_14, 30, 1)
    FIELD(ISR_0, PL_ALM_13, 29, 1)
    FIELD(ISR_0, PL_ALM_12, 28, 1)
    FIELD(ISR_0, PL_ALM_11, 27, 1)
    FIELD(ISR_0, PL_ALM_10, 26, 1)
    FIELD(ISR_0, PL_ALM_9, 25, 1)
    FIELD(ISR_0, PL_ALM_8, 24, 1)
    FIELD(ISR_0, PL_ALM_7, 23, 1)
    FIELD(ISR_0, PL_ALM_6, 22, 1)
    FIELD(ISR_0, PL_ALM_5, 21, 1)
    FIELD(ISR_0, PL_ALM_4, 20, 1)
    FIELD(ISR_0, PL_ALM_3, 19, 1)
    FIELD(ISR_0, PL_ALM_2, 18, 1)
    FIELD(ISR_0, PL_ALM_1, 17, 1)
    FIELD(ISR_0, PL_ALM_0, 16, 1)
    FIELD(ISR_0, PS_ALM_15, 15, 1)
    FIELD(ISR_0, PS_ALM_14, 14, 1)
    FIELD(ISR_0, PS_ALM_13, 13, 1)
    FIELD(ISR_0, PS_ALM_12, 12, 1)
    FIELD(ISR_0, PS_ALM_11, 11, 1)
    FIELD(ISR_0, PS_ALM_10, 10, 1)
    FIELD(ISR_0, PS_ALM_9, 9, 1)
    FIELD(ISR_0, PS_ALM_8, 8, 1)
    FIELD(ISR_0, PS_ALM_7, 7, 1)
    FIELD(ISR_0, PS_ALM_6, 6, 1)
    FIELD(ISR_0, PS_ALM_5, 5, 1)
    FIELD(ISR_0, PS_ALM_4, 4, 1)
    FIELD(ISR_0, PS_ALM_3, 3, 1)
    FIELD(ISR_0, PS_ALM_2, 2, 1)
    FIELD(ISR_0, PS_ALM_1, 1, 1)
    FIELD(ISR_0, PS_ALM_0, 0, 1)
REG32(ISR_1, 0x14)
    FIELD(ISR_1, ADDR_DECODE_ERR, 31, 1)
    FIELD(ISR_1, ADDR_DECODE_ERR_PL_SYSMON, 30, 1)
    FIELD(ISR_1, ADDR_DECODE_ERR_PS_SYSMON, 29, 1)
    FIELD(ISR_1, EOS, 4, 1)
    FIELD(ISR_1, EOC, 3, 1)
    FIELD(ISR_1, PL_OT, 2, 1)
    FIELD(ISR_1, PS_LPD_OT, 1, 1)
    FIELD(ISR_1, PS_FPD_OT, 0, 1)
REG32(IMR_0, 0x18)
    FIELD(IMR_0, PL_ALM_15, 31, 1)
    FIELD(IMR_0, PL_ALM_14, 30, 1)
    FIELD(IMR_0, PL_ALM_13, 29, 1)
    FIELD(IMR_0, PL_ALM_12, 28, 1)
    FIELD(IMR_0, PL_ALM_11, 27, 1)
    FIELD(IMR_0, PL_ALM_10, 26, 1)
    FIELD(IMR_0, PL_ALM_9, 25, 1)
    FIELD(IMR_0, PL_ALM_8, 24, 1)
    FIELD(IMR_0, PL_ALM_7, 23, 1)
    FIELD(IMR_0, PL_ALM_6, 22, 1)
    FIELD(IMR_0, PL_ALM_5, 21, 1)
    FIELD(IMR_0, PL_ALM_4, 20, 1)
    FIELD(IMR_0, PL_ALM_3, 19, 1)
    FIELD(IMR_0, PL_ALM_2, 18, 1)
    FIELD(IMR_0, PL_ALM_1, 17, 1)
    FIELD(IMR_0, PL_ALM_0, 16, 1)
    FIELD(IMR_0, PS_ALM_15, 15, 1)
    FIELD(IMR_0, PS_ALM_14, 14, 1)
    FIELD(IMR_0, PS_ALM_13, 13, 1)
    FIELD(IMR_0, PS_ALM_12, 12, 1)
    FIELD(IMR_0, PS_ALM_11, 11, 1)
    FIELD(IMR_0, PS_ALM_10, 10, 1)
    FIELD(IMR_0, PS_ALM_9, 9, 1)
    FIELD(IMR_0, PS_ALM_8, 8, 1)
    FIELD(IMR_0, PS_ALM_7, 7, 1)
    FIELD(IMR_0, PS_ALM_6, 6, 1)
    FIELD(IMR_0, PS_ALM_5, 5, 1)
    FIELD(IMR_0, PS_ALM_4, 4, 1)
    FIELD(IMR_0, PS_ALM_3, 3, 1)
    FIELD(IMR_0, PS_ALM_2, 2, 1)
    FIELD(IMR_0, PS_ALM_1, 1, 1)
    FIELD(IMR_0, PS_ALM_0, 0, 1)
REG32(IMR_1, 0x1c)
    FIELD(IMR_1, ADDR_DECODE_ERR, 31, 1)
    FIELD(IMR_1, ADDR_DECODE_ERR_PL_SYSMON, 30, 1)
    FIELD(IMR_1, ADDR_DECODE_ERR_PS_SYSMON, 29, 1)
    FIELD(IMR_1, EOS, 4, 1)
    FIELD(IMR_1, EOC, 3, 1)
    FIELD(IMR_1, PL_OT, 2, 1)
    FIELD(IMR_1, PS_LPD_OT, 1, 1)
    FIELD(IMR_1, PS_FPD_OT, 0, 1)
REG32(IER_0, 0x20)
    FIELD(IER_0, PL_ALM_15, 31, 1)
    FIELD(IER_0, PL_ALM_14, 30, 1)
    FIELD(IER_0, PL_ALM_13, 29, 1)
    FIELD(IER_0, PL_ALM_12, 28, 1)
    FIELD(IER_0, PL_ALM_11, 27, 1)
    FIELD(IER_0, PL_ALM_10, 26, 1)
    FIELD(IER_0, PL_ALM_9, 25, 1)
    FIELD(IER_0, PL_ALM_8, 24, 1)
    FIELD(IER_0, PL_ALM_7, 23, 1)
    FIELD(IER_0, PL_ALM_6, 22, 1)
    FIELD(IER_0, PL_ALM_5, 21, 1)
    FIELD(IER_0, PL_ALM_4, 20, 1)
    FIELD(IER_0, PL_ALM_3, 19, 1)
    FIELD(IER_0, PL_ALM_2, 18, 1)
    FIELD(IER_0, PL_ALM_1, 17, 1)
    FIELD(IER_0, PL_ALM_0, 16, 1)
    FIELD(IER_0, PS_ALM_15, 15, 1)
    FIELD(IER_0, PS_ALM_14, 14, 1)
    FIELD(IER_0, PS_ALM_13, 13, 1)
    FIELD(IER_0, PS_ALM_12, 12, 1)
    FIELD(IER_0, PS_ALM_11, 11, 1)
    FIELD(IER_0, PS_ALM_10, 10, 1)
    FIELD(IER_0, PS_ALM_9, 9, 1)
    FIELD(IER_0, PS_ALM_8, 8, 1)
    FIELD(IER_0, PS_ALM_7, 7, 1)
    FIELD(IER_0, PS_ALM_6, 6, 1)
    FIELD(IER_0, PS_ALM_5, 5, 1)
    FIELD(IER_0, PS_ALM_4, 4, 1)
    FIELD(IER_0, PS_ALM_3, 3, 1)
    FIELD(IER_0, PS_ALM_2, 2, 1)
    FIELD(IER_0, PS_ALM_1, 1, 1)
    FIELD(IER_0, PS_ALM_0, 0, 1)
REG32(IER_1, 0x24)
    FIELD(IER_1, ADDR_DECODE_ERR, 31, 1)
    FIELD(IER_1, ADDR_DECODE_ERR_PL_SYSMON, 30, 1)
    FIELD(IER_1, ADDR_DECODE_ERR_PS_SYSMON, 29, 1)
    FIELD(IER_1, EOS, 4, 1)
    FIELD(IER_1, EOC, 3, 1)
    FIELD(IER_1, PL_OT, 2, 1)
    FIELD(IER_1, PS_LPD_OT, 1, 1)
    FIELD(IER_1, PS_FPD_OT, 0, 1)
REG32(IDR_0, 0x28)
    FIELD(IDR_0, PL_ALM_15, 31, 1)
    FIELD(IDR_0, PL_ALM_14, 30, 1)
    FIELD(IDR_0, PL_ALM_13, 29, 1)
    FIELD(IDR_0, PL_ALM_12, 28, 1)
    FIELD(IDR_0, PL_ALM_11, 27, 1)
    FIELD(IDR_0, PL_ALM_10, 26, 1)
    FIELD(IDR_0, PL_ALM_9, 25, 1)
    FIELD(IDR_0, PL_ALM_8, 24, 1)
    FIELD(IDR_0, PL_ALM_7, 23, 1)
    FIELD(IDR_0, PL_ALM_6, 22, 1)
    FIELD(IDR_0, PL_ALM_5, 21, 1)
    FIELD(IDR_0, PL_ALM_4, 20, 1)
    FIELD(IDR_0, PL_ALM_3, 19, 1)
    FIELD(IDR_0, PL_ALM_2, 18, 1)
    FIELD(IDR_0, PL_ALM_1, 17, 1)
    FIELD(IDR_0, PL_ALM_0, 16, 1)
    FIELD(IDR_0, PS_ALM_15, 15, 1)
    FIELD(IDR_0, PS_ALM_14, 14, 1)
    FIELD(IDR_0, PS_ALM_13, 13, 1)
    FIELD(IDR_0, PS_ALM_12, 12, 1)
    FIELD(IDR_0, PS_ALM_11, 11, 1)
    FIELD(IDR_0, PS_ALM_10, 10, 1)
    FIELD(IDR_0, PS_ALM_9, 9, 1)
    FIELD(IDR_0, PS_ALM_8, 8, 1)
    FIELD(IDR_0, PS_ALM_7, 7, 1)
    FIELD(IDR_0, PS_ALM_6, 6, 1)
    FIELD(IDR_0, PS_ALM_5, 5, 1)
    FIELD(IDR_0, PS_ALM_4, 4, 1)
    FIELD(IDR_0, PS_ALM_3, 3, 1)
    FIELD(IDR_0, PS_ALM_2, 2, 1)
    FIELD(IDR_0, PS_ALM_1, 1, 1)
    FIELD(IDR_0, PS_ALM_0, 0, 1)
REG32(IDR_1, 0x2c)
    FIELD(IDR_1, ADDR_DECODE_ERR, 31, 1)
    FIELD(IDR_1, ADDR_DECODE_ERR_PL_SYSMON, 30, 1)
    FIELD(IDR_1, ADDR_DECODE_ERR_PS_SYSMON, 29, 1)
    FIELD(IDR_1, EOS, 4, 1)
    FIELD(IDR_1, EOC, 3, 1)
    FIELD(IDR_1, PL_OT, 2, 1)
    FIELD(IDR_1, PS_LPD_OT, 1, 1)
    FIELD(IDR_1, PS_FPD_OT, 0, 1)
REG32(ITR_0, 0x30)
    FIELD(ITR_0, PL_ALM_15, 31, 1)
    FIELD(ITR_0, PL_ALM_14, 30, 1)
    FIELD(ITR_0, PL_ALM_13, 29, 1)
    FIELD(ITR_0, PL_ALM_12, 28, 1)
    FIELD(ITR_0, PL_ALM_11, 27, 1)
    FIELD(ITR_0, PL_ALM_10, 26, 1)
    FIELD(ITR_0, PL_ALM_9, 25, 1)
    FIELD(ITR_0, PL_ALM_8, 24, 1)
    FIELD(ITR_0, PL_ALM_7, 23, 1)
    FIELD(ITR_0, PL_ALM_6, 22, 1)
    FIELD(ITR_0, PL_ALM_5, 21, 1)
    FIELD(ITR_0, PL_ALM_4, 20, 1)
    FIELD(ITR_0, PL_ALM_3, 19, 1)
    FIELD(ITR_0, PL_ALM_2, 18, 1)
    FIELD(ITR_0, PL_ALM_1, 17, 1)
    FIELD(ITR_0, PL_ALM_0, 16, 1)
    FIELD(ITR_0, PS_ALM_15, 15, 1)
    FIELD(ITR_0, PS_ALM_14, 14, 1)
    FIELD(ITR_0, PS_ALM_13, 13, 1)
    FIELD(ITR_0, PS_ALM_12, 12, 1)
    FIELD(ITR_0, PS_ALM_11, 11, 1)
    FIELD(ITR_0, PS_ALM_10, 10, 1)
    FIELD(ITR_0, PS_ALM_9, 9, 1)
    FIELD(ITR_0, PS_ALM_8, 8, 1)
    FIELD(ITR_0, PS_ALM_7, 7, 1)
    FIELD(ITR_0, PS_ALM_6, 6, 1)
    FIELD(ITR_0, PS_ALM_5, 5, 1)
    FIELD(ITR_0, PS_ALM_4, 4, 1)
    FIELD(ITR_0, PS_ALM_3, 3, 1)
    FIELD(ITR_0, PS_ALM_2, 2, 1)
    FIELD(ITR_0, PS_ALM_1, 1, 1)
    FIELD(ITR_0, PS_ALM_0, 0, 1)
REG32(ITR_1, 0x34)
    FIELD(ITR_1, ADDR_DECODE_ERR, 31, 1)
    FIELD(ITR_1, ADDR_DECODE_ERR_PL_SYSMON, 30, 1)
    FIELD(ITR_1, ADDR_DECODE_ERR_PS_SYSMON, 29, 1)
    FIELD(ITR_1, EOS, 4, 1)
    FIELD(ITR_1, EOC, 3, 1)
    FIELD(ITR_1, PL_OT, 2, 1)
    FIELD(ITR_1, PS_LPD_OT, 1, 1)
    FIELD(ITR_1, PS_FPD_OT, 0, 1)
REG32(PS_SYSMON_CONTROL_STATUS, 0x40)
    FIELD(PS_SYSMON_CONTROL_STATUS, STARTUP_STATE, 24, 4)
    FIELD(PS_SYSMON_CONTROL_STATUS, STARTUP_DONE, 16, 1)
    FIELD(PS_SYSMON_CONTROL_STATUS, AUTO_CONVST, 3, 1)
    FIELD(PS_SYSMON_CONTROL_STATUS, CONVST, 2, 1)
    FIELD(PS_SYSMON_CONTROL_STATUS, RESET_USER, 1, 1)
    FIELD(PS_SYSMON_CONTROL_STATUS, STARTUP_TRIGGER, 0, 1)
REG32(PL_SYSMON_CONTROL_STATUS, 0x44)
    FIELD(PL_SYSMON_CONTROL_STATUS, ACCESSIBLE, 0, 1)
REG32(MON_STATUS, 0x50)
    FIELD(MON_STATUS, JTAG_LOCKED, 23, 1)
    FIELD(MON_STATUS, BUSY, 22, 1)
    FIELD(MON_STATUS, CHANNEL, 16, 6)
    FIELD(MON_STATUS, MON_DATA, 0, 16)
REG32(VCC_PSPLL0, 0x60)
    FIELD(VCC_PSPLL0, VALUE, 0, 16)
REG32(VCC_PSPLL1, 0x64)
    FIELD(VCC_PSPLL1, VALUE, 0, 16)
REG32(VCC_PSPLL2, 0x68)
    FIELD(VCC_PSPLL2, VALUE, 0, 16)
REG32(VCC_PSPLL3, 0x6c)
    FIELD(VCC_PSPLL3, VALUE, 0, 16)
REG32(VCC_PSPLL4, 0x70)
    FIELD(VCC_PSPLL4, VALUE, 0, 16)
REG32(VCC_PSBATT, 0x74)
    FIELD(VCC_PSBATT, VALUE, 0, 16)
REG32(VCCINT, 0x78)
    FIELD(VCCINT, VALUE, 0, 16)
REG32(VCCBRAM, 0x7c)
    FIELD(VCCBRAM, VALUE, 0, 16)
REG32(VCCAUX, 0x80)
    FIELD(VCCAUX, VALUE, 0, 16)
REG32(VCC_PSDDRPLL, 0x84)
    FIELD(VCC_PSDDRPLL, VALUE, 0, 16)
REG32(DDRPHY_VREF, 0x88)
    FIELD(DDRPHY_VREF, VALUE, 0, 16)
REG32(DDRPHY_ATO, 0x8c)
    FIELD(DDRPHY_ATO, VALUE, 0, 16)
REG32(PSGT_AT0, 0x90)
    FIELD(PSGT_AT0, VALUE, 0, 16)
REG32(PSGT_AT1, 0x94)
    FIELD(PSGT_AT1, VALUE, 0, 16)
REG32(RESERVE0, 0x98)
    FIELD(RESERVE0, VALUE, 0, 16)
REG32(RESERVE1, 0x9c)
    FIELD(RESERVE1, VALUE, 0, 16)

#define AMS_R_MAX (R_RESERVE1 + 1)

typedef struct AMS {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr_0;
    qemu_irq irq_imr_1;

    uint32_t regs[AMS_R_MAX];
    RegisterInfo regs_info[AMS_R_MAX];
} AMS;

static void imr_0_update_irq(AMS *s)
{
    bool pending = s->regs[R_ISR_0] & ~s->regs[R_IMR_0];
    qemu_set_irq(s->irq_imr_0, pending);
}

static void isr_0_postw(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    imr_0_update_irq(s);
}

static uint64_t ier_0_prew(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR_0] &= ~val;
    imr_0_update_irq(s);
    return 0;
}

static uint64_t idr_0_prew(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR_0] |= val;
    imr_0_update_irq(s);
    return 0;
}

static uint64_t itr_0_prew(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR_0] |= val;
    imr_0_update_irq(s);
    return 0;
}

static void imr_1_update_irq(AMS *s)
{
    bool pending = s->regs[R_ISR_1] & ~s->regs[R_IMR_1];
    qemu_set_irq(s->irq_imr_1, pending);
}

static void isr_1_postw(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    imr_1_update_irq(s);
}

static uint64_t ier_1_prew(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR_1] &= ~val;
    imr_1_update_irq(s);
    return 0;
}

static uint64_t idr_1_prew(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR_1] |= val;
    imr_1_update_irq(s);
    return 0;
}

static uint64_t itr_1_prew(RegisterInfo *reg, uint64_t val64)
{
    AMS *s = XILINX_AMS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR_1] |= val;
    imr_1_update_irq(s);
    return 0;
}

static const RegisterAccessInfo ams_regs_info[] = {
    {   .name = "MISC_CTRL",  .addr = A_MISC_CTRL,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ISR_0",  .addr = A_ISR_0,
        .w1c = 0xffffffff,
        .post_write = isr_0_postw,
    },{ .name = "ISR_1",  .addr = A_ISR_1,
        .rsvd = 0x1fffffe0,
        .ro = 0x1fffffe0,
        .w1c = 0xe000001f,
        .post_write = isr_1_postw,
    },{ .name = "IMR_0",  .addr = A_IMR_0,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "IMR_1",  .addr = A_IMR_1,
        .reset = 0xe000001f,
        .rsvd = 0x1fffffe0,
        .ro = 0xffffffff,
    },{ .name = "IER_0",  .addr = A_IER_0,
        .pre_write = ier_0_prew,
    },{ .name = "IER_1",  .addr = A_IER_1,
        .rsvd = 0x1fffffe0,
        .ro = 0x1fffffe0,
        .pre_write = ier_1_prew,
    },{ .name = "IDR_0",  .addr = A_IDR_0,
        .pre_write = idr_0_prew,
    },{ .name = "IDR_1",  .addr = A_IDR_1,
        .rsvd = 0x1fffffe0,
        .ro = 0x1fffffe0,
        .pre_write = idr_1_prew,
    },{ .name = "ITR_0",  .addr = A_ITR_0,
        .pre_write = itr_0_prew,
    },{ .name = "ITR_1",  .addr = A_ITR_1,
        .rsvd = 0x1fffffe0,
        .ro = 0x1fffffe0,
        .pre_write = itr_1_prew,
    },{ .name = "PS_SYSMON_CONTROL_STATUS",  .addr = A_PS_SYSMON_CONTROL_STATUS,
        .rsvd = 0xf0fefff0,
        .ro = 0xfffffff0,
    },{ .name = "PL_SYSMON_CONTROL_STATUS",  .addr = A_PL_SYSMON_CONTROL_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "MON_STATUS",  .addr = A_MON_STATUS,
        .rsvd = 0xff000000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSPLL0",  .addr = A_VCC_PSPLL0,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSPLL1",  .addr = A_VCC_PSPLL1,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSPLL2",  .addr = A_VCC_PSPLL2,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSPLL3",  .addr = A_VCC_PSPLL3,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSPLL4",  .addr = A_VCC_PSPLL4,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSBATT",  .addr = A_VCC_PSBATT,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCCINT",  .addr = A_VCCINT,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCCBRAM",  .addr = A_VCCBRAM,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCCAUX",  .addr = A_VCCAUX,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "VCC_PSDDRPLL",  .addr = A_VCC_PSDDRPLL,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "DDRPHY_VREF",  .addr = A_DDRPHY_VREF,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "DDRPHY_ATO",  .addr = A_DDRPHY_ATO,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "PSGT_AT0",  .addr = A_PSGT_AT0,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "PSGT_AT1",  .addr = A_PSGT_AT1,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "RESERVE0",  .addr = A_RESERVE0,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "RESERVE1",  .addr = A_RESERVE1,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    }
};

static void ams_reset(DeviceState *dev)
{
    AMS *s = XILINX_AMS(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    imr_0_update_irq(s);
    imr_1_update_irq(s);
}

static const MemoryRegionOps ams_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void ams_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void ams_init(Object *obj)
{
    AMS *s = XILINX_AMS(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_AMS, AMS_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), ams_regs_info,
                              ARRAY_SIZE(ams_regs_info),
                              s->regs_info, s->regs,
                              &ams_ops,
                              XILINX_AMS_ERR_DEBUG,
                              AMS_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr_0);
    sysbus_init_irq(sbd, &s->irq_imr_1);
}

static const VMStateDescription vmstate_ams = {
    .name = TYPE_XILINX_AMS,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, AMS, AMS_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void ams_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = ams_reset;
    dc->realize = ams_realize;
    dc->vmsd = &vmstate_ams;
}

static const TypeInfo ams_info = {
    .name          = TYPE_XILINX_AMS,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(AMS),
    .class_init    = ams_class_init,
    .instance_init = ams_init,
};

static void ams_register_types(void)
{
    type_register_static(&ams_info);
}

type_init(ams_register_types)
