/*
 * QEMU model of the DDR_PHY DDR PHY Register Description
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-09-18.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_DDR_PHY_ERR_DEBUG
#define XILINX_DDR_PHY_ERR_DEBUG 0
#endif

#define TYPE_XILINX_DDR_PHY "xlnx.zynqmp-ddr-phy"

#define XILINX_DDR_PHY(obj) \
     OBJECT_CHECK(DDR_PHY, (obj), TYPE_XILINX_DDR_PHY)

REG32(PIR, 0x4)
    FIELD(PIR, RESERVED_31, 31, 1)
    FIELD(PIR, ZCALBYP, 30, 1)
    FIELD(PIR, DCALPSE, 29, 1)
    FIELD(PIR, RESERVED_28_21, 21, 8)
    FIELD(PIR, DQS2DQ, 20, 1)
    FIELD(PIR, RDIMMINIT, 19, 1)
    FIELD(PIR, CTLDINIT, 18, 1)
    FIELD(PIR, VREF, 17, 1)
    FIELD(PIR, SRD, 16, 1)
    FIELD(PIR, WREYE, 15, 1)
    FIELD(PIR, RDEYE, 14, 1)
    FIELD(PIR, WRDSKW, 13, 1)
    FIELD(PIR, RDDSKW, 12, 1)
    FIELD(PIR, WLADJ, 11, 1)
    FIELD(PIR, QSGATE, 10, 1)
    FIELD(PIR, WL, 9, 1)
    FIELD(PIR, DRAMINIT, 8, 1)
    FIELD(PIR, DRAMRST, 7, 1)
    FIELD(PIR, PHYRST, 6, 1)
    FIELD(PIR, DCAL, 5, 1)
    FIELD(PIR, PLLINIT, 4, 1)
    FIELD(PIR, RESERVED_3, 3, 1)
    FIELD(PIR, CA, 2, 1)
    FIELD(PIR, ZCAL, 1, 1)
    FIELD(PIR, INIT, 0, 1)
REG32(PGCR0, 0x10)
    FIELD(PGCR0, ADCP, 31, 1)
    FIELD(PGCR0, RESERVED_30_27, 27, 4)
    FIELD(PGCR0, PHYFRST, 26, 1)
    FIELD(PGCR0, OSCACDL, 24, 2)
    FIELD(PGCR0, RESERVED_23_19, 19, 5)
    FIELD(PGCR0, DTOSEL, 14, 5)
    FIELD(PGCR0, RESERVED_13, 13, 1)
    FIELD(PGCR0, OSCDIV, 9, 4)
    FIELD(PGCR0, OSCEN, 8, 1)
    FIELD(PGCR0, RESERVED_7_0, 0, 8)
REG32(PGCR2, 0x18)
    FIELD(PGCR2, CLRTSTAT, 31, 1)
    FIELD(PGCR2, CLRZCAL, 30, 1)
    FIELD(PGCR2, CLRPERR, 29, 1)
    FIELD(PGCR2, ICPC, 28, 1)
    FIELD(PGCR2, DTPMXTMR, 20, 8)
    FIELD(PGCR2, INITFSMBYP, 19, 1)
    FIELD(PGCR2, PLLFSMBYP, 18, 1)
    FIELD(PGCR2, TREFPRD, 0, 18)
REG32(PGCR3, 0x1c)
    FIELD(PGCR3, CKNEN, 24, 4)
    FIELD(PGCR3, CKEN, 16, 4)
    FIELD(PGCR3, RESERVED_15, 15, 1)
    FIELD(PGCR3, GATEACRDCLK, 13, 2)
    FIELD(PGCR3, GATEACDDRCLK, 11, 2)
    FIELD(PGCR3, GATEACCTLCLK, 9, 2)
    FIELD(PGCR3, RESERVED_8, 8, 1)
    FIELD(PGCR3, DDLBYPMODE, 6, 2)
    FIELD(PGCR3, IOLB, 5, 1)
    FIELD(PGCR3, RDMODE, 3, 2)
    FIELD(PGCR3, DISRST, 2, 1)
    FIELD(PGCR3, CLKLEVEL, 0, 2)
REG32(PGCR4, 0x20)
    FIELD(PGCR4, RESERVED_31_30, 30, 2)
    FIELD(PGCR4, ACDDLLD, 29, 1)
    FIELD(PGCR4, ACDDLBYP, 24, 5)
    FIELD(PGCR4, OEDDLBYP, 23, 1)
    FIELD(PGCR4, TEDDLBYP, 22, 1)
    FIELD(PGCR4, PDRDDLBYP, 21, 1)
    FIELD(PGCR4, RRRMODE, 20, 1)
    FIELD(PGCR4, WRRMODE, 19, 1)
    FIELD(PGCR4, RESERVED_18_8, 8, 11)
    FIELD(PGCR4, LPWAKEUP_THRSH, 4, 4)
    FIELD(PGCR4, RESERVED_3_2, 2, 2)
    FIELD(PGCR4, LPPLLPD, 1, 1)
    FIELD(PGCR4, LPIOPD, 0, 1)
REG32(PGCR5, 0x24)
    FIELD(PGCR5, FRQBT, 24, 8)
    FIELD(PGCR5, FRQAT, 16, 8)
    FIELD(PGCR5, DISCNPERIOD, 8, 8)
    FIELD(PGCR5, VREF_RBCTRL, 4, 4)
    FIELD(PGCR5, RESERVED_3, 3, 1)
    FIELD(PGCR5, DXREFISELRANGE, 2, 1)
    FIELD(PGCR5, DDLPGACT, 1, 1)
    FIELD(PGCR5, DDLPGRW, 0, 1)
REG32(PGCR6, 0x28)
    FIELD(PGCR6, RESERVED_31_24, 24, 8)
    FIELD(PGCR6, DLDLMT, 16, 8)
    FIELD(PGCR6, RESERVED_15_14, 14, 2)
    FIELD(PGCR6, ACDLVT, 13, 1)
    FIELD(PGCR6, ACBVT, 12, 1)
    FIELD(PGCR6, ODTBVT, 11, 1)
    FIELD(PGCR6, CKEBVT, 10, 1)
    FIELD(PGCR6, CSNBVT, 9, 1)
    FIELD(PGCR6, CKBVT, 8, 1)
    FIELD(PGCR6, RESERVED_7_1, 1, 7)
    FIELD(PGCR6, INHVT, 0, 1)
REG32(PGCR7, 0x2c)
    FIELD(PGCR7, RESERVED_31_8, 8, 24)
    FIELD(PGCR7, ACRSVD_7_6, 6, 2)
    FIELD(PGCR7, ACCALCLK, 5, 1)
    FIELD(PGCR7, ACRCLKMD, 4, 1)
    FIELD(PGCR7, ACDLDT, 3, 1)
    FIELD(PGCR7, ACRSVD_2, 2, 1)
    FIELD(PGCR7, ACDTOSEL, 1, 1)
    FIELD(PGCR7, ACTMODE, 0, 1)
REG32(PGSR0, 0x30)
    FIELD(PGSR0, APLOCK, 31, 1)
    FIELD(PGSR0, SRDERR, 30, 1)
    FIELD(PGSR0, CAWRN, 29, 1)
    FIELD(PGSR0, CAERR, 28, 1)
    FIELD(PGSR0, WEERR, 27, 1)
    FIELD(PGSR0, REERR, 26, 1)
    FIELD(PGSR0, WDERR, 25, 1)
    FIELD(PGSR0, RDERR, 24, 1)
    FIELD(PGSR0, WLAERR, 23, 1)
    FIELD(PGSR0, QSGERR, 22, 1)
    FIELD(PGSR0, WLERR, 21, 1)
    FIELD(PGSR0, ZCERR, 20, 1)
    FIELD(PGSR0, VERR, 19, 1)
    FIELD(PGSR0, DQS2DQERR, 18, 1)
    FIELD(PGSR0, RESERVED_17_16, 16, 2)
    FIELD(PGSR0, DQS2DQDONE, 15, 1)
    FIELD(PGSR0, VDONE, 14, 1)
    FIELD(PGSR0, SRDDONE, 13, 1)
    FIELD(PGSR0, CADONE, 12, 1)
    FIELD(PGSR0, WEDONE, 11, 1)
    FIELD(PGSR0, REDONE, 10, 1)
    FIELD(PGSR0, WDDONE, 9, 1)
    FIELD(PGSR0, RDDONE, 8, 1)
    FIELD(PGSR0, WLADONE, 7, 1)
    FIELD(PGSR0, QSGDONE, 6, 1)
    FIELD(PGSR0, WLDONE, 5, 1)
    FIELD(PGSR0, DIDONE, 4, 1)
    FIELD(PGSR0, ZCDONE, 3, 1)
    FIELD(PGSR0, DCDONE, 2, 1)
    FIELD(PGSR0, PLDONE, 1, 1)
    FIELD(PGSR0, IDONE, 0, 1)
REG32(PGSR1, 0x34)
    FIELD(PGSR1, PARERR, 31, 1)
    FIELD(PGSR1, VTSTOP, 30, 1)
    FIELD(PGSR1, RESERVED_29_25, 25, 5)
    FIELD(PGSR1, DLTCODE, 1, 24)
    FIELD(PGSR1, DLTDONE, 0, 1)
REG32(PGSR2, 0x38)
    FIELD(PGSR2, RESERVED_31_25, 25, 7)
    FIELD(PGSR2, DLTCODE, 1, 24)
    FIELD(PGSR2, DLTDONE, 0, 1)
REG32(PTR0, 0x40)
    FIELD(PTR0, TPLLPD, 21, 11)
    FIELD(PTR0, TPLLGS, 6, 15)
    FIELD(PTR0, TPHYRST, 0, 6)
REG32(PTR1, 0x44)
    FIELD(PTR1, TPLLLOCK, 16, 16)
    FIELD(PTR1, RESERVED_15_13, 13, 3)
    FIELD(PTR1, TPLLRST, 0, 13)
REG32(PTR2, 0x48)
    FIELD(PTR2, RESERVED_31_20, 20, 12)
    FIELD(PTR2, TWLDLYS, 15, 5)
    FIELD(PTR2, TCALH, 10, 5)
    FIELD(PTR2, TCALS, 5, 5)
    FIELD(PTR2, TCALON, 0, 5)
REG32(PTR3, 0x4c)
    FIELD(PTR3, RESERVED_31_23, 23, 9)
    FIELD(PTR3, TDINIT0, 0, 23)
REG32(PTR4, 0x50)
    FIELD(PTR4, RESERVED_31_13, 13, 19)
    FIELD(PTR4, TDINIT1, 0, 13)
REG32(PTR5, 0x54)
    FIELD(PTR5, RESERVED_31_19, 19, 13)
    FIELD(PTR5, TDINIT2, 0, 19)
REG32(PTR6, 0x58)
    FIELD(PTR6, RESERVED_31_27, 27, 5)
    FIELD(PTR6, TDINIT4, 20, 7)
    FIELD(PTR6, RESERVED_19_12, 12, 8)
    FIELD(PTR6, TDINIT3, 0, 12)
REG32(PLLCR0, 0x68)
    FIELD(PLLCR0, PLLBYP, 31, 1)
    FIELD(PLLCR0, PLLRST, 30, 1)
    FIELD(PLLCR0, PLLPD, 29, 1)
    FIELD(PLLCR0, RSTOPM, 28, 1)
    FIELD(PLLCR0, FRQSEL, 24, 4)
    FIELD(PLLCR0, RLOCKM, 23, 1)
    FIELD(PLLCR0, CPPC, 17, 6)
    FIELD(PLLCR0, CPIC, 13, 4)
    FIELD(PLLCR0, GSHIFT, 12, 1)
    FIELD(PLLCR0, RESERVED_11_9, 9, 3)
    FIELD(PLLCR0, ATOEN, 8, 1)
    FIELD(PLLCR0, ATC, 4, 4)
    FIELD(PLLCR0, DTC, 0, 4)
REG32(PLLCR1, 0x6c)
    FIELD(PLLCR1, PLLPROG, 16, 16)
    FIELD(PLLCR1, RESERVED_15_6, 6, 10)
    FIELD(PLLCR1, BYPVREGCP, 5, 1)
    FIELD(PLLCR1, BYPVREGDIG, 4, 1)
    FIELD(PLLCR1, BYPVDD, 3, 1)
    FIELD(PLLCR1, LOCKPS, 2, 1)
    FIELD(PLLCR1, LOCKCS, 1, 1)
    FIELD(PLLCR1, LOCKDS, 0, 1)
REG32(PLLCR2, 0x70)
REG32(PLLCR3, 0x74)
REG32(PLLCR4, 0x78)
REG32(PLLCR5, 0x7c)
    FIELD(PLLCR5, RESERVED_31_8, 8, 24)
    FIELD(PLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DXCCR, 0x88)
    FIELD(DXCCR, RESERVED_31_30, 30, 2)
    FIELD(DXCCR, RKLOOP, 29, 1)
    FIELD(DXCCR, RESERVED_28_7, 7, 22)
    FIELD(DXCCR, DQS2DQMPER, 3, 4)
    FIELD(DXCCR, RESERVED_2_0, 0, 3)
REG32(DSGCR, 0x90)
    FIELD(DSGCR, RESERVED_31_28, 28, 4)
    FIELD(DSGCR, RDBICLSEL, 27, 1)
    FIELD(DSGCR, RDBICL, 24, 3)
    FIELD(DSGCR, PHYZUEN, 23, 1)
    FIELD(DSGCR, RESERVED_22, 22, 1)
    FIELD(DSGCR, RSTOE, 21, 1)
    FIELD(DSGCR, SDRMODE, 19, 2)
    FIELD(DSGCR, RESERVED_18, 18, 1)
    FIELD(DSGCR, ATOAE, 17, 1)
    FIELD(DSGCR, DTOOE, 16, 1)
    FIELD(DSGCR, DTOIOM, 15, 1)
    FIELD(DSGCR, DTOPDR, 14, 1)
    FIELD(DSGCR, RESERVED_13, 13, 1)
    FIELD(DSGCR, DTOODT, 12, 1)
    FIELD(DSGCR, PUAD, 6, 6)
    FIELD(DSGCR, CUAEN, 5, 1)
    FIELD(DSGCR, RESERVED_4_3, 3, 2)
    FIELD(DSGCR, CTLZUEN, 2, 1)
    FIELD(DSGCR, RESERVED_1, 1, 1)
    FIELD(DSGCR, PUREN, 0, 1)
REG32(ODTCR, 0x98)
    FIELD(ODTCR, RESERVED_31_28, 28, 4)
    FIELD(ODTCR, WRODT_RSVD, 18, 10)
    FIELD(ODTCR, WRODT, 16, 2)
    FIELD(ODTCR, RESERVED_15_12, 12, 4)
    FIELD(ODTCR, RDODT_RSVD, 2, 10)
    FIELD(ODTCR, RDODT, 0, 2)
REG32(AACR, 0xa0)
    FIELD(AACR, AAOENC, 31, 1)
    FIELD(AACR, AAENC, 30, 1)
    FIELD(AACR, AATR, 0, 30)
REG32(GPR0, 0xc0)
    FIELD(GPR0, PLL_RETRY, 16, 16)
    FIELD(GPR0, ZDDR_VERSION, 0, 16)
REG32(GPR1, 0xc4)
REG32(DCR, 0x100)
    FIELD(DCR, GEARDN, 31, 1)
    FIELD(DCR, UBG, 30, 1)
    FIELD(DCR, UDIMM, 29, 1)
    FIELD(DCR, DDR2T, 28, 1)
    FIELD(DCR, NOSRA, 27, 1)
    FIELD(DCR, RESERVED_26_18, 18, 9)
    FIELD(DCR, BYTEMASK, 10, 8)
    FIELD(DCR, DDRTYPE, 8, 2)
    FIELD(DCR, MPRDQ, 7, 1)
    FIELD(DCR, PDQ, 4, 3)
    FIELD(DCR, DDR8BNK, 3, 1)
    FIELD(DCR, DDRMD, 0, 3)
REG32(DTPR0, 0x110)
    FIELD(DTPR0, RESERVED_31_29, 29, 3)
    FIELD(DTPR0, TRRD, 24, 5)
    FIELD(DTPR0, RESERVED_23, 23, 1)
    FIELD(DTPR0, TRAS, 16, 7)
    FIELD(DTPR0, RESERVED_15, 15, 1)
    FIELD(DTPR0, TRP, 8, 7)
    FIELD(DTPR0, RESERVED_7_5, 5, 3)
    FIELD(DTPR0, TRTP, 0, 5)
REG32(DTPR1, 0x114)
    FIELD(DTPR1, RESERVED_31, 31, 1)
    FIELD(DTPR1, TWLMRD, 24, 7)
    FIELD(DTPR1, RESERVED_23, 23, 1)
    FIELD(DTPR1, TFAW, 16, 7)
    FIELD(DTPR1, RESERVED_15_11, 11, 5)
    FIELD(DTPR1, TMOD, 8, 3)
    FIELD(DTPR1, RESERVED_7_5, 5, 3)
    FIELD(DTPR1, TMRD, 0, 5)
REG32(DTPR2, 0x118)
    FIELD(DTPR2, RESERVED_31_29, 29, 3)
    FIELD(DTPR2, TRTW, 28, 1)
    FIELD(DTPR2, RESERVED_27_25, 25, 3)
    FIELD(DTPR2, TRTODT, 24, 1)
    FIELD(DTPR2, RESERVED_23_20, 20, 4)
    FIELD(DTPR2, TCKE, 16, 4)
    FIELD(DTPR2, RESERVED_15_10, 10, 6)
    FIELD(DTPR2, TXS, 0, 10)
REG32(DTPR3, 0x11c)
    FIELD(DTPR3, TOFDX, 29, 3)
    FIELD(DTPR3, TCCD, 26, 3)
    FIELD(DTPR3, TDLLK, 16, 10)
    FIELD(DTPR3, RESERVED_15_12, 12, 4)
    FIELD(DTPR3, TDQSCKMAX, 8, 4)
    FIELD(DTPR3, RESERVED_7_3, 3, 5)
    FIELD(DTPR3, TDQSCK, 0, 3)
REG32(DTPR4, 0x120)
    FIELD(DTPR4, RESERVED_31_30, 30, 2)
    FIELD(DTPR4, TAOND_TAOFD, 28, 2)
    FIELD(DTPR4, RESERVED_27_26, 26, 2)
    FIELD(DTPR4, TRFC, 16, 10)
    FIELD(DTPR4, RESERVED_15_14, 14, 2)
    FIELD(DTPR4, TWLO, 8, 6)
    FIELD(DTPR4, RESERVED_7_5, 5, 3)
    FIELD(DTPR4, TXP, 0, 5)
REG32(DTPR5, 0x124)
    FIELD(DTPR5, RESERVED_31_24, 24, 8)
    FIELD(DTPR5, TRC, 16, 8)
    FIELD(DTPR5, RESERVED_15, 15, 1)
    FIELD(DTPR5, TRCD, 8, 7)
    FIELD(DTPR5, RESERVED_7_5, 5, 3)
    FIELD(DTPR5, TWTR, 0, 5)
REG32(DTPR6, 0x128)
    FIELD(DTPR6, PUBWLEN, 31, 1)
    FIELD(DTPR6, PUBRLEN, 30, 1)
    FIELD(DTPR6, RESERVED_29_14, 14, 16)
    FIELD(DTPR6, PUBWL, 8, 6)
    FIELD(DTPR6, RESERVED_7_6, 6, 2)
    FIELD(DTPR6, PUBRL, 0, 6)
REG32(RDIMMGCR0, 0x140)
    FIELD(RDIMMGCR0, RESERVED_31, 31, 1)
    FIELD(RDIMMGCR0, QCSEN, 30, 1)
    FIELD(RDIMMGCR0, RESERVED_29_28, 28, 2)
    FIELD(RDIMMGCR0, RDIMMIOM, 27, 1)
    FIELD(RDIMMGCR0, RESERVED_26_24, 24, 3)
    FIELD(RDIMMGCR0, ERROUTOE, 23, 1)
    FIELD(RDIMMGCR0, ERROUTIOM, 22, 1)
    FIELD(RDIMMGCR0, ERROUTPDR, 21, 1)
    FIELD(RDIMMGCR0, RESERVED_20, 20, 1)
    FIELD(RDIMMGCR0, ERROUTODT, 19, 1)
    FIELD(RDIMMGCR0, LRDIMM, 18, 1)
    FIELD(RDIMMGCR0, PARINIOM, 17, 1)
    FIELD(RDIMMGCR0, RESERVED_16_8, 8, 9)
    FIELD(RDIMMGCR0, RNKMRREN_RSVD, 6, 2)
    FIELD(RDIMMGCR0, RNKMRREN, 4, 2)
    FIELD(RDIMMGCR0, RESERVED_3, 3, 1)
    FIELD(RDIMMGCR0, SOPERR, 2, 1)
    FIELD(RDIMMGCR0, ERRNOREG, 1, 1)
    FIELD(RDIMMGCR0, RDIMM, 0, 1)
REG32(RDIMMGCR1, 0x144)
    FIELD(RDIMMGCR1, RESERVED_31_29, 29, 3)
    FIELD(RDIMMGCR1, A17BID, 28, 1)
    FIELD(RDIMMGCR1, RESERVED_27, 27, 1)
    FIELD(RDIMMGCR1, TBCMRD_L2, 24, 3)
    FIELD(RDIMMGCR1, RESERVED_23, 23, 1)
    FIELD(RDIMMGCR1, TBCMRD_L, 20, 3)
    FIELD(RDIMMGCR1, RESERVED_19, 19, 1)
    FIELD(RDIMMGCR1, TBCMRD, 16, 3)
    FIELD(RDIMMGCR1, RESERVED_15_14, 14, 2)
    FIELD(RDIMMGCR1, TBCSTAB, 0, 14)
REG32(RDIMMGCR2, 0x148)
REG32(RDIMMCR0, 0x150)
    FIELD(RDIMMCR0, RC7, 28, 4)
    FIELD(RDIMMCR0, RC6, 24, 4)
    FIELD(RDIMMCR0, RC5, 20, 4)
    FIELD(RDIMMCR0, RC4, 16, 4)
    FIELD(RDIMMCR0, RC3, 12, 4)
    FIELD(RDIMMCR0, RC2, 8, 4)
    FIELD(RDIMMCR0, RC1, 4, 4)
    FIELD(RDIMMCR0, RC0, 0, 4)
REG32(RDIMMCR1, 0x154)
    FIELD(RDIMMCR1, RC15, 28, 4)
    FIELD(RDIMMCR1, RC14, 24, 4)
    FIELD(RDIMMCR1, RC13, 20, 4)
    FIELD(RDIMMCR1, RC12, 16, 4)
    FIELD(RDIMMCR1, RC11, 12, 4)
    FIELD(RDIMMCR1, RC10, 8, 4)
    FIELD(RDIMMCR1, RC9, 4, 4)
    FIELD(RDIMMCR1, RC8, 0, 4)
REG32(RDIMMCR2, 0x158)
    FIELD(RDIMMCR2, RC4X, 24, 8)
    FIELD(RDIMMCR2, RC3X, 16, 8)
    FIELD(RDIMMCR2, RC2X, 8, 8)
    FIELD(RDIMMCR2, RC1X, 0, 8)
REG32(RDIMMCR3, 0x15c)
    FIELD(RDIMMCR3, RC8X, 24, 8)
    FIELD(RDIMMCR3, RC7X, 16, 8)
    FIELD(RDIMMCR3, RC6X, 8, 8)
    FIELD(RDIMMCR3, RC5X, 0, 8)
REG32(RDIMMCR4, 0x160)
    FIELD(RDIMMCR4, RCXX, 24, 8)
    FIELD(RDIMMCR4, RCBX, 16, 8)
    FIELD(RDIMMCR4, RCAX, 8, 8)
    FIELD(RDIMMCR4, RC9X, 0, 8)
REG32(SCHCR0, 0x168)
    FIELD(SCHCR0, RESERVED_31_25, 25, 7)
    FIELD(SCHCR0, SCHDQV, 16, 9)
    FIELD(SCHCR0, RESERVED_15_12, 12, 4)
    FIELD(SCHCR0, SP_CMD, 8, 4)
    FIELD(SCHCR0, CMD, 4, 4)
    FIELD(SCHCR0, SCHTRIG, 0, 4)
REG32(SCHCR1, 0x16c)
    FIELD(SCHCR1, SCRNK, 28, 4)
    FIELD(SCHCR1, SCADDR, 8, 20)
    FIELD(SCHCR1, SCBG, 6, 2)
    FIELD(SCHCR1, SCBK, 4, 2)
    FIELD(SCHCR1, RESERVED_3, 3, 1)
    FIELD(SCHCR1, ALLRANK, 2, 1)
    FIELD(SCHCR1, RESERVED_1_0, 0, 2)
REG32(MR0, 0x180)
    FIELD(MR0, RESERVED_31_16, 16, 16)
    FIELD(MR0, RSVD_15_8, 8, 8)
    FIELD(MR0, CATR, 7, 1)
    FIELD(MR0, RSVD_6_5, 5, 2)
    FIELD(MR0, RZQI, 3, 2)
    FIELD(MR0, RSVD_2_0, 0, 3)
REG32(MR1, 0x184)
    FIELD(MR1, RESERVED_31_16, 16, 16)
    FIELD(MR1, RSVD, 8, 8)
    FIELD(MR1, RDPST, 7, 1)
    FIELD(MR1, NWR, 4, 3)
    FIELD(MR1, RDPRE, 3, 1)
    FIELD(MR1, WRPRE, 2, 1)
    FIELD(MR1, BL, 0, 2)
REG32(MR2, 0x188)
    FIELD(MR2, RESERVED_31_16, 16, 16)
    FIELD(MR2, RSVD, 8, 8)
    FIELD(MR2, WRL, 7, 1)
    FIELD(MR2, WLS, 6, 1)
    FIELD(MR2, WL, 3, 3)
    FIELD(MR2, RL, 0, 3)
REG32(MR3, 0x18c)
    FIELD(MR3, RESERVED_31_8, 8, 24)
    FIELD(MR3, DBIWR, 7, 1)
    FIELD(MR3, DBIRD, 6, 1)
    FIELD(MR3, PDDS, 3, 3)
    FIELD(MR3, RSVD, 2, 1)
    FIELD(MR3, WRPST, 1, 1)
    FIELD(MR3, PUCAL, 0, 1)
REG32(MR4, 0x190)
    FIELD(MR4, RESERVED_31_8, 8, 24)
    FIELD(MR4, RSVD, 0, 8)
REG32(MR5, 0x194)
    FIELD(MR5, RESERVED_31_8, 8, 24)
    FIELD(MR5, RSVD, 0, 8)
REG32(MR6, 0x198)
    FIELD(MR6, RESERVED_31_8, 8, 24)
    FIELD(MR6, RSVD, 0, 8)
REG32(MR7, 0x19c)
    FIELD(MR7, RESERVED_31_8, 8, 24)
    FIELD(MR7, RSVD, 0, 8)
REG32(MR11, 0x1ac)
    FIELD(MR11, RESERVED_31_16, 16, 16)
    FIELD(MR11, RSVD_15_8, 8, 8)
    FIELD(MR11, RSVD_7, 7, 1)
    FIELD(MR11, CAODT, 4, 3)
    FIELD(MR11, RSVD_3, 3, 1)
    FIELD(MR11, DQODT, 0, 3)
REG32(MR12, 0x1b0)
    FIELD(MR12, RESERVED_31_8, 8, 24)
    FIELD(MR12, RSVD, 7, 1)
    FIELD(MR12, VR_CA, 6, 1)
    FIELD(MR12, VREF_CA, 0, 6)
REG32(MR13, 0x1b4)
    FIELD(MR13, RESERVED_31_8, 8, 24)
    FIELD(MR13, FSPOP, 7, 1)
    FIELD(MR13, FSPWR, 6, 1)
    FIELD(MR13, DMD, 5, 1)
    FIELD(MR13, RRO, 4, 1)
    FIELD(MR13, VRCG, 3, 1)
    FIELD(MR13, VRO, 2, 1)
    FIELD(MR13, RPT, 1, 1)
    FIELD(MR13, CBT, 0, 1)
REG32(MR14, 0x1b8)
    FIELD(MR14, RESERVED_31_8, 8, 24)
    FIELD(MR14, RSVD, 7, 1)
    FIELD(MR14, VR_DQ, 6, 1)
    FIELD(MR14, VREF_DQ, 0, 6)
REG32(MR22, 0x1d8)
    FIELD(MR22, RESERVED_31_8, 8, 24)
    FIELD(MR22, RSVD, 6, 2)
    FIELD(MR22, ODTD_CA, 5, 1)
    FIELD(MR22, ODTE_CS, 4, 1)
    FIELD(MR22, ODTE_CK, 3, 1)
    FIELD(MR22, CODT, 0, 3)
REG32(DTCR0, 0x200)
    FIELD(DTCR0, RFSHDT, 28, 4)
    FIELD(DTCR0, RESERVED_27_26, 26, 2)
    FIELD(DTCR0, DTDRS, 24, 2)
    FIELD(DTCR0, DTEXG, 23, 1)
    FIELD(DTCR0, DTEXD, 22, 1)
    FIELD(DTCR0, DTDSTP, 21, 1)
    FIELD(DTCR0, DTDEN, 20, 1)
    FIELD(DTCR0, DTDBS, 16, 4)
    FIELD(DTCR0, DTRDBITR, 14, 2)
    FIELD(DTCR0, RESERVED_13, 13, 1)
    FIELD(DTCR0, DTWBDDM, 12, 1)
    FIELD(DTCR0, RFSHEN, 8, 4)
    FIELD(DTCR0, DTCMPD, 7, 1)
    FIELD(DTCR0, DTMPR, 6, 1)
    FIELD(DTCR0, RESERVED_5, 5, 1)
    FIELD(DTCR0, INCWEYE, 4, 1)
    FIELD(DTCR0, DTRPTN, 0, 4)
REG32(DTCR1, 0x204)
    FIELD(DTCR1, RANKEN_RSVD, 18, 14)
    FIELD(DTCR1, RANKEN, 16, 2)
    FIELD(DTCR1, RESERVED_15_14, 14, 2)
    FIELD(DTCR1, DTRANK, 12, 2)
    FIELD(DTCR1, RESERVED_11, 11, 1)
    FIELD(DTCR1, RDLVLGDIFF, 8, 3)
    FIELD(DTCR1, RESERVED_7, 7, 1)
    FIELD(DTCR1, RDLVLGS, 4, 3)
    FIELD(DTCR1, RESERVED_3, 3, 1)
    FIELD(DTCR1, RDPRMVL_TRN, 2, 1)
    FIELD(DTCR1, RDLVLEN, 1, 1)
    FIELD(DTCR1, BSTEN, 0, 1)
REG32(DTAR0, 0x208)
    FIELD(DTAR0, RESERVED_31_30, 30, 2)
    FIELD(DTAR0, MPRLOC, 28, 2)
    FIELD(DTAR0, DTBGBK1, 24, 4)
    FIELD(DTAR0, DTBGBK0, 20, 4)
    FIELD(DTAR0, RESERVED_19_18, 18, 2)
    FIELD(DTAR0, DTROW, 0, 18)
REG32(DTAR1, 0x20c)
    FIELD(DTAR1, RESERVED_31_25, 25, 7)
    FIELD(DTAR1, DTCOL1, 16, 9)
    FIELD(DTAR1, RESERVED_15_9, 9, 7)
    FIELD(DTAR1, DTCOL0, 0, 9)
REG32(DTAR2, 0x210)
    FIELD(DTAR2, RESERVED_31_25, 25, 7)
    FIELD(DTAR2, DTCOL3, 16, 9)
    FIELD(DTAR2, RESERVED_15_9, 9, 7)
    FIELD(DTAR2, DTCOL2, 0, 9)
REG32(DTDR0, 0x218)
    FIELD(DTDR0, DTBYTE3, 24, 8)
    FIELD(DTDR0, DTBYTE2, 16, 8)
    FIELD(DTDR0, DTBYTE1, 8, 8)
    FIELD(DTDR0, DTBYTE0, 0, 8)
REG32(DTDR1, 0x21c)
    FIELD(DTDR1, DTBYTE7, 24, 8)
    FIELD(DTDR1, DTBYTE6, 16, 8)
    FIELD(DTDR1, DTBYTE5, 8, 8)
    FIELD(DTDR1, DTBYTE4, 0, 8)
REG32(DTEDR0, 0x230)
    FIELD(DTEDR0, RESERVED_31_30, 30, 2)
    FIELD(DTEDR0, WDQBMX, 24, 6)
    FIELD(DTEDR0, WDQBMN, 18, 6)
    FIELD(DTEDR0, RESERVED_17_9, 9, 9)
    FIELD(DTEDR0, RESERVED_8_0, 0, 9)
REG32(DTEDR1, 0x234)
    FIELD(DTEDR1, RESERVED_31_30, 30, 2)
    FIELD(DTEDR1, RDQSBMX, 24, 6)
    FIELD(DTEDR1, RDQSBMN, 18, 6)
    FIELD(DTEDR1, RDQSLMX, 9, 9)
    FIELD(DTEDR1, RDQSLMN, 0, 9)
REG32(DTEDR2, 0x238)
    FIELD(DTEDR2, RESERVED_31_30, 30, 2)
    FIELD(DTEDR2, RDQSNBMX, 24, 6)
    FIELD(DTEDR2, RDQSNBMN, 18, 6)
    FIELD(DTEDR2, RDQSNLMX, 9, 9)
    FIELD(DTEDR2, RDQSNLMN, 0, 9)
REG32(VTDR, 0x23c)
    FIELD(VTDR, RESERVED_31, 31, 1)
    FIELD(VTDR, HVREFMX, 24, 7)
    FIELD(VTDR, RESERVED_23, 23, 1)
    FIELD(VTDR, HVREFMN, 16, 7)
    FIELD(VTDR, RESERVED_15_14, 14, 2)
    FIELD(VTDR, DVREFMX, 8, 6)
    FIELD(VTDR, RESERVED_7_6, 6, 2)
    FIELD(VTDR, DVREFMN, 0, 6)
REG32(CATR0, 0x240)
    FIELD(CATR0, RESERVED_31_21, 21, 11)
    FIELD(CATR0, CACD, 16, 5)
    FIELD(CATR0, RESERVED_15_13, 13, 3)
    FIELD(CATR0, CAADR, 8, 5)
    FIELD(CATR0, CA1BYTE1, 4, 4)
    FIELD(CATR0, CA1BYTE0, 0, 4)
REG32(CATR1, 0x244)
    FIELD(CATR1, RESERVED_31_28, 28, 4)
    FIELD(CATR1, CA0BYTE1, 24, 4)
    FIELD(CATR1, CA0BYTE0, 20, 4)
    FIELD(CATR1, CAMRZ, 16, 4)
    FIELD(CATR1, CACKEH, 12, 4)
    FIELD(CATR1, CACKEL, 8, 4)
    FIELD(CATR1, CAEXT, 4, 4)
    FIELD(CATR1, CAENT, 0, 4)
REG32(DQSDR0, 0x250)
    FIELD(DQSDR0, DFTDLY, 28, 4)
    FIELD(DQSDR0, DFTZQUP, 27, 1)
    FIELD(DQSDR0, DFTDDLUP, 26, 1)
    FIELD(DQSDR0, RESERVED_25_22, 22, 4)
    FIELD(DQSDR0, DFTRDSPC, 20, 2)
    FIELD(DQSDR0, DFTB2BRD, 16, 4)
    FIELD(DQSDR0, DFTIDLRD, 12, 4)
    FIELD(DQSDR0, RESERVED_11_8, 8, 4)
    FIELD(DQSDR0, DFTGPULSE, 4, 4)
    FIELD(DQSDR0, DFTUPMODE, 2, 2)
    FIELD(DQSDR0, DFTDTMODE, 1, 1)
    FIELD(DQSDR0, DFTDTEN, 0, 1)
REG32(DQSDR1, 0x254)
    FIELD(DQSDR1, DFTUPDACKF, 29, 3)
    FIELD(DQSDR1, DFTUPDACKC, 24, 5)
    FIELD(DQSDR1, DFTRDB2BF, 20, 4)
    FIELD(DQSDR1, DFTRDIDLF, 16, 4)
    FIELD(DQSDR1, DFTRDB2BC, 8, 8)
    FIELD(DQSDR1, DFTRDIDLC, 0, 8)
REG32(DQSDR2, 0x258)
    FIELD(DQSDR2, RESERVED_31_24, 24, 8)
    FIELD(DQSDR2, DFTTHRSH, 16, 8)
    FIELD(DQSDR2, DFTMNTPRD, 0, 16)
REG32(DTEDR3, 0x25c)
    FIELD(DTEDR3, RESERVED_31_27, 27, 5)
    FIELD(DTEDR3, WDQLMX, 16, 11)
    FIELD(DTEDR3, RESERVED_15_11, 11, 5)
    FIELD(DTEDR3, WDQLMN, 0, 11)
REG32(DCUAR, 0x300)
    FIELD(DCUAR, RESERVED_31_20, 20, 12)
    FIELD(DCUAR, CSADDR_R, 16, 4)
    FIELD(DCUAR, CWADDR_R, 12, 4)
    FIELD(DCUAR, ATYPE, 11, 1)
    FIELD(DCUAR, INCA, 10, 1)
    FIELD(DCUAR, CSEL, 8, 2)
    FIELD(DCUAR, CSADDR_W, 4, 4)
    FIELD(DCUAR, CWADDR_W, 0, 4)
REG32(DCUDR, 0x304)
REG32(DCURR, 0x308)
    FIELD(DCURR, RESERVED_31_24, 24, 8)
    FIELD(DCURR, XCEN, 23, 1)
    FIELD(DCURR, RCEN, 22, 1)
    FIELD(DCURR, SCOF, 21, 1)
    FIELD(DCURR, SONF, 20, 1)
    FIELD(DCURR, NFAIL, 12, 8)
    FIELD(DCURR, EADDR, 8, 4)
    FIELD(DCURR, SADDR, 4, 4)
    FIELD(DCURR, DINST, 0, 4)
REG32(DCULR, 0x30c)
    FIELD(DCULR, XLEADDR, 28, 4)
    FIELD(DCULR, RESERVED_27_18, 18, 10)
    FIELD(DCULR, IDA, 17, 1)
    FIELD(DCULR, LINF, 16, 1)
    FIELD(DCULR, LCNT, 8, 8)
    FIELD(DCULR, LEADDR, 4, 4)
    FIELD(DCULR, LSADDR, 0, 4)
REG32(DCUGCR, 0x310)
    FIELD(DCUGCR, RESERVED_31_16, 16, 16)
    FIELD(DCUGCR, RCSW, 0, 16)
REG32(DCUTPR, 0x314)
    FIELD(DCUTPR, TDCUT2, 16, 16)
    FIELD(DCUTPR, TDCUT1, 8, 8)
    FIELD(DCUTPR, TDCUT0, 0, 8)
REG32(DCUSR0, 0x318)
    FIELD(DCUSR0, RESERVED_31_3, 3, 29)
    FIELD(DCUSR0, CFULL, 2, 1)
    FIELD(DCUSR0, CFAIL, 1, 1)
    FIELD(DCUSR0, RDONE, 0, 1)
REG32(DCUSR1, 0x31c)
    FIELD(DCUSR1, LPCNT, 24, 8)
    FIELD(DCUSR1, FLCNT, 16, 8)
    FIELD(DCUSR1, RDCNT, 0, 16)
REG32(RANKIDR, 0x4dc)
    FIELD(RANKIDR, RESERVED_31_20, 20, 12)
    FIELD(RANKIDR, RANKRID, 16, 4)
    FIELD(RANKIDR, RESERVED_15_4, 4, 12)
    FIELD(RANKIDR, RANKWID, 0, 4)
REG32(RIOCR0, 0x4e0)
REG32(RIOCR1, 0x4e4)
REG32(RIOCR2, 0x4e8)
    FIELD(RIOCR2, RESERVED_31_30, 30, 2)
    FIELD(RIOCR2, COEMODE_RSVD, 26, 4)
    FIELD(RIOCR2, COEMODE, 24, 2)
    FIELD(RIOCR2, CSOEMODE_RSVD, 4, 20)
    FIELD(RIOCR2, CSOEMODE, 0, 4)
REG32(RIOCR3, 0x4ec)
REG32(RIOCR4, 0x4f0)
    FIELD(RIOCR4, RESERVED_31_16, 16, 16)
    FIELD(RIOCR4, CKEOEMODE_RSVD, 4, 12)
    FIELD(RIOCR4, CKEOEMODE, 0, 4)
REG32(RIOCR5, 0x4f4)
    FIELD(RIOCR5, RESERVED_31_16, 16, 16)
    FIELD(RIOCR5, ODTOEMODE_RSVD, 4, 12)
    FIELD(RIOCR5, ODTOEMODE, 0, 4)
REG32(ACIOCR0, 0x500)
    FIELD(ACIOCR0, ACSR, 30, 2)
    FIELD(ACIOCR0, RSTIOM, 29, 1)
    FIELD(ACIOCR0, RSTPDR, 28, 1)
    FIELD(ACIOCR0, RESERVED_27, 27, 1)
    FIELD(ACIOCR0, RSTODT, 26, 1)
    FIELD(ACIOCR0, RESERVED_25_10, 10, 16)
    FIELD(ACIOCR0, CKDCC, 6, 4)
    FIELD(ACIOCR0, ACPDRMODE, 4, 2)
    FIELD(ACIOCR0, ACODTMODE, 2, 2)
    FIELD(ACIOCR0, RESERVED_1, 1, 1)
    FIELD(ACIOCR0, ACRANKCLKSEL, 0, 1)
REG32(ACIOCR1, 0x504)
REG32(ACIOCR2, 0x508)
    FIELD(ACIOCR2, CLKGENCLKGATE, 31, 1)
    FIELD(ACIOCR2, ACOECLKGATE0, 30, 1)
    FIELD(ACIOCR2, ACPDRCLKGATE0, 29, 1)
    FIELD(ACIOCR2, ACTECLKGATE0, 28, 1)
    FIELD(ACIOCR2, CKNCLKGATE0, 26, 2)
    FIELD(ACIOCR2, CKCLKGATE0, 24, 2)
    FIELD(ACIOCR2, ACCLKGATE0, 0, 24)
REG32(ACIOCR3, 0x50c)
    FIELD(ACIOCR3, PAROEMODE, 30, 2)
    FIELD(ACIOCR3, BGOEMODE, 26, 4)
    FIELD(ACIOCR3, BAOEMODE, 22, 4)
    FIELD(ACIOCR3, A17OEMODE, 20, 2)
    FIELD(ACIOCR3, A16OEMODE, 18, 2)
    FIELD(ACIOCR3, ACTOEMODE, 16, 2)
    FIELD(ACIOCR3, RESERVED_15_8, 8, 8)
    FIELD(ACIOCR3, CKOEMODE_RSVD, 4, 4)
    FIELD(ACIOCR3, CKOEMODE, 0, 4)
REG32(ACIOCR4, 0x510)
    FIELD(ACIOCR4, LBCLKGATE, 31, 1)
    FIELD(ACIOCR4, ACOECLKGATE1, 30, 1)
    FIELD(ACIOCR4, ACPDRCLKGATE1, 29, 1)
    FIELD(ACIOCR4, ACTECLKGATE1, 28, 1)
    FIELD(ACIOCR4, CKNCLKGATE1, 26, 2)
    FIELD(ACIOCR4, CKCLKGATE1, 24, 2)
    FIELD(ACIOCR4, ACCLKGATE1, 0, 24)
REG32(ACIOCR5, 0x514)
    FIELD(ACIOCR5, RESERVED_31_28, 28, 4)
    FIELD(ACIOCR5, ACVREFIOM, 25, 3)
    FIELD(ACIOCR5, ACXIOM, 22, 3)
    FIELD(ACIOCR5, ACTXM, 11, 11)
    FIELD(ACIOCR5, ACRXM, 0, 11)
REG32(IOVCR0, 0x520)
    FIELD(IOVCR0, RESERVED_31_29, 29, 3)
    FIELD(IOVCR0, ACREFPEN, 28, 1)
    FIELD(IOVCR0, ACREFEEN, 26, 2)
    FIELD(IOVCR0, ACREFSEN, 25, 1)
    FIELD(IOVCR0, ACREFIEN, 24, 1)
    FIELD(IOVCR0, ACREFESELRANGE, 23, 1)
    FIELD(IOVCR0, ACREFESEL, 16, 7)
    FIELD(IOVCR0, ACREFSSELRANGE, 15, 1)
    FIELD(IOVCR0, ACREFSSEL, 8, 7)
    FIELD(IOVCR0, ACVREFISELRANGE, 7, 1)
    FIELD(IOVCR0, ACVREFISEL, 0, 7)
REG32(IOVCR1, 0x524)
REG32(VTCR0, 0x528)
    FIELD(VTCR0, TVREF, 29, 3)
    FIELD(VTCR0, DVEN, 28, 1)
    FIELD(VTCR0, PDAEN, 27, 1)
    FIELD(VTCR0, RESERVED_26, 26, 1)
    FIELD(VTCR0, VWCR, 22, 4)
    FIELD(VTCR0, DVSS, 18, 4)
    FIELD(VTCR0, DVMAX, 12, 6)
    FIELD(VTCR0, DVMIN, 6, 6)
    FIELD(VTCR0, DVINIT, 0, 6)
REG32(VTCR1, 0x52c)
    FIELD(VTCR1, HVSS, 28, 4)
    FIELD(VTCR1, RESERVED_27, 27, 1)
    FIELD(VTCR1, HVMAX, 20, 7)
    FIELD(VTCR1, RESERVED_19, 19, 1)
    FIELD(VTCR1, HVMIN, 12, 7)
    FIELD(VTCR1, RESERVED_11, 11, 1)
    FIELD(VTCR1, SHRNK, 9, 2)
    FIELD(VTCR1, SHREN, 8, 1)
    FIELD(VTCR1, TVREFIO, 5, 3)
    FIELD(VTCR1, EOFF, 3, 2)
    FIELD(VTCR1, ENUM, 2, 1)
    FIELD(VTCR1, HVEN, 1, 1)
    FIELD(VTCR1, HVIO, 0, 1)
REG32(ACBDLR0, 0x540)
    FIELD(ACBDLR0, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR0, CK3BD, 24, 6)
    FIELD(ACBDLR0, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR0, CK2BD, 16, 6)
    FIELD(ACBDLR0, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR0, CK1BD, 8, 6)
    FIELD(ACBDLR0, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR0, CK0BD, 0, 6)
REG32(ACBDLR1, 0x544)
    FIELD(ACBDLR1, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR1, PARBD, 24, 6)
    FIELD(ACBDLR1, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR1, A16BD, 16, 6)
    FIELD(ACBDLR1, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR1, A17BD, 8, 6)
    FIELD(ACBDLR1, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR1, ACTBD, 0, 6)
REG32(ACBDLR2, 0x548)
    FIELD(ACBDLR2, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR2, BG1BD, 24, 6)
    FIELD(ACBDLR2, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR2, BG0BD, 16, 6)
    FIELD(ACBDLR2, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR2, BA1BD, 8, 6)
    FIELD(ACBDLR2, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR2, BA0BD, 0, 6)
REG32(ACBDLR3, 0x54c)
    FIELD(ACBDLR3, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR3, CS3BD, 24, 6)
    FIELD(ACBDLR3, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR3, CS2BD, 16, 6)
    FIELD(ACBDLR3, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR3, CS1BD, 8, 6)
    FIELD(ACBDLR3, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR3, CS0BD, 0, 6)
REG32(ACBDLR4, 0x550)
    FIELD(ACBDLR4, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR4, ODT3BD, 24, 6)
    FIELD(ACBDLR4, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR4, ODT2BD, 16, 6)
    FIELD(ACBDLR4, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR4, ODT1BD, 8, 6)
    FIELD(ACBDLR4, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR4, ODT0BD, 0, 6)
REG32(ACBDLR5, 0x554)
    FIELD(ACBDLR5, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR5, CKE3BD, 24, 6)
    FIELD(ACBDLR5, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR5, CKE2BD, 16, 6)
    FIELD(ACBDLR5, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR5, CKE1BD, 8, 6)
    FIELD(ACBDLR5, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR5, CKE0BD, 0, 6)
REG32(ACBDLR6, 0x558)
    FIELD(ACBDLR6, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR6, A03BD, 24, 6)
    FIELD(ACBDLR6, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR6, A02BD, 16, 6)
    FIELD(ACBDLR6, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR6, A01BD, 8, 6)
    FIELD(ACBDLR6, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR6, A00BD, 0, 6)
REG32(ACBDLR7, 0x55c)
    FIELD(ACBDLR7, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR7, A07BD, 24, 6)
    FIELD(ACBDLR7, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR7, A06BD, 16, 6)
    FIELD(ACBDLR7, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR7, A05BD, 8, 6)
    FIELD(ACBDLR7, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR7, A04BD, 0, 6)
REG32(ACBDLR8, 0x560)
    FIELD(ACBDLR8, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR8, A11BD, 24, 6)
    FIELD(ACBDLR8, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR8, A10BD, 16, 6)
    FIELD(ACBDLR8, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR8, A09BD, 8, 6)
    FIELD(ACBDLR8, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR8, A08BD, 0, 6)
REG32(ACBDLR9, 0x564)
    FIELD(ACBDLR9, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR9, A15BD, 24, 6)
    FIELD(ACBDLR9, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR9, A14BD, 16, 6)
    FIELD(ACBDLR9, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR9, A13BD, 8, 6)
    FIELD(ACBDLR9, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR9, A12BD, 0, 6)
REG32(ACBDLR15, 0x57c)
    FIELD(ACBDLR15, RESERVED_31_22, 22, 10)
    FIELD(ACBDLR15, OEBD, 16, 6)
    FIELD(ACBDLR15, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR15, TEBD, 8, 6)
    FIELD(ACBDLR15, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR15, PDRBD, 0, 6)
REG32(ACBDLR16, 0x580)
    FIELD(ACBDLR16, RESERVED_31_30, 30, 2)
    FIELD(ACBDLR16, CKN3BD, 24, 6)
    FIELD(ACBDLR16, RESERVED_23_22, 22, 2)
    FIELD(ACBDLR16, CKN2BD, 16, 6)
    FIELD(ACBDLR16, RESERVED_15_14, 14, 2)
    FIELD(ACBDLR16, CKN1BD, 8, 6)
    FIELD(ACBDLR16, RESERVED_7_6, 6, 2)
    FIELD(ACBDLR16, CKN0BD, 0, 6)
REG32(ACLCDLR, 0x584)
    FIELD(ACLCDLR, RESERVED_31_25, 25, 7)
    FIELD(ACLCDLR, ACD1, 16, 9)
    FIELD(ACLCDLR, RESERVED_15_9, 9, 7)
    FIELD(ACLCDLR, ACD, 0, 9)
REG32(ACMDLR0, 0x5a0)
    FIELD(ACMDLR0, RESERVED_31_25, 25, 7)
    FIELD(ACMDLR0, TPRD, 16, 9)
    FIELD(ACMDLR0, RESERVED_15_9, 9, 7)
    FIELD(ACMDLR0, IPRD, 0, 9)
REG32(ACMDLR1, 0x5a4)
    FIELD(ACMDLR1, RESERVED_31_25, 25, 7)
    FIELD(ACMDLR1, MDLD1, 16, 9)
    FIELD(ACMDLR1, RESERVED_15_9, 9, 7)
    FIELD(ACMDLR1, MDLD, 0, 9)
REG32(ZQCR, 0x680)
    FIELD(ZQCR, RESERVED_31_26, 26, 6)
    FIELD(ZQCR, ZQREFISELRANGE, 25, 1)
    FIELD(ZQCR, PGWAIT_FRQB, 19, 6)
    FIELD(ZQCR, PGWAIT_FRQA, 13, 6)
    FIELD(ZQCR, ZQREFPEN, 12, 1)
    FIELD(ZQCR, ZQREFIEN, 11, 1)
    FIELD(ZQCR, ODT_MODE, 9, 2)
    FIELD(ZQCR, FORCE_ZCAL_VT_UPDATE, 8, 1)
    FIELD(ZQCR, IODLMT, 5, 3)
    FIELD(ZQCR, AVGEN, 4, 1)
    FIELD(ZQCR, AVGMAX, 2, 2)
    FIELD(ZQCR, ZCALT, 1, 1)
    FIELD(ZQCR, ZQPD, 0, 1)
REG32(ZQ0PR0, 0x684)
    FIELD(ZQ0PR0, PD_DRV_ZDEN, 31, 1)
    FIELD(ZQ0PR0, PU_DRV_ZDEN, 30, 1)
    FIELD(ZQ0PR0, PD_ODT_ZDEN, 29, 1)
    FIELD(ZQ0PR0, PU_ODT_ZDEN, 28, 1)
    FIELD(ZQ0PR0, ZSEGBYP, 27, 1)
    FIELD(ZQ0PR0, ZLE_MODE, 25, 2)
    FIELD(ZQ0PR0, ODT_ADJUST, 22, 3)
    FIELD(ZQ0PR0, PD_DRV_ADJUST, 19, 3)
    FIELD(ZQ0PR0, PU_DRV_ADJUST, 16, 3)
    FIELD(ZQ0PR0, ZPROG_DRAM_ODT, 12, 4)
    FIELD(ZQ0PR0, ZPROG_HOST_ODT, 8, 4)
    FIELD(ZQ0PR0, ZPROG_ASYM_DRV_PD, 4, 4)
    FIELD(ZQ0PR0, ZPROG_ASYM_DRV_PU, 0, 4)
REG32(ZQ0PR1, 0x688)
    FIELD(ZQ0PR1, RESERVED_31_15, 15, 17)
    FIELD(ZQ0PR1, PU_REFSEL, 8, 7)
    FIELD(ZQ0PR1, RESERVED_7, 7, 1)
    FIELD(ZQ0PR1, PD_REFSEL, 0, 7)
REG32(ZQ0DR0, 0x68c)
    FIELD(ZQ0DR0, RESERVED_31_26, 26, 6)
    FIELD(ZQ0DR0, ZDATA_PU_DRV_RESULT, 16, 10)
    FIELD(ZQ0DR0, RESERVED_15_10, 10, 6)
    FIELD(ZQ0DR0, ZDATA_PD_DRV_RESULT, 0, 10)
REG32(ZQ0DR1, 0x690)
    FIELD(ZQ0DR1, RESERVED_31_26, 26, 6)
    FIELD(ZQ0DR1, ZDATA_PU_ODT_RESULT, 16, 10)
    FIELD(ZQ0DR1, RESERVED_15_10, 10, 6)
    FIELD(ZQ0DR1, ZDATA_PD_ODT_RESULT, 0, 10)
REG32(ZQ0OR0, 0x694)
    FIELD(ZQ0OR0, RESERVED_31_26, 26, 6)
    FIELD(ZQ0OR0, ZDATA_PU_DRV_OVRD, 16, 10)
    FIELD(ZQ0OR0, RESERVED_15_10, 10, 6)
    FIELD(ZQ0OR0, ZDATA_PD_DRV_OVRD, 0, 10)
REG32(ZQ0OR1, 0x698)
    FIELD(ZQ0OR1, RESERVED_31_26, 26, 6)
    FIELD(ZQ0OR1, ZDATA_PU_ODT_OVRD, 16, 10)
    FIELD(ZQ0OR1, RESERVED_15_10, 10, 6)
    FIELD(ZQ0OR1, ZDATA_PD_ODT_OVRD, 0, 10)
REG32(ZQ0SR, 0x69c)
    FIELD(ZQ0SR, RESERVED_31_14, 14, 18)
    FIELD(ZQ0SR, PD_ODT_SAT, 13, 1)
    FIELD(ZQ0SR, PU_ODT_SAT, 12, 1)
    FIELD(ZQ0SR, PD_DRV_SAT, 11, 1)
    FIELD(ZQ0SR, PU_DRV_SAT, 10, 1)
    FIELD(ZQ0SR, ZDONE, 9, 1)
    FIELD(ZQ0SR, ZERR, 8, 1)
    FIELD(ZQ0SR, OPU, 6, 2)
    FIELD(ZQ0SR, OPD, 4, 2)
    FIELD(ZQ0SR, ZPU, 2, 2)
    FIELD(ZQ0SR, ZPD, 0, 2)
REG32(ZQ1PR0, 0x6a4)
    FIELD(ZQ1PR0, PD_DRV_ZDEN, 31, 1)
    FIELD(ZQ1PR0, PU_DRV_ZDEN, 30, 1)
    FIELD(ZQ1PR0, PD_ODT_ZDEN, 29, 1)
    FIELD(ZQ1PR0, PU_ODT_ZDEN, 28, 1)
    FIELD(ZQ1PR0, ZSEGBYP, 27, 1)
    FIELD(ZQ1PR0, ZLE_MODE, 25, 2)
    FIELD(ZQ1PR0, ODT_ADJUST, 22, 3)
    FIELD(ZQ1PR0, PD_DRV_ADJUST, 19, 3)
    FIELD(ZQ1PR0, PU_DRV_ADJUST, 16, 3)
    FIELD(ZQ1PR0, ZPROG_DRAM_ODT, 12, 4)
    FIELD(ZQ1PR0, ZPROG_HOST_ODT, 8, 4)
    FIELD(ZQ1PR0, ZPROG_ASYM_DRV_PD, 4, 4)
    FIELD(ZQ1PR0, ZPROG_ASYM_DRV_PU, 0, 4)
REG32(ZQ1PR1, 0x6a8)
    FIELD(ZQ1PR1, RESERVED_31_15, 15, 17)
    FIELD(ZQ1PR1, PU_REFSEL, 8, 7)
    FIELD(ZQ1PR1, RESERVED_7, 7, 1)
    FIELD(ZQ1PR1, PD_REFSEL, 0, 7)
REG32(ZQ1DR0, 0x6ac)
    FIELD(ZQ1DR0, RESERVED_31_26, 26, 6)
    FIELD(ZQ1DR0, ZDATA_PU_DRV_RESULT, 16, 10)
    FIELD(ZQ1DR0, RESERVED_15_10, 10, 6)
    FIELD(ZQ1DR0, ZDATA_PD_DRV_RESULT, 0, 10)
REG32(ZQ1DR1, 0x6b0)
    FIELD(ZQ1DR1, RESERVED_31_26, 26, 6)
    FIELD(ZQ1DR1, ZDATA_PU_ODT_RESULT, 16, 10)
    FIELD(ZQ1DR1, RESERVED_15_10, 10, 6)
    FIELD(ZQ1DR1, ZDATA_PD_ODT_RESULT, 0, 10)
REG32(ZQ1OR0, 0x6b4)
    FIELD(ZQ1OR0, RESERVED_31_26, 26, 6)
    FIELD(ZQ1OR0, ZDATA_PU_DRV_OVRD, 16, 10)
    FIELD(ZQ1OR0, RESERVED_15_10, 10, 6)
    FIELD(ZQ1OR0, ZDATA_PD_DRV_OVRD, 0, 10)
REG32(ZQ1OR1, 0x6b8)
    FIELD(ZQ1OR1, RESERVED_31_26, 26, 6)
    FIELD(ZQ1OR1, ZDATA_PU_ODT_OVRD, 16, 10)
    FIELD(ZQ1OR1, RESERVED_15_10, 10, 6)
    FIELD(ZQ1OR1, ZDATA_PD_ODT_OVRD, 0, 10)
REG32(ZQ1SR, 0x6bc)
    FIELD(ZQ1SR, RESERVED_31_14, 14, 18)
    FIELD(ZQ1SR, PD_ODT_SAT, 13, 1)
    FIELD(ZQ1SR, PU_ODT_SAT, 12, 1)
    FIELD(ZQ1SR, PD_DRV_SAT, 11, 1)
    FIELD(ZQ1SR, PU_DRV_SAT, 10, 1)
    FIELD(ZQ1SR, ZDONE, 9, 1)
    FIELD(ZQ1SR, ZERR, 8, 1)
    FIELD(ZQ1SR, OPU, 6, 2)
    FIELD(ZQ1SR, OPD, 4, 2)
    FIELD(ZQ1SR, ZPU, 2, 2)
    FIELD(ZQ1SR, ZPD, 0, 2)
REG32(DX0GCR0, 0x700)
    FIELD(DX0GCR0, CALBYP, 31, 1)
    FIELD(DX0GCR0, MDLEN, 30, 1)
    FIELD(DX0GCR0, CODTSHFT, 28, 2)
    FIELD(DX0GCR0, DQSDCC, 24, 4)
    FIELD(DX0GCR0, RDDLY, 20, 4)
    FIELD(DX0GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX0GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX0GCR0, DQSSEPDR, 12, 1)
    FIELD(DX0GCR0, RTTOAL, 11, 1)
    FIELD(DX0GCR0, RTTOH, 9, 2)
    FIELD(DX0GCR0, CPDRSHFT, 7, 2)
    FIELD(DX0GCR0, DQSRPD, 6, 1)
    FIELD(DX0GCR0, DQSGPDR, 5, 1)
    FIELD(DX0GCR0, RESERVED_4, 4, 1)
    FIELD(DX0GCR0, DQSGODT, 3, 1)
    FIELD(DX0GCR0, DQSGOE, 2, 1)
    FIELD(DX0GCR0, RESERVED_1_0, 0, 2)
REG32(DX0GCR1, 0x704)
    FIELD(DX0GCR1, DXPDRMODE, 16, 16)
    FIELD(DX0GCR1, RESERVED_15, 15, 1)
    FIELD(DX0GCR1, QSNSEL, 14, 1)
    FIELD(DX0GCR1, QSSEL, 13, 1)
    FIELD(DX0GCR1, OEEN, 12, 1)
    FIELD(DX0GCR1, PDREN, 11, 1)
    FIELD(DX0GCR1, TEEN, 10, 1)
    FIELD(DX0GCR1, DSEN, 9, 1)
    FIELD(DX0GCR1, DMEN, 8, 1)
    FIELD(DX0GCR1, DQEN, 0, 8)
REG32(DX0GCR2, 0x708)
    FIELD(DX0GCR2, DXOEMODE, 16, 16)
    FIELD(DX0GCR2, DXTEMODE, 0, 16)
REG32(DX0GCR3, 0x70c)
    FIELD(DX0GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX0GCR3, RDBVT, 29, 1)
    FIELD(DX0GCR3, WDBVT, 28, 1)
    FIELD(DX0GCR3, RGLVT, 27, 1)
    FIELD(DX0GCR3, RDLVT, 26, 1)
    FIELD(DX0GCR3, WDLVT, 25, 1)
    FIELD(DX0GCR3, WLLVT, 24, 1)
    FIELD(DX0GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX0GCR3, DSNOEMODE, 20, 2)
    FIELD(DX0GCR3, DSNTEMODE, 18, 2)
    FIELD(DX0GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX0GCR3, DMOEMODE, 14, 2)
    FIELD(DX0GCR3, DMTEMODE, 12, 2)
    FIELD(DX0GCR3, DMPDRMODE, 10, 2)
    FIELD(DX0GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX0GCR3, DSOEMODE, 6, 2)
    FIELD(DX0GCR3, DSTEMODE, 4, 2)
    FIELD(DX0GCR3, DSPDRMODE, 2, 2)
    FIELD(DX0GCR3, RESERVED_1_0, 0, 2)
REG32(DX0GCR4, 0x710)
    FIELD(DX0GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX0GCR4, DXREFPEN, 28, 1)
    FIELD(DX0GCR4, DXREFEEN, 26, 2)
    FIELD(DX0GCR4, DXREFSEN, 25, 1)
    FIELD(DX0GCR4, RESERVED_24, 24, 1)
    FIELD(DX0GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX0GCR4, DXREFESEL, 16, 7)
    FIELD(DX0GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX0GCR4, DXREFSSEL, 8, 7)
    FIELD(DX0GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX0GCR4, DXREFIEN, 2, 4)
    FIELD(DX0GCR4, DXREFIMON, 0, 2)
REG32(DX0GCR5, 0x714)
    FIELD(DX0GCR5, RESERVED_31, 31, 1)
    FIELD(DX0GCR5, DXREFISELR3, 24, 7)
    FIELD(DX0GCR5, RESERVED_23, 23, 1)
    FIELD(DX0GCR5, DXREFISELR2, 16, 7)
    FIELD(DX0GCR5, RESERVED_15, 15, 1)
    FIELD(DX0GCR5, DXREFISELR1, 8, 7)
    FIELD(DX0GCR5, RESERVED_7, 7, 1)
    FIELD(DX0GCR5, DXREFISELR0, 0, 7)
REG32(DX0GCR6, 0x718)
    FIELD(DX0GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX0GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX0GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX0GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX0GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX0GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX0GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX0GCR6, DXDQVREFR0, 0, 6)
REG32(DX0BDLR0, 0x740)
    FIELD(DX0BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX0BDLR0, DQ3WBD, 24, 6)
    FIELD(DX0BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX0BDLR0, DQ2WBD, 16, 6)
    FIELD(DX0BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX0BDLR0, DQ1WBD, 8, 6)
    FIELD(DX0BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX0BDLR0, DQ0WBD, 0, 6)
REG32(DX0BDLR1, 0x744)
    FIELD(DX0BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX0BDLR1, DQ7WBD, 24, 6)
    FIELD(DX0BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX0BDLR1, DQ6WBD, 16, 6)
    FIELD(DX0BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX0BDLR1, DQ5WBD, 8, 6)
    FIELD(DX0BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX0BDLR1, DQ4WBD, 0, 6)
REG32(DX0BDLR2, 0x748)
    FIELD(DX0BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX0BDLR2, DSNWBD, 24, 6)
    FIELD(DX0BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX0BDLR2, DSOEBD, 16, 6)
    FIELD(DX0BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX0BDLR2, DSWBD, 8, 6)
    FIELD(DX0BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX0BDLR2, DMWBD, 0, 6)
REG32(DX0BDLR3, 0x750)
    FIELD(DX0BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX0BDLR3, DQ3RBD, 24, 6)
    FIELD(DX0BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX0BDLR3, DQ2RBD, 16, 6)
    FIELD(DX0BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX0BDLR3, DQ1RBD, 8, 6)
    FIELD(DX0BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX0BDLR3, DQ0RBD, 0, 6)
REG32(DX0BDLR4, 0x754)
    FIELD(DX0BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX0BDLR4, DQ7RBD, 24, 6)
    FIELD(DX0BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX0BDLR4, DQ6RBD, 16, 6)
    FIELD(DX0BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX0BDLR4, DQ5RBD, 8, 6)
    FIELD(DX0BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX0BDLR4, DQ4RBD, 0, 6)
REG32(DX0BDLR5, 0x758)
    FIELD(DX0BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX0BDLR5, DMRBD, 0, 6)
REG32(DX0BDLR6, 0x760)
    FIELD(DX0BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX0BDLR6, TERBD, 16, 6)
    FIELD(DX0BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX0BDLR6, PDRBD, 8, 6)
    FIELD(DX0BDLR6, RESERVED_7_0, 0, 8)
REG32(DX0LCDLR0, 0x780)
    FIELD(DX0LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX0LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX0LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX0LCDLR0, WLD, 0, 9)
REG32(DX0LCDLR1, 0x784)
    FIELD(DX0LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX0LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX0LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX0LCDLR1, WDQD, 0, 9)
REG32(DX0LCDLR2, 0x788)
    FIELD(DX0LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX0LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX0LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX0LCDLR2, DQSGD, 0, 9)
REG32(DX0LCDLR3, 0x78c)
    FIELD(DX0LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX0LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX0LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX0LCDLR3, RDQSD, 0, 9)
REG32(DX0LCDLR4, 0x790)
    FIELD(DX0LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX0LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX0LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX0LCDLR4, RDQSND, 0, 9)
REG32(DX0LCDLR5, 0x794)
    FIELD(DX0LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX0LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX0LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX0LCDLR5, DQSGSD, 0, 9)
REG32(DX0MDLR0, 0x7a0)
    FIELD(DX0MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX0MDLR0, TPRD, 16, 9)
    FIELD(DX0MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX0MDLR0, IPRD, 0, 9)
REG32(DX0MDLR1, 0x7a4)
    FIELD(DX0MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX0MDLR1, MDLD, 0, 9)
REG32(DX0GTR0, 0x7c0)
    FIELD(DX0GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX0GTR0, WDQSL, 24, 3)
    FIELD(DX0GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX0GTR0, WLSL, 16, 4)
    FIELD(DX0GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX0GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX0GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX0GTR0, DGSL, 0, 5)
REG32(DX0RSR1, 0x7d4)
    FIELD(DX0RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX0RSR1, RDLVLERR, 0, 16)
REG32(DX0RSR2, 0x7d8)
    FIELD(DX0RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX0RSR2, WLAWN, 0, 16)
REG32(DX0RSR3, 0x7dc)
    FIELD(DX0RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX0RSR3, WLAERR, 0, 16)
REG32(DX0GSR0, 0x7e0)
    FIELD(DX0GSR0, RESERVED_31, 31, 1)
    FIELD(DX0GSR0, WLDQ, 30, 1)
    FIELD(DX0GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX0GSR0, GDQSPRD, 17, 9)
    FIELD(DX0GSR0, DPLOCK, 16, 1)
    FIELD(DX0GSR0, WLPRD, 7, 9)
    FIELD(DX0GSR0, WLERR, 6, 1)
    FIELD(DX0GSR0, WLDONE, 5, 1)
    FIELD(DX0GSR0, WLCAL, 4, 1)
    FIELD(DX0GSR0, GDQSCAL, 3, 1)
    FIELD(DX0GSR0, RDQSNCAL, 2, 1)
    FIELD(DX0GSR0, RDQSCAL, 1, 1)
    FIELD(DX0GSR0, WDQCAL, 0, 1)
REG32(DX0GSR1, 0x7e4)
    FIELD(DX0GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX0GSR1, DLTCODE, 1, 24)
    FIELD(DX0GSR1, DLTDONE, 0, 1)
REG32(DX0GSR2, 0x7e8)
    FIELD(DX0GSR2, GSDQSPRD, 23, 9)
    FIELD(DX0GSR2, GSDQSCAL, 22, 1)
    FIELD(DX0GSR2, RESERVED_21, 21, 1)
    FIELD(DX0GSR2, SRDERR, 20, 1)
    FIELD(DX0GSR2, DQS2DQERR, 12, 4)
    FIELD(DX0GSR2, ESTAT, 8, 4)
    FIELD(DX0GSR2, WEWN, 7, 1)
    FIELD(DX0GSR2, WEERR, 6, 1)
    FIELD(DX0GSR2, REWN, 5, 1)
    FIELD(DX0GSR2, REERR, 4, 1)
    FIELD(DX0GSR2, WDWN, 3, 1)
    FIELD(DX0GSR2, WDERR, 2, 1)
    FIELD(DX0GSR2, RDWN, 1, 1)
    FIELD(DX0GSR2, RDERR, 0, 1)
REG32(DX0GSR3, 0x7ec)
    FIELD(DX0GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX0GSR3, ESTAT, 24, 3)
    FIELD(DX0GSR3, DVWRN, 20, 2)
    FIELD(DX0GSR3, DVERR, 16, 2)
    FIELD(DX0GSR3, HVWRN, 12, 2)
    FIELD(DX0GSR3, HVERR, 8, 2)
    FIELD(DX0GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX0GSR3, SRDPC, 0, 2)
REG32(DX1GCR0, 0x800)
    FIELD(DX1GCR0, CALBYP, 31, 1)
    FIELD(DX1GCR0, MDLEN, 30, 1)
    FIELD(DX1GCR0, CODTSHFT, 28, 2)
    FIELD(DX1GCR0, DQSDCC, 24, 4)
    FIELD(DX1GCR0, RDDLY, 20, 4)
    FIELD(DX1GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX1GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX1GCR0, DQSSEPDR, 12, 1)
    FIELD(DX1GCR0, RTTOAL, 11, 1)
    FIELD(DX1GCR0, RTTOH, 9, 2)
    FIELD(DX1GCR0, CPDRSHFT, 7, 2)
    FIELD(DX1GCR0, DQSRPD, 6, 1)
    FIELD(DX1GCR0, DQSGPDR, 5, 1)
    FIELD(DX1GCR0, RESERVED_4, 4, 1)
    FIELD(DX1GCR0, DQSGODT, 3, 1)
    FIELD(DX1GCR0, DQSGOE, 2, 1)
    FIELD(DX1GCR0, RESERVED_1_0, 0, 2)
REG32(DX1GCR1, 0x804)
    FIELD(DX1GCR1, DXPDRMODE, 16, 16)
    FIELD(DX1GCR1, RESERVED_15, 15, 1)
    FIELD(DX1GCR1, QSNSEL, 14, 1)
    FIELD(DX1GCR1, QSSEL, 13, 1)
    FIELD(DX1GCR1, OEEN, 12, 1)
    FIELD(DX1GCR1, PDREN, 11, 1)
    FIELD(DX1GCR1, TEEN, 10, 1)
    FIELD(DX1GCR1, DSEN, 9, 1)
    FIELD(DX1GCR1, DMEN, 8, 1)
    FIELD(DX1GCR1, DQEN, 0, 8)
REG32(DX1GCR2, 0x808)
    FIELD(DX1GCR2, DXOEMODE, 16, 16)
    FIELD(DX1GCR2, DXTEMODE, 0, 16)
REG32(DX1GCR3, 0x80c)
    FIELD(DX1GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX1GCR3, RDBVT, 29, 1)
    FIELD(DX1GCR3, WDBVT, 28, 1)
    FIELD(DX1GCR3, RGLVT, 27, 1)
    FIELD(DX1GCR3, RDLVT, 26, 1)
    FIELD(DX1GCR3, WDLVT, 25, 1)
    FIELD(DX1GCR3, WLLVT, 24, 1)
    FIELD(DX1GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX1GCR3, DSNOEMODE, 20, 2)
    FIELD(DX1GCR3, DSNTEMODE, 18, 2)
    FIELD(DX1GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX1GCR3, DMOEMODE, 14, 2)
    FIELD(DX1GCR3, DMTEMODE, 12, 2)
    FIELD(DX1GCR3, DMPDRMODE, 10, 2)
    FIELD(DX1GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX1GCR3, DSOEMODE, 6, 2)
    FIELD(DX1GCR3, DSTEMODE, 4, 2)
    FIELD(DX1GCR3, DSPDRMODE, 2, 2)
    FIELD(DX1GCR3, RESERVED_1_0, 0, 2)
REG32(DX1GCR4, 0x810)
    FIELD(DX1GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX1GCR4, DXREFPEN, 28, 1)
    FIELD(DX1GCR4, DXREFEEN, 26, 2)
    FIELD(DX1GCR4, DXREFSEN, 25, 1)
    FIELD(DX1GCR4, RESERVED_24, 24, 1)
    FIELD(DX1GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX1GCR4, DXREFESEL, 16, 7)
    FIELD(DX1GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX1GCR4, DXREFSSEL, 8, 7)
    FIELD(DX1GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX1GCR4, DXREFIEN, 2, 4)
    FIELD(DX1GCR4, DXREFIMON, 0, 2)
REG32(DX1GCR5, 0x814)
    FIELD(DX1GCR5, RESERVED_31, 31, 1)
    FIELD(DX1GCR5, DXREFISELR3, 24, 7)
    FIELD(DX1GCR5, RESERVED_23, 23, 1)
    FIELD(DX1GCR5, DXREFISELR2, 16, 7)
    FIELD(DX1GCR5, RESERVED_15, 15, 1)
    FIELD(DX1GCR5, DXREFISELR1, 8, 7)
    FIELD(DX1GCR5, RESERVED_7, 7, 1)
    FIELD(DX1GCR5, DXREFISELR0, 0, 7)
REG32(DX1GCR6, 0x818)
    FIELD(DX1GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX1GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX1GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX1GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX1GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX1GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX1GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX1GCR6, DXDQVREFR0, 0, 6)
REG32(DX1BDLR0, 0x840)
    FIELD(DX1BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX1BDLR0, DQ3WBD, 24, 6)
    FIELD(DX1BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX1BDLR0, DQ2WBD, 16, 6)
    FIELD(DX1BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX1BDLR0, DQ1WBD, 8, 6)
    FIELD(DX1BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX1BDLR0, DQ0WBD, 0, 6)
REG32(DX1BDLR1, 0x844)
    FIELD(DX1BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX1BDLR1, DQ7WBD, 24, 6)
    FIELD(DX1BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX1BDLR1, DQ6WBD, 16, 6)
    FIELD(DX1BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX1BDLR1, DQ5WBD, 8, 6)
    FIELD(DX1BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX1BDLR1, DQ4WBD, 0, 6)
REG32(DX1BDLR2, 0x848)
    FIELD(DX1BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX1BDLR2, DSNWBD, 24, 6)
    FIELD(DX1BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX1BDLR2, DSOEBD, 16, 6)
    FIELD(DX1BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX1BDLR2, DSWBD, 8, 6)
    FIELD(DX1BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX1BDLR2, DMWBD, 0, 6)
REG32(DX1BDLR3, 0x850)
    FIELD(DX1BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX1BDLR3, DQ3RBD, 24, 6)
    FIELD(DX1BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX1BDLR3, DQ2RBD, 16, 6)
    FIELD(DX1BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX1BDLR3, DQ1RBD, 8, 6)
    FIELD(DX1BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX1BDLR3, DQ0RBD, 0, 6)
REG32(DX1BDLR4, 0x854)
    FIELD(DX1BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX1BDLR4, DQ7RBD, 24, 6)
    FIELD(DX1BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX1BDLR4, DQ6RBD, 16, 6)
    FIELD(DX1BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX1BDLR4, DQ5RBD, 8, 6)
    FIELD(DX1BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX1BDLR4, DQ4RBD, 0, 6)
REG32(DX1BDLR5, 0x858)
    FIELD(DX1BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX1BDLR5, DMRBD, 0, 6)
REG32(DX1BDLR6, 0x860)
    FIELD(DX1BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX1BDLR6, TERBD, 16, 6)
    FIELD(DX1BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX1BDLR6, PDRBD, 8, 6)
    FIELD(DX1BDLR6, RESERVED_7_0, 0, 8)
REG32(DX1LCDLR0, 0x880)
    FIELD(DX1LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX1LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX1LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX1LCDLR0, WLD, 0, 9)
REG32(DX1LCDLR1, 0x884)
    FIELD(DX1LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX1LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX1LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX1LCDLR1, WDQD, 0, 9)
REG32(DX1LCDLR2, 0x888)
    FIELD(DX1LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX1LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX1LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX1LCDLR2, DQSGD, 0, 9)
REG32(DX1LCDLR3, 0x88c)
    FIELD(DX1LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX1LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX1LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX1LCDLR3, RDQSD, 0, 9)
REG32(DX1LCDLR4, 0x890)
    FIELD(DX1LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX1LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX1LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX1LCDLR4, RDQSND, 0, 9)
REG32(DX1LCDLR5, 0x894)
    FIELD(DX1LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX1LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX1LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX1LCDLR5, DQSGSD, 0, 9)
REG32(DX1MDLR0, 0x8a0)
    FIELD(DX1MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX1MDLR0, TPRD, 16, 9)
    FIELD(DX1MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX1MDLR0, IPRD, 0, 9)
REG32(DX1MDLR1, 0x8a4)
    FIELD(DX1MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX1MDLR1, MDLD, 0, 9)
REG32(DX1GTR0, 0x8c0)
    FIELD(DX1GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX1GTR0, WDQSL, 24, 3)
    FIELD(DX1GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX1GTR0, WLSL, 16, 4)
    FIELD(DX1GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX1GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX1GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX1GTR0, DGSL, 0, 5)
REG32(DX1RSR1, 0x8d4)
    FIELD(DX1RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX1RSR1, RDLVLERR, 0, 16)
REG32(DX1RSR2, 0x8d8)
    FIELD(DX1RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX1RSR2, WLAWN, 0, 16)
REG32(DX1RSR3, 0x8dc)
    FIELD(DX1RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX1RSR3, WLAERR, 0, 16)
REG32(DX1GSR0, 0x8e0)
    FIELD(DX1GSR0, RESERVED_31, 31, 1)
    FIELD(DX1GSR0, WLDQ, 30, 1)
    FIELD(DX1GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX1GSR0, GDQSPRD, 17, 9)
    FIELD(DX1GSR0, DPLOCK, 16, 1)
    FIELD(DX1GSR0, WLPRD, 7, 9)
    FIELD(DX1GSR0, WLERR, 6, 1)
    FIELD(DX1GSR0, WLDONE, 5, 1)
    FIELD(DX1GSR0, WLCAL, 4, 1)
    FIELD(DX1GSR0, GDQSCAL, 3, 1)
    FIELD(DX1GSR0, RDQSNCAL, 2, 1)
    FIELD(DX1GSR0, RDQSCAL, 1, 1)
    FIELD(DX1GSR0, WDQCAL, 0, 1)
REG32(DX1GSR1, 0x8e4)
    FIELD(DX1GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX1GSR1, DLTCODE, 1, 24)
    FIELD(DX1GSR1, DLTDONE, 0, 1)
REG32(DX1GSR2, 0x8e8)
    FIELD(DX1GSR2, GSDQSPRD, 23, 9)
    FIELD(DX1GSR2, GSDQSCAL, 22, 1)
    FIELD(DX1GSR2, RESERVED_21, 21, 1)
    FIELD(DX1GSR2, SRDERR, 20, 1)
    FIELD(DX1GSR2, DQS2DQERR, 12, 4)
    FIELD(DX1GSR2, ESTAT, 8, 4)
    FIELD(DX1GSR2, WEWN, 7, 1)
    FIELD(DX1GSR2, WEERR, 6, 1)
    FIELD(DX1GSR2, REWN, 5, 1)
    FIELD(DX1GSR2, REERR, 4, 1)
    FIELD(DX1GSR2, WDWN, 3, 1)
    FIELD(DX1GSR2, WDERR, 2, 1)
    FIELD(DX1GSR2, RDWN, 1, 1)
    FIELD(DX1GSR2, RDERR, 0, 1)
REG32(DX1GSR3, 0x8ec)
    FIELD(DX1GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX1GSR3, ESTAT, 24, 3)
    FIELD(DX1GSR3, DVWRN, 20, 4)
    FIELD(DX1GSR3, DVERR, 16, 4)
    FIELD(DX1GSR3, HVWRN, 12, 4)
    FIELD(DX1GSR3, HVERR, 8, 4)
    FIELD(DX1GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX1GSR3, SRDPC, 0, 2)
REG32(DX2GCR0, 0x900)
    FIELD(DX2GCR0, CALBYP, 31, 1)
    FIELD(DX2GCR0, MDLEN, 30, 1)
    FIELD(DX2GCR0, CODTSHFT, 28, 2)
    FIELD(DX2GCR0, DQSDCC, 24, 4)
    FIELD(DX2GCR0, RDDLY, 20, 4)
    FIELD(DX2GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX2GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX2GCR0, DQSSEPDR, 12, 1)
    FIELD(DX2GCR0, RTTOAL, 11, 1)
    FIELD(DX2GCR0, RTTOH, 9, 2)
    FIELD(DX2GCR0, CPDRSHFT, 7, 2)
    FIELD(DX2GCR0, DQSRPD, 6, 1)
    FIELD(DX2GCR0, DQSGPDR, 5, 1)
    FIELD(DX2GCR0, RESERVED_4, 4, 1)
    FIELD(DX2GCR0, DQSGODT, 3, 1)
    FIELD(DX2GCR0, DQSGOE, 2, 1)
    FIELD(DX2GCR0, RESERVED_1_0, 0, 2)
REG32(DX2GCR1, 0x904)
    FIELD(DX2GCR1, DXPDRMODE, 16, 16)
    FIELD(DX2GCR1, RESERVED_15, 15, 1)
    FIELD(DX2GCR1, QSNSEL, 14, 1)
    FIELD(DX2GCR1, QSSEL, 13, 1)
    FIELD(DX2GCR1, OEEN, 12, 1)
    FIELD(DX2GCR1, PDREN, 11, 1)
    FIELD(DX2GCR1, TEEN, 10, 1)
    FIELD(DX2GCR1, DSEN, 9, 1)
    FIELD(DX2GCR1, DMEN, 8, 1)
    FIELD(DX2GCR1, DQEN, 0, 8)
REG32(DX2GCR2, 0x908)
    FIELD(DX2GCR2, DXOEMODE, 16, 16)
    FIELD(DX2GCR2, DXTEMODE, 0, 16)
REG32(DX2GCR3, 0x90c)
    FIELD(DX2GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX2GCR3, RDBVT, 29, 1)
    FIELD(DX2GCR3, WDBVT, 28, 1)
    FIELD(DX2GCR3, RGLVT, 27, 1)
    FIELD(DX2GCR3, RDLVT, 26, 1)
    FIELD(DX2GCR3, WDLVT, 25, 1)
    FIELD(DX2GCR3, WLLVT, 24, 1)
    FIELD(DX2GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX2GCR3, DSNOEMODE, 20, 2)
    FIELD(DX2GCR3, DSNTEMODE, 18, 2)
    FIELD(DX2GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX2GCR3, DMOEMODE, 14, 2)
    FIELD(DX2GCR3, DMTEMODE, 12, 2)
    FIELD(DX2GCR3, DMPDRMODE, 10, 2)
    FIELD(DX2GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX2GCR3, DSOEMODE, 6, 2)
    FIELD(DX2GCR3, DSTEMODE, 4, 2)
    FIELD(DX2GCR3, DSPDRMODE, 2, 2)
    FIELD(DX2GCR3, RESERVED_1_0, 0, 2)
REG32(DX2GCR4, 0x910)
    FIELD(DX2GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX2GCR4, DXREFPEN, 28, 1)
    FIELD(DX2GCR4, DXREFEEN, 26, 2)
    FIELD(DX2GCR4, DXREFSEN, 25, 1)
    FIELD(DX2GCR4, RESERVED_24, 24, 1)
    FIELD(DX2GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX2GCR4, DXREFESEL, 16, 7)
    FIELD(DX2GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX2GCR4, DXREFSSEL, 8, 7)
    FIELD(DX2GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX2GCR4, DXREFIEN, 2, 4)
    FIELD(DX2GCR4, DXREFIMON, 0, 2)
REG32(DX2GCR5, 0x914)
    FIELD(DX2GCR5, RESERVED_31, 31, 1)
    FIELD(DX2GCR5, DXREFISELR3, 24, 7)
    FIELD(DX2GCR5, RESERVED_23, 23, 1)
    FIELD(DX2GCR5, DXREFISELR2, 16, 7)
    FIELD(DX2GCR5, RESERVED_15, 15, 1)
    FIELD(DX2GCR5, DXREFISELR1, 8, 7)
    FIELD(DX2GCR5, RESERVED_7, 7, 1)
    FIELD(DX2GCR5, DXREFISELR0, 0, 7)
REG32(DX2GCR6, 0x918)
    FIELD(DX2GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX2GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX2GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX2GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX2GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX2GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX2GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX2GCR6, DXDQVREFR0, 0, 6)
REG32(DX2BDLR0, 0x940)
    FIELD(DX2BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX2BDLR0, DQ3WBD, 24, 6)
    FIELD(DX2BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX2BDLR0, DQ2WBD, 16, 6)
    FIELD(DX2BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX2BDLR0, DQ1WBD, 8, 6)
    FIELD(DX2BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX2BDLR0, DQ0WBD, 0, 6)
REG32(DX2BDLR1, 0x944)
    FIELD(DX2BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX2BDLR1, DQ7WBD, 24, 6)
    FIELD(DX2BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX2BDLR1, DQ6WBD, 16, 6)
    FIELD(DX2BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX2BDLR1, DQ5WBD, 8, 6)
    FIELD(DX2BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX2BDLR1, DQ4WBD, 0, 6)
REG32(DX2BDLR2, 0x948)
    FIELD(DX2BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX2BDLR2, DSNWBD, 24, 6)
    FIELD(DX2BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX2BDLR2, DSOEBD, 16, 6)
    FIELD(DX2BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX2BDLR2, DSWBD, 8, 6)
    FIELD(DX2BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX2BDLR2, DMWBD, 0, 6)
REG32(DX2BDLR3, 0x950)
    FIELD(DX2BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX2BDLR3, DQ3RBD, 24, 6)
    FIELD(DX2BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX2BDLR3, DQ2RBD, 16, 6)
    FIELD(DX2BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX2BDLR3, DQ1RBD, 8, 6)
    FIELD(DX2BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX2BDLR3, DQ0RBD, 0, 6)
REG32(DX2BDLR4, 0x954)
    FIELD(DX2BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX2BDLR4, DQ7RBD, 24, 6)
    FIELD(DX2BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX2BDLR4, DQ6RBD, 16, 6)
    FIELD(DX2BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX2BDLR4, DQ5RBD, 8, 6)
    FIELD(DX2BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX2BDLR4, DQ4RBD, 0, 6)
REG32(DX2BDLR5, 0x958)
    FIELD(DX2BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX2BDLR5, DMRBD, 0, 6)
REG32(DX2BDLR6, 0x960)
    FIELD(DX2BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX2BDLR6, TERBD, 16, 6)
    FIELD(DX2BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX2BDLR6, PDRBD, 8, 6)
    FIELD(DX2BDLR6, RESERVED_7_0, 0, 8)
REG32(DX2LCDLR0, 0x980)
    FIELD(DX2LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX2LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX2LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX2LCDLR0, WLD, 0, 9)
REG32(DX2LCDLR1, 0x984)
    FIELD(DX2LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX2LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX2LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX2LCDLR1, WDQD, 0, 9)
REG32(DX2LCDLR2, 0x988)
    FIELD(DX2LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX2LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX2LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX2LCDLR2, DQSGD, 0, 9)
REG32(DX2LCDLR3, 0x98c)
    FIELD(DX2LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX2LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX2LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX2LCDLR3, RDQSD, 0, 9)
REG32(DX2LCDLR4, 0x990)
    FIELD(DX2LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX2LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX2LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX2LCDLR4, RDQSND, 0, 9)
REG32(DX2LCDLR5, 0x994)
    FIELD(DX2LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX2LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX2LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX2LCDLR5, DQSGSD, 0, 9)
REG32(DX2MDLR0, 0x9a0)
    FIELD(DX2MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX2MDLR0, TPRD, 16, 9)
    FIELD(DX2MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX2MDLR0, IPRD, 0, 9)
REG32(DX2MDLR1, 0x9a4)
    FIELD(DX2MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX2MDLR1, MDLD, 0, 9)
REG32(DX2GTR0, 0x9c0)
    FIELD(DX2GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX2GTR0, WDQSL, 24, 3)
    FIELD(DX2GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX2GTR0, WLSL, 16, 4)
    FIELD(DX2GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX2GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX2GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX2GTR0, DGSL, 0, 5)
REG32(DX2RSR1, 0x9d4)
    FIELD(DX2RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX2RSR1, RDLVLERR, 0, 16)
REG32(DX2RSR2, 0x9d8)
    FIELD(DX2RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX2RSR2, WLAWN, 0, 16)
REG32(DX2RSR3, 0x9dc)
    FIELD(DX2RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX2RSR3, WLAERR, 0, 16)
REG32(DX2GSR0, 0x9e0)
    FIELD(DX2GSR0, RESERVED_31, 31, 1)
    FIELD(DX2GSR0, WLDQ, 30, 1)
    FIELD(DX2GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX2GSR0, GDQSPRD, 17, 9)
    FIELD(DX2GSR0, DPLOCK, 16, 1)
    FIELD(DX2GSR0, WLPRD, 7, 9)
    FIELD(DX2GSR0, WLERR, 6, 1)
    FIELD(DX2GSR0, WLDONE, 5, 1)
    FIELD(DX2GSR0, WLCAL, 4, 1)
    FIELD(DX2GSR0, GDQSCAL, 3, 1)
    FIELD(DX2GSR0, RDQSNCAL, 2, 1)
    FIELD(DX2GSR0, RDQSCAL, 1, 1)
    FIELD(DX2GSR0, WDQCAL, 0, 1)
REG32(DX2GSR1, 0x9e4)
    FIELD(DX2GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX2GSR1, DLTCODE, 1, 24)
    FIELD(DX2GSR1, DLTDONE, 0, 1)
REG32(DX2GSR2, 0x9e8)
    FIELD(DX2GSR2, GSDQSPRD, 23, 9)
    FIELD(DX2GSR2, GSDQSCAL, 22, 1)
    FIELD(DX2GSR2, RESERVED_21, 21, 1)
    FIELD(DX2GSR2, SRDERR, 20, 1)
    FIELD(DX2GSR2, DQS2DQERR, 12, 4)
    FIELD(DX2GSR2, ESTAT, 8, 4)
    FIELD(DX2GSR2, WEWN, 7, 1)
    FIELD(DX2GSR2, WEERR, 6, 1)
    FIELD(DX2GSR2, REWN, 5, 1)
    FIELD(DX2GSR2, REERR, 4, 1)
    FIELD(DX2GSR2, WDWN, 3, 1)
    FIELD(DX2GSR2, WDERR, 2, 1)
    FIELD(DX2GSR2, RDWN, 1, 1)
    FIELD(DX2GSR2, RDERR, 0, 1)
REG32(DX2GSR3, 0x9ec)
    FIELD(DX2GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX2GSR3, ESTAT, 24, 3)
    FIELD(DX2GSR3, DVWRN, 20, 4)
    FIELD(DX2GSR3, DVERR, 16, 4)
    FIELD(DX2GSR3, HVWRN, 12, 4)
    FIELD(DX2GSR3, HVERR, 8, 4)
    FIELD(DX2GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX2GSR3, SRDPC, 0, 2)
REG32(DX3GCR0, 0xa00)
    FIELD(DX3GCR0, CALBYP, 31, 1)
    FIELD(DX3GCR0, MDLEN, 30, 1)
    FIELD(DX3GCR0, CODTSHFT, 28, 2)
    FIELD(DX3GCR0, DQSDCC, 24, 4)
    FIELD(DX3GCR0, RDDLY, 20, 4)
    FIELD(DX3GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX3GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX3GCR0, DQSSEPDR, 12, 1)
    FIELD(DX3GCR0, RTTOAL, 11, 1)
    FIELD(DX3GCR0, RTTOH, 9, 2)
    FIELD(DX3GCR0, CPDRSHFT, 7, 2)
    FIELD(DX3GCR0, DQSRPD, 6, 1)
    FIELD(DX3GCR0, DQSGPDR, 5, 1)
    FIELD(DX3GCR0, RESERVED_4, 4, 1)
    FIELD(DX3GCR0, DQSGODT, 3, 1)
    FIELD(DX3GCR0, DQSGOE, 2, 1)
    FIELD(DX3GCR0, RESERVED_1_0, 0, 2)
REG32(DX3GCR1, 0xa04)
    FIELD(DX3GCR1, DXPDRMODE, 16, 16)
    FIELD(DX3GCR1, RESERVED_15, 15, 1)
    FIELD(DX3GCR1, QSNSEL, 14, 1)
    FIELD(DX3GCR1, QSSEL, 13, 1)
    FIELD(DX3GCR1, OEEN, 12, 1)
    FIELD(DX3GCR1, PDREN, 11, 1)
    FIELD(DX3GCR1, TEEN, 10, 1)
    FIELD(DX3GCR1, DSEN, 9, 1)
    FIELD(DX3GCR1, DMEN, 8, 1)
    FIELD(DX3GCR1, DQEN, 0, 8)
REG32(DX3GCR2, 0xa08)
    FIELD(DX3GCR2, DXOEMODE, 16, 16)
    FIELD(DX3GCR2, DXTEMODE, 0, 16)
REG32(DX3GCR3, 0xa0c)
    FIELD(DX3GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX3GCR3, RDBVT, 29, 1)
    FIELD(DX3GCR3, WDBVT, 28, 1)
    FIELD(DX3GCR3, RGLVT, 27, 1)
    FIELD(DX3GCR3, RDLVT, 26, 1)
    FIELD(DX3GCR3, WDLVT, 25, 1)
    FIELD(DX3GCR3, WLLVT, 24, 1)
    FIELD(DX3GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX3GCR3, DSNOEMODE, 20, 2)
    FIELD(DX3GCR3, DSNTEMODE, 18, 2)
    FIELD(DX3GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX3GCR3, DMOEMODE, 14, 2)
    FIELD(DX3GCR3, DMTEMODE, 12, 2)
    FIELD(DX3GCR3, DMPDRMODE, 10, 2)
    FIELD(DX3GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX3GCR3, DSOEMODE, 6, 2)
    FIELD(DX3GCR3, DSTEMODE, 4, 2)
    FIELD(DX3GCR3, DSPDRMODE, 2, 2)
    FIELD(DX3GCR3, RESERVED_1_0, 0, 2)
REG32(DX3GCR4, 0xa10)
    FIELD(DX3GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX3GCR4, DXREFPEN, 28, 1)
    FIELD(DX3GCR4, DXREFEEN, 26, 2)
    FIELD(DX3GCR4, DXREFSEN, 25, 1)
    FIELD(DX3GCR4, RESERVED_24, 24, 1)
    FIELD(DX3GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX3GCR4, DXREFESEL, 16, 7)
    FIELD(DX3GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX3GCR4, DXREFSSEL, 8, 7)
    FIELD(DX3GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX3GCR4, DXREFIEN, 2, 4)
    FIELD(DX3GCR4, DXREFIMON, 0, 2)
REG32(DX3GCR5, 0xa14)
    FIELD(DX3GCR5, RESERVED_31, 31, 1)
    FIELD(DX3GCR5, DXREFISELR3, 24, 7)
    FIELD(DX3GCR5, RESERVED_23, 23, 1)
    FIELD(DX3GCR5, DXREFISELR2, 16, 7)
    FIELD(DX3GCR5, RESERVED_15, 15, 1)
    FIELD(DX3GCR5, DXREFISELR1, 8, 7)
    FIELD(DX3GCR5, RESERVED_7, 7, 1)
    FIELD(DX3GCR5, DXREFISELR0, 0, 7)
REG32(DX3GCR6, 0xa18)
    FIELD(DX3GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX3GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX3GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX3GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX3GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX3GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX3GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX3GCR6, DXDQVREFR0, 0, 6)
REG32(DX3BDLR0, 0xa40)
    FIELD(DX3BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX3BDLR0, DQ3WBD, 24, 6)
    FIELD(DX3BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX3BDLR0, DQ2WBD, 16, 6)
    FIELD(DX3BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX3BDLR0, DQ1WBD, 8, 6)
    FIELD(DX3BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX3BDLR0, DQ0WBD, 0, 6)
REG32(DX3BDLR1, 0xa44)
    FIELD(DX3BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX3BDLR1, DQ7WBD, 24, 6)
    FIELD(DX3BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX3BDLR1, DQ6WBD, 16, 6)
    FIELD(DX3BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX3BDLR1, DQ5WBD, 8, 6)
    FIELD(DX3BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX3BDLR1, DQ4WBD, 0, 6)
REG32(DX3BDLR2, 0xa48)
    FIELD(DX3BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX3BDLR2, DSNWBD, 24, 6)
    FIELD(DX3BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX3BDLR2, DSOEBD, 16, 6)
    FIELD(DX3BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX3BDLR2, DSWBD, 8, 6)
    FIELD(DX3BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX3BDLR2, DMWBD, 0, 6)
REG32(DX3BDLR3, 0xa50)
    FIELD(DX3BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX3BDLR3, DQ3RBD, 24, 6)
    FIELD(DX3BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX3BDLR3, DQ2RBD, 16, 6)
    FIELD(DX3BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX3BDLR3, DQ1RBD, 8, 6)
    FIELD(DX3BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX3BDLR3, DQ0RBD, 0, 6)
REG32(DX3BDLR4, 0xa54)
    FIELD(DX3BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX3BDLR4, DQ7RBD, 24, 6)
    FIELD(DX3BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX3BDLR4, DQ6RBD, 16, 6)
    FIELD(DX3BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX3BDLR4, DQ5RBD, 8, 6)
    FIELD(DX3BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX3BDLR4, DQ4RBD, 0, 6)
REG32(DX3BDLR5, 0xa58)
    FIELD(DX3BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX3BDLR5, DMRBD, 0, 6)
REG32(DX3BDLR6, 0xa60)
    FIELD(DX3BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX3BDLR6, TERBD, 16, 6)
    FIELD(DX3BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX3BDLR6, PDRBD, 8, 6)
    FIELD(DX3BDLR6, RESERVED_7_0, 0, 8)
REG32(DX3LCDLR0, 0xa80)
    FIELD(DX3LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX3LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX3LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX3LCDLR0, WLD, 0, 9)
REG32(DX3LCDLR1, 0xa84)
    FIELD(DX3LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX3LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX3LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX3LCDLR1, WDQD, 0, 9)
REG32(DX3LCDLR2, 0xa88)
    FIELD(DX3LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX3LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX3LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX3LCDLR2, DQSGD, 0, 9)
REG32(DX3LCDLR3, 0xa8c)
    FIELD(DX3LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX3LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX3LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX3LCDLR3, RDQSD, 0, 9)
REG32(DX3LCDLR4, 0xa90)
    FIELD(DX3LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX3LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX3LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX3LCDLR4, RDQSND, 0, 9)
REG32(DX3LCDLR5, 0xa94)
    FIELD(DX3LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX3LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX3LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX3LCDLR5, DQSGSD, 0, 9)
REG32(DX3MDLR0, 0xaa0)
    FIELD(DX3MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX3MDLR0, TPRD, 16, 9)
    FIELD(DX3MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX3MDLR0, IPRD, 0, 9)
REG32(DX3MDLR1, 0xaa4)
    FIELD(DX3MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX3MDLR1, MDLD, 0, 9)
REG32(DX3GTR0, 0xac0)
    FIELD(DX3GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX3GTR0, WDQSL, 24, 3)
    FIELD(DX3GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX3GTR0, WLSL, 16, 4)
    FIELD(DX3GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX3GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX3GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX3GTR0, DGSL, 0, 5)
REG32(DX3RSR1, 0xad4)
    FIELD(DX3RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX3RSR1, RDLVLERR, 0, 16)
REG32(DX3RSR2, 0xad8)
    FIELD(DX3RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX3RSR2, WLAWN, 0, 16)
REG32(DX3RSR3, 0xadc)
    FIELD(DX3RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX3RSR3, WLAERR, 0, 16)
REG32(DX3GSR0, 0xae0)
    FIELD(DX3GSR0, RESERVED_31, 31, 1)
    FIELD(DX3GSR0, WLDQ, 30, 1)
    FIELD(DX3GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX3GSR0, GDQSPRD, 17, 9)
    FIELD(DX3GSR0, DPLOCK, 16, 1)
    FIELD(DX3GSR0, WLPRD, 7, 9)
    FIELD(DX3GSR0, WLERR, 6, 1)
    FIELD(DX3GSR0, WLDONE, 5, 1)
    FIELD(DX3GSR0, WLCAL, 4, 1)
    FIELD(DX3GSR0, GDQSCAL, 3, 1)
    FIELD(DX3GSR0, RDQSNCAL, 2, 1)
    FIELD(DX3GSR0, RDQSCAL, 1, 1)
    FIELD(DX3GSR0, WDQCAL, 0, 1)
REG32(DX3GSR1, 0xae4)
    FIELD(DX3GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX3GSR1, DLTCODE, 1, 24)
    FIELD(DX3GSR1, DLTDONE, 0, 1)
REG32(DX3GSR2, 0xae8)
    FIELD(DX3GSR2, GSDQSPRD, 23, 9)
    FIELD(DX3GSR2, GSDQSCAL, 22, 1)
    FIELD(DX3GSR2, RESERVED_21, 21, 1)
    FIELD(DX3GSR2, SRDERR, 20, 1)
    FIELD(DX3GSR2, DQS2DQERR, 12, 4)
    FIELD(DX3GSR2, ESTAT, 8, 4)
    FIELD(DX3GSR2, WEWN, 7, 1)
    FIELD(DX3GSR2, WEERR, 6, 1)
    FIELD(DX3GSR2, REWN, 5, 1)
    FIELD(DX3GSR2, REERR, 4, 1)
    FIELD(DX3GSR2, WDWN, 3, 1)
    FIELD(DX3GSR2, WDERR, 2, 1)
    FIELD(DX3GSR2, RDWN, 1, 1)
    FIELD(DX3GSR2, RDERR, 0, 1)
REG32(DX3GSR3, 0xaec)
    FIELD(DX3GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX3GSR3, ESTAT, 24, 3)
    FIELD(DX3GSR3, DVWRN, 20, 4)
    FIELD(DX3GSR3, DVERR, 16, 4)
    FIELD(DX3GSR3, HVWRN, 12, 4)
    FIELD(DX3GSR3, HVERR, 8, 4)
    FIELD(DX3GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX3GSR3, SRDPC, 0, 2)
REG32(DX4GCR0, 0xb00)
    FIELD(DX4GCR0, CALBYP, 31, 1)
    FIELD(DX4GCR0, MDLEN, 30, 1)
    FIELD(DX4GCR0, CODTSHFT, 28, 2)
    FIELD(DX4GCR0, DQSDCC, 24, 4)
    FIELD(DX4GCR0, RDDLY, 20, 4)
    FIELD(DX4GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX4GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX4GCR0, DQSSEPDR, 12, 1)
    FIELD(DX4GCR0, RTTOAL, 11, 1)
    FIELD(DX4GCR0, RTTOH, 9, 2)
    FIELD(DX4GCR0, CPDRSHFT, 7, 2)
    FIELD(DX4GCR0, DQSRPD, 6, 1)
    FIELD(DX4GCR0, DQSGPDR, 5, 1)
    FIELD(DX4GCR0, RESERVED_4, 4, 1)
    FIELD(DX4GCR0, DQSGODT, 3, 1)
    FIELD(DX4GCR0, DQSGOE, 2, 1)
    FIELD(DX4GCR0, RESERVED_1_0, 0, 2)
REG32(DX4GCR1, 0xb04)
    FIELD(DX4GCR1, DXPDRMODE, 16, 16)
    FIELD(DX4GCR1, RESERVED_15, 15, 1)
    FIELD(DX4GCR1, QSNSEL, 14, 1)
    FIELD(DX4GCR1, QSSEL, 13, 1)
    FIELD(DX4GCR1, OEEN, 12, 1)
    FIELD(DX4GCR1, PDREN, 11, 1)
    FIELD(DX4GCR1, TEEN, 10, 1)
    FIELD(DX4GCR1, DSEN, 9, 1)
    FIELD(DX4GCR1, DMEN, 8, 1)
    FIELD(DX4GCR1, DQEN, 0, 8)
REG32(DX4GCR2, 0xb08)
    FIELD(DX4GCR2, DXOEMODE, 16, 16)
    FIELD(DX4GCR2, DXTEMODE, 0, 16)
REG32(DX4GCR3, 0xb0c)
    FIELD(DX4GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX4GCR3, RDBVT, 29, 1)
    FIELD(DX4GCR3, WDBVT, 28, 1)
    FIELD(DX4GCR3, RGLVT, 27, 1)
    FIELD(DX4GCR3, RDLVT, 26, 1)
    FIELD(DX4GCR3, WDLVT, 25, 1)
    FIELD(DX4GCR3, WLLVT, 24, 1)
    FIELD(DX4GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX4GCR3, DSNOEMODE, 20, 2)
    FIELD(DX4GCR3, DSNTEMODE, 18, 2)
    FIELD(DX4GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX4GCR3, DMOEMODE, 14, 2)
    FIELD(DX4GCR3, DMTEMODE, 12, 2)
    FIELD(DX4GCR3, DMPDRMODE, 10, 2)
    FIELD(DX4GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX4GCR3, DSOEMODE, 6, 2)
    FIELD(DX4GCR3, DSTEMODE, 4, 2)
    FIELD(DX4GCR3, DSPDRMODE, 2, 2)
    FIELD(DX4GCR3, RESERVED_1_0, 0, 2)
REG32(DX4GCR4, 0xb10)
    FIELD(DX4GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX4GCR4, DXREFPEN, 28, 1)
    FIELD(DX4GCR4, DXREFEEN, 26, 2)
    FIELD(DX4GCR4, DXREFSEN, 25, 1)
    FIELD(DX4GCR4, RESERVED_24, 24, 1)
    FIELD(DX4GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX4GCR4, DXREFESEL, 16, 7)
    FIELD(DX4GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX4GCR4, DXREFSSEL, 8, 7)
    FIELD(DX4GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX4GCR4, DXREFIEN, 2, 4)
    FIELD(DX4GCR4, DXREFIMON, 0, 2)
REG32(DX4GCR5, 0xb14)
    FIELD(DX4GCR5, RESERVED_31, 31, 1)
    FIELD(DX4GCR5, DXREFISELR3, 24, 7)
    FIELD(DX4GCR5, RESERVED_23, 23, 1)
    FIELD(DX4GCR5, DXREFISELR2, 16, 7)
    FIELD(DX4GCR5, RESERVED_15, 15, 1)
    FIELD(DX4GCR5, DXREFISELR1, 8, 7)
    FIELD(DX4GCR5, RESERVED_7, 7, 1)
    FIELD(DX4GCR5, DXREFISELR0, 0, 7)
REG32(DX4GCR6, 0xb18)
    FIELD(DX4GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX4GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX4GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX4GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX4GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX4GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX4GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX4GCR6, DXDQVREFR0, 0, 6)
REG32(DX4BDLR0, 0xb40)
    FIELD(DX4BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX4BDLR0, DQ3WBD, 24, 6)
    FIELD(DX4BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX4BDLR0, DQ2WBD, 16, 6)
    FIELD(DX4BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX4BDLR0, DQ1WBD, 8, 6)
    FIELD(DX4BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX4BDLR0, DQ0WBD, 0, 6)
REG32(DX4BDLR1, 0xb44)
    FIELD(DX4BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX4BDLR1, DQ7WBD, 24, 6)
    FIELD(DX4BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX4BDLR1, DQ6WBD, 16, 6)
    FIELD(DX4BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX4BDLR1, DQ5WBD, 8, 6)
    FIELD(DX4BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX4BDLR1, DQ4WBD, 0, 6)
REG32(DX4BDLR2, 0xb48)
    FIELD(DX4BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX4BDLR2, DSNWBD, 24, 6)
    FIELD(DX4BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX4BDLR2, DSOEBD, 16, 6)
    FIELD(DX4BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX4BDLR2, DSWBD, 8, 6)
    FIELD(DX4BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX4BDLR2, DMWBD, 0, 6)
REG32(DX4BDLR3, 0xb50)
    FIELD(DX4BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX4BDLR3, DQ3RBD, 24, 6)
    FIELD(DX4BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX4BDLR3, DQ2RBD, 16, 6)
    FIELD(DX4BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX4BDLR3, DQ1RBD, 8, 6)
    FIELD(DX4BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX4BDLR3, DQ0RBD, 0, 6)
REG32(DX4BDLR4, 0xb54)
    FIELD(DX4BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX4BDLR4, DQ7RBD, 24, 6)
    FIELD(DX4BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX4BDLR4, DQ6RBD, 16, 6)
    FIELD(DX4BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX4BDLR4, DQ5RBD, 8, 6)
    FIELD(DX4BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX4BDLR4, DQ4RBD, 0, 6)
REG32(DX4BDLR5, 0xb58)
    FIELD(DX4BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX4BDLR5, DMRBD, 0, 6)
REG32(DX4BDLR6, 0xb60)
    FIELD(DX4BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX4BDLR6, TERBD, 16, 6)
    FIELD(DX4BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX4BDLR6, PDRBD, 8, 6)
    FIELD(DX4BDLR6, RESERVED_7_0, 0, 8)
REG32(DX4LCDLR0, 0xb80)
    FIELD(DX4LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX4LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX4LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX4LCDLR0, WLD, 0, 9)
REG32(DX4LCDLR1, 0xb84)
    FIELD(DX4LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX4LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX4LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX4LCDLR1, WDQD, 0, 9)
REG32(DX4LCDLR2, 0xb88)
    FIELD(DX4LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX4LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX4LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX4LCDLR2, DQSGD, 0, 9)
REG32(DX4LCDLR3, 0xb8c)
    FIELD(DX4LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX4LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX4LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX4LCDLR3, RDQSD, 0, 9)
REG32(DX4LCDLR4, 0xb90)
    FIELD(DX4LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX4LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX4LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX4LCDLR4, RDQSND, 0, 9)
REG32(DX4LCDLR5, 0xb94)
    FIELD(DX4LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX4LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX4LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX4LCDLR5, DQSGSD, 0, 9)
REG32(DX4MDLR0, 0xba0)
    FIELD(DX4MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX4MDLR0, TPRD, 16, 9)
    FIELD(DX4MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX4MDLR0, IPRD, 0, 9)
REG32(DX4MDLR1, 0xba4)
    FIELD(DX4MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX4MDLR1, MDLD, 0, 9)
REG32(DX4GTR0, 0xbc0)
    FIELD(DX4GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX4GTR0, WDQSL, 24, 3)
    FIELD(DX4GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX4GTR0, WLSL, 16, 4)
    FIELD(DX4GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX4GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX4GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX4GTR0, DGSL, 0, 5)
REG32(DX4RSR1, 0xbd4)
    FIELD(DX4RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX4RSR1, RDLVLERR, 0, 16)
REG32(DX4RSR2, 0xbd8)
    FIELD(DX4RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX4RSR2, WLAWN, 0, 16)
REG32(DX4RSR3, 0xbdc)
    FIELD(DX4RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX4RSR3, WLAERR, 0, 16)
REG32(DX4GSR0, 0xbe0)
    FIELD(DX4GSR0, RESERVED_31, 31, 1)
    FIELD(DX4GSR0, WLDQ, 30, 1)
    FIELD(DX4GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX4GSR0, GDQSPRD, 17, 9)
    FIELD(DX4GSR0, DPLOCK, 16, 1)
    FIELD(DX4GSR0, WLPRD, 7, 9)
    FIELD(DX4GSR0, WLERR, 6, 1)
    FIELD(DX4GSR0, WLDONE, 5, 1)
    FIELD(DX4GSR0, WLCAL, 4, 1)
    FIELD(DX4GSR0, GDQSCAL, 3, 1)
    FIELD(DX4GSR0, RDQSNCAL, 2, 1)
    FIELD(DX4GSR0, RDQSCAL, 1, 1)
    FIELD(DX4GSR0, WDQCAL, 0, 1)
REG32(DX4GSR1, 0xbe4)
    FIELD(DX4GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX4GSR1, DLTCODE, 1, 24)
    FIELD(DX4GSR1, DLTDONE, 0, 1)
REG32(DX4GSR2, 0xbe8)
    FIELD(DX4GSR2, GSDQSPRD, 23, 9)
    FIELD(DX4GSR2, GSDQSCAL, 22, 1)
    FIELD(DX4GSR2, RESERVED_21, 21, 1)
    FIELD(DX4GSR2, SRDERR, 20, 1)
    FIELD(DX4GSR2, DQS2DQERR, 12, 4)
    FIELD(DX4GSR2, ESTAT, 8, 4)
    FIELD(DX4GSR2, WEWN, 7, 1)
    FIELD(DX4GSR2, WEERR, 6, 1)
    FIELD(DX4GSR2, REWN, 5, 1)
    FIELD(DX4GSR2, REERR, 4, 1)
    FIELD(DX4GSR2, WDWN, 3, 1)
    FIELD(DX4GSR2, WDERR, 2, 1)
    FIELD(DX4GSR2, RDWN, 1, 1)
    FIELD(DX4GSR2, RDERR, 0, 1)
REG32(DX4GSR3, 0xbec)
    FIELD(DX4GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX4GSR3, ESTAT, 24, 3)
    FIELD(DX4GSR3, DVWRN, 20, 4)
    FIELD(DX4GSR3, DVERR, 16, 4)
    FIELD(DX4GSR3, HVWRN, 12, 4)
    FIELD(DX4GSR3, HVERR, 8, 4)
    FIELD(DX4GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX4GSR3, SRDPC, 0, 2)
REG32(DX5GCR0, 0xc00)
    FIELD(DX5GCR0, CALBYP, 31, 1)
    FIELD(DX5GCR0, MDLEN, 30, 1)
    FIELD(DX5GCR0, CODTSHFT, 28, 2)
    FIELD(DX5GCR0, DQSDCC, 24, 4)
    FIELD(DX5GCR0, RDDLY, 20, 4)
    FIELD(DX5GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX5GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX5GCR0, DQSSEPDR, 12, 1)
    FIELD(DX5GCR0, RTTOAL, 11, 1)
    FIELD(DX5GCR0, RTTOH, 9, 2)
    FIELD(DX5GCR0, CPDRSHFT, 7, 2)
    FIELD(DX5GCR0, DQSRPD, 6, 1)
    FIELD(DX5GCR0, DQSGPDR, 5, 1)
    FIELD(DX5GCR0, RESERVED_4, 4, 1)
    FIELD(DX5GCR0, DQSGODT, 3, 1)
    FIELD(DX5GCR0, DQSGOE, 2, 1)
    FIELD(DX5GCR0, RESERVED_1_0, 0, 2)
REG32(DX5GCR1, 0xc04)
    FIELD(DX5GCR1, DXPDRMODE, 16, 16)
    FIELD(DX5GCR1, RESERVED_15, 15, 1)
    FIELD(DX5GCR1, QSNSEL, 14, 1)
    FIELD(DX5GCR1, QSSEL, 13, 1)
    FIELD(DX5GCR1, OEEN, 12, 1)
    FIELD(DX5GCR1, PDREN, 11, 1)
    FIELD(DX5GCR1, TEEN, 10, 1)
    FIELD(DX5GCR1, DSEN, 9, 1)
    FIELD(DX5GCR1, DMEN, 8, 1)
    FIELD(DX5GCR1, DQEN, 0, 8)
REG32(DX5GCR2, 0xc08)
    FIELD(DX5GCR2, DXOEMODE, 16, 16)
    FIELD(DX5GCR2, DXTEMODE, 0, 16)
REG32(DX5GCR3, 0xc0c)
    FIELD(DX5GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX5GCR3, RDBVT, 29, 1)
    FIELD(DX5GCR3, WDBVT, 28, 1)
    FIELD(DX5GCR3, RGLVT, 27, 1)
    FIELD(DX5GCR3, RDLVT, 26, 1)
    FIELD(DX5GCR3, WDLVT, 25, 1)
    FIELD(DX5GCR3, WLLVT, 24, 1)
    FIELD(DX5GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX5GCR3, DSNOEMODE, 20, 2)
    FIELD(DX5GCR3, DSNTEMODE, 18, 2)
    FIELD(DX5GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX5GCR3, DMOEMODE, 14, 2)
    FIELD(DX5GCR3, DMTEMODE, 12, 2)
    FIELD(DX5GCR3, DMPDRMODE, 10, 2)
    FIELD(DX5GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX5GCR3, DSOEMODE, 6, 2)
    FIELD(DX5GCR3, DSTEMODE, 4, 2)
    FIELD(DX5GCR3, DSPDRMODE, 2, 2)
    FIELD(DX5GCR3, RESERVED_1_0, 0, 2)
REG32(DX5GCR4, 0xc10)
    FIELD(DX5GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX5GCR4, DXREFPEN, 28, 1)
    FIELD(DX5GCR4, DXREFEEN, 26, 2)
    FIELD(DX5GCR4, DXREFSEN, 25, 1)
    FIELD(DX5GCR4, RESERVED_24, 24, 1)
    FIELD(DX5GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX5GCR4, DXREFESEL, 16, 7)
    FIELD(DX5GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX5GCR4, DXREFSSEL, 8, 7)
    FIELD(DX5GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX5GCR4, DXREFIEN, 2, 4)
    FIELD(DX5GCR4, DXREFIMON, 0, 2)
REG32(DX5GCR5, 0xc14)
    FIELD(DX5GCR5, RESERVED_31, 31, 1)
    FIELD(DX5GCR5, DXREFISELR3, 24, 7)
    FIELD(DX5GCR5, RESERVED_23, 23, 1)
    FIELD(DX5GCR5, DXREFISELR2, 16, 7)
    FIELD(DX5GCR5, RESERVED_15, 15, 1)
    FIELD(DX5GCR5, DXREFISELR1, 8, 7)
    FIELD(DX5GCR5, RESERVED_7, 7, 1)
    FIELD(DX5GCR5, DXREFISELR0, 0, 7)
REG32(DX5GCR6, 0xc18)
    FIELD(DX5GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX5GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX5GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX5GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX5GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX5GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX5GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX5GCR6, DXDQVREFR0, 0, 6)
REG32(DX5BDLR0, 0xc40)
    FIELD(DX5BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX5BDLR0, DQ3WBD, 24, 6)
    FIELD(DX5BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX5BDLR0, DQ2WBD, 16, 6)
    FIELD(DX5BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX5BDLR0, DQ1WBD, 8, 6)
    FIELD(DX5BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX5BDLR0, DQ0WBD, 0, 6)
REG32(DX5BDLR1, 0xc44)
    FIELD(DX5BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX5BDLR1, DQ7WBD, 24, 6)
    FIELD(DX5BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX5BDLR1, DQ6WBD, 16, 6)
    FIELD(DX5BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX5BDLR1, DQ5WBD, 8, 6)
    FIELD(DX5BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX5BDLR1, DQ4WBD, 0, 6)
REG32(DX5BDLR2, 0xc48)
    FIELD(DX5BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX5BDLR2, DSNWBD, 24, 6)
    FIELD(DX5BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX5BDLR2, DSOEBD, 16, 6)
    FIELD(DX5BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX5BDLR2, DSWBD, 8, 6)
    FIELD(DX5BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX5BDLR2, DMWBD, 0, 6)
REG32(DX5BDLR3, 0xc50)
    FIELD(DX5BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX5BDLR3, DQ3RBD, 24, 6)
    FIELD(DX5BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX5BDLR3, DQ2RBD, 16, 6)
    FIELD(DX5BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX5BDLR3, DQ1RBD, 8, 6)
    FIELD(DX5BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX5BDLR3, DQ0RBD, 0, 6)
REG32(DX5BDLR4, 0xc54)
    FIELD(DX5BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX5BDLR4, DQ7RBD, 24, 6)
    FIELD(DX5BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX5BDLR4, DQ6RBD, 16, 6)
    FIELD(DX5BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX5BDLR4, DQ5RBD, 8, 6)
    FIELD(DX5BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX5BDLR4, DQ4RBD, 0, 6)
REG32(DX5BDLR5, 0xc58)
    FIELD(DX5BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX5BDLR5, DMRBD, 0, 6)
REG32(DX5BDLR6, 0xc60)
    FIELD(DX5BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX5BDLR6, TERBD, 16, 6)
    FIELD(DX5BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX5BDLR6, PDRBD, 8, 6)
    FIELD(DX5BDLR6, RESERVED_7_0, 0, 8)
REG32(DX5LCDLR0, 0xc80)
    FIELD(DX5LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX5LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX5LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX5LCDLR0, WLD, 0, 9)
REG32(DX5LCDLR1, 0xc84)
    FIELD(DX5LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX5LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX5LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX5LCDLR1, WDQD, 0, 9)
REG32(DX5LCDLR2, 0xc88)
    FIELD(DX5LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX5LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX5LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX5LCDLR2, DQSGD, 0, 9)
REG32(DX5LCDLR3, 0xc8c)
    FIELD(DX5LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX5LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX5LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX5LCDLR3, RDQSD, 0, 9)
REG32(DX5LCDLR4, 0xc90)
    FIELD(DX5LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX5LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX5LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX5LCDLR4, RDQSND, 0, 9)
REG32(DX5LCDLR5, 0xc94)
    FIELD(DX5LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX5LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX5LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX5LCDLR5, DQSGSD, 0, 9)
REG32(DX5MDLR0, 0xca0)
    FIELD(DX5MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX5MDLR0, TPRD, 16, 9)
    FIELD(DX5MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX5MDLR0, IPRD, 0, 9)
REG32(DX5MDLR1, 0xca4)
    FIELD(DX5MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX5MDLR1, MDLD, 0, 9)
REG32(DX5GTR0, 0xcc0)
    FIELD(DX5GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX5GTR0, WDQSL, 24, 3)
    FIELD(DX5GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX5GTR0, WLSL, 16, 4)
    FIELD(DX5GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX5GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX5GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX5GTR0, DGSL, 0, 5)
REG32(DX5RSR1, 0xcd4)
    FIELD(DX5RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX5RSR1, RDLVLERR, 0, 16)
REG32(DX5RSR2, 0xcd8)
    FIELD(DX5RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX5RSR2, WLAWN, 0, 16)
REG32(DX5RSR3, 0xcdc)
    FIELD(DX5RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX5RSR3, WLAERR, 0, 16)
REG32(DX5GSR0, 0xce0)
    FIELD(DX5GSR0, RESERVED_31, 31, 1)
    FIELD(DX5GSR0, WLDQ, 30, 1)
    FIELD(DX5GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX5GSR0, GDQSPRD, 17, 9)
    FIELD(DX5GSR0, DPLOCK, 16, 1)
    FIELD(DX5GSR0, WLPRD, 7, 9)
    FIELD(DX5GSR0, WLERR, 6, 1)
    FIELD(DX5GSR0, WLDONE, 5, 1)
    FIELD(DX5GSR0, WLCAL, 4, 1)
    FIELD(DX5GSR0, GDQSCAL, 3, 1)
    FIELD(DX5GSR0, RDQSNCAL, 2, 1)
    FIELD(DX5GSR0, RDQSCAL, 1, 1)
    FIELD(DX5GSR0, WDQCAL, 0, 1)
REG32(DX5GSR1, 0xce4)
    FIELD(DX5GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX5GSR1, DLTCODE, 1, 24)
    FIELD(DX5GSR1, DLTDONE, 0, 1)
REG32(DX5GSR2, 0xce8)
    FIELD(DX5GSR2, GSDQSPRD, 23, 9)
    FIELD(DX5GSR2, GSDQSCAL, 22, 1)
    FIELD(DX5GSR2, RESERVED_21, 21, 1)
    FIELD(DX5GSR2, SRDERR, 20, 1)
    FIELD(DX5GSR2, DQS2DQERR, 12, 4)
    FIELD(DX5GSR2, ESTAT, 8, 4)
    FIELD(DX5GSR2, WEWN, 7, 1)
    FIELD(DX5GSR2, WEERR, 6, 1)
    FIELD(DX5GSR2, REWN, 5, 1)
    FIELD(DX5GSR2, REERR, 4, 1)
    FIELD(DX5GSR2, WDWN, 3, 1)
    FIELD(DX5GSR2, WDERR, 2, 1)
    FIELD(DX5GSR2, RDWN, 1, 1)
    FIELD(DX5GSR2, RDERR, 0, 1)
REG32(DX5GSR3, 0xcec)
    FIELD(DX5GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX5GSR3, ESTAT, 24, 3)
    FIELD(DX5GSR3, DVWRN, 20, 4)
    FIELD(DX5GSR3, DVERR, 16, 4)
    FIELD(DX5GSR3, HVWRN, 12, 4)
    FIELD(DX5GSR3, HVERR, 8, 4)
    FIELD(DX5GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX5GSR3, SRDPC, 0, 2)
REG32(DX6GCR0, 0xd00)
    FIELD(DX6GCR0, CALBYP, 31, 1)
    FIELD(DX6GCR0, MDLEN, 30, 1)
    FIELD(DX6GCR0, CODTSHFT, 28, 2)
    FIELD(DX6GCR0, DQSDCC, 24, 4)
    FIELD(DX6GCR0, RDDLY, 20, 4)
    FIELD(DX6GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX6GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX6GCR0, DQSSEPDR, 12, 1)
    FIELD(DX6GCR0, RTTOAL, 11, 1)
    FIELD(DX6GCR0, RTTOH, 9, 2)
    FIELD(DX6GCR0, CPDRSHFT, 7, 2)
    FIELD(DX6GCR0, DQSRPD, 6, 1)
    FIELD(DX6GCR0, DQSGPDR, 5, 1)
    FIELD(DX6GCR0, RESERVED_4, 4, 1)
    FIELD(DX6GCR0, DQSGODT, 3, 1)
    FIELD(DX6GCR0, DQSGOE, 2, 1)
    FIELD(DX6GCR0, RESERVED_1_0, 0, 2)
REG32(DX6GCR1, 0xd04)
    FIELD(DX6GCR1, DXPDRMODE, 16, 16)
    FIELD(DX6GCR1, RESERVED_15, 15, 1)
    FIELD(DX6GCR1, QSNSEL, 14, 1)
    FIELD(DX6GCR1, QSSEL, 13, 1)
    FIELD(DX6GCR1, OEEN, 12, 1)
    FIELD(DX6GCR1, PDREN, 11, 1)
    FIELD(DX6GCR1, TEEN, 10, 1)
    FIELD(DX6GCR1, DSEN, 9, 1)
    FIELD(DX6GCR1, DMEN, 8, 1)
    FIELD(DX6GCR1, DQEN, 0, 8)
REG32(DX6GCR2, 0xd08)
    FIELD(DX6GCR2, DXOEMODE, 16, 16)
    FIELD(DX6GCR2, DXTEMODE, 0, 16)
REG32(DX6GCR3, 0xd0c)
    FIELD(DX6GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX6GCR3, RDBVT, 29, 1)
    FIELD(DX6GCR3, WDBVT, 28, 1)
    FIELD(DX6GCR3, RGLVT, 27, 1)
    FIELD(DX6GCR3, RDLVT, 26, 1)
    FIELD(DX6GCR3, WDLVT, 25, 1)
    FIELD(DX6GCR3, WLLVT, 24, 1)
    FIELD(DX6GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX6GCR3, DSNOEMODE, 20, 2)
    FIELD(DX6GCR3, DSNTEMODE, 18, 2)
    FIELD(DX6GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX6GCR3, DMOEMODE, 14, 2)
    FIELD(DX6GCR3, DMTEMODE, 12, 2)
    FIELD(DX6GCR3, DMPDRMODE, 10, 2)
    FIELD(DX6GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX6GCR3, DSOEMODE, 6, 2)
    FIELD(DX6GCR3, DSTEMODE, 4, 2)
    FIELD(DX6GCR3, DSPDRMODE, 2, 2)
    FIELD(DX6GCR3, RESERVED_1_0, 0, 2)
REG32(DX6GCR4, 0xd10)
    FIELD(DX6GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX6GCR4, DXREFPEN, 28, 1)
    FIELD(DX6GCR4, DXREFEEN, 26, 2)
    FIELD(DX6GCR4, DXREFSEN, 25, 1)
    FIELD(DX6GCR4, RESERVED_24, 24, 1)
    FIELD(DX6GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX6GCR4, DXREFESEL, 16, 7)
    FIELD(DX6GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX6GCR4, DXREFSSEL, 8, 7)
    FIELD(DX6GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX6GCR4, DXREFIEN, 2, 4)
    FIELD(DX6GCR4, DXREFIMON, 0, 2)
REG32(DX6GCR5, 0xd14)
    FIELD(DX6GCR5, RESERVED_31, 31, 1)
    FIELD(DX6GCR5, DXREFISELR3, 24, 7)
    FIELD(DX6GCR5, RESERVED_23, 23, 1)
    FIELD(DX6GCR5, DXREFISELR2, 16, 7)
    FIELD(DX6GCR5, RESERVED_15, 15, 1)
    FIELD(DX6GCR5, DXREFISELR1, 8, 7)
    FIELD(DX6GCR5, RESERVED_7, 7, 1)
    FIELD(DX6GCR5, DXREFISELR0, 0, 7)
REG32(DX6GCR6, 0xd18)
    FIELD(DX6GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX6GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX6GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX6GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX6GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX6GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX6GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX6GCR6, DXDQVREFR0, 0, 6)
REG32(DX6BDLR0, 0xd40)
    FIELD(DX6BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX6BDLR0, DQ3WBD, 24, 6)
    FIELD(DX6BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX6BDLR0, DQ2WBD, 16, 6)
    FIELD(DX6BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX6BDLR0, DQ1WBD, 8, 6)
    FIELD(DX6BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX6BDLR0, DQ0WBD, 0, 6)
REG32(DX6BDLR1, 0xd44)
    FIELD(DX6BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX6BDLR1, DQ7WBD, 24, 6)
    FIELD(DX6BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX6BDLR1, DQ6WBD, 16, 6)
    FIELD(DX6BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX6BDLR1, DQ5WBD, 8, 6)
    FIELD(DX6BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX6BDLR1, DQ4WBD, 0, 6)
REG32(DX6BDLR2, 0xd48)
    FIELD(DX6BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX6BDLR2, DSNWBD, 24, 6)
    FIELD(DX6BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX6BDLR2, DSOEBD, 16, 6)
    FIELD(DX6BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX6BDLR2, DSWBD, 8, 6)
    FIELD(DX6BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX6BDLR2, DMWBD, 0, 6)
REG32(DX6BDLR3, 0xd50)
    FIELD(DX6BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX6BDLR3, DQ3RBD, 24, 6)
    FIELD(DX6BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX6BDLR3, DQ2RBD, 16, 6)
    FIELD(DX6BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX6BDLR3, DQ1RBD, 8, 6)
    FIELD(DX6BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX6BDLR3, DQ0RBD, 0, 6)
REG32(DX6BDLR4, 0xd54)
    FIELD(DX6BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX6BDLR4, DQ7RBD, 24, 6)
    FIELD(DX6BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX6BDLR4, DQ6RBD, 16, 6)
    FIELD(DX6BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX6BDLR4, DQ5RBD, 8, 6)
    FIELD(DX6BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX6BDLR4, DQ4RBD, 0, 6)
REG32(DX6BDLR5, 0xd58)
    FIELD(DX6BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX6BDLR5, DMRBD, 0, 6)
REG32(DX6BDLR6, 0xd60)
    FIELD(DX6BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX6BDLR6, TERBD, 16, 6)
    FIELD(DX6BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX6BDLR6, PDRBD, 8, 6)
    FIELD(DX6BDLR6, RESERVED_7_0, 0, 8)
REG32(DX6LCDLR0, 0xd80)
    FIELD(DX6LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX6LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX6LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX6LCDLR0, WLD, 0, 9)
REG32(DX6LCDLR1, 0xd84)
    FIELD(DX6LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX6LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX6LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX6LCDLR1, WDQD, 0, 9)
REG32(DX6LCDLR2, 0xd88)
    FIELD(DX6LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX6LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX6LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX6LCDLR2, DQSGD, 0, 9)
REG32(DX6LCDLR3, 0xd8c)
    FIELD(DX6LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX6LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX6LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX6LCDLR3, RDQSD, 0, 9)
REG32(DX6LCDLR4, 0xd90)
    FIELD(DX6LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX6LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX6LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX6LCDLR4, RDQSND, 0, 9)
REG32(DX6LCDLR5, 0xd94)
    FIELD(DX6LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX6LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX6LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX6LCDLR5, DQSGSD, 0, 9)
REG32(DX6MDLR0, 0xda0)
    FIELD(DX6MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX6MDLR0, TPRD, 16, 9)
    FIELD(DX6MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX6MDLR0, IPRD, 0, 9)
REG32(DX6MDLR1, 0xda4)
    FIELD(DX6MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX6MDLR1, MDLD, 0, 9)
REG32(DX6GTR0, 0xdc0)
    FIELD(DX6GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX6GTR0, WDQSL, 24, 3)
    FIELD(DX6GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX6GTR0, WLSL, 16, 4)
    FIELD(DX6GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX6GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX6GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX6GTR0, DGSL, 0, 5)
REG32(DX6RSR1, 0xdd4)
    FIELD(DX6RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX6RSR1, RDLVLERR, 0, 16)
REG32(DX6RSR2, 0xdd8)
    FIELD(DX6RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX6RSR2, WLAWN, 0, 16)
REG32(DX6RSR3, 0xddc)
    FIELD(DX6RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX6RSR3, WLAERR, 0, 16)
REG32(DX6GSR0, 0xde0)
    FIELD(DX6GSR0, RESERVED_31, 31, 1)
    FIELD(DX6GSR0, WLDQ, 30, 1)
    FIELD(DX6GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX6GSR0, GDQSPRD, 17, 9)
    FIELD(DX6GSR0, DPLOCK, 16, 1)
    FIELD(DX6GSR0, WLPRD, 7, 9)
    FIELD(DX6GSR0, WLERR, 6, 1)
    FIELD(DX6GSR0, WLDONE, 5, 1)
    FIELD(DX6GSR0, WLCAL, 4, 1)
    FIELD(DX6GSR0, GDQSCAL, 3, 1)
    FIELD(DX6GSR0, RDQSNCAL, 2, 1)
    FIELD(DX6GSR0, RDQSCAL, 1, 1)
    FIELD(DX6GSR0, WDQCAL, 0, 1)
REG32(DX6GSR1, 0xde4)
    FIELD(DX6GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX6GSR1, DLTCODE, 1, 24)
    FIELD(DX6GSR1, DLTDONE, 0, 1)
REG32(DX6GSR2, 0xde8)
    FIELD(DX6GSR2, GSDQSPRD, 23, 9)
    FIELD(DX6GSR2, GSDQSCAL, 22, 1)
    FIELD(DX6GSR2, RESERVED_21, 21, 1)
    FIELD(DX6GSR2, SRDERR, 20, 1)
    FIELD(DX6GSR2, DQS2DQERR, 12, 4)
    FIELD(DX6GSR2, ESTAT, 8, 4)
    FIELD(DX6GSR2, WEWN, 7, 1)
    FIELD(DX6GSR2, WEERR, 6, 1)
    FIELD(DX6GSR2, REWN, 5, 1)
    FIELD(DX6GSR2, REERR, 4, 1)
    FIELD(DX6GSR2, WDWN, 3, 1)
    FIELD(DX6GSR2, WDERR, 2, 1)
    FIELD(DX6GSR2, RDWN, 1, 1)
    FIELD(DX6GSR2, RDERR, 0, 1)
REG32(DX6GSR3, 0xdec)
    FIELD(DX6GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX6GSR3, ESTAT, 24, 3)
    FIELD(DX6GSR3, DVWRN, 20, 4)
    FIELD(DX6GSR3, DVERR, 16, 4)
    FIELD(DX6GSR3, HVWRN, 12, 4)
    FIELD(DX6GSR3, HVERR, 8, 4)
    FIELD(DX6GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX6GSR3, SRDPC, 0, 2)
REG32(DX7GCR0, 0xe00)
    FIELD(DX7GCR0, CALBYP, 31, 1)
    FIELD(DX7GCR0, MDLEN, 30, 1)
    FIELD(DX7GCR0, CODTSHFT, 28, 2)
    FIELD(DX7GCR0, DQSDCC, 24, 4)
    FIELD(DX7GCR0, RDDLY, 20, 4)
    FIELD(DX7GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX7GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX7GCR0, DQSSEPDR, 12, 1)
    FIELD(DX7GCR0, RTTOAL, 11, 1)
    FIELD(DX7GCR0, RTTOH, 9, 2)
    FIELD(DX7GCR0, CPDRSHFT, 7, 2)
    FIELD(DX7GCR0, DQSRPD, 6, 1)
    FIELD(DX7GCR0, DQSGPDR, 5, 1)
    FIELD(DX7GCR0, RESERVED_4, 4, 1)
    FIELD(DX7GCR0, DQSGODT, 3, 1)
    FIELD(DX7GCR0, DQSGOE, 2, 1)
    FIELD(DX7GCR0, RESERVED_1_0, 0, 2)
REG32(DX7GCR1, 0xe04)
    FIELD(DX7GCR1, DXPDRMODE, 16, 16)
    FIELD(DX7GCR1, RESERVED_15, 15, 1)
    FIELD(DX7GCR1, QSNSEL, 14, 1)
    FIELD(DX7GCR1, QSSEL, 13, 1)
    FIELD(DX7GCR1, OEEN, 12, 1)
    FIELD(DX7GCR1, PDREN, 11, 1)
    FIELD(DX7GCR1, TEEN, 10, 1)
    FIELD(DX7GCR1, DSEN, 9, 1)
    FIELD(DX7GCR1, DMEN, 8, 1)
    FIELD(DX7GCR1, DQEN, 0, 8)
REG32(DX7GCR2, 0xe08)
    FIELD(DX7GCR2, DXOEMODE, 16, 16)
    FIELD(DX7GCR2, DXTEMODE, 0, 16)
REG32(DX7GCR3, 0xe0c)
    FIELD(DX7GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX7GCR3, RDBVT, 29, 1)
    FIELD(DX7GCR3, WDBVT, 28, 1)
    FIELD(DX7GCR3, RGLVT, 27, 1)
    FIELD(DX7GCR3, RDLVT, 26, 1)
    FIELD(DX7GCR3, WDLVT, 25, 1)
    FIELD(DX7GCR3, WLLVT, 24, 1)
    FIELD(DX7GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX7GCR3, DSNOEMODE, 20, 2)
    FIELD(DX7GCR3, DSNTEMODE, 18, 2)
    FIELD(DX7GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX7GCR3, DMOEMODE, 14, 2)
    FIELD(DX7GCR3, DMTEMODE, 12, 2)
    FIELD(DX7GCR3, DMPDRMODE, 10, 2)
    FIELD(DX7GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX7GCR3, DSOEMODE, 6, 2)
    FIELD(DX7GCR3, DSTEMODE, 4, 2)
    FIELD(DX7GCR3, DSPDRMODE, 2, 2)
    FIELD(DX7GCR3, RESERVED_1_0, 0, 2)
REG32(DX7GCR4, 0xe10)
    FIELD(DX7GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX7GCR4, DXREFPEN, 28, 1)
    FIELD(DX7GCR4, DXREFEEN, 26, 2)
    FIELD(DX7GCR4, DXREFSEN, 25, 1)
    FIELD(DX7GCR4, RESERVED_24, 24, 1)
    FIELD(DX7GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX7GCR4, DXREFESEL, 16, 7)
    FIELD(DX7GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX7GCR4, DXREFSSEL, 8, 7)
    FIELD(DX7GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX7GCR4, DXREFIEN, 2, 4)
    FIELD(DX7GCR4, DXREFIMON, 0, 2)
REG32(DX7GCR5, 0xe14)
    FIELD(DX7GCR5, RESERVED_31, 31, 1)
    FIELD(DX7GCR5, DXREFISELR3, 24, 7)
    FIELD(DX7GCR5, RESERVED_23, 23, 1)
    FIELD(DX7GCR5, DXREFISELR2, 16, 7)
    FIELD(DX7GCR5, RESERVED_15, 15, 1)
    FIELD(DX7GCR5, DXREFISELR1, 8, 7)
    FIELD(DX7GCR5, RESERVED_7, 7, 1)
    FIELD(DX7GCR5, DXREFISELR0, 0, 7)
REG32(DX7GCR6, 0xe18)
    FIELD(DX7GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX7GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX7GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX7GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX7GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX7GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX7GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX7GCR6, DXDQVREFR0, 0, 6)
REG32(DX7BDLR0, 0xe40)
    FIELD(DX7BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX7BDLR0, DQ3WBD, 24, 6)
    FIELD(DX7BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX7BDLR0, DQ2WBD, 16, 6)
    FIELD(DX7BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX7BDLR0, DQ1WBD, 8, 6)
    FIELD(DX7BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX7BDLR0, DQ0WBD, 0, 6)
REG32(DX7BDLR1, 0xe44)
    FIELD(DX7BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX7BDLR1, DQ7WBD, 24, 6)
    FIELD(DX7BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX7BDLR1, DQ6WBD, 16, 6)
    FIELD(DX7BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX7BDLR1, DQ5WBD, 8, 6)
    FIELD(DX7BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX7BDLR1, DQ4WBD, 0, 6)
REG32(DX7BDLR2, 0xe48)
    FIELD(DX7BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX7BDLR2, DSNWBD, 24, 6)
    FIELD(DX7BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX7BDLR2, DSOEBD, 16, 6)
    FIELD(DX7BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX7BDLR2, DSWBD, 8, 6)
    FIELD(DX7BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX7BDLR2, DMWBD, 0, 6)
REG32(DX7BDLR3, 0xe50)
    FIELD(DX7BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX7BDLR3, DQ3RBD, 24, 6)
    FIELD(DX7BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX7BDLR3, DQ2RBD, 16, 6)
    FIELD(DX7BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX7BDLR3, DQ1RBD, 8, 6)
    FIELD(DX7BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX7BDLR3, DQ0RBD, 0, 6)
REG32(DX7BDLR4, 0xe54)
    FIELD(DX7BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX7BDLR4, DQ7RBD, 24, 6)
    FIELD(DX7BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX7BDLR4, DQ6RBD, 16, 6)
    FIELD(DX7BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX7BDLR4, DQ5RBD, 8, 6)
    FIELD(DX7BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX7BDLR4, DQ4RBD, 0, 6)
REG32(DX7BDLR5, 0xe58)
    FIELD(DX7BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX7BDLR5, DMRBD, 0, 6)
REG32(DX7BDLR6, 0xe60)
    FIELD(DX7BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX7BDLR6, TERBD, 16, 6)
    FIELD(DX7BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX7BDLR6, PDRBD, 8, 6)
    FIELD(DX7BDLR6, RESERVED_7_0, 0, 8)
REG32(DX7LCDLR0, 0xe80)
    FIELD(DX7LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX7LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX7LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX7LCDLR0, WLD, 0, 9)
REG32(DX7LCDLR1, 0xe84)
    FIELD(DX7LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX7LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX7LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX7LCDLR1, WDQD, 0, 9)
REG32(DX7LCDLR2, 0xe88)
    FIELD(DX7LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX7LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX7LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX7LCDLR2, DQSGD, 0, 9)
REG32(DX7LCDLR3, 0xe8c)
    FIELD(DX7LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX7LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX7LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX7LCDLR3, RDQSD, 0, 9)
REG32(DX7LCDLR4, 0xe90)
    FIELD(DX7LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX7LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX7LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX7LCDLR4, RDQSND, 0, 9)
REG32(DX7LCDLR5, 0xe94)
    FIELD(DX7LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX7LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX7LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX7LCDLR5, DQSGSD, 0, 9)
REG32(DX7MDLR0, 0xea0)
    FIELD(DX7MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX7MDLR0, TPRD, 16, 9)
    FIELD(DX7MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX7MDLR0, IPRD, 0, 9)
REG32(DX7MDLR1, 0xea4)
    FIELD(DX7MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX7MDLR1, MDLD, 0, 9)
REG32(DX7GTR0, 0xec0)
    FIELD(DX7GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX7GTR0, WDQSL, 24, 3)
    FIELD(DX7GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX7GTR0, WLSL, 16, 4)
    FIELD(DX7GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX7GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX7GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX7GTR0, DGSL, 0, 5)
REG32(DX7RSR1, 0xed4)
    FIELD(DX7RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX7RSR1, RDLVLERR, 0, 16)
REG32(DX7RSR2, 0xed8)
    FIELD(DX7RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX7RSR2, WLAWN, 0, 16)
REG32(DX7RSR3, 0xedc)
    FIELD(DX7RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX7RSR3, WLAERR, 0, 16)
REG32(DX7GSR0, 0xee0)
    FIELD(DX7GSR0, RESERVED_31, 31, 1)
    FIELD(DX7GSR0, WLDQ, 30, 1)
    FIELD(DX7GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX7GSR0, GDQSPRD, 17, 9)
    FIELD(DX7GSR0, DPLOCK, 16, 1)
    FIELD(DX7GSR0, WLPRD, 7, 9)
    FIELD(DX7GSR0, WLERR, 6, 1)
    FIELD(DX7GSR0, WLDONE, 5, 1)
    FIELD(DX7GSR0, WLCAL, 4, 1)
    FIELD(DX7GSR0, GDQSCAL, 3, 1)
    FIELD(DX7GSR0, RDQSNCAL, 2, 1)
    FIELD(DX7GSR0, RDQSCAL, 1, 1)
    FIELD(DX7GSR0, WDQCAL, 0, 1)
REG32(DX7GSR1, 0xee4)
    FIELD(DX7GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX7GSR1, DLTCODE, 1, 24)
    FIELD(DX7GSR1, DLTDONE, 0, 1)
REG32(DX7GSR2, 0xee8)
    FIELD(DX7GSR2, GSDQSPRD, 23, 9)
    FIELD(DX7GSR2, GSDQSCAL, 22, 1)
    FIELD(DX7GSR2, RESERVED_21, 21, 1)
    FIELD(DX7GSR2, SRDERR, 20, 1)
    FIELD(DX7GSR2, DQS2DQERR, 12, 4)
    FIELD(DX7GSR2, ESTAT, 8, 4)
    FIELD(DX7GSR2, WEWN, 7, 1)
    FIELD(DX7GSR2, WEERR, 6, 1)
    FIELD(DX7GSR2, REWN, 5, 1)
    FIELD(DX7GSR2, REERR, 4, 1)
    FIELD(DX7GSR2, WDWN, 3, 1)
    FIELD(DX7GSR2, WDERR, 2, 1)
    FIELD(DX7GSR2, RDWN, 1, 1)
    FIELD(DX7GSR2, RDERR, 0, 1)
REG32(DX7GSR3, 0xeec)
    FIELD(DX7GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX7GSR3, ESTAT, 24, 3)
    FIELD(DX7GSR3, DVWRN, 20, 4)
    FIELD(DX7GSR3, DVERR, 16, 4)
    FIELD(DX7GSR3, HVWRN, 12, 4)
    FIELD(DX7GSR3, HVERR, 8, 4)
    FIELD(DX7GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX7GSR3, SRDPC, 0, 2)
REG32(DX8GCR0, 0xf00)
    FIELD(DX8GCR0, CALBYP, 31, 1)
    FIELD(DX8GCR0, MDLEN, 30, 1)
    FIELD(DX8GCR0, CODTSHFT, 28, 2)
    FIELD(DX8GCR0, DQSDCC, 24, 4)
    FIELD(DX8GCR0, RDDLY, 20, 4)
    FIELD(DX8GCR0, RESERVED_19_14, 14, 6)
    FIELD(DX8GCR0, DQSNSEPDR, 13, 1)
    FIELD(DX8GCR0, DQSSEPDR, 12, 1)
    FIELD(DX8GCR0, RTTOAL, 11, 1)
    FIELD(DX8GCR0, RTTOH, 9, 2)
    FIELD(DX8GCR0, CPDRSHFT, 7, 2)
    FIELD(DX8GCR0, DQSRPD, 6, 1)
    FIELD(DX8GCR0, DQSGPDR, 5, 1)
    FIELD(DX8GCR0, RESERVED_4, 4, 1)
    FIELD(DX8GCR0, DQSGODT, 3, 1)
    FIELD(DX8GCR0, DQSGOE, 2, 1)
    FIELD(DX8GCR0, RESERVED_1_0, 0, 2)
REG32(DX8GCR1, 0xf04)
    FIELD(DX8GCR1, DXPDRMODE, 16, 16)
    FIELD(DX8GCR1, RESERVED_15, 15, 1)
    FIELD(DX8GCR1, QSNSEL, 14, 1)
    FIELD(DX8GCR1, QSSEL, 13, 1)
    FIELD(DX8GCR1, OEEN, 12, 1)
    FIELD(DX8GCR1, PDREN, 11, 1)
    FIELD(DX8GCR1, TEEN, 10, 1)
    FIELD(DX8GCR1, DSEN, 9, 1)
    FIELD(DX8GCR1, DMEN, 8, 1)
    FIELD(DX8GCR1, DQEN, 0, 8)
REG32(DX8GCR2, 0xf08)
    FIELD(DX8GCR2, DXOEMODE, 16, 16)
    FIELD(DX8GCR2, DXTEMODE, 0, 16)
REG32(DX8GCR3, 0xf0c)
    FIELD(DX8GCR3, RESERVED_31_30, 30, 2)
    FIELD(DX8GCR3, RDBVT, 29, 1)
    FIELD(DX8GCR3, WDBVT, 28, 1)
    FIELD(DX8GCR3, RGLVT, 27, 1)
    FIELD(DX8GCR3, RDLVT, 26, 1)
    FIELD(DX8GCR3, WDLVT, 25, 1)
    FIELD(DX8GCR3, WLLVT, 24, 1)
    FIELD(DX8GCR3, RESERVED_23_22, 22, 2)
    FIELD(DX8GCR3, DSNOEMODE, 20, 2)
    FIELD(DX8GCR3, DSNTEMODE, 18, 2)
    FIELD(DX8GCR3, DSNPDRMODE, 16, 2)
    FIELD(DX8GCR3, DMOEMODE, 14, 2)
    FIELD(DX8GCR3, DMTEMODE, 12, 2)
    FIELD(DX8GCR3, DMPDRMODE, 10, 2)
    FIELD(DX8GCR3, RESERVED_9_8, 8, 2)
    FIELD(DX8GCR3, DSOEMODE, 6, 2)
    FIELD(DX8GCR3, DSTEMODE, 4, 2)
    FIELD(DX8GCR3, DSPDRMODE, 2, 2)
    FIELD(DX8GCR3, RESERVED_1_0, 0, 2)
REG32(DX8GCR4, 0xf10)
    FIELD(DX8GCR4, RESERVED_31_29, 29, 3)
    FIELD(DX8GCR4, DXREFPEN, 28, 1)
    FIELD(DX8GCR4, DXREFEEN, 26, 2)
    FIELD(DX8GCR4, DXREFSEN, 25, 1)
    FIELD(DX8GCR4, RESERVED_24, 24, 1)
    FIELD(DX8GCR4, DXREFESELRANGE, 23, 1)
    FIELD(DX8GCR4, DXREFESEL, 16, 7)
    FIELD(DX8GCR4, DXREFSSELRANGE, 15, 1)
    FIELD(DX8GCR4, DXREFSSEL, 8, 7)
    FIELD(DX8GCR4, RESERVED_7_6, 6, 2)
    FIELD(DX8GCR4, DXREFIEN, 2, 4)
    FIELD(DX8GCR4, DXREFIMON, 0, 2)
REG32(DX8GCR5, 0xf14)
    FIELD(DX8GCR5, RESERVED_31, 31, 1)
    FIELD(DX8GCR5, DXREFISELR3, 24, 7)
    FIELD(DX8GCR5, RESERVED_23, 23, 1)
    FIELD(DX8GCR5, DXREFISELR2, 16, 7)
    FIELD(DX8GCR5, RESERVED_15, 15, 1)
    FIELD(DX8GCR5, DXREFISELR1, 8, 7)
    FIELD(DX8GCR5, RESERVED_7, 7, 1)
    FIELD(DX8GCR5, DXREFISELR0, 0, 7)
REG32(DX8GCR6, 0xf18)
    FIELD(DX8GCR6, RESERVED_31_30, 30, 2)
    FIELD(DX8GCR6, DXDQVREFR3, 24, 6)
    FIELD(DX8GCR6, RESERVED_23_22, 22, 2)
    FIELD(DX8GCR6, DXDQVREFR2, 16, 6)
    FIELD(DX8GCR6, RESERVED_15_14, 14, 2)
    FIELD(DX8GCR6, DXDQVREFR1, 8, 6)
    FIELD(DX8GCR6, RESERVED_7_6, 6, 2)
    FIELD(DX8GCR6, DXDQVREFR0, 0, 6)
REG32(DX8BDLR0, 0xf40)
    FIELD(DX8BDLR0, RESERVED_31_30, 30, 2)
    FIELD(DX8BDLR0, DQ3WBD, 24, 6)
    FIELD(DX8BDLR0, RESERVED_23_22, 22, 2)
    FIELD(DX8BDLR0, DQ2WBD, 16, 6)
    FIELD(DX8BDLR0, RESERVED_15_14, 14, 2)
    FIELD(DX8BDLR0, DQ1WBD, 8, 6)
    FIELD(DX8BDLR0, RESERVED_7_6, 6, 2)
    FIELD(DX8BDLR0, DQ0WBD, 0, 6)
REG32(DX8BDLR1, 0xf44)
    FIELD(DX8BDLR1, RESERVED_31_30, 30, 2)
    FIELD(DX8BDLR1, DQ7WBD, 24, 6)
    FIELD(DX8BDLR1, RESERVED_23_22, 22, 2)
    FIELD(DX8BDLR1, DQ6WBD, 16, 6)
    FIELD(DX8BDLR1, RESERVED_15_14, 14, 2)
    FIELD(DX8BDLR1, DQ5WBD, 8, 6)
    FIELD(DX8BDLR1, RESERVED_7_6, 6, 2)
    FIELD(DX8BDLR1, DQ4WBD, 0, 6)
REG32(DX8BDLR2, 0xf48)
    FIELD(DX8BDLR2, RESERVED_31_30, 30, 2)
    FIELD(DX8BDLR2, DSNWBD, 24, 6)
    FIELD(DX8BDLR2, RESERVED_23_22, 22, 2)
    FIELD(DX8BDLR2, DSOEBD, 16, 6)
    FIELD(DX8BDLR2, RESERVED_15_14, 14, 2)
    FIELD(DX8BDLR2, DSWBD, 8, 6)
    FIELD(DX8BDLR2, RESERVED_7_6, 6, 2)
    FIELD(DX8BDLR2, DMWBD, 0, 6)
REG32(DX8BDLR3, 0xf50)
    FIELD(DX8BDLR3, RESERVED_31_30, 30, 2)
    FIELD(DX8BDLR3, DQ3RBD, 24, 6)
    FIELD(DX8BDLR3, RESERVED_23_22, 22, 2)
    FIELD(DX8BDLR3, DQ2RBD, 16, 6)
    FIELD(DX8BDLR3, RESERVED_15_14, 14, 2)
    FIELD(DX8BDLR3, DQ1RBD, 8, 6)
    FIELD(DX8BDLR3, RESERVED_7_6, 6, 2)
    FIELD(DX8BDLR3, DQ0RBD, 0, 6)
REG32(DX8BDLR4, 0xf54)
    FIELD(DX8BDLR4, RESERVED_31_30, 30, 2)
    FIELD(DX8BDLR4, DQ7RBD, 24, 6)
    FIELD(DX8BDLR4, RESERVED_23_22, 22, 2)
    FIELD(DX8BDLR4, DQ6RBD, 16, 6)
    FIELD(DX8BDLR4, RESERVED_15_14, 14, 2)
    FIELD(DX8BDLR4, DQ5RBD, 8, 6)
    FIELD(DX8BDLR4, RESERVED_7_6, 6, 2)
    FIELD(DX8BDLR4, DQ4RBD, 0, 6)
REG32(DX8BDLR5, 0xf58)
    FIELD(DX8BDLR5, RESERVED_31_6, 6, 26)
    FIELD(DX8BDLR5, DMRBD, 0, 6)
REG32(DX8BDLR6, 0xf60)
    FIELD(DX8BDLR6, RESERVED_31_22, 22, 10)
    FIELD(DX8BDLR6, TERBD, 16, 6)
    FIELD(DX8BDLR6, RESERVED_15_14, 14, 2)
    FIELD(DX8BDLR6, PDRBD, 8, 6)
    FIELD(DX8BDLR6, RESERVED_7_0, 0, 8)
REG32(DX8LCDLR0, 0xf80)
    FIELD(DX8LCDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX8LCDLR0, RESERVED_24_16, 16, 9)
    FIELD(DX8LCDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX8LCDLR0, WLD, 0, 9)
REG32(DX8LCDLR1, 0xf84)
    FIELD(DX8LCDLR1, RESERVED_31_25, 25, 7)
    FIELD(DX8LCDLR1, RESERVED_24_16, 16, 9)
    FIELD(DX8LCDLR1, RESERVED_15_9, 9, 7)
    FIELD(DX8LCDLR1, WDQD, 0, 9)
REG32(DX8LCDLR2, 0xf88)
    FIELD(DX8LCDLR2, RESERVED_31_25, 25, 7)
    FIELD(DX8LCDLR2, RESERVED_24_16, 16, 9)
    FIELD(DX8LCDLR2, RESERVED_15_9, 9, 7)
    FIELD(DX8LCDLR2, DQSGD, 0, 9)
REG32(DX8LCDLR3, 0xf8c)
    FIELD(DX8LCDLR3, RESERVED_31_25, 25, 7)
    FIELD(DX8LCDLR3, RESERVED_24_16, 16, 9)
    FIELD(DX8LCDLR3, RESERVED_15_9, 9, 7)
    FIELD(DX8LCDLR3, RDQSD, 0, 9)
REG32(DX8LCDLR4, 0xf90)
    FIELD(DX8LCDLR4, RESERVED_31_25, 25, 7)
    FIELD(DX8LCDLR4, RESERVED_24_16, 16, 9)
    FIELD(DX8LCDLR4, RESERVED_15_9, 9, 7)
    FIELD(DX8LCDLR4, RDQSND, 0, 9)
REG32(DX8LCDLR5, 0xf94)
    FIELD(DX8LCDLR5, RESERVED_31_25, 25, 7)
    FIELD(DX8LCDLR5, RESERVED_24_16, 16, 9)
    FIELD(DX8LCDLR5, RESERVED_15_9, 9, 7)
    FIELD(DX8LCDLR5, DQSGSD, 0, 9)
REG32(DX8MDLR0, 0xfa0)
    FIELD(DX8MDLR0, RESERVED_31_25, 25, 7)
    FIELD(DX8MDLR0, TPRD, 16, 9)
    FIELD(DX8MDLR0, RESERVED_15_9, 9, 7)
    FIELD(DX8MDLR0, IPRD, 0, 9)
REG32(DX8MDLR1, 0xfa4)
    FIELD(DX8MDLR1, RESERVED_31_9, 9, 23)
    FIELD(DX8MDLR1, MDLD, 0, 9)
REG32(DX8GTR0, 0xfc0)
    FIELD(DX8GTR0, RESERVED_31_24, 27, 5)
    FIELD(DX8GTR0, WDQSL, 24, 3)
    FIELD(DX8GTR0, RESERVED_23_20, 20, 4)
    FIELD(DX8GTR0, WLSL, 16, 4)
    FIELD(DX8GTR0, RESERVED_15_13, 13, 3)
    FIELD(DX8GTR0, RESERVED_12_8, 8, 5)
    FIELD(DX8GTR0, RESERVED_7_5, 5, 3)
    FIELD(DX8GTR0, DGSL, 0, 5)
REG32(DX8RSR1, 0xfd4)
    FIELD(DX8RSR1, RESERVED_31_16, 16, 16)
    FIELD(DX8RSR1, RDLVLERR, 0, 16)
REG32(DX8RSR2, 0xfd8)
    FIELD(DX8RSR2, RESERVED_31_16, 16, 16)
    FIELD(DX8RSR2, WLAWN, 0, 16)
REG32(DX8RSR3, 0xfdc)
    FIELD(DX8RSR3, RESERVED_31_16, 16, 16)
    FIELD(DX8RSR3, WLAERR, 0, 16)
REG32(DX8GSR0, 0xfe0)
    FIELD(DX8GSR0, RESERVED_31, 31, 1)
    FIELD(DX8GSR0, WLDQ, 30, 1)
    FIELD(DX8GSR0, RESERVED_29_26, 26, 4)
    FIELD(DX8GSR0, GDQSPRD, 17, 9)
    FIELD(DX8GSR0, DPLOCK, 16, 1)
    FIELD(DX8GSR0, WLPRD, 7, 9)
    FIELD(DX8GSR0, WLERR, 6, 1)
    FIELD(DX8GSR0, WLDONE, 5, 1)
    FIELD(DX8GSR0, WLCAL, 4, 1)
    FIELD(DX8GSR0, GDQSCAL, 3, 1)
    FIELD(DX8GSR0, RDQSNCAL, 2, 1)
    FIELD(DX8GSR0, RDQSCAL, 1, 1)
    FIELD(DX8GSR0, WDQCAL, 0, 1)
REG32(DX8GSR1, 0xfe4)
    FIELD(DX8GSR1, RESERVED_31_25, 25, 7)
    FIELD(DX8GSR1, DLTCODE, 1, 24)
    FIELD(DX8GSR1, DLTDONE, 0, 1)
REG32(DX8GSR2, 0xfe8)
    FIELD(DX8GSR2, GSDQSPRD, 23, 9)
    FIELD(DX8GSR2, GSDQSCAL, 22, 1)
    FIELD(DX8GSR2, RESERVED_21, 21, 1)
    FIELD(DX8GSR2, SRDERR, 20, 1)
    FIELD(DX8GSR2, DQS2DQERR, 12, 4)
    FIELD(DX8GSR2, ESTAT, 8, 4)
    FIELD(DX8GSR2, WEWN, 7, 1)
    FIELD(DX8GSR2, WEERR, 6, 1)
    FIELD(DX8GSR2, REWN, 5, 1)
    FIELD(DX8GSR2, REERR, 4, 1)
    FIELD(DX8GSR2, WDWN, 3, 1)
    FIELD(DX8GSR2, WDERR, 2, 1)
    FIELD(DX8GSR2, RDWN, 1, 1)
    FIELD(DX8GSR2, RDERR, 0, 1)
REG32(DX8GSR3, 0xfec)
    FIELD(DX8GSR3, RESERVED_31_27, 27, 5)
    FIELD(DX8GSR3, ESTAT, 24, 3)
    FIELD(DX8GSR3, DVWRN, 20, 4)
    FIELD(DX8GSR3, DVERR, 16, 4)
    FIELD(DX8GSR3, HVWRN, 12, 4)
    FIELD(DX8GSR3, HVERR, 8, 4)
    FIELD(DX8GSR3, RESERVED_7_2, 2, 6)
    FIELD(DX8GSR3, SRDPC, 0, 2)
REG32(DX8SL0OSC, 0x1400)
    FIELD(DX8SL0OSC, RESERVED_31_30, 30, 2)
    FIELD(DX8SL0OSC, GATEDXRDCLK, 28, 2)
    FIELD(DX8SL0OSC, GATEDXDDRCLK, 26, 2)
    FIELD(DX8SL0OSC, GATEDXCTLCLK, 24, 2)
    FIELD(DX8SL0OSC, CLKLEVEL, 22, 2)
    FIELD(DX8SL0OSC, LBMODE, 21, 1)
    FIELD(DX8SL0OSC, LBGSDQS, 20, 1)
    FIELD(DX8SL0OSC, LBGDQS, 18, 2)
    FIELD(DX8SL0OSC, LBDQSS, 17, 1)
    FIELD(DX8SL0OSC, PHYHRST, 16, 1)
    FIELD(DX8SL0OSC, PHYFRST, 15, 1)
    FIELD(DX8SL0OSC, DLTST, 14, 1)
    FIELD(DX8SL0OSC, DLTMODE, 13, 1)
    FIELD(DX8SL0OSC, RESERVED_12_11, 11, 2)
    FIELD(DX8SL0OSC, OSCWDDL, 9, 2)
    FIELD(DX8SL0OSC, RESERVED_8_7, 7, 2)
    FIELD(DX8SL0OSC, OSCWDL, 5, 2)
    FIELD(DX8SL0OSC, OSCDIV, 1, 4)
    FIELD(DX8SL0OSC, OSCEN, 0, 1)
REG32(DX8SL0PLLCR0, 0x1404)
    FIELD(DX8SL0PLLCR0, PLLBYP, 31, 1)
    FIELD(DX8SL0PLLCR0, PLLRST, 30, 1)
    FIELD(DX8SL0PLLCR0, PLLPD, 29, 1)
    FIELD(DX8SL0PLLCR0, RSTOPM, 28, 1)
    FIELD(DX8SL0PLLCR0, FRQSEL, 24, 4)
    FIELD(DX8SL0PLLCR0, RLOCKM, 23, 1)
    FIELD(DX8SL0PLLCR0, CPPC, 17, 6)
    FIELD(DX8SL0PLLCR0, CPIC, 13, 4)
    FIELD(DX8SL0PLLCR0, GSHIFT, 12, 1)
    FIELD(DX8SL0PLLCR0, RESERVED_11_9, 9, 3)
    FIELD(DX8SL0PLLCR0, ATOEN, 8, 1)
    FIELD(DX8SL0PLLCR0, ATC, 4, 4)
    FIELD(DX8SL0PLLCR0, DTC, 0, 4)
REG32(DX8SL0PLLCR1, 0x1408)
    FIELD(DX8SL0PLLCR1, RESERVED_31_22, 22, 10)
    FIELD(DX8SL0PLLCR1, PLLPROG, 6, 16)
    FIELD(DX8SL0PLLCR1, BYPVREGCP, 5, 1)
    FIELD(DX8SL0PLLCR1, BYPVREGDIG, 4, 1)
    FIELD(DX8SL0PLLCR1, BYPVDD, 3, 1)
    FIELD(DX8SL0PLLCR1, LOCKPS, 2, 1)
    FIELD(DX8SL0PLLCR1, LOCKCS, 1, 1)
    FIELD(DX8SL0PLLCR1, LOCKDS, 0, 1)
REG32(DX8SL0PLLCR2, 0x140c)
REG32(DX8SL0PLLCR3, 0x1410)
REG32(DX8SL0PLLCR4, 0x1414)
REG32(DX8SL0PLLCR5, 0x1418)
    FIELD(DX8SL0PLLCR5, RESERVED_31_8, 8, 24)
    FIELD(DX8SL0PLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DX8SL0DQSCTL, 0x141c)
    FIELD(DX8SL0DQSCTL, RESERVED_31_25, 25, 7)
    FIELD(DX8SL0DQSCTL, RRRMODE, 24, 1)
    FIELD(DX8SL0DQSCTL, RESERVED_23_22, 22, 2)
    FIELD(DX8SL0DQSCTL, WRRMODE, 21, 1)
    FIELD(DX8SL0DQSCTL, DQSGX, 19, 2)
    FIELD(DX8SL0DQSCTL, LPPLLPD, 18, 1)
    FIELD(DX8SL0DQSCTL, LPIOPD, 17, 1)
    FIELD(DX8SL0DQSCTL, RESERVED_16_15, 15, 2)
    FIELD(DX8SL0DQSCTL, QSCNTEN, 14, 1)
    FIELD(DX8SL0DQSCTL, UDQIOM, 13, 1)
    FIELD(DX8SL0DQSCTL, RESERVED_12_10, 10, 3)
    FIELD(DX8SL0DQSCTL, DXSR, 8, 2)
    FIELD(DX8SL0DQSCTL, DQSNRES, 4, 4)
    FIELD(DX8SL0DQSCTL, DQSRES, 0, 4)
REG32(DX8SL0TRNCTL, 0x1420)
REG32(DX8SL0DDLCTL, 0x1424)
    FIELD(DX8SL0DDLCTL, RESERVED_31_27, 27, 5)
    FIELD(DX8SL0DDLCTL, DLYLDTM, 26, 1)
    FIELD(DX8SL0DDLCTL, DXDDLLDT, 25, 1)
    FIELD(DX8SL0DDLCTL, RESERVED_24_23, 23, 2)
    FIELD(DX8SL0DDLCTL, DXDDLLD, 18, 5)
    FIELD(DX8SL0DDLCTL, DXDDLBYP, 2, 16)
    FIELD(DX8SL0DDLCTL, DDLBYPMODE, 0, 2)
REG32(DX8SL0DXCTL1, 0x1428)
    FIELD(DX8SL0DXCTL1, RESERVED_31_25, 25, 7)
    FIELD(DX8SL0DXCTL1, DXCALCLK, 24, 1)
    FIELD(DX8SL0DXCTL1, DXRCLKMD, 23, 1)
    FIELD(DX8SL0DXCTL1, RESERVED_22, 22, 1)
    FIELD(DX8SL0DXCTL1, DXDTOSEL, 20, 2)
    FIELD(DX8SL0DXCTL1, DXGSMD, 19, 1)
    FIELD(DX8SL0DXCTL1, DXQSDBYP, 18, 1)
    FIELD(DX8SL0DXCTL1, DXGDBYP, 17, 1)
    FIELD(DX8SL0DXCTL1, DXTMODE, 16, 1)
    FIELD(DX8SL0DXCTL1, RESERVED_15_0, 0, 16)
REG32(DX8SL0DXCTL2, 0x142c)
    FIELD(DX8SL0DXCTL2, RESERVED_31_24, 24, 8)
    FIELD(DX8SL0DXCTL2, CRDEN, 23, 1)
    FIELD(DX8SL0DXCTL2, POSOEX, 20, 3)
    FIELD(DX8SL0DXCTL2, PREOEX, 18, 2)
    FIELD(DX8SL0DXCTL2, RESERVED_17, 17, 1)
    FIELD(DX8SL0DXCTL2, IOAG, 16, 1)
    FIELD(DX8SL0DXCTL2, IOLB, 15, 1)
    FIELD(DX8SL0DXCTL2, RESERVED_14_13, 13, 2)
    FIELD(DX8SL0DXCTL2, LPWAKEUP_THRSH, 9, 4)
    FIELD(DX8SL0DXCTL2, RDBI, 8, 1)
    FIELD(DX8SL0DXCTL2, WDBI, 7, 1)
    FIELD(DX8SL0DXCTL2, PRFBYP, 6, 1)
    FIELD(DX8SL0DXCTL2, RDMODE, 4, 2)
    FIELD(DX8SL0DXCTL2, DISRST, 3, 1)
    FIELD(DX8SL0DXCTL2, DQSGLB, 1, 2)
    FIELD(DX8SL0DXCTL2, RESERVED_0, 0, 1)
REG32(DX8SL0IOCR, 0x1430)
    FIELD(DX8SL0IOCR, RESERVED_31, 31, 1)
    FIELD(DX8SL0IOCR, DXDACRANGE, 28, 3)
    FIELD(DX8SL0IOCR, DXVREFIOM, 25, 3)
    FIELD(DX8SL0IOCR, DXIOM, 22, 3)
    FIELD(DX8SL0IOCR, DXTXM, 11, 11)
    FIELD(DX8SL0IOCR, DXRXM, 0, 11)
REG32(DX8SL1OSC, 0x1440)
    FIELD(DX8SL1OSC, RESERVED_31_30, 30, 2)
    FIELD(DX8SL1OSC, GATEDXRDCLK, 28, 2)
    FIELD(DX8SL1OSC, GATEDXDDRCLK, 26, 2)
    FIELD(DX8SL1OSC, GATEDXCTLCLK, 24, 2)
    FIELD(DX8SL1OSC, CLKLEVEL, 22, 2)
    FIELD(DX8SL1OSC, LBMODE, 21, 1)
    FIELD(DX8SL1OSC, LBGSDQS, 20, 1)
    FIELD(DX8SL1OSC, LBGDQS, 18, 2)
    FIELD(DX8SL1OSC, LBDQSS, 17, 1)
    FIELD(DX8SL1OSC, PHYHRST, 16, 1)
    FIELD(DX8SL1OSC, PHYFRST, 15, 1)
    FIELD(DX8SL1OSC, DLTST, 14, 1)
    FIELD(DX8SL1OSC, DLTMODE, 13, 1)
    FIELD(DX8SL1OSC, RESERVED_12_11, 11, 2)
    FIELD(DX8SL1OSC, OSCWDDL, 9, 2)
    FIELD(DX8SL1OSC, RESERVED_8_7, 7, 2)
    FIELD(DX8SL1OSC, OSCWDL, 5, 2)
    FIELD(DX8SL1OSC, OSCDIV, 1, 4)
    FIELD(DX8SL1OSC, OSCEN, 0, 1)
REG32(DX8SL1PLLCR0, 0x1444)
    FIELD(DX8SL1PLLCR0, PLLBYP, 31, 1)
    FIELD(DX8SL1PLLCR0, PLLRST, 30, 1)
    FIELD(DX8SL1PLLCR0, PLLPD, 29, 1)
    FIELD(DX8SL1PLLCR0, RSTOPM, 28, 1)
    FIELD(DX8SL1PLLCR0, FRQSEL, 24, 4)
    FIELD(DX8SL1PLLCR0, RLOCKM, 23, 1)
    FIELD(DX8SL1PLLCR0, CPPC, 17, 6)
    FIELD(DX8SL1PLLCR0, CPIC, 13, 4)
    FIELD(DX8SL1PLLCR0, GSHIFT, 12, 1)
    FIELD(DX8SL1PLLCR0, RESERVED_11_9, 9, 3)
    FIELD(DX8SL1PLLCR0, ATOEN, 8, 1)
    FIELD(DX8SL1PLLCR0, ATC, 4, 4)
    FIELD(DX8SL1PLLCR0, DTC, 0, 4)
REG32(DX8SL1PLLCR1, 0x1448)
    FIELD(DX8SL1PLLCR1, RESERVED_31_22, 22, 10)
    FIELD(DX8SL1PLLCR1, PLLPROG, 6, 16)
    FIELD(DX8SL1PLLCR1, BYPVREGCP, 5, 1)
    FIELD(DX8SL1PLLCR1, BYPVREGDIG, 4, 1)
    FIELD(DX8SL1PLLCR1, BYPVDD, 3, 1)
    FIELD(DX8SL1PLLCR1, LOCKPS, 2, 1)
    FIELD(DX8SL1PLLCR1, LOCKCS, 1, 1)
    FIELD(DX8SL1PLLCR1, LOCKDS, 0, 1)
REG32(DX8SL1PLLCR2, 0x144c)
REG32(DX8SL1PLLCR3, 0x1450)
REG32(DX8SL1PLLCR4, 0x1454)
REG32(DX8SL1PLLCR5, 0x1458)
    FIELD(DX8SL1PLLCR5, RESERVED_31_8, 8, 24)
    FIELD(DX8SL1PLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DX8SL1DQSCTL, 0x145c)
    FIELD(DX8SL1DQSCTL, RESERVED_31_25, 25, 7)
    FIELD(DX8SL1DQSCTL, RRRMODE, 24, 1)
    FIELD(DX8SL1DQSCTL, RESERVED_23_22, 22, 2)
    FIELD(DX8SL1DQSCTL, WRRMODE, 21, 1)
    FIELD(DX8SL1DQSCTL, DQSGX, 19, 2)
    FIELD(DX8SL1DQSCTL, LPPLLPD, 18, 1)
    FIELD(DX8SL1DQSCTL, LPIOPD, 17, 1)
    FIELD(DX8SL1DQSCTL, RESERVED_16_15, 15, 2)
    FIELD(DX8SL1DQSCTL, QSCNTEN, 14, 1)
    FIELD(DX8SL1DQSCTL, UDQIOM, 13, 1)
    FIELD(DX8SL1DQSCTL, RESERVED_12_10, 10, 3)
    FIELD(DX8SL1DQSCTL, DXSR, 8, 2)
    FIELD(DX8SL1DQSCTL, DQSNRES, 4, 4)
    FIELD(DX8SL1DQSCTL, DQSRES, 0, 4)
REG32(DX8SL1TRNCTL, 0x1460)
REG32(DX8SL1DDLCTL, 0x1464)
    FIELD(DX8SL1DDLCTL, RESERVED_31_27, 27, 5)
    FIELD(DX8SL1DDLCTL, DLYLDTM, 26, 1)
    FIELD(DX8SL1DDLCTL, DXDDLLDT, 25, 1)
    FIELD(DX8SL1DDLCTL, RESERVED_24_23, 23, 2)
    FIELD(DX8SL1DDLCTL, DXDDLLD, 18, 5)
    FIELD(DX8SL1DDLCTL, DXDDLBYP, 2, 16)
    FIELD(DX8SL1DDLCTL, DDLBYPMODE, 0, 2)
REG32(DX8SL1DXCTL1, 0x1468)
    FIELD(DX8SL1DXCTL1, RESERVED_31_25, 25, 7)
    FIELD(DX8SL1DXCTL1, DXCALCLK, 24, 1)
    FIELD(DX8SL1DXCTL1, DXRCLKMD, 23, 1)
    FIELD(DX8SL1DXCTL1, RESERVED_22, 22, 1)
    FIELD(DX8SL1DXCTL1, DXDTOSEL, 20, 2)
    FIELD(DX8SL1DXCTL1, DXGSMD, 19, 1)
    FIELD(DX8SL1DXCTL1, DXQSDBYP, 18, 1)
    FIELD(DX8SL1DXCTL1, DXGDBYP, 17, 1)
    FIELD(DX8SL1DXCTL1, DXTMODE, 16, 1)
    FIELD(DX8SL1DXCTL1, RESERVED_15_0, 0, 16)
REG32(DX8SL1DXCTL2, 0x146c)
    FIELD(DX8SL1DXCTL2, RESERVED_31_24, 24, 8)
    FIELD(DX8SL1DXCTL2, CRDEN, 23, 1)
    FIELD(DX8SL1DXCTL2, POSOEX, 20, 3)
    FIELD(DX8SL1DXCTL2, PREOEX, 18, 2)
    FIELD(DX8SL1DXCTL2, RESERVED_17, 17, 1)
    FIELD(DX8SL1DXCTL2, IOAG, 16, 1)
    FIELD(DX8SL1DXCTL2, IOLB, 15, 1)
    FIELD(DX8SL1DXCTL2, RESERVED_14_13, 13, 2)
    FIELD(DX8SL1DXCTL2, LPWAKEUP_THRSH, 9, 4)
    FIELD(DX8SL1DXCTL2, RDBI, 8, 1)
    FIELD(DX8SL1DXCTL2, WDBI, 7, 1)
    FIELD(DX8SL1DXCTL2, PRFBYP, 6, 1)
    FIELD(DX8SL1DXCTL2, RDMODE, 4, 2)
    FIELD(DX8SL1DXCTL2, DISRST, 3, 1)
    FIELD(DX8SL1DXCTL2, DQSGLB, 1, 2)
    FIELD(DX8SL1DXCTL2, RESERVED_0, 0, 1)
REG32(DX8SL1IOCR, 0x1470)
    FIELD(DX8SL1IOCR, RESERVED_31, 31, 1)
    FIELD(DX8SL1IOCR, DXDACRANGE, 28, 3)
    FIELD(DX8SL1IOCR, DXVREFIOM, 25, 3)
    FIELD(DX8SL1IOCR, DXIOM, 22, 3)
    FIELD(DX8SL1IOCR, DXTXM, 11, 11)
    FIELD(DX8SL1IOCR, DXRXM, 0, 11)
REG32(DX8SL2OSC, 0x1480)
    FIELD(DX8SL2OSC, RESERVED_31_30, 30, 2)
    FIELD(DX8SL2OSC, GATEDXRDCLK, 28, 2)
    FIELD(DX8SL2OSC, GATEDXDDRCLK, 26, 2)
    FIELD(DX8SL2OSC, GATEDXCTLCLK, 24, 2)
    FIELD(DX8SL2OSC, CLKLEVEL, 22, 2)
    FIELD(DX8SL2OSC, LBMODE, 21, 1)
    FIELD(DX8SL2OSC, LBGSDQS, 20, 1)
    FIELD(DX8SL2OSC, LBGDQS, 18, 2)
    FIELD(DX8SL2OSC, LBDQSS, 17, 1)
    FIELD(DX8SL2OSC, PHYHRST, 16, 1)
    FIELD(DX8SL2OSC, PHYFRST, 15, 1)
    FIELD(DX8SL2OSC, DLTST, 14, 1)
    FIELD(DX8SL2OSC, DLTMODE, 13, 1)
    FIELD(DX8SL2OSC, RESERVED_12_11, 11, 2)
    FIELD(DX8SL2OSC, OSCWDDL, 9, 2)
    FIELD(DX8SL2OSC, RESERVED_8_7, 7, 2)
    FIELD(DX8SL2OSC, OSCWDL, 5, 2)
    FIELD(DX8SL2OSC, OSCDIV, 1, 4)
    FIELD(DX8SL2OSC, OSCEN, 0, 1)
REG32(DX8SL2PLLCR0, 0x1484)
    FIELD(DX8SL2PLLCR0, PLLBYP, 31, 1)
    FIELD(DX8SL2PLLCR0, PLLRST, 30, 1)
    FIELD(DX8SL2PLLCR0, PLLPD, 29, 1)
    FIELD(DX8SL2PLLCR0, RSTOPM, 28, 1)
    FIELD(DX8SL2PLLCR0, FRQSEL, 24, 4)
    FIELD(DX8SL2PLLCR0, RLOCKM, 23, 1)
    FIELD(DX8SL2PLLCR0, CPPC, 17, 6)
    FIELD(DX8SL2PLLCR0, CPIC, 13, 4)
    FIELD(DX8SL2PLLCR0, GSHIFT, 12, 1)
    FIELD(DX8SL2PLLCR0, RESERVED_11_9, 9, 3)
    FIELD(DX8SL2PLLCR0, ATOEN, 8, 1)
    FIELD(DX8SL2PLLCR0, ATC, 4, 4)
    FIELD(DX8SL2PLLCR0, DTC, 0, 4)
REG32(DX8SL2PLLCR1, 0x1488)
    FIELD(DX8SL2PLLCR1, RESERVED_31_22, 22, 10)
    FIELD(DX8SL2PLLCR1, PLLPROG, 6, 16)
    FIELD(DX8SL2PLLCR1, BYPVREGCP, 5, 1)
    FIELD(DX8SL2PLLCR1, BYPVREGDIG, 4, 1)
    FIELD(DX8SL2PLLCR1, BYPVDD, 3, 1)
    FIELD(DX8SL2PLLCR1, LOCKPS, 2, 1)
    FIELD(DX8SL2PLLCR1, LOCKCS, 1, 1)
    FIELD(DX8SL2PLLCR1, LOCKDS, 0, 1)
REG32(DX8SL2PLLCR2, 0x148c)
REG32(DX8SL2PLLCR3, 0x1490)
REG32(DX8SL2PLLCR4, 0x1494)
REG32(DX8SL2PLLCR5, 0x1498)
    FIELD(DX8SL2PLLCR5, RESERVED_31_8, 8, 24)
    FIELD(DX8SL2PLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DX8SL2DQSCTL, 0x149c)
    FIELD(DX8SL2DQSCTL, RESERVED_31_25, 25, 7)
    FIELD(DX8SL2DQSCTL, RRRMODE, 24, 1)
    FIELD(DX8SL2DQSCTL, RESERVED_23_22, 22, 2)
    FIELD(DX8SL2DQSCTL, WRRMODE, 21, 1)
    FIELD(DX8SL2DQSCTL, DQSGX, 19, 2)
    FIELD(DX8SL2DQSCTL, LPPLLPD, 18, 1)
    FIELD(DX8SL2DQSCTL, LPIOPD, 17, 1)
    FIELD(DX8SL2DQSCTL, RESERVED_16_15, 15, 2)
    FIELD(DX8SL2DQSCTL, QSCNTEN, 14, 1)
    FIELD(DX8SL2DQSCTL, UDQIOM, 13, 1)
    FIELD(DX8SL2DQSCTL, RESERVED_12_10, 10, 3)
    FIELD(DX8SL2DQSCTL, DXSR, 8, 2)
    FIELD(DX8SL2DQSCTL, DQSNRES, 4, 4)
    FIELD(DX8SL2DQSCTL, DQSRES, 0, 4)
REG32(DX8SL2TRNCTL, 0x14a0)
REG32(DX8SL2DDLCTL, 0x14a4)
    FIELD(DX8SL2DDLCTL, RESERVED_31_27, 27, 5)
    FIELD(DX8SL2DDLCTL, DLYLDTM, 26, 1)
    FIELD(DX8SL2DDLCTL, DXDDLLDT, 25, 1)
    FIELD(DX8SL2DDLCTL, RESERVED_24_23, 23, 2)
    FIELD(DX8SL2DDLCTL, DXDDLLD, 18, 5)
    FIELD(DX8SL2DDLCTL, DXDDLBYP, 2, 16)
    FIELD(DX8SL2DDLCTL, DDLBYPMODE, 0, 2)
REG32(DX8SL2DXCTL1, 0x14a8)
    FIELD(DX8SL2DXCTL1, RESERVED_31_25, 25, 7)
    FIELD(DX8SL2DXCTL1, DXCALCLK, 24, 1)
    FIELD(DX8SL2DXCTL1, DXRCLKMD, 23, 1)
    FIELD(DX8SL2DXCTL1, RESERVED_22, 22, 1)
    FIELD(DX8SL2DXCTL1, DXDTOSEL, 20, 2)
    FIELD(DX8SL2DXCTL1, DXGSMD, 19, 1)
    FIELD(DX8SL2DXCTL1, DXQSDBYP, 18, 1)
    FIELD(DX8SL2DXCTL1, DXGDBYP, 17, 1)
    FIELD(DX8SL2DXCTL1, DXTMODE, 16, 1)
    FIELD(DX8SL2DXCTL1, RESERVED_15_0, 0, 16)
REG32(DX8SL2DXCTL2, 0x14ac)
    FIELD(DX8SL2DXCTL2, RESERVED_31_24, 24, 8)
    FIELD(DX8SL2DXCTL2, CRDEN, 23, 1)
    FIELD(DX8SL2DXCTL2, POSOEX, 20, 3)
    FIELD(DX8SL2DXCTL2, PREOEX, 18, 2)
    FIELD(DX8SL2DXCTL2, RESERVED_17, 17, 1)
    FIELD(DX8SL2DXCTL2, IOAG, 16, 1)
    FIELD(DX8SL2DXCTL2, IOLB, 15, 1)
    FIELD(DX8SL2DXCTL2, RESERVED_14_13, 13, 2)
    FIELD(DX8SL2DXCTL2, LPWAKEUP_THRSH, 9, 4)
    FIELD(DX8SL2DXCTL2, RDBI, 8, 1)
    FIELD(DX8SL2DXCTL2, WDBI, 7, 1)
    FIELD(DX8SL2DXCTL2, PRFBYP, 6, 1)
    FIELD(DX8SL2DXCTL2, RDMODE, 4, 2)
    FIELD(DX8SL2DXCTL2, DISRST, 3, 1)
    FIELD(DX8SL2DXCTL2, DQSGLB, 1, 2)
    FIELD(DX8SL2DXCTL2, RESERVED_0, 0, 1)
REG32(DX8SL2IOCR, 0x14b0)
    FIELD(DX8SL2IOCR, RESERVED_31, 31, 1)
    FIELD(DX8SL2IOCR, DXDACRANGE, 28, 3)
    FIELD(DX8SL2IOCR, DXVREFIOM, 25, 3)
    FIELD(DX8SL2IOCR, DXIOM, 22, 3)
    FIELD(DX8SL2IOCR, DXTXM, 11, 11)
    FIELD(DX8SL2IOCR, DXRXM, 0, 11)
REG32(DX8SL3OSC, 0x14c0)
    FIELD(DX8SL3OSC, RESERVED_31_30, 30, 2)
    FIELD(DX8SL3OSC, GATEDXRDCLK, 28, 2)
    FIELD(DX8SL3OSC, GATEDXDDRCLK, 26, 2)
    FIELD(DX8SL3OSC, GATEDXCTLCLK, 24, 2)
    FIELD(DX8SL3OSC, CLKLEVEL, 22, 2)
    FIELD(DX8SL3OSC, LBMODE, 21, 1)
    FIELD(DX8SL3OSC, LBGSDQS, 20, 1)
    FIELD(DX8SL3OSC, LBGDQS, 18, 2)
    FIELD(DX8SL3OSC, LBDQSS, 17, 1)
    FIELD(DX8SL3OSC, PHYHRST, 16, 1)
    FIELD(DX8SL3OSC, PHYFRST, 15, 1)
    FIELD(DX8SL3OSC, DLTST, 14, 1)
    FIELD(DX8SL3OSC, DLTMODE, 13, 1)
    FIELD(DX8SL3OSC, RESERVED_12_11, 11, 2)
    FIELD(DX8SL3OSC, OSCWDDL, 9, 2)
    FIELD(DX8SL3OSC, RESERVED_8_7, 7, 2)
    FIELD(DX8SL3OSC, OSCWDL, 5, 2)
    FIELD(DX8SL3OSC, OSCDIV, 1, 4)
    FIELD(DX8SL3OSC, OSCEN, 0, 1)
REG32(DX8SL3PLLCR0, 0x14c4)
    FIELD(DX8SL3PLLCR0, PLLBYP, 31, 1)
    FIELD(DX8SL3PLLCR0, PLLRST, 30, 1)
    FIELD(DX8SL3PLLCR0, PLLPD, 29, 1)
    FIELD(DX8SL3PLLCR0, RSTOPM, 28, 1)
    FIELD(DX8SL3PLLCR0, FRQSEL, 24, 4)
    FIELD(DX8SL3PLLCR0, RLOCKM, 23, 1)
    FIELD(DX8SL3PLLCR0, CPPC, 17, 6)
    FIELD(DX8SL3PLLCR0, CPIC, 13, 4)
    FIELD(DX8SL3PLLCR0, GSHIFT, 12, 1)
    FIELD(DX8SL3PLLCR0, RESERVED_11_9, 9, 3)
    FIELD(DX8SL3PLLCR0, ATOEN, 8, 1)
    FIELD(DX8SL3PLLCR0, ATC, 4, 4)
    FIELD(DX8SL3PLLCR0, DTC, 0, 4)
REG32(DX8SL3PLLCR1, 0x14c8)
    FIELD(DX8SL3PLLCR1, RESERVED_31_22, 22, 10)
    FIELD(DX8SL3PLLCR1, PLLPROG, 6, 16)
    FIELD(DX8SL3PLLCR1, BYPVREGCP, 5, 1)
    FIELD(DX8SL3PLLCR1, BYPVREGDIG, 4, 1)
    FIELD(DX8SL3PLLCR1, BYPVDD, 3, 1)
    FIELD(DX8SL3PLLCR1, LOCKPS, 2, 1)
    FIELD(DX8SL3PLLCR1, LOCKCS, 1, 1)
    FIELD(DX8SL3PLLCR1, LOCKDS, 0, 1)
REG32(DX8SL3PLLCR2, 0x14cc)
REG32(DX8SL3PLLCR3, 0x14d0)
REG32(DX8SL3PLLCR4, 0x14d4)
REG32(DX8SL3PLLCR5, 0x14d8)
    FIELD(DX8SL3PLLCR5, RESERVED_31_8, 8, 24)
    FIELD(DX8SL3PLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DX8SL3DQSCTL, 0x14dc)
    FIELD(DX8SL3DQSCTL, RESERVED_31_25, 25, 7)
    FIELD(DX8SL3DQSCTL, RRRMODE, 24, 1)
    FIELD(DX8SL3DQSCTL, RESERVED_23_22, 22, 2)
    FIELD(DX8SL3DQSCTL, WRRMODE, 21, 1)
    FIELD(DX8SL3DQSCTL, DQSGX, 19, 2)
    FIELD(DX8SL3DQSCTL, LPPLLPD, 18, 1)
    FIELD(DX8SL3DQSCTL, LPIOPD, 17, 1)
    FIELD(DX8SL3DQSCTL, RESERVED_16_15, 15, 2)
    FIELD(DX8SL3DQSCTL, QSCNTEN, 14, 1)
    FIELD(DX8SL3DQSCTL, UDQIOM, 13, 1)
    FIELD(DX8SL3DQSCTL, RESERVED_12_10, 10, 3)
    FIELD(DX8SL3DQSCTL, DXSR, 8, 2)
    FIELD(DX8SL3DQSCTL, DQSNRES, 4, 4)
    FIELD(DX8SL3DQSCTL, DQSRES, 0, 4)
REG32(DX8SL3TRNCTL, 0x14e0)
REG32(DX8SL3DDLCTL, 0x14e4)
    FIELD(DX8SL3DDLCTL, RESERVED_31_27, 27, 5)
    FIELD(DX8SL3DDLCTL, DLYLDTM, 26, 1)
    FIELD(DX8SL3DDLCTL, DXDDLLDT, 25, 1)
    FIELD(DX8SL3DDLCTL, RESERVED_24_23, 23, 2)
    FIELD(DX8SL3DDLCTL, DXDDLLD, 18, 5)
    FIELD(DX8SL3DDLCTL, DXDDLBYP, 2, 16)
    FIELD(DX8SL3DDLCTL, DDLBYPMODE, 0, 2)
REG32(DX8SL3DXCTL1, 0x14e8)
    FIELD(DX8SL3DXCTL1, RESERVED_31_25, 25, 7)
    FIELD(DX8SL3DXCTL1, DXCALCLK, 24, 1)
    FIELD(DX8SL3DXCTL1, DXRCLKMD, 23, 1)
    FIELD(DX8SL3DXCTL1, RESERVED_22, 22, 1)
    FIELD(DX8SL3DXCTL1, DXDTOSEL, 20, 2)
    FIELD(DX8SL3DXCTL1, DXGSMD, 19, 1)
    FIELD(DX8SL3DXCTL1, DXQSDBYP, 18, 1)
    FIELD(DX8SL3DXCTL1, DXGDBYP, 17, 1)
    FIELD(DX8SL3DXCTL1, DXTMODE, 16, 1)
    FIELD(DX8SL3DXCTL1, RESERVED_15_0, 0, 16)
REG32(DX8SL3DXCTL2, 0x14ec)
    FIELD(DX8SL3DXCTL2, RESERVED_31_24, 24, 8)
    FIELD(DX8SL3DXCTL2, CRDEN, 23, 1)
    FIELD(DX8SL3DXCTL2, POSOEX, 20, 3)
    FIELD(DX8SL3DXCTL2, PREOEX, 18, 2)
    FIELD(DX8SL3DXCTL2, RESERVED_17, 17, 1)
    FIELD(DX8SL3DXCTL2, IOAG, 16, 1)
    FIELD(DX8SL3DXCTL2, IOLB, 15, 1)
    FIELD(DX8SL3DXCTL2, RESERVED_14_13, 13, 2)
    FIELD(DX8SL3DXCTL2, LPWAKEUP_THRSH, 9, 4)
    FIELD(DX8SL3DXCTL2, RDBI, 8, 1)
    FIELD(DX8SL3DXCTL2, WDBI, 7, 1)
    FIELD(DX8SL3DXCTL2, PRFBYP, 6, 1)
    FIELD(DX8SL3DXCTL2, RDMODE, 4, 2)
    FIELD(DX8SL3DXCTL2, DISRST, 3, 1)
    FIELD(DX8SL3DXCTL2, DQSGLB, 1, 2)
    FIELD(DX8SL3DXCTL2, RESERVED_0, 0, 1)
REG32(DX8SL3IOCR, 0x14f0)
    FIELD(DX8SL3IOCR, RESERVED_31, 31, 1)
    FIELD(DX8SL3IOCR, DXDACRANGE, 28, 3)
    FIELD(DX8SL3IOCR, DXVREFIOM, 25, 3)
    FIELD(DX8SL3IOCR, DXIOM, 22, 3)
    FIELD(DX8SL3IOCR, DXTXM, 11, 11)
    FIELD(DX8SL3IOCR, DXRXM, 0, 11)
REG32(DX8SL4OSC, 0x1500)
    FIELD(DX8SL4OSC, RESERVED_31_30, 30, 2)
    FIELD(DX8SL4OSC, GATEDXRDCLK, 28, 2)
    FIELD(DX8SL4OSC, GATEDXDDRCLK, 26, 2)
    FIELD(DX8SL4OSC, GATEDXCTLCLK, 24, 2)
    FIELD(DX8SL4OSC, CLKLEVEL, 22, 2)
    FIELD(DX8SL4OSC, LBMODE, 21, 1)
    FIELD(DX8SL4OSC, LBGSDQS, 20, 1)
    FIELD(DX8SL4OSC, LBGDQS, 18, 2)
    FIELD(DX8SL4OSC, LBDQSS, 17, 1)
    FIELD(DX8SL4OSC, PHYHRST, 16, 1)
    FIELD(DX8SL4OSC, PHYFRST, 15, 1)
    FIELD(DX8SL4OSC, DLTST, 14, 1)
    FIELD(DX8SL4OSC, DLTMODE, 13, 1)
    FIELD(DX8SL4OSC, RESERVED_12_11, 11, 2)
    FIELD(DX8SL4OSC, OSCWDDL, 9, 2)
    FIELD(DX8SL4OSC, RESERVED_8_7, 7, 2)
    FIELD(DX8SL4OSC, OSCWDL, 5, 2)
    FIELD(DX8SL4OSC, OSCDIV, 1, 4)
    FIELD(DX8SL4OSC, OSCEN, 0, 1)
REG32(DX8SL4PLLCR0, 0x1504)
    FIELD(DX8SL4PLLCR0, PLLBYP, 31, 1)
    FIELD(DX8SL4PLLCR0, PLLRST, 30, 1)
    FIELD(DX8SL4PLLCR0, PLLPD, 29, 1)
    FIELD(DX8SL4PLLCR0, RSTOPM, 28, 1)
    FIELD(DX8SL4PLLCR0, FRQSEL, 24, 4)
    FIELD(DX8SL4PLLCR0, RLOCKM, 23, 1)
    FIELD(DX8SL4PLLCR0, CPPC, 17, 6)
    FIELD(DX8SL4PLLCR0, CPIC, 13, 4)
    FIELD(DX8SL4PLLCR0, GSHIFT, 12, 1)
    FIELD(DX8SL4PLLCR0, RESERVED_11_9, 9, 3)
    FIELD(DX8SL4PLLCR0, ATOEN, 8, 1)
    FIELD(DX8SL4PLLCR0, ATC, 4, 4)
    FIELD(DX8SL4PLLCR0, DTC, 0, 4)
REG32(DX8SL4PLLCR1, 0x1508)
    FIELD(DX8SL4PLLCR1, RESERVED_31_22, 22, 10)
    FIELD(DX8SL4PLLCR1, PLLPROG, 6, 16)
    FIELD(DX8SL4PLLCR1, BYPVREGCP, 5, 1)
    FIELD(DX8SL4PLLCR1, BYPVREGDIG, 4, 1)
    FIELD(DX8SL4PLLCR1, BYPVDD, 3, 1)
    FIELD(DX8SL4PLLCR1, LOCKPS, 2, 1)
    FIELD(DX8SL4PLLCR1, LOCKCS, 1, 1)
    FIELD(DX8SL4PLLCR1, LOCKDS, 0, 1)
REG32(DX8SL4PLLCR2, 0x150c)
REG32(DX8SL4PLLCR3, 0x1510)
REG32(DX8SL4PLLCR4, 0x1514)
REG32(DX8SL4PLLCR5, 0x1518)
    FIELD(DX8SL4PLLCR5, RESERVED_31_8, 8, 24)
    FIELD(DX8SL4PLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DX8SL4DQSCTL, 0x151c)
    FIELD(DX8SL4DQSCTL, RESERVED_31_25, 25, 7)
    FIELD(DX8SL4DQSCTL, RRRMODE, 24, 1)
    FIELD(DX8SL4DQSCTL, RESERVED_23_22, 22, 2)
    FIELD(DX8SL4DQSCTL, WRRMODE, 21, 1)
    FIELD(DX8SL4DQSCTL, DQSGX, 19, 2)
    FIELD(DX8SL4DQSCTL, LPPLLPD, 18, 1)
    FIELD(DX8SL4DQSCTL, LPIOPD, 17, 1)
    FIELD(DX8SL4DQSCTL, RESERVED_16_15, 15, 2)
    FIELD(DX8SL4DQSCTL, QSCNTEN, 14, 1)
    FIELD(DX8SL4DQSCTL, UDQIOM, 13, 1)
    FIELD(DX8SL4DQSCTL, RESERVED_12_10, 10, 3)
    FIELD(DX8SL4DQSCTL, DXSR, 8, 2)
    FIELD(DX8SL4DQSCTL, DQSNRES, 4, 4)
    FIELD(DX8SL4DQSCTL, DQSRES, 0, 4)
REG32(DX8SL4TRNCTL, 0x1520)
REG32(DX8SL4DDLCTL, 0x1524)
    FIELD(DX8SL4DDLCTL, RESERVED_31_27, 27, 5)
    FIELD(DX8SL4DDLCTL, DLYLDTM, 26, 1)
    FIELD(DX8SL4DDLCTL, DXDDLLDT, 25, 1)
    FIELD(DX8SL4DDLCTL, RESERVED_24_23, 23, 2)
    FIELD(DX8SL4DDLCTL, DXDDLLD, 18, 5)
    FIELD(DX8SL4DDLCTL, DXDDLBYP, 2, 16)
    FIELD(DX8SL4DDLCTL, DDLBYPMODE, 0, 2)
REG32(DX8SL4DXCTL1, 0x1528)
    FIELD(DX8SL4DXCTL1, RESERVED_31_25, 25, 7)
    FIELD(DX8SL4DXCTL1, DXCALCLK, 24, 1)
    FIELD(DX8SL4DXCTL1, DXRCLKMD, 23, 1)
    FIELD(DX8SL4DXCTL1, RESERVED_22, 22, 1)
    FIELD(DX8SL4DXCTL1, DXDTOSEL, 20, 2)
    FIELD(DX8SL4DXCTL1, DXGSMD, 19, 1)
    FIELD(DX8SL4DXCTL1, DXQSDBYP, 18, 1)
    FIELD(DX8SL4DXCTL1, DXGDBYP, 17, 1)
    FIELD(DX8SL4DXCTL1, DXTMODE, 16, 1)
    FIELD(DX8SL4DXCTL1, RESERVED_15_0, 0, 16)
REG32(DX8SL4DXCTL2, 0x152c)
    FIELD(DX8SL4DXCTL2, RESERVED_31_24, 24, 8)
    FIELD(DX8SL4DXCTL2, CRDEN, 23, 1)
    FIELD(DX8SL4DXCTL2, POSOEX, 20, 3)
    FIELD(DX8SL4DXCTL2, PREOEX, 18, 2)
    FIELD(DX8SL4DXCTL2, RESERVED_17, 17, 1)
    FIELD(DX8SL4DXCTL2, IOAG, 16, 1)
    FIELD(DX8SL4DXCTL2, IOLB, 15, 1)
    FIELD(DX8SL4DXCTL2, RESERVED_14_13, 13, 2)
    FIELD(DX8SL4DXCTL2, LPWAKEUP_THRSH, 9, 4)
    FIELD(DX8SL4DXCTL2, RDBI, 8, 1)
    FIELD(DX8SL4DXCTL2, WDBI, 7, 1)
    FIELD(DX8SL4DXCTL2, PRFBYP, 6, 1)
    FIELD(DX8SL4DXCTL2, RDMODE, 4, 2)
    FIELD(DX8SL4DXCTL2, DISRST, 3, 1)
    FIELD(DX8SL4DXCTL2, DQSGLB, 1, 2)
    FIELD(DX8SL4DXCTL2, RESERVED_0, 0, 1)
REG32(DX8SL4IOCR, 0x1530)
    FIELD(DX8SL4IOCR, RESERVED_31, 31, 1)
    FIELD(DX8SL4IOCR, DXDACRANGE, 28, 3)
    FIELD(DX8SL4IOCR, DXVREFIOM, 25, 3)
    FIELD(DX8SL4IOCR, DXIOM, 22, 3)
    FIELD(DX8SL4IOCR, DXTXM, 11, 11)
    FIELD(DX8SL4IOCR, DXRXM, 0, 11)
REG32(DX8SLBOSC, 0x17c0)
    FIELD(DX8SLBOSC, RESERVED_31_30, 30, 2)
    FIELD(DX8SLBOSC, GATEDXRDCLK, 28, 2)
    FIELD(DX8SLBOSC, GATEDXDDRCLK, 26, 2)
    FIELD(DX8SLBOSC, GATEDXCTLCLK, 24, 2)
    FIELD(DX8SLBOSC, CLKLEVEL, 22, 2)
    FIELD(DX8SLBOSC, LBMODE, 21, 1)
    FIELD(DX8SLBOSC, LBGSDQS, 20, 1)
    FIELD(DX8SLBOSC, LBGDQS, 18, 2)
    FIELD(DX8SLBOSC, LBDQSS, 17, 1)
    FIELD(DX8SLBOSC, PHYHRST, 16, 1)
    FIELD(DX8SLBOSC, PHYFRST, 15, 1)
    FIELD(DX8SLBOSC, DLTST, 14, 1)
    FIELD(DX8SLBOSC, DLTMODE, 13, 1)
    FIELD(DX8SLBOSC, RESERVED_12_11, 11, 2)
    FIELD(DX8SLBOSC, OSCWDDL, 9, 2)
    FIELD(DX8SLBOSC, RESERVED_8_7, 7, 2)
    FIELD(DX8SLBOSC, OSCWDL, 5, 2)
    FIELD(DX8SLBOSC, OSCDIV, 1, 4)
    FIELD(DX8SLBOSC, OSCEN, 0, 1)
REG32(DX8SLBPLLCR0, 0x17c4)
    FIELD(DX8SLBPLLCR0, PLLBYP, 31, 1)
    FIELD(DX8SLBPLLCR0, PLLRST, 30, 1)
    FIELD(DX8SLBPLLCR0, PLLPD, 29, 1)
    FIELD(DX8SLBPLLCR0, RSTOPM, 28, 1)
    FIELD(DX8SLBPLLCR0, FRQSEL, 24, 4)
    FIELD(DX8SLBPLLCR0, RLOCKM, 23, 1)
    FIELD(DX8SLBPLLCR0, CPPC, 17, 6)
    FIELD(DX8SLBPLLCR0, CPIC, 13, 4)
    FIELD(DX8SLBPLLCR0, GSHIFT, 12, 1)
    FIELD(DX8SLBPLLCR0, RESERVED_11_9, 9, 3)
    FIELD(DX8SLBPLLCR0, ATOEN, 8, 1)
    FIELD(DX8SLBPLLCR0, ATC, 4, 4)
    FIELD(DX8SLBPLLCR0, DTC, 0, 4)
REG32(DX8SLBPLLCR1, 0x17c8)
    FIELD(DX8SLBPLLCR1, RESERVED_31_22, 22, 10)
    FIELD(DX8SLBPLLCR1, PLLPROG, 6, 16)
    FIELD(DX8SLBPLLCR1, BYPVREGCP, 5, 1)
    FIELD(DX8SLBPLLCR1, BYPVREGDIG, 4, 1)
    FIELD(DX8SLBPLLCR1, BYPVDD, 3, 1)
    FIELD(DX8SLBPLLCR1, LOCKPS, 2, 1)
    FIELD(DX8SLBPLLCR1, LOCKCS, 1, 1)
    FIELD(DX8SLBPLLCR1, LOCKDS, 0, 1)
REG32(DX8SLBPLLCR2, 0x17cc)
REG32(DX8SLBPLLCR3, 0x17d0)
REG32(DX8SLBPLLCR4, 0x17d4)
REG32(DX8SLBPLLCR5, 0x17d8)
    FIELD(DX8SLBPLLCR5, RESERVED_31_8, 8, 24)
    FIELD(DX8SLBPLLCR5, PLLCTRL_103_96, 0, 8)
REG32(DX8SLBDQSCTL, 0x17dc)
    FIELD(DX8SLBDQSCTL, RESERVED_31_25, 25, 7)
    FIELD(DX8SLBDQSCTL, RRRMODE, 24, 1)
    FIELD(DX8SLBDQSCTL, RESERVED_23_22, 22, 2)
    FIELD(DX8SLBDQSCTL, WRRMODE, 21, 1)
    FIELD(DX8SLBDQSCTL, DQSGX, 19, 2)
    FIELD(DX8SLBDQSCTL, LPPLLPD, 18, 1)
    FIELD(DX8SLBDQSCTL, LPIOPD, 17, 1)
    FIELD(DX8SLBDQSCTL, RESERVED_16_15, 15, 2)
    FIELD(DX8SLBDQSCTL, QSCNTEN, 14, 1)
    FIELD(DX8SLBDQSCTL, UDQIOM, 13, 1)
    FIELD(DX8SLBDQSCTL, RESERVED_12_10, 10, 3)
    FIELD(DX8SLBDQSCTL, DXSR, 8, 2)
    FIELD(DX8SLBDQSCTL, DQSNRES, 4, 4)
    FIELD(DX8SLBDQSCTL, DQSRES, 0, 4)
REG32(DX8SLBTRNCTL, 0x17e0)
REG32(DX8SLBDDLCTL, 0x17e4)
    FIELD(DX8SLBDDLCTL, RESERVED_31_27, 27, 5)
    FIELD(DX8SLBDDLCTL, DLYLDTM, 26, 1)
    FIELD(DX8SLBDDLCTL, DXDDLLDT, 25, 1)
    FIELD(DX8SLBDDLCTL, RESERVED_24_23, 23, 2)
    FIELD(DX8SLBDDLCTL, DXDDLLD, 18, 5)
    FIELD(DX8SLBDDLCTL, DXDDLBYP, 2, 16)
    FIELD(DX8SLBDDLCTL, DDLBYPMODE, 0, 2)
REG32(DX8SLBDXCTL1, 0x17e8)
    FIELD(DX8SLBDXCTL1, RESERVED_31_25, 25, 7)
    FIELD(DX8SLBDXCTL1, DXCALCLK, 24, 1)
    FIELD(DX8SLBDXCTL1, DXRCLKMD, 23, 1)
    FIELD(DX8SLBDXCTL1, RESERVED_22, 22, 1)
    FIELD(DX8SLBDXCTL1, DXDTOSEL, 20, 2)
    FIELD(DX8SLBDXCTL1, DXGSMD, 19, 1)
    FIELD(DX8SLBDXCTL1, DXQSDBYP, 18, 1)
    FIELD(DX8SLBDXCTL1, DXGDBYP, 17, 1)
    FIELD(DX8SLBDXCTL1, DXTMODE, 16, 1)
    FIELD(DX8SLBDXCTL1, RESERVED_15_0, 0, 16)
REG32(DX8SLBDXCTL2, 0x17ec)
    FIELD(DX8SLBDXCTL2, RESERVED_31_24, 24, 8)
    FIELD(DX8SLBDXCTL2, CRDEN, 23, 1)
    FIELD(DX8SLBDXCTL2, POSOEX, 20, 3)
    FIELD(DX8SLBDXCTL2, PREOEX, 18, 2)
    FIELD(DX8SLBDXCTL2, RESERVED_17, 17, 1)
    FIELD(DX8SLBDXCTL2, IOAG, 16, 1)
    FIELD(DX8SLBDXCTL2, IOLB, 15, 1)
    FIELD(DX8SLBDXCTL2, RESERVED_14_13, 13, 2)
    FIELD(DX8SLBDXCTL2, LPWAKEUP_THRSH, 9, 4)
    FIELD(DX8SLBDXCTL2, RDBI, 8, 1)
    FIELD(DX8SLBDXCTL2, WDBI, 7, 1)
    FIELD(DX8SLBDXCTL2, PRFBYP, 6, 1)
    FIELD(DX8SLBDXCTL2, RDMODE, 4, 2)
    FIELD(DX8SLBDXCTL2, DISRST, 3, 1)
    FIELD(DX8SLBDXCTL2, DQSGLB, 1, 2)
    FIELD(DX8SLBDXCTL2, RESERVED_0, 0, 1)
REG32(DX8SLBIOCR, 0x17f0)
    FIELD(DX8SLBIOCR, RESERVED_31, 31, 1)
    FIELD(DX8SLBIOCR, DXDACRANGE, 28, 3)
    FIELD(DX8SLBIOCR, DXVREFIOM, 25, 3)
    FIELD(DX8SLBIOCR, DXIOM, 22, 3)
    FIELD(DX8SLBIOCR, DXTXM, 11, 11)
    FIELD(DX8SLBIOCR, DXRXM, 0, 11)

#define DDR_PHY_R_MAX (R_DX8SLBIOCR + 1)

typedef struct DDR_PHY {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[DDR_PHY_R_MAX];
    RegisterInfo regs_info[DDR_PHY_R_MAX];
} DDR_PHY;

#define DDR_PIR_REACT(val, src, dest) \
    do { \
        if (val & R_PIR_ ## src ## _MASK) { \
            ARRAY_FIELD_DP32(s->regs, PGSR0, dest , 0x1);\
        } \
    } while (0)

static uint64_t ddr_phy_pir_pre_write(RegisterInfo *reg, uint64_t val)
{
    DDR_PHY *s = reg->opaque;

    /* Set the corresponding bit in the PGSR0 register */
    DDR_PIR_REACT(val, DRAMINIT, DIDONE);
    DDR_PIR_REACT(val, ZCAL, ZCDONE);
    DDR_PIR_REACT(val, DCAL, DCDONE);
    DDR_PIR_REACT(val, PLLINIT, PLDONE);
    DDR_PIR_REACT(val, WLADJ, WLADONE);
    DDR_PIR_REACT(val, RDDSKW, RDDONE);
    DDR_PIR_REACT(val, WRDSKW, WDDONE);
    DDR_PIR_REACT(val, RDEYE, REDONE);
    DDR_PIR_REACT(val, WREYE, WEDONE);
    DDR_PIR_REACT(val, WL, WLDONE);
    DDR_PIR_REACT(val, QSGATE, QSGDONE);
    DDR_PIR_REACT(val, VREF, VDONE);

    return val;
}

static uint64_t ddr_phy_pgsr0_post_read(RegisterInfo *reg, uint64_t val)
{
    DDR_PHY *s = reg->opaque;

    /* Flip the bits stored in the register as some guests require the status
     * to change and we don't fully model the device.
     */
    s->regs[R_PGSR0] ^= R_PGSR0_DIDONE_MASK;

    return val;
}

static const RegisterAccessInfo ddr_phy_regs_info[] = {
    {   .name = "PIR",  .addr = A_PIR,
        .ro = 0x9fe00008,
        .w1c = 0x60000001,
        .pre_write = ddr_phy_pir_pre_write,
    },{ .name = "PGCR0",  .addr = A_PGCR0,
        .reset = 0x7001e00,
        .ro = 0x78f820ff,
    },{ .name = "PGCR2",  .addr = A_PGCR2,
        .reset = 0xf12480,
        .w1c = 0xe0000000,
    },{ .name = "PGCR3",  .addr = A_PGCR3,
        .reset = 0x50a0080,
        .ro = 0x8100,
    },{ .name = "PGCR4",  .addr = A_PGCR4,
        .reset = 0x1800c3,
        .ro = 0xc007ff0c,
    },{ .name = "PGCR5",  .addr = A_PGCR5,
        .reset = 0x1010000,
        .ro = 0x8,
    },{ .name = "PGCR6",  .addr = A_PGCR6,
        .reset = 0x13000,
        .ro = 0xff00c0fe,
    },{ .name = "PGCR7",  .addr = A_PGCR7,
        .ro = 0xffffff00,
    },{ .name = "PGSR0",  .addr = A_PGSR0,
        .ro = 0xffffffff,
        /* Report all ready.  */
        .reset = 0x8000000f,
        .post_read = ddr_phy_pgsr0_post_read,
    },{ .name = "PGSR1",  .addr = A_PGSR1,
        .ro = 0xffffffff,
    },{ .name = "PGSR2",  .addr = A_PGSR2,
        .ro = 0xffffffff,
    },{ .name = "PTR0",  .addr = A_PTR0,
        .reset = 0x42c21590,
    },{ .name = "PTR1",  .addr = A_PTR1,
        .reset = 0xd05612c0,
        .ro = 0xe000,
    },{ .name = "PTR2",  .addr = A_PTR2,
        .reset = 0x83def,
        .ro = 0xfff00000,
    },{ .name = "PTR3",  .addr = A_PTR3,
        .reset = 0x411810,
        .ro = 0xff800000,
    },{ .name = "PTR4",  .addr = A_PTR4,
        .reset = 0x10aa,
        .ro = 0xffffe000,
    },{ .name = "PTR5",  .addr = A_PTR5,
        .reset = 0x68268,
        .ro = 0xfff80000,
    },{ .name = "PTR6",  .addr = A_PTR6,
        .reset = 0x4000855,
        .ro = 0xf80ff000,
    },{ .name = "PLLCR0",  .addr = A_PLLCR0,
        .reset = 0x1c0000,
        .ro = 0xe00,
    },{ .name = "PLLCR1",  .addr = A_PLLCR1,
        .ro = 0xffc0,
    },{ .name = "PLLCR2",  .addr = A_PLLCR2,
    },{ .name = "PLLCR3",  .addr = A_PLLCR3,
    },{ .name = "PLLCR4",  .addr = A_PLLCR4,
    },{ .name = "PLLCR5",  .addr = A_PLLCR5,
        .ro = 0xffffff00,
    },{ .name = "DXCCR",  .addr = A_DXCCR,
        .reset = 0x20000038,
        .ro = 0xdfffff87,
    },{ .name = "DSGCR",  .addr = A_DSGCR,
        .reset = 0x2a04101,
        .ro = 0xf044201a,
    },{ .name = "ODTCR",  .addr = A_ODTCR,
        .reset = 0x10000,
        .ro = 0xfffcfffc,
    },{ .name = "AACR",  .addr = A_AACR,
        .reset = 0xff,
    },{ .name = "GPR0",  .addr = A_GPR0,
    },{ .name = "GPR1",  .addr = A_GPR1,
    },{ .name = "DCR",  .addr = A_DCR,
        .reset = 0x40d,
        .ro = 0x7fc0000,
    },{ .name = "DTPR0",  .addr = A_DTPR0,
        .reset = 0x105a2d08,
        .ro = 0xe08080e0,
    },{ .name = "DTPR1",  .addr = A_DTPR1,
        .reset = 0x5656041e,
        .ro = 0x8080f8e0,
    },{ .name = "DTPR2",  .addr = A_DTPR2,
        .reset = 0xb01d0,
        .ro = 0xeef0fc00,
    },{ .name = "DTPR3",  .addr = A_DTPR3,
        .reset = 0x2000804,
        .ro = 0xf0f8,
    },{ .name = "DTPR4",  .addr = A_DTPR4,
        .reset = 0x1c02b10,
        .ro = 0xcc00c0e0,
    },{ .name = "DTPR5",  .addr = A_DTPR5,
        .reset = 0x872716,
        .ro = 0xff0080e0,
    },{ .name = "DTPR6",  .addr = A_DTPR6,
        .reset = 0x505,
        .ro = 0x3fffc0c0,
    },{ .name = "RDIMMGCR0",  .addr = A_RDIMMGCR0,
        .reset = 0x8400020,
        .ro = 0xb711ffc8,
    },{ .name = "RDIMMGCR1",  .addr = A_RDIMMGCR1,
        .reset = 0xc80,
        .ro = 0xe888c000,
    },{ .name = "RDIMMGCR2",  .addr = A_RDIMMGCR2,
        .reset = 0x3ffffbf,
    },{ .name = "RDIMMCR0",  .addr = A_RDIMMCR0,
    },{ .name = "RDIMMCR1",  .addr = A_RDIMMCR1,
    },{ .name = "RDIMMCR2",  .addr = A_RDIMMCR2,
    },{ .name = "RDIMMCR3",  .addr = A_RDIMMCR3,
    },{ .name = "RDIMMCR4",  .addr = A_RDIMMCR4,
    },{ .name = "SCHCR0",  .addr = A_SCHCR0,
        .ro = 0xfe00f000,
        .w1c = 0xf,
    },{ .name = "SCHCR1",  .addr = A_SCHCR1,
        .ro = 0xb,
    },{ .name = "MR0",  .addr = A_MR0,
        .reset = 0x52,
        .ro = 0xffffff00,
    },{ .name = "MR1",  .addr = A_MR1,
        .reset = 0x4,
        .ro = 0xffffff00,
    },{ .name = "MR2",  .addr = A_MR2,
        .ro = 0xffffff00,
    },{ .name = "MR3",  .addr = A_MR3,
        .reset = 0x31,
        .ro = 0xffffff00,
    },{ .name = "MR4",  .addr = A_MR4,
        .ro = 0xffffff00,
    },{ .name = "MR5",  .addr = A_MR5,
        .ro = 0xffffff00,
    },{ .name = "MR6",  .addr = A_MR6,
        .ro = 0xffffff00,
    },{ .name = "MR7",  .addr = A_MR7,
        .ro = 0xffffff00,
    },{ .name = "MR11",  .addr = A_MR11,
        .ro = 0xffffff00,
    },{ .name = "MR12",  .addr = A_MR12,
        .reset = 0x4d,
        .ro = 0xffffff00,
    },{ .name = "MR13",  .addr = A_MR13,
        .ro = 0xffffff00,
    },{ .name = "MR14",  .addr = A_MR14,
        .reset = 0x4d,
        .ro = 0xffffff00,
    },{ .name = "MR22",  .addr = A_MR22,
        .ro = 0xffffff00,
    },{ .name = "DTCR0",  .addr = A_DTCR0,
        .reset = 0x800091c7,
        .ro = 0xc002020,
        .w1c = 0x200000,
    },{ .name = "DTCR1",  .addr = A_DTCR1,
        .reset = 0x30237,
        .ro = 0xfffcc888,
    },{ .name = "DTAR0",  .addr = A_DTAR0,
        .reset = 0x4000000,
        .ro = 0xc00c0000,
    },{ .name = "DTAR1",  .addr = A_DTAR1,
        .reset = 0x10000,
        .ro = 0xfe00fe00,
    },{ .name = "DTAR2",  .addr = A_DTAR2,
        .reset = 0x30002,
        .ro = 0xfe00fe00,
    },{ .name = "DTDR0",  .addr = A_DTDR0,
        .reset = 0xdd22ee11,
    },{ .name = "DTDR1",  .addr = A_DTDR1,
        .reset = 0x7788bb44,
    },{ .name = "DTEDR0",  .addr = A_DTEDR0,
        .ro = 0xffffffff,
    },{ .name = "DTEDR1",  .addr = A_DTEDR1,
        .ro = 0xffffffff,
    },{ .name = "DTEDR2",  .addr = A_DTEDR2,
        .ro = 0xffffffff,
    },{ .name = "VTDR",  .addr = A_VTDR,
        .reset = 0x7f003f00,
        .ro = 0xffffffff,
    },{ .name = "CATR0",  .addr = A_CATR0,
        .reset = 0x141054,
        .ro = 0xffe0e000,
    },{ .name = "CATR1",  .addr = A_CATR1,
        .reset = 0x103aaaa,
        .ro = 0xf0000000,
    },{ .name = "DQSDR0",  .addr = A_DQSDR0,
        .reset = 0x88000,
        .ro = 0x3c00f00,
    },{ .name = "DQSDR1",  .addr = A_DQSDR1,
        .reset = 0xa8000000,
    },{ .name = "DQSDR2",  .addr = A_DQSDR2,
        .ro = 0xff000000,
    },{ .name = "DTEDR3",  .addr = A_DTEDR3,
        .ro = 0xffffffff,
    },{ .name = "DCUAR",  .addr = A_DCUAR,
        .ro = 0xfff00000,
    },{ .name = "DCUDR",  .addr = A_DCUDR,
    },{ .name = "DCURR",  .addr = A_DCURR,
        .ro = 0xff000000,
    },{ .name = "DCULR",  .addr = A_DCULR,
        .reset = 0xf0000000,
        .ro = 0xffc0000,
    },{ .name = "DCUGCR",  .addr = A_DCUGCR,
        .ro = 0xffff0000,
    },{ .name = "DCUTPR",  .addr = A_DCUTPR,
    },{ .name = "DCUSR0",  .addr = A_DCUSR0,
        .ro = 0xffffffff,
    },{ .name = "DCUSR1",  .addr = A_DCUSR1,
        .ro = 0xffffffff,
    },{ .name = "RANKIDR",  .addr = A_RANKIDR,
        .ro = 0xfff0fff0,
    },{ .name = "RIOCR0",  .addr = A_RIOCR0,
        .ro = 0xffffffff,
    },{ .name = "RIOCR1",  .addr = A_RIOCR1,
        .ro = 0xffffffff,
    },{ .name = "RIOCR2",  .addr = A_RIOCR2,
        .ro = 0xfcfffff0,
    },{ .name = "RIOCR3",  .addr = A_RIOCR3,
        .ro = 0xffffffff,
    },{ .name = "RIOCR4",  .addr = A_RIOCR4,
        .reset = 0x5,
        .ro = 0xfffffff0,
    },{ .name = "RIOCR5",  .addr = A_RIOCR5,
        .reset = 0x5,
        .ro = 0xfffffff0,
    },{ .name = "ACIOCR0",  .addr = A_ACIOCR0,
        .reset = 0x30000000,
        .ro = 0xbfffc02,
    },{ .name = "ACIOCR1",  .addr = A_ACIOCR1,
    },{ .name = "ACIOCR2",  .addr = A_ACIOCR2,
    },{ .name = "ACIOCR3",  .addr = A_ACIOCR3,
        .reset = 0x5,
        .ro = 0xfff0,
    },{ .name = "ACIOCR4",  .addr = A_ACIOCR4,
    },{ .name = "ACIOCR5",  .addr = A_ACIOCR5,
        .ro = 0xf0000000,
    },{ .name = "IOVCR0",  .addr = A_IOVCR0,
        .reset = 0xf000000,
        .ro = 0xe0000000,
    },{ .name = "IOVCR1",  .addr = A_IOVCR1,
        .ro = 0xffffffff,
    },{ .name = "VTCR0",  .addr = A_VTCR0,
        .reset = 0x70032019,
        .ro = 0x4000000,
    },{ .name = "VTCR1",  .addr = A_VTCR1,
        .reset = 0x7f00072,
        .ro = 0x8080800,
    },{ .name = "ACBDLR0",  .addr = A_ACBDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR1",  .addr = A_ACBDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR2",  .addr = A_ACBDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR3",  .addr = A_ACBDLR3,
        .ro = 0xffffc0c0,
    },{ .name = "ACBDLR4",  .addr = A_ACBDLR4,
        .ro = 0xffffc0c0,
    },{ .name = "ACBDLR5",  .addr = A_ACBDLR5,
        .ro = 0xffffc0c0,
    },{ .name = "ACBDLR6",  .addr = A_ACBDLR6,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR7",  .addr = A_ACBDLR7,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR8",  .addr = A_ACBDLR8,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR9",  .addr = A_ACBDLR9,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACBDLR15",  .addr = A_ACBDLR15,
        .ro = 0xffc0c0c0,
    },{ .name = "ACBDLR16",  .addr = A_ACBDLR16,
        .ro = 0xc0c0c0c0,
    },{ .name = "ACLCDLR",  .addr = A_ACLCDLR,
        .ro = 0xfe00fe00,
    },{ .name = "ACMDLR0",  .addr = A_ACMDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "ACMDLR1",  .addr = A_ACMDLR1,
        .ro = 0xfe00fe00,
    },{ .name = "ZQCR",  .addr = A_ZQCR,
        .reset = 0x8a2858,
        .ro = 0xfc000000,
    },{ .name = "ZQ0PR0",  .addr = A_ZQ0PR0,
        .reset = 0x77bb,
    },{ .name = "ZQ0PR1",  .addr = A_ZQ0PR1,
        .reset = 0xb0b,
        .ro = 0xffff8080,
    },{ .name = "ZQ0DR0",  .addr = A_ZQ0DR0,
        .ro = 0xffffffff,
    },{ .name = "ZQ0DR1",  .addr = A_ZQ0DR1,
        .ro = 0xffffffff,
    },{ .name = "ZQ0OR0",  .addr = A_ZQ0OR0,
        .ro = 0xfc00fc00,
    },{ .name = "ZQ0OR1",  .addr = A_ZQ0OR1,
        .ro = 0xfc00fc00,
    },{ .name = "ZQ0SR",  .addr = A_ZQ0SR,
        .ro = 0xffffffff,
    },{ .name = "ZQ1PR0",  .addr = A_ZQ1PR0,
        .reset = 0x77bb,
    },{ .name = "ZQ1PR1",  .addr = A_ZQ1PR1,
        .reset = 0xb0b,
        .ro = 0xffff8080,
    },{ .name = "ZQ1DR0",  .addr = A_ZQ1DR0,
        .ro = 0xffffffff,
    },{ .name = "ZQ1DR1",  .addr = A_ZQ1DR1,
        .ro = 0xffffffff,
    },{ .name = "ZQ1OR0",  .addr = A_ZQ1OR0,
        .ro = 0xfc00fc00,
    },{ .name = "ZQ1OR1",  .addr = A_ZQ1OR1,
        .ro = 0xfc00fc00,
    },{ .name = "ZQ1SR",  .addr = A_ZQ1SR,
        .ro = 0xffffffff,
    },{ .name = "DX0GCR0",  .addr = A_DX0GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX0GCR1",  .addr = A_DX0GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX0GCR2",  .addr = A_DX0GCR2,
    },{ .name = "DX0GCR3",  .addr = A_DX0GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX0GCR4",  .addr = A_DX0GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX0GCR5",  .addr = A_DX0GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX0GCR6",  .addr = A_DX0GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX0BDLR0",  .addr = A_DX0BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX0BDLR1",  .addr = A_DX0BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX0BDLR2",  .addr = A_DX0BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX0BDLR3",  .addr = A_DX0BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX0BDLR4",  .addr = A_DX0BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX0BDLR5",  .addr = A_DX0BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX0BDLR6",  .addr = A_DX0BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX0LCDLR0",  .addr = A_DX0LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX0LCDLR1",  .addr = A_DX0LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX0LCDLR2",  .addr = A_DX0LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX0LCDLR3",  .addr = A_DX0LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX0LCDLR4",  .addr = A_DX0LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX0LCDLR5",  .addr = A_DX0LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX0MDLR0",  .addr = A_DX0MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX0MDLR1",  .addr = A_DX0MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX0GTR0",  .addr = A_DX0GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX0RSR1",  .addr = A_DX0RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX0RSR2",  .addr = A_DX0RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX0RSR3",  .addr = A_DX0RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX0GSR0",  .addr = A_DX0GSR0,
        .reset = R_DX0GSR0_DPLOCK_MASK
               | R_DX0GSR0_WLDONE_MASK
               | R_DX0GSR0_WLCAL_MASK
               | R_DX0GSR0_GDQSCAL_MASK
               | R_DX0GSR0_RDQSNCAL_MASK
               | R_DX0GSR0_RDQSCAL_MASK
               | R_DX0GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX0GSR1",  .addr = A_DX0GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX0GSR2",  .addr = A_DX0GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX0GSR3",  .addr = A_DX0GSR3,
        .ro = 0xff3333ff,
    },{ .name = "DX1GCR0",  .addr = A_DX1GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX1GCR1",  .addr = A_DX1GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX1GCR2",  .addr = A_DX1GCR2,
    },{ .name = "DX1GCR3",  .addr = A_DX1GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX1GCR4",  .addr = A_DX1GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX1GCR5",  .addr = A_DX1GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX1GCR6",  .addr = A_DX1GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX1BDLR0",  .addr = A_DX1BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX1BDLR1",  .addr = A_DX1BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX1BDLR2",  .addr = A_DX1BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX1BDLR3",  .addr = A_DX1BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX1BDLR4",  .addr = A_DX1BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX1BDLR5",  .addr = A_DX1BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX1BDLR6",  .addr = A_DX1BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX1LCDLR0",  .addr = A_DX1LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX1LCDLR1",  .addr = A_DX1LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX1LCDLR2",  .addr = A_DX1LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX1LCDLR3",  .addr = A_DX1LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX1LCDLR4",  .addr = A_DX1LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX1LCDLR5",  .addr = A_DX1LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX1MDLR0",  .addr = A_DX1MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX1MDLR1",  .addr = A_DX1MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX1GTR0",  .addr = A_DX1GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX1RSR1",  .addr = A_DX1RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX1RSR2",  .addr = A_DX1RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX1RSR3",  .addr = A_DX1RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX1GSR0",  .addr = A_DX1GSR0,
        .reset = R_DX1GSR0_DPLOCK_MASK
               | R_DX1GSR0_WLDONE_MASK
               | R_DX1GSR0_WLCAL_MASK
               | R_DX1GSR0_GDQSCAL_MASK
               | R_DX1GSR0_RDQSNCAL_MASK
               | R_DX1GSR0_RDQSCAL_MASK
               | R_DX1GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX1GSR1",  .addr = A_DX1GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX1GSR2",  .addr = A_DX1GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX1GSR3",  .addr = A_DX1GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX2GCR0",  .addr = A_DX2GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX2GCR1",  .addr = A_DX2GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX2GCR2",  .addr = A_DX2GCR2,
    },{ .name = "DX2GCR3",  .addr = A_DX2GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX2GCR4",  .addr = A_DX2GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX2GCR5",  .addr = A_DX2GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX2GCR6",  .addr = A_DX2GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX2BDLR0",  .addr = A_DX2BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX2BDLR1",  .addr = A_DX2BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX2BDLR2",  .addr = A_DX2BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX2BDLR3",  .addr = A_DX2BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX2BDLR4",  .addr = A_DX2BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX2BDLR5",  .addr = A_DX2BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX2BDLR6",  .addr = A_DX2BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX2LCDLR0",  .addr = A_DX2LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX2LCDLR1",  .addr = A_DX2LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX2LCDLR2",  .addr = A_DX2LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX2LCDLR3",  .addr = A_DX2LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX2LCDLR4",  .addr = A_DX2LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX2LCDLR5",  .addr = A_DX2LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX2MDLR0",  .addr = A_DX2MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX2MDLR1",  .addr = A_DX2MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX2GTR0",  .addr = A_DX2GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX2RSR1",  .addr = A_DX2RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX2RSR2",  .addr = A_DX2RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX2RSR3",  .addr = A_DX2RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX2GSR0",  .addr = A_DX2GSR0,
        .reset = R_DX2GSR0_DPLOCK_MASK
               | R_DX2GSR0_WLDONE_MASK
               | R_DX2GSR0_WLCAL_MASK
               | R_DX2GSR0_GDQSCAL_MASK
               | R_DX2GSR0_RDQSNCAL_MASK
               | R_DX2GSR0_RDQSCAL_MASK
               | R_DX2GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX2GSR1",  .addr = A_DX2GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX2GSR2",  .addr = A_DX2GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX2GSR3",  .addr = A_DX2GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX3GCR0",  .addr = A_DX3GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX3GCR1",  .addr = A_DX3GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX3GCR2",  .addr = A_DX3GCR2,
    },{ .name = "DX3GCR3",  .addr = A_DX3GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX3GCR4",  .addr = A_DX3GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX3GCR5",  .addr = A_DX3GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX3GCR6",  .addr = A_DX3GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX3BDLR0",  .addr = A_DX3BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX3BDLR1",  .addr = A_DX3BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX3BDLR2",  .addr = A_DX3BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX3BDLR3",  .addr = A_DX3BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX3BDLR4",  .addr = A_DX3BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX3BDLR5",  .addr = A_DX3BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX3BDLR6",  .addr = A_DX3BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX3LCDLR0",  .addr = A_DX3LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX3LCDLR1",  .addr = A_DX3LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX3LCDLR2",  .addr = A_DX3LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX3LCDLR3",  .addr = A_DX3LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX3LCDLR4",  .addr = A_DX3LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX3LCDLR5",  .addr = A_DX3LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX3MDLR0",  .addr = A_DX3MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX3MDLR1",  .addr = A_DX3MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX3GTR0",  .addr = A_DX3GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX3RSR1",  .addr = A_DX3RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX3RSR2",  .addr = A_DX3RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX3RSR3",  .addr = A_DX3RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX3GSR0",  .addr = A_DX3GSR0,
        .reset = R_DX3GSR0_DPLOCK_MASK
               | R_DX3GSR0_WLDONE_MASK
               | R_DX3GSR0_WLCAL_MASK
               | R_DX3GSR0_GDQSCAL_MASK
               | R_DX3GSR0_RDQSNCAL_MASK
               | R_DX3GSR0_RDQSCAL_MASK
               | R_DX3GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX3GSR1",  .addr = A_DX3GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX3GSR2",  .addr = A_DX3GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX3GSR3",  .addr = A_DX3GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX4GCR0",  .addr = A_DX4GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX4GCR1",  .addr = A_DX4GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX4GCR2",  .addr = A_DX4GCR2,
    },{ .name = "DX4GCR3",  .addr = A_DX4GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX4GCR4",  .addr = A_DX4GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX4GCR5",  .addr = A_DX4GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX4GCR6",  .addr = A_DX4GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX4BDLR0",  .addr = A_DX4BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX4BDLR1",  .addr = A_DX4BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX4BDLR2",  .addr = A_DX4BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX4BDLR3",  .addr = A_DX4BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX4BDLR4",  .addr = A_DX4BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX4BDLR5",  .addr = A_DX4BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX4BDLR6",  .addr = A_DX4BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX4LCDLR0",  .addr = A_DX4LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX4LCDLR1",  .addr = A_DX4LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX4LCDLR2",  .addr = A_DX4LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX4LCDLR3",  .addr = A_DX4LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX4LCDLR4",  .addr = A_DX4LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX4LCDLR5",  .addr = A_DX4LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX4MDLR0",  .addr = A_DX4MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX4MDLR1",  .addr = A_DX4MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX4GTR0",  .addr = A_DX4GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX4RSR1",  .addr = A_DX4RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX4RSR2",  .addr = A_DX4RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX4RSR3",  .addr = A_DX4RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX4GSR0",  .addr = A_DX4GSR0,
        .reset = R_DX4GSR0_DPLOCK_MASK
               | R_DX4GSR0_WLDONE_MASK
               | R_DX4GSR0_WLCAL_MASK
               | R_DX4GSR0_GDQSCAL_MASK
               | R_DX4GSR0_RDQSNCAL_MASK
               | R_DX4GSR0_RDQSCAL_MASK
               | R_DX4GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX4GSR1",  .addr = A_DX4GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX4GSR2",  .addr = A_DX4GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX4GSR3",  .addr = A_DX4GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX5GCR0",  .addr = A_DX5GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX5GCR1",  .addr = A_DX5GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX5GCR2",  .addr = A_DX5GCR2,
    },{ .name = "DX5GCR3",  .addr = A_DX5GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX5GCR4",  .addr = A_DX5GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX5GCR5",  .addr = A_DX5GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX5GCR6",  .addr = A_DX5GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX5BDLR0",  .addr = A_DX5BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX5BDLR1",  .addr = A_DX5BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX5BDLR2",  .addr = A_DX5BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX5BDLR3",  .addr = A_DX5BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX5BDLR4",  .addr = A_DX5BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX5BDLR5",  .addr = A_DX5BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX5BDLR6",  .addr = A_DX5BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX5LCDLR0",  .addr = A_DX5LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX5LCDLR1",  .addr = A_DX5LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX5LCDLR2",  .addr = A_DX5LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX5LCDLR3",  .addr = A_DX5LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX5LCDLR4",  .addr = A_DX5LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX5LCDLR5",  .addr = A_DX5LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX5MDLR0",  .addr = A_DX5MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX5MDLR1",  .addr = A_DX5MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX5GTR0",  .addr = A_DX5GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX5RSR1",  .addr = A_DX5RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX5RSR2",  .addr = A_DX5RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX5RSR3",  .addr = A_DX5RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX5GSR0",  .addr = A_DX5GSR0,
        .reset = R_DX5GSR0_DPLOCK_MASK
               | R_DX5GSR0_WLDONE_MASK
               | R_DX5GSR0_WLCAL_MASK
               | R_DX5GSR0_GDQSCAL_MASK
               | R_DX5GSR0_RDQSNCAL_MASK
               | R_DX5GSR0_RDQSCAL_MASK
               | R_DX5GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX5GSR1",  .addr = A_DX5GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX5GSR2",  .addr = A_DX5GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX5GSR3",  .addr = A_DX5GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX6GCR0",  .addr = A_DX6GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX6GCR1",  .addr = A_DX6GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX6GCR2",  .addr = A_DX6GCR2,
    },{ .name = "DX6GCR3",  .addr = A_DX6GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX6GCR4",  .addr = A_DX6GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX6GCR5",  .addr = A_DX6GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX6GCR6",  .addr = A_DX6GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX6BDLR0",  .addr = A_DX6BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX6BDLR1",  .addr = A_DX6BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX6BDLR2",  .addr = A_DX6BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX6BDLR3",  .addr = A_DX6BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX6BDLR4",  .addr = A_DX6BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX6BDLR5",  .addr = A_DX6BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX6BDLR6",  .addr = A_DX6BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX6LCDLR0",  .addr = A_DX6LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX6LCDLR1",  .addr = A_DX6LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX6LCDLR2",  .addr = A_DX6LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX6LCDLR3",  .addr = A_DX6LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX6LCDLR4",  .addr = A_DX6LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX6LCDLR5",  .addr = A_DX6LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX6MDLR0",  .addr = A_DX6MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX6MDLR1",  .addr = A_DX6MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX6GTR0",  .addr = A_DX6GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX6RSR1",  .addr = A_DX6RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX6RSR2",  .addr = A_DX6RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX6RSR3",  .addr = A_DX6RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX6GSR0",  .addr = A_DX6GSR0,
        .reset = R_DX6GSR0_DPLOCK_MASK
               | R_DX6GSR0_WLDONE_MASK
               | R_DX6GSR0_WLCAL_MASK
               | R_DX6GSR0_GDQSCAL_MASK
               | R_DX6GSR0_RDQSNCAL_MASK
               | R_DX6GSR0_RDQSCAL_MASK
               | R_DX6GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX6GSR1",  .addr = A_DX6GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX6GSR2",  .addr = A_DX6GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX6GSR3",  .addr = A_DX6GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX7GCR0",  .addr = A_DX7GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX7GCR1",  .addr = A_DX7GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX7GCR2",  .addr = A_DX7GCR2,
    },{ .name = "DX7GCR3",  .addr = A_DX7GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX7GCR4",  .addr = A_DX7GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX7GCR5",  .addr = A_DX7GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX7GCR6",  .addr = A_DX7GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX7BDLR0",  .addr = A_DX7BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX7BDLR1",  .addr = A_DX7BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX7BDLR2",  .addr = A_DX7BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX7BDLR3",  .addr = A_DX7BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX7BDLR4",  .addr = A_DX7BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX7BDLR5",  .addr = A_DX7BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX7BDLR6",  .addr = A_DX7BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX7LCDLR0",  .addr = A_DX7LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX7LCDLR1",  .addr = A_DX7LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX7LCDLR2",  .addr = A_DX7LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX7LCDLR3",  .addr = A_DX7LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX7LCDLR4",  .addr = A_DX7LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX7LCDLR5",  .addr = A_DX7LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX7MDLR0",  .addr = A_DX7MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX7MDLR1",  .addr = A_DX7MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX7GTR0",  .addr = A_DX7GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX7RSR1",  .addr = A_DX7RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX7RSR2",  .addr = A_DX7RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX7RSR3",  .addr = A_DX7RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX7GSR0",  .addr = A_DX7GSR0,
        .reset = R_DX7GSR0_DPLOCK_MASK
               | R_DX7GSR0_WLDONE_MASK
               | R_DX7GSR0_WLCAL_MASK
               | R_DX7GSR0_GDQSCAL_MASK
               | R_DX7GSR0_RDQSNCAL_MASK
               | R_DX7GSR0_RDQSCAL_MASK
               | R_DX7GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX7GSR1",  .addr = A_DX7GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX7GSR2",  .addr = A_DX7GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX7GSR3",  .addr = A_DX7GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX8GCR0",  .addr = A_DX8GCR0,
        .reset = 0x40200204,
        .ro = 0xfc013,
    },{ .name = "DX8GCR1",  .addr = A_DX8GCR1,
        .reset = 0x7fff,
        .ro = 0x8000,
    },{ .name = "DX8GCR2",  .addr = A_DX8GCR2,
    },{ .name = "DX8GCR3",  .addr = A_DX8GCR3,
        .reset = 0x3f000008,
        .ro = 0xc0c00303,
    },{ .name = "DX8GCR4",  .addr = A_DX8GCR4,
        .reset = 0xe00003c,
        .ro = 0xe10000c0,
    },{ .name = "DX8GCR5",  .addr = A_DX8GCR5,
        .reset = 0x9090909,
        .ro = 0x80808080,
    },{ .name = "DX8GCR6",  .addr = A_DX8GCR6,
        .reset = 0x9090909,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX8BDLR0",  .addr = A_DX8BDLR0,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX8BDLR1",  .addr = A_DX8BDLR1,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX8BDLR2",  .addr = A_DX8BDLR2,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX8BDLR3",  .addr = A_DX8BDLR3,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX8BDLR4",  .addr = A_DX8BDLR4,
        .ro = 0xc0c0c0c0,
    },{ .name = "DX8BDLR5",  .addr = A_DX8BDLR5,
        .ro = 0xffffffc0,
    },{ .name = "DX8BDLR6",  .addr = A_DX8BDLR6,
        .ro = 0xffc0c0ff,
    },{ .name = "DX8LCDLR0",  .addr = A_DX8LCDLR0,
        .ro = 0xfffffe00,
    },{ .name = "DX8LCDLR1",  .addr = A_DX8LCDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX8LCDLR2",  .addr = A_DX8LCDLR2,
        .ro = 0xfffffe00,
    },{ .name = "DX8LCDLR3",  .addr = A_DX8LCDLR3,
        .ro = 0xfffffe00,
    },{ .name = "DX8LCDLR4",  .addr = A_DX8LCDLR4,
        .ro = 0xfffffe00,
    },{ .name = "DX8LCDLR5",  .addr = A_DX8LCDLR5,
        .ro = 0xfffffe00,
    },{ .name = "DX8MDLR0",  .addr = A_DX8MDLR0,
        .ro = 0xfe00fe00,
    },{ .name = "DX8MDLR1",  .addr = A_DX8MDLR1,
        .ro = 0xfffffe00,
    },{ .name = "DX8GTR0",  .addr = A_DX8GTR0,
        .reset = 0x20000,
        .ro = 0xf8f0ffe0,
    },{ .name = "DX8RSR1",  .addr = A_DX8RSR1,
        .ro = 0xffffffff,
    },{ .name = "DX8RSR2",  .addr = A_DX8RSR2,
        .ro = 0xffffffff,
    },{ .name = "DX8RSR3",  .addr = A_DX8RSR3,
        .ro = 0xffffffff,
    },{ .name = "DX8GSR0",  .addr = A_DX8GSR0,
        .reset = R_DX8GSR0_DPLOCK_MASK
               | R_DX8GSR0_WLDONE_MASK
               | R_DX8GSR0_WLCAL_MASK
               | R_DX8GSR0_GDQSCAL_MASK
               | R_DX8GSR0_RDQSNCAL_MASK
               | R_DX8GSR0_RDQSCAL_MASK
               | R_DX8GSR0_WDQCAL_MASK,
        .ro = 0xffffffff,
    },{ .name = "DX8GSR1",  .addr = A_DX8GSR1,
        .ro = 0xffffffff,
    },{ .name = "DX8GSR2",  .addr = A_DX8GSR2,
        .ro = 0xfff0ffff,
    },{ .name = "DX8GSR3",  .addr = A_DX8GSR3,
        .ro = 0xffffffff,
    },{ .name = "DX8SL0OSC",  .addr = A_DX8SL0OSC,
        .reset = 0x19ffe,
        .ro = 0xc0000000,
        .w1c = 0x100000,
    },{ .name = "DX8SL0PLLCR0",  .addr = A_DX8SL0PLLCR0,
        .reset = 0x1c0000,
        .ro = 0xe00,
    },{ .name = "DX8SL0PLLCR1",  .addr = A_DX8SL0PLLCR1,
        .ro = 0xffc00000,
    },{ .name = "DX8SL0PLLCR2",  .addr = A_DX8SL0PLLCR2,
    },{ .name = "DX8SL0PLLCR3",  .addr = A_DX8SL0PLLCR3,
    },{ .name = "DX8SL0PLLCR4",  .addr = A_DX8SL0PLLCR4,
    },{ .name = "DX8SL0PLLCR5",  .addr = A_DX8SL0PLLCR5,
        .ro = 0xffffff00,
    },{ .name = "DX8SL0DQSCTL",  .addr = A_DX8SL0DQSCTL,
        .reset = 0x1264000,
        .ro = 0xfec19c00,
    },{ .name = "DX8SL0TRNCTL",  .addr = A_DX8SL0TRNCTL,
        .ro = 0xffffffff,
    },{ .name = "DX8SL0DDLCTL",  .addr = A_DX8SL0DDLCTL,
        .reset = 0x2,
        .ro = 0xf9800000,
    },{ .name = "DX8SL0DXCTL1",  .addr = A_DX8SL0DXCTL1,
        .reset = 0x40000,
        .ro = 0xfe40ffff,
    },{ .name = "DX8SL0DXCTL2",  .addr = A_DX8SL0DXCTL2,
        .reset = 0x141800,
        .ro = 0xff026001,
    },{ .name = "DX8SL0IOCR",  .addr = A_DX8SL0IOCR,
        .ro = 0x80000000,
    },{ .name = "DX8SL1OSC",  .addr = A_DX8SL1OSC,
        .reset = 0x19ffe,
        .ro = 0xc0000000,
        .w1c = 0x100000,
    },{ .name = "DX8SL1PLLCR0",  .addr = A_DX8SL1PLLCR0,
        .reset = 0x1c0000,
        .ro = 0xe00,
    },{ .name = "DX8SL1PLLCR1",  .addr = A_DX8SL1PLLCR1,
        .ro = 0xffc00000,
    },{ .name = "DX8SL1PLLCR2",  .addr = A_DX8SL1PLLCR2,
    },{ .name = "DX8SL1PLLCR3",  .addr = A_DX8SL1PLLCR3,
    },{ .name = "DX8SL1PLLCR4",  .addr = A_DX8SL1PLLCR4,
    },{ .name = "DX8SL1PLLCR5",  .addr = A_DX8SL1PLLCR5,
        .ro = 0xffffff00,
    },{ .name = "DX8SL1DQSCTL",  .addr = A_DX8SL1DQSCTL,
        .reset = 0x1264000,
        .ro = 0xfec19c00,
    },{ .name = "DX8SL1TRNCTL",  .addr = A_DX8SL1TRNCTL,
        .ro = 0xffffffff,
    },{ .name = "DX8SL1DDLCTL",  .addr = A_DX8SL1DDLCTL,
        .reset = 0x2,
        .ro = 0xf9800000,
    },{ .name = "DX8SL1DXCTL1",  .addr = A_DX8SL1DXCTL1,
        .reset = 0x40000,
        .ro = 0xfe40ffff,
    },{ .name = "DX8SL1DXCTL2",  .addr = A_DX8SL1DXCTL2,
        .reset = 0x141800,
        .ro = 0xff026001,
    },{ .name = "DX8SL1IOCR",  .addr = A_DX8SL1IOCR,
        .ro = 0x80000000,
    },{ .name = "DX8SL2OSC",  .addr = A_DX8SL2OSC,
        .reset = 0x19ffe,
        .ro = 0xc0000000,
        .w1c = 0x100000,
    },{ .name = "DX8SL2PLLCR0",  .addr = A_DX8SL2PLLCR0,
        .reset = 0x1c0000,
        .ro = 0xe00,
    },{ .name = "DX8SL2PLLCR1",  .addr = A_DX8SL2PLLCR1,
        .ro = 0xffc00000,
    },{ .name = "DX8SL2PLLCR2",  .addr = A_DX8SL2PLLCR2,
    },{ .name = "DX8SL2PLLCR3",  .addr = A_DX8SL2PLLCR3,
    },{ .name = "DX8SL2PLLCR4",  .addr = A_DX8SL2PLLCR4,
    },{ .name = "DX8SL2PLLCR5",  .addr = A_DX8SL2PLLCR5,
        .ro = 0xffffff00,
    },{ .name = "DX8SL2DQSCTL",  .addr = A_DX8SL2DQSCTL,
        .reset = 0x1264000,
        .ro = 0xfec19c00,
    },{ .name = "DX8SL2TRNCTL",  .addr = A_DX8SL2TRNCTL,
        .ro = 0xffffffff,
    },{ .name = "DX8SL2DDLCTL",  .addr = A_DX8SL2DDLCTL,
        .reset = 0x2,
        .ro = 0xf9800000,
    },{ .name = "DX8SL2DXCTL1",  .addr = A_DX8SL2DXCTL1,
        .reset = 0x40000,
        .ro = 0xfe40ffff,
    },{ .name = "DX8SL2DXCTL2",  .addr = A_DX8SL2DXCTL2,
        .reset = 0x141800,
        .ro = 0xff026001,
    },{ .name = "DX8SL2IOCR",  .addr = A_DX8SL2IOCR,
        .ro = 0x80000000,
    },{ .name = "DX8SL3OSC",  .addr = A_DX8SL3OSC,
        .reset = 0x19ffe,
        .ro = 0xc0000000,
        .w1c = 0x100000,
    },{ .name = "DX8SL3PLLCR0",  .addr = A_DX8SL3PLLCR0,
        .reset = 0x1c0000,
        .ro = 0xe00,
    },{ .name = "DX8SL3PLLCR1",  .addr = A_DX8SL3PLLCR1,
        .ro = 0xffc00000,
    },{ .name = "DX8SL3PLLCR2",  .addr = A_DX8SL3PLLCR2,
    },{ .name = "DX8SL3PLLCR3",  .addr = A_DX8SL3PLLCR3,
    },{ .name = "DX8SL3PLLCR4",  .addr = A_DX8SL3PLLCR4,
    },{ .name = "DX8SL3PLLCR5",  .addr = A_DX8SL3PLLCR5,
        .ro = 0xffffff00,
    },{ .name = "DX8SL3DQSCTL",  .addr = A_DX8SL3DQSCTL,
        .reset = 0x1264000,
        .ro = 0xfec19c00,
    },{ .name = "DX8SL3TRNCTL",  .addr = A_DX8SL3TRNCTL,
        .ro = 0xffffffff,
    },{ .name = "DX8SL3DDLCTL",  .addr = A_DX8SL3DDLCTL,
        .reset = 0x2,
        .ro = 0xf9800000,
    },{ .name = "DX8SL3DXCTL1",  .addr = A_DX8SL3DXCTL1,
        .reset = 0x40000,
        .ro = 0xfe40ffff,
    },{ .name = "DX8SL3DXCTL2",  .addr = A_DX8SL3DXCTL2,
        .reset = 0x141800,
        .ro = 0xff026001,
    },{ .name = "DX8SL3IOCR",  .addr = A_DX8SL3IOCR,
        .ro = 0x80000000,
    },{ .name = "DX8SL4OSC",  .addr = A_DX8SL4OSC,
        .reset = 0x19ffe,
        .ro = 0xc0000000,
        .w1c = 0x100000,
    },{ .name = "DX8SL4PLLCR0",  .addr = A_DX8SL4PLLCR0,
        .reset = 0x1c0000,
        .ro = 0xe00,
    },{ .name = "DX8SL4PLLCR1",  .addr = A_DX8SL4PLLCR1,
        .ro = 0xffc00000,
    },{ .name = "DX8SL4PLLCR2",  .addr = A_DX8SL4PLLCR2,
    },{ .name = "DX8SL4PLLCR3",  .addr = A_DX8SL4PLLCR3,
    },{ .name = "DX8SL4PLLCR4",  .addr = A_DX8SL4PLLCR4,
    },{ .name = "DX8SL4PLLCR5",  .addr = A_DX8SL4PLLCR5,
        .ro = 0xffffff00,
    },{ .name = "DX8SL4DQSCTL",  .addr = A_DX8SL4DQSCTL,
        .reset = 0x1264000,
        .ro = 0xfec19c00,
    },{ .name = "DX8SL4TRNCTL",  .addr = A_DX8SL4TRNCTL,
        .ro = 0xffffffff,
    },{ .name = "DX8SL4DDLCTL",  .addr = A_DX8SL4DDLCTL,
        .reset = 0x2,
        .ro = 0xf9800000,
    },{ .name = "DX8SL4DXCTL1",  .addr = A_DX8SL4DXCTL1,
        .reset = 0x40000,
        .ro = 0xfe40ffff,
    },{ .name = "DX8SL4DXCTL2",  .addr = A_DX8SL4DXCTL2,
        .reset = 0x141800,
        .ro = 0xff026001,
    },{ .name = "DX8SL4IOCR",  .addr = A_DX8SL4IOCR,
        .ro = 0x80000000,
    },{ .name = "DX8SLBOSC",  .addr = A_DX8SLBOSC,
    },{ .name = "DX8SLBPLLCR0",  .addr = A_DX8SLBPLLCR0,
    },{ .name = "DX8SLBPLLCR1",  .addr = A_DX8SLBPLLCR1,
    },{ .name = "DX8SLBPLLCR2",  .addr = A_DX8SLBPLLCR2,
    },{ .name = "DX8SLBPLLCR3",  .addr = A_DX8SLBPLLCR3,
    },{ .name = "DX8SLBPLLCR4",  .addr = A_DX8SLBPLLCR4,
    },{ .name = "DX8SLBPLLCR5",  .addr = A_DX8SLBPLLCR5,
    },{ .name = "DX8SLBDQSCTL",  .addr = A_DX8SLBDQSCTL,
    },{ .name = "DX8SLBTRNCTL",  .addr = A_DX8SLBTRNCTL,
    },{ .name = "DX8SLBDDLCTL",  .addr = A_DX8SLBDDLCTL,
    },{ .name = "DX8SLBDXCTL1",  .addr = A_DX8SLBDXCTL1,
    },{ .name = "DX8SLBDXCTL2",  .addr = A_DX8SLBDXCTL2,
    },{ .name = "DX8SLBIOCR",  .addr = A_DX8SLBIOCR,
    }
};

static void ddr_phy_reset(DeviceState *dev)
{
    DDR_PHY *s = XILINX_DDR_PHY(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static const MemoryRegionOps ddr_phy_ops = {
    .read = register_read_memory,
    .write_with_attrs = register_write_memory_with_attrs,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void ddr_phy_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void ddr_phy_init(Object *obj)
{
    DDR_PHY *s = XILINX_DDR_PHY(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_DDR_PHY, DDR_PHY_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), ddr_phy_regs_info,
                              ARRAY_SIZE(ddr_phy_regs_info),
                              s->regs_info, s->regs,
                              &ddr_phy_ops,
                              XILINX_DDR_PHY_ERR_DEBUG,
                              DDR_PHY_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);

    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_ddr_phy = {
    .name = TYPE_XILINX_DDR_PHY,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, DDR_PHY, DDR_PHY_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void ddr_phy_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = ddr_phy_reset;
    dc->realize = ddr_phy_realize;
    dc->vmsd = &vmstate_ddr_phy;
}

static const TypeInfo ddr_phy_info = {
    .name          = TYPE_XILINX_DDR_PHY,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(DDR_PHY),
    .class_init    = ddr_phy_class_init,
    .instance_init = ddr_phy_init,
};

static void ddr_phy_register_types(void)
{
    type_register_static(&ddr_phy_info);
}

type_init(ddr_phy_register_types)
