/*
 * QEMU model of the CMN top level component for the CMN-600AE
 *
 * Copyright (c) 2021 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2021-03-06.
 * Written by Edgar E. Iglesias
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef ARM_CMN_ERR_DEBUG
#define ARM_CMN_ERR_DEBUG 0
#endif

#define TYPE_ARM_CMN "arm,cmn600ae"

#define ARM_CMN(obj) \
     OBJECT_CHECK(CMN600AE, (obj), TYPE_ARM_CMN)

REG32(POR_SBSX_NODE_INFO_U_SBSX_NID0, 0x0)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID0, RESERVED_48, 48, 16)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID0, LOGICAL_ID, 32, 16)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID0, NODE_ID, 16, 16)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID0, NODE_TYPE, 0, 16)
REG32(POR_SBSX_CHILD_INFO_U_SBSX_NID0, 0x80)
    FIELD(POR_SBSX_CHILD_INFO_U_SBSX_NID0, RESERVED_32, 32, 32)
    FIELD(POR_SBSX_CHILD_INFO_U_SBSX_NID0, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_SBSX_CHILD_INFO_U_SBSX_NID0, CHILD_COUNT, 0, 16)
REG32(POR_SBSX_UNIT_INFO_U_SBSX_NID0, 0x900)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID0, RESERVED_22, 22, 42)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID0, ACEL_SAFE_XFACE_DISABLE, 21, 1)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID0, NUM_WR_DATA_BUF, 16, 5)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID0, NUM_OUTSTANDING_READS, 8, 8)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID0, AXDATA_POISON_EN, 4, 1)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID0, AXDATA_WIDTH, 0, 1)
REG32(POR_SBSX_AUX_CTL_U_SBSX_NID0, 0xa08)
    FIELD(POR_SBSX_AUX_CTL_U_SBSX_NID0, CLKGATE_DISABLE, 0, 1)
REG32(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, 0x2000)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, RESERVED_30, 30, 34)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, PMU_EVENT3_ID, 24, 6)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, RESERVED_22, 22, 2)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, PMU_EVENT2_ID, 16, 6)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, RESERVED_14, 14, 2)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, PMU_EVENT1_ID, 8, 6)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID0, PMU_EVENT0_ID, 0, 6)
REG32(POR_SBSX_ERRFR_U_SBSX_NID0, 0x3000)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, RESERVED_15, 15, 49)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, CEC, 12, 3)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, CFI, 10, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, FI, 6, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, UI, 4, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, DE, 2, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID0, ED, 0, 2)
REG32(POR_SBSX_ERRCTLR_U_SBSX_NID0, 0x3008)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID0, RESERVED_9, 9, 55)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID0, CFI, 8, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID0, FI, 3, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID0, UI, 2, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID0, DE, 1, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID0, ED, 0, 1)
REG32(POR_SBSX_ERRSTATUS_U_SBSX_NID0, 0x3010)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, RESERVED_32, 32, 32)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, AV, 31, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, V, 30, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, UE, 29, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, RESERVED_28, 28, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, OF, 27, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, MV, 26, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, RESERVED_25, 25, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, CE, 24, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, DE, 23, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID0, RESERVED_0, 0, 23)
REG32(POR_SBSX_ERRADDR_U_SBSX_NID0, 0x3018)
    FIELD(POR_SBSX_ERRADDR_U_SBSX_NID0, NS, 63, 1)
    FIELD(POR_SBSX_ERRADDR_U_SBSX_NID0, RESERVED_48, 48, 15)
    FIELD(POR_SBSX_ERRADDR_U_SBSX_NID0, ADDR, 0, 48)
REG32(POR_SBSX_ERRMISC_U_SBSX_NID0, 0x3020)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, RESERVED_31, 31, 33)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, SIZE, 28, 3)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, MEMATTR, 24, 4)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, RESERVED_17, 17, 7)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, OPTYPE, 16, 1)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, RESERVED_15, 15, 1)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, SRCID, 4, 11)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID0, RESERVED_0, 0, 4)
REG32(POR_SBSX_ERRFR_NS_U_SBSX_NID0, 0x3100)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, RESERVED_15, 15, 49)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, CEC, 12, 3)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, CFI, 10, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, FI, 6, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, UI, 4, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, DE, 2, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID0, ED, 0, 2)
REG32(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, 0x3108)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, RESERVED_9, 9, 55)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, CFI, 8, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, FI, 3, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, UI, 2, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, DE, 1, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID0, ED, 0, 1)
REG32(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, 0x3110)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, RESERVED_32, 32, 32)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, AV, 31, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, V, 30, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, UE, 29, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, RESERVED_28, 28, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, OF, 27, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, MV, 26, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, RESERVED_25, 25, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, CE, 24, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, DE, 23, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID0, RESERVED_0, 0, 23)
REG32(POR_SBSX_ERRADDR_NS_U_SBSX_NID0, 0x3118)
    FIELD(POR_SBSX_ERRADDR_NS_U_SBSX_NID0, NS, 63, 1)
    FIELD(POR_SBSX_ERRADDR_NS_U_SBSX_NID0, RESERVED_48, 48, 15)
    FIELD(POR_SBSX_ERRADDR_NS_U_SBSX_NID0, ADDR, 0, 48)
REG32(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, 0x3120)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, RESERVED_31, 31, 33)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, SIZE, 28, 3)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, MEMATTR, 24, 4)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, RESERVED_17, 17, 7)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, OPTYPE, 16, 1)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, RESERVED_15, 15, 1)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, SRCID, 4, 11)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID0, RESERVED_0, 0, 4)
REG32(POR_MXP_NODE_INFO_U_SMXP_0_0, 0x8000)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_0, LOGICAL_ID, 32, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_0, XY_ID, 16, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_0, NODE_TYPE, 0, 16)
REG32(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, 0x8008)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, NUM_DCS_P0_D3, 28, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, NUM_DCS_P0_D2, 24, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, NUM_DCS_P0_D1, 20, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, NUM_DCS_P0_D0, 16, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_0, DEVICE_TYPE_P0, 0, 5)
REG32(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, 0x8010)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, NUM_DCS_P1_D3, 28, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, NUM_DCS_P1_D2, 24, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, NUM_DCS_P1_D1, 20, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, NUM_DCS_P1_D0, 16, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_0, DEVICE_TYPE_P1, 0, 5)
REG32(POR_MXP_MESH_PORT_CONNECT_INFO_EAST_U_SMXP_0_0, 0x8018)
    FIELD(POR_MXP_MESH_PORT_CONNECT_INFO_EAST_U_SMXP_0_0, NUM_MCS_EAST, 0, 4)
REG32(POR_MXP_MESH_PORT_CONNECT_INFO_NORTH_U_SMXP_0_0, 0x8020)
    FIELD(POR_MXP_MESH_PORT_CONNECT_INFO_NORTH_U_SMXP_0_0, NUM_MCS_NORTH, 0, 4)
REG32(POR_MXP_CHILD_INFO_U_SMXP_0_0, 0x8080)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_0_0, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_0_0, CHILD_COUNT, 0, 16)
REG32(POR_MXP_CHILD_POINTER_0_U_SMXP_0_0, 0x8100)
    FIELD(POR_MXP_CHILD_POINTER_0_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_0_U_SMXP_0_0, RELATIVE_ADDRESS_0, 0, 32)
REG32(POR_MXP_CHILD_POINTER_1_U_SMXP_0_0, 0x8108)
    FIELD(POR_MXP_CHILD_POINTER_1_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_1_U_SMXP_0_0, RELATIVE_ADDRESS_1, 0, 32)
REG32(POR_MXP_CHILD_POINTER_2_U_SMXP_0_0, 0x8110)
    FIELD(POR_MXP_CHILD_POINTER_2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_2_U_SMXP_0_0, RELATIVE_ADDRESS_2, 0, 32)
REG32(POR_MXP_CHILD_POINTER_3_U_SMXP_0_0, 0x8118)
    FIELD(POR_MXP_CHILD_POINTER_3_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_3_U_SMXP_0_0, RELATIVE_ADDRESS_3, 0, 32)
REG32(POR_MXP_CHILD_POINTER_4_U_SMXP_0_0, 0x8120)
    FIELD(POR_MXP_CHILD_POINTER_4_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_4_U_SMXP_0_0, RELATIVE_ADDRESS_4, 0, 32)
REG32(POR_MXP_CHILD_POINTER_5_U_SMXP_0_0, 0x8128)
    FIELD(POR_MXP_CHILD_POINTER_5_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_5_U_SMXP_0_0, RELATIVE_ADDRESS_5, 0, 32)
REG32(POR_MXP_CHILD_POINTER_6_U_SMXP_0_0, 0x8130)
    FIELD(POR_MXP_CHILD_POINTER_6_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_6_U_SMXP_0_0, RELATIVE_ADDRESS_6, 0, 32)
REG32(POR_MXP_CHILD_POINTER_7_U_SMXP_0_0, 0x8138)
    FIELD(POR_MXP_CHILD_POINTER_7_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_7_U_SMXP_0_0, RELATIVE_ADDRESS_7, 0, 32)
REG32(POR_MXP_CHILD_POINTER_8_U_SMXP_0_0, 0x8140)
    FIELD(POR_MXP_CHILD_POINTER_8_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_8_U_SMXP_0_0, RELATIVE_ADDRESS_8, 0, 32)
REG32(POR_MXP_CHILD_POINTER_9_U_SMXP_0_0, 0x8148)
    FIELD(POR_MXP_CHILD_POINTER_9_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_9_U_SMXP_0_0, RELATIVE_ADDRESS_9, 0, 32)
REG32(POR_MXP_CHILD_POINTER_10_U_SMXP_0_0, 0x8150)
    FIELD(POR_MXP_CHILD_POINTER_10_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_10_U_SMXP_0_0, RELATIVE_ADDRESS_10, 0, 32)
REG32(POR_MXP_CHILD_POINTER_11_U_SMXP_0_0, 0x8158)
    FIELD(POR_MXP_CHILD_POINTER_11_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_11_U_SMXP_0_0, RELATIVE_ADDRESS_11, 0, 32)
REG32(POR_MXP_CHILD_POINTER_12_U_SMXP_0_0, 0x8160)
    FIELD(POR_MXP_CHILD_POINTER_12_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_12_U_SMXP_0_0, RELATIVE_ADDRESS_12, 0, 32)
REG32(POR_MXP_CHILD_POINTER_13_U_SMXP_0_0, 0x8168)
    FIELD(POR_MXP_CHILD_POINTER_13_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_13_U_SMXP_0_0, RELATIVE_ADDRESS_13, 0, 32)
REG32(POR_MXP_CHILD_POINTER_14_U_SMXP_0_0, 0x8170)
    FIELD(POR_MXP_CHILD_POINTER_14_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_14_U_SMXP_0_0, RELATIVE_ADDRESS_14, 0, 32)
REG32(POR_MXP_CHILD_POINTER_15_U_SMXP_0_0, 0x8178)
    FIELD(POR_MXP_CHILD_POINTER_15_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_15_U_SMXP_0_0, RELATIVE_ADDRESS_15, 0, 32)
REG32(POR_MXP_P0_INFO_U_SMXP_0_0, 0x8900)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, RESERVED_26, 26, 38)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, A4S_SAFE_XFACE_DISABLE_P0, 25, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, CHI_SAFE_XFACE_DISABLE_P0, 24, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, A4S_LOGICALID_BASE_P0, 16, 8)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, RESERVED_14, 14, 2)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, A4S_NUM_P0, 11, 3)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, RXBUF_NUM_ENTRIES_P0, 8, 3)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, EXT_SAM_EN_P0, 7, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, DATACHECK_EN_P0, 5, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, POISON_EN_P0, 4, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_0, NUM_DEV_P0, 0, 3)
REG32(POR_MXP_P1_INFO_U_SMXP_0_0, 0x8908)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, RESERVED_26, 26, 38)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, A4S_SAFE_XFACE_DISABLE_P1, 25, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, CHI_SAFE_XFACE_DISABLE_P1, 24, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, A4S_LOGICALID_BASE_P1, 16, 8)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, RESERVED_14, 14, 2)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, A4S_NUM_P1, 11, 3)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, RXBUF_NUM_ENTRIES_P1, 8, 3)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, EXT_SAM_EN_P1, 7, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, DATACHECK_EN_P1, 5, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, POISON_EN_P1, 4, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_0, NUM_DEV_P1, 0, 3)
REG32(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_0_0, 0x8980)
    FIELD(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_0_0, SYSCOREQ_CTL, 1, 1)
    FIELD(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_0_0, QOS, 0, 1)
REG32(POR_MXP_AUX_CTL_U_SMXP_0_0, 0x8a00)
    FIELD(POR_MXP_AUX_CTL_U_SMXP_0_0, CLKGATE_DISABLE, 0, 1)
REG32(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, 0x8a80)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, RESERVED_20, 20, 44)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, P0_QOS_OVERRIDE, 16, 4)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, P0_PQV_MODE, 6, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, P0_REG_MODE, 4, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, P0_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_0, P0_LAT_EN, 0, 1)
REG32(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_0_0, 0x8a88)
    FIELD(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_0_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_0_0, P0_LAT_TGT, 0, 12)
REG32(POR_MXP_P0_QOS_LAT_SCALE_U_SMXP_0_0, 0x8a90)
    FIELD(POR_MXP_P0_QOS_LAT_SCALE_U_SMXP_0_0, P0_LAT_SCALE, 0, 3)
REG32(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_0, 0x8a98)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_0, P0_LAT_MAX_QOS, 8, 4)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_0, P0_LAT_MIN_QOS, 0, 4)
REG32(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, 0x8aa0)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, RESERVED_20, 20, 44)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, P1_QOS_OVERRIDE, 16, 4)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, P1_PQV_MODE, 6, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, P1_REG_MODE, 4, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, P1_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_0, P1_LAT_EN, 0, 1)
REG32(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_0_0, 0x8aa8)
    FIELD(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_0_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_0_0, P1_LAT_TGT, 0, 12)
REG32(POR_MXP_P1_QOS_LAT_SCALE_U_SMXP_0_0, 0x8ab0)
    FIELD(POR_MXP_P1_QOS_LAT_SCALE_U_SMXP_0_0, P1_LAT_SCALE, 0, 3)
REG32(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_0, 0x8ab8)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_0, P1_LAT_MAX_QOS, 8, 4)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_0, P1_LAT_MIN_QOS, 0, 4)
REG32(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_0, 0x9000)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P0_D3, 3, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P0_D2, 2, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P0_D1, 1, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P0_D0, 0, 1)
REG32(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_0, 0x9008)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P1_D3, 3, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P1_D2, 2, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P1_D1, 1, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_0, SNPDVM_REQ_P1_D0, 0, 1)
REG32(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_0, 0x9010)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P0_D3, 3, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P0_D2, 2, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P0_D1, 1, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P0_D0, 0, 1)
REG32(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_0, 0x9018)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P1_D3, 3, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P1_D2, 2, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P1_D1, 1, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_0, SNPDVM_ACK_P1_D0, 0, 1)
REG32(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_0, 0xa000)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_0, PMU_EVENT3_ID, 24, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_0, PMU_EVENT2_ID, 16, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_0, PMU_EVENT1_ID, 8, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_0, PMU_EVENT0_ID, 0, 8)
REG32(POR_DTM_CONTROL_U_SMXP_0_0, 0xa100)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_0, TRACE_NO_ATB, 3, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_0, SAMPLE_PROFILE_ENABLE, 2, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_0, TRACE_TAG_ENABLE, 1, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_0, DTM_ENABLE, 0, 1)
REG32(POR_DTM_FIFO_ENTRY_READY_U_SMXP_0_0, 0xa118)
    FIELD(POR_DTM_FIFO_ENTRY_READY_U_SMXP_0_0, READY, 0, 4)
REG32(POR_DTM_FIFO_ENTRY0_0_U_SMXP_0_0, 0xa120)
REG32(POR_DTM_FIFO_ENTRY0_1_U_SMXP_0_0, 0xa128)
REG32(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_0, 0xa130)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY1_0_U_SMXP_0_0, 0xa138)
REG32(POR_DTM_FIFO_ENTRY1_1_U_SMXP_0_0, 0xa140)
REG32(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_0, 0xa148)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY2_0_U_SMXP_0_0, 0xa150)
REG32(POR_DTM_FIFO_ENTRY2_1_U_SMXP_0_0, 0xa158)
REG32(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_0, 0xa160)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY3_0_U_SMXP_0_0, 0xa168)
REG32(POR_DTM_FIFO_ENTRY3_1_U_SMXP_0_0, 0xa170)
REG32(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_0, 0xa178)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_WP0_CONFIG_U_SMXP_0_0, 0xa1a0)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_COMBINE, 6, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP0_VAL_U_SMXP_0_0, 0xa1a8)
REG32(POR_DTM_WP0_MASK_U_SMXP_0_0, 0xa1b0)
REG32(POR_DTM_WP1_CONFIG_U_SMXP_0_0, 0xa1b8)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP1_VAL_U_SMXP_0_0, 0xa1c0)
REG32(POR_DTM_WP1_MASK_U_SMXP_0_0, 0xa1c8)
REG32(POR_DTM_WP2_CONFIG_U_SMXP_0_0, 0xa1d0)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_COMBINE, 6, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP2_VAL_U_SMXP_0_0, 0xa1d8)
REG32(POR_DTM_WP2_MASK_U_SMXP_0_0, 0xa1e0)
REG32(POR_DTM_WP3_CONFIG_U_SMXP_0_0, 0xa1e8)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP3_VAL_U_SMXP_0_0, 0xa1f0)
REG32(POR_DTM_WP3_MASK_U_SMXP_0_0, 0xa1f8)
REG32(POR_DTM_PMSICR_U_SMXP_0_0, 0xa200)
    FIELD(POR_DTM_PMSICR_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_PMSICR_U_SMXP_0_0, COUNT, 0, 32)
REG32(POR_DTM_PMSIRR_U_SMXP_0_0, 0xa208)
    FIELD(POR_DTM_PMSIRR_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_PMSIRR_U_SMXP_0_0, INTERVAL, 8, 24)
    FIELD(POR_DTM_PMSIRR_U_SMXP_0_0, RESERVED_0, 0, 8)
REG32(POR_DTM_PMU_CONFIG_U_SMXP_0_0, 0xa210)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_62, 62, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT3_INPUT_SEL, 56, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_54, 54, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT2_INPUT_SEL, 48, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_46, 46, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT1_INPUT_SEL, 40, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_38, 38, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT0_INPUT_SEL, 32, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_31, 31, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT3_GLOBAL_NUM, 28, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_27, 27, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT2_GLOBAL_NUM, 24, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_23, 23, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT1_GLOBAL_NUM, 20, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_19, 19, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT0_GLOBAL_NUM, 16, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, RESERVED_9, 9, 7)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, CNTR_RST, 8, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT_PAIRED, 4, 4)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNTALL_COMBINED, 3, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT23_COMBINED, 2, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMEVCNT01_COMBINED, 1, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_0, PMU_EN, 0, 1)
REG32(POR_DTM_PMEVCNT_U_SMXP_0_0, 0xa220)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_0, PMEVCNT3, 48, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_0, PMEVCNT2, 32, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_0, PMEVCNT1, 16, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_0, PMEVCNT0, 0, 16)
REG32(POR_DTM_PMEVCNTSR_U_SMXP_0_0, 0xa240)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_0, PMEVCNTSR3, 48, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_0, PMEVCNTSR2, 32, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_0, PMEVCNTSR1, 16, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_0, PMEVCNTSR0, 0, 16)
REG32(POR_MXP_ERRFR_U_SMXP_0_0, 0xb000)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, RESERVED_15, 15, 49)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, CEC, 12, 3)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, CFI, 10, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, DE, 2, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_0, ED, 0, 2)
REG32(POR_MXP_ERRCTLR_U_SMXP_0_0, 0xb008)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_0, RESERVED_9, 9, 55)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_0, CFI, 8, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_0, DE, 1, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_0, ED, 0, 1)
REG32(POR_MXP_ERRSTATUS_U_SMXP_0_0, 0xb010)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, AV, 31, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, MV, 26, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, RESERVED_25, 25, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, CE, 24, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_0, RESERVED_0, 0, 23)
REG32(POR_MXP_ERRMISC_U_SMXP_0_0, 0xb028)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, RESERVED_59, 59, 5)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, TGTID, 48, 11)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, RESERVED_22, 22, 26)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, OPCODE, 16, 6)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, RESERVED_15, 15, 1)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, SRCID, 4, 11)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_0, ERRSRC, 0, 3)
REG32(POR_MXP_P0_BYTE_PAR_ERR_INJ_U_SMXP_0_0, 0xb030)
    FIELD(POR_MXP_P0_BYTE_PAR_ERR_INJ_U_SMXP_0_0, P0_BYTE_PARITY_ERR_INJ, 0, 5)
REG32(POR_MXP_P1_BYTE_PAR_ERR_INJ_U_SMXP_0_0, 0xb038)
    FIELD(POR_MXP_P1_BYTE_PAR_ERR_INJ_U_SMXP_0_0, P1_BYTE_PARITY_ERR_INJ, 0, 5)
REG32(POR_MXP_ERRFR_NS_U_SMXP_0_0, 0xb100)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, RESERVED_15, 15, 49)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, CEC, 12, 3)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, CFI, 10, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, DE, 2, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_0, ED, 0, 2)
REG32(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, 0xb108)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, RESERVED_9, 9, 55)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, CFI, 8, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, DE, 1, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_0, ED, 0, 1)
REG32(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, 0xb110)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, AV, 31, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, MV, 26, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, RESERVED_25, 25, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, CE, 24, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_0, RESERVED_0, 0, 23)
REG32(POR_MXP_ERRMISC_NS_U_SMXP_0_0, 0xb128)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, RESERVED_59, 59, 5)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, TGTID, 48, 11)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, RESERVED_22, 22, 26)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, OPCODE, 16, 6)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, RESERVED_15, 15, 1)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, SRCID, 4, 11)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_0, ERRSRC, 0, 3)
REG32(POR_RNI_NODE_INFO_U_RNI_NID4, 0x14000)
    FIELD(POR_RNI_NODE_INFO_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_RNI_NODE_INFO_U_RNI_NID4, LOGICAL_ID, 32, 16)
    FIELD(POR_RNI_NODE_INFO_U_RNI_NID4, NODE_ID, 16, 16)
    FIELD(POR_RNI_NODE_INFO_U_RNI_NID4, NODE_TYPE, 0, 16)
REG32(POR_RNI_CHILD_INFO_U_RNI_NID4, 0x14080)
    FIELD(POR_RNI_CHILD_INFO_U_RNI_NID4, RESERVED_32, 32, 32)
    FIELD(POR_RNI_CHILD_INFO_U_RNI_NID4, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_RNI_CHILD_INFO_U_RNI_NID4, CHILD_COUNT, 0, 16)
REG32(POR_RNI_UNIT_INFO_U_RNI_NID4, 0x14900)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, RESERVED_46, 46, 18)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, A4S_SAFE_XFACE_DISABLE, 45, 1)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, ACEL_SAFE_XFACE_DISABLE, 44, 1)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, A4S_LOGICALID_BASE, 36, 8)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, RESERVED_34, 34, 2)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, A4S_NUM, 32, 2)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, RESERVED_29, 29, 3)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, FORCE_RDB_PREALLOC, 28, 1)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, AX_DATAPOISON_EN, 27, 1)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, AX_DATA_256BIT, 26, 1)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, RESERVED_24, 24, 2)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, NUM_RD_BUFS, 16, 8)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, NUM_RD_REQS, 8, 8)
    FIELD(POR_RNI_UNIT_INFO_U_RNI_NID4, NUM_WR_REQS, 0, 8)
REG32(POR_RNI_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNI_NID4, 0x14980)
    FIELD(POR_RNI_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNI_NID4, QOS_CTRL, 2, 1)
    FIELD(POR_RNI_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNI_NID4, PORT_CTRL, 1, 1)
    FIELD(POR_RNI_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNI_NID4, CFG_CTL, 0, 1)
REG32(POR_RNI_CFG_CTL_U_RNI_NID4, 0x14a00)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, RESERVED_32, 32, 32)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, MAX_WRT_OUTSTD_CHITXN_CNT, 24, 8)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, MAX_RRT_OUTSTD_CHITXN_CNT, 16, 8)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, RESERVED_15, 15, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, WRT_CRDGNT_WEIGHT, 12, 3)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, RRT_CRDGNT_WEIGHT, 8, 3)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, DIS_NCWR_STREAM, 6, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, PCIE_MSTR_PRESENT, 5, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, QPC15_ENTRY_RSV_EN, 4, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, FORCE_PREALLOC_RDB, 3, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, DIS_WR_STREAM, 2, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, WFC, 1, 1)
    FIELD(POR_RNI_CFG_CTL_U_RNI_NID4, QPC_EN, 0, 1)
REG32(POR_RNI_AUX_CTL_U_RNI_NID4, 0x14a08)
    FIELD(POR_RNI_AUX_CTL_U_RNI_NID4, SAMEID_WRSTASH_STREAM_EN, 5, 1)
    FIELD(POR_RNI_AUX_CTL_U_RNI_NID4, UPSTRM_DATCHECK_EN, 4, 1)
    FIELD(POR_RNI_AUX_CTL_U_RNI_NID4, DIS_NORM_RDSTREAM, 3, 1)
    FIELD(POR_RNI_AUX_CTL_U_RNI_NID4, PARK_PORT_ARB_PTR, 2, 1)
    FIELD(POR_RNI_AUX_CTL_U_RNI_NID4, AR_BYP_EN, 1, 1)
    FIELD(POR_RNI_AUX_CTL_U_RNI_NID4, CG_DISABLE, 0, 1)
REG32(POR_RNI_S0_PORT_CONTROL_U_RNI_NID4, 0x14a10)
    FIELD(POR_RNI_S0_PORT_CONTROL_U_RNI_NID4, RESERVED_11, 11, 53)
    FIELD(POR_RNI_S0_PORT_CONTROL_U_RNI_NID4, S0_LPID_MASK, 0, 11)
REG32(POR_RNI_S1_PORT_CONTROL_U_RNI_NID4, 0x14a18)
    FIELD(POR_RNI_S1_PORT_CONTROL_U_RNI_NID4, RESERVED_11, 11, 53)
    FIELD(POR_RNI_S1_PORT_CONTROL_U_RNI_NID4, S1_LPID_MASK, 0, 11)
REG32(POR_RNI_S2_PORT_CONTROL_U_RNI_NID4, 0x14a20)
    FIELD(POR_RNI_S2_PORT_CONTROL_U_RNI_NID4, RESERVED_11, 11, 53)
    FIELD(POR_RNI_S2_PORT_CONTROL_U_RNI_NID4, S2_LPID_MASK, 0, 11)
REG32(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, 0x14a80)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, RESERVED_24, 24, 40)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AR_QOS_OVERRIDE, 20, 4)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AW_QOS_OVERRIDE, 16, 4)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AR_PQV_MODE, 7, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AW_PQV_MODE, 6, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AR_REG_MODE, 5, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AW_REG_MODE, 4, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AR_QOS_OVERRIDE_EN, 3, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AW_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AR_LAT_EN, 1, 1)
    FIELD(POR_RNI_S0_QOS_CONTROL_U_RNI_NID4, S0_AW_LAT_EN, 0, 1)
REG32(POR_RNI_S0_QOS_LAT_TGT_U_RNI_NID4, 0x14a88)
    FIELD(POR_RNI_S0_QOS_LAT_TGT_U_RNI_NID4, RESERVED_28, 28, 36)
    FIELD(POR_RNI_S0_QOS_LAT_TGT_U_RNI_NID4, S0_AR_LAT_TGT, 16, 12)
    FIELD(POR_RNI_S0_QOS_LAT_TGT_U_RNI_NID4, RESERVED_12, 12, 4)
    FIELD(POR_RNI_S0_QOS_LAT_TGT_U_RNI_NID4, S0_AW_LAT_TGT, 0, 12)
REG32(POR_RNI_S0_QOS_LAT_SCALE_U_RNI_NID4, 0x14a90)
    FIELD(POR_RNI_S0_QOS_LAT_SCALE_U_RNI_NID4, RESERVED_11, 11, 53)
    FIELD(POR_RNI_S0_QOS_LAT_SCALE_U_RNI_NID4, S0_AR_LAT_SCALE, 8, 3)
    FIELD(POR_RNI_S0_QOS_LAT_SCALE_U_RNI_NID4, S0_AW_LAT_SCALE, 0, 3)
REG32(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, 0x14a98)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_28, 28, 36)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, S0_AR_LAT_MAX_QOS, 24, 4)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_20, 20, 4)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, S0_AR_LAT_MIN_QOS, 16, 4)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_12, 12, 4)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, S0_AW_LAT_MAX_QOS, 8, 4)
    FIELD(POR_RNI_S0_QOS_LAT_RANGE_U_RNI_NID4, S0_AW_LAT_MIN_QOS, 0, 4)
REG32(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, 0x14aa0)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, RESERVED_24, 24, 40)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AR_QOS_OVERRIDE, 20, 4)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AW_QOS_OVERRIDE, 16, 4)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AR_PQV_MODE, 7, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AW_PQV_MODE, 6, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AR_REG_MODE, 5, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AW_REG_MODE, 4, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AR_QOS_OVERRIDE_EN, 3, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AW_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AR_LAT_EN, 1, 1)
    FIELD(POR_RNI_S1_QOS_CONTROL_U_RNI_NID4, S1_AW_LAT_EN, 0, 1)
REG32(POR_RNI_S1_QOS_LAT_TGT_U_RNI_NID4, 0x14aa8)
    FIELD(POR_RNI_S1_QOS_LAT_TGT_U_RNI_NID4, RESERVED_28, 28, 36)
    FIELD(POR_RNI_S1_QOS_LAT_TGT_U_RNI_NID4, S1_AR_LAT_TGT, 16, 12)
    FIELD(POR_RNI_S1_QOS_LAT_TGT_U_RNI_NID4, RESERVED_12, 12, 4)
    FIELD(POR_RNI_S1_QOS_LAT_TGT_U_RNI_NID4, S1_AW_LAT_TGT, 0, 12)
REG32(POR_RNI_S1_QOS_LAT_SCALE_U_RNI_NID4, 0x14ab0)
    FIELD(POR_RNI_S1_QOS_LAT_SCALE_U_RNI_NID4, RESERVED_11, 11, 53)
    FIELD(POR_RNI_S1_QOS_LAT_SCALE_U_RNI_NID4, S1_AR_LAT_SCALE, 8, 3)
    FIELD(POR_RNI_S1_QOS_LAT_SCALE_U_RNI_NID4, S1_AW_LAT_SCALE, 0, 3)
REG32(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, 0x14ab8)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_28, 28, 36)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, S1_AR_LAT_MAX_QOS, 24, 4)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_20, 20, 4)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, S1_AR_LAT_MIN_QOS, 16, 4)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_12, 12, 4)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, S1_AW_LAT_MAX_QOS, 8, 4)
    FIELD(POR_RNI_S1_QOS_LAT_RANGE_U_RNI_NID4, S1_AW_LAT_MIN_QOS, 0, 4)
REG32(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, 0x14ac0)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, RESERVED_24, 24, 40)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AR_QOS_OVERRIDE, 20, 4)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AW_QOS_OVERRIDE, 16, 4)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AR_PQV_MODE, 7, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AW_PQV_MODE, 6, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AR_REG_MODE, 5, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AW_REG_MODE, 4, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AR_QOS_OVERRIDE_EN, 3, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AW_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AR_LAT_EN, 1, 1)
    FIELD(POR_RNI_S2_QOS_CONTROL_U_RNI_NID4, S2_AW_LAT_EN, 0, 1)
REG32(POR_RNI_S2_QOS_LAT_TGT_U_RNI_NID4, 0x14ac8)
    FIELD(POR_RNI_S2_QOS_LAT_TGT_U_RNI_NID4, RESERVED_28, 28, 36)
    FIELD(POR_RNI_S2_QOS_LAT_TGT_U_RNI_NID4, S2_AR_LAT_TGT, 16, 12)
    FIELD(POR_RNI_S2_QOS_LAT_TGT_U_RNI_NID4, RESERVED_12, 12, 4)
    FIELD(POR_RNI_S2_QOS_LAT_TGT_U_RNI_NID4, S2_AW_LAT_TGT, 0, 12)
REG32(POR_RNI_S2_QOS_LAT_SCALE_U_RNI_NID4, 0x14ad0)
    FIELD(POR_RNI_S2_QOS_LAT_SCALE_U_RNI_NID4, RESERVED_11, 11, 53)
    FIELD(POR_RNI_S2_QOS_LAT_SCALE_U_RNI_NID4, S2_AR_LAT_SCALE, 8, 3)
    FIELD(POR_RNI_S2_QOS_LAT_SCALE_U_RNI_NID4, S2_AW_LAT_SCALE, 0, 3)
REG32(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, 0x14ad8)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_28, 28, 36)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, S2_AR_LAT_MAX_QOS, 24, 4)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_20, 20, 4)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, S2_AR_LAT_MIN_QOS, 16, 4)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, RESERVED_12, 12, 4)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, S2_AW_LAT_MAX_QOS, 8, 4)
    FIELD(POR_RNI_S2_QOS_LAT_RANGE_U_RNI_NID4, S2_AW_LAT_MIN_QOS, 0, 4)
REG32(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, 0x16000)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, RESERVED_29, 29, 35)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, PMU_EVENT3_ID, 24, 5)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, RESERVED_21, 21, 3)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, PMU_EVENT2_ID, 16, 5)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, RESERVED_13, 13, 3)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, PMU_EVENT1_ID, 8, 5)
    FIELD(POR_RNI_PMU_EVENT_SEL_U_RNI_NID4, PMU_EVENT0_ID, 0, 5)
REG32(POR_RNSAM_NODE_INFO_U_RNI_NID4, 0x24000)
    FIELD(POR_RNSAM_NODE_INFO_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RNI_NID4, LOGICAL_ID, 32, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RNI_NID4, NODE_ID, 16, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RNI_NID4, NODE_TYPE, 0, 16)
REG32(POR_RNSAM_CHILD_INFO_U_RNI_NID4, 0x24080)
    FIELD(POR_RNSAM_CHILD_INFO_U_RNI_NID4, RESERVED_32, 32, 32)
    FIELD(POR_RNSAM_CHILD_INFO_U_RNI_NID4, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_RNSAM_CHILD_INFO_U_RNI_NID4, CHILD_COUNT, 0, 16)
REG32(POR_RNSAM_UNIT_INFO_U_RNI_NID4, 0x24900)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNI_NID4, RESERVED_37, 37, 27)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNI_NID4, NUM_NON_HASH_GROUP, 32, 5)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNI_NID4, RESERVED_20, 20, 12)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNI_NID4, NUM_SYS_CACHE_GROUP, 16, 4)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNI_NID4, NUM_HNF, 0, 8)
REG32(POR_RNSAM_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNI_NID4, 0x24980)
    FIELD(POR_RNSAM_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNI_NID4, MEM_RANGE, 0, 1)
REG32(RNSAM_STATUS_U_RNI_NID4, 0x24c00)
    FIELD(RNSAM_STATUS_U_RNI_NID4, NSTALL_REQ, 1, 1)
    FIELD(RNSAM_STATUS_U_RNI_NID4, USE_DEFAULT_NODE, 0, 1)
REG32(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, 0x24c08)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION1_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION1_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION1_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION1_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION0_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION0_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION0_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNI_NID4, REGION0_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, 0x24c10)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION3_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION3_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION3_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION3_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION2_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION2_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION2_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNI_NID4, REGION2_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, 0x24c18)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION5_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION5_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION5_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION5_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION4_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION4_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION4_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNI_NID4, REGION4_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, 0x24c20)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION7_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION7_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION7_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION7_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION6_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION6_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION6_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNI_NID4, REGION6_VALID, 0, 1)
REG32(NON_HASH_TGT_NODEID0_U_RNI_NID4, 0x24c30)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, NODEID_3, 36, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, NODEID_2, 24, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, NODEID_1, 12, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RNI_NID4, NODEID_0, 0, 11)
REG32(NON_HASH_TGT_NODEID1_U_RNI_NID4, 0x24c38)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, NODEID_7, 36, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, NODEID_6, 24, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, NODEID_5, 12, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RNI_NID4, NODEID_4, 0, 11)
REG32(NON_HASH_TGT_NODEID2_U_RNI_NID4, 0x24c40)
    FIELD(NON_HASH_TGT_NODEID2_U_RNI_NID4, RESERVED_23, 23, 41)
    FIELD(NON_HASH_TGT_NODEID2_U_RNI_NID4, NODEID_9, 12, 11)
    FIELD(NON_HASH_TGT_NODEID2_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID2_U_RNI_NID4, NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_REGION0_U_RNI_NID4, 0x24c48)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION1_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION1_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION1_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION1_NONHASH_REG_EN, 33, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION1_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION0_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION0_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION0_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNI_NID4, REGION0_VALID, 0, 1)
REG32(SYS_CACHE_GRP_REGION1_U_RNI_NID4, 0x24c50)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION3_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION3_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION3_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION3_NONHASH_REG_EN, 33, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION3_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION2_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION2_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION2_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION2_NONHASH_REG_EN, 1, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNI_NID4, REGION2_VALID, 0, 1)
REG32(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, 0x24c58)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, NODEID_3, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, NODEID_2, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, NODEID_1, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNI_NID4, NODEID_0, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, 0x24c60)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, NODEID_7, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, NODEID_6, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, NODEID_5, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNI_NID4, NODEID_4, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, 0x24c68)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, NODEID_11, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, NODEID_10, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, NODEID_9, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNI_NID4, NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, 0x24c70)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, NODEID_15, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, NODEID_14, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, NODEID_13, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNI_NID4, NODEID_12, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, 0x24c78)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, NODEID_19, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, NODEID_18, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, NODEID_17, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNI_NID4, NODEID_16, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, 0x24c80)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, NODEID_23, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, NODEID_22, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, NODEID_21, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNI_NID4, NODEID_20, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, 0x24c88)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, NODEID_27, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, NODEID_26, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, NODEID_25, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNI_NID4, NODEID_24, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, 0x24c90)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, NODEID_31, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, NODEID_30, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, NODEID_29, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNI_NID4, NODEID_28, 0, 11)
REG32(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, 0x24c98)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, RESERVED_35, 35, 29)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, SCG3_NODEID, 24, 11)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, SCG2_NODEID, 12, 11)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNI_NID4, SCG1_NODEID, 0, 11)
REG32(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, 0x24d00)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, RESERVED_31, 31, 33)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, SCG3_NUM_HNF, 24, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, SCG2_NUM_HNF, 16, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, RESERVED_15, 15, 1)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, SCG1_NUM_HNF, 8, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNI_NID4, SCG0_NUM_HNF, 0, 7)
REG32(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, 0x24d08)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, SN_NODEID_3, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, SN_NODEID_2, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, SN_NODEID_1, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNI_NID4, SN_NODEID_0, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, 0x24d10)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, SN_NODEID_7, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, SN_NODEID_6, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, SN_NODEID_5, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNI_NID4, SN_NODEID_4, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, 0x24d18)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, SN_NODEID_11, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, SN_NODEID_10, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, SN_NODEID_9, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNI_NID4, SN_NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, 0x24d20)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, SN_NODEID_15, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, SN_NODEID_14, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, SN_NODEID_13, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNI_NID4, SN_NODEID_12, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, 0x24d28)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, SN_NODEID_19, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, SN_NODEID_18, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, SN_NODEID_17, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNI_NID4, SN_NODEID_16, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, 0x24d30)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, SN_NODEID_23, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, SN_NODEID_22, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, SN_NODEID_21, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNI_NID4, SN_NODEID_20, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, 0x24d38)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, SN_NODEID_27, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, SN_NODEID_26, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, SN_NODEID_25, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNI_NID4, SN_NODEID_24, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, 0x24d40)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, SN_NODEID_31, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, SN_NODEID_30, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, SN_NODEID_29, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNI_NID4, SN_NODEID_28, 0, 11)
REG32(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, 0x24d48)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, RESERVED_46, 46, 18)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, SCG1_TOP_ADDRESS_BIT2, 40, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, RESERVED_38, 38, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, SCG1_TOP_ADDRESS_BIT1, 32, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, RESERVED_30, 30, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, SCG1_TOP_ADDRESS_BIT0, 24, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, RESERVED_22, 22, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, SCG0_TOP_ADDRESS_BIT2, 16, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, RESERVED_14, 14, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, SCG0_TOP_ADDRESS_BIT1, 8, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNI_NID4, SCG0_TOP_ADDRESS_BIT0, 0, 6)
REG32(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, 0x24d50)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, RESERVED_46, 46, 18)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, SCG3_TOP_ADDRESS_BIT2, 40, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, RESERVED_38, 38, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, SCG3_TOP_ADDRESS_BIT1, 32, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, RESERVED_30, 30, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, SCG3_TOP_ADDRESS_BIT0, 24, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, RESERVED_22, 22, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, SCG2_TOP_ADDRESS_BIT2, 16, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, RESERVED_14, 14, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, SCG2_TOP_ADDRESS_BIT1, 8, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNI_NID4, SCG2_TOP_ADDRESS_BIT0, 0, 6)
REG32(GIC_MEM_REGION_REG_U_RNI_NID4, 0x24d58)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, GIC_REGION_NODEID, 52, 11)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, RESERVED_48, 48, 4)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, GIC_REGION_BASE_ADDR, 16, 32)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, GIC_REGION_SIZE, 4, 3)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, GIC_REGION_TARGET_TYPE, 2, 2)
    FIELD(GIC_MEM_REGION_REG_U_RNI_NID4, GIC_REGION_VALID, 0, 1)
REG32(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, 0x24d60)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, RESERVED_54, 54, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, SN_MODE_SYS_CACHE_GRP3, 52, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, RESERVED_49, 49, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP3, 48, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, RESERVED_38, 38, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, SN_MODE_SYS_CACHE_GRP2, 36, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, RESERVED_33, 33, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP2, 32, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, RESERVED_22, 22, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, SN_MODE_SYS_CACHE_GRP1, 20, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, RESERVED_17, 17, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP1, 16, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, SN_MODE_SYS_CACHE_GRP0, 4, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNI_NID4, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP0, 0, 1)
REG32(SYS_CACHE_GRP_HN_CPA_EN_REG_U_RNI_NID4, 0x24d68)
REG32(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, 0x24d70)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, RESERVED_50, 50, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, CPA_GRP_SCG3, 48, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, RESERVED_34, 34, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, CPA_GRP_SCG2, 32, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, RESERVED_18, 18, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, CPA_GRP_SCG1, 16, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNI_NID4, CPA_GRP_SCG0, 0, 2)
REG32(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, 0x24e00)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_32, 32, 32)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION7_PAG_GRPID, 30, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_29, 29, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION7_PAG_EN, 28, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_27, 27, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION6_PAG_GRPID, 25, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION6_PAG_EN, 24, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION5_PAG_GRPID, 21, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION5_PAG_EN, 20, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_19, 19, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION4_PAG_GRPID, 17, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION4_PAG_EN, 16, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_15, 15, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION3_PAG_GRPID, 13, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION3_PAG_EN, 12, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION2_PAG_GRPID, 9, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION2_PAG_EN, 8, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION1_PAG_GRPID, 5, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION1_PAG_EN, 4, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION0_PAG_GRPID, 1, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNI_NID4, REGION0_PAG_EN, 0, 1)
REG32(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNI_NID4, 0x24e08)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNI_NID4, ADDR_MASK, 6, 42)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNI_NID4, RESERVED_0, 0, 6)
REG32(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNI_NID4, 0x24e10)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNI_NID4, ADDR_MASK, 6, 42)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNI_NID4, RESERVED_0, 0, 6)
REG32(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, 0x24e40)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, RESERVED_50, 50, 14)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, NUM_CXG_PAG0, 48, 2)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, RESERVED_47, 47, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, PAG0_TGTID3, 36, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, PAG0_TGTID2, 24, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, PAG0_TGTID1, 12, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNI_NID4, PAG0_TGTID0, 0, 11)
REG32(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, 0x24e48)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, RESERVED_50, 50, 14)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, NUM_CXG_PAG1, 48, 2)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, RESERVED_47, 47, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, PAG1_TGTID3, 36, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, PAG1_TGTID2, 24, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, PAG1_TGTID1, 12, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNI_NID4, PAG1_TGTID0, 0, 11)
REG32(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, 0x24f00)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION1_SCNDRY_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION1_SCNDRY_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION1_SCNDRY_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, RESERVED_33, 33, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION1_SCNDRY_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION0_SCNDRY_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION0_SCNDRY_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION0_SCNDRY_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNI_NID4, REGION0_SCNDRY_VALID, 0, 1)
REG32(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, 0x24f08)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION3_SCNDRY_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION3_SCNDRY_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION3_SCNDRY_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, RESERVED_33, 33, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION3_SCNDRY_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION2_SCNDRY_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION2_SCNDRY_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION2_SCNDRY_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNI_NID4, REGION2_SCNDRY_VALID, 0, 1)
REG32(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, 0x24f10)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, RESERVED_49, 49, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, SCG3_HNF_CAL_MODE_EN, 48, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, RESERVED_33, 33, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, SCG2_HNF_CAL_MODE_EN, 32, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, RESERVED_17, 17, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, SCG1_HNF_CAL_MODE_EN, 16, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNI_NID4, SCG0_HNF_CAL_MODE_EN, 0, 1)
REG32(RNSAM_HASH_ADDR_MASK_REG_U_RNI_NID4, 0x24f18)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RNI_NID4, ADDR_MASK, 6, 42)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RNI_NID4, RESERVED_0, 0, 6)
REG32(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNI_NID4, 0x24f20)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNI_NID4, ADDR_MASK, 16, 32)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNI_NID4, RESERVED_0, 0, 16)
REG32(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, 0x24f58)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, NODEID_35, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, NODEID_34, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, NODEID_33, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNI_NID4, NODEID_32, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, 0x24f60)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, NODEID_39, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, NODEID_38, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, NODEID_37, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNI_NID4, NODEID_36, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, 0x24f68)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, NODEID_43, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, NODEID_42, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, NODEID_41, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNI_NID4, NODEID_40, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, 0x24f70)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, NODEID_47, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, NODEID_46, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, NODEID_45, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNI_NID4, NODEID_44, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, 0x24f78)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, NODEID_51, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, NODEID_50, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, NODEID_49, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNI_NID4, NODEID_48, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, 0x24f80)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, NODEID_55, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, NODEID_54, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, NODEID_53, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNI_NID4, NODEID_52, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, 0x24f88)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, NODEID_59, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, NODEID_58, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, NODEID_57, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNI_NID4, NODEID_56, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, 0x24f90)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, NODEID_63, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, NODEID_62, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, NODEID_61, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNI_NID4, NODEID_60, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, 0x25008)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, SN_NODEID_35, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, SN_NODEID_34, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, SN_NODEID_33, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNI_NID4, SN_NODEID_32, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, 0x25010)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, SN_NODEID_39, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, SN_NODEID_38, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, SN_NODEID_37, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNI_NID4, SN_NODEID_36, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, 0x25018)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, SN_NODEID_43, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, SN_NODEID_42, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, SN_NODEID_41, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNI_NID4, SN_NODEID_40, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, 0x25020)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, SN_NODEID_47, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, SN_NODEID_46, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, SN_NODEID_45, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNI_NID4, SN_NODEID_44, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, 0x25028)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, SN_NODEID_51, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, SN_NODEID_50, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, SN_NODEID_49, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNI_NID4, SN_NODEID_48, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, 0x25030)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, SN_NODEID_55, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, SN_NODEID_54, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, SN_NODEID_53, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNI_NID4, SN_NODEID_52, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, 0x25038)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, SN_NODEID_59, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, SN_NODEID_58, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, SN_NODEID_57, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNI_NID4, SN_NODEID_56, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, 0x25040)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, SN_NODEID_63, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, SN_NODEID_62, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, SN_NODEID_61, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNI_NID4, SN_NODEID_60, 0, 11)
REG32(POR_FDC_NODE_INFO_U_SMXP_0_0, 0x2c000)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_0, LOGICAL_ID, 32, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_0, NODE_ID, 16, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_0, NODE_TYPE, 0, 16)
REG32(POR_FDC_CHILD_INFO_U_SMXP_0_0, 0x2c080)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_0_0, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_0_0, CHILD_COUNT, 0, 16)
REG32(POR_ERRFR_MXP_U_SMXP_0_0, 0x2f000)
    FIELD(POR_ERRFR_MXP_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_MXP_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_MXP_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_MXP_U_SMXP_0_0, 0x2f008)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_MXP_U_SMXP_0_0, 0x2f010)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_MXP_U_SMXP_0_0, 0x2f018)
    FIELD(POR_FDC_AUX_CTL_MXP_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_MXP_U_SMXP_0_0, RESERVED_0, 0, 4)
REG32(POR_ERRFR_P0_D0_U_SMXP_0_0, 0x2f040)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D0_U_SMXP_0_0, 0x2f048)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, 0x2f050)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D0_U_SMXP_0_0, 0x2f058)
    FIELD(POR_FDC_AUX_CTL_P0_D0_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D0_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D1_U_SMXP_0_0, 0x2f080)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D1_U_SMXP_0_0, 0x2f088)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, 0x2f090)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D1_U_SMXP_0_0, 0x2f098)
    FIELD(POR_FDC_AUX_CTL_P0_D1_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D1_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D2_U_SMXP_0_0, 0x2f0c0)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D2_U_SMXP_0_0, 0x2f0c8)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, 0x2f0d0)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D2_U_SMXP_0_0, 0x2f0d8)
    FIELD(POR_FDC_AUX_CTL_P0_D2_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D2_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D3_U_SMXP_0_0, 0x2f100)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D3_U_SMXP_0_0, 0x2f108)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, 0x2f110)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D3_U_SMXP_0_0, 0x2f118)
    FIELD(POR_FDC_AUX_CTL_P0_D3_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D3_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D0_U_SMXP_0_0, 0x2f140)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D0_U_SMXP_0_0, 0x2f148)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, 0x2f150)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D0_U_SMXP_0_0, 0x2f158)
    FIELD(POR_FDC_AUX_CTL_P1_D0_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D0_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D1_U_SMXP_0_0, 0x2f180)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D1_U_SMXP_0_0, 0x2f188)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, 0x2f190)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D1_U_SMXP_0_0, 0x2f198)
    FIELD(POR_FDC_AUX_CTL_P1_D1_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D1_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D2_U_SMXP_0_0, 0x2f1c0)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D2_U_SMXP_0_0, 0x2f1c8)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, 0x2f1d0)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D2_U_SMXP_0_0, 0x2f1d8)
    FIELD(POR_FDC_AUX_CTL_P1_D2_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D2_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D3_U_SMXP_0_0, 0x2f200)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_0_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_0_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_0_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D3_U_SMXP_0_0, 0x2f208)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, 0x2f210)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D3_U_SMXP_0_0, 0x2f218)
    FIELD(POR_FDC_AUX_CTL_P1_D3_U_SMXP_0_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D3_U_SMXP_0_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRINJECT_U_SMXP_0_0, 0x2f300)
    FIELD(POR_ERRINJECT_U_SMXP_0_0, ERR_DEV, 4, 4)
    FIELD(POR_ERRINJECT_U_SMXP_0_0, ERR_TYPE, 0, 4)
REG32(POR_FDC_KEY_U_SMXP_0_0, 0x2f308)
    FIELD(POR_FDC_KEY_U_SMXP_0_0, KEY, 0, 8)
REG32(POR_MPU_NODE_INFO_U_RNI_NID4, 0x34000)
    FIELD(POR_MPU_NODE_INFO_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_NODE_INFO_U_RNI_NID4, LOGICAL_ID, 32, 16)
    FIELD(POR_MPU_NODE_INFO_U_RNI_NID4, NODE_ID, 16, 16)
    FIELD(POR_MPU_NODE_INFO_U_RNI_NID4, NODE_TYPE, 0, 16)
REG32(POR_MPU_CHILD_INFO_U_RNI_NID4, 0x34080)
    FIELD(POR_MPU_CHILD_INFO_U_RNI_NID4, RESERVED_32, 32, 32)
    FIELD(POR_MPU_CHILD_INFO_U_RNI_NID4, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MPU_CHILD_INFO_U_RNI_NID4, CHILD_COUNT, 0, 16)
REG32(POR_MPU_UNIT_INFO_U_RNI_NID4, 0x34900)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, RESERVED_16, 16, 48)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_7_PRESENT, 15, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_6_PRESENT, 14, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_5_PRESENT, 13, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_4_PRESENT, 12, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_3_PRESENT, 11, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_2_PRESENT, 10, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_1_PRESENT, 9, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, MASTER_0_PRESENT, 8, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RNI_NID4, NUM_PROG_REGION, 0, 8)
REG32(POR_MPU_M0_CTL_U_RNI_NID4, 0x35000)
    FIELD(POR_MPU_M0_CTL_U_RNI_NID4, M0_EN, 2, 1)
    FIELD(POR_MPU_M0_CTL_U_RNI_NID4, M0_ACTION, 0, 2)
REG32(POR_MPU_M0_PRBAR0_U_RNI_NID4, 0x35010)
    FIELD(POR_MPU_M0_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR0_U_RNI_NID4, 0x35018)
    FIELD(POR_MPU_M0_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR1_U_RNI_NID4, 0x35020)
    FIELD(POR_MPU_M0_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR1_U_RNI_NID4, 0x35028)
    FIELD(POR_MPU_M0_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR2_U_RNI_NID4, 0x35030)
    FIELD(POR_MPU_M0_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR2_U_RNI_NID4, 0x35038)
    FIELD(POR_MPU_M0_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR3_U_RNI_NID4, 0x35040)
    FIELD(POR_MPU_M0_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR3_U_RNI_NID4, 0x35048)
    FIELD(POR_MPU_M0_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR4_U_RNI_NID4, 0x35050)
    FIELD(POR_MPU_M0_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR4_U_RNI_NID4, 0x35058)
    FIELD(POR_MPU_M0_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR5_U_RNI_NID4, 0x35060)
    FIELD(POR_MPU_M0_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR5_U_RNI_NID4, 0x35068)
    FIELD(POR_MPU_M0_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR6_U_RNI_NID4, 0x35070)
    FIELD(POR_MPU_M0_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR6_U_RNI_NID4, 0x35078)
    FIELD(POR_MPU_M0_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR7_U_RNI_NID4, 0x35080)
    FIELD(POR_MPU_M0_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR7_U_RNI_NID4, 0x35088)
    FIELD(POR_MPU_M0_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR8_U_RNI_NID4, 0x35090)
    FIELD(POR_MPU_M0_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR8_U_RNI_NID4, 0x35098)
    FIELD(POR_MPU_M0_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR9_U_RNI_NID4, 0x350a0)
    FIELD(POR_MPU_M0_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR9_U_RNI_NID4, 0x350a8)
    FIELD(POR_MPU_M0_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR10_U_RNI_NID4, 0x350b0)
    FIELD(POR_MPU_M0_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR10_U_RNI_NID4, 0x350b8)
    FIELD(POR_MPU_M0_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR11_U_RNI_NID4, 0x350c0)
    FIELD(POR_MPU_M0_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR11_U_RNI_NID4, 0x350c8)
    FIELD(POR_MPU_M0_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR12_U_RNI_NID4, 0x350d0)
    FIELD(POR_MPU_M0_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR12_U_RNI_NID4, 0x350d8)
    FIELD(POR_MPU_M0_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR13_U_RNI_NID4, 0x350e0)
    FIELD(POR_MPU_M0_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR13_U_RNI_NID4, 0x350e8)
    FIELD(POR_MPU_M0_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR14_U_RNI_NID4, 0x350f0)
    FIELD(POR_MPU_M0_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR14_U_RNI_NID4, 0x350f8)
    FIELD(POR_MPU_M0_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR15_U_RNI_NID4, 0x35100)
    FIELD(POR_MPU_M0_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR15_U_RNI_NID4, 0x35108)
    FIELD(POR_MPU_M0_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR16_U_RNI_NID4, 0x35110)
    FIELD(POR_MPU_M0_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR16_U_RNI_NID4, 0x35118)
    FIELD(POR_MPU_M0_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR17_U_RNI_NID4, 0x35120)
    FIELD(POR_MPU_M0_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR17_U_RNI_NID4, 0x35128)
    FIELD(POR_MPU_M0_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR18_U_RNI_NID4, 0x35130)
    FIELD(POR_MPU_M0_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR18_U_RNI_NID4, 0x35138)
    FIELD(POR_MPU_M0_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR19_U_RNI_NID4, 0x35140)
    FIELD(POR_MPU_M0_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR19_U_RNI_NID4, 0x35148)
    FIELD(POR_MPU_M0_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR20_U_RNI_NID4, 0x35150)
    FIELD(POR_MPU_M0_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR20_U_RNI_NID4, 0x35158)
    FIELD(POR_MPU_M0_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR21_U_RNI_NID4, 0x35160)
    FIELD(POR_MPU_M0_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR21_U_RNI_NID4, 0x35168)
    FIELD(POR_MPU_M0_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR22_U_RNI_NID4, 0x35170)
    FIELD(POR_MPU_M0_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR22_U_RNI_NID4, 0x35178)
    FIELD(POR_MPU_M0_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR23_U_RNI_NID4, 0x35180)
    FIELD(POR_MPU_M0_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR23_U_RNI_NID4, 0x35188)
    FIELD(POR_MPU_M0_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR24_U_RNI_NID4, 0x35190)
    FIELD(POR_MPU_M0_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR24_U_RNI_NID4, 0x35198)
    FIELD(POR_MPU_M0_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR25_U_RNI_NID4, 0x351a0)
    FIELD(POR_MPU_M0_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR25_U_RNI_NID4, 0x351a8)
    FIELD(POR_MPU_M0_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR26_U_RNI_NID4, 0x351b0)
    FIELD(POR_MPU_M0_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR26_U_RNI_NID4, 0x351b8)
    FIELD(POR_MPU_M0_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR27_U_RNI_NID4, 0x351c0)
    FIELD(POR_MPU_M0_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR27_U_RNI_NID4, 0x351c8)
    FIELD(POR_MPU_M0_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR28_U_RNI_NID4, 0x351d0)
    FIELD(POR_MPU_M0_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR28_U_RNI_NID4, 0x351d8)
    FIELD(POR_MPU_M0_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR29_U_RNI_NID4, 0x351e0)
    FIELD(POR_MPU_M0_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR29_U_RNI_NID4, 0x351e8)
    FIELD(POR_MPU_M0_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR30_U_RNI_NID4, 0x351f0)
    FIELD(POR_MPU_M0_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR30_U_RNI_NID4, 0x351f8)
    FIELD(POR_MPU_M0_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR31_U_RNI_NID4, 0x35200)
    FIELD(POR_MPU_M0_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR31_U_RNI_NID4, 0x35208)
    FIELD(POR_MPU_M0_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M1_CTL_U_RNI_NID4, 0x35400)
    FIELD(POR_MPU_M1_CTL_U_RNI_NID4, M1_EN, 2, 1)
    FIELD(POR_MPU_M1_CTL_U_RNI_NID4, M1_ACTION, 0, 2)
REG32(POR_MPU_M1_PRBAR0_U_RNI_NID4, 0x35410)
    FIELD(POR_MPU_M1_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR0_U_RNI_NID4, 0x35418)
    FIELD(POR_MPU_M1_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR1_U_RNI_NID4, 0x35420)
    FIELD(POR_MPU_M1_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR1_U_RNI_NID4, 0x35428)
    FIELD(POR_MPU_M1_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR2_U_RNI_NID4, 0x35430)
    FIELD(POR_MPU_M1_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR2_U_RNI_NID4, 0x35438)
    FIELD(POR_MPU_M1_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR3_U_RNI_NID4, 0x35440)
    FIELD(POR_MPU_M1_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR3_U_RNI_NID4, 0x35448)
    FIELD(POR_MPU_M1_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR4_U_RNI_NID4, 0x35450)
    FIELD(POR_MPU_M1_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR4_U_RNI_NID4, 0x35458)
    FIELD(POR_MPU_M1_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR5_U_RNI_NID4, 0x35460)
    FIELD(POR_MPU_M1_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR5_U_RNI_NID4, 0x35468)
    FIELD(POR_MPU_M1_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR6_U_RNI_NID4, 0x35470)
    FIELD(POR_MPU_M1_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR6_U_RNI_NID4, 0x35478)
    FIELD(POR_MPU_M1_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR7_U_RNI_NID4, 0x35480)
    FIELD(POR_MPU_M1_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR7_U_RNI_NID4, 0x35488)
    FIELD(POR_MPU_M1_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR8_U_RNI_NID4, 0x35490)
    FIELD(POR_MPU_M1_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR8_U_RNI_NID4, 0x35498)
    FIELD(POR_MPU_M1_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR9_U_RNI_NID4, 0x354a0)
    FIELD(POR_MPU_M1_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR9_U_RNI_NID4, 0x354a8)
    FIELD(POR_MPU_M1_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR10_U_RNI_NID4, 0x354b0)
    FIELD(POR_MPU_M1_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR10_U_RNI_NID4, 0x354b8)
    FIELD(POR_MPU_M1_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR11_U_RNI_NID4, 0x354c0)
    FIELD(POR_MPU_M1_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR11_U_RNI_NID4, 0x354c8)
    FIELD(POR_MPU_M1_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR12_U_RNI_NID4, 0x354d0)
    FIELD(POR_MPU_M1_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR12_U_RNI_NID4, 0x354d8)
    FIELD(POR_MPU_M1_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR13_U_RNI_NID4, 0x354e0)
    FIELD(POR_MPU_M1_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR13_U_RNI_NID4, 0x354e8)
    FIELD(POR_MPU_M1_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR14_U_RNI_NID4, 0x354f0)
    FIELD(POR_MPU_M1_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR14_U_RNI_NID4, 0x354f8)
    FIELD(POR_MPU_M1_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR15_U_RNI_NID4, 0x35500)
    FIELD(POR_MPU_M1_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR15_U_RNI_NID4, 0x35508)
    FIELD(POR_MPU_M1_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR16_U_RNI_NID4, 0x35510)
    FIELD(POR_MPU_M1_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR16_U_RNI_NID4, 0x35518)
    FIELD(POR_MPU_M1_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR17_U_RNI_NID4, 0x35520)
    FIELD(POR_MPU_M1_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR17_U_RNI_NID4, 0x35528)
    FIELD(POR_MPU_M1_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR18_U_RNI_NID4, 0x35530)
    FIELD(POR_MPU_M1_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR18_U_RNI_NID4, 0x35538)
    FIELD(POR_MPU_M1_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR19_U_RNI_NID4, 0x35540)
    FIELD(POR_MPU_M1_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR19_U_RNI_NID4, 0x35548)
    FIELD(POR_MPU_M1_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR20_U_RNI_NID4, 0x35550)
    FIELD(POR_MPU_M1_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR20_U_RNI_NID4, 0x35558)
    FIELD(POR_MPU_M1_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR21_U_RNI_NID4, 0x35560)
    FIELD(POR_MPU_M1_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR21_U_RNI_NID4, 0x35568)
    FIELD(POR_MPU_M1_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR22_U_RNI_NID4, 0x35570)
    FIELD(POR_MPU_M1_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR22_U_RNI_NID4, 0x35578)
    FIELD(POR_MPU_M1_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR23_U_RNI_NID4, 0x35580)
    FIELD(POR_MPU_M1_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR23_U_RNI_NID4, 0x35588)
    FIELD(POR_MPU_M1_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR24_U_RNI_NID4, 0x35590)
    FIELD(POR_MPU_M1_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR24_U_RNI_NID4, 0x35598)
    FIELD(POR_MPU_M1_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR25_U_RNI_NID4, 0x355a0)
    FIELD(POR_MPU_M1_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR25_U_RNI_NID4, 0x355a8)
    FIELD(POR_MPU_M1_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR26_U_RNI_NID4, 0x355b0)
    FIELD(POR_MPU_M1_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR26_U_RNI_NID4, 0x355b8)
    FIELD(POR_MPU_M1_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR27_U_RNI_NID4, 0x355c0)
    FIELD(POR_MPU_M1_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR27_U_RNI_NID4, 0x355c8)
    FIELD(POR_MPU_M1_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR28_U_RNI_NID4, 0x355d0)
    FIELD(POR_MPU_M1_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR28_U_RNI_NID4, 0x355d8)
    FIELD(POR_MPU_M1_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR29_U_RNI_NID4, 0x355e0)
    FIELD(POR_MPU_M1_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR29_U_RNI_NID4, 0x355e8)
    FIELD(POR_MPU_M1_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR30_U_RNI_NID4, 0x355f0)
    FIELD(POR_MPU_M1_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR30_U_RNI_NID4, 0x355f8)
    FIELD(POR_MPU_M1_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR31_U_RNI_NID4, 0x35600)
    FIELD(POR_MPU_M1_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR31_U_RNI_NID4, 0x35608)
    FIELD(POR_MPU_M1_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M2_CTL_U_RNI_NID4, 0x35800)
    FIELD(POR_MPU_M2_CTL_U_RNI_NID4, M2_EN, 2, 1)
    FIELD(POR_MPU_M2_CTL_U_RNI_NID4, M2_ACTION, 0, 2)
REG32(POR_MPU_M2_PRBAR0_U_RNI_NID4, 0x35810)
    FIELD(POR_MPU_M2_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR0_U_RNI_NID4, 0x35818)
    FIELD(POR_MPU_M2_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR1_U_RNI_NID4, 0x35820)
    FIELD(POR_MPU_M2_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR1_U_RNI_NID4, 0x35828)
    FIELD(POR_MPU_M2_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR2_U_RNI_NID4, 0x35830)
    FIELD(POR_MPU_M2_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR2_U_RNI_NID4, 0x35838)
    FIELD(POR_MPU_M2_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR3_U_RNI_NID4, 0x35840)
    FIELD(POR_MPU_M2_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR3_U_RNI_NID4, 0x35848)
    FIELD(POR_MPU_M2_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR4_U_RNI_NID4, 0x35850)
    FIELD(POR_MPU_M2_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR4_U_RNI_NID4, 0x35858)
    FIELD(POR_MPU_M2_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR5_U_RNI_NID4, 0x35860)
    FIELD(POR_MPU_M2_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR5_U_RNI_NID4, 0x35868)
    FIELD(POR_MPU_M2_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR6_U_RNI_NID4, 0x35870)
    FIELD(POR_MPU_M2_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR6_U_RNI_NID4, 0x35878)
    FIELD(POR_MPU_M2_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR7_U_RNI_NID4, 0x35880)
    FIELD(POR_MPU_M2_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR7_U_RNI_NID4, 0x35888)
    FIELD(POR_MPU_M2_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR8_U_RNI_NID4, 0x35890)
    FIELD(POR_MPU_M2_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR8_U_RNI_NID4, 0x35898)
    FIELD(POR_MPU_M2_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR9_U_RNI_NID4, 0x358a0)
    FIELD(POR_MPU_M2_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR9_U_RNI_NID4, 0x358a8)
    FIELD(POR_MPU_M2_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR10_U_RNI_NID4, 0x358b0)
    FIELD(POR_MPU_M2_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR10_U_RNI_NID4, 0x358b8)
    FIELD(POR_MPU_M2_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR11_U_RNI_NID4, 0x358c0)
    FIELD(POR_MPU_M2_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR11_U_RNI_NID4, 0x358c8)
    FIELD(POR_MPU_M2_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR12_U_RNI_NID4, 0x358d0)
    FIELD(POR_MPU_M2_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR12_U_RNI_NID4, 0x358d8)
    FIELD(POR_MPU_M2_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR13_U_RNI_NID4, 0x358e0)
    FIELD(POR_MPU_M2_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR13_U_RNI_NID4, 0x358e8)
    FIELD(POR_MPU_M2_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR14_U_RNI_NID4, 0x358f0)
    FIELD(POR_MPU_M2_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR14_U_RNI_NID4, 0x358f8)
    FIELD(POR_MPU_M2_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR15_U_RNI_NID4, 0x35900)
    FIELD(POR_MPU_M2_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR15_U_RNI_NID4, 0x35908)
    FIELD(POR_MPU_M2_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR16_U_RNI_NID4, 0x35910)
    FIELD(POR_MPU_M2_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR16_U_RNI_NID4, 0x35918)
    FIELD(POR_MPU_M2_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR17_U_RNI_NID4, 0x35920)
    FIELD(POR_MPU_M2_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR17_U_RNI_NID4, 0x35928)
    FIELD(POR_MPU_M2_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR18_U_RNI_NID4, 0x35930)
    FIELD(POR_MPU_M2_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR18_U_RNI_NID4, 0x35938)
    FIELD(POR_MPU_M2_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR19_U_RNI_NID4, 0x35940)
    FIELD(POR_MPU_M2_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR19_U_RNI_NID4, 0x35948)
    FIELD(POR_MPU_M2_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR20_U_RNI_NID4, 0x35950)
    FIELD(POR_MPU_M2_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR20_U_RNI_NID4, 0x35958)
    FIELD(POR_MPU_M2_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR21_U_RNI_NID4, 0x35960)
    FIELD(POR_MPU_M2_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR21_U_RNI_NID4, 0x35968)
    FIELD(POR_MPU_M2_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR22_U_RNI_NID4, 0x35970)
    FIELD(POR_MPU_M2_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR22_U_RNI_NID4, 0x35978)
    FIELD(POR_MPU_M2_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR23_U_RNI_NID4, 0x35980)
    FIELD(POR_MPU_M2_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR23_U_RNI_NID4, 0x35988)
    FIELD(POR_MPU_M2_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR24_U_RNI_NID4, 0x35990)
    FIELD(POR_MPU_M2_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR24_U_RNI_NID4, 0x35998)
    FIELD(POR_MPU_M2_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR25_U_RNI_NID4, 0x359a0)
    FIELD(POR_MPU_M2_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR25_U_RNI_NID4, 0x359a8)
    FIELD(POR_MPU_M2_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR26_U_RNI_NID4, 0x359b0)
    FIELD(POR_MPU_M2_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR26_U_RNI_NID4, 0x359b8)
    FIELD(POR_MPU_M2_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR27_U_RNI_NID4, 0x359c0)
    FIELD(POR_MPU_M2_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR27_U_RNI_NID4, 0x359c8)
    FIELD(POR_MPU_M2_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR28_U_RNI_NID4, 0x359d0)
    FIELD(POR_MPU_M2_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR28_U_RNI_NID4, 0x359d8)
    FIELD(POR_MPU_M2_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR29_U_RNI_NID4, 0x359e0)
    FIELD(POR_MPU_M2_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR29_U_RNI_NID4, 0x359e8)
    FIELD(POR_MPU_M2_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR30_U_RNI_NID4, 0x359f0)
    FIELD(POR_MPU_M2_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR30_U_RNI_NID4, 0x359f8)
    FIELD(POR_MPU_M2_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR31_U_RNI_NID4, 0x35a00)
    FIELD(POR_MPU_M2_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR31_U_RNI_NID4, 0x35a08)
    FIELD(POR_MPU_M2_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M3_CTL_U_RNI_NID4, 0x35c00)
    FIELD(POR_MPU_M3_CTL_U_RNI_NID4, M3_EN, 2, 1)
    FIELD(POR_MPU_M3_CTL_U_RNI_NID4, M3_ACTION, 0, 2)
REG32(POR_MPU_M3_PRBAR0_U_RNI_NID4, 0x35c10)
    FIELD(POR_MPU_M3_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR0_U_RNI_NID4, 0x35c18)
    FIELD(POR_MPU_M3_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR1_U_RNI_NID4, 0x35c20)
    FIELD(POR_MPU_M3_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR1_U_RNI_NID4, 0x35c28)
    FIELD(POR_MPU_M3_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR2_U_RNI_NID4, 0x35c30)
    FIELD(POR_MPU_M3_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR2_U_RNI_NID4, 0x35c38)
    FIELD(POR_MPU_M3_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR3_U_RNI_NID4, 0x35c40)
    FIELD(POR_MPU_M3_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR3_U_RNI_NID4, 0x35c48)
    FIELD(POR_MPU_M3_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR4_U_RNI_NID4, 0x35c50)
    FIELD(POR_MPU_M3_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR4_U_RNI_NID4, 0x35c58)
    FIELD(POR_MPU_M3_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR5_U_RNI_NID4, 0x35c60)
    FIELD(POR_MPU_M3_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR5_U_RNI_NID4, 0x35c68)
    FIELD(POR_MPU_M3_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR6_U_RNI_NID4, 0x35c70)
    FIELD(POR_MPU_M3_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR6_U_RNI_NID4, 0x35c78)
    FIELD(POR_MPU_M3_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR7_U_RNI_NID4, 0x35c80)
    FIELD(POR_MPU_M3_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR7_U_RNI_NID4, 0x35c88)
    FIELD(POR_MPU_M3_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR8_U_RNI_NID4, 0x35c90)
    FIELD(POR_MPU_M3_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR8_U_RNI_NID4, 0x35c98)
    FIELD(POR_MPU_M3_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR9_U_RNI_NID4, 0x35ca0)
    FIELD(POR_MPU_M3_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR9_U_RNI_NID4, 0x35ca8)
    FIELD(POR_MPU_M3_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR10_U_RNI_NID4, 0x35cb0)
    FIELD(POR_MPU_M3_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR10_U_RNI_NID4, 0x35cb8)
    FIELD(POR_MPU_M3_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR11_U_RNI_NID4, 0x35cc0)
    FIELD(POR_MPU_M3_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR11_U_RNI_NID4, 0x35cc8)
    FIELD(POR_MPU_M3_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR12_U_RNI_NID4, 0x35cd0)
    FIELD(POR_MPU_M3_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR12_U_RNI_NID4, 0x35cd8)
    FIELD(POR_MPU_M3_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR13_U_RNI_NID4, 0x35ce0)
    FIELD(POR_MPU_M3_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR13_U_RNI_NID4, 0x35ce8)
    FIELD(POR_MPU_M3_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR14_U_RNI_NID4, 0x35cf0)
    FIELD(POR_MPU_M3_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR14_U_RNI_NID4, 0x35cf8)
    FIELD(POR_MPU_M3_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR15_U_RNI_NID4, 0x35d00)
    FIELD(POR_MPU_M3_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR15_U_RNI_NID4, 0x35d08)
    FIELD(POR_MPU_M3_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR16_U_RNI_NID4, 0x35d10)
    FIELD(POR_MPU_M3_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR16_U_RNI_NID4, 0x35d18)
    FIELD(POR_MPU_M3_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR17_U_RNI_NID4, 0x35d20)
    FIELD(POR_MPU_M3_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR17_U_RNI_NID4, 0x35d28)
    FIELD(POR_MPU_M3_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR18_U_RNI_NID4, 0x35d30)
    FIELD(POR_MPU_M3_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR18_U_RNI_NID4, 0x35d38)
    FIELD(POR_MPU_M3_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR19_U_RNI_NID4, 0x35d40)
    FIELD(POR_MPU_M3_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR19_U_RNI_NID4, 0x35d48)
    FIELD(POR_MPU_M3_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR20_U_RNI_NID4, 0x35d50)
    FIELD(POR_MPU_M3_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR20_U_RNI_NID4, 0x35d58)
    FIELD(POR_MPU_M3_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR21_U_RNI_NID4, 0x35d60)
    FIELD(POR_MPU_M3_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR21_U_RNI_NID4, 0x35d68)
    FIELD(POR_MPU_M3_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR22_U_RNI_NID4, 0x35d70)
    FIELD(POR_MPU_M3_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR22_U_RNI_NID4, 0x35d78)
    FIELD(POR_MPU_M3_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR23_U_RNI_NID4, 0x35d80)
    FIELD(POR_MPU_M3_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR23_U_RNI_NID4, 0x35d88)
    FIELD(POR_MPU_M3_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR24_U_RNI_NID4, 0x35d90)
    FIELD(POR_MPU_M3_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR24_U_RNI_NID4, 0x35d98)
    FIELD(POR_MPU_M3_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR25_U_RNI_NID4, 0x35da0)
    FIELD(POR_MPU_M3_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR25_U_RNI_NID4, 0x35da8)
    FIELD(POR_MPU_M3_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR26_U_RNI_NID4, 0x35db0)
    FIELD(POR_MPU_M3_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR26_U_RNI_NID4, 0x35db8)
    FIELD(POR_MPU_M3_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR27_U_RNI_NID4, 0x35dc0)
    FIELD(POR_MPU_M3_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR27_U_RNI_NID4, 0x35dc8)
    FIELD(POR_MPU_M3_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR28_U_RNI_NID4, 0x35dd0)
    FIELD(POR_MPU_M3_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR28_U_RNI_NID4, 0x35dd8)
    FIELD(POR_MPU_M3_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR29_U_RNI_NID4, 0x35de0)
    FIELD(POR_MPU_M3_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR29_U_RNI_NID4, 0x35de8)
    FIELD(POR_MPU_M3_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR30_U_RNI_NID4, 0x35df0)
    FIELD(POR_MPU_M3_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR30_U_RNI_NID4, 0x35df8)
    FIELD(POR_MPU_M3_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR31_U_RNI_NID4, 0x35e00)
    FIELD(POR_MPU_M3_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR31_U_RNI_NID4, 0x35e08)
    FIELD(POR_MPU_M3_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M4_CTL_U_RNI_NID4, 0x36000)
    FIELD(POR_MPU_M4_CTL_U_RNI_NID4, M4_EN, 2, 1)
    FIELD(POR_MPU_M4_CTL_U_RNI_NID4, M4_ACTION, 0, 2)
REG32(POR_MPU_M4_PRBAR0_U_RNI_NID4, 0x36010)
    FIELD(POR_MPU_M4_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR0_U_RNI_NID4, 0x36018)
    FIELD(POR_MPU_M4_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR1_U_RNI_NID4, 0x36020)
    FIELD(POR_MPU_M4_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR1_U_RNI_NID4, 0x36028)
    FIELD(POR_MPU_M4_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR2_U_RNI_NID4, 0x36030)
    FIELD(POR_MPU_M4_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR2_U_RNI_NID4, 0x36038)
    FIELD(POR_MPU_M4_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR3_U_RNI_NID4, 0x36040)
    FIELD(POR_MPU_M4_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR3_U_RNI_NID4, 0x36048)
    FIELD(POR_MPU_M4_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR4_U_RNI_NID4, 0x36050)
    FIELD(POR_MPU_M4_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR4_U_RNI_NID4, 0x36058)
    FIELD(POR_MPU_M4_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR5_U_RNI_NID4, 0x36060)
    FIELD(POR_MPU_M4_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR5_U_RNI_NID4, 0x36068)
    FIELD(POR_MPU_M4_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR6_U_RNI_NID4, 0x36070)
    FIELD(POR_MPU_M4_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR6_U_RNI_NID4, 0x36078)
    FIELD(POR_MPU_M4_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR7_U_RNI_NID4, 0x36080)
    FIELD(POR_MPU_M4_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR7_U_RNI_NID4, 0x36088)
    FIELD(POR_MPU_M4_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR8_U_RNI_NID4, 0x36090)
    FIELD(POR_MPU_M4_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR8_U_RNI_NID4, 0x36098)
    FIELD(POR_MPU_M4_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR9_U_RNI_NID4, 0x360a0)
    FIELD(POR_MPU_M4_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR9_U_RNI_NID4, 0x360a8)
    FIELD(POR_MPU_M4_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR10_U_RNI_NID4, 0x360b0)
    FIELD(POR_MPU_M4_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR10_U_RNI_NID4, 0x360b8)
    FIELD(POR_MPU_M4_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR11_U_RNI_NID4, 0x360c0)
    FIELD(POR_MPU_M4_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR11_U_RNI_NID4, 0x360c8)
    FIELD(POR_MPU_M4_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR12_U_RNI_NID4, 0x360d0)
    FIELD(POR_MPU_M4_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR12_U_RNI_NID4, 0x360d8)
    FIELD(POR_MPU_M4_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR13_U_RNI_NID4, 0x360e0)
    FIELD(POR_MPU_M4_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR13_U_RNI_NID4, 0x360e8)
    FIELD(POR_MPU_M4_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR14_U_RNI_NID4, 0x360f0)
    FIELD(POR_MPU_M4_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR14_U_RNI_NID4, 0x360f8)
    FIELD(POR_MPU_M4_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR15_U_RNI_NID4, 0x36100)
    FIELD(POR_MPU_M4_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR15_U_RNI_NID4, 0x36108)
    FIELD(POR_MPU_M4_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR16_U_RNI_NID4, 0x36110)
    FIELD(POR_MPU_M4_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR16_U_RNI_NID4, 0x36118)
    FIELD(POR_MPU_M4_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR17_U_RNI_NID4, 0x36120)
    FIELD(POR_MPU_M4_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR17_U_RNI_NID4, 0x36128)
    FIELD(POR_MPU_M4_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR18_U_RNI_NID4, 0x36130)
    FIELD(POR_MPU_M4_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR18_U_RNI_NID4, 0x36138)
    FIELD(POR_MPU_M4_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR19_U_RNI_NID4, 0x36140)
    FIELD(POR_MPU_M4_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR19_U_RNI_NID4, 0x36148)
    FIELD(POR_MPU_M4_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR20_U_RNI_NID4, 0x36150)
    FIELD(POR_MPU_M4_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR20_U_RNI_NID4, 0x36158)
    FIELD(POR_MPU_M4_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR21_U_RNI_NID4, 0x36160)
    FIELD(POR_MPU_M4_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR21_U_RNI_NID4, 0x36168)
    FIELD(POR_MPU_M4_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR22_U_RNI_NID4, 0x36170)
    FIELD(POR_MPU_M4_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR22_U_RNI_NID4, 0x36178)
    FIELD(POR_MPU_M4_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR23_U_RNI_NID4, 0x36180)
    FIELD(POR_MPU_M4_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR23_U_RNI_NID4, 0x36188)
    FIELD(POR_MPU_M4_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR24_U_RNI_NID4, 0x36190)
    FIELD(POR_MPU_M4_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR24_U_RNI_NID4, 0x36198)
    FIELD(POR_MPU_M4_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR25_U_RNI_NID4, 0x361a0)
    FIELD(POR_MPU_M4_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR25_U_RNI_NID4, 0x361a8)
    FIELD(POR_MPU_M4_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR26_U_RNI_NID4, 0x361b0)
    FIELD(POR_MPU_M4_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR26_U_RNI_NID4, 0x361b8)
    FIELD(POR_MPU_M4_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR27_U_RNI_NID4, 0x361c0)
    FIELD(POR_MPU_M4_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR27_U_RNI_NID4, 0x361c8)
    FIELD(POR_MPU_M4_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR28_U_RNI_NID4, 0x361d0)
    FIELD(POR_MPU_M4_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR28_U_RNI_NID4, 0x361d8)
    FIELD(POR_MPU_M4_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR29_U_RNI_NID4, 0x361e0)
    FIELD(POR_MPU_M4_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR29_U_RNI_NID4, 0x361e8)
    FIELD(POR_MPU_M4_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR30_U_RNI_NID4, 0x361f0)
    FIELD(POR_MPU_M4_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR30_U_RNI_NID4, 0x361f8)
    FIELD(POR_MPU_M4_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR31_U_RNI_NID4, 0x36200)
    FIELD(POR_MPU_M4_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR31_U_RNI_NID4, 0x36208)
    FIELD(POR_MPU_M4_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M5_CTL_U_RNI_NID4, 0x36400)
    FIELD(POR_MPU_M5_CTL_U_RNI_NID4, M5_EN, 2, 1)
    FIELD(POR_MPU_M5_CTL_U_RNI_NID4, M5_ACTION, 0, 2)
REG32(POR_MPU_M5_PRBAR0_U_RNI_NID4, 0x36410)
    FIELD(POR_MPU_M5_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR0_U_RNI_NID4, 0x36418)
    FIELD(POR_MPU_M5_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR1_U_RNI_NID4, 0x36420)
    FIELD(POR_MPU_M5_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR1_U_RNI_NID4, 0x36428)
    FIELD(POR_MPU_M5_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR2_U_RNI_NID4, 0x36430)
    FIELD(POR_MPU_M5_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR2_U_RNI_NID4, 0x36438)
    FIELD(POR_MPU_M5_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR3_U_RNI_NID4, 0x36440)
    FIELD(POR_MPU_M5_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR3_U_RNI_NID4, 0x36448)
    FIELD(POR_MPU_M5_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR4_U_RNI_NID4, 0x36450)
    FIELD(POR_MPU_M5_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR4_U_RNI_NID4, 0x36458)
    FIELD(POR_MPU_M5_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR5_U_RNI_NID4, 0x36460)
    FIELD(POR_MPU_M5_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR5_U_RNI_NID4, 0x36468)
    FIELD(POR_MPU_M5_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR6_U_RNI_NID4, 0x36470)
    FIELD(POR_MPU_M5_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR6_U_RNI_NID4, 0x36478)
    FIELD(POR_MPU_M5_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR7_U_RNI_NID4, 0x36480)
    FIELD(POR_MPU_M5_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR7_U_RNI_NID4, 0x36488)
    FIELD(POR_MPU_M5_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR8_U_RNI_NID4, 0x36490)
    FIELD(POR_MPU_M5_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR8_U_RNI_NID4, 0x36498)
    FIELD(POR_MPU_M5_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR9_U_RNI_NID4, 0x364a0)
    FIELD(POR_MPU_M5_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR9_U_RNI_NID4, 0x364a8)
    FIELD(POR_MPU_M5_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR10_U_RNI_NID4, 0x364b0)
    FIELD(POR_MPU_M5_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR10_U_RNI_NID4, 0x364b8)
    FIELD(POR_MPU_M5_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR11_U_RNI_NID4, 0x364c0)
    FIELD(POR_MPU_M5_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR11_U_RNI_NID4, 0x364c8)
    FIELD(POR_MPU_M5_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR12_U_RNI_NID4, 0x364d0)
    FIELD(POR_MPU_M5_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR12_U_RNI_NID4, 0x364d8)
    FIELD(POR_MPU_M5_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR13_U_RNI_NID4, 0x364e0)
    FIELD(POR_MPU_M5_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR13_U_RNI_NID4, 0x364e8)
    FIELD(POR_MPU_M5_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR14_U_RNI_NID4, 0x364f0)
    FIELD(POR_MPU_M5_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR14_U_RNI_NID4, 0x364f8)
    FIELD(POR_MPU_M5_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR15_U_RNI_NID4, 0x36500)
    FIELD(POR_MPU_M5_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR15_U_RNI_NID4, 0x36508)
    FIELD(POR_MPU_M5_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR16_U_RNI_NID4, 0x36510)
    FIELD(POR_MPU_M5_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR16_U_RNI_NID4, 0x36518)
    FIELD(POR_MPU_M5_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR17_U_RNI_NID4, 0x36520)
    FIELD(POR_MPU_M5_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR17_U_RNI_NID4, 0x36528)
    FIELD(POR_MPU_M5_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR18_U_RNI_NID4, 0x36530)
    FIELD(POR_MPU_M5_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR18_U_RNI_NID4, 0x36538)
    FIELD(POR_MPU_M5_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR19_U_RNI_NID4, 0x36540)
    FIELD(POR_MPU_M5_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR19_U_RNI_NID4, 0x36548)
    FIELD(POR_MPU_M5_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR20_U_RNI_NID4, 0x36550)
    FIELD(POR_MPU_M5_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR20_U_RNI_NID4, 0x36558)
    FIELD(POR_MPU_M5_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR21_U_RNI_NID4, 0x36560)
    FIELD(POR_MPU_M5_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR21_U_RNI_NID4, 0x36568)
    FIELD(POR_MPU_M5_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR22_U_RNI_NID4, 0x36570)
    FIELD(POR_MPU_M5_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR22_U_RNI_NID4, 0x36578)
    FIELD(POR_MPU_M5_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR23_U_RNI_NID4, 0x36580)
    FIELD(POR_MPU_M5_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR23_U_RNI_NID4, 0x36588)
    FIELD(POR_MPU_M5_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR24_U_RNI_NID4, 0x36590)
    FIELD(POR_MPU_M5_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR24_U_RNI_NID4, 0x36598)
    FIELD(POR_MPU_M5_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR25_U_RNI_NID4, 0x365a0)
    FIELD(POR_MPU_M5_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR25_U_RNI_NID4, 0x365a8)
    FIELD(POR_MPU_M5_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR26_U_RNI_NID4, 0x365b0)
    FIELD(POR_MPU_M5_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR26_U_RNI_NID4, 0x365b8)
    FIELD(POR_MPU_M5_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR27_U_RNI_NID4, 0x365c0)
    FIELD(POR_MPU_M5_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR27_U_RNI_NID4, 0x365c8)
    FIELD(POR_MPU_M5_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR28_U_RNI_NID4, 0x365d0)
    FIELD(POR_MPU_M5_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR28_U_RNI_NID4, 0x365d8)
    FIELD(POR_MPU_M5_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR29_U_RNI_NID4, 0x365e0)
    FIELD(POR_MPU_M5_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR29_U_RNI_NID4, 0x365e8)
    FIELD(POR_MPU_M5_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR30_U_RNI_NID4, 0x365f0)
    FIELD(POR_MPU_M5_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR30_U_RNI_NID4, 0x365f8)
    FIELD(POR_MPU_M5_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR31_U_RNI_NID4, 0x36600)
    FIELD(POR_MPU_M5_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR31_U_RNI_NID4, 0x36608)
    FIELD(POR_MPU_M5_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M6_CTL_U_RNI_NID4, 0x36800)
    FIELD(POR_MPU_M6_CTL_U_RNI_NID4, M6_EN, 2, 1)
    FIELD(POR_MPU_M6_CTL_U_RNI_NID4, M6_ACTION, 0, 2)
REG32(POR_MPU_M6_PRBAR0_U_RNI_NID4, 0x36810)
    FIELD(POR_MPU_M6_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR0_U_RNI_NID4, 0x36818)
    FIELD(POR_MPU_M6_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR1_U_RNI_NID4, 0x36820)
    FIELD(POR_MPU_M6_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR1_U_RNI_NID4, 0x36828)
    FIELD(POR_MPU_M6_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR2_U_RNI_NID4, 0x36830)
    FIELD(POR_MPU_M6_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR2_U_RNI_NID4, 0x36838)
    FIELD(POR_MPU_M6_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR3_U_RNI_NID4, 0x36840)
    FIELD(POR_MPU_M6_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR3_U_RNI_NID4, 0x36848)
    FIELD(POR_MPU_M6_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR4_U_RNI_NID4, 0x36850)
    FIELD(POR_MPU_M6_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR4_U_RNI_NID4, 0x36858)
    FIELD(POR_MPU_M6_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR5_U_RNI_NID4, 0x36860)
    FIELD(POR_MPU_M6_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR5_U_RNI_NID4, 0x36868)
    FIELD(POR_MPU_M6_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR6_U_RNI_NID4, 0x36870)
    FIELD(POR_MPU_M6_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR6_U_RNI_NID4, 0x36878)
    FIELD(POR_MPU_M6_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR7_U_RNI_NID4, 0x36880)
    FIELD(POR_MPU_M6_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR7_U_RNI_NID4, 0x36888)
    FIELD(POR_MPU_M6_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR8_U_RNI_NID4, 0x36890)
    FIELD(POR_MPU_M6_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR8_U_RNI_NID4, 0x36898)
    FIELD(POR_MPU_M6_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR9_U_RNI_NID4, 0x368a0)
    FIELD(POR_MPU_M6_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR9_U_RNI_NID4, 0x368a8)
    FIELD(POR_MPU_M6_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR10_U_RNI_NID4, 0x368b0)
    FIELD(POR_MPU_M6_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR10_U_RNI_NID4, 0x368b8)
    FIELD(POR_MPU_M6_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR11_U_RNI_NID4, 0x368c0)
    FIELD(POR_MPU_M6_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR11_U_RNI_NID4, 0x368c8)
    FIELD(POR_MPU_M6_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR12_U_RNI_NID4, 0x368d0)
    FIELD(POR_MPU_M6_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR12_U_RNI_NID4, 0x368d8)
    FIELD(POR_MPU_M6_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR13_U_RNI_NID4, 0x368e0)
    FIELD(POR_MPU_M6_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR13_U_RNI_NID4, 0x368e8)
    FIELD(POR_MPU_M6_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR14_U_RNI_NID4, 0x368f0)
    FIELD(POR_MPU_M6_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR14_U_RNI_NID4, 0x368f8)
    FIELD(POR_MPU_M6_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR15_U_RNI_NID4, 0x36900)
    FIELD(POR_MPU_M6_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR15_U_RNI_NID4, 0x36908)
    FIELD(POR_MPU_M6_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR16_U_RNI_NID4, 0x36910)
    FIELD(POR_MPU_M6_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR16_U_RNI_NID4, 0x36918)
    FIELD(POR_MPU_M6_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR17_U_RNI_NID4, 0x36920)
    FIELD(POR_MPU_M6_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR17_U_RNI_NID4, 0x36928)
    FIELD(POR_MPU_M6_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR18_U_RNI_NID4, 0x36930)
    FIELD(POR_MPU_M6_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR18_U_RNI_NID4, 0x36938)
    FIELD(POR_MPU_M6_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR19_U_RNI_NID4, 0x36940)
    FIELD(POR_MPU_M6_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR19_U_RNI_NID4, 0x36948)
    FIELD(POR_MPU_M6_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR20_U_RNI_NID4, 0x36950)
    FIELD(POR_MPU_M6_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR20_U_RNI_NID4, 0x36958)
    FIELD(POR_MPU_M6_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR21_U_RNI_NID4, 0x36960)
    FIELD(POR_MPU_M6_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR21_U_RNI_NID4, 0x36968)
    FIELD(POR_MPU_M6_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR22_U_RNI_NID4, 0x36970)
    FIELD(POR_MPU_M6_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR22_U_RNI_NID4, 0x36978)
    FIELD(POR_MPU_M6_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR23_U_RNI_NID4, 0x36980)
    FIELD(POR_MPU_M6_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR23_U_RNI_NID4, 0x36988)
    FIELD(POR_MPU_M6_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR24_U_RNI_NID4, 0x36990)
    FIELD(POR_MPU_M6_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR24_U_RNI_NID4, 0x36998)
    FIELD(POR_MPU_M6_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR25_U_RNI_NID4, 0x369a0)
    FIELD(POR_MPU_M6_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR25_U_RNI_NID4, 0x369a8)
    FIELD(POR_MPU_M6_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR26_U_RNI_NID4, 0x369b0)
    FIELD(POR_MPU_M6_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR26_U_RNI_NID4, 0x369b8)
    FIELD(POR_MPU_M6_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR27_U_RNI_NID4, 0x369c0)
    FIELD(POR_MPU_M6_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR27_U_RNI_NID4, 0x369c8)
    FIELD(POR_MPU_M6_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR28_U_RNI_NID4, 0x369d0)
    FIELD(POR_MPU_M6_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR28_U_RNI_NID4, 0x369d8)
    FIELD(POR_MPU_M6_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR29_U_RNI_NID4, 0x369e0)
    FIELD(POR_MPU_M6_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR29_U_RNI_NID4, 0x369e8)
    FIELD(POR_MPU_M6_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR30_U_RNI_NID4, 0x369f0)
    FIELD(POR_MPU_M6_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR30_U_RNI_NID4, 0x369f8)
    FIELD(POR_MPU_M6_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR31_U_RNI_NID4, 0x36a00)
    FIELD(POR_MPU_M6_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR31_U_RNI_NID4, 0x36a08)
    FIELD(POR_MPU_M6_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_M7_CTL_U_RNI_NID4, 0x36c00)
    FIELD(POR_MPU_M7_CTL_U_RNI_NID4, M7_EN, 2, 1)
    FIELD(POR_MPU_M7_CTL_U_RNI_NID4, M7_ACTION, 0, 2)
REG32(POR_MPU_M7_PRBAR0_U_RNI_NID4, 0x36c10)
    FIELD(POR_MPU_M7_PRBAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR0_U_RNI_NID4, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR0_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR0_U_RNI_NID4, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR0_U_RNI_NID4, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR0_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR0_U_RNI_NID4, 0x36c18)
    FIELD(POR_MPU_M7_PRLAR0_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR0_U_RNI_NID4, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR0_U_RNI_NID4, REGION0_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR1_U_RNI_NID4, 0x36c20)
    FIELD(POR_MPU_M7_PRBAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR1_U_RNI_NID4, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR1_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR1_U_RNI_NID4, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR1_U_RNI_NID4, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR1_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR1_U_RNI_NID4, 0x36c28)
    FIELD(POR_MPU_M7_PRLAR1_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR1_U_RNI_NID4, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR1_U_RNI_NID4, REGION1_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR2_U_RNI_NID4, 0x36c30)
    FIELD(POR_MPU_M7_PRBAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR2_U_RNI_NID4, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR2_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR2_U_RNI_NID4, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR2_U_RNI_NID4, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR2_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR2_U_RNI_NID4, 0x36c38)
    FIELD(POR_MPU_M7_PRLAR2_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR2_U_RNI_NID4, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR2_U_RNI_NID4, REGION2_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR3_U_RNI_NID4, 0x36c40)
    FIELD(POR_MPU_M7_PRBAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR3_U_RNI_NID4, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR3_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR3_U_RNI_NID4, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR3_U_RNI_NID4, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR3_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR3_U_RNI_NID4, 0x36c48)
    FIELD(POR_MPU_M7_PRLAR3_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR3_U_RNI_NID4, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR3_U_RNI_NID4, REGION3_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR4_U_RNI_NID4, 0x36c50)
    FIELD(POR_MPU_M7_PRBAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR4_U_RNI_NID4, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR4_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR4_U_RNI_NID4, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR4_U_RNI_NID4, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR4_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR4_U_RNI_NID4, 0x36c58)
    FIELD(POR_MPU_M7_PRLAR4_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR4_U_RNI_NID4, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR4_U_RNI_NID4, REGION4_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR5_U_RNI_NID4, 0x36c60)
    FIELD(POR_MPU_M7_PRBAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR5_U_RNI_NID4, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR5_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR5_U_RNI_NID4, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR5_U_RNI_NID4, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR5_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR5_U_RNI_NID4, 0x36c68)
    FIELD(POR_MPU_M7_PRLAR5_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR5_U_RNI_NID4, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR5_U_RNI_NID4, REGION5_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR6_U_RNI_NID4, 0x36c70)
    FIELD(POR_MPU_M7_PRBAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR6_U_RNI_NID4, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR6_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR6_U_RNI_NID4, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR6_U_RNI_NID4, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR6_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR6_U_RNI_NID4, 0x36c78)
    FIELD(POR_MPU_M7_PRLAR6_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR6_U_RNI_NID4, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR6_U_RNI_NID4, REGION6_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR7_U_RNI_NID4, 0x36c80)
    FIELD(POR_MPU_M7_PRBAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR7_U_RNI_NID4, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR7_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR7_U_RNI_NID4, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR7_U_RNI_NID4, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR7_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR7_U_RNI_NID4, 0x36c88)
    FIELD(POR_MPU_M7_PRLAR7_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR7_U_RNI_NID4, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR7_U_RNI_NID4, REGION7_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR8_U_RNI_NID4, 0x36c90)
    FIELD(POR_MPU_M7_PRBAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR8_U_RNI_NID4, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR8_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR8_U_RNI_NID4, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR8_U_RNI_NID4, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR8_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR8_U_RNI_NID4, 0x36c98)
    FIELD(POR_MPU_M7_PRLAR8_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR8_U_RNI_NID4, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR8_U_RNI_NID4, REGION8_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR9_U_RNI_NID4, 0x36ca0)
    FIELD(POR_MPU_M7_PRBAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR9_U_RNI_NID4, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR9_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR9_U_RNI_NID4, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR9_U_RNI_NID4, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR9_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR9_U_RNI_NID4, 0x36ca8)
    FIELD(POR_MPU_M7_PRLAR9_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR9_U_RNI_NID4, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR9_U_RNI_NID4, REGION9_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR10_U_RNI_NID4, 0x36cb0)
    FIELD(POR_MPU_M7_PRBAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR10_U_RNI_NID4, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR10_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR10_U_RNI_NID4, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR10_U_RNI_NID4, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR10_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR10_U_RNI_NID4, 0x36cb8)
    FIELD(POR_MPU_M7_PRLAR10_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR10_U_RNI_NID4, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR10_U_RNI_NID4, REGION10_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR11_U_RNI_NID4, 0x36cc0)
    FIELD(POR_MPU_M7_PRBAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR11_U_RNI_NID4, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR11_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR11_U_RNI_NID4, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR11_U_RNI_NID4, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR11_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR11_U_RNI_NID4, 0x36cc8)
    FIELD(POR_MPU_M7_PRLAR11_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR11_U_RNI_NID4, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR11_U_RNI_NID4, REGION11_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR12_U_RNI_NID4, 0x36cd0)
    FIELD(POR_MPU_M7_PRBAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR12_U_RNI_NID4, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR12_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR12_U_RNI_NID4, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR12_U_RNI_NID4, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR12_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR12_U_RNI_NID4, 0x36cd8)
    FIELD(POR_MPU_M7_PRLAR12_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR12_U_RNI_NID4, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR12_U_RNI_NID4, REGION12_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR13_U_RNI_NID4, 0x36ce0)
    FIELD(POR_MPU_M7_PRBAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR13_U_RNI_NID4, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR13_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR13_U_RNI_NID4, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR13_U_RNI_NID4, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR13_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR13_U_RNI_NID4, 0x36ce8)
    FIELD(POR_MPU_M7_PRLAR13_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR13_U_RNI_NID4, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR13_U_RNI_NID4, REGION13_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR14_U_RNI_NID4, 0x36cf0)
    FIELD(POR_MPU_M7_PRBAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR14_U_RNI_NID4, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR14_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR14_U_RNI_NID4, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR14_U_RNI_NID4, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR14_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR14_U_RNI_NID4, 0x36cf8)
    FIELD(POR_MPU_M7_PRLAR14_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR14_U_RNI_NID4, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR14_U_RNI_NID4, REGION14_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR15_U_RNI_NID4, 0x36d00)
    FIELD(POR_MPU_M7_PRBAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR15_U_RNI_NID4, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR15_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR15_U_RNI_NID4, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR15_U_RNI_NID4, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR15_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR15_U_RNI_NID4, 0x36d08)
    FIELD(POR_MPU_M7_PRLAR15_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR15_U_RNI_NID4, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR15_U_RNI_NID4, REGION15_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR16_U_RNI_NID4, 0x36d10)
    FIELD(POR_MPU_M7_PRBAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR16_U_RNI_NID4, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR16_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR16_U_RNI_NID4, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR16_U_RNI_NID4, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR16_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR16_U_RNI_NID4, 0x36d18)
    FIELD(POR_MPU_M7_PRLAR16_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR16_U_RNI_NID4, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR16_U_RNI_NID4, REGION16_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR17_U_RNI_NID4, 0x36d20)
    FIELD(POR_MPU_M7_PRBAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR17_U_RNI_NID4, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR17_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR17_U_RNI_NID4, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR17_U_RNI_NID4, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR17_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR17_U_RNI_NID4, 0x36d28)
    FIELD(POR_MPU_M7_PRLAR17_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR17_U_RNI_NID4, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR17_U_RNI_NID4, REGION17_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR18_U_RNI_NID4, 0x36d30)
    FIELD(POR_MPU_M7_PRBAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR18_U_RNI_NID4, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR18_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR18_U_RNI_NID4, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR18_U_RNI_NID4, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR18_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR18_U_RNI_NID4, 0x36d38)
    FIELD(POR_MPU_M7_PRLAR18_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR18_U_RNI_NID4, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR18_U_RNI_NID4, REGION18_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR19_U_RNI_NID4, 0x36d40)
    FIELD(POR_MPU_M7_PRBAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR19_U_RNI_NID4, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR19_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR19_U_RNI_NID4, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR19_U_RNI_NID4, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR19_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR19_U_RNI_NID4, 0x36d48)
    FIELD(POR_MPU_M7_PRLAR19_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR19_U_RNI_NID4, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR19_U_RNI_NID4, REGION19_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR20_U_RNI_NID4, 0x36d50)
    FIELD(POR_MPU_M7_PRBAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR20_U_RNI_NID4, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR20_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR20_U_RNI_NID4, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR20_U_RNI_NID4, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR20_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR20_U_RNI_NID4, 0x36d58)
    FIELD(POR_MPU_M7_PRLAR20_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR20_U_RNI_NID4, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR20_U_RNI_NID4, REGION20_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR21_U_RNI_NID4, 0x36d60)
    FIELD(POR_MPU_M7_PRBAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR21_U_RNI_NID4, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR21_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR21_U_RNI_NID4, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR21_U_RNI_NID4, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR21_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR21_U_RNI_NID4, 0x36d68)
    FIELD(POR_MPU_M7_PRLAR21_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR21_U_RNI_NID4, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR21_U_RNI_NID4, REGION21_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR22_U_RNI_NID4, 0x36d70)
    FIELD(POR_MPU_M7_PRBAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR22_U_RNI_NID4, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR22_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR22_U_RNI_NID4, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR22_U_RNI_NID4, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR22_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR22_U_RNI_NID4, 0x36d78)
    FIELD(POR_MPU_M7_PRLAR22_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR22_U_RNI_NID4, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR22_U_RNI_NID4, REGION22_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR23_U_RNI_NID4, 0x36d80)
    FIELD(POR_MPU_M7_PRBAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR23_U_RNI_NID4, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR23_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR23_U_RNI_NID4, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR23_U_RNI_NID4, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR23_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR23_U_RNI_NID4, 0x36d88)
    FIELD(POR_MPU_M7_PRLAR23_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR23_U_RNI_NID4, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR23_U_RNI_NID4, REGION23_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR24_U_RNI_NID4, 0x36d90)
    FIELD(POR_MPU_M7_PRBAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR24_U_RNI_NID4, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR24_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR24_U_RNI_NID4, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR24_U_RNI_NID4, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR24_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR24_U_RNI_NID4, 0x36d98)
    FIELD(POR_MPU_M7_PRLAR24_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR24_U_RNI_NID4, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR24_U_RNI_NID4, REGION24_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR25_U_RNI_NID4, 0x36da0)
    FIELD(POR_MPU_M7_PRBAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR25_U_RNI_NID4, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR25_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR25_U_RNI_NID4, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR25_U_RNI_NID4, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR25_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR25_U_RNI_NID4, 0x36da8)
    FIELD(POR_MPU_M7_PRLAR25_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR25_U_RNI_NID4, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR25_U_RNI_NID4, REGION25_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR26_U_RNI_NID4, 0x36db0)
    FIELD(POR_MPU_M7_PRBAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR26_U_RNI_NID4, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR26_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR26_U_RNI_NID4, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR26_U_RNI_NID4, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR26_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR26_U_RNI_NID4, 0x36db8)
    FIELD(POR_MPU_M7_PRLAR26_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR26_U_RNI_NID4, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR26_U_RNI_NID4, REGION26_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR27_U_RNI_NID4, 0x36dc0)
    FIELD(POR_MPU_M7_PRBAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR27_U_RNI_NID4, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR27_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR27_U_RNI_NID4, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR27_U_RNI_NID4, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR27_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR27_U_RNI_NID4, 0x36dc8)
    FIELD(POR_MPU_M7_PRLAR27_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR27_U_RNI_NID4, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR27_U_RNI_NID4, REGION27_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR28_U_RNI_NID4, 0x36dd0)
    FIELD(POR_MPU_M7_PRBAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR28_U_RNI_NID4, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR28_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR28_U_RNI_NID4, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR28_U_RNI_NID4, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR28_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR28_U_RNI_NID4, 0x36dd8)
    FIELD(POR_MPU_M7_PRLAR28_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR28_U_RNI_NID4, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR28_U_RNI_NID4, REGION28_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR29_U_RNI_NID4, 0x36de0)
    FIELD(POR_MPU_M7_PRBAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR29_U_RNI_NID4, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR29_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR29_U_RNI_NID4, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR29_U_RNI_NID4, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR29_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR29_U_RNI_NID4, 0x36de8)
    FIELD(POR_MPU_M7_PRLAR29_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR29_U_RNI_NID4, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR29_U_RNI_NID4, REGION29_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR30_U_RNI_NID4, 0x36df0)
    FIELD(POR_MPU_M7_PRBAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR30_U_RNI_NID4, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR30_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR30_U_RNI_NID4, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR30_U_RNI_NID4, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR30_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR30_U_RNI_NID4, 0x36df8)
    FIELD(POR_MPU_M7_PRLAR30_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR30_U_RNI_NID4, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR30_U_RNI_NID4, REGION30_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR31_U_RNI_NID4, 0x36e00)
    FIELD(POR_MPU_M7_PRBAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR31_U_RNI_NID4, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR31_U_RNI_NID4, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR31_U_RNI_NID4, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR31_U_RNI_NID4, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR31_U_RNI_NID4, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR31_U_RNI_NID4, 0x36e08)
    FIELD(POR_MPU_M7_PRLAR31_U_RNI_NID4, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR31_U_RNI_NID4, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR31_U_RNI_NID4, REGION31_EN, 0, 1)
REG32(POR_MPU_NODE_INFO_U_SMXP_0_0, 0x3c000)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_0, LOGICAL_ID, 32, 16)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_0, NODE_ID, 16, 16)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_0, NODE_TYPE, 0, 16)
REG32(POR_MPU_CHILD_INFO_U_SMXP_0_0, 0x3c080)
    FIELD(POR_MPU_CHILD_INFO_U_SMXP_0_0, RESERVED_32, 32, 32)
    FIELD(POR_MPU_CHILD_INFO_U_SMXP_0_0, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MPU_CHILD_INFO_U_SMXP_0_0, CHILD_COUNT, 0, 16)
REG32(POR_MPU_UNIT_INFO_U_SMXP_0_0, 0x3c900)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, RESERVED_16, 16, 48)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_7_PRESENT, 15, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_6_PRESENT, 14, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_5_PRESENT, 13, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_4_PRESENT, 12, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_3_PRESENT, 11, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_2_PRESENT, 10, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_1_PRESENT, 9, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, MASTER_0_PRESENT, 8, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_0, NUM_PROG_REGION, 0, 8)
REG32(POR_MPU_M0_CTL_U_SMXP_0_0, 0x3d000)
    FIELD(POR_MPU_M0_CTL_U_SMXP_0_0, M0_EN, 2, 1)
    FIELD(POR_MPU_M0_CTL_U_SMXP_0_0, M0_ACTION, 0, 2)
REG32(POR_MPU_M0_PRBAR0_U_SMXP_0_0, 0x3d010)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR0_U_SMXP_0_0, 0x3d018)
    FIELD(POR_MPU_M0_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR1_U_SMXP_0_0, 0x3d020)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR1_U_SMXP_0_0, 0x3d028)
    FIELD(POR_MPU_M0_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR2_U_SMXP_0_0, 0x3d030)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR2_U_SMXP_0_0, 0x3d038)
    FIELD(POR_MPU_M0_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR3_U_SMXP_0_0, 0x3d040)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR3_U_SMXP_0_0, 0x3d048)
    FIELD(POR_MPU_M0_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR4_U_SMXP_0_0, 0x3d050)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR4_U_SMXP_0_0, 0x3d058)
    FIELD(POR_MPU_M0_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR5_U_SMXP_0_0, 0x3d060)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR5_U_SMXP_0_0, 0x3d068)
    FIELD(POR_MPU_M0_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR6_U_SMXP_0_0, 0x3d070)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR6_U_SMXP_0_0, 0x3d078)
    FIELD(POR_MPU_M0_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR7_U_SMXP_0_0, 0x3d080)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR7_U_SMXP_0_0, 0x3d088)
    FIELD(POR_MPU_M0_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR8_U_SMXP_0_0, 0x3d090)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR8_U_SMXP_0_0, 0x3d098)
    FIELD(POR_MPU_M0_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR9_U_SMXP_0_0, 0x3d0a0)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR9_U_SMXP_0_0, 0x3d0a8)
    FIELD(POR_MPU_M0_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR10_U_SMXP_0_0, 0x3d0b0)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR10_U_SMXP_0_0, 0x3d0b8)
    FIELD(POR_MPU_M0_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR11_U_SMXP_0_0, 0x3d0c0)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR11_U_SMXP_0_0, 0x3d0c8)
    FIELD(POR_MPU_M0_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR12_U_SMXP_0_0, 0x3d0d0)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR12_U_SMXP_0_0, 0x3d0d8)
    FIELD(POR_MPU_M0_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR13_U_SMXP_0_0, 0x3d0e0)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR13_U_SMXP_0_0, 0x3d0e8)
    FIELD(POR_MPU_M0_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR14_U_SMXP_0_0, 0x3d0f0)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR14_U_SMXP_0_0, 0x3d0f8)
    FIELD(POR_MPU_M0_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR15_U_SMXP_0_0, 0x3d100)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR15_U_SMXP_0_0, 0x3d108)
    FIELD(POR_MPU_M0_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR16_U_SMXP_0_0, 0x3d110)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR16_U_SMXP_0_0, 0x3d118)
    FIELD(POR_MPU_M0_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR17_U_SMXP_0_0, 0x3d120)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR17_U_SMXP_0_0, 0x3d128)
    FIELD(POR_MPU_M0_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR18_U_SMXP_0_0, 0x3d130)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR18_U_SMXP_0_0, 0x3d138)
    FIELD(POR_MPU_M0_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR19_U_SMXP_0_0, 0x3d140)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR19_U_SMXP_0_0, 0x3d148)
    FIELD(POR_MPU_M0_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR20_U_SMXP_0_0, 0x3d150)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR20_U_SMXP_0_0, 0x3d158)
    FIELD(POR_MPU_M0_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR21_U_SMXP_0_0, 0x3d160)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR21_U_SMXP_0_0, 0x3d168)
    FIELD(POR_MPU_M0_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR22_U_SMXP_0_0, 0x3d170)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR22_U_SMXP_0_0, 0x3d178)
    FIELD(POR_MPU_M0_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR23_U_SMXP_0_0, 0x3d180)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR23_U_SMXP_0_0, 0x3d188)
    FIELD(POR_MPU_M0_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR24_U_SMXP_0_0, 0x3d190)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR24_U_SMXP_0_0, 0x3d198)
    FIELD(POR_MPU_M0_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR25_U_SMXP_0_0, 0x3d1a0)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR25_U_SMXP_0_0, 0x3d1a8)
    FIELD(POR_MPU_M0_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR26_U_SMXP_0_0, 0x3d1b0)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR26_U_SMXP_0_0, 0x3d1b8)
    FIELD(POR_MPU_M0_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR27_U_SMXP_0_0, 0x3d1c0)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR27_U_SMXP_0_0, 0x3d1c8)
    FIELD(POR_MPU_M0_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR28_U_SMXP_0_0, 0x3d1d0)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR28_U_SMXP_0_0, 0x3d1d8)
    FIELD(POR_MPU_M0_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR29_U_SMXP_0_0, 0x3d1e0)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR29_U_SMXP_0_0, 0x3d1e8)
    FIELD(POR_MPU_M0_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR30_U_SMXP_0_0, 0x3d1f0)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR30_U_SMXP_0_0, 0x3d1f8)
    FIELD(POR_MPU_M0_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR31_U_SMXP_0_0, 0x3d200)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR31_U_SMXP_0_0, 0x3d208)
    FIELD(POR_MPU_M0_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M1_CTL_U_SMXP_0_0, 0x3d400)
    FIELD(POR_MPU_M1_CTL_U_SMXP_0_0, M1_EN, 2, 1)
    FIELD(POR_MPU_M1_CTL_U_SMXP_0_0, M1_ACTION, 0, 2)
REG32(POR_MPU_M1_PRBAR0_U_SMXP_0_0, 0x3d410)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR0_U_SMXP_0_0, 0x3d418)
    FIELD(POR_MPU_M1_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR1_U_SMXP_0_0, 0x3d420)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR1_U_SMXP_0_0, 0x3d428)
    FIELD(POR_MPU_M1_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR2_U_SMXP_0_0, 0x3d430)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR2_U_SMXP_0_0, 0x3d438)
    FIELD(POR_MPU_M1_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR3_U_SMXP_0_0, 0x3d440)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR3_U_SMXP_0_0, 0x3d448)
    FIELD(POR_MPU_M1_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR4_U_SMXP_0_0, 0x3d450)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR4_U_SMXP_0_0, 0x3d458)
    FIELD(POR_MPU_M1_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR5_U_SMXP_0_0, 0x3d460)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR5_U_SMXP_0_0, 0x3d468)
    FIELD(POR_MPU_M1_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR6_U_SMXP_0_0, 0x3d470)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR6_U_SMXP_0_0, 0x3d478)
    FIELD(POR_MPU_M1_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR7_U_SMXP_0_0, 0x3d480)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR7_U_SMXP_0_0, 0x3d488)
    FIELD(POR_MPU_M1_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR8_U_SMXP_0_0, 0x3d490)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR8_U_SMXP_0_0, 0x3d498)
    FIELD(POR_MPU_M1_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR9_U_SMXP_0_0, 0x3d4a0)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR9_U_SMXP_0_0, 0x3d4a8)
    FIELD(POR_MPU_M1_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR10_U_SMXP_0_0, 0x3d4b0)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR10_U_SMXP_0_0, 0x3d4b8)
    FIELD(POR_MPU_M1_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR11_U_SMXP_0_0, 0x3d4c0)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR11_U_SMXP_0_0, 0x3d4c8)
    FIELD(POR_MPU_M1_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR12_U_SMXP_0_0, 0x3d4d0)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR12_U_SMXP_0_0, 0x3d4d8)
    FIELD(POR_MPU_M1_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR13_U_SMXP_0_0, 0x3d4e0)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR13_U_SMXP_0_0, 0x3d4e8)
    FIELD(POR_MPU_M1_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR14_U_SMXP_0_0, 0x3d4f0)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR14_U_SMXP_0_0, 0x3d4f8)
    FIELD(POR_MPU_M1_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR15_U_SMXP_0_0, 0x3d500)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR15_U_SMXP_0_0, 0x3d508)
    FIELD(POR_MPU_M1_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR16_U_SMXP_0_0, 0x3d510)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR16_U_SMXP_0_0, 0x3d518)
    FIELD(POR_MPU_M1_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR17_U_SMXP_0_0, 0x3d520)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR17_U_SMXP_0_0, 0x3d528)
    FIELD(POR_MPU_M1_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR18_U_SMXP_0_0, 0x3d530)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR18_U_SMXP_0_0, 0x3d538)
    FIELD(POR_MPU_M1_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR19_U_SMXP_0_0, 0x3d540)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR19_U_SMXP_0_0, 0x3d548)
    FIELD(POR_MPU_M1_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR20_U_SMXP_0_0, 0x3d550)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR20_U_SMXP_0_0, 0x3d558)
    FIELD(POR_MPU_M1_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR21_U_SMXP_0_0, 0x3d560)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR21_U_SMXP_0_0, 0x3d568)
    FIELD(POR_MPU_M1_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR22_U_SMXP_0_0, 0x3d570)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR22_U_SMXP_0_0, 0x3d578)
    FIELD(POR_MPU_M1_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR23_U_SMXP_0_0, 0x3d580)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR23_U_SMXP_0_0, 0x3d588)
    FIELD(POR_MPU_M1_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR24_U_SMXP_0_0, 0x3d590)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR24_U_SMXP_0_0, 0x3d598)
    FIELD(POR_MPU_M1_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR25_U_SMXP_0_0, 0x3d5a0)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR25_U_SMXP_0_0, 0x3d5a8)
    FIELD(POR_MPU_M1_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR26_U_SMXP_0_0, 0x3d5b0)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR26_U_SMXP_0_0, 0x3d5b8)
    FIELD(POR_MPU_M1_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR27_U_SMXP_0_0, 0x3d5c0)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR27_U_SMXP_0_0, 0x3d5c8)
    FIELD(POR_MPU_M1_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR28_U_SMXP_0_0, 0x3d5d0)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR28_U_SMXP_0_0, 0x3d5d8)
    FIELD(POR_MPU_M1_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR29_U_SMXP_0_0, 0x3d5e0)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR29_U_SMXP_0_0, 0x3d5e8)
    FIELD(POR_MPU_M1_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR30_U_SMXP_0_0, 0x3d5f0)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR30_U_SMXP_0_0, 0x3d5f8)
    FIELD(POR_MPU_M1_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR31_U_SMXP_0_0, 0x3d600)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR31_U_SMXP_0_0, 0x3d608)
    FIELD(POR_MPU_M1_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M2_CTL_U_SMXP_0_0, 0x3d800)
    FIELD(POR_MPU_M2_CTL_U_SMXP_0_0, M2_EN, 2, 1)
    FIELD(POR_MPU_M2_CTL_U_SMXP_0_0, M2_ACTION, 0, 2)
REG32(POR_MPU_M2_PRBAR0_U_SMXP_0_0, 0x3d810)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR0_U_SMXP_0_0, 0x3d818)
    FIELD(POR_MPU_M2_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR1_U_SMXP_0_0, 0x3d820)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR1_U_SMXP_0_0, 0x3d828)
    FIELD(POR_MPU_M2_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR2_U_SMXP_0_0, 0x3d830)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR2_U_SMXP_0_0, 0x3d838)
    FIELD(POR_MPU_M2_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR3_U_SMXP_0_0, 0x3d840)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR3_U_SMXP_0_0, 0x3d848)
    FIELD(POR_MPU_M2_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR4_U_SMXP_0_0, 0x3d850)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR4_U_SMXP_0_0, 0x3d858)
    FIELD(POR_MPU_M2_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR5_U_SMXP_0_0, 0x3d860)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR5_U_SMXP_0_0, 0x3d868)
    FIELD(POR_MPU_M2_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR6_U_SMXP_0_0, 0x3d870)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR6_U_SMXP_0_0, 0x3d878)
    FIELD(POR_MPU_M2_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR7_U_SMXP_0_0, 0x3d880)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR7_U_SMXP_0_0, 0x3d888)
    FIELD(POR_MPU_M2_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR8_U_SMXP_0_0, 0x3d890)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR8_U_SMXP_0_0, 0x3d898)
    FIELD(POR_MPU_M2_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR9_U_SMXP_0_0, 0x3d8a0)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR9_U_SMXP_0_0, 0x3d8a8)
    FIELD(POR_MPU_M2_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR10_U_SMXP_0_0, 0x3d8b0)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR10_U_SMXP_0_0, 0x3d8b8)
    FIELD(POR_MPU_M2_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR11_U_SMXP_0_0, 0x3d8c0)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR11_U_SMXP_0_0, 0x3d8c8)
    FIELD(POR_MPU_M2_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR12_U_SMXP_0_0, 0x3d8d0)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR12_U_SMXP_0_0, 0x3d8d8)
    FIELD(POR_MPU_M2_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR13_U_SMXP_0_0, 0x3d8e0)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR13_U_SMXP_0_0, 0x3d8e8)
    FIELD(POR_MPU_M2_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR14_U_SMXP_0_0, 0x3d8f0)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR14_U_SMXP_0_0, 0x3d8f8)
    FIELD(POR_MPU_M2_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR15_U_SMXP_0_0, 0x3d900)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR15_U_SMXP_0_0, 0x3d908)
    FIELD(POR_MPU_M2_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR16_U_SMXP_0_0, 0x3d910)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR16_U_SMXP_0_0, 0x3d918)
    FIELD(POR_MPU_M2_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR17_U_SMXP_0_0, 0x3d920)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR17_U_SMXP_0_0, 0x3d928)
    FIELD(POR_MPU_M2_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR18_U_SMXP_0_0, 0x3d930)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR18_U_SMXP_0_0, 0x3d938)
    FIELD(POR_MPU_M2_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR19_U_SMXP_0_0, 0x3d940)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR19_U_SMXP_0_0, 0x3d948)
    FIELD(POR_MPU_M2_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR20_U_SMXP_0_0, 0x3d950)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR20_U_SMXP_0_0, 0x3d958)
    FIELD(POR_MPU_M2_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR21_U_SMXP_0_0, 0x3d960)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR21_U_SMXP_0_0, 0x3d968)
    FIELD(POR_MPU_M2_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR22_U_SMXP_0_0, 0x3d970)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR22_U_SMXP_0_0, 0x3d978)
    FIELD(POR_MPU_M2_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR23_U_SMXP_0_0, 0x3d980)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR23_U_SMXP_0_0, 0x3d988)
    FIELD(POR_MPU_M2_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR24_U_SMXP_0_0, 0x3d990)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR24_U_SMXP_0_0, 0x3d998)
    FIELD(POR_MPU_M2_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR25_U_SMXP_0_0, 0x3d9a0)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR25_U_SMXP_0_0, 0x3d9a8)
    FIELD(POR_MPU_M2_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR26_U_SMXP_0_0, 0x3d9b0)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR26_U_SMXP_0_0, 0x3d9b8)
    FIELD(POR_MPU_M2_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR27_U_SMXP_0_0, 0x3d9c0)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR27_U_SMXP_0_0, 0x3d9c8)
    FIELD(POR_MPU_M2_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR28_U_SMXP_0_0, 0x3d9d0)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR28_U_SMXP_0_0, 0x3d9d8)
    FIELD(POR_MPU_M2_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR29_U_SMXP_0_0, 0x3d9e0)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR29_U_SMXP_0_0, 0x3d9e8)
    FIELD(POR_MPU_M2_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR30_U_SMXP_0_0, 0x3d9f0)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR30_U_SMXP_0_0, 0x3d9f8)
    FIELD(POR_MPU_M2_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR31_U_SMXP_0_0, 0x3da00)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR31_U_SMXP_0_0, 0x3da08)
    FIELD(POR_MPU_M2_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M3_CTL_U_SMXP_0_0, 0x3dc00)
    FIELD(POR_MPU_M3_CTL_U_SMXP_0_0, M3_EN, 2, 1)
    FIELD(POR_MPU_M3_CTL_U_SMXP_0_0, M3_ACTION, 0, 2)
REG32(POR_MPU_M3_PRBAR0_U_SMXP_0_0, 0x3dc10)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR0_U_SMXP_0_0, 0x3dc18)
    FIELD(POR_MPU_M3_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR1_U_SMXP_0_0, 0x3dc20)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR1_U_SMXP_0_0, 0x3dc28)
    FIELD(POR_MPU_M3_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR2_U_SMXP_0_0, 0x3dc30)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR2_U_SMXP_0_0, 0x3dc38)
    FIELD(POR_MPU_M3_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR3_U_SMXP_0_0, 0x3dc40)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR3_U_SMXP_0_0, 0x3dc48)
    FIELD(POR_MPU_M3_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR4_U_SMXP_0_0, 0x3dc50)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR4_U_SMXP_0_0, 0x3dc58)
    FIELD(POR_MPU_M3_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR5_U_SMXP_0_0, 0x3dc60)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR5_U_SMXP_0_0, 0x3dc68)
    FIELD(POR_MPU_M3_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR6_U_SMXP_0_0, 0x3dc70)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR6_U_SMXP_0_0, 0x3dc78)
    FIELD(POR_MPU_M3_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR7_U_SMXP_0_0, 0x3dc80)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR7_U_SMXP_0_0, 0x3dc88)
    FIELD(POR_MPU_M3_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR8_U_SMXP_0_0, 0x3dc90)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR8_U_SMXP_0_0, 0x3dc98)
    FIELD(POR_MPU_M3_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR9_U_SMXP_0_0, 0x3dca0)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR9_U_SMXP_0_0, 0x3dca8)
    FIELD(POR_MPU_M3_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR10_U_SMXP_0_0, 0x3dcb0)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR10_U_SMXP_0_0, 0x3dcb8)
    FIELD(POR_MPU_M3_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR11_U_SMXP_0_0, 0x3dcc0)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR11_U_SMXP_0_0, 0x3dcc8)
    FIELD(POR_MPU_M3_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR12_U_SMXP_0_0, 0x3dcd0)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR12_U_SMXP_0_0, 0x3dcd8)
    FIELD(POR_MPU_M3_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR13_U_SMXP_0_0, 0x3dce0)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR13_U_SMXP_0_0, 0x3dce8)
    FIELD(POR_MPU_M3_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR14_U_SMXP_0_0, 0x3dcf0)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR14_U_SMXP_0_0, 0x3dcf8)
    FIELD(POR_MPU_M3_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR15_U_SMXP_0_0, 0x3dd00)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR15_U_SMXP_0_0, 0x3dd08)
    FIELD(POR_MPU_M3_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR16_U_SMXP_0_0, 0x3dd10)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR16_U_SMXP_0_0, 0x3dd18)
    FIELD(POR_MPU_M3_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR17_U_SMXP_0_0, 0x3dd20)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR17_U_SMXP_0_0, 0x3dd28)
    FIELD(POR_MPU_M3_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR18_U_SMXP_0_0, 0x3dd30)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR18_U_SMXP_0_0, 0x3dd38)
    FIELD(POR_MPU_M3_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR19_U_SMXP_0_0, 0x3dd40)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR19_U_SMXP_0_0, 0x3dd48)
    FIELD(POR_MPU_M3_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR20_U_SMXP_0_0, 0x3dd50)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR20_U_SMXP_0_0, 0x3dd58)
    FIELD(POR_MPU_M3_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR21_U_SMXP_0_0, 0x3dd60)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR21_U_SMXP_0_0, 0x3dd68)
    FIELD(POR_MPU_M3_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR22_U_SMXP_0_0, 0x3dd70)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR22_U_SMXP_0_0, 0x3dd78)
    FIELD(POR_MPU_M3_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR23_U_SMXP_0_0, 0x3dd80)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR23_U_SMXP_0_0, 0x3dd88)
    FIELD(POR_MPU_M3_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR24_U_SMXP_0_0, 0x3dd90)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR24_U_SMXP_0_0, 0x3dd98)
    FIELD(POR_MPU_M3_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR25_U_SMXP_0_0, 0x3dda0)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR25_U_SMXP_0_0, 0x3dda8)
    FIELD(POR_MPU_M3_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR26_U_SMXP_0_0, 0x3ddb0)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR26_U_SMXP_0_0, 0x3ddb8)
    FIELD(POR_MPU_M3_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR27_U_SMXP_0_0, 0x3ddc0)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR27_U_SMXP_0_0, 0x3ddc8)
    FIELD(POR_MPU_M3_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR28_U_SMXP_0_0, 0x3ddd0)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR28_U_SMXP_0_0, 0x3ddd8)
    FIELD(POR_MPU_M3_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR29_U_SMXP_0_0, 0x3dde0)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR29_U_SMXP_0_0, 0x3dde8)
    FIELD(POR_MPU_M3_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR30_U_SMXP_0_0, 0x3ddf0)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR30_U_SMXP_0_0, 0x3ddf8)
    FIELD(POR_MPU_M3_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR31_U_SMXP_0_0, 0x3de00)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR31_U_SMXP_0_0, 0x3de08)
    FIELD(POR_MPU_M3_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M4_CTL_U_SMXP_0_0, 0x3e000)
    FIELD(POR_MPU_M4_CTL_U_SMXP_0_0, M4_EN, 2, 1)
    FIELD(POR_MPU_M4_CTL_U_SMXP_0_0, M4_ACTION, 0, 2)
REG32(POR_MPU_M4_PRBAR0_U_SMXP_0_0, 0x3e010)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR0_U_SMXP_0_0, 0x3e018)
    FIELD(POR_MPU_M4_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR1_U_SMXP_0_0, 0x3e020)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR1_U_SMXP_0_0, 0x3e028)
    FIELD(POR_MPU_M4_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR2_U_SMXP_0_0, 0x3e030)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR2_U_SMXP_0_0, 0x3e038)
    FIELD(POR_MPU_M4_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR3_U_SMXP_0_0, 0x3e040)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR3_U_SMXP_0_0, 0x3e048)
    FIELD(POR_MPU_M4_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR4_U_SMXP_0_0, 0x3e050)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR4_U_SMXP_0_0, 0x3e058)
    FIELD(POR_MPU_M4_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR5_U_SMXP_0_0, 0x3e060)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR5_U_SMXP_0_0, 0x3e068)
    FIELD(POR_MPU_M4_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR6_U_SMXP_0_0, 0x3e070)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR6_U_SMXP_0_0, 0x3e078)
    FIELD(POR_MPU_M4_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR7_U_SMXP_0_0, 0x3e080)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR7_U_SMXP_0_0, 0x3e088)
    FIELD(POR_MPU_M4_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR8_U_SMXP_0_0, 0x3e090)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR8_U_SMXP_0_0, 0x3e098)
    FIELD(POR_MPU_M4_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR9_U_SMXP_0_0, 0x3e0a0)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR9_U_SMXP_0_0, 0x3e0a8)
    FIELD(POR_MPU_M4_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR10_U_SMXP_0_0, 0x3e0b0)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR10_U_SMXP_0_0, 0x3e0b8)
    FIELD(POR_MPU_M4_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR11_U_SMXP_0_0, 0x3e0c0)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR11_U_SMXP_0_0, 0x3e0c8)
    FIELD(POR_MPU_M4_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR12_U_SMXP_0_0, 0x3e0d0)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR12_U_SMXP_0_0, 0x3e0d8)
    FIELD(POR_MPU_M4_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR13_U_SMXP_0_0, 0x3e0e0)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR13_U_SMXP_0_0, 0x3e0e8)
    FIELD(POR_MPU_M4_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR14_U_SMXP_0_0, 0x3e0f0)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR14_U_SMXP_0_0, 0x3e0f8)
    FIELD(POR_MPU_M4_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR15_U_SMXP_0_0, 0x3e100)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR15_U_SMXP_0_0, 0x3e108)
    FIELD(POR_MPU_M4_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR16_U_SMXP_0_0, 0x3e110)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR16_U_SMXP_0_0, 0x3e118)
    FIELD(POR_MPU_M4_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR17_U_SMXP_0_0, 0x3e120)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR17_U_SMXP_0_0, 0x3e128)
    FIELD(POR_MPU_M4_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR18_U_SMXP_0_0, 0x3e130)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR18_U_SMXP_0_0, 0x3e138)
    FIELD(POR_MPU_M4_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR19_U_SMXP_0_0, 0x3e140)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR19_U_SMXP_0_0, 0x3e148)
    FIELD(POR_MPU_M4_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR20_U_SMXP_0_0, 0x3e150)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR20_U_SMXP_0_0, 0x3e158)
    FIELD(POR_MPU_M4_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR21_U_SMXP_0_0, 0x3e160)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR21_U_SMXP_0_0, 0x3e168)
    FIELD(POR_MPU_M4_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR22_U_SMXP_0_0, 0x3e170)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR22_U_SMXP_0_0, 0x3e178)
    FIELD(POR_MPU_M4_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR23_U_SMXP_0_0, 0x3e180)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR23_U_SMXP_0_0, 0x3e188)
    FIELD(POR_MPU_M4_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR24_U_SMXP_0_0, 0x3e190)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR24_U_SMXP_0_0, 0x3e198)
    FIELD(POR_MPU_M4_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR25_U_SMXP_0_0, 0x3e1a0)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR25_U_SMXP_0_0, 0x3e1a8)
    FIELD(POR_MPU_M4_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR26_U_SMXP_0_0, 0x3e1b0)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR26_U_SMXP_0_0, 0x3e1b8)
    FIELD(POR_MPU_M4_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR27_U_SMXP_0_0, 0x3e1c0)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR27_U_SMXP_0_0, 0x3e1c8)
    FIELD(POR_MPU_M4_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR28_U_SMXP_0_0, 0x3e1d0)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR28_U_SMXP_0_0, 0x3e1d8)
    FIELD(POR_MPU_M4_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR29_U_SMXP_0_0, 0x3e1e0)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR29_U_SMXP_0_0, 0x3e1e8)
    FIELD(POR_MPU_M4_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR30_U_SMXP_0_0, 0x3e1f0)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR30_U_SMXP_0_0, 0x3e1f8)
    FIELD(POR_MPU_M4_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR31_U_SMXP_0_0, 0x3e200)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR31_U_SMXP_0_0, 0x3e208)
    FIELD(POR_MPU_M4_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M5_CTL_U_SMXP_0_0, 0x3e400)
    FIELD(POR_MPU_M5_CTL_U_SMXP_0_0, M5_EN, 2, 1)
    FIELD(POR_MPU_M5_CTL_U_SMXP_0_0, M5_ACTION, 0, 2)
REG32(POR_MPU_M5_PRBAR0_U_SMXP_0_0, 0x3e410)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR0_U_SMXP_0_0, 0x3e418)
    FIELD(POR_MPU_M5_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR1_U_SMXP_0_0, 0x3e420)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR1_U_SMXP_0_0, 0x3e428)
    FIELD(POR_MPU_M5_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR2_U_SMXP_0_0, 0x3e430)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR2_U_SMXP_0_0, 0x3e438)
    FIELD(POR_MPU_M5_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR3_U_SMXP_0_0, 0x3e440)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR3_U_SMXP_0_0, 0x3e448)
    FIELD(POR_MPU_M5_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR4_U_SMXP_0_0, 0x3e450)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR4_U_SMXP_0_0, 0x3e458)
    FIELD(POR_MPU_M5_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR5_U_SMXP_0_0, 0x3e460)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR5_U_SMXP_0_0, 0x3e468)
    FIELD(POR_MPU_M5_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR6_U_SMXP_0_0, 0x3e470)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR6_U_SMXP_0_0, 0x3e478)
    FIELD(POR_MPU_M5_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR7_U_SMXP_0_0, 0x3e480)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR7_U_SMXP_0_0, 0x3e488)
    FIELD(POR_MPU_M5_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR8_U_SMXP_0_0, 0x3e490)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR8_U_SMXP_0_0, 0x3e498)
    FIELD(POR_MPU_M5_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR9_U_SMXP_0_0, 0x3e4a0)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR9_U_SMXP_0_0, 0x3e4a8)
    FIELD(POR_MPU_M5_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR10_U_SMXP_0_0, 0x3e4b0)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR10_U_SMXP_0_0, 0x3e4b8)
    FIELD(POR_MPU_M5_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR11_U_SMXP_0_0, 0x3e4c0)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR11_U_SMXP_0_0, 0x3e4c8)
    FIELD(POR_MPU_M5_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR12_U_SMXP_0_0, 0x3e4d0)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR12_U_SMXP_0_0, 0x3e4d8)
    FIELD(POR_MPU_M5_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR13_U_SMXP_0_0, 0x3e4e0)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR13_U_SMXP_0_0, 0x3e4e8)
    FIELD(POR_MPU_M5_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR14_U_SMXP_0_0, 0x3e4f0)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR14_U_SMXP_0_0, 0x3e4f8)
    FIELD(POR_MPU_M5_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR15_U_SMXP_0_0, 0x3e500)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR15_U_SMXP_0_0, 0x3e508)
    FIELD(POR_MPU_M5_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR16_U_SMXP_0_0, 0x3e510)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR16_U_SMXP_0_0, 0x3e518)
    FIELD(POR_MPU_M5_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR17_U_SMXP_0_0, 0x3e520)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR17_U_SMXP_0_0, 0x3e528)
    FIELD(POR_MPU_M5_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR18_U_SMXP_0_0, 0x3e530)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR18_U_SMXP_0_0, 0x3e538)
    FIELD(POR_MPU_M5_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR19_U_SMXP_0_0, 0x3e540)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR19_U_SMXP_0_0, 0x3e548)
    FIELD(POR_MPU_M5_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR20_U_SMXP_0_0, 0x3e550)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR20_U_SMXP_0_0, 0x3e558)
    FIELD(POR_MPU_M5_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR21_U_SMXP_0_0, 0x3e560)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR21_U_SMXP_0_0, 0x3e568)
    FIELD(POR_MPU_M5_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR22_U_SMXP_0_0, 0x3e570)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR22_U_SMXP_0_0, 0x3e578)
    FIELD(POR_MPU_M5_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR23_U_SMXP_0_0, 0x3e580)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR23_U_SMXP_0_0, 0x3e588)
    FIELD(POR_MPU_M5_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR24_U_SMXP_0_0, 0x3e590)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR24_U_SMXP_0_0, 0x3e598)
    FIELD(POR_MPU_M5_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR25_U_SMXP_0_0, 0x3e5a0)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR25_U_SMXP_0_0, 0x3e5a8)
    FIELD(POR_MPU_M5_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR26_U_SMXP_0_0, 0x3e5b0)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR26_U_SMXP_0_0, 0x3e5b8)
    FIELD(POR_MPU_M5_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR27_U_SMXP_0_0, 0x3e5c0)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR27_U_SMXP_0_0, 0x3e5c8)
    FIELD(POR_MPU_M5_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR28_U_SMXP_0_0, 0x3e5d0)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR28_U_SMXP_0_0, 0x3e5d8)
    FIELD(POR_MPU_M5_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR29_U_SMXP_0_0, 0x3e5e0)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR29_U_SMXP_0_0, 0x3e5e8)
    FIELD(POR_MPU_M5_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR30_U_SMXP_0_0, 0x3e5f0)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR30_U_SMXP_0_0, 0x3e5f8)
    FIELD(POR_MPU_M5_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR31_U_SMXP_0_0, 0x3e600)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR31_U_SMXP_0_0, 0x3e608)
    FIELD(POR_MPU_M5_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M6_CTL_U_SMXP_0_0, 0x3e800)
    FIELD(POR_MPU_M6_CTL_U_SMXP_0_0, M6_EN, 2, 1)
    FIELD(POR_MPU_M6_CTL_U_SMXP_0_0, M6_ACTION, 0, 2)
REG32(POR_MPU_M6_PRBAR0_U_SMXP_0_0, 0x3e810)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR0_U_SMXP_0_0, 0x3e818)
    FIELD(POR_MPU_M6_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR1_U_SMXP_0_0, 0x3e820)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR1_U_SMXP_0_0, 0x3e828)
    FIELD(POR_MPU_M6_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR2_U_SMXP_0_0, 0x3e830)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR2_U_SMXP_0_0, 0x3e838)
    FIELD(POR_MPU_M6_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR3_U_SMXP_0_0, 0x3e840)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR3_U_SMXP_0_0, 0x3e848)
    FIELD(POR_MPU_M6_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR4_U_SMXP_0_0, 0x3e850)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR4_U_SMXP_0_0, 0x3e858)
    FIELD(POR_MPU_M6_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR5_U_SMXP_0_0, 0x3e860)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR5_U_SMXP_0_0, 0x3e868)
    FIELD(POR_MPU_M6_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR6_U_SMXP_0_0, 0x3e870)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR6_U_SMXP_0_0, 0x3e878)
    FIELD(POR_MPU_M6_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR7_U_SMXP_0_0, 0x3e880)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR7_U_SMXP_0_0, 0x3e888)
    FIELD(POR_MPU_M6_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR8_U_SMXP_0_0, 0x3e890)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR8_U_SMXP_0_0, 0x3e898)
    FIELD(POR_MPU_M6_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR9_U_SMXP_0_0, 0x3e8a0)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR9_U_SMXP_0_0, 0x3e8a8)
    FIELD(POR_MPU_M6_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR10_U_SMXP_0_0, 0x3e8b0)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR10_U_SMXP_0_0, 0x3e8b8)
    FIELD(POR_MPU_M6_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR11_U_SMXP_0_0, 0x3e8c0)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR11_U_SMXP_0_0, 0x3e8c8)
    FIELD(POR_MPU_M6_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR12_U_SMXP_0_0, 0x3e8d0)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR12_U_SMXP_0_0, 0x3e8d8)
    FIELD(POR_MPU_M6_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR13_U_SMXP_0_0, 0x3e8e0)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR13_U_SMXP_0_0, 0x3e8e8)
    FIELD(POR_MPU_M6_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR14_U_SMXP_0_0, 0x3e8f0)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR14_U_SMXP_0_0, 0x3e8f8)
    FIELD(POR_MPU_M6_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR15_U_SMXP_0_0, 0x3e900)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR15_U_SMXP_0_0, 0x3e908)
    FIELD(POR_MPU_M6_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR16_U_SMXP_0_0, 0x3e910)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR16_U_SMXP_0_0, 0x3e918)
    FIELD(POR_MPU_M6_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR17_U_SMXP_0_0, 0x3e920)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR17_U_SMXP_0_0, 0x3e928)
    FIELD(POR_MPU_M6_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR18_U_SMXP_0_0, 0x3e930)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR18_U_SMXP_0_0, 0x3e938)
    FIELD(POR_MPU_M6_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR19_U_SMXP_0_0, 0x3e940)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR19_U_SMXP_0_0, 0x3e948)
    FIELD(POR_MPU_M6_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR20_U_SMXP_0_0, 0x3e950)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR20_U_SMXP_0_0, 0x3e958)
    FIELD(POR_MPU_M6_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR21_U_SMXP_0_0, 0x3e960)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR21_U_SMXP_0_0, 0x3e968)
    FIELD(POR_MPU_M6_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR22_U_SMXP_0_0, 0x3e970)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR22_U_SMXP_0_0, 0x3e978)
    FIELD(POR_MPU_M6_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR23_U_SMXP_0_0, 0x3e980)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR23_U_SMXP_0_0, 0x3e988)
    FIELD(POR_MPU_M6_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR24_U_SMXP_0_0, 0x3e990)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR24_U_SMXP_0_0, 0x3e998)
    FIELD(POR_MPU_M6_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR25_U_SMXP_0_0, 0x3e9a0)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR25_U_SMXP_0_0, 0x3e9a8)
    FIELD(POR_MPU_M6_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR26_U_SMXP_0_0, 0x3e9b0)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR26_U_SMXP_0_0, 0x3e9b8)
    FIELD(POR_MPU_M6_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR27_U_SMXP_0_0, 0x3e9c0)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR27_U_SMXP_0_0, 0x3e9c8)
    FIELD(POR_MPU_M6_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR28_U_SMXP_0_0, 0x3e9d0)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR28_U_SMXP_0_0, 0x3e9d8)
    FIELD(POR_MPU_M6_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR29_U_SMXP_0_0, 0x3e9e0)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR29_U_SMXP_0_0, 0x3e9e8)
    FIELD(POR_MPU_M6_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR30_U_SMXP_0_0, 0x3e9f0)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR30_U_SMXP_0_0, 0x3e9f8)
    FIELD(POR_MPU_M6_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR31_U_SMXP_0_0, 0x3ea00)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR31_U_SMXP_0_0, 0x3ea08)
    FIELD(POR_MPU_M6_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_MPU_M7_CTL_U_SMXP_0_0, 0x3ec00)
    FIELD(POR_MPU_M7_CTL_U_SMXP_0_0, M7_EN, 2, 1)
    FIELD(POR_MPU_M7_CTL_U_SMXP_0_0, M7_ACTION, 0, 2)
REG32(POR_MPU_M7_PRBAR0_U_SMXP_0_0, 0x3ec10)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_0, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_0, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_0, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR0_U_SMXP_0_0, 0x3ec18)
    FIELD(POR_MPU_M7_PRLAR0_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR0_U_SMXP_0_0, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR0_U_SMXP_0_0, REGION0_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR1_U_SMXP_0_0, 0x3ec20)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_0, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_0, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_0, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR1_U_SMXP_0_0, 0x3ec28)
    FIELD(POR_MPU_M7_PRLAR1_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR1_U_SMXP_0_0, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR1_U_SMXP_0_0, REGION1_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR2_U_SMXP_0_0, 0x3ec30)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_0, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_0, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_0, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR2_U_SMXP_0_0, 0x3ec38)
    FIELD(POR_MPU_M7_PRLAR2_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR2_U_SMXP_0_0, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR2_U_SMXP_0_0, REGION2_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR3_U_SMXP_0_0, 0x3ec40)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_0, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_0, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_0, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR3_U_SMXP_0_0, 0x3ec48)
    FIELD(POR_MPU_M7_PRLAR3_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR3_U_SMXP_0_0, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR3_U_SMXP_0_0, REGION3_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR4_U_SMXP_0_0, 0x3ec50)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_0, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_0, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_0, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR4_U_SMXP_0_0, 0x3ec58)
    FIELD(POR_MPU_M7_PRLAR4_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR4_U_SMXP_0_0, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR4_U_SMXP_0_0, REGION4_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR5_U_SMXP_0_0, 0x3ec60)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_0, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_0, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_0, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR5_U_SMXP_0_0, 0x3ec68)
    FIELD(POR_MPU_M7_PRLAR5_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR5_U_SMXP_0_0, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR5_U_SMXP_0_0, REGION5_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR6_U_SMXP_0_0, 0x3ec70)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_0, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_0, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_0, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR6_U_SMXP_0_0, 0x3ec78)
    FIELD(POR_MPU_M7_PRLAR6_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR6_U_SMXP_0_0, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR6_U_SMXP_0_0, REGION6_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR7_U_SMXP_0_0, 0x3ec80)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_0, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_0, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_0, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR7_U_SMXP_0_0, 0x3ec88)
    FIELD(POR_MPU_M7_PRLAR7_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR7_U_SMXP_0_0, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR7_U_SMXP_0_0, REGION7_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR8_U_SMXP_0_0, 0x3ec90)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_0, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_0, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_0, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR8_U_SMXP_0_0, 0x3ec98)
    FIELD(POR_MPU_M7_PRLAR8_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR8_U_SMXP_0_0, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR8_U_SMXP_0_0, REGION8_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR9_U_SMXP_0_0, 0x3eca0)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_0, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_0, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_0, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR9_U_SMXP_0_0, 0x3eca8)
    FIELD(POR_MPU_M7_PRLAR9_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR9_U_SMXP_0_0, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR9_U_SMXP_0_0, REGION9_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR10_U_SMXP_0_0, 0x3ecb0)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_0, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_0, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_0, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR10_U_SMXP_0_0, 0x3ecb8)
    FIELD(POR_MPU_M7_PRLAR10_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR10_U_SMXP_0_0, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR10_U_SMXP_0_0, REGION10_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR11_U_SMXP_0_0, 0x3ecc0)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_0, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_0, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_0, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR11_U_SMXP_0_0, 0x3ecc8)
    FIELD(POR_MPU_M7_PRLAR11_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR11_U_SMXP_0_0, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR11_U_SMXP_0_0, REGION11_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR12_U_SMXP_0_0, 0x3ecd0)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_0, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_0, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_0, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR12_U_SMXP_0_0, 0x3ecd8)
    FIELD(POR_MPU_M7_PRLAR12_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR12_U_SMXP_0_0, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR12_U_SMXP_0_0, REGION12_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR13_U_SMXP_0_0, 0x3ece0)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_0, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_0, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_0, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR13_U_SMXP_0_0, 0x3ece8)
    FIELD(POR_MPU_M7_PRLAR13_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR13_U_SMXP_0_0, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR13_U_SMXP_0_0, REGION13_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR14_U_SMXP_0_0, 0x3ecf0)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_0, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_0, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_0, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR14_U_SMXP_0_0, 0x3ecf8)
    FIELD(POR_MPU_M7_PRLAR14_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR14_U_SMXP_0_0, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR14_U_SMXP_0_0, REGION14_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR15_U_SMXP_0_0, 0x3ed00)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_0, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_0, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_0, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR15_U_SMXP_0_0, 0x3ed08)
    FIELD(POR_MPU_M7_PRLAR15_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR15_U_SMXP_0_0, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR15_U_SMXP_0_0, REGION15_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR16_U_SMXP_0_0, 0x3ed10)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_0, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_0, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_0, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR16_U_SMXP_0_0, 0x3ed18)
    FIELD(POR_MPU_M7_PRLAR16_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR16_U_SMXP_0_0, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR16_U_SMXP_0_0, REGION16_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR17_U_SMXP_0_0, 0x3ed20)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_0, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_0, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_0, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR17_U_SMXP_0_0, 0x3ed28)
    FIELD(POR_MPU_M7_PRLAR17_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR17_U_SMXP_0_0, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR17_U_SMXP_0_0, REGION17_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR18_U_SMXP_0_0, 0x3ed30)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_0, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_0, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_0, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR18_U_SMXP_0_0, 0x3ed38)
    FIELD(POR_MPU_M7_PRLAR18_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR18_U_SMXP_0_0, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR18_U_SMXP_0_0, REGION18_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR19_U_SMXP_0_0, 0x3ed40)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_0, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_0, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_0, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR19_U_SMXP_0_0, 0x3ed48)
    FIELD(POR_MPU_M7_PRLAR19_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR19_U_SMXP_0_0, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR19_U_SMXP_0_0, REGION19_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR20_U_SMXP_0_0, 0x3ed50)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_0, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_0, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_0, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR20_U_SMXP_0_0, 0x3ed58)
    FIELD(POR_MPU_M7_PRLAR20_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR20_U_SMXP_0_0, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR20_U_SMXP_0_0, REGION20_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR21_U_SMXP_0_0, 0x3ed60)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_0, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_0, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_0, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR21_U_SMXP_0_0, 0x3ed68)
    FIELD(POR_MPU_M7_PRLAR21_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR21_U_SMXP_0_0, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR21_U_SMXP_0_0, REGION21_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR22_U_SMXP_0_0, 0x3ed70)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_0, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_0, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_0, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR22_U_SMXP_0_0, 0x3ed78)
    FIELD(POR_MPU_M7_PRLAR22_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR22_U_SMXP_0_0, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR22_U_SMXP_0_0, REGION22_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR23_U_SMXP_0_0, 0x3ed80)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_0, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_0, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_0, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR23_U_SMXP_0_0, 0x3ed88)
    FIELD(POR_MPU_M7_PRLAR23_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR23_U_SMXP_0_0, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR23_U_SMXP_0_0, REGION23_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR24_U_SMXP_0_0, 0x3ed90)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_0, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_0, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_0, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR24_U_SMXP_0_0, 0x3ed98)
    FIELD(POR_MPU_M7_PRLAR24_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR24_U_SMXP_0_0, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR24_U_SMXP_0_0, REGION24_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR25_U_SMXP_0_0, 0x3eda0)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_0, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_0, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_0, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR25_U_SMXP_0_0, 0x3eda8)
    FIELD(POR_MPU_M7_PRLAR25_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR25_U_SMXP_0_0, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR25_U_SMXP_0_0, REGION25_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR26_U_SMXP_0_0, 0x3edb0)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_0, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_0, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_0, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR26_U_SMXP_0_0, 0x3edb8)
    FIELD(POR_MPU_M7_PRLAR26_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR26_U_SMXP_0_0, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR26_U_SMXP_0_0, REGION26_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR27_U_SMXP_0_0, 0x3edc0)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_0, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_0, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_0, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR27_U_SMXP_0_0, 0x3edc8)
    FIELD(POR_MPU_M7_PRLAR27_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR27_U_SMXP_0_0, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR27_U_SMXP_0_0, REGION27_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR28_U_SMXP_0_0, 0x3edd0)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_0, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_0, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_0, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR28_U_SMXP_0_0, 0x3edd8)
    FIELD(POR_MPU_M7_PRLAR28_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR28_U_SMXP_0_0, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR28_U_SMXP_0_0, REGION28_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR29_U_SMXP_0_0, 0x3ede0)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_0, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_0, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_0, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR29_U_SMXP_0_0, 0x3ede8)
    FIELD(POR_MPU_M7_PRLAR29_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR29_U_SMXP_0_0, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR29_U_SMXP_0_0, REGION29_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR30_U_SMXP_0_0, 0x3edf0)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_0, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_0, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_0, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR30_U_SMXP_0_0, 0x3edf8)
    FIELD(POR_MPU_M7_PRLAR30_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR30_U_SMXP_0_0, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR30_U_SMXP_0_0, REGION30_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR31_U_SMXP_0_0, 0x3ee00)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_0, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_0, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_0, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_0, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_0, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR31_U_SMXP_0_0, 0x3ee08)
    FIELD(POR_MPU_M7_PRLAR31_U_SMXP_0_0, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR31_U_SMXP_0_0, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR31_U_SMXP_0_0, REGION31_EN, 0, 1)
REG32(POR_HNF_NODE_INFO_U_HNF_NID8, 0x100000)
    FIELD(POR_HNF_NODE_INFO_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(POR_HNF_NODE_INFO_U_HNF_NID8, LOGICAL_ID, 32, 16)
    FIELD(POR_HNF_NODE_INFO_U_HNF_NID8, NODE_ID, 16, 16)
    FIELD(POR_HNF_NODE_INFO_U_HNF_NID8, NODE_TYPE, 0, 16)
REG32(POR_HNF_CHILD_INFO_U_HNF_NID8, 0x100080)
    FIELD(POR_HNF_CHILD_INFO_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_CHILD_INFO_U_HNF_NID8, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_HNF_CHILD_INFO_U_HNF_NID8, CHILD_COUNT, 0, 16)
REG32(POR_HNF_UNIT_INFO_U_HNF_NID8, 0x100900)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, RESERVED_39, 39, 25)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, NUM_POC_ENTRIES, 32, 7)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, RESERVED_31, 31, 1)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, NUM_EXCL, 24, 7)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, DATA_RAM_LATENCY, 20, 3)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, RESERVED_19, 19, 1)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, TAG_RAM_LAT, 16, 3)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, RESERVED_13, 13, 3)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, NUM_WAYS, 8, 5)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, SF_SIZE, 4, 3)
    FIELD(POR_HNF_UNIT_INFO_U_HNF_NID8, SLC_SIZE, 0, 3)
REG32(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, 0x100980)
    FIELD(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, SLCSF_DBGRD, 5, 1)
    FIELD(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, SAM_CONTROL, 4, 1)
    FIELD(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, SLC_LOCK_WAYS, 3, 1)
    FIELD(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, PPU, 2, 1)
    FIELD(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, CFG_CTL, 1, 1)
    FIELD(POR_HNF_SECURE_REGISTER_GROUPS_OVERRIDE_U_HNF_NID8, QOS, 0, 1)
REG32(POR_HNF_CFG_CTL_U_HNF_NID8, 0x100a00)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, RESERVED_12, 12, 52)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, HNF_DMT_DISABLE, 11, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, HNF_OCM_ALLWAYS_EN, 10, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, HNF_OCM_EN, 9, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, NCDEVCMO_MC_COMP, 8, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, SF_ECC_SCRUB_DISABLE, 6, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, SLC_TAG_ECC_SCRUB_DISABLE, 4, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, POIS_DIS, 2, 1)
    FIELD(POR_HNF_CFG_CTL_U_HNF_NID8, ECC_DISABLE, 0, 1)
REG32(POR_HNF_AUX_CTL_U_HNF_NID8, 0x100a08)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, RESERVED_58, 58, 6)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, SLC_ECC_PIPE_MODE_DIS, 57, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_ORD_STASH_DATAPULL_EN, 56, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SHARED_INTV_DISABLE, 55, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, RESERVED_53, 53, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_LRU_DUALMODE_INSERT_VALUE, 51, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_LRU_STATICMODE_INSERT_VALUE, 49, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_LRU_SLCSRC_INSERT_VALUE, 47, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_LRU_SEL_CNT_VALUE, 45, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_LRU_SET_GROUPS, 43, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_LRU_VICTIM_DISABLE, 42, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SLC_VICTIM_QOS_HIGH, 41, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_SF_SNP_VEC_DISABLE, 40, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_STASH_DATAPULL_DISABLE, 39, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, RESERVED_37, 37, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_CU_EXCL_OPT_EN, 36, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, RESERVED_34, 34, 2)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_EXCL_SNP_FWD_EN, 33, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_RD_EXCL_OPT_EN, 32, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, RESERVED_17, 17, 15)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_POISON_INTR_EN, 16, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_DCT_DISABLE, 15, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, WLU_ALLOC_ON_HIT, 14, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, SF_DISABLE, 13, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, CG_DISABLE, 12, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, SLC_POR_INIT_DISABLE, 11, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, FRZ_MON_ON_OVFL, 10, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, DIS_SEQREQ_COLL, 9, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, DIS_LIKELYSH, 8, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_STASH_DISABLE, 7, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, DIS_SNP_ONCE, 6, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, NON_SH_NO_ALLOC, 5, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, IO_READ_NO_ALLOC, 4, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, REV_QOS_POOL_ALLOC, 3, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, NO_WU_ALLOC, 2, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_HONOR_EWA, 1, 1)
    FIELD(POR_HNF_AUX_CTL_U_HNF_NID8, HNF_ONLY_MODE, 0, 1)
REG32(POR_HNF_R2_AUX_CTL_U_HNF_NID8, 0x100a10)
    FIELD(POR_HNF_R2_AUX_CTL_U_HNF_NID8, HNF_SHD_RAM_LSCG_CG_DISABLE, 3, 1)
    FIELD(POR_HNF_R2_AUX_CTL_U_HNF_NID8, HNF_FORCE_FLUSH_EWA0_EN, 2, 1)
    FIELD(POR_HNF_R2_AUX_CTL_U_HNF_NID8, HNF_PCMO_TERMINATE_EN, 1, 1)
    FIELD(POR_HNF_R2_AUX_CTL_U_HNF_NID8, HNF_CHIC_RDNOSNPSEP_DIS, 0, 1)
REG32(RDF_HNF_AUX_CTL_U_HNF_NID8, 0x100a18)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RESERVED_16, 16, 48)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RDF_1CYCTAG_ECCMODE_OPT_DIS, 15, 1)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RESERVED_13, 13, 2)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RDF_ALLOW_CLN_DATA_FROM_NO_WR_AP, 12, 1)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RESERVED_10, 10, 2)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RDF_SNP_MPU_ERR_LOG_EN, 9, 1)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RDF_MPU_ERR_LOG_DIS, 8, 1)
    FIELD(RDF_HNF_AUX_CTL_U_HNF_NID8, RESERVED_0, 0, 8)
REG32(POR_HNF_QOS_BAND_U_HNF_NID8, 0x100a80)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, HIGHHIGH_MAX_QOS_VAL, 28, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, HIGHHIGH_MIN_QOS_VAL, 24, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, HIGH_MAX_QOS_VAL, 20, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, HIGH_MIN_QOS_VAL, 16, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, MED_MAX_QOS_VAL, 12, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, MED_MIN_QOS_VAL, 8, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, LOW_MAX_QOS_VAL, 4, 4)
    FIELD(POR_HNF_QOS_BAND_U_HNF_NID8, LOW_MIN_QOS_VAL, 0, 4)
REG32(POR_HNF_QOS_RESERVATION_U_HNF_NID8, 0x100a88)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, RESERVED_38, 38, 26)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, SEQ_QOS_MAX_CNT, 32, 6)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, RESERVED_30, 30, 2)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, HIGHHIGH_QOS_MAX_CNT, 24, 6)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, RESERVED_22, 22, 2)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, HIGH_QOS_MAX_CNT, 16, 6)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, RESERVED_14, 14, 2)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, MED_QOS_MAX_CNT, 8, 6)
    FIELD(POR_HNF_QOS_RESERVATION_U_HNF_NID8, LOW_QOS_MAX_CNT, 0, 6)
REG32(POR_HNF_RN_STARVATION_U_HNF_NID8, 0x100a90)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RESERVED_45, 45, 19)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RN_HIGH_OVER_HIGH_HIGH_MAX_CNT, 40, 5)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RESERVED_38, 38, 2)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RN_MED_OVER_HIGHHIGH_MAX_CNT, 32, 6)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RESERVED_29, 29, 3)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RN_MED_OVER_HIGH_MAX_CNT, 24, 5)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RN_LOW_OVER_HIGHHIGH_MAX_CNT, 16, 7)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RESERVED_14, 14, 2)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RN_LOW_OVER_HIGH_MAX_CNT, 8, 6)
    FIELD(POR_HNF_RN_STARVATION_U_HNF_NID8, RN_LOW_OVER_MED_MAX_CNT, 0, 5)
REG32(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, 0x100b80)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, RESERVED_26, 26, 38)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, SLC_ACCESS_COMPONENT, 24, 2)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, SLC_ACCESS_DW, 20, 3)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, SLC_ACCESS_WAY, 16, 4)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, RESERVED_13, 13, 3)
    FIELD(POR_HNF_CFG_SLCSF_DBGRD_U_HNF_NID8, SLC_ACCESS_SET, 0, 13)
REG32(POR_HNF_SLC_CACHE_ACCESS_SLC_TAG_U_HNF_NID8, 0x100b88)
    FIELD(POR_HNF_SLC_CACHE_ACCESS_SLC_TAG_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(POR_HNF_SLC_CACHE_ACCESS_SLC_TAG_U_HNF_NID8, SLC_CACHE_ACCESS_SLC_TAG, 0, 48)
REG32(POR_HNF_SLC_CACHE_ACCESS_SLC_DATA_U_HNF_NID8, 0x100b90)
REG32(POR_HNF_SLC_CACHE_ACCESS_SF_TAG_U_HNF_NID8, 0x100b98)
REG32(POR_HNF_SLC_CACHE_ACCESS_SF_TAG1_U_HNF_NID8, 0x100ba0)
REG32(POR_HNF_SLC_CACHE_ACCESS_SF_TAG2_U_HNF_NID8, 0x100ba8)
REG32(POR_HNF_SLC_LOCK_WAYS_U_HNF_NID8, 0x100c00)
    FIELD(POR_HNF_SLC_LOCK_WAYS_U_HNF_NID8, RESERVED_15, 15, 49)
    FIELD(POR_HNF_SLC_LOCK_WAYS_U_HNF_NID8, NUM_HNF, 8, 7)
    FIELD(POR_HNF_SLC_LOCK_WAYS_U_HNF_NID8, WAYS, 0, 4)
REG32(POR_HNF_SLC_LOCK_BASE0_U_HNF_NID8, 0x100c08)
    FIELD(POR_HNF_SLC_LOCK_BASE0_U_HNF_NID8, BASE0_VLD, 63, 1)
    FIELD(POR_HNF_SLC_LOCK_BASE0_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_SLC_LOCK_BASE0_U_HNF_NID8, BASE0, 0, 48)
REG32(POR_HNF_SLC_LOCK_BASE1_U_HNF_NID8, 0x100c10)
    FIELD(POR_HNF_SLC_LOCK_BASE1_U_HNF_NID8, BASE1_VLD, 63, 1)
    FIELD(POR_HNF_SLC_LOCK_BASE1_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_SLC_LOCK_BASE1_U_HNF_NID8, BASE1, 0, 48)
REG32(POR_HNF_SLC_LOCK_BASE2_U_HNF_NID8, 0x100c18)
    FIELD(POR_HNF_SLC_LOCK_BASE2_U_HNF_NID8, BASE2_VLD, 63, 1)
    FIELD(POR_HNF_SLC_LOCK_BASE2_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_SLC_LOCK_BASE2_U_HNF_NID8, BASE2, 0, 48)
REG32(POR_HNF_SLC_LOCK_BASE3_U_HNF_NID8, 0x100c20)
    FIELD(POR_HNF_SLC_LOCK_BASE3_U_HNF_NID8, BASE3_VLD, 63, 1)
    FIELD(POR_HNF_SLC_LOCK_BASE3_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_SLC_LOCK_BASE3_U_HNF_NID8, BASE3, 0, 48)
REG32(POR_HNF_RNF_REGION_VEC1_U_HNF_NID8, 0x100c28)
REG32(POR_HNF_RNI_REGION_VEC_U_HNF_NID8, 0x100c30)
    FIELD(POR_HNF_RNI_REGION_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_RNI_REGION_VEC_U_HNF_NID8, RNI_REGION_VEC, 0, 32)
REG32(POR_HNF_RNF_REGION_VEC_U_HNF_NID8, 0x100c38)
REG32(POR_HNF_RND_REGION_VEC_U_HNF_NID8, 0x100c40)
    FIELD(POR_HNF_RND_REGION_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_RND_REGION_VEC_U_HNF_NID8, RND_REGION_VEC, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION0_RNF_VEC_U_HNF_NID8, 0x100c48)
REG32(POR_HNF_SLCWAY_PARTITION1_RNF_VEC_U_HNF_NID8, 0x100c50)
REG32(POR_HNF_SLCWAY_PARTITION2_RNF_VEC_U_HNF_NID8, 0x100c58)
REG32(POR_HNF_SLCWAY_PARTITION3_RNF_VEC_U_HNF_NID8, 0x100c60)
REG32(POR_HNF_SLCWAY_PARTITION0_RNI_VEC_U_HNF_NID8, 0x100c68)
    FIELD(POR_HNF_SLCWAY_PARTITION0_RNI_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION0_RNI_VEC_U_HNF_NID8, RNI_VEC0, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION1_RNI_VEC_U_HNF_NID8, 0x100c70)
    FIELD(POR_HNF_SLCWAY_PARTITION1_RNI_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION1_RNI_VEC_U_HNF_NID8, RNI_VEC1, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION2_RNI_VEC_U_HNF_NID8, 0x100c78)
    FIELD(POR_HNF_SLCWAY_PARTITION2_RNI_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION2_RNI_VEC_U_HNF_NID8, RNI_VEC2, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION3_RNI_VEC_U_HNF_NID8, 0x100c80)
    FIELD(POR_HNF_SLCWAY_PARTITION3_RNI_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION3_RNI_VEC_U_HNF_NID8, RNI_VEC3, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION0_RND_VEC_U_HNF_NID8, 0x100c88)
    FIELD(POR_HNF_SLCWAY_PARTITION0_RND_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION0_RND_VEC_U_HNF_NID8, RND_VEC0, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION1_RND_VEC_U_HNF_NID8, 0x100c90)
    FIELD(POR_HNF_SLCWAY_PARTITION1_RND_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION1_RND_VEC_U_HNF_NID8, RND_VEC1, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION2_RND_VEC_U_HNF_NID8, 0x100c98)
    FIELD(POR_HNF_SLCWAY_PARTITION2_RND_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION2_RND_VEC_U_HNF_NID8, RND_VEC2, 0, 32)
REG32(POR_HNF_SLCWAY_PARTITION3_RND_VEC_U_HNF_NID8, 0x100ca0)
    FIELD(POR_HNF_SLCWAY_PARTITION3_RND_VEC_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_SLCWAY_PARTITION3_RND_VEC_U_HNF_NID8, RND_VEC3, 0, 32)
REG32(POR_HNF_RN_REGION_LOCK_U_HNF_NID8, 0x100ca8)
    FIELD(POR_HNF_RN_REGION_LOCK_U_HNF_NID8, RN_PICK_LOCKED_WAYS_ONLY, 1, 1)
    FIELD(POR_HNF_RN_REGION_LOCK_U_HNF_NID8, RN_REGION_LOCK_EN, 0, 1)
REG32(POR_HNF_SLCWAY_PARTITION0_RNF_VEC1_U_HNF_NID8, 0x100cb0)
REG32(POR_HNF_SLCWAY_PARTITION1_RNF_VEC1_U_HNF_NID8, 0x100cb8)
REG32(POR_HNF_SLCWAY_PARTITION2_RNF_VEC1_U_HNF_NID8, 0x100cc0)
REG32(POR_HNF_SLCWAY_PARTITION3_RNF_VEC1_U_HNF_NID8, 0x100cc8)
REG32(POR_HNF_SAM_CONTROL_U_HNF_NID8, 0x100d00)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SAM_INV_TOP_ADDRESS_BIT, 63, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_62, 62, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SAM_TOP_ADDRESS_BIT2, 56, 6)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_54, 54, 2)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SAM_TOP_ADDRESS_BIT1, 48, 6)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_46, 46, 2)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SAM_TOP_ADDRESS_BIT0, 40, 6)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_38, 38, 2)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SIX_SN_EN, 37, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_THREE_SN_EN, 36, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_35, 35, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SN2_NODEID, 24, 11)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SN1_NODEID, 12, 11)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, RESERVED_11, 11, 1)
    FIELD(POR_HNF_SAM_CONTROL_U_HNF_NID8, HN_CFG_SN0_NODEID, 0, 11)
REG32(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, 0x100d08)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, VALID, 63, 1)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, BASE_ADDR, 26, 22)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, RESERVED_17, 17, 9)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, SIZE, 12, 5)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, RESERVED_11, 11, 1)
    FIELD(POR_HNF_SAM_MEMREGION0_U_HNF_NID8, RANGE0_NODEID, 0, 11)
REG32(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, 0x100d10)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, VALID, 63, 1)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, BASE_ADDR, 26, 22)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, RESERVED_17, 17, 9)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, SIZE, 12, 5)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, RESERVED_11, 11, 1)
    FIELD(POR_HNF_SAM_MEMREGION1_U_HNF_NID8, RANGE1_NODEID, 0, 11)
REG32(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, 0x100d18)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_45, 45, 19)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RANGE1_SN_PCMO_PROP_DIS, 44, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RANGE1_SN_CMO_PROP_EN, 43, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RANGE1_SN_128B, 42, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_39, 39, 3)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RANGE0_SN_PCMO_PROP_DIS, 38, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RANGE0_SN_CMO_PROP_EN, 37, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RANGE0_SN_128B, 36, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_33, 33, 3)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN5_PCMO_PROP_DIS, 32, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN5_CMO_PROP_EN, 31, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN5_128B, 30, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_27, 27, 3)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN4_PCMO_PROP_DIS, 26, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN4_CMO_PROP_EN, 25, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN4_128B, 24, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_21, 21, 3)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN3_PCMO_PROP_DIS, 20, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN3_CMO_PROP_EN, 19, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN3_128B, 18, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_15, 15, 3)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN2_PCMO_PROP_DIS, 14, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN2_CMO_PROP_EN, 13, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN2_128B, 12, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, RESERVED_9, 9, 3)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN1_PCMO_PROP_DIS, 8, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN1_CMO_PROP_EN, 7, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN1_128B, 6, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN0_PCMO_PROP_DIS, 2, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN0_CMO_PROP_EN, 1, 1)
    FIELD(POR_HNF_SAM_SN_PROPERTIES_U_HNF_NID8, SN0_128B, 0, 1)
REG32(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, 0x100d20)
    FIELD(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, RESERVED_35, 35, 29)
    FIELD(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, HN_CFG_SN5_NODEID, 24, 11)
    FIELD(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, HN_CFG_SN4_NODEID, 12, 11)
    FIELD(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, RESERVED_11, 11, 1)
    FIELD(POR_HNF_SAM_6SN_NODEID_U_HNF_NID8, HN_CFG_SN3_NODEID, 0, 11)
REG32(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, 0x100d28)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, VALID_RA1, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, CPA_EN_RA1, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, CPA_GRP_RA1, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, REMOTE_RA1, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, NODEID_RA1, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, VALID_RA0, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, CPA_EN_RA0, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, CPA_GRP_RA0, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, REMOTE_RA0, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID0_U_HNF_NID8, NODEID_RA0, 0, 11)
REG32(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, 0x100d30)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, VALID_RA3, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, CPA_EN_RA3, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, CPA_GRP_RA3, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, REMOTE_RA3, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, NODEID_RA3, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, VALID_RA2, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, CPA_EN_RA2, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, CPA_GRP_RA2, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, REMOTE_RA2, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID1_U_HNF_NID8, NODEID_RA2, 0, 11)
REG32(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, 0x100d38)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, VALID_RA5, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, CPA_EN_RA5, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, CPA_GRP_RA5, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, REMOTE_RA5, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, NODEID_RA5, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, VALID_RA4, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, CPA_EN_RA4, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, CPA_GRP_RA4, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, REMOTE_RA4, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID2_U_HNF_NID8, NODEID_RA4, 0, 11)
REG32(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, 0x100d40)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, VALID_RA7, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, CPA_EN_RA7, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, CPA_GRP_RA7, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, REMOTE_RA7, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, NODEID_RA7, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, VALID_RA6, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, CPA_EN_RA6, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, CPA_GRP_RA6, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, REMOTE_RA6, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID3_U_HNF_NID8, NODEID_RA6, 0, 11)
REG32(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, 0x100d48)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, VALID_RA9, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, CPA_EN_RA9, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, CPA_GRP_RA9, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, REMOTE_RA9, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, NODEID_RA9, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, VALID_RA8, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, CPA_EN_RA8, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, CPA_GRP_RA8, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, REMOTE_RA8, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID4_U_HNF_NID8, NODEID_RA8, 0, 11)
REG32(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, 0x100d50)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, VALID_RA11, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, CPA_EN_RA11, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, CPA_GRP_RA11, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, REMOTE_RA11, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, NODEID_RA11, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, VALID_RA10, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, CPA_EN_RA10, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, CPA_GRP_RA10, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, REMOTE_RA10, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID5_U_HNF_NID8, NODEID_RA10, 0, 11)
REG32(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, 0x100d58)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, VALID_RA13, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, CPA_EN_RA13, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, CPA_GRP_RA13, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, REMOTE_RA13, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, NODEID_RA13, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, VALID_RA12, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, CPA_EN_RA12, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, CPA_GRP_RA12, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, REMOTE_RA12, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID6_U_HNF_NID8, NODEID_RA12, 0, 11)
REG32(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, 0x100d60)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, VALID_RA15, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, CPA_EN_RA15, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, CPA_GRP_RA15, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, REMOTE_RA15, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, NODEID_RA15, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, VALID_RA14, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, CPA_EN_RA14, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, CPA_GRP_RA14, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, REMOTE_RA14, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID7_U_HNF_NID8, NODEID_RA14, 0, 11)
REG32(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, 0x100d68)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, VALID_RA17, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, CPA_EN_RA17, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, CPA_GRP_RA17, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, REMOTE_RA17, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, NODEID_RA17, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, VALID_RA16, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, CPA_EN_RA16, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, CPA_GRP_RA16, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, REMOTE_RA16, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID8_U_HNF_NID8, NODEID_RA16, 0, 11)
REG32(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, 0x100d70)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, VALID_RA19, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, CPA_EN_RA19, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, CPA_GRP_RA19, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, REMOTE_RA19, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, NODEID_RA19, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, VALID_RA18, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, CPA_EN_RA18, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, CPA_GRP_RA18, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, REMOTE_RA18, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID9_U_HNF_NID8, NODEID_RA18, 0, 11)
REG32(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, 0x100d78)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, VALID_RA21, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, CPA_EN_RA21, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, CPA_GRP_RA21, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, REMOTE_RA21, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, NODEID_RA21, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, VALID_RA20, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, CPA_EN_RA20, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, CPA_GRP_RA20, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, REMOTE_RA20, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID10_U_HNF_NID8, NODEID_RA20, 0, 11)
REG32(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, 0x100d80)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, VALID_RA23, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, CPA_EN_RA23, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, CPA_GRP_RA23, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, REMOTE_RA23, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, NODEID_RA23, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, VALID_RA22, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, CPA_EN_RA22, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, CPA_GRP_RA22, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, REMOTE_RA22, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID11_U_HNF_NID8, NODEID_RA22, 0, 11)
REG32(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, 0x100d88)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, VALID_RA25, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, CPA_EN_RA25, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, CPA_GRP_RA25, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, REMOTE_RA25, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, NODEID_RA25, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, VALID_RA24, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, CPA_EN_RA24, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, CPA_GRP_RA24, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, REMOTE_RA24, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID12_U_HNF_NID8, NODEID_RA24, 0, 11)
REG32(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, 0x100d90)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, VALID_RA27, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, CPA_EN_RA27, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, CPA_GRP_RA27, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, REMOTE_RA27, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, NODEID_RA27, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, VALID_RA26, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, CPA_EN_RA26, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, CPA_GRP_RA26, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, REMOTE_RA26, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID13_U_HNF_NID8, NODEID_RA26, 0, 11)
REG32(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, 0x100d98)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, VALID_RA29, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, CPA_EN_RA29, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, CPA_GRP_RA29, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, REMOTE_RA29, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, NODEID_RA29, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, VALID_RA28, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, CPA_EN_RA28, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, CPA_GRP_RA28, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, REMOTE_RA28, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID14_U_HNF_NID8, NODEID_RA28, 0, 11)
REG32(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, 0x100da0)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, VALID_RA31, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, CPA_EN_RA31, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, CPA_GRP_RA31, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, REMOTE_RA31, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, NODEID_RA31, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, VALID_RA30, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, CPA_EN_RA30, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, CPA_GRP_RA30, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, REMOTE_RA30, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID15_U_HNF_NID8, NODEID_RA30, 0, 11)
REG32(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, 0x100da8)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, VALID_RA33, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, CPA_EN_RA33, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, CPA_GRP_RA33, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, REMOTE_RA33, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, NODEID_RA33, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, VALID_RA32, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, CPA_EN_RA32, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, CPA_GRP_RA32, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, REMOTE_RA32, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID16_U_HNF_NID8, NODEID_RA32, 0, 11)
REG32(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, 0x100db0)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, VALID_RA35, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, CPA_EN_RA35, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, CPA_GRP_RA35, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, REMOTE_RA35, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, NODEID_RA35, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, VALID_RA34, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, CPA_EN_RA34, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, CPA_GRP_RA34, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, REMOTE_RA34, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID17_U_HNF_NID8, NODEID_RA34, 0, 11)
REG32(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, 0x100db8)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, VALID_RA37, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, CPA_EN_RA37, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, CPA_GRP_RA37, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, REMOTE_RA37, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, NODEID_RA37, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, VALID_RA36, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, CPA_EN_RA36, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, CPA_GRP_RA36, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, REMOTE_RA36, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID18_U_HNF_NID8, NODEID_RA36, 0, 11)
REG32(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, 0x100dc0)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, VALID_RA39, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, CPA_EN_RA39, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, CPA_GRP_RA39, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, REMOTE_RA39, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, NODEID_RA39, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, VALID_RA38, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, CPA_EN_RA38, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, CPA_GRP_RA38, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, REMOTE_RA38, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID19_U_HNF_NID8, NODEID_RA38, 0, 11)
REG32(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, 0x100dc8)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, VALID_RA41, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, CPA_EN_RA41, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, CPA_GRP_RA41, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, REMOTE_RA41, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, NODEID_RA41, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, VALID_RA40, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, CPA_EN_RA40, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, CPA_GRP_RA40, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, REMOTE_RA40, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID20_U_HNF_NID8, NODEID_RA40, 0, 11)
REG32(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, 0x100dd0)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, VALID_RA43, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, CPA_EN_RA43, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, CPA_GRP_RA43, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, REMOTE_RA43, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, NODEID_RA43, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, VALID_RA42, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, CPA_EN_RA42, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, CPA_GRP_RA42, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, REMOTE_RA42, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID21_U_HNF_NID8, NODEID_RA42, 0, 11)
REG32(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, 0x100dd8)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, VALID_RA45, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, CPA_EN_RA45, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, CPA_GRP_RA45, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, REMOTE_RA45, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, NODEID_RA45, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, VALID_RA44, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, CPA_EN_RA44, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, CPA_GRP_RA44, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, REMOTE_RA44, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID22_U_HNF_NID8, NODEID_RA44, 0, 11)
REG32(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, 0x100de0)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, VALID_RA47, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, CPA_EN_RA47, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, CPA_GRP_RA47, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, REMOTE_RA47, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, NODEID_RA47, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, VALID_RA46, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, CPA_EN_RA46, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, CPA_GRP_RA46, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, REMOTE_RA46, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID23_U_HNF_NID8, NODEID_RA46, 0, 11)
REG32(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, 0x100de8)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, VALID_RA49, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, CPA_EN_RA49, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, CPA_GRP_RA49, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, REMOTE_RA49, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, NODEID_RA49, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, VALID_RA48, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, CPA_EN_RA48, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, CPA_GRP_RA48, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, REMOTE_RA48, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID24_U_HNF_NID8, NODEID_RA48, 0, 11)
REG32(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, 0x100df0)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, VALID_RA51, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, CPA_EN_RA51, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, CPA_GRP_RA51, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, REMOTE_RA51, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, NODEID_RA51, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, VALID_RA50, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, CPA_EN_RA50, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, CPA_GRP_RA50, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, REMOTE_RA50, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID25_U_HNF_NID8, NODEID_RA50, 0, 11)
REG32(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, 0x100df8)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, VALID_RA53, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, CPA_EN_RA53, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, CPA_GRP_RA53, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, REMOTE_RA53, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, NODEID_RA53, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, VALID_RA52, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, CPA_EN_RA52, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, CPA_GRP_RA52, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, REMOTE_RA52, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID26_U_HNF_NID8, NODEID_RA52, 0, 11)
REG32(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, 0x100e00)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, VALID_RA55, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, CPA_EN_RA55, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, CPA_GRP_RA55, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, REMOTE_RA55, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, NODEID_RA55, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, VALID_RA54, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, CPA_EN_RA54, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, CPA_GRP_RA54, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, REMOTE_RA54, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID27_U_HNF_NID8, NODEID_RA54, 0, 11)
REG32(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, 0x100e08)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, VALID_RA57, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, CPA_EN_RA57, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, CPA_GRP_RA57, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, REMOTE_RA57, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, NODEID_RA57, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, VALID_RA56, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, CPA_EN_RA56, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, CPA_GRP_RA56, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, REMOTE_RA56, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID28_U_HNF_NID8, NODEID_RA56, 0, 11)
REG32(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, 0x100e10)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, VALID_RA59, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, CPA_EN_RA59, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, CPA_GRP_RA59, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, REMOTE_RA59, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, NODEID_RA59, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, VALID_RA58, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, CPA_EN_RA58, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, CPA_GRP_RA58, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, REMOTE_RA58, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID29_U_HNF_NID8, NODEID_RA58, 0, 11)
REG32(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, 0x100e18)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, VALID_RA61, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, CPA_EN_RA61, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, CPA_GRP_RA61, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, REMOTE_RA61, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, NODEID_RA61, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, VALID_RA60, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, CPA_EN_RA60, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, CPA_GRP_RA60, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, REMOTE_RA60, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID30_U_HNF_NID8, NODEID_RA60, 0, 11)
REG32(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, 0x100e20)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, VALID_RA63, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, CPA_EN_RA63, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, CPA_GRP_RA63, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, REMOTE_RA63, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, NODEID_RA63, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, VALID_RA62, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, CPA_EN_RA62, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, CPA_GRP_RA62, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, REMOTE_RA62, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID31_U_HNF_NID8, NODEID_RA62, 0, 11)
REG32(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, 0x100e28)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, VALID_RA65, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, CPA_EN_RA65, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, CPA_GRP_RA65, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, REMOTE_RA65, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, NODEID_RA65, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, VALID_RA64, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, CPA_EN_RA64, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, CPA_GRP_RA64, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, REMOTE_RA64, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID32_U_HNF_NID8, NODEID_RA64, 0, 11)
REG32(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, 0x100e30)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, VALID_RA67, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, CPA_EN_RA67, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, CPA_GRP_RA67, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, REMOTE_RA67, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, NODEID_RA67, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, VALID_RA66, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, CPA_EN_RA66, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, CPA_GRP_RA66, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, REMOTE_RA66, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID33_U_HNF_NID8, NODEID_RA66, 0, 11)
REG32(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, 0x100e38)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, VALID_RA69, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, CPA_EN_RA69, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, CPA_GRP_RA69, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, REMOTE_RA69, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, NODEID_RA69, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, VALID_RA68, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, CPA_EN_RA68, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, CPA_GRP_RA68, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, REMOTE_RA68, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID34_U_HNF_NID8, NODEID_RA68, 0, 11)
REG32(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, 0x100e40)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, VALID_RA71, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, CPA_EN_RA71, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, CPA_GRP_RA71, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, REMOTE_RA71, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, NODEID_RA71, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, VALID_RA70, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, CPA_EN_RA70, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, CPA_GRP_RA70, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, REMOTE_RA70, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID35_U_HNF_NID8, NODEID_RA70, 0, 11)
REG32(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, 0x100e48)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, VALID_RA73, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, CPA_EN_RA73, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, CPA_GRP_RA73, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, REMOTE_RA73, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, NODEID_RA73, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, VALID_RA72, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, CPA_EN_RA72, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, CPA_GRP_RA72, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, REMOTE_RA72, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID36_U_HNF_NID8, NODEID_RA72, 0, 11)
REG32(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, 0x100e50)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, VALID_RA75, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, CPA_EN_RA75, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, CPA_GRP_RA75, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, REMOTE_RA75, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, NODEID_RA75, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, VALID_RA74, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, CPA_EN_RA74, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, CPA_GRP_RA74, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, REMOTE_RA74, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID37_U_HNF_NID8, NODEID_RA74, 0, 11)
REG32(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, 0x100e58)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, VALID_RA77, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, CPA_EN_RA77, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, CPA_GRP_RA77, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, REMOTE_RA77, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, NODEID_RA77, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, VALID_RA76, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, CPA_EN_RA76, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, CPA_GRP_RA76, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, REMOTE_RA76, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID38_U_HNF_NID8, NODEID_RA76, 0, 11)
REG32(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, 0x100e60)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, VALID_RA79, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, CPA_EN_RA79, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, CPA_GRP_RA79, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, REMOTE_RA79, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, NODEID_RA79, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, VALID_RA78, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, CPA_EN_RA78, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, CPA_GRP_RA78, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, REMOTE_RA78, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID39_U_HNF_NID8, NODEID_RA78, 0, 11)
REG32(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, 0x100e68)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, VALID_RA81, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, CPA_EN_RA81, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, CPA_GRP_RA81, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, REMOTE_RA81, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, NODEID_RA81, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, VALID_RA80, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, CPA_EN_RA80, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, CPA_GRP_RA80, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, REMOTE_RA80, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID40_U_HNF_NID8, NODEID_RA80, 0, 11)
REG32(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, 0x100e70)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, VALID_RA83, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, CPA_EN_RA83, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, CPA_GRP_RA83, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, REMOTE_RA83, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, NODEID_RA83, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, VALID_RA82, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, CPA_EN_RA82, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, CPA_GRP_RA82, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, REMOTE_RA82, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID41_U_HNF_NID8, NODEID_RA82, 0, 11)
REG32(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, 0x100e78)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, VALID_RA85, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, CPA_EN_RA85, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, CPA_GRP_RA85, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, REMOTE_RA85, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, NODEID_RA85, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, VALID_RA84, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, CPA_EN_RA84, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, CPA_GRP_RA84, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, REMOTE_RA84, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID42_U_HNF_NID8, NODEID_RA84, 0, 11)
REG32(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, 0x100e80)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, VALID_RA87, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, CPA_EN_RA87, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, CPA_GRP_RA87, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, REMOTE_RA87, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, NODEID_RA87, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, VALID_RA86, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, CPA_EN_RA86, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, CPA_GRP_RA86, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, REMOTE_RA86, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID43_U_HNF_NID8, NODEID_RA86, 0, 11)
REG32(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, 0x100e88)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, VALID_RA89, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, CPA_EN_RA89, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, CPA_GRP_RA89, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, REMOTE_RA89, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, NODEID_RA89, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, VALID_RA88, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, CPA_EN_RA88, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, CPA_GRP_RA88, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, REMOTE_RA88, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID44_U_HNF_NID8, NODEID_RA88, 0, 11)
REG32(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, 0x100e90)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, VALID_RA91, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, CPA_EN_RA91, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, CPA_GRP_RA91, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, REMOTE_RA91, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, NODEID_RA91, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, VALID_RA90, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, CPA_EN_RA90, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, CPA_GRP_RA90, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, REMOTE_RA90, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID45_U_HNF_NID8, NODEID_RA90, 0, 11)
REG32(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, 0x100e98)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, VALID_RA93, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, CPA_EN_RA93, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, CPA_GRP_RA93, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, REMOTE_RA93, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, NODEID_RA93, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, VALID_RA92, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, CPA_EN_RA92, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, CPA_GRP_RA92, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, REMOTE_RA92, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID46_U_HNF_NID8, NODEID_RA92, 0, 11)
REG32(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, 0x100ea0)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, VALID_RA95, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, CPA_EN_RA95, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, CPA_GRP_RA95, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, REMOTE_RA95, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, NODEID_RA95, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, VALID_RA94, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, CPA_EN_RA94, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, CPA_GRP_RA94, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, REMOTE_RA94, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID47_U_HNF_NID8, NODEID_RA94, 0, 11)
REG32(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, 0x100ea8)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, VALID_RA97, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, CPA_EN_RA97, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, CPA_GRP_RA97, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, REMOTE_RA97, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, NODEID_RA97, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, VALID_RA96, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, CPA_EN_RA96, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, CPA_GRP_RA96, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, REMOTE_RA96, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID48_U_HNF_NID8, NODEID_RA96, 0, 11)
REG32(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, 0x100eb0)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, VALID_RA99, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, CPA_EN_RA99, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, CPA_GRP_RA99, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, REMOTE_RA99, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, NODEID_RA99, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, VALID_RA98, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, CPA_EN_RA98, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, CPA_GRP_RA98, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, REMOTE_RA98, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID49_U_HNF_NID8, NODEID_RA98, 0, 11)
REG32(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, 0x100eb8)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, VALID_RA101, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, CPA_EN_RA101, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, CPA_GRP_RA101, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, REMOTE_RA101, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, NODEID_RA101, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, VALID_RA100, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, CPA_EN_RA100, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, CPA_GRP_RA100, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, REMOTE_RA100, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID50_U_HNF_NID8, NODEID_RA100, 0, 11)
REG32(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, 0x100ec0)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, VALID_RA103, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, CPA_EN_RA103, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, CPA_GRP_RA103, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, REMOTE_RA103, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, NODEID_RA103, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, VALID_RA102, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, CPA_EN_RA102, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, CPA_GRP_RA102, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, REMOTE_RA102, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID51_U_HNF_NID8, NODEID_RA102, 0, 11)
REG32(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, 0x100ec8)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, VALID_RA105, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, CPA_EN_RA105, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, CPA_GRP_RA105, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, REMOTE_RA105, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, NODEID_RA105, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, VALID_RA104, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, CPA_EN_RA104, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, CPA_GRP_RA104, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, REMOTE_RA104, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID52_U_HNF_NID8, NODEID_RA104, 0, 11)
REG32(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, 0x100ed0)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, VALID_RA107, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, CPA_EN_RA107, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, CPA_GRP_RA107, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, REMOTE_RA107, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, NODEID_RA107, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, VALID_RA106, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, CPA_EN_RA106, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, CPA_GRP_RA106, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, REMOTE_RA106, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID53_U_HNF_NID8, NODEID_RA106, 0, 11)
REG32(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, 0x100ed8)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, VALID_RA109, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, CPA_EN_RA109, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, CPA_GRP_RA109, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, REMOTE_RA109, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, NODEID_RA109, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, VALID_RA108, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, CPA_EN_RA108, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, CPA_GRP_RA108, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, REMOTE_RA108, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID54_U_HNF_NID8, NODEID_RA108, 0, 11)
REG32(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, 0x100ee0)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, VALID_RA111, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, CPA_EN_RA111, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, CPA_GRP_RA111, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, REMOTE_RA111, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, NODEID_RA111, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, VALID_RA110, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, CPA_EN_RA110, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, CPA_GRP_RA110, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, REMOTE_RA110, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID55_U_HNF_NID8, NODEID_RA110, 0, 11)
REG32(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, 0x100ee8)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, VALID_RA113, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, CPA_EN_RA113, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, CPA_GRP_RA113, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, REMOTE_RA113, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, NODEID_RA113, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, VALID_RA112, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, CPA_EN_RA112, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, CPA_GRP_RA112, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, REMOTE_RA112, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID56_U_HNF_NID8, NODEID_RA112, 0, 11)
REG32(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, 0x100ef0)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, VALID_RA115, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, CPA_EN_RA115, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, CPA_GRP_RA115, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, REMOTE_RA115, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, NODEID_RA115, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, VALID_RA114, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, CPA_EN_RA114, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, CPA_GRP_RA114, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, REMOTE_RA114, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID57_U_HNF_NID8, NODEID_RA114, 0, 11)
REG32(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, 0x100ef8)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, VALID_RA117, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, CPA_EN_RA117, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, CPA_GRP_RA117, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, REMOTE_RA117, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, NODEID_RA117, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, VALID_RA116, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, CPA_EN_RA116, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, CPA_GRP_RA116, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, REMOTE_RA116, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID58_U_HNF_NID8, NODEID_RA116, 0, 11)
REG32(POR_HNF_SF_CXG_BLOCKED_WAYS_U_HNF_NID8, 0x100f00)
    FIELD(POR_HNF_SF_CXG_BLOCKED_WAYS_U_HNF_NID8, SF_BLOCKED_WAYS, 0, 2)
REG32(POR_HNF_CML_PORT_AGGR_GRP0_ADD_MASK_U_HNF_NID8, 0x100f10)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_ADD_MASK_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_ADD_MASK_U_HNF_NID8, ADDR_MASK, 6, 42)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_ADD_MASK_U_HNF_NID8, RESERVED_0, 0, 6)
REG32(POR_HNF_CML_PORT_AGGR_GRP1_ADD_MASK_U_HNF_NID8, 0x100f18)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_ADD_MASK_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_ADD_MASK_U_HNF_NID8, ADDR_MASK, 6, 42)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_ADD_MASK_U_HNF_NID8, RESERVED_0, 0, 6)
REG32(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, 0x100f28)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, RESERVED_50, 50, 14)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, NUM_CXG_PAG0, 48, 2)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, RESERVED_47, 47, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, PAG0_TGTID3, 36, 11)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, RESERVED_35, 35, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, PAG0_TGTID2, 24, 11)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, PAG0_TGTID1, 12, 11)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, RESERVED_11, 11, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP0_REG_U_HNF_NID8, PAG0_TGTID0, 0, 11)
REG32(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, 0x100f30)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, RESERVED_50, 50, 14)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, NUM_CXG_PAG1, 48, 2)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, RESERVED_47, 47, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, PAG1_TGTID3, 36, 11)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, RESERVED_35, 35, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, PAG1_TGTID2, 24, 11)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, RESERVED_23, 23, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, PAG1_TGTID1, 12, 11)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, RESERVED_11, 11, 1)
    FIELD(POR_HNF_CML_PORT_AGGR_GRP1_REG_U_HNF_NID8, PAG1_TGTID0, 0, 11)
REG32(HN_SAM_HASH_ADDR_MASK_REG_U_HNF_NID8, 0x100f40)
    FIELD(HN_SAM_HASH_ADDR_MASK_REG_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(HN_SAM_HASH_ADDR_MASK_REG_U_HNF_NID8, ADDR_MASK, 6, 42)
    FIELD(HN_SAM_HASH_ADDR_MASK_REG_U_HNF_NID8, RESERVED_0, 0, 6)
REG32(HN_SAM_REGION_CMP_ADDR_MASK_REG_U_HNF_NID8, 0x100f48)
    FIELD(HN_SAM_REGION_CMP_ADDR_MASK_REG_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(HN_SAM_REGION_CMP_ADDR_MASK_REG_U_HNF_NID8, ADDR_MASK, 26, 22)
    FIELD(HN_SAM_REGION_CMP_ADDR_MASK_REG_U_HNF_NID8, RESERVED_0, 0, 26)
REG32(POR_HNF_ABF_LO_ADDR_U_HNF_NID8, 0x100f50)
    FIELD(POR_HNF_ABF_LO_ADDR_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(POR_HNF_ABF_LO_ADDR_U_HNF_NID8, ABF_LO_ADDR, 0, 48)
REG32(POR_HNF_ABF_HI_ADDR_U_HNF_NID8, 0x100f58)
    FIELD(POR_HNF_ABF_HI_ADDR_U_HNF_NID8, RESERVED_48, 48, 16)
    FIELD(POR_HNF_ABF_HI_ADDR_U_HNF_NID8, ABF_HI_ADDR, 0, 48)
REG32(POR_HNF_ABF_PR_U_HNF_NID8, 0x100f60)
    FIELD(POR_HNF_ABF_PR_U_HNF_NID8, ABF_MODE, 1, 2)
    FIELD(POR_HNF_ABF_PR_U_HNF_NID8, ABF_ENABLE, 0, 1)
REG32(POR_HNF_ABF_SR_U_HNF_NID8, 0x100f68)
    FIELD(POR_HNF_ABF_SR_U_HNF_NID8, ABF_SF_DISABLE_ABORT, 3, 1)
    FIELD(POR_HNF_ABF_SR_U_HNF_NID8, ABF_SF_PM_TRANSITION_ABORT, 2, 1)
    FIELD(POR_HNF_ABF_SR_U_HNF_NID8, ABF_INVALID_REQ_ABORT, 1, 1)
    FIELD(POR_HNF_ABF_SR_U_HNF_NID8, ABF_COMPLETE, 0, 1)
REG32(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, 0x100f70)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, VALID_RA119, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, CPA_EN_RA119, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, CPA_GRP_RA119, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, REMOTE_RA119, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, NODEID_RA119, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, VALID_RA118, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, CPA_EN_RA118, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, CPA_GRP_RA118, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, REMOTE_RA118, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID59_U_HNF_NID8, NODEID_RA118, 0, 11)
REG32(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, 0x100f78)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, VALID_RA121, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, CPA_EN_RA121, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, CPA_GRP_RA121, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, REMOTE_RA121, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, NODEID_RA121, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, VALID_RA120, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, CPA_EN_RA120, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, CPA_GRP_RA120, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, REMOTE_RA120, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID60_U_HNF_NID8, NODEID_RA120, 0, 11)
REG32(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, 0x100f80)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, VALID_RA123, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, CPA_EN_RA123, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, CPA_GRP_RA123, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, REMOTE_RA123, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, NODEID_RA123, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, VALID_RA122, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, CPA_EN_RA122, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, CPA_GRP_RA122, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, REMOTE_RA122, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID61_U_HNF_NID8, NODEID_RA122, 0, 11)
REG32(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, 0x100f88)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, VALID_RA125, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, CPA_EN_RA125, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, CPA_GRP_RA125, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, REMOTE_RA125, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, NODEID_RA125, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, VALID_RA124, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, CPA_EN_RA124, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, CPA_GRP_RA124, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, REMOTE_RA124, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID62_U_HNF_NID8, NODEID_RA124, 0, 11)
REG32(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, 0x100f90)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, VALID_RA127, 63, 1)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, CPA_EN_RA127, 62, 1)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, RESERVED_51, 51, 11)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, CPA_GRP_RA127, 49, 2)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, REMOTE_RA127, 48, 1)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, NODEID_RA127, 32, 11)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, VALID_RA126, 31, 1)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, CPA_EN_RA126, 30, 1)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, RESERVED_19, 19, 11)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, CPA_GRP_RA126, 17, 2)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, REMOTE_RA126, 16, 1)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_RN_PHYS_ID63_U_HNF_NID8, NODEID_RA126, 0, 11)
REG32(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, 0x100f98)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, VALID_CXHA1, 63, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, RESERVED_55, 55, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, STARTING_LDID_CXHA1, 48, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, SRCID_CXHA1, 32, 11)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, VALID_CXHA0, 31, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, RESERVED_23, 23, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, STARTING_LDID_CXHA0, 16, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG0_U_HNF_NID8, SRCID_CXHA0, 0, 11)
REG32(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, 0x100fa0)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, VALID_CXHA3, 63, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, RESERVED_55, 55, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, STARTING_LDID_CXHA3, 48, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, SRCID_CXHA3, 32, 11)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, VALID_CXHA2, 31, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, RESERVED_23, 23, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, STARTING_LDID_CXHA2, 16, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG1_U_HNF_NID8, SRCID_CXHA2, 0, 11)
REG32(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, 0x100fa8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, VALID_CXHA5, 63, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, RESERVED_55, 55, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, STARTING_LDID_CXHA5, 48, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, SRCID_CXHA5, 32, 11)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, VALID_CXHA4, 31, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, RESERVED_23, 23, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, STARTING_LDID_CXHA4, 16, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG2_U_HNF_NID8, SRCID_CXHA4, 0, 11)
REG32(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, 0x100fb0)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, VALID_CXHA7, 63, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, RESERVED_55, 55, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, STARTING_LDID_CXHA7, 48, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, RESERVED_43, 43, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, SRCID_CXHA7, 32, 11)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, VALID_CXHA6, 31, 1)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, RESERVED_23, 23, 8)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, STARTING_LDID_CXHA6, 16, 7)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, RESERVED_11, 11, 5)
    FIELD(POR_HNF_LDID_MAP_TABLE_REG3_U_HNF_NID8, SRCID_CXHA6, 0, 11)
REG32(POR_HNF_PPU_PWPR_U_HNF_NID8, 0x101000)
    FIELD(POR_HNF_PPU_PWPR_U_HNF_NID8, RESERVED_9, 9, 23)
    FIELD(POR_HNF_PPU_PWPR_U_HNF_NID8, DYN_EN, 8, 1)
    FIELD(POR_HNF_PPU_PWPR_U_HNF_NID8, OP_MODE, 4, 4)
    FIELD(POR_HNF_PPU_PWPR_U_HNF_NID8, POLICY, 0, 4)
REG32(POR_HNF_PPU_PWSR_U_HNF_NID8, 0x101008)
    FIELD(POR_HNF_PPU_PWSR_U_HNF_NID8, RESERVED_9, 9, 23)
    FIELD(POR_HNF_PPU_PWSR_U_HNF_NID8, DYN_EN_STATUS, 8, 1)
    FIELD(POR_HNF_PPU_PWSR_U_HNF_NID8, OP_MODE_STATUS, 4, 4)
    FIELD(POR_HNF_PPU_PWSR_U_HNF_NID8, POW_STATUS, 0, 4)
REG32(POR_HNF_PPU_MISR_U_HNF_NID8, 0x101014)
    FIELD(POR_HNF_PPU_MISR_U_HNF_NID8, PCSMACCEPT_STATUS, 0, 1)
REG32(POR_HNF_PPU_DYN_RET_THRESHOLD_U_HNF_NID8, 0x101100)
    FIELD(POR_HNF_PPU_DYN_RET_THRESHOLD_U_HNF_NID8, RESERVED_12, 12, 52)
    FIELD(POR_HNF_PPU_DYN_RET_THRESHOLD_U_HNF_NID8, DYN_RET_THRESHOLD, 0, 12)
REG32(POR_HNF_PPU_IDR0_U_HNF_NID8, 0x101fb0)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, RESERVED_30, 30, 2)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_WRM_RST_SPT, 29, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_ALL_ON_SPT, 28, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_FNC_RET_SPT, 27, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_FULL_RET_SPT, 26, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_MEM_OFF_SPT, 25, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_LGC_RET_SPT, 24, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_MEM_RET_EMU_SPT, 23, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_MEM_RET_SPT, 22, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_OFF_EMU_SPT, 21, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DYN_ALL_OFF_SPT, 20, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, RESERVED_19, 19, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_DBG_RECOV_SPT, 18, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_WRM_RST_SPT, 17, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_ALL_ON_SPT, 16, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_FNC_RET_SPT, 15, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_FULL_RET_SPT, 14, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_MEM_OFF_SPT, 13, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_LGC_RET_SPT, 12, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_MEM_RET_EMU_SPT, 11, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_MEM_RET_SPT, 10, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_OFF_EMU_SPT, 9, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, STA_ALL_OFF_SPT, 8, 1)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, NUM_OPMODES, 4, 4)
    FIELD(POR_HNF_PPU_IDR0_U_HNF_NID8, DEVCHAN, 0, 4)
REG32(POR_HNF_PPU_IDR1_U_HNF_NID8, 0x101fb4)
    FIELD(POR_HNF_PPU_IDR1_U_HNF_NID8, DYN_POLICY_MIN_IRQ_SPT, 3, 1)
    FIELD(POR_HNF_PPU_IDR1_U_HNF_NID8, OFF_LOCK_SPT, 2, 1)
    FIELD(POR_HNF_PPU_IDR1_U_HNF_NID8, SW_DEV_DEL_CONFIG_SPT, 1, 1)
    FIELD(POR_HNF_PPU_IDR1_U_HNF_NID8, PWR_MODE_ENTRY_DEL_SPT, 0, 1)
REG32(POR_HNF_PPU_IIDR_U_HNF_NID8, 0x101fc8)
    FIELD(POR_HNF_PPU_IIDR_U_HNF_NID8, PRODUCT_ID, 20, 12)
    FIELD(POR_HNF_PPU_IIDR_U_HNF_NID8, VARIANT, 16, 4)
    FIELD(POR_HNF_PPU_IIDR_U_HNF_NID8, REVISION, 12, 4)
    FIELD(POR_HNF_PPU_IIDR_U_HNF_NID8, IMPLEMENTER, 0, 12)
REG32(POR_HNF_PPU_AIDR_U_HNF_NID8, 0x101fcc)
    FIELD(POR_HNF_PPU_AIDR_U_HNF_NID8, ARCH_REV_MAJOR, 4, 4)
    FIELD(POR_HNF_PPU_AIDR_U_HNF_NID8, ARCH_REV_MINOR, 0, 4)
REG32(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, 0x102000)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, RESERVED_35, 35, 29)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, PMU_OCCUP1_ID, 32, 3)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, RESERVED_29, 29, 3)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, PMU_EVENT3_ID, 24, 5)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, RESERVED_21, 21, 3)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, PMU_EVENT2_ID, 16, 5)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, RESERVED_13, 13, 3)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, PMU_EVENT1_ID, 8, 5)
    FIELD(POR_HNF_PMU_EVENT_SEL_U_HNF_NID8, PMU_EVENT0_ID, 0, 5)
REG32(POR_HNF_ERRFR_U_HNF_NID8, 0x103000)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, RESERVED_15, 15, 49)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, CEC, 12, 3)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, CFI, 10, 2)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, FI, 6, 2)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, UI, 4, 2)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, DE, 2, 2)
    FIELD(POR_HNF_ERRFR_U_HNF_NID8, ED, 0, 2)
REG32(POR_HNF_ERRCTLR_U_HNF_NID8, 0x103008)
    FIELD(POR_HNF_ERRCTLR_U_HNF_NID8, RESERVED_9, 9, 55)
    FIELD(POR_HNF_ERRCTLR_U_HNF_NID8, CFI, 8, 1)
    FIELD(POR_HNF_ERRCTLR_U_HNF_NID8, FI, 3, 1)
    FIELD(POR_HNF_ERRCTLR_U_HNF_NID8, UI, 2, 1)
    FIELD(POR_HNF_ERRCTLR_U_HNF_NID8, DE, 1, 1)
    FIELD(POR_HNF_ERRCTLR_U_HNF_NID8, ED, 0, 1)
REG32(POR_HNF_ERRSTATUS_U_HNF_NID8, 0x103010)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, AV, 31, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, V, 30, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, UE, 29, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, RESERVED_28, 28, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, OF, 27, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, MV, 26, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, RESERVED_25, 25, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, CE, 24, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, DE, 23, 1)
    FIELD(POR_HNF_ERRSTATUS_U_HNF_NID8, RESERVED_0, 0, 23)
REG32(POR_HNF_ERRADDR_U_HNF_NID8, 0x103018)
    FIELD(POR_HNF_ERRADDR_U_HNF_NID8, NS, 63, 1)
    FIELD(POR_HNF_ERRADDR_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_ERRADDR_U_HNF_NID8, ADDR, 0, 48)
REG32(POR_HNF_ERRMISC_U_HNF_NID8, 0x103020)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, CECOF, 63, 1)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, SETMATCH, 62, 1)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, RESERVED_61, 61, 1)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, ERRSET, 48, 13)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, CEC, 32, 16)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, RESERVED_18, 18, 14)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, OPTYPE, 16, 2)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, RESERVED_15, 15, 1)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, SRCID, 4, 11)
    FIELD(POR_HNF_ERRMISC_U_HNF_NID8, ERRSRC, 0, 4)
REG32(POR_HNF_ERR_INJ_U_HNF_NID8, 0x103030)
    FIELD(POR_HNF_ERR_INJ_U_HNF_NID8, RESERVED_27, 27, 37)
    FIELD(POR_HNF_ERR_INJ_U_HNF_NID8, HNF_ERR_INJ_SRCID, 16, 11)
    FIELD(POR_HNF_ERR_INJ_U_HNF_NID8, RESERVED_9, 9, 7)
    FIELD(POR_HNF_ERR_INJ_U_HNF_NID8, HNF_ERR_INJ_LPID, 4, 5)
    FIELD(POR_HNF_ERR_INJ_U_HNF_NID8, HNF_ERR_INJ_EN, 0, 1)
REG32(POR_HNF_BYTE_PAR_ERR_INJ_U_HNF_NID8, 0x103038)
    FIELD(POR_HNF_BYTE_PAR_ERR_INJ_U_HNF_NID8, HNF_BYTE_PAR_ERR_INJ, 0, 5)
REG32(POR_HNF_ERRFR_NS_U_HNF_NID8, 0x103100)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, RESERVED_15, 15, 49)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, CEC, 12, 3)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, CFI, 10, 2)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, FI, 6, 2)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, UI, 4, 2)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, DE, 2, 2)
    FIELD(POR_HNF_ERRFR_NS_U_HNF_NID8, ED, 0, 2)
REG32(POR_HNF_ERRCTLR_NS_U_HNF_NID8, 0x103108)
    FIELD(POR_HNF_ERRCTLR_NS_U_HNF_NID8, RESERVED_9, 9, 55)
    FIELD(POR_HNF_ERRCTLR_NS_U_HNF_NID8, CFI, 8, 1)
    FIELD(POR_HNF_ERRCTLR_NS_U_HNF_NID8, FI, 3, 1)
    FIELD(POR_HNF_ERRCTLR_NS_U_HNF_NID8, UI, 2, 1)
    FIELD(POR_HNF_ERRCTLR_NS_U_HNF_NID8, DE, 1, 1)
    FIELD(POR_HNF_ERRCTLR_NS_U_HNF_NID8, ED, 0, 1)
REG32(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, 0x103110)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, RESERVED_32, 32, 32)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, AV, 31, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, V, 30, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, UE, 29, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, RESERVED_28, 28, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, OF, 27, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, MV, 26, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, RESERVED_25, 25, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, CE, 24, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, DE, 23, 1)
    FIELD(POR_HNF_ERRSTATUS_NS_U_HNF_NID8, RESERVED_0, 0, 23)
REG32(POR_HNF_ERRADDR_NS_U_HNF_NID8, 0x103118)
    FIELD(POR_HNF_ERRADDR_NS_U_HNF_NID8, NS, 63, 1)
    FIELD(POR_HNF_ERRADDR_NS_U_HNF_NID8, RESERVED_48, 48, 15)
    FIELD(POR_HNF_ERRADDR_NS_U_HNF_NID8, ADDR, 0, 48)
REG32(POR_HNF_ERRMISC_NS_U_HNF_NID8, 0x103120)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, CECOF, 63, 1)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, SETMATCH, 62, 1)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, RESERVED_61, 61, 1)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, ERRSET, 48, 13)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, CEC, 32, 16)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, RESERVED_18, 18, 14)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, OPTYPE, 16, 2)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, RESERVED_15, 15, 1)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, SRCID, 4, 11)
    FIELD(POR_HNF_ERRMISC_NS_U_HNF_NID8, ERRSRC, 0, 4)
REG32(POR_MXP_NODE_INFO_U_SMXP_0_1, 0x108000)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_1, LOGICAL_ID, 32, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_1, XY_ID, 16, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_0_1, NODE_TYPE, 0, 16)
REG32(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, 0x108008)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, NUM_DCS_P0_D3, 28, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, NUM_DCS_P0_D2, 24, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, NUM_DCS_P0_D1, 20, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, NUM_DCS_P0_D0, 16, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_0_1, DEVICE_TYPE_P0, 0, 5)
REG32(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, 0x108010)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, NUM_DCS_P1_D3, 28, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, NUM_DCS_P1_D2, 24, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, NUM_DCS_P1_D1, 20, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, NUM_DCS_P1_D0, 16, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_0_1, DEVICE_TYPE_P1, 0, 5)
REG32(POR_MXP_MESH_PORT_CONNECT_INFO_EAST_U_SMXP_0_1, 0x108018)
    FIELD(POR_MXP_MESH_PORT_CONNECT_INFO_EAST_U_SMXP_0_1, NUM_MCS_EAST, 0, 4)
REG32(POR_MXP_MESH_PORT_CONNECT_INFO_NORTH_U_SMXP_0_1, 0x108020)
    FIELD(POR_MXP_MESH_PORT_CONNECT_INFO_NORTH_U_SMXP_0_1, NUM_MCS_NORTH, 0, 4)
REG32(POR_MXP_CHILD_INFO_U_SMXP_0_1, 0x108080)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_0_1, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_0_1, CHILD_COUNT, 0, 16)
REG32(POR_MXP_CHILD_POINTER_0_U_SMXP_0_1, 0x108100)
    FIELD(POR_MXP_CHILD_POINTER_0_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_0_U_SMXP_0_1, RELATIVE_ADDRESS_0, 0, 32)
REG32(POR_MXP_CHILD_POINTER_1_U_SMXP_0_1, 0x108108)
    FIELD(POR_MXP_CHILD_POINTER_1_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_1_U_SMXP_0_1, RELATIVE_ADDRESS_1, 0, 32)
REG32(POR_MXP_CHILD_POINTER_2_U_SMXP_0_1, 0x108110)
    FIELD(POR_MXP_CHILD_POINTER_2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_2_U_SMXP_0_1, RELATIVE_ADDRESS_2, 0, 32)
REG32(POR_MXP_CHILD_POINTER_3_U_SMXP_0_1, 0x108118)
    FIELD(POR_MXP_CHILD_POINTER_3_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_3_U_SMXP_0_1, RELATIVE_ADDRESS_3, 0, 32)
REG32(POR_MXP_CHILD_POINTER_4_U_SMXP_0_1, 0x108120)
    FIELD(POR_MXP_CHILD_POINTER_4_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_4_U_SMXP_0_1, RELATIVE_ADDRESS_4, 0, 32)
REG32(POR_MXP_CHILD_POINTER_5_U_SMXP_0_1, 0x108128)
    FIELD(POR_MXP_CHILD_POINTER_5_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_5_U_SMXP_0_1, RELATIVE_ADDRESS_5, 0, 32)
REG32(POR_MXP_CHILD_POINTER_6_U_SMXP_0_1, 0x108130)
    FIELD(POR_MXP_CHILD_POINTER_6_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_6_U_SMXP_0_1, RELATIVE_ADDRESS_6, 0, 32)
REG32(POR_MXP_CHILD_POINTER_7_U_SMXP_0_1, 0x108138)
    FIELD(POR_MXP_CHILD_POINTER_7_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_7_U_SMXP_0_1, RELATIVE_ADDRESS_7, 0, 32)
REG32(POR_MXP_CHILD_POINTER_8_U_SMXP_0_1, 0x108140)
    FIELD(POR_MXP_CHILD_POINTER_8_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_8_U_SMXP_0_1, RELATIVE_ADDRESS_8, 0, 32)
REG32(POR_MXP_CHILD_POINTER_9_U_SMXP_0_1, 0x108148)
    FIELD(POR_MXP_CHILD_POINTER_9_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_9_U_SMXP_0_1, RELATIVE_ADDRESS_9, 0, 32)
REG32(POR_MXP_CHILD_POINTER_10_U_SMXP_0_1, 0x108150)
    FIELD(POR_MXP_CHILD_POINTER_10_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_10_U_SMXP_0_1, RELATIVE_ADDRESS_10, 0, 32)
REG32(POR_MXP_CHILD_POINTER_11_U_SMXP_0_1, 0x108158)
    FIELD(POR_MXP_CHILD_POINTER_11_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_11_U_SMXP_0_1, RELATIVE_ADDRESS_11, 0, 32)
REG32(POR_MXP_CHILD_POINTER_12_U_SMXP_0_1, 0x108160)
    FIELD(POR_MXP_CHILD_POINTER_12_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_12_U_SMXP_0_1, RELATIVE_ADDRESS_12, 0, 32)
REG32(POR_MXP_CHILD_POINTER_13_U_SMXP_0_1, 0x108168)
    FIELD(POR_MXP_CHILD_POINTER_13_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_13_U_SMXP_0_1, RELATIVE_ADDRESS_13, 0, 32)
REG32(POR_MXP_CHILD_POINTER_14_U_SMXP_0_1, 0x108170)
    FIELD(POR_MXP_CHILD_POINTER_14_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_14_U_SMXP_0_1, RELATIVE_ADDRESS_14, 0, 32)
REG32(POR_MXP_CHILD_POINTER_15_U_SMXP_0_1, 0x108178)
    FIELD(POR_MXP_CHILD_POINTER_15_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_15_U_SMXP_0_1, RELATIVE_ADDRESS_15, 0, 32)
REG32(POR_MXP_P0_INFO_U_SMXP_0_1, 0x108900)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, RESERVED_26, 26, 38)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, A4S_SAFE_XFACE_DISABLE_P0, 25, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, CHI_SAFE_XFACE_DISABLE_P0, 24, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, A4S_LOGICALID_BASE_P0, 16, 8)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, RESERVED_14, 14, 2)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, A4S_NUM_P0, 11, 3)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, RXBUF_NUM_ENTRIES_P0, 8, 3)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, EXT_SAM_EN_P0, 7, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, DATACHECK_EN_P0, 5, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, POISON_EN_P0, 4, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_0_1, NUM_DEV_P0, 0, 3)
REG32(POR_MXP_P1_INFO_U_SMXP_0_1, 0x108908)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, RESERVED_26, 26, 38)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, A4S_SAFE_XFACE_DISABLE_P1, 25, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, CHI_SAFE_XFACE_DISABLE_P1, 24, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, A4S_LOGICALID_BASE_P1, 16, 8)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, RESERVED_14, 14, 2)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, A4S_NUM_P1, 11, 3)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, RXBUF_NUM_ENTRIES_P1, 8, 3)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, EXT_SAM_EN_P1, 7, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, DATACHECK_EN_P1, 5, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, POISON_EN_P1, 4, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_0_1, NUM_DEV_P1, 0, 3)
REG32(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_0_1, 0x108980)
    FIELD(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_0_1, SYSCOREQ_CTL, 1, 1)
    FIELD(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_0_1, QOS, 0, 1)
REG32(POR_MXP_AUX_CTL_U_SMXP_0_1, 0x108a00)
    FIELD(POR_MXP_AUX_CTL_U_SMXP_0_1, CLKGATE_DISABLE, 0, 1)
REG32(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, 0x108a80)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, RESERVED_20, 20, 44)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, P0_QOS_OVERRIDE, 16, 4)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, P0_PQV_MODE, 6, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, P0_REG_MODE, 4, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, P0_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_0_1, P0_LAT_EN, 0, 1)
REG32(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_0_1, 0x108a88)
    FIELD(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_0_1, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_0_1, P0_LAT_TGT, 0, 12)
REG32(POR_MXP_P0_QOS_LAT_SCALE_U_SMXP_0_1, 0x108a90)
    FIELD(POR_MXP_P0_QOS_LAT_SCALE_U_SMXP_0_1, P0_LAT_SCALE, 0, 3)
REG32(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_1, 0x108a98)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_1, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_1, P0_LAT_MAX_QOS, 8, 4)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_0_1, P0_LAT_MIN_QOS, 0, 4)
REG32(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, 0x108aa0)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, RESERVED_20, 20, 44)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, P1_QOS_OVERRIDE, 16, 4)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, P1_PQV_MODE, 6, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, P1_REG_MODE, 4, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, P1_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_0_1, P1_LAT_EN, 0, 1)
REG32(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_0_1, 0x108aa8)
    FIELD(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_0_1, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_0_1, P1_LAT_TGT, 0, 12)
REG32(POR_MXP_P1_QOS_LAT_SCALE_U_SMXP_0_1, 0x108ab0)
    FIELD(POR_MXP_P1_QOS_LAT_SCALE_U_SMXP_0_1, P1_LAT_SCALE, 0, 3)
REG32(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_1, 0x108ab8)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_1, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_1, P1_LAT_MAX_QOS, 8, 4)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_0_1, P1_LAT_MIN_QOS, 0, 4)
REG32(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_1, 0x109000)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P0_D3, 3, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P0_D2, 2, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P0_D1, 1, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P0_D0, 0, 1)
REG32(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_1, 0x109008)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P1_D3, 3, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P1_D2, 2, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P1_D1, 1, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_0_1, SNPDVM_REQ_P1_D0, 0, 1)
REG32(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_1, 0x109010)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P0_D3, 3, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P0_D2, 2, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P0_D1, 1, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P0_D0, 0, 1)
REG32(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_1, 0x109018)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P1_D3, 3, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P1_D2, 2, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P1_D1, 1, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_0_1, SNPDVM_ACK_P1_D0, 0, 1)
REG32(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_1, 0x10a000)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_1, PMU_EVENT3_ID, 24, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_1, PMU_EVENT2_ID, 16, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_1, PMU_EVENT1_ID, 8, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_0_1, PMU_EVENT0_ID, 0, 8)
REG32(POR_DTM_CONTROL_U_SMXP_0_1, 0x10a100)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_1, TRACE_NO_ATB, 3, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_1, SAMPLE_PROFILE_ENABLE, 2, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_1, TRACE_TAG_ENABLE, 1, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_0_1, DTM_ENABLE, 0, 1)
REG32(POR_DTM_FIFO_ENTRY_READY_U_SMXP_0_1, 0x10a118)
    FIELD(POR_DTM_FIFO_ENTRY_READY_U_SMXP_0_1, READY, 0, 4)
REG32(POR_DTM_FIFO_ENTRY0_0_U_SMXP_0_1, 0x10a120)
REG32(POR_DTM_FIFO_ENTRY0_1_U_SMXP_0_1, 0x10a128)
REG32(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_1, 0x10a130)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_1, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_0_1, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY1_0_U_SMXP_0_1, 0x10a138)
REG32(POR_DTM_FIFO_ENTRY1_1_U_SMXP_0_1, 0x10a140)
REG32(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_1, 0x10a148)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_1, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_0_1, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY2_0_U_SMXP_0_1, 0x10a150)
REG32(POR_DTM_FIFO_ENTRY2_1_U_SMXP_0_1, 0x10a158)
REG32(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_1, 0x10a160)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_1, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_0_1, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY3_0_U_SMXP_0_1, 0x10a168)
REG32(POR_DTM_FIFO_ENTRY3_1_U_SMXP_0_1, 0x10a170)
REG32(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_1, 0x10a178)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_1, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_0_1, FIFO_DATA2, 0, 16)
REG32(POR_DTM_WP0_CONFIG_U_SMXP_0_1, 0x10a1a0)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_COMBINE, 6, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_0_1, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP0_VAL_U_SMXP_0_1, 0x10a1a8)
REG32(POR_DTM_WP0_MASK_U_SMXP_0_1, 0x10a1b0)
REG32(POR_DTM_WP1_CONFIG_U_SMXP_0_1, 0x10a1b8)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_0_1, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP1_VAL_U_SMXP_0_1, 0x10a1c0)
REG32(POR_DTM_WP1_MASK_U_SMXP_0_1, 0x10a1c8)
REG32(POR_DTM_WP2_CONFIG_U_SMXP_0_1, 0x10a1d0)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_COMBINE, 6, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_0_1, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP2_VAL_U_SMXP_0_1, 0x10a1d8)
REG32(POR_DTM_WP2_MASK_U_SMXP_0_1, 0x10a1e0)
REG32(POR_DTM_WP3_CONFIG_U_SMXP_0_1, 0x10a1e8)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_0_1, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP3_VAL_U_SMXP_0_1, 0x10a1f0)
REG32(POR_DTM_WP3_MASK_U_SMXP_0_1, 0x10a1f8)
REG32(POR_DTM_PMSICR_U_SMXP_0_1, 0x10a200)
    FIELD(POR_DTM_PMSICR_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_DTM_PMSICR_U_SMXP_0_1, COUNT, 0, 32)
REG32(POR_DTM_PMSIRR_U_SMXP_0_1, 0x10a208)
    FIELD(POR_DTM_PMSIRR_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_DTM_PMSIRR_U_SMXP_0_1, INTERVAL, 8, 24)
    FIELD(POR_DTM_PMSIRR_U_SMXP_0_1, RESERVED_0, 0, 8)
REG32(POR_DTM_PMU_CONFIG_U_SMXP_0_1, 0x10a210)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_62, 62, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT3_INPUT_SEL, 56, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_54, 54, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT2_INPUT_SEL, 48, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_46, 46, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT1_INPUT_SEL, 40, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_38, 38, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT0_INPUT_SEL, 32, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_31, 31, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT3_GLOBAL_NUM, 28, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_27, 27, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT2_GLOBAL_NUM, 24, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_23, 23, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT1_GLOBAL_NUM, 20, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_19, 19, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT0_GLOBAL_NUM, 16, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, RESERVED_9, 9, 7)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, CNTR_RST, 8, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT_PAIRED, 4, 4)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNTALL_COMBINED, 3, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT23_COMBINED, 2, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMEVCNT01_COMBINED, 1, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_0_1, PMU_EN, 0, 1)
REG32(POR_DTM_PMEVCNT_U_SMXP_0_1, 0x10a220)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_1, PMEVCNT3, 48, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_1, PMEVCNT2, 32, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_1, PMEVCNT1, 16, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_0_1, PMEVCNT0, 0, 16)
REG32(POR_DTM_PMEVCNTSR_U_SMXP_0_1, 0x10a240)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_1, PMEVCNTSR3, 48, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_1, PMEVCNTSR2, 32, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_1, PMEVCNTSR1, 16, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_0_1, PMEVCNTSR0, 0, 16)
REG32(POR_MXP_ERRFR_U_SMXP_0_1, 0x10b000)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, RESERVED_15, 15, 49)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, CEC, 12, 3)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, CFI, 10, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, DE, 2, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_0_1, ED, 0, 2)
REG32(POR_MXP_ERRCTLR_U_SMXP_0_1, 0x10b008)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_1, RESERVED_9, 9, 55)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_1, CFI, 8, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_1, DE, 1, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_0_1, ED, 0, 1)
REG32(POR_MXP_ERRSTATUS_U_SMXP_0_1, 0x10b010)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, AV, 31, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, MV, 26, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, RESERVED_25, 25, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, CE, 24, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_0_1, RESERVED_0, 0, 23)
REG32(POR_MXP_ERRMISC_U_SMXP_0_1, 0x10b028)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, RESERVED_59, 59, 5)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, TGTID, 48, 11)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, RESERVED_22, 22, 26)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, OPCODE, 16, 6)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, RESERVED_15, 15, 1)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, SRCID, 4, 11)
    FIELD(POR_MXP_ERRMISC_U_SMXP_0_1, ERRSRC, 0, 3)
REG32(POR_MXP_P0_BYTE_PAR_ERR_INJ_U_SMXP_0_1, 0x10b030)
    FIELD(POR_MXP_P0_BYTE_PAR_ERR_INJ_U_SMXP_0_1, P0_BYTE_PARITY_ERR_INJ, 0, 5)
REG32(POR_MXP_P1_BYTE_PAR_ERR_INJ_U_SMXP_0_1, 0x10b038)
    FIELD(POR_MXP_P1_BYTE_PAR_ERR_INJ_U_SMXP_0_1, P1_BYTE_PARITY_ERR_INJ, 0, 5)
REG32(POR_MXP_ERRFR_NS_U_SMXP_0_1, 0x10b100)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, RESERVED_15, 15, 49)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, CEC, 12, 3)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, CFI, 10, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, DE, 2, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_0_1, ED, 0, 2)
REG32(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, 0x10b108)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, RESERVED_9, 9, 55)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, CFI, 8, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, DE, 1, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_0_1, ED, 0, 1)
REG32(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, 0x10b110)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, AV, 31, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, MV, 26, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, RESERVED_25, 25, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, CE, 24, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_0_1, RESERVED_0, 0, 23)
REG32(POR_MXP_ERRMISC_NS_U_SMXP_0_1, 0x10b128)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, RESERVED_59, 59, 5)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, TGTID, 48, 11)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, RESERVED_22, 22, 26)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, OPCODE, 16, 6)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, RESERVED_15, 15, 1)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, SRCID, 4, 11)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_0_1, ERRSRC, 0, 3)
REG32(POR_FDC_NODE_INFO_U_SMXP_0_1, 0x12c000)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_1, LOGICAL_ID, 32, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_1, NODE_ID, 16, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_0_1, NODE_TYPE, 0, 16)
REG32(POR_FDC_CHILD_INFO_U_SMXP_0_1, 0x12c080)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_0_1, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_0_1, CHILD_COUNT, 0, 16)
REG32(POR_ERRFR_MXP_U_SMXP_0_1, 0x12f000)
    FIELD(POR_ERRFR_MXP_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_MXP_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_MXP_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_MXP_U_SMXP_0_1, 0x12f008)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_MXP_U_SMXP_0_1, 0x12f010)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_MXP_U_SMXP_0_1, 0x12f018)
    FIELD(POR_FDC_AUX_CTL_MXP_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_MXP_U_SMXP_0_1, RESERVED_0, 0, 4)
REG32(POR_ERRFR_P0_D0_U_SMXP_0_1, 0x12f040)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D0_U_SMXP_0_1, 0x12f048)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, 0x12f050)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D0_U_SMXP_0_1, 0x12f058)
    FIELD(POR_FDC_AUX_CTL_P0_D0_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D0_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D1_U_SMXP_0_1, 0x12f080)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D1_U_SMXP_0_1, 0x12f088)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, 0x12f090)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D1_U_SMXP_0_1, 0x12f098)
    FIELD(POR_FDC_AUX_CTL_P0_D1_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D1_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D2_U_SMXP_0_1, 0x12f0c0)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D2_U_SMXP_0_1, 0x12f0c8)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, 0x12f0d0)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D2_U_SMXP_0_1, 0x12f0d8)
    FIELD(POR_FDC_AUX_CTL_P0_D2_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D2_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D3_U_SMXP_0_1, 0x12f100)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D3_U_SMXP_0_1, 0x12f108)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, 0x12f110)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D3_U_SMXP_0_1, 0x12f118)
    FIELD(POR_FDC_AUX_CTL_P0_D3_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D3_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D0_U_SMXP_0_1, 0x12f140)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D0_U_SMXP_0_1, 0x12f148)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, 0x12f150)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D0_U_SMXP_0_1, 0x12f158)
    FIELD(POR_FDC_AUX_CTL_P1_D0_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D0_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D1_U_SMXP_0_1, 0x12f180)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D1_U_SMXP_0_1, 0x12f188)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, 0x12f190)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D1_U_SMXP_0_1, 0x12f198)
    FIELD(POR_FDC_AUX_CTL_P1_D1_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D1_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D2_U_SMXP_0_1, 0x12f1c0)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D2_U_SMXP_0_1, 0x12f1c8)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, 0x12f1d0)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D2_U_SMXP_0_1, 0x12f1d8)
    FIELD(POR_FDC_AUX_CTL_P1_D2_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D2_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D3_U_SMXP_0_1, 0x12f200)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_0_1, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_0_1, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_0_1, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D3_U_SMXP_0_1, 0x12f208)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_1, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_1, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_1, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_0_1, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, 0x12f210)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_0_1, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D3_U_SMXP_0_1, 0x12f218)
    FIELD(POR_FDC_AUX_CTL_P1_D3_U_SMXP_0_1, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D3_U_SMXP_0_1, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRINJECT_U_SMXP_0_1, 0x12f300)
    FIELD(POR_ERRINJECT_U_SMXP_0_1, ERR_DEV, 4, 4)
    FIELD(POR_ERRINJECT_U_SMXP_0_1, ERR_TYPE, 0, 4)
REG32(POR_FDC_KEY_U_SMXP_0_1, 0x12f308)
    FIELD(POR_FDC_KEY_U_SMXP_0_1, KEY, 0, 8)
REG32(POR_MPU_NODE_INFO_U_SMXP_0_1, 0x13c000)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_1, LOGICAL_ID, 32, 16)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_1, NODE_ID, 16, 16)
    FIELD(POR_MPU_NODE_INFO_U_SMXP_0_1, NODE_TYPE, 0, 16)
REG32(POR_MPU_CHILD_INFO_U_SMXP_0_1, 0x13c080)
    FIELD(POR_MPU_CHILD_INFO_U_SMXP_0_1, RESERVED_32, 32, 32)
    FIELD(POR_MPU_CHILD_INFO_U_SMXP_0_1, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MPU_CHILD_INFO_U_SMXP_0_1, CHILD_COUNT, 0, 16)
REG32(POR_MPU_UNIT_INFO_U_SMXP_0_1, 0x13c900)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, RESERVED_16, 16, 48)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_7_PRESENT, 15, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_6_PRESENT, 14, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_5_PRESENT, 13, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_4_PRESENT, 12, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_3_PRESENT, 11, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_2_PRESENT, 10, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_1_PRESENT, 9, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, MASTER_0_PRESENT, 8, 1)
    FIELD(POR_MPU_UNIT_INFO_U_SMXP_0_1, NUM_PROG_REGION, 0, 8)
REG32(POR_MPU_M0_CTL_U_SMXP_0_1, 0x13d000)
    FIELD(POR_MPU_M0_CTL_U_SMXP_0_1, M0_EN, 2, 1)
    FIELD(POR_MPU_M0_CTL_U_SMXP_0_1, M0_ACTION, 0, 2)
REG32(POR_MPU_M0_PRBAR0_U_SMXP_0_1, 0x13d010)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR0_U_SMXP_0_1, 0x13d018)
    FIELD(POR_MPU_M0_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR1_U_SMXP_0_1, 0x13d020)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR1_U_SMXP_0_1, 0x13d028)
    FIELD(POR_MPU_M0_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR2_U_SMXP_0_1, 0x13d030)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR2_U_SMXP_0_1, 0x13d038)
    FIELD(POR_MPU_M0_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR3_U_SMXP_0_1, 0x13d040)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR3_U_SMXP_0_1, 0x13d048)
    FIELD(POR_MPU_M0_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR4_U_SMXP_0_1, 0x13d050)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR4_U_SMXP_0_1, 0x13d058)
    FIELD(POR_MPU_M0_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR5_U_SMXP_0_1, 0x13d060)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR5_U_SMXP_0_1, 0x13d068)
    FIELD(POR_MPU_M0_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR6_U_SMXP_0_1, 0x13d070)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR6_U_SMXP_0_1, 0x13d078)
    FIELD(POR_MPU_M0_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR7_U_SMXP_0_1, 0x13d080)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR7_U_SMXP_0_1, 0x13d088)
    FIELD(POR_MPU_M0_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR8_U_SMXP_0_1, 0x13d090)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR8_U_SMXP_0_1, 0x13d098)
    FIELD(POR_MPU_M0_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR9_U_SMXP_0_1, 0x13d0a0)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR9_U_SMXP_0_1, 0x13d0a8)
    FIELD(POR_MPU_M0_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR10_U_SMXP_0_1, 0x13d0b0)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR10_U_SMXP_0_1, 0x13d0b8)
    FIELD(POR_MPU_M0_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR11_U_SMXP_0_1, 0x13d0c0)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR11_U_SMXP_0_1, 0x13d0c8)
    FIELD(POR_MPU_M0_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR12_U_SMXP_0_1, 0x13d0d0)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR12_U_SMXP_0_1, 0x13d0d8)
    FIELD(POR_MPU_M0_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR13_U_SMXP_0_1, 0x13d0e0)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR13_U_SMXP_0_1, 0x13d0e8)
    FIELD(POR_MPU_M0_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR14_U_SMXP_0_1, 0x13d0f0)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR14_U_SMXP_0_1, 0x13d0f8)
    FIELD(POR_MPU_M0_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR15_U_SMXP_0_1, 0x13d100)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR15_U_SMXP_0_1, 0x13d108)
    FIELD(POR_MPU_M0_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR16_U_SMXP_0_1, 0x13d110)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR16_U_SMXP_0_1, 0x13d118)
    FIELD(POR_MPU_M0_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR17_U_SMXP_0_1, 0x13d120)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR17_U_SMXP_0_1, 0x13d128)
    FIELD(POR_MPU_M0_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR18_U_SMXP_0_1, 0x13d130)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR18_U_SMXP_0_1, 0x13d138)
    FIELD(POR_MPU_M0_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR19_U_SMXP_0_1, 0x13d140)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR19_U_SMXP_0_1, 0x13d148)
    FIELD(POR_MPU_M0_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR20_U_SMXP_0_1, 0x13d150)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR20_U_SMXP_0_1, 0x13d158)
    FIELD(POR_MPU_M0_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR21_U_SMXP_0_1, 0x13d160)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR21_U_SMXP_0_1, 0x13d168)
    FIELD(POR_MPU_M0_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR22_U_SMXP_0_1, 0x13d170)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR22_U_SMXP_0_1, 0x13d178)
    FIELD(POR_MPU_M0_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR23_U_SMXP_0_1, 0x13d180)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR23_U_SMXP_0_1, 0x13d188)
    FIELD(POR_MPU_M0_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR24_U_SMXP_0_1, 0x13d190)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR24_U_SMXP_0_1, 0x13d198)
    FIELD(POR_MPU_M0_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR25_U_SMXP_0_1, 0x13d1a0)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR25_U_SMXP_0_1, 0x13d1a8)
    FIELD(POR_MPU_M0_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR26_U_SMXP_0_1, 0x13d1b0)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR26_U_SMXP_0_1, 0x13d1b8)
    FIELD(POR_MPU_M0_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR27_U_SMXP_0_1, 0x13d1c0)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR27_U_SMXP_0_1, 0x13d1c8)
    FIELD(POR_MPU_M0_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR28_U_SMXP_0_1, 0x13d1d0)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR28_U_SMXP_0_1, 0x13d1d8)
    FIELD(POR_MPU_M0_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR29_U_SMXP_0_1, 0x13d1e0)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR29_U_SMXP_0_1, 0x13d1e8)
    FIELD(POR_MPU_M0_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR30_U_SMXP_0_1, 0x13d1f0)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR30_U_SMXP_0_1, 0x13d1f8)
    FIELD(POR_MPU_M0_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR31_U_SMXP_0_1, 0x13d200)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR31_U_SMXP_0_1, 0x13d208)
    FIELD(POR_MPU_M0_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M1_CTL_U_SMXP_0_1, 0x13d400)
    FIELD(POR_MPU_M1_CTL_U_SMXP_0_1, M1_EN, 2, 1)
    FIELD(POR_MPU_M1_CTL_U_SMXP_0_1, M1_ACTION, 0, 2)
REG32(POR_MPU_M1_PRBAR0_U_SMXP_0_1, 0x13d410)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR0_U_SMXP_0_1, 0x13d418)
    FIELD(POR_MPU_M1_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR1_U_SMXP_0_1, 0x13d420)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR1_U_SMXP_0_1, 0x13d428)
    FIELD(POR_MPU_M1_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR2_U_SMXP_0_1, 0x13d430)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR2_U_SMXP_0_1, 0x13d438)
    FIELD(POR_MPU_M1_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR3_U_SMXP_0_1, 0x13d440)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR3_U_SMXP_0_1, 0x13d448)
    FIELD(POR_MPU_M1_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR4_U_SMXP_0_1, 0x13d450)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR4_U_SMXP_0_1, 0x13d458)
    FIELD(POR_MPU_M1_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR5_U_SMXP_0_1, 0x13d460)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR5_U_SMXP_0_1, 0x13d468)
    FIELD(POR_MPU_M1_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR6_U_SMXP_0_1, 0x13d470)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR6_U_SMXP_0_1, 0x13d478)
    FIELD(POR_MPU_M1_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR7_U_SMXP_0_1, 0x13d480)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR7_U_SMXP_0_1, 0x13d488)
    FIELD(POR_MPU_M1_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR8_U_SMXP_0_1, 0x13d490)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR8_U_SMXP_0_1, 0x13d498)
    FIELD(POR_MPU_M1_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR9_U_SMXP_0_1, 0x13d4a0)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR9_U_SMXP_0_1, 0x13d4a8)
    FIELD(POR_MPU_M1_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR10_U_SMXP_0_1, 0x13d4b0)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR10_U_SMXP_0_1, 0x13d4b8)
    FIELD(POR_MPU_M1_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR11_U_SMXP_0_1, 0x13d4c0)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR11_U_SMXP_0_1, 0x13d4c8)
    FIELD(POR_MPU_M1_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR12_U_SMXP_0_1, 0x13d4d0)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR12_U_SMXP_0_1, 0x13d4d8)
    FIELD(POR_MPU_M1_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR13_U_SMXP_0_1, 0x13d4e0)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR13_U_SMXP_0_1, 0x13d4e8)
    FIELD(POR_MPU_M1_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR14_U_SMXP_0_1, 0x13d4f0)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR14_U_SMXP_0_1, 0x13d4f8)
    FIELD(POR_MPU_M1_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR15_U_SMXP_0_1, 0x13d500)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR15_U_SMXP_0_1, 0x13d508)
    FIELD(POR_MPU_M1_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR16_U_SMXP_0_1, 0x13d510)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR16_U_SMXP_0_1, 0x13d518)
    FIELD(POR_MPU_M1_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR17_U_SMXP_0_1, 0x13d520)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR17_U_SMXP_0_1, 0x13d528)
    FIELD(POR_MPU_M1_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR18_U_SMXP_0_1, 0x13d530)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR18_U_SMXP_0_1, 0x13d538)
    FIELD(POR_MPU_M1_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR19_U_SMXP_0_1, 0x13d540)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR19_U_SMXP_0_1, 0x13d548)
    FIELD(POR_MPU_M1_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR20_U_SMXP_0_1, 0x13d550)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR20_U_SMXP_0_1, 0x13d558)
    FIELD(POR_MPU_M1_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR21_U_SMXP_0_1, 0x13d560)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR21_U_SMXP_0_1, 0x13d568)
    FIELD(POR_MPU_M1_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR22_U_SMXP_0_1, 0x13d570)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR22_U_SMXP_0_1, 0x13d578)
    FIELD(POR_MPU_M1_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR23_U_SMXP_0_1, 0x13d580)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR23_U_SMXP_0_1, 0x13d588)
    FIELD(POR_MPU_M1_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR24_U_SMXP_0_1, 0x13d590)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR24_U_SMXP_0_1, 0x13d598)
    FIELD(POR_MPU_M1_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR25_U_SMXP_0_1, 0x13d5a0)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR25_U_SMXP_0_1, 0x13d5a8)
    FIELD(POR_MPU_M1_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR26_U_SMXP_0_1, 0x13d5b0)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR26_U_SMXP_0_1, 0x13d5b8)
    FIELD(POR_MPU_M1_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR27_U_SMXP_0_1, 0x13d5c0)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR27_U_SMXP_0_1, 0x13d5c8)
    FIELD(POR_MPU_M1_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR28_U_SMXP_0_1, 0x13d5d0)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR28_U_SMXP_0_1, 0x13d5d8)
    FIELD(POR_MPU_M1_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR29_U_SMXP_0_1, 0x13d5e0)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR29_U_SMXP_0_1, 0x13d5e8)
    FIELD(POR_MPU_M1_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR30_U_SMXP_0_1, 0x13d5f0)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR30_U_SMXP_0_1, 0x13d5f8)
    FIELD(POR_MPU_M1_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR31_U_SMXP_0_1, 0x13d600)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR31_U_SMXP_0_1, 0x13d608)
    FIELD(POR_MPU_M1_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M2_CTL_U_SMXP_0_1, 0x13d800)
    FIELD(POR_MPU_M2_CTL_U_SMXP_0_1, M2_EN, 2, 1)
    FIELD(POR_MPU_M2_CTL_U_SMXP_0_1, M2_ACTION, 0, 2)
REG32(POR_MPU_M2_PRBAR0_U_SMXP_0_1, 0x13d810)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR0_U_SMXP_0_1, 0x13d818)
    FIELD(POR_MPU_M2_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR1_U_SMXP_0_1, 0x13d820)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR1_U_SMXP_0_1, 0x13d828)
    FIELD(POR_MPU_M2_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR2_U_SMXP_0_1, 0x13d830)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR2_U_SMXP_0_1, 0x13d838)
    FIELD(POR_MPU_M2_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR3_U_SMXP_0_1, 0x13d840)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR3_U_SMXP_0_1, 0x13d848)
    FIELD(POR_MPU_M2_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR4_U_SMXP_0_1, 0x13d850)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR4_U_SMXP_0_1, 0x13d858)
    FIELD(POR_MPU_M2_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR5_U_SMXP_0_1, 0x13d860)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR5_U_SMXP_0_1, 0x13d868)
    FIELD(POR_MPU_M2_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR6_U_SMXP_0_1, 0x13d870)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR6_U_SMXP_0_1, 0x13d878)
    FIELD(POR_MPU_M2_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR7_U_SMXP_0_1, 0x13d880)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR7_U_SMXP_0_1, 0x13d888)
    FIELD(POR_MPU_M2_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR8_U_SMXP_0_1, 0x13d890)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR8_U_SMXP_0_1, 0x13d898)
    FIELD(POR_MPU_M2_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR9_U_SMXP_0_1, 0x13d8a0)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR9_U_SMXP_0_1, 0x13d8a8)
    FIELD(POR_MPU_M2_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR10_U_SMXP_0_1, 0x13d8b0)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR10_U_SMXP_0_1, 0x13d8b8)
    FIELD(POR_MPU_M2_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR11_U_SMXP_0_1, 0x13d8c0)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR11_U_SMXP_0_1, 0x13d8c8)
    FIELD(POR_MPU_M2_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR12_U_SMXP_0_1, 0x13d8d0)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR12_U_SMXP_0_1, 0x13d8d8)
    FIELD(POR_MPU_M2_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR13_U_SMXP_0_1, 0x13d8e0)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR13_U_SMXP_0_1, 0x13d8e8)
    FIELD(POR_MPU_M2_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR14_U_SMXP_0_1, 0x13d8f0)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR14_U_SMXP_0_1, 0x13d8f8)
    FIELD(POR_MPU_M2_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR15_U_SMXP_0_1, 0x13d900)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR15_U_SMXP_0_1, 0x13d908)
    FIELD(POR_MPU_M2_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR16_U_SMXP_0_1, 0x13d910)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR16_U_SMXP_0_1, 0x13d918)
    FIELD(POR_MPU_M2_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR17_U_SMXP_0_1, 0x13d920)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR17_U_SMXP_0_1, 0x13d928)
    FIELD(POR_MPU_M2_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR18_U_SMXP_0_1, 0x13d930)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR18_U_SMXP_0_1, 0x13d938)
    FIELD(POR_MPU_M2_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR19_U_SMXP_0_1, 0x13d940)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR19_U_SMXP_0_1, 0x13d948)
    FIELD(POR_MPU_M2_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR20_U_SMXP_0_1, 0x13d950)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR20_U_SMXP_0_1, 0x13d958)
    FIELD(POR_MPU_M2_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR21_U_SMXP_0_1, 0x13d960)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR21_U_SMXP_0_1, 0x13d968)
    FIELD(POR_MPU_M2_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR22_U_SMXP_0_1, 0x13d970)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR22_U_SMXP_0_1, 0x13d978)
    FIELD(POR_MPU_M2_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR23_U_SMXP_0_1, 0x13d980)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR23_U_SMXP_0_1, 0x13d988)
    FIELD(POR_MPU_M2_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR24_U_SMXP_0_1, 0x13d990)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR24_U_SMXP_0_1, 0x13d998)
    FIELD(POR_MPU_M2_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR25_U_SMXP_0_1, 0x13d9a0)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR25_U_SMXP_0_1, 0x13d9a8)
    FIELD(POR_MPU_M2_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR26_U_SMXP_0_1, 0x13d9b0)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR26_U_SMXP_0_1, 0x13d9b8)
    FIELD(POR_MPU_M2_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR27_U_SMXP_0_1, 0x13d9c0)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR27_U_SMXP_0_1, 0x13d9c8)
    FIELD(POR_MPU_M2_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR28_U_SMXP_0_1, 0x13d9d0)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR28_U_SMXP_0_1, 0x13d9d8)
    FIELD(POR_MPU_M2_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR29_U_SMXP_0_1, 0x13d9e0)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR29_U_SMXP_0_1, 0x13d9e8)
    FIELD(POR_MPU_M2_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR30_U_SMXP_0_1, 0x13d9f0)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR30_U_SMXP_0_1, 0x13d9f8)
    FIELD(POR_MPU_M2_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR31_U_SMXP_0_1, 0x13da00)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR31_U_SMXP_0_1, 0x13da08)
    FIELD(POR_MPU_M2_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M3_CTL_U_SMXP_0_1, 0x13dc00)
    FIELD(POR_MPU_M3_CTL_U_SMXP_0_1, M3_EN, 2, 1)
    FIELD(POR_MPU_M3_CTL_U_SMXP_0_1, M3_ACTION, 0, 2)
REG32(POR_MPU_M3_PRBAR0_U_SMXP_0_1, 0x13dc10)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR0_U_SMXP_0_1, 0x13dc18)
    FIELD(POR_MPU_M3_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR1_U_SMXP_0_1, 0x13dc20)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR1_U_SMXP_0_1, 0x13dc28)
    FIELD(POR_MPU_M3_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR2_U_SMXP_0_1, 0x13dc30)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR2_U_SMXP_0_1, 0x13dc38)
    FIELD(POR_MPU_M3_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR3_U_SMXP_0_1, 0x13dc40)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR3_U_SMXP_0_1, 0x13dc48)
    FIELD(POR_MPU_M3_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR4_U_SMXP_0_1, 0x13dc50)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR4_U_SMXP_0_1, 0x13dc58)
    FIELD(POR_MPU_M3_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR5_U_SMXP_0_1, 0x13dc60)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR5_U_SMXP_0_1, 0x13dc68)
    FIELD(POR_MPU_M3_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR6_U_SMXP_0_1, 0x13dc70)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR6_U_SMXP_0_1, 0x13dc78)
    FIELD(POR_MPU_M3_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR7_U_SMXP_0_1, 0x13dc80)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR7_U_SMXP_0_1, 0x13dc88)
    FIELD(POR_MPU_M3_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR8_U_SMXP_0_1, 0x13dc90)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR8_U_SMXP_0_1, 0x13dc98)
    FIELD(POR_MPU_M3_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR9_U_SMXP_0_1, 0x13dca0)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR9_U_SMXP_0_1, 0x13dca8)
    FIELD(POR_MPU_M3_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR10_U_SMXP_0_1, 0x13dcb0)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR10_U_SMXP_0_1, 0x13dcb8)
    FIELD(POR_MPU_M3_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR11_U_SMXP_0_1, 0x13dcc0)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR11_U_SMXP_0_1, 0x13dcc8)
    FIELD(POR_MPU_M3_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR12_U_SMXP_0_1, 0x13dcd0)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR12_U_SMXP_0_1, 0x13dcd8)
    FIELD(POR_MPU_M3_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR13_U_SMXP_0_1, 0x13dce0)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR13_U_SMXP_0_1, 0x13dce8)
    FIELD(POR_MPU_M3_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR14_U_SMXP_0_1, 0x13dcf0)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR14_U_SMXP_0_1, 0x13dcf8)
    FIELD(POR_MPU_M3_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR15_U_SMXP_0_1, 0x13dd00)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR15_U_SMXP_0_1, 0x13dd08)
    FIELD(POR_MPU_M3_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR16_U_SMXP_0_1, 0x13dd10)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR16_U_SMXP_0_1, 0x13dd18)
    FIELD(POR_MPU_M3_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR17_U_SMXP_0_1, 0x13dd20)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR17_U_SMXP_0_1, 0x13dd28)
    FIELD(POR_MPU_M3_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR18_U_SMXP_0_1, 0x13dd30)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR18_U_SMXP_0_1, 0x13dd38)
    FIELD(POR_MPU_M3_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR19_U_SMXP_0_1, 0x13dd40)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR19_U_SMXP_0_1, 0x13dd48)
    FIELD(POR_MPU_M3_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR20_U_SMXP_0_1, 0x13dd50)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR20_U_SMXP_0_1, 0x13dd58)
    FIELD(POR_MPU_M3_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR21_U_SMXP_0_1, 0x13dd60)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR21_U_SMXP_0_1, 0x13dd68)
    FIELD(POR_MPU_M3_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR22_U_SMXP_0_1, 0x13dd70)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR22_U_SMXP_0_1, 0x13dd78)
    FIELD(POR_MPU_M3_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR23_U_SMXP_0_1, 0x13dd80)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR23_U_SMXP_0_1, 0x13dd88)
    FIELD(POR_MPU_M3_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR24_U_SMXP_0_1, 0x13dd90)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR24_U_SMXP_0_1, 0x13dd98)
    FIELD(POR_MPU_M3_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR25_U_SMXP_0_1, 0x13dda0)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR25_U_SMXP_0_1, 0x13dda8)
    FIELD(POR_MPU_M3_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR26_U_SMXP_0_1, 0x13ddb0)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR26_U_SMXP_0_1, 0x13ddb8)
    FIELD(POR_MPU_M3_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR27_U_SMXP_0_1, 0x13ddc0)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR27_U_SMXP_0_1, 0x13ddc8)
    FIELD(POR_MPU_M3_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR28_U_SMXP_0_1, 0x13ddd0)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR28_U_SMXP_0_1, 0x13ddd8)
    FIELD(POR_MPU_M3_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR29_U_SMXP_0_1, 0x13dde0)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR29_U_SMXP_0_1, 0x13dde8)
    FIELD(POR_MPU_M3_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR30_U_SMXP_0_1, 0x13ddf0)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR30_U_SMXP_0_1, 0x13ddf8)
    FIELD(POR_MPU_M3_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR31_U_SMXP_0_1, 0x13de00)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR31_U_SMXP_0_1, 0x13de08)
    FIELD(POR_MPU_M3_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M4_CTL_U_SMXP_0_1, 0x13e000)
    FIELD(POR_MPU_M4_CTL_U_SMXP_0_1, M4_EN, 2, 1)
    FIELD(POR_MPU_M4_CTL_U_SMXP_0_1, M4_ACTION, 0, 2)
REG32(POR_MPU_M4_PRBAR0_U_SMXP_0_1, 0x13e010)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR0_U_SMXP_0_1, 0x13e018)
    FIELD(POR_MPU_M4_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR1_U_SMXP_0_1, 0x13e020)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR1_U_SMXP_0_1, 0x13e028)
    FIELD(POR_MPU_M4_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR2_U_SMXP_0_1, 0x13e030)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR2_U_SMXP_0_1, 0x13e038)
    FIELD(POR_MPU_M4_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR3_U_SMXP_0_1, 0x13e040)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR3_U_SMXP_0_1, 0x13e048)
    FIELD(POR_MPU_M4_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR4_U_SMXP_0_1, 0x13e050)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR4_U_SMXP_0_1, 0x13e058)
    FIELD(POR_MPU_M4_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR5_U_SMXP_0_1, 0x13e060)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR5_U_SMXP_0_1, 0x13e068)
    FIELD(POR_MPU_M4_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR6_U_SMXP_0_1, 0x13e070)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR6_U_SMXP_0_1, 0x13e078)
    FIELD(POR_MPU_M4_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR7_U_SMXP_0_1, 0x13e080)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR7_U_SMXP_0_1, 0x13e088)
    FIELD(POR_MPU_M4_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR8_U_SMXP_0_1, 0x13e090)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR8_U_SMXP_0_1, 0x13e098)
    FIELD(POR_MPU_M4_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR9_U_SMXP_0_1, 0x13e0a0)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR9_U_SMXP_0_1, 0x13e0a8)
    FIELD(POR_MPU_M4_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR10_U_SMXP_0_1, 0x13e0b0)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR10_U_SMXP_0_1, 0x13e0b8)
    FIELD(POR_MPU_M4_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR11_U_SMXP_0_1, 0x13e0c0)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR11_U_SMXP_0_1, 0x13e0c8)
    FIELD(POR_MPU_M4_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR12_U_SMXP_0_1, 0x13e0d0)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR12_U_SMXP_0_1, 0x13e0d8)
    FIELD(POR_MPU_M4_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR13_U_SMXP_0_1, 0x13e0e0)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR13_U_SMXP_0_1, 0x13e0e8)
    FIELD(POR_MPU_M4_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR14_U_SMXP_0_1, 0x13e0f0)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR14_U_SMXP_0_1, 0x13e0f8)
    FIELD(POR_MPU_M4_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR15_U_SMXP_0_1, 0x13e100)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR15_U_SMXP_0_1, 0x13e108)
    FIELD(POR_MPU_M4_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR16_U_SMXP_0_1, 0x13e110)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR16_U_SMXP_0_1, 0x13e118)
    FIELD(POR_MPU_M4_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR17_U_SMXP_0_1, 0x13e120)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR17_U_SMXP_0_1, 0x13e128)
    FIELD(POR_MPU_M4_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR18_U_SMXP_0_1, 0x13e130)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR18_U_SMXP_0_1, 0x13e138)
    FIELD(POR_MPU_M4_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR19_U_SMXP_0_1, 0x13e140)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR19_U_SMXP_0_1, 0x13e148)
    FIELD(POR_MPU_M4_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR20_U_SMXP_0_1, 0x13e150)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR20_U_SMXP_0_1, 0x13e158)
    FIELD(POR_MPU_M4_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR21_U_SMXP_0_1, 0x13e160)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR21_U_SMXP_0_1, 0x13e168)
    FIELD(POR_MPU_M4_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR22_U_SMXP_0_1, 0x13e170)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR22_U_SMXP_0_1, 0x13e178)
    FIELD(POR_MPU_M4_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR23_U_SMXP_0_1, 0x13e180)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR23_U_SMXP_0_1, 0x13e188)
    FIELD(POR_MPU_M4_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR24_U_SMXP_0_1, 0x13e190)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR24_U_SMXP_0_1, 0x13e198)
    FIELD(POR_MPU_M4_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR25_U_SMXP_0_1, 0x13e1a0)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR25_U_SMXP_0_1, 0x13e1a8)
    FIELD(POR_MPU_M4_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR26_U_SMXP_0_1, 0x13e1b0)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR26_U_SMXP_0_1, 0x13e1b8)
    FIELD(POR_MPU_M4_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR27_U_SMXP_0_1, 0x13e1c0)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR27_U_SMXP_0_1, 0x13e1c8)
    FIELD(POR_MPU_M4_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR28_U_SMXP_0_1, 0x13e1d0)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR28_U_SMXP_0_1, 0x13e1d8)
    FIELD(POR_MPU_M4_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR29_U_SMXP_0_1, 0x13e1e0)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR29_U_SMXP_0_1, 0x13e1e8)
    FIELD(POR_MPU_M4_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR30_U_SMXP_0_1, 0x13e1f0)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR30_U_SMXP_0_1, 0x13e1f8)
    FIELD(POR_MPU_M4_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR31_U_SMXP_0_1, 0x13e200)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR31_U_SMXP_0_1, 0x13e208)
    FIELD(POR_MPU_M4_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M5_CTL_U_SMXP_0_1, 0x13e400)
    FIELD(POR_MPU_M5_CTL_U_SMXP_0_1, M5_EN, 2, 1)
    FIELD(POR_MPU_M5_CTL_U_SMXP_0_1, M5_ACTION, 0, 2)
REG32(POR_MPU_M5_PRBAR0_U_SMXP_0_1, 0x13e410)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR0_U_SMXP_0_1, 0x13e418)
    FIELD(POR_MPU_M5_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR1_U_SMXP_0_1, 0x13e420)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR1_U_SMXP_0_1, 0x13e428)
    FIELD(POR_MPU_M5_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR2_U_SMXP_0_1, 0x13e430)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR2_U_SMXP_0_1, 0x13e438)
    FIELD(POR_MPU_M5_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR3_U_SMXP_0_1, 0x13e440)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR3_U_SMXP_0_1, 0x13e448)
    FIELD(POR_MPU_M5_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR4_U_SMXP_0_1, 0x13e450)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR4_U_SMXP_0_1, 0x13e458)
    FIELD(POR_MPU_M5_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR5_U_SMXP_0_1, 0x13e460)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR5_U_SMXP_0_1, 0x13e468)
    FIELD(POR_MPU_M5_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR6_U_SMXP_0_1, 0x13e470)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR6_U_SMXP_0_1, 0x13e478)
    FIELD(POR_MPU_M5_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR7_U_SMXP_0_1, 0x13e480)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR7_U_SMXP_0_1, 0x13e488)
    FIELD(POR_MPU_M5_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR8_U_SMXP_0_1, 0x13e490)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR8_U_SMXP_0_1, 0x13e498)
    FIELD(POR_MPU_M5_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR9_U_SMXP_0_1, 0x13e4a0)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR9_U_SMXP_0_1, 0x13e4a8)
    FIELD(POR_MPU_M5_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR10_U_SMXP_0_1, 0x13e4b0)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR10_U_SMXP_0_1, 0x13e4b8)
    FIELD(POR_MPU_M5_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR11_U_SMXP_0_1, 0x13e4c0)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR11_U_SMXP_0_1, 0x13e4c8)
    FIELD(POR_MPU_M5_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR12_U_SMXP_0_1, 0x13e4d0)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR12_U_SMXP_0_1, 0x13e4d8)
    FIELD(POR_MPU_M5_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR13_U_SMXP_0_1, 0x13e4e0)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR13_U_SMXP_0_1, 0x13e4e8)
    FIELD(POR_MPU_M5_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR14_U_SMXP_0_1, 0x13e4f0)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR14_U_SMXP_0_1, 0x13e4f8)
    FIELD(POR_MPU_M5_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR15_U_SMXP_0_1, 0x13e500)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR15_U_SMXP_0_1, 0x13e508)
    FIELD(POR_MPU_M5_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR16_U_SMXP_0_1, 0x13e510)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR16_U_SMXP_0_1, 0x13e518)
    FIELD(POR_MPU_M5_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR17_U_SMXP_0_1, 0x13e520)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR17_U_SMXP_0_1, 0x13e528)
    FIELD(POR_MPU_M5_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR18_U_SMXP_0_1, 0x13e530)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR18_U_SMXP_0_1, 0x13e538)
    FIELD(POR_MPU_M5_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR19_U_SMXP_0_1, 0x13e540)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR19_U_SMXP_0_1, 0x13e548)
    FIELD(POR_MPU_M5_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR20_U_SMXP_0_1, 0x13e550)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR20_U_SMXP_0_1, 0x13e558)
    FIELD(POR_MPU_M5_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR21_U_SMXP_0_1, 0x13e560)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR21_U_SMXP_0_1, 0x13e568)
    FIELD(POR_MPU_M5_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR22_U_SMXP_0_1, 0x13e570)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR22_U_SMXP_0_1, 0x13e578)
    FIELD(POR_MPU_M5_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR23_U_SMXP_0_1, 0x13e580)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR23_U_SMXP_0_1, 0x13e588)
    FIELD(POR_MPU_M5_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR24_U_SMXP_0_1, 0x13e590)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR24_U_SMXP_0_1, 0x13e598)
    FIELD(POR_MPU_M5_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR25_U_SMXP_0_1, 0x13e5a0)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR25_U_SMXP_0_1, 0x13e5a8)
    FIELD(POR_MPU_M5_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR26_U_SMXP_0_1, 0x13e5b0)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR26_U_SMXP_0_1, 0x13e5b8)
    FIELD(POR_MPU_M5_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR27_U_SMXP_0_1, 0x13e5c0)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR27_U_SMXP_0_1, 0x13e5c8)
    FIELD(POR_MPU_M5_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR28_U_SMXP_0_1, 0x13e5d0)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR28_U_SMXP_0_1, 0x13e5d8)
    FIELD(POR_MPU_M5_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR29_U_SMXP_0_1, 0x13e5e0)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR29_U_SMXP_0_1, 0x13e5e8)
    FIELD(POR_MPU_M5_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR30_U_SMXP_0_1, 0x13e5f0)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR30_U_SMXP_0_1, 0x13e5f8)
    FIELD(POR_MPU_M5_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR31_U_SMXP_0_1, 0x13e600)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR31_U_SMXP_0_1, 0x13e608)
    FIELD(POR_MPU_M5_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M6_CTL_U_SMXP_0_1, 0x13e800)
    FIELD(POR_MPU_M6_CTL_U_SMXP_0_1, M6_EN, 2, 1)
    FIELD(POR_MPU_M6_CTL_U_SMXP_0_1, M6_ACTION, 0, 2)
REG32(POR_MPU_M6_PRBAR0_U_SMXP_0_1, 0x13e810)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR0_U_SMXP_0_1, 0x13e818)
    FIELD(POR_MPU_M6_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR1_U_SMXP_0_1, 0x13e820)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR1_U_SMXP_0_1, 0x13e828)
    FIELD(POR_MPU_M6_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR2_U_SMXP_0_1, 0x13e830)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR2_U_SMXP_0_1, 0x13e838)
    FIELD(POR_MPU_M6_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR3_U_SMXP_0_1, 0x13e840)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR3_U_SMXP_0_1, 0x13e848)
    FIELD(POR_MPU_M6_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR4_U_SMXP_0_1, 0x13e850)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR4_U_SMXP_0_1, 0x13e858)
    FIELD(POR_MPU_M6_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR5_U_SMXP_0_1, 0x13e860)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR5_U_SMXP_0_1, 0x13e868)
    FIELD(POR_MPU_M6_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR6_U_SMXP_0_1, 0x13e870)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR6_U_SMXP_0_1, 0x13e878)
    FIELD(POR_MPU_M6_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR7_U_SMXP_0_1, 0x13e880)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR7_U_SMXP_0_1, 0x13e888)
    FIELD(POR_MPU_M6_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR8_U_SMXP_0_1, 0x13e890)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR8_U_SMXP_0_1, 0x13e898)
    FIELD(POR_MPU_M6_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR9_U_SMXP_0_1, 0x13e8a0)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR9_U_SMXP_0_1, 0x13e8a8)
    FIELD(POR_MPU_M6_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR10_U_SMXP_0_1, 0x13e8b0)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR10_U_SMXP_0_1, 0x13e8b8)
    FIELD(POR_MPU_M6_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR11_U_SMXP_0_1, 0x13e8c0)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR11_U_SMXP_0_1, 0x13e8c8)
    FIELD(POR_MPU_M6_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR12_U_SMXP_0_1, 0x13e8d0)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR12_U_SMXP_0_1, 0x13e8d8)
    FIELD(POR_MPU_M6_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR13_U_SMXP_0_1, 0x13e8e0)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR13_U_SMXP_0_1, 0x13e8e8)
    FIELD(POR_MPU_M6_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR14_U_SMXP_0_1, 0x13e8f0)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR14_U_SMXP_0_1, 0x13e8f8)
    FIELD(POR_MPU_M6_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR15_U_SMXP_0_1, 0x13e900)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR15_U_SMXP_0_1, 0x13e908)
    FIELD(POR_MPU_M6_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR16_U_SMXP_0_1, 0x13e910)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR16_U_SMXP_0_1, 0x13e918)
    FIELD(POR_MPU_M6_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR17_U_SMXP_0_1, 0x13e920)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR17_U_SMXP_0_1, 0x13e928)
    FIELD(POR_MPU_M6_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR18_U_SMXP_0_1, 0x13e930)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR18_U_SMXP_0_1, 0x13e938)
    FIELD(POR_MPU_M6_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR19_U_SMXP_0_1, 0x13e940)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR19_U_SMXP_0_1, 0x13e948)
    FIELD(POR_MPU_M6_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR20_U_SMXP_0_1, 0x13e950)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR20_U_SMXP_0_1, 0x13e958)
    FIELD(POR_MPU_M6_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR21_U_SMXP_0_1, 0x13e960)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR21_U_SMXP_0_1, 0x13e968)
    FIELD(POR_MPU_M6_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR22_U_SMXP_0_1, 0x13e970)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR22_U_SMXP_0_1, 0x13e978)
    FIELD(POR_MPU_M6_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR23_U_SMXP_0_1, 0x13e980)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR23_U_SMXP_0_1, 0x13e988)
    FIELD(POR_MPU_M6_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR24_U_SMXP_0_1, 0x13e990)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR24_U_SMXP_0_1, 0x13e998)
    FIELD(POR_MPU_M6_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR25_U_SMXP_0_1, 0x13e9a0)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR25_U_SMXP_0_1, 0x13e9a8)
    FIELD(POR_MPU_M6_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR26_U_SMXP_0_1, 0x13e9b0)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR26_U_SMXP_0_1, 0x13e9b8)
    FIELD(POR_MPU_M6_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR27_U_SMXP_0_1, 0x13e9c0)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR27_U_SMXP_0_1, 0x13e9c8)
    FIELD(POR_MPU_M6_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR28_U_SMXP_0_1, 0x13e9d0)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR28_U_SMXP_0_1, 0x13e9d8)
    FIELD(POR_MPU_M6_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR29_U_SMXP_0_1, 0x13e9e0)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR29_U_SMXP_0_1, 0x13e9e8)
    FIELD(POR_MPU_M6_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR30_U_SMXP_0_1, 0x13e9f0)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR30_U_SMXP_0_1, 0x13e9f8)
    FIELD(POR_MPU_M6_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR31_U_SMXP_0_1, 0x13ea00)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR31_U_SMXP_0_1, 0x13ea08)
    FIELD(POR_MPU_M6_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_MPU_M7_CTL_U_SMXP_0_1, 0x13ec00)
    FIELD(POR_MPU_M7_CTL_U_SMXP_0_1, M7_EN, 2, 1)
    FIELD(POR_MPU_M7_CTL_U_SMXP_0_1, M7_ACTION, 0, 2)
REG32(POR_MPU_M7_PRBAR0_U_SMXP_0_1, 0x13ec10)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_1, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_1, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_1, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR0_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR0_U_SMXP_0_1, 0x13ec18)
    FIELD(POR_MPU_M7_PRLAR0_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR0_U_SMXP_0_1, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR0_U_SMXP_0_1, REGION0_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR1_U_SMXP_0_1, 0x13ec20)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_1, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_1, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_1, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR1_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR1_U_SMXP_0_1, 0x13ec28)
    FIELD(POR_MPU_M7_PRLAR1_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR1_U_SMXP_0_1, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR1_U_SMXP_0_1, REGION1_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR2_U_SMXP_0_1, 0x13ec30)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_1, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_1, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_1, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR2_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR2_U_SMXP_0_1, 0x13ec38)
    FIELD(POR_MPU_M7_PRLAR2_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR2_U_SMXP_0_1, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR2_U_SMXP_0_1, REGION2_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR3_U_SMXP_0_1, 0x13ec40)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_1, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_1, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_1, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR3_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR3_U_SMXP_0_1, 0x13ec48)
    FIELD(POR_MPU_M7_PRLAR3_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR3_U_SMXP_0_1, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR3_U_SMXP_0_1, REGION3_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR4_U_SMXP_0_1, 0x13ec50)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_1, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_1, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_1, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR4_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR4_U_SMXP_0_1, 0x13ec58)
    FIELD(POR_MPU_M7_PRLAR4_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR4_U_SMXP_0_1, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR4_U_SMXP_0_1, REGION4_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR5_U_SMXP_0_1, 0x13ec60)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_1, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_1, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_1, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR5_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR5_U_SMXP_0_1, 0x13ec68)
    FIELD(POR_MPU_M7_PRLAR5_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR5_U_SMXP_0_1, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR5_U_SMXP_0_1, REGION5_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR6_U_SMXP_0_1, 0x13ec70)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_1, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_1, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_1, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR6_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR6_U_SMXP_0_1, 0x13ec78)
    FIELD(POR_MPU_M7_PRLAR6_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR6_U_SMXP_0_1, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR6_U_SMXP_0_1, REGION6_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR7_U_SMXP_0_1, 0x13ec80)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_1, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_1, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_1, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR7_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR7_U_SMXP_0_1, 0x13ec88)
    FIELD(POR_MPU_M7_PRLAR7_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR7_U_SMXP_0_1, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR7_U_SMXP_0_1, REGION7_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR8_U_SMXP_0_1, 0x13ec90)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_1, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_1, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_1, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR8_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR8_U_SMXP_0_1, 0x13ec98)
    FIELD(POR_MPU_M7_PRLAR8_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR8_U_SMXP_0_1, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR8_U_SMXP_0_1, REGION8_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR9_U_SMXP_0_1, 0x13eca0)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_1, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_1, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_1, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR9_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR9_U_SMXP_0_1, 0x13eca8)
    FIELD(POR_MPU_M7_PRLAR9_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR9_U_SMXP_0_1, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR9_U_SMXP_0_1, REGION9_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR10_U_SMXP_0_1, 0x13ecb0)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_1, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_1, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_1, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR10_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR10_U_SMXP_0_1, 0x13ecb8)
    FIELD(POR_MPU_M7_PRLAR10_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR10_U_SMXP_0_1, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR10_U_SMXP_0_1, REGION10_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR11_U_SMXP_0_1, 0x13ecc0)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_1, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_1, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_1, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR11_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR11_U_SMXP_0_1, 0x13ecc8)
    FIELD(POR_MPU_M7_PRLAR11_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR11_U_SMXP_0_1, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR11_U_SMXP_0_1, REGION11_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR12_U_SMXP_0_1, 0x13ecd0)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_1, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_1, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_1, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR12_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR12_U_SMXP_0_1, 0x13ecd8)
    FIELD(POR_MPU_M7_PRLAR12_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR12_U_SMXP_0_1, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR12_U_SMXP_0_1, REGION12_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR13_U_SMXP_0_1, 0x13ece0)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_1, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_1, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_1, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR13_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR13_U_SMXP_0_1, 0x13ece8)
    FIELD(POR_MPU_M7_PRLAR13_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR13_U_SMXP_0_1, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR13_U_SMXP_0_1, REGION13_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR14_U_SMXP_0_1, 0x13ecf0)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_1, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_1, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_1, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR14_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR14_U_SMXP_0_1, 0x13ecf8)
    FIELD(POR_MPU_M7_PRLAR14_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR14_U_SMXP_0_1, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR14_U_SMXP_0_1, REGION14_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR15_U_SMXP_0_1, 0x13ed00)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_1, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_1, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_1, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR15_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR15_U_SMXP_0_1, 0x13ed08)
    FIELD(POR_MPU_M7_PRLAR15_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR15_U_SMXP_0_1, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR15_U_SMXP_0_1, REGION15_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR16_U_SMXP_0_1, 0x13ed10)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_1, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_1, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_1, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR16_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR16_U_SMXP_0_1, 0x13ed18)
    FIELD(POR_MPU_M7_PRLAR16_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR16_U_SMXP_0_1, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR16_U_SMXP_0_1, REGION16_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR17_U_SMXP_0_1, 0x13ed20)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_1, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_1, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_1, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR17_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR17_U_SMXP_0_1, 0x13ed28)
    FIELD(POR_MPU_M7_PRLAR17_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR17_U_SMXP_0_1, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR17_U_SMXP_0_1, REGION17_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR18_U_SMXP_0_1, 0x13ed30)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_1, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_1, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_1, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR18_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR18_U_SMXP_0_1, 0x13ed38)
    FIELD(POR_MPU_M7_PRLAR18_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR18_U_SMXP_0_1, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR18_U_SMXP_0_1, REGION18_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR19_U_SMXP_0_1, 0x13ed40)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_1, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_1, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_1, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR19_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR19_U_SMXP_0_1, 0x13ed48)
    FIELD(POR_MPU_M7_PRLAR19_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR19_U_SMXP_0_1, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR19_U_SMXP_0_1, REGION19_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR20_U_SMXP_0_1, 0x13ed50)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_1, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_1, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_1, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR20_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR20_U_SMXP_0_1, 0x13ed58)
    FIELD(POR_MPU_M7_PRLAR20_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR20_U_SMXP_0_1, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR20_U_SMXP_0_1, REGION20_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR21_U_SMXP_0_1, 0x13ed60)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_1, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_1, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_1, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR21_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR21_U_SMXP_0_1, 0x13ed68)
    FIELD(POR_MPU_M7_PRLAR21_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR21_U_SMXP_0_1, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR21_U_SMXP_0_1, REGION21_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR22_U_SMXP_0_1, 0x13ed70)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_1, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_1, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_1, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR22_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR22_U_SMXP_0_1, 0x13ed78)
    FIELD(POR_MPU_M7_PRLAR22_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR22_U_SMXP_0_1, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR22_U_SMXP_0_1, REGION22_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR23_U_SMXP_0_1, 0x13ed80)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_1, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_1, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_1, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR23_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR23_U_SMXP_0_1, 0x13ed88)
    FIELD(POR_MPU_M7_PRLAR23_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR23_U_SMXP_0_1, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR23_U_SMXP_0_1, REGION23_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR24_U_SMXP_0_1, 0x13ed90)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_1, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_1, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_1, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR24_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR24_U_SMXP_0_1, 0x13ed98)
    FIELD(POR_MPU_M7_PRLAR24_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR24_U_SMXP_0_1, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR24_U_SMXP_0_1, REGION24_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR25_U_SMXP_0_1, 0x13eda0)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_1, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_1, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_1, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR25_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR25_U_SMXP_0_1, 0x13eda8)
    FIELD(POR_MPU_M7_PRLAR25_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR25_U_SMXP_0_1, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR25_U_SMXP_0_1, REGION25_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR26_U_SMXP_0_1, 0x13edb0)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_1, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_1, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_1, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR26_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR26_U_SMXP_0_1, 0x13edb8)
    FIELD(POR_MPU_M7_PRLAR26_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR26_U_SMXP_0_1, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR26_U_SMXP_0_1, REGION26_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR27_U_SMXP_0_1, 0x13edc0)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_1, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_1, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_1, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR27_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR27_U_SMXP_0_1, 0x13edc8)
    FIELD(POR_MPU_M7_PRLAR27_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR27_U_SMXP_0_1, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR27_U_SMXP_0_1, REGION27_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR28_U_SMXP_0_1, 0x13edd0)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_1, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_1, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_1, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR28_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR28_U_SMXP_0_1, 0x13edd8)
    FIELD(POR_MPU_M7_PRLAR28_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR28_U_SMXP_0_1, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR28_U_SMXP_0_1, REGION28_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR29_U_SMXP_0_1, 0x13ede0)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_1, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_1, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_1, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR29_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR29_U_SMXP_0_1, 0x13ede8)
    FIELD(POR_MPU_M7_PRLAR29_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR29_U_SMXP_0_1, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR29_U_SMXP_0_1, REGION29_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR30_U_SMXP_0_1, 0x13edf0)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_1, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_1, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_1, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR30_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR30_U_SMXP_0_1, 0x13edf8)
    FIELD(POR_MPU_M7_PRLAR30_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR30_U_SMXP_0_1, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR30_U_SMXP_0_1, REGION30_EN, 0, 1)
REG32(POR_MPU_M7_PRBAR31_U_SMXP_0_1, 0x13ee00)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_1, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_1, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_1, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_1, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M7_PRBAR31_U_SMXP_0_1, RESERVED_0, 0, 2)
REG32(POR_MPU_M7_PRLAR31_U_SMXP_0_1, 0x13ee08)
    FIELD(POR_MPU_M7_PRLAR31_U_SMXP_0_1, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M7_PRLAR31_U_SMXP_0_1, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M7_PRLAR31_U_SMXP_0_1, REGION31_EN, 0, 1)
REG32(POR_RNSAM_NODE_INFO_U_RNFBESAM_NID12, 0x168000)
    FIELD(POR_RNSAM_NODE_INFO_U_RNFBESAM_NID12, RESERVED_48, 48, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RNFBESAM_NID12, LOGICAL_ID, 32, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RNFBESAM_NID12, NODE_ID, 16, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RNFBESAM_NID12, NODE_TYPE, 0, 16)
REG32(POR_RNSAM_CHILD_INFO_U_RNFBESAM_NID12, 0x168080)
    FIELD(POR_RNSAM_CHILD_INFO_U_RNFBESAM_NID12, RESERVED_32, 32, 32)
    FIELD(POR_RNSAM_CHILD_INFO_U_RNFBESAM_NID12, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_RNSAM_CHILD_INFO_U_RNFBESAM_NID12, CHILD_COUNT, 0, 16)
REG32(POR_RNSAM_UNIT_INFO_U_RNFBESAM_NID12, 0x168900)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNFBESAM_NID12, RESERVED_37, 37, 27)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNFBESAM_NID12, NUM_NON_HASH_GROUP, 32, 5)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNFBESAM_NID12, RESERVED_20, 20, 12)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNFBESAM_NID12, NUM_SYS_CACHE_GROUP, 16, 4)
    FIELD(POR_RNSAM_UNIT_INFO_U_RNFBESAM_NID12, NUM_HNF, 0, 8)
REG32(POR_RNSAM_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNFBESAM_NID12, 0x168980)
    FIELD(POR_RNSAM_SECURE_REGISTER_GROUPS_OVERRIDE_U_RNFBESAM_NID12, MEM_RANGE, 0, 1)
REG32(RNSAM_STATUS_U_RNFBESAM_NID12, 0x168c00)
    FIELD(RNSAM_STATUS_U_RNFBESAM_NID12, NSTALL_REQ, 1, 1)
    FIELD(RNSAM_STATUS_U_RNFBESAM_NID12, USE_DEFAULT_NODE, 0, 1)
REG32(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, 0x168c08)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION1_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION1_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION1_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION1_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION0_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION0_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION0_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RNFBESAM_NID12, REGION0_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, 0x168c10)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION3_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION3_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION3_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION3_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION2_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION2_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION2_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RNFBESAM_NID12, REGION2_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, 0x168c18)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION5_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION5_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION5_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION5_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION4_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION4_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION4_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RNFBESAM_NID12, REGION4_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, 0x168c20)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION7_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION7_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION7_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION7_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION6_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION6_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION6_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RNFBESAM_NID12, REGION6_VALID, 0, 1)
REG32(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, 0x168c30)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, NODEID_3, 36, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, NODEID_2, 24, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, NODEID_1, 12, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RNFBESAM_NID12, NODEID_0, 0, 11)
REG32(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, 0x168c38)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, NODEID_7, 36, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, NODEID_6, 24, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, NODEID_5, 12, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RNFBESAM_NID12, NODEID_4, 0, 11)
REG32(NON_HASH_TGT_NODEID2_U_RNFBESAM_NID12, 0x168c40)
    FIELD(NON_HASH_TGT_NODEID2_U_RNFBESAM_NID12, RESERVED_23, 23, 41)
    FIELD(NON_HASH_TGT_NODEID2_U_RNFBESAM_NID12, NODEID_9, 12, 11)
    FIELD(NON_HASH_TGT_NODEID2_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID2_U_RNFBESAM_NID12, NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, 0x168c48)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION1_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION1_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION1_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION1_NONHASH_REG_EN, 33, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION1_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION0_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION0_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION0_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_REGION0_U_RNFBESAM_NID12, REGION0_VALID, 0, 1)
REG32(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, 0x168c50)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION3_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION3_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION3_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION3_NONHASH_REG_EN, 33, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION3_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION2_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION2_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION2_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION2_NONHASH_REG_EN, 1, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RNFBESAM_NID12, REGION2_VALID, 0, 1)
REG32(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, 0x168c58)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, NODEID_3, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, NODEID_2, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, NODEID_1, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RNFBESAM_NID12, NODEID_0, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, 0x168c60)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, NODEID_7, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, NODEID_6, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, NODEID_5, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RNFBESAM_NID12, NODEID_4, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, 0x168c68)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, NODEID_11, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, NODEID_10, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, NODEID_9, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RNFBESAM_NID12, NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, 0x168c70)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, NODEID_15, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, NODEID_14, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, NODEID_13, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RNFBESAM_NID12, NODEID_12, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, 0x168c78)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, NODEID_19, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, NODEID_18, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, NODEID_17, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RNFBESAM_NID12, NODEID_16, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, 0x168c80)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, NODEID_23, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, NODEID_22, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, NODEID_21, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RNFBESAM_NID12, NODEID_20, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, 0x168c88)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, NODEID_27, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, NODEID_26, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, NODEID_25, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RNFBESAM_NID12, NODEID_24, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, 0x168c90)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, NODEID_31, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, NODEID_30, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, NODEID_29, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RNFBESAM_NID12, NODEID_28, 0, 11)
REG32(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, 0x168c98)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, RESERVED_35, 35, 29)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, SCG3_NODEID, 24, 11)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, SCG2_NODEID, 12, 11)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RNFBESAM_NID12, SCG1_NODEID, 0, 11)
REG32(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, 0x168d00)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, RESERVED_31, 31, 33)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, SCG3_NUM_HNF, 24, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, SCG2_NUM_HNF, 16, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, RESERVED_15, 15, 1)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, SCG1_NUM_HNF, 8, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RNFBESAM_NID12, SCG0_NUM_HNF, 0, 7)
REG32(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, 0x168d08)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, SN_NODEID_3, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, SN_NODEID_2, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, SN_NODEID_1, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RNFBESAM_NID12, SN_NODEID_0, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, 0x168d10)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, SN_NODEID_7, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, SN_NODEID_6, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, SN_NODEID_5, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RNFBESAM_NID12, SN_NODEID_4, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, 0x168d18)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, SN_NODEID_11, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, SN_NODEID_10, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, SN_NODEID_9, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RNFBESAM_NID12, SN_NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, 0x168d20)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, SN_NODEID_15, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, SN_NODEID_14, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, SN_NODEID_13, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RNFBESAM_NID12, SN_NODEID_12, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, 0x168d28)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, SN_NODEID_19, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, SN_NODEID_18, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, SN_NODEID_17, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RNFBESAM_NID12, SN_NODEID_16, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, 0x168d30)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, SN_NODEID_23, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, SN_NODEID_22, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, SN_NODEID_21, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RNFBESAM_NID12, SN_NODEID_20, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, 0x168d38)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, SN_NODEID_27, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, SN_NODEID_26, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, SN_NODEID_25, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RNFBESAM_NID12, SN_NODEID_24, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, 0x168d40)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, SN_NODEID_31, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, SN_NODEID_30, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, SN_NODEID_29, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RNFBESAM_NID12, SN_NODEID_28, 0, 11)
REG32(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, 0x168d48)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, RESERVED_46, 46, 18)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, SCG1_TOP_ADDRESS_BIT2, 40, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, RESERVED_38, 38, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, SCG1_TOP_ADDRESS_BIT1, 32, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, RESERVED_30, 30, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, SCG1_TOP_ADDRESS_BIT0, 24, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, RESERVED_22, 22, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, SCG0_TOP_ADDRESS_BIT2, 16, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, RESERVED_14, 14, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, SCG0_TOP_ADDRESS_BIT1, 8, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RNFBESAM_NID12, SCG0_TOP_ADDRESS_BIT0, 0, 6)
REG32(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, 0x168d50)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, RESERVED_46, 46, 18)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, SCG3_TOP_ADDRESS_BIT2, 40, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, RESERVED_38, 38, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, SCG3_TOP_ADDRESS_BIT1, 32, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, RESERVED_30, 30, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, SCG3_TOP_ADDRESS_BIT0, 24, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, RESERVED_22, 22, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, SCG2_TOP_ADDRESS_BIT2, 16, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, RESERVED_14, 14, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, SCG2_TOP_ADDRESS_BIT1, 8, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RNFBESAM_NID12, SCG2_TOP_ADDRESS_BIT0, 0, 6)
REG32(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, 0x168d58)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, GIC_REGION_NODEID, 52, 11)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, RESERVED_48, 48, 4)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, GIC_REGION_BASE_ADDR, 16, 32)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, GIC_REGION_SIZE, 4, 3)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, GIC_REGION_TARGET_TYPE, 2, 2)
    FIELD(GIC_MEM_REGION_REG_U_RNFBESAM_NID12, GIC_REGION_VALID, 0, 1)
REG32(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, 0x168d60)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, RESERVED_54, 54, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, SN_MODE_SYS_CACHE_GRP3, 52, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, RESERVED_49, 49, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP3, 48, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, RESERVED_38, 38, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, SN_MODE_SYS_CACHE_GRP2, 36, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, RESERVED_33, 33, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP2, 32, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, RESERVED_22, 22, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, SN_MODE_SYS_CACHE_GRP1, 20, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, RESERVED_17, 17, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP1, 16, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, SN_MODE_SYS_CACHE_GRP0, 4, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RNFBESAM_NID12, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP0, 0, 1)
REG32(SYS_CACHE_GRP_HN_CPA_EN_REG_U_RNFBESAM_NID12, 0x168d68)
REG32(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, 0x168d70)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, RESERVED_50, 50, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, CPA_GRP_SCG3, 48, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, RESERVED_34, 34, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, CPA_GRP_SCG2, 32, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, RESERVED_18, 18, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, CPA_GRP_SCG1, 16, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RNFBESAM_NID12, CPA_GRP_SCG0, 0, 2)
REG32(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, 0x168e00)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_32, 32, 32)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION7_PAG_GRPID, 30, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_29, 29, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION7_PAG_EN, 28, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_27, 27, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION6_PAG_GRPID, 25, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION6_PAG_EN, 24, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION5_PAG_GRPID, 21, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION5_PAG_EN, 20, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_19, 19, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION4_PAG_GRPID, 17, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION4_PAG_EN, 16, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_15, 15, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION3_PAG_GRPID, 13, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION3_PAG_EN, 12, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION2_PAG_GRPID, 9, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION2_PAG_EN, 8, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION1_PAG_GRPID, 5, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION1_PAG_EN, 4, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION0_PAG_GRPID, 1, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RNFBESAM_NID12, REGION0_PAG_EN, 0, 1)
REG32(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNFBESAM_NID12, 0x168e08)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNFBESAM_NID12, RESERVED_48, 48, 16)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNFBESAM_NID12, ADDR_MASK, 6, 42)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RNFBESAM_NID12, RESERVED_0, 0, 6)
REG32(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNFBESAM_NID12, 0x168e10)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNFBESAM_NID12, RESERVED_48, 48, 16)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNFBESAM_NID12, ADDR_MASK, 6, 42)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RNFBESAM_NID12, RESERVED_0, 0, 6)
REG32(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, 0x168e40)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, RESERVED_50, 50, 14)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, NUM_CXG_PAG0, 48, 2)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, RESERVED_47, 47, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, PAG0_TGTID3, 36, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, PAG0_TGTID2, 24, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, PAG0_TGTID1, 12, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RNFBESAM_NID12, PAG0_TGTID0, 0, 11)
REG32(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, 0x168e48)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, RESERVED_50, 50, 14)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, NUM_CXG_PAG1, 48, 2)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, RESERVED_47, 47, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, PAG1_TGTID3, 36, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, PAG1_TGTID2, 24, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, PAG1_TGTID1, 12, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RNFBESAM_NID12, PAG1_TGTID0, 0, 11)
REG32(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, 0x168f00)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION1_SCNDRY_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION1_SCNDRY_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION1_SCNDRY_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, RESERVED_33, 33, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION1_SCNDRY_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION0_SCNDRY_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION0_SCNDRY_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION0_SCNDRY_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RNFBESAM_NID12, REGION0_SCNDRY_VALID, 0, 1)
REG32(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, 0x168f08)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION3_SCNDRY_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION3_SCNDRY_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION3_SCNDRY_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, RESERVED_33, 33, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION3_SCNDRY_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION2_SCNDRY_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION2_SCNDRY_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION2_SCNDRY_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RNFBESAM_NID12, REGION2_SCNDRY_VALID, 0, 1)
REG32(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, 0x168f10)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, RESERVED_49, 49, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, SCG3_HNF_CAL_MODE_EN, 48, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, RESERVED_33, 33, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, SCG2_HNF_CAL_MODE_EN, 32, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, RESERVED_17, 17, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, SCG1_HNF_CAL_MODE_EN, 16, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RNFBESAM_NID12, SCG0_HNF_CAL_MODE_EN, 0, 1)
REG32(RNSAM_HASH_ADDR_MASK_REG_U_RNFBESAM_NID12, 0x168f18)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RNFBESAM_NID12, RESERVED_48, 48, 16)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RNFBESAM_NID12, ADDR_MASK, 6, 42)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RNFBESAM_NID12, RESERVED_0, 0, 6)
REG32(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNFBESAM_NID12, 0x168f20)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNFBESAM_NID12, RESERVED_48, 48, 16)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNFBESAM_NID12, ADDR_MASK, 16, 32)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RNFBESAM_NID12, RESERVED_0, 0, 16)
REG32(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, 0x168f58)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, NODEID_35, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, NODEID_34, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, NODEID_33, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RNFBESAM_NID12, NODEID_32, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, 0x168f60)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, NODEID_39, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, NODEID_38, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, NODEID_37, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RNFBESAM_NID12, NODEID_36, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, 0x168f68)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, NODEID_43, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, NODEID_42, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, NODEID_41, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RNFBESAM_NID12, NODEID_40, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, 0x168f70)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, NODEID_47, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, NODEID_46, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, NODEID_45, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RNFBESAM_NID12, NODEID_44, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, 0x168f78)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, NODEID_51, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, NODEID_50, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, NODEID_49, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RNFBESAM_NID12, NODEID_48, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, 0x168f80)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, NODEID_55, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, NODEID_54, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, NODEID_53, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RNFBESAM_NID12, NODEID_52, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, 0x168f88)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, NODEID_59, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, NODEID_58, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, NODEID_57, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RNFBESAM_NID12, NODEID_56, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, 0x168f90)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, NODEID_63, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, NODEID_62, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, NODEID_61, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RNFBESAM_NID12, NODEID_60, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, 0x169008)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, SN_NODEID_35, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, SN_NODEID_34, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, SN_NODEID_33, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RNFBESAM_NID12, SN_NODEID_32, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, 0x169010)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, SN_NODEID_39, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, SN_NODEID_38, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, SN_NODEID_37, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RNFBESAM_NID12, SN_NODEID_36, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, 0x169018)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, SN_NODEID_43, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, SN_NODEID_42, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, SN_NODEID_41, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RNFBESAM_NID12, SN_NODEID_40, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, 0x169020)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, SN_NODEID_47, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, SN_NODEID_46, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, SN_NODEID_45, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RNFBESAM_NID12, SN_NODEID_44, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, 0x169028)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, SN_NODEID_51, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, SN_NODEID_50, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, SN_NODEID_49, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RNFBESAM_NID12, SN_NODEID_48, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, 0x169030)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, SN_NODEID_55, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, SN_NODEID_54, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, SN_NODEID_53, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RNFBESAM_NID12, SN_NODEID_52, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, 0x169038)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, SN_NODEID_59, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, SN_NODEID_58, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, SN_NODEID_57, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RNFBESAM_NID12, SN_NODEID_56, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, 0x169040)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, SN_NODEID_63, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, SN_NODEID_62, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, SN_NODEID_61, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RNFBESAM_NID12, SN_NODEID_60, 0, 11)
REG32(POR_SBSX_NODE_INFO_U_SBSX_NID64, 0x800000)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID64, RESERVED_48, 48, 16)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID64, LOGICAL_ID, 32, 16)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID64, NODE_ID, 16, 16)
    FIELD(POR_SBSX_NODE_INFO_U_SBSX_NID64, NODE_TYPE, 0, 16)
REG32(POR_SBSX_CHILD_INFO_U_SBSX_NID64, 0x800080)
    FIELD(POR_SBSX_CHILD_INFO_U_SBSX_NID64, RESERVED_32, 32, 32)
    FIELD(POR_SBSX_CHILD_INFO_U_SBSX_NID64, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_SBSX_CHILD_INFO_U_SBSX_NID64, CHILD_COUNT, 0, 16)
REG32(POR_SBSX_UNIT_INFO_U_SBSX_NID64, 0x800900)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID64, RESERVED_22, 22, 42)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID64, ACEL_SAFE_XFACE_DISABLE, 21, 1)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID64, NUM_WR_DATA_BUF, 16, 5)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID64, NUM_OUTSTANDING_READS, 8, 8)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID64, AXDATA_POISON_EN, 4, 1)
    FIELD(POR_SBSX_UNIT_INFO_U_SBSX_NID64, AXDATA_WIDTH, 0, 1)
REG32(POR_SBSX_AUX_CTL_U_SBSX_NID64, 0x800a08)
    FIELD(POR_SBSX_AUX_CTL_U_SBSX_NID64, CLKGATE_DISABLE, 0, 1)
REG32(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, 0x802000)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, RESERVED_30, 30, 34)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, PMU_EVENT3_ID, 24, 6)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, RESERVED_22, 22, 2)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, PMU_EVENT2_ID, 16, 6)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, RESERVED_14, 14, 2)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, PMU_EVENT1_ID, 8, 6)
    FIELD(POR_SBSX_PMU_EVENT_SEL_U_SBSX_NID64, PMU_EVENT0_ID, 0, 6)
REG32(POR_SBSX_ERRFR_U_SBSX_NID64, 0x803000)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, RESERVED_15, 15, 49)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, CEC, 12, 3)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, CFI, 10, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, FI, 6, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, UI, 4, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, DE, 2, 2)
    FIELD(POR_SBSX_ERRFR_U_SBSX_NID64, ED, 0, 2)
REG32(POR_SBSX_ERRCTLR_U_SBSX_NID64, 0x803008)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID64, RESERVED_9, 9, 55)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID64, CFI, 8, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID64, FI, 3, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID64, UI, 2, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID64, DE, 1, 1)
    FIELD(POR_SBSX_ERRCTLR_U_SBSX_NID64, ED, 0, 1)
REG32(POR_SBSX_ERRSTATUS_U_SBSX_NID64, 0x803010)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, RESERVED_32, 32, 32)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, AV, 31, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, V, 30, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, UE, 29, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, RESERVED_28, 28, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, OF, 27, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, MV, 26, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, RESERVED_25, 25, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, CE, 24, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, DE, 23, 1)
    FIELD(POR_SBSX_ERRSTATUS_U_SBSX_NID64, RESERVED_0, 0, 23)
REG32(POR_SBSX_ERRADDR_U_SBSX_NID64, 0x803018)
    FIELD(POR_SBSX_ERRADDR_U_SBSX_NID64, NS, 63, 1)
    FIELD(POR_SBSX_ERRADDR_U_SBSX_NID64, RESERVED_48, 48, 15)
    FIELD(POR_SBSX_ERRADDR_U_SBSX_NID64, ADDR, 0, 48)
REG32(POR_SBSX_ERRMISC_U_SBSX_NID64, 0x803020)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, RESERVED_31, 31, 33)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, SIZE, 28, 3)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, MEMATTR, 24, 4)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, RESERVED_17, 17, 7)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, OPTYPE, 16, 1)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, RESERVED_15, 15, 1)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, SRCID, 4, 11)
    FIELD(POR_SBSX_ERRMISC_U_SBSX_NID64, RESERVED_0, 0, 4)
REG32(POR_SBSX_ERRFR_NS_U_SBSX_NID64, 0x803100)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, RESERVED_15, 15, 49)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, CEC, 12, 3)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, CFI, 10, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, FI, 6, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, UI, 4, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, DE, 2, 2)
    FIELD(POR_SBSX_ERRFR_NS_U_SBSX_NID64, ED, 0, 2)
REG32(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, 0x803108)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, RESERVED_9, 9, 55)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, CFI, 8, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, FI, 3, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, UI, 2, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, DE, 1, 1)
    FIELD(POR_SBSX_ERRCTLR_NS_U_SBSX_NID64, ED, 0, 1)
REG32(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, 0x803110)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, RESERVED_32, 32, 32)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, AV, 31, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, V, 30, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, UE, 29, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, RESERVED_28, 28, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, OF, 27, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, MV, 26, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, RESERVED_25, 25, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, CE, 24, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, DE, 23, 1)
    FIELD(POR_SBSX_ERRSTATUS_NS_U_SBSX_NID64, RESERVED_0, 0, 23)
REG32(POR_SBSX_ERRADDR_NS_U_SBSX_NID64, 0x803118)
    FIELD(POR_SBSX_ERRADDR_NS_U_SBSX_NID64, NS, 63, 1)
    FIELD(POR_SBSX_ERRADDR_NS_U_SBSX_NID64, RESERVED_48, 48, 15)
    FIELD(POR_SBSX_ERRADDR_NS_U_SBSX_NID64, ADDR, 0, 48)
REG32(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, 0x803120)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, RESERVED_31, 31, 33)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, SIZE, 28, 3)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, MEMATTR, 24, 4)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, RESERVED_17, 17, 7)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, OPTYPE, 16, 1)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, RESERVED_15, 15, 1)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, SRCID, 4, 11)
    FIELD(POR_SBSX_ERRMISC_NS_U_SBSX_NID64, RESERVED_0, 0, 4)
REG32(POR_MXP_NODE_INFO_U_SMXP_1_0, 0x808000)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_1_0, RESERVED_48, 48, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_1_0, LOGICAL_ID, 32, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_1_0, XY_ID, 16, 16)
    FIELD(POR_MXP_NODE_INFO_U_SMXP_1_0, NODE_TYPE, 0, 16)
REG32(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, 0x808008)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, NUM_DCS_P0_D3, 28, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, NUM_DCS_P0_D2, 24, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, NUM_DCS_P0_D1, 20, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, NUM_DCS_P0_D0, 16, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P0_U_SMXP_1_0, DEVICE_TYPE_P0, 0, 5)
REG32(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, 0x808010)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, NUM_DCS_P1_D3, 28, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, NUM_DCS_P1_D2, 24, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, NUM_DCS_P1_D1, 20, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, NUM_DCS_P1_D0, 16, 4)
    FIELD(POR_MXP_DEVICE_PORT_CONNECT_INFO_P1_U_SMXP_1_0, DEVICE_TYPE_P1, 0, 5)
REG32(POR_MXP_MESH_PORT_CONNECT_INFO_EAST_U_SMXP_1_0, 0x808018)
    FIELD(POR_MXP_MESH_PORT_CONNECT_INFO_EAST_U_SMXP_1_0, NUM_MCS_EAST, 0, 4)
REG32(POR_MXP_MESH_PORT_CONNECT_INFO_NORTH_U_SMXP_1_0, 0x808020)
    FIELD(POR_MXP_MESH_PORT_CONNECT_INFO_NORTH_U_SMXP_1_0, NUM_MCS_NORTH, 0, 4)
REG32(POR_MXP_CHILD_INFO_U_SMXP_1_0, 0x808080)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_1_0, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MXP_CHILD_INFO_U_SMXP_1_0, CHILD_COUNT, 0, 16)
REG32(POR_MXP_CHILD_POINTER_0_U_SMXP_1_0, 0x808100)
    FIELD(POR_MXP_CHILD_POINTER_0_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_0_U_SMXP_1_0, RELATIVE_ADDRESS_0, 0, 32)
REG32(POR_MXP_CHILD_POINTER_1_U_SMXP_1_0, 0x808108)
    FIELD(POR_MXP_CHILD_POINTER_1_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_1_U_SMXP_1_0, RELATIVE_ADDRESS_1, 0, 32)
REG32(POR_MXP_CHILD_POINTER_2_U_SMXP_1_0, 0x808110)
    FIELD(POR_MXP_CHILD_POINTER_2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_2_U_SMXP_1_0, RELATIVE_ADDRESS_2, 0, 32)
REG32(POR_MXP_CHILD_POINTER_3_U_SMXP_1_0, 0x808118)
    FIELD(POR_MXP_CHILD_POINTER_3_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_3_U_SMXP_1_0, RELATIVE_ADDRESS_3, 0, 32)
REG32(POR_MXP_CHILD_POINTER_4_U_SMXP_1_0, 0x808120)
    FIELD(POR_MXP_CHILD_POINTER_4_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_4_U_SMXP_1_0, RELATIVE_ADDRESS_4, 0, 32)
REG32(POR_MXP_CHILD_POINTER_5_U_SMXP_1_0, 0x808128)
    FIELD(POR_MXP_CHILD_POINTER_5_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_5_U_SMXP_1_0, RELATIVE_ADDRESS_5, 0, 32)
REG32(POR_MXP_CHILD_POINTER_6_U_SMXP_1_0, 0x808130)
    FIELD(POR_MXP_CHILD_POINTER_6_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_6_U_SMXP_1_0, RELATIVE_ADDRESS_6, 0, 32)
REG32(POR_MXP_CHILD_POINTER_7_U_SMXP_1_0, 0x808138)
    FIELD(POR_MXP_CHILD_POINTER_7_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_7_U_SMXP_1_0, RELATIVE_ADDRESS_7, 0, 32)
REG32(POR_MXP_CHILD_POINTER_8_U_SMXP_1_0, 0x808140)
    FIELD(POR_MXP_CHILD_POINTER_8_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_8_U_SMXP_1_0, RELATIVE_ADDRESS_8, 0, 32)
REG32(POR_MXP_CHILD_POINTER_9_U_SMXP_1_0, 0x808148)
    FIELD(POR_MXP_CHILD_POINTER_9_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_9_U_SMXP_1_0, RELATIVE_ADDRESS_9, 0, 32)
REG32(POR_MXP_CHILD_POINTER_10_U_SMXP_1_0, 0x808150)
    FIELD(POR_MXP_CHILD_POINTER_10_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_10_U_SMXP_1_0, RELATIVE_ADDRESS_10, 0, 32)
REG32(POR_MXP_CHILD_POINTER_11_U_SMXP_1_0, 0x808158)
    FIELD(POR_MXP_CHILD_POINTER_11_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_11_U_SMXP_1_0, RELATIVE_ADDRESS_11, 0, 32)
REG32(POR_MXP_CHILD_POINTER_12_U_SMXP_1_0, 0x808160)
    FIELD(POR_MXP_CHILD_POINTER_12_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_12_U_SMXP_1_0, RELATIVE_ADDRESS_12, 0, 32)
REG32(POR_MXP_CHILD_POINTER_13_U_SMXP_1_0, 0x808168)
    FIELD(POR_MXP_CHILD_POINTER_13_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_13_U_SMXP_1_0, RELATIVE_ADDRESS_13, 0, 32)
REG32(POR_MXP_CHILD_POINTER_14_U_SMXP_1_0, 0x808170)
    FIELD(POR_MXP_CHILD_POINTER_14_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_14_U_SMXP_1_0, RELATIVE_ADDRESS_14, 0, 32)
REG32(POR_MXP_CHILD_POINTER_15_U_SMXP_1_0, 0x808178)
    FIELD(POR_MXP_CHILD_POINTER_15_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_CHILD_POINTER_15_U_SMXP_1_0, RELATIVE_ADDRESS_15, 0, 32)
REG32(POR_MXP_P0_INFO_U_SMXP_1_0, 0x808900)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, RESERVED_26, 26, 38)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, A4S_SAFE_XFACE_DISABLE_P0, 25, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, CHI_SAFE_XFACE_DISABLE_P0, 24, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, A4S_LOGICALID_BASE_P0, 16, 8)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, RESERVED_14, 14, 2)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, A4S_NUM_P0, 11, 3)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, RXBUF_NUM_ENTRIES_P0, 8, 3)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, EXT_SAM_EN_P0, 7, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, DATACHECK_EN_P0, 5, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, POISON_EN_P0, 4, 1)
    FIELD(POR_MXP_P0_INFO_U_SMXP_1_0, NUM_DEV_P0, 0, 3)
REG32(POR_MXP_P1_INFO_U_SMXP_1_0, 0x808908)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, RESERVED_26, 26, 38)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, A4S_SAFE_XFACE_DISABLE_P1, 25, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, CHI_SAFE_XFACE_DISABLE_P1, 24, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, A4S_LOGICALID_BASE_P1, 16, 8)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, RESERVED_14, 14, 2)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, A4S_NUM_P1, 11, 3)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, RXBUF_NUM_ENTRIES_P1, 8, 3)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, EXT_SAM_EN_P1, 7, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, DATACHECK_EN_P1, 5, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, POISON_EN_P1, 4, 1)
    FIELD(POR_MXP_P1_INFO_U_SMXP_1_0, NUM_DEV_P1, 0, 3)
REG32(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_1_0, 0x808980)
    FIELD(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_1_0, SYSCOREQ_CTL, 1, 1)
    FIELD(POR_MXP_SECURE_REGISTER_GROUPS_OVERRIDE_U_SMXP_1_0, QOS, 0, 1)
REG32(POR_MXP_AUX_CTL_U_SMXP_1_0, 0x808a00)
    FIELD(POR_MXP_AUX_CTL_U_SMXP_1_0, CLKGATE_DISABLE, 0, 1)
REG32(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, 0x808a80)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, RESERVED_20, 20, 44)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, P0_QOS_OVERRIDE, 16, 4)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, P0_PQV_MODE, 6, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, P0_REG_MODE, 4, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, P0_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_MXP_P0_QOS_CONTROL_U_SMXP_1_0, P0_LAT_EN, 0, 1)
REG32(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_1_0, 0x808a88)
    FIELD(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_1_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P0_QOS_LAT_TGT_U_SMXP_1_0, P0_LAT_TGT, 0, 12)
REG32(POR_MXP_P0_QOS_LAT_SCALE_U_SMXP_1_0, 0x808a90)
    FIELD(POR_MXP_P0_QOS_LAT_SCALE_U_SMXP_1_0, P0_LAT_SCALE, 0, 3)
REG32(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_1_0, 0x808a98)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_1_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_1_0, P0_LAT_MAX_QOS, 8, 4)
    FIELD(POR_MXP_P0_QOS_LAT_RANGE_U_SMXP_1_0, P0_LAT_MIN_QOS, 0, 4)
REG32(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, 0x808aa0)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, RESERVED_20, 20, 44)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, P1_QOS_OVERRIDE, 16, 4)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, P1_PQV_MODE, 6, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, P1_REG_MODE, 4, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, P1_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_MXP_P1_QOS_CONTROL_U_SMXP_1_0, P1_LAT_EN, 0, 1)
REG32(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_1_0, 0x808aa8)
    FIELD(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_1_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P1_QOS_LAT_TGT_U_SMXP_1_0, P1_LAT_TGT, 0, 12)
REG32(POR_MXP_P1_QOS_LAT_SCALE_U_SMXP_1_0, 0x808ab0)
    FIELD(POR_MXP_P1_QOS_LAT_SCALE_U_SMXP_1_0, P1_LAT_SCALE, 0, 3)
REG32(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_1_0, 0x808ab8)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_1_0, RESERVED_12, 12, 52)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_1_0, P1_LAT_MAX_QOS, 8, 4)
    FIELD(POR_MXP_P1_QOS_LAT_RANGE_U_SMXP_1_0, P1_LAT_MIN_QOS, 0, 4)
REG32(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_1_0, 0x809000)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P0_D3, 3, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P0_D2, 2, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P0_D1, 1, 1)
    FIELD(POR_MXP_P0_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P0_D0, 0, 1)
REG32(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_1_0, 0x809008)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P1_D3, 3, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P1_D2, 2, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P1_D1, 1, 1)
    FIELD(POR_MXP_P1_SYSCOREQ_CTL_U_SMXP_1_0, SNPDVM_REQ_P1_D0, 0, 1)
REG32(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_1_0, 0x809010)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P0_D3, 3, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P0_D2, 2, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P0_D1, 1, 1)
    FIELD(POR_MXP_P0_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P0_D0, 0, 1)
REG32(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_1_0, 0x809018)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P1_D3, 3, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P1_D2, 2, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P1_D1, 1, 1)
    FIELD(POR_MXP_P1_SYSCOACK_STATUS_U_SMXP_1_0, SNPDVM_ACK_P1_D0, 0, 1)
REG32(POR_MXP_PMU_EVENT_SEL_U_SMXP_1_0, 0x80a000)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_1_0, PMU_EVENT3_ID, 24, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_1_0, PMU_EVENT2_ID, 16, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_1_0, PMU_EVENT1_ID, 8, 8)
    FIELD(POR_MXP_PMU_EVENT_SEL_U_SMXP_1_0, PMU_EVENT0_ID, 0, 8)
REG32(POR_DTM_CONTROL_U_SMXP_1_0, 0x80a100)
    FIELD(POR_DTM_CONTROL_U_SMXP_1_0, TRACE_NO_ATB, 3, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_1_0, SAMPLE_PROFILE_ENABLE, 2, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_1_0, TRACE_TAG_ENABLE, 1, 1)
    FIELD(POR_DTM_CONTROL_U_SMXP_1_0, DTM_ENABLE, 0, 1)
REG32(POR_DTM_FIFO_ENTRY_READY_U_SMXP_1_0, 0x80a118)
    FIELD(POR_DTM_FIFO_ENTRY_READY_U_SMXP_1_0, READY, 0, 4)
REG32(POR_DTM_FIFO_ENTRY0_0_U_SMXP_1_0, 0x80a120)
REG32(POR_DTM_FIFO_ENTRY0_1_U_SMXP_1_0, 0x80a128)
REG32(POR_DTM_FIFO_ENTRY0_2_U_SMXP_1_0, 0x80a130)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_1_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY0_2_U_SMXP_1_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY1_0_U_SMXP_1_0, 0x80a138)
REG32(POR_DTM_FIFO_ENTRY1_1_U_SMXP_1_0, 0x80a140)
REG32(POR_DTM_FIFO_ENTRY1_2_U_SMXP_1_0, 0x80a148)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_1_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY1_2_U_SMXP_1_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY2_0_U_SMXP_1_0, 0x80a150)
REG32(POR_DTM_FIFO_ENTRY2_1_U_SMXP_1_0, 0x80a158)
REG32(POR_DTM_FIFO_ENTRY2_2_U_SMXP_1_0, 0x80a160)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_1_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY2_2_U_SMXP_1_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_FIFO_ENTRY3_0_U_SMXP_1_0, 0x80a168)
REG32(POR_DTM_FIFO_ENTRY3_1_U_SMXP_1_0, 0x80a170)
REG32(POR_DTM_FIFO_ENTRY3_2_U_SMXP_1_0, 0x80a178)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_1_0, FIFO_CYCLE_COUNT, 16, 16)
    FIELD(POR_DTM_FIFO_ENTRY3_2_U_SMXP_1_0, FIFO_DATA2, 0, 16)
REG32(POR_DTM_WP0_CONFIG_U_SMXP_1_0, 0x80a1a0)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_COMBINE, 6, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP0_CONFIG_U_SMXP_1_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP0_VAL_U_SMXP_1_0, 0x80a1a8)
REG32(POR_DTM_WP0_MASK_U_SMXP_1_0, 0x80a1b0)
REG32(POR_DTM_WP1_CONFIG_U_SMXP_1_0, 0x80a1b8)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP1_CONFIG_U_SMXP_1_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP1_VAL_U_SMXP_1_0, 0x80a1c0)
REG32(POR_DTM_WP1_MASK_U_SMXP_1_0, 0x80a1c8)
REG32(POR_DTM_WP2_CONFIG_U_SMXP_1_0, 0x80a1d0)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_COMBINE, 6, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP2_CONFIG_U_SMXP_1_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP2_VAL_U_SMXP_1_0, 0x80a1d8)
REG32(POR_DTM_WP2_MASK_U_SMXP_1_0, 0x80a1e0)
REG32(POR_DTM_WP3_CONFIG_U_SMXP_1_0, 0x80a1e8)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, RESERVED_15, 15, 49)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_DBGTRIG_EN, 14, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_CTRIG_EN, 13, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_CC_EN, 12, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_PKT_TYPE, 9, 3)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_PKT_GEN, 8, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_EXCLUSIVE, 5, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_GRP, 4, 1)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_CHN_SEL, 1, 3)
    FIELD(POR_DTM_WP3_CONFIG_U_SMXP_1_0, WP_DEV_SEL, 0, 1)
REG32(POR_DTM_WP3_VAL_U_SMXP_1_0, 0x80a1f0)
REG32(POR_DTM_WP3_MASK_U_SMXP_1_0, 0x80a1f8)
REG32(POR_DTM_PMSICR_U_SMXP_1_0, 0x80a200)
    FIELD(POR_DTM_PMSICR_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_PMSICR_U_SMXP_1_0, COUNT, 0, 32)
REG32(POR_DTM_PMSIRR_U_SMXP_1_0, 0x80a208)
    FIELD(POR_DTM_PMSIRR_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_DTM_PMSIRR_U_SMXP_1_0, INTERVAL, 8, 24)
    FIELD(POR_DTM_PMSIRR_U_SMXP_1_0, RESERVED_0, 0, 8)
REG32(POR_DTM_PMU_CONFIG_U_SMXP_1_0, 0x80a210)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_62, 62, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT3_INPUT_SEL, 56, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_54, 54, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT2_INPUT_SEL, 48, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_46, 46, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT1_INPUT_SEL, 40, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_38, 38, 2)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT0_INPUT_SEL, 32, 6)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_31, 31, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT3_GLOBAL_NUM, 28, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_27, 27, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT2_GLOBAL_NUM, 24, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_23, 23, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT1_GLOBAL_NUM, 20, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_19, 19, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT0_GLOBAL_NUM, 16, 3)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, RESERVED_9, 9, 7)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, CNTR_RST, 8, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT_PAIRED, 4, 4)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNTALL_COMBINED, 3, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT23_COMBINED, 2, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMEVCNT01_COMBINED, 1, 1)
    FIELD(POR_DTM_PMU_CONFIG_U_SMXP_1_0, PMU_EN, 0, 1)
REG32(POR_DTM_PMEVCNT_U_SMXP_1_0, 0x80a220)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_1_0, PMEVCNT3, 48, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_1_0, PMEVCNT2, 32, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_1_0, PMEVCNT1, 16, 16)
    FIELD(POR_DTM_PMEVCNT_U_SMXP_1_0, PMEVCNT0, 0, 16)
REG32(POR_DTM_PMEVCNTSR_U_SMXP_1_0, 0x80a240)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_1_0, PMEVCNTSR3, 48, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_1_0, PMEVCNTSR2, 32, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_1_0, PMEVCNTSR1, 16, 16)
    FIELD(POR_DTM_PMEVCNTSR_U_SMXP_1_0, PMEVCNTSR0, 0, 16)
REG32(POR_MXP_ERRFR_U_SMXP_1_0, 0x80b000)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, RESERVED_15, 15, 49)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, CEC, 12, 3)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, CFI, 10, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, DE, 2, 2)
    FIELD(POR_MXP_ERRFR_U_SMXP_1_0, ED, 0, 2)
REG32(POR_MXP_ERRCTLR_U_SMXP_1_0, 0x80b008)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_1_0, RESERVED_9, 9, 55)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_1_0, CFI, 8, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_1_0, DE, 1, 1)
    FIELD(POR_MXP_ERRCTLR_U_SMXP_1_0, ED, 0, 1)
REG32(POR_MXP_ERRSTATUS_U_SMXP_1_0, 0x80b010)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, AV, 31, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, MV, 26, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, RESERVED_25, 25, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, CE, 24, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_MXP_ERRSTATUS_U_SMXP_1_0, RESERVED_0, 0, 23)
REG32(POR_MXP_ERRMISC_U_SMXP_1_0, 0x80b028)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, RESERVED_59, 59, 5)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, TGTID, 48, 11)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, RESERVED_22, 22, 26)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, OPCODE, 16, 6)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, RESERVED_15, 15, 1)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, SRCID, 4, 11)
    FIELD(POR_MXP_ERRMISC_U_SMXP_1_0, ERRSRC, 0, 3)
REG32(POR_MXP_P0_BYTE_PAR_ERR_INJ_U_SMXP_1_0, 0x80b030)
    FIELD(POR_MXP_P0_BYTE_PAR_ERR_INJ_U_SMXP_1_0, P0_BYTE_PARITY_ERR_INJ, 0, 5)
REG32(POR_MXP_P1_BYTE_PAR_ERR_INJ_U_SMXP_1_0, 0x80b038)
    FIELD(POR_MXP_P1_BYTE_PAR_ERR_INJ_U_SMXP_1_0, P1_BYTE_PARITY_ERR_INJ, 0, 5)
REG32(POR_MXP_ERRFR_NS_U_SMXP_1_0, 0x80b100)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, RESERVED_15, 15, 49)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, CEC, 12, 3)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, CFI, 10, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, DE, 2, 2)
    FIELD(POR_MXP_ERRFR_NS_U_SMXP_1_0, ED, 0, 2)
REG32(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, 0x80b108)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, RESERVED_9, 9, 55)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, CFI, 8, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, DE, 1, 1)
    FIELD(POR_MXP_ERRCTLR_NS_U_SMXP_1_0, ED, 0, 1)
REG32(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, 0x80b110)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, AV, 31, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, MV, 26, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, RESERVED_25, 25, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, CE, 24, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_MXP_ERRSTATUS_NS_U_SMXP_1_0, RESERVED_0, 0, 23)
REG32(POR_MXP_ERRMISC_NS_U_SMXP_1_0, 0x80b128)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, RESERVED_59, 59, 5)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, TGTID, 48, 11)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, RESERVED_22, 22, 26)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, OPCODE, 16, 6)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, RESERVED_15, 15, 1)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, SRCID, 4, 11)
    FIELD(POR_MXP_ERRMISC_NS_U_SMXP_1_0, ERRSRC, 0, 3)
REG32(POR_RND_NODE_INFO_U_RND_NID68, 0x814000)
    FIELD(POR_RND_NODE_INFO_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_RND_NODE_INFO_U_RND_NID68, LOGICAL_ID, 32, 16)
    FIELD(POR_RND_NODE_INFO_U_RND_NID68, NODE_ID, 16, 16)
    FIELD(POR_RND_NODE_INFO_U_RND_NID68, NODE_TYPE, 0, 16)
REG32(POR_RND_CHILD_INFO_U_RND_NID68, 0x814080)
    FIELD(POR_RND_CHILD_INFO_U_RND_NID68, RESERVED_32, 32, 32)
    FIELD(POR_RND_CHILD_INFO_U_RND_NID68, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_RND_CHILD_INFO_U_RND_NID68, CHILD_COUNT, 0, 16)
REG32(POR_RND_UNIT_INFO_U_RND_NID68, 0x814900)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, RESERVED_46, 46, 18)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, A4S_SAFE_XFACE_DISABLE, 45, 1)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, ACEL_SAFE_XFACE_DISABLE, 44, 1)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, A4S_LOGICALID_BASE, 36, 8)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, RESERVED_34, 34, 2)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, A4S_NUM, 32, 2)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, RESERVED_29, 29, 3)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, FORCE_RDB_PREALLOC, 28, 1)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, AX_DATAPOISON_EN, 27, 1)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, AX_DATA_256BIT, 26, 1)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, RESERVED_24, 24, 2)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, NUM_RD_BUFS, 16, 8)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, NUM_RD_REQS, 8, 8)
    FIELD(POR_RND_UNIT_INFO_U_RND_NID68, NUM_WR_REQS, 0, 8)
REG32(POR_RND_SECURE_REGISTER_GROUPS_OVERRIDE_U_RND_NID68, 0x814980)
    FIELD(POR_RND_SECURE_REGISTER_GROUPS_OVERRIDE_U_RND_NID68, QOS_CTRL, 2, 1)
    FIELD(POR_RND_SECURE_REGISTER_GROUPS_OVERRIDE_U_RND_NID68, PORT_CTRL, 1, 1)
    FIELD(POR_RND_SECURE_REGISTER_GROUPS_OVERRIDE_U_RND_NID68, CFG_CTL, 0, 1)
REG32(POR_RND_CFG_CTL_U_RND_NID68, 0x814a00)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, RESERVED_32, 32, 32)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, MAX_WRT_OUTSTD_CHITXN_CNT, 24, 8)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, MAX_RRT_OUTSTD_CHITXN_CNT, 16, 8)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, RESERVED_15, 15, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, WRT_CRDGNT_WEIGHT, 12, 3)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, RRT_CRDGNT_WEIGHT, 8, 3)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, DIS_NCWR_STREAM, 6, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, PCIE_MSTR_PRESENT, 5, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, QPC15_ENTRY_RSV_EN, 4, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, FORCE_PREALLOC_RDB, 3, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, DIS_WR_STREAM, 2, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, WFC, 1, 1)
    FIELD(POR_RND_CFG_CTL_U_RND_NID68, QPC_EN, 0, 1)
REG32(POR_RND_AUX_CTL_U_RND_NID68, 0x814a08)
    FIELD(POR_RND_AUX_CTL_U_RND_NID68, SAMEID_WRSTASH_STREAM_EN, 5, 1)
    FIELD(POR_RND_AUX_CTL_U_RND_NID68, UPSTRM_DATCHECK_EN, 4, 1)
    FIELD(POR_RND_AUX_CTL_U_RND_NID68, DIS_NORM_RDSTREAM, 3, 1)
    FIELD(POR_RND_AUX_CTL_U_RND_NID68, PARK_PORT_ARB_PTR, 2, 1)
    FIELD(POR_RND_AUX_CTL_U_RND_NID68, AR_BYP_EN, 1, 1)
    FIELD(POR_RND_AUX_CTL_U_RND_NID68, CG_DISABLE, 0, 1)
REG32(POR_RND_S0_PORT_CONTROL_U_RND_NID68, 0x814a10)
    FIELD(POR_RND_S0_PORT_CONTROL_U_RND_NID68, RESERVED_11, 11, 53)
    FIELD(POR_RND_S0_PORT_CONTROL_U_RND_NID68, S0_LPID_MASK, 0, 11)
REG32(POR_RND_S1_PORT_CONTROL_U_RND_NID68, 0x814a18)
    FIELD(POR_RND_S1_PORT_CONTROL_U_RND_NID68, RESERVED_11, 11, 53)
    FIELD(POR_RND_S1_PORT_CONTROL_U_RND_NID68, S1_LPID_MASK, 0, 11)
REG32(POR_RND_S2_PORT_CONTROL_U_RND_NID68, 0x814a20)
    FIELD(POR_RND_S2_PORT_CONTROL_U_RND_NID68, RESERVED_11, 11, 53)
    FIELD(POR_RND_S2_PORT_CONTROL_U_RND_NID68, S2_LPID_MASK, 0, 11)
REG32(POR_RND_S0_QOS_CONTROL_U_RND_NID68, 0x814a80)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, RESERVED_24, 24, 40)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AR_QOS_OVERRIDE, 20, 4)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AW_QOS_OVERRIDE, 16, 4)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AR_PQV_MODE, 7, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AW_PQV_MODE, 6, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AR_REG_MODE, 5, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AW_REG_MODE, 4, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AR_QOS_OVERRIDE_EN, 3, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AW_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AR_LAT_EN, 1, 1)
    FIELD(POR_RND_S0_QOS_CONTROL_U_RND_NID68, S0_AW_LAT_EN, 0, 1)
REG32(POR_RND_S0_QOS_LAT_TGT_U_RND_NID68, 0x814a88)
    FIELD(POR_RND_S0_QOS_LAT_TGT_U_RND_NID68, RESERVED_28, 28, 36)
    FIELD(POR_RND_S0_QOS_LAT_TGT_U_RND_NID68, S0_AR_LAT_TGT, 16, 12)
    FIELD(POR_RND_S0_QOS_LAT_TGT_U_RND_NID68, RESERVED_12, 12, 4)
    FIELD(POR_RND_S0_QOS_LAT_TGT_U_RND_NID68, S0_AW_LAT_TGT, 0, 12)
REG32(POR_RND_S0_QOS_LAT_SCALE_U_RND_NID68, 0x814a90)
    FIELD(POR_RND_S0_QOS_LAT_SCALE_U_RND_NID68, RESERVED_11, 11, 53)
    FIELD(POR_RND_S0_QOS_LAT_SCALE_U_RND_NID68, S0_AR_LAT_SCALE, 8, 3)
    FIELD(POR_RND_S0_QOS_LAT_SCALE_U_RND_NID68, S0_AW_LAT_SCALE, 0, 3)
REG32(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, 0x814a98)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, RESERVED_28, 28, 36)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, S0_AR_LAT_MAX_QOS, 24, 4)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, RESERVED_20, 20, 4)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, S0_AR_LAT_MIN_QOS, 16, 4)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, RESERVED_12, 12, 4)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, S0_AW_LAT_MAX_QOS, 8, 4)
    FIELD(POR_RND_S0_QOS_LAT_RANGE_U_RND_NID68, S0_AW_LAT_MIN_QOS, 0, 4)
REG32(POR_RND_S1_QOS_CONTROL_U_RND_NID68, 0x814aa0)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, RESERVED_24, 24, 40)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AR_QOS_OVERRIDE, 20, 4)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AW_QOS_OVERRIDE, 16, 4)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AR_PQV_MODE, 7, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AW_PQV_MODE, 6, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AR_REG_MODE, 5, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AW_REG_MODE, 4, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AR_QOS_OVERRIDE_EN, 3, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AW_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AR_LAT_EN, 1, 1)
    FIELD(POR_RND_S1_QOS_CONTROL_U_RND_NID68, S1_AW_LAT_EN, 0, 1)
REG32(POR_RND_S1_QOS_LAT_TGT_U_RND_NID68, 0x814aa8)
    FIELD(POR_RND_S1_QOS_LAT_TGT_U_RND_NID68, RESERVED_28, 28, 36)
    FIELD(POR_RND_S1_QOS_LAT_TGT_U_RND_NID68, S1_AR_LAT_TGT, 16, 12)
    FIELD(POR_RND_S1_QOS_LAT_TGT_U_RND_NID68, RESERVED_12, 12, 4)
    FIELD(POR_RND_S1_QOS_LAT_TGT_U_RND_NID68, S1_AW_LAT_TGT, 0, 12)
REG32(POR_RND_S1_QOS_LAT_SCALE_U_RND_NID68, 0x814ab0)
    FIELD(POR_RND_S1_QOS_LAT_SCALE_U_RND_NID68, RESERVED_11, 11, 53)
    FIELD(POR_RND_S1_QOS_LAT_SCALE_U_RND_NID68, S1_AR_LAT_SCALE, 8, 3)
    FIELD(POR_RND_S1_QOS_LAT_SCALE_U_RND_NID68, S1_AW_LAT_SCALE, 0, 3)
REG32(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, 0x814ab8)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, RESERVED_28, 28, 36)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, S1_AR_LAT_MAX_QOS, 24, 4)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, RESERVED_20, 20, 4)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, S1_AR_LAT_MIN_QOS, 16, 4)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, RESERVED_12, 12, 4)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, S1_AW_LAT_MAX_QOS, 8, 4)
    FIELD(POR_RND_S1_QOS_LAT_RANGE_U_RND_NID68, S1_AW_LAT_MIN_QOS, 0, 4)
REG32(POR_RND_S2_QOS_CONTROL_U_RND_NID68, 0x814ac0)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, RESERVED_24, 24, 40)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AR_QOS_OVERRIDE, 20, 4)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AW_QOS_OVERRIDE, 16, 4)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AR_PQV_MODE, 7, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AW_PQV_MODE, 6, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AR_REG_MODE, 5, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AW_REG_MODE, 4, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AR_QOS_OVERRIDE_EN, 3, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AW_QOS_OVERRIDE_EN, 2, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AR_LAT_EN, 1, 1)
    FIELD(POR_RND_S2_QOS_CONTROL_U_RND_NID68, S2_AW_LAT_EN, 0, 1)
REG32(POR_RND_S2_QOS_LAT_TGT_U_RND_NID68, 0x814ac8)
    FIELD(POR_RND_S2_QOS_LAT_TGT_U_RND_NID68, RESERVED_28, 28, 36)
    FIELD(POR_RND_S2_QOS_LAT_TGT_U_RND_NID68, S2_AR_LAT_TGT, 16, 12)
    FIELD(POR_RND_S2_QOS_LAT_TGT_U_RND_NID68, RESERVED_12, 12, 4)
    FIELD(POR_RND_S2_QOS_LAT_TGT_U_RND_NID68, S2_AW_LAT_TGT, 0, 12)
REG32(POR_RND_S2_QOS_LAT_SCALE_U_RND_NID68, 0x814ad0)
    FIELD(POR_RND_S2_QOS_LAT_SCALE_U_RND_NID68, RESERVED_11, 11, 53)
    FIELD(POR_RND_S2_QOS_LAT_SCALE_U_RND_NID68, S2_AR_LAT_SCALE, 8, 3)
    FIELD(POR_RND_S2_QOS_LAT_SCALE_U_RND_NID68, S2_AW_LAT_SCALE, 0, 3)
REG32(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, 0x814ad8)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, RESERVED_28, 28, 36)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, S2_AR_LAT_MAX_QOS, 24, 4)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, RESERVED_20, 20, 4)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, S2_AR_LAT_MIN_QOS, 16, 4)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, RESERVED_12, 12, 4)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, S2_AW_LAT_MAX_QOS, 8, 4)
    FIELD(POR_RND_S2_QOS_LAT_RANGE_U_RND_NID68, S2_AW_LAT_MIN_QOS, 0, 4)
REG32(POR_RND_SYSCOREQ_CTL_U_RND_NID68, 0x815000)
    FIELD(POR_RND_SYSCOREQ_CTL_U_RND_NID68, S2_DVMDOMAIN_REQ, 2, 1)
    FIELD(POR_RND_SYSCOREQ_CTL_U_RND_NID68, S1_DVMDOMAIN_REQ, 1, 1)
    FIELD(POR_RND_SYSCOREQ_CTL_U_RND_NID68, S0_DVMDOMAIN_REQ, 0, 1)
REG32(POR_RND_SYSCOACK_STATUS_U_RND_NID68, 0x815008)
    FIELD(POR_RND_SYSCOACK_STATUS_U_RND_NID68, S2_DVMDOMAIN_ACK, 2, 1)
    FIELD(POR_RND_SYSCOACK_STATUS_U_RND_NID68, S1_DVMDOMAIN_ACK, 1, 1)
    FIELD(POR_RND_SYSCOACK_STATUS_U_RND_NID68, S0_DVMDOMAIN_ACK, 0, 1)
REG32(POR_RND_PMU_EVENT_SEL_U_RND_NID68, 0x816000)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, RESERVED_29, 29, 35)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, PMU_EVENT3_ID, 24, 5)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, RESERVED_21, 21, 3)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, PMU_EVENT2_ID, 16, 5)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, RESERVED_13, 13, 3)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, PMU_EVENT1_ID, 8, 5)
    FIELD(POR_RND_PMU_EVENT_SEL_U_RND_NID68, PMU_EVENT0_ID, 0, 5)
REG32(POR_RNSAM_NODE_INFO_U_RND_NID68, 0x824000)
    FIELD(POR_RNSAM_NODE_INFO_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RND_NID68, LOGICAL_ID, 32, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RND_NID68, NODE_ID, 16, 16)
    FIELD(POR_RNSAM_NODE_INFO_U_RND_NID68, NODE_TYPE, 0, 16)
REG32(POR_RNSAM_CHILD_INFO_U_RND_NID68, 0x824080)
    FIELD(POR_RNSAM_CHILD_INFO_U_RND_NID68, RESERVED_32, 32, 32)
    FIELD(POR_RNSAM_CHILD_INFO_U_RND_NID68, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_RNSAM_CHILD_INFO_U_RND_NID68, CHILD_COUNT, 0, 16)
REG32(POR_RNSAM_UNIT_INFO_U_RND_NID68, 0x824900)
    FIELD(POR_RNSAM_UNIT_INFO_U_RND_NID68, RESERVED_37, 37, 27)
    FIELD(POR_RNSAM_UNIT_INFO_U_RND_NID68, NUM_NON_HASH_GROUP, 32, 5)
    FIELD(POR_RNSAM_UNIT_INFO_U_RND_NID68, RESERVED_20, 20, 12)
    FIELD(POR_RNSAM_UNIT_INFO_U_RND_NID68, NUM_SYS_CACHE_GROUP, 16, 4)
    FIELD(POR_RNSAM_UNIT_INFO_U_RND_NID68, NUM_HNF, 0, 8)
REG32(POR_RNSAM_SECURE_REGISTER_GROUPS_OVERRIDE_U_RND_NID68, 0x824980)
    FIELD(POR_RNSAM_SECURE_REGISTER_GROUPS_OVERRIDE_U_RND_NID68, MEM_RANGE, 0, 1)
REG32(RNSAM_STATUS_U_RND_NID68, 0x824c00)
    FIELD(RNSAM_STATUS_U_RND_NID68, NSTALL_REQ, 1, 1)
    FIELD(RNSAM_STATUS_U_RND_NID68, USE_DEFAULT_NODE, 0, 1)
REG32(NON_HASH_MEM_REGION_REG0_U_RND_NID68, 0x824c08)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION1_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION1_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION1_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION1_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION0_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION0_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION0_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG0_U_RND_NID68, REGION0_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG1_U_RND_NID68, 0x824c10)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION3_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION3_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION3_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION3_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION2_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION2_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION2_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG1_U_RND_NID68, REGION2_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG2_U_RND_NID68, 0x824c18)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION5_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION5_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION5_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION5_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION4_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION4_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION4_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG2_U_RND_NID68, REGION4_VALID, 0, 1)
REG32(NON_HASH_MEM_REGION_REG3_U_RND_NID68, 0x824c20)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION7_BASE_ADDR, 41, 22)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION7_SIZE, 36, 5)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION7_TARGET_TYPE, 34, 2)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, RESERVED_33, 33, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION7_VALID, 32, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION6_BASE_ADDR, 9, 22)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION6_SIZE, 4, 5)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION6_TARGET_TYPE, 2, 2)
    FIELD(NON_HASH_MEM_REGION_REG3_U_RND_NID68, REGION6_VALID, 0, 1)
REG32(NON_HASH_TGT_NODEID0_U_RND_NID68, 0x824c30)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, NODEID_3, 36, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, NODEID_2, 24, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, NODEID_1, 12, 11)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID0_U_RND_NID68, NODEID_0, 0, 11)
REG32(NON_HASH_TGT_NODEID1_U_RND_NID68, 0x824c38)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, NODEID_7, 36, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, NODEID_6, 24, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, NODEID_5, 12, 11)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID1_U_RND_NID68, NODEID_4, 0, 11)
REG32(NON_HASH_TGT_NODEID2_U_RND_NID68, 0x824c40)
    FIELD(NON_HASH_TGT_NODEID2_U_RND_NID68, RESERVED_23, 23, 41)
    FIELD(NON_HASH_TGT_NODEID2_U_RND_NID68, NODEID_9, 12, 11)
    FIELD(NON_HASH_TGT_NODEID2_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(NON_HASH_TGT_NODEID2_U_RND_NID68, NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_REGION0_U_RND_NID68, 0x824c48)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION1_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION1_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION1_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION1_NONHASH_REG_EN, 33, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION1_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION0_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION0_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION0_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_REGION0_U_RND_NID68, REGION0_VALID, 0, 1)
REG32(SYS_CACHE_GRP_REGION1_U_RND_NID68, 0x824c50)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION3_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION3_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION3_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION3_NONHASH_REG_EN, 33, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION3_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION2_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION2_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION2_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION2_NONHASH_REG_EN, 1, 1)
    FIELD(SYS_CACHE_GRP_REGION1_U_RND_NID68, REGION2_VALID, 0, 1)
REG32(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, 0x824c58)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, NODEID_3, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, NODEID_2, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, NODEID_1, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG0_U_RND_NID68, NODEID_0, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, 0x824c60)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, NODEID_7, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, NODEID_6, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, NODEID_5, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG1_U_RND_NID68, NODEID_4, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, 0x824c68)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, NODEID_11, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, NODEID_10, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, NODEID_9, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG2_U_RND_NID68, NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, 0x824c70)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, NODEID_15, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, NODEID_14, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, NODEID_13, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG3_U_RND_NID68, NODEID_12, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, 0x824c78)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, NODEID_19, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, NODEID_18, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, NODEID_17, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG4_U_RND_NID68, NODEID_16, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, 0x824c80)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, NODEID_23, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, NODEID_22, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, NODEID_21, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG5_U_RND_NID68, NODEID_20, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, 0x824c88)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, NODEID_27, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, NODEID_26, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, NODEID_25, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG6_U_RND_NID68, NODEID_24, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, 0x824c90)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, NODEID_31, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, NODEID_30, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, NODEID_29, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG7_U_RND_NID68, NODEID_28, 0, 11)
REG32(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, 0x824c98)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, RESERVED_35, 35, 29)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, SCG3_NODEID, 24, 11)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, SCG2_NODEID, 12, 11)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_NONHASH_NODEID_U_RND_NID68, SCG1_NODEID, 0, 11)
REG32(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, 0x824d00)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, RESERVED_31, 31, 33)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, SCG3_NUM_HNF, 24, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, SCG2_NUM_HNF, 16, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, RESERVED_15, 15, 1)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, SCG1_NUM_HNF, 8, 7)
    FIELD(SYS_CACHE_GROUP_HN_COUNT_U_RND_NID68, SCG0_NUM_HNF, 0, 7)
REG32(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, 0x824d08)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, SN_NODEID_3, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, SN_NODEID_2, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, SN_NODEID_1, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG0_U_RND_NID68, SN_NODEID_0, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, 0x824d10)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, SN_NODEID_7, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, SN_NODEID_6, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, SN_NODEID_5, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG1_U_RND_NID68, SN_NODEID_4, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, 0x824d18)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, SN_NODEID_11, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, SN_NODEID_10, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, SN_NODEID_9, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG2_U_RND_NID68, SN_NODEID_8, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, 0x824d20)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, SN_NODEID_15, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, SN_NODEID_14, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, SN_NODEID_13, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG3_U_RND_NID68, SN_NODEID_12, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, 0x824d28)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, SN_NODEID_19, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, SN_NODEID_18, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, SN_NODEID_17, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG4_U_RND_NID68, SN_NODEID_16, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, 0x824d30)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, SN_NODEID_23, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, SN_NODEID_22, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, SN_NODEID_21, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG5_U_RND_NID68, SN_NODEID_20, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, 0x824d38)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, SN_NODEID_27, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, SN_NODEID_26, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, SN_NODEID_25, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG6_U_RND_NID68, SN_NODEID_24, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, 0x824d40)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, SN_NODEID_31, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, SN_NODEID_30, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, SN_NODEID_29, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG7_U_RND_NID68, SN_NODEID_28, 0, 11)
REG32(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, 0x824d48)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, RESERVED_46, 46, 18)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, SCG1_TOP_ADDRESS_BIT2, 40, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, RESERVED_38, 38, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, SCG1_TOP_ADDRESS_BIT1, 32, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, RESERVED_30, 30, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, SCG1_TOP_ADDRESS_BIT0, 24, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, RESERVED_22, 22, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, SCG0_TOP_ADDRESS_BIT2, 16, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, RESERVED_14, 14, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, SCG0_TOP_ADDRESS_BIT1, 8, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG0_U_RND_NID68, SCG0_TOP_ADDRESS_BIT0, 0, 6)
REG32(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, 0x824d50)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, RESERVED_46, 46, 18)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, SCG3_TOP_ADDRESS_BIT2, 40, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, RESERVED_38, 38, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, SCG3_TOP_ADDRESS_BIT1, 32, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, RESERVED_30, 30, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, SCG3_TOP_ADDRESS_BIT0, 24, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, RESERVED_22, 22, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, SCG2_TOP_ADDRESS_BIT2, 16, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, RESERVED_14, 14, 2)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, SCG2_TOP_ADDRESS_BIT1, 8, 6)
    FIELD(SYS_CACHE_GRP_SN_SAM_CFG1_U_RND_NID68, SCG2_TOP_ADDRESS_BIT0, 0, 6)
REG32(GIC_MEM_REGION_REG_U_RND_NID68, 0x824d58)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, GIC_REGION_NODEID, 52, 11)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, RESERVED_48, 48, 4)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, GIC_REGION_BASE_ADDR, 16, 32)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, GIC_REGION_SIZE, 4, 3)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, GIC_REGION_TARGET_TYPE, 2, 2)
    FIELD(GIC_MEM_REGION_REG_U_RND_NID68, GIC_REGION_VALID, 0, 1)
REG32(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, 0x824d60)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, RESERVED_54, 54, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, SN_MODE_SYS_CACHE_GRP3, 52, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, RESERVED_49, 49, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP3, 48, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, RESERVED_38, 38, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, SN_MODE_SYS_CACHE_GRP2, 36, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, RESERVED_33, 33, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP2, 32, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, RESERVED_22, 22, 10)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, SN_MODE_SYS_CACHE_GRP1, 20, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, RESERVED_17, 17, 3)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP1, 16, 1)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, SN_MODE_SYS_CACHE_GRP0, 4, 2)
    FIELD(SYS_CACHE_GRP_SN_ATTR_U_RND_NID68, INV_TOP_ADDRESS_BIT_SYS_CACHE_GRP0, 0, 1)
REG32(SYS_CACHE_GRP_HN_CPA_EN_REG_U_RND_NID68, 0x824d68)
REG32(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, 0x824d70)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, RESERVED_50, 50, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, CPA_GRP_SCG3, 48, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, RESERVED_34, 34, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, CPA_GRP_SCG2, 32, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, RESERVED_18, 18, 14)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, CPA_GRP_SCG1, 16, 2)
    FIELD(SYS_CACHE_GRP_HN_CPA_GRP_REG_U_RND_NID68, CPA_GRP_SCG0, 0, 2)
REG32(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, 0x824e00)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_32, 32, 32)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION7_PAG_GRPID, 30, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_29, 29, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION7_PAG_EN, 28, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_27, 27, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION6_PAG_GRPID, 25, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION6_PAG_EN, 24, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION5_PAG_GRPID, 21, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION5_PAG_EN, 20, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_19, 19, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION4_PAG_GRPID, 17, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION4_PAG_EN, 16, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_15, 15, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION3_PAG_GRPID, 13, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION3_PAG_EN, 12, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION2_PAG_GRPID, 9, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION2_PAG_EN, 8, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION1_PAG_GRPID, 5, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION1_PAG_EN, 4, 1)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION0_PAG_GRPID, 1, 2)
    FIELD(CML_PORT_AGGR_MODE_CTRL_REG_U_RND_NID68, REGION0_PAG_EN, 0, 1)
REG32(CML_PORT_AGGR_GRP0_ADD_MASK_U_RND_NID68, 0x824e08)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RND_NID68, ADDR_MASK, 6, 42)
    FIELD(CML_PORT_AGGR_GRP0_ADD_MASK_U_RND_NID68, RESERVED_0, 0, 6)
REG32(CML_PORT_AGGR_GRP1_ADD_MASK_U_RND_NID68, 0x824e10)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RND_NID68, ADDR_MASK, 6, 42)
    FIELD(CML_PORT_AGGR_GRP1_ADD_MASK_U_RND_NID68, RESERVED_0, 0, 6)
REG32(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, 0x824e40)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, RESERVED_50, 50, 14)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, NUM_CXG_PAG0, 48, 2)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, RESERVED_47, 47, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, PAG0_TGTID3, 36, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, PAG0_TGTID2, 24, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, PAG0_TGTID1, 12, 11)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_GRP0_REG_U_RND_NID68, PAG0_TGTID0, 0, 11)
REG32(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, 0x824e48)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, RESERVED_50, 50, 14)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, NUM_CXG_PAG1, 48, 2)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, RESERVED_47, 47, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, PAG1_TGTID3, 36, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, PAG1_TGTID2, 24, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, PAG1_TGTID1, 12, 11)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(CML_PORT_AGGR_GRP1_REG_U_RND_NID68, PAG1_TGTID0, 0, 11)
REG32(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, 0x824f00)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION1_SCNDRY_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION1_SCNDRY_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION1_SCNDRY_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, RESERVED_33, 33, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION1_SCNDRY_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION0_SCNDRY_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION0_SCNDRY_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION0_SCNDRY_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG0_U_RND_NID68, REGION0_SCNDRY_VALID, 0, 1)
REG32(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, 0x824f08)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, RESERVED_63, 63, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION3_SCNDRY_BASE_ADDR, 41, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION3_SCNDRY_SIZE, 36, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION3_SCNDRY_TARGET_TYPE, 34, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, RESERVED_33, 33, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION3_SCNDRY_VALID, 32, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, RESERVED_31, 31, 1)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION2_SCNDRY_BASE_ADDR, 9, 22)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION2_SCNDRY_SIZE, 4, 5)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION2_SCNDRY_TARGET_TYPE, 2, 2)
    FIELD(SYS_CACHE_GRP_SECONDARY_REG1_U_RND_NID68, REGION2_SCNDRY_VALID, 0, 1)
REG32(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, 0x824f10)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, RESERVED_49, 49, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, SCG3_HNF_CAL_MODE_EN, 48, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, RESERVED_33, 33, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, SCG2_HNF_CAL_MODE_EN, 32, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, RESERVED_17, 17, 15)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, SCG1_HNF_CAL_MODE_EN, 16, 1)
    FIELD(SYS_CACHE_GRP_CAL_MODE_REG_U_RND_NID68, SCG0_HNF_CAL_MODE_EN, 0, 1)
REG32(RNSAM_HASH_ADDR_MASK_REG_U_RND_NID68, 0x824f18)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RND_NID68, ADDR_MASK, 6, 42)
    FIELD(RNSAM_HASH_ADDR_MASK_REG_U_RND_NID68, RESERVED_0, 0, 6)
REG32(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RND_NID68, 0x824f20)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RND_NID68, ADDR_MASK, 16, 32)
    FIELD(RNSAM_REGION_CMP_ADDR_MASK_REG_U_RND_NID68, RESERVED_0, 0, 16)
REG32(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, 0x824f58)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, NODEID_35, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, NODEID_34, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, NODEID_33, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG8_U_RND_NID68, NODEID_32, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, 0x824f60)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, NODEID_39, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, NODEID_38, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, NODEID_37, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG9_U_RND_NID68, NODEID_36, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, 0x824f68)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, NODEID_43, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, NODEID_42, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, NODEID_41, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG10_U_RND_NID68, NODEID_40, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, 0x824f70)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, NODEID_47, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, NODEID_46, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, NODEID_45, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG11_U_RND_NID68, NODEID_44, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, 0x824f78)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, NODEID_51, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, NODEID_50, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, NODEID_49, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG12_U_RND_NID68, NODEID_48, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, 0x824f80)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, NODEID_55, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, NODEID_54, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, NODEID_53, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG13_U_RND_NID68, NODEID_52, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, 0x824f88)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, NODEID_59, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, NODEID_58, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, NODEID_57, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG14_U_RND_NID68, NODEID_56, 0, 11)
REG32(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, 0x824f90)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, NODEID_63, 36, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, NODEID_62, 24, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, NODEID_61, 12, 11)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_HN_NODEID_REG15_U_RND_NID68, NODEID_60, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, 0x825008)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, SN_NODEID_35, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, SN_NODEID_34, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, SN_NODEID_33, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG8_U_RND_NID68, SN_NODEID_32, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, 0x825010)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, SN_NODEID_39, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, SN_NODEID_38, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, SN_NODEID_37, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG9_U_RND_NID68, SN_NODEID_36, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, 0x825018)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, SN_NODEID_43, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, SN_NODEID_42, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, SN_NODEID_41, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG10_U_RND_NID68, SN_NODEID_40, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, 0x825020)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, SN_NODEID_47, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, SN_NODEID_46, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, SN_NODEID_45, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG11_U_RND_NID68, SN_NODEID_44, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, 0x825028)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, SN_NODEID_51, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, SN_NODEID_50, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, SN_NODEID_49, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG12_U_RND_NID68, SN_NODEID_48, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, 0x825030)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, SN_NODEID_55, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, SN_NODEID_54, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, SN_NODEID_53, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG13_U_RND_NID68, SN_NODEID_52, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, 0x825038)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, SN_NODEID_59, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, SN_NODEID_58, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, SN_NODEID_57, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG14_U_RND_NID68, SN_NODEID_56, 0, 11)
REG32(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, 0x825040)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, RESERVED_47, 47, 17)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, SN_NODEID_63, 36, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, RESERVED_35, 35, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, SN_NODEID_62, 24, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, RESERVED_23, 23, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, SN_NODEID_61, 12, 11)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, RESERVED_11, 11, 1)
    FIELD(SYS_CACHE_GRP_SN_NODEID_REG15_U_RND_NID68, SN_NODEID_60, 0, 11)
REG32(POR_FDC_NODE_INFO_U_SMXP_1_0, 0x82c000)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_1_0, RESERVED_48, 48, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_1_0, LOGICAL_ID, 32, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_1_0, NODE_ID, 16, 16)
    FIELD(POR_FDC_NODE_INFO_U_SMXP_1_0, NODE_TYPE, 0, 16)
REG32(POR_FDC_CHILD_INFO_U_SMXP_1_0, 0x82c080)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_1_0, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_FDC_CHILD_INFO_U_SMXP_1_0, CHILD_COUNT, 0, 16)
REG32(POR_ERRFR_MXP_U_SMXP_1_0, 0x82f000)
    FIELD(POR_ERRFR_MXP_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_MXP_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_MXP_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_MXP_U_SMXP_1_0, 0x82f008)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_MXP_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_MXP_U_SMXP_1_0, 0x82f010)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_MXP_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_MXP_U_SMXP_1_0, 0x82f018)
    FIELD(POR_FDC_AUX_CTL_MXP_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_MXP_U_SMXP_1_0, RESERVED_0, 0, 4)
REG32(POR_ERRFR_P0_D0_U_SMXP_1_0, 0x82f040)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D0_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D0_U_SMXP_1_0, 0x82f048)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D0_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, 0x82f050)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D0_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D0_U_SMXP_1_0, 0x82f058)
    FIELD(POR_FDC_AUX_CTL_P0_D0_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D0_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D1_U_SMXP_1_0, 0x82f080)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D1_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D1_U_SMXP_1_0, 0x82f088)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D1_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, 0x82f090)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D1_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D1_U_SMXP_1_0, 0x82f098)
    FIELD(POR_FDC_AUX_CTL_P0_D1_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D1_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D2_U_SMXP_1_0, 0x82f0c0)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D2_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D2_U_SMXP_1_0, 0x82f0c8)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D2_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, 0x82f0d0)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D2_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D2_U_SMXP_1_0, 0x82f0d8)
    FIELD(POR_FDC_AUX_CTL_P0_D2_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D2_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P0_D3_U_SMXP_1_0, 0x82f100)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P0_D3_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P0_D3_U_SMXP_1_0, 0x82f108)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P0_D3_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, 0x82f110)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P0_D3_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P0_D3_U_SMXP_1_0, 0x82f118)
    FIELD(POR_FDC_AUX_CTL_P0_D3_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P0_D3_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D0_U_SMXP_1_0, 0x82f140)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D0_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D0_U_SMXP_1_0, 0x82f148)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D0_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, 0x82f150)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D0_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D0_U_SMXP_1_0, 0x82f158)
    FIELD(POR_FDC_AUX_CTL_P1_D0_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D0_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D1_U_SMXP_1_0, 0x82f180)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D1_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D1_U_SMXP_1_0, 0x82f188)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D1_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, 0x82f190)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D1_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D1_U_SMXP_1_0, 0x82f198)
    FIELD(POR_FDC_AUX_CTL_P1_D1_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D1_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D2_U_SMXP_1_0, 0x82f1c0)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D2_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D2_U_SMXP_1_0, 0x82f1c8)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D2_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, 0x82f1d0)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D2_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D2_U_SMXP_1_0, 0x82f1d8)
    FIELD(POR_FDC_AUX_CTL_P1_D2_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D2_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRFR_P1_D3_U_SMXP_1_0, 0x82f200)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_1_0, FI, 6, 2)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_1_0, UI, 4, 2)
    FIELD(POR_ERRFR_P1_D3_U_SMXP_1_0, ED, 0, 2)
REG32(POR_ERRCTLR_P1_D3_U_SMXP_1_0, 0x82f208)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_1_0, RESERVED_32, 32, 32)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_1_0, ERC, 14, 18)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_1_0, FI, 3, 1)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_1_0, UI, 2, 1)
    FIELD(POR_ERRCTLR_P1_D3_U_SMXP_1_0, ED, 0, 1)
REG32(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, 0x82f210)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, RESERVED_31, 31, 33)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, V, 30, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, UE, 29, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, RESERVED_28, 28, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, OF, 27, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, RESERVED_24, 24, 3)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, DE, 23, 1)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, RESERVED_16, 16, 7)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, V_ERR_TYPE, 6, 10)
    FIELD(POR_ERRSTATUS_P1_D3_U_SMXP_1_0, RESERVED_0, 0, 6)
REG32(POR_FDC_AUX_CTL_P1_D3_U_SMXP_1_0, 0x82f218)
    FIELD(POR_FDC_AUX_CTL_P1_D3_U_SMXP_1_0, CLKGATE_OVERRIDE, 4, 1)
    FIELD(POR_FDC_AUX_CTL_P1_D3_U_SMXP_1_0, HANG_DET_CONFIG, 0, 4)
REG32(POR_ERRINJECT_U_SMXP_1_0, 0x82f300)
    FIELD(POR_ERRINJECT_U_SMXP_1_0, ERR_DEV, 4, 4)
    FIELD(POR_ERRINJECT_U_SMXP_1_0, ERR_TYPE, 0, 4)
REG32(POR_FDC_KEY_U_SMXP_1_0, 0x82f308)
    FIELD(POR_FDC_KEY_U_SMXP_1_0, KEY, 0, 8)
REG32(POR_MPU_NODE_INFO_U_RND_NID68, 0x834000)
    FIELD(POR_MPU_NODE_INFO_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_NODE_INFO_U_RND_NID68, LOGICAL_ID, 32, 16)
    FIELD(POR_MPU_NODE_INFO_U_RND_NID68, NODE_ID, 16, 16)
    FIELD(POR_MPU_NODE_INFO_U_RND_NID68, NODE_TYPE, 0, 16)
REG32(POR_MPU_CHILD_INFO_U_RND_NID68, 0x834080)
    FIELD(POR_MPU_CHILD_INFO_U_RND_NID68, RESERVED_32, 32, 32)
    FIELD(POR_MPU_CHILD_INFO_U_RND_NID68, CHILD_PTR_OFFSET, 16, 16)
    FIELD(POR_MPU_CHILD_INFO_U_RND_NID68, CHILD_COUNT, 0, 16)
REG32(POR_MPU_UNIT_INFO_U_RND_NID68, 0x834900)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, RESERVED_16, 16, 48)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_7_PRESENT, 15, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_6_PRESENT, 14, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_5_PRESENT, 13, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_4_PRESENT, 12, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_3_PRESENT, 11, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_2_PRESENT, 10, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_1_PRESENT, 9, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, MASTER_0_PRESENT, 8, 1)
    FIELD(POR_MPU_UNIT_INFO_U_RND_NID68, NUM_PROG_REGION, 0, 8)
REG32(POR_MPU_M0_CTL_U_RND_NID68, 0x835000)
    FIELD(POR_MPU_M0_CTL_U_RND_NID68, M0_EN, 2, 1)
    FIELD(POR_MPU_M0_CTL_U_RND_NID68, M0_ACTION, 0, 2)
REG32(POR_MPU_M0_PRBAR0_U_RND_NID68, 0x835010)
    FIELD(POR_MPU_M0_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR0_U_RND_NID68, 0x835018)
    FIELD(POR_MPU_M0_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR1_U_RND_NID68, 0x835020)
    FIELD(POR_MPU_M0_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR1_U_RND_NID68, 0x835028)
    FIELD(POR_MPU_M0_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR2_U_RND_NID68, 0x835030)
    FIELD(POR_MPU_M0_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR2_U_RND_NID68, 0x835038)
    FIELD(POR_MPU_M0_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR3_U_RND_NID68, 0x835040)
    FIELD(POR_MPU_M0_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR3_U_RND_NID68, 0x835048)
    FIELD(POR_MPU_M0_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR4_U_RND_NID68, 0x835050)
    FIELD(POR_MPU_M0_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR4_U_RND_NID68, 0x835058)
    FIELD(POR_MPU_M0_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR5_U_RND_NID68, 0x835060)
    FIELD(POR_MPU_M0_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR5_U_RND_NID68, 0x835068)
    FIELD(POR_MPU_M0_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR6_U_RND_NID68, 0x835070)
    FIELD(POR_MPU_M0_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR6_U_RND_NID68, 0x835078)
    FIELD(POR_MPU_M0_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR7_U_RND_NID68, 0x835080)
    FIELD(POR_MPU_M0_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR7_U_RND_NID68, 0x835088)
    FIELD(POR_MPU_M0_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR8_U_RND_NID68, 0x835090)
    FIELD(POR_MPU_M0_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR8_U_RND_NID68, 0x835098)
    FIELD(POR_MPU_M0_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR9_U_RND_NID68, 0x8350a0)
    FIELD(POR_MPU_M0_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR9_U_RND_NID68, 0x8350a8)
    FIELD(POR_MPU_M0_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR10_U_RND_NID68, 0x8350b0)
    FIELD(POR_MPU_M0_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR10_U_RND_NID68, 0x8350b8)
    FIELD(POR_MPU_M0_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR11_U_RND_NID68, 0x8350c0)
    FIELD(POR_MPU_M0_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR11_U_RND_NID68, 0x8350c8)
    FIELD(POR_MPU_M0_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR12_U_RND_NID68, 0x8350d0)
    FIELD(POR_MPU_M0_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR12_U_RND_NID68, 0x8350d8)
    FIELD(POR_MPU_M0_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR13_U_RND_NID68, 0x8350e0)
    FIELD(POR_MPU_M0_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR13_U_RND_NID68, 0x8350e8)
    FIELD(POR_MPU_M0_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR14_U_RND_NID68, 0x8350f0)
    FIELD(POR_MPU_M0_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR14_U_RND_NID68, 0x8350f8)
    FIELD(POR_MPU_M0_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR15_U_RND_NID68, 0x835100)
    FIELD(POR_MPU_M0_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR15_U_RND_NID68, 0x835108)
    FIELD(POR_MPU_M0_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR16_U_RND_NID68, 0x835110)
    FIELD(POR_MPU_M0_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR16_U_RND_NID68, 0x835118)
    FIELD(POR_MPU_M0_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR17_U_RND_NID68, 0x835120)
    FIELD(POR_MPU_M0_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR17_U_RND_NID68, 0x835128)
    FIELD(POR_MPU_M0_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR18_U_RND_NID68, 0x835130)
    FIELD(POR_MPU_M0_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR18_U_RND_NID68, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR18_U_RND_NID68, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR18_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR18_U_RND_NID68, 0x835138)
    FIELD(POR_MPU_M0_PRLAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR18_U_RND_NID68, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR18_U_RND_NID68, REGION18_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR19_U_RND_NID68, 0x835140)
    FIELD(POR_MPU_M0_PRBAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR19_U_RND_NID68, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR19_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR19_U_RND_NID68, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR19_U_RND_NID68, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR19_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR19_U_RND_NID68, 0x835148)
    FIELD(POR_MPU_M0_PRLAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR19_U_RND_NID68, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR19_U_RND_NID68, REGION19_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR20_U_RND_NID68, 0x835150)
    FIELD(POR_MPU_M0_PRBAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR20_U_RND_NID68, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR20_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR20_U_RND_NID68, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR20_U_RND_NID68, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR20_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR20_U_RND_NID68, 0x835158)
    FIELD(POR_MPU_M0_PRLAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR20_U_RND_NID68, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR20_U_RND_NID68, REGION20_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR21_U_RND_NID68, 0x835160)
    FIELD(POR_MPU_M0_PRBAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR21_U_RND_NID68, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR21_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR21_U_RND_NID68, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR21_U_RND_NID68, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR21_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR21_U_RND_NID68, 0x835168)
    FIELD(POR_MPU_M0_PRLAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR21_U_RND_NID68, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR21_U_RND_NID68, REGION21_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR22_U_RND_NID68, 0x835170)
    FIELD(POR_MPU_M0_PRBAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR22_U_RND_NID68, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR22_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR22_U_RND_NID68, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR22_U_RND_NID68, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR22_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR22_U_RND_NID68, 0x835178)
    FIELD(POR_MPU_M0_PRLAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR22_U_RND_NID68, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR22_U_RND_NID68, REGION22_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR23_U_RND_NID68, 0x835180)
    FIELD(POR_MPU_M0_PRBAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR23_U_RND_NID68, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR23_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR23_U_RND_NID68, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR23_U_RND_NID68, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR23_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR23_U_RND_NID68, 0x835188)
    FIELD(POR_MPU_M0_PRLAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR23_U_RND_NID68, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR23_U_RND_NID68, REGION23_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR24_U_RND_NID68, 0x835190)
    FIELD(POR_MPU_M0_PRBAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR24_U_RND_NID68, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR24_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR24_U_RND_NID68, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR24_U_RND_NID68, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR24_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR24_U_RND_NID68, 0x835198)
    FIELD(POR_MPU_M0_PRLAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR24_U_RND_NID68, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR24_U_RND_NID68, REGION24_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR25_U_RND_NID68, 0x8351a0)
    FIELD(POR_MPU_M0_PRBAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR25_U_RND_NID68, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR25_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR25_U_RND_NID68, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR25_U_RND_NID68, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR25_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR25_U_RND_NID68, 0x8351a8)
    FIELD(POR_MPU_M0_PRLAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR25_U_RND_NID68, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR25_U_RND_NID68, REGION25_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR26_U_RND_NID68, 0x8351b0)
    FIELD(POR_MPU_M0_PRBAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR26_U_RND_NID68, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR26_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR26_U_RND_NID68, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR26_U_RND_NID68, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR26_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR26_U_RND_NID68, 0x8351b8)
    FIELD(POR_MPU_M0_PRLAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR26_U_RND_NID68, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR26_U_RND_NID68, REGION26_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR27_U_RND_NID68, 0x8351c0)
    FIELD(POR_MPU_M0_PRBAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR27_U_RND_NID68, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR27_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR27_U_RND_NID68, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR27_U_RND_NID68, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR27_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR27_U_RND_NID68, 0x8351c8)
    FIELD(POR_MPU_M0_PRLAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR27_U_RND_NID68, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR27_U_RND_NID68, REGION27_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR28_U_RND_NID68, 0x8351d0)
    FIELD(POR_MPU_M0_PRBAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR28_U_RND_NID68, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR28_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR28_U_RND_NID68, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR28_U_RND_NID68, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR28_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR28_U_RND_NID68, 0x8351d8)
    FIELD(POR_MPU_M0_PRLAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR28_U_RND_NID68, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR28_U_RND_NID68, REGION28_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR29_U_RND_NID68, 0x8351e0)
    FIELD(POR_MPU_M0_PRBAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR29_U_RND_NID68, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR29_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR29_U_RND_NID68, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR29_U_RND_NID68, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR29_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR29_U_RND_NID68, 0x8351e8)
    FIELD(POR_MPU_M0_PRLAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR29_U_RND_NID68, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR29_U_RND_NID68, REGION29_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR30_U_RND_NID68, 0x8351f0)
    FIELD(POR_MPU_M0_PRBAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR30_U_RND_NID68, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR30_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR30_U_RND_NID68, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR30_U_RND_NID68, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR30_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR30_U_RND_NID68, 0x8351f8)
    FIELD(POR_MPU_M0_PRLAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR30_U_RND_NID68, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR30_U_RND_NID68, REGION30_EN, 0, 1)
REG32(POR_MPU_M0_PRBAR31_U_RND_NID68, 0x835200)
    FIELD(POR_MPU_M0_PRBAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRBAR31_U_RND_NID68, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRBAR31_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M0_PRBAR31_U_RND_NID68, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M0_PRBAR31_U_RND_NID68, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M0_PRBAR31_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M0_PRLAR31_U_RND_NID68, 0x835208)
    FIELD(POR_MPU_M0_PRLAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M0_PRLAR31_U_RND_NID68, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M0_PRLAR31_U_RND_NID68, REGION31_EN, 0, 1)
REG32(POR_MPU_M1_CTL_U_RND_NID68, 0x835400)
    FIELD(POR_MPU_M1_CTL_U_RND_NID68, M1_EN, 2, 1)
    FIELD(POR_MPU_M1_CTL_U_RND_NID68, M1_ACTION, 0, 2)
REG32(POR_MPU_M1_PRBAR0_U_RND_NID68, 0x835410)
    FIELD(POR_MPU_M1_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR0_U_RND_NID68, 0x835418)
    FIELD(POR_MPU_M1_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR1_U_RND_NID68, 0x835420)
    FIELD(POR_MPU_M1_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR1_U_RND_NID68, 0x835428)
    FIELD(POR_MPU_M1_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR2_U_RND_NID68, 0x835430)
    FIELD(POR_MPU_M1_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR2_U_RND_NID68, 0x835438)
    FIELD(POR_MPU_M1_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR3_U_RND_NID68, 0x835440)
    FIELD(POR_MPU_M1_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR3_U_RND_NID68, 0x835448)
    FIELD(POR_MPU_M1_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR4_U_RND_NID68, 0x835450)
    FIELD(POR_MPU_M1_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR4_U_RND_NID68, 0x835458)
    FIELD(POR_MPU_M1_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR5_U_RND_NID68, 0x835460)
    FIELD(POR_MPU_M1_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR5_U_RND_NID68, 0x835468)
    FIELD(POR_MPU_M1_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR6_U_RND_NID68, 0x835470)
    FIELD(POR_MPU_M1_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR6_U_RND_NID68, 0x835478)
    FIELD(POR_MPU_M1_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR7_U_RND_NID68, 0x835480)
    FIELD(POR_MPU_M1_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR7_U_RND_NID68, 0x835488)
    FIELD(POR_MPU_M1_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR8_U_RND_NID68, 0x835490)
    FIELD(POR_MPU_M1_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR8_U_RND_NID68, 0x835498)
    FIELD(POR_MPU_M1_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR9_U_RND_NID68, 0x8354a0)
    FIELD(POR_MPU_M1_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR9_U_RND_NID68, 0x8354a8)
    FIELD(POR_MPU_M1_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR10_U_RND_NID68, 0x8354b0)
    FIELD(POR_MPU_M1_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR10_U_RND_NID68, 0x8354b8)
    FIELD(POR_MPU_M1_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR11_U_RND_NID68, 0x8354c0)
    FIELD(POR_MPU_M1_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR11_U_RND_NID68, 0x8354c8)
    FIELD(POR_MPU_M1_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR12_U_RND_NID68, 0x8354d0)
    FIELD(POR_MPU_M1_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR12_U_RND_NID68, 0x8354d8)
    FIELD(POR_MPU_M1_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR13_U_RND_NID68, 0x8354e0)
    FIELD(POR_MPU_M1_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR13_U_RND_NID68, 0x8354e8)
    FIELD(POR_MPU_M1_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR14_U_RND_NID68, 0x8354f0)
    FIELD(POR_MPU_M1_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR14_U_RND_NID68, 0x8354f8)
    FIELD(POR_MPU_M1_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR15_U_RND_NID68, 0x835500)
    FIELD(POR_MPU_M1_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR15_U_RND_NID68, 0x835508)
    FIELD(POR_MPU_M1_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR16_U_RND_NID68, 0x835510)
    FIELD(POR_MPU_M1_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR16_U_RND_NID68, 0x835518)
    FIELD(POR_MPU_M1_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR17_U_RND_NID68, 0x835520)
    FIELD(POR_MPU_M1_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR17_U_RND_NID68, 0x835528)
    FIELD(POR_MPU_M1_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR18_U_RND_NID68, 0x835530)
    FIELD(POR_MPU_M1_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR18_U_RND_NID68, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR18_U_RND_NID68, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR18_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR18_U_RND_NID68, 0x835538)
    FIELD(POR_MPU_M1_PRLAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR18_U_RND_NID68, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR18_U_RND_NID68, REGION18_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR19_U_RND_NID68, 0x835540)
    FIELD(POR_MPU_M1_PRBAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR19_U_RND_NID68, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR19_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR19_U_RND_NID68, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR19_U_RND_NID68, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR19_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR19_U_RND_NID68, 0x835548)
    FIELD(POR_MPU_M1_PRLAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR19_U_RND_NID68, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR19_U_RND_NID68, REGION19_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR20_U_RND_NID68, 0x835550)
    FIELD(POR_MPU_M1_PRBAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR20_U_RND_NID68, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR20_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR20_U_RND_NID68, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR20_U_RND_NID68, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR20_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR20_U_RND_NID68, 0x835558)
    FIELD(POR_MPU_M1_PRLAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR20_U_RND_NID68, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR20_U_RND_NID68, REGION20_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR21_U_RND_NID68, 0x835560)
    FIELD(POR_MPU_M1_PRBAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR21_U_RND_NID68, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR21_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR21_U_RND_NID68, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR21_U_RND_NID68, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR21_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR21_U_RND_NID68, 0x835568)
    FIELD(POR_MPU_M1_PRLAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR21_U_RND_NID68, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR21_U_RND_NID68, REGION21_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR22_U_RND_NID68, 0x835570)
    FIELD(POR_MPU_M1_PRBAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR22_U_RND_NID68, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR22_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR22_U_RND_NID68, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR22_U_RND_NID68, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR22_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR22_U_RND_NID68, 0x835578)
    FIELD(POR_MPU_M1_PRLAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR22_U_RND_NID68, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR22_U_RND_NID68, REGION22_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR23_U_RND_NID68, 0x835580)
    FIELD(POR_MPU_M1_PRBAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR23_U_RND_NID68, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR23_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR23_U_RND_NID68, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR23_U_RND_NID68, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR23_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR23_U_RND_NID68, 0x835588)
    FIELD(POR_MPU_M1_PRLAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR23_U_RND_NID68, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR23_U_RND_NID68, REGION23_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR24_U_RND_NID68, 0x835590)
    FIELD(POR_MPU_M1_PRBAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR24_U_RND_NID68, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR24_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR24_U_RND_NID68, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR24_U_RND_NID68, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR24_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR24_U_RND_NID68, 0x835598)
    FIELD(POR_MPU_M1_PRLAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR24_U_RND_NID68, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR24_U_RND_NID68, REGION24_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR25_U_RND_NID68, 0x8355a0)
    FIELD(POR_MPU_M1_PRBAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR25_U_RND_NID68, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR25_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR25_U_RND_NID68, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR25_U_RND_NID68, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR25_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR25_U_RND_NID68, 0x8355a8)
    FIELD(POR_MPU_M1_PRLAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR25_U_RND_NID68, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR25_U_RND_NID68, REGION25_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR26_U_RND_NID68, 0x8355b0)
    FIELD(POR_MPU_M1_PRBAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR26_U_RND_NID68, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR26_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR26_U_RND_NID68, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR26_U_RND_NID68, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR26_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR26_U_RND_NID68, 0x8355b8)
    FIELD(POR_MPU_M1_PRLAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR26_U_RND_NID68, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR26_U_RND_NID68, REGION26_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR27_U_RND_NID68, 0x8355c0)
    FIELD(POR_MPU_M1_PRBAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR27_U_RND_NID68, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR27_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR27_U_RND_NID68, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR27_U_RND_NID68, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR27_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR27_U_RND_NID68, 0x8355c8)
    FIELD(POR_MPU_M1_PRLAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR27_U_RND_NID68, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR27_U_RND_NID68, REGION27_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR28_U_RND_NID68, 0x8355d0)
    FIELD(POR_MPU_M1_PRBAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR28_U_RND_NID68, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR28_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR28_U_RND_NID68, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR28_U_RND_NID68, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR28_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR28_U_RND_NID68, 0x8355d8)
    FIELD(POR_MPU_M1_PRLAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR28_U_RND_NID68, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR28_U_RND_NID68, REGION28_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR29_U_RND_NID68, 0x8355e0)
    FIELD(POR_MPU_M1_PRBAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR29_U_RND_NID68, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR29_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR29_U_RND_NID68, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR29_U_RND_NID68, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR29_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR29_U_RND_NID68, 0x8355e8)
    FIELD(POR_MPU_M1_PRLAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR29_U_RND_NID68, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR29_U_RND_NID68, REGION29_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR30_U_RND_NID68, 0x8355f0)
    FIELD(POR_MPU_M1_PRBAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR30_U_RND_NID68, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR30_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR30_U_RND_NID68, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR30_U_RND_NID68, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR30_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR30_U_RND_NID68, 0x8355f8)
    FIELD(POR_MPU_M1_PRLAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR30_U_RND_NID68, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR30_U_RND_NID68, REGION30_EN, 0, 1)
REG32(POR_MPU_M1_PRBAR31_U_RND_NID68, 0x835600)
    FIELD(POR_MPU_M1_PRBAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRBAR31_U_RND_NID68, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRBAR31_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M1_PRBAR31_U_RND_NID68, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M1_PRBAR31_U_RND_NID68, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M1_PRBAR31_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M1_PRLAR31_U_RND_NID68, 0x835608)
    FIELD(POR_MPU_M1_PRLAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M1_PRLAR31_U_RND_NID68, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M1_PRLAR31_U_RND_NID68, REGION31_EN, 0, 1)
REG32(POR_MPU_M2_CTL_U_RND_NID68, 0x835800)
    FIELD(POR_MPU_M2_CTL_U_RND_NID68, M2_EN, 2, 1)
    FIELD(POR_MPU_M2_CTL_U_RND_NID68, M2_ACTION, 0, 2)
REG32(POR_MPU_M2_PRBAR0_U_RND_NID68, 0x835810)
    FIELD(POR_MPU_M2_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR0_U_RND_NID68, 0x835818)
    FIELD(POR_MPU_M2_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR1_U_RND_NID68, 0x835820)
    FIELD(POR_MPU_M2_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR1_U_RND_NID68, 0x835828)
    FIELD(POR_MPU_M2_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR2_U_RND_NID68, 0x835830)
    FIELD(POR_MPU_M2_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR2_U_RND_NID68, 0x835838)
    FIELD(POR_MPU_M2_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR3_U_RND_NID68, 0x835840)
    FIELD(POR_MPU_M2_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR3_U_RND_NID68, 0x835848)
    FIELD(POR_MPU_M2_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR4_U_RND_NID68, 0x835850)
    FIELD(POR_MPU_M2_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR4_U_RND_NID68, 0x835858)
    FIELD(POR_MPU_M2_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR5_U_RND_NID68, 0x835860)
    FIELD(POR_MPU_M2_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR5_U_RND_NID68, 0x835868)
    FIELD(POR_MPU_M2_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR6_U_RND_NID68, 0x835870)
    FIELD(POR_MPU_M2_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR6_U_RND_NID68, 0x835878)
    FIELD(POR_MPU_M2_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR7_U_RND_NID68, 0x835880)
    FIELD(POR_MPU_M2_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR7_U_RND_NID68, 0x835888)
    FIELD(POR_MPU_M2_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR8_U_RND_NID68, 0x835890)
    FIELD(POR_MPU_M2_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR8_U_RND_NID68, 0x835898)
    FIELD(POR_MPU_M2_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR9_U_RND_NID68, 0x8358a0)
    FIELD(POR_MPU_M2_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR9_U_RND_NID68, 0x8358a8)
    FIELD(POR_MPU_M2_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR10_U_RND_NID68, 0x8358b0)
    FIELD(POR_MPU_M2_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR10_U_RND_NID68, 0x8358b8)
    FIELD(POR_MPU_M2_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR11_U_RND_NID68, 0x8358c0)
    FIELD(POR_MPU_M2_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR11_U_RND_NID68, 0x8358c8)
    FIELD(POR_MPU_M2_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR12_U_RND_NID68, 0x8358d0)
    FIELD(POR_MPU_M2_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR12_U_RND_NID68, 0x8358d8)
    FIELD(POR_MPU_M2_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR13_U_RND_NID68, 0x8358e0)
    FIELD(POR_MPU_M2_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR13_U_RND_NID68, 0x8358e8)
    FIELD(POR_MPU_M2_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR14_U_RND_NID68, 0x8358f0)
    FIELD(POR_MPU_M2_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR14_U_RND_NID68, 0x8358f8)
    FIELD(POR_MPU_M2_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR15_U_RND_NID68, 0x835900)
    FIELD(POR_MPU_M2_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR15_U_RND_NID68, 0x835908)
    FIELD(POR_MPU_M2_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR16_U_RND_NID68, 0x835910)
    FIELD(POR_MPU_M2_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR16_U_RND_NID68, 0x835918)
    FIELD(POR_MPU_M2_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR17_U_RND_NID68, 0x835920)
    FIELD(POR_MPU_M2_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR17_U_RND_NID68, 0x835928)
    FIELD(POR_MPU_M2_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR18_U_RND_NID68, 0x835930)
    FIELD(POR_MPU_M2_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR18_U_RND_NID68, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR18_U_RND_NID68, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR18_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR18_U_RND_NID68, 0x835938)
    FIELD(POR_MPU_M2_PRLAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR18_U_RND_NID68, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR18_U_RND_NID68, REGION18_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR19_U_RND_NID68, 0x835940)
    FIELD(POR_MPU_M2_PRBAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR19_U_RND_NID68, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR19_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR19_U_RND_NID68, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR19_U_RND_NID68, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR19_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR19_U_RND_NID68, 0x835948)
    FIELD(POR_MPU_M2_PRLAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR19_U_RND_NID68, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR19_U_RND_NID68, REGION19_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR20_U_RND_NID68, 0x835950)
    FIELD(POR_MPU_M2_PRBAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR20_U_RND_NID68, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR20_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR20_U_RND_NID68, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR20_U_RND_NID68, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR20_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR20_U_RND_NID68, 0x835958)
    FIELD(POR_MPU_M2_PRLAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR20_U_RND_NID68, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR20_U_RND_NID68, REGION20_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR21_U_RND_NID68, 0x835960)
    FIELD(POR_MPU_M2_PRBAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR21_U_RND_NID68, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR21_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR21_U_RND_NID68, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR21_U_RND_NID68, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR21_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR21_U_RND_NID68, 0x835968)
    FIELD(POR_MPU_M2_PRLAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR21_U_RND_NID68, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR21_U_RND_NID68, REGION21_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR22_U_RND_NID68, 0x835970)
    FIELD(POR_MPU_M2_PRBAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR22_U_RND_NID68, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR22_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR22_U_RND_NID68, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR22_U_RND_NID68, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR22_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR22_U_RND_NID68, 0x835978)
    FIELD(POR_MPU_M2_PRLAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR22_U_RND_NID68, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR22_U_RND_NID68, REGION22_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR23_U_RND_NID68, 0x835980)
    FIELD(POR_MPU_M2_PRBAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR23_U_RND_NID68, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR23_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR23_U_RND_NID68, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR23_U_RND_NID68, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR23_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR23_U_RND_NID68, 0x835988)
    FIELD(POR_MPU_M2_PRLAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR23_U_RND_NID68, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR23_U_RND_NID68, REGION23_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR24_U_RND_NID68, 0x835990)
    FIELD(POR_MPU_M2_PRBAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR24_U_RND_NID68, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR24_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR24_U_RND_NID68, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR24_U_RND_NID68, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR24_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR24_U_RND_NID68, 0x835998)
    FIELD(POR_MPU_M2_PRLAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR24_U_RND_NID68, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR24_U_RND_NID68, REGION24_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR25_U_RND_NID68, 0x8359a0)
    FIELD(POR_MPU_M2_PRBAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR25_U_RND_NID68, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR25_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR25_U_RND_NID68, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR25_U_RND_NID68, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR25_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR25_U_RND_NID68, 0x8359a8)
    FIELD(POR_MPU_M2_PRLAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR25_U_RND_NID68, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR25_U_RND_NID68, REGION25_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR26_U_RND_NID68, 0x8359b0)
    FIELD(POR_MPU_M2_PRBAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR26_U_RND_NID68, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR26_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR26_U_RND_NID68, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR26_U_RND_NID68, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR26_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR26_U_RND_NID68, 0x8359b8)
    FIELD(POR_MPU_M2_PRLAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR26_U_RND_NID68, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR26_U_RND_NID68, REGION26_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR27_U_RND_NID68, 0x8359c0)
    FIELD(POR_MPU_M2_PRBAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR27_U_RND_NID68, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR27_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR27_U_RND_NID68, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR27_U_RND_NID68, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR27_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR27_U_RND_NID68, 0x8359c8)
    FIELD(POR_MPU_M2_PRLAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR27_U_RND_NID68, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR27_U_RND_NID68, REGION27_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR28_U_RND_NID68, 0x8359d0)
    FIELD(POR_MPU_M2_PRBAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR28_U_RND_NID68, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR28_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR28_U_RND_NID68, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR28_U_RND_NID68, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR28_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR28_U_RND_NID68, 0x8359d8)
    FIELD(POR_MPU_M2_PRLAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR28_U_RND_NID68, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR28_U_RND_NID68, REGION28_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR29_U_RND_NID68, 0x8359e0)
    FIELD(POR_MPU_M2_PRBAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR29_U_RND_NID68, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR29_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR29_U_RND_NID68, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR29_U_RND_NID68, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR29_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR29_U_RND_NID68, 0x8359e8)
    FIELD(POR_MPU_M2_PRLAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR29_U_RND_NID68, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR29_U_RND_NID68, REGION29_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR30_U_RND_NID68, 0x8359f0)
    FIELD(POR_MPU_M2_PRBAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR30_U_RND_NID68, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR30_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR30_U_RND_NID68, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR30_U_RND_NID68, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR30_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR30_U_RND_NID68, 0x8359f8)
    FIELD(POR_MPU_M2_PRLAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR30_U_RND_NID68, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR30_U_RND_NID68, REGION30_EN, 0, 1)
REG32(POR_MPU_M2_PRBAR31_U_RND_NID68, 0x835a00)
    FIELD(POR_MPU_M2_PRBAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRBAR31_U_RND_NID68, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRBAR31_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M2_PRBAR31_U_RND_NID68, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M2_PRBAR31_U_RND_NID68, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M2_PRBAR31_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M2_PRLAR31_U_RND_NID68, 0x835a08)
    FIELD(POR_MPU_M2_PRLAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M2_PRLAR31_U_RND_NID68, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M2_PRLAR31_U_RND_NID68, REGION31_EN, 0, 1)
REG32(POR_MPU_M3_CTL_U_RND_NID68, 0x835c00)
    FIELD(POR_MPU_M3_CTL_U_RND_NID68, M3_EN, 2, 1)
    FIELD(POR_MPU_M3_CTL_U_RND_NID68, M3_ACTION, 0, 2)
REG32(POR_MPU_M3_PRBAR0_U_RND_NID68, 0x835c10)
    FIELD(POR_MPU_M3_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR0_U_RND_NID68, 0x835c18)
    FIELD(POR_MPU_M3_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR1_U_RND_NID68, 0x835c20)
    FIELD(POR_MPU_M3_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR1_U_RND_NID68, 0x835c28)
    FIELD(POR_MPU_M3_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR2_U_RND_NID68, 0x835c30)
    FIELD(POR_MPU_M3_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR2_U_RND_NID68, 0x835c38)
    FIELD(POR_MPU_M3_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR3_U_RND_NID68, 0x835c40)
    FIELD(POR_MPU_M3_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR3_U_RND_NID68, 0x835c48)
    FIELD(POR_MPU_M3_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR4_U_RND_NID68, 0x835c50)
    FIELD(POR_MPU_M3_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR4_U_RND_NID68, 0x835c58)
    FIELD(POR_MPU_M3_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR5_U_RND_NID68, 0x835c60)
    FIELD(POR_MPU_M3_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR5_U_RND_NID68, 0x835c68)
    FIELD(POR_MPU_M3_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR6_U_RND_NID68, 0x835c70)
    FIELD(POR_MPU_M3_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR6_U_RND_NID68, 0x835c78)
    FIELD(POR_MPU_M3_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR7_U_RND_NID68, 0x835c80)
    FIELD(POR_MPU_M3_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR7_U_RND_NID68, 0x835c88)
    FIELD(POR_MPU_M3_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR8_U_RND_NID68, 0x835c90)
    FIELD(POR_MPU_M3_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR8_U_RND_NID68, 0x835c98)
    FIELD(POR_MPU_M3_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR9_U_RND_NID68, 0x835ca0)
    FIELD(POR_MPU_M3_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR9_U_RND_NID68, 0x835ca8)
    FIELD(POR_MPU_M3_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR10_U_RND_NID68, 0x835cb0)
    FIELD(POR_MPU_M3_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR10_U_RND_NID68, 0x835cb8)
    FIELD(POR_MPU_M3_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR11_U_RND_NID68, 0x835cc0)
    FIELD(POR_MPU_M3_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR11_U_RND_NID68, 0x835cc8)
    FIELD(POR_MPU_M3_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR12_U_RND_NID68, 0x835cd0)
    FIELD(POR_MPU_M3_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR12_U_RND_NID68, 0x835cd8)
    FIELD(POR_MPU_M3_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR13_U_RND_NID68, 0x835ce0)
    FIELD(POR_MPU_M3_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR13_U_RND_NID68, 0x835ce8)
    FIELD(POR_MPU_M3_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR14_U_RND_NID68, 0x835cf0)
    FIELD(POR_MPU_M3_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR14_U_RND_NID68, 0x835cf8)
    FIELD(POR_MPU_M3_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR15_U_RND_NID68, 0x835d00)
    FIELD(POR_MPU_M3_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR15_U_RND_NID68, 0x835d08)
    FIELD(POR_MPU_M3_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR16_U_RND_NID68, 0x835d10)
    FIELD(POR_MPU_M3_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR16_U_RND_NID68, 0x835d18)
    FIELD(POR_MPU_M3_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR17_U_RND_NID68, 0x835d20)
    FIELD(POR_MPU_M3_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR17_U_RND_NID68, 0x835d28)
    FIELD(POR_MPU_M3_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR18_U_RND_NID68, 0x835d30)
    FIELD(POR_MPU_M3_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR18_U_RND_NID68, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR18_U_RND_NID68, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR18_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR18_U_RND_NID68, 0x835d38)
    FIELD(POR_MPU_M3_PRLAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR18_U_RND_NID68, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR18_U_RND_NID68, REGION18_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR19_U_RND_NID68, 0x835d40)
    FIELD(POR_MPU_M3_PRBAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR19_U_RND_NID68, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR19_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR19_U_RND_NID68, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR19_U_RND_NID68, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR19_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR19_U_RND_NID68, 0x835d48)
    FIELD(POR_MPU_M3_PRLAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR19_U_RND_NID68, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR19_U_RND_NID68, REGION19_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR20_U_RND_NID68, 0x835d50)
    FIELD(POR_MPU_M3_PRBAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR20_U_RND_NID68, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR20_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR20_U_RND_NID68, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR20_U_RND_NID68, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR20_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR20_U_RND_NID68, 0x835d58)
    FIELD(POR_MPU_M3_PRLAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR20_U_RND_NID68, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR20_U_RND_NID68, REGION20_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR21_U_RND_NID68, 0x835d60)
    FIELD(POR_MPU_M3_PRBAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR21_U_RND_NID68, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR21_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR21_U_RND_NID68, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR21_U_RND_NID68, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR21_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR21_U_RND_NID68, 0x835d68)
    FIELD(POR_MPU_M3_PRLAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR21_U_RND_NID68, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR21_U_RND_NID68, REGION21_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR22_U_RND_NID68, 0x835d70)
    FIELD(POR_MPU_M3_PRBAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR22_U_RND_NID68, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR22_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR22_U_RND_NID68, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR22_U_RND_NID68, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR22_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR22_U_RND_NID68, 0x835d78)
    FIELD(POR_MPU_M3_PRLAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR22_U_RND_NID68, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR22_U_RND_NID68, REGION22_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR23_U_RND_NID68, 0x835d80)
    FIELD(POR_MPU_M3_PRBAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR23_U_RND_NID68, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR23_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR23_U_RND_NID68, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR23_U_RND_NID68, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR23_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR23_U_RND_NID68, 0x835d88)
    FIELD(POR_MPU_M3_PRLAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR23_U_RND_NID68, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR23_U_RND_NID68, REGION23_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR24_U_RND_NID68, 0x835d90)
    FIELD(POR_MPU_M3_PRBAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR24_U_RND_NID68, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR24_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR24_U_RND_NID68, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR24_U_RND_NID68, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR24_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR24_U_RND_NID68, 0x835d98)
    FIELD(POR_MPU_M3_PRLAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR24_U_RND_NID68, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR24_U_RND_NID68, REGION24_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR25_U_RND_NID68, 0x835da0)
    FIELD(POR_MPU_M3_PRBAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR25_U_RND_NID68, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR25_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR25_U_RND_NID68, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR25_U_RND_NID68, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR25_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR25_U_RND_NID68, 0x835da8)
    FIELD(POR_MPU_M3_PRLAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR25_U_RND_NID68, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR25_U_RND_NID68, REGION25_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR26_U_RND_NID68, 0x835db0)
    FIELD(POR_MPU_M3_PRBAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR26_U_RND_NID68, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR26_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR26_U_RND_NID68, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR26_U_RND_NID68, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR26_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR26_U_RND_NID68, 0x835db8)
    FIELD(POR_MPU_M3_PRLAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR26_U_RND_NID68, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR26_U_RND_NID68, REGION26_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR27_U_RND_NID68, 0x835dc0)
    FIELD(POR_MPU_M3_PRBAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR27_U_RND_NID68, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR27_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR27_U_RND_NID68, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR27_U_RND_NID68, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR27_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR27_U_RND_NID68, 0x835dc8)
    FIELD(POR_MPU_M3_PRLAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR27_U_RND_NID68, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR27_U_RND_NID68, REGION27_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR28_U_RND_NID68, 0x835dd0)
    FIELD(POR_MPU_M3_PRBAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR28_U_RND_NID68, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR28_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR28_U_RND_NID68, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR28_U_RND_NID68, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR28_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR28_U_RND_NID68, 0x835dd8)
    FIELD(POR_MPU_M3_PRLAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR28_U_RND_NID68, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR28_U_RND_NID68, REGION28_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR29_U_RND_NID68, 0x835de0)
    FIELD(POR_MPU_M3_PRBAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR29_U_RND_NID68, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR29_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR29_U_RND_NID68, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR29_U_RND_NID68, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR29_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR29_U_RND_NID68, 0x835de8)
    FIELD(POR_MPU_M3_PRLAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR29_U_RND_NID68, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR29_U_RND_NID68, REGION29_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR30_U_RND_NID68, 0x835df0)
    FIELD(POR_MPU_M3_PRBAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR30_U_RND_NID68, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR30_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR30_U_RND_NID68, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR30_U_RND_NID68, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR30_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR30_U_RND_NID68, 0x835df8)
    FIELD(POR_MPU_M3_PRLAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR30_U_RND_NID68, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR30_U_RND_NID68, REGION30_EN, 0, 1)
REG32(POR_MPU_M3_PRBAR31_U_RND_NID68, 0x835e00)
    FIELD(POR_MPU_M3_PRBAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRBAR31_U_RND_NID68, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRBAR31_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M3_PRBAR31_U_RND_NID68, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M3_PRBAR31_U_RND_NID68, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M3_PRBAR31_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M3_PRLAR31_U_RND_NID68, 0x835e08)
    FIELD(POR_MPU_M3_PRLAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M3_PRLAR31_U_RND_NID68, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M3_PRLAR31_U_RND_NID68, REGION31_EN, 0, 1)
REG32(POR_MPU_M4_CTL_U_RND_NID68, 0x836000)
    FIELD(POR_MPU_M4_CTL_U_RND_NID68, M4_EN, 2, 1)
    FIELD(POR_MPU_M4_CTL_U_RND_NID68, M4_ACTION, 0, 2)
REG32(POR_MPU_M4_PRBAR0_U_RND_NID68, 0x836010)
    FIELD(POR_MPU_M4_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR0_U_RND_NID68, 0x836018)
    FIELD(POR_MPU_M4_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR1_U_RND_NID68, 0x836020)
    FIELD(POR_MPU_M4_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR1_U_RND_NID68, 0x836028)
    FIELD(POR_MPU_M4_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR2_U_RND_NID68, 0x836030)
    FIELD(POR_MPU_M4_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR2_U_RND_NID68, 0x836038)
    FIELD(POR_MPU_M4_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR3_U_RND_NID68, 0x836040)
    FIELD(POR_MPU_M4_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR3_U_RND_NID68, 0x836048)
    FIELD(POR_MPU_M4_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR4_U_RND_NID68, 0x836050)
    FIELD(POR_MPU_M4_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR4_U_RND_NID68, 0x836058)
    FIELD(POR_MPU_M4_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR5_U_RND_NID68, 0x836060)
    FIELD(POR_MPU_M4_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR5_U_RND_NID68, 0x836068)
    FIELD(POR_MPU_M4_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR6_U_RND_NID68, 0x836070)
    FIELD(POR_MPU_M4_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR6_U_RND_NID68, 0x836078)
    FIELD(POR_MPU_M4_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR7_U_RND_NID68, 0x836080)
    FIELD(POR_MPU_M4_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR7_U_RND_NID68, 0x836088)
    FIELD(POR_MPU_M4_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR8_U_RND_NID68, 0x836090)
    FIELD(POR_MPU_M4_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR8_U_RND_NID68, 0x836098)
    FIELD(POR_MPU_M4_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR9_U_RND_NID68, 0x8360a0)
    FIELD(POR_MPU_M4_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR9_U_RND_NID68, 0x8360a8)
    FIELD(POR_MPU_M4_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR10_U_RND_NID68, 0x8360b0)
    FIELD(POR_MPU_M4_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR10_U_RND_NID68, 0x8360b8)
    FIELD(POR_MPU_M4_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR11_U_RND_NID68, 0x8360c0)
    FIELD(POR_MPU_M4_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR11_U_RND_NID68, 0x8360c8)
    FIELD(POR_MPU_M4_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR12_U_RND_NID68, 0x8360d0)
    FIELD(POR_MPU_M4_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR12_U_RND_NID68, 0x8360d8)
    FIELD(POR_MPU_M4_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR13_U_RND_NID68, 0x8360e0)
    FIELD(POR_MPU_M4_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR13_U_RND_NID68, 0x8360e8)
    FIELD(POR_MPU_M4_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR14_U_RND_NID68, 0x8360f0)
    FIELD(POR_MPU_M4_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR14_U_RND_NID68, 0x8360f8)
    FIELD(POR_MPU_M4_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR15_U_RND_NID68, 0x836100)
    FIELD(POR_MPU_M4_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR15_U_RND_NID68, 0x836108)
    FIELD(POR_MPU_M4_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR16_U_RND_NID68, 0x836110)
    FIELD(POR_MPU_M4_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR16_U_RND_NID68, 0x836118)
    FIELD(POR_MPU_M4_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR17_U_RND_NID68, 0x836120)
    FIELD(POR_MPU_M4_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR17_U_RND_NID68, 0x836128)
    FIELD(POR_MPU_M4_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR18_U_RND_NID68, 0x836130)
    FIELD(POR_MPU_M4_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR18_U_RND_NID68, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR18_U_RND_NID68, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR18_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR18_U_RND_NID68, 0x836138)
    FIELD(POR_MPU_M4_PRLAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR18_U_RND_NID68, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR18_U_RND_NID68, REGION18_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR19_U_RND_NID68, 0x836140)
    FIELD(POR_MPU_M4_PRBAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR19_U_RND_NID68, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR19_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR19_U_RND_NID68, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR19_U_RND_NID68, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR19_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR19_U_RND_NID68, 0x836148)
    FIELD(POR_MPU_M4_PRLAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR19_U_RND_NID68, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR19_U_RND_NID68, REGION19_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR20_U_RND_NID68, 0x836150)
    FIELD(POR_MPU_M4_PRBAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR20_U_RND_NID68, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR20_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR20_U_RND_NID68, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR20_U_RND_NID68, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR20_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR20_U_RND_NID68, 0x836158)
    FIELD(POR_MPU_M4_PRLAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR20_U_RND_NID68, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR20_U_RND_NID68, REGION20_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR21_U_RND_NID68, 0x836160)
    FIELD(POR_MPU_M4_PRBAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR21_U_RND_NID68, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR21_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR21_U_RND_NID68, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR21_U_RND_NID68, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR21_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR21_U_RND_NID68, 0x836168)
    FIELD(POR_MPU_M4_PRLAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR21_U_RND_NID68, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR21_U_RND_NID68, REGION21_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR22_U_RND_NID68, 0x836170)
    FIELD(POR_MPU_M4_PRBAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR22_U_RND_NID68, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR22_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR22_U_RND_NID68, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR22_U_RND_NID68, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR22_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR22_U_RND_NID68, 0x836178)
    FIELD(POR_MPU_M4_PRLAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR22_U_RND_NID68, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR22_U_RND_NID68, REGION22_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR23_U_RND_NID68, 0x836180)
    FIELD(POR_MPU_M4_PRBAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR23_U_RND_NID68, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR23_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR23_U_RND_NID68, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR23_U_RND_NID68, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR23_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR23_U_RND_NID68, 0x836188)
    FIELD(POR_MPU_M4_PRLAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR23_U_RND_NID68, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR23_U_RND_NID68, REGION23_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR24_U_RND_NID68, 0x836190)
    FIELD(POR_MPU_M4_PRBAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR24_U_RND_NID68, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR24_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR24_U_RND_NID68, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR24_U_RND_NID68, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR24_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR24_U_RND_NID68, 0x836198)
    FIELD(POR_MPU_M4_PRLAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR24_U_RND_NID68, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR24_U_RND_NID68, REGION24_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR25_U_RND_NID68, 0x8361a0)
    FIELD(POR_MPU_M4_PRBAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR25_U_RND_NID68, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR25_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR25_U_RND_NID68, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR25_U_RND_NID68, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR25_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR25_U_RND_NID68, 0x8361a8)
    FIELD(POR_MPU_M4_PRLAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR25_U_RND_NID68, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR25_U_RND_NID68, REGION25_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR26_U_RND_NID68, 0x8361b0)
    FIELD(POR_MPU_M4_PRBAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR26_U_RND_NID68, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR26_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR26_U_RND_NID68, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR26_U_RND_NID68, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR26_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR26_U_RND_NID68, 0x8361b8)
    FIELD(POR_MPU_M4_PRLAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR26_U_RND_NID68, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR26_U_RND_NID68, REGION26_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR27_U_RND_NID68, 0x8361c0)
    FIELD(POR_MPU_M4_PRBAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR27_U_RND_NID68, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR27_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR27_U_RND_NID68, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR27_U_RND_NID68, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR27_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR27_U_RND_NID68, 0x8361c8)
    FIELD(POR_MPU_M4_PRLAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR27_U_RND_NID68, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR27_U_RND_NID68, REGION27_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR28_U_RND_NID68, 0x8361d0)
    FIELD(POR_MPU_M4_PRBAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR28_U_RND_NID68, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR28_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR28_U_RND_NID68, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR28_U_RND_NID68, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR28_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR28_U_RND_NID68, 0x8361d8)
    FIELD(POR_MPU_M4_PRLAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR28_U_RND_NID68, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR28_U_RND_NID68, REGION28_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR29_U_RND_NID68, 0x8361e0)
    FIELD(POR_MPU_M4_PRBAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR29_U_RND_NID68, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR29_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR29_U_RND_NID68, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR29_U_RND_NID68, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR29_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR29_U_RND_NID68, 0x8361e8)
    FIELD(POR_MPU_M4_PRLAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR29_U_RND_NID68, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR29_U_RND_NID68, REGION29_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR30_U_RND_NID68, 0x8361f0)
    FIELD(POR_MPU_M4_PRBAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR30_U_RND_NID68, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR30_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR30_U_RND_NID68, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR30_U_RND_NID68, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR30_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR30_U_RND_NID68, 0x8361f8)
    FIELD(POR_MPU_M4_PRLAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR30_U_RND_NID68, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR30_U_RND_NID68, REGION30_EN, 0, 1)
REG32(POR_MPU_M4_PRBAR31_U_RND_NID68, 0x836200)
    FIELD(POR_MPU_M4_PRBAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRBAR31_U_RND_NID68, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRBAR31_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M4_PRBAR31_U_RND_NID68, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M4_PRBAR31_U_RND_NID68, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M4_PRBAR31_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M4_PRLAR31_U_RND_NID68, 0x836208)
    FIELD(POR_MPU_M4_PRLAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M4_PRLAR31_U_RND_NID68, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M4_PRLAR31_U_RND_NID68, REGION31_EN, 0, 1)
REG32(POR_MPU_M5_CTL_U_RND_NID68, 0x836400)
    FIELD(POR_MPU_M5_CTL_U_RND_NID68, M5_EN, 2, 1)
    FIELD(POR_MPU_M5_CTL_U_RND_NID68, M5_ACTION, 0, 2)
REG32(POR_MPU_M5_PRBAR0_U_RND_NID68, 0x836410)
    FIELD(POR_MPU_M5_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR0_U_RND_NID68, 0x836418)
    FIELD(POR_MPU_M5_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR1_U_RND_NID68, 0x836420)
    FIELD(POR_MPU_M5_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR1_U_RND_NID68, 0x836428)
    FIELD(POR_MPU_M5_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR2_U_RND_NID68, 0x836430)
    FIELD(POR_MPU_M5_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR2_U_RND_NID68, 0x836438)
    FIELD(POR_MPU_M5_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR3_U_RND_NID68, 0x836440)
    FIELD(POR_MPU_M5_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR3_U_RND_NID68, 0x836448)
    FIELD(POR_MPU_M5_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR4_U_RND_NID68, 0x836450)
    FIELD(POR_MPU_M5_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR4_U_RND_NID68, 0x836458)
    FIELD(POR_MPU_M5_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR5_U_RND_NID68, 0x836460)
    FIELD(POR_MPU_M5_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR5_U_RND_NID68, 0x836468)
    FIELD(POR_MPU_M5_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR6_U_RND_NID68, 0x836470)
    FIELD(POR_MPU_M5_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR6_U_RND_NID68, 0x836478)
    FIELD(POR_MPU_M5_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR7_U_RND_NID68, 0x836480)
    FIELD(POR_MPU_M5_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR7_U_RND_NID68, 0x836488)
    FIELD(POR_MPU_M5_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR8_U_RND_NID68, 0x836490)
    FIELD(POR_MPU_M5_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR8_U_RND_NID68, 0x836498)
    FIELD(POR_MPU_M5_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR9_U_RND_NID68, 0x8364a0)
    FIELD(POR_MPU_M5_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR9_U_RND_NID68, 0x8364a8)
    FIELD(POR_MPU_M5_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR10_U_RND_NID68, 0x8364b0)
    FIELD(POR_MPU_M5_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR10_U_RND_NID68, 0x8364b8)
    FIELD(POR_MPU_M5_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR11_U_RND_NID68, 0x8364c0)
    FIELD(POR_MPU_M5_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR11_U_RND_NID68, 0x8364c8)
    FIELD(POR_MPU_M5_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR12_U_RND_NID68, 0x8364d0)
    FIELD(POR_MPU_M5_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR12_U_RND_NID68, 0x8364d8)
    FIELD(POR_MPU_M5_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR13_U_RND_NID68, 0x8364e0)
    FIELD(POR_MPU_M5_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR13_U_RND_NID68, 0x8364e8)
    FIELD(POR_MPU_M5_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR14_U_RND_NID68, 0x8364f0)
    FIELD(POR_MPU_M5_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR14_U_RND_NID68, 0x8364f8)
    FIELD(POR_MPU_M5_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR15_U_RND_NID68, 0x836500)
    FIELD(POR_MPU_M5_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR15_U_RND_NID68, 0x836508)
    FIELD(POR_MPU_M5_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR16_U_RND_NID68, 0x836510)
    FIELD(POR_MPU_M5_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR16_U_RND_NID68, 0x836518)
    FIELD(POR_MPU_M5_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR17_U_RND_NID68, 0x836520)
    FIELD(POR_MPU_M5_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR17_U_RND_NID68, 0x836528)
    FIELD(POR_MPU_M5_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR18_U_RND_NID68, 0x836530)
    FIELD(POR_MPU_M5_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR18_U_RND_NID68, REGION18_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR18_U_RND_NID68, REGION18_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR18_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR18_U_RND_NID68, 0x836538)
    FIELD(POR_MPU_M5_PRLAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR18_U_RND_NID68, REGION18_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR18_U_RND_NID68, REGION18_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR19_U_RND_NID68, 0x836540)
    FIELD(POR_MPU_M5_PRBAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR19_U_RND_NID68, REGION19_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR19_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR19_U_RND_NID68, REGION19_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR19_U_RND_NID68, REGION19_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR19_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR19_U_RND_NID68, 0x836548)
    FIELD(POR_MPU_M5_PRLAR19_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR19_U_RND_NID68, REGION19_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR19_U_RND_NID68, REGION19_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR20_U_RND_NID68, 0x836550)
    FIELD(POR_MPU_M5_PRBAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR20_U_RND_NID68, REGION20_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR20_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR20_U_RND_NID68, REGION20_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR20_U_RND_NID68, REGION20_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR20_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR20_U_RND_NID68, 0x836558)
    FIELD(POR_MPU_M5_PRLAR20_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR20_U_RND_NID68, REGION20_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR20_U_RND_NID68, REGION20_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR21_U_RND_NID68, 0x836560)
    FIELD(POR_MPU_M5_PRBAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR21_U_RND_NID68, REGION21_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR21_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR21_U_RND_NID68, REGION21_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR21_U_RND_NID68, REGION21_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR21_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR21_U_RND_NID68, 0x836568)
    FIELD(POR_MPU_M5_PRLAR21_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR21_U_RND_NID68, REGION21_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR21_U_RND_NID68, REGION21_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR22_U_RND_NID68, 0x836570)
    FIELD(POR_MPU_M5_PRBAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR22_U_RND_NID68, REGION22_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR22_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR22_U_RND_NID68, REGION22_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR22_U_RND_NID68, REGION22_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR22_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR22_U_RND_NID68, 0x836578)
    FIELD(POR_MPU_M5_PRLAR22_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR22_U_RND_NID68, REGION22_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR22_U_RND_NID68, REGION22_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR23_U_RND_NID68, 0x836580)
    FIELD(POR_MPU_M5_PRBAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR23_U_RND_NID68, REGION23_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR23_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR23_U_RND_NID68, REGION23_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR23_U_RND_NID68, REGION23_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR23_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR23_U_RND_NID68, 0x836588)
    FIELD(POR_MPU_M5_PRLAR23_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR23_U_RND_NID68, REGION23_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR23_U_RND_NID68, REGION23_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR24_U_RND_NID68, 0x836590)
    FIELD(POR_MPU_M5_PRBAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR24_U_RND_NID68, REGION24_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR24_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR24_U_RND_NID68, REGION24_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR24_U_RND_NID68, REGION24_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR24_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR24_U_RND_NID68, 0x836598)
    FIELD(POR_MPU_M5_PRLAR24_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR24_U_RND_NID68, REGION24_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR24_U_RND_NID68, REGION24_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR25_U_RND_NID68, 0x8365a0)
    FIELD(POR_MPU_M5_PRBAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR25_U_RND_NID68, REGION25_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR25_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR25_U_RND_NID68, REGION25_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR25_U_RND_NID68, REGION25_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR25_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR25_U_RND_NID68, 0x8365a8)
    FIELD(POR_MPU_M5_PRLAR25_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR25_U_RND_NID68, REGION25_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR25_U_RND_NID68, REGION25_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR26_U_RND_NID68, 0x8365b0)
    FIELD(POR_MPU_M5_PRBAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR26_U_RND_NID68, REGION26_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR26_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR26_U_RND_NID68, REGION26_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR26_U_RND_NID68, REGION26_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR26_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR26_U_RND_NID68, 0x8365b8)
    FIELD(POR_MPU_M5_PRLAR26_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR26_U_RND_NID68, REGION26_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR26_U_RND_NID68, REGION26_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR27_U_RND_NID68, 0x8365c0)
    FIELD(POR_MPU_M5_PRBAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR27_U_RND_NID68, REGION27_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR27_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR27_U_RND_NID68, REGION27_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR27_U_RND_NID68, REGION27_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR27_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR27_U_RND_NID68, 0x8365c8)
    FIELD(POR_MPU_M5_PRLAR27_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR27_U_RND_NID68, REGION27_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR27_U_RND_NID68, REGION27_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR28_U_RND_NID68, 0x8365d0)
    FIELD(POR_MPU_M5_PRBAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR28_U_RND_NID68, REGION28_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR28_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR28_U_RND_NID68, REGION28_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR28_U_RND_NID68, REGION28_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR28_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR28_U_RND_NID68, 0x8365d8)
    FIELD(POR_MPU_M5_PRLAR28_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR28_U_RND_NID68, REGION28_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR28_U_RND_NID68, REGION28_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR29_U_RND_NID68, 0x8365e0)
    FIELD(POR_MPU_M5_PRBAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR29_U_RND_NID68, REGION29_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR29_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR29_U_RND_NID68, REGION29_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR29_U_RND_NID68, REGION29_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR29_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR29_U_RND_NID68, 0x8365e8)
    FIELD(POR_MPU_M5_PRLAR29_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR29_U_RND_NID68, REGION29_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR29_U_RND_NID68, REGION29_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR30_U_RND_NID68, 0x8365f0)
    FIELD(POR_MPU_M5_PRBAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR30_U_RND_NID68, REGION30_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR30_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR30_U_RND_NID68, REGION30_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR30_U_RND_NID68, REGION30_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR30_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR30_U_RND_NID68, 0x8365f8)
    FIELD(POR_MPU_M5_PRLAR30_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR30_U_RND_NID68, REGION30_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR30_U_RND_NID68, REGION30_EN, 0, 1)
REG32(POR_MPU_M5_PRBAR31_U_RND_NID68, 0x836600)
    FIELD(POR_MPU_M5_PRBAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRBAR31_U_RND_NID68, REGION31_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRBAR31_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M5_PRBAR31_U_RND_NID68, REGION31_BR, 9, 1)
    FIELD(POR_MPU_M5_PRBAR31_U_RND_NID68, REGION31_AP, 2, 4)
    FIELD(POR_MPU_M5_PRBAR31_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M5_PRLAR31_U_RND_NID68, 0x836608)
    FIELD(POR_MPU_M5_PRLAR31_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M5_PRLAR31_U_RND_NID68, REGION31_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M5_PRLAR31_U_RND_NID68, REGION31_EN, 0, 1)
REG32(POR_MPU_M6_CTL_U_RND_NID68, 0x836800)
    FIELD(POR_MPU_M6_CTL_U_RND_NID68, M6_EN, 2, 1)
    FIELD(POR_MPU_M6_CTL_U_RND_NID68, M6_ACTION, 0, 2)
REG32(POR_MPU_M6_PRBAR0_U_RND_NID68, 0x836810)
    FIELD(POR_MPU_M6_PRBAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR0_U_RND_NID68, REGION0_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR0_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR0_U_RND_NID68, REGION0_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR0_U_RND_NID68, REGION0_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR0_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR0_U_RND_NID68, 0x836818)
    FIELD(POR_MPU_M6_PRLAR0_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR0_U_RND_NID68, REGION0_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR0_U_RND_NID68, REGION0_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR1_U_RND_NID68, 0x836820)
    FIELD(POR_MPU_M6_PRBAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR1_U_RND_NID68, REGION1_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR1_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR1_U_RND_NID68, REGION1_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR1_U_RND_NID68, REGION1_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR1_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR1_U_RND_NID68, 0x836828)
    FIELD(POR_MPU_M6_PRLAR1_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR1_U_RND_NID68, REGION1_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR1_U_RND_NID68, REGION1_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR2_U_RND_NID68, 0x836830)
    FIELD(POR_MPU_M6_PRBAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR2_U_RND_NID68, REGION2_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR2_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR2_U_RND_NID68, REGION2_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR2_U_RND_NID68, REGION2_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR2_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR2_U_RND_NID68, 0x836838)
    FIELD(POR_MPU_M6_PRLAR2_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR2_U_RND_NID68, REGION2_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR2_U_RND_NID68, REGION2_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR3_U_RND_NID68, 0x836840)
    FIELD(POR_MPU_M6_PRBAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR3_U_RND_NID68, REGION3_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR3_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR3_U_RND_NID68, REGION3_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR3_U_RND_NID68, REGION3_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR3_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR3_U_RND_NID68, 0x836848)
    FIELD(POR_MPU_M6_PRLAR3_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR3_U_RND_NID68, REGION3_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR3_U_RND_NID68, REGION3_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR4_U_RND_NID68, 0x836850)
    FIELD(POR_MPU_M6_PRBAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR4_U_RND_NID68, REGION4_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR4_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR4_U_RND_NID68, REGION4_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR4_U_RND_NID68, REGION4_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR4_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR4_U_RND_NID68, 0x836858)
    FIELD(POR_MPU_M6_PRLAR4_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR4_U_RND_NID68, REGION4_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR4_U_RND_NID68, REGION4_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR5_U_RND_NID68, 0x836860)
    FIELD(POR_MPU_M6_PRBAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR5_U_RND_NID68, REGION5_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR5_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR5_U_RND_NID68, REGION5_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR5_U_RND_NID68, REGION5_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR5_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR5_U_RND_NID68, 0x836868)
    FIELD(POR_MPU_M6_PRLAR5_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR5_U_RND_NID68, REGION5_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR5_U_RND_NID68, REGION5_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR6_U_RND_NID68, 0x836870)
    FIELD(POR_MPU_M6_PRBAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR6_U_RND_NID68, REGION6_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR6_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR6_U_RND_NID68, REGION6_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR6_U_RND_NID68, REGION6_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR6_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR6_U_RND_NID68, 0x836878)
    FIELD(POR_MPU_M6_PRLAR6_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR6_U_RND_NID68, REGION6_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR6_U_RND_NID68, REGION6_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR7_U_RND_NID68, 0x836880)
    FIELD(POR_MPU_M6_PRBAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR7_U_RND_NID68, REGION7_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR7_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR7_U_RND_NID68, REGION7_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR7_U_RND_NID68, REGION7_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR7_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR7_U_RND_NID68, 0x836888)
    FIELD(POR_MPU_M6_PRLAR7_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR7_U_RND_NID68, REGION7_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR7_U_RND_NID68, REGION7_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR8_U_RND_NID68, 0x836890)
    FIELD(POR_MPU_M6_PRBAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR8_U_RND_NID68, REGION8_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR8_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR8_U_RND_NID68, REGION8_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR8_U_RND_NID68, REGION8_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR8_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR8_U_RND_NID68, 0x836898)
    FIELD(POR_MPU_M6_PRLAR8_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR8_U_RND_NID68, REGION8_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR8_U_RND_NID68, REGION8_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR9_U_RND_NID68, 0x8368a0)
    FIELD(POR_MPU_M6_PRBAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR9_U_RND_NID68, REGION9_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR9_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR9_U_RND_NID68, REGION9_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR9_U_RND_NID68, REGION9_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR9_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR9_U_RND_NID68, 0x8368a8)
    FIELD(POR_MPU_M6_PRLAR9_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR9_U_RND_NID68, REGION9_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR9_U_RND_NID68, REGION9_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR10_U_RND_NID68, 0x8368b0)
    FIELD(POR_MPU_M6_PRBAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR10_U_RND_NID68, REGION10_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR10_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR10_U_RND_NID68, REGION10_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR10_U_RND_NID68, REGION10_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR10_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR10_U_RND_NID68, 0x8368b8)
    FIELD(POR_MPU_M6_PRLAR10_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR10_U_RND_NID68, REGION10_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR10_U_RND_NID68, REGION10_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR11_U_RND_NID68, 0x8368c0)
    FIELD(POR_MPU_M6_PRBAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR11_U_RND_NID68, REGION11_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR11_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR11_U_RND_NID68, REGION11_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR11_U_RND_NID68, REGION11_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR11_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR11_U_RND_NID68, 0x8368c8)
    FIELD(POR_MPU_M6_PRLAR11_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR11_U_RND_NID68, REGION11_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR11_U_RND_NID68, REGION11_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR12_U_RND_NID68, 0x8368d0)
    FIELD(POR_MPU_M6_PRBAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR12_U_RND_NID68, REGION12_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR12_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR12_U_RND_NID68, REGION12_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR12_U_RND_NID68, REGION12_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR12_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR12_U_RND_NID68, 0x8368d8)
    FIELD(POR_MPU_M6_PRLAR12_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR12_U_RND_NID68, REGION12_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR12_U_RND_NID68, REGION12_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR13_U_RND_NID68, 0x8368e0)
    FIELD(POR_MPU_M6_PRBAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR13_U_RND_NID68, REGION13_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR13_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR13_U_RND_NID68, REGION13_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR13_U_RND_NID68, REGION13_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR13_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR13_U_RND_NID68, 0x8368e8)
    FIELD(POR_MPU_M6_PRLAR13_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR13_U_RND_NID68, REGION13_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR13_U_RND_NID68, REGION13_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR14_U_RND_NID68, 0x8368f0)
    FIELD(POR_MPU_M6_PRBAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR14_U_RND_NID68, REGION14_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR14_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR14_U_RND_NID68, REGION14_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR14_U_RND_NID68, REGION14_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR14_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR14_U_RND_NID68, 0x8368f8)
    FIELD(POR_MPU_M6_PRLAR14_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR14_U_RND_NID68, REGION14_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR14_U_RND_NID68, REGION14_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR15_U_RND_NID68, 0x836900)
    FIELD(POR_MPU_M6_PRBAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR15_U_RND_NID68, REGION15_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR15_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR15_U_RND_NID68, REGION15_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR15_U_RND_NID68, REGION15_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR15_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR15_U_RND_NID68, 0x836908)
    FIELD(POR_MPU_M6_PRLAR15_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR15_U_RND_NID68, REGION15_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR15_U_RND_NID68, REGION15_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR16_U_RND_NID68, 0x836910)
    FIELD(POR_MPU_M6_PRBAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR16_U_RND_NID68, REGION16_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR16_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR16_U_RND_NID68, REGION16_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR16_U_RND_NID68, REGION16_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR16_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR16_U_RND_NID68, 0x836918)
    FIELD(POR_MPU_M6_PRLAR16_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR16_U_RND_NID68, REGION16_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR16_U_RND_NID68, REGION16_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR17_U_RND_NID68, 0x836920)
    FIELD(POR_MPU_M6_PRBAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR17_U_RND_NID68, REGION17_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR17_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_M6_PRBAR17_U_RND_NID68, REGION17_BR, 9, 1)
    FIELD(POR_MPU_M6_PRBAR17_U_RND_NID68, REGION17_AP, 2, 4)
    FIELD(POR_MPU_M6_PRBAR17_U_RND_NID68, RESERVED_0, 0, 2)
REG32(POR_MPU_M6_PRLAR17_U_RND_NID68, 0x836928)
    FIELD(POR_MPU_M6_PRLAR17_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRLAR17_U_RND_NID68, REGION17_LIMIT_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRLAR17_U_RND_NID68, REGION17_EN, 0, 1)
REG32(POR_MPU_M6_PRBAR18_U_RND_NID68, 0x836930)
    FIELD(POR_MPU_M6_PRBAR18_U_RND_NID68, RESERVED_48, 48, 16)
    FIELD(POR_MPU_M6_PRBAR18_U_RND_NID68, REGION18_BASE_ADDR, 12, 36)
    FIELD(POR_MPU_M6_PRBAR18_U_RND_NID68, RESERVED_10, 10, 2)
    FIELD(POR_MPU_