/*  Init
 *
 *  This routine is the initialization task for this program suite.
 *
 *  $Id: init.c,v 1.1 1999/10/25 14:03:52 jack Exp $
 */

#include "bsp.h"

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_MAXIMUM_TIMERS	32

#define CONFIGURE_EXECUTIVE_RAM_SIZE	(512*1024)
#define CONFIGURE_MAXIMUM_SEMAPHORES	20
#define CONFIGURE_MAXIMUM_TASKS		20
#define CONFIGURE_MAXIMUM_PARTITIONS    5

#define STACK_CHECKER_ON 

#define CONFIGURE_MICROSECONDS_PER_TICK	10486

#define CONFIGURE_INIT_TASK_STACK_SIZE	(128*1024)
#define CONFIGURE_INIT_TASK_PRIORITY	120
#define CONFIGURE_INIT_TASK_INITIAL_MODES (RTEMS_PREEMPT | \
                                           RTEMS_NO_TIMESLICE | \
                                           RTEMS_NO_ASR | \
                                           RTEMS_INTERRUPT_LEVEL(0))

#define CONFIGURE_INIT

/* forward declarations */

rtems_task Init (rtems_task_argument argument);
int	rtems_snmp_main (rtems_task_argument port);


#include "stdio.h"
#include "string.h"
#include "errno.h"
#include "stdlib.h"

#include "rtems/error.h"

#include "rtems/rtems_bsdnet.h"
#include "sys/types.h"
#include "sys/socket.h"
#include "netinet/in.h"
#include "arpa/inet.h"

#include "networkconfig.h"
#include "confdefs.h"


#define SNMP_DEFAULT_PORT     161 

static
void
showStatistics (void)
{
	rtems_bsdnet_show_inet_routes ();
	rtems_bsdnet_show_mbuf_stats ();
	rtems_bsdnet_show_if_stats ();
	rtems_bsdnet_show_ip_stats ();
	rtems_bsdnet_show_icmp_stats ();
	rtems_bsdnet_show_udp_stats ();
	rtems_bsdnet_show_tcp_stats ();
}

/*
 * Run SNMP server
 */
static void
runSNMPServer (rtems_task_argument port)
{
	rtems_snmp_main (port);
	rtems_task_delete (RTEMS_SELF);
}

void
init_snmp_server (void)
{
	rtems_status_code sc;
	rtems_task_priority my_priority;
	rtems_id tid;

	/*
	 * Spawn  server
	 */
	 
	rtems_task_set_priority (RTEMS_SELF, RTEMS_CURRENT_PRIORITY, &my_priority);
	sc = rtems_task_create (rtems_build_name ('S', 'N', 'M', 'P'),
			my_priority - 1,
			128*1024,
			RTEMS_PREEMPT|RTEMS_NO_TIMESLICE|RTEMS_NO_ASR|RTEMS_INTERRUPT_LEVEL(0),
			RTEMS_NO_FLOATING_POINT|RTEMS_LOCAL,
			&tid);
	
    if (sc != RTEMS_SUCCESSFUL) 
    {
		printf ("Can't create server; %s\n", rtems_status_text (sc));
		return;
	}
	
    sc = rtems_task_start (tid, runSNMPServer, SNMP_DEFAULT_PORT);
	
    if (sc != RTEMS_SUCCESSFUL) 
    {
	    printf ("Can't start server; %s\n", rtems_status_text (sc));
	    return;
    }

	/*
	 * Wait for characters from console terminal
	 */
	for (;;) {
		switch (getchar ()) {
		case 'q':
			return;

		case 's':
			showStatistics ();
			break;
		}
	}
}

/*
 * RTEMS Startup Task
 */
rtems_task Init(
  rtems_task_argument ignored
)
{
  int sc;
  
  printf("We are going to initialize a network...");
  rtems_bsdnet_initialize_network ();
  printf("Done\n");

  init_snmp_server();

  sc = rtems_task_delete(RTEMS_SELF);

  if (sc != RTEMS_SUCCESSFUL) 
  {
    printf ("Can't delete task %s\n", rtems_status_text (sc));
    return;
  }
}

