/*
 * RTEMS configuration/initialization
 * 
 * This program may be distributed and used for any purpose.
 * I ask only that you:
 *	1. Leave this author information intact.
 *	2. Document any changes you make.
 *
 * W. Eric Norum
 * Saskatchewan Accelerator Laboratory
 * University of Saskatchewan
 * Saskatoon, Saskatchewan, CANADA
 * eric@skatter.usask.ca
 *
 *  $Id: init.c,v 1.8 1999/12/14 13:23:56 joel Exp $
 */

#include <bsp.h>
#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS 32 
#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_EXECUTIVE_RAM_SIZE	(512*1024)
#define CONFIGURE_MAXIMUM_SEMAPHORES	40
#define CONFIGURE_MAXIMUM_TASKS		40

#define CONFIGURE_MICROSECONDS_PER_TICK	10000

#define CONFIGURE_INIT_TASK_STACK_SIZE	(10*1024)
#define CONFIGURE_INIT_TASK_PRIORITY	120
#define CONFIGURE_INIT_TASK_INITIAL_MODES (RTEMS_PREEMPT | \
                                           RTEMS_NO_TIMESLICE | \
                                           RTEMS_NO_ASR | \
                                           RTEMS_INTERRUPT_LEVEL(0))

#define CONFIGURE_INIT
rtems_task Init (rtems_task_argument argument);

#include <confdefs.h>
#include <stdio.h>
#include <syslog.h>
#include <rtems/rtems_bsdnet.h>
#include "network_config.h"
#include <ftpd.h>
#include <tcl.h>
#include <stdlib.h>

extern int _binary_tarfile_start;
extern int _binary_tarfile_size;
extern int rtems_tcl_main(int argc, char **argv);

struct rtems_ftpd_configuration rtems_ftpd_configuration = {
   10,		/* FTPD task priority            */
   1024,		/* Maximum buffersize for hooks  */
   0,			/* Well-known port     				*/
   NULL		/* List of hooks       				*/
};

static rtems_interval ticksPerSecond;

rtems_task Init(rtems_task_argument ignored)
{
	static char *argv[] = {  NULL };
   rtems_status_code status;
   
   rtems_clock_get (RTEMS_CLOCK_GET_TICKS_PER_SECOND, &ticksPerSecond);
   putenv("TERM=xterm");
   putenv("TCL_LIBRARY=");
   putenv("PATH=./:/");

   rtems_bsdnet_initialize_network ();
   rtems_initialize_ftpd();
   status = Untar_FromMemory((unsigned char *)(&_binary_tarfile_start), 
                             &_binary_tarfile_size);

   rtems_tcl_main(0, argv); 
   rtems_task_suspend (RTEMS_SELF);
}
