#ifndef __ssf_base_h__
#define __ssf_base_h__
///////////////////////////////////////////////////////////////////////////
// $Header: /usr/local/cvs-repository/ssf/src/ssf_base.h,v 1.1.1.1 2001/01/13 21:01:17 rosimildo Exp $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//  
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// DESCRIPTION: C++ Fraemwork to talk to SQL db engines..
// SSF: stands for: Simple Storable Framework
//
// NOTE: This has been loosely based on the original work from:
// database.cc C++ wrapper library
// 
// Author: Roland Haenel <rh@ginster.net>
// This program is in the public domain.
// Distribute and use it freely.
//
// HISTORY:
//
// $Log: ssf_base.h,v $
// Revision 1.1.1.1  2001/01/13 21:01:17  rosimildo
// Initial checkin for SSF
//
//
///////////////////////////////////////////////////////////////////////////

#include "ssf_inc.h"

namespace ssf
{

/**
 * Keeps the result of a command executed on a Connection instance.
 */
class ResultSet 
{
public:
   ResultSet() {}
	virtual ~ResultSet() {}

	// Number of fetched rows...
	virtual int getRows() = 0;
	// Number of columns per row...
	virtual int getColumns() = 0;

	// Name of nth column
	virtual char *getColumnName(int n) = 0;
   // Index of the column matching the name
	virtual int   getColumnIndex(const char *name)  = 0;

	 // Size of nth column
	virtual int   getColumnSize(int n) = 0;
	// Size of nth column by name
	virtual int   getColumnSize(const char *name) = 0;

	// Sets internal cursor to row
	virtual bool seekRow(int row) = 0;

   // reset internal cursor to fisrt row...
   virtual void reset() = 0;
   // go to the next row...
   virtual bool next() = 0;

   // access members...
   virtual const char *getString( const char *name ) = 0;
   virtual const char *getString( int columnIndex )  = 0;

   virtual long   getLong( const char *name );
   virtual long   getLong( int columnIndex );

   virtual int    getInt( const char *name );
   virtual int    getInt( int columnIndex );

   virtual float  getFloat( const char *name );
   virtual float  getFloat( int columnIndex );

   virtual double getDouble( const char *name );
   virtual double getDouble( int columnIndex );

   // TODO: more access members for Date, TimeStamp...

protected:

};

/**
 * Class Wrapper to talk to a MySQL Database. It tries to 
 * resembles some of the JDBC Connection class, but not that
 * much yet....
 */
class Connection
{
protected:
	bool connected;
   int  db_err;
public:

	Connection() : connected( false ), db_err( 0 ) {}
	virtual ~Connection(){}

   bool isConnected() const { return connected; }
   bool success() const { return db_err == 0; }
	const char *errorDescription() const { return errorDescription( db_err ); }
   int raw_errno() const { return db_err; }

	virtual const char *errorDescription( int err ) const = 0;
	virtual bool connect(const char *url, const char *user, const char *passwd ) = 0;
	virtual void disconnect() = 0;

	bool connect(const char *url ) { return connect( url, NULL, NULL ); }

   // JDBC equivalents, defualt behavior does nothing
   virtual bool getAutoCommit() { return true; }
   virtual void setAutoCommit( bool /* value */ ) {}
   virtual void commit() {}
   virtual void rollback() {}

   // should be overwriten if implemented by the DB driver...
   virtual UINT64 idAfterInsert() { return 0; }

	virtual ResultSet *executeQuery(const char *sqlStatement ) = 0; 
	ResultSet *executeQueryFormat(const char *sqlFormat, ...);

	virtual UINT64 executeUpdate(const char *sqlStatement ) = 0; 
	UINT64 executeUpdateFormat(const char *sqlFormat, ... ); 
};

};

#endif //  __ssf_base_h__


