///////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//  
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// DESCRIPTION: C++ Wrapper to talk to a MySQL database.
//
// HISTORY:
//
// $Log: $
//
///////////////////////////////////////////////////////////////////////////

#include "ssf_factory.h"
#include "ssf_mysql.h"

namespace ssf
{

/**
 * Generic factory to create the "Connection" instances to different 
 * DB engines.
 */
Connection *Factory::createConnection( DB_DRIVER_TYPE type, const char * )
{
   Connection *c = 0;
   switch( type )
   {
      case MySQL:
        c = new MySQLConnection();
        break;
   }
   return c;
}


} // namespace
