/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
//  
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
// MODULE DESCRIPTION: Simple Storable Framework -- Generic class
// factory to create instances of "Storable" matching a query.
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

package ssf;


import java.sql.*;
import java.util.*;


/**
 * 
 */
public class StorableFactory
{
   /**
    *  Returns a Storable class instance from a class name.
    */
   public static Storable create( String name ) throws Exception
   {
      try 
      {
        return ( Storable )Class.forName( name ).newInstance();
      }
      catch( Exception e )
      {
         throw e;
      }
   }

   /** 
    * This method returns a list of instances represeting the "matches"
    * on the DB, for the type of "Stotrble" requested. It is 
    * used by the subclasses to get list of themselves a bit easier.
    */
   public static List getList
   ( 
      String className,
      String tableName, 
      String where,
      Connection c
   ) throws SQLException, Exception
   {
      List v = new LinkedList();
      Statement stmt = null;
      try 
      {
         String query = "SELECT * FROM " + tableName;
         stmt = c.createStatement();
         ResultSet rs = stmt.executeQuery( query );
         while( rs.next() )
         {
            Storable cur = create( className );
            cur.mapping( rs );
            v.add( (Object)cur );
         }
         stmt.close();
      }
      catch( SQLException e ) 
      {
         try 
         {
            if( stmt != null )
               stmt.close();
         }
         catch( Exception e2 )
         {
            e2.printStackTrace();
            throw e2;
         }
      }
      catch( Exception e ) 
      {
         e.printStackTrace();
         throw e;
      }
      return v;
   }
}


