#ifndef __rtems_rrm_i__
#define __rtems_rrm_i__
/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
// Class definition for the implementation of the Rtems Monitor interface.
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


// include is generated by the IDL compiler..
#include "rtems_rrm.hh"


namespace Rtems {

class MonitorImpl: public POA_Rtems::Monitor, 
                   public PortableServer::RefCountServantBase
{
public:
  MonitorImpl() {}
  virtual ~MonitorImpl() {}

  // these methods are stubs for the time being,
  // and no implementation for them.
  virtual RtemsThreadList * getRtemsThreads();
  virtual RtemsSemaphoreList * getRtemsSemaphores();
  virtual RtemsTimerList * getRtemsTimers();
  virtual RtemsPartitionList * getRtemsPartitions();
  virtual RtemsRegionList * getRtemsRegions();
  virtual RtemsMessageQueueList * getRtemsMessageQueues();
  virtual PosixThreadList * getPosixThreads();
  virtual PosixSemaphoreList * getPosixSemaphores();
  virtual PosixMutexList * getPosixMutexes();
  virtual PosixKeyList * getPosixKeys();
  virtual PosixCondVariableList * getPosixCondVariables();
  virtual PosixInterruptList * getPosixInterrupts();
  virtual PosixMessageQueueList * getPosixMessageQueues();


  // the only ones implemented at this point.
  virtual char*  getInstancesAsHTML( CounterType instanceType );
  virtual CounterInfo  getCounter(CounterType  cntType);
};

} // namespace

#endif // __rtems_rrm_i__


