/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION: 
//
// RTEMS RRM - Remote Resource Monitor.
// A java base GUI - This program talks to a RTEMS target system to
// retrieve information about RTEMS resources using a CORBA interface.
//
// The goal of this application is to show the integration of java and
// RTEMS objects using CORBA.
//
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


import javax.swing.JTabbedPane;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;

import java.awt.*;
import java.awt.event.*;

public class RtemsRRM extends JPanel 
{
    //
    // Build the GUI for the RTEMS RRM application...
    //
    public RtemsRRM() 
    {
        GridBagLayout grid;
        GridBagConstraints c;
        CountersControl  countersPanel = new CountersControl();
        ResourcesViewControl resourcesPanel = new ResourcesViewControl();

        //Add the tabbed pane to this panel.
        grid = new GridBagLayout(); 
        setLayout( grid ); 

        c = new GridBagConstraints();
        buildConstraints( c, 0, 0, 1, 1, 90, 100 );
        c.fill = GridBagConstraints.BOTH;
        c.anchor = GridBagConstraints.NORTH;
        grid.setConstraints( resourcesPanel, c );
        add( resourcesPanel );

        buildConstraints( c, 1, 0, 1, 1, 10, 100 );
        c.fill = GridBagConstraints.BOTH;
        c.anchor = GridBagConstraints.NORTH;
        grid.setConstraints( countersPanel, c );
        add( countersPanel );
    }

    //
    // Setup the "bag-grid" constraints...
    //
    private void buildConstraints( GridBagConstraints gbc, 
                                   int gx, int gy, int gw, int gh, int wx, int wy )
    {
       gbc.gridx = gx;
       gbc.gridy = gy;
       gbc.gridwidth = gw;
       gbc.gridheight = gh;
       gbc.weightx = wx;
       gbc.weighty = wy;
    }

    //
    // Main routine to start the Rtems RRM program.
    //
    public static void main(String[] args) 
    {
      // FIXME: we should get these from the command line.
      String namingServiceHost = "rps1";
      String namingServicePort = "6000";

      try
      {
        RtemsORBWrapper.getORB( args, namingServiceHost, 
                                      namingServicePort );  // create and initialize the ORB
        if( !RtemsORBWrapper.setupConnection() )
		{
           System.out.println("Could not set remote connection." );
  	       System.exit( 1 );
        }
        System.out.println("Connected successfully." );
      } 
      catch (Exception e) 
      {
          System.out.println("CORBA ERROR: " + e );
          e.printStackTrace( System.out );
          System.exit( 1 );
      }

      //
      // At this point, we have contacted the remote RTEMS system, and a connection
      // to the target has been established. The system is ready to start monitoring
      // the resources.
      //
      System.out.println("Now, let's start the GUI..." );

      JFrame frame = new JFrame( "RRM: Remote Resource Monitor for RTEMS - Version 0.01" );
      frame.addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) {System.exit(0);} } );

      frame.getContentPane().add(new RtemsRRM(), BorderLayout.CENTER );
      frame.setSize( 800, 500 );
      frame.setVisible(true);
    }
}
