/***************************************************************************
 *
 * $Header: $
 *
 * Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
 *  
 * MODULE DESCRIPTION: RTEMS configuration file. This file should be
 *                     udpated to match your own configuration.
 *
 * by: Rosimildo da Silva:
 *     rdasilva@connecttel.com
 *     http://www.connecttel.com
 *
 * MODIFICATION/HISTORY:
 *
 * $Log: $
 ****************************************************************************/

#include <bsp.h>              /* includes <rtems.h> */
#include <tty_drv.h>
#include <rtems/ps2_drv.h>
#include <rtems/serial_mouse.h>
#include <rtems/fb_vga.h>

/* functions */
#ifdef __cplusplus
extern "C" {
#endif

/* configuration information */
#define CONFIGURE_MAXIMUM_DEVICES                     40
#define CONFIGURE_MAXIMUM_TASKS                       300
#define CONFIGURE_MAXIMUM_TIMERS                      32
#define CONFIGURE_MAXIMUM_SEMAPHORES                  100
#define CONFIGURE_MAXIMUM_MESSAGE_QUEUES              20
#define CONFIGURE_MAXIMUM_PARTITIONS                  10
#define CONFIGURE_MAXIMUM_REGIONS                     10

/* This seetings overwrite the ones defined in confdefs.h */
#define CONFIGURE_MAXIMUM_POSIX_MUTEXES 		         32
#define CONFIGURE_MAXIMUM_POSIX_CONDITION_VARIABLES  	32
#define CONFIGURE_MAXIMUM_POSIX_KEYS         		   32
#define CONFIGURE_MAXIMUM_POSIX_QUEUED_SIGNALS 		   10
#define CONFIGURE_MAXIMUM_POSIX_THREADS      		   256
#define CONFIGURE_MAXIMUM_POSIX_TIMERS                10

/* used by the input device driver */
#define CONFIGURE_MAXIMUM_POSIX_MESSAGE_QUEUES        10

void *POSIX_Init( void *argument );
#define CONFIGURE_INIT_TASK_STACK_SIZE	               (512*1024)
#define CONFIGURE_POSIX_INIT_THREAD_STACK_SIZE        (512*1024)
#define CONFIGURE_POSIX_INIT_THREAD_TABLE


#define CONFIGURE_HAS_OWN_DEVICE_DRIVER_TABLE
#define CONFIGURE_MICROSECONDS_PER_TICK	        1000


/* List of device drivers loaded by RTEMS at boot time */
rtems_driver_address_table Device_drivers[] = 
{
  CONSOLE_DRIVER_TABLE_ENTRY,
  CLOCK_DRIVER_TABLE_ENTRY,
  TTY2_DRIVER_TABLE_ENTRY,
#if PS2_MOUSE
  PAUX_DRIVER_TABLE_ENTRY,
#else
  SERIAL_MOUSE_DRIVER_TABLE_ENTRY,
#endif
  FBVGA_DRIVER_TABLE_ENTRY,

  { NULL,NULL, NULL,NULL,NULL, NULL }
};

#include <confdefs.h>


#ifdef __cplusplus
}
#endif
/* end of include file */
