#! /bin/sh
#
# Script to build Python for RTEMS.
#
# Chris Johns 
# Copyright 2005 Chris Johns (chrisj@rtems.org)
#

fatal()
{
 if [ $1 -ne 0 ] ; then
  shift
  echo "error: $*" >&2
  exit 1
 fi
 return 0
}

lower='abcdefghijklmnopqrstuvwxyz'
upper='ABCDEFGHIJKLMNOPQRSTUVWXYZ'

BASEOBLIBS="Modules\/_bisectmodule.o \
 Modules\/_csv.o \
 Modules\/_heapqmodule.o \
 Modules\/_localemodule.o \
 Modules\/_randommodule.o \
 Modules\/_ssl.o \
 Modules\/_weakref.o \
 Modules\/arraymodule.o \
 Modules\/binascii.o \
 Modules\/cPickle.o \
 Modules\/cStringIO.o \
 Modules\/cmathmodule.o \
 Modules\/collectionsmodule.o \
 Modules\/cryptmodule.o \
 Modules\/datetimemodule.o \
 Modules\/fcntlmodule.o \
 Modules\/grpmodule.o \
 Modules\/itertoolsmodule.o \
 Modules\/mathmodule.o \
 Modules\/md5c.o \
 Modules\/md5module.o \
 Modules\/operator.o \
 Modules\/parsermodule.o \
 Modules\/pwdmodule.o \
 Modules\/regexmodule.o \
 Modules\/regexpr.o \
 Modules\/selectmodule.o \
 Modules\/shamodule.o \
 Modules\/socketmodule.o \
 Modules\/stropmodule.o \
 Modules\/structmodule.o \
 Modules\/termios.o \
 Modules\/timemodule.o \
 Modules\/timingmodule.o \
 Modules\/expat\/xmlparse.o \
 Modules\/expat\/xmlrole.o \
 Modules\/expat\/xmltok.o"

#
# Add if you need unicode support.
#
# Modules\/cjkcodecs\/multibytecodec.o \
# Modules\/unicodedata.o \
#

version=2.4
source=Python-2.4.1

build=$(uname -m)-$(uname -s | sed -e 'y/'$upper'/'$lower'/')
target=$1-rtems
cpu=$2
cpu_flags=-$3
prefix=$4

CC=${target}-gcc
CXX=${target}-g++
AR=${target}-ar
CFLAGS="-g -O3 ${cpu_flags}"
CPPFLAGS="-I ${prefix}/${target}/lib/include"
LDFLAGS="${cpu_flags}" # -Xlinker --no-undefined -Xlinker --allow-multiple-definition"
LIBS="-lc -lrtemscpu"
LIBDIR="${prefix}/${target}/lib/m5200"
INCLUDEDIR="${prefix}/${target}/include"
CONFINCLUDEDIR="${prefix}/${target}/include"

echo "CC="${CC}" CXX="${CXX}" AR="${AR}" CFLAGS="${CFLAGS}" CPPFLAGS="${CPPFLAGS}" \
      LDFLAGS="${LDFLAGS}" LIBS="${LIBS}" \
      ../${source}/configure --host=$target --build=${build} --prefix=${prefix} \
      --enable-pgen=../${build}/Parser/pgen --without-doc-strings --disable-unicode"
CC="${CC}" CXX="${CXX}" AR="${AR}" CFLAGS="${CFLAGS}" CPPFLAGS="${CPPFLAGS}" \
    LDFLAGS="${LDFLAGS}" LIBS="${LIBS}" \
    ../${source}/configure --host=$target --build=${build} --prefix=${prefix} \
          --without-doc-strings  --disable-unicode \
          --enable-pgen=../${build}/Parser/pgen
fatal $? "python configure"

cat Makefile | \
  sed -e "s/^MODOBJS=/MODOBJS=${BASEOBLIBS}/g" -e "s/^MACHDEP=.*/MACHDEP=\tRTEMS/g" > Makefile.tmp
fatal $? "python patch Makefile"
rm Makefile && mv Makefile.tmp Makefile
fatal $? "python replacing the Makefile"

mkdir -p Modules/cjkcodecs
fatal $? "python making Modules/cjkcodecs"
mkdir -p Modules/expat
fatal $? "python making Modules/expat"

echo "make CFLAGS="${CFLAGS} ${CPPFLAGS}" LDFLAGS="${LDFLAGS}" LIBS="${LIBS}" \
     LIBDIR="${LIBDIR}" INCLUDEDIR="${INCLUDEDIR}" CONFINCLUDEDIR="${CONFINCLUDEDIR}" \
      all inclinstall libainstall"
make CFLAGS="${CFLAGS} ${CPPFLAGS}" LDFLAGS="${LDFLAGS}" LIBS="${LIBS}" \
     LIBDIR="${LIBDIR}" INCLUDEDIR="${INCLUDEDIR}" CONFINCLUDEDIR="${CONFINCLUDEDIR}" \
      all inclinstall libainstall
fatal $? "python make and install"

cp ${prefix}/${target}/lib/${cpu}/python${version}/config/libpython${version}.a \
   ${prefix}/${target}/lib/${cpu}/libpython${version}.a
fatal $? "python move library"

exit 0
