#include <rtems.h>

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <Python.h>

#include <rtems/monitor.h>

#define USE_TAR 1

/*
 * These are created by the linker when linking a binary file.
 */

#ifdef USE_TAR
#include <rtems/untar.h>
#define PYTHON_LIB(p)  _binary_python_pyc_tar_ ## p
extern int PYTHON_LIB (start);
extern int PYTHON_LIB (size);
#endif

int our_argc;
char **our_argv;

void run (rtems_task_argument main_id)
{
  setenv ("PYTHONHOME", "/python", 1);  
  setenv ("PYTHONPATH", "/python/lib/python2.4", 1);  
#if 0
  setenv ("PYTHONDEBUG", "10", 1);
  setenv ("PYTHONVERBOSE", "10", 1);
#endif

  Py_Main(our_argc, our_argv);

  rtems_event_send ((rtems_id) main_id, RTEMS_EVENT_0);

  rtems_task_delete (RTEMS_SELF);
}

int main (int argc, char * argv[])
{
  rtems_status_code result;
  rtems_event_set   event_out;
  rtems_name        name;
  rtems_id          self;
  rtems_id          id;

  our_argc = argc;
  our_argv = argv;
  
#if 0  
  rtems_monitor_init (0);
  rtems_register_bin_cmds ();
#endif
  
#ifdef USE_TAR
  Untar_FromMemory ((unsigned char *) (&PYTHON_LIB (start)),
                    (int) &PYTHON_LIB (size));
#endif

  rtems_task_ident (RTEMS_SELF, RTEMS_SEARCH_ALL_NODES, &self);
  
  name = rtems_build_name('P', 'y', 'I', 'n');

  result = rtems_task_create(name, 100, 1024 * 60,
                             RTEMS_DEFAULT_ATTRIBUTES, RTEMS_LOCAL,
                             &id);

  if (result != RTEMS_SUCCESSFUL)
  {
    printf ("python: create task failed, error = %d\n", result);
    return 0;
  }

  result = rtems_task_start(id, run, (rtems_task_argument) self);

  if (result != RTEMS_SUCCESSFUL)
  {
    printf ("python: start task failed, error = %d\n", result);
    rtems_task_delete (id);
    return 0;
  }

  rtems_event_receive (RTEMS_EVENT_0, RTEMS_WAIT | RTEMS_EVENT_ANY,
                       0, &event_out);
 
  return 0;
}
