/*	view.cxx

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/14/0 10:52AM
$Header: /cvsroot/jedi/wince/view.cxx,v 1.26 2000/10/04 04:11:12 tomyeh Exp $
Purpose:	CView and the window procedure
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/event.h>
#include <jedi/thread.h>
#include "palmce.h"
#include "view.h"
#include "dlg.h"

////////////////////////////////////////////////////////
CView g_view;

EXTERN_C void _JAPI mtOsNotifyNoApp(void)
{
	g_view.PostCommand(IDC_NOTIFY_NOAPP);
}

int CView::OnCreate(LPCREATESTRUCT /*lpcs*/)
{
	if(!m_cmdBar.Create(this, IDR_MAINFRAME)){
		TRACE("Failed to create m_cmdBar\n");
	}else{
		m_cmdBar.AddBitmap(g_app.Instance(), IDR_CMDBAR_BITMAP, 4);

		TBBUTTON btn;
		btn.fsState		= TBSTATE_ENABLED;
		btn.fsStyle		= TBSTYLE_BUTTON;
#ifdef _WIN32
		btn.bReserved[0] = btn.bReserved[1] = 0;
#endif
    	btn.dwData		= 0;
    	btn.iString		= -1;

		for(int nId=IDC_BUTTON_LAST; nId>=IDC_BUTTON_FIRST; --nId){
			btn.iBitmap		= nId-IDC_BUTTON_FIRST;
			btn.idCommand	= nId;
	  
			m_cmdBar.InsertButton(0, &btn);
		}
	}

	return 0;
		//Note: if we return -1 here, it cause a GP fault inside Windows
		//Thus, we returns success here and checks IsInitOK later in caller
}

void CView::OnClose()
{
	TRACE("Closing the window\n");

	evtOnHwNotify(EVT_APPSTOP);
	//Note: we don't wait EVT_APPSTOP being processed here because Palm app
	//does not access CView directly. Thus, we wait after the window
	//is destroy, see main.cxx

	//DefWindowProc will be called after returned
}

void CView::OnSettingChange(int flag)
{
	switch(flag){
	case SPI_SETSIPINFO:
		{	SIPINFO si;
			memset(&si, 0, sizeof(si));
			si.cbSize = sizeof(si);
			if(SHSipInfo(SPI_GETSIPINFO, 0, &si, 0)){
				//not yet: take care of SIP's changing
				//int wd = si.rcVisibleDesktop.right - si.rcVisibleDesktop.left;
				//int hgh = si.rcVisibleDesktop.bottom - si.rcVisibleDesktop.top;
				//if(!(si.fdwFlags & SIPF_ON) ) hgh -= MENU_HEIGHT;
			}
		}
		break;
	}
}

inline void CView::OnAppHelp()
{
	//not yet
}

inline void CView::OnAppOption()
{
	COptionDlg dlg;
	dlg.Create(this);
}

inline void CView::OnAppRegister()
{
	CRegisterDlg dlg;
	dlg.Create(this);
}

inline void CView::OnAppAbout()
{
	CAboutDlg dlg;
	dlg.Create(this);
}

void CView::OnCommand(int nId)
{
	switch(nId){
	case IDC_APP_HELP:
		OnAppHelp();
		break;
	case IDC_APP_OPTION:
		OnAppOption();
		break;
	case IDC_APP_REGISTER:
		OnAppRegister();
		break;
	case IDC_APP_ABOUT:
		OnAppAbout();
		break;
	case IDC_NOTIFY_NOAPP:
		ErrorBox(IDP_NOTIFYNOAPP);
		PostMessage(WM_CLOSE);
		break;
	default:
		if(nId>=IDC_BUTTON_FIRST && nId<=IDC_BUTTON_LAST){
			static __u8 slkbtn[] = {
				CC_LAUNCH-CC_VIRTUAL_FIRST, CC_MENU-CC_VIRTUAL_FIRST,
				CC_CALC-CC_VIRTUAL_FIRST,   CC_FIND-CC_VIRTUAL_FIRST
			};
			evtOnHwNotify(EVT_KEYDOWN,
				slkbtn[nId - IDC_BUTTON_FIRST]+CC_VIRTUAL_FIRST);
		}
		break;
	}
}

void CView::OnPaint()
{
	CPaintDC dc(this);
	fbDraw(dc);
}

static int _STDCALL ConvertKey(int nKey)
{
	//h/w button
	if(nKey==VK_PRIOR)
		return CC_PAGEUP;

	if(nKey==VK_NEXT)
		return CC_PAGEDOWN;

	if(nKey>=0xc1 && nKey<=0xc4) //h/w button
		return nKey - 0xc1 + CC_BTN1;

	//other keys
	static __u8 s_map[] = {CC_LEFT, CC_UP, CC_RIGHT, CC_DOWN};

	return	nKey==VK_CONTROL ? CC_COMMAND: //open command bar window
			nKey>=VK_LEFT && nKey<=VK_DOWN ?
				s_map[nKey-VK_LEFT]: 0;
}

inline void CView::OnKeyDown(int nKey)
{
#ifndef NDEBUG
	if(nKey == VK_F4){
		PostMessage(WM_CLOSE);
		return;
	}
#endif

	nKey = ConvertKey(nKey);
	if(nKey)
		evtOnHwNotify(EVT_KEYDOWN, nKey);
}

inline void CView::OnKeyUp(int nKey)
{
	nKey = ConvertKey(nKey);
	if(nKey)
		evtOnHwNotify(EX_EVT_KEYUP, nKey);
}

inline void CView::OnChar(int nKey)
{
	evtOnHwNotify(EVT_KEYDOWN, nKey==VK_RETURN ? CC_LINEFEED: nKey);
}

LRESULT CALLBACK CView::WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	CView* wnd = (CView*)CFrame::PreWndProc(hWnd, uMsg, wParam, lParam);

	switch(uMsg){
	case WM_CREATE:
		return wnd->OnCreate((CREATESTRUCT*)lParam);

	case WM_PAINT:
		wnd->OnPaint();
	l_ret0:
		return 0;

	case WM_CLOSE:
		wnd->OnClose();
		break;

	case WM_COMMAND:
		wnd->OnCommand(LOWORD(wParam));
		goto l_ret0;

	case WM_SETTINGCHANGE:
		wnd->OnSettingChange(wParam);
		goto l_ret0;

	//////////////////////////////////////////////////////
	//Keyboard messages
	case WM_KEYDOWN:
		wnd->OnKeyDown((int)wParam);
		goto l_ret0;

	case WM_KEYUP:
		wnd->OnKeyUp((int)wParam);
		goto l_ret0;

	case WM_CHAR:
		wnd->OnChar((int)wParam);
		goto l_ret0;

	//////////////////////////////////////////////////////
	//Button messages
	case WM_LBUTTONDBLCLK:
		uMsg = EX_EVT_PENDOWN + 1;
		goto l_on_btndown;

	case WM_LBUTTONDOWN:
		uMsg = EX_EVT_PENDOWN;
	l_on_btndown:
		SetCapture(hWnd);
		goto l_on_mouse;

	case WM_LBUTTONUP:
		uMsg = EVT_PENUP;
		ReleaseCapture();
		goto l_on_mouse;

	case WM_MOUSEMOVE:
		if(!(wParam & MK_LBUTTON))
			break;
		uMsg = EVT_PENMOVE;

	l_on_mouse:
		evtOnHwNotify((int)uMsg, LOWORD(lParam), HIWORD(lParam));
		goto l_ret0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}
