/*	main.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/4/0 09:26PM
	$Header: /cvsroot/jedi/wince/main.cxx,v 1.19 2000/09/22 11:57:52 tomyeh Exp $
	Purpose:	The main program of PalmCE
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/fb.h>
#include <jedi/mem.h>
#include <jedi/event.h>
#include "palmce.h"
#include "view.h"

////////////////////////////////////////////////////////
const struct TPenBtnInfo g_penBtnList[PEN_BTN_NO] = {
	{{{ 27, 1206}, {18, 14}}, CC_KEYBOARDALPHA,		0, KM_COMMAND},
	{{{115, 1206}, {18, 14}}, CC_KEYBOARDNUMERIC,	0, KM_COMMAND},
	{{{  0, 1164}, {27, 28}}, CC_LAUNCH,			0, KM_COMMAND},
	{{{  0, 1192}, {27, 28}}, CC_MENU,				0, KM_COMMAND},
	{{{133, 1164}, {27, 28}}, CC_CALC,				0, KM_COMMAND},
	{{{133, 1192}, {27, 28}}, CC_FIND,				0, KM_COMMAND}
		//we add 1000 to vertical offset to fake
};

////////////////////////////////////////////////////////
//CTheApp
CTheApp g_app;

bool CTheApp::InitInstance(HINSTANCE hInst, LPCTSTR cmdLine, int nCmdShow)
{
	fbInit(); //retrieve screen information

	CApp::InitInstance(&g_view, IDR_MAINFRAME, hInst);

	HWND hWnd = CView::Find();	
	if(hWnd){
		SetForegroundWindow(hWnd);
		return false;
	}

	//register and create g_view
	WNDCLASS wcs;
	wcs.style		= CS_DBLCLKS;
	wcs.lpfnWndProc	= CView::WndProc;
	wcs.cbClsExtra	= 0;
	wcs.cbWndExtra	= sizeof(CView*);
	wcs.hInstance	= hInst;
	wcs.hIcon		= LoadIcon(hInst, MAKEINTRESOURCE(IDR_MAINFRAME));
	wcs.hCursor		= 0;
	wcs.hbrBackground	= 0;
	wcs.lpszMenuName	= 0;
	wcs.lpszClassName	= CLSNAME_VIEW;
	if(!RegisterClass(&wcs) ||
			!g_view.Create(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT) ||
			!g_view.IsInitOK()){
		ErrorBox(IDP_CREATEWINDOW_FAIL);
		return false;
	}

	JediStart(_T2AN(cmdLine, MAX_DB_NAME_LEN));

	g_view.ShowWindow(nCmdShow); //show window after JediStart since resize
	return true;
}

void CTheApp::ExitInstance()
{
	//wait for all applications to stop (stupid way but simple)
	//No need to call mtJediSleep because the main thread is running
	//w/o AnakinLock() (after all, it processes UI events)
	DWORD to = GetTickCount() + 2000; //at most 2 seconds
	while(g_listApp && GetTickCount()<=to)
		Sleep(10);

	//cleanup
	JediStop();
	UnregisterClass(CLSNAME_VIEW, m_hInstance);

	if(m_hAccel)
		DestroyAcceleratorTable(m_hAccel);
		//because we might CreateAcceleratorTable in cemenu.cxx

	CApp::ExitInstance();
}

////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE, LPTSTR cmdLine, int nCmdShow)
{
	if(!g_app.InitInstance(hInst, cmdLine, nCmdShow))
		return -1;

	int iRet = g_app.Run();
	g_app.ExitInstance();
	return iRet;
}

#ifndef NDEBUG
DEF_SYSCLEANUP(MCheck, _MCHECK())
#endif
