/*	cetime.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/15/0 09:30AM
	$Header: /cvsroot/jedi/wince/cetime.cxx,v 1.3 2000/09/27 04:05:01 tomyeh Exp $
	Purpose:	Time functions on CE
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/time.h>

#define n1SecIn100NS 	10000000
#define n1DayInSec		86400
#define nYear1			1904

#ifdef __LITTLE_ENDIAN__
#define Ft2U64(v)		(*((__u64*)&v))
#else
#define Ft2U64(v)		((((__u64)v.dwHighDateTime)<<32) + ((__u64)v.dwLowDateTime))
#endif

#define	ToSeconds	_ToSeconds
	//We use 64-bit here but 32-bit elsewhere, so rename it to avoid problem

///////////////////////////////////////////////////////////
static __u64 _STDCALL ToCeSeconds(const SYSTEMTIME *pst)
{
	FILETIME ft;
	SystemTimeToFileTime(pst, &ft);

	return Ft2U64(ft) / n1SecIn100NS;
}

static __u64 _STDCALL ToCeSeconds(int year, int month, int day)
{
	SYSTEMTIME st;

	st.wYear			= (WORD)year;
	st.wMonth			= (WORD)month;
	st.wDay				= (WORD)day;
	st.wDayOfWeek		= 1; //assumed
	st.wHour			= 0;
	st.wMinute			= 0;
	st.wSecond			= 0;
	st.wMilliseconds	= 0;

	return ToCeSeconds(&st);
}

static __u64 s_second1 = ToCeSeconds(nYear1, 1, 1);

EXTERN_C __u64 _JAPI ToSeconds(int year, int month, int day)
{
	return ToCeSeconds(year, month, day) - s_second1;
}

static __u64 _STDCALL ToSeconds(const SYSTEMTIME *pst)
{
	return ToCeSeconds(pst) - s_second1;
}

static void _STDCALL SecondsToSystemTime(__u64 t, SYSTEMTIME* pst)
{
	t = (t + s_second1) * n1SecIn100NS;
	FILETIME ft;
	ft.dwHighDateTime = (DWORD)((t >> 32) & 0x00000000FFFFFFFF);
	ft.dwLowDateTime  = (DWORD)( t        & 0x00000000FFFFFFFF);
	FileTimeToSystemTime(&ft, pst);
}

///////////////////////////////////////////////////////////
EXTERN_C void _AAPI DaysToDate(unsigned days, TDate* date)
{
	SYSTEMTIME st;
	SecondsToSystemTime(((__u64)days)*n1DayInSec, &st);
	date->year	= st.wYear - nYear1;
	date->month	= st.wMonth;
	date->day	= st.wDay;
}

EXTERN_C void _AAPI SecondsToDate(unsigned secs, TDate* date)
{
	SYSTEMTIME st;
	SecondsToSystemTime(secs, &st);
	date->year	= st.wYear - nYear1;
	date->month	= st.wMonth;
	date->day	= st.wDay;
}

EXTERN_C unsigned _AAPI DateToDays(TDate date)
{
	return (unsigned)(ToSeconds(date.year + nYear1, date.month, date.day) / n1DayInSec);
}

EXTERN_C unsigned _AAPI DateTimeToSeconds(TDateTime* dt)
{
	SYSTEMTIME st;

	st.wYear			= dt->year;
	st.wMonth			= dt->month;
	st.wDay				= dt->day;
	st.wDayOfWeek		= dt->weekDay;
	st.wHour			= dt->hour;
	st.wMinute			= dt->minute;
	st.wSecond			= dt->second;
	st.wMilliseconds	= 0;

	return (unsigned)ToSeconds(&st);
}

EXTERN_C void _AAPI SecondsToDateTime(unsigned secs, TDateTime* dt)
{
	SYSTEMTIME st;
	SecondsToSystemTime(secs, &st);
	dt->year	= st.wYear;
	dt->month	= st.wMonth;
	dt->day		= st.wDay;
	dt->weekDay	= st.wDayOfWeek;
	dt->hour	= st.wHour;
	dt->minute	= st.wMinute;
	dt->second	= st.wSecond;
}

EXTERN_C int _AAPI DayOfWeek(int month, int day, int year)
{
	SYSTEMTIME st;
	SecondsToSystemTime(ToSeconds(year, month, day), &st);
	return st.wDayOfWeek;
}

EXTERN_C unsigned _AAPI GetCurrentSeconds(void)
{
	SYSTEMTIME	st;
	GetLocalTime(&st);
	return (unsigned)ToSeconds(&st);
}

EXTERN_C void _AAPI SetCurrentSeconds(unsigned secs)
{
	SYSTEMTIME st;
	SecondsToSystemTime(secs, &st);
	SetLocalTime(&st);
}

EXTERN_C unsigned _AAPI GetCurrentTicks(void)
{
	return GetTickCount() / 10; // 1/100 second
}
