/*	cegdi.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/28 07:59PM
	$Header: /cvsroot/jedi/wince/cegdi.cxx,v 1.12 2000/10/12 09:00:39 henrichen Exp $
	Purpose:	
	Description:	OS dependent part of gdi functions for WinCE

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/rct.h>
#include <jedi/fb.h>
#include <jedi/bmp.h>
#include <jedi/fnt.h>
#include <jedi/win.h>
#include <jedi/gdi.h>

//////////////////////////////////////////////////////////////////
static unsigned long s_Rop2[]={
	R2_COPYPEN,	//winPaint
	R2_MASKPEN,	//winErase
	R2_MASKNOTPEN,	//winMask
	R2_XORPEN,	//winInvert
	R2_MERGEPEN,	//winOverlay
	R2_NOTCOPYPEN,	//winPaintInverse
	R2_XORPEN	//winSwap
};

inline unsigned long gdiGetRop2(TDrawState *pDs)
{
	return s_Rop2[pDs->transferMode];
}

static unsigned long s_Rop3[]={
	SRCCOPY,
	SRCAND,
	0x220326,
	SRCINVERT,
	SRCPAINT,
	NOTSRCCOPY,
	SRCINVERT
};

inline unsigned long gdiGetRop3(TDrawState *pDs)
{
	return s_Rop3[pDs->transferMode];
}

static unsigned long s_PatRop3[]={
	PATCOPY,	//winPaint
	0xa000c9,	//winErase
	0x0a0329,	//winMask
	PATINVERT,	//winInvert
	0xfa0089,	//winOverlay
	0x0f0001,	//winPaintInverse
	PATINVERT	//winSwap
};

inline unsigned long gdiGetPatRop3(TDrawState *pDs)
{
	return s_PatRop3[pDs->transferMode];
}

static HBRUSH _STDCALL gdiCreatePatternBrush(TDrawState *pDs, TWin *pDrawWin)
{
	struct TDib {
		BITMAPINFOHEADER	bmh;
		RGBQUAD				colors[2];
		__u32				pattern[8];
	} dib;

	dib.bmh.biSize= sizeof(BITMAPINFOHEADER);
	dib.bmh.biWidth= 8;
	dib.bmh.biHeight= 8; 
	dib.bmh.biPlanes= 1; 
	dib.bmh.biBitCount= 1; 
	dib.bmh.biCompression= BI_RGB; 
	dib.bmh.biSizeImage= 0; 
	dib.bmh.biXPelsPerMeter= 0;
	dib.bmh.biYPelsPerMeter= 0; 
	dib.bmh.biClrUsed= 0; 
	dib.bmh.biClrImportant= 0;
	
	TPalette pal= gdiIndexToRGB(pDrawWin, pDs->foreColor);
	FbToWinRGB(&dib.colors[0], &pal, 1);
	pal= gdiIndexToRGB(pDrawWin, pDs->backColor);
	FbToWinRGB(&dib.colors[1], &pal, 1);
	
	for(int j=0; j<8; j++) {
		*((__u8*)(&dib.pattern[j]))= ((__u8*)(&pDs->patternData))[j];
	}
	return ::CreateDIBPatternBrushPt(&dib, DIB_RGB_COLORS);
}

static HBRUSH _STDCALL gdiCreateBrush(TDrawState *pDs, TWin *pDrawWin)
{
	HBRUSH hBrh=0;
	switch(pDs->pattern) {
		case DSPATTERN_BLACK:
			TPalette pal= gdiIndexToRGB(pDrawWin, pDs->foreColor);
//			TRACE("r=0x%x, g=0x%x, b=0x%x, RGB=0x%08x\n",
//				pal.r, pal.g, pal.b, RGB(pal.r,pal.g,pal.b));
			hBrh= ::CreateSolidBrush(RGB(pal.r,pal.g,pal.b));
			break;
		case DSPATTERN_WHITE:
		{
			TPalette pal= gdiIndexToRGB(pDrawWin, pDs->backColor);
			hBrh= ::CreateSolidBrush(RGB(pal.r,pal.g,pal.b));
			break;
		}
		case DSPATTERN_GRAY:
		{
			__u8 val= 0xaa;
			for(int j=0; j<8; j++) {
				((__u8*)pDs->patternData)[j]= val;
				val^= 0xff;
			}
			hBrh= gdiCreatePatternBrush(pDs, pDrawWin);
			break;
		}
		case DSPATTERN_CUSTOM:
		{
			hBrh= gdiCreatePatternBrush(pDs, pDrawWin);
			break;
		}
	}
	return hBrh;
}

static HPEN _STDCALL gdiCreatePen(TDrawState *pDs, TWin *pDrawWin)
{
	int style= PS_SOLID;
	TPalette pal={0,0,0,0};
	switch (pDs->pattern ) {
		case DSPATTERN_BLACK:
			style= PS_SOLID;
			pal= gdiIndexToRGB(pDrawWin, pDs->foreColor);
			break;
		case DSPATTERN_WHITE:
			style= PS_SOLID;
			pal= gdiIndexToRGB(pDrawWin, pDs->backColor);
			break;
		case DSPATTERN_GRAY:
		case DSPATTERN_CUSTOM:
			style= PS_DASH;
			pal= gdiIndexToRGB(pDrawWin, pDs->foreColor);
			break;
	}
	
	return CreatePen(style, 1, RGB(pal.r,pal.g,pal.b));
}

static HRGN _STDCALL gdiCreateRgn(TWin *pWin)
{
	if (!pWin) pWin= &g_winScrn;
	TRect clip;
	CopyRect(&clip, &pWin->clippingBounds);
	if (!pWin->flags.offscreen)
		WinToScreen(pWin, &clip.Left(), &clip.Top());
	return ::CreateRectRgn(clip.Left(), clip.Top(), clip.Right(), clip.Bottom());
}

//////////////////////////////////////////////////////////////////
inline HDIB gdiGetBmpHDIB(TBmp *pBmp, TBmp *pRefBmp)
{
	ASSERT(pBmp->flags.indirect);
	HDIB hDIB= *bmpGetHDIBAddr(pBmp);
	if (hDIB && !pBmp->flags.hasColorTable) {
		TBmp *pPalBmp= pRefBmp && pRefBmp->flags.hasColorTable ? pRefBmp : g_pBmpScrn;
		TPalette *pPal= bmpGetColorTableEntries(bmpGetColorTable(pPalBmp));
		fbSetPaletteEx(hDIB, pPal, 0, 1 << pBmp->pixelSize);
	}
		
	return hDIB;
}
	

static HDIB _STDCALL gdiGetWinDIB(TWin *pWin, TWin *pRefWin DEFAULTVAL(0))
{
	HDIB hDIB;
	if (pWin) {
		//Get associated HDIB in the TBmp
		hDIB= gdiGetBmpHDIB(pWin->pBitmap, pRefWin ? pRefWin->pBitmap : g_pBmpScrn);
	}
	else {
		//use the default screen bitmap
		hDIB= *bmpGetHDIBAddr(g_pBmpScrn);
	}
	return hDIB;
}

static void _STDCALL gdiRoundRect(
	TWin *pWin, int l, int t, int r, int b, int radius, 
	HPEN hPen, HBRUSH hBrh, TDrawState *pDs)
{
	HDIB hDIB= gdiGetWinDIB(pWin);
	
	if (hDIB) {
		CMemDC hdc(hDIB);
		if ((HDC)hdc) {
			HRGN hRgn= gdiCreateRgn(pWin);
			if (hRgn) {
				hPen= (HPEN) ::SelectObject(hdc, hPen);
				hBrh= (HBRUSH) ::SelectObject(hdc, hBrh);
				::SelectObject(hdc, hRgn);
				::DeleteObject(hRgn);
				TPalette pal= gdiIndexToRGB(pWin, pDs->backColor);
				::SetBkColor(hdc, RGB(pal.r,pal.g,pal.b));
				::SetROP2(hdc, gdiGetRop2(pDs));
				::RoundRect(hdc, l, t, r, b, radius<<1, radius<<1);
				::SelectObject(hdc, hBrh);
				::SelectObject(hdc, hPen);
			}
		}
	}
}

inline void gdiDrawUnderline(
	HDC hdc, int y, int x1, int x2, TDrawState *pDs, TWin *pDrawWin)
{
	TDrawState ds= *pDs;
	switch(pDs->underlineMode) {
		case DSUNDERLINE_NONE:
			return;
		case DSUNDERLINE_GRAY:
			ds.pattern= DSPATTERN_GRAY;
			break;
		default:
			ds.pattern= DSPATTERN_BLACK;
			break;
	}
	HBRUSH hBrh= gdiCreateBrush(&ds, pDrawWin);
	if (hBrh) {
		hBrh= (HBRUSH) ::SelectObject(hdc, hBrh);
		::PatBlt(hdc, x1, y, x2-x1, 1, gdiGetPatRop3(&ds));
		hBrh= (HBRUSH) ::SelectObject(hdc, hBrh);
		::DeleteObject(hBrh);
	}
}	

//////////////////////////////////////////////////////////////////
EXTERN_C __u32 _JAPI gdiGetPixel(TWin *pWin, int x, int y)
{
	HDIB hDIB= gdiGetWinDIB(pWin);

	TPalette rgb= {0,0,0,0};
	if (hDIB) {
		CMemDC hdc(hDIB);
		if ((HDC)hdc) {
			COLORREF cr= GetPixel(hdc, x, y);
			rgb.r= GetRValue(cr);
			rgb.g= GetGValue(cr);
			rgb.b= GetBValue(cr);
		}
	}
	
	return gdiRGBToIndex(pWin, rgb);
}

EXTERN_C void _JAPI gdiSetPixel(TWin *pWin, int x, int y, TDrawState *pDs)
{
	gdiLine(pWin, x, y, x+1, y, pDs);
}

EXTERN_C void _JAPI gdiLine(TWin *pWin, int x1, int y1, int x2, int y2, TDrawState *pDs)
{
	if (x1==x2 && y1==y2) return;
	
	HDIB hDIB= gdiGetWinDIB(pWin);
	bool bUpdate= false;
	
	if (hDIB) {
		CMemDC hdc(hDIB);
		
		if ((HDC)hdc) {
			if (!pDs) pDs= winGetDrawState();
			if (pDs->pattern == DSPATTERN_GRAY || 
				pDs->pattern == DSPATTERN_CUSTOM) {
				TPalette pal= gdiIndexToRGB(pWin, pDs->backColor);
				::SetBkColor(hdc, RGB(pal.r,pal.g,pal.b));
			}

			HPEN hPen= gdiCreatePen(pDs, pWin);
			HRGN hRgn= gdiCreateRgn(pWin);
			if (hPen && hRgn) {
				hPen= (HPEN) ::SelectObject(hdc, hPen);
				::SelectObject(hdc, hRgn);
				::DeleteObject(hRgn);
				::SetROP2(hdc, gdiGetRop2(pDs));
				POINT pts[]={{x1,y1},{x2,y2}};
				::Polyline(hdc, pts, 2);
				hPen= (HPEN) ::SelectObject(hdc, hPen);
				::DeleteObject(hPen);
				bUpdate= true;				
			}
		}
	}
	// fbUpdate() will bind hDIB again, so we must release it before call it.
	if (!pWin->flags.offscreen && bUpdate) {
		if (x1 > x2) Swap(x1, x2);
		if (y1 > y2) Swap(y1, y2);
		TRect rect={{x1,y1},{x2-x1+1, y2-y1+1}};
		fbUpdate(&rect);
	}
}

EXTERN_C void _JAPI gdiOutlineRect(
	TWin *pWin, TRect *pRect, int radius, TDrawState *pDs)
{
	if (!pDs) pDs= winGetDrawState();
	HPEN hPen= gdiCreatePen(pDs, pWin);
	HBRUSH hBrh= (HBRUSH) ::GetStockObject(NULL_BRUSH);
	if (hPen) {
		gdiRoundRect(pWin, pRect->Left(), pRect->Top(), 
			pRect->Right(), pRect->Bottom(), radius, hPen, hBrh, pDs);
		DeleteObject(hPen);
		if (!pWin->flags.offscreen)	fbUpdate(pRect);
	}
}

EXTERN_C void _JAPI gdiFillRect(
	TWin *pWin, TRect *pRect, int radius, TDrawState *pDs)
{
	if (!pDs) pDs= winGetDrawState();
	HPEN hPen= (HPEN) ::GetStockObject(NULL_PEN);
	HBRUSH hBrh= gdiCreateBrush(pDs, pWin);
	if (hBrh) {
		gdiRoundRect(pWin, pRect->Left(), pRect->Top(), 
			pRect->Right()+1, pRect->Bottom()+1, radius, hPen, hBrh, pDs);
		::DeleteObject(hBrh);
		if (!pWin->flags.offscreen)	fbUpdate(pRect);
	}
}

EXTERN_C void _JAPI gdiBitBlt(
	TWin *pDstWin, int dstX, int dstY, 
	TWin *pSrcWin, const TRect *pRect, TDrawState *pDs)
{
	HDIB hDstDIB= gdiGetWinDIB(pDstWin);
	HDIB hSrcDIB= gdiGetWinDIB(pSrcWin, pDstWin);
	bool bUpdate= false;
	if (hDstDIB && hSrcDIB) {
		CMemDC hDstDC(hDstDIB);
		CMemDC &hSrcDC= (hDstDIB == hSrcDIB) ? hDstDC : *_NEW(CMemDC(hSrcDIB));
			// one HBITMAP cannot be selected into two memory DC simultaneously
		if ((HDC)hDstDC && (HDC)hSrcDC) {
			HRGN hRgn= gdiCreateRgn(pDstWin);
			if (!pDs) pDs= winGetDrawState();
			if (hRgn) {
				::SelectObject(hDstDC, hRgn);
				::DeleteObject(hRgn);
				if (!pSrcWin) pSrcWin= &g_winScrn;
				TBmp *pSrcBmp= pSrcWin->pBitmap;
				if (pSrcBmp->flags.hasTransparency) {
					HBITMAP hMskDDB= ::CreateBitmap(pRect->Width(), pRect->Height(), 1, 1, NULL);
					if (hMskDDB) {
						CMemDC hMskDC(hMskDDB);
						if ((HDC)hMskDC) {
							TPalette pal= gdiIndexToRGB(pSrcWin, pSrcBmp->transparentIndex);
							COLORREF old=::SetBkColor(hSrcDC, RGB(pal.r,pal.g,pal.b));
							::BitBlt(hMskDC, 0, 0, pRect->Width(), pRect->Height(), hSrcDC, pRect->Left(), pRect->Top(), SRCCOPY);
							::SetBkColor(hSrcDC, old);
							::MaskBlt(hDstDC, dstX, dstY, pRect->Width(), pRect->Height(),
								hSrcDC, pRect->Left(), pRect->Top(), 
								hMskDDB, 0, 0, MAKEROP4(0x00aa0029, gdiGetRop3(pDs)));
						}
					}
				}
//?? 20000801, Henri Chen: The following is the easier way to implement transparency
//	However, experiment on the PocketPC emulator show an incorrect result. Where
//	transparency should occure are all blacks.
/*				if (pSrcBmp->flags.hasTransparency) {
					TPalette pal= gdiIndexToRGB(pSrcWin, pSrcBmp->transparentIndex);
					::TransparentImage(hDstDC, dstX, dstY, pRect->Width(), pRect->Height(),
						hSrcDIB, pRect->Left(), pRect->Top(), pRect->Width(), pRect->Height(), RGB(pal.r,pal.g,pal.b));

				}
*/				else 
					::BitBlt(hDstDC, dstX, dstY, pRect->Width(), pRect->Height(), 
						hSrcDC, pRect->Left(), pRect->Top(), gdiGetRop3(pDs));

				bUpdate= true;				
			}
		}
		if (hDstDC != hSrcDC)
			_DEL(&hSrcDC);
	}
	// fbUpdate() will bind hDIB again, so we must release it before call it.
	if (!pDstWin->flags.offscreen && bUpdate) {
		TRect rect={{dstX, dstY},{pRect->Width(), pRect->Height()}};
		fbUpdate(&rect);
	}
}

//?? 20000828, Henri Chen: hFont should change to refer to fontID.
EXTERN_C void _JAPI gdiDrawChars(
	TWin *pWin, const char *chars, int len, int x, int y, TDrawState *pDs)
{
	HDIB hDIB= gdiGetWinDIB(pWin);
	
	SIZE sz;
	bool bUpdate= false;
	if (hDIB) {
		CMemDC hdc(hDIB);
		
		if ((HDC)hdc) {
			if (!pDs) pDs= winGetDrawState();
			TPalette pal= gdiIndexToRGB(pWin, pDs->textColor);
			::SetTextColor(hdc, RGB(pal.r,pal.g,pal.b));
			pal= gdiIndexToRGB(pWin, pDs->backColor);
			::SetBkColor(hdc, RGB(pal.r,pal.g,pal.b));

			HRGN hRgn= gdiCreateRgn(pWin);
			if (!pDs->pFont) pDs->pFont= fntGetTFont(pDs->fontId);
			HFONT hFont= pDs->pFont->hCeFont;
			if (hFont && hRgn) {
				::SelectObject(hdc, hRgn);
				::DeleteObject(hRgn);
				hFont= (HFONT) ::SelectObject(hdc, hFont);
				::SetROP2(hdc, gdiGetRop2(pDs));
				TCHAR *wc= (TCHAR*) alloca(len * sizeof(TCHAR));
				len= MbsToWcs(chars, len, wc, len);
				if (len) {
					if (::GetTextExtentPoint32(hdc, wc, len, &sz)) {
						RECT rect={x,y,x+sz.cx,y+sz.cy};
						::DrawText(hdc, wc, len, &rect, DT_LEFT|DT_NOPREFIX|DT_SINGLELINE|DT_TOP);
						gdiDrawUnderline(hdc, rect.bottom, rect.left, rect.right, pDs, pWin);

						bUpdate= true;
					}
				}
				hFont= (HFONT) ::SelectObject(hdc, hFont);
			}
		}
	}
	// fbUpdate() will bind hDIB again, so we must release it before call it.
	if (!pWin->flags.offscreen && bUpdate) {
		TRect r={{(__s16)x,(__s16)y},{(__s16)sz.cx, (__s16)sz.cy}};
		fbUpdate(&r);
	}
}	

