/*	cefnt.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:	Tom M. Yeh
	Create Date:	2000/8/28 09:45PM
	$Header: /cvsroot/jedi/wince/cefnt.cxx,v 1.10 2000/10/12 01:50:46 henrichen Exp $
	Purpose:	
	Description:	Implementation dependent part of fntXXX() for WinCE

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/fnt.h>

//?? 20000914, Henri Chen: now support only one font.
static TFont s_stdFont;
EXTERN_C void _JAPI fntOsSysInit(void)
{
	//Note the other fields of TFont are inited by fntInit
	s_stdFont.hCeFont= (HFONT)::GetStockObject(SYSTEM_FONT);
	
	g_pSysFonts[FONT_STD]= &s_stdFont;
	g_pSysFonts[FONT_BOLD]= &s_stdFont;
	g_pSysFonts[FONT_LARGE]= &s_stdFont;

	TRect rect;
	fntGetExtent(FONT_STD, "abc", &rect);
	s_stdFont.height= rect.Height();
}

EXTERN_C void _JAPI fntOsSysCleanup(void)
{
}

EXTERN_C void _JAPI fntGetExtent(__s16 fontId, const char *str, TRect *pRect)
{
	TFont *pFont= fntGetTFont(fontId);
	ASSERT(pFont);
	if (!str || strlen(str) == 0) {
		memset(pRect, 0, sizeof(TRect));
		return;
	}
	
	HDC hdc= GetDC(0);
	HFONT hfont= (HFONT) ::SelectObject(hdc, pFont->hCeFont);
	SIZE size;
	TCHAR *tstr= A2T(str);
	::GetTextExtentPoint(GetDC(0), tstr, _tcsclen(tstr), &size);
	::SelectObject(hdc, hfont);
	ReleaseDC(0, hdc);
//	pRect->Left()= pRect->Top()= 0;
	pRect->Width()= (__s16) size.cx;
	pRect->Height()= (__s16) size.cy;
}

EXTERN_C int _JAPI fntGetCharWidth(__s16 fontId, const char ch)
{
	char str[2]; str[0]= ch; str[1]= '\0';
	TRect rect;
	fntGetExtent(fontId, str, &rect);
	return rect.Width();
}
