/*	cefile.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/23 05:33PM
	$Header: /cvsroot/jedi/wince/cefile.cxx,v 1.5 2000/10/04 04:07:26 henrichen Exp $
	Purpose:	
	Description:	Porting layer of jedi's file system for WinCE

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/file.h>

//////////////////////////////////////////////////////////////////
// file porting layer
EXTERN_C unsigned int _JAPI jdbReadFile(_hfile_t h, void* data, size_t size)
{
	DWORD n= 0;
	::ReadFile(h, data, size, &n, NULL);
	return n;
}

EXTERN_C unsigned int _JAPI jdbWriteFile(_hfile_t h, const void* data, size_t size)
{
	DWORD n= 0;
	::WriteFile(h, data, size, &n, NULL);
	return n;
}

#define	CEATTRFLAGS (FILE_ATTRIBUTE_NORMAL|FILE_FLAG_WRITE_THROUGH|FILE_FLAG_RANDOM_ACCESS)
EXTERN_C _hfile_t _JAPI jdbOpenFile(const char *filename, int mode)
{
	DWORD access= 0;
	if ((mode & MODE_READONLY) != 0) access|= GENERIC_READ;
	if ((mode & MODE_WRITE) !=0) access|= GENERIC_WRITE;
	
	DWORD share= 0;
	if ((mode & MODE_EXCLUSIVE) == 0) {
		if ((mode & MODE_READONLY) != 0) share|= FILE_SHARE_READ;
//		if ((mode & MODE_WRITE) !=0) share|= FILE_SHARE_WRITE;
	}

	return ::CreateFile(_A2T(filename), access, share, 0, 
		mode & MODE_CREATE ? CREATE_NEW : OPEN_EXISTING, CEATTRFLAGS, 0);
}

EXTERN_C _hfind_t _JAPI jdbFindFirstFile(const char *name, TFindData *fd)
{
	WIN32_FIND_DATA wfd;

	_hfind_t hfind= ::FindFirstFile(_A2T(name), &wfd);
	if (hfind != INVALID_HANDLE_VALUE) {
		fd->attributes= wfd.dwFileAttributes;
		strcpy(fd->filename, T2A(wfd.cFileName));
	}
	return hfind;
}

EXTERN_C BOOL _JAPI jdbFindNextFile(_hfind_t hfind, TFindData *fd)
{
	ASSERT(	hfind != INVALID_HANDLE_VALUE);

	WIN32_FIND_DATA wfd;
	BOOL ret=::FindNextFile(hfind, &wfd);
	fd->attributes= wfd.dwFileAttributes;
	strcpy(fd->filename, T2A(wfd.cFileName));
	return ret;
}

