/*	cefb.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/13/0 09:13PM
	$Header: /cvsroot/jedi/wince/cefb.cxx,v 1.15 2000/10/12 03:07:30 tomyeh Exp $
	Purpose:	Frame buffer of Win/CE
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <malloc.h>
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/fb.h>
#include <jedi/swab.h>
#include "palmce.h"
#include "view.h"

#define MENU_HEIGHT		26

/////////////////////////////////////////////////////////////////
class CFb {
public:
	inline HDIB Config(const TPalette palettes[]);
	inline void Cleanup() {DeleteObject(m_hDIB);}

	inline void Update(const TRect* rect);
	inline void Draw(CDC& dc, const CRect* pRect);

	inline __u8* Bits() const {return (__u8*)SCREEN_BASEADDR;}
	inline __u8** BitsAddr() {return (__u8**)&SCREEN_BASEADDR;}
	inline int Width() const {return SCREEN_WIDTH;}
	inline int Height() const {return SCREEN_HEIGHT;}
	inline int Bpp() const {return SCREEN_BPP;}

	//data member
	HDIB	m_hDIB;
	CMutex	m_csDraw;
};

static CFb s_fb;

/////////////////////////////////////////////////////////////////
inline HDIB CFb::Config(const TPalette palettes[])
{
	ASSERT(!m_hDIB); //reentry not allowed

	ASSERT(Bpp()>8 || palettes);

	m_hDIB = fbCreateDIB(Width(), Height(), Bpp(), palettes, (void**)BitsAddr());
	if(!m_hDIB){
		ErrorBox(IDP_CREATEDIB_FAIL);
		return 0;
	}

	TRACE("frame buffer: %p\n", Bits());
	return m_hDIB;
}

void CFb::Draw(CDC& dc, const CRect* pRect)
{
	m_csDraw.Lock();
	if(dc.m_hDC){
		CMemDC dcMem(m_hDIB, dc);
	
		CRect rc;
		if(!pRect){
			rc.left = rc.top = 0;
			rc.right = Width(); rc.bottom = Height();
			pRect = &rc;
		}

		BitBlt(dc,
			pRect->left, pRect->top, pRect->Width(), pRect->Height(),
			dcMem, pRect->left, pRect->top, SRCCOPY);
	}
	m_csDraw.Unlock();
}

inline void CFb::Update(const TRect* ptrc)
{
	CRect rc;
	if(ptrc){
		rc.left = ptrc->Left();
		rc.top = ptrc->Top();
		rc.right = ptrc->Right();
		rc.bottom = ptrc->Bottom();
	}else{
		rc.left = rc.top = 0;
		rc.right = Width(); rc.bottom = Height();
	}

	CDC dc(&g_view);
	Draw(dc, &rc);
}

/////////////////////////////////////////////////////////////////
int g_scrnWidth, g_scrnHeight, g_scrnBpp;
unsigned g_scrnBase;

EXTERN_C void _STDCALL fbInit(void)
{
	SIPINFO si;
	memset(&si, 0, sizeof(SIPINFO));		
	si.cbSize = sizeof (si);
	if(SHSipInfo(SPI_GETSIPINFO, 0, &si, 0)){
		if(si.fdwFlags & SIPF_ON){//turn off SIP at the beginning
			si.fdwFlags &= ~SIPF_ON;
			SHSipInfo(SPI_SETSIPINFO, 0, &si, 0); //turn off SIP
			SHSipInfo(SPI_GETSIPINFO, 0, &si, 0); //reget information
		}
		g_scrnWidth = si.rcVisibleDesktop.right - si.rcVisibleDesktop.left;
		g_scrnHeight = si.rcVisibleDesktop.bottom - si.rcVisibleDesktop.top - MENU_HEIGHT;
			//Note: if SIP visible, we don't need to substract MENU_HEIGHT
			//If SIP invisible, we have to.
	}else
		TRACE("Warning: Can't get the SIP Info.");

	HDC hDC = GetDC(0);
	g_scrnBpp = GetDeviceCaps(hDC, BITSPIXEL);
	if(g_scrnBpp>8) g_scrnBpp = 8;
		//Since Palm API does not support more than 8bpp
	ReleaseDC(0, hDC);

	TRACE("Screen %d x %d x %d\n", SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);
}

HDIB _STDCALL fbCreateDIB(int wd, int hgh, int bpp, const TPalette pals[], void** ppBits)
{
	//Set up BITMAPINFO
	struct BITMAPINFOEX {
		BITMAPINFO	bmi;
		RGBQUAD		colors[256-1];
	} bmi;

	memset(&bmi.bmi.bmiHeader, 0, sizeof(bmi.bmi.bmiHeader));
    bmi.bmi.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
    bmi.bmi.bmiHeader.biWidth		= wd;
    bmi.bmi.bmiHeader.biHeight		= -hgh;
    bmi.bmi.bmiHeader.biPlanes		= 1;
    bmi.bmi.bmiHeader.biBitCount	= (__u16)bpp;
    bmi.bmi.bmiHeader.biCompression	= BI_RGB;
	if(bpp <= 8){
		int nColors = 1 << bpp;

		FbToWinRGB(bmi.bmi.bmiColors, pals, nColors);
	}

	HDC hDC = GetDC(0);
	HDIB hdib = CreateDIBSection(hDC, &bmi.bmi, DIB_RGB_COLORS, ppBits, 0, 0);
	ReleaseDC(0, hDC);
	return hdib;
}

EXTERN_C HDIB _JAPI fbConfig(const TPalette palettes[])
{
	return s_fb.Config(palettes);
}

EXTERN_C void _JAPI fbCleanup()
{
	s_fb.Cleanup();
}

EXTERN_C void _JAPI fbUpdate(const TRect* rect)
{
	s_fb.Update(rect);
}

EXTERN_C void _JAPI fbDraw(CDC& dc, const CRect* rect)
{
	s_fb.Draw(dc, rect);
}

#ifdef __LITTLE_ENDIAN__
EXTERN_C void _STDCALL FbToWinRGB(RGBQUAD rgb[], const TPalette pal[], int n)
{
	while(--n >=0)
		(__u32&)(rgb[n]) = __be32_to_cpu((const __u32&)(pal[n]));
}
#endif

EXTERN_C bool _STDCALL fbSetPaletteEx(HDIB hDIB, const TPalette palettes[], 
#if CAN_SETDIBCOLORTABLE
	int index, int nColors)
#else
	int,int)
#endif
{
	if(!hDIB)
		hDIB = s_fb.m_hDIB;

	CMemDC dcMem(hDIB);
	const int nTotal = GetDeviceCaps(dcMem, NUMCOLORS);
	if(nTotal <= 0){
		TRACE("SetPalette ignored for a nonpalette device\n");
		return false;
	}

	//update nColors
#if CAN_SETDIBCOLORTABLE
	ASSERT(index>=0 && index<nTotal);

	if(nColors == -1) nColors = nTotal - index;
	else if(nColors > nTotal - index) nColors = nTotal - index;

#ifdef __LITTLE_ENDIAN__
	RGBQUAD* rgbs = (RGBQUAD*)_alloca(sizeof(RGBQUAD)*nColors);
	FbToWinRGB(rgbs, palettes+index, nColors);
#else
	RGBQUAD* rgbs = (RGBQUAD*)(palettes+index);
#endif

	if(!SetDIBColorTable(dcMem, index, nColors, rgbs)){
		TRACE("SetDIBColorTable failed\n");
		return false;
	}

#else //CAN_SETDIBCOLORTABLE
	LOGPALETTE* pal = (LOGPALETTE*)_MALLOC(sizeof(LOGPALETTE)+sizeof(PALETTEENTRY)*nTotal);
	if(!pal)
		return false;

	pal->palVersion = 0x300;
	pal->palNumEntries = (WORD)nTotal;
	for(int j=nTotal; --j>=0;){
		pal->palPalEntry[j].peRed	= palettes[j].r;
		pal->palPalEntry[j].peGreen	= palettes[j].g;
		pal->palPalEntry[j].peBlue	= palettes[j].b;
		pal->palPalEntry[j].peFlags	= 0;
	}

	HPALETTE hPal = ::CreatePalette(pal);
	_FREE(pal);

	if(!hPal){
		TRACE("CreatePalette failed\n");
		return false;
	}

	::DeleteObject(::SelectPalette(dcMem, hPal, FALSE));
#endif

	g_view.InvalidateRect(0, false);
	return true;
}
