/*	cecond.cxx

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	8/2/0 02:25PM
$Header: /cvsroot/jedi/wince/cecond.cxx,v 1.3 2000/09/26 10:09:27 tomyeh Exp $
Purpose:	_cond_t
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/thread.h>

#define _COND_SIGNAL_	0x80000000
	//a trick: initial nWait to a non-zero so it won't be decreased
	//to zero so ResetEvent won't be called

EXTERN_C void _JAPI mtInitCond(_cond_t* cond, _mutex_t* pMutex, bool bBroadcast)
{
	ASSERT(cond);
	cond->pMutex = pMutex;
	cond->nWait = bBroadcast ? 0: _COND_SIGNAL_;
	cond->event = CreateEvent(0, bBroadcast, false, 0);
	ASSERT(cond->event && cond->pMutex);
}

extern CMutex g_sysMutex;

EXTERN_C bool _AAPI mtWaitCond(_cond_t* cond, unsigned toTicks)
{
	if(!cond)
		return false;

	++cond->nWait;

	mtUnlockMutex(cond->pMutex);

	if(cond->pMutex != g_sysMutex.Mutex())
		AnakinUnlock(); //let other threads able to access Jedi

	bool bOk = WAIT_OBJECT_0 ==
				WaitForSingleObject(cond->event,
					toTicks==TO_INFINITE ? INFINITE: toTicks*10);

	if(cond->pMutex != g_sysMutex.Mutex())
		AnakinLock();

	mtLockMutex(cond->pMutex);

	if(!--cond->nWait)
		ResetEvent(cond->event); //the last one close the door
	return bOk;
}
