/*	menu.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/21/0 09:57PM
	$Header: /cvsroot/jedi/ui/menu.cxx,v 1.17 2000/10/03 06:16:13 henrichen Exp $
	Purpose:	Menu Functions
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/event.h>
#include <jedi/menu.h>
#include <jedi/form.h>
#include <lib/lcllink.h>
#include <jedi/win.h>
#include <jedi/gdi.h>
#include <jedi/fnt.h>

//////////////////////////////////////////////////////////
DECL_APPLINK(TMenubarEx, TMenubar, pMenubarExList)

TMenubar* g_mnuActive;
static bool s_bAutoDelActive;

//////////////////////////////////////////////////////////
EXTERN_C bool _AAPI mnuHandleEvent(
	TMenubar * /*menu*/, TEvent *event, __u16 *err)
{
	if(err) *err = 0;

	switch(event->eType){
	case EVT_KEYDOWN:
		switch(event->data.keyDown.chr){
		case CC_MENU:
			mnuPopup(0);
			return true;

		case CC_COMMAND:
			mnuCmdbarPopup();			
			return true;
		}
		break;

	case EVT_FRMTITLESELECT:
		evtPushKeyEx(CC_MENU);
		break;
	}

	return false;
}

//////////////////////////////////////////////////////////
EXTERN_C TMenubar* _JAPI mnuSetActive(TMenubar* p)
{
	TMenubar* old = 0;
	if(p != g_mnuActive){
		if(!s_bAutoDelActive)
			old = g_mnuActive;

		mnuDeleteActiveCache();
		g_mnuActive = p;
		s_bAutoDelActive = false;
	}
	return old;
}

EXTERN_C void _AAPI mnuSetActiveRes(__u16 resId)
{
	frmSetMenu(g_pFrmActive, resId);
}

EXTERN_C void _JAPI mnuDeleteActiveCache(void)
{
	if(g_mnuActive){
		mnuDismiss();

		if(s_bAutoDelActive)
			mnuDestroy(g_mnuActive);

		g_mnuActive = 0;
	}
}

EXTERN_C void _JAPI mnuInitActiveCache(void)
{
	if(!g_mnuActive){
		TForm* frm = g_pFrmActive;
		if(frm && frm->resIdMenu){
			 g_mnuActive = mnuCreate(frm->resIdMenu);
			 s_bAutoDelActive = true;

			TEvent evt;
			evtInitEvent(&evt);
			evt.eType = EVT_MENUOPEN;
			evt.data.menuOpen.menuRscID = frm->resIdMenu;
			evt.data.menuOpen.cause = MENU_BUTTON_CAUSE;
			evtPushEvent(&evt);
		}
	}
}

//////////////////////////////////////////////////////////
static void _JAPI mnuDrawItem(TWin *pWin, TMenuItem *p, TRect *bounds, TDrawState *pDs)
{
	if (p->hidden) return;
	
	//if a seperator line
	if (strlen(p->itemStr) == 1 && p->itemStr[0] == MENU_SEPARATOR_CHAR) {
		TDrawState ds= *pDs;
		ds.pattern= DSPATTERN_GRAY;
		gdiLine(pWin, bounds->Left(), bounds->Top()+MENU_SEPARATOR_YOFS, 
			bounds->Right(), bounds->Top()+MENU_SEPARATOR_YOFS, &ds);
		bounds->Top()= (__s16)(bounds->Top() + MENU_SEPARATOR_YOFS * 2 + 1);
	}
	else  {
#if defined(__rtems__)
#warning "Why am I doing alloca()?"
	void *alloca(int);
#endif
		//normal case
		gdiFillRect(pWin, bounds, 0, pDs);
		
		//findout the shortcut char and draw it
		char *str = (char*)alloca(strlen(p->itemStr)+1);
		char *shortcut= strchr(str, '\t');
		if (shortcut) {
			*shortcut= '\0';
			shortcut++;
			*(shortcut+1)= '\0';
		}
		gdiDrawChars(pWin, str, strlen(p->itemStr), 
			bounds->Left()+SUBMENU_XOFS, bounds->Top()+SUBMENU_YOFS, pDs);
		if (shortcut) {
			//?? 20000915, The '/' mark shoud be replaced with real stroke font
			gdiDrawChars(pWin, "/", 1, 
				bounds->Right()-SUBMENU_XOFS-20, bounds->Top()+SUBMENU_YOFS, pDs);
			gdiDrawChars(pWin, shortcut, 1, 
				bounds->Right()-SUBMENU_XOFS-10, bounds->Top()+SUBMENU_YOFS, pDs);
		}
		bounds->Top()= (__s16)(bounds->Top() + bounds->Height());
	}

}

inline void _JAPI mnuDrawPullDown(TWin *pWinBar, TMenuPullDown *p, int curItem)
{
	if (p->hidden) return;
	
	//save the bit behind the pulldown window
	{
		__u16 err;
		p->bitsBehind= winSaveBits(&p->bounds, &err);
	}

	//invert the bar title
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_WHITE;
	TPalette palText= {0, 0xff, 0xff, 0xff};
	TPalette palBack= {0, 0x00, 0x00, 0x00};
	ds.textColor= (__u8) gdiRGBToIndex(pWinBar, palText);
	ds.backColor= (__u8) gdiRGBToIndex(pWinBar, palBack);
	ds.foreColor= ds.textColor;
	ds.underlineMode= DSUNDERLINE_NONE;
	ds.fontId= FONT_TITLE;
	ds.pFont= NULL;
	gdiDrawCenterText(pWinBar, p->title, &p->titleBounds, 0, &ds);

	Swap(ds.textColor, ds.backColor);
	ds.foreColor= ds.textColor;

	//draw the pulldown menu
	winDrawFrame(p->menuWin->frameType, &p->menuWin->bounds, &ds);
	
	TRect r;
	fntGetExtent(FONT_TITLE, "A", &r);	//we need the height only
	r.Width()=	p->menuWin->bounds.Width();
	r.Left()=	p->menuWin->bounds.Left();
	r.Top()=	p->menuWin->bounds.Top();
	for(int i=0; i < p->numItems; i++) {
		if (i == curItem) {
			Swap(ds.textColor, ds.backColor);
			ds.foreColor= ds.textColor;
		}
		mnuDrawItem(p->menuWin, &p->items[i], &r, &ds);
		if (i == curItem) {
			Swap(ds.textColor, ds.backColor);
			ds.foreColor= ds.textColor;
		}
	}
}

static void _JAPI mnuDrawPullDownTitle(TWin *pWinBar, TMenuPullDown *p, TDrawState *pDs)
{
	if (!p->hidden)
		gdiDrawCenterText(pWinBar, p->title, &p->titleBounds, 0, pDs);
}

inline void _AAPI mnuDraw(TMenubar* p)
{
	if(!p) return;

	p->attr.visible = 1; //denote it is drawn
	p->savedActiveWin= g_pWinActive;
	
	//save the bit behind the bar
	{
		__u16 err;
		p->bitsBehind= winSaveBits(&p->barWin->bounds, &err);
	}

	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_WHITE;
	TPalette palBack= {0, 0xff, 0xff, 0xff};
	TPalette palText= {0, 0x00, 0x00, 0x00};
	ds.textColor= (__u8) gdiRGBToIndex(p->barWin, palText);
	ds.backColor= (__u8) gdiRGBToIndex(p->barWin, palBack);
	ds.foreColor= ds.textColor;
	ds.underlineMode= DSUNDERLINE_NONE;
	ds.fontId= FONT_TITLE;
	ds.pFont= NULL;

	//draw the bar
	winDrawFrame(p->barWin->frameType, &p->barWin->bounds, &ds);

	//draw the bar title
	for(int i= 0; i < p->numMenus; i++)
		mnuDrawPullDownTitle(p->barWin, &p->menus[i], &ds);
		
	//draw the pulldown
	if (p->curMenu >= 0 && p->curMenu < p->numMenus) 
		mnuDrawPullDown(p->barWin, &p->menus[p->curMenu], p->curItem);
}

EXTERN_C void _AAPI mnuPopup(TMenubar* menu)
{
	mnuCmdbarDismiss();
	mnuInitActiveCache();
	mnuDraw(menu);
}

inline void _JAPI mnuErase(TMenubar* p)
{
	if (!p) return;
	
	if (p->bitsBehind)
		winRestoreBits(p->bitsBehind, p->barWin->bounds.Left(), p->barWin->bounds.Top());

	if (p->curMenu >= 0 && p->curMenu < p->numMenus) {
		TMenuPullDown *pp= &p->menus[p->curMenu];
		if (pp->bitsBehind)
			winRestoreBits(pp->bitsBehind, pp->bounds.Left(), pp->bounds.Top());
	}
}

EXTERN_C void _JAPI mnuDismiss(void)
{
	mnuErase(g_mnuActive);
}

//////////////////////////////////////////////////////////
EXTERN_C _err_t _AAPI mnuAddPullDown(__u16 index, const char* text)
{
	TMenubar* menu = mnuGetActive();
	if(!text || !menu)
		return ERRM_NOMENU;

	if(index > menu->numMenus)
		index = menu->numMenus;

	TMenuPullDown* p;
	if(menu->menus){
		p = (TMenuPullDown*)_REALLOC(menu->menus, sizeof(TMenuPullDown)*(menu->numMenus+1));
		if(!p)
			return ERRM_OUTOFMEMORY;

		menu->menus = p;
		p = menu->menus + index;
		if(menu->numMenus > index)
			memmove(p+1, p, sizeof(TMenuPullDown)*(menu->numMenus - index));
	}else{
		p = menu->menus = _MALLOC_T(TMenuPullDown);
		if(!p)
			return ERRM_OUTOFMEMORY;
	}

	++menu->numMenus;
	memset(p, 0, sizeof(TMenuPullDown));
	p->title = STRDUP(text);
	return 0;
}

static TMenuItem* _STDCALL FindItem(TMenubar* menu, __u16 id, TMenuPullDown** ppm=0)
{
	TMenuPullDown *p=menu->menus;
	for(int j=menu->numMenus; --j>=0; ++p){
		TMenuItem *q=p->items;
		for(int k=p->numItems; --k>=0; ++q)
			if(q->id == id){
				if(ppm)
					*ppm = p;
				return q;
			}
	}
	return 0;
}

EXTERN_C _err_t _AAPI mnuAddItem(__u16 idAfter, __u16 id, char shortcut, const char* text)
{
	TMenubar* menu = mnuGetActive();
	if(!text || !menu)
		return ERRM_NOMENU;

	//search for idAfter
	#define ALLOC_ITEM_NO	4 //must be 2^n
	TMenuPullDown *mpd;
	TMenuItem *item=FindItem(menu, idAfter, &mpd);
	if(item){
		int index = ++item - mpd->items; //insert after
		if(!(mpd->numItems & (ALLOC_ITEM_NO-1))){ //no room?
			TMenuItem *p = (TMenuItem*)_REALLOC(
				mpd->items, sizeof(TMenuItem)*(mpd->numItems+ALLOC_ITEM_NO));
			if(!p)
				return ERRM_OUTOFMEMORY;

			mpd->items = p;
			item = p + index; //items might be moved
		}

		if(mpd->numItems > index)
			memmove(item+1, item, sizeof(TMenuItem)*(mpd->numItems-index));
	}else{
		//search for the first empty menu
		for(int j=0;; ++j)
			if(j==menu->numMenus){
				return ERRM_NOTFOUND;
			}else if(!menu->menus[j].items){
				mpd = &menu->menus[j];
				break;
			}

		item = mpd->items =
			(TMenuItem*)_MALLOC(sizeof(TMenuItem) * ALLOC_ITEM_NO);
		if(!item)
			return ERRM_OUTOFMEMORY;
	}

	++mpd->numItems;
	item->id		= id;
	item->command	= shortcut;
	item->hidden	= 0;
	item->reserved	= 0;
	item->itemStr	= STRDUP(text);

	return 0;
}

EXTERN_C bool _AAPI mnuHideItem(__u16 id)
{
	TMenubar* menu = mnuGetActive();
	if(menu){
		TMenuItem* item = FindItem(menu, id);
		if(item){
			item->hidden = 1;
			return true;
		}
	}
	return false;
}

EXTERN_C bool _AAPI mnuShowItem(__u16 id)
{
	TMenubar* menu = mnuGetActive();
	if(menu){
		TMenuItem* item = FindItem(menu, id);
		if(item){
			item->hidden = 0;
			return true;
		}
	}
	return false;
}

//////////////////////////////////////////////////////////
EXTERN_C TMenubar* _AAPI mnuCreate(__u16 resId)
{
	TMenubarEx* p = _CALLOC_T(TMenubarEx);
	if(p){
		p->Link();
	}
	return ToTMenubar(p);
}

static void DestroyMenubar(TMenubar* menu, TAppLocal* app)
{
	if(!menu) return;

	if(menu == g_mnuActive){
		mnuDismiss();
		g_mnuActive = 0;
	}

	//deallocate space
	TMenuPullDown *p = menu->menus;
	for(int j=menu->numMenus; --j>=0; ++p){
		TMenuItem *q = p->items;
		for(int k=p->numItems; --k>=0; ++q)
			_FREE(q->itemStr);

		_FREE(p->items);
		_FREE(p->title);
	}
	_FREE(menu->menus);

	TMenubarEx* menuEx = ToTMenubarEx(menu);
	menuEx->Unlink(app);
	_FREE(menuEx);
}

EXTERN_C void _AAPI mnuDestroy(TMenubar* menu)
{
	DestroyMenubar(menu, 0);
}

EXTERN_C void _JAPI mnuAppCleanup(TAppLocal* app)
{
#ifndef NDEBUG
	TMenubarEx::Dump("Menubar Leakage");
#endif

	TMenubarEx::Apply(DestroyMenubar, app);
}
