/*	label.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/15/0 04:56PM
	$Header: /cvsroot/jedi/ui/label.cxx,v 1.3 2000/10/03 06:16:13 henrichen Exp $
	Purpose:	Label Functions (FOBJ_LABEL)
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/rct.h>
#include <jedi/form.h>
#include <jedi/win.h>
#include <jedi/gdi.h>
#include <jedi/fnt.h>

EXTERN_C void _AAPI lblHide(TObjLabel *label)
{
	if(label && label->attr.usable){
		label->attr.usable = false;
		lblErase(label);
	}
}

EXTERN_C void _AAPI lblShow(TObjLabel *label)
{
	if(label && !label->attr.usable){
		label->attr.usable = true;
		lblDraw(label);
	}
}

EXTERN_C void _AAPI lblDraw(TObjLabel *label)
{
	if(label && label->attr.usable) {
		TDrawState ds;
		ds.transferMode= DSMODE_PAINT;
		TPalette palBack= {0, 0xff, 0xff, 0xff};
		TPalette palText= {0, 0x00, 0x00, 0x00};
		ds.backColor= (__u8) gdiRGBToIndex(0, palBack);
		ds.textColor= (__u8) gdiRGBToIndex(0, palText);
		ds.underlineMode= DSUNDERLINE_NONE;
		ds.fontId= label->fontId;
		ds.pFont= NULL;
		gdiDrawChars(0, label->text, strlen(label->text), label->pos.x, label->pos.y, &ds);
	}
}

EXTERN_C void _AAPI lblErase(TObjLabel *label)
{
	if(label && label->attr.usable) {
		TDrawState ds;
		ds.transferMode= DSMODE_PAINT;
		TPalette palBack= {0, 0xff, 0xff, 0xff};
		ds.foreColor= (__u8) gdiRGBToIndex(0, palBack);
		TRect rect;
		fntGetExtent(label->fontId, label->text, &rect);
		rect.Left()	= label->pos.x;
		rect.Top()	= label->pos.y;
		gdiFillRect(0, &rect, 0, &ds);
	}
}
