/*	formobj.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/13/0 06:36PM
	$Header: /cvsroot/jedi/ui/formobj.cxx,v 1.4 2000/10/04 03:28:32 tomyeh Exp $
	Purpose:	Form Functions related to Controls
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/form.h>
#include <lib/strutl.h>

///////////////////////////////////////////////////////////
EXTERN_C _err_t _JAPI frmAttachCtl(TForm* frm, __u16 objType, TObjPtr objPtr)
{
	ASSERT(frm && objPtr.ptr); //internal functin; not allowing...

#define ALLOC_FOBJ_NO	4 //must be 2^n
	if(!(frm->numObjs & (ALLOC_FOBJ_NO-1))){ //no zoom?
		TObjNode *p = (TObjNode*)_REALLOC(frm->pObjNodes,
				sizeof(TObjNode)*(frm->numObjs+ALLOC_FOBJ_NO));
		if(!p)
			return ERRS_OUTOFMEMORY;
		frm->pObjNodes = p;
	}

	frm->pObjNodes[frm->numObjs].objType	= objType;
	frm->pObjNodes[frm->numObjs].reserved	= 0;
	frm->pObjNodes[frm->numObjs++].objPtr	= objPtr;
	return 0;
}

EXTERN_C _err_t _JAPI frmDestroyCtl(TForm* frm, __u16 objIndex)
{
	if(!frm || objIndex>=frm->numObjs)
		return ERRS_PARAMERR;

	TObjNode* p = &frm->pObjNodes[objIndex];
	switch(p->objType){
	case FOBJ_CTL:
		_FREE(p->objPtr.ctl->text);
		break;

	case FOBJ_LABEL:
		_FREE(p->objPtr.label->text);
		break;

	case FOBJ_TITLE:
		_FREE(p->objPtr.title->text);
		break;
	}
	_FREE(p->objPtr.ptr);

	if(objIndex != --frm->numObjs)
		memmove(p, p+1, sizeof(TObjNode)*(frm->numObjs-objIndex));
	//Note: we don't resize here to have a better performance
	return 0;
}

///////////////////////////////////////////////////////////
EXTERN_C TObjTitle* _JAPI frmCreateTitle(TForm *p, const char *title)
{
	TObjPtr titlePtr;
	titlePtr.ptr = _CALLOC_T(TObjTitle);
	if(!titlePtr.ptr){
		return 0;
	}
	titlePtr.title->text = STRDUP(title);
	if (frmAttachCtl(p, FOBJ_TITLE, titlePtr)) {
		_FREE(titlePtr.ptr);
		return 0;
	}
	return titlePtr.title;
}

EXTERN_C TObjLabel* _AAPI _frmCreateLabel(TForm **ppFrm, __u16 id,
	const char* text, __s16 x, __s16 y, __s16 fontId)
{
	if(!ppFrm || !*ppFrm) return 0;

	TForm* frm = *ppFrm;
	TObjPtr objPtr;
	objPtr.label = _MALLOC_T(TObjLabel);
	if(!objPtr.label)
		return 0;
	if(frmAttachCtl(frm, FOBJ_LABEL, objPtr)){
		_FREE(objPtr.label);
		return 0;
	}

	objPtr.label->id		= id;
	objPtr.label->pos.x		= x;
	objPtr.label->pos.y		= y;
	objPtr.label->fontId	= fontId;
	objPtr.label->reserved	= 0;
	objPtr.label->attr.SetZeros();
	objPtr.label->text		= STRDUP(text);
	return objPtr.label;
}

EXTERN_C TObjCtl* _AAPI _frmCreateCtl(TForm **ppFrm, __u16 id, __s16 style,
	const char *text, __s16 x, __s16 y,	__s16 wd, __s16 hgh,
	__s16 fontId, __u8 group, bool leftAnchor)
{
	if(!ppFrm || !*ppFrm) return 0;

	TForm* frm = *ppFrm;
	TObjPtr objPtr;
	bool bSlider = style==OBJCTL_SLIDER || style==OBJCTL_FEEDBACKSLIDER;
	objPtr.ctl = (TObjCtl*)_CALLOC(1, bSlider ? sizeof(TObjSlider) : sizeof(TObjCtl));
	if(!objPtr.ctl)
		return 0;
	if(frmAttachCtl(frm, FOBJ_CTL, objPtr)){
		_FREE(objPtr.ctl);
		return 0;
	}

	objPtr.ctl->id				= id;
	objPtr.ctl->bounds.Left()	= x;
	objPtr.ctl->bounds.Top()	= y;
	objPtr.ctl->bounds.Width()	= wd;
	objPtr.ctl->bounds.Height()	= hgh;
	objPtr.ctl->style			= ((__u16)style)>OBJCTL_LAST ? (__s16)OBJCTL_LAST: style;
	objPtr.ctl->fontId			= fontId;
	objPtr.ctl->group			= group;
	objPtr.ctl->attr.on			= 1;
	if(leftAnchor)
		objPtr.ctl->attr.leftAnchor = 1;
		//Note: usable is not turned on

	if(!bSlider)
		objPtr.ctl->text		=  STRDUP(text);

	return objPtr.ctl;
}

///////////////////////////////////////////////////////////
EXTERN_C TObjNode* _JAPI frmGetObjNode(const TForm* frm, __u16 objIndex)
{
	return frm && objIndex<frm->numObjs ? frm->pObjNodes + objIndex: 0;
}

EXTERN_C __u16 _AAPI frmGetObjId(const TForm* frm, __u16 objIndex)
{
	if(!frm || objIndex>=frm->numObjs)
		return (__u16)-1;

	//Due to Palm's weird design, we have to use dirty switch here

	TObjPtr objPtr = frm->pObjNodes[objIndex].objPtr;
	switch(frm->pObjNodes[objIndex].objType){
	case FOBJ_BMP:
		return objPtr.bmp->resId;

	case FOBJ_TITLE:
	case FOBJ_LINE:
	case FOBJ_FRAME:
	case FOBJ_RECTANGLE:
		return (__u16)-1;

	default: //all others use the first half-word
		return objPtr.ctl->id;
	}
}

EXTERN_C __u16 _AAPI frmGetObjIndex(const TForm* frm, __u16 ctlId)
{
	if(!frm)
		return (__u16)-1;

	//Due to Palm's weird design, we have to use dirty switch here

	TObjNode *p = frm->pObjNodes;
	for(__u16 j=0; j<frm->numObjs; ++j, ++p)
		switch(p->objType){
		case FOBJ_BMP:
			if(p->objPtr.bmp->resId == ctlId)
				return j;
			break;

		case FOBJ_TITLE:
		case FOBJ_LINE:
		case FOBJ_FRAME:
		case FOBJ_RECTANGLE:
			break;

		default:
			if(p->objPtr.ctl->id == ctlId)
				return j;
			break;
		}

	return (__u16)-1;
}

///////////////////////////////////////////////////////////
EXTERN_C TRect* _JAPI frmGetObjBoundsPtr(const TForm *frm, __u16 objIndex, bool* bPtOnly)
{
	if(!frm || objIndex>=frm->numObjs)
		return 0;

	//Due to Palm's weird design, we have to use dirty switch here

	if(bPtOnly) *bPtOnly = false;

	TObjNode *p = &frm->pObjNodes[objIndex];
	switch(p->objType){
	case FOBJ_TITLE:
		return &p->objPtr.title->bounds;

	case FOBJ_GADGET:
		return &p->objPtr.gadget->bounds;

	case FOBJ_GRAFFITISTATE:
		if(bPtOnly) *bPtOnly = true;
		return (TRect*)&p->objPtr.grfState->pos;

	case FOBJ_SCROLLBAR:
		return &p->objPtr.scrollBar->bounds;

	case FOBJ_BMP:
	case FOBJ_LABEL:
		if(bPtOnly) *bPtOnly = true;
		//fall through

	case FOBJ_FIELD:
	case FOBJ_CTL:
	case FOBJ_LIST:
	case FOBJ_TABLE:
		return &p->objPtr.ctl->bounds;
	}
	return 0;
}

EXTERN_C void _AAPI frmGetObjPosition(const TForm *frm, __u16 objIndex, __s16 *x, __s16 *y)
{
	TRect *rc = frmGetObjBoundsPtr(frm, objIndex);
	if(rc){
		*x = rc->Left();
		*y = rc->Top();
	}
}

EXTERN_C void _AAPI frmSetObjPosition(TForm *frm, __u16 objIndex, __s16 x, __s16 y)
{
	TRect *rc = frmGetObjBoundsPtr(frm, objIndex);
	if(rc){
		rc->Left() = x;
		rc->Top()  = y;
	}
}

EXTERN_C void _AAPI frmGetObjBounds(const TForm *frm, __u16 objIndex, TRect* bounds)
{
	if(bounds){
		bool bPtOnly;
		TRect *rc = frmGetObjBoundsPtr(frm, objIndex, &bPtOnly);
		if(rc){
			bounds->Left() = rc->Left();
			bounds->Top()  = rc->Top();
			if(!bPtOnly){
				bounds->Width()  = rc->Width();
				bounds->Height() = rc->Height();
			}
		}
	}
}

EXTERN_C void _AAPI frmSetObjBounds(TForm *frm, __u16 objIndex, const TRect* bounds)
{
	if(bounds){
		bool bPtOnly;
		TRect *rc = frmGetObjBoundsPtr(frm, objIndex, &bPtOnly);
		if(rc){
			rc->Left() = bounds->Left();
			rc->Top() = bounds->Top();
			if(!bPtOnly){
				rc->Width() = bounds->Width();
				rc->Height() = bounds->Height();
			}
		}
	}
}

///////////////////////////////////////////////////////////
static char** _STDCALL frmGetLabelAddr(const TForm* frm, __u16 objIndex)
{
	TObjNode *p = frmGetObjNode(frm, objIndex);
	if(p)
		switch(p->objType){
		case FOBJ_CTL:
			return &p->objPtr.ctl->text;
		case FOBJ_LABEL:
			return &p->objPtr.label->text;
		case FOBJ_TITLE:
			return &p->objPtr.title->text;
		}

	return 0;
}

EXTERN_C const char* _AAPI frmGetLabel(const TForm* frm, __u16 objIndex)
{
	char** p = frmGetLabelAddr(frm, objIndex);
	return p ? *p : 0;
}

EXTERN_C void _AAPI frmSetLabel(const TForm* frm, __u16 objIndex, const char* text)
{
	strupd(frmGetLabelAddr(frm, objIndex), text);
}

///////////////////////////////////////////////////////////
EXTERN_C void _AAPI frmHideObj(TForm* frm, __u16 objIndex)
{
	TObjNode *p = frmGetObjNode(frm, objIndex);
	if(p)
		switch(p->objType){
		case FOBJ_CTL:
			ctlHide(p->objPtr.ctl);
			break;
		case FOBJ_LABEL:
			lblHide(p->objPtr.label);
			break;
		}
}

EXTERN_C void _AAPI frmShowObj(TForm* frm, __u16 objIndex)
{
	TObjNode *p = frmGetObjNode(frm, objIndex);
	if(p)
		switch(p->objType){
		case FOBJ_CTL:
			ctlShow(p->objPtr.ctl);
			break;
		case FOBJ_LABEL:
			lblShow(p->objPtr.label);
			break;
		}
}

///////////////////////////////////////////////////////////
EXTERN_C __s16 _AAPI frmGetCtlVal(const TForm* frm, __u16 objIndex)
{
	TObjNode *p = frmGetObjNode(frm, objIndex);
	return p && p->objType==FOBJ_CTL ? ctlGetVal(p->objPtr.ctl) : (__s16)0;
}

EXTERN_C void _AAPI frmSetCtlVal(const TForm* frm, __u16 objIndex, __s16 val)
{
	TObjNode *p = frmGetObjNode(frm, objIndex);
	if(p && p->objType==FOBJ_CTL)
		ctlSetVal(p->objPtr.ctl, val);
}

EXTERN_C __u16 _AAPI frmGetCtlGrpSel(const TForm* frm, __u8 grp)
{
	if(frm){
		TObjNode *p = frm->pObjNodes;
		for(int j=0; j<frm->numObjs; ++j, ++p)
			if(p->objType==FOBJ_CTL && p->objPtr.ctl->group==grp
					&& p->objPtr.ctl->attr.on)
				return p->objPtr.ctl->id;
	}
	return FRM_NO_SELECTED_CTL;
}

EXTERN_C void _AAPI frmSetCtlGrpSel(const TForm* frm, __u8 grp, __u16 ctlId)
{
	if(frm){
		TObjNode *p = frm->pObjNodes;
		for(int j=0; j<frm->numObjs; ++j, ++p)
			if(p->objType==FOBJ_CTL && p->objPtr.ctl->group==grp)
				ctlSetVal(p->objPtr.ctl, p->objPtr.ctl->id == ctlId);
	}
}
