/*	formevt.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/14/0 01:46PM
	$Header: /cvsroot/jedi/ui/formevt.cxx,v 1.5 2000/10/12 08:26:27 tomyeh Exp $
	Purpose:	Form and Control Event Handler
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/event.h>
#include <jedi/form.h>
#include <jedi/rct.h>

//////////////////////////////////////////////////////////
static struct TLastTap { //information about the last tap
	TForm	*frm;
	TRect	*bounds;
	TObjPtr	objPtr;
	__u16	objType;
	bool	bIn;
} s_lastTap;

static bool _STDCALL frmOnPenDown(TForm* frm, TEvent* in_evt)
{
	for(int j=0; j<frm->numObjs; ++j){
		bool bPtOnly;
		s_lastTap.bounds = frmGetObjBoundsPtr(frm, (__u16)j, &bPtOnly);
		if(!bPtOnly && s_lastTap.bounds &&
				rctPtInRect(in_evt->screenX, in_evt->screenY, s_lastTap.bounds)){
			TEvent evt;
			evtInitEvent(&evt);

			s_lastTap.objPtr  = frm->pObjNodes[j].objPtr;
			s_lastTap.objType = frm->pObjNodes[j].objType;

			switch(s_lastTap.objType){
			case FOBJ_CTL:
				evt.eType = EVT_CTLENTER;
				evt.data.ctlEnterExit.ctlId	= s_lastTap.objPtr.ctl->id;
				evt.data.ctlEnterExit.pCtl	= s_lastTap.objPtr.ctl;
				break;

			case FOBJ_TITLE:
				evt.eType = EVT_FRMTITLEENTER;
				evt.data.frm.frmId = frm->frmId;
				break;

			default:
				continue;
			}

			s_lastTap.frm = frm;
			s_lastTap.bIn = true;
			evtPushEvent(&evt);
			return true;
		}
	}
	s_lastTap.objPtr.ptr = 0;
	return false;
}

static bool _STDCALL frmOnPenMove(TForm* frm, TEvent* in_evt)
{
	if(!s_lastTap.objPtr.ptr || frm!=s_lastTap.frm)
		return false;

	bool bNowIn = rctPtInRect(in_evt->screenX, in_evt->screenY, s_lastTap.bounds);
	if(bNowIn ^ s_lastTap.bIn){//changed?
		s_lastTap.bIn = bNowIn;
		
		switch(s_lastTap.objType){
		case FOBJ_CTL:
			//not yet: draw
			break;
		}
	}
	//Note: eat all evt_penmove if tap
	return true;
}

static bool _STDCALL frmOnPenUp(TForm* frm, TEvent* in_evt)
{
	if(!s_lastTap.objPtr.ptr || frm!=s_lastTap.frm)
		return false;

	TEvent evt;
	evtInitEvent(&evt);

	bool bPushEvent = true;
	bool bNowIn = rctPtInRect(in_evt->screenX, in_evt->screenY, s_lastTap.bounds);

	switch(s_lastTap.objType){
	case FOBJ_CTL:
		evt.data.ctlSelect.ctlId = s_lastTap.objPtr.ctl->id;
		evt.data.ctlSelect.pCtl  = s_lastTap.objPtr.ctl;
		if(bNowIn){
			evt.eType = EVT_CTLSELECT;
			evt.data.ctlSelect.on		= s_lastTap.objPtr.ctl->attr.on;
			evt.data.ctlSelect.reserved	= 0;
			evt.data.ctlSelect.value	= 0; //not yet: slider
		}else{
			evt.eType = EVT_CTLEXIT;
		}
		break;

	case FOBJ_TITLE:
		if(bNowIn){
			evt.eType = EVT_FRMTITLESELECT;
			evt.data.frm.frmId = s_lastTap.frm->frmId;
		}else{
			bPushEvent = false;
		}
		break;

	default:
		ASSERT(0); //not possible
	}

	s_lastTap.objPtr.ptr = 0;
	if(bPushEvent) evtPushEvent(&evt);
	return bPushEvent;
}

static bool _STDCALL frmOnKeyDown(TForm* frm, TEvent* in_evt)
{
	if(frm->focus < frm->numObjs){
		TObjPtr objPtr = frm->pObjNodes[frm->focus].objPtr;
		switch(frm->pObjNodes[frm->focus].objType){
		case FOBJ_CTL:
			return ctlHandleEvent(objPtr.ctl, in_evt);
		}
	}
	return false;
}

EXTERN_C bool _AAPI frmHandleEvent(TForm* frm, TEvent* in_evt)
{
	if(!frm)
		return false;

	switch(in_evt->eType){
	case EVT_PENDOWN:
		return frmOnPenDown(frm, in_evt);

	case EVT_PENMOVE:
		return frmOnPenMove(frm, in_evt);

	case EVT_PENUP:
		return frmOnPenUp(frm, in_evt);

	case EVT_KEYDOWN:
		return frmOnKeyDown(frm, in_evt);

	case EVT_FRMCLOSE:
		frmDestroy(frm);
		return true;

	case EVT_FRMUPDATE:
		//ignore in_evt->data.frmUpdate.updateCode, see Palm API
		frmDraw(frm);
		return true;

	case EVT_CTLENTER:
	case EVT_CTLEXIT:
	case EVT_CTLSELECT:
	case EVT_CTLREPEAT:
		return ctlHandleEvent(in_evt->data.ctlEnterExit.pCtl, in_evt);
	}

	return false;
}

EXTERN_C bool _AAPI frmDispatchEvent(TEvent* in_evt)
{
	TForm *frm = 0;
	if(in_evt->eType>=EVT_FRMFIRST && in_evt->eType<=EVT_FRMLAST 
			&& in_evt->eType!=EVT_FRMSAVE)
		frm = frmFind(in_evt->data.frm.frmId);

	if(!frm) frm = g_pFrmActive;

	if(frm && frm->handler){
		AnakinUnlock();
		bool bHandled = (frm->handler)(in_evt);
		AnakinLock();
		if(bHandled)
			return bHandled;
	}

	return frmHandleEvent(frm, in_evt);
}

//////////////////////////////////////////////////////////
EXTERN_C bool _AAPI ctlHandleEvent(TObjCtl *ctl, TEvent *in_evt)
{
	if(!ctl || !in_evt)
		return false;

	switch(in_evt->eType){
	case EVT_CTLENTER:
		//not yet: EVT_REAPT for OBJCTL_REPEATINGBUTTON and OBJCTL_FEEDBACKSLIDER
		//not yet: draw
		return true;
	}

	return false;
}
