/*	form.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:	Henri Chen
	Create Date:	8/22/0 08:26PM
	$Header: /cvsroot/jedi/ui/form.cxx,v 1.33 2000/10/11 07:48:57 henrichen Exp $
	Purpose:	Form Functions
	Description:
	1. Modal vs. Modeless
		* Appearance: a modal dialog has a full-width titlebar with the title
		centered and with buttons from left to right along the bottom. Most
		modal dialogs should have an info button that provides additional help.
		* Behavior: the Find button doesn't work while a modal dialog 
		is being displayed.
	2. FrmDoDialog is documented to return the number of the tapped button,
	where the first button is 0. Actually, it returns the button ID of the
	tapped button.
	3. When you call  FrmDoDialog with a modal form, your event handler won't
	get a frmOpenEvent, and it doesn't have to call FrmDrawForm
	4. You'll need to inset the bounds of your modal form by at least two
	pixels in each direction.
	5. The Palm OS takes care of displaying the "i" button (only if the help ID
	is nonzero) and displaying the help text if the button is tapped.
	6. When you call  FrmDoDialog with a modal form, your event handler won't
	get a frmOpenEvent, and it doesn't have to call FrmDrawForm. Since your
	event handler won't be notified that the form is opening, any form
	initialization must be done before you call FrmDoDialog.
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/event.h>
#include <jedi/menu.h>
#include <jedi/bmp.h>
#include <jedi/form.h>
#include <jedi/rct.h>
#include <jedi/win.h>
#include <jedi/fnt.h>
#include <jedi/gdi.h>
#include <lib/strutl.h>
#include <lib/lcllink.h>

//////////////////////////////////////////////////////////
DECL_APPLINK(TFormEx, TForm, pFormExList)

TForm *g_pFrmActive;

//////////////////////////////////////////////////////////
EXTERN_C void _JAPI frmDrawIMark(TForm *pForm, TRect *bounds, bool bInvert)
{
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	ds.pattern= DSPATTERN_BLACK;
	TPalette palBack= {0, 0xff, 0xff, 0xff};
	TPalette palText= {0, 0x00, 0x00, 0x00};
	ds.textColor= (__u8) gdiRGBToIndex(&pForm->window, bInvert ? palBack : palText);
	ds.backColor= (__u8) gdiRGBToIndex(&pForm->window, bInvert ? palText : palBack);
	ds.underlineMode= DSUNDERLINE_NONE;
	ds.fontId= FONT_TITLE;
	ds.pFont= NULL;

	//?? 20000915, Henri Chen: This could be changed to draw an icon
	gdiDrawCenterText(&pForm->window, "i", bounds, 3, &ds);
}
	
EXTERN_C void _JAPI frmDrawTitle(TForm *pForm, TObjTitle *p)
{
	if (!p->text) return;
	
	TDrawState ds;
	ds.transferMode= DSMODE_PAINT;
	TPalette palFore= {0, 0xff, 0xff, 0xff};
	TPalette palBack= {0, 0x00, 0x00, 0x00};
	ds.foreColor= (__u8) gdiRGBToIndex(&pForm->window, palFore);
	ds.backColor= (__u8) gdiRGBToIndex(&pForm->window, palBack);
	ds.textColor= ds.foreColor;
	ds.underlineMode= DSUNDERLINE_NONE;
	ds.fontId= FONT_TITLE;
	ds.pFont= NULL;

	int left= p->bounds.Left();
	int top= p->bounds.Top();
	int right= left + p->bounds.Width();
	int bottom= top + p->bounds.Height();

	//draw the title
	if (!pForm->window.flags.modal) {
		ds.pattern= DSPATTERN_WHITE;
		gdiLine(&pForm->window, left, bottom-1, 
			pForm->window.bounds.Right(), bottom-1, &ds);
		gdiLine(&pForm->window, left, bottom-2, 
			pForm->window.bounds.Right(), bottom-2, &ds);
		ds.pattern= DSPATTERN_BLACK;
		gdiDrawCenterText(&pForm->window, p->text, &p->bounds, 1, &ds);
	}
	else {
		gdiDrawCenterText(&pForm->window, p->text, &p->bounds, 0, &ds);
		//draw the i mark
		if (pForm->resIdHelp != 0) {
			TRect bounds={{(__s16)(right-FRM_IMARK_XOFS-FRM_IMARK_SIZE), 
							(__s16)(top+FRM_IMARK_YOFS)},{FRM_IMARK_SIZE, FRM_IMARK_SIZE}};
			frmDrawIMark(pForm, &bounds, false);
		}
	}
}

//?? 20000914, Henri Chen: more control to be drawn
static void _JAPI frmDrawObjs(TForm* p)
{
	TObjNode *pObjNode= p->pObjNodes;
	for (int i= 0; i < p->numObjs; ++i, ++pObjNode) {
		switch(pObjNode->objType) {
			//FOBJ_FIELD
			case FOBJ_CTL:
				ctlDraw(pObjNode->objPtr.ctl);
				break;
			//FOBJ_LIST
			//FOBJ_TABLE
			//FOBJ_BMP
			//FOBJ_LINE
			//FOBJ_FRAME
			//FOBJ_RECTANGLE
			case FOBJ_LABEL:
				lblDraw(pObjNode->objPtr.label);
				break;
			case FOBJ_TITLE:
				frmDrawTitle(p, pObjNode->objPtr.title);
				break;
			//FOBJ_POPUP
			//FOBJ_GRAFFITISTATE,
			//FOBJ_GADGET
			//FOBJ_SCROLLBAR
			default:
				TRACE("Object Type(%d) is not supported yet!\n", pObjNode->objType);
		}
	}
}

EXTERN_C void _AAPI frmDraw(TForm* p)
{
	if(!p) return;

	p->attr.drawn = 1; //denote it is drawn (i.e., visible in Palm)
	
	if (p->attr.saveBehind) {
		__u16 err;
		p->bitsBehindForm= winSaveBits(&p->window.bounds, &err);
	}
	//erase the background
	TRect r;
	winGetFrameRect(p->window.frameType, &p->window.bounds, &r);

	TDrawState ds;
	TPalette pal	= {0, 0xff, 0xff, 0xff};
	ds.backColor	= (__u8) gdiRGBToIndex(&p->window, pal);
	ds.transferMode	= DSMODE_PAINT;
	ds.pattern		= DSPATTERN_WHITE;
	gdiFillRect(&p->window, &r, 0, &ds);
	
	//draw the frame
	pal.r= pal.g= pal.b= 0;
	ds.foreColor	= (__u8) gdiRGBToIndex(&p->window, pal);
	ds.pattern		= DSPATTERN_BLACK;
	winDrawFrame(p->window.frameType, &p->window.bounds, &ds);
	
	//draw the controls
	frmDrawObjs(p);
	
	//force painting
	fbUpdate(&r);
	
}

static bool _STDCALL frmTryRestore(TForm* p)
{
	if(p->attr.saveBehind && p->bitsBehindForm){
		winRestoreBits(p->bitsBehindForm, p->window.bounds.Left(), p->window.bounds.Top());
		return true;
	}
	return false;
}

EXTERN_C void _AAPI frmErase(TForm* p)
{
	if(!frmTryRestore(p)){
		TDrawState ds;
		TPalette palFore= {0, 0xff, 0xff, 0xff};
		ds.backColor= (__u8) gdiRGBToIndex(&p->window, palFore);
		winErase(&p->window, &ds);
	}
}

//////////////////////////////////////////////////////////
static bool CompareFormId(TForm* frm, int frmId)
{
	return frm->frmId == frmId;
}

EXTERN_C TForm* _AAPI frmFind(__u16 frmId)
{
	return TFormEx::Find(&CompareFormId, frmId);
}

static bool CompareFormObj(TForm* frm1, int frm2)
{
	return frm1 == (TForm*)frm2;
}

EXTERN_C bool _AAPI frmValid(const TForm* frm)
{
	return TFormEx::Find(&CompareFormObj, (int)frm)!=0;
}

EXTERN_C TForm* _AAPI frmGetFirstForm(void)
{
	TFormEx *frmEx = (TFormEx*)GetAppLocal()->pFormExList;
	return frmEx ? ToTForm(frmEx): 0;
}

//////////////////////////////////////////////////////////
EXTERN_C void _AAPI frmSetMenu(TForm* p, __u16 resIdMenu)
{
	if(!p) return;

	p->resIdMenu = resIdMenu;

	if(p == g_pFrmActive)
		mnuDeleteActiveCache();
}

EXTERN_C void _AAPI frmSetActive(TForm* p)
{
	if(p != g_pFrmActive){
		g_pFrmActive	= p;
		winSetActive(p ? &p->window: 0);
		if(p)
			ToTFormEx(p)->MoveToTop(); //as topmost of list

		mnuDeleteActiveCache();
	}
}

EXTERN_C _err_t _AAPI frmActiveState(TFormActiveState *state, bool bSave)
{
	if(!state)
		return ERRS_PARAMERR;

	if(bSave){
		state->cbSize = sizeof(TFormActiveState);
		state->frmIdActive = g_pFrmActive ? g_pFrmActive->frmId: (__u16)0;
	}else{
		if(state->cbSize != sizeof(TFormActiveState))
			return ERRS_PARAMERR;
		frmSetActive(state->frmIdActive ? frmFind(state->frmIdActive): 0);
	}
	return 0;
}

//////////////////////////////////////////////////////////
EXTERN_C void _AAPI frmUpdate(__u16 frmId, __u16 updateCode)
{
	TEvent evt;
	evtInitEvent(&evt);
	evt.eType						= EVT_FRMUPDATE;
	evt.data.frmUpdate.frmId		= frmId;
	evt.data.frmUpdate.updateCode	= updateCode;
	evtPushEvent(&evt);
}

inline void _STDCALL SetFormEvent(TEvent *evt, __u16 frmId, __u16 eType)
{
	evtInitEvent(evt);
	evt->eType			= eType;
	evt->data.frm.frmId	= frmId;
}

static void _STDCALL PushFormEvent(__u16 frmId, __u16 eType)
{
	TEvent evt;
	SetFormEvent(&evt, frmId, eType);
	evtPushEvent(&evt);
}

EXTERN_C void _AAPI frmGoto(__u16 frmId)
{
	if(g_pFrmActive)
		PushFormEvent(g_pFrmActive->frmId, EVT_FRMCLOSE);

	frmPopup(frmId);
}

EXTERN_C void _AAPI frmPopup(__u16 frmId)
{
	if(frmId){
		PushFormEvent(frmId, EVT_FRMLOAD);
		PushFormEvent(frmId, EVT_FRMOPEN);
	}
}

EXTERN_C void _AAPI frmReturn(__u16 frmId)
{
	if(g_pFrmActive)
		frmDestroy(g_pFrmActive); //not sending EVT_FRMCLOSE, see Palm API

	TForm* frm = frmId ? frmFind(frmId): 0;
	if(!frm) frm = frmGetFirstForm();
	frmSetActive(frm);
}

//////////////////////////////////////////////////////////
static void SendFormCloseEvent(TForm* frm, TAppLocal*)
{
	TEvent evt;
	SetFormEvent(&evt, frm->frmId, EVT_FRMCLOSE);
	frmHandleEvent(frm, &evt);
	//Note: we don't push EVT_FRMCLOSE because frmCloseAll is called
	//after the event loop
}

EXTERN_C void _AAPI frmCloseAll(void)
{
	TFormEx::Apply(SendFormCloseEvent, 0);
}

EXTERN_C void _AAPI frmSaveAll(void)
{
	PushFormEvent(0, EVT_FRMSAVE);
		//Note: strange Palm API: EVT_FRMSAVE does not carry frmId,
		//so, unlike frmCloseAll, we don't need to send it for each form
}

//////////////////////////////////////////////////////////
EXTERN_C TForm* _AAPI frmCreateRsc(__u16 resIdForm)
{
	//?? 20000922, Henri Chen: not yet, because the dmXXX() is not ready yet!
	//non-modal case
	return frmCreate(resIdForm, "StarterApp", 0, 0, (__s16)SCREEN_WIDTH, (__s16)SCREEN_HEIGHT, false, 0, 0, 0); //not yet
	//modal case
//	return frmCreate(resIdForm, "Address Entry Details", 2, 2, (__s16)(SCREEN_WIDTH-4), (__s16)(SCREEN_HEIGHT-4), true, 0, 1, 0); //not yet
}

static void _STDCALL frmCalcTitleExtent(TForm *frm)
{
	ASSERT(frm && frm->pObjNodes && frm->pObjNodes[0].objType==FOBJ_TITLE);

	TObjTitle *p = frm->pObjNodes[0].objPtr.title;
	fntGetExtent(FONT_TITLE, p->text, &p->bounds);
	if(p->text){
		p->bounds.Left()	= frm->window.bounds.Left();
		p->bounds.Top()		= frm->window.bounds.Top();
		if(frm->window.flags.modal){
			p->bounds.Width()   = frm->window.bounds.Width();
			p->bounds.Height() += FRM_MTITLE_YOFS*2;
		}else{
			p->bounds.Width()  += FRM_TITLE_XOFS*2;
			p->bounds.Height() += FRM_TITLE_YOFS*2;
		}
	}
}

EXTERN_C TForm* _AAPI frmCreate(__u16 frmId, const char* title, __s16 x, __s16 y,
		__s16 wd, __s16 hgh, bool modal, 
		__u16 btnIdDefault, __u16 resIdHelp, __u16 resIdMenu)
{
	TFormEx* p = _CALLOC_T(TFormEx);
	if(!p)
		return 0;

	p->frmId			= frmId;
	p->btnIdDefault		= btnIdDefault;
	p->resIdHelp		= resIdHelp;
	p->resIdMenu		= resIdMenu;

	if (!frmCreateTitle(ToTForm(p), title)) {
		_FREE(p);
		return 0;
	}

	TRect bounds;
	bounds.Left()		= x;
	bounds.Top()		= y;
	bounds.Width()		= wd;
	bounds.Height()		= hgh;
	winBindAndInit(&p->window, g_pBmpScrn, &bounds);
	p->window.flags.modal = modal;
	p->window.frameType	= (__u16)(modal ? WINFRAME_DIALOG: WINFRAME_NO);

	p->Link();
	frmCalcTitleExtent(ToTForm(p));
	return p;
}

static void DestroyForm(TForm* frm, TAppLocal* app)
{
	if(!frm) return;

	if(frm==g_pFrmActive){
		frmErase(frm);
		frmSetActive(0);
	}else
		frmTryRestore(frm);

	for(int j=frm->numObjs; --j>=0;)
		frmDestroyCtl(frm, (__u16)j);
	_FREE(frm->pObjNodes);

	winDestroy(&frm->window, false);

	TFormEx* frmEx = ToTFormEx(frm);
	frmEx->Unlink(app);
	_FREE(frmEx);
}

EXTERN_C void _AAPI frmDestroy(TForm* frm)
{
	DestroyForm(frm, 0);
}

EXTERN_C void _JAPI frmAppCleanup(TAppLocal* app)
{
#ifndef NDEBUG
	TFormEx::Dump("Form Leakage");
#endif
	TFormEx::Apply(DestroyForm, app);
}

//////////////////////////////////////////////////////////
EXTERN_C bool _AAPI frmPointInTitle(const TForm* frm, __s16 x, __s16 y)
{
	if(!frm) return false;

	ASSERT(frm->pObjNodes && frm->pObjNodes[0].objType==FOBJ_TITLE);

	return rctPtInRect(x, y, &frm->pObjNodes[0].objPtr.title->bounds);
}

EXTERN_C void _AAPI frmSetTitle(TForm* frm, const char* text)
{
	if(frm){
		strupd(&frm->pObjNodes[0].objPtr.title->text, text);
		frmCalcTitleExtent(frm);

		if(frm==g_pFrmActive)
			frmDrawTitle(frm, frm->pObjNodes[0].objPtr.title);
	}
}
