/*	ctl.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/13/0 10:21AM
	$Header: /cvsroot/jedi/ui/ctl.cxx,v 1.4 2000/09/15 12:56:24 tomyeh Exp $
	Purpose:	Controls (FOBJ_CTL)
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/rct.h>
#include <jedi/form.h>
#include <jedi/event.h>
#include <lib/strutl.h>

//////////////////////////////////////////////////////////
EXTERN_C bool _AAPI ctlValidatePtr(TObjCtl *ctl)
{
	return ctl && !ctl->reserved && !ctl->attr.reserved;
}

EXTERN_C void _AAPI ctlSetLabel(TObjCtl *ctl, const char *text)
{
	if(ctl)
		strupd(&ctl->text, text);
}

EXTERN_C void _AAPI ctlHide(TObjCtl *ctl)
{
	if(ctl && ctl->attr.usable){
		ctl->attr.usable = false;
		ctlErase(ctl);
	}
}

EXTERN_C void _AAPI ctlShow(TObjCtl *ctl)
{
	if(ctl && !ctl->attr.usable){
		ctl->attr.usable = true;
		ctlDraw(ctl);
	}
}

EXTERN_C void _AAPI ctlDraw(TObjCtl *ctl)
{
	if(ctl){
		//not yet; draw
	}
}

EXTERN_C void _AAPI ctlErase(TObjCtl *ctl)
{
	if(ctl){
		//not yet; draw
	}
}

EXTERN_C void _AAPI ctlHit(const TObjCtl *ctl)
{
	if(ctl){
		TEvent evt;
		evtInitEvent(&evt);

		evt.eType = EVT_CTLSELECT;
		evt.data.ctlSelect.ctlId	= ctl->id;
		evt.data.ctlSelect.pCtl		= (TObjCtl*)ctl;
		evt.data.ctlSelect.on		= ctl->attr.on;
		evt.data.ctlSelect.reserved	= 0;
		evt.data.ctlSelect.value	= 0; //not yet: slider
	}
}

EXTERN_C __s16 _AAPI ctlGetVal(const TObjCtl *ctl)
{
	return ctl ?
		ctl->style==OBJCTL_SLIDER || ctl->style==OBJCTL_FEEDBACKSLIDER ?
			((TObjSlider*)ctl)->value: ctl->attr.on: (__s16)0;
}

EXTERN_C void  _AAPI ctlSetVal(TObjCtl *ctl, __s16 val)
{
	if(ctl){
		bool bRedraw = false;
		if(ctl->style==OBJCTL_SLIDER || ctl->style==OBJCTL_FEEDBACKSLIDER){
			if(val<((TObjSlider*)ctl)->minValue) val = ((TObjSlider*)ctl)->minValue;
			if(val>((TObjSlider*)ctl)->maxValue) val = ((TObjSlider*)ctl)->maxValue;
			if(val != ((TObjSlider*)ctl)->value){
				((TObjSlider*)ctl)->value = val;
				bRedraw = true;
			}
		}else{
			if((val && !ctl->attr.on) || (!val && ctl->attr.on)){
				ctl->attr.on = val!=0;
				bRedraw = true;
			}
		}
		if(bRedraw && ctl->attr.usable){
			ctlErase(ctl);
			ctlDraw(ctl);
		}
	}
}
