/*	tvmfile.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/10/4 09:52AM
	$Header: $
	Purpose:	
	Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <stdio.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/file.h>

//////////////////////////////////////////////////////////////////
// file porting layer
EXTERN_C _hfile_t _JAPI jdbOpenFile(const char *filename, int mode)
{
	int access= 0;
	if ((mode & MODE_READONLY) != 0)access|= O_RDONLY;
	if ((mode & MODE_WRITE) != 0) 	access|= O_RDWR;
	if ((mode & MODE_CREATE) != 0)	access|= O_CREAT | O_WRONLY | O_EXCL;
	
	return ::open(filename, access);
}

EXTERN_C _hfind_t _JAPI jdbFindFirstFile(const char *name, TFindData *fd)
{
	char* buf= (char*) alloca(strlen(name)+4);
	strcpy(buf, "ls ");
	strcat(buf, name);
	_hfind_t hf= popen(buf, "r");

	if (!hf) jdbFindNextFile(hf, fd);
	return hf;
}

EXTERN_C BOOL _JAPI jdbFindNextFile(_hfind_t hfind, TFindData *fd)
{
	ASSERT(	hfind );

	char *result= fgets(fd->filename, sizeof(fd->filename), hfind);
	if (result) {
		struct stat st;
		stat(fd->filename, &st);
		if (S_ISREG(st.st_mode)) fd->attributes|= FILE_REG;
		if (S_ISDIR(st.st_mode)) fd->attributes|= FILE_DIR;
	}
	return result != NULL;
}
