/*	main.cxx

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	6/12/0 12:29PM
$Header: /cvsroot/jedi/tvm/main.cxx,v 1.8 2000/10/11 09:22:52 tomyeh Exp $
Purpose:	Startup of tvm & ecosvm
Description:
	It calls cyg_user_start after initialization

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/event.h>

////////////////////////////////////////////////////////
const struct TPenBtnInfo g_penBtnList[PEN_BTN_NO] = {
	{{{ 27, 206}, {18, 14}}, CC_KEYBOARDALPHA,		0, KM_COMMAND},
	{{{115, 206}, {18, 14}}, CC_KEYBOARDNUMERIC,	0, KM_COMMAND},
	{{{  0, 164}, {27, 28}}, CC_LAUNCH,			0, KM_COMMAND},
	{{{  0, 192}, {27, 28}}, CC_MENU,				0, KM_COMMAND},
	{{{133, 164}, {27, 28}}, CC_CALC,				0, KM_COMMAND},
	{{{133, 192}, {27, 28}}, CC_FIND,				0, KM_COMMAND}
};

EXTERN_C int main(int argc, char **argv)
{
	int nRet = 255;
	if(tvmInit(evtOnHwNotify, abort)){
		JediStart(argc>1 ? argv[1]: 0);

		if(tvmStart())
			nRet = 0; //ok

		for(int j=0; g_listApp && ++j<32;) //at most about 3 sec
			tvmSleep(10);

		JediStop();
	}
	return nRet; //failed
}

#ifndef NDEBUG
DEF_SYSCLEANUP(MCheck, _MCHECK())
#endif
